#version unofficial Megapov 0.7;

//////////////////////////////////////

       
#include "textures.inc"

#declare ICP35_white_3 = texture {
    finish {
        ambient 0.10
        diffuse 0.90
        phong 0.07
        phong_size 2.1
    }
    pigment { rgb <1.000, 1.000, 1.000> }
}

#declare ICP35_black_2 = texture {
    finish {
        ambient 0.10
        diffuse 0.90
        phong 0.07
        phong_size 2.1
        metallic
    }
    pigment { rgb <0.000, 0.000, 0.000> }
}

#declare ICP35_orangish = texture {
    finish {
        ambient 0.10
        diffuse 0.90
        phong 0.07
        phong_size 2.1
        metallic
    }
    pigment { rgb <1.000, 0.122, 0.000> }
}

#declare CUSTOM_TUBE_bl = texture {
    finish {
        ambient 0.10
        diffuse 0.90
        phong 0.09
        phong_size 2.8
        metallic
    }
    pigment { rgb <0.000, 0.000, 0.000> }
}

#declare AXIS_black_4 = texture {
    finish {
        ambient 0.10
        diffuse 0.90
        phong 0.28
        phong_size 8.4
        metallic
    }
    pigment { rgb <0.000, 0.000, 0.000> }
}

//   Object    CenterX    CenterY    CenterZ    LengthX    LengthY    LengthZ
// ---------- ---------- ---------- ---------- ---------- ---------- ----------
// ICP35          186.00      66.63      25.12     137.26     161.10      68.03
// CUSTOM_T       155.61     -36.63      29.42      28.58      56.94      25.00
// CUSTOM7        216.39     -36.63      29.42      28.58      56.94      25.00
// CUSTOM6        143.65       9.54     -14.92      84.33      82.76      13.53
// CUSTOM5        149.94     105.96     -14.92      71.55      79.08      13.53
// CUSTOM4        131.08      76.34     -15.73     106.45      40.13      16.24
// CUSTOM3        218.11     115.76     -14.92      60.82      88.29      13.53
// CUSTOM2        244.79      55.77     -15.73     111.74      27.41      16.24
// CUSTOM1        230.35      14.04     -14.92      84.33      82.76      13.53
// AXIS           187.00      63.45      17.28     120.96     126.90      59.49







#declare marienkaefer = union {
/* Object 'AXIS' */
union {
	smooth_triangle { <189.4200, 0.0000, -9.0854>, <-0.064, 0.144, 0.987>, <186.8790, 0.0000, -9.1979>, <0.002, 0.132, 0.991>, <186.3950, 13.5000, -10.9979>, <0.002, 0.098, 0.995> }
	smooth_triangle { <199.1000, 13.5000, -10.4354>, <0.057, -0.117, -0.991>, <186.3950, 13.5000, -10.9979>, <-0.002, -0.097, -0.995>, <189.4200, 0.0000, -9.0854>, <0.044, -0.130, -0.990> }
	smooth_triangle { <193.4130, 0.0000, -8.7479>, <-0.261, 0.496, 0.828>, <189.4200, 0.0000, -9.0854>, <-0.064, 0.144, 0.987>, <199.1000, 13.5000, -10.4354>, <-0.071, 0.098, 0.993> }
	smooth_triangle { <219.0650, 13.5000, -8.7479>, <0.204, -0.357, -0.911>, <199.1000, 13.5000, -10.4354>, <0.057, -0.117, -0.991>, <193.4130, 0.0000, -8.7479>, <0.083, -0.158, -0.984> }
	smooth_triangle { <194.3205, 0.0000, -8.0729>, <-0.425, 0.876, 0.228>, <193.4130, 0.0000, -8.7479>, <-0.261, 0.496, 0.828>, <219.0650, 13.5000, -8.7479>, <-0.363, 0.468, 0.806> }
	smooth_triangle { <223.6025, 13.5000, -5.3729>, <0.483, -0.772, -0.413>, <219.0650, 13.5000, -8.7479>, <0.204, -0.357, -0.911>, <194.3205, 0.0000, -8.0729>, <0.395, -0.750, -0.531> }
	smooth_triangle { <193.7155, 0.0000, -5.5979>, <-0.373, 0.910, -0.180>, <194.3205, 0.0000, -8.0729>, <-0.425, 0.876, 0.228>, <223.6025, 13.5000, -5.3729>, <-0.603, 0.780, 0.165> }
	smooth_triangle { <220.5775, 13.5000, 7.0021>, <0.483, -0.857, 0.178>, <223.6025, 13.5000, -5.3729>, <0.483, -0.772, -0.413>, <193.7155, 0.0000, -5.5979>, <0.409, -0.907, 0.100> }
	smooth_triangle { <192.3240, 0.0000, -3.7979>, <-0.279, 0.906, -0.318>, <193.7155, 0.0000, -5.5979>, <-0.373, 0.910, -0.180>, <220.5775, 13.5000, 7.0021>, <-0.535, 0.793, -0.291> }
	smooth_triangle { <213.6200, 13.5000, 16.0022>, <0.377, -0.853, 0.361>, <220.5775, 13.5000, 7.0021>, <0.483, -0.857, 0.178>, <192.3240, 0.0000, -3.7979>, <0.334, -0.906, 0.258> }
	smooth_triangle { <189.8435, 0.0000, -2.3354>, <-0.138, 0.900, -0.413>, <192.3240, 0.0000, -3.7979>, <-0.279, 0.906, -0.318>, <213.6200, 13.5000, 16.0022>, <-0.388, 0.785, -0.484> }
	smooth_triangle { <201.2175, 13.5000, 23.3148>, <0.217, -0.845, 0.488>, <213.6200, 13.5000, 16.0022>, <0.377, -0.853, 0.361>, <189.8435, 0.0000, -2.3354>, <0.221, -0.900, 0.376> }
	smooth_triangle { <187.0605, 0.0000, -1.9978>, <0.006, 0.894, -0.447>, <189.8435, 0.0000, -2.3354>, <-0.138, 0.900, -0.413>, <201.2175, 13.5000, 23.3148>, <-0.172, 0.774, -0.609> }
	smooth_triangle { <187.3025, 13.5000, 25.0023>, <0.026, -0.836, 0.548>, <201.2175, 13.5000, 23.3148>, <0.217, -0.845, 0.488>, <187.0605, 0.0000, -1.9978>, <0.054, -0.893, 0.446> }
	smooth_triangle { <183.9750, 0.0000, -2.4479>, <0.132, 0.899, -0.418>, <187.0605, 0.0000, -1.9978>, <0.006, 0.894, -0.447>, <187.3025, 13.5000, 25.0023>, <0.028, 0.766, -0.643> }
	smooth_triangle { <171.8750, 13.5000, 22.7522>, <-0.125, -0.840, 0.529>, <187.3025, 13.5000, 25.0023>, <0.026, -0.836, 0.548>, <183.9750, 0.0000, -2.4479>, <-0.065, -0.892, 0.447> }
	smooth_triangle { <181.5550, 0.0000, -3.6854>, <0.277, 0.910, -0.308>, <183.9750, 0.0000, -2.4479>, <0.132, 0.899, -0.418>, <171.8750, 13.5000, 22.7522>, <0.214, 0.775, -0.594> }
	smooth_triangle { <159.7750, 13.5000, 16.5647>, <-0.299, -0.854, 0.426>, <171.8750, 13.5000, 22.7522>, <-0.125, -0.840, 0.529>, <181.5550, 0.0000, -3.6854>, <-0.198, -0.900, 0.387> }
	smooth_triangle { <180.4055, 0.0000, -5.4854>, <0.380, 0.909, -0.172>, <181.5550, 0.0000, -3.6854>, <0.277, 0.910, -0.308>, <159.7750, 13.5000, 16.5647>, <0.434, 0.795, -0.424> }
	smooth_triangle { <154.0275, 13.5000, 7.5646>, <-0.456, -0.856, 0.244>, <159.7750, 13.5000, 16.5647>, <-0.299, -0.854, 0.426>, <180.4055, 0.0000, -5.4854>, <-0.353, -0.908, 0.226> }
	smooth_triangle { <179.6795, 0.0000, -7.9604>, <0.428, 0.872, 0.239>, <180.4055, 0.0000, -5.4854>, <0.380, 0.909, -0.172>, <154.0275, 13.5000, 7.5646>, <0.566, 0.790, -0.235> }
	smooth_triangle { <150.3975, 13.5000, -4.8104>, <-0.531, -0.843, -0.090>, <154.0275, 13.5000, 7.5646>, <-0.456, -0.856, 0.244>, <179.6795, 0.0000, -7.9604>, <-0.405, -0.906, 0.119> }
	smooth_triangle { <180.6475, 0.0000, -8.6354>, <0.273, 0.487, 0.830>, <179.6795, 0.0000, -7.9604>, <0.428, 0.872, 0.239>, <150.3975, 13.5000, -4.8104>, <0.588, 0.698, 0.410> }
	smooth_triangle { <155.2375, 13.5000, -8.1854>, <-0.360, -0.475, -0.803>, <150.3975, 13.5000, -4.8104>, <-0.531, -0.843, -0.090>, <180.6475, 0.0000, -8.6354>, <-0.395, -0.724, -0.566> }
	smooth_triangle { <184.5195, 0.0000, -9.0854>, <0.114, 0.181, 0.977>, <180.6475, 0.0000, -8.6354>, <0.273, 0.487, 0.830>, <155.2375, 13.5000, -8.1854>, <0.256, 0.246, 0.935> }
	smooth_triangle { <174.5975, 13.5000, -10.4354>, <-0.081, -0.116, -0.990>, <155.2375, 13.5000, -8.1854>, <-0.360, -0.475, -0.803>, <184.5195, 0.0000, -9.0854>, <-0.080, -0.158, -0.984> }
	smooth_triangle { <184.5195, 0.0000, -9.0854>, <-0.080, -0.158, -0.984>, <186.8790, 0.0000, -9.1979>, <-0.047, -0.134, -0.990>, <174.5975, 13.5000, -10.4354>, <-0.081, -0.116, -0.990> }
	smooth_triangle { <174.5975, 13.5000, -10.4354>, <0.081, 0.110, 0.991>, <186.3950, 13.5000, -10.9979>, <0.002, 0.098, 0.995>, <186.8790, 0.0000, -9.1979>, <0.002, 0.132, 0.991> }
	smooth_triangle { <199.1000, 13.5000, -10.4354>, <-0.071, 0.098, 0.993>, <186.3950, 13.5000, -10.9979>, <0.002, 0.098, 0.995>, <186.1669, 27.0000, -11.8462>, <0.002, 0.045, 0.999> }
	smooth_triangle { <203.6617, 27.0000, -11.0716>, <0.057, -0.055, -0.997>, <186.1669, 27.0000, -11.8462>, <-0.002, -0.045, -0.999>, <199.1000, 13.5000, -10.4354>, <0.057, -0.117, -0.991> }
	smooth_triangle { <219.0650, 13.5000, -8.7479>, <-0.363, 0.468, 0.806>, <199.1000, 13.5000, -10.4354>, <-0.071, 0.098, 0.993>, <203.6617, 27.0000, -11.0716>, <-0.071, 0.045, 0.996> }
	smooth_triangle { <231.1535, 27.0000, -8.7479>, <0.244, -0.204, -0.948>, <203.6617, 27.0000, -11.0716>, <0.057, -0.055, -0.997>, <219.0650, 13.5000, -8.7479>, <0.204, -0.357, -0.911> }
	smooth_triangle { <223.6025, 13.5000, -5.3729>, <-0.603, 0.780, 0.165>, <219.0650, 13.5000, -8.7479>, <-0.363, 0.468, 0.806>, <231.1535, 27.0000, -8.7479>, <-0.418, 0.257, 0.871> }
	smooth_triangle { <237.4017, 27.0000, -4.1005>, <0.679, -0.536, -0.502>, <231.1535, 27.0000, -8.7479>, <0.244, -0.204, -0.948>, <223.6025, 13.5000, -5.3729>, <0.483, -0.772, -0.413> }
	smooth_triangle { <220.5775, 13.5000, 7.0021>, <-0.535, 0.793, -0.291>, <223.6025, 13.5000, -5.3729>, <-0.603, 0.780, 0.165>, <237.4017, 27.0000, -4.1005>, <-0.837, 0.525, 0.155> }
	smooth_triangle { <233.2362, 27.0000, 12.9399>, <0.728, -0.627, 0.279>, <237.4017, 27.0000, -4.1005>, <0.679, -0.536, -0.502>, <220.5775, 13.5000, 7.0021>, <0.483, -0.857, 0.178> }
	smooth_triangle { <213.6200, 13.5000, 16.0022>, <-0.388, 0.785, -0.484>, <220.5775, 13.5000, 7.0021>, <-0.535, 0.793, -0.291>, <233.2362, 27.0000, 12.9399>, <-0.745, 0.523, -0.414> }
	smooth_triangle { <223.6558, 27.0000, 25.3330>, <0.561, -0.619, 0.549>, <233.2362, 27.0000, 12.9399>, <0.728, -0.627, 0.279>, <213.6200, 13.5000, 16.0022>, <0.377, -0.853, 0.361> }
	smooth_triangle { <201.2175, 13.5000, 23.3148>, <-0.172, 0.774, -0.609>, <213.6200, 13.5000, 16.0022>, <-0.388, 0.785, -0.484>, <223.6558, 27.0000, 25.3330>, <-0.532, 0.512, -0.674> }
	smooth_triangle { <206.5775, 27.0000, 35.4025>, <0.314, -0.607, 0.730>, <223.6558, 27.0000, 25.3330>, <0.561, -0.619, 0.549>, <201.2175, 13.5000, 23.3148>, <0.217, -0.845, 0.488> }
	smooth_triangle { <187.3025, 13.5000, 25.0023>, <0.028, 0.766, -0.643>, <201.2175, 13.5000, 23.3148>, <-0.172, 0.774, -0.609>, <206.5775, 27.0000, 35.4025>, <-0.229, 0.499, -0.836> }
	smooth_triangle { <187.4166, 27.0000, 37.7262>, <0.032, -0.593, 0.805>, <206.5775, 27.0000, 35.4025>, <0.314, -0.607, 0.730>, <187.3025, 13.5000, 25.0023>, <0.026, -0.836, 0.548> }
	smooth_triangle { <171.8750, 13.5000, 22.7522>, <0.214, 0.775, -0.594>, <187.3025, 13.5000, 25.0023>, <0.028, 0.766, -0.643>, <187.4166, 27.0000, 37.7262>, <0.044, 0.490, -0.871> }
	smooth_triangle { <166.1729, 27.0000, 34.6279>, <-0.193, -0.600, 0.777>, <187.4166, 27.0000, 37.7262>, <0.032, -0.593, 0.805>, <171.8750, 13.5000, 22.7522>, <-0.125, -0.840, 0.529> }
	smooth_triangle { <159.7750, 13.5000, 16.5647>, <0.434, 0.795, -0.424>, <171.8750, 13.5000, 22.7522>, <0.214, 0.775, -0.594>, <166.1729, 27.0000, 34.6279>, <0.300, 0.502, -0.811> }
	smooth_triangle { <149.5112, 27.0000, 26.1076>, <-0.460, -0.623, 0.632>, <166.1729, 27.0000, 34.6279>, <-0.193, -0.600, 0.777>, <159.7750, 13.5000, 16.5647>, <-0.299, -0.854, 0.426> }
	smooth_triangle { <154.0275, 13.5000, 7.5646>, <0.566, 0.790, -0.235>, <159.7750, 13.5000, 16.5647>, <0.434, 0.795, -0.424>, <149.5112, 27.0000, 26.1076>, <0.617, 0.526, -0.585> }
	smooth_triangle { <141.5969, 27.0000, 13.7145>, <-0.692, -0.624, 0.363>, <149.5112, 27.0000, 26.1076>, <-0.460, -0.623, 0.632>, <154.0275, 13.5000, 7.5646>, <-0.456, -0.856, 0.244> }
	smooth_triangle { <150.3975, 13.5000, -4.8104>, <0.588, 0.698, 0.410>, <154.0275, 13.5000, 7.5646>, <0.566, 0.790, -0.235>, <141.5969, 27.0000, 13.7145>, <0.791, 0.520, -0.323> }
	smooth_triangle { <136.5984, 27.0000, -3.3259>, <-0.793, -0.599, -0.108>, <141.5969, 27.0000, 13.7145>, <-0.692, -0.624, 0.363>, <150.3975, 13.5000, -4.8104>, <-0.531, -0.843, -0.090> }
	smooth_triangle { <155.2375, 13.5000, -8.1854>, <0.256, 0.246, 0.935>, <150.3975, 13.5000, -4.8104>, <0.588, 0.698, 0.410>, <136.5984, 27.0000, -3.3259>, <0.761, 0.414, 0.500> }
	smooth_triangle { <143.2631, 27.0000, -7.9733>, <-0.411, -0.257, -0.875>, <136.5984, 27.0000, -3.3259>, <-0.793, -0.599, -0.108>, <155.2375, 13.5000, -8.1854>, <-0.360, -0.475, -0.803> }
	smooth_triangle { <174.5975, 13.5000, -10.4354>, <0.081, 0.110, 0.991>, <155.2375, 13.5000, -8.1854>, <0.256, 0.246, 0.935>, <143.2631, 27.0000, -7.9733>, <0.271, 0.115, 0.956> }
	smooth_triangle { <169.9218, 27.0000, -11.0716>, <-0.081, -0.054, -0.995>, <143.2631, 27.0000, -7.9733>, <-0.411, -0.257, -0.875>, <174.5975, 13.5000, -10.4354>, <-0.081, -0.116, -0.990> }
	smooth_triangle { <174.5975, 13.5000, -10.4354>, <-0.081, -0.116, -0.990>, <186.3950, 13.5000, -10.9979>, <-0.002, -0.097, -0.995>, <169.9218, 27.0000, -11.0716>, <-0.081, -0.054, -0.995> }
	smooth_triangle { <169.9218, 27.0000, -11.0716>, <0.081, 0.051, 0.995>, <186.1669, 27.0000, -11.8462>, <0.002, 0.045, 0.999>, <186.3950, 13.5000, -10.9979>, <0.002, 0.098, 0.995> }
	smooth_triangle { <203.6617, 27.0000, -11.0716>, <-0.071, 0.045, 0.996>, <186.1669, 27.0000, -11.8462>, <0.002, 0.045, 0.999>, <186.0003, 49.5000, -12.4659>, <0.002, 0.014, 1.000> }
	smooth_triangle { <206.9940, 49.5000, -11.5364>, <0.058, -0.020, -0.998>, <186.0003, 49.5000, -12.4659>, <-0.002, -0.014, -1.000>, <203.6617, 27.0000, -11.0716>, <0.057, -0.055, -0.997> }
	smooth_triangle { <231.1535, 27.0000, -8.7479>, <-0.418, 0.257, 0.871>, <203.6617, 27.0000, -11.0716>, <-0.071, 0.045, 0.996>, <206.9940, 49.5000, -11.5364>, <-0.071, 0.011, 0.997> }
	smooth_triangle { <239.9842, 49.5000, -8.7479>, <0.260, -0.091, -0.961>, <206.9940, 49.5000, -11.5364>, <0.058, -0.020, -0.998>, <231.1535, 27.0000, -8.7479>, <0.244, -0.204, -0.948> }
	smooth_triangle { <237.4017, 27.0000, -4.1005>, <-0.837, 0.525, 0.155>, <231.1535, 27.0000, -8.7479>, <-0.418, 0.257, 0.871>, <239.9842, 49.5000, -8.7479>, <-0.438, 0.079, 0.895> }
	smooth_triangle { <247.4820, 49.5000, -3.1711>, <0.808, -0.248, -0.535>, <239.9842, 49.5000, -8.7479>, <0.260, -0.091, -0.961>, <237.4017, 27.0000, -4.1005>, <0.679, -0.536, -0.502> }
	smooth_triangle { <233.2362, 27.0000, 12.9399>, <-0.745, 0.523, -0.414>, <237.4017, 27.0000, -4.1005>, <-0.837, 0.525, 0.155>, <247.4820, 49.5000, -3.1711>, <-0.977, 0.162, 0.138> }
	smooth_triangle { <242.4835, 49.5000, 17.2775>, <0.893, -0.281, 0.351>, <247.4820, 49.5000, -3.1711>, <0.808, -0.248, -0.535>, <233.2362, 27.0000, 12.9399>, <0.728, -0.627, 0.279> }
	smooth_triangle { <223.6558, 27.0000, 25.3330>, <-0.532, 0.512, -0.674>, <233.2362, 27.0000, 12.9399>, <-0.745, 0.523, -0.414>, <242.4835, 49.5000, 17.2775>, <-0.861, 0.140, -0.488> }
	smooth_triangle { <230.9869, 49.5000, 32.1492>, <0.683, -0.275, 0.677>, <242.4835, 49.5000, 17.2775>, <0.893, -0.281, 0.351>, <223.6558, 27.0000, 25.3330>, <0.561, -0.619, 0.549> }
	smooth_triangle { <206.5775, 27.0000, 35.4025>, <-0.229, 0.499, -0.836>, <223.6558, 27.0000, 25.3330>, <-0.532, 0.512, -0.674>, <230.9869, 49.5000, 32.1492>, <-0.609, 0.135, -0.781> }
	smooth_triangle { <210.4930, 49.5000, 44.2326>, <0.375, -0.267, 0.888>, <230.9869, 49.5000, 32.1492>, <0.683, -0.275, 0.677>, <206.5775, 27.0000, 35.4025>, <0.314, -0.607, 0.730> }
	smooth_triangle { <187.4166, 27.0000, 37.7262>, <0.044, 0.490, -0.871>, <206.5775, 27.0000, 35.4025>, <-0.229, 0.499, -0.836>, <210.4930, 49.5000, 44.2326>, <-0.256, 0.131, -0.958> }
	smooth_triangle { <187.4999, 49.5000, 47.0210>, <0.034, -0.259, 0.965>, <210.4930, 49.5000, 44.2326>, <0.375, -0.267, 0.888>, <187.4166, 27.0000, 37.7262>, <0.032, -0.593, 0.805> }
	smooth_triangle { <166.1729, 27.0000, 34.6279>, <0.300, 0.502, -0.811>, <187.4166, 27.0000, 37.7262>, <0.044, 0.490, -0.871>, <187.4999, 49.5000, 47.0210>, <0.054, 0.129, -0.990> }
	smooth_triangle { <162.0074, 49.5000, 43.3031>, <-0.239, -0.264, 0.934>, <187.4999, 49.5000, 47.0210>, <0.034, -0.259, 0.965>, <166.1729, 27.0000, 34.6279>, <-0.193, -0.600, 0.777> }
	smooth_triangle { <149.5112, 27.0000, 26.1076>, <0.617, 0.526, -0.585>, <166.1729, 27.0000, 34.6279>, <0.300, 0.502, -0.811>, <162.0074, 49.5000, 43.3031>, <0.350, 0.135, -0.927> }
	smooth_triangle { <142.0134, 49.5000, 33.0788>, <-0.574, -0.280, 0.769>, <162.0074, 49.5000, 43.3031>, <-0.239, -0.264, 0.934>, <149.5112, 27.0000, 26.1076>, <-0.460, -0.623, 0.632> }
	smooth_triangle { <141.5969, 27.0000, 13.7145>, <0.791, 0.520, -0.323>, <149.5112, 27.0000, 26.1076>, <0.617, 0.526, -0.585>, <142.0134, 49.5000, 33.0788>, <0.725, 0.143, -0.673> }
	smooth_triangle { <132.5162, 49.5000, 18.2070>, <-0.853, -0.279, 0.441>, <142.0134, 49.5000, 33.0788>, <-0.574, -0.280, 0.769>, <141.5969, 27.0000, 13.7145>, <-0.692, -0.624, 0.363> }
	smooth_triangle { <136.5984, 27.0000, -3.3259>, <0.761, 0.414, 0.500>, <141.5969, 27.0000, 13.7145>, <0.791, 0.520, -0.323>, <132.5162, 49.5000, 18.2070>, <0.919, 0.139, -0.369> }
	smooth_triangle { <126.5181, 49.5000, -2.2415>, <-0.963, -0.248, -0.106>, <132.5162, 49.5000, 18.2070>, <-0.853, -0.279, 0.441>, <136.5984, 27.0000, -3.3259>, <-0.793, -0.599, -0.108> }
	smooth_triangle { <143.2631, 27.0000, -7.9733>, <0.271, 0.115, 0.956>, <136.5984, 27.0000, -3.3259>, <0.761, 0.414, 0.500>, <126.5181, 49.5000, -2.2415>, <0.569, 0.107, 0.816> }
	smooth_triangle { <134.5157, 49.5000, -7.8184>, <-0.429, -0.086, -0.899>, <126.5181, 49.5000, -2.2415>, <-0.868, -0.373, -0.329>, <143.2631, 27.0000, -7.9733>, <-0.411, -0.257, -0.875> }
	smooth_triangle { <169.9218, 27.0000, -11.0716>, <0.081, 0.051, 0.995>, <143.2631, 27.0000, -7.9733>, <0.271, 0.115, 0.956>, <134.5157, 49.5000, -7.8184>, <0.275, 0.013, 0.961> }
	smooth_triangle { <166.5061, 49.5000, -11.5364>, <-0.082, -0.016, -0.997>, <134.5157, 49.5000, -7.8184>, <-0.429, -0.086, -0.899>, <169.9218, 27.0000, -11.0716>, <-0.081, -0.054, -0.995> }
	smooth_triangle { <169.9218, 27.0000, -11.0716>, <-0.081, -0.054, -0.995>, <186.1669, 27.0000, -11.8462>, <-0.002, -0.045, -0.999>, <166.5061, 49.5000, -11.5364>, <-0.082, -0.016, -0.997> }
	smooth_triangle { <166.5061, 49.5000, -11.5364>, <0.082, 0.014, 0.997>, <186.0003, 49.5000, -12.4659>, <0.002, 0.014, 1.000>, <186.1669, 27.0000, -11.8462>, <0.002, 0.045, 0.999> }
	smooth_triangle { <206.9940, 49.5000, -11.5364>, <-0.071, 0.011, 0.997>, <186.0003, 49.5000, -12.4659>, <0.002, 0.014, 1.000>, <186.0003, 85.5000, -12.4659>, <0.002, -0.016, 1.000> }
	smooth_triangle { <206.9940, 85.5000, -11.5364>, <0.058, 0.010, -0.998>, <186.0003, 85.5000, -12.4659>, <-0.002, 0.016, -1.000>, <206.9940, 49.5000, -11.5364>, <0.058, -0.020, -0.998> }
	smooth_triangle { <239.9842, 49.5000, -8.7479>, <-0.438, 0.079, 0.895>, <206.9940, 49.5000, -11.5364>, <-0.071, 0.011, 0.997>, <206.9940, 85.5000, -11.5364>, <-0.071, -0.023, 0.997> }
	smooth_triangle { <239.9842, 85.5000, -8.7479>, <0.264, 0.013, -0.964>, <206.9940, 85.5000, -11.5364>, <0.058, 0.010, -0.998>, <239.9842, 49.5000, -8.7479>, <0.260, -0.091, -0.961> }
	smooth_triangle { <247.4820, 49.5000, -3.1711>, <-0.977, 0.162, 0.138>, <239.9842, 49.5000, -8.7479>, <-0.438, 0.079, 0.895>, <239.9842, 85.5000, -8.7479>, <-0.437, -0.103, 0.894> }
	smooth_triangle { <247.4820, 85.5000, -3.1711>, <0.844, 0.101, -0.527>, <239.9842, 85.5000, -8.7479>, <0.264, 0.013, -0.964>, <247.4820, 49.5000, -3.1711>, <0.808, -0.248, -0.535> }
	smooth_triangle { <242.4835, 49.5000, 17.2775>, <-0.861, 0.140, -0.488>, <247.4820, 49.5000, -3.1711>, <-0.977, 0.162, 0.138>, <247.4820, 85.5000, -3.1711>, <-0.951, -0.280, 0.128> }
	smooth_triangle { <242.4835, 85.5000, 17.2775>, <0.916, 0.158, 0.370>, <247.4820, 85.5000, -3.1711>, <0.844, 0.101, -0.527>, <242.4835, 49.5000, 17.2775>, <0.893, -0.281, 0.351> }
	smooth_triangle { <230.9869, 49.5000, 32.1492>, <-0.609, 0.135, -0.781>, <242.4835, 49.5000, 17.2775>, <-0.861, 0.140, -0.488>, <242.4835, 85.5000, 17.2775>, <-0.822, -0.314, -0.476> }
	smooth_triangle { <230.9869, 85.5000, 32.1492>, <0.696, 0.156, 0.701>, <242.4835, 85.5000, 17.2775>, <0.916, 0.158, 0.370>, <230.9869, 49.5000, 32.1492>, <0.683, -0.275, 0.677> }
	smooth_triangle { <210.4930, 49.5000, 44.2326>, <-0.256, 0.131, -0.958>, <230.9869, 49.5000, 32.1492>, <-0.609, 0.135, -0.781>, <230.9869, 85.5000, 32.1492>, <-0.579, -0.307, -0.756> }
	smooth_triangle { <210.4930, 85.5000, 44.2326>, <0.377, 0.152, 0.914>, <230.9869, 85.5000, 32.1492>, <0.696, 0.156, 0.701>, <210.4930, 49.5000, 44.2326>, <0.375, -0.267, 0.888> }
	smooth_triangle { <187.4999, 49.5000, 47.0210>, <0.054, 0.129, -0.990>, <210.4930, 49.5000, 44.2326>, <-0.256, 0.131, -0.958>, <210.4930, 85.5000, 44.2326>, <-0.238, -0.298, -0.924> }
	smooth_triangle { <187.4999, 85.5000, 47.0210>, <0.029, 0.145, 0.989>, <210.4930, 85.5000, 44.2326>, <0.377, 0.152, 0.914>, <187.4999, 49.5000, 47.0210>, <0.034, -0.259, 0.965> }
	smooth_triangle { <162.0074, 49.5000, 43.3031>, <0.350, 0.135, -0.927>, <187.4999, 49.5000, 47.0210>, <0.054, 0.129, -0.990>, <187.4999, 85.5000, 47.0210>, <0.057, -0.290, -0.955> }
	smooth_triangle { <162.0074, 85.5000, 43.3031>, <-0.252, 0.145, 0.957>, <187.4999, 85.5000, 47.0210>, <0.029, 0.145, 0.989>, <162.0074, 49.5000, 43.3031>, <-0.239, -0.264, 0.934> }
	smooth_triangle { <142.0134, 49.5000, 33.0788>, <0.725, 0.143, -0.673>, <162.0074, 49.5000, 43.3031>, <0.350, 0.135, -0.927>, <162.0074, 85.5000, 43.3031>, <0.343, -0.296, -0.891> }
	smooth_triangle { <142.0134, 85.5000, 33.0788>, <-0.601, 0.154, 0.784>, <162.0074, 85.5000, 43.3031>, <-0.252, 0.145, 0.957>, <142.0134, 49.5000, 33.0788>, <-0.574, -0.280, 0.769> }
	smooth_triangle { <132.5162, 49.5000, 18.2070>, <0.919, 0.139, -0.369>, <142.0134, 49.5000, 33.0788>, <0.725, 0.143, -0.673>, <142.0134, 85.5000, 33.0788>, <0.703, -0.313, -0.638> }
	smooth_triangle { <132.5162, 85.5000, 18.2070>, <-0.880, 0.157, 0.448>, <142.0134, 85.5000, 33.0788>, <-0.601, 0.154, 0.784>, <132.5162, 49.5000, 18.2070>, <-0.853, -0.279, 0.441> }
	smooth_triangle { <126.5181, 49.5000, -2.2415>, <0.960, 0.000, -0.281>, <132.5162, 49.5000, 18.2070>, <0.919, 0.139, -0.369>, <132.5162, 85.5000, 18.2070>, <0.884, -0.312, -0.349> }
	smooth_triangle { <126.5181, 85.5000, -2.2415>, <-0.933, 0.232, 0.274>, <132.5162, 85.5000, 18.2070>, <-0.880, 0.157, 0.448>, <126.5181, 49.5000, -2.2415>, <-0.939, -0.207, 0.275> }
	smooth_triangle { <134.5157, 49.5000, -7.8184>, <0.275, 0.013, 0.961>, <126.5181, 49.5000, -2.2415>, <0.569, 0.107, 0.816>, <126.5181, 85.5000, -2.2415>, <0.568, -0.121, 0.814> }
	smooth_triangle { <134.5157, 85.5000, -7.8184>, <-0.428, 0.083, -0.900>, <126.5181, 85.5000, -2.2415>, <-0.572, 0.000, -0.820>, <134.5157, 49.5000, -7.8184>, <-0.429, -0.086, -0.899> }
	smooth_triangle { <166.5061, 49.5000, -11.5364>, <0.082, 0.014, 0.997>, <134.5157, 49.5000, -7.8184>, <0.275, 0.013, 0.961>, <134.5157, 85.5000, -7.8184>, <0.271, -0.097, 0.958> }
	smooth_triangle { <166.5061, 85.5000, -11.5364>, <-0.082, 0.019, -0.996>, <134.5157, 85.5000, -7.8184>, <-0.428, 0.083, -0.900>, <166.5061, 49.5000, -11.5364>, <-0.082, -0.016, -0.997> }
	smooth_triangle { <166.5061, 49.5000, -11.5364>, <-0.082, -0.016, -0.997>, <186.0003, 49.5000, -12.4659>, <-0.002, -0.014, -1.000>, <166.5061, 85.5000, -11.5364>, <-0.082, 0.019, -0.996> }
	smooth_triangle { <166.5061, 85.5000, -11.5364>, <0.082, -0.022, 0.996>, <186.0003, 85.5000, -12.4659>, <0.002, -0.016, 1.000>, <186.0003, 49.5000, -12.4659>, <0.002, 0.014, 1.000> }
	smooth_triangle { <206.9940, 85.5000, -11.5364>, <-0.071, -0.023, 0.997>, <186.0003, 85.5000, -12.4659>, <0.002, -0.016, 1.000>, <186.1902, 108.0000, -11.7594>, <0.002, -0.057, 0.998> }
	smooth_triangle { <203.1952, 108.0000, -11.0065>, <0.058, 0.050, -0.997>, <186.1902, 108.0000, -11.7594>, <-0.002, 0.057, -0.998>, <206.9940, 85.5000, -11.5364>, <0.058, 0.010, -0.998> }
	smooth_triangle { <239.9842, 85.5000, -8.7479>, <-0.437, -0.103, 0.894>, <206.9940, 85.5000, -11.5364>, <-0.071, -0.023, 0.997>, <203.1952, 108.0000, -11.0065>, <-0.071, -0.073, 0.995> }
	smooth_triangle { <229.9172, 108.0000, -8.7479>, <0.258, 0.136, -0.957>, <203.1952, 108.0000, -11.0065>, <0.058, 0.050, -0.997>, <239.9842, 85.5000, -8.7479>, <0.264, 0.013, -0.964> }
	smooth_triangle { <247.4820, 85.5000, -3.1711>, <-0.951, -0.280, 0.128>, <239.9842, 85.5000, -8.7479>, <-0.437, -0.103, 0.894>, <229.9172, 108.0000, -8.7479>, <-0.405, -0.328, 0.854> }
	smooth_triangle { <235.9904, 108.0000, -4.2307>, <0.737, 0.490, -0.466>, <229.9172, 108.0000, -8.7479>, <0.258, 0.136, -0.957>, <247.4820, 85.5000, -3.1711>, <0.844, 0.101, -0.527> }
	smooth_triangle { <242.4835, 85.5000, 17.2775>, <-0.822, -0.314, -0.476>, <247.4820, 85.5000, -3.1711>, <-0.951, -0.280, 0.128>, <235.9904, 108.0000, -4.2307>, <-0.723, -0.682, 0.113> }
	smooth_triangle { <231.9416, 108.0000, 12.3326>, <0.746, 0.589, 0.311>, <235.9904, 108.0000, -4.2307>, <0.737, 0.490, -0.466>, <242.4835, 85.5000, 17.2775>, <0.916, 0.158, 0.370> }
	smooth_triangle { <230.9869, 85.5000, 32.1492>, <-0.579, -0.307, -0.756>, <242.4835, 85.5000, 17.2775>, <-0.822, -0.314, -0.476>, <231.9416, 108.0000, 12.3326>, <-0.608, -0.706, -0.364> }
	smooth_triangle { <222.6294, 108.0000, 24.3787>, <0.566, 0.583, 0.583>, <231.9416, 108.0000, 12.3326>, <0.746, 0.589, 0.311>, <230.9869, 85.5000, 32.1492>, <0.696, 0.156, 0.701> }
	smooth_triangle { <210.4930, 85.5000, 44.2326>, <-0.238, -0.298, -0.924>, <230.9869, 85.5000, 32.1492>, <-0.579, -0.307, -0.756>, <222.6294, 108.0000, 24.3787>, <-0.429, -0.696, -0.576> }
	smooth_triangle { <206.0293, 108.0000, 34.1662>, <0.304, 0.571, 0.763>, <222.6294, 108.0000, 24.3787>, <0.566, 0.583, 0.583>, <210.4930, 85.5000, 44.2326>, <0.377, 0.152, 0.914> }
	smooth_triangle { <187.4999, 85.5000, 47.0210>, <0.057, -0.290, -0.955>, <210.4930, 85.5000, 44.2326>, <-0.238, -0.298, -0.924>, <206.0293, 108.0000, 34.1662>, <-0.172, -0.685, -0.708> }
	smooth_triangle { <187.4049, 108.0000, 36.4249>, <0.019, 0.556, 0.831>, <206.0293, 108.0000, 34.1662>, <0.304, 0.571, 0.763>, <187.4999, 85.5000, 47.0210>, <0.029, 0.145, 0.989> }
	smooth_triangle { <162.0074, 85.5000, 43.3031>, <0.343, -0.296, -0.891>, <187.4999, 85.5000, 47.0210>, <0.057, -0.290, -0.955>, <187.4049, 108.0000, 36.4249>, <0.050, -0.675, -0.736> }
	smooth_triangle { <166.7560, 108.0000, 33.4133>, <-0.217, 0.562, 0.798>, <187.4049, 108.0000, 36.4249>, <0.019, 0.556, 0.831>, <162.0074, 85.5000, 43.3031>, <-0.252, 0.145, 0.957> }
	smooth_triangle { <142.0134, 85.5000, 33.0788>, <0.703, -0.313, -0.638>, <162.0074, 85.5000, 43.3031>, <0.343, -0.296, -0.891>, <166.7560, 108.0000, 33.4133>, <0.268, -0.686, -0.677> }
	smooth_triangle { <150.5609, 108.0000, 25.1316>, <-0.502, 0.586, 0.637>, <166.7560, 108.0000, 33.4133>, <-0.217, 0.562, 0.798>, <142.0134, 85.5000, 33.0788>, <-0.601, 0.154, 0.784> }
	smooth_triangle { <132.5162, 85.5000, 18.2070>, <0.884, -0.312, -0.349>, <142.0134, 85.5000, 33.0788>, <0.703, -0.313, -0.638>, <150.5609, 108.0000, 25.1316>, <0.531, -0.707, -0.467> }
	smooth_triangle { <142.8682, 108.0000, 13.0855>, <-0.725, 0.586, 0.361>, <150.5609, 108.0000, 25.1316>, <-0.502, 0.586, 0.637>, <132.5162, 85.5000, 18.2070>, <-0.880, 0.157, 0.448> }
	smooth_triangle { <126.5181, 85.5000, -2.2415>, <0.849, -0.415, 0.328>, <132.5162, 85.5000, 18.2070>, <0.884, -0.312, -0.349>, <142.8682, 108.0000, 13.0855>, <0.664, -0.703, -0.254> }
	smooth_triangle { <138.0096, 108.0000, -3.4778>, <-0.791, 0.593, -0.150>, <142.8682, 108.0000, 13.0855>, <-0.725, 0.586, 0.361>, <126.5181, 85.5000, -2.2415>, <-0.933, 0.232, 0.274> }
	smooth_triangle { <134.5157, 85.5000, -7.8184>, <0.271, -0.097, 0.958>, <126.5181, 85.5000, -2.2415>, <0.792, -0.276, 0.545>, <138.0096, 108.0000, -3.4778>, <0.617, -0.606, 0.503> }
	smooth_triangle { <144.4877, 108.0000, -7.9950>, <-0.403, 0.290, -0.868>, <138.0096, 108.0000, -3.4778>, <-0.791, 0.593, -0.150>, <134.5157, 85.5000, -7.8184>, <-0.428, 0.083, -0.900> }
	smooth_triangle { <166.5061, 85.5000, -11.5364>, <0.082, -0.022, 0.996>, <134.5157, 85.5000, -7.8184>, <0.271, -0.097, 0.958>, <144.4877, 108.0000, -7.9950>, <0.249, -0.246, 0.937> }
	smooth_triangle { <170.4000, 108.0000, -11.0065>, <-0.081, 0.068, -0.994>, <144.4877, 108.0000, -7.9950>, <-0.403, 0.290, -0.868>, <166.5061, 85.5000, -11.5364>, <-0.082, 0.019, -0.996> }
	smooth_triangle { <166.5061, 85.5000, -11.5364>, <-0.082, 0.019, -0.996>, <186.0003, 85.5000, -12.4659>, <-0.002, 0.016, -1.000>, <170.4000, 108.0000, -11.0065>, <-0.081, 0.068, -0.994> }
	smooth_triangle { <170.4000, 108.0000, -11.0065>, <0.081, -0.073, 0.994>, <186.1902, 108.0000, -11.7594>, <0.002, -0.057, 0.998>, <186.0003, 85.5000, -12.4659>, <0.002, -0.016, 1.000> }
	smooth_triangle { <203.1952, 108.0000, -11.0065>, <-0.071, -0.073, 0.995>, <186.1902, 108.0000, -11.7594>, <0.002, -0.057, 0.998>, <186.4899, 121.5000, -10.6452>, <0.002, -0.177, 0.984> }
	smooth_triangle { <197.2029, 121.5000, -10.1709>, <0.057, 0.150, -0.987>, <186.4899, 121.5000, -10.6452>, <-0.001, 0.178, -0.984>, <203.1952, 108.0000, -11.0065>, <0.058, 0.050, -0.997> }
	smooth_triangle { <229.9172, 108.0000, -8.7479>, <-0.405, -0.328, 0.854>, <203.1952, 108.0000, -11.0065>, <-0.071, -0.073, 0.995>, <197.2029, 121.5000, -10.1709>, <-0.069, -0.230, 0.971> }
	smooth_triangle { <214.0378, 121.5000, -8.7479>, <0.229, 0.348, -0.909>, <197.2029, 121.5000, -10.1709>, <0.057, 0.150, -0.987>, <229.9172, 108.0000, -8.7479>, <0.258, 0.136, -0.957> }
	smooth_triangle { <235.9904, 108.0000, -4.2307>, <-0.723, -0.682, 0.113>, <229.9172, 108.0000, -8.7479>, <-0.405, -0.328, 0.854>, <214.0378, 121.5000, -8.7479>, <-0.290, -0.660, 0.694> }
	smooth_triangle { <217.8640, 121.5000, -5.9020>, <0.471, 0.831, -0.298>, <214.0378, 121.5000, -8.7479>, <0.229, 0.348, -0.909>, <235.9904, 108.0000, -4.2307>, <0.737, 0.490, -0.466> }
	smooth_triangle { <231.9416, 108.0000, 12.3326>, <-0.608, -0.706, -0.364>, <235.9904, 108.0000, -4.2307>, <-0.723, -0.682, 0.113>, <217.8640, 121.5000, -5.9020>, <-0.354, -0.934, 0.040> }
	smooth_triangle { <215.3132, 121.5000, 4.5328>, <0.433, 0.881, 0.192>, <217.8640, 121.5000, -5.9020>, <0.471, 0.831, -0.298>, <231.9416, 108.0000, 12.3326>, <0.746, 0.589, 0.311> }
	smooth_triangle { <222.6294, 108.0000, 24.3787>, <-0.429, -0.696, -0.576>, <231.9416, 108.0000, 12.3326>, <-0.608, -0.706, -0.364>, <215.3132, 121.5000, 4.5328>, <-0.292, -0.938, -0.188> }
	smooth_triangle { <209.4465, 121.5000, 12.1218>, <0.328, 0.876, 0.352>, <215.3132, 121.5000, 4.5328>, <0.433, 0.881, 0.192>, <222.6294, 108.0000, 24.3787>, <0.566, 0.583, 0.583> }
	smooth_triangle { <206.0293, 108.0000, 34.1662>, <-0.172, -0.685, -0.708>, <222.6294, 108.0000, 24.3787>, <-0.429, -0.696, -0.576>, <209.4465, 121.5000, 12.1218>, <-0.204, -0.934, -0.292> }
	smooth_triangle { <198.9885, 121.5000, 18.2879>, <0.172, 0.870, 0.463>, <209.4465, 121.5000, 12.1218>, <0.328, 0.876, 0.352>, <206.0293, 108.0000, 34.1662>, <0.304, 0.571, 0.763> }
	smooth_triangle { <187.4049, 108.0000, 36.4249>, <0.050, -0.675, -0.736>, <206.0293, 108.0000, 34.1662>, <-0.172, -0.685, -0.708>, <198.9885, 121.5000, 18.2879>, <-0.074, -0.931, -0.359> }
	smooth_triangle { <187.2551, 121.5000, 19.7109>, <0.004, 0.862, 0.507>, <198.9885, 121.5000, 18.2879>, <0.172, 0.870, 0.463>, <187.4049, 108.0000, 36.4249>, <0.019, 0.556, 0.831> }
	smooth_triangle { <166.7560, 108.0000, 33.4133>, <0.268, -0.686, -0.677>, <187.4049, 108.0000, 36.4249>, <0.050, -0.675, -0.736>, <187.2551, 121.5000, 19.7109>, <0.033, -0.928, -0.371> }
	smooth_triangle { <174.2463, 121.5000, 17.8136>, <-0.138, 0.866, 0.480>, <187.2551, 121.5000, 19.7109>, <0.004, 0.862, 0.507>, <166.7560, 108.0000, 33.4133>, <-0.217, 0.562, 0.798> }
	smooth_triangle { <150.5609, 108.0000, 25.1316>, <0.531, -0.707, -0.467>, <166.7560, 108.0000, 33.4133>, <0.268, -0.686, -0.677>, <174.2463, 121.5000, 17.8136>, <0.142, -0.932, -0.333> }
	smooth_triangle { <164.0433, 121.5000, 12.5961>, <-0.304, 0.880, 0.366>, <174.2463, 121.5000, 17.8136>, <-0.138, 0.866, 0.480>, <150.5609, 108.0000, 25.1316>, <-0.502, 0.586, 0.637> }
	smooth_triangle { <142.8682, 108.0000, 13.0855>, <0.664, -0.703, -0.254>, <150.5609, 108.0000, 25.1316>, <0.531, -0.707, -0.467>, <164.0433, 121.5000, 12.5961>, <0.268, -0.939, -0.217> }
	smooth_triangle { <159.1970, 121.5000, 5.0071>, <-0.430, 0.879, 0.207>, <164.0433, 121.5000, 12.5961>, <-0.304, 0.880, 0.366>, <142.8682, 108.0000, 13.0855>, <-0.725, 0.586, 0.361> }
	smooth_triangle { <138.0096, 108.0000, -3.4778>, <0.617, -0.606, 0.503>, <142.8682, 108.0000, 13.0855>, <0.664, -0.703, -0.254>, <159.1970, 121.5000, 5.0071>, <0.328, -0.937, -0.117> }
	smooth_triangle { <156.1360, 121.5000, -5.4277>, <-0.471, 0.865, -0.171>, <159.1970, 121.5000, 5.0071>, <-0.430, 0.879, 0.207>, <138.0096, 108.0000, -3.4778>, <-0.791, 0.593, -0.150> }
	smooth_triangle { <144.4877, 108.0000, -7.9950>, <0.249, -0.246, 0.937>, <138.0096, 108.0000, -3.4778>, <0.617, -0.606, 0.503>, <156.1360, 121.5000, -5.4277>, <0.332, -0.877, 0.348> }
	smooth_triangle { <160.2173, 121.5000, -8.2736>, <-0.309, 0.585, -0.750>, <156.1360, 121.5000, -5.4277>, <-0.471, 0.865, -0.171>, <144.4877, 108.0000, -7.9950>, <-0.403, 0.290, -0.868> }
	smooth_triangle { <170.4000, 108.0000, -11.0065>, <0.081, -0.073, 0.994>, <144.4877, 108.0000, -7.9950>, <0.249, -0.246, 0.937>, <160.2173, 121.5000, -8.2736>, <0.171, -0.517, 0.839> }
	smooth_triangle { <176.5420, 121.5000, -10.1709>, <-0.079, 0.210, -0.975>, <160.2173, 121.5000, -8.2736>, <-0.309, 0.585, -0.750>, <170.4000, 108.0000, -11.0065>, <-0.081, 0.068, -0.994> }
	smooth_triangle { <170.4000, 108.0000, -11.0065>, <-0.081, 0.068, -0.994>, <186.1902, 108.0000, -11.7594>, <-0.002, 0.057, -0.998>, <176.5420, 121.5000, -10.1709>, <-0.079, 0.210, -0.975> }
	smooth_triangle { <176.5420, 121.5000, -10.1709>, <0.078, -0.225, 0.971>, <186.4899, 121.5000, -10.6452>, <0.002, -0.177, 0.984>, <186.1902, 108.0000, -11.7594>, <0.002, -0.057, 0.998> }
	smooth_triangle { <197.2029, 121.5000, -10.1709>, <-0.069, -0.230, 0.971>, <186.4899, 121.5000, -10.6452>, <0.002, -0.177, 0.984>, <186.8979, 126.9000, -9.1274>, <0.002, -0.271, 0.963> }
	smooth_triangle { <189.0406, 126.9000, -9.0325>, <0.061, 0.294, -0.954>, <186.8979, 126.9000, -9.1274>, <0.043, 0.267, -0.963>, <197.2029, 121.5000, -10.1709>, <0.057, 0.150, -0.987> }
	smooth_triangle { <214.0378, 121.5000, -8.7479>, <-0.290, -0.660, 0.694>, <197.2029, 121.5000, -10.1709>, <-0.069, -0.230, 0.971>, <189.0406, 126.9000, -9.0325>, <-0.080, -0.320, 0.944> }
	smooth_triangle { <192.4076, 126.9000, -8.7479>, <0.173, 0.693, -0.700>, <189.0406, 126.9000, -9.0325>, <0.061, 0.294, -0.954>, <214.0378, 121.5000, -8.7479>, <0.229, 0.348, -0.909> }
	smooth_triangle { <217.8640, 121.5000, -5.9020>, <-0.354, -0.934, 0.040>, <214.0378, 121.5000, -8.7479>, <-0.290, -0.660, 0.694>, <192.4076, 126.9000, -8.7479>, <-0.230, -0.923, 0.310> }
	smooth_triangle { <193.1728, 126.9000, -8.1788>, <0.223, 0.966, -0.132>, <192.4076, 126.9000, -8.7479>, <0.173, 0.693, -0.700>, <217.8640, 121.5000, -5.9020>, <0.471, 0.831, -0.298> }
	smooth_triangle { <215.3132, 121.5000, 4.5328>, <-0.292, -0.938, -0.188>, <217.8640, 121.5000, -5.9020>, <-0.354, -0.934, 0.040>, <193.1728, 126.9000, -8.1788>, <-0.209, -0.977, -0.051> }
	smooth_triangle { <192.6627, 126.9000, -6.0918>, <0.190, 0.977, 0.092>, <193.1728, 126.9000, -8.1788>, <0.223, 0.966, -0.132>, <215.3132, 121.5000, 4.5328>, <0.433, 0.881, 0.192> }
	smooth_triangle { <209.4465, 121.5000, 12.1218>, <-0.204, -0.934, -0.292>, <215.3132, 121.5000, 4.5328>, <-0.292, -0.938, -0.188>, <192.6627, 126.9000, -6.0918>, <-0.171, -0.976, -0.132> }
	smooth_triangle { <191.4893, 126.9000, -4.5739>, <0.142, 0.976, 0.163>, <192.6627, 126.9000, -6.0918>, <0.190, 0.977, 0.092>, <209.4465, 121.5000, 12.1218>, <0.328, 0.876, 0.352> }
	smooth_triangle { <198.9885, 121.5000, 18.2879>, <-0.074, -0.931, -0.359>, <209.4465, 121.5000, 12.1218>, <-0.204, -0.934, -0.292>, <191.4893, 126.9000, -4.5739>, <-0.114, -0.975, -0.193> }
	smooth_triangle { <189.3977, 126.9000, -3.3407>, <0.071, 0.975, 0.212>, <191.4893, 126.9000, -4.5739>, <0.142, 0.976, 0.163>, <198.9885, 121.5000, 18.2879>, <0.172, 0.870, 0.463> }
	smooth_triangle { <187.2551, 121.5000, 19.7109>, <0.033, -0.928, -0.371>, <198.9885, 121.5000, 18.2879>, <-0.074, -0.931, -0.359>, <189.3977, 126.9000, -3.3407>, <-0.028, -0.973, -0.230> }
	smooth_triangle { <187.0510, 126.9000, -3.0561>, <-0.003, 0.973, 0.231>, <189.3977, 126.9000, -3.3407>, <0.071, 0.975, 0.212>, <187.2551, 121.5000, 19.7109>, <0.004, 0.862, 0.507> }
	smooth_triangle { <174.2463, 121.5000, 17.8136>, <0.142, -0.932, -0.333>, <187.2551, 121.5000, 19.7109>, <0.033, -0.928, -0.371>, <187.0510, 126.9000, -3.0561>, <0.034, -0.972, -0.231> }
	smooth_triangle { <184.4493, 126.9000, -3.4356>, <-0.068, 0.974, 0.215>, <187.0510, 126.9000, -3.0561>, <-0.003, 0.973, 0.231>, <174.2463, 121.5000, 17.8136>, <-0.138, 0.866, 0.480> }
	smooth_triangle { <164.0433, 121.5000, 12.5961>, <0.268, -0.939, -0.217>, <174.2463, 121.5000, 17.8136>, <0.142, -0.932, -0.333>, <184.4493, 126.9000, -3.4356>, <0.102, -0.975, -0.199> }
	smooth_triangle { <182.4087, 126.9000, -4.4791>, <-0.141, 0.977, 0.157>, <184.4493, 126.9000, -3.4356>, <-0.068, 0.974, 0.215>, <164.0433, 121.5000, 12.5961>, <-0.304, 0.880, 0.366> }
	smooth_triangle { <159.1970, 121.5000, 5.0071>, <0.328, -0.937, -0.117>, <164.0433, 121.5000, 12.5961>, <0.268, -0.939, -0.217>, <182.4087, 126.9000, -4.4791>, <0.180, -0.977, -0.115> }
	smooth_triangle { <181.4394, 126.9000, -5.9969>, <-0.194, 0.977, 0.088>, <182.4087, 126.9000, -4.4791>, <-0.141, 0.977, 0.157>, <159.1970, 121.5000, 5.0071>, <-0.430, 0.879, 0.207> }
	smooth_triangle { <156.1360, 121.5000, -5.4277>, <0.332, -0.877, 0.348>, <159.1970, 121.5000, 5.0071>, <0.328, -0.937, -0.117>, <181.4394, 126.9000, -5.9969>, <0.207, -0.976, -0.061> }
	smooth_triangle { <180.8272, 126.9000, -8.0839>, <-0.226, 0.964, -0.142>, <181.4394, 126.9000, -5.9969>, <-0.194, 0.977, 0.088>, <156.1360, 121.5000, -5.4277>, <-0.471, 0.865, -0.171> }
	smooth_triangle { <160.2173, 121.5000, -8.2736>, <0.171, -0.517, 0.839>, <156.1360, 121.5000, -5.4277>, <0.332, -0.877, 0.348>, <180.8272, 126.9000, -8.0839>, <0.236, -0.911, 0.338> }
	smooth_triangle { <181.6434, 126.9000, -8.6531>, <-0.188, 0.697, -0.692>, <180.8272, 126.9000, -8.0839>, <-0.226, 0.964, -0.142>, <160.2173, 121.5000, -8.2736>, <-0.309, 0.585, -0.750> }
	smooth_triangle { <176.5420, 121.5000, -10.1709>, <0.078, -0.225, 0.971>, <160.2173, 121.5000, -8.2736>, <0.171, -0.517, 0.839>, <181.6434, 126.9000, -8.6531>, <0.108, -0.362, 0.926> }
	smooth_triangle { <184.9084, 126.9000, -9.0325>, <-0.077, 0.318, -0.945>, <181.6434, 126.9000, -8.6531>, <-0.188, 0.697, -0.692>, <176.5420, 121.5000, -10.1709>, <-0.079, 0.210, -0.975> }
	smooth_triangle { <176.5420, 121.5000, -10.1709>, <-0.079, 0.210, -0.975>, <186.4899, 121.5000, -10.6452>, <-0.001, 0.178, -0.984>, <184.9084, 126.9000, -9.0325>, <-0.077, 0.318, -0.945> }
	smooth_triangle { <184.9084, 126.9000, -9.0325>, <0.046, -0.274, 0.961>, <186.8979, 126.9000, -9.1274>, <0.002, -0.271, 0.963>, <186.4899, 121.5000, -10.6452>, <0.002, -0.177, 0.984> }

	texture { AXIS_black_4 }
}

/* Object 'CUSTOM1' */
union {
	smooth_triangle { <192.8151, 55.4223, -11.7026>, <0.091, 0.346, -0.934>, <190.5000, 51.0092, -13.5599>, <-0.049, 0.025, -0.998>, <204.6772, 51.7538, -11.9102>, <0.103, 0.340, -0.935> }
	smooth_triangle { <204.6772, 51.7538, -11.9102>, <-0.091, -0.346, 0.934>, <201.7833, 46.2373, -14.2319>, <-0.033, -0.195, 0.980>, <190.5000, 51.0092, -13.5599>, <0.049, -0.025, 0.998> }
	smooth_triangle { <191.9308, 53.7367, -8.6973>, <0.125, 0.473, 0.872>, <192.8151, 55.4223, -11.7026>, <0.259, 0.808, 0.529>, <203.5719, 49.6467, -8.1536>, <0.243, 0.584, 0.774> }
	smooth_triangle { <203.5719, 49.6467, -8.1536>, <-0.089, -0.302, -0.949>, <204.6772, 51.7538, -11.9102>, <-0.336, -0.824, -0.457>, <192.8151, 55.4223, -11.7026>, <-0.259, -0.808, -0.529> }
	smooth_triangle { <189.0692, 48.2817, -8.6973>, <-0.250, -0.413, 0.876>, <191.9308, 53.7367, -8.6973>, <0.125, 0.473, 0.872>, <199.9948, 42.8280, -8.1536>, <-0.114, -0.296, 0.949> }
	smooth_triangle { <199.9948, 42.8280, -8.1536>, <0.301, 0.612, -0.731>, <203.5719, 49.6467, -8.1536>, <-0.089, -0.302, -0.949>, <191.9308, 53.7367, -8.6973>, <0.039, -0.021, -0.999> }
	smooth_triangle { <188.1848, 46.5960, -11.7026>, <-0.398, -0.745, 0.535>, <189.0692, 48.2817, -8.6973>, <-0.250, -0.413, 0.876>, <198.8894, 40.7209, -11.9102>, <-0.344, -0.772, 0.534> }
	smooth_triangle { <198.8894, 40.7209, -11.9102>, <0.398, 0.745, -0.535>, <199.9948, 42.8280, -8.1536>, <0.301, 0.612, -0.731>, <189.0692, 48.2817, -8.6973>, <0.398, 0.745, -0.535> }
	smooth_triangle { <188.1848, 46.5960, -11.7026>, <0.182, 0.299, 0.937>, <190.5000, 51.0092, -13.5599>, <0.049, -0.025, 0.998>, <198.8894, 40.7209, -11.9102>, <0.175, 0.303, 0.937> }
	smooth_triangle { <198.8894, 40.7209, -11.9102>, <-0.182, -0.299, -0.937>, <201.7833, 46.2373, -14.2319>, <-0.109, -0.142, -0.984>, <190.5000, 51.0092, -13.5599>, <-0.049, 0.025, -0.998> }
	smooth_triangle { <204.6772, 51.7538, -11.9102>, <0.103, 0.340, -0.935>, <201.7833, 46.2373, -14.2319>, <-0.109, -0.142, -0.984>, <248.6057, 31.0220, -13.9179>, <0.230, 0.322, -0.918> }
	smooth_triangle { <248.6057, 31.0220, -13.9179>, <-0.169, -0.502, 0.848>, <244.3076, 27.7548, -16.7040>, <-0.075, -0.186, 0.980>, <201.7833, 46.2373, -14.2319>, <-0.033, -0.195, 0.980> }
	smooth_triangle { <203.5719, 49.6467, -8.1536>, <0.243, 0.584, 0.774>, <204.6772, 51.7538, -11.9102>, <0.365, 0.762, 0.535>, <246.9640, 29.7740, -9.4100>, <0.403, 0.524, 0.750> }
	smooth_triangle { <246.9640, 29.7740, -9.4100>, <-0.168, -0.316, -0.934>, <248.6057, 31.0220, -13.9179>, <-0.550, -0.728, -0.408>, <204.6772, 51.7538, -11.9102>, <-0.336, -0.824, -0.457> }
	smooth_triangle { <199.9948, 42.8280, -8.1536>, <-0.114, -0.296, 0.949>, <203.5719, 49.6467, -8.1536>, <0.243, 0.584, 0.774>, <241.6512, 25.7355, -9.4100>, <-0.234, -0.262, 0.936> }
	smooth_triangle { <241.6512, 25.7355, -9.4100>, <0.396, 0.604, -0.691>, <246.9640, 29.7740, -9.4100>, <-0.168, -0.316, -0.934>, <203.5719, 49.6467, -8.1536>, <-0.089, -0.302, -0.949> }
	smooth_triangle { <198.8894, 40.7209, -11.9102>, <-0.344, -0.772, 0.534>, <199.9948, 42.8280, -8.1536>, <-0.114, -0.296, 0.949>, <240.0095, 24.4875, -13.9179>, <-0.467, -0.742, 0.481> }
	smooth_triangle { <240.0095, 24.4875, -13.9179>, <0.344, 0.865, -0.365>, <241.6512, 25.7355, -9.4100>, <0.396, 0.604, -0.691>, <199.9948, 42.8280, -8.1536>, <0.301, 0.612, -0.731> }
	smooth_triangle { <198.8894, 40.7209, -11.9102>, <0.175, 0.303, 0.937>, <201.7833, 46.2373, -14.2319>, <-0.033, -0.195, 0.980>, <240.0095, 24.4875, -13.9179>, <0.244, 0.323, 0.915> }
	smooth_triangle { <240.0095, 24.4875, -13.9179>, <-0.238, -0.430, -0.871>, <244.3076, 27.7548, -16.7040>, <-0.087, -0.168, -0.982>, <201.7833, 46.2373, -14.2319>, <-0.109, -0.142, -0.984> }
	smooth_triangle { <248.6057, 31.0220, -13.9179>, <0.230, 0.322, -0.918>, <244.3076, 27.7548, -16.7040>, <-0.087, -0.168, -0.982>, <255.2514, 23.5948, -13.9132>, <0.398, -0.032, -0.917> }
	smooth_triangle { <255.2514, 23.5948, -13.9132>, <-0.349, -0.331, 0.876>, <248.9208, 22.9294, -16.6886>, <-0.403, 0.018, 0.915>, <244.3076, 27.7548, -16.7040>, <-0.075, -0.186, 0.980> }
	smooth_triangle { <246.9640, 29.7740, -9.4100>, <0.403, 0.524, 0.750>, <248.6057, 31.0220, -13.9179>, <0.682, 0.602, 0.415>, <253.0101, 22.9390, -9.4224>, <0.887, 0.100, 0.450> }
	smooth_triangle { <253.0101, 22.9390, -9.4224>, <-0.400, -0.357, -0.844>, <255.2514, 23.5948, -13.9132>, <-0.884, -0.101, -0.456>, <248.6057, 31.0220, -13.9179>, <-0.550, -0.728, -0.408> }
	smooth_triangle { <241.6512, 25.7355, -9.4100>, <-0.234, -0.262, 0.936>, <246.9640, 29.7740, -9.4100>, <0.403, 0.524, 0.750>, <245.2943, 21.8683, -9.4224>, <0.049, -0.346, 0.937> }
	smooth_triangle { <245.2943, 21.8683, -9.4224>, <0.405, 0.383, -0.830>, <253.0101, 22.9390, -9.4224>, <-0.331, 0.019, -0.944>, <246.9640, 29.7740, -9.4100>, <-0.168, -0.316, -0.934> }
	smooth_triangle { <240.0095, 24.4875, -13.9179>, <-0.467, -0.742, 0.481>, <241.6512, 25.7355, -9.4100>, <-0.234, -0.262, 0.936>, <242.7669, 21.8624, -13.9132>, <-0.498, -0.810, 0.310> }
	smooth_triangle { <242.7669, 21.8624, -13.9132>, <0.673, 0.635, -0.379>, <245.2943, 21.8683, -9.4224>, <0.417, 0.639, -0.646>, <241.6512, 25.7355, -9.4100>, <0.396, 0.604, -0.691> }
	smooth_triangle { <240.0095, 24.4875, -13.9179>, <0.244, 0.323, 0.915>, <244.3076, 27.7548, -16.7040>, <-0.075, -0.186, 0.980>, <242.7669, 21.8624, -13.9132>, <0.261, 0.529, 0.807> }
	smooth_triangle { <242.7669, 21.8624, -13.9132>, <-0.340, -0.328, -0.881>, <248.9208, 22.9294, -16.6886>, <-0.045, -0.500, -0.865>, <244.3076, 27.7548, -16.7040>, <-0.087, -0.168, -0.982> }
	smooth_triangle { <255.2514, 23.5948, -13.9132>, <0.398, -0.032, -0.917>, <248.9208, 22.9294, -16.6886>, <-0.045, -0.500, -0.865>, <254.0576, 21.5535, -13.5999>, <0.403, -0.020, -0.915> }
	smooth_triangle { <254.0576, 21.5535, -13.5999>, <-0.406, 0.366, 0.838>, <250.2592, 21.1543, -15.2652>, <-0.129, 0.003, 0.992>, <248.9208, 22.9294, -16.6886>, <-0.219, 0.284, 0.933> }
	smooth_triangle { <253.0101, 22.9390, -9.4224>, <0.708, -0.210, 0.674>, <255.2514, 23.5948, -13.9132>, <0.831, -0.432, 0.352>, <252.7128, 21.1600, -10.9054>, <0.670, -0.021, 0.742> }
	smooth_triangle { <252.7128, 21.1600, -10.9054>, <-0.362, 0.430, -0.827>, <254.0576, 21.5535, -13.5999>, <-0.896, 0.019, -0.444>, <255.2514, 23.5948, -13.9132>, <-0.884, -0.101, -0.456> }
	smooth_triangle { <245.2943, 21.8683, -9.4224>, <-0.100, -0.623, 0.776>, <253.0101, 22.9390, -9.4224>, <0.511, -0.599, 0.616>, <248.0833, 20.5176, -10.9054>, <-0.297, -0.363, 0.883> }
	smooth_triangle { <248.0833, 20.5176, -10.9054>, <0.428, 0.711, -0.558>, <252.7128, 21.1600, -10.9054>, <-0.362, 0.430, -0.827>, <253.0101, 22.9390, -9.4224>, <-0.048, 0.346, -0.937> }
	smooth_triangle { <242.7669, 21.8624, -13.9132>, <-0.498, -0.810, 0.310>, <245.2943, 21.8683, -9.4224>, <-0.137, -0.847, 0.514>, <246.5669, 20.5140, -13.5999>, <-0.593, -0.805, -0.010> }
	smooth_triangle { <246.5669, 20.5140, -13.5999>, <0.300, 0.912, 0.280>, <248.0833, 20.5176, -10.9054>, <0.428, 0.711, -0.558>, <245.2943, 21.8683, -9.4224>, <0.522, 0.800, -0.295> }
	smooth_triangle { <242.7669, 21.8624, -13.9132>, <0.261, 0.529, 0.807>, <248.9208, 22.9294, -16.6886>, <-0.115, 0.567, 0.815>, <246.5669, 20.5140, -13.5999>, <0.408, 0.683, 0.605> }
	smooth_triangle { <246.5669, 20.5140, -13.5999>, <-0.300, -0.912, -0.280>, <250.2592, 21.1543, -15.2652>, <-0.330, -0.363, -0.871>, <248.9208, 22.9294, -16.6886>, <-0.045, -0.500, -0.865> }
	smooth_triangle { <254.0576, 21.5535, -13.5999>, <0.403, -0.020, -0.915>, <250.2592, 21.1543, -15.2652>, <-0.036, 0.196, -0.980>, <262.4590, 7.0348, -15.6638>, <0.401, 0.002, -0.916> }
	smooth_triangle { <262.4590, 7.0348, -15.6638>, <-0.350, -0.327, 0.878>, <256.1284, 6.3694, -18.4392>, <-0.187, 0.204, 0.961>, <250.2592, 21.1543, -15.2652>, <-0.129, 0.003, 0.992> }
	smooth_triangle { <252.7128, 21.1600, -10.9054>, <0.670, -0.021, 0.742>, <254.0576, 21.5535, -13.5999>, <0.797, 0.396, 0.456>, <260.2177, 6.3790, -11.1730>, <0.896, -0.036, 0.442> }
	smooth_triangle { <260.2177, 6.3790, -11.1730>, <-0.469, -0.223, -0.854>, <262.4590, 7.0348, -15.6638>, <-0.896, 0.036, -0.442>, <254.0576, 21.5535, -13.5999>, <-0.896, 0.019, -0.444> }
	smooth_triangle { <248.0833, 20.5176, -10.9054>, <-0.297, -0.363, 0.883>, <252.7128, 21.1600, -10.9054>, <0.670, -0.021, 0.742>, <252.5018, 5.3083, -11.1730>, <0.041, -0.293, 0.955> }
	smooth_triangle { <252.5018, 5.3083, -11.1730>, <0.489, 0.157, -0.858>, <260.2177, 6.3790, -11.1730>, <-0.356, 0.068, -0.932>, <252.7128, 21.1600, -10.9054>, <-0.362, 0.430, -0.827> }
	smooth_triangle { <246.5669, 20.5140, -13.5999>, <-0.660, -0.653, 0.372>, <248.0833, 20.5176, -10.9054>, <-0.297, -0.363, 0.883>, <249.9745, 5.3024, -15.6638>, <-0.719, -0.564, 0.405> }
	smooth_triangle { <249.9745, 5.3024, -15.6638>, <0.843, 0.253, -0.475>, <252.5018, 5.3083, -11.1730>, <0.547, 0.437, -0.714>, <248.0833, 20.5176, -10.9054>, <0.428, 0.711, -0.558> }
	smooth_triangle { <246.5669, 20.5140, -13.5999>, <0.330, 0.363, 0.871>, <250.2592, 21.1543, -15.2652>, <-0.129, 0.003, 0.992>, <249.9745, 5.3024, -15.6638>, <0.357, 0.267, 0.895> }
	smooth_triangle { <249.9745, 5.3024, -15.6638>, <-0.415, 0.030, -0.909>, <256.1284, 6.3694, -18.4392>, <-0.101, -0.308, -0.946>, <250.2592, 21.1543, -15.2652>, <-0.102, -0.135, -0.986> }
	smooth_triangle { <262.4590, 7.0348, -15.6638>, <0.401, 0.002, -0.916>, <256.1284, 6.3694, -18.4392>, <-0.101, -0.308, -0.946>, <260.8211, 4.3121, -15.4123>, <0.401, 0.009, -0.916> }
	smooth_triangle { <260.8211, 4.3121, -15.4123>, <-0.408, 0.324, 0.853>, <257.0227, 3.9128, -17.0775>, <-0.138, -0.032, 0.990>, <256.1284, 6.3694, -18.4392>, <-0.187, 0.204, 0.961> }
	smooth_triangle { <260.2177, 6.3790, -11.1730>, <0.697, -0.252, 0.672>, <262.4590, 7.0348, -15.6638>, <0.819, -0.461, 0.341>, <259.4763, 3.9186, -12.7178>, <0.666, -0.014, 0.746> }
	smooth_triangle { <259.4763, 3.9186, -12.7178>, <-0.350, 0.395, -0.850>, <260.8211, 4.3121, -15.4123>, <-0.896, 0.017, -0.444>, <262.4590, 7.0348, -15.6638>, <-0.896, 0.036, -0.442> }
	smooth_triangle { <252.5018, 5.3083, -11.1730>, <-0.169, -0.535, 0.828>, <260.2177, 6.3790, -11.1730>, <0.500, -0.563, 0.657>, <254.8468, 3.2762, -12.7178>, <-0.298, -0.317, 0.900> }
	smooth_triangle { <254.8468, 3.2762, -12.7178>, <0.493, 0.621, -0.610>, <259.4763, 3.9186, -12.7178>, <-0.350, 0.395, -0.850>, <260.2177, 6.3790, -11.1730>, <-0.041, 0.293, -0.955> }
	smooth_triangle { <249.9745, 5.3024, -15.6638>, <-0.719, -0.564, 0.405>, <252.5018, 5.3083, -11.1730>, <-0.240, -0.748, 0.619>, <253.3304, 3.2726, -15.4123>, <-0.709, -0.706, -0.016> }
	smooth_triangle { <253.3304, 3.2726, -15.4123>, <0.475, 0.823, 0.311>, <254.8468, 3.2762, -12.7178>, <0.493, 0.621, -0.610>, <252.5018, 5.3083, -11.1730>, <0.719, 0.564, -0.405> }
	smooth_triangle { <249.9745, 5.3024, -15.6638>, <0.357, 0.267, 0.895>, <256.1284, 6.3694, -18.4392>, <-0.187, 0.204, 0.961>, <253.3304, 3.2726, -15.4123>, <0.527, 0.576, 0.625> }
	smooth_triangle { <253.3304, 3.2726, -15.4123>, <-0.475, -0.823, -0.311>, <257.0227, 3.9128, -17.0775>, <-0.120, -0.060, -0.991>, <256.1284, 6.3694, -18.4392>, <-0.101, -0.308, -0.946> }
	smooth_triangle { <260.8211, 4.3121, -15.4123>, <0.401, 0.009, -0.916>, <257.0227, 3.9128, -17.0775>, <-0.120, -0.060, -0.991>, <269.1242, -8.8114, -17.2431>, <0.374, -0.003, -0.928> }
	smooth_triangle { <269.1242, -8.8114, -17.2431>, <-0.373, -0.365, 0.853>, <262.5482, -8.5865, -20.0186>, <-0.155, 0.191, 0.969>, <257.0227, 3.9128, -17.0775>, <-0.138, -0.032, 0.990> }
	smooth_triangle { <259.4763, 3.9186, -12.7178>, <0.666, -0.014, 0.746>, <260.8211, 4.3121, -15.4123>, <0.781, 0.431, 0.453>, <266.7000, -9.1330, -12.7524>, <0.880, -0.057, 0.471> }
	smooth_triangle { <266.7000, -9.1330, -12.7524>, <-0.458, -0.251, -0.852>, <269.1242, -8.8114, -17.2431>, <-0.880, 0.057, -0.471>, <260.8211, 4.3121, -15.4123>, <-0.896, 0.017, -0.444> }
	smooth_triangle { <254.8468, 3.2762, -12.7178>, <-0.298, -0.317, 0.900>, <259.4763, 3.9186, -12.7178>, <0.666, -0.014, 0.746>, <258.6259, -9.1069, -12.7524>, <-0.001, -0.288, 0.958> }
	smooth_triangle { <258.6259, -9.1069, -12.7524>, <0.495, 0.153, -0.855>, <266.7000, -9.1330, -12.7524>, <-0.322, 0.050, -0.945>, <259.4763, 3.9186, -12.7178>, <-0.350, 0.395, -0.850> }
	smooth_triangle { <253.3304, 3.2726, -15.4123>, <-0.717, -0.568, 0.404>, <254.8468, 3.2762, -12.7178>, <-0.298, -0.317, 0.900>, <256.0599, -8.7691, -17.2431>, <-0.747, -0.536, 0.393> }
	smooth_triangle { <256.0599, -8.7691, -17.2431>, <0.847, 0.260, -0.464>, <258.6259, -9.1069, -12.7524>, <0.579, 0.413, -0.703>, <254.8468, 3.2762, -12.7178>, <0.493, 0.621, -0.610> }
	smooth_triangle { <253.3304, 3.2726, -15.4123>, <0.359, 0.261, 0.896>, <257.0227, 3.9128, -17.0775>, <-0.138, -0.032, 0.990>, <256.0599, -8.7691, -17.2431>, <0.388, 0.245, 0.889> }
	smooth_triangle { <256.0599, -8.7691, -17.2431>, <-0.394, 0.042, -0.918>, <262.5482, -8.5865, -20.0186>, <-0.134, -0.300, -0.945>, <257.0227, 3.9128, -17.0775>, <-0.120, -0.060, -0.991> }
	smooth_triangle { <269.1242, -8.8114, -17.2431>, <0.374, -0.003, -0.928>, <262.5482, -8.5865, -20.0186>, <-0.134, -0.300, -0.945>, <267.2680, -11.3044, -17.0036>, <0.387, -0.047, -0.921> }
	smooth_triangle { <267.2680, -11.3044, -17.0036>, <-0.355, 0.347, 0.868>, <263.3224, -11.1694, -18.6688>, <-0.139, -0.026, 0.990>, <262.5482, -8.5865, -20.0186>, <-0.155, 0.191, 0.969> }
	smooth_triangle { <266.7000, -9.1330, -12.7524>, <0.654, -0.276, 0.705>, <269.1242, -8.8114, -17.2431>, <0.761, -0.531, 0.373>, <265.8135, -11.4973, -14.3091>, <0.652, -0.119, 0.749> }
	smooth_triangle { <265.8135, -11.4973, -14.3091>, <-0.294, 0.422, -0.857>, <267.2680, -11.3044, -17.0036>, <-0.874, 0.155, -0.461>, <269.1242, -8.8114, -17.2431>, <-0.880, 0.057, -0.471> }
	smooth_triangle { <258.6259, -9.1069, -12.7524>, <-0.230, -0.514, 0.827>, <266.7000, -9.1330, -12.7524>, <0.424, -0.604, 0.675>, <260.9690, -11.4817, -14.3091>, <-0.340, -0.243, 0.909> }
	smooth_triangle { <260.9690, -11.4817, -14.3091>, <0.571, 0.535, -0.623>, <265.8135, -11.4973, -14.3091>, <-0.294, 0.422, -0.857>, <266.7000, -9.1330, -12.7524>, <0.001, 0.288, -0.958> }
	smooth_triangle { <256.0599, -8.7691, -17.2431>, <-0.747, -0.536, 0.393>, <258.6259, -9.1069, -12.7524>, <-0.324, -0.721, 0.613>, <259.4294, -11.2790, -17.0036>, <-0.800, -0.600, -0.011> }
	smooth_triangle { <259.4294, -11.2790, -17.0036>, <0.553, 0.772, 0.313>, <260.9690, -11.4817, -14.3091>, <0.571, 0.535, -0.623>, <258.6259, -9.1069, -12.7524>, <0.751, 0.534, -0.389> }
	smooth_triangle { <256.0599, -8.7691, -17.2431>, <0.388, 0.245, 0.889>, <262.5482, -8.5865, -20.0186>, <-0.155, 0.191, 0.969>, <259.4294, -11.2790, -17.0036>, <0.583, 0.505, 0.637> }
	smooth_triangle { <259.4294, -11.2790, -17.0036>, <-0.553, -0.772, -0.313>, <263.3224, -11.1694, -18.6688>, <-0.119, -0.046, -0.992>, <262.5482, -8.5865, -20.0186>, <-0.134, -0.300, -0.945> }
	smooth_triangle { <267.2680, -11.3044, -17.0036>, <0.387, -0.047, -0.921>, <263.3224, -11.1694, -18.6688>, <-0.119, -0.046, -0.992>, <272.5165, -25.6701, -18.9081>, <0.336, -0.196, -0.921> }
	smooth_triangle { <272.5165, -25.6701, -18.9081>, <-0.410, -0.275, 0.870>, <265.8951, -24.5617, -21.6836>, <-0.353, 0.188, 0.917>, <263.3224, -11.1694, -18.6688>, <-0.139, -0.026, 0.990> }
	smooth_triangle { <265.8135, -11.4973, -14.3091>, <0.652, -0.119, 0.749>, <267.2680, -11.3044, -17.0036>, <0.846, 0.246, 0.474>, <269.9831, -25.6478, -14.4174>, <0.846, 0.246, 0.474> }
	smooth_triangle { <269.9831, -25.6478, -14.4174>, <-0.492, -0.138, -0.860>, <272.5165, -25.6701, -18.9081>, <-0.845, -0.246, -0.475>, <267.2680, -11.3044, -17.0036>, <-0.874, 0.155, -0.461> }
	smooth_triangle { <260.9690, -11.4817, -14.3091>, <-0.340, -0.243, 0.909>, <265.8135, -11.4973, -14.3091>, <0.652, -0.119, 0.749>, <261.7959, -24.5256, -14.4174>, <-0.051, -0.377, 0.925> }
	smooth_triangle { <261.7959, -24.5256, -14.4174>, <0.508, 0.039, -0.861>, <269.9831, -25.6478, -14.4174>, <-0.317, 0.192, -0.929>, <265.8135, -11.4973, -14.3091>, <-0.294, 0.422, -0.857> }
	smooth_triangle { <259.4294, -11.2790, -17.0036>, <-0.790, -0.448, 0.418>, <260.9690, -11.4817, -14.3091>, <-0.340, -0.243, 0.909>, <259.2693, -23.8544, -18.9081>, <-0.799, -0.459, 0.388> }
	smooth_triangle { <259.2693, -23.8544, -18.9081>, <0.874, 0.059, -0.483>, <261.7959, -24.5256, -14.4174>, <0.612, 0.351, -0.709>, <260.9690, -11.4817, -14.3091>, <0.571, 0.535, -0.623> }
	smooth_triangle { <259.4294, -11.2790, -17.0036>, <0.381, 0.196, 0.904>, <263.3224, -11.1694, -18.6688>, <-0.139, -0.026, 0.990>, <259.2693, -23.8544, -18.9081>, <0.409, 0.252, 0.877> }
	smooth_triangle { <259.2693, -23.8544, -18.9081>, <-0.370, 0.136, -0.919>, <265.8951, -24.5617, -21.6836>, <-0.192, -0.404, -0.894>, <263.3224, -11.1694, -18.6688>, <-0.119, -0.046, -0.992> }
	smooth_triangle { <272.5165, -25.6701, -18.9081>, <0.507, -0.563, -0.653>, <265.8951, -24.5617, -21.6836>, <-0.192, -0.404, -0.894>, <269.9978, -26.9798, -18.5829>, <0.125, -0.907, -0.403> }
	smooth_triangle { <269.9978, -26.9798, -18.5829>, <-0.305, 0.938, 0.165>, <266.0249, -26.3148, -20.2482>, <0.010, 0.830, 0.558>, <265.8951, -24.5617, -21.6836>, <-0.105, 0.371, 0.923> }
	smooth_triangle { <269.9831, -25.6478, -14.4174>, <0.203, -0.823, 0.531>, <272.5165, -25.6701, -18.9081>, <0.411, -0.863, -0.294>, <268.4778, -26.9664, -15.8885>, <0.156, -0.958, 0.239> }
	smooth_triangle { <268.4778, -26.9664, -15.8885>, <-0.089, 0.874, -0.477>, <269.9978, -26.9798, -18.5829>, <-0.305, 0.938, 0.165>, <272.5165, -25.6701, -18.9081>, <-0.471, 0.840, -0.270> }
	smooth_triangle { <261.7959, -24.5256, -14.4174>, <-0.272, -0.583, 0.765>, <269.9831, -25.6478, -14.4174>, <0.203, -0.823, 0.531>, <263.5654, -26.2931, -15.8885>, <-0.211, -0.891, 0.402> }
	smooth_triangle { <263.5654, -26.2931, -15.8885>, <0.380, 0.852, -0.360>, <268.4778, -26.9664, -15.8885>, <-0.089, 0.874, -0.477>, <269.9831, -25.6478, -14.4174>, <0.052, 0.377, -0.925> }
	smooth_triangle { <259.2693, -23.8544, -18.9081>, <-0.799, -0.459, 0.388>, <261.7959, -24.5256, -14.4174>, <-0.368, -0.784, 0.500>, <262.0495, -25.8904, -18.5829>, <-0.495, -0.855, -0.154> }
	smooth_triangle { <262.0495, -25.8904, -18.5829>, <0.451, 0.827, 0.336>, <263.5654, -26.2931, -15.8885>, <0.380, 0.852, -0.360>, <261.7959, -24.5256, -14.4174>, <0.803, 0.457, -0.383> }
	smooth_triangle { <259.2693, -23.8544, -18.9081>, <0.409, 0.252, 0.877>, <265.8951, -24.5617, -21.6836>, <0.075, 0.635, 0.769>, <262.0495, -25.8904, -18.5829>, <0.451, 0.827, 0.336> }
	smooth_triangle { <262.0495, -25.8904, -18.5829>, <-0.495, -0.855, -0.154>, <266.0249, -26.3148, -20.2482>, <-0.210, -0.820, -0.533>, <265.8951, -24.5617, -21.6836>, <-0.192, -0.404, -0.894> }
	smooth_triangle { <269.9978, -26.9798, -18.5829>, <0.125, -0.907, -0.403>, <266.0249, -26.3148, -20.2482>, <-0.210, -0.820, -0.533>, <266.2320, -27.3411, -17.9983>, <0.023, -0.909, -0.417> }
	smooth_triangle { <266.2320, -27.3411, -17.9983>, <-0.066, 0.981, 0.182>, <265.8347, -27.2746, -18.1648>, <-0.022, 0.909, 0.417>, <266.0249, -26.3148, -20.2482>, <0.010, 0.830, 0.558> }
	smooth_triangle { <268.4778, -26.9664, -15.8885>, <0.156, -0.958, 0.239>, <269.9978, -26.9798, -18.5829>, <0.125, -0.907, -0.403>, <266.0800, -27.3398, -17.7289>, <0.105, -0.992, 0.064> }
	smooth_triangle { <266.0800, -27.3398, -17.7289>, <0.011, 0.977, -0.213>, <266.2320, -27.3411, -17.9983>, <-0.066, 0.981, 0.182>, <269.9978, -26.9798, -18.5829>, <-0.305, 0.938, 0.165> }
	smooth_triangle { <263.5654, -26.2931, -15.8885>, <-0.211, -0.891, 0.402>, <268.4778, -26.9664, -15.8885>, <0.156, -0.958, 0.239>, <265.5888, -27.2724, -17.7289>, <-0.127, -0.927, 0.353> }
	smooth_triangle { <265.5888, -27.2724, -17.7289>, <0.257, 0.941, -0.218>, <266.0800, -27.3398, -17.7289>, <0.011, 0.977, -0.213>, <268.4778, -26.9664, -15.8885>, <-0.089, 0.874, -0.477> }
	smooth_triangle { <262.0495, -25.8904, -18.5829>, <-0.495, -0.855, -0.154>, <263.5654, -26.2931, -15.8885>, <-0.211, -0.891, 0.402>, <265.4372, -27.2322, -17.9983>, <-0.335, -0.925, -0.180> }
	smooth_triangle { <265.4372, -27.2322, -17.9983>, <0.335, 0.925, 0.180>, <265.5888, -27.2724, -17.7289>, <0.257, 0.941, -0.218>, <263.5654, -26.2931, -15.8885>, <0.380, 0.852, -0.360> }
	smooth_triangle { <262.0495, -25.8904, -18.5829>, <0.451, 0.827, 0.336>, <266.0249, -26.3148, -20.2482>, <0.010, 0.830, 0.558>, <265.4372, -27.2322, -17.9983>, <0.335, 0.925, 0.180> }
	smooth_triangle { <265.4372, -27.2322, -17.9983>, <-0.335, -0.925, -0.180>, <265.8347, -27.2746, -18.1648>, <-0.270, -0.865, -0.423>, <266.0249, -26.3148, -20.2482>, <-0.210, -0.820, -0.533> }

	texture { CUSTOM_TUBE_bl }
}

/* Object 'CUSTOM2' */
union {
	smooth_triangle { <188.9224, 61.7959, -11.8687>, <0.218, 0.444, 0.869>, <190.0000, 65.6343, -14.0975>, <0.063, -0.019, 0.998>, <200.1876, 56.7538, -12.1179>, <0.203, 0.448, 0.870> }
	smooth_triangle { <200.1876, 56.7538, -12.1179>, <-0.218, -0.444, -0.869>, <201.5346, 61.5519, -14.9039>, <-0.139, -0.233, -0.962>, <190.0000, 65.6343, -14.0975>, <-0.063, 0.019, -0.998> }
	smooth_triangle { <189.3340, 63.2620, -8.2624>, <0.252, 0.498, -0.830>, <188.9224, 61.7959, -11.8687>, <0.370, 0.845, -0.386>, <200.7021, 58.5865, -7.6100>, <0.240, 0.678, -0.694> }
	smooth_triangle { <200.7021, 58.5865, -7.6100>, <-0.151, -0.322, 0.935>, <200.1876, 56.7538, -12.1179>, <-0.326, -0.888, 0.326>, <188.9224, 61.7959, -11.8687>, <-0.370, -0.845, 0.386> }
	smooth_triangle { <190.6660, 68.0066, -8.2624>, <-0.115, -0.542, -0.833>, <189.3340, 63.2620, -8.2624>, <0.252, 0.498, -0.830>, <202.3671, 64.5173, -7.6100>, <-0.127, -0.337, -0.933> }
	smooth_triangle { <202.3671, 64.5173, -7.6100>, <0.115, 0.542, 0.833>, <200.7021, 58.5865, -7.6100>, <-0.151, -0.322, 0.935>, <189.3340, 63.2620, -8.2624>, <-0.051, 0.014, 0.999> }
	smooth_triangle { <191.0776, 69.4728, -11.8687>, <-0.243, -0.889, -0.389>, <190.6660, 68.0066, -8.2624>, <-0.115, -0.542, -0.833>, <202.8816, 66.3500, -12.1179>, <-0.294, -0.873, -0.389> }
	smooth_triangle { <202.8816, 66.3500, -12.1179>, <0.243, 0.889, 0.389>, <202.3671, 64.5173, -7.6100>, <0.212, 0.724, 0.656>, <190.6660, 68.0066, -8.2624>, <0.243, 0.889, 0.389> }
	smooth_triangle { <191.0776, 69.4728, -11.8687>, <0.108, 0.476, -0.873>, <190.0000, 65.6343, -14.0975>, <-0.063, 0.019, -0.998>, <202.8816, 66.3500, -12.1179>, <0.117, 0.474, -0.873> }
	smooth_triangle { <202.8816, 66.3500, -12.1179>, <-0.108, -0.476, 0.873>, <201.5346, 61.5519, -14.9039>, <-0.032, -0.250, 0.968>, <190.0000, 65.6343, -14.0975>, <0.063, -0.019, 0.998> }
	smooth_triangle { <200.1876, 56.7538, -12.1179>, <0.203, 0.448, 0.870>, <201.5346, 61.5519, -14.9039>, <-0.032, -0.250, 0.968>, <246.4700, 42.0588, -14.5271>, <0.090, 0.533, 0.841> }
	smooth_triangle { <246.4700, 42.0588, -14.5271>, <-0.207, -0.976, -0.064>, <245.3242, 46.4437, -17.8704>, <-0.136, -0.634, -0.761>, <201.5346, 61.5519, -14.9039>, <-0.244, -0.539, -0.806> }
	smooth_triangle { <200.7021, 58.5865, -7.6100>, <0.240, 0.678, -0.694>, <200.1876, 56.7538, -12.1179>, <0.275, 0.879, -0.389>, <246.0323, 43.7337, -9.1176>, <0.100, 0.732, -0.674> }
	smooth_triangle { <246.0323, 43.7337, -9.1176>, <-0.279, -0.923, 0.263>, <246.4700, 42.0588, -14.5271>, <-0.207, -0.976, -0.064>, <200.1876, 56.7538, -12.1179>, <-0.326, -0.888, 0.326> }
	smooth_triangle { <202.3671, 64.5173, -7.6100>, <-0.127, -0.337, -0.933>, <200.7021, 58.5865, -7.6100>, <0.240, 0.678, -0.694>, <244.6160, 49.1537, -9.1176>, <-0.018, 0.004, -1.000> }
	smooth_triangle { <244.6160, 49.1537, -9.1176>, <0.036, 0.009, 0.999>, <246.0323, 43.7337, -9.1176>, <0.019, 0.006, 1.000>, <200.7021, 58.5865, -7.6100>, <-0.151, -0.322, 0.935> }
	smooth_triangle { <202.8816, 66.3500, -12.1179>, <-0.294, -0.873, -0.389>, <202.3671, 64.5173, -7.6100>, <-0.127, -0.337, -0.933>, <244.1783, 50.8286, -14.5271>, <-0.198, -0.918, -0.344> }
	smooth_triangle { <244.1783, 50.8286, -14.5271>, <0.224, 0.919, -0.325>, <244.6160, 49.1537, -9.1176>, <0.174, 0.948, 0.265>, <202.3671, 64.5173, -7.6100>, <0.292, 0.901, 0.322> }
	smooth_triangle { <202.8816, 66.3500, -12.1179>, <0.117, 0.474, -0.873>, <201.5346, 61.5519, -14.9039>, <-0.052, 0.016, -0.998>, <244.1783, 50.8286, -14.5271>, <0.079, 0.544, -0.836> }
	smooth_triangle { <244.1783, 50.8286, -14.5271>, <-0.127, -0.951, 0.284>, <245.3242, 46.4437, -17.8704>, <-0.087, -0.624, 0.776>, <201.5346, 61.5519, -14.9039>, <-0.032, -0.250, 0.968> }
	smooth_triangle { <246.4700, 42.0588, -14.5271>, <0.090, 0.533, 0.841>, <245.3242, 46.4437, -17.8704>, <-0.011, 0.605, 0.797>, <256.2126, 42.2235, -14.5214>, <-0.352, 0.324, 0.878> }
	smooth_triangle { <256.2126, 42.2235, -14.5214>, <0.007, -0.958, -0.287>, <251.8761, 46.3742, -17.8519>, <0.346, -0.340, -0.874>, <245.3242, 46.4437, -17.8704>, <-0.136, -0.634, -0.761> }
	smooth_triangle { <246.0323, 43.7337, -9.1176>, <0.129, 0.929, -0.348>, <246.4700, 42.0588, -14.5271>, <-0.021, 0.955, -0.297>, <254.9457, 43.9269, -9.1325>, <-0.570, 0.738, -0.362> }
	smooth_triangle { <254.9457, 43.9269, -9.1325>, <0.016, -0.952, 0.305>, <256.2126, 42.2235, -14.5214>, <0.449, -0.890, -0.084>, <246.4700, 42.0588, -14.5271>, <-0.207, -0.976, -0.064> }
	smooth_triangle { <244.6160, 49.1537, -9.1176>, <-0.018, 0.004, -1.000>, <246.0323, 43.7337, -9.1176>, <0.163, 0.527, -0.834>, <249.8262, 49.1303, -9.1325>, <-0.305, -0.299, -0.904> }
	smooth_triangle { <249.8262, 49.1303, -9.1325>, <0.002, 0.002, 1.000>, <254.9457, 43.9269, -9.1325>, <0.305, 0.300, 0.904>, <246.0323, 43.7337, -9.1176>, <0.019, 0.006, 1.000> }
	smooth_triangle { <244.1783, 50.8286, -14.5271>, <-0.222, -0.974, 0.034>, <244.6160, 49.1537, -9.1176>, <-0.047, -0.955, -0.292>, <247.9291, 50.6429, -14.5214>, <-0.164, -0.976, 0.141> }
	smooth_triangle { <247.9291, 50.6429, -14.5214>, <0.155, 0.899, -0.410>, <249.8262, 49.1303, -9.1325>, <0.188, 0.961, 0.204>, <244.6160, 49.1537, -9.1176>, <0.174, 0.948, 0.265> }
	smooth_triangle { <244.1783, 50.8286, -14.5271>, <0.199, 0.799, -0.567>, <245.3242, 46.4437, -17.8704>, <0.031, 0.611, -0.791>, <247.9291, 50.6429, -14.5214>, <0.155, 0.899, -0.410> }
	smooth_triangle { <247.9291, 50.6429, -14.5214>, <-0.164, -0.976, 0.141>, <251.8761, 46.3742, -17.8519>, <-0.366, -0.515, 0.775>, <245.3242, 46.4437, -17.8704>, <-0.087, -0.624, 0.776> }
	smooth_triangle { <256.2126, 42.2235, -14.5214>, <-0.352, 0.324, 0.878>, <251.8761, 46.3742, -17.8519>, <-0.366, -0.515, 0.775>, <256.6186, 44.0724, -14.1455>, <-0.348, 0.338, 0.874> }
	smooth_triangle { <256.6186, 44.0724, -14.1455>, <0.622, 0.022, -0.782>, <254.0166, 46.5629, -16.1438>, <0.108, -0.105, -0.989>, <251.8761, 46.3742, -17.8519>, <0.423, 0.066, -0.904> }
	smooth_triangle { <254.9457, 43.9269, -9.1325>, <-0.727, 0.330, -0.602>, <256.2126, 42.2235, -14.5214>, <-0.918, 0.262, -0.299>, <255.8584, 45.0945, -10.9121>, <-0.653, 0.665, -0.364> }
	smooth_triangle { <255.8584, 45.0945, -10.9121>, <0.833, 0.158, 0.531>, <256.6186, 44.0724, -14.1455>, <0.653, -0.665, 0.364>, <256.2126, 42.2235, -14.5214>, <0.567, -0.738, 0.366> }
	smooth_triangle { <249.8262, 49.1303, -9.1325>, <-0.371, -0.592, -0.715>, <254.9457, 43.9269, -9.1325>, <-0.833, -0.158, -0.531>, <252.7867, 48.2165, -10.9121>, <-0.079, -0.573, -0.816> }
	smooth_triangle { <252.7867, 48.2165, -10.9121>, <0.206, 0.878, 0.432>, <255.8584, 45.0945, -10.9121>, <0.604, 0.120, 0.788>, <254.9457, 43.9269, -9.1325>, <0.305, 0.300, 0.904> }
	smooth_triangle { <247.9291, 50.6429, -14.5214>, <-0.164, -0.976, 0.141>, <249.8262, 49.1303, -9.1325>, <-0.484, -0.775, -0.407>, <251.6485, 49.1240, -14.1455>, <-0.139, -0.990, 0.015> }
	smooth_triangle { <251.6485, 49.1240, -14.1455>, <0.388, 0.896, -0.218>, <252.7867, 48.2165, -10.9121>, <0.206, 0.878, 0.432>, <249.8262, 49.1303, -9.1325>, <0.188, 0.961, 0.204> }
	smooth_triangle { <247.9291, 50.6429, -14.5214>, <0.155, 0.899, -0.410>, <251.8761, 46.3742, -17.8519>, <0.540, 0.428, -0.725>, <251.6485, 49.1240, -14.1455>, <0.153, 0.836, -0.527> }
	smooth_triangle { <251.6485, 49.1240, -14.1455>, <-0.388, -0.896, 0.218>, <254.0166, 46.5629, -16.1438>, <-0.004, -0.618, 0.786>, <251.8761, 46.3742, -17.8519>, <-0.366, -0.515, 0.775> }
	smooth_triangle { <256.6186, 44.0724, -14.1455>, <-0.348, 0.338, 0.874>, <254.0166, 46.5629, -16.1438>, <0.209, 0.164, 0.964>, <272.2112, 47.1352, -16.6222>, <-0.328, 0.359, 0.874> }
	smooth_triangle { <272.2112, 47.1352, -16.6222>, <-0.001, -0.626, -0.780>, <267.8747, 51.2859, -19.9527>, <0.328, -0.359, -0.874>, <254.0166, 46.5629, -16.1438>, <0.108, -0.105, -0.989> }
	smooth_triangle { <255.8584, 45.0945, -10.9121>, <-0.653, 0.665, -0.364>, <256.6186, 44.0724, -14.1455>, <-0.233, 0.910, -0.342>, <270.9443, 48.8386, -11.2332>, <-0.667, 0.651, -0.363> }
	smooth_triangle { <270.9443, 48.8386, -11.2332>, <0.233, -0.910, 0.342>, <272.2112, 47.1352, -16.6222>, <0.667, -0.651, 0.363>, <256.6186, 44.0724, -14.1455>, <0.653, -0.665, 0.364> }
	smooth_triangle { <252.7867, 48.2165, -10.9121>, <-0.079, -0.573, -0.816>, <255.8584, 45.0945, -10.9121>, <-0.017, -0.017, -1.000>, <265.8249, 54.0420, -11.2332>, <-0.269, -0.264, -0.926> }
	smooth_triangle { <265.8249, 54.0420, -11.2332>, <-0.213, 0.523, 0.825>, <270.9443, 48.8386, -11.2332>, <0.269, 0.264, 0.926>, <255.8584, 45.0945, -10.9121>, <0.312, 0.306, 0.899> }
	smooth_triangle { <251.6485, 49.1240, -14.1455>, <0.004, -0.962, -0.272>, <252.7867, 48.2165, -10.9121>, <-0.079, -0.573, -0.816>, <263.9277, 55.5545, -16.6222>, <0.088, -0.951, -0.298> }
	smooth_triangle { <263.9277, 55.5545, -16.6222>, <-0.371, 0.852, 0.370>, <265.8249, 54.0420, -11.2332>, <-0.062, 0.758, 0.650>, <252.7867, 48.2165, -10.9121>, <0.206, 0.878, 0.432> }
	smooth_triangle { <251.6485, 49.1240, -14.1455>, <0.004, 0.618, -0.786>, <254.0166, 46.5629, -16.1438>, <0.108, -0.105, -0.989>, <263.9277, 55.5545, -16.6222>, <-0.075, 0.569, -0.819> }
	smooth_triangle { <263.9277, 55.5545, -16.6222>, <0.357, -0.347, 0.867>, <267.8747, 51.2859, -19.9527>, <-0.175, -0.401, 0.899>, <254.0166, 46.5629, -16.1438>, <-0.003, -0.214, 0.977> }
	smooth_triangle { <272.2112, 47.1352, -16.6222>, <-0.328, 0.359, 0.874>, <267.8747, 51.2859, -19.9527>, <-0.175, -0.401, 0.899>, <272.7184, 49.6285, -16.3204>, <-0.322, 0.365, 0.874> }
	smooth_triangle { <272.7184, 49.6285, -16.3204>, <0.595, -0.024, -0.804>, <270.1165, 52.1189, -18.3187>, <0.086, -0.146, -0.985>, <267.8747, 51.2859, -19.9527>, <0.339, 0.028, -0.940> }
	smooth_triangle { <270.9443, 48.8386, -11.2332>, <-0.737, 0.293, -0.609>, <272.2112, 47.1352, -16.6222>, <-0.930, 0.224, -0.290>, <271.9583, 50.6505, -13.0870>, <-0.654, 0.663, -0.363> }
	smooth_triangle { <271.9583, 50.6505, -13.0870>, <0.802, 0.144, 0.579>, <272.7184, 49.6285, -16.3204>, <0.654, -0.663, 0.363>, <272.2112, 47.1352, -16.6222>, <0.667, -0.651, 0.363> }
	smooth_triangle { <265.8249, 54.0420, -11.2332>, <-0.281, -0.577, -0.767>, <270.9443, 48.8386, -11.2332>, <-0.802, -0.144, -0.579>, <268.8866, 53.7726, -13.0870>, <-0.050, -0.536, -0.843> }
	smooth_triangle { <268.8866, 53.7726, -13.0870>, <0.121, 0.865, 0.487>, <271.9583, 50.6505, -13.0870>, <0.571, 0.103, 0.814>, <270.9443, 48.8386, -11.2332>, <0.269, 0.264, 0.926> }
	smooth_triangle { <263.9277, 55.5545, -16.6222>, <0.088, -0.951, -0.298>, <265.8249, 54.0420, -11.2332>, <-0.374, -0.779, -0.504>, <267.7483, 54.6801, -16.3204>, <-0.023, -0.999, 0.038> }
	smooth_triangle { <267.7483, 54.6801, -16.3204>, <0.235, 0.937, -0.260>, <268.8866, 53.7726, -13.0870>, <0.121, 0.865, 0.487>, <265.8249, 54.0420, -11.2332>, <-0.088, 0.951, 0.298> }
	smooth_triangle { <263.9277, 55.5545, -16.6222>, <-0.075, 0.569, -0.819>, <267.8747, 51.2859, -19.9527>, <0.447, 0.382, -0.809>, <267.7483, 54.6801, -16.3204>, <0.021, 0.833, -0.552> }
	smooth_triangle { <267.7483, 54.6801, -16.3204>, <-0.235, -0.937, 0.260>, <270.1165, 52.1189, -18.3187>, <0.073, -0.555, 0.829>, <267.8747, 51.2859, -19.9527>, <-0.175, -0.401, 0.899> }
	smooth_triangle { <272.7184, 49.6285, -16.3204>, <-0.322, 0.365, 0.874>, <270.1165, 52.1189, -18.3187>, <0.212, 0.185, 0.960>, <287.3461, 51.9735, -18.5174>, <-0.313, 0.328, 0.891> }
	smooth_triangle { <287.3461, 51.9735, -18.5174>, <0.111, -0.963, -0.245>, <282.2564, 55.7753, -21.8479>, <0.315, -0.350, -0.882>, <270.1165, 52.1189, -18.3187>, <0.086, -0.146, -0.985> }
	smooth_triangle { <271.9583, 50.6505, -13.0870>, <-0.654, 0.663, -0.363>, <272.7184, 49.6285, -16.3204>, <-0.198, 0.920, -0.337>, <285.7282, 53.6001, -13.1285>, <-0.683, 0.617, -0.391> }
	smooth_triangle { <285.7282, 53.6001, -13.1285>, <0.198, -0.920, 0.337>, <287.3461, 51.9735, -18.5174>, <0.552, -0.833, -0.044>, <272.7184, 49.6285, -16.3204>, <0.654, -0.663, 0.363> }
	smooth_triangle { <268.8866, 53.7726, -13.0870>, <-0.050, -0.536, -0.843>, <271.9583, 50.6505, -13.0870>, <-0.003, -0.003, -1.000>, <279.6387, 58.4072, -13.1285>, <-0.231, -0.292, -0.928> }
	smooth_triangle { <279.6387, 58.4072, -13.1285>, <-0.222, 0.521, 0.824>, <285.7282, 53.6001, -13.1285>, <0.231, 0.292, 0.928>, <271.9583, 50.6505, -13.0870>, <0.262, 0.258, 0.930> }
	smooth_triangle { <267.7483, 54.6801, -16.3204>, <0.083, -0.951, -0.296>, <268.8866, 53.7726, -13.0870>, <-0.050, -0.536, -0.843>, <277.4930, 59.7515, -18.5174>, <0.120, -0.950, -0.290> }
	smooth_triangle { <277.4930, 59.7515, -18.5174>, <-0.368, 0.857, 0.360>, <279.6387, 58.4072, -13.1285>, <-0.097, 0.760, 0.643>, <268.8866, 53.7726, -13.0870>, <0.121, 0.865, 0.487> }
	smooth_triangle { <267.7483, 54.6801, -16.3204>, <-0.082, 0.565, -0.821>, <270.1165, 52.1189, -18.3187>, <0.086, -0.146, -0.985>, <277.4930, 59.7515, -18.5174>, <-0.114, 0.571, -0.813> }
	smooth_triangle { <277.4930, 59.7515, -18.5174>, <0.352, -0.317, 0.881>, <282.2564, 55.7753, -21.8479>, <-0.143, -0.419, 0.896>, <270.1165, 52.1189, -18.3187>, <0.063, -0.169, 0.983> }
	smooth_triangle { <287.3461, 51.9735, -18.5174>, <-0.313, 0.328, 0.891>, <282.2564, 55.7753, -21.8479>, <-0.143, -0.419, 0.896>, <287.5424, 54.4693, -18.2299>, <-0.357, 0.298, 0.885> }
	smooth_triangle { <287.5424, 54.4693, -18.2299>, <0.572, 0.049, -0.818>, <284.4886, 56.7504, -20.2282>, <0.088, -0.148, -0.985>, <282.2564, 55.7753, -21.8479>, <0.306, 0.050, -0.951> }
	smooth_triangle { <285.7282, 53.6001, -13.1285>, <-0.731, 0.229, -0.643>, <287.3461, 51.9735, -18.5174>, <-0.942, 0.111, -0.316>, <286.5717, 55.4453, -14.9965>, <-0.746, 0.541, -0.387> }
	smooth_triangle { <286.5717, 55.4453, -14.9965>, <0.772, 0.242, 0.588>, <287.5424, 54.4693, -18.2299>, <0.746, -0.541, 0.388>, <287.3461, 51.9735, -18.5174>, <0.683, -0.617, 0.391> }
	smooth_triangle { <279.6387, 58.4072, -13.1285>, <-0.224, -0.605, -0.764>, <285.7282, 53.6001, -13.1285>, <-0.772, -0.242, -0.588>, <282.9179, 58.3295, -14.9965>, <0.045, -0.517, -0.855> }
	smooth_triangle { <282.9179, 58.3295, -14.9965>, <0.003, 0.864, 0.503>, <286.5717, 55.4453, -14.9965>, <0.550, 0.176, 0.817>, <285.7282, 53.6001, -13.1285>, <0.231, 0.292, 0.928> }
	smooth_triangle { <277.4930, 59.7515, -18.5174>, <0.120, -0.950, -0.290>, <279.6387, 58.4072, -13.1285>, <-0.301, -0.816, -0.494>, <281.6305, 59.1361, -18.2299>, <0.105, -0.994, 0.027> }
	smooth_triangle { <281.6305, 59.1361, -18.2299>, <0.160, 0.952, -0.260>, <282.9179, 58.3295, -14.9965>, <0.003, 0.864, 0.503>, <279.6387, 58.4072, -13.1285>, <-0.123, 0.950, 0.286> }
	smooth_triangle { <277.4930, 59.7515, -18.5174>, <-0.114, 0.571, -0.813>, <282.2564, 55.7753, -21.8479>, <0.399, 0.431, -0.809>, <281.6305, 59.1361, -18.2299>, <-0.065, 0.818, -0.572> }
	smooth_triangle { <281.6305, 59.1361, -18.2299>, <-0.160, -0.952, 0.260>, <284.4886, 56.7504, -20.2282>, <0.143, -0.511, 0.848>, <282.2564, 55.7753, -21.8479>, <-0.143, -0.419, 0.896> }
	smooth_triangle { <287.5424, 54.4693, -18.2299>, <-0.357, 0.298, 0.885>, <284.4886, 56.7504, -20.2282>, <0.190, 0.226, 0.956>, <300.6660, 59.3297, -20.5154>, <-0.080, 0.594, 0.801> }
	smooth_triangle { <300.6660, 59.3297, -20.5154>, <0.086, -0.626, -0.775>, <294.9778, 62.6670, -23.8459>, <0.086, -0.626, -0.775>, <284.4886, 56.7504, -20.2282>, <0.088, -0.148, -0.985> }
	smooth_triangle { <286.5717, 55.4453, -14.9965>, <-0.566, 0.404, -0.718>, <287.5424, 54.4693, -18.2299>, <-0.379, 0.848, -0.370>, <298.7463, 60.8302, -15.1264>, <-0.379, 0.848, -0.370> }
	smooth_triangle { <298.7463, 60.8302, -15.1264>, <0.233, -0.507, 0.830>, <300.6660, 59.3297, -20.5154>, <-0.152, -0.765, 0.625>, <287.5424, 54.4693, -18.2299>, <0.746, -0.541, 0.388> }
	smooth_triangle { <282.9179, 58.3295, -14.9965>, <0.045, -0.517, -0.855>, <286.5717, 55.4453, -14.9965>, <-0.234, 0.508, -0.829>, <291.8716, 65.0948, -15.1264>, <-0.247, -0.397, -0.884> }
	smooth_triangle { <291.8716, 65.0948, -15.1264>, <-0.326, 0.447, 0.833>, <298.7463, 60.8302, -15.1264>, <0.387, -0.067, 0.920>, <286.5717, 55.4453, -14.9965>, <0.232, 0.295, 0.927> }
	smooth_triangle { <281.6305, 59.1361, -18.2299>, <0.223, -0.921, -0.319>, <282.9179, 58.3295, -14.9965>, <0.045, -0.517, -0.855>, <289.5425, 66.2300, -20.5154>, <0.222, -0.929, -0.297> }
	smooth_triangle { <289.5425, 66.2300, -20.5154>, <-0.551, 0.736, 0.393>, <291.8716, 65.0948, -15.1264>, <-0.174, 0.735, 0.656>, <282.9179, 58.3295, -14.9965>, <0.003, 0.864, 0.503> }
	smooth_triangle { <281.6305, 59.1361, -18.2299>, <-0.155, 0.518, -0.841>, <284.4886, 56.7504, -20.2282>, <0.088, -0.148, -0.985>, <289.5425, 66.2300, -20.5154>, <-0.140, 0.573, -0.807> }
	smooth_triangle { <289.5425, 66.2300, -20.5154>, <0.416, -0.195, 0.888>, <294.9778, 62.6670, -23.8459>, <-0.156, -0.552, 0.819>, <284.4886, 56.7504, -20.2282>, <0.076, -0.142, 0.987> }
	smooth_triangle { <300.6660, 59.3297, -20.5154>, <-0.529, -0.760, 0.378>, <294.9778, 62.6670, -23.8459>, <-0.156, -0.552, 0.819>, <299.6082, 61.5627, -20.1251>, <-0.680, -0.658, 0.324> }
	smooth_triangle { <299.6082, 61.5627, -20.1251>, <0.815, 0.560, -0.148>, <296.1952, 63.5650, -22.1234>, <0.564, 0.700, -0.438>, <294.9778, 62.6670, -23.8459>, <0.429, 0.641, -0.637> }
	smooth_triangle { <298.7463, 60.8302, -15.1264>, <-0.705, -0.575, -0.416>, <300.6660, 59.3297, -20.5154>, <-0.857, -0.450, 0.252>, <298.4563, 62.4630, -16.8918>, <-0.724, -0.667, -0.175> }
	smooth_triangle { <298.4563, 62.4630, -16.8918>, <0.647, 0.671, 0.363>, <299.6082, 61.5627, -20.1251>, <0.815, 0.560, -0.148>, <300.6660, 59.3297, -20.5154>, <0.897, 0.388, 0.212> }
	smooth_triangle { <291.8716, 65.0948, -15.1264>, <-0.232, -0.681, -0.695>, <298.7463, 60.8302, -15.1264>, <-0.705, -0.575, -0.416>, <294.3315, 65.0217, -16.8918>, <-0.442, -0.845, -0.300> }
	smooth_triangle { <294.3315, 65.0217, -16.8918>, <0.316, 0.910, 0.268>, <298.4563, 62.4630, -16.8918>, <0.647, 0.671, 0.363>, <298.7463, 60.8302, -15.1264>, <0.246, 0.397, 0.884> }
	smooth_triangle { <289.5425, 66.2300, -20.5154>, <0.222, -0.929, -0.297>, <291.8716, 65.0948, -15.1264>, <-0.297, -0.877, -0.377>, <292.9341, 65.7028, -20.1251>, <-0.235, -0.964, 0.126> }
	smooth_triangle { <292.9341, 65.7028, -20.1251>, <0.251, 0.936, -0.249>, <294.3315, 65.0217, -16.8918>, <0.316, 0.910, 0.268>, <291.8716, 65.0948, -15.1264>, <-0.225, 0.929, 0.293> }
	smooth_triangle { <289.5425, 66.2300, -20.5154>, <-0.140, 0.573, -0.807>, <294.9778, 62.6670, -23.8459>, <0.429, 0.641, -0.637>, <292.9341, 65.7028, -20.1251>, <0.251, 0.936, -0.249> }
	smooth_triangle { <292.9341, 65.7028, -20.1251>, <-0.235, -0.964, 0.126>, <296.1952, 63.5650, -22.1234>, <-0.405, -0.824, 0.396>, <294.9778, 62.6670, -23.8459>, <-0.156, -0.552, 0.819> }
	smooth_triangle { <299.6082, 61.5627, -20.1251>, <-0.680, -0.658, 0.324>, <296.1952, 63.5650, -22.1234>, <-0.405, -0.824, 0.396>, <297.0065, 64.0125, -19.4236>, <-0.608, -0.733, 0.304> }
	smooth_triangle { <297.0065, 64.0125, -19.4236>, <0.661, 0.739, -0.132>, <296.6652, 64.2128, -19.6234>, <0.608, 0.733, -0.304>, <296.1952, 63.5650, -22.1234>, <0.564, 0.700, -0.438> }
	smooth_triangle { <298.4563, 62.4630, -16.8918>, <-0.724, -0.667, -0.175>, <299.6082, 61.5627, -20.1251>, <-0.680, -0.658, 0.324>, <296.8914, 64.1025, -19.1002>, <-0.691, -0.721, -0.045> }
	smooth_triangle { <296.8914, 64.1025, -19.1002>, <0.607, 0.780, 0.149>, <297.0065, 64.0125, -19.4236>, <0.661, 0.739, -0.132>, <299.6082, 61.5627, -20.1251>, <0.815, 0.560, -0.148> }
	smooth_triangle { <294.3315, 65.0217, -16.8918>, <-0.442, -0.845, -0.300>, <298.4563, 62.4630, -16.8918>, <-0.724, -0.667, -0.175>, <296.4789, 64.3584, -19.1002>, <-0.511, -0.823, -0.249> }
	smooth_triangle { <296.4789, 64.3584, -19.1002>, <0.430, 0.890, 0.151>, <296.8914, 64.1025, -19.1002>, <0.607, 0.780, 0.149>, <298.4563, 62.4630, -16.8918>, <0.647, 0.671, 0.363> }
	smooth_triangle { <292.9341, 65.7028, -20.1251>, <-0.235, -0.964, 0.126>, <294.3315, 65.0217, -16.8918>, <-0.442, -0.845, -0.300>, <296.3391, 64.4265, -19.4236>, <-0.371, -0.920, 0.126> }
	smooth_triangle { <296.3391, 64.4265, -19.4236>, <0.371, 0.920, -0.126>, <296.4789, 64.3584, -19.1002>, <0.430, 0.890, 0.151>, <294.3315, 65.0217, -16.8918>, <0.316, 0.910, 0.268> }
	smooth_triangle { <292.9341, 65.7028, -20.1251>, <0.251, 0.936, -0.249>, <296.1952, 63.5650, -22.1234>, <0.564, 0.700, -0.438>, <296.3391, 64.4265, -19.4236>, <0.371, 0.920, -0.126> }
	smooth_triangle { <296.3391, 64.4265, -19.4236>, <-0.371, -0.920, 0.126>, <296.6652, 64.2128, -19.6234>, <-0.388, -0.872, 0.299>, <296.1952, 63.5650, -22.1234>, <-0.405, -0.824, 0.396> }

	texture { CUSTOM_TUBE_bl }
}

/* Object 'CUSTOM3' */
union {
	smooth_triangle { <196.3040, 71.6216, -11.7026>, <-0.170, 0.329, 0.929>, <192.0000, 74.6344, -13.5599>, <0.036, 0.047, 0.998>, <207.1209, 77.7935, -11.9102>, <-0.179, 0.318, 0.931> }
	smooth_triangle { <207.1209, 77.7935, -11.9102>, <0.170, -0.329, -0.929>, <201.7409, 81.5595, -14.2319>, <0.080, -0.193, -0.978>, <192.0000, 74.6344, -13.5599>, <-0.036, -0.047, -0.998> }
	smooth_triangle { <194.6600, 72.7724, -8.6973>, <-0.230, 0.444, -0.866>, <196.3040, 71.6216, -11.7026>, <-0.431, 0.738, -0.519>, <205.0659, 79.2320, -8.1536>, <-0.365, 0.518, -0.774> }
	smooth_triangle { <205.0659, 79.2320, -8.1536>, <0.155, -0.280, 0.947>, <207.1209, 77.7935, -11.9102>, <0.508, -0.733, 0.453>, <196.3040, 71.6216, -11.7026>, <0.431, -0.738, 0.519> }
	smooth_triangle { <189.3400, 76.4964, -8.6973>, <0.330, -0.340, -0.881>, <194.6600, 72.7724, -8.6973>, <-0.230, 0.444, -0.866>, <198.4159, 83.8870, -8.1536>, <0.175, -0.265, -0.948> }
	smooth_triangle { <198.4159, 83.8870, -8.1536>, <-0.425, 0.528, 0.735>, <205.0659, 79.2320, -8.1536>, <0.155, -0.280, 0.947>, <194.6600, 72.7724, -8.6973>, <-0.028, -0.040, 0.999> }
	smooth_triangle { <187.6960, 77.6472, -11.7026>, <0.549, -0.635, -0.544>, <189.3400, 76.4964, -8.6973>, <0.330, -0.340, -0.881>, <196.3609, 85.3255, -11.9102>, <0.504, -0.678, -0.535> }
	smooth_triangle { <196.3609, 85.3255, -11.9102>, <-0.549, 0.635, 0.544>, <198.4159, 83.8870, -8.1536>, <-0.425, 0.528, 0.735>, <189.3400, 76.4964, -8.6973>, <-0.549, 0.635, 0.544> }
	smooth_triangle { <187.6960, 77.6472, -11.7026>, <-0.237, 0.242, -0.941>, <192.0000, 74.6344, -13.5599>, <-0.036, -0.047, -0.998>, <196.3609, 85.3255, -11.9102>, <-0.231, 0.249, -0.940> }
	smooth_triangle { <196.3609, 85.3255, -11.9102>, <0.237, -0.242, 0.941>, <201.7409, 81.5595, -14.2319>, <0.132, -0.106, 0.986>, <192.0000, 74.6344, -13.5599>, <0.036, 0.047, 0.998> }
	smooth_triangle { <207.1209, 77.7935, -11.9102>, <-0.179, 0.318, 0.931>, <201.7409, 81.5595, -14.2319>, <0.132, -0.106, 0.986>, <244.1233, 106.5255, -13.9179>, <-0.287, 0.246, 0.926> }
	smooth_triangle { <244.1233, 106.5255, -13.9179>, <0.278, -0.461, -0.843>, <238.2388, 108.0686, -16.7040>, <0.113, -0.164, -0.980>, <201.7409, 81.5595, -14.2319>, <0.080, -0.193, -0.978> }
	smooth_triangle { <205.0659, 79.2320, -8.1536>, <-0.365, 0.518, -0.774>, <207.1209, 77.7935, -11.9102>, <-0.520, 0.663, -0.538>, <241.8757, 107.1149, -9.4100>, <-0.509, 0.398, -0.763> }
	smooth_triangle { <241.8757, 107.1149, -9.4100>, <0.231, -0.269, 0.935>, <244.1233, 106.5255, -13.9179>, <0.705, -0.563, 0.432>, <207.1209, 77.7935, -11.9102>, <0.508, -0.733, 0.453> }
	smooth_triangle { <198.4159, 83.8870, -8.1536>, <0.175, -0.265, -0.948>, <205.0659, 79.2320, -8.1536>, <-0.365, 0.518, -0.774>, <234.6020, 109.0222, -9.4100>, <0.288, -0.189, -0.939> }
	smooth_triangle { <234.6020, 109.0222, -9.4100>, <-0.523, 0.484, 0.701>, <241.8757, 107.1149, -9.4100>, <0.231, -0.269, 0.935>, <205.0659, 79.2320, -8.1536>, <0.155, -0.280, 0.947> }
	smooth_triangle { <196.3609, 85.3255, -11.9102>, <0.504, -0.678, -0.535>, <198.4159, 83.8870, -8.1536>, <0.175, -0.265, -0.948>, <232.3543, 109.6116, -13.9179>, <0.624, -0.605, -0.494> }
	smooth_triangle { <232.3543, 109.6116, -13.9179>, <-0.523, 0.772, 0.362>, <234.6020, 109.0222, -9.4100>, <-0.523, 0.484, 0.701>, <198.4159, 83.8870, -8.1536>, <-0.425, 0.528, 0.735> }
	smooth_triangle { <196.3609, 85.3255, -11.9102>, <-0.231, 0.249, -0.940>, <201.7409, 81.5595, -14.2319>, <0.080, -0.193, -0.978>, <232.3543, 109.6116, -13.9179>, <-0.298, 0.242, -0.924> }
	smooth_triangle { <232.3543, 109.6116, -13.9179>, <0.321, -0.360, 0.876>, <238.2388, 108.0686, -16.7040>, <0.119, -0.141, 0.983>, <201.7409, 81.5595, -14.2319>, <0.132, -0.106, 0.986> }
	smooth_triangle { <244.1233, 106.5255, -13.9179>, <-0.287, 0.246, 0.926>, <238.2388, 108.0686, -16.7040>, <0.119, -0.141, 0.983>, <247.8868, 114.4002, -13.9132>, <-0.332, -0.198, 0.923> }
	smooth_triangle { <247.8868, 114.4002, -13.9132>, <0.395, -0.206, -0.895>, <240.9925, 113.2633, -16.6886>, <0.341, 0.185, -0.922>, <238.2388, 108.0686, -16.7040>, <0.113, -0.164, -0.980> }
	smooth_triangle { <241.8757, 107.1149, -9.4100>, <-0.509, 0.398, -0.763>, <244.1233, 106.5255, -13.9179>, <-0.808, 0.378, -0.452>, <245.2663, 114.3432, -9.4224>, <-0.808, 0.378, -0.452> }
	smooth_triangle { <245.2663, 114.3432, -9.4224>, <0.468, -0.223, 0.855>, <247.8868, 114.4002, -13.9132>, <0.340, -0.557, 0.758>, <244.1233, 106.5255, -13.9179>, <0.705, -0.563, 0.432> }
	smooth_triangle { <234.6020, 109.0222, -9.4100>, <0.288, -0.189, -0.939>, <241.8757, 107.1149, -9.4100>, <-0.509, 0.398, -0.763>, <236.7524, 113.1710, -9.4224>, <0.051, -0.375, -0.926> }
	smooth_triangle { <236.7524, 113.1710, -9.4224>, <-0.481, 0.251, 0.840>, <245.2663, 114.3432, -9.4224>, <0.305, 0.135, 0.943>, <241.8757, 107.1149, -9.4100>, <0.231, -0.269, 0.935> }
	smooth_triangle { <232.3543, 109.6116, -13.9179>, <0.624, -0.605, -0.494>, <234.6020, 109.0222, -9.4100>, <0.288, -0.189, -0.939>, <234.1111, 112.5036, -13.9132>, <0.671, -0.666, -0.327> }
	smooth_triangle { <234.1111, 112.5036, -13.9132>, <-0.808, 0.420, 0.413>, <236.7524, 113.1710, -9.4224>, <-0.551, 0.512, 0.659>, <234.6020, 109.0222, -9.4100>, <-0.523, 0.484, 0.701> }
	smooth_triangle { <232.3543, 109.6116, -13.9179>, <-0.298, 0.242, -0.924>, <238.2388, 108.0686, -16.7040>, <0.113, -0.164, -0.980>, <234.1111, 112.5036, -13.9132>, <-0.367, 0.452, -0.813> }
	smooth_triangle { <234.1111, 112.5036, -13.9132>, <0.386, -0.207, 0.899>, <240.9925, 113.2633, -16.6886>, <0.177, -0.501, 0.847>, <238.2388, 108.0686, -16.7040>, <0.119, -0.141, 0.983> }
	smooth_triangle { <247.8868, 114.4002, -13.9132>, <0.081, -0.325, 0.942>, <240.9925, 113.2633, -16.6886>, <0.177, -0.501, 0.847>, <245.7676, 115.7611, -13.5999>, <-0.340, -0.188, 0.922> }
	smooth_triangle { <245.7676, 115.7611, -13.5999>, <0.233, 0.548, -0.803>, <241.6311, 115.0789, -15.2652>, <0.107, 0.049, -0.993>, <240.9925, 113.2633, -16.6886>, <0.109, 0.383, -0.917> }
	smooth_triangle { <245.2663, 114.3432, -9.4224>, <-0.242, -0.790, -0.563>, <247.8868, 114.4002, -13.9132>, <-0.544, -0.772, -0.327>, <244.1953, 115.7269, -10.9054>, <-0.793, -0.389, -0.468> }
	smooth_triangle { <244.1953, 115.7269, -10.9054>, <0.242, 0.790, 0.563>, <245.7676, 115.7611, -13.5999>, <0.793, 0.389, 0.468>, <247.8868, 114.4002, -13.9132>, <0.544, 0.772, 0.327> }
	smooth_triangle { <236.7524, 113.1710, -9.4224>, <0.249, -0.604, -0.757>, <245.2663, 114.3432, -9.4224>, <-0.242, -0.790, -0.563>, <239.0870, 115.0236, -10.9054>, <0.379, -0.242, -0.893> }
	smooth_triangle { <239.0870, 115.0236, -10.9054>, <-0.594, 0.566, 0.571>, <244.1953, 115.7269, -10.9054>, <0.174, 0.579, 0.797>, <245.2663, 114.3432, -9.4224>, <-0.052, 0.375, 0.926> }
	smooth_triangle { <234.1111, 112.5036, -13.9132>, <0.671, -0.666, -0.327>, <236.7524, 113.1710, -9.4224>, <0.335, -0.809, -0.483>, <237.5022, 114.6231, -13.5999>, <0.784, -0.621, -0.014> }
	smooth_triangle { <237.5022, 114.6231, -13.5999>, <-0.492, 0.827, -0.272>, <239.0870, 115.0236, -10.9054>, <-0.594, 0.566, 0.571>, <236.7524, 113.1710, -9.4224>, <-0.696, 0.646, 0.313> }
	smooth_triangle { <234.1111, 112.5036, -13.9132>, <-0.367, 0.452, -0.813>, <240.9925, 113.2633, -16.6886>, <-0.058, 0.629, -0.776>, <237.5022, 114.6231, -13.5999>, <-0.545, 0.561, -0.623> }
	smooth_triangle { <237.5022, 114.6231, -13.5999>, <0.492, -0.827, 0.272>, <241.6311, 115.0789, -15.2652>, <0.386, -0.244, 0.890>, <240.9925, 113.2633, -16.6886>, <0.177, -0.501, 0.847> }
	smooth_triangle { <245.7676, 115.7611, -13.5999>, <-0.340, -0.188, 0.922>, <241.6311, 115.0789, -15.2652>, <-0.027, 0.225, 0.974>, <248.3324, 129.9337, -15.6638>, <-0.345, -0.165, 0.924> }
	smooth_triangle { <248.3324, 129.9337, -15.6638>, <0.394, -0.202, -0.897>, <241.4381, 128.7968, -18.4392>, <0.101, 0.291, -0.951>, <241.6311, 115.0789, -15.2652>, <0.107, 0.049, -0.993> }
	smooth_triangle { <244.1953, 115.7269, -10.9054>, <-0.582, -0.294, -0.758>, <245.7676, 115.7611, -13.5999>, <-0.861, 0.083, -0.501>, <245.7119, 129.8767, -11.1730>, <-0.788, -0.403, -0.465> }
	smooth_triangle { <245.7119, 129.8767, -11.1730>, <0.496, -0.037, 0.867>, <248.3324, 129.9337, -15.6638>, <0.788, 0.403, 0.465>, <245.7676, 115.7611, -13.5999>, <0.793, 0.389, 0.468> }
	smooth_triangle { <239.0870, 115.0236, -10.9054>, <0.379, -0.242, -0.893>, <244.1953, 115.7269, -10.9054>, <-0.496, 0.037, -0.867>, <237.1980, 128.7045, -11.1730>, <0.044, -0.323, -0.946> }
	smooth_triangle { <237.1980, 128.7045, -11.1730>, <-0.490, -0.051, 0.870>, <245.7119, 129.8767, -11.1730>, <0.312, 0.214, 0.926>, <244.1953, 115.7269, -10.9054>, <-0.053, 0.383, 0.922> }
	smooth_triangle { <237.5022, 114.6231, -13.5999>, <0.808, -0.419, -0.413>, <239.0870, 115.0236, -10.9054>, <0.379, -0.242, -0.893>, <234.5567, 128.0370, -15.6638>, <0.839, -0.309, -0.448> }
	smooth_triangle { <234.5567, 128.0370, -15.6638>, <-0.850, -0.107, 0.516>, <237.1980, 128.7045, -11.1730>, <-0.626, 0.238, 0.742>, <239.0870, 115.0236, -10.9054>, <-0.594, 0.566, 0.571> }
	smooth_triangle { <237.5022, 114.6231, -13.5999>, <-0.386, 0.244, -0.890>, <241.6311, 115.0789, -15.2652>, <0.107, 0.049, -0.993>, <234.5567, 128.0370, -15.6638>, <-0.383, 0.132, -0.914> }
	smooth_triangle { <234.5567, 128.0370, -15.6638>, <0.345, 0.216, 0.914>, <241.4381, 128.7968, -18.4392>, <0.175, -0.282, 0.943>, <241.6311, 115.0789, -15.2652>, <0.117, -0.093, 0.989> }
	smooth_triangle { <248.3324, 129.9337, -15.6638>, <-0.345, -0.165, 0.924>, <241.4381, 128.7968, -18.4392>, <0.175, -0.282, 0.943>, <245.4583, 131.7367, -15.4123>, <-0.346, -0.157, 0.925> }
	smooth_triangle { <245.4583, 131.7367, -15.4123>, <0.248, 0.510, -0.824>, <241.3217, 131.0545, -17.0775>, <0.126, 0.017, -0.992>, <241.4381, 128.7968, -18.4392>, <0.101, 0.291, -0.951> }
	smooth_triangle { <245.7119, 129.8767, -11.1730>, <-0.532, -0.531, -0.660>, <248.3324, 129.9337, -15.6638>, <-0.524, -0.791, -0.316>, <243.8859, 131.7025, -12.7178>, <-0.797, -0.381, -0.470> }
	smooth_triangle { <243.8859, 131.7025, -12.7178>, <0.241, 0.756, 0.609>, <245.4583, 131.7367, -15.4123>, <0.797, 0.381, 0.470>, <248.3324, 129.9337, -15.6638>, <0.788, 0.403, 0.465> }
	smooth_triangle { <237.1980, 128.7045, -11.1730>, <0.296, -0.498, -0.815>, <245.7119, 129.8767, -11.1730>, <-0.241, -0.756, -0.609>, <238.7776, 130.9992, -12.7178>, <0.367, -0.197, -0.909> }
	smooth_triangle { <238.7776, 130.9992, -12.7178>, <-0.632, 0.454, 0.627>, <243.8859, 131.7025, -12.7178>, <0.172, 0.541, 0.824>, <245.7119, 129.8767, -11.1730>, <-0.044, 0.323, 0.946> }
	smooth_triangle { <234.5567, 128.0370, -15.6638>, <0.839, -0.309, -0.448>, <237.1980, 128.7045, -11.1730>, <0.414, -0.687, -0.598>, <237.1928, 130.5987, -15.4123>, <0.838, -0.314, -0.446> }
	smooth_triangle { <237.1928, 130.5987, -15.4123>, <-0.679, 0.670, 0.300>, <238.7776, 130.9992, -12.7178>, <-0.632, 0.454, 0.627>, <237.1980, 128.7045, -11.1730>, <-0.839, 0.309, 0.448> }
	smooth_triangle { <234.5567, 128.0370, -15.6638>, <-0.383, 0.132, -0.914>, <241.4381, 128.7968, -18.4392>, <0.101, 0.291, -0.951>, <237.1928, 130.5987, -15.4123>, <-0.383, 0.125, -0.915> }
	smooth_triangle { <237.1928, 130.5987, -15.4123>, <0.375, -0.465, 0.802>, <241.3217, 131.0545, -17.0775>, <0.115, -0.010, 0.993>, <241.4381, 128.7968, -18.4392>, <0.175, -0.282, 0.943> }
	smooth_triangle { <245.4583, 131.7367, -15.4123>, <-0.346, -0.157, 0.925>, <241.3217, 131.0545, -17.0775>, <0.115, -0.010, 0.993>, <248.5169, 144.7361, -17.2431>, <-0.320, -0.157, 0.934> }
	smooth_triangle { <248.5169, 144.7361, -17.2431>, <0.425, -0.234, -0.874>, <241.7471, 142.8018, -20.0186>, <0.077, 0.263, -0.962>, <241.3217, 131.0545, -17.0775>, <0.126, 0.017, -0.992> }
	smooth_triangle { <243.8859, 131.7025, -12.7178>, <-0.581, -0.279, -0.764>, <245.4583, 131.7367, -15.4123>, <-0.857, 0.132, -0.498>, <245.8483, 144.3557, -12.7524>, <-0.770, -0.407, -0.492> }
	smooth_triangle { <245.8483, 144.3557, -12.7524>, <0.495, -0.074, 0.866>, <248.5169, 144.7361, -17.2431>, <0.770, 0.407, 0.492>, <245.4583, 131.7367, -15.4123>, <0.797, 0.381, 0.470> }
	smooth_triangle { <238.7776, 130.9992, -12.7178>, <0.367, -0.197, -0.909>, <243.8859, 131.7025, -12.7178>, <-0.495, 0.074, -0.866>, <237.4292, 142.1863, -12.7524>, <0.077, -0.301, -0.950> }
	smooth_triangle { <237.4292, 142.1863, -12.7524>, <-0.494, -0.057, 0.867>, <245.8483, 144.3557, -12.7524>, <0.289, 0.180, 0.940>, <243.8859, 131.7025, -12.7178>, <-0.044, 0.315, 0.948> }
	smooth_triangle { <237.1928, 130.5987, -15.4123>, <0.838, -0.314, -0.446>, <238.7776, 130.9992, -12.7178>, <0.367, -0.197, -0.909>, <234.8945, 141.2260, -17.2431>, <0.859, -0.268, -0.435> }
	smooth_triangle { <234.8945, 141.2260, -17.2431>, <-0.857, -0.102, 0.505>, <237.4292, 142.1863, -12.7524>, <-0.652, 0.201, 0.731>, <238.7776, 130.9992, -12.7178>, <-0.632, 0.454, 0.627> }
	smooth_triangle { <237.1928, 130.5987, -15.4123>, <-0.383, 0.125, -0.915>, <241.3217, 131.0545, -17.0775>, <0.126, 0.017, -0.992>, <234.8945, 141.2260, -17.2431>, <-0.404, 0.097, -0.909> }
	smooth_triangle { <234.8945, 141.2260, -17.2431>, <0.323, 0.219, 0.921>, <241.7471, 142.8018, -20.0186>, <0.201, -0.260, 0.944>, <241.3217, 131.0545, -17.0775>, <0.115, -0.010, 0.993> }
	smooth_triangle { <248.5169, 144.7361, -17.2431>, <-0.320, -0.157, 0.934>, <241.7471, 142.8018, -20.0186>, <0.201, -0.260, 0.944>, <245.5131, 146.2921, -17.0036>, <-0.318, -0.211, 0.924> }
	smooth_triangle { <245.5131, 146.2921, -17.0036>, <0.197, 0.510, -0.837>, <241.4512, 145.1316, -18.6688>, <0.128, 0.026, -0.991>, <241.7471, 142.8018, -20.0186>, <0.077, 0.263, -0.962> }
	smooth_triangle { <245.8483, 144.3557, -12.7524>, <-0.489, -0.531, -0.692>, <248.5169, 144.7361, -17.2431>, <-0.454, -0.824, -0.339>, <243.9119, 146.0639, -14.3091>, <-0.530, -0.387, -0.755> }
	smooth_triangle { <243.9119, 146.0639, -14.3091>, <0.118, 0.543, 0.832>, <245.5131, 146.2921, -17.0036>, <0.716, 0.517, 0.470>, <248.5169, 144.7361, -17.2431>, <0.770, 0.407, 0.492> }
	smooth_triangle { <237.4292, 142.1863, -12.7524>, <0.349, -0.455, -0.819>, <245.8483, 144.3557, -12.7524>, <-0.168, -0.761, -0.627>, <238.8604, 144.7623, -14.3091>, <0.373, -0.099, -0.923> }
	smooth_triangle { <238.8604, 144.7623, -14.3091>, <-0.487, 0.634, 0.601>, <243.9119, 146.0639, -14.3091>, <0.118, 0.543, 0.832>, <245.8483, 144.3557, -12.7524>, <-0.078, 0.301, 0.950> }
	smooth_triangle { <234.8945, 141.2260, -17.2431>, <0.859, -0.268, -0.435>, <237.4292, 142.1863, -12.7524>, <0.487, -0.634, -0.601>, <237.3396, 144.1861, -17.0036>, <0.874, -0.150, -0.461> }
	smooth_triangle { <237.3396, 144.1861, -17.0036>, <-0.748, 0.594, 0.295>, <238.8604, 144.7623, -14.3091>, <-0.682, 0.334, 0.651>, <237.4292, 142.1863, -12.7524>, <-0.863, 0.265, 0.430> }
	smooth_triangle { <234.8945, 141.2260, -17.2431>, <-0.404, 0.097, -0.909>, <241.7471, 142.8018, -20.0186>, <0.077, 0.263, -0.962>, <237.3396, 144.1861, -17.0036>, <-0.385, 0.049, -0.922> }
	smooth_triangle { <237.3396, 144.1861, -17.0036>, <0.422, -0.414, 0.807>, <241.4512, 145.1316, -18.6688>, <0.110, 0.001, 0.994>, <241.7471, 142.8018, -20.0186>, <0.201, -0.260, 0.944> }
	smooth_triangle { <245.5131, 146.2921, -17.0036>, <-0.318, -0.211, 0.924>, <241.4512, 145.1316, -18.6688>, <0.110, 0.001, 0.994>, <244.8513, 159.5003, -18.9081>, <-0.237, -0.332, 0.913> }
	smooth_triangle { <244.8513, 159.5003, -18.9081>, <0.434, -0.118, -0.893>, <238.4117, 156.8275, -21.6836>, <-0.011, 0.422, -0.906>, <241.4512, 145.1316, -18.6688>, <0.128, 0.026, -0.991> }
	smooth_triangle { <243.9119, 146.0639, -14.3091>, <-0.530, -0.387, -0.755>, <245.5131, 146.2921, -17.0036>, <-0.849, -0.117, -0.515>, <242.2157, 158.8080, -14.4174>, <-0.604, -0.654, -0.454> }
	smooth_triangle { <242.2157, 158.8080, -14.4174>, <0.486, 0.072, 0.871>, <244.8513, 159.5003, -18.9081>, <0.604, 0.654, 0.455>, <245.5131, 146.2921, -17.0036>, <0.716, 0.517, 0.470> }
	smooth_triangle { <238.8604, 144.7623, -14.3091>, <0.373, -0.099, -0.923>, <243.9119, 146.0639, -14.3091>, <-0.530, -0.387, -0.755>, <234.1472, 155.7074, -14.4174>, <0.142, -0.371, -0.918> }
	smooth_triangle { <234.1472, 155.7074, -14.4174>, <-0.459, -0.189, 0.868>, <242.2157, 158.8080, -14.4174>, <0.242, 0.331, 0.912>, <243.9119, 146.0639, -14.3091>, <0.118, 0.543, 0.832> }
	smooth_triangle { <237.3396, 144.1861, -17.0036>, <0.874, -0.150, -0.461>, <238.8604, 144.7623, -14.3091>, <0.373, -0.099, -0.923>, <231.7962, 154.4834, -18.9081>, <0.889, -0.160, -0.429> }
	smooth_triangle { <231.7962, 154.4834, -18.9081>, <-0.793, -0.337, 0.507>, <234.1472, 155.7074, -14.4174>, <-0.662, 0.119, 0.740>, <238.8604, 144.7623, -14.3091>, <-0.877, 0.147, 0.457> }
	smooth_triangle { <237.3396, 144.1861, -17.0036>, <-0.385, 0.049, -0.922>, <241.4512, 145.1316, -18.6688>, <0.128, 0.026, -0.991>, <231.7962, 154.4834, -18.9081>, <-0.427, 0.099, -0.899> }
	smooth_triangle { <231.7962, 154.4834, -18.9081>, <0.274, 0.306, 0.912>, <238.4117, 156.8275, -21.6836>, <0.282, -0.342, 0.896>, <241.4512, 145.1316, -18.6688>, <0.110, 0.001, 0.994> }
	smooth_triangle { <244.8513, 159.5003, -18.9081>, <-0.263, -0.719, 0.643>, <238.4117, 156.8275, -21.6836>, <0.282, -0.342, 0.896>, <241.6616, 159.9072, -18.5829>, <0.126, -0.921, 0.369> }
	smooth_triangle { <241.6616, 159.9072, -18.5829>, <0.001, 0.988, -0.158>, <237.7978, 158.3035, -20.2482>, <-0.223, 0.825, -0.520>, <238.4117, 156.8275, -21.6836>, <-0.011, 0.422, -0.906> }
	smooth_triangle { <242.2157, 158.8080, -14.4174>, <-0.309, -0.735, -0.603>, <244.8513, 159.5003, -18.9081>, <-0.094, -0.957, 0.276>, <240.0802, 159.4918, -15.8885>, <0.121, -0.969, -0.213> }
	smooth_triangle { <240.0802, 159.4918, -15.8885>, <-0.158, 0.883, 0.441>, <241.6616, 159.9072, -18.5829>, <0.001, 0.988, -0.158>, <244.8513, 159.5003, -18.9081>, <0.604, 0.654, 0.455> }
	smooth_triangle { <234.1472, 155.7074, -14.4174>, <0.403, -0.510, -0.759>, <242.2157, 158.8080, -14.4174>, <0.060, -0.869, -0.491>, <235.2391, 157.6314, -15.8885>, <0.407, -0.829, -0.383> }
	smooth_triangle { <235.2391, 157.6314, -15.8885>, <-0.564, 0.746, 0.354>, <240.0802, 159.4918, -15.8885>, <-0.158, 0.883, 0.441>, <242.2157, 158.8080, -14.4174>, <-0.143, 0.371, 0.918> }
	smooth_triangle { <231.7962, 154.4834, -18.9081>, <0.889, -0.160, -0.429>, <234.1472, 155.7074, -14.4174>, <0.542, -0.683, -0.491>, <233.8285, 156.8970, -18.5829>, <0.676, -0.721, 0.155> }
	smooth_triangle { <233.8285, 156.8970, -18.5829>, <-0.627, 0.704, -0.334>, <235.2391, 157.6314, -15.8885>, <-0.564, 0.746, 0.354>, <234.1472, 155.7074, -14.4174>, <-0.892, 0.156, 0.424> }
	smooth_triangle { <231.7962, 154.4834, -18.9081>, <-0.427, 0.099, -0.899>, <238.4117, 156.8275, -21.6836>, <-0.011, 0.422, -0.906>, <233.8285, 156.8970, -18.5829>, <-0.627, 0.704, -0.334> }
	smooth_triangle { <233.8285, 156.8970, -18.5829>, <0.676, -0.721, 0.155>, <237.7978, 158.3035, -20.2482>, <0.394, -0.756, 0.522>, <238.4117, 156.8275, -21.6836>, <0.282, -0.342, 0.896> }
	smooth_triangle { <241.6616, 159.9072, -18.5829>, <0.126, -0.921, 0.369>, <237.7978, 158.3035, -20.2482>, <0.394, -0.756, 0.522>, <237.5752, 159.2025, -17.9983>, <0.210, -0.901, 0.381> }
	smooth_triangle { <237.5752, 159.2025, -17.9983>, <-0.191, 0.968, -0.166>, <237.1889, 159.0421, -18.1648>, <-0.210, 0.901, -0.381>, <237.7978, 158.3035, -20.2482>, <-0.223, 0.825, -0.520> }
	smooth_triangle { <240.0802, 159.4918, -15.8885>, <0.121, -0.969, -0.213>, <241.6616, 159.9072, -18.5829>, <0.126, -0.921, 0.369>, <237.4171, 159.1609, -17.7289>, <0.162, -0.985, -0.057> }
	smooth_triangle { <237.4171, 159.1609, -17.7289>, <-0.254, 0.947, 0.197>, <237.5752, 159.2025, -17.9983>, <-0.191, 0.968, -0.166>, <241.6616, 159.9072, -18.5829>, <0.001, 0.988, -0.158> }
	smooth_triangle { <235.2391, 157.6314, -15.8885>, <0.407, -0.829, -0.383>, <240.0802, 159.4918, -15.8885>, <0.121, -0.969, -0.213>, <236.9330, 158.9749, -17.7289>, <0.338, -0.881, -0.331> }
	smooth_triangle { <236.9330, 158.9749, -17.7289>, <-0.461, 0.863, 0.206>, <237.4171, 159.1609, -17.7289>, <-0.254, 0.947, 0.197>, <240.0802, 159.4918, -15.8885>, <-0.158, 0.883, 0.441> }
	smooth_triangle { <233.8285, 156.8970, -18.5829>, <0.676, -0.721, 0.155>, <235.2391, 157.6314, -15.8885>, <0.407, -0.829, -0.383>, <236.7919, 158.9015, -17.9983>, <0.528, -0.831, 0.175> }
	smooth_triangle { <236.7919, 158.9015, -17.9983>, <-0.528, 0.831, -0.175>, <236.9330, 158.9749, -17.7289>, <-0.461, 0.863, 0.206>, <235.2391, 157.6314, -15.8885>, <-0.564, 0.746, 0.354> }
	smooth_triangle { <233.8285, 156.8970, -18.5829>, <-0.627, 0.704, -0.334>, <237.7978, 158.3035, -20.2482>, <-0.223, 0.825, -0.520>, <236.7919, 158.9015, -17.9983>, <-0.528, 0.831, -0.175> }
	smooth_triangle { <236.7919, 158.9015, -17.9983>, <0.528, -0.831, 0.175>, <237.1889, 159.0421, -18.1648>, <0.453, -0.790, 0.413>, <237.7978, 158.3035, -20.2482>, <0.394, -0.756, 0.522> }

	texture { CUSTOM_TUBE_bl }
}

/* Object 'CUSTOM4' */
union {
	smooth_triangle { <183.6998, 57.1587, -11.8687>, <0.053, -0.491, -0.869>, <184.0000, 61.1343, -14.0975>, <0.066, -0.004, -0.998>, <171.3895, 56.2737, -12.1179>, <0.038, -0.491, -0.870> }
	smooth_triangle { <171.3895, 56.2737, -12.1179>, <-0.053, 0.491, 0.869>, <171.7648, 61.2431, -14.9039>, <-0.051, 0.267, 0.962>, <184.0000, 61.1343, -14.0975>, <-0.066, 0.004, 0.998> }
	smooth_triangle { <183.8145, 58.6772, -8.2624>, <0.067, -0.554, 0.830>, <183.6998, 57.1587, -11.8687>, <0.058, -0.921, 0.386>, <171.5329, 58.1718, -7.6100>, <-0.007, -0.720, 0.694> }
	smooth_triangle { <171.5329, 58.1718, -7.6100>, <-0.032, 0.354, -0.935>, <171.3895, 56.2737, -12.1179>, <-0.003, 0.945, -0.326>, <183.6998, 57.1587, -11.8687>, <-0.058, 0.921, -0.386> }
	smooth_triangle { <184.1855, 63.5913, -8.2624>, <0.077, 0.549, 0.833>, <183.8145, 58.6772, -8.2624>, <0.067, -0.554, 0.830>, <171.9967, 64.3144, -7.6100>, <-0.004, 0.360, 0.933> }
	smooth_triangle { <171.9967, 64.3144, -7.6100>, <-0.077, -0.549, -0.833>, <171.5329, 58.1718, -7.6100>, <-0.032, 0.354, -0.935>, <183.8145, 58.6772, -8.2624>, <-0.053, 0.004, -0.999> }
	smooth_triangle { <184.3002, 65.1098, -11.8687>, <0.075, 0.918, 0.389>, <184.1855, 63.5913, -8.2624>, <0.077, 0.549, 0.833>, <172.1401, 66.2125, -12.1179>, <0.022, 0.921, 0.389> }
	smooth_triangle { <172.1401, 66.2125, -12.1179>, <-0.075, -0.918, -0.389>, <171.9967, 64.3144, -7.6100>, <-0.048, -0.753, -0.656>, <184.1855, 63.5913, -8.2624>, <-0.075, -0.918, -0.389> }
	smooth_triangle { <184.3002, 65.1098, -11.8687>, <-0.062, -0.485, 0.873>, <184.0000, 61.1343, -14.0975>, <-0.066, 0.004, 0.998>, <172.1401, 66.2125, -12.1179>, <-0.052, -0.485, 0.873> }
	smooth_triangle { <172.1401, 66.2125, -12.1179>, <0.062, 0.485, -0.873>, <171.7648, 61.2431, -14.9039>, <0.056, 0.246, -0.968>, <184.0000, 61.1343, -14.0975>, <0.066, -0.004, -0.998> }
	smooth_triangle { <171.3895, 56.2737, -12.1179>, <0.038, -0.491, -0.870>, <171.7648, 61.2431, -14.9039>, <0.056, 0.246, -0.968>, <122.8723, 58.2944, -14.5271>, <-0.098, -0.532, -0.841> }
	smooth_triangle { <122.8723, 58.2944, -14.5271>, <0.140, 0.988, 0.064>, <125.4487, 62.0230, -17.8704>, <0.088, 0.642, 0.761>, <171.7648, 61.2431, -14.9039>, <-0.044, 0.590, 0.806> }
	smooth_triangle { <171.5329, 58.1718, -7.6100>, <-0.007, -0.720, 0.694>, <171.3895, 56.2737, -12.1179>, <-0.042, -0.920, 0.389>, <123.8564, 59.7186, -9.1176>, <-0.156, -0.722, 0.674> }
	smooth_triangle { <123.8564, 59.7186, -9.1176>, <0.053, 0.963, -0.263>, <122.8723, 58.2944, -14.5271>, <0.140, 0.988, 0.064>, <171.3895, 56.2737, -12.1179>, <-0.003, 0.945, -0.326> }
	smooth_triangle { <171.9967, 64.3144, -7.6100>, <-0.004, 0.360, 0.933>, <171.5329, 58.1718, -7.6100>, <-0.007, -0.720, 0.694>, <127.0410, 64.3273, -9.1176>, <-0.018, 0.002, 1.000> }
	smooth_triangle { <127.0410, 64.3273, -9.1176>, <0.031, -0.021, -0.999>, <123.8564, 59.7186, -9.1176>, <0.016, -0.012, -1.000>, <171.5329, 58.1718, -7.6100>, <-0.032, 0.354, -0.935> }
	smooth_triangle { <172.1401, 66.2125, -12.1179>, <0.022, 0.921, 0.389>, <171.9967, 64.3144, -7.6100>, <-0.004, 0.360, 0.933>, <128.0252, 65.7515, -14.5271>, <0.128, 0.930, 0.344> }
	smooth_triangle { <128.0252, 65.7515, -14.5271>, <-0.104, -0.940, 0.325>, <127.0410, 64.3273, -9.1176>, <-0.161, -0.951, -0.265>, <171.9967, 64.3144, -7.6100>, <-0.034, -0.946, -0.322> }
	smooth_triangle { <172.1401, 66.2125, -12.1179>, <-0.052, -0.485, 0.873>, <171.7648, 61.2431, -14.9039>, <-0.055, 0.003, 0.998>, <128.0252, 65.7515, -14.5271>, <-0.112, -0.538, 0.836> }
	smooth_triangle { <128.0252, 65.7515, -14.5271>, <0.206, 0.937, -0.284>, <125.4487, 62.0230, -17.8704>, <0.132, 0.616, -0.776>, <171.7648, 61.2431, -14.9039>, <0.056, 0.246, -0.968> }
	smooth_triangle { <122.8723, 58.2944, -14.5271>, <-0.098, -0.532, -0.841>, <125.4487, 62.0230, -17.8704>, <-0.217, -0.564, -0.797>, <113.7736, 61.7813, -14.5214>, <-0.442, -0.184, -0.878> }
	smooth_triangle { <113.7736, 61.7813, -14.5214>, <0.334, 0.898, 0.287>, <119.2682, 64.1986, -17.8519>, <0.442, 0.201, 0.874>, <125.4487, 62.0230, -17.8704>, <0.088, 0.642, 0.761> }
	smooth_triangle { <123.8564, 59.7186, -9.1176>, <-0.197, -0.917, 0.348>, <122.8723, 58.2944, -14.5271>, <-0.346, -0.890, 0.297>, <115.5466, 62.9487, -9.1325>, <-0.788, -0.499, 0.361> }
	smooth_triangle { <115.5466, 62.9487, -9.1325>, <0.341, 0.889, -0.305>, <113.7736, 61.7813, -14.5214>, <0.726, 0.683, 0.084>, <122.8723, 58.2944, -14.5271>, <0.140, 0.988, 0.064> }
	smooth_triangle { <127.0410, 64.3273, -9.1176>, <-0.018, 0.002, 1.000>, <123.8564, 59.7186, -9.1176>, <-0.027, -0.551, 0.834>, <122.1371, 66.0874, -9.1325>, <-0.184, 0.385, 0.904> }
	smooth_triangle { <122.1371, 66.0874, -9.1325>, <0.001, -0.002, -1.000>, <115.5466, 62.9487, -9.1325>, <0.184, -0.386, -0.904>, <123.8564, 59.7186, -9.1176>, <0.016, -0.012, -1.000> }
	smooth_triangle { <128.0252, 65.7515, -14.5271>, <0.125, 0.992, -0.034>, <127.0410, 64.3273, -9.1176>, <0.283, 0.914, 0.292>, <124.4371, 66.8598, -14.5214>, <0.180, 0.973, -0.141> }
	smooth_triangle { <124.4371, 66.8598, -14.5214>, <-0.162, -0.898, 0.410>, <122.1371, 66.0874, -9.1325>, <-0.152, -0.967, -0.204>, <127.0410, 64.3273, -9.1176>, <-0.161, -0.951, -0.265> }
	smooth_triangle { <128.0252, 65.7515, -14.5271>, <-0.086, -0.819, 0.567>, <125.4487, 62.0230, -17.8704>, <-0.179, -0.585, 0.791>, <124.4371, 66.8598, -14.5214>, <-0.162, -0.898, 0.410> }
	smooth_triangle { <124.4371, 66.8598, -14.5214>, <0.180, 0.973, -0.141>, <119.2682, 64.1986, -17.8519>, <-0.168, 0.609, -0.775>, <125.4487, 62.0230, -17.8704>, <0.132, 0.616, -0.776> }
	smooth_triangle { <113.7736, 61.7813, -14.5214>, <-0.442, -0.184, -0.878>, <119.2682, 64.1986, -17.8519>, <-0.168, 0.609, -0.775>, <114.0244, 63.6576, -14.1455>, <-0.443, -0.199, -0.874> }
	smooth_triangle { <114.0244, 63.6576, -14.1455>, <0.577, -0.234, 0.782>, <117.3212, 65.1079, -16.1438>, <0.137, 0.061, 0.989>, <119.2682, 64.1986, -17.8519>, <0.375, -0.206, 0.904> }
	smooth_triangle { <115.5466, 62.9487, -9.1325>, <-0.796, -0.062, 0.602>, <113.7736, 61.7813, -14.5214>, <-0.952, 0.067, 0.299>, <115.0883, 64.3580, -10.9121>, <-0.841, -0.402, 0.364> }
	smooth_triangle { <115.0883, 64.3580, -10.9121>, <0.728, -0.433, -0.531>, <114.0244, 63.6576, -14.1455>, <0.841, 0.402, -0.364>, <113.7736, 61.7813, -14.5214>, <0.785, 0.499, -0.366> }
	smooth_triangle { <122.1371, 66.0874, -9.1325>, <-0.146, 0.683, 0.715>, <115.5466, 62.9487, -9.1325>, <-0.728, 0.433, 0.531>, <119.0425, 66.2412, -10.9121>, <0.121, 0.566, 0.816> }
	smooth_triangle { <119.0425, 66.2412, -10.9121>, <-0.107, -0.896, -0.432>, <115.0883, 64.3580, -10.9121>, <0.527, -0.320, -0.788>, <115.5466, 62.9487, -9.1325>, <0.184, -0.386, -0.904> }
	smooth_triangle { <124.4371, 66.8598, -14.5214>, <0.180, 0.973, -0.141>, <122.1371, 66.0874, -9.1325>, <-0.189, 0.894, 0.407>, <120.4226, 66.7047, -14.1455>, <0.208, 0.978, -0.015> }
	smooth_triangle { <120.4226, 66.7047, -14.1455>, <0.058, -0.974, 0.218>, <119.0425, 66.2412, -10.9121>, <-0.107, -0.896, -0.432>, <122.1371, 66.0874, -9.1325>, <-0.152, -0.967, -0.204> }
	smooth_triangle { <124.4371, 66.8598, -14.5214>, <-0.162, -0.898, 0.410>, <119.2682, 64.1986, -17.8519>, <0.362, -0.587, 0.725>, <120.4226, 66.7047, -14.1455>, <-0.142, -0.838, 0.527> }
	smooth_triangle { <120.4226, 66.7047, -14.1455>, <-0.058, 0.974, -0.218>, <117.3212, 65.1079, -16.1438>, <0.207, 0.582, -0.786>, <119.2682, 64.1986, -17.8519>, <-0.168, 0.609, -0.775> }
	smooth_triangle { <114.0244, 63.6576, -14.1455>, <-0.443, -0.199, -0.874>, <117.3212, 65.1079, -16.1438>, <0.141, -0.225, -0.964>, <100.4197, 71.8687, -16.6222>, <-0.431, -0.225, -0.874> }
	smooth_triangle { <100.4197, 71.8687, -16.6222>, <0.213, 0.589, 0.780>, <105.9142, 74.2859, -19.9527>, <0.431, 0.225, 0.874>, <117.3212, 65.1079, -16.1438>, <0.137, 0.061, 0.989> }
	smooth_triangle { <115.0883, 64.3580, -10.9121>, <-0.841, -0.402, 0.364>, <114.0244, 63.6576, -14.1455>, <-0.530, -0.775, 0.342>, <102.1927, 73.0360, -11.2332>, <-0.850, -0.383, 0.363> }
	smooth_triangle { <102.1927, 73.0360, -11.2332>, <0.530, 0.775, -0.342>, <100.4197, 71.8687, -16.6222>, <0.850, 0.383, -0.363>, <114.0244, 63.6576, -14.1455>, <0.841, 0.402, -0.364> }
	smooth_triangle { <119.0425, 66.2412, -10.9121>, <0.121, 0.566, 0.816>, <115.0883, 64.3580, -10.9121>, <-0.010, 0.022, 1.000>, <108.7831, 76.1747, -11.2332>, <-0.162, 0.340, 0.926> }
	smooth_triangle { <108.7831, 76.1747, -11.2332>, <-0.380, -0.419, -0.825>, <102.1927, 73.0360, -11.2332>, <0.162, -0.340, -0.926>, <115.0883, 64.3580, -10.9121>, <0.188, -0.395, -0.899> }
	smooth_triangle { <120.4226, 66.7047, -14.1455>, <0.333, 0.903, 0.272>, <119.0425, 66.2412, -10.9121>, <0.121, 0.566, 0.816>, <111.0831, 76.9471, -16.6222>, <0.408, 0.863, 0.298> }
	smooth_triangle { <111.0831, 76.9471, -16.6222>, <-0.640, -0.673, -0.370>, <108.7831, 76.1747, -11.2332>, <-0.318, -0.691, -0.650>, <119.0425, 66.2412, -10.9121>, <-0.107, -0.896, -0.432> }
	smooth_triangle { <120.4226, 66.7047, -14.1455>, <-0.207, -0.582, 0.786>, <117.3212, 65.1079, -16.1438>, <0.137, 0.061, 0.989>, <111.0831, 76.9471, -16.6222>, <-0.265, -0.509, 0.819> }
	smooth_triangle { <111.0831, 76.9471, -16.6222>, <0.454, 0.204, -0.867>, <105.9142, 74.2859, -19.9527>, <-0.027, 0.437, -0.899>, <117.3212, 65.1079, -16.1438>, <0.070, 0.202, -0.977> }
	smooth_triangle { <100.4197, 71.8687, -16.6222>, <-0.431, -0.225, -0.874>, <105.9142, 74.2859, -19.9527>, <-0.027, 0.437, -0.899>, <100.7958, 74.3851, -16.3204>, <-0.427, -0.233, -0.874> }
	smooth_triangle { <100.7958, 74.3851, -16.3204>, <0.567, -0.181, 0.804>, <104.0925, 75.8354, -18.3187>, <0.131, 0.108, 0.985>, <105.9142, 74.2859, -19.9527>, <0.309, -0.142, 0.940> }
	smooth_triangle { <102.1927, 73.0360, -11.2332>, <-0.792, -0.024, 0.609>, <100.4197, 71.8687, -16.6222>, <-0.951, 0.107, 0.290>, <101.8596, 75.0855, -13.0870>, <-0.842, -0.400, 0.363> }
	smooth_triangle { <101.8596, 75.0855, -13.0870>, <0.705, -0.409, -0.579>, <100.7958, 74.3851, -16.3204>, <0.842, 0.400, -0.363>, <100.4197, 71.8687, -16.6222>, <0.850, 0.383, -0.363> }
	smooth_triangle { <108.7831, 76.1747, -11.2332>, <-0.066, 0.639, 0.767>, <102.1927, 73.0360, -11.2332>, <-0.705, 0.409, 0.579>, <105.8139, 76.9687, -13.0870>, <0.136, 0.521, 0.843> }
	smooth_triangle { <105.8139, 76.9687, -13.0870>, <-0.182, -0.854, -0.487>, <101.8596, 75.0855, -13.0870>, <0.501, -0.292, -0.814>, <102.1927, 73.0360, -11.2332>, <0.162, -0.340, -0.926> }
	smooth_triangle { <111.0831, 76.9471, -16.6222>, <0.408, 0.863, 0.298>, <108.7831, 76.1747, -11.2332>, <-0.085, 0.860, 0.504>, <107.1939, 77.4322, -16.3204>, <0.320, 0.947, -0.038> }
	smooth_triangle { <107.1939, 77.4322, -16.3204>, <-0.100, -0.960, 0.260>, <105.8139, 76.9687, -13.0870>, <-0.182, -0.854, -0.487>, <108.7831, 76.1747, -11.2332>, <-0.408, -0.863, -0.298> }
	smooth_triangle { <111.0831, 76.9471, -16.6222>, <-0.265, -0.509, 0.819>, <105.9142, 74.2859, -19.9527>, <0.289, -0.512, 0.809>, <107.1939, 77.4322, -16.3204>, <-0.265, -0.790, 0.552> }
	smooth_triangle { <107.1939, 77.4322, -16.3204>, <0.100, 0.960, -0.260>, <104.0925, 75.8354, -18.3187>, <0.258, 0.497, -0.829>, <105.9142, 74.2859, -19.9527>, <-0.027, 0.437, -0.899> }
	smooth_triangle { <100.7958, 74.3851, -16.3204>, <-0.427, -0.233, -0.874>, <104.0925, 75.8354, -18.3187>, <0.136, -0.246, -0.960>, <87.8523, 81.5917, -18.5174>, <-0.406, -0.201, -0.891> }
	smooth_triangle { <87.8523, 81.5917, -18.5174>, <0.434, 0.867, 0.245>, <93.9353, 83.4234, -21.8479>, <0.416, 0.221, 0.882>, <104.0925, 75.8354, -18.3187>, <0.131, 0.108, 0.985> }
	smooth_triangle { <101.8596, 75.0855, -13.0870>, <-0.842, -0.400, 0.363>, <100.7958, 74.3851, -16.3204>, <-0.501, -0.797, 0.337>, <89.9290, 82.5668, -13.1285>, <-0.853, -0.346, 0.391> }
	smooth_triangle { <89.9290, 82.5668, -13.1285>, <0.501, 0.797, -0.337>, <87.8523, 81.5917, -18.5174>, <0.803, 0.594, 0.044>, <100.7958, 74.3851, -16.3204>, <0.842, 0.400, -0.363> }
	smooth_triangle { <105.8139, 76.9687, -13.0870>, <0.136, 0.521, 0.843>, <101.8596, 75.0855, -13.0870>, <-0.002, 0.003, 1.000>, <97.2954, 85.0012, -13.1285>, <-0.117, 0.353, 0.928> }
	smooth_triangle { <97.2954, 85.0012, -13.1285>, <-0.386, -0.414, -0.824>, <89.9290, 82.5668, -13.1285>, <0.117, -0.353, -0.928>, <101.8596, 75.0855, -13.0870>, <0.158, -0.332, -0.930> }
	smooth_triangle { <107.1939, 77.4322, -16.3204>, <0.404, 0.866, 0.296>, <105.8139, 76.9687, -13.0870>, <0.136, 0.521, 0.843>, <99.7715, 85.5306, -18.5174>, <0.438, 0.851, 0.290> }
	smooth_triangle { <99.7715, 85.5306, -18.5174>, <-0.639, -0.680, -0.360>, <97.2954, 85.0012, -13.1285>, <-0.351, -0.681, -0.643>, <105.8139, 76.9687, -13.0870>, <-0.182, -0.854, -0.487> }
	smooth_triangle { <107.1939, 77.4322, -16.3204>, <-0.270, -0.503, 0.821>, <104.0925, 75.8354, -18.3187>, <0.131, 0.108, 0.985>, <99.7715, 85.5306, -18.5174>, <-0.303, -0.498, 0.813> }
	smooth_triangle { <99.7715, 85.5306, -18.5174>, <0.439, 0.177, -0.881>, <93.9353, 83.4234, -21.8479>, <0.009, 0.443, -0.896>, <104.0925, 75.8354, -18.3187>, <0.118, 0.138, -0.983> }
	smooth_triangle { <87.8523, 81.5917, -18.5174>, <-0.406, -0.201, -0.891>, <93.9353, 83.4234, -21.8479>, <0.009, 0.443, -0.896>, <88.5215, 84.0041, -18.2299>, <-0.437, -0.158, -0.885> }
	smooth_triangle { <88.5215, 84.0041, -18.2299>, <0.521, -0.242, 0.818>, <92.1713, 85.1031, -20.2282>, <0.133, 0.109, 0.985>, <93.9353, 83.4234, -21.8479>, <0.270, -0.152, 0.951> }
	smooth_triangle { <89.9290, 82.5668, -13.1285>, <-0.765, 0.035, 0.643>, <87.8523, 81.5917, -18.5174>, <-0.923, 0.218, 0.316>, <89.7675, 84.5892, -14.9965>, <-0.886, -0.254, 0.387> }
	smooth_triangle { <89.7675, 84.5892, -14.9965>, <0.643, -0.492, -0.588>, <88.5215, 84.0041, -18.2299>, <0.886, 0.254, -0.388>, <87.8523, 81.5917, -18.5174>, <0.853, 0.346, -0.391> }
	smooth_triangle { <97.2954, 85.0012, -13.1285>, <-0.003, 0.645, 0.764>, <89.9290, 82.5668, -13.1285>, <-0.643, 0.492, 0.588>, <94.1873, 86.0498, -14.9965>, <0.219, 0.471, 0.855> }
	smooth_triangle { <94.1873, 86.0498, -14.9965>, <-0.293, -0.813, -0.503>, <89.7675, 84.5892, -14.9965>, <0.457, -0.353, -0.817>, <89.9290, 82.5668, -13.1285>, <0.117, -0.353, -0.928> }
	smooth_triangle { <99.7715, 85.5306, -18.5174>, <0.438, 0.851, 0.290>, <97.2954, 85.0012, -13.1285>, <-0.004, 0.869, 0.494>, <95.6730, 86.3674, -18.2299>, <0.439, 0.898, -0.027> }
	smooth_triangle { <95.6730, 86.3674, -18.2299>, <-0.176, -0.949, 0.260>, <94.1873, 86.0498, -14.9965>, <-0.293, -0.813, -0.503>, <97.2954, 85.0012, -13.1285>, <-0.440, -0.851, -0.286> }
	smooth_triangle { <99.7715, 85.5306, -18.5174>, <-0.303, -0.498, 0.813>, <93.9353, 83.4234, -21.8479>, <0.227, -0.542, 0.809>, <95.6730, 86.3674, -18.2299>, <-0.340, -0.746, 0.572> }
	smooth_triangle { <95.6730, 86.3674, -18.2299>, <0.176, 0.949, -0.260>, <92.1713, 85.1031, -20.2282>, <0.309, 0.431, -0.848>, <93.9353, 83.4234, -21.8479>, <0.009, 0.443, -0.896> }
	smooth_triangle { <88.5215, 84.0041, -18.2299>, <-0.437, -0.158, -0.885>, <92.1713, 85.1031, -20.2282>, <0.101, -0.277, -0.956>, <77.8517, 93.0599, -20.5154>, <-0.279, -0.530, -0.801> }
	smooth_triangle { <77.8517, 93.0599, -20.5154>, <0.295, 0.559, 0.775>, <84.3383, 94.2504, -23.8459>, <0.295, 0.559, 0.775>, <92.1713, 85.1031, -20.2282>, <0.133, 0.109, 0.985> }
	smooth_triangle { <89.7675, 84.5892, -14.9965>, <-0.670, -0.186, 0.718>, <88.5215, 84.0041, -18.2299>, <-0.646, -0.667, 0.370>, <80.1688, 93.8132, -15.1264>, <-0.646, -0.667, 0.370> }
	smooth_triangle { <80.1688, 93.8132, -15.1264>, <0.392, 0.397, -0.830>, <77.8517, 93.0599, -20.5154>, <0.119, 0.771, -0.625>, <88.5215, 84.0041, -18.2299>, <0.886, 0.254, -0.388> }
	smooth_triangle { <94.1873, 86.0498, -14.9965>, <0.219, 0.471, 0.855>, <89.7675, 84.5892, -14.9965>, <-0.394, -0.397, 0.829>, <88.0875, 95.4694, -15.1264>, <-0.096, 0.457, 0.884> }
	smooth_triangle { <88.0875, 95.4694, -15.1264>, <-0.459, -0.308, -0.833>, <80.1688, 93.8132, -15.1264>, <0.386, -0.069, -0.920>, <89.7675, 84.5892, -14.9965>, <0.117, -0.357, -0.927> }
	smooth_triangle { <95.6730, 86.3674, -18.2299>, <0.524, 0.790, 0.319>, <94.1873, 86.0498, -14.9965>, <0.219, 0.471, 0.855>, <90.6644, 95.7396, -20.5154>, <0.526, 0.797, 0.297> }
	smooth_triangle { <90.6644, 95.7396, -20.5154>, <-0.769, -0.504, -0.393>, <88.0875, 95.4694, -15.1264>, <-0.415, -0.631, -0.656>, <94.1873, 86.0498, -14.9965>, <-0.293, -0.813, -0.503> }
	smooth_triangle { <95.6730, 86.3674, -18.2299>, <-0.323, -0.434, 0.841>, <92.1713, 85.1031, -20.2282>, <0.133, 0.109, 0.985>, <90.6644, 95.7396, -20.5154>, <-0.328, -0.491, 0.807> }
	smooth_triangle { <90.6644, 95.7396, -20.5154>, <0.458, 0.041, -0.888>, <84.3383, 94.2504, -23.8459>, <0.042, 0.572, -0.819>, <92.1713, 85.1031, -20.2282>, <0.120, 0.108, -0.987> }
	smooth_triangle { <77.8517, 93.0599, -20.5154>, <-0.237, 0.895, -0.378>, <84.3383, 94.2504, -23.8459>, <0.042, 0.572, -0.819>, <79.6095, 94.7964, -20.1251>, <-0.414, 0.851, -0.324> }
	smooth_triangle { <79.6095, 94.7964, -20.1251>, <0.575, -0.805, 0.148>, <83.5014, 95.5107, -22.1234>, <0.290, -0.851, 0.438>, <84.3383, 94.2504, -23.8459>, <0.184, -0.749, 0.637> }
	smooth_triangle { <80.1688, 93.8132, -15.1264>, <-0.465, 0.781, 0.416>, <77.8517, 93.0599, -20.5154>, <-0.651, 0.716, -0.252>, <80.9997, 95.2484, -16.8918>, <-0.453, 0.874, 0.175> }
	smooth_triangle { <80.9997, 95.2484, -16.8918>, <0.378, -0.851, -0.363>, <79.6095, 94.7964, -20.1251>, <0.575, -0.805, 0.148>, <77.8517, 93.0599, -20.5154>, <0.710, -0.671, -0.212> }
	smooth_triangle { <88.0875, 95.4694, -15.1264>, <0.015, 0.719, 0.695>, <80.1688, 93.8132, -15.1264>, <-0.465, 0.781, 0.416>, <85.7509, 96.2421, -16.8918>, <-0.126, 0.946, 0.300> }
	smooth_triangle { <85.7509, 96.2421, -16.8918>, <-0.014, -0.963, -0.268>, <80.9997, 95.2484, -16.8918>, <0.378, -0.851, -0.363>, <80.1688, 93.8132, -15.1264>, <0.096, -0.457, -0.884> }
	smooth_triangle { <90.6644, 95.7396, -20.5154>, <0.526, 0.797, 0.297>, <88.0875, 95.4694, -15.1264>, <0.021, 0.926, 0.377>, <87.2970, 96.4042, -20.1251>, <0.108, 0.986, -0.126> }
	smooth_triangle { <87.2970, 96.4042, -20.1251>, <-0.084, -0.965, 0.249>, <85.7509, 96.2421, -16.8918>, <-0.014, -0.963, -0.268>, <88.0875, 95.4694, -15.1264>, <-0.529, -0.796, -0.293> }
	smooth_triangle { <90.6644, 95.7396, -20.5154>, <-0.328, -0.491, 0.807>, <84.3383, 94.2504, -23.8459>, <0.184, -0.749, 0.637>, <87.2970, 96.4042, -20.1251>, <-0.084, -0.965, 0.249> }
	smooth_triangle { <87.2970, 96.4042, -20.1251>, <0.108, 0.986, -0.126>, <83.5014, 95.5107, -22.1234>, <-0.099, 0.913, -0.396>, <84.3383, 94.2504, -23.8459>, <0.042, 0.572, -0.819> }
	smooth_triangle { <79.6095, 94.7964, -20.1251>, <-0.414, 0.851, -0.324>, <83.5014, 95.5107, -22.1234>, <-0.099, 0.913, -0.396>, <82.8921, 96.2087, -19.4236>, <-0.321, 0.897, -0.304> }
	smooth_triangle { <82.8921, 96.2087, -19.4236>, <0.368, -0.921, 0.132>, <83.2813, 96.2801, -19.6234>, <0.321, -0.897, 0.304>, <83.5014, 95.5107, -22.1234>, <0.290, -0.851, 0.438> }
	smooth_triangle { <80.9997, 95.2484, -16.8918>, <-0.453, 0.874, 0.175>, <79.6095, 94.7964, -20.1251>, <-0.414, 0.851, -0.324>, <83.0311, 96.2539, -19.1002>, <-0.403, 0.914, 0.045> }
	smooth_triangle { <83.0311, 96.2539, -19.1002>, <0.304, -0.941, -0.149>, <82.8921, 96.2087, -19.4236>, <0.368, -0.921, 0.132>, <79.6095, 94.7964, -20.1251>, <0.575, -0.805, 0.148> }
	smooth_triangle { <85.7509, 96.2421, -16.8918>, <-0.126, 0.946, 0.300>, <80.9997, 95.2484, -16.8918>, <-0.453, 0.874, 0.175>, <83.5062, 96.3532, -19.1002>, <-0.198, 0.948, 0.249> }
	smooth_triangle { <83.5062, 96.3532, -19.1002>, <0.100, -0.983, -0.151>, <83.0311, 96.2539, -19.1002>, <0.304, -0.941, -0.149>, <80.9997, 95.2484, -16.8918>, <0.378, -0.851, -0.363> }
	smooth_triangle { <87.2970, 96.4042, -20.1251>, <0.108, 0.986, -0.126>, <85.7509, 96.2421, -16.8918>, <-0.126, 0.946, 0.300>, <83.6608, 96.3694, -19.4236>, <-0.034, 0.991, -0.126> }
	smooth_triangle { <83.6608, 96.3694, -19.4236>, <0.034, -0.991, 0.126>, <83.5062, 96.3532, -19.1002>, <0.100, -0.983, -0.151>, <85.7509, 96.2421, -16.8918>, <-0.014, -0.963, -0.268> }
	smooth_triangle { <87.2970, 96.4042, -20.1251>, <-0.084, -0.965, 0.249>, <83.5014, 95.5107, -22.1234>, <0.290, -0.851, 0.438>, <83.6608, 96.3694, -19.4236>, <0.034, -0.991, 0.126> }
	smooth_triangle { <83.6608, 96.3694, -19.4236>, <-0.034, 0.991, -0.126>, <83.2813, 96.2801, -19.6234>, <-0.067, 0.952, -0.299>, <83.5014, 95.5107, -22.1234>, <-0.099, 0.913, -0.396> }

	texture { CUSTOM_TUBE_bl }
}

/* Object 'CUSTOM5' */
union {
	smooth_triangle { <178.2846, 66.4200, -11.7026>, <-0.110, -0.354, -0.929>, <182.0000, 70.1344, -13.5599>, <0.043, -0.040, -0.998>, <166.5603, 70.6197, -11.9102>, <-0.121, -0.344, -0.931> }
	smooth_triangle { <166.5603, 70.6197, -11.9102>, <0.110, 0.354, 0.929>, <171.2046, 75.2628, -14.2319>, <0.046, 0.204, 0.978>, <182.0000, 70.1344, -13.5599>, <-0.043, 0.040, 0.998> }
	smooth_triangle { <179.7037, 67.8387, -8.6973>, <-0.150, -0.477, 0.866>, <178.2846, 66.4200, -11.7026>, <-0.296, -0.802, 0.519>, <168.3342, 72.3932, -8.1536>, <-0.269, -0.573, 0.774> }
	smooth_triangle { <168.3342, 72.3932, -8.1536>, <0.104, 0.303, -0.947>, <166.5603, 70.6197, -11.9102>, <0.373, 0.810, -0.453>, <178.2846, 66.4200, -11.7026>, <0.296, 0.802, -0.519> }
	smooth_triangle { <184.2963, 72.4300, -8.6973>, <0.266, 0.392, 0.881>, <179.7037, 67.8387, -8.6973>, <-0.150, -0.477, 0.866>, <174.0749, 78.1323, -8.1536>, <0.127, 0.291, 0.948> }
	smooth_triangle { <174.0749, 78.1323, -8.1536>, <-0.327, -0.594, -0.735>, <168.3342, 72.3932, -8.1536>, <0.104, 0.303, -0.947>, <179.7037, 67.8387, -8.6973>, <-0.034, 0.034, -0.999> }
	smooth_triangle { <185.7154, 73.8488, -11.7026>, <0.431, 0.720, 0.544>, <184.2963, 72.4300, -8.6973>, <0.266, 0.392, 0.881>, <175.8489, 79.9057, -11.9102>, <0.378, 0.755, 0.535> }
	smooth_triangle { <175.8489, 79.9057, -11.9102>, <-0.431, -0.720, -0.544>, <174.0749, 78.1323, -8.1536>, <-0.327, -0.594, -0.735>, <184.2963, 72.4300, -8.6973>, <-0.431, -0.720, -0.544> }
	smooth_triangle { <185.7154, 73.8488, -11.7026>, <-0.191, -0.279, 0.941>, <182.0000, 70.1344, -13.5599>, <-0.043, 0.040, 0.998>, <175.8489, 79.9057, -11.9102>, <-0.184, -0.286, 0.940> }
	smooth_triangle { <175.8489, 79.9057, -11.9102>, <0.191, 0.279, -0.941>, <171.2046, 75.2628, -14.2319>, <0.112, 0.127, -0.986>, <182.0000, 70.1344, -13.5599>, <0.043, -0.040, -0.998> }
	smooth_triangle { <166.5603, 70.6197, -11.9102>, <-0.121, -0.344, -0.931>, <171.2046, 75.2628, -14.2319>, <0.112, 0.127, -0.986>, <125.1307, 92.4898, -13.9179>, <-0.239, -0.292, -0.926> }
	smooth_triangle { <125.1307, 92.4898, -13.9179>, <0.194, 0.503, 0.843>, <130.6579, 95.0313, -16.7040>, <0.083, 0.181, 0.980>, <171.2046, 75.2628, -14.2319>, <0.046, 0.204, 0.978> }
	smooth_triangle { <168.3342, 72.3932, -8.1536>, <-0.269, -0.573, 0.774>, <166.5603, 70.6197, -11.9102>, <-0.397, -0.743, 0.538>, <127.2419, 93.4606, -9.4100>, <-0.433, -0.480, 0.763> }
	smooth_triangle { <127.2419, 93.4606, -9.4100>, <0.181, 0.305, -0.935>, <125.1307, 92.4898, -13.9179>, <0.596, 0.677, -0.432>, <166.5603, 70.6197, -11.9102>, <0.373, 0.810, -0.453> }
	smooth_triangle { <174.0749, 78.1323, -8.1536>, <0.127, 0.291, 0.948>, <168.3342, 72.3932, -8.1536>, <-0.269, -0.573, 0.774>, <134.0738, 96.6020, -9.4100>, <0.250, 0.236, 0.939> }
	smooth_triangle { <134.0738, 96.6020, -9.4100>, <-0.431, -0.568, -0.701>, <127.2419, 93.4606, -9.4100>, <0.181, 0.305, -0.935>, <168.3342, 72.3932, -8.1536>, <0.104, 0.303, -0.947> }
	smooth_triangle { <175.8489, 79.9057, -11.9102>, <0.378, 0.755, 0.535>, <174.0749, 78.1323, -8.1536>, <0.127, 0.291, 0.948>, <136.1850, 97.5727, -13.9179>, <0.510, 0.704, 0.494> }
	smooth_triangle { <136.1850, 97.5727, -13.9179>, <-0.381, -0.851, -0.362>, <134.0738, 96.6020, -9.4100>, <-0.431, -0.568, -0.701>, <174.0749, 78.1323, -8.1536>, <-0.327, -0.594, -0.735> }
	smooth_triangle { <175.8489, 79.9057, -11.9102>, <-0.184, -0.286, 0.940>, <171.2046, 75.2628, -14.2319>, <0.046, 0.204, 0.978>, <136.1850, 97.5727, -13.9179>, <-0.251, -0.290, 0.924> }
	smooth_triangle { <136.1850, 97.5727, -13.9179>, <0.253, 0.410, -0.876>, <130.6579, 95.0313, -16.7040>, <0.093, 0.160, -0.983>, <171.2046, 75.2628, -14.2319>, <0.112, 0.127, -0.986> }
	smooth_triangle { <125.1307, 92.4898, -13.9179>, <-0.239, -0.292, -0.926>, <130.6579, 95.0313, -16.7040>, <0.093, 0.160, -0.983>, <120.0570, 99.5914, -13.9132>, <-0.361, 0.137, -0.923> }
	smooth_triangle { <120.0570, 99.5914, -13.9132>, <0.353, 0.272, 0.895>, <127.0440, 99.6689, -16.6886>, <0.368, -0.123, 0.922>, <130.6579, 95.0313, -16.7040>, <0.083, 0.181, 0.980> }
	smooth_triangle { <127.2419, 93.4606, -9.4100>, <-0.433, -0.480, 0.763>, <125.1307, 92.4898, -13.9179>, <-0.730, -0.513, 0.452>, <122.6476, 99.9903, -9.4224>, <-0.730, -0.513, 0.452> }
	smooth_triangle { <122.6476, 99.9903, -9.4224>, <0.422, 0.301, -0.855>, <120.0570, 99.5914, -13.9132>, <0.238, 0.608, -0.758>, <125.1307, 92.4898, -13.9179>, <0.596, 0.677, -0.432> }
	smooth_triangle { <134.0738, 96.6020, -9.4100>, <0.250, 0.236, 0.939>, <127.2419, 93.4606, -9.4100>, <-0.433, -0.480, 0.763>, <131.2356, 100.3143, -9.4224>, <-0.015, 0.378, 0.926> }
	smooth_triangle { <131.2356, 100.3143, -9.4224>, <-0.430, -0.331, -0.840>, <122.6476, 99.9903, -9.4224>, <0.324, -0.080, -0.943>, <127.2419, 93.4606, -9.4100>, <0.181, 0.305, -0.935> }
	smooth_triangle { <136.1850, 97.5727, -13.9179>, <0.510, 0.704, 0.494>, <134.0738, 96.6020, -9.4100>, <0.250, 0.236, 0.939>, <133.9528, 100.1157, -13.9132>, <0.545, 0.772, 0.327> }
	smooth_triangle { <133.9528, 100.1157, -13.9132>, <-0.723, -0.554, -0.413>, <131.2356, 100.3143, -9.4224>, <-0.454, -0.600, -0.659>, <134.0738, 96.6020, -9.4100>, <-0.431, -0.568, -0.701> }
	smooth_triangle { <136.1850, 97.5727, -13.9179>, <-0.251, -0.290, 0.924>, <130.6579, 95.0313, -16.7040>, <0.083, 0.181, 0.980>, <133.9528, 100.1157, -13.9132>, <-0.283, -0.508, 0.813> }
	smooth_triangle { <133.9528, 100.1157, -13.9132>, <0.344, 0.271, -0.899>, <127.0440, 99.6689, -16.6886>, <0.087, 0.524, -0.847>, <130.6579, 95.0313, -16.7040>, <0.093, 0.160, -0.983> }
	smooth_triangle { <120.0570, 99.5914, -13.9132>, <0.023, 0.334, -0.942>, <127.0440, 99.6689, -16.6886>, <0.087, 0.524, -0.847>, <121.9076, 101.2996, -13.5999>, <-0.367, 0.126, -0.922> }
	smooth_triangle { <121.9076, 101.2996, -13.5999>, <0.325, -0.499, 0.803>, <126.0998, 101.3461, -15.2652>, <0.114, -0.030, 0.993>, <127.0440, 99.6689, -16.6886>, <0.174, -0.359, 0.917> }
	smooth_triangle { <122.6476, 99.9903, -9.4224>, <-0.376, 0.736, 0.563>, <120.0570, 99.5914, -13.9132>, <-0.670, 0.666, 0.327>, <123.4620, 101.5390, -10.9054>, <-0.849, 0.246, 0.468> }
	smooth_triangle { <123.4620, 101.5390, -10.9054>, <0.376, -0.736, -0.563>, <121.9076, 101.2996, -13.5999>, <0.849, -0.246, -0.468>, <120.0570, 99.5914, -13.9132>, <0.670, -0.666, -0.327> }
	smooth_triangle { <131.2356, 100.3143, -9.4224>, <0.141, 0.638, 0.757>, <122.6476, 99.9903, -9.4224>, <-0.376, 0.736, 0.563>, <128.6149, 101.7334, -10.9054>, <0.332, 0.304, 0.893> }
	smooth_triangle { <128.6149, 101.7334, -10.9054>, <-0.487, -0.661, -0.571>, <123.4620, 101.5390, -10.9054>, <0.272, -0.540, -0.797>, <122.6476, 99.9903, -9.4224>, <0.014, -0.378, -0.926> }
	smooth_triangle { <133.9528, 100.1157, -13.9132>, <0.545, 0.772, 0.327>, <131.2356, 100.3143, -9.4224>, <0.189, 0.855, 0.483>, <130.2451, 101.6142, -13.5999>, <0.664, 0.748, 0.014> }
	smooth_triangle { <130.2451, 101.6142, -13.5999>, <-0.341, -0.900, 0.272>, <128.6149, 101.7334, -10.9054>, <-0.487, -0.661, -0.571>, <131.2356, 100.3143, -9.4224>, <-0.573, -0.757, -0.313> }
	smooth_triangle { <133.9528, 100.1157, -13.9132>, <-0.283, -0.508, 0.813>, <127.0440, 99.6689, -16.6886>, <0.052, -0.629, 0.776>, <130.2451, 101.6142, -13.5999>, <-0.439, -0.647, 0.623> }
	smooth_triangle { <130.2451, 101.6142, -13.5999>, <0.341, 0.900, -0.272>, <126.0998, 101.3461, -15.2652>, <0.338, 0.307, -0.890>, <127.0440, 99.6689, -16.6886>, <0.087, 0.524, -0.847> }
	smooth_triangle { <121.9076, 101.2996, -13.5999>, <-0.367, 0.126, -0.922>, <126.0998, 101.3461, -15.2652>, <0.013, -0.226, -0.974>, <116.9208, 114.8115, -15.6638>, <-0.368, 0.103, -0.924> }
	smooth_triangle { <116.9208, 114.8115, -15.6638>, <0.353, 0.267, 0.897>, <123.9077, 114.8890, -18.4392>, <0.150, -0.269, 0.951>, <126.0998, 101.3461, -15.2652>, <0.114, -0.030, 0.993> }
	smooth_triangle { <123.4620, 101.5390, -10.9054>, <-0.624, 0.188, 0.758>, <121.9076, 101.2996, -13.5999>, <-0.834, -0.231, 0.501>, <119.5114, 115.2104, -11.1730>, <-0.846, 0.260, 0.465> }
	smooth_triangle { <119.5114, 115.2104, -11.1730>, <0.482, 0.122, -0.867>, <116.9208, 114.8115, -15.6638>, <0.846, -0.260, -0.465>, <121.9076, 101.2996, -13.5999>, <0.849, -0.246, -0.468> }
	smooth_triangle { <128.6149, 101.7334, -10.9054>, <0.332, 0.304, 0.893>, <123.4620, 101.5390, -10.9054>, <-0.482, -0.122, 0.867>, <128.0994, 115.5345, -11.1730>, <-0.012, 0.325, 0.946> }
	smooth_triangle { <128.0994, 115.5345, -11.1730>, <-0.491, -0.035, -0.870>, <119.5114, 115.2104, -11.1730>, <0.345, -0.156, -0.926>, <123.4620, 101.5390, -10.9054>, <0.015, -0.386, -0.922> }
	smooth_triangle { <130.2451, 101.6142, -13.5999>, <0.723, 0.553, 0.413>, <128.6149, 101.7334, -10.9054>, <0.332, 0.304, 0.893>, <130.8165, 115.3358, -15.6638>, <0.773, 0.450, 0.448> }
	smooth_triangle { <130.8165, 115.3358, -15.6638>, <-0.856, -0.042, -0.516>, <128.0994, 115.5345, -11.1730>, <-0.576, -0.343, -0.742>, <128.6149, 101.7334, -10.9054>, <-0.487, -0.661, -0.571> }
	smooth_triangle { <130.2451, 101.6142, -13.5999>, <-0.338, -0.307, 0.890>, <126.0998, 101.3461, -15.2652>, <0.114, -0.030, 0.993>, <130.8165, 115.3358, -15.6638>, <-0.354, -0.197, 0.914> }
	smooth_triangle { <130.8165, 115.3358, -15.6638>, <0.377, -0.153, -0.914>, <123.9077, 114.8890, -18.4392>, <0.124, 0.308, -0.943>, <126.0998, 101.3461, -15.2652>, <0.099, 0.112, -0.989> }
	smooth_triangle { <116.9208, 114.8115, -15.6638>, <-0.368, 0.103, -0.924>, <123.9077, 114.8890, -18.4392>, <0.124, 0.308, -0.943>, <119.4382, 117.0862, -15.4123>, <-0.368, 0.094, -0.925> }
	smooth_triangle { <119.4382, 117.0862, -15.4123>, <0.332, -0.459, 0.824>, <123.6304, 117.1327, -17.0775>, <0.127, 0.005, 0.992>, <123.9077, 114.8890, -18.4392>, <0.150, -0.269, 0.951> }
	smooth_triangle { <119.5114, 115.2104, -11.1730>, <-0.616, 0.431, 0.660>, <116.9208, 114.8115, -15.6638>, <-0.653, 0.688, 0.316>, <120.9926, 117.3256, -12.7178>, <-0.851, 0.236, 0.470> }
	smooth_triangle { <120.9926, 117.3256, -12.7178>, <0.369, -0.703, -0.609>, <119.4382, 117.0862, -15.4123>, <0.851, -0.236, -0.470>, <116.9208, 114.8115, -15.6638>, <0.846, -0.260, -0.465> }
	smooth_triangle { <128.0994, 115.5345, -11.1730>, <0.205, 0.542, 0.815>, <119.5114, 115.2104, -11.1730>, <-0.369, 0.703, 0.609>, <126.1454, 117.5200, -12.7178>, <0.327, 0.258, 0.909> }
	smooth_triangle { <126.1454, 117.5200, -12.7178>, <-0.544, -0.557, -0.627>, <120.9926, 117.3256, -12.7178>, <0.263, -0.503, -0.824>, <119.5114, 115.2104, -11.1730>, <0.012, -0.325, -0.946> }
	smooth_triangle { <130.8165, 115.3358, -15.6638>, <0.773, 0.450, 0.448>, <128.0994, 115.5345, -11.1730>, <0.288, 0.748, 0.598>, <127.7757, 117.4008, -15.4123>, <0.771, 0.455, 0.446> }
	smooth_triangle { <127.7757, 117.4008, -15.4123>, <-0.553, -0.777, -0.300>, <126.1454, 117.5200, -12.7178>, <-0.544, -0.557, -0.627>, <128.0994, 115.5345, -11.1730>, <-0.773, -0.450, -0.448> }
	smooth_triangle { <130.8165, 115.3358, -15.6638>, <-0.354, -0.197, 0.914>, <123.9077, 114.8890, -18.4392>, <0.150, -0.269, 0.951>, <127.7757, 117.4008, -15.4123>, <-0.355, -0.189, 0.915> }
	smooth_triangle { <127.7757, 117.4008, -15.4123>, <0.289, 0.523, -0.802>, <123.6304, 117.1327, -17.0775>, <0.111, 0.030, -0.993>, <123.9077, 114.8890, -18.4392>, <0.124, 0.308, -0.943> }
	smooth_triangle { <119.4382, 117.0862, -15.4123>, <-0.368, 0.094, -0.925>, <123.6304, 117.1327, -17.0775>, <0.111, 0.030, -0.993>, <114.1687, 129.3570, -17.2431>, <-0.343, 0.099, -0.934> }
	smooth_triangle { <114.1687, 129.3570, -17.2431>, <0.378, 0.305, 0.874>, <121.1715, 128.6277, -20.0186>, <0.121, -0.246, 0.962>, <123.6304, 117.1327, -17.0775>, <0.127, 0.005, 0.992> }
	smooth_triangle { <120.9926, 117.3256, -12.7178>, <-0.621, 0.174, 0.764>, <119.4382, 117.0862, -15.4123>, <-0.821, -0.278, 0.498>, <116.8628, 129.4458, -12.7524>, <-0.829, 0.267, 0.492> }
	smooth_triangle { <116.8628, 129.4458, -12.7524>, <0.474, 0.159, -0.866>, <114.1687, 129.3570, -17.2431>, <0.829, -0.267, -0.492>, <119.4382, 117.0862, -15.4123>, <0.851, -0.236, -0.470> }
	smooth_triangle { <126.1454, 117.5200, -12.7178>, <0.327, 0.258, 0.909>, <120.9926, 117.3256, -12.7178>, <-0.474, -0.159, 0.866>, <125.5307, 128.7713, -12.7524>, <0.024, 0.310, 0.950> }
	smooth_triangle { <125.5307, 128.7713, -12.7524>, <-0.497, -0.030, -0.867>, <116.8628, 129.4458, -12.7524>, <0.316, -0.127, -0.940>, <120.9926, 117.3256, -12.7178>, <0.012, -0.318, -0.948> }
	smooth_triangle { <127.7757, 117.4008, -15.4123>, <0.771, 0.455, 0.446>, <126.1454, 117.5200, -12.7178>, <0.327, 0.258, 0.909>, <128.1936, 128.2657, -17.2431>, <0.800, 0.413, 0.435> }
	smooth_triangle { <128.1936, 128.2657, -17.2431>, <-0.862, -0.049, -0.505>, <125.5307, 128.7713, -12.7524>, <-0.607, -0.311, -0.731>, <126.1454, 117.5200, -12.7178>, <-0.544, -0.557, -0.627> }
	smooth_triangle { <127.7757, 117.4008, -15.4123>, <-0.355, -0.189, 0.915>, <123.6304, 117.1327, -17.0775>, <0.127, 0.005, 0.992>, <128.1936, 128.2657, -17.2431>, <-0.381, -0.166, 0.909> }
	smooth_triangle { <128.1936, 128.2657, -17.2431>, <0.356, -0.160, -0.921>, <121.1715, 128.6277, -20.0186>, <0.153, 0.291, -0.944>, <123.6304, 117.1327, -17.0775>, <0.111, 0.030, -0.993> }
	smooth_triangle { <114.1687, 129.3570, -17.2431>, <-0.343, 0.099, -0.934>, <121.1715, 128.6277, -20.0186>, <0.153, 0.291, -0.944>, <116.8567, 131.4110, -17.0036>, <-0.350, 0.153, -0.924> }
	smooth_triangle { <116.8567, 131.4110, -17.0036>, <0.283, -0.468, 0.837>, <121.0584, 130.9734, -18.6688>, <0.131, -0.004, 0.991>, <121.1715, 128.6277, -20.0186>, <0.121, -0.246, 0.962> }
	smooth_triangle { <116.8628, 129.4458, -12.7524>, <-0.574, 0.438, 0.692>, <114.1687, 129.3570, -17.2431>, <-0.590, 0.733, 0.339>, <118.4732, 131.4643, -14.3091>, <-0.589, 0.289, 0.755> }
	smooth_triangle { <118.4732, 131.4643, -14.3091>, <0.210, -0.514, -0.832>, <116.8567, 131.4110, -17.0036>, <0.794, -0.385, -0.470>, <114.1687, 129.3570, -17.2431>, <0.829, -0.267, -0.492> }
	smooth_triangle { <125.5307, 128.7713, -12.7524>, <0.265, 0.508, 0.819>, <116.8628, 129.4458, -12.7524>, <-0.297, 0.720, 0.627>, <123.6739, 131.0596, -14.3091>, <0.350, 0.162, 0.923> }
	smooth_triangle { <123.6739, 131.0596, -14.3091>, <-0.370, -0.709, -0.601>, <118.4732, 131.4643, -14.3091>, <0.210, -0.514, -0.832>, <116.8628, 129.4458, -12.7524>, <-0.024, -0.310, -0.950> }
	smooth_triangle { <128.1936, 128.2657, -17.2431>, <0.800, 0.413, 0.435>, <125.5307, 128.7713, -12.7524>, <0.370, 0.709, 0.601>, <125.2717, 130.7563, -17.0036>, <0.835, 0.300, 0.461> }
	smooth_triangle { <125.2717, 130.7563, -17.0036>, <-0.634, -0.715, -0.295>, <123.6739, 131.0596, -14.3091>, <-0.614, -0.448, -0.651>, <125.5307, 128.7713, -12.7524>, <-0.804, -0.411, -0.430> }
	smooth_triangle { <128.1936, 128.2657, -17.2431>, <-0.381, -0.166, 0.909>, <121.1715, 128.6277, -20.0186>, <0.121, -0.246, 0.962>, <125.2717, 130.7563, -17.0036>, <-0.370, -0.115, 0.922> }
	smooth_triangle { <125.2717, 130.7563, -17.0036>, <0.344, 0.481, -0.807>, <121.0584, 130.9734, -18.6688>, <0.109, 0.018, -0.994>, <121.1715, 128.6277, -20.0186>, <0.153, 0.291, -0.944> }
	smooth_triangle { <116.8567, 131.4110, -17.0036>, <-0.350, 0.153, -0.924>, <121.0584, 130.9734, -18.6688>, <0.109, 0.018, -0.994>, <115.2148, 144.5334, -18.9081>, <-0.291, 0.286, -0.913> }
	smooth_triangle { <115.2148, 144.5334, -18.9081>, <0.407, 0.191, 0.893>, <122.0207, 143.0194, -21.6836>, <0.062, -0.418, 0.906>, <121.0584, 130.9734, -18.6688>, <0.131, -0.004, 0.991> }
	smooth_triangle { <118.4732, 131.4643, -14.3091>, <-0.589, 0.289, 0.755>, <116.8567, 131.4110, -17.0036>, <-0.857, -0.032, 0.515>, <117.9306, 144.3093, -14.4174>, <-0.709, 0.540, 0.454> }
	smooth_triangle { <117.9306, 144.3093, -14.4174>, <0.491, 0.014, -0.871>, <115.2148, 144.5334, -18.9081>, <0.708, -0.539, -0.455>, <116.8567, 131.4110, -17.0036>, <0.794, -0.385, -0.470> }
	smooth_triangle { <123.6739, 131.0596, -14.3091>, <0.350, 0.162, 0.923>, <118.4732, 131.4643, -14.3091>, <-0.589, 0.289, 0.755>, <126.4149, 142.6569, -14.4174>, <0.075, 0.390, 0.918> }
	smooth_triangle { <126.4149, 142.6569, -14.4174>, <-0.485, 0.107, -0.868>, <117.9306, 144.3093, -14.4174>, <0.296, -0.284, -0.912>, <118.4732, 131.4643, -14.3091>, <0.210, -0.514, -0.832> }
	smooth_triangle { <125.2717, 130.7563, -17.0036>, <0.835, 0.300, 0.461>, <123.6739, 131.0596, -14.3091>, <0.350, 0.162, 0.923>, <128.9428, 141.8597, -18.9081>, <0.848, 0.312, 0.429> }
	smooth_triangle { <128.9428, 141.8597, -18.9081>, <-0.840, 0.194, -0.507>, <126.4149, 142.6569, -14.4174>, <-0.631, -0.232, -0.740>, <123.6739, 131.0596, -14.3091>, <-0.839, -0.297, -0.457> }
	smooth_triangle { <125.2717, 130.7563, -17.0036>, <-0.370, -0.115, 0.922>, <121.0584, 130.9734, -18.6688>, <0.131, -0.004, 0.991>, <128.9428, 141.8597, -18.9081>, <-0.403, -0.171, 0.899> }
	smooth_triangle { <128.9428, 141.8597, -18.9081>, <0.323, -0.254, -0.912>, <122.0207, 143.0194, -21.6836>, <0.218, 0.386, -0.896>, <121.0584, 130.9734, -18.6688>, <0.109, 0.018, -0.994> }
	smooth_triangle { <115.2148, 144.5334, -18.9081>, <-0.384, 0.663, -0.643>, <122.0207, 143.0194, -21.6836>, <0.218, 0.386, -0.896>, <118.2854, 145.4880, -18.5829>, <-0.035, 0.929, -0.369> }
	smooth_triangle { <118.2854, 145.4880, -18.5829>, <0.172, -0.972, 0.158>, <122.3690, 144.5796, -20.2482>, <-0.076, -0.851, 0.520>, <122.0207, 143.0194, -21.6836>, <0.062, -0.418, 0.906> }
	smooth_triangle { <117.9306, 144.3093, -14.4174>, <-0.432, 0.670, 0.603>, <115.2148, 144.5334, -18.9081>, <-0.259, 0.926, -0.276>, <119.9149, 145.3535, -15.8885>, <-0.049, 0.976, 0.213> }
	smooth_triangle { <119.9149, 145.3535, -15.8885>, <-0.003, -0.898, -0.441>, <118.2854, 145.4880, -18.5829>, <0.172, -0.972, 0.158>, <115.2148, 144.5334, -18.9081>, <0.708, -0.539, -0.455> }
	smooth_triangle { <126.4149, 142.6569, -14.4174>, <0.309, 0.573, 0.759>, <117.9306, 144.3093, -14.4174>, <-0.092, 0.866, 0.491>, <125.0055, 144.3621, -15.8885>, <0.257, 0.887, 0.383> }
	smooth_triangle { <125.0055, 144.3621, -15.8885>, <-0.425, -0.833, -0.354>, <119.9149, 145.3535, -15.8885>, <-0.003, -0.898, -0.441>, <117.9306, 144.3093, -14.4174>, <-0.076, -0.390, -0.918> }
	smooth_triangle { <128.9428, 141.8597, -18.9081>, <0.848, 0.312, 0.429>, <126.4149, 142.6569, -14.4174>, <0.415, 0.766, 0.491>, <126.5222, 143.8838, -18.5829>, <0.540, 0.827, -0.155> }
	smooth_triangle { <126.5222, 143.8838, -18.5829>, <-0.495, -0.802, 0.334>, <125.0055, 144.3621, -15.8885>, <-0.425, -0.833, -0.354>, <126.4149, 142.6569, -14.4174>, <-0.851, -0.308, -0.424> }
	smooth_triangle { <128.9428, 141.8597, -18.9081>, <-0.403, -0.171, 0.899>, <122.0207, 143.0194, -21.6836>, <0.062, -0.418, 0.906>, <126.5222, 143.8838, -18.5829>, <-0.495, -0.802, 0.334> }
	smooth_triangle { <126.5222, 143.8838, -18.5829>, <0.540, 0.827, -0.155>, <122.3690, 144.5796, -20.2482>, <0.257, 0.813, -0.522>, <122.0207, 143.0194, -21.6836>, <0.218, 0.386, -0.896> }
	smooth_triangle { <118.2854, 145.4880, -18.5829>, <-0.035, 0.929, -0.369>, <122.3690, 144.5796, -20.2482>, <0.257, 0.813, -0.522>, <122.4321, 145.5036, -17.9983>, <0.050, 0.923, -0.381> }
	smooth_triangle { <122.4321, 145.5036, -17.9983>, <-0.020, -0.986, 0.166>, <122.8404, 145.4127, -18.1648>, <-0.050, -0.923, 0.381>, <122.3690, 144.5796, -20.2482>, <-0.076, -0.851, 0.520> }
	smooth_triangle { <119.9149, 145.3535, -15.8885>, <-0.049, 0.976, 0.213>, <118.2854, 145.4880, -18.5829>, <-0.035, 0.929, -0.369>, <122.5950, 145.4901, -17.7289>, <-0.012, 0.998, 0.057> }
	smooth_triangle { <122.5950, 145.4901, -17.7289>, <-0.086, -0.977, -0.197>, <122.4321, 145.5036, -17.9983>, <-0.020, -0.986, 0.166>, <118.2854, 145.4880, -18.5829>, <0.172, -0.972, 0.158> }
	smooth_triangle { <125.0055, 144.3621, -15.8885>, <0.257, 0.887, 0.383>, <119.9149, 145.3535, -15.8885>, <-0.049, 0.976, 0.213>, <123.1040, 145.3910, -17.7289>, <0.180, 0.926, 0.331> }
	smooth_triangle { <123.1040, 145.3910, -17.7289>, <-0.304, -0.930, -0.206>, <122.5950, 145.4901, -17.7289>, <-0.086, -0.977, -0.197>, <119.9149, 145.3535, -15.8885>, <-0.003, -0.898, -0.441> }
	smooth_triangle { <126.5222, 143.8838, -18.5829>, <0.540, 0.827, -0.155>, <125.0055, 144.3621, -15.8885>, <0.257, 0.887, 0.383>, <123.2557, 145.3432, -17.9983>, <0.375, 0.910, -0.175> }
	smooth_triangle { <123.2557, 145.3432, -17.9983>, <-0.375, -0.910, 0.175>, <123.1040, 145.3910, -17.7289>, <-0.304, -0.930, -0.206>, <125.0055, 144.3621, -15.8885>, <-0.425, -0.833, -0.354> }
	smooth_triangle { <126.5222, 143.8838, -18.5829>, <-0.495, -0.802, 0.334>, <122.3690, 144.5796, -20.2482>, <-0.076, -0.851, 0.520>, <123.2557, 145.3432, -17.9983>, <-0.375, -0.910, 0.175> }
	smooth_triangle { <123.2557, 145.3432, -17.9983>, <0.375, 0.910, -0.175>, <122.8404, 145.4127, -18.1648>, <0.309, 0.857, -0.413>, <122.3690, 144.5796, -20.2482>, <0.257, 0.813, -0.522> }

	texture { CUSTOM_TUBE_bl }
}

/* Object 'CUSTOM6' */
union {
	smooth_triangle { <181.1849, 50.9223, -11.7026>, <0.091, -0.346, 0.934>, <183.5000, 46.5091, -13.5599>, <-0.049, -0.025, 0.998>, <169.3227, 47.2538, -11.9102>, <0.103, -0.340, 0.935> }
	smooth_triangle { <169.3227, 47.2538, -11.9102>, <-0.091, 0.346, -0.934>, <172.2167, 41.7373, -14.2319>, <-0.033, 0.195, -0.980>, <183.5000, 46.5091, -13.5599>, <0.049, 0.025, -0.998> }
	smooth_triangle { <182.0692, 49.2366, -8.6973>, <0.125, -0.473, -0.872>, <181.1849, 50.9223, -11.7026>, <0.259, -0.808, -0.529>, <170.4281, 45.1467, -8.1536>, <0.243, -0.584, -0.774> }
	smooth_triangle { <170.4281, 45.1467, -8.1536>, <-0.089, 0.302, 0.949>, <169.3227, 47.2538, -11.9102>, <-0.336, 0.824, 0.457>, <181.1849, 50.9223, -11.7026>, <-0.259, 0.808, 0.529> }
	smooth_triangle { <184.9308, 43.7816, -8.6973>, <-0.250, 0.413, -0.876>, <182.0692, 49.2366, -8.6973>, <0.125, -0.473, -0.872>, <174.0052, 38.3279, -8.1536>, <-0.114, 0.296, -0.949> }
	smooth_triangle { <174.0052, 38.3279, -8.1536>, <0.301, -0.612, 0.731>, <170.4281, 45.1467, -8.1536>, <-0.089, 0.302, 0.949>, <182.0692, 49.2366, -8.6973>, <0.039, 0.021, 0.999> }
	smooth_triangle { <185.8151, 42.0959, -11.7026>, <-0.398, 0.745, -0.535>, <184.9308, 43.7816, -8.6973>, <-0.250, 0.413, -0.876>, <175.1106, 36.2208, -11.9102>, <-0.344, 0.772, -0.534> }
	smooth_triangle { <175.1106, 36.2208, -11.9102>, <0.398, -0.745, 0.535>, <174.0052, 38.3279, -8.1536>, <0.301, -0.612, 0.731>, <184.9308, 43.7816, -8.6973>, <0.398, -0.745, 0.535> }
	smooth_triangle { <185.8151, 42.0959, -11.7026>, <0.182, -0.299, -0.937>, <183.5000, 46.5091, -13.5599>, <0.049, 0.025, -0.998>, <175.1106, 36.2208, -11.9102>, <0.175, -0.303, -0.937> }
	smooth_triangle { <175.1106, 36.2208, -11.9102>, <-0.182, 0.299, 0.937>, <172.2167, 41.7373, -14.2319>, <-0.109, 0.142, 0.984>, <183.5000, 46.5091, -13.5599>, <-0.049, -0.025, 0.998> }
	smooth_triangle { <169.3227, 47.2538, -11.9102>, <0.103, -0.340, 0.935>, <172.2167, 41.7373, -14.2319>, <-0.109, 0.142, 0.984>, <125.3943, 26.5220, -13.9179>, <0.230, -0.322, 0.918> }
	smooth_triangle { <125.3943, 26.5220, -13.9179>, <-0.169, 0.502, -0.848>, <129.6924, 23.2547, -16.7040>, <-0.075, 0.186, -0.980>, <172.2167, 41.7373, -14.2319>, <-0.033, 0.195, -0.980> }
	smooth_triangle { <170.4281, 45.1467, -8.1536>, <0.243, -0.584, -0.774>, <169.3227, 47.2538, -11.9102>, <0.365, -0.762, -0.535>, <127.0360, 25.2740, -9.4100>, <0.403, -0.524, -0.750> }
	smooth_triangle { <127.0360, 25.2740, -9.4100>, <-0.168, 0.316, 0.934>, <125.3943, 26.5220, -13.9179>, <-0.550, 0.728, 0.408>, <169.3227, 47.2538, -11.9102>, <-0.336, 0.824, 0.457> }
	smooth_triangle { <174.0052, 38.3279, -8.1536>, <-0.114, 0.296, -0.949>, <170.4281, 45.1467, -8.1536>, <0.243, -0.584, -0.774>, <132.3488, 21.2355, -9.4100>, <-0.234, 0.262, -0.936> }
	smooth_triangle { <132.3488, 21.2355, -9.4100>, <0.396, -0.604, 0.691>, <127.0360, 25.2740, -9.4100>, <-0.168, 0.316, 0.934>, <170.4281, 45.1467, -8.1536>, <-0.089, 0.302, 0.949> }
	smooth_triangle { <175.1106, 36.2208, -11.9102>, <-0.344, 0.772, -0.534>, <174.0052, 38.3279, -8.1536>, <-0.114, 0.296, -0.949>, <133.9905, 19.9875, -13.9179>, <-0.467, 0.742, -0.481> }
	smooth_triangle { <133.9905, 19.9875, -13.9179>, <0.344, -0.865, 0.365>, <132.3488, 21.2355, -9.4100>, <0.396, -0.604, 0.691>, <174.0052, 38.3279, -8.1536>, <0.301, -0.612, 0.731> }
	smooth_triangle { <175.1106, 36.2208, -11.9102>, <0.175, -0.303, -0.937>, <172.2167, 41.7373, -14.2319>, <-0.033, 0.195, -0.980>, <133.9905, 19.9875, -13.9179>, <0.244, -0.323, -0.915> }
	smooth_triangle { <133.9905, 19.9875, -13.9179>, <-0.238, 0.430, 0.871>, <129.6924, 23.2547, -16.7040>, <-0.087, 0.168, 0.982>, <172.2167, 41.7373, -14.2319>, <-0.109, 0.142, 0.984> }
	smooth_triangle { <125.3943, 26.5220, -13.9179>, <0.230, -0.322, 0.918>, <129.6924, 23.2547, -16.7040>, <-0.087, 0.168, 0.982>, <118.7486, 19.0948, -13.9132>, <0.398, 0.032, 0.917> }
	smooth_triangle { <118.7486, 19.0948, -13.9132>, <-0.349, 0.331, -0.876>, <125.0792, 18.4294, -16.6886>, <-0.403, -0.018, -0.915>, <129.6924, 23.2547, -16.7040>, <-0.075, 0.186, -0.980> }
	smooth_triangle { <127.0360, 25.2740, -9.4100>, <0.403, -0.524, -0.750>, <125.3943, 26.5220, -13.9179>, <0.682, -0.602, -0.415>, <120.9899, 18.4389, -9.4224>, <0.887, -0.100, -0.450> }
	smooth_triangle { <120.9899, 18.4389, -9.4224>, <-0.400, 0.357, 0.844>, <118.7486, 19.0948, -13.9132>, <-0.884, 0.101, 0.456>, <125.3943, 26.5220, -13.9179>, <-0.550, 0.728, 0.408> }
	smooth_triangle { <132.3488, 21.2355, -9.4100>, <-0.234, 0.262, -0.936>, <127.0360, 25.2740, -9.4100>, <0.403, -0.524, -0.750>, <128.7057, 17.3683, -9.4224>, <0.049, 0.346, -0.937> }
	smooth_triangle { <128.7057, 17.3683, -9.4224>, <0.405, -0.383, 0.830>, <120.9899, 18.4389, -9.4224>, <-0.331, -0.019, 0.944>, <127.0360, 25.2740, -9.4100>, <-0.168, 0.316, 0.934> }
	smooth_triangle { <133.9905, 19.9875, -13.9179>, <-0.467, 0.742, -0.481>, <132.3488, 21.2355, -9.4100>, <-0.234, 0.262, -0.936>, <131.2331, 17.3624, -13.9132>, <-0.498, 0.810, -0.310> }
	smooth_triangle { <131.2331, 17.3624, -13.9132>, <0.673, -0.635, 0.379>, <128.7057, 17.3683, -9.4224>, <0.417, -0.639, 0.646>, <132.3488, 21.2355, -9.4100>, <0.396, -0.604, 0.691> }
	smooth_triangle { <133.9905, 19.9875, -13.9179>, <0.244, -0.323, -0.915>, <129.6924, 23.2547, -16.7040>, <-0.075, 0.186, -0.980>, <131.2331, 17.3624, -13.9132>, <0.261, -0.529, -0.807> }
	smooth_triangle { <131.2331, 17.3624, -13.9132>, <-0.340, 0.328, 0.881>, <125.0792, 18.4294, -16.6886>, <-0.045, 0.500, 0.865>, <129.6924, 23.2547, -16.7040>, <-0.087, 0.168, 0.982> }
	smooth_triangle { <118.7486, 19.0948, -13.9132>, <0.398, 0.032, 0.917>, <125.0792, 18.4294, -16.6886>, <-0.045, 0.500, 0.865>, <119.9424, 17.0534, -13.5999>, <0.403, 0.020, 0.915> }
	smooth_triangle { <119.9424, 17.0534, -13.5999>, <-0.406, -0.366, -0.838>, <123.7408, 16.6542, -15.2652>, <-0.129, -0.003, -0.992>, <125.0792, 18.4294, -16.6886>, <-0.219, -0.284, -0.933> }
	smooth_triangle { <120.9899, 18.4389, -9.4224>, <0.708, 0.210, -0.674>, <118.7486, 19.0948, -13.9132>, <0.831, 0.432, -0.352>, <121.2872, 16.6599, -10.9054>, <0.670, 0.021, -0.742> }
	smooth_triangle { <121.2872, 16.6599, -10.9054>, <-0.362, -0.430, 0.827>, <119.9424, 17.0534, -13.5999>, <-0.896, -0.019, 0.444>, <118.7486, 19.0948, -13.9132>, <-0.884, 0.101, 0.456> }
	smooth_triangle { <128.7057, 17.3683, -9.4224>, <-0.100, 0.623, -0.776>, <120.9899, 18.4389, -9.4224>, <0.511, 0.599, -0.616>, <125.9167, 16.0175, -10.9054>, <-0.297, 0.363, -0.883> }
	smooth_triangle { <125.9167, 16.0175, -10.9054>, <0.428, -0.711, 0.558>, <121.2872, 16.6599, -10.9054>, <-0.362, -0.430, 0.827>, <120.9899, 18.4389, -9.4224>, <-0.048, -0.346, 0.937> }
	smooth_triangle { <131.2331, 17.3624, -13.9132>, <-0.498, 0.810, -0.310>, <128.7057, 17.3683, -9.4224>, <-0.137, 0.847, -0.514>, <127.4331, 16.0140, -13.5999>, <-0.593, 0.805, 0.010> }
	smooth_triangle { <127.4331, 16.0140, -13.5999>, <0.300, -0.912, -0.280>, <125.9167, 16.0175, -10.9054>, <0.428, -0.711, 0.558>, <128.7057, 17.3683, -9.4224>, <0.522, -0.800, 0.295> }
	smooth_triangle { <131.2331, 17.3624, -13.9132>, <0.261, -0.529, -0.807>, <125.0792, 18.4294, -16.6886>, <-0.115, -0.567, -0.815>, <127.4331, 16.0140, -13.5999>, <0.408, -0.683, -0.605> }
	smooth_triangle { <127.4331, 16.0140, -13.5999>, <-0.300, 0.912, 0.280>, <123.7408, 16.6542, -15.2652>, <-0.330, 0.363, 0.871>, <125.0792, 18.4294, -16.6886>, <-0.045, 0.500, 0.865> }
	smooth_triangle { <119.9424, 17.0534, -13.5999>, <0.403, 0.020, 0.915>, <123.7408, 16.6542, -15.2652>, <-0.036, -0.196, 0.980>, <111.5410, 2.5347, -15.6638>, <0.401, -0.002, 0.916> }
	smooth_triangle { <111.5410, 2.5347, -15.6638>, <-0.350, 0.327, -0.878>, <117.8717, 1.8694, -18.4392>, <-0.187, -0.204, -0.961>, <123.7408, 16.6542, -15.2652>, <-0.129, -0.003, -0.992> }
	smooth_triangle { <121.2872, 16.6599, -10.9054>, <0.670, 0.021, -0.742>, <119.9424, 17.0534, -13.5999>, <0.797, -0.396, -0.456>, <113.7823, 1.8789, -11.1730>, <0.896, 0.036, -0.442> }
	smooth_triangle { <113.7823, 1.8789, -11.1730>, <-0.469, 0.223, 0.854>, <111.5410, 2.5347, -15.6638>, <-0.896, -0.036, 0.442>, <119.9424, 17.0534, -13.5999>, <-0.896, -0.019, 0.444> }
	smooth_triangle { <125.9167, 16.0175, -10.9054>, <-0.297, 0.363, -0.883>, <121.2872, 16.6599, -10.9054>, <0.670, 0.021, -0.742>, <121.4982, 0.8083, -11.1730>, <0.041, 0.293, -0.955> }
	smooth_triangle { <121.4982, 0.8083, -11.1730>, <0.489, -0.157, 0.858>, <113.7823, 1.8789, -11.1730>, <-0.356, -0.068, 0.932>, <121.2872, 16.6599, -10.9054>, <-0.362, -0.430, 0.827> }
	smooth_triangle { <127.4331, 16.0140, -13.5999>, <-0.660, 0.653, -0.372>, <125.9167, 16.0175, -10.9054>, <-0.297, 0.363, -0.883>, <124.0255, 0.8024, -15.6638>, <-0.719, 0.564, -0.405> }
	smooth_triangle { <124.0255, 0.8024, -15.6638>, <0.843, -0.253, 0.475>, <121.4982, 0.8083, -11.1730>, <0.547, -0.437, 0.714>, <125.9167, 16.0175, -10.9054>, <0.428, -0.711, 0.558> }
	smooth_triangle { <127.4331, 16.0140, -13.5999>, <0.330, -0.363, -0.871>, <123.7408, 16.6542, -15.2652>, <-0.129, -0.003, -0.992>, <124.0255, 0.8024, -15.6638>, <0.357, -0.267, -0.895> }
	smooth_triangle { <124.0255, 0.8024, -15.6638>, <-0.415, -0.030, 0.909>, <117.8717, 1.8694, -18.4392>, <-0.101, 0.308, 0.946>, <123.7408, 16.6542, -15.2652>, <-0.102, 0.135, 0.986> }
	smooth_triangle { <111.5410, 2.5347, -15.6638>, <0.401, -0.002, 0.916>, <117.8717, 1.8694, -18.4392>, <-0.101, 0.308, 0.946>, <113.1789, -0.1878, -15.4123>, <0.401, -0.009, 0.916> }
	smooth_triangle { <113.1789, -0.1878, -15.4123>, <-0.408, -0.324, -0.853>, <116.9773, -0.5871, -17.0775>, <-0.138, 0.032, -0.990>, <117.8717, 1.8694, -18.4392>, <-0.187, -0.204, -0.961> }
	smooth_triangle { <113.7823, 1.8789, -11.1730>, <0.697, 0.252, -0.672>, <111.5410, 2.5347, -15.6638>, <0.819, 0.461, -0.341>, <114.5237, -0.5813, -12.7178>, <0.666, 0.014, -0.746> }
	smooth_triangle { <114.5237, -0.5813, -12.7178>, <-0.350, -0.395, 0.850>, <113.1789, -0.1878, -15.4123>, <-0.896, -0.017, 0.444>, <111.5410, 2.5347, -15.6638>, <-0.896, -0.036, 0.442> }
	smooth_triangle { <121.4982, 0.8083, -11.1730>, <-0.169, 0.535, -0.828>, <113.7823, 1.8789, -11.1730>, <0.500, 0.564, -0.657>, <119.1532, -1.2237, -12.7178>, <-0.298, 0.317, -0.900> }
	smooth_triangle { <119.1532, -1.2237, -12.7178>, <0.493, -0.621, 0.610>, <114.5237, -0.5813, -12.7178>, <-0.350, -0.395, 0.850>, <113.7823, 1.8789, -11.1730>, <-0.041, -0.293, 0.955> }
	smooth_triangle { <124.0255, 0.8024, -15.6638>, <-0.719, 0.564, -0.405>, <121.4982, 0.8083, -11.1730>, <-0.240, 0.748, -0.619>, <120.6696, -1.2273, -15.4123>, <-0.708, 0.706, 0.016> }
	smooth_triangle { <120.6696, -1.2273, -15.4123>, <0.475, -0.823, -0.311>, <119.1532, -1.2237, -12.7178>, <0.493, -0.621, 0.610>, <121.4982, 0.8083, -11.1730>, <0.719, -0.564, 0.405> }
	smooth_triangle { <124.0255, 0.8024, -15.6638>, <0.357, -0.267, -0.895>, <117.8717, 1.8694, -18.4392>, <-0.187, -0.204, -0.961>, <120.6696, -1.2273, -15.4123>, <0.527, -0.576, -0.625> }
	smooth_triangle { <120.6696, -1.2273, -15.4123>, <-0.475, 0.823, 0.311>, <116.9773, -0.5871, -17.0775>, <-0.120, 0.060, 0.991>, <117.8717, 1.8694, -18.4392>, <-0.101, 0.308, 0.946> }
	smooth_triangle { <113.1789, -0.1878, -15.4123>, <0.401, -0.009, 0.916>, <116.9773, -0.5871, -17.0775>, <-0.120, 0.060, 0.991>, <104.8758, -13.3114, -17.2431>, <0.374, 0.003, 0.928> }
	smooth_triangle { <104.8758, -13.3114, -17.2431>, <-0.373, 0.365, -0.853>, <111.4518, -13.0865, -20.0186>, <-0.155, -0.191, -0.969>, <116.9773, -0.5871, -17.0775>, <-0.138, 0.032, -0.990> }
	smooth_triangle { <114.5237, -0.5813, -12.7178>, <0.666, 0.014, -0.746>, <113.1789, -0.1878, -15.4123>, <0.781, -0.431, -0.453>, <107.3000, -13.6331, -12.7524>, <0.880, 0.057, -0.471> }
	smooth_triangle { <107.3000, -13.6331, -12.7524>, <-0.458, 0.251, 0.852>, <104.8758, -13.3114, -17.2431>, <-0.880, -0.057, 0.471>, <113.1789, -0.1878, -15.4123>, <-0.896, -0.017, 0.444> }
	smooth_triangle { <119.1532, -1.2237, -12.7178>, <-0.298, 0.317, -0.900>, <114.5237, -0.5813, -12.7178>, <0.666, 0.014, -0.746>, <115.3742, -13.6069, -12.7524>, <-0.001, 0.288, -0.958> }
	smooth_triangle { <115.3742, -13.6069, -12.7524>, <0.495, -0.153, 0.855>, <107.3000, -13.6331, -12.7524>, <-0.322, -0.050, 0.945>, <114.5237, -0.5813, -12.7178>, <-0.350, -0.395, 0.850> }
	smooth_triangle { <120.6696, -1.2273, -15.4123>, <-0.717, 0.568, -0.404>, <119.1532, -1.2237, -12.7178>, <-0.298, 0.317, -0.900>, <117.9401, -13.2691, -17.2431>, <-0.747, 0.536, -0.393> }
	smooth_triangle { <117.9401, -13.2691, -17.2431>, <0.847, -0.260, 0.464>, <115.3742, -13.6069, -12.7524>, <0.579, -0.413, 0.703>, <119.1532, -1.2237, -12.7178>, <0.493, -0.621, 0.610> }
	smooth_triangle { <120.6696, -1.2273, -15.4123>, <0.359, -0.261, -0.896>, <116.9773, -0.5871, -17.0775>, <-0.138, 0.032, -0.990>, <117.9401, -13.2691, -17.2431>, <0.388, -0.245, -0.889> }
	smooth_triangle { <117.9401, -13.2691, -17.2431>, <-0.394, -0.042, 0.918>, <111.4518, -13.0865, -20.0186>, <-0.134, 0.300, 0.945>, <116.9773, -0.5871, -17.0775>, <-0.120, 0.060, 0.991> }
	smooth_triangle { <104.8758, -13.3114, -17.2431>, <0.374, 0.003, 0.928>, <111.4518, -13.0865, -20.0186>, <-0.134, 0.300, 0.945>, <106.7320, -15.8044, -17.0036>, <0.387, 0.047, 0.921> }
	smooth_triangle { <106.7320, -15.8044, -17.0036>, <-0.355, -0.347, -0.868>, <110.6776, -15.6694, -18.6688>, <-0.139, 0.026, -0.990>, <111.4518, -13.0865, -20.0186>, <-0.155, -0.191, -0.969> }
	smooth_triangle { <107.3000, -13.6331, -12.7524>, <0.654, 0.276, -0.705>, <104.8758, -13.3114, -17.2431>, <0.761, 0.531, -0.373>, <108.1865, -15.9974, -14.3091>, <0.652, 0.119, -0.749> }
	smooth_triangle { <108.1865, -15.9974, -14.3091>, <-0.294, -0.422, 0.857>, <106.7320, -15.8044, -17.0036>, <-0.874, -0.155, 0.461>, <104.8758, -13.3114, -17.2431>, <-0.880, -0.057, 0.471> }
	smooth_triangle { <115.3742, -13.6069, -12.7524>, <-0.230, 0.514, -0.827>, <107.3000, -13.6331, -12.7524>, <0.424, 0.604, -0.675>, <113.0310, -15.9817, -14.3091>, <-0.340, 0.243, -0.909> }
	smooth_triangle { <113.0310, -15.9817, -14.3091>, <0.571, -0.535, 0.623>, <108.1865, -15.9974, -14.3091>, <-0.294, -0.422, 0.857>, <107.3000, -13.6331, -12.7524>, <0.001, -0.288, 0.958> }
	smooth_triangle { <117.9401, -13.2691, -17.2431>, <-0.747, 0.536, -0.393>, <115.3742, -13.6069, -12.7524>, <-0.324, 0.721, -0.613>, <114.5706, -15.7790, -17.0036>, <-0.800, 0.600, 0.011> }
	smooth_triangle { <114.5706, -15.7790, -17.0036>, <0.553, -0.772, -0.313>, <113.0310, -15.9817, -14.3091>, <0.571, -0.535, 0.623>, <115.3742, -13.6069, -12.7524>, <0.751, -0.534, 0.389> }
	smooth_triangle { <117.9401, -13.2691, -17.2431>, <0.388, -0.245, -0.889>, <111.4518, -13.0865, -20.0186>, <-0.155, -0.191, -0.969>, <114.5706, -15.7790, -17.0036>, <0.583, -0.505, -0.637> }
	smooth_triangle { <114.5706, -15.7790, -17.0036>, <-0.553, 0.772, 0.313>, <110.6776, -15.6694, -18.6688>, <-0.119, 0.046, 0.992>, <111.4518, -13.0865, -20.0186>, <-0.134, 0.300, 0.945> }
	smooth_triangle { <106.7320, -15.8044, -17.0036>, <0.387, 0.047, 0.921>, <110.6776, -15.6694, -18.6688>, <-0.119, 0.046, 0.992>, <101.4835, -30.1701, -18.9081>, <0.336, 0.196, 0.921> }
	smooth_triangle { <101.4835, -30.1701, -18.9081>, <-0.410, 0.275, -0.870>, <108.1049, -29.0617, -21.6836>, <-0.353, -0.188, -0.917>, <110.6776, -15.6694, -18.6688>, <-0.139, 0.026, -0.990> }
	smooth_triangle { <108.1865, -15.9974, -14.3091>, <0.652, 0.119, -0.749>, <106.7320, -15.8044, -17.0036>, <0.846, -0.246, -0.474>, <104.0169, -30.1478, -14.4174>, <0.846, -0.246, -0.474> }
	smooth_triangle { <104.0169, -30.1478, -14.4174>, <-0.492, 0.138, 0.860>, <101.4835, -30.1701, -18.9081>, <-0.845, 0.246, 0.475>, <106.7320, -15.8044, -17.0036>, <-0.874, -0.155, 0.461> }
	smooth_triangle { <113.0310, -15.9817, -14.3091>, <-0.340, 0.243, -0.909>, <108.1865, -15.9974, -14.3091>, <0.652, 0.119, -0.749>, <112.2041, -29.0257, -14.4174>, <-0.051, 0.377, -0.925> }
	smooth_triangle { <112.2041, -29.0257, -14.4174>, <0.508, -0.039, 0.861>, <104.0169, -30.1478, -14.4174>, <-0.317, -0.192, 0.929>, <108.1865, -15.9974, -14.3091>, <-0.294, -0.422, 0.857> }
	smooth_triangle { <114.5706, -15.7790, -17.0036>, <-0.790, 0.448, -0.418>, <113.0310, -15.9817, -14.3091>, <-0.340, 0.243, -0.909>, <114.7307, -28.3544, -18.9081>, <-0.799, 0.459, -0.388> }
	smooth_triangle { <114.7307, -28.3544, -18.9081>, <0.874, -0.059, 0.483>, <112.2041, -29.0257, -14.4174>, <0.612, -0.351, 0.709>, <113.0310, -15.9817, -14.3091>, <0.571, -0.535, 0.623> }
	smooth_triangle { <114.5706, -15.7790, -17.0036>, <0.381, -0.196, -0.904>, <110.6776, -15.6694, -18.6688>, <-0.139, 0.026, -0.990>, <114.7307, -28.3544, -18.9081>, <0.409, -0.252, -0.877> }
	smooth_triangle { <114.7307, -28.3544, -18.9081>, <-0.370, -0.136, 0.919>, <108.1049, -29.0617, -21.6836>, <-0.192, 0.404, 0.894>, <110.6776, -15.6694, -18.6688>, <-0.119, 0.046, 0.992> }
	smooth_triangle { <101.4835, -30.1701, -18.9081>, <0.507, 0.563, 0.653>, <108.1049, -29.0617, -21.6836>, <-0.192, 0.404, 0.894>, <104.0022, -31.4799, -18.5829>, <0.125, 0.907, 0.403> }
	smooth_triangle { <104.0022, -31.4799, -18.5829>, <-0.305, -0.938, -0.165>, <107.9751, -30.8148, -20.2482>, <0.010, -0.830, -0.558>, <108.1049, -29.0617, -21.6836>, <-0.105, -0.371, -0.923> }
	smooth_triangle { <104.0169, -30.1478, -14.4174>, <0.203, 0.823, -0.531>, <101.4835, -30.1701, -18.9081>, <0.411, 0.863, 0.294>, <105.5222, -31.4665, -15.8885>, <0.156, 0.958, -0.239> }
	smooth_triangle { <105.5222, -31.4665, -15.8885>, <-0.089, -0.874, 0.477>, <104.0022, -31.4799, -18.5829>, <-0.305, -0.938, -0.165>, <101.4835, -30.1701, -18.9081>, <-0.471, -0.840, 0.270> }
	smooth_triangle { <112.2041, -29.0257, -14.4174>, <-0.272, 0.583, -0.765>, <104.0169, -30.1478, -14.4174>, <0.203, 0.823, -0.531>, <110.4346, -30.7932, -15.8885>, <-0.211, 0.891, -0.402> }
	smooth_triangle { <110.4346, -30.7932, -15.8885>, <0.380, -0.852, 0.360>, <105.5222, -31.4665, -15.8885>, <-0.089, -0.874, 0.477>, <104.0169, -30.1478, -14.4174>, <0.052, -0.377, 0.925> }
	smooth_triangle { <114.7307, -28.3544, -18.9081>, <-0.799, 0.459, -0.388>, <112.2041, -29.0257, -14.4174>, <-0.368, 0.784, -0.500>, <111.9505, -30.3905, -18.5829>, <-0.495, 0.855, 0.154> }
	smooth_triangle { <111.9505, -30.3905, -18.5829>, <0.451, -0.827, -0.336>, <110.4346, -30.7932, -15.8885>, <0.380, -0.852, 0.360>, <112.2041, -29.0257, -14.4174>, <0.803, -0.457, 0.383> }
	smooth_triangle { <114.7307, -28.3544, -18.9081>, <0.409, -0.252, -0.877>, <108.1049, -29.0617, -21.6836>, <0.075, -0.635, -0.769>, <111.9505, -30.3905, -18.5829>, <0.451, -0.827, -0.336> }
	smooth_triangle { <111.9505, -30.3905, -18.5829>, <-0.495, 0.855, 0.154>, <107.9751, -30.8148, -20.2482>, <-0.210, 0.820, 0.533>, <108.1049, -29.0617, -21.6836>, <-0.192, 0.404, 0.894> }
	smooth_triangle { <104.0022, -31.4799, -18.5829>, <0.125, 0.907, 0.403>, <107.9751, -30.8148, -20.2482>, <-0.210, 0.820, 0.533>, <107.7680, -31.8412, -17.9983>, <0.023, 0.909, 0.417> }
	smooth_triangle { <107.7680, -31.8412, -17.9983>, <-0.066, -0.981, -0.182>, <108.1653, -31.7746, -18.1648>, <-0.022, -0.909, -0.417>, <107.9751, -30.8148, -20.2482>, <0.010, -0.830, -0.558> }
	smooth_triangle { <105.5222, -31.4665, -15.8885>, <0.156, 0.958, -0.239>, <104.0022, -31.4799, -18.5829>, <0.125, 0.907, 0.403>, <107.9200, -31.8398, -17.7289>, <0.105, 0.992, -0.064> }
	smooth_triangle { <107.9200, -31.8398, -17.7289>, <0.011, -0.977, 0.213>, <107.7680, -31.8412, -17.9983>, <-0.066, -0.981, -0.182>, <104.0022, -31.4799, -18.5829>, <-0.305, -0.938, -0.165> }
	smooth_triangle { <110.4346, -30.7932, -15.8885>, <-0.211, 0.891, -0.402>, <105.5222, -31.4665, -15.8885>, <0.156, 0.958, -0.239>, <108.4112, -31.7725, -17.7289>, <-0.127, 0.927, -0.353> }
	smooth_triangle { <108.4112, -31.7725, -17.7289>, <0.257, -0.941, 0.218>, <107.9200, -31.8398, -17.7289>, <0.011, -0.977, 0.213>, <105.5222, -31.4665, -15.8885>, <-0.089, -0.874, 0.477> }
	smooth_triangle { <111.9505, -30.3905, -18.5829>, <-0.495, 0.855, 0.154>, <110.4346, -30.7932, -15.8885>, <-0.211, 0.891, -0.402>, <108.5628, -31.7322, -17.9983>, <-0.335, 0.925, 0.180> }
	smooth_triangle { <108.5628, -31.7322, -17.9983>, <0.335, -0.925, -0.180>, <108.4112, -31.7725, -17.7289>, <0.257, -0.941, 0.218>, <110.4346, -30.7932, -15.8885>, <0.380, -0.852, 0.360> }
	smooth_triangle { <111.9505, -30.3905, -18.5829>, <0.451, -0.827, -0.336>, <107.9751, -30.8148, -20.2482>, <0.010, -0.830, -0.558>, <108.5628, -31.7322, -17.9983>, <0.335, -0.925, -0.180> }
	smooth_triangle { <108.5628, -31.7322, -17.9983>, <-0.335, 0.925, 0.180>, <108.1653, -31.7746, -18.1648>, <-0.270, 0.865, 0.423>, <107.9751, -30.8148, -20.2482>, <-0.210, 0.820, 0.533> }

	texture { CUSTOM_TUBE_bl }
}

/* Object 'CUSTOM7' */
union {
	smooth_triangle { <203.3000, -8.1631, 20.8308>, <0.500, -0.275, -0.821>, <202.1000, -8.8739, 18.8777>, <0.998, 0.063, -0.023>, <204.3500, -20.7602, 25.6923>, <0.652, -0.191, -0.734> }
	smooth_triangle { <204.3500, -20.7602, 25.6923>, <-0.331, 0.317, 0.889>, <203.0000, -21.5599, 23.4950>, <-0.971, -0.067, 0.228>, <202.1000, -8.8739, 18.8777>, <-0.998, -0.063, 0.023> }
	smooth_triangle { <205.7000, -8.1631, 20.8308>, <-0.498, -0.358, -0.790>, <203.3000, -8.1631, 20.8308>, <0.500, -0.275, -0.821>, <207.0500, -20.7602, 25.6923>, <-0.320, -0.417, -0.851> }
	smooth_triangle { <207.0500, -20.7602, 25.6923>, <0.641, 0.376, 0.669>, <204.3500, -20.7602, 25.6923>, <-0.331, 0.317, 0.889>, <203.3000, -8.1631, 20.8308>, <0.000, 0.360, 0.933> }
	smooth_triangle { <206.9000, -8.8739, 18.8777>, <-0.994, -0.104, 0.038>, <205.7000, -8.1631, 20.8308>, <-0.498, -0.358, -0.790>, <208.4000, -21.5599, 23.4950>, <-0.962, -0.252, -0.108> }
	smooth_triangle { <208.4000, -21.5599, 23.4950>, <0.969, 0.080, -0.233>, <207.0500, -20.7602, 25.6923>, <0.641, 0.376, 0.669>, <205.7000, -8.1631, 20.8308>, <0.862, 0.260, 0.435> }
	smooth_triangle { <205.7000, -9.5848, 16.9246>, <-0.498, 0.233, 0.835>, <206.9000, -8.8739, 18.8777>, <-0.994, -0.104, 0.038>, <207.0500, -22.3596, 21.2978>, <-0.647, 0.137, 0.750> }
	smooth_triangle { <207.0500, -22.3596, 21.2978>, <0.322, -0.273, -0.906>, <208.4000, -21.5599, 23.4950>, <0.969, 0.080, -0.233>, <206.9000, -8.8739, 18.8777>, <0.862, -0.080, -0.500> }
	smooth_triangle { <203.3000, -9.5848, 16.9246>, <0.000, 0.324, 0.946>, <205.7000, -9.5848, 16.9246>, <-0.498, 0.233, 0.835>, <204.3500, -22.3596, 21.2978>, <0.327, 0.328, 0.886> }
	smooth_triangle { <204.3500, -22.3596, 21.2978>, <-0.652, -0.328, -0.684>, <207.0500, -22.3596, 21.2978>, <0.322, -0.273, -0.906>, <205.7000, -9.5848, 16.9246>, <0.000, -0.324, -0.946> }
	smooth_triangle { <203.3000, -9.5848, 16.9246>, <-0.865, -0.225, -0.449>, <202.1000, -8.8739, 18.8777>, <-0.998, -0.063, 0.023>, <204.3500, -22.3596, 21.2978>, <-0.652, -0.328, -0.684> }
	smooth_triangle { <204.3500, -22.3596, 21.2978>, <0.327, 0.328, 0.886>, <203.0000, -21.5599, 23.4950>, <0.971, 0.198, 0.131>, <202.1000, -8.8739, 18.8777>, <0.998, 0.063, -0.023> }
	smooth_triangle { <204.3500, -20.7602, 25.6923>, <0.652, -0.191, -0.734>, <203.0000, -21.5599, 23.4950>, <0.971, 0.198, 0.131>, <207.4200, -35.0028, 31.2909>, <0.619, -0.073, -0.782> }
	smooth_triangle { <207.4200, -35.0028, 31.2909>, <-0.330, 0.279, 0.902>, <205.9399, -36.5685, 28.9577>, <-0.916, -0.266, 0.300>, <203.0000, -21.5599, 23.4950>, <-0.971, -0.067, 0.228> }
	smooth_triangle { <207.0500, -20.7602, 25.6923>, <-0.320, -0.417, -0.851>, <204.3500, -20.7602, 25.6923>, <0.652, -0.191, -0.734>, <210.3800, -33.7373, 30.8303>, <-0.281, -0.485, -0.828> }
	smooth_triangle { <210.3800, -33.7373, 30.8303>, <0.596, 0.492, 0.635>, <207.4200, -35.0028, 31.2909>, <-0.330, 0.279, 0.902>, <204.3500, -20.7602, 25.6923>, <-0.331, 0.317, 0.889> }
	smooth_triangle { <208.4000, -21.5599, 23.4950>, <-0.962, -0.252, -0.108>, <207.0500, -20.7602, 25.6923>, <-0.320, -0.417, -0.851>, <211.8600, -34.0376, 28.0365>, <-0.898, -0.439, -0.038> }
	smooth_triangle { <211.8600, -34.0376, 28.0365>, <0.926, 0.235, -0.296>, <210.3800, -33.7373, 30.8303>, <0.596, 0.492, 0.635>, <207.0500, -20.7602, 25.6923>, <0.641, 0.376, 0.669> }
	smooth_triangle { <207.0500, -22.3596, 21.2978>, <-0.647, 0.137, 0.750>, <208.4000, -21.5599, 23.4950>, <-0.962, -0.252, -0.108>, <210.3800, -35.6033, 25.7034>, <-0.604, 0.030, 0.796> }
	smooth_triangle { <210.3800, -35.6033, 25.7034>, <0.306, -0.234, -0.923>, <211.8600, -34.0376, 28.0365>, <0.926, 0.235, -0.296>, <208.4000, -21.5599, 23.4950>, <0.969, 0.080, -0.233> }
	smooth_triangle { <204.3500, -22.3596, 21.2978>, <0.327, 0.328, 0.886>, <207.0500, -22.3596, 21.2978>, <-0.647, 0.137, 0.750>, <207.4200, -36.8688, 26.1640>, <0.324, 0.365, 0.873> }
	smooth_triangle { <207.4200, -36.8688, 26.1640>, <-0.620, -0.443, -0.647>, <210.3800, -35.6033, 25.7034>, <0.306, -0.234, -0.923>, <207.0500, -22.3596, 21.2978>, <0.322, -0.273, -0.906> }
	smooth_triangle { <204.3500, -22.3596, 21.2978>, <-0.652, -0.328, -0.684>, <203.0000, -21.5599, 23.4950>, <-0.971, -0.067, 0.228>, <207.4200, -36.8688, 26.1640>, <-0.620, -0.443, -0.647> }
	smooth_triangle { <207.4200, -36.8688, 26.1640>, <0.324, 0.365, 0.873>, <205.9399, -36.5685, 28.9577>, <0.916, 0.397, 0.059>, <203.0000, -21.5599, 23.4950>, <0.971, 0.198, 0.131> }
	smooth_triangle { <207.4200, -35.0028, 31.2909>, <0.619, -0.073, -0.782>, <205.9399, -36.5685, 28.9577>, <0.916, 0.397, 0.059>, <215.2750, -49.4588, 36.8428>, <0.542, 0.053, -0.838> }
	smooth_triangle { <215.2750, -49.4588, 36.8428>, <-0.308, 0.196, 0.931>, <214.0499, -51.9242, 34.5467>, <-0.799, -0.471, 0.373>, <205.9399, -36.5685, 28.9577>, <-0.916, -0.266, 0.300> }
	smooth_triangle { <210.3800, -33.7373, 30.8303>, <-0.281, -0.485, -0.828>, <207.4200, -35.0028, 31.2909>, <0.619, -0.073, -0.782>, <217.7250, -46.5809, 35.7953>, <-0.210, -0.545, -0.812> }
	smooth_triangle { <217.7250, -46.5809, 35.7953>, <0.505, 0.624, 0.596>, <215.2750, -49.4588, 36.8428>, <-0.308, 0.196, 0.931>, <207.4200, -35.0028, 31.2909>, <-0.330, 0.279, 0.902> }
	smooth_triangle { <211.8600, -34.0376, 28.0365>, <-0.898, -0.439, -0.038>, <210.3800, -33.7373, 30.8303>, <-0.281, -0.485, -0.828>, <218.9501, -46.1682, 32.4517>, <-0.759, -0.650, 0.025> }
	smooth_triangle { <218.9501, -46.1682, 32.4517>, <0.812, 0.442, -0.380>, <217.7250, -46.5809, 35.7953>, <0.505, 0.624, 0.596>, <210.3800, -33.7373, 30.8303>, <0.596, 0.492, 0.635> }
	smooth_triangle { <210.3800, -35.6033, 25.7034>, <-0.604, 0.030, 0.796>, <211.8600, -34.0376, 28.0365>, <-0.898, -0.439, -0.038>, <217.7250, -48.6335, 30.1557>, <-0.500, -0.098, 0.861> }
	smooth_triangle { <217.7250, -48.6335, 30.1557>, <0.263, -0.169, -0.950>, <218.9501, -46.1682, 32.4517>, <0.812, 0.442, -0.380>, <211.8600, -34.0376, 28.0365>, <0.926, 0.235, -0.296> }
	smooth_triangle { <207.4200, -36.8688, 26.1640>, <0.324, 0.365, 0.873>, <210.3800, -35.6033, 25.7034>, <-0.604, 0.030, 0.796>, <215.2750, -51.5115, 31.2031>, <0.303, 0.445, 0.843> }
	smooth_triangle { <215.2750, -51.5115, 31.2031>, <-0.538, -0.585, -0.607>, <217.7250, -48.6335, 30.1557>, <0.263, -0.169, -0.950>, <210.3800, -35.6033, 25.7034>, <0.306, -0.234, -0.923> }
	smooth_triangle { <207.4200, -36.8688, 26.1640>, <-0.620, -0.443, -0.647>, <205.9399, -36.5685, 28.9577>, <-0.916, -0.266, 0.300>, <215.2750, -51.5115, 31.2031>, <-0.538, -0.585, -0.607> }
	smooth_triangle { <215.2750, -51.5115, 31.2031>, <0.303, 0.445, 0.843>, <214.0499, -51.9242, 34.5467>, <0.799, 0.601, -0.017>, <205.9399, -36.5685, 28.9577>, <0.916, 0.397, 0.059> }
	smooth_triangle { <215.2750, -49.4588, 36.8428>, <0.542, 0.053, -0.838>, <214.0499, -51.9242, 34.5467>, <0.799, 0.601, -0.017>, <226.8214, -61.6566, 41.9211>, <0.646, 0.323, -0.692> }
	smooth_triangle { <226.8214, -61.6566, 41.9211>, <-0.392, 0.008, 0.920>, <225.9427, -65.1015, 39.3428>, <-0.651, -0.341, 0.678>, <214.0499, -51.9242, 34.5467>, <-0.799, -0.471, 0.373> }
	smooth_triangle { <217.7250, -46.5809, 35.7953>, <-0.210, -0.545, -0.812>, <215.2750, -49.4588, 36.8428>, <0.542, 0.053, -0.838>, <228.5786, -57.2302, 40.3100>, <-0.361, -0.196, -0.912> }
	smooth_triangle { <228.5786, -57.2302, 40.3100>, <0.324, 0.628, 0.708>, <226.8214, -61.6566, 41.9211>, <-0.001, 0.003, 1.000>, <215.2750, -49.4588, 36.8428>, <-0.308, 0.196, 0.931> }
	smooth_triangle { <218.9501, -46.1682, 32.4517>, <-0.759, -0.650, 0.025>, <217.7250, -46.5809, 35.7953>, <-0.210, -0.545, -0.812>, <229.4572, -56.2485, 36.1207>, <-0.905, -0.421, -0.063> }
	smooth_triangle { <229.4572, -56.2485, 36.1207>, <0.827, 0.463, -0.317>, <228.5786, -57.2302, 40.3100>, <0.583, 0.557, 0.592>, <217.7250, -46.5809, 35.7953>, <0.505, 0.624, 0.596> }
	smooth_triangle { <217.7250, -48.6335, 30.1557>, <-0.500, -0.098, 0.861>, <218.9501, -46.1682, 32.4517>, <-0.759, -0.650, 0.025>, <228.5786, -59.6934, 33.5424>, <-0.795, 0.012, 0.606> }
	smooth_triangle { <228.5786, -59.6934, 33.5424>, <0.487, -0.167, -0.857>, <229.4572, -56.2485, 36.1207>, <0.827, 0.463, -0.317>, <218.9501, -46.1682, 32.4517>, <0.812, 0.442, -0.380> }
	smooth_triangle { <215.2750, -51.5115, 31.2031>, <0.303, 0.445, 0.843>, <217.7250, -48.6335, 30.1557>, <-0.500, -0.098, 0.861>, <226.8214, -64.1198, 35.1535>, <-0.003, 0.638, 0.770> }
	smooth_triangle { <226.8214, -64.1198, 35.1535>, <-0.388, -0.578, -0.718>, <228.5786, -59.6934, 33.5424>, <0.487, -0.167, -0.857>, <217.7250, -48.6335, 30.1557>, <0.263, -0.169, -0.950> }
	smooth_triangle { <215.2750, -51.5115, 31.2031>, <-0.538, -0.585, -0.607>, <214.0499, -51.9242, 34.5467>, <-0.799, -0.471, 0.373>, <226.8214, -64.1198, 35.1535>, <-0.388, -0.578, -0.718> }
	smooth_triangle { <226.8214, -64.1198, 35.1535>, <0.388, 0.583, 0.714>, <225.9427, -65.1015, 39.3428>, <0.651, 0.697, 0.300>, <214.0499, -51.9242, 34.5467>, <0.799, 0.601, -0.017> }
	smooth_triangle { <226.8214, -61.6566, 41.9211>, <-0.644, 0.313, -0.699>, <225.9427, -65.1015, 39.3428>, <-0.579, 0.766, -0.279>, <230.4122, -61.8303, 38.5354>, <-0.539, 0.588, -0.602> }
	smooth_triangle { <230.4122, -61.8303, 38.5354>, <0.644, -0.313, 0.699>, <230.3243, -62.1748, 38.2776>, <0.539, -0.588, 0.602>, <225.9427, -65.1015, 39.3428>, <0.579, -0.766, 0.279> }
	smooth_triangle { <228.5786, -57.2302, 40.3100>, <-0.609, -0.262, -0.748>, <226.8214, -61.6566, 41.9211>, <-0.644, 0.313, -0.699>, <230.5879, -61.3877, 38.3743>, <-0.686, 0.007, -0.728> }
	smooth_triangle { <230.5879, -61.3877, 38.3743>, <0.838, 0.162, 0.521>, <230.4122, -61.8303, 38.5354>, <0.644, -0.313, 0.699>, <226.8214, -61.6566, 41.9211>, <0.357, 0.191, 0.914> }
	smooth_triangle { <229.4572, -56.2485, 36.1207>, <-0.905, -0.421, -0.063>, <228.5786, -57.2302, 40.3100>, <-0.838, -0.162, -0.521>, <230.6757, -61.2895, 37.9554>, <-0.911, -0.317, -0.265> }
	smooth_triangle { <230.6757, -61.2895, 37.9554>, <0.975, 0.208, -0.076>, <230.5879, -61.3877, 38.3743>, <0.838, 0.162, 0.521>, <228.5786, -57.2302, 40.3100>, <0.784, 0.548, 0.293> }
	smooth_triangle { <228.5786, -59.6934, 33.5424>, <-0.795, 0.012, 0.606>, <229.4572, -56.2485, 36.1207>, <-0.905, -0.421, -0.063>, <230.5878, -61.6340, 37.6976>, <-0.911, -0.072, 0.407> }
	smooth_triangle { <230.5878, -61.6340, 37.6976>, <0.838, -0.211, -0.504>, <230.6757, -61.2895, 37.9554>, <0.975, 0.208, -0.076>, <229.4572, -56.2485, 36.1207>, <0.827, 0.463, -0.317> }
	smooth_triangle { <226.8214, -64.1198, 35.1535>, <-0.362, 0.437, 0.824>, <228.5786, -59.6934, 33.5424>, <-0.795, 0.012, 0.606>, <230.4122, -62.0766, 37.8587>, <-0.644, 0.689, 0.334> }
	smooth_triangle { <230.4122, -62.0766, 37.8587>, <0.644, -0.689, -0.334>, <230.5878, -61.6340, 37.6976>, <0.838, -0.211, -0.504>, <228.5786, -59.6934, 33.5424>, <0.487, -0.167, -0.857> }
	smooth_triangle { <226.8214, -64.1198, 35.1535>, <0.539, -0.838, -0.083>, <225.9427, -65.1015, 39.3428>, <0.579, -0.766, 0.279>, <230.4122, -62.0766, 37.8587>, <0.644, -0.689, -0.334> }
	smooth_triangle { <230.4122, -62.0766, 37.8587>, <-0.644, 0.689, 0.334>, <230.3243, -62.1748, 38.2776>, <-0.539, 0.838, 0.083>, <225.9427, -65.1015, 39.3428>, <-0.579, 0.766, -0.279> }

	texture { CUSTOM_TUBE_bl }
}

/* Object 'CUSTOM_T' */
union {
	smooth_triangle { <168.7000, -9.5848, 16.9246>, <-0.500, 0.317, 0.806>, <169.9000, -8.8739, 18.8777>, <-0.998, 0.063, -0.023>, <167.6500, -22.3596, 21.2978>, <-0.652, 0.325, 0.685> }
	smooth_triangle { <167.6500, -22.3596, 21.2978>, <0.331, -0.328, -0.885>, <169.0000, -21.5599, 23.4950>, <0.971, -0.198, -0.131>, <169.9000, -8.8739, 18.8777>, <0.998, -0.063, 0.023> }
	smooth_triangle { <166.3000, -9.5848, 16.9246>, <0.498, 0.233, 0.835>, <168.7000, -9.5848, 16.9246>, <-0.500, 0.317, 0.806>, <164.9500, -22.3596, 21.2978>, <0.320, 0.227, 0.920> }
	smooth_triangle { <164.9500, -22.3596, 21.2978>, <-0.641, -0.142, -0.754>, <167.6500, -22.3596, 21.2978>, <0.331, -0.328, -0.885>, <168.7000, -9.5848, 16.9246>, <0.000, -0.324, -0.946> }
	smooth_triangle { <165.1000, -8.8739, 18.8777>, <0.994, -0.104, 0.038>, <166.3000, -9.5848, 16.9246>, <0.498, 0.233, 0.835>, <163.6000, -21.5599, 23.4950>, <0.962, -0.124, 0.245> }
	smooth_triangle { <163.6000, -21.5599, 23.4950>, <-0.969, 0.211, 0.127>, <164.9500, -22.3596, 21.2978>, <-0.641, -0.142, -0.754>, <166.3000, -9.5848, 16.9246>, <-0.862, -0.080, -0.500> }
	smooth_triangle { <166.3000, -8.1631, 20.8308>, <0.498, -0.358, -0.790>, <165.1000, -8.8739, 18.8777>, <0.994, -0.104, 0.038>, <164.9500, -20.7602, 25.6923>, <0.647, -0.377, -0.663> }
	smooth_triangle { <164.9500, -20.7602, 25.6923>, <-0.322, 0.373, 0.870>, <163.6000, -21.5599, 23.4950>, <-0.969, 0.211, 0.127>, <165.1000, -8.8739, 18.8777>, <-0.862, 0.260, 0.435> }
	smooth_triangle { <168.7000, -8.1631, 20.8308>, <0.000, -0.360, -0.933>, <166.3000, -8.1631, 20.8308>, <0.498, -0.358, -0.790>, <167.6500, -20.7602, 25.6923>, <-0.327, -0.319, -0.890> }
	smooth_triangle { <167.6500, -20.7602, 25.6923>, <0.652, 0.188, 0.735>, <164.9500, -20.7602, 25.6923>, <-0.322, 0.373, 0.870>, <166.3000, -8.1631, 20.8308>, <0.000, 0.360, 0.933> }
	smooth_triangle { <168.7000, -8.1631, 20.8308>, <0.865, 0.117, 0.489>, <169.9000, -8.8739, 18.8777>, <0.998, -0.063, 0.023>, <167.6500, -20.7602, 25.6923>, <0.652, 0.188, 0.735> }
	smooth_triangle { <167.6500, -20.7602, 25.6923>, <-0.327, -0.319, -0.890>, <169.0000, -21.5599, 23.4950>, <-0.971, 0.067, -0.228>, <169.9000, -8.8739, 18.8777>, <-0.998, 0.063, -0.023> }
	smooth_triangle { <167.6500, -22.3596, 21.2978>, <-0.652, 0.325, 0.685>, <169.0000, -21.5599, 23.4950>, <-0.971, 0.067, -0.228>, <164.5800, -36.8688, 26.1640>, <-0.619, 0.447, 0.646> }
	smooth_triangle { <164.5800, -36.8688, 26.1640>, <0.330, -0.366, -0.870>, <166.0601, -36.5685, 28.9577>, <0.916, -0.397, -0.059>, <169.0000, -21.5599, 23.4950>, <0.971, -0.198, -0.131> }
	smooth_triangle { <164.9500, -22.3596, 21.2978>, <0.320, 0.227, 0.920>, <167.6500, -22.3596, 21.2978>, <-0.652, 0.325, 0.685>, <161.6200, -35.6033, 25.7034>, <0.281, 0.161, 0.946> }
	smooth_triangle { <161.6200, -35.6033, 25.7034>, <-0.596, -0.031, -0.802>, <164.5800, -36.8688, 26.1640>, <0.330, -0.366, -0.870>, <167.6500, -22.3596, 21.2978>, <0.331, -0.328, -0.885> }
	smooth_triangle { <163.6000, -21.5599, 23.4950>, <0.962, -0.124, 0.245>, <164.9500, -22.3596, 21.2978>, <0.320, 0.227, 0.920>, <160.1400, -34.0376, 28.0365>, <0.898, -0.312, 0.311> }
	smooth_triangle { <160.1400, -34.0376, 28.0365>, <-0.926, 0.371, 0.076>, <161.6200, -35.6033, 25.7034>, <-0.596, -0.031, -0.802>, <164.9500, -22.3596, 21.2978>, <-0.641, -0.142, -0.754> }
	smooth_triangle { <164.9500, -20.7602, 25.6923>, <0.647, -0.377, -0.663>, <163.6000, -21.5599, 23.4950>, <0.962, -0.124, 0.245>, <161.6200, -33.7373, 30.8303>, <0.604, -0.488, -0.629> }
	smooth_triangle { <161.6200, -33.7373, 30.8303>, <-0.306, 0.414, 0.857>, <160.1400, -34.0376, 28.0365>, <-0.926, 0.371, 0.076>, <163.6000, -21.5599, 23.4950>, <-0.969, 0.211, 0.127> }
	smooth_triangle { <167.6500, -20.7602, 25.6923>, <-0.327, -0.319, -0.890>, <164.9500, -20.7602, 25.6923>, <0.647, -0.377, -0.663>, <164.5800, -35.0028, 31.2909>, <-0.324, -0.282, -0.903> }
	smooth_triangle { <164.5800, -35.0028, 31.2909>, <0.620, 0.076, 0.781>, <161.6200, -33.7373, 30.8303>, <-0.306, 0.414, 0.857>, <164.9500, -20.7602, 25.6923>, <-0.322, 0.373, 0.870> }
	smooth_triangle { <167.6500, -20.7602, 25.6923>, <0.652, 0.188, 0.735>, <169.0000, -21.5599, 23.4950>, <0.971, -0.198, -0.131>, <164.5800, -35.0028, 31.2909>, <0.620, 0.076, 0.781> }
	smooth_triangle { <164.5800, -35.0028, 31.2909>, <-0.324, -0.282, -0.903>, <166.0601, -36.5685, 28.9577>, <-0.916, 0.266, -0.300>, <169.0000, -21.5599, 23.4950>, <-0.971, 0.067, -0.228> }
	smooth_triangle { <164.5800, -36.8688, 26.1640>, <-0.619, 0.447, 0.646>, <166.0601, -36.5685, 28.9577>, <-0.916, 0.266, -0.300>, <156.7250, -51.5115, 31.2031>, <-0.542, 0.580, 0.608> }
	smooth_triangle { <156.7250, -51.5115, 31.2031>, <0.308, -0.448, -0.839>, <157.9501, -51.9242, 34.5467>, <0.799, -0.601, 0.017>, <166.0601, -36.5685, 28.9577>, <0.916, -0.397, -0.059> }
	smooth_triangle { <161.6200, -35.6033, 25.7034>, <0.281, 0.161, 0.946>, <164.5800, -36.8688, 26.1640>, <-0.619, 0.447, 0.646>, <154.2750, -48.6335, 30.1557>, <0.210, 0.105, 0.972> }
	smooth_triangle { <154.2750, -48.6335, 30.1557>, <-0.505, 0.095, -0.858>, <156.7250, -51.5115, 31.2031>, <0.308, -0.448, -0.839>, <164.5800, -36.8688, 26.1640>, <0.330, -0.366, -0.870> }
	smooth_triangle { <160.1400, -34.0376, 28.0365>, <0.898, -0.312, 0.311>, <161.6200, -35.6033, 25.7034>, <0.281, 0.161, 0.946>, <153.0499, -46.1682, 32.4517>, <0.759, -0.514, 0.399> }
	smooth_triangle { <153.0499, -46.1682, 32.4517>, <-0.812, 0.583, 0.007>, <154.2750, -48.6335, 30.1557>, <-0.505, 0.095, -0.858>, <161.6200, -35.6033, 25.7034>, <-0.596, -0.031, -0.802> }
	smooth_triangle { <161.6200, -33.7373, 30.8303>, <0.604, -0.488, -0.629>, <160.1400, -34.0376, 28.0365>, <0.898, -0.312, 0.311>, <154.2750, -46.5809, 35.7953>, <0.500, -0.628, -0.597> }
	smooth_triangle { <154.2750, -46.5809, 35.7953>, <-0.263, 0.481, 0.836>, <153.0499, -46.1682, 32.4517>, <-0.812, 0.583, 0.007>, <160.1400, -34.0376, 28.0365>, <-0.926, 0.371, 0.076> }
	smooth_triangle { <164.5800, -35.0028, 31.2909>, <-0.324, -0.282, -0.903>, <161.6200, -33.7373, 30.8303>, <0.604, -0.488, -0.629>, <156.7250, -49.4588, 36.8428>, <-0.303, -0.200, -0.932> }
	smooth_triangle { <156.7250, -49.4588, 36.8428>, <0.538, -0.058, 0.841>, <154.2750, -46.5809, 35.7953>, <-0.263, 0.481, 0.836>, <161.6200, -33.7373, 30.8303>, <-0.306, 0.414, 0.857> }
	smooth_triangle { <164.5800, -35.0028, 31.2909>, <0.620, 0.076, 0.781>, <166.0601, -36.5685, 28.9577>, <0.916, -0.397, -0.059>, <156.7250, -49.4588, 36.8428>, <0.538, -0.058, 0.841> }
	smooth_triangle { <156.7250, -49.4588, 36.8428>, <-0.303, -0.200, -0.932>, <157.9501, -51.9242, 34.5467>, <-0.799, 0.471, -0.373>, <166.0601, -36.5685, 28.9577>, <-0.916, 0.266, -0.300> }
	smooth_triangle { <156.7250, -51.5115, 31.2031>, <-0.542, 0.580, 0.608>, <157.9501, -51.9242, 34.5467>, <-0.799, 0.471, -0.373>, <145.1786, -64.1198, 35.1535>, <-0.646, 0.692, 0.322> }
	smooth_triangle { <145.1786, -64.1198, 35.1535>, <0.392, -0.585, -0.709>, <146.0573, -65.1015, 39.3428>, <0.651, -0.697, -0.300>, <157.9501, -51.9242, 34.5467>, <0.799, -0.601, 0.017> }
	smooth_triangle { <154.2750, -48.6335, 30.1557>, <0.210, 0.105, 0.972>, <156.7250, -51.5115, 31.2031>, <-0.542, 0.580, 0.608>, <143.4214, -59.6934, 33.5424>, <0.361, 0.436, 0.825> }
	smooth_triangle { <143.4214, -59.6934, 33.5424>, <-0.324, 0.026, -0.946>, <145.1786, -64.1198, 35.1535>, <0.001, -0.641, -0.768>, <156.7250, -51.5115, 31.2031>, <0.308, -0.448, -0.839> }
	smooth_triangle { <153.0499, -46.1682, 32.4517>, <0.759, -0.514, 0.399>, <154.2750, -48.6335, 30.1557>, <0.210, 0.105, 0.972>, <142.5428, -56.2485, 36.1207>, <0.905, -0.282, 0.319> }
	smooth_triangle { <142.5428, -56.2485, 36.1207>, <-0.827, 0.559, -0.055>, <143.4214, -59.6934, 33.5424>, <-0.583, 0.046, -0.811>, <154.2750, -48.6335, 30.1557>, <-0.505, 0.095, -0.858> }
	smooth_triangle { <154.2750, -46.5809, 35.7953>, <0.500, -0.628, -0.597>, <153.0499, -46.1682, 32.4517>, <0.759, -0.514, 0.399>, <143.4214, -57.2302, 40.3100>, <0.795, -0.380, -0.472> }
	smooth_triangle { <143.4214, -57.2302, 40.3100>, <-0.487, 0.423, 0.764>, <142.5428, -56.2485, 36.1207>, <-0.827, 0.559, -0.055>, <153.0499, -46.1682, 32.4517>, <-0.812, 0.583, 0.007> }
	smooth_triangle { <156.7250, -49.4588, 36.8428>, <-0.303, -0.200, -0.932>, <154.2750, -46.5809, 35.7953>, <0.500, -0.628, -0.597>, <145.1786, -61.6566, 41.9211>, <0.003, -0.006, -1.000> }
	smooth_triangle { <145.1786, -61.6566, 41.9211>, <0.388, 0.018, 0.921>, <143.4214, -57.2302, 40.3100>, <-0.487, 0.423, 0.764>, <154.2750, -46.5809, 35.7953>, <-0.263, 0.481, 0.836> }
	smooth_triangle { <156.7250, -49.4588, 36.8428>, <0.538, -0.058, 0.841>, <157.9501, -51.9242, 34.5467>, <0.799, -0.601, 0.017>, <145.1786, -61.6566, 41.9211>, <0.388, 0.018, 0.921> }
	smooth_triangle { <145.1786, -61.6566, 41.9211>, <-0.388, -0.012, -0.921>, <146.0573, -65.1015, 39.3428>, <-0.651, 0.341, -0.678>, <157.9501, -51.9242, 34.5467>, <-0.799, 0.471, -0.373> }
	smooth_triangle { <145.1786, -64.1198, 35.1535>, <0.644, 0.689, 0.334>, <146.0573, -65.1015, 39.3428>, <0.579, 0.766, -0.279>, <141.5878, -62.0766, 37.8587>, <0.539, 0.838, 0.083> }
	smooth_triangle { <141.5878, -62.0766, 37.8587>, <-0.644, -0.689, -0.334>, <141.6757, -62.1748, 38.2776>, <-0.539, -0.838, -0.083>, <146.0573, -65.1015, 39.3428>, <-0.579, -0.766, 0.279> }
	smooth_triangle { <143.4214, -59.6934, 33.5424>, <0.609, 0.280, 0.742>, <145.1786, -64.1198, 35.1535>, <0.644, 0.689, 0.334>, <141.4121, -61.6340, 37.6976>, <0.686, 0.473, 0.553> }
	smooth_triangle { <141.4121, -61.6340, 37.6976>, <-0.838, -0.211, -0.504>, <141.5878, -62.0766, 37.8587>, <-0.644, -0.689, -0.334>, <145.1786, -64.1198, 35.1535>, <-0.357, -0.441, -0.823> }
	smooth_triangle { <142.5428, -56.2485, 36.1207>, <0.905, -0.282, 0.319>, <143.4214, -59.6934, 33.5424>, <0.838, 0.211, 0.504>, <141.3243, -61.2895, 37.9554>, <0.911, -0.072, 0.407> }
	smooth_triangle { <141.3243, -61.2895, 37.9554>, <-0.975, 0.208, -0.076>, <141.4121, -61.6340, 37.6976>, <-0.838, -0.211, -0.504>, <143.4214, -59.6934, 33.5424>, <-0.784, 0.231, -0.576> }
	smooth_triangle { <143.4214, -57.2302, 40.3100>, <0.795, -0.380, -0.472>, <142.5428, -56.2485, 36.1207>, <0.905, -0.282, 0.319>, <141.4122, -61.3877, 38.3743>, <0.911, -0.317, -0.265> }
	smooth_triangle { <141.4122, -61.3877, 38.3743>, <-0.838, 0.162, 0.521>, <141.3243, -61.2895, 37.9554>, <-0.975, 0.208, -0.076>, <142.5428, -56.2485, 36.1207>, <-0.827, 0.559, -0.055> }
	smooth_triangle { <145.1786, -61.6566, 41.9211>, <0.362, -0.195, -0.912>, <143.4214, -57.2302, 40.3100>, <0.795, -0.380, -0.472>, <141.5878, -61.8303, 38.5354>, <0.644, 0.313, -0.699> }
	smooth_triangle { <141.5878, -61.8303, 38.5354>, <-0.644, -0.313, 0.699>, <141.4122, -61.3877, 38.3743>, <-0.838, 0.162, 0.521>, <143.4214, -57.2302, 40.3100>, <-0.487, 0.423, 0.764> }
	smooth_triangle { <145.1786, -61.6566, 41.9211>, <-0.539, -0.588, 0.602>, <146.0573, -65.1015, 39.3428>, <-0.579, -0.766, 0.279>, <141.5878, -61.8303, 38.5354>, <-0.644, -0.313, 0.699> }
	smooth_triangle { <141.5878, -61.8303, 38.5354>, <0.644, 0.313, -0.699>, <141.6757, -62.1748, 38.2776>, <0.539, 0.588, -0.602>, <146.0573, -65.1015, 39.3428>, <0.579, 0.766, -0.279> }

	texture { CUSTOM_TUBE_bl }
}

/* Object 'ICP35' */
union {
	smooth_triangle { <168.5871, 115.5089, 43.0329>, <-0.277, 0.594, 0.755>, <163.6187, 103.8218, 48.3094>, <-0.278, 0.439, 0.854>, <158.3121, 112.3868, 40.7999>, <-0.398, 0.571, 0.718> texture { ICP35_orangish }}
	smooth_triangle { <168.5871, 115.5089, 43.0329>, <0.218, -0.565, -0.796>, <174.9731, 106.1118, 50.2289>, <0.107, -0.462, -0.881>, <180.0931, 117.3358, 43.8559>, <0.028, -0.503, -0.864> texture { ICP35_orangish }}
	smooth_triangle { <163.6187, 103.8218, 48.3094>, <0.353, -0.401, -0.846>, <174.9731, 106.1118, 50.2289>, <0.107, -0.462, -0.881>, <168.5871, 115.5089, 43.0329>, <0.218, -0.565, -0.796> texture { ICP35_orangish }}
	smooth_triangle { <163.6187, 103.8218, 48.3094>, <-0.278, 0.439, 0.854>, <174.9731, 106.1118, 50.2289>, <-0.227, 0.373, 0.899>, <170.1831, 93.2238, 54.3694>, <-0.253, 0.259, 0.932> texture { ICP35_orangish }}
	smooth_triangle { <182.0721, 94.7138, 55.4579>, <0.053, -0.350, -0.935>, <174.9731, 106.1118, 50.2289>, <0.107, -0.462, -0.881>, <170.1831, 93.2238, 54.3694>, <0.189, -0.300, -0.935> texture { ICP35_orangish }}
	smooth_triangle { <177.3276, 81.6878, 58.0254>, <0.162, -0.158, -0.974>, <182.0721, 94.7138, 55.4579>, <0.053, -0.350, -0.935>, <170.1831, 93.2238, 54.3694>, <0.189, -0.300, -0.935> texture { ICP35_orangish }}
	smooth_triangle { <142.6506, 78.5483, 43.0329>, <-0.694, 0.071, 0.717>, <149.1321, 67.5493, 48.3094>, <-0.560, 0.000, 0.828>, <140.0871, 66.7593, 40.7999>, <-0.732, -0.027, 0.681> texture { ICP35_black_2 }}
	smooth_triangle { <142.6506, 78.5483, 43.0329>, <0.641, -0.101, -0.761>, <152.8411, 79.9728, 50.2289>, <0.525, -0.086, -0.846>, <146.7841, 90.8828, 43.8564>, <0.632, -0.253, -0.732> texture { ICP35_black_2 }}
	smooth_triangle { <149.1321, 67.5493, 48.3094>, <0.564, 0.074, -0.823>, <152.8411, 79.9728, 50.2289>, <0.525, -0.086, -0.846>, <142.6506, 78.5483, 43.0329>, <0.641, -0.101, -0.761> texture { ICP35_black_2 }}
	smooth_triangle { <149.1321, 67.5493, 48.3094>, <-0.560, 0.000, 0.828>, <152.8411, 79.9728, 50.2289>, <-0.467, 0.125, 0.876>, <160.3181, 68.5303, 54.3694>, <-0.383, -0.068, 0.921> texture { ICP35_orangish }}
	smooth_triangle { <164.8951, 81.0693, 55.4579>, <-0.313, 0.188, 0.931>, <157.8471, 92.5143, 50.2289>, <-0.439, 0.222, 0.871>, <170.1831, 93.2238, 54.3694>, <-0.253, 0.259, 0.932> texture { ICP35_orangish }}
	smooth_triangle { <157.8471, 92.5143, 50.2289>, <-0.439, 0.222, 0.871>, <152.8411, 79.9728, 50.2289>, <-0.467, 0.125, 0.876>, <146.7841, 90.8828, 43.8564>, <-0.574, 0.230, 0.786> texture { ICP35_black_2 }}
	smooth_triangle { <164.8951, 81.0693, 55.4579>, <-0.313, 0.188, 0.931>, <152.8411, 79.9728, 50.2289>, <-0.467, 0.125, 0.876>, <157.8471, 92.5143, 50.2289>, <-0.439, 0.222, 0.871> texture { ICP35_orangish }}
	smooth_triangle { <164.8951, 81.0693, 55.4579>, <0.300, -0.058, -0.952>, <152.8411, 79.9728, 50.2289>, <0.525, -0.086, -0.846>, <160.3181, 68.5303, 54.3694>, <0.389, 0.000, -0.921> texture { ICP35_orangish }}
	smooth_triangle { <152.2226, 102.5113, 43.0334>, <0.521, -0.413, -0.747>, <163.6187, 103.8218, 48.3094>, <0.353, -0.401, -0.846>, <158.3121, 112.3868, 40.7999>, <0.475, -0.462, -0.749> texture { ICP35_orangish }}
	smooth_triangle { <163.6187, 103.8218, 48.3094>, <0.353, -0.401, -0.846>, <157.8471, 92.5143, 50.2289>, <0.373, -0.337, -0.864>, <170.1831, 93.2238, 54.3694>, <0.189, -0.300, -0.935> texture { ICP35_orangish }}
	smooth_triangle { <152.2226, 102.5113, 43.0334>, <0.521, -0.413, -0.747>, <157.8471, 92.5143, 50.2289>, <0.373, -0.337, -0.864>, <163.6187, 103.8218, 48.3094>, <0.353, -0.401, -0.846> texture { ICP35_orangish }}
	smooth_triangle { <152.2226, 102.5113, 43.0334>, <-0.509, 0.295, 0.808>, <157.8471, 92.5143, 50.2289>, <-0.439, 0.222, 0.871>, <146.7841, 90.8828, 43.8564>, <-0.574, 0.230, 0.786> texture { ICP35_black_2 }}
	smooth_triangle { <172.4976, 69.5953, 58.0254>, <-0.157, -0.030, 0.987>, <177.3276, 81.6878, 58.0254>, <-0.070, 0.126, 0.990>, <184.1781, 70.6178, 59.1339>, <-0.030, 0.048, 0.998> texture { ICP35_orangish }}
	smooth_triangle { <172.4976, 69.5953, 58.0254>, <0.229, 0.004, -0.974>, <164.8951, 81.0693, 55.4579>, <0.300, -0.058, -0.952>, <160.3181, 68.5303, 54.3694>, <0.389, 0.000, -0.921> texture { ICP35_orangish }}
	smooth_triangle { <177.3276, 81.6878, 58.0254>, <0.162, -0.158, -0.974>, <164.8951, 81.0693, 55.4579>, <0.300, -0.058, -0.952>, <172.4976, 69.5953, 58.0254>, <0.229, 0.004, -0.974> texture { ICP35_orangish }}
	smooth_triangle { <177.3276, 81.6878, 58.0254>, <-0.070, 0.126, 0.990>, <164.8951, 81.0693, 55.4579>, <-0.313, 0.188, 0.931>, <170.1831, 93.2238, 54.3694>, <-0.253, 0.259, 0.932> texture { ICP35_orangish }}
	smooth_triangle { <158.2411, 33.6548, 43.0334>, <-0.501, -0.446, 0.742>, <169.6951, 34.3499, 48.3094>, <-0.313, -0.379, 0.871>, <166.2796, 21.3428, 40.7999>, <-0.303, -0.773, 0.557> texture { ICP35_orangish }}
	smooth_triangle { <158.2411, 33.6548, 43.0334>, <0.443, 0.448, -0.777>, <162.0481, 44.4818, 50.2289>, <0.364, 0.362, -0.858>, <150.8716, 44.1683, 43.8564>, <0.579, 0.359, -0.733> texture { ICP35_orangish }}
	smooth_triangle { <169.6951, 34.3499, 48.3094>, <0.188, 0.461, -0.867>, <162.0481, 44.4818, 50.2289>, <0.364, 0.362, -0.858>, <158.2411, 33.6548, 43.0334>, <0.443, 0.448, -0.777> texture { ICP35_orangish }}
	smooth_triangle { <169.6951, 34.3499, 48.3094>, <-0.313, -0.379, 0.871>, <162.0481, 44.4818, 50.2289>, <-0.368, -0.296, 0.881>, <174.3186, 45.9268, 54.3694>, <-0.134, -0.328, 0.935> texture { ICP35_orangish }}
	smooth_triangle { <167.0006, 56.9753, 55.4579>, <-0.347, -0.147, 0.927>, <154.9396, 55.9573, 50.2289>, <-0.446, -0.226, 0.866>, <160.3181, 68.5303, 54.3694>, <-0.383, -0.068, 0.921> texture { ICP35_orangish }}
	smooth_triangle { <154.9396, 55.9573, 50.2289>, <-0.446, -0.226, 0.866>, <162.0481, 44.4818, 50.2289>, <-0.368, -0.296, 0.881>, <150.8716, 44.1683, 43.8564>, <-0.526, -0.326, 0.786> texture { ICP35_orangish }}
	smooth_triangle { <167.0006, 56.9753, 55.4579>, <-0.347, -0.147, 0.927>, <162.0481, 44.4818, 50.2289>, <-0.368, -0.296, 0.881>, <154.9396, 55.9573, 50.2289>, <-0.446, -0.226, 0.866> texture { ICP35_orangish }}
	smooth_triangle { <167.0006, 56.9753, 55.4579>, <0.214, 0.201, -0.956>, <162.0481, 44.4818, 50.2289>, <0.364, 0.362, -0.858>, <174.3186, 45.9268, 54.3694>, <0.205, 0.299, -0.932> texture { ICP35_orangish }}
	smooth_triangle { <144.6576, 55.5963, 43.0329>, <0.660, 0.192, -0.726>, <149.1321, 67.5493, 48.3094>, <0.564, 0.074, -0.823>, <140.0871, 66.7593, 40.7999>, <0.679, 0.134, -0.722> texture { ICP35_orangish }}
	smooth_triangle { <149.1321, 67.5493, 48.3094>, <0.564, 0.074, -0.823>, <154.9396, 55.9573, 50.2289>, <0.517, 0.119, -0.848>, <160.3181, 68.5303, 54.3694>, <0.389, 0.000, -0.921> texture { ICP35_orangish }}
	smooth_triangle { <144.6576, 55.5963, 43.0329>, <0.660, 0.192, -0.726>, <154.9396, 55.9573, 50.2289>, <0.517, 0.119, -0.848>, <149.1321, 67.5493, 48.3094>, <0.564, 0.074, -0.823> texture { ICP35_orangish }}
	smooth_triangle { <144.6576, 55.5963, 43.0329>, <-0.551, -0.242, 0.799>, <154.9396, 55.9573, 50.2289>, <-0.446, -0.226, 0.866>, <150.8716, 44.1683, 43.8564>, <-0.526, -0.326, 0.786> texture { ICP35_orangish }}
	smooth_triangle { <179.3536, 58.5283, 58.0254>, <-0.083, -0.153, 0.985>, <172.4976, 69.5953, 58.0254>, <-0.157, -0.030, 0.987>, <184.1781, 70.6178, 59.1339>, <-0.030, 0.048, 0.998> texture { ICP35_orangish }}
	smooth_triangle { <179.3536, 58.5283, 58.0254>, <0.080, 0.157, -0.984>, <167.0006, 56.9753, 55.4579>, <0.214, 0.201, -0.956>, <174.3186, 45.9268, 54.3694>, <0.205, 0.299, -0.932> texture { ICP35_orangish }}
	smooth_triangle { <172.4976, 69.5953, 58.0254>, <0.229, 0.004, -0.974>, <167.0006, 56.9753, 55.4579>, <0.214, 0.201, -0.956>, <179.3536, 58.5283, 58.0254>, <0.080, 0.157, -0.984> texture { ICP35_orangish }}
	smooth_triangle { <172.4976, 69.5953, 58.0254>, <-0.157, -0.030, 0.987>, <167.0006, 56.9753, 55.4579>, <-0.347, -0.147, 0.927>, <160.3181, 68.5303, 54.3694>, <-0.383, -0.068, 0.921> texture { ICP35_orangish }}
	smooth_triangle { <186.2866, 46.5244, 55.4579>, <-0.002, -0.326, 0.945>, <181.2731, 34.0653, 50.2289>, <0.018, -0.456, 0.890>, <174.3186, 45.9268, 54.3694>, <-0.134, -0.328, 0.935> texture { ICP35_orangish }}
	smooth_triangle { <176.6191, 23.7014, 43.0329>, <0.083, 0.704, -0.705>, <169.6951, 34.3499, 48.3094>, <0.188, 0.461, -0.867>, <166.2796, 21.3428, 40.7999>, <-0.047, 0.787, -0.615> texture { ICP35_orangish }}
	smooth_triangle { <169.6951, 34.3499, 48.3094>, <0.188, 0.461, -0.867>, <181.2731, 34.0653, 50.2289>, <0.156, 0.463, -0.873>, <174.3186, 45.9268, 54.3694>, <0.205, 0.299, -0.932> texture { ICP35_orangish }}
	smooth_triangle { <176.6191, 23.7014, 43.0329>, <0.083, 0.704, -0.705>, <181.2731, 34.0653, 50.2289>, <0.156, 0.463, -0.873>, <169.6951, 34.3499, 48.3094>, <0.188, 0.461, -0.867> texture { ICP35_orangish }}
	smooth_triangle { <176.6191, 23.7014, 43.0329>, <0.040, -0.879, 0.474>, <181.2731, 34.0653, 50.2289>, <0.018, -0.456, 0.890>, <188.2661, 23.9038, 43.8559>, <0.000, -0.648, 0.762> texture { ICP35_orangish }}
	smooth_triangle { <179.3536, 58.5283, 58.0254>, <-0.083, -0.153, 0.985>, <186.2866, 46.5244, 55.4579>, <-0.002, -0.326, 0.945>, <174.3186, 45.9268, 54.3694>, <-0.134, -0.328, 0.935> texture { ICP35_orangish }}
	smooth_triangle { <161.5076, 123.8033, 32.4464>, <-0.393, 0.684, 0.615>, <168.5871, 115.5089, 43.0329>, <-0.277, 0.594, 0.755>, <158.3121, 112.3868, 40.7999>, <-0.398, 0.571, 0.718> texture { ICP35_orangish }}
	smooth_triangle { <161.5076, 123.8033, 32.4464>, <0.274, -0.725, -0.632>, <173.0146, 126.9468, 33.8359>, <0.274, -0.725, -0.632>, <166.3001, 133.6178, 21.1854>, <0.311, -0.857, -0.411> texture { ICP35_orangish }}
	smooth_triangle { <168.5871, 115.5089, 43.0329>, <0.218, -0.565, -0.796>, <173.0146, 126.9468, 33.8359>, <0.274, -0.725, -0.632>, <161.5076, 123.8033, 32.4464>, <0.274, -0.725, -0.632> texture { ICP35_orangish }}
	smooth_triangle { <168.5871, 115.5089, 43.0329>, <-0.277, 0.594, 0.755>, <173.0146, 126.9468, 33.8359>, <-0.066, 0.761, 0.645>, <180.0931, 117.3358, 43.8559>, <-0.007, 0.719, 0.695> texture { ICP35_orangish }}
	smooth_triangle { <178.4656, 135.9718, 21.6773>, <-0.078, 0.852, 0.518>, <173.0146, 126.9468, 33.8359>, <-0.066, 0.761, 0.645>, <166.3001, 133.6178, 21.1854>, <-0.242, 0.845, 0.476> texture { ICP35_orangish }}
	smooth_triangle { <172.1226, 139.8083, 8.5069>, <-0.236, 0.941, 0.241>, <178.4656, 135.9718, 21.6773>, <-0.078, 0.852, 0.518>, <166.3001, 133.6178, 21.1854>, <-0.242, 0.845, 0.476> texture { ICP35_orangish }}
	smooth_triangle { <148.2476, 128.6443, 8.2654>, <0.629, -0.758, -0.174>, <154.4271, 134.3853, -3.4625>, <0.465, -0.792, -0.396>, <147.5991, 129.6913, -3.4625>, <0.572, -0.720, -0.393> texture { ICP35_orangish }}
	smooth_triangle { <148.2476, 128.6443, 8.2654>, <-0.594, 0.784, 0.179>, <155.5496, 133.5248, 8.5758>, <-0.509, 0.841, 0.182>, <150.3851, 125.1938, 20.4919>, <-0.564, 0.714, 0.414> texture { ICP35_orangish }}
	smooth_triangle { <154.4271, 134.3853, -3.4625>, <-0.467, 0.788, 0.401>, <155.5496, 133.5248, 8.5758>, <-0.509, 0.841, 0.182>, <148.2476, 128.6443, 8.2654>, <-0.594, 0.784, 0.179> texture { ICP35_orangish }}
	smooth_triangle { <154.4271, 134.3853, -3.4625>, <0.465, -0.792, -0.396>, <155.5496, 133.5248, 8.5758>, <0.459, -0.852, -0.253>, <162.0136, 138.1348, -3.4625>, <0.350, -0.797, -0.493> texture { ICP35_orangish }}
	smooth_triangle { <163.6576, 137.3353, 8.6613>, <0.350, -0.877, -0.329>, <157.9651, 129.9438, 21.0799>, <0.451, -0.809, -0.377>, <166.3001, 133.6178, 21.1854>, <0.311, -0.857, -0.411> texture { ICP35_orangish }}
	smooth_triangle { <157.9651, 129.9438, 21.0799>, <0.451, -0.809, -0.377>, <155.5496, 133.5248, 8.5758>, <0.459, -0.852, -0.253>, <150.3851, 125.1938, 20.4919>, <0.578, -0.727, -0.370> texture { ICP35_orangish }}
	smooth_triangle { <163.6576, 137.3353, 8.6613>, <0.350, -0.877, -0.329>, <155.5496, 133.5248, 8.5758>, <0.459, -0.852, -0.253>, <157.9651, 129.9438, 21.0799>, <0.451, -0.809, -0.377> texture { ICP35_orangish }}
	smooth_triangle { <163.6576, 137.3353, 8.6613>, <-0.335, 0.935, 0.114>, <155.5496, 133.5248, 8.5758>, <-0.509, 0.841, 0.182>, <162.0136, 138.1348, -3.4625>, <-0.333, 0.892, 0.305> texture { ICP35_orangish }}
	smooth_triangle { <153.9251, 119.4758, 31.7224>, <-0.514, 0.628, 0.584>, <161.5076, 123.8033, 32.4464>, <-0.393, 0.684, 0.615>, <158.3121, 112.3868, 40.7999>, <-0.398, 0.571, 0.718> texture { ICP35_orangish }}
	smooth_triangle { <161.5076, 123.8033, 32.4464>, <-0.393, 0.684, 0.615>, <157.9651, 129.9438, 21.0799>, <-0.404, 0.746, 0.529>, <166.3001, 133.6178, 21.1854>, <-0.242, 0.845, 0.476> texture { ICP35_orangish }}
	smooth_triangle { <153.9251, 119.4758, 31.7224>, <-0.514, 0.628, 0.584>, <157.9651, 129.9438, 21.0799>, <-0.404, 0.746, 0.529>, <161.5076, 123.8033, 32.4464>, <-0.393, 0.684, 0.615> texture { ICP35_orangish }}
	smooth_triangle { <153.9251, 119.4758, 31.7224>, <0.484, -0.709, -0.513>, <157.9651, 129.9438, 21.0799>, <0.451, -0.809, -0.377>, <150.3851, 125.1938, 20.4919>, <0.578, -0.727, -0.370> texture { ICP35_orangish }}
	smooth_triangle { <169.9931, 140.6908, -3.4625>, <0.178, -0.851, -0.494>, <172.1226, 139.8083, 8.5069>, <0.105, -0.969, -0.222>, <177.9401, 141.9818, -3.4625>, <0.059, -0.937, -0.344> texture { ICP35_orangish }}
	smooth_triangle { <169.9931, 140.6908, -3.4625>, <-0.244, 0.920, 0.307>, <163.6576, 137.3353, 8.6613>, <-0.335, 0.935, 0.114>, <162.0136, 138.1348, -3.4625>, <-0.333, 0.892, 0.305> texture { ICP35_orangish }}
	smooth_triangle { <172.1226, 139.8083, 8.5069>, <-0.236, 0.941, 0.241>, <163.6576, 137.3353, 8.6613>, <-0.335, 0.935, 0.114>, <169.9931, 140.6908, -3.4625>, <-0.244, 0.920, 0.307> texture { ICP35_orangish }}
	smooth_triangle { <172.1226, 139.8083, 8.5069>, <0.105, -0.969, -0.222>, <163.6576, 137.3353, 8.6613>, <0.350, -0.877, -0.329>, <166.3001, 133.6178, 21.1854>, <0.311, -0.857, -0.411> texture { ICP35_orangish }}
	smooth_triangle { <130.8427, 107.0278, 8.5069>, <0.893, -0.398, -0.210>, <130.8336, 109.5943, -3.4625>, <0.849, -0.448, -0.281>, <127.0581, 101.5708, -3.4625>, <0.906, -0.349, -0.238> texture { ICP35_orangish }}
	smooth_triangle { <130.8427, 107.0278, 8.5069>, <-0.839, 0.503, 0.207>, <135.7806, 115.1983, 8.6613>, <-0.819, 0.546, 0.176>, <137.9661, 111.1153, 21.1854>, <-0.767, 0.459, 0.448> texture { ICP35_orangish }}
	smooth_triangle { <130.8336, 109.5943, -3.4625>, <-0.766, 0.437, 0.471>, <135.7806, 115.1983, 8.6613>, <-0.819, 0.546, 0.176>, <130.8427, 107.0278, 8.5069>, <-0.839, 0.503, 0.207> texture { ICP35_orangish }}
	smooth_triangle { <130.8336, 109.5943, -3.4625>, <0.849, -0.448, -0.281>, <135.7806, 115.1983, 8.6613>, <0.780, -0.576, -0.243>, <135.6761, 117.2193, -3.4625>, <0.781, -0.496, -0.378> texture { ICP35_orangish }}
	smooth_triangle { <141.7066, 122.5318, 8.5764>, <0.678, -0.664, -0.314>, <143.8581, 118.7358, 21.0804>, <0.708, -0.604, -0.366>, <150.3851, 125.1938, 20.4919>, <0.578, -0.727, -0.370> texture { ICP35_orangish }}
	smooth_triangle { <143.8581, 118.7358, 21.0804>, <0.708, -0.604, -0.366>, <135.7806, 115.1983, 8.6613>, <0.780, -0.576, -0.243>, <137.9661, 111.1153, 21.1854>, <0.761, -0.520, -0.389> texture { ICP35_orangish }}
	smooth_triangle { <141.7066, 122.5318, 8.5764>, <0.678, -0.664, -0.314>, <135.7806, 115.1983, 8.6613>, <0.780, -0.576, -0.243>, <143.8581, 118.7358, 21.0804>, <0.708, -0.604, -0.366> texture { ICP35_orangish }}
	smooth_triangle { <141.7066, 122.5318, 8.5764>, <-0.738, 0.666, 0.107>, <135.7806, 115.1983, 8.6613>, <-0.819, 0.546, 0.176>, <135.6761, 117.2193, -3.4625>, <-0.727, 0.569, 0.385> texture { ICP35_orangish }}
	smooth_triangle { <147.7481, 112.8783, 32.4464>, <-0.604, 0.549, 0.578>, <153.9251, 119.4758, 31.7224>, <-0.514, 0.628, 0.584>, <158.3121, 112.3868, 40.7999>, <-0.398, 0.571, 0.718> texture { ICP35_orangish }}
	smooth_triangle { <153.9251, 119.4758, 31.7224>, <-0.514, 0.628, 0.584>, <143.8581, 118.7358, 21.0804>, <-0.589, 0.624, 0.513>, <150.3851, 125.1938, 20.4919>, <-0.564, 0.714, 0.414> texture { ICP35_orangish }}
	smooth_triangle { <147.7481, 112.8783, 32.4464>, <-0.604, 0.549, 0.578>, <143.8581, 118.7358, 21.0804>, <-0.589, 0.624, 0.513>, <153.9251, 119.4758, 31.7224>, <-0.514, 0.628, 0.584> texture { ICP35_orangish }}
	smooth_triangle { <147.7481, 112.8783, 32.4464>, <0.605, -0.486, -0.630>, <143.8581, 118.7358, 21.0804>, <0.708, -0.604, -0.366>, <137.9661, 111.1153, 21.1854>, <0.761, -0.520, -0.389> texture { ICP35_orangish }}
	smooth_triangle { <141.3741, 124.0193, -3.4625>, <0.660, -0.644, -0.386>, <148.2476, 128.6443, 8.2654>, <0.629, -0.758, -0.174>, <147.5991, 129.6913, -3.4625>, <0.572, -0.720, -0.393> texture { ICP35_orangish }}
	smooth_triangle { <141.3741, 124.0193, -3.4625>, <-0.666, 0.636, 0.389>, <141.7066, 122.5318, 8.5764>, <-0.738, 0.666, 0.107>, <135.6761, 117.2193, -3.4625>, <-0.727, 0.569, 0.385> texture { ICP35_orangish }}
	smooth_triangle { <148.2476, 128.6443, 8.2654>, <-0.594, 0.784, 0.179>, <141.7066, 122.5318, 8.5764>, <-0.738, 0.666, 0.107>, <141.3741, 124.0193, -3.4625>, <-0.666, 0.636, 0.389> texture { ICP35_orangish }}
	smooth_triangle { <148.2476, 128.6443, 8.2654>, <0.629, -0.758, -0.174>, <141.7066, 122.5318, 8.5764>, <0.678, -0.664, -0.314>, <150.3851, 125.1938, 20.4919>, <0.578, -0.727, -0.370> texture { ICP35_orangish }}
	smooth_triangle { <132.9601, 75.8578, 32.4464>, <-0.819, 0.027, 0.573>, <142.6506, 78.5483, 43.0329>, <-0.694, 0.071, 0.717>, <140.0871, 66.7593, 40.7999>, <-0.732, -0.027, 0.681> texture { ICP35_black_2 }}
	smooth_triangle { <132.9601, 75.8578, 32.4464>, <0.799, -0.130, -0.588>, <136.0971, 88.8763, 33.8359>, <0.764, -0.179, -0.620>, <127.8171, 85.7068, 21.1854>, <0.914, -0.159, -0.373> texture { ICP35_black_2 }}
	smooth_triangle { <142.6506, 78.5483, 43.0329>, <0.641, -0.101, -0.761>, <136.0971, 88.8763, 33.8359>, <0.764, -0.179, -0.620>, <132.9601, 75.8578, 32.4464>, <0.799, -0.130, -0.588> texture { ICP35_black_2 }}
	smooth_triangle { <142.6506, 78.5483, 43.0329>, <-0.694, 0.071, 0.717>, <136.0971, 88.8763, 33.8359>, <-0.777, 0.247, 0.578>, <146.7841, 90.8828, 43.8564>, <-0.574, 0.230, 0.786> texture { ICP35_black_2 }}
	smooth_triangle { <141.2181, 101.6943, 33.8364>, <-0.753, 0.399, 0.523>, <131.8671, 98.9648, 21.6773>, <-0.830, 0.308, 0.465>, <137.9661, 111.1153, 21.1854>, <-0.767, 0.459, 0.448> texture { ICP35_black_2 }}
	smooth_triangle { <131.8671, 98.9648, 21.6773>, <-0.830, 0.308, 0.465>, <136.0971, 88.8763, 33.8359>, <-0.777, 0.247, 0.578>, <127.8171, 85.7068, 21.1854>, <-0.878, 0.202, 0.435> texture { ICP35_black_2 }}
	smooth_triangle { <141.2181, 101.6943, 33.8364>, <-0.753, 0.399, 0.523>, <136.0971, 88.8763, 33.8359>, <-0.777, 0.247, 0.578>, <131.8671, 98.9648, 21.6773>, <-0.830, 0.308, 0.465> texture { ICP35_black_2 }}
	smooth_triangle { <141.2181, 101.6943, 33.8364>, <0.635, -0.349, -0.689>, <136.0971, 88.8763, 33.8359>, <0.764, -0.179, -0.620>, <146.7841, 90.8828, 43.8564>, <0.632, -0.253, -0.732> texture { ICP35_black_2 }}
	smooth_triangle { <125.9166, 94.6858, 8.5069>, <0.928, -0.315, -0.200>, <130.8427, 107.0278, 8.5069>, <0.893, -0.398, -0.210>, <127.0581, 101.5708, -3.4625>, <0.906, -0.349, -0.238> texture { ICP35_orangish }}
	smooth_triangle { <130.8427, 107.0278, 8.5069>, <0.893, -0.398, -0.210>, <131.8671, 98.9648, 21.6773>, <0.865, -0.395, -0.309>, <137.9661, 111.1153, 21.1854>, <0.761, -0.520, -0.389> texture { ICP35_orangish }}
	smooth_triangle { <125.9166, 94.6858, 8.5069>, <0.928, -0.315, -0.200>, <131.8671, 98.9648, 21.6773>, <0.865, -0.395, -0.309>, <130.8427, 107.0278, 8.5069>, <0.893, -0.398, -0.210> texture { ICP35_orangish }}
	smooth_triangle { <125.9166, 94.6858, 8.5069>, <-0.945, 0.245, 0.217>, <131.8671, 98.9648, 21.6773>, <-0.830, 0.308, 0.465>, <127.8171, 85.7068, 21.1854>, <-0.878, 0.202, 0.435> texture { ICP35_orangish }}
	smooth_triangle { <147.7481, 112.8783, 32.4464>, <0.605, -0.486, -0.630>, <152.2226, 102.5113, 43.0334>, <0.521, -0.413, -0.747>, <158.3121, 112.3868, 40.7999>, <0.475, -0.462, -0.749> texture { ICP35_orangish }}
	smooth_triangle { <152.2226, 102.5113, 43.0334>, <0.521, -0.413, -0.747>, <141.2181, 101.6943, 33.8364>, <0.635, -0.349, -0.689>, <146.7841, 90.8828, 43.8564>, <0.632, -0.253, -0.732> texture { ICP35_black_2 }}
	smooth_triangle { <147.7481, 112.8783, 32.4464>, <0.605, -0.486, -0.630>, <141.2181, 101.6943, 33.8364>, <0.635, -0.349, -0.689>, <152.2226, 102.5113, 43.0334>, <0.521, -0.413, -0.747> texture { ICP35_black_2 }}
	smooth_triangle { <147.7481, 112.8783, 32.4464>, <-0.604, 0.549, 0.578>, <141.2181, 101.6943, 33.8364>, <-0.753, 0.399, 0.523>, <137.9661, 111.1153, 21.1854>, <-0.767, 0.459, 0.448> texture { ICP35_black_2 }}
	smooth_triangle { <122.9296, 65.2558, 8.2654>, <0.982, 0.104, -0.159>, <121.5401, 74.3568, -3.4625>, <0.930, -0.025, -0.366>, <121.8231, 65.1613, -3.4625>, <0.927, 0.081, -0.366> texture { ICP35_orangish }}
	smooth_triangle { <122.9296, 65.2558, 8.2654>, <-0.984, -0.067, 0.163>, <122.7321, 75.0178, 8.5758>, <-0.986, 0.015, 0.164>, <126.5696, 65.5753, 20.4919>, <-0.921, -0.079, 0.383> texture { ICP35_orangish }}
	smooth_triangle { <121.5401, 74.3568, -3.4625>, <-0.929, 0.022, 0.370>, <122.7321, 75.0178, 8.5758>, <-0.986, 0.015, 0.164>, <122.9296, 65.2558, 8.2654>, <-0.984, -0.067, 0.163> texture { ICP35_orangish }}
	smooth_triangle { <121.5401, 74.3568, -3.4625>, <0.930, -0.025, -0.366>, <122.7321, 75.0178, 8.5758>, <0.972, -0.054, -0.228>, <122.3341, 83.8138, -3.4625>, <0.884, -0.107, -0.455> texture { ICP35_orangish }}
	smooth_triangle { <123.7281, 85.0243, 8.6613>, <0.945, -0.139, -0.296>, <126.6066, 75.5493, 21.0799>, <0.938, -0.041, -0.343>, <127.8171, 85.7068, 21.1854>, <0.914, -0.159, -0.373> texture { ICP35_orangish }}
	smooth_triangle { <126.6066, 75.5493, 21.0799>, <0.938, -0.041, -0.343>, <122.7321, 75.0178, 8.5758>, <0.972, -0.054, -0.228>, <126.5696, 65.5753, 20.4919>, <0.937, 0.083, -0.340> texture { ICP35_orangish }}
	smooth_triangle { <123.7281, 85.0243, 8.6613>, <0.945, -0.139, -0.296>, <122.7321, 75.0178, 8.5758>, <0.972, -0.054, -0.228>, <126.6066, 75.5493, 21.0799>, <0.938, -0.041, -0.343> texture { ICP35_orangish }}
	smooth_triangle { <123.7281, 85.0243, 8.6613>, <-0.980, 0.173, 0.101>, <122.7321, 75.0178, 8.5758>, <-0.986, 0.015, 0.164>, <122.3341, 83.8138, -3.4625>, <-0.947, 0.158, 0.280> texture { ICP35_orangish }}
	smooth_triangle { <132.6076, 66.1049, 31.7224>, <-0.832, -0.083, 0.548>, <132.9601, 75.8578, 32.4464>, <-0.819, 0.027, 0.573>, <140.0871, 66.7593, 40.7999>, <-0.732, -0.027, 0.681> texture { ICP35_orangish }}
	smooth_triangle { <132.9601, 75.8578, 32.4464>, <-0.819, 0.027, 0.573>, <126.6066, 75.5493, 21.0799>, <-0.872, 0.047, 0.486>, <127.8171, 85.7068, 21.1854>, <-0.878, 0.202, 0.435> texture { ICP35_orangish }}
	smooth_triangle { <132.6076, 66.1049, 31.7224>, <-0.832, -0.083, 0.548>, <126.6066, 75.5493, 21.0799>, <-0.872, 0.047, 0.486>, <132.9601, 75.8578, 32.4464>, <-0.819, 0.027, 0.573> texture { ICP35_orangish }}
	smooth_triangle { <132.6076, 66.1049, 31.7224>, <0.880, 0.025, -0.474>, <126.6066, 75.5493, 21.0799>, <0.938, -0.041, -0.343>, <126.5696, 65.5753, 20.4919>, <0.937, 0.083, -0.340> texture { ICP35_orangish }}
	smooth_triangle { <124.2236, 93.0368, -3.4625>, <0.854, -0.249, -0.457>, <125.9166, 94.6858, 8.5069>, <0.928, -0.315, -0.200>, <127.0581, 101.5708, -3.4625>, <0.906, -0.349, -0.238> texture { ICP35_orangish }}
	smooth_triangle { <124.2236, 93.0368, -3.4625>, <-0.931, 0.231, 0.282>, <123.7281, 85.0243, 8.6613>, <-0.980, 0.173, 0.101>, <122.3341, 83.8138, -3.4625>, <-0.947, 0.158, 0.280> texture { ICP35_orangish }}
	smooth_triangle { <125.9166, 94.6858, 8.5069>, <-0.945, 0.245, 0.217>, <123.7281, 85.0243, 8.6613>, <-0.980, 0.173, 0.101>, <124.2236, 93.0368, -3.4625>, <-0.931, 0.231, 0.282> texture { ICP35_orangish }}
	smooth_triangle { <125.9166, 94.6858, 8.5069>, <0.928, -0.315, -0.200>, <123.7281, 85.0243, 8.6613>, <0.945, -0.139, -0.296>, <127.8171, 85.7068, 21.1854>, <0.914, -0.159, -0.373> texture { ICP35_orangish }}
	smooth_triangle { <130.9781, 36.7943, 8.5069>, <0.851, 0.483, -0.208>, <129.0256, 38.1248, -3.4625>, <0.864, 0.420, -0.277>, <133.3001, 30.2108, -3.4625>, <0.860, 0.498, -0.107> texture { ICP35_orangish }}
	smooth_triangle { <130.9781, 36.7943, 8.5069>, <-0.902, -0.382, 0.200>, <127.1471, 45.9308, 8.6613>, <-0.923, -0.345, 0.169>, <131.2926, 45.9698, 21.1854>, <-0.829, -0.351, 0.435> texture { ICP35_orangish }}
	smooth_triangle { <129.0256, 38.1248, -3.4625>, <-0.809, -0.363, 0.462>, <127.1471, 45.9308, 8.6613>, <-0.923, -0.345, 0.169>, <130.9781, 36.7943, 8.5069>, <-0.902, -0.382, 0.200> texture { ICP35_orangish }}
	smooth_triangle { <129.0256, 38.1248, -3.4625>, <0.864, 0.420, -0.277>, <127.1471, 45.9308, 8.6613>, <0.926, 0.300, -0.230>, <125.5636, 46.8784, -3.4625>, <0.865, 0.342, -0.367> texture { ICP35_orangish }}
	smooth_triangle { <124.4276, 55.6113, 8.5758>, <0.939, 0.182, -0.292>, <128.3366, 55.7623, 21.0799>, <0.909, 0.233, -0.345>, <126.5696, 65.5753, 20.4919>, <0.937, 0.083, -0.340> texture { ICP35_orangish }}
	smooth_triangle { <128.3366, 55.7623, 21.0799>, <0.909, 0.233, -0.345>, <127.1471, 45.9308, 8.6613>, <0.926, 0.300, -0.230>, <131.2926, 45.9698, 21.1854>, <0.873, 0.315, -0.373> texture { ICP35_orangish }}
	smooth_triangle { <124.4276, 55.6113, 8.5758>, <0.939, 0.182, -0.292>, <127.1471, 45.9308, 8.6613>, <0.926, 0.300, -0.230>, <128.3366, 55.7623, 21.0799>, <0.909, 0.233, -0.345> texture { ICP35_orangish }}
	smooth_triangle { <124.4276, 55.6113, 8.5758>, <-0.969, -0.224, 0.099>, <127.1471, 45.9308, 8.6613>, <-0.923, -0.345, 0.169>, <125.5636, 46.8784, -3.4625>, <-0.891, -0.264, 0.370> texture { ICP35_orangish }}
	smooth_triangle { <134.6501, 56.5609, 32.4464>, <-0.814, -0.186, 0.550>, <132.6076, 66.1049, 31.7224>, <-0.832, -0.083, 0.548>, <140.0871, 66.7593, 40.7999>, <-0.732, -0.027, 0.681> texture { ICP35_orangish }}
	smooth_triangle { <132.6076, 66.1049, 31.7224>, <-0.832, -0.083, 0.548>, <128.3366, 55.7623, 21.0799>, <-0.866, -0.138, 0.481>, <126.5696, 65.5753, 20.4919>, <-0.921, -0.079, 0.383> texture { ICP35_orangish }}
	smooth_triangle { <134.6501, 56.5609, 32.4464>, <-0.814, -0.186, 0.550>, <128.3366, 55.7623, 21.0799>, <-0.866, -0.138, 0.481>, <132.6076, 66.1049, 31.7224>, <-0.832, -0.083, 0.548> texture { ICP35_orangish }}
	smooth_triangle { <134.6501, 56.5609, 32.4464>, <0.765, 0.218, -0.607>, <128.3366, 55.7623, 21.0799>, <0.909, 0.233, -0.345>, <131.2926, 45.9698, 21.1854>, <0.873, 0.315, -0.373> texture { ICP35_orangish }}
	smooth_triangle { <123.1381, 56.0538, -3.4625>, <0.913, 0.180, -0.367>, <122.9296, 65.2558, 8.2654>, <0.982, 0.104, -0.159>, <121.8231, 65.1613, -3.4625>, <0.927, 0.081, -0.366> texture { ICP35_orangish }}
	smooth_triangle { <123.1381, 56.0538, -3.4625>, <-0.911, -0.187, 0.368>, <124.4276, 55.6113, 8.5758>, <-0.969, -0.224, 0.099>, <125.5636, 46.8784, -3.4625>, <-0.891, -0.264, 0.370> texture { ICP35_orangish }}
	smooth_triangle { <122.9296, 65.2558, 8.2654>, <-0.984, -0.067, 0.163>, <124.4276, 55.6113, 8.5758>, <-0.969, -0.224, 0.099>, <123.1381, 56.0538, -3.4625>, <-0.911, -0.187, 0.368> texture { ICP35_orangish }}
	smooth_triangle { <122.9296, 65.2558, 8.2654>, <0.982, 0.104, -0.159>, <124.4276, 55.6113, 8.5758>, <0.939, 0.182, -0.292>, <126.5696, 65.5753, 20.4919>, <0.937, 0.083, -0.340> texture { ICP35_orangish }}
	smooth_triangle { <155.6381, 22.6773, 32.4464>, <-0.407, -0.822, 0.399>, <158.2411, 33.6548, 43.0334>, <-0.501, -0.446, 0.742>, <166.2796, 21.3428, 40.7999>, <-0.303, -0.773, 0.557> texture { ICP35_orangish }}
	smooth_triangle { <155.6381, 22.6773, 32.4464>, <0.495, 0.708, -0.504>, <147.2646, 32.5523, 33.8364>, <0.586, 0.506, -0.633>, <145.6951, 22.7088, 21.1854>, <0.461, 0.790, -0.405> texture { ICP35_orangish }}
	smooth_triangle { <158.2411, 33.6548, 43.0334>, <0.443, 0.448, -0.777>, <147.2646, 32.5523, 33.8364>, <0.586, 0.506, -0.633>, <155.6381, 22.6773, 32.4464>, <0.495, 0.708, -0.504> texture { ICP35_orangish }}
	smooth_triangle { <158.2411, 33.6548, 43.0334>, <-0.501, -0.446, 0.742>, <147.2646, 32.5523, 33.8364>, <-0.656, -0.476, 0.585>, <150.8716, 44.1683, 43.8564>, <-0.526, -0.326, 0.786> texture { ICP35_orangish }}
	smooth_triangle { <139.9986, 44.2838, 33.8359>, <-0.772, -0.374, 0.514>, <137.5826, 33.6168, 21.6773>, <-0.739, -0.486, 0.466>, <131.2926, 45.9698, 21.1854>, <-0.829, -0.351, 0.435> texture { ICP35_orangish }}
	smooth_triangle { <137.5826, 33.6168, 21.6773>, <-0.739, -0.486, 0.466>, <147.2646, 32.5523, 33.8364>, <-0.656, -0.476, 0.585>, <145.6951, 22.7088, 21.1854>, <-0.602, -0.726, 0.331> texture { ICP35_orangish }}
	smooth_triangle { <139.9986, 44.2838, 33.8359>, <-0.772, -0.374, 0.514>, <147.2646, 32.5523, 33.8364>, <-0.656, -0.476, 0.585>, <137.5826, 33.6168, 21.6773>, <-0.739, -0.486, 0.466> texture { ICP35_orangish }}
	smooth_triangle { <139.9986, 44.2838, 33.8359>, <0.666, 0.310, -0.679>, <147.2646, 32.5523, 33.8364>, <0.586, 0.506, -0.633>, <150.8716, 44.1683, 43.8564>, <0.579, 0.359, -0.733> texture { ICP35_orangish }}
	smooth_triangle { <137.9726, 25.5009, 8.5069>, <0.767, 0.607, -0.207>, <130.9781, 36.7943, 8.5069>, <0.851, 0.483, -0.208>, <133.3001, 30.2108, -3.4625>, <0.860, 0.498, -0.107> texture { ICP35_orangish }}
	smooth_triangle { <130.9781, 36.7943, 8.5069>, <0.851, 0.483, -0.208>, <137.5826, 33.6168, 21.6773>, <0.832, 0.462, -0.306>, <131.2926, 45.9698, 21.1854>, <0.873, 0.315, -0.373> texture { ICP35_orangish }}
	smooth_triangle { <137.9726, 25.5009, 8.5069>, <0.767, 0.607, -0.207>, <137.5826, 33.6168, 21.6773>, <0.832, 0.462, -0.306>, <130.9781, 36.7943, 8.5069>, <0.851, 0.483, -0.208> texture { ICP35_orangish }}
	smooth_triangle { <137.9726, 25.5009, 8.5069>, <-0.686, -0.676, 0.269>, <137.5826, 33.6168, 21.6773>, <-0.739, -0.486, 0.466>, <145.6951, 22.7088, 21.1854>, <-0.602, -0.726, 0.331> texture { ICP35_orangish }}
	smooth_triangle { <134.6501, 56.5609, 32.4464>, <0.765, 0.218, -0.607>, <144.6576, 55.5963, 43.0329>, <0.660, 0.192, -0.726>, <140.0871, 66.7593, 40.7999>, <0.679, 0.134, -0.722> texture { ICP35_orangish }}
	smooth_triangle { <144.6576, 55.5963, 43.0329>, <0.660, 0.192, -0.726>, <139.9986, 44.2838, 33.8359>, <0.666, 0.310, -0.679>, <150.8716, 44.1683, 43.8564>, <0.579, 0.359, -0.733> texture { ICP35_orangish }}
	smooth_triangle { <134.6501, 56.5609, 32.4464>, <0.765, 0.218, -0.607>, <139.9986, 44.2838, 33.8359>, <0.666, 0.310, -0.679>, <144.6576, 55.5963, 43.0329>, <0.660, 0.192, -0.726> texture { ICP35_orangish }}
	smooth_triangle { <134.6501, 56.5609, 32.4464>, <-0.814, -0.186, 0.550>, <139.9986, 44.2838, 33.8359>, <-0.772, -0.374, 0.514>, <131.2926, 45.9698, 21.1854>, <-0.829, -0.351, 0.435> texture { ICP35_orangish }}
	smooth_triangle { <121.6566, 45.2943, -8.8955>, <0.751, 0.247, -0.612>, <123.1381, 56.0538, -3.4625>, <0.913, 0.180, -0.367>, <119.0711, 55.0803, -8.8955>, <0.777, 0.158, -0.610> texture { ICP35_orangish }}
	smooth_triangle { <121.6566, 45.2943, -8.8955>, <-0.766, -0.203, 0.610>, <123.1381, 56.0538, -3.4625>, <-0.911, -0.187, 0.368>, <125.5636, 46.8784, -3.4625>, <-0.891, -0.264, 0.370> texture { ICP35_orangish }}
	smooth_triangle { <119.0711, 55.0803, -8.8955>, <0.777, 0.158, -0.610>, <121.8231, 65.1613, -3.4625>, <0.927, 0.081, -0.366>, <117.6681, 64.7968, -8.8955>, <0.786, 0.113, -0.608> texture { ICP35_orangish }}
	smooth_triangle { <119.0711, 55.0803, -8.8955>, <-0.786, -0.113, 0.608>, <121.8231, 65.1613, -3.4625>, <-0.790, -0.069, 0.609>, <123.1381, 56.0538, -3.4625>, <-0.911, -0.187, 0.368> texture { ICP35_orangish }}
	smooth_triangle { <129.9086, 27.5173, -8.8955>, <0.692, 0.374, -0.617>, <129.0256, 38.1248, -3.4625>, <0.864, 0.420, -0.277>, <125.3506, 35.9598, -8.8955>, <0.714, 0.333, -0.616> texture { ICP35_orangish }}
	smooth_triangle { <129.9086, 27.5173, -8.8955>, <-0.692, -0.374, 0.617>, <129.0256, 38.1248, -3.4625>, <-0.809, -0.363, 0.462>, <133.3001, 30.2108, -3.4625>, <-0.692, -0.374, 0.617> texture { ICP35_orangish }}
	smooth_triangle { <125.3506, 35.9598, -8.8955>, <0.714, 0.333, -0.616>, <125.5636, 46.8784, -3.4625>, <0.865, 0.342, -0.367>, <121.6566, 45.2943, -8.8955>, <0.751, 0.247, -0.612> texture { ICP35_orangish }}
	smooth_triangle { <125.3506, 35.9598, -8.8955>, <-0.735, -0.291, 0.613>, <125.5636, 46.8784, -3.4625>, <-0.891, -0.264, 0.370>, <129.0256, 38.1248, -3.4625>, <-0.809, -0.363, 0.462> texture { ICP35_orangish }}
	smooth_triangle { <118.2126, 84.6923, -8.8955>, <-0.783, 0.113, 0.612>, <121.5401, 74.3568, -3.4625>, <-0.929, 0.022, 0.370>, <117.3641, 74.6083, -8.8955>, <-0.792, 0.021, 0.610> texture { ICP35_orangish }}
	smooth_triangle { <118.2126, 84.6923, -8.8955>, <0.790, -0.066, -0.610>, <121.5401, 74.3568, -3.4625>, <0.930, -0.025, -0.366>, <122.3341, 83.8138, -3.4625>, <0.884, -0.107, -0.455> texture { ICP35_orangish }}
	smooth_triangle { <117.3641, 74.6083, -8.8955>, <-0.792, 0.021, 0.610>, <121.8231, 65.1613, -3.4625>, <-0.790, -0.069, 0.609>, <117.6681, 64.7968, -8.8955>, <-0.793, -0.025, 0.608> texture { ICP35_orangish }}
	smooth_triangle { <117.3641, 74.6083, -8.8955>, <0.793, 0.024, -0.609>, <121.8231, 65.1613, -3.4625>, <0.927, 0.081, -0.366>, <121.5401, 74.3568, -3.4625>, <0.930, -0.025, -0.366> texture { ICP35_orangish }}
	smooth_triangle { <123.2506, 103.6339, -8.8955>, <-0.728, 0.291, 0.621>, <124.2236, 93.0368, -3.4625>, <-0.931, 0.231, 0.282>, <120.2311, 94.5323, -8.8955>, <-0.761, 0.204, 0.616> texture { ICP35_orangish }}
	smooth_triangle { <123.2506, 103.6339, -8.8955>, <0.728, -0.291, -0.621>, <124.2236, 93.0368, -3.4625>, <0.854, -0.249, -0.457>, <127.0581, 101.5708, -3.4625>, <0.906, -0.349, -0.238> texture { ICP35_orangish }}
	smooth_triangle { <120.2311, 94.5323, -8.8955>, <-0.761, 0.204, 0.616>, <122.3341, 83.8138, -3.4625>, <-0.947, 0.158, 0.280>, <118.2126, 84.6923, -8.8955>, <-0.783, 0.113, 0.612> texture { ICP35_orangish }}
	smooth_triangle { <120.2311, 94.5323, -8.8955>, <0.774, -0.159, -0.613>, <122.3341, 83.8138, -3.4625>, <0.884, -0.107, -0.455>, <124.2236, 93.0368, -3.4625>, <0.854, -0.249, -0.457> texture { ICP35_orangish }}
	smooth_triangle { <132.4436, 120.3243, -8.8955>, <0.625, -0.457, -0.633>, <141.3741, 124.0193, -3.4625>, <0.660, -0.644, -0.386>, <138.5226, 127.5808, -8.8955>, <0.555, -0.532, -0.640> texture { ICP35_orangish }}
	smooth_triangle { <132.4436, 120.3243, -8.8955>, <-0.592, 0.496, 0.636>, <141.3741, 124.0193, -3.4625>, <-0.666, 0.636, 0.389>, <135.6761, 117.2193, -3.4625>, <-0.727, 0.569, 0.385> texture { ICP35_orangish }}
	smooth_triangle { <138.5226, 127.5808, -8.8955>, <0.555, -0.532, -0.640>, <147.5991, 129.6913, -3.4625>, <0.572, -0.720, -0.393>, <145.1581, 133.6288, -8.8955>, <0.516, -0.566, -0.642> texture { ICP35_orangish }}
	smooth_triangle { <138.5226, 127.5808, -8.8955>, <-0.516, 0.567, 0.642>, <147.5991, 129.6913, -3.4625>, <-0.474, 0.598, 0.646>, <141.3741, 124.0193, -3.4625>, <-0.666, 0.636, 0.389> texture { ICP35_orangish }}
	smooth_triangle { <123.2506, 103.6339, -8.8955>, <0.728, -0.291, -0.621>, <130.8336, 109.5943, -3.4625>, <0.849, -0.448, -0.281>, <127.2791, 112.1883, -8.8955>, <0.683, -0.376, -0.626> texture { ICP35_orangish }}
	smooth_triangle { <123.2506, 103.6339, -8.8955>, <-0.728, 0.291, 0.621>, <130.8336, 109.5943, -3.4625>, <-0.766, 0.437, 0.471>, <127.0581, 101.5708, -3.4625>, <-0.708, 0.333, 0.623> texture { ICP35_orangish }}
	smooth_triangle { <127.2791, 112.1883, -8.8955>, <0.683, -0.376, -0.626>, <135.6761, 117.2193, -3.4625>, <0.781, -0.496, -0.378>, <132.4436, 120.3243, -8.8955>, <0.625, -0.457, -0.633> texture { ICP35_orangish }}
	smooth_triangle { <127.2791, 112.1883, -8.8955>, <-0.657, 0.417, 0.629>, <135.6761, 117.2193, -3.4625>, <-0.727, 0.569, 0.385>, <130.8336, 109.5943, -3.4625>, <-0.766, 0.437, 0.471> texture { ICP35_orangish }}
	smooth_triangle { <160.5391, 142.6368, -8.8955>, <-0.283, 0.699, 0.656>, <154.4271, 134.3853, -3.4625>, <-0.467, 0.788, 0.401>, <152.4476, 138.6358, -8.8955>, <-0.384, 0.654, 0.652> texture { ICP35_orangish }}
	smooth_triangle { <160.5391, 142.6368, -8.8955>, <0.335, -0.679, -0.653>, <154.4271, 134.3853, -3.4625>, <0.465, -0.792, -0.396>, <162.0136, 138.1348, -3.4625>, <0.350, -0.797, -0.493> texture { ICP35_orangish }}
	smooth_triangle { <152.4476, 138.6358, -8.8955>, <-0.384, 0.654, 0.652>, <147.5991, 129.6913, -3.4625>, <-0.474, 0.598, 0.646>, <145.1581, 133.6288, -8.8955>, <-0.431, 0.628, 0.648> texture { ICP35_orangish }}
	smooth_triangle { <152.4476, 138.6358, -8.8955>, <0.431, -0.628, -0.648>, <147.5991, 129.6913, -3.4625>, <0.572, -0.720, -0.393>, <154.4271, 134.3853, -3.4625>, <0.465, -0.792, -0.396> texture { ICP35_orangish }}
	smooth_triangle { <177.5261, 146.7353, -8.8955>, <-0.120, 0.742, 0.659>, <169.9931, 140.6908, -3.4625>, <-0.244, 0.920, 0.307>, <169.0486, 145.3623, -8.8955>, <-0.175, 0.731, 0.659> texture { ICP35_orangish }}
	smooth_triangle { <177.5261, 146.7353, -8.8955>, <0.121, -0.743, -0.659>, <169.9931, 140.6908, -3.4625>, <0.178, -0.851, -0.494>, <177.9401, 141.9818, -3.4625>, <0.059, -0.937, -0.344> texture { ICP35_orangish }}
	smooth_triangle { <169.0486, 145.3623, -8.8955>, <-0.175, 0.731, 0.659>, <162.0136, 138.1348, -3.4625>, <-0.333, 0.892, 0.305>, <160.5391, 142.6368, -8.8955>, <-0.283, 0.699, 0.656> texture { ICP35_orangish }}
	smooth_triangle { <169.0486, 145.3623, -8.8955>, <0.230, -0.718, -0.657>, <162.0136, 138.1348, -3.4625>, <0.350, -0.797, -0.493>, <169.9931, 140.6908, -3.4625>, <0.178, -0.851, -0.494> texture { ICP35_orangish }}
	smooth_triangle { <182.0721, 94.7138, 55.4579>, <0.097, 0.158, 0.983>, <184.1781, 70.6178, 59.1339>, <-0.030, 0.048, 0.998>, <177.3276, 81.6878, 58.0254>, <-0.070, 0.126, 0.990> texture { ICP35_orangish }}
	smooth_triangle { <186.2866, 46.5244, 55.4579>, <-0.123, 0.139, -0.983>, <184.1781, 70.6178, 59.1339>, <-0.123, 0.139, -0.983>, <179.3536, 58.5283, 58.0254>, <0.080, 0.157, -0.984> texture { ICP35_orangish }}
	smooth_triangle { <186.2866, 46.5244, 55.4579>, <-0.002, -0.326, 0.945>, <188.2661, 23.9038, 43.8559>, <0.000, -0.648, 0.762>, <181.2731, 34.0653, 50.2289>, <0.018, -0.456, 0.890> texture { ICP35_orangish }}
	smooth_triangle { <182.0721, 94.7138, 55.4579>, <0.053, -0.350, -0.935>, <180.0931, 117.3358, 43.8559>, <0.028, -0.503, -0.864>, <174.9731, 106.1118, 50.2289>, <0.107, -0.462, -0.881> texture { ICP35_orangish }}
	smooth_triangle { <178.4656, 135.9718, 21.6773>, <-0.078, 0.852, 0.518>, <180.0931, 117.3358, 43.8559>, <-0.007, 0.719, 0.695>, <173.0146, 126.9468, 33.8359>, <-0.066, 0.761, 0.645> texture { ICP35_orangish }}
	smooth_triangle { <178.4656, 135.9718, 21.6773>, <-0.110, -0.967, -0.229>, <177.9401, 141.9818, -3.4625>, <0.059, -0.937, -0.344>, <172.1226, 139.8083, 8.5069>, <0.105, -0.969, -0.222> texture { ICP35_orangish }}
	smooth_triangle { <196.4211, 146.5578, -8.8955>, <0.167, 0.735, 0.657>, <205.1356, 144.5844, -8.8955>, <0.166, 0.735, 0.657>, <204.0576, 139.9708, -3.4625>, <0.235, 0.885, 0.403> texture { ICP35_orangish }}
	smooth_triangle { <196.4211, 146.5578, -8.8955>, <-0.055, -0.750, -0.659>, <187.8586, 147.1858, -8.8955>, <-0.055, -0.750, -0.659>, <195.8861, 141.8223, -3.4625>, <-0.064, -0.867, -0.494> texture { ICP35_orangish }}
	smooth_triangle { <213.5451, 141.3033, -8.8955>, <0.375, 0.663, 0.648>, <221.2411, 136.9523, -8.8955>, <0.375, 0.663, 0.648>, <219.1561, 132.8143, -3.4625>, <0.375, 0.663, 0.648> texture { ICP35_orangish }}
	smooth_triangle { <213.5451, 141.3033, -8.8955>, <-0.275, -0.706, -0.653>, <205.1356, 144.5844, -8.8955>, <-0.275, -0.705, -0.653>, <211.9426, 136.8993, -3.4625>, <-0.368, -0.841, -0.398> texture { ICP35_orangish }}
	smooth_triangle { <240.9216, 117.1538, -8.8955>, <-0.618, -0.472, -0.629>, <235.0706, 124.8068, -8.8955>, <-0.618, -0.472, -0.629>, <232.1191, 121.4333, -3.4625>, <-0.702, -0.536, -0.469> texture { ICP35_orangish }}
	smooth_triangle { <240.9216, 117.1538, -8.8955>, <0.676, 0.394, 0.623>, <245.6811, 108.9798, -8.8955>, <0.676, 0.394, 0.623>, <237.6056, 114.2558, -3.4625>, <0.745, 0.474, 0.469> texture { ICP35_orangish }}
	smooth_triangle { <228.3806, 131.5053, -8.8955>, <-0.465, -0.609, -0.642>, <221.2411, 136.9523, -8.8955>, <-0.465, -0.609, -0.642>, <219.1561, 132.8143, -3.4625>, <-0.530, -0.753, -0.391> texture { ICP35_orangish }}
	smooth_triangle { <228.3806, 131.5053, -8.8955>, <0.546, 0.546, 0.636>, <235.0706, 124.8068, -8.8955>, <0.546, 0.546, 0.636>, <225.8486, 127.7098, -3.4625>, <0.629, 0.674, 0.387> texture { ICP35_orangish }}
	smooth_triangle { <249.4816, 100.1778, -8.8955>, <0.757, 0.226, 0.613>, <252.3491, 90.5523, -8.8955>, <0.757, 0.226, 0.613>, <248.3216, 89.3168, -3.4625>, <0.898, 0.239, 0.370> texture { ICP35_orangish }}
	smooth_triangle { <249.4816, 100.1778, -8.8955>, <-0.722, -0.312, -0.617>, <245.6811, 108.9798, -8.8955>, <-0.722, -0.312, -0.617>, <245.6341, 98.3413, -3.4625>, <-0.816, -0.352, -0.458> texture { ICP35_orangish }}
	smooth_triangle { <254.0761, 80.5783, -8.8955>, <0.792, 0.045, 0.608>, <254.6261, 70.7783, -8.8955>, <0.792, 0.044, 0.608>, <250.4561, 70.7763, -3.4625>, <0.792, 0.045, 0.608> texture { ICP35_orangish }}
	smooth_triangle { <254.0761, 80.5783, -8.8955>, <-0.781, -0.135, -0.610>, <252.3491, 90.5523, -8.8955>, <-0.781, -0.135, -0.610>, <249.9366, 79.9659, -3.4625>, <-0.921, -0.129, -0.367> texture { ICP35_orangish }}
	smooth_triangle { <249.4851, 41.3798, -8.8955>, <-0.757, 0.225, -0.613>, <252.3511, 51.0023, -8.8955>, <-0.757, 0.226, -0.613>, <248.3211, 52.2428, -3.4625>, <-0.853, 0.254, -0.456> texture { ICP35_orangish }}
	smooth_triangle { <249.4851, 41.3798, -8.8955>, <0.722, -0.312, 0.617>, <245.6826, 32.5743, -8.8955>, <0.722, -0.312, 0.617>, <245.6336, 43.2158, -3.4625>, <0.826, -0.321, 0.463> texture { ICP35_orangish }}
	smooth_triangle { <254.0756, 60.9793, -8.8955>, <-0.792, 0.045, -0.608>, <254.6261, 70.7783, -8.8955>, <-0.792, 0.045, -0.608>, <250.4561, 70.7763, -3.4625>, <-0.930, 0.023, -0.366> texture { ICP35_orangish }}
	smooth_triangle { <254.0756, 60.9793, -8.8955>, <0.781, -0.135, 0.610>, <252.3511, 51.0023, -8.8955>, <0.781, -0.135, 0.610>, <249.9401, 61.5898, -3.4625>, <0.921, -0.131, 0.368> texture { ICP35_orangish }}
	smooth_triangle { <228.5411, 59.2583, 43.0329>, <0.630, -0.156, 0.761>, <238.4286, 61.0928, 32.4464>, <0.782, -0.149, 0.606>, <234.1661, 48.3994, 33.8359>, <0.796, -0.237, 0.556> texture { ICP35_orangish }}
	smooth_triangle { <243.8046, 41.7198, 8.5069>, <0.910, -0.346, 0.230>, <237.8231, 29.8604, 8.5069>, <0.781, -0.561, 0.273>, <237.5046, 37.9808, 21.6773>, <0.806, -0.433, 0.405> texture { ICP35_orangish }}
	smooth_triangle { <237.5046, 37.9808, 21.6773>, <-0.825, 0.365, -0.432>, <234.1661, 48.3994, 33.8359>, <-0.699, 0.321, -0.640>, <227.9510, 36.0773, 33.8364>, <-0.662, 0.436, -0.610> texture { ICP35_orangish }}
	smooth_triangle { <216.9211, 36.2183, 43.0334>, <-0.480, 0.408, -0.777>, <220.4726, 25.5058, 32.4464>, <-0.510, 0.738, -0.441>, <227.9510, 36.0773, 33.8364>, <-0.662, 0.436, -0.610> texture { ICP35_orangish }}
	smooth_triangle { <249.3446, 70.7783, 8.2654>, <0.986, 0.019, 0.163>, <249.9401, 61.5898, -3.4625>, <0.921, -0.131, 0.368>, <248.6926, 61.0378, 8.5758>, <0.978, -0.149, 0.148> texture { ICP35_orangish }}
	smooth_triangle { <239.6286, 70.7794, 31.7224>, <-0.875, -0.017, -0.484>, <238.4286, 61.0928, 32.4464>, <-0.827, 0.115, -0.551>, <244.7846, 60.8493, 21.0799>, <-0.910, 0.127, -0.395> texture { ICP35_orangish }}
	smooth_triangle { <244.7846, 60.8493, 21.0799>, <0.916, -0.114, 0.385>, <248.6926, 61.0378, 8.5758>, <0.978, -0.149, 0.148>, <246.8266, 51.1568, 8.6613>, <0.950, -0.241, 0.200> texture { ICP35_orangish }}
	smooth_triangle { <245.6336, 43.2158, -3.4625>, <0.826, -0.321, 0.463>, <243.8046, 41.7198, 8.5069>, <0.910, -0.346, 0.230>, <246.8266, 51.1568, 8.6613>, <0.950, -0.241, 0.200> texture { ICP35_orangish }}
	smooth_triangle { <243.8041, 99.8344, 8.5069>, <0.900, 0.362, 0.241>, <245.6341, 98.3413, -3.4625>, <0.918, 0.281, 0.280>, <246.8251, 90.3988, 8.6613>, <0.960, 0.238, 0.149> texture { ICP35_orangish }}
	smooth_triangle { <238.4276, 80.4628, 32.4464>, <-0.816, -0.157, -0.557>, <239.6286, 70.7794, 31.7224>, <-0.875, -0.017, -0.484>, <244.7861, 80.7094, 21.0799>, <-0.914, -0.097, -0.393> texture { ICP35_orangish }}
	smooth_triangle { <244.7861, 80.7094, 21.0799>, <0.904, 0.176, 0.389>, <246.8251, 90.3988, 8.6613>, <0.960, 0.238, 0.149>, <248.6911, 80.5188, 8.5758>, <0.973, 0.120, 0.197> texture { ICP35_orangish }}
	smooth_triangle { <249.9366, 79.9659, -3.4625>, <0.928, 0.056, 0.368>, <249.3446, 70.7783, 8.2654>, <0.986, 0.019, 0.163>, <248.6911, 80.5188, 8.5758>, <0.973, 0.120, 0.197> texture { ICP35_orangish }}
	smooth_triangle { <216.9176, 105.3353, 43.0334>, <0.480, 0.408, 0.777>, <220.4701, 116.0533, 32.4464>, <0.559, 0.538, 0.630>, <227.9516, 105.4808, 33.8364>, <0.651, 0.499, 0.573> texture { ICP35_black_2 }}
	smooth_triangle { <237.8201, 111.6973, 8.5069>, <0.816, 0.528, 0.235>, <243.8041, 99.8344, 8.5069>, <0.900, 0.362, 0.241>, <237.5031, 103.5828, 21.6773>, <0.827, 0.392, 0.403> texture { ICP35_orangish }}
	smooth_triangle { <237.5031, 103.5828, 21.6773>, <-0.782, -0.447, -0.435>, <227.9516, 105.4808, 33.8364>, <-0.670, -0.370, -0.643>, <234.1671, 93.1583, 33.8359>, <-0.750, -0.279, -0.600> texture { ICP35_black_2 }}
	smooth_triangle { <228.5411, 82.2978, 43.0329>, <-0.630, -0.156, -0.761>, <238.4276, 80.4628, 32.4464>, <-0.816, -0.157, -0.557>, <234.1671, 93.1583, 33.8359>, <-0.750, -0.279, -0.600> texture { ICP35_black_2 }}
	smooth_triangle { <218.6011, 131.7173, 8.2654>, <0.523, 0.833, 0.179>, <225.8486, 127.7098, -3.4625>, <0.629, 0.674, 0.387>, <225.6456, 126.1993, 8.5764>, <0.682, 0.714, 0.158> texture { ICP35_orangish }}
	smooth_triangle { <213.7421, 122.0893, 31.7224>, <-0.452, -0.723, -0.522>, <220.4701, 116.0533, 32.4464>, <-0.555, -0.598, -0.579>, <223.8351, 122.2298, 21.0804>, <-0.618, -0.665, -0.420> texture { ICP35_orangish }}
	smooth_triangle { <223.8351, 122.2298, 21.0804>, <0.609, 0.678, 0.411>, <225.6456, 126.1993, 8.5764>, <0.682, 0.714, 0.158>, <232.1926, 119.4093, 8.6613>, <0.749, 0.628, 0.210> texture { ICP35_orangish }}
	smooth_triangle { <237.6056, 114.2558, -3.4625>, <0.745, 0.474, 0.469>, <237.8201, 111.6973, 8.5069>, <0.816, 0.528, 0.235>, <232.1926, 119.4093, 8.6613>, <0.749, 0.628, 0.210> texture { ICP35_orangish }}
	smooth_triangle { <193.8416, 140.7553, 8.5069>, <0.037, 0.970, 0.240>, <195.8861, 141.8223, -3.4625>, <0.201, 0.931, 0.306>, <202.4911, 139.0313, 8.6613>, <0.273, 0.947, 0.167> texture { ICP35_orangish }}
	smooth_triangle { <205.8101, 125.7418, 32.4464>, <-0.273, -0.752, -0.600>, <213.7421, 122.0893, 31.7224>, <-0.452, -0.723, -0.522>, <208.8066, 132.1623, 21.0799>, <-0.396, -0.812, -0.430> texture { ICP35_orangish }}
	smooth_triangle { <208.8066, 132.1623, 21.0799>, <0.306, 0.850, 0.428>, <202.4911, 139.0313, 8.6613>, <0.273, 0.947, 0.167>, <210.9011, 135.9423, 8.5758>, <0.409, 0.886, 0.218> texture { ICP35_orangish }}
	smooth_triangle { <211.9426, 136.8993, -3.4625>, <0.448, 0.801, 0.397>, <218.6011, 131.7173, 8.2654>, <0.523, 0.833, 0.179>, <210.9011, 135.9423, 8.5758>, <0.409, 0.886, 0.218> texture { ICP35_orangish }}
	smooth_triangle { <199.4806, 116.8588, 43.0329>, <-0.168, -0.582, -0.796>, <205.8101, 125.7418, 32.4464>, <-0.273, -0.752, -0.600>, <194.0741, 127.8678, 33.8359>, <-0.071, -0.762, -0.644> texture { ICP35_orangish }}
	smooth_triangle { <205.4510, 35.9103, 48.3094>, <0.297, -0.403, 0.866>, <199.4811, 24.7008, 43.0329>, <0.153, -0.791, 0.592>, <193.9401, 34.6188, 50.2289>, <0.057, -0.443, 0.895> texture { ICP35_orangish }}
	smooth_triangle { <199.5866, 70.7798, 58.0254>, <-0.228, -0.016, -0.974>, <193.7221, 59.1563, 58.0254>, <-0.195, 0.147, -0.970>, <206.1641, 58.6873, 55.4579>, <-0.271, 0.186, -0.944> texture { ICP35_orangish }}
	smooth_triangle { <223.0421, 70.7788, 48.3094>, <0.565, 0.000, 0.825>, <228.5411, 59.2583, 43.0329>, <0.630, -0.156, 0.761>, <218.2661, 58.7228, 50.2289>, <0.510, -0.161, 0.845> texture { ICP35_orangish }}
	smooth_triangle { <218.2661, 58.7228, 50.2289>, <-0.433, 0.123, -0.893>, <206.1641, 58.6873, 55.4579>, <-0.271, 0.186, -0.944>, <212.1856, 46.6718, 50.2289>, <-0.394, 0.296, -0.870> texture { ICP35_orangish }}
	smooth_triangle { <205.4510, 35.9103, 48.3094>, <-0.237, 0.423, -0.874>, <216.9211, 36.2183, 43.0334>, <-0.480, 0.408, -0.777>, <212.1856, 46.6718, 50.2289>, <-0.394, 0.296, -0.870> texture { ICP35_orangish }}
	smooth_triangle { <193.7226, 82.4043, 58.0254>, <-0.062, -0.165, -0.984>, <199.5866, 70.7798, 58.0254>, <-0.228, -0.016, -0.974>, <206.1606, 82.8718, 55.4579>, <-0.319, -0.112, -0.941> texture { ICP35_orangish }}
	smooth_triangle { <205.4501, 105.6523, 48.3094>, <0.291, 0.440, 0.849>, <216.9176, 105.3353, 43.0334>, <0.480, 0.408, 0.777>, <212.1851, 94.8878, 50.2289>, <0.419, 0.309, 0.854> texture { ICP35_orangish }}
	smooth_triangle { <212.1851, 94.8878, 50.2289>, <-0.341, -0.270, -0.901>, <206.1606, 82.8718, 55.4579>, <-0.319, -0.112, -0.941>, <218.2646, 82.8303, 50.2289>, <-0.485, -0.148, -0.862> texture { ICP35_orangish }}
	smooth_triangle { <223.0421, 70.7788, 48.3094>, <-0.565, -0.001, -0.825>, <228.5411, 82.2978, 43.0329>, <-0.630, -0.156, -0.761>, <218.2646, 82.8303, 50.2289>, <-0.485, -0.148, -0.862> texture { ICP35_black_2 }}
	smooth_triangle { <205.4501, 105.6523, 48.3094>, <-0.290, -0.441, -0.849>, <199.4806, 116.8588, 43.0329>, <-0.168, -0.582, -0.796>, <193.9391, 106.9398, 50.2289>, <-0.131, -0.471, -0.872> texture { ICP35_orangish }}
	smooth_triangle { <242.0681, 34.9623, -3.4625>, <-0.901, 0.421, -0.107>, <243.8046, 41.7198, 8.5069>, <-0.900, 0.398, -0.181>, <237.8231, 29.8604, 8.5069>, <-0.787, 0.596, -0.160> texture { ICP35_orangish }}
	smooth_triangle { <248.3211, 52.2428, -3.4625>, <0.945, -0.169, 0.279>, <249.9401, 61.5898, -3.4625>, <0.921, -0.131, 0.368>, <252.3511, 51.0023, -8.8955>, <0.781, -0.135, 0.610> texture { ICP35_orangish }}
	smooth_triangle { <250.4561, 70.7763, -3.4625>, <-0.930, 0.023, -0.366>, <249.9401, 61.5898, -3.4625>, <-0.929, 0.052, -0.365>, <254.0756, 60.9793, -8.8955>, <-0.792, 0.045, -0.608> texture { ICP35_orangish }}
	smooth_triangle { <242.0681, 34.9623, -3.4625>, <-0.901, 0.421, -0.107>, <245.6336, 43.2158, -3.4625>, <-0.909, 0.313, -0.275>, <243.8046, 41.7198, 8.5069>, <-0.900, 0.398, -0.181> texture { ICP35_orangish }}
	smooth_triangle { <242.0681, 34.9623, -3.4625>, <0.722, -0.312, 0.617>, <245.6336, 43.2158, -3.4625>, <0.826, -0.321, 0.463>, <245.6826, 32.5743, -8.8955>, <0.722, -0.312, 0.617> texture { ICP35_orangish }}
	smooth_triangle { <248.3211, 52.2428, -3.4625>, <-0.853, 0.254, -0.456>, <245.6336, 43.2158, -3.4625>, <-0.909, 0.313, -0.275>, <249.4851, 41.3798, -8.8955>, <-0.757, 0.225, -0.613> texture { ICP35_orangish }}
	smooth_triangle { <232.1231, 70.7783, 40.7999>, <0.731, 0.037, 0.681>, <239.6286, 70.7794, 31.7224>, <0.810, -0.017, 0.586>, <238.4286, 61.0928, 32.4464>, <0.782, -0.149, 0.606> texture { ICP35_orangish }}
	smooth_triangle { <250.4561, 70.7763, -3.4625>, <-0.930, 0.023, -0.366>, <249.3446, 70.7783, 8.2654>, <-0.987, 0.018, -0.159>, <249.9401, 61.5898, -3.4625>, <-0.929, 0.052, -0.365> texture { ICP35_orangish }}
	smooth_triangle { <248.3216, 89.3168, -3.4625>, <-0.917, -0.158, -0.366>, <249.9366, 79.9659, -3.4625>, <-0.921, -0.129, -0.367>, <252.3491, 90.5523, -8.8955>, <-0.781, -0.135, -0.610> texture { ICP35_orangish }}
	smooth_triangle { <250.4561, 70.7763, -3.4625>, <-0.930, 0.023, -0.366>, <249.9366, 79.9659, -3.4625>, <-0.921, -0.129, -0.367>, <249.3446, 70.7783, 8.2654>, <-0.987, 0.018, -0.159> texture { ICP35_orangish }}
	smooth_triangle { <250.4561, 70.7763, -3.4625>, <0.792, 0.045, 0.608>, <249.9366, 79.9659, -3.4625>, <0.928, 0.056, 0.368>, <254.0761, 80.5783, -8.8955>, <0.792, 0.045, 0.608> texture { ICP35_orangish }}
	smooth_triangle { <242.0671, 106.5968, -3.4625>, <-0.872, -0.427, -0.238>, <245.6341, 98.3413, -3.4625>, <-0.816, -0.352, -0.458>, <245.6811, 108.9798, -8.8955>, <-0.722, -0.312, -0.617> texture { ICP35_orangish }}
	smooth_triangle { <248.3216, 89.3168, -3.4625>, <0.898, 0.239, 0.370>, <245.6341, 98.3413, -3.4625>, <0.918, 0.281, 0.280>, <249.4816, 100.1778, -8.8955>, <0.757, 0.226, 0.613> texture { ICP35_orangish }}
	smooth_triangle { <242.0671, 106.5968, -3.4625>, <-0.872, -0.427, -0.238>, <243.8041, 99.8344, 8.5069>, <-0.909, -0.382, -0.170>, <245.6341, 98.3413, -3.4625>, <-0.816, -0.352, -0.458> texture { ICP35_orangish }}
	smooth_triangle { <232.1231, 70.7783, 40.7999>, <0.731, 0.037, 0.681>, <238.4276, 80.4628, 32.4464>, <0.793, 0.108, 0.600>, <239.6286, 70.7794, 31.7224>, <0.810, -0.017, 0.586> texture { ICP35_orangish }}
	smooth_triangle { <242.0671, 106.5968, -3.4625>, <-0.872, -0.427, -0.238>, <237.8201, 111.6973, 8.5069>, <-0.853, -0.488, -0.183>, <243.8041, 99.8344, 8.5069>, <-0.909, -0.382, -0.170> texture { ICP35_orangish }}
	smooth_triangle { <232.1191, 121.4333, -3.4625>, <0.680, 0.672, 0.293>, <225.8486, 127.7098, -3.4625>, <0.629, 0.674, 0.387>, <235.0706, 124.8068, -8.8955>, <0.546, 0.546, 0.636> texture { ICP35_orangish }}
	smooth_triangle { <219.1561, 132.8143, -3.4625>, <-0.530, -0.753, -0.391>, <225.8486, 127.7098, -3.4625>, <-0.559, -0.732, -0.390>, <228.3806, 131.5053, -8.8955>, <-0.465, -0.609, -0.642> texture { ICP35_orangish }}
	smooth_triangle { <242.0671, 106.5968, -3.4625>, <-0.872, -0.427, -0.238>, <237.6056, 114.2558, -3.4625>, <-0.787, -0.548, -0.283>, <237.8201, 111.6973, 8.5069>, <-0.853, -0.488, -0.183> texture { ICP35_orangish }}
	smooth_triangle { <242.0671, 106.5968, -3.4625>, <0.676, 0.394, 0.623>, <237.6056, 114.2558, -3.4625>, <0.745, 0.474, 0.469>, <245.6811, 108.9798, -8.8955>, <0.676, 0.394, 0.623> texture { ICP35_orangish }}
	smooth_triangle { <232.1191, 121.4333, -3.4625>, <-0.702, -0.536, -0.469>, <237.6056, 114.2558, -3.4625>, <-0.787, -0.548, -0.283>, <240.9216, 117.1538, -8.8955>, <-0.618, -0.472, -0.629> texture { ICP35_orangish }}
	smooth_triangle { <209.9896, 114.6443, 40.7999>, <0.347, 0.603, 0.718>, <213.7421, 122.0893, 31.7224>, <0.449, 0.642, 0.621>, <220.4701, 116.0533, 32.4464>, <0.559, 0.538, 0.630> texture { ICP35_orangish }}
	smooth_triangle { <219.1561, 132.8143, -3.4625>, <-0.530, -0.753, -0.391>, <218.6011, 131.7173, 8.2654>, <-0.561, -0.809, -0.174>, <225.8486, 127.7098, -3.4625>, <-0.559, -0.732, -0.390> texture { ICP35_orangish }}
	smooth_triangle { <204.0576, 139.9708, -3.4625>, <-0.333, -0.855, -0.397>, <211.9426, 136.8993, -3.4625>, <-0.368, -0.841, -0.398>, <205.1356, 144.5844, -8.8955>, <-0.275, -0.705, -0.653> texture { ICP35_orangish }}
	smooth_triangle { <219.1561, 132.8143, -3.4625>, <-0.530, -0.753, -0.391>, <211.9426, 136.8993, -3.4625>, <-0.368, -0.841, -0.398>, <218.6011, 131.7173, 8.2654>, <-0.561, -0.809, -0.174> texture { ICP35_orangish }}
	smooth_triangle { <219.1561, 132.8143, -3.4625>, <0.375, 0.663, 0.648>, <211.9426, 136.8993, -3.4625>, <0.448, 0.801, 0.397>, <213.5451, 141.3033, -8.8955>, <0.375, 0.663, 0.648> texture { ICP35_orangish }}
	smooth_triangle { <187.8591, 142.4133, -3.4625>, <-0.067, -0.915, -0.399>, <195.8861, 141.8223, -3.4625>, <-0.064, -0.867, -0.494>, <187.8586, 147.1858, -8.8955>, <-0.055, -0.750, -0.659> texture { ICP35_orangish }}
	smooth_triangle { <204.0576, 139.9708, -3.4625>, <0.235, 0.885, 0.403>, <195.8861, 141.8223, -3.4625>, <0.201, 0.931, 0.306>, <196.4211, 146.5578, -8.8955>, <0.167, 0.735, 0.657> texture { ICP35_orangish }}
	smooth_triangle { <187.8591, 142.4133, -3.4625>, <-0.067, -0.915, -0.399>, <193.8416, 140.7553, 8.5069>, <-0.127, -0.968, -0.215>, <195.8861, 141.8223, -3.4625>, <-0.064, -0.867, -0.494> texture { ICP35_orangish }}
	smooth_triangle { <187.8591, 142.4133, -3.4625>, <-0.193, 0.954, 0.229>, <193.8416, 140.7553, 8.5069>, <0.037, 0.970, 0.240>, <187.8571, 136.3823, 21.6773>, <0.009, 0.925, 0.380> texture { ICP35_orangish }}
	smooth_triangle { <209.9896, 114.6443, 40.7999>, <0.347, 0.603, 0.718>, <205.8101, 125.7418, 32.4464>, <0.310, 0.701, 0.642>, <213.7421, 122.0893, 31.7224>, <0.449, 0.642, 0.621> texture { ICP35_orangish }}
	smooth_triangle { <232.1231, 70.7783, 40.7999>, <-0.688, 0.074, -0.722>, <228.5411, 59.2583, 43.0329>, <-0.685, 0.131, -0.717>, <238.4286, 61.0928, 32.4464>, <-0.827, 0.115, -0.551> texture { ICP35_orangish }}
	smooth_triangle { <209.9881, 23.2493, 40.7999>, <0.352, -0.664, 0.659>, <216.9211, 36.2183, 43.0334>, <0.538, -0.400, 0.742>, <220.4726, 25.5058, 32.4464>, <0.527, -0.708, 0.470> texture { ICP35_orangish }}
	smooth_triangle { <209.9896, 114.6443, 40.7999>, <-0.433, -0.502, -0.749>, <216.9176, 105.3353, 43.0334>, <-0.486, -0.467, -0.738>, <220.4701, 116.0533, 32.4464>, <-0.555, -0.598, -0.579> texture { ICP35_orangish }}
	smooth_triangle { <232.1231, 70.7783, 40.7999>, <0.731, 0.037, 0.681>, <228.5411, 82.2978, 43.0329>, <0.685, 0.131, 0.717>, <238.4276, 80.4628, 32.4464>, <0.793, 0.108, 0.600> texture { ICP35_black_2 }}
	smooth_triangle { <209.9896, 114.6443, 40.7999>, <0.347, 0.603, 0.718>, <199.4806, 116.8588, 43.0329>, <0.224, 0.616, 0.755>, <205.8101, 125.7418, 32.4464>, <0.310, 0.701, 0.642> texture { ICP35_orangish }}
	smooth_triangle { <209.9881, 23.2493, 40.7999>, <0.352, -0.664, 0.659>, <205.4510, 35.9103, 48.3094>, <0.297, -0.403, 0.866>, <216.9211, 36.2183, 43.0334>, <0.538, -0.400, 0.742> texture { ICP35_orangish }}
	smooth_triangle { <209.9881, 23.2493, 40.7999>, <-0.154, 0.854, -0.498>, <205.4510, 35.9103, 48.3094>, <-0.237, 0.423, -0.874>, <199.4811, 24.7008, 43.0329>, <-0.062, 0.799, -0.598> texture { ICP35_orangish }}
	smooth_triangle { <187.8591, 70.7788, 59.1339>, <0.030, -0.048, 0.998>, <193.7221, 59.1563, 58.0254>, <0.028, -0.147, 0.989>, <186.2866, 46.5244, 55.4579>, <-0.002, -0.326, 0.945> texture { ICP35_orangish }}
	smooth_triangle { <232.1231, 70.7783, 40.7999>, <0.731, 0.037, 0.681>, <223.0421, 70.7788, 48.3094>, <0.565, 0.000, 0.825>, <228.5411, 82.2978, 43.0329>, <0.685, 0.131, 0.717> texture { ICP35_black_2 }}
	smooth_triangle { <232.1231, 70.7783, 40.7999>, <-0.688, 0.074, -0.722>, <223.0421, 70.7788, 48.3094>, <-0.565, -0.001, -0.825>, <228.5411, 59.2583, 43.0329>, <-0.685, 0.131, -0.717> texture { ICP35_orangish }}
	smooth_triangle { <187.8591, 70.7788, 59.1339>, <0.030, -0.048, 0.998>, <199.5866, 70.7798, 58.0254>, <0.159, -0.016, 0.987>, <193.7221, 59.1563, 58.0254>, <0.028, -0.147, 0.989> texture { ICP35_orangish }}
	smooth_triangle { <209.9896, 114.6443, 40.7999>, <0.347, 0.603, 0.718>, <205.4501, 105.6523, 48.3094>, <0.291, 0.440, 0.849>, <199.4806, 116.8588, 43.0329>, <0.224, 0.616, 0.755> texture { ICP35_orangish }}
	smooth_triangle { <209.9896, 114.6443, 40.7999>, <-0.433, -0.502, -0.749>, <205.4501, 105.6523, 48.3094>, <-0.290, -0.441, -0.849>, <216.9176, 105.3353, 43.0334>, <-0.486, -0.467, -0.738> texture { ICP35_orangish }}
	smooth_triangle { <187.8591, 70.7788, 59.1339>, <0.110, -0.149, -0.983>, <193.7226, 82.4043, 58.0254>, <-0.062, -0.165, -0.984>, <187.8616, 94.9653, 55.4579>, <-0.028, -0.252, -0.967> texture { ICP35_orangish }}
	smooth_triangle { <187.8591, 70.7788, 59.1339>, <0.030, -0.048, 0.998>, <193.7226, 82.4043, 58.0254>, <0.143, 0.121, 0.982>, <199.5866, 70.7798, 58.0254>, <0.159, -0.016, 0.987> texture { ICP35_orangish }}
	smooth_triangle { <242.6951, 50.8333, 21.1854>, <0.856, -0.278, 0.435>, <234.1661, 48.3994, 33.8359>, <0.796, -0.237, 0.556>, <238.4286, 61.0928, 32.4464>, <0.782, -0.149, 0.606> texture { ICP35_orangish }}
	smooth_triangle { <223.3451, 47.3333, 43.8564>, <-0.608, 0.307, -0.732>, <234.1661, 48.3994, 33.8359>, <-0.699, 0.321, -0.640>, <228.5411, 59.2583, 43.0329>, <-0.685, 0.131, -0.717> texture { ICP35_orangish }}
	smooth_triangle { <230.3726, 26.4058, 21.1854>, <0.656, -0.657, 0.373>, <237.5046, 37.9808, 21.6773>, <0.806, -0.433, 0.405>, <237.8231, 29.8604, 8.5069>, <0.781, -0.561, 0.273> texture { ICP35_orangish }}
	smooth_triangle { <242.6951, 50.8333, 21.1854>, <0.856, -0.278, 0.435>, <237.5046, 37.9808, 21.6773>, <0.806, -0.433, 0.405>, <234.1661, 48.3994, 33.8359>, <0.796, -0.237, 0.556> texture { ICP35_orangish }}
	smooth_triangle { <242.6951, 50.8333, 21.1854>, <-0.897, 0.238, -0.373>, <237.5046, 37.9808, 21.6773>, <-0.825, 0.365, -0.432>, <243.8046, 41.7198, 8.5069>, <-0.900, 0.398, -0.181> texture { ICP35_orangish }}
	smooth_triangle { <223.3451, 47.3333, 43.8564>, <0.552, -0.279, 0.786>, <227.9510, 36.0773, 33.8364>, <0.663, -0.435, 0.609>, <216.9211, 36.2183, 43.0334>, <0.538, -0.400, 0.742> texture { ICP35_orangish }}
	smooth_triangle { <223.3451, 47.3333, 43.8564>, <-0.608, 0.307, -0.732>, <227.9510, 36.0773, 33.8364>, <-0.662, 0.436, -0.610>, <234.1661, 48.3994, 33.8359>, <-0.699, 0.321, -0.640> texture { ICP35_orangish }}
	smooth_triangle { <230.3726, 26.4058, 21.1854>, <0.656, -0.657, 0.373>, <227.9510, 36.0773, 33.8364>, <0.663, -0.435, 0.609>, <237.5046, 37.9808, 21.6773>, <0.806, -0.433, 0.405> texture { ICP35_orangish }}
	smooth_triangle { <230.3726, 26.4058, 21.1854>, <-0.576, 0.747, -0.332>, <227.9510, 36.0773, 33.8364>, <-0.662, 0.436, -0.610>, <220.4726, 25.5058, 32.4464>, <-0.510, 0.738, -0.441> texture { ICP35_orangish }}
	smooth_triangle { <245.6901, 70.7803, 20.4919>, <-0.940, 0.001, -0.340>, <248.6926, 61.0378, 8.5758>, <-0.955, 0.062, -0.291>, <249.3446, 70.7783, 8.2654>, <-0.987, 0.018, -0.159> texture { ICP35_orangish }}
	smooth_triangle { <248.3211, 52.2428, -3.4625>, <0.945, -0.169, 0.279>, <248.6926, 61.0378, 8.5758>, <0.978, -0.149, 0.148>, <249.9401, 61.5898, -3.4625>, <0.921, -0.131, 0.368> texture { ICP35_orangish }}
	smooth_triangle { <242.6951, 50.8333, 21.1854>, <-0.897, 0.238, -0.373>, <244.7846, 60.8493, 21.0799>, <-0.910, 0.127, -0.395>, <238.4286, 61.0928, 32.4464>, <-0.827, 0.115, -0.551> texture { ICP35_orangish }}
	smooth_triangle { <245.6901, 70.7803, 20.4919>, <-0.940, 0.001, -0.340>, <244.7846, 60.8493, 21.0799>, <-0.910, 0.127, -0.395>, <248.6926, 61.0378, 8.5758>, <-0.955, 0.062, -0.291> texture { ICP35_orangish }}
	smooth_triangle { <245.6901, 70.7803, 20.4919>, <0.924, 0.002, 0.383>, <244.7846, 60.8493, 21.0799>, <0.916, -0.114, 0.385>, <239.6286, 70.7794, 31.7224>, <0.810, -0.017, 0.586> texture { ICP35_orangish }}
	smooth_triangle { <248.3211, 52.2428, -3.4625>, <-0.853, 0.254, -0.456>, <246.8266, 51.1568, 8.6613>, <-0.950, 0.239, -0.199>, <245.6336, 43.2158, -3.4625>, <-0.909, 0.313, -0.275> texture { ICP35_orangish }}
	smooth_triangle { <248.3211, 52.2428, -3.4625>, <0.945, -0.169, 0.279>, <246.8266, 51.1568, 8.6613>, <0.950, -0.241, 0.200>, <248.6926, 61.0378, 8.5758>, <0.978, -0.149, 0.148> texture { ICP35_orangish }}
	smooth_triangle { <242.6951, 50.8333, 21.1854>, <-0.897, 0.238, -0.373>, <246.8266, 51.1568, 8.6613>, <-0.950, 0.239, -0.199>, <244.7846, 60.8493, 21.0799>, <-0.910, 0.127, -0.395> texture { ICP35_orangish }}
	smooth_triangle { <242.6951, 50.8333, 21.1854>, <0.856, -0.278, 0.435>, <246.8266, 51.1568, 8.6613>, <0.950, -0.241, 0.200>, <243.8046, 41.7198, 8.5069>, <0.910, -0.346, 0.230> texture { ICP35_orangish }}
	smooth_triangle { <242.6951, 90.7233, 21.1854>, <-0.897, -0.238, -0.373>, <246.8251, 90.3988, 8.6613>, <-0.923, -0.244, -0.298>, <243.8041, 99.8344, 8.5069>, <-0.909, -0.382, -0.170> texture { ICP35_orangish }}
	smooth_triangle { <248.3216, 89.3168, -3.4625>, <0.898, 0.239, 0.370>, <246.8251, 90.3988, 8.6613>, <0.960, 0.238, 0.149>, <245.6341, 98.3413, -3.4625>, <0.918, 0.281, 0.280> texture { ICP35_orangish }}
	smooth_triangle { <245.6901, 70.7803, 20.4919>, <-0.940, 0.001, -0.340>, <244.7861, 80.7094, 21.0799>, <-0.914, -0.097, -0.393>, <239.6286, 70.7794, 31.7224>, <-0.875, -0.017, -0.484> texture { ICP35_orangish }}
	smooth_triangle { <242.6951, 90.7233, 21.1854>, <-0.897, -0.238, -0.373>, <244.7861, 80.7094, 21.0799>, <-0.914, -0.097, -0.393>, <246.8251, 90.3988, 8.6613>, <-0.923, -0.244, -0.298> texture { ICP35_orangish }}
	smooth_triangle { <242.6951, 90.7233, 21.1854>, <0.857, 0.278, 0.435>, <244.7861, 80.7094, 21.0799>, <0.904, 0.176, 0.389>, <238.4276, 80.4628, 32.4464>, <0.793, 0.108, 0.600> texture { ICP35_orangish }}
	smooth_triangle { <248.3216, 89.3168, -3.4625>, <-0.917, -0.158, -0.366>, <248.6911, 80.5188, 8.5758>, <-0.973, -0.120, -0.196>, <249.9366, 79.9659, -3.4625>, <-0.921, -0.129, -0.367> texture { ICP35_orangish }}
	smooth_triangle { <248.3216, 89.3168, -3.4625>, <0.898, 0.239, 0.370>, <248.6911, 80.5188, 8.5758>, <0.973, 0.120, 0.197>, <246.8251, 90.3988, 8.6613>, <0.960, 0.238, 0.149> texture { ICP35_orangish }}
	smooth_triangle { <245.6901, 70.7803, 20.4919>, <-0.940, 0.001, -0.340>, <248.6911, 80.5188, 8.5758>, <-0.973, -0.120, -0.196>, <244.7861, 80.7094, 21.0799>, <-0.914, -0.097, -0.393> texture { ICP35_orangish }}
	smooth_triangle { <245.6901, 70.7803, 20.4919>, <0.924, 0.002, 0.383>, <248.6911, 80.5188, 8.5758>, <0.973, 0.120, 0.197>, <249.3446, 70.7783, 8.2654>, <0.986, 0.019, 0.163> texture { ICP35_orangish }}
	smooth_triangle { <230.3676, 115.1498, 21.1854>, <0.724, 0.525, 0.448>, <227.9516, 105.4808, 33.8364>, <0.651, 0.499, 0.573>, <220.4701, 116.0533, 32.4464>, <0.559, 0.538, 0.630> texture { ICP35_black_2 }}
	smooth_triangle { <223.3471, 94.2273, 43.8564>, <-0.608, -0.307, -0.732>, <227.9516, 105.4808, 33.8364>, <-0.670, -0.370, -0.643>, <216.9176, 105.3353, 43.0334>, <-0.486, -0.467, -0.738> texture { ICP35_black_2 }}
	smooth_triangle { <242.6951, 90.7233, 21.1854>, <0.857, 0.278, 0.435>, <237.5031, 103.5828, 21.6773>, <0.827, 0.392, 0.403>, <243.8041, 99.8344, 8.5069>, <0.900, 0.362, 0.241> texture { ICP35_orangish }}
	smooth_triangle { <230.3676, 115.1498, 21.1854>, <0.724, 0.525, 0.448>, <237.5031, 103.5828, 21.6773>, <0.827, 0.392, 0.403>, <227.9516, 105.4808, 33.8364>, <0.651, 0.499, 0.573> texture { ICP35_black_2 }}
	smooth_triangle { <230.3676, 115.1498, 21.1854>, <-0.712, -0.584, -0.389>, <237.5031, 103.5828, 21.6773>, <-0.782, -0.447, -0.435>, <237.8201, 111.6973, 8.5069>, <-0.853, -0.488, -0.183> texture { ICP35_orangish }}
	smooth_triangle { <223.3471, 94.2273, 43.8564>, <0.552, 0.279, 0.786>, <234.1671, 93.1583, 33.8359>, <0.750, 0.280, 0.600>, <228.5411, 82.2978, 43.0329>, <0.685, 0.131, 0.717> texture { ICP35_black_2 }}
	smooth_triangle { <223.3471, 94.2273, 43.8564>, <-0.608, -0.307, -0.732>, <234.1671, 93.1583, 33.8359>, <-0.750, -0.279, -0.600>, <227.9516, 105.4808, 33.8364>, <-0.670, -0.370, -0.643> texture { ICP35_black_2 }}
	smooth_triangle { <242.6951, 90.7233, 21.1854>, <0.857, 0.278, 0.435>, <234.1671, 93.1583, 33.8359>, <0.750, 0.280, 0.600>, <237.5031, 103.5828, 21.6773>, <0.827, 0.392, 0.403> texture { ICP35_black_2 }}
	smooth_triangle { <242.6951, 90.7233, 21.1854>, <-0.897, -0.238, -0.373>, <234.1671, 93.1583, 33.8359>, <-0.750, -0.279, -0.600>, <238.4276, 80.4628, 32.4464>, <-0.816, -0.157, -0.557> texture { ICP35_black_2 }}
	smooth_triangle { <216.7711, 128.0928, 20.4919>, <-0.513, -0.775, -0.370>, <225.6456, 126.1993, 8.5764>, <-0.583, -0.748, -0.316>, <218.6011, 131.7173, 8.2654>, <-0.561, -0.809, -0.174> texture { ICP35_orangish }}
	smooth_triangle { <232.1191, 121.4333, -3.4625>, <0.680, 0.672, 0.293>, <225.6456, 126.1993, 8.5764>, <0.682, 0.714, 0.158>, <225.8486, 127.7098, -3.4625>, <0.629, 0.674, 0.387> texture { ICP35_orangish }}
	smooth_triangle { <230.3676, 115.1498, 21.1854>, <-0.712, -0.584, -0.389>, <223.8351, 122.2298, 21.0804>, <-0.618, -0.665, -0.420>, <220.4701, 116.0533, 32.4464>, <-0.555, -0.598, -0.579> texture { ICP35_orangish }}
	smooth_triangle { <216.7711, 128.0928, 20.4919>, <-0.513, -0.775, -0.370>, <223.8351, 122.2298, 21.0804>, <-0.618, -0.665, -0.420>, <225.6456, 126.1993, 8.5764>, <-0.583, -0.748, -0.316> texture { ICP35_orangish }}
	smooth_triangle { <216.7711, 128.0928, 20.4919>, <0.500, 0.761, 0.414>, <223.8351, 122.2298, 21.0804>, <0.609, 0.678, 0.411>, <213.7421, 122.0893, 31.7224>, <0.449, 0.642, 0.621> texture { ICP35_orangish }}
	smooth_triangle { <232.1191, 121.4333, -3.4625>, <-0.702, -0.536, -0.469>, <232.1926, 119.4093, 8.6613>, <-0.748, -0.630, -0.210>, <237.6056, 114.2558, -3.4625>, <-0.787, -0.548, -0.283> texture { ICP35_orangish }}
	smooth_triangle { <232.1191, 121.4333, -3.4625>, <0.680, 0.672, 0.293>, <232.1926, 119.4093, 8.6613>, <0.749, 0.628, 0.210>, <225.6456, 126.1993, 8.5764>, <0.682, 0.714, 0.158> texture { ICP35_orangish }}
	smooth_triangle { <230.3676, 115.1498, 21.1854>, <-0.712, -0.584, -0.389>, <232.1926, 119.4093, 8.6613>, <-0.748, -0.630, -0.210>, <223.8351, 122.2298, 21.0804>, <-0.618, -0.665, -0.420> texture { ICP35_orangish }}
	smooth_triangle { <230.3676, 115.1498, 21.1854>, <0.724, 0.525, 0.448>, <232.1926, 119.4093, 8.6613>, <0.749, 0.628, 0.210>, <237.8201, 111.6973, 8.5069>, <0.816, 0.528, 0.235> texture { ICP35_orangish }}
	smooth_triangle { <200.1826, 135.0978, 21.1854>, <-0.235, -0.881, -0.411>, <202.4911, 139.0313, 8.6613>, <-0.244, -0.912, -0.331>, <193.8416, 140.7553, 8.5069>, <-0.127, -0.968, -0.215> texture { ICP35_orangish }}
	smooth_triangle { <204.0576, 139.9708, -3.4625>, <0.235, 0.885, 0.403>, <202.4911, 139.0313, 8.6613>, <0.273, 0.947, 0.167>, <195.8861, 141.8223, -3.4625>, <0.201, 0.931, 0.306> texture { ICP35_orangish }}
	smooth_triangle { <216.7711, 128.0928, 20.4919>, <-0.513, -0.775, -0.370>, <208.8066, 132.1623, 21.0799>, <-0.396, -0.812, -0.430>, <213.7421, 122.0893, 31.7224>, <-0.452, -0.723, -0.522> texture { ICP35_orangish }}
	smooth_triangle { <200.1826, 135.0978, 21.1854>, <-0.235, -0.881, -0.411>, <208.8066, 132.1623, 21.0799>, <-0.396, -0.812, -0.430>, <202.4911, 139.0313, 8.6613>, <-0.244, -0.912, -0.331> texture { ICP35_orangish }}
	smooth_triangle { <200.1826, 135.0978, 21.1854>, <0.168, 0.863, 0.476>, <208.8066, 132.1623, 21.0799>, <0.306, 0.850, 0.428>, <205.8101, 125.7418, 32.4464>, <0.310, 0.701, 0.642> texture { ICP35_orangish }}
	smooth_triangle { <204.0576, 139.9708, -3.4625>, <-0.333, -0.855, -0.397>, <210.9011, 135.9423, 8.5758>, <-0.408, -0.886, -0.218>, <211.9426, 136.8993, -3.4625>, <-0.368, -0.841, -0.398> texture { ICP35_orangish }}
	smooth_triangle { <204.0576, 139.9708, -3.4625>, <0.235, 0.885, 0.403>, <210.9011, 135.9423, 8.5758>, <0.409, 0.886, 0.218>, <202.4911, 139.0313, 8.6613>, <0.273, 0.947, 0.167> texture { ICP35_orangish }}
	smooth_triangle { <216.7711, 128.0928, 20.4919>, <-0.513, -0.775, -0.370>, <210.9011, 135.9423, 8.5758>, <-0.408, -0.886, -0.218>, <208.8066, 132.1623, 21.0799>, <-0.396, -0.812, -0.430> texture { ICP35_orangish }}
	smooth_triangle { <216.7711, 128.0928, 20.4919>, <0.500, 0.761, 0.414>, <210.9011, 135.9423, 8.5758>, <0.409, 0.886, 0.218>, <218.6011, 131.7173, 8.2654>, <0.523, 0.833, 0.179> texture { ICP35_orangish }}
	smooth_triangle { <200.1826, 135.0978, 21.1854>, <0.168, 0.863, 0.476>, <187.8571, 136.3823, 21.6773>, <0.009, 0.925, 0.380>, <193.8416, 140.7553, 8.5069>, <0.037, 0.970, 0.240> texture { ICP35_orangish }}
	smooth_triangle { <187.8571, 117.6738, 43.8559>, <-0.015, 0.567, 0.823>, <194.0741, 127.8678, 33.8359>, <0.105, 0.760, 0.642>, <199.4806, 116.8588, 43.0329>, <0.224, 0.616, 0.755> texture { ICP35_orangish }}
	smooth_triangle { <187.8571, 117.6738, 43.8559>, <0.057, -0.662, -0.747>, <194.0741, 127.8678, 33.8359>, <-0.071, -0.762, -0.644>, <187.8571, 136.3823, 21.6773>, <0.209, -0.747, -0.630> texture { ICP35_orangish }}
	smooth_triangle { <200.1826, 135.0978, 21.1854>, <0.168, 0.863, 0.476>, <194.0741, 127.8678, 33.8359>, <0.105, 0.760, 0.642>, <187.8571, 136.3823, 21.6773>, <0.009, 0.925, 0.380> texture { ICP35_orangish }}
	smooth_triangle { <200.1826, 135.0978, 21.1854>, <-0.235, -0.881, -0.411>, <194.0741, 127.8678, 33.8359>, <-0.071, -0.762, -0.644>, <205.8101, 125.7418, 32.4464>, <-0.273, -0.752, -0.600> texture { ICP35_orangish }}
	smooth_triangle { <199.8351, 47.0383, 54.3694>, <0.156, -0.315, 0.936>, <186.2866, 46.5244, 55.4579>, <-0.002, -0.326, 0.945>, <193.7221, 59.1563, 58.0254>, <0.028, -0.147, 0.989> texture { ICP35_orangish }}
	smooth_triangle { <193.9401, 34.6188, 50.2289>, <0.057, -0.443, 0.895>, <188.2661, 23.9038, 43.8559>, <0.000, -0.648, 0.762>, <186.2866, 46.5244, 55.4579>, <-0.002, -0.326, 0.945> texture { ICP35_orangish }}
	smooth_triangle { <193.9401, 34.6188, 50.2289>, <-0.148, 0.472, -0.869>, <188.2661, 23.9038, 43.8559>, <-0.100, 0.808, -0.580>, <199.4811, 24.7008, 43.0329>, <-0.062, 0.799, -0.598> texture { ICP35_orangish }}
	smooth_triangle { <199.8351, 47.0383, 54.3694>, <0.156, -0.315, 0.936>, <193.9401, 34.6188, 50.2289>, <0.057, -0.443, 0.895>, <186.2866, 46.5244, 55.4579>, <-0.002, -0.326, 0.945> texture { ICP35_orangish }}
	smooth_triangle { <199.8351, 47.0383, 54.3694>, <-0.230, 0.280, -0.932>, <193.9401, 34.6188, 50.2289>, <-0.148, 0.472, -0.869>, <205.4510, 35.9103, 48.3094>, <-0.237, 0.423, -0.874> texture { ICP35_orangish }}
	smooth_triangle { <211.8131, 70.7803, 54.3694>, <0.387, -0.034, 0.921>, <206.1641, 58.6873, 55.4579>, <0.341, -0.075, 0.937>, <199.5866, 70.7798, 58.0254>, <0.159, -0.016, 0.987> texture { ICP35_orangish }}
	smooth_triangle { <199.8351, 47.0383, 54.3694>, <-0.230, 0.280, -0.932>, <206.1641, 58.6873, 55.4579>, <-0.271, 0.186, -0.944>, <193.7221, 59.1563, 58.0254>, <-0.195, 0.147, -0.970> texture { ICP35_orangish }}
	smooth_triangle { <223.3451, 47.3333, 43.8564>, <0.552, -0.279, 0.786>, <218.2661, 58.7228, 50.2289>, <0.510, -0.161, 0.845>, <228.5411, 59.2583, 43.0329>, <0.630, -0.156, 0.761> texture { ICP35_orangish }}
	smooth_triangle { <211.8131, 70.7803, 54.3694>, <0.387, -0.034, 0.921>, <218.2661, 58.7228, 50.2289>, <0.510, -0.161, 0.845>, <206.1641, 58.6873, 55.4579>, <0.341, -0.075, 0.937> texture { ICP35_orangish }}
	smooth_triangle { <211.8131, 70.7803, 54.3694>, <-0.387, -0.034, -0.921>, <218.2661, 58.7228, 50.2289>, <-0.433, 0.123, -0.893>, <223.0421, 70.7788, 48.3094>, <-0.565, -0.001, -0.825> texture { ICP35_orangish }}
	smooth_triangle { <199.8351, 47.0383, 54.3694>, <0.156, -0.315, 0.936>, <212.1856, 46.6718, 50.2289>, <0.393, -0.296, 0.870>, <205.4510, 35.9103, 48.3094>, <0.297, -0.403, 0.866> texture { ICP35_orangish }}
	smooth_triangle { <199.8351, 47.0383, 54.3694>, <-0.230, 0.280, -0.932>, <212.1856, 46.6718, 50.2289>, <-0.394, 0.296, -0.870>, <206.1641, 58.6873, 55.4579>, <-0.271, 0.186, -0.944> texture { ICP35_orangish }}
	smooth_triangle { <223.3451, 47.3333, 43.8564>, <0.552, -0.279, 0.786>, <212.1856, 46.6718, 50.2289>, <0.393, -0.296, 0.870>, <218.2661, 58.7228, 50.2289>, <0.510, -0.161, 0.845> texture { ICP35_orangish }}
	smooth_triangle { <223.3451, 47.3333, 43.8564>, <-0.608, 0.307, -0.732>, <212.1856, 46.6718, 50.2289>, <-0.394, 0.296, -0.870>, <216.9211, 36.2183, 43.0334>, <-0.480, 0.408, -0.777> texture { ICP35_orangish }}
	smooth_triangle { <199.8311, 94.5193, 54.3694>, <0.230, 0.280, 0.932>, <206.1606, 82.8718, 55.4579>, <0.247, 0.222, 0.943>, <193.7226, 82.4043, 58.0254>, <0.143, 0.121, 0.982> texture { ICP35_orangish }}
	smooth_triangle { <211.8131, 70.7803, 54.3694>, <-0.387, -0.034, -0.921>, <206.1606, 82.8718, 55.4579>, <-0.319, -0.112, -0.941>, <199.5866, 70.7798, 58.0254>, <-0.228, -0.016, -0.974> texture { ICP35_orangish }}
	smooth_triangle { <223.3471, 94.2273, 43.8564>, <0.552, 0.279, 0.786>, <212.1851, 94.8878, 50.2289>, <0.419, 0.309, 0.854>, <216.9176, 105.3353, 43.0334>, <0.480, 0.408, 0.777> texture { ICP35_black_2 }}
	smooth_triangle { <199.8311, 94.5193, 54.3694>, <0.230, 0.280, 0.932>, <212.1851, 94.8878, 50.2289>, <0.419, 0.309, 0.854>, <206.1606, 82.8718, 55.4579>, <0.247, 0.222, 0.943> texture { ICP35_orangish }}
	smooth_triangle { <199.8311, 94.5193, 54.3694>, <-0.162, -0.315, -0.935>, <212.1851, 94.8878, 50.2289>, <-0.341, -0.270, -0.901>, <205.4501, 105.6523, 48.3094>, <-0.290, -0.441, -0.849> texture { ICP35_orangish }}
	smooth_triangle { <211.8131, 70.7803, 54.3694>, <0.387, -0.034, 0.921>, <218.2646, 82.8303, 50.2289>, <0.485, 0.149, 0.862>, <223.0421, 70.7788, 48.3094>, <0.565, 0.000, 0.825> texture { ICP35_orangish }}
	smooth_triangle { <211.8131, 70.7803, 54.3694>, <-0.387, -0.034, -0.921>, <218.2646, 82.8303, 50.2289>, <-0.485, -0.148, -0.862>, <206.1606, 82.8718, 55.4579>, <-0.319, -0.112, -0.941> texture { ICP35_orangish }}
	smooth_triangle { <223.3471, 94.2273, 43.8564>, <0.552, 0.279, 0.786>, <218.2646, 82.8303, 50.2289>, <0.485, 0.149, 0.862>, <212.1851, 94.8878, 50.2289>, <0.419, 0.309, 0.854> texture { ICP35_black_2 }}
	smooth_triangle { <223.3471, 94.2273, 43.8564>, <-0.608, -0.307, -0.732>, <218.2646, 82.8303, 50.2289>, <-0.485, -0.148, -0.862>, <228.5411, 82.2978, 43.0329>, <-0.630, -0.156, -0.761> texture { ICP35_black_2 }}
	smooth_triangle { <199.8311, 94.5193, 54.3694>, <-0.162, -0.315, -0.935>, <187.8616, 94.9653, 55.4579>, <-0.028, -0.252, -0.967>, <193.7226, 82.4043, 58.0254>, <-0.062, -0.165, -0.984> texture { ICP35_orangish }}
	smooth_triangle { <199.8311, 94.5193, 54.3694>, <0.230, 0.280, 0.932>, <193.9391, 106.9398, 50.2289>, <0.033, 0.427, 0.904>, <205.4501, 105.6523, 48.3094>, <0.291, 0.440, 0.849> texture { ICP35_orangish }}
	smooth_triangle { <199.8311, 94.5193, 54.3694>, <-0.162, -0.315, -0.935>, <193.9391, 106.9398, 50.2289>, <-0.131, -0.471, -0.872>, <187.8616, 94.9653, 55.4579>, <-0.028, -0.252, -0.967> texture { ICP35_orangish }}
	smooth_triangle { <187.8571, 117.6738, 43.8559>, <0.057, -0.662, -0.747>, <193.9391, 106.9398, 50.2289>, <-0.131, -0.471, -0.872>, <199.4806, 116.8588, 43.0329>, <-0.168, -0.582, -0.796> texture { ICP35_orangish }}
	smooth_triangle { <187.8571, 117.6738, 43.8559>, <-0.015, 0.567, 0.823>, <193.9391, 106.9398, 50.2289>, <0.033, 0.427, 0.904>, <187.8616, 94.9653, 55.4579>, <-0.129, 0.451, 0.883> texture { ICP35_orangish }}
	smooth_triangle { <134.1351, 18.2593, -8.3870>, <0.618, 0.472, -0.629>, <139.9861, 10.6053, -8.3870>, <0.618, 0.472, -0.629>, <142.9361, 13.9813, -2.9540>, <0.716, 0.585, -0.382> texture { ICP35_black_2 }}
	smooth_triangle { <134.1351, 18.2593, -8.3870>, <-0.676, -0.394, 0.623>, <129.3751, 26.4313, -8.3870>, <-0.676, -0.394, 0.623>, <137.4506, 21.1568, -2.9540>, <-0.766, -0.446, 0.463> texture { ICP35_black_2 }}
	smooth_triangle { <146.6741, 3.9088, -8.3870>, <0.465, 0.609, -0.642>, <153.8146, -1.5380, -8.3870>, <0.465, 0.609, -0.642>, <155.9006, 2.5968, -2.9540>, <0.465, 0.609, -0.642> texture { ICP35_black_2 }}
	smooth_triangle { <146.6741, 3.9088, -8.3870>, <-0.546, -0.546, 0.636>, <139.9861, 10.6053, -8.3870>, <-0.546, -0.546, 0.636>, <149.2061, 7.7033, -2.9540>, <-0.628, -0.676, 0.386> texture { ICP35_black_2 }}
	smooth_triangle { <178.6351, -11.1435, -8.3870>, <-0.166, -0.735, 0.657>, <169.9181, -9.1715, -8.3870>, <-0.166, -0.735, 0.657>, <170.9976, -4.5595, -2.9540>, <-0.192, -0.849, 0.493> texture { ICP35_black_2 }}
	smooth_triangle { <178.6351, -11.1435, -8.3870>, <0.055, 0.750, -0.659>, <187.1986, -11.7745, -8.3870>, <0.019, 0.751, -0.660>, <179.1701, -6.4085, -2.9540>, <0.105, 0.860, -0.500> texture { ICP35_black_2 }}
	smooth_triangle { <161.5076, -5.8915, -8.3870>, <-0.375, -0.663, 0.648>, <153.8146, -1.5380, -8.3870>, <-0.375, -0.663, 0.648>, <155.9006, 2.5968, -2.9540>, <-0.483, -0.782, 0.394> texture { ICP35_black_2 }}
	smooth_triangle { <161.5076, -5.8915, -8.3870>, <0.275, 0.705, -0.653>, <169.9181, -9.1715, -8.3870>, <0.275, 0.705, -0.653>, <163.1126, -1.4845, -2.9540>, <0.365, 0.841, -0.399> texture { ICP35_black_2 }}
	smooth_triangle { <175.5751, 18.5548, 43.5414>, <0.207, 0.685, -0.698>, <169.2446, 9.6743, 32.9549>, <0.261, 0.715, -0.649>, <180.9826, 7.5473, 34.3444>, <0.081, 0.783, -0.617> texture { ICP35_black_2 }}
	smooth_triangle { <156.4551, 3.6958, 8.7739>, <0.560, 0.809, -0.178>, <163.1126, -1.4845, -2.9540>, <0.365, 0.841, -0.399>, <164.1541, -0.5285, 9.0844>, <0.381, 0.910, -0.165> texture { ICP35_black_2 }}
	smooth_triangle { <161.3131, 13.3253, 32.2309>, <-0.487, -0.701, 0.520>, <169.2446, 9.6743, 32.9549>, <-0.322, -0.738, 0.593>, <166.2501, 3.2509, 21.5883>, <-0.361, -0.826, 0.433> texture { ICP35_black_2 }}
	smooth_triangle { <166.2501, 3.2509, 21.5883>, <0.378, 0.824, -0.422>, <164.1541, -0.5285, 9.0844>, <0.381, 0.910, -0.165>, <172.5636, -3.6190, 9.1699>, <0.263, 0.939, -0.223> texture { ICP35_black_2 }}
	smooth_triangle { <179.1701, -6.4085, -2.9540>, <0.105, 0.860, -0.500>, <181.2141, -5.3440, 9.0154>, <0.187, 0.957, -0.223>, <172.5636, -3.6190, 9.1699>, <0.263, 0.939, -0.223> texture { ICP35_black_2 }}
	smooth_triangle { <137.2341, 23.7148, 9.0154>, <0.804, 0.585, -0.110>, <137.4506, 21.1568, -2.9540>, <0.765, 0.575, -0.289>, <142.8651, 16.0034, 9.1699>, <0.753, 0.639, -0.158> texture { ICP35_black_2 }}
	smooth_triangle { <154.5846, 19.3608, 32.9549>, <-0.539, -0.663, 0.520>, <161.3131, 13.3253, 32.2309>, <-0.487, -0.701, 0.520>, <151.2206, 13.1813, 21.5883>, <-0.591, -0.689, 0.420> texture { ICP35_black_2 }}
	smooth_triangle { <151.2206, 13.1813, 21.5883>, <0.660, 0.629, -0.410>, <142.8651, 16.0034, 9.1699>, <0.753, 0.639, -0.158>, <149.4091, 9.2133, 9.0848>, <0.651, 0.729, -0.211> texture { ICP35_white_3 }}
	smooth_triangle { <149.2061, 7.7033, -2.9540>, <0.562, 0.729, -0.392>, <156.4551, 3.6958, 8.7739>, <0.560, 0.809, -0.178>, <149.4091, 9.2133, 9.0848>, <0.651, 0.729, -0.211> texture { ICP35_white_3 }}
	smooth_triangle { <187.1986, -7.0000, -2.9540>, <0.064, -0.957, 0.283>, <181.2141, -5.3440, 9.0154>, <0.003, -0.973, 0.233>, <187.1986, -0.9690, 22.1859>, <-0.004, -0.914, 0.405> texture { ICP35_black_2 }}
	smooth_triangle { <170.9976, -4.5595, -2.9540>, <0.340, 0.890, -0.304>, <163.1126, -1.4845, -2.9540>, <0.365, 0.841, -0.399>, <169.9181, -9.1715, -8.3870>, <0.275, 0.705, -0.653> texture { ICP35_black_2 }}
	smooth_triangle { <155.9006, 2.5968, -2.9540>, <-0.483, -0.782, 0.394>, <163.1126, -1.4845, -2.9540>, <-0.453, -0.800, 0.394>, <161.5076, -5.8915, -8.3870>, <-0.375, -0.663, 0.648> texture { ICP35_black_2 }}
	smooth_triangle { <187.1986, -7.0000, -2.9540>, <0.064, -0.957, 0.283>, <179.1701, -6.4085, -2.9540>, <-0.160, -0.940, 0.300>, <181.2141, -5.3440, 9.0154>, <0.003, -0.973, 0.233> texture { ICP35_black_2 }}
	smooth_triangle { <187.1986, -7.0000, -2.9540>, <0.127, 0.880, -0.458>, <179.1701, -6.4085, -2.9540>, <0.105, 0.860, -0.500>, <187.1986, -11.7745, -8.3870>, <0.019, 0.751, -0.660> texture { ICP35_black_2 }}
	smooth_triangle { <170.9976, -4.5595, -2.9540>, <-0.192, -0.849, 0.493>, <179.1701, -6.4085, -2.9540>, <-0.160, -0.940, 0.300>, <178.6351, -11.1435, -8.3870>, <-0.166, -0.735, 0.657> texture { ICP35_black_2 }}
	smooth_triangle { <165.0676, 20.7683, 41.3084>, <0.407, 0.617, -0.674>, <161.3131, 13.3253, 32.2309>, <0.413, 0.664, -0.623>, <169.2446, 9.6743, 32.9549>, <0.261, 0.715, -0.649> texture { ICP35_black_2 }}
	smooth_triangle { <155.9006, 2.5968, -2.9540>, <-0.483, -0.782, 0.394>, <156.4551, 3.6958, 8.7739>, <-0.524, -0.834, 0.175>, <163.1126, -1.4845, -2.9540>, <-0.453, -0.800, 0.394> texture { ICP35_black_2 }}
	smooth_triangle { <142.9361, 13.9813, -2.9540>, <-0.653, -0.652, 0.384>, <149.2061, 7.7033, -2.9540>, <-0.628, -0.676, 0.386>, <139.9861, 10.6053, -8.3870>, <-0.546, -0.546, 0.636> texture { ICP35_black_2 }}
	smooth_triangle { <155.9006, 2.5968, -2.9540>, <-0.483, -0.782, 0.394>, <149.2061, 7.7033, -2.9540>, <-0.628, -0.676, 0.386>, <156.4551, 3.6958, 8.7739>, <-0.524, -0.834, 0.175> texture { ICP35_black_2 }}
	smooth_triangle { <155.9006, 2.5968, -2.9540>, <0.465, 0.609, -0.642>, <149.2061, 7.7033, -2.9540>, <0.562, 0.729, -0.392>, <146.6741, 3.9088, -8.3870>, <0.465, 0.609, -0.642> texture { ICP35_black_2 }}
	smooth_triangle { <132.9881, 28.8183, -2.9540>, <-0.802, -0.467, 0.373>, <137.4506, 21.1568, -2.9540>, <-0.766, -0.446, 0.463>, <129.3751, 26.4313, -8.3870>, <-0.676, -0.394, 0.623> texture { ICP35_black_2 }}
	smooth_triangle { <142.9361, 13.9813, -2.9540>, <0.716, 0.585, -0.382>, <137.4506, 21.1568, -2.9540>, <0.765, 0.575, -0.289>, <134.1351, 18.2593, -8.3870>, <0.618, 0.472, -0.629> texture { ICP35_black_2 }}
	smooth_triangle { <132.9881, 28.8183, -2.9540>, <-0.802, -0.467, 0.373>, <137.2341, 23.7148, 9.0154>, <-0.822, -0.533, 0.198>, <137.4506, 21.1568, -2.9540>, <-0.766, -0.446, 0.463> texture { ICP35_black_2 }}
	smooth_triangle { <165.0676, 20.7683, 41.3084>, <0.407, 0.617, -0.674>, <154.5846, 19.3608, 32.9549>, <0.546, 0.592, -0.592>, <161.3131, 13.3253, 32.2309>, <0.413, 0.664, -0.623> texture { ICP35_black_2 }}
	smooth_triangle { <165.0676, 20.7683, 41.3084>, <-0.286, -0.643, 0.710>, <175.5751, 18.5548, 43.5414>, <-0.194, -0.658, 0.728>, <169.2446, 9.6743, 32.9549>, <-0.322, -0.738, 0.593> texture { ICP35_black_2 }}
	smooth_triangle { <174.8746, 0.3148, 21.6938>, <0.168, 0.863, -0.476>, <180.9826, 7.5473, 34.3444>, <0.081, 0.783, -0.617>, <169.2446, 9.6743, 32.9549>, <0.261, 0.715, -0.649> texture { ICP35_black_2 }}
	smooth_triangle { <187.1986, 17.7398, 44.3644>, <-0.070, -0.700, 0.710>, <180.9826, 7.5473, 34.3444>, <-0.099, -0.666, 0.739>, <175.5751, 18.5548, 43.5414>, <-0.194, -0.658, 0.728> texture { ICP35_black_2 }}
	smooth_triangle { <187.1986, 17.7398, 44.3644>, <-0.209, 0.747, -0.631>, <180.9826, 7.5473, 34.3444>, <0.081, 0.783, -0.617>, <187.1986, -0.9690, 22.1859>, <-0.004, 0.869, -0.495> texture { ICP35_black_2 }}
	smooth_triangle { <174.8746, 0.3148, 21.6938>, <0.168, 0.863, -0.476>, <187.1986, -0.9690, 22.1859>, <-0.004, 0.869, -0.495>, <180.9826, 7.5473, 34.3444>, <0.081, 0.783, -0.617> texture { ICP35_black_2 }}
	smooth_triangle { <174.8746, 0.3148, 21.6938>, <-0.235, -0.881, 0.411>, <187.1986, -0.9690, 22.1859>, <-0.004, -0.914, 0.405>, <181.2141, -5.3440, 9.0154>, <0.003, -0.973, 0.233> texture { ICP35_black_2 }}
	smooth_triangle { <158.2831, 7.3193, 21.0004>, <-0.511, -0.776, 0.370>, <164.1541, -0.5285, 9.0844>, <-0.458, -0.829, 0.321>, <156.4551, 3.6958, 8.7739>, <-0.524, -0.834, 0.175> texture { ICP35_black_2 }}
	smooth_triangle { <170.9976, -4.5595, -2.9540>, <0.340, 0.890, -0.304>, <164.1541, -0.5285, 9.0844>, <0.381, 0.910, -0.165>, <163.1126, -1.4845, -2.9540>, <0.365, 0.841, -0.399> texture { ICP35_black_2 }}
	smooth_triangle { <174.8746, 0.3148, 21.6938>, <-0.235, -0.881, 0.411>, <166.2501, 3.2509, 21.5883>, <-0.361, -0.826, 0.433>, <169.2446, 9.6743, 32.9549>, <-0.322, -0.738, 0.593> texture { ICP35_black_2 }}
	smooth_triangle { <158.2831, 7.3193, 21.0004>, <-0.511, -0.776, 0.370>, <166.2501, 3.2509, 21.5883>, <-0.361, -0.826, 0.433>, <164.1541, -0.5285, 9.0844>, <-0.458, -0.829, 0.321> texture { ICP35_black_2 }}
	smooth_triangle { <158.2831, 7.3193, 21.0004>, <0.503, 0.758, -0.415>, <166.2501, 3.2509, 21.5883>, <0.378, 0.824, -0.422>, <161.3131, 13.3253, 32.2309>, <0.413, 0.664, -0.623> texture { ICP35_black_2 }}
	smooth_triangle { <170.9976, -4.5595, -2.9540>, <-0.192, -0.849, 0.493>, <172.5636, -3.6190, 9.1699>, <-0.266, -0.938, 0.222>, <179.1701, -6.4085, -2.9540>, <-0.160, -0.940, 0.300> texture { ICP35_black_2 }}
	smooth_triangle { <170.9976, -4.5595, -2.9540>, <0.340, 0.890, -0.304>, <172.5636, -3.6190, 9.1699>, <0.263, 0.939, -0.223>, <164.1541, -0.5285, 9.0844>, <0.381, 0.910, -0.165> texture { ICP35_black_2 }}
	smooth_triangle { <174.8746, 0.3148, 21.6938>, <-0.235, -0.881, 0.411>, <172.5636, -3.6190, 9.1699>, <-0.266, -0.938, 0.222>, <166.2501, 3.2509, 21.5883>, <-0.361, -0.826, 0.433> texture { ICP35_black_2 }}
	smooth_triangle { <174.8746, 0.3148, 21.6938>, <0.168, 0.863, -0.476>, <172.5636, -3.6190, 9.1699>, <0.263, 0.939, -0.223>, <181.2141, -5.3440, 9.0154>, <0.187, 0.957, -0.223> texture { ICP35_black_2 }}
	smooth_triangle { <144.6866, 20.2614, 21.6938>, <-0.735, -0.603, 0.312>, <142.8651, 16.0034, 9.1699>, <-0.735, -0.603, 0.312>, <137.2341, 23.7148, 9.0154>, <-0.822, -0.533, 0.198> texture { ICP35_black_2 }}
	smooth_triangle { <142.9361, 13.9813, -2.9540>, <0.716, 0.585, -0.382>, <142.8651, 16.0034, 9.1699>, <0.753, 0.639, -0.158>, <137.4506, 21.1568, -2.9540>, <0.765, 0.575, -0.289> texture { ICP35_black_2 }}
	smooth_triangle { <158.2831, 7.3193, 21.0004>, <-0.511, -0.776, 0.370>, <151.2206, 13.1813, 21.5883>, <-0.591, -0.689, 0.420>, <161.3131, 13.3253, 32.2309>, <-0.487, -0.701, 0.520> texture { ICP35_black_2 }}
	smooth_triangle { <144.6866, 20.2614, 21.6938>, <-0.735, -0.603, 0.312>, <151.2206, 13.1813, 21.5883>, <-0.591, -0.689, 0.420>, <142.8651, 16.0034, 9.1699>, <-0.735, -0.603, 0.312> texture { ICP35_black_2 }}
	smooth_triangle { <144.6866, 20.2614, 21.6938>, <0.630, 0.589, -0.507>, <151.2206, 13.1813, 21.5883>, <0.660, 0.629, -0.410>, <154.5846, 19.3608, 32.9549>, <0.546, 0.592, -0.592> texture { ICP35_black_2 }}
	smooth_triangle { <142.9361, 13.9813, -2.9540>, <-0.653, -0.652, 0.384>, <149.4091, 9.2133, 9.0848>, <-0.652, -0.728, 0.212>, <149.2061, 7.7033, -2.9540>, <-0.628, -0.676, 0.386> texture { ICP35_white_3 }}
	smooth_triangle { <142.9361, 13.9813, -2.9540>, <0.716, 0.585, -0.382>, <149.4091, 9.2133, 9.0848>, <0.651, 0.729, -0.211>, <142.8651, 16.0034, 9.1699>, <0.753, 0.639, -0.158> texture { ICP35_white_3 }}
	smooth_triangle { <158.2831, 7.3193, 21.0004>, <-0.511, -0.776, 0.370>, <149.4091, 9.2133, 9.0848>, <-0.652, -0.728, 0.212>, <151.2206, 13.1813, 21.5883>, <-0.591, -0.689, 0.420> texture { ICP35_white_3 }}
	smooth_triangle { <158.2831, 7.3193, 21.0004>, <0.503, 0.758, -0.415>, <149.4091, 9.2133, 9.0848>, <0.651, 0.729, -0.211>, <156.4551, 3.6958, 8.7739>, <0.560, 0.809, -0.178> texture { ICP35_white_3 }}
	smooth_triangle { <218.0111, 3.6958, 8.7739>, <0.524, -0.834, 0.175>, <225.2601, 7.7033, -2.9540>, <0.607, -0.694, 0.388>, <218.5656, 2.5968, -2.9540>, <0.507, -0.768, 0.393> texture { ICP35_black_2 }}
	smooth_triangle { <218.0111, 3.6958, 8.7739>, <-0.560, 0.809, -0.178>, <225.0571, 9.2133, 9.0848>, <-0.639, 0.749, -0.178>, <216.1831, 7.3193, 21.0004>, <-0.503, 0.758, -0.415> texture { ICP35_white_3 }}
	smooth_triangle { <225.2601, 7.7033, -2.9540>, <-0.604, 0.695, -0.389>, <225.0571, 9.2133, 9.0848>, <-0.639, 0.749, -0.178>, <218.0111, 3.6958, 8.7739>, <-0.560, 0.809, -0.178> texture { ICP35_white_3 }}
	smooth_triangle { <225.2601, 7.7033, -2.9540>, <0.607, -0.694, 0.388>, <225.0571, 9.2133, 9.0848>, <0.663, -0.707, 0.245>, <231.5301, 13.9813, -2.9540>, <0.648, -0.597, 0.473> texture { ICP35_white_3 }}
	smooth_triangle { <231.6011, 16.0034, 9.1699>, <0.718, -0.623, 0.311>, <223.2456, 13.1813, 21.5883>, <0.627, -0.688, 0.367>, <229.7796, 20.2614, 21.6938>, <0.735, -0.603, 0.312> texture { ICP35_black_2 }}
	smooth_triangle { <223.2456, 13.1813, 21.5883>, <0.627, -0.688, 0.367>, <225.0571, 9.2133, 9.0848>, <0.663, -0.707, 0.245>, <216.1831, 7.3193, 21.0004>, <0.511, -0.776, 0.370> texture { ICP35_white_3 }}
	smooth_triangle { <231.6011, 16.0034, 9.1699>, <0.718, -0.623, 0.311>, <225.0571, 9.2133, 9.0848>, <0.663, -0.707, 0.245>, <223.2456, 13.1813, 21.5883>, <0.627, -0.688, 0.367> texture { ICP35_white_3 }}
	smooth_triangle { <231.6011, 16.0034, 9.1699>, <-0.771, 0.628, -0.106>, <225.0571, 9.2133, 9.0848>, <-0.639, 0.749, -0.178>, <231.5301, 13.9813, -2.9540>, <-0.736, 0.612, -0.290> texture { ICP35_white_3 }}
	smooth_triangle { <213.1531, 13.3253, 32.2309>, <-0.436, 0.683, -0.585>, <219.8816, 19.3608, 32.9549>, <-0.544, 0.617, -0.569>, <209.3986, 20.7683, 41.3084>, <-0.407, 0.617, -0.674> texture { ICP35_black_2 }}
	smooth_triangle { <219.8816, 19.3608, 32.9549>, <-0.544, 0.617, -0.569>, <223.2456, 13.1813, 21.5883>, <-0.585, 0.627, -0.514>, <229.7796, 20.2614, 21.6938>, <-0.630, 0.589, -0.507> texture { ICP35_black_2 }}
	smooth_triangle { <213.1531, 13.3253, 32.2309>, <-0.436, 0.683, -0.585>, <223.2456, 13.1813, 21.5883>, <-0.585, 0.627, -0.514>, <219.8816, 19.3608, 32.9549>, <-0.544, 0.617, -0.569> texture { ICP35_black_2 }}
	smooth_triangle { <213.1531, 13.3253, 32.2309>, <0.525, -0.683, 0.507>, <223.2456, 13.1813, 21.5883>, <0.627, -0.688, 0.367>, <216.1831, 7.3193, 21.0004>, <0.511, -0.776, 0.370> texture { ICP35_black_2 }}
	smooth_triangle { <237.0156, 21.1568, -2.9540>, <0.747, -0.474, 0.466>, <237.2321, 23.7148, 9.0154>, <0.822, -0.533, 0.198>, <241.4781, 28.8183, -2.9540>, <0.802, -0.467, 0.373> texture { ICP35_black_2 }}
	smooth_triangle { <237.0156, 21.1568, -2.9540>, <-0.786, 0.548, -0.287>, <231.6011, 16.0034, 9.1699>, <-0.771, 0.628, -0.106>, <231.5301, 13.9813, -2.9540>, <-0.736, 0.612, -0.290> texture { ICP35_black_2 }}
	smooth_triangle { <237.2321, 23.7148, 9.0154>, <-0.804, 0.585, -0.110>, <231.6011, 16.0034, 9.1699>, <-0.771, 0.628, -0.106>, <237.0156, 21.1568, -2.9540>, <-0.786, 0.548, -0.287> texture { ICP35_black_2 }}
	smooth_triangle { <237.2321, 23.7148, 9.0154>, <0.822, -0.533, 0.198>, <231.6011, 16.0034, 9.1699>, <0.718, -0.623, 0.311>, <229.7796, 20.2614, 21.6938>, <0.735, -0.603, 0.312> texture { ICP35_black_2 }}
	smooth_triangle { <193.2521, -5.3440, 9.0154>, <0.092, -0.968, 0.232>, <195.2961, -6.4085, -2.9540>, <0.121, -0.946, 0.301>, <187.1986, -7.0000, -2.9540>, <0.064, -0.957, 0.283> texture { ICP35_black_2 }}
	smooth_triangle { <193.2521, -5.3440, 9.0154>, <-0.061, 0.972, -0.229>, <201.9026, -3.6190, 9.1699>, <-0.240, 0.952, -0.188>, <199.5916, 0.3148, 21.6938>, <-0.168, 0.863, -0.476> texture { ICP35_black_2 }}
	smooth_triangle { <195.2961, -6.4085, -2.9540>, <-0.144, 0.855, -0.499>, <201.9026, -3.6190, 9.1699>, <-0.240, 0.952, -0.188>, <193.2521, -5.3440, 9.0154>, <-0.061, 0.972, -0.229> texture { ICP35_black_2 }}
	smooth_triangle { <195.2961, -6.4085, -2.9540>, <0.121, -0.946, 0.301>, <201.9026, -3.6190, 9.1699>, <0.288, -0.923, 0.256>, <203.4686, -4.5595, -2.9540>, <0.202, -0.894, 0.399> texture { ICP35_black_2 }}
	smooth_triangle { <210.3121, -0.5285, 9.0844>, <0.416, -0.850, 0.322>, <208.2161, 3.2509, 21.5883>, <0.343, -0.858, 0.381>, <216.1831, 7.3193, 21.0004>, <0.511, -0.776, 0.370> texture { ICP35_black_2 }}
	smooth_triangle { <208.2161, 3.2509, 21.5883>, <0.343, -0.858, 0.381>, <201.9026, -3.6190, 9.1699>, <0.288, -0.923, 0.256>, <199.5916, 0.3148, 21.6938>, <0.234, -0.881, 0.411> texture { ICP35_black_2 }}
	smooth_triangle { <210.3121, -0.5285, 9.0844>, <0.416, -0.850, 0.322>, <201.9026, -3.6190, 9.1699>, <0.288, -0.923, 0.256>, <208.2161, 3.2509, 21.5883>, <0.343, -0.858, 0.381> texture { ICP35_black_2 }}
	smooth_triangle { <210.3121, -0.5285, 9.0844>, <-0.396, 0.911, -0.111>, <201.9026, -3.6190, 9.1699>, <-0.240, 0.952, -0.188>, <203.4686, -4.5595, -2.9540>, <-0.301, 0.865, -0.402> texture { ICP35_black_2 }}
	smooth_triangle { <205.2216, 9.6743, 32.9549>, <-0.324, 0.738, -0.593>, <213.1531, 13.3253, 32.2309>, <-0.436, 0.683, -0.585>, <209.3986, 20.7683, 41.3084>, <-0.407, 0.617, -0.674> texture { ICP35_black_2 }}
	smooth_triangle { <213.1531, 13.3253, 32.2309>, <-0.436, 0.683, -0.585>, <208.2161, 3.2509, 21.5883>, <-0.407, 0.750, -0.521>, <216.1831, 7.3193, 21.0004>, <-0.503, 0.758, -0.415> texture { ICP35_black_2 }}
	smooth_triangle { <205.2216, 9.6743, 32.9549>, <-0.324, 0.738, -0.593>, <208.2161, 3.2509, 21.5883>, <-0.407, 0.750, -0.521>, <213.1531, 13.3253, 32.2309>, <-0.436, 0.683, -0.585> texture { ICP35_black_2 }}
	smooth_triangle { <205.2216, 9.6743, 32.9549>, <0.259, -0.715, 0.650>, <208.2161, 3.2509, 21.5883>, <0.343, -0.858, 0.381>, <199.5916, 0.3148, 21.6938>, <0.234, -0.881, 0.411> texture { ICP35_black_2 }}
	smooth_triangle { <211.3536, -1.4845, -2.9540>, <0.402, -0.825, 0.398>, <218.0111, 3.6958, 8.7739>, <0.524, -0.834, 0.175>, <218.5656, 2.5968, -2.9540>, <0.507, -0.768, 0.393> texture { ICP35_black_2 }}
	smooth_triangle { <211.3536, -1.4845, -2.9540>, <-0.391, 0.830, -0.398>, <210.3121, -0.5285, 9.0844>, <-0.396, 0.911, -0.111>, <203.4686, -4.5595, -2.9540>, <-0.301, 0.865, -0.402> texture { ICP35_black_2 }}
	smooth_triangle { <218.0111, 3.6958, 8.7739>, <-0.560, 0.809, -0.178>, <210.3121, -0.5285, 9.0844>, <-0.396, 0.911, -0.111>, <211.3536, -1.4845, -2.9540>, <-0.391, 0.830, -0.398> texture { ICP35_black_2 }}
	smooth_triangle { <218.0111, 3.6958, 8.7739>, <0.524, -0.834, 0.175>, <210.3121, -0.5285, 9.0844>, <0.416, -0.850, 0.322>, <216.1831, 7.3193, 21.0004>, <0.511, -0.776, 0.370> texture { ICP35_black_2 }}
	smooth_triangle { <193.4836, 7.5473, 34.3444>, <-0.160, 0.822, -0.547>, <187.1986, -0.9690, 22.1859>, <-0.004, 0.869, -0.495>, <199.5916, 0.3148, 21.6938>, <-0.168, 0.863, -0.476> texture { ICP35_black_2 }}
	smooth_triangle { <193.4836, 7.5473, 34.3444>, <0.033, -0.712, 0.702>, <187.1986, -0.9690, 22.1859>, <-0.004, -0.914, 0.405>, <187.1986, 17.7398, 44.3644>, <-0.070, -0.700, 0.710> texture { ICP35_black_2 }}
	smooth_triangle { <193.2521, -5.3440, 9.0154>, <-0.061, 0.972, -0.229>, <187.1986, -0.9690, 22.1859>, <-0.004, 0.869, -0.495>, <187.1986, -7.0000, -2.9540>, <0.127, 0.880, -0.458> texture { ICP35_black_2 }}
	smooth_triangle { <193.2521, -5.3440, 9.0154>, <0.092, -0.968, 0.232>, <187.1986, -0.9690, 22.1859>, <-0.004, -0.914, 0.405>, <199.5916, 0.3148, 21.6938>, <0.234, -0.881, 0.411> texture { ICP35_black_2 }}
	smooth_triangle { <205.2216, 9.6743, 32.9549>, <0.259, -0.715, 0.650>, <198.8911, 18.5548, 43.5414>, <0.198, -0.667, 0.718>, <209.3986, 20.7683, 41.3084>, <0.286, -0.643, 0.710> texture { ICP35_black_2 }}
	smooth_triangle { <198.8911, 18.5548, 43.5414>, <0.198, -0.667, 0.718>, <193.4836, 7.5473, 34.3444>, <0.033, -0.712, 0.702>, <187.1986, 17.7398, 44.3644>, <-0.070, -0.700, 0.710> texture { ICP35_black_2 }}
	smooth_triangle { <205.2216, 9.6743, 32.9549>, <0.259, -0.715, 0.650>, <193.4836, 7.5473, 34.3444>, <0.033, -0.712, 0.702>, <198.8911, 18.5548, 43.5414>, <0.198, -0.667, 0.718> texture { ICP35_black_2 }}
	smooth_triangle { <205.2216, 9.6743, 32.9549>, <-0.324, 0.738, -0.593>, <193.4836, 7.5473, 34.3444>, <-0.160, 0.822, -0.547>, <199.5916, 0.3148, 21.6938>, <-0.168, 0.863, -0.476> texture { ICP35_black_2 }}
	smooth_triangle { <204.5481, -9.1715, -8.3870>, <0.221, -0.721, 0.656>, <211.3536, -1.4845, -2.9540>, <0.402, -0.825, 0.398>, <212.9586, -5.8915, -8.3870>, <0.326, -0.685, 0.652> texture { ICP35_black_2 }}
	smooth_triangle { <204.5481, -9.1715, -8.3870>, <-0.275, 0.705, -0.653>, <211.3536, -1.4845, -2.9540>, <-0.391, 0.830, -0.398>, <203.4686, -4.5595, -2.9540>, <-0.301, 0.865, -0.402> texture { ICP35_black_2 }}
	smooth_triangle { <212.9586, -5.8915, -8.3870>, <0.326, -0.685, 0.652>, <218.5656, 2.5968, -2.9540>, <0.507, -0.768, 0.393>, <220.6516, -1.5380, -8.3870>, <0.375, -0.663, 0.648> texture { ICP35_black_2 }}
	smooth_triangle { <212.9586, -5.8915, -8.3870>, <-0.375, 0.663, -0.648>, <218.5656, 2.5968, -2.9540>, <-0.421, 0.637, -0.646>, <211.3536, -1.4845, -2.9540>, <-0.391, 0.830, -0.398> texture { ICP35_black_2 }}
	smooth_triangle { <195.2961, -6.4085, -2.9540>, <-0.144, 0.855, -0.499>, <187.1986, -11.7745, -8.3870>, <0.019, 0.751, -0.660>, <195.8311, -11.1435, -8.3870>, <-0.111, 0.744, -0.659> texture { ICP35_black_2 }}
	smooth_triangle { <195.2961, -6.4085, -2.9540>, <0.121, -0.946, 0.301>, <187.1986, -11.7745, -8.3870>, <0.055, -0.750, 0.659>, <187.1986, -7.0000, -2.9540>, <0.064, -0.957, 0.283> texture { ICP35_black_2 }}
	smooth_triangle { <195.8311, -11.1435, -8.3870>, <0.166, -0.735, 0.657>, <203.4686, -4.5595, -2.9540>, <0.202, -0.894, 0.399>, <204.5481, -9.1715, -8.3870>, <0.221, -0.721, 0.656> texture { ICP35_black_2 }}
	smooth_triangle { <195.8311, -11.1435, -8.3870>, <-0.111, 0.744, -0.659>, <203.4686, -4.5595, -2.9540>, <-0.301, 0.865, -0.402>, <195.2961, -6.4085, -2.9540>, <-0.144, 0.855, -0.499> texture { ICP35_black_2 }}
	smooth_triangle { <234.4801, 10.6053, -8.3870>, <-0.583, 0.510, -0.633>, <225.2601, 7.7033, -2.9540>, <-0.604, 0.695, -0.389>, <227.7921, 3.9088, -8.3870>, <-0.506, 0.578, -0.640> texture { ICP35_black_2 }}
	smooth_triangle { <234.4801, 10.6053, -8.3870>, <0.546, -0.546, 0.636>, <225.2601, 7.7033, -2.9540>, <0.607, -0.694, 0.388>, <231.5301, 13.9813, -2.9540>, <0.648, -0.597, 0.473> texture { ICP35_black_2 }}
	smooth_triangle { <227.7921, 3.9088, -8.3870>, <-0.506, 0.578, -0.640>, <218.5656, 2.5968, -2.9540>, <-0.421, 0.637, -0.646>, <220.6516, -1.5380, -8.3870>, <-0.465, 0.609, -0.642> texture { ICP35_black_2 }}
	smooth_triangle { <227.7921, 3.9088, -8.3870>, <0.465, -0.609, 0.642>, <218.5656, 2.5968, -2.9540>, <0.507, -0.768, 0.393>, <225.2601, 7.7033, -2.9540>, <0.607, -0.694, 0.388> texture { ICP35_black_2 }}
	smooth_triangle { <245.0911, 26.4313, -8.3870>, <-0.676, 0.394, -0.623>, <237.0156, 21.1568, -2.9540>, <-0.786, 0.548, -0.287>, <240.3311, 18.2593, -8.3870>, <-0.648, 0.434, -0.627> texture { ICP35_black_2 }}
	smooth_triangle { <245.0911, 26.4313, -8.3870>, <0.676, -0.394, 0.623>, <237.0156, 21.1568, -2.9540>, <0.747, -0.474, 0.466>, <241.4781, 28.8183, -2.9540>, <0.802, -0.467, 0.373> texture { ICP35_black_2 }}
	smooth_triangle { <240.3311, 18.2593, -8.3870>, <-0.648, 0.434, -0.627>, <231.5301, 13.9813, -2.9540>, <-0.736, 0.612, -0.290>, <234.4801, 10.6053, -8.3870>, <-0.583, 0.510, -0.633> texture { ICP35_black_2 }}
	smooth_triangle { <240.3311, 18.2593, -8.3870>, <0.618, -0.472, 0.629>, <231.5301, 13.9813, -2.9540>, <0.648, -0.597, 0.473>, <237.0156, 21.1568, -2.9540>, <0.747, -0.474, 0.466> texture { ICP35_black_2 }}
	smooth_triangle { <229.7796, 24.1104, 15.6909>, <-0.470, -0.743, -0.476>, <237.2321, 23.7148, 9.0154>, <-0.467, -0.744, -0.477>, <237.2321, 27.5638, 3.0124>, <-0.467, -0.744, -0.477> texture { ICP35_black_2 }}
	smooth_triangle { <229.7796, 24.1104, 15.6909>, <0.467, 0.744, 0.477>, <237.2321, 23.7148, 9.0154>, <0.467, 0.744, 0.477>, <229.7796, 20.2614, 21.6938>, <0.470, 0.743, 0.476> texture { ICP35_black_2 }}
	smooth_triangle { <209.3986, 24.6173, 35.3054>, <-0.216, -0.822, -0.527>, <219.8816, 19.3608, 32.9549>, <-0.477, -0.740, -0.474>, <219.8816, 23.2098, 26.9519>, <-0.475, -0.741, -0.475> texture { ICP35_black_2 }}
	smooth_triangle { <209.3986, 24.6173, 35.3054>, <0.477, 0.740, 0.474>, <219.8816, 19.3608, 32.9549>, <0.475, 0.741, 0.475>, <209.3986, 20.7683, 41.3084>, <0.216, 0.822, 0.527> texture { ICP35_black_2 }}
	smooth_triangle { <219.8816, 23.2098, 26.9519>, <-0.475, -0.741, -0.475>, <229.7796, 20.2614, 21.6938>, <-0.473, -0.741, -0.475>, <229.7796, 24.1104, 15.6909>, <-0.470, -0.743, -0.476> texture { ICP35_black_2 }}
	smooth_triangle { <219.8816, 23.2098, 26.9519>, <0.473, 0.741, 0.475>, <229.7796, 20.2614, 21.6938>, <0.470, 0.743, 0.476>, <219.8816, 19.3608, 32.9549>, <0.475, 0.741, 0.475> texture { ICP35_black_2 }}
	smooth_triangle { <187.1986, 21.5888, 38.3614>, <0.000, -0.842, -0.540>, <198.8911, 18.5548, 43.5414>, <0.021, -0.842, -0.540>, <198.8911, 22.4038, 37.5384>, <0.042, -0.841, -0.539> texture { ICP35_black_2 }}
	smooth_triangle { <187.1986, 21.5888, 38.3614>, <0.000, 0.842, 0.540>, <198.8911, 18.5548, 43.5414>, <-0.042, 0.841, 0.539>, <187.1986, 17.7398, 44.3644>, <-0.021, 0.842, 0.540> texture { ICP35_black_2 }}
	smooth_triangle { <198.8911, 22.4038, 37.5384>, <0.042, -0.841, -0.539>, <209.3986, 20.7683, 41.3084>, <0.063, -0.840, -0.539>, <209.3986, 24.6173, 35.3054>, <-0.216, -0.822, -0.527> texture { ICP35_black_2 }}
	smooth_triangle { <198.8911, 22.4038, 37.5384>, <-0.063, 0.840, 0.539>, <209.3986, 20.7683, 41.3084>, <0.216, 0.822, 0.527>, <198.8911, 18.5548, 43.5414>, <-0.042, 0.841, 0.539> texture { ICP35_black_2 }}
	smooth_triangle { <175.5751, 22.4038, 37.5384>, <0.042, 0.841, 0.539>, <165.0676, 20.7683, 41.3084>, <0.063, 0.840, 0.539>, <165.0676, 24.6173, 35.3054>, <-0.216, 0.822, 0.527> texture { ICP35_black_2 }}
	smooth_triangle { <175.5751, 22.4038, 37.5384>, <-0.063, -0.840, -0.539>, <165.0676, 20.7683, 41.3084>, <0.216, -0.822, -0.527>, <175.5751, 18.5548, 43.5414>, <-0.042, -0.841, -0.539> texture { ICP35_black_2 }}
	smooth_triangle { <187.1986, 21.5888, 38.3614>, <0.000, 0.842, 0.540>, <175.5751, 18.5548, 43.5414>, <0.021, 0.842, 0.540>, <175.5751, 22.4038, 37.5384>, <0.042, 0.841, 0.539> texture { ICP35_black_2 }}
	smooth_triangle { <187.1986, 21.5888, 38.3614>, <0.000, -0.842, -0.540>, <175.5751, 18.5548, 43.5414>, <-0.042, -0.841, -0.539>, <187.1986, 17.7398, 44.3644>, <-0.021, -0.842, -0.540> texture { ICP35_black_2 }}
	smooth_triangle { <154.5846, 23.2098, 26.9519>, <-0.475, 0.741, 0.475>, <144.6866, 20.2614, 21.6938>, <-0.473, 0.741, 0.475>, <144.6866, 24.1104, 15.6909>, <-0.470, 0.743, 0.476> texture { ICP35_black_2 }}
	smooth_triangle { <154.5846, 23.2098, 26.9519>, <0.473, -0.741, -0.475>, <144.6866, 20.2614, 21.6938>, <0.470, -0.743, -0.476>, <154.5846, 19.3608, 32.9549>, <0.475, -0.741, -0.475> texture { ICP35_black_2 }}
	smooth_triangle { <165.0676, 24.6173, 35.3054>, <-0.216, 0.822, 0.527>, <154.5846, 19.3608, 32.9549>, <-0.477, 0.740, 0.474>, <154.5846, 23.2098, 26.9519>, <-0.475, 0.741, 0.475> texture { ICP35_black_2 }}
	smooth_triangle { <165.0676, 24.6173, 35.3054>, <0.477, -0.740, -0.474>, <154.5846, 19.3608, 32.9549>, <0.475, -0.741, -0.475>, <165.0676, 20.7683, 41.3084>, <0.216, -0.822, -0.527> texture { ICP35_black_2 }}
	smooth_triangle { <144.6866, 24.1104, 15.6909>, <-0.470, 0.743, 0.476>, <137.2341, 23.7148, 9.0154>, <-0.467, 0.744, 0.477>, <137.2341, 27.5638, 3.0124>, <-0.467, 0.744, 0.477> texture { ICP35_black_2 }}
	smooth_triangle { <144.6866, 24.1104, 15.6909>, <0.467, -0.744, -0.477>, <137.2341, 23.7148, 9.0154>, <0.467, -0.744, -0.477>, <144.6866, 20.2614, 21.6938>, <0.470, -0.743, -0.476> texture { ICP35_black_2 }}
	smooth_triangle { <199.4811, 21.2828, 30.0259>, <0.004, -0.967, 0.254>, <209.9881, 23.2493, 40.7999>, <0.352, -0.664, 0.659>, <209.9881, 19.8313, 27.7929>, <0.154, -0.956, 0.251> texture { ICP35_black_2 }}
	smooth_triangle { <199.4811, 21.2828, 30.0259>, <0.079, 0.964, -0.253>, <209.9881, 23.2493, 40.7999>, <-0.154, 0.854, -0.498>, <199.4811, 24.7008, 43.0329>, <-0.062, 0.799, -0.598> texture { ICP35_black_2 }}
	smooth_triangle { <188.2661, 20.4858, 30.8489>, <0.043, -0.966, 0.254>, <199.4811, 24.7008, 43.0329>, <0.153, -0.791, 0.592>, <199.4811, 21.2828, 30.0259>, <0.004, -0.967, 0.254> texture { ICP35_black_2 }}
	smooth_triangle { <188.2661, 20.4858, 30.8489>, <-0.043, 0.966, -0.254>, <199.4811, 24.7008, 43.0329>, <-0.062, 0.799, -0.598>, <188.2661, 23.9038, 43.8559>, <-0.100, 0.808, -0.580> texture { ICP35_black_2 }}
	smooth_triangle { <220.4726, 22.0878, 19.4394>, <0.366, -0.900, 0.236>, <230.3726, 26.4058, 21.1854>, <0.656, -0.657, 0.373>, <230.3726, 22.9879, 8.1783>, <0.515, -0.829, 0.218> texture { ICP35_black_2 }}
	smooth_triangle { <220.4726, 22.0878, 19.4394>, <-0.353, 0.905, -0.238>, <230.3726, 26.4058, 21.1854>, <-0.576, 0.747, -0.332>, <220.4726, 25.5058, 32.4464>, <-0.510, 0.738, -0.441> texture { ICP35_black_2 }}
	smooth_triangle { <209.9881, 19.8313, 27.7929>, <0.154, -0.956, 0.251>, <220.4726, 25.5058, 32.4464>, <0.527, -0.708, 0.470>, <220.4726, 22.0878, 19.4394>, <0.366, -0.900, 0.236> texture { ICP35_black_2 }}
	smooth_triangle { <209.9881, 19.8313, 27.7929>, <-0.380, 0.895, -0.235>, <220.4726, 25.5058, 32.4464>, <-0.510, 0.738, -0.441>, <209.9881, 23.2493, 40.7999>, <-0.154, 0.854, -0.498> texture { ICP35_black_2 }}
	smooth_triangle { <230.3726, 22.9879, 8.1783>, <0.515, -0.829, 0.218>, <237.8231, 29.8604, 8.5069>, <0.781, -0.561, 0.273>, <237.8231, 26.4423, -4.5000>, <0.661, -0.726, 0.191> texture { ICP35_black_2 }}
	smooth_triangle { <230.3726, 22.9879, 8.1783>, <-0.661, 0.726, -0.191>, <237.8231, 29.8604, 8.5069>, <-0.787, 0.596, -0.160>, <230.3726, 26.4058, 21.1854>, <-0.576, 0.747, -0.332> texture { ICP35_black_2 }}
	smooth_triangle { <145.6951, 19.2908, 8.1783>, <0.452, 0.863, -0.227>, <137.9726, 25.5009, 8.5069>, <0.767, 0.607, -0.207>, <137.9726, 22.0828, -4.5000>, <0.609, 0.767, -0.202> texture { ICP35_black_2 }}
	smooth_triangle { <145.6951, 19.2908, 8.1783>, <-0.609, -0.767, 0.202>, <137.9726, 25.5009, 8.5069>, <-0.686, -0.676, 0.269>, <145.6951, 22.7088, 21.1854>, <-0.602, -0.726, 0.331> texture { ICP35_black_2 }}
	smooth_triangle { <166.2796, 17.9248, 27.7929>, <0.073, 0.965, -0.253>, <155.6381, 22.6773, 32.4464>, <0.495, 0.708, -0.504>, <155.6381, 19.2593, 19.4394>, <0.292, 0.925, -0.243> texture { ICP35_black_2 }}
	smooth_triangle { <166.2796, 17.9248, 27.7929>, <-0.305, -0.921, 0.242>, <155.6381, 22.6773, 32.4464>, <-0.407, -0.822, 0.399>, <166.2796, 21.3428, 40.7999>, <-0.303, -0.773, 0.557> texture { ICP35_black_2 }}
	smooth_triangle { <155.6381, 19.2593, 19.4394>, <0.292, 0.925, -0.243>, <145.6951, 22.7088, 21.1854>, <0.461, 0.790, -0.405>, <145.6951, 19.2908, 8.1783>, <0.452, 0.863, -0.227> texture { ICP35_black_2 }}
	smooth_triangle { <155.6381, 19.2593, 19.4394>, <-0.279, -0.929, 0.244>, <145.6951, 22.7088, 21.1854>, <-0.602, -0.726, 0.331>, <155.6381, 22.6773, 32.4464>, <-0.407, -0.822, 0.399> texture { ICP35_black_2 }}
	smooth_triangle { <188.2661, 20.4858, 30.8489>, <-0.043, 0.966, -0.254>, <176.6191, 23.7014, 43.0329>, <0.083, 0.704, -0.705>, <176.6191, 20.2833, 30.0259>, <-0.081, 0.964, -0.253> texture { ICP35_black_2 }}
	smooth_triangle { <188.2661, 20.4858, 30.8489>, <0.043, -0.966, 0.254>, <176.6191, 23.7014, 43.0329>, <0.040, -0.879, 0.474>, <188.2661, 23.9038, 43.8559>, <0.000, -0.648, 0.762> texture { ICP35_black_2 }}
	smooth_triangle { <176.6191, 20.2833, 30.0259>, <-0.081, 0.964, -0.253>, <166.2796, 21.3428, 40.7999>, <-0.047, 0.787, -0.615>, <166.2796, 17.9248, 27.7929>, <0.073, 0.965, -0.253> texture { ICP35_black_2 }}
	smooth_triangle { <176.6191, 20.2833, 30.0259>, <0.163, -0.954, 0.251>, <166.2796, 21.3428, 40.7999>, <-0.303, -0.773, 0.557>, <176.6191, 23.7014, 43.0329>, <0.040, -0.879, 0.474> texture { ICP35_black_2 }}
	smooth_triangle { <210.8076, -9.2960, -3.7510>, <0.428, 0.188, -0.884>, <217.1196, -8.6635, 0.4524>, <0.665, -0.479, -0.572>, <215.1411, -6.9850, -0.7985>, <0.451, 0.397, -0.800> texture { ICP35_black_2 }}
	smooth_triangle { <210.8076, -9.2960, -3.7510>, <-0.223, 0.820, 0.527>, <217.1196, -8.6635, 0.4524>, <-0.631, 0.182, 0.754>, <211.8251, -10.7135, -1.7550>, <-0.219, 0.856, 0.468> texture { ICP35_black_2 }}
	smooth_triangle { <210.8076, -9.2960, -3.7510>, <-0.223, 0.820, 0.527>, <211.8251, -10.7135, -1.7550>, <-0.219, 0.856, 0.468>, <204.0581, -10.7070, -1.9210>, <-0.148, 0.874, 0.463> texture { ICP35_black_2 }}
	smooth_triangle { <217.1196, -8.6635, 0.4524>, <0.665, -0.479, -0.572>, <211.8251, -10.7135, -1.7550>, <0.274, -0.904, -0.328>, <216.6336, -9.8990, 2.1414>, <0.527, -0.804, -0.277> texture { ICP35_black_2 }}
	smooth_triangle { <207.2066, -7.3945, -4.6285>, <0.277, 0.408, -0.870>, <202.0096, -5.5295, -4.1470>, <0.118, 0.778, -0.618>, <197.2096, -7.6580, -7.0875>, <0.146, 0.519, -0.842> texture { ICP35_black_2 }}
	smooth_triangle { <207.2066, -7.3945, -4.6285>, <-0.254, -0.690, 0.678>, <202.0096, -5.5295, -4.1470>, <-0.155, -0.758, 0.634>, <210.5751, -5.2080, -1.1420>, <-0.217, -0.768, 0.603> texture { ICP35_black_2 }}
	smooth_triangle { <207.2066, -7.3945, -4.6285>, <-0.254, -0.690, 0.678>, <210.5751, -5.2080, -1.1420>, <-0.217, -0.768, 0.603>, <215.1411, -6.9850, -0.7985>, <-0.497, -0.528, 0.688> texture { ICP35_black_2 }}
	smooth_triangle { <210.5751, -5.2080, -1.1420>, <-0.217, -0.768, 0.603>, <202.0096, -5.5295, -4.1470>, <-0.155, -0.758, 0.634>, <204.9816, -3.7450, -0.6980>, <-0.177, -0.836, 0.520> texture { ICP35_black_2 }}
	smooth_triangle { <201.3796, -9.6500, -7.0580>, <-0.162, 0.665, 0.729>, <210.8076, -9.2960, -3.7510>, <-0.223, 0.820, 0.527>, <204.0581, -10.7070, -1.9210>, <-0.148, 0.874, 0.463> texture { ICP35_black_2 }}
	smooth_triangle { <201.3796, -9.6500, -7.0580>, <0.266, 0.300, -0.916>, <210.8076, -9.2960, -3.7510>, <0.428, 0.188, -0.884>, <207.2066, -7.3945, -4.6285>, <0.277, 0.408, -0.870> texture { ICP35_black_2 }}
	smooth_triangle { <201.3796, -9.6500, -7.0580>, <0.266, 0.300, -0.916>, <207.2066, -7.3945, -4.6285>, <0.277, 0.408, -0.870>, <197.2096, -7.6580, -7.0875>, <0.146, 0.519, -0.842> texture { ICP35_black_2 }}
	smooth_triangle { <207.2066, -7.3945, -4.6285>, <0.277, 0.408, -0.870>, <210.8076, -9.2960, -3.7510>, <0.428, 0.188, -0.884>, <215.1411, -6.9850, -0.7985>, <0.451, 0.397, -0.800> texture { ICP35_black_2 }}
	smooth_triangle { <201.3796, -9.6500, -7.0580>, <0.266, -0.907, -0.325>, <194.6931, -11.3570, -7.7645>, <0.139, -0.677, -0.723>, <204.0581, -10.7070, -1.9210>, <0.326, -0.865, -0.381> texture { ICP35_black_2 }}
	smooth_triangle { <201.3796, -9.6500, -7.0580>, <-0.176, 0.354, 0.919>, <194.6931, -11.3570, -7.7645>, <-0.230, 0.599, 0.767>, <191.4206, -9.6290, -8.5620>, <-0.099, -0.038, 0.994> texture { ICP35_black_2 }}
	smooth_triangle { <201.3796, -9.6500, -7.0580>, <-0.149, -0.059, 0.987>, <191.4206, -9.6290, -8.5620>, <-0.099, -0.038, 0.994>, <197.2096, -7.6580, -7.0875>, <-0.099, -0.575, 0.812> texture { ICP35_black_2 }}
	smooth_triangle { <194.6931, -11.3570, -7.7645>, <0.139, -0.677, -0.723>, <191.4206, -9.6290, -8.5620>, <0.050, 0.175, -0.983>, <186.1276, -11.0440, -8.5590>, <0.000, -0.501, -0.866> texture { ICP35_black_2 }}
	smooth_triangle { <180.3016, -5.4930, -5.5065>, <0.012, -0.803, 0.596>, <175.5391, -3.4800, -1.9400>, <0.079, -0.863, 0.499>, <186.1276, -3.3670, -2.4675>, <0.001, -0.872, 0.490> texture { ICP35_black_2 }}
	smooth_triangle { <180.3016, -5.4930, -5.5065>, <-0.076, 0.741, -0.667>, <175.5391, -3.4800, -1.9400>, <-0.059, 0.878, -0.476>, <170.2446, -5.5295, -4.1470>, <-0.114, 0.787, -0.606> texture { ICP35_black_2 }}
	smooth_triangle { <180.3016, -5.4930, -5.5065>, <-0.076, 0.741, -0.667>, <170.2446, -5.5295, -4.1470>, <-0.114, 0.787, -0.606>, <175.0456, -7.6580, -7.0875>, <-0.099, 0.575, -0.812> texture { ICP35_black_2 }}
	smooth_triangle { <175.5391, -3.4800, -1.9400>, <0.079, -0.863, 0.499>, <170.2446, -5.5295, -4.1470>, <0.159, -0.747, 0.645>, <167.2726, -3.7450, -0.6980>, <0.101, -0.869, 0.484> texture { ICP35_black_2 }}
	smooth_triangle { <191.9526, -5.4930, -5.5065>, <-0.037, -0.740, 0.672>, <202.0096, -5.5295, -4.1470>, <-0.155, -0.758, 0.634>, <197.2096, -7.6580, -7.0875>, <-0.099, -0.575, 0.812> texture { ICP35_black_2 }}
	smooth_triangle { <191.9526, -5.4930, -5.5065>, <0.058, 0.835, -0.548>, <202.0096, -5.5295, -4.1470>, <0.118, 0.778, -0.618>, <196.7151, -3.4800, -1.9400>, <0.076, 0.865, -0.496> texture { ICP35_black_2 }}
	smooth_triangle { <191.9526, -5.4930, -5.5065>, <0.058, 0.835, -0.548>, <196.7151, -3.4800, -1.9400>, <0.076, 0.865, -0.496>, <186.1276, -3.3670, -2.4675>, <0.002, 0.874, -0.486> texture { ICP35_black_2 }}
	smooth_triangle { <196.7151, -3.4800, -1.9400>, <0.076, 0.865, -0.496>, <202.0096, -5.5295, -4.1470>, <0.118, 0.778, -0.618>, <204.9816, -3.7450, -0.6980>, <0.113, 0.881, -0.459> texture { ICP35_black_2 }}
	smooth_triangle { <186.1276, -7.7490, -7.9350>, <0.004, 0.493, -0.870>, <180.3016, -5.4930, -5.5065>, <-0.076, 0.741, -0.667>, <175.0456, -7.6580, -7.0875>, <-0.099, 0.575, -0.812> texture { ICP35_black_2 }}
	smooth_triangle { <186.1276, -7.7490, -7.9350>, <0.004, -0.631, 0.776>, <180.3016, -5.4930, -5.5065>, <0.012, -0.803, 0.596>, <191.9526, -5.4930, -5.5065>, <-0.037, -0.740, 0.672> texture { ICP35_black_2 }}
	smooth_triangle { <186.1276, -7.7490, -7.9350>, <0.004, -0.631, 0.776>, <191.9526, -5.4930, -5.5065>, <-0.037, -0.740, 0.672>, <197.2096, -7.6580, -7.0875>, <-0.099, -0.575, 0.812> texture { ICP35_black_2 }}
	smooth_triangle { <191.9526, -5.4930, -5.5065>, <-0.037, -0.740, 0.672>, <180.3016, -5.4930, -5.5065>, <0.012, -0.803, 0.596>, <186.1276, -3.3670, -2.4675>, <0.001, -0.872, 0.490> texture { ICP35_black_2 }}
	smooth_triangle { <186.1276, -7.7490, -7.9350>, <0.004, -0.631, 0.776>, <180.8336, -9.6290, -8.5620>, <0.073, -0.104, 0.992>, <175.0456, -7.6580, -7.0875>, <0.146, -0.519, 0.842> texture { ICP35_black_2 }}
	smooth_triangle { <186.1276, -7.7490, -7.9350>, <0.004, 0.493, -0.870>, <180.8336, -9.6290, -8.5620>, <-0.077, 0.108, -0.991>, <191.4206, -9.6290, -8.5620>, <0.050, 0.175, -0.983> texture { ICP35_black_2 }}
	smooth_triangle { <186.1276, -7.7490, -7.9350>, <0.004, 0.493, -0.870>, <191.4206, -9.6290, -8.5620>, <0.050, 0.175, -0.983>, <197.2096, -7.6580, -7.0875>, <0.146, 0.519, -0.842> texture { ICP35_black_2 }}
	smooth_triangle { <180.8336, -9.6290, -8.5620>, <0.073, -0.104, 0.992>, <191.4206, -9.6290, -8.5620>, <-0.099, -0.038, 0.994>, <186.1276, -11.0440, -8.5590>, <0.000, 0.002, 1.000> texture { ICP35_black_2 }}
	smooth_triangle { <195.5531, -13.5485, -1.7895>, <0.210, -0.973, -0.091>, <194.6911, -13.5965, 2.7284>, <0.093, -0.992, 0.086>, <204.0571, -11.9575, 3.9354>, <0.107, -0.994, 0.022> texture { ICP35_black_2 }}
	smooth_triangle { <195.5531, -13.5485, -1.7895>, <-0.083, 0.992, 0.090>, <194.6911, -13.5965, 2.7284>, <-0.080, 0.993, -0.092>, <186.1271, -13.9175, -0.2765>, <-0.001, 1.000, 0.013> texture { ICP35_black_2 }}
	smooth_triangle { <195.5531, -13.5485, -1.7895>, <-0.083, 0.992, 0.090>, <186.1271, -13.9175, -0.2765>, <-0.001, 1.000, 0.013>, <186.1271, -13.5115, -4.3870>, <-0.015, 0.975, 0.221> texture { ICP35_black_2 }}
	smooth_triangle { <194.6911, -13.5965, 2.7284>, <0.093, -0.992, 0.086>, <186.1271, -13.9175, -0.2765>, <-0.002, -1.000, -0.024>, <186.1276, -13.7030, 3.8964>, <0.016, -0.993, 0.115> texture { ICP35_black_2 }}
	smooth_triangle { <211.8251, -10.7135, -1.7550>, <-0.219, 0.856, 0.468>, <204.9801, -11.5860, 0.5483>, <-0.113, 0.974, 0.196>, <204.0581, -10.7070, -1.9210>, <-0.148, 0.874, 0.463> texture { ICP35_black_2 }}
	smooth_triangle { <211.8251, -10.7135, -1.7550>, <0.274, -0.904, -0.328>, <204.9801, -11.5860, 0.5483>, <0.184, -0.953, -0.241>, <211.8246, -11.4595, 1.7423>, <0.102, -0.993, -0.059> texture { ICP35_black_2 }}
	smooth_triangle { <211.8246, -11.4595, 1.7423>, <0.102, -0.993, -0.059>, <204.9801, -11.5860, 0.5483>, <0.184, -0.953, -0.241>, <204.0571, -11.9575, 3.9354>, <0.107, -0.994, 0.022> texture { ICP35_black_2 }}
	smooth_triangle { <211.8246, -11.4595, 1.7423>, <-0.315, 0.942, 0.115>, <211.8251, -10.7135, -1.7550>, <-0.219, 0.856, 0.468>, <216.6336, -9.8990, 2.1414>, <-0.315, 0.942, 0.115> texture { ICP35_black_2 }}
	smooth_triangle { <195.5541, -12.7270, -5.6380>, <-0.190, 0.858, 0.477>, <195.5531, -13.5485, -1.7895>, <-0.083, 0.992, 0.090>, <186.1271, -13.5115, -4.3870>, <-0.015, 0.975, 0.221> texture { ICP35_black_2 }}
	smooth_triangle { <195.5541, -12.7270, -5.6380>, <0.224, -0.915, -0.335>, <195.5531, -13.5485, -1.7895>, <0.210, -0.973, -0.091>, <204.9801, -11.5860, 0.5483>, <0.184, -0.953, -0.241> texture { ICP35_black_2 }}
	smooth_triangle { <195.5541, -12.7270, -5.6380>, <0.224, -0.915, -0.335>, <204.9801, -11.5860, 0.5483>, <0.184, -0.953, -0.241>, <204.0581, -10.7070, -1.9210>, <0.326, -0.865, -0.381> texture { ICP35_black_2 }}
	smooth_triangle { <195.5531, -13.5485, -1.7895>, <-0.083, 0.992, 0.090>, <204.9801, -11.5860, 0.5483>, <-0.113, 0.974, 0.196>, <204.0571, -11.9575, 3.9354>, <-0.133, 0.991, -0.014> texture { ICP35_black_2 }}
	smooth_triangle { <195.5541, -12.7270, -5.6380>, <0.224, -0.915, -0.335>, <186.1271, -12.4250, -7.2715>, <0.011, -0.785, -0.620>, <186.1271, -13.5115, -4.3870>, <-0.015, -0.975, -0.221> texture { ICP35_black_2 }}
	smooth_triangle { <195.5541, -12.7270, -5.6380>, <-0.190, 0.858, 0.477>, <186.1271, -12.4250, -7.2715>, <0.010, 0.869, 0.495>, <194.6931, -11.3570, -7.7645>, <-0.230, 0.599, 0.767> texture { ICP35_black_2 }}
	smooth_triangle { <195.5541, -12.7270, -5.6380>, <-0.190, 0.858, 0.477>, <194.6931, -11.3570, -7.7645>, <-0.230, 0.599, 0.767>, <204.0581, -10.7070, -1.9210>, <-0.148, 0.874, 0.463> texture { ICP35_black_2 }}
	smooth_triangle { <186.1271, -12.4250, -7.2715>, <0.011, -0.785, -0.620>, <194.6931, -11.3570, -7.7645>, <0.139, -0.677, -0.723>, <186.1276, -11.0440, -8.5590>, <0.000, -0.501, -0.866> texture { ICP35_black_2 }}
	smooth_triangle { <160.4301, -11.4595, 1.7423>, <0.052, 0.998, 0.041>, <167.2731, -11.5860, 0.5483>, <0.217, 0.936, 0.276>, <168.1966, -11.9575, 3.9354>, <0.107, 0.994, -0.022> texture { ICP35_black_2 }}
	smooth_triangle { <160.4301, -11.4595, 1.7423>, <-0.234, -0.967, -0.096>, <167.2731, -11.5860, 0.5483>, <-0.132, -0.971, -0.201>, <160.4286, -10.7135, -1.7550>, <-0.100, -0.935, -0.339> texture { ICP35_black_2 }}
	smooth_triangle { <160.4286, -10.7135, -1.7550>, <-0.100, -0.935, -0.339>, <167.2731, -11.5860, 0.5483>, <-0.132, -0.971, -0.201>, <168.1966, -10.7070, -1.9210>, <-0.148, -0.874, -0.463> texture { ICP35_black_2 }}
	smooth_triangle { <160.4301, -11.4595, 1.7423>, <-0.234, -0.967, -0.096>, <160.4286, -10.7135, -1.7550>, <-0.100, -0.935, -0.339>, <155.6211, -9.8985, 2.1414>, <-0.364, -0.927, -0.093> texture { ICP35_black_2 }}
	smooth_triangle { <176.7006, -13.5485, -1.7895>, <-0.136, -0.981, -0.140>, <186.1271, -13.9175, -0.2765>, <-0.002, -1.000, -0.024>, <186.1271, -13.5115, -4.3870>, <-0.015, -0.975, -0.221> texture { ICP35_black_2 }}
	smooth_triangle { <176.7006, -13.5485, -1.7895>, <0.104, 0.994, -0.009>, <186.1271, -13.9175, -0.2765>, <-0.001, 1.000, 0.013>, <177.5616, -13.5965, 2.7284>, <0.089, 0.992, -0.088> texture { ICP35_black_2 }}
	smooth_triangle { <176.7006, -13.5485, -1.7895>, <0.104, 0.994, -0.009>, <177.5616, -13.5965, 2.7284>, <0.089, 0.992, -0.088>, <168.1966, -11.9575, 3.9354>, <0.107, 0.994, -0.022> texture { ICP35_black_2 }}
	smooth_triangle { <177.5616, -13.5965, 2.7284>, <0.089, 0.992, -0.088>, <186.1271, -13.9175, -0.2765>, <-0.001, 1.000, 0.013>, <186.1276, -13.7030, 3.8964>, <0.024, 0.996, -0.089> texture { ICP35_black_2 }}
	smooth_triangle { <176.7011, -12.7275, -5.6380>, <0.165, 0.874, 0.457>, <167.2731, -11.5860, 0.5483>, <0.217, 0.936, 0.276>, <168.1966, -10.7070, -1.9210>, <0.326, 0.865, 0.381> texture { ICP35_black_2 }}
	smooth_triangle { <176.7011, -12.7275, -5.6380>, <-0.252, -0.901, -0.353>, <167.2731, -11.5860, 0.5483>, <-0.132, -0.971, -0.201>, <176.7006, -13.5485, -1.7895>, <-0.136, -0.981, -0.140> texture { ICP35_black_2 }}
	smooth_triangle { <176.7011, -12.7275, -5.6380>, <-0.252, -0.901, -0.353>, <176.7006, -13.5485, -1.7895>, <-0.136, -0.981, -0.140>, <186.1271, -13.5115, -4.3870>, <-0.015, -0.975, -0.221> texture { ICP35_black_2 }}
	smooth_triangle { <176.7006, -13.5485, -1.7895>, <-0.136, -0.981, -0.140>, <167.2731, -11.5860, 0.5483>, <-0.132, -0.971, -0.201>, <168.1966, -11.9575, 3.9354>, <-0.132, -0.991, 0.014> texture { ICP35_black_2 }}
	smooth_triangle { <176.7011, -12.7275, -5.6380>, <-0.252, -0.901, -0.353>, <177.5621, -11.3570, -7.7645>, <-0.190, -0.573, -0.797>, <168.1966, -10.7070, -1.9210>, <-0.148, -0.874, -0.463> texture { ICP35_black_2 }}
	smooth_triangle { <176.7011, -12.7275, -5.6380>, <0.165, 0.874, 0.457>, <177.5621, -11.3570, -7.7645>, <0.179, 0.704, 0.687>, <186.1271, -12.4250, -7.2715>, <0.010, 0.869, 0.495> texture { ICP35_black_2 }}
	smooth_triangle { <176.7011, -12.7275, -5.6380>, <0.165, 0.874, 0.457>, <186.1271, -12.4250, -7.2715>, <0.010, 0.869, 0.495>, <186.1271, -13.5115, -4.3870>, <-0.015, 0.975, 0.221> texture { ICP35_black_2 }}
	smooth_triangle { <177.5621, -11.3570, -7.7645>, <-0.190, -0.573, -0.797>, <186.1271, -12.4250, -7.2715>, <0.011, -0.785, -0.620>, <186.1276, -11.0440, -8.5590>, <0.000, -0.501, -0.866> texture { ICP35_black_2 }}
	smooth_triangle { <165.0481, -7.3945, -4.6285>, <-0.347, 0.401, -0.848>, <161.6791, -5.2080, -1.1420>, <-0.227, 0.799, -0.557>, <157.1136, -6.9850, -0.7985>, <-0.464, 0.424, -0.778> texture { ICP35_black_2 }}
	smooth_triangle { <165.0481, -7.3945, -4.6285>, <0.194, -0.608, 0.770>, <161.6791, -5.2080, -1.1420>, <0.268, -0.739, 0.619>, <170.2446, -5.5295, -4.1470>, <0.159, -0.747, 0.645> texture { ICP35_black_2 }}
	smooth_triangle { <165.0481, -7.3945, -4.6285>, <0.194, -0.608, 0.770>, <170.2446, -5.5295, -4.1470>, <0.159, -0.747, 0.645>, <175.0456, -7.6580, -7.0875>, <0.146, -0.519, 0.842> texture { ICP35_black_2 }}
	smooth_triangle { <161.6791, -5.2080, -1.1420>, <-0.227, 0.799, -0.557>, <170.2446, -5.5295, -4.1470>, <-0.114, 0.787, -0.606>, <167.2726, -3.7450, -0.6980>, <-0.164, 0.860, -0.483> texture { ICP35_black_2 }}
	smooth_triangle { <161.4481, -9.2960, -3.7510>, <-0.189, -0.655, -0.731>, <160.4286, -10.7135, -1.7550>, <-0.100, -0.935, -0.339>, <168.1966, -10.7070, -1.9210>, <-0.148, -0.874, -0.463> texture { ICP35_black_2 }}
	smooth_triangle { <161.4481, -9.2960, -3.7510>, <0.551, 0.284, 0.785>, <160.4286, -10.7135, -1.7550>, <0.491, 0.677, 0.548>, <155.1356, -8.6635, 0.4524>, <0.577, 0.544, 0.609> texture { ICP35_black_2 }}
	smooth_triangle { <161.4481, -9.2960, -3.7510>, <0.551, 0.284, 0.785>, <155.1356, -8.6635, 0.4524>, <0.577, 0.544, 0.609>, <157.1136, -6.9850, -0.7985>, <0.488, -0.507, 0.711> texture { ICP35_black_2 }}
	smooth_triangle { <155.1356, -8.6635, 0.4524>, <0.577, 0.544, 0.609>, <160.4286, -10.7135, -1.7550>, <0.491, 0.677, 0.548>, <155.6211, -9.8985, 2.1414>, <0.549, 0.742, 0.385> texture { ICP35_black_2 }}
	smooth_triangle { <170.8746, -9.6500, -7.0580>, <0.185, -0.130, 0.974>, <165.0481, -7.3945, -4.6285>, <0.194, -0.608, 0.770>, <175.0456, -7.6580, -7.0875>, <0.146, -0.519, 0.842> texture { ICP35_black_2 }}
	smooth_triangle { <170.8746, -9.6500, -7.0580>, <-0.233, 0.233, -0.944>, <165.0481, -7.3945, -4.6285>, <-0.347, 0.401, -0.848>, <161.4481, -9.2960, -3.7510>, <-0.291, -0.115, -0.950> texture { ICP35_black_2 }}
	smooth_triangle { <170.8746, -9.6500, -7.0580>, <-0.128, -0.956, -0.264>, <161.4481, -9.2960, -3.7510>, <-0.071, -0.900, -0.431>, <168.1966, -10.7070, -1.9210>, <-0.148, -0.874, -0.463> texture { ICP35_black_2 }}
	smooth_triangle { <161.4481, -9.2960, -3.7510>, <-0.358, 0.265, -0.895>, <165.0481, -7.3945, -4.6285>, <-0.347, 0.401, -0.848>, <157.1136, -6.9850, -0.7985>, <-0.464, 0.424, -0.778> texture { ICP35_black_2 }}
	smooth_triangle { <170.8746, -9.6500, -7.0580>, <-0.233, 0.233, -0.944>, <180.8336, -9.6290, -8.5620>, <-0.077, 0.108, -0.991>, <175.0456, -7.6580, -7.0875>, <-0.099, 0.575, -0.812> texture { ICP35_black_2 }}
	smooth_triangle { <170.8746, -9.6500, -7.0580>, <0.262, 0.279, 0.924>, <180.8336, -9.6290, -8.5620>, <0.073, -0.104, 0.992>, <177.5621, -11.3570, -7.7645>, <0.179, 0.704, 0.687> texture { ICP35_black_2 }}
	smooth_triangle { <170.8746, -9.6500, -7.0580>, <0.237, 0.621, 0.747>, <177.5621, -11.3570, -7.7645>, <0.179, 0.704, 0.687>, <168.1966, -10.7070, -1.9210>, <0.326, 0.865, 0.381> texture { ICP35_black_2 }}
	smooth_triangle { <180.8336, -9.6290, -8.5620>, <-0.077, 0.108, -0.991>, <177.5621, -11.3570, -7.7645>, <-0.190, -0.573, -0.797>, <186.1276, -11.0440, -8.5590>, <0.000, -0.501, -0.866> texture { ICP35_black_2 }}
	smooth_triangle { <186.1276, 0.2598, 6.5384>, <-0.020, -0.954, 0.300>, <191.4206, 1.2858, 11.1649>, <-0.038, -0.984, 0.173>, <197.2086, -0.0415, 6.6773>, <-0.051, -0.956, 0.288> texture { ICP35_black_2 }}
	smooth_triangle { <186.1276, 0.2598, 6.5384>, <-0.020, 0.966, -0.258>, <191.4206, 1.2858, 11.1649>, <0.020, 0.980, -0.199>, <180.8341, 1.2863, 11.1643>, <-0.015, 0.982, -0.190> texture { ICP35_black_2 }}
	smooth_triangle { <186.1276, 0.2598, 6.5384>, <-0.020, 0.966, -0.258>, <180.8341, 1.2863, 11.1643>, <-0.015, 0.982, -0.190>, <175.0451, -0.0415, 6.6773>, <-0.051, 0.956, -0.288> texture { ICP35_black_2 }}
	smooth_triangle { <180.8341, 1.2863, 11.1643>, <-0.015, 0.982, -0.190>, <191.4206, 1.2858, 11.1649>, <0.020, 0.980, -0.199>, <186.1276, 1.9133, 14.8583>, <-0.016, 0.993, -0.115> texture { ICP35_black_2 }}
	smooth_triangle { <191.9531, -1.4885, 1.7303>, <-0.015, -0.926, 0.377>, <196.7151, -3.4800, -1.9400>, <-0.032, -0.895, 0.445>, <186.1276, -3.3670, -2.4675>, <0.001, -0.872, 0.490> texture { ICP35_black_2 }}
	smooth_triangle { <191.9531, -1.4885, 1.7303>, <0.063, 0.925, -0.375>, <196.7151, -3.4800, -1.9400>, <0.076, 0.865, -0.496>, <202.0096, -1.8910, 2.4289>, <0.089, 0.912, -0.399> texture { ICP35_black_2 }}
	smooth_triangle { <191.9531, -1.4885, 1.7303>, <0.063, 0.925, -0.375>, <202.0096, -1.8910, 2.4289>, <0.089, 0.912, -0.399>, <197.2086, -0.0415, 6.6773>, <0.072, 0.962, -0.263> texture { ICP35_black_2 }}
	smooth_triangle { <202.0096, -1.8910, 2.4289>, <0.089, 0.912, -0.399>, <196.7151, -3.4800, -1.9400>, <0.076, 0.865, -0.496>, <204.9816, -3.7450, -0.6980>, <0.113, 0.881, -0.459> texture { ICP35_black_2 }}
	smooth_triangle { <180.3011, -1.4885, 1.7303>, <-0.042, 0.920, -0.389>, <186.1276, 0.2598, 6.5384>, <-0.020, 0.966, -0.258>, <175.0451, -0.0415, 6.6773>, <-0.051, 0.956, -0.288> texture { ICP35_black_2 }}
	smooth_triangle { <180.3011, -1.4885, 1.7303>, <0.020, -0.931, 0.364>, <186.1276, 0.2598, 6.5384>, <-0.020, -0.954, 0.300>, <191.9531, -1.4885, 1.7303>, <-0.015, -0.926, 0.377> texture { ICP35_black_2 }}
	smooth_triangle { <180.3011, -1.4885, 1.7303>, <0.020, -0.931, 0.364>, <191.9531, -1.4885, 1.7303>, <-0.015, -0.926, 0.377>, <186.1276, -3.3670, -2.4675>, <0.001, -0.872, 0.490> texture { ICP35_black_2 }}
	smooth_triangle { <191.9531, -1.4885, 1.7303>, <-0.015, -0.926, 0.377>, <186.1276, 0.2598, 6.5384>, <-0.020, -0.954, 0.300>, <197.2086, -0.0415, 6.6773>, <-0.051, -0.956, 0.288> texture { ICP35_black_2 }}
	smooth_triangle { <180.3011, -1.4885, 1.7303>, <0.020, -0.931, 0.364>, <170.2451, -1.8910, 2.4289>, <0.097, -0.922, 0.376>, <175.0451, -0.0415, 6.6773>, <0.072, -0.962, 0.263> texture { ICP35_black_2 }}
	smooth_triangle { <180.3011, -1.4885, 1.7303>, <-0.042, 0.920, -0.389>, <170.2451, -1.8910, 2.4289>, <-0.099, 0.922, -0.374>, <175.5391, -3.4800, -1.9400>, <-0.059, 0.878, -0.476> texture { ICP35_black_2 }}
	smooth_triangle { <180.3011, -1.4885, 1.7303>, <-0.042, 0.920, -0.389>, <175.5391, -3.4800, -1.9400>, <-0.059, 0.878, -0.476>, <186.1276, -3.3670, -2.4675>, <0.002, 0.874, -0.486> texture { ICP35_black_2 }}
	smooth_triangle { <170.2451, -1.8910, 2.4289>, <0.097, -0.922, 0.376>, <175.5391, -3.4800, -1.9400>, <0.079, -0.863, 0.499>, <167.2726, -3.7450, -0.6980>, <0.101, -0.869, 0.484> texture { ICP35_black_2 }}
	smooth_triangle { <220.2356, -3.9930, 8.5009>, <-0.687, -0.674, 0.272>, <220.3916, -3.6470, 13.4398>, <-0.698, -0.682, -0.220>, <221.9901, -5.8950, 9.3778>, <-0.764, -0.616, 0.192> texture { ICP35_black_2 }}
	smooth_triangle { <220.2356, -3.9930, 8.5009>, <0.392, 0.897, -0.204>, <220.3916, -3.6470, 13.4398>, <0.809, 0.574, 0.124>, <217.1196, -1.9190, 12.6433>, <0.380, 0.921, -0.083> texture { ICP35_black_2 }}
	smooth_triangle { <220.2356, -3.9930, 8.5009>, <0.392, 0.897, -0.204>, <217.1196, -1.9190, 12.6433>, <0.380, 0.921, -0.083>, <215.1411, -2.2775, 7.7089>, <0.292, 0.914, -0.281> texture { ICP35_black_2 }}
	smooth_triangle { <220.3916, -3.6470, 13.4398>, <-0.698, -0.682, -0.220>, <217.1196, -1.9190, 12.6433>, <-0.318, -0.946, 0.059>, <216.6336, -1.8910, 16.6129>, <-0.527, -0.804, -0.277> texture { ICP35_black_2 }}
	smooth_triangle { <220.2351, -6.4680, 4.0273>, <-0.626, -0.574, 0.528>, <217.1196, -8.6635, 0.4524>, <-0.631, 0.182, 0.754>, <215.1411, -6.9850, -0.7985>, <-0.497, -0.528, 0.688> texture { ICP35_black_2 }}
	smooth_triangle { <220.2351, -6.4680, 4.0273>, <0.885, -0.229, -0.406>, <217.1196, -8.6635, 0.4524>, <0.665, -0.479, -0.572>, <220.3911, -8.1425, 5.3138>, <0.766, -0.556, -0.323> texture { ICP35_black_2 }}
	smooth_triangle { <220.2351, -6.4680, 4.0273>, <0.885, -0.229, -0.406>, <220.3911, -8.1425, 5.3138>, <0.766, -0.556, -0.323>, <221.9901, -5.8950, 9.3778>, <0.972, -0.206, 0.114> texture { ICP35_black_2 }}
	smooth_triangle { <220.3911, -8.1425, 5.3138>, <0.766, -0.556, -0.323>, <217.1196, -8.6635, 0.4524>, <0.665, -0.479, -0.572>, <216.6336, -9.8990, 2.1414>, <0.527, -0.804, -0.277> texture { ICP35_black_2 }}
	smooth_triangle { <216.6341, -4.5660, 3.1498>, <0.310, 0.830, -0.463>, <220.2356, -3.9930, 8.5009>, <0.392, 0.897, -0.204>, <215.1411, -2.2775, 7.7089>, <0.292, 0.914, -0.281> texture { ICP35_black_2 }}
	smooth_triangle { <216.6341, -4.5660, 3.1498>, <-0.420, -0.780, 0.464>, <220.2356, -3.9930, 8.5009>, <-0.687, -0.674, 0.272>, <220.2351, -6.4680, 4.0273>, <-0.626, -0.574, 0.528> texture { ICP35_black_2 }}
	smooth_triangle { <216.6341, -4.5660, 3.1498>, <-0.420, -0.780, 0.464>, <220.2351, -6.4680, 4.0273>, <-0.626, -0.574, 0.528>, <215.1411, -6.9850, -0.7985>, <-0.497, -0.528, 0.688> texture { ICP35_black_2 }}
	smooth_triangle { <220.2351, -6.4680, 4.0273>, <-0.626, -0.574, 0.528>, <220.2356, -3.9930, 8.5009>, <-0.687, -0.674, 0.272>, <221.9901, -5.8950, 9.3778>, <-0.764, -0.616, 0.192> texture { ICP35_black_2 }}
	smooth_triangle { <216.6341, -4.5660, 3.1498>, <-0.420, -0.780, 0.464>, <210.5756, -2.9590, 2.9214>, <-0.192, -0.897, 0.398>, <215.1411, -2.2775, 7.7089>, <-0.227, -0.940, 0.254> texture { ICP35_black_2 }}
	smooth_triangle { <216.6341, -4.5660, 3.1498>, <0.310, 0.830, -0.463>, <210.5756, -2.9590, 2.9214>, <0.189, 0.898, -0.397>, <210.5751, -5.2080, -1.1420>, <0.289, 0.799, -0.527> texture { ICP35_black_2 }}
	smooth_triangle { <216.6341, -4.5660, 3.1498>, <0.310, 0.830, -0.463>, <210.5751, -5.2080, -1.1420>, <0.289, 0.799, -0.527>, <215.1411, -6.9850, -0.7985>, <0.451, 0.397, -0.800> texture { ICP35_black_2 }}
	smooth_triangle { <210.5756, -2.9590, 2.9214>, <-0.192, -0.897, 0.398>, <210.5751, -5.2080, -1.1420>, <-0.217, -0.768, 0.603>, <204.9816, -3.7450, -0.6980>, <-0.177, -0.836, 0.520> texture { ICP35_black_2 }}
	smooth_triangle { <207.2056, -10.8740, 11.6733>, <-0.047, 0.966, -0.254>, <202.0076, -9.6065, 15.4728>, <-0.099, 0.927, -0.361>, <197.2076, -11.0855, 12.0749>, <-0.079, 0.946, -0.314> texture { ICP35_black_2 }}
	smooth_triangle { <207.2056, -10.8740, 11.6733>, <0.116, -0.952, 0.282>, <202.0076, -9.6065, 15.4728>, <0.079, -0.924, 0.373>, <210.5741, -8.8305, 15.8323>, <0.097, -0.906, 0.412> texture { ICP35_black_2 }}
	smooth_triangle { <207.2056, -10.8740, 11.6733>, <0.116, -0.952, 0.282>, <210.5741, -8.8305, 15.8323>, <0.097, -0.906, 0.412>, <215.1406, -9.5120, 11.0449>, <0.237, -0.940, 0.247> texture { ICP35_black_2 }}
	smooth_triangle { <210.5741, -8.8305, 15.8323>, <0.097, -0.906, 0.412>, <202.0076, -9.6065, 15.4728>, <0.079, -0.924, 0.373>, <204.9801, -8.1225, 17.9749>, <0.121, -0.842, 0.525> texture { ICP35_black_2 }}
	smooth_triangle { <194.6911, -13.5965, 2.7284>, <0.093, -0.992, 0.086>, <201.3791, -11.7850, 7.9073>, <0.091, -0.981, 0.170>, <204.0571, -11.9575, 3.9354>, <0.107, -0.994, 0.022> texture { ICP35_black_2 }}
	smooth_triangle { <194.6911, -13.5965, 2.7284>, <-0.080, 0.993, -0.092>, <201.3791, -11.7850, 7.9073>, <-0.086, 0.981, -0.171>, <191.4196, -13.0755, 7.5898>, <-0.081, 0.966, -0.247> texture { ICP35_black_2 }}
	smooth_triangle { <191.4196, -13.0755, 7.5898>, <-0.081, 0.966, -0.247>, <201.3791, -11.7850, 7.9073>, <-0.086, 0.981, -0.171>, <197.2076, -11.0855, 12.0749>, <-0.079, 0.946, -0.314> texture { ICP35_black_2 }}
	smooth_triangle { <191.4196, -13.0755, 7.5898>, <0.015, -0.989, 0.147>, <194.6911, -13.5965, 2.7284>, <0.093, -0.992, 0.086>, <186.1276, -13.7030, 3.8964>, <0.016, -0.993, 0.115> texture { ICP35_black_2 }}
	smooth_triangle { <210.8071, -11.4465, 6.3249>, <0.166, -0.981, 0.101>, <207.2056, -10.8740, 11.6733>, <0.116, -0.952, 0.282>, <215.1406, -9.5120, 11.0449>, <0.237, -0.940, 0.247> texture { ICP35_black_2 }}
	smooth_triangle { <210.8071, -11.4465, 6.3249>, <-0.118, 0.984, -0.130>, <207.2056, -10.8740, 11.6733>, <-0.047, 0.966, -0.254>, <201.3791, -11.7850, 7.9073>, <-0.086, 0.981, -0.171> texture { ICP35_black_2 }}
	smooth_triangle { <210.8071, -11.4465, 6.3249>, <-0.118, 0.984, -0.130>, <201.3791, -11.7850, 7.9073>, <-0.086, 0.981, -0.171>, <204.0571, -11.9575, 3.9354>, <-0.133, 0.991, -0.014> texture { ICP35_black_2 }}
	smooth_triangle { <207.2056, -10.8740, 11.6733>, <0.116, -0.952, 0.282>, <201.3791, -11.7850, 7.9073>, <0.091, -0.981, 0.170>, <197.2076, -11.0855, 12.0749>, <0.074, -0.969, 0.235> texture { ICP35_black_2 }}
	smooth_triangle { <210.8071, -11.4465, 6.3249>, <-0.118, 0.984, -0.130>, <217.1186, -9.8710, 6.1114>, <-0.348, 0.935, -0.072>, <215.1406, -9.5120, 11.0449>, <-0.282, 0.915, -0.289> texture { ICP35_black_2 }}
	smooth_triangle { <210.8071, -11.4465, 6.3249>, <0.166, -0.981, 0.101>, <217.1186, -9.8710, 6.1114>, <0.351, -0.934, 0.071>, <211.8246, -11.4595, 1.7423>, <0.102, -0.993, -0.059> texture { ICP35_black_2 }}
	smooth_triangle { <210.8071, -11.4465, 6.3249>, <0.166, -0.981, 0.101>, <211.8246, -11.4595, 1.7423>, <0.102, -0.993, -0.059>, <204.0571, -11.9575, 3.9354>, <0.107, -0.994, 0.022> texture { ICP35_black_2 }}
	smooth_triangle { <217.1186, -9.8710, 6.1114>, <-0.348, 0.935, -0.072>, <211.8246, -11.4595, 1.7423>, <-0.315, 0.942, 0.115>, <216.6336, -9.8990, 2.1414>, <-0.315, 0.942, 0.115> texture { ICP35_black_2 }}
	smooth_triangle { <165.0486, -10.8740, 11.6733>, <0.132, 0.961, -0.243>, <161.6796, -8.8305, 15.8323>, <0.142, 0.891, -0.431>, <157.1136, -9.5120, 11.0449>, <0.237, 0.940, -0.247> texture { ICP35_black_2 }}
	smooth_triangle { <165.0486, -10.8740, 11.6733>, <-0.054, -0.952, 0.302>, <161.6796, -8.8305, 15.8323>, <-0.160, -0.910, 0.383>, <170.2456, -9.6065, 15.4728>, <-0.081, -0.923, 0.376> texture { ICP35_black_2 }}
	smooth_triangle { <165.0486, -10.8740, 11.6733>, <-0.054, -0.952, 0.302>, <170.2456, -9.6065, 15.4728>, <-0.081, -0.923, 0.376>, <175.0466, -11.0855, 12.0749>, <-0.079, -0.946, 0.314> texture { ICP35_black_2 }}
	smooth_triangle { <161.6796, -8.8305, 15.8323>, <0.142, 0.891, -0.431>, <170.2456, -9.6065, 15.4728>, <0.096, 0.929, -0.358>, <167.2746, -8.1225, 17.9749>, <0.121, 0.842, -0.525> texture { ICP35_black_2 }}
	smooth_triangle { <161.4476, -11.4465, 6.3249>, <0.127, 0.984, -0.123>, <160.4301, -11.4595, 1.7423>, <0.052, 0.998, 0.041>, <168.1966, -11.9575, 3.9354>, <0.107, 0.994, -0.022> texture { ICP35_black_2 }}
	smooth_triangle { <161.4476, -11.4465, 6.3249>, <-0.150, -0.982, 0.112>, <160.4301, -11.4595, 1.7423>, <-0.234, -0.967, -0.096>, <155.1351, -9.8710, 6.1114>, <-0.316, -0.948, 0.036> texture { ICP35_black_2 }}
	smooth_triangle { <161.4476, -11.4465, 6.3249>, <-0.150, -0.982, 0.112>, <155.1351, -9.8710, 6.1114>, <-0.316, -0.948, 0.036>, <157.1136, -9.5120, 11.0449>, <-0.282, -0.915, 0.289> texture { ICP35_black_2 }}
	smooth_triangle { <155.1351, -9.8710, 6.1114>, <-0.316, -0.948, 0.036>, <160.4301, -11.4595, 1.7423>, <-0.234, -0.967, -0.096>, <155.6211, -9.8985, 2.1414>, <-0.364, -0.927, -0.093> texture { ICP35_black_2 }}
	smooth_triangle { <165.0486, -10.8740, 11.6733>, <0.132, 0.961, -0.243>, <170.8761, -11.7850, 7.9073>, <0.101, 0.979, -0.175>, <175.0466, -11.0855, 12.0749>, <0.074, 0.969, -0.235> texture { ICP35_black_2 }}
	smooth_triangle { <165.0486, -10.8740, 11.6733>, <-0.054, -0.952, 0.302>, <170.8761, -11.7850, 7.9073>, <-0.075, -0.983, 0.166>, <161.4476, -11.4465, 6.3249>, <-0.150, -0.982, 0.112> texture { ICP35_black_2 }}
	smooth_triangle { <161.4476, -11.4465, 6.3249>, <-0.150, -0.982, 0.112>, <170.8761, -11.7850, 7.9073>, <-0.075, -0.983, 0.166>, <168.1966, -11.9575, 3.9354>, <-0.132, -0.991, 0.014> texture { ICP35_black_2 }}
	smooth_triangle { <161.4476, -11.4465, 6.3249>, <0.127, 0.984, -0.123>, <165.0486, -10.8740, 11.6733>, <0.132, 0.961, -0.243>, <157.1136, -9.5120, 11.0449>, <0.237, 0.940, -0.247> texture { ICP35_black_2 }}
	smooth_triangle { <180.8336, -13.0755, 7.5898>, <-0.067, -0.966, 0.251>, <170.8761, -11.7850, 7.9073>, <-0.075, -0.983, 0.166>, <175.0466, -11.0855, 12.0749>, <-0.079, -0.946, 0.314> texture { ICP35_black_2 }}
	smooth_triangle { <180.8336, -13.0755, 7.5898>, <0.050, 0.983, -0.176>, <170.8761, -11.7850, 7.9073>, <0.101, 0.979, -0.175>, <177.5616, -13.5965, 2.7284>, <0.089, 0.992, -0.088> texture { ICP35_black_2 }}
	smooth_triangle { <177.5616, -13.5965, 2.7284>, <0.089, 0.992, -0.088>, <170.8761, -11.7850, 7.9073>, <0.101, 0.979, -0.175>, <168.1966, -11.9575, 3.9354>, <0.107, 0.994, -0.022> texture { ICP35_black_2 }}
	smooth_triangle { <180.8336, -13.0755, 7.5898>, <0.050, 0.983, -0.176>, <177.5616, -13.5965, 2.7284>, <0.089, 0.992, -0.088>, <186.1276, -13.7030, 3.8964>, <0.024, 0.996, -0.089> texture { ICP35_black_2 }}
	smooth_triangle { <152.0196, -3.9935, 8.5009>, <0.400, -0.859, 0.319>, <155.1351, -1.9185, 12.6429>, <0.341, -0.939, 0.045>, <157.1126, -2.2775, 7.7089>, <0.292, -0.914, 0.281> texture { ICP35_black_2 }}
	smooth_triangle { <152.0196, -3.9935, 8.5009>, <-0.681, 0.715, -0.156>, <155.1351, -1.9185, 12.6429>, <-0.365, 0.923, -0.123>, <151.8621, -3.6470, 13.4398>, <-0.635, 0.770, 0.067> texture { ICP35_black_2 }}
	smooth_triangle { <152.0196, -3.9935, 8.5009>, <-0.681, 0.715, -0.156>, <151.8621, -3.6470, 13.4398>, <-0.635, 0.770, 0.067>, <150.2651, -5.8950, 9.3778>, <-0.764, 0.616, -0.192> texture { ICP35_black_2 }}
	smooth_triangle { <155.1351, -1.9185, 12.6429>, <0.341, -0.939, 0.045>, <151.8621, -3.6470, 13.4398>, <0.812, -0.493, -0.313>, <155.6196, -1.8910, 16.6129>, <0.364, -0.927, -0.093> texture { ICP35_black_2 }}
	smooth_triangle { <155.6201, -4.5660, 3.1498>, <0.422, -0.767, 0.483>, <161.6791, -5.2080, -1.1420>, <0.268, -0.739, 0.619>, <157.1136, -6.9850, -0.7985>, <0.488, -0.507, 0.711> texture { ICP35_black_2 }}
	smooth_triangle { <155.6201, -4.5660, 3.1498>, <-0.248, 0.874, -0.419>, <161.6791, -5.2080, -1.1420>, <-0.227, 0.799, -0.557>, <161.6786, -2.9590, 2.9214>, <-0.205, 0.879, -0.431> texture { ICP35_black_2 }}
	smooth_triangle { <155.6201, -4.5660, 3.1498>, <-0.248, 0.874, -0.419>, <161.6786, -2.9590, 2.9214>, <-0.205, 0.879, -0.431>, <157.1126, -2.2775, 7.7089>, <-0.227, 0.940, -0.254> texture { ICP35_black_2 }}
	smooth_triangle { <161.6786, -2.9590, 2.9214>, <-0.205, 0.879, -0.431>, <161.6791, -5.2080, -1.1420>, <-0.227, 0.799, -0.557>, <167.2726, -3.7450, -0.6980>, <-0.164, 0.860, -0.483> texture { ICP35_black_2 }}
	smooth_triangle { <152.0191, -6.4680, 4.0273>, <-0.810, 0.177, -0.559>, <152.0196, -3.9935, 8.5009>, <-0.681, 0.715, -0.156>, <150.2651, -5.8950, 9.3778>, <-0.764, 0.616, -0.192> texture { ICP35_black_2 }}
	smooth_triangle { <152.0191, -6.4680, 4.0273>, <0.729, -0.479, 0.489>, <152.0196, -3.9935, 8.5009>, <0.400, -0.859, 0.319>, <155.6201, -4.5660, 3.1498>, <0.422, -0.767, 0.483> texture { ICP35_black_2 }}
	smooth_triangle { <152.0191, -6.4680, 4.0273>, <0.729, -0.479, 0.489>, <155.6201, -4.5660, 3.1498>, <0.422, -0.767, 0.483>, <157.1136, -6.9850, -0.7985>, <0.488, -0.507, 0.711> texture { ICP35_black_2 }}
	smooth_triangle { <155.6201, -4.5660, 3.1498>, <0.422, -0.767, 0.483>, <152.0196, -3.9935, 8.5009>, <0.400, -0.859, 0.319>, <157.1126, -2.2775, 7.7089>, <0.292, -0.914, 0.281> texture { ICP35_black_2 }}
	smooth_triangle { <152.0191, -6.4680, 4.0273>, <0.729, -0.479, 0.489>, <151.8631, -8.1425, 5.3138>, <0.749, 0.630, 0.205>, <150.2651, -5.8950, 9.3778>, <0.972, 0.206, -0.114> texture { ICP35_black_2 }}
	smooth_triangle { <152.0191, -6.4680, 4.0273>, <-0.810, 0.177, -0.559>, <151.8631, -8.1425, 5.3138>, <-0.722, -0.669, -0.175>, <155.1356, -8.6635, 0.4524>, <-0.765, -0.040, -0.642> texture { ICP35_black_2 }}
	smooth_triangle { <152.0191, -6.4680, 4.0273>, <-0.810, 0.177, -0.559>, <155.1356, -8.6635, 0.4524>, <-0.765, -0.040, -0.642>, <157.1136, -6.9850, -0.7985>, <-0.464, 0.424, -0.778> texture { ICP35_black_2 }}
	smooth_triangle { <151.8631, -8.1425, 5.3138>, <0.749, 0.630, 0.205>, <155.1356, -8.6635, 0.4524>, <0.577, 0.544, 0.609>, <155.6211, -9.8985, 2.1414>, <0.549, 0.742, 0.385> texture { ICP35_black_2 }}
	smooth_triangle { <210.8071, -0.3430, 12.4289>, <0.146, 0.982, -0.116>, <211.8251, -0.3300, 17.0114>, <0.265, 0.959, 0.098>, <204.0581, 1.0479, 16.8518>, <0.129, 0.990, -0.053> texture { ICP35_black_2 }}
	smooth_triangle { <210.8071, -0.3430, 12.4289>, <-0.224, -0.963, 0.150>, <211.8251, -0.3300, 17.0114>, <-0.209, -0.978, -0.007>, <217.1196, -1.9190, 12.6433>, <-0.318, -0.946, 0.059> texture { ICP35_black_2 }}
	smooth_triangle { <210.8071, -0.3430, 12.4289>, <-0.224, -0.963, 0.150>, <217.1196, -1.9190, 12.6433>, <-0.318, -0.946, 0.059>, <215.1411, -2.2775, 7.7089>, <-0.227, -0.940, 0.254> texture { ICP35_black_2 }}
	smooth_triangle { <211.8251, -0.3300, 17.0114>, <0.265, 0.959, 0.098>, <217.1196, -1.9190, 12.6433>, <0.380, 0.921, -0.083>, <216.6336, -1.8910, 16.6129>, <0.315, 0.942, 0.115> texture { ICP35_black_2 }}
	smooth_triangle { <201.3796, 0.8323, 11.8864>, <0.104, 0.976, -0.189>, <191.4206, 1.2858, 11.1649>, <0.020, 0.980, -0.199>, <197.2086, -0.0415, 6.6773>, <0.072, 0.962, -0.263> texture { ICP35_black_2 }}
	smooth_triangle { <201.3796, 0.8323, 11.8864>, <-0.072, -0.991, 0.117>, <191.4206, 1.2858, 11.1649>, <-0.038, -0.984, 0.173>, <194.6931, 1.8063, 16.0254>, <-0.048, -0.994, 0.103> texture { ICP35_black_2 }}
	smooth_triangle { <201.3796, 0.8323, 11.8864>, <-0.072, -0.991, 0.117>, <194.6931, 1.8063, 16.0254>, <-0.048, -0.994, 0.103>, <204.0581, 1.0479, 16.8518>, <-0.127, -0.992, -0.021> texture { ICP35_black_2 }}
	smooth_triangle { <194.6931, 1.8063, 16.0254>, <-0.048, -0.994, 0.103>, <191.4206, 1.2858, 11.1649>, <-0.038, -0.984, 0.173>, <186.1276, 1.9133, 14.8583>, <-0.025, -0.996, 0.089> texture { ICP35_black_2 }}
	smooth_triangle { <207.2071, -0.9155, 7.0804>, <-0.138, -0.946, 0.293>, <210.8071, -0.3430, 12.4289>, <-0.224, -0.963, 0.150>, <215.1411, -2.2775, 7.7089>, <-0.227, -0.940, 0.254> texture { ICP35_black_2 }}
	smooth_triangle { <207.2071, -0.9155, 7.0804>, <0.137, 0.959, -0.247>, <210.8071, -0.3430, 12.4289>, <0.146, 0.982, -0.116>, <201.3796, 0.8323, 11.8864>, <0.104, 0.976, -0.189> texture { ICP35_black_2 }}
	smooth_triangle { <207.2071, -0.9155, 7.0804>, <0.137, 0.959, -0.247>, <201.3796, 0.8323, 11.8864>, <0.104, 0.976, -0.189>, <197.2086, -0.0415, 6.6773>, <0.072, 0.962, -0.263> texture { ICP35_black_2 }}
	smooth_triangle { <201.3796, 0.8323, 11.8864>, <0.104, 0.976, -0.189>, <210.8071, -0.3430, 12.4289>, <0.146, 0.982, -0.116>, <204.0581, 1.0479, 16.8518>, <0.129, 0.990, -0.053> texture { ICP35_black_2 }}
	smooth_triangle { <207.2071, -0.9155, 7.0804>, <0.137, 0.959, -0.247>, <210.5756, -2.9590, 2.9214>, <0.189, 0.898, -0.397>, <215.1411, -2.2775, 7.7089>, <0.292, 0.914, -0.281> texture { ICP35_black_2 }}
	smooth_triangle { <207.2071, -0.9155, 7.0804>, <-0.138, -0.946, 0.293>, <210.5756, -2.9590, 2.9214>, <-0.192, -0.897, 0.398>, <202.0096, -1.8910, 2.4289>, <-0.115, -0.938, 0.326> texture { ICP35_black_2 }}
	smooth_triangle { <207.2071, -0.9155, 7.0804>, <-0.138, -0.946, 0.293>, <202.0096, -1.8910, 2.4289>, <-0.115, -0.938, 0.326>, <197.2086, -0.0415, 6.6773>, <-0.051, -0.956, 0.288> texture { ICP35_black_2 }}
	smooth_triangle { <210.5756, -2.9590, 2.9214>, <0.189, 0.898, -0.397>, <202.0096, -1.8910, 2.4289>, <0.089, 0.912, -0.399>, <204.9816, -3.7450, -0.6980>, <0.113, 0.881, -0.459> texture { ICP35_black_2 }}
	smooth_triangle { <216.6331, -7.2230, 15.6034>, <0.443, -0.722, 0.531>, <210.5756, -6.5815, 19.8964>, <0.160, -0.818, 0.552>, <215.1401, -4.8060, 19.5529>, <0.488, -0.507, 0.711> texture { ICP35_black_2 }}
	smooth_triangle { <216.6331, -7.2230, 15.6034>, <-0.281, 0.877, -0.389>, <210.5756, -6.5815, 19.8964>, <-0.206, 0.797, -0.568>, <210.5741, -8.8305, 15.8323>, <-0.248, 0.874, -0.419> texture { ICP35_black_2 }}
	smooth_triangle { <216.6331, -7.2230, 15.6034>, <-0.281, 0.877, -0.389>, <210.5741, -8.8305, 15.8323>, <-0.248, 0.874, -0.419>, <215.1406, -9.5120, 11.0449>, <-0.282, 0.915, -0.289> texture { ICP35_black_2 }}
	smooth_triangle { <210.5756, -6.5815, 19.8964>, <0.160, -0.818, 0.552>, <210.5741, -8.8305, 15.8323>, <0.097, -0.906, 0.412>, <204.9801, -8.1225, 17.9749>, <0.121, -0.842, 0.525> texture { ICP35_black_2 }}
	smooth_triangle { <220.2341, -5.3225, 14.7259>, <0.742, -0.504, 0.442>, <220.3916, -3.6470, 13.4398>, <0.809, 0.574, 0.124>, <221.9901, -5.8950, 9.3778>, <0.972, -0.206, 0.114> texture { ICP35_black_2 }}
	smooth_triangle { <220.2341, -5.3225, 14.7259>, <-0.765, -0.040, -0.642>, <220.3916, -3.6470, 13.4398>, <-0.698, -0.682, -0.220>, <217.1191, -3.1265, 18.3014>, <-0.711, -0.433, -0.554> texture { ICP35_black_2 }}
	smooth_triangle { <220.2341, -5.3225, 14.7259>, <-0.765, -0.040, -0.642>, <217.1191, -3.1265, 18.3014>, <-0.711, -0.433, -0.554>, <215.1401, -4.8060, 19.5529>, <-0.464, 0.424, -0.778> texture { ICP35_black_2 }}
	smooth_triangle { <217.1191, -3.1265, 18.3014>, <-0.711, -0.433, -0.554>, <220.3916, -3.6470, 13.4398>, <-0.698, -0.682, -0.220>, <216.6336, -1.8910, 16.6129>, <-0.527, -0.804, -0.277> texture { ICP35_black_2 }}
	smooth_triangle { <220.2341, -7.7955, 10.2538>, <-0.540, 0.826, -0.162>, <216.6331, -7.2230, 15.6034>, <-0.281, 0.877, -0.389>, <215.1406, -9.5120, 11.0449>, <-0.282, 0.915, -0.289> texture { ICP35_black_2 }}
	smooth_triangle { <220.2341, -7.7955, 10.2538>, <0.553, -0.769, 0.321>, <216.6331, -7.2230, 15.6034>, <0.443, -0.722, 0.531>, <220.2341, -5.3225, 14.7259>, <0.742, -0.504, 0.442> texture { ICP35_black_2 }}
	smooth_triangle { <220.2341, -7.7955, 10.2538>, <0.553, -0.769, 0.321>, <220.2341, -5.3225, 14.7259>, <0.742, -0.504, 0.442>, <221.9901, -5.8950, 9.3778>, <0.972, -0.206, 0.114> texture { ICP35_black_2 }}
	smooth_triangle { <220.2341, -5.3225, 14.7259>, <0.742, -0.504, 0.442>, <216.6331, -7.2230, 15.6034>, <0.443, -0.722, 0.531>, <215.1401, -4.8060, 19.5529>, <0.488, -0.507, 0.711> texture { ICP35_black_2 }}
	smooth_triangle { <220.2341, -7.7955, 10.2538>, <0.553, -0.769, 0.321>, <217.1186, -9.8710, 6.1114>, <0.351, -0.934, 0.071>, <215.1406, -9.5120, 11.0449>, <0.237, -0.940, 0.247> texture { ICP35_black_2 }}
	smooth_triangle { <220.2341, -7.7955, 10.2538>, <-0.540, 0.826, -0.162>, <217.1186, -9.8710, 6.1114>, <-0.348, 0.935, -0.072>, <220.3911, -8.1425, 5.3138>, <-0.624, 0.778, -0.074> texture { ICP35_black_2 }}
	smooth_triangle { <220.2341, -7.7955, 10.2538>, <-0.540, 0.826, -0.162>, <220.3911, -8.1425, 5.3138>, <-0.624, 0.778, -0.074>, <221.9901, -5.8950, 9.3778>, <-0.749, 0.659, -0.070> texture { ICP35_black_2 }}
	smooth_triangle { <217.1186, -9.8710, 6.1114>, <0.351, -0.934, 0.071>, <220.3911, -8.1425, 5.3138>, <0.766, -0.556, -0.323>, <216.6336, -9.8990, 2.1414>, <0.527, -0.804, -0.277> texture { ICP35_black_2 }}
	smooth_triangle { <180.3021, -10.3010, 17.0233>, <-0.011, -0.917, 0.399>, <175.5411, -8.3100, 20.6938>, <-0.130, -0.852, 0.507>, <186.1276, -8.4230, 21.2219>, <0.001, -0.888, 0.461> texture { ICP35_black_2 }}
	smooth_triangle { <180.3021, -10.3010, 17.0233>, <0.104, 0.952, -0.288>, <175.5411, -8.3100, 20.6938>, <0.127, 0.852, -0.508>, <170.2456, -9.6065, 15.4728>, <0.096, 0.929, -0.358> texture { ICP35_black_2 }}
	smooth_triangle { <180.3021, -10.3010, 17.0233>, <0.104, 0.952, -0.288>, <170.2456, -9.6065, 15.4728>, <0.096, 0.929, -0.358>, <175.0466, -11.0855, 12.0749>, <0.074, 0.969, -0.235> texture { ICP35_black_2 }}
	smooth_triangle { <175.5411, -8.3100, 20.6938>, <-0.130, -0.852, 0.507>, <170.2456, -9.6065, 15.4728>, <-0.081, -0.923, 0.376>, <167.2746, -8.1225, 17.9749>, <-0.103, -0.891, 0.443> texture { ICP35_black_2 }}
	smooth_triangle { <191.9516, -10.3010, 17.0233>, <0.049, -0.947, 0.316>, <202.0076, -9.6065, 15.4728>, <0.079, -0.924, 0.373>, <197.2076, -11.0855, 12.0749>, <0.074, -0.969, 0.235> texture { ICP35_black_2 }}
	smooth_triangle { <191.9516, -10.3010, 17.0233>, <-0.075, 0.914, -0.398>, <202.0076, -9.6065, 15.4728>, <-0.099, 0.927, -0.361>, <196.7136, -8.3100, 20.6938>, <-0.098, 0.916, -0.390> texture { ICP35_black_2 }}
	smooth_triangle { <191.9516, -10.3010, 17.0233>, <-0.075, 0.914, -0.398>, <196.7136, -8.3100, 20.6938>, <-0.098, 0.916, -0.390>, <186.1276, -8.4230, 21.2219>, <0.001, 0.857, -0.516> texture { ICP35_black_2 }}
	smooth_triangle { <196.7136, -8.3100, 20.6938>, <-0.098, 0.916, -0.390>, <202.0076, -9.6065, 15.4728>, <-0.099, 0.927, -0.361>, <204.9801, -8.1225, 17.9749>, <-0.103, 0.891, -0.443> texture { ICP35_black_2 }}
	smooth_triangle { <186.1276, -12.0495, 12.2163>, <0.000, 0.966, -0.258>, <180.3021, -10.3010, 17.0233>, <0.104, 0.952, -0.288>, <175.0466, -11.0855, 12.0749>, <0.074, 0.969, -0.235> texture { ICP35_black_2 }}
	smooth_triangle { <186.1276, -12.0495, 12.2163>, <0.000, -0.954, 0.300>, <180.3021, -10.3010, 17.0233>, <-0.011, -0.917, 0.399>, <191.9516, -10.3010, 17.0233>, <0.049, -0.947, 0.316> texture { ICP35_black_2 }}
	smooth_triangle { <186.1276, -12.0495, 12.2163>, <0.000, -0.954, 0.300>, <191.9516, -10.3010, 17.0233>, <0.049, -0.947, 0.316>, <197.2076, -11.0855, 12.0749>, <0.074, -0.969, 0.235> texture { ICP35_black_2 }}
	smooth_triangle { <191.9516, -10.3010, 17.0233>, <0.049, -0.947, 0.316>, <180.3021, -10.3010, 17.0233>, <-0.011, -0.917, 0.399>, <186.1276, -8.4230, 21.2219>, <0.001, -0.888, 0.461> texture { ICP35_black_2 }}
	smooth_triangle { <186.1276, -12.0495, 12.2163>, <0.000, -0.954, 0.300>, <180.8336, -13.0755, 7.5898>, <-0.067, -0.966, 0.251>, <175.0466, -11.0855, 12.0749>, <-0.079, -0.946, 0.314> texture { ICP35_black_2 }}
	smooth_triangle { <186.1276, -12.0495, 12.2163>, <0.000, 0.966, -0.258>, <180.8336, -13.0755, 7.5898>, <0.050, 0.983, -0.176>, <191.4196, -13.0755, 7.5898>, <-0.081, 0.966, -0.247> texture { ICP35_black_2 }}
	smooth_triangle { <186.1276, -12.0495, 12.2163>, <0.000, 0.966, -0.258>, <191.4196, -13.0755, 7.5898>, <-0.081, 0.966, -0.247>, <197.2076, -11.0855, 12.0749>, <-0.079, 0.946, -0.314> texture { ICP35_black_2 }}
	smooth_triangle { <180.8336, -13.0755, 7.5898>, <-0.067, -0.966, 0.251>, <191.4196, -13.0755, 7.5898>, <0.015, -0.989, 0.147>, <186.1276, -13.7030, 3.8964>, <0.016, -0.993, 0.115> texture { ICP35_black_2 }}
	smooth_triangle { <152.0191, -5.3225, 14.7259>, <-0.568, -0.569, 0.594>, <155.1346, -3.1265, 18.3014>, <-0.625, 0.504, 0.596>, <157.1136, -4.8055, 19.5529>, <-0.497, -0.529, 0.688> texture { ICP35_black_2 }}
	smooth_triangle { <152.0191, -5.3225, 14.7259>, <0.914, 0.040, -0.405>, <155.1346, -3.1265, 18.3014>, <0.703, -0.148, -0.696>, <151.8621, -3.6470, 13.4398>, <0.812, -0.493, -0.313> texture { ICP35_black_2 }}
	smooth_triangle { <152.0191, -5.3225, 14.7259>, <0.914, 0.040, -0.405>, <151.8621, -3.6470, 13.4398>, <0.812, -0.493, -0.313>, <150.2651, -5.8950, 9.3778>, <0.972, 0.206, -0.114> texture { ICP35_black_2 }}
	smooth_triangle { <155.1346, -3.1265, 18.3014>, <-0.625, 0.504, 0.596>, <151.8621, -3.6470, 13.4398>, <-0.635, 0.770, 0.067>, <155.6196, -1.8910, 16.6129>, <-0.549, 0.742, 0.385> texture { ICP35_black_2 }}
	smooth_triangle { <155.6206, -7.2230, 15.6034>, <-0.402, -0.808, 0.430>, <161.6796, -8.8305, 15.8323>, <-0.160, -0.910, 0.383>, <157.1136, -9.5120, 11.0449>, <-0.282, -0.915, 0.289> texture { ICP35_black_2 }}
	smooth_triangle { <155.6206, -7.2230, 15.6034>, <0.289, 0.799, -0.527>, <161.6796, -8.8305, 15.8323>, <0.142, 0.891, -0.431>, <161.6796, -6.5815, 19.8964>, <0.219, 0.829, -0.515> texture { ICP35_black_2 }}
	smooth_triangle { <155.6206, -7.2230, 15.6034>, <0.289, 0.799, -0.527>, <161.6796, -6.5815, 19.8964>, <0.219, 0.829, -0.515>, <157.1136, -4.8055, 19.5529>, <0.451, 0.397, -0.800> texture { ICP35_black_2 }}
	smooth_triangle { <161.6796, -6.5815, 19.8964>, <0.219, 0.829, -0.515>, <161.6796, -8.8305, 15.8323>, <0.142, 0.891, -0.431>, <167.2746, -8.1225, 17.9749>, <0.121, 0.842, -0.525> texture { ICP35_black_2 }}
	smooth_triangle { <152.0191, -7.7955, 10.2538>, <0.547, 0.812, -0.204>, <152.0191, -5.3225, 14.7259>, <0.914, 0.040, -0.405>, <150.2651, -5.8950, 9.3778>, <0.972, 0.206, -0.114> texture { ICP35_black_2 }}
	smooth_triangle { <152.0191, -7.7955, 10.2538>, <-0.548, -0.788, 0.280>, <152.0191, -5.3225, 14.7259>, <-0.568, -0.569, 0.594>, <155.6206, -7.2230, 15.6034>, <-0.402, -0.808, 0.430> texture { ICP35_black_2 }}
	smooth_triangle { <152.0191, -7.7955, 10.2538>, <-0.548, -0.788, 0.280>, <155.6206, -7.2230, 15.6034>, <-0.402, -0.808, 0.430>, <157.1136, -9.5120, 11.0449>, <-0.282, -0.915, 0.289> texture { ICP35_black_2 }}
	smooth_triangle { <155.6206, -7.2230, 15.6034>, <-0.402, -0.808, 0.430>, <152.0191, -5.3225, 14.7259>, <-0.568, -0.569, 0.594>, <157.1136, -4.8055, 19.5529>, <-0.497, -0.529, 0.688> texture { ICP35_black_2 }}
	smooth_triangle { <152.0191, -7.7955, 10.2538>, <-0.548, -0.788, 0.280>, <151.8631, -8.1425, 5.3138>, <-0.722, -0.669, -0.175>, <150.2651, -5.8950, 9.3778>, <-0.749, -0.659, 0.070> texture { ICP35_black_2 }}
	smooth_triangle { <152.0191, -7.7955, 10.2538>, <0.547, 0.812, -0.204>, <151.8631, -8.1425, 5.3138>, <0.749, 0.630, 0.205>, <155.1351, -9.8710, 6.1114>, <0.412, 0.900, -0.141> texture { ICP35_black_2 }}
	smooth_triangle { <152.0191, -7.7955, 10.2538>, <0.547, 0.812, -0.204>, <155.1351, -9.8710, 6.1114>, <0.412, 0.900, -0.141>, <157.1136, -9.5120, 11.0449>, <0.237, 0.940, -0.247> texture { ICP35_black_2 }}
	smooth_triangle { <151.8631, -8.1425, 5.3138>, <-0.722, -0.669, -0.175>, <155.1351, -9.8710, 6.1114>, <-0.316, -0.948, 0.036>, <155.6211, -9.8985, 2.1414>, <-0.364, -0.927, -0.093> texture { ICP35_black_2 }}
	smooth_triangle { <170.8736, 0.8323, 11.8864>, <-0.117, 0.984, -0.132>, <177.5626, 1.8063, 16.0254>, <-0.044, 0.997, -0.066>, <168.1951, 1.0479, 16.8518>, <-0.131, 0.990, -0.045> texture { ICP35_black_2 }}
	smooth_triangle { <170.8736, 0.8323, 11.8864>, <0.070, -0.978, 0.198>, <177.5626, 1.8063, 16.0254>, <0.068, -0.995, 0.074>, <180.8341, 1.2863, 11.1643>, <0.058, -0.982, 0.177> texture { ICP35_black_2 }}
	smooth_triangle { <170.8736, 0.8323, 11.8864>, <0.070, -0.978, 0.198>, <180.8341, 1.2863, 11.1643>, <0.058, -0.982, 0.177>, <175.0451, -0.0415, 6.6773>, <0.072, -0.962, 0.263> texture { ICP35_black_2 }}
	smooth_triangle { <177.5626, 1.8063, 16.0254>, <-0.044, 0.997, -0.066>, <180.8341, 1.2863, 11.1643>, <-0.015, 0.982, -0.190>, <186.1276, 1.9133, 14.8583>, <-0.016, 0.993, -0.115> texture { ICP35_black_2 }}
	smooth_triangle { <161.4461, -0.3430, 12.4289>, <-0.172, 0.969, -0.175>, <155.1351, -1.9185, 12.6429>, <-0.365, 0.923, -0.123>, <157.1126, -2.2775, 7.7089>, <-0.227, 0.940, -0.254> texture { ICP35_black_2 }}
	smooth_triangle { <161.4461, -0.3430, 12.4289>, <0.210, -0.977, 0.049>, <155.1351, -1.9185, 12.6429>, <0.341, -0.939, 0.045>, <160.4286, -0.3300, 17.0114>, <0.264, -0.964, -0.033> texture { ICP35_black_2 }}
	smooth_triangle { <161.4461, -0.3430, 12.4289>, <0.210, -0.977, 0.049>, <160.4286, -0.3300, 17.0114>, <0.264, -0.964, -0.033>, <168.1951, 1.0479, 16.8518>, <0.125, -0.992, -0.012> texture { ICP35_black_2 }}
	smooth_triangle { <160.4286, -0.3300, 17.0114>, <0.264, -0.964, -0.033>, <155.1351, -1.9185, 12.6429>, <0.341, -0.939, 0.045>, <155.6196, -1.8910, 16.6129>, <0.364, -0.927, -0.093> texture { ICP35_black_2 }}
	smooth_triangle { <165.0476, -0.9155, 7.0804>, <0.138, -0.944, 0.298>, <170.8736, 0.8323, 11.8864>, <0.070, -0.978, 0.198>, <175.0451, -0.0415, 6.6773>, <0.072, -0.962, 0.263> texture { ICP35_black_2 }}
	smooth_triangle { <165.0476, -0.9155, 7.0804>, <-0.137, 0.961, -0.242>, <170.8736, 0.8323, 11.8864>, <-0.117, 0.984, -0.132>, <161.4461, -0.3430, 12.4289>, <-0.172, 0.969, -0.175> texture { ICP35_black_2 }}
	smooth_triangle { <165.0476, -0.9155, 7.0804>, <-0.137, 0.961, -0.242>, <161.4461, -0.3430, 12.4289>, <-0.172, 0.969, -0.175>, <157.1126, -2.2775, 7.7089>, <-0.227, 0.940, -0.254> texture { ICP35_black_2 }}
	smooth_triangle { <161.4461, -0.3430, 12.4289>, <-0.172, 0.969, -0.175>, <170.8736, 0.8323, 11.8864>, <-0.117, 0.984, -0.132>, <168.1951, 1.0479, 16.8518>, <-0.131, 0.990, -0.045> texture { ICP35_black_2 }}
	smooth_triangle { <165.0476, -0.9155, 7.0804>, <-0.137, 0.961, -0.242>, <170.2451, -1.8910, 2.4289>, <-0.099, 0.922, -0.374>, <175.0451, -0.0415, 6.6773>, <-0.051, 0.956, -0.288> texture { ICP35_black_2 }}
	smooth_triangle { <165.0476, -0.9155, 7.0804>, <0.138, -0.944, 0.298>, <170.2451, -1.8910, 2.4289>, <0.097, -0.922, 0.376>, <161.6786, -2.9590, 2.9214>, <0.160, -0.931, 0.328> texture { ICP35_black_2 }}
	smooth_triangle { <165.0476, -0.9155, 7.0804>, <0.138, -0.944, 0.298>, <161.6786, -2.9590, 2.9214>, <0.160, -0.931, 0.328>, <157.1126, -2.2775, 7.7089>, <0.292, -0.914, 0.281> texture { ICP35_black_2 }}
	smooth_triangle { <170.2451, -1.8910, 2.4289>, <-0.099, 0.922, -0.374>, <161.6786, -2.9590, 2.9214>, <-0.205, 0.879, -0.431>, <167.2726, -3.7450, -0.6980>, <-0.164, 0.860, -0.483> texture { ICP35_black_2 }}
	smooth_triangle { <195.5541, 0.9373, 24.3924>, <-0.144, -0.909, -0.392>, <194.6931, -0.4325, 26.5184>, <-0.152, -0.802, -0.578>, <204.0581, -0.5145, 24.1733>, <-0.229, -0.807, -0.545> texture { ICP35_black_2 }}
	smooth_triangle { <195.5541, 0.9373, 24.3924>, <0.052, 0.924, 0.379>, <194.6931, -0.4325, 26.5184>, <0.147, 0.678, 0.720>, <186.1276, 0.6353, 26.0254>, <0.010, 0.869, 0.495> texture { ICP35_black_2 }}
	smooth_triangle { <195.5541, 0.9373, 24.3924>, <0.052, 0.924, 0.379>, <186.1276, 0.6353, 26.0254>, <0.010, 0.869, 0.495>, <186.1271, 1.7213, 23.1418>, <0.021, 0.975, 0.221> texture { ICP35_black_2 }}
	smooth_triangle { <186.1276, 0.6353, 26.0254>, <-0.113, -0.513, 0.851>, <194.6931, -0.4325, 26.5184>, <-0.018, -0.310, 0.950>, <186.1276, -2.2845, 24.2639>, <-0.112, -0.516, 0.849> texture { ICP35_black_2 }}
	smooth_triangle { <204.9796, 0.5838, 21.0858>, <-0.143, -0.972, -0.185>, <211.8251, -0.3300, 17.0114>, <-0.209, -0.978, -0.007>, <204.0581, 1.0479, 16.8518>, <-0.127, -0.992, -0.021> texture { ICP35_black_2 }}
	smooth_triangle { <204.9796, 0.5838, 21.0858>, <0.249, 0.922, 0.297>, <211.8251, -0.3300, 17.0114>, <0.265, 0.959, 0.098>, <211.8251, -1.0760, 20.5089>, <0.339, 0.863, 0.375> texture { ICP35_black_2 }}
	smooth_triangle { <204.9796, 0.5838, 21.0858>, <0.249, 0.922, 0.297>, <211.8251, -1.0760, 20.5089>, <0.339, 0.863, 0.375>, <204.0581, -0.5145, 24.1733>, <0.276, 0.611, 0.742> texture { ICP35_black_2 }}
	smooth_triangle { <211.8251, -1.0760, 20.5089>, <0.339, 0.863, 0.375>, <211.8251, -0.3300, 17.0114>, <0.265, 0.959, 0.098>, <216.6336, -1.8910, 16.6129>, <0.315, 0.942, 0.115> texture { ICP35_black_2 }}
	smooth_triangle { <195.5541, 1.7593, 20.5428>, <0.058, 0.996, 0.069>, <195.5541, 0.9373, 24.3924>, <0.052, 0.924, 0.379>, <186.1271, 1.7213, 23.1418>, <0.021, 0.975, 0.221> texture { ICP35_black_2 }}
	smooth_triangle { <195.5541, 1.7593, 20.5428>, <-0.084, -0.988, -0.130>, <195.5541, 0.9373, 24.3924>, <-0.144, -0.909, -0.392>, <204.9796, 0.5838, 21.0858>, <-0.143, -0.972, -0.185> texture { ICP35_black_2 }}
	smooth_triangle { <195.5541, 1.7593, 20.5428>, <-0.084, -0.988, -0.130>, <204.9796, 0.5838, 21.0858>, <-0.143, -0.972, -0.185>, <204.0581, 1.0479, 16.8518>, <-0.127, -0.992, -0.021> texture { ICP35_black_2 }}
	smooth_triangle { <204.9796, 0.5838, 21.0858>, <-0.143, -0.972, -0.185>, <195.5541, 0.9373, 24.3924>, <-0.144, -0.909, -0.392>, <204.0581, -0.5145, 24.1733>, <-0.229, -0.807, -0.545> texture { ICP35_black_2 }}
	smooth_triangle { <195.5541, 1.7593, 20.5428>, <-0.084, -0.988, -0.130>, <186.1271, 2.1278, 19.0298>, <-0.021, -0.999, -0.024>, <186.1271, 1.7213, 23.1418>, <0.021, -0.975, -0.221> texture { ICP35_black_2 }}
	smooth_triangle { <195.5541, 1.7593, 20.5428>, <0.058, 0.996, 0.069>, <186.1271, 2.1278, 19.0298>, <-0.011, 1.000, 0.013>, <194.6931, 1.8063, 16.0254>, <0.060, 0.998, -0.001> texture { ICP35_black_2 }}
	smooth_triangle { <195.5541, 1.7593, 20.5428>, <0.058, 0.996, 0.069>, <194.6931, 1.8063, 16.0254>, <0.060, 0.998, -0.001>, <204.0581, 1.0479, 16.8518>, <0.129, 0.990, -0.053> texture { ICP35_black_2 }}
	smooth_triangle { <186.1271, 2.1278, 19.0298>, <-0.021, -0.999, -0.024>, <194.6931, 1.8063, 16.0254>, <-0.048, -0.994, 0.103>, <186.1276, 1.9133, 14.8583>, <-0.025, -0.996, 0.089> texture { ICP35_black_2 }}
	smooth_triangle { <201.3791, -2.1395, 25.8124>, <-0.109, 0.542, -0.833>, <191.4206, -3.4160, 24.2659>, <0.014, 0.738, -0.675>, <197.2086, -4.9935, 23.0864>, <-0.096, 0.601, -0.794> texture { ICP35_black_2 }}
	smooth_triangle { <201.3791, -2.1395, 25.8124>, <0.184, 0.111, 0.977>, <191.4206, -3.4160, 24.2659>, <0.054, -0.221, 0.974>, <194.6931, -0.4325, 26.5184>, <-0.018, -0.310, 0.950> texture { ICP35_black_2 }}
	smooth_triangle { <201.3791, -2.1395, 25.8124>, <0.184, 0.111, 0.977>, <194.6931, -0.4325, 26.5184>, <0.001, -0.069, 0.998>, <204.0581, -0.5145, 24.1733>, <0.276, 0.611, 0.742> texture { ICP35_black_2 }}
	smooth_triangle { <194.6931, -0.4325, 26.5184>, <-0.018, -0.310, 0.950>, <191.4206, -3.4160, 24.2659>, <0.054, -0.221, 0.974>, <186.1276, -2.2845, 24.2639>, <-0.112, -0.516, 0.849> texture { ICP35_black_2 }}
	smooth_triangle { <207.2061, -4.3950, 23.3828>, <-0.270, 0.489, -0.829>, <210.5756, -6.5815, 19.8964>, <-0.206, 0.797, -0.568>, <215.1401, -4.8060, 19.5529>, <-0.464, 0.424, -0.778> texture { ICP35_black_2 }}
	smooth_triangle { <207.2061, -4.3950, 23.3828>, <0.048, -0.799, 0.600>, <210.5756, -6.5815, 19.8964>, <0.160, -0.818, 0.552>, <202.0086, -6.6945, 20.7339>, <0.133, -0.766, 0.629> texture { ICP35_black_2 }}
	smooth_triangle { <207.2061, -4.3950, 23.3828>, <0.048, -0.799, 0.600>, <202.0086, -6.6945, 20.7339>, <0.133, -0.766, 0.629>, <197.2086, -4.9935, 23.0864>, <0.160, -0.560, 0.813> texture { ICP35_black_2 }}
	smooth_triangle { <210.5756, -6.5815, 19.8964>, <-0.206, 0.797, -0.568>, <202.0086, -6.6945, 20.7339>, <-0.186, 0.657, -0.731>, <204.9801, -8.1225, 17.9749>, <-0.103, 0.891, -0.443> texture { ICP35_black_2 }}
	smooth_triangle { <210.8076, -2.4935, 22.5053>, <0.475, 0.311, 0.823>, <201.3791, -2.1395, 25.8124>, <0.184, 0.111, 0.977>, <204.0581, -0.5145, 24.1733>, <0.276, 0.611, 0.742> texture { ICP35_black_2 }}
	smooth_triangle { <210.8076, -2.4935, 22.5053>, <-0.401, -0.052, -0.914>, <201.3791, -2.1395, 25.8124>, <-0.109, 0.542, -0.833>, <207.2061, -4.3950, 23.3828>, <-0.270, 0.489, -0.829> texture { ICP35_black_2 }}
	smooth_triangle { <210.8076, -2.4935, 22.5053>, <-0.401, -0.052, -0.914>, <207.2061, -4.3950, 23.3828>, <-0.270, 0.489, -0.829>, <215.1401, -4.8060, 19.5529>, <-0.464, 0.424, -0.778> texture { ICP35_black_2 }}
	smooth_triangle { <207.2061, -4.3950, 23.3828>, <-0.270, 0.489, -0.829>, <201.3791, -2.1395, 25.8124>, <-0.109, 0.542, -0.833>, <197.2086, -4.9935, 23.0864>, <-0.096, 0.601, -0.794> texture { ICP35_black_2 }}
	smooth_triangle { <210.8076, -2.4935, 22.5053>, <-0.401, -0.052, -0.914>, <211.8251, -1.0760, 20.5089>, <-0.420, -0.725, -0.546>, <204.0581, -0.5145, 24.1733>, <-0.229, -0.807, -0.545> texture { ICP35_black_2 }}
	smooth_triangle { <210.8076, -2.4935, 22.5053>, <0.475, 0.311, 0.823>, <211.8251, -1.0760, 20.5089>, <0.339, 0.863, 0.375>, <217.1191, -3.1265, 18.3014>, <0.551, 0.284, 0.784> texture { ICP35_black_2 }}
	smooth_triangle { <210.8076, -2.4935, 22.5053>, <0.475, 0.311, 0.823>, <217.1191, -3.1265, 18.3014>, <0.551, 0.284, 0.784>, <215.1401, -4.8060, 19.5529>, <0.488, -0.507, 0.711> texture { ICP35_black_2 }}
	smooth_triangle { <211.8251, -1.0760, 20.5089>, <-0.420, -0.725, -0.546>, <217.1191, -3.1265, 18.3014>, <-0.711, -0.433, -0.554>, <216.6336, -1.8910, 16.6129>, <-0.527, -0.804, -0.277> texture { ICP35_black_2 }}
	smooth_triangle { <186.1276, -4.0415, 26.6894>, <0.317, -0.131, -0.939>, <180.8336, -3.4160, 24.2659>, <0.073, -0.001, -0.997>, <175.0456, -4.9935, 23.0864>, <0.317, -0.131, -0.939> texture { ICP35_black_2 }}
	smooth_triangle { <186.1276, -4.0415, 26.6894>, <0.134, 0.978, 0.162>, <180.8336, -3.4160, 24.2659>, <0.000, 0.968, 0.250>, <191.4206, -3.4160, 24.2659>, <0.152, 0.979, 0.138> texture { ICP35_black_2 }}
	smooth_triangle { <186.1276, -4.0415, 26.6894>, <0.243, 0.507, 0.827>, <191.4206, -3.4160, 24.2659>, <0.050, 0.148, 0.988>, <197.2086, -4.9935, 23.0864>, <0.317, 0.131, 0.939> texture { ICP35_black_2 }}
	smooth_triangle { <180.8336, -3.4160, 24.2659>, <0.073, -0.001, -0.997>, <191.4206, -3.4160, 24.2659>, <0.016, 0.356, -0.934>, <186.1276, -2.2845, 24.2639>, <-0.077, 0.355, -0.931> texture { ICP35_black_2 }}
	smooth_triangle { <180.3021, -6.2965, 24.2609>, <0.081, 0.702, -0.707>, <175.5411, -8.3100, 20.6938>, <0.127, 0.852, -0.508>, <186.1276, -8.4230, 21.2219>, <0.001, 0.857, -0.516> texture { ICP35_black_2 }}
	smooth_triangle { <180.3021, -6.2965, 24.2609>, <-0.255, -0.556, 0.791>, <175.5411, -8.3100, 20.6938>, <-0.130, -0.852, 0.507>, <170.2456, -6.6945, 20.7339>, <-0.163, -0.714, 0.681> texture { ICP35_black_2 }}
	smooth_triangle { <180.3021, -6.2965, 24.2609>, <-0.255, -0.556, 0.791>, <170.2456, -6.6945, 20.7339>, <-0.163, -0.714, 0.681>, <175.0456, -4.9935, 23.0864>, <-0.096, -0.601, 0.794> texture { ICP35_black_2 }}
	smooth_triangle { <175.5411, -8.3100, 20.6938>, <0.127, 0.852, -0.508>, <170.2456, -6.6945, 20.7339>, <0.126, 0.768, -0.628>, <167.2746, -8.1225, 17.9749>, <0.121, 0.842, -0.525> texture { ICP35_black_2 }}
	smooth_triangle { <191.9521, -6.2970, 24.2609>, <0.182, -0.643, 0.744>, <186.1276, -4.0415, 26.6894>, <0.317, 0.131, 0.939>, <197.2086, -4.9935, 23.0864>, <0.245, -0.219, 0.944> texture { ICP35_black_2 }}
	smooth_triangle { <191.9521, -6.2970, 24.2609>, <-0.101, 0.670, -0.735>, <186.1276, -4.0415, 26.6894>, <0.114, 0.821, -0.560>, <180.3021, -6.2965, 24.2609>, <0.081, 0.702, -0.707> texture { ICP35_black_2 }}
	smooth_triangle { <191.9521, -6.2970, 24.2609>, <-0.101, 0.670, -0.735>, <180.3021, -6.2965, 24.2609>, <0.081, 0.702, -0.707>, <186.1276, -8.4230, 21.2219>, <0.001, 0.857, -0.516> texture { ICP35_black_2 }}
	smooth_triangle { <180.3021, -6.2965, 24.2609>, <0.081, 0.702, -0.707>, <186.1276, -4.0415, 26.6894>, <0.230, 0.196, -0.953>, <175.0456, -4.9935, 23.0864>, <0.245, 0.219, -0.944> texture { ICP35_black_2 }}
	smooth_triangle { <191.9521, -6.2970, 24.2609>, <-0.101, 0.670, -0.735>, <202.0086, -6.6945, 20.7339>, <-0.186, 0.657, -0.731>, <197.2086, -4.9935, 23.0864>, <-0.096, 0.601, -0.794> texture { ICP35_black_2 }}
	smooth_triangle { <191.9521, -6.2970, 24.2609>, <0.182, -0.643, 0.744>, <202.0086, -6.6945, 20.7339>, <0.133, -0.766, 0.629>, <196.7136, -8.3100, 20.6938>, <0.157, -0.773, 0.615> texture { ICP35_black_2 }}
	smooth_triangle { <191.9521, -6.2970, 24.2609>, <0.182, -0.643, 0.744>, <196.7136, -8.3100, 20.6938>, <0.157, -0.773, 0.615>, <186.1276, -8.4230, 21.2219>, <0.001, -0.888, 0.461> texture { ICP35_black_2 }}
	smooth_triangle { <196.7136, -8.3100, 20.6938>, <0.157, -0.773, 0.615>, <202.0086, -6.6945, 20.7339>, <0.133, -0.766, 0.629>, <204.9801, -8.1225, 17.9749>, <0.121, -0.842, 0.525> texture { ICP35_black_2 }}
	smooth_triangle { <170.8746, -2.1390, 25.8124>, <0.299, -0.235, -0.925>, <177.5616, -0.4325, 26.5184>, <-0.003, 0.207, -0.978>, <168.1961, -0.5145, 24.1733>, <0.276, -0.611, -0.742> texture { ICP35_black_2 }}
	smooth_triangle { <170.8746, -2.1390, 25.8124>, <0.022, -0.647, 0.762>, <177.5616, -0.4325, 26.5184>, <0.056, -0.562, 0.825>, <180.8336, -3.4160, 24.2659>, <0.043, -0.616, 0.787> texture { ICP35_black_2 }}
	smooth_triangle { <170.8746, -2.1390, 25.8124>, <0.022, -0.647, 0.762>, <180.8336, -3.4160, 24.2659>, <0.043, -0.616, 0.787>, <175.0456, -4.9935, 23.0864>, <-0.096, -0.601, 0.794> texture { ICP35_black_2 }}
	smooth_triangle { <177.5616, -0.4325, 26.5184>, <-0.003, 0.207, -0.978>, <180.8336, -3.4160, 24.2659>, <0.073, -0.001, -0.997>, <186.1276, -2.2845, 24.2639>, <-0.077, 0.355, -0.931> texture { ICP35_black_2 }}
	smooth_triangle { <161.4471, -2.4930, 22.5053>, <0.413, 0.052, -0.909>, <155.1346, -3.1265, 18.3014>, <0.703, -0.148, -0.696>, <157.1136, -4.8055, 19.5529>, <0.451, 0.397, -0.800> texture { ICP35_black_2 }}
	smooth_triangle { <161.4471, -2.4930, 22.5053>, <-0.427, 0.620, 0.658>, <155.1346, -3.1265, 18.3014>, <-0.625, 0.504, 0.596>, <160.4286, -1.0760, 20.5089>, <-0.407, 0.763, 0.502> texture { ICP35_black_2 }}
	smooth_triangle { <161.4471, -2.4930, 22.5053>, <-0.427, 0.620, 0.658>, <160.4286, -1.0760, 20.5089>, <-0.407, 0.763, 0.502>, <168.1961, -0.5145, 24.1733>, <-0.229, 0.807, 0.545> texture { ICP35_black_2 }}
	smooth_triangle { <160.4286, -1.0760, 20.5089>, <-0.407, 0.763, 0.502>, <155.1346, -3.1265, 18.3014>, <-0.625, 0.504, 0.596>, <155.6196, -1.8910, 16.6129>, <-0.549, 0.742, 0.385> texture { ICP35_black_2 }}
	smooth_triangle { <165.0481, -4.3950, 23.3828>, <-0.132, -0.731, 0.669>, <170.8746, -2.1390, 25.8124>, <0.022, -0.647, 0.762>, <175.0456, -4.9935, 23.0864>, <-0.096, -0.601, 0.794> texture { ICP35_black_2 }}
	smooth_triangle { <165.0481, -4.3950, 23.3828>, <0.261, 0.461, -0.848>, <170.8746, -2.1390, 25.8124>, <0.299, -0.235, -0.925>, <161.4471, -2.4930, 22.5053>, <0.413, 0.052, -0.909> texture { ICP35_black_2 }}
	smooth_triangle { <165.0481, -4.3950, 23.3828>, <0.261, 0.461, -0.848>, <161.4471, -2.4930, 22.5053>, <0.413, 0.052, -0.909>, <157.1136, -4.8055, 19.5529>, <0.451, 0.397, -0.800> texture { ICP35_black_2 }}
	smooth_triangle { <161.4471, -2.4930, 22.5053>, <0.413, 0.052, -0.909>, <170.8746, -2.1390, 25.8124>, <0.299, -0.235, -0.925>, <168.1961, -0.5145, 24.1733>, <0.276, -0.611, -0.742> texture { ICP35_black_2 }}
	smooth_triangle { <165.0481, -4.3950, 23.3828>, <0.261, 0.461, -0.848>, <170.2456, -6.6945, 20.7339>, <0.126, 0.768, -0.628>, <175.0456, -4.9935, 23.0864>, <0.160, 0.560, -0.813> texture { ICP35_black_2 }}
	smooth_triangle { <165.0481, -4.3950, 23.3828>, <-0.132, -0.731, 0.669>, <170.2456, -6.6945, 20.7339>, <-0.163, -0.714, 0.681>, <161.6796, -6.5815, 19.8964>, <-0.146, -0.784, 0.603> texture { ICP35_black_2 }}
	smooth_triangle { <165.0481, -4.3950, 23.3828>, <-0.132, -0.731, 0.669>, <161.6796, -6.5815, 19.8964>, <-0.146, -0.784, 0.603>, <157.1136, -4.8055, 19.5529>, <-0.497, -0.529, 0.688> texture { ICP35_black_2 }}
	smooth_triangle { <161.6796, -6.5815, 19.8964>, <-0.146, -0.784, 0.603>, <170.2456, -6.6945, 20.7339>, <-0.163, -0.714, 0.681>, <167.2746, -8.1225, 17.9749>, <-0.103, -0.891, 0.443> texture { ICP35_black_2 }}
	smooth_triangle { <176.7001, 0.9373, 24.3924>, <0.065, -0.964, -0.257>, <186.1276, 0.6353, 26.0254>, <0.031, -0.935, -0.352>, <186.1271, 1.7213, 23.1418>, <0.021, -0.975, -0.221> texture { ICP35_black_2 }}
	smooth_triangle { <176.7001, 0.9373, 24.3924>, <-0.130, 0.852, 0.507>, <186.1276, 0.6353, 26.0254>, <0.010, 0.869, 0.495>, <177.5616, -0.4325, 26.5184>, <-0.111, 0.814, 0.570> texture { ICP35_black_2 }}
	smooth_triangle { <176.7001, 0.9373, 24.3924>, <-0.130, 0.852, 0.507>, <177.5616, -0.4325, 26.5184>, <-0.111, 0.814, 0.570>, <168.1961, -0.5145, 24.1733>, <-0.229, 0.807, 0.545> texture { ICP35_black_2 }}
	smooth_triangle { <186.1276, 0.6353, 26.0254>, <-0.113, 0.513, -0.851>, <177.5616, -0.4325, 26.5184>, <-0.003, 0.207, -0.978>, <186.1276, -2.2845, 24.2639>, <-0.077, 0.355, -0.931> texture { ICP35_black_2 }}
	smooth_triangle { <176.7006, 1.7593, 20.5428>, <0.091, -0.988, -0.124>, <177.5626, 1.8063, 16.0254>, <0.068, -0.995, 0.074>, <168.1951, 1.0479, 16.8518>, <0.125, -0.992, -0.012> texture { ICP35_black_2 }}
	smooth_triangle { <176.7006, 1.7593, 20.5428>, <-0.031, 0.998, 0.051>, <177.5626, 1.8063, 16.0254>, <-0.044, 0.997, -0.066>, <186.1271, 2.1278, 19.0298>, <-0.011, 1.000, 0.013> texture { ICP35_black_2 }}
	smooth_triangle { <176.7006, 1.7593, 20.5428>, <-0.031, 0.998, 0.051>, <186.1271, 2.1278, 19.0298>, <-0.011, 1.000, 0.013>, <186.1271, 1.7213, 23.1418>, <0.021, 0.975, 0.221> texture { ICP35_black_2 }}
	smooth_triangle { <186.1271, 2.1278, 19.0298>, <-0.011, 1.000, 0.013>, <177.5626, 1.8063, 16.0254>, <-0.044, 0.997, -0.066>, <186.1276, 1.9133, 14.8583>, <-0.016, 0.993, -0.115> texture { ICP35_black_2 }}
	smooth_triangle { <167.2731, 0.5838, 21.0858>, <-0.197, 0.956, 0.217>, <176.7001, 0.9373, 24.3924>, <-0.130, 0.852, 0.507>, <168.1961, -0.5145, 24.1733>, <-0.229, 0.807, 0.545> texture { ICP35_black_2 }}
	smooth_triangle { <167.2731, 0.5838, 21.0858>, <0.160, -0.960, -0.229>, <176.7001, 0.9373, 24.3924>, <0.065, -0.964, -0.257>, <176.7006, 1.7593, 20.5428>, <0.091, -0.988, -0.124> texture { ICP35_black_2 }}
	smooth_triangle { <167.2731, 0.5838, 21.0858>, <0.160, -0.960, -0.229>, <176.7006, 1.7593, 20.5428>, <0.091, -0.988, -0.124>, <168.1951, 1.0479, 16.8518>, <0.125, -0.992, -0.012> texture { ICP35_black_2 }}
	smooth_triangle { <176.7006, 1.7593, 20.5428>, <0.091, -0.988, -0.124>, <176.7001, 0.9373, 24.3924>, <0.065, -0.964, -0.257>, <186.1271, 1.7213, 23.1418>, <0.021, -0.975, -0.221> texture { ICP35_black_2 }}
	smooth_triangle { <167.2731, 0.5838, 21.0858>, <0.160, -0.960, -0.229>, <160.4286, -1.0760, 20.5089>, <0.284, -0.912, -0.295>, <168.1961, -0.5145, 24.1733>, <0.276, -0.611, -0.742> texture { ICP35_black_2 }}
	smooth_triangle { <167.2731, 0.5838, 21.0858>, <-0.197, 0.956, 0.217>, <160.4286, -1.0760, 20.5089>, <-0.407, 0.763, 0.502>, <160.4286, -0.3300, 17.0114>, <-0.211, 0.968, 0.137> texture { ICP35_black_2 }}
	smooth_triangle { <167.2731, 0.5838, 21.0858>, <-0.197, 0.956, 0.217>, <160.4286, -0.3300, 17.0114>, <-0.211, 0.968, 0.137>, <168.1951, 1.0479, 16.8518>, <-0.131, 0.990, -0.045> texture { ICP35_black_2 }}
	smooth_triangle { <160.4286, -1.0760, 20.5089>, <0.284, -0.912, -0.295>, <160.4286, -0.3300, 17.0114>, <0.264, -0.964, -0.033>, <155.6196, -1.8910, 16.6129>, <0.364, -0.927, -0.093> texture { ICP35_black_2 }}

}}

 object { marienkaefer scale 0.00015 rotate <100,-90,110> translate <-0.31,-0.010,-11.84> }
