// Persistence of Vision Ray Tracer include
// Version: 3
// Description: Fichier ballustres balcon, ballustrade.
// Date: 07/2000
// Auteur: Danneel Luc
/*

Exemple :

#declare Deco = texture { T_Stone18 }
#declare Base = 
	 texture {
         pigment { color White }
         finish { ambient .4}
         }
#declare Number = 5 //nombre de ballustres.
#include "Balustre.inc"

union {
object { Pilier_gauche }
object { Rang translate x*35}
object { Pilier_centre translate x*(35+(Number*25))}
object { Rang translate x*((35*2)+(Number*25))}
object { Pilier_droit translate x*((35*2)+(Number*50))}
rotate y*-30
}
*/

#include "vasetest.pov"
#declare Ballustre =  //dimensions au sol:Hauteur = 82.5, Largeur = 25, Profondeur = 30,pt 0 coin avant gauche.
                      //Dimensionen am Boden: Hhe = 82.5, Breite = 25, Tiefe = 30, pt 0 Ecke vor Linke
union {
      difference {
                 box { 0 <25, 15, 30> }
                 cylinder { -.005 <25.005, 0, 0> 5 translate y*15 }
                 cylinder { -.005 <25.005, 0, 0> 5 translate <0, 15, 30> }
                 }
      box { 0 <15, 3, 15> translate <5, 15, 7.5> texture { Deco scale <15, 3, 15>} }
      difference {
                 cylinder { 0 <0, 5, 0> 7.5 }
                 torus { 7.5, 3 scale <1, 1.5, 1> translate y*5 }
                 translate <12.5, 18, 15>
                 }

      torus { 5, 1.5 translate <12.5, 23, 15> }
      difference {
                 union {
                 sphere { 0, 7.5  }
                 cylinder { 0 <0, 40, 0> 7.5 }
                 }
                 torus { 7.5, 5 scale <1, 5.5, 1> translate y*30}
                 translate <12.5, 30, 15>
                 }
      torus { 2.5, .5 translate <12.5, 62, 15> }
      torus { 2.5, 1.5 translate <12.5, 64.5, 15> }
      box { 0 <15, 3, 15> translate <5, 67.5, 7.5> }
      union {
            box { 0 <25, 2, 15> translate <0, 10, 5> texture { Deco scale <15, 3, 15>} }
            difference {
                       box { 0 <25, 10, 25> }
                       cylinder { -.005 <25.005, 0, 0> 2.5 }
                       cylinder { -.005 <25.005, 0, 0> 2.5 translate y*10 }
                       cylinder { -.005 <25.005, 0, 0> 2.5 translate z*25 }
                       cylinder { -.005 <25.005, 0, 0> 2.5 translate <0, 10, 25> }
                       }
            translate <0, 70.5, 2.5>
             }
      texture {Base }
}

#declare Ballustre_coin = //dimensions au sol:Hauteur = 82.5, Largeur = 30, Profondeur = 30,pt 0 coin avant gauche.
union {                   //Dimensionen am Boden: Hhe = 82.5, Breite = 30, Tiefe = 30, pt 0 Ecke vor Linke
      difference {
                 box { 0 <30, 15, 30> }
                 cylinder { -.005 <30.005, 0, 0> 5 translate y*15 }
                 cylinder { -.005 <0, 0, 30.005> 5 translate y*15 }
                 cylinder { -.005 <30.005, 0, 0> 5 translate <0, 15, 30> }
                 }
      box { 0 <15, 3, 15> translate <7.5, 15, 7.5> texture { Deco scale <15, 3, 15>} }
      difference {
                 cylinder { 0 <0, 5, 0> 7.5 }
                 torus { 7.5, 3 scale <1, 1.5, 1> translate y*5 }
                 translate <15, 18, 15>
                 }
      torus { 5, 1.5 translate <15, 23, 15> }
      difference {
                 union {
                 sphere { 0, 7.5  }
                 cylinder { 0 <0, 40, 0> 7.5 }
                 }
                 torus { 7.5, 5 scale <1, 5.5, 1> translate y*30}
                 translate <15, 30, 15>
                 }
      torus { 2.5, .5 translate <15, 62, 15> }
      torus { 2.5, 1.5 translate <15, 64.5, 15> }
      box { 0 <15, 3, 15> translate <7.5, 67.5, 7.5> }
      union {
            box { 0 <20, 2, 15> translate <5, 10, 5> texture { Deco scale <15, 3, 15>} }
            box { 0 <15, 2, 20> translate <5, 10, 5> texture { Deco scale <15, 3, 15>} }
            difference {
                       box { 0 <25, 10, 25> }
                       cylinder { -.005 <25.005, 0, 0> 2.5 }
                       cylinder { -.005 <25.005, 0, 0> 2.5 translate y*10 }
                       cylinder { -.005 <0, 0, 25.005> 2.5 }
                       cylinder { -.005 <0, 0, 25.005> 2.5 translate y*10 }
                       cylinder { -.005 <25.005, 0, 0> 2.5 translate <0, 10, 25>}
                       cylinder { -.005 <25.005, 0, 0> 2.5 translate z*25 }
                       }
            translate <2.5, 70.5, 2.5>
             }
      texture {Base }
}

//PILIER DE COIN 35X35 au sol et 97 de haut. Point 0 au coin avant gauche au sol.
//ECK Pfeiler 35X35 am Boden und 97 von oberem Teil. Punkt 0 an der Ecke vor Linke am Boden
#declare Moulure =
difference {
box { .005 <25, 60, 2> }
cylinder { 0, z*2, 5}
cylinder { 0, z*2, 5 translate x*25}
cylinder { 0, z*2, 5 translate y*60}
cylinder { 0, z*2, 5 translate <25, 60, 0>}
texture { Deco scale <15, 3, 15>}}

#declare Cote = 35;

#declare Coin =   // Four=Eck
union {
sphere { 0, 2.5}
cylinder { 0, y*60, 2.5}
sphere { 0, 2.5 translate y*60}
texture {Deco}}

#declare FourCoin =   // FourCoin=Ofen Ecke
union {
object { Coin }
object { Coin translate x*Cote}
object { Coin translate <Cote, 0, Cote> }
object { Coin translate z*Cote}
translate y*20
texture { Base }
}

#declare Pilier_gauche = //Pilier_gauche=Linker Pfeiler
difference { 
union {
box { 0 <Cote, 92, Cote> }
box { 0 <45, 5, 45> translate <-5, 92, -5> texture { Deco scale <15, 3, 15>}}
sphere {<0, 0, 0>,4 scale <4,4,4> translate < 17.5,110,17.5> texture { T_Stone21}}//Deco }}//****************************TEST
texture { Base } //Base=Basis
}
object { Moulure translate <5, 20, -.01> }
object { Moulure rotate y*90 translate <-.01, 20, 30> }
object { FourCoin }
translate z*-2.5
}

#declare Pilier_centre = //Pilier_centre=Pfeiler zentriert
difference {
union {
box { 0 <Cote, 92, Cote> }
box { 0 <45, 5, 45> translate <-5, 92, -5> texture { Deco scale <15, 3, 15>}}
sphere {<0, 0, 0>,4 scale <4,4,4> translate < 17.5,110,17.5> texture { T_Stone21}}//Deco }}//****************************TEST
texture { Base }
}
object { Moulure translate <5, 20, -.01> }//Moulure=Profilleiste
object { Moulure translate <5, 20, 33.01> }//Moulure=Profilleiste
object { FourCoin }// FourCoin=Ofen Ecke
translate z*-2.5
}

#declare Pilier_droit =  //Gerader Pfeiler
difference {
union {
box { 0 <Cote, 92, Cote> }//Cote =Quote
box { 0 <45, 5, 45> translate <-5, 92, -5> texture { Deco scale <15, 3, 15>}}
sphere {<0, 0, 0>,4 scale <4,4,4> translate < 17.5,110,17.5> texture { T_Stone21}}//Deco }}//****************************TEST
texture { Base }
}
object { Moulure translate <5, 20, -.01> }//Moulure=Profilleiste
object { Moulure rotate y*-90 translate <35.01, 20, 5> }//Moulure=Profilleiste
object { FourCoin }// FourCoin=Ofen Ecke
translate z*-2.5
}


#declare Rang =  //Rang=Reihe
union {
#declare Decale = 0;
#while   (Decale < (25*Number))
object { Ballustre translate x*Decale}
#declare Decale = Decale + 25;
#end
}