/*
 *	Box.pov
 *
 *	"An Offering to the POV-Ray Gods"
 *
 *	Created for the Jan-Feb 2001 IRTC topic "Worship"
 *	Copyright (c) 2001 Mark Wagner
 */

#declare cm = 1/2.54;		/* 1 POV unit = 1 inch */
#include "units.inc"
#include "clothutil.inc"

#macro WriteClothFile(nomfile, n1, n2, nlng, ks)
	#fopen file nomfile write
	#local tempx=0;
	#local tempy=0;
	#local tempz=0;
	#write(file, n1, ",", n2, ",", nlng, ",", ks, ",\n")

	#local l1 = nlng*(n1-1);
	#local l2 = nlng*(n2-1);
	#local h = 3*feet;
	#local st = seed(1234);
	#local i=0;
	#while (i<n1)
		#local j=0;
		#while (j<n2)
			#local tempx = -l1/2 + i*nlng;
			#local tempz = -l2/2 + j*nlng;
			#local tempy = h -.005+.01*rand(st);
			#write(file, tempx, ",", tempy, ",", tempz, ", 0.0, 0.0, 0.0\n")
			#local j=j+1;
		#end
		#local i=i+1;
	#end
	#fclose file
#end


#declare Box = box{<-1.9,2.9,-.9>*feet,<1.9,3,.9>*feet}

//WriteClothFile("box.cth",160, 160, .5*inch, 20)
#declare dummy = clothsim(Box, -y, -y, 1, .9, .05, 1000, "box.cth", "box.cth");
#undef Points
ReadClothFile("box.cth")

union{
	object{Box pigment{rgb <1,1,0>}}
	mesh{
		DrawTriangles(Points,160,160,off,0,0)
		scale 1.1
		pigment{rgb 1}
	}
}

#declare ViewFromAbove = camera{ /* God-s-eye view */
	location <5,20,10>*feet
	look_at <.3,2.35,-1.2>*feet
	angle 45
}

camera{ViewFromAbove}

light_source{<100,100,100>*feet, 1}