#ifndef(included)
	#declare included = true;
	#declare cm = .1;
	
	#include "units.inc"
	#include "colors.inc"
	#include "textures.inc"
	#include "metals.inc"
	#undef included
#end
	
#version unofficial MegaPOV 0.5;

#declare WhiteWax = texture{
	pigment{ rgb 1 }
	finish{
		diffuse .8
		phong .7
		phong_size 150
	}
}

// >>> T_Wood7 (from File "woods.inc") <<<

// Constants from file "woods.inc"
#declare P_WoodGrain7A = pigment {
  wood
  turbulence <0.05, 0.08, 1000>
  octaves 4
  scale <0.15, .15, 1>
}

// Constants from file "woodmaps.inc"
#declare M_Wood7A = color_map {
  [0.0, 0.1 color rgb <0.60, 0.35, 0.20>
  color rgb <0.60, 0.35, 0.20>]
  [0.1, 0.9 color rgb <0.60, 0.35, 0.20>
  color rgb <0.90, 0.65, 0.30>]
  [0.9, 1.0 color rgb <0.90, 0.65, 0.30>
  color rgb <0.60, 0.35, 0.20>]
}

// Constants from file "woods.inc"
#declare P_WoodGrain7B = pigment {
	bozo
	scale <0.01, 0.01, 100000>
}

// Constants from file "woodmaps.inc"
#declare M_Wood7B = color_map {
	[0.0, 0.1 color rgbt <0.90, 0.65, 0.30, 0.00>
		color rgbt <0.90, 0.65, 0.30, 0.30>]
	[0.1, 1.0 color rgbt <0.90, 0.65, 0.30, 0.30>
		color rgbt <1.00, 1.00, 1.00, 1.00> ] 
}

#declare T_Wood7 = texture {
	pigment {
		P_WoodGrain7A color_map {
			M_Wood7A 
		}
	}
	finish{ambient 0}
}
texture {
	pigment {
		P_WoodGrain7B color_map {
			M_Wood7B 
		}
	}
	finish{ambient 0}
}

// >>> T_Wood14 (from File "woods.inc") <<<

// Constants from file "woodmaps.inc"
#declare M_Wood14A = colour_map {
  [0.00 0.10 color rgb < 0.80, 0.232, 0.115 >
  color rgb < 0.80, 0.232, 0.115 >]
  [0.10 0.90 color rgb < 0.80, 0.232, 0.115 >
  color rgb < 0.45, 0.115, 0.060 >]
  [0.90 1.0 color rgb < 0.45, 0.115, 0.060 >
  color rgb < 0.45, 0.115, 0.060 >]
}

// Constants from file "woods.inc"
#declare P_WoodGrain14A = pigment {
  wood
  colour_map {
    M_Wood14A 
  }
  turbulence 0.065
  octaves 2
  scale <0.15, .15, 1>
  translate < -1 0 0 >
  rotate <-3, -3, 0>
}

// Constants from file "woodmaps.inc"
#declare M_Wood14B = colour_map {
	[0.00 0.10 color rgbt < 0.70, 0.232, 0.115, 0.5 >
		color rgbt < 0.70, 0.232, 0.115, 0.7 >]
	[0.10 0.15 color rgbt < 0.70, 0.232, 0.115, 0.7 >
		color rgbt < 0.35, 0.115, 0.060, 0.9 >]
	[0.15 0.20 color rgbt < 0.70, 0.232, 0.115, 0.9 >
		color rgbt < 0.35, 0.115, 0.060, 0.7 >]
	[0.20 1.0 color rgbt < 0.35, 0.115, 0.060, 0.7 >
		color rgbt < 0.35, 0.115, 0.060, 0.5 >]
}

// Constants from file "woods.inc"
#declare P_WoodGrain14B = pigment {
	wood
	colour_map {
		M_Wood14B 
	}
	turbulence <0, 0.1, 0>
	lambda 2.75
	omega 1.15
	octaves 4
	scale <5, 0.075, 1>
	rotate x*90
}

#declare T_Wood14 = texture {
  pigment {
    P_WoodGrain14A color_map {
      M_Wood14A 
    }
  }
  finish{ambient 0}
}
texture {
  pigment {
    P_WoodGrain14B color_map {
      M_Wood14B 
    }
  }
  finish{ambient 0}
}


// >>> EMBWood1 (from File "textures.inc") <<<
#declare EMBWood1 = texture {
	pigment {
		wood
		turbulence 0.05
		color_map {
			[0.00 rgb <0.58, 0.45, 0.23>]
			[0.34 rgb <0.65, 0.45, 0.25>]
			[0.40 rgb <0.33, 0.23, 0.13>]
			[0.47 rgb <0.60, 0.40, 0.20>]
			[1.00 rgb <0.25, 0.15, 0.05>]
		}
	}
	finish {
		crand 0.02
		ambient 0
		diffuse 0.93
		phong 0.2
		phong_size 10
	}
	normal {
		bumps 0.05 
	}
}
texture {
	pigment {
		bozo
		color_map {
			[0.0 rgbt <1.00, 1.00, 1.00, 1.00>]
			[0.8 rgbt <1.00, 0.90, 0.80, 0.80>]
			[1.0 rgbt <0.30, 0.20, 0.10, 0.40>]
		}
		scale 0.25
	}
	finish{ambient 0}
}



#declare CandleStick1 = difference{
	union{
		lathe{
			cubic_spline
			10,<-.1,0>*feet,<0,0>*feet,<.13,0>*feet,<.03,.08>*feet,
			<.03,.45>*feet,<.07.47>*feet,<.07,.60>*feet,
			<.08,.61>*feet,<0,.60>*feet,<-.1,.60>*feet
		}
		sphere{ y*.15*feet,.04*feet }
	}
	cylinder{ y*.61*feet,y*.53*feet,.06*feet }
	texture{Tinny_Brass}
}

#declare CandleStick2 = difference{
	union{
		lathe{
			cubic_spline
			10,<-.1,0>*feet,<0,0>,<.13,0>*feet,<.03,.07>*feet,
			<.03,.25>*feet,<.07.27>*feet,<.07,.40>*feet,
			<.08,.41>*feet,<0,.40>*feet,<-.1,.40>*feet
		}
		sphere{ y*.13*feet,.04*feet }
	}
	cylinder{ y*.41*feet,y*.33*feet,.06*feet }
	texture{Tinny_Brass}
}

#declare Candle1 = union{
	difference{
		union{
			cylinder{ 0,y*.05*feet,.06*feet }
			cone{ y*.05*feet,.06*feet,y*.6*feet,.05*feet }
		}
		sphere{ y*.59*feet,.048*feet }
		texture{ WhiteWax }
	}
	//Wick
	cylinder{ y*.54*feet,y*.64*feet, .01*feet pigment{ Black } }
}

#declare Candle_Stick1 = union{
	union{
		object{ CandleStick1 } 
		object{ Candle1 translate y*.54*feet}
	}
	sphere{ 0, 2*cm pigment{rgbt 1} finish{ambient <1,1,1> diffuse 0} hollow
		interior{
			media{
				emission <1,1,1>/cm
				absorption <1,1,1>/cm
				method 3
				density{ spherical
					scale 2*cm
					color_map{
						[0 rgb <0,0,0>]
						[.4 rgb <1,.5,0>]
						[.9 rgb <1,1,0>]
						[1 rgb <0,0,0> ]
					}
				}
				samples 1,10
				confidence .9999
				variance 1/1000
				translate y*-1*cm
			}
		}
		scale <1,3,1>
		translate y*(.54*feet+.61*feet+6*cm)
	}
	light_source{
		y*(.54*feet+.61*feet+6*cm)
		rgb <1,1,.5>
		fade_distance 6*inch
		fade_power 2 
	}
}

#ifndef(included)
	object{Candle_Stick1}
	camera{location 2*feet look_at y*1*feet}
#end