// Persistence Of Vision INCLUDE file
// File:        beartex.inc
// Vers:        3.1 Mac PPC
// Desc:        Textures for bears (from the old pdmeyes.pov)
// Auth:        Peter Murray
// Date:        12-27 January 2001

#debug "\r  beartex.inc - Textures for bears.\r"

// Alphabetically-ordered textures (macro textures at the end)
// A

#declare AltarCloth=
texture{
	pigment{colour rgb <0.60,0.40,0.60>}
	finish{
		reflection 0.1
	}
	normal{
		wrinkles .5*in
	}
}

#declare AltarFrontal=
texture{
	pigment{colour rgb <0.80,0.20,0.20>}
	finish{
		reflection 0.1
	}
	normal{
		wrinkles .5*in
	}
}

// B

#declare BarryFur=
texture{
  normal {
    ripples 2 turbulence 0.5 omega 1 lambda 4
    rotate <5,10,15>
  }
  pigment {
    granite
    colour_map {
      [0.0 colour rgb <.75,.45,.20>]
      [0.3 colour rgb <.80,.50,.15>]
      [0.6 colour rgb <.85,.55,.25>]
      [1.0 colour rgb <.75,.50,.20>]
    }
    scale .5
  }
}

#declare BeatriceFur=
texture{
  normal{
		ripples 2 turbulence 0.5 omega 1 lambda 4
		rotate <30,20,10>
  }
  pigment{
		agate
		colour_map{
	  	[0.00 colour rgb <0.90,0.90,0.90>]
		  [0.25 colour rgb <0.60,0.60,0.80>]
		  [0.50 colour rgb <0.80,0.80,0.80>]
	  	[0.75 colour rgb <0.90,0.90,1.00>]
	  	[1.00 colour rgb <1.00,1.00,1.00>]
		}
		scale 0.25
  }
  finish{ambient .1 brilliance .2 diffuse .4
    specular .1 roughness .1 reflection .1
    irid{0.15 thickness .25 turbulence .25}
  }
}

#declare BelaFur=
texture{
  normal {
    ripples 2 turbulence 0.5 omega 1 lambda 4
    rotate <30,20,10>
  }
  pigment {
    granite
    colour_map {
      [0.0 colour rgb <.20,.65,.75>]
      [0.3 colour rgb <.15,.75,.80>]
      [0.6 colour rgb <.25,.80,.85>]
      [1.0 colour rgb <.20,.75,.80>]
    }
    scale .5
  }
}

#declare BeltTx=
texture{
	pigment{colour rgb <0.1,0.1,0.1>}
}

#declare BernieFur=
texture{
  normal {
    ripples 2 turbulence 0.5 omega 1 lambda 4
    rotate <5,10,15>
  }
  pigment {
    granite
    colour_map {
      [0.0 colour rgb <.75,.55,.20>]
      [0.3 colour rgb <.80,.60,.15>]
      [0.6 colour rgb <.85,.65,.25>]
      [1.0 colour rgb <.75,.60,.20>]
    }
    scale .5
  }
}

#declare BillyFur=
texture{
  normal {
    ripples 2 turbulence 0.5 omega 1 lambda 4
    rotate <30,20,10>
  }
  pigment {
    granite
    colour_map {
      [0.0 colour rgb <0.75,0.75,0.75>]
      [0.3 colour rgb <0.80,0.75,0.95>]
      [0.6 colour rgb <0.85,0.80,0.85>]
      [1.0 colour rgb <0.80,0.75,1.00>]
    }
    scale .5
  }
}

#declare BishopAlbTx=
texture{
	pigment{colour rgb <1.00,1.00,1.00>}
	finish{
		reflection 0.1 irid{0.25 thickness .15 turbulence .25}
	}
	normal{
		wrinkles .5*in
	}
}

#declare BishopBeltTx=
texture{
	pigment{colour rgb <1.00,1.00,1.00>}
	finish{
		reflection 0.1 irid{0.25 thickness .15 turbulence .25}
	}
	normal{
		gradient y scale <0.05,0.1,0.05>
	}
}

#declare BishopCopeTx=
texture{
	pigment{
		agate agate_turb 0.5
		colour_map{
			[0.00 colour rgb <0.00,0.00,0.00>]
			[0.40 colour rgb <0.00,0.05,0.00>]
			[0.60 colour rgb <0.00,0.00,0.00>]
			[1.00 colour rgb <0.00,0.05,0.00>]
		}
		scale 0.25
	}
	finish{
		reflection 0.1 irid{0.25 thickness .15 turbulence .25}
	}
	normal{
		wrinkles .5*in
	}
}

#declare BishopRedTx=
texture{
	pigment{
		agate agate_turb 0.5
		colour_map{
			[0.00 colour rgb <0.80,0.00,0.00>]
			[0.40 colour rgb <0.80,0.05,0.00>]
			[0.60 colour rgb <0.80,0.00,0.00>]
			[1.00 colour rgb <0.75,0.05,0.00>]
		}
		scale 0.25
	}
	finish{
		reflection 0.1 irid{0.25 thickness .15 turbulence .25}
	}
	normal{
		wrinkles .5*in
	}
}

#declare Blip2Fur=
texture{
  normal{
		ripples 2 turbulence 0.5 omega 1 lambda 4
		rotate <30,20,10>
  }
  pigment{colour rgb <0.5,0.5,0.5>}
  finish{
  	ambient .1 brilliance .2 diffuse .4
		specular .1 roughness .1 reflection .1}
}
texture{
	pigment{
		gradient x
		colour_map{
		  [0.0 colour rgbf <1.0,1.0,1.0,1>]
		  [0.9 colour rgbf <1.0,1.0,1.0,1>]
		  [1.0 colour rgbf <0.0,1.0,0.0,0>]
		}                             
		scale 0.1
	}
}
texture{
	pigment{
		gradient y
		colour_map{
		  [0.0 colour rgbf <1.0,1.0,1.0,1>]
		  [0.9 colour rgbf <1.0,1.0,1.0,1>]
		  [1.0 colour rgbf <0.0,1.0,0.0,0>]
		}                             
		scale 0.1
	}
}

#declare BlipFur=
texture{
  normal{
		ripples 2 turbulence 0.5 omega 1 lambda 4
		rotate <30,20,10>
  }
  pigment{
		agate
		colour_map{
		  [0.0 colour rgb <.05,.03,.00>]
		  [0.3 colour rgb <.07,.05,.00>]
		  [0.6 colour rgb <.13,.11,.00>]
		  [1.0 colour rgb <.10,.08,.00>]
		}
		scale .5
  }
  finish{
  	ambient .1 brilliance .2 diffuse .4
		specular .1 roughness .1 reflection .1}
}
texture{
	pigment{
		gradient x
		colour_map{
		  [0.0 colour rgbf <1.0,1.0,1.0,1>]
		  [0.9 colour rgbf <1.0,1.0,1.0,1>]
		  [1.0 colour rgbf <0.0,1.0,0.0,0>]
		}                             
		scale 0.1
	}
}
texture{
	pigment{
		gradient y
		colour_map{
		  [0.0 colour rgbf <1.0,1.0,1.0,1>]
		  [0.9 colour rgbf <1.0,1.0,1.0,1>]
		  [1.0 colour rgbf <0.0,1.0,0.0,0>]
		}                             
		scale 0.1
	}
}

#declare BlossomDress=
texture{
	pigment{
		radial frequency 25
		colour_map{
			[0.00 colour rgb <1.00,1.00,1.00>]
			[0.70 colour rgb <1.00,1.00,1.00>]
			[0.80 colour rgb <0.90,0.45,0.40>]
			[0.90 colour rgb <1.00,1.00,1.00>]
			[1.00 colour rgb <0.90,0.45,0.40>]
		}
	}
	normal{
		wrinkles .5*in
	}
}

#declare Blossom2Fur=
texture{
  normal {
    ripples 2 turbulence 0.5 omega 1 lambda 4
    rotate <30,20,10>
  }
  pigment {
    spotted
    colour_map {
      [0.0 colour rgb <.85,.50,.50>*1.1]
      [0.3 colour rgb <.85,.50,.50>*1.1]
      [0.6 colour rgb <.85,.50,.50>*1.1]
      [1.0 colour rgb <.85,.50,.50>*1.1]
    }
    scale .5
  }
}

#declare BlossomFur=
texture{
  normal {
    ripples 2 turbulence 0.5 omega 1 lambda 4
    rotate <30,20,10>
  }
  pigment {
    spotted
    colour_map {
      [0.0 colour rgb <.85,.50,.50>*1.2]
      [0.3 colour rgb <.85,.50,.50>*1.2]
      [0.6 colour rgb <.85,.50,.50>*1.2]
      [1.0 colour rgb <.85,.50,.50>*1.2]
    }
    scale .5
  }
}

#declare BlueCheck=
texture{
	pigment{
		gradient y
		colour_map{
			[0.00 colour rgb <1.00,1.00,1.00>]
			[0.70 colour rgb <1.00,1.00,1.00>]
			[0.80 colour rgb <0.45,0.45,0.90>]
			[0.90 colour rgb <1.00,1.00,1.00>]
			[1.00 colour rgb <0.40,0.45,0.90>]
		}
		scale 0.15
	}
	normal{
		wrinkles .5*in
	}
}
texture{
	pigment{
		radial frequency 25
		colour_map{
			[0.00 colour rgbf <1.00,1.00,1.00,1>]
			[0.70 colour rgbf <1.00,1.00,1.00,1>]
			[0.80 colour rgbf <0.40,0.45,0.90,0>]
			[0.90 colour rgbf <1.00,1.00,1.00,1>]
			[1.00 colour rgbf <0.40,0.45,0.90,0>]
		}
	}
}

#declare BlueCheck2=
texture{
	pigment{
		gradient y
		colour_map{
			[0.00 colour rgb <1.00,1.00,1.00>]
			[0.33 colour rgb <1.00,1.00,1.00>]
			[0.34 colour rgb <0.45,0.45,0.90>]
			[0.36 colour rgb <0.45,0.45,0.90>]
			[0.37 colour rgb <1.00,1.00,1.00>]
			[0.70 colour rgb <1.00,1.00,1.00>]
			[0.80 colour rgb <0.45,0.45,0.90>]
			[0.90 colour rgb <1.00,1.00,1.00>]
			[1.00 colour rgb <0.40,0.45,0.90>]
		}
		scale 0.15
	}
	normal{
		wrinkles .5*in
	}
}
texture{
	pigment{
		radial frequency 25
		colour_map{
			[0.00 colour rgbf <1.00,1.00,1.00,1>]
			[0.33 colour rgbf <1.00,1.00,1.00,1>]
			[0.34 colour rgbf <0.40,0.45,0.90,0>]
			[0.36 colour rgbf <0.40,0.45,0.90,0>]
			[0.37 colour rgbf <1.00,1.00,1.00,1>]
			[0.70 colour rgbf <1.00,1.00,1.00,1>]
			[0.80 colour rgbf <0.40,0.45,0.90,0>]
			[0.90 colour rgbf <1.00,1.00,1.00,1>]
			[1.00 colour rgbf <0.40,0.45,0.90,0>]
		}
	}
}

#declare BonnieFur=
texture{
  normal {
    ripples 2 turbulence 0.5 omega 1 lambda 4
    rotate <5,10,15>
  }
  pigment {
    agate
    colour_map {
      [0.0 colour rgb <.75,.60,.20>]
      [0.3 colour rgb <.80,.70,.15>]
      [0.6 colour rgb <.85,.75,.25>]
      [1.0 colour rgb <.75,.70,.20>]
    }
    scale .5
  }
}

#declare BosieRobes=
texture{
	pigment{
		crackle turbulence 0.5 omega 0.5 lambda 3.0 octaves 6
    colour_map {
      [0.0 colour <0.5,0.5,1.0>]
      [0.3 Silver]
      [0.6 colour <0.5,0.5,1.0>]
      [1.0 Gold]
    }
    scale 0.15
	}
	finish{
		reflection 0.1 irid{0.25 thickness .15 turbulence .25}
	}
	normal{
		wrinkles .5*in
	}
}

#declare BosieRobes2=
texture{
	pigment{White filter 0.5}
	finish{
		reflection 0.1 irid{0.25 thickness .15 turbulence .25}
	}
	normal{
		wrinkles .5*in
	}
}

#declare BosieWindow=
texture{
  pigment{
    image_map{
  		png "bosie.png" once
  		map_type 0 //interpolate 2
  		//filter all 0.9
  		transmit all 0.9
		}
		scale <6,6.5,1> translate <-3,-0,0>*in
	}
  finish{
		ambient 0.1
		reflection .25
		//specular 1
		roughness 0.001
	}
}
texture{
	pigment{
		crackle scale <0.3,0.8,1> //turbulence 0.5
    colour_map{
    	[0.00 colour rgbf <0.1,0.1,0.1,0.0>]
    	[0.09 colour rgbf <0.1,0.1,0.1,0.0>]
    	[0.10 colour rgbf <1.0,1.0,1.0,1.0>]
    	[1.00 colour rgbf <1.0,1.0,1.0,1.0>]
    }
	}
}

#declare BrandyFur=
texture{
  normal {
    ripples 2 turbulence 0.5 omega 1 lambda 4
    rotate <30,20,10>
  }
  pigment {
    spotted
    colour_map {
      [0.0 colour rgb <.75,.65,.20>]
      [0.3 colour rgb <.80,.75,.15>]
      [0.6 colour rgb <.85,.80,.25>]
      [1.0 colour rgb <.80,.75,.20>]
    }
    scale .5
  }
}

#declare BrownShoe=
texture{
	pigment{
		colour rgb <0.3,0.15,0.0>
	}
	finish{
		reflection 0.25
	}
}

// C
// D
// E

#declare EvilEyeTx=
texture{
  pigment{rgb <.8,0,0>}
  finish{ambient 1 brilliance .2 diffuse .4
    specular .2 roughness .1 reflection .3}
}

#declare EyeBlackTx=
texture{
	pigment{rgb <0,0,0>}
	finish{
		reflection 0.1 phong 0.75 phong_size 50
	}
}

#declare EyeBlueTx=
texture{
	pigment{
		onion colour_map{
			[0.00 colour rgb <0,0,0>]
			[0.50 colour rgb <0,0,0>]
			[0.51 colour rgb <0.4,0.4,0.8>]
			[1.00 colour rgb <0.4,0.4,0.8>]
		}
		scale <0.11,0.1,10>
		translate <0,0.03,0>
	}
	finish{
		reflection 0.1 phong .75 phong_size 150
	}
}

#declare EyeBrownTx=
texture{
	pigment{
		onion colour_map{
			[0.00 colour rgb <0,0,0>]
			[0.50 colour rgb <0,0,0>]
			[0.51 colour rgb <0.6,0.3,0>]
			[1.00 colour rgb <0.6,0.3,0>]
		}
		scale <0.11,0.1,10>
		translate <0,0.03,0>
	}
	finish{
		reflection 0.1 phong .75 phong_size 150

	}
}

#declare EyeGreenTx=
texture{
	pigment{
		onion colour_map{
			[0.00 colour rgb <0,0,0>]
			[0.50 colour rgb <0,0,0>]
			[0.51 colour rgb <0.0,0.5,0>]
			[1.00 colour rgb <0.0,0.5,0>]
		}
		scale <0.11,0.1,10>
		translate <0,0.03,0>
	}
	finish{
		reflection 0.1 phong .75 phong_size 150
	}
}

#declare EyeLtBrownTx=
texture{
	pigment{
		onion colour_map{
			[0.00 colour rgb <0,0,0>]
			[0.50 colour rgb <0,0,0>]
			[0.51 colour rgb <0.9,0.5,0.1>]
			[1.00 colour rgb <0.9,0.5,0.1>]
		}
		scale <0.11,0.1,10>
		translate <0,0.03,0>
	}
	finish{
		reflection 0.1 phong .75 phong_size 150

	}
}

#declare EyeOliveTx=
texture{
	pigment{
		onion colour_map{
			[0.00 colour rgb <0,0,0>]
			[0.50 colour rgb <0,0,0>]
			[0.51 colour rgb <0.5,0.6,0>]
			[1.00 colour rgb <0.5,0.6,0>]
		}
		scale <0.11,0.1,10>
		translate <0,0.03,0>
	}
	finish{
		reflection 0.1 phong .75 phong_size 150

	}
}

// F

#declare Fur2Tx=
texture{
  normal{
	ripples 2 turbulence 0.5 omega 1 lambda 4
	rotate <30,20,10>
  }
  pigment{
	granite
	colour_map{
	  [0.0 colour rgb <.65,.65,.35>]
	  [0.3 colour rgb <.75,.75,.45>]
	  [0.6 colour rgb <.75,.80,.45>]
	  [1.0 colour rgb <.75,.75,.45>]
	}
	scale .5
  }
}

#declare Fur3Tx=
texture{
  normal{
	ripples 2 turbulence 0.5 omega 1 lambda 4
	rotate <30,20,10>
  }
  pigment{
	granite
	colour_map{
	  [0.0 colour rgb <.65,.43,.15>]
	  [0.3 colour rgb <.85,.57,.15>]
	  [0.6 colour rgb <.75,.50,.15>]
	  [1.0 colour rgb <.90,.60,.15>]
	}
	scale .5
  }
}

#declare Fur4Tx=
texture{
  normal{
	ripples 2 turbulence 0.5 omega 1 lambda 4
	rotate <30,20,10>
  }
  pigment{
	marble
	colour_map{
	  [0.0 colour rgb <.65,.65,.25>]
	  [0.3 colour rgb <.75,.75,.25>]
	  [0.6 colour rgb <.75,.80,.25>]
	  [1.0 colour rgb <.75,.75,.25>]
	}
	scale .5
  }
}

#declare Fur5Tx=
texture{
  normal{
	ripples 2 turbulence 0.5 omega 1 lambda 4
	rotate <30,20,10>
  }
  pigment{
	granite
	colour_map{
	  [0.0 colour rgb <.65,.65,.65>]
	  [0.3 colour rgb <.75,.75,.75>]
	  [0.6 colour rgb <.50,.50,.50>]
	  [1.0 colour rgb <1.0,1.0,1.0>]
	}
	scale .5
  }
}

#declare Fur6Tx=
texture{
  normal{
	ripples 2 turbulence 0.5 omega 1 lambda 4
	rotate <30,20,10>
  }
  pigment{
	granite
	colour_map{
	  [0.0 colour rgb <.65,.65,.35>]
	  [0.3 colour rgb <.65,.65,.65>]
	  [0.6 colour rgb <.80,.80,.45>]
	  [1.0 colour rgb <.75,.75,.75>]
	}
	scale .5
  }
  finish{ambient .1 brilliance .2 diffuse .4
    specular .1 roughness .1 reflection .1}
}

#declare Fur7Tx=
texture{
  normal{
	ripples 2 turbulence 0.5 omega 1 lambda 4
	rotate <30,20,10>
  }
  pigment{
	granite
	colour_map{
	  [0.0 colour rgb <.15,.10,.05>]
	  [0.3 colour rgb <.25,.20,.05>]
	  [0.6 colour rgb <.40,.35,.05>]
	  [1.0 colour rgb <.30,.25,.05>]
	}
	scale .5
  }
}

#declare Fur8Tx=
texture{
  normal{
	ripples 2 turbulence 0.5 omega 1 lambda 4
	rotate <30,20,10>
  }
  pigment{
	agate
	colour_map{
	  [0.0 colour rgb <.05,.03,.00>]
	  [0.3 colour rgb <.07,.05,.00>]
	  [0.6 colour rgb <.13,.11,.00>]
	  [1.0 colour rgb <.10,.08,.00>]
	}
	scale .5
  }
  finish{ambient .1 brilliance .2 diffuse .4
    specular .1 roughness .1 reflection .1}
}

#declare Fur9Tx=
texture{
  normal{
	ripples 2 turbulence 0.5 omega 1 lambda 4
	rotate <30,20,10>
  }
  pigment{
	granite
	colour_map{
	  [0.0 colour rgb <.65,.43,.15>]
	  [0.3 colour rgb <.85,.57,.15>]
	  [0.6 colour rgb <.75,.50,.15>]
	  [1.0 colour rgb <.90,.60,.15>]
	}
	scale .5
  }
  finish{ambient .2 brilliance .2 diffuse .4
    specular .2 roughness .1 reflection .1}
}

#declare Fur10Tx=
texture{
  normal{
		ripples 2 turbulence 0.5 omega 1 lambda 4
		rotate <30,20,10>
  }
  pigment{
		granite
		colour_map{
	  	[0.0 colour rgb <.65,.43,.15>*1.2]
		  [0.3 colour rgb <.85,.57,.15>*1.2]
		  [0.6 colour rgb <.75,.50,.15>*1.2]
	  	[1.0 colour rgb <.90,.60,.15>*1.2]
		}
		scale .5
  }
  finish{
  	ambient .2 brilliance .2 diffuse .4
		specular .2 roughness .1 reflection .1
	}
}

// G

#declare GreenSilver=
texture{
	pigment{
		radial frequency 25
		colour_map{
			[0.00 colour rgb <0.15,0.80,0.15>]
			[0.79 colour rgb <0.15,0.80,0.15>]
			[0.80 Silver]
			[1.00 Silver]
		}
	}
	normal{
		wrinkles .5*in
	}
}

// H
// I
// J
// K
// L
// M
// N
// O

#declare OldBillyFur=
texture{
  normal {
    ripples 2 turbulence 0.5 omega 1 lambda 4
    rotate <30,20,10>
  }
  pigment {
    granite
    colour_map {
      [0.0 colour rgb <.75,.65,.20>]
      [0.3 colour rgb <.80,.75,.15>]
      [0.6 colour rgb <.85,.80,.25>]
      [1.0 colour rgb <.80,.75,.20>]
    }
    scale .5
  }
}

// P

#declare PaleFur=
texture{
  normal{
		ripples 2 turbulence 0.5 omega 1 lambda 4
		rotate <-60,40,-20>
  }
  pigment{
		granite
		colour_map{
	  	[0.00 colour rgb <0.90,0.90,0.90>]
		  [0.25 colour rgb <0.95,0.95,0.95>]
		  [0.50 colour rgb <0.80,0.80,0.80>]
	  	[0.75 colour rgb <0.95,0.95,0.95>]
	  	[1.00 colour rgb <1.00,1.00,1.00>]
		}
  }
  finish{ambient .1 brilliance .2 diffuse .4
    specular .1 roughness .1 reflection .1
  }
}

#declare PinkDress=
texture{
	pigment{
		agate agate_turb 0.5
		colour_map{
			[0.00 colour rgb <0.85,0.40,0.45>]
			[0.40 colour rgb <0.90,0.45,0.40>]
			[0.60 colour rgb <0.85,0.40,0.45>]
			[1.00 colour rgb <0.90,0.45,0.40>]
		}
		scale 0.25
	}
	finish{
		reflection 0.1
	}
	normal{
		wrinkles .5*in
	}
}

#declare PinkGingham=
texture{
	pigment{
		gradient y
		colour_map{
			[0.00 colour rgb <1.00,1.00,1.00>]
			[0.70 colour rgb <1.00,1.00,1.00>]
			[0.80 colour rgb <0.90,0.45,0.40>]
			[0.90 colour rgb <1.00,1.00,1.00>]
			[1.00 colour rgb <0.90,0.45,0.40>]
		}
		scale 0.15
	}
	normal{
		wrinkles .5*in
	}
}
texture{
	pigment{
		radial frequency 25
		colour_map{
			[0.00 colour rgbf <1.00,1.00,1.00,1>]
			[0.70 colour rgbf <1.00,1.00,1.00,1>]
			[0.80 colour rgbf <0.90,0.45,0.40,0>]
			[0.90 colour rgbf <1.00,1.00,1.00,1>]
			[1.00 colour rgbf <0.90,0.45,0.40,0>]
		}
	}
}

#declare PolarFur=
texture{
  normal{
		ripples 2 turbulence 0.5 omega 1 lambda 4
		rotate <30,20,10>
  }
  pigment{
		granite
		colour_map{
	  	[0.00 colour rgb <0.90,0.90,0.90>]
		  [0.25 colour rgb <0.95,0.95,0.95>]
		  [0.50 colour rgb <0.80,0.80,0.80>]
	  	[0.75 colour rgb <0.95,0.95,0.95>]
	  	[1.00 colour rgb <1.00,1.00,1.00>]
		}
		scale 0.5
  }
  finish{ambient .1 brilliance .2 diffuse .4
    specular .1 roughness .1 reflection .1
    irid{0.25 thickness .15 turbulence .25}
  }
}

// Q
// R

#declare RedGold=
texture{
	pigment{
		radial frequency 25
		colour_map{
			[0.00 colour rgb <0.80,0.20,0.20>]
			[0.79 colour rgb <0.80,0.20,0.20>]
			[0.80 Gold]
			[1.00 Gold]
		}
	}
	normal{
		wrinkles .5*in
	}
}

// S
// T
// U
// V
// W

#declare WandererBrown=
texture{
	pigment{
		agate agate_turb 0.5
		colour_map{
			[0.00 colour rgb <0.40,0.25,0.00>]
			[0.40 colour rgb <0.53,0.35,0.00>]
			[0.60 colour rgb <0.40,0.25,0.00>]
			[1.00 colour rgb <0.53,0.35,0.00>]
		}
		scale 0.15
	}
	finish{
		reflection 0.1
	}
	normal{
		wrinkles .5*in
	}
}

#declare WandererGreen=
texture{
	pigment{
		agate agate_turb 0.5
		colour_map{
			[0.00 colour rgb <0.15,0.30,0.00>]
			[0.40 colour rgb <0.20,0.40,0.00>]
			[0.60 colour rgb <0.15,0.30,0.00>]
			[1.00 colour rgb <0.20,0.40,0.00>]
		}
		scale 0.25
	}
	finish{
		reflection 0.1
	}
	normal{
		wrinkles .5*in
	}
}

#declare WandererYellow=
texture{
	pigment{
		agate agate_turb 0.5
		colour_map{
			[0.00 colour rgb <0.80,0.50,0.30>]
			[0.40 colour rgb <1.00,0.70,0.30>]
			[0.60 colour rgb <0.80,0.50,0.30>]
			[1.00 colour rgb <1.00,0.70,0.30>]
		}
		scale 0.15
	}
	finish{
		reflection 0.1
	}
	normal{
		wrinkles .5*in
	}
}

#declare WarmFur2Tx=
texture{
	normal{
		ripples 2 turbulence 0.5 omega 1 lambda 4
		rotate <30,20,10>
	}
	pigment{
		granite
		colour_map{
			[0.0 colour rgb <0.88,0.70,0.20>*1.2]
			[0.3 colour rgb <1.00,0.80,0.20>*1.2]
			[0.6 colour rgb <0.90,0.84,0.20>*1.2]
			[1.0 colour rgb <1.00,0.80,0.20>*1.2]
		}
		scale .5
	}
}

#declare WarmFurTx=
texture{
	normal{
		ripples 2 turbulence 0.5 omega 1 lambda 4
		rotate <30,20,10>
	}
	pigment{
		granite
		colour_map{
			[0.0 colour rgb <0.85,0.60,0.15>*1.2]
			[0.3 colour rgb <0.95,0.70,0.15>*1.2]
			[0.6 colour rgb <0.95,0.75,0.15>*1.2]
			[1.0 colour rgb <0.95,0.70,0.15>*1.2]
		}
		scale .5
	}
}

#declare WhiteSilver=
texture{
	pigment{
		agate agate_turb 0.5
		colour_map{
			[0.00 colour rgb <0.90,0.90,0.95>]
			[0.40 colour rgb <0.90,0.95,0.90>]
			[0.60 colour rgb <0.90,0.90,0.95>]
			[1.00 colour rgb <0.90,0.95,0.90>]
		}
		scale 0.25
	}
	finish{
		reflection 0.1 irid{0.25 thickness .15 turbulence .25}
	}
	normal{
		wrinkles .5*in
	}
}

// X
// Y
// Z
// macros that generate textures

/* Create texture for panels of T-shirt
	BaseTx:  basic background texture
	Picture: picture to put on T-shirt
	Width,Height: needed to scale picture proportionately
	Flags:   0 opaque 1 transparent white
*/
#macro TShirtPic(BaseTx,Picture,Width,Height,Flags)
	texture{
		BaseTx
	}
	texture{
		pigment{
			image_map{
			  png Picture
			  map_type 0 interpolate 2 once
			  //transmit 0 1
			}
		}
		scale <-1,Height/Width,1>*in //reverse and resize
		translate <0.5,0,0>*in
	}
#end
// extras & unsorted.


#debug "\r--------------------\rend of beartex.inc\r--------------------\r"

