// Persistence Of Vision INCLUDE file
// File:        bishop.cdf
// Vers:        3.1 Mac PPC
// Desc:        A mediaeval bishop's costume for tedbearm.inc to wear
// Auth:        Peter Murray
// Date:        28 January 2001

#debug "\r  bishop.cdf - A mediaeval bishop's costume for bears.\r"

// Measurements might already be defined.
#ifndef(in)
	#declare in = 1;
	#declare ft = 12;
#end

// Pick up values/choices from the options arrays.

	// 0 mitre, 1 alb, 2 trim, 3 cope, 4 ?
	#local MitreTx=BearTextureList[0]
	#local AlbTx=BearTextureList[1]
	#local TrimTx=BearTextureList[2]
	#local CopeTx=BearTextureList[3]
	#local ScarfTx=BearTextureList[4]
	
	// 0,1 scarf ends y length, 2 Boolean songsheets, 3 Boolean snowball
	
#declare TeddyHat=// a mitre
union{
	cone{
		<0,0.88,0.0>*in,0.5*in,<0,1.25,0>*in,0.4*in
		scale <1.75,1,0.85>
		translate <0,0,0.01>*in
	}
	cone{
		<0,0.88,0.0>*in,0.51*in,<0,0.93,0>*in,0.505*in
		scale <1.75,1,0.85>
		translate <0,0,0.01>*in
		texture{TrimTx}
	}
	cone{
		<0,1.15,0.0>*in,0.43*in,<0,1.20,0>*in,0.415*in
		scale <1.75,1,0.85>
		translate <0,0,0.01>*in
		texture{TrimTx}
	}
	sphere{
		<0,0,0>*in,0.39*in
		scale <1.75,0.5,0.85>
		translate <0,1.25,0.01>*in
	}
	difference{
		union{
			cone{
				<0,1.25,0>*in,0.4*in,<0,2.0,0>*in,0.05*in
				scale <1.75,1,0.85>
				translate <0,0,0.01>*in
			}
			//vertical trim
			box{<-0.15,0,0>*in,<-0.05,0.7,-0.015>*in texture{TrimTx} rotate x*-25 translate <0,1.2,0.415>*in}
			box{<0.15,0,0>*in,<0.05,0.7,-0.015>*in texture{TrimTx} rotate x*-25 translate <0,1.2,0.415>*in}
		}
		box{<-0.5,1,-0.1>*in,<0.5,2.5,0.1>*in}
	}
	texture{MitreTx}
	rotate x*-10
	translate <0,0,0.1>*in
}

#declare TeddyShirt=
union{
	#local xtnt=1.0;
	union{//part of the bishop's alb
		bicubic_patch{//left front upper panel
			type 1 flatness 0.1
			u_steps 5 v_steps 5
			<-0.7,2.875,0.25>*in <-0.5,2.875,0.25>*in <-0.25,2.875,0.55>*in <0,2.875,0.55>*in
			<-0.75,2.3465,0.25>*in <-0.6,2.3465,0.25>*in <-0.3,2.3465,0.55>*in <0,2.3465,0.55>*in
			<-0.85,1.9035,0.25>*in <-0.7,1.9035,0.6>*in <-0.4,1.9035,0.75>*in <0,1.9035,0.75>*in
			<-0.85,1.55,0.25>*in <-0.7,1.55,0.55>*in <-0.45,1.55,0.65>*in <0,1.55,0.65>*in
		}
		bicubic_patch{//right front upper panel
			type 1 flatness 0.1
			u_steps 5 v_steps 5
			<0.7,2.875,0.25>*in <0.5,2.875,0.25>*in <0.25,2.875,0.55>*in <0,2.875,0.55>*in
			<0.75,2.3465,0.25>*in <0.6,2.3465,0.25>*in <0.3,2.3465,0.55>*in <0,2.3465,0.55>*in
			<0.85,1.9035,0.25>*in <0.7,1.9035,0.6>*in <0.4,1.9035,0.75>*in <0,1.9035,0.75>*in
			<0.85,1.55,0.25>*in <0.7,1.55,0.55>*in <0.45,1.55,0.65>*in <0,1.55,0.65>*in
		}
		bicubic_patch{//right upper panel
			type 1 flatness 0.1
			u_steps 5 v_steps 5
			<0.7,2.875,0.25>*in <0.73,2.875,0.15>*in <0.73,2.875,-0.15>*in <0.7,2.875,-0.25>*in
			<0.75,2.3465,0.25>*in <0.78,2.3465,0.15>*in <0.78,2.3465,-0.15>*in <0.75,2.3465,-0.25>*in
			<0.85,1.9035,0.25>*in <0.88,1.9035,0.15>*in <0.88,1.9035,-0.15>*in <0.85,1.9035,-0.25>*in
			<0.85,1.55,0.25>*in <0.88,1.55,0.15>*in <0.88,1.55,-0.15>*in <0.85,1.55,-0.25>*in
		}
		bicubic_patch{//right back upper panel
			type 1 flatness 0.1
			u_steps 5 v_steps 5
			<0.65,2.875,-0.25>*in <0.5,2.875,-0.25>*in <0.25,2.875,-0.55>*in <0,2.875,-0.4>*in
			<0.75,2.3465,-0.25>*in <0.5,2.3465,-0.30>*in <0.3,2.3465,-0.55>*in <0,2.3465,-0.5>*in
			<0.85,1.9035,-0.25>*in <0.7,1.9035,-0.58>*in <0.4,1.9035,-0.6>*in <0,1.9035,-0.55>*in
			<0.85,1.55,-0.25>*in <0.7,1.55,-0.57>*in <0.4,1.55,-0.6>*in <0,1.55,-0.6>*in
		}
		bicubic_patch{//left back upper panel
			type 1 flatness 0.1
			u_steps 5 v_steps 5
			<-0.65,2.875,-0.25>*in <-0.5,2.875,-0.25>*in <-0.25,2.875,-0.55>*in <-0,2.875,-0.4>*in
			<-0.75,2.3465,-0.25>*in <-0.5,2.3465,-0.30>*in <-0.3,2.3465,-0.55>*in <-0,2.3465,-0.5>*in
			<-0.85,1.9035,-0.25>*in <-0.7,1.9035,-0.58>*in <-0.4,1.9035,-0.6>*in <-0,1.9035,-0.55>*in
			<-0.85,1.55,-0.25>*in <-0.7,1.55,-0.57>*in <-0.4,1.55,-0.6>*in <-0,1.55,-0.6>*in
		}
		bicubic_patch{//left panel
			type 1 flatness 0.1
			u_steps 5 v_steps 5
			<-0.7,2.875,0.25>*in <-0.73,2.875,0.15>*in <-0.73,2.875,-0.15>*in <-0.7,2.875,-0.25>*in
			<-0.75,2.3465,0.25>*in <-0.78,2.3465,0.15>*in <-0.78,2.3465,-0.15>*in <-0.75,2.3465,-0.25>*in
			<-0.85,1.9035,0.25>*in <-0.88,1.9035,0.15>*in <-0.88,1.9035,-0.15>*in <-0.85,1.9035,-0.25>*in
			<-0.85,1.55,0.25>*in <-0.88,1.55,0.15>*in <-0.88,1.55,-0.15>*in <-0.85,1.55,-0.25>*in
		}
		bicubic_patch{//left shoulder
			type 1 flatness 0.1
			u_steps 5 v_steps 5
			<-0.65,2.875,-0.25>*in <-0.5,2.875,-0.25>*in <-0.25,2.875,-0.55>*in <-0.1,2.875,-0.4>*in
			<-0.65,3.050,-0.15>*in <-0.5,3.125,-0.15>*in <-0.25,3.125,-0.35>*in <-0.1,3.125,-0.3>*in
			<-0.65,3.050,0.15>*in <-0.5,3.125,0.15>*in <-0.25,3.125,0.35>*in <-0.1,3.125,0.3>*in
			<-0.7,2.875,0.25>*in <-0.5,2.875,0.25>*in <-0.25,2.875,0.55>*in <0,2.875,0.55>*in
		}
		bicubic_patch{//right shoulder
			type 1 flatness 0.1
			u_steps 5 v_steps 5
			<0.65,2.875,-0.25>*in <0.5,2.875,-0.25>*in <0.25,2.875,-0.55>*in <0.1,2.875,-0.4>*in
			<0.65,3.050,-0.15>*in <0.5,3.125,-0.15>*in <0.25,3.125,-0.35>*in <0.1,3.125,-0.3>*in
			<0.65,3.050,0.15>*in <0.5,3.125,0.15>*in <0.25,3.125,0.35>*in <0.1,3.125,0.3>*in
			<0.7,2.875,0.25>*in <0.5,2.875,0.25>*in <0.25,2.875,0.55>*in <0,2.875,0.55>*in
		}
		// now for the "skirt" part
		bicubic_patch{//right front lower panel
			type 1 flatness 0.1
			u_steps 5 v_steps 5
			<0.85,1.55,0.25>*in <0.70,1.55,0.55>*in <0.45,1.55,0.65>*in <0,1.55,0.65>*in
			<0.97,1.25,0.25>*in <0.78,1.25,0.55>*in <0.49,1.25,0.65>*in <0,1.25,0.65>*in
			<1.08,0.85,0.25>*in <0.86,0.85,0.55>*in <0.53,0.85,0.65>*in <0,0.85,0.65>*in
			<1.20,0.55,0.25>*in <0.94,0.55,0.55>*in <0.57,0.55,0.65>*in <0,0.55,0.65>*in
		}
		bicubic_patch{//right lower panel
			type 1 flatness 0.1
			u_steps 5 v_steps 5
			<0.85,1.55,0.25>*in <0.88,1.55,0.15>*in <0.88,1.55,-0.15>*in <0.85,1.55,-0.25>*in
			<0.97,1.25,0.25>*in <1.05,1.25,0.15>*in <1.05,1.25,-0.15>*in <0.97,1.25,-0.25>*in
			<1.08,0.85,0.25>*in <1.23,0.85,0.15>*in <1.23,0.85,-0.15>*in <1.08,0.85,-0.25>*in
			<1.20,0.55,0.25>*in <1.40,0.55,0.15>*in <1.40,0.55,-0.15>*in <1.20,0.55,-0.25>*in
		}
		bicubic_patch{//right back lower panel
			type 1 flatness 0.1
			u_steps 5 v_steps 5
			<0.85,1.55,-0.25>*in <0.70,1.55,-0.57>*in <0.45,1.55,-0.6>*in <0,1.55,-0.6>*in
			<0.97,1.25,-0.25>*in <0.78,1.25,-0.57>*in <0.49,1.25,-0.6>*in <0,1.25,-0.6>*in
			<1.08,0.85,-0.25>*in <0.86,0.85,-0.57>*in <0.53,0.85,-0.6>*in <0,0.85,-0.6>*in
			<1.20,0.55,-0.25>*in <0.94,0.55,-0.57>*in <0.57,0.55,-0.6>*in <0,0.55,-0.6>*in
		}
		bicubic_patch{//left front lower panel
			type 1 flatness 0.1
			u_steps 5 v_steps 5
			<-0.85,1.55,0.25>*in <-0.70,1.55,0.55>*in <-0.45,1.55,0.65>*in <0,1.55,0.65>*in
			<-0.97,1.25,0.25>*in <-0.78,1.25,0.55>*in <-0.49,1.25,0.65>*in <0,1.25,0.65>*in
			<-1.08,0.85,0.25>*in <-0.86,0.85,0.55>*in <-0.53,0.85,0.65>*in <0,0.85,0.65>*in
			<-1.20,0.55,0.25>*in <-0.94,0.55,0.55>*in <-0.57,0.55,0.65>*in <0,0.55,0.65>*in
		}
		bicubic_patch{//left lower panel
			type 1 flatness 0.1
			u_steps 5 v_steps 5
			<-0.85,1.55,0.25>*in <-0.88,1.55,0.15>*in <-0.88,1.55,-0.15>*in <-0.85,1.55,-0.25>*in
			<-0.97,1.25,0.25>*in <-1.05,1.25,0.15>*in <-1.05,1.25,-0.15>*in <-0.97,1.25,-0.25>*in
			<-1.08,0.85,0.25>*in <-1.23,0.85,0.15>*in <-1.23,0.85,-0.15>*in <-1.08,0.85,-0.25>*in
			<-1.20,0.55,0.25>*in <-1.40,0.55,0.15>*in <-1.40,0.55,-0.15>*in <-1.20,0.55,-0.25>*in
		}
		bicubic_patch{//left back lower panel
			type 1 flatness 0.1
			u_steps 5 v_steps 5
			<-0.85,1.55,-0.25>*in <-0.70,1.55,-0.57>*in <-0.45,1.55,-0.6>*in <0,1.55,-0.6>*in
			<-0.97,1.25,-0.25>*in <-0.78,1.25,-0.57>*in <-0.49,1.25,-0.6>*in <0,1.25,-0.6>*in
			<-1.08,0.85,-0.25>*in <-0.86,0.85,-0.57>*in <-0.53,0.85,-0.6>*in <0,0.85,-0.6>*in
			<-1.20,0.55,-0.25>*in <-0.94,0.55,-0.57>*in <-0.57,0.55,-0.6>*in <0,0.55,-0.6>*in
		}
		texture{AlbTx}
	}
	//string belt
	//the cope
	union{
		bicubic_patch{//left front upper panel
			type 1 flatness 0.1
			u_steps 5 v_steps 5
			<-0.7,2.875,0.26>*in <-0.55,2.875,0.26>*in <-0.3,2.875,0.55>*in <-0.1,2.875,0.55>*in
			<-0.75,2.3465,0.27>*in <-0.65,2.3465,0.27>*in <-0.35,2.3465,0.55>*in <-0.1,2.3465,0.55>*in
			<-0.85,1.9035,0.28>*in <-0.75,1.9035,0.63>*in <-0.45,1.9035,0.75>*in <-0.1,1.9035,0.75>*in
			<-0.85,1.55,0.29>*in <-0.75,1.55,0.59>*in <-0.50,1.55,0.65>*in <-0.1,1.55,0.65>*in
		}
		bicubic_patch{//left front lower panel
			type 1 flatness 0.1
			u_steps 5 v_steps 5
			<-0.87,1.55,0.28>*in <-0.75,1.55,0.59>*in <-0.50,1.55,0.65>*in <-0.1,1.55,0.65>*in
			<-1.00,1.25,0.29>*in <-0.83,1.25,0.59>*in <-0.54,1.25,0.65>*in <-0.1,1.25,0.66>*in
			<-1.12,0.85,0.30>*in <-0.91,0.85,0.59>*in <-0.58,0.85,0.65>*in <-0.1,0.85,0.67>*in
			<-1.25,0.60,0.31>*in <-0.99,0.60,0.59>*in <-0.62,0.60,0.65>*in <-0.1,0.60,0.68>*in
		}
		bicubic_patch{//right front upper panel
			type 1 flatness 0.1
			u_steps 5 v_steps 5
			<0.7,2.875,0.26>*in <0.55,2.875,0.26>*in <0.3,2.875,0.55>*in <0.1,2.875,0.55>*in
			<0.75,2.3465,0.27>*in <0.65,2.3465,0.27>*in <0.35,2.3465,0.55>*in <0.1,2.3465,0.55>*in
			<0.85,1.9035,0.28>*in <0.75,1.9035,0.63>*in <0.45,1.9035,0.75>*in <0.1,1.9035,0.75>*in
			<0.85,1.55,0.29>*in <0.75,1.55,0.59>*in <0.50,1.55,0.65>*in <0.1,1.55,0.65>*in
		}
		bicubic_patch{//right front lower panel
			type 1 flatness 0.1
			u_steps 5 v_steps 5
			<0.87,1.55,0.28>*in <0.75,1.55,0.59>*in <0.50,1.55,0.65>*in <0.1,1.55,0.65>*in
			<1.00,1.25,0.29>*in <0.83,1.25,0.59>*in <0.54,1.25,0.65>*in <0.1,1.25,0.66>*in
			<1.12,0.85,0.30>*in <0.91,0.85,0.59>*in <0.58,0.85,0.65>*in <0.1,0.85,0.67>*in
			<1.25,0.60,0.31>*in <0.99,0.60,0.59>*in <0.62,0.60,0.65>*in <0.1,0.60,0.68>*in
		}
		bicubic_patch{//right shoulder
			type 1 flatness 0.1
			u_steps 5 v_steps 5
			<0.65,2.875,-0.26>*in <0.50,2.870,-0.27>*in <0.25,2.870,-0.57>*in <0.0,2.875,-0.41>*in
			<0.65,3.060,-0.15>*in <0.50,3.135,-0.15>*in <0.25,3.135,-0.45>*in <0.1,3.135,-0.3>*in
			<0.65,3.060, 0.15>*in <0.50,3.135, 0.15>*in <0.25,3.135, 0.46>*in <0.1,3.135, 0.44>*in
			<0.70,2.875, 0.26>*in <0.55,2.875, 0.26>*in <0.30,2.875, 0.55>*in <0.1,2.875, 0.55>*in
		}
		bicubic_patch{//left shoulder
			type 1 flatness 0.1
			u_steps 5 v_steps 5
			<-0.65,2.875,-0.26>*in <-0.50,2.870,-0.27>*in <-0.25,2.870,-0.57>*in <-0.0,2.875,-0.41>*in
			<-0.65,3.060,-0.15>*in <-0.50,3.135,-0.15>*in <-0.25,3.135,-0.45>*in <-0.1,3.135,-0.30>*in
			<-0.65,3.060, 0.15>*in <-0.50,3.135, 0.15>*in <-0.25,3.135, 0.46>*in <-0.1,3.135, 0.44>*in
			<-0.70,2.875, 0.26>*in <-0.55,2.875, 0.26>*in <-0.30,2.875, 0.55>*in <-0.1,2.875, 0.55>*in
		}
		bicubic_patch{//right back upper panel
			type 1 flatness 0.1
			u_steps 5 v_steps 5
			<0.65,2.875,-0.26>*in <0.5,2.88,-0.27>*in <0.25,2.88,-0.57>*in <0,2.875,-0.41>*in
			<0.75,2.3465,-0.26>*in <0.5,2.3465,-0.31>*in <0.3,2.3465,-0.56>*in <0,2.3465,-0.51>*in
			<0.86,1.9035,-0.27>*in <0.71,1.9035,-0.60>*in <0.4,1.9035,-0.62>*in <0,1.9035,-0.57>*in
			<0.87,1.55,-0.28>*in <0.72,1.55,-0.60>*in <0.4,1.55,-0.63>*in <0,1.55,-0.62>*in
		}
		bicubic_patch{//left back upper panel
			type 1 flatness 0.1
			u_steps 5 v_steps 5
			<-0.65,2.875,-0.26>*in <-0.5,2.88,-0.27>*in <-0.25,2.88,-0.57>*in <-0,2.875,-0.41>*in
			<-0.75,2.3465,-0.26>*in <-0.5,2.3465,-0.31>*in <-0.3,2.3465,-0.56>*in <-0,2.3465,-0.51>*in
			<-0.86,1.9035,-0.27>*in <-0.71,1.9035,-0.60>*in <-0.4,1.9035,-0.62>*in <-0,1.9035,-0.57>*in
			<-0.87,1.55,-0.28>*in <-0.72,1.55,-0.60>*in <-0.4,1.55,-0.63>*in <-0,1.55,-0.63>*in
		}
		bicubic_patch{//left upper panel
			type 1 flatness 0.1
			u_steps 5 v_steps 5
			<-0.7,2.875,0.26>*in <-0.73,2.875,0.15>*in <-0.73,2.875,-0.15>*in <-0.7,2.875,-0.26>*in
			<-0.75,2.3465,0.26>*in <-0.80,2.3465,0.15>*in <-0.80,2.3465,-0.15>*in <-0.75,2.3465,-0.26>*in
			<-0.86,1.9035,0.27>*in <-0.87,1.9035,0.15>*in <-0.87,1.9035,-0.15>*in <-0.86,1.9035,-0.27>*in
			<-0.87,1.55,0.28>*in <-0.94,1.54,0.15>*in <-0.94,1.54,-0.15>*in <-0.87,1.55,-0.28>*in
		}
		bicubic_patch{//right upper panel
			type 1 flatness 0.1
			u_steps 5 v_steps 5
			<0.7,2.875,0.26>*in <0.73,2.875,0.15>*in <0.73,2.875,-0.15>*in <0.7,2.875,-0.26>*in
			<0.75,2.3465,0.26>*in <0.80,2.3465,0.15>*in <0.80,2.3465,-0.15>*in <0.75,2.3465,-0.26>*in
			<0.86,1.9035,0.27>*in <0.87,1.9035,0.15>*in <0.87,1.9035,-0.15>*in <0.86,1.9035,-0.27>*in
			<0.87,1.55,0.28>*in <0.94,1.54,0.15>*in <0.94,1.54,-0.15>*in <0.87,1.55,-0.28>*in
		}
		bicubic_patch{//right back lower panel
			type 1 flatness 0.1
			u_steps 5 v_steps 5
			<0.87,1.55,-0.28>*in <0.70,1.55,-0.60>*in <0.45,1.55,-0.63>*in <0,1.55,-0.63>*in
			<1.00,1.25,-0.29>*in <0.78,1.25,-0.61>*in <0.49,1.25,-0.64>*in <0,1.25,-0.64>*in
			<1.12,0.85,-0.30>*in <0.86,0.85,-0.62>*in <0.53,0.85,-0.65>*in <0,0.85,-0.65>*in
			<1.25,0.60,-0.31>*in <0.94,0.60,-0.63>*in <0.57,0.60,-0.66>*in <0,0.60,-0.66>*in
		}
		bicubic_patch{//left back lower panel
			type 1 flatness 0.1
			u_steps 5 v_steps 5
			<-0.87,1.55,-0.28>*in <-0.70,1.55,-0.60>*in <-0.45,1.55,-0.63>*in <0,1.55,-0.63>*in
			<-1.00,1.25,-0.29>*in <-0.78,1.25,-0.61>*in <-0.49,1.25,-0.64>*in <0,1.25,-0.64>*in
			<-1.12,0.85,-0.30>*in <-0.86,0.85,-0.62>*in <-0.53,0.85,-0.65>*in <0,0.85,-0.65>*in
			<-1.25,0.60,-0.31>*in <-0.94,0.60,-0.63>*in <-0.57,0.60,-0.66>*in <0,0.60,-0.66>*in
		}
		bicubic_patch{//left lower panel
			type 1 flatness 0.1
			u_steps 5 v_steps 5
			<-0.87,1.55,0.28>*in <-0.94,1.57,0.15>*in <-0.94,1.57,-0.15>*in <-0.87,1.55,-0.28>*in
			<-1.00,1.25,0.29>*in <-1.12,1.25,0.15>*in <-1.12,1.25,-0.15>*in <-1.00,1.25,-0.29>*in
			<-1.12,0.85,0.30>*in <-1.31,0.85,0.15>*in <-1.31,0.85,-0.15>*in <-1.12,0.85,-0.30>*in
			<-1.25,0.60,0.31>*in <-1.49,0.60,0.15>*in <-1.49,0.60,-0.15>*in <-1.25,0.60,-0.31>*in
		}
		bicubic_patch{//right lower panel
			type 1 flatness 0.1
			u_steps 5 v_steps 5
			<0.87,1.55,0.28>*in <0.94,1.57,0.15>*in <0.94,1.57,-0.15>*in <0.87,1.55,-0.28>*in
			<1.00,1.25,0.29>*in <1.12,1.25,0.15>*in <1.12,1.25,-0.15>*in <1.00,1.25,-0.29>*in
			<1.12,0.85,0.30>*in <1.31,0.85,0.15>*in <1.31,0.85,-0.15>*in <1.12,0.85,-0.30>*in
			<1.25,0.60,0.31>*in <1.49,0.60,0.15>*in <1.49,0.60,-0.15>*in <1.25,0.60,-0.31>*in
		}
		texture{CopeTx}
	}
	//the embroidered trim on the cope
	union{
		bicubic_patch{//left upper panel
			type 1 flatness 0.1
			u_steps 5 v_steps 5
			<-0.2,2.875,0.56>*in  <-0.17,2.875,0.56>*in  <-0.13,2.875,0.56>*in  <-0.1,2.875,0.56>*in
			<-0.2,2.3465,0.56>*in <-0.17,2.3465,0.56>*in <-0.13,2.3465,0.56>*in <-0.1,2.3465,0.56>*in
			<-0.2,1.9035,0.76>*in <-0.17,1.9035,0.76>*in <-0.13,1.9035,0.76>*in <-0.1,1.9035,0.76>*in
			<-0.2,1.55,0.66>*in   <-0.17,1.55,0.66>*in   <-0.13,1.55,0.66>*in   <-0.1,1.55,0.66>*in
		}
		bicubic_patch{//left lower panel
			type 1 flatness 0.1
			u_steps 5 v_steps 5
			<-0.2,1.55,0.66>*in <-0.17,1.55,0.66>*in <-0.13,1.55,0.66>*in <-0.1,1.55,0.66>*in
			<-0.2,1.25,0.67>*in <-0.17,1.25,0.67>*in <-0.13,1.25,0.67>*in <-0.1,1.25,0.67>*in
			<-0.2,0.85,0.68>*in <-0.17,0.85,0.68>*in <-0.13,0.85,0.68>*in <-0.1,0.85,0.68>*in
			<-0.2,0.60,0.69>*in <-0.17,0.60,0.69>*in <-0.13,0.60,0.69>*in <-0.1,0.60,0.69>*in
		}
		bicubic_patch{//left shoulder
			type 1 flatness 0.1
			u_steps 5 v_steps 5
			<-0.10,2.875,-0.42>*in <-0.07,2.875,-0.42>*in <-0.03,2.875,-0.42>*in <-0.00,2.875,-0.42>*in
			<-0.20,3.145,-0.31>*in <-0.17,3.145,-0.31>*in <-0.13,3.145,-0.31>*in <-0.10,3.145,-0.31>*in
			<-0.20,3.145, 0.45>*in <-0.17,3.145, 0.45>*in <-0.13,3.145, 0.45>*in <-0.10,3.145, 0.45>*in
			<-0.20,2.875, 0.56>*in <-0.17,2.875, 0.56>*in <-0.13,2.875, 0.56>*in <-0.10,2.875, 0.56>*in
		}
		bicubic_patch{//right upper panel
			type 1 flatness 0.1
			u_steps 5 v_steps 5
			<0.2,2.875,0.56>*in  <0.17,2.875,0.56>*in  <0.13,2.875,0.56>*in  <0.1,2.875,0.56>*in
			<0.2,2.3465,0.56>*in <0.17,2.3465,0.56>*in <0.13,2.3465,0.56>*in <0.1,2.3465,0.56>*in
			<0.2,1.9035,0.76>*in <0.17,1.9035,0.76>*in <0.13,1.9035,0.76>*in <0.1,1.9035,0.76>*in
			<0.2,1.55,0.66>*in   <0.17,1.55,0.66>*in   <0.13,1.55,0.66>*in   <0.1,1.55,0.66>*in
		}
		bicubic_patch{//right lower panel
			type 1 flatness 0.1
			u_steps 5 v_steps 5
			<0.2,1.55,0.66>*in <0.17,1.55,0.66>*in <0.13,1.55,0.66>*in <0.1,1.55,0.66>*in
			<0.2,1.25,0.67>*in <0.17,1.25,0.67>*in <0.13,1.25,0.67>*in <0.1,1.25,0.67>*in
			<0.2,0.85,0.68>*in <0.17,0.85,0.68>*in <0.13,0.85,0.68>*in <0.1,0.85,0.68>*in
			<0.2,0.60,0.69>*in <0.17,0.60,0.69>*in <0.13,0.60,0.69>*in <0.1,0.60,0.69>*in
		}
		bicubic_patch{//right shoulder
			type 1 flatness 0.1
			u_steps 5 v_steps 5
			<0.10,2.875,-0.42>*in <0.07,2.875,-0.42>*in <0.03,2.875,-0.42>*in <0.00,2.875,-0.42>*in
			<0.20,3.145,-0.31>*in <0.17,3.145,-0.31>*in <0.13,3.145,-0.31>*in <0.10,3.145,-0.31>*in
			<0.20,3.145, 0.45>*in <0.17,3.145, 0.45>*in <0.13,3.145, 0.45>*in <0.10,3.145, 0.45>*in
			<0.20,2.875, 0.56>*in <0.17,2.875, 0.56>*in <0.13,2.875, 0.56>*in <0.10,2.875, 0.56>*in
		}
		box{<-0.13,2.72,0.59>*in,<0.13,2.77,0.61>*in}
		texture{TrimTx}
	}
}

#declare TeddyLUSleeve=
union{
	union{
		sphere{
			< 0.000,0.000,0.000>,0.375*in
		}
		cone{
			< 0.000,0.000,0.000>,0.375*in,<-0.09375,-0.28125,0>*in,0.375*in
		}
		sphere{
			<-0.09375,-0.28125,0>*in,0.375*in
		}
		texture{AlbTx}
	}     
	union{
		sphere{
			< 0.000,0.000,0.000>,0.385*in
		}
		cone{
			< 0.000,0.000,0.000>,0.385*in,<-0.09375,-0.28125,0>*in,0.39*in open
		}
		texture{CopeTx}
	}     
}

#declare TeddyLLSleeve=
union{
	sphere{
		< 0.0,0.0,0.0>,0.375*in
	}
	cone{
		< 0.0,0.0,0.0>,0.375*in,<-0.10546875,-0.2953125,0.000>*in,0.375*in open
	}
	texture{AlbTx}
}

#declare TeddyLSleeve=
union{
	sphere{
		< 0.000,0.000,0.000>,0.375*in
	}
	cone{
		< 0.000,0.000,0.000>,0.375*in,<-0.1875,-0.30,-0.050>*in,0.375*in
	}
	sphere{
		<-0.1875,-0.30,-0.050>,0.375*in
	}
	cone{
		<-0.1875,-0.30,-0.050>,0.375*in,<-0.375,-0.65,0.000>*in,0.375*in open
	}
	#if (BearOptionsList[2]=1)
		box{<-0.2,-0.95,-0.5>*in,<0.45,-1,0.5>*in rotate z*-15 texture{pigment{White}}}
	#end
	texture{AlbTx}
}

#declare TeddyRUSleeve=
union{
	union{
		sphere{
			< 0.000,0.000,0.000>,0.375*in
		}
		cone{
			< 0.000,0.000,0.000>,0.375*in,<0.09375,-0.28125,0>*in,0.375*in
		}
		sphere{
			<0.09375,-0.28125,0>*in,0.375*in
		}
		texture{AlbTx}
	}     
	union{
		sphere{
			< 0.000,0.000,0.000>,0.385*in
		}
		cone{
			< 0.000,0.000,0.000>,0.385*in,<0.09375,-0.28125,0>*in,0.39*in open
		}
		texture{CopeTx}
	}     
}

#declare TeddyRLSleeve=
union{
	sphere{
		< 0.0,0.0,0.0>,0.375*in
	}
	cone{
		< 0.0,0.0,0.0>,0.375*in,< 0.10546875,-0.2953125,0.000>*in,0.375*in open
	}
	texture{AlbTx}
}

/*
#declare TeddyRShoe=
union{
	difference{
		cylinder{<0,-0.9,0>*in,<0,-1.35,0>*in,0.625*in}
		cylinder{<0,-0.8,0>*in,<0,-1.2,0>*in,0.575*in}
	}
	difference{
		sphere{<0,0,0>*in,0.625*in scale <1,0.3,1> translate <0,-1.2,0.4>*in}
		box{<-0.7,-1.7,0>*in,<0.7,-1.35,1.5>*in}
		box{<-0.7,0,0>*in,<0.7,-2,-0.7>*in}
	}
	texture{BootTx}
}

#declare TeddyLShoe=TeddyRShoe

#declare TeddyRClothes=TeddyRShoe
#declare TeddyLClothes=TeddyLShoe
*/

#declare TeddyShirt2=
union{
	#local xtnt=1.0;
	cylinder{<-xtnt,3,0>*in,<xtnt,3,0>*in,.05*in}
	cylinder{<-xtnt,2.6875,-0.4>*in,<xtnt,2.6875,-0.4>*in,.05*in}
	cylinder{<-xtnt,2.6875,0.4>*in,<xtnt,2.6875,0.4>*in,.05*in}
	//
	cylinder{<-xtnt,2.1250,-0.4>*in,<xtnt,2.1250,-0.4>*in,.05*in}
	cylinder{<-xtnt,2.1250,0.4>*in,<xtnt,2.1250,0.4>*in,.05*in}
	//
	cylinder{<-xtnt,1.5625,-0.45>*in,<xtnt,1.5625,-0.45>*in,.05*in}
	cylinder{<-xtnt,1.5625,0.55>*in,<xtnt,1.5625,0.55>*in,.05*in}
	texture{AlbTx}
}
