// POV-Ray file
// Standard pre-defined colors
#include "colors.inc"
#include "textures.inc"
#include "glass.inc"
#include "metals.inc"
//#include "stones.inc"
#include "woods.inc"

/*	11Feb2001: 800x600 AA 0.3:
	Time for parse: 0h 0m 5s (5 seconds)
	Time for trace: 0h 51m 21s (3081 seconds)
	Total time: 0h 51m 26s (3086 seconds)
		18Feb2001: 320x240 No AA:
	Time for parse: 0h 0m 6s (6 seconds)
	Time for trace: 0h 4m 35s (275 seconds)
	Total time: 0h 4m 41s (281 seconds)
		19Feb2001: 800x600 AA 0.3:
	Time for parse: 0h 0m 4s (4 seconds)
	Time for trace: 0h 53m 22s (3202 seconds)
	Total time: 0h 53m 26s (3206 seconds)
*/

//global_settings{max_trace_level 10}

// Units
#declare in = 1;// Redefine only this to change scale.
#declare ft = 12*in;
#declare yd = 36*in;
#declare mi = 5280*ft;

/* Checklist
	/ Put altar and screen into church
	/ Put honeypot on altar
	/ Add priest
	/ Change the roof to wood, and add rafters for detail
	/ Fix where the columns and arches don't join
	/ Use a loop for columns & arches
	/ Add metalwork to doors
	/ Add stained glass windows
	/ Add congregation
	/ Correct parishioners' eyelines
	/ Fix rear ledge
	/ Close the door
	/ re-texture honeypot
	/ move viewpoint to right?
	change windows
	add credits
*/

#fopen DebugFile "pdmhoney.debug" write

//#declare LookAt    = <0,6,0>*in;//scene
//#declare ViewPoint = <0,10,-8>*in;//scene

//development values

#declare Tester=0;
#declare CameraLight=0;#declare CameraAdjust=<1,1,1>;
#declare GeneralLight=0;#declare GeneralAdjust=<1,1,1>;
#declare GeneralLightXYZ=<0,30,-12>*in;
#declare BackLight=0;#declare BackAdjust=<1,1,1>;
#declare Hazy=1;

#declare BlackPt=texture{pigment{Black}}
#declare BluePt=texture{pigment{Blue}}
#declare GreenPt=texture{pigment{Green}}
#declare Grey25Pt=texture{pigment{Gray25}}
#declare Grey50Pt=texture{pigment{Gray50}}
#declare OrangePt=texture{pigment{Orange}}
#declare RedPt=texture{pigment{Red}}
#declare YellowPt=texture{pigment{Yellow}}

background{colour rgb <0.6,0.6,0.9>}

// based on T_Stone30 and T_Stone33
#declare ChurchStone=
texture{
	pigment{
		gradient x turbulence 0.75 frequency 6
		scale 0.5 rotate <0, -45, 30>
		warp{repeat <2,0,0>*in offset <0,8,0>*in flip <0,0,1>}		
		colour_map{ 
			[0.02 colour rgbf <0.85, 0.85, 0.45, 0.0>]
			[0.06 colour rgbf <0.65, 0.65, 0.40, 0.0>]
			[0.10 colour rgbf <0.90, 0.90, 0.65, 0.0>]
			[1.00 colour rgbf <0.85, 0.85, 0.45, 0.0>]
		}
	}
}
texture{
	pigment{
		crackle turbulence 0.3 lambda 2.5 omega 0.75 octaves 5 frequency 2 phase 0.25
		scale 0.45 rotate <0, 5, 60>
		warp{repeat <2,0,0>*in offset <0,8,0>*in flip <0,0,1>}		
		colour_map{ 
			[0.00 colour Clear]
			[0.25 colour rgbf <0.40, 0.40, 0.15, 0.75>]
			[0.30 colour rgbf <0.20, 0.20, 0.10, 0.50>]
			[0.35 colour rgbf <0.40, 0.40, 0.20, 0.75>]
			[0.40 colour rgbf <0.65, 0.65, 0.30, 0.90>]
			[0.65 colour Clear]
		}
	}
}
texture{
	pigment{
		crackle turbulence 0.1 lambda 2.5 omega 0.75 octaves 5 frequency 1 phase 0.25
		scale 0.75 rotate <0, 45, 60>
		warp{repeat <2,0,0>*in offset <0,8,0>*in flip <0,0,1>}		
		colour_map{ 
			[0.00 colour Clear]
			[0.15 colour rgbf <0.40, 0.15, 0.45, 0.60>]
			[0.18 colour rgbf <0.20, 0.10, 0.00, 0.40>]
			[0.25 colour rgbf <0.20, 0.15, 0.45, 0.60>]
			[0.30 colour rgbf <0.40, 0.15, 0.45, 0.80>]
			[0.65 colour Clear]
		}
	}
}

#declare ChurchFloor=
texture{
	pigment{
		gradient x turbulence 0.75 frequency 6
		scale 0.5 rotate <0, 60,-30>
		warp{repeat <2,0,0>*in offset <0,8,0>*in flip <0,0,1>}		
		colour_map{ 
			[0.02 colour rgbf <0.55, 0.55, 0.30, 0.0>]
			[0.06 colour rgbf <0.45, 0.45, 0.25, 0.0>]
			[0.10 colour rgbf <0.60, 0.60, 0.45, 0.0>]
			[1.00 colour rgbf <0.55, 0.55, 0.30, 0.0>]
		}
	}
}
texture{
	pigment{
		crackle turbulence 0.3 lambda 2.5 omega 0.75 octaves 5 frequency 2 phase 0.25
		scale 0.45 rotate <0, 5, 60>
		warp{repeat <2,0,0>*in offset <0,8,0>*in flip <0,0,1>}		
		colour_map{ 
			[0.00 colour Clear]
			[0.25 colour rgbf <0.40, 0.40, 0.15, 0.75>]
			[0.30 colour rgbf <0.20, 0.20, 0.10, 0.50>]
			[0.35 colour rgbf <0.40, 0.40, 0.20, 0.75>]
			[0.40 colour rgbf <0.65, 0.65, 0.30, 0.90>]
			[0.65 colour Clear]
		}
	}
}
texture{
	pigment{
		crackle turbulence 0.1 lambda 2.5 omega 0.75 octaves 5 frequency 1 phase 0.25
		scale 0.75 rotate <0, 45, 60>
		warp{repeat <2,0,0>*in offset <0,8,0>*in flip <0,0,1>}		
		colour_map{ 
			[0.00 colour Clear]
			[0.15 colour rgbf <0.40, 0.15, 0.45, 0.60>]
			[0.18 colour rgbf <0.20, 0.10, 0.00, 0.40>]
			[0.25 colour rgbf <0.20, 0.15, 0.45, 0.60>]
			[0.30 colour rgbf <0.40, 0.15, 0.45, 0.80>]
			[0.65 colour Clear]
		}
	}
}

#declare RoofWood=
texture{
	pigment{P_WoodGrain17A colour_map{M_Wood17A} warp{repeat <1,0,0>*in offset <0,8,0>*in flip <1,0,0>}}
} 
texture{
	pigment{P_WoodGrain17B colour_map{M_Wood17B}}
}

#declare RoofWood2=
texture{
	pigment{P_WoodGrain17A colour_map{M_Wood14A} warp{repeat <1,0,0>*in offset <0,8,0>*in flip <1,0,0>}}
} 
texture{
	pigment{P_WoodGrain17B colour_map{M_Wood14B}}
}

#include "tedbearm.inc"
#include "beartex.inc"
#include "bearlist.inc"
#include "congregation.inc"
#if (Tester=0)
	//#declare LookAt    = <0,6,6>*in;//scene?
	#declare LookAt    = <0,6,-16>*in;//mid-aisle
	//#declare LookAt    = <0,12,0>*in;//church roof
	//#declare LookAt    = <0,3,-36>*in;//church door
	//#declare LookAt    = <0,4,10>*in;//priest's door
	//#declare ViewPoint = LookAt+<0,0,-8>*in;//inspect feature
	//#declare ViewPoint = LookAt+<0,1,3>*in;//priestly view
	//#declare ViewPoint = LookAt+<0,-1,-21>*in;//in the aisle
	//#declare ViewPoint = LookAt+<0,2,18>*in;//outside priest's door
	//#declare ViewPoint = <-3,6,9>*in;//behind priest
	#declare ViewPoint = <-4.5,6,9>*in;//behind priest, to his right
	//#declare ViewPoint = LookAt+<0,15,28>*in;//overview
	//#declare ViewPoint = LookAt+<0,-2.5,-50>*in;//outside door
	//#declare ViewPoint = <0,6,-21>*in;//from the aisle
	//#declare ViewPoint = <0,20,-50>*in;//from the air
	//#declare ViewPoint = <0,36,-50>*in;//further up in the air
	//#declare ViewPoint = <-48,6,-16>*in;//side view
	#declare CameraLight=0.5;#declare GeneralLight=2;#declare BackLight=1;
	#declare GeneralAdjust=<1,1,1>;#declare GeneralLightXYZ=<30,30,-12>*in;
	#local Setting=1;
#else
	#if (Tester=1)
		#declare LookAt    = <0,2.5,0>*in;//scene
		#declare ViewPoint = LookAt+<0,0.5,4.5>*in;//close-up
		#declare CameraLight=0.5;#declare GeneralLight=0;
		#declare GeneralAdjust=<1,1,1>;#declare GeneralLightXYZ=<0,30,-12>*in;
		#local Setting=2;
	#else
		#if (Tester=2)
			#declare LookAt    = <0,2.5,0>*in;//scene
			#declare ViewPoint = LookAt+<0,0.5,4.5>*in;//close-up
			#declare CameraLight=0.75;#declare GeneralLight=0;#declare GeneralLightXYZ=<0,30,-12>*in;
			#declare GeneralAdjust=<1,1,1>;
			#local Setting=3;
		#else
			//#declare LookAt    = <0,2.5,-3>*in;//scene
			#declare LookAt    = <0,1.5,5>*in;//altar
			#declare ViewPoint = LookAt+<0,3,-20>*in;//front view
			//#declare ViewPoint = LookAt+<0,15,-1>*in;//plan view
			#declare CameraLight=0.75;#declare GeneralLight=0.75;#declare BackLight=1;
			#declare GeneralAdjust=<1,1,1>;#declare GeneralLightXYZ=<0,30,-12>*in;
			#local Setting=0;
		#end		
	#end
#end
#include "bearchurch.inc"

#if (CameraLight>0)
  light_source {
    ViewPoint
    colour rgb <1,1,1>*CameraLight*CameraAdjust
  }
#end

#if (GeneralLight>0)
  light_source {
    GeneralLightXYZ
    colour rgb <1,1,1>*GeneralLight*GeneralAdjust
  }
#end

#if (BackLight>0)
  light_source {
    ViewPoint*<0,1,-2>
    colour rgb <1,1,1>*BackLight*BackAdjust
  }
#end

//object{Marker scale 2 translate ViewPoint*<0,1,-1>}

camera{
  location  ViewPoint
  #if (Tester=2) right x #end
  look_at   LookAt
}

#fclose DebugFile
