// Persistence Of Vision INCLUDE file
// File:        tedbearm.inc
// Vers:        3.1 Mac PPC
// Desc:        A 4-inch high teddy bear (as a macro)
// Auth:        Peter Murray
// Date:        16 January-26 February 2001
// Version:     costumable bear with opening mouth, different noses.

#debug "\r  tedbearm.inc - Macro for a 4-inch teddy bear.\r"

// Measurements might already be defined.
#ifndef(in)
	#declare in = 1;
#end

// Define the default textures
#declare dNoseTx=
texture{
	pigment{rgb <0,0,0>}
}

#declare dMouthTx=
texture{
	pigment{rgb <0,0,0>}
}

#declare dEyeTx=
texture{
	pigment{rgb <0,0,0>}
}

#declare dFurTx=
texture{
	normal{
	ripples 2 turbulence 0.5 omega 1 lambda 4
	rotate <30,20,10>
	}
	pigment{
	granite
	colour_map{
		[0.0 colour rgb <.65,.65,.25>]
		[0.3 colour rgb <.75,.75,.25>]
		[0.6 colour rgb <.75,.80,.25>]
		[1.0 colour rgb <.75,.75,.25>]
	}
	scale .5
	}
}

#declare dContrastTx=
texture{
	normal{
	ripples 2 turbulence 0.5 omega 1 lambda 4
	rotate <30,20,10>
	}
	pigment{
	granite
	colour_map{
		[0.0 colour rgb <.78,.78,.30>]
		[0.3 colour rgb <.90,.90,.30>]
		[0.6 colour rgb <.80,.96,.30>]
		[1.0 colour rgb <.90,.90,.30>]
	}
	scale .5
	}
}

/* Passed parameter values (mostly rotations):
	 pWhere: Location of final bear.
	 pRotn: Its rotation about its own axis.
	 pRotations: array[13] of limb rotations:
	   0 Head rotation (about neck),
	   1 Right arm (about shoulder), 2 right lower arm (about elbow), 3* right paw (about wrist),
	   4 Left arm (about shoulder), 5 left lower arm (about elbow), 6* left paw (about wrist),
	   7 Right leg (about hip), 8 right calf (about knee), 9* right pad (about ankle),
	   10 Left leg (about hip), 11 left calf (about knee), 12* left pad (about ankle)
	   * means not yet done/separated out
	 pTextureA:	array[5] of textures:
		 0 Fur, 1 Contrast, 2 Eyes, 3 Mouth, 4 Nose.
	 pHeadvars: array[8] of (mostly) head controls (Cuddy is "normal" for each):
	             [0] mouth 0 open 1 closed;
	             [1] nose 0 big round 1 small round 2 narrow triangle 3 wide triangle 4 wide+nostrils 5 narrow+nostrils
	                 6 high round;
	             [2] cheeks -1 emaciated, -0.5 thin, 0 normal, 0.5 plump, 1 puffy;
	             [3] ears -1 none 0 original 1 Charlie 2 Chubby 3 Humphrey;
	             [4] muzzle 0 original 1 enlarged;
	             [5] right eye 0 open 1 closed
	             [6] left eye 0 open 1 closed
	             [7]*traditional hump.
	             [8] feet 0 none 1 traditional
	             * means not yet done
	 pScaled: overall scaling - needs to be applied to each body part before rotation.
*/
#macro TeddyBearRev(pWhere,pRotn,pRotations,pTextureA,pHeadvars,pScaled)
	object{
		union{
			blob{// torso
				threshold .5
				//	#debug "\r	Fix those units.\r"
				component 2,0.375,< 0.5625,2.6875,0.000> //r shoulder
				component 2,0.375,<-0.5625,2.6875,0.000> //l shoulder
				component 2.75,.5,< 0.375,2.625,0.000>	//r collar
				component 2.75,.5,< 0.000,2.625,0.000>	//c collar
				component 2.75,.5,<-0.375,2.625,0.000>	//l collar
				component 3,.5,< 0.250,2.250,0.000>	//r chest
				component 3,.5,<-0.250,2.250,0.000>	//l chest
				sphere{< 0.375,1.875,0.100>,.5, 3 }//texture{pTextureA[1]}}	//r waist
				sphere{< 0.000,1.875,0.000>,0.5,3} //upper tummy
				sphere{< 0.000,1.875,0.125>,.5, 3 texture{pTextureA[1]}}
				sphere{<-0.375,1.875,0.100>,.5, 3 }//texture{pTextureA[1]}}	//l waist
				sphere{< 0.375,1.500,0.100>,.5, 3}	//r upper hip
				sphere{< 0.000,1.500,0.000>,0.5,3}	//tummy
				sphere{< 0.375,1.700,0.100>,.5, 4 }
				sphere{< 0.000,1.700,0.200>,.5, 4 texture{pTextureA[1]}}
				sphere{<-0.375,1.700,0.100>,.5, 4 }
				sphere{<-0.375,1.500,0.100>,.5, 3}
				sphere{< 0.000,1.250,0.000>,0.5,3}	//groin
				sphere{< 0.375,1.5625,0.000>,0.625,2} //r hip
				sphere{<-0.375,1.5625,0.000>,0.625,2} //l hip
				scale pScaled
				texture{pTextureA[0]}
			}//-blob
		#ifdef (TeddyShirt)
			object{
				TeddyShirt
				scale pScaled
			}
		#end
		union{// r leg
			blob{// r thigh
				threshold .5
				cylinder{< 0, 0.000,0.000>,< 0,-0.375,0.000>,0.625,2}
				scale pScaled
				texture{pTextureA[0]}
			}
			union{
				blob{// r calf
					threshold .5
					sphere{< 0,0,0.000>,0.625,2}
					sphere{< 0,-0.5,0.000>,0.625,2} //r foot
					scale pScaled
					texture{pTextureA[0]}
				}//-blob
				#if (pHeadvars[8]=1)// r foot
					blob{
						threshold .5
						sphere{< 0,0,0.500>,0.625,1}
						sphere{< 0,0,0.250>,0.625,1}
						scale <0.75,0.5,1>
						texture{pTextureA[0]}
						rotate pRotations[9]
						translate <0,-0.875,0>*pScaled
						scale pScaled
					}
				#end
				rotate pRotations[8]
				translate <0,-0.375,0>*pScaled
			}
			#ifdef (TeddyRClothes)
				object{
					TeddyRClothes
					scale pScaled
				}
			#end
			rotate pRotations[7]
			translate <0.375,1.5625,0>*pScaled
		}//-r leg
		union{// l leg
			blob{// l thigh
				threshold .5
				cylinder{< 0, 0.000,0.000>,< 0,-0.375,0.000>,0.625,2}
				scale pScaled
				texture{pTextureA[0]}
			}
			union{
				blob{// l calf
					threshold .5
					sphere{< 0,0,0.000>,0.625,2}
					sphere{< 0,-0.5,0.000>,0.625,2} //l foot
					scale pScaled
					texture{pTextureA[0]}
				}//-blob
				#if (pHeadvars[8]=1)// l foot
					blob{
						threshold .5
						sphere{< 0,0,0.500>,0.625,1}
						sphere{< 0,0,0.250>,0.625,1}
						scale <0.75,0.5,1>
						texture{pTextureA[0]}
						rotate pRotations[12]
						translate <0,-0.875,0>*pScaled
						scale pScaled
					}
				#end
				rotate pRotations[11]
				translate <0,-0.375,0>*pScaled
			}
			#ifdef (TeddyLClothes)
				object{
					TeddyLClothes
					scale pScaled
				}
			#end
			rotate pRotations[10]
			translate <-0.375,1.5625,0>*pScaled
		}//-l leg
		union{// r arm
			blob{// r upper arm
				threshold .5
				cylinder{< 0.000,0.000,0.000>,< 0.09375,-0.28125,0.000>,0.375,2}
				scale pScaled
				texture{pTextureA[0]}
			}//-blob
			#ifdef (TeddyRUSleeve)
				object{
					TeddyRUSleeve
					scale pScaled
				}
			#end
			blob{// r lower arm
				threshold .5
				cylinder{<0,0,0>,< 0.28125,-0.59375,0.000>,0.375,2}
				sphere{< 0.140625,-0.46875,0.000>,0.375,2 texture{pTextureA[1]}} //r hand
				texture{pTextureA[0]}
				scale pScaled
				rotate pRotations[2]
				translate <0.09375,-0.28125,0>*pScaled
			}//-blob
			#ifdef (TeddyRLSleeve)
				object{
					TeddyRLSleeve
					scale pScaled
					rotate pRotations[2]
					translate <0.09375,-0.28125,0>*pScaled
				}
			#end
			rotate pRotations[1]
			translate <0.5625,2.6875,0>*pScaled
		}//- r arm
		union{// l arm
			blob{// l upper arm
				threshold .5
				cylinder{< 0.000,0.000,0.000>,<-0.09375,-0.28125,0.000>,0.375,2}
				scale pScaled
				texture{pTextureA[0]}
			}//-blob
			#ifdef (TeddyLUSleeve)
				object{
					TeddyLUSleeve
					scale pScaled
				}
			#end
			blob{// l lower arm
				threshold .5
				cylinder{<0,0,0>,<-0.28125,-0.59375,0.000>,0.375,2}
				sphere{<-0.140625,-0.46875,0.000>,0.375,2 texture{pTextureA[1]}} //l hand
				texture{pTextureA[0]}
					scale pScaled
				rotate pRotations[5]
				translate <-0.09375,-0.28125,0>*pScaled
			}//-blob
			#ifdef (TeddyLLSleeve)
				object{
					TeddyLLSleeve
					scale pScaled
					rotate pRotations[5]
					translate <-0.09375,-0.28125,0>*pScaled
				}
			#end
			rotate pRotations[4]
			translate <-0.5625,2.6875,0>*pScaled
		}//- l arm
			union{//head
				difference{
					blob{
						threshold .5
						component 2,.375,< 0.000,0.000,0.000> //neck
						sphere{< 0.250,0.250,0.000>,.5,2.75 scale <1,1,1.25>} //r cheek
						sphere{< 0.375,0.250,0.125>,.5,2.75*pHeadvars[2]}
						sphere{< 0.000,0.250,0.000>,.5,2.75}
						sphere{<-0.250,0.250,0.000>,.5,2.75 scale <1,1,1.25>} //l cheek
						sphere{<-0.375,0.250,0.125>,.5,2.75*pHeadvars[2]}
						sphere{< 0.250,0.500,0.000>,.5,2.75}
						sphere{< 0.000,0.500,-0.10>,.5,2.75}
						sphere{< 0.000,0.250,0.000>,.5,-2.75 scale <1,1,1.25>} //space for mouth
						cylinder{//"chin"
							< 0.000,0.000,0.350>,< 0.000,0.000,-0.000>,.0625,2.75 scale <5,1,1>
						}
						sphere{ //snout
							0,.5,2.75 scale <1,1-0.4*pHeadvars[4],1+0.4*pHeadvars[4]>
							translate < 0.000,0.500,0.200>
						}
						#if (pHeadvars[4]>0)
							#local SnoutOriginZ=0.5;
							sphere{
								0,.5,2.75 scale <0.5,0.5,0.75> texture{pTextureA[1]}
								translate < 0.000,0.500,0.500>
							}
							sphere{
								0,.5,1 scale <0.5,0.5,1> texture{pTextureA[1]}
								translate < 0.000,0.250,0.400>
							}
						#else
							#local SnoutOriginZ=0.2;
						#end
						sphere{
							0,.5,2.75 scale <1,1,1>
							translate < 0.100,0.400,0.150>
						}
						sphere{
							0,.5,2.75 scale <1,1,1>
							translate <-0.100,0.400,0.150>
						}
						sphere{<-0.250,0.500,0.000>,.5,2.75}
						sphere{< 0.250,0.6875,0.000>,.5,2.75} //r temple
						sphere{< 0.000,0.750,0.000>,.5,2.75} //forehead
						sphere{<-0.250,0.6875,0.000>,.5,2.75} //l temple   
						#switch (pHeadvars[3])
							#case (0) //original Cuddy ears
								sphere{< 0.525,0.800,-0.1000>,.375,2} //r ear
								sphere{< 0.400,0.925,-0.1000>,.375,2}
								sphere{< 0.375,0.800, 0.1000>,.375,-1 texture{pTextureA[1]}}
								sphere{<-0.525,0.800,-0.1000>,.375,2} //l ear
								sphere{<-0.400,0.925,-0.1000>,.375,2}
								sphere{<-0.375,0.800, 0.1000>,.375,-1 texture{pTextureA[1]}}
							#break
							#case (1) //Charlie (bears bk 13)
								sphere{< 0.675,0.700,-0.1000>,.375,2} //r ear
								sphere{< 0.650,0.550,-0.1000>,.375,2}
								sphere{< 1.300,0.550, 0.0050>,.375,-2 scale <0.5,1,1> texture{pTextureA[1]}}
								sphere{<-0.675,0.700,-0.1000>,.375,2} //l ear
								sphere{<-0.650,0.550,-0.1000>,.375,2}
								sphere{<-1.300,0.550, 0.0050>,.375,-2 scale <0.5,1,1> texture{pTextureA[1]}}
							#break
							#case (2) //Chubby (bears bk 45)
								sphere{< 0.500,0.950,-0.0500>,.375,2} //r ear
								sphere{< 0.525,0.800,-0.1000>,.375,2}
								sphere{< 0.400,0.925,-0.1000>,.375,2}
								sphere{< 0.375,0.800, 0.0050>,.375,-1 texture{pTextureA[1]}}
								sphere{<-0.500,0.950,-0.0500>,.375,2} //l ear
								sphere{<-0.525,0.800,-0.1000>,.375,2}
								sphere{<-0.400,0.925,-0.1000>,.375,2}
								sphere{<-0.375,0.800, 0.0050>,.375,-1 texture{pTextureA[1]}}
							#break
							#case (3) //Humphrey (bears bk 67)
								sphere{< 0.550,1.000,-0.1000>,.375,2} //r ear
								sphere{<-0.550,1.000,-0.1000>,.375,2} //l ear
							#break
						#end             
						texture{pTextureA[0]}
					}//-blob
					cylinder{//mouth space
						< 0.000,0.200,0.750>,< 0.000,0.200,-0.000>,.25 scale <0.75,1,1>
						texture{pigment{colour rgb <0.75,0.25,0.05>}}
					}
				}
				blob{//mouth
					threshold .6
					sphere{ //jaw
						<0,0,0>,.5,1.5 scale <1,0.75,0.8>
						translate <0.000,0.100,0.300>
						texture{pTextureA[0]}
						rotate x*pHeadvars[0]*-18
					}
					sphere{
						<0,0,0>,.375,1
						translate <0.000,-0.250,0.000>
						texture{pTextureA[0]}
						rotate x*pHeadvars[0]*-18
					}
					sphere{< 0.400,0.250,0.000>,.375,1 scale <0.8,1,1>} //r cheek
					sphere{<-0.400,0.250,0.000>,.375,1 scale <0.8,1,1>} //l cheek
					texture{pTextureA[0]}
				}//-blob
				#switch (pHeadvars[1])
					#case (0)//big round nose
						sphere{
							<0,0,0>,0.25
							scale <1,0.5,1>
							translate <0,0.525,0.25+SnoutOriginZ>
							texture{pTextureA[4]}
						}
					#break                  	
					#case (1)//little round nose
						sphere{
							<0,0,0>,0.25
							scale <0.5,0.5,1>
							translate <0,0.525,0.25+SnoutOriginZ>
							texture{pTextureA[4]}
						}
					#break                  	
					#case (2)//narrow triangular nose            
						difference{
							sphere{
								<0,0,0>,0.25
								scale <0.5,0.5,1>
								translate <0,0.525,0.25+SnoutOriginZ>
								texture{pTextureA[4]}
							}
							box{<0,-0.2,-0.2>,<-0.2,0.2,0.3> rotate z*50 translate <0,0.525,0.25+SnoutOriginZ>}   
							box{<0,-0.2,-0.2>,<0.2,0.2,0.3> rotate z*-50 translate <0,0.525,0.25+SnoutOriginZ>}   
						}
					#break                  	
					#case (3)//wide triangular nose            
						difference{
							sphere{
								<0,0,0>,0.25
								scale <1,0.5,1>
								translate <0,0.525,0.25+SnoutOriginZ>
								texture{pTextureA[4]}
							}
							box{<0,-0.2,-0.2>,<-0.3,0.3,0.3> rotate z*60 translate <0,0.525,0.25+SnoutOriginZ>}   
							box{<0,-0.2,-0.2>,<0.3,0.3,0.3> rotate z*-60 translate <0,0.525,0.25+SnoutOriginZ>}   
						}
					#break                  	
					#case (4)//round nose w nostrils - large
					#case (5)//narrow
						//union{
						difference{
							sphere{
								<0,0,0>,0.25
								scale <1,0.5,1>
								translate <0,0.525,0.25+SnoutOriginZ>
								texture{pTextureA[4]}
							}
							cylinder{<0,0,-0.3>,<0,0,0.3>,0.1 scale <0.6,0.5,1> translate <0.125,0.475,0.25+SnoutOriginZ>}
							cylinder{<0,0,-0.3>,<0,0,0.3>,0.1 scale <0.6,0.5,1> translate <-0.125,0.475,0.25+SnoutOriginZ>}
							#if (pHeadvars[1]=5) scale <0.75,1,1> #end
						}
					#break                  	
					#case (6)//high round nose
						sphere{
							<0,0,0>,0.25
							scale <0.8,1,1>
							translate <0,0.525,0.25+SnoutOriginZ>
							texture{pTextureA[4]}
						}
					#break                  	
				#end
				intersection{//r half of mouth
					torus{
						.25,.02
					}
					box{
						<0,-.1,0>,<-.25,.1,.25>
					}
					scale <1,1.5,1>
					rotate <130,0,0>
					translate <0.25,0.525,.45+.5-.25>
					texture{pTextureA[3]}
				}
				intersection{//l half of mouth
					torus{
						.25,.02
					}
					box{
						<0,-.1,0>,<.25,.1,.25>
					}
					scale <1,1.5,1>
					rotate <130,0,0>
					translate <-0.25,0.525,.45+.5-.25>
					texture{pTextureA[3]}
				}
				sphere{//r eye
					<0,0,0>,.1
					texture{pTextureA[2]}
					translate <.25,0.725,.4>
				}
				difference{
					sphere{//r upper eyelid
						<0,0,0>,0.125
					}
					box{<-0.15,-0.15,0>,<0.15,0.15,0.15> texture{pTextureA[1]}}
					texture{pTextureA[0]}
					rotate <90,0,0>*pHeadvars[5]
					translate <.25,0.725,.4>
				}
				difference{
					sphere{//r lower eyelid
						<0,0,0>,0.125
					}
					box{<-0.15,-0.15,0>,<0.15,0.15,0.15> texture{pTextureA[1]}}
					texture{pTextureA[0]}
					rotate <-90,0,0>*pHeadvars[5]
					translate <.25,0.725,.4>
				}
				sphere{//l eye
					<0,0,0>,.1
					texture{pTextureA[2]}
					translate <-.25,0.725,.4>
				}
				difference{
					sphere{//l upper eyelid
						<0,0,0>,0.125
					}
					box{<-0.15,-0.15,0>,<0.15,0.15,0.15> texture{pTextureA[1]}}
					texture{pTextureA[0]}
					rotate <90,0,0>*pHeadvars[6]
					translate <-0.25,0.725,.4>
				}
				difference{
					sphere{//l lower eyelid
						<0,0,0>,0.125
					}
					box{<-0.15,-0.15,0>,<0.15,0.15,0.15> texture{pTextureA[1]}}
					texture{pTextureA[0]}
					rotate <-90,0,0>*pHeadvars[6]
					translate <-0.25,0.725,.4>
				}
				texture{pTextureA[0]}
				scale pScaled
				rotate pRotations[0]
				translate <0,2.875,0>*pScaled
			}//-union - head
		#ifdef (TeddyHat)
			//#debug "\r	Found a hat.\r"
			object{
				TeddyHat
				rotate pRotations[0]
				scale pScaled
				translate <0,2.875,0>*pScaled
			}
		#end
		}//-union
		texture{pTextureA[0]}
		rotate pRotn
		translate pWhere
	}//-macro teddybearrev
#end

// The invisible bear models clothes
#macro Baffler(pWhere,pRotn,pRotations,pTextureA,pHeadvars,pScaled)
	object{
		union{
		#ifdef (TeddyShirt)
			object{
				TeddyShirt
				scale pScaled
			}
		#end
		union{// r leg
			#ifdef (TeddyRClothes)
				object{
					TeddyRClothes
					scale pScaled
				}
			#end
			rotate pRotations[7]
			translate <0.375,1.5625,0>*pScaled
		}//-r leg
		union{// l leg
			#ifdef (TeddyLClothes)
				object{
					TeddyLClothes
					scale pScaled
				}
			#end
			rotate pRotations[10]
			translate <-0.375,1.5625,0>*pScaled
		}//-l leg
		union{// r arm
			#ifdef (TeddyRUSleeve)
				object{
					TeddyRUSleeve
					scale pScaled
				}
			#end
			#ifdef (TeddyRLSleeve)
				object{
					TeddyRLSleeve
					scale pScaled
					rotate pRotations[2]
					translate <0.09375,-0.28125,0>*pScaled
				}
			#end
			rotate pRotations[1]
			translate <0.5625,2.6875,0>*pScaled
		}//- r arm
		union{// l arm
			#ifdef (TeddyLUSleeve)
				object{
					TeddyLUSleeve
					scale pScaled
				}
			#end
			#ifdef (TeddyLLSleeve)
				object{
					TeddyLLSleeve
					scale pScaled
					rotate pRotations[5]
					translate <-0.09375,-0.28125,0>*pScaled
				}
			#end
			rotate pRotations[4]
			translate <-0.5625,2.6875,0>*pScaled
		}//- l arm
		#ifdef (TeddyHat)
			//#debug "\r	Found a hat.\r"
			object{
				TeddyHat
				rotate pRotations[0]
				scale pScaled
				translate <0,2.875,0>*pScaled
			}
		#end
		}//-union
		rotate pRotn
		translate pWhere
	}//-macro baffler
#end

