// Persistence Of Vision INCLUDE file
// File:        tshirt.cdf
// Vers:        3.1 Mac PPC
// Desc:        A T-shirt for tedbearm.inc to wear
// Auth:        Peter Murray
// Date:        28 January 2001

#debug "\r  tshirt.cdf - A T-shirt for bears.\r"

// Measurements might already be defined.
#ifndef(in)
	#declare in = 1;
	#declare ft = 12;
#end

// Pick up values/choices from the options arrays.

	// 0 T-shirt, 1 ?, 2 ?, 3 ?, 4 ?
	#local TShirtTx=BearTextureList[0]
	#local TShirtLTx=BearTextureList[1]
	#local TShirtRTx=BearTextureList[2]
	#local UnusedTx=BearTextureList[3]
	#local UnusedTx=BearTextureList[4]
	
#ifdef (TeddyHat) #undef TeddyHat #end

#declare TeddyShirt=// actually, it's a T-shirt
merge{
	#local xtnt=1.0;
	bicubic_patch{//left front panel
		type 1 flatness 0.1
		u_steps 5 v_steps 5
		<-0.7,2.875,0.25>*in <-0.5,2.875,0.25>*in <-0.25,2.875,0.55>*in <0,2.875,0.55>*in
		<-0.75,2.3465,0.25>*in <-0.6,2.3465,0.25>*in <-0.3,2.3465,0.55>*in <0,2.3465,0.55>*in
		<-0.85,1.9035,0.25>*in <-0.7,1.9035,0.6>*in <-0.4,1.9035,0.75>*in <0,1.9035,0.75>*in
		<-0.85,1.55,0.25>*in <-0.7,1.55,0.55>*in <-0.45,1.55,0.65>*in <0,1.55,0.65>*in
		texture{TShirtLTx translate <0,1.5,0>*in}
	}
	bicubic_patch{//right front panel
		type 1 flatness 0.1
		u_steps 5 v_steps 5
		<0.7,2.875,0.25>*in <0.5,2.875,0.25>*in <0.25,2.875,0.55>*in <0,2.875,0.55>*in
		<0.75,2.3465,0.25>*in <0.6,2.3465,0.25>*in <0.3,2.3465,0.55>*in <0,2.3465,0.55>*in
		<0.85,1.9035,0.25>*in <0.7,1.9035,0.6>*in <0.4,1.9035,0.75>*in <0,1.9035,0.75>*in
		<0.85,1.55,0.25>*in <0.7,1.55,0.55>*in <0.45,1.55,0.65>*in <0,1.55,0.65>*in
		texture{TShirtRTx translate <0,1.5,0>*in}
	}
	bicubic_patch{//right panel
		type 1 flatness 0.1
		u_steps 5 v_steps 5
		<0.7,2.875,0.25>*in <0.73,2.875,0.15>*in <0.73,2.875,-0.15>*in <0.7,2.875,-0.25>*in
		<0.75,2.3465,0.25>*in <0.78,2.3465,0.15>*in <0.78,2.3465,-0.15>*in <0.75,2.3465,-0.25>*in
		<0.85,1.9035,0.25>*in <0.88,1.9035,0.15>*in <0.88,1.9035,-0.15>*in <0.85,1.9035,-0.25>*in
		<0.85,1.55,0.25>*in <0.88,1.55,0.15>*in <0.88,1.55,-0.15>*in <0.85,1.55,-0.25>*in
	}
	bicubic_patch{//right back panel
		type 1 flatness 0.1
		u_steps 5 v_steps 5
		<0.65,2.875,-0.25>*in <0.5,2.875,-0.25>*in <0.25,2.875,-0.55>*in <0,2.875,-0.4>*in
		<0.75,2.3465,-0.25>*in <0.5,2.3465,-0.30>*in <0.3,2.3465,-0.55>*in <0,2.3465,-0.5>*in
		<0.85,1.9035,-0.25>*in <0.7,1.9035,-0.58>*in <0.4,1.9035,-0.6>*in <0,1.9035,-0.55>*in
		<0.85,1.55,-0.25>*in <0.7,1.55,-0.57>*in <0.4,1.55,-0.6>*in <0,1.55,-0.6>*in
	}
	bicubic_patch{//left back panel
		type 1 flatness 0.1
		u_steps 5 v_steps 5
		<-0.65,2.875,-0.25>*in <-0.5,2.875,-0.25>*in <-0.25,2.875,-0.55>*in <-0,2.875,-0.4>*in
		<-0.75,2.3465,-0.25>*in <-0.5,2.3465,-0.30>*in <-0.3,2.3465,-0.55>*in <-0,2.3465,-0.5>*in
		<-0.85,1.9035,-0.25>*in <-0.7,1.9035,-0.58>*in <-0.4,1.9035,-0.6>*in <-0,1.9035,-0.55>*in
		<-0.85,1.55,-0.25>*in <-0.7,1.55,-0.57>*in <-0.4,1.55,-0.6>*in <-0,1.55,-0.6>*in
	}
	bicubic_patch{//left panel
		type 1 flatness 0.1
		u_steps 5 v_steps 5
		<-0.7,2.875,0.25>*in <-0.73,2.875,0.15>*in <-0.73,2.875,-0.15>*in <-0.7,2.875,-0.25>*in
		<-0.75,2.3465,0.25>*in <-0.78,2.3465,0.15>*in <-0.78,2.3465,-0.15>*in <-0.75,2.3465,-0.25>*in
		<-0.85,1.9035,0.25>*in <-0.88,1.9035,0.15>*in <-0.88,1.9035,-0.15>*in <-0.85,1.9035,-0.25>*in
		<-0.85,1.55,0.25>*in <-0.88,1.55,0.15>*in <-0.88,1.55,-0.15>*in <-0.85,1.55,-0.25>*in
	}
	bicubic_patch{//left shoulder
		type 1 flatness 0.1
		u_steps 5 v_steps 5
		<-0.65,2.875,-0.25>*in <-0.5,2.875,-0.25>*in <-0.25,2.875,-0.55>*in <-0.1,2.875,-0.4>*in
		<-0.65,3.050,-0.15>*in <-0.5,3.125,-0.15>*in <-0.25,3.125,-0.35>*in <-0.1,3.125,-0.3>*in
		<-0.65,3.050,0.15>*in <-0.5,3.125,0.15>*in <-0.25,3.125,0.35>*in <-0.1,3.125,0.3>*in
		<-0.7,2.875,0.25>*in <-0.5,2.875,0.25>*in <-0.25,2.875,0.55>*in <0,2.875,0.55>*in
	}
	bicubic_patch{//right shoulder
		type 1 flatness 0.1
		u_steps 5 v_steps 5
		<0.65,2.875,-0.25>*in <0.5,2.875,-0.25>*in <0.25,2.875,-0.55>*in <0.1,2.875,-0.4>*in
		<0.65,3.050,-0.15>*in <0.5,3.125,-0.15>*in <0.25,3.125,-0.35>*in <0.1,3.125,-0.3>*in
		<0.65,3.050,0.15>*in <0.5,3.125,0.15>*in <0.25,3.125,0.35>*in <0.1,3.125,0.3>*in
		<0.7,2.875,0.25>*in <0.5,2.875,0.25>*in <0.25,2.875,0.55>*in <0,2.875,0.55>*in
	}
	texture{TShirtTx}
}

#declare TeddyLUSleeve=
merge{
	sphere{
		< 0.000,0.000,0.000>,0.375*in
	}
	cone{
		< 0.000,0.000,0.000>,0.375*in,<-0.09375,-0.28125,0>*in,0.375*in
	}
	sphere{
		<-0.09375,-0.28125,0>*in,0.375*in
	}
	texture{TShirtTx}
}

#ifdef (TeddyLLSleeve) #undef TeddyLLSleeve #end

#declare TeddyRUSleeve=
merge{
	sphere{
		< 0.000,0.000,0.000>,0.375*in
	}
	cone{
		< 0.000,0.000,0.000>,0.375*in,<0.09375,-0.28125,0>*in,0.375*in
	}
	sphere{
		<0.09375,-0.28125,0>*in,0.375*in
	}
	texture{TShirtTx}
}

#ifdef (TeddyRLSleeve) #undef TeddyRLSleeve #end
#ifdef (TeddyRClothes) #undef TeddyRClothes #end
#ifdef (TeddyLClothes) #undef TeddyLClothes #end
