// Persistence Of Vision INCLUDE file
// File:        idol.inc
// Vers:        3.1g.r1 Mac PPC
// Desc:        Ancient primitive idol
// Auth:        Peter Murray
// Date:        13-15th February 2001

#debug "\r  idol.inc - Ancient primitive idol\r"

#declare Bronzeish=
texture{//basic bronze
	pigment{P_Brass2}
	finish{F_MetalB}
	normal{dents 0.6}
}              
texture{//tarnish it
	pigment{
		bozo
		colour_map{
			[0.00 colour rgbf <0.4,0.8,0.5,0.0>]
			[1.00 colour rgbf <0.4,0.8,0.5,1.0>]
		}
	}
}

// The idol is modelled facing the camera.
#declare Idol=
union{
	//base
	box{<-2.5,0,-3.25>*ft,<2.5,1,2>*ft}
	box{<-2.5,0,-3>*ft,<2.5,2,2>*ft}
	//outline body
	sphere{0,6*in scale <4.5,8,2.5> translate <0,5,0.5>*ft}
	//sketch head
	difference{
		union{
			sphere{0,6*in scale <1.5,2,1.5> rotate <10,0,0> translate <0,10,0.25>*ft}
			sphere{0,6*in scale <1.5,3,0.75> rotate <30,0,0> translate <0,9,0>*ft}
			cylinder{<0,5,1.5>*ft,<0,9.5,0.5>*ft,6*in scale <1,1,0.75>}//neck
		}
		//nostrils
		cone{<0.25,8.0,-0.75>*ft,0*in,<0.3,8.5,-0.5>*ft,3*in}
		cone{<-0.3,8.0,-0.75>*ft,0*in,<-0.35,8.5,-0.5>*ft,3*in}
	}
	//eyes
	sphere{0,0.5*in scale <4,6,4> rotate <15,0,0> translate <0.5,9.25,-0.2>*ft}
	sphere{0,0.5*in scale <4,6,4> rotate <15,0,0> translate <-0.5,9.25,-0.2>*ft}
	//mandibles
	torus{6*in,1*in rotate <-100,0,0> translate <0,7.5,-0.5>*ft}
	difference{
		torus{9*in,1*in}
		box{<-10,-1.5,-10>*in,<0,1.5,0>*in rotate <0,-45,0>}
		rotate <-75,0,0> translate <0,7.5,-0.75>*ft
	}
	//headcrest
	mesh{
	  triangle{<0,10,0.25>*ft,<0,11.5,-1.5>*ft,<0,11.25,-0.7>*ft}
	  triangle{<0,10,0.25>*ft,<0,11.25,-0.7>*ft,<0,11.75,-0.5>*ft}
	  triangle{<0,10,0.25>*ft,<0,11.75,-0.5>*ft,<0,11.25,0.5>*ft}
	  triangle{<0,10,0.25>*ft,<0,11.25,0.5>*ft,<0,11.25,1.5>*ft}
	  triangle{<0,10,0.25>*ft,<0,11.25,1.5>*ft,<0,7.5,0.75>*ft}
	}
	cone{<0,10,0.25>*ft,3*in,<0,11.5,-1.5>*ft,0.25*in}
	cone{<0,10,0.25>*ft,3*in,<0,11.75,-0.5>*ft,0.25*in}
	cone{<0,10,0.25>*ft,3*in,<0,11.25,1.5>*ft,0.25*in}
	//sketch arms
	//left
	sphere{0,6*in scale <1.5,2,1.5> rotate <0,0,45> translate <1.5,7.4,0.5>*ft}
	sphere{0,6*in scale <1,4,1> rotate <60,-25,0> translate <2.75,6.5,-0.75>*ft}
	sphere{0,6*in scale <1,3,1> rotate <65,10,0> translate <3,5.25,-3>*ft}	
	//right
	sphere{0,6*in scale <1.5,2,1.5> rotate <0,0,-45> translate <-1.5,7.4,0.5>*ft}
	sphere{0,6*in scale <1,4,1> rotate <60,25,0> translate <-2.75,6.5,-0.75>*ft}
	sphere{0,6*in scale <1,3,1> rotate <65,-10,0> translate <-3,5.25,-3>*ft}
	//sketch legs
	sphere{0,6*in scale <2,6,1.5> rotate <-30,0,0> translate <1.5,2,0.25>*ft}
	sphere{0,6*in scale <1.75,4,1.5> rotate <20,0,0> translate <1.5,2.7,-1.6>*ft}
	sphere{0,6*in scale <1.75,1,1.5> translate <1.5,2,-2.25>*ft}
	sphere{0,6*in scale <2,6,1.5> rotate <-30,0,0> translate <-1.5,2,0.25>*ft}
	sphere{0,6*in scale <1.75,4,1.5> rotate <20,0,0> translate <-1.5,2.7,-1.6>*ft}
	sphere{0,6*in scale <1.75,1,1.5> translate <-1.5,2,-2.25>*ft}
	//sketch wings
	union{//left
		cylinder{<1,7,1>*ft,<3,10,1>*ft,3*in}
		sphere{<3,10,1>*ft,3*in}
		cone{<3,10,1>*ft,2*in,<2.25,6.5,1>*ft,0.25*in}
		cone{<3,10,1>*ft,2*in,<3.5,6,1>*ft,0.25*in}
		cylinder{<3,10,1>*ft,<5,6,1>*ft,3*in}
		sphere{<5,6,1>*ft,3*in}
		cone{<5,6,1>*ft,3*in,<4.5,5,1>*ft,1*in}
		triangle{<1,7,1>*ft,<3,10,1>*ft,<5,6,1>*ft}
		triangle{<1,7,1>*ft,<4.5,5,1>*ft,<5,6,1>*ft}
		translate <-1,-7,-1>*ft
		rotate <0,0,15>
		translate <1,7,1>*ft
	}
	union{//right
		cylinder{<-1,7,1>*ft,<-3,10,1>*ft,3*in}
		sphere{<-3,10,1>*ft,3*in}
		cone{<-3,10,1>*ft,2*in,<-2.25,6.5,1>*ft,0.25*in}
		cone{<-3,10,1>*ft,2*in,<-3.5,6,1>*ft,0.25*in}
		cylinder{<-3,10,1>*ft,<-5,6,1>*ft,3*in}
		sphere{<-5,6,1>*ft,3*in}
		cone{<-5,6,1>*ft,3*in,<-4.5,5,1>*ft,1*in}
		triangle{<-1,7,1>*ft,<-3,10,1>*ft,<-5,6,1>*ft}
		triangle{<-1,7,1>*ft,<-4.5,5,1>*ft,<-5,6,1>*ft}
		translate <1,-7,-1>*ft
		rotate <0,0,-15>
		translate <-1,7,1>*ft
	}
	//tail
	cone{<0,5,1.25>*ft,6*in,<0,3,2>*ft,5*in}
	sphere{<0,3,2>*ft,5*in}
	cone{<0,3,2>*ft,5*in,<0,2,2.5>*ft,4*in}
	sphere{<0,2,2.5>*ft,4*in}
	cone{<0,2,2.5>*ft,4*in,<0,1.5,3>*ft,2*in}
	sphere{<0,1.5,3>*ft,2*in}
	cone{<0,1.5,3>*ft,2*in,<0,1,3.5>*ft,0*in}
	texture{Bronzeish}
}