// Persistence Of Vision INCLUDE file
// File:        rtd3.inc
// Vers:        3.1g.r1 Mac PPC
// Desc:        Simplified humans that can wear clothes
// Uses:				.cst costume files
// Auth:        Peter Murray

#debug "\r  rtd3.inc - define Render Test Dummy - Human, costumable\r"

/*
Macros:
	(all figures share the basic textures)
	("HFlesh" = skin, "HHair" = hair)
   RTDH3 Costumable
*/

// Measurements might already be defined.
#ifndef(in)
	#declare in = 1;
	#declare ft = 12;
#end

/*#declare HFlesh=
texture{
	pigment{
		colour rgb <.97,.82,.75>//<.76,.58,.45>
	}
}*/

#declare HFlesh=texture{pigment{colour rgb <0.89,0.51,0.46>}}
#declare HHair =texture{pigment{colour rgb <0.64,0.50,0.42>}}
#declare HBrain=texture{
	pigment{colour rgb <0.70,0.70,0.50>}
	normal{wrinkles turbulence 0.0 octaves 1.0 omega 0.1 lambda 1.0 scale <0.8,0.2,0.2>}
}
#declare HBone =texture{pigment{colour rgb <0.95,0.95,0.80>}}

#declare Sculpt1=texture{pigment{P_Chrome4} finish{F_MetalE}}
#declare Sculpt2=texture{pigment{P_Chrome2} finish{F_MetalB}}

/*
// Assumpta Fitzgerald
#local HFlesh=texture{pigment{colour rgb <0.89,0.51,0.46>}}
#local HHair =texture{pigment{colour rgb <0.29,0.19,0.00>}}
// Beth (Newsradio)
#local HFlesh=texture{pigment{colour rgb <0.86,0.69,0.68>}}
#local HHair =texture{pigment{colour rgb <0.72,0.41,0.24>}}
// Beverly Crusher
#local HFlesh=texture{pigment{colour rgb <0.81,0.59,0.62>}}
#local HHair =texture{pigment{colour rgb <0.64,0.43,0.25>}}
#local HHair2=texture{pigment{colour rgb <0.36,0.22,0.12>}}
// Data
#local HFlesh=texture{pigment{colour rgb <0.86,0.73,0.64>}}
#local HHair =texture{pigment{colour rgb <0.36,0.32,0.24>}}
// Deanna Troi
#local HFlesh=texture{pigment{colour rgb <0.84,0.66,0.59>}}
#local HHair =texture{pigment{colour rgb <0.52,0.39,0.23>}}
// Geordi LaForge
#local HFlesh=texture{pigment{colour rgb <0.33,0.22,0.10>}}
#local HHair =texture{pigment{colour rgb <0.07,0.08,0.08>}}
// Gloria (Newsradio)
#local HFlesh=texture{pigment{colour rgb <0.45,0.34,0.25>}}
#local HHair =texture{pigment{colour rgb <0.29,0.19,0.15>}}
// Happy Merryweather
#local HFlesh=texture{pigment{colour rgb <0.85,0.55,0.42>}}
#local HHair =texture{pigment{colour rgb <0.31,0.25,0.15>}}
// Jean-Luc Picard
#local HFlesh=texture{pigment{colour rgb <0.77,0.59,0.49>}}
#local HHair =texture{pigment{colour rgb <0.63,0.56,0.59>}}
// Joy Merryweather
#local HFlesh=texture{pigment{colour rgb <0.79,0.45,0.31>}}
#local HHair =texture{pigment{colour rgb <0.40,0.33,0.15>}}
// Lisa (Newsradio)
#local HFlesh=texture{pigment{colour rgb <0.88,0.65,0.55>}}
#local HHair =texture{pigment{colour rgb <0.64,0.50,0.42>}}
// Worf
#local HFlesh=texture{pigment{colour rgb <0.51,0.35,0.32>}}
#local HHair =texture{pigment{colour rgb <0.23,0.17,0.12>}}
*/

#declare HEyes=
texture{
	pigment{colour rgb<.9,.9,.9>}
}

#declare HIris=
texture{
	pigment{colour rgb<.6,.6,.9>}
}

// To be replaced later by a macro
#declare RHand=
union{
	sphere{
		<0,-0.5,0>*in,0.5*in
		scale <1.5,4,3.0>
	}
	sphere{
		<-0.75,-0.75,1>*in,0.5*in
		scale <0.75,2,0.75>
	}
	cylinder{//thumb
		<0.5,-1.5,-1>*in,<0.5,-4,-1>*in,0.375*in
	}//fingers:
	cylinder{//first
		<0,-2.5,-0.75>*in,<0,-5.5,-0.75>*in,0.375*in
	}
	cylinder{//index
		<0,-3,-0.375>*in,<0,-6,-0.375>*in,0.375*in
	}
	cylinder{//middle
		<0,-3,0.375>*in,<0,-5.75,0.375>*in,0.375*in
	}
	cylinder{//little
		<0,-2.5,0.75>*in,<0,-4.75,0.75>*in,0.375*in
	}
}

#declare LHand=
union{
	sphere{
		<0,-0.5,0>*in,0.5*in
		scale <1.5,4,3.0>
	}
	sphere{
		<-0.75,-0.75,-1>*in,0.5*in
		scale <0.75,2,0.75>
	}
	cylinder{//thumb
		<-0.5,-1.5,-1>*in,<-0.5,-4,-1>*in,0.375*in
	}//fingers:
	cylinder{//first
		<0,-2.5,-0.75>*in,<0,-5.5,-0.75>*in,0.375*in
	}
	cylinder{//index
		<0,-3,-0.375>*in,<0,-6,-0.375>*in,0.375*in
	}
	cylinder{//middle
		<0,-3,0.375>*in,<0,-5.75,0.375>*in,0.375*in
	}
	cylinder{//little
		<0,-2.5,0.75>*in,<0,-4.75,0.75>*in,0.375*in
	}
}
/*
sphere{
	<0,-1,0>*in,1*in
	scale <1.25,2.5,1.75>
}
*/
//box{<-1.25*in,0,-1.75*in>,<1.25*in,-5*in,1.75*in>}

/*
// Brain!  Scaled down - I measured it from a skull picture and applied it to a head.
#macro HumanBrain(headsize,brain_texture)
	union{
		#local XX=headsize.x;#local YY=headsize.y;#local ZZ=headsize.z;
		// 1 55-90% back @35% up
		sphere{0,0.5*in scale <XX,YY*0.3,ZZ*0.9> translate <0,-YY*0.25,ZZ*0.15>*in}
		// 2 35-95% back @50% up x*-10
		sphere{0,0.5*in scale <XX*1.5,YY*0.5,ZZ*1.2> rotate x*-10 translate <0,-YY*0.05,ZZ*0.2>*in}
		// 3 5-95% back 42-92% up
		sphere{0,0.5*in scale <XX*1.6,YY,ZZ*1.6> translate <0,YY*0.29,0>*in}
		// spinal cord: 60-65% back -30-40% up
		cylinder{<0,-YY*1.6,ZZ*0.25>*in,<0,-YY*0.2,ZZ*0.25>*in,0.2*in}
		texture{brain_texture}
	}
#end
*/

/*
#macro HumanSkull(headsize,bone_texture)
	difference{
		#local XX=headsize.x;#local YY=headsize.y;#local ZZ=headsize.z;
		union{
			sphere{0,0.5*in scale <XX*1.7,YY*1.1,ZZ*1.7> translate <0,YY*0.29,0>*in}
			sphere{0,0.5*in scale <XX*1.55,YY*0.8,ZZ*1.25> rotate x*-10 translate <0,YY*0.05,ZZ*0.2>*in}
			sphere{0,0.5*in scale <XX*1.7,YY*0.6,ZZ*1.2> translate <0,-YY*0.10,ZZ*0.1>*in}
			difference{
				cylinder{<0,YY*0.29,0>*in,<0,-2.4,0>*in,0.5*in scale <XX*1,1,ZZ*1.3> translate <0,0,-ZZ*0.2>}
				box{<-XX*0.9,YY*0.3,-ZZ*0.2>*in,<XX*0.9,-2.6,ZZ*0.9>*in}
			}
			difference{
				cylinder{<0,0,0>*in,<0,-YY*0.2,0>*in,0.5*in scale <XX*1.6,1,ZZ*1.3> translate <0,0,-ZZ*0.2>}
				box{<-XX*0.9,0.5,-ZZ*0.2>*in,<XX*0.9,-YY*0.5,ZZ*0.9>*in}
			}
			torus{(XX-0.25)*in,0.25*in scale <1,1,0.75> translate <0,-0.25,XX-ZZ/0.875>*in}
		}
		//orbits
		sphere{<0,0,0>,0.75*in translate <-1.3,0,-2.5>*in}
		sphere{<0,0,0>,0.75*in translate <1.3,0,-2.5>*in}
		//septum
		cone{<0,0,0>*in,0.1*in,<0,-YY*0.25+0.6,0>*in,0.75*in scale <0.8,1,2> translate <0,0,-ZZ*6/7>*in}
		sphere{<0,0.25,0>*in,0.75*in scale <0.8,0.5,2> translate <0,-YY*0.25+0.6,-ZZ*6/7>*in}
		//earholes or whatever
		cylinder{<-XX,-0.5,0.70>*in,<-XX*0.6,-0.5,0.70>*in,0.25*in}
		cylinder{<XX,-0.5,0.70>*in,<XX*0.6,-0.5,0.70>*in,0.25*in}
		texture{bone_texture}
	}
#end
*/

/*
#macro HeadSculpture(plocn,prtn)
	union{
		union{
			torus{0.9375*in,0.0625*in scale <3,2,3.125> translate <0,0,-0.375>*in}//XZ
			difference{
				torus{0.9375*in,0.0625*in scale <3,2,4.5> rotate x*90}//XY
				box{<-3.6,-4.6,-0.5>*in,<3.6,-2.5,0.5>*in}
			}
			difference{
				torus{0.9375*in,0.0625*in scale <4.5,2,3.5> rotate z*90}//+YZ
				box{<-0.5,-4.6,-3.6>*in,<0.5,0,3.6>*in}
				box{<-0.5,0,3.6>*in,<0.5,4.6,0>*in}
			}
			difference{
				torus{0.9375*in,0.0625*in scale <3.5,2,3.5> rotate z*90 translate <0,1,0>*in}//YZ
				box{<-0.5,-2.6,-3.6>*in,<0.5,4.6,0>*in}
			}
			// Mouth:
			cylinder{<-1.25,-1.5,-2.5>*in,<0,-1.35,-2.5>*in,0.125*in}
			cylinder{<0,-1.35,-2.5>*in,<1.25,-1.5,-2.5>*in,0.125*in}
			cylinder{<-1.25,-1.5,-2.5>*in,<0,-1.65,-2.5>*in,0.125*in}
			cylinder{<0,-1.65,-2.5>*in,<1.25,-1.5,-2.5>*in,0.125*in}
			// Eyebrows:
			cylinder{<-0.75,0.45*1.1,-3.5>*in,<-2.25,0.45*1.1,-3.5>*in,0.125*in texture{Sculpt2}}
			cylinder{<0.75,0.45*1.1,-3.5>*in,<2.25,0.45*1.1,-3.5>*in,0.125*in texture{Sculpt2}}
			// Hairline:
			cylinder{<-1.75,1.35,-2.5>*in,<-1,1.35,-3.5>*in,0.125*in texture{Sculpt2}}
			cylinder{<-1,1.35,-3.5>*in,<1,1.35,-3.5>*in,0.125*in texture{Sculpt2}}
			cylinder{<1,1.35,-3.5>*in,<1.75,1.35,-2.5>*in,0.125*in texture{Sculpt2}}
			// Ears:
			cylinder{<-3.30,0.45,1.05>*in,<-3,0,0.35>*in,0.25*in}
			cylinder{<-3.30,0.45,1.05>*in,<-3,-0.90,0.95>*in,0.25*in}
			cylinder{<-3,-0.90,0.95>*in,<-3,-1.35,0.35>*in,0.25*in}
			cylinder{<3.30,0.45,1.05>*in,<3,0,0.35>*in,0.25*in}
			cylinder{<3.30,0.45,1.05>*in,<3,-0.90,0.95>*in,0.25*in}
			cylinder{<3,-0.90,0.95>*in,<3,-1.35,0.35>*in,0.25*in}
			// Nose:
			cylinder{<0,-1.2,-4>*in,<0,0,-3.5>*in,0.125*in}
			cylinder{<0,-1.2,-4>*in,<-0.6,-0.8,-3>*in,0.125*in}
			cylinder{<0,-1.2,-4>*in,<0.6,-0.8,-3>*in,0.125*in}
			// Chin (and front of face):
			cylinder{<-1,-4.0,-2.5>*in,<1,-4.0,-2.5>*in,0.125*in}
			cylinder{<-1,-4.0,-2.5>*in,<-1.5,-0.75,-2.75>*in,0.125*in}
			cylinder{<-1.5,-0.75,-2.75>*in,<-2.5,-0.75,-2.5>*in,0.125*in}
			cylinder{<-2.5,-0.75,-2.5>*in,<-2.5,0,-2.5>*in,0.125*in}
			cylinder{<1,-4.0,-2.5>*in,<1.5,-0.75,-2.75>*in,0.125*in}
			cylinder{<1.5,-0.75,-2.75>*in,<2.5,-0.75,-2.5>*in,0.125*in}
			cylinder{<2.5,-0.75,-2.5>*in,<2.5,0,-2.5>*in,0.125*in}
			// Jaw: from chin to y=10%, z=40% to y=25%,z=60%
			cylinder{<-1,-4.0,-2.5>*in,<-1,-3.6,-0.35>*in,0.125*in}
			cylinder{<-1,-3.6,-0.35>*in,<-1,-2.5,0.35>*in,0.125*in}
			cylinder{<1,-4.0,-2.5>*in,<1,-3.6,-0.35>*in,0.125*in}
			cylinder{<1,-3.6,-0.35>*in,<1,-2.5,0.35>*in,0.125*in}
			cylinder{<-2.5,-2.5,0.35>*in,<2.5,-2.5,0.35>*in,0.125*in}
			cylinder{<-1,-3.6,-0.35>*in,<1,-3.6,-0.35>*in,0.125*in}
			translate <0,8,0>*in
		}
		// Eyes
		sphere{//eyeball
			<0,0,0>,.5*in scale <1.5,1,1> translate <-1.5*in,8*in,-3.0*in> texture{Sculpt1}
		}
		sphere{//iris
			<0,0,0>,.5*in scale <0.4,0.4,0.1> translate <-1.5*in,8*in,-3.5*in> texture{Sculpt2}
		}
		sphere{//eyeball
			<0,0,0>,.5*in scale <1.5,1,1> translate <1.5*in,8*in,-3.0*in> texture{Sculpt1}
		}
		sphere{//iris
			<0,0,0>,.5*in scale <0.4,0.4,0.1> translate <1.5*in,8*in,-3.5*in> texture{Sculpt2}
		}
		// Neck: front -30%; back -5%; (mid -17.5%)
		cylinder{<-1.8,1.925,0>*in,<-1,5.5,0.35>*in,0.125*in}
		cylinder{<1.8,1.925,0>*in,<1,5.5,0.35>*in,0.125*in}
		cylinder{<0,3.05,1.5>*in,<0,6.5,1.5>*in,0.125*in}
		cylinder{<0,0.8,-1.5>*in,<0,4.5,-1.5>*in,0.125*in}
		torus{2*in,0.125*in rotate x*-45 scale <0.9,1,0.75> translate <0,1.925>*in}
		// Shoulder
		cylinder{<-4.25,1.925,0>*in,<-1.8,1.925,0>*in,0.125*in}
		cylinder{<1.8,1.925,0>*in,<4.25,1.925,0>*in,0.125*in}
		cylinder{<-5,3.05,1.5>*in,<5,3.05,1.5>*in,0.125*in}
		cylinder{<-3,0.8,-1.5>*in,<3,0.8,-1.5>*in,0.125*in}
		cylinder{<-5.5,0.8,2>*in,<5.5,0.8,2>*in,0.125*in}
		//
		cylinder{<-4.25,1.925,0>*in,<-3,0.8,-1.5>*in,0.125*in}
		cylinder{<-5,3.05,1.5>*in,<-4.25,1.925,0>*in,0.125*in}
		cylinder{<-5.5,0,2>*in,<-5,3.05,1.5>*in,0.125*in}
		cylinder{<-3,0.8,-1.5>*in,<-5.5,0.8,2>*in,0.125*in}
		cylinder{<4.25,1.925,0>*in,<3,0.8,-1.5>*in,0.125*in}
		cylinder{<5,3.05,1.5>*in,<4.25,1.925,0>*in,0.125*in}
		cylinder{<5.5,0.8,2>*in,<5,3.05,1.5>*in,0.125*in}
		cylinder{<3,0.8,-1.5>*in,<5.5,0.8,2>*in,0.125*in}
		rotate prtn translate plocn
		texture{Sculpt1}
	}
#end
*/

/*
	Unfinished, aka still badly messed-up.
*/
#macro TestHead(plocn,prtn,psize,prtns,pclths,prhead,prtorso,prhips)
	#local Waist=<0,0,0>;
	union{
		// Guides <3,4.5,3.5> inches  %ages are doubled because of the halving of ranges.
		#local XX=3;#local YY=4.5;#local ZZ=3.5;// inches, but it says that later.
		#local JawMatrix=IdentityMatrix
		MatrixTranslate(JawMatrix,<0,YY*5/9,-ZZ*0.1>)
		MatrixXRotate(JawMatrix,x*prhead)
		MatrixTranslate(JawMatrix,<0,-YY*5/9,ZZ*0.1>)
		// MatrixUse(JawMatrix)
		union{
			/*
			cylinder{<-2.9,0,0>*in,<2.9,0,0>*in,0.25*in}
			torus{0.9375*in,0.0625*in scale <XX,2,3.125> translate <0,0,-0.375>*in}//XZ
			cylinder{<0,-4.4,0>*in,<0,4.4,0>*in,0.25*in}
			difference{
				torus{0.9375*in,0.0625*in scale <XX,2,YY> rotate x*90}//XY
				box{<-ZZ-0.1,-YY-0.1,-0.5>*in,<ZZ+0.1,-2.5,0.5>*in}
			}
			cylinder{<0,0,-3.4>*in,<0,0,3.4>*in,0.25*in}
			difference{
				torus{0.9375*in,0.0625*in scale <YY,2,ZZ> rotate z*90}//+YZ
				box{<-0.5,-YY-0.1,-ZZ-0.1>*in,<0.5,0,ZZ+0.1>*in}
				box{<-0.5,0,ZZ+0.1>*in,<0.5,YY+0.1,0>*in}
			}
			difference{
				torus{0.9375*in,0.0625*in scale <ZZ,2,ZZ> rotate z*90 translate <0,1,0>*in}//YZ
				box{<-0.5,-2.6,-ZZ-0.1>*in,<0.5,YY+0.1,0>*in}
			}
			sphere{<0,0,0>,0.5*in scale 2*<XX,YY,ZZ>*in}
			*/
			// Mouth:
			// 1 centred 20% up from chin, span to 1/3 across eyes
			/*
			cylinder{<-1.25,-2.575,-2.5>*in,<1.25,-2.575,-2.5>*in,0.125*in texture{pigment{White}}}
			cylinder{<-1.25,-2.575,-2.5>*in,<-1.25,-2.575,-ZZ*0.2>*in,0.125*in texture{pigment{White}}}
			cylinder{<1.25,-2.575,-2.5>*in,<1.25,-2.575,-ZZ*0.2>*in,0.125*in texture{pigment{White}}}
			*/
			//
			//cylinder{<-1.25,-2.325,-2.5>*in,<1.25,-2.325,-2.5>*in,0.125*in }//texture{GreenPt}}
			//cylinder{<-1.25,-2.325,-2.5>*in,<-1.25,-2.325,-0.55>*in,0.125*in }//texture{BluePt}}
			//cylinder{<1.25,-2.325,-2.5>*in,<1.25,-2.325,-0.55>*in,0.125*in }//texture{BrownPt}}
			//cylinder{<-1.25,-1.5,-2.5>*in,<0,-1.35,-2.5>*in,0.125*in}
			//cylinder{<0,-1.35,-2.5>*in,<1.25,-1.5,-2.5>*in,0.125*in}
			//cylinder{<-1.25,-1.5,-2.5>*in,<0,-1.65,-2.5>*in,0.125*in}
			//cylinder{<0,-1.65,-2.5>*in,<1.25,-1.5,-2.5>*in,0.125*in}
			/*
			// Eyebrows:
			// 1 60% up
			cylinder{<-XX*0.25,YY*0.11,-ZZ>*in,<-XX*0.35,YY*0.15,-ZZ>*in,0.125*in texture{HHair}}
			cylinder{<-XX*0.35,YY*0.15,-ZZ>*in,<-XX*0.60,YY*0.20,-ZZ>*in,0.125*in texture{HHair}}
			cylinder{<-XX*0.60,YY*0.20,-ZZ>*in,<-XX*0.75,YY*0.11,-ZZ>*in,0.125*in texture{HHair}}
			cylinder{<XX*0.25,YY*0.11,-ZZ>*in,<XX*0.35,YY*0.15,-ZZ>*in,0.125*in texture{HHair}}
			cylinder{<XX*0.35,YY*0.15,-ZZ>*in,<XX*0.60,YY*0.20,-ZZ>*in,0.125*in texture{HHair}}
			cylinder{<XX*0.60,YY*0.20,-ZZ>*in,<XX*0.75,YY*0.11,-ZZ>*in,0.125*in texture{HHair}}
			*/
			/*
			// Hairline:
			// 1 80% up
			cylinder{<-XX*7/12,YY*0.5,-ZZ*0.6>*in,<-XX/3,YY*0.5,-ZZ*0.9>*in,0.125*in texture{HHair}}
			cylinder{<-XX/3,YY*0.5,-ZZ*0.9>*in,<XX/3,YY*0.5,-ZZ*0.9>*in,0.125*in texture{HHair}}
			cylinder{<XX/3,YY*0.5,-ZZ*0.9>*in,<XX*7/12,YY*0.5,-ZZ*0.6>*in,0.125*in texture{HHair}}
			*/
			// Ears:
			// 1 top at eyeline, lobe about mouthline; 60-80% back.
			// 2 top at 60%? lobe about 25-30%, 5% wide
			cylinder{<-XX*1.1,YY*0.1,ZZ*0.3>*in,<-XX,0,ZZ*0.1>*in,0.25*in}
			cylinder{<-XX*1.1,YY*0.1,ZZ*0.3>*in,<-XX,-YY*0.2,ZZ*0.27>*in,0.25*in}
			cylinder{<-XX,-YY*0.2,ZZ*0.27>*in,<-XX,-YY*0.3,ZZ*0.1>*in,0.25*in}
			cylinder{<XX*1.1,YY*0.1,ZZ*0.3>*in,<XX,0,ZZ*0.1>*in,0.25*in}
			cylinder{<XX*1.1,YY*0.1,ZZ*0.3>*in,<XX,-YY*0.2,ZZ*0.27>*in,0.25*in}
			cylinder{<XX,-YY*0.2,ZZ*0.27>*in,<XX,-YY*0.3,ZZ*0.1>*in,0.25*in}
			/*
			// Nose:
			// 1 30-50% up, nostrils are 0.8*space between eyes
			cylinder{<0,-YY*0.2,-ZZ*6/7>*in,<0,0,-ZZ*5/7>*in,0.125*in}
			cylinder{<0,-YY*0.2,-ZZ*6/7>*in,<-XX*0.2,-YY*0.2+0.3,-ZZ*5/7>*in,0.125*in}
			cylinder{<0,-YY*0.2,-ZZ*6/7>*in,<XX*0.2,-YY*0.2+0.3,-ZZ*5/7>*in,0.125*in}
			*/
			// Moustache:
			//cylinder{<-XX/3,-YY/4,-YY*4/7>*in,<0,-YY/4,-ZZ*6/7>*in,0.125*in texture{HHair}}
			//cylinder{<XX/3,-YY/4,-YY*4/7>*in,<0,-YY/4,-ZZ*6/7>*in,0.125*in texture{HHair}}
			// Chin (and front of face):
			//cylinder{<-XX*0.4,-2.575,-ZZ*5/7>*in,<-XX/2,-0.75,-ZZ*0.8>*in,0.125*in}
			//cylinder{<-XX/2,-0.75,-ZZ*0.8>*in,<-XX*5/6,-0.75,-ZZ*5/7>*in,0.125*in}
			//cylinder{<-XX*5/6,-0.75,-ZZ*5/7>*in,<-XX*5/6,0,-ZZ*5/7>*in,0.125*in}
			//cylinder{<XX*0.4,-2.575,-ZZ*5/7>*in,<XX/2,-0.75,-ZZ*0.8>*in,0.125*in}
			//cylinder{<XX/2,-0.75,-ZZ*0.8>*in,<XX*5/6,-0.75,-ZZ*5/7>*in,0.125*in}
			//cylinder{<XX*5/6,-0.75,-ZZ*5/7>*in,<XX*5/6,0,-ZZ*5/7>*in,0.125*in}
			//HumanBrain(<XX,YY,ZZ>,HBrain)
			//HumanSkull(<XX,YY,ZZ>,HBone)
			// flesh
			#local BlobStr=2.5;
			#local LtLwLip=vrotate(<XX*0.45,-YY*0.66,-ZZ*0.45>*in+<0,YY*5/9,-ZZ*0.1>*in,x*prhead)+<0,-YY*5/9,ZZ*0.1>*in;
			#local RtLwLip=vrotate(<-XX*0.45,-YY*0.66,-ZZ*0.45>*in+<0,YY*5/9,-ZZ*0.1>*in,x*prhead)+<0,-YY*5/9,ZZ*0.1>*in;
			#local LtMidLwLip=vrotate(<XX*0.4,-YY*0.66,-ZZ*0.55>*in+<0,YY*5/9,-ZZ*0.1>*in,x*prhead)+<0,-YY*5/9,ZZ*0.1>*in;
			#local RtMidLwLip=vrotate(<-XX*0.4,-YY*0.66,-ZZ*0.55>*in+<0,YY*5/9,-ZZ*0.1>*in,x*prhead)+<0,-YY*5/9,ZZ*0.1>*in;
			#local MidLwLip=vrotate(<0,-YY*0.66,-ZZ*0.65>*in+<0,YY*5/9,-ZZ*0.1>*in,x*prhead)+<0,-YY*5/9,ZZ*0.1>*in;
			#local RtJaw=vrotate(<-XX*0.6,-YY*0.66,-ZZ*0.3>*in+<0,YY*5/9,-ZZ*0.1>*in,x*prhead)+<0,-YY*5/9,ZZ*0.1>*in;
			#local LtJaw=vrotate(<XX*0.6,-YY*0.66,-ZZ*0.3>*in+<0,YY*5/9,-ZZ*0.1>*in,x*prhead)+<0,-YY*5/9,ZZ*0.1>*in;
			#local RtJawBack=vrotate(<-XX*0.65,-YY*0.66,-ZZ*0.1>*in+<0,YY*5/9,-ZZ*0.1>*in,x*prhead)+<0,-YY*5/9,ZZ*0.1>*in;
			#local LtJawBack=vrotate(<XX*0.65,-YY*0.66,-ZZ*0.1>*in+<0,YY*5/9,-ZZ*0.1>*in,x*prhead)+<0,-YY*5/9,ZZ*0.1>*in;
			//*
			blob{
				threshold 0.1
				//main structure
				sphere{0,0.6*in,2.5 scale <XX*1.8,YY*1.2,ZZ*1.75> translate <0,YY*0.29,0>*in}
				sphere{0,0.6*in,BlobStr scale <XX*1.65,YY*0.9,ZZ*1.35> rotate x*-10 translate <0,YY*0.05,ZZ*0.2>*in}
				sphere{0,0.6*in,BlobStr scale <XX*1.8,YY*0.7,ZZ*1.3> translate <0,-YY*0.10,ZZ*0.1>*in}
				//cheeks
				cylinder{<0,0,0>,<0.5,0.5,1.5>*in,0.5*in,BlobStr scale <1.25,1.25,1.75> translate <XX*0.5,-YY*0.3,-ZZ*0.5>*in}
				cylinder{<XX*0.5,0,0>*in,<-XX*0.5,0,0>*in,0.5*in,BlobStr scale <1,4,3> translate <0,-YY*0.3,-ZZ*0.35>*in}
				cylinder{<0,0,0>,<-0.5,0.5,1.5>*in,0.5*in,BlobStr scale <1.25,1.25,1.75> translate <-XX*0.5,-YY*0.3,-ZZ*0.5>*in}
				//orbits
				sphere{<0,0,0>,0.75*in,-BlobStr translate <-1.3,0,-2.5>*in}
				sphere{<0,0,0>,0.75*in,-BlobStr translate <1.3,0,-2.5>*in}
				//septum
				//sphere{<0,0.25,0>*in,0.75*in,-BlobStr scale <0.8,0.5,2> translate <0,-YY*0.25+0.6,-ZZ*6/7>*in}
				//nose
				cylinder{<0,-YY*0.4,-ZZ*6/7>*in,<0,0,-ZZ*(5+prtorso.x)/7>*in,0.5*in,BlobStr scale <0.8,1,1>}
				cylinder{<0,-YY*0.4,-ZZ*6/7>*in,<-XX*0.2,-YY*0.39,-ZZ*5/7>*in,0.25*in,BlobStr}
				cylinder{<0,-YY*0.4,-ZZ*6/7>*in,<XX*0.2,-YY*0.39,-ZZ*5/7>*in,0.25*in,BlobStr}
				//muscles connecting to jaw
				cylinder{LtJawBack,<XX*0.5,-YY*0.3,-ZZ*0.45>*in,0.5*in,BlobStr}
				cylinder{RtJawBack,<-XX*0.5,-YY*0.3,-ZZ*0.45>*in,0.5*in,BlobStr}
				cylinder{LtJaw,<XX*0.5,-YY*0.3,-ZZ*0.3>*in,0.5*in,BlobStr}
				cylinder{RtJaw,<-XX*0.5,-YY*0.3,-ZZ*0.3>*in,0.5*in,BlobStr}
				//chin
				cylinder{<-XX*0.2,-YY*0.66,-ZZ*0.6>*in,<XX*0.2,-YY*0.66,-ZZ*0.6>*in,0.25*in,BlobStr MatrixUse(JawMatrix)}
				cylinder{<-XX*0.2,-YY*0.66,-ZZ*0.6>*in,<0,-YY*0.8,-ZZ*0.65>*in,0.25*in,BlobStr MatrixUse(JawMatrix)}
				cylinder{<XX*0.2,-YY*0.66,-ZZ*0.6>*in,<0,-YY*0.8,-ZZ*0.65>*in,0.25*in,BlobStr MatrixUse(JawMatrix)}
				//jaw left
				cylinder{<XX*0.8,0,ZZ*0.05>*in,<XX*0.75,-YY*0.66,0>*in,0.25*in,BlobStr scale <1,1,3> MatrixUse(JawMatrix)}
				cylinder{<XX*0.75,0,ZZ*0.1>*in,<XX*0.65,-YY*0.66,0>*in,0.5*in,BlobStr scale <1,1,1.5> MatrixUse(JawMatrix)}
				cylinder{<XX*0.75,-YY*0.66,0>*in,<XX*0.7,-YY*0.8,0>*in,0.25*in,BlobStr scale <1,1,3> MatrixUse(JawMatrix)}
				cylinder{<XX*0.7,0,0>*in,<XX*0.5,0,-ZZ*0.5>*in,0.25*in,BlobStr scale <1,2.5,1> rotate z*-20 translate <0,-YY*0.73,0>*in MatrixUse(JawMatrix)}
				//jaw middle/front
				//cylinder{<-XX*0.35,0,-ZZ*0.6>*in,<0,0,-ZZ*0.7>*in,0.33*in,BlobStr scale <1,2,1> translate <0,-YY*0.73,0>*in MatrixUse(JawMatrix)}
				//cylinder{<0,0,-ZZ*0.7>*in,<XX*0.35,0,-ZZ*0.6>*in,0.33*in,BlobStr scale <1,2,1> translate <0,-YY*0.73,0>*in MatrixUse(JawMatrix)}
				cylinder{<XX*0.2,-YY*0.66,-ZZ*0.65>*in,<XX*0.6,-YY*0.66,-ZZ*0.4>*in,0.25*in,BlobStr MatrixUse(JawMatrix)}
				cylinder{<-XX*0.2,-YY*0.66,-ZZ*0.65>*in,<-XX*0.6,-YY*0.66,-ZZ*0.4>*in,0.25*in,BlobStr MatrixUse(JawMatrix)}
				cylinder{<XX*0.5,-YY*0.66,-ZZ*0.4>*in,<XX*0.25,-YY*0.75,-ZZ*0.65>*in,0.33*in,BlobStr MatrixUse(JawMatrix)}
				cylinder{<-XX*0.5,-YY*0.66,-ZZ*0.4>*in,<-XX*0.25,-YY*0.75,-ZZ*0.65>*in,0.33*in,BlobStr MatrixUse(JawMatrix)}
				sphere{<0,0,0>,0.5*in,BlobStr scale <XX*0.8,1.5,1.75> rotate y*-10 translate <XX*0.2,-YY*0.78,-ZZ*0.5>*in MatrixUse(JawMatrix)}
				sphere{<0,0,0>,0.5*in,BlobStr scale <XX*0.4,1.5,1.75> translate <0,-YY*0.78,-ZZ*0.55>*in MatrixUse(JawMatrix)}
				sphere{<0,0,0>,0.5*in,BlobStr scale <XX*0.8,1.5,1.75> rotate y*10 translate <-XX*0.2,-YY*0.78,-ZZ*0.5>*in MatrixUse(JawMatrix)}
				cylinder{<-XX*0.3,0,-ZZ*0.4>*in,<XX*0.3,0,-ZZ*0.4>*in,0.33*in,BlobStr scale <1,0.5,1.5> translate <0,-YY*0.8,0>*in MatrixUse(JawMatrix)}
				//jaw right
				cylinder{<-XX*0.8,0,ZZ*0.05>*in,<-XX*0.75,-YY*0.66,0>*in,0.25*in,BlobStr scale <1,1,3> MatrixUse(JawMatrix)}
				cylinder{<-XX*0.75,0,ZZ*0.1>*in,<-XX*0.65,-YY*0.66,0>*in,0.5*in,BlobStr scale <1,1,1.5> MatrixUse(JawMatrix)}
				cylinder{<-XX*0.75,-YY*0.66,0>*in,<-XX*0.7,-YY*0.8,0>*in,0.25*in,BlobStr scale <1,1,3> MatrixUse(JawMatrix)}
				cylinder{<-XX*0.7,0,0>*in,<-XX*0.5,0,-ZZ*0.5>*in,0.25*in,BlobStr scale <1,2.5,1> rotate z*20 translate <0,-YY*0.73,0>*in MatrixUse(JawMatrix)}
				//upper lip
				cylinder{LtLwLip,<XX*0.4,-YY*0.55,-ZZ*0.6>*in,0.25*in,BlobStr}
				cylinder{<XX*0.4,-YY*0.55,-ZZ*0.6>*in,<0,-YY*0.55,-ZZ*0.75>*in,0.25*in,BlobStr}
				sphere{<0,0,0>*in,0.25*in,BlobStr scale <2,1,1> rotate <0,-5,-7> translate <XX*0.2,-YY*0.525,-ZZ*0.65>*in}
				sphere{<0,0,0>*in,0.25*in,BlobStr scale <2,1,1> rotate <0,5,7> translate <-XX*0.2,-YY*0.525,-ZZ*0.65>*in}
				cylinder{<-XX*0.4,-YY*0.55,-ZZ*0.6>*in,<0,-YY*0.55,-ZZ*0.75>*in,0.25*in,BlobStr}
				cylinder{RtLwLip,<-XX*0.4,-YY*0.55,-ZZ*0.6>*in,0.25*in,BlobStr}
				//lower lip - matrix calculations imbedded in variables where relevant
				cylinder{LtMidLwLip,<XX*0.5,-YY*0.55,-ZZ*0.5>*in,0.25*in,BlobStr}
				cylinder{LtMidLwLip,MidLwLip,0.25*in,BlobStr}
				cylinder{MidLwLip+<-0.5,0,0>*in,MidLwLip+<0.5,0,0>*in,0.25*in,BlobStr}
				//cylinder{MidLwLip+<-0.5,-0.2,0.1>*in,MidLwLip+<0.5,-0.2,0.1>*in,0.25*in,BlobStr}
				cylinder{RtMidLwLip,MidLwLip,0.25*in,BlobStr}
				cylinder{RtMidLwLip,<-XX*0.5,-YY*0.55,-ZZ*0.5>*in,0.25*in,BlobStr}
				//attach to neck - simplified version
				cylinder{<0,-YY*1.2,ZZ*0.2>*in,<0,0,ZZ*0.4>*in,2*in,BlobStr scale <XX*0.3,1,0.75>}
				/*
				cylinder{<-XX*0.6,YY*0.43,0>*in,<-XX*0.33,YY*1.22,ZZ*0.1>*in,0.125*in,BlobStr translate <0,-8,0>*in}
				cylinder{<XX*0.6,YY*0.43,0>*in,<XX*0.33,YY*1.22,ZZ*0.1>*in,0.125*in,BlobStr translate <0,-8,0>*in}
				cylinder{<0,YY*0.67,ZZ*0.4>*in,<0,YY*1.45,ZZ*0.4>*in,0.125*in,BlobStr translate <0,-8,0>*in}
				cylinder{<0,YY*0.17,-ZZ*0.4>*in,<0,YY,-ZZ*0.4>*in,0.125*in,BlobStr translate <0,-8,0>*in}
				*/
				texture{HFlesh}
			}
			//*/
				//cylinder{,,0.25*in,BlobStr MatrixUse(JawMatrix)}
			//
			//sphere{<-XX*0.55,-4,-ZZ*0.5>*in,0.25*in texture{GreenPt} MatrixUse(JawMatrix)}
			//sphere{<XX*0.55,-4,-ZZ*0.5>*in,0.25*in texture{BluePt} MatrixUse(JawMatrix)}
			//sphere{<-XX*0.25,-2.975,-ZZ*0.65>*in,0.25*in texture{GreenPt} MatrixUse(JawMatrix)}
			//sphere{<XX*0.25,-2.975,-ZZ*0.65>*in,0.25*in texture{BluePt} MatrixUse(JawMatrix)}
			//chin
			//sphere{<-XX*0.2,-2.975,-ZZ*0.7>*in,0.25*in texture{CyanPt} MatrixUse(JawMatrix)}
			//sphere{<XX*0.2,-2.975,-ZZ*0.7>*in,0.25*in texture{CyanPt} MatrixUse(JawMatrix)}
			//sphere{<0,-4.1,-ZZ*0.75>*in,0.25*in texture{CyanPt} MatrixUse(JawMatrix)}
			//sphere{<-XX*0.25,-4,-ZZ*0.7>*in,0.25*in texture{CyanPt} MatrixUse(JawMatrix)}
			//sphere{<XX*0.25,-4,-ZZ*0.7>*in,0.25*in texture{CyanPt} MatrixUse(JawMatrix)}
			//sphere{<-XX*0.6,-2.975,-ZZ*0.4>*in,0.25*in texture{MagentaPt} MatrixUse(JawMatrix)}
			//sphere{<XX*0.6,-2.975,-ZZ*0.4>*in,0.25*in texture{MagentaPt} MatrixUse(JawMatrix)}
			//pivot
			//sphere{<-XX*0.8,0,0>*in,0.25*in texture{RedPt} MatrixUse(JawMatrix)}
			//sphere{<-XX*0.8,-2.975,0>*in,0.25*in texture{MagentaPt} MatrixUse(JawMatrix)}
			//sphere{<XX*0.8,0,0>*in,0.25*in texture{RedPt} MatrixUse(JawMatrix)}
			//sphere{<XX*0.8,-2.975,0>*in,0.25*in texture{MagentaPt} MatrixUse(JawMatrix)}
			//sphere{<-XX*0.75,-4,0>*in,0.25*in texture{GreenPt} MatrixUse(JawMatrix)}
			//sphere{<XX*0.75,-4,0>*in,0.25*in texture{BluePt} MatrixUse(JawMatrix)}
			// Fringe:
			//
			// Cheeks:
			//
			// Sideburns:
			//
			// Jaw: from chin to y=10%, z=40% to y=25%,z=60%
			/*
			cylinder{<-2.5,-2.5,0.35>*in,<2.5,-2.5,0.35>*in,0.125*in}
			union{
				cylinder{<-1.25,-2.825,-2.5>*in,<1.25,-2.825,-2.5>*in,0.125*in texture{pigment{White}}}
				cylinder{<-1.25,-2.825,-2.5>*in,<-1.45,-2.825,-1.05>*in,0.125*in texture{pigment{White}}}
				cylinder{<1.25,-2.825,-2.5>*in,<1.45,-2.825,-1.05>*in,0.125*in texture{pigment{White}}}
				//
				cylinder{<-1.25,-3.375,-2.5>*in,<1.25,-3.375,-2.5>*in,0.125*in }//texture{ScarletPt}}
				cylinder{<-1,-3.375,-2.5>*in,<-1.45,-2.975,-0.53>*in,0.125*in }//texture{VioletPt}}
				cylinder{<1,-3.375,-2.5>*in,<1.45,-2.975,-0.53>*in,0.125*in }//texture{TurquoisePt}}
				cylinder{<-1.45,-0.9,-0.53>*in,<-1.45,-2.975,-0.53>*in,0.125*in }//texture{NavyPt}}
				cylinder{<1.45,-0.9,-0.53>*in,<1.45,-2.975,-0.53>*in,0.125*in }//texture{BrownPt}}
				cylinder{<-1,-4.0,-2.5>*in,<-1.5,-3.6,-0.35>*in,0.125*in }//texture{KhakiPt}}
				cylinder{<1,-4.0,-2.5>*in,<1.5,-3.6,-0.35>*in,0.125*in }//texture{MaroonPt}}
				cylinder{<-1.5,-3.6,-0.35>*in,<1.5,-3.6,-0.35>*in,0.125*in }//texture{RedPt}}
				cylinder{<-1,-4.0,-2.5>*in,<1,-4.0,-2.5>*in,0.125*in }//texture{OrangePt}}
				//
				cylinder{<-1,-3.6,-0.35>*in,<-1,-2.5,0.35>*in,0.125*in}
				cylinder{<1,-3.6,-0.35>*in,<1,-2.5,0.35>*in,0.125*in}
				cylinder{<-1,-4.0,-2.5>*in,<-1.25,-2.825,-2.5>*in,0.125*in}
				cylinder{<1,-4.0,-2.5>*in,<1.25,-2.825,-2.5>*in,0.125*in}
				// jawbone
				/*
				union{
					box{<-XX*0.1,3.75,-0.70>*in,<0,0,0>*in rotate z*10 translate <-XX*0.6,-4.0,0.35>*in}
					box{<XX*0.1,3.75,-0.70>*in,<0,0,0>*in rotate z*-10 translate <XX*0.6,-4.0,0.35>*in}
					box{<-XX*0.7,-2.975,-ZZ*0.2>*in,<XX*0.7,-4.0,0.35>*in}
					difference{
						union{
							cylinder{<0,-2.975,0>*in,<0,-4.0,0>*in,0.5*in scale <XX*1.4,1,ZZ*1.1> translate <0,0,-ZZ*0.1>}
							cylinder{<0,0.25,0>*in,<0,0,0>*in,0.5*in scale <XX*1.4,1,ZZ*1.2> rotate x*-20 translate <0,-3.25,-ZZ*0.15>}
						}
						box{<-XX*0.9,-2.8,-ZZ*0.2>*in,<XX*0.9,-4.1,ZZ*0.9>*in}
					}
					texture{HBone}
				}
				*/
				/*
				sphere{<-XX*0.75,-2.975,-ZZ*0.2>*in,0.25*in texture{GreenPt}}
				sphere{<XX*0.75,-2.975,-ZZ*0.2>*in,0.25*in texture{BluePt}}
				sphere{<-XX*0.8,-2.975,0>*in,0.25*in texture{GreenPt}}
				sphere{<XX*0.8,-2.975,0>*in,0.25*in texture{BluePt}}
				sphere{<-XX*0.75,-4,0>*in,0.25*in texture{GreenPt}}
				sphere{<XX*0.75,-4,0>*in,0.25*in texture{BluePt}}
				*/
				//sphere{<XX*0.65,-2.975,-ZZ*0.3>*in,0.25*in texture{BluePt}}
				//sphere{<-XX*0.7,-2.975,-ZZ*0.1>*in,0.25*in texture{GreenPt}}
				//sphere{<XX*0.7,-2.975,-ZZ*0.1>*in,0.25*in texture{BluePt}}
				translate <0,YY*5/9,-ZZ*0.1>*in
				rotate x*prhead
				translate <0,-YY*5/9,ZZ*0.1>*in
				//texture{pigment{Blue}}
			}
			*/
			translate <0,8,0>*in
		}
		// Eyes
		// right
		sphere{//eyeball
			<0,0,0>,.5*in scale <1.5,1,1> translate <-1.5*in,8*in,-2.5*in>
			texture{HEyes}
		}
		sphere{//iris
			<0,0,0>,.5*in scale <0.4,0.4,0.1> translate <-1.5*in,8*in,-3.0*in>
			texture{HIris}
		}
		difference{//upper eyelid
			sphere{
				<0,0,0>,.6*in scale <1.5,1,1>
			}
			box{
				<-1,-0.7,-0.7>*in,<1,0,0.7>*in texture{HHair}
			}
			rotate x*45*(1-prhead.y)
			translate <-1.5*in,8*in,-2.5*in>
		}
		difference{//lower eyelid
			sphere{
				<0,0,0>,.6*in scale <1.5,1,1>
			}
			box{
				<-1,0.7,-0.7>*in,<1,0,0.7>*in texture{HHair}
			}
			rotate x*-45*(1-prhead.y)
			translate <-1.5*in,8*in,-2.5*in>
		}
		// left
		sphere{//eyeball
			<0,0,0>,.5*in scale <1.5,1,1> translate <1.5*in,8*in,-2.5*in>
			texture{HEyes}
		}
		sphere{//iris
			<0,0,0>,.5*in scale <0.4,0.4,0.1> translate <1.5*in,8*in,-3.0*in>
			texture{HIris}
		}
		difference{//upper eyelid
			sphere{
				<0,0,0>,.6*in scale <1.5,1,1>
			}
			box{
				<-1,-0.7,-0.7>*in,<1,0,0.7>*in texture{HHair}
			}
			rotate x*45*(1-prhead.z)
			translate <1.5*in,8*in,-2.5*in>
		}
		difference{//lower eyelid
			sphere{
				<0,0,0>,.6*in scale <1.5,1,1>
			}
			box{
				<-1,0.7,-0.7>*in,<1,0,0.7>*in texture{HHair}
			}
			rotate x*-45*(1-prhead.z)
			translate <1.5*in,8*in,-2.5*in>
		}
		/*
		// Neck: front -30%; back -5%; (mid -17.5%) 3/4.5/3.5
		cylinder{<-XX*0.6,YY*0.43,0>*in,<-XX*0.33,YY*1.22,0.35>*in,0.125*in}
		cylinder{<XX*0.6,YY*0.43,0>*in,<XX*0.33,YY*1.22,0.35>*in,0.125*in}
		cylinder{<0,YY*0.67,1.5>*in,<0,YY*1.45,1.5>*in,0.125*in}
		cylinder{<0,YY*0.17,-1.5>*in,<0,YY,-1.5>*in,0.125*in}
		torus{2*in,0.125*in rotate x*-40 scale <XX*0.3,1,0.75> translate <0,YY*0.43,0>*in}
		*/
		/*
		// Shoulder
		cylinder{<-4.25,1.925,0>*in,<-1.8,1.925,0>*in,0.125*in}
		cylinder{<1.8,1.925,0>*in,<4.25,1.925,0>*in,0.125*in}
		cylinder{<-5,3.05,1.5>*in,<5,3.05,1.5>*in,0.125*in}
		cylinder{<-3,0.8,-1.5>*in,<3,0.8,-1.5>*in,0.125*in}
		cylinder{<-5.5,0.8,2>*in,<5.5,0.8,2>*in,0.125*in}
		//
		cylinder{<-4.25,1.925,0>*in,<-3,0.8,-1.5>*in,0.125*in}
		cylinder{<-5,3.05,1.5>*in,<-4.25,1.925,0>*in,0.125*in}
		cylinder{<-5.5,0,2>*in,<-5,3.05,1.5>*in,0.125*in}
		cylinder{<-3,0.8,-1.5>*in,<-5.5,0.8,2>*in,0.125*in}
		cylinder{<4.25,1.925,0>*in,<3,0.8,-1.5>*in,0.125*in}
		cylinder{<5,3.05,1.5>*in,<4.25,1.925,0>*in,0.125*in}
		cylinder{<5.5,0.8,2>*in,<5,3.05,1.5>*in,0.125*in}
		cylinder{<3,0.8,-1.5>*in,<5.5,0.8,2>*in,0.125*in}
		*/
		/*
		#ifdef (HeadClothing)
			object{HeadClothing}
		#end
		*/
		//scale psize[0]
		//rotate prtns[0]
		//rotate prhead+prtorso
		//translate Waist+(vrotate(<0,1*ft+2*in,0>*psize[1],prtorso))
		//
		//rotate prtn translate plocn
		translate <0,-2,0>*in
		texture{HFlesh}
	}
#end


/*
	Parameters for all macros:
		plocn:	Origin of dummy in scene (groundlevel, between feet)
		prtn:	 	Rotation of whole figure
		psize:	Array[7] of size data
						0 Head, 1 Torso, 2 RArm, 3 LArm, 4 Hips, 5 RLeg, 6 LLeg
		prtns:	Array[9] or [11] or [13] of rotation data
						0 Head 1 right u arm 2 right l arm 3 left u arm 4 left l arm
						5 right u leg 6 right l leg 7 left u leg 8 left l leg
						9 right hand 10 left hand 11 right foot 12 left foot
		pclths: placeholder variable
		prhead: Rotation of head relative to torso
		prtorso:Rotation of torso about waist
		prhips: Rotation of hips about waist
*/

#macro RTDH3 (plocn,prtn,psize,prtns,pclths,prhead,prtorso,prhips,head1par,head2par)
object{
	#if (dimension_size(psize,1)<7)
		#debug "\nError in RTDH3; sizes must be array[7].\n"
	#end
	#local Waist=<0,2*ft+9*in,0>*(psize[5]+psize[6])/2+<0,8*in,0>*psize[4];
	#local DraperyPoints=array[64]
	union{
		// old code still in backup copy, if I need it
		// Head
		union{
			TestHead(plocn,prtn,psize,prtns,pclths,head1par,head2par,0)
			#ifdef (HeadClothing)
				object{HeadClothing}
			#end
			scale psize[0]
			rotate prtns[0]
			//rotate prtorso
			translate Waist+(vrotate(<0,1*ft+2*in,0>*psize[1],prtorso))
		}
		// Torso
		union{
			cone{
				<0,11*in,0>,5*in,<0,14*in,0>,2*in
			}
			cone{
				<0,7*in,0>,5.5*in,<0,11*in,0>,5*in
			}
			cone{
				<0,0,0>,5*in,<0,7*in,0>,5.5*in
			}
			#ifdef (TorsoClothing)
				object{TorsoClothing}
			#end
			// Upper shoulders
			/*
			cone{
				<0,10*in,0>,8*in,<0,11*in,0>,5*in
				scale <1,1,.5>
			}
			*/
			#local Rshld=vrotate(<-6*in,10*in,0>*psize[1],prtorso);
			#local Lshld=vrotate(<6*in,10*in,0>*psize[1],prtorso);
			#ifdef (ShoulderClothing)
				object{ShoulderClothing}
			#end
			scale <1,1,.5>*psize[1]
			rotate prtorso
			translate Waist
		}
		#local RInt=radians(22.5);
		// Store drapery values for top,shoulder: 0-7
		#local DraperyPoints[ 3]=<2.1,14,-2.2>*<sin(3*RInt),1,cos(3*RInt)>*<1,1,.5>*psize[1];
		#local DraperyPoints[ 2]=<2.1,14,-2.2>*<sin(RInt),1,cos(RInt)>*<1,1,.5>*psize[1];
		#local DraperyPoints[ 1]=DraperyPoints[ 2]*<-1,1,1>;
		#local DraperyPoints[ 0]=DraperyPoints[ 3]*<-1,1,1>;
		#local DraperyPoints[ 4]=DraperyPoints[ 0]*<1,1,-1>;
		#local DraperyPoints[ 5]=DraperyPoints[ 1]*<1,1,-1>;
		#local DraperyPoints[ 6]=DraperyPoints[ 2]*<1,1,-1>;
		#local DraperyPoints[ 7]=DraperyPoints[ 3]*<1,1,-1>;
		//adjust drapery
		#local DraperyPoints[ 0]=Waist+vrotate(DraperyPoints[ 0],prtorso);
		#local DraperyPoints[ 1]=Waist+vrotate(DraperyPoints[ 1],prtorso);
		#local DraperyPoints[ 2]=Waist+vrotate(DraperyPoints[ 2],prtorso);
		#local DraperyPoints[ 3]=Waist+vrotate(DraperyPoints[ 3],prtorso);
		#local DraperyPoints[ 4]=Waist+vrotate(DraperyPoints[ 4],prtorso);
		#local DraperyPoints[ 5]=Waist+vrotate(DraperyPoints[ 5],prtorso);
		#local DraperyPoints[ 6]=Waist+vrotate(DraperyPoints[ 6],prtorso);
		#local DraperyPoints[ 7]=Waist+vrotate(DraperyPoints[ 7],prtorso);
		// Store drapery values for top,collar: 0-7
		#local DraperyPoints[11]=<8.1,11,-6.1>*<sin(3*RInt),1,cos(3*RInt)>*<1,1,.5>*psize[1];
		#local DraperyPoints[10]=<8.1,11,-6.1>*<sin(RInt),1,cos(RInt)>*<1,1,.5>*psize[1];
		#local DraperyPoints[ 9]=DraperyPoints[10]*<-1,1,1>;
		#local DraperyPoints[ 8]=DraperyPoints[11]*<-1,1,1>;
		#local DraperyPoints[12]=DraperyPoints[ 8]*<1,1,-1>;
		#local DraperyPoints[13]=DraperyPoints[ 9]*<1,1,-1>;
		#local DraperyPoints[14]=DraperyPoints[10]*<1,1,-1>;
		#local DraperyPoints[15]=DraperyPoints[11]*<1,1,-1>;
		//adjust drapery
		#local DraperyPoints[ 8]=Waist+vrotate(DraperyPoints[ 8],prtorso);
		#local DraperyPoints[ 9]=Waist+vrotate(DraperyPoints[ 9],prtorso);
		#local DraperyPoints[10]=Waist+vrotate(DraperyPoints[10],prtorso);
		#local DraperyPoints[11]=Waist+vrotate(DraperyPoints[11],prtorso);
		#local DraperyPoints[12]=Waist+vrotate(DraperyPoints[12],prtorso);
		#local DraperyPoints[13]=Waist+vrotate(DraperyPoints[13],prtorso);
		#local DraperyPoints[14]=Waist+vrotate(DraperyPoints[14],prtorso);
		#local DraperyPoints[15]=Waist+vrotate(DraperyPoints[15],prtorso);
		// Right arm
		union{
			/*
			sphere{
				<0,0,0>,1*in scale <3,1.5,1.5>*psize[2] translate <3.5,0,0>*in
				rotate prtorso
				translate Rshld+Waist
			}
			*/
			sphere{
				<0,0,0>,1*in scale psize[2]
				rotate prtns[1]+prtorso
				translate Rshld+Waist
			}
			cone{
				<0,0,0>,1*in,<0,-9.5*in,0>,1*in
				scale psize[2]
				rotate prtns[1]+prtorso
				translate Rshld+Waist
				#local Relbw=Rshld+vrotate(<0,-9.5*in,0>*psize[2],prtns[1]+prtorso);
			}
			#ifdef (RuSleeveClothing)
				object{
					RuSleeveClothing
					scale psize[2]
					rotate prtns[1]+prtorso
					translate Rshld+Waist
				}
			#end
			sphere{
				<0,0,0>,1*in scale psize[2]
				rotate prtns[2]+prtorso
				translate Relbw+Waist
			}
			cone{
				<0,0,0>,1*in,<0,-9.5*in,0>,1.25*in
				scale psize[2]
				rotate prtns[2]+prtorso
				translate Relbw+Waist
				#local Rwrst=Relbw+vrotate(<0,-9.5*in,0>*psize[2],prtns[2]+prtorso);
			}
			sphere{
				<0,-9.5*in,0>,1.25*in
				scale psize[2]
				rotate prtns[2]+prtorso
				translate Relbw+Waist
			}
			#ifdef (RlSleeveClothing)
				object{
					RlSleeveClothing
					scale psize[2]
					rotate prtns[2]+prtorso
					translate Relbw+Waist
				}
			#end
			object{
				RHand
				scale psize[2]
				rotate prtns[2]
				#if (dimension_size(prtns,1)>9) rotate prtns[9] #end
				translate Rwrst+Waist
			}
			#ifdef (RHandClothing)
				object{
					RHandClothing
					scale psize[2]
					rotate prtns[2]
					#if (dimension_size(prtns,1)>9) rotate prtns[9] #end
					translate Rwrst+Waist
				}
			#end
		}
		// Left arm
		union{
			/*
			sphere{
				<0,0,0>,1*in scale <3,1.5,1.5>*psize[3] translate <-3.5,0,0>*in
				rotate prtorso
				translate Lshld+Waist
			}
			*/
			sphere{
				<0,0,0>,1*in scale psize[3]
				rotate prtns[3]+prtorso
				translate Lshld+Waist
			}
			cone{
				<0,0,0>,1*in,<0,-9.5*in,0>,1*in
				scale psize[3]
				rotate prtns[3]+prtorso
				translate Lshld+Waist
				#local Lelbw=Lshld+vrotate(<0,-9.5*in,0>*psize[3],prtns[3]+prtorso);
			}
			#ifdef (LuSleeveClothing)
				object{
					LuSleeveClothing
					scale psize[3]
					rotate prtns[3]+prtorso
					translate Lshld+Waist
				}
			#end
			sphere{
				<0,0,0>,1*in scale psize[3]
				rotate prtns[4]+prtorso
				translate Lelbw+Waist
			}
			cone{
				<0,0,0>,1*in,<0,-9.5*in,0>,1.25*in
				scale psize[3]
				rotate prtns[4]+prtorso
				translate Lelbw+Waist
				#local Lwrst=Lelbw+vrotate(<0,-9.5*in,0>*psize[3],prtns[4]+prtorso);
			}
			sphere{
				<0,-9.5*in,0>,1.25*in
				scale psize[3]
				rotate prtns[4]+prtorso
				translate Lelbw+Waist
			}
			#ifdef (LlSleeveClothing)
				object{
					LlSleeveClothing
					scale psize[3]
					rotate prtns[4]+prtorso
					translate Lelbw+Waist
				}
			#end
			object{
				LHand
				scale psize[3]
				rotate prtns[4]
				#if (dimension_size(prtns,1)>10) rotate prtns[10] #end
				translate Lwrst+Waist
			}
			#ifdef (LHandClothing)
				object{
					LHandClothing
					scale psize[3]
					rotate prtns[4]
					#if (dimension_size(prtns,1)>10) rotate prtns[10] #end
					translate Lwrst+Waist
				}
			#end
		}
		// Hips
		union{
			sphere{
				<0,0,0>,5*in
				scale <1,1,.5>*psize[4]
				translate Waist
				// Store drapery values for skirt,waist: 32-39
				#local DraperyPoints[35]=<5.1,0,-5.1>*<sin(3*RInt),1,cos(3*RInt)>*<1,1,.5>*psize[4];
				#local DraperyPoints[34]=<5.1,0,-5.1>*<sin(RInt),1,cos(RInt)>*<1,1,.5>*psize[4];
				#local DraperyPoints[33]=DraperyPoints[34]*<-1,1,1>;
				#local DraperyPoints[32]=DraperyPoints[35]*<-1,1,1>;
				#local DraperyPoints[36]=DraperyPoints[32]*<1,1,-1>;
				#local DraperyPoints[37]=DraperyPoints[33]*<1,1,-1>;
				#local DraperyPoints[38]=DraperyPoints[34]*<1,1,-1>;
				#local DraperyPoints[39]=DraperyPoints[35]*<1,1,-1>;
				//adjust drapery
				#local DraperyPoints[32]=Waist+vrotate(DraperyPoints[32],prhips);
				#local DraperyPoints[33]=Waist+vrotate(DraperyPoints[33],prhips);
				#local DraperyPoints[34]=Waist+vrotate(DraperyPoints[34],prhips);
				#local DraperyPoints[35]=Waist+vrotate(DraperyPoints[35],prhips);
				#local DraperyPoints[36]=Waist+vrotate(DraperyPoints[36],prhips);
				#local DraperyPoints[37]=Waist+vrotate(DraperyPoints[37],prhips);
				#local DraperyPoints[38]=Waist+vrotate(DraperyPoints[38],prhips);
				#local DraperyPoints[39]=Waist+vrotate(DraperyPoints[39],prhips);
			}
			cone{
				<0,0,0>,5*in,<0,-8*in,-3>,1*in
				//<0,0,0>,5*in,<0,-8*in,0>,6*in
				scale <1,1,.5>*psize[4]
				rotate prhips
				translate Waist
				#local Rhip=vrotate(<-3*in,-8*in,0>*psize[4],prhips);
				#local Lhip=vrotate(<3*in,-8*in,0>*psize[4],prhips);
			}
			#ifdef (HipsClothing)
				object{
					HipsClothing
					scale psize[4]
					rotate prhips
					translate Waist
				}
			#end
		}
		// Right leg
		union{
			sphere{
				<0.3,1.6,0.35>*in,3.2*in
				scale <1,1,1>*psize[5]
				translate Rhip+Waist
			}
			#ifdef (RHipsClothing)
				object{
					RHipsClothing
					scale psize[5]
					translate Rhip+Waist
				}
			#end
			cone{
				<0,0,0>,3*in,<0,8*in,0>,2*in
				scale psize[5]
				rotate prhips
				translate Rhip+Waist
			}
			cone{
				<0,0,0>,3*in,<0,-14*in,0>,1.5*in
				scale psize[5]
				rotate prtns[5]
				translate Rhip+Waist
				#local Rknee=Rhip+vrotate(<0,-14*in,0>*psize[5],prtns[5]);
				#local RkneeD=Rhip+vrotate(<0,-14*in,0>*psize[5],
					<min(0.5*prtns[5].x,prtns[5].x),prtns[5].y,min(0,0.5*prtns[5].z)>);
			}
			// Store drapery values for skirt,thigh: 40-41,44-45
			#local DraperyPoints[40]=<-2.6,-14,-2.6>*<sin(2*RInt),1/3,cos(2*RInt)>*psize[5];
			#local DraperyPoints[41]=<2.6,-14,-2.6>*<sin(RInt),1/3,cos(RInt)>*psize[5];
			#local DraperyPoints[44]=DraperyPoints[40]*<1,1,-1>;
			#local DraperyPoints[45]=DraperyPoints[41]*<1,1,-1>;
			//adjust drapery
			#local DraperyPoints[40]=Rhip+Waist+vrotate(DraperyPoints[40],
				<max(0,prtns[5].x),prtns[5].y,min(0,prtns[5].z)>);
			#local DraperyPoints[41]=Rhip+Waist+vrotate(DraperyPoints[41],
				<max(0.5*prtns[5].x,prtns[5].x),prtns[5].y,min(0,0.5*prtns[5].z)>);
			#local DraperyPoints[44]=Rhip+Waist+vrotate(DraperyPoints[44],
				<min(0,prtns[5].x),prtns[5].y,min(0,prtns[5].z)>);
			#local DraperyPoints[45]=Rhip+Waist+vrotate(DraperyPoints[45],
				<min(0.5*prtns[5].x,prtns[5].x),prtns[5].y,min(0,0.5*prtns[5].z)>);
			#ifdef (RThighClothing)
				object{
					RThighClothing
					scale psize[5]
					rotate prtns[5]
					translate Rhip+Waist
				}
			#end
			sphere{
				<0,0,0>,1.5*in
				scale psize[5]
				translate Rknee+Waist
			}
			cone{
				<0,0,0>,1.5*in,<0,-16*in,0>,1.5*in
				scale psize[5]
				rotate prtns[6]
				translate Rknee+Waist
				#local Rankl=Rknee+vrotate(<0,-16*in,0>*psize[5],prtns[6]);
			}
			// Store drapery values for skirt,knee: 48-49,52-53
			#local DraperyPoints[48]=<-2.6,-14,-2.6>*<sin(2*RInt),1,cos(2*RInt)>*psize[5];
			#local DraperyPoints[49]=<2.6,-14,-2.6>*<sin(RInt),1,cos(RInt)>*psize[5];
			#local DraperyPoints[52]=DraperyPoints[48]*<1,1,-1>;
			#local DraperyPoints[53]=DraperyPoints[49]*<1,1,-1>;
			//adjust drapery
			#local DraperyPoints[48]=Rhip+Waist+vrotate(DraperyPoints[48],
				<max(0,prtns[5].x),prtns[5].y,min(0,prtns[5].z)>);
			#local DraperyPoints[49]=Rhip+Waist+vrotate(DraperyPoints[49],
				<max(0.5*prtns[5].x,prtns[5].x),prtns[5].y,min(0,0.5*prtns[5].z)>);
			#local DraperyPoints[52]=Rhip+Waist+vrotate(DraperyPoints[52],
				<min(0,prtns[5].x),prtns[5].y,min(0,prtns[5].z)>);
			#local DraperyPoints[53]=Rhip+Waist+vrotate(DraperyPoints[53],
				<min(0.5*prtns[5].x,prtns[5].x),prtns[5].y,min(0,0.5*prtns[5].z)>);
			#ifdef (RCalfClothing)
				object{
					RCalfClothing
					scale psize[5]
					rotate prtns[6]
					translate Rknee+Waist
				}
			#end
			union{
				cylinder{
				<0,0,0>*in,<0,-3,0>*in,1*in
				scale <1.5,1,0.75>
			}
			intersection{
				box{
					<-2,0,0>*in,<2,-3,-6.1>*in
				}
				union{
					sphere{
						<0,0,0>*in,1*in scale <2,2.5,6> translate <0,-3,0>*in
					}
					cylinder{
						<1.25,-2.5,-4>*in,<1.25,-2.5,-6>*in,0.5*in
					}
				}
			}
			scale psize[5]
			#if (dimension_size(prtns,1)>11) rotate prtns[11] #end
			translate Rankl+Waist
		}
		// Store drapery values for skirt,ankle: 56-57,60-61
		#local DraperyPoints[56]=<-2.6,-16,-2.6>*<sin(2*RInt),1,cos(2*RInt)>*psize[5];
		#local DraperyPoints[57]=<2.6,-16,-2.6>*<sin(RInt),1,cos(RInt)>*psize[5];
		#local DraperyPoints[60]=DraperyPoints[56]*<1,1,-1>;
		#local DraperyPoints[61]=DraperyPoints[57]*<1,1,-1>;
		//adjust drapery
		#local DraperyPoints[56]=<min(Rknee.x,RkneeD.x),Rknee.y,max(Rknee.z,RkneeD.z)>+Waist+vrotate(DraperyPoints[56],
			<max(0,prtns[6].x),prtns[6].y,min(0,prtns[6].z)>);
		#local DraperyPoints[57]=<RkneeD.x,Rknee.y,max(Rknee.z,RkneeD.z)>+Waist+vrotate(DraperyPoints[57],
			<max(0.5*prtns[6].x,prtns[6].x),prtns[6].y,min(0,0.5*prtns[6].z)>);
		#local DraperyPoints[60]=<min(Rknee.x,RkneeD.x),Rknee.y,min(Rknee.z,RkneeD.z)>+Waist+vrotate(DraperyPoints[60],
			<min(0,prtns[6].x),prtns[6].y,min(0,prtns[6].z)>);
		#local DraperyPoints[61]=<RkneeD.x,Rknee.y,min(Rknee.z,RkneeD.z)>+Waist+vrotate(DraperyPoints[61],
			<min(0.5*prtns[6].x,prtns[6].x),prtns[6].y,min(0,0.5*prtns[6].z)>);
		#ifdef (RFootClothing)
			object{
				RFootClothing
				scale psize[5]
				#if (dimension_size(prtns,1)>11) rotate prtns[11] #end
				translate Rankl+Waist
			}
		#end
		}
		// Left leg
		union{
			sphere{
				<-0.3,1.6,0.35>*in,3.2*in
				scale <1,1,1>*psize[6]
				translate Lhip+Waist
			}
			#ifdef (LHipsClothing)
				object{
					LHipsClothing
					scale psize[6]
					translate Lhip+Waist
				}
			#end
			cone{
				<0,0,0>,3*in,<0,8*in,0>,2*in
				scale psize[6]
				rotate prhips
				translate Lhip+Waist
			}
			cone{
				<0,0,0>,3*in,<0,-14*in,0>,1.5*in
				scale psize[6]
				rotate prtns[7]
				translate Lhip+Waist
				#local Lknee=Lhip+vrotate(<0,-14*in,0>*psize[6],prtns[7]);
				#local LkneeD=Lhip+vrotate(<0,-14*in,0>*psize[6],
					<max(0.5*prtns[7].x,prtns[7].x),prtns[7].y,max(0,0.5*prtns[7].z)>);
			}
			// Store drapery values for skirt,thigh: 42-43,46-47
			#local DraperyPoints[42]=<-2.6,-14,-2.6>*<sin(RInt),1/3,cos(RInt)>*psize[6];
			#local DraperyPoints[43]=<2.6,-14,-2.6>*<sin(2*RInt),1/3,cos(2*RInt)>*psize[6];
			#local DraperyPoints[46]=DraperyPoints[42]*<1,1,-1>;
			#local DraperyPoints[47]=DraperyPoints[43]*<1,1,-1>;
			//adjust drapery
			#local DraperyPoints[42]=Lhip+Waist+vrotate(DraperyPoints[42],
				<max(0.5*prtns[7].x,prtns[7].x),prtns[7].y,max(0,0.5*prtns[7].z)>);
			#local DraperyPoints[43]=Lhip+Waist+vrotate(DraperyPoints[43],
				<max(0,prtns[7].x),prtns[7].y,max(0,prtns[7].z)>);
			#local DraperyPoints[46]=Lhip+Waist+vrotate(DraperyPoints[46],
				<min(0.5*prtns[7].x,prtns[7].x),prtns[7].y,max(0,0.5*prtns[7].z)>);
			#local DraperyPoints[47]=Lhip+Waist+vrotate(DraperyPoints[47],
				<min(0,prtns[7].x),prtns[7].y,max(0,prtns[7].z)>);
			#ifdef (LThighClothing)
				object{
					LThighClothing
					scale psize[6]
					rotate prtns[7]
					translate Lhip+Waist
				}
			#end
			sphere{
				<0,0,0>,1.5*in
				scale psize[6]
				translate Lknee+Waist
			}
			cone{
				<0,0,0>,1.5*in,<0,-16*in,0>,1.5*in
				scale psize[6]
				rotate prtns[8]
				translate Lknee+Waist
				#local Lankl=Lknee+vrotate(<0,-16*in,0>*psize[6],prtns[8]);
			}
			// Store drapery values for skirt,knee: 50-51,54-55
			#local DraperyPoints[50]=<-2.6,-14,-2.6>*<sin(RInt),1,cos(RInt)>*psize[6];
			#local DraperyPoints[51]=<2.6,-14,-2.6>*<sin(2*RInt),1,cos(2*RInt)>*psize[6];
			#local DraperyPoints[54]=DraperyPoints[50]*<1,1,-1>;
			#local DraperyPoints[55]=DraperyPoints[51]*<1,1,-1>;
			//adjust drapery
			#local DraperyPoints[50]=Lhip+Waist+vrotate(DraperyPoints[50],
				<max(0.5*prtns[7].x,prtns[7].x),prtns[7].y,max(0,0.5*prtns[7].z)>);
			#local DraperyPoints[51]=Lhip+Waist+vrotate(DraperyPoints[51],
				<max(0,prtns[7].x),prtns[7].y,max(0,prtns[7].z)>);
			#local DraperyPoints[54]=Lhip+Waist+vrotate(DraperyPoints[54],
				<min(0.5*prtns[7].x,prtns[7].x),prtns[7].y,max(0,0.5*prtns[7].z)>);
			#local DraperyPoints[55]=Lhip+Waist+vrotate(DraperyPoints[55],
				<min(0,prtns[7].x),prtns[7].y,max(0,prtns[7].z)>);
			#ifdef (LCalfClothing)
				object{
					LCalfClothing
					scale psize[6]
					rotate prtns[8]
					translate Lknee+Waist
				}
			#end
			union{
				cylinder{
					<0,0,0>*in,<0,-3,0>*in,1*in
					scale <1.5,1,0.75>
				}
				intersection{
					box{
						<-2,0,0>*in,<2,-3,-6.1>*in
					}
					union{
						sphere{
							<0,0,0>*in,1*in scale <2,2.5,6> translate <0,-3,0>*in
						}
						cylinder{
							<-1.25,-2.5,-4>*in,<-1.25,-2.5,-6>*in,0.5*in
						}
					}
				}
				scale psize[6]
				#if (dimension_size(prtns,1)>12) rotate prtns[12] #end
				translate Lankl+Waist
			}
			// Store drapery values for skirt,ankle: 58-59,62-63
			#local DraperyPoints[58]=<-2.6,-16,-2.6>*<sin(RInt),1,cos(RInt)>*psize[6];
			#local DraperyPoints[59]=<2.6,-16,-2.6>*<sin(2*RInt),1,cos(2*RInt)>*psize[6];
			#local DraperyPoints[62]=DraperyPoints[58]*<1,1,-1>;
			#local DraperyPoints[63]=DraperyPoints[59]*<1,1,-1>;
			//adjust drapery
			#local DraperyPoints[58]=<LkneeD.x,Lknee.y,max(Lknee.z,LkneeD.z)>+Waist+vrotate(DraperyPoints[58],
				<max(0.5*prtns[8].x,prtns[8].x),prtns[8].y,max(0,0.5*prtns[8].z)>);
			#local DraperyPoints[59]=<max(Lknee.x,LkneeD.x),Lknee.y,max(Lknee.z,LkneeD.z)>+Waist+vrotate(DraperyPoints[59],
				<max(0,prtns[8].x),prtns[8].y,max(0,prtns[8].z)>);
			#local DraperyPoints[62]=<LkneeD.x,Lknee.y,min(Lknee.z,LkneeD.z)>+Waist+vrotate(DraperyPoints[62],
				<min(0.5*prtns[8].x,prtns[8].x),prtns[8].y,max(0,0.5*prtns[8].z)>);
			#local DraperyPoints[63]=<max(Lknee.x,LkneeD.x),Lknee.y,min(Lknee.z,LkneeD.z)>+Waist+vrotate(DraperyPoints[63],
				<min(0,prtns[8].x),prtns[8].y,max(0,prtns[8].z)>);
			#ifdef (LFootClothing)
				object{
					LFootClothing
					scale psize[6]
					#if (dimension_size(prtns,1)>12) rotate prtns[12] #end
					translate Lankl+Waist
				}
			#end
		}
		#ifdef  (BodycostumeNo) #write(DebugFile,"Body costume undef\n") #end
		#ifndef (BodycostumeNo) #write(DebugFile,"Body costume def\n")   #end
		#ifndef (BodycostumeNo)
			#ifdef (Bodycostume)
				Bodycostume(DraperyPoints)
			#end
		#end
		texture{HFlesh}
	}//-union
	rotate prtn
	translate plocn
}//-object RTDH3
#end

#declare SamplerName=object{
	RTDH3(<0,0,0>,<0,0,0>,
		array[7]{<1,1,1>,<1,1,1>,<1,1,1>,<1,1,1>,
			<1,1,1>,<1,1,1>,<1,1,1>},
		array[9]{<15,5,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>},
		array[1]{0},<0,0,0>,<0,0,0>,<0,0,0>,<-5,0.2,0.4>,<0,0,0>)
}
#declare SamplerBBox=array[2]
	{<-12*in,0,-8*in>,<12*in,5*ft+8*in,8*in>}
	
/*
#declare KoDT_BA=object{
	RTDH3(<0,0,0>,<0,0,0>,
		array[7]{<1.5,1.33,1.5>,<1.07,1.5,1.07>,<2,1,2>,<2,1,2>,
			<1,0.83,1>,<1.33,0.61,1.33>,<1.33,0.61,1.33>},
		array[9]{<10,10,0>,<0,0,-40>,<120,0,0>,<0,0,15>,<0,0,-5>,<5,0,-20>,<-3,0,-18>,<0,0,20>,<-2,0,18>},
		array[1]{0},<0,0,0>,<0,0,0>,<0,0,0>)
	scale 1.2
}
#declare KoDT_Bob=object{
	RTDH3(<0,0,0>,<0,0,0>,
		array[7]{<1.29,1.67,1.29>,<1.1,1.5,1.1>,<2,1.23,2>,<2,1.23,2>,
			<1.1,0.87,1.1>,<1.2,0.6,1.2>,<1.2,0.6,1.2>},
		array[9]{<10,5,0>,<0,0,-70>,<0,0,-120>,<0,0,110>,<0,0,115>,<5,0,-15>,<-3,0,-13>,<0,0,13>,<-2,0,11>},
		array[1]{0},<0,0,0>,<0,0,0>,<0,0,0>)
}
	psize:	Array[7] of size data
					0 Head, 1 Torso, 2 RArm, 3 LArm, 4 Hips, 5 RLeg, 6 LLeg
	prtns:	Array[9] of rotation data
					0 Head 1 right u arm 2 right l arm 3 left u arm 4 left l arm
			5 right u leg 6 right l leg 7 left u leg 8 left l leg
#declare KoDT_Brian=object{
	RTDH3(<0,0,0>,<0,0,0>,
		array[7]{<1,1,1>,<1,1,1>,<1,1,1>,<1,1,1>,
			<1,1,1>,<1,1,1>,<1,1,1>},
		array[9]{<15,5,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>},
		array[1]{0},<0,0,0>,<0,0,0>,<0,0,0>)
}
#declare KoDT_Dave=object{
	RTDH3(<0,0,0>,<0,0,0>,
		array[7]{<1,1,1>,<1,1,1>,<1,1,1>,<1,1,1>,
			<1,1,1>,<1,1,1>,<1,1,1>},
		array[9]{<15,5,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>},
		array[1]{0},<0,0,0>,<0,0,0>,<0,0,0>)
}
#declare KoDT_Johnny=object{
	RTDH3(<0,0,0>,<0,0,0>,
		array[7]{<1,1,1>,<1,1,1>,<1,1,1>,<1,1,1>,
			<1,1,1>,<1,1,1>,<1,1,1>},
		array[9]{<15,5,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>},
		array[1]{0},<0,0,0>,<0,0,0>,<0,0,0>)
}
#declare KoDT_Sara=object{
	RTDH3(<0,0,0>,<0,0,0>,
		array[7]{<1,1,1>,<1,1,1>,<1,1,1>,<1,1,1>,
			<1,1,1>,<1,1,1>,<1,1,1>},
		array[9]{<15,5,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>},
		array[1]{0},<0,0,0>,<0,0,0>,<0,0,0>)
}
#local HFlesh=texture{pigment{colour rgb <0.79,0.45,0.31>}}
#local HHair =texture{pigment{colour rgb <0.55,0.33,0.15>}}
#declare Cave_mother=object{
	RTDH3(<0,0,0>,<0,0,0>,
		array[7]{<1,1,1>,<1,1,1>,<1.2,1.3,1.2>,<1.2,1.3,1.2>,
			<1.2,1.2,1.2>,<1.2,1,1.1>,<1.2,1,1.1>},
		array[9]{<15,5,0>,<15,0,-25>,<15,0,65>,<0,0,10>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>},
		array[1]{0},<0,0,0>,<0,0,0>,<0,0,0>)
}
#local HFlesh=texture{pigment{colour rgb <0.77,0.59,0.49>}}
#local HHair =texture{pigment{colour rgb <0.63,0.56,0.59>}}
#declare Cave_grandma=object{
	RTDH3(<0,0,0>,<0,0,0>,
		array[7]{<1,1,1>,<1,1,1.2>,<1.2,1.3,1.2>,<1.2,1.3,1.2>,
			<1.2,1.2,1.5>,<1.2,1,1.1>,<1.2,1,1.1>},
		array[9]{<15,5,0>,<15,0,-25>,<15,0,65>,<0,0,10>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>},
		array[1]{0},<0,0,0>,<0,0,0>,<0,0,0>)
}
#local HFlesh=texture{pigment{colour rgb <0.79,0.45,0.31>}}
#local HHair =texture{pigment{colour rgb <0.29,0.19,0.00>}}
#declare Cave_dad=object{
	RTDH3(<0,0,0>,<0,0,0>,
		array[7]{<1.3,1.1,1.3>,<1.5,1.43,2>,<1.6,1.48,1.6>,<1.6,1.48,1.6>,
			<1.4,0.62,2>,<1.25,1.067,1.09>,<1.25,1.067,1.09>},
		array[9]{<0,-15,0>,<0,0,-10>,<0,0,0>,<-30,0,10>,<30,10,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>},
		array[1]{0},<0,0,0>,<0,0,0>,<0,0,0>)
}
#local HFlesh=texture{pigment{colour rgb <0.79,0.45,0.31>}}
#local HHair =texture{pigment{colour rgb <0.70,0.30,0.15>}}
#local Furskin=texture{Woven}
#declare CavePizza=object{// cave pizza delivery guy
	RTDH3(<0,0,0>,<0,0,0>,
		array[7]{<1.05,1.1,1>,<1.05,1.2,1>,<1.05,1.1,1>,<1.05,1.1,1>,
			<1.05,1.1,1>,<1.05,0.8,1>,<1.05,0.8,1>},
		array[11]{<-10,-25,0>,<25,0,0>,<120,-20,0>,<-10,0,5>,<100,-10,0>,<15,0,0>,<-10,0,0>,<0,10,0>,<0,0,0>,<0,0,90>,<0,0,-90>},
		array[1]{0},<0,0,0>,<0,0,0>,<0,0,0>)
}
	psize:	Array[7] of size data
					0 Head <6,8,6>, 1 Torso <16,20,8>, 2 RArm <2.5,19,2.5>, 3 LArm <2.5,19,2.5>,
					4 Hips <10,8,5>, 5 RLeg <6.4,30,6.4>, 6 LLeg <6.4,30,6.4>
	prtns:	Array[9] of rotation data
					0 Head 1 right u arm 2 right l arm 3 left u arm 4 left l arm
					5 right u leg 6 right l leg 7 left u leg 8 left l leg
					9 right hand 10 left hand
*/
/*
#local HFlesh=texture{pigment{colour rgb <0.79,0.45,0.31>}}
#local HHair =texture{pigment{colour rgb <0.35,0.25,0.12>}}
#declare Cave_kid1=object{
	RTDH3(<0,0,0>,<0,0,0>,
		array[7]{<0.83,0.94,0.875>,<0.875,1.21,1>,<1,0.89,1>,<1,0.89,1>,
			<0.8,0.46,1>,<0.78,0.87,0.78>,<0.78,0.87,0.78>},
		array[9]{<0,-15,0>,<0,0,-10>,<0,0,5>,<-10,0,10>,<10,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>},
		array[1]{0},<0,0,0>,<0,0,0>,<0,0,0>)
}
#declare Cave_kid2=object{
	RTDH3(<0,0,0>,<0,0,0>,
		array[7]{<0.83,0.89,0.625>,<0.75,0.78,1>,<0.8,0.89,0.8>,<0.8,0.89,0.8>,
			<0.7,0.54,1>,<0.625,0.8,0.625>,<0.625,0.8,0.625>},
		array[9]{<0,15,0>,<-5,0,-10>,<0,0,5>,<0,0,10>,<5,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>},
		array[1]{0},<0,0,0>,<0,0,0>,<0,0,0>)
}
#local HFlesh=texture{pigment{colour rgb <0.79,0.45,0.31>}}
#local HHair =texture{pigment{colour rgb <0.70,0.30,0.15>}}
#declare Cave_kid3=object{
	RTDH3(<0,0,0>,<0,0,0>,
		array[7]{<0.75,0.89,0.75>,<0.68,0.71,0.875>,<0.8,0.63,0.8>,<0.8,0.63,0.8>,
			<0.6,0.46,0.8>,<0.47,0.43,0.47>,<0.47,0.43,0.47>},
		array[9]{<20,-5,0>,<-5,0,-10>,<0,0,5>,<0,0,10>,<5,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>},
		array[1]{0},<0,0,0>,<0,0,0>,<0,0,0>)
}

#declare UnitRTD=object{
	RTDH3(<0,0,0>,<0,0,0>,
		array[7]{<1/6,1/9,1/8>,<1/8,1/14,1/4>,<1/2.5,1/19,1/2.5>,<1/2.5,1/19,1/2.5>,
			<1/10,1/13,1/5>,<1/6.4,1/30,1/6.4>,<1/6.4,1/30,1/6.4>},
		array[9]{<15,5,0>,<15,0,-25>,<15,0,65>,<0,0,10>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>},
		array[1]{0},<0,0,0>,<0,0,0>,<0,0,0>)
}
*/
                         