// Persistence of Vision Ray Tracer Scene Description File
// File: The Cradle2.pov 
// Date: 01/01/2001
// Auth: Mick Hazelgrove

#version unofficial MegaPov 0.7;
#include "colors.inc"

#declare Rad_on = 1;   

#declare Sky_on = 1;
#declare Sea_on = 0;
#declare Ground_on =1; 
#declare Girders_on = 1;
#declare Gulls_on = 1;
#declare FlyingGulls_on = 1;
#declare Egg_on = 1;
#declare Fog_on = 1;
#declare Rocks_on = 1;
#declare Small_Rocks = 1;
#declare Shells_on =1;

// ----------------------------------------------------------------

global_settings{
  assumed_gamma 1.0
  max_trace_level 150
  
	#if(Rad_on =1)  
	  ini_option "+QR"
	       
	  radiosity{
	    pretrace_start 0.08
		pretrace_end .001
		count 50
		nearest_count  1//5 
		error_bound .05
		recursion_limit 1      
		low_error_factor .5
		gray_threshold 0
		minimum_reuse 0.015
		brightness 3 
		normal on     
		max_sample 2 
		adc_bailout 0.01/1
		}
	#end	
}

#declare Image_Length = 480;
#declare Image_Height = 640;

camera
{
  location <0.0, -3.0, -25> 
  direction 1.5*z
  right Image_Length/Image_Height*x
  look_at <0.0, 2.0, 0.0> 
}

sky_sphere{pigment {gradient y                          
   color_map { [0.0 SteelBlue+((White)/2)][0.75 rgb<.9,.625,.65>/1.25]}
 	}
  	  rotate x*-5
		}

light_source {<-400, 600, -400>color rgb <0.99, .8, .5>}

disc{<0, 0, 0> y,20.0,
  	pigment{rgb<.7,.5,.3>/1.25}
  		rotate x*45 rotate y*-45
			translate <-25,25,0>
				finish{ambient 60}
				no_shadow
				}
disc{<0, 0, 0>y,20.0,
  	pigment{rgb<.5,.25,.75>}
  		rotate x*45 rotate y*45
			translate <25,25,0>
				finish{ambient .325}
				no_shadow
				}
				
// ----------------------------------------------------------------

#declare Pigg = pigment{ 
	crackle 
	color_map {
		[0 rgb <0.8, 0.6, 0.4>]
		[.25 rgb <0.8, 0.8, 0.65>]
		[.5 rgb 1]
		[.75 rgb <0.99, 0.9, 0.7>]
		[1 rgb <0.99, 0.8, 0.6>]
		}
		scale 2.5
		solid
		}
		
#declare Pigg2 = pigment{
	crackle 
	color_map {
		[0 rgbt 1]
		[.25 rgb <0.8, 0.9, 0.5>]
		[.5 rgbt 1]
		[.75 rgb <0.99, 0.9, 0.7>]
		[1 rgbt 1]
		}
		scale .75
		solid
		}
		
// -----------------------------------------------------------------
#if(Sea_on = 1)

plane{y,-10 
	pigment{rgbt<0,.65,.5,0>}
		normal{ bumps 5 scale 5} 	
			finish{reflection .3 phong 1000 phong_size .05*3 ambient .2 diffuse 0}
			hollow
			}
			 
#end			
//--------------------------------------------------------------		
#if (Sky_on = 1)

#declare Cheight=5000; 
#declare Pdist=25;      
#declare Tdist=25;      
#declare Nboxes=12; 
#declare Count=1;      

#while (Count<=Nboxes)

#declare CldtopCol = color rgb<1,1,.875>*1.65;  
#declare p = color rgb<.95,.9,1>*1.6;

#declare p2=p*(1-(Count/Nboxes))+CldtopCol*(Count/Nboxes);  
box{<7500,0.001,70000><-7500,0,0>
  texture{
   pigment{
	spotted    
    	warp{ turbulence 6 omega .5 lambda 3}
    	turbulence .3
    color_map{        
     [0.0 Clear]
     [0.375 Clear]       
     [1.0 p2 filter .75*(Count/Nboxes)] 
    }
   	scale 17000    
   }
   translate <0,(Cheight+Tdist*Count),0>
  }
  translate <0,(Cheight+Pdist*Count),0>
  	finish{diffuse .15 ambient.01+(1.25*((Count/Nboxes)/1.875)) specular 1}
  		rotate x*5
  			hollow
 }
 #declare Count=Count+1;
#end

#end

//--------------------------------------------------------------------

#if(Fog_on = 1)

fog {fog_type 2 
distance 5000
rgb .8  
fog_offset 0.5
fog_alt 150 
}

fog {fog_type 2 
distance 5000
rgbt <.8,.8,1,.4>   
fog_offset 0.5
fog_alt 300 
}

#end
// -----------------------------------------------------------------
#if(Girders_on =1)
	
#declare defaultFlat = texture {
  pigment {
     bozo pigment_map{
  		[0 crackle pigment_map { 
  			[0 rgb< 1, 0.7, 0.1>]
  			[0.2 rgb< 0.8, 0.25, 0>*1.25]
  			[0.5 rgb< 0.3, 0.1, 0.1>]
  			[0.6 rgb< 0.9, 0.45, 0.2>*1.25]
  			[0.7 rgb< 0.8, 0.6, 0.1>*1.25]
  			[1 rgb< 0.7, 0.375, 0.0>/1.25]
  			}
  			scale 7.5
  			turbulence .35
  			frequency 2
  		]
  		[1 agate pigment_map { 
  			[0 rgb< 1, 0.7, 0.1>*1.25 ]
  			[0.2 rgb< 0.9, 0.25, 0>*1.25]
  			[0.45 rgb< 0.8, 0.3, 0.1>*1.25]
  			[0.65 rgb< 1, 0.25, 0.2>*1.25]
  			[0.7 rgb< 0.8, 0.4, 0.1>*1.25]
  			[1 rgb< 0.7, 0.375, 0.0  >*1.25]
  			}
  			scale 5
  			turbulence .5
  		]
  		}
  		scale 3
  		}
		#if(Rad_on=1)  		
		  finish {ambient 0 diffuse 0.325}
		#else
		  finish {ambient .325 diffuse 0}
		#end  
  normal{
  		bozo normal_map{
  				[0 facets coords 2 size 5 scallop_wave frequency 5]
  				[1 crackle 3 scale 5 ramp_wave frequency 5 turbulence .3]
  				}
  				scale 5
  				}
}

#declare RGirder = union{
	#include"girder4.inc"
	#include"cylinder.inc"
		
	object{Girder4 
	scale .0175 
	}
	object {Ring // bottom
	scale <.0115, .0125, .0375>
	translate<3.35,1,0.1>
	}
	object {Ring // middle
	scale <.0115, .0125, .0375>
	translate<1.875,2,0.125>
	}
	object {Ring // top
	scale <.0175, .0125, .0375>/1.3
	translate<1,3.425,0.15>
	}	
}

#declare EggCup = union{

#include "HGirder.inc"
	object{HGirder
		scale .025
		rotate z*101
		rotate y*65
		translate<0.25,6.5,-3.25>
		}
	
	object{RGirder rotate y*180 translate x*3.85} // right
	object{RGirder scale <-1,.975,1> rotate y*180  translate <-5.5,.01,0> } // left
	object{RGirder rotate z*45 rotate y*90 translate <-.75,-2.15,0>} // middle
	
	
#include"basegirder2.inc"

union{ 
	object{BaseGirder 
		scale .02
			rotate z*90
			rotate x*180
				translate<-.325,-2.25,2.75>
				}
	
	object {Ring // middle
	scale <.015, .0125, .0375>
	translate<-0.2,-1.275,0>
	}

	object {Ring // top
	scale <.0175, .015, .0375>
	translate<-0.2,-3.2,0>
	}
	translate x*-.325			
  }				
}

object{EggCup  rotate y*10 translate <.875,0,10>}	

#end
//-------------------------------------------------
#if (Ground_on = 1)

#declare GMTex = texture{
	pigment{
	wrinkles 
	color_map {
		[0 rgb <1,.9,.75>*1.5]
		[1 rgb <.85,.8,.65>*1.75]}
			scale .2 
			rotate y*-20
			warp{turbulence .375}
			}
	finish { ambient 0 diffuse .25  crand .05}
	normal{
		average normal_map{
			[0 ripples 500 scale <2, 55,10>/5 warp{turbulence .25}rotate y*-20 translate x*.5]
			[.5 ripples normal_map{[0 agate 5 scale <2, 5,10>/5][.5 wrinkles 5 scale<2, 5,10>/8]} rotate y*76]
			}
			scale.5
    	}	
}

#declare R = seed(463);

#declare GM =
height_field {
pattern 1000, 1000 {
hf_gray_16
	spotted
		color_map {
			[ 0.0 rgb 0 ]
			[ 1.0 rgb .1 ]
		}
		rotate y*35
warp {turbulence 2 lambda .25 }
scale 0.05
}
smooth
}

object{GM 
	scale <350,50,100>
	rotate y*-10
		translate <-80, -7.5, -50>
		texture{GMTex}
		}

#end

//-----------------------------------------------------------------------
#if(Gulls_on = 1)

#declare GLegTex = texture{
	pigment{rgb<1,.6,0>}
	normal{crackle 1 scale .2}
	finish{specular .5 ambient 0 diffuse .325}
	}
#macro Gull_Leg(Ankle,Hip,Thigh,Shin,KD,FRot,Rot, scle,XPos,YPos,ZPos)

#macro FindKnee(pA,pH,lT,lS,vD)
  #local lB=vlength(pA-(pH));
#if( (lB>lT+lS) | (lT>lB+lS) | (lS>lT+lB) )
#error "Invalid span lengths.\n"
#end
  #local tX=(lT*lT-lS*lS+lB*lB)/2/lB;
  #local tY=sqrt(lT*lT-tX*tX);
  #local vO=vnormalize(pA-(pH));
  #local vF=vnormalize(vcross(vD,vO));
  #local vU=vnormalize(vcross(vO,vF));
  #declare KPos =(pH+vO*tX+vU*tY);
#end

FindKnee(Ankle,Hip,Thigh,Shin,KD)

#declare Foot = union{
blob{
  threshold 0.6   
  	cylinder { x*1.5, x*-0.1, 0.15, 1 rotate y*-35 }// L
  	cylinder { x*1.5, x*-0.1, 0.15, 1 }// M
  	cylinder { x*1.5, x*-0.1, 0.15, 1 rotate y*35 }// R 
  	sphere{x*1.5,.25,1}
  	sphere{x*1.5,.25,1 rotate y*35}
  	sphere{x*1.5,.25,1 rotate y*-35}
  	}
//prism 
prism {
  linear_sweep 
  cubic_spline 
   0, 
   0.01,
    6, 
    < 3, -3>,
    < 3,  3>,
    <-5,  0>,
    < 3, -3>, 
    < 3,  3>, 
    <-5,  0> 
    	scale <.18,.2,.32>/1.25
    		translate x*.85 
} 	
//cones
cone{x*0,.1,x*.5,0 rotate z*-10 translate x*1.5}
cone{x*0,.1,x*.5,0 rotate z*-10 translate x*1.5 rotate y*-35  }
cone{x*0,.1,x*.5,0 rotate z*-10 translate x*1.5 rotate y*35  }  	
} // end union

#declare Leg = union{  	   
blob{
  threshold 0.6 
// upper leg  
	cylinder{0,KPos,.2,1}
	cylinder{<-.3,0,0>,KPos,.2,1}
	cylinder{<-.15,0,0>,KPos,.2,1}
	sphere{KPos,.25,1} // Knee
//lower leg	
	cylinder{KPos,Ankle,.2,1}
	sphere{Ankle,.35,1}
	}
object{Foot	rotate z*FRot translate Ankle}
}// end union
	
object{Leg rotate Rot translate<XPos,YPos,ZPos> scale scle  texture{GLegTex}}

#end // end macro

#declare GullTex = texture {
	pigment{image_map{sys"UVHPSGallmppnt.bmp"}}
		#if(Rad_on = 1) 
			finish{ambient 0 diffuse .5 brilliance 0}
		#else
			finish{ambient .375 diffuse 0 brilliance 0}
		#end
	normal{wrinkles 50 scale <.075,.005,.005>rotate z*-35 turbulence 8 scallop_wave}
	}

#include "HPSGallcv_o.inc"

#declare Gull = 
	object{ SeaGull // right
	scale <.175,.175,.2>
	rotate y*90
	}

#declare SeagullUP_Tex = texture {
	pigment{image_map{sys"UVseagullup.bmp"}} 
		#if(Rad_on = 1) 
			finish{ambient 0 diffuse .5 brilliance 0}
		#else
			finish{ambient .375 diffuse 0 brilliance 0}
		#end
	normal{wrinkles 50 scale <.075,.005,.005>rotate z*-35 turbulence 8 scallop_wave}
	}
	
#include "seagullup_o.inc"

#declare GullUP = 
	object{ SeagullUP 
	scale <.175,.175,.2>
	rotate y*90
	}

#declare GullTex3 = texture {
	pigment{image_map{sys"UVseagull3.bmp"}} 
		#if(Rad_on = 1) 
			finish{ambient 0 diffuse .5 brilliance 1.7}
		#else
			finish{ambient .375 diffuse 0 brilliance 1.7}
		#end
	normal{wrinkles 50 scale <.075,.005,.005>rotate z*-35 turbulence 8 scallop_wave}
	}
	
#include "seagull3_o.inc" // looking down
	
#declare Gull3 = 
	object{ Seagull3 // right
	scale <.175,.175,.2> // .2
	rotate y*90
	translate<-.5,0.4,0>
	}
	

#declare GL= union{ // back left			
object{GullUP scale .06*5} 
		Gull_Leg(<1,-3.5,0>,0,1.5,2.5,<-1,0,0>,-5,<0,-90,0>,.185,-1,-3.25,0)
        Gull_Leg(<-1.5,-2.325,0>,0,1.5, 2.5,<-1,0,0>,-45,<0,-90,0>,.185,0.5,-3.25,0)
}
object{GL rotate y*120 translate <-6.25,-0.975,5>}

#declare GR= union{		
object{Gull3 scale .055*5 rotate z*10} 
	Gull_Leg(<1,-3.85,0>,0, 1.5,2.5,<-1,0,0>,-27.5,<0,90,0>,.155,-1,-1.125,0)
	Gull_Leg(<-1.5,-3.2,0>,0,1.5, 2.5,<-1,0,0>, -25,<0,90,0>, .155,0,-1.125,0)
}
object{GR rotate y*45 translate <4.75,-1.75,-0.75>}

#declare HPGull = union{
	object{Gull //High Priest was Gull
	scale .0425*3
	rotate z*-25
	}
		Gull_Leg(<.9,-3.65,0>,0,1.5,2.5,<-1,0,0>,<0,-10,50>,<0,-190,0>,<.065,.095,.065>,1,-1.5,-1 )
        Gull_Leg(<1.5,-3.25,0>,0,1.5,2.5,<-1,0,0>,<0,-90,50>,<0,-190,0>,<.075,.095,.075>,1,-1.5,1)
}
object{HPGull rotate y*100 translate<-1.089,-2.35,-15.399>}

#declare GBL= union{ // back left			
	object{GullUP scale .325 } 
		Gull_Leg(<0,-3.5,0>, 0,1.5, 2.5, <-1,0,0>,-10,<0,90,0>,.185,-1,-3.25,0 )
        Gull_Leg(<0,-3.5,0>, 0,1.5,2.5,<-1,0,0>,-30,<0,90,0>,.185,0,-3.25,1)
}
object{GBL rotate y*-120 translate<-1.6,-2.11,11>}

#declare BR= union{ // back right			
	object{GullUP scale .325 rotate z*-10 translate y*.4} 
		Gull_Leg(<1,-3.5,0>,0,1.5,2.5,<-1,0,0>,-20,<0,-90,0>,.185,0,-1.125,1 )
        Gull_Leg(<1,-3.5,0>, 0,1.5,2.5,<-1,0,0>,-20,<0,-90,0>,.185,0,-1.125,-1)
}
object{BR rotate y*-60 translate<5.325,-1.8,15>}

#declare FFR= union{ //front front right			
	object{GullUP scale .125 rotate z*-25 }
		Gull_Leg(<1,-3.5,0>,0,1.5,2.5,<-1,0,0>,180,<0,0,0>,.09,-0,-1.3125,-.325)
        Gull_Leg(<1,-3.5,0>,0,1.5,2.5,<-1,0,0>,0,<0,180,0>,.09,0,-1.3125,.325 )
}
object{FFR rotate y*65 translate<1.075,-3.5,-16>}

#declare FFL= union{ //front front left			
	object{GullUP scale .125 rotate z*-5 } 
		Gull_Leg(<-1.5,-2.75,0>,0, 1.5,2.5,<-1,0,0>,-30,<0,180,0>,.075,0,-2.85, -.45 )
        Gull_Leg(<1,-3.5,0>,0,1.5,2.5,<-1,0,0>,0, <0,180,0>,.075,0,-3,.45)
}                                      
object{FFL rotate y*115 translate<-1.3325,-3.3125,-16.875>}

#declare FFML= union{ // front front middle left			
object{GullUP scale .1 scale<-1,1,1> rotate z*20} 
		Gull_Leg(<0 ,-3.5,0>,0,1.5,2.5,<-1,0,0>,0,<0,0,0>,.08,-0,-2.25,-.75)
        Gull_Leg(<0,-3.5,0>, 0,1.5,2.5, <-1,0,0>,-10,<0,0,0>,.08,0,-2.25,.75)
}
object{FFML rotate y*-70 translate <-.5,-3.5,-18.75>}

#declare FFMR= union{ // front front middle right			
object{GullUP scale .125 scale<-1,1,1> rotate z*25 } 
		Gull_Leg(<1,-3.5,0>,0,1.5,2.5,<-1,0,0>,0,<0,00,0>,.08,-0,-1.5,-1 )
        Gull_Leg(<1,-3.5,0>,0,1.5,2.5,<-1,0,0>,0,<0,00,0>,.08,0,-1.5,1)
}
object{FFMR rotate y*-105 translate<.5,-3.65,-16.75> }

#declare FFM= union{ // front front middle		
object{GullUP scale .125 scale<-1,1,1> rotate z*10 translate y*.2} 
		Gull_Leg(<-1.5,-2,0>, 0,1.5,2.5,<-1,0,0>,-50,<0,0,0>,<.08,.065,.08>,0,-1.125,-.7)
        Gull_Leg(<0,-3.5,0>,0,1.5,2.5,<-1,0,0>,-10,<0,-0,0>,<.08,.065,.08>,0,-1.125,.7)
}                                                 
object{FFM rotate y*-85 rotate x*-15 translate<0,-3.275,-16>}

#declare FFFR= union{ // front front far right on right front rock 			
object{GullUP scale .125 scale<-1,1,1> rotate z*15 translate y*.12} 
		Gull_Leg(<-1.5,-2.5,0>,0,1.5,2.5,<-1,0,0>,-45,<0,-90,0>,<.085,.06,.085>,2,-2,-.4)
        Gull_Leg(<0,-3.375,0>,0,1.5,2.5,<-1,0,0>,-25, <0,-90,0>,<.085,.06,.085>,2, -2,.4)
}
object{FFFR rotate y*-105 translate<1.65,-3.325,-16.125>}

#declare PGullTex = texture{
	pigment{image_map{sys"UVPreacherGull5mk2.bmp"}}
		#if(Rad_on = 1) 
			finish{ambient 0 diffuse .5 brilliance 0} 
		#else
			finish{ambient .375 diffuse 0 brilliance 0}
		#end
	normal{wrinkles 10 scale <.1,.01,.01>rotate z*-35 turbulence 8 ramp_wave}
			}

#include "PreacherGull5mk2_o.inc"
#declare Preacher = union{
	object{ PGull scale .07 rotate y*-15 rotate x*-22 translate<0,11.25,10>} // y was -10
		Gull_Leg(<1,-3.5,0>,0,1.5,2.5,<-1,0,0>, -50,<0,90,0>,.2,1.2, 53.25,48)
		Gull_Leg(<1,-3.5,0>,0, 1.5,2.5,<-1,0,0>,-50,<0,90,0>,.2,-.75,53.25,48 )
}

object{Preacher translate <0.115,.225,0>}
	
#end	
// ------------------------------------------------------------------------
#if(Egg_on=1)

#declare EggTex = texture{
	pigment{Pigg}                                                         
		normal{ granite 10 scallop_wave scale .025}
			finish{ambient 0 diffuse .3 brilliance 3}
			}
texture{
	pigment{Pigg2}
		normal{bozo normal_map{ 
			[0 bozo 5 scallop_wave scale 0.5*4]
			[.2 bozo 20 scallop_wave scale 1.5*4]
			[.9 bozo 25 scallop_wave scale 0.5*2]
			[1 bozo 10 scallop_wave scale 3*4]
			}
		 		turbulence .3
		 		}
			finish{specular .125 ambient 0  diffuse .45 crand .125 brilliance 2} 
			}
  									
#include"Rock1.inc"
object{Rock rotate z*-90 
	texture{EggTex}
		scale <.17,.2,.17>
			rotate y*-45
			rotate x*7.5
			rotate z*0
				translate <0, 6 ,10>
				}

#end

//-------------------------------------------------------------

#if (Rocks_on = 1)
		
#declare RockTex = texture{
	pigment{Pigg}                                                         
		normal{ granite 10 scallop_wave scale .025}
			finish{ambient 0 diffuse .3 brilliance 2}
			}
texture{
	pigment{Pigg2}
		normal{bozo normal_map{ 
			[0 bozo 5 scallop_wave scale 0.5*4]
			[.2 bozo 20 scallop_wave scale 1.5*4]
			[.9 bozo 25 scallop_wave scale 0.5*2]
			[1 bozo 10 scallop_wave scale 3*4]
			}
		 		turbulence .3
		 		}
			finish{specular .1 ambient 0  diffuse .45 crand .125 brilliance 2} // brilliance was 3
			}					
						
#include"rock1.inc"

#if(Small_Rocks=1)

#declare R = seed(1267);

#declare TracedObj = union{
$ Norm = <0,0,0>;
$ Xpos = .233;
$ Zpos = .85;
 
#while (Xpos<.3)
   #while (Zpos<.875)
        
       $ SPos = <Xpos,1,Zpos>;
       $ Inter = trace (GM,SPos,<0,-1,0>, Norm ); 
            #declare Ht = .0005+(rand(R)/5000);
            #if (vlength(Norm)!=0)
			    object{Rock 
			    texture{RockTex scale 3}
			    scale ((<.0001,.0004,.0001>)/2.5)*rand(R) 
			    	rotate y*rand(R)*360 
					translate <Inter.x+((rand(R)-0.5)/1000),Inter.y-(Ht/1.5),Inter.z+((rand(R)-0.5)/1000)>
					}
            #end 
                        
     $ Zpos = Zpos +.001125;
    #end           
    $ Zpos = 0.125;
  $ Xpos = Xpos +.001125; 
 #end 
}
object{TracedObj 	
scale <350,50,100>
	rotate y*-10
		translate <-80, -7.5, -50>
		}

#end // small rocks

//left group
object{Rock // far left
texture{RockTex} 
	scale <.1,.08,.1> 
		rotate<0,180,0>
		translate<-5.55,-3.5,5>
		}
// right group		
object{Rock // far right
texture{RockTex}
	scale <.1,.08,.1>/1.2 
		rotate<45,30,0>
		translate<4,-3.75,-4.75>
		}
object{Rock //mid right small
texture{RockTex}
	scale <.1,.08,.1>/3 
		rotate<90,0,0>
		translate<1.15,-4.325,-6>
		}
object{Rock //mid right small
texture{RockTex}
	scale <.1,.08,.1>/2.5 
		rotate<180,0,0>
		translate<2.5,-4,-7>
		}
// middle group
object{Rock // middle middle
texture{RockTex}
	scale <.1,.08,.1>/1.2 
		rotate<45,210,0>
		translate<1.25,-4.5,12>
		}
object{Rock // middle right
texture{RockTex}
	scale <.1,.08,.1>/1.75 
		rotate<45,-30,0>
		translate<2,-4.325,9>
		}
object{Rock // middle left
texture{RockTex}
	scale <.1,.08,.1>/2
		rotate<145,30,0>
		translate<-2.5,-4.125,5>
		}
		
//Front		
object{Rock // front left
texture{RockTex}
	scale <.1,.08,.1>/3
		rotate<0,-200,-30>
		translate<-1.5,-3.7,-16.325>
		}
object{Rock // right
texture{RockTex}
	scale <.1,.08,.1>/3
		rotate<90,-10,0>
		translate<1.5,-4.125,-16.5>
		}
// Priest Rock
object{Rock 
texture{RockTex}
	scale .04
		rotate<0,0,-90>
		translate<-1.1,-3.5,-15>// x was 1 
		}
object{Rock // right
texture{RockTex}
	scale .06
		rotate<0,180,0>
		translate<-1.25,-4.35,11>
		}
object{Rock // right back back vert
texture{RockTex}
		rotate<0,0,-90>
		scale <.125,.055,.075>
		translate<5.65,-3.75,18>
		}		
#end

//-----------------------------------------------

#if(FlyingGulls_on = 1)

#declare Wangle = 80;
#declare WHeight = 2.75;
#declare WWidth = 2.75;
#include "FlyingGull.inc" 

	object{Bird // topright
	scale 0.05*2
	rotate x*20                                     
	rotate y*-65
	translate<3.5,11,1.5>
	no_shadow 
	}

#declare Wangle = 80;
#declare WHeight = 2.75;
#declare WWidth = 2.75; 
#include "FlyingGull.inc" 

	object{Bird // left middle
	scale 0.065*2 
	rotate y*225//225
	rotate z*-15
	translate<-4.75,2.5,1.5>
	no_shadow  
	}

#declare Wangle = 110;
#declare WHeight = 1;
#declare WWidth = 3.75;
#include "FlyingGull.inc"

	object{Bird // low right
	scale 0.06*1.5
	rotate y*320
	rotate z*20
	rotate x*5
	translate<3.5,-.4,-3>
	no_shadow  
	}

#declare Wangle = 110;
#declare WHeight = 1;
#declare WWidth = 3.75;
#include "FlyingGull.inc" 

	object{Bird // top left
	scale .0825
	rotate y*65
	rotate y*180
	rotate z*-30
	translate<-6.125,9.5,3>
	no_shadow  
	}

#declare Wangle = 80;
#declare WHeight = 2.75;
#declare WWidth = 2.75;
#include "FlyingGull.inc" 

	object{Bird // midright
	scale 0.09
	rotate y*-15
	rotate z*0
	translate<5,5,1>
	no_shadow  
	}

#end

//-----------------------------------------------------------------------

#if(Shells_on = 1)

#declare ShellTex5 =
texture{
	pigment{rgbt <1,1,1,.3>}
			finish{ ambient 0 diffuse .1 specular 1 phong 100 phong_size 200}
			}
texture{
	pigment{rgbt 1}
		finish {
		        ambient 0
		        diffuse .15
		        specular 0.2
		        roughness .01
				    irid {
				          0.5
				          thickness 0.5
				          turbulence 0.3
				         }
		     }		     
  }

#include"Shell.inc"
					
object{Shell 
	scale <.03,0.01,0.03>
		rotate x*-210 rotate z*-50 rotate y*40
		translate<-.125,-3.745,-16.325> // y was -3.7335  
}

sphere{0,.035 texture{ShellTex5}translate<-.08,-3.775,-17.00>} 

#end