#version unofficial MegaPov 0.5;

#ifndef(main)
#include "wrmat.inc"
// 0 for simple throne, 1 for complex throne and 2 for full textures
#declare throne = 3;
camera { location <.5,2.01,-2> look_at <-.2,.5,0> }
light_source { <0,3,0> color rgb 1 }
#end

/************** Throne *************/

// lower step
union {
  box { <-.25,.1,0> <.25,.125,-.0125> texture { carpet } }  // carpet
  #local i = 0;
  #local n = 40;
  #local sp = sphere { 0 .013 texture { gold } }
  #while (i<=n)
    object { sp translate <-.25+i/n*.5,.09,.008> }
    object { sp scale <.5,3,.5> translate <-.25+i/n*.5,.09,.00625> }
    #local i = i + 1;
  #end
  union {
    cylinder { <-.275,.135,-.0125> <.275,.135,-.0125> .01 }
    sphere { <-.275,.135,-.0125> .02 }
    sphere { <.275,.135,-.0125> .02 }
    texture { gold }
  }
  
  union {
    cylinder { <-.275,.135,.245> <.275,.135,.245> .01 }
    sphere { <-.275,.135,.245> .02 }
    sphere { <.275,.135,.245> .02 }
    texture { gold }
  }

  box { <-.7475,0.05,.0025> <.7475,.115,1.9875> }
  box { <-.75,0.115,0> <.75,.12,2> }
  box { <-.25,.12,0> <.25,.125,.25> texture { carpet } }  // carpet

  box { <-.25,.12,.245> <.25,.25,.25> texture { carpet } } // carpet
  union {
    cylinder { <-.275,.25,.245> <.275,.25,.245> .01 }
    sphere { <-.275,.25,.245> .02 }
    sphere { <.275,.25,.245> .02 }
    texture { gold }
  }

  // upper step
  box { <-.4975,.125,.2525> <.4975,.24,1.7> }
  difference {
    box { <-.5,.24,.25> <.5,.245,1.75> }
    #local i=0;
    #local n=7;
    #local sz=.002;
    #local tmp=1.5/n;
    #while (i<n) cylinder { <-.6,.245,.25+tmp*i> <.6,.245,.25+tmp*i> sz %i=i+1;}#end
    cylinder { <-0.5,.245,0> <-0.5,.245,2> sz }
    cylinder { < 0.5,.245,0> < 0.5,.245,2> sz }
  }
  box { <-.25,.245,.25> <.25,.25,1.75> texture { carpet } } // carpet

  texture { throne_wood }
}
union {
  box { <-.225,.7,1.275> <-.175,.725,.8> }
  box { < .225,.7,1.275> < .175,.725,.8> }
  texture { light_wood }
}
union {
  box { <-.225,.25,.9> <-.175,.7,.925> }
  box { < .225,.25,.9> < .175,.7,.925> }
  box { <-.225,.25,1.25> <-.175,.7,1.275> }
  box { < .225,.25,1.25> < .175,.7,1.275> }
  texture { light_wood }
}
difference {
  intersection {
    box { <.25,.6,1.25> <-.25,2,1.275> }
    cylinder { <0,.6,.9> <0,.6,1.5> .4 }
  }
  cylinder { <0,0,-2> <0,0,2> 1 scale <.1,.4,1> translate <-.22,.6> }
  cylinder { <0,0,-2> <0,0,2> 1 scale <.1,.4,1> translate <.22,.6> }
  texture { light_wood }
}
superellipsoid { 
  <.5,.5> 
  scale <.10,.165,.025> translate <0,.8,1.25> 
  texture { pillow } 
}
box { 
  <.175,.55,.9> <-.175,.6,1.25>
  texture { light_wood }
}
superellipsoid { 
  <.5,.5> 
  scale <.15,.025,.15> translate <0,.6,1.075> 
  texture { pillow } 
}
