#include "macros.inc"
#include "ganesha_3ds_objects_trone_bottom.inc"       


#declare GoldBase = <1.00, 0.875, 0.575>;
#declare myGoldPigment =
pigment
{
   color rgb GoldBase * 1.4 + <0.1,0.1,0>
}
#declare tGold = texture { pigment { myGoldPigment } finish { F_MetalE } }

#declare tFlower =
texture
{
   tGold
}
                    
#declare T_Grnt20mod =
texture {
pigment
 {granite
  turbulence 0.0
  color_map
   {[0.0, 0.3 color rgb <0.7,0.9,0.78> color White]
    [0.3, 0.4 color White color White]
    [0.4, 0.6 color White color White]
    [0.6, 1.0 color White color White]
   }
 }
 finish {
  crand 0.02
 }
 }                    
                    
#declare T_Grnt8amod =
texture {
pigment
 {granite
  turbulence 0.6
  color_map
   {[0.000, 0.119   color rgbf <0.310, 0.384, 0.420, 0.631>+<0,0.2,0>
                    color rgbf <0.322, 0.369, 0.416, 0.847>+<0,0.2,0>]
    [0.119, 0.322   color rgbf <0.322, 0.369, 0.416, 0.847>+<0,0.2,0>
                    color rgbf <0.424, 0.369, 0.420, 0.549>+<0,0.2,0>]
    [0.322, 0.449   color rgbf <0.424, 0.369, 0.420, 0.549>+<0,0.2,0>
                    color rgbf <0.373, 0.424, 0.518, 0.965>+<0,0.2,0>]
    [0.449, 0.729   color rgbf <0.373, 0.424, 0.518, 0.965>+<0,0.2,0>
                    color rgbf <0.482, 0.573, 0.533, 0.741>+<0,0.2,0>]
    [0.729, 1.001   color rgbf <0.482, 0.573, 0.533, 0.741>+<0,0.2,0>
                    color rgbf <0.310, 0.384, 0.420, 0.631>+<0,0.2,0>]
   }
 }
 }
                   
#declare T_Stone15mod =
texture{T_Grnt20mod scale <1, 2, 2> rotate <0, 0, -30>
        finish{ambient 0.2 diffuse 0.9 crand 0.03}
}
texture{T_Grnt8amod scale <1, 2, 1> rotate <0, 0, 40>
        finish{phong 1.0 phong_size 90}
}               
                                 
#declare tTroneBottom =
texture
{
   T_Stone15mod
   finish
   {
      reflection 0.1
   }      
   scale 1.5
}                                 

#declare tTroneBottomUpperBox =
texture
{
/*   pigment
   {
      color rgb<.75,.75,.75>
   }
*/
   T_Stone27
   finish
   {
      reflection 0.34
   }                
   scale 5
}                                 

                                 
#declare oBottomBox =
object
{
   mBoxRounded(10,0.8,10,0.04)
   translate <0,0.4,0>
}                     
                             
#declare oBottomBoxInside =
box
{
   <-5.3,0,-5.3>,<5.3,0.4,5.3>
}

#declare oFront = 
union
{                 
   object
   {
      mBoxRounded(10.6,0.1,0.1,0.04)
      translate <0,0.75,-5.3>
   }
   object
   {
      mBoxRounded(10.6,0.1,0.1,0.04)
      translate <0,0.05,-5.3>
   }
   object
   {
      mBoxRounded(0.1,0.8,0.1,0.04)
      translate <-5.3,0.4,-5.3>
   }
   box
   {
      <-5.26,0.05,-5.26>,<5.26,0.75,-5.26>
   }
}                   

#declare oAllFronts =
union
{
   object{oFront}
   object{oFront rotate <0,90,0>}
   object{oFront rotate <0,180,0>}  
   object{oFront rotate <0,270,0>}   
}          

#declare oBackWithBalls = 
object
{
   maxBackWithBalls
   scale 1/300
   translate<0,2.2,0>         
   rotate <-60,180,0>
   translate <0,0,-6.8>
}
                         
#declare oFrontCurl = 
object
{
   maxFrontCurl
   scale 1/300
   translate<0,2.2,0>         
   rotate <-60,180,0>
   translate <0,0,-6.8>
}
                         
#declare iCounter = 1;

#declare oAllFrontCurls =
object
{  
   oFrontCurl
}

#while (iCounter < 6)
#declare oAllFrontCurls = 
   union
   {
      object{oAllFrontCurls}
      object
      {
         oFrontCurl
         translate <iCounter * 0.78, 0,0>
      }
      object
      {
         oFrontCurl
         translate <iCounter * -0.78, 0,0>
      }
   }
   #declare iCounter = iCounter + 1;
#end
                          

#declare iCounter = 1;

#declare oAllBackWithBalls =
sphere {<0,0,0>,0.00001}                          
                          
#while (iCounter < 6)
#declare oAllBackWithBalls = 
   union
   {
      object{oAllBackWithBalls}
      object
      {
         oBackWithBalls
         translate <iCounter * 0.78, 0,0>
      }
      object
      {
         oBackWithBalls
         scale <-1,1,1>
         translate <iCounter * -0.78, 0,0>
      }
   }
   #declare iCounter = iCounter + 1;
#end

#declare oTriBlob = 
object
{
   maxTriBlob
   scale 1/360
   rotate <90,0,0>
   translate <0,1.1,-4.6>   
}

#declare oAllTriBlobs = sphere{<0,0,0>,0.000001}

#declare iCounter = 0;

#while (iCounter < 11)
#declare oAllTriBlobs = 
   union
   {
      object{oAllTriBlobs}
      object
      {
         oTriBlob
         translate <-4.3,0,iCounter * 0.75>
      }
      object
      {
         oTriBlob
         translate <4.3,0,iCounter * 0.75>
      }                                
   }
   #declare iCounter = iCounter + 1;
#end

#declare oPlaneRounded =
intersection
{  
   union
   {
      cylinder
      {
         <-4.2-0.14,1.45,-4>,<4.2+0.14,1.45,-4>,0.14
      }
      box
      {
         <-4.2-0.14,1.45-0.14,-4>,<4.2+0.14,1.45+0.14,4>
      }
   }
   union
   {
      cylinder
      {
         <-4.2,1.45,-4-0.14>,<-4.2,1.45,4>,0.14
      }
      box
      {
         <-4.2,1.45-0.14,-4-0.14>,<4.2+0.14,1.45+0.18,4>
      }
   }  
   union
   {
      cylinder
      {
         <4.2,1.45,-4-0.14>,<4.2,1.45,4>,0.14
      }
      box
      {
         <-4.2-0.14,1.45-0.14,-4-0.14>,<4.2,1.45+0.18,4>
      }
   }
   scale <0.99,1.5,1>
   translate <0,-0.6,0>
}

#declare oCylinderBubbles =
intersection
{
   union
   {  
      #declare iCounter = -7.5;
      #while (iCounter < 8)
      
         cylinder 
         {
            <0,1.45,0>,<0,1.45,-6>,0.1
            scale <1.8,1,1,>
            translate <iCounter * 0.53,0,0>
         }                                
         #declare iCounter = iCounter + 1;
      #end
   }
   cylinder
   {
      <-4.2-0.14,1.45,-4>,<4.2+0.14,1.45,-4>,0.17
   }
   scale <0.99,1.5,1>
   translate <0,-0.6,0>
}
   
#declare oEdelStone =
intersection
{
   plane {<0,1,0>,1 rotate <0,0,36>}
   plane {<0,1,0>,1 rotate <0,0,36> rotate <0,72,0>}
   plane {<0,1,0>,1 rotate <0,0,36> rotate <0,2*72,0>}
   plane {<0,1,0>,1 rotate <0,0,36> rotate <0,3*72,0>}
   plane {<0,1,0>,1 rotate <0,0,36> rotate <0,4*72,0>}

   plane {<0,1,0>,1 rotate <0,0,2*36>}
   plane {<0,1,0>,1 rotate <0,0,2*36> rotate <0,72,0>}
   plane {<0,1,0>,1 rotate <0,0,2*36> rotate <0,2*72,0>}
   plane {<0,1,0>,1 rotate <0,0,2*36> rotate <0,3*72,0>}
   plane {<0,1,0>,1 rotate <0,0,2*36> rotate <0,4*72,0>}

   plane {<0,1,0>,1 rotate <0,0,3*36> rotate <0,0+36,0>}
   plane {<0,1,0>,1 rotate <0,0,3*36> rotate <0,72+36,0>}
   plane {<0,1,0>,1 rotate <0,0,3*36> rotate <0,2*72+36,0>}
   plane {<0,1,0>,1 rotate <0,0,3*36> rotate <0,3*72+36,0>}
   plane {<0,1,0>,1 rotate <0,0,3*36> rotate <0,4*72+36,0>}

   plane {<0,1,0>,1 rotate <0,0,4*36> rotate <0,0+36,0>}
   plane {<0,1,0>,1 rotate <0,0,4*36> rotate <0,72+36,0>}
   plane {<0,1,0>,1 rotate <0,0,4*36> rotate <0,2*72+36,0>}
   plane {<0,1,0>,1 rotate <0,0,4*36> rotate <0,3*72+36,0>}
   plane {<0,1,0>,1 rotate <0,0,4*36> rotate <0,4*72+36,0>}   
   
   bounded_by { sphere {<0,0,0>, 1.1}}
   
   scale 1/12
   translate <0,1.45*1.5 - 0.6,-4.16> 
   
}

#declare oAllEdelStones =
union   
{
   #declare iCounter = -7.5;
   #while (iCounter < 8)
   
      object
      {
         oEdelStone
         translate <iCounter * 0.526,0,0>
         texture
         {  
            pigment
            {    
               color rgbf <0.9, 0.1, 0.2, 0.5> 
            }
            finish 
            {
                ambient 0.1
                diffuse 0.1
                reflection .75
                specular 1
                roughness 0.0005
            }              
      
         }
         interior
         {
            ior 1.5
         }
      }
      #declare iCounter = iCounter + 1;
   
      #if (iCounter < 8)
         object
         {
            oEdelStone
            translate <iCounter * 0.526,0,0>
            texture
            {  
               pigment
               {
                  color rgbf <0.2, 0.1, 0.9, 0.5> 
               }
               finish 
               {
                   ambient 0.1
                   diffuse 0.1
                   reflection .75
                   specular 1
                   roughness 0.0005
               }      
            }
            interior
            {
               ior 1.5
            }
         }
      #end
      #declare iCounter = iCounter + 1;
   #end
}   
                 
#declare oMiddleBox =
object
{
   mBoxRounded(8.15,2,8.15,0.08)
   translate <0,1,0>
}                         

#declare oMiddleBoxInside =
box
{
   <-3.95,0,-3.95>,<3.95,3,3.95>
}

#declare oFlower =
object    
{
   maxFlower 
   scale 1/500   
   rotate <90,0,0>
   translate<0,2.33,-4.08>
}

#declare iCounter = -1.9;

#declare oAllFlowers =
union
{
   #while (iCounter < 3)
   object
   {
      oFlower
      translate <iCounter * 1.76,0,0>
   }
   #declare iCounter = iCounter + 1;
   #end
}                   

#declare oZijSpalken =
union
{
   #declare iCounter = 0;
   #while (iCounter < 5)
      object 
      {
         mBoxRounded(0.1,0.9,0.1,0.04)
         translate <-3.95+0.05 + iCounter * 1.76,0.35+2,-3.95-0.05>
      }
      object 
      {
         mBoxRounded(0.1,0.9,0.1,0.04)
         translate <3.95-0.05 - iCounter * 1.76,0.35+2,-3.95-0.05>
      }
      #declare iCounter = iCounter + 1;
   #end
}

#declare oRooster =
intersection
{
   box
   {
      <-1.3,-1.1,-0.3>,<1.3,1.1,0.3>
   }
   union
   {
      object{mBoxRounded(0.14,3.2,0.14,0.06) translate <-1.6,0,0>}
      object{mBoxRounded(0.14,3.2,0.14,0.06) translate <-1.2,0,0>}
      object{mBoxRounded(0.14,3.2,0.14,0.06) translate <-0.8,0,0>}
      object{mBoxRounded(0.14,3.2,0.14,0.06) translate <-0.4,0,0>}
      object{mBoxRounded(0.14,3.2,0.14,0.06) translate <0,0,0>}
      object{mBoxRounded(0.14,3.2,0.14,0.06) translate <0.4,0,0>}
      object{mBoxRounded(0.14,3.2,0.14,0.06) translate <0.8,0,0>}
      object{mBoxRounded(0.14,3.2,0.14,0.06) translate <1.2,0,0>}
      object{mBoxRounded(0.14,3.2,0.14,0.06) translate <1.6,0,0>}
   
      object{mBoxRounded(3.2,0.14,0.14,0.06) translate <0,-1.6,0>}
      object{mBoxRounded(3.2,0.14,0.14,0.06) translate <0,-1.2,0>}
      object{mBoxRounded(3.2,0.14,0.14,0.06) translate <0,-0.8,0>}
      object{mBoxRounded(3.2,0.14,0.14,0.06) translate <0,-0.4,0>}
      object{mBoxRounded(3.2,0.14,0.14,0.06) translate <0,0,0>}
      object{mBoxRounded(3.2,0.14,0.14,0.06) translate <0,0.4,0>}
      object{mBoxRounded(3.2,0.14,0.14,0.06) translate <0,0.8,0>}
      object{mBoxRounded(3.2,0.14,0.14,0.06) translate <0,1.2,0>}
      object{mBoxRounded(3.2,0.14,0.14,0.06) translate <0,1.6,0>}
   
      rotate <0,0,45>
   }
   bounded_by
   {
      box
      {
         <-1.4,-1.2,-0.4>,<1.4,1.2,0.4>
      }
   }
   scale <0.36,0.36,1>
   translate <2,2.3,-3.92>   
}                        

#declare oAllRoosters =
union
{    
   #declare iCounter = -2.65;               
   #while (iCounter < 1)   
   object
   {
      oRooster
      translate <iCounter * 1.75, 0, 0>
   }       
   #declare iCounter = iCounter + 1;
   #end
}

#declare oMiddleBox2 =
object
{
   mBoxRounded(8.15,0.24,8.15,0.08)
   translate <0,2.77,0>
}                         

#declare oMiddleBox3 =
object
{
   mBoxRounded(8.3,0.12,8.3,0.05)
   translate <0,2.9,0>
}                         

#declare oEdelStone2 =
intersection
{
   plane {<0,1,0>,1 rotate <0,0,36>}
   plane {<0,1,0>,1 rotate <0,0,36> rotate <0,72,0>}
   plane {<0,1,0>,1 rotate <0,0,36> rotate <0,2*72,0>}
   plane {<0,1,0>,1 rotate <0,0,36> rotate <0,3*72,0>}
   plane {<0,1,0>,1 rotate <0,0,36> rotate <0,4*72,0>}

   plane {<0,1,0>,1 rotate <0,0,2*36>}
   plane {<0,1,0>,1 rotate <0,0,2*36> rotate <0,72,0>}
   plane {<0,1,0>,1 rotate <0,0,2*36> rotate <0,2*72,0>}
   plane {<0,1,0>,1 rotate <0,0,2*36> rotate <0,3*72,0>}
   plane {<0,1,0>,1 rotate <0,0,2*36> rotate <0,4*72,0>}

   plane {<0,1,0>,1 rotate <0,0,3*36> rotate <0,0+36,0>}
   plane {<0,1,0>,1 rotate <0,0,3*36> rotate <0,72+36,0>}
   plane {<0,1,0>,1 rotate <0,0,3*36> rotate <0,2*72+36,0>}
   plane {<0,1,0>,1 rotate <0,0,3*36> rotate <0,3*72+36,0>}
   plane {<0,1,0>,1 rotate <0,0,3*36> rotate <0,4*72+36,0>}

   plane {<0,1,0>,1 rotate <0,0,4*36> rotate <0,0+36,0>}
   plane {<0,1,0>,1 rotate <0,0,4*36> rotate <0,72+36,0>}
   plane {<0,1,0>,1 rotate <0,0,4*36> rotate <0,2*72+36,0>}
   plane {<0,1,0>,1 rotate <0,0,4*36> rotate <0,3*72+36,0>}
   plane {<0,1,0>,1 rotate <0,0,4*36> rotate <0,4*72+36,0>}   
   
   bounded_by { sphere {<0,0,0>, 1.1}}
   
   scale 1/20
   translate <0,2.45-0.39,-4.24> 
   
}

#declare oPlaneRounded2 =
intersection
{  
   union
   {
      cylinder
      {
         <-4.13-0.095,2.45,-4.13>,<4.13+0.095,2.45,-4.13>,0.095
      }
      box
      {
         <-4.13-0.095,2.45-0.095,-4.13>,<4.13+0.095,2.45+0.095,4.13>
      }
   }
   union
   {
      cylinder
      {                                 
         <-4.13,2.45,-4.13-0.095>,<-4.13,2.45,4.13>,0.095
      }
      box
      {
         <-4.13,2.45-0.095,-4.13-0.095>,<4.13+0.095,2.45+0.18,4.13>
      }
   }  
   union
   {
      cylinder
      {
         <4.13,2.45,-4.13-0.095>,<4.13,2.45,4.13>,0.095
      }
      box
      {
         <-4.13-0.095,2.45-0.095,-4.13-0.095>,<4.13,2.45+0.18,4.13>
      }
   }
   scale <0.99,1.5,1>
   translate <0,-0.6,0>
}

#declare oCylinderBubbles2 =
intersection
{
   union
   {  
      #declare iCounter = -15.5;
      #while (iCounter < 16)
      
         cylinder 
         {
            <0,2.45,0>,<0,2.45,-6>,0.065
            scale <1.8,1,1,>
            translate <iCounter * 0.53/1.5,0,0>
         }                                
         #declare iCounter = iCounter + 1;
      #end
   }
   cylinder
   {
      <-4.13-0.095,2.45,-4.13>,<4.13+0.095,2.45,-4.13>,0.12
   }
   scale <0.99,1.5,1>
   translate <0,-0.6,0>
}

#declare oAllEdelStones2 =
union   
{
   #declare iCounter = -11.5;
   #while (iCounter < 12)
   
      object
      {
         oEdelStone2          
         translate <0,1,0>
         translate <iCounter * 0.526/1.5,0,0>
         texture
         {  
            pigment
            {    
               color rgbf <0.9, 0.1, 0.2, 0.5> 
            }
            finish 
            {
                ambient 0.1
                diffuse 0.1
                reflection .75
                specular 1
                roughness 0.0005
            }              
      
         }
         interior
         {
            ior 1.5
         }
      }
      #declare iCounter = iCounter + 1;
   
      #if (iCounter < 12)
         object
         {
            oEdelStone2
            translate <0,1,0>
            translate <iCounter * 0.526/1.5,0,0>
            texture
            {  
               pigment
               {
                  color rgbf <0.2, 0.9, 0.1, 0.5> 
               }
               finish 
               {
                   ambient 0.1
                   diffuse 0.1
                   reflection .75
                   specular 1
                   roughness 0.0005
               }      
            }
            interior
            {
               ior 1.5
            }
         }
      #end
      #declare iCounter = iCounter + 1;
   #end
}   
                         
#declare oUpperBox =
object
{
   mBoxRounded(8.1,0.3,8.1,0.05)
   translate <0,3.2,0>
}                         
                         
#declare oTroneBottom =
union
{
   object{oBottomBox}
   object{oBottomBoxInside}
   object{oAllFronts}  
   object{oAllFrontCurls} 
   object{oAllBackWithBalls}           
   object{oAllTriBlobs}      
   object{oPlaneRounded}
   object{oCylinderBubbles}    
   object{oAllEdelStones}
   object{oMiddleBox}           
   object{oMiddleBoxInside}    
   object{oAllFlowers texture{tFlower}}
   object{oZijSpalken}
   object{oAllRoosters}
   object{oMiddleBox2}
   object{oMiddleBox3}
   object{oPlaneRounded2}
   object{oCylinderBubbles2}    
   object{oAllEdelStones2}
   object{oUpperBox texture{tTroneBottomUpperBox}}
              
   texture{tTroneBottom}
}