// Persistence of Vision Ray Tracer Scene Description File
// File: arch.inc
// Vers: 3.1g.wmp.0.6a
// Desc: part of irtc worship - arch 75 wide 120 tall 5 deep, front-center base at <0,0,0.001>
// Date: dd/01/01
// Auth: Tom Melly, http://www.tomandlu.co.uk, tom@tomandlu.co.uk
//

#version unofficial MegaPov 0.6;

#declare blue_pearl =
sphere{
  0, 0.6
  scale<1/1.25,1,4>
  pigment{rgb<0.85,0.85,1>}
  finish{Shiny}
}
#declare white_pearl =
sphere{
  0, 1/2
  scale<1/1.25,1,4>
  pigment{rgb<1,1,0.9>}
  finish{Shiny}
}
#declare green_pearl =
sphere{
  0, 1/2
  scale<1/1.25,1,4>
  pigment{rgb<0.85,1,0.85>}
  finish{Shiny}
}

#declare left_base =
union{
  union{ // gold
    difference{ // main part of inner ring
      torus{
        4,1
        rotate x*90
      }
      box{
        <0.1,-6,-2>,<6,6,2>
      }
      box{
        <-1.1,-6,-2>,<6,0,2>
      }
    }
    sphere{ // inner curve of inner ring
      0, 2/1.5
      scale<0.8,1.5,1>
      translate<-1.1,-2.9,0>
    }
    //pearls for outer ring
    #declare Count = 40;
    #while(Count <= 85)
      #if(Count != 85)
        object{white_pearl translate<-6.2 ,0, -1> rotate z*-Count}
      #else
        object{green_pearl translate<-6.2 ,0, -1> rotate z*-Count}
      #end      
      #declare Count = Count + 15;
    #end

    object{blue_pearl translate<-7.7 ,0, -1> rotate z*-45}
    object{white_pearl translate<-7.7 ,0, -1> rotate z*-70}
    object{blue_pearl translate<-7.7 ,0, -1> rotate z*-90}
    
    difference{ // main part of outer ring
      torus{
        6.2,1
        rotate x*90
      }
      box{
        <0.1,-8,-2>,<8,8,2>
      }
      box{
        <-8,-8,-2>,<8,4.25,2>
      }
    }
    difference{ // join of outer ring (*NOTE: needs jewel fill-in)
      sphere{
        0,1
      }
      box{
        <-2,0,-2>,<2,2,2>
      }
      scale<2.5,1,1>
      translate<-5.3,4.5,0>
    }
    texture{T_Gold_4C}
    normal{granite 1/10}
  }
  object{
    blue_pearl
    translate<-1.1,-2.7,-1>
  }
  #declare Count = 20;
  #while(Count <= 180)
    #if(Count != 80)
      object{white_pearl
        translate<0,-4,-1>
        rotate z*-Count
      }
    #else
      object{green_pearl
        translate<0,-4,-1>
        rotate z*-Count
      }
    #end
    #declare Count=Count + 20;
  #end
  object{green_pearl
    translate<0,4,-1>
  }
}

#declare base =
union{
  object{left_base}
  object{left_base scale <-1,1,1.0001>}
  object{blue_pearl translate<-5.1,2.8,0>}
  scale<1.25,1,1/4>
}

//object{base translate z*-90}

#declare full_torque_arch =
  union{
    #declare Count = -90;
    #while(Count <=90)
      object{base translate y*45 rotate z*Count}
      #declare Count = Count + 15;
    #end
    
    #declare Count = 1;
    #while(Count <= 7)
      object{base rotate z*90 translate x*-45 translate y*12*-Count}
      object{base rotate z*-90 translate x*45 translate y*12*-Count}
      #declare Count = Count + 1;
    #end
    translate y*85
  }

#declare Rand1 = seed(785321);

#declare ArchPig =
pigment{
  bozo
  pigment_map{
    #declare n = 0;
    #while(n<=1)
      [n rgb<rand(Rand1)/2, rand(Rand1)/1, rand(Rand1)/1.25>]
      #declare n = n + 0.05;
    #end
  }
}
#declare arch_walls =
union{
  difference{
    box{
      <-200,-250,-0.001>,<200,200,5.01>
    }
    cylinder{z*-5, z*10, 51 translate y*85}
    box{<-51.001,-1,-5>,<51.001,85,15>}
    pigment{Thistle*0.75}
    normal{average normal_map{
      [agate 3 scale 7]
      [granite 1]
      [bozo 2 scale 5]
    }}
    finish{diffuse 0.8}//specular 1/2 roughness 0.005 reflection 0.2}
  }

  difference{
    box{
      <-100,-25,0>,<100,155,5>
    }
    cylinder{z*-5, z*10, 39 translate y*85}
    box{<-39.001,-1,-5>,<39.001,85,15>}
    pigment{ArchPig}
    normal{bozo 2 scale 2}
    finish{Glossy} //finish{reflection 0.3 diffuse 0.4 brilliance 2 specular 0.4 roughness 0.01 metallic 0}
//    finish{reflection 0.1 diffuse 0.5 specular 0.5 roughness 0.001}
  }

  box{
    <-75,-10,6>,<75,145,7>
    FurTex(Med_Purple, 7)
  }
}

#declare golden_archway =
#difference{
  box{
    <-50,-20,0.001>,<50,145,4.999>
  }
  cylinder{z*-5, z*10, 36 translate y*85}
  box{<-36.001,2,-5>,<36.001,85,15>}
  texture{T_Gold_4C}
  normal{granite 1/10}
}

#declare pearl_rim =
union{
  #declare Count = 0;
  #declare P_count = 0;
  #while(Count <= 83)
    #if(P_count != 4)
      #declare this_pearl = white_pearl
      #declare P_count = P_count + 1;
    #else
      #declare this_pearl = green_pearl
      #declare P_count = 0;
    #end
    object{this_pearl scale <1,1,1/4> translate<-37.5, Count,0>}
    object{this_pearl scale <1,1,1/4> translate<37.5, Count,0>}
    #declare Count = Count + 2;
  #end
  
  #declare Count = 0;
  #declare P_count = 0;
  #while(Count <= 180)
    #if(P_count != 4)
      #declare this_pearl = white_pearl
      #declare P_count = P_count + 1;
    #else
      #declare this_pearl = green_pearl
      #declare P_count = 0;
    #end
    object{this_pearl translate<37.5, 0,0> rotate z*Count translate y*85}
    #declare Count = Count + 3;
  #end
}

union{
  object{full_torque_arch}
  object{arch_walls}
  object{golden_archway}
  object{pearl_rim}
  //scale <1.25,1.25,1>
}

