//back-fan
#version unofficial MegaPov 0.6;

//MakePanel(42.5, 72.5, 121.5)
/*
#macro MakeCenterGem(GemTex, ZR)
difference{
  sphere{0,1}
  plane{x, 0 rotate y*-15}  
  plane{-x, 0 rotate y*15}
  texture{GemTex}
  interior{I_Glass}
  rotate x*-90
  rotate z*ZR
}
#end

#declare CenterGems =
union{
  MakeCenterGem(T_Ruby_Glass, 0)
  MakeCenterGem(T_Green_Glass, (360/8)*1)
  MakeCenterGem(T_Ruby_Glass, (360/8)*2)
  MakeCenterGem(T_Green_Glass, (360/8)*3)
  MakeCenterGem(T_Ruby_Glass, (360/8)*4)
  MakeCenterGem(T_Green_Glass, (360/8)*5)
  MakeCenterGem(T_Ruby_Glass, (360/8)*6)
  MakeCenterGem(T_Green_Glass, (360/8)*7)
  scale <1.5,1.5,0.5>
}


object{
  CenterGems
  translate<-22,76,-21>
}
object{//?
  CenterGems
  translate<22,76,-21>
}

object{
  CenterGems
  translate<-33,82,-21>
}
object{
  CenterGems
  translate<33,82,-21>
}

object{
  CenterGems
  translate<-32.5,69.5,-21>
}
object{
  CenterGems
  translate<32.5,69.5,-21>
}
*/

#declare FScale = 10;

#declare BaseFur = FurTex(rgb<147/255,68/255,129/255>*1.5, FScale)
#declare InnerFur = FurTex(rgb<96/255,122/255,137/255>, FScale)

#declare MandelTex =
texture{
  mandel 100
  texture_map{
    [0.05 pigment{rgbf 1}]
    [0.05 T_Gold_4C]
    [0.15 T_Gold_4C]
    [0.15 InnerFur]
  }
}

#declare MandTex1 =
texture{
  MandelTex
  scale <8,5,4>
  rotate z*-90
  translate <5, 25, 0>
}

#declare MandTex2 =
texture{
  MandelTex
  scale <6,4,4>
  rotate z*14
  translate <-1.5, 17, 0>
}

#declare MandTex3 =
texture{
  MandelTex
  scale <4,4,4>
  rotate z*150
  translate <9, 15, 0>
}

#macro MakePanel(SphereA, SphereB, SphereC)
  #declare Panel =
  intersection{
    difference{
      box{<-25,0,0>,<25,60,1>}
      sphere{0, SphereA translate<-40,50,1/2>}
    }
    sphere{0,SphereB translate<10,80,1/2>}
    sphere{0,SphereC translate<-100,-15,1/2>}
  }
#end  


MakePanel(40.0, 75.0, 125.0)
#declare PA = Panel
MakePanel(40.5, 74.5, 124.5)
#declare PB = Panel
MakePanel(42.0, 73.0, 122.0)
#declare PC = Panel
MakePanel(42.5, 72.5, 121.5)
#declare PD = Panel

#declare FullPanel =
union{
  object{
    PA
    translate<0,0,-0.000>
    texture{T_Gold_4C}
    normal{granite 1/10}
  }
  object{
    PB
    translate<0,0,-0.001>
    FurTex(rgb<96/255,122/255,137/255>, 5)
  }
  object{
    PC
    translate<0,0,-0.002>
    texture{T_Gold_4C}
    normal{granite 1/10}
  }
  object{
    PD
    translate<0,0,-0.003>
    texture{BaseFur}
  }
  object{
    PD
    translate<0,0,-0.0031>
    texture{MandTex1}
  }
  object{
    PD
    translate<0,0,-0.0032>
    texture{MandTex2}
  }
  object{
    PD
    translate<0,0,-0.0033>
    texture{MandTex3}
  }

  translate y*-50
  translate z*-10
}

union{
  object{FullPanel rotate z*-80}
  object{FullPanel rotate z*-80 scale<-1,1,1>}
  translate y*85
  translate z*-10
}

#declare Rand1 = seed(1721);

#declare OuterPig =
pigment{
  bozo
  pigment_map{
    #declare n = 0;
    #while(n<=1)
      [n rgb<rand(Rand1)/1.5, rand(Rand1)/2, rand(Rand1)/1.5>]
      #declare n = n + 0.05;
    #end
  }
}

//#declare foobar =
union{
  cylinder{
    z*0, z*0.1, 25
    texture{T_Gold_4C}
    normal{granite 1/10}
    translate z*0
  }
  cylinder{
    z*0, z*0.1, 24.5
    pigment{OuterPig}
    normal{bozo 2 scale 2}
    finish{Glossy} //finish{reflection 0.3 diffuse 0.4 brilliance 2 specular 0.4 roughness 0.01 metallic 0}
    translate z*-0.001
  }
  cylinder{
    z*0, z*0.1, 18
    texture{T_Gold_4C}
    normal{granite 1/10}
    translate z*-0.002
  }
  sphere{
    0, 17.5
    scale<1,1,0.2>
    FurTex(color <71/255, 93/255, 117/255>, 2)
    translate z*-0.002
  }
  translate y*105
  translate z*-7.5
}

#declare blue_pearl =
sphere{
  0, 0.6
  pigment{rgb<0.85,0.85,1>}
  finish{Shiny}
}
#declare white_pearl =
sphere{
  0, 1/2
  pigment{rgb<1,1,0.9>}
  finish{Shiny}
}
#declare green_pearl =
sphere{
  0, 1/2
  pigment{rgb<0.85,1,0.85>}
  finish{Shiny}
}

#declare n = 1;
#while(n<360)
  object{
    white_pearl
    translate x*23.5
    rotate z*n
    translate y*105
    translate z*-7.25
  }
  object{
    white_pearl
    translate x*19
    rotate z*n
    translate y*105
    translate z*-7.25
  }

  #declare n = n + 5;
#end 

#declare GreenGem = true;
#declare n = 1;
#while(n<360)

  cylinder{
    z*1, z*-0.01, 1
    texture{T_Gold_4C}
    normal{granite 1/10}
    translate x*21.25
    rotate z*n
    translate y*105
    translate z*-7.75
  }

  #if(GreenGem)
    sphere{
      0,2/3 texture{T_Green_Glass} interior{I_Glass}
      translate x*21.25
      rotate z*n
      translate y*105
      translate z*-7.75
    }
    #declare GreenGem = false;
  #else
    sphere{
      0,3/4 texture{T_Ruby_Glass} interior{I_Glass}
      translate x*21.25
      rotate z*n
      translate y*105
      translate z*-7.5
    }
    #declare GreenGem = true;
  #end
  #declare n = n + 10;
#end