//  Persistance of Vision Raytracer V3.1
//  World definition file.
//
//  Contains 2 lights, 18 materials and 290 primitives.
//
//  This file was generated for POV-Ray V3.1 by
//  Moray V3.1 For Windows (c) 1991-1998 Lutz + Kretzschmar
//

//  Date : 02/21/2001    (21.02.2001)
//

/*
  The text between these two comments is in MorayPOV.INC and is
  automatically included in all POV files that Moray exports.
*/

default {
  texture {
    pigment { rgb <1,0,0> }
  }
}

/* // Scene Comment

This scene was created with Moray V3.1 For Windows specifically for the January-Feburary 2001 International Ray-Tracing Competition.  2/21/2001.

*/ // End Scene Comment

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.000,0.000,0.000> }

fog {
  fog_type 2    // Ground Fog
  distance     750.0
  color <0.447059,0.447059,0.447059,0.0,0.0>
  up           <0,0,1>
  fog_offset   0.0
  fog_alt      15.0
}

camera {  //  Camera StdCam
  location  <    -11.544,     -42.082,       2.949>
  direction <        0.0,         0.0,      1.0360> // Aperture is 0.90 degrees
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.33333,         0.0,         0.0> // Aspect ratio
  look_at   <      0.006,      -0.277,      13.529>
}

//
// *******  L I G H T S *******
//

light_source { // Arealight001
  <4.409, -29.541, 16.756>
  color rgb <0.100, 0.100, 0.100>*0.6000
  area_light <49.909, 6.173, -0.259>, <-0.633, 6.263, 27.371>, 3, 3
  adaptive 1
  jitter
  media_interaction off
}


light_source {   // Lamplight
  <-5.113, -19.373, 17.556>
  color rgb <0.100, 0.100, 0.100>*0.7500
  media_attenuation on
}

light_source {   // Light2
  <0.000, 0.000, 8.801>
  color rgb <1.000, 1.000, 1.000>*0.7500
  fade_distance  10.0
  fade_power 1.0
  media_attenuation on
}

light_source {   // Lamplight1
  <-14.115, -14.221, 17.556>
  color rgb <0.100, 0.100, 0.100>*0.7500
  media_attenuation on
}

light_source {   // Lamplight2
  <-19.334, -5.258, 17.556>
  color rgb <0.100, 0.100, 0.100>*0.7500
  media_attenuation on
}

light_source {   // Lamplight3
  <-19.373, 5.113, 17.556>
  color rgb <0.100, 0.100, 0.100>*0.7500
}

light_source {   // Lamplight4
  <-14.221, 14.115, 17.556>
  color rgb <0.100, 0.100, 0.100>*0.7500
}

light_source {   // Lamplight5
  <-5.258, 19.334, 17.556>
  color rgb <0.100, 0.100, 0.100>*0.7500
}

light_source {   // Lamplight6
  <5.113, 19.373, 17.556>
  color rgb <0.100, 0.100, 0.100>*0.7500
}

light_source {   // Lamplight7
  <14.115, 14.221, 17.556>
  color rgb <0.100, 0.100, 0.100>*0.7500
}

light_source {   // Lamplight8
  <19.334, 5.258, 17.556>
  color rgb <0.100, 0.100, 0.100>*0.7500
}

light_source {   // Lamplight9
  <19.373, -5.113, 17.556>
  color rgb <0.100, 0.100, 0.100>*0.7500
}

light_source {   // Lamplight10
  <14.221, -14.115, 17.556>
  color rgb <0.100, 0.100, 0.100>*0.7500
}

light_source {   // Lamplight11
  <5.258, -19.334, 17.556>
  color rgb <0.100, 0.100, 0.100>*0.7500
}


//
// ********  MATERIALS  *******
//

#include "webtmplx.inc"


//
// ********  REFERENCED OBJECTS  *******
//

//
// Include file contains 'Tree16'
//
#include "webtmplx.in1"
#declare Tree16 = object {
  Tree16_Raw
  material {
    Plantmat
  }
  hollow
  scale <2.918758, 3.723187, 7.695704>
  translate  <-36.017323, 37.12339, 8.192086>
}


#declare Columngroove = union {
  sphere { // Sphere002
    <0,0,0>,1
    scale 0.2
    translate  <0.0, 0.0, 14.0>
  }
  sphere { // Sphere015
    <0,0,0>,1
    scale 0.2
  }
  cylinder { // Cylndr002
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 14.0>
  }
  translate  <0.0, -1.0, 1.0>
}
#declare Columnshaft = difference {
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 16.0>
  }
  object { // Columngroove11->Columngroove
    Columngroove
    rotate 30.0*z
    translate  <-0.0, 0.0, 0.0>
  }
  object { // Columngroove10->Columngroove
    Columngroove
    rotate 60.0*z
    translate  <-0.0, 0.0, 0.0>
  }
  object { // Columngroove9->Columngroove
    Columngroove
    rotate 90.0*z
    translate  <-0.0, -0.0, 0.0>
  }
  object { // Columngroove8->Columngroove
    Columngroove
    rotate 120.0*z
    translate  <-0.0, -0.0, 0.0>
  }
  object { // Columngroove7->Columngroove
    Columngroove
    rotate 150.0*z
    translate  <-0.0, -0.0, 0.0>
  }
  object { // Columngroove6->Columngroove
    Columngroove
    rotate -180.0*z
    translate  <0.0, -0.0, 0.0>
  }
  object { // Columngroove5->Columngroove
    Columngroove
    rotate -150.0*z
    translate  -0.0*y
  }
  object { // Columngroove4->Columngroove
    Columngroove
    rotate -120.0*z
  }
  object { // Columngroove3->Columngroove
    Columngroove
    rotate -90.0*z
    translate  0.0*y
  }
  object { // Columngroove2->Columngroove
    Columngroove
    rotate -60.0*z
  }
  object { // Columngroove1->Columngroove
    Columngroove
    rotate -30.0*z
  }
  object { Columngroove }
}
#declare Column = union {
  object { Columnshaft }
  box { // Cube001
    <-1, -1, -1>, <1, 1, 1>
    scale <1.5, 1.5, 0.25>
    translate  -0.6*z
  }
  torus { // Torus001
    1.5, 0.5  rotate -x*90
    scale 0.680633
    translate  <-0.017743, 0.0, 0.017743>
  }
  torus { // Torus002
    3.75, 0.5  rotate -x*90
    scale 0.272552
    translate  <0.0, 0.0, 0.479051>
  }
  torus { // Torus003
    1.5, 0.5  rotate -x*90
    scale 0.680633
    translate  16.0*z
  }
  torus { // Torus004
    3.75, 0.5  rotate -x*90
    scale 0.272552
    translate  15.5*z
  }
  box { // Cube002
    <-1, -1, -1>, <1, 1, 1>
    scale <1.5, 1.5, 0.25>
    translate  16.6*z
  }
  translate  <-0.093499, -19.975474, 1.071206>
}
#declare archring3 = difference {
  cylinder { // Cylndr009
    <0,0,1>, <0,0,0>, 1 
    scale <21.0, 21.0, 6.5>
    translate  17.770244*z
  }
  cylinder { // Cylndr010
    <0,0,1>, <0,0,0>, 1 
    hollow
    scale <19.299999, 19.299999, 7.0>
    translate  17.576515*z
  }
  translate  -0.226605*z
}
#declare archoutside3 = intersection {
  object { archring3 }
  cone { // Cone031
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <6.176085, 6.025559, 22.550632>
    rotate <106.588112, -0.024392, 15.017459>
    translate  <0.005994, -0.003178, 22.968696>
  }
  translate  <-0.114403, -0.064576, 0.562239>
}
#declare Arch4 = difference {
  object { archoutside3 }
  cone { // Cone032
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <5.326588, 5.760117, 22.43433>
    rotate <104.67189, 0.0, 15.0>
    translate  <-0.105643, -0.064683, 22.311615>
  }
  translate  <0.006525, 0.000501, -0.19437>
}
#declare archring4 = difference {
  cylinder { // Cylndr011
    <0,0,1>, <0,0,0>, 1 
    scale <20.700001, 20.700001, 6.5>
    translate  17.770244*z
  }
  cylinder { // Cylndr012
    <0,0,1>, <0,0,0>, 1 
    hollow
    scale <19.5, 19.5, 7.0>
    translate  17.576515*z
  }
  translate  -0.226605*z
}
#declare archoutside4 = intersection {
  object { archring4 }
  cone { // Cone033
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <6.008018, 5.503125, 22.65497>
    rotate <105.726601, 0.137271, 14.280789>
    translate  <0.10528, 0.066145, 22.919166>
  }
  translate  <-0.114403, -0.064576, 0.562239>
}
#declare Arch5 = difference {
  object { archoutside4 }
  cone { // Cone034
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <4.768627, 5.08677, 22.561451>
    rotate <104.999023, 0.151044, 14.260401>
    translate  <-0.013756, 0.005333, 22.311615>
  }
  rotate 0.745157*z
  translate  <-0.09, -0.06966, -0.19437>
}
#declare archring5 = difference {
  cylinder { // Cylndr013
    <0,0,1>, <0,0,0>, 1 
    scale <20.4, 20.4, 6.5>
    translate  17.770244*z
  }
  cylinder { // Cylndr014
    <0,0,1>, <0,0,0>, 1 
    hollow
    scale <19.700001, 19.700001, 7.0>
    translate  17.576515*z
  }
  translate  -0.226605*z
}
#declare archoutside5 = intersection {
  object { archring5 }
  cone { // Cone035
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <5.44, 5.44, 22.762829>
    rotate <104.57148, 0.201716, 13.93832>
    translate  <0.163211, 0.065312, 22.523035>
  }
  translate  <-0.114403, -0.064576, 0.562239>
}
#declare Arch6 = difference {
  object { archoutside5 }
  cone { // Cone036
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <4.286448, 4.584971, 22.726597>
    rotate <105.157211, 0.175718, 14.166779>
    translate  <-0.013756, 0.012991, 22.311615>
  }
  rotate 0.745157*z
  translate  <-0.09, -0.06966, -0.19437>
}
#declare Arch = union {
  object { Arch4 }
  object { Arch5 }
  object { Arch6 }
  material {
    ArchTexture
  }
  translate  <0.027784, 0.190017, 0.0>
}
#declare ColumnArch = union {
  object { Column }
  object { Arch }
}




//
// ********  OBJECTS  *******
//

union { // Trees
  object { Tree16 }
  object { // Tree17->Tree16
    Tree16
    rotate <0.0, -0.0, -0.0>
    translate  <6.993593, 5.690355, 0.0>
  }
  object { // Tree18->Tree16
    Tree16
    rotate <0.0, -0.0, -0.0>
    translate  <14.869058, 10.079836, 0.0>
  }
  object { // Tree19->Tree16
    Tree16
    rotate <0.0, -0.0, -0.0>
    translate  <23.387101, 13.035071, 0.0>
  }
  object { // Tree20->Tree16
    Tree16
    rotate <0.0, -0.0, -0.0>
    translate  <32.288908, 14.466266, 0.0>
  }
  object { // Tree21->Tree16
    Tree16
    rotate <0.0, -0.0, -0.0>
    translate  <41.304001, 14.329936, 0.0>
  }
  object { // Tree22->Tree16
    Tree16
    rotate <0.0, -0.0, -0.0>
    translate  <50.158461, 12.630222, 0.0>
  }
  object { // Tree23->Tree16
    Tree16
    rotate <0.0, -0.0, -0.0>
    translate  <58.583249, 9.41877, 0.0>
  }
  object { // Tree24->Tree16
    Tree16
    rotate <0.0, -0.0, -0.0>
    translate  <66.322383, 4.793158, 0.0>
  }
  object { // Tree25->Tree16
    Tree16
    rotate <0.0, -0.0, -0.0>
    translate  <73.140713, -1.106067, 0.0>
  }
  object { // Tree26->Tree16
    Tree16
    rotate <0.0, -0.0, -0.0>
    translate  <78.831068, -8.09966, 0.0>
  }
  object { // Tree27->Tree16
    Tree16
    rotate <0.0, -0.0, -0.0>
    translate  <83.220549, -15.975124, 0.0>
  }
  object { // Tree28->Tree16
    Tree16
    rotate <0.0, -0.0, -0.0>
    translate  <86.175784, -24.493168, 0.0>
  }
}




sphere { // Sky
  <0,0,0>,1
  material {
    Night_Sky
  }
  hollow
  scale 2258.380371
  rotate -180.0*z
}


plane { // Grassland
  z,0
  material {
    Grasstext
  }
  translate  <-0.135418, -0.040463, -2.533389>
}


object {   // Mountains_Htfld
  height_field {
    gif "C:\Program Files\POV-Ray for Windows v3.1\include\Fract010.gif"
    water_level 0.001
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  material {
    Landtext
  }
  scale <987.947815, 1012.439575, 300.0>
  rotate -43.038334*z
  translate  <143.845307, 1240.126413, 43.124472>
}


#declare BezPtch005 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -8.065095, 2.741868>, <-0.165642, -8.065095, 2.741868>, <0.000000, -8.065095, 2.741868>, <0.165642, -8.065095, 2.741868>, 
      <-0.333985, -7.937644, 0.088447>, <-0.168343, -7.937644, 0.088447>, <-0.002700, -7.937644, 0.088447>, <0.162942, -7.937644, 0.088447>, 
      <-0.331285, -6.154882, 0.353789>, <-0.165642, -6.154882, 0.353789>, <0.000000, -6.154882, 0.353789>, <0.165642, -6.154882, 0.353789>, 
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>, 
      <-0.331285, -3.705948, 0.353789>, <-0.165642, -3.705948, 0.353789>, <0.000000, -3.705948, 0.353789>, <0.165642, -3.705948, 0.353789>, 
      <-0.331285, -4.052750, 3.184105>, <-0.165642, -4.052750, 3.184105>, <0.000000, -4.052750, 3.184105>, <0.165642, -4.052750, 3.184105>, 
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>, 
      <-0.331285, 1.269360, 3.537894>, <-0.165642, 1.269360, 3.537894>, <0.000000, 1.269360, 3.537894>, <0.165642, 1.269360, 3.537894>, 
      <-0.331285, 1.461279, 0.000000>, <-0.165642, 1.461279, 0.000000>, <0.000000, 1.461279, 0.000000>, <0.165642, 1.461279, 0.000000>, 
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>, 
      <-0.331285, 3.820426, -0.088447>, <-0.165642, 3.820426, -0.088447>, <0.000000, 3.820426, -0.088447>, <0.165642, 3.820426, -0.088447>, 
      <-0.331285, 5.000000, 0.088447>, <-0.165642, 5.000000, 0.088447>, <0.000000, 5.000000, 0.088447>, <0.165642, 5.000000, 0.088447>, 
      <-0.331285, 5.012346, 1.857395>, <-0.165642, 5.012346, 1.857395>, <0.000000, 5.012346, 1.857395>, <0.165642, 5.012346, 1.857395>
    }
  }
  rotate <91.002113, 0.0, 180.0>
  translate  <34.972278, -43.612587, 10.817071>
}
#declare BezPtch007 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -8.065095, 2.741868>, <-0.165642, -8.065095, 2.741868>, <0.000000, -8.065095, 2.741868>, <0.165642, -8.065095, 2.741868>, 
      <-0.333985, -7.937644, 0.088447>, <-0.168343, -7.937644, 0.088447>, <-0.002700, -7.937644, 0.088447>, <0.162942, -7.937644, 0.088447>, 
      <-0.331285, -6.154882, 0.353789>, <-0.165642, -6.154882, 0.353789>, <0.000000, -6.154882, 0.353789>, <0.165642, -6.154882, 0.353789>, 
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>, 
      <-0.331285, -3.705948, 0.353789>, <-0.165642, -3.705948, 0.353789>, <0.000000, -3.705948, 0.353789>, <0.165642, -3.705948, 0.353789>, 
      <-0.331285, -4.052750, 3.184105>, <-0.165642, -4.052750, 3.184105>, <0.000000, -4.052750, 3.184105>, <0.165642, -4.052750, 3.184105>, 
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>, 
      <-0.331285, 1.269360, 3.537894>, <-0.165642, 1.269360, 3.537894>, <0.000000, 1.269360, 3.537894>, <0.165642, 1.269360, 3.537894>, 
      <-0.331285, 1.461279, 0.000000>, <-0.165642, 1.461279, 0.000000>, <0.000000, 1.461279, 0.000000>, <0.165642, 1.461279, 0.000000>, 
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>, 
      <-0.331285, 3.820426, -0.088447>, <-0.165642, 3.820426, -0.088447>, <0.000000, 3.820426, -0.088447>, <0.165642, 3.820426, -0.088447>, 
      <-0.331285, 5.000000, 0.088447>, <-0.165642, 5.000000, 0.088447>, <0.000000, 5.000000, 0.088447>, <0.165642, 5.000000, 0.088447>, 
      <-0.331285, 5.012346, 1.857395>, <-0.165642, 5.012346, 1.857395>, <0.000000, 5.012346, 1.857395>, <0.165642, 5.012346, 1.857395>
    }
  }
  rotate <91.002113, 0.0, 90.0>
  translate  <36.710571, -44.916306, 10.817071>
}
#declare BezPtch008 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -8.065095, 2.741868>, <-0.165642, -8.065095, 2.741868>, <0.000000, -8.065095, 2.741868>, <0.165642, -8.065095, 2.741868>, 
      <-0.333985, -7.937644, 0.088447>, <-0.168343, -7.937644, 0.088447>, <-0.002700, -7.937644, 0.088447>, <0.162942, -7.937644, 0.088447>, 
      <-0.331285, -6.154882, 0.353789>, <-0.165642, -6.154882, 0.353789>, <0.000000, -6.154882, 0.353789>, <0.165642, -6.154882, 0.353789>, 
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>, 
      <-0.331285, -3.705948, 0.353789>, <-0.165642, -3.705948, 0.353789>, <0.000000, -3.705948, 0.353789>, <0.165642, -3.705948, 0.353789>, 
      <-0.331285, -4.052750, 3.184105>, <-0.165642, -4.052750, 3.184105>, <0.000000, -4.052750, 3.184105>, <0.165642, -4.052750, 3.184105>, 
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>, 
      <-0.331285, 1.269360, 3.537894>, <-0.165642, 1.269360, 3.537894>, <0.000000, 1.269360, 3.537894>, <0.165642, 1.269360, 3.537894>, 
      <-0.331285, 1.461279, 0.000000>, <-0.165642, 1.461279, 0.000000>, <0.000000, 1.461279, 0.000000>, <0.165642, 1.461279, 0.000000>, 
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>, 
      <-0.331285, 3.820426, -0.088447>, <-0.165642, 3.820426, -0.088447>, <0.000000, 3.820426, -0.088447>, <0.165642, 3.820426, -0.088447>, 
      <-0.331285, 5.000000, 0.088447>, <-0.165642, 5.000000, 0.088447>, <0.000000, 5.000000, 0.088447>, <0.165642, 5.000000, 0.088447>, 
      <-0.331285, 5.012346, 1.857395>, <-0.165642, 5.012346, 1.857395>, <0.000000, 5.012346, 1.857395>, <0.165642, 5.012346, 1.857395>
    }
  }
  rotate <91.002113, 0.0, 45.0>
  translate  <36.362912, -46.133111, 10.817071>
}
#declare BezPtch006 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -8.065095, 2.741868>, <-0.165642, -8.065095, 2.741868>, <0.000000, -8.065095, 2.741868>, <0.165642, -8.065095, 2.741868>, 
      <-0.333985, -7.937644, 0.088447>, <-0.168343, -7.937644, 0.088447>, <-0.002700, -7.937644, 0.088447>, <0.162942, -7.937644, 0.088447>, 
      <-0.331285, -6.154882, 0.353789>, <-0.165642, -6.154882, 0.353789>, <0.000000, -6.154882, 0.353789>, <0.165642, -6.154882, 0.353789>, 
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>, 
      <-0.331285, -3.705948, 0.353789>, <-0.165642, -3.705948, 0.353789>, <0.000000, -3.705948, 0.353789>, <0.165642, -3.705948, 0.353789>, 
      <-0.331285, -4.052750, 3.184105>, <-0.165642, -4.052750, 3.184105>, <0.000000, -4.052750, 3.184105>, <0.165642, -4.052750, 3.184105>, 
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>, 
      <-0.331285, 1.269360, 3.537894>, <-0.165642, 1.269360, 3.537894>, <0.000000, 1.269360, 3.537894>, <0.165642, 1.269360, 3.537894>, 
      <-0.331285, 1.461279, 0.000000>, <-0.165642, 1.461279, 0.000000>, <0.000000, 1.461279, 0.000000>, <0.165642, 1.461279, 0.000000>, 
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>, 
      <-0.331285, 3.820426, -0.088447>, <-0.165642, 3.820426, -0.088447>, <0.000000, 3.820426, -0.088447>, <0.165642, 3.820426, -0.088447>, 
      <-0.331285, 5.000000, 0.088447>, <-0.165642, 5.000000, 0.088447>, <0.000000, 5.000000, 0.088447>, <0.165642, 5.000000, 0.088447>, 
      <-0.331285, 5.012346, 1.857395>, <-0.165642, 5.012346, 1.857395>, <0.000000, 5.012346, 1.857395>, <0.165642, 5.012346, 1.857395>
    }
  }
  rotate <91.002113, 0.0, 135.0>
  translate  <36.189083, -44.134074, 10.817071>
}
#declare BezPtch004 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -8.065095, 2.741868>, <-0.165642, -8.065095, 2.741868>, <0.000000, -8.065095, 2.741868>, <0.165642, -8.065095, 2.741868>, 
      <-0.333985, -7.937644, 0.088447>, <-0.168343, -7.937644, 0.088447>, <-0.002700, -7.937644, 0.088447>, <0.162942, -7.937644, 0.088447>, 
      <-0.331285, -6.154882, 0.353789>, <-0.165642, -6.154882, 0.353789>, <0.000000, -6.154882, 0.353789>, <0.165642, -6.154882, 0.353789>, 
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>, 
      <-0.331285, -3.705948, 0.353789>, <-0.165642, -3.705948, 0.353789>, <0.000000, -3.705948, 0.353789>, <0.165642, -3.705948, 0.353789>, 
      <-0.331285, -4.052750, 3.184105>, <-0.165642, -4.052750, 3.184105>, <0.000000, -4.052750, 3.184105>, <0.165642, -4.052750, 3.184105>, 
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>, 
      <-0.331285, 1.269360, 3.537894>, <-0.165642, 1.269360, 3.537894>, <0.000000, 1.269360, 3.537894>, <0.165642, 1.269360, 3.537894>, 
      <-0.331285, 1.461279, 0.000000>, <-0.165642, 1.461279, 0.000000>, <0.000000, 1.461279, 0.000000>, <0.165642, 1.461279, 0.000000>, 
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>, 
      <-0.331285, 3.820426, -0.088447>, <-0.165642, 3.820426, -0.088447>, <0.000000, 3.820426, -0.088447>, <0.165642, 3.820426, -0.088447>, 
      <-0.331285, 5.000000, 0.088447>, <-0.165642, 5.000000, 0.088447>, <0.000000, 5.000000, 0.088447>, <0.165642, 5.000000, 0.088447>, 
      <-0.331285, 5.012346, 1.857395>, <-0.165642, 5.012346, 1.857395>, <0.000000, 5.012346, 1.857395>, <0.165642, 5.012346, 1.857395>
    }
  }
  rotate <91.002113, 0.0, -135.0>
  translate  <34.016217, -44.481733, 10.817071>
}
#declare BezPtch003 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -8.065095, 2.741868>, <-0.165642, -8.065095, 2.741868>, <0.000000, -8.065095, 2.741868>, <0.165642, -8.065095, 2.741868>, 
      <-0.333985, -7.937644, 0.088447>, <-0.168343, -7.937644, 0.088447>, <-0.002700, -7.937644, 0.088447>, <0.162942, -7.937644, 0.088447>, 
      <-0.331285, -6.154882, 0.353789>, <-0.165642, -6.154882, 0.353789>, <0.000000, -6.154882, 0.353789>, <0.165642, -6.154882, 0.353789>, 
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>, 
      <-0.331285, -3.705948, 0.353789>, <-0.165642, -3.705948, 0.353789>, <0.000000, -3.705948, 0.353789>, <0.165642, -3.705948, 0.353789>, 
      <-0.331285, -4.052750, 3.184105>, <-0.165642, -4.052750, 3.184105>, <0.000000, -4.052750, 3.184105>, <0.165642, -4.052750, 3.184105>, 
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>, 
      <-0.331285, 1.269360, 3.537894>, <-0.165642, 1.269360, 3.537894>, <0.000000, 1.269360, 3.537894>, <0.165642, 1.269360, 3.537894>, 
      <-0.331285, 1.461279, 0.000000>, <-0.165642, 1.461279, 0.000000>, <0.000000, 1.461279, 0.000000>, <0.165642, 1.461279, 0.000000>, 
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>, 
      <-0.331285, 3.820426, -0.088447>, <-0.165642, 3.820426, -0.088447>, <0.000000, 3.820426, -0.088447>, <0.165642, 3.820426, -0.088447>, 
      <-0.331285, 5.000000, 0.088447>, <-0.165642, 5.000000, 0.088447>, <0.000000, 5.000000, 0.088447>, <0.165642, 5.000000, 0.088447>, 
      <-0.331285, 5.012346, 1.857395>, <-0.165642, 5.012346, 1.857395>, <0.000000, 5.012346, 1.857395>, <0.165642, 5.012346, 1.857395>
    }
  }
  rotate <91.002113, 0.0, -90.0>
  translate  <33.407814, -45.17705, 10.817071>
}
#declare BezPtch002 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -8.065095, 2.741868>, <-0.165642, -8.065095, 2.741868>, <0.000000, -8.065095, 2.741868>, <0.165642, -8.065095, 2.741868>, 
      <-0.333985, -7.937644, 0.088447>, <-0.168343, -7.937644, 0.088447>, <-0.002700, -7.937644, 0.088447>, <0.162942, -7.937644, 0.088447>, 
      <-0.331285, -6.154882, 0.353789>, <-0.165642, -6.154882, 0.353789>, <0.000000, -6.154882, 0.353789>, <0.165642, -6.154882, 0.353789>, 
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>, 
      <-0.331285, -3.705948, 0.353789>, <-0.165642, -3.705948, 0.353789>, <0.000000, -3.705948, 0.353789>, <0.165642, -3.705948, 0.353789>, 
      <-0.331285, -4.052750, 3.184105>, <-0.165642, -4.052750, 3.184105>, <0.000000, -4.052750, 3.184105>, <0.165642, -4.052750, 3.184105>, 
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>, 
      <-0.331285, 1.269360, 3.537894>, <-0.165642, 1.269360, 3.537894>, <0.000000, 1.269360, 3.537894>, <0.165642, 1.269360, 3.537894>, 
      <-0.331285, 1.461279, 0.000000>, <-0.165642, 1.461279, 0.000000>, <0.000000, 1.461279, 0.000000>, <0.165642, 1.461279, 0.000000>, 
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>, 
      <-0.331285, 3.820426, -0.088447>, <-0.165642, 3.820426, -0.088447>, <0.000000, 3.820426, -0.088447>, <0.165642, 3.820426, -0.088447>, 
      <-0.331285, 5.000000, 0.088447>, <-0.165642, 5.000000, 0.088447>, <0.000000, 5.000000, 0.088447>, <0.165642, 5.000000, 0.088447>, 
      <-0.331285, 5.012346, 1.857395>, <-0.165642, 5.012346, 1.857395>, <0.000000, 5.012346, 1.857395>, <0.165642, 5.012346, 1.857395>
    }
  }
  rotate <91.002113, 0.0, -45.0>
  translate  <34.016217, -46.046196, 10.817071>
}
#declare BezPtch001 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -8.065095, 2.741868>, <-0.165642, -8.065095, 2.741868>, <0.000000, -8.065095, 2.741868>, <0.165642, -8.065095, 2.741868>, 
      <-0.333985, -7.937644, 0.088447>, <-0.168343, -7.937644, 0.088447>, <-0.002700, -7.937644, 0.088447>, <0.162942, -7.937644, 0.088447>, 
      <-0.331285, -6.154882, 0.353789>, <-0.165642, -6.154882, 0.353789>, <0.000000, -6.154882, 0.353789>, <0.165642, -6.154882, 0.353789>, 
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>, 
      <-0.331285, -3.705948, 0.353789>, <-0.165642, -3.705948, 0.353789>, <0.000000, -3.705948, 0.353789>, <0.165642, -3.705948, 0.353789>, 
      <-0.331285, -4.052750, 3.184105>, <-0.165642, -4.052750, 3.184105>, <0.000000, -4.052750, 3.184105>, <0.165642, -4.052750, 3.184105>, 
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>, 
      <-0.331285, 1.269360, 3.537894>, <-0.165642, 1.269360, 3.537894>, <0.000000, 1.269360, 3.537894>, <0.165642, 1.269360, 3.537894>, 
      <-0.331285, 1.461279, 0.000000>, <-0.165642, 1.461279, 0.000000>, <0.000000, 1.461279, 0.000000>, <0.165642, 1.461279, 0.000000>, 
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>, 
      <-0.331285, 3.820426, -0.088447>, <-0.165642, 3.820426, -0.088447>, <0.000000, 3.820426, -0.088447>, <0.165642, 3.820426, -0.088447>, 
      <-0.331285, 5.000000, 0.088447>, <-0.165642, 5.000000, 0.088447>, <0.000000, 5.000000, 0.088447>, <0.165642, 5.000000, 0.088447>, 
      <-0.331285, 5.012346, 1.857395>, <-0.165642, 5.012346, 1.857395>, <0.000000, 5.012346, 1.857395>, <0.165642, 5.012346, 1.857395>
    }
  }
  rotate <91.002113, 0.0, 0.0>
  translate  <35.233022, -46.567684, 10.817071>
}
#declare lamp = union {
  sphere { // Sphere004
    <0,0,0>,1
    material {
      Glass
    }
    hollow
    scale <5.0, 5.0, 3.261394>
    translate  <35.095907, -45.140268, 9.51724>
  }
  object { BezPtch005 }
  object { BezPtch007 }
  object { BezPtch008 }
  object { BezPtch006 }
  object { BezPtch004 }
  object { BezPtch003 }
  object { BezPtch002 }
  object { BezPtch001 }
  cone { // Cone001
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale 1.716519
    rotate <180.0, 0.0, 180.0>
    translate  <35.128593, -45.169069, 16.365649>
  }
  torus { // Torus035
    1.75, 0.25  rotate -x*90
    scale 1.091333
    rotate 0.0*x
    translate  <35.06776, -45.169069, 13.234877>
  }
  cylinder { // Cylndr160
    <0,0,1>, <0,0,0>, 1 
    scale 2.064656
    rotate 0.0*x
    translate  <35.268193, -45.169069, 4.005444>
  }
  torus { // Torus036
    1.75, 0.25  rotate -x*90
    scale 1.091333
    rotate 0.0*x
    translate  <35.128593, -45.169069, 14.2082>
  }
  cylinder { // Cylndr161
    <0,0,1>, <0,0,0>, 1 
    scale <0.333333, 0.333333, 20.0>
    rotate <180.0, -0.0, -180.0>
    translate  <35.009483, -44.966081, 35.268835>
  }
  cone { // Cone002
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale 2.465107
    rotate 0.0*y
    translate  <35.009391, -44.976931, 28.187788>
  }
  sphere { // Sphere017
    <0,0,0>,1
    material {
      lampwhite
    }
    no_shadow
    scale 0.734142
    rotate <-0.0, 0.0, -30.0>
    translate  <35.041314, -45.284038, 9.456169>
  }
  material {
    ironblack
  }
  scale 0.15
  translate  <-10.375813, -12.578051, 16.133418>
}
// Include contains 'TransSweep001'
#include "webtmplx.in2"

#declare TransSweep001 = object {
  TransSweep001_Raw
  scale <3.292601, 3.588416, 15.016603>
  rotate 73.36895*z
  translate  -3.425675*z
}
#declare altar = difference {
  object { TransSweep001 }
  box { // Cube025
    <-1, -1, -1>, <1, 1, 1>
    scale <6.01033, 1.224556, 1.614136>
    rotate -16.800516*z
    translate  <-1.361903, -3.561134, 3.69175>
  }
  material {
    ColumnTexture
  }
  rotate 2.047179*z
}
#declare Dome = difference {
  sphere { // Sphere003
    <0,0,0>,1
    hollow
    scale 21.259651
    rotate 90.0*z
    translate  18.570933*z
  }
  cylinder { // Cylndr159
    <0,0,1>, <0,0,0>, 1 
    material {
      nothing
    }
    hollow
    scale 25.0
    translate  <-0.460447, 0.0, -5.755583>
  }
  material {
    DomeText
  }
  translate  4.604466*z
}
#declare washer = difference {
  cylinder { // Cylndr158
    <0,0,1>, <0,0,0>, 1 
    scale <1.75, 1.75, 0.5>
  }
  cylinder { // Cylndr157
    <0,0,1>, <0,0,0>, 1 
    scale <1.5, 1.5, 1.0>
    translate  -0.243235*z
  }
  scale <12.5, 12.5, 2.0>
  translate  22.890199*z
}
#declare TempleWalls = union {
  object { ColumnArch }
  object { washer }
  cylinder { // Floordisk
    <0,0,1>, <0,0,0>, 1 
    material {
      FloorTexture
    }
    scale <23.0, 23.0, 2.5>
    translate  -2.322065*z
  }
  cylinder { // Floordisk1
    <0,0,1>, <0,0,0>, 1 
    material {
      FloorTexture_1
    }
    scale <24.0, 24.0, 1.6>
    translate  -2.335338*z
  }
  cylinder { // Floordisk2
    <0,0,1>, <0,0,0>, 1 
    material {
      FloorTexture
    }
    scale <25.0, 25.0, 0.8>
    translate  -2.364796*z
  }
  object { // ColumnArch1->ColumnArch
    ColumnArch
    rotate -30.0*z
  }
  object { // ColumnArch2->ColumnArch
    ColumnArch
    rotate -60.0*z
  }
  object { // ColumnArch3->ColumnArch
    ColumnArch
    rotate -90.0*z
  }
  object { // ColumnArch4->ColumnArch
    ColumnArch
    rotate -120.0*z
  }
  object { // ColumnArch5->ColumnArch
    ColumnArch
    rotate -150.0*z
  }
  object { // ColumnArch6->ColumnArch
    ColumnArch
    rotate 180.0*z
  }
  object { // ColumnArch7->ColumnArch
    ColumnArch
    rotate 150.0*z
  }
  object { // ColumnArch8->ColumnArch
    ColumnArch
    rotate 120.0*z
  }
  object { // ColumnArch9->ColumnArch
    ColumnArch
    rotate 90.0*z
  }
  object { // ColumnArch10->ColumnArch
    ColumnArch
    rotate 60.0*z
  }
  object { // ColumnArch11->ColumnArch
    ColumnArch
    rotate 30.0*z
  }
  material {
    ColumnTexture
  }
}
#declare BezPtch009 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -8.065095, 2.741868>, <-0.165642, -8.065095, 2.741868>, <0.000000, -8.065095, 2.741868>, <0.165642, -8.065095, 2.741868>, 
      <-0.333985, -7.937644, 0.088447>, <-0.168343, -7.937644, 0.088447>, <-0.002700, -7.937644, 0.088447>, <0.162942, -7.937644, 0.088447>, 
      <-0.331285, -6.154882, 0.353789>, <-0.165642, -6.154882, 0.353789>, <0.000000, -6.154882, 0.353789>, <0.165642, -6.154882, 0.353789>, 
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>, 
      <-0.331285, -3.705948, 0.353789>, <-0.165642, -3.705948, 0.353789>, <0.000000, -3.705948, 0.353789>, <0.165642, -3.705948, 0.353789>, 
      <-0.331285, -4.052750, 3.184105>, <-0.165642, -4.052750, 3.184105>, <0.000000, -4.052750, 3.184105>, <0.165642, -4.052750, 3.184105>, 
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>, 
      <-0.331285, 1.269360, 3.537894>, <-0.165642, 1.269360, 3.537894>, <0.000000, 1.269360, 3.537894>, <0.165642, 1.269360, 3.537894>, 
      <-0.331285, 1.461279, 0.000000>, <-0.165642, 1.461279, 0.000000>, <0.000000, 1.461279, 0.000000>, <0.165642, 1.461279, 0.000000>, 
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>, 
      <-0.331285, 3.820426, -0.088447>, <-0.165642, 3.820426, -0.088447>, <0.000000, 3.820426, -0.088447>, <0.165642, 3.820426, -0.088447>, 
      <-0.331285, 5.000000, 0.088447>, <-0.165642, 5.000000, 0.088447>, <0.000000, 5.000000, 0.088447>, <0.165642, 5.000000, 0.088447>, 
      <-0.331285, 5.012346, 1.857395>, <-0.165642, 5.012346, 1.857395>, <0.000000, 5.012346, 1.857395>, <0.165642, 5.012346, 1.857395>
    }
  }
  rotate <91.002113, 0.0, 180.0>
  translate  <34.972278, -43.612587, 10.817071>
}
#declare BezPtch010 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -8.065095, 2.741868>, <-0.165642, -8.065095, 2.741868>, <0.000000, -8.065095, 2.741868>, <0.165642, -8.065095, 2.741868>, 
      <-0.333985, -7.937644, 0.088447>, <-0.168343, -7.937644, 0.088447>, <-0.002700, -7.937644, 0.088447>, <0.162942, -7.937644, 0.088447>, 
      <-0.331285, -6.154882, 0.353789>, <-0.165642, -6.154882, 0.353789>, <0.000000, -6.154882, 0.353789>, <0.165642, -6.154882, 0.353789>, 
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>, 
      <-0.331285, -3.705948, 0.353789>, <-0.165642, -3.705948, 0.353789>, <0.000000, -3.705948, 0.353789>, <0.165642, -3.705948, 0.353789>, 
      <-0.331285, -4.052750, 3.184105>, <-0.165642, -4.052750, 3.184105>, <0.000000, -4.052750, 3.184105>, <0.165642, -4.052750, 3.184105>, 
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>, 
      <-0.331285, 1.269360, 3.537894>, <-0.165642, 1.269360, 3.537894>, <0.000000, 1.269360, 3.537894>, <0.165642, 1.269360, 3.537894>, 
      <-0.331285, 1.461279, 0.000000>, <-0.165642, 1.461279, 0.000000>, <0.000000, 1.461279, 0.000000>, <0.165642, 1.461279, 0.000000>, 
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>, 
      <-0.331285, 3.820426, -0.088447>, <-0.165642, 3.820426, -0.088447>, <0.000000, 3.820426, -0.088447>, <0.165642, 3.820426, -0.088447>, 
      <-0.331285, 5.000000, 0.088447>, <-0.165642, 5.000000, 0.088447>, <0.000000, 5.000000, 0.088447>, <0.165642, 5.000000, 0.088447>, 
      <-0.331285, 5.012346, 1.857395>, <-0.165642, 5.012346, 1.857395>, <0.000000, 5.012346, 1.857395>, <0.165642, 5.012346, 1.857395>
    }
  }
  rotate <91.002113, 0.0, 90.0>
  translate  <36.710571, -44.916306, 10.817071>
}
#declare BezPtch011 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -8.065095, 2.741868>, <-0.165642, -8.065095, 2.741868>, <0.000000, -8.065095, 2.741868>, <0.165642, -8.065095, 2.741868>, 
      <-0.333985, -7.937644, 0.088447>, <-0.168343, -7.937644, 0.088447>, <-0.002700, -7.937644, 0.088447>, <0.162942, -7.937644, 0.088447>, 
      <-0.331285, -6.154882, 0.353789>, <-0.165642, -6.154882, 0.353789>, <0.000000, -6.154882, 0.353789>, <0.165642, -6.154882, 0.353789>, 
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>, 
      <-0.331285, -3.705948, 0.353789>, <-0.165642, -3.705948, 0.353789>, <0.000000, -3.705948, 0.353789>, <0.165642, -3.705948, 0.353789>, 
      <-0.331285, -4.052750, 3.184105>, <-0.165642, -4.052750, 3.184105>, <0.000000, -4.052750, 3.184105>, <0.165642, -4.052750, 3.184105>, 
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>, 
      <-0.331285, 1.269360, 3.537894>, <-0.165642, 1.269360, 3.537894>, <0.000000, 1.269360, 3.537894>, <0.165642, 1.269360, 3.537894>, 
      <-0.331285, 1.461279, 0.000000>, <-0.165642, 1.461279, 0.000000>, <0.000000, 1.461279, 0.000000>, <0.165642, 1.461279, 0.000000>, 
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>, 
      <-0.331285, 3.820426, -0.088447>, <-0.165642, 3.820426, -0.088447>, <0.000000, 3.820426, -0.088447>, <0.165642, 3.820426, -0.088447>, 
      <-0.331285, 5.000000, 0.088447>, <-0.165642, 5.000000, 0.088447>, <0.000000, 5.000000, 0.088447>, <0.165642, 5.000000, 0.088447>, 
      <-0.331285, 5.012346, 1.857395>, <-0.165642, 5.012346, 1.857395>, <0.000000, 5.012346, 1.857395>, <0.165642, 5.012346, 1.857395>
    }
  }
  rotate <91.002113, 0.0, 45.0>
  translate  <36.362912, -46.133111, 10.817071>
}
#declare BezPtch012 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -8.065095, 2.741868>, <-0.165642, -8.065095, 2.741868>, <0.000000, -8.065095, 2.741868>, <0.165642, -8.065095, 2.741868>, 
      <-0.333985, -7.937644, 0.088447>, <-0.168343, -7.937644, 0.088447>, <-0.002700, -7.937644, 0.088447>, <0.162942, -7.937644, 0.088447>, 
      <-0.331285, -6.154882, 0.353789>, <-0.165642, -6.154882, 0.353789>, <0.000000, -6.154882, 0.353789>, <0.165642, -6.154882, 0.353789>, 
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>, 
      <-0.331285, -3.705948, 0.353789>, <-0.165642, -3.705948, 0.353789>, <0.000000, -3.705948, 0.353789>, <0.165642, -3.705948, 0.353789>, 
      <-0.331285, -4.052750, 3.184105>, <-0.165642, -4.052750, 3.184105>, <0.000000, -4.052750, 3.184105>, <0.165642, -4.052750, 3.184105>, 
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>, 
      <-0.331285, 1.269360, 3.537894>, <-0.165642, 1.269360, 3.537894>, <0.000000, 1.269360, 3.537894>, <0.165642, 1.269360, 3.537894>, 
      <-0.331285, 1.461279, 0.000000>, <-0.165642, 1.461279, 0.000000>, <0.000000, 1.461279, 0.000000>, <0.165642, 1.461279, 0.000000>, 
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>, 
      <-0.331285, 3.820426, -0.088447>, <-0.165642, 3.820426, -0.088447>, <0.000000, 3.820426, -0.088447>, <0.165642, 3.820426, -0.088447>, 
      <-0.331285, 5.000000, 0.088447>, <-0.165642, 5.000000, 0.088447>, <0.000000, 5.000000, 0.088447>, <0.165642, 5.000000, 0.088447>, 
      <-0.331285, 5.012346, 1.857395>, <-0.165642, 5.012346, 1.857395>, <0.000000, 5.012346, 1.857395>, <0.165642, 5.012346, 1.857395>
    }
  }
  rotate <91.002113, 0.0, 135.0>
  translate  <36.189083, -44.134074, 10.817071>
}
#declare BezPtch013 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -8.065095, 2.741868>, <-0.165642, -8.065095, 2.741868>, <0.000000, -8.065095, 2.741868>, <0.165642, -8.065095, 2.741868>, 
      <-0.333985, -7.937644, 0.088447>, <-0.168343, -7.937644, 0.088447>, <-0.002700, -7.937644, 0.088447>, <0.162942, -7.937644, 0.088447>, 
      <-0.331285, -6.154882, 0.353789>, <-0.165642, -6.154882, 0.353789>, <0.000000, -6.154882, 0.353789>, <0.165642, -6.154882, 0.353789>, 
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>, 
      <-0.331285, -3.705948, 0.353789>, <-0.165642, -3.705948, 0.353789>, <0.000000, -3.705948, 0.353789>, <0.165642, -3.705948, 0.353789>, 
      <-0.331285, -4.052750, 3.184105>, <-0.165642, -4.052750, 3.184105>, <0.000000, -4.052750, 3.184105>, <0.165642, -4.052750, 3.184105>, 
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>, 
      <-0.331285, 1.269360, 3.537894>, <-0.165642, 1.269360, 3.537894>, <0.000000, 1.269360, 3.537894>, <0.165642, 1.269360, 3.537894>, 
      <-0.331285, 1.461279, 0.000000>, <-0.165642, 1.461279, 0.000000>, <0.000000, 1.461279, 0.000000>, <0.165642, 1.461279, 0.000000>, 
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>, 
      <-0.331285, 3.820426, -0.088447>, <-0.165642, 3.820426, -0.088447>, <0.000000, 3.820426, -0.088447>, <0.165642, 3.820426, -0.088447>, 
      <-0.331285, 5.000000, 0.088447>, <-0.165642, 5.000000, 0.088447>, <0.000000, 5.000000, 0.088447>, <0.165642, 5.000000, 0.088447>, 
      <-0.331285, 5.012346, 1.857395>, <-0.165642, 5.012346, 1.857395>, <0.000000, 5.012346, 1.857395>, <0.165642, 5.012346, 1.857395>
    }
  }
  rotate <91.002113, 0.0, -135.0>
  translate  <34.016217, -44.481733, 10.817071>
}
#declare BezPtch014 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -8.065095, 2.741868>, <-0.165642, -8.065095, 2.741868>, <0.000000, -8.065095, 2.741868>, <0.165642, -8.065095, 2.741868>, 
      <-0.333985, -7.937644, 0.088447>, <-0.168343, -7.937644, 0.088447>, <-0.002700, -7.937644, 0.088447>, <0.162942, -7.937644, 0.088447>, 
      <-0.331285, -6.154882, 0.353789>, <-0.165642, -6.154882, 0.353789>, <0.000000, -6.154882, 0.353789>, <0.165642, -6.154882, 0.353789>, 
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>, 
      <-0.331285, -3.705948, 0.353789>, <-0.165642, -3.705948, 0.353789>, <0.000000, -3.705948, 0.353789>, <0.165642, -3.705948, 0.353789>, 
      <-0.331285, -4.052750, 3.184105>, <-0.165642, -4.052750, 3.184105>, <0.000000, -4.052750, 3.184105>, <0.165642, -4.052750, 3.184105>, 
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>, 
      <-0.331285, 1.269360, 3.537894>, <-0.165642, 1.269360, 3.537894>, <0.000000, 1.269360, 3.537894>, <0.165642, 1.269360, 3.537894>, 
      <-0.331285, 1.461279, 0.000000>, <-0.165642, 1.461279, 0.000000>, <0.000000, 1.461279, 0.000000>, <0.165642, 1.461279, 0.000000>, 
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>, 
      <-0.331285, 3.820426, -0.088447>, <-0.165642, 3.820426, -0.088447>, <0.000000, 3.820426, -0.088447>, <0.165642, 3.820426, -0.088447>, 
      <-0.331285, 5.000000, 0.088447>, <-0.165642, 5.000000, 0.088447>, <0.000000, 5.000000, 0.088447>, <0.165642, 5.000000, 0.088447>, 
      <-0.331285, 5.012346, 1.857395>, <-0.165642, 5.012346, 1.857395>, <0.000000, 5.012346, 1.857395>, <0.165642, 5.012346, 1.857395>
    }
  }
  rotate <91.002113, 0.0, -90.0>
  translate  <33.407814, -45.17705, 10.817071>
}
#declare BezPtch015 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -8.065095, 2.741868>, <-0.165642, -8.065095, 2.741868>, <0.000000, -8.065095, 2.741868>, <0.165642, -8.065095, 2.741868>, 
      <-0.333985, -7.937644, 0.088447>, <-0.168343, -7.937644, 0.088447>, <-0.002700, -7.937644, 0.088447>, <0.162942, -7.937644, 0.088447>, 
      <-0.331285, -6.154882, 0.353789>, <-0.165642, -6.154882, 0.353789>, <0.000000, -6.154882, 0.353789>, <0.165642, -6.154882, 0.353789>, 
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>, 
      <-0.331285, -3.705948, 0.353789>, <-0.165642, -3.705948, 0.353789>, <0.000000, -3.705948, 0.353789>, <0.165642, -3.705948, 0.353789>, 
      <-0.331285, -4.052750, 3.184105>, <-0.165642, -4.052750, 3.184105>, <0.000000, -4.052750, 3.184105>, <0.165642, -4.052750, 3.184105>, 
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>, 
      <-0.331285, 1.269360, 3.537894>, <-0.165642, 1.269360, 3.537894>, <0.000000, 1.269360, 3.537894>, <0.165642, 1.269360, 3.537894>, 
      <-0.331285, 1.461279, 0.000000>, <-0.165642, 1.461279, 0.000000>, <0.000000, 1.461279, 0.000000>, <0.165642, 1.461279, 0.000000>, 
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>, 
      <-0.331285, 3.820426, -0.088447>, <-0.165642, 3.820426, -0.088447>, <0.000000, 3.820426, -0.088447>, <0.165642, 3.820426, -0.088447>, 
      <-0.331285, 5.000000, 0.088447>, <-0.165642, 5.000000, 0.088447>, <0.000000, 5.000000, 0.088447>, <0.165642, 5.000000, 0.088447>, 
      <-0.331285, 5.012346, 1.857395>, <-0.165642, 5.012346, 1.857395>, <0.000000, 5.012346, 1.857395>, <0.165642, 5.012346, 1.857395>
    }
  }
  rotate <91.002113, 0.0, -45.0>
  translate  <34.016217, -46.046196, 10.817071>
}
#declare BezPtch016 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -8.065095, 2.741868>, <-0.165642, -8.065095, 2.741868>, <0.000000, -8.065095, 2.741868>, <0.165642, -8.065095, 2.741868>, 
      <-0.333985, -7.937644, 0.088447>, <-0.168343, -7.937644, 0.088447>, <-0.002700, -7.937644, 0.088447>, <0.162942, -7.937644, 0.088447>, 
      <-0.331285, -6.154882, 0.353789>, <-0.165642, -6.154882, 0.353789>, <0.000000, -6.154882, 0.353789>, <0.165642, -6.154882, 0.353789>, 
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>, 
      <-0.331285, -3.705948, 0.353789>, <-0.165642, -3.705948, 0.353789>, <0.000000, -3.705948, 0.353789>, <0.165642, -3.705948, 0.353789>, 
      <-0.331285, -4.052750, 3.184105>, <-0.165642, -4.052750, 3.184105>, <0.000000, -4.052750, 3.184105>, <0.165642, -4.052750, 3.184105>, 
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>, 
      <-0.331285, 1.269360, 3.537894>, <-0.165642, 1.269360, 3.537894>, <0.000000, 1.269360, 3.537894>, <0.165642, 1.269360, 3.537894>, 
      <-0.331285, 1.461279, 0.000000>, <-0.165642, 1.461279, 0.000000>, <0.000000, 1.461279, 0.000000>, <0.165642, 1.461279, 0.000000>, 
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>, 
      <-0.331285, 3.820426, -0.088447>, <-0.165642, 3.820426, -0.088447>, <0.000000, 3.820426, -0.088447>, <0.165642, 3.820426, -0.088447>, 
      <-0.331285, 5.000000, 0.088447>, <-0.165642, 5.000000, 0.088447>, <0.000000, 5.000000, 0.088447>, <0.165642, 5.000000, 0.088447>, 
      <-0.331285, 5.012346, 1.857395>, <-0.165642, 5.012346, 1.857395>, <0.000000, 5.012346, 1.857395>, <0.165642, 5.012346, 1.857395>
    }
  }
  rotate <91.002113, 0.0, 0.0>
  translate  <35.233022, -46.567684, 10.817071>
}
#declare lamp1 = union {
  sphere { // Sphere005
    <0,0,0>,1
    material {
      Glass
    }
    hollow
    scale <5.0, 5.0, 3.261394>
    translate  <35.095907, -45.140268, 9.51724>
  }
  object { BezPtch009 }
  object { BezPtch010 }
  object { BezPtch011 }
  object { BezPtch012 }
  object { BezPtch013 }
  object { BezPtch014 }
  object { BezPtch015 }
  object { BezPtch016 }
  cone { // Cone003
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale 1.716519
    rotate <180.0, 0.0, 180.0>
    translate  <35.128593, -45.169069, 16.365649>
  }
  torus { // Torus037
    1.75, 0.25  rotate -x*90
    scale 1.091333
    rotate 0.0*x
    translate  <35.06776, -45.169069, 13.234877>
  }
  cylinder { // Cylndr162
    <0,0,1>, <0,0,0>, 1 
    scale 2.064656
    rotate 0.0*x
    translate  <35.268193, -45.169069, 4.005444>
  }
  torus { // Torus038
    1.75, 0.25  rotate -x*90
    scale 1.091333
    rotate 0.0*x
    translate  <35.128593, -45.169069, 14.2082>
  }
  cylinder { // Cylndr163
    <0,0,1>, <0,0,0>, 1 
    scale <0.333333, 0.333333, 20.0>
    rotate <180.0, -0.0, -180.0>
    translate  <35.009483, -44.966081, 35.268835>
  }
  cone { // Cone004
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale 2.465107
    rotate 0.0*y
    translate  <35.009391, -44.976931, 28.187788>
  }
  sphere { // Sphere018
    <0,0,0>,1
    material {
      lampwhite
    }
    no_shadow
    scale 0.734142
    rotate <-0.0, 0.0, -30.0>
    translate  <35.041314, -45.284038, 9.456169>
  }
  material {
    ironblack
  }
  scale 0.15
  rotate -30.0*z
  translate  <-15.274743, -5.705005, 16.133418>
}
#declare BezPtch017 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -8.065095, 2.741868>, <-0.165642, -8.065095, 2.741868>, <0.000000, -8.065095, 2.741868>, <0.165642, -8.065095, 2.741868>, 
      <-0.333985, -7.937644, 0.088447>, <-0.168343, -7.937644, 0.088447>, <-0.002700, -7.937644, 0.088447>, <0.162942, -7.937644, 0.088447>, 
      <-0.331285, -6.154882, 0.353789>, <-0.165642, -6.154882, 0.353789>, <0.000000, -6.154882, 0.353789>, <0.165642, -6.154882, 0.353789>, 
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>, 
      <-0.331285, -3.705948, 0.353789>, <-0.165642, -3.705948, 0.353789>, <0.000000, -3.705948, 0.353789>, <0.165642, -3.705948, 0.353789>, 
      <-0.331285, -4.052750, 3.184105>, <-0.165642, -4.052750, 3.184105>, <0.000000, -4.052750, 3.184105>, <0.165642, -4.052750, 3.184105>, 
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>, 
      <-0.331285, 1.269360, 3.537894>, <-0.165642, 1.269360, 3.537894>, <0.000000, 1.269360, 3.537894>, <0.165642, 1.269360, 3.537894>, 
      <-0.331285, 1.461279, 0.000000>, <-0.165642, 1.461279, 0.000000>, <0.000000, 1.461279, 0.000000>, <0.165642, 1.461279, 0.000000>, 
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>, 
      <-0.331285, 3.820426, -0.088447>, <-0.165642, 3.820426, -0.088447>, <0.000000, 3.820426, -0.088447>, <0.165642, 3.820426, -0.088447>, 
      <-0.331285, 5.000000, 0.088447>, <-0.165642, 5.000000, 0.088447>, <0.000000, 5.000000, 0.088447>, <0.165642, 5.000000, 0.088447>, 
      <-0.331285, 5.012346, 1.857395>, <-0.165642, 5.012346, 1.857395>, <0.000000, 5.012346, 1.857395>, <0.165642, 5.012346, 1.857395>
    }
  }
  rotate <91.002113, 0.0, 180.0>
  translate  <34.972278, -43.612587, 10.817071>
}
#declare BezPtch018 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -8.065095, 2.741868>, <-0.165642, -8.065095, 2.741868>, <0.000000, -8.065095, 2.741868>, <0.165642, -8.065095, 2.741868>, 
      <-0.333985, -7.937644, 0.088447>, <-0.168343, -7.937644, 0.088447>, <-0.002700, -7.937644, 0.088447>, <0.162942, -7.937644, 0.088447>, 
      <-0.331285, -6.154882, 0.353789>, <-0.165642, -6.154882, 0.353789>, <0.000000, -6.154882, 0.353789>, <0.165642, -6.154882, 0.353789>, 
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>, 
      <-0.331285, -3.705948, 0.353789>, <-0.165642, -3.705948, 0.353789>, <0.000000, -3.705948, 0.353789>, <0.165642, -3.705948, 0.353789>, 
      <-0.331285, -4.052750, 3.184105>, <-0.165642, -4.052750, 3.184105>, <0.000000, -4.052750, 3.184105>, <0.165642, -4.052750, 3.184105>, 
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>, 
      <-0.331285, 1.269360, 3.537894>, <-0.165642, 1.269360, 3.537894>, <0.000000, 1.269360, 3.537894>, <0.165642, 1.269360, 3.537894>, 
      <-0.331285, 1.461279, 0.000000>, <-0.165642, 1.461279, 0.000000>, <0.000000, 1.461279, 0.000000>, <0.165642, 1.461279, 0.000000>, 
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>, 
      <-0.331285, 3.820426, -0.088447>, <-0.165642, 3.820426, -0.088447>, <0.000000, 3.820426, -0.088447>, <0.165642, 3.820426, -0.088447>, 
      <-0.331285, 5.000000, 0.088447>, <-0.165642, 5.000000, 0.088447>, <0.000000, 5.000000, 0.088447>, <0.165642, 5.000000, 0.088447>, 
      <-0.331285, 5.012346, 1.857395>, <-0.165642, 5.012346, 1.857395>, <0.000000, 5.012346, 1.857395>, <0.165642, 5.012346, 1.857395>
    }
  }
  rotate <91.002113, 0.0, 90.0>
  translate  <36.710571, -44.916306, 10.817071>
}
#declare BezPtch019 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -8.065095, 2.741868>, <-0.165642, -8.065095, 2.741868>, <0.000000, -8.065095, 2.741868>, <0.165642, -8.065095, 2.741868>, 
      <-0.333985, -7.937644, 0.088447>, <-0.168343, -7.937644, 0.088447>, <-0.002700, -7.937644, 0.088447>, <0.162942, -7.937644, 0.088447>, 
      <-0.331285, -6.154882, 0.353789>, <-0.165642, -6.154882, 0.353789>, <0.000000, -6.154882, 0.353789>, <0.165642, -6.154882, 0.353789>, 
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>, 
      <-0.331285, -3.705948, 0.353789>, <-0.165642, -3.705948, 0.353789>, <0.000000, -3.705948, 0.353789>, <0.165642, -3.705948, 0.353789>, 
      <-0.331285, -4.052750, 3.184105>, <-0.165642, -4.052750, 3.184105>, <0.000000, -4.052750, 3.184105>, <0.165642, -4.052750, 3.184105>, 
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>, 
      <-0.331285, 1.269360, 3.537894>, <-0.165642, 1.269360, 3.537894>, <0.000000, 1.269360, 3.537894>, <0.165642, 1.269360, 3.537894>, 
      <-0.331285, 1.461279, 0.000000>, <-0.165642, 1.461279, 0.000000>, <0.000000, 1.461279, 0.000000>, <0.165642, 1.461279, 0.000000>, 
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>, 
      <-0.331285, 3.820426, -0.088447>, <-0.165642, 3.820426, -0.088447>, <0.000000, 3.820426, -0.088447>, <0.165642, 3.820426, -0.088447>, 
      <-0.331285, 5.000000, 0.088447>, <-0.165642, 5.000000, 0.088447>, <0.000000, 5.000000, 0.088447>, <0.165642, 5.000000, 0.088447>, 
      <-0.331285, 5.012346, 1.857395>, <-0.165642, 5.012346, 1.857395>, <0.000000, 5.012346, 1.857395>, <0.165642, 5.012346, 1.857395>
    }
  }
  rotate <91.002113, 0.0, 45.0>
  translate  <36.362912, -46.133111, 10.817071>
}
#declare BezPtch020 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -8.065095, 2.741868>, <-0.165642, -8.065095, 2.741868>, <0.000000, -8.065095, 2.741868>, <0.165642, -8.065095, 2.741868>, 
      <-0.333985, -7.937644, 0.088447>, <-0.168343, -7.937644, 0.088447>, <-0.002700, -7.937644, 0.088447>, <0.162942, -7.937644, 0.088447>, 
      <-0.331285, -6.154882, 0.353789>, <-0.165642, -6.154882, 0.353789>, <0.000000, -6.154882, 0.353789>, <0.165642, -6.154882, 0.353789>, 
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>, 
      <-0.331285, -3.705948, 0.353789>, <-0.165642, -3.705948, 0.353789>, <0.000000, -3.705948, 0.353789>, <0.165642, -3.705948, 0.353789>, 
      <-0.331285, -4.052750, 3.184105>, <-0.165642, -4.052750, 3.184105>, <0.000000, -4.052750, 3.184105>, <0.165642, -4.052750, 3.184105>, 
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>, 
      <-0.331285, 1.269360, 3.537894>, <-0.165642, 1.269360, 3.537894>, <0.000000, 1.269360, 3.537894>, <0.165642, 1.269360, 3.537894>, 
      <-0.331285, 1.461279, 0.000000>, <-0.165642, 1.461279, 0.000000>, <0.000000, 1.461279, 0.000000>, <0.165642, 1.461279, 0.000000>, 
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>, 
      <-0.331285, 3.820426, -0.088447>, <-0.165642, 3.820426, -0.088447>, <0.000000, 3.820426, -0.088447>, <0.165642, 3.820426, -0.088447>, 
      <-0.331285, 5.000000, 0.088447>, <-0.165642, 5.000000, 0.088447>, <0.000000, 5.000000, 0.088447>, <0.165642, 5.000000, 0.088447>, 
      <-0.331285, 5.012346, 1.857395>, <-0.165642, 5.012346, 1.857395>, <0.000000, 5.012346, 1.857395>, <0.165642, 5.012346, 1.857395>
    }
  }
  rotate <91.002113, 0.0, 135.0>
  translate  <36.189083, -44.134074, 10.817071>
}
#declare BezPtch021 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -8.065095, 2.741868>, <-0.165642, -8.065095, 2.741868>, <0.000000, -8.065095, 2.741868>, <0.165642, -8.065095, 2.741868>, 
      <-0.333985, -7.937644, 0.088447>, <-0.168343, -7.937644, 0.088447>, <-0.002700, -7.937644, 0.088447>, <0.162942, -7.937644, 0.088447>, 
      <-0.331285, -6.154882, 0.353789>, <-0.165642, -6.154882, 0.353789>, <0.000000, -6.154882, 0.353789>, <0.165642, -6.154882, 0.353789>, 
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>, 
      <-0.331285, -3.705948, 0.353789>, <-0.165642, -3.705948, 0.353789>, <0.000000, -3.705948, 0.353789>, <0.165642, -3.705948, 0.353789>, 
      <-0.331285, -4.052750, 3.184105>, <-0.165642, -4.052750, 3.184105>, <0.000000, -4.052750, 3.184105>, <0.165642, -4.052750, 3.184105>, 
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>, 
      <-0.331285, 1.269360, 3.537894>, <-0.165642, 1.269360, 3.537894>, <0.000000, 1.269360, 3.537894>, <0.165642, 1.269360, 3.537894>, 
      <-0.331285, 1.461279, 0.000000>, <-0.165642, 1.461279, 0.000000>, <0.000000, 1.461279, 0.000000>, <0.165642, 1.461279, 0.000000>, 
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>, 
      <-0.331285, 3.820426, -0.088447>, <-0.165642, 3.820426, -0.088447>, <0.000000, 3.820426, -0.088447>, <0.165642, 3.820426, -0.088447>, 
      <-0.331285, 5.000000, 0.088447>, <-0.165642, 5.000000, 0.088447>, <0.000000, 5.000000, 0.088447>, <0.165642, 5.000000, 0.088447>, 
      <-0.331285, 5.012346, 1.857395>, <-0.165642, 5.012346, 1.857395>, <0.000000, 5.012346, 1.857395>, <0.165642, 5.012346, 1.857395>
    }
  }
  rotate <91.002113, 0.0, -135.0>
  translate  <34.016217, -44.481733, 10.817071>
}
#declare BezPtch022 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -8.065095, 2.741868>, <-0.165642, -8.065095, 2.741868>, <0.000000, -8.065095, 2.741868>, <0.165642, -8.065095, 2.741868>, 
      <-0.333985, -7.937644, 0.088447>, <-0.168343, -7.937644, 0.088447>, <-0.002700, -7.937644, 0.088447>, <0.162942, -7.937644, 0.088447>, 
      <-0.331285, -6.154882, 0.353789>, <-0.165642, -6.154882, 0.353789>, <0.000000, -6.154882, 0.353789>, <0.165642, -6.154882, 0.353789>, 
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>, 
      <-0.331285, -3.705948, 0.353789>, <-0.165642, -3.705948, 0.353789>, <0.000000, -3.705948, 0.353789>, <0.165642, -3.705948, 0.353789>, 
      <-0.331285, -4.052750, 3.184105>, <-0.165642, -4.052750, 3.184105>, <0.000000, -4.052750, 3.184105>, <0.165642, -4.052750, 3.184105>, 
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>, 
      <-0.331285, 1.269360, 3.537894>, <-0.165642, 1.269360, 3.537894>, <0.000000, 1.269360, 3.537894>, <0.165642, 1.269360, 3.537894>, 
      <-0.331285, 1.461279, 0.000000>, <-0.165642, 1.461279, 0.000000>, <0.000000, 1.461279, 0.000000>, <0.165642, 1.461279, 0.000000>, 
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>, 
      <-0.331285, 3.820426, -0.088447>, <-0.165642, 3.820426, -0.088447>, <0.000000, 3.820426, -0.088447>, <0.165642, 3.820426, -0.088447>, 
      <-0.331285, 5.000000, 0.088447>, <-0.165642, 5.000000, 0.088447>, <0.000000, 5.000000, 0.088447>, <0.165642, 5.000000, 0.088447>, 
      <-0.331285, 5.012346, 1.857395>, <-0.165642, 5.012346, 1.857395>, <0.000000, 5.012346, 1.857395>, <0.165642, 5.012346, 1.857395>
    }
  }
  rotate <91.002113, 0.0, -90.0>
  translate  <33.407814, -45.17705, 10.817071>
}
#declare BezPtch023 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -8.065095, 2.741868>, <-0.165642, -8.065095, 2.741868>, <0.000000, -8.065095, 2.741868>, <0.165642, -8.065095, 2.741868>, 
      <-0.333985, -7.937644, 0.088447>, <-0.168343, -7.937644, 0.088447>, <-0.002700, -7.937644, 0.088447>, <0.162942, -7.937644, 0.088447>, 
      <-0.331285, -6.154882, 0.353789>, <-0.165642, -6.154882, 0.353789>, <0.000000, -6.154882, 0.353789>, <0.165642, -6.154882, 0.353789>, 
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>, 
      <-0.331285, -3.705948, 0.353789>, <-0.165642, -3.705948, 0.353789>, <0.000000, -3.705948, 0.353789>, <0.165642, -3.705948, 0.353789>, 
      <-0.331285, -4.052750, 3.184105>, <-0.165642, -4.052750, 3.184105>, <0.000000, -4.052750, 3.184105>, <0.165642, -4.052750, 3.184105>, 
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>, 
      <-0.331285, 1.269360, 3.537894>, <-0.165642, 1.269360, 3.537894>, <0.000000, 1.269360, 3.537894>, <0.165642, 1.269360, 3.537894>, 
      <-0.331285, 1.461279, 0.000000>, <-0.165642, 1.461279, 0.000000>, <0.000000, 1.461279, 0.000000>, <0.165642, 1.461279, 0.000000>, 
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>, 
      <-0.331285, 3.820426, -0.088447>, <-0.165642, 3.820426, -0.088447>, <0.000000, 3.820426, -0.088447>, <0.165642, 3.820426, -0.088447>, 
      <-0.331285, 5.000000, 0.088447>, <-0.165642, 5.000000, 0.088447>, <0.000000, 5.000000, 0.088447>, <0.165642, 5.000000, 0.088447>, 
      <-0.331285, 5.012346, 1.857395>, <-0.165642, 5.012346, 1.857395>, <0.000000, 5.012346, 1.857395>, <0.165642, 5.012346, 1.857395>
    }
  }
  rotate <91.002113, 0.0, -45.0>
  translate  <34.016217, -46.046196, 10.817071>
}
#declare BezPtch024 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -8.065095, 2.741868>, <-0.165642, -8.065095, 2.741868>, <0.000000, -8.065095, 2.741868>, <0.165642, -8.065095, 2.741868>, 
      <-0.333985, -7.937644, 0.088447>, <-0.168343, -7.937644, 0.088447>, <-0.002700, -7.937644, 0.088447>, <0.162942, -7.937644, 0.088447>, 
      <-0.331285, -6.154882, 0.353789>, <-0.165642, -6.154882, 0.353789>, <0.000000, -6.154882, 0.353789>, <0.165642, -6.154882, 0.353789>, 
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>, 
      <-0.331285, -3.705948, 0.353789>, <-0.165642, -3.705948, 0.353789>, <0.000000, -3.705948, 0.353789>, <0.165642, -3.705948, 0.353789>, 
      <-0.331285, -4.052750, 3.184105>, <-0.165642, -4.052750, 3.184105>, <0.000000, -4.052750, 3.184105>, <0.165642, -4.052750, 3.184105>, 
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>, 
      <-0.331285, 1.269360, 3.537894>, <-0.165642, 1.269360, 3.537894>, <0.000000, 1.269360, 3.537894>, <0.165642, 1.269360, 3.537894>, 
      <-0.331285, 1.461279, 0.000000>, <-0.165642, 1.461279, 0.000000>, <0.000000, 1.461279, 0.000000>, <0.165642, 1.461279, 0.000000>, 
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>, 
      <-0.331285, 3.820426, -0.088447>, <-0.165642, 3.820426, -0.088447>, <0.000000, 3.820426, -0.088447>, <0.165642, 3.820426, -0.088447>, 
      <-0.331285, 5.000000, 0.088447>, <-0.165642, 5.000000, 0.088447>, <0.000000, 5.000000, 0.088447>, <0.165642, 5.000000, 0.088447>, 
      <-0.331285, 5.012346, 1.857395>, <-0.165642, 5.012346, 1.857395>, <0.000000, 5.012346, 1.857395>, <0.165642, 5.012346, 1.857395>
    }
  }
  rotate <91.002113, 0.0, 0.0>
  translate  <35.233022, -46.567684, 10.817071>
}
#declare lamp2 = union {
  sphere { // Sphere006
    <0,0,0>,1
    material {
      Glass
    }
    hollow
    scale <5.0, 5.0, 3.261394>
    translate  <35.095907, -45.140268, 9.51724>
  }
  object { BezPtch017 }
  object { BezPtch018 }
  object { BezPtch019 }
  object { BezPtch020 }
  object { BezPtch021 }
  object { BezPtch022 }
  object { BezPtch023 }
  object { BezPtch024 }
  cone { // Cone005
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale 1.716519
    rotate <180.0, 0.0, 180.0>
    translate  <35.128593, -45.169069, 16.365649>
  }
  torus { // Torus039
    1.75, 0.25  rotate -x*90
    scale 1.091333
    rotate 0.0*x
    translate  <35.06776, -45.169069, 13.234877>
  }
  cylinder { // Cylndr164
    <0,0,1>, <0,0,0>, 1 
    scale 2.064656
    rotate 0.0*x
    translate  <35.268193, -45.169069, 4.005444>
  }
  torus { // Torus040
    1.75, 0.25  rotate -x*90
    scale 1.091333
    rotate 0.0*x
    translate  <35.128593, -45.169069, 14.2082>
  }
  cylinder { // Cylndr165
    <0,0,1>, <0,0,0>, 1 
    scale <0.333333, 0.333333, 20.0>
    rotate <180.0, -0.0, -180.0>
    translate  <35.009483, -44.966081, 35.268835>
  }
  cone { // Cone006
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale 2.465107
    rotate 0.0*y
    translate  <35.009391, -44.976931, 28.187788>
  }
  sphere { // Sphere019
    <0,0,0>,1
    material {
      lampwhite
    }
    no_shadow
    scale 0.734142
    rotate <-0.0, 0.0, -30.0>
    translate  <35.041314, -45.284038, 9.456169>
  }
  material {
    ironblack
  }
  scale 0.15
  rotate -60.0*z
  translate  <-16.080818, 2.696693, 16.133418>
}
#declare BezPtch025 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -8.065095, 2.741868>, <-0.165642, -8.065095, 2.741868>, <0.000000, -8.065095, 2.741868>, <0.165642, -8.065095, 2.741868>, 
      <-0.333985, -7.937644, 0.088447>, <-0.168343, -7.937644, 0.088447>, <-0.002700, -7.937644, 0.088447>, <0.162942, -7.937644, 0.088447>, 
      <-0.331285, -6.154882, 0.353789>, <-0.165642, -6.154882, 0.353789>, <0.000000, -6.154882, 0.353789>, <0.165642, -6.154882, 0.353789>, 
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>, 
      <-0.331285, -3.705948, 0.353789>, <-0.165642, -3.705948, 0.353789>, <0.000000, -3.705948, 0.353789>, <0.165642, -3.705948, 0.353789>, 
      <-0.331285, -4.052750, 3.184105>, <-0.165642, -4.052750, 3.184105>, <0.000000, -4.052750, 3.184105>, <0.165642, -4.052750, 3.184105>, 
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>, 
      <-0.331285, 1.269360, 3.537894>, <-0.165642, 1.269360, 3.537894>, <0.000000, 1.269360, 3.537894>, <0.165642, 1.269360, 3.537894>, 
      <-0.331285, 1.461279, 0.000000>, <-0.165642, 1.461279, 0.000000>, <0.000000, 1.461279, 0.000000>, <0.165642, 1.461279, 0.000000>, 
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>, 
      <-0.331285, 3.820426, -0.088447>, <-0.165642, 3.820426, -0.088447>, <0.000000, 3.820426, -0.088447>, <0.165642, 3.820426, -0.088447>, 
      <-0.331285, 5.000000, 0.088447>, <-0.165642, 5.000000, 0.088447>, <0.000000, 5.000000, 0.088447>, <0.165642, 5.000000, 0.088447>, 
      <-0.331285, 5.012346, 1.857395>, <-0.165642, 5.012346, 1.857395>, <0.000000, 5.012346, 1.857395>, <0.165642, 5.012346, 1.857395>
    }
  }
  rotate <91.002113, 0.0, 180.0>
  translate  <34.972278, -43.612587, 10.817071>
}
#declare BezPtch026 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -8.065095, 2.741868>, <-0.165642, -8.065095, 2.741868>, <0.000000, -8.065095, 2.741868>, <0.165642, -8.065095, 2.741868>, 
      <-0.333985, -7.937644, 0.088447>, <-0.168343, -7.937644, 0.088447>, <-0.002700, -7.937644, 0.088447>, <0.162942, -7.937644, 0.088447>, 
      <-0.331285, -6.154882, 0.353789>, <-0.165642, -6.154882, 0.353789>, <0.000000, -6.154882, 0.353789>, <0.165642, -6.154882, 0.353789>, 
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>, 
      <-0.331285, -3.705948, 0.353789>, <-0.165642, -3.705948, 0.353789>, <0.000000, -3.705948, 0.353789>, <0.165642, -3.705948, 0.353789>, 
      <-0.331285, -4.052750, 3.184105>, <-0.165642, -4.052750, 3.184105>, <0.000000, -4.052750, 3.184105>, <0.165642, -4.052750, 3.184105>, 
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>, 
      <-0.331285, 1.269360, 3.537894>, <-0.165642, 1.269360, 3.537894>, <0.000000, 1.269360, 3.537894>, <0.165642, 1.269360, 3.537894>, 
      <-0.331285, 1.461279, 0.000000>, <-0.165642, 1.461279, 0.000000>, <0.000000, 1.461279, 0.000000>, <0.165642, 1.461279, 0.000000>, 
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>, 
      <-0.331285, 3.820426, -0.088447>, <-0.165642, 3.820426, -0.088447>, <0.000000, 3.820426, -0.088447>, <0.165642, 3.820426, -0.088447>, 
      <-0.331285, 5.000000, 0.088447>, <-0.165642, 5.000000, 0.088447>, <0.000000, 5.000000, 0.088447>, <0.165642, 5.000000, 0.088447>, 
      <-0.331285, 5.012346, 1.857395>, <-0.165642, 5.012346, 1.857395>, <0.000000, 5.012346, 1.857395>, <0.165642, 5.012346, 1.857395>
    }
  }
  rotate <91.002113, 0.0, 90.0>
  translate  <36.710571, -44.916306, 10.817071>
}
#declare BezPtch027 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -8.065095, 2.741868>, <-0.165642, -8.065095, 2.741868>, <0.000000, -8.065095, 2.741868>, <0.165642, -8.065095, 2.741868>, 
      <-0.333985, -7.937644, 0.088447>, <-0.168343, -7.937644, 0.088447>, <-0.002700, -7.937644, 0.088447>, <0.162942, -7.937644, 0.088447>, 
      <-0.331285, -6.154882, 0.353789>, <-0.165642, -6.154882, 0.353789>, <0.000000, -6.154882, 0.353789>, <0.165642, -6.154882, 0.353789>, 
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>, 
      <-0.331285, -3.705948, 0.353789>, <-0.165642, -3.705948, 0.353789>, <0.000000, -3.705948, 0.353789>, <0.165642, -3.705948, 0.353789>, 
      <-0.331285, -4.052750, 3.184105>, <-0.165642, -4.052750, 3.184105>, <0.000000, -4.052750, 3.184105>, <0.165642, -4.052750, 3.184105>, 
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>, 
      <-0.331285, 1.269360, 3.537894>, <-0.165642, 1.269360, 3.537894>, <0.000000, 1.269360, 3.537894>, <0.165642, 1.269360, 3.537894>, 
      <-0.331285, 1.461279, 0.000000>, <-0.165642, 1.461279, 0.000000>, <0.000000, 1.461279, 0.000000>, <0.165642, 1.461279, 0.000000>, 
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>, 
      <-0.331285, 3.820426, -0.088447>, <-0.165642, 3.820426, -0.088447>, <0.000000, 3.820426, -0.088447>, <0.165642, 3.820426, -0.088447>, 
      <-0.331285, 5.000000, 0.088447>, <-0.165642, 5.000000, 0.088447>, <0.000000, 5.000000, 0.088447>, <0.165642, 5.000000, 0.088447>, 
      <-0.331285, 5.012346, 1.857395>, <-0.165642, 5.012346, 1.857395>, <0.000000, 5.012346, 1.857395>, <0.165642, 5.012346, 1.857395>
    }
  }
  rotate <91.002113, 0.0, 45.0>
  translate  <36.362912, -46.133111, 10.817071>
}
#declare BezPtch028 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -8.065095, 2.741868>, <-0.165642, -8.065095, 2.741868>, <0.000000, -8.065095, 2.741868>, <0.165642, -8.065095, 2.741868>, 
      <-0.333985, -7.937644, 0.088447>, <-0.168343, -7.937644, 0.088447>, <-0.002700, -7.937644, 0.088447>, <0.162942, -7.937644, 0.088447>, 
      <-0.331285, -6.154882, 0.353789>, <-0.165642, -6.154882, 0.353789>, <0.000000, -6.154882, 0.353789>, <0.165642, -6.154882, 0.353789>, 
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>, 
      <-0.331285, -3.705948, 0.353789>, <-0.165642, -3.705948, 0.353789>, <0.000000, -3.705948, 0.353789>, <0.165642, -3.705948, 0.353789>, 
      <-0.331285, -4.052750, 3.184105>, <-0.165642, -4.052750, 3.184105>, <0.000000, -4.052750, 3.184105>, <0.165642, -4.052750, 3.184105>, 
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>, 
      <-0.331285, 1.269360, 3.537894>, <-0.165642, 1.269360, 3.537894>, <0.000000, 1.269360, 3.537894>, <0.165642, 1.269360, 3.537894>, 
      <-0.331285, 1.461279, 0.000000>, <-0.165642, 1.461279, 0.000000>, <0.000000, 1.461279, 0.000000>, <0.165642, 1.461279, 0.000000>, 
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>, 
      <-0.331285, 3.820426, -0.088447>, <-0.165642, 3.820426, -0.088447>, <0.000000, 3.820426, -0.088447>, <0.165642, 3.820426, -0.088447>, 
      <-0.331285, 5.000000, 0.088447>, <-0.165642, 5.000000, 0.088447>, <0.000000, 5.000000, 0.088447>, <0.165642, 5.000000, 0.088447>, 
      <-0.331285, 5.012346, 1.857395>, <-0.165642, 5.012346, 1.857395>, <0.000000, 5.012346, 1.857395>, <0.165642, 5.012346, 1.857395>
    }
  }
  rotate <91.002113, 0.0, 135.0>
  translate  <36.189083, -44.134074, 10.817071>
}
#declare BezPtch029 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -8.065095, 2.741868>, <-0.165642, -8.065095, 2.741868>, <0.000000, -8.065095, 2.741868>, <0.165642, -8.065095, 2.741868>, 
      <-0.333985, -7.937644, 0.088447>, <-0.168343, -7.937644, 0.088447>, <-0.002700, -7.937644, 0.088447>, <0.162942, -7.937644, 0.088447>, 
      <-0.331285, -6.154882, 0.353789>, <-0.165642, -6.154882, 0.353789>, <0.000000, -6.154882, 0.353789>, <0.165642, -6.154882, 0.353789>, 
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>, 
      <-0.331285, -3.705948, 0.353789>, <-0.165642, -3.705948, 0.353789>, <0.000000, -3.705948, 0.353789>, <0.165642, -3.705948, 0.353789>, 
      <-0.331285, -4.052750, 3.184105>, <-0.165642, -4.052750, 3.184105>, <0.000000, -4.052750, 3.184105>, <0.165642, -4.052750, 3.184105>, 
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>, 
      <-0.331285, 1.269360, 3.537894>, <-0.165642, 1.269360, 3.537894>, <0.000000, 1.269360, 3.537894>, <0.165642, 1.269360, 3.537894>, 
      <-0.331285, 1.461279, 0.000000>, <-0.165642, 1.461279, 0.000000>, <0.000000, 1.461279, 0.000000>, <0.165642, 1.461279, 0.000000>, 
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>, 
      <-0.331285, 3.820426, -0.088447>, <-0.165642, 3.820426, -0.088447>, <0.000000, 3.820426, -0.088447>, <0.165642, 3.820426, -0.088447>, 
      <-0.331285, 5.000000, 0.088447>, <-0.165642, 5.000000, 0.088447>, <0.000000, 5.000000, 0.088447>, <0.165642, 5.000000, 0.088447>, 
      <-0.331285, 5.012346, 1.857395>, <-0.165642, 5.012346, 1.857395>, <0.000000, 5.012346, 1.857395>, <0.165642, 5.012346, 1.857395>
    }
  }
  rotate <91.002113, 0.0, -135.0>
  translate  <34.016217, -44.481733, 10.817071>
}
#declare BezPtch030 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -8.065095, 2.741868>, <-0.165642, -8.065095, 2.741868>, <0.000000, -8.065095, 2.741868>, <0.165642, -8.065095, 2.741868>, 
      <-0.333985, -7.937644, 0.088447>, <-0.168343, -7.937644, 0.088447>, <-0.002700, -7.937644, 0.088447>, <0.162942, -7.937644, 0.088447>, 
      <-0.331285, -6.154882, 0.353789>, <-0.165642, -6.154882, 0.353789>, <0.000000, -6.154882, 0.353789>, <0.165642, -6.154882, 0.353789>, 
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>, 
      <-0.331285, -3.705948, 0.353789>, <-0.165642, -3.705948, 0.353789>, <0.000000, -3.705948, 0.353789>, <0.165642, -3.705948, 0.353789>, 
      <-0.331285, -4.052750, 3.184105>, <-0.165642, -4.052750, 3.184105>, <0.000000, -4.052750, 3.184105>, <0.165642, -4.052750, 3.184105>, 
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>, 
      <-0.331285, 1.269360, 3.537894>, <-0.165642, 1.269360, 3.537894>, <0.000000, 1.269360, 3.537894>, <0.165642, 1.269360, 3.537894>, 
      <-0.331285, 1.461279, 0.000000>, <-0.165642, 1.461279, 0.000000>, <0.000000, 1.461279, 0.000000>, <0.165642, 1.461279, 0.000000>, 
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>, 
      <-0.331285, 3.820426, -0.088447>, <-0.165642, 3.820426, -0.088447>, <0.000000, 3.820426, -0.088447>, <0.165642, 3.820426, -0.088447>, 
      <-0.331285, 5.000000, 0.088447>, <-0.165642, 5.000000, 0.088447>, <0.000000, 5.000000, 0.088447>, <0.165642, 5.000000, 0.088447>, 
      <-0.331285, 5.012346, 1.857395>, <-0.165642, 5.012346, 1.857395>, <0.000000, 5.012346, 1.857395>, <0.165642, 5.012346, 1.857395>
    }
  }
  rotate <91.002113, 0.0, -90.0>
  translate  <33.407814, -45.17705, 10.817071>
}
#declare BezPtch031 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -8.065095, 2.741868>, <-0.165642, -8.065095, 2.741868>, <0.000000, -8.065095, 2.741868>, <0.165642, -8.065095, 2.741868>, 
      <-0.333985, -7.937644, 0.088447>, <-0.168343, -7.937644, 0.088447>, <-0.002700, -7.937644, 0.088447>, <0.162942, -7.937644, 0.088447>, 
      <-0.331285, -6.154882, 0.353789>, <-0.165642, -6.154882, 0.353789>, <0.000000, -6.154882, 0.353789>, <0.165642, -6.154882, 0.353789>, 
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>, 
      <-0.331285, -3.705948, 0.353789>, <-0.165642, -3.705948, 0.353789>, <0.000000, -3.705948, 0.353789>, <0.165642, -3.705948, 0.353789>, 
      <-0.331285, -4.052750, 3.184105>, <-0.165642, -4.052750, 3.184105>, <0.000000, -4.052750, 3.184105>, <0.165642, -4.052750, 3.184105>, 
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>, 
      <-0.331285, 1.269360, 3.537894>, <-0.165642, 1.269360, 3.537894>, <0.000000, 1.269360, 3.537894>, <0.165642, 1.269360, 3.537894>, 
      <-0.331285, 1.461279, 0.000000>, <-0.165642, 1.461279, 0.000000>, <0.000000, 1.461279, 0.000000>, <0.165642, 1.461279, 0.000000>, 
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>, 
      <-0.331285, 3.820426, -0.088447>, <-0.165642, 3.820426, -0.088447>, <0.000000, 3.820426, -0.088447>, <0.165642, 3.820426, -0.088447>, 
      <-0.331285, 5.000000, 0.088447>, <-0.165642, 5.000000, 0.088447>, <0.000000, 5.000000, 0.088447>, <0.165642, 5.000000, 0.088447>, 
      <-0.331285, 5.012346, 1.857395>, <-0.165642, 5.012346, 1.857395>, <0.000000, 5.012346, 1.857395>, <0.165642, 5.012346, 1.857395>
    }
  }
  rotate <91.002113, 0.0, -45.0>
  translate  <34.016217, -46.046196, 10.817071>
}
#declare BezPtch032 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -8.065095, 2.741868>, <-0.165642, -8.065095, 2.741868>, <0.000000, -8.065095, 2.741868>, <0.165642, -8.065095, 2.741868>, 
      <-0.333985, -7.937644, 0.088447>, <-0.168343, -7.937644, 0.088447>, <-0.002700, -7.937644, 0.088447>, <0.162942, -7.937644, 0.088447>, 
      <-0.331285, -6.154882, 0.353789>, <-0.165642, -6.154882, 0.353789>, <0.000000, -6.154882, 0.353789>, <0.165642, -6.154882, 0.353789>, 
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>, 
      <-0.331285, -3.705948, 0.353789>, <-0.165642, -3.705948, 0.353789>, <0.000000, -3.705948, 0.353789>, <0.165642, -3.705948, 0.353789>, 
      <-0.331285, -4.052750, 3.184105>, <-0.165642, -4.052750, 3.184105>, <0.000000, -4.052750, 3.184105>, <0.165642, -4.052750, 3.184105>, 
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>, 
      <-0.331285, 1.269360, 3.537894>, <-0.165642, 1.269360, 3.537894>, <0.000000, 1.269360, 3.537894>, <0.165642, 1.269360, 3.537894>, 
      <-0.331285, 1.461279, 0.000000>, <-0.165642, 1.461279, 0.000000>, <0.000000, 1.461279, 0.000000>, <0.165642, 1.461279, 0.000000>, 
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>, 
      <-0.331285, 3.820426, -0.088447>, <-0.165642, 3.820426, -0.088447>, <0.000000, 3.820426, -0.088447>, <0.165642, 3.820426, -0.088447>, 
      <-0.331285, 5.000000, 0.088447>, <-0.165642, 5.000000, 0.088447>, <0.000000, 5.000000, 0.088447>, <0.165642, 5.000000, 0.088447>, 
      <-0.331285, 5.012346, 1.857395>, <-0.165642, 5.012346, 1.857395>, <0.000000, 5.012346, 1.857395>, <0.165642, 5.012346, 1.857395>
    }
  }
  rotate <91.002113, 0.0, 0.0>
  translate  <35.233022, -46.567684, 10.817071>
}
#declare lamp3 = union {
  sphere { // Sphere007
    <0,0,0>,1
    material {
      Glass
    }
    hollow
    scale <5.0, 5.0, 3.261394>
    translate  <35.095907, -45.140268, 9.51724>
  }
  object { BezPtch025 }
  object { BezPtch026 }
  object { BezPtch027 }
  object { BezPtch028 }
  object { BezPtch029 }
  object { BezPtch030 }
  object { BezPtch031 }
  object { BezPtch032 }
  cone { // Cone007
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale 1.716519
    rotate <180.0, 0.0, 180.0>
    translate  <35.128593, -45.169069, 16.365649>
  }
  torus { // Torus041
    1.75, 0.25  rotate -x*90
    scale 1.091333
    rotate 0.0*x
    translate  <35.06776, -45.169069, 13.234877>
  }
  cylinder { // Cylndr166
    <0,0,1>, <0,0,0>, 1 
    scale 2.064656
    rotate 0.0*x
    translate  <35.268193, -45.169069, 4.005444>
  }
  torus { // Torus042
    1.75, 0.25  rotate -x*90
    scale 1.091333
    rotate 0.0*x
    translate  <35.128593, -45.169069, 14.2082>
  }
  cylinder { // Cylndr167
    <0,0,1>, <0,0,0>, 1 
    scale <0.333333, 0.333333, 20.0>
    rotate <180.0, -0.0, -180.0>
    translate  <35.009483, -44.966081, 35.268835>
  }
  cone { // Cone008
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale 2.465107
    rotate 0.0*y
    translate  <35.009391, -44.976931, 28.187788>
  }
  sphere { // Sphere020
    <0,0,0>,1
    material {
      lampwhite
    }
    no_shadow
    scale 0.734142
    rotate <-0.0, 0.0, -30.0>
    translate  <35.041314, -45.284038, 9.456169>
  }
  material {
    ironblack
  }
  scale 0.15
  rotate -90.0*z
  translate  <-12.578051, 10.375813, 16.133418>
}
#declare BezPtch033 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -8.065095, 2.741868>, <-0.165642, -8.065095, 2.741868>, <0.000000, -8.065095, 2.741868>, <0.165642, -8.065095, 2.741868>, 
      <-0.333985, -7.937644, 0.088447>, <-0.168343, -7.937644, 0.088447>, <-0.002700, -7.937644, 0.088447>, <0.162942, -7.937644, 0.088447>, 
      <-0.331285, -6.154882, 0.353789>, <-0.165642, -6.154882, 0.353789>, <0.000000, -6.154882, 0.353789>, <0.165642, -6.154882, 0.353789>, 
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>, 
      <-0.331285, -3.705948, 0.353789>, <-0.165642, -3.705948, 0.353789>, <0.000000, -3.705948, 0.353789>, <0.165642, -3.705948, 0.353789>, 
      <-0.331285, -4.052750, 3.184105>, <-0.165642, -4.052750, 3.184105>, <0.000000, -4.052750, 3.184105>, <0.165642, -4.052750, 3.184105>, 
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>, 
      <-0.331285, 1.269360, 3.537894>, <-0.165642, 1.269360, 3.537894>, <0.000000, 1.269360, 3.537894>, <0.165642, 1.269360, 3.537894>, 
      <-0.331285, 1.461279, 0.000000>, <-0.165642, 1.461279, 0.000000>, <0.000000, 1.461279, 0.000000>, <0.165642, 1.461279, 0.000000>, 
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>, 
      <-0.331285, 3.820426, -0.088447>, <-0.165642, 3.820426, -0.088447>, <0.000000, 3.820426, -0.088447>, <0.165642, 3.820426, -0.088447>, 
      <-0.331285, 5.000000, 0.088447>, <-0.165642, 5.000000, 0.088447>, <0.000000, 5.000000, 0.088447>, <0.165642, 5.000000, 0.088447>, 
      <-0.331285, 5.012346, 1.857395>, <-0.165642, 5.012346, 1.857395>, <0.000000, 5.012346, 1.857395>, <0.165642, 5.012346, 1.857395>
    }
  }
  rotate <91.002113, 0.0, 180.0>
  translate  <34.972278, -43.612587, 10.817071>
}
#declare BezPtch034 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -8.065095, 2.741868>, <-0.165642, -8.065095, 2.741868>, <0.000000, -8.065095, 2.741868>, <0.165642, -8.065095, 2.741868>, 
      <-0.333985, -7.937644, 0.088447>, <-0.168343, -7.937644, 0.088447>, <-0.002700, -7.937644, 0.088447>, <0.162942, -7.937644, 0.088447>, 
      <-0.331285, -6.154882, 0.353789>, <-0.165642, -6.154882, 0.353789>, <0.000000, -6.154882, 0.353789>, <0.165642, -6.154882, 0.353789>, 
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>, 
      <-0.331285, -3.705948, 0.353789>, <-0.165642, -3.705948, 0.353789>, <0.000000, -3.705948, 0.353789>, <0.165642, -3.705948, 0.353789>, 
      <-0.331285, -4.052750, 3.184105>, <-0.165642, -4.052750, 3.184105>, <0.000000, -4.052750, 3.184105>, <0.165642, -4.052750, 3.184105>, 
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>, 
      <-0.331285, 1.269360, 3.537894>, <-0.165642, 1.269360, 3.537894>, <0.000000, 1.269360, 3.537894>, <0.165642, 1.269360, 3.537894>, 
      <-0.331285, 1.461279, 0.000000>, <-0.165642, 1.461279, 0.000000>, <0.000000, 1.461279, 0.000000>, <0.165642, 1.461279, 0.000000>, 
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>, 
      <-0.331285, 3.820426, -0.088447>, <-0.165642, 3.820426, -0.088447>, <0.000000, 3.820426, -0.088447>, <0.165642, 3.820426, -0.088447>, 
      <-0.331285, 5.000000, 0.088447>, <-0.165642, 5.000000, 0.088447>, <0.000000, 5.000000, 0.088447>, <0.165642, 5.000000, 0.088447>, 
      <-0.331285, 5.012346, 1.857395>, <-0.165642, 5.012346, 1.857395>, <0.000000, 5.012346, 1.857395>, <0.165642, 5.012346, 1.857395>
    }
  }
  rotate <91.002113, 0.0, 90.0>
  translate  <36.710571, -44.916306, 10.817071>
}
#declare BezPtch035 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -8.065095, 2.741868>, <-0.165642, -8.065095, 2.741868>, <0.000000, -8.065095, 2.741868>, <0.165642, -8.065095, 2.741868>, 
      <-0.333985, -7.937644, 0.088447>, <-0.168343, -7.937644, 0.088447>, <-0.002700, -7.937644, 0.088447>, <0.162942, -7.937644, 0.088447>, 
      <-0.331285, -6.154882, 0.353789>, <-0.165642, -6.154882, 0.353789>, <0.000000, -6.154882, 0.353789>, <0.165642, -6.154882, 0.353789>, 
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>, 
      <-0.331285, -3.705948, 0.353789>, <-0.165642, -3.705948, 0.353789>, <0.000000, -3.705948, 0.353789>, <0.165642, -3.705948, 0.353789>, 
      <-0.331285, -4.052750, 3.184105>, <-0.165642, -4.052750, 3.184105>, <0.000000, -4.052750, 3.184105>, <0.165642, -4.052750, 3.184105>, 
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>, 
      <-0.331285, 1.269360, 3.537894>, <-0.165642, 1.269360, 3.537894>, <0.000000, 1.269360, 3.537894>, <0.165642, 1.269360, 3.537894>, 
      <-0.331285, 1.461279, 0.000000>, <-0.165642, 1.461279, 0.000000>, <0.000000, 1.461279, 0.000000>, <0.165642, 1.461279, 0.000000>, 
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>, 
      <-0.331285, 3.820426, -0.088447>, <-0.165642, 3.820426, -0.088447>, <0.000000, 3.820426, -0.088447>, <0.165642, 3.820426, -0.088447>, 
      <-0.331285, 5.000000, 0.088447>, <-0.165642, 5.000000, 0.088447>, <0.000000, 5.000000, 0.088447>, <0.165642, 5.000000, 0.088447>, 
      <-0.331285, 5.012346, 1.857395>, <-0.165642, 5.012346, 1.857395>, <0.000000, 5.012346, 1.857395>, <0.165642, 5.012346, 1.857395>
    }
  }
  rotate <91.002113, 0.0, 45.0>
  translate  <36.362912, -46.133111, 10.817071>
}
#declare BezPtch036 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -8.065095, 2.741868>, <-0.165642, -8.065095, 2.741868>, <0.000000, -8.065095, 2.741868>, <0.165642, -8.065095, 2.741868>, 
      <-0.333985, -7.937644, 0.088447>, <-0.168343, -7.937644, 0.088447>, <-0.002700, -7.937644, 0.088447>, <0.162942, -7.937644, 0.088447>, 
      <-0.331285, -6.154882, 0.353789>, <-0.165642, -6.154882, 0.353789>, <0.000000, -6.154882, 0.353789>, <0.165642, -6.154882, 0.353789>, 
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>, 
      <-0.331285, -3.705948, 0.353789>, <-0.165642, -3.705948, 0.353789>, <0.000000, -3.705948, 0.353789>, <0.165642, -3.705948, 0.353789>, 
      <-0.331285, -4.052750, 3.184105>, <-0.165642, -4.052750, 3.184105>, <0.000000, -4.052750, 3.184105>, <0.165642, -4.052750, 3.184105>, 
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>, 
      <-0.331285, 1.269360, 3.537894>, <-0.165642, 1.269360, 3.537894>, <0.000000, 1.269360, 3.537894>, <0.165642, 1.269360, 3.537894>, 
      <-0.331285, 1.461279, 0.000000>, <-0.165642, 1.461279, 0.000000>, <0.000000, 1.461279, 0.000000>, <0.165642, 1.461279, 0.000000>, 
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>, 
      <-0.331285, 3.820426, -0.088447>, <-0.165642, 3.820426, -0.088447>, <0.000000, 3.820426, -0.088447>, <0.165642, 3.820426, -0.088447>, 
      <-0.331285, 5.000000, 0.088447>, <-0.165642, 5.000000, 0.088447>, <0.000000, 5.000000, 0.088447>, <0.165642, 5.000000, 0.088447>, 
      <-0.331285, 5.012346, 1.857395>, <-0.165642, 5.012346, 1.857395>, <0.000000, 5.012346, 1.857395>, <0.165642, 5.012346, 1.857395>
    }
  }
  rotate <91.002113, 0.0, 135.0>
  translate  <36.189083, -44.134074, 10.817071>
}
#declare BezPtch037 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -8.065095, 2.741868>, <-0.165642, -8.065095, 2.741868>, <0.000000, -8.065095, 2.741868>, <0.165642, -8.065095, 2.741868>, 
      <-0.333985, -7.937644, 0.088447>, <-0.168343, -7.937644, 0.088447>, <-0.002700, -7.937644, 0.088447>, <0.162942, -7.937644, 0.088447>, 
      <-0.331285, -6.154882, 0.353789>, <-0.165642, -6.154882, 0.353789>, <0.000000, -6.154882, 0.353789>, <0.165642, -6.154882, 0.353789>, 
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>, 
      <-0.331285, -3.705948, 0.353789>, <-0.165642, -3.705948, 0.353789>, <0.000000, -3.705948, 0.353789>, <0.165642, -3.705948, 0.353789>, 
      <-0.331285, -4.052750, 3.184105>, <-0.165642, -4.052750, 3.184105>, <0.000000, -4.052750, 3.184105>, <0.165642, -4.052750, 3.184105>, 
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>, 
      <-0.331285, 1.269360, 3.537894>, <-0.165642, 1.269360, 3.537894>, <0.000000, 1.269360, 3.537894>, <0.165642, 1.269360, 3.537894>, 
      <-0.331285, 1.461279, 0.000000>, <-0.165642, 1.461279, 0.000000>, <0.000000, 1.461279, 0.000000>, <0.165642, 1.461279, 0.000000>, 
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>, 
      <-0.331285, 3.820426, -0.088447>, <-0.165642, 3.820426, -0.088447>, <0.000000, 3.820426, -0.088447>, <0.165642, 3.820426, -0.088447>, 
      <-0.331285, 5.000000, 0.088447>, <-0.165642, 5.000000, 0.088447>, <0.000000, 5.000000, 0.088447>, <0.165642, 5.000000, 0.088447>, 
      <-0.331285, 5.012346, 1.857395>, <-0.165642, 5.012346, 1.857395>, <0.000000, 5.012346, 1.857395>, <0.165642, 5.012346, 1.857395>
    }
  }
  rotate <91.002113, 0.0, -135.0>
  translate  <34.016217, -44.481733, 10.817071>
}
#declare BezPtch038 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -8.065095, 2.741868>, <-0.165642, -8.065095, 2.741868>, <0.000000, -8.065095, 2.741868>, <0.165642, -8.065095, 2.741868>, 
      <-0.333985, -7.937644, 0.088447>, <-0.168343, -7.937644, 0.088447>, <-0.002700, -7.937644, 0.088447>, <0.162942, -7.937644, 0.088447>, 
      <-0.331285, -6.154882, 0.353789>, <-0.165642, -6.154882, 0.353789>, <0.000000, -6.154882, 0.353789>, <0.165642, -6.154882, 0.353789>, 
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>, 
      <-0.331285, -3.705948, 0.353789>, <-0.165642, -3.705948, 0.353789>, <0.000000, -3.705948, 0.353789>, <0.165642, -3.705948, 0.353789>, 
      <-0.331285, -4.052750, 3.184105>, <-0.165642, -4.052750, 3.184105>, <0.000000, -4.052750, 3.184105>, <0.165642, -4.052750, 3.184105>, 
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>, 
      <-0.331285, 1.269360, 3.537894>, <-0.165642, 1.269360, 3.537894>, <0.000000, 1.269360, 3.537894>, <0.165642, 1.269360, 3.537894>, 
      <-0.331285, 1.461279, 0.000000>, <-0.165642, 1.461279, 0.000000>, <0.000000, 1.461279, 0.000000>, <0.165642, 1.461279, 0.000000>, 
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>, 
      <-0.331285, 3.820426, -0.088447>, <-0.165642, 3.820426, -0.088447>, <0.000000, 3.820426, -0.088447>, <0.165642, 3.820426, -0.088447>, 
      <-0.331285, 5.000000, 0.088447>, <-0.165642, 5.000000, 0.088447>, <0.000000, 5.000000, 0.088447>, <0.165642, 5.000000, 0.088447>, 
      <-0.331285, 5.012346, 1.857395>, <-0.165642, 5.012346, 1.857395>, <0.000000, 5.012346, 1.857395>, <0.165642, 5.012346, 1.857395>
    }
  }
  rotate <91.002113, 0.0, -90.0>
  translate  <33.407814, -45.17705, 10.817071>
}
#declare BezPtch039 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -8.065095, 2.741868>, <-0.165642, -8.065095, 2.741868>, <0.000000, -8.065095, 2.741868>, <0.165642, -8.065095, 2.741868>, 
      <-0.333985, -7.937644, 0.088447>, <-0.168343, -7.937644, 0.088447>, <-0.002700, -7.937644, 0.088447>, <0.162942, -7.937644, 0.088447>, 
      <-0.331285, -6.154882, 0.353789>, <-0.165642, -6.154882, 0.353789>, <0.000000, -6.154882, 0.353789>, <0.165642, -6.154882, 0.353789>, 
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>, 
      <-0.331285, -3.705948, 0.353789>, <-0.165642, -3.705948, 0.353789>, <0.000000, -3.705948, 0.353789>, <0.165642, -3.705948, 0.353789>, 
      <-0.331285, -4.052750, 3.184105>, <-0.165642, -4.052750, 3.184105>, <0.000000, -4.052750, 3.184105>, <0.165642, -4.052750, 3.184105>, 
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>, 
      <-0.331285, 1.269360, 3.537894>, <-0.165642, 1.269360, 3.537894>, <0.000000, 1.269360, 3.537894>, <0.165642, 1.269360, 3.537894>, 
      <-0.331285, 1.461279, 0.000000>, <-0.165642, 1.461279, 0.000000>, <0.000000, 1.461279, 0.000000>, <0.165642, 1.461279, 0.000000>, 
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>, 
      <-0.331285, 3.820426, -0.088447>, <-0.165642, 3.820426, -0.088447>, <0.000000, 3.820426, -0.088447>, <0.165642, 3.820426, -0.088447>, 
      <-0.331285, 5.000000, 0.088447>, <-0.165642, 5.000000, 0.088447>, <0.000000, 5.000000, 0.088447>, <0.165642, 5.000000, 0.088447>, 
      <-0.331285, 5.012346, 1.857395>, <-0.165642, 5.012346, 1.857395>, <0.000000, 5.012346, 1.857395>, <0.165642, 5.012346, 1.857395>
    }
  }
  rotate <91.002113, 0.0, -45.0>
  translate  <34.016217, -46.046196, 10.817071>
}
#declare BezPtch040 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -8.065095, 2.741868>, <-0.165642, -8.065095, 2.741868>, <0.000000, -8.065095, 2.741868>, <0.165642, -8.065095, 2.741868>, 
      <-0.333985, -7.937644, 0.088447>, <-0.168343, -7.937644, 0.088447>, <-0.002700, -7.937644, 0.088447>, <0.162942, -7.937644, 0.088447>, 
      <-0.331285, -6.154882, 0.353789>, <-0.165642, -6.154882, 0.353789>, <0.000000, -6.154882, 0.353789>, <0.165642, -6.154882, 0.353789>, 
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>, 
      <-0.331285, -3.705948, 0.353789>, <-0.165642, -3.705948, 0.353789>, <0.000000, -3.705948, 0.353789>, <0.165642, -3.705948, 0.353789>, 
      <-0.331285, -4.052750, 3.184105>, <-0.165642, -4.052750, 3.184105>, <0.000000, -4.052750, 3.184105>, <0.165642, -4.052750, 3.184105>, 
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>, 
      <-0.331285, 1.269360, 3.537894>, <-0.165642, 1.269360, 3.537894>, <0.000000, 1.269360, 3.537894>, <0.165642, 1.269360, 3.537894>, 
      <-0.331285, 1.461279, 0.000000>, <-0.165642, 1.461279, 0.000000>, <0.000000, 1.461279, 0.000000>, <0.165642, 1.461279, 0.000000>, 
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>, 
      <-0.331285, 3.820426, -0.088447>, <-0.165642, 3.820426, -0.088447>, <0.000000, 3.820426, -0.088447>, <0.165642, 3.820426, -0.088447>, 
      <-0.331285, 5.000000, 0.088447>, <-0.165642, 5.000000, 0.088447>, <0.000000, 5.000000, 0.088447>, <0.165642, 5.000000, 0.088447>, 
      <-0.331285, 5.012346, 1.857395>, <-0.165642, 5.012346, 1.857395>, <0.000000, 5.012346, 1.857395>, <0.165642, 5.012346, 1.857395>
    }
  }
  rotate <91.002113, 0.0, 0.0>
  translate  <35.233022, -46.567684, 10.817071>
}
#declare lamp4 = union {
  sphere { // Sphere008
    <0,0,0>,1
    material {
      Glass
    }
    hollow
    scale <5.0, 5.0, 3.261394>
    translate  <35.095907, -45.140268, 9.51724>
  }
  object { BezPtch033 }
  object { BezPtch034 }
  object { BezPtch035 }
  object { BezPtch036 }
  object { BezPtch037 }
  object { BezPtch038 }
  object { BezPtch039 }
  object { BezPtch040 }
  cone { // Cone009
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale 1.716519
    rotate <180.0, 0.0, 180.0>
    translate  <35.128593, -45.169069, 16.365649>
  }
  torus { // Torus043
    1.75, 0.25  rotate -x*90
    scale 1.091333
    rotate 0.0*x
    translate  <35.06776, -45.169069, 13.234877>
  }
  cylinder { // Cylndr168
    <0,0,1>, <0,0,0>, 1 
    scale 2.064656
    rotate 0.0*x
    translate  <35.268193, -45.169069, 4.005444>
  }
  torus { // Torus044
    1.75, 0.25  rotate -x*90
    scale 1.091333
    rotate 0.0*x
    translate  <35.128593, -45.169069, 14.2082>
  }
  cylinder { // Cylndr169
    <0,0,1>, <0,0,0>, 1 
    scale <0.333333, 0.333333, 20.0>
    rotate <180.0, -0.0, -180.0>
    translate  <35.009483, -44.966081, 35.268835>
  }
  cone { // Cone010
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale 2.465107
    rotate 0.0*y
    translate  <35.009391, -44.976931, 28.187788>
  }
  sphere { // Sphere021
    <0,0,0>,1
    material {
      lampwhite
    }
    no_shadow
    scale 0.734142
    rotate <-0.0, 0.0, -30.0>
    translate  <35.041314, -45.284038, 9.456169>
  }
  material {
    ironblack
  }
  scale 0.15
  rotate -120.0*z
  translate  <-5.705005, 15.274743, 16.133418>
}
#declare BezPtch041 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -8.065095, 2.741868>, <-0.165642, -8.065095, 2.741868>, <0.000000, -8.065095, 2.741868>, <0.165642, -8.065095, 2.741868>, 
      <-0.333985, -7.937644, 0.088447>, <-0.168343, -7.937644, 0.088447>, <-0.002700, -7.937644, 0.088447>, <0.162942, -7.937644, 0.088447>, 
      <-0.331285, -6.154882, 0.353789>, <-0.165642, -6.154882, 0.353789>, <0.000000, -6.154882, 0.353789>, <0.165642, -6.154882, 0.353789>, 
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>, 
      <-0.331285, -3.705948, 0.353789>, <-0.165642, -3.705948, 0.353789>, <0.000000, -3.705948, 0.353789>, <0.165642, -3.705948, 0.353789>, 
      <-0.331285, -4.052750, 3.184105>, <-0.165642, -4.052750, 3.184105>, <0.000000, -4.052750, 3.184105>, <0.165642, -4.052750, 3.184105>, 
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>, 
      <-0.331285, 1.269360, 3.537894>, <-0.165642, 1.269360, 3.537894>, <0.000000, 1.269360, 3.537894>, <0.165642, 1.269360, 3.537894>, 
      <-0.331285, 1.461279, 0.000000>, <-0.165642, 1.461279, 0.000000>, <0.000000, 1.461279, 0.000000>, <0.165642, 1.461279, 0.000000>, 
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>, 
      <-0.331285, 3.820426, -0.088447>, <-0.165642, 3.820426, -0.088447>, <0.000000, 3.820426, -0.088447>, <0.165642, 3.820426, -0.088447>, 
      <-0.331285, 5.000000, 0.088447>, <-0.165642, 5.000000, 0.088447>, <0.000000, 5.000000, 0.088447>, <0.165642, 5.000000, 0.088447>, 
      <-0.331285, 5.012346, 1.857395>, <-0.165642, 5.012346, 1.857395>, <0.000000, 5.012346, 1.857395>, <0.165642, 5.012346, 1.857395>
    }
  }
  rotate <91.002113, 0.0, 180.0>
  translate  <34.972278, -43.612587, 10.817071>
}
#declare BezPtch042 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -8.065095, 2.741868>, <-0.165642, -8.065095, 2.741868>, <0.000000, -8.065095, 2.741868>, <0.165642, -8.065095, 2.741868>, 
      <-0.333985, -7.937644, 0.088447>, <-0.168343, -7.937644, 0.088447>, <-0.002700, -7.937644, 0.088447>, <0.162942, -7.937644, 0.088447>, 
      <-0.331285, -6.154882, 0.353789>, <-0.165642, -6.154882, 0.353789>, <0.000000, -6.154882, 0.353789>, <0.165642, -6.154882, 0.353789>, 
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>, 
      <-0.331285, -3.705948, 0.353789>, <-0.165642, -3.705948, 0.353789>, <0.000000, -3.705948, 0.353789>, <0.165642, -3.705948, 0.353789>, 
      <-0.331285, -4.052750, 3.184105>, <-0.165642, -4.052750, 3.184105>, <0.000000, -4.052750, 3.184105>, <0.165642, -4.052750, 3.184105>, 
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>, 
      <-0.331285, 1.269360, 3.537894>, <-0.165642, 1.269360, 3.537894>, <0.000000, 1.269360, 3.537894>, <0.165642, 1.269360, 3.537894>, 
      <-0.331285, 1.461279, 0.000000>, <-0.165642, 1.461279, 0.000000>, <0.000000, 1.461279, 0.000000>, <0.165642, 1.461279, 0.000000>, 
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>, 
      <-0.331285, 3.820426, -0.088447>, <-0.165642, 3.820426, -0.088447>, <0.000000, 3.820426, -0.088447>, <0.165642, 3.820426, -0.088447>, 
      <-0.331285, 5.000000, 0.088447>, <-0.165642, 5.000000, 0.088447>, <0.000000, 5.000000, 0.088447>, <0.165642, 5.000000, 0.088447>, 
      <-0.331285, 5.012346, 1.857395>, <-0.165642, 5.012346, 1.857395>, <0.000000, 5.012346, 1.857395>, <0.165642, 5.012346, 1.857395>
    }
  }
  rotate <91.002113, 0.0, 90.0>
  translate  <36.710571, -44.916306, 10.817071>
}
#declare BezPtch043 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -8.065095, 2.741868>, <-0.165642, -8.065095, 2.741868>, <0.000000, -8.065095, 2.741868>, <0.165642, -8.065095, 2.741868>, 
      <-0.333985, -7.937644, 0.088447>, <-0.168343, -7.937644, 0.088447>, <-0.002700, -7.937644, 0.088447>, <0.162942, -7.937644, 0.088447>, 
      <-0.331285, -6.154882, 0.353789>, <-0.165642, -6.154882, 0.353789>, <0.000000, -6.154882, 0.353789>, <0.165642, -6.154882, 0.353789>, 
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>, 
      <-0.331285, -3.705948, 0.353789>, <-0.165642, -3.705948, 0.353789>, <0.000000, -3.705948, 0.353789>, <0.165642, -3.705948, 0.353789>, 
      <-0.331285, -4.052750, 3.184105>, <-0.165642, -4.052750, 3.184105>, <0.000000, -4.052750, 3.184105>, <0.165642, -4.052750, 3.184105>, 
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>, 
      <-0.331285, 1.269360, 3.537894>, <-0.165642, 1.269360, 3.537894>, <0.000000, 1.269360, 3.537894>, <0.165642, 1.269360, 3.537894>, 
      <-0.331285, 1.461279, 0.000000>, <-0.165642, 1.461279, 0.000000>, <0.000000, 1.461279, 0.000000>, <0.165642, 1.461279, 0.000000>, 
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>, 
      <-0.331285, 3.820426, -0.088447>, <-0.165642, 3.820426, -0.088447>, <0.000000, 3.820426, -0.088447>, <0.165642, 3.820426, -0.088447>, 
      <-0.331285, 5.000000, 0.088447>, <-0.165642, 5.000000, 0.088447>, <0.000000, 5.000000, 0.088447>, <0.165642, 5.000000, 0.088447>, 
      <-0.331285, 5.012346, 1.857395>, <-0.165642, 5.012346, 1.857395>, <0.000000, 5.012346, 1.857395>, <0.165642, 5.012346, 1.857395>
    }
  }
  rotate <91.002113, 0.0, 45.0>
  translate  <36.362912, -46.133111, 10.817071>
}
#declare BezPtch044 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -8.065095, 2.741868>, <-0.165642, -8.065095, 2.741868>, <0.000000, -8.065095, 2.741868>, <0.165642, -8.065095, 2.741868>, 
      <-0.333985, -7.937644, 0.088447>, <-0.168343, -7.937644, 0.088447>, <-0.002700, -7.937644, 0.088447>, <0.162942, -7.937644, 0.088447>, 
      <-0.331285, -6.154882, 0.353789>, <-0.165642, -6.154882, 0.353789>, <0.000000, -6.154882, 0.353789>, <0.165642, -6.154882, 0.353789>, 
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>, 
      <-0.331285, -3.705948, 0.353789>, <-0.165642, -3.705948, 0.353789>, <0.000000, -3.705948, 0.353789>, <0.165642, -3.705948, 0.353789>, 
      <-0.331285, -4.052750, 3.184105>, <-0.165642, -4.052750, 3.184105>, <0.000000, -4.052750, 3.184105>, <0.165642, -4.052750, 3.184105>, 
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>, 
      <-0.331285, 1.269360, 3.537894>, <-0.165642, 1.269360, 3.537894>, <0.000000, 1.269360, 3.537894>, <0.165642, 1.269360, 3.537894>, 
      <-0.331285, 1.461279, 0.000000>, <-0.165642, 1.461279, 0.000000>, <0.000000, 1.461279, 0.000000>, <0.165642, 1.461279, 0.000000>, 
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>, 
      <-0.331285, 3.820426, -0.088447>, <-0.165642, 3.820426, -0.088447>, <0.000000, 3.820426, -0.088447>, <0.165642, 3.820426, -0.088447>, 
      <-0.331285, 5.000000, 0.088447>, <-0.165642, 5.000000, 0.088447>, <0.000000, 5.000000, 0.088447>, <0.165642, 5.000000, 0.088447>, 
      <-0.331285, 5.012346, 1.857395>, <-0.165642, 5.012346, 1.857395>, <0.000000, 5.012346, 1.857395>, <0.165642, 5.012346, 1.857395>
    }
  }
  rotate <91.002113, 0.0, 135.0>
  translate  <36.189083, -44.134074, 10.817071>
}
#declare BezPtch045 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -8.065095, 2.741868>, <-0.165642, -8.065095, 2.741868>, <0.000000, -8.065095, 2.741868>, <0.165642, -8.065095, 2.741868>, 
      <-0.333985, -7.937644, 0.088447>, <-0.168343, -7.937644, 0.088447>, <-0.002700, -7.937644, 0.088447>, <0.162942, -7.937644, 0.088447>, 
      <-0.331285, -6.154882, 0.353789>, <-0.165642, -6.154882, 0.353789>, <0.000000, -6.154882, 0.353789>, <0.165642, -6.154882, 0.353789>, 
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>, 
      <-0.331285, -3.705948, 0.353789>, <-0.165642, -3.705948, 0.353789>, <0.000000, -3.705948, 0.353789>, <0.165642, -3.705948, 0.353789>, 
      <-0.331285, -4.052750, 3.184105>, <-0.165642, -4.052750, 3.184105>, <0.000000, -4.052750, 3.184105>, <0.165642, -4.052750, 3.184105>, 
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>, 
      <-0.331285, 1.269360, 3.537894>, <-0.165642, 1.269360, 3.537894>, <0.000000, 1.269360, 3.537894>, <0.165642, 1.269360, 3.537894>, 
      <-0.331285, 1.461279, 0.000000>, <-0.165642, 1.461279, 0.000000>, <0.000000, 1.461279, 0.000000>, <0.165642, 1.461279, 0.000000>, 
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>, 
      <-0.331285, 3.820426, -0.088447>, <-0.165642, 3.820426, -0.088447>, <0.000000, 3.820426, -0.088447>, <0.165642, 3.820426, -0.088447>, 
      <-0.331285, 5.000000, 0.088447>, <-0.165642, 5.000000, 0.088447>, <0.000000, 5.000000, 0.088447>, <0.165642, 5.000000, 0.088447>, 
      <-0.331285, 5.012346, 1.857395>, <-0.165642, 5.012346, 1.857395>, <0.000000, 5.012346, 1.857395>, <0.165642, 5.012346, 1.857395>
    }
  }
  rotate <91.002113, 0.0, -135.0>
  translate  <34.016217, -44.481733, 10.817071>
}
#declare BezPtch046 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -8.065095, 2.741868>, <-0.165642, -8.065095, 2.741868>, <0.000000, -8.065095, 2.741868>, <0.165642, -8.065095, 2.741868>, 
      <-0.333985, -7.937644, 0.088447>, <-0.168343, -7.937644, 0.088447>, <-0.002700, -7.937644, 0.088447>, <0.162942, -7.937644, 0.088447>, 
      <-0.331285, -6.154882, 0.353789>, <-0.165642, -6.154882, 0.353789>, <0.000000, -6.154882, 0.353789>, <0.165642, -6.154882, 0.353789>, 
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>, 
      <-0.331285, -3.705948, 0.353789>, <-0.165642, -3.705948, 0.353789>, <0.000000, -3.705948, 0.353789>, <0.165642, -3.705948, 0.353789>, 
      <-0.331285, -4.052750, 3.184105>, <-0.165642, -4.052750, 3.184105>, <0.000000, -4.052750, 3.184105>, <0.165642, -4.052750, 3.184105>, 
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>, 
      <-0.331285, 1.269360, 3.537894>, <-0.165642, 1.269360, 3.537894>, <0.000000, 1.269360, 3.537894>, <0.165642, 1.269360, 3.537894>, 
      <-0.331285, 1.461279, 0.000000>, <-0.165642, 1.461279, 0.000000>, <0.000000, 1.461279, 0.000000>, <0.165642, 1.461279, 0.000000>, 
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>, 
      <-0.331285, 3.820426, -0.088447>, <-0.165642, 3.820426, -0.088447>, <0.000000, 3.820426, -0.088447>, <0.165642, 3.820426, -0.088447>, 
      <-0.331285, 5.000000, 0.088447>, <-0.165642, 5.000000, 0.088447>, <0.000000, 5.000000, 0.088447>, <0.165642, 5.000000, 0.088447>, 
      <-0.331285, 5.012346, 1.857395>, <-0.165642, 5.012346, 1.857395>, <0.000000, 5.012346, 1.857395>, <0.165642, 5.012346, 1.857395>
    }
  }
  rotate <91.002113, 0.0, -90.0>
  translate  <33.407814, -45.17705, 10.817071>
}
#declare BezPtch047 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -8.065095, 2.741868>, <-0.165642, -8.065095, 2.741868>, <0.000000, -8.065095, 2.741868>, <0.165642, -8.065095, 2.741868>, 
      <-0.333985, -7.937644, 0.088447>, <-0.168343, -7.937644, 0.088447>, <-0.002700, -7.937644, 0.088447>, <0.162942, -7.937644, 0.088447>, 
      <-0.331285, -6.154882, 0.353789>, <-0.165642, -6.154882, 0.353789>, <0.000000, -6.154882, 0.353789>, <0.165642, -6.154882, 0.353789>, 
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>, 
      <-0.331285, -3.705948, 0.353789>, <-0.165642, -3.705948, 0.353789>, <0.000000, -3.705948, 0.353789>, <0.165642, -3.705948, 0.353789>, 
      <-0.331285, -4.052750, 3.184105>, <-0.165642, -4.052750, 3.184105>, <0.000000, -4.052750, 3.184105>, <0.165642, -4.052750, 3.184105>, 
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>, 
      <-0.331285, 1.269360, 3.537894>, <-0.165642, 1.269360, 3.537894>, <0.000000, 1.269360, 3.537894>, <0.165642, 1.269360, 3.537894>, 
      <-0.331285, 1.461279, 0.000000>, <-0.165642, 1.461279, 0.000000>, <0.000000, 1.461279, 0.000000>, <0.165642, 1.461279, 0.000000>, 
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>, 
      <-0.331285, 3.820426, -0.088447>, <-0.165642, 3.820426, -0.088447>, <0.000000, 3.820426, -0.088447>, <0.165642, 3.820426, -0.088447>, 
      <-0.331285, 5.000000, 0.088447>, <-0.165642, 5.000000, 0.088447>, <0.000000, 5.000000, 0.088447>, <0.165642, 5.000000, 0.088447>, 
      <-0.331285, 5.012346, 1.857395>, <-0.165642, 5.012346, 1.857395>, <0.000000, 5.012346, 1.857395>, <0.165642, 5.012346, 1.857395>
    }
  }
  rotate <91.002113, 0.0, -45.0>
  translate  <34.016217, -46.046196, 10.817071>
}
#declare BezPtch048 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -8.065095, 2.741868>, <-0.165642, -8.065095, 2.741868>, <0.000000, -8.065095, 2.741868>, <0.165642, -8.065095, 2.741868>, 
      <-0.333985, -7.937644, 0.088447>, <-0.168343, -7.937644, 0.088447>, <-0.002700, -7.937644, 0.088447>, <0.162942, -7.937644, 0.088447>, 
      <-0.331285, -6.154882, 0.353789>, <-0.165642, -6.154882, 0.353789>, <0.000000, -6.154882, 0.353789>, <0.165642, -6.154882, 0.353789>, 
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>, 
      <-0.331285, -3.705948, 0.353789>, <-0.165642, -3.705948, 0.353789>, <0.000000, -3.705948, 0.353789>, <0.165642, -3.705948, 0.353789>, 
      <-0.331285, -4.052750, 3.184105>, <-0.165642, -4.052750, 3.184105>, <0.000000, -4.052750, 3.184105>, <0.165642, -4.052750, 3.184105>, 
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>, 
      <-0.331285, 1.269360, 3.537894>, <-0.165642, 1.269360, 3.537894>, <0.000000, 1.269360, 3.537894>, <0.165642, 1.269360, 3.537894>, 
      <-0.331285, 1.461279, 0.000000>, <-0.165642, 1.461279, 0.000000>, <0.000000, 1.461279, 0.000000>, <0.165642, 1.461279, 0.000000>, 
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>, 
      <-0.331285, 3.820426, -0.088447>, <-0.165642, 3.820426, -0.088447>, <0.000000, 3.820426, -0.088447>, <0.165642, 3.820426, -0.088447>, 
      <-0.331285, 5.000000, 0.088447>, <-0.165642, 5.000000, 0.088447>, <0.000000, 5.000000, 0.088447>, <0.165642, 5.000000, 0.088447>, 
      <-0.331285, 5.012346, 1.857395>, <-0.165642, 5.012346, 1.857395>, <0.000000, 5.012346, 1.857395>, <0.165642, 5.012346, 1.857395>
    }
  }
  rotate <91.002113, 0.0, 0.0>
  translate  <35.233022, -46.567684, 10.817071>
}
#declare lamp5 = union {
  sphere { // Sphere009
    <0,0,0>,1
    material {
      Glass
    }
    hollow
    scale <5.0, 5.0, 3.261394>
    translate  <35.095907, -45.140268, 9.51724>
  }
  object { BezPtch041 }
  object { BezPtch042 }
  object { BezPtch043 }
  object { BezPtch044 }
  object { BezPtch045 }
  object { BezPtch046 }
  object { BezPtch047 }
  object { BezPtch048 }
  cone { // Cone011
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale 1.716519
    rotate <180.0, 0.0, 180.0>
    translate  <35.128593, -45.169069, 16.365649>
  }
  torus { // Torus045
    1.75, 0.25  rotate -x*90
    scale 1.091333
    rotate 0.0*x
    translate  <35.06776, -45.169069, 13.234877>
  }
  cylinder { // Cylndr170
    <0,0,1>, <0,0,0>, 1 
    scale 2.064656
    rotate 0.0*x
    translate  <35.268193, -45.169069, 4.005444>
  }
  torus { // Torus046
    1.75, 0.25  rotate -x*90
    scale 1.091333
    rotate 0.0*x
    translate  <35.128593, -45.169069, 14.2082>
  }
  cylinder { // Cylndr171
    <0,0,1>, <0,0,0>, 1 
    scale <0.333333, 0.333333, 20.0>
    rotate <180.0, -0.0, -180.0>
    translate  <35.009483, -44.966081, 35.268835>
  }
  cone { // Cone012
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale 2.465107
    rotate 0.0*y
    translate  <35.009391, -44.976931, 28.187788>
  }
  sphere { // Sphere022
    <0,0,0>,1
    material {
      lampwhite
    }
    no_shadow
    scale 0.734142
    rotate <-0.0, 0.0, -30.0>
    translate  <35.041314, -45.284038, 9.456169>
  }
  material {
    ironblack
  }
  scale 0.15
  rotate -150.0*z
  translate  <2.696693, 16.080818, 16.133418>
}
#declare BezPtch049 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -8.065095, 2.741868>, <-0.165642, -8.065095, 2.741868>, <0.000000, -8.065095, 2.741868>, <0.165642, -8.065095, 2.741868>, 
      <-0.333985, -7.937644, 0.088447>, <-0.168343, -7.937644, 0.088447>, <-0.002700, -7.937644, 0.088447>, <0.162942, -7.937644, 0.088447>, 
      <-0.331285, -6.154882, 0.353789>, <-0.165642, -6.154882, 0.353789>, <0.000000, -6.154882, 0.353789>, <0.165642, -6.154882, 0.353789>, 
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>, 
      <-0.331285, -3.705948, 0.353789>, <-0.165642, -3.705948, 0.353789>, <0.000000, -3.705948, 0.353789>, <0.165642, -3.705948, 0.353789>, 
      <-0.331285, -4.052750, 3.184105>, <-0.165642, -4.052750, 3.184105>, <0.000000, -4.052750, 3.184105>, <0.165642, -4.052750, 3.184105>, 
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>, 
      <-0.331285, 1.269360, 3.537894>, <-0.165642, 1.269360, 3.537894>, <0.000000, 1.269360, 3.537894>, <0.165642, 1.269360, 3.537894>, 
      <-0.331285, 1.461279, 0.000000>, <-0.165642, 1.461279, 0.000000>, <0.000000, 1.461279, 0.000000>, <0.165642, 1.461279, 0.000000>, 
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>, 
      <-0.331285, 3.820426, -0.088447>, <-0.165642, 3.820426, -0.088447>, <0.000000, 3.820426, -0.088447>, <0.165642, 3.820426, -0.088447>, 
      <-0.331285, 5.000000, 0.088447>, <-0.165642, 5.000000, 0.088447>, <0.000000, 5.000000, 0.088447>, <0.165642, 5.000000, 0.088447>, 
      <-0.331285, 5.012346, 1.857395>, <-0.165642, 5.012346, 1.857395>, <0.000000, 5.012346, 1.857395>, <0.165642, 5.012346, 1.857395>
    }
  }
  rotate <91.002113, 0.0, 180.0>
  translate  <34.972278, -43.612587, 10.817071>
}
#declare BezPtch050 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -8.065095, 2.741868>, <-0.165642, -8.065095, 2.741868>, <0.000000, -8.065095, 2.741868>, <0.165642, -8.065095, 2.741868>, 
      <-0.333985, -7.937644, 0.088447>, <-0.168343, -7.937644, 0.088447>, <-0.002700, -7.937644, 0.088447>, <0.162942, -7.937644, 0.088447>, 
      <-0.331285, -6.154882, 0.353789>, <-0.165642, -6.154882, 0.353789>, <0.000000, -6.154882, 0.353789>, <0.165642, -6.154882, 0.353789>, 
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>, 
      <-0.331285, -3.705948, 0.353789>, <-0.165642, -3.705948, 0.353789>, <0.000000, -3.705948, 0.353789>, <0.165642, -3.705948, 0.353789>, 
      <-0.331285, -4.052750, 3.184105>, <-0.165642, -4.052750, 3.184105>, <0.000000, -4.052750, 3.184105>, <0.165642, -4.052750, 3.184105>, 
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>, 
      <-0.331285, 1.269360, 3.537894>, <-0.165642, 1.269360, 3.537894>, <0.000000, 1.269360, 3.537894>, <0.165642, 1.269360, 3.537894>, 
      <-0.331285, 1.461279, 0.000000>, <-0.165642, 1.461279, 0.000000>, <0.000000, 1.461279, 0.000000>, <0.165642, 1.461279, 0.000000>, 
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>, 
      <-0.331285, 3.820426, -0.088447>, <-0.165642, 3.820426, -0.088447>, <0.000000, 3.820426, -0.088447>, <0.165642, 3.820426, -0.088447>, 
      <-0.331285, 5.000000, 0.088447>, <-0.165642, 5.000000, 0.088447>, <0.000000, 5.000000, 0.088447>, <0.165642, 5.000000, 0.088447>, 
      <-0.331285, 5.012346, 1.857395>, <-0.165642, 5.012346, 1.857395>, <0.000000, 5.012346, 1.857395>, <0.165642, 5.012346, 1.857395>
    }
  }
  rotate <91.002113, 0.0, 90.0>
  translate  <36.710571, -44.916306, 10.817071>
}
#declare BezPtch051 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -8.065095, 2.741868>, <-0.165642, -8.065095, 2.741868>, <0.000000, -8.065095, 2.741868>, <0.165642, -8.065095, 2.741868>, 
      <-0.333985, -7.937644, 0.088447>, <-0.168343, -7.937644, 0.088447>, <-0.002700, -7.937644, 0.088447>, <0.162942, -7.937644, 0.088447>, 
      <-0.331285, -6.154882, 0.353789>, <-0.165642, -6.154882, 0.353789>, <0.000000, -6.154882, 0.353789>, <0.165642, -6.154882, 0.353789>, 
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>, 
      <-0.331285, -3.705948, 0.353789>, <-0.165642, -3.705948, 0.353789>, <0.000000, -3.705948, 0.353789>, <0.165642, -3.705948, 0.353789>, 
      <-0.331285, -4.052750, 3.184105>, <-0.165642, -4.052750, 3.184105>, <0.000000, -4.052750, 3.184105>, <0.165642, -4.052750, 3.184105>, 
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>, 
      <-0.331285, 1.269360, 3.537894>, <-0.165642, 1.269360, 3.537894>, <0.000000, 1.269360, 3.537894>, <0.165642, 1.269360, 3.537894>, 
      <-0.331285, 1.461279, 0.000000>, <-0.165642, 1.461279, 0.000000>, <0.000000, 1.461279, 0.000000>, <0.165642, 1.461279, 0.000000>, 
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>, 
      <-0.331285, 3.820426, -0.088447>, <-0.165642, 3.820426, -0.088447>, <0.000000, 3.820426, -0.088447>, <0.165642, 3.820426, -0.088447>, 
      <-0.331285, 5.000000, 0.088447>, <-0.165642, 5.000000, 0.088447>, <0.000000, 5.000000, 0.088447>, <0.165642, 5.000000, 0.088447>, 
      <-0.331285, 5.012346, 1.857395>, <-0.165642, 5.012346, 1.857395>, <0.000000, 5.012346, 1.857395>, <0.165642, 5.012346, 1.857395>
    }
  }
  rotate <91.002113, 0.0, 45.0>
  translate  <36.362912, -46.133111, 10.817071>
}
#declare BezPtch052 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -8.065095, 2.741868>, <-0.165642, -8.065095, 2.741868>, <0.000000, -8.065095, 2.741868>, <0.165642, -8.065095, 2.741868>, 
      <-0.333985, -7.937644, 0.088447>, <-0.168343, -7.937644, 0.088447>, <-0.002700, -7.937644, 0.088447>, <0.162942, -7.937644, 0.088447>, 
      <-0.331285, -6.154882, 0.353789>, <-0.165642, -6.154882, 0.353789>, <0.000000, -6.154882, 0.353789>, <0.165642, -6.154882, 0.353789>, 
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>, 
      <-0.331285, -3.705948, 0.353789>, <-0.165642, -3.705948, 0.353789>, <0.000000, -3.705948, 0.353789>, <0.165642, -3.705948, 0.353789>, 
      <-0.331285, -4.052750, 3.184105>, <-0.165642, -4.052750, 3.184105>, <0.000000, -4.052750, 3.184105>, <0.165642, -4.052750, 3.184105>, 
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>, 
      <-0.331285, 1.269360, 3.537894>, <-0.165642, 1.269360, 3.537894>, <0.000000, 1.269360, 3.537894>, <0.165642, 1.269360, 3.537894>, 
      <-0.331285, 1.461279, 0.000000>, <-0.165642, 1.461279, 0.000000>, <0.000000, 1.461279, 0.000000>, <0.165642, 1.461279, 0.000000>, 
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>, 
      <-0.331285, 3.820426, -0.088447>, <-0.165642, 3.820426, -0.088447>, <0.000000, 3.820426, -0.088447>, <0.165642, 3.820426, -0.088447>, 
      <-0.331285, 5.000000, 0.088447>, <-0.165642, 5.000000, 0.088447>, <0.000000, 5.000000, 0.088447>, <0.165642, 5.000000, 0.088447>, 
      <-0.331285, 5.012346, 1.857395>, <-0.165642, 5.012346, 1.857395>, <0.000000, 5.012346, 1.857395>, <0.165642, 5.012346, 1.857395>
    }
  }
  rotate <91.002113, 0.0, 135.0>
  translate  <36.189083, -44.134074, 10.817071>
}
#declare BezPtch053 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -8.065095, 2.741868>, <-0.165642, -8.065095, 2.741868>, <0.000000, -8.065095, 2.741868>, <0.165642, -8.065095, 2.741868>, 
      <-0.333985, -7.937644, 0.088447>, <-0.168343, -7.937644, 0.088447>, <-0.002700, -7.937644, 0.088447>, <0.162942, -7.937644, 0.088447>, 
      <-0.331285, -6.154882, 0.353789>, <-0.165642, -6.154882, 0.353789>, <0.000000, -6.154882, 0.353789>, <0.165642, -6.154882, 0.353789>, 
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>, 
      <-0.331285, -3.705948, 0.353789>, <-0.165642, -3.705948, 0.353789>, <0.000000, -3.705948, 0.353789>, <0.165642, -3.705948, 0.353789>, 
      <-0.331285, -4.052750, 3.184105>, <-0.165642, -4.052750, 3.184105>, <0.000000, -4.052750, 3.184105>, <0.165642, -4.052750, 3.184105>, 
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>, 
      <-0.331285, 1.269360, 3.537894>, <-0.165642, 1.269360, 3.537894>, <0.000000, 1.269360, 3.537894>, <0.165642, 1.269360, 3.537894>, 
      <-0.331285, 1.461279, 0.000000>, <-0.165642, 1.461279, 0.000000>, <0.000000, 1.461279, 0.000000>, <0.165642, 1.461279, 0.000000>, 
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>, 
      <-0.331285, 3.820426, -0.088447>, <-0.165642, 3.820426, -0.088447>, <0.000000, 3.820426, -0.088447>, <0.165642, 3.820426, -0.088447>, 
      <-0.331285, 5.000000, 0.088447>, <-0.165642, 5.000000, 0.088447>, <0.000000, 5.000000, 0.088447>, <0.165642, 5.000000, 0.088447>, 
      <-0.331285, 5.012346, 1.857395>, <-0.165642, 5.012346, 1.857395>, <0.000000, 5.012346, 1.857395>, <0.165642, 5.012346, 1.857395>
    }
  }
  rotate <91.002113, 0.0, -135.0>
  translate  <34.016217, -44.481733, 10.817071>
}
#declare BezPtch054 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -8.065095, 2.741868>, <-0.165642, -8.065095, 2.741868>, <0.000000, -8.065095, 2.741868>, <0.165642, -8.065095, 2.741868>, 
      <-0.333985, -7.937644, 0.088447>, <-0.168343, -7.937644, 0.088447>, <-0.002700, -7.937644, 0.088447>, <0.162942, -7.937644, 0.088447>, 
      <-0.331285, -6.154882, 0.353789>, <-0.165642, -6.154882, 0.353789>, <0.000000, -6.154882, 0.353789>, <0.165642, -6.154882, 0.353789>, 
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>, 
      <-0.331285, -3.705948, 0.353789>, <-0.165642, -3.705948, 0.353789>, <0.000000, -3.705948, 0.353789>, <0.165642, -3.705948, 0.353789>, 
      <-0.331285, -4.052750, 3.184105>, <-0.165642, -4.052750, 3.184105>, <0.000000, -4.052750, 3.184105>, <0.165642, -4.052750, 3.184105>, 
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>, 
      <-0.331285, 1.269360, 3.537894>, <-0.165642, 1.269360, 3.537894>, <0.000000, 1.269360, 3.537894>, <0.165642, 1.269360, 3.537894>, 
      <-0.331285, 1.461279, 0.000000>, <-0.165642, 1.461279, 0.000000>, <0.000000, 1.461279, 0.000000>, <0.165642, 1.461279, 0.000000>, 
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>, 
      <-0.331285, 3.820426, -0.088447>, <-0.165642, 3.820426, -0.088447>, <0.000000, 3.820426, -0.088447>, <0.165642, 3.820426, -0.088447>, 
      <-0.331285, 5.000000, 0.088447>, <-0.165642, 5.000000, 0.088447>, <0.000000, 5.000000, 0.088447>, <0.165642, 5.000000, 0.088447>, 
      <-0.331285, 5.012346, 1.857395>, <-0.165642, 5.012346, 1.857395>, <0.000000, 5.012346, 1.857395>, <0.165642, 5.012346, 1.857395>
    }
  }
  rotate <91.002113, 0.0, -90.0>
  translate  <33.407814, -45.17705, 10.817071>
}
#declare BezPtch055 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -8.065095, 2.741868>, <-0.165642, -8.065095, 2.741868>, <0.000000, -8.065095, 2.741868>, <0.165642, -8.065095, 2.741868>, 
      <-0.333985, -7.937644, 0.088447>, <-0.168343, -7.937644, 0.088447>, <-0.002700, -7.937644, 0.088447>, <0.162942, -7.937644, 0.088447>, 
      <-0.331285, -6.154882, 0.353789>, <-0.165642, -6.154882, 0.353789>, <0.000000, -6.154882, 0.353789>, <0.165642, -6.154882, 0.353789>, 
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>, 
      <-0.331285, -3.705948, 0.353789>, <-0.165642, -3.705948, 0.353789>, <0.000000, -3.705948, 0.353789>, <0.165642, -3.705948, 0.353789>, 
      <-0.331285, -4.052750, 3.184105>, <-0.165642, -4.052750, 3.184105>, <0.000000, -4.052750, 3.184105>, <0.165642, -4.052750, 3.184105>, 
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>, 
      <-0.331285, 1.269360, 3.537894>, <-0.165642, 1.269360, 3.537894>, <0.000000, 1.269360, 3.537894>, <0.165642, 1.269360, 3.537894>, 
      <-0.331285, 1.461279, 0.000000>, <-0.165642, 1.461279, 0.000000>, <0.000000, 1.461279, 0.000000>, <0.165642, 1.461279, 0.000000>, 
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>, 
      <-0.331285, 3.820426, -0.088447>, <-0.165642, 3.820426, -0.088447>, <0.000000, 3.820426, -0.088447>, <0.165642, 3.820426, -0.088447>, 
      <-0.331285, 5.000000, 0.088447>, <-0.165642, 5.000000, 0.088447>, <0.000000, 5.000000, 0.088447>, <0.165642, 5.000000, 0.088447>, 
      <-0.331285, 5.012346, 1.857395>, <-0.165642, 5.012346, 1.857395>, <0.000000, 5.012346, 1.857395>, <0.165642, 5.012346, 1.857395>
    }
  }
  rotate <91.002113, 0.0, -45.0>
  translate  <34.016217, -46.046196, 10.817071>
}
#declare BezPtch056 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -8.065095, 2.741868>, <-0.165642, -8.065095, 2.741868>, <0.000000, -8.065095, 2.741868>, <0.165642, -8.065095, 2.741868>, 
      <-0.333985, -7.937644, 0.088447>, <-0.168343, -7.937644, 0.088447>, <-0.002700, -7.937644, 0.088447>, <0.162942, -7.937644, 0.088447>, 
      <-0.331285, -6.154882, 0.353789>, <-0.165642, -6.154882, 0.353789>, <0.000000, -6.154882, 0.353789>, <0.165642, -6.154882, 0.353789>, 
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>, 
      <-0.331285, -3.705948, 0.353789>, <-0.165642, -3.705948, 0.353789>, <0.000000, -3.705948, 0.353789>, <0.165642, -3.705948, 0.353789>, 
      <-0.331285, -4.052750, 3.184105>, <-0.165642, -4.052750, 3.184105>, <0.000000, -4.052750, 3.184105>, <0.165642, -4.052750, 3.184105>, 
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>, 
      <-0.331285, 1.269360, 3.537894>, <-0.165642, 1.269360, 3.537894>, <0.000000, 1.269360, 3.537894>, <0.165642, 1.269360, 3.537894>, 
      <-0.331285, 1.461279, 0.000000>, <-0.165642, 1.461279, 0.000000>, <0.000000, 1.461279, 0.000000>, <0.165642, 1.461279, 0.000000>, 
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>, 
      <-0.331285, 3.820426, -0.088447>, <-0.165642, 3.820426, -0.088447>, <0.000000, 3.820426, -0.088447>, <0.165642, 3.820426, -0.088447>, 
      <-0.331285, 5.000000, 0.088447>, <-0.165642, 5.000000, 0.088447>, <0.000000, 5.000000, 0.088447>, <0.165642, 5.000000, 0.088447>, 
      <-0.331285, 5.012346, 1.857395>, <-0.165642, 5.012346, 1.857395>, <0.000000, 5.012346, 1.857395>, <0.165642, 5.012346, 1.857395>
    }
  }
  rotate <91.002113, 0.0, 0.0>
  translate  <35.233022, -46.567684, 10.817071>
}
#declare lamp6 = union {
  sphere { // Sphere010
    <0,0,0>,1
    material {
      Glass
    }
    hollow
    scale <5.0, 5.0, 3.261394>
    translate  <35.095907, -45.140268, 9.51724>
  }
  object { BezPtch049 }
  object { BezPtch050 }
  object { BezPtch051 }
  object { BezPtch052 }
  object { BezPtch053 }
  object { BezPtch054 }
  object { BezPtch055 }
  object { BezPtch056 }
  cone { // Cone013
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale 1.716519
    rotate <180.0, 0.0, 180.0>
    translate  <35.128593, -45.169069, 16.365649>
  }
  torus { // Torus047
    1.75, 0.25  rotate -x*90
    scale 1.091333
    rotate 0.0*x
    translate  <35.06776, -45.169069, 13.234877>
  }
  cylinder { // Cylndr172
    <0,0,1>, <0,0,0>, 1 
    scale 2.064656
    rotate 0.0*x
    translate  <35.268193, -45.169069, 4.005444>
  }
  torus { // Torus048
    1.75, 0.25  rotate -x*90
    scale 1.091333
    rotate 0.0*x
    translate  <35.128593, -45.169069, 14.2082>
  }
  cylinder { // Cylndr173
    <0,0,1>, <0,0,0>, 1 
    scale <0.333333, 0.333333, 20.0>
    rotate <180.0, -0.0, -180.0>
    translate  <35.009483, -44.966081, 35.268835>
  }
  cone { // Cone014
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale 2.465107
    rotate 0.0*y
    translate  <35.009391, -44.976931, 28.187788>
  }
  sphere { // Sphere023
    <0,0,0>,1
    material {
      lampwhite
    }
    no_shadow
    scale 0.734142
    rotate <-0.0, 0.0, -30.0>
    translate  <35.041314, -45.284038, 9.456169>
  }
  material {
    ironblack
  }
  scale 0.15
  rotate -180.0*z
  translate  <10.375813, 12.578051, 16.133418>
}
#declare BezPtch057 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -8.065095, 2.741868>, <-0.165642, -8.065095, 2.741868>, <0.000000, -8.065095, 2.741868>, <0.165642, -8.065095, 2.741868>, 
      <-0.333985, -7.937644, 0.088447>, <-0.168343, -7.937644, 0.088447>, <-0.002700, -7.937644, 0.088447>, <0.162942, -7.937644, 0.088447>, 
      <-0.331285, -6.154882, 0.353789>, <-0.165642, -6.154882, 0.353789>, <0.000000, -6.154882, 0.353789>, <0.165642, -6.154882, 0.353789>, 
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>, 
      <-0.331285, -3.705948, 0.353789>, <-0.165642, -3.705948, 0.353789>, <0.000000, -3.705948, 0.353789>, <0.165642, -3.705948, 0.353789>, 
      <-0.331285, -4.052750, 3.184105>, <-0.165642, -4.052750, 3.184105>, <0.000000, -4.052750, 3.184105>, <0.165642, -4.052750, 3.184105>, 
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>, 
      <-0.331285, 1.269360, 3.537894>, <-0.165642, 1.269360, 3.537894>, <0.000000, 1.269360, 3.537894>, <0.165642, 1.269360, 3.537894>, 
      <-0.331285, 1.461279, 0.000000>, <-0.165642, 1.461279, 0.000000>, <0.000000, 1.461279, 0.000000>, <0.165642, 1.461279, 0.000000>, 
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>, 
      <-0.331285, 3.820426, -0.088447>, <-0.165642, 3.820426, -0.088447>, <0.000000, 3.820426, -0.088447>, <0.165642, 3.820426, -0.088447>, 
      <-0.331285, 5.000000, 0.088447>, <-0.165642, 5.000000, 0.088447>, <0.000000, 5.000000, 0.088447>, <0.165642, 5.000000, 0.088447>, 
      <-0.331285, 5.012346, 1.857395>, <-0.165642, 5.012346, 1.857395>, <0.000000, 5.012346, 1.857395>, <0.165642, 5.012346, 1.857395>
    }
  }
  rotate <91.002113, 0.0, 180.0>
  translate  <34.972278, -43.612587, 10.817071>
}
#declare BezPtch058 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -8.065095, 2.741868>, <-0.165642, -8.065095, 2.741868>, <0.000000, -8.065095, 2.741868>, <0.165642, -8.065095, 2.741868>, 
      <-0.333985, -7.937644, 0.088447>, <-0.168343, -7.937644, 0.088447>, <-0.002700, -7.937644, 0.088447>, <0.162942, -7.937644, 0.088447>, 
      <-0.331285, -6.154882, 0.353789>, <-0.165642, -6.154882, 0.353789>, <0.000000, -6.154882, 0.353789>, <0.165642, -6.154882, 0.353789>, 
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>, 
      <-0.331285, -3.705948, 0.353789>, <-0.165642, -3.705948, 0.353789>, <0.000000, -3.705948, 0.353789>, <0.165642, -3.705948, 0.353789>, 
      <-0.331285, -4.052750, 3.184105>, <-0.165642, -4.052750, 3.184105>, <0.000000, -4.052750, 3.184105>, <0.165642, -4.052750, 3.184105>, 
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>, 
      <-0.331285, 1.269360, 3.537894>, <-0.165642, 1.269360, 3.537894>, <0.000000, 1.269360, 3.537894>, <0.165642, 1.269360, 3.537894>, 
      <-0.331285, 1.461279, 0.000000>, <-0.165642, 1.461279, 0.000000>, <0.000000, 1.461279, 0.000000>, <0.165642, 1.461279, 0.000000>, 
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>, 
      <-0.331285, 3.820426, -0.088447>, <-0.165642, 3.820426, -0.088447>, <0.000000, 3.820426, -0.088447>, <0.165642, 3.820426, -0.088447>, 
      <-0.331285, 5.000000, 0.088447>, <-0.165642, 5.000000, 0.088447>, <0.000000, 5.000000, 0.088447>, <0.165642, 5.000000, 0.088447>, 
      <-0.331285, 5.012346, 1.857395>, <-0.165642, 5.012346, 1.857395>, <0.000000, 5.012346, 1.857395>, <0.165642, 5.012346, 1.857395>
    }
  }
  rotate <91.002113, 0.0, 90.0>
  translate  <36.710571, -44.916306, 10.817071>
}
#declare BezPtch059 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -8.065095, 2.741868>, <-0.165642, -8.065095, 2.741868>, <0.000000, -8.065095, 2.741868>, <0.165642, -8.065095, 2.741868>, 
      <-0.333985, -7.937644, 0.088447>, <-0.168343, -7.937644, 0.088447>, <-0.002700, -7.937644, 0.088447>, <0.162942, -7.937644, 0.088447>, 
      <-0.331285, -6.154882, 0.353789>, <-0.165642, -6.154882, 0.353789>, <0.000000, -6.154882, 0.353789>, <0.165642, -6.154882, 0.353789>, 
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>, 
      <-0.331285, -3.705948, 0.353789>, <-0.165642, -3.705948, 0.353789>, <0.000000, -3.705948, 0.353789>, <0.165642, -3.705948, 0.353789>, 
      <-0.331285, -4.052750, 3.184105>, <-0.165642, -4.052750, 3.184105>, <0.000000, -4.052750, 3.184105>, <0.165642, -4.052750, 3.184105>, 
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>, 
      <-0.331285, 1.269360, 3.537894>, <-0.165642, 1.269360, 3.537894>, <0.000000, 1.269360, 3.537894>, <0.165642, 1.269360, 3.537894>, 
      <-0.331285, 1.461279, 0.000000>, <-0.165642, 1.461279, 0.000000>, <0.000000, 1.461279, 0.000000>, <0.165642, 1.461279, 0.000000>, 
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>, 
      <-0.331285, 3.820426, -0.088447>, <-0.165642, 3.820426, -0.088447>, <0.000000, 3.820426, -0.088447>, <0.165642, 3.820426, -0.088447>, 
      <-0.331285, 5.000000, 0.088447>, <-0.165642, 5.000000, 0.088447>, <0.000000, 5.000000, 0.088447>, <0.165642, 5.000000, 0.088447>, 
      <-0.331285, 5.012346, 1.857395>, <-0.165642, 5.012346, 1.857395>, <0.000000, 5.012346, 1.857395>, <0.165642, 5.012346, 1.857395>
    }
  }
  rotate <91.002113, 0.0, 45.0>
  translate  <36.362912, -46.133111, 10.817071>
}
#declare BezPtch060 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -8.065095, 2.741868>, <-0.165642, -8.065095, 2.741868>, <0.000000, -8.065095, 2.741868>, <0.165642, -8.065095, 2.741868>, 
      <-0.333985, -7.937644, 0.088447>, <-0.168343, -7.937644, 0.088447>, <-0.002700, -7.937644, 0.088447>, <0.162942, -7.937644, 0.088447>, 
      <-0.331285, -6.154882, 0.353789>, <-0.165642, -6.154882, 0.353789>, <0.000000, -6.154882, 0.353789>, <0.165642, -6.154882, 0.353789>, 
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>, 
      <-0.331285, -3.705948, 0.353789>, <-0.165642, -3.705948, 0.353789>, <0.000000, -3.705948, 0.353789>, <0.165642, -3.705948, 0.353789>, 
      <-0.331285, -4.052750, 3.184105>, <-0.165642, -4.052750, 3.184105>, <0.000000, -4.052750, 3.184105>, <0.165642, -4.052750, 3.184105>, 
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>, 
      <-0.331285, 1.269360, 3.537894>, <-0.165642, 1.269360, 3.537894>, <0.000000, 1.269360, 3.537894>, <0.165642, 1.269360, 3.537894>, 
      <-0.331285, 1.461279, 0.000000>, <-0.165642, 1.461279, 0.000000>, <0.000000, 1.461279, 0.000000>, <0.165642, 1.461279, 0.000000>, 
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>, 
      <-0.331285, 3.820426, -0.088447>, <-0.165642, 3.820426, -0.088447>, <0.000000, 3.820426, -0.088447>, <0.165642, 3.820426, -0.088447>, 
      <-0.331285, 5.000000, 0.088447>, <-0.165642, 5.000000, 0.088447>, <0.000000, 5.000000, 0.088447>, <0.165642, 5.000000, 0.088447>, 
      <-0.331285, 5.012346, 1.857395>, <-0.165642, 5.012346, 1.857395>, <0.000000, 5.012346, 1.857395>, <0.165642, 5.012346, 1.857395>
    }
  }
  rotate <91.002113, 0.0, 135.0>
  translate  <36.189083, -44.134074, 10.817071>
}
#declare BezPtch061 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -8.065095, 2.741868>, <-0.165642, -8.065095, 2.741868>, <0.000000, -8.065095, 2.741868>, <0.165642, -8.065095, 2.741868>, 
      <-0.333985, -7.937644, 0.088447>, <-0.168343, -7.937644, 0.088447>, <-0.002700, -7.937644, 0.088447>, <0.162942, -7.937644, 0.088447>, 
      <-0.331285, -6.154882, 0.353789>, <-0.165642, -6.154882, 0.353789>, <0.000000, -6.154882, 0.353789>, <0.165642, -6.154882, 0.353789>, 
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>, 
      <-0.331285, -3.705948, 0.353789>, <-0.165642, -3.705948, 0.353789>, <0.000000, -3.705948, 0.353789>, <0.165642, -3.705948, 0.353789>, 
      <-0.331285, -4.052750, 3.184105>, <-0.165642, -4.052750, 3.184105>, <0.000000, -4.052750, 3.184105>, <0.165642, -4.052750, 3.184105>, 
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>, 
      <-0.331285, 1.269360, 3.537894>, <-0.165642, 1.269360, 3.537894>, <0.000000, 1.269360, 3.537894>, <0.165642, 1.269360, 3.537894>, 
      <-0.331285, 1.461279, 0.000000>, <-0.165642, 1.461279, 0.000000>, <0.000000, 1.461279, 0.000000>, <0.165642, 1.461279, 0.000000>, 
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>, 
      <-0.331285, 3.820426, -0.088447>, <-0.165642, 3.820426, -0.088447>, <0.000000, 3.820426, -0.088447>, <0.165642, 3.820426, -0.088447>, 
      <-0.331285, 5.000000, 0.088447>, <-0.165642, 5.000000, 0.088447>, <0.000000, 5.000000, 0.088447>, <0.165642, 5.000000, 0.088447>, 
      <-0.331285, 5.012346, 1.857395>, <-0.165642, 5.012346, 1.857395>, <0.000000, 5.012346, 1.857395>, <0.165642, 5.012346, 1.857395>
    }
  }
  rotate <91.002113, 0.0, -135.0>
  translate  <34.016217, -44.481733, 10.817071>
}
#declare BezPtch062 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -8.065095, 2.741868>, <-0.165642, -8.065095, 2.741868>, <0.000000, -8.065095, 2.741868>, <0.165642, -8.065095, 2.741868>, 
      <-0.333985, -7.937644, 0.088447>, <-0.168343, -7.937644, 0.088447>, <-0.002700, -7.937644, 0.088447>, <0.162942, -7.937644, 0.088447>, 
      <-0.331285, -6.154882, 0.353789>, <-0.165642, -6.154882, 0.353789>, <0.000000, -6.154882, 0.353789>, <0.165642, -6.154882, 0.353789>, 
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>, 
      <-0.331285, -3.705948, 0.353789>, <-0.165642, -3.705948, 0.353789>, <0.000000, -3.705948, 0.353789>, <0.165642, -3.705948, 0.353789>, 
      <-0.331285, -4.052750, 3.184105>, <-0.165642, -4.052750, 3.184105>, <0.000000, -4.052750, 3.184105>, <0.165642, -4.052750, 3.184105>, 
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>, 
      <-0.331285, 1.269360, 3.537894>, <-0.165642, 1.269360, 3.537894>, <0.000000, 1.269360, 3.537894>, <0.165642, 1.269360, 3.537894>, 
      <-0.331285, 1.461279, 0.000000>, <-0.165642, 1.461279, 0.000000>, <0.000000, 1.461279, 0.000000>, <0.165642, 1.461279, 0.000000>, 
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>, 
      <-0.331285, 3.820426, -0.088447>, <-0.165642, 3.820426, -0.088447>, <0.000000, 3.820426, -0.088447>, <0.165642, 3.820426, -0.088447>, 
      <-0.331285, 5.000000, 0.088447>, <-0.165642, 5.000000, 0.088447>, <0.000000, 5.000000, 0.088447>, <0.165642, 5.000000, 0.088447>, 
      <-0.331285, 5.012346, 1.857395>, <-0.165642, 5.012346, 1.857395>, <0.000000, 5.012346, 1.857395>, <0.165642, 5.012346, 1.857395>
    }
  }
  rotate <91.002113, 0.0, -90.0>
  translate  <33.407814, -45.17705, 10.817071>
}
#declare BezPtch063 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -8.065095, 2.741868>, <-0.165642, -8.065095, 2.741868>, <0.000000, -8.065095, 2.741868>, <0.165642, -8.065095, 2.741868>, 
      <-0.333985, -7.937644, 0.088447>, <-0.168343, -7.937644, 0.088447>, <-0.002700, -7.937644, 0.088447>, <0.162942, -7.937644, 0.088447>, 
      <-0.331285, -6.154882, 0.353789>, <-0.165642, -6.154882, 0.353789>, <0.000000, -6.154882, 0.353789>, <0.165642, -6.154882, 0.353789>, 
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>, 
      <-0.331285, -3.705948, 0.353789>, <-0.165642, -3.705948, 0.353789>, <0.000000, -3.705948, 0.353789>, <0.165642, -3.705948, 0.353789>, 
      <-0.331285, -4.052750, 3.184105>, <-0.165642, -4.052750, 3.184105>, <0.000000, -4.052750, 3.184105>, <0.165642, -4.052750, 3.184105>, 
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>, 
      <-0.331285, 1.269360, 3.537894>, <-0.165642, 1.269360, 3.537894>, <0.000000, 1.269360, 3.537894>, <0.165642, 1.269360, 3.537894>, 
      <-0.331285, 1.461279, 0.000000>, <-0.165642, 1.461279, 0.000000>, <0.000000, 1.461279, 0.000000>, <0.165642, 1.461279, 0.000000>, 
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>, 
      <-0.331285, 3.820426, -0.088447>, <-0.165642, 3.820426, -0.088447>, <0.000000, 3.820426, -0.088447>, <0.165642, 3.820426, -0.088447>, 
      <-0.331285, 5.000000, 0.088447>, <-0.165642, 5.000000, 0.088447>, <0.000000, 5.000000, 0.088447>, <0.165642, 5.000000, 0.088447>, 
      <-0.331285, 5.012346, 1.857395>, <-0.165642, 5.012346, 1.857395>, <0.000000, 5.012346, 1.857395>, <0.165642, 5.012346, 1.857395>
    }
  }
  rotate <91.002113, 0.0, -45.0>
  translate  <34.016217, -46.046196, 10.817071>
}
#declare BezPtch064 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -8.065095, 2.741868>, <-0.165642, -8.065095, 2.741868>, <0.000000, -8.065095, 2.741868>, <0.165642, -8.065095, 2.741868>, 
      <-0.333985, -7.937644, 0.088447>, <-0.168343, -7.937644, 0.088447>, <-0.002700, -7.937644, 0.088447>, <0.162942, -7.937644, 0.088447>, 
      <-0.331285, -6.154882, 0.353789>, <-0.165642, -6.154882, 0.353789>, <0.000000, -6.154882, 0.353789>, <0.165642, -6.154882, 0.353789>, 
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>, 
      <-0.331285, -3.705948, 0.353789>, <-0.165642, -3.705948, 0.353789>, <0.000000, -3.705948, 0.353789>, <0.165642, -3.705948, 0.353789>, 
      <-0.331285, -4.052750, 3.184105>, <-0.165642, -4.052750, 3.184105>, <0.000000, -4.052750, 3.184105>, <0.165642, -4.052750, 3.184105>, 
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>, 
      <-0.331285, 1.269360, 3.537894>, <-0.165642, 1.269360, 3.537894>, <0.000000, 1.269360, 3.537894>, <0.165642, 1.269360, 3.537894>, 
      <-0.331285, 1.461279, 0.000000>, <-0.165642, 1.461279, 0.000000>, <0.000000, 1.461279, 0.000000>, <0.165642, 1.461279, 0.000000>, 
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>, 
      <-0.331285, 3.820426, -0.088447>, <-0.165642, 3.820426, -0.088447>, <0.000000, 3.820426, -0.088447>, <0.165642, 3.820426, -0.088447>, 
      <-0.331285, 5.000000, 0.088447>, <-0.165642, 5.000000, 0.088447>, <0.000000, 5.000000, 0.088447>, <0.165642, 5.000000, 0.088447>, 
      <-0.331285, 5.012346, 1.857395>, <-0.165642, 5.012346, 1.857395>, <0.000000, 5.012346, 1.857395>, <0.165642, 5.012346, 1.857395>
    }
  }
  rotate <91.002113, 0.0, 0.0>
  translate  <35.233022, -46.567684, 10.817071>
}
#declare lamp7 = union {
  sphere { // Sphere011
    <0,0,0>,1
    material {
      Glass
    }
    hollow
    scale <5.0, 5.0, 3.261394>
    translate  <35.095907, -45.140268, 9.51724>
  }
  object { BezPtch057 }
  object { BezPtch058 }
  object { BezPtch059 }
  object { BezPtch060 }
  object { BezPtch061 }
  object { BezPtch062 }
  object { BezPtch063 }
  object { BezPtch064 }
  cone { // Cone015
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale 1.716519
    rotate <180.0, 0.0, 180.0>
    translate  <35.128593, -45.169069, 16.365649>
  }
  torus { // Torus049
    1.75, 0.25  rotate -x*90
    scale 1.091333
    rotate 0.0*x
    translate  <35.06776, -45.169069, 13.234877>
  }
  cylinder { // Cylndr174
    <0,0,1>, <0,0,0>, 1 
    scale 2.064656
    rotate 0.0*x
    translate  <35.268193, -45.169069, 4.005444>
  }
  torus { // Torus050
    1.75, 0.25  rotate -x*90
    scale 1.091333
    rotate 0.0*x
    translate  <35.128593, -45.169069, 14.2082>
  }
  cylinder { // Cylndr175
    <0,0,1>, <0,0,0>, 1 
    scale <0.333333, 0.333333, 20.0>
    rotate <180.0, -0.0, -180.0>
    translate  <35.009483, -44.966081, 35.268835>
  }
  cone { // Cone016
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale 2.465107
    rotate 0.0*y
    translate  <35.009391, -44.976931, 28.187788>
  }
  sphere { // Sphere024
    <0,0,0>,1
    material {
      lampwhite
    }
    no_shadow
    scale 0.734142
    rotate <-0.0, 0.0, -30.0>
    translate  <35.041314, -45.284038, 9.456169>
  }
  material {
    ironblack
  }
  scale 0.15
  rotate -210.0*z
  translate  <15.274743, 5.705005, 16.133418>
}
#declare BezPtch065 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -8.065095, 2.741868>, <-0.165642, -8.065095, 2.741868>, <0.000000, -8.065095, 2.741868>, <0.165642, -8.065095, 2.741868>, 
      <-0.333985, -7.937644, 0.088447>, <-0.168343, -7.937644, 0.088447>, <-0.002700, -7.937644, 0.088447>, <0.162942, -7.937644, 0.088447>, 
      <-0.331285, -6.154882, 0.353789>, <-0.165642, -6.154882, 0.353789>, <0.000000, -6.154882, 0.353789>, <0.165642, -6.154882, 0.353789>, 
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>, 
      <-0.331285, -3.705948, 0.353789>, <-0.165642, -3.705948, 0.353789>, <0.000000, -3.705948, 0.353789>, <0.165642, -3.705948, 0.353789>, 
      <-0.331285, -4.052750, 3.184105>, <-0.165642, -4.052750, 3.184105>, <0.000000, -4.052750, 3.184105>, <0.165642, -4.052750, 3.184105>, 
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>, 
      <-0.331285, 1.269360, 3.537894>, <-0.165642, 1.269360, 3.537894>, <0.000000, 1.269360, 3.537894>, <0.165642, 1.269360, 3.537894>, 
      <-0.331285, 1.461279, 0.000000>, <-0.165642, 1.461279, 0.000000>, <0.000000, 1.461279, 0.000000>, <0.165642, 1.461279, 0.000000>, 
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>, 
      <-0.331285, 3.820426, -0.088447>, <-0.165642, 3.820426, -0.088447>, <0.000000, 3.820426, -0.088447>, <0.165642, 3.820426, -0.088447>, 
      <-0.331285, 5.000000, 0.088447>, <-0.165642, 5.000000, 0.088447>, <0.000000, 5.000000, 0.088447>, <0.165642, 5.000000, 0.088447>, 
      <-0.331285, 5.012346, 1.857395>, <-0.165642, 5.012346, 1.857395>, <0.000000, 5.012346, 1.857395>, <0.165642, 5.012346, 1.857395>
    }
  }
  rotate <91.002113, 0.0, 180.0>
  translate  <34.972278, -43.612587, 10.817071>
}
#declare BezPtch066 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -8.065095, 2.741868>, <-0.165642, -8.065095, 2.741868>, <0.000000, -8.065095, 2.741868>, <0.165642, -8.065095, 2.741868>, 
      <-0.333985, -7.937644, 0.088447>, <-0.168343, -7.937644, 0.088447>, <-0.002700, -7.937644, 0.088447>, <0.162942, -7.937644, 0.088447>, 
      <-0.331285, -6.154882, 0.353789>, <-0.165642, -6.154882, 0.353789>, <0.000000, -6.154882, 0.353789>, <0.165642, -6.154882, 0.353789>, 
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>, 
      <-0.331285, -3.705948, 0.353789>, <-0.165642, -3.705948, 0.353789>, <0.000000, -3.705948, 0.353789>, <0.165642, -3.705948, 0.353789>, 
      <-0.331285, -4.052750, 3.184105>, <-0.165642, -4.052750, 3.184105>, <0.000000, -4.052750, 3.184105>, <0.165642, -4.052750, 3.184105>, 
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>, 
      <-0.331285, 1.269360, 3.537894>, <-0.165642, 1.269360, 3.537894>, <0.000000, 1.269360, 3.537894>, <0.165642, 1.269360, 3.537894>, 
      <-0.331285, 1.461279, 0.000000>, <-0.165642, 1.461279, 0.000000>, <0.000000, 1.461279, 0.000000>, <0.165642, 1.461279, 0.000000>, 
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>, 
      <-0.331285, 3.820426, -0.088447>, <-0.165642, 3.820426, -0.088447>, <0.000000, 3.820426, -0.088447>, <0.165642, 3.820426, -0.088447>, 
      <-0.331285, 5.000000, 0.088447>, <-0.165642, 5.000000, 0.088447>, <0.000000, 5.000000, 0.088447>, <0.165642, 5.000000, 0.088447>, 
      <-0.331285, 5.012346, 1.857395>, <-0.165642, 5.012346, 1.857395>, <0.000000, 5.012346, 1.857395>, <0.165642, 5.012346, 1.857395>
    }
  }
  rotate <91.002113, 0.0, 90.0>
  translate  <36.710571, -44.916306, 10.817071>
}
#declare BezPtch067 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -8.065095, 2.741868>, <-0.165642, -8.065095, 2.741868>, <0.000000, -8.065095, 2.741868>, <0.165642, -8.065095, 2.741868>, 
      <-0.333985, -7.937644, 0.088447>, <-0.168343, -7.937644, 0.088447>, <-0.002700, -7.937644, 0.088447>, <0.162942, -7.937644, 0.088447>, 
      <-0.331285, -6.154882, 0.353789>, <-0.165642, -6.154882, 0.353789>, <0.000000, -6.154882, 0.353789>, <0.165642, -6.154882, 0.353789>, 
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>, 
      <-0.331285, -3.705948, 0.353789>, <-0.165642, -3.705948, 0.353789>, <0.000000, -3.705948, 0.353789>, <0.165642, -3.705948, 0.353789>, 
      <-0.331285, -4.052750, 3.184105>, <-0.165642, -4.052750, 3.184105>, <0.000000, -4.052750, 3.184105>, <0.165642, -4.052750, 3.184105>, 
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>, 
      <-0.331285, 1.269360, 3.537894>, <-0.165642, 1.269360, 3.537894>, <0.000000, 1.269360, 3.537894>, <0.165642, 1.269360, 3.537894>, 
      <-0.331285, 1.461279, 0.000000>, <-0.165642, 1.461279, 0.000000>, <0.000000, 1.461279, 0.000000>, <0.165642, 1.461279, 0.000000>, 
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>, 
      <-0.331285, 3.820426, -0.088447>, <-0.165642, 3.820426, -0.088447>, <0.000000, 3.820426, -0.088447>, <0.165642, 3.820426, -0.088447>, 
      <-0.331285, 5.000000, 0.088447>, <-0.165642, 5.000000, 0.088447>, <0.000000, 5.000000, 0.088447>, <0.165642, 5.000000, 0.088447>, 
      <-0.331285, 5.012346, 1.857395>, <-0.165642, 5.012346, 1.857395>, <0.000000, 5.012346, 1.857395>, <0.165642, 5.012346, 1.857395>
    }
  }
  rotate <91.002113, 0.0, 45.0>
  translate  <36.362912, -46.133111, 10.817071>
}
#declare BezPtch068 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -8.065095, 2.741868>, <-0.165642, -8.065095, 2.741868>, <0.000000, -8.065095, 2.741868>, <0.165642, -8.065095, 2.741868>, 
      <-0.333985, -7.937644, 0.088447>, <-0.168343, -7.937644, 0.088447>, <-0.002700, -7.937644, 0.088447>, <0.162942, -7.937644, 0.088447>, 
      <-0.331285, -6.154882, 0.353789>, <-0.165642, -6.154882, 0.353789>, <0.000000, -6.154882, 0.353789>, <0.165642, -6.154882, 0.353789>, 
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>, 
      <-0.331285, -3.705948, 0.353789>, <-0.165642, -3.705948, 0.353789>, <0.000000, -3.705948, 0.353789>, <0.165642, -3.705948, 0.353789>, 
      <-0.331285, -4.052750, 3.184105>, <-0.165642, -4.052750, 3.184105>, <0.000000, -4.052750, 3.184105>, <0.165642, -4.052750, 3.184105>, 
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>, 
      <-0.331285, 1.269360, 3.537894>, <-0.165642, 1.269360, 3.537894>, <0.000000, 1.269360, 3.537894>, <0.165642, 1.269360, 3.537894>, 
      <-0.331285, 1.461279, 0.000000>, <-0.165642, 1.461279, 0.000000>, <0.000000, 1.461279, 0.000000>, <0.165642, 1.461279, 0.000000>, 
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>, 
      <-0.331285, 3.820426, -0.088447>, <-0.165642, 3.820426, -0.088447>, <0.000000, 3.820426, -0.088447>, <0.165642, 3.820426, -0.088447>, 
      <-0.331285, 5.000000, 0.088447>, <-0.165642, 5.000000, 0.088447>, <0.000000, 5.000000, 0.088447>, <0.165642, 5.000000, 0.088447>, 
      <-0.331285, 5.012346, 1.857395>, <-0.165642, 5.012346, 1.857395>, <0.000000, 5.012346, 1.857395>, <0.165642, 5.012346, 1.857395>
    }
  }
  rotate <91.002113, 0.0, 135.0>
  translate  <36.189083, -44.134074, 10.817071>
}
#declare BezPtch069 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -8.065095, 2.741868>, <-0.165642, -8.065095, 2.741868>, <0.000000, -8.065095, 2.741868>, <0.165642, -8.065095, 2.741868>, 
      <-0.333985, -7.937644, 0.088447>, <-0.168343, -7.937644, 0.088447>, <-0.002700, -7.937644, 0.088447>, <0.162942, -7.937644, 0.088447>, 
      <-0.331285, -6.154882, 0.353789>, <-0.165642, -6.154882, 0.353789>, <0.000000, -6.154882, 0.353789>, <0.165642, -6.154882, 0.353789>, 
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>, 
      <-0.331285, -3.705948, 0.353789>, <-0.165642, -3.705948, 0.353789>, <0.000000, -3.705948, 0.353789>, <0.165642, -3.705948, 0.353789>, 
      <-0.331285, -4.052750, 3.184105>, <-0.165642, -4.052750, 3.184105>, <0.000000, -4.052750, 3.184105>, <0.165642, -4.052750, 3.184105>, 
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>, 
      <-0.331285, 1.269360, 3.537894>, <-0.165642, 1.269360, 3.537894>, <0.000000, 1.269360, 3.537894>, <0.165642, 1.269360, 3.537894>, 
      <-0.331285, 1.461279, 0.000000>, <-0.165642, 1.461279, 0.000000>, <0.000000, 1.461279, 0.000000>, <0.165642, 1.461279, 0.000000>, 
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>, 
      <-0.331285, 3.820426, -0.088447>, <-0.165642, 3.820426, -0.088447>, <0.000000, 3.820426, -0.088447>, <0.165642, 3.820426, -0.088447>, 
      <-0.331285, 5.000000, 0.088447>, <-0.165642, 5.000000, 0.088447>, <0.000000, 5.000000, 0.088447>, <0.165642, 5.000000, 0.088447>, 
      <-0.331285, 5.012346, 1.857395>, <-0.165642, 5.012346, 1.857395>, <0.000000, 5.012346, 1.857395>, <0.165642, 5.012346, 1.857395>
    }
  }
  rotate <91.002113, 0.0, -135.0>
  translate  <34.016217, -44.481733, 10.817071>
}
#declare BezPtch070 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -8.065095, 2.741868>, <-0.165642, -8.065095, 2.741868>, <0.000000, -8.065095, 2.741868>, <0.165642, -8.065095, 2.741868>, 
      <-0.333985, -7.937644, 0.088447>, <-0.168343, -7.937644, 0.088447>, <-0.002700, -7.937644, 0.088447>, <0.162942, -7.937644, 0.088447>, 
      <-0.331285, -6.154882, 0.353789>, <-0.165642, -6.154882, 0.353789>, <0.000000, -6.154882, 0.353789>, <0.165642, -6.154882, 0.353789>, 
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>, 
      <-0.331285, -3.705948, 0.353789>, <-0.165642, -3.705948, 0.353789>, <0.000000, -3.705948, 0.353789>, <0.165642, -3.705948, 0.353789>, 
      <-0.331285, -4.052750, 3.184105>, <-0.165642, -4.052750, 3.184105>, <0.000000, -4.052750, 3.184105>, <0.165642, -4.052750, 3.184105>, 
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>, 
      <-0.331285, 1.269360, 3.537894>, <-0.165642, 1.269360, 3.537894>, <0.000000, 1.269360, 3.537894>, <0.165642, 1.269360, 3.537894>, 
      <-0.331285, 1.461279, 0.000000>, <-0.165642, 1.461279, 0.000000>, <0.000000, 1.461279, 0.000000>, <0.165642, 1.461279, 0.000000>, 
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>, 
      <-0.331285, 3.820426, -0.088447>, <-0.165642, 3.820426, -0.088447>, <0.000000, 3.820426, -0.088447>, <0.165642, 3.820426, -0.088447>, 
      <-0.331285, 5.000000, 0.088447>, <-0.165642, 5.000000, 0.088447>, <0.000000, 5.000000, 0.088447>, <0.165642, 5.000000, 0.088447>, 
      <-0.331285, 5.012346, 1.857395>, <-0.165642, 5.012346, 1.857395>, <0.000000, 5.012346, 1.857395>, <0.165642, 5.012346, 1.857395>
    }
  }
  rotate <91.002113, 0.0, -90.0>
  translate  <33.407814, -45.17705, 10.817071>
}
#declare BezPtch071 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -8.065095, 2.741868>, <-0.165642, -8.065095, 2.741868>, <0.000000, -8.065095, 2.741868>, <0.165642, -8.065095, 2.741868>, 
      <-0.333985, -7.937644, 0.088447>, <-0.168343, -7.937644, 0.088447>, <-0.002700, -7.937644, 0.088447>, <0.162942, -7.937644, 0.088447>, 
      <-0.331285, -6.154882, 0.353789>, <-0.165642, -6.154882, 0.353789>, <0.000000, -6.154882, 0.353789>, <0.165642, -6.154882, 0.353789>, 
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>, 
      <-0.331285, -3.705948, 0.353789>, <-0.165642, -3.705948, 0.353789>, <0.000000, -3.705948, 0.353789>, <0.165642, -3.705948, 0.353789>, 
      <-0.331285, -4.052750, 3.184105>, <-0.165642, -4.052750, 3.184105>, <0.000000, -4.052750, 3.184105>, <0.165642, -4.052750, 3.184105>, 
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>, 
      <-0.331285, 1.269360, 3.537894>, <-0.165642, 1.269360, 3.537894>, <0.000000, 1.269360, 3.537894>, <0.165642, 1.269360, 3.537894>, 
      <-0.331285, 1.461279, 0.000000>, <-0.165642, 1.461279, 0.000000>, <0.000000, 1.461279, 0.000000>, <0.165642, 1.461279, 0.000000>, 
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>, 
      <-0.331285, 3.820426, -0.088447>, <-0.165642, 3.820426, -0.088447>, <0.000000, 3.820426, -0.088447>, <0.165642, 3.820426, -0.088447>, 
      <-0.331285, 5.000000, 0.088447>, <-0.165642, 5.000000, 0.088447>, <0.000000, 5.000000, 0.088447>, <0.165642, 5.000000, 0.088447>, 
      <-0.331285, 5.012346, 1.857395>, <-0.165642, 5.012346, 1.857395>, <0.000000, 5.012346, 1.857395>, <0.165642, 5.012346, 1.857395>
    }
  }
  rotate <91.002113, 0.0, -45.0>
  translate  <34.016217, -46.046196, 10.817071>
}
#declare BezPtch072 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -8.065095, 2.741868>, <-0.165642, -8.065095, 2.741868>, <0.000000, -8.065095, 2.741868>, <0.165642, -8.065095, 2.741868>, 
      <-0.333985, -7.937644, 0.088447>, <-0.168343, -7.937644, 0.088447>, <-0.002700, -7.937644, 0.088447>, <0.162942, -7.937644, 0.088447>, 
      <-0.331285, -6.154882, 0.353789>, <-0.165642, -6.154882, 0.353789>, <0.000000, -6.154882, 0.353789>, <0.165642, -6.154882, 0.353789>, 
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>, 
      <-0.331285, -3.705948, 0.353789>, <-0.165642, -3.705948, 0.353789>, <0.000000, -3.705948, 0.353789>, <0.165642, -3.705948, 0.353789>, 
      <-0.331285, -4.052750, 3.184105>, <-0.165642, -4.052750, 3.184105>, <0.000000, -4.052750, 3.184105>, <0.165642, -4.052750, 3.184105>, 
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>, 
      <-0.331285, 1.269360, 3.537894>, <-0.165642, 1.269360, 3.537894>, <0.000000, 1.269360, 3.537894>, <0.165642, 1.269360, 3.537894>, 
      <-0.331285, 1.461279, 0.000000>, <-0.165642, 1.461279, 0.000000>, <0.000000, 1.461279, 0.000000>, <0.165642, 1.461279, 0.000000>, 
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>, 
      <-0.331285, 3.820426, -0.088447>, <-0.165642, 3.820426, -0.088447>, <0.000000, 3.820426, -0.088447>, <0.165642, 3.820426, -0.088447>, 
      <-0.331285, 5.000000, 0.088447>, <-0.165642, 5.000000, 0.088447>, <0.000000, 5.000000, 0.088447>, <0.165642, 5.000000, 0.088447>, 
      <-0.331285, 5.012346, 1.857395>, <-0.165642, 5.012346, 1.857395>, <0.000000, 5.012346, 1.857395>, <0.165642, 5.012346, 1.857395>
    }
  }
  rotate <91.002113, 0.0, 0.0>
  translate  <35.233022, -46.567684, 10.817071>
}
#declare lamp8 = union {
  sphere { // Sphere012
    <0,0,0>,1
    material {
      Glass
    }
    hollow
    scale <5.0, 5.0, 3.261394>
    translate  <35.095907, -45.140268, 9.51724>
  }
  object { BezPtch065 }
  object { BezPtch066 }
  object { BezPtch067 }
  object { BezPtch068 }
  object { BezPtch069 }
  object { BezPtch070 }
  object { BezPtch071 }
  object { BezPtch072 }
  cone { // Cone017
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale 1.716519
    rotate <180.0, 0.0, 180.0>
    translate  <35.128593, -45.169069, 16.365649>
  }
  torus { // Torus051
    1.75, 0.25  rotate -x*90
    scale 1.091333
    rotate 0.0*x
    translate  <35.06776, -45.169069, 13.234877>
  }
  cylinder { // Cylndr176
    <0,0,1>, <0,0,0>, 1 
    scale 2.064656
    rotate 0.0*x
    translate  <35.268193, -45.169069, 4.005444>
  }
  torus { // Torus052
    1.75, 0.25  rotate -x*90
    scale 1.091333
    rotate 0.0*x
    translate  <35.128593, -45.169069, 14.2082>
  }
  cylinder { // Cylndr177
    <0,0,1>, <0,0,0>, 1 
    scale <0.333333, 0.333333, 20.0>
    rotate <180.0, -0.0, -180.0>
    translate  <35.009483, -44.966081, 35.268835>
  }
  cone { // Cone018
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale 2.465107
    rotate 0.0*y
    translate  <35.009391, -44.976931, 28.187788>
  }
  sphere { // Sphere025
    <0,0,0>,1
    material {
      lampwhite
    }
    no_shadow
    scale 0.734142
    rotate <-0.0, 0.0, -30.0>
    translate  <35.041314, -45.284038, 9.456169>
  }
  material {
    ironblack
  }
  scale 0.15
  rotate -240.0*z
  translate  <16.080818, -2.696693, 16.133418>
}
#declare BezPtch073 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -8.065095, 2.741868>, <-0.165642, -8.065095, 2.741868>, <0.000000, -8.065095, 2.741868>, <0.165642, -8.065095, 2.741868>, 
      <-0.333985, -7.937644, 0.088447>, <-0.168343, -7.937644, 0.088447>, <-0.002700, -7.937644, 0.088447>, <0.162942, -7.937644, 0.088447>, 
      <-0.331285, -6.154882, 0.353789>, <-0.165642, -6.154882, 0.353789>, <0.000000, -6.154882, 0.353789>, <0.165642, -6.154882, 0.353789>, 
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>, 
      <-0.331285, -3.705948, 0.353789>, <-0.165642, -3.705948, 0.353789>, <0.000000, -3.705948, 0.353789>, <0.165642, -3.705948, 0.353789>, 
      <-0.331285, -4.052750, 3.184105>, <-0.165642, -4.052750, 3.184105>, <0.000000, -4.052750, 3.184105>, <0.165642, -4.052750, 3.184105>, 
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>, 
      <-0.331285, 1.269360, 3.537894>, <-0.165642, 1.269360, 3.537894>, <0.000000, 1.269360, 3.537894>, <0.165642, 1.269360, 3.537894>, 
      <-0.331285, 1.461279, 0.000000>, <-0.165642, 1.461279, 0.000000>, <0.000000, 1.461279, 0.000000>, <0.165642, 1.461279, 0.000000>, 
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>, 
      <-0.331285, 3.820426, -0.088447>, <-0.165642, 3.820426, -0.088447>, <0.000000, 3.820426, -0.088447>, <0.165642, 3.820426, -0.088447>, 
      <-0.331285, 5.000000, 0.088447>, <-0.165642, 5.000000, 0.088447>, <0.000000, 5.000000, 0.088447>, <0.165642, 5.000000, 0.088447>, 
      <-0.331285, 5.012346, 1.857395>, <-0.165642, 5.012346, 1.857395>, <0.000000, 5.012346, 1.857395>, <0.165642, 5.012346, 1.857395>
    }
  }
  rotate <91.002113, 0.0, 180.0>
  translate  <34.972278, -43.612587, 10.817071>
}
#declare BezPtch074 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -8.065095, 2.741868>, <-0.165642, -8.065095, 2.741868>, <0.000000, -8.065095, 2.741868>, <0.165642, -8.065095, 2.741868>, 
      <-0.333985, -7.937644, 0.088447>, <-0.168343, -7.937644, 0.088447>, <-0.002700, -7.937644, 0.088447>, <0.162942, -7.937644, 0.088447>, 
      <-0.331285, -6.154882, 0.353789>, <-0.165642, -6.154882, 0.353789>, <0.000000, -6.154882, 0.353789>, <0.165642, -6.154882, 0.353789>, 
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>, 
      <-0.331285, -3.705948, 0.353789>, <-0.165642, -3.705948, 0.353789>, <0.000000, -3.705948, 0.353789>, <0.165642, -3.705948, 0.353789>, 
      <-0.331285, -4.052750, 3.184105>, <-0.165642, -4.052750, 3.184105>, <0.000000, -4.052750, 3.184105>, <0.165642, -4.052750, 3.184105>, 
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>, 
      <-0.331285, 1.269360, 3.537894>, <-0.165642, 1.269360, 3.537894>, <0.000000, 1.269360, 3.537894>, <0.165642, 1.269360, 3.537894>, 
      <-0.331285, 1.461279, 0.000000>, <-0.165642, 1.461279, 0.000000>, <0.000000, 1.461279, 0.000000>, <0.165642, 1.461279, 0.000000>, 
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>, 
      <-0.331285, 3.820426, -0.088447>, <-0.165642, 3.820426, -0.088447>, <0.000000, 3.820426, -0.088447>, <0.165642, 3.820426, -0.088447>, 
      <-0.331285, 5.000000, 0.088447>, <-0.165642, 5.000000, 0.088447>, <0.000000, 5.000000, 0.088447>, <0.165642, 5.000000, 0.088447>, 
      <-0.331285, 5.012346, 1.857395>, <-0.165642, 5.012346, 1.857395>, <0.000000, 5.012346, 1.857395>, <0.165642, 5.012346, 1.857395>
    }
  }
  rotate <91.002113, 0.0, 90.0>
  translate  <36.710571, -44.916306, 10.817071>
}
#declare BezPtch075 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -8.065095, 2.741868>, <-0.165642, -8.065095, 2.741868>, <0.000000, -8.065095, 2.741868>, <0.165642, -8.065095, 2.741868>, 
      <-0.333985, -7.937644, 0.088447>, <-0.168343, -7.937644, 0.088447>, <-0.002700, -7.937644, 0.088447>, <0.162942, -7.937644, 0.088447>, 
      <-0.331285, -6.154882, 0.353789>, <-0.165642, -6.154882, 0.353789>, <0.000000, -6.154882, 0.353789>, <0.165642, -6.154882, 0.353789>, 
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>, 
      <-0.331285, -3.705948, 0.353789>, <-0.165642, -3.705948, 0.353789>, <0.000000, -3.705948, 0.353789>, <0.165642, -3.705948, 0.353789>, 
      <-0.331285, -4.052750, 3.184105>, <-0.165642, -4.052750, 3.184105>, <0.000000, -4.052750, 3.184105>, <0.165642, -4.052750, 3.184105>, 
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>, 
      <-0.331285, 1.269360, 3.537894>, <-0.165642, 1.269360, 3.537894>, <0.000000, 1.269360, 3.537894>, <0.165642, 1.269360, 3.537894>, 
      <-0.331285, 1.461279, 0.000000>, <-0.165642, 1.461279, 0.000000>, <0.000000, 1.461279, 0.000000>, <0.165642, 1.461279, 0.000000>, 
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>, 
      <-0.331285, 3.820426, -0.088447>, <-0.165642, 3.820426, -0.088447>, <0.000000, 3.820426, -0.088447>, <0.165642, 3.820426, -0.088447>, 
      <-0.331285, 5.000000, 0.088447>, <-0.165642, 5.000000, 0.088447>, <0.000000, 5.000000, 0.088447>, <0.165642, 5.000000, 0.088447>, 
      <-0.331285, 5.012346, 1.857395>, <-0.165642, 5.012346, 1.857395>, <0.000000, 5.012346, 1.857395>, <0.165642, 5.012346, 1.857395>
    }
  }
  rotate <91.002113, 0.0, 45.0>
  translate  <36.362912, -46.133111, 10.817071>
}
#declare BezPtch076 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -8.065095, 2.741868>, <-0.165642, -8.065095, 2.741868>, <0.000000, -8.065095, 2.741868>, <0.165642, -8.065095, 2.741868>, 
      <-0.333985, -7.937644, 0.088447>, <-0.168343, -7.937644, 0.088447>, <-0.002700, -7.937644, 0.088447>, <0.162942, -7.937644, 0.088447>, 
      <-0.331285, -6.154882, 0.353789>, <-0.165642, -6.154882, 0.353789>, <0.000000, -6.154882, 0.353789>, <0.165642, -6.154882, 0.353789>, 
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>, 
      <-0.331285, -3.705948, 0.353789>, <-0.165642, -3.705948, 0.353789>, <0.000000, -3.705948, 0.353789>, <0.165642, -3.705948, 0.353789>, 
      <-0.331285, -4.052750, 3.184105>, <-0.165642, -4.052750, 3.184105>, <0.000000, -4.052750, 3.184105>, <0.165642, -4.052750, 3.184105>, 
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>, 
      <-0.331285, 1.269360, 3.537894>, <-0.165642, 1.269360, 3.537894>, <0.000000, 1.269360, 3.537894>, <0.165642, 1.269360, 3.537894>, 
      <-0.331285, 1.461279, 0.000000>, <-0.165642, 1.461279, 0.000000>, <0.000000, 1.461279, 0.000000>, <0.165642, 1.461279, 0.000000>, 
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>, 
      <-0.331285, 3.820426, -0.088447>, <-0.165642, 3.820426, -0.088447>, <0.000000, 3.820426, -0.088447>, <0.165642, 3.820426, -0.088447>, 
      <-0.331285, 5.000000, 0.088447>, <-0.165642, 5.000000, 0.088447>, <0.000000, 5.000000, 0.088447>, <0.165642, 5.000000, 0.088447>, 
      <-0.331285, 5.012346, 1.857395>, <-0.165642, 5.012346, 1.857395>, <0.000000, 5.012346, 1.857395>, <0.165642, 5.012346, 1.857395>
    }
  }
  rotate <91.002113, 0.0, 135.0>
  translate  <36.189083, -44.134074, 10.817071>
}
#declare BezPtch077 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -8.065095, 2.741868>, <-0.165642, -8.065095, 2.741868>, <0.000000, -8.065095, 2.741868>, <0.165642, -8.065095, 2.741868>, 
      <-0.333985, -7.937644, 0.088447>, <-0.168343, -7.937644, 0.088447>, <-0.002700, -7.937644, 0.088447>, <0.162942, -7.937644, 0.088447>, 
      <-0.331285, -6.154882, 0.353789>, <-0.165642, -6.154882, 0.353789>, <0.000000, -6.154882, 0.353789>, <0.165642, -6.154882, 0.353789>, 
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>, 
      <-0.331285, -3.705948, 0.353789>, <-0.165642, -3.705948, 0.353789>, <0.000000, -3.705948, 0.353789>, <0.165642, -3.705948, 0.353789>, 
      <-0.331285, -4.052750, 3.184105>, <-0.165642, -4.052750, 3.184105>, <0.000000, -4.052750, 3.184105>, <0.165642, -4.052750, 3.184105>, 
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>, 
      <-0.331285, 1.269360, 3.537894>, <-0.165642, 1.269360, 3.537894>, <0.000000, 1.269360, 3.537894>, <0.165642, 1.269360, 3.537894>, 
      <-0.331285, 1.461279, 0.000000>, <-0.165642, 1.461279, 0.000000>, <0.000000, 1.461279, 0.000000>, <0.165642, 1.461279, 0.000000>, 
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>, 
      <-0.331285, 3.820426, -0.088447>, <-0.165642, 3.820426, -0.088447>, <0.000000, 3.820426, -0.088447>, <0.165642, 3.820426, -0.088447>, 
      <-0.331285, 5.000000, 0.088447>, <-0.165642, 5.000000, 0.088447>, <0.000000, 5.000000, 0.088447>, <0.165642, 5.000000, 0.088447>, 
      <-0.331285, 5.012346, 1.857395>, <-0.165642, 5.012346, 1.857395>, <0.000000, 5.012346, 1.857395>, <0.165642, 5.012346, 1.857395>
    }
  }
  rotate <91.002113, 0.0, -135.0>
  translate  <34.016217, -44.481733, 10.817071>
}
#declare BezPtch078 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -8.065095, 2.741868>, <-0.165642, -8.065095, 2.741868>, <0.000000, -8.065095, 2.741868>, <0.165642, -8.065095, 2.741868>, 
      <-0.333985, -7.937644, 0.088447>, <-0.168343, -7.937644, 0.088447>, <-0.002700, -7.937644, 0.088447>, <0.162942, -7.937644, 0.088447>, 
      <-0.331285, -6.154882, 0.353789>, <-0.165642, -6.154882, 0.353789>, <0.000000, -6.154882, 0.353789>, <0.165642, -6.154882, 0.353789>, 
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>, 
      <-0.331285, -3.705948, 0.353789>, <-0.165642, -3.705948, 0.353789>, <0.000000, -3.705948, 0.353789>, <0.165642, -3.705948, 0.353789>, 
      <-0.331285, -4.052750, 3.184105>, <-0.165642, -4.052750, 3.184105>, <0.000000, -4.052750, 3.184105>, <0.165642, -4.052750, 3.184105>, 
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>, 
      <-0.331285, 1.269360, 3.537894>, <-0.165642, 1.269360, 3.537894>, <0.000000, 1.269360, 3.537894>, <0.165642, 1.269360, 3.537894>, 
      <-0.331285, 1.461279, 0.000000>, <-0.165642, 1.461279, 0.000000>, <0.000000, 1.461279, 0.000000>, <0.165642, 1.461279, 0.000000>, 
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>, 
      <-0.331285, 3.820426, -0.088447>, <-0.165642, 3.820426, -0.088447>, <0.000000, 3.820426, -0.088447>, <0.165642, 3.820426, -0.088447>, 
      <-0.331285, 5.000000, 0.088447>, <-0.165642, 5.000000, 0.088447>, <0.000000, 5.000000, 0.088447>, <0.165642, 5.000000, 0.088447>, 
      <-0.331285, 5.012346, 1.857395>, <-0.165642, 5.012346, 1.857395>, <0.000000, 5.012346, 1.857395>, <0.165642, 5.012346, 1.857395>
    }
  }
  rotate <91.002113, 0.0, -90.0>
  translate  <33.407814, -45.17705, 10.817071>
}
#declare BezPtch079 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -8.065095, 2.741868>, <-0.165642, -8.065095, 2.741868>, <0.000000, -8.065095, 2.741868>, <0.165642, -8.065095, 2.741868>, 
      <-0.333985, -7.937644, 0.088447>, <-0.168343, -7.937644, 0.088447>, <-0.002700, -7.937644, 0.088447>, <0.162942, -7.937644, 0.088447>, 
      <-0.331285, -6.154882, 0.353789>, <-0.165642, -6.154882, 0.353789>, <0.000000, -6.154882, 0.353789>, <0.165642, -6.154882, 0.353789>, 
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>, 
      <-0.331285, -3.705948, 0.353789>, <-0.165642, -3.705948, 0.353789>, <0.000000, -3.705948, 0.353789>, <0.165642, -3.705948, 0.353789>, 
      <-0.331285, -4.052750, 3.184105>, <-0.165642, -4.052750, 3.184105>, <0.000000, -4.052750, 3.184105>, <0.165642, -4.052750, 3.184105>, 
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>, 
      <-0.331285, 1.269360, 3.537894>, <-0.165642, 1.269360, 3.537894>, <0.000000, 1.269360, 3.537894>, <0.165642, 1.269360, 3.537894>, 
      <-0.331285, 1.461279, 0.000000>, <-0.165642, 1.461279, 0.000000>, <0.000000, 1.461279, 0.000000>, <0.165642, 1.461279, 0.000000>, 
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>, 
      <-0.331285, 3.820426, -0.088447>, <-0.165642, 3.820426, -0.088447>, <0.000000, 3.820426, -0.088447>, <0.165642, 3.820426, -0.088447>, 
      <-0.331285, 5.000000, 0.088447>, <-0.165642, 5.000000, 0.088447>, <0.000000, 5.000000, 0.088447>, <0.165642, 5.000000, 0.088447>, 
      <-0.331285, 5.012346, 1.857395>, <-0.165642, 5.012346, 1.857395>, <0.000000, 5.012346, 1.857395>, <0.165642, 5.012346, 1.857395>
    }
  }
  rotate <91.002113, 0.0, -45.0>
  translate  <34.016217, -46.046196, 10.817071>
}
#declare BezPtch080 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -8.065095, 2.741868>, <-0.165642, -8.065095, 2.741868>, <0.000000, -8.065095, 2.741868>, <0.165642, -8.065095, 2.741868>, 
      <-0.333985, -7.937644, 0.088447>, <-0.168343, -7.937644, 0.088447>, <-0.002700, -7.937644, 0.088447>, <0.162942, -7.937644, 0.088447>, 
      <-0.331285, -6.154882, 0.353789>, <-0.165642, -6.154882, 0.353789>, <0.000000, -6.154882, 0.353789>, <0.165642, -6.154882, 0.353789>, 
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>, 
      <-0.331285, -3.705948, 0.353789>, <-0.165642, -3.705948, 0.353789>, <0.000000, -3.705948, 0.353789>, <0.165642, -3.705948, 0.353789>, 
      <-0.331285, -4.052750, 3.184105>, <-0.165642, -4.052750, 3.184105>, <0.000000, -4.052750, 3.184105>, <0.165642, -4.052750, 3.184105>, 
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>, 
      <-0.331285, 1.269360, 3.537894>, <-0.165642, 1.269360, 3.537894>, <0.000000, 1.269360, 3.537894>, <0.165642, 1.269360, 3.537894>, 
      <-0.331285, 1.461279, 0.000000>, <-0.165642, 1.461279, 0.000000>, <0.000000, 1.461279, 0.000000>, <0.165642, 1.461279, 0.000000>, 
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>, 
      <-0.331285, 3.820426, -0.088447>, <-0.165642, 3.820426, -0.088447>, <0.000000, 3.820426, -0.088447>, <0.165642, 3.820426, -0.088447>, 
      <-0.331285, 5.000000, 0.088447>, <-0.165642, 5.000000, 0.088447>, <0.000000, 5.000000, 0.088447>, <0.165642, 5.000000, 0.088447>, 
      <-0.331285, 5.012346, 1.857395>, <-0.165642, 5.012346, 1.857395>, <0.000000, 5.012346, 1.857395>, <0.165642, 5.012346, 1.857395>
    }
  }
  rotate <91.002113, 0.0, 0.0>
  translate  <35.233022, -46.567684, 10.817071>
}
#declare lamp9 = union {
  sphere { // Sphere013
    <0,0,0>,1
    material {
      Glass
    }
    hollow
    scale <5.0, 5.0, 3.261394>
    translate  <35.095907, -45.140268, 9.51724>
  }
  object { BezPtch073 }
  object { BezPtch074 }
  object { BezPtch075 }
  object { BezPtch076 }
  object { BezPtch077 }
  object { BezPtch078 }
  object { BezPtch079 }
  object { BezPtch080 }
  cone { // Cone019
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale 1.716519
    rotate <180.0, 0.0, 180.0>
    translate  <35.128593, -45.169069, 16.365649>
  }
  torus { // Torus053
    1.75, 0.25  rotate -x*90
    scale 1.091333
    rotate 0.0*x
    translate  <35.06776, -45.169069, 13.234877>
  }
  cylinder { // Cylndr178
    <0,0,1>, <0,0,0>, 1 
    scale 2.064656
    rotate 0.0*x
    translate  <35.268193, -45.169069, 4.005444>
  }
  torus { // Torus054
    1.75, 0.25  rotate -x*90
    scale 1.091333
    rotate 0.0*x
    translate  <35.128593, -45.169069, 14.2082>
  }
  cylinder { // Cylndr179
    <0,0,1>, <0,0,0>, 1 
    scale <0.333333, 0.333333, 20.0>
    rotate <180.0, -0.0, -180.0>
    translate  <35.009483, -44.966081, 35.268835>
  }
  cone { // Cone020
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale 2.465107
    rotate 0.0*y
    translate  <35.009391, -44.976931, 28.187788>
  }
  sphere { // Sphere026
    <0,0,0>,1
    material {
      lampwhite
    }
    no_shadow
    scale 0.734142
    rotate <-0.0, 0.0, -30.0>
    translate  <35.041314, -45.284038, 9.456169>
  }
  material {
    ironblack
  }
  scale 0.15
  rotate -270.0*z
  translate  <12.578051, -10.375813, 16.133418>
}
#declare BezPtch081 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -8.065095, 2.741868>, <-0.165642, -8.065095, 2.741868>, <0.000000, -8.065095, 2.741868>, <0.165642, -8.065095, 2.741868>, 
      <-0.333985, -7.937644, 0.088447>, <-0.168343, -7.937644, 0.088447>, <-0.002700, -7.937644, 0.088447>, <0.162942, -7.937644, 0.088447>, 
      <-0.331285, -6.154882, 0.353789>, <-0.165642, -6.154882, 0.353789>, <0.000000, -6.154882, 0.353789>, <0.165642, -6.154882, 0.353789>, 
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>, 
      <-0.331285, -3.705948, 0.353789>, <-0.165642, -3.705948, 0.353789>, <0.000000, -3.705948, 0.353789>, <0.165642, -3.705948, 0.353789>, 
      <-0.331285, -4.052750, 3.184105>, <-0.165642, -4.052750, 3.184105>, <0.000000, -4.052750, 3.184105>, <0.165642, -4.052750, 3.184105>, 
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>, 
      <-0.331285, 1.269360, 3.537894>, <-0.165642, 1.269360, 3.537894>, <0.000000, 1.269360, 3.537894>, <0.165642, 1.269360, 3.537894>, 
      <-0.331285, 1.461279, 0.000000>, <-0.165642, 1.461279, 0.000000>, <0.000000, 1.461279, 0.000000>, <0.165642, 1.461279, 0.000000>, 
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>, 
      <-0.331285, 3.820426, -0.088447>, <-0.165642, 3.820426, -0.088447>, <0.000000, 3.820426, -0.088447>, <0.165642, 3.820426, -0.088447>, 
      <-0.331285, 5.000000, 0.088447>, <-0.165642, 5.000000, 0.088447>, <0.000000, 5.000000, 0.088447>, <0.165642, 5.000000, 0.088447>, 
      <-0.331285, 5.012346, 1.857395>, <-0.165642, 5.012346, 1.857395>, <0.000000, 5.012346, 1.857395>, <0.165642, 5.012346, 1.857395>
    }
  }
  rotate <91.002113, 0.0, 180.0>
  translate  <34.972278, -43.612587, 10.817071>
}
#declare BezPtch082 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -8.065095, 2.741868>, <-0.165642, -8.065095, 2.741868>, <0.000000, -8.065095, 2.741868>, <0.165642, -8.065095, 2.741868>, 
      <-0.333985, -7.937644, 0.088447>, <-0.168343, -7.937644, 0.088447>, <-0.002700, -7.937644, 0.088447>, <0.162942, -7.937644, 0.088447>, 
      <-0.331285, -6.154882, 0.353789>, <-0.165642, -6.154882, 0.353789>, <0.000000, -6.154882, 0.353789>, <0.165642, -6.154882, 0.353789>, 
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>, 
      <-0.331285, -3.705948, 0.353789>, <-0.165642, -3.705948, 0.353789>, <0.000000, -3.705948, 0.353789>, <0.165642, -3.705948, 0.353789>, 
      <-0.331285, -4.052750, 3.184105>, <-0.165642, -4.052750, 3.184105>, <0.000000, -4.052750, 3.184105>, <0.165642, -4.052750, 3.184105>, 
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>, 
      <-0.331285, 1.269360, 3.537894>, <-0.165642, 1.269360, 3.537894>, <0.000000, 1.269360, 3.537894>, <0.165642, 1.269360, 3.537894>, 
      <-0.331285, 1.461279, 0.000000>, <-0.165642, 1.461279, 0.000000>, <0.000000, 1.461279, 0.000000>, <0.165642, 1.461279, 0.000000>, 
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>, 
      <-0.331285, 3.820426, -0.088447>, <-0.165642, 3.820426, -0.088447>, <0.000000, 3.820426, -0.088447>, <0.165642, 3.820426, -0.088447>, 
      <-0.331285, 5.000000, 0.088447>, <-0.165642, 5.000000, 0.088447>, <0.000000, 5.000000, 0.088447>, <0.165642, 5.000000, 0.088447>, 
      <-0.331285, 5.012346, 1.857395>, <-0.165642, 5.012346, 1.857395>, <0.000000, 5.012346, 1.857395>, <0.165642, 5.012346, 1.857395>
    }
  }
  rotate <91.002113, 0.0, 90.0>
  translate  <36.710571, -44.916306, 10.817071>
}
#declare BezPtch083 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -8.065095, 2.741868>, <-0.165642, -8.065095, 2.741868>, <0.000000, -8.065095, 2.741868>, <0.165642, -8.065095, 2.741868>, 
      <-0.333985, -7.937644, 0.088447>, <-0.168343, -7.937644, 0.088447>, <-0.002700, -7.937644, 0.088447>, <0.162942, -7.937644, 0.088447>, 
      <-0.331285, -6.154882, 0.353789>, <-0.165642, -6.154882, 0.353789>, <0.000000, -6.154882, 0.353789>, <0.165642, -6.154882, 0.353789>, 
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>, 
      <-0.331285, -3.705948, 0.353789>, <-0.165642, -3.705948, 0.353789>, <0.000000, -3.705948, 0.353789>, <0.165642, -3.705948, 0.353789>, 
      <-0.331285, -4.052750, 3.184105>, <-0.165642, -4.052750, 3.184105>, <0.000000, -4.052750, 3.184105>, <0.165642, -4.052750, 3.184105>, 
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>, 
      <-0.331285, 1.269360, 3.537894>, <-0.165642, 1.269360, 3.537894>, <0.000000, 1.269360, 3.537894>, <0.165642, 1.269360, 3.537894>, 
      <-0.331285, 1.461279, 0.000000>, <-0.165642, 1.461279, 0.000000>, <0.000000, 1.461279, 0.000000>, <0.165642, 1.461279, 0.000000>, 
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>, 
      <-0.331285, 3.820426, -0.088447>, <-0.165642, 3.820426, -0.088447>, <0.000000, 3.820426, -0.088447>, <0.165642, 3.820426, -0.088447>, 
      <-0.331285, 5.000000, 0.088447>, <-0.165642, 5.000000, 0.088447>, <0.000000, 5.000000, 0.088447>, <0.165642, 5.000000, 0.088447>, 
      <-0.331285, 5.012346, 1.857395>, <-0.165642, 5.012346, 1.857395>, <0.000000, 5.012346, 1.857395>, <0.165642, 5.012346, 1.857395>
    }
  }
  rotate <91.002113, 0.0, 45.0>
  translate  <36.362912, -46.133111, 10.817071>
}
#declare BezPtch084 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -8.065095, 2.741868>, <-0.165642, -8.065095, 2.741868>, <0.000000, -8.065095, 2.741868>, <0.165642, -8.065095, 2.741868>, 
      <-0.333985, -7.937644, 0.088447>, <-0.168343, -7.937644, 0.088447>, <-0.002700, -7.937644, 0.088447>, <0.162942, -7.937644, 0.088447>, 
      <-0.331285, -6.154882, 0.353789>, <-0.165642, -6.154882, 0.353789>, <0.000000, -6.154882, 0.353789>, <0.165642, -6.154882, 0.353789>, 
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>, 
      <-0.331285, -3.705948, 0.353789>, <-0.165642, -3.705948, 0.353789>, <0.000000, -3.705948, 0.353789>, <0.165642, -3.705948, 0.353789>, 
      <-0.331285, -4.052750, 3.184105>, <-0.165642, -4.052750, 3.184105>, <0.000000, -4.052750, 3.184105>, <0.165642, -4.052750, 3.184105>, 
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>, 
      <-0.331285, 1.269360, 3.537894>, <-0.165642, 1.269360, 3.537894>, <0.000000, 1.269360, 3.537894>, <0.165642, 1.269360, 3.537894>, 
      <-0.331285, 1.461279, 0.000000>, <-0.165642, 1.461279, 0.000000>, <0.000000, 1.461279, 0.000000>, <0.165642, 1.461279, 0.000000>, 
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>, 
      <-0.331285, 3.820426, -0.088447>, <-0.165642, 3.820426, -0.088447>, <0.000000, 3.820426, -0.088447>, <0.165642, 3.820426, -0.088447>, 
      <-0.331285, 5.000000, 0.088447>, <-0.165642, 5.000000, 0.088447>, <0.000000, 5.000000, 0.088447>, <0.165642, 5.000000, 0.088447>, 
      <-0.331285, 5.012346, 1.857395>, <-0.165642, 5.012346, 1.857395>, <0.000000, 5.012346, 1.857395>, <0.165642, 5.012346, 1.857395>
    }
  }
  rotate <91.002113, 0.0, 135.0>
  translate  <36.189083, -44.134074, 10.817071>
}
#declare BezPtch085 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -8.065095, 2.741868>, <-0.165642, -8.065095, 2.741868>, <0.000000, -8.065095, 2.741868>, <0.165642, -8.065095, 2.741868>, 
      <-0.333985, -7.937644, 0.088447>, <-0.168343, -7.937644, 0.088447>, <-0.002700, -7.937644, 0.088447>, <0.162942, -7.937644, 0.088447>, 
      <-0.331285, -6.154882, 0.353789>, <-0.165642, -6.154882, 0.353789>, <0.000000, -6.154882, 0.353789>, <0.165642, -6.154882, 0.353789>, 
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>, 
      <-0.331285, -3.705948, 0.353789>, <-0.165642, -3.705948, 0.353789>, <0.000000, -3.705948, 0.353789>, <0.165642, -3.705948, 0.353789>, 
      <-0.331285, -4.052750, 3.184105>, <-0.165642, -4.052750, 3.184105>, <0.000000, -4.052750, 3.184105>, <0.165642, -4.052750, 3.184105>, 
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>, 
      <-0.331285, 1.269360, 3.537894>, <-0.165642, 1.269360, 3.537894>, <0.000000, 1.269360, 3.537894>, <0.165642, 1.269360, 3.537894>, 
      <-0.331285, 1.461279, 0.000000>, <-0.165642, 1.461279, 0.000000>, <0.000000, 1.461279, 0.000000>, <0.165642, 1.461279, 0.000000>, 
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>, 
      <-0.331285, 3.820426, -0.088447>, <-0.165642, 3.820426, -0.088447>, <0.000000, 3.820426, -0.088447>, <0.165642, 3.820426, -0.088447>, 
      <-0.331285, 5.000000, 0.088447>, <-0.165642, 5.000000, 0.088447>, <0.000000, 5.000000, 0.088447>, <0.165642, 5.000000, 0.088447>, 
      <-0.331285, 5.012346, 1.857395>, <-0.165642, 5.012346, 1.857395>, <0.000000, 5.012346, 1.857395>, <0.165642, 5.012346, 1.857395>
    }
  }
  rotate <91.002113, 0.0, -135.0>
  translate  <34.016217, -44.481733, 10.817071>
}
#declare BezPtch086 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -8.065095, 2.741868>, <-0.165642, -8.065095, 2.741868>, <0.000000, -8.065095, 2.741868>, <0.165642, -8.065095, 2.741868>, 
      <-0.333985, -7.937644, 0.088447>, <-0.168343, -7.937644, 0.088447>, <-0.002700, -7.937644, 0.088447>, <0.162942, -7.937644, 0.088447>, 
      <-0.331285, -6.154882, 0.353789>, <-0.165642, -6.154882, 0.353789>, <0.000000, -6.154882, 0.353789>, <0.165642, -6.154882, 0.353789>, 
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>, 
      <-0.331285, -3.705948, 0.353789>, <-0.165642, -3.705948, 0.353789>, <0.000000, -3.705948, 0.353789>, <0.165642, -3.705948, 0.353789>, 
      <-0.331285, -4.052750, 3.184105>, <-0.165642, -4.052750, 3.184105>, <0.000000, -4.052750, 3.184105>, <0.165642, -4.052750, 3.184105>, 
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>, 
      <-0.331285, 1.269360, 3.537894>, <-0.165642, 1.269360, 3.537894>, <0.000000, 1.269360, 3.537894>, <0.165642, 1.269360, 3.537894>, 
      <-0.331285, 1.461279, 0.000000>, <-0.165642, 1.461279, 0.000000>, <0.000000, 1.461279, 0.000000>, <0.165642, 1.461279, 0.000000>, 
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>, 
      <-0.331285, 3.820426, -0.088447>, <-0.165642, 3.820426, -0.088447>, <0.000000, 3.820426, -0.088447>, <0.165642, 3.820426, -0.088447>, 
      <-0.331285, 5.000000, 0.088447>, <-0.165642, 5.000000, 0.088447>, <0.000000, 5.000000, 0.088447>, <0.165642, 5.000000, 0.088447>, 
      <-0.331285, 5.012346, 1.857395>, <-0.165642, 5.012346, 1.857395>, <0.000000, 5.012346, 1.857395>, <0.165642, 5.012346, 1.857395>
    }
  }
  rotate <91.002113, 0.0, -90.0>
  translate  <33.407814, -45.17705, 10.817071>
}
#declare BezPtch087 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -8.065095, 2.741868>, <-0.165642, -8.065095, 2.741868>, <0.000000, -8.065095, 2.741868>, <0.165642, -8.065095, 2.741868>, 
      <-0.333985, -7.937644, 0.088447>, <-0.168343, -7.937644, 0.088447>, <-0.002700, -7.937644, 0.088447>, <0.162942, -7.937644, 0.088447>, 
      <-0.331285, -6.154882, 0.353789>, <-0.165642, -6.154882, 0.353789>, <0.000000, -6.154882, 0.353789>, <0.165642, -6.154882, 0.353789>, 
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>, 
      <-0.331285, -3.705948, 0.353789>, <-0.165642, -3.705948, 0.353789>, <0.000000, -3.705948, 0.353789>, <0.165642, -3.705948, 0.353789>, 
      <-0.331285, -4.052750, 3.184105>, <-0.165642, -4.052750, 3.184105>, <0.000000, -4.052750, 3.184105>, <0.165642, -4.052750, 3.184105>, 
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>, 
      <-0.331285, 1.269360, 3.537894>, <-0.165642, 1.269360, 3.537894>, <0.000000, 1.269360, 3.537894>, <0.165642, 1.269360, 3.537894>, 
      <-0.331285, 1.461279, 0.000000>, <-0.165642, 1.461279, 0.000000>, <0.000000, 1.461279, 0.000000>, <0.165642, 1.461279, 0.000000>, 
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>, 
      <-0.331285, 3.820426, -0.088447>, <-0.165642, 3.820426, -0.088447>, <0.000000, 3.820426, -0.088447>, <0.165642, 3.820426, -0.088447>, 
      <-0.331285, 5.000000, 0.088447>, <-0.165642, 5.000000, 0.088447>, <0.000000, 5.000000, 0.088447>, <0.165642, 5.000000, 0.088447>, 
      <-0.331285, 5.012346, 1.857395>, <-0.165642, 5.012346, 1.857395>, <0.000000, 5.012346, 1.857395>, <0.165642, 5.012346, 1.857395>
    }
  }
  rotate <91.002113, 0.0, -45.0>
  translate  <34.016217, -46.046196, 10.817071>
}
#declare BezPtch088 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -8.065095, 2.741868>, <-0.165642, -8.065095, 2.741868>, <0.000000, -8.065095, 2.741868>, <0.165642, -8.065095, 2.741868>, 
      <-0.333985, -7.937644, 0.088447>, <-0.168343, -7.937644, 0.088447>, <-0.002700, -7.937644, 0.088447>, <0.162942, -7.937644, 0.088447>, 
      <-0.331285, -6.154882, 0.353789>, <-0.165642, -6.154882, 0.353789>, <0.000000, -6.154882, 0.353789>, <0.165642, -6.154882, 0.353789>, 
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>, 
      <-0.331285, -3.705948, 0.353789>, <-0.165642, -3.705948, 0.353789>, <0.000000, -3.705948, 0.353789>, <0.165642, -3.705948, 0.353789>, 
      <-0.331285, -4.052750, 3.184105>, <-0.165642, -4.052750, 3.184105>, <0.000000, -4.052750, 3.184105>, <0.165642, -4.052750, 3.184105>, 
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>, 
      <-0.331285, 1.269360, 3.537894>, <-0.165642, 1.269360, 3.537894>, <0.000000, 1.269360, 3.537894>, <0.165642, 1.269360, 3.537894>, 
      <-0.331285, 1.461279, 0.000000>, <-0.165642, 1.461279, 0.000000>, <0.000000, 1.461279, 0.000000>, <0.165642, 1.461279, 0.000000>, 
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>, 
      <-0.331285, 3.820426, -0.088447>, <-0.165642, 3.820426, -0.088447>, <0.000000, 3.820426, -0.088447>, <0.165642, 3.820426, -0.088447>, 
      <-0.331285, 5.000000, 0.088447>, <-0.165642, 5.000000, 0.088447>, <0.000000, 5.000000, 0.088447>, <0.165642, 5.000000, 0.088447>, 
      <-0.331285, 5.012346, 1.857395>, <-0.165642, 5.012346, 1.857395>, <0.000000, 5.012346, 1.857395>, <0.165642, 5.012346, 1.857395>
    }
  }
  rotate <91.002113, 0.0, 0.0>
  translate  <35.233022, -46.567684, 10.817071>
}
#declare lamp10 = union {
  sphere { // Sphere014
    <0,0,0>,1
    material {
      Glass
    }
    hollow
    scale <5.0, 5.0, 3.261394>
    translate  <35.095907, -45.140268, 9.51724>
  }
  object { BezPtch081 }
  object { BezPtch082 }
  object { BezPtch083 }
  object { BezPtch084 }
  object { BezPtch085 }
  object { BezPtch086 }
  object { BezPtch087 }
  object { BezPtch088 }
  cone { // Cone021
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale 1.716519
    rotate <180.0, 0.0, 180.0>
    translate  <35.128593, -45.169069, 16.365649>
  }
  torus { // Torus055
    1.75, 0.25  rotate -x*90
    scale 1.091333
    rotate 0.0*x
    translate  <35.06776, -45.169069, 13.234877>
  }
  cylinder { // Cylndr180
    <0,0,1>, <0,0,0>, 1 
    scale 2.064656
    rotate 0.0*x
    translate  <35.268193, -45.169069, 4.005444>
  }
  torus { // Torus056
    1.75, 0.25  rotate -x*90
    scale 1.091333
    rotate 0.0*x
    translate  <35.128593, -45.169069, 14.2082>
  }
  cylinder { // Cylndr181
    <0,0,1>, <0,0,0>, 1 
    scale <0.333333, 0.333333, 20.0>
    rotate <180.0, -0.0, -180.0>
    translate  <35.009483, -44.966081, 35.268835>
  }
  cone { // Cone022
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale 2.465107
    rotate 0.0*y
    translate  <35.009391, -44.976931, 28.187788>
  }
  sphere { // Sphere027
    <0,0,0>,1
    material {
      lampwhite
    }
    no_shadow
    scale 0.734142
    rotate <-0.0, 0.0, -30.0>
    translate  <35.041314, -45.284038, 9.456169>
  }
  material {
    ironblack
  }
  scale 0.15
  rotate -300.0*z
  translate  <5.705005, -15.274743, 16.133418>
}
#declare BezPtch089 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -8.065095, 2.741868>, <-0.165642, -8.065095, 2.741868>, <0.000000, -8.065095, 2.741868>, <0.165642, -8.065095, 2.741868>, 
      <-0.333985, -7.937644, 0.088447>, <-0.168343, -7.937644, 0.088447>, <-0.002700, -7.937644, 0.088447>, <0.162942, -7.937644, 0.088447>, 
      <-0.331285, -6.154882, 0.353789>, <-0.165642, -6.154882, 0.353789>, <0.000000, -6.154882, 0.353789>, <0.165642, -6.154882, 0.353789>, 
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>, 
      <-0.331285, -3.705948, 0.353789>, <-0.165642, -3.705948, 0.353789>, <0.000000, -3.705948, 0.353789>, <0.165642, -3.705948, 0.353789>, 
      <-0.331285, -4.052750, 3.184105>, <-0.165642, -4.052750, 3.184105>, <0.000000, -4.052750, 3.184105>, <0.165642, -4.052750, 3.184105>, 
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>, 
      <-0.331285, 1.269360, 3.537894>, <-0.165642, 1.269360, 3.537894>, <0.000000, 1.269360, 3.537894>, <0.165642, 1.269360, 3.537894>, 
      <-0.331285, 1.461279, 0.000000>, <-0.165642, 1.461279, 0.000000>, <0.000000, 1.461279, 0.000000>, <0.165642, 1.461279, 0.000000>, 
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>, 
      <-0.331285, 3.820426, -0.088447>, <-0.165642, 3.820426, -0.088447>, <0.000000, 3.820426, -0.088447>, <0.165642, 3.820426, -0.088447>, 
      <-0.331285, 5.000000, 0.088447>, <-0.165642, 5.000000, 0.088447>, <0.000000, 5.000000, 0.088447>, <0.165642, 5.000000, 0.088447>, 
      <-0.331285, 5.012346, 1.857395>, <-0.165642, 5.012346, 1.857395>, <0.000000, 5.012346, 1.857395>, <0.165642, 5.012346, 1.857395>
    }
  }
  rotate <91.002113, 0.0, 180.0>
  translate  <34.972278, -43.612587, 10.817071>
}
#declare BezPtch090 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -8.065095, 2.741868>, <-0.165642, -8.065095, 2.741868>, <0.000000, -8.065095, 2.741868>, <0.165642, -8.065095, 2.741868>, 
      <-0.333985, -7.937644, 0.088447>, <-0.168343, -7.937644, 0.088447>, <-0.002700, -7.937644, 0.088447>, <0.162942, -7.937644, 0.088447>, 
      <-0.331285, -6.154882, 0.353789>, <-0.165642, -6.154882, 0.353789>, <0.000000, -6.154882, 0.353789>, <0.165642, -6.154882, 0.353789>, 
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>, 
      <-0.331285, -3.705948, 0.353789>, <-0.165642, -3.705948, 0.353789>, <0.000000, -3.705948, 0.353789>, <0.165642, -3.705948, 0.353789>, 
      <-0.331285, -4.052750, 3.184105>, <-0.165642, -4.052750, 3.184105>, <0.000000, -4.052750, 3.184105>, <0.165642, -4.052750, 3.184105>, 
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>, 
      <-0.331285, 1.269360, 3.537894>, <-0.165642, 1.269360, 3.537894>, <0.000000, 1.269360, 3.537894>, <0.165642, 1.269360, 3.537894>, 
      <-0.331285, 1.461279, 0.000000>, <-0.165642, 1.461279, 0.000000>, <0.000000, 1.461279, 0.000000>, <0.165642, 1.461279, 0.000000>, 
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>, 
      <-0.331285, 3.820426, -0.088447>, <-0.165642, 3.820426, -0.088447>, <0.000000, 3.820426, -0.088447>, <0.165642, 3.820426, -0.088447>, 
      <-0.331285, 5.000000, 0.088447>, <-0.165642, 5.000000, 0.088447>, <0.000000, 5.000000, 0.088447>, <0.165642, 5.000000, 0.088447>, 
      <-0.331285, 5.012346, 1.857395>, <-0.165642, 5.012346, 1.857395>, <0.000000, 5.012346, 1.857395>, <0.165642, 5.012346, 1.857395>
    }
  }
  rotate <91.002113, 0.0, 90.0>
  translate  <36.710571, -44.916306, 10.817071>
}
#declare BezPtch091 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -8.065095, 2.741868>, <-0.165642, -8.065095, 2.741868>, <0.000000, -8.065095, 2.741868>, <0.165642, -8.065095, 2.741868>, 
      <-0.333985, -7.937644, 0.088447>, <-0.168343, -7.937644, 0.088447>, <-0.002700, -7.937644, 0.088447>, <0.162942, -7.937644, 0.088447>, 
      <-0.331285, -6.154882, 0.353789>, <-0.165642, -6.154882, 0.353789>, <0.000000, -6.154882, 0.353789>, <0.165642, -6.154882, 0.353789>, 
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>, 
      <-0.331285, -3.705948, 0.353789>, <-0.165642, -3.705948, 0.353789>, <0.000000, -3.705948, 0.353789>, <0.165642, -3.705948, 0.353789>, 
      <-0.331285, -4.052750, 3.184105>, <-0.165642, -4.052750, 3.184105>, <0.000000, -4.052750, 3.184105>, <0.165642, -4.052750, 3.184105>, 
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>, 
      <-0.331285, 1.269360, 3.537894>, <-0.165642, 1.269360, 3.537894>, <0.000000, 1.269360, 3.537894>, <0.165642, 1.269360, 3.537894>, 
      <-0.331285, 1.461279, 0.000000>, <-0.165642, 1.461279, 0.000000>, <0.000000, 1.461279, 0.000000>, <0.165642, 1.461279, 0.000000>, 
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>, 
      <-0.331285, 3.820426, -0.088447>, <-0.165642, 3.820426, -0.088447>, <0.000000, 3.820426, -0.088447>, <0.165642, 3.820426, -0.088447>, 
      <-0.331285, 5.000000, 0.088447>, <-0.165642, 5.000000, 0.088447>, <0.000000, 5.000000, 0.088447>, <0.165642, 5.000000, 0.088447>, 
      <-0.331285, 5.012346, 1.857395>, <-0.165642, 5.012346, 1.857395>, <0.000000, 5.012346, 1.857395>, <0.165642, 5.012346, 1.857395>
    }
  }
  rotate <91.002113, 0.0, 45.0>
  translate  <36.362912, -46.133111, 10.817071>
}
#declare BezPtch092 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -8.065095, 2.741868>, <-0.165642, -8.065095, 2.741868>, <0.000000, -8.065095, 2.741868>, <0.165642, -8.065095, 2.741868>, 
      <-0.333985, -7.937644, 0.088447>, <-0.168343, -7.937644, 0.088447>, <-0.002700, -7.937644, 0.088447>, <0.162942, -7.937644, 0.088447>, 
      <-0.331285, -6.154882, 0.353789>, <-0.165642, -6.154882, 0.353789>, <0.000000, -6.154882, 0.353789>, <0.165642, -6.154882, 0.353789>, 
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>, 
      <-0.331285, -3.705948, 0.353789>, <-0.165642, -3.705948, 0.353789>, <0.000000, -3.705948, 0.353789>, <0.165642, -3.705948, 0.353789>, 
      <-0.331285, -4.052750, 3.184105>, <-0.165642, -4.052750, 3.184105>, <0.000000, -4.052750, 3.184105>, <0.165642, -4.052750, 3.184105>, 
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>, 
      <-0.331285, 1.269360, 3.537894>, <-0.165642, 1.269360, 3.537894>, <0.000000, 1.269360, 3.537894>, <0.165642, 1.269360, 3.537894>, 
      <-0.331285, 1.461279, 0.000000>, <-0.165642, 1.461279, 0.000000>, <0.000000, 1.461279, 0.000000>, <0.165642, 1.461279, 0.000000>, 
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>, 
      <-0.331285, 3.820426, -0.088447>, <-0.165642, 3.820426, -0.088447>, <0.000000, 3.820426, -0.088447>, <0.165642, 3.820426, -0.088447>, 
      <-0.331285, 5.000000, 0.088447>, <-0.165642, 5.000000, 0.088447>, <0.000000, 5.000000, 0.088447>, <0.165642, 5.000000, 0.088447>, 
      <-0.331285, 5.012346, 1.857395>, <-0.165642, 5.012346, 1.857395>, <0.000000, 5.012346, 1.857395>, <0.165642, 5.012346, 1.857395>
    }
  }
  rotate <91.002113, 0.0, 135.0>
  translate  <36.189083, -44.134074, 10.817071>
}
#declare BezPtch093 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -8.065095, 2.741868>, <-0.165642, -8.065095, 2.741868>, <0.000000, -8.065095, 2.741868>, <0.165642, -8.065095, 2.741868>, 
      <-0.333985, -7.937644, 0.088447>, <-0.168343, -7.937644, 0.088447>, <-0.002700, -7.937644, 0.088447>, <0.162942, -7.937644, 0.088447>, 
      <-0.331285, -6.154882, 0.353789>, <-0.165642, -6.154882, 0.353789>, <0.000000, -6.154882, 0.353789>, <0.165642, -6.154882, 0.353789>, 
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>, 
      <-0.331285, -3.705948, 0.353789>, <-0.165642, -3.705948, 0.353789>, <0.000000, -3.705948, 0.353789>, <0.165642, -3.705948, 0.353789>, 
      <-0.331285, -4.052750, 3.184105>, <-0.165642, -4.052750, 3.184105>, <0.000000, -4.052750, 3.184105>, <0.165642, -4.052750, 3.184105>, 
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>, 
      <-0.331285, 1.269360, 3.537894>, <-0.165642, 1.269360, 3.537894>, <0.000000, 1.269360, 3.537894>, <0.165642, 1.269360, 3.537894>, 
      <-0.331285, 1.461279, 0.000000>, <-0.165642, 1.461279, 0.000000>, <0.000000, 1.461279, 0.000000>, <0.165642, 1.461279, 0.000000>, 
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>, 
      <-0.331285, 3.820426, -0.088447>, <-0.165642, 3.820426, -0.088447>, <0.000000, 3.820426, -0.088447>, <0.165642, 3.820426, -0.088447>, 
      <-0.331285, 5.000000, 0.088447>, <-0.165642, 5.000000, 0.088447>, <0.000000, 5.000000, 0.088447>, <0.165642, 5.000000, 0.088447>, 
      <-0.331285, 5.012346, 1.857395>, <-0.165642, 5.012346, 1.857395>, <0.000000, 5.012346, 1.857395>, <0.165642, 5.012346, 1.857395>
    }
  }
  rotate <91.002113, 0.0, -135.0>
  translate  <34.016217, -44.481733, 10.817071>
}
#declare BezPtch094 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -8.065095, 2.741868>, <-0.165642, -8.065095, 2.741868>, <0.000000, -8.065095, 2.741868>, <0.165642, -8.065095, 2.741868>, 
      <-0.333985, -7.937644, 0.088447>, <-0.168343, -7.937644, 0.088447>, <-0.002700, -7.937644, 0.088447>, <0.162942, -7.937644, 0.088447>, 
      <-0.331285, -6.154882, 0.353789>, <-0.165642, -6.154882, 0.353789>, <0.000000, -6.154882, 0.353789>, <0.165642, -6.154882, 0.353789>, 
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>, 
      <-0.331285, -3.705948, 0.353789>, <-0.165642, -3.705948, 0.353789>, <0.000000, -3.705948, 0.353789>, <0.165642, -3.705948, 0.353789>, 
      <-0.331285, -4.052750, 3.184105>, <-0.165642, -4.052750, 3.184105>, <0.000000, -4.052750, 3.184105>, <0.165642, -4.052750, 3.184105>, 
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>, 
      <-0.331285, 1.269360, 3.537894>, <-0.165642, 1.269360, 3.537894>, <0.000000, 1.269360, 3.537894>, <0.165642, 1.269360, 3.537894>, 
      <-0.331285, 1.461279, 0.000000>, <-0.165642, 1.461279, 0.000000>, <0.000000, 1.461279, 0.000000>, <0.165642, 1.461279, 0.000000>, 
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>, 
      <-0.331285, 3.820426, -0.088447>, <-0.165642, 3.820426, -0.088447>, <0.000000, 3.820426, -0.088447>, <0.165642, 3.820426, -0.088447>, 
      <-0.331285, 5.000000, 0.088447>, <-0.165642, 5.000000, 0.088447>, <0.000000, 5.000000, 0.088447>, <0.165642, 5.000000, 0.088447>, 
      <-0.331285, 5.012346, 1.857395>, <-0.165642, 5.012346, 1.857395>, <0.000000, 5.012346, 1.857395>, <0.165642, 5.012346, 1.857395>
    }
  }
  rotate <91.002113, 0.0, -90.0>
  translate  <33.407814, -45.17705, 10.817071>
}
#declare BezPtch095 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -8.065095, 2.741868>, <-0.165642, -8.065095, 2.741868>, <0.000000, -8.065095, 2.741868>, <0.165642, -8.065095, 2.741868>, 
      <-0.333985, -7.937644, 0.088447>, <-0.168343, -7.937644, 0.088447>, <-0.002700, -7.937644, 0.088447>, <0.162942, -7.937644, 0.088447>, 
      <-0.331285, -6.154882, 0.353789>, <-0.165642, -6.154882, 0.353789>, <0.000000, -6.154882, 0.353789>, <0.165642, -6.154882, 0.353789>, 
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>, 
      <-0.331285, -3.705948, 0.353789>, <-0.165642, -3.705948, 0.353789>, <0.000000, -3.705948, 0.353789>, <0.165642, -3.705948, 0.353789>, 
      <-0.331285, -4.052750, 3.184105>, <-0.165642, -4.052750, 3.184105>, <0.000000, -4.052750, 3.184105>, <0.165642, -4.052750, 3.184105>, 
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>, 
      <-0.331285, 1.269360, 3.537894>, <-0.165642, 1.269360, 3.537894>, <0.000000, 1.269360, 3.537894>, <0.165642, 1.269360, 3.537894>, 
      <-0.331285, 1.461279, 0.000000>, <-0.165642, 1.461279, 0.000000>, <0.000000, 1.461279, 0.000000>, <0.165642, 1.461279, 0.000000>, 
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>, 
      <-0.331285, 3.820426, -0.088447>, <-0.165642, 3.820426, -0.088447>, <0.000000, 3.820426, -0.088447>, <0.165642, 3.820426, -0.088447>, 
      <-0.331285, 5.000000, 0.088447>, <-0.165642, 5.000000, 0.088447>, <0.000000, 5.000000, 0.088447>, <0.165642, 5.000000, 0.088447>, 
      <-0.331285, 5.012346, 1.857395>, <-0.165642, 5.012346, 1.857395>, <0.000000, 5.012346, 1.857395>, <0.165642, 5.012346, 1.857395>
    }
  }
  rotate <91.002113, 0.0, -45.0>
  translate  <34.016217, -46.046196, 10.817071>
}
#declare BezPtch096 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -8.065095, 2.741868>, <-0.165642, -8.065095, 2.741868>, <0.000000, -8.065095, 2.741868>, <0.165642, -8.065095, 2.741868>, 
      <-0.333985, -7.937644, 0.088447>, <-0.168343, -7.937644, 0.088447>, <-0.002700, -7.937644, 0.088447>, <0.162942, -7.937644, 0.088447>, 
      <-0.331285, -6.154882, 0.353789>, <-0.165642, -6.154882, 0.353789>, <0.000000, -6.154882, 0.353789>, <0.165642, -6.154882, 0.353789>, 
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -4.930415, 0.353789>, <-0.165642, -4.930415, 0.353789>, <0.000000, -4.930415, 0.353789>, <0.165642, -4.930415, 0.353789>, 
      <-0.331285, -3.705948, 0.353789>, <-0.165642, -3.705948, 0.353789>, <0.000000, -3.705948, 0.353789>, <0.165642, -3.705948, 0.353789>, 
      <-0.331285, -4.052750, 3.184105>, <-0.165642, -4.052750, 3.184105>, <0.000000, -4.052750, 3.184105>, <0.165642, -4.052750, 3.184105>, 
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, -1.391695, 3.361000>, <-0.165642, -1.391695, 3.361000>, <0.000000, -1.391695, 3.361000>, <0.165642, -1.391695, 3.361000>, 
      <-0.331285, 1.269360, 3.537894>, <-0.165642, 1.269360, 3.537894>, <0.000000, 1.269360, 3.537894>, <0.165642, 1.269360, 3.537894>, 
      <-0.331285, 1.461279, 0.000000>, <-0.165642, 1.461279, 0.000000>, <0.000000, 1.461279, 0.000000>, <0.165642, 1.461279, 0.000000>, 
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.331285, 2.640853, -0.044224>, <-0.165642, 2.640853, -0.044224>, <0.000000, 2.640853, -0.044224>, <0.165642, 2.640853, -0.044224>, 
      <-0.331285, 3.820426, -0.088447>, <-0.165642, 3.820426, -0.088447>, <0.000000, 3.820426, -0.088447>, <0.165642, 3.820426, -0.088447>, 
      <-0.331285, 5.000000, 0.088447>, <-0.165642, 5.000000, 0.088447>, <0.000000, 5.000000, 0.088447>, <0.165642, 5.000000, 0.088447>, 
      <-0.331285, 5.012346, 1.857395>, <-0.165642, 5.012346, 1.857395>, <0.000000, 5.012346, 1.857395>, <0.165642, 5.012346, 1.857395>
    }
  }
  rotate <91.002113, 0.0, 0.0>
  translate  <35.233022, -46.567684, 10.817071>
}
#declare lamp11 = union {
  sphere { // Sphere016
    <0,0,0>,1
    material {
      Glass
    }
    hollow
    scale <5.0, 5.0, 3.261394>
    translate  <35.095907, -45.140268, 9.51724>
  }
  object { BezPtch089 }
  object { BezPtch090 }
  object { BezPtch091 }
  object { BezPtch092 }
  object { BezPtch093 }
  object { BezPtch094 }
  object { BezPtch095 }
  object { BezPtch096 }
  cone { // Cone023
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale 1.716519
    rotate <180.0, 0.0, 180.0>
    translate  <35.128593, -45.169069, 16.365649>
  }
  torus { // Torus057
    1.75, 0.25  rotate -x*90
    scale 1.091333
    rotate 0.0*x
    translate  <35.06776, -45.169069, 13.234877>
  }
  cylinder { // Cylndr182
    <0,0,1>, <0,0,0>, 1 
    scale 2.064656
    rotate 0.0*x
    translate  <35.268193, -45.169069, 4.005444>
  }
  torus { // Torus058
    1.75, 0.25  rotate -x*90
    scale 1.091333
    rotate 0.0*x
    translate  <35.128593, -45.169069, 14.2082>
  }
  cylinder { // Cylndr183
    <0,0,1>, <0,0,0>, 1 
    scale <0.333333, 0.333333, 20.0>
    rotate <180.0, -0.0, -180.0>
    translate  <35.009483, -44.966081, 35.268835>
  }
  cone { // Cone024
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale 2.465107
    rotate 0.0*y
    translate  <35.009391, -44.976931, 28.187788>
  }
  sphere { // Sphere028
    <0,0,0>,1
    material {
      lampwhite
    }
    no_shadow
    scale 0.734142
    rotate <-0.0, 0.0, -30.0>
    translate  <35.041314, -45.284038, 9.456169>
  }
  material {
    ironblack
  }
  scale 0.15
  rotate -330.0*z
  translate  <-2.696693, -16.080818, 16.133418>
}
union { // Temple
  object { lamp }
  text {   // TText001
    ttf      "C:\WINDOWS\Fonts\Tt0148m_.ttf",
    "WWW",
    0.27,  // Depth
    <0.0,     0.0, 0.0> // Offset
    material {
      ColumnTexture
    }
    scale <2.5, 1.999188, 1.284758>
    rotate <90.0, -0.0, -15.0>
    translate  <-4.407032, -1.471016, 2.312471>
  }

  object { altar }
  object { Dome }
  object { TempleWalls }
  object { lamp1 }
  object { lamp2 }
  object { lamp3 }
  object { lamp4 }
  object { lamp5 }
  object { lamp6 }
  object { lamp7 }
  object { lamp8 }
  object { lamp9 }
  object { lamp10 }
  object { lamp11 }
}


union { // Globe
  torus { // Torus025
    1.95, 0.05  rotate -x*90
    rotate -90.0*y
  }
  torus { // Torus026
    1.95, 0.05  rotate -x*90
    rotate <36.0, -90.0, 0.0>
  }
  torus { // Torus027
    1.95, 0.05  rotate -x*90
    rotate <72.0, -90.0, 0.0>
  }
  torus { // Torus028
    1.95, 0.05  rotate -x*90
    rotate <108.0, -90.0, 0.0>
  }
  torus { // Torus029
    1.95, 0.05  rotate -x*90
    rotate <144.0, -90.0, 0.0>
  }
  torus { // Torus030
    1.95, 0.05  rotate -x*90
    rotate <-0.0, 0.0, 180.0>
  }
  torus { // Torus031
    1.95, 0.05  rotate -x*90
    scale <0.55, 0.55, 1.118577>
    rotate <-0.0, 0.0, 180.0>
    translate  -1.630434*z
  }
  torus { // Torus032
    1.95, 0.05  rotate -x*90
    scale <0.55, 0.55, 1.118577>
    rotate <-0.0, 0.0, 180.0>
    translate  1.660078*z
  }
  torus { // Torus033
    1.95, 0.05  rotate -x*90
    scale <0.9, 0.9, 1.118577>
    rotate <-0.0, 0.0, 180.0>
    translate  0.859683*z
  }
  torus { // Torus034
    1.95, 0.05  rotate -x*90
    scale <0.9, 0.9, 1.118577>
    rotate <-0.0, 0.0, 180.0>
    translate  -0.918972*z
  }
  sphere { // Sphere001
    <0,0,0>,1
    material {
      USMap
    }
    hollow
    scale 2.025
  }
  sphere { // Sphere030
    <0,0,0>,1
    material {
      haze
    }
    no_shadow
    hollow
    scale 3.285828
    rotate <-25.357487, 5.944525, 12.32688>
  }
  sphere { // Sphere031
    <0,0,0>,1
    material {
      Glass_Colored_Blue
    }
    hollow
    scale 1.9
    rotate <-25.357487, 5.944525, 12.32688>
  }
  sphere { // Sphere032
    <0,0,0>,1
    material {
      Electricity
    }
    no_shadow
    hollow
    scale 2.111081
    rotate <-25.357487, 5.944525, 12.32688>
  }
  material {
    Gold_Metal1
  }
  scale 2.321085
  rotate <26.0, 0.0, -13.665359>
  translate  8.98945*z
}


