#ifndef( TV_inc )
#declare TV_inc = true;
// Persistence of Vision Ray Tracer Scene Description File
// File: TV.inc
// Vers: 3.1
// Desc: 
// Date: 2000.12.10
// Auth: Masanori Imazu

// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
//#include "textures.inc"	// Standard Texture definitions

#local T_TVCasing =
	texture{
		pigment{ Black }
		finish{ phong 0.7 }
	}

#local T_TVScreen =
	texture{
		pigment{ rgb < 0.1, 0.3, 0.2 > }
		finish { reflection 0.1 }
	}

#declare TV =
	union{
		intersection {
			difference{
				box{ 0, 1 translate -0.5*x
					scale < 600, 530, 450+10 >
					translate 10*z
				}
				box{ 0, 1 translate -0.5*x
					scale < 600-80, 530-40-100, 100 >
					translate < 0, 100, -11 >
				}
			}
			#local Radius = 3000;
			sphere{ Radius*z, Radius }

			texture{ T_TVCasing }
		}
		intersection{
			box{ 0,1 translate -0.5*x
				scale < 600-80+2, 530-40-100+2, 100 >
				translate < 0, 100-1, -15 >
			}
			#local Radius = 3000-10;
			sphere{ Radius*z, Radius }

			texture{ T_TVScreen }
		}
	}

#end
