
#if (the_cheese_skelet > 0)
#declare lc1=1;
#declare lc2=2;
#else
#declare lc1=100;
#declare lc2=200;
#end

/*
camera {
  location <0, 3.5, -4.5>
  look_at <0.13, 0.15, 0>
  scale 0.85
}

background { color rgb <1,1,1>}

light_source { <3, 20, -10> colour Gray60 shadowless}
light_source { <-3, -1, -5> colour Gray80 shadowless}
light_source { <0, 10, 0> colour Gray50 shadowless }
//light_source { <-20, 40, -20> colour Gray70 }
//light_source { <100, 80, -200> colour Gray70 }
*/

#declare layoutPosition=<0,0,0>;

#declare gauss = array[9] {0.0,0.1,0.5,0.9,1.0,0.9,0.5,0.1,0.0} // Gauss-like
#declare statL=array[2] {1,0}
#declare statR=array[2] {0,1}
#declare rs1=seed(1);

#declare holeDepthSeed = seed(0);

#macro hole(sz)
//#alternative (rand(random1))
//#case (0.5)
// union {
blob {
    threshold 0.25
    #declare i=0;
    #while (i<3)
    sphere {
        <makevalue(gauss,0,sz,rs1),makevalue(gauss,0,sz,rs1),makevalue(gauss,0,sz,rs1)>
        makevalue(statR, sz, sz/3, rs1) 1
    }
    #declare i=i+1;
    #end
    scale <1,1,makevalue(gauss,1,0.5,rs1)>
    rotate x*rand(rs1)*180
    rotate z*rand(rs1)*180
}
#end

#macro blobHole(sz)
blob {
    threshold 0.25
    #declare i=0;
    #while (i<10)
    sphere {
        <makevalue(gauss,0,sz,rs1),makevalue(gauss,0,sz,rs1),makevalue(gauss,0,sz,rs1)>
        makevalue(statR, sz, sz/3, rs1) 1
    }
    #declare i=i+1;
    #end
    scale <1,1,makevalue(gauss,1,0.5,rs1)>
    rotate x*rand(rs1)*180
    rotate z*rand(rs1)*180
}
#end

#macro holeMoved(sz)
    object {
        blobHole(sz)
        translate -layoutUp*rand(rs1)*sz*(rand(holeDepthSeed)-0.3)
    }
#end

#declare random1 = seed(0);          


#declare AreaToFill=
//difference {
intersection {

superellipsoid {
    <1,0.3>
    rotate x*-90
    //translate -1
    scale <3,1,3>
}

#declare sedata=0.05; 
superellipsoid {
    <sedata,sedata>
    scale <3,1,3>
    translate z*3
}

superellipsoid {
    <sedata,sedata>
    scale <3,1,3>
    translate z*3
    rotate y*127
}
}


// #declare AreaToFill=sphere { <1,0,0>, 1}


#declare layoutUp=<0,0,0>;

#declare theLayout = layout {
    object {AreaToFill /*scale <1,0.68,1>*/}
    layout_surface
    layout_random_stream seed(98)//seed(34)
    layout_count lc1
    layout_size 0.16
    layout_distance 0.4
    "holeMoved"
    //inverse     
}

#declare theLayout2 = layout {
    difference { object {AreaToFill} object {theLayout} }
    layout_surface2
    layout_random_stream seed(3)
    layout_count lc2
    layout_size 0.05
    layout_distance 0.1
    "hole"
}


#macro testLayout(sz)
layout {
    sphere { 0,0.001}
    layout_size sz
    layout_random_stream seed(0)
    layout_count 1
    "blobHole"
}
#end 

#declare theCheese = difference {
    object { AreaToFill }

    // union {object { blobHole(0.8) translate <0.9,0.6,-1.3> } }
    // object {testLayout(0.8) translate <0.9,0.6,-1.3> }

    object { theLayout }
    object { theLayout2 }
    texture {
        pigment {
            color rgb <1.0,0.96,0.65>
        }
        finish {
            diffuse 0.9
            phong 0.1
        }
        normal {
            bumps scale 0.1 bump_size 0.2
        }
    }
    rotate y*15
    translate <-1.5,0,0>
    // scale 1.6
}

