#render "building crab\n"
#ifndef(main_render)

global_settings {
  assumed_gamma 1.6
  max_intersections 350
  max_trace_level 350
}
//#declare quick_crab=1;
#declare cam_pos=<0,3,-6>;
#declare cam_tgt=<0,2,0>;

#declare light_pos=<-1000,1500,-1500>;
#declare pen_light=.2;
#declare amb_light=.15;

camera {
  location cam_pos
  up <0,1,0>
  right <4/3,0,0>
  direction <0,0,1.45>
  look_at cam_tgt
}

light_source {
  light_pos
  1-pen_light
}
light_source {
  light_pos
  pen_light
  shadowless
}

#macro flight_spline(_p1,_p2,_p3,_p4,_sc,_ec,_cc)
  #if (_cc<=_sc)
    (_p1)
  #else
    #if (_cc>=_ec)
      (_p4)
    #else
      #local _ci=(_cc-_sc)/(_ec-_sc);
      #local _co=(1-_ci);
      //  p = (p1*co^3)+(3*p2*co^2*ci)+(3*p3*ci^2*co)+(p4*ci^3) 
         ( ( _p1*pow(_co,3) ) + ( _p2*3*pow(_co,2)*_ci ) + ( _p3*3*pow(_ci,2)*_co ) + ( _p4*pow(_ci,3) ) )
    #end
  #end
#end  

#macro rebt(_threshold)
   #declare reb_thresh=_threshold;
   threshold _threshold
#end
//  
#macro reb(_visibleradius,_blobbiness)
   #local _strength = reb_thresh*(1+1/_blobbiness);
   #local _actualradius =_visibleradius/sqrt(1-sqrt(reb_thresh/_strength));
   _actualradius, _strength
#end

#end
                       
#macro flight_array(_pos,_sc,_ec,_cc) // as-per flight spline, but positions passed as a four element array
  #if (_cc<=_sc)
    (_pos[0])
  #else
    #if (_cc>=_ec)
      (_pos[3])
    #else
      #local _ci=(_cc-_sc)/(_ec-_sc);
      #local _co=(1-_ci);
      //  p = (p1*co^3)+(3*p2*co^2*ci)+(3*p3*ci^2*co)+(p4*ci^3) 
         ( ( _pos[0]*pow(_co,3) ) + ( _pos[1]*3*pow(_co,2)*_ci ) + ( _pos[2]*3*pow(_ci,2)*_co ) + ( _pos[3]*pow(_ci,3) ) )
    #end
  #end
#end  

#macro blob_thing(_pos,_col,_sca,_rad,_bb,_neg,_st)
  #local _cs = reb_thresh*(1+1/_bb);
  #local _inc=1/_st;
  #local _step=0;
  #while ( _step < 1+(_inc/2))
    #local _tp=(flight_array(_pos,0,1,_step));
    #local _tc=(flight_array(_col,0,1,_step));
    #local _ts=(flight_array(_sca,0,1,_step));
    #local _tr=(flight_array(_rad,0,1,_step));

    #local _cr =_tr/sqrt(1-sqrt(reb_thresh/_cs));
    sphere { 0,_cr,_cs*_neg scale _ts translate _tp texture { pigment { color _tc } finish { crab_fin } } }
    #declare crab_blobs=crab_blobs+1;

    #local _step=_step+_inc;
  #end
  
#end

#declare crab_fin=
  finish { 
    ambient amb_light
    diffuse .8
    roughness .1
    specular .4
  }
#declare lig_tex=texture { pigment { color rgb<.9,.8,.8> } finish { crab_fin } }

#declare crab_blobs=0;

#declare std_limb=
  blob {
    rebt(.6)
    #local _pos=array[4] { <-1.9,0,0>,<-.6,-.3,0>,<.6,.3,0>,<1.9,.1,0> }
    #local _col=array[4] { <.6,.1,.05>,<.6,.1,.05>,<.6,.1,.05>,<.6,.1,.05> }
    #local _sca=array[4] { <1,1,1>,<1,1,1>,<1,1,1>,<1,1,1> }
    #local _rad=array[4] { .2,.4,.4,.2 }
    #local _bb=1;
    #local _neg=.5;
    #local _st=80;    
    blob_thing(_pos,_col,_sca,_rad,_bb,_neg,_st)
    
    #local _pos=array[4] { <-2.05,.1,0>,<-.6,.15,0>,<.6,.75,0>,<2.05,.15,0> }
    #local _col=array[4] { <1,.6,0>,<0,0,0>,<-.2,-.1,0>,<1,.6,0> }
    #local _sca=array[4] { <1,1,2>,<1,1,1>,<1,1,1>,<1,1,2> }
    #local _rad=array[4] { .1,.1,.1,.1 }
    #local _bb=3;
    #local _neg=.5;
    #local _st=80;
    blob_thing(_pos,_col,_sca,_rad,_bb,_neg,_st)
    
    #local _pos=array[4] { <-1.9,0,0>,<-.6,-.6,0>,<.6,-.2,0>,<1.9,.1,0> }
    #local _col=array[4] { <1,1,1>,<1,1,1>,<1,1,1>,<1,1,1> }
    #local _sca=array[4] { <1,1,1>,<1,1,2>,<1,1,2>,<1,1,1> }
    #local _rad=array[4] { .1,.2,.2,.1 }
    #local _bb=2;
    #local _neg=.5;
    #local _st=80;
    blob_thing(_pos,_col,_sca,_rad,_bb,_neg,_st)
    
    #local _pos=array[4] { <-1.9,-.75,0>,<-.6,-.95,0>,<.6,-.75,0>,<1.9,-.85,0> }
    #local _col=array[4] { <1,1,1>,<1,1,1>,<1,1,1>,<1,1,1> }
    #local _sca=array[4] { <1,1,3>,<1,1,1>,<1,1,1>,<1,1,3> }
    #local _rad=array[4] { .2,.01,.01,.2 }
    #local _bb=2;
    #local _neg=-1;
    #local _st=80;
    blob_thing(_pos,_col,_sca,_rad,_bb,_neg,_st)
    translate <2,0,0>
    texture {
      pigment { color rgb<0,0,0> }
      finish { crab_fin }
    }
  }
#declare upper_limb=object { std_limb scale <1,1.2,1.2> scale 3/4 }
#declare middle_limb=object { std_limb translate <-4,0,0> scale <-.5,.75,.75> }
#declare lower_limb=object { std_limb translate <-4,0,0> scale <-.5,.75,.75>*.5 }

#macro limb_const(_a1,_a2,_a3)
  union {
    object { upper_limb rotate <0,0,_a1> }
    object { middle_limb rotate <0,0,_a2> translate vrotate(<3,0,0>,<0,0,_a1>) }
    object { lower_limb rotate <0,0,_a3> translate vrotate(<3,0,0>,<0,0,_a1>)+vrotate(<2,0,0>,<0,0,_a2>) }
    sphere { 0,.25 texture { lig_tex } }
    sphere { 0,.22 texture { lig_tex } translate vrotate(<3,0,0>,<0,0,_a1>) }
    sphere { 0,.19 texture { lig_tex } translate vrotate(<3,0,0>,<0,0,_a1>)+vrotate(<2,0,0>,<0,0,_a2>) } 
  }
#end
#declare s_j_seed=seed(1);
#macro s_jitt(j_qty)
  #local j_rad=j_qty*rand(s_j_seed);
  #local j_ang=<360*rand(s_j_seed),360*rand(s_j_seed),360*rand(s_j_seed)>;
  ( vrotate(<0,1,0>,j_ang)*j_rad )
#end
//      #macro blob_thing(_pos,_col,_sca,_rad,_bb,_neg,_st)
#macro blob_thing_patch(_pos1,_pos2,_pos3,_pos4,_col1,_col2,_col3,_col4,_rad,_bb,_neg,_st1,_st2)
  #local _cs = reb_thresh*(1+1/_bb);
  #local _incx=1/_st1;
  #local _incz=1/_st2;
  #local _stepx=0+(_misxs*_incx);
  #while ( _stepx < 1+(_incx/2)-(_misxe*_incx))
  
    #local _posC=array[4] {     (flight_spline(_pos1[0],_pos2[0],_pos3[0],_pos4[0],0,1,_stepx)) ,
                                (flight_spline(_pos1[1],_pos2[1],_pos3[1],_pos4[1],0,1,_stepx)) ,
                                (flight_spline(_pos1[2],_pos2[2],_pos3[2],_pos4[2],0,1,_stepx)) ,
                                (flight_spline(_pos1[3],_pos2[3],_pos3[3],_pos4[3],0,1,_stepx)) }
                                
    #local _colC=array[4] {     (flight_spline(_col1[0],_col2[0],_col3[0],_col4[0],0,1,_stepx)) ,
                                (flight_spline(_col1[1],_col2[1],_col3[1],_col4[1],0,1,_stepx)) ,
                                (flight_spline(_col1[2],_col2[2],_col3[2],_col4[2],0,1,_stepx)) ,
                                (flight_spline(_col1[3],_col2[3],_col3[3],_col4[3],0,1,_stepx)) }       
    #local _stepz=0+(_miszs*_incz);
    #while (_stepz<1+(_incz/2)-(_misze*_incz))
    
      #local _tp=(flight_array(_posC,0,1,_stepz))+s_jitt(shell_jt);
      #local _tc=(flight_array(_colC,0,1,_stepz));
      
      #local _cr =_rad/sqrt(1-sqrt(reb_thresh/_cs));
      sphere { 0,_cr,_cs*_neg translate _tp texture { pigment { color _tc } finish { crab_fin } } }
      #declare crab_blobs=crab_blobs+1;
      
      #local _stepz=_stepz+_incz;
      #ifdef (quick_crab)
        #local _stepz=_stepz+_incz*4;
      #end
    #end
    
    #local _stepx=_stepx+_incx;
    #ifdef (quick_crab)
      #local _stepx=_stepx+_incx*4;
    #end
  #end
  
#end
      
#declare crab_body=
  blob {
    rebt(.6)
// leg pivot area's
    #local _col=array[4] { <1,1,1>,<1,1,1>,<1,1,1>,<1,1,1> }
    #local _sca=array[4] { <2,1.2,2>,<2,1.2,2>,<2,1.2,2>,<2,1.2,2> }
    #local _rad=array[4] { .25,.25,.25,.25 }
    #local _bb=1;
    #local _neg=1;
    #local _st=4;    
    #local _pos=array[4] { <-1.8,0,-1.8>,<-1.7,-.2,-.8>,<-1.55,-.2,.7>,<-1.3,0,1.7> }
    blob_thing(_pos,_col,_sca,_rad,_bb,_neg,_st)
    #local _pos=array[4] { <1.8,0,-1.8>,<1.7,-.2,-.8>,<1.55,-.2,.7>,<1.3,0,1.7> }
    blob_thing(_pos,_col,_sca,_rad,_bb,_neg,_st)
// centre spine, bottom layer
    #local _pos=array[4] { <0,.1,-1.7>,<0,-.1,-1>,<0,-.1,1>,<0,.2,1.8> }
    #local _col=array[4] { <1,.6,.6>,<1,1,1>,<1,1,1>,<1,.1,.1> }
    #local _sca=array[4] { <2.2,.75,1.45>,<2,.75,1.35>,<1.8,.75,1.1>,<1.6,.75,1> }
    #local _rad=array[4] { .6,.6,.6,.6 }
    #local _bb=1;
    #local _neg=1;
    #local _st=8;
    blob_thing(_pos,_col,_sca,_rad,_bb,_neg,_st)
    
// middle layer    
    #local _col=array[4] { <.6,.1,.05>,<1,1,1>,<1,1,1>,<.6,.1,.05> }
    #local _sca=array[4] { <1.5,.75,1>,<1.6,.75,.9>,<1.5,.75,.8>,<1.4,.75,.7> }
    #local _rad=array[4] { .6,.6,.6,.6 }
    #local _bb=1;
    #local _neg=1;
    #local _st=16;
    #local _pos=array[4] { <-1.2,.5,-1.8>,<-1.2,.5,-.8>,<-1.05,.5,.7>,<-.8,.5,1.7> }
    blob_thing(_pos,_col,_sca,_rad,_bb,_neg,_st)
    #local _pos=array[4] { <1.2,.5,-1.8>,<1.2,.5,-.8>,<1.05,.5,.7>,<.8,.5,1.7> }
    blob_thing(_pos,_col,_sca,_rad,_bb,_neg,_st)
    #local _col=array[4] { <1,1,1>,<1,1,1>,<1,1,1>,<.6,.1,.05> }
    #local _pos=array[4] { <0,.65,-2>,<0,.75,-1.1>,<0,.75,.7>,<0,.5,1.7> }
    #local _sca=array[4] { <1.5,.85,1.5>,<1.6,.85,1.35>,<1.5,.85,1.1>,<1.4,.7,1> }
    blob_thing(_pos,_col,_sca,_rad,_bb,_neg,_st)
// top layer
    #local _col=array[4] { <.6,.1,.05>,<.6,.1,.05>,<.6,.1,.05>,<.6,.1,.05> }
    #local _sca=array[4] { <1.25,.75,1>,<1.5,.75,1>,<1.5,.75,1>,<1.24,.65,1> }    
    #local _pos=array[4] { <-1.3,1,-2>,<-1.3,1.25,-.8>,<-1.15,1.15,.7>,<-.9,.95,1.7> }
    blob_thing(_pos,_col,_sca,_rad,_bb,_neg,_st)
    #local _pos=array[4] { <1.3,.95,-2>,<1.3,1.25,-.8>,<1.15,1.15,.7>,<.9,.95,1.7> }
    blob_thing(_pos,_col,_sca,_rad,_bb,_neg,_st)
    #local _pos=array[4] { <0,1.2,-2.05>,<0,1.75,-1.1>,<0,1.25,.7>,<0,1.05,1.7> }
    #local _sca=array[4] { <1.5,.85,1.65>,<1.6,.85,1.35>,<1.5,.85,1.1>,<1.4,.7,1> }
    blob_thing(_pos,_col,_sca,_rad,_bb,_neg,_st)

// jaws
    #local _col=array[4] { <.6,.1,.05>,<.6,.1,.05>,<.6,.1,.05>,<.6,.1,.05> }
    #local _sca=array[4] { <.5,1,.4>,<.5,1,.4>,<.75,1,.4>,<1.25,1,.4> }
    #local _rad=array[4] { .2,.2,.2,.2 }
    #local _bb=1;
    #local _neg=.5;
    #local _st=10;    
    #local _pos=array[4] { <.2,.75,-3.3>,<.2,.6,-3.2>,<.3,.3,-3.1>,<.4,.1,-3.0> }
    blob_thing(_pos,_col,_sca,_rad,_bb,_neg,_st)
    #local _pos=array[4] { <-.2,.75,-3.3>,<-.2,.6,-3.2>,<-.3,.3,-3.1>,<-.4,.1,-3.0> }
    blob_thing(_pos,_col,_sca,_rad,_bb,_neg,_st)
    
// shell top
    #declare shell_jt=.01;
// front left quarter    
    #local _pos1=array[4] { <0.0,2.1,0>,<0.6,2.1,0>,<1.2,2,0>,<2.4,1.4,0> }
    #local _pos2=array[4] { <0.0,2.2,-1.2>,<0.6,2.2,-1.2>,<1.2,2,-1.2>,<2.6,1.4,-1.2> }
    #local _pos3=array[4] { <0.0,2.4,-2.4>,<0.6,2.4,-2.4>,<2.0,2,-2>,<3,1.8,-1.6> }
    #local _pos4=array[4] { <0.0,1.6,-3.2>,<0.6,1.8,-3.3>,<2.0,1,-2.6>,<2.5,1.4,-2.0> }
      
    #local _col1=array[4] { <.8,.5,.3>,<.8,.5,.1>,<.8,.2,.1>,<.3,.1,0> }
    #local _col2=array[4] { <.8,.5,.1>,<.8,.5,.1>,<.8,.2,.1>,<.3,.1,0> }
    #local _col3=array[4] { <.8,.2,.1>,<.8,.2,.1>,<.8,.2,.1>,<.3,.1,0> }
    #local _col4=array[4] { <.3,.1,0>,<.3,.1,0>,<.3,.1,0>,<.3,.1,0> }

    #declare _misxs=0;      
    #declare _misxe=0;
    #declare _miszs=0;
    #declare _misze=0;
      
    blob_thing_patch(_pos1,_pos2,_pos3,_pos4,_col1,_col2,_col3,_col4,.05,10,1.5,30,30)
    
// front right quarter    
    #local _pos1=array[4] { <0.0,2.1,0>,<-0.6,2.1,0>,<-1.2,2,0>,<-2.4,1.4,0> }
    #local _pos2=array[4] { <0.0,2.2,-1.2>,<-0.6,2.2,-1.2>,<-1.2,2,-1.2>,<-2.6,1.4,-1.2> }
    #local _pos3=array[4] { <0.0,2.4,-2.4>,<-0.6,2.4,-2.4>,<-2.0,2,-2>,<-3,1.8,-1.6> }
    #local _pos4=array[4] { <0.0,1.6,-3.2>,<-0.6,1.8,-3.3>,<-2.0,1,-2.6>,<-2.5,1.4,-2.0> }
      
    #local _col1=array[4] { <.8,.5,.3>,<.8,.5,.1>,<.8,.2,.1>,<.3,.1,0> }
    #local _col2=array[4] { <.8,.5,.1>,<.8,.5,.1>,<.8,.2,.1>,<.3,.1,0> }
    #local _col3=array[4] { <.8,.2,.1>,<.8,.2,.1>,<.8,.2,.1>,<.3,.1,0> }
    #local _col4=array[4] { <.3,.1,0>,<.3,.1,0>,<.3,.1,0>,<.3,.1,0> }

    #declare _misxs=0;      
    #declare _misxe=0;
    #declare _miszs=1;
    #declare _misze=0;
      
    blob_thing_patch(_pos1,_pos2,_pos3,_pos4,_col1,_col2,_col3,_col4,.05,10,1.5,30,30)
// rear left quarter
    #local _pos1=array[4] { <0.0,1,2.6>,<0.6,1,2.6>,<1.6,1.4,2.3>,<1.8,1.4,1.9> }
    #local _pos2=array[4] { <0.0,1.6,2.2>,<0.6,1.6,2.2>,<1.2,1.6,1.5>,<2.0,1.4,1.5> }
    #local _pos3=array[4] { <0.0,2.0,1.2>,<0.6,2.0,1.2>,<1.2,2,1.2>,<2.2,1.4,1.2> }
    #local _pos4=array[4] { <0.0,2.1,-0>,<0.6,2.1,-0>,<1.2,2,-0>,<2.4,1.4,0> }
      
    #local _col1=array[4] { <.3,.1,0>,<.3,.1,0>,<.3,.1,0>,<.3,.1,0> }
    #local _col2=array[4] { <.8,.2,.1>,<.8,.2,.1>,<.8,.2,.1>,<.3,.1,0> }
    #local _col3=array[4] { <.8,.5,.1>,<.8,.5,.1>,<.8,.2,.1>,<.3,.1,0> }
    #local _col4=array[4] { <.8,.5,.3>,<.8,.5,.1>,<.8,.2,.1>,<.3,.1,0> }

    #declare _misxs=0;      
    #declare _misxe=1;
    #declare _miszs=0;
    #declare _misze=0;
      
    blob_thing_patch(_pos1,_pos2,_pos3,_pos4,_col1,_col2,_col3,_col4,.05,10,1.5,30,30)
    
// rear right quarter
    #local _pos1=array[4] { <0.0,1,2.6>,<-0.6,1,2.6>,<-1.6,1.4,2.3>,<-1.8,1.4,1.9> }
    #local _pos2=array[4] { <0.0,1.6,2.2>,<-0.6,1.6,2.2>,<-1.2,1.6,1.5>,<-2.0,1.4,1.5> }
    #local _pos3=array[4] { <0.0,2.0,1.2>,<-0.6,2.0,1.2>,<-1.2,2,1.2>,<-2.2,1.4,1.2> }
    #local _pos4=array[4] { <0.0,2.1,-0>,<-0.6,2.1,-0>,<-1.2,2,-0>,<-2.4,1.4,0> }
      
    #local _col1=array[4] { <.3,.1,0>,<.3,.1,0>,<.3,.1,0>,<.3,.1,0> }
    #local _col2=array[4] { <.8,.2,.1>,<.8,.2,.1>,<.8,.2,.1>,<.3,.1,0> }
    #local _col3=array[4] { <.8,.5,.1>,<.8,.5,.1>,<.8,.2,.1>,<.3,.1,0> }
    #local _col4=array[4] { <.8,.5,.3>,<.8,.5,.1>,<.8,.2,.1>,<.3,.1,0> }

    #declare _misxs=0;      
    #declare _misxe=1;
    #declare _miszs=1;
    #declare _misze=0;
      
    blob_thing_patch(_pos1,_pos2,_pos3,_pos4,_col1,_col2,_col3,_col4,.05,10,1.5,30,30)
    
    
// eye_hole R/L
    #local _rep=<1.3,1.5,-2.85>;
    #local _red=<.25,.3,-.2>;
    #local _lep=_rep*<-1,1,1>;
    #local _led=_red*<-1,1,1>;
    cylinder { _rep,_rep+_red/2,reb(.175,1)*-10 }
    cylinder { _lep,_lep+_led/2,reb(.175,1)*-10 }
    cylinder { _rep-_red,_rep+_red,reb(.1,.5)*8 }
    cylinder { _lep-_led,_lep+_led,reb(.1,.5)*8 }
      
    texture {
      pigment { color rgb<0,0,0> }
      finish { crab_fin }
    }
  }
#declare _misxs=0;      
#declare _misxe=0;
#declare _miszs=0;
#declare _misze=0;
    
#declare upper_claw=
  blob {
    rebt(.6)
    #local _pos=array[4] { <-.8,0,0>,<-.2,0,0>,<.2,0,0>,<.8,0,0> }
    #local _col=array[4] { <.6,.1,.05>,<.6,.1,.05>,<.6,.1,.05>,<.6,.1,.05> }
    #local _sca=array[4] { <1,1,1>,<1,1,1>,<1,1,1>,<1,1,1> }
    #local _rad=array[4] { .2,.3,.3,.2 }
    #local _bb=1;
    #local _neg=.5;
    #local _st=40;    
    blob_thing(_pos,_col,_sca,_rad,_bb,_neg,_st)
    
    #local _pos=array[4] { <-1,0,-.2>,<-.3,.05,-.3>,<.3,.3,.05>,<1,.2,0> }
    #local _col=array[4] { <1,.6,0>,<0,0,0>,<-.2,-.1,0>,<1,.6,0> }
    #local _sca=array[4] { <1,1.6,1>,<1,1,1>,<1,1,1>,<1,1,1.6> }
    #local _rad=array[4] { .1,.1,.1,.1 }
    #local _bb=3;
    #local _neg=.5;
    #local _st=40;
    blob_thing(_pos,_col,_sca,_rad,_bb,_neg,_st)
    
    #local _pos=array[4] { <-.8,0,.2>,<-.5,-.1,.4>,<.5,-.4,.1>,<.8,-.2,0> }
    #local _col=array[4] { <1,1,1>,<1,1,1>,<1,1,1>,<1,1,1> }
    #local _sca=array[4] { <1,1,.5>,<1,2,1>,<1,1,2>,<1,.5,1> }
    #local _rad=array[4] { .05,.15,.15,.05 }
    #local _bb=2;
    #local _neg=.5;
    #local _st=40;
    blob_thing(_pos,_col,_sca,_rad,_bb,_neg,_st)
       
    translate <1,0,0>
    scale <.75,1,1>
    texture {
      pigment { color rgb<0,0,0> }
      finish { crab_fin }
    }
  }
#declare middle_claw=
  blob {
    rebt(.6)
    #local _pos=array[4] { <-.8,0,0>,<-.2,0,0>,<.2,0,0>,<.8,0,0> }
    #local _col=array[4] { <.6,.1,.05>,<.6,.1,.05>,<.6,.1,.05>,<.6,.1,.05> }
    #local _sca=array[4] { <1,1,1>,<1,1,1>,<1,1,1>,<1,1,1> }
    #local _rad=array[4] { .2,.3,.3,.2 }
    #local _bb=1;
    #local _neg=.5;
    #local _st=40;    
    blob_thing(_pos,_col,_sca,_rad,_bb,_neg,_st)
    
    #local _pos=array[4] { <-1.1,.15,0>,<-.3,.3,0>,<.3,.3,0>,<1,.15,0> }
    #local _col=array[4] { <1,.6,0>,<0,0,0>,<0,0,0>,<1,.6,0> }
    #local _sca=array[4] { <1,1,1.6>,<1,1,1>,<1,1,1>,<1,1,1.6> }
    #local _rad=array[4] { .1,.1,.1,.1 }
    #local _bb=3;
    #local _neg=.5;
    #local _st=40;
    blob_thing(_pos,_col,_sca,_rad,_bb,_neg,_st)
    
    #local _pos=array[4] { <-.8,-.2,0>,<-.5,-.3,0>,<.5,-.3,0>,<.8,-.2,0> }
    #local _col=array[4] { <1,1,1>,<1,1,1>,<1,1,1>,<1,1,1> }
    #local _sca=array[4] { <1,1,1>,<1,1,2>,<1,1,2>,<1,.5,1> }
    #local _rad=array[4] { .05,.15,.15,.05 }
    #local _bb=2;
    #local _neg=.5;
    #local _st=40;
    blob_thing(_pos,_col,_sca,_rad,_bb,_neg,_st)
       
    translate <1,0,0>
    scale <.25,1,1>
    texture {
      pigment { color rgb<0,0,0> }
      finish { crab_fin }
    }
  }
  
#declare claw_jaws=
union {
  blob {
    rebt(.6)
    #local _pos=array[4] { <-1.5,-.21,-.05>,<-.3,-.4,0>,<-.3,.4,0>,<-1.5,.21,-.05> }
    #local _col=array[4] { <.6,.1,.05>,<.6,.1,.05>,<.6,.1,.05>,<.6,.1,.05> }
    #local _sca=array[4] { <1,1,1>,<1,1,1>,<1,1,1>,<1,1,1> }
    #local _rad=array[4] { .21,.19,.19,.21 }
    #local _bb=1;
    #local _neg=.5;
    #local _st=40;
    
    blob_thing(_pos,_col,_sca,_rad,_bb,_neg,_st)
    #local _pos=array[4] { <-1.55,0,.16>,<0,0,.25>,<0,0,-.26>,<-1.7,0,-.25> }
    #local _col=array[4] { <1,.6,0>,<0,0,0>,<0,0,0>,<1,.6,0> }
    #local _sca=array[4] { <1,1.5,1>,<1,1,1>,<1,1,1>,<1,1.5,1> }
    #local _rad=array[4] { .1,.1,.1,.1 }
    #local _bb=3;
    #local _neg=.5;
    #local _st=40;
    blob_thing(_pos,_col,_sca,_rad,_bb,_neg,_st)
  }
  blob {
    rebt(.6)    
// lower claw jaw    
    #local _pos=array[4] { <-.7,.2,0>,<0,.5,0>,<.5,.5,0>,<1.1,.1,0> }
    #local _col=array[4] { <.5,.2,.1>,<.6,.3,.05>,<.5,.2,.05>,<.5,.2,.05> }
    #local _sca=array[4] { <1,1.3,1.1>,<1,1.3,1.6>,<1,1.3,1.3>,<1,1,1> }
    #local _rad=array[4] { .2,.15,.11,.1 }
    #local _bb=1;
    #local _neg=.5;
    #local _st=40;    
    blob_thing(_pos,_col,_sca,_rad,_bb,_neg,_st)
    
    #local _pos=array[4] { <-.5,.05,0>,<0,.2,0>,<.5,.3,0>,<1,.05,0> }
    #local _col=array[4] { <1,1,1>,<1,1,1>,<1,1,1>,<1,1,1> }
    #local _sca=array[4] { <1,1,1>,<1,1,1>,<1,1,1>,<1,1,1> }
    #local _rad=array[4] { .01,.083,.067,.05 }
    #local _bb=1;
    #local _neg=.5;
    #local _st=40;    
    blob_thing(_pos,_col,_sca,_rad,_bb,_neg,_st)
    
    #local _pos=array[4] { <-.5,.05,0>,<0,.2,0>,<.5,.3,0>,<1,.05,0> }
    #local _col=array[4] { <1,1,1>,<1,1,1>,<1,1,1>,<1,1,1> }
    #local _sca=array[4] { <1,1,1>,<1,1,1>,<1,1,1>,<1,1,1> }
    #local _rad=array[4] { .01,.083,.067,.05 }
    #local _bb=1;
    #local _neg=.75;
    #local _st=7;    
    blob_thing(_pos,_col,_sca,_rad,_bb,_neg,_st)
  }
  blob {
    rebt(.6) 
// upper claw jaw    
    #local _pos=array[4] { <-.5,-.3,0>,<0,-.45,0>,<.5,-.2,0>,<1,-.45,0> }
    #local _col=array[4] { <.5,.2,.1>,<.6,.3,.05>,<.5,.2,.05>,<.5,.2,.05> }
    #local _sca=array[4] { <1,1,1.3>,<1,1.5,1.6>,<1,1,1.3>,<1,1,1> }
    #local _rad=array[4] { .15,.15,.125,.075 }
    #local _bb=1;
    #local _neg=.5;
    #local _st=40;    
    blob_thing(_pos,_col,_sca,_rad,_bb,_neg,_st)
    
    #local _pos=array[4] { <-.5,-.3,0>,<0,-.1,0>,<.5,-.1,0>,<1,-.35,0> }
    #local _col=array[4] { <1,1,1>,<1,1,1>,<1,1,1>,<1,1,1> }
    #local _sca=array[4] { <1,1,1>,<1,1,1>,<1,1,1>,<1,1,1> }
    #local _rad=array[4] { .01,.083,.067,.05 }
    #local _bb=1;
    #local _neg=.5;
    #local _st=40;    
    blob_thing(_pos,_col,_sca,_rad,_bb,_neg,_st)
    
    #local _pos=array[4] { <-.5,-.3,0>,<0,-.1,0>,<.5,-.1,0>,<1,-.35,0> }
    #local _col=array[4] { <1,1,1>,<1,1,1>,<1,1,1>,<1,1,1> }
    #local _sca=array[4] { <1,1,1>,<1,1,1>,<1,1,1>,<1,1,1> }
    #local _rad=array[4] { .01,.083,.067,.05 }
    #local _bb=1;
    #local _neg=.75;
    #local _st=7;    
    blob_thing(_pos,_col,_sca,_rad,_bb,_neg,_st)
  }
  rotate <60,0,0>   
  translate <1.6,0,0>
  texture {
    pigment { color rgb<0,0,0> }
    finish { crab_fin }
  }
}

#macro claw_const(_a1,_a2,_a3)
  union {
    object { upper_claw rotate <0,0,_a1> }
    object { middle_claw rotate <0,0,_a2> translate vrotate(<1.5,0,0>,<0,0,_a1>) }
    object { claw_jaws rotate <0,0,_a3> translate vrotate(<1.5,0,0>,<0,0,_a1>)+vrotate(<.5,0,0>,<0,0,_a2>) }
    sphere { 0,.25 texture { lig_tex } }
    sphere { 0,.22 texture { lig_tex } translate vrotate(<1.5,0,0>,<0,0,_a1>) }
    sphere { 0,.3 texture { lig_tex } translate vrotate(<1.5,0,0>,<0,0,_a1>)+vrotate(<.5,0,0>,<0,0,_a2>) } 
  }
#end
#declare crab=
  union {
    object { limb_const(52,-38,-50) rotate <-10,-30,0> translate <1.75,0,2> }    // bbL
    object { limb_const(52,-60,-70) rotate <-5,-15,0> translate <2,0,1> }       // bmL
    object { limb_const(40,-40,-70) rotate <0,0,0>   translate <2.15,0,0> }      // fmL
    object { limb_const(42,-80,-70) rotate <5,10,0>  translate <2.25,0,-1> }    // ffL
    
    object { limb_const(15,-60,-70) rotate <-10,-30,0> scale <-1,1,1> translate <-1.75,0,2> }   // bbR
    object { limb_const(10,-60,-70) rotate <-5,-15,0> scale <-1,1,1> translate <-2,0,1> }      // bmR
    object { limb_const(-5,-30,-50) rotate <0,0,0>   scale <-1,1,1> translate <-2.15,0,0> }     // fmR
    object { limb_const(15,-75,-70) rotate <5,10,0>  scale <-1,1,1> translate <-2.25,0,-1> }   // ffR
      
    object { claw_const(-25,-115,-150) rotate <85,20,0> translate <2.25,0,-2> }
    object { claw_const(-20,-135,-155) rotate <100,20,0> scale <-1,1,1> translate <-2.25,0,-2> }
    
    object { crab_body }
    scale .1
  }

#ifndef(main_render)

object { crab
  scale 5
  rotate <0,30,0>
  translate <0,2,0>
}


plane { -z,0 texture { pigment { color rgb<1,1,1> } } translate <0,0,20> }
plane { y,0 texture { pigment { color rgb<1,1,1> } } }
#end

#render concat("Total crab blob component count = ",str(crab_blobs,0,0),"\n")