#render "building mud-hut\n"
#ifndef(main_render)

global_settings {
  assumed_gamma 1.6
  max_intersections 350
  max_trace_level 350
}

#declare cam_pos=<0,2,-10>;
#declare cam_tgt=<0,1.5,0>;

#declare light_pos=<-1000,1500,-1500>;
#declare pen_light=.2;
#declare amb_light=.15;

camera {
  location cam_pos
  up <0,1,0>
  right <4/3,0,0>
  direction <0,0,1.45>
  look_at cam_tgt
}

light_source {
  light_pos
  1-pen_light
}
light_source {
  light_pos
  pen_light
  shadowless
}

#macro flight_spline(_p1,_p2,_p3,_p4,_sc,_ec,_cc)
  #if (_cc<=_sc)
    (_p1)
  #else
    #if (_cc>=_ec)
      (_p4)
    #else
      #local _ci=(_cc-_sc)/(_ec-_sc);
      #local _co=(1-_ci);
      //  p = (p1*co^3)+(3*p2*co^2*ci)+(3*p3*ci^2*co)+(p4*ci^3) 
         ( ( _p1*pow(_co,3) ) + ( _p2*3*pow(_co,2)*_ci ) + ( _p3*3*pow(_ci,2)*_co ) + ( _p4*pow(_ci,3) ) )
    #end
  #end
#end  

#macro rebt(_threshold)
   #declare reb_thresh=_threshold;
   threshold _threshold
#end
//  
#macro reb(_visibleradius,_blobbiness)
   #local _strength = reb_thresh*(1+1/_blobbiness);
   #local _actualradius =_visibleradius/sqrt(1-sqrt(reb_thresh/_strength));
   _actualradius, _strength
#end

#macro flight_array(_pos,_sc,_ec,_cc) // as-per flight spline, but positions passed as a four element array
  #if (_cc<=_sc)
    (_pos[0])
  #else
    #if (_cc>=_ec)
      (_pos[3])
    #else
      #local _ci=(_cc-_sc)/(_ec-_sc);
      #local _co=(1-_ci);
      //  p = (p1*co^3)+(3*p2*co^2*ci)+(3*p3*ci^2*co)+(p4*ci^3) 
         ( ( _pos[0]*pow(_co,3) ) + ( _pos[1]*3*pow(_co,2)*_ci ) + ( _pos[2]*3*pow(_ci,2)*_co ) + ( _pos[3]*pow(_ci,3) ) )
    #end
  #end
#end  

#end

#declare h_j_seed=seed(1);
#macro h_jitt(j_qty)
  #local j_rad=j_qty*rand(h_j_seed);
  #local j_ang=<360*rand(h_j_seed),360*rand(h_j_seed),360*rand(h_j_seed)>;
  ( vrotate(<0,1,0>,j_ang)*j_rad )
#end

#declare pale_mud=
  texture {
    pigment {
      color rgb<.3,.2,0>
    }
    finish {
      ambient amb_light
      diffuse .8
      roughness .6
      specular .1
    }
  }
#render "Walls:\n"
#local hut_blobs=0;  
#declare hut_walls=
  blob {
    threshold .6    
    #local ang=0;
    #local ang_st=2.5;
    #while (ang<180)
      #local hut_hei=(flight_spline(3.25,3.2,2.75,-2,0,25,ang));//0;      
      #while (hut_hei<4)
      
        sphere { 0,.25,2 scale <2,2,1> translate <0,hut_hei,-3.5> translate h_jitt(<.1,.1,.1>) rotate <0,(-ang-ang_st),0> }
        sphere { 0,.25,2 scale <2,2,1> translate <0,hut_hei,-3.5> translate h_jitt(<.1,.1,.1>) rotate <0,ang,0> }
        
        #local hut_blobs=hut_blobs+1;
        #local hut_hei=hut_hei+.2;
      #end
      #render concat(str(100*ang/180,0,0),"%\n")
      #local ang=ang+ang_st;
    #end
    texture {
      pale_mud
    } 
  }

#declare straw_tex=
  texture {
    pigment {
      color rgb<.6,.4,.1>
    }
    finish {
      ambient amb_light
      diffuse .8
      roughness .4
      specular .2
    }
  }
#render "Roof:\n"  
#declare hut_roof=
  union {
    #local ang=0;
    #while (ang<360)
      #local hei=0;
      #while (hei<1)
        #local _e1=(flight_spline(<0,4,-4.25>,<0,5,-4>,<0,5,-3>,<0,6,-2>,0,1,hei))+h_jitt(<.3,.1,.2>);
        #local _e2=(flight_spline(<0,6,0>,<0,6.5,0>,<0,6.75,0>,<0,7.5,0>,0,1,hei))+h_jitt(<.2,.1,.2>);
        cylinder { _e1,_e2,.02 rotate <0,ang,0> }
        #local hei=hei+.02;
      #end
      #render concat(str(100*ang/360,0,0),"%\n")
      #local ang=ang+2;
    #end
    texture { straw_tex }
  }
  
#declare hut=
  union {
    object { hut_walls }
    object { hut_roof }
  }      
#ifndef(main_render)

object { hut
  scale .5
}


plane { -z,0 texture { pigment { color rgb<1,1,1> } } translate <0,0,20> }
plane { y,0 texture { pigment { color rgb<1,1,1> } } }
#end

#render concat("Total boat blob component count = ",str(hut_blobs,0,0),"\n")