#ifndef(main_render)

global_settings {
  assumed_gamma 1.6
  max_intersections 350
  max_trace_level 350
}

#declare cam_pos=<0,.1,-20>;
#declare cam_tgt=<0,6,0>;

#declare light_pos=<-1000,1500,-1500>;
#declare pen_light=.2;
#declare amb_light=.15;

camera {
  location cam_pos
  up <0,1,0>
  right <4/3,0,0>
  direction <0,0,1.45>
  look_at cam_tgt
}

light_source {
  light_pos
  1-pen_light
}
light_source {
  light_pos
  pen_light
  shadowless
}

#macro flight_spline(_p1,_p2,_p3,_p4,_sc,_ec,_cc)
  #if (_cc<=_sc)
    (_p1)
  #else
    #if (_cc>=_ec)
      (_p4)
    #else
      #local _ci=(_cc-_sc)/(_ec-_sc);
      #local _co=(1-_ci);
      //  p = (p1*co^3)+(3*p2*co^2*ci)+(3*p3*ci^2*co)+(p4*ci^3) 
         ( ( _p1*pow(_co,3) ) + ( _p2*3*pow(_co,2)*_ci ) + ( _p3*3*pow(_ci,2)*_co ) + ( _p4*pow(_ci,3) ) )
    #end
  #end
#end  

#end

#declare sp_leaf_tex=
  texture {
    pigment {
      color rgb<.2,.5,.1>
    }
    finish {
      ambient amb_light
      diffuse .8
      roughness .1
      specular .4
    }
  }
  
#macro v_spline_leaf(_lp1,_lp2,_lp3,_lp4, //  curve of leaf - base to tip
                     _vc1,_vc2,_vc3,_vc4, //  'v' cross section of leaf
                     _lw1,_lw2,_lw3,_lw4) //  leaf width - base to tip   
                      
                     
  // n.b. build the leaf with base at origin, and tip in the +z direction                     

  union {
    bicubic_patch {
      type 0 flatness 0.0100 u_steps 3 v_steps 3,
      _lp1+_vc1*_lw1,_lp1+_vc2*_lw1,_lp1+_vc3*_lw1,_lp1+_vc4*_lw1,
      _lp2+_vc1*_lw2,_lp2+_vc2*_lw2,_lp2+_vc3*_lw2,_lp2+_vc4*_lw2,
      _lp3+_vc1*_lw3,_lp3+_vc2*_lw3,_lp3+_vc3*_lw3,_lp3+_vc4*_lw3,
      _lp4+_vc1*_lw4,_lp4+_vc2*_lw4,_lp4+_vc3*_lw4,_lp4+_vc4*_lw4  
    }
    bicubic_patch {
      type 0 flatness 0.0100 u_steps 3 v_steps 3,
      _lp1+_vc1*_lw1,_lp1+_vc2*_lw1,_lp1+_vc3*_lw1,_lp1+_vc4*_lw1,
      _lp2+_vc1*_lw2,_lp2+_vc2*_lw2,_lp2+_vc3*_lw2,_lp2+_vc4*_lw2,
      _lp3+_vc1*_lw3,_lp3+_vc2*_lw3,_lp3+_vc3*_lw3,_lp3+_vc4*_lw3,
      _lp4+_vc1*_lw4,_lp4+_vc2*_lw4,_lp4+_vc3*_lw4,_lp4+_vc4*_lw4  
      scale <-1,1,1>
    } 
  }                                              
#end

#local bsp_layers=5;      
#local bsp_leaves=5;
#local bsp_leaf=array[bsp_layers]
#local _spl=0;
#while (_spl<bsp_layers)
  #local _ang=(flight_spline(40,70,85,90,0,bsp_layers,_spl));
  #local _len=(flight_spline(3,4,4.25,4.5,0,bsp_layers,_spl));
  #local bsp_leaf[_spl]=object { v_spline_leaf(<0,0,0>,<0,_len/6,0>,vrotate(<0,_len/1.8,-_len/4>,<_ang,0,0>),vrotate(<0,_len,0>,<_ang,0,0>),
                                       <0,0,0>,<.1,.3,0>,<.3,.3,0>,<.5,.1,0>,
                                       .1,.5,.7,.01) }
  #local _spl=_spl+1;
#end

#declare bspike_plant=
  union {
  #local j_rnd=seed(10);
  #local _spl=0;                 
  #while (_spl<bsp_layers)
    union {
    #local _rot=0;
    #while (_rot<1)
      object { bsp_leaf[_spl] rotate <0,_rot*360,0> }
      #local _rot=_rot+1/bsp_leaves;
    #end
      rotate <0,rand(j_rnd)*360/bsp_leaves,0>
    }
    #local _spl=_spl+1;
  #end
  texture { sp_leaf_tex }
  scale .75
  }
  
#local ssp_layers=3;      
#local ssp_leaves=5;
#local ssp_leaf=array[ssp_layers]
#local _spl=0;
#while (_spl<ssp_layers)
  #local _ang=(flight_spline(20,50,80,88,0,ssp_layers,_spl));
  #local _len=(flight_spline(1.5,1.5,2,2,0,ssp_layers,_spl));
  #local ssp_leaf[_spl]=object { v_spline_leaf(<0,0,0>,<0,_len/6,0>,vrotate(<0,_len/1.8,-_len/4>,<_ang,0,0>),vrotate(<0,_len,0>,<_ang,0,0>),
                                       <0,0,0>,<.1,.3,0>,<.3,.3,0>,<.5,.1,0>,
                                       .1,.5,.7,.01) }
  #local _spl=_spl+1;
#end

#declare sspike_plant=
  union {
  #local j_rnd=seed(10);
  #local _spl=0;                 
  #while (_spl<ssp_layers)
    union {
    #local _rot=0;
    #while (_rot<1)
      object { ssp_leaf[_spl] rotate <0,_rot*360,0> }
      #local _rot=_rot+1/ssp_leaves;
    #end
      rotate <0,rand(j_rnd)*360/ssp_leaves,0>
    }
    #local _spl=_spl+1;
  #end
  texture { sp_leaf_tex }
  scale .75
  }




#declare trunk_tex=
  texture {
    pigment {
      color rgb<.3,.25,.05>
    }
    finish {
      ambient amb_light
      diffuse .8
      roughness .8
      specular .05
    }
    normal {
      bumps .2
      scale .1
    }
  }
#declare palm_leaf_tex=
  texture {
    pigment {
      color rgb<.2,.4,.15>
    }
    finish {
      ambient amb_light
      diffuse .8
      roughness .1
      specular .2
    }
  }
#declare transparent_tex=
  texture {
    pigment {
      color rgbf<1,1,1,1>
    }
    finish { ambient 0 diffuse 0 }
  }
#declare palm_leaf_strips=
  texture {
    wood
    sine_wave
    frequency 2
    rotate <90,0,0>
    texture_map {
      [ .0 palm_leaf_tex ]
      [ .15 palm_leaf_tex ]
      [ .15 transparent_tex ]
      [ .85 transparent_tex ]
      [ .85 palm_leaf_tex ]
      [ 1. palm_leaf_tex ]
    }
  }                            
  
#macro trunk_bit(_pos,_ang,_rad,_len,_diff)
  union {
    cone { <0,-.1,0>,_rad,<0,_len+_diff,0>,_rad+_diff }
    torus { _rad,_diff translate <0,_len+_diff,0> }    
    texture { trunk_tex }
    scale <.75,1,.75>
    rotate _ang translate _pos 
  }
#end

#macro v_spline_stalk(_lp1,_lp2,_lp3,_lp4)
  union {  
    #local _stp=1/10;
    #local _ss=_stp;
    #local _lp=_lp1;
    #while (_ss<=1+1/20)
      #local _tp=(flight_spline(_lp1,_lp2,_lp3,_lp4,0,1,_ss));
      #local _rd=(flight_spline(1,1,.6,.5,0,1,_ss));
      cylinder { _lp,_tp,.07*_rd }
      sphere { _tp,.07*_rd }
      #local _lp=_tp;
      #local _ss=_ss+1/10;
    #end
  }
#end
#macro v_spline_palm(_lp1,_lp2,_lp3,_lp4, //  curve of leaf - base to tip
                     _vc1,_vc2,_vc3,_vc4, //  'v' cross section of leaf
                     _lw1,_lw2,_lw3,_lw4) //  leaf width - base to tip   
                      
                     
  // n.b. build the leaf with base at origin, and tip in the +z direction                     

    union {
      bicubic_patch {
        type 0 flatness 0.0100 u_steps 3 v_steps 3,
        _lp1+_vc1*_lw1,_lp1+_vc2*_lw1,_lp1+_vc3*_lw1,_lp1+_vc4*_lw1,
        _lp2+_vc1*_lw2,_lp2+_vc2*_lw2,_lp2+_vc3*_lw2,_lp2+_vc4*_lw2,
        _lp3+_vc1*_lw3,_lp3+_vc2*_lw3,_lp3+_vc3*_lw3,_lp3+_vc4*_lw3,
        _lp4+_vc1*_lw4,_lp4+_vc2*_lw4,_lp4+_vc3*_lw4,_lp4+_vc4*_lw4  
      }
      bicubic_patch {
        type 0 flatness 0.0100 u_steps 3 v_steps 3,
        _lp1+_vc1*_lw1,_lp1+_vc2*_lw1,_lp1+_vc3*_lw1,_lp1+_vc4*_lw1,
        _lp2+_vc1*_lw2,_lp2+_vc2*_lw2,_lp2+_vc3*_lw2,_lp2+_vc4*_lw2,
        _lp3+_vc1*_lw3,_lp3+_vc2*_lw3,_lp3+_vc3*_lw3,_lp3+_vc4*_lw3,
        _lp4+_vc1*_lw4,_lp4+_vc2*_lw4,_lp4+_vc3*_lw4,_lp4+_vc4*_lw4  
        scale <-1,1,1>
      } 
    }                                              
#end

#local pl_layers=5;
#local pl_leaves=9;
#local pl_leaf=array[pl_layers]
#local pl_stalk=array[pl_layers]
#local _pl=0;
#while (_pl<pl_layers)
  #local _ang=(flight_spline(30,60,90,110,0,pl_layers,_pl));
  #local _len=(flight_spline(6,7,8,7,0,pl_layers,_pl));
  #local pl_leaf[_pl]=object { v_spline_palm(<0,0,0>,<0,_len/4,0>,vrotate(<0,_len/1.5,-_len/3>,<_ang,0,0>),vrotate(<0,_len,0>,<_ang,0,0>),
                                       <0,0,0>,<.1,.2,0>,<.65,0,-.1>,<.75,-1.25,-.2>,
                                       .01,.01,1,.25) }
  #local pl_stalk[_pl]=object { v_spline_stalk(<0,0,0>,<0,_len/4,0>,vrotate(<0,_len/1.5,-_len/3>,<_ang,0,0>),vrotate(<0,_len,0>,<_ang,0,0>)) }
  #local _pl=_pl+1;
#end

#declare bpalm_crest=
  union {
  #local j_rnd=seed(10);
  #local _pl=0;                 
  #while (_pl<pl_layers)
    union {
    #local _rot=0;
    #while (_rot<1)
      object { pl_leaf[_pl] rotate <10*rand(j_rnd),0,0> translate <0,0,_pl*.1> rotate<0,_rot*360,0> }
      #local _rot=_rot+1/pl_leaves;
    #end
      texture { palm_leaf_strips }
      rotate <0,rand(j_rnd)*360/pl_leaves,0>
    }
    #local _pl=_pl+1;
  #end
  
  #local j_rnd=seed(10);
  #local _pl=0;                 
  #while (_pl<pl_layers)
    union {
    #local _rot=0;
    #while (_rot<1)
      object { pl_stalk[_pl] rotate <10*rand(j_rnd),0,0> translate <0,0,_pl*.1> rotate<0,_rot*360,0> }
      #local _rot=_rot+1/pl_leaves;
    #end
      texture { palm_leaf_tex }
      rotate <0,rand(j_rnd)*360/pl_leaves,0>
    }
    #local _pl=_pl+1;
  #end
  
  scale 2
  }

#macro palm_crest(_pos,_ang,_siz)
  object { bpalm_crest scale _siz rotate _ang translate _pos }
#end

#macro palm_tree(_pos,_a1,_a2,_a3,_a4,_ns,_sr,_sh,_df)
// position, angle of trunk at key poits a1, a2, a3 &a4
// _ns (number of segments), segment radius, segment length
  union {           
  #render "Building Palm-Tree\n"
  #local _cp=_pos;           
  #local _sc=0;
  #while (_sc<=_ns)
  
    #local _ca=(flight_spline(_a1,_a2,_a3,_a4,0,_ns,_sc));
    #local _sz=(flight_spline(1,.9,.8,.7,0,_ns,_sc));
    trunk_bit(_cp,_ca,_sr*_sz,_sh*_sz,_df*_sz)
    #local _cp=_cp+vrotate(<0,_sh*_sz,0>,_ca);
  
    #local _sc=_sc+1;
  #end
  palm_crest(_cp,_ca,_sr*_sz)
  }
#end
                                      
#ifndef(main_render)

object {
  palm_tree(<-4,-3,0>,<-2,0,5>,<-4,0,7>,<-3,0,-10>,<-5,0,-15>,8,.5,1.5,.1)
}

object {
  pl_leaf[pl_layers-1] //palm_leaf(<0,0,0>,<0,0,0>,.8)
  rotate <-90,0,0>
  translate <4,2,-4>
}                                                         

object {
  object { bspike_plant }
  translate <6,0,0>
}
object {
  object { sspike_plant }
  translate <0,0,0>
}
plane { -z,0 texture { pigment { color rgb<1,1,1> } } translate <0,0,20> }
plane { y,0 texture { pigment { color rgb<1,1,1> } } }

#end