// Persistence of Vision Ray Tracer Scene Description File
// File: hosttex.inc
// Vers: 3.1
// Desc: texture file for hostage.pov
// Date: 04/28/2001
// Auth: Bob Franke
//

#version 3.1

#declare Quiet_Water = 
texture {
  pigment {
    color rgb <0.1, 0.1,0.15>
  }
  normal { bumps 0.01 scale<1,2,1>}
  finish {
  #version -1.0;
    reflection 0.7
    refraction 0.5
    ior 1.33 
  #version 3.1;
    phong .5
    phong_size 25  
    roughness 0.1
    irid {0.125 thickness .1 turbulence .65 }  
    ambient .05
  }
  scale .2
}

#declare silvx=.9     
#declare oldWood =  
texture{
  pigment{
    bozo
    turbulence 0.56 
    omega 0.2
    color_map {
      [0.0 Silver*silvx]
      [0.4 Silver*silvx]
      [0.5 LightWood*.75]
      [0.7 Silver*silvx]
      [1.0 Silver*silvx]
    }    
    scale <8,.5,.5> 
  } 
  normal{  
    bump_map { 
      tga "woodmap.tga"
      interpolate 2
      bump_size 9
    }  
    scale 10
  } 
  finish {
    crand .1  ambient .05}
}  


     
     
#declare oldWood2 =  
texture{
  pigment{
    bozo
    turbulence 0.56 
    omega 0.2
    color_map {
      [0.0 Silver*silvx]
      [0.4 Silver*silvx]
      [0.5 LightWood*.75]
      [0.7 Silver*silvx]
      [1.0 Silver*silvx]
    }    
    scale <5,.5,.5> 
  } 
  normal{  
    bump_map { 
      tga "woodmap.tga"
      interpolate 2
      bump_size 1.125*5
    }  
    scale 8 //13
  } 
  finish {
    crand .1  ambient .2}
}  
  
  
#declare Rusttex =
texture {
  pigment {
    bozo
    color_map {
      [0.0 rgb <.6,.5,.3>*.8]
      [0.5 rgb <.4,.2,.2>*.8]
      [1.0 rgb <.5,.3,.1>*.8]
    }
    turbulence .25
    scale <.25,.5,.25>*.4
  }
  finish {phong .1 phong_size 10}
  normal {bumps .6 scale .01}
}


// bare old metal
#declare IRONX=.4
#declare OldIron =
texture {
  pigment {
    bozo
    color_map {
      [0.0  Gray50*IRONX]
      [0.25 Gray80*IRONX]
      [0.57 Gray60*IRONX]
      [0.65 Gray40*IRONX]
      [0.88 Gray80*IRONX]
      [1.0  Gray50*IRONX]
    }
    turbulence 1
    scale .05
  }
  normal {dents 1 scale .1}
}


#declare Rusttex2 =
texture {
  pigment {
    bozo
    color_map {
      [0.0 rgb <.6,.5,.3>*.8]
      [0.5 rgb <.4,.2,.2>*.8]
      [1.0 rgb <.5,.3,.1>*.8]
    }
    turbulence .25
    scale <.25,.5,.25>*.4
  }
  finish {phong .1 phong_size 10}
  normal {bumps .5 scale .01}
  finish{ambient .5}
}


// bare old metal
#declare IRONX=.5
#declare OldIron2 =
texture {
  pigment {
    bozo
    color_map {
      [0.0  Gray50*IRONX]
      [0.25 Gray80*IRONX]
      [0.57 Gray60*IRONX]
      [0.65 Gray40*IRONX]
      [0.88 Gray80*IRONX]
      [1.0  Gray50*IRONX]
    }
    turbulence 1
    scale .05
  }
  finish{ambient .5} normal {dents 1 scale .1}
}


// rusty metal
#declare RustyIron2 =
texture {
  crackle
  texture_map {
    [0.0 OldIron2]
    [0.05 OldIron2]
    [0.35 Rusttex2]
    [1.0 Rusttex2]
  }
  scale .2
  turbulence .5 
}


#declare RustyIron =
texture {
  crackle
  texture_map {
    [0.0 OldIron]
    [0.05 OldIron]
    [0.35 Rusttex]
    [1.0 Rusttex]
  }
  scale .2
  turbulence .5     
}
