// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3.1
// Desc: Basic Scene Example
// Date: mm/dd/yy
// Auth: ?[esp]
//

#version 3.1

#include "colors.inc"

global_settings
{                                              
  assumed_gamma 2
}                                                

// ----------------------------------------
camera
{
  location  <0, 750, 0>
  direction 20*y                     
  right     4/4*x
  look_at   <0, 0.0,  0>
}


light_source
{
  0*x // light's position (translated below)
  color White*1.5
  translate <0, 10000, 0>
}

// ----------------------------------------
                          
#declare oneBrick =
  superellipsoid{ <.2,.2> 
    scale<1,1,.5> 
  }    


#declare roty= seed(12345);
#declare randz= seed(125);
#declare bright = seed(315);
                
#declare xoffset = 0;
#declare xx = -20;
#declare zz = -20  
union{
  #while (zz < 20)
    #declare xx = -20;
    #while (xx < 20)  
      #declare bb = rand(bright);
      object{oneBrick 
        #switch (bb)
          #range (0.0,.2)
            pigment{Firebrick*(1.25 - .5*rand(bright))}
          #break 
          #range (.2,.4)
            pigment{OrangeRed*(.65 - .2*rand(bright))}
          #break 
          #range (.4,.6)
            pigment{Salmon*(1.5 - .3*rand(bright))}
          #break 
          #range (.6,.8) 
            pigment{Firebrick*(1.25 - .3*rand(bright))}
          #break 
          #range (.8,1.0)
            pigment{Firebrick*(1.25 - .3*rand(bright))}
          #break 
          #else
            pigment{Firebrick*(1.25 - .3*rand(bright))}
        #end // End of conditional part
        rotate<0,rand(roty)*1.5,rand(roty)*1.5>
        translate<xx+xoffset+ rand(randz)*.15,rand(randz)*.1,zz+ rand(randz)*.15>   
      }    

      #declare xx = xx + 2.15;                                               
    #end
    #declare zz = zz + 1.15;                      
    #if (xoffset=1)
      #declare xoffset=0;
    #else
      #declare xoffset=1;
    #end  
  #end  
}

