#version unofficial MegaPov 0.7; 

#declare ShapeTex1 =
        texture { pigment { gradient z
        color_map {
     [  0.00  color red 0.18 green 0.15 blue 0.12]
     [  0.225 color red 0.18 green 0.15 blue 0.12]
     [  0.275 color red 0.3 green 0.205 blue 0.145]
     [  0.775 color red 0.3 green 0.205 blue 0.145]
     [  0.825 color red 0.18 green 0.15 blue 0.12]
     [  1.00  color red 0.18 green 0.15 blue 0.12] }

} finish {ambient 0.04 diffuse 0.7 specular 0.3 roughness 0.005} scale <1,1,0.4> }

#declare ShellTex1 =
        texture { pigment { gradient y
        color_map {
        
     [  0.00 color red 0.18 green 0.15 blue 0.12]
     [  0.05 color red 0.18 green 0.15 blue 0.12]
        
     [  0.05 color red 0.233 green 0.167 blue 0.1]
     [  0.45 color red 0.233 green 0.167 blue 0.1]

     [  0.45 color red 0.35 green 0.16 blue 0.14]
     [  0.50 color red 0.35 green 0.16 blue 0.14]

     [  0.50 color red 0.18 green 0.15 blue 0.12]
     [  0.55 color red 0.18 green 0.15 blue 0.12]

     [  0.55 color rgbt 1]
     [  1.00 color rgbt 1] }
} finish {ambient 0.04 diffuse 0.7 specular 0.3 roughness 0.005} scale <1,0.3,1> }

#declare ShellTex2 =
        texture { pigment { colour rgbt 1 }
                  finish  { ambient 0.04 diffuse 0.7 specular 0.3 roughness 0.005}
                  normal { bumps 0.4 scale <10,0.01,10> } }

// ----------------------------------------
// Shell2 - rising coil shape
#declare Shape2 =
        sphere { <0,0,0> 1
        scale <1.15,1,1>
        rotate y*90
        texture { ShapeTex1 } }
#declare NumIterations = 80
#declare Counter       = 0.0
#declare Increment     = 1.0/(NumIterations/2)
#declare NumTwists     = 360*4 // number of twists
// ----------------------------------------
#declare Shell2 =
union{
  #while (Counter<=1.0)
    object    {
      Shape2
      scale <(1-Counter)*2,(1-Counter)*1.50,(1-Counter)*2>
      translate <(1-Counter)*1.25, Counter*4, 0.0>
      rotate NumTwists*Counter*y
      texture { ShellTex1 }
      texture { ShellTex2 } }
    #declare Counter=Counter+Increment
    #end

union {
 sphere {  <0, 4.9, 0>   0.8 scale <1,0.6,1> }
 sphere {  <0, 5.6, 0>   0.5 scale <1,0.6,1> }
 sphere {  <0, 6.1, 0>   0.3 scale <1,0.6,1> }

texture { ShellTex1 }
texture { ShellTex2 } }
}
  
object { Shell2 scale 0.25*0.85 rotate 85*x rotate -30*z rotate -105*y rotate <-135.08,-154.9,103.8> translate <1.5,-4.28,14.7>}
