#version unofficial MegaPov 0.7;
global_settings { 	assumed_gamma 1.8 
			max_trace_level 50
			ambient_light rgb 1.2
		
}

#include "colors.inc"


// ----------------------------------------
//background {
//	rgb <0.543999, 0.800000, 0.748791>
//}

#declare debug_options = true;
#declare star_count = 1105; 
#declare star_scale =  .5; 
#declare star_spread =  1; 
#declare star_distance =  20000 ; 
#include "Galaxy.sf" 

light_source {
			<0, 300000, 0>
			rgb <1.0, 1.0, 1.0>*.45*.3
				rotate -70*x
				rotate  3*y
}
light_source {
			<0, 10000, 0>
			rgb <1.0, 1.0, 1.0>*.17*.3
				rotate  30*x
				rotate  66*y
}
light_source {
			<0, 10000, 0>
			rgb <1.0, 1.0, 1.0>*.17*3.
				rotate -40*x
				rotate  -45*y
}
//   	//	//	//Area Fog
cylinder {
	<0, -1, 0>, <0, 1, 0>, 1
	hollow
		pigment { rgbf < 1, 1, 1, 1 > }

			interior {
					media {
								absorption .001
								intervals 10
								samples 1,  15
								confidence 0.99
								variance 1/500
								density {
									gradient y
										color_map {
													[ 0.0 rgb < .9, .9, 1 >*.5 ]
													[ .25 rgb < .9, .9, 1 >*.35 ]
													[ .65 rgbf < 0, 0, 0, 1 > ]
													[ 1 rgbf < 0, 0, 0, 1 > ]
												}
									frequency 1
									turbulence < .01, .03, .01 >
									octaves 	9
									lambda 2
									omega 0.25
								}
					}
			}
	scale < 600, 100, 600 >
	translate < 150, 0, -1028>
}
camera {
	perspective 
	location < 150, 6, -1028>
		right 2*x
		up y
		angle 80
	look_at < 0, 50, -550 -300>
}
#declare AuroraOn =		1	;
#declare EveningSkyON =	1	;
#declare GroundSceneEqualsOn =		1	;
#declare GateEqualsOn =		1	;
#declare MesaEqualsOn =		1	;
#declare SuperStreakOn =	1	;
#declare SuperKeyOn =	1	;
#declare GroundFogsOn =	1	;
#declare Turquoisish =	rgb < 0.68, 0.92, 0.92>*2 ;
#declare InBetweenIsh =	rgb < 0.68, 0.92, 0.92>*3 ;
#declare Whiteish =	rgb < 0.68, 0.92, 0.92>*4 ;

#declare FrameWork = union {
//	//Picture Frame
	object {
			difference {
					box {
						<-0.5, -0.5, -0.5>, <0.5, 0.5, 0.5> 
					}
					box {
						<-0.5, -0.5, -0.5>, <0.5, 0.5, 0.5>
							scale < .95, .91, 1.1 >
					}
			}
				no_reflection
				no_shadow
				translate < 0, 0, 0.5>
					scale <  2, 1, .0001 >*4
						pigment { White 
						}
						finish {
							ambient .6
							diffuse .8
						}
						rotate  -13.8846676*.775*x 
						rotate -40.1207262*y
						translate < 150, -44, -178>*-.0201
						translate < 150, 6, -1028> 
	}

	union  {
	box {
		<-0.5, -0.5, -0.5>, <0.5, 0.5, 0.5>
		translate < 0.4, 0, .501 >
		scale <  9.6, 13, 1 >
		pigment { rgb < 0.678431, 0.917647, 0.917647>*2 }
	}
	difference {
		box {
			<-0.5, -0.5, -0.5>, <0.5, 0.5, 0.5>
		}
		box {
			<-0.5, -0.5, -0.5>, <0.5, 0.5, 0.5>
			scale < .98, .99, 1.1 >
		}
			translate < 0.4, 0, .49 >
			scale < 9.6, 13.1, 1.1 >
			pigment { Black }
	}
	
///	///	Caption Text	
	
			text {
				ttf "Comic Sans MS.ttf",
				"THE REDS AND"
					1, < 0, 0.0, 0.0>
					align_left
					translate < 0, 5, 0 >
			}
			text {
				ttf "Comic Sans MS.ttf",
				"BLUES RAN"
					1, < 0.05, 0.0, 0.0>
					align_left
					translate < 0, 4, 0 >
			}
			text {
				ttf "Comic Sans MS Bold.ttf",
				"TOGETHER"
					1, < 0.05, 0.0, 0.0 >
					align_left
					translate < 0, 3, 0 >
			}
			text {
				ttf "Comic Sans MS.ttf",
				"YOU SEE, SO"
					1, < 0.05, 0.0, 0.0 >
					align_left
					translate < 0, 2, 0 >
			}
			text {
				ttf "Comic Sans MS.ttf",
				"THAT'S HOW"
					1, < 0.05, 0.0, 0.0 >
					align_left
					translate < 0, 1, 0 >
			}
			text {
				ttf "Comic Sans MS.ttf",
				"HE LOOKED"
					1, < 0.05, 0.0, 0.0 >
					align_left
					translate < 0, -0, 0 >
			}
			text {
				ttf "Comic Sans MS.ttf",
				"WHEN HE"
					1, < 0.05, 0.0, 0.0 >
					align_left
					translate < 0, -1, 0 >
			}
			text {
				ttf "Comic Sans MS Bold.ttf",
				"FLEW..."
					1, < 0.05, 0.0, 0.0 >
					align_left
					translate < .5, -2, 0 >
			}
		
		///////
			text {
				ttf "Comic Sans MS.ttf",
				"...A"
					1, < 0.05, 0.0, 0.0 >
					align_left
					translate < 2.5, -3.5, 0 >
			}
			text {
				ttf "Comic Sans MS.ttf",
				"VIOLET"
					1, < 0.05, 0.0, 0.0 >
					align_left
					translate < 2, -4.5, 0 >
			}
			text {
				ttf "Comic Sans MS.ttf",
				"COMET"
					1, < 0.05, 0.0, 0.0 >
					align_left
					translate < 2, -5.5, 0 >
			}
	scale < .015, .015, .003 >
			pigment { Black }
			finish {
				ambient 1
				diffuse 1
			}
				rotate  1*x 
				rotate 1*z
				translate <  .013, .025, 1>
				rotate  -13.8846676*.775*x 
				rotate -40.1207262*y
				translate < 150-0, 6, -1028>
				translate < -.1, 0, .1>
				translate < .633, .13, 0 >
				no_reflection
				no_shadow
}
}

light_source {
	<0, 0, 0>
	rgb <1.0, 1.0, 1.0>*.1
	looks_like { FrameWork }
		media_interaction off
		shadowless
		fade_distance 4
		fade_power 4
}

#switch (  GroundFogsOn   )
#case (1 )
//	//Mesa Fog
cylinder {
	<0, -1, 0>, <0, 1, 0>, 1
	hollow
		pigment { rgbf < 1, 1, 1, 1 > }

			interior {
					media {
						emission .001
								intervals 10
								samples 1,  15
								confidence 0.99
								variance 1/500
								density {
									gradient y
										color_map {
													[ 0.0 rgb < .9, .9, 1 >*.5 ]
													[ .25 rgb < .9, .9, 1 >*.35 ]
													[ .65 rgbf < 0, 0, 0, 1 > ]
													[ 1 rgbf < 0, 0, 0, 1 > ]
												}
									frequency 1
									turbulence < .01, .03, .01 >
									octaves 	9
									lambda 2
									omega 0.25
								}
					}
			}
	scale < 850, 12, 850 >
	translate < 50, 0, 50 >
}



//	//	//Area Fog
		object {
				difference {
						cylinder{
							<0, -1, 0>, <0, 1, 0>, 1
							hollow
							}
						cylinder{
							<0, -1.1, 0>, <0, 1.1, 0>, .75
							hollow
							}
				}
					pigment { rgbf < 1, 1, 1, 1 > }
		
					interior {
							media {
								absorption .0015
										intervals 10
										samples 1,  15
										confidence 0.99
										variance 1/500
										density {
											gradient y
												color_map {
															[ 0.0 rgb < .9, .9, 1 >*.5 ]
															[ .25 rgb < .9, .9, 1 >*.5 ]
															[ .65 rgbf < 0, 0, 0, 1 > ]
															[ 1 rgbf < 0, 0, 0, 1 > ]
														}
											frequency 1
											turbulence < .01, .03, .01 >
											octaves 	9
											lambda 2
											omega 0.25
										}
							}
					}
			scale < 5000, 4.5, 5000 >
			translate < 50, 0, 50 >
		}
	#break
#end
#declare CliffNormal = normal {
							wrinkles 1.3
								scale 	< 33, 100, 33 >
						turbulence .1
						octaves 10 
						lambda 1.4 
						omega 1	
					}

#declare SuperGold =texture {
							pigment { rgb < 1, 1, 0 >*1}
							finish {
									ambient 0.1
									diffuse 0.3
									specular 1
									roughness .0001
									reflection 1
									metallic .5
							}
							normal {
									ripples .7
									bump_size 3
									turbulence .35
									octaves 10 
									lambda 2 
									omega .45
							}
					}
	

#switch ( GroundSceneEqualsOn)
	#case ( 1 )
plane { y,  0.0 
			texture	{ 
				pigment { 
						rgb < .75, .87, 1 >
			}
			finish {
					ambient .4
					diffuse .6
					specular .01
					roughness .1
				
			}	
				normal {   CliffNormal }
			}
//					no_reflection

}

#switch ( MesaEqualsOn)
	#case ( 1 )
	
////////Alpha Mesa
height_field {
			png "forthf6md.png"
			translate < -.5, 0, -.5 >
			hierarchy 
			smooth 
			scale < 1200, 80, 1200 >
			texture	{ 
					pigment { rgb < .75, .87, 1 >}
					finish {
						ambient .4
						diffuse .6
						specular .01
						roughness .1
						
					}
					normal {   CliffNormal }
					}
				no_reflection
				translate < 0, 0, 5000 >
				rotate -45*y
}
////////Beta Mesa	
		
height_field {
		png "forthf6md.png"
		translate < -.5, 0, -.5 >
		hierarchy 
		smooth 
		scale < 1100, 100, 1200 >
	//	texture {ModuleColor }
		texture	{ 
				pigment { rgb < .75, .87, 1 >}
				finish {
					ambient .4
					diffuse .6
					specular .01
					roughness .1
				}
				normal {   CliffNormal }
		}
	no_reflection
	translate < 0, 0, 4000 >
	rotate -75*y
}
	
/////Rock of the Fortress
difference {
			height_field {
						png "forthf6md.png"
						translate < -.5, 0, -.5 >
						hierarchy 
						smooth 
						water_level 0.000001
						scale < 1500, 100, 1500 >
								texture	{ 
										pigment { rgb < .75, .87, 1 >}
										finish {
											ambient .4
											diffuse .6
											specular .01
											roughness .1
											
										}	
										normal {   CliffNormal }
								}
				rotate 18*y
			} 
			box {
				<-0.5, -0.5, -0.5>, <0.5, 0.5, 0.5>
				hollow
					translate < 0, 0, 0 >
					scale < 14, 18, 30 >
					scale	< 1.75, 1.75, 1.75 >
						texture	{ 
						pigment { rgb < .8, .7, .5 > 		}
						finish {
							ambient .2
							diffuse .4
							specular .01
							roughness 2
							
						}	
						normal {   CliffNormal }
						}
					translate < 0, 50, -545 >
			}


}
	#break
#end
	light_source {
		<0, 0, 0>
		rgb <1.0, 1.0, 1.0>*.1
							fade_distance 33
							fade_power 2
							shadowless
									translate < -30, 65, -600 >
	}

#declare LockPlate = difference {
			union {
					box {
						<-0.5, -0.5, -0.5>, <0.5, 0.5, 0.5>
						texture {SuperGold}
						scale < 14, 18, 1 >
					}

#declare GoldBolt =sphere {
						<0.0, 0.0, 0.0>, .65
						translate < 6, 0, -.5 >
						
						texture { SuperGold }
					}
#declare TopBolts = union {
							object { GoldBolt
								translate < -4,  8, 0 >
							}
							object { GoldBolt
								translate < -8,  8, 0 >
							}
					}
#declare SideBolts = union {
						object { GoldBolt
							translate < 0,  8, 0 >
						}
						object { GoldBolt
							translate < 0,  4.8, 0 >
						}
						object { GoldBolt
							translate < 0,  1.6, 0 >
						}
						object { GoldBolt
							translate < 0,  -1.6, 0 >
						}
						object { GoldBolt
							translate < 0,  -4.8, 0 >
						}
						object { GoldBolt
							translate < 0,  -8, 0 >
						}
					}
object { TopBolts
	translate < 0,  0, 0 >
}
object { TopBolts
	translate < 0,  -16, 0 >
}
object { SideBolts
	translate < 0,  0, 0 >
}
object { SideBolts
	translate < -12,  0, 0 >
}
}
union {
		box {
			<-0.5, -0.5, -0.5>, <0.5, 0.5, 0.5>
				scale < 2, 3, 1.5 >
				translate < 0, -3.5, 0 >
		}

prism {
		linear_spline
		linear_sweep
		-1, 	//Base height
		1.0, 	//Top height
		4,
		<-0.00000, 1.00000>,
		<-0.86603, -0.50000>,
		<0.86603, -0.50000>,
		<-0.00000, 1.00000>
		scale < 4, 1, 4 >
		rotate -90*x
}
		texture { SuperGold }
//	rotate 45*y
}
}




#declare LockAssembly =union {
object { LockPlate	
}
object { LockPlate
	rotate 180*y
	translate < 0,  0, 4 >
	
}
}



#switch ( GateEqualsOn)
	#case ( 1 )
	union {
	object { LockAssembly	
	}
	object { LockAssembly	
		scale < 1.75, 1.75, .75 >
		translate < 0, 0, .5 >
	}
		translate < 0, 50, -538 >
	}
	#break
#end

	#break
#end
#declare SpaceDensity =  density {
								gradient y
									color_map {
										[ 0.0 rgbt  < 0,  0,  0, 1> ]
										[ 1 rgbt < 0,  0,  0, 1> ]
									}
						}

 #declare none = pigment {color rgbt <1,1,1,1>}
 #declare SkyDensity = density {
							      gradient y 
									         color_map {
									
										          [ 0.0 color rgbf < .5, .35, .35, 1>]
										
										          [ 0.0175 color rgbf < .2, .1, .25, 1>]
										
										          [ 0.062 color rgbf < .01, .001, .01, 1>]
															
										          [ 0.062  color rgbf < 0, 0 , 0, 1 >]
										
										          [1.0 color rgbf < 0, 0 , 0, 1 >]
									
									        }
							turbulence  < .01, .02, .01>
							octaves 4
							lambda 2
							omega .45
					}
		
		
#switch ( EveningSkyON )
	#case ( 1 )
			difference {
						cylinder {
							<0, -.5, 0>, <0, .5, 0>, 1
							hollow
						}
						cylinder {
							<0, -.51, 0>, <0, .51, 0>, .999
							hollow
						}
					no_shadow
					no_reflection
						texture {
								pigment {rgb < 0,  0,  0 >}
						}
					scale < 6000, 1500, 6000 >
			}
			
			object { 
					sphere {
						<0.0, 0.0, 0.0>, 1
						hollow
							pigment { none }
								interior {
									media { 
										emission .005
										intervals 15
										samples 1, 15
										confidence .999
										variance 1/500
											density {
												cylindrical 
													density_map {
																[ 0 SkyDensity ]
																[ .065 SkyDensity ]
																[ .1 SpaceDensity ]
																[ 1 SpaceDensity ]
												}
											}
									 }
								}
						scale 5000
					}
				rotate 2*x
				translate < 0, -50, 0 >
			}
	#break
#end
  


#switch ( AuroraOn )
	#case ( 1 )
#declare blue_light1ColorMap =  	color_map {
											[ 0.0 rgbf <0, 0, 0, 1> ]
											[ 0.25 rgbf <0.0, 0.0, 0.0, 1.0> ]
											[ 0.3 rgbf <.15, .4, .8, 1.0> ]
											[ 0.4 rgbf <.05, .12, 0.2, 1.0> ]
											[ .7 rgbf <0, 0, 0, 1.0> ] 
											[ 0.8 rgbf <.095, .02, 0.02, 1.0> ]
											[ 1 rgbf <0, 0, 0, 1.0> ] 
								}
 #declare blue_light1DensityMap   =  density {
										      gradient y 
													color_map {
															blue_light1ColorMap
													}
												turbulence < .01, .1, .01>
									}
 #declare blue_light1WaveDensityMap   =  density {
												waves 		
														density_map {
																	[ 0		SpaceDensity  ]
																	[ 1	blue_light1DensityMap	 ]
														}
													frequency 	1 
													turbulence < .1, .01, .1 >
													scale  <  .1, 1, .1 >
										}
			
//-------//---------- Aurora Object
object {
		difference{
				cylinder {
					<0, .17, 0>, <0, 1, 0>, 1
					hollow
					}
				cylinder {
					<0, .169, 0>, <0, 1.1, 0>, .35
					hollow
					}
		}
				texture {
						pigment {	rgbf < 1, 1, 1, 1 >		}
				}
				interior {
						media {
							emission 	.04
							      intervals 15
							      samples 1, 15 
							      confidence 0.9998
							      variance 1/700
							density {
								cylindrical
									density_map {
										[ 0		blue_light1WaveDensityMap  ]
										[ .145		blue_light1WaveDensityMap  ]
										[ .145		SpaceDensity  ]
										[ 1		SpaceDensity  ]
												 	}
								frequency 	 10
							}
					}
			}
		translate < 0, -.17, 0>
		scale < 2000, 500, 4000 >
		rotate -45*y 
		translate < 750-125,  110, 250>
}
#break
#end

#switch ( SuperKeyOn)
	#case ( 1 )


#declare SuperKey = union   { 
							prism {
									linear_spline
									linear_sweep
											0.0, 	//Base height
											1.0, 	//Top height
											7,
											<1.00000, 0.00000>,
											<0.500, 1.00000>,
											<-1, 1.00000>,
											<-.5, 0>,
											<-1, -1>,
											<0.50000, -1>,
											<1.00000, 0.00000>
									translate < 0, -.5, 0 >
									rotate -90*y
									rotate 90*z
									scale < 3, 2.5, 3 >
									translate < 0, 1.25, -8.5 >
							}
							
							box {
								<-0.5, -0.5, -0.5>, <0.5, 0.5, 0.5>
									translate < 0, .5, 0 >
									scale < 3, 2.5, 20 >
							}
							box {
								<-0.5, -0.5, -0.5>, <0.5, 0.5, 0.5>
									translate < 0, -.5, 0 >
									scale < 3, 3, 1.5 >
									translate < 0, 0, 5 >
							}
							box {
								<-0.5, -0.5, -0.5>, <0.5, 0.5, 0.5>
									translate < 0, -.5, 0 >
									scale < 3, 2, 1.5 >
									translate < 0, 0, 7.5 >
							}
							box {
								<-0.5, -0.5, -0.5>, <0.5, 0.5, 0.5>
									translate < 0, -.5, 0 >
									scale < 3, 2, 1.5 >
									translate < 0, 0, 2.5 >
							}
							prism {
									linear_spline
									conic_sweep
											0, 	//Base height
											1, 	//Top height
											4,
											<0, 1.00000>,
											<-1.00000, 0.0>,
											<1, 0.0>,
											<0, 1.00000>
								scale < 4,  4, 4 >
								rotate 180*z
								translate < 0, 4, 10 >
							}
	texture { SuperGold scale 20}

}

object { SuperKey 
	rotate -.5*x
	translate < 100, 2.9, -1000 >
}
	light_source {
		<0, 0, 0>
		rgb <1.0, 1.0, 1.0>*.3
		fade_distance 15
		fade_power 2
			shadowless
		translate < 115, 5, -1000 >
	}
#break
#end

#switch ( SuperStreakOn)
	#case ( 1 )
#declare SuperNoseBlue = density {
								 gradient y 
											color_map {
												[ 0.0 rgbf <.01, .01, 1, 1> ]
												[ 0.3 rgbf <.01, .01, 1, 1> ]
												[ .3 rgbf <0, 0, 0, 1> ]
												[ 1 rgbf <0, 0, 0, 1> ]
											}
									turbulence  < .01, 0, .01 >
									octaves 2
									lambda 2
									omega .3
									translate < 0, .3, 0 >
						}
#declare SuperBlue = density {
							 gradient y 
										color_map {
											[ 0.0 rgbf < .01, .01, .5, 1> ]
											[ 0.13rgbf < .8, .3, 1, 1> ]
											[ .2 rgbf <.01, .01, 0.1, 1> ]
											[ 1 rgbf <0, 0, 0, 1> ]
										}
								turbulence  < .5, .7, .5 >
								octaves 2
								lambda 2
								omega .3
								translate < 0, .2, 0 >
					}
 #declare SuperRed = density {
							 gradient y 
								color_map {
									[ 0.0 rgbf <.5, .01, .01, 1> ]
									[ 0.13rgbf < 1, .3, .8, 1> ]
									[ .2 rgbf <.01, .01, 0.1, 1> ]
									[ 1 rgbf < 0, 0, 0, 1> ]
								}
								turbulence  < .3, .7, .3 >
								octaves 2
								lambda 2
								omega .3
								translate < 0, .2, 0 >
								rotate 20*y
					}
//------//---------------	SuperBlur
		merge {
				sphere {
						<0.0, 0.0, 0.0>, 0.5
								clipped_by {
											box {<-0.5,  -.51, -0.5>, <0.5, 0, 0.5>}
								}
							translate < 0, .5, 0 >
							scale < 1, .1, 1 >
				}
			
				cylinder {
					<0, .04999, 0>, <0, .4, 0>, .5
				}
				cone {
					<0, .399, 0>, .5, <0, .85, 0>, 0
				}
				hollow
		
					pigment { rgbf < 1, 1, 1, .8 > }
					interior {
						media { 
						emission .8
						
						intervals 20
						
						samples 1, 10
						
						confidence 0.999
						
						variance 1/1000
						density {
						cylindrical
								density_map {
												[ 0 SuperRed]
												[ .2 SuperRed]
												[ .3 SuperBlue]
												[ 1 SuperBlue]
								}
						}
						scale < 1, .8, 1 >
						 }
					}
					scale  < 6, 380, 6 >
					translate  < 0, -190, 0 >
					rotate 180*x
					translate  < 0, 190, 0 >
					rotate -85*x
	translate < 0, 50+4-4, -600 >

		}

	#break
#end







///////////

