#include "colors.inc"
#include "skies.inc"
//making necessary textures
#declare T_Steel = texture {
  pigment {
    bozo
    color_map {
      [0.0 rgb <0.39, 0.41, 0.43> ]
      [0.25 Orange * .5 ]
      [0.5 rgb <0.39, 0.41, 0.43> ]
      [0.75 Orange * .5 ]
      [1.0 rgb <0.39, 0.41, 0.43> ]
    }
    turbulence .7
    scale .5
  }
  finish { ambient 0 diffuse .7 }
  normal { bumps .3 scale .1 }
}
#declare NoLichen = texture {
  pigment {
    granite
    color_map {
      [0.25 rgb <0.690, 0.690, 0.621> ]
      [0.75 rgb <0.850, 0.850, 0.850> ]
    }
    scale 1
  }
  finish { ambient 0.05 }
  normal { granite 0.75 scale 0.090 }
}
#declare LightLichen =
texture { NoLichen }
texture {
  pigment {
    granite
    color_map {
      [0.0 Clear ]
      [0.5 Clear ]
      [0.51 rgbf <.5, .8, .5, .90> ]
      [0.54 rgbf <.4, .7, .4, .83> ]
      [0.55 rgbf <.3, .6, .3, .60> ]
      [0.56 rgbf <.4, .7, .4, .83> ]
      [0.59 rgbf <.5, .8, .5, .90> ]
      [0.6 Clear ]
      [1.0 Clear ]
    }
    scale 0.075
  }
  finish { ambient 0 }
  normal { granite 0.75 scale 0.090 }
}
#declare HeavyLichen =
texture { NoLichen }
texture {
  pigment {
    granite
    color_map {
      [0.0 Clear ]
      [0.2 Clear ]
      [0.21 rgbf <.5, .8, .5, .90> ]
      [0.24 rgbf <.4, .7, .4, .83> ]
      [0.25 rgbf <.3, .6, .3, .60> ]
      [0.26 rgbf <.4, .7, .4, .83> ]
      [0.29 rgbf <.5, .8, .5, .90> ]
      [0.3 Clear ]
      [0.5 Clear ]
      [0.51 rgbf <.5, .8, .5, .90> ]
      [0.54 rgbf <.4, .7, .4, .83> ]
      [0.55 rgbf <.3, .6, .3, .60> ]
      [0.56 rgbf <.4, .7, .4, .83> ]
      [0.59 rgbf <.5, .8, .5, .90> ]
      [0.6 Clear ]
      [0.8 Clear ]
      [0.81 rgbf <.5, .8, .5, .90> ]
      [0.84 rgbf <.4, .7, .4, .83> ]
      [0.85 rgbf <.3, .6, .3, .60> ]
      [0.86 rgbf <.4, .7, .4, .83> ]
      [0.89 rgbf <.5, .8, .5, .90> ]
      [0.9 Clear ]
      [1.0 Clear ]
    }
    scale 0.075
  }
  finish { ambient 0 }
  normal { granite 0.75 scale 0.090 }
}
#declare OldOak =
texture {
  pigment{
    wood
    color_map {
      [0.00 color rgb < 0.404, 0.275, 0.187> ]
      [0.25 color rgb < 0.431, 0.294, 0.204> ]
      [0.40 color rgb < 0.447, 0.304, 0.209> ]
      [0.50 color rgb < 0.404, 0.275, 0.185> ]
      [0.70 color rgb < 0.459, 0.301, 0.221> ]
      [0.98 color rgb < 0.431, 0.294, 0.201> ]
      [1.00 color rgb < 0.404, 0.275, 0.187> ]
    }
    scale <0.20 0.20 1>
    turbulence 0.04
    rotate <-2, 2, 0>
  }
  finish { ambient 0.05 }
} 
//constucting parts of the outpost
#declare Stone = superellipsoid {
  <.3, .3>
  scale <2, 1, 1>
  translate <0, 1, -15>
}
#declare HalfStone = superellipsoid {
  <.3, .3>
  translate <0, 1, -15>
}
#declare Ring = union {
  object { Stone }
  object { Stone rotate y*15 }
  object { Stone rotate y*30 }
  object { Stone rotate y*45 }
  object { Stone rotate y*60 }
  object { Stone rotate y*75 }
  object { Stone rotate y*90 }
  object { Stone rotate y*105 }
  object { Stone rotate y*120 }
  object { Stone rotate y*135 }
  object { Stone rotate y*150 }
  object { Stone rotate y*165 }
  object { Stone rotate y*180 }
  object { Stone rotate y*195 }
  object { Stone rotate y*210 }
  object { Stone rotate y*225 }
  object { Stone rotate y*240 }
  object { Stone rotate y*255 }
  object { Stone rotate y*270 }
  object { Stone rotate y*285 }
  object { Stone rotate y*300 }
  object { Stone rotate y*315 }
  object { Stone rotate y*330 }
  object { Stone rotate y*345 }
}
#declare Ring1_3 = union {
  object { Stone rotate y*15 }
  object { Stone rotate y*30 }
  object { Stone rotate y*45 }
  object { Stone rotate y*60 }
  object { Stone rotate y*75 }
  object { Stone rotate y*90 }
  object { Stone rotate y*105 }
  object { Stone rotate y*120 }
  object { Stone rotate y*135 }
  object { Stone rotate y*150 }
  object { Stone rotate y*165 }
  object { Stone rotate y*180 }
  object { Stone rotate y*195 }
  object { Stone rotate y*210 }
  object { Stone rotate y*225 }
  object { Stone rotate y*240 }
  object { Stone rotate y*255 }
  object { Stone rotate y*270 }
  object { Stone rotate y*285 }
  object { Stone rotate y*300 }
  object { Stone rotate y*315 }
  object { Stone rotate y*330 }
  object { Stone rotate y*345 }
}
#declare Ring2 = union {
  object { HalfStone texture { HeavyLichen scale 10 } rotate y*4 }
  object { Stone rotate y*15 texture { LightLichen scale 10 }}
  object { Stone rotate y*30 texture { LightLichen scale 10 }}
  object { Stone rotate y*45 texture { HeavyLichen scale 10 }}
  object { Stone rotate y*60 texture { LightLichen scale 10 }}
  object { Stone rotate y*75 texture { LightLichen scale 10 }}
  object { Stone rotate y*90 texture { HeavyLichen scale 10 }}
  object { Stone rotate y*105 texture { LightLichen scale 10 }}
  object { Stone rotate y*120 texture { LightLichen scale 10 }}
  object { Stone rotate y*135 texture { HeavyLichen scale 10 }}
  object { Stone rotate y*150 texture { LightLichen scale 10 }}
  object { Stone rotate y*165 texture { LightLichen scale 10 }}
  object { Stone rotate y*180 texture { HeavyLichen scale 10 }}
  object { Stone rotate y*195 texture { LightLichen scale 10 }}
  object { Stone rotate y*210 texture { LightLichen scale 10 }}
  object { Stone rotate y*225 texture { HeavyLichen scale 10 }}
  object { Stone rotate y*240 texture { LightLichen scale 10 }}
  object { Stone rotate y*255 texture { LightLichen scale 10 }}
  object { Stone rotate y*270 texture { HeavyLichen scale 10 }}
  object { Stone rotate y*285 texture { LightLichen scale 10 }}
  object { Stone rotate y*300 texture { LightLichen scale 10 }}
  object { Stone rotate y*315 texture { HeavyLichen scale 10 }}
  object { Stone rotate y*330 texture { LightLichen scale 10 }}
  object { HalfStone texture { LightLichen scale 10 } rotate y*341.0 }
}
#declare Ring4 = union {
  object { Stone texture { LightLichen scale 10 }}
  object { Stone rotate y*15 texture { NoLichen scale 10 }}
  object { Stone rotate y*30 texture { LightLichen scale 10 }}
  object { Stone rotate y*45 texture { NoLichen scale 10 }}
  object { Stone rotate y*60 texture { LightLichen scale 10 }}
  object { Stone rotate y*75 texture { NoLichen scale 10 }}
  object { Stone rotate y*90 texture { LightLichen scale 10 }}
  object { Stone rotate y*105 texture { NoLichen scale 10 }}
  object { Stone rotate y*120 texture { LightLichen scale 10 }}
  object { Stone rotate y*135 texture { NoLichen scale 10 }}
  object { Stone rotate y*150 texture { LightLichen scale 10 }}
  object { Stone rotate y*165 texture { NoLichen scale 10 }}
  object { Stone rotate y*180 texture { LightLichen scale 10 }}
  object { Stone rotate y*195 texture { NoLichen scale 10 }}
  object { Stone rotate y*210 texture { LightLichen scale 10 }}
  object { Stone rotate y*225 texture { NoLichen scale 10 }}
  object { Stone rotate y*240 texture { LightLichen scale 10 }}
  object { Stone rotate y*255 texture { NoLichen scale 10 }}
  object { Stone rotate y*270 texture { LightLichen scale 10 }}
  object { Stone rotate y*285 texture { NoLichen scale 10 }}
  object { Stone rotate y*300 texture { LightLichen scale 10 }}
  object { Stone rotate y*315 texture { NoLichen scale 10 }}
  object { Stone rotate y*330 texture { LightLichen scale 10 }}
  object { Stone rotate y*345 texture { NoLichen scale 10 }}
}
#declare WindowRing = union {
  object { Stone rotate y*15 }
  object { Stone rotate y*30 }
  object { Stone rotate y*45 }
  object { Stone rotate y*75 }
  object { Stone rotate y*90 }
  object { Stone rotate y*105 }
  object { Stone rotate y*135 }
  object { Stone rotate y*150 }
  object { Stone rotate y*165 }
  object { Stone rotate y*195 }
  object { Stone rotate y*210 }
  object { Stone rotate y*225 }
  object { Stone rotate y*255 }
  object { Stone rotate y*270 }
  object { Stone rotate y*285 }
  object { Stone rotate y*315 }
  object { Stone rotate y*330 }
  object { Stone rotate y*345 }
}
#declare OffsetWindowRing = union {
  object { Stone }
  object { Stone rotate y*15 }
  object { Stone rotate y*45 }
  object { Stone rotate y*60 }
  object { Stone rotate y*75 }
  object { Stone rotate y*105 }
  object { Stone rotate y*120 }
  object { Stone rotate y*135 }
  object { Stone rotate y*165 }
  object { Stone rotate y*180 }
  object { Stone rotate y*195 }
  object { Stone rotate y*225 }
  object { Stone rotate y*240 }
  object { Stone rotate y*255 }
  object { Stone rotate y*285 }
  object { Stone rotate y*300 }
  object { Stone rotate y*315 }
  object { Stone rotate y*345 }
}
#declare FirstFloor = union {
  union {
    object { Ring1_3 texture { HeavyLichen scale 10 }}
    object { Ring2 rotate y*7.5 translate y*2 }
    object { Ring1_3 texture { LightLichen scale 10 } translate y*4 }
    object { Ring4 rotate y*7.5 translate y*6 }
  }
  //door frame
  union {
    box { <-2.5, 0, -15.5>, <-1.75, 6.5, -14.5> }
    box { <1.75, 0, -15.5>, <2.5, 6.5, -14.5> }
    texture { OldOak rotate x*90 }
  }
  box { <-1.75, 5.5, -15.5>, <1.75, 6.5, -14.5> texture { OldOak rotate y*90 }}
  //door
  union {
    box { <-3.4, .1, -.4>, <-2.75, 5.4, .4> texture { OldOak rotate <90, 0, 7> }}
    box { <-2.69, .1, -.4>, <-2.07, 5.4, .4> texture { OldOak rotate <90, 0, -9> }}
    box { <-2, .1, -.4>, <-1.39, 5.4, .4> texture { OldOak rotate <90, 0, 0> }}
    box { <-1.33, .1, -.4>, <-.71, 5.4, .4> texture { OldOak rotate <90, 0, -12> }}
    box { <-.65, .1, -.4>, <0, 5.4, .4> texture { OldOak rotate <90, 0, 9> }}
    box { <-3.4, 1.8, -.45>, <0, 2.3, -.35> texture { T_Steel }}
    box { <-3.4, 3.1, -.45>, <0, 3.6, -.35> texture { T_Steel }}
    rotate y*20
    translate <1.75, 0, -15>
  }
}
#declare EvenFloor = union {
  cylinder { <0, 0, 0>, <0, .5, 0>, 15 texture { OldOak } }
  object { Ring }
  object { Ring translate y*2 rotate y*7.5 }
  object { OffsetWindowRing translate y*4 }
  object { Ring translate y*6 rotate y*7.5 }
  texture { NoLichen scale 10 }
}
#declare OddFloor = union {
  cylinder { <0, 0, 0>, <0, .5, 0>, 15 texture { OldOak } }
  object { Ring }
  object { Ring translate y*2 rotate y*7.5 }
  object { WindowRing translate y*4 }
  object { Ring translate y*6 rotate y*7.5 }
  texture { NoLichen scale 10 }
}
#declare TopFloor = union {
  cylinder { <0, 0, 0>, <0, .5, 0>, 15 texture { OldOak } }
  object { Ring }
  //second ring
  object { Stone rotate y*7.5 translate y*2 }
  object { Stone rotate y*52.5 translate y*2 }
  object { Stone rotate y*67.5 translate y*2 }
  object { Stone rotate y*112.5 translate y*2 }
  object { Stone rotate y*127.5 translate y*2 }
  object { Stone rotate y*172.5 translate y*2 }
  object { Stone rotate y*187.5 translate y*2 }
  object { Stone rotate y*232.5 translate y*2 }
  object { Stone rotate y*247.5 translate y*2 }
  object { Stone rotate y*292.5 translate y*2 }
  object { Stone rotate y*307.5 translate y*2 }
  object { Stone rotate y*352.5 translate y*2 }
  //third ring
  object { Stone translate y*4 }
  object { HalfStone rotate y*11 translate y*4 }
  object { HalfStone rotate y*49 translate y*4 }
  object { Stone rotate y*60 translate y*4 }
  object { HalfStone rotate y*71 translate y*4 }
  object { HalfStone rotate y*109 translate y*4 }
  object { Stone rotate y*120 translate y*4 }
  object { HalfStone rotate y*131 translate y*4 }
  object { HalfStone rotate y*169 translate y*4 }
  object { Stone rotate y*180 translate y*4 }
  object { HalfStone rotate y*191 translate y*4 }
  object { HalfStone rotate y*229 translate y*4 }
  object { Stone rotate y*240 translate y*4 }
  object { HalfStone rotate y*251 translate y*4 }
  object { HalfStone rotate y*289 translate y*4 }
  object { Stone rotate y*300 translate y*4 }
  object { HalfStone rotate y*311 translate y*4 }
  object { HalfStone rotate y*349 translate y*4 }
  texture { NoLichen scale 10 }
}
#declare Layer = union {
  object { Stone translate <-4, 0, 15> }
  object { Stone translate <0, 0, 15> }
  object { Stone translate <4, 0, 15> }
}
#declare Walkway = union {
  object { Layer translate <21, 0, 3> texture{ HeavyLichen scale 10 }}
  object { Layer translate <19, 0, -3> texture{ HeavyLichen scale 10 }}
  object { Layer translate <19, 2, 3> texture{ LightLichen scale 10 }}
  object { Layer translate <21, 2, -3> texture{ LightLichen scale 10 }}
  object { Layer translate <21, 4, 3> texture{ LightLichen scale 10 }}
  object { Layer translate <19, 4, -3> texture{ LightLichen scale 10 }}
  object { Layer translate <19, 6, 3> }
  object { Layer translate <21, 6, -3> }
  object { Layer translate <21, 8, 3> }
  object { Layer translate <19, 8, -3> }
  object { Layer translate <19, 10, 3> }
  object { Layer translate <21, 10, -3> }
  object { Layer translate <21, 12, 3> }
  object { Layer translate <19, 12, -3> }
  object { Layer translate <19, 14, 3> }
  object { Layer translate <21, 14, -3> }
  object { Layer translate <21, 16, 3> }
  object { Layer translate <19, 16, -3> }
  object { Layer translate <19, 18, 3> }
  object { Layer translate <21, 18, -3> }
  object { Layer translate <21, 20, 3> }
  object { Layer translate <19, 20, -3> }
  object { Layer translate <19, 22, 3> }
  object { Layer translate <21, 22, -3> }
  intersection {
    union {
      object { Layer translate <21, 24, 3> }
      object { Layer translate <21, 24, -1> }
      object { Layer translate <21, 26, -3> }
      object { Layer translate <21, 28, 3> }
    }
    box { <12, 23, -5>, <25, 30, 5> }
  }
  object { Layer translate <19, 24, 1> }
  object { Layer translate <19, 24, -3> }
  object { Layer translate <19, 26, 3> }
  object { Layer translate <19, 28, -3> }
  texture { NoLichen scale 10 }
}
#declare MainTower = union {
  object { FirstFloor }
  object { EvenFloor translate y*8 }
  object { OddFloor translate y*16 }
  object { EvenFloor translate y*24 }
  object { OddFloor translate y*32 }
  object { TopFloor translate y*40 }
}
#declare SideTower = union {
  object { Walkway }
  object { Ring translate <40, 0, 0> texture { HeavyLichen scale 10 }}
  object { Ring rotate y*7.5 translate <40, 2, 0> texture { LightLichen scale 10 }}
  object { OffsetWindowRing translate <40, 4, 0> texture { LightLichen scale 10 }}
  object { Ring rotate y*7.5 translate <40, 6, 0> texture { NoLichen scale 10 }}
  object { OddFloor translate <40, 8, 0> }
  object { EvenFloor translate <40, 16, 0> }
  object { TopFloor translate <40, 24, 0> }
}
//the actual outpost
union {
  object { MainTower }
  object { SideTower }
  object { SideTower rotate y*180 }
  translate y*1.5
}
//a void-like filling to keep the sky from showing through the windows
union {
  cylinder { <0, 0, 0>, <0, 40, 0>, 13 }
  cylinder { <-40, 0, 0>, <-40, 24, 0>, 13 }
  cylinder { <40, 0, 0>, <40, 24, 0>, 13 }
  pigment { Black }
  finish { ambient 0 }
}
//the hillside
height_field {
  tga "hillside.tga"
  smooth
  scale <300, 50, 300>
  translate <-150, 0, -150>
  pigment {
    wrinkles
    turbulence 0.3
    scale 0.2
    color_map {
      [0.0 rgb <0.45, 0.29, 0.12> ]
      [0.2 rgb <0.45, 0.29, 0.12> ]
      [0.4 rgb <0.29, 0.45, 0.12> ]
      [0.6 rgb <0.29, 0.45, 0.12> ]
      [0.8 rgb <0.45, 0.29, 0.12> ]
      [1.0 rgb <0.45, 0.29, 0.12> ]
    }
  }
  finish { ambient 0.05 }
  normal { bumps 1 scale .02 }
}
//dirt mounds
height_field {
  tga "dirt.tga"
  smooth
  scale <130, 20, 130>
  translate <-65, -.1, -56>
  pigment {
    gradient y
    pigment_map {
      [0.010
        wrinkles
        turbulence 0.3
        scale 0.01
        color_map {
          [0.0 rgb <0.45, 0.29, 0.12> ]
          [0.2 rgb <0.45, 0.29, 0.12> ]
          [0.4 rgb <0.29, 0.45, 0.12> ]
          [0.6 rgb <0.29, 0.45, 0.12> ]
          [0.8 rgb <0.45, 0.29, 0.12> ]
          [1.0 rgb <0.45, 0.29, 0.12> ]
        }]
      [0.095
        wrinkles
        turbulence 0.1
        scale 0.025
        color_map {
          [0.0 rgb <.60, .35, .27> ]
          [0.3 rgb <.60, .35, .27>*.7 ]
          [0.5 rgb <.60, .35, .27>*.5 ]
          [0.8 rgb <.60, .35, .27>*.9 ]
          [1.0 rgb <.60, .35, .27> ]
        }]
    }
    scale 20
  }
  finish { ambient 0.05 }
  normal { bumps 1 scale .02 }
}

plane { <.05, 1, .05>, 140
  texture { T_Cloud3 scale 100 }
}

sky_sphere {
  pigment { 
    gradient y
    color_map {
      [0 rgb <.16, .48, .64>*.5 ]
      [1 rgb <.16, .48, .64> ]
    }
  }
}
//Birch Trees
object {
  #include "defaults.inc"
  #declare BaseLen = .4;
  #declare LengthInc = 3;
  #declare MaxXDeg = 50;
  #declare MaxZDeg = 15;
  #declare IncXDeg = 5;
  #declare IncSplits = 1.1;
  #declare PlusMinus = 15;
  #declare LeafNum = 3;
  #declare LeafTexture = 1;
  #declare Leaves = texture {
    pigment {
      crackle
      color_map {
        [0.0 Green*.7]
        [0.2 Green*.5]
        [0.3 Green]
        [0.4 Green*.7]
        [0.8 Green*.8]
      }
      scale <.3, .1, .3>
    }
    finish { ambient .2 phong .4 phong_size 50 }
    normal { wrinkles .2 scale .05 }
  }
  #declare LeafShape = 3;
  #declare SD1 = seed(12);
  #declare BarkTexture = 2;
  #include "trees.inc"
  rotate y*35
  translate <-52, 0, -56>
}
object {
  #include "trees.inc"
  translate <-50, 0, -25>
}
object {
  #declare BaseLen = .3
  #include "trees.inc"
  translate <-35, 0, -28>
}
//Bushes
object {
  #include "defaults.inc"
  #declare BaseLen = .3;
  #declare LengthInc = .6;
  #declare PlusMinus = -55;
  #declare MinSplits = 2;
  #declare MaxSplits = 3;
  #declare IncSplits = 1.35;
  #declare LeafNum = 6;
  #declare LeafShape = 2;
  #declare LeafRandRot = True;
  #declare BallJoint = False;
  #declare LeafTexture = 1;
  #declare Leaves = texture {
    pigment {
      wrinkles
      color_map {
        [0.0 rgb <0.29, 0.45, 0.12>*1.4]
        [0.4 rgb <0.29, 0.45, 0.12>]
        [0.8 rgb <0.29, 0.45, 0.12>*1.2]
      }
      turbulence .2
      scale .2
    }
    finish { ambient .2 phong .4 phong_size 50 }
  }
  #declare BarkTexture = 1;
  #declare Bark = texture {
    pigment {
      crackle
      color_map {
        [0.0 rgb <.84, .74, .84> ]
        [0.2 rgb <.62, .55, .57> ]
        [0.25 rgb <.62, .55, .57> ]
        [0.6 rgb <.84, .74, .84> ]
      }
      turbulence .2
      scale <.25, .05,  .5>
    }
    finish { ambient .05 }
  }
  #include "trees.inc"
  translate <-64.45, 8.2, -57.5>
}
object {
  #include "trees.inc"
  translate <-62, 8.5, -60.2>
}
object {
  #declare BaseLen = .5;
  #include "trees.inc"
  translate <-40, -1.2, -39>
}
object {
  #declare BaseLen = .5;
  #include "trees.inc"
  translate <-36, -2, -31>
}
object {
  #declare BaseLen = .5;
  #include "trees.inc"
  translate <-24, -1.2, -39.5>
}

camera {
  location <-65, 10, -60>
  look_at <0, 12, 0>
}

light_source {
  <-80, 140, -70>
  color White
  area_light
  <2.83, 0, 2.83>, <0, 4, 0>, 3, 3
  adaptive 2
  jitter
}
