// Persistence of Vision Ray Tracer Scene Description File
// File: tmfort.pov
// Vers: 3.1g.wmp.0.6a
// Desc: Fortress entry for IRTC
// Date: ??/04/01
// Auth: Tom Melly, http://www.tomandlu.co.uk, tom@tomandlu.co.uk
//
// fort is 30 long, 1 mile = 50 units
// basin is 2000 units across = 40 miles
// mounts are 150 units high = 3miles // currently 5 miles approx.


#version unofficial MegaPov 0.6;
#include "colors.inc"
#include "metals.inc"

#declare myScale = 1000;

#declare doRadiosity = false;
#if(doRadiosity)
global_settings{
  motion_blur 20, 1/4
  max_trace_level 10
  ambient_light 0
  assumed_gamma 1.0
  ini_option "+qr"
  radiosity{
    pretrace_start 0.08
    pretrace_end 0.02
    count 50 // 50 // 100
    nearest_count 5
    recursion_limit 4 
    error_bound 1
    low_error_factor .5  // leave this
    gray_threshold 0.0   // leave this
    minimum_reuse 0.015  // leave this
    brightness 1         // leave this

  }
}
#else
  global_settings{motion_blur 20, 1/4}
  light_source{<0,0,0> color rgb<1,1,1> translate <-3000, 3500, -3000>*myScale}
#end

light_source{<0,0,0> color rgb<1,1,1> translate <-3000, 1500, -3000>*myScale}

camera{location  <0, 20*myScale, 0> sky<2.5*myScale,20*myScale,0> look_at<0, 19, 10>*myScale}

sky_sphere{
  pigment{
    wrinkles turbulence 0.5 scale 0.075 
    pigment_map{
      [0.5 rgb<0.25,0.25,0.75>][1.00 rgb 1]
    }
  }
}

fog {
  distance 1000*myScale
  fog_type 2
  color rgbt 0.75
  fog_offset 0
  fog_alt 300*myScale
}

#include "landscap.inc"
object{MBase scale myScale}

#include "fortress.inc"
object{FullFort rotate y*55 translate <17,12,60> scale myScale}

#declare doFig = true;
#if(doFig)

//  #include "sman_g.inc"
  #include "cape.inc"
  
motion_blur{
  union{
//    object{
//      P_Figure_1
//      scale 2
//      rotate<0,20,-28>
//      translate<-0.52, -1.06, -0.63>
//    }
    object{
      cape
      pigment{Red}
      pigment{object{cape_logo rgb<1,1,0.5> Red}}
  
      scale 1/10
      rotate<0,180,-20>//-35>
    }
    translate <-0.00087,19.99950,0.00360>*myScale
    translate x*clock/4 translate z*clock
  }
}
#end


