#version unofficial MegaPov 0.7;         

#include "macros.inc"     
#include "wasp2.inc"   
#include "winegla.inc"
#include "table.inc"
                     
global_settings 
{
   motion_blur 15,15
//   motion_blur 2,15
   max_trace_level 15                   
//   max_trace_level 2
   photons
   {
      count 450000
 //    count 0
//      spacing 0.05       
      max_trace_level 15
      autostop 0
      gather 20,100
      jitter .4
   }
}                   

#declare waspNotFlying=
union
{
   object{waspBody}
   object{waspWingL}
   object{waspWingR}    
   rotate <90,0,0>
   rotate <0,180,0>
   rotate <-20,0,0>   
   scale 1/800
}                 

#declare waspFlying=
union
{
   object{waspBody}
   motion_blur
   {
      object
      {
         waspWingR
         rotate <0,16+sin(0.375*3.1415+0.25*3.1415*clock)*26,0>
      }
   }
   motion_blur
   {
      object
      {
         waspWingR
         rotate <0,16+sin(0.125*3.1415+0.25*3.1415*clock)*26,0>
      }
   }
   motion_blur
   {
      object
      {
         waspWingR
         rotate <0,16+sin(-0.125*3.1415+0.25*3.1415*clock)*26,0>
      }
   }
   motion_blur
   {
      object
      {
         waspWingR
         rotate <0,16+sin(-0.375*3.1415+0.25*3.1415*clock)*26,0>
      }
   }

   motion_blur
   {
      object
      {
         waspWingL
         rotate <0,-16-sin(0.375*3.1415+0.25*3.1415*clock)*26,0>
      }
   }
   motion_blur
   {
      object
      {
         waspWingL
         rotate <0,-16-sin(0.125*3.1415+0.25*3.1415*clock)*26,0>
      }
   }
   motion_blur
   {
      object
      {
         waspWingL
         rotate <0,-16-sin(-0.125*3.1415+0.25*3.1415*clock)*26,0>
      }
   }
   motion_blur
   {
      object
      {
         waspWingL
         rotate <0,-16-sin(-0.375*3.1415+0.25*3.1415*clock)*26,0>    
         #debug str(clock,0,2)
      }    
   }          
      rotate <90,0,0>
   rotate <0,180,0>
   rotate <-20,0,0>   
   scale 1/800
}  

#declare matLiquid = 
material
{
   texture 
   {
      pigment 
      { 
         rgbf < 1.01, 0.9,0.9, 0.945>
      }
      finish 
      {                           
         ambient 0.04
         reflection 0.03
         specular 0
         roughness .0001
      }
   }
   interior
   {  
      ior 1.1
      fade_distance 0.5
      fade_power 1.5
   }
}

                     
#declare matGlas = 
material
{
   texture 
   {
      pigment 
      { 
         rgbf < 0.95, 0.95, 0.95, 0.975> 
   //     rgb<1,1,1>
      }
      finish 
      {
         reflection .025
         specular 1.5
         roughness .00008
  
      }
   }
   interior
   {
      ior 1.17  
   }  
}

#declare oGlas = 
merge
{     
   #declare rDown = 1.14;                        
   #declare rUp = 1.4;
   #declare glasDikte = 0.12;              
   #declare glasHoogte = 4.5; //minus straal afronding aan de onderzijde
   #declare rAfronding = 0.2;                     
   #declare extraBodem = 0.1; 
   #declare extraLiquid = 1;
                                  
   difference
   {
      cone
      {
         <0,0,0>,rDown,<0,glasHoogte,0>,rUp 
      }
      cone
      {
         <0,-0.0001,0>,rDown - glasDikte,<0,glasHoogte + 0.00001,0>,rUp - glasDikte 
      }
   }            
   torus
   {
      rUp - glasDikte/2,glasDikte / 2
      translate <0,glasHoogte,0>
   }           
   torus
   {
      rDown-rAfronding,rAfronding
   }       
   cone
   {
      <0,-rAfronding,0>,rDown-rAfronding, <0,rAfronding + extraBodem,0>,rDown+(rAfronding+extraBodem)*(rUp-rDown)/glasHoogte    
   }        
}            


#declare tBubble =
      texture
      {
         pigment
         {
            color rgb <1,1,1>
    //        rgbf < 1.01, 0.92,0.92, 0.95>
         }
         finish
         {    
            reflection .08
            phong 0.6
            phong_size 400
         }
      }


#declare oLiquid =
merge
{
   difference
   {
      cone
      {
         <0,rAfronding + extraBodem,0>,rDown+(rAfronding+extraBodem)*(rUp-rDown)/glasHoogte-glasDikte,<0,rAfronding + extraBodem + extraLiquid,0>,rDown+(rAfronding+extraBodem+extraLiquid)*(rUp-rDown)/glasHoogte-glasDikte
      }              
   
      #declare bubbleRadiusMin = 0.007;
      #declare bubbleRadiusMax = 0.0115;
      
      #declare bubbleRadius = seed(134);
      #declare bubbleHeight = seed(424);
      #declare bubbleDirection = seed(244);
      
      #declare bubbleCounter = 0;
      #while (bubbleCounter < 260)
         sphere
         {                                    
            #declare randBubbleHeight = rand(bubbleHeight);
            <0,rAfronding + extraBodem + randBubbleHeight*extraLiquid,0>,rand(bubbleRadius)*(bubbleRadiusMax - bubbleRadiusMin) + bubbleRadiusMin
            texture{tBubble}   
            translate<0,0,(-1)*(rDown+(rAfronding + extraBodem + randBubbleHeight*extraLiquid)*(rUp-rDown)/glasHoogte-glasDikte)>
            rotate <0,rand(bubbleDirection) * 360,0>
         }
      #declare bubbleCounter = bubbleCounter + 1;
      #end
   }

   difference
   {                                             
      #declare meniscusHeight = 0.12;
      cone
      {
         <0,rAfronding + extraBodem + extraLiquid + meniscusHeight,0>,rDown+(rAfronding+extraBodem+extraLiquid+meniscusHeight)*(rUp-rDown)/glasHoogte-glasDikte,<0,rAfronding + extraBodem + extraLiquid-0.001,0>,rDown+(rAfronding+extraBodem+extraLiquid-0.001)*(rUp-rDown)/glasHoogte-glasDikte
      }    
      torus
      {
         rDown+(rAfronding+extraBodem+extraLiquid+meniscusHeight)*(rUp-rDown)/glasHoogte-glasDikte -meniscusHeight , meniscusHeight
         translate <0,rAfronding + extraBodem + extraLiquid + meniscusHeight,0>
      }
      cylinder
      {       
         <0,rAfronding + extraBodem + extraLiquid + meniscusHeight + 0.001,0>,<0,rAfronding + extraBodem + extraLiquid -0.001,0>,rDown+(rAfronding+extraBodem+extraLiquid+meniscusHeight)*(rUp-rDown)/glasHoogte-glasDikte -meniscusHeight
         
      }         
   }
} 

#declare grass=
plane
{
   <0,1,0>,-rAfronding-0.001-tafelBladDikte-tafelBladStraal*1.8
   texture
   {
     pigment 
     {        
         bozo
         turbulence 0.3
         color_map
         {
            [0 color rgb<0,0.4,0.2>]
            [1 color rgb<0.1,0.3,0.14>]
         }         
     }
     finish
     {                 
         diffuse 0.6
         ambient 1.2
     }               
     normal
     {
         granite 3
         scale 6
     }
  }         
  texture
  {
      pigment
      {        
         bozo
         turbulence 0.45
         color_map
         {
            [0 color rgbf<0,0.15,0,0.55>]
            [0.5 color rgbf<0,0.2,0,0.7>]
            [1 color Clear]
         }                 
         scale 75
      }
      finish
      {
         ambient 0.5
      }
  }  
} 

#declare oViltje=
mCylinderRounded(0.04, 2.35, 0.01) 


#declare tViltje=
texture
{
   pigment
   {
      image_map
      {
        sys "povvilt.bmp" // the file to read (iff/gif/tga/png/sys)
        map_type 0 // 0=planar, 1=spherical, 2=cylindrical, 5=torus
        interpolate 2 // 0=none, 1=linear, 2=bilinear, 4=normalized distance
        // [filter N V] // N=all or color index # (0...N), V= value (0.0...1.0)
        // [transmit N V] // N=all or color index # (0...N), V= value (0.0...1.0)
        // [use_color | use_index]
        // [once]
      } // image_map
   }
   finish
   {
      reflection 0
      diffuse .7 
      ambient 0.4
      phong 0
   }
   normal
   {    
      // texture pigment/normal pattern
// create a wrinkly surface (0...1 or more)
   wrinkles 0.6                
   turbulence 5      
      scale <0.06,0.06,0.08>

   }              
   translate<0.5,0.5,0.5>
   scale 2.35*2          
   rotate<90,0,0>
}  

#declare tViltje2=
texture
{
   pigment
   {
      image_map
      {
        sys "povvilt.bmp" // the file to read (iff/gif/tga/png/sys)
        map_type 0 // 0=planar, 1=spherical, 2=cylindrical, 5=torus
        interpolate 2 // 0=none, 1=linear, 2=bilinear, 4=normalized distance
        // [filter N V] // N=all or color index # (0...N), V= value (0.0...1.0)
        // [transmit N V] // N=all or color index # (0...N), V= value (0.0...1.0)
        // [use_color | use_index]
        // [once]
      } // image_map
   }
   finish
   {
      reflection 0
      diffuse 0.58 
      ambient 0.13
      phong 0
   }
   normal
   {    
      // texture pigment/normal pattern
// create a wrinkly surface (0...1 or more)
   wrinkles 3                
   turbulence 5      
      scale <0.06,0.06,0.08>

   }              
   translate<0.5,0.5,0.5>
   scale 2.35*2          
   rotate<90,0,0>
}  

#declare tHekje =
texture
{
   pigment
   {  
      wood
      turbulence 0.7
      color_map
      {
         [0 color rgb .8]
         [1 color rgb .7]   
      }                    
   }
   finish
   {
      ambient 0.85
      diffuse 0.085
      reflection 0.1
   }
   normal
   {
      wood 0.15
      turbulence 0.7
   }    
   scale <2,7,2>
}
               
#declare rand4 = seed(2424);
#declare iCounter = -7;
#declare hekje=
union
{
#while (iCounter < 20) 
      #debug str(iCounter,0,2)
   union
   {
      box
      {
         <-1.5,-40,0.25>,<1.5,4,-0.25>
         translate <iCounter * 3*1.5, 0, 0>    
      }
      box
      {
         <-sqrt(1.5*1.5*2)/2,-sqrt(1.5*1.5*2)/2,0.25>,<sqrt(1.5*1.5*2)/2,sqrt(1.5*1.5*2)/2,-0.25>
         rotate <0,0,45> 
         scale <1,1.3,1>
         translate<0,4,0>
         translate <iCounter * 3*1.5, 0, 0>    
      }                  
      texture
      {              
         tHekje
         translate 20*<rand(rand4),rand(rand4),rand(rand4)>
      }
   }
#declare iCounter = iCounter + 1;
#end
   translate <0,0,100>
}

#declare fenceComplete=
union
{
   object
   {
      hekje
   }        
   
   box
   {
      <-7.5*3*1.5-1,0,0>,<20*3*1.5,-2,0>
      translate <0,0,100+0.5>
      texture{tHekje}
   }
   
   box
   {
      <-7.5*3*1.5-1,-8.5,0>,<20*3*1.5,-10.5,0>
      translate <0,0,100+0.5>
      texture{tHekje}
   }
   
   union
   {
      cylinder
      {
         <0,5,0>,<0,-40,0>,0.8
      }
      sphere
      {
         <0,5,0>,0.6
      }
      translate<0,0,100.5>
      translate<-7.83*3*1.5,0,0>
      texture
      {
         pigment
         {           
            crackle 
            turbulence 0.2
            color_map
            {
               [0 color rgb<0.42,0.42,0.46>]
               [1 color rgb<0.49,0.49,0.53>]
            }                                          
            scale <1,5,1>
         }                        
         finish
         {                 
            diffuse 0.5
            specular 1
            roughness .001
            reflection .03
            metallic
         }
         normal
         {
            granite 0.7
            scale <1,5,1>
         }
      }    
   }
   rotate <0,34,0>
   translate <-65,0,0>
}    

#declare tWhite =
texture
{
   pigment
   {     
      color rgb<1,1,1>
   }                  
   finish
   {             
  //    reflection 0.1
      phong 0.6
      phong_size 200
   }
   normal
   {      
      wrinkles 0.1 
      scale 0.1
   }
}

#declare tMetal =
texture
{
   pigment
   {           
      crackle 
      turbulence 0.2
      color_map
      {
         [0 color rgb<0.82,0.82,0.91>]
         [1 color rgb<0.89,0.89,0.97>]
      }      
      scale <1,5,1>
   }                        
   finish
   {                 
      diffuse 0.5
      specular 1
      roughness .005
      reflection .23
      metallic
   }
   normal
   {
      granite 0.7
      scale <1,5,1>
   }
}      
#declare tRoest=
texture
{
   pigment
   {       
      gradient y
      turbulence 0.2
      color_map
      {
         [0 color rgb<0.5,0.3,0.2>]
         [0.5 color rgb<0.7,0.45,0.34>]
         [1 color rgb<0.5,0.3,0.2>]
      }
   }                  
   normal
   {
      granite 1
   }
}

#declare parasol=
cylinder
{
   <0.6,-20,0.1>,<-0.5,20,0.5>,0.3
   translate <5.85,0,3>   
   texture
   {
      bozo 
      turbulence 0.62
      texture_map
      {
         [0 tWhite]
         [0.58 tWhite]
         [0.583 tMetal]
         [0.63 tMetal]
         [0.7 tRoest] 
         [1 tRoest]
      }                
      scale 0.8
      translate <.5,4,0>
   }
   translate <0,3,0>    
} 


//end of declarations

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////


//start of object placement


object {fenceComplete}

object {parasol}               
 

object
{
   oGlas       
   material {matGlas}
   photons
   {
      target
      refraction on
      reflection on
      ignore_photons
   }
}    
           

object
{
   oLiquid  
   material {matLiquid}
   photons
   {
      target
      refraction on
      reflection on
      ignore_photons
   }
} 

object
{
   oViltje
   texture{tViltje}
   rotate <0,43235,180>
   translate <0,glasHoogte + glasDikte/2 - 0.001,0>
   translate <-0.2,0,0.4>
}    

object
{
   oViltje
   texture{tViltje2}
   translate <-4.5,-0.2,6>
}       


object
{
   wineGlass    
   translate <0,2.91*33,0>
   scale 1/36
   translate <0,0.04,0>
   translate <-4.59,0,5.97>   
}

object {waspNotFlying rotate<19,90,-85> translate <-1,4,0> rotate<0,25,0>} //wasp in the glass
object {waspFlying rotate<15,-80,0> translate <-1.65,3.2,-5>} //wasp in the forground
object {waspFlying rotate<10,40,0> translate <8,4.3,9>} //wasp in the background


object 
{
   table 
   translate <0,-.2,0>
   translate <5.85,0,3>
} 


object{grass}

sky_sphere
{
   pigment
   {        
   color rgb<0.49*1.14,0.48*1.3,0.8>                   
//      bozo
 //     color_map
  //    {
   //      [0 color rgb<0.42,0.42,0.8>]
   //     [1 color rgb<
   //   }
   }                  
   scale 0.25
}

        
/*
]_sphere {  
    pigment {
        gradient y     
        turbulence 0.1
        pigment_map {
            [0.00    rgb <0.847, 0.749, 0.847> ]
            [0.04 rgb <0.6,0.6,0.8> ]
            [0.08 color rgb<0.42,0.4,0.8> ]
        }                     
    }
}                          
*/


//sphere
//{         
//   <0,0,0>, 1000    
difference
{
   plane
   {
      <0,1,0>,100       
      texture
      {
         pigment
         {           
            bozo       
            turbulence 1.25
            color_map
            {
               [0 color rgb 1.05*<1,1,.95>]
               [0.25 color rgb 1.05]
               [0.48 color Clear]
               [1 color Clear]
            }
         }    
         finish
         {
            reflection 0
            diffuse 0
            ambient 1
         }           
 
         scale 1100   
         translate <100,0,-280>
      }
      texture
      {
         pigment
         {           
            bozo       
            turbulence 1.05            
            octaves 4
            color_map
            {
               [0 color rgb .8]
               [0.15 color rgb 1.5*<0.65,0.61,0.7>]
               [0.3 color rgb <0.65,0.61,0.7>]
               [0.45 color Clear]
               [1 color Clear]
            }
         }    
         finish
         {
            reflection 0
            diffuse 0
            ambient .9
         }           
         scale 1100                  
         translate <0,-3,0>
         translate <100,0,-180>
      }
   }
   plane
   {
      <0,0,-1>,-6500 
      pigment
      {
         color Clear
      }
   }
}

fog 
{
   fog_type 2
   distance 800
   color rgbf 0.03+<0.7,0.73,0.88,0.2>
   fog_offset -40
   fog_alt 50    
   turbulence 5
// turbulence <TURBULENCE>
// turb_depth TURB_DEPTH
// omega OMEGA
// lambda LAMBDA
// octaves OCTAVES
// fog_offset FOG_OFFSET
// fog_alt FOG_ALT
  }

        
//end of object placement

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

//start of lightsources and camera

/*
light_source
{                                      
   
  0*x // light's position (translated below)
  color rgb <1,1,0.98>  // light's color
  // <widthVector> <heightVector> nLightsWide mLightsHigh
  area_light
  <5, 0, 0> <0, 0, 7> // lights spread out across this distance (x * z)
  4, 4                // total number of lights in grid (4x*4z = 16 lights)
  adaptive 0          // 0,1,2,3... 
 //orient 
 jitter              // adds random softening of light
  //rotate <0,0,90>
  translate 1.05*<12, 6, 7>   // <x y z> position of light
}
*/

light_source
{                                      
   
  0*x // light's position (translated below)
  color rgb <1,1,0.95>*1.5  // light's color
  // <widthVector> <heightVector> nLightsWide mLightsHigh
  area_light
  <5, 0, 0> <0, 0, 5> // lights spread out across this distance (x * z)
  4, 3                // total number of lights in grid (4x*4z = 16 lights)
  adaptive 0          // 0,1,2,3... 
// orient 
 jitter              // adds random softening of light
  rotate <0,0,-30>
  translate 2*<12, 6.7, 9>   // <x y z> position of light
//  photons { reflection off refraction off}
   photons {reflection on refraction on}
}

light_source
{
   <12,2,-6> color rgb .3      
   photons { reflection off refraction off}
}                            
/*
light_source
{
   5*<12,10,7> color rgb 2.5      
//   shadowless
}                            
light_source
{
   5*<12,7.5,7> color rgb 2.5      
//   shadowless
}                            
light_source
{
   5*<12,5,7> color rgb 2.5      
//   shadowless
}                            
light_source
{
   5*<12,2.5,7> color rgb 2.5      
//   shadowless
}                            

     */

light_source
{
   <2,2,-3> color rgb .5      
   shadowless
   photons { reflection off refraction off}
}                            

light_source
{  
   <9,4,20> color rgb .6  
   shadowless
   photons { reflection off refraction off}
}


light_source
{
   <6,5,-5> color rgb .5
//   shadowless
   photons { reflection off refraction off}
}



light_source
{
   <-6,5,1> color rgb .3
 //  shadowless
   photons { reflection off refraction off}
}

                           
camera
{
//   location 2*<-0.5,1,-7>
   location <-0.5,3,-7>
   direction <0,0,1>
//   look_at <-0.5, 3, 0>
      look_at <-0.5,2,0>
}