/*************************************************************************
                       AMEISEN MACRO - ANT MACRO
                               Version 0.1												            
                     (C) by Micha Riser, 28.9.2000
                      http://micha.virtualave.net

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 
  To contact the author write to:
                Micha Riser
                Lanzenbergstr. 14
                4312 Magden
                Switzerland    
 
  or send an email to:
        micha@micha.virtualave.net

  These macros are part of the POV-Ray Objects Collection. See 
	http://povobjects.virtualave.net/ for further information and more
	interesting objects!

**************************************************************************
This macros require MegaPov 0.5 ! See	http://nathan.kopp.com/patched.htm
for further information and download of MegaPov.

There are three macros to generate and set up ants:
- make_ant
- set_leg_to_positon
- make_random_ant

********************************** make_ant ******************************

PARAMETERS:					DEFAULT:					TYP RANGE:

  *	Thorax:
	w_torax1_2				  10							-10 to 30
		angle between first and second part of thorax (rotate around z)

  *	Legs:
	leg3right,leg3left,leg2right,leg2left,leg1right,leg1left
		these are all arrays of 5 values for the leg positions
	
		1. value			  50 /  80 /  60	   10 to 80
			angle between the base and the first part of the leg (around z)
		2. value			 160 / 100 /  45		 40 to 170
			angle between the base and the first part of the leg (around y)
		3. value			  90 /  90 / 135		20 to 170
			angle between the first and the second part of the leg
		4. value			- 20								-40 to 0
			angle between the second and the third part of the leg
		5. value			- 15								-30 to 0
			angle between the 3rd and the 4rd part of the leg

  *	Head:
	greifer_open			  10								0 to 90
		open angle for the 'mouth'
	w_head_thorax			  30								10 to 50
		angle between head and thorax

  *	Antenneas:
	rightantennea,leftantennea
		array of 5
		
		1. value			 70 / 110						40 to 130
			angle between the first and second part of the antennea
		2. value			-20 /  20						-40 to 40
			rotation about y
		3. value			-20									-40 to 0
			angle between base and antenea (around z)
		4. value			 40 / -40						30 to 50
			angle between base and antennea (around x)
		5. value			 18 / 107
			random seed
		
  *	Abdomen:
	w_abdomen_thorax		0
		angle between thorax and abdomen

TEXTURES:

	Ant_Type
		Choses the ant type for texturing
		0: individual
		1: Brown-black ant
		2: red ant
		
	Infividual texture can be chosen by specifying following variables	

	T_Ant_Overall
		Main ant texture
	T_Eye:
		The eye's texture.
	T_Mouth:
		The 'mouth''s texture.
	T_Antennea 	(*)
	T_Leg		(*)
	
	(*) these textures will be same as T_Ant_Overall if not specified
	
*************************************************************************/
#version unofficial Megapov 0.7;

// for much faster rendering I use the following option:
global_settings{ini_option "-UR"} 


#macro make_Fuehler(Fw_1_2,F_yrot,Fw_0_1z,Fw_0_1x,F_seed)

union{

sphere_sweep{
	
		catmull_rom_spline_sphere_sweep
		#declare rscale=0.4;
		6
		0,0.275*rscale
		0,0.25*rscale
		<-.2,0,1>,.22*rscale
		<-.3,0.15,2.8>,.3*rscale
		<0,0.3,4.8>,.35*rscale
		<0,0.3,4.8>,.35*rscale
				
		rotate y*90
		rotate z*90
		
		bounded_by{cylinder{0,<0,5,0>,0.5}}
		
		}



#declare ss=<0,0,0>;
#declare ss_dy=0;
#declare ss_dz=0;
#declare ss_anz=0;
#declare ss_r=seed(F_seed);

sphere_sweep{
		linear_sphere_sweep
21
0,0.25

#while(ss_anz<10)
	
	#declare ss_dy=ss_dy+(rand(ss_r)-.5)*.3;
	#declare ss_dz=ss_dz+(rand(ss_r)-.5)*.3;
	#if (ss_dy>0.7) #declare ss_dy=0.7; #end
	#if (ss_dy<-0.7) #declare ss_dy=-0.7; #end
	#if (ss_dz>0.7) #declare ss_dz=0.7; #end
	#if (ss_dz<-0.7) #declare ss_dz=-0.7; #end

	#declare ss_dx=1;
	#if (ss_anz=0) #declare ss_dx=2; #end
	#if (ss_anz=10) #declare ss_dx=1; #end
	
	#declare ss_x_neu=sqrt(ss_dx^2-ss_dz^2-ss_dy^2);
	#declare ss=ss+<ss_x_neu,ss_dy,ss_dz>;
	
	#if (ss_anz<9)
		ss,0.3
		ss+<0.01,0,0>,0.25
	#end
	
	#declare ss_anz=ss_anz+1;
#end
ss,0.25
#declare ss=ss+<ss_x_neu,ss_dy,ss_dz>*.5;
ss,0.1

bounded_by{cylinder{<-.1,0,0>,ss*1.05,2}}

scale .5
rotate y*180
rotate -z*(Fw_1_2-90)
translate <-.3,4.8,0>

}


rotate -y*F_yrot
rotate z*Fw_0_1z
rotate x*Fw_0_1x

#ifdef (T_Antennea)
texture{T_Antennea}
#end

}


#end //END OF FUEHLER MACRO


#macro Kopf(Greifer_offen)

#local Greifer=
difference{
	#declare r1=0.5;
	#declare r2=0.1;
		isosurface{
			function{x^2+ ( y/(r1-z+.2)^2 )^2+z^2-2*sqrt(x^2+z^2)*r1+r1^2-( r2/(r1-z+.2) )^2}
			contained_by{box{<-.7,-.15,-.6>,<0,.15,0>}}
			scale <.9,0.7,1>

			}
	box{-.1,.1 
		rotate y*45 
		scale <0.5,1,1>
		translate <-.52,0,0.075>
		}
	box{-.1,.1 
		rotate y*45 
		scale <0.5,1,1>
		translate <-.45,0,0.075>
		}
	box{-.1,.1 
		rotate y*45 
		scale <0.5,1,1>
		translate <-.38,0,0.075>
		}
	bounded_by{box{<-.7,-.15,-.6>,<0,.15,0>}}
	translate <0,0,.5>
	texture{T_Mouth}

}


	union{
	blob{
		threshold 0.5
		sphere{0,2,1 scale <1,0.3,1>*0.9 //rotate z*30
						}
		sphere{<2,0,0>,2,-1}
		sphere{<-1.5,0,.75>,1.6,-1.5}
		sphere{<-1.5,0,-.75>,1.6,-1.5}		
		sphere{0,0.5,-.5 scale <1,1,2> translate <-.35,.5,0>}
		sphere{0,1,-1 scale <1,1,5> translate <-.25,-.85,0>}
		sphere{0,0.15,-.02 scale <4.5,1,1.25> rotate z*15 translate <-.1,.25,-.35>}
		sphere{0,0.15,-.02 scale <4.5,1,1.25> rotate z*15 translate <-.1,.25,.35>}
		clipped_by{sphere{<.5,0,0>,.8 scale <1,5,2>}}		
		bounded_by{sphere{0,.5 scale <1,.6,2.2> translate <.13,.025,0>}}
		}
	sphere{0,.15 // LINKES AUGE 
				scale <1.5,.5,1>*0.85*.95
				rotate x*-50
				rotate z*-14
				scale <1,1,1/0.4> 
				scale <1,1,1>
				translate <.275,0.1,-0.7>
				texture{T_Eye}			
				}
	sphere{0,.15 //RECHTES AUGE
				scale <1.5,.5,1>*0.85*.95
				rotate x*-50
				rotate z*-14
				scale <1,1,1/0.4> 
				scale <1,1,1>
				translate <.275,0.1,-0.7>
				scale <1,1,-1>
				texture{T_Eye}
				}
	object{Greifer
				rotate -y*Greifer_offen
				scale <1,1,1/0.4>	*.6
				translate<-.1,0,-.7>	
							
				}
	object{Greifer
				scale <1,1,-1>
				rotate y*Greifer_offen
				scale <1,1,1/.4> *.6
				translate<-.1,0,.7>
				
				}
								
	}
#end
	
	
#declare Torax1=
	blob{
		threshold 0.5
		sphere{0,1,1 scale <1,0.7,1>*1.2}
		}

#declare Haeckchen=difference{
	sphere{0,1}
	sphere{0,1 scale <1,2,1> translate <.2,0,0>}
	scale <1,.3,1>*.1*.9

	}



#macro Bein1(b1w0_1_z,b1w0_1_y,b1w1_2,b1w2_3,b1w3_4)

union{
	blob{
		threshold 0.5
		sphere{<-.25,0,0>,0.15,.8}
		sphere{0,1,.4 translate <0.25,0,0>}//scale <1,0.1,.1>}
		cylinder{0,<.25,0,0>,.11,1 scale <3,1,1>}
		scale <1,0.8,.8>
		}
	blob{
		threshold 0.5
		sphere{0,0.3,.3 translate <0.4,0,0>}
		cylinder{0,<.25,0,0>,.08,1 scale <2.5,1,1>}
		translate <0.1,0,0>
		rotate -z*b1w1_2
		translate <0.92,0,0>
		}
	blob{
		threshold 0.5
		sphere{0,0.2,0.2 translate <0.2,0,0>}
		cylinder{0,<0.1,0,0>,0.05,1 scale <3,1,1>}
		translate <0.04,0,0>
		rotate -z*b1w2_3
		translate <1.75-0.92,0,0>
		rotate -z*b1w1_2
		translate <0.92,0,0>
		}	
	blob{
		threshold 0.5
		sphere{0,.2,1}
		sphere{<-.25,0,0>,.2,.45}
		sphere{<0.25,0,0>,.3,-1}		
		scale <2.5,1,1>	*.35
		scale <0.7,0.9,0.9>		
			
		translate <0.07,0,0>
		rotate -z*b1w3_4
		
		translate <2.12-1.7,0,0> 			//1.34
		rotate -z*b1w2_3
		translate <1.75-0.92,0,0>			//0.78
		rotate -z*b1w1_2
		translate <0.92,0,0>					//0.92
		}
	blob{
		threshold 0.5
		sphere{0,.2,1}
		sphere{<-.25,0,0>,.2,.45}
		sphere{<0.25,0,0>,.3,-1}			
		scale <2.5,1,1>	*.35		
		translate <0.15,0,0>
		scale <0.7,0.9,0.9>
		
		translate <0.07,0,0>
		rotate -z*b1w3_4

		translate <2.12-1.7,0,0> 			//1.34
		rotate -z*b1w2_3
		translate <1.75-0.92,0,0>			//0.78
		rotate -z*b1w1_2
		translate <0.92,0,0>					//0.92
		}	
	blob{
		threshold 0.5
		sphere{0,.2,1}
		sphere{<-.25,0,0>,.2,.45}
		sphere{<0.25,0,0>,.3,-1}			
		scale <2.5,1,1>	*.35		
		translate <0.15*2,0,0>
		scale <0.7,0.9,0.9>

		translate <0.07,0,0>
		rotate -z*b1w3_4

		translate <2.12-1.7,0,0> 			//1.34
		rotate -z*b1w2_3
		translate <1.75-0.92,0,0>			//0.78
		rotate -z*b1w1_2
		translate <0.92,0,0>					//0.92
		}		
	blob{
		threshold 0.5
		sphere{0,.2,1}
		sphere{<-.25,0,0>,.2,.45}
		sphere{<0.25,0,0>,.3,-1}			
		scale <2.5,1,1>	*.35		
		translate <0.15*3,0,0>
		scale <0.7,0.9,0.9>
		
		translate <0.07,0,0>
		rotate -z*b1w3_4
		
		translate <2.12-1.7,0,0> 			//1.34
		rotate -z*b1w2_3
		translate <1.75-0.92,0,0>			//0.78
		rotate -z*b1w1_2
		translate <0.92,0,0>					//0.92
		}		
	object{Haeckchen	
		translate <0.15*3.25,0,0>
		scale <0.7,0.9,0.9>	
		translate <0.07,0,0>
		rotate -z*b1w3_4
		
		translate <2.12-1.7,0,0> 			//1.34
		rotate -z*b1w2_3
		translate <1.75-0.92,0,0>			//0.78
		rotate -z*b1w1_2
		translate <0.92,0,0>					//0.92
		}	
	

}
#end //END BEIN1 MACRO


#macro Bein2_3(b2w0_1_z,b2w0_1_y,b2w1_2,b2w2_3,b2w3_4)
union{
	blob{
		threshold 0.5
		sphere{<-.25,0,0>,0.15,.8}
		sphere{0,1,.4 translate <0.25,0,0>}//scale <1,0.1,.1>}
		cylinder{0,<.12,0,0>,.11,1 scale <3,1,1>}
		scale <1,0.8,.8>
		}
	blob{
		threshold 0.5
		sphere{0,0.3,.3 translate <0.4,0,0>}
		cylinder{0,<.25,0,0>,.08,1 scale <2.5,1,1>}
		translate <0.1,0,0>
		rotate -z*b2w1_2
		translate <0.59,0,0>
		}
	blob{
		threshold 0.5
		sphere{0,0.2,0.2 translate <0.2,0,0>}
		cylinder{0,<0.1,0,0>,0.05,1 scale <3,1,1>}
		translate <0.04,0,0>
		rotate -z*b2w2_3
		translate <1.75-0.92,0,0>
		rotate -z*b2w1_2
		translate <0.59,0,0>
		}
	blob{
		threshold 0.5
		sphere{0,.2,1}
		sphere{<-.25,0,0>,.2,.45}
		sphere{<0.25,0,0>,.3,-1}		
		scale <2.5,1,1>	*.35
		scale <0.7,0.9,0.9>		
			
		translate <0.07,0,0>
		rotate -z*b2w3_4
		
		translate <2.12-1.7,0,0> 			//1.34
		rotate -z*b2w2_3
		translate <1.75-0.92,0,0>			//0.78
		rotate -z*b2w1_2
		translate <0.59,0,0>					//0.92
		}
	blob{
		threshold 0.5
		sphere{0,.2,1}
		sphere{<-.25,0,0>,.2,.45}
		sphere{<0.25,0,0>,.3,-1}			
		scale <2.5,1,1>	*.35		
		translate <0.15,0,0>
		scale <0.7,0.9,0.9>
		
		translate <0.07,0,0>
		rotate -z*b2w3_4

		translate <2.12-1.7,0,0> 			//1.34
		rotate -z*b2w2_3
		translate <1.75-0.92,0,0>			//0.78
		rotate -z*b2w1_2
		translate <0.59,0,0>					//0.92
		}	
	blob{
		threshold 0.5
		sphere{0,.2,1}
		sphere{<-.25,0,0>,.2,.45}
		sphere{<0.25,0,0>,.3,-1}			
		scale <2.5,1,1>	*.35		
		translate <0.15*2,0,0>
		scale <0.7,0.9,0.9>

		translate <0.07,0,0>
		rotate -z*b2w3_4

		translate <2.12-1.7,0,0> 			//1.34
		rotate -z*b2w2_3
		translate <1.75-0.92,0,0>			//0.78
		rotate -z*b2w1_2
		translate <0.59,0,0>					//0.92
		}		
	blob{
		threshold 0.5
		sphere{0,.2,1}
		sphere{<-.25,0,0>,.2,.45}
		sphere{<0.25,0,0>,.3,-1}			
		scale <2.5,1,1>	*.35		
		translate <0.15*3,0,0>
		scale <0.7,0.9,0.9>
		
		translate <0.07,0,0>
		rotate -z*b2w3_4
		
		translate <2.12-1.7,0,0> 			//1.34
		rotate -z*b2w2_3
		translate <1.75-0.92,0,0>			//0.78
		rotate -z*b2w1_2
		translate <0.59,0,0>					//0.92
		}		
	object{Haeckchen	
		translate <0.15*3.25,0,0>
		scale <0.7,0.9,0.9>	
		translate <0.07,0,0>
		rotate -z*b2w3_4		
		translate <2.12-1.7,0,0> 			//1.34
		rotate -z*b2w2_3
		translate <1.75-0.92,0,0>			//0.78
		rotate -z*b2w1_2
		translate <0.59,0,0>					//0.92		
		}

}
#end


#declare Torax2=
	blob{
		threshold 0.5
		sphere{0,0.85,1 scale <1,0.5,1> translate <0,0.05,0>}
		sphere{0,0.3,.3 translate <.2,0.1,-.45>}		
		sphere{0,0.3,.3 translate <.2,0.1,.45>}
		
		sphere{0,0.4,.35 translate <-.4,0.1,-.42> }
		sphere{0,0.4,.35 translate <-.4,0.1,.42> }
		
		sphere{0,0.2,.35 translate <-.075,0.1,-.55> }
		sphere{0,0.2,.35 translate <-.075,0.1,.55> }
		}

#declare Appendix=
	blob{
		threshold 0.5
		sphere{0,2,.5 scale <.8,0.4,1>}
		sphere{0,2,.5 scale <.8,0.4,1> translate <0,0.2,0>}
		sphere{0,1.5,0.4 scale <.8,1,1> translate <-0.5,1,0>}
		sphere{0,2,-0.3 translate <3,0,0>}
		bounded_by{sphere{0,1 scale <.95,.6,1.1> translate <-.05,.18,0>}}
		}	


/*************************************************************************
												AMEISEN MACRO - ANT MACRO

PARAMETERS:					DEFAULT:					TYP RANGE:

  *	Thorax:
	w_torax1_2				  10							-10 to 30
		angle between first and second part of thorax (rotate around z)

  *	Legs:
	leg3right,leg3left,leg2right,leg2left,leg1right,leg1left
		these are all arrays of 5 values for the leg positions
	
		1. value			  50 /  80 /  60	   10 to 80
			angle between the base and the first part of the leg (around z)
		2. value			 160 / 100 /  45		 40 to 170
			angle between the base and the first part of the leg (around y)
		3. value			  90 /  90 / 135		20 to 170
			angle between the first and the second part of the leg
		4. value			- 20								-40 to 0
			angle between the second and the third part of the leg
		5. value			- 15								-30 to 0
			angle between the 3rd and the 4rd part of the leg

  *	Head:
	greifer_open			  10								0 to 90
		open angle for the 'mouth'
	w_head_thorax			  30								10 to 50
		angle between head and thorax

  *	Antenneas:
	rightantennea,leftantennea
		array of 5
		
		1. value			 70 / 110						40 to 130
			angle between the first and second part of the antennea
		2. value			-20 /  20						-40 to 40
			rotation about y
		3. value			-20									-40 to 0
			angle between base and antenea (around z)
		4. value			 40 / -40						30 to 50
			angle between base and antennea (around x)
		5. value			 18 / 107
			random seed
		
  *	Abdomen:
	w_abdomen_thorax		0
		angle between thorax and abdomen

TEXTURES:

	Ant_Type
		Choses the ant type for texturing
		0: individual
		1: Brown-black ant
		2: red ant
		
	Infividual texture can be chosen by specifying following variables	

	T_Ant_Overall
		Main ant texture
	T_Eye:
		The eye's texture.
	T_Mouth:
		The 'mouth''s texture.
	T_Antennea 	(*)
	T_Leg		(*)
	
	(*) these textures will be same as T_Ant_Overall if not specified
	
*************************************************************************/

#macro make_ant()               // BEGIN MAIN MACRO

#ifndef (w_torax1_2)	#declare w_torax1_2=10;  #end	
#ifndef (leg3left)		#declare leg3left=array[5] {60,45,135,-20,-15} #end
#ifndef (leg3right)		#declare leg3right=array[5] {60,45,135,-20,-15} #end
#ifndef (leg2left)		#declare leg2left=array[5] {80,100,135,-20,-15} #end
#ifndef (leg2right)		#declare leg2right=array[5] {80,100,135,-20,-15} #end
#ifndef (leg1left)		#declare leg1left=array[5] {50,160,90,-20,-15} #end
#ifndef (leg1right)		#declare leg1right=array[5] {50,160,90,-20,-15} #end
#ifndef (greifer_open)	#declare greifer_open=10;	#end
#ifndef (w_head_thorax)	#declare w_head_thorax=60;	#end
#ifndef	(w_abdomen_thorax)	#declare w_abdomen_thorax=0; #end
#ifndef (Ant_Type) #declare Ant_Type=0; #end

#include "ant_tex.inc"

	union{
									// Thorax
		object{Torax2
			scale 1.1
			translate <0,-0.05,0>
			}
		object{Torax1
			rotate z*-10
			scale <1,1,0.9>
			rotate z*10
			
			#ifdef(T_Thorax1)
				texture{T_Thorax1}
			#end
			
			translate <-.5,.3,0>
			scale <1,0.9,0.8>
			rotate z*-w_torax1_2
			translate <-.5,.05,0>
			}
									// Legs
		object{Bein1(leg3left[0],leg3left[1],			// 3. Bein links
					 leg3left[2],leg3left[3],
					 leg3left[4])
			translate <.25,0,0>
	  		scale 1.5
			rotate z*leg3left[0]
			rotate y*leg3left[1]
			translate<2.5,-.15,-.6>-<2.2,-0.2,0>
			#ifdef (T_Leg)
				texture{T_Leg}
			#end		
			}
		object{Bein1(leg3right[0],leg3right[1],			// 3. Bein rechts
					 leg3right[2],leg3right[3],
					 leg3right[4])
			translate <.25,0,0>
	  		scale 1.5
			rotate z*leg3right[0]
			rotate y*-leg3right[1]
			translate<2.5,-.15,.6>-<2.2,-0.2,0>
			#ifdef (T_Leg)
				texture{T_Leg}
			#end	
			}
		object{Bein2_3(leg2left[0],leg2left[1],			// 2. Bein links
					 leg2left[2],leg2left[3],
					 leg2left[4])			
			translate <.25,0,0>
	 		scale 1.4
			rotate z*leg2left[0]
			rotate y*leg2left[1]
			translate<2.1,-.15,-.65>-<2.2,-0.2,0>
			#ifdef (T_Leg)
				texture{T_Leg}
			#end	
			}
		object{Bein2_3(leg2right[0],leg2right[1], 		// 2. Bein rechts
					 leg2right[2],leg2right[3],
					 leg2right[4]) 
			translate <.25,0,0>
	 		scale 1.4
			rotate z*leg2right[0]
			rotate y*-leg2right[1]
			translate<2.1,-.15,.65>-<2.2,-0.2,0>
			#ifdef (T_Leg)
				texture{T_Leg}
			#end
			}	
		
		object{Bein2_3(leg1left[0],leg1left[1], 		// 1. Bein links
					 leg1left[2],leg1left[3],
					 leg1left[4]) 
			translate <.25,0,0>
	  		scale 1.4
			rotate z*leg1left[0]
			rotate y*leg1left[1]
			translate<1.7,-.15,-.55>-<2.2,-0.2,0>
			#ifdef (T_Leg)
				texture{T_Leg}
			#end	
			}
		object{Bein2_3(leg1right[0],leg1right[1], 		// 1. Bein rechts
					 leg1right[2],leg1right[3],
					 leg1right[4])
			translate <.25,0,0>
	  		scale 1.4
			rotate z*leg1right[0]
			rotate y*-leg1right[1]
			translate<1.7,-.15,.55>	-<2.2,-0.2,0>
			#ifdef (T_Leg)
				texture{T_Leg}
			#end
			}	
			
		object{Kopf(greifer_open)	// Head	
			scale <1,1,0.4>*1.6
			translate <-0.6,0.3,0>
			rotate z*w_head_thorax
			translate <-1.5,0.6,0>
			translate -<-.5,.3,0>
			rotate z*-w_torax1_2
			translate <-.5,.3,0>
			}	
		
		object{make_Fuehler(110,20,-20,-40,107)		// Antennea 
			translate <0,1.75,-.7>
			scale .25
			
			translate <-0.6,0.3,0>
			rotate z*w_head_thorax
			translate <-1.5,0.6,0>
			translate -<-.5,.3,0>
			rotate z*-w_torax1_2
			translate <-.5,.3,0>
			}
		object{make_Fuehler(70,-20,-20,40,18)		// Antennea
			translate <0,1.85,.7>
			scale .25

			translate <-0.6,0.3,0>
			rotate z*w_head_thorax
			translate <-1.5,0.6,0>
			translate -<-.5,.3,0>
			rotate z*-w_torax1_2
			translate <-.5,.3,0>
			}		
			
		object{Appendix				// Abdomen
			scale <1,1,0.6>
			scale 1.5
			translate <1.3,0,0>
			scale <.8,.75,.657>
			#ifdef (T_Abdomen)				
				texture{T_Abdomen}
			#end
			rotate z*w_abdomen_thorax
			translate<3.9,-.05,0>-<2.2,-0.2,0>-<1.3,0,0>
			}

		texture{T_Ant_Overall}
	
		#ifdef (I_Ant_Overall)
			interior{I_Ant_Overall}
		#end
					
		} 							//END union


#end							
/// END MAIN MACRO

/////////////////////////////////////////////////////////////////////////
//
// Macro to put the ant's leg to a certain position
//
/////////////////////////////////////////////////////////////////////////
#macro calculate_angles(vv,r1,r2)

#declare winkel1=atan2(-vv.z,vv.x)/pi*180;
#local p=<sqrt( (vv.x^2) + (vv.z^2) ),vv.y>;
#local c=(r1^2)-(r2^2)+(p.x^2)+(p.y^2);
#local D=-(c^2)*(p.x^2)+4*(p.x^4)*(r1^2)+4*(p.x^2)*(p.y^2)*(r1^2);

#if (D<0) 

	#debug "impossible leg position!\n"  
	#declare winkel0=0;
	#declare winkel2=0;
	
	#else
	
	#local qy=( c*p.y+sqrt(D) ) / ( 2*(p.x^2)+2*(p.y^2) );
	#local qx_a=sqrt(r1^2-(qy^2));
	#local qx_b=-sqrt(r1^2-(qy^2));
	#local qx_c=p.x-sqrt( -(p.y^2)+(r2^2)+2*p.y*qy-(qy^2) );
	#local qx_d=p.x+sqrt( -(p.y^2)+(r2^2)+2*p.y*qy-(qy^2) );
	#if (qx_a=qx_c) #local qx=qx_a; #end
	#if (qx_a=qx_d) #local qx=qx_a; #end
	#if (qx_b=qx_c) #local qx=qx_b; #end
	#if (qx_b=qx_d) #local qx=qx_b; #end
	#declare winkel0=atan2(qy,qx)/pi*180;
	#declare winkel2=atan2(qy-p.y,p.x-qx)/pi*180;
	#end
	
#end

#macro set_leg_to_position(vl1,vr1,vl2,vr2,vl3,vr3)

#local vl1=vl1+<0.5,-0.05,.55>;
calculate_angles(vl1,1.25,2.3)
#declare leg1left=array[5]
#declare leg1left[1]=winkel1;
#declare leg1left[0]=winkel0;
#declare leg1left[2]=winkel2+winkel0+5;
#declare leg1left[3]=-10;
#declare leg1left[4]=-10;

#local vr1=vr1+<0.5,-0.05,-.55>;
calculate_angles(vr1,1.25,2.3)
#declare leg1right=array[5]
#declare leg1right[1]=-winkel1;
#declare leg1right[0]=winkel0;
#declare leg1right[2]=winkel2+winkel0+5;
#declare leg1right[3]=-10;
#declare leg1right[4]=-10;

#local vl2=vl2+<0.1,-0.05,.6>;
calculate_angles(vl2,1.25,2.3)
#declare leg2left=array[5]
#declare leg2left[1]=winkel1;
#declare leg2left[0]=winkel0;
#declare leg2left[2]=winkel2+winkel0+5;
#declare leg2left[3]=-10;
#declare leg2left[4]=-10;

#local vr2=vr2+<0.1,-0.05,-.6>;
calculate_angles(vr2,1.25,2.3)
#declare leg2right=array[5]
#declare leg2right[1]=-winkel1;
#declare leg2right[0]=winkel0;
#declare leg2right[2]=winkel2+winkel0+5;
#declare leg2right[3]=-10;
#declare leg2right[4]=-10;

#local vl3=vl3+<-0.28,0,.58>;
calculate_angles(vl3,1.85,2.35)
#declare leg3left=array[5]
#declare leg3left[1]=winkel1;
#declare leg3left[0]=winkel0;
#declare leg3left[2]=winkel2+winkel0+5;
#declare leg3left[3]=-10;
#declare leg3left[4]=-10;

#local vr3=vr3+<-0.28,0,-.58>;
calculate_angles(vr3,1.85,2.35)
#declare leg3right=array[5]
#declare leg3right[1]=-winkel1;
#declare leg3right[0]=winkel0;
#declare leg3right[2]=winkel2+winkel0+5;
#declare leg3right[3]=-10;
#declare leg3right[4]=-10;
#end

// END SET-LEG-TO-POSITION-MACRO

////////////////////////////////////////////////////////////////////
// MACRO TO GENERATE AN ANT WITH RANDOM LOOK 
///////////////////////////////////////////////////////////////////

#macro random_vec_circular(my_radius,rseed)
	#local winkel=rand(rseed)*2*pi;
	my_radius*rand(rseed)*<sin(winkel),0,cos(winkel)>
#end

#macro make_random_ant(rand_seed,legy)
#declare ss=seed(rand_seed);

#declare w_torax1_2=rand(ss)*40-10;
#declare greifer_open=rand(ss)*50;
#declare w_head_thorax=rand(ss)*40+10;
#declare rightantennea=array[5] {rand(ss)*90+40,rand(ss)*80-40,rand(ss)*40-40,rand(ss)*20+30,int(rand(ss)*1000)}
#declare leftantennea=array[5] {rand(ss)*90+40,rand(ss)*80-40,rand(ss)*40-40,-(rand(ss)*20+30),int(rand(ss)*1000)}

set_leg_to_position(
			<-2,legy,-2>+random_vec_circular(.8,ss),
			<-2,legy,2>+random_vec_circular(.8,ss),
			<-.25,legy,-2.5>+random_vec_circular(.9,ss),
			<-.25,legy,2.5>+random_vec_circular(.9,ss),
			<1.7,legy,-2>+random_vec_circular(1,ss),
			<1.7,legy,2>+random_vec_circular(1,ss)
			)

make_ant()
#end

//////////////// END INCLUDE FILE ////////////////////////////////
