#version unofficial MegaPov 0.7;

#declare test_fly_inc = off;


#declare P_Crack = pigment {
	crackle
	turbulence .1
	octaves 2
	scale <.3, .3, .6>
	color_map{
		[ 0.00 rgb 1 ]
		[ 0.05 rgb .5]
		[ 0.10 rgb 0]
	}
}

#declare T_FlyWings = texture {
	pigment {
		pigment_pattern { P_Crack }
		color_map{
			[ 0.0 rgbft<.97, .97, .97,0.9>]
			[ 0.8 rgbft<.9, .9, .9, 0.8>]
			[ 1.0 rgbf<0, 0, 0 ,0>]
		}
	}
	normal {
		average
		normal_map {
			[1 pigment_pattern { P_Crack } ]
			[1 wrinkles 5.0 scale .001 ]
		}
	}
	finish{
		specular .7 roughness .02
	}
}

#declare T_FlyEyes = texture {
	pigment{
		crackle
		scale .05
		color_map {
			[0.2 color rgb <0.667,0.227,0.067>]
			[.2 color rgb <0.345,0.600,0.392>]
			[.6 color rgb <0.345,0.600,0.392>]
			[.6 color rgb <0.847,0.878,0.424>]
		}
	}
	normal { crackle 2.0 scale .01 }
	finish{phong .2 specular .5 }
}

#declare T_FlyBody = texture {
	pigment{rgb <.4, .2, .3>*.2 }
	normal { bumps 3 scale .02 }
	finish{ phong .2 specular .4 }
}

#declare T_FlyLegs = texture {
	pigment{rgb <.4, .2, .3>*.2 }
	normal { bumps 3 scale .02 }
	finish{ phong .2 specular .4 }
}


#declare IMPORT_SPATCH = on;
#include "fly.msh"

#declare Fly = union {
	object { fly_Layer1 texture { T_FlyBody }}
	object { fly_Layer2 texture { T_FlyEyes }}
	object { fly_Layer3 texture { T_FlyWings } texture { T_FlyWings translate 10*x}}
	object { fly_Layer4 texture { T_FlyLegs }}
	translate <0, 1.39, 0>
}


#if (test_fly_inc)

camera{
	location < -5.149, 18.791, -10.796 >
	look_at < 0.000, 2.000, 0.000 >
	angle 40.000
}

background{ rgb <192/255,192/255,192/255> }

plane { y, 0 pigment { color rgb <.6, .4, .1> } }

//name : light_00
light_source{
	<5.406,6.428,-4.498>*5
	rgb<1.000,1.000,1.000>*1.5
}

object { Fly }

#end

