// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions

// ==== Additional Includes ====
// Don't have all of the following included at once, it'll cost memory and time
// to parse!
#include "FINISH.INC"   // Some basic finishes
#include "GLASS.INC"    // Glass textures
#include "METALS.INC"   // Metallic pigments, finishes, and textures





//base
#declare lbase =
union{
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.050, 1.684, -0.027> <1.050, 2.378, -0.027> <1.846, 2.723, -0.027> <2.540, 2.723, -0.027> 
		<1.050, 1.684, -0.027> <1.050, 2.378, -0.951> <1.846, 2.723, -0.856> <2.540, 2.723, -0.856> 
		<1.050, 1.684, -0.027> <1.050, 2.378, -0.951> <1.615, 2.514, -1.934> <2.540, 2.514, -1.934> 
		<1.050, 1.684, -0.027> <1.050, 1.684, -0.951> <1.615, 1.684, -1.934> <2.540, 1.684, -1.934> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.050, 1.684, -0.027> <1.050, 2.378, -0.027> <1.846, 2.723, -0.027> <2.540, 2.723, -0.027> 
		<1.050, 1.684, -0.027> <1.050, 2.378, 0.898> <1.846, 2.723, 0.803> <2.540, 2.723, 0.803> 
		<1.050, 1.684, -0.027> <1.050, 2.378, 0.898> <1.615, 2.514, 1.881> <2.540, 2.514, 1.881> 
		<1.050, 1.684, -0.027> <1.050, 1.684, 0.898> <1.615, 1.684, 1.881> <2.540, 1.684, 1.881> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.540, 2.723, -0.027> <3.234, 2.723, -0.027> <4.030, 2.378, -0.027> <4.030, 1.684, -0.027> 
		<2.540, 2.723, -0.027> <3.234, 2.723, 0.803> <4.030, 2.378, 0.898> <4.030, 1.684, 0.898> 
		<2.540, 2.723, -0.027> <3.234, 2.723, 0.803> <3.464, 2.514, 1.881> <3.464, 1.684, 1.881> 
		<2.540, 2.723, -0.027> <2.540, 2.723, 0.803> <2.540, 2.514, 1.881> <2.540, 1.684, 1.881> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.540, 2.723, -0.027> <3.234, 2.723, -0.027> <4.030, 2.378, -0.027> <4.030, 1.684, -0.027> 
		<2.540, 2.723, -0.027> <3.234, 2.723, -0.856> <4.030, 2.378, -0.951> <4.030, 1.684, -0.951> 
		<2.540, 2.723, -0.027> <3.234, 2.723, -0.856> <3.464, 2.514, -1.934> <3.464, 1.684, -1.934> 
		<2.540, 2.723, -0.027> <2.540, 2.723, -0.856> <2.540, 2.514, -1.934> <2.540, 1.684, -1.934> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.030, 1.684, -0.027> <4.030, 0.990, -0.027> <3.234, 0.645, -0.027> <2.540, 0.645, -0.027> 
		<4.030, 1.684, -0.027> <4.030, 0.990, 0.898> <3.234, 0.645, 0.803> <2.540, 0.645, 0.803> 
		<4.030, 1.684, -0.027> <4.030, 0.990, 0.898> <3.464, 0.855, 1.881> <2.540, 0.855, 1.881> 
		<4.030, 1.684, -0.027> <4.030, 1.684, 0.898> <3.464, 1.684, 1.881> <2.540, 1.684, 1.881> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.030, 1.684, -0.027> <4.030, 0.990, -0.027> <3.234, 0.645, -0.027> <2.540, 0.645, -0.027> 
		<4.030, 1.684, -0.027> <4.030, 0.990, -0.951> <3.234, 0.645, -0.856> <2.540, 0.645, -0.856> 
		<4.030, 1.684, -0.027> <4.030, 0.990, -0.951> <3.464, 0.855, -1.934> <2.540, 0.855, -1.934> 
		<4.030, 1.684, -0.027> <4.030, 1.684, -0.951> <3.464, 1.684, -1.934> <2.540, 1.684, -1.934> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.540, 0.645, -0.027> <1.846, 0.645, -0.027> <1.050, 0.990, -0.027> <1.050, 1.684, -0.027> 
		<2.540, 0.645, -0.027> <1.846, 0.645, -0.856> <1.050, 0.990, -0.951> <1.050, 1.684, -0.951> 
		<2.540, 0.645, -0.027> <1.846, 0.645, -0.856> <1.615, 0.855, -1.934> <1.615, 1.684, -1.934> 
		<2.540, 0.645, -0.027> <2.540, 0.645, -0.856> <2.540, 0.855, -1.934> <2.540, 1.684, -1.934> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.540, 0.645, -0.027> <1.846, 0.645, -0.027> <1.050, 0.990, -0.027> <1.050, 1.684, -0.027> 
		<2.540, 0.645, -0.027> <1.846, 0.645, 0.803> <1.050, 0.990, 0.898> <1.050, 1.684, 0.898> 
		<2.540, 0.645, -0.027> <1.846, 0.645, 0.803> <1.615, 0.855, 1.881> <1.615, 1.684, 1.881> 
		<2.540, 0.645, -0.027> <2.540, 0.645, 0.803> <2.540, 0.855, 1.881> <2.540, 1.684, 1.881> 
	}
	

}

//headlight
#declare lbody =
union{
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.055, 0.196, -0.872> <-0.154, 0.196, -0.870> <-0.235, 0.114, -0.870> <-0.235, 0.016, -0.872> 
		<-0.055, 0.196, -0.872> <-0.055, 0.196, -0.872> <-0.127, 0.114, -0.872> <-0.128, 0.016, -0.874> 
		<-0.055, 0.196, -0.872> <-0.055, 0.196, -0.872> <0.016, 0.114, -0.874> <0.016, 0.016, -0.876> 
		<-0.055, 0.196, -0.872> <0.043, 0.196, -0.873> <0.124, 0.114, -0.876> <0.124, 0.016, -0.878> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.235, 0.016, -0.872> <-0.236, -0.082, -0.873> <-0.154, -0.164, -0.876> <-0.056, -0.164, -0.878> 
		<-0.235, 0.016, -0.872> <-0.128, -0.082, -0.875> <-0.056, -0.164, -0.878> <0.043, -0.164, -0.880> 
		<-0.235, 0.016, -0.872> <-0.128, -0.082, -0.875> <0.016, -0.082, -0.878> <0.124, -0.082, -0.880> 
		<-0.235, 0.016, -0.872> <-0.128, 0.016, -0.874> <0.016, 0.016, -0.876> <0.124, 0.016, -0.878> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.034, 0.190, 0.885> <-0.133, 0.190, 0.886> <-0.214, 0.108, 0.886> <-0.214, 0.010, 0.885> 
		<-0.034, 0.190, 0.885> <-0.034, 0.190, 0.885> <-0.106, 0.108, 0.884> <-0.106, 0.010, 0.883> 
		<-0.034, 0.190, 0.885> <-0.034, 0.190, 0.885> <0.038, 0.108, 0.882> <0.038, 0.010, 0.880> 
		<-0.034, 0.190, 0.885> <0.064, 0.190, 0.883> <0.146, 0.108, 0.880> <0.146, 0.010, 0.878> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.214, 0.010, 0.885> <-0.214, -0.089, 0.883> <-0.133, -0.170, 0.880> <-0.034, -0.170, 0.878> 
		<-0.214, 0.010, 0.885> <-0.106, -0.089, 0.881> <-0.034, -0.170, 0.878> <0.064, -0.170, 0.877> 
		<-0.214, 0.010, 0.885> <-0.106, -0.089, 0.881> <0.038, -0.089, 0.878> <0.146, -0.089, 0.877> 
		<-0.214, 0.010, 0.885> <-0.106, 0.010, 0.883> <0.038, 0.010, 0.880> <0.146, 0.010, 0.878> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.398, -0.344, 0.000> <-0.398, -0.344, 0.188> <-0.241, -0.344, 0.345> <-0.053, -0.344, 0.345> 
		<-0.398, -0.344, 0.000> <-0.398, -0.344, 0.000> <-0.241, -0.344, 0.138> <-0.053, -0.344, 0.138> 
		<-0.398, -0.344, 0.000> <-0.398, -0.344, 0.000> <-0.241, -0.344, -0.138> <-0.053, -0.344, -0.138> 
		<-0.398, -0.344, 0.000> <-0.398, -0.344, -0.188> <-0.241, -0.344, -0.345> <-0.053, -0.344, -0.345> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.053, -0.344, 0.345> <0.135, -0.344, 0.345> <0.292, -0.344, 0.188> <0.292, -0.344, 0.000> 
		<-0.053, -0.344, 0.345> <0.135, -0.344, 0.138> <0.292, -0.344, 0.000> <0.292, -0.344, -0.188> 
		<-0.053, -0.344, 0.345> <0.135, -0.344, 0.138> <0.135, -0.344, -0.138> <0.135, -0.344, -0.345> 
		<-0.053, -0.344, 0.345> <-0.053, -0.344, 0.138> <-0.053, -0.344, -0.138> <-0.053, -0.344, -0.345> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.235, 0.016, -0.872> <-0.236, -0.082, -0.873> <-0.154, -0.164, -0.876> <-0.056, -0.164, -0.878> 
		<-0.229, 0.014, -0.345> <-0.229, -0.084, -0.347> <-0.147, -0.166, -0.349> <-0.049, -0.166, -0.351> 
		<-0.221, 0.012, 0.358> <-0.221, -0.087, 0.356> <-0.139, -0.168, 0.353> <-0.041, -0.168, 0.351> 
		<-0.214, 0.010, 0.885> <-0.214, -0.089, 0.883> <-0.133, -0.170, 0.880> <-0.034, -0.170, 0.878> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.056, -0.164, -0.878> <0.043, -0.164, -0.880> <0.124, -0.082, -0.880> <0.124, 0.016, -0.878> 
		<-0.049, -0.166, -0.351> <0.049, -0.166, -0.353> <0.131, -0.084, -0.353> <0.131, 0.014, -0.351> 
		<-0.041, -0.168, 0.351> <0.057, -0.168, 0.350> <0.139, -0.087, 0.350> <0.139, 0.012, 0.351> 
		<-0.034, -0.170, 0.878> <0.064, -0.170, 0.877> <0.146, -0.089, 0.877> <0.146, 0.010, 0.878> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.124, 0.016, -0.878> <0.124, 0.114, -0.876> <0.043, 0.196, -0.873> <-0.055, 0.196, -0.872> 
		<0.131, 0.014, -0.351> <0.131, 0.112, -0.349> <0.049, 0.194, -0.347> <-0.049, 0.194, -0.345> 
		<0.139, 0.012, 0.351> <0.139, 0.110, 0.353> <0.058, 0.192, 0.356> <-0.041, 0.192, 0.358> 
		<0.146, 0.010, 0.878> <0.146, 0.108, 0.880> <0.064, 0.190, 0.883> <-0.034, 0.190, 0.885> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.034, 0.190, 0.885> <-0.133, 0.190, 0.886> <-0.214, 0.108, 0.886> <-0.214, 0.010, 0.885> 
		<-0.041, 0.192, 0.358> <-0.139, 0.192, 0.359> <-0.221, 0.110, 0.359> <-0.221, 0.012, 0.358> 
		<-0.049, 0.194, -0.345> <-0.147, 0.194, -0.343> <-0.229, 0.112, -0.343> <-0.229, 0.014, -0.345> 
		<-0.055, 0.196, -0.872> <-0.154, 0.196, -0.870> <-0.235, 0.114, -0.870> <-0.235, 0.016, -0.872> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.053, -0.344, 0.345> <0.135, -0.344, 0.345> <0.292, -0.344, 0.188> <0.292, -0.344, 0.000> 
		<-0.053, -0.249, 0.241> <0.135, -0.249, 0.241> <0.188, -0.249, 0.188> <0.188, -0.249, 0.000> 
		<-0.053, -0.122, 0.103> <-0.053, -0.122, 0.103> <0.050, -0.122, 0.000> <0.050, -0.122, 0.000> 
		<-0.053, -0.027, 0.000> <-0.053, -0.027, 0.000> <-0.053, -0.027, 0.000> <-0.053, -0.027, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.292, -0.344, 0.000> <0.292, -0.344, -0.188> <0.135, -0.344, -0.345> <-0.053, -0.344, -0.345> 
		<0.188, -0.249, 0.000> <0.188, -0.249, -0.188> <0.135, -0.249, -0.241> <-0.053, -0.249, -0.241> 
		<0.050, -0.122, 0.000> <0.050, -0.122, 0.000> <-0.053, -0.122, -0.103> <-0.053, -0.122, -0.103> 
		<-0.053, -0.027, 0.000> <-0.053, -0.027, 0.000> <-0.053, -0.027, 0.000> <-0.053, -0.027, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.053, -0.344, -0.345> <-0.241, -0.344, -0.345> <-0.398, -0.344, -0.188> <-0.398, -0.344, 0.000> 
		<-0.053, -0.249, -0.241> <-0.241, -0.249, -0.241> <-0.294, -0.249, -0.188> <-0.294, -0.249, 0.000> 
		<-0.053, -0.122, -0.103> <-0.053, -0.122, -0.103> <-0.156, -0.122, 0.000> <-0.156, -0.122, 0.000> 
		<-0.053, -0.027, 0.000> <-0.053, -0.027, 0.000> <-0.053, -0.027, 0.000> <-0.053, -0.027, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.053, -0.027, 0.000> <-0.053, -0.027, 0.000> <-0.053, -0.027, 0.000> <-0.053, -0.027, 0.000> 
		<-0.156, -0.122, 0.000> <-0.156, -0.122, 0.000> <-0.053, -0.122, 0.103> <-0.053, -0.122, 0.103> 
		<-0.294, -0.249, 0.000> <-0.294, -0.249, 0.188> <-0.241, -0.249, 0.241> <-0.053, -0.249, 0.241> 
		<-0.398, -0.344, 0.000> <-0.398, -0.344, 0.188> <-0.241, -0.344, 0.345> <-0.053, -0.344, 0.345> 
	}
	

}

//lens
#declare lens =
union{
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.229, 0.000, -0.824> <-0.229, 0.081, -0.824> <-0.161, 0.150, -0.824> <-0.080, 0.150, -0.824> 
		<-0.229, 0.000, -0.824> <-0.229, 0.081, -0.890> <-0.161, 0.150, -0.890> <-0.080, 0.150, -0.890> 
		<-0.229, 0.000, -0.824> <-0.229, 0.081, -0.890> <-0.146, 0.066, -0.911> <-0.080, 0.066, -0.911> 
		<-0.229, 0.000, -0.824> <-0.229, 0.000, -0.890> <-0.146, 0.000, -0.911> <-0.080, 0.000, -0.911> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.229, 0.000, -0.824> <-0.229, 0.081, -0.824> <-0.161, 0.150, -0.824> <-0.080, 0.150, -0.824> 
		<-0.229, 0.000, -0.824> <-0.229, 0.081, -0.757> <-0.161, 0.150, -0.757> <-0.080, 0.150, -0.757> 
		<-0.229, 0.000, -0.824> <-0.229, 0.081, -0.757> <-0.146, 0.066, -0.737> <-0.080, 0.066, -0.737> 
		<-0.229, 0.000, -0.824> <-0.229, 0.000, -0.757> <-0.146, 0.000, -0.737> <-0.080, 0.000, -0.737> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.080, 0.150, -0.824> <0.001, 0.150, -0.824> <0.070, 0.081, -0.824> <0.070, 0.000, -0.824> 
		<-0.080, 0.150, -0.824> <0.001, 0.150, -0.757> <0.070, 0.081, -0.757> <0.070, 0.000, -0.757> 
		<-0.080, 0.150, -0.824> <0.001, 0.150, -0.757> <-0.014, 0.066, -0.737> <-0.014, 0.000, -0.737> 
		<-0.080, 0.150, -0.824> <-0.080, 0.150, -0.757> <-0.080, 0.066, -0.737> <-0.080, 0.000, -0.737> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.080, 0.150, -0.824> <0.001, 0.150, -0.824> <0.070, 0.081, -0.824> <0.070, 0.000, -0.824> 
		<-0.080, 0.150, -0.824> <0.001, 0.150, -0.890> <0.070, 0.081, -0.890> <0.070, 0.000, -0.890> 
		<-0.080, 0.150, -0.824> <0.001, 0.150, -0.890> <-0.014, 0.066, -0.911> <-0.014, 0.000, -0.911> 
		<-0.080, 0.150, -0.824> <-0.080, 0.150, -0.890> <-0.080, 0.066, -0.911> <-0.080, 0.000, -0.911> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.070, 0.000, -0.824> <0.070, -0.081, -0.824> <0.001, -0.150, -0.824> <-0.080, -0.150, -0.824> 
		<0.070, 0.000, -0.824> <0.070, -0.081, -0.757> <0.001, -0.150, -0.757> <-0.080, -0.150, -0.757> 
		<0.070, 0.000, -0.824> <0.070, -0.081, -0.757> <-0.014, -0.066, -0.737> <-0.080, -0.066, -0.737> 
		<0.070, 0.000, -0.824> <0.070, 0.000, -0.757> <-0.014, 0.000, -0.737> <-0.080, 0.000, -0.737> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.070, 0.000, -0.824> <0.070, -0.081, -0.824> <0.001, -0.150, -0.824> <-0.080, -0.150, -0.824> 
		<0.070, 0.000, -0.824> <0.070, -0.081, -0.890> <0.001, -0.150, -0.890> <-0.080, -0.150, -0.890> 
		<0.070, 0.000, -0.824> <0.070, -0.081, -0.890> <-0.014, -0.066, -0.911> <-0.080, -0.066, -0.911> 
		<0.070, 0.000, -0.824> <0.070, 0.000, -0.890> <-0.014, 0.000, -0.911> <-0.080, 0.000, -0.911> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.080, -0.150, -0.824> <-0.161, -0.150, -0.824> <-0.229, -0.081, -0.824> <-0.229, 0.000, -0.824> 
		<-0.080, -0.150, -0.824> <-0.161, -0.150, -0.890> <-0.229, -0.081, -0.890> <-0.229, 0.000, -0.890> 
		<-0.080, -0.150, -0.824> <-0.161, -0.150, -0.890> <-0.146, -0.066, -0.911> <-0.146, 0.000, -0.911> 
		<-0.080, -0.150, -0.824> <-0.080, -0.150, -0.890> <-0.080, -0.066, -0.911> <-0.080, 0.000, -0.911> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.080, -0.150, -0.824> <-0.161, -0.150, -0.824> <-0.229, -0.081, -0.824> <-0.229, 0.000, -0.824> 
		<-0.080, -0.150, -0.824> <-0.161, -0.150, -0.757> <-0.229, -0.081, -0.757> <-0.229, 0.000, -0.757> 
		<-0.080, -0.150, -0.824> <-0.161, -0.150, -0.757> <-0.146, -0.066, -0.737> <-0.146, 0.000, -0.737> 
		<-0.080, -0.150, -0.824> <-0.080, -0.150, -0.757> <-0.080, -0.066, -0.737> <-0.080, 0.000, -0.737> 
	}
	

}

#declare lmount =
union{
//object {lbase 
//        color red 0.119608 green 0.137255 blue 0.556863
//	finish{phong 0.2}}
object {lbody
        texture { pigment { P_Chrome4 } finish { F_MetalD  } }}
object {lens
        texture {
    pigment { color rgbf<1.0, 1.0, 1.0, 1.0> }
    finish  { F_Glass2 }
}}
}

//object {lmount}