// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions

// ==== Additional Includes ====
// Don't have all of the following included at once, it'll cost memory and time
// to parse!

#include "FINISH.INC"   // Some basic finishes
#include "GOLDS.INC"    // Gold textures
#include "METALS.INC"   // Metallic pigments, finishes, and textures


#declare legs =
union{
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.194, -0.364, -0.000> <-3.194, -0.364, 0.031> <-3.172, -0.377, 0.056> <-3.145, -0.392, 0.056> 
		<-3.194, -0.364, -0.000> <-3.194, -0.364, -0.000> <-3.172, -0.377, 0.022> <-3.145, -0.392, 0.022> 
		<-3.194, -0.364, -0.000> <-3.194, -0.364, -0.000> <-3.172, -0.377, -0.023> <-3.145, -0.392, -0.023> 
		<-3.194, -0.364, -0.000> <-3.194, -0.364, -0.031> <-3.172, -0.377, -0.056> <-3.145, -0.392, -0.056> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.145, -0.392, 0.056> <-3.118, -0.407, 0.056> <-3.096, -0.420, 0.031> <-3.096, -0.420, -0.000> 
		<-3.145, -0.392, 0.056> <-3.118, -0.407, 0.022> <-3.096, -0.420, -0.000> <-3.096, -0.420, -0.031> 
		<-3.145, -0.392, 0.056> <-3.118, -0.407, 0.022> <-3.118, -0.407, -0.023> <-3.118, -0.407, -0.056> 
		<-3.145, -0.392, 0.056> <-3.145, -0.392, 0.022> <-3.145, -0.392, -0.023> <-3.145, -0.392, -0.056> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.782, 2.285, -0.000> <-1.782, 2.285, 0.086> <-1.720, 2.249, 0.158> <-1.645, 2.206, 0.158> 
		<-1.782, 2.285, -0.000> <-1.782, 2.285, -0.000> <-1.720, 2.249, 0.063> <-1.645, 2.206, 0.063> 
		<-1.782, 2.285, -0.000> <-1.782, 2.285, -0.000> <-1.720, 2.249, -0.063> <-1.645, 2.206, -0.063> 
		<-1.782, 2.285, -0.000> <-1.782, 2.285, -0.086> <-1.720, 2.249, -0.158> <-1.645, 2.206, -0.158> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.645, 2.206, 0.158> <-1.570, 2.163, 0.158> <-1.508, 2.127, 0.086> <-1.508, 2.127, -0.000> 
		<-1.645, 2.206, 0.158> <-1.570, 2.163, 0.063> <-1.508, 2.127, -0.000> <-1.508, 2.127, -0.086> 
		<-1.645, 2.206, 0.158> <-1.570, 2.163, 0.063> <-1.570, 2.163, -0.063> <-1.570, 2.163, -0.158> 
		<-1.645, 2.206, 0.158> <-1.645, 2.206, 0.063> <-1.645, 2.206, -0.063> <-1.645, 2.206, -0.158> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.681, 2.274, -0.000> <-1.681, 2.274, 0.050> <-1.688, 2.233, 0.092> <-1.697, 2.183, 0.092> 
		<-1.681, 2.274, -0.000> <-1.681, 2.274, -0.000> <-1.688, 2.233, 0.037> <-1.697, 2.183, 0.037> 
		<-1.681, 2.274, -0.000> <-1.681, 2.274, -0.000> <-1.688, 2.233, -0.037> <-1.697, 2.183, -0.037> 
		<-1.681, 2.274, -0.000> <-1.681, 2.274, -0.050> <-1.688, 2.233, -0.092> <-1.697, 2.183, -0.092> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.697, 2.183, 0.092> <-1.706, 2.134, 0.092> <-1.713, 2.093, 0.050> <-1.713, 2.093, -0.000> 
		<-1.697, 2.183, 0.092> <-1.706, 2.134, 0.037> <-1.713, 2.093, -0.000> <-1.713, 2.093, -0.050> 
		<-1.697, 2.183, 0.092> <-1.706, 2.134, 0.037> <-1.706, 2.134, -0.037> <-1.706, 2.134, -0.092> 
		<-1.697, 2.183, 0.092> <-1.697, 2.183, 0.037> <-1.697, 2.183, -0.037> <-1.697, 2.183, -0.092> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.291, 1.852, 0.000> <1.291, 1.852, 0.105> <1.276, 1.766, 0.193> <1.258, 1.662, 0.193> 
		<1.291, 1.852, 0.000> <1.291, 1.852, 0.000> <1.276, 1.766, 0.077> <1.258, 1.662, 0.077> 
		<1.291, 1.852, 0.000> <1.291, 1.852, 0.000> <1.276, 1.766, -0.077> <1.258, 1.662, -0.077> 
		<1.291, 1.852, 0.000> <1.291, 1.852, -0.105> <1.276, 1.766, -0.193> <1.258, 1.662, -0.193> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.258, 1.662, 0.193> <1.239, 1.559, 0.193> <1.224, 1.472, 0.105> <1.224, 1.472, 0.000> 
		<1.258, 1.662, 0.193> <1.239, 1.559, 0.077> <1.224, 1.472, 0.000> <1.224, 1.472, -0.105> 
		<1.258, 1.662, 0.193> <1.239, 1.559, 0.077> <1.239, 1.559, -0.077> <1.239, 1.559, -0.193> 
		<1.258, 1.662, 0.193> <1.258, 1.662, 0.077> <1.258, 1.662, -0.077> <1.258, 1.662, -0.193> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<8.280, 0.013, 0.002> <8.280, 0.013, 0.032> <8.258, -0.002, 0.057> <8.234, -0.020, 0.057> 
		<8.280, 0.013, 0.002> <8.280, 0.013, 0.002> <8.259, -0.002, 0.024> <8.234, -0.020, 0.023> 
		<8.280, 0.013, 0.002> <8.280, 0.013, 0.002> <8.260, -0.003, -0.021> <8.235, -0.021, -0.022> 
		<8.280, 0.013, 0.002> <8.281, 0.012, -0.029> <8.261, -0.003, -0.055> <8.236, -0.021, -0.056> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<8.234, -0.020, 0.057> <8.209, -0.038, 0.056> <8.189, -0.053, 0.030> <8.189, -0.054, -0.000> 
		<8.234, -0.020, 0.057> <8.210, -0.038, 0.023> <8.189, -0.054, -0.000> <8.190, -0.054, -0.031> 
		<8.234, -0.020, 0.057> <8.210, -0.038, 0.023> <8.211, -0.039, -0.022> <8.211, -0.039, -0.056> 
		<8.234, -0.020, 0.057> <8.234, -0.020, 0.023> <8.235, -0.021, -0.022> <8.236, -0.021, -0.056> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<6.601, 2.500, -0.055> <6.599, 2.500, 0.031> <6.539, 2.458, 0.102> <6.469, 2.408, 0.101> 
		<6.601, 2.500, -0.055> <6.601, 2.500, -0.055> <6.541, 2.458, 0.007> <6.471, 2.407, 0.006> 
		<6.601, 2.500, -0.055> <6.601, 2.500, -0.055> <6.544, 2.457, -0.119> <6.474, 2.406, -0.121> 
		<6.601, 2.500, -0.055> <6.603, 2.499, -0.141> <6.547, 2.456, -0.214> <6.477, 2.406, -0.215> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<6.469, 2.408, 0.101> <6.399, 2.357, 0.099> <6.343, 2.314, 0.026> <6.345, 2.314, -0.060> 
		<6.469, 2.408, 0.101> <6.402, 2.357, 0.004> <6.345, 2.314, -0.060> <6.347, 2.313, -0.146> 
		<6.469, 2.408, 0.101> <6.402, 2.357, 0.004> <6.405, 2.356, -0.122> <6.407, 2.355, -0.217> 
		<6.469, 2.408, 0.101> <6.471, 2.407, 0.006> <6.474, 2.406, -0.121> <6.477, 2.406, -0.215> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<6.502, 2.478, -0.057> <6.500, 2.478, -0.007> <6.511, 2.438, 0.035> <6.525, 2.390, 0.036> 
		<6.502, 2.478, -0.057> <6.502, 2.478, -0.057> <6.512, 2.438, -0.020> <6.526, 2.390, -0.019> 
		<6.502, 2.478, -0.057> <6.502, 2.478, -0.057> <6.514, 2.437, -0.093> <6.528, 2.389, -0.093> 
		<6.502, 2.478, -0.057> <6.503, 2.477, -0.107> <6.515, 2.437, -0.148> <6.529, 2.389, -0.148> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<6.525, 2.390, 0.036> <6.538, 2.342, 0.036> <6.551, 2.302, -0.005> <6.552, 2.301, -0.055> 
		<6.525, 2.390, 0.036> <6.540, 2.342, -0.019> <6.552, 2.301, -0.055> <6.553, 2.301, -0.105> 
		<6.525, 2.390, 0.036> <6.540, 2.342, -0.019> <6.541, 2.341, -0.092> <6.543, 2.341, -0.147> 
		<6.525, 2.390, 0.036> <6.526, 2.390, -0.019> <6.528, 2.389, -0.093> <6.529, 2.389, -0.148> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.591, 1.749, -0.123> <3.588, 1.749, -0.018> <3.610, 1.666, 0.071> <3.639, 1.564, 0.072> 
		<3.591, 1.749, -0.123> <3.591, 1.749, -0.123> <3.613, 1.665, -0.045> <3.642, 1.564, -0.044> 
		<3.591, 1.749, -0.123> <3.591, 1.749, -0.123> <3.616, 1.664, -0.199> <3.645, 1.563, -0.198> 
		<3.591, 1.749, -0.123> <3.593, 1.748, -0.228> <3.619, 1.663, -0.315> <3.648, 1.562, -0.313> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.639, 1.564, 0.072> <3.668, 1.463, 0.073> <3.694, 1.379, -0.013> <3.697, 1.378, -0.118> 
		<3.639, 1.564, 0.072> <3.671, 1.463, -0.042> <3.697, 1.378, -0.118> <3.699, 1.377, -0.223> 
		<3.639, 1.564, 0.072> <3.671, 1.463, -0.042> <3.674, 1.462, -0.196> <3.677, 1.461, -0.312> 
		<3.639, 1.564, 0.072> <3.642, 1.564, -0.044> <3.645, 1.563, -0.198> <3.648, 1.562, -0.313> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<6.645, -0.025, -0.765> <6.646, -0.022, -0.735> <6.627, -0.034, -0.707> <6.601, -0.051, -0.704> 
		<6.645, -0.025, -0.765> <6.645, -0.025, -0.765> <6.625, -0.037, -0.741> <6.599, -0.054, -0.738> 
		<6.645, -0.025, -0.765> <6.645, -0.025, -0.765> <6.622, -0.041, -0.785> <6.597, -0.058, -0.783> 
		<6.645, -0.025, -0.765> <6.643, -0.028, -0.796> <6.620, -0.044, -0.819> <6.595, -0.061, -0.816> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<6.601, -0.051, -0.704> <6.576, -0.068, -0.701> <6.553, -0.085, -0.724> <6.552, -0.087, -0.755> 
		<6.601, -0.051, -0.704> <6.574, -0.071, -0.735> <6.552, -0.087, -0.755> <6.550, -0.090, -0.785> 
		<6.601, -0.051, -0.704> <6.574, -0.071, -0.735> <6.572, -0.075, -0.780> <6.570, -0.078, -0.813> 
		<6.601, -0.051, -0.704> <6.599, -0.054, -0.738> <6.597, -0.058, -0.783> <6.595, -0.061, -0.816> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<6.102, 3.164, -1.008> <6.106, 3.172, -0.922> <6.051, 3.139, -0.844> <5.980, 3.091, -0.835> 
		<6.102, 3.164, -1.008> <6.102, 3.164, -1.008> <6.046, 3.130, -0.938> <5.975, 3.082, -0.930> 
		<6.102, 3.164, -1.008> <6.102, 3.164, -1.008> <6.039, 3.119, -1.064> <5.968, 3.071, -1.055> 
		<6.102, 3.164, -1.008> <6.097, 3.157, -1.093> <6.034, 3.110, -1.158> <5.963, 3.063, -1.150> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.980, 3.091, -0.835> <5.908, 3.043, -0.827> <5.845, 2.997, -0.892> <5.841, 2.989, -0.978> 
		<5.980, 3.091, -0.835> <5.903, 3.035, -0.922> <5.841, 2.989, -0.978> <5.836, 2.981, -1.063> 
		<5.980, 3.091, -0.835> <5.903, 3.035, -0.922> <5.896, 3.023, -1.047> <5.891, 3.015, -1.142> 
		<5.980, 3.091, -0.835> <5.975, 3.082, -0.930> <5.968, 3.071, -1.055> <5.963, 3.063, -1.150> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<6.002, 3.146, -1.001> <6.005, 3.151, -0.951> <6.017, 3.114, -0.906> <6.029, 3.066, -0.903> 
		<6.002, 3.146, -1.001> <6.002, 3.146, -1.001> <6.014, 3.109, -0.961> <6.026, 3.061, -0.957> 
		<6.002, 3.146, -1.001> <6.002, 3.146, -1.001> <6.010, 3.103, -1.034> <6.022, 3.054, -1.030> 
		<6.002, 3.146, -1.001> <5.999, 3.142, -1.050> <6.007, 3.098, -1.089> <6.019, 3.049, -1.085> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<6.029, 3.066, -0.903> <6.042, 3.017, -0.899> <6.049, 2.973, -0.937> <6.047, 2.969, -0.987> 
		<6.029, 3.066, -0.903> <6.039, 3.013, -0.954> <6.047, 2.969, -0.987> <6.044, 2.964, -1.037> 
		<6.029, 3.066, -0.903> <6.039, 3.013, -0.954> <6.035, 3.006, -1.027> <6.032, 3.001, -1.081> 
		<6.029, 3.066, -0.903> <6.026, 3.061, -0.957> <6.022, 3.054, -1.030> <6.019, 3.049, -1.085> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.519, 1.934, -0.686> <3.524, 1.944, -0.582> <3.550, 1.867, -0.488> <3.576, 1.765, -0.480> 
		<3.519, 1.934, -0.686> <3.519, 1.934, -0.686> <3.544, 1.856, -0.603> <3.570, 1.755, -0.595> 
		<3.519, 1.934, -0.686> <3.519, 1.934, -0.686> <3.536, 1.843, -0.757> <3.561, 1.741, -0.749> 
		<3.519, 1.934, -0.686> <3.513, 1.925, -0.791> <3.530, 1.832, -0.872> <3.555, 1.730, -0.864> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.576, 1.765, -0.480> <3.602, 1.663, -0.473> <3.618, 1.571, -0.553> <3.613, 1.561, -0.658> 
		<3.576, 1.765, -0.480> <3.595, 1.653, -0.588> <3.613, 1.561, -0.658> <3.607, 1.552, -0.762> 
		<3.576, 1.765, -0.480> <3.595, 1.653, -0.588> <3.587, 1.639, -0.741> <3.581, 1.629, -0.856> 
		<3.576, 1.765, -0.480> <3.570, 1.755, -0.595> <3.561, 1.741, -0.749> <3.555, 1.730, -0.864> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<8.225, 0.063, 1.197> <8.229, 0.065, 1.167> <8.213, 0.050, 1.138> <8.189, 0.032, 1.134> 
		<8.225, 0.063, 1.197> <8.225, 0.063, 1.197> <8.208, 0.049, 1.171> <8.184, 0.030, 1.167> 
		<8.225, 0.063, 1.197> <8.225, 0.063, 1.197> <8.202, 0.046, 1.216> <8.178, 0.028, 1.211> 
		<8.225, 0.063, 1.197> <8.221, 0.061, 1.228> <8.197, 0.044, 1.249> <8.173, 0.026, 1.245> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<8.189, 0.032, 1.134> <8.165, 0.013, 1.129> <8.141, -0.004, 1.151> <8.137, -0.005, 1.181> 
		<8.189, 0.032, 1.134> <8.160, 0.011, 1.163> <8.137, -0.005, 1.181> <8.133, -0.007, 1.212> 
		<8.189, 0.032, 1.134> <8.160, 0.011, 1.163> <8.154, 0.009, 1.207> <8.149, 0.007, 1.241> 
		<8.189, 0.032, 1.134> <8.184, 0.030, 1.167> <8.178, 0.028, 1.211> <8.173, 0.026, 1.245> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<6.475, 2.499, 1.086> <6.487, 2.504, 1.000> <6.441, 2.464, 0.919> <6.373, 2.412, 0.907> 
		<6.475, 2.499, 1.086> <6.475, 2.499, 1.086> <6.428, 2.459, 1.013> <6.360, 2.407, 1.001> 
		<6.475, 2.499, 1.086> <6.475, 2.499, 1.086> <6.410, 2.452, 1.138> <6.343, 2.400, 1.126> 
		<6.475, 2.499, 1.086> <6.463, 2.495, 1.171> <6.397, 2.447, 1.232> <6.330, 2.395, 1.220> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<6.373, 2.412, 0.907> <6.306, 2.359, 0.895> <6.240, 2.312, 0.956> <6.228, 2.307, 1.041> 
		<6.373, 2.412, 0.907> <6.293, 2.354, 0.989> <6.228, 2.307, 1.041> <6.216, 2.302, 1.126> 
		<6.373, 2.412, 0.907> <6.293, 2.354, 0.989> <6.276, 2.347, 1.114> <6.262, 2.342, 1.207> 
		<6.373, 2.412, 0.907> <6.360, 2.407, 1.001> <6.343, 2.400, 1.126> <6.330, 2.395, 1.220> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<6.377, 2.475, 1.071> <6.384, 2.477, 1.021> <6.403, 2.440, 0.980> <6.418, 2.392, 0.979> 
		<6.377, 2.475, 1.071> <6.377, 2.475, 1.071> <6.395, 2.437, 1.034> <6.411, 2.389, 1.034> 
		<6.377, 2.475, 1.071> <6.377, 2.475, 1.071> <6.385, 2.433, 1.107> <6.400, 2.386, 1.106> 
		<6.377, 2.475, 1.071> <6.371, 2.472, 1.120> <6.378, 2.430, 1.161> <6.393, 2.383, 1.161> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<6.418, 2.392, 0.979> <6.433, 2.345, 0.979> <6.440, 2.303, 1.020> <6.434, 2.300, 1.069> 
		<6.418, 2.392, 0.979> <6.426, 2.342, 1.033> <6.434, 2.300, 1.069> <6.427, 2.297, 1.119> 
		<6.418, 2.392, 0.979> <6.426, 2.342, 1.033> <6.416, 2.338, 1.106> <6.408, 2.335, 1.160> 
		<6.418, 2.392, 0.979> <6.411, 2.389, 1.034> <6.400, 2.386, 1.106> <6.393, 2.383, 1.161> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.520, 1.667, 0.630> <3.535, 1.672, 0.526> <3.574, 1.594, 0.438> <3.606, 1.493, 0.437> 
		<3.520, 1.667, 0.630> <3.520, 1.667, 0.630> <3.558, 1.587, 0.553> <3.590, 1.487, 0.552> 
		<3.520, 1.667, 0.630> <3.520, 1.667, 0.630> <3.537, 1.579, 0.705> <3.569, 1.479, 0.704> 
		<3.520, 1.667, 0.630> <3.506, 1.661, 0.734> <3.521, 1.573, 0.820> <3.553, 1.473, 0.819> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.606, 1.493, 0.437> <3.638, 1.393, 0.436> <3.653, 1.305, 0.522> <3.638, 1.300, 0.626> 
		<3.606, 1.493, 0.437> <3.622, 1.387, 0.551> <3.638, 1.300, 0.626> <3.624, 1.294, 0.730> 
		<3.606, 1.493, 0.437> <3.622, 1.387, 0.551> <3.601, 1.379, 0.703> <3.585, 1.373, 0.818> 
		<3.606, 1.493, 0.437> <3.590, 1.487, 0.552> <3.569, 1.479, 0.704> <3.553, 1.473, 0.819> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.228, -0.300, -0.818> <-3.230, -0.298, -0.787> <-3.210, -0.309, -0.759> <-3.183, -0.324, -0.756> 
		<-3.228, -0.300, -0.818> <-3.228, -0.300, -0.818> <-3.208, -0.312, -0.793> <-3.181, -0.327, -0.790> 
		<-3.228, -0.300, -0.818> <-3.228, -0.300, -0.818> <-3.205, -0.315, -0.838> <-3.179, -0.331, -0.835> 
		<-3.228, -0.300, -0.818> <-3.226, -0.303, -0.848> <-3.203, -0.318, -0.871> <-3.177, -0.334, -0.868> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.183, -0.324, -0.756> <-3.157, -0.340, -0.753> <-3.134, -0.355, -0.776> <-3.132, -0.358, -0.807> 
		<-3.183, -0.324, -0.756> <-3.155, -0.343, -0.787> <-3.132, -0.358, -0.807> <-3.130, -0.361, -0.838> 
		<-3.183, -0.324, -0.756> <-3.155, -0.343, -0.787> <-3.152, -0.347, -0.832> <-3.150, -0.350, -0.865> 
		<-3.183, -0.324, -0.756> <-3.181, -0.327, -0.790> <-3.179, -0.331, -0.835> <-3.177, -0.334, -0.868> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.766, 2.317, -0.960> <-1.771, 2.325, -0.874> <-1.714, 2.294, -0.796> <-1.640, 2.250, -0.788> 
		<-1.766, 2.317, -0.960> <-1.766, 2.317, -0.960> <-1.708, 2.286, -0.890> <-1.635, 2.242, -0.882> 
		<-1.766, 2.317, -0.960> <-1.766, 2.317, -0.960> <-1.701, 2.275, -1.016> <-1.627, 2.231, -1.008> 
		<-1.766, 2.317, -0.960> <-1.761, 2.310, -1.046> <-1.695, 2.267, -1.110> <-1.622, 2.223, -1.102> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.640, 2.250, -0.788> <-1.567, 2.206, -0.780> <-1.501, 2.163, -0.844> <-1.496, 2.156, -0.930> 
		<-1.640, 2.250, -0.788> <-1.561, 2.198, -0.874> <-1.496, 2.156, -0.930> <-1.491, 2.148, -1.016> 
		<-1.640, 2.250, -0.788> <-1.561, 2.198, -0.874> <-1.554, 2.187, -1.000> <-1.548, 2.179, -1.094> 
		<-1.640, 2.250, -0.788> <-1.635, 2.242, -0.882> <-1.627, 2.231, -1.008> <-1.622, 2.223, -1.102> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.665, 2.304, -0.953> <-1.668, 2.309, -0.903> <-1.679, 2.272, -0.859> <-1.689, 2.223, -0.855> 
		<-1.665, 2.304, -0.953> <-1.665, 2.304, -0.953> <-1.676, 2.267, -0.913> <-1.685, 2.218, -0.910> 
		<-1.665, 2.304, -0.953> <-1.665, 2.304, -0.953> <-1.671, 2.261, -0.986> <-1.681, 2.212, -0.982> 
		<-1.665, 2.304, -0.953> <-1.663, 2.300, -1.003> <-1.668, 2.256, -1.041> <-1.678, 2.207, -1.037> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.689, 2.223, -0.855> <-1.698, 2.174, -0.851> <-1.704, 2.129, -0.889> <-1.701, 2.125, -0.939> 
		<-1.689, 2.223, -0.855> <-1.695, 2.169, -0.906> <-1.701, 2.125, -0.939> <-1.698, 2.121, -0.989> 
		<-1.689, 2.223, -0.855> <-1.695, 2.169, -0.906> <-1.691, 2.163, -0.979> <-1.687, 2.158, -1.034> 
		<-1.689, 2.223, -0.855> <-1.685, 2.218, -0.910> <-1.681, 2.212, -0.982> <-1.678, 2.207, -1.037> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.292, 1.841, -0.739> <1.286, 1.850, -0.634> <1.264, 1.772, -0.540> <1.244, 1.669, -0.533> 
		<1.292, 1.841, -0.739> <1.292, 1.841, -0.739> <1.271, 1.762, -0.655> <1.251, 1.659, -0.648> 
		<1.292, 1.841, -0.739> <1.292, 1.841, -0.739> <1.280, 1.748, -0.809> <1.260, 1.645, -0.801> 
		<1.292, 1.841, -0.739> <1.299, 1.831, -0.843> <1.287, 1.738, -0.924> <1.266, 1.635, -0.916> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.244, 1.669, -0.533> <1.224, 1.566, -0.525> <1.212, 1.472, -0.605> <1.218, 1.463, -0.710> 
		<1.244, 1.669, -0.533> <1.230, 1.556, -0.640> <1.218, 1.463, -0.710> <1.224, 1.454, -0.815> 
		<1.244, 1.669, -0.533> <1.230, 1.556, -0.640> <1.239, 1.542, -0.793> <1.246, 1.532, -0.908> 
		<1.244, 1.669, -0.533> <1.251, 1.659, -0.648> <1.260, 1.645, -0.801> <1.266, 1.635, -0.916> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.022, -0.427, 2.190> <-2.012, -0.427, 2.219> <-1.984, -0.442, 2.237> <-1.961, -0.461, 2.228> 
		<-2.022, -0.427, 2.190> <-2.022, -0.427, 2.190> <-1.995, -0.442, 2.205> <-1.972, -0.460, 2.197> 
		<-2.022, -0.427, 2.190> <-2.022, -0.427, 2.190> <-2.009, -0.442, 2.162> <-1.986, -0.460, 2.154> 
		<-2.022, -0.427, 2.190> <-2.032, -0.427, 2.161> <-2.020, -0.441, 2.130> <-1.997, -0.460, 2.122> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.961, -0.461, 2.228> <-1.937, -0.479, 2.220> <-1.926, -0.494, 2.189> <-1.936, -0.494, 2.160> 
		<-1.961, -0.461, 2.228> <-1.948, -0.479, 2.188> <-1.936, -0.494, 2.160> <-1.946, -0.493, 2.131> 
		<-1.961, -0.461, 2.228> <-1.948, -0.479, 2.188> <-1.963, -0.478, 2.146> <-1.974, -0.478, 2.114> 
		<-1.961, -0.461, 2.228> <-1.972, -0.460, 2.197> <-1.986, -0.460, 2.154> <-1.997, -0.460, 2.122> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.213, 2.693, 1.661> <-1.186, 2.692, 1.743> <-1.108, 2.649, 1.791> <-1.042, 2.598, 1.769> 
		<-1.213, 2.693, 1.661> <-1.213, 2.693, 1.661> <-1.139, 2.650, 1.702> <-1.073, 2.599, 1.679> 
		<-1.213, 2.693, 1.661> <-1.213, 2.693, 1.661> <-1.179, 2.651, 1.582> <-1.114, 2.600, 1.559> 
		<-1.213, 2.693, 1.661> <-1.241, 2.694, 1.579> <-1.210, 2.652, 1.492> <-1.144, 2.601, 1.470> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.042, 2.598, 1.769> <-0.977, 2.547, 1.746> <-0.946, 2.505, 1.659> <-0.973, 2.505, 1.577> 
		<-1.042, 2.598, 1.769> <-1.007, 2.547, 1.656> <-0.973, 2.505, 1.577> <-1.001, 2.506, 1.496> 
		<-1.042, 2.598, 1.769> <-1.007, 2.547, 1.656> <-1.048, 2.549, 1.536> <-1.079, 2.549, 1.447> 
		<-1.042, 2.598, 1.769> <-1.073, 2.599, 1.679> <-1.114, 2.600, 1.559> <-1.144, 2.601, 1.470> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.120, 2.670, 1.629> <-1.104, 2.670, 1.676> <-1.101, 2.630, 1.719> <-1.115, 2.582, 1.723> 
		<-1.120, 2.670, 1.629> <-1.120, 2.670, 1.629> <-1.119, 2.630, 1.667> <-1.133, 2.582, 1.671> 
		<-1.120, 2.670, 1.629> <-1.120, 2.670, 1.629> <-1.143, 2.631, 1.598> <-1.156, 2.583, 1.602> 
		<-1.120, 2.670, 1.629> <-1.136, 2.671, 1.581> <-1.161, 2.631, 1.545> <-1.174, 2.583, 1.550> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.115, 2.582, 1.723> <-1.129, 2.534, 1.727> <-1.153, 2.494, 1.691> <-1.169, 2.494, 1.644> 
		<-1.115, 2.582, 1.723> <-1.146, 2.534, 1.675> <-1.169, 2.494, 1.644> <-1.186, 2.495, 1.597> 
		<-1.115, 2.582, 1.723> <-1.146, 2.534, 1.675> <-1.170, 2.535, 1.606> <-1.188, 2.535, 1.554> 
		<-1.115, 2.582, 1.723> <-1.133, 2.582, 1.671> <-1.156, 2.583, 1.602> <-1.174, 2.583, 1.550> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.467, 1.865, 0.684> <1.501, 1.864, 0.784> <1.505, 1.779, 0.874> <1.477, 1.678, 0.882> 
		<1.467, 1.865, 0.684> <1.467, 1.865, 0.684> <1.468, 1.780, 0.764> <1.440, 1.679, 0.773> 
		<1.467, 1.865, 0.684> <1.467, 1.865, 0.684> <1.418, 1.782, 0.618> <1.390, 1.681, 0.627> 
		<1.467, 1.865, 0.684> <1.433, 1.866, 0.584> <1.381, 1.783, 0.509> <1.352, 1.682, 0.518> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.477, 1.678, 0.882> <1.449, 1.578, 0.891> <1.397, 1.494, 0.816> <1.363, 1.495, 0.716> 
		<1.477, 1.678, 0.882> <1.411, 1.579, 0.782> <1.363, 1.495, 0.716> <1.329, 1.496, 0.617> 
		<1.477, 1.678, 0.882> <1.411, 1.579, 0.782> <1.361, 1.580, 0.636> <1.324, 1.581, 0.526> 
		<1.477, 1.678, 0.882> <1.440, 1.679, 0.773> <1.390, 1.681, 0.627> <1.352, 1.682, 0.518> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.786, 1.756, -4.784> <-1.804, 1.741, -4.765> <-1.803, 1.710, -4.746> <-1.782, 1.688, -4.743> 
		<-1.786, 1.756, -4.784> <-1.786, 1.756, -4.784> <-1.782, 1.727, -4.768> <-1.761, 1.704, -4.764> 
		<-1.786, 1.756, -4.784> <-1.786, 1.756, -4.784> <-1.754, 1.748, -4.796> <-1.734, 1.726, -4.793> 
		<-1.786, 1.756, -4.784> <-1.767, 1.771, -4.803> <-1.734, 1.765, -4.817> <-1.713, 1.742, -4.814> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.782, 1.688, -4.743> <-1.761, 1.666, -4.740> <-1.728, 1.659, -4.754> <-1.709, 1.674, -4.773> 
		<-1.782, 1.688, -4.743> <-1.740, 1.682, -4.761> <-1.709, 1.674, -4.773> <-1.691, 1.689, -4.792> 
		<-1.782, 1.688, -4.743> <-1.740, 1.682, -4.761> <-1.713, 1.704, -4.789> <-1.692, 1.720, -4.811> 
		<-1.782, 1.688, -4.743> <-1.761, 1.704, -4.764> <-1.734, 1.726, -4.793> <-1.713, 1.742, -4.814> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.635, 3.289, -2.475> <-0.687, 3.248, -2.421> <-0.683, 3.161, -2.368> <-0.624, 3.098, -2.360> 
		<-0.635, 3.289, -2.475> <-0.635, 3.289, -2.475> <-0.625, 3.207, -2.428> <-0.566, 3.144, -2.419> 
		<-0.635, 3.289, -2.475> <-0.635, 3.289, -2.475> <-0.547, 3.268, -2.507> <-0.489, 3.205, -2.498> 
		<-0.635, 3.289, -2.475> <-0.582, 3.331, -2.529> <-0.489, 3.313, -2.566> <-0.431, 3.251, -2.557> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.624, 3.098, -2.360> <-0.566, 3.035, -2.351> <-0.473, 3.018, -2.389> <-0.420, 3.059, -2.443> 
		<-0.624, 3.098, -2.360> <-0.508, 3.081, -2.410> <-0.420, 3.059, -2.443> <-0.367, 3.101, -2.496> 
		<-0.624, 3.098, -2.360> <-0.508, 3.081, -2.410> <-0.430, 3.142, -2.489> <-0.372, 3.188, -2.549> 
		<-0.624, 3.098, -2.360> <-0.566, 3.144, -2.419> <-0.489, 3.205, -2.498> <-0.431, 3.251, -2.557> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.555, 3.241, -2.434> <-0.586, 3.217, -2.402> <-0.617, 3.168, -2.405> <-0.625, 3.132, -2.440> 
		<-0.555, 3.241, -2.434> <-0.555, 3.241, -2.434> <-0.584, 3.194, -2.440> <-0.591, 3.159, -2.474> 
		<-0.555, 3.241, -2.434> <-0.555, 3.241, -2.434> <-0.539, 3.230, -2.486> <-0.546, 3.194, -2.520> 
		<-0.555, 3.241, -2.434> <-0.524, 3.265, -2.465> <-0.505, 3.256, -2.520> <-0.513, 3.221, -2.555> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.625, 3.132, -2.440> <-0.632, 3.097, -2.474> <-0.613, 3.088, -2.529> <-0.582, 3.112, -2.561> 
		<-0.625, 3.132, -2.440> <-0.599, 3.123, -2.509> <-0.582, 3.112, -2.561> <-0.552, 3.136, -2.592> 
		<-0.625, 3.132, -2.440> <-0.599, 3.123, -2.509> <-0.554, 3.159, -2.555> <-0.520, 3.185, -2.589> 
		<-0.625, 3.132, -2.440> <-0.591, 3.159, -2.474> <-0.546, 3.194, -2.520> <-0.513, 3.221, -2.555> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.789, 1.759, -1.284> <1.724, 1.708, -1.218> <1.657, 1.604, -1.224> <1.642, 1.530, -1.297> 
		<1.789, 1.759, -1.284> <1.789, 1.759, -1.284> <1.728, 1.660, -1.297> <1.712, 1.586, -1.369> 
		<1.789, 1.759, -1.284> <1.789, 1.759, -1.284> <1.823, 1.734, -1.393> <1.807, 1.660, -1.466> 
		<1.789, 1.759, -1.284> <1.853, 1.810, -1.350> <1.894, 1.790, -1.465> <1.878, 1.716, -1.538> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.642, 1.530, -1.297> <1.626, 1.456, -1.370> <1.666, 1.436, -1.485> <1.731, 1.487, -1.551> 
		<1.642, 1.530, -1.297> <1.697, 1.511, -1.442> <1.731, 1.487, -1.551> <1.795, 1.538, -1.617> 
		<1.642, 1.530, -1.297> <1.697, 1.511, -1.442> <1.791, 1.586, -1.539> <1.862, 1.642, -1.611> 
		<1.642, 1.530, -1.297> <1.712, 1.586, -1.369> <1.807, 1.660, -1.466> <1.878, 1.716, -1.538> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<7.784, -0.048, -2.534> <7.792, -0.050, -2.505> <7.778, -0.067, -2.476> <7.753, -0.085, -2.471> 
		<7.784, -0.048, -2.534> <7.784, -0.048, -2.534> <7.769, -0.064, -2.509> <7.745, -0.082, -2.504> 
		<7.784, -0.048, -2.534> <7.784, -0.048, -2.534> <7.758, -0.061, -2.552> <7.734, -0.079, -2.547> 
		<7.784, -0.048, -2.534> <7.777, -0.045, -2.564> <7.750, -0.058, -2.585> <7.726, -0.076, -2.580> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<7.753, -0.085, -2.471> <7.729, -0.103, -2.467> <7.702, -0.116, -2.487> <7.695, -0.114, -2.517> 
		<7.753, -0.085, -2.471> <7.720, -0.100, -2.499> <7.695, -0.114, -2.517> <7.687, -0.111, -2.547> 
		<7.753, -0.085, -2.471> <7.720, -0.100, -2.499> <7.709, -0.097, -2.543> <7.701, -0.094, -2.575> 
		<7.753, -0.085, -2.471> <7.745, -0.082, -2.504> <7.734, -0.079, -2.547> <7.726, -0.076, -2.580> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<6.202, 2.433, -1.939> <6.224, 2.426, -1.855> <6.184, 2.379, -1.775> <6.115, 2.328, -1.761> 
		<6.202, 2.433, -1.939> <6.202, 2.433, -1.939> <6.161, 2.386, -1.866> <6.092, 2.336, -1.853> 
		<6.202, 2.433, -1.939> <6.202, 2.433, -1.939> <6.130, 2.396, -1.989> <6.061, 2.345, -1.975> 
		<6.202, 2.433, -1.939> <6.181, 2.440, -2.022> <6.107, 2.403, -2.080> <6.038, 2.352, -2.067> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<6.115, 2.328, -1.761> <6.047, 2.278, -1.748> <5.972, 2.241, -1.806> <5.951, 2.248, -1.890> 
		<6.115, 2.328, -1.761> <6.024, 2.285, -1.840> <5.951, 2.248, -1.890> <5.930, 2.254, -1.973> 
		<6.115, 2.328, -1.761> <6.024, 2.285, -1.840> <5.993, 2.295, -1.962> <5.970, 2.302, -2.054> 
		<6.115, 2.328, -1.761> <6.092, 2.336, -1.853> <6.061, 2.345, -1.975> <6.038, 2.352, -2.067> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<6.106, 2.411, -1.916> <6.118, 2.407, -1.868> <6.139, 2.364, -1.833> <6.151, 2.316, -1.840> 
		<6.106, 2.411, -1.916> <6.106, 2.411, -1.916> <6.125, 2.368, -1.886> <6.138, 2.320, -1.893> 
		<6.106, 2.411, -1.916> <6.106, 2.411, -1.916> <6.107, 2.374, -1.957> <6.120, 2.326, -1.964> 
		<6.106, 2.411, -1.916> <6.094, 2.415, -1.964> <6.094, 2.378, -2.010> <6.106, 2.330, -2.017> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<6.151, 2.316, -1.840> <6.164, 2.268, -1.847> <6.164, 2.232, -1.893> <6.151, 2.235, -1.941> 
		<6.151, 2.316, -1.840> <6.150, 2.272, -1.900> <6.151, 2.235, -1.941> <6.139, 2.239, -1.990> 
		<6.151, 2.316, -1.840> <6.150, 2.272, -1.900> <6.132, 2.278, -1.971> <6.119, 2.282, -2.024> 
		<6.151, 2.316, -1.840> <6.138, 2.320, -1.893> <6.120, 2.326, -1.964> <6.106, 2.330, -2.017> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.269, 1.685, -1.256> <3.295, 1.677, -1.154> <3.338, 1.587, -1.082> <3.364, 1.486, -1.097> 
		<3.269, 1.685, -1.256> <3.269, 1.685, -1.256> <3.310, 1.596, -1.194> <3.336, 1.495, -1.208> 
		<3.269, 1.685, -1.256> <3.269, 1.685, -1.256> <3.272, 1.607, -1.343> <3.298, 1.507, -1.357> 
		<3.269, 1.685, -1.256> <3.243, 1.694, -1.358> <3.244, 1.616, -1.455> <3.270, 1.515, -1.469> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.364, 1.486, -1.097> <3.390, 1.385, -1.111> <3.390, 1.308, -1.208> <3.365, 1.316, -1.310> 
		<3.364, 1.486, -1.097> <3.362, 1.394, -1.223> <3.365, 1.316, -1.310> <3.339, 1.324, -1.411> 
		<3.364, 1.486, -1.097> <3.362, 1.394, -1.223> <3.324, 1.406, -1.372> <3.296, 1.415, -1.484> 
		<3.364, 1.486, -1.097> <3.336, 1.495, -1.208> <3.298, 1.507, -1.357> <3.270, 1.515, -1.469> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.145, -0.392, 0.056> <-3.118, -0.407, 0.056> <-3.096, -0.420, 0.031> <-3.096, -0.420, -0.000> 
		<-2.695, 0.387, 0.087> <-2.668, 0.372, 0.087> <-2.620, 0.344, 0.031> <-2.620, 0.344, -0.000> 
		<-2.095, 1.427, 0.127> <-2.020, 1.383, 0.127> <-1.985, 1.363, 0.086> <-1.985, 1.363, -0.000> 
		<-1.645, 2.206, 0.158> <-1.570, 2.163, 0.158> <-1.508, 2.127, 0.086> <-1.508, 2.127, -0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.096, -0.420, -0.000> <-3.096, -0.420, -0.031> <-3.118, -0.407, -0.056> <-3.145, -0.392, -0.056> 
		<-2.620, 0.344, -0.000> <-2.620, 0.344, -0.031> <-2.668, 0.372, -0.087> <-2.695, 0.387, -0.087> 
		<-1.985, 1.363, -0.000> <-1.985, 1.363, -0.086> <-2.020, 1.383, -0.127> <-2.095, 1.427, -0.127> 
		<-1.508, 2.127, -0.000> <-1.508, 2.127, -0.086> <-1.570, 2.163, -0.158> <-1.645, 2.206, -0.158> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.145, -0.392, -0.056> <-3.172, -0.377, -0.056> <-3.194, -0.364, -0.031> <-3.194, -0.364, -0.000> 
		<-2.695, 0.387, -0.087> <-2.722, 0.403, -0.087> <-2.770, 0.431, -0.031> <-2.770, 0.431, -0.000> 
		<-2.095, 1.427, -0.127> <-2.170, 1.470, -0.127> <-2.205, 1.490, -0.086> <-2.205, 1.490, -0.000> 
		<-1.645, 2.206, -0.158> <-1.720, 2.249, -0.158> <-1.782, 2.285, -0.086> <-1.782, 2.285, -0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.782, 2.285, -0.000> <-1.782, 2.285, 0.086> <-1.720, 2.249, 0.158> <-1.645, 2.206, 0.158> 
		<-2.205, 1.490, -0.000> <-2.205, 1.490, 0.086> <-2.170, 1.470, 0.127> <-2.095, 1.427, 0.127> 
		<-2.770, 0.431, -0.000> <-2.770, 0.431, 0.031> <-2.722, 0.403, 0.087> <-2.695, 0.387, 0.087> 
		<-3.194, -0.364, -0.000> <-3.194, -0.364, 0.031> <-3.172, -0.377, 0.056> <-3.145, -0.392, 0.056> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.697, 2.183, 0.092> <-1.706, 2.134, 0.092> <-1.713, 2.093, 0.050> <-1.713, 2.093, -0.000> 
		<-0.810, 2.027, 0.122> <-0.819, 1.978, 0.122> <-0.832, 1.907, 0.050> <-0.832, 1.907, -0.000> 
		<0.371, 1.819, 0.162> <0.353, 1.715, 0.162> <0.343, 1.659, 0.105> <0.343, 1.659, 0.000> 
		<1.258, 1.662, 0.193> <1.239, 1.559, 0.193> <1.224, 1.472, 0.105> <1.224, 1.472, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.713, 2.093, -0.000> <-1.713, 2.093, -0.050> <-1.706, 2.134, -0.092> <-1.697, 2.183, -0.092> 
		<-0.832, 1.907, -0.000> <-0.832, 1.907, -0.050> <-0.819, 1.978, -0.122> <-0.810, 2.027, -0.122> 
		<0.343, 1.659, 0.000> <0.343, 1.659, -0.105> <0.353, 1.715, -0.162> <0.371, 1.819, -0.162> 
		<1.224, 1.472, 0.000> <1.224, 1.472, -0.105> <1.239, 1.559, -0.193> <1.258, 1.662, -0.193> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.697, 2.183, -0.092> <-1.688, 2.233, -0.092> <-1.681, 2.274, -0.050> <-1.681, 2.274, -0.000> 
		<-0.810, 2.027, -0.122> <-0.802, 2.076, -0.122> <-0.789, 2.147, -0.050> <-0.789, 2.147, -0.000> 
		<0.371, 1.819, -0.162> <0.390, 1.922, -0.162> <0.399, 1.979, -0.105> <0.399, 1.979, 0.000> 
		<1.258, 1.662, -0.193> <1.276, 1.766, -0.193> <1.291, 1.852, -0.105> <1.291, 1.852, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.291, 1.852, 0.000> <1.291, 1.852, 0.105> <1.276, 1.766, 0.193> <1.258, 1.662, 0.193> 
		<0.399, 1.979, 0.000> <0.399, 1.979, 0.105> <0.390, 1.922, 0.162> <0.371, 1.819, 0.162> 
		<-0.789, 2.147, -0.000> <-0.789, 2.147, 0.050> <-0.802, 2.076, 0.122> <-0.810, 2.027, 0.122> 
		<-1.681, 2.274, -0.000> <-1.681, 2.274, 0.050> <-1.688, 2.233, 0.092> <-1.697, 2.183, 0.092> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<8.234, -0.020, 0.057> <8.209, -0.038, 0.056> <8.189, -0.053, 0.030> <8.189, -0.054, -0.000> 
		<7.704, 0.708, 0.070> <7.679, 0.690, 0.069> <7.635, 0.657, 0.013> <7.636, 0.657, -0.018> 
		<6.998, 1.679, 0.087> <6.929, 1.629, 0.086> <6.896, 1.604, 0.044> <6.898, 1.604, -0.042> 
		<6.469, 2.408, 0.101> <6.399, 2.357, 0.099> <6.343, 2.314, 0.026> <6.345, 2.314, -0.060> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<8.189, -0.054, -0.000> <8.190, -0.054, -0.031> <8.211, -0.039, -0.056> <8.236, -0.021, -0.056> 
		<7.636, 0.657, -0.018> <7.637, 0.656, -0.049> <7.684, 0.689, -0.104> <7.708, 0.707, -0.104> 
		<6.898, 1.604, -0.042> <6.900, 1.603, -0.128> <6.935, 1.627, -0.169> <7.005, 1.678, -0.167> 
		<6.345, 2.314, -0.060> <6.347, 2.313, -0.146> <6.407, 2.355, -0.217> <6.477, 2.406, -0.215> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<8.236, -0.021, -0.056> <8.261, -0.003, -0.055> <8.281, 0.012, -0.029> <8.280, 0.013, 0.002> 
		<7.708, 0.707, -0.104> <7.733, 0.725, -0.103> <7.777, 0.758, -0.046> <7.777, 0.759, -0.015> 
		<7.005, 1.678, -0.167> <7.074, 1.728, -0.166> <7.107, 1.753, -0.124> <7.105, 1.754, -0.038> 
		<6.477, 2.406, -0.215> <6.547, 2.456, -0.214> <6.603, 2.499, -0.141> <6.601, 2.500, -0.055> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<6.601, 2.500, -0.055> <6.599, 2.500, 0.031> <6.539, 2.458, 0.102> <6.469, 2.408, 0.101> 
		<7.105, 1.754, -0.038> <7.103, 1.754, 0.048> <7.068, 1.730, 0.089> <6.998, 1.679, 0.087> 
		<7.777, 0.759, -0.015> <7.776, 0.759, 0.015> <7.729, 0.726, 0.070> <7.704, 0.708, 0.070> 
		<8.280, 0.013, 0.002> <8.280, 0.013, 0.032> <8.258, -0.002, 0.057> <8.234, -0.020, 0.057> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<6.525, 2.390, 0.036> <6.538, 2.342, 0.036> <6.551, 2.302, -0.005> <6.552, 2.301, -0.055> 
		<5.659, 2.142, 0.047> <5.673, 2.094, 0.047> <5.694, 2.025, -0.024> <5.695, 2.024, -0.074> 
		<4.505, 1.812, 0.061> <4.534, 1.711, 0.062> <4.551, 1.656, 0.006> <4.553, 1.655, -0.099> 
		<3.639, 1.564, 0.072> <3.668, 1.463, 0.073> <3.694, 1.379, -0.013> <3.697, 1.378, -0.118> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<6.552, 2.301, -0.055> <6.553, 2.301, -0.105> <6.543, 2.341, -0.147> <6.529, 2.389, -0.148> 
		<5.695, 2.024, -0.074> <5.697, 2.024, -0.124> <5.679, 2.093, -0.197> <5.665, 2.141, -0.197> 
		<4.553, 1.655, -0.099> <4.556, 1.654, -0.204> <4.541, 1.709, -0.262> <4.512, 1.810, -0.264> 
		<3.697, 1.378, -0.118> <3.699, 1.377, -0.223> <3.677, 1.461, -0.312> <3.648, 1.562, -0.313> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<6.529, 2.389, -0.148> <6.515, 2.437, -0.148> <6.503, 2.477, -0.107> <6.502, 2.478, -0.057> 
		<5.665, 2.141, -0.197> <5.651, 2.189, -0.198> <5.629, 2.259, -0.127> <5.628, 2.259, -0.077> 
		<4.512, 1.810, -0.264> <4.484, 1.911, -0.265> <4.466, 1.967, -0.209> <4.464, 1.967, -0.103> 
		<3.648, 1.562, -0.313> <3.619, 1.663, -0.315> <3.593, 1.748, -0.228> <3.591, 1.749, -0.123> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.591, 1.749, -0.123> <3.588, 1.749, -0.018> <3.610, 1.666, 0.071> <3.639, 1.564, 0.072> 
		<4.464, 1.967, -0.103> <4.461, 1.968, 0.002> <4.476, 1.913, 0.060> <4.505, 1.812, 0.061> 
		<5.628, 2.259, -0.077> <5.627, 2.259, -0.027> <5.645, 2.191, 0.046> <5.659, 2.142, 0.047> 
		<6.502, 2.478, -0.057> <6.500, 2.478, -0.007> <6.511, 2.438, 0.035> <6.525, 2.390, 0.036> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<6.601, -0.051, -0.704> <6.576, -0.068, -0.701> <6.553, -0.085, -0.724> <6.552, -0.087, -0.755> 
		<6.415, 0.891, -0.744> <6.389, 0.874, -0.741> <6.340, 0.838, -0.791> <6.338, 0.836, -0.822> 
		<6.166, 2.148, -0.796> <6.095, 2.100, -0.788> <6.058, 2.074, -0.825> <6.054, 2.066, -0.911> 
		<5.980, 3.091, -0.835> <5.908, 3.043, -0.827> <5.845, 2.997, -0.892> <5.841, 2.989, -0.978> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<6.552, -0.087, -0.755> <6.550, -0.090, -0.785> <6.570, -0.078, -0.813> <6.595, -0.061, -0.816> 
		<6.338, 0.836, -0.822> <6.337, 0.833, -0.852> <6.380, 0.859, -0.913> <6.405, 0.876, -0.916> 
		<6.054, 2.066, -0.911> <6.049, 2.058, -0.997> <6.081, 2.078, -1.041> <6.152, 2.125, -1.050> 
		<5.841, 2.989, -0.978> <5.836, 2.981, -1.063> <5.891, 3.015, -1.142> <5.963, 3.063, -1.150> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<6.595, -0.061, -0.816> <6.620, -0.044, -0.819> <6.643, -0.028, -0.796> <6.645, -0.025, -0.765> 
		<6.405, 0.876, -0.916> <6.431, 0.893, -0.919> <6.480, 0.929, -0.869> <6.482, 0.932, -0.838> 
		<6.152, 2.125, -1.050> <6.224, 2.173, -1.058> <6.260, 2.200, -1.021> <6.265, 2.208, -0.935> 
		<5.963, 3.063, -1.150> <6.034, 3.110, -1.158> <6.097, 3.157, -1.093> <6.102, 3.164, -1.008> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<6.102, 3.164, -1.008> <6.106, 3.172, -0.922> <6.051, 3.139, -0.844> <5.980, 3.091, -0.835> 
		<6.265, 2.208, -0.935> <6.269, 2.215, -0.849> <6.237, 2.196, -0.804> <6.166, 2.148, -0.796> 
		<6.482, 0.932, -0.838> <6.483, 0.935, -0.808> <6.440, 0.908, -0.746> <6.415, 0.891, -0.744> 
		<6.645, -0.025, -0.765> <6.646, -0.022, -0.735> <6.627, -0.034, -0.707> <6.601, -0.051, -0.704> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<6.029, 3.066, -0.903> <6.042, 3.017, -0.899> <6.049, 2.973, -0.937> <6.047, 2.969, -0.987> 
		<5.293, 2.676, -0.776> <5.306, 2.627, -0.772> <5.319, 2.551, -0.838> <5.317, 2.547, -0.888> 
		<4.312, 2.155, -0.607> <4.338, 2.054, -0.599> <4.349, 1.993, -0.652> <4.343, 1.984, -0.757> 
		<3.576, 1.765, -0.480> <3.602, 1.663, -0.473> <3.618, 1.571, -0.553> <3.613, 1.561, -0.658> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<6.047, 2.969, -0.987> <6.044, 2.964, -1.037> <6.032, 3.001, -1.081> <6.019, 3.049, -1.085> 
		<5.317, 2.547, -0.888> <5.314, 2.542, -0.938> <5.292, 2.605, -1.015> <5.280, 2.654, -1.019> 
		<4.343, 1.984, -0.757> <4.337, 1.974, -0.861> <4.320, 2.024, -0.922> <4.295, 2.126, -0.930> 
		<3.613, 1.561, -0.658> <3.607, 1.552, -0.762> <3.581, 1.629, -0.856> <3.555, 1.730, -0.864> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<6.019, 3.049, -1.085> <6.007, 3.098, -1.089> <5.999, 3.142, -1.050> <6.002, 3.146, -1.001> 
		<5.280, 2.654, -1.019> <5.268, 2.702, -1.022> <5.254, 2.778, -0.956> <5.257, 2.783, -0.906> 
		<4.295, 2.126, -0.930> <4.269, 2.228, -0.938> <4.258, 2.288, -0.885> <4.264, 2.298, -0.781> 
		<3.555, 1.730, -0.864> <3.530, 1.832, -0.872> <3.513, 1.925, -0.791> <3.519, 1.934, -0.686> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.519, 1.934, -0.686> <3.524, 1.944, -0.582> <3.550, 1.867, -0.488> <3.576, 1.765, -0.480> 
		<4.264, 2.298, -0.781> <4.269, 2.307, -0.676> <4.286, 2.257, -0.615> <4.312, 2.155, -0.607> 
		<5.257, 2.783, -0.906> <5.260, 2.787, -0.857> <5.281, 2.724, -0.780> <5.293, 2.676, -0.776> 
		<6.002, 3.146, -1.001> <6.005, 3.151, -0.951> <6.017, 3.114, -0.906> <6.029, 3.066, -0.903> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<8.189, 0.032, 1.134> <8.165, 0.013, 1.129> <8.141, -0.004, 1.151> <8.137, -0.005, 1.181> 
		<7.644, 0.746, 1.066> <7.620, 0.727, 1.061> <7.569, 0.690, 1.109> <7.564, 0.688, 1.139> 
		<6.918, 1.698, 0.975> <6.851, 1.645, 0.963> <6.813, 1.618, 0.998> <6.801, 1.613, 1.083> 
		<6.373, 2.412, 0.907> <6.306, 2.359, 0.895> <6.240, 2.312, 0.956> <6.228, 2.307, 1.041> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<8.137, -0.005, 1.181> <8.133, -0.007, 1.212> <8.149, 0.007, 1.241> <8.173, 0.026, 1.245> 
		<7.564, 0.688, 1.139> <7.560, 0.687, 1.170> <7.596, 0.718, 1.233> <7.620, 0.736, 1.237> 
		<6.801, 1.613, 1.083> <6.789, 1.609, 1.168> <6.815, 1.632, 1.215> <6.883, 1.684, 1.227> 
		<6.228, 2.307, 1.041> <6.216, 2.302, 1.126> <6.262, 2.342, 1.207> <6.330, 2.395, 1.220> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<8.173, 0.026, 1.245> <8.197, 0.044, 1.249> <8.221, 0.061, 1.228> <8.225, 0.063, 1.197> 
		<7.620, 0.736, 1.237> <7.644, 0.755, 1.242> <7.696, 0.792, 1.194> <7.700, 0.794, 1.164> 
		<6.883, 1.684, 1.227> <6.950, 1.737, 1.239> <6.988, 1.764, 1.204> <7.000, 1.768, 1.119> 
		<6.330, 2.395, 1.220> <6.397, 2.447, 1.232> <6.463, 2.495, 1.171> <6.475, 2.499, 1.086> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<6.475, 2.499, 1.086> <6.487, 2.504, 1.000> <6.441, 2.464, 0.919> <6.373, 2.412, 0.907> 
		<7.000, 1.768, 1.119> <7.012, 1.773, 1.034> <6.985, 1.750, 0.987> <6.918, 1.698, 0.975> 
		<7.700, 0.794, 1.164> <7.704, 0.796, 1.133> <7.668, 0.764, 1.070> <7.644, 0.746, 1.066> 
		<8.225, 0.063, 1.197> <8.229, 0.065, 1.167> <8.213, 0.050, 1.138> <8.189, 0.032, 1.134> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<6.418, 2.392, 0.979> <6.433, 2.345, 0.979> <6.440, 2.303, 1.020> <6.434, 2.300, 1.069> 
		<5.574, 2.123, 0.817> <5.590, 2.075, 0.816> <5.602, 2.003, 0.887> <5.595, 2.000, 0.936> 
		<4.450, 1.763, 0.600> <4.482, 1.663, 0.599> <4.491, 1.605, 0.655> <4.477, 1.600, 0.759> 
		<3.606, 1.493, 0.437> <3.638, 1.393, 0.436> <3.653, 1.305, 0.522> <3.638, 1.300, 0.626> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<6.434, 2.300, 1.069> <6.427, 2.297, 1.119> <6.408, 2.335, 1.160> <6.393, 2.383, 1.161> 
		<5.595, 2.000, 0.936> <5.588, 1.997, 0.986> <5.556, 2.062, 1.058> <5.541, 2.110, 1.058> 
		<4.477, 1.600, 0.759> <4.462, 1.594, 0.863> <4.437, 1.646, 0.920> <4.405, 1.746, 0.921> 
		<3.638, 1.300, 0.626> <3.624, 1.294, 0.730> <3.585, 1.373, 0.818> <3.553, 1.473, 0.819> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<6.393, 2.383, 1.161> <6.378, 2.430, 1.161> <6.371, 2.472, 1.120> <6.377, 2.475, 1.071> 
		<5.541, 2.110, 1.058> <5.526, 2.157, 1.059> <5.513, 2.230, 0.988> <5.520, 2.232, 0.939> 
		<4.405, 1.746, 0.921> <4.373, 1.846, 0.922> <4.363, 1.903, 0.866> <4.377, 1.909, 0.762> 
		<3.553, 1.473, 0.819> <3.521, 1.573, 0.820> <3.506, 1.661, 0.734> <3.520, 1.667, 0.630> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.520, 1.667, 0.630> <3.535, 1.672, 0.526> <3.574, 1.594, 0.438> <3.606, 1.493, 0.437> 
		<4.377, 1.909, 0.762> <4.392, 1.915, 0.658> <4.417, 1.863, 0.601> <4.450, 1.763, 0.600> 
		<5.520, 2.232, 0.939> <5.527, 2.235, 0.889> <5.559, 2.170, 0.817> <5.574, 2.123, 0.817> 
		<6.377, 2.475, 1.071> <6.384, 2.477, 1.021> <6.403, 2.440, 0.980> <6.418, 2.392, 0.979> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.183, -0.324, -0.756> <-3.157, -0.340, -0.753> <-3.134, -0.355, -0.776> <-3.132, -0.358, -0.807> 
		<-2.720, 0.448, -0.766> <-2.694, 0.432, -0.763> <-2.643, 0.399, -0.813> <-2.641, 0.396, -0.844> 
		<-2.103, 1.478, -0.778> <-2.029, 1.434, -0.770> <-1.992, 1.409, -0.807> <-1.987, 1.402, -0.893> 
		<-1.640, 2.250, -0.788> <-1.567, 2.206, -0.780> <-1.501, 2.163, -0.844> <-1.496, 2.156, -0.930> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.132, -0.358, -0.807> <-3.130, -0.361, -0.838> <-3.150, -0.350, -0.865> <-3.177, -0.334, -0.868> 
		<-2.641, 0.396, -0.844> <-2.639, 0.394, -0.874> <-2.684, 0.417, -0.935> <-2.710, 0.433, -0.938> 
		<-1.987, 1.402, -0.893> <-1.982, 1.394, -0.979> <-2.015, 1.412, -1.024> <-2.088, 1.456, -1.032> 
		<-1.496, 2.156, -0.930> <-1.491, 2.148, -1.016> <-1.548, 2.179, -1.094> <-1.622, 2.223, -1.102> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-3.177, -0.334, -0.868> <-3.203, -0.318, -0.871> <-3.226, -0.303, -0.848> <-3.228, -0.300, -0.818> 
		<-2.710, 0.433, -0.938> <-2.736, 0.449, -0.941> <-2.788, 0.482, -0.891> <-2.789, 0.485, -0.860> 
		<-2.088, 1.456, -1.032> <-2.162, 1.500, -1.040> <-2.200, 1.525, -1.003> <-2.205, 1.532, -0.917> 
		<-1.622, 2.223, -1.102> <-1.695, 2.267, -1.110> <-1.761, 2.310, -1.046> <-1.766, 2.317, -0.960> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.766, 2.317, -0.960> <-1.771, 2.325, -0.874> <-1.714, 2.294, -0.796> <-1.640, 2.250, -0.788> 
		<-2.205, 1.532, -0.917> <-2.210, 1.539, -0.831> <-2.177, 1.522, -0.786> <-2.103, 1.478, -0.778> 
		<-2.789, 0.485, -0.860> <-2.791, 0.488, -0.830> <-2.747, 0.464, -0.769> <-2.720, 0.448, -0.766> 
		<-3.228, -0.300, -0.818> <-3.230, -0.298, -0.787> <-3.210, -0.309, -0.759> <-3.183, -0.324, -0.756> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.689, 2.223, -0.855> <-1.698, 2.174, -0.851> <-1.704, 2.129, -0.889> <-1.701, 2.125, -0.939> 
		<-0.809, 2.056, -0.758> <-0.818, 2.007, -0.754> <-0.828, 1.931, -0.821> <-0.825, 1.926, -0.870> 
		<0.364, 1.835, -0.629> <0.344, 1.732, -0.621> <0.336, 1.671, -0.674> <0.342, 1.662, -0.779> 
		<1.244, 1.669, -0.533> <1.224, 1.566, -0.525> <1.212, 1.472, -0.605> <1.218, 1.463, -0.710> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.701, 2.125, -0.939> <-1.698, 2.121, -0.989> <-1.687, 2.158, -1.034> <-1.678, 2.207, -1.037> 
		<-0.825, 1.926, -0.870> <-0.822, 1.922, -0.920> <-0.804, 1.986, -0.997> <-0.795, 2.035, -1.001> 
		<0.342, 1.662, -0.779> <0.348, 1.653, -0.883> <0.363, 1.704, -0.945> <0.383, 1.807, -0.952> 
		<1.218, 1.463, -0.710> <1.224, 1.454, -0.815> <1.246, 1.532, -0.908> <1.266, 1.635, -0.916> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.678, 2.207, -1.037> <-1.668, 2.256, -1.041> <-1.663, 2.300, -1.003> <-1.665, 2.304, -0.953> 
		<-0.795, 2.035, -1.001> <-0.785, 2.084, -1.005> <-0.775, 2.161, -0.938> <-0.778, 2.165, -0.889> 
		<0.383, 1.807, -0.952> <0.403, 1.910, -0.960> <0.411, 1.971, -0.907> <0.405, 1.980, -0.803> 
		<1.266, 1.635, -0.916> <1.287, 1.738, -0.924> <1.299, 1.831, -0.843> <1.292, 1.841, -0.739> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.292, 1.841, -0.739> <1.286, 1.850, -0.634> <1.264, 1.772, -0.540> <1.244, 1.669, -0.533> 
		<0.405, 1.980, -0.803> <0.399, 1.989, -0.698> <0.384, 1.938, -0.637> <0.364, 1.835, -0.629> 
		<-0.778, 2.165, -0.889> <-0.781, 2.170, -0.839> <-0.799, 2.105, -0.762> <-0.809, 2.056, -0.758> 
		<-1.665, 2.304, -0.953> <-1.668, 2.309, -0.903> <-1.679, 2.272, -0.859> <-1.689, 2.223, -0.855> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.961, -0.461, 2.228> <-1.937, -0.479, 2.220> <-1.926, -0.494, 2.189> <-1.936, -0.494, 2.160> 
		<-1.685, 0.457, 2.091> <-1.662, 0.439, 2.082> <-1.637, 0.406, 2.014> <-1.647, 0.406, 1.985> 
		<-1.318, 1.680, 1.907> <-1.252, 1.629, 1.884> <-1.234, 1.605, 1.834> <-1.262, 1.606, 1.752> 
		<-1.042, 2.598, 1.769> <-0.977, 2.547, 1.746> <-0.946, 2.505, 1.659> <-0.973, 2.505, 1.577> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.936, -0.494, 2.160> <-1.946, -0.493, 2.131> <-1.974, -0.478, 2.114> <-1.997, -0.460, 2.122> 
		<-1.647, 0.406, 1.985> <-1.657, 0.406, 1.956> <-1.718, 0.440, 1.918> <-1.741, 0.458, 1.926> 
		<-1.262, 1.606, 1.752> <-1.290, 1.606, 1.671> <-1.335, 1.631, 1.642> <-1.400, 1.682, 1.665> 
		<-0.973, 2.505, 1.577> <-1.001, 2.506, 1.496> <-1.079, 2.549, 1.447> <-1.144, 2.601, 1.470> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.997, -0.460, 2.122> <-2.020, -0.441, 2.130> <-2.032, -0.427, 2.161> <-2.022, -0.427, 2.190> 
		<-1.741, 0.458, 1.926> <-1.765, 0.477, 1.934> <-1.789, 0.509, 2.002> <-1.779, 0.509, 2.031> 
		<-1.400, 1.682, 1.665> <-1.466, 1.734, 1.688> <-1.484, 1.758, 1.738> <-1.456, 1.757, 1.820> 
		<-1.144, 2.601, 1.470> <-1.210, 2.652, 1.492> <-1.241, 2.694, 1.579> <-1.213, 2.693, 1.661> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.213, 2.693, 1.661> <-1.186, 2.692, 1.743> <-1.108, 2.649, 1.791> <-1.042, 2.598, 1.769> 
		<-1.456, 1.757, 1.820> <-1.428, 1.756, 1.901> <-1.383, 1.732, 1.929> <-1.318, 1.680, 1.907> 
		<-1.779, 0.509, 2.031> <-1.769, 0.509, 2.060> <-1.709, 0.475, 2.099> <-1.685, 0.457, 2.091> 
		<-2.022, -0.427, 2.190> <-2.012, -0.427, 2.219> <-1.984, -0.442, 2.237> <-1.961, -0.461, 2.228> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.115, 2.582, 1.723> <-1.129, 2.534, 1.727> <-1.153, 2.494, 1.691> <-1.169, 2.494, 1.644> 
		<-0.337, 2.311, 1.471> <-0.351, 2.263, 1.475> <-0.394, 2.194, 1.413> <-0.410, 2.195, 1.366> 
		<0.699, 1.949, 1.135> <0.671, 1.849, 1.144> <0.637, 1.794, 1.094> <0.603, 1.795, 0.995> 
		<1.477, 1.678, 0.882> <1.449, 1.578, 0.891> <1.397, 1.494, 0.816> <1.363, 1.495, 0.716> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.169, 2.494, 1.644> <-1.186, 2.495, 1.597> <-1.188, 2.535, 1.554> <-1.174, 2.583, 1.550> 
		<-0.410, 2.195, 1.366> <-0.426, 2.195, 1.318> <-0.430, 2.265, 1.244> <-0.416, 2.313, 1.240> 
		<0.603, 1.795, 0.995> <0.569, 1.796, 0.895> <0.566, 1.851, 0.836> <0.594, 1.952, 0.827> 
		<1.363, 1.495, 0.716> <1.329, 1.496, 0.617> <1.324, 1.581, 0.526> <1.352, 1.682, 0.518> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.174, 2.583, 1.550> <-1.161, 2.631, 1.545> <-1.136, 2.671, 1.581> <-1.120, 2.670, 1.629> 
		<-0.416, 2.313, 1.240> <-0.403, 2.361, 1.236> <-0.360, 2.429, 1.298> <-0.344, 2.429, 1.345> 
		<0.594, 1.952, 0.827> <0.623, 2.053, 0.818> <0.657, 2.108, 0.868> <0.691, 2.107, 0.967> 
		<1.352, 1.682, 0.518> <1.381, 1.783, 0.509> <1.433, 1.866, 0.584> <1.467, 1.865, 0.684> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.467, 1.865, 0.684> <1.501, 1.864, 0.784> <1.505, 1.779, 0.874> <1.477, 1.678, 0.882> 
		<0.691, 2.107, 0.967> <0.725, 2.106, 1.067> <0.728, 2.050, 1.126> <0.699, 1.949, 1.135> 
		<-0.344, 2.429, 1.345> <-0.328, 2.428, 1.393> <-0.324, 2.359, 1.467> <-0.337, 2.311, 1.471> 
		<-1.120, 2.670, 1.629> <-1.104, 2.670, 1.676> <-1.101, 2.630, 1.719> <-1.115, 2.582, 1.723> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.782, 1.688, -4.743> <-1.761, 1.666, -4.740> <-1.728, 1.659, -4.754> <-1.709, 1.674, -4.773> 
		<-1.435, 2.111, -4.028> <-1.414, 2.089, -4.025> <-1.341, 2.075, -4.054> <-1.323, 2.090, -4.074> 
		<-0.971, 2.675, -3.075> <-0.913, 2.612, -3.066> <-0.860, 2.602, -3.088> <-0.807, 2.644, -3.142> 
		<-0.624, 3.098, -2.360> <-0.566, 3.035, -2.351> <-0.473, 3.018, -2.389> <-0.420, 3.059, -2.443> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.709, 1.674, -4.773> <-1.691, 1.689, -4.792> <-1.692, 1.720, -4.811> <-1.713, 1.742, -4.814> 
		<-1.323, 2.090, -4.074> <-1.304, 2.104, -4.093> <-1.307, 2.172, -4.134> <-1.328, 2.195, -4.137> 
		<-0.807, 2.644, -3.142> <-0.754, 2.685, -3.196> <-0.757, 2.735, -3.226> <-0.815, 2.798, -3.234> 
		<-0.420, 3.059, -2.443> <-0.367, 3.101, -2.496> <-0.372, 3.188, -2.549> <-0.431, 3.251, -2.557> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.713, 1.742, -4.814> <-1.734, 1.765, -4.817> <-1.767, 1.771, -4.803> <-1.786, 1.756, -4.784> 
		<-1.328, 2.195, -4.137> <-1.349, 2.217, -4.140> <-1.421, 2.231, -4.111> <-1.440, 2.216, -4.091> 
		<-0.815, 2.798, -3.234> <-0.874, 2.861, -3.243> <-0.927, 2.871, -3.221> <-0.980, 2.829, -3.167> 
		<-0.431, 3.251, -2.557> <-0.489, 3.313, -2.566> <-0.582, 3.331, -2.529> <-0.635, 3.289, -2.475> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.635, 3.289, -2.475> <-0.687, 3.248, -2.421> <-0.683, 3.161, -2.368> <-0.624, 3.098, -2.360> 
		<-0.980, 2.829, -3.167> <-1.033, 2.788, -3.113> <-1.030, 2.738, -3.083> <-0.971, 2.675, -3.075> 
		<-1.440, 2.216, -4.091> <-1.459, 2.201, -4.072> <-1.455, 2.133, -4.031> <-1.435, 2.111, -4.028> 
		<-1.786, 1.756, -4.784> <-1.804, 1.741, -4.765> <-1.803, 1.710, -4.746> <-1.782, 1.688, -4.743> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.625, 3.132, -2.440> <-0.632, 3.097, -2.474> <-0.613, 3.088, -2.529> <-0.582, 3.112, -2.561> 
		<0.055, 2.651, -2.097> <0.048, 2.616, -2.132> <0.081, 2.600, -2.226> <0.111, 2.624, -2.258> 
		<0.962, 2.011, -1.640> <0.946, 1.936, -1.713> <0.972, 1.923, -1.788> <1.037, 1.974, -1.854> 
		<1.642, 1.530, -1.297> <1.626, 1.456, -1.370> <1.666, 1.436, -1.485> <1.731, 1.487, -1.551> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.582, 3.112, -2.561> <-0.552, 3.136, -2.592> <-0.520, 3.185, -2.589> <-0.513, 3.221, -2.555> 
		<0.111, 2.624, -2.258> <0.142, 2.648, -2.289> <0.197, 2.734, -2.284> <0.205, 2.769, -2.250> 
		<1.037, 1.974, -1.854> <1.101, 2.025, -1.920> <1.145, 2.093, -1.916> <1.161, 2.167, -1.843> 
		<1.731, 1.487, -1.551> <1.795, 1.538, -1.617> <1.862, 1.642, -1.611> <1.878, 1.716, -1.538> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.513, 3.221, -2.555> <-0.505, 3.256, -2.520> <-0.524, 3.265, -2.465> <-0.555, 3.241, -2.434> 
		<0.205, 2.769, -2.250> <0.212, 2.805, -2.215> <0.179, 2.821, -2.120> <0.148, 2.797, -2.089> 
		<1.161, 2.167, -1.843> <1.176, 2.242, -1.770> <1.150, 2.255, -1.695> <1.086, 2.204, -1.629> 
		<1.878, 1.716, -1.538> <1.894, 1.790, -1.465> <1.853, 1.810, -1.350> <1.789, 1.759, -1.284> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.789, 1.759, -1.284> <1.724, 1.708, -1.218> <1.657, 1.604, -1.224> <1.642, 1.530, -1.297> 
		<1.086, 2.204, -1.629> <1.021, 2.153, -1.563> <0.977, 2.085, -1.567> <0.962, 2.011, -1.640> 
		<0.148, 2.797, -2.089> <0.118, 2.772, -2.058> <0.063, 2.687, -2.062> <0.055, 2.651, -2.097> 
		<-0.555, 3.241, -2.434> <-0.586, 3.217, -2.402> <-0.617, 3.168, -2.405> <-0.625, 3.132, -2.440> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<7.753, -0.085, -2.471> <7.729, -0.103, -2.467> <7.702, -0.116, -2.487> <7.695, -0.114, -2.517> 
		<7.262, 0.639, -2.258> <7.237, 0.621, -2.254> <7.179, 0.592, -2.299> <7.171, 0.595, -2.329> 
		<6.607, 1.604, -1.974> <6.538, 1.554, -1.961> <6.495, 1.533, -1.994> <6.474, 1.539, -2.078> 
		<6.115, 2.328, -1.761> <6.047, 2.278, -1.748> <5.972, 2.241, -1.806> <5.951, 2.248, -1.890> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<7.695, -0.114, -2.517> <7.687, -0.111, -2.547> <7.701, -0.094, -2.575> <7.726, -0.076, -2.580> 
		<7.171, 0.595, -2.329> <7.164, 0.597, -2.358> <7.195, 0.634, -2.421> <7.219, 0.652, -2.426> 
		<6.474, 1.539, -2.078> <6.453, 1.546, -2.161> <6.476, 1.573, -2.207> <6.544, 1.624, -2.221> 
		<5.951, 2.248, -1.890> <5.930, 2.254, -1.973> <5.970, 2.302, -2.054> <6.038, 2.352, -2.067> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<7.726, -0.076, -2.580> <7.750, -0.058, -2.585> <7.777, -0.045, -2.564> <7.784, -0.048, -2.534> 
		<7.219, 0.652, -2.426> <7.244, 0.670, -2.431> <7.302, 0.699, -2.385> <7.310, 0.696, -2.356> 
		<6.544, 1.624, -2.221> <6.613, 1.674, -2.234> <6.656, 1.695, -2.201> <6.677, 1.689, -2.117> 
		<6.038, 2.352, -2.067> <6.107, 2.403, -2.080> <6.181, 2.440, -2.022> <6.202, 2.433, -1.939> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<6.202, 2.433, -1.939> <6.224, 2.426, -1.855> <6.184, 2.379, -1.775> <6.115, 2.328, -1.761> 
		<6.677, 1.689, -2.117> <6.698, 1.682, -2.034> <6.675, 1.655, -1.988> <6.607, 1.604, -1.974> 
		<7.310, 0.696, -2.356> <7.317, 0.694, -2.326> <7.286, 0.657, -2.263> <7.262, 0.639, -2.258> 
		<7.784, -0.048, -2.534> <7.792, -0.050, -2.505> <7.778, -0.067, -2.476> <7.753, -0.085, -2.471> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<6.151, 2.316, -1.840> <6.164, 2.268, -1.847> <6.164, 2.232, -1.893> <6.151, 2.235, -1.941> 
		<5.315, 2.067, -1.617> <5.327, 2.019, -1.624> <5.328, 1.956, -1.703> <5.315, 1.960, -1.752> 
		<4.200, 1.735, -1.320> <4.226, 1.634, -1.334> <4.227, 1.584, -1.397> <4.201, 1.592, -1.499> 
		<3.364, 1.486, -1.097> <3.390, 1.385, -1.111> <3.390, 1.308, -1.208> <3.365, 1.316, -1.310> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<6.151, 2.235, -1.941> <6.139, 2.239, -1.990> <6.119, 2.282, -2.024> <6.106, 2.330, -2.017> 
		<5.315, 1.960, -1.752> <5.303, 1.963, -1.800> <5.268, 2.038, -1.860> <5.255, 2.086, -1.853> 
		<4.201, 1.592, -1.499> <4.175, 1.600, -1.601> <4.147, 1.659, -1.648> <4.121, 1.760, -1.634> 
		<3.365, 1.316, -1.310> <3.339, 1.324, -1.411> <3.296, 1.415, -1.484> <3.270, 1.515, -1.469> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<6.106, 2.330, -2.017> <6.094, 2.378, -2.010> <6.094, 2.415, -1.964> <6.106, 2.411, -1.916> 
		<5.255, 2.086, -1.853> <5.243, 2.134, -1.846> <5.243, 2.197, -1.766> <5.255, 2.193, -1.718> 
		<4.121, 1.760, -1.634> <4.095, 1.861, -1.619> <4.094, 1.911, -1.556> <4.120, 1.903, -1.454> 
		<3.270, 1.515, -1.469> <3.244, 1.616, -1.455> <3.243, 1.694, -1.358> <3.269, 1.685, -1.256> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.269, 1.685, -1.256> <3.295, 1.677, -1.154> <3.338, 1.587, -1.082> <3.364, 1.486, -1.097> 
		<4.120, 1.903, -1.454> <4.146, 1.895, -1.352> <4.174, 1.836, -1.305> <4.200, 1.735, -1.320> 
		<5.255, 2.193, -1.718> <5.267, 2.190, -1.670> <5.303, 2.115, -1.610> <5.315, 2.067, -1.617> 
		<6.106, 2.411, -1.916> <6.118, 2.407, -1.868> <6.139, 2.364, -1.833> <6.151, 2.316, -1.840> 
	}
	

}

#declare body =
union{
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.050, 1.684, -0.027> <1.050, 2.378, -0.027> <1.846, 2.723, -0.027> <2.540, 2.723, -0.027> 
		<1.050, 1.684, -0.027> <1.050, 2.378, -0.951> <1.846, 2.723, -0.856> <2.540, 2.723, -0.856> 
		<1.050, 1.684, -0.027> <1.050, 2.378, -0.951> <1.615, 2.514, -1.934> <2.540, 2.514, -1.934> 
		<1.050, 1.684, -0.027> <1.050, 1.684, -0.951> <1.615, 1.684, -1.934> <2.540, 1.684, -1.934> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.050, 1.684, -0.027> <1.050, 2.378, -0.027> <1.846, 2.723, -0.027> <2.540, 2.723, -0.027> 
		<1.050, 1.684, -0.027> <1.050, 2.378, 0.898> <1.846, 2.723, 0.803> <2.540, 2.723, 0.803> 
		<1.050, 1.684, -0.027> <1.050, 2.378, 0.898> <1.615, 2.514, 1.881> <2.540, 2.514, 1.881> 
		<1.050, 1.684, -0.027> <1.050, 1.684, 0.898> <1.615, 1.684, 1.881> <2.540, 1.684, 1.881> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.540, 2.723, -0.027> <3.234, 2.723, -0.027> <4.030, 2.378, -0.027> <4.030, 1.684, -0.027> 
		<2.540, 2.723, -0.027> <3.234, 2.723, 0.803> <4.030, 2.378, 0.898> <4.030, 1.684, 0.898> 
		<2.540, 2.723, -0.027> <3.234, 2.723, 0.803> <3.464, 2.514, 1.881> <3.464, 1.684, 1.881> 
		<2.540, 2.723, -0.027> <2.540, 2.723, 0.803> <2.540, 2.514, 1.881> <2.540, 1.684, 1.881> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.540, 2.723, -0.027> <3.234, 2.723, -0.027> <4.030, 2.378, -0.027> <4.030, 1.684, -0.027> 
		<2.540, 2.723, -0.027> <3.234, 2.723, -0.856> <4.030, 2.378, -0.951> <4.030, 1.684, -0.951> 
		<2.540, 2.723, -0.027> <3.234, 2.723, -0.856> <3.464, 2.514, -1.934> <3.464, 1.684, -1.934> 
		<2.540, 2.723, -0.027> <2.540, 2.723, -0.856> <2.540, 2.514, -1.934> <2.540, 1.684, -1.934> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.030, 1.684, -0.027> <4.030, 0.990, -0.027> <3.234, 0.645, -0.027> <2.540, 0.645, -0.027> 
		<4.030, 1.684, -0.027> <4.030, 0.990, 0.898> <3.234, 0.645, 0.803> <2.540, 0.645, 0.803> 
		<4.030, 1.684, -0.027> <4.030, 0.990, 0.898> <3.464, 0.855, 1.881> <2.540, 0.855, 1.881> 
		<4.030, 1.684, -0.027> <4.030, 1.684, 0.898> <3.464, 1.684, 1.881> <2.540, 1.684, 1.881> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.030, 1.684, -0.027> <4.030, 0.990, -0.027> <3.234, 0.645, -0.027> <2.540, 0.645, -0.027> 
		<4.030, 1.684, -0.027> <4.030, 0.990, -0.951> <3.234, 0.645, -0.856> <2.540, 0.645, -0.856> 
		<4.030, 1.684, -0.027> <4.030, 0.990, -0.951> <3.464, 0.855, -1.934> <2.540, 0.855, -1.934> 
		<4.030, 1.684, -0.027> <4.030, 1.684, -0.951> <3.464, 1.684, -1.934> <2.540, 1.684, -1.934> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.540, 0.645, -0.027> <1.846, 0.645, -0.027> <1.050, 0.990, -0.027> <1.050, 1.684, -0.027> 
		<2.540, 0.645, -0.027> <1.846, 0.645, -0.856> <1.050, 0.990, -0.951> <1.050, 1.684, -0.951> 
		<2.540, 0.645, -0.027> <1.846, 0.645, -0.856> <1.615, 0.855, -1.934> <1.615, 1.684, -1.934> 
		<2.540, 0.645, -0.027> <2.540, 0.645, -0.856> <2.540, 0.855, -1.934> <2.540, 1.684, -1.934> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.540, 0.645, -0.027> <1.846, 0.645, -0.027> <1.050, 0.990, -0.027> <1.050, 1.684, -0.027> 
		<2.540, 0.645, -0.027> <1.846, 0.645, 0.803> <1.050, 0.990, 0.898> <1.050, 1.684, 0.898> 
		<2.540, 0.645, -0.027> <1.846, 0.645, 0.803> <1.615, 0.855, 1.881> <1.615, 1.684, 1.881> 
		<2.540, 0.645, -0.027> <2.540, 0.645, 0.803> <2.540, 0.855, 1.881> <2.540, 1.684, 1.881> 
	}
	

}

#declare hydro =
union{
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.041, 2.203, -0.026> <1.041, 2.203, 0.047> <1.039, 2.264, 0.108> <1.036, 2.337, 0.108> 
		<1.041, 2.203, -0.026> <1.041, 2.203, -0.026> <1.039, 2.264, 0.028> <1.036, 2.337, 0.028> 
		<1.041, 2.203, -0.026> <1.041, 2.203, -0.026> <1.039, 2.264, -0.080> <1.036, 2.337, -0.080> 
		<1.041, 2.203, -0.026> <1.041, 2.203, -0.099> <1.039, 2.264, -0.160> <1.036, 2.337, -0.160> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.036, 2.337, 0.108> <1.033, 2.411, 0.108> <1.031, 2.471, 0.047> <1.031, 2.471, -0.026> 
		<1.036, 2.337, 0.108> <1.033, 2.411, 0.028> <1.031, 2.471, -0.026> <1.031, 2.471, -0.099> 
		<1.036, 2.337, 0.108> <1.033, 2.411, 0.028> <1.033, 2.411, -0.080> <1.033, 2.411, -0.160> 
		<1.036, 2.337, 0.108> <1.036, 2.337, 0.028> <1.036, 2.337, -0.080> <1.036, 2.337, -0.160> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.070, 2.169, -0.026> <0.070, 2.169, 0.047> <0.068, 2.230, 0.108> <0.065, 2.304, 0.108> 
		<0.070, 2.169, -0.026> <0.070, 2.169, -0.026> <0.068, 2.230, 0.028> <0.065, 2.304, 0.028> 
		<0.070, 2.169, -0.026> <0.070, 2.169, -0.026> <0.068, 2.230, -0.080> <0.065, 2.304, -0.080> 
		<0.070, 2.169, -0.026> <0.070, 2.169, -0.099> <0.068, 2.230, -0.160> <0.065, 2.304, -0.160> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.065, 2.304, 0.108> <0.063, 2.377, 0.108> <0.060, 2.438, 0.047> <0.060, 2.438, -0.026> 
		<0.065, 2.304, 0.108> <0.063, 2.377, 0.028> <0.060, 2.438, -0.026> <0.060, 2.438, -0.099> 
		<0.065, 2.304, 0.108> <0.063, 2.377, 0.028> <0.063, 2.377, -0.080> <0.063, 2.377, -0.160> 
		<0.065, 2.304, 0.108> <0.065, 2.304, 0.028> <0.065, 2.304, -0.080> <0.065, 2.304, -0.160> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.422, 2.295, -0.026> <0.422, 2.295, -0.009> <0.421, 2.309, 0.006> <0.420, 2.327, 0.006> 
		<0.422, 2.295, -0.026> <0.422, 2.295, -0.026> <0.421, 2.309, -0.013> <0.420, 2.327, -0.013> 
		<0.422, 2.295, -0.026> <0.422, 2.295, -0.026> <0.421, 2.309, -0.039> <0.420, 2.327, -0.039> 
		<0.422, 2.295, -0.026> <0.422, 2.295, -0.044> <0.421, 2.309, -0.058> <0.420, 2.327, -0.058> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.420, 2.327, 0.006> <0.420, 2.344, 0.006> <0.419, 2.359, -0.009> <0.419, 2.359, -0.026> 
		<0.420, 2.327, 0.006> <0.420, 2.344, -0.013> <0.419, 2.359, -0.026> <0.419, 2.359, -0.044> 
		<0.420, 2.327, 0.006> <0.420, 2.344, -0.013> <0.420, 2.344, -0.039> <0.420, 2.344, -0.058> 
		<0.420, 2.327, 0.006> <0.420, 2.327, -0.013> <0.420, 2.327, -0.039> <0.420, 2.327, -0.058> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.549, 2.261, -0.026> <-0.549, 2.261, -0.009> <-0.550, 2.275, 0.006> <-0.550, 2.293, 0.006> 
		<-0.549, 2.261, -0.026> <-0.549, 2.261, -0.026> <-0.550, 2.275, -0.013> <-0.550, 2.293, -0.013> 
		<-0.549, 2.261, -0.026> <-0.549, 2.261, -0.026> <-0.550, 2.275, -0.039> <-0.550, 2.293, -0.039> 
		<-0.549, 2.261, -0.026> <-0.549, 2.261, -0.044> <-0.550, 2.275, -0.058> <-0.550, 2.293, -0.058> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.550, 2.293, 0.006> <-0.551, 2.311, 0.006> <-0.552, 2.325, -0.009> <-0.552, 2.325, -0.026> 
		<-0.550, 2.293, 0.006> <-0.551, 2.311, -0.013> <-0.552, 2.325, -0.026> <-0.552, 2.325, -0.044> 
		<-0.550, 2.293, 0.006> <-0.551, 2.311, -0.013> <-0.551, 2.311, -0.039> <-0.551, 2.311, -0.058> 
		<-0.550, 2.293, 0.006> <-0.550, 2.293, -0.013> <-0.550, 2.293, -0.039> <-0.550, 2.293, -0.058> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.143, 2.313, -0.766> <1.138, 2.319, -0.693> <1.125, 2.384, -0.638> <1.115, 2.456, -0.644> 
		<1.143, 2.313, -0.766> <1.143, 2.313, -0.766> <1.131, 2.377, -0.718> <1.121, 2.450, -0.724> 
		<1.143, 2.313, -0.766> <1.143, 2.313, -0.766> <1.138, 2.369, -0.825> <1.128, 2.441, -0.831> 
		<1.143, 2.313, -0.766> <1.147, 2.307, -0.839> <1.143, 2.362, -0.905> <1.133, 2.434, -0.911> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.115, 2.456, -0.644> <1.105, 2.528, -0.651> <1.101, 2.584, -0.717> <1.106, 2.578, -0.790> 
		<1.115, 2.456, -0.644> <1.111, 2.522, -0.731> <1.106, 2.578, -0.790> <1.111, 2.572, -0.863> 
		<1.115, 2.456, -0.644> <1.111, 2.522, -0.731> <1.118, 2.513, -0.838> <1.123, 2.507, -0.918> 
		<1.115, 2.456, -0.644> <1.121, 2.450, -0.724> <1.128, 2.441, -0.831> <1.133, 2.434, -0.911> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.182, 2.175, -0.818> <0.178, 2.181, -0.745> <0.165, 2.247, -0.690> <0.155, 2.319, -0.697> 
		<0.182, 2.175, -0.818> <0.182, 2.175, -0.818> <0.170, 2.240, -0.770> <0.161, 2.312, -0.777> 
		<0.182, 2.175, -0.818> <0.182, 2.175, -0.818> <0.178, 2.231, -0.877> <0.168, 2.303, -0.883> 
		<0.182, 2.175, -0.818> <0.187, 2.170, -0.891> <0.183, 2.225, -0.957> <0.173, 2.297, -0.963> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.155, 2.319, -0.697> <0.145, 2.391, -0.703> <0.141, 2.446, -0.769> <0.146, 2.440, -0.842> 
		<0.155, 2.319, -0.697> <0.151, 2.384, -0.783> <0.146, 2.440, -0.842> <0.151, 2.434, -0.915> 
		<0.155, 2.319, -0.697> <0.151, 2.384, -0.783> <0.158, 2.376, -0.890> <0.163, 2.369, -0.970> 
		<0.155, 2.319, -0.697> <0.161, 2.312, -0.777> <0.168, 2.303, -0.883> <0.173, 2.297, -0.963> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.519, 2.337, -0.809> <0.518, 2.339, -0.791> <0.515, 2.354, -0.778> <0.512, 2.372, -0.780> 
		<0.519, 2.337, -0.809> <0.519, 2.337, -0.809> <0.516, 2.353, -0.797> <0.513, 2.370, -0.799> 
		<0.519, 2.337, -0.809> <0.519, 2.337, -0.809> <0.518, 2.351, -0.823> <0.515, 2.368, -0.825> 
		<0.519, 2.337, -0.809> <0.520, 2.336, -0.826> <0.519, 2.349, -0.842> <0.516, 2.366, -0.844> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.512, 2.372, -0.780> <0.510, 2.389, -0.781> <0.509, 2.402, -0.797> <0.510, 2.401, -0.815> 
		<0.512, 2.372, -0.780> <0.511, 2.387, -0.801> <0.510, 2.401, -0.815> <0.511, 2.399, -0.832> 
		<0.512, 2.372, -0.780> <0.511, 2.387, -0.801> <0.513, 2.385, -0.826> <0.514, 2.384, -0.845> 
		<0.512, 2.372, -0.780> <0.513, 2.370, -0.799> <0.515, 2.368, -0.825> <0.516, 2.366, -0.844> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.442, 2.200, -0.861> <-0.443, 2.201, -0.844> <-0.446, 2.217, -0.831> <-0.448, 2.234, -0.832> 
		<-0.442, 2.200, -0.861> <-0.442, 2.200, -0.861> <-0.444, 2.215, -0.850> <-0.447, 2.233, -0.851> 
		<-0.442, 2.200, -0.861> <-0.442, 2.200, -0.861> <-0.443, 2.213, -0.875> <-0.445, 2.231, -0.877> 
		<-0.442, 2.200, -0.861> <-0.440, 2.198, -0.879> <-0.441, 2.212, -0.895> <-0.444, 2.229, -0.896> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.448, 2.234, -0.832> <-0.450, 2.252, -0.834> <-0.451, 2.265, -0.850> <-0.450, 2.263, -0.867> 
		<-0.448, 2.234, -0.832> <-0.449, 2.250, -0.853> <-0.450, 2.263, -0.867> <-0.449, 2.262, -0.885> 
		<-0.448, 2.234, -0.832> <-0.449, 2.250, -0.853> <-0.447, 2.248, -0.879> <-0.446, 2.246, -0.898> 
		<-0.448, 2.234, -0.832> <-0.447, 2.233, -0.851> <-0.445, 2.231, -0.877> <-0.444, 2.229, -0.896> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.273, 2.318, 0.685> <1.298, 2.298, 0.751> <1.326, 2.340, 0.821> <1.334, 2.411, 0.839> 
		<1.273, 2.318, 0.685> <1.273, 2.318, 0.685> <1.298, 2.362, 0.748> <1.307, 2.433, 0.766> 
		<1.273, 2.318, 0.685> <1.273, 2.318, 0.685> <1.262, 2.391, 0.651> <1.270, 2.461, 0.669> 
		<1.273, 2.318, 0.685> <1.249, 2.337, 0.619> <1.235, 2.412, 0.579> <1.243, 2.483, 0.597> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.334, 2.411, 0.839> <1.342, 2.481, 0.856> <1.328, 2.557, 0.817> <1.303, 2.576, 0.751> 
		<1.334, 2.411, 0.839> <1.315, 2.503, 0.784> <1.303, 2.576, 0.751> <1.278, 2.596, 0.685> 
		<1.334, 2.411, 0.839> <1.315, 2.503, 0.784> <1.278, 2.532, 0.687> <1.251, 2.553, 0.615> 
		<1.334, 2.411, 0.839> <1.307, 2.433, 0.766> <1.270, 2.461, 0.669> <1.243, 2.483, 0.597> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.366, 2.334, 1.032> <0.391, 2.314, 1.098> <0.419, 2.357, 1.168> <0.427, 2.427, 1.186> 
		<0.366, 2.334, 1.032> <0.366, 2.334, 1.032> <0.391, 2.378, 1.095> <0.400, 2.449, 1.113> 
		<0.366, 2.334, 1.032> <0.366, 2.334, 1.032> <0.355, 2.407, 0.999> <0.363, 2.478, 1.017> 
		<0.366, 2.334, 1.032> <0.342, 2.354, 0.966> <0.328, 2.429, 0.926> <0.336, 2.499, 0.944> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.427, 2.427, 1.186> <0.435, 2.498, 1.204> <0.421, 2.573, 1.164> <0.396, 2.592, 1.098> 
		<0.427, 2.427, 1.186> <0.408, 2.519, 1.131> <0.396, 2.592, 1.098> <0.371, 2.612, 1.032> 
		<0.427, 2.427, 1.186> <0.408, 2.519, 1.131> <0.371, 2.548, 1.035> <0.344, 2.570, 0.962> 
		<0.427, 2.427, 1.186> <0.400, 2.449, 1.113> <0.363, 2.478, 1.017> <0.336, 2.499, 0.944> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.711, 2.437, 0.933> <0.717, 2.432, 0.948> <0.724, 2.442, 0.965> <0.726, 2.459, 0.970> 
		<0.711, 2.437, 0.933> <0.711, 2.437, 0.933> <0.717, 2.447, 0.948> <0.719, 2.464, 0.952> 
		<0.711, 2.437, 0.933> <0.711, 2.437, 0.933> <0.708, 2.454, 0.925> <0.710, 2.471, 0.929> 
		<0.711, 2.437, 0.933> <0.705, 2.441, 0.917> <0.702, 2.460, 0.907> <0.704, 2.476, 0.911> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.726, 2.459, 0.970> <0.728, 2.476, 0.974> <0.724, 2.494, 0.964> <0.718, 2.499, 0.948> 
		<0.726, 2.459, 0.970> <0.721, 2.481, 0.956> <0.718, 2.499, 0.948> <0.712, 2.504, 0.933> 
		<0.726, 2.459, 0.970> <0.721, 2.481, 0.956> <0.712, 2.488, 0.933> <0.706, 2.493, 0.916> 
		<0.726, 2.459, 0.970> <0.719, 2.464, 0.952> <0.710, 2.471, 0.929> <0.704, 2.476, 0.911> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.048, 2.479, 1.207> <-0.042, 2.474, 1.222> <-0.035, 2.485, 1.239> <-0.033, 2.501, 1.244> 
		<-0.048, 2.479, 1.207> <-0.048, 2.479, 1.207> <-0.042, 2.490, 1.222> <-0.040, 2.507, 1.226> 
		<-0.048, 2.479, 1.207> <-0.048, 2.479, 1.207> <-0.050, 2.497, 1.199> <-0.049, 2.514, 1.203> 
		<-0.048, 2.479, 1.207> <-0.054, 2.484, 1.191> <-0.057, 2.502, 1.181> <-0.055, 2.519, 1.186> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.033, 2.501, 1.244> <-0.031, 2.518, 1.248> <-0.035, 2.536, 1.238> <-0.041, 2.541, 1.222> 
		<-0.033, 2.501, 1.244> <-0.038, 2.524, 1.230> <-0.041, 2.541, 1.222> <-0.047, 2.546, 1.207> 
		<-0.033, 2.501, 1.244> <-0.038, 2.524, 1.230> <-0.047, 2.530, 1.207> <-0.053, 2.536, 1.190> 
		<-0.033, 2.501, 1.244> <-0.040, 2.507, 1.226> <-0.049, 2.514, 1.203> <-0.055, 2.519, 1.186> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.745, 2.374, -1.403> <1.715, 2.360, -1.338> <1.692, 2.408, -1.270> <1.695, 2.479, -1.253> 
		<1.745, 2.374, -1.403> <1.745, 2.374, -1.403> <1.726, 2.423, -1.341> <1.729, 2.494, -1.325> 
		<1.745, 2.374, -1.403> <1.745, 2.374, -1.403> <1.770, 2.443, -1.437> <1.773, 2.515, -1.421> 
		<1.745, 2.374, -1.403> <1.776, 2.388, -1.468> <1.804, 2.458, -1.509> <1.807, 2.530, -1.492> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.695, 2.479, -1.253> <1.699, 2.551, -1.237> <1.726, 2.621, -1.278> <1.757, 2.635, -1.343> 
		<1.695, 2.479, -1.253> <1.732, 2.566, -1.309> <1.757, 2.635, -1.343> <1.787, 2.649, -1.408> 
		<1.695, 2.479, -1.253> <1.732, 2.566, -1.309> <1.776, 2.586, -1.404> <1.810, 2.601, -1.476> 
		<1.695, 2.479, -1.253> <1.729, 2.494, -1.325> <1.773, 2.515, -1.421> <1.807, 2.530, -1.492> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.863, 2.501, -1.788> <0.832, 2.487, -1.723> <0.810, 2.535, -1.655> <0.813, 2.606, -1.638> 
		<0.863, 2.501, -1.788> <0.863, 2.501, -1.788> <0.843, 2.550, -1.726> <0.846, 2.621, -1.710> 
		<0.863, 2.501, -1.788> <0.863, 2.501, -1.788> <0.887, 2.570, -1.822> <0.891, 2.641, -1.806> 
		<0.863, 2.501, -1.788> <0.893, 2.514, -1.853> <0.921, 2.585, -1.894> <0.924, 2.656, -1.877> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.813, 2.606, -1.638> <0.816, 2.677, -1.622> <0.844, 2.748, -1.663> <0.874, 2.762, -1.728> 
		<0.813, 2.606, -1.638> <0.849, 2.692, -1.694> <0.874, 2.762, -1.728> <0.904, 2.776, -1.793> 
		<0.813, 2.606, -1.638> <0.849, 2.692, -1.694> <0.894, 2.713, -1.789> <0.927, 2.728, -1.861> 
		<0.813, 2.606, -1.638> <0.846, 2.621, -1.710> <0.891, 2.641, -1.806> <0.924, 2.656, -1.877> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.191, 2.564, -1.621> <1.183, 2.561, -1.606> <1.178, 2.572, -1.590> <1.179, 2.589, -1.586> 
		<1.191, 2.564, -1.621> <1.191, 2.564, -1.621> <1.186, 2.576, -1.607> <1.187, 2.593, -1.603> 
		<1.191, 2.564, -1.621> <1.191, 2.564, -1.621> <1.197, 2.581, -1.630> <1.197, 2.598, -1.626> 
		<1.191, 2.564, -1.621> <1.198, 2.567, -1.637> <1.205, 2.584, -1.647> <1.206, 2.602, -1.643> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.179, 2.589, -1.586> <1.180, 2.607, -1.582> <1.186, 2.624, -1.591> <1.194, 2.627, -1.607> 
		<1.179, 2.589, -1.586> <1.188, 2.610, -1.599> <1.194, 2.627, -1.607> <1.201, 2.630, -1.623> 
		<1.179, 2.589, -1.586> <1.188, 2.610, -1.599> <1.198, 2.615, -1.622> <1.206, 2.619, -1.639> 
		<1.179, 2.589, -1.586> <1.187, 2.593, -1.603> <1.197, 2.598, -1.626> <1.206, 2.602, -1.643> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.685, 2.648, -1.893> <0.677, 2.644, -1.877> <0.672, 2.656, -1.861> <0.673, 2.673, -1.857> 
		<0.685, 2.648, -1.893> <0.685, 2.648, -1.893> <0.680, 2.659, -1.878> <0.681, 2.677, -1.874> 
		<0.685, 2.648, -1.893> <0.685, 2.648, -1.893> <0.691, 2.664, -1.901> <0.691, 2.681, -1.897> 
		<0.685, 2.648, -1.893> <0.692, 2.651, -1.908> <0.699, 2.668, -1.918> <0.699, 2.685, -1.914> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.673, 2.673, -1.857> <0.673, 2.690, -1.853> <0.680, 2.707, -1.863> <0.687, 2.710, -1.878> 
		<0.673, 2.673, -1.857> <0.681, 2.694, -1.870> <0.687, 2.710, -1.878> <0.695, 2.714, -1.894> 
		<0.673, 2.673, -1.857> <0.681, 2.694, -1.870> <0.692, 2.699, -1.893> <0.700, 2.702, -1.910> 
		<0.673, 2.673, -1.857> <0.681, 2.677, -1.874> <0.691, 2.681, -1.897> <0.699, 2.685, -1.914> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.594, 1.933, -0.153> <3.592, 1.934, -0.080> <3.584, 1.995, -0.019> <3.576, 2.068, -0.020> 
		<3.594, 1.933, -0.153> <3.594, 1.933, -0.153> <3.586, 1.994, -0.100> <3.578, 2.067, -0.100> 
		<3.594, 1.933, -0.153> <3.594, 1.933, -0.153> <3.589, 1.994, -0.207> <3.581, 2.067, -0.208> 
		<3.594, 1.933, -0.153> <3.596, 1.933, -0.226> <3.591, 1.993, -0.288> <3.583, 2.066, -0.288> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.576, 2.068, -0.020> <3.569, 2.140, -0.021> <3.564, 2.201, -0.082> <3.566, 2.200, -0.155> 
		<3.576, 2.068, -0.020> <3.571, 2.140, -0.101> <3.566, 2.200, -0.155> <3.568, 2.200, -0.228> 
		<3.576, 2.068, -0.020> <3.571, 2.140, -0.101> <3.573, 2.139, -0.208> <3.576, 2.139, -0.289> 
		<3.576, 2.068, -0.020> <3.578, 2.067, -0.100> <3.581, 2.067, -0.208> <3.583, 2.066, -0.288> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.559, 2.035, -0.129> <4.558, 2.035, -0.055> <4.550, 2.096, 0.005> <4.542, 2.169, 0.004> 
		<4.559, 2.035, -0.129> <4.559, 2.035, -0.129> <4.552, 2.096, -0.075> <4.544, 2.169, -0.076> 
		<4.559, 2.035, -0.129> <4.559, 2.035, -0.129> <4.554, 2.095, -0.183> <4.547, 2.168, -0.183> 
		<4.559, 2.035, -0.129> <4.561, 2.034, -0.202> <4.557, 2.095, -0.263> <4.549, 2.167, -0.264> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.542, 2.169, 0.004> <4.534, 2.242, 0.004> <4.530, 2.302, -0.058> <4.532, 2.302, -0.131> 
		<4.542, 2.169, 0.004> <4.536, 2.241, -0.077> <4.532, 2.302, -0.131> <4.533, 2.301, -0.204> 
		<4.542, 2.169, 0.004> <4.536, 2.241, -0.077> <4.539, 2.241, -0.184> <4.541, 2.240, -0.264> 
		<4.542, 2.169, 0.004> <4.544, 2.169, -0.076> <4.547, 2.168, -0.183> <4.549, 2.167, -0.264> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.194, 2.110, -0.138> <4.193, 2.110, -0.121> <4.192, 2.125, -0.106> <4.190, 2.142, -0.107> 
		<4.194, 2.110, -0.138> <4.194, 2.110, -0.138> <4.192, 2.125, -0.126> <4.190, 2.142, -0.126> 
		<4.194, 2.110, -0.138> <4.194, 2.110, -0.138> <4.193, 2.124, -0.151> <4.191, 2.142, -0.152> 
		<4.194, 2.110, -0.138> <4.194, 2.110, -0.156> <4.193, 2.124, -0.171> <4.191, 2.142, -0.171> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.190, 2.142, -0.107> <4.188, 2.160, -0.107> <4.187, 2.174, -0.121> <4.187, 2.174, -0.139> 
		<4.190, 2.142, -0.107> <4.188, 2.160, -0.126> <4.187, 2.174, -0.139> <4.188, 2.174, -0.157> 
		<4.190, 2.142, -0.107> <4.188, 2.160, -0.126> <4.189, 2.159, -0.152> <4.190, 2.159, -0.171> 
		<4.190, 2.142, -0.107> <4.190, 2.142, -0.126> <4.191, 2.142, -0.152> <4.191, 2.142, -0.171> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.160, 2.211, -0.114> <5.159, 2.211, -0.096> <5.157, 2.226, -0.082> <5.156, 2.244, -0.082> 
		<5.160, 2.211, -0.114> <5.160, 2.211, -0.114> <5.158, 2.226, -0.101> <5.156, 2.243, -0.101> 
		<5.160, 2.211, -0.114> <5.160, 2.211, -0.114> <5.159, 2.226, -0.127> <5.157, 2.243, -0.127> 
		<5.160, 2.211, -0.114> <5.160, 2.211, -0.132> <5.159, 2.226, -0.146> <5.157, 2.243, -0.147> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.156, 2.244, -0.082> <5.154, 2.261, -0.082> <5.153, 2.276, -0.097> <5.153, 2.275, -0.115> 
		<5.156, 2.244, -0.082> <5.154, 2.261, -0.102> <5.153, 2.275, -0.115> <5.153, 2.275, -0.132> 
		<5.156, 2.244, -0.082> <5.154, 2.261, -0.102> <5.155, 2.261, -0.127> <5.155, 2.261, -0.147> 
		<5.156, 2.244, -0.082> <5.156, 2.243, -0.101> <5.157, 2.243, -0.127> <5.157, 2.243, -0.147> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.601, 2.416, -0.710> <3.610, 2.420, -0.638> <3.606, 2.484, -0.579> <3.593, 2.556, -0.582> 
		<3.601, 2.416, -0.710> <3.601, 2.416, -0.710> <3.597, 2.479, -0.659> <3.584, 2.551, -0.662> 
		<3.601, 2.416, -0.710> <3.601, 2.416, -0.710> <3.584, 2.473, -0.766> <3.571, 2.545, -0.768> 
		<3.601, 2.416, -0.710> <3.593, 2.412, -0.783> <3.575, 2.469, -0.845> <3.562, 2.541, -0.848> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.593, 2.556, -0.582> <3.580, 2.628, -0.584> <3.562, 2.684, -0.647> <3.554, 2.680, -0.719> 
		<3.593, 2.556, -0.582> <3.571, 2.623, -0.664> <3.554, 2.680, -0.719> <3.546, 2.676, -0.792> 
		<3.593, 2.556, -0.582> <3.571, 2.623, -0.664> <3.559, 2.618, -0.770> <3.549, 2.613, -0.850> 
		<3.593, 2.556, -0.582> <3.584, 2.551, -0.662> <3.571, 2.545, -0.768> <3.562, 2.541, -0.848> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.551, 2.583, -0.828> <4.559, 2.587, -0.755> <4.555, 2.650, -0.697> <4.542, 2.722, -0.699> 
		<4.551, 2.583, -0.828> <4.551, 2.583, -0.828> <4.546, 2.646, -0.776> <4.533, 2.718, -0.779> 
		<4.551, 2.583, -0.828> <4.551, 2.583, -0.828> <4.534, 2.640, -0.883> <4.521, 2.712, -0.885> 
		<4.551, 2.583, -0.828> <4.543, 2.579, -0.900> <4.525, 2.636, -0.963> <4.512, 2.708, -0.965> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.542, 2.722, -0.699> <4.530, 2.794, -0.701> <4.512, 2.851, -0.764> <4.504, 2.847, -0.837> 
		<4.542, 2.722, -0.699> <4.520, 2.790, -0.781> <4.504, 2.847, -0.837> <4.495, 2.843, -0.909> 
		<4.542, 2.722, -0.699> <4.520, 2.790, -0.781> <4.508, 2.784, -0.888> <4.499, 2.780, -0.968> 
		<4.542, 2.722, -0.699> <4.533, 2.718, -0.779> <4.521, 2.712, -0.885> <4.512, 2.708, -0.965> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.183, 2.633, -0.788> <4.185, 2.634, -0.771> <4.184, 2.649, -0.757> <4.181, 2.667, -0.758> 
		<4.183, 2.633, -0.788> <4.183, 2.633, -0.788> <4.182, 2.648, -0.776> <4.179, 2.666, -0.777> 
		<4.183, 2.633, -0.788> <4.183, 2.633, -0.788> <4.179, 2.647, -0.802> <4.176, 2.664, -0.802> 
		<4.183, 2.633, -0.788> <4.181, 2.632, -0.806> <4.177, 2.646, -0.821> <4.174, 2.663, -0.821> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.181, 2.667, -0.758> <4.178, 2.684, -0.758> <4.174, 2.698, -0.773> <4.172, 2.697, -0.791> 
		<4.181, 2.667, -0.758> <4.176, 2.683, -0.777> <4.172, 2.697, -0.791> <4.170, 2.696, -0.808> 
		<4.181, 2.667, -0.758> <4.176, 2.683, -0.777> <4.173, 2.682, -0.803> <4.171, 2.680, -0.822> 
		<4.181, 2.667, -0.758> <4.179, 2.666, -0.777> <4.176, 2.664, -0.802> <4.174, 2.663, -0.821> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.825, 2.742, -0.874> <4.827, 2.743, -0.857> <4.826, 2.758, -0.843> <4.823, 2.776, -0.844> 
		<4.825, 2.742, -0.874> <4.825, 2.742, -0.874> <4.824, 2.757, -0.862> <4.821, 2.774, -0.863> 
		<4.825, 2.742, -0.874> <4.825, 2.742, -0.874> <4.821, 2.756, -0.888> <4.818, 2.773, -0.888> 
		<4.825, 2.742, -0.874> <4.823, 2.741, -0.892> <4.819, 2.755, -0.907> <4.816, 2.772, -0.907> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.823, 2.776, -0.844> <4.820, 2.793, -0.844> <4.816, 2.806, -0.859> <4.814, 2.805, -0.877> 
		<4.823, 2.776, -0.844> <4.818, 2.792, -0.863> <4.814, 2.805, -0.877> <4.812, 2.805, -0.894> 
		<4.823, 2.776, -0.844> <4.818, 2.792, -0.863> <4.815, 2.790, -0.889> <4.813, 2.789, -0.908> 
		<4.823, 2.776, -0.844> <4.821, 2.774, -0.863> <4.818, 2.773, -0.888> <4.816, 2.772, -0.907> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.708, 2.403, 0.652> <3.695, 2.400, 0.724> <3.692, 2.457, 0.788> <3.701, 2.529, 0.793> 
		<3.708, 2.403, 0.652> <3.708, 2.403, 0.652> <3.706, 2.461, 0.709> <3.715, 2.533, 0.714> 
		<3.708, 2.403, 0.652> <3.708, 2.403, 0.652> <3.725, 2.466, 0.603> <3.734, 2.539, 0.609> 
		<3.708, 2.403, 0.652> <3.720, 2.407, 0.580> <3.738, 2.470, 0.524> <3.748, 2.542, 0.529> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.701, 2.529, 0.793> <3.711, 2.602, 0.799> <3.729, 2.665, 0.743> <3.741, 2.669, 0.671> 
		<3.701, 2.529, 0.793> <3.724, 2.606, 0.719> <3.741, 2.669, 0.671> <3.754, 2.672, 0.599> 
		<3.701, 2.529, 0.793> <3.724, 2.606, 0.719> <3.743, 2.611, 0.614> <3.757, 2.615, 0.535> 
		<3.701, 2.529, 0.793> <3.715, 2.533, 0.714> <3.734, 2.539, 0.609> <3.748, 2.542, 0.529> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.657, 2.272, 0.811> <4.644, 2.268, 0.883> <4.641, 2.325, 0.948> <4.651, 2.398, 0.953> 
		<4.657, 2.272, 0.811> <4.657, 2.272, 0.811> <4.655, 2.329, 0.868> <4.664, 2.402, 0.873> 
		<4.657, 2.272, 0.811> <4.657, 2.272, 0.811> <4.674, 2.335, 0.763> <4.683, 2.407, 0.768> 
		<4.657, 2.272, 0.811> <4.669, 2.275, 0.739> <4.688, 2.339, 0.683> <4.697, 2.411, 0.689> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.651, 2.398, 0.953> <4.660, 2.470, 0.958> <4.678, 2.534, 0.902> <4.690, 2.537, 0.830> 
		<4.651, 2.398, 0.953> <4.674, 2.474, 0.879> <4.690, 2.537, 0.830> <4.703, 2.541, 0.758> 
		<4.651, 2.398, 0.953> <4.674, 2.474, 0.879> <4.692, 2.480, 0.773> <4.706, 2.483, 0.694> 
		<4.651, 2.398, 0.953> <4.664, 2.402, 0.873> <4.683, 2.407, 0.768> <4.697, 2.411, 0.689> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.323, 2.432, 0.761> <4.320, 2.431, 0.778> <4.320, 2.445, 0.794> <4.322, 2.462, 0.795> 
		<4.323, 2.432, 0.761> <4.323, 2.432, 0.761> <4.323, 2.445, 0.775> <4.325, 2.463, 0.776> 
		<4.323, 2.432, 0.761> <4.323, 2.432, 0.761> <4.327, 2.447, 0.749> <4.330, 2.464, 0.750> 
		<4.323, 2.432, 0.761> <4.326, 2.432, 0.744> <4.331, 2.448, 0.730> <4.333, 2.465, 0.731> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.322, 2.462, 0.795> <4.324, 2.479, 0.796> <4.328, 2.495, 0.783> <4.331, 2.495, 0.765> 
		<4.322, 2.462, 0.795> <4.327, 2.480, 0.777> <4.331, 2.495, 0.765> <4.334, 2.496, 0.748> 
		<4.322, 2.462, 0.795> <4.327, 2.480, 0.777> <4.332, 2.482, 0.752> <4.335, 2.482, 0.733> 
		<4.322, 2.462, 0.795> <4.325, 2.463, 0.776> <4.330, 2.464, 0.750> <4.333, 2.465, 0.731> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.272, 2.300, 0.920> <5.269, 2.299, 0.937> <5.269, 2.313, 0.953> <5.271, 2.330, 0.954> 
		<5.272, 2.300, 0.920> <5.272, 2.300, 0.920> <5.272, 2.314, 0.934> <5.274, 2.331, 0.935> 
		<5.272, 2.300, 0.920> <5.272, 2.300, 0.920> <5.277, 2.315, 0.908> <5.279, 2.333, 0.910> 
		<5.272, 2.300, 0.920> <5.275, 2.301, 0.903> <5.280, 2.316, 0.889> <5.282, 2.334, 0.891> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.271, 2.330, 0.954> <5.273, 2.348, 0.955> <5.278, 2.363, 0.942> <5.281, 2.364, 0.925> 
		<5.271, 2.330, 0.954> <5.276, 2.349, 0.936> <5.281, 2.364, 0.925> <5.284, 2.365, 0.907> 
		<5.271, 2.330, 0.954> <5.276, 2.349, 0.936> <5.281, 2.350, 0.911> <5.284, 2.351, 0.892> 
		<5.271, 2.330, 0.954> <5.274, 2.331, 0.935> <5.279, 2.333, 0.910> <5.282, 2.334, 0.891> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.471, 2.281, -1.235> <3.485, 2.266, -1.165> <3.508, 2.312, -1.096> <3.520, 2.383, -1.084> 
		<3.471, 2.281, -1.235> <3.471, 2.281, -1.235> <3.492, 2.329, -1.173> <3.504, 2.400, -1.161> 
		<3.471, 2.281, -1.235> <3.471, 2.281, -1.235> <3.471, 2.351, -1.276> <3.483, 2.422, -1.264> 
		<3.471, 2.281, -1.235> <3.456, 2.296, -1.305> <3.455, 2.367, -1.353> <3.468, 2.438, -1.341> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.520, 2.383, -1.084> <3.533, 2.454, -1.071> <3.531, 2.526, -1.119> <3.517, 2.541, -1.189> 
		<3.520, 2.383, -1.084> <3.517, 2.471, -1.148> <3.517, 2.541, -1.189> <3.503, 2.556, -1.259> 
		<3.520, 2.383, -1.084> <3.517, 2.471, -1.148> <3.496, 2.493, -1.251> <3.480, 2.509, -1.328> 
		<3.520, 2.383, -1.084> <3.504, 2.400, -1.161> <3.483, 2.422, -1.264> <3.468, 2.438, -1.341> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.409, 2.153, -1.454> <4.423, 2.138, -1.384> <4.445, 2.185, -1.315> <4.458, 2.256, -1.302> 
		<4.409, 2.153, -1.454> <4.409, 2.153, -1.454> <4.430, 2.201, -1.392> <4.442, 2.272, -1.380> 
		<4.409, 2.153, -1.454> <4.409, 2.153, -1.454> <4.409, 2.223, -1.495> <4.421, 2.294, -1.483> 
		<4.409, 2.153, -1.454> <4.394, 2.168, -1.524> <4.393, 2.240, -1.572> <4.405, 2.311, -1.560> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.458, 2.256, -1.302> <4.471, 2.327, -1.290> <4.469, 2.398, -1.338> <4.455, 2.413, -1.408> 
		<4.458, 2.256, -1.302> <4.455, 2.343, -1.367> <4.455, 2.413, -1.408> <4.440, 2.428, -1.478> 
		<4.458, 2.256, -1.302> <4.455, 2.343, -1.367> <4.434, 2.365, -1.470> <4.418, 2.382, -1.547> 
		<4.458, 2.256, -1.302> <4.442, 2.272, -1.380> <4.421, 2.294, -1.483> <4.405, 2.311, -1.560> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.085, 2.309, -1.355> <4.088, 2.306, -1.338> <4.093, 2.317, -1.321> <4.096, 2.334, -1.318> 
		<4.085, 2.309, -1.355> <4.085, 2.309, -1.355> <4.090, 2.321, -1.340> <4.093, 2.338, -1.337> 
		<4.085, 2.309, -1.355> <4.085, 2.309, -1.355> <4.085, 2.326, -1.364> <4.088, 2.343, -1.361> 
		<4.085, 2.309, -1.355> <4.081, 2.313, -1.371> <4.081, 2.330, -1.383> <4.084, 2.347, -1.380> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.096, 2.334, -1.318> <4.099, 2.351, -1.315> <4.099, 2.368, -1.327> <4.096, 2.372, -1.344> 
		<4.096, 2.334, -1.318> <4.096, 2.355, -1.334> <4.096, 2.372, -1.344> <4.092, 2.375, -1.360> 
		<4.096, 2.334, -1.318> <4.096, 2.355, -1.334> <4.091, 2.360, -1.358> <4.087, 2.364, -1.377> 
		<4.096, 2.334, -1.318> <4.093, 2.338, -1.337> <4.088, 2.343, -1.361> <4.084, 2.347, -1.380> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.022, 2.182, -1.573> <5.026, 2.178, -1.557> <5.031, 2.189, -1.540> <5.034, 2.206, -1.537> 
		<5.022, 2.182, -1.573> <5.022, 2.182, -1.573> <5.027, 2.193, -1.559> <5.030, 2.210, -1.556> 
		<5.022, 2.182, -1.573> <5.022, 2.182, -1.573> <5.022, 2.199, -1.583> <5.025, 2.216, -1.580> 
		<5.022, 2.182, -1.573> <5.019, 2.185, -1.590> <5.019, 2.203, -1.602> <5.022, 2.220, -1.599> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.034, 2.206, -1.537> <5.037, 2.223, -1.534> <5.037, 2.241, -1.546> <5.033, 2.244, -1.562> 
		<5.034, 2.206, -1.537> <5.033, 2.227, -1.553> <5.033, 2.244, -1.562> <5.030, 2.248, -1.579> 
		<5.034, 2.206, -1.537> <5.033, 2.227, -1.553> <5.028, 2.233, -1.577> <5.025, 2.237, -1.596> 
		<5.034, 2.206, -1.537> <5.030, 2.210, -1.556> <5.025, 2.216, -1.580> <5.022, 2.220, -1.599> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.171, 1.849, -0.018> <-1.171, 1.849, 0.030> <-1.147, 1.817, 0.069> <-1.119, 1.779, 0.069> 
		<-1.171, 1.849, -0.018> <-1.171, 1.849, -0.018> <-1.147, 1.817, 0.017> <-1.119, 1.779, 0.017> 
		<-1.171, 1.849, -0.018> <-1.171, 1.849, -0.018> <-1.147, 1.817, -0.053> <-1.119, 1.779, -0.053> 
		<-1.171, 1.849, -0.018> <-1.171, 1.849, -0.066> <-1.147, 1.817, -0.105> <-1.119, 1.779, -0.105> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.119, 1.779, 0.069> <-1.090, 1.741, 0.069> <-1.066, 1.709, 0.030> <-1.066, 1.709, -0.018> 
		<-1.119, 1.779, 0.069> <-1.090, 1.741, 0.017> <-1.066, 1.709, -0.018> <-1.066, 1.709, -0.066> 
		<-1.119, 1.779, 0.069> <-1.090, 1.741, 0.017> <-1.090, 1.741, -0.053> <-1.090, 1.741, -0.105> 
		<-1.119, 1.779, 0.069> <-1.119, 1.779, 0.017> <-1.119, 1.779, -0.053> <-1.119, 1.779, -0.105> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.675, 1.469, -0.018> <-1.675, 1.469, 0.030> <-1.651, 1.437, 0.069> <-1.623, 1.399, 0.069> 
		<-1.675, 1.469, -0.018> <-1.675, 1.469, -0.018> <-1.651, 1.437, 0.017> <-1.623, 1.399, 0.017> 
		<-1.675, 1.469, -0.018> <-1.675, 1.469, -0.018> <-1.651, 1.437, -0.053> <-1.623, 1.399, -0.053> 
		<-1.675, 1.469, -0.018> <-1.675, 1.469, -0.066> <-1.651, 1.437, -0.105> <-1.623, 1.399, -0.105> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.623, 1.399, 0.069> <-1.594, 1.361, 0.069> <-1.570, 1.329, 0.030> <-1.570, 1.329, -0.018> 
		<-1.623, 1.399, 0.069> <-1.594, 1.361, 0.017> <-1.570, 1.329, -0.018> <-1.570, 1.329, -0.066> 
		<-1.623, 1.399, 0.069> <-1.594, 1.361, 0.017> <-1.594, 1.361, -0.053> <-1.594, 1.361, -0.105> 
		<-1.623, 1.399, 0.069> <-1.623, 1.399, 0.017> <-1.623, 1.399, -0.053> <-1.623, 1.399, -0.105> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.446, 1.549, -0.018> <-1.446, 1.549, -0.007> <-1.441, 1.542, 0.003> <-1.434, 1.532, 0.003> 
		<-1.446, 1.549, -0.018> <-1.446, 1.549, -0.018> <-1.441, 1.542, -0.010> <-1.434, 1.532, -0.010> 
		<-1.446, 1.549, -0.018> <-1.446, 1.549, -0.018> <-1.441, 1.542, -0.026> <-1.434, 1.532, -0.026> 
		<-1.446, 1.549, -0.018> <-1.446, 1.549, -0.029> <-1.441, 1.542, -0.039> <-1.434, 1.532, -0.039> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.434, 1.532, 0.003> <-1.427, 1.523, 0.003> <-1.421, 1.516, -0.007> <-1.421, 1.516, -0.018> 
		<-1.434, 1.532, 0.003> <-1.427, 1.523, -0.010> <-1.421, 1.516, -0.018> <-1.421, 1.516, -0.029> 
		<-1.434, 1.532, 0.003> <-1.427, 1.523, -0.010> <-1.427, 1.523, -0.026> <-1.427, 1.523, -0.039> 
		<-1.434, 1.532, 0.003> <-1.434, 1.532, -0.010> <-1.434, 1.532, -0.026> <-1.434, 1.532, -0.039> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.951, 1.169, -0.018> <-1.951, 1.169, -0.007> <-1.945, 1.162, 0.003> <-1.938, 1.152, 0.003> 
		<-1.951, 1.169, -0.018> <-1.951, 1.169, -0.018> <-1.945, 1.162, -0.010> <-1.938, 1.152, -0.010> 
		<-1.951, 1.169, -0.018> <-1.951, 1.169, -0.018> <-1.945, 1.162, -0.026> <-1.938, 1.152, -0.026> 
		<-1.951, 1.169, -0.018> <-1.951, 1.169, -0.029> <-1.945, 1.162, -0.039> <-1.938, 1.152, -0.039> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.938, 1.152, 0.003> <-1.931, 1.143, 0.003> <-1.925, 1.136, -0.007> <-1.925, 1.136, -0.018> 
		<-1.938, 1.152, 0.003> <-1.931, 1.143, -0.010> <-1.925, 1.136, -0.018> <-1.925, 1.136, -0.029> 
		<-1.938, 1.152, 0.003> <-1.931, 1.143, -0.010> <-1.931, 1.143, -0.026> <-1.931, 1.143, -0.039> 
		<-1.938, 1.152, 0.003> <-1.938, 1.152, -0.010> <-1.938, 1.152, -0.026> <-1.938, 1.152, -0.039> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.710, 2.218, 1.468> <-0.691, 2.218, 1.512> <-0.651, 2.189, 1.537> <-0.621, 2.154, 1.525> 
		<-0.710, 2.218, 1.468> <-0.710, 2.218, 1.468> <-0.671, 2.189, 1.489> <-0.641, 2.154, 1.477> 
		<-0.710, 2.218, 1.468> <-0.710, 2.218, 1.468> <-0.698, 2.189, 1.425> <-0.668, 2.154, 1.412> 
		<-0.710, 2.218, 1.468> <-0.728, 2.218, 1.424> <-0.719, 2.189, 1.377> <-0.689, 2.154, 1.364> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.621, 2.154, 1.525> <-0.591, 2.119, 1.512> <-0.581, 2.090, 1.465> <-0.600, 2.090, 1.421> 
		<-0.621, 2.154, 1.525> <-0.611, 2.119, 1.464> <-0.600, 2.090, 1.421> <-0.619, 2.090, 1.377> 
		<-0.621, 2.154, 1.525> <-0.611, 2.119, 1.464> <-0.639, 2.119, 1.400> <-0.659, 2.119, 1.352> 
		<-0.621, 2.154, 1.525> <-0.641, 2.154, 1.477> <-0.668, 2.154, 1.412> <-0.689, 2.154, 1.364> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.135, 1.787, 1.648> <-1.116, 1.787, 1.692> <-1.076, 1.758, 1.718> <-1.046, 1.723, 1.705> 
		<-1.135, 1.787, 1.648> <-1.135, 1.787, 1.648> <-1.096, 1.758, 1.670> <-1.066, 1.723, 1.657> 
		<-1.135, 1.787, 1.648> <-1.135, 1.787, 1.648> <-1.123, 1.758, 1.606> <-1.094, 1.723, 1.593> 
		<-1.135, 1.787, 1.648> <-1.153, 1.787, 1.604> <-1.144, 1.758, 1.557> <-1.114, 1.723, 1.545> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.046, 1.723, 1.705> <-1.016, 1.688, 1.693> <-1.007, 1.659, 1.646> <-1.025, 1.659, 1.602> 
		<-1.046, 1.723, 1.705> <-1.036, 1.688, 1.644> <-1.025, 1.659, 1.602> <-1.044, 1.659, 1.558> 
		<-1.046, 1.723, 1.705> <-1.036, 1.688, 1.644> <-1.064, 1.688, 1.580> <-1.084, 1.688, 1.532> 
		<-1.046, 1.723, 1.705> <-1.066, 1.723, 1.657> <-1.094, 1.723, 1.593> <-1.114, 1.723, 1.545> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.933, 1.891, 1.563> <-0.928, 1.891, 1.573> <-0.919, 1.884, 1.579> <-0.912, 1.876, 1.576> 
		<-0.933, 1.891, 1.563> <-0.933, 1.891, 1.563> <-0.924, 1.884, 1.568> <-0.916, 1.876, 1.565> 
		<-0.933, 1.891, 1.563> <-0.933, 1.891, 1.563> <-0.930, 1.884, 1.552> <-0.923, 1.876, 1.549> 
		<-0.933, 1.891, 1.563> <-0.937, 1.891, 1.552> <-0.935, 1.884, 1.541> <-0.928, 1.876, 1.538> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.912, 1.876, 1.576> <-0.904, 1.867, 1.573> <-0.902, 1.860, 1.562> <-0.907, 1.860, 1.551> 
		<-0.912, 1.876, 1.576> <-0.909, 1.867, 1.562> <-0.907, 1.860, 1.551> <-0.911, 1.860, 1.541> 
		<-0.912, 1.876, 1.576> <-0.909, 1.867, 1.562> <-0.916, 1.867, 1.546> <-0.921, 1.867, 1.535> 
		<-0.912, 1.876, 1.576> <-0.916, 1.876, 1.565> <-0.923, 1.876, 1.549> <-0.928, 1.876, 1.538> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.239, 1.573, 1.693> <-1.235, 1.573, 1.703> <-1.225, 1.566, 1.709> <-1.218, 1.558, 1.706> 
		<-1.239, 1.573, 1.693> <-1.239, 1.573, 1.693> <-1.230, 1.566, 1.698> <-1.223, 1.558, 1.695> 
		<-1.239, 1.573, 1.693> <-1.239, 1.573, 1.693> <-1.236, 1.566, 1.682> <-1.229, 1.558, 1.679> 
		<-1.239, 1.573, 1.693> <-1.244, 1.573, 1.682> <-1.241, 1.566, 1.671> <-1.234, 1.558, 1.668> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.218, 1.558, 1.706> <-1.211, 1.550, 1.703> <-1.208, 1.543, 1.692> <-1.213, 1.543, 1.681> 
		<-1.218, 1.558, 1.706> <-1.215, 1.550, 1.692> <-1.213, 1.543, 1.681> <-1.217, 1.543, 1.671> 
		<-1.218, 1.558, 1.706> <-1.215, 1.550, 1.692> <-1.222, 1.550, 1.676> <-1.227, 1.550, 1.665> 
		<-1.218, 1.558, 1.706> <-1.223, 1.558, 1.695> <-1.229, 1.558, 1.679> <-1.234, 1.558, 1.668> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.219, 1.906, -0.931> <-1.219, 1.906, -0.883> <-1.194, 1.875, -0.844> <-1.165, 1.837, -0.844> 
		<-1.219, 1.906, -0.931> <-1.219, 1.906, -0.931> <-1.194, 1.875, -0.896> <-1.165, 1.837, -0.896> 
		<-1.219, 1.906, -0.931> <-1.219, 1.906, -0.931> <-1.194, 1.875, -0.966> <-1.165, 1.837, -0.966> 
		<-1.219, 1.906, -0.931> <-1.219, 1.906, -0.979> <-1.194, 1.875, -1.018> <-1.165, 1.837, -1.018> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.165, 1.837, -0.844> <-1.136, 1.800, -0.844> <-1.111, 1.768, -0.883> <-1.111, 1.768, -0.931> 
		<-1.165, 1.837, -0.844> <-1.136, 1.800, -0.896> <-1.111, 1.768, -0.931> <-1.111, 1.768, -0.979> 
		<-1.165, 1.837, -0.844> <-1.136, 1.800, -0.896> <-1.136, 1.800, -0.966> <-1.136, 1.800, -1.018> 
		<-1.165, 1.837, -0.844> <-1.165, 1.837, -0.896> <-1.165, 1.837, -0.966> <-1.165, 1.837, -1.018> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.716, 1.517, -0.931> <-1.716, 1.517, -0.883> <-1.692, 1.486, -0.844> <-1.662, 1.448, -0.844> 
		<-1.716, 1.517, -0.931> <-1.716, 1.517, -0.931> <-1.692, 1.486, -0.896> <-1.662, 1.448, -0.896> 
		<-1.716, 1.517, -0.931> <-1.716, 1.517, -0.931> <-1.692, 1.486, -0.966> <-1.662, 1.448, -0.966> 
		<-1.716, 1.517, -0.931> <-1.716, 1.517, -0.979> <-1.692, 1.486, -1.018> <-1.662, 1.448, -1.018> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.662, 1.448, -0.844> <-1.633, 1.411, -0.844> <-1.609, 1.380, -0.883> <-1.609, 1.380, -0.931> 
		<-1.662, 1.448, -0.844> <-1.633, 1.411, -0.896> <-1.609, 1.380, -0.931> <-1.609, 1.380, -0.979> 
		<-1.662, 1.448, -0.844> <-1.633, 1.411, -0.896> <-1.633, 1.411, -0.966> <-1.633, 1.411, -1.018> 
		<-1.662, 1.448, -0.844> <-1.662, 1.448, -0.896> <-1.662, 1.448, -0.966> <-1.662, 1.448, -1.018> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.489, 1.602, -0.931> <-1.489, 1.602, -0.920> <-1.483, 1.594, -0.910> <-1.476, 1.585, -0.910> 
		<-1.489, 1.602, -0.931> <-1.489, 1.602, -0.931> <-1.483, 1.594, -0.923> <-1.476, 1.585, -0.923> 
		<-1.489, 1.602, -0.931> <-1.489, 1.602, -0.931> <-1.483, 1.594, -0.939> <-1.476, 1.585, -0.939> 
		<-1.489, 1.602, -0.931> <-1.489, 1.602, -0.942> <-1.483, 1.594, -0.952> <-1.476, 1.585, -0.952> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.476, 1.585, -0.910> <-1.469, 1.576, -0.910> <-1.463, 1.569, -0.920> <-1.463, 1.569, -0.931> 
		<-1.476, 1.585, -0.910> <-1.469, 1.576, -0.923> <-1.463, 1.569, -0.931> <-1.463, 1.569, -0.942> 
		<-1.476, 1.585, -0.910> <-1.469, 1.576, -0.923> <-1.469, 1.576, -0.939> <-1.469, 1.576, -0.952> 
		<-1.476, 1.585, -0.910> <-1.476, 1.585, -0.923> <-1.476, 1.585, -0.939> <-1.476, 1.585, -0.952> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.986, 1.213, -0.931> <-1.986, 1.213, -0.920> <-1.980, 1.206, -0.910> <-1.973, 1.197, -0.910> 
		<-1.986, 1.213, -0.931> <-1.986, 1.213, -0.931> <-1.980, 1.206, -0.923> <-1.973, 1.197, -0.923> 
		<-1.986, 1.213, -0.931> <-1.986, 1.213, -0.931> <-1.980, 1.206, -0.939> <-1.973, 1.197, -0.939> 
		<-1.986, 1.213, -0.931> <-1.986, 1.213, -0.942> <-1.980, 1.206, -0.952> <-1.973, 1.197, -0.952> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.973, 1.197, -0.910> <-1.966, 1.188, -0.910> <-1.960, 1.180, -0.920> <-1.960, 1.180, -0.931> 
		<-1.973, 1.197, -0.910> <-1.966, 1.188, -0.923> <-1.960, 1.180, -0.931> <-1.960, 1.180, -0.942> 
		<-1.973, 1.197, -0.910> <-1.966, 1.188, -0.923> <-1.966, 1.188, -0.939> <-1.966, 1.188, -0.952> 
		<-1.973, 1.197, -0.910> <-1.973, 1.197, -0.923> <-1.973, 1.197, -0.939> <-1.973, 1.197, -0.952> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.136, 2.732, -2.382> <-0.173, 2.727, -2.352> <-0.197, 2.683, -2.327> <-0.190, 2.636, -2.327> 
		<-0.136, 2.732, -2.382> <-0.136, 2.732, -2.382> <-0.157, 2.689, -2.360> <-0.150, 2.642, -2.359> 
		<-0.136, 2.732, -2.382> <-0.136, 2.732, -2.382> <-0.103, 2.697, -2.404> <-0.096, 2.650, -2.403> 
		<-0.136, 2.732, -2.382> <-0.099, 2.737, -2.412> <-0.062, 2.703, -2.436> <-0.055, 2.656, -2.436> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.190, 2.636, -2.327> <-0.183, 2.589, -2.326> <-0.146, 2.554, -2.350> <-0.109, 2.560, -2.380> 
		<-0.190, 2.636, -2.327> <-0.142, 2.595, -2.359> <-0.109, 2.560, -2.380> <-0.073, 2.565, -2.410> 
		<-0.190, 2.636, -2.327> <-0.142, 2.595, -2.359> <-0.088, 2.603, -2.402> <-0.048, 2.609, -2.435> 
		<-0.190, 2.636, -2.327> <-0.150, 2.642, -2.359> <-0.096, 2.650, -2.403> <-0.055, 2.656, -2.436> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.525, 2.666, -2.875> <-0.562, 2.661, -2.846> <-0.586, 2.618, -2.820> <-0.579, 2.570, -2.820> 
		<-0.525, 2.666, -2.875> <-0.525, 2.666, -2.875> <-0.546, 2.623, -2.853> <-0.538, 2.576, -2.852> 
		<-0.525, 2.666, -2.875> <-0.525, 2.666, -2.875> <-0.492, 2.631, -2.897> <-0.485, 2.584, -2.896> 
		<-0.525, 2.666, -2.875> <-0.488, 2.672, -2.905> <-0.451, 2.637, -2.929> <-0.444, 2.590, -2.929> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.579, 2.570, -2.820> <-0.572, 2.523, -2.819> <-0.535, 2.489, -2.844> <-0.498, 2.494, -2.873> 
		<-0.579, 2.570, -2.820> <-0.531, 2.529, -2.852> <-0.498, 2.494, -2.873> <-0.461, 2.499, -2.903> 
		<-0.579, 2.570, -2.820> <-0.531, 2.529, -2.852> <-0.477, 2.537, -2.895> <-0.437, 2.543, -2.928> 
		<-0.579, 2.570, -2.820> <-0.538, 2.576, -2.852> <-0.485, 2.584, -2.896> <-0.444, 2.590, -2.929> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.371, 2.618, -2.694> <-0.380, 2.617, -2.687> <-0.386, 2.606, -2.681> <-0.384, 2.595, -2.680> 
		<-0.371, 2.618, -2.694> <-0.371, 2.618, -2.694> <-0.376, 2.608, -2.688> <-0.374, 2.596, -2.688> 
		<-0.371, 2.618, -2.694> <-0.371, 2.618, -2.694> <-0.363, 2.609, -2.699> <-0.362, 2.598, -2.699> 
		<-0.371, 2.618, -2.694> <-0.362, 2.619, -2.701> <-0.354, 2.611, -2.707> <-0.352, 2.600, -2.707> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.384, 2.595, -2.680> <-0.382, 2.584, -2.680> <-0.374, 2.575, -2.686> <-0.365, 2.576, -2.693> 
		<-0.384, 2.595, -2.680> <-0.373, 2.585, -2.688> <-0.365, 2.576, -2.693> <-0.356, 2.578, -2.700> 
		<-0.384, 2.595, -2.680> <-0.373, 2.585, -2.688> <-0.360, 2.587, -2.699> <-0.350, 2.588, -2.706> 
		<-0.384, 2.595, -2.680> <-0.374, 2.596, -2.688> <-0.362, 2.598, -2.699> <-0.352, 2.600, -2.707> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.760, 2.552, -3.187> <-0.769, 2.551, -3.180> <-0.775, 2.540, -3.174> <-0.773, 2.529, -3.174> 
		<-0.760, 2.552, -3.187> <-0.760, 2.552, -3.187> <-0.765, 2.542, -3.182> <-0.763, 2.531, -3.181> 
		<-0.760, 2.552, -3.187> <-0.760, 2.552, -3.187> <-0.752, 2.544, -3.192> <-0.750, 2.532, -3.192> 
		<-0.760, 2.552, -3.187> <-0.751, 2.553, -3.194> <-0.742, 2.545, -3.200> <-0.741, 2.534, -3.200> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.773, 2.529, -3.174> <-0.771, 2.518, -3.173> <-0.763, 2.510, -3.179> <-0.754, 2.511, -3.186> 
		<-0.773, 2.529, -3.174> <-0.762, 2.519, -3.181> <-0.754, 2.511, -3.186> <-0.745, 2.512, -3.194> 
		<-0.773, 2.529, -3.174> <-0.762, 2.519, -3.181> <-0.749, 2.521, -3.192> <-0.739, 2.523, -3.200> 
		<-0.773, 2.529, -3.174> <-0.763, 2.531, -3.181> <-0.750, 2.532, -3.192> <-0.741, 2.534, -3.200> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.768, 1.934, -0.062> <5.767, 1.934, -0.015> <5.758, 1.896, 0.025> <5.749, 1.849, 0.025> 
		<5.768, 1.934, -0.062> <5.768, 1.934, -0.062> <5.760, 1.895, -0.028> <5.750, 1.849, -0.028> 
		<5.768, 1.934, -0.062> <5.768, 1.934, -0.062> <5.761, 1.895, -0.097> <5.752, 1.848, -0.097> 
		<5.768, 1.934, -0.062> <5.769, 1.934, -0.110> <5.763, 1.895, -0.150> <5.754, 1.848, -0.150> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.749, 1.849, 0.025> <5.740, 1.802, 0.025> <5.733, 1.763, -0.015> <5.735, 1.763, -0.062> 
		<5.749, 1.849, 0.025> <5.741, 1.802, -0.028> <5.735, 1.763, -0.062> <5.736, 1.763, -0.110> 
		<5.749, 1.849, 0.025> <5.741, 1.802, -0.028> <5.743, 1.802, -0.097> <5.745, 1.801, -0.150> 
		<5.749, 1.849, 0.025> <5.750, 1.849, -0.028> <5.752, 1.848, -0.097> <5.754, 1.848, -0.150> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<6.388, 1.813, -0.046> <6.386, 1.814, 0.002> <6.378, 1.775, 0.041> <6.369, 1.728, 0.041> 
		<6.388, 1.813, -0.046> <6.388, 1.813, -0.046> <6.379, 1.775, -0.011> <6.370, 1.728, -0.011> 
		<6.388, 1.813, -0.046> <6.388, 1.813, -0.046> <6.381, 1.774, -0.081> <6.372, 1.728, -0.081> 
		<6.388, 1.813, -0.046> <6.389, 1.813, -0.093> <6.382, 1.774, -0.133> <6.373, 1.727, -0.133> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<6.369, 1.728, 0.041> <6.360, 1.682, 0.042> <6.353, 1.643, 0.002> <6.354, 1.642, -0.046> 
		<6.369, 1.728, 0.041> <6.361, 1.681, -0.011> <6.354, 1.642, -0.046> <6.355, 1.642, -0.093> 
		<6.369, 1.728, 0.041> <6.361, 1.681, -0.011> <6.363, 1.681, -0.081> <6.364, 1.681, -0.133> 
		<6.369, 1.728, 0.041> <6.370, 1.728, -0.011> <6.372, 1.728, -0.081> <6.373, 1.727, -0.133> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<6.147, 1.786, -0.052> <6.146, 1.786, -0.040> <6.144, 1.776, -0.031> <6.142, 1.765, -0.031> 
		<6.147, 1.786, -0.052> <6.147, 1.786, -0.052> <6.145, 1.776, -0.043> <6.142, 1.765, -0.043> 
		<6.147, 1.786, -0.052> <6.147, 1.786, -0.052> <6.145, 1.776, -0.060> <6.143, 1.765, -0.060> 
		<6.147, 1.786, -0.052> <6.147, 1.786, -0.063> <6.145, 1.776, -0.073> <6.143, 1.765, -0.073> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<6.142, 1.765, -0.031> <6.140, 1.754, -0.031> <6.138, 1.745, -0.040> <6.139, 1.744, -0.052> 
		<6.142, 1.765, -0.031> <6.140, 1.754, -0.043> <6.139, 1.744, -0.052> <6.139, 1.744, -0.063> 
		<6.142, 1.765, -0.031> <6.140, 1.754, -0.043> <6.141, 1.754, -0.060> <6.141, 1.754, -0.073> 
		<6.142, 1.765, -0.031> <6.142, 1.765, -0.043> <6.143, 1.765, -0.060> <6.143, 1.765, -0.073> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<6.766, 1.665, -0.035> <6.766, 1.665, -0.024> <6.764, 1.656, -0.014> <6.762, 1.645, -0.014> 
		<6.766, 1.665, -0.035> <6.766, 1.665, -0.035> <6.764, 1.656, -0.027> <6.762, 1.644, -0.027> 
		<6.766, 1.665, -0.035> <6.766, 1.665, -0.035> <6.765, 1.656, -0.043> <6.762, 1.644, -0.043> 
		<6.766, 1.665, -0.035> <6.766, 1.665, -0.047> <6.765, 1.656, -0.056> <6.763, 1.644, -0.056> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<6.762, 1.645, -0.014> <6.759, 1.633, -0.014> <6.758, 1.624, -0.024> <6.758, 1.624, -0.035> 
		<6.762, 1.645, -0.014> <6.760, 1.633, -0.027> <6.758, 1.624, -0.035> <6.758, 1.624, -0.046> 
		<6.762, 1.645, -0.014> <6.760, 1.633, -0.027> <6.760, 1.633, -0.043> <6.761, 1.633, -0.056> 
		<6.762, 1.645, -0.014> <6.762, 1.644, -0.027> <6.762, 1.644, -0.043> <6.763, 1.644, -0.056> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.437, 2.485, -0.912> <5.437, 2.485, -0.864> <5.410, 2.456, -0.825> <5.378, 2.420, -0.825> 
		<5.437, 2.485, -0.912> <5.437, 2.485, -0.912> <5.410, 2.455, -0.877> <5.378, 2.420, -0.878> 
		<5.437, 2.485, -0.912> <5.437, 2.485, -0.912> <5.411, 2.455, -0.947> <5.380, 2.420, -0.947> 
		<5.437, 2.485, -0.912> <5.438, 2.484, -0.960> <5.412, 2.455, -0.999> <5.380, 2.419, -1.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.378, 2.420, -0.825> <5.346, 2.385, -0.825> <5.320, 2.355, -0.865> <5.321, 2.355, -0.913> 
		<5.378, 2.420, -0.825> <5.347, 2.385, -0.878> <5.321, 2.355, -0.913> <5.321, 2.355, -0.960> 
		<5.378, 2.420, -0.825> <5.347, 2.385, -0.878> <5.348, 2.384, -0.948> <5.348, 2.384, -1.000> 
		<5.378, 2.420, -0.825> <5.378, 2.420, -0.878> <5.380, 2.420, -0.947> <5.380, 2.419, -1.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.906, 2.062, -0.902> <5.906, 2.062, -0.854> <5.879, 2.033, -0.815> <5.847, 1.998, -0.815> 
		<5.906, 2.062, -0.902> <5.906, 2.062, -0.902> <5.879, 2.033, -0.867> <5.848, 1.998, -0.867> 
		<5.906, 2.062, -0.902> <5.906, 2.062, -0.902> <5.880, 2.032, -0.937> <5.849, 1.997, -0.937> 
		<5.906, 2.062, -0.902> <5.907, 2.062, -0.949> <5.881, 2.032, -0.989> <5.849, 1.997, -0.989> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.847, 1.998, -0.815> <5.815, 1.963, -0.815> <5.789, 1.933, -0.855> <5.790, 1.932, -0.903> 
		<5.847, 1.998, -0.815> <5.816, 1.962, -0.868> <5.790, 1.932, -0.903> <5.790, 1.932, -0.950> 
		<5.847, 1.998, -0.815> <5.816, 1.962, -0.868> <5.817, 1.962, -0.937> <5.818, 1.961, -0.990> 
		<5.847, 1.998, -0.815> <5.848, 1.998, -0.867> <5.849, 1.997, -0.937> <5.849, 1.997, -0.989> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.685, 2.162, -0.906> <5.685, 2.162, -0.894> <5.679, 2.155, -0.885> <5.671, 2.147, -0.885> 
		<5.685, 2.162, -0.906> <5.685, 2.162, -0.906> <5.679, 2.155, -0.898> <5.671, 2.147, -0.898> 
		<5.685, 2.162, -0.906> <5.685, 2.162, -0.906> <5.679, 2.155, -0.914> <5.672, 2.147, -0.914> 
		<5.685, 2.162, -0.906> <5.686, 2.162, -0.917> <5.679, 2.155, -0.927> <5.672, 2.147, -0.927> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.671, 2.147, -0.885> <5.663, 2.138, -0.885> <5.657, 2.131, -0.895> <5.657, 2.131, -0.906> 
		<5.671, 2.147, -0.885> <5.664, 2.138, -0.898> <5.657, 2.131, -0.906> <5.658, 2.131, -0.918> 
		<5.671, 2.147, -0.885> <5.664, 2.138, -0.898> <5.664, 2.138, -0.914> <5.664, 2.138, -0.927> 
		<5.671, 2.147, -0.885> <5.671, 2.147, -0.898> <5.672, 2.147, -0.914> <5.672, 2.147, -0.927> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<6.000, 1.856, -0.896> <6.000, 1.856, -0.885> <5.993, 1.849, -0.875> <5.986, 1.840, -0.876> 
		<6.000, 1.856, -0.896> <6.000, 1.856, -0.896> <5.993, 1.849, -0.888> <5.986, 1.840, -0.888> 
		<6.000, 1.856, -0.896> <6.000, 1.856, -0.896> <5.994, 1.849, -0.905> <5.986, 1.840, -0.905> 
		<6.000, 1.856, -0.896> <6.000, 1.856, -0.908> <5.994, 1.848, -0.917> <5.986, 1.840, -0.917> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.986, 1.840, -0.876> <5.978, 1.832, -0.876> <5.972, 1.825, -0.885> <5.972, 1.825, -0.897> 
		<5.986, 1.840, -0.876> <5.978, 1.832, -0.888> <5.972, 1.825, -0.897> <5.972, 1.824, -0.908> 
		<5.986, 1.840, -0.876> <5.978, 1.832, -0.888> <5.978, 1.832, -0.905> <5.979, 1.831, -0.917> 
		<5.986, 1.840, -0.876> <5.986, 1.840, -0.888> <5.986, 1.840, -0.905> <5.986, 1.840, -0.917> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.908, 2.039, 1.002> <5.909, 2.048, 1.048> <5.892, 2.020, 1.094> <5.872, 1.978, 1.102> 
		<5.908, 2.039, 1.002> <5.908, 2.039, 1.002> <5.891, 2.010, 1.043> <5.871, 1.968, 1.051> 
		<5.908, 2.039, 1.002> <5.908, 2.039, 1.002> <5.890, 1.998, 0.974> <5.870, 1.956, 0.982> 
		<5.908, 2.039, 1.002> <5.907, 2.031, 0.955> <5.890, 1.988, 0.923> <5.869, 1.946, 0.931> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.872, 1.978, 1.102> <5.851, 1.936, 1.110> <5.833, 1.893, 1.078> <5.833, 1.885, 1.031> 
		<5.872, 1.978, 1.102> <5.850, 1.926, 1.059> <5.833, 1.885, 1.031> <5.832, 1.876, 0.984> 
		<5.872, 1.978, 1.102> <5.850, 1.926, 1.059> <5.849, 1.914, 0.990> <5.848, 1.904, 0.939> 
		<5.872, 1.978, 1.102> <5.871, 1.968, 1.051> <5.870, 1.956, 0.982> <5.869, 1.946, 0.931> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<6.477, 1.769, 1.043> <6.478, 1.777, 1.090> <6.461, 1.749, 1.135> <6.441, 1.707, 1.143> 
		<6.477, 1.769, 1.043> <6.477, 1.769, 1.043> <6.461, 1.740, 1.084> <6.440, 1.698, 1.092> 
		<6.477, 1.769, 1.043> <6.477, 1.769, 1.043> <6.459, 1.727, 1.015> <6.439, 1.685, 1.023> 
		<6.477, 1.769, 1.043> <6.476, 1.760, 0.996> <6.459, 1.718, 0.964> <6.438, 1.676, 0.972> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<6.441, 1.707, 1.143> <6.420, 1.665, 1.151> <6.402, 1.623, 1.119> <6.402, 1.614, 1.072> 
		<6.441, 1.707, 1.143> <6.419, 1.656, 1.100> <6.402, 1.614, 1.072> <6.401, 1.606, 1.025> 
		<6.441, 1.707, 1.143> <6.419, 1.656, 1.100> <6.418, 1.643, 1.031> <6.417, 1.634, 0.980> 
		<6.441, 1.707, 1.143> <6.440, 1.698, 1.092> <6.439, 1.685, 1.023> <6.438, 1.676, 0.972> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<6.237, 1.803, 1.040> <6.237, 1.805, 1.051> <6.233, 1.798, 1.062> <6.228, 1.788, 1.064> 
		<6.237, 1.803, 1.040> <6.237, 1.803, 1.040> <6.233, 1.796, 1.050> <6.228, 1.786, 1.052> 
		<6.237, 1.803, 1.040> <6.237, 1.803, 1.040> <6.233, 1.793, 1.034> <6.228, 1.783, 1.035> 
		<6.237, 1.803, 1.040> <6.237, 1.801, 1.029> <6.232, 1.791, 1.021> <6.228, 1.781, 1.023> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<6.228, 1.788, 1.064> <6.223, 1.778, 1.066> <6.219, 1.768, 1.058> <6.219, 1.766, 1.047> 
		<6.228, 1.788, 1.064> <6.223, 1.776, 1.054> <6.219, 1.766, 1.047> <6.219, 1.764, 1.036> 
		<6.228, 1.788, 1.064> <6.223, 1.776, 1.054> <6.223, 1.773, 1.037> <6.223, 1.770, 1.025> 
		<6.228, 1.788, 1.064> <6.228, 1.786, 1.052> <6.228, 1.783, 1.035> <6.228, 1.781, 1.023> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<6.806, 1.532, 1.081> <6.806, 1.534, 1.093> <6.802, 1.528, 1.103> <6.797, 1.518, 1.105> 
		<6.806, 1.532, 1.081> <6.806, 1.532, 1.081> <6.802, 1.526, 1.091> <6.797, 1.515, 1.093> 
		<6.806, 1.532, 1.081> <6.806, 1.532, 1.081> <6.802, 1.523, 1.075> <6.797, 1.512, 1.077> 
		<6.806, 1.532, 1.081> <6.806, 1.530, 1.070> <6.802, 1.520, 1.062> <6.797, 1.510, 1.064> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<6.797, 1.518, 1.105> <6.792, 1.508, 1.107> <6.788, 1.497, 1.100> <6.788, 1.495, 1.088> 
		<6.797, 1.518, 1.105> <6.792, 1.505, 1.095> <6.788, 1.495, 1.088> <6.788, 1.493, 1.077> 
		<6.797, 1.518, 1.105> <6.792, 1.505, 1.095> <6.792, 1.502, 1.079> <6.792, 1.500, 1.066> 
		<6.797, 1.518, 1.105> <6.797, 1.515, 1.093> <6.797, 1.512, 1.077> <6.797, 1.510, 1.064> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.540, 1.955, -1.791> <5.545, 1.936, -1.748> <5.532, 1.888, -1.724> <5.510, 1.848, -1.738> 
		<5.540, 1.955, -1.791> <5.540, 1.955, -1.791> <5.526, 1.908, -1.772> <5.505, 1.868, -1.786> 
		<5.540, 1.955, -1.791> <5.540, 1.955, -1.791> <5.518, 1.935, -1.835> <5.497, 1.895, -1.850> 
		<5.540, 1.955, -1.791> <5.534, 1.974, -1.835> <5.512, 1.956, -1.883> <5.491, 1.916, -1.898> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.510, 1.848, -1.738> <5.489, 1.808, -1.753> <5.467, 1.790, -1.801> <5.462, 1.808, -1.844> 
		<5.510, 1.848, -1.738> <5.483, 1.828, -1.801> <5.462, 1.808, -1.844> <5.456, 1.827, -1.888> 
		<5.510, 1.848, -1.738> <5.483, 1.828, -1.801> <5.475, 1.855, -1.864> <5.470, 1.876, -1.912> 
		<5.510, 1.848, -1.738> <5.505, 1.868, -1.786> <5.497, 1.895, -1.850> <5.491, 1.916, -1.898> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<6.100, 1.719, -1.961> <6.105, 1.700, -1.918> <6.092, 1.651, -1.894> <6.071, 1.611, -1.908> 
		<6.100, 1.719, -1.961> <6.100, 1.719, -1.961> <6.086, 1.672, -1.941> <6.065, 1.632, -1.956> 
		<6.100, 1.719, -1.961> <6.100, 1.719, -1.961> <6.078, 1.699, -2.005> <6.057, 1.659, -2.020> 
		<6.100, 1.719, -1.961> <6.095, 1.737, -2.005> <6.072, 1.719, -2.053> <6.051, 1.679, -2.067> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<6.071, 1.611, -1.908> <6.049, 1.571, -1.923> <6.027, 1.553, -1.971> <6.022, 1.572, -2.014> 
		<6.071, 1.611, -1.908> <6.044, 1.592, -1.970> <6.022, 1.572, -2.014> <6.017, 1.591, -2.058> 
		<6.071, 1.611, -1.908> <6.044, 1.592, -1.970> <6.036, 1.619, -2.034> <6.030, 1.639, -2.082> 
		<6.071, 1.611, -1.908> <6.065, 1.632, -1.956> <6.057, 1.659, -2.020> <6.051, 1.679, -2.067> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.862, 1.744, -1.921> <5.863, 1.739, -1.911> <5.860, 1.727, -1.905> <5.855, 1.718, -1.909> 
		<5.862, 1.744, -1.921> <5.862, 1.744, -1.921> <5.859, 1.732, -1.917> <5.853, 1.723, -1.920> 
		<5.862, 1.744, -1.921> <5.862, 1.744, -1.921> <5.857, 1.739, -1.932> <5.852, 1.729, -1.935> 
		<5.862, 1.744, -1.921> <5.861, 1.748, -1.932> <5.855, 1.744, -1.943> <5.850, 1.734, -1.947> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.855, 1.718, -1.909> <5.850, 1.708, -1.912> <5.844, 1.704, -1.924> <5.843, 1.708, -1.934> 
		<5.855, 1.718, -1.909> <5.848, 1.713, -1.924> <5.843, 1.708, -1.934> <5.842, 1.713, -1.945> 
		<5.855, 1.718, -1.909> <5.848, 1.713, -1.924> <5.846, 1.720, -1.939> <5.845, 1.725, -1.950> 
		<5.855, 1.718, -1.909> <5.853, 1.723, -1.920> <5.852, 1.729, -1.935> <5.850, 1.734, -1.947> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<6.422, 1.507, -2.091> <6.423, 1.503, -2.081> <6.420, 1.491, -2.075> <6.415, 1.481, -2.078> 
		<6.422, 1.507, -2.091> <6.422, 1.507, -2.091> <6.419, 1.496, -2.086> <6.414, 1.486, -2.090> 
		<6.422, 1.507, -2.091> <6.422, 1.507, -2.091> <6.417, 1.502, -2.102> <6.412, 1.493, -2.105> 
		<6.422, 1.507, -2.091> <6.421, 1.512, -2.102> <6.416, 1.507, -2.113> <6.410, 1.498, -2.117> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<6.415, 1.481, -2.078> <6.410, 1.472, -2.082> <6.405, 1.467, -2.094> <6.403, 1.472, -2.104> 
		<6.415, 1.481, -2.078> <6.409, 1.477, -2.093> <6.403, 1.472, -2.104> <6.402, 1.476, -2.114> 
		<6.415, 1.481, -2.078> <6.409, 1.477, -2.093> <6.407, 1.483, -2.109> <6.405, 1.488, -2.120> 
		<6.415, 1.481, -2.078> <6.414, 1.486, -2.090> <6.412, 1.493, -2.105> <6.410, 1.498, -2.117> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.036, 2.337, 0.108> <1.033, 2.411, 0.108> <1.031, 2.471, 0.047> <1.031, 2.471, -0.026> 
		<0.745, 2.327, 0.108> <0.742, 2.400, 0.108> <0.740, 2.461, 0.047> <0.740, 2.461, -0.026> 
		<0.356, 2.314, 0.108> <0.354, 2.387, 0.108> <0.352, 2.448, 0.047> <0.352, 2.448, -0.026> 
		<0.065, 2.304, 0.108> <0.063, 2.377, 0.108> <0.060, 2.438, 0.047> <0.060, 2.438, -0.026> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.031, 2.471, -0.026> <1.031, 2.471, -0.099> <1.033, 2.411, -0.160> <1.036, 2.337, -0.160> 
		<0.740, 2.461, -0.026> <0.740, 2.461, -0.099> <0.742, 2.400, -0.160> <0.745, 2.327, -0.160> 
		<0.352, 2.448, -0.026> <0.352, 2.448, -0.099> <0.354, 2.387, -0.160> <0.356, 2.314, -0.160> 
		<0.060, 2.438, -0.026> <0.060, 2.438, -0.099> <0.063, 2.377, -0.160> <0.065, 2.304, -0.160> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.036, 2.337, -0.160> <1.039, 2.264, -0.160> <1.041, 2.203, -0.099> <1.041, 2.203, -0.026> 
		<0.745, 2.327, -0.160> <0.747, 2.254, -0.160> <0.749, 2.193, -0.099> <0.749, 2.193, -0.026> 
		<0.356, 2.314, -0.160> <0.359, 2.240, -0.160> <0.361, 2.180, -0.099> <0.361, 2.180, -0.026> 
		<0.065, 2.304, -0.160> <0.068, 2.230, -0.160> <0.070, 2.169, -0.099> <0.070, 2.169, -0.026> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.070, 2.169, -0.026> <0.070, 2.169, 0.047> <0.068, 2.230, 0.108> <0.065, 2.304, 0.108> 
		<0.361, 2.180, -0.026> <0.361, 2.180, 0.047> <0.359, 2.240, 0.108> <0.356, 2.314, 0.108> 
		<0.749, 2.193, -0.026> <0.749, 2.193, 0.047> <0.747, 2.254, 0.108> <0.745, 2.327, 0.108> 
		<1.041, 2.203, -0.026> <1.041, 2.203, 0.047> <1.039, 2.264, 0.108> <1.036, 2.337, 0.108> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.420, 2.327, 0.006> <0.420, 2.344, 0.006> <0.419, 2.359, -0.009> <0.419, 2.359, -0.026> 
		<0.129, 2.317, 0.006> <0.129, 2.334, 0.006> <0.128, 2.349, -0.009> <0.128, 2.349, -0.026> 
		<-0.259, 2.303, 0.006> <-0.260, 2.321, 0.006> <-0.260, 2.335, -0.009> <-0.260, 2.335, -0.026> 
		<-0.550, 2.293, 0.006> <-0.551, 2.311, 0.006> <-0.552, 2.325, -0.009> <-0.552, 2.325, -0.026> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.419, 2.359, -0.026> <0.419, 2.359, -0.044> <0.420, 2.344, -0.058> <0.420, 2.327, -0.058> 
		<0.128, 2.349, -0.026> <0.128, 2.349, -0.044> <0.129, 2.334, -0.058> <0.129, 2.317, -0.058> 
		<-0.260, 2.335, -0.026> <-0.260, 2.335, -0.044> <-0.260, 2.321, -0.058> <-0.259, 2.303, -0.058> 
		<-0.552, 2.325, -0.026> <-0.552, 2.325, -0.044> <-0.551, 2.311, -0.058> <-0.550, 2.293, -0.058> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.420, 2.327, -0.058> <0.421, 2.309, -0.058> <0.422, 2.295, -0.044> <0.422, 2.295, -0.026> 
		<0.129, 2.317, -0.058> <0.130, 2.299, -0.058> <0.130, 2.285, -0.044> <0.130, 2.285, -0.026> 
		<-0.259, 2.303, -0.058> <-0.259, 2.286, -0.058> <-0.258, 2.271, -0.044> <-0.258, 2.271, -0.026> 
		<-0.550, 2.293, -0.058> <-0.550, 2.275, -0.058> <-0.549, 2.261, -0.044> <-0.549, 2.261, -0.026> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.549, 2.261, -0.026> <-0.549, 2.261, -0.009> <-0.550, 2.275, 0.006> <-0.550, 2.293, 0.006> 
		<-0.258, 2.271, -0.026> <-0.258, 2.271, -0.009> <-0.259, 2.286, 0.006> <-0.259, 2.303, 0.006> 
		<0.130, 2.285, -0.026> <0.130, 2.285, -0.009> <0.130, 2.299, 0.006> <0.129, 2.317, 0.006> 
		<0.422, 2.295, -0.026> <0.422, 2.295, -0.009> <0.421, 2.309, 0.006> <0.420, 2.327, 0.006> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.012, 2.261, -0.026> <-0.009, 2.252, -0.026> <-0.012, 2.235, -0.026> <-0.004, 2.230, -0.026> 
		<-0.012, 2.261, -0.040> <-0.009, 2.252, -0.040> <-0.012, 2.235, -0.047> <-0.004, 2.230, -0.047> 
		<-0.012, 2.269, -0.060> <-0.010, 2.262, -0.066> <-0.013, 2.246, -0.073> <-0.005, 2.242, -0.077> 
		<-0.012, 2.279, -0.070> <-0.010, 2.273, -0.076> <-0.013, 2.261, -0.088> <-0.005, 2.257, -0.092> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.004, 2.230, -0.026> <0.012, 2.221, -0.026> <0.040, 2.214, -0.026> <0.058, 2.220, -0.026> 
		<-0.004, 2.230, -0.047> <0.012, 2.221, -0.047> <0.040, 2.214, -0.050> <0.058, 2.220, -0.050> 
		<-0.005, 2.242, -0.077> <0.012, 2.236, -0.084> <0.040, 2.229, -0.087> <0.058, 2.234, -0.083> 
		<-0.005, 2.257, -0.092> <0.011, 2.251, -0.099> <0.039, 2.246, -0.104> <0.057, 2.251, -0.101> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.058, 2.220, -0.026> <0.068, 2.223, -0.026> <0.075, 2.248, -0.026> <0.066, 2.254, -0.026> 
		<0.058, 2.220, -0.050> <0.068, 2.223, -0.050> <0.075, 2.248, -0.042> <0.066, 2.254, -0.042> 
		<0.058, 2.234, -0.083> <0.068, 2.236, -0.081> <0.075, 2.260, -0.069> <0.066, 2.264, -0.065> 
		<0.057, 2.251, -0.101> <0.067, 2.253, -0.098> <0.074, 2.271, -0.081> <0.065, 2.275, -0.076> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.066, 2.254, -0.026> <0.047, 2.267, -0.026> <0.014, 2.261, -0.026> <-0.009, 2.264, -0.026> 
		<0.066, 2.254, -0.042> <0.047, 2.267, -0.042> <0.014, 2.261, -0.040> <-0.009, 2.264, -0.040> 
		<0.066, 2.264, -0.065> <0.047, 2.272, -0.056> <0.014, 2.270, -0.061> <-0.009, 2.272, -0.058> 
		<0.065, 2.275, -0.076> <0.047, 2.284, -0.067> <0.013, 2.279, -0.070> <-0.009, 2.281, -0.068> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.012, 2.279, 0.018> <-0.010, 2.273, 0.024> <-0.013, 2.261, 0.036> <-0.005, 2.257, 0.040> 
		<-0.012, 2.269, 0.008> <-0.010, 2.262, 0.014> <-0.013, 2.246, 0.021> <-0.005, 2.242, 0.024> 
		<-0.012, 2.261, -0.012> <-0.009, 2.252, -0.012> <-0.012, 2.235, -0.005> <-0.004, 2.230, -0.005> 
		<-0.012, 2.261, -0.026> <-0.009, 2.252, -0.026> <-0.012, 2.235, -0.026> <-0.004, 2.230, -0.026> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.005, 2.257, 0.040> <0.011, 2.251, 0.047> <0.039, 2.246, 0.052> <0.057, 2.251, 0.048> 
		<-0.005, 2.242, 0.024> <0.012, 2.236, 0.032> <0.040, 2.229, 0.035> <0.058, 2.234, 0.031> 
		<-0.004, 2.230, -0.005> <0.012, 2.221, -0.005> <0.040, 2.214, -0.002> <0.058, 2.220, -0.002> 
		<-0.004, 2.230, -0.026> <0.012, 2.221, -0.026> <0.040, 2.214, -0.026> <0.058, 2.220, -0.026> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.057, 2.251, 0.048> <0.067, 2.253, 0.046> <0.074, 2.271, 0.029> <0.065, 2.275, 0.024> 
		<0.058, 2.234, 0.031> <0.068, 2.236, 0.029> <0.075, 2.260, 0.017> <0.066, 2.264, 0.013> 
		<0.058, 2.220, -0.002> <0.068, 2.223, -0.002> <0.075, 2.248, -0.010> <0.066, 2.254, -0.010> 
		<0.058, 2.220, -0.026> <0.068, 2.223, -0.026> <0.075, 2.248, -0.026> <0.066, 2.254, -0.026> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.065, 2.275, 0.024> <0.047, 2.284, 0.015> <0.013, 2.279, 0.018> <-0.009, 2.281, 0.015> 
		<0.066, 2.264, 0.013> <0.047, 2.272, 0.003> <0.014, 2.270, 0.009> <-0.009, 2.272, 0.006> 
		<0.066, 2.254, -0.010> <0.047, 2.267, -0.010> <0.014, 2.261, -0.013> <-0.009, 2.264, -0.013> 
		<0.066, 2.254, -0.026> <0.047, 2.267, -0.026> <0.014, 2.261, -0.026> <-0.009, 2.264, -0.026> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.014, 2.323, 0.036> <-0.012, 2.323, 0.045> <-0.015, 2.323, 0.062> <-0.007, 2.323, 0.067> 
		<-0.013, 2.309, 0.036> <-0.011, 2.309, 0.045> <-0.015, 2.301, 0.062> <-0.007, 2.302, 0.067> 
		<-0.013, 2.289, 0.028> <-0.010, 2.283, 0.034> <-0.014, 2.276, 0.051> <-0.006, 2.272, 0.055> 
		<-0.012, 2.279, 0.018> <-0.010, 2.273, 0.024> <-0.013, 2.261, 0.036> <-0.005, 2.257, 0.040> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.007, 2.323, 0.067> <0.008, 2.324, 0.077> <0.036, 2.324, 0.085> <0.054, 2.325, 0.079> 
		<-0.007, 2.302, 0.067> <0.009, 2.302, 0.077> <0.037, 2.300, 0.085> <0.055, 2.301, 0.079> 
		<-0.006, 2.272, 0.055> <0.010, 2.266, 0.062> <0.038, 2.263, 0.069> <0.056, 2.268, 0.065> 
		<-0.005, 2.257, 0.040> <0.011, 2.251, 0.047> <0.039, 2.246, 0.052> <0.057, 2.251, 0.048> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.054, 2.325, 0.079> <0.065, 2.325, 0.076> <0.072, 2.326, 0.051> <0.064, 2.325, 0.045> 
		<0.055, 2.301, 0.079> <0.065, 2.301, 0.076> <0.073, 2.309, 0.051> <0.064, 2.309, 0.045> 
		<0.056, 2.268, 0.065> <0.066, 2.270, 0.063> <0.074, 2.283, 0.040> <0.065, 2.287, 0.036> 
		<0.057, 2.251, 0.048> <0.067, 2.253, 0.046> <0.074, 2.271, 0.029> <0.065, 2.275, 0.024> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.064, 2.325, 0.045> <0.045, 2.325, 0.032> <0.012, 2.324, 0.036> <-0.011, 2.323, 0.033> 
		<0.064, 2.309, 0.045> <0.046, 2.308, 0.032> <0.012, 2.310, 0.036> <-0.010, 2.309, 0.033> 
		<0.065, 2.287, 0.036> <0.046, 2.295, 0.027> <0.013, 2.289, 0.028> <-0.009, 2.291, 0.025> 
		<0.065, 2.275, 0.024> <0.047, 2.284, 0.015> <0.013, 2.279, 0.018> <-0.009, 2.281, 0.015> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.015, 2.366, 0.018> <-0.014, 2.373, 0.024> <-0.018, 2.385, 0.036> <-0.010, 2.389, 0.040> 
		<-0.015, 2.356, 0.028> <-0.013, 2.363, 0.034> <-0.017, 2.370, 0.051> <-0.009, 2.374, 0.055> 
		<-0.014, 2.337, 0.036> <-0.012, 2.337, 0.045> <-0.016, 2.344, 0.062> <-0.008, 2.344, 0.067> 
		<-0.014, 2.323, 0.036> <-0.012, 2.323, 0.045> <-0.015, 2.323, 0.062> <-0.007, 2.323, 0.067> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.010, 2.389, 0.040> <0.006, 2.396, 0.047> <0.034, 2.403, 0.052> <0.052, 2.399, 0.048> 
		<-0.009, 2.374, 0.055> <0.006, 2.381, 0.062> <0.034, 2.386, 0.069> <0.052, 2.382, 0.065> 
		<-0.008, 2.344, 0.067> <0.008, 2.345, 0.077> <0.035, 2.349, 0.085> <0.054, 2.349, 0.079> 
		<-0.007, 2.323, 0.067> <0.008, 2.324, 0.077> <0.036, 2.324, 0.085> <0.054, 2.325, 0.079> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.052, 2.399, 0.048> <0.062, 2.398, 0.046> <0.070, 2.380, 0.029> <0.062, 2.376, 0.024> 
		<0.052, 2.382, 0.065> <0.063, 2.381, 0.063> <0.071, 2.369, 0.040> <0.062, 2.364, 0.036> 
		<0.054, 2.349, 0.079> <0.064, 2.350, 0.076> <0.072, 2.342, 0.051> <0.063, 2.342, 0.045> 
		<0.054, 2.325, 0.079> <0.065, 2.325, 0.076> <0.072, 2.326, 0.051> <0.064, 2.325, 0.045> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.062, 2.376, 0.024> <0.044, 2.366, 0.015> <0.010, 2.368, 0.018> <-0.012, 2.364, 0.015> 
		<0.062, 2.364, 0.036> <0.044, 2.354, 0.027> <0.010, 2.358, 0.028> <-0.012, 2.355, 0.025> 
		<0.063, 2.342, 0.045> <0.045, 2.341, 0.032> <0.011, 2.337, 0.036> <-0.011, 2.336, 0.033> 
		<0.064, 2.325, 0.045> <0.045, 2.325, 0.032> <0.012, 2.324, 0.036> <-0.011, 2.323, 0.033> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.016, 2.385, -0.026> <-0.014, 2.394, -0.026> <-0.019, 2.410, -0.026> <-0.011, 2.416, -0.026> 
		<-0.016, 2.385, -0.012> <-0.014, 2.394, -0.012> <-0.019, 2.410, -0.005> <-0.011, 2.416, -0.005> 
		<-0.016, 2.377, 0.008> <-0.014, 2.383, 0.014> <-0.018, 2.400, 0.021> <-0.010, 2.404, 0.024> 
		<-0.015, 2.366, 0.018> <-0.014, 2.373, 0.024> <-0.018, 2.385, 0.036> <-0.010, 2.389, 0.040> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.011, 2.416, -0.026> <0.005, 2.426, -0.026> <0.032, 2.435, -0.026> <0.051, 2.430, -0.026> 
		<-0.011, 2.416, -0.005> <0.005, 2.426, -0.005> <0.032, 2.435, -0.002> <0.051, 2.430, -0.002> 
		<-0.010, 2.404, 0.024> <0.005, 2.411, 0.032> <0.033, 2.420, 0.035> <0.051, 2.417, 0.031> 
		<-0.010, 2.389, 0.040> <0.006, 2.396, 0.047> <0.034, 2.403, 0.052> <0.052, 2.399, 0.048> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.051, 2.430, -0.026> <0.061, 2.428, -0.026> <0.070, 2.403, -0.026> <0.061, 2.397, -0.026> 
		<0.051, 2.430, -0.002> <0.061, 2.428, -0.002> <0.070, 2.403, -0.010> <0.061, 2.397, -0.010> 
		<0.051, 2.417, 0.031> <0.061, 2.415, 0.029> <0.070, 2.392, 0.017> <0.061, 2.387, 0.013> 
		<0.052, 2.399, 0.048> <0.062, 2.398, 0.046> <0.070, 2.380, 0.029> <0.062, 2.376, 0.024> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.061, 2.397, -0.026> <0.043, 2.383, -0.026> <0.010, 2.386, -0.026> <-0.013, 2.382, -0.026> 
		<0.061, 2.397, -0.010> <0.043, 2.383, -0.010> <0.010, 2.386, -0.013> <-0.013, 2.382, -0.013> 
		<0.061, 2.387, 0.013> <0.043, 2.377, 0.003> <0.010, 2.377, 0.009> <-0.012, 2.374, 0.006> 
		<0.062, 2.376, 0.024> <0.044, 2.366, 0.015> <0.010, 2.368, 0.018> <-0.012, 2.364, 0.015> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.015, 2.366, -0.070> <-0.014, 2.373, -0.076> <-0.018, 2.385, -0.088> <-0.010, 2.389, -0.092> 
		<-0.016, 2.377, -0.060> <-0.014, 2.383, -0.066> <-0.018, 2.400, -0.073> <-0.010, 2.404, -0.077> 
		<-0.016, 2.385, -0.040> <-0.014, 2.394, -0.040> <-0.019, 2.410, -0.047> <-0.011, 2.416, -0.047> 
		<-0.016, 2.385, -0.026> <-0.014, 2.394, -0.026> <-0.019, 2.410, -0.026> <-0.011, 2.416, -0.026> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.010, 2.389, -0.092> <0.006, 2.396, -0.099> <0.034, 2.403, -0.104> <0.052, 2.399, -0.101> 
		<-0.010, 2.404, -0.077> <0.005, 2.411, -0.084> <0.033, 2.420, -0.087> <0.051, 2.417, -0.083> 
		<-0.011, 2.416, -0.047> <0.005, 2.426, -0.047> <0.032, 2.435, -0.050> <0.051, 2.430, -0.050> 
		<-0.011, 2.416, -0.026> <0.005, 2.426, -0.026> <0.032, 2.435, -0.026> <0.051, 2.430, -0.026> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.052, 2.399, -0.101> <0.062, 2.398, -0.098> <0.070, 2.380, -0.081> <0.062, 2.376, -0.076> 
		<0.051, 2.417, -0.083> <0.061, 2.415, -0.081> <0.070, 2.392, -0.069> <0.061, 2.387, -0.065> 
		<0.051, 2.430, -0.050> <0.061, 2.428, -0.050> <0.070, 2.403, -0.042> <0.061, 2.397, -0.042> 
		<0.051, 2.430, -0.026> <0.061, 2.428, -0.026> <0.070, 2.403, -0.026> <0.061, 2.397, -0.026> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.062, 2.376, -0.076> <0.044, 2.366, -0.067> <0.010, 2.368, -0.070> <-0.012, 2.364, -0.068> 
		<0.061, 2.387, -0.065> <0.043, 2.377, -0.056> <0.010, 2.377, -0.061> <-0.012, 2.374, -0.058> 
		<0.061, 2.397, -0.042> <0.043, 2.383, -0.042> <0.010, 2.386, -0.040> <-0.013, 2.382, -0.040> 
		<0.061, 2.397, -0.026> <0.043, 2.383, -0.026> <0.010, 2.386, -0.026> <-0.013, 2.382, -0.026> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.014, 2.323, -0.088> <-0.012, 2.323, -0.097> <-0.015, 2.323, -0.114> <-0.007, 2.323, -0.119> 
		<-0.014, 2.337, -0.088> <-0.012, 2.337, -0.097> <-0.016, 2.344, -0.114> <-0.008, 2.344, -0.119> 
		<-0.015, 2.356, -0.080> <-0.013, 2.363, -0.086> <-0.017, 2.370, -0.103> <-0.009, 2.374, -0.107> 
		<-0.015, 2.366, -0.070> <-0.014, 2.373, -0.076> <-0.018, 2.385, -0.088> <-0.010, 2.389, -0.092> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.007, 2.323, -0.119> <0.008, 2.324, -0.129> <0.036, 2.324, -0.137> <0.054, 2.325, -0.131> 
		<-0.008, 2.344, -0.119> <0.008, 2.345, -0.129> <0.035, 2.349, -0.137> <0.054, 2.349, -0.131> 
		<-0.009, 2.374, -0.107> <0.006, 2.381, -0.114> <0.034, 2.386, -0.121> <0.052, 2.382, -0.118> 
		<-0.010, 2.389, -0.092> <0.006, 2.396, -0.099> <0.034, 2.403, -0.104> <0.052, 2.399, -0.101> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.054, 2.325, -0.131> <0.065, 2.325, -0.128> <0.072, 2.326, -0.103> <0.064, 2.325, -0.097> 
		<0.054, 2.349, -0.131> <0.064, 2.350, -0.128> <0.072, 2.342, -0.103> <0.063, 2.342, -0.097> 
		<0.052, 2.382, -0.118> <0.063, 2.381, -0.115> <0.071, 2.369, -0.092> <0.062, 2.364, -0.088> 
		<0.052, 2.399, -0.101> <0.062, 2.398, -0.098> <0.070, 2.380, -0.081> <0.062, 2.376, -0.076> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.064, 2.325, -0.097> <0.045, 2.325, -0.084> <0.012, 2.324, -0.089> <-0.011, 2.323, -0.085> 
		<0.063, 2.342, -0.097> <0.045, 2.341, -0.084> <0.011, 2.337, -0.089> <-0.011, 2.336, -0.085> 
		<0.062, 2.364, -0.088> <0.044, 2.354, -0.079> <0.010, 2.358, -0.080> <-0.012, 2.355, -0.077> 
		<0.062, 2.376, -0.076> <0.044, 2.366, -0.067> <0.010, 2.368, -0.070> <-0.012, 2.364, -0.068> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.012, 2.279, -0.070> <-0.010, 2.273, -0.076> <-0.013, 2.261, -0.088> <-0.005, 2.257, -0.092> 
		<-0.013, 2.289, -0.080> <-0.010, 2.283, -0.086> <-0.014, 2.276, -0.103> <-0.006, 2.272, -0.107> 
		<-0.013, 2.309, -0.088> <-0.011, 2.309, -0.097> <-0.015, 2.301, -0.114> <-0.007, 2.302, -0.119> 
		<-0.014, 2.323, -0.088> <-0.012, 2.323, -0.097> <-0.015, 2.323, -0.114> <-0.007, 2.323, -0.119> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.005, 2.257, -0.092> <0.011, 2.251, -0.099> <0.039, 2.246, -0.104> <0.057, 2.251, -0.101> 
		<-0.006, 2.272, -0.107> <0.010, 2.266, -0.114> <0.038, 2.263, -0.121> <0.056, 2.268, -0.118> 
		<-0.007, 2.302, -0.119> <0.009, 2.302, -0.129> <0.037, 2.300, -0.137> <0.055, 2.301, -0.131> 
		<-0.007, 2.323, -0.119> <0.008, 2.324, -0.129> <0.036, 2.324, -0.137> <0.054, 2.325, -0.131> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.057, 2.251, -0.101> <0.067, 2.253, -0.098> <0.074, 2.271, -0.081> <0.065, 2.275, -0.076> 
		<0.056, 2.268, -0.118> <0.066, 2.270, -0.115> <0.074, 2.283, -0.092> <0.065, 2.287, -0.088> 
		<0.055, 2.301, -0.131> <0.065, 2.301, -0.128> <0.073, 2.309, -0.103> <0.064, 2.309, -0.097> 
		<0.054, 2.325, -0.131> <0.065, 2.325, -0.128> <0.072, 2.326, -0.103> <0.064, 2.325, -0.097> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.065, 2.275, -0.076> <0.047, 2.284, -0.067> <0.013, 2.279, -0.070> <-0.009, 2.281, -0.068> 
		<0.065, 2.287, -0.088> <0.046, 2.295, -0.079> <0.013, 2.289, -0.080> <-0.009, 2.291, -0.077> 
		<0.064, 2.309, -0.097> <0.046, 2.308, -0.084> <0.012, 2.310, -0.089> <-0.010, 2.309, -0.085> 
		<0.064, 2.325, -0.097> <0.045, 2.325, -0.084> <0.012, 2.324, -0.089> <-0.011, 2.323, -0.085> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.609, 2.229, -0.065> <-0.609, 2.220, -0.063> <-0.608, 2.203, -0.067> <-0.608, 2.198, -0.059> 
		<-0.595, 2.230, -0.065> <-0.594, 2.220, -0.063> <-0.587, 2.204, -0.066> <-0.587, 2.199, -0.058> 
		<-0.576, 2.238, -0.064> <-0.569, 2.232, -0.062> <-0.561, 2.215, -0.066> <-0.558, 2.212, -0.058> 
		<-0.566, 2.249, -0.064> <-0.559, 2.242, -0.062> <-0.547, 2.231, -0.065> <-0.543, 2.228, -0.057> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.608, 2.198, -0.059> <-0.608, 2.188, -0.043> <-0.608, 2.180, -0.015> <-0.609, 2.186, 0.003> 
		<-0.587, 2.199, -0.058> <-0.587, 2.189, -0.042> <-0.584, 2.181, -0.014> <-0.584, 2.187, 0.004> 
		<-0.558, 2.212, -0.058> <-0.551, 2.205, -0.042> <-0.547, 2.198, -0.014> <-0.552, 2.201, 0.004> 
		<-0.543, 2.228, -0.057> <-0.536, 2.221, -0.041> <-0.531, 2.215, -0.013> <-0.535, 2.219, 0.005> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.609, 2.186, 0.003> <-0.609, 2.189, 0.013> <-0.610, 2.214, 0.021> <-0.610, 2.220, 0.013> 
		<-0.584, 2.187, 0.004> <-0.585, 2.190, 0.014> <-0.594, 2.214, 0.021> <-0.594, 2.220, 0.013> 
		<-0.552, 2.201, 0.004> <-0.554, 2.203, 0.014> <-0.567, 2.226, 0.022> <-0.572, 2.230, 0.013> 
		<-0.535, 2.219, 0.005> <-0.538, 2.221, 0.015> <-0.556, 2.238, 0.022> <-0.560, 2.242, 0.013> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.610, 2.220, 0.013> <-0.610, 2.233, -0.006> <-0.609, 2.228, -0.039> <-0.609, 2.232, -0.062> 
		<-0.594, 2.220, 0.013> <-0.594, 2.233, -0.006> <-0.596, 2.229, -0.039> <-0.596, 2.233, -0.061> 
		<-0.572, 2.230, 0.013> <-0.581, 2.239, -0.005> <-0.575, 2.238, -0.039> <-0.577, 2.241, -0.061> 
		<-0.560, 2.242, 0.013> <-0.570, 2.251, -0.005> <-0.566, 2.248, -0.039> <-0.568, 2.251, -0.061> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.653, 2.246, -0.066> <-0.660, 2.239, -0.064> <-0.671, 2.227, -0.068> <-0.675, 2.223, -0.060> 
		<-0.643, 2.236, -0.065> <-0.649, 2.229, -0.064> <-0.655, 2.212, -0.067> <-0.659, 2.208, -0.059> 
		<-0.623, 2.229, -0.065> <-0.623, 2.219, -0.063> <-0.629, 2.202, -0.067> <-0.629, 2.197, -0.059> 
		<-0.609, 2.229, -0.065> <-0.609, 2.220, -0.063> <-0.608, 2.203, -0.067> <-0.608, 2.198, -0.059> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.675, 2.223, -0.060> <-0.682, 2.216, -0.044> <-0.688, 2.210, -0.016> <-0.684, 2.214, 0.002> 
		<-0.659, 2.208, -0.059> <-0.666, 2.201, -0.044> <-0.670, 2.193, -0.016> <-0.666, 2.197, 0.002> 
		<-0.629, 2.197, -0.059> <-0.629, 2.187, -0.043> <-0.632, 2.179, -0.015> <-0.633, 2.185, 0.003> 
		<-0.608, 2.198, -0.059> <-0.608, 2.188, -0.043> <-0.608, 2.180, -0.015> <-0.609, 2.186, 0.003> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.684, 2.214, 0.002> <-0.682, 2.216, 0.012> <-0.665, 2.234, 0.020> <-0.661, 2.239, 0.012> 
		<-0.666, 2.197, 0.002> <-0.664, 2.200, 0.012> <-0.653, 2.223, 0.020> <-0.649, 2.228, 0.012> 
		<-0.633, 2.185, 0.003> <-0.633, 2.188, 0.013> <-0.626, 2.213, 0.021> <-0.626, 2.219, 0.012> 
		<-0.609, 2.186, 0.003> <-0.609, 2.189, 0.013> <-0.610, 2.214, 0.021> <-0.610, 2.220, 0.013> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.661, 2.239, 0.012> <-0.652, 2.248, -0.007> <-0.654, 2.245, -0.040> <-0.651, 2.248, -0.062> 
		<-0.649, 2.228, 0.012> <-0.640, 2.237, -0.006> <-0.644, 2.236, -0.040> <-0.641, 2.239, -0.062> 
		<-0.626, 2.219, 0.012> <-0.626, 2.232, -0.006> <-0.623, 2.228, -0.040> <-0.623, 2.232, -0.062> 
		<-0.610, 2.220, 0.013> <-0.610, 2.233, -0.006> <-0.609, 2.228, -0.039> <-0.609, 2.232, -0.062> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.673, 2.289, -0.066> <-0.682, 2.288, -0.064> <-0.699, 2.288, -0.068> <-0.704, 2.288, -0.060> 
		<-0.672, 2.275, -0.066> <-0.682, 2.274, -0.064> <-0.698, 2.267, -0.068> <-0.703, 2.266, -0.060> 
		<-0.664, 2.255, -0.066> <-0.670, 2.249, -0.064> <-0.687, 2.241, -0.068> <-0.690, 2.238, -0.060> 
		<-0.653, 2.246, -0.066> <-0.660, 2.239, -0.064> <-0.671, 2.227, -0.068> <-0.675, 2.223, -0.060> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.704, 2.288, -0.060> <-0.714, 2.287, -0.044> <-0.723, 2.287, -0.017> <-0.717, 2.287, 0.001> 
		<-0.703, 2.266, -0.060> <-0.714, 2.266, -0.044> <-0.722, 2.263, -0.017> <-0.717, 2.263, 0.001> 
		<-0.690, 2.238, -0.060> <-0.697, 2.230, -0.044> <-0.705, 2.226, -0.016> <-0.702, 2.230, 0.002> 
		<-0.675, 2.223, -0.060> <-0.682, 2.216, -0.044> <-0.688, 2.210, -0.016> <-0.684, 2.214, 0.002> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.717, 2.287, 0.001> <-0.715, 2.287, 0.012> <-0.690, 2.288, 0.020> <-0.684, 2.288, 0.011> 
		<-0.717, 2.263, 0.001> <-0.714, 2.263, 0.012> <-0.689, 2.272, 0.020> <-0.683, 2.272, 0.011> 
		<-0.702, 2.230, 0.002> <-0.700, 2.233, 0.012> <-0.677, 2.245, 0.020> <-0.673, 2.250, 0.012> 
		<-0.684, 2.214, 0.002> <-0.682, 2.216, 0.012> <-0.665, 2.234, 0.020> <-0.661, 2.239, 0.012> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.684, 2.288, 0.011> <-0.670, 2.289, -0.007> <-0.674, 2.289, -0.040> <-0.670, 2.289, -0.063> 
		<-0.683, 2.272, 0.011> <-0.670, 2.272, -0.007> <-0.674, 2.275, -0.040> <-0.669, 2.275, -0.063> 
		<-0.673, 2.250, 0.012> <-0.664, 2.260, -0.007> <-0.664, 2.254, -0.040> <-0.661, 2.257, -0.063> 
		<-0.661, 2.239, 0.012> <-0.652, 2.248, -0.007> <-0.654, 2.245, -0.040> <-0.651, 2.248, -0.062> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.656, 2.333, -0.066> <-0.663, 2.339, -0.064> <-0.675, 2.351, -0.068> <-0.679, 2.354, -0.060> 
		<-0.666, 2.323, -0.066> <-0.673, 2.329, -0.064> <-0.690, 2.335, -0.068> <-0.694, 2.339, -0.060> 
		<-0.673, 2.303, -0.066> <-0.683, 2.303, -0.064> <-0.700, 2.309, -0.068> <-0.705, 2.309, -0.060> 
		<-0.673, 2.289, -0.066> <-0.682, 2.288, -0.064> <-0.699, 2.288, -0.068> <-0.704, 2.288, -0.060> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.679, 2.354, -0.060> <-0.687, 2.361, -0.044> <-0.693, 2.366, -0.016> <-0.689, 2.363, 0.002> 
		<-0.694, 2.339, -0.060> <-0.701, 2.346, -0.044> <-0.709, 2.349, -0.016> <-0.706, 2.345, 0.002> 
		<-0.705, 2.309, -0.060> <-0.715, 2.309, -0.044> <-0.724, 2.311, -0.017> <-0.718, 2.311, 0.001> 
		<-0.704, 2.288, -0.060> <-0.714, 2.287, -0.044> <-0.723, 2.287, -0.017> <-0.717, 2.287, 0.001> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.689, 2.363, 0.002> <-0.687, 2.361, 0.012> <-0.669, 2.344, 0.020> <-0.665, 2.339, 0.012> 
		<-0.706, 2.345, 0.002> <-0.704, 2.343, 0.012> <-0.680, 2.332, 0.020> <-0.676, 2.327, 0.012> 
		<-0.718, 2.311, 0.001> <-0.715, 2.311, 0.012> <-0.690, 2.304, 0.020> <-0.684, 2.305, 0.011> 
		<-0.717, 2.287, 0.001> <-0.715, 2.287, 0.012> <-0.690, 2.288, 0.020> <-0.684, 2.288, 0.011> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.665, 2.339, 0.012> <-0.655, 2.330, -0.007> <-0.657, 2.334, -0.040> <-0.654, 2.331, -0.062> 
		<-0.676, 2.327, 0.012> <-0.666, 2.318, -0.007> <-0.666, 2.324, -0.040> <-0.663, 2.321, -0.063> 
		<-0.684, 2.305, 0.011> <-0.671, 2.305, -0.007> <-0.675, 2.302, -0.040> <-0.670, 2.302, -0.063> 
		<-0.684, 2.288, 0.011> <-0.670, 2.289, -0.007> <-0.674, 2.289, -0.040> <-0.670, 2.289, -0.063> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.613, 2.353, -0.065> <-0.614, 2.362, -0.063> <-0.614, 2.379, -0.067> <-0.614, 2.384, -0.059> 
		<-0.627, 2.352, -0.065> <-0.628, 2.362, -0.063> <-0.635, 2.378, -0.067> <-0.636, 2.383, -0.059> 
		<-0.647, 2.344, -0.065> <-0.654, 2.350, -0.064> <-0.661, 2.366, -0.067> <-0.665, 2.370, -0.059> 
		<-0.656, 2.333, -0.066> <-0.663, 2.339, -0.064> <-0.675, 2.351, -0.068> <-0.679, 2.354, -0.060> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.614, 2.384, -0.059> <-0.615, 2.394, -0.043> <-0.616, 2.402, -0.015> <-0.616, 2.396, 0.003> 
		<-0.636, 2.383, -0.059> <-0.636, 2.393, -0.043> <-0.640, 2.401, -0.015> <-0.640, 2.395, 0.003> 
		<-0.665, 2.370, -0.059> <-0.672, 2.377, -0.044> <-0.676, 2.384, -0.016> <-0.673, 2.380, 0.002> 
		<-0.679, 2.354, -0.060> <-0.687, 2.361, -0.044> <-0.693, 2.366, -0.016> <-0.689, 2.363, 0.002> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.616, 2.396, 0.003> <-0.616, 2.393, 0.013> <-0.615, 2.368, 0.021> <-0.615, 2.362, 0.013> 
		<-0.640, 2.395, 0.003> <-0.640, 2.392, 0.013> <-0.632, 2.368, 0.021> <-0.631, 2.361, 0.012> 
		<-0.673, 2.380, 0.002> <-0.671, 2.378, 0.012> <-0.658, 2.356, 0.020> <-0.653, 2.351, 0.012> 
		<-0.689, 2.363, 0.002> <-0.687, 2.361, 0.012> <-0.669, 2.344, 0.020> <-0.665, 2.339, 0.012> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.615, 2.362, 0.013> <-0.614, 2.349, -0.006> <-0.614, 2.353, -0.039> <-0.613, 2.350, -0.062> 
		<-0.631, 2.361, 0.012> <-0.631, 2.348, -0.006> <-0.627, 2.353, -0.040> <-0.627, 2.349, -0.062> 
		<-0.653, 2.351, 0.012> <-0.643, 2.342, -0.006> <-0.648, 2.343, -0.040> <-0.645, 2.341, -0.062> 
		<-0.665, 2.339, 0.012> <-0.655, 2.330, -0.007> <-0.657, 2.334, -0.040> <-0.654, 2.331, -0.062> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.569, 2.336, -0.064> <-0.563, 2.343, -0.062> <-0.551, 2.355, -0.065> <-0.548, 2.359, -0.057> 
		<-0.579, 2.346, -0.064> <-0.573, 2.353, -0.062> <-0.567, 2.370, -0.066> <-0.563, 2.373, -0.058> 
		<-0.599, 2.353, -0.065> <-0.599, 2.363, -0.063> <-0.593, 2.379, -0.066> <-0.593, 2.384, -0.058> 
		<-0.613, 2.353, -0.065> <-0.614, 2.362, -0.063> <-0.614, 2.379, -0.067> <-0.614, 2.384, -0.059> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.548, 2.359, -0.057> <-0.541, 2.366, -0.041> <-0.536, 2.372, -0.013> <-0.541, 2.368, 0.005> 
		<-0.563, 2.373, -0.058> <-0.557, 2.381, -0.042> <-0.554, 2.388, -0.014> <-0.558, 2.384, 0.004> 
		<-0.593, 2.384, -0.058> <-0.594, 2.395, -0.042> <-0.592, 2.402, -0.014> <-0.592, 2.397, 0.004> 
		<-0.614, 2.384, -0.059> <-0.615, 2.394, -0.043> <-0.616, 2.402, -0.015> <-0.616, 2.396, 0.003> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.541, 2.368, 0.005> <-0.543, 2.366, 0.015> <-0.560, 2.347, 0.022> <-0.564, 2.343, 0.013> 
		<-0.558, 2.384, 0.004> <-0.560, 2.382, 0.014> <-0.572, 2.359, 0.022> <-0.576, 2.354, 0.013> 
		<-0.592, 2.397, 0.004> <-0.592, 2.394, 0.014> <-0.599, 2.369, 0.021> <-0.599, 2.363, 0.013> 
		<-0.616, 2.396, 0.003> <-0.616, 2.393, 0.013> <-0.615, 2.368, 0.021> <-0.615, 2.362, 0.013> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.564, 2.343, 0.013> <-0.573, 2.333, -0.005> <-0.569, 2.337, -0.039> <-0.571, 2.334, -0.061> 
		<-0.576, 2.354, 0.013> <-0.585, 2.344, -0.005> <-0.579, 2.346, -0.039> <-0.581, 2.343, -0.061> 
		<-0.599, 2.363, 0.013> <-0.598, 2.349, -0.006> <-0.600, 2.354, -0.039> <-0.600, 2.350, -0.061> 
		<-0.615, 2.362, 0.013> <-0.614, 2.349, -0.006> <-0.614, 2.353, -0.039> <-0.613, 2.350, -0.062> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.549, 2.293, -0.064> <-0.540, 2.293, -0.062> <-0.523, 2.294, -0.065> <-0.518, 2.294, -0.057> 
		<-0.550, 2.307, -0.064> <-0.540, 2.308, -0.062> <-0.524, 2.315, -0.065> <-0.519, 2.315, -0.057> 
		<-0.559, 2.326, -0.064> <-0.552, 2.333, -0.062> <-0.536, 2.341, -0.065> <-0.532, 2.344, -0.057> 
		<-0.569, 2.336, -0.064> <-0.563, 2.343, -0.062> <-0.551, 2.355, -0.065> <-0.548, 2.359, -0.057> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.518, 2.294, -0.057> <-0.509, 2.294, -0.041> <-0.501, 2.295, -0.013> <-0.507, 2.295, 0.005> 
		<-0.519, 2.315, -0.057> <-0.509, 2.316, -0.041> <-0.502, 2.319, -0.013> <-0.508, 2.319, 0.005> 
		<-0.532, 2.344, -0.057> <-0.526, 2.352, -0.041> <-0.519, 2.355, -0.013> <-0.523, 2.351, 0.005> 
		<-0.548, 2.359, -0.057> <-0.541, 2.366, -0.041> <-0.536, 2.372, -0.013> <-0.541, 2.368, 0.005> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.507, 2.295, 0.005> <-0.510, 2.294, 0.015> <-0.535, 2.294, 0.023> <-0.541, 2.293, 0.014> 
		<-0.508, 2.319, 0.005> <-0.511, 2.319, 0.015> <-0.536, 2.310, 0.023> <-0.542, 2.310, 0.014> 
		<-0.523, 2.351, 0.005> <-0.525, 2.349, 0.015> <-0.548, 2.336, 0.022> <-0.552, 2.332, 0.014> 
		<-0.541, 2.368, 0.005> <-0.543, 2.366, 0.015> <-0.560, 2.347, 0.022> <-0.564, 2.343, 0.013> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.541, 2.293, 0.014> <-0.554, 2.293, -0.005> <-0.549, 2.293, -0.038> <-0.552, 2.293, -0.061> 
		<-0.542, 2.310, 0.014> <-0.555, 2.309, -0.005> <-0.550, 2.307, -0.038> <-0.553, 2.306, -0.061> 
		<-0.552, 2.332, 0.014> <-0.561, 2.322, -0.005> <-0.559, 2.327, -0.038> <-0.561, 2.325, -0.061> 
		<-0.564, 2.343, 0.013> <-0.573, 2.333, -0.005> <-0.569, 2.337, -0.039> <-0.571, 2.334, -0.061> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.566, 2.249, -0.064> <-0.559, 2.242, -0.062> <-0.547, 2.231, -0.065> <-0.543, 2.228, -0.057> 
		<-0.556, 2.259, -0.064> <-0.549, 2.253, -0.062> <-0.532, 2.247, -0.065> <-0.529, 2.243, -0.057> 
		<-0.549, 2.279, -0.064> <-0.540, 2.279, -0.062> <-0.523, 2.273, -0.065> <-0.518, 2.273, -0.057> 
		<-0.549, 2.293, -0.064> <-0.540, 2.293, -0.062> <-0.523, 2.294, -0.065> <-0.518, 2.294, -0.057> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.543, 2.228, -0.057> <-0.536, 2.221, -0.041> <-0.531, 2.215, -0.013> <-0.535, 2.219, 0.005> 
		<-0.529, 2.243, -0.057> <-0.522, 2.236, -0.041> <-0.515, 2.233, -0.013> <-0.519, 2.237, 0.005> 
		<-0.518, 2.273, -0.057> <-0.508, 2.273, -0.041> <-0.500, 2.271, -0.013> <-0.506, 2.270, 0.005> 
		<-0.518, 2.294, -0.057> <-0.509, 2.294, -0.041> <-0.501, 2.295, -0.013> <-0.507, 2.295, 0.005> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.535, 2.219, 0.005> <-0.538, 2.221, 0.015> <-0.556, 2.238, 0.022> <-0.560, 2.242, 0.013> 
		<-0.519, 2.237, 0.005> <-0.521, 2.239, 0.015> <-0.545, 2.250, 0.022> <-0.549, 2.254, 0.014> 
		<-0.506, 2.270, 0.005> <-0.510, 2.270, 0.015> <-0.535, 2.277, 0.023> <-0.541, 2.277, 0.014> 
		<-0.507, 2.295, 0.005> <-0.510, 2.294, 0.015> <-0.535, 2.294, 0.023> <-0.541, 2.293, 0.014> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.560, 2.242, 0.013> <-0.570, 2.251, -0.005> <-0.566, 2.248, -0.039> <-0.568, 2.251, -0.061> 
		<-0.549, 2.254, 0.014> <-0.559, 2.263, -0.005> <-0.557, 2.258, -0.038> <-0.559, 2.261, -0.061> 
		<-0.541, 2.277, 0.014> <-0.554, 2.277, -0.005> <-0.549, 2.280, -0.038> <-0.552, 2.279, -0.061> 
		<-0.541, 2.293, 0.014> <-0.554, 2.293, -0.005> <-0.549, 2.293, -0.038> <-0.552, 2.293, -0.061> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.116, 2.278, -0.065> <1.116, 2.269, -0.063> <1.117, 2.252, -0.067> <1.117, 2.247, -0.059> 
		<1.130, 2.279, -0.065> <1.131, 2.269, -0.063> <1.138, 2.253, -0.066> <1.138, 2.248, -0.058> 
		<1.150, 2.288, -0.064> <1.156, 2.281, -0.062> <1.164, 2.265, -0.066> <1.167, 2.261, -0.058> 
		<1.159, 2.298, -0.064> <1.166, 2.292, -0.062> <1.178, 2.280, -0.065> <1.182, 2.277, -0.057> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.117, 2.247, -0.059> <1.117, 2.237, -0.043> <1.117, 2.229, -0.015> <1.116, 2.235, 0.003> 
		<1.138, 2.248, -0.058> <1.139, 2.238, -0.042> <1.141, 2.230, -0.014> <1.141, 2.236, 0.004> 
		<1.167, 2.261, -0.058> <1.174, 2.254, -0.042> <1.178, 2.247, -0.014> <1.173, 2.251, 0.004> 
		<1.182, 2.277, -0.057> <1.189, 2.270, -0.041> <1.194, 2.265, -0.013> <1.190, 2.268, 0.005> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.116, 2.235, 0.003> <1.116, 2.238, 0.013> <1.115, 2.263, 0.021> <1.115, 2.269, 0.013> 
		<1.141, 2.236, 0.004> <1.140, 2.239, 0.014> <1.132, 2.263, 0.021> <1.131, 2.270, 0.013> 
		<1.173, 2.251, 0.004> <1.171, 2.253, 0.014> <1.158, 2.275, 0.022> <1.154, 2.280, 0.013> 
		<1.190, 2.268, 0.005> <1.187, 2.270, 0.015> <1.169, 2.287, 0.022> <1.165, 2.292, 0.013> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.115, 2.269, 0.013> <1.115, 2.282, -0.006> <1.116, 2.278, -0.039> <1.116, 2.281, -0.062> 
		<1.131, 2.270, 0.013> <1.131, 2.283, -0.006> <1.129, 2.278, -0.039> <1.129, 2.282, -0.061> 
		<1.154, 2.280, 0.013> <1.144, 2.289, -0.005> <1.150, 2.288, -0.039> <1.148, 2.290, -0.061> 
		<1.165, 2.292, 0.013> <1.155, 2.300, -0.005> <1.159, 2.297, -0.039> <1.157, 2.300, -0.061> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.072, 2.295, -0.066> <1.065, 2.288, -0.064> <1.054, 2.276, -0.068> <1.051, 2.272, -0.060> 
		<1.082, 2.285, -0.065> <1.076, 2.278, -0.064> <1.070, 2.261, -0.067> <1.066, 2.258, -0.059> 
		<1.102, 2.278, -0.065> <1.102, 2.268, -0.063> <1.096, 2.252, -0.067> <1.096, 2.247, -0.059> 
		<1.116, 2.278, -0.065> <1.116, 2.269, -0.063> <1.117, 2.252, -0.067> <1.117, 2.247, -0.059> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.051, 2.272, -0.060> <1.043, 2.265, -0.044> <1.038, 2.259, -0.016> <1.041, 2.263, 0.002> 
		<1.066, 2.258, -0.059> <1.059, 2.250, -0.044> <1.055, 2.243, -0.016> <1.059, 2.247, 0.002> 
		<1.096, 2.247, -0.059> <1.096, 2.236, -0.043> <1.093, 2.229, -0.015> <1.092, 2.234, 0.003> 
		<1.117, 2.247, -0.059> <1.117, 2.237, -0.043> <1.117, 2.229, -0.015> <1.116, 2.235, 0.003> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.041, 2.263, 0.002> <1.043, 2.265, 0.012> <1.060, 2.284, 0.020> <1.064, 2.288, 0.012> 
		<1.059, 2.247, 0.002> <1.061, 2.249, 0.012> <1.072, 2.272, 0.020> <1.076, 2.277, 0.012> 
		<1.092, 2.234, 0.003> <1.092, 2.237, 0.013> <1.099, 2.262, 0.021> <1.099, 2.268, 0.012> 
		<1.116, 2.235, 0.003> <1.116, 2.238, 0.013> <1.115, 2.263, 0.021> <1.115, 2.269, 0.013> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.064, 2.288, 0.012> <1.073, 2.298, -0.007> <1.071, 2.294, -0.040> <1.074, 2.297, -0.062> 
		<1.076, 2.277, 0.012> <1.085, 2.286, -0.006> <1.081, 2.285, -0.040> <1.084, 2.288, -0.062> 
		<1.099, 2.268, 0.012> <1.099, 2.281, -0.006> <1.102, 2.277, -0.040> <1.103, 2.281, -0.062> 
		<1.115, 2.269, 0.013> <1.115, 2.282, -0.006> <1.116, 2.278, -0.039> <1.116, 2.281, -0.062> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.052, 2.338, -0.066> <1.043, 2.338, -0.064> <1.026, 2.337, -0.068> <1.021, 2.337, -0.060> 
		<1.053, 2.324, -0.066> <1.043, 2.323, -0.064> <1.027, 2.316, -0.068> <1.022, 2.316, -0.060> 
		<1.061, 2.305, -0.066> <1.055, 2.298, -0.064> <1.039, 2.290, -0.068> <1.035, 2.287, -0.060> 
		<1.072, 2.295, -0.066> <1.065, 2.288, -0.064> <1.054, 2.276, -0.068> <1.051, 2.272, -0.060> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.021, 2.337, -0.060> <1.011, 2.337, -0.044> <1.002, 2.336, -0.017> <1.008, 2.336, 0.001> 
		<1.022, 2.316, -0.060> <1.011, 2.315, -0.044> <1.003, 2.312, -0.017> <1.008, 2.312, 0.001> 
		<1.035, 2.287, -0.060> <1.028, 2.279, -0.044> <1.020, 2.276, -0.016> <1.023, 2.280, 0.002> 
		<1.051, 2.272, -0.060> <1.043, 2.265, -0.044> <1.038, 2.259, -0.016> <1.041, 2.263, 0.002> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.008, 2.336, 0.001> <1.011, 2.337, 0.012> <1.035, 2.337, 0.020> <1.042, 2.338, 0.011> 
		<1.008, 2.312, 0.001> <1.011, 2.312, 0.012> <1.036, 2.321, 0.020> <1.042, 2.321, 0.011> 
		<1.023, 2.280, 0.002> <1.025, 2.282, 0.012> <1.048, 2.295, 0.020> <1.052, 2.299, 0.012> 
		<1.041, 2.263, 0.002> <1.043, 2.265, 0.012> <1.060, 2.284, 0.020> <1.064, 2.288, 0.012> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.042, 2.338, 0.011> <1.055, 2.338, -0.007> <1.051, 2.338, -0.040> <1.055, 2.338, -0.063> 
		<1.042, 2.321, 0.011> <1.056, 2.322, -0.007> <1.052, 2.324, -0.040> <1.056, 2.325, -0.063> 
		<1.052, 2.299, 0.012> <1.061, 2.309, -0.007> <1.061, 2.304, -0.040> <1.064, 2.306, -0.063> 
		<1.064, 2.288, 0.012> <1.073, 2.298, -0.007> <1.071, 2.294, -0.040> <1.074, 2.297, -0.062> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.069, 2.382, -0.066> <1.062, 2.389, -0.064> <1.050, 2.400, -0.068> <1.046, 2.403, -0.060> 
		<1.059, 2.372, -0.066> <1.052, 2.378, -0.064> <1.035, 2.384, -0.068> <1.031, 2.388, -0.060> 
		<1.052, 2.352, -0.066> <1.042, 2.352, -0.064> <1.026, 2.358, -0.068> <1.020, 2.358, -0.060> 
		<1.052, 2.338, -0.066> <1.043, 2.338, -0.064> <1.026, 2.337, -0.068> <1.021, 2.337, -0.060> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.046, 2.403, -0.060> <1.038, 2.410, -0.044> <1.032, 2.416, -0.016> <1.036, 2.412, 0.002> 
		<1.031, 2.388, -0.060> <1.024, 2.395, -0.044> <1.016, 2.398, -0.016> <1.019, 2.394, 0.002> 
		<1.020, 2.358, -0.060> <1.010, 2.358, -0.044> <1.002, 2.360, -0.017> <1.007, 2.361, 0.001> 
		<1.021, 2.337, -0.060> <1.011, 2.337, -0.044> <1.002, 2.336, -0.017> <1.008, 2.336, 0.001> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.036, 2.412, 0.002> <1.038, 2.410, 0.012> <1.056, 2.393, 0.020> <1.061, 2.389, 0.012> 
		<1.019, 2.394, 0.002> <1.021, 2.392, 0.012> <1.045, 2.381, 0.020> <1.049, 2.377, 0.012> 
		<1.007, 2.361, 0.001> <1.010, 2.361, 0.012> <1.035, 2.354, 0.020> <1.041, 2.354, 0.011> 
		<1.008, 2.336, 0.001> <1.011, 2.337, 0.012> <1.035, 2.337, 0.020> <1.042, 2.338, 0.011> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.061, 2.389, 0.012> <1.071, 2.380, -0.007> <1.068, 2.383, -0.040> <1.071, 2.380, -0.062> 
		<1.049, 2.377, 0.012> <1.059, 2.368, -0.007> <1.059, 2.373, -0.040> <1.062, 2.370, -0.063> 
		<1.041, 2.354, 0.011> <1.054, 2.354, -0.007> <1.051, 2.351, -0.040> <1.055, 2.352, -0.063> 
		<1.042, 2.338, 0.011> <1.055, 2.338, -0.007> <1.051, 2.338, -0.040> <1.055, 2.338, -0.063> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.112, 2.402, -0.065> <1.111, 2.411, -0.063> <1.111, 2.428, -0.067> <1.111, 2.433, -0.059> 
		<1.098, 2.402, -0.065> <1.097, 2.411, -0.063> <1.090, 2.427, -0.067> <1.089, 2.432, -0.059> 
		<1.078, 2.393, -0.065> <1.072, 2.399, -0.064> <1.064, 2.416, -0.067> <1.061, 2.419, -0.059> 
		<1.069, 2.382, -0.066> <1.062, 2.389, -0.064> <1.050, 2.400, -0.068> <1.046, 2.403, -0.060> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.111, 2.433, -0.059> <1.110, 2.443, -0.043> <1.109, 2.451, -0.015> <1.109, 2.445, 0.003> 
		<1.089, 2.432, -0.059> <1.089, 2.442, -0.043> <1.085, 2.450, -0.015> <1.085, 2.444, 0.003> 
		<1.061, 2.419, -0.059> <1.053, 2.426, -0.044> <1.049, 2.433, -0.016> <1.052, 2.430, 0.002> 
		<1.046, 2.403, -0.060> <1.038, 2.410, -0.044> <1.032, 2.416, -0.016> <1.036, 2.412, 0.002> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.109, 2.445, 0.003> <1.109, 2.442, 0.013> <1.110, 2.417, 0.021> <1.110, 2.411, 0.013> 
		<1.085, 2.444, 0.003> <1.085, 2.441, 0.013> <1.093, 2.417, 0.021> <1.094, 2.411, 0.012> 
		<1.052, 2.430, 0.002> <1.054, 2.427, 0.012> <1.067, 2.405, 0.020> <1.072, 2.401, 0.012> 
		<1.036, 2.412, 0.002> <1.038, 2.410, 0.012> <1.056, 2.393, 0.020> <1.061, 2.389, 0.012> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.110, 2.411, 0.013> <1.111, 2.398, -0.006> <1.111, 2.403, -0.039> <1.112, 2.399, -0.062> 
		<1.094, 2.411, 0.012> <1.095, 2.398, -0.006> <1.098, 2.402, -0.040> <1.098, 2.398, -0.062> 
		<1.072, 2.401, 0.012> <1.082, 2.392, -0.006> <1.077, 2.393, -0.040> <1.080, 2.390, -0.062> 
		<1.061, 2.389, 0.012> <1.071, 2.380, -0.007> <1.068, 2.383, -0.040> <1.071, 2.380, -0.062> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.156, 2.385, -0.064> <1.163, 2.392, -0.062> <1.174, 2.404, -0.065> <1.177, 2.408, -0.057> 
		<1.146, 2.395, -0.064> <1.152, 2.402, -0.062> <1.158, 2.419, -0.066> <1.162, 2.423, -0.058> 
		<1.126, 2.402, -0.065> <1.126, 2.412, -0.063> <1.132, 2.429, -0.066> <1.132, 2.434, -0.058> 
		<1.112, 2.402, -0.065> <1.111, 2.411, -0.063> <1.111, 2.428, -0.067> <1.111, 2.433, -0.059> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.177, 2.408, -0.057> <1.184, 2.415, -0.041> <1.189, 2.421, -0.013> <1.185, 2.417, 0.005> 
		<1.162, 2.423, -0.058> <1.168, 2.430, -0.042> <1.171, 2.438, -0.014> <1.167, 2.434, 0.004> 
		<1.132, 2.434, -0.058> <1.131, 2.444, -0.042> <1.133, 2.452, -0.014> <1.133, 2.446, 0.004> 
		<1.111, 2.433, -0.059> <1.110, 2.443, -0.043> <1.109, 2.451, -0.015> <1.109, 2.445, 0.003> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.185, 2.417, 0.005> <1.182, 2.415, 0.015> <1.165, 2.397, 0.022> <1.161, 2.392, 0.013> 
		<1.167, 2.434, 0.004> <1.165, 2.431, 0.014> <1.153, 2.408, 0.022> <1.149, 2.403, 0.013> 
		<1.133, 2.446, 0.004> <1.133, 2.443, 0.014> <1.126, 2.418, 0.021> <1.126, 2.412, 0.013> 
		<1.109, 2.445, 0.003> <1.109, 2.442, 0.013> <1.110, 2.417, 0.021> <1.110, 2.411, 0.013> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.161, 2.392, 0.013> <1.153, 2.383, -0.005> <1.156, 2.386, -0.039> <1.154, 2.383, -0.061> 
		<1.149, 2.403, 0.013> <1.141, 2.394, -0.005> <1.146, 2.395, -0.039> <1.144, 2.392, -0.061> 
		<1.126, 2.412, 0.013> <1.127, 2.399, -0.006> <1.125, 2.403, -0.039> <1.125, 2.399, -0.061> 
		<1.110, 2.411, 0.013> <1.111, 2.398, -0.006> <1.111, 2.403, -0.039> <1.112, 2.399, -0.062> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.176, 2.342, -0.064> <1.185, 2.343, -0.062> <1.202, 2.343, -0.065> <1.207, 2.343, -0.057> 
		<1.175, 2.356, -0.064> <1.185, 2.357, -0.062> <1.201, 2.365, -0.065> <1.206, 2.365, -0.057> 
		<1.167, 2.376, -0.064> <1.173, 2.383, -0.062> <1.189, 2.390, -0.065> <1.193, 2.393, -0.057> 
		<1.156, 2.385, -0.064> <1.163, 2.392, -0.062> <1.174, 2.404, -0.065> <1.177, 2.408, -0.057> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.207, 2.343, -0.057> <1.217, 2.344, -0.041> <1.224, 2.344, -0.013> <1.218, 2.344, 0.005> 
		<1.206, 2.365, -0.057> <1.216, 2.365, -0.041> <1.223, 2.368, -0.013> <1.217, 2.368, 0.005> 
		<1.193, 2.393, -0.057> <1.199, 2.401, -0.041> <1.206, 2.405, -0.013> <1.202, 2.401, 0.005> 
		<1.177, 2.408, -0.057> <1.184, 2.415, -0.041> <1.189, 2.421, -0.013> <1.185, 2.417, 0.005> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.218, 2.344, 0.005> <1.215, 2.344, 0.015> <1.190, 2.343, 0.023> <1.184, 2.343, 0.014> 
		<1.217, 2.368, 0.005> <1.214, 2.368, 0.015> <1.189, 2.359, 0.023> <1.183, 2.359, 0.014> 
		<1.202, 2.401, 0.005> <1.200, 2.398, 0.015> <1.177, 2.385, 0.022> <1.173, 2.381, 0.014> 
		<1.185, 2.417, 0.005> <1.182, 2.415, 0.015> <1.165, 2.397, 0.022> <1.161, 2.392, 0.013> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.184, 2.343, 0.014> <1.171, 2.342, -0.005> <1.176, 2.342, -0.038> <1.173, 2.342, -0.061> 
		<1.183, 2.359, 0.014> <1.170, 2.358, -0.005> <1.176, 2.356, -0.038> <1.172, 2.356, -0.061> 
		<1.173, 2.381, 0.014> <1.165, 2.371, -0.005> <1.166, 2.377, -0.038> <1.164, 2.374, -0.061> 
		<1.161, 2.392, 0.013> <1.153, 2.383, -0.005> <1.156, 2.386, -0.039> <1.154, 2.383, -0.061> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.159, 2.298, -0.064> <1.166, 2.292, -0.062> <1.178, 2.280, -0.065> <1.182, 2.277, -0.057> 
		<1.169, 2.308, -0.064> <1.176, 2.302, -0.062> <1.193, 2.296, -0.065> <1.196, 2.292, -0.057> 
		<1.176, 2.328, -0.064> <1.186, 2.328, -0.062> <1.202, 2.322, -0.065> <1.207, 2.322, -0.057> 
		<1.176, 2.342, -0.064> <1.185, 2.343, -0.062> <1.202, 2.343, -0.065> <1.207, 2.343, -0.057> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.182, 2.277, -0.057> <1.189, 2.270, -0.041> <1.194, 2.265, -0.013> <1.190, 2.268, 0.005> 
		<1.196, 2.292, -0.057> <1.203, 2.285, -0.041> <1.211, 2.282, -0.013> <1.206, 2.286, 0.005> 
		<1.207, 2.322, -0.057> <1.217, 2.322, -0.041> <1.225, 2.320, -0.013> <1.219, 2.320, 0.005> 
		<1.207, 2.343, -0.057> <1.217, 2.344, -0.041> <1.224, 2.344, -0.013> <1.218, 2.344, 0.005> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.190, 2.268, 0.005> <1.187, 2.270, 0.015> <1.169, 2.287, 0.022> <1.165, 2.292, 0.013> 
		<1.206, 2.286, 0.005> <1.204, 2.288, 0.015> <1.180, 2.299, 0.022> <1.176, 2.303, 0.014> 
		<1.219, 2.320, 0.005> <1.216, 2.319, 0.015> <1.190, 2.326, 0.023> <1.184, 2.326, 0.014> 
		<1.218, 2.344, 0.005> <1.215, 2.344, 0.015> <1.190, 2.343, 0.023> <1.184, 2.343, 0.014> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.165, 2.292, 0.013> <1.155, 2.300, -0.005> <1.159, 2.297, -0.039> <1.157, 2.300, -0.061> 
		<1.176, 2.303, 0.014> <1.167, 2.312, -0.005> <1.168, 2.307, -0.038> <1.166, 2.310, -0.061> 
		<1.184, 2.326, 0.014> <1.172, 2.326, -0.005> <1.177, 2.329, -0.038> <1.173, 2.329, -0.061> 
		<1.184, 2.343, 0.014> <1.171, 2.342, -0.005> <1.176, 2.342, -0.038> <1.173, 2.342, -0.061> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.681, 2.176, 0.121> <-0.678, 2.175, 0.139> <-0.684, 2.177, 0.170> <-0.669, 2.172, 0.181> 
		<-0.683, 2.151, 0.121> <-0.680, 2.150, 0.139> <-0.687, 2.139, 0.170> <-0.673, 2.134, 0.180> 
		<-0.687, 2.117, 0.105> <-0.684, 2.104, 0.117> <-0.691, 2.094, 0.149> <-0.678, 2.083, 0.156> 
		<-0.689, 2.101, 0.086> <-0.686, 2.088, 0.098> <-0.694, 2.069, 0.121> <-0.681, 2.059, 0.128> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.669, 2.172, 0.181> <-0.643, 2.163, 0.199> <-0.596, 2.146, 0.212> <-0.567, 2.136, 0.200> 
		<-0.673, 2.134, 0.180> <-0.647, 2.125, 0.199> <-0.600, 2.104, 0.212> <-0.571, 2.094, 0.200> 
		<-0.678, 2.083, 0.156> <-0.654, 2.063, 0.168> <-0.609, 2.040, 0.182> <-0.577, 2.036, 0.172> 
		<-0.681, 2.059, 0.128> <-0.657, 2.038, 0.140> <-0.612, 2.012, 0.150> <-0.580, 2.008, 0.141> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.567, 2.136, 0.200> <-0.549, 2.130, 0.193> <-0.538, 2.127, 0.146> <-0.554, 2.132, 0.134> 
		<-0.571, 2.094, 0.200> <-0.553, 2.088, 0.193> <-0.541, 2.098, 0.146> <-0.556, 2.103, 0.134> 
		<-0.577, 2.036, 0.172> <-0.559, 2.034, 0.167> <-0.547, 2.053, 0.122> <-0.560, 2.064, 0.115> 
		<-0.580, 2.008, 0.141> <-0.562, 2.006, 0.135> <-0.550, 2.034, 0.101> <-0.562, 2.045, 0.093> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.554, 2.132, 0.134> <-0.584, 2.142, 0.110> <-0.640, 2.162, 0.120> <-0.676, 2.174, 0.115> 
		<-0.556, 2.103, 0.134> <-0.586, 2.113, 0.110> <-0.642, 2.138, 0.120> <-0.678, 2.151, 0.115> 
		<-0.560, 2.064, 0.115> <-0.588, 2.089, 0.099> <-0.645, 2.101, 0.103> <-0.682, 2.118, 0.099> 
		<-0.562, 2.045, 0.093> <-0.590, 2.070, 0.078> <-0.647, 2.085, 0.085> <-0.684, 2.103, 0.081> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.676, 2.252, 0.086> <-0.671, 2.262, 0.099> <-0.676, 2.284, 0.121> <-0.661, 2.286, 0.128> 
		<-0.677, 2.235, 0.105> <-0.672, 2.245, 0.117> <-0.678, 2.259, 0.149> <-0.662, 2.261, 0.156> 
		<-0.679, 2.201, 0.121> <-0.676, 2.200, 0.139> <-0.681, 2.214, 0.171> <-0.666, 2.209, 0.181> 
		<-0.681, 2.176, 0.121> <-0.678, 2.175, 0.139> <-0.684, 2.177, 0.170> <-0.669, 2.172, 0.181> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.661, 2.286, 0.128> <-0.632, 2.289, 0.141> <-0.584, 2.281, 0.149> <-0.558, 2.266, 0.141> 
		<-0.662, 2.261, 0.156> <-0.634, 2.264, 0.169> <-0.586, 2.253, 0.181> <-0.559, 2.237, 0.172> 
		<-0.666, 2.209, 0.181> <-0.640, 2.200, 0.199> <-0.592, 2.189, 0.212> <-0.563, 2.179, 0.200> 
		<-0.669, 2.172, 0.181> <-0.643, 2.163, 0.199> <-0.596, 2.146, 0.212> <-0.567, 2.136, 0.200> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.558, 2.266, 0.141> <-0.541, 2.256, 0.136> <-0.530, 2.222, 0.103> <-0.547, 2.219, 0.093> 
		<-0.559, 2.237, 0.172> <-0.542, 2.227, 0.167> <-0.531, 2.203, 0.124> <-0.548, 2.200, 0.115> 
		<-0.563, 2.179, 0.200> <-0.545, 2.173, 0.193> <-0.536, 2.155, 0.146> <-0.551, 2.161, 0.134> 
		<-0.567, 2.136, 0.200> <-0.549, 2.130, 0.193> <-0.538, 2.127, 0.146> <-0.554, 2.132, 0.134> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.547, 2.219, 0.093> <-0.581, 2.214, 0.076> <-0.634, 2.238, 0.085> <-0.671, 2.247, 0.081> 
		<-0.548, 2.200, 0.115> <-0.582, 2.194, 0.097> <-0.635, 2.222, 0.103> <-0.672, 2.231, 0.099> 
		<-0.551, 2.161, 0.134> <-0.581, 2.171, 0.110> <-0.638, 2.185, 0.120> <-0.674, 2.198, 0.115> 
		<-0.554, 2.132, 0.134> <-0.584, 2.142, 0.110> <-0.640, 2.162, 0.120> <-0.676, 2.174, 0.115> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.676, 2.284, 0.001> <-0.671, 2.299, 0.001> <-0.676, 2.330, 0.001> <-0.661, 2.334, 0.001> 
		<-0.675, 2.284, 0.028> <-0.670, 2.299, 0.028> <-0.674, 2.329, 0.042> <-0.660, 2.334, 0.042> 
		<-0.675, 2.270, 0.066> <-0.670, 2.281, 0.078> <-0.675, 2.312, 0.091> <-0.660, 2.313, 0.098> 
		<-0.676, 2.252, 0.086> <-0.671, 2.262, 0.099> <-0.676, 2.284, 0.121> <-0.661, 2.286, 0.128> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.661, 2.334, 0.001> <-0.631, 2.344, -0.000> <-0.583, 2.339, -0.002> <-0.557, 2.321, -0.003> 
		<-0.660, 2.334, 0.042> <-0.630, 2.343, 0.040> <-0.582, 2.338, 0.044> <-0.556, 2.320, 0.043> 
		<-0.660, 2.313, 0.098> <-0.631, 2.317, 0.111> <-0.583, 2.313, 0.114> <-0.556, 2.297, 0.106> 
		<-0.661, 2.286, 0.128> <-0.632, 2.289, 0.141> <-0.584, 2.281, 0.149> <-0.558, 2.266, 0.141> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.557, 2.321, -0.003> <-0.541, 2.310, -0.004> <-0.529, 2.264, -0.005> <-0.547, 2.257, -0.004> 
		<-0.556, 2.320, 0.043> <-0.540, 2.309, 0.042> <-0.528, 2.263, 0.027> <-0.546, 2.256, 0.027> 
		<-0.556, 2.297, 0.106> <-0.539, 2.287, 0.101> <-0.529, 2.243, 0.079> <-0.546, 2.240, 0.070> 
		<-0.558, 2.266, 0.141> <-0.541, 2.256, 0.136> <-0.530, 2.222, 0.103> <-0.547, 2.219, 0.093> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.547, 2.257, -0.004> <-0.582, 2.243, -0.003> <-0.634, 2.271, -0.001> <-0.671, 2.277, 0.001> 
		<-0.546, 2.256, 0.027> <-0.581, 2.243, 0.029> <-0.633, 2.271, 0.025> <-0.670, 2.277, 0.027> 
		<-0.546, 2.240, 0.070> <-0.580, 2.235, 0.053> <-0.633, 2.256, 0.066> <-0.670, 2.264, 0.062> 
		<-0.547, 2.219, 0.093> <-0.581, 2.214, 0.076> <-0.634, 2.238, 0.085> <-0.671, 2.247, 0.081> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.681, 2.254, -0.084> <-0.677, 2.264, -0.096> <-0.683, 2.287, -0.118> <-0.669, 2.289, -0.126> 
		<-0.679, 2.272, -0.063> <-0.675, 2.282, -0.076> <-0.680, 2.314, -0.088> <-0.665, 2.316, -0.096> 
		<-0.676, 2.285, -0.026> <-0.672, 2.300, -0.026> <-0.677, 2.330, -0.039> <-0.662, 2.335, -0.040> 
		<-0.676, 2.284, 0.001> <-0.671, 2.299, 0.001> <-0.676, 2.330, 0.001> <-0.661, 2.334, 0.001> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.669, 2.289, -0.126> <-0.641, 2.292, -0.142> <-0.593, 2.285, -0.153> <-0.566, 2.269, -0.148> 
		<-0.665, 2.316, -0.096> <-0.638, 2.319, -0.112> <-0.590, 2.315, -0.119> <-0.562, 2.299, -0.113> 
		<-0.662, 2.335, -0.040> <-0.632, 2.344, -0.041> <-0.584, 2.339, -0.048> <-0.559, 2.321, -0.049> 
		<-0.661, 2.334, 0.001> <-0.631, 2.344, -0.000> <-0.583, 2.339, -0.002> <-0.557, 2.321, -0.003> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.566, 2.269, -0.148> <-0.549, 2.259, -0.144> <-0.536, 2.225, -0.112> <-0.553, 2.222, -0.102> 
		<-0.562, 2.299, -0.113> <-0.545, 2.289, -0.109> <-0.534, 2.245, -0.089> <-0.551, 2.242, -0.078> 
		<-0.559, 2.321, -0.049> <-0.543, 2.310, -0.050> <-0.530, 2.264, -0.036> <-0.548, 2.257, -0.035> 
		<-0.557, 2.321, -0.003> <-0.541, 2.310, -0.004> <-0.529, 2.264, -0.005> <-0.547, 2.257, -0.004> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.553, 2.222, -0.102> <-0.585, 2.216, -0.082> <-0.639, 2.240, -0.086> <-0.676, 2.248, -0.080> 
		<-0.551, 2.242, -0.078> <-0.583, 2.236, -0.058> <-0.637, 2.257, -0.067> <-0.674, 2.265, -0.060> 
		<-0.548, 2.257, -0.035> <-0.583, 2.243, -0.034> <-0.635, 2.271, -0.026> <-0.672, 2.278, -0.025> 
		<-0.547, 2.257, -0.004> <-0.582, 2.243, -0.003> <-0.634, 2.271, -0.001> <-0.671, 2.277, 0.001> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.688, 2.179, -0.119> <-0.686, 2.178, -0.137> <-0.694, 2.180, -0.168> <-0.680, 2.176, -0.179> 
		<-0.686, 2.203, -0.119> <-0.684, 2.203, -0.137> <-0.690, 2.218, -0.168> <-0.677, 2.213, -0.179> 
		<-0.683, 2.237, -0.102> <-0.679, 2.248, -0.115> <-0.686, 2.262, -0.146> <-0.672, 2.264, -0.155> 
		<-0.681, 2.254, -0.084> <-0.677, 2.264, -0.096> <-0.683, 2.287, -0.118> <-0.669, 2.289, -0.126> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.680, 2.176, -0.179> <-0.655, 2.167, -0.199> <-0.609, 2.151, -0.217> <-0.579, 2.141, -0.207> 
		<-0.677, 2.213, -0.179> <-0.652, 2.205, -0.199> <-0.605, 2.194, -0.217> <-0.575, 2.183, -0.207> 
		<-0.672, 2.264, -0.155> <-0.644, 2.268, -0.170> <-0.597, 2.257, -0.185> <-0.570, 2.241, -0.179> 
		<-0.669, 2.289, -0.126> <-0.641, 2.292, -0.142> <-0.593, 2.285, -0.153> <-0.566, 2.269, -0.148> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.579, 2.141, -0.207> <-0.561, 2.134, -0.202> <-0.547, 2.130, -0.155> <-0.562, 2.135, -0.142> 
		<-0.575, 2.183, -0.207> <-0.557, 2.177, -0.202> <-0.545, 2.159, -0.155> <-0.559, 2.164, -0.142> 
		<-0.570, 2.241, -0.179> <-0.552, 2.231, -0.176> <-0.538, 2.206, -0.134> <-0.555, 2.203, -0.123> 
		<-0.566, 2.269, -0.148> <-0.549, 2.259, -0.144> <-0.536, 2.225, -0.112> <-0.553, 2.222, -0.102> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.562, 2.135, -0.142> <-0.590, 2.145, -0.116> <-0.647, 2.164, -0.122> <-0.683, 2.177, -0.113> 
		<-0.559, 2.164, -0.142> <-0.588, 2.173, -0.116> <-0.645, 2.188, -0.122> <-0.681, 2.200, -0.113> 
		<-0.555, 2.203, -0.123> <-0.588, 2.196, -0.103> <-0.641, 2.225, -0.104> <-0.678, 2.233, -0.097> 
		<-0.553, 2.222, -0.102> <-0.585, 2.216, -0.082> <-0.639, 2.240, -0.086> <-0.676, 2.248, -0.080> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.694, 2.102, -0.084> <-0.692, 2.090, -0.097> <-0.701, 2.072, -0.119> <-0.688, 2.061, -0.127> 
		<-0.693, 2.119, -0.102> <-0.691, 2.107, -0.115> <-0.699, 2.097, -0.147> <-0.687, 2.087, -0.155> 
		<-0.691, 2.153, -0.119> <-0.688, 2.153, -0.137> <-0.697, 2.143, -0.168> <-0.683, 2.138, -0.179> 
		<-0.688, 2.179, -0.119> <-0.686, 2.178, -0.137> <-0.694, 2.180, -0.168> <-0.680, 2.176, -0.179> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.688, 2.061, -0.127> <-0.665, 2.041, -0.141> <-0.622, 2.015, -0.155> <-0.588, 2.011, -0.148> 
		<-0.687, 2.087, -0.155> <-0.663, 2.067, -0.169> <-0.620, 2.044, -0.186> <-0.587, 2.040, -0.179> 
		<-0.683, 2.138, -0.179> <-0.658, 2.129, -0.199> <-0.613, 2.108, -0.217> <-0.583, 2.098, -0.207> 
		<-0.680, 2.176, -0.179> <-0.655, 2.167, -0.199> <-0.609, 2.151, -0.217> <-0.579, 2.141, -0.207> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.588, 2.011, -0.148> <-0.570, 2.009, -0.144> <-0.556, 2.036, -0.110> <-0.568, 2.047, -0.102> 
		<-0.587, 2.040, -0.179> <-0.569, 2.038, -0.176> <-0.555, 2.055, -0.131> <-0.567, 2.067, -0.123> 
		<-0.583, 2.098, -0.207> <-0.564, 2.092, -0.202> <-0.550, 2.101, -0.155> <-0.564, 2.106, -0.142> 
		<-0.579, 2.141, -0.207> <-0.561, 2.134, -0.202> <-0.547, 2.130, -0.155> <-0.562, 2.135, -0.142> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.568, 2.047, -0.102> <-0.595, 2.072, -0.084> <-0.652, 2.087, -0.086> <-0.688, 2.104, -0.080> 
		<-0.567, 2.067, -0.123> <-0.594, 2.091, -0.105> <-0.651, 2.103, -0.104> <-0.688, 2.120, -0.097> 
		<-0.564, 2.106, -0.142> <-0.593, 2.116, -0.116> <-0.649, 2.140, -0.122> <-0.685, 2.153, -0.113> 
		<-0.562, 2.135, -0.142> <-0.590, 2.145, -0.116> <-0.647, 2.164, -0.122> <-0.683, 2.177, -0.113> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.694, 2.070, 0.001> <-0.692, 2.053, 0.001> <-0.700, 2.026, 0.001> <-0.689, 2.013, 0.001> 
		<-0.695, 2.070, -0.026> <-0.693, 2.053, -0.026> <-0.702, 2.026, -0.040> <-0.690, 2.013, -0.040> 
		<-0.695, 2.084, -0.064> <-0.693, 2.072, -0.076> <-0.702, 2.045, -0.089> <-0.690, 2.034, -0.096> 
		<-0.694, 2.102, -0.084> <-0.692, 2.090, -0.097> <-0.701, 2.072, -0.119> <-0.688, 2.061, -0.127> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.689, 2.013, 0.001> <-0.665, 1.988, -0.000> <-0.623, 1.957, -0.002> <-0.589, 1.956, -0.004> 
		<-0.690, 2.013, -0.040> <-0.666, 1.988, -0.041> <-0.625, 1.958, -0.049> <-0.590, 1.957, -0.050> 
		<-0.690, 2.034, -0.096> <-0.666, 2.014, -0.111> <-0.623, 1.984, -0.120> <-0.590, 1.980, -0.113> 
		<-0.688, 2.061, -0.127> <-0.665, 2.041, -0.141> <-0.622, 2.015, -0.155> <-0.588, 2.011, -0.148> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.589, 1.956, -0.004> <-0.572, 1.956, -0.004> <-0.557, 1.997, -0.005> <-0.568, 2.010, -0.004> 
		<-0.590, 1.957, -0.050> <-0.573, 1.957, -0.051> <-0.558, 1.997, -0.036> <-0.569, 2.010, -0.036> 
		<-0.590, 1.980, -0.113> <-0.572, 1.978, -0.110> <-0.557, 2.015, -0.087> <-0.569, 2.026, -0.079> 
		<-0.588, 2.011, -0.148> <-0.570, 2.009, -0.144> <-0.556, 2.036, -0.110> <-0.568, 2.047, -0.102> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.568, 2.010, -0.004> <-0.595, 2.041, -0.003> <-0.653, 2.055, -0.001> <-0.689, 2.074, 0.001> 
		<-0.569, 2.010, -0.036> <-0.596, 2.041, -0.034> <-0.653, 2.055, -0.027> <-0.689, 2.074, -0.025> 
		<-0.569, 2.026, -0.079> <-0.596, 2.051, -0.060> <-0.653, 2.070, -0.067> <-0.689, 2.087, -0.061> 
		<-0.568, 2.047, -0.102> <-0.595, 2.072, -0.084> <-0.652, 2.087, -0.086> <-0.688, 2.104, -0.080> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.689, 2.101, 0.086> <-0.686, 2.088, 0.098> <-0.694, 2.069, 0.121> <-0.681, 2.059, 0.128> 
		<-0.691, 2.083, 0.066> <-0.689, 2.070, 0.078> <-0.697, 2.043, 0.091> <-0.684, 2.032, 0.097> 
		<-0.693, 2.070, 0.028> <-0.692, 2.053, 0.028> <-0.699, 2.025, 0.042> <-0.687, 2.013, 0.041> 
		<-0.694, 2.070, 0.001> <-0.692, 2.053, 0.001> <-0.700, 2.026, 0.001> <-0.689, 2.013, 0.001> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.681, 2.059, 0.128> <-0.657, 2.038, 0.140> <-0.612, 2.012, 0.150> <-0.580, 2.008, 0.141> 
		<-0.684, 2.032, 0.097> <-0.660, 2.011, 0.110> <-0.616, 1.982, 0.116> <-0.584, 1.978, 0.106> 
		<-0.687, 2.013, 0.041> <-0.664, 1.987, 0.040> <-0.622, 1.957, 0.044> <-0.587, 1.956, 0.042> 
		<-0.689, 2.013, 0.001> <-0.665, 1.988, -0.000> <-0.623, 1.957, -0.002> <-0.589, 1.956, -0.004> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.580, 2.008, 0.141> <-0.562, 2.006, 0.135> <-0.550, 2.034, 0.101> <-0.562, 2.045, 0.093> 
		<-0.584, 1.978, 0.106> <-0.566, 1.976, 0.101> <-0.552, 2.013, 0.077> <-0.565, 2.025, 0.070> 
		<-0.587, 1.956, 0.042> <-0.570, 1.956, 0.042> <-0.556, 1.997, 0.026> <-0.568, 2.010, 0.027> 
		<-0.589, 1.956, -0.004> <-0.572, 1.956, -0.004> <-0.557, 1.997, -0.005> <-0.568, 2.010, -0.004> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.562, 2.045, 0.093> <-0.590, 2.070, 0.078> <-0.647, 2.085, 0.085> <-0.684, 2.103, 0.081> 
		<-0.565, 2.025, 0.070> <-0.592, 2.050, 0.054> <-0.649, 2.068, 0.066> <-0.686, 2.086, 0.062> 
		<-0.568, 2.010, 0.027> <-0.594, 2.041, 0.028> <-0.652, 2.054, 0.025> <-0.688, 2.073, 0.027> 
		<-0.568, 2.010, -0.004> <-0.595, 2.041, -0.003> <-0.653, 2.055, -0.001> <-0.689, 2.074, 0.001> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.127, 2.212, 0.119> <1.130, 2.214, 0.137> <1.123, 2.212, 0.168> <1.137, 2.217, 0.179> 
		<1.140, 2.191, 0.120> <1.143, 2.193, 0.138> <1.143, 2.181, 0.169> <1.157, 2.186, 0.180> 
		<1.159, 2.162, 0.104> <1.168, 2.154, 0.117> <1.169, 2.143, 0.150> <1.185, 2.142, 0.157> 
		<1.168, 2.148, 0.086> <1.177, 2.140, 0.099> <1.182, 2.121, 0.122> <1.199, 2.120, 0.129> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.137, 2.217, 0.179> <1.162, 2.226, 0.198> <1.209, 2.243, 0.212> <1.238, 2.253, 0.202> 
		<1.157, 2.186, 0.180> <1.183, 2.195, 0.199> <1.232, 2.207, 0.214> <1.262, 2.217, 0.203> 
		<1.185, 2.142, 0.157> <1.217, 2.141, 0.170> <1.265, 2.151, 0.185> <1.293, 2.168, 0.176> 
		<1.199, 2.120, 0.129> <1.230, 2.119, 0.142> <1.281, 2.126, 0.154> <1.309, 2.143, 0.145> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.238, 2.253, 0.202> <1.257, 2.259, 0.195> <1.269, 2.262, 0.148> <1.254, 2.256, 0.135> 
		<1.262, 2.217, 0.203> <1.280, 2.223, 0.196> <1.285, 2.238, 0.149> <1.270, 2.232, 0.136> 
		<1.293, 2.168, 0.176> <1.309, 2.177, 0.172> <1.308, 2.198, 0.126> <1.291, 2.199, 0.118> 
		<1.309, 2.143, 0.145> <1.325, 2.152, 0.140> <1.319, 2.181, 0.105> <1.302, 2.182, 0.097> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.254, 2.256, 0.135> <1.225, 2.246, 0.111> <1.168, 2.227, 0.120> <1.132, 2.214, 0.113> 
		<1.270, 2.232, 0.136> <1.240, 2.222, 0.112> <1.181, 2.207, 0.120> <1.145, 2.194, 0.114> 
		<1.291, 2.199, 0.118> <1.254, 2.202, 0.101> <1.202, 2.175, 0.104> <1.163, 2.167, 0.099> 
		<1.302, 2.182, 0.097> <1.265, 2.185, 0.080> <1.210, 2.162, 0.086> <1.171, 2.153, 0.081> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.085, 2.275, 0.082> <1.082, 2.286, 0.094> <1.064, 2.301, 0.116> <1.075, 2.312, 0.123> 
		<1.094, 2.262, 0.101> <1.091, 2.273, 0.113> <1.078, 2.280, 0.144> <1.088, 2.291, 0.152> 
		<1.113, 2.234, 0.118> <1.116, 2.235, 0.136> <1.102, 2.244, 0.167> <1.116, 2.249, 0.178> 
		<1.127, 2.212, 0.119> <1.130, 2.214, 0.137> <1.123, 2.212, 0.168> <1.137, 2.217, 0.179> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.075, 2.312, 0.123> <1.095, 2.332, 0.137> <1.137, 2.356, 0.145> <1.168, 2.360, 0.138> 
		<1.088, 2.291, 0.152> <1.108, 2.312, 0.166> <1.153, 2.333, 0.178> <1.184, 2.337, 0.171> 
		<1.116, 2.249, 0.178> <1.142, 2.258, 0.197> <1.185, 2.279, 0.211> <1.215, 2.289, 0.200> 
		<1.137, 2.217, 0.179> <1.162, 2.226, 0.198> <1.209, 2.243, 0.212> <1.238, 2.253, 0.202> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.168, 2.360, 0.138> <1.188, 2.362, 0.134> <1.218, 2.342, 0.102> <1.206, 2.329, 0.093> 
		<1.184, 2.337, 0.171> <1.203, 2.339, 0.166> <1.228, 2.327, 0.124> <1.217, 2.313, 0.115> 
		<1.215, 2.289, 0.200> <1.233, 2.295, 0.194> <1.253, 2.286, 0.147> <1.238, 2.281, 0.135> 
		<1.238, 2.253, 0.202> <1.257, 2.259, 0.195> <1.269, 2.262, 0.148> <1.254, 2.256, 0.135> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.206, 2.329, 0.093> <1.184, 2.304, 0.075> <1.127, 2.290, 0.082> <1.093, 2.274, 0.078> 
		<1.217, 2.313, 0.115> <1.194, 2.288, 0.097> <1.135, 2.277, 0.100> <1.101, 2.261, 0.096> 
		<1.238, 2.281, 0.135> <1.209, 2.270, 0.110> <1.155, 2.247, 0.119> <1.119, 2.234, 0.112> 
		<1.254, 2.256, 0.135> <1.225, 2.246, 0.111> <1.168, 2.227, 0.120> <1.132, 2.214, 0.113> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.068, 2.300, -0.004> <1.063, 2.315, -0.004> <1.040, 2.336, -0.005> <1.049, 2.349, -0.005> 
		<1.068, 2.301, 0.023> <1.063, 2.315, 0.023> <1.040, 2.337, 0.036> <1.049, 2.350, 0.035> 
		<1.076, 2.290, 0.061> <1.072, 2.301, 0.073> <1.049, 2.323, 0.085> <1.060, 2.334, 0.092> 
		<1.085, 2.275, 0.082> <1.082, 2.286, 0.094> <1.064, 2.301, 0.116> <1.075, 2.312, 0.123> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.049, 2.349, -0.005> <1.067, 2.374, -0.006> <1.108, 2.400, -0.007> <1.139, 2.402, -0.007> 
		<1.049, 2.350, 0.035> <1.067, 2.375, 0.035> <1.108, 2.401, 0.039> <1.139, 2.403, 0.039> 
		<1.060, 2.334, 0.092> <1.080, 2.354, 0.106> <1.121, 2.381, 0.110> <1.151, 2.385, 0.103> 
		<1.075, 2.312, 0.123> <1.095, 2.332, 0.137> <1.137, 2.356, 0.145> <1.168, 2.360, 0.138> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.139, 2.402, -0.007> <1.159, 2.403, -0.007> <1.197, 2.374, -0.006> <1.187, 2.357, -0.006> 
		<1.139, 2.403, 0.039> <1.159, 2.404, 0.039> <1.197, 2.375, 0.025> <1.187, 2.358, 0.025> 
		<1.151, 2.385, 0.103> <1.171, 2.387, 0.099> <1.207, 2.359, 0.078> <1.195, 2.346, 0.069> 
		<1.168, 2.360, 0.138> <1.188, 2.362, 0.134> <1.218, 2.342, 0.102> <1.206, 2.329, 0.093> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.187, 2.357, -0.006> <1.167, 2.325, -0.005> <1.110, 2.315, -0.004> <1.076, 2.297, -0.004> 
		<1.187, 2.358, 0.025> <1.167, 2.326, 0.027> <1.109, 2.316, 0.021> <1.076, 2.298, 0.022> 
		<1.195, 2.346, 0.069> <1.173, 2.321, 0.051> <1.117, 2.304, 0.062> <1.083, 2.288, 0.058> 
		<1.206, 2.329, 0.093> <1.184, 2.304, 0.075> <1.127, 2.290, 0.082> <1.093, 2.274, 0.078> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.086, 2.272, -0.088> <1.083, 2.282, -0.101> <1.065, 2.296, -0.123> <1.075, 2.306, -0.131> 
		<1.076, 2.288, -0.068> <1.073, 2.298, -0.081> <1.050, 2.319, -0.094> <1.061, 2.330, -0.102> 
		<1.069, 2.300, -0.031> <1.063, 2.314, -0.031> <1.040, 2.335, -0.046> <1.049, 2.348, -0.046> 
		<1.068, 2.300, -0.004> <1.063, 2.315, -0.004> <1.040, 2.336, -0.005> <1.049, 2.349, -0.005> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.075, 2.306, -0.131> <1.096, 2.326, -0.146> <1.138, 2.349, -0.157> <1.169, 2.354, -0.150> 
		<1.061, 2.330, -0.102> <1.081, 2.350, -0.117> <1.121, 2.376, -0.123> <1.152, 2.380, -0.116> 
		<1.049, 2.348, -0.046> <1.067, 2.374, -0.047> <1.108, 2.399, -0.053> <1.140, 2.401, -0.053> 
		<1.049, 2.349, -0.005> <1.067, 2.374, -0.006> <1.108, 2.400, -0.007> <1.139, 2.402, -0.007> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.169, 2.354, -0.150> <1.189, 2.356, -0.146> <1.219, 2.338, -0.113> <1.207, 2.325, -0.102> 
		<1.152, 2.380, -0.116> <1.172, 2.383, -0.112> <1.207, 2.356, -0.090> <1.195, 2.343, -0.080> 
		<1.140, 2.401, -0.053> <1.159, 2.402, -0.053> <1.197, 2.373, -0.038> <1.187, 2.357, -0.037> 
		<1.139, 2.402, -0.007> <1.159, 2.403, -0.007> <1.197, 2.374, -0.006> <1.187, 2.357, -0.006> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.207, 2.325, -0.102> <1.185, 2.301, -0.083> <1.127, 2.287, -0.089> <1.093, 2.271, -0.084> 
		<1.195, 2.343, -0.080> <1.173, 2.318, -0.060> <1.118, 2.302, -0.070> <1.084, 2.285, -0.065> 
		<1.187, 2.357, -0.037> <1.168, 2.324, -0.036> <1.110, 2.315, -0.030> <1.077, 2.297, -0.030> 
		<1.187, 2.357, -0.006> <1.167, 2.325, -0.005> <1.110, 2.315, -0.004> <1.076, 2.297, -0.004> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.127, 2.207, -0.121> <1.131, 2.208, -0.139> <1.124, 2.205, -0.170> <1.138, 2.210, -0.181> 
		<1.114, 2.228, -0.122> <1.117, 2.229, -0.140> <1.103, 2.237, -0.171> <1.117, 2.241, -0.182> 
		<1.095, 2.257, -0.106> <1.092, 2.268, -0.119> <1.079, 2.274, -0.151> <1.089, 2.285, -0.159> 
		<1.086, 2.272, -0.088> <1.083, 2.282, -0.101> <1.065, 2.296, -0.123> <1.075, 2.306, -0.131> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.138, 2.210, -0.181> <1.163, 2.218, -0.200> <1.210, 2.234, -0.217> <1.240, 2.244, -0.206> 
		<1.117, 2.241, -0.182> <1.143, 2.249, -0.201> <1.187, 2.269, -0.218> <1.216, 2.280, -0.207> 
		<1.089, 2.285, -0.159> <1.109, 2.304, -0.174> <1.154, 2.325, -0.188> <1.185, 2.329, -0.181> 
		<1.075, 2.306, -0.131> <1.096, 2.326, -0.146> <1.138, 2.349, -0.157> <1.169, 2.354, -0.150> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.240, 2.244, -0.206> <1.258, 2.250, -0.200> <1.270, 2.256, -0.153> <1.255, 2.251, -0.140> 
		<1.216, 2.280, -0.207> <1.235, 2.286, -0.201> <1.254, 2.280, -0.154> <1.239, 2.275, -0.141> 
		<1.185, 2.329, -0.181> <1.204, 2.332, -0.177> <1.229, 2.321, -0.134> <1.218, 2.308, -0.123> 
		<1.169, 2.354, -0.150> <1.189, 2.356, -0.146> <1.219, 2.338, -0.113> <1.207, 2.325, -0.102> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.255, 2.251, -0.140> <1.226, 2.241, -0.116> <1.169, 2.222, -0.123> <1.132, 2.209, -0.115> 
		<1.239, 2.275, -0.141> <1.210, 2.265, -0.116> <1.156, 2.242, -0.123> <1.120, 2.229, -0.116> 
		<1.218, 2.308, -0.123> <1.195, 2.284, -0.104> <1.136, 2.273, -0.107> <1.102, 2.257, -0.101> 
		<1.207, 2.325, -0.102> <1.185, 2.301, -0.083> <1.127, 2.287, -0.089> <1.093, 2.271, -0.084> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.169, 2.144, -0.084> <1.178, 2.136, -0.096> <1.183, 2.116, -0.118> <1.200, 2.115, -0.125> 
		<1.160, 2.158, -0.103> <1.169, 2.149, -0.115> <1.170, 2.136, -0.147> <1.186, 2.136, -0.154> 
		<1.141, 2.186, -0.120> <1.144, 2.187, -0.138> <1.144, 2.173, -0.169> <1.158, 2.178, -0.180> 
		<1.127, 2.207, -0.121> <1.131, 2.208, -0.139> <1.124, 2.205, -0.170> <1.138, 2.210, -0.181> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.200, 2.115, -0.125> <1.231, 2.113, -0.138> <1.282, 2.119, -0.151> <1.310, 2.137, -0.143> 
		<1.186, 2.136, -0.154> <1.218, 2.134, -0.167> <1.266, 2.143, -0.183> <1.294, 2.160, -0.176> 
		<1.158, 2.178, -0.180> <1.184, 2.186, -0.199> <1.233, 2.198, -0.215> <1.263, 2.208, -0.205> 
		<1.138, 2.210, -0.181> <1.163, 2.218, -0.200> <1.210, 2.234, -0.217> <1.240, 2.244, -0.206> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.310, 2.137, -0.143> <1.325, 2.146, -0.139> <1.319, 2.177, -0.105> <1.302, 2.178, -0.098> 
		<1.294, 2.160, -0.176> <1.310, 2.170, -0.171> <1.309, 2.192, -0.127> <1.292, 2.194, -0.120> 
		<1.263, 2.208, -0.205> <1.281, 2.215, -0.199> <1.286, 2.231, -0.152> <1.270, 2.226, -0.140> 
		<1.240, 2.244, -0.206> <1.258, 2.250, -0.200> <1.270, 2.256, -0.153> <1.255, 2.251, -0.140> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.302, 2.178, -0.098> <1.266, 2.182, -0.081> <1.211, 2.158, -0.085> <1.172, 2.149, -0.080> 
		<1.292, 2.194, -0.120> <1.255, 2.197, -0.103> <1.202, 2.171, -0.103> <1.163, 2.162, -0.098> 
		<1.270, 2.226, -0.140> <1.241, 2.217, -0.115> <1.182, 2.202, -0.122> <1.146, 2.189, -0.114> 
		<1.255, 2.251, -0.140> <1.226, 2.241, -0.116> <1.169, 2.222, -0.123> <1.132, 2.209, -0.115> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.186, 2.120, 0.002> <1.198, 2.107, 0.002> <1.208, 2.081, 0.003> <1.225, 2.078, 0.003> 
		<1.186, 2.119, -0.025> <1.198, 2.107, -0.025> <1.208, 2.080, -0.038> <1.225, 2.077, -0.038> 
		<1.179, 2.130, -0.063> <1.188, 2.121, -0.076> <1.198, 2.094, -0.087> <1.215, 2.093, -0.094> 
		<1.169, 2.144, -0.084> <1.178, 2.136, -0.096> <1.183, 2.116, -0.118> <1.200, 2.115, -0.125> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.225, 2.078, 0.003> <1.259, 2.073, 0.003> <1.311, 2.075, 0.003> <1.339, 2.095, 0.003> 
		<1.225, 2.077, -0.038> <1.259, 2.072, -0.037> <1.311, 2.074, -0.043> <1.339, 2.094, -0.044> 
		<1.215, 2.093, -0.094> <1.246, 2.091, -0.107> <1.298, 2.094, -0.116> <1.327, 2.112, -0.108> 
		<1.200, 2.115, -0.125> <1.231, 2.113, -0.138> <1.282, 2.119, -0.151> <1.310, 2.137, -0.143> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.339, 2.095, 0.003> <1.352, 2.105, 0.002> <1.339, 2.146, 0.001> <1.322, 2.150, 0.001> 
		<1.339, 2.094, -0.044> <1.353, 2.104, -0.044> <1.339, 2.146, -0.030> <1.322, 2.149, -0.030> 
		<1.327, 2.112, -0.108> <1.342, 2.121, -0.104> <1.330, 2.160, -0.082> <1.314, 2.161, -0.074> 
		<1.310, 2.137, -0.143> <1.325, 2.146, -0.139> <1.319, 2.177, -0.105> <1.302, 2.178, -0.098> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.322, 2.150, 0.001> <1.282, 2.158, 0.001> <1.228, 2.133, 0.001> <1.188, 2.126, 0.002> 
		<1.322, 2.149, -0.030> <1.282, 2.157, -0.031> <1.228, 2.133, -0.024> <1.188, 2.125, -0.024> 
		<1.314, 2.161, -0.074> <1.277, 2.165, -0.057> <1.220, 2.144, -0.065> <1.181, 2.135, -0.060> 
		<1.302, 2.178, -0.098> <1.266, 2.182, -0.081> <1.211, 2.158, -0.085> <1.172, 2.149, -0.080> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.168, 2.148, 0.086> <1.177, 2.140, 0.099> <1.182, 2.121, 0.122> <1.199, 2.120, 0.129> 
		<1.178, 2.132, 0.066> <1.187, 2.124, 0.079> <1.197, 2.098, 0.093> <1.214, 2.097, 0.100> 
		<1.186, 2.120, 0.029> <1.197, 2.108, 0.029> <1.208, 2.082, 0.044> <1.225, 2.079, 0.044> 
		<1.186, 2.120, 0.002> <1.198, 2.107, 0.002> <1.208, 2.081, 0.003> <1.225, 2.078, 0.003> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.199, 2.120, 0.129> <1.230, 2.119, 0.142> <1.281, 2.126, 0.154> <1.309, 2.143, 0.145> 
		<1.214, 2.097, 0.100> <1.245, 2.096, 0.113> <1.298, 2.099, 0.120> <1.326, 2.116, 0.112> 
		<1.225, 2.079, 0.044> <1.259, 2.074, 0.044> <1.311, 2.076, 0.049> <1.339, 2.096, 0.049> 
		<1.225, 2.078, 0.003> <1.259, 2.073, 0.003> <1.311, 2.075, 0.003> <1.339, 2.095, 0.003> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.309, 2.143, 0.145> <1.325, 2.152, 0.140> <1.319, 2.181, 0.105> <1.302, 2.182, 0.097> 
		<1.326, 2.116, 0.112> <1.341, 2.126, 0.107> <1.330, 2.163, 0.083> <1.313, 2.164, 0.075> 
		<1.339, 2.096, 0.049> <1.352, 2.106, 0.048> <1.338, 2.147, 0.032> <1.322, 2.151, 0.032> 
		<1.339, 2.095, 0.003> <1.352, 2.105, 0.002> <1.339, 2.146, 0.001> <1.322, 2.150, 0.001> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.302, 2.182, 0.097> <1.265, 2.185, 0.080> <1.210, 2.162, 0.086> <1.171, 2.153, 0.081> 
		<1.313, 2.164, 0.075> <1.277, 2.167, 0.058> <1.220, 2.147, 0.067> <1.181, 2.138, 0.063> 
		<1.322, 2.151, 0.032> <1.282, 2.159, 0.032> <1.228, 2.134, 0.027> <1.188, 2.127, 0.027> 
		<1.322, 2.150, 0.001> <1.282, 2.158, 0.001> <1.228, 2.133, 0.001> <1.188, 2.126, 0.002> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.115, 2.456, -0.644> <1.105, 2.528, -0.651> <1.101, 2.584, -0.717> <1.106, 2.578, -0.790> 
		<0.827, 2.415, -0.660> <0.817, 2.487, -0.667> <0.813, 2.542, -0.733> <0.818, 2.536, -0.805> 
		<0.443, 2.360, -0.681> <0.433, 2.432, -0.687> <0.429, 2.487, -0.754> <0.434, 2.481, -0.826> 
		<0.155, 2.319, -0.697> <0.145, 2.391, -0.703> <0.141, 2.446, -0.769> <0.146, 2.440, -0.842> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.106, 2.578, -0.790> <1.111, 2.572, -0.863> <1.123, 2.507, -0.918> <1.133, 2.434, -0.911> 
		<0.818, 2.536, -0.805> <0.823, 2.530, -0.878> <0.835, 2.465, -0.933> <0.845, 2.393, -0.927> 
		<0.434, 2.481, -0.826> <0.439, 2.475, -0.899> <0.451, 2.410, -0.954> <0.461, 2.338, -0.948> 
		<0.146, 2.440, -0.842> <0.151, 2.434, -0.915> <0.163, 2.369, -0.970> <0.173, 2.297, -0.963> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.133, 2.434, -0.911> <1.143, 2.362, -0.905> <1.147, 2.307, -0.839> <1.143, 2.313, -0.766> 
		<0.845, 2.393, -0.927> <0.855, 2.321, -0.920> <0.859, 2.266, -0.854> <0.854, 2.272, -0.781> 
		<0.461, 2.338, -0.948> <0.471, 2.266, -0.941> <0.475, 2.211, -0.875> <0.470, 2.217, -0.802> 
		<0.173, 2.297, -0.963> <0.183, 2.225, -0.957> <0.187, 2.170, -0.891> <0.182, 2.175, -0.818> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.182, 2.175, -0.818> <0.178, 2.181, -0.745> <0.165, 2.247, -0.690> <0.155, 2.319, -0.697> 
		<0.470, 2.217, -0.802> <0.466, 2.223, -0.729> <0.453, 2.288, -0.674> <0.443, 2.360, -0.681> 
		<0.854, 2.272, -0.781> <0.850, 2.278, -0.709> <0.837, 2.343, -0.653> <0.827, 2.415, -0.660> 
		<1.143, 2.313, -0.766> <1.138, 2.319, -0.693> <1.125, 2.384, -0.638> <1.115, 2.456, -0.644> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.512, 2.372, -0.780> <0.510, 2.389, -0.781> <0.509, 2.402, -0.797> <0.510, 2.401, -0.815> 
		<0.224, 2.330, -0.796> <0.222, 2.348, -0.797> <0.221, 2.361, -0.813> <0.222, 2.360, -0.830> 
		<-0.160, 2.275, -0.816> <-0.162, 2.293, -0.818> <-0.163, 2.306, -0.834> <-0.162, 2.305, -0.851> 
		<-0.448, 2.234, -0.832> <-0.450, 2.252, -0.834> <-0.451, 2.265, -0.850> <-0.450, 2.263, -0.867> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.510, 2.401, -0.815> <0.511, 2.399, -0.832> <0.514, 2.384, -0.845> <0.516, 2.366, -0.844> 
		<0.222, 2.360, -0.830> <0.223, 2.358, -0.848> <0.226, 2.343, -0.861> <0.228, 2.325, -0.860> 
		<-0.162, 2.305, -0.851> <-0.161, 2.303, -0.869> <-0.158, 2.288, -0.882> <-0.156, 2.270, -0.880> 
		<-0.450, 2.263, -0.867> <-0.449, 2.262, -0.885> <-0.446, 2.246, -0.898> <-0.444, 2.229, -0.896> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.516, 2.366, -0.844> <0.519, 2.349, -0.842> <0.520, 2.336, -0.826> <0.519, 2.337, -0.809> 
		<0.228, 2.325, -0.860> <0.231, 2.308, -0.858> <0.232, 2.295, -0.842> <0.231, 2.296, -0.825> 
		<-0.156, 2.270, -0.880> <-0.153, 2.253, -0.879> <-0.152, 2.240, -0.863> <-0.153, 2.241, -0.846> 
		<-0.444, 2.229, -0.896> <-0.441, 2.212, -0.895> <-0.440, 2.198, -0.879> <-0.442, 2.200, -0.861> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.442, 2.200, -0.861> <-0.443, 2.201, -0.844> <-0.446, 2.217, -0.831> <-0.448, 2.234, -0.832> 
		<-0.153, 2.241, -0.846> <-0.155, 2.243, -0.828> <-0.158, 2.258, -0.815> <-0.160, 2.275, -0.816> 
		<0.231, 2.296, -0.825> <0.229, 2.297, -0.807> <0.227, 2.313, -0.794> <0.224, 2.330, -0.796> 
		<0.519, 2.337, -0.809> <0.518, 2.339, -0.791> <0.515, 2.354, -0.778> <0.512, 2.372, -0.780> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.092, 2.257, -0.831> <0.095, 2.249, -0.830> <0.094, 2.232, -0.828> <0.103, 2.228, -0.828> 
		<0.093, 2.256, -0.845> <0.096, 2.247, -0.844> <0.095, 2.230, -0.850> <0.104, 2.226, -0.849> 
		<0.093, 2.263, -0.865> <0.097, 2.256, -0.871> <0.096, 2.238, -0.876> <0.104, 2.236, -0.879> 
		<0.093, 2.272, -0.876> <0.096, 2.265, -0.882> <0.095, 2.252, -0.892> <0.103, 2.249, -0.895> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.103, 2.228, -0.828> <0.120, 2.220, -0.826> <0.148, 2.216, -0.824> <0.165, 2.224, -0.823> 
		<0.104, 2.226, -0.849> <0.121, 2.218, -0.847> <0.150, 2.214, -0.848> <0.167, 2.222, -0.847> 
		<0.104, 2.236, -0.879> <0.122, 2.230, -0.885> <0.150, 2.226, -0.886> <0.167, 2.233, -0.881> 
		<0.103, 2.249, -0.895> <0.120, 2.244, -0.901> <0.149, 2.242, -0.904> <0.166, 2.249, -0.900> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.165, 2.224, -0.823> <0.175, 2.229, -0.823> <0.179, 2.254, -0.825> <0.170, 2.259, -0.826> 
		<0.167, 2.222, -0.847> <0.177, 2.227, -0.847> <0.180, 2.253, -0.841> <0.171, 2.258, -0.842> 
		<0.167, 2.233, -0.881> <0.177, 2.237, -0.879> <0.181, 2.262, -0.869> <0.171, 2.265, -0.865> 
		<0.166, 2.249, -0.900> <0.176, 2.252, -0.897> <0.180, 2.272, -0.881> <0.170, 2.276, -0.878> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.170, 2.259, -0.826> <0.150, 2.270, -0.828> <0.117, 2.260, -0.829> <0.095, 2.261, -0.831> 
		<0.171, 2.258, -0.842> <0.151, 2.268, -0.844> <0.118, 2.259, -0.843> <0.096, 2.260, -0.844> 
		<0.171, 2.265, -0.865> <0.151, 2.273, -0.858> <0.119, 2.266, -0.864> <0.096, 2.266, -0.863> 
		<0.170, 2.276, -0.878> <0.150, 2.283, -0.870> <0.118, 2.275, -0.875> <0.095, 2.275, -0.874> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.087, 2.279, -0.789> <0.089, 2.273, -0.782> <0.086, 2.262, -0.769> <0.095, 2.260, -0.765> 
		<0.089, 2.268, -0.798> <0.091, 2.262, -0.791> <0.089, 2.246, -0.783> <0.098, 2.244, -0.778> 
		<0.091, 2.259, -0.817> <0.094, 2.250, -0.816> <0.093, 2.233, -0.807> <0.101, 2.229, -0.806> 
		<0.092, 2.257, -0.831> <0.095, 2.249, -0.830> <0.094, 2.232, -0.828> <0.103, 2.228, -0.828> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.095, 2.260, -0.765> <0.111, 2.256, -0.756> <0.139, 2.255, -0.749> <0.156, 2.261, -0.752> 
		<0.098, 2.244, -0.778> <0.114, 2.240, -0.770> <0.142, 2.236, -0.764> <0.160, 2.243, -0.767> 
		<0.101, 2.229, -0.806> <0.118, 2.222, -0.805> <0.147, 2.218, -0.800> <0.164, 2.226, -0.799> 
		<0.103, 2.228, -0.828> <0.120, 2.220, -0.826> <0.148, 2.216, -0.824> <0.165, 2.224, -0.823> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.156, 2.261, -0.752> <0.166, 2.264, -0.754> <0.173, 2.281, -0.772> <0.164, 2.284, -0.777> 
		<0.160, 2.243, -0.767> <0.170, 2.246, -0.769> <0.175, 2.269, -0.783> <0.166, 2.272, -0.788> 
		<0.164, 2.226, -0.799> <0.173, 2.231, -0.799> <0.178, 2.256, -0.808> <0.169, 2.261, -0.809> 
		<0.165, 2.224, -0.823> <0.175, 2.229, -0.823> <0.179, 2.254, -0.825> <0.170, 2.259, -0.826> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.164, 2.284, -0.777> <0.145, 2.290, -0.789> <0.112, 2.282, -0.787> <0.090, 2.281, -0.791> 
		<0.166, 2.272, -0.788> <0.147, 2.277, -0.799> <0.114, 2.272, -0.796> <0.092, 2.271, -0.800> 
		<0.169, 2.261, -0.809> <0.149, 2.271, -0.812> <0.117, 2.261, -0.816> <0.094, 2.262, -0.817> 
		<0.170, 2.259, -0.826> <0.150, 2.270, -0.828> <0.117, 2.260, -0.829> <0.095, 2.261, -0.831> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.080, 2.324, -0.775> <0.081, 2.325, -0.765> <0.076, 2.325, -0.749> <0.084, 2.327, -0.744> 
		<0.082, 2.310, -0.773> <0.083, 2.311, -0.764> <0.079, 2.304, -0.747> <0.087, 2.306, -0.742> 
		<0.085, 2.290, -0.780> <0.087, 2.284, -0.772> <0.083, 2.278, -0.755> <0.092, 2.276, -0.751> 
		<0.087, 2.279, -0.789> <0.089, 2.273, -0.782> <0.086, 2.262, -0.769> <0.095, 2.260, -0.765> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.084, 2.327, -0.744> <0.099, 2.330, -0.733> <0.126, 2.335, -0.723> <0.144, 2.337, -0.728> 
		<0.087, 2.306, -0.742> <0.102, 2.309, -0.731> <0.129, 2.311, -0.721> <0.148, 2.313, -0.726> 
		<0.092, 2.276, -0.751> <0.108, 2.272, -0.742> <0.135, 2.273, -0.733> <0.153, 2.279, -0.736> 
		<0.095, 2.260, -0.765> <0.111, 2.256, -0.756> <0.139, 2.255, -0.749> <0.156, 2.261, -0.752> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.144, 2.337, -0.728> <0.154, 2.338, -0.730> <0.164, 2.337, -0.755> <0.156, 2.335, -0.761> 
		<0.148, 2.313, -0.726> <0.158, 2.314, -0.728> <0.166, 2.321, -0.753> <0.158, 2.319, -0.760> 
		<0.153, 2.279, -0.736> <0.163, 2.282, -0.738> <0.170, 2.293, -0.762> <0.162, 2.296, -0.767> 
		<0.156, 2.261, -0.752> <0.166, 2.264, -0.754> <0.173, 2.281, -0.772> <0.164, 2.284, -0.777> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.156, 2.335, -0.761> <0.138, 2.332, -0.775> <0.105, 2.327, -0.773> <0.083, 2.324, -0.778> 
		<0.158, 2.319, -0.760> <0.141, 2.315, -0.774> <0.107, 2.314, -0.771> <0.085, 2.310, -0.776> 
		<0.162, 2.296, -0.767> <0.143, 2.302, -0.778> <0.110, 2.292, -0.778> <0.088, 2.291, -0.782> 
		<0.164, 2.284, -0.777> <0.145, 2.290, -0.789> <0.112, 2.282, -0.787> <0.090, 2.281, -0.791> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.075, 2.365, -0.797> <0.075, 2.373, -0.791> <0.070, 2.385, -0.780> <0.077, 2.389, -0.776> 
		<0.076, 2.356, -0.786> <0.076, 2.363, -0.780> <0.071, 2.371, -0.764> <0.078, 2.376, -0.760> 
		<0.078, 2.338, -0.776> <0.079, 2.339, -0.767> <0.073, 2.346, -0.751> <0.081, 2.348, -0.745> 
		<0.080, 2.324, -0.775> <0.081, 2.325, -0.765> <0.076, 2.325, -0.749> <0.084, 2.327, -0.744> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.077, 2.389, -0.776> <0.091, 2.399, -0.769> <0.117, 2.409, -0.763> <0.136, 2.408, -0.765> 
		<0.078, 2.376, -0.760> <0.092, 2.386, -0.753> <0.119, 2.394, -0.744> <0.137, 2.392, -0.747> 
		<0.081, 2.348, -0.745> <0.096, 2.351, -0.734> <0.123, 2.358, -0.726> <0.141, 2.361, -0.730> 
		<0.084, 2.327, -0.744> <0.099, 2.330, -0.733> <0.126, 2.335, -0.723> <0.144, 2.337, -0.728> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.136, 2.408, -0.765> <0.147, 2.407, -0.767> <0.158, 2.389, -0.782> <0.150, 2.383, -0.786> 
		<0.137, 2.392, -0.747> <0.148, 2.391, -0.748> <0.159, 2.379, -0.770> <0.151, 2.373, -0.774> 
		<0.141, 2.361, -0.730> <0.151, 2.362, -0.733> <0.162, 2.353, -0.756> <0.153, 2.351, -0.763> 
		<0.144, 2.337, -0.728> <0.154, 2.338, -0.730> <0.164, 2.337, -0.755> <0.156, 2.335, -0.761> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.150, 2.383, -0.786> <0.134, 2.371, -0.796> <0.100, 2.369, -0.795> <0.078, 2.363, -0.798> 
		<0.151, 2.373, -0.774> <0.135, 2.360, -0.783> <0.101, 2.361, -0.784> <0.079, 2.355, -0.788> 
		<0.153, 2.351, -0.763> <0.136, 2.348, -0.777> <0.103, 2.340, -0.774> <0.081, 2.337, -0.779> 
		<0.156, 2.335, -0.761> <0.138, 2.332, -0.775> <0.105, 2.327, -0.773> <0.083, 2.324, -0.778> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.075, 2.380, -0.842> <0.076, 2.389, -0.842> <0.070, 2.405, -0.844> <0.077, 2.411, -0.844> 
		<0.074, 2.381, -0.828> <0.075, 2.390, -0.828> <0.069, 2.407, -0.823> <0.076, 2.413, -0.823> 
		<0.074, 2.374, -0.807> <0.075, 2.382, -0.801> <0.068, 2.398, -0.796> <0.076, 2.403, -0.793> 
		<0.075, 2.365, -0.797> <0.075, 2.373, -0.791> <0.070, 2.385, -0.780> <0.077, 2.389, -0.776> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.077, 2.411, -0.844> <0.092, 2.423, -0.844> <0.118, 2.435, -0.843> <0.137, 2.432, -0.842> 
		<0.076, 2.413, -0.823> <0.090, 2.425, -0.823> <0.117, 2.437, -0.819> <0.135, 2.434, -0.818> 
		<0.076, 2.403, -0.793> <0.090, 2.413, -0.785> <0.116, 2.425, -0.781> <0.135, 2.423, -0.784> 
		<0.077, 2.389, -0.776> <0.091, 2.399, -0.769> <0.117, 2.409, -0.763> <0.136, 2.408, -0.765> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.137, 2.432, -0.842> <0.147, 2.430, -0.841> <0.158, 2.407, -0.838> <0.151, 2.400, -0.838> 
		<0.135, 2.434, -0.818> <0.146, 2.432, -0.817> <0.157, 2.408, -0.822> <0.150, 2.401, -0.822> 
		<0.135, 2.423, -0.784> <0.145, 2.422, -0.785> <0.157, 2.400, -0.795> <0.149, 2.394, -0.799> 
		<0.136, 2.408, -0.765> <0.147, 2.407, -0.767> <0.158, 2.389, -0.782> <0.150, 2.383, -0.786> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.151, 2.400, -0.838> <0.134, 2.384, -0.838> <0.100, 2.384, -0.840> <0.079, 2.377, -0.841> 
		<0.150, 2.401, -0.822> <0.133, 2.385, -0.822> <0.100, 2.385, -0.827> <0.078, 2.378, -0.828> 
		<0.149, 2.394, -0.799> <0.133, 2.381, -0.808> <0.099, 2.378, -0.805> <0.078, 2.372, -0.809> 
		<0.150, 2.383, -0.786> <0.134, 2.371, -0.796> <0.100, 2.369, -0.795> <0.078, 2.363, -0.798> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.081, 2.358, -0.884> <0.082, 2.364, -0.891> <0.078, 2.374, -0.904> <0.085, 2.379, -0.907> 
		<0.079, 2.369, -0.875> <0.080, 2.375, -0.882> <0.075, 2.391, -0.890> <0.082, 2.395, -0.893> 
		<0.076, 2.378, -0.856> <0.077, 2.388, -0.857> <0.071, 2.403, -0.865> <0.079, 2.409, -0.865> 
		<0.075, 2.380, -0.842> <0.076, 2.389, -0.842> <0.070, 2.405, -0.844> <0.077, 2.411, -0.844> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.085, 2.379, -0.907> <0.101, 2.388, -0.914> <0.128, 2.396, -0.918> <0.146, 2.396, -0.913> 
		<0.082, 2.395, -0.893> <0.098, 2.404, -0.900> <0.124, 2.415, -0.903> <0.142, 2.414, -0.898> 
		<0.079, 2.409, -0.865> <0.093, 2.422, -0.865> <0.120, 2.433, -0.867> <0.138, 2.430, -0.866> 
		<0.077, 2.411, -0.844> <0.092, 2.423, -0.844> <0.118, 2.435, -0.843> <0.137, 2.432, -0.842> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.146, 2.396, -0.913> <0.156, 2.395, -0.910> <0.165, 2.380, -0.891> <0.157, 2.375, -0.887> 
		<0.142, 2.414, -0.898> <0.153, 2.413, -0.895> <0.163, 2.393, -0.880> <0.154, 2.387, -0.876> 
		<0.138, 2.430, -0.866> <0.149, 2.428, -0.865> <0.159, 2.406, -0.855> <0.152, 2.398, -0.855> 
		<0.137, 2.432, -0.842> <0.147, 2.430, -0.841> <0.158, 2.407, -0.838> <0.151, 2.400, -0.838> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.157, 2.375, -0.887> <0.139, 2.364, -0.878> <0.106, 2.362, -0.883> <0.084, 2.357, -0.881> 
		<0.154, 2.387, -0.876> <0.137, 2.376, -0.867> <0.104, 2.372, -0.874> <0.082, 2.367, -0.872> 
		<0.152, 2.398, -0.855> <0.135, 2.383, -0.854> <0.101, 2.383, -0.854> <0.080, 2.376, -0.855> 
		<0.151, 2.400, -0.838> <0.134, 2.384, -0.838> <0.100, 2.384, -0.840> <0.079, 2.377, -0.841> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.088, 2.313, -0.898> <0.090, 2.313, -0.907> <0.088, 2.311, -0.924> <0.096, 2.312, -0.928> 
		<0.086, 2.327, -0.899> <0.088, 2.327, -0.908> <0.085, 2.332, -0.925> <0.093, 2.333, -0.930> 
		<0.083, 2.347, -0.893> <0.084, 2.354, -0.900> <0.081, 2.358, -0.917> <0.088, 2.363, -0.921> 
		<0.081, 2.358, -0.884> <0.082, 2.364, -0.891> <0.078, 2.374, -0.904> <0.085, 2.379, -0.907> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.096, 2.312, -0.928> <0.113, 2.313, -0.937> <0.141, 2.317, -0.944> <0.158, 2.320, -0.937> 
		<0.093, 2.333, -0.930> <0.110, 2.334, -0.939> <0.137, 2.340, -0.946> <0.155, 2.343, -0.939> 
		<0.088, 2.363, -0.921> <0.104, 2.371, -0.928> <0.131, 2.378, -0.934> <0.149, 2.377, -0.929> 
		<0.085, 2.379, -0.907> <0.101, 2.388, -0.914> <0.128, 2.396, -0.918> <0.146, 2.396, -0.913> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.158, 2.320, -0.937> <0.168, 2.321, -0.934> <0.174, 2.324, -0.908> <0.165, 2.324, -0.903> 
		<0.155, 2.343, -0.939> <0.165, 2.345, -0.936> <0.172, 2.341, -0.910> <0.163, 2.340, -0.904> 
		<0.149, 2.377, -0.929> <0.160, 2.377, -0.926> <0.167, 2.368, -0.901> <0.159, 2.363, -0.897> 
		<0.146, 2.396, -0.913> <0.156, 2.395, -0.910> <0.165, 2.380, -0.891> <0.157, 2.375, -0.887> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.165, 2.324, -0.903> <0.146, 2.322, -0.891> <0.113, 2.317, -0.897> <0.091, 2.314, -0.895> 
		<0.163, 2.340, -0.904> <0.144, 2.338, -0.892> <0.111, 2.330, -0.898> <0.089, 2.327, -0.896> 
		<0.159, 2.363, -0.897> <0.142, 2.352, -0.888> <0.108, 2.352, -0.891> <0.086, 2.346, -0.890> 
		<0.157, 2.375, -0.887> <0.139, 2.364, -0.878> <0.106, 2.362, -0.883> <0.084, 2.357, -0.881> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.093, 2.272, -0.876> <0.096, 2.265, -0.882> <0.095, 2.252, -0.892> <0.103, 2.249, -0.895> 
		<0.092, 2.281, -0.887> <0.095, 2.274, -0.893> <0.094, 2.266, -0.909> <0.102, 2.263, -0.912> 
		<0.090, 2.299, -0.896> <0.092, 2.299, -0.906> <0.091, 2.290, -0.922> <0.099, 2.291, -0.926> 
		<0.088, 2.313, -0.898> <0.090, 2.313, -0.907> <0.088, 2.311, -0.924> <0.096, 2.312, -0.928> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.103, 2.249, -0.895> <0.120, 2.244, -0.901> <0.149, 2.242, -0.904> <0.166, 2.249, -0.900> 
		<0.102, 2.263, -0.912> <0.119, 2.257, -0.917> <0.148, 2.257, -0.923> <0.165, 2.264, -0.918> 
		<0.099, 2.291, -0.926> <0.115, 2.292, -0.936> <0.144, 2.293, -0.941> <0.161, 2.296, -0.935> 
		<0.096, 2.312, -0.928> <0.113, 2.313, -0.937> <0.141, 2.317, -0.944> <0.158, 2.320, -0.937> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.166, 2.249, -0.900> <0.176, 2.252, -0.897> <0.180, 2.272, -0.881> <0.170, 2.276, -0.878> 
		<0.165, 2.264, -0.918> <0.175, 2.268, -0.916> <0.179, 2.283, -0.894> <0.170, 2.286, -0.890> 
		<0.161, 2.296, -0.935> <0.171, 2.297, -0.931> <0.176, 2.308, -0.907> <0.167, 2.308, -0.901> 
		<0.158, 2.320, -0.937> <0.168, 2.321, -0.934> <0.174, 2.324, -0.908> <0.165, 2.324, -0.903> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.170, 2.276, -0.878> <0.150, 2.283, -0.870> <0.118, 2.275, -0.875> <0.095, 2.275, -0.874> 
		<0.170, 2.286, -0.890> <0.150, 2.293, -0.883> <0.117, 2.284, -0.885> <0.095, 2.283, -0.884> 
		<0.167, 2.308, -0.901> <0.148, 2.306, -0.889> <0.115, 2.304, -0.896> <0.093, 2.301, -0.893> 
		<0.165, 2.324, -0.903> <0.146, 2.322, -0.891> <0.113, 2.317, -0.897> <0.091, 2.314, -0.895> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.495, 2.159, -0.900> <-0.494, 2.150, -0.898> <-0.491, 2.133, -0.900> <-0.491, 2.129, -0.891> 
		<-0.481, 2.161, -0.899> <-0.480, 2.152, -0.897> <-0.470, 2.136, -0.898> <-0.470, 2.132, -0.890> 
		<-0.463, 2.172, -0.899> <-0.456, 2.166, -0.896> <-0.446, 2.150, -0.897> <-0.443, 2.148, -0.889> 
		<-0.454, 2.183, -0.899> <-0.447, 2.178, -0.896> <-0.434, 2.167, -0.898> <-0.430, 2.165, -0.889> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.491, 2.129, -0.891> <-0.491, 2.120, -0.875> <-0.492, 2.115, -0.846> <-0.495, 2.121, -0.829> 
		<-0.470, 2.132, -0.890> <-0.470, 2.123, -0.873> <-0.469, 2.118, -0.845> <-0.471, 2.125, -0.827> 
		<-0.443, 2.148, -0.889> <-0.436, 2.143, -0.872> <-0.434, 2.139, -0.843> <-0.440, 2.143, -0.826> 
		<-0.430, 2.165, -0.889> <-0.423, 2.160, -0.872> <-0.420, 2.158, -0.844> <-0.425, 2.163, -0.826> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.495, 2.121, -0.829> <-0.496, 2.125, -0.819> <-0.500, 2.150, -0.814> <-0.500, 2.156, -0.823> 
		<-0.471, 2.125, -0.827> <-0.472, 2.129, -0.817> <-0.484, 2.153, -0.812> <-0.484, 2.158, -0.821> 
		<-0.440, 2.143, -0.826> <-0.443, 2.146, -0.816> <-0.459, 2.168, -0.811> <-0.463, 2.171, -0.821> 
		<-0.425, 2.163, -0.826> <-0.429, 2.165, -0.817> <-0.449, 2.181, -0.812> <-0.453, 2.184, -0.821> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.500, 2.156, -0.823> <-0.500, 2.167, -0.842> <-0.497, 2.160, -0.875> <-0.496, 2.162, -0.898> 
		<-0.484, 2.158, -0.821> <-0.484, 2.170, -0.841> <-0.484, 2.162, -0.874> <-0.482, 2.164, -0.897> 
		<-0.463, 2.171, -0.821> <-0.472, 2.177, -0.840> <-0.464, 2.174, -0.873> <-0.465, 2.174, -0.896> 
		<-0.453, 2.184, -0.821> <-0.462, 2.190, -0.841> <-0.456, 2.185, -0.874> <-0.457, 2.185, -0.896> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.541, 2.171, -0.905> <-0.546, 2.163, -0.903> <-0.556, 2.150, -0.907> <-0.560, 2.146, -0.899> 
		<-0.529, 2.162, -0.903> <-0.535, 2.155, -0.901> <-0.539, 2.137, -0.904> <-0.543, 2.134, -0.896> 
		<-0.509, 2.157, -0.901> <-0.508, 2.148, -0.899> <-0.512, 2.130, -0.901> <-0.512, 2.126, -0.893> 
		<-0.495, 2.159, -0.900> <-0.494, 2.150, -0.898> <-0.491, 2.133, -0.900> <-0.491, 2.129, -0.891> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.560, 2.146, -0.899> <-0.567, 2.139, -0.883> <-0.574, 2.135, -0.855> <-0.572, 2.141, -0.837> 
		<-0.543, 2.134, -0.896> <-0.550, 2.127, -0.880> <-0.555, 2.121, -0.852> <-0.553, 2.127, -0.834> 
		<-0.512, 2.126, -0.893> <-0.512, 2.117, -0.876> <-0.516, 2.111, -0.848> <-0.519, 2.118, -0.831> 
		<-0.491, 2.129, -0.891> <-0.491, 2.120, -0.875> <-0.492, 2.115, -0.846> <-0.495, 2.121, -0.829> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.572, 2.141, -0.837> <-0.571, 2.145, -0.827> <-0.557, 2.165, -0.819> <-0.553, 2.169, -0.828> 
		<-0.553, 2.127, -0.834> <-0.552, 2.130, -0.824> <-0.544, 2.155, -0.818> <-0.540, 2.159, -0.826> 
		<-0.519, 2.118, -0.831> <-0.520, 2.122, -0.821> <-0.516, 2.148, -0.815> <-0.516, 2.153, -0.824> 
		<-0.495, 2.121, -0.829> <-0.496, 2.125, -0.819> <-0.500, 2.150, -0.814> <-0.500, 2.156, -0.823> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.553, 2.169, -0.828> <-0.543, 2.178, -0.847> <-0.543, 2.172, -0.880> <-0.539, 2.173, -0.902> 
		<-0.540, 2.159, -0.826> <-0.530, 2.168, -0.845> <-0.532, 2.164, -0.878> <-0.528, 2.165, -0.901> 
		<-0.516, 2.153, -0.824> <-0.517, 2.165, -0.843> <-0.510, 2.158, -0.876> <-0.509, 2.160, -0.899> 
		<-0.500, 2.156, -0.823> <-0.500, 2.167, -0.842> <-0.497, 2.160, -0.875> <-0.496, 2.162, -0.898> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.565, 2.211, -0.910> <-0.574, 2.210, -0.909> <-0.590, 2.207, -0.914> <-0.596, 2.207, -0.906> 
		<-0.563, 2.197, -0.909> <-0.572, 2.196, -0.908> <-0.587, 2.186, -0.912> <-0.593, 2.186, -0.904> 
		<-0.552, 2.179, -0.907> <-0.558, 2.172, -0.905> <-0.573, 2.162, -0.909> <-0.577, 2.159, -0.901> 
		<-0.541, 2.171, -0.905> <-0.546, 2.163, -0.903> <-0.556, 2.150, -0.907> <-0.560, 2.146, -0.899> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.596, 2.207, -0.906> <-0.607, 2.207, -0.891> <-0.617, 2.208, -0.864> <-0.613, 2.210, -0.846> 
		<-0.593, 2.186, -0.904> <-0.604, 2.186, -0.889> <-0.614, 2.184, -0.862> <-0.610, 2.186, -0.844> 
		<-0.577, 2.159, -0.901> <-0.584, 2.152, -0.885> <-0.593, 2.150, -0.858> <-0.592, 2.156, -0.840> 
		<-0.560, 2.146, -0.899> <-0.567, 2.139, -0.883> <-0.574, 2.135, -0.855> <-0.572, 2.141, -0.837> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.613, 2.210, -0.846> <-0.611, 2.212, -0.835> <-0.587, 2.216, -0.826> <-0.580, 2.216, -0.834> 
		<-0.610, 2.186, -0.844> <-0.607, 2.188, -0.833> <-0.585, 2.200, -0.824> <-0.578, 2.200, -0.833> 
		<-0.592, 2.156, -0.840> <-0.591, 2.159, -0.830> <-0.570, 2.175, -0.821> <-0.566, 2.179, -0.830> 
		<-0.572, 2.141, -0.837> <-0.571, 2.145, -0.827> <-0.557, 2.165, -0.819> <-0.553, 2.169, -0.828> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.580, 2.216, -0.834> <-0.566, 2.216, -0.851> <-0.567, 2.213, -0.885> <-0.562, 2.212, -0.907> 
		<-0.578, 2.200, -0.833> <-0.563, 2.200, -0.850> <-0.565, 2.200, -0.884> <-0.560, 2.198, -0.906> 
		<-0.566, 2.179, -0.830> <-0.556, 2.188, -0.848> <-0.554, 2.180, -0.881> <-0.550, 2.181, -0.904> 
		<-0.553, 2.169, -0.828> <-0.543, 2.178, -0.847> <-0.543, 2.172, -0.880> <-0.539, 2.173, -0.902> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.553, 2.257, -0.913> <-0.560, 2.263, -0.912> <-0.573, 2.272, -0.918> <-0.578, 2.276, -0.910> 
		<-0.561, 2.246, -0.913> <-0.569, 2.251, -0.912> <-0.586, 2.255, -0.917> <-0.591, 2.259, -0.910> 
		<-0.566, 2.225, -0.912> <-0.576, 2.224, -0.910> <-0.593, 2.228, -0.916> <-0.599, 2.228, -0.908> 
		<-0.565, 2.211, -0.910> <-0.574, 2.210, -0.909> <-0.590, 2.207, -0.914> <-0.596, 2.207, -0.906> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.578, 2.276, -0.910> <-0.587, 2.283, -0.896> <-0.596, 2.290, -0.869> <-0.593, 2.288, -0.850> 
		<-0.591, 2.259, -0.910> <-0.600, 2.266, -0.895> <-0.610, 2.271, -0.869> <-0.607, 2.269, -0.850> 
		<-0.599, 2.228, -0.908> <-0.610, 2.228, -0.893> <-0.620, 2.232, -0.866> <-0.616, 2.234, -0.848> 
		<-0.596, 2.207, -0.906> <-0.607, 2.207, -0.891> <-0.617, 2.208, -0.864> <-0.613, 2.210, -0.846> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.593, 2.288, -0.850> <-0.591, 2.287, -0.840> <-0.572, 2.273, -0.829> <-0.566, 2.269, -0.837> 
		<-0.607, 2.269, -0.850> <-0.606, 2.268, -0.839> <-0.582, 2.260, -0.829> <-0.576, 2.255, -0.837> 
		<-0.616, 2.234, -0.848> <-0.614, 2.235, -0.838> <-0.589, 2.232, -0.827> <-0.582, 2.232, -0.836> 
		<-0.613, 2.210, -0.846> <-0.611, 2.212, -0.835> <-0.587, 2.216, -0.826> <-0.580, 2.216, -0.834> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.566, 2.269, -0.837> <-0.554, 2.259, -0.854> <-0.555, 2.259, -0.888> <-0.550, 2.255, -0.909> 
		<-0.576, 2.255, -0.837> <-0.564, 2.246, -0.854> <-0.563, 2.248, -0.888> <-0.559, 2.245, -0.909> 
		<-0.582, 2.232, -0.836> <-0.568, 2.232, -0.853> <-0.569, 2.226, -0.886> <-0.564, 2.225, -0.908> 
		<-0.580, 2.216, -0.834> <-0.566, 2.216, -0.851> <-0.567, 2.213, -0.885> <-0.562, 2.212, -0.907> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.512, 2.281, -0.911> <-0.513, 2.290, -0.910> <-0.515, 2.306, -0.916> <-0.517, 2.312, -0.908> 
		<-0.526, 2.279, -0.912> <-0.527, 2.288, -0.911> <-0.536, 2.303, -0.917> <-0.538, 2.309, -0.910> 
		<-0.544, 2.268, -0.913> <-0.552, 2.274, -0.912> <-0.560, 2.289, -0.918> <-0.565, 2.293, -0.911> 
		<-0.553, 2.257, -0.913> <-0.560, 2.263, -0.912> <-0.573, 2.272, -0.918> <-0.578, 2.276, -0.910> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.517, 2.312, -0.908> <-0.519, 2.323, -0.893> <-0.523, 2.333, -0.866> <-0.523, 2.329, -0.848> 
		<-0.538, 2.309, -0.910> <-0.540, 2.320, -0.895> <-0.547, 2.330, -0.868> <-0.547, 2.326, -0.849> 
		<-0.565, 2.293, -0.911> <-0.574, 2.300, -0.896> <-0.581, 2.309, -0.869> <-0.578, 2.307, -0.851> 
		<-0.578, 2.276, -0.910> <-0.587, 2.283, -0.896> <-0.596, 2.290, -0.869> <-0.593, 2.288, -0.850> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.523, 2.329, -0.848> <-0.524, 2.327, -0.837> <-0.521, 2.303, -0.827> <-0.520, 2.296, -0.835> 
		<-0.547, 2.326, -0.849> <-0.548, 2.323, -0.839> <-0.537, 2.301, -0.829> <-0.536, 2.294, -0.837> 
		<-0.578, 2.307, -0.851> <-0.577, 2.306, -0.840> <-0.562, 2.286, -0.829> <-0.557, 2.282, -0.837> 
		<-0.593, 2.288, -0.850> <-0.591, 2.287, -0.840> <-0.572, 2.273, -0.829> <-0.566, 2.269, -0.837> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.520, 2.296, -0.835> <-0.516, 2.282, -0.852> <-0.514, 2.284, -0.886> <-0.512, 2.278, -0.908> 
		<-0.536, 2.294, -0.837> <-0.532, 2.280, -0.854> <-0.527, 2.282, -0.887> <-0.525, 2.276, -0.909> 
		<-0.557, 2.282, -0.837> <-0.545, 2.272, -0.854> <-0.547, 2.270, -0.888> <-0.542, 2.266, -0.910> 
		<-0.566, 2.269, -0.837> <-0.554, 2.259, -0.854> <-0.555, 2.259, -0.888> <-0.550, 2.255, -0.909> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.466, 2.269, -0.907> <-0.461, 2.277, -0.905> <-0.450, 2.290, -0.909> <-0.448, 2.295, -0.901> 
		<-0.477, 2.278, -0.908> <-0.472, 2.285, -0.907> <-0.467, 2.303, -0.911> <-0.465, 2.307, -0.903> 
		<-0.498, 2.283, -0.910> <-0.499, 2.292, -0.909> <-0.494, 2.309, -0.914> <-0.496, 2.315, -0.907> 
		<-0.512, 2.281, -0.911> <-0.513, 2.290, -0.910> <-0.515, 2.306, -0.916> <-0.517, 2.312, -0.908> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.448, 2.295, -0.901> <-0.443, 2.304, -0.885> <-0.441, 2.312, -0.858> <-0.446, 2.309, -0.840> 
		<-0.465, 2.307, -0.903> <-0.460, 2.317, -0.888> <-0.460, 2.327, -0.860> <-0.465, 2.324, -0.842> 
		<-0.496, 2.315, -0.907> <-0.498, 2.326, -0.892> <-0.499, 2.337, -0.864> <-0.500, 2.333, -0.846> 
		<-0.517, 2.312, -0.908> <-0.519, 2.323, -0.893> <-0.523, 2.333, -0.866> <-0.523, 2.329, -0.848> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.446, 2.309, -0.840> <-0.448, 2.308, -0.830> <-0.464, 2.288, -0.821> <-0.467, 2.283, -0.830> 
		<-0.465, 2.324, -0.842> <-0.468, 2.322, -0.832> <-0.477, 2.298, -0.823> <-0.480, 2.293, -0.832> 
		<-0.500, 2.333, -0.846> <-0.500, 2.330, -0.836> <-0.505, 2.305, -0.826> <-0.503, 2.299, -0.834> 
		<-0.523, 2.329, -0.848> <-0.524, 2.327, -0.837> <-0.521, 2.303, -0.827> <-0.520, 2.296, -0.835> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.467, 2.283, -0.830> <-0.473, 2.271, -0.848> <-0.468, 2.272, -0.881> <-0.468, 2.267, -0.904> 
		<-0.480, 2.293, -0.832> <-0.486, 2.281, -0.850> <-0.479, 2.280, -0.883> <-0.479, 2.275, -0.905> 
		<-0.503, 2.299, -0.834> <-0.500, 2.284, -0.851> <-0.501, 2.286, -0.885> <-0.498, 2.280, -0.907> 
		<-0.520, 2.296, -0.835> <-0.516, 2.282, -0.852> <-0.514, 2.284, -0.886> <-0.512, 2.278, -0.908> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.442, 2.229, -0.901> <-0.433, 2.230, -0.899> <-0.417, 2.232, -0.901> <-0.412, 2.234, -0.893> 
		<-0.444, 2.243, -0.903> <-0.435, 2.244, -0.900> <-0.420, 2.253, -0.903> <-0.415, 2.255, -0.895> 
		<-0.455, 2.261, -0.905> <-0.449, 2.268, -0.903> <-0.434, 2.277, -0.906> <-0.431, 2.282, -0.899> 
		<-0.466, 2.269, -0.907> <-0.461, 2.277, -0.905> <-0.450, 2.290, -0.909> <-0.448, 2.295, -0.901> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.412, 2.234, -0.893> <-0.404, 2.236, -0.877> <-0.398, 2.240, -0.848> <-0.405, 2.240, -0.831> 
		<-0.415, 2.255, -0.895> <-0.406, 2.257, -0.878> <-0.402, 2.264, -0.851> <-0.408, 2.264, -0.833> 
		<-0.431, 2.282, -0.899> <-0.426, 2.291, -0.883> <-0.422, 2.298, -0.855> <-0.427, 2.295, -0.837> 
		<-0.448, 2.295, -0.901> <-0.443, 2.304, -0.885> <-0.441, 2.312, -0.858> <-0.446, 2.309, -0.840> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.405, 2.240, -0.831> <-0.409, 2.241, -0.821> <-0.434, 2.238, -0.815> <-0.440, 2.236, -0.824> 
		<-0.408, 2.264, -0.833> <-0.412, 2.265, -0.823> <-0.436, 2.254, -0.816> <-0.442, 2.252, -0.825> 
		<-0.427, 2.295, -0.837> <-0.429, 2.293, -0.827> <-0.451, 2.279, -0.820> <-0.454, 2.273, -0.828> 
		<-0.446, 2.309, -0.840> <-0.448, 2.308, -0.830> <-0.464, 2.288, -0.821> <-0.467, 2.283, -0.830> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.440, 2.236, -0.824> <-0.451, 2.233, -0.843> <-0.444, 2.231, -0.876> <-0.446, 2.229, -0.899> 
		<-0.442, 2.252, -0.825> <-0.453, 2.249, -0.845> <-0.446, 2.244, -0.877> <-0.447, 2.242, -0.900> 
		<-0.454, 2.273, -0.828> <-0.460, 2.261, -0.846> <-0.457, 2.264, -0.880> <-0.458, 2.259, -0.902> 
		<-0.467, 2.283, -0.830> <-0.473, 2.271, -0.848> <-0.468, 2.272, -0.881> <-0.468, 2.267, -0.904> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.454, 2.183, -0.899> <-0.447, 2.178, -0.896> <-0.434, 2.167, -0.898> <-0.430, 2.165, -0.889> 
		<-0.446, 2.194, -0.899> <-0.438, 2.189, -0.896> <-0.421, 2.184, -0.898> <-0.417, 2.182, -0.889> 
		<-0.440, 2.215, -0.900> <-0.431, 2.216, -0.898> <-0.414, 2.211, -0.900> <-0.409, 2.213, -0.891> 
		<-0.442, 2.229, -0.901> <-0.433, 2.230, -0.899> <-0.417, 2.232, -0.901> <-0.412, 2.234, -0.893> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.430, 2.165, -0.889> <-0.423, 2.160, -0.872> <-0.420, 2.158, -0.844> <-0.425, 2.163, -0.826> 
		<-0.417, 2.182, -0.889> <-0.411, 2.177, -0.872> <-0.405, 2.177, -0.844> <-0.411, 2.182, -0.827> 
		<-0.409, 2.213, -0.891> <-0.401, 2.215, -0.875> <-0.395, 2.216, -0.846> <-0.402, 2.216, -0.829> 
		<-0.412, 2.234, -0.893> <-0.404, 2.236, -0.877> <-0.398, 2.240, -0.848> <-0.405, 2.240, -0.831> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.425, 2.163, -0.826> <-0.429, 2.165, -0.817> <-0.449, 2.181, -0.812> <-0.453, 2.184, -0.821> 
		<-0.411, 2.182, -0.827> <-0.414, 2.184, -0.817> <-0.439, 2.194, -0.812> <-0.443, 2.197, -0.821> 
		<-0.402, 2.216, -0.829> <-0.406, 2.217, -0.819> <-0.432, 2.222, -0.813> <-0.437, 2.220, -0.822> 
		<-0.405, 2.240, -0.831> <-0.409, 2.241, -0.821> <-0.434, 2.238, -0.815> <-0.440, 2.236, -0.824> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.453, 2.184, -0.821> <-0.462, 2.190, -0.841> <-0.456, 2.185, -0.874> <-0.457, 2.185, -0.896> 
		<-0.443, 2.197, -0.821> <-0.452, 2.203, -0.841> <-0.448, 2.195, -0.874> <-0.449, 2.196, -0.896> 
		<-0.437, 2.220, -0.822> <-0.449, 2.217, -0.842> <-0.442, 2.218, -0.875> <-0.444, 2.215, -0.897> 
		<-0.440, 2.236, -0.824> <-0.451, 2.233, -0.843> <-0.444, 2.231, -0.876> <-0.446, 2.229, -0.899> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.212, 2.392, -0.806> <1.214, 2.383, -0.804> <1.216, 2.366, -0.806> <1.216, 2.362, -0.798> 
		<1.226, 2.394, -0.805> <1.228, 2.385, -0.803> <1.237, 2.369, -0.804> <1.237, 2.365, -0.796> 
		<1.245, 2.405, -0.805> <1.252, 2.399, -0.802> <1.261, 2.384, -0.804> <1.264, 2.381, -0.795> 
		<1.253, 2.416, -0.805> <1.260, 2.411, -0.802> <1.274, 2.401, -0.804> <1.277, 2.398, -0.795> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.216, 2.362, -0.798> <1.216, 2.353, -0.781> <1.215, 2.348, -0.752> <1.213, 2.355, -0.735> 
		<1.237, 2.365, -0.796> <1.237, 2.356, -0.779> <1.239, 2.351, -0.751> <1.237, 2.358, -0.733> 
		<1.264, 2.381, -0.795> <1.271, 2.376, -0.778> <1.273, 2.372, -0.749> <1.267, 2.376, -0.732> 
		<1.277, 2.398, -0.795> <1.284, 2.393, -0.778> <1.288, 2.391, -0.750> <1.282, 2.396, -0.732> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.213, 2.355, -0.735> <1.211, 2.358, -0.725> <1.207, 2.384, -0.720> <1.207, 2.389, -0.729> 
		<1.237, 2.358, -0.733> <1.235, 2.362, -0.723> <1.224, 2.386, -0.718> <1.223, 2.391, -0.728> 
		<1.267, 2.376, -0.732> <1.264, 2.379, -0.722> <1.248, 2.401, -0.718> <1.244, 2.404, -0.727> 
		<1.282, 2.396, -0.732> <1.279, 2.398, -0.723> <1.258, 2.414, -0.718> <1.254, 2.417, -0.727> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.207, 2.389, -0.729> <1.207, 2.400, -0.748> <1.210, 2.393, -0.781> <1.212, 2.395, -0.804> 
		<1.223, 2.391, -0.728> <1.223, 2.403, -0.747> <1.224, 2.395, -0.780> <1.225, 2.397, -0.803> 
		<1.244, 2.404, -0.727> <1.235, 2.410, -0.747> <1.243, 2.407, -0.779> <1.242, 2.407, -0.802> 
		<1.254, 2.417, -0.727> <1.245, 2.423, -0.747> <1.252, 2.418, -0.780> <1.250, 2.418, -0.802> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.167, 2.404, -0.811> <1.161, 2.396, -0.809> <1.151, 2.383, -0.813> <1.148, 2.379, -0.805> 
		<1.178, 2.395, -0.810> <1.172, 2.388, -0.808> <1.168, 2.370, -0.810> <1.165, 2.367, -0.802> 
		<1.198, 2.390, -0.807> <1.200, 2.381, -0.805> <1.195, 2.363, -0.807> <1.195, 2.359, -0.799> 
		<1.212, 2.392, -0.806> <1.214, 2.383, -0.804> <1.216, 2.366, -0.806> <1.216, 2.362, -0.798> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.148, 2.379, -0.805> <1.140, 2.373, -0.789> <1.133, 2.369, -0.761> <1.135, 2.374, -0.743> 
		<1.165, 2.367, -0.802> <1.157, 2.360, -0.786> <1.152, 2.354, -0.758> <1.154, 2.360, -0.740> 
		<1.195, 2.359, -0.799> <1.195, 2.350, -0.782> <1.191, 2.344, -0.754> <1.189, 2.351, -0.737> 
		<1.216, 2.362, -0.798> <1.216, 2.353, -0.781> <1.215, 2.348, -0.752> <1.213, 2.355, -0.735> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.135, 2.374, -0.743> <1.136, 2.378, -0.733> <1.150, 2.398, -0.726> <1.155, 2.402, -0.734> 
		<1.154, 2.360, -0.740> <1.155, 2.363, -0.730> <1.163, 2.388, -0.724> <1.168, 2.393, -0.732> 
		<1.189, 2.351, -0.737> <1.188, 2.355, -0.727> <1.191, 2.381, -0.721> <1.191, 2.387, -0.730> 
		<1.213, 2.355, -0.735> <1.211, 2.358, -0.725> <1.207, 2.384, -0.720> <1.207, 2.389, -0.729> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.155, 2.402, -0.734> <1.164, 2.411, -0.753> <1.164, 2.405, -0.786> <1.168, 2.406, -0.808> 
		<1.168, 2.393, -0.732> <1.177, 2.402, -0.751> <1.175, 2.397, -0.784> <1.179, 2.398, -0.807> 
		<1.191, 2.387, -0.730> <1.191, 2.398, -0.749> <1.197, 2.391, -0.782> <1.198, 2.393, -0.805> 
		<1.207, 2.389, -0.729> <1.207, 2.400, -0.748> <1.210, 2.393, -0.781> <1.212, 2.395, -0.804> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.143, 2.444, -0.816> <1.134, 2.443, -0.815> <1.117, 2.440, -0.820> <1.112, 2.440, -0.812> 
		<1.145, 2.430, -0.815> <1.135, 2.429, -0.814> <1.120, 2.419, -0.818> <1.115, 2.419, -0.811> 
		<1.155, 2.412, -0.813> <1.150, 2.405, -0.811> <1.134, 2.396, -0.815> <1.131, 2.392, -0.807> 
		<1.167, 2.404, -0.811> <1.161, 2.396, -0.809> <1.151, 2.383, -0.813> <1.148, 2.379, -0.805> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.112, 2.440, -0.812> <1.100, 2.440, -0.797> <1.091, 2.441, -0.770> <1.094, 2.443, -0.752> 
		<1.115, 2.419, -0.811> <1.103, 2.419, -0.795> <1.094, 2.417, -0.768> <1.098, 2.420, -0.750> 
		<1.131, 2.392, -0.807> <1.123, 2.385, -0.791> <1.114, 2.383, -0.764> <1.116, 2.389, -0.746> 
		<1.148, 2.379, -0.805> <1.140, 2.373, -0.789> <1.133, 2.369, -0.761> <1.135, 2.374, -0.743> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.094, 2.443, -0.752> <1.097, 2.445, -0.742> <1.120, 2.449, -0.732> <1.127, 2.449, -0.740> 
		<1.098, 2.420, -0.750> <1.100, 2.421, -0.739> <1.123, 2.433, -0.731> <1.130, 2.433, -0.739> 
		<1.116, 2.389, -0.746> <1.117, 2.392, -0.736> <1.137, 2.408, -0.727> <1.142, 2.412, -0.736> 
		<1.135, 2.374, -0.743> <1.136, 2.378, -0.733> <1.150, 2.398, -0.726> <1.155, 2.402, -0.734> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.127, 2.449, -0.740> <1.142, 2.449, -0.758> <1.140, 2.446, -0.791> <1.146, 2.445, -0.813> 
		<1.130, 2.433, -0.739> <1.144, 2.433, -0.756> <1.142, 2.433, -0.790> <1.148, 2.432, -0.812> 
		<1.142, 2.412, -0.736> <1.151, 2.421, -0.754> <1.154, 2.413, -0.787> <1.158, 2.414, -0.810> 
		<1.155, 2.402, -0.734> <1.164, 2.411, -0.753> <1.164, 2.405, -0.786> <1.168, 2.406, -0.808> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.155, 2.490, -0.819> <1.147, 2.496, -0.818> <1.134, 2.505, -0.824> <1.130, 2.509, -0.816> 
		<1.146, 2.479, -0.819> <1.139, 2.484, -0.818> <1.122, 2.488, -0.823> <1.117, 2.492, -0.816> 
		<1.141, 2.458, -0.818> <1.132, 2.457, -0.816> <1.115, 2.461, -0.822> <1.109, 2.461, -0.814> 
		<1.143, 2.444, -0.816> <1.134, 2.443, -0.815> <1.117, 2.440, -0.820> <1.112, 2.440, -0.812> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.130, 2.509, -0.816> <1.120, 2.516, -0.802> <1.112, 2.523, -0.775> <1.115, 2.521, -0.756> 
		<1.117, 2.492, -0.816> <1.107, 2.499, -0.801> <1.097, 2.504, -0.775> <1.100, 2.502, -0.756> 
		<1.109, 2.461, -0.814> <1.098, 2.461, -0.799> <1.087, 2.465, -0.772> <1.091, 2.467, -0.754> 
		<1.112, 2.440, -0.812> <1.100, 2.440, -0.797> <1.091, 2.441, -0.770> <1.094, 2.443, -0.752> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.115, 2.521, -0.756> <1.116, 2.520, -0.746> <1.135, 2.506, -0.735> <1.141, 2.502, -0.743> 
		<1.100, 2.502, -0.756> <1.102, 2.501, -0.746> <1.126, 2.493, -0.735> <1.131, 2.489, -0.743> 
		<1.091, 2.467, -0.754> <1.093, 2.468, -0.744> <1.118, 2.465, -0.734> <1.125, 2.465, -0.742> 
		<1.094, 2.443, -0.752> <1.097, 2.445, -0.742> <1.120, 2.449, -0.732> <1.127, 2.449, -0.740> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.141, 2.502, -0.743> <1.153, 2.492, -0.760> <1.152, 2.492, -0.794> <1.157, 2.488, -0.816> 
		<1.131, 2.489, -0.743> <1.143, 2.479, -0.760> <1.144, 2.482, -0.794> <1.149, 2.478, -0.815> 
		<1.125, 2.465, -0.742> <1.140, 2.466, -0.759> <1.138, 2.459, -0.792> <1.144, 2.458, -0.814> 
		<1.127, 2.449, -0.740> <1.142, 2.449, -0.758> <1.140, 2.446, -0.791> <1.146, 2.445, -0.813> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.196, 2.514, -0.818> <1.194, 2.523, -0.817> <1.192, 2.540, -0.822> <1.191, 2.545, -0.814> 
		<1.182, 2.512, -0.819> <1.180, 2.521, -0.818> <1.171, 2.536, -0.823> <1.170, 2.542, -0.816> 
		<1.163, 2.501, -0.819> <1.156, 2.507, -0.818> <1.147, 2.522, -0.824> <1.143, 2.526, -0.817> 
		<1.155, 2.490, -0.819> <1.147, 2.496, -0.818> <1.134, 2.505, -0.824> <1.130, 2.509, -0.816> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.191, 2.545, -0.814> <1.188, 2.556, -0.799> <1.185, 2.566, -0.772> <1.184, 2.562, -0.754> 
		<1.170, 2.542, -0.816> <1.167, 2.553, -0.801> <1.161, 2.563, -0.774> <1.160, 2.559, -0.755> 
		<1.143, 2.526, -0.817> <1.133, 2.533, -0.802> <1.126, 2.542, -0.775> <1.129, 2.541, -0.757> 
		<1.130, 2.509, -0.816> <1.120, 2.516, -0.802> <1.112, 2.523, -0.775> <1.115, 2.521, -0.756> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.184, 2.562, -0.754> <1.184, 2.560, -0.743> <1.186, 2.536, -0.733> <1.188, 2.529, -0.741> 
		<1.160, 2.559, -0.755> <1.160, 2.557, -0.745> <1.170, 2.534, -0.735> <1.172, 2.527, -0.743> 
		<1.129, 2.541, -0.757> <1.131, 2.539, -0.746> <1.145, 2.519, -0.736> <1.151, 2.515, -0.743> 
		<1.115, 2.521, -0.756> <1.116, 2.520, -0.746> <1.135, 2.506, -0.735> <1.141, 2.502, -0.743> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.188, 2.529, -0.741> <1.191, 2.515, -0.759> <1.193, 2.517, -0.792> <1.196, 2.511, -0.814> 
		<1.172, 2.527, -0.743> <1.175, 2.513, -0.760> <1.180, 2.515, -0.793> <1.182, 2.509, -0.815> 
		<1.151, 2.515, -0.743> <1.163, 2.505, -0.760> <1.160, 2.503, -0.794> <1.165, 2.499, -0.816> 
		<1.141, 2.502, -0.743> <1.153, 2.492, -0.760> <1.152, 2.492, -0.794> <1.157, 2.488, -0.816> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.241, 2.503, -0.813> <1.247, 2.510, -0.811> <1.257, 2.523, -0.815> <1.259, 2.528, -0.807> 
		<1.230, 2.511, -0.814> <1.235, 2.519, -0.813> <1.240, 2.536, -0.817> <1.242, 2.540, -0.809> 
		<1.210, 2.516, -0.817> <1.208, 2.525, -0.816> <1.213, 2.543, -0.820> <1.212, 2.548, -0.813> 
		<1.196, 2.514, -0.818> <1.194, 2.523, -0.817> <1.192, 2.540, -0.822> <1.191, 2.545, -0.814> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.259, 2.528, -0.807> <1.264, 2.537, -0.791> <1.266, 2.545, -0.764> <1.262, 2.542, -0.746> 
		<1.242, 2.540, -0.809> <1.247, 2.550, -0.794> <1.247, 2.560, -0.767> <1.242, 2.557, -0.748> 
		<1.212, 2.548, -0.813> <1.209, 2.560, -0.798> <1.209, 2.570, -0.771> <1.208, 2.566, -0.752> 
		<1.191, 2.545, -0.814> <1.188, 2.556, -0.799> <1.185, 2.566, -0.772> <1.184, 2.562, -0.754> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.262, 2.542, -0.746> <1.259, 2.541, -0.736> <1.243, 2.522, -0.728> <1.240, 2.516, -0.736> 
		<1.242, 2.557, -0.748> <1.240, 2.555, -0.738> <1.230, 2.531, -0.729> <1.227, 2.526, -0.738> 
		<1.208, 2.566, -0.752> <1.207, 2.563, -0.742> <1.202, 2.538, -0.732> <1.204, 2.532, -0.740> 
		<1.184, 2.562, -0.754> <1.184, 2.560, -0.743> <1.186, 2.536, -0.733> <1.188, 2.529, -0.741> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.240, 2.516, -0.736> <1.234, 2.504, -0.754> <1.240, 2.505, -0.788> <1.239, 2.500, -0.810> 
		<1.227, 2.526, -0.738> <1.221, 2.514, -0.756> <1.229, 2.513, -0.789> <1.228, 2.508, -0.811> 
		<1.204, 2.532, -0.740> <1.207, 2.517, -0.757> <1.207, 2.519, -0.791> <1.209, 2.513, -0.813> 
		<1.188, 2.529, -0.741> <1.191, 2.515, -0.759> <1.193, 2.517, -0.792> <1.196, 2.511, -0.814> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.265, 2.462, -0.808> <1.274, 2.463, -0.805> <1.291, 2.465, -0.808> <1.295, 2.467, -0.799> 
		<1.263, 2.476, -0.809> <1.272, 2.477, -0.806> <1.288, 2.487, -0.809> <1.292, 2.488, -0.801> 
		<1.253, 2.494, -0.811> <1.258, 2.502, -0.809> <1.274, 2.510, -0.812> <1.276, 2.515, -0.805> 
		<1.241, 2.503, -0.813> <1.247, 2.510, -0.811> <1.257, 2.523, -0.815> <1.259, 2.528, -0.807> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.295, 2.467, -0.799> <1.304, 2.470, -0.783> <1.309, 2.473, -0.754> <1.302, 2.473, -0.737> 
		<1.292, 2.488, -0.801> <1.301, 2.491, -0.785> <1.306, 2.497, -0.757> <1.299, 2.497, -0.739> 
		<1.276, 2.515, -0.805> <1.281, 2.524, -0.789> <1.286, 2.531, -0.761> <1.281, 2.528, -0.743> 
		<1.259, 2.528, -0.807> <1.264, 2.537, -0.791> <1.266, 2.545, -0.764> <1.262, 2.542, -0.746> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.302, 2.473, -0.737> <1.298, 2.474, -0.727> <1.273, 2.471, -0.721> <1.268, 2.469, -0.730> 
		<1.299, 2.497, -0.739> <1.295, 2.498, -0.729> <1.271, 2.487, -0.723> <1.266, 2.485, -0.732> 
		<1.281, 2.528, -0.743> <1.278, 2.526, -0.733> <1.256, 2.512, -0.726> <1.253, 2.506, -0.734> 
		<1.262, 2.542, -0.746> <1.259, 2.541, -0.736> <1.243, 2.522, -0.728> <1.240, 2.516, -0.736> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.268, 2.469, -0.730> <1.256, 2.466, -0.749> <1.264, 2.464, -0.782> <1.262, 2.462, -0.805> 
		<1.266, 2.485, -0.732> <1.254, 2.482, -0.751> <1.262, 2.477, -0.784> <1.260, 2.475, -0.806> 
		<1.253, 2.506, -0.734> <1.247, 2.494, -0.752> <1.250, 2.497, -0.786> <1.250, 2.492, -0.808> 
		<1.240, 2.516, -0.736> <1.234, 2.504, -0.754> <1.240, 2.505, -0.788> <1.239, 2.500, -0.810> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.253, 2.416, -0.805> <1.260, 2.411, -0.802> <1.274, 2.401, -0.804> <1.277, 2.398, -0.795> 
		<1.262, 2.427, -0.805> <1.269, 2.422, -0.802> <1.287, 2.418, -0.804> <1.290, 2.415, -0.796> 
		<1.267, 2.448, -0.806> <1.276, 2.449, -0.804> <1.294, 2.444, -0.806> <1.298, 2.446, -0.797> 
		<1.265, 2.462, -0.808> <1.274, 2.463, -0.805> <1.291, 2.465, -0.808> <1.295, 2.467, -0.799> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.277, 2.398, -0.795> <1.284, 2.393, -0.778> <1.288, 2.391, -0.750> <1.282, 2.396, -0.732> 
		<1.290, 2.415, -0.796> <1.297, 2.410, -0.779> <1.302, 2.410, -0.750> <1.296, 2.415, -0.733> 
		<1.298, 2.446, -0.797> <1.307, 2.448, -0.781> <1.312, 2.449, -0.752> <1.306, 2.450, -0.735> 
		<1.295, 2.467, -0.799> <1.304, 2.470, -0.783> <1.309, 2.473, -0.754> <1.302, 2.473, -0.737> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.282, 2.396, -0.732> <1.279, 2.398, -0.723> <1.258, 2.414, -0.718> <1.254, 2.417, -0.727> 
		<1.296, 2.415, -0.733> <1.293, 2.418, -0.723> <1.268, 2.427, -0.718> <1.264, 2.430, -0.727> 
		<1.306, 2.450, -0.735> <1.302, 2.450, -0.725> <1.275, 2.455, -0.720> <1.270, 2.453, -0.729> 
		<1.302, 2.473, -0.737> <1.298, 2.474, -0.727> <1.273, 2.471, -0.721> <1.268, 2.469, -0.730> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.254, 2.417, -0.727> <1.245, 2.423, -0.747> <1.252, 2.418, -0.780> <1.250, 2.418, -0.802> 
		<1.264, 2.430, -0.727> <1.255, 2.436, -0.747> <1.260, 2.429, -0.780> <1.259, 2.429, -0.802> 
		<1.270, 2.453, -0.729> <1.259, 2.450, -0.748> <1.265, 2.451, -0.781> <1.264, 2.448, -0.804> 
		<1.268, 2.469, -0.730> <1.256, 2.466, -0.749> <1.264, 2.464, -0.782> <1.262, 2.462, -0.805> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.574, 2.114, -0.715> <-0.571, 2.114, -0.697> <-0.579, 2.118, -0.666> <-0.565, 2.116, -0.655> 
		<-0.573, 2.089, -0.713> <-0.571, 2.089, -0.695> <-0.579, 2.081, -0.663> <-0.565, 2.078, -0.652> 
		<-0.572, 2.053, -0.727> <-0.569, 2.042, -0.713> <-0.576, 2.034, -0.680> <-0.563, 2.025, -0.672> 
		<-0.571, 2.035, -0.744> <-0.568, 2.024, -0.730> <-0.575, 2.007, -0.706> <-0.562, 1.998, -0.698> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.565, 2.116, -0.655> <-0.540, 2.111, -0.635> <-0.492, 2.101, -0.617> <-0.461, 2.093, -0.626> 
		<-0.565, 2.078, -0.652> <-0.539, 2.073, -0.631> <-0.491, 2.058, -0.614> <-0.461, 2.051, -0.623> 
		<-0.563, 2.025, -0.672> <-0.538, 2.008, -0.657> <-0.492, 1.992, -0.639> <-0.459, 1.991, -0.646> 
		<-0.562, 1.998, -0.698> <-0.536, 1.981, -0.683> <-0.491, 1.961, -0.668> <-0.457, 1.960, -0.675> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.461, 2.093, -0.626> <-0.442, 2.088, -0.632> <-0.428, 2.082, -0.678> <-0.443, 2.085, -0.691> 
		<-0.461, 2.051, -0.623> <-0.442, 2.046, -0.628> <-0.428, 2.053, -0.675> <-0.443, 2.056, -0.689> 
		<-0.459, 1.991, -0.646> <-0.441, 1.990, -0.650> <-0.428, 2.006, -0.695> <-0.442, 2.015, -0.704> 
		<-0.457, 1.960, -0.675> <-0.439, 1.959, -0.679> <-0.427, 1.985, -0.715> <-0.441, 1.994, -0.724> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.443, 2.085, -0.691> <-0.473, 2.090, -0.717> <-0.531, 2.104, -0.712> <-0.568, 2.112, -0.721> 
		<-0.443, 2.056, -0.689> <-0.472, 2.061, -0.715> <-0.530, 2.080, -0.710> <-0.568, 2.088, -0.719> 
		<-0.442, 2.015, -0.704> <-0.470, 2.036, -0.724> <-0.529, 2.042, -0.725> <-0.567, 2.055, -0.732> 
		<-0.441, 1.994, -0.724> <-0.469, 2.015, -0.744> <-0.528, 2.025, -0.741> <-0.566, 2.037, -0.748> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.574, 2.187, -0.756> <-0.571, 2.198, -0.744> <-0.580, 2.222, -0.724> <-0.565, 2.225, -0.717> 
		<-0.574, 2.172, -0.736> <-0.571, 2.183, -0.724> <-0.580, 2.199, -0.694> <-0.566, 2.202, -0.687> 
		<-0.574, 2.139, -0.717> <-0.572, 2.139, -0.699> <-0.580, 2.156, -0.669> <-0.566, 2.153, -0.658> 
		<-0.574, 2.114, -0.715> <-0.571, 2.114, -0.697> <-0.579, 2.118, -0.666> <-0.565, 2.116, -0.655> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.565, 2.225, -0.717> <-0.538, 2.233, -0.702> <-0.490, 2.231, -0.691> <-0.461, 2.218, -0.696> 
		<-0.566, 2.202, -0.687> <-0.538, 2.210, -0.672> <-0.490, 2.205, -0.657> <-0.462, 2.192, -0.662> 
		<-0.566, 2.153, -0.658> <-0.540, 2.149, -0.638> <-0.493, 2.144, -0.621> <-0.462, 2.136, -0.630> 
		<-0.565, 2.116, -0.655> <-0.540, 2.111, -0.635> <-0.492, 2.101, -0.617> <-0.461, 2.093, -0.626> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.461, 2.218, -0.696> <-0.443, 2.209, -0.700> <-0.427, 2.174, -0.729> <-0.443, 2.169, -0.739> 
		<-0.462, 2.192, -0.662> <-0.444, 2.183, -0.666> <-0.427, 2.157, -0.706> <-0.444, 2.151, -0.716> 
		<-0.462, 2.136, -0.630> <-0.443, 2.131, -0.635> <-0.429, 2.111, -0.680> <-0.444, 2.114, -0.694> 
		<-0.461, 2.093, -0.626> <-0.442, 2.088, -0.632> <-0.428, 2.082, -0.678> <-0.443, 2.085, -0.691> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.443, 2.169, -0.739> <-0.475, 2.158, -0.757> <-0.531, 2.178, -0.754> <-0.568, 2.182, -0.760> 
		<-0.444, 2.151, -0.716> <-0.475, 2.141, -0.734> <-0.531, 2.163, -0.735> <-0.569, 2.167, -0.741> 
		<-0.444, 2.114, -0.694> <-0.473, 2.119, -0.719> <-0.531, 2.128, -0.714> <-0.569, 2.136, -0.723> 
		<-0.443, 2.085, -0.691> <-0.473, 2.090, -0.717> <-0.531, 2.104, -0.712> <-0.568, 2.112, -0.721> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.571, 2.212, -0.843> <-0.568, 2.227, -0.845> <-0.576, 2.257, -0.847> <-0.561, 2.263, -0.847> 
		<-0.572, 2.214, -0.816> <-0.569, 2.229, -0.817> <-0.577, 2.260, -0.807> <-0.563, 2.266, -0.807> 
		<-0.573, 2.203, -0.778> <-0.571, 2.215, -0.766> <-0.579, 2.246, -0.757> <-0.565, 2.250, -0.749> 
		<-0.574, 2.187, -0.756> <-0.571, 2.198, -0.744> <-0.580, 2.222, -0.724> <-0.565, 2.225, -0.717> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.561, 2.263, -0.847> <-0.533, 2.275, -0.848> <-0.485, 2.275, -0.846> <-0.457, 2.260, -0.844> 
		<-0.563, 2.266, -0.807> <-0.534, 2.278, -0.807> <-0.486, 2.279, -0.800> <-0.459, 2.264, -0.798> 
		<-0.565, 2.250, -0.749> <-0.537, 2.258, -0.734> <-0.489, 2.259, -0.728> <-0.461, 2.246, -0.733> 
		<-0.565, 2.225, -0.717> <-0.538, 2.233, -0.702> <-0.490, 2.231, -0.691> <-0.461, 2.218, -0.696> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.457, 2.260, -0.844> <-0.440, 2.251, -0.843> <-0.423, 2.207, -0.839> <-0.440, 2.198, -0.839> 
		<-0.459, 2.264, -0.798> <-0.442, 2.255, -0.797> <-0.424, 2.209, -0.808> <-0.442, 2.200, -0.808> 
		<-0.461, 2.246, -0.733> <-0.443, 2.237, -0.736> <-0.426, 2.193, -0.754> <-0.443, 2.188, -0.764> 
		<-0.461, 2.218, -0.696> <-0.443, 2.209, -0.700> <-0.427, 2.174, -0.729> <-0.443, 2.169, -0.739> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.440, 2.198, -0.839> <-0.474, 2.181, -0.838> <-0.528, 2.203, -0.842> <-0.566, 2.205, -0.843> 
		<-0.442, 2.200, -0.808> <-0.475, 2.183, -0.807> <-0.529, 2.205, -0.816> <-0.567, 2.207, -0.817> 
		<-0.443, 2.188, -0.764> <-0.474, 2.177, -0.782> <-0.530, 2.193, -0.774> <-0.568, 2.197, -0.780> 
		<-0.443, 2.169, -0.739> <-0.475, 2.158, -0.757> <-0.531, 2.178, -0.754> <-0.568, 2.182, -0.760> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.568, 2.174, -0.925> <-0.564, 2.184, -0.939> <-0.571, 2.204, -0.963> <-0.556, 2.207, -0.970> 
		<-0.569, 2.194, -0.907> <-0.565, 2.204, -0.920> <-0.573, 2.233, -0.935> <-0.558, 2.236, -0.942> 
		<-0.570, 2.210, -0.870> <-0.567, 2.225, -0.872> <-0.574, 2.254, -0.888> <-0.560, 2.260, -0.888> 
		<-0.571, 2.212, -0.843> <-0.568, 2.227, -0.845> <-0.576, 2.257, -0.847> <-0.561, 2.263, -0.847> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.556, 2.207, -0.970> <-0.528, 2.212, -0.984> <-0.479, 2.209, -0.992> <-0.451, 2.196, -0.984> 
		<-0.558, 2.236, -0.942> <-0.530, 2.241, -0.956> <-0.481, 2.242, -0.961> <-0.453, 2.230, -0.952> 
		<-0.560, 2.260, -0.888> <-0.531, 2.272, -0.888> <-0.483, 2.272, -0.892> <-0.455, 2.257, -0.890> 
		<-0.561, 2.263, -0.847> <-0.533, 2.275, -0.848> <-0.485, 2.275, -0.846> <-0.457, 2.260, -0.844> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.451, 2.196, -0.984> <-0.433, 2.189, -0.978> <-0.419, 2.159, -0.943> <-0.436, 2.154, -0.933> 
		<-0.453, 2.230, -0.952> <-0.435, 2.222, -0.946> <-0.420, 2.181, -0.921> <-0.438, 2.177, -0.912> 
		<-0.455, 2.257, -0.890> <-0.438, 2.248, -0.889> <-0.422, 2.204, -0.870> <-0.439, 2.195, -0.870> 
		<-0.457, 2.260, -0.844> <-0.440, 2.251, -0.843> <-0.423, 2.207, -0.839> <-0.440, 2.198, -0.839> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.436, 2.154, -0.933> <-0.469, 2.147, -0.915> <-0.525, 2.165, -0.924> <-0.562, 2.170, -0.921> 
		<-0.438, 2.177, -0.912> <-0.470, 2.169, -0.893> <-0.526, 2.184, -0.907> <-0.563, 2.188, -0.903> 
		<-0.439, 2.195, -0.870> <-0.473, 2.178, -0.869> <-0.527, 2.201, -0.867> <-0.565, 2.204, -0.868> 
		<-0.440, 2.198, -0.839> <-0.474, 2.181, -0.838> <-0.528, 2.203, -0.842> <-0.566, 2.205, -0.843> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.565, 2.096, -0.954> <-0.561, 2.094, -0.972> <-0.567, 2.093, -1.004> <-0.553, 2.089, -1.013> 
		<-0.566, 2.121, -0.956> <-0.562, 2.119, -0.974> <-0.568, 2.131, -1.007> <-0.553, 2.127, -1.017> 
		<-0.567, 2.156, -0.943> <-0.563, 2.166, -0.956> <-0.570, 2.177, -0.989> <-0.555, 2.180, -0.996> 
		<-0.568, 2.174, -0.925> <-0.564, 2.184, -0.939> <-0.571, 2.204, -0.963> <-0.556, 2.207, -0.970> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.553, 2.089, -1.013> <-0.526, 2.082, -1.031> <-0.477, 2.069, -1.045> <-0.447, 2.063, -1.033> 
		<-0.553, 2.127, -1.017> <-0.526, 2.119, -1.034> <-0.478, 2.112, -1.048> <-0.448, 2.106, -1.036> 
		<-0.555, 2.180, -0.996> <-0.527, 2.185, -1.010> <-0.478, 2.178, -1.022> <-0.450, 2.166, -1.013> 
		<-0.556, 2.207, -0.970> <-0.528, 2.212, -0.984> <-0.479, 2.209, -0.992> <-0.451, 2.196, -0.984> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.447, 2.063, -1.033> <-0.428, 2.059, -1.025> <-0.418, 2.060, -0.978> <-0.434, 2.064, -0.966> 
		<-0.448, 2.106, -1.036> <-0.429, 2.102, -1.029> <-0.418, 2.089, -0.980> <-0.434, 2.093, -0.969> 
		<-0.450, 2.166, -1.013> <-0.432, 2.158, -1.008> <-0.418, 2.138, -0.963> <-0.435, 2.134, -0.953> 
		<-0.451, 2.196, -0.984> <-0.433, 2.189, -0.978> <-0.419, 2.159, -0.943> <-0.436, 2.154, -0.933> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.434, 2.064, -0.966> <-0.464, 2.073, -0.943> <-0.522, 2.086, -0.953> <-0.560, 2.095, -0.948> 
		<-0.434, 2.093, -0.969> <-0.465, 2.102, -0.946> <-0.523, 2.110, -0.955> <-0.560, 2.119, -0.950> 
		<-0.435, 2.134, -0.953> <-0.468, 2.126, -0.935> <-0.524, 2.148, -0.941> <-0.562, 2.152, -0.937> 
		<-0.436, 2.154, -0.933> <-0.469, 2.147, -0.915> <-0.525, 2.165, -0.924> <-0.562, 2.170, -0.921> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.565, 2.023, -0.913> <-0.561, 2.010, -0.925> <-0.566, 1.989, -0.946> <-0.553, 1.979, -0.952> 
		<-0.565, 2.038, -0.933> <-0.561, 2.025, -0.945> <-0.566, 2.012, -0.976> <-0.552, 2.002, -0.982> 
		<-0.565, 2.071, -0.952> <-0.561, 2.069, -0.970> <-0.567, 2.056, -1.001> <-0.552, 2.051, -1.010> 
		<-0.565, 2.096, -0.954> <-0.561, 2.094, -0.972> <-0.567, 2.093, -1.004> <-0.553, 2.089, -1.013> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.553, 1.979, -0.952> <-0.526, 1.961, -0.963> <-0.480, 1.938, -0.972> <-0.447, 1.939, -0.963> 
		<-0.552, 2.002, -0.982> <-0.526, 1.984, -0.993> <-0.479, 1.964, -1.006> <-0.446, 1.965, -0.997> 
		<-0.552, 2.051, -1.010> <-0.525, 2.044, -1.028> <-0.477, 2.027, -1.041> <-0.446, 2.020, -1.029> 
		<-0.553, 2.089, -1.013> <-0.526, 2.082, -1.031> <-0.477, 2.069, -1.045> <-0.447, 2.063, -1.033> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.447, 1.939, -0.963> <-0.429, 1.939, -0.958> <-0.420, 1.970, -0.925> <-0.434, 1.980, -0.919> 
		<-0.446, 1.965, -0.997> <-0.429, 1.965, -0.992> <-0.419, 1.987, -0.948> <-0.433, 1.998, -0.942> 
		<-0.446, 2.020, -1.029> <-0.428, 2.017, -1.022> <-0.417, 2.031, -0.976> <-0.433, 2.035, -0.964> 
		<-0.447, 2.063, -1.033> <-0.428, 2.059, -1.025> <-0.418, 2.060, -0.978> <-0.434, 2.064, -0.966> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.434, 1.980, -0.919> <-0.464, 2.003, -0.905> <-0.522, 2.012, -0.912> <-0.560, 2.026, -0.909> 
		<-0.433, 1.998, -0.942> <-0.463, 2.021, -0.928> <-0.522, 2.027, -0.931> <-0.560, 2.040, -0.928> 
		<-0.433, 2.035, -0.964> <-0.464, 2.044, -0.941> <-0.522, 2.062, -0.951> <-0.560, 2.071, -0.946> 
		<-0.434, 2.064, -0.966> <-0.464, 2.073, -0.943> <-0.522, 2.086, -0.953> <-0.560, 2.095, -0.948> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.568, 1.998, -0.826> <-0.564, 1.981, -0.824> <-0.569, 1.953, -0.822> <-0.556, 1.942, -0.821> 
		<-0.567, 1.996, -0.853> <-0.563, 1.979, -0.851> <-0.568, 1.950, -0.863> <-0.555, 1.939, -0.862> 
		<-0.566, 2.006, -0.891> <-0.562, 1.993, -0.903> <-0.567, 1.964, -0.913> <-0.553, 1.954, -0.919> 
		<-0.565, 2.023, -0.913> <-0.561, 2.010, -0.925> <-0.566, 1.989, -0.946> <-0.553, 1.979, -0.952> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.556, 1.942, -0.821> <-0.531, 1.919, -0.818> <-0.486, 1.893, -0.815> <-0.451, 1.896, -0.814> 
		<-0.555, 1.939, -0.862> <-0.529, 1.916, -0.859> <-0.484, 1.890, -0.861> <-0.450, 1.892, -0.861> 
		<-0.553, 1.954, -0.919> <-0.527, 1.936, -0.930> <-0.481, 1.910, -0.935> <-0.448, 1.910, -0.926> 
		<-0.553, 1.979, -0.952> <-0.526, 1.961, -0.963> <-0.480, 1.938, -0.972> <-0.447, 1.939, -0.963> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.451, 1.896, -0.814> <-0.434, 1.897, -0.814> <-0.424, 1.939, -0.817> <-0.437, 1.951, -0.819> 
		<-0.450, 1.892, -0.861> <-0.433, 1.894, -0.860> <-0.423, 1.937, -0.849> <-0.435, 1.949, -0.850> 
		<-0.448, 1.910, -0.926> <-0.430, 1.911, -0.921> <-0.420, 1.951, -0.901> <-0.434, 1.961, -0.894> 
		<-0.447, 1.939, -0.963> <-0.429, 1.939, -0.958> <-0.420, 1.970, -0.925> <-0.434, 1.980, -0.919> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.437, 1.951, -0.819> <-0.466, 1.979, -0.822> <-0.525, 1.987, -0.824> <-0.563, 2.002, -0.826> 
		<-0.435, 1.949, -0.850> <-0.465, 1.977, -0.853> <-0.524, 1.985, -0.850> <-0.562, 2.000, -0.852> 
		<-0.434, 1.961, -0.894> <-0.464, 1.984, -0.880> <-0.523, 1.996, -0.891> <-0.561, 2.010, -0.888> 
		<-0.434, 1.980, -0.919> <-0.464, 2.003, -0.905> <-0.522, 2.012, -0.912> <-0.560, 2.026, -0.909> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.571, 2.035, -0.744> <-0.568, 2.024, -0.730> <-0.575, 2.007, -0.706> <-0.562, 1.998, -0.698> 
		<-0.570, 2.016, -0.763> <-0.567, 2.004, -0.749> <-0.574, 1.978, -0.734> <-0.560, 1.969, -0.726> 
		<-0.569, 2.000, -0.799> <-0.565, 1.983, -0.797> <-0.571, 1.956, -0.782> <-0.558, 1.945, -0.780> 
		<-0.568, 1.998, -0.826> <-0.564, 1.981, -0.824> <-0.569, 1.953, -0.822> <-0.556, 1.942, -0.821> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.562, 1.998, -0.698> <-0.536, 1.981, -0.683> <-0.491, 1.961, -0.668> <-0.457, 1.960, -0.675> 
		<-0.560, 1.969, -0.726> <-0.535, 1.952, -0.711> <-0.489, 1.928, -0.700> <-0.456, 1.927, -0.707> 
		<-0.558, 1.945, -0.780> <-0.532, 1.922, -0.778> <-0.487, 1.896, -0.769> <-0.453, 1.899, -0.769> 
		<-0.556, 1.942, -0.821> <-0.531, 1.919, -0.818> <-0.486, 1.893, -0.815> <-0.451, 1.896, -0.814> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.457, 1.960, -0.675> <-0.439, 1.959, -0.679> <-0.427, 1.985, -0.715> <-0.441, 1.994, -0.724> 
		<-0.456, 1.927, -0.707> <-0.437, 1.926, -0.711> <-0.426, 1.962, -0.737> <-0.439, 1.972, -0.746> 
		<-0.453, 1.899, -0.769> <-0.436, 1.901, -0.768> <-0.425, 1.942, -0.786> <-0.438, 1.953, -0.788> 
		<-0.451, 1.896, -0.814> <-0.434, 1.897, -0.814> <-0.424, 1.939, -0.817> <-0.437, 1.951, -0.819> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.441, 1.994, -0.724> <-0.469, 2.015, -0.744> <-0.528, 2.025, -0.741> <-0.566, 2.037, -0.748> 
		<-0.439, 1.972, -0.746> <-0.468, 1.993, -0.765> <-0.527, 2.006, -0.759> <-0.565, 2.019, -0.766> 
		<-0.438, 1.953, -0.788> <-0.467, 1.982, -0.791> <-0.526, 1.988, -0.798> <-0.563, 2.004, -0.800> 
		<-0.437, 1.951, -0.819> <-0.466, 1.979, -0.822> <-0.525, 1.987, -0.824> <-0.563, 2.002, -0.826> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.217, 2.343, -0.617> <1.219, 2.346, -0.599> <1.210, 2.346, -0.568> <1.223, 2.353, -0.558> 
		<1.233, 2.324, -0.614> <1.235, 2.327, -0.596> <1.234, 2.317, -0.563> <1.246, 2.325, -0.553> 
		<1.256, 2.296, -0.626> <1.265, 2.289, -0.612> <1.264, 2.281, -0.578> <1.280, 2.283, -0.570> 
		<1.267, 2.281, -0.642> <1.277, 2.275, -0.628> <1.282, 2.259, -0.603> <1.298, 2.260, -0.595> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.223, 2.353, -0.558> <1.246, 2.367, -0.538> <1.290, 2.389, -0.522> <1.319, 2.401, -0.532> 
		<1.246, 2.325, -0.553> <1.270, 2.338, -0.533> <1.316, 2.356, -0.517> <1.345, 2.368, -0.527> 
		<1.280, 2.283, -0.570> <1.311, 2.286, -0.555> <1.357, 2.302, -0.538> <1.384, 2.321, -0.547> 
		<1.298, 2.260, -0.595> <1.328, 2.264, -0.580> <1.377, 2.276, -0.566> <1.404, 2.296, -0.575> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.319, 2.401, -0.532> <1.337, 2.409, -0.539> <1.352, 2.409, -0.585> <1.338, 2.401, -0.598> 
		<1.345, 2.368, -0.527> <1.363, 2.376, -0.533> <1.370, 2.387, -0.581> <1.356, 2.379, -0.594> 
		<1.384, 2.321, -0.547> <1.398, 2.331, -0.552> <1.398, 2.348, -0.598> <1.382, 2.347, -0.607> 
		<1.404, 2.296, -0.575> <1.419, 2.306, -0.579> <1.412, 2.331, -0.617> <1.396, 2.330, -0.626> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.338, 2.401, -0.598> <1.312, 2.386, -0.622> <1.257, 2.362, -0.616> <1.223, 2.345, -0.623> 
		<1.356, 2.379, -0.594> <1.330, 2.364, -0.619> <1.272, 2.343, -0.612> <1.238, 2.326, -0.620> 
		<1.382, 2.347, -0.607> <1.347, 2.344, -0.627> <1.297, 2.313, -0.625> <1.259, 2.300, -0.631> 
		<1.396, 2.330, -0.626> <1.360, 2.327, -0.645> <1.308, 2.299, -0.641> <1.270, 2.285, -0.647> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.172, 2.398, -0.662> <1.167, 2.409, -0.651> <1.147, 2.424, -0.632> <1.155, 2.436, -0.625> 
		<1.182, 2.387, -0.641> <1.177, 2.398, -0.630> <1.160, 2.407, -0.601> <1.169, 2.419, -0.594> 
		<1.202, 2.362, -0.621> <1.203, 2.365, -0.603> <1.187, 2.375, -0.573> <1.199, 2.383, -0.563> 
		<1.217, 2.343, -0.617> <1.219, 2.346, -0.599> <1.210, 2.346, -0.568> <1.223, 2.353, -0.558> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.155, 2.436, -0.625> <1.172, 2.460, -0.612> <1.212, 2.488, -0.603> <1.242, 2.495, -0.609> 
		<1.169, 2.419, -0.594> <1.186, 2.443, -0.581> <1.227, 2.469, -0.568> <1.258, 2.476, -0.573> 
		<1.199, 2.383, -0.563> <1.223, 2.396, -0.543> <1.263, 2.422, -0.528> <1.292, 2.434, -0.538> 
		<1.223, 2.353, -0.558> <1.246, 2.367, -0.538> <1.290, 2.389, -0.522> <1.319, 2.401, -0.532> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.242, 2.495, -0.609> <1.262, 2.499, -0.612> <1.296, 2.480, -0.640> <1.286, 2.465, -0.649> 
		<1.258, 2.476, -0.573> <1.277, 2.480, -0.577> <1.307, 2.467, -0.616> <1.297, 2.452, -0.625> 
		<1.292, 2.434, -0.538> <1.310, 2.442, -0.544> <1.334, 2.432, -0.589> <1.320, 2.424, -0.601> 
		<1.319, 2.401, -0.532> <1.337, 2.409, -0.539> <1.352, 2.409, -0.585> <1.338, 2.401, -0.598> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.286, 2.465, -0.649> <1.268, 2.436, -0.666> <1.212, 2.417, -0.661> <1.180, 2.397, -0.666> 
		<1.297, 2.452, -0.625> <1.279, 2.423, -0.642> <1.221, 2.407, -0.641> <1.189, 2.386, -0.646> 
		<1.320, 2.424, -0.601> <1.294, 2.408, -0.626> <1.242, 2.380, -0.619> <1.208, 2.363, -0.626> 
		<1.338, 2.401, -0.598> <1.312, 2.386, -0.622> <1.257, 2.362, -0.616> <1.223, 2.345, -0.623> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.159, 2.414, -0.751> <1.152, 2.427, -0.753> <1.127, 2.446, -0.756> <1.135, 2.459, -0.757> 
		<1.157, 2.416, -0.723> <1.150, 2.430, -0.726> <1.124, 2.450, -0.716> <1.132, 2.464, -0.717> 
		<1.163, 2.410, -0.685> <1.158, 2.421, -0.673> <1.132, 2.441, -0.665> <1.141, 2.454, -0.659> 
		<1.172, 2.398, -0.662> <1.167, 2.409, -0.651> <1.147, 2.424, -0.632> <1.155, 2.436, -0.625> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.135, 2.459, -0.757> <1.150, 2.487, -0.759> <1.188, 2.516, -0.760> <1.219, 2.521, -0.759> 
		<1.132, 2.464, -0.717> <1.147, 2.491, -0.719> <1.185, 2.521, -0.714> <1.216, 2.526, -0.713> 
		<1.141, 2.454, -0.659> <1.158, 2.477, -0.646> <1.195, 2.508, -0.641> <1.226, 2.515, -0.647> 
		<1.155, 2.436, -0.625> <1.172, 2.460, -0.612> <1.212, 2.488, -0.603> <1.242, 2.495, -0.609> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.219, 2.521, -0.759> <1.238, 2.525, -0.758> <1.279, 2.500, -0.752> <1.271, 2.483, -0.751> 
		<1.216, 2.526, -0.713> <1.235, 2.529, -0.712> <1.277, 2.503, -0.721> <1.268, 2.486, -0.720> 
		<1.226, 2.515, -0.647> <1.245, 2.519, -0.650> <1.285, 2.494, -0.666> <1.275, 2.478, -0.675> 
		<1.242, 2.495, -0.609> <1.262, 2.499, -0.612> <1.296, 2.480, -0.640> <1.286, 2.465, -0.649> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.271, 2.483, -0.751> <1.255, 2.449, -0.748> <1.198, 2.433, -0.750> <1.167, 2.412, -0.750> 
		<1.268, 2.486, -0.720> <1.252, 2.452, -0.717> <1.196, 2.436, -0.724> <1.165, 2.414, -0.724> 
		<1.275, 2.478, -0.675> <1.257, 2.449, -0.692> <1.203, 2.428, -0.682> <1.171, 2.408, -0.687> 
		<1.286, 2.465, -0.649> <1.268, 2.436, -0.666> <1.212, 2.417, -0.661> <1.180, 2.397, -0.666> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.185, 2.381, -0.831> <1.181, 2.389, -0.845> <1.163, 2.399, -0.869> <1.174, 2.410, -0.877> 
		<1.172, 2.397, -0.813> <1.168, 2.405, -0.827> <1.144, 2.423, -0.843> <1.154, 2.434, -0.851> 
		<1.161, 2.411, -0.777> <1.154, 2.425, -0.779> <1.130, 2.442, -0.797> <1.138, 2.455, -0.798> 
		<1.159, 2.414, -0.751> <1.152, 2.427, -0.753> <1.127, 2.446, -0.756> <1.135, 2.459, -0.757> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.174, 2.410, -0.877> <1.192, 2.431, -0.893> <1.233, 2.457, -0.903> <1.263, 2.465, -0.895> 
		<1.154, 2.434, -0.851> <1.173, 2.455, -0.866> <1.211, 2.485, -0.873> <1.241, 2.493, -0.865> 
		<1.138, 2.455, -0.798> <1.153, 2.483, -0.800> <1.192, 2.511, -0.806> <1.222, 2.517, -0.804> 
		<1.135, 2.459, -0.757> <1.150, 2.487, -0.759> <1.188, 2.516, -0.760> <1.219, 2.521, -0.759> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.263, 2.465, -0.895> <1.282, 2.471, -0.890> <1.311, 2.458, -0.853> <1.300, 2.445, -0.843> 
		<1.241, 2.493, -0.865> <1.260, 2.498, -0.860> <1.297, 2.476, -0.833> <1.286, 2.463, -0.822> 
		<1.222, 2.517, -0.804> <1.242, 2.520, -0.803> <1.281, 2.497, -0.783> <1.273, 2.479, -0.782> 
		<1.219, 2.521, -0.759> <1.238, 2.525, -0.758> <1.279, 2.500, -0.752> <1.271, 2.483, -0.751> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.300, 2.445, -0.843> <1.279, 2.420, -0.823> <1.224, 2.400, -0.831> <1.191, 2.380, -0.826> 
		<1.286, 2.463, -0.822> <1.265, 2.438, -0.802> <1.212, 2.415, -0.814> <1.179, 2.396, -0.809> 
		<1.273, 2.479, -0.782> <1.257, 2.445, -0.779> <1.200, 2.430, -0.776> <1.169, 2.409, -0.775> 
		<1.271, 2.483, -0.751> <1.255, 2.449, -0.748> <1.198, 2.433, -0.750> <1.167, 2.412, -0.750> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.235, 2.318, -0.855> <1.239, 2.318, -0.873> <1.234, 2.312, -0.905> <1.249, 2.317, -0.915> 
		<1.219, 2.338, -0.859> <1.223, 2.337, -0.877> <1.211, 2.341, -0.909> <1.225, 2.346, -0.920> 
		<1.196, 2.366, -0.847> <1.193, 2.375, -0.861> <1.181, 2.377, -0.894> <1.191, 2.388, -0.902> 
		<1.185, 2.381, -0.831> <1.181, 2.389, -0.845> <1.163, 2.399, -0.869> <1.174, 2.410, -0.877> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.249, 2.317, -0.915> <1.274, 2.326, -0.933> <1.320, 2.345, -0.948> <1.348, 2.360, -0.937> 
		<1.225, 2.346, -0.920> <1.251, 2.355, -0.938> <1.293, 2.378, -0.954> <1.321, 2.393, -0.943> 
		<1.191, 2.388, -0.902> <1.210, 2.408, -0.918> <1.253, 2.432, -0.931> <1.283, 2.440, -0.923> 
		<1.174, 2.410, -0.877> <1.192, 2.431, -0.893> <1.233, 2.457, -0.903> <1.263, 2.465, -0.895> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.348, 2.360, -0.937> <1.365, 2.369, -0.930> <1.373, 2.379, -0.884> <1.358, 2.373, -0.871> 
		<1.321, 2.393, -0.943> <1.338, 2.401, -0.936> <1.355, 2.401, -0.887> <1.340, 2.396, -0.875> 
		<1.283, 2.440, -0.923> <1.302, 2.445, -0.917> <1.325, 2.441, -0.872> <1.314, 2.428, -0.862> 
		<1.263, 2.465, -0.895> <1.282, 2.471, -0.890> <1.311, 2.458, -0.853> <1.300, 2.445, -0.843> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.358, 2.373, -0.871> <1.328, 2.363, -0.848> <1.275, 2.337, -0.856> <1.239, 2.321, -0.849> 
		<1.340, 2.396, -0.875> <1.310, 2.385, -0.851> <1.260, 2.355, -0.859> <1.224, 2.340, -0.853> 
		<1.314, 2.428, -0.862> <1.293, 2.403, -0.841> <1.235, 2.386, -0.846> <1.203, 2.366, -0.841> 
		<1.300, 2.445, -0.843> <1.279, 2.420, -0.823> <1.224, 2.400, -0.831> <1.191, 2.380, -0.826> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.279, 2.263, -0.811> <1.290, 2.255, -0.822> <1.299, 2.234, -0.842> <1.316, 2.234, -0.848> 
		<1.270, 2.274, -0.831> <1.281, 2.266, -0.842> <1.285, 2.251, -0.873> <1.302, 2.251, -0.879> 
		<1.250, 2.299, -0.852> <1.254, 2.299, -0.870> <1.258, 2.283, -0.900> <1.272, 2.288, -0.910> 
		<1.235, 2.318, -0.855> <1.239, 2.318, -0.873> <1.234, 2.312, -0.905> <1.249, 2.317, -0.915> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.316, 2.234, -0.848> <1.348, 2.235, -0.859> <1.398, 2.245, -0.868> <1.424, 2.266, -0.861> 
		<1.302, 2.251, -0.879> <1.335, 2.252, -0.890> <1.383, 2.264, -0.904> <1.409, 2.285, -0.896> 
		<1.272, 2.288, -0.910> <1.298, 2.297, -0.928> <1.347, 2.312, -0.942> <1.375, 2.327, -0.931> 
		<1.249, 2.317, -0.915> <1.274, 2.326, -0.933> <1.320, 2.345, -0.948> <1.348, 2.360, -0.937> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.424, 2.266, -0.861> <1.438, 2.278, -0.857> <1.427, 2.310, -0.826> <1.409, 2.310, -0.820> 
		<1.409, 2.285, -0.896> <1.423, 2.296, -0.892> <1.416, 2.322, -0.850> <1.399, 2.323, -0.844> 
		<1.375, 2.327, -0.931> <1.392, 2.336, -0.925> <1.391, 2.356, -0.880> <1.376, 2.351, -0.868> 
		<1.348, 2.360, -0.937> <1.365, 2.369, -0.930> <1.373, 2.379, -0.884> <1.358, 2.373, -0.871> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.409, 2.310, -0.820> <1.372, 2.311, -0.805> <1.320, 2.281, -0.811> <1.282, 2.269, -0.807> 
		<1.399, 2.323, -0.844> <1.361, 2.323, -0.829> <1.311, 2.292, -0.830> <1.273, 2.280, -0.827> 
		<1.376, 2.351, -0.868> <1.346, 2.341, -0.844> <1.290, 2.318, -0.853> <1.254, 2.303, -0.846> 
		<1.358, 2.373, -0.871> <1.328, 2.363, -0.848> <1.275, 2.337, -0.856> <1.239, 2.321, -0.849> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.293, 2.248, -0.722> <1.306, 2.237, -0.720> <1.319, 2.212, -0.716> <1.336, 2.211, -0.715> 
		<1.295, 2.245, -0.749> <1.308, 2.234, -0.747> <1.322, 2.208, -0.757> <1.339, 2.207, -0.756> 
		<1.289, 2.252, -0.788> <1.300, 2.243, -0.799> <1.314, 2.216, -0.808> <1.331, 2.217, -0.814> 
		<1.279, 2.263, -0.811> <1.290, 2.255, -0.822> <1.299, 2.234, -0.842> <1.316, 2.234, -0.848> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.336, 2.211, -0.715> <1.371, 2.209, -0.713> <1.422, 2.216, -0.710> <1.447, 2.240, -0.711> 
		<1.339, 2.207, -0.756> <1.374, 2.205, -0.753> <1.425, 2.212, -0.756> <1.451, 2.235, -0.757> 
		<1.331, 2.217, -0.814> <1.363, 2.217, -0.825> <1.415, 2.225, -0.830> <1.441, 2.246, -0.823> 
		<1.316, 2.234, -0.848> <1.348, 2.235, -0.859> <1.398, 2.245, -0.868> <1.424, 2.266, -0.861> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.447, 2.240, -0.711> <1.460, 2.251, -0.711> <1.442, 2.290, -0.717> <1.425, 2.292, -0.718> 
		<1.451, 2.235, -0.757> <1.463, 2.247, -0.757> <1.444, 2.287, -0.748> <1.427, 2.289, -0.749> 
		<1.441, 2.246, -0.823> <1.455, 2.257, -0.819> <1.438, 2.296, -0.801> <1.421, 2.296, -0.794> 
		<1.424, 2.266, -0.861> <1.438, 2.278, -0.857> <1.427, 2.310, -0.826> <1.409, 2.310, -0.820> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.425, 2.292, -0.718> <1.385, 2.296, -0.721> <1.334, 2.266, -0.722> <1.295, 2.254, -0.723> 
		<1.427, 2.289, -0.749> <1.387, 2.293, -0.753> <1.336, 2.263, -0.747> <1.297, 2.252, -0.749> 
		<1.421, 2.296, -0.794> <1.383, 2.297, -0.780> <1.329, 2.270, -0.789> <1.291, 2.258, -0.786> 
		<1.409, 2.310, -0.820> <1.372, 2.311, -0.805> <1.320, 2.281, -0.811> <1.282, 2.269, -0.807> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.267, 2.281, -0.642> <1.277, 2.275, -0.628> <1.282, 2.259, -0.603> <1.298, 2.260, -0.595> 
		<1.280, 2.265, -0.660> <1.289, 2.259, -0.646> <1.301, 2.234, -0.629> <1.317, 2.236, -0.622> 
		<1.291, 2.251, -0.695> <1.304, 2.239, -0.693> <1.316, 2.216, -0.676> <1.334, 2.215, -0.675> 
		<1.293, 2.248, -0.722> <1.306, 2.237, -0.720> <1.319, 2.212, -0.716> <1.336, 2.211, -0.715> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.298, 2.260, -0.595> <1.328, 2.264, -0.580> <1.377, 2.276, -0.566> <1.404, 2.296, -0.575> 
		<1.317, 2.236, -0.622> <1.347, 2.240, -0.607> <1.399, 2.249, -0.596> <1.426, 2.268, -0.605> 
		<1.334, 2.215, -0.675> <1.368, 2.213, -0.672> <1.419, 2.221, -0.664> <1.444, 2.244, -0.665> 
		<1.336, 2.211, -0.715> <1.371, 2.209, -0.713> <1.422, 2.216, -0.710> <1.447, 2.240, -0.711> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.404, 2.296, -0.575> <1.419, 2.306, -0.579> <1.412, 2.331, -0.617> <1.396, 2.330, -0.626> 
		<1.426, 2.268, -0.605> <1.440, 2.279, -0.609> <1.427, 2.313, -0.638> <1.410, 2.311, -0.647> 
		<1.444, 2.244, -0.665> <1.457, 2.256, -0.666> <1.440, 2.294, -0.686> <1.423, 2.295, -0.687> 
		<1.447, 2.240, -0.711> <1.460, 2.251, -0.711> <1.442, 2.290, -0.717> <1.425, 2.292, -0.718> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.396, 2.330, -0.626> <1.360, 2.327, -0.645> <1.308, 2.299, -0.641> <1.270, 2.285, -0.647> 
		<1.410, 2.311, -0.647> <1.375, 2.309, -0.666> <1.320, 2.284, -0.657> <1.282, 2.270, -0.664> 
		<1.423, 2.295, -0.687> <1.382, 2.299, -0.691> <1.332, 2.268, -0.696> <1.293, 2.257, -0.697> 
		<1.425, 2.292, -0.718> <1.385, 2.296, -0.721> <1.334, 2.266, -0.722> <1.295, 2.254, -0.723> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.334, 2.411, 0.839> <1.342, 2.481, 0.856> <1.328, 2.557, 0.817> <1.303, 2.576, 0.751> 
		<1.062, 2.416, 0.943> <1.070, 2.486, 0.961> <1.056, 2.561, 0.921> <1.031, 2.581, 0.855> 
		<0.699, 2.422, 1.082> <0.707, 2.493, 1.100> <0.693, 2.568, 1.060> <0.668, 2.588, 0.994> 
		<0.427, 2.427, 1.186> <0.435, 2.498, 1.204> <0.421, 2.573, 1.164> <0.396, 2.592, 1.098> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.303, 2.576, 0.751> <1.278, 2.596, 0.685> <1.251, 2.553, 0.615> <1.243, 2.483, 0.597> 
		<1.031, 2.581, 0.855> <1.006, 2.601, 0.789> <0.979, 2.558, 0.719> <0.971, 2.488, 0.701> 
		<0.668, 2.588, 0.994> <0.643, 2.607, 0.928> <0.616, 2.565, 0.858> <0.608, 2.494, 0.840> 
		<0.396, 2.592, 1.098> <0.371, 2.612, 1.032> <0.344, 2.570, 0.962> <0.336, 2.499, 0.944> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.243, 2.483, 0.597> <1.235, 2.412, 0.579> <1.249, 2.337, 0.619> <1.273, 2.318, 0.685> 
		<0.971, 2.488, 0.701> <0.962, 2.417, 0.683> <0.976, 2.342, 0.723> <1.001, 2.323, 0.789> 
		<0.608, 2.494, 0.840> <0.600, 2.424, 0.822> <0.614, 2.349, 0.862> <0.639, 2.329, 0.928> 
		<0.336, 2.499, 0.944> <0.328, 2.429, 0.926> <0.342, 2.354, 0.966> <0.366, 2.334, 1.032> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.366, 2.334, 1.032> <0.391, 2.314, 1.098> <0.419, 2.357, 1.168> <0.427, 2.427, 1.186> 
		<0.639, 2.329, 0.928> <0.663, 2.309, 0.994> <0.691, 2.352, 1.064> <0.699, 2.422, 1.082> 
		<1.001, 2.323, 0.789> <1.026, 2.303, 0.855> <1.054, 2.345, 0.925> <1.062, 2.416, 0.943> 
		<1.273, 2.318, 0.685> <1.298, 2.298, 0.751> <1.326, 2.340, 0.821> <1.334, 2.411, 0.839> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.726, 2.459, 0.970> <0.728, 2.476, 0.974> <0.724, 2.494, 0.964> <0.718, 2.499, 0.948> 
		<0.498, 2.472, 1.052> <0.500, 2.489, 1.056> <0.497, 2.507, 1.046> <0.491, 2.511, 1.031> 
		<0.195, 2.489, 1.161> <0.196, 2.506, 1.166> <0.193, 2.524, 1.156> <0.187, 2.528, 1.140> 
		<-0.033, 2.501, 1.244> <-0.031, 2.518, 1.248> <-0.035, 2.536, 1.238> <-0.041, 2.541, 1.222> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.718, 2.499, 0.948> <0.712, 2.504, 0.933> <0.706, 2.493, 0.916> <0.704, 2.476, 0.911> 
		<0.491, 2.511, 1.031> <0.485, 2.516, 1.015> <0.478, 2.506, 0.998> <0.476, 2.489, 0.994> 
		<0.187, 2.528, 1.140> <0.181, 2.533, 1.124> <0.175, 2.523, 1.108> <0.173, 2.506, 1.103> 
		<-0.041, 2.541, 1.222> <-0.047, 2.546, 1.207> <-0.053, 2.536, 1.190> <-0.055, 2.519, 1.186> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.704, 2.476, 0.911> <0.702, 2.460, 0.907> <0.705, 2.441, 0.917> <0.711, 2.437, 0.933> 
		<0.476, 2.489, 0.994> <0.474, 2.472, 0.989> <0.478, 2.454, 0.999> <0.484, 2.449, 1.015> 
		<0.173, 2.506, 1.103> <0.171, 2.489, 1.099> <0.174, 2.471, 1.109> <0.180, 2.466, 1.124> 
		<-0.055, 2.519, 1.186> <-0.057, 2.502, 1.181> <-0.054, 2.484, 1.191> <-0.048, 2.479, 1.207> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.048, 2.479, 1.207> <-0.042, 2.474, 1.222> <-0.035, 2.485, 1.239> <-0.033, 2.501, 1.244> 
		<0.180, 2.466, 1.124> <0.186, 2.462, 1.140> <0.193, 2.472, 1.157> <0.195, 2.489, 1.161> 
		<0.484, 2.449, 1.015> <0.490, 2.445, 1.031> <0.496, 2.455, 1.047> <0.498, 2.472, 1.052> 
		<0.711, 2.437, 0.933> <0.717, 2.432, 0.948> <0.724, 2.442, 0.965> <0.726, 2.459, 0.970> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.304, 2.426, 1.083> <0.305, 2.417, 1.080> <0.299, 2.401, 1.078> <0.306, 2.396, 1.073> 
		<0.299, 2.430, 1.070> <0.300, 2.421, 1.067> <0.292, 2.407, 1.058> <0.299, 2.402, 1.054> 
		<0.293, 2.443, 1.055> <0.292, 2.438, 1.047> <0.285, 2.424, 1.038> <0.290, 2.421, 1.031> 
		<0.291, 2.455, 1.048> <0.290, 2.451, 1.040> <0.281, 2.443, 1.028> <0.287, 2.440, 1.021> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.306, 2.396, 1.073> <0.320, 2.386, 1.065> <0.345, 2.378, 1.053> <0.363, 2.383, 1.048> 
		<0.299, 2.402, 1.054> <0.313, 2.392, 1.046> <0.337, 2.385, 1.032> <0.355, 2.390, 1.026> 
		<0.290, 2.421, 1.031> <0.302, 2.416, 1.017> <0.326, 2.409, 1.002> <0.345, 2.412, 1.000> 
		<0.287, 2.440, 1.021> <0.299, 2.435, 1.007> <0.322, 2.430, 0.991> <0.341, 2.433, 0.989> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.363, 2.383, 1.048> <0.373, 2.386, 1.045> <0.383, 2.410, 1.049> <0.375, 2.416, 1.053> 
		<0.355, 2.390, 1.026> <0.364, 2.392, 1.024> <0.377, 2.414, 1.034> <0.370, 2.420, 1.039> 
		<0.345, 2.412, 1.000> <0.355, 2.413, 0.999> <0.369, 2.432, 1.013> <0.363, 2.435, 1.021> 
		<0.341, 2.433, 0.989> <0.351, 2.434, 0.988> <0.366, 2.446, 1.005> <0.360, 2.449, 1.013> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.375, 2.416, 1.053> <0.359, 2.429, 1.063> <0.328, 2.425, 1.074> <0.307, 2.429, 1.083> 
		<0.370, 2.420, 1.039> <0.354, 2.433, 1.048> <0.323, 2.429, 1.062> <0.303, 2.433, 1.071> 
		<0.363, 2.435, 1.021> <0.350, 2.442, 1.038> <0.317, 2.443, 1.045> <0.297, 2.445, 1.056> 
		<0.360, 2.449, 1.013> <0.347, 2.456, 1.030> <0.315, 2.454, 1.039> <0.295, 2.457, 1.050> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.321, 2.432, 1.127> <0.324, 2.424, 1.131> <0.323, 2.409, 1.140> <0.332, 2.405, 1.139> 
		<0.316, 2.425, 1.116> <0.320, 2.417, 1.119> <0.317, 2.399, 1.122> <0.325, 2.394, 1.122> 
		<0.309, 2.422, 1.096> <0.309, 2.413, 1.093> <0.307, 2.395, 1.097> <0.314, 2.390, 1.093> 
		<0.304, 2.426, 1.083> <0.305, 2.417, 1.080> <0.299, 2.401, 1.078> <0.306, 2.396, 1.073> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.332, 2.405, 1.139> <0.348, 2.396, 1.138> <0.375, 2.388, 1.132> <0.391, 2.393, 1.123> 
		<0.325, 2.394, 1.122> <0.341, 2.385, 1.121> <0.368, 2.376, 1.112> <0.384, 2.381, 1.103> 
		<0.314, 2.390, 1.093> <0.327, 2.380, 1.084> <0.353, 2.372, 1.075> <0.371, 2.377, 1.070> 
		<0.306, 2.396, 1.073> <0.320, 2.386, 1.065> <0.345, 2.378, 1.053> <0.363, 2.383, 1.048> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.391, 2.393, 1.123> <0.400, 2.395, 1.118> <0.404, 2.417, 1.104> <0.395, 2.422, 1.104> 
		<0.384, 2.381, 1.103> <0.393, 2.383, 1.098> <0.398, 2.409, 1.090> <0.389, 2.414, 1.090> 
		<0.371, 2.377, 1.070> <0.381, 2.379, 1.067> <0.388, 2.405, 1.063> <0.381, 2.411, 1.068> 
		<0.363, 2.383, 1.048> <0.373, 2.386, 1.045> <0.383, 2.410, 1.049> <0.375, 2.416, 1.053> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.395, 2.422, 1.104> <0.375, 2.434, 1.104> <0.345, 2.431, 1.118> <0.323, 2.434, 1.125> 
		<0.389, 2.414, 1.090> <0.370, 2.426, 1.091> <0.340, 2.424, 1.107> <0.319, 2.428, 1.114> 
		<0.381, 2.411, 1.068> <0.365, 2.424, 1.078> <0.332, 2.421, 1.086> <0.312, 2.425, 1.095> 
		<0.375, 2.416, 1.053> <0.359, 2.429, 1.063> <0.328, 2.425, 1.074> <0.307, 2.429, 1.083> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.332, 2.469, 1.154> <0.337, 2.466, 1.162> <0.339, 2.462, 1.178> <0.348, 2.461, 1.180> 
		<0.330, 2.455, 1.151> <0.335, 2.453, 1.158> <0.337, 2.442, 1.173> <0.346, 2.440, 1.175> 
		<0.325, 2.439, 1.139> <0.329, 2.431, 1.142> <0.330, 2.420, 1.157> <0.338, 2.415, 1.157> 
		<0.321, 2.432, 1.127> <0.324, 2.424, 1.131> <0.323, 2.409, 1.140> <0.332, 2.405, 1.139> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.348, 2.461, 1.180> <0.367, 2.458, 1.183> <0.395, 2.455, 1.180> <0.410, 2.456, 1.169> 
		<0.346, 2.440, 1.175> <0.364, 2.437, 1.178> <0.393, 2.432, 1.174> <0.408, 2.433, 1.163> 
		<0.338, 2.415, 1.157> <0.355, 2.406, 1.156> <0.383, 2.400, 1.151> <0.399, 2.405, 1.142> 
		<0.332, 2.405, 1.139> <0.348, 2.396, 1.138> <0.375, 2.388, 1.132> <0.391, 2.393, 1.123> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.410, 2.456, 1.169> <0.419, 2.457, 1.162> <0.417, 2.463, 1.137> <0.407, 2.465, 1.135> 
		<0.408, 2.433, 1.163> <0.416, 2.434, 1.157> <0.416, 2.448, 1.133> <0.405, 2.449, 1.131> 
		<0.399, 2.405, 1.142> <0.408, 2.407, 1.137> <0.409, 2.425, 1.117> <0.400, 2.430, 1.117> 
		<0.391, 2.393, 1.123> <0.400, 2.395, 1.118> <0.404, 2.417, 1.104> <0.395, 2.422, 1.104> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.407, 2.465, 1.135> <0.386, 2.469, 1.130> <0.356, 2.468, 1.146> <0.334, 2.470, 1.150> 
		<0.405, 2.449, 1.131> <0.384, 2.453, 1.126> <0.354, 2.455, 1.142> <0.332, 2.457, 1.147> 
		<0.400, 2.430, 1.117> <0.381, 2.442, 1.117> <0.349, 2.437, 1.129> <0.328, 2.441, 1.136> 
		<0.395, 2.422, 1.104> <0.375, 2.434, 1.104> <0.345, 2.431, 1.118> <0.323, 2.434, 1.125> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.331, 2.516, 1.149> <0.335, 2.521, 1.155> <0.337, 2.529, 1.170> <0.346, 2.531, 1.171> 
		<0.333, 2.504, 1.155> <0.338, 2.508, 1.162> <0.341, 2.510, 1.180> <0.350, 2.513, 1.181> 
		<0.333, 2.483, 1.158> <0.338, 2.480, 1.165> <0.341, 2.483, 1.183> <0.351, 2.481, 1.185> 
		<0.332, 2.469, 1.154> <0.337, 2.466, 1.162> <0.339, 2.462, 1.178> <0.348, 2.461, 1.180> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.346, 2.531, 1.171> <0.364, 2.536, 1.174> <0.393, 2.539, 1.170> <0.408, 2.536, 1.159> 
		<0.350, 2.513, 1.181> <0.368, 2.517, 1.184> <0.397, 2.518, 1.181> <0.412, 2.515, 1.171> 
		<0.351, 2.481, 1.185> <0.369, 2.478, 1.189> <0.398, 2.478, 1.186> <0.413, 2.480, 1.175> 
		<0.348, 2.461, 1.180> <0.367, 2.458, 1.183> <0.395, 2.455, 1.180> <0.410, 2.456, 1.169> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.408, 2.536, 1.159> <0.416, 2.535, 1.153> <0.416, 2.522, 1.130> <0.406, 2.519, 1.128> 
		<0.412, 2.515, 1.171> <0.420, 2.513, 1.164> <0.418, 2.508, 1.138> <0.408, 2.505, 1.136> 
		<0.413, 2.480, 1.175> <0.421, 2.480, 1.168> <0.419, 2.479, 1.141> <0.409, 2.481, 1.139> 
		<0.410, 2.456, 1.169> <0.419, 2.457, 1.162> <0.417, 2.463, 1.137> <0.407, 2.465, 1.135> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.406, 2.519, 1.128> <0.384, 2.513, 1.124> <0.354, 2.516, 1.140> <0.332, 2.514, 1.145> 
		<0.408, 2.505, 1.136> <0.387, 2.499, 1.132> <0.357, 2.504, 1.146> <0.335, 2.503, 1.151> 
		<0.409, 2.481, 1.139> <0.387, 2.485, 1.134> <0.357, 2.481, 1.149> <0.335, 2.483, 1.154> 
		<0.407, 2.465, 1.135> <0.386, 2.469, 1.130> <0.356, 2.468, 1.146> <0.334, 2.470, 1.150> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.318, 2.545, 1.114> <0.320, 2.554, 1.115> <0.319, 2.570, 1.121> <0.327, 2.575, 1.119> 
		<0.323, 2.541, 1.126> <0.325, 2.550, 1.128> <0.326, 2.564, 1.140> <0.334, 2.569, 1.138> 
		<0.328, 2.528, 1.142> <0.333, 2.533, 1.149> <0.334, 2.547, 1.160> <0.343, 2.550, 1.162> 
		<0.331, 2.516, 1.149> <0.335, 2.521, 1.155> <0.337, 2.529, 1.170> <0.346, 2.531, 1.171> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.327, 2.575, 1.119> <0.343, 2.584, 1.116> <0.370, 2.591, 1.108> <0.386, 2.586, 1.100> 
		<0.334, 2.569, 1.138> <0.350, 2.579, 1.135> <0.378, 2.585, 1.129> <0.394, 2.579, 1.122> 
		<0.343, 2.550, 1.162> <0.361, 2.554, 1.164> <0.389, 2.560, 1.159> <0.404, 2.557, 1.148> 
		<0.346, 2.531, 1.171> <0.364, 2.536, 1.174> <0.393, 2.539, 1.170> <0.408, 2.536, 1.159> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.386, 2.586, 1.100> <0.395, 2.583, 1.095> <0.400, 2.559, 1.087> <0.391, 2.553, 1.088> 
		<0.394, 2.579, 1.122> <0.403, 2.576, 1.117> <0.405, 2.554, 1.101> <0.397, 2.549, 1.103> 
		<0.404, 2.557, 1.148> <0.413, 2.556, 1.142> <0.413, 2.536, 1.123> <0.403, 2.534, 1.121> 
		<0.408, 2.536, 1.159> <0.416, 2.535, 1.153> <0.416, 2.522, 1.130> <0.406, 2.519, 1.128> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.391, 2.553, 1.088> <0.372, 2.541, 1.091> <0.341, 2.545, 1.105> <0.320, 2.542, 1.112> 
		<0.397, 2.549, 1.103> <0.378, 2.536, 1.106> <0.346, 2.542, 1.117> <0.325, 2.539, 1.124> 
		<0.403, 2.534, 1.121> <0.382, 2.527, 1.117> <0.352, 2.528, 1.134> <0.330, 2.526, 1.139> 
		<0.406, 2.519, 1.128> <0.384, 2.513, 1.124> <0.354, 2.516, 1.140> <0.332, 2.514, 1.145> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.301, 2.540, 1.070> <0.301, 2.548, 1.065> <0.295, 2.562, 1.058> <0.302, 2.566, 1.053> 
		<0.305, 2.547, 1.081> <0.306, 2.555, 1.076> <0.302, 2.573, 1.076> <0.308, 2.577, 1.070> 
		<0.313, 2.549, 1.101> <0.316, 2.558, 1.102> <0.312, 2.576, 1.101> <0.320, 2.581, 1.100> 
		<0.318, 2.545, 1.114> <0.320, 2.554, 1.115> <0.319, 2.570, 1.121> <0.327, 2.575, 1.119> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.302, 2.566, 1.053> <0.315, 2.575, 1.043> <0.340, 2.581, 1.029> <0.357, 2.576, 1.025> 
		<0.308, 2.577, 1.070> <0.322, 2.585, 1.060> <0.347, 2.593, 1.049> <0.365, 2.588, 1.045> 
		<0.320, 2.581, 1.100> <0.336, 2.590, 1.096> <0.362, 2.598, 1.086> <0.378, 2.592, 1.078> 
		<0.327, 2.575, 1.119> <0.343, 2.584, 1.116> <0.370, 2.591, 1.108> <0.386, 2.586, 1.100> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.357, 2.576, 1.025> <0.367, 2.573, 1.023> <0.379, 2.552, 1.032> <0.372, 2.546, 1.038> 
		<0.365, 2.588, 1.045> <0.375, 2.585, 1.043> <0.384, 2.560, 1.045> <0.377, 2.554, 1.051> 
		<0.378, 2.592, 1.078> <0.387, 2.589, 1.074> <0.394, 2.563, 1.072> <0.385, 2.557, 1.073> 
		<0.386, 2.586, 1.100> <0.395, 2.583, 1.095> <0.400, 2.559, 1.087> <0.391, 2.553, 1.088> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.372, 2.546, 1.038> <0.356, 2.535, 1.050> <0.324, 2.540, 1.060> <0.304, 2.537, 1.070> 
		<0.377, 2.554, 1.051> <0.362, 2.543, 1.064> <0.329, 2.546, 1.071> <0.308, 2.543, 1.081> 
		<0.385, 2.557, 1.073> <0.367, 2.545, 1.077> <0.337, 2.549, 1.092> <0.316, 2.546, 1.099> 
		<0.391, 2.553, 1.088> <0.372, 2.541, 1.091> <0.341, 2.545, 1.105> <0.320, 2.542, 1.112> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.290, 2.502, 1.043> <0.288, 2.505, 1.034> <0.279, 2.509, 1.020> <0.285, 2.510, 1.012> 
		<0.291, 2.516, 1.046> <0.290, 2.518, 1.037> <0.282, 2.530, 1.025> <0.287, 2.531, 1.018> 
		<0.296, 2.533, 1.058> <0.296, 2.541, 1.053> <0.288, 2.552, 1.041> <0.295, 2.556, 1.036> 
		<0.301, 2.540, 1.070> <0.301, 2.548, 1.065> <0.295, 2.562, 1.058> <0.302, 2.566, 1.053> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.285, 2.510, 1.012> <0.296, 2.513, 0.998> <0.320, 2.515, 0.981> <0.339, 2.513, 0.979> 
		<0.287, 2.531, 1.018> <0.299, 2.533, 1.003> <0.322, 2.538, 0.987> <0.341, 2.536, 0.985> 
		<0.295, 2.556, 1.036> <0.308, 2.564, 1.025> <0.332, 2.569, 1.010> <0.350, 2.564, 1.006> 
		<0.302, 2.566, 1.053> <0.315, 2.575, 1.043> <0.340, 2.581, 1.029> <0.357, 2.576, 1.025> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.339, 2.513, 0.979> <0.349, 2.512, 0.978> <0.365, 2.505, 0.998> <0.359, 2.503, 1.007> 
		<0.341, 2.536, 0.985> <0.352, 2.535, 0.984> <0.367, 2.521, 1.002> <0.361, 2.519, 1.011> 
		<0.350, 2.564, 1.006> <0.360, 2.561, 1.003> <0.373, 2.544, 1.018> <0.366, 2.538, 1.024> 
		<0.357, 2.576, 1.025> <0.367, 2.573, 1.023> <0.379, 2.552, 1.032> <0.372, 2.546, 1.038> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.359, 2.503, 1.007> <0.346, 2.500, 1.025> <0.313, 2.502, 1.033> <0.294, 2.501, 1.044> 
		<0.361, 2.519, 1.011> <0.348, 2.516, 1.029> <0.315, 2.515, 1.036> <0.295, 2.514, 1.048> 
		<0.366, 2.538, 1.024> <0.351, 2.527, 1.037> <0.320, 2.533, 1.049> <0.300, 2.530, 1.059> 
		<0.372, 2.546, 1.038> <0.356, 2.535, 1.050> <0.324, 2.540, 1.060> <0.304, 2.537, 1.070> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.291, 2.455, 1.048> <0.290, 2.451, 1.040> <0.281, 2.443, 1.028> <0.287, 2.440, 1.021> 
		<0.289, 2.468, 1.042> <0.288, 2.463, 1.033> <0.278, 2.461, 1.018> <0.284, 2.458, 1.011> 
		<0.288, 2.489, 1.039> <0.287, 2.491, 1.030> <0.277, 2.489, 1.015> <0.283, 2.490, 1.007> 
		<0.290, 2.502, 1.043> <0.288, 2.505, 1.034> <0.279, 2.509, 1.020> <0.285, 2.510, 1.012> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.287, 2.440, 1.021> <0.299, 2.435, 1.007> <0.322, 2.430, 0.991> <0.341, 2.433, 0.989> 
		<0.284, 2.458, 1.011> <0.295, 2.453, 0.997> <0.318, 2.451, 0.980> <0.337, 2.454, 0.978> 
		<0.283, 2.490, 1.007> <0.294, 2.492, 0.992> <0.317, 2.491, 0.975> <0.336, 2.489, 0.973> 
		<0.285, 2.510, 1.012> <0.296, 2.513, 0.998> <0.320, 2.515, 0.981> <0.339, 2.513, 0.979> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.341, 2.433, 0.989> <0.351, 2.434, 0.988> <0.366, 2.446, 1.005> <0.360, 2.449, 1.013> 
		<0.337, 2.454, 0.978> <0.347, 2.455, 0.976> <0.364, 2.460, 0.997> <0.358, 2.464, 1.005> 
		<0.336, 2.489, 0.973> <0.346, 2.488, 0.972> <0.363, 2.489, 0.994> <0.357, 2.488, 1.003> 
		<0.339, 2.513, 0.979> <0.349, 2.512, 0.978> <0.365, 2.505, 0.998> <0.359, 2.503, 1.007> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.360, 2.449, 1.013> <0.347, 2.456, 1.030> <0.315, 2.454, 1.039> <0.295, 2.457, 1.050> 
		<0.358, 2.464, 1.005> <0.345, 2.470, 1.023> <0.312, 2.466, 1.032> <0.293, 2.468, 1.043> 
		<0.357, 2.488, 1.003> <0.344, 2.484, 1.021> <0.312, 2.489, 1.030> <0.292, 2.488, 1.041> 
		<0.359, 2.503, 1.007> <0.346, 2.500, 1.025> <0.313, 2.502, 1.033> <0.294, 2.501, 1.044> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.121, 2.462, 1.186> <-0.121, 2.452, 1.186> <-0.124, 2.437, 1.178> <-0.122, 2.430, 1.184> 
		<-0.108, 2.462, 1.181> <-0.108, 2.452, 1.181> <-0.104, 2.437, 1.171> <-0.102, 2.430, 1.177> 
		<-0.088, 2.469, 1.177> <-0.082, 2.462, 1.175> <-0.079, 2.447, 1.165> <-0.073, 2.441, 1.170> 
		<-0.078, 2.478, 1.176> <-0.072, 2.471, 1.174> <-0.063, 2.461, 1.163> <-0.058, 2.455, 1.168> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.122, 2.430, 1.184> <-0.118, 2.416, 1.196> <-0.110, 2.401, 1.220> <-0.104, 2.402, 1.237> 
		<-0.102, 2.430, 1.177> <-0.098, 2.416, 1.189> <-0.087, 2.401, 1.211> <-0.081, 2.401, 1.229> 
		<-0.073, 2.441, 1.170> <-0.062, 2.430, 1.180> <-0.051, 2.415, 1.202> <-0.048, 2.414, 1.221> 
		<-0.058, 2.455, 1.168> <-0.046, 2.444, 1.179> <-0.033, 2.431, 1.201> <-0.030, 2.430, 1.220> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.104, 2.402, 1.237> <-0.100, 2.402, 1.247> <-0.095, 2.424, 1.260> <-0.097, 2.432, 1.254> 
		<-0.081, 2.401, 1.229> <-0.077, 2.402, 1.239> <-0.079, 2.424, 1.255> <-0.081, 2.432, 1.249> 
		<-0.048, 2.414, 1.221> <-0.047, 2.413, 1.232> <-0.053, 2.434, 1.248> <-0.059, 2.440, 1.243> 
		<-0.030, 2.430, 1.220> <-0.029, 2.429, 1.230> <-0.041, 2.445, 1.247> <-0.047, 2.451, 1.242> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.097, 2.432, 1.254> <-0.101, 2.450, 1.241> <-0.113, 2.454, 1.209> <-0.120, 2.464, 1.190> 
		<-0.081, 2.432, 1.249> <-0.086, 2.449, 1.235> <-0.100, 2.454, 1.204> <-0.107, 2.464, 1.185> 
		<-0.059, 2.440, 1.243> <-0.073, 2.454, 1.232> <-0.079, 2.462, 1.199> <-0.089, 2.471, 1.181> 
		<-0.047, 2.451, 1.242> <-0.061, 2.465, 1.231> <-0.069, 2.471, 1.198> <-0.079, 2.480, 1.180> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.160, 2.480, 1.206> <-0.166, 2.474, 1.208> <-0.180, 2.464, 1.206> <-0.181, 2.458, 1.213> 
		<-0.152, 2.470, 1.200> <-0.158, 2.464, 1.202> <-0.167, 2.449, 1.197> <-0.168, 2.443, 1.205> 
		<-0.134, 2.462, 1.191> <-0.135, 2.453, 1.190> <-0.144, 2.438, 1.186> <-0.142, 2.431, 1.192> 
		<-0.121, 2.462, 1.186> <-0.121, 2.452, 1.186> <-0.124, 2.437, 1.178> <-0.122, 2.430, 1.184> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.181, 2.458, 1.213> <-0.183, 2.447, 1.229> <-0.180, 2.434, 1.254> <-0.170, 2.433, 1.270> 
		<-0.168, 2.443, 1.205> <-0.171, 2.432, 1.220> <-0.166, 2.418, 1.244> <-0.156, 2.416, 1.260> 
		<-0.142, 2.431, 1.192> <-0.138, 2.417, 1.204> <-0.133, 2.402, 1.228> <-0.126, 2.402, 1.246> 
		<-0.122, 2.430, 1.184> <-0.118, 2.416, 1.196> <-0.110, 2.401, 1.220> <-0.104, 2.402, 1.237> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.170, 2.433, 1.270> <-0.165, 2.432, 1.279> <-0.144, 2.447, 1.285> <-0.142, 2.453, 1.276> 
		<-0.156, 2.416, 1.260> <-0.150, 2.416, 1.269> <-0.134, 2.436, 1.278> <-0.132, 2.442, 1.270> 
		<-0.126, 2.402, 1.246> <-0.123, 2.403, 1.256> <-0.110, 2.424, 1.266> <-0.112, 2.433, 1.260> 
		<-0.104, 2.402, 1.237> <-0.100, 2.402, 1.247> <-0.095, 2.424, 1.260> <-0.097, 2.432, 1.254> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.142, 2.453, 1.276> <-0.138, 2.467, 1.259> <-0.152, 2.473, 1.229> <-0.157, 2.481, 1.208> 
		<-0.132, 2.442, 1.270> <-0.128, 2.456, 1.252> <-0.144, 2.464, 1.223> <-0.149, 2.472, 1.203> 
		<-0.112, 2.433, 1.260> <-0.117, 2.450, 1.246> <-0.125, 2.455, 1.214> <-0.132, 2.464, 1.194> 
		<-0.097, 2.432, 1.254> <-0.101, 2.450, 1.241> <-0.113, 2.454, 1.209> <-0.120, 2.464, 1.190> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.172, 2.523, 1.223> <-0.180, 2.523, 1.227> <-0.197, 2.524, 1.230> <-0.199, 2.522, 1.239> 
		<-0.174, 2.509, 1.219> <-0.182, 2.509, 1.224> <-0.199, 2.503, 1.225> <-0.202, 2.501, 1.234> 
		<-0.168, 2.490, 1.212> <-0.175, 2.483, 1.214> <-0.192, 2.478, 1.215> <-0.193, 2.473, 1.222> 
		<-0.160, 2.480, 1.206> <-0.166, 2.474, 1.208> <-0.180, 2.464, 1.206> <-0.181, 2.458, 1.213> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.199, 2.522, 1.239> <-0.204, 2.518, 1.257> <-0.202, 2.510, 1.285> <-0.191, 2.505, 1.299> 
		<-0.202, 2.501, 1.234> <-0.206, 2.497, 1.251> <-0.205, 2.487, 1.279> <-0.193, 2.482, 1.293> 
		<-0.193, 2.473, 1.222> <-0.196, 2.462, 1.237> <-0.194, 2.451, 1.264> <-0.184, 2.450, 1.280> 
		<-0.181, 2.458, 1.213> <-0.183, 2.447, 1.229> <-0.180, 2.434, 1.254> <-0.170, 2.433, 1.270> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.191, 2.505, 1.299> <-0.185, 2.503, 1.307> <-0.159, 2.500, 1.306> <-0.156, 2.502, 1.296> 
		<-0.193, 2.482, 1.293> <-0.187, 2.479, 1.301> <-0.161, 2.484, 1.302> <-0.158, 2.487, 1.292> 
		<-0.184, 2.450, 1.280> <-0.179, 2.449, 1.289> <-0.153, 2.458, 1.291> <-0.151, 2.465, 1.283> 
		<-0.170, 2.433, 1.270> <-0.165, 2.432, 1.279> <-0.144, 2.447, 1.285> <-0.142, 2.453, 1.276> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.156, 2.502, 1.296> <-0.149, 2.507, 1.275> <-0.165, 2.516, 1.246> <-0.168, 2.522, 1.224> 
		<-0.158, 2.487, 1.292> <-0.151, 2.491, 1.271> <-0.166, 2.503, 1.242> <-0.170, 2.509, 1.221> 
		<-0.151, 2.465, 1.283> <-0.148, 2.478, 1.266> <-0.160, 2.482, 1.234> <-0.165, 2.491, 1.214> 
		<-0.142, 2.453, 1.276> <-0.138, 2.467, 1.259> <-0.152, 2.473, 1.229> <-0.157, 2.481, 1.208> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.150, 2.565, 1.227> <-0.155, 2.571, 1.233> <-0.166, 2.583, 1.236> <-0.166, 2.584, 1.246> 
		<-0.161, 2.555, 1.228> <-0.166, 2.561, 1.234> <-0.182, 2.569, 1.238> <-0.182, 2.570, 1.247> 
		<-0.171, 2.536, 1.226> <-0.179, 2.536, 1.231> <-0.195, 2.544, 1.235> <-0.197, 2.542, 1.244> 
		<-0.172, 2.523, 1.223> <-0.180, 2.523, 1.227> <-0.197, 2.524, 1.230> <-0.199, 2.522, 1.239> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.166, 2.584, 1.246> <-0.167, 2.587, 1.264> <-0.163, 2.585, 1.293> <-0.154, 2.576, 1.307> 
		<-0.182, 2.570, 1.247> <-0.183, 2.573, 1.266> <-0.181, 2.569, 1.294> <-0.172, 2.560, 1.308> 
		<-0.197, 2.542, 1.244> <-0.201, 2.538, 1.262> <-0.199, 2.534, 1.291> <-0.188, 2.529, 1.305> 
		<-0.199, 2.522, 1.239> <-0.204, 2.518, 1.257> <-0.202, 2.510, 1.285> <-0.191, 2.505, 1.299> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.154, 2.576, 1.307> <-0.149, 2.572, 1.315> <-0.131, 2.552, 1.311> <-0.131, 2.550, 1.301> 
		<-0.172, 2.560, 1.308> <-0.166, 2.556, 1.316> <-0.144, 2.541, 1.313> <-0.143, 2.539, 1.302> 
		<-0.188, 2.529, 1.305> <-0.182, 2.526, 1.313> <-0.157, 2.516, 1.310> <-0.154, 2.518, 1.300> 
		<-0.191, 2.505, 1.299> <-0.185, 2.503, 1.307> <-0.159, 2.500, 1.306> <-0.156, 2.502, 1.296> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.131, 2.550, 1.301> <-0.129, 2.546, 1.279> <-0.142, 2.558, 1.250> <-0.147, 2.562, 1.229> 
		<-0.143, 2.539, 1.302> <-0.141, 2.535, 1.280> <-0.152, 2.549, 1.251> <-0.157, 2.553, 1.230> 
		<-0.154, 2.518, 1.300> <-0.148, 2.523, 1.279> <-0.163, 2.529, 1.249> <-0.167, 2.535, 1.228> 
		<-0.156, 2.502, 1.296> <-0.149, 2.507, 1.275> <-0.165, 2.516, 1.246> <-0.168, 2.522, 1.224> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.107, 2.581, 1.217> <-0.106, 2.590, 1.221> <-0.105, 2.607, 1.221> <-0.102, 2.609, 1.230> 
		<-0.120, 2.581, 1.221> <-0.119, 2.590, 1.225> <-0.125, 2.607, 1.229> <-0.122, 2.610, 1.237> 
		<-0.140, 2.574, 1.226> <-0.145, 2.580, 1.232> <-0.150, 2.597, 1.235> <-0.151, 2.599, 1.244> 
		<-0.150, 2.565, 1.227> <-0.155, 2.571, 1.233> <-0.166, 2.583, 1.236> <-0.166, 2.584, 1.246> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.102, 2.609, 1.230> <-0.095, 2.615, 1.247> <-0.086, 2.615, 1.274> <-0.080, 2.605, 1.289> 
		<-0.122, 2.610, 1.237> <-0.115, 2.615, 1.254> <-0.108, 2.615, 1.282> <-0.103, 2.605, 1.297> 
		<-0.151, 2.599, 1.244> <-0.151, 2.601, 1.263> <-0.145, 2.601, 1.291> <-0.136, 2.593, 1.305> 
		<-0.166, 2.584, 1.246> <-0.167, 2.587, 1.264> <-0.163, 2.585, 1.293> <-0.154, 2.576, 1.307> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.080, 2.605, 1.289> <-0.077, 2.599, 1.297> <-0.078, 2.573, 1.298> <-0.081, 2.569, 1.289> 
		<-0.103, 2.605, 1.297> <-0.100, 2.599, 1.306> <-0.093, 2.573, 1.304> <-0.096, 2.570, 1.295> 
		<-0.136, 2.593, 1.305> <-0.131, 2.588, 1.313> <-0.119, 2.563, 1.310> <-0.118, 2.561, 1.300> 
		<-0.154, 2.576, 1.307> <-0.149, 2.572, 1.315> <-0.131, 2.552, 1.311> <-0.131, 2.550, 1.301> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.081, 2.569, 1.289> <-0.088, 2.562, 1.269> <-0.099, 2.575, 1.240> <-0.106, 2.577, 1.219> 
		<-0.096, 2.570, 1.295> <-0.104, 2.562, 1.275> <-0.112, 2.575, 1.244> <-0.119, 2.578, 1.223> 
		<-0.118, 2.561, 1.300> <-0.117, 2.557, 1.278> <-0.132, 2.567, 1.249> <-0.137, 2.571, 1.228> 
		<-0.131, 2.550, 1.301> <-0.129, 2.546, 1.279> <-0.142, 2.558, 1.250> <-0.147, 2.562, 1.229> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.068, 2.563, 1.197> <-0.061, 2.568, 1.198> <-0.049, 2.580, 1.194> <-0.043, 2.582, 1.201> 
		<-0.076, 2.573, 1.203> <-0.069, 2.578, 1.204> <-0.062, 2.595, 1.203> <-0.056, 2.597, 1.209> 
		<-0.094, 2.581, 1.212> <-0.092, 2.589, 1.216> <-0.085, 2.606, 1.214> <-0.082, 2.609, 1.222> 
		<-0.107, 2.581, 1.217> <-0.106, 2.590, 1.221> <-0.105, 2.607, 1.221> <-0.102, 2.609, 1.230> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.043, 2.582, 1.201> <-0.030, 2.584, 1.214> <-0.016, 2.582, 1.239> <-0.014, 2.573, 1.256> 
		<-0.056, 2.597, 1.209> <-0.043, 2.599, 1.223> <-0.030, 2.599, 1.249> <-0.028, 2.590, 1.266> 
		<-0.082, 2.609, 1.222> <-0.075, 2.614, 1.239> <-0.063, 2.614, 1.266> <-0.058, 2.604, 1.281> 
		<-0.102, 2.609, 1.230> <-0.095, 2.615, 1.247> <-0.086, 2.615, 1.274> <-0.080, 2.605, 1.289> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.014, 2.573, 1.256> <-0.013, 2.569, 1.265> <-0.029, 2.550, 1.274> <-0.036, 2.548, 1.267> 
		<-0.028, 2.590, 1.266> <-0.027, 2.585, 1.275> <-0.038, 2.561, 1.281> <-0.046, 2.560, 1.273> 
		<-0.058, 2.604, 1.281> <-0.055, 2.598, 1.289> <-0.062, 2.573, 1.293> <-0.066, 2.569, 1.283> 
		<-0.080, 2.605, 1.289> <-0.077, 2.599, 1.297> <-0.078, 2.573, 1.298> <-0.081, 2.569, 1.289> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.036, 2.548, 1.267> <-0.052, 2.544, 1.251> <-0.059, 2.556, 1.220> <-0.069, 2.560, 1.200> 
		<-0.046, 2.560, 1.273> <-0.061, 2.556, 1.258> <-0.067, 2.566, 1.226> <-0.077, 2.569, 1.206> 
		<-0.066, 2.569, 1.283> <-0.073, 2.561, 1.264> <-0.086, 2.575, 1.235> <-0.094, 2.577, 1.214> 
		<-0.081, 2.569, 1.289> <-0.088, 2.562, 1.269> <-0.099, 2.575, 1.240> <-0.106, 2.577, 1.219> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.056, 2.520, 1.180> <-0.047, 2.519, 1.179> <-0.032, 2.520, 1.170> <-0.025, 2.518, 1.175> 
		<-0.054, 2.534, 1.184> <-0.045, 2.533, 1.182> <-0.030, 2.541, 1.175> <-0.022, 2.538, 1.180> 
		<-0.060, 2.553, 1.191> <-0.052, 2.559, 1.192> <-0.037, 2.566, 1.185> <-0.031, 2.567, 1.192> 
		<-0.068, 2.563, 1.197> <-0.061, 2.568, 1.198> <-0.049, 2.580, 1.194> <-0.043, 2.582, 1.201> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.025, 2.518, 1.175> <-0.010, 2.513, 1.186> <0.006, 2.506, 1.209> <0.007, 2.501, 1.227> 
		<-0.022, 2.538, 1.180> <-0.008, 2.534, 1.191> <0.009, 2.529, 1.215> <0.010, 2.524, 1.233> 
		<-0.031, 2.567, 1.192> <-0.018, 2.569, 1.206> <-0.001, 2.565, 1.229> <0.000, 2.556, 1.246> 
		<-0.043, 2.582, 1.201> <-0.030, 2.584, 1.214> <-0.016, 2.582, 1.239> <-0.014, 2.573, 1.256> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.007, 2.501, 1.227> <0.007, 2.498, 1.237> <-0.013, 2.497, 1.253> <-0.022, 2.499, 1.247> 
		<0.010, 2.524, 1.233> <0.010, 2.522, 1.243> <-0.012, 2.513, 1.257> <-0.020, 2.515, 1.251> 
		<0.000, 2.556, 1.246> <0.001, 2.552, 1.255> <-0.019, 2.539, 1.267> <-0.026, 2.537, 1.260> 
		<-0.014, 2.573, 1.256> <-0.013, 2.569, 1.265> <-0.029, 2.550, 1.274> <-0.036, 2.548, 1.267> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.022, 2.499, 1.247> <-0.040, 2.504, 1.235> <-0.047, 2.513, 1.203> <-0.058, 2.519, 1.184> 
		<-0.020, 2.515, 1.251> <-0.039, 2.520, 1.239> <-0.046, 2.526, 1.206> <-0.056, 2.532, 1.187> 
		<-0.026, 2.537, 1.260> <-0.042, 2.533, 1.244> <-0.051, 2.547, 1.215> <-0.061, 2.550, 1.195> 
		<-0.036, 2.548, 1.267> <-0.052, 2.544, 1.251> <-0.059, 2.556, 1.220> <-0.069, 2.560, 1.200> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.078, 2.478, 1.176> <-0.072, 2.471, 1.174> <-0.063, 2.461, 1.163> <-0.058, 2.455, 1.168> 
		<-0.067, 2.488, 1.175> <-0.061, 2.481, 1.173> <-0.047, 2.475, 1.162> <-0.042, 2.469, 1.167> 
		<-0.057, 2.506, 1.177> <-0.048, 2.506, 1.175> <-0.034, 2.500, 1.165> <-0.027, 2.497, 1.170> 
		<-0.056, 2.520, 1.180> <-0.047, 2.519, 1.179> <-0.032, 2.520, 1.170> <-0.025, 2.518, 1.175> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.058, 2.455, 1.168> <-0.046, 2.444, 1.179> <-0.033, 2.431, 1.201> <-0.030, 2.430, 1.220> 
		<-0.042, 2.469, 1.167> <-0.031, 2.458, 1.177> <-0.015, 2.447, 1.199> <-0.012, 2.446, 1.218> 
		<-0.027, 2.497, 1.170> <-0.012, 2.493, 1.181> <0.004, 2.482, 1.203> <0.004, 2.478, 1.221> 
		<-0.025, 2.518, 1.175> <-0.010, 2.513, 1.186> <0.006, 2.506, 1.209> <0.007, 2.501, 1.227> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.030, 2.430, 1.220> <-0.029, 2.429, 1.230> <-0.041, 2.445, 1.247> <-0.047, 2.451, 1.242> 
		<-0.012, 2.446, 1.218> <-0.011, 2.445, 1.228> <-0.029, 2.455, 1.246> <-0.035, 2.462, 1.241> 
		<0.004, 2.478, 1.221> <0.005, 2.475, 1.232> <-0.015, 2.481, 1.249> <-0.024, 2.483, 1.243> 
		<0.007, 2.501, 1.227> <0.007, 2.498, 1.237> <-0.013, 2.497, 1.253> <-0.022, 2.499, 1.247> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.047, 2.451, 1.242> <-0.061, 2.465, 1.231> <-0.069, 2.471, 1.198> <-0.079, 2.480, 1.180> 
		<-0.035, 2.462, 1.241> <-0.049, 2.476, 1.230> <-0.059, 2.480, 1.198> <-0.069, 2.489, 1.179> 
		<-0.024, 2.483, 1.243> <-0.042, 2.489, 1.231> <-0.049, 2.500, 1.200> <-0.059, 2.506, 1.181> 
		<-0.022, 2.499, 1.247> <-0.040, 2.504, 1.235> <-0.047, 2.513, 1.203> <-0.058, 2.519, 1.184> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.341, 2.396, 0.640> <1.341, 2.387, 0.639> <1.338, 2.372, 0.632> <1.340, 2.365, 0.638> 
		<1.355, 2.396, 0.635> <1.354, 2.387, 0.634> <1.358, 2.372, 0.624> <1.360, 2.364, 0.630> 
		<1.374, 2.403, 0.630> <1.380, 2.397, 0.628> <1.383, 2.381, 0.618> <1.389, 2.376, 0.623> 
		<1.384, 2.413, 0.629> <1.390, 2.406, 0.627> <1.399, 2.395, 0.617> <1.404, 2.390, 0.622> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.340, 2.365, 0.638> <1.344, 2.351, 0.650> <1.352, 2.336, 0.673> <1.358, 2.336, 0.691> 
		<1.360, 2.364, 0.630> <1.364, 2.350, 0.642> <1.375, 2.335, 0.665> <1.381, 2.336, 0.683> 
		<1.389, 2.376, 0.623> <1.400, 2.364, 0.634> <1.411, 2.349, 0.656> <1.414, 2.348, 0.675> 
		<1.404, 2.390, 0.622> <1.416, 2.378, 0.632> <1.429, 2.366, 0.654> <1.432, 2.365, 0.673> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.358, 2.336, 0.691> <1.362, 2.337, 0.701> <1.367, 2.358, 0.714> <1.365, 2.367, 0.708> 
		<1.381, 2.336, 0.683> <1.385, 2.336, 0.693> <1.383, 2.358, 0.708> <1.381, 2.366, 0.702> 
		<1.414, 2.348, 0.675> <1.415, 2.348, 0.685> <1.409, 2.368, 0.702> <1.403, 2.375, 0.697> 
		<1.432, 2.365, 0.673> <1.433, 2.364, 0.683> <1.421, 2.379, 0.701> <1.415, 2.386, 0.696> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.365, 2.367, 0.708> <1.361, 2.384, 0.694> <1.349, 2.389, 0.663> <1.343, 2.399, 0.643> 
		<1.381, 2.366, 0.702> <1.376, 2.384, 0.689> <1.362, 2.389, 0.658> <1.355, 2.398, 0.639> 
		<1.403, 2.375, 0.697> <1.389, 2.389, 0.685> <1.383, 2.397, 0.653> <1.374, 2.405, 0.634> 
		<1.415, 2.386, 0.696> <1.401, 2.400, 0.684> <1.393, 2.406, 0.652> <1.384, 2.414, 0.633> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.302, 2.415, 0.659> <1.296, 2.408, 0.661> <1.282, 2.398, 0.659> <1.281, 2.393, 0.667> 
		<1.310, 2.405, 0.653> <1.304, 2.398, 0.656> <1.295, 2.383, 0.650> <1.294, 2.378, 0.658> 
		<1.328, 2.397, 0.645> <1.327, 2.387, 0.644> <1.318, 2.372, 0.639> <1.320, 2.365, 0.645> 
		<1.341, 2.396, 0.640> <1.341, 2.387, 0.639> <1.338, 2.372, 0.632> <1.340, 2.365, 0.638> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.281, 2.393, 0.667> <1.279, 2.381, 0.682> <1.282, 2.369, 0.708> <1.292, 2.368, 0.724> 
		<1.294, 2.378, 0.658> <1.291, 2.367, 0.673> <1.296, 2.352, 0.698> <1.306, 2.351, 0.714> 
		<1.320, 2.365, 0.645> <1.324, 2.351, 0.657> <1.329, 2.336, 0.681> <1.336, 2.337, 0.699> 
		<1.340, 2.365, 0.638> <1.344, 2.351, 0.650> <1.352, 2.336, 0.673> <1.358, 2.336, 0.691> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.292, 2.368, 0.724> <1.298, 2.367, 0.733> <1.318, 2.381, 0.738> <1.320, 2.388, 0.730> 
		<1.306, 2.351, 0.714> <1.312, 2.350, 0.723> <1.328, 2.370, 0.731> <1.330, 2.377, 0.723> 
		<1.336, 2.337, 0.699> <1.339, 2.337, 0.709> <1.352, 2.359, 0.720> <1.350, 2.367, 0.713> 
		<1.358, 2.336, 0.691> <1.362, 2.337, 0.701> <1.367, 2.358, 0.714> <1.365, 2.367, 0.708> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.320, 2.388, 0.730> <1.324, 2.402, 0.712> <1.310, 2.408, 0.682> <1.305, 2.416, 0.662> 
		<1.330, 2.377, 0.723> <1.334, 2.390, 0.706> <1.318, 2.398, 0.677> <1.313, 2.407, 0.656> 
		<1.350, 2.367, 0.713> <1.345, 2.385, 0.700> <1.337, 2.389, 0.667> <1.330, 2.399, 0.648> 
		<1.365, 2.367, 0.708> <1.361, 2.384, 0.694> <1.349, 2.389, 0.663> <1.343, 2.399, 0.643> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.290, 2.457, 0.676> <1.282, 2.457, 0.681> <1.265, 2.458, 0.683> <1.263, 2.456, 0.692> 
		<1.288, 2.444, 0.673> <1.280, 2.443, 0.677> <1.263, 2.438, 0.678> <1.260, 2.436, 0.687> 
		<1.294, 2.425, 0.665> <1.287, 2.418, 0.667> <1.270, 2.413, 0.668> <1.269, 2.407, 0.676> 
		<1.302, 2.415, 0.659> <1.296, 2.408, 0.661> <1.282, 2.398, 0.659> <1.281, 2.393, 0.667> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.263, 2.456, 0.692> <1.258, 2.452, 0.710> <1.260, 2.445, 0.738> <1.271, 2.440, 0.753> 
		<1.260, 2.436, 0.687> <1.256, 2.432, 0.705> <1.258, 2.422, 0.732> <1.269, 2.417, 0.747> 
		<1.269, 2.407, 0.676> <1.266, 2.396, 0.691> <1.268, 2.386, 0.718> <1.278, 2.385, 0.734> 
		<1.281, 2.393, 0.667> <1.279, 2.381, 0.682> <1.282, 2.369, 0.708> <1.292, 2.368, 0.724> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.271, 2.440, 0.753> <1.277, 2.437, 0.761> <1.303, 2.435, 0.759> <1.306, 2.437, 0.749> 
		<1.269, 2.417, 0.747> <1.275, 2.414, 0.755> <1.301, 2.419, 0.755> <1.304, 2.421, 0.745> 
		<1.278, 2.385, 0.734> <1.283, 2.384, 0.743> <1.309, 2.393, 0.745> <1.311, 2.399, 0.737> 
		<1.292, 2.368, 0.724> <1.298, 2.367, 0.733> <1.318, 2.381, 0.738> <1.320, 2.388, 0.730> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.306, 2.437, 0.749> <1.313, 2.441, 0.728> <1.298, 2.451, 0.699> <1.294, 2.456, 0.678> 
		<1.304, 2.421, 0.745> <1.311, 2.426, 0.724> <1.296, 2.438, 0.696> <1.292, 2.443, 0.674> 
		<1.311, 2.399, 0.737> <1.314, 2.413, 0.719> <1.302, 2.417, 0.688> <1.297, 2.425, 0.667> 
		<1.320, 2.388, 0.730> <1.324, 2.402, 0.712> <1.310, 2.408, 0.682> <1.305, 2.416, 0.662> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.312, 2.499, 0.681> <1.307, 2.505, 0.686> <1.296, 2.518, 0.690> <1.296, 2.519, 0.699> 
		<1.301, 2.490, 0.682> <1.296, 2.496, 0.687> <1.280, 2.503, 0.691> <1.280, 2.505, 0.700> 
		<1.291, 2.471, 0.680> <1.283, 2.471, 0.684> <1.267, 2.479, 0.688> <1.265, 2.477, 0.697> 
		<1.290, 2.457, 0.676> <1.282, 2.457, 0.681> <1.265, 2.458, 0.683> <1.263, 2.456, 0.692> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.296, 2.519, 0.699> <1.295, 2.522, 0.718> <1.299, 2.520, 0.746> <1.308, 2.511, 0.760> 
		<1.280, 2.505, 0.700> <1.279, 2.508, 0.719> <1.281, 2.504, 0.748> <1.291, 2.495, 0.762> 
		<1.265, 2.477, 0.697> <1.261, 2.473, 0.715> <1.263, 2.468, 0.744> <1.274, 2.463, 0.759> 
		<1.263, 2.456, 0.692> <1.258, 2.452, 0.710> <1.260, 2.445, 0.738> <1.271, 2.440, 0.753> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.308, 2.511, 0.760> <1.314, 2.506, 0.768> <1.331, 2.487, 0.765> <1.331, 2.485, 0.755> 
		<1.291, 2.495, 0.762> <1.296, 2.490, 0.770> <1.318, 2.476, 0.766> <1.319, 2.474, 0.756> 
		<1.274, 2.463, 0.759> <1.280, 2.461, 0.767> <1.305, 2.450, 0.763> <1.308, 2.453, 0.753> 
		<1.271, 2.440, 0.753> <1.277, 2.437, 0.761> <1.303, 2.435, 0.759> <1.306, 2.437, 0.749> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.331, 2.485, 0.755> <1.333, 2.481, 0.732> <1.320, 2.493, 0.704> <1.315, 2.496, 0.682> 
		<1.319, 2.474, 0.756> <1.321, 2.470, 0.734> <1.310, 2.484, 0.705> <1.305, 2.487, 0.683> 
		<1.308, 2.453, 0.753> <1.314, 2.457, 0.732> <1.299, 2.464, 0.703> <1.295, 2.469, 0.681> 
		<1.306, 2.437, 0.749> <1.313, 2.441, 0.728> <1.298, 2.451, 0.699> <1.294, 2.456, 0.678> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.355, 2.516, 0.670> <1.357, 2.524, 0.674> <1.357, 2.541, 0.675> <1.360, 2.544, 0.683> 
		<1.342, 2.516, 0.675> <1.343, 2.524, 0.679> <1.337, 2.542, 0.682> <1.340, 2.544, 0.691> 
		<1.322, 2.509, 0.680> <1.318, 2.515, 0.685> <1.312, 2.532, 0.688> <1.312, 2.533, 0.698> 
		<1.312, 2.499, 0.681> <1.307, 2.505, 0.686> <1.296, 2.518, 0.690> <1.296, 2.519, 0.699> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.360, 2.544, 0.683> <1.367, 2.549, 0.700> <1.377, 2.549, 0.727> <1.382, 2.539, 0.742> 
		<1.340, 2.544, 0.691> <1.347, 2.550, 0.708> <1.354, 2.550, 0.736> <1.359, 2.540, 0.751> 
		<1.312, 2.533, 0.698> <1.311, 2.536, 0.716> <1.317, 2.536, 0.745> <1.326, 2.527, 0.759> 
		<1.296, 2.519, 0.699> <1.295, 2.522, 0.718> <1.299, 2.520, 0.746> <1.308, 2.511, 0.760> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.382, 2.539, 0.742> <1.385, 2.533, 0.751> <1.385, 2.507, 0.752> <1.381, 2.504, 0.743> 
		<1.359, 2.540, 0.751> <1.362, 2.534, 0.759> <1.369, 2.508, 0.757> <1.366, 2.504, 0.748> 
		<1.326, 2.527, 0.759> <1.332, 2.522, 0.767> <1.343, 2.498, 0.764> <1.344, 2.496, 0.753> 
		<1.308, 2.511, 0.760> <1.314, 2.506, 0.768> <1.331, 2.487, 0.765> <1.331, 2.485, 0.755> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.381, 2.504, 0.743> <1.374, 2.496, 0.723> <1.363, 2.509, 0.693> <1.356, 2.512, 0.672> 
		<1.366, 2.504, 0.748> <1.358, 2.496, 0.728> <1.351, 2.510, 0.698> <1.343, 2.512, 0.677> 
		<1.344, 2.496, 0.753> <1.345, 2.492, 0.731> <1.330, 2.502, 0.703> <1.325, 2.505, 0.681> 
		<1.331, 2.485, 0.755> <1.333, 2.481, 0.732> <1.320, 2.493, 0.704> <1.315, 2.496, 0.682> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.394, 2.497, 0.651> <1.402, 2.503, 0.652> <1.413, 2.515, 0.647> <1.419, 2.516, 0.654> 
		<1.386, 2.507, 0.657> <1.393, 2.513, 0.658> <1.400, 2.530, 0.656> <1.407, 2.531, 0.663> 
		<1.368, 2.515, 0.665> <1.370, 2.524, 0.669> <1.377, 2.541, 0.667> <1.380, 2.543, 0.676> 
		<1.355, 2.516, 0.670> <1.357, 2.524, 0.674> <1.357, 2.541, 0.675> <1.360, 2.544, 0.683> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.419, 2.516, 0.654> <1.432, 2.519, 0.668> <1.447, 2.516, 0.693> <1.448, 2.508, 0.709> 
		<1.407, 2.531, 0.663> <1.419, 2.534, 0.677> <1.432, 2.533, 0.703> <1.434, 2.525, 0.719> 
		<1.380, 2.543, 0.676> <1.387, 2.549, 0.693> <1.399, 2.549, 0.719> <1.405, 2.539, 0.734> 
		<1.360, 2.544, 0.683> <1.367, 2.549, 0.700> <1.377, 2.549, 0.727> <1.382, 2.539, 0.742> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.448, 2.508, 0.709> <1.449, 2.503, 0.719> <1.433, 2.484, 0.728> <1.426, 2.483, 0.720> 
		<1.434, 2.525, 0.719> <1.435, 2.520, 0.729> <1.424, 2.496, 0.734> <1.416, 2.494, 0.727> 
		<1.405, 2.539, 0.734> <1.407, 2.533, 0.743> <1.400, 2.507, 0.746> <1.396, 2.504, 0.737> 
		<1.382, 2.539, 0.742> <1.385, 2.533, 0.751> <1.385, 2.507, 0.752> <1.381, 2.504, 0.743> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.426, 2.483, 0.720> <1.410, 2.479, 0.704> <1.403, 2.491, 0.674> <1.393, 2.494, 0.654> 
		<1.416, 2.494, 0.727> <1.401, 2.490, 0.711> <1.395, 2.500, 0.679> <1.385, 2.504, 0.659> 
		<1.396, 2.504, 0.737> <1.389, 2.496, 0.717> <1.376, 2.509, 0.689> <1.368, 2.512, 0.667> 
		<1.381, 2.504, 0.743> <1.374, 2.496, 0.723> <1.363, 2.509, 0.693> <1.356, 2.512, 0.672> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.406, 2.455, 0.634> <1.416, 2.454, 0.632> <1.430, 2.455, 0.623> <1.437, 2.452, 0.629> 
		<1.408, 2.468, 0.637> <1.417, 2.468, 0.636> <1.432, 2.475, 0.628> <1.440, 2.473, 0.634> 
		<1.402, 2.487, 0.645> <1.410, 2.493, 0.646> <1.425, 2.500, 0.638> <1.432, 2.501, 0.645> 
		<1.394, 2.497, 0.651> <1.402, 2.503, 0.652> <1.413, 2.515, 0.647> <1.419, 2.516, 0.654> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.437, 2.452, 0.629> <1.452, 2.448, 0.640> <1.468, 2.440, 0.662> <1.469, 2.436, 0.681> 
		<1.440, 2.473, 0.634> <1.454, 2.468, 0.645> <1.471, 2.464, 0.668> <1.472, 2.459, 0.687> 
		<1.432, 2.501, 0.645> <1.444, 2.504, 0.659> <1.461, 2.500, 0.683> <1.462, 2.491, 0.699> 
		<1.419, 2.516, 0.654> <1.432, 2.519, 0.668> <1.447, 2.516, 0.693> <1.448, 2.508, 0.709> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.469, 2.436, 0.681> <1.469, 2.433, 0.691> <1.449, 2.431, 0.706> <1.440, 2.434, 0.701> 
		<1.472, 2.459, 0.687> <1.472, 2.456, 0.697> <1.450, 2.447, 0.710> <1.442, 2.450, 0.705> 
		<1.462, 2.491, 0.699> <1.463, 2.486, 0.709> <1.443, 2.473, 0.721> <1.436, 2.471, 0.713> 
		<1.448, 2.508, 0.709> <1.449, 2.503, 0.719> <1.433, 2.484, 0.728> <1.426, 2.483, 0.720> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.440, 2.434, 0.701> <1.422, 2.439, 0.689> <1.415, 2.448, 0.657> <1.404, 2.454, 0.638> 
		<1.442, 2.450, 0.705> <1.424, 2.455, 0.693> <1.417, 2.461, 0.660> <1.406, 2.467, 0.641> 
		<1.436, 2.471, 0.713> <1.420, 2.468, 0.698> <1.411, 2.481, 0.668> <1.401, 2.485, 0.648> 
		<1.426, 2.483, 0.720> <1.410, 2.479, 0.704> <1.403, 2.491, 0.674> <1.393, 2.494, 0.654> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.384, 2.413, 0.629> <1.390, 2.406, 0.627> <1.399, 2.395, 0.617> <1.404, 2.390, 0.622> 
		<1.395, 2.422, 0.628> <1.401, 2.415, 0.626> <1.415, 2.410, 0.615> <1.420, 2.404, 0.620> 
		<1.405, 2.441, 0.630> <1.414, 2.440, 0.629> <1.428, 2.434, 0.618> <1.435, 2.432, 0.624> 
		<1.406, 2.455, 0.634> <1.416, 2.454, 0.632> <1.430, 2.455, 0.623> <1.437, 2.452, 0.629> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.404, 2.390, 0.622> <1.416, 2.378, 0.632> <1.429, 2.366, 0.654> <1.432, 2.365, 0.673> 
		<1.420, 2.404, 0.620> <1.431, 2.393, 0.631> <1.447, 2.382, 0.653> <1.450, 2.381, 0.671> 
		<1.435, 2.432, 0.624> <1.450, 2.427, 0.635> <1.466, 2.417, 0.656> <1.466, 2.412, 0.675> 
		<1.437, 2.452, 0.629> <1.452, 2.448, 0.640> <1.468, 2.440, 0.662> <1.469, 2.436, 0.681> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.432, 2.365, 0.673> <1.433, 2.364, 0.683> <1.421, 2.379, 0.701> <1.415, 2.386, 0.696> 
		<1.450, 2.381, 0.671> <1.451, 2.380, 0.682> <1.433, 2.390, 0.700> <1.427, 2.397, 0.694> 
		<1.466, 2.412, 0.675> <1.467, 2.410, 0.685> <1.447, 2.416, 0.702> <1.438, 2.418, 0.697> 
		<1.469, 2.436, 0.681> <1.469, 2.433, 0.691> <1.449, 2.431, 0.706> <1.440, 2.434, 0.701> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.415, 2.386, 0.696> <1.401, 2.400, 0.684> <1.393, 2.406, 0.652> <1.384, 2.414, 0.633> 
		<1.427, 2.397, 0.694> <1.413, 2.411, 0.683> <1.403, 2.415, 0.651> <1.394, 2.423, 0.632> 
		<1.438, 2.418, 0.697> <1.420, 2.423, 0.685> <1.414, 2.435, 0.653> <1.403, 2.441, 0.634> 
		<1.440, 2.434, 0.701> <1.422, 2.439, 0.689> <1.415, 2.448, 0.657> <1.404, 2.454, 0.638> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.132, 2.365, 1.368> <-0.123, 2.358, 1.382> <-0.118, 2.352, 1.413> <-0.102, 2.344, 1.416> 
		<-0.138, 2.341, 1.363> <-0.129, 2.334, 1.377> <-0.126, 2.316, 1.406> <-0.110, 2.308, 1.409> 
		<-0.152, 2.313, 1.341> <-0.147, 2.297, 1.349> <-0.143, 2.279, 1.378> <-0.131, 2.266, 1.376> 
		<-0.162, 2.302, 1.321> <-0.158, 2.286, 1.329> <-0.159, 2.263, 1.348> <-0.147, 2.250, 1.346> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.102, 2.344, 1.416> <-0.073, 2.329, 1.421> <-0.027, 2.308, 1.412> <-0.005, 2.300, 1.388> 
		<-0.110, 2.308, 1.409> <-0.081, 2.293, 1.413> <-0.036, 2.267, 1.403> <-0.014, 2.259, 1.380> 
		<-0.131, 2.266, 1.376> <-0.107, 2.242, 1.374> <-0.064, 2.214, 1.365> <-0.038, 2.211, 1.343> 
		<-0.147, 2.250, 1.346> <-0.123, 2.226, 1.344> <-0.082, 2.196, 1.331> <-0.056, 2.193, 1.309> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.005, 2.300, 1.388> <0.008, 2.295, 1.374> <0.002, 2.303, 1.326> <-0.016, 2.312, 1.322> 
		<-0.014, 2.259, 1.380> <-0.001, 2.254, 1.365> <-0.005, 2.276, 1.321> <-0.022, 2.285, 1.317> 
		<-0.038, 2.211, 1.343> <-0.023, 2.210, 1.332> <-0.025, 2.239, 1.291> <-0.038, 2.253, 1.292> 
		<-0.056, 2.193, 1.309> <-0.041, 2.191, 1.298> <-0.038, 2.226, 1.268> <-0.050, 2.240, 1.269> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.016, 2.312, 1.322> <-0.050, 2.330, 1.315> <-0.096, 2.349, 1.349> <-0.130, 2.364, 1.360> 
		<-0.022, 2.285, 1.317> <-0.057, 2.303, 1.309> <-0.101, 2.326, 1.344> <-0.136, 2.342, 1.355> 
		<-0.038, 2.253, 1.292> <-0.065, 2.282, 1.294> <-0.116, 2.296, 1.321> <-0.149, 2.315, 1.335> 
		<-0.050, 2.240, 1.269> <-0.078, 2.270, 1.271> <-0.126, 2.285, 1.302> <-0.159, 2.305, 1.316> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.128, 2.447, 1.352> <-0.119, 2.453, 1.364> <-0.112, 2.469, 1.391> <-0.096, 2.468, 1.392> 
		<-0.125, 2.426, 1.365> <-0.115, 2.432, 1.377> <-0.108, 2.437, 1.411> <-0.091, 2.436, 1.412> 
		<-0.127, 2.389, 1.373> <-0.118, 2.382, 1.387> <-0.109, 2.388, 1.421> <-0.093, 2.380, 1.424> 
		<-0.132, 2.365, 1.368> <-0.123, 2.358, 1.382> <-0.118, 2.352, 1.413> <-0.102, 2.344, 1.416> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.096, 2.468, 1.392> <-0.064, 2.466, 1.394> <-0.018, 2.454, 1.382> <0.002, 2.440, 1.361> 
		<-0.091, 2.436, 1.412> <-0.059, 2.434, 1.414> <-0.012, 2.418, 1.404> <0.007, 2.404, 1.384> 
		<-0.093, 2.380, 1.424> <-0.064, 2.365, 1.428> <-0.017, 2.348, 1.420> <0.005, 2.340, 1.397> 
		<-0.102, 2.344, 1.416> <-0.073, 2.329, 1.421> <-0.027, 2.308, 1.412> <-0.005, 2.300, 1.388> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.002, 2.440, 1.361> <0.015, 2.431, 1.348> <0.009, 2.407, 1.307> <-0.011, 2.407, 1.304> 
		<0.007, 2.404, 1.384> <0.020, 2.395, 1.371> <0.012, 2.382, 1.322> <-0.008, 2.383, 1.319> 
		<0.005, 2.340, 1.397> <0.018, 2.335, 1.382> <0.008, 2.331, 1.332> <-0.009, 2.340, 1.328> 
		<-0.005, 2.300, 1.388> <0.008, 2.295, 1.374> <0.002, 2.303, 1.326> <-0.016, 2.312, 1.322> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.011, 2.407, 1.304> <-0.049, 2.408, 1.299> <-0.092, 2.432, 1.333> <-0.126, 2.443, 1.345> 
		<-0.008, 2.383, 1.319> <-0.045, 2.384, 1.314> <-0.089, 2.412, 1.345> <-0.123, 2.422, 1.357> 
		<-0.009, 2.340, 1.328> <-0.044, 2.358, 1.320> <-0.091, 2.372, 1.353> <-0.125, 2.387, 1.365> 
		<-0.016, 2.312, 1.322> <-0.050, 2.330, 1.315> <-0.096, 2.349, 1.349> <-0.130, 2.364, 1.360> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.152, 2.501, 1.283> <-0.146, 2.515, 1.285> <-0.146, 2.544, 1.294> <-0.132, 2.548, 1.289> 
		<-0.142, 2.493, 1.307> <-0.136, 2.507, 1.309> <-0.131, 2.533, 1.330> <-0.117, 2.537, 1.325> 
		<-0.132, 2.470, 1.338> <-0.122, 2.476, 1.350> <-0.117, 2.503, 1.370> <-0.101, 2.502, 1.371> 
		<-0.128, 2.447, 1.352> <-0.119, 2.453, 1.364> <-0.112, 2.469, 1.391> <-0.096, 2.468, 1.392> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.132, 2.548, 1.289> <-0.103, 2.556, 1.279> <-0.060, 2.549, 1.259> <-0.039, 2.531, 1.244> 
		<-0.117, 2.537, 1.325> <-0.088, 2.545, 1.315> <-0.043, 2.536, 1.300> <-0.022, 2.518, 1.285> 
		<-0.101, 2.502, 1.371> <-0.069, 2.500, 1.373> <-0.023, 2.493, 1.358> <-0.004, 2.479, 1.337> 
		<-0.096, 2.468, 1.392> <-0.064, 2.466, 1.394> <-0.018, 2.454, 1.382> <0.002, 2.440, 1.361> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.039, 2.531, 1.244> <-0.026, 2.520, 1.235> <-0.021, 2.475, 1.219> <-0.039, 2.469, 1.225> 
		<-0.022, 2.518, 1.285> <-0.009, 2.507, 1.276> <-0.010, 2.466, 1.247> <-0.027, 2.460, 1.252> 
		<-0.004, 2.479, 1.337> <0.009, 2.470, 1.324> <0.005, 2.433, 1.290> <-0.015, 2.433, 1.288> 
		<0.002, 2.440, 1.361> <0.015, 2.431, 1.348> <0.009, 2.407, 1.307> <-0.011, 2.407, 1.304> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.039, 2.469, 1.225> <-0.073, 2.457, 1.236> <-0.116, 2.486, 1.263> <-0.149, 2.494, 1.279> 
		<-0.027, 2.460, 1.252> <-0.061, 2.449, 1.263> <-0.107, 2.479, 1.286> <-0.140, 2.487, 1.302> 
		<-0.015, 2.433, 1.288> <-0.053, 2.434, 1.283> <-0.095, 2.454, 1.319> <-0.130, 2.464, 1.331> 
		<-0.011, 2.407, 1.304> <-0.049, 2.408, 1.299> <-0.092, 2.432, 1.333> <-0.126, 2.443, 1.345> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.190, 2.494, 1.201> <-0.190, 2.508, 1.191> <-0.200, 2.536, 1.179> <-0.189, 2.539, 1.166> 
		<-0.179, 2.506, 1.223> <-0.178, 2.519, 1.212> <-0.183, 2.553, 1.211> <-0.171, 2.556, 1.199> 
		<-0.162, 2.508, 1.259> <-0.156, 2.523, 1.261> <-0.161, 2.556, 1.258> <-0.146, 2.560, 1.253> 
		<-0.152, 2.501, 1.283> <-0.146, 2.515, 1.285> <-0.146, 2.544, 1.294> <-0.132, 2.548, 1.289> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.189, 2.539, 1.166> <-0.168, 2.545, 1.143> <-0.128, 2.539, 1.114> <-0.104, 2.520, 1.105> 
		<-0.171, 2.556, 1.199> <-0.150, 2.563, 1.176> <-0.109, 2.558, 1.150> <-0.084, 2.540, 1.142> 
		<-0.146, 2.560, 1.253> <-0.118, 2.567, 1.243> <-0.077, 2.562, 1.218> <-0.056, 2.544, 1.203> 
		<-0.132, 2.548, 1.289> <-0.103, 2.556, 1.279> <-0.060, 2.549, 1.259> <-0.039, 2.531, 1.244> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.104, 2.520, 1.105> <-0.088, 2.509, 1.100> <-0.070, 2.467, 1.116> <-0.083, 2.462, 1.131> 
		<-0.084, 2.540, 1.142> <-0.068, 2.529, 1.137> <-0.057, 2.480, 1.141> <-0.069, 2.475, 1.156> 
		<-0.056, 2.544, 1.203> <-0.042, 2.533, 1.194> <-0.033, 2.484, 1.191> <-0.050, 2.478, 1.197> 
		<-0.039, 2.531, 1.244> <-0.026, 2.520, 1.235> <-0.021, 2.475, 1.219> <-0.039, 2.469, 1.225> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.083, 2.462, 1.131> <-0.107, 2.452, 1.159> <-0.155, 2.480, 1.181> <-0.185, 2.488, 1.202> 
		<-0.069, 2.475, 1.156> <-0.093, 2.466, 1.184> <-0.144, 2.491, 1.201> <-0.174, 2.499, 1.222> 
		<-0.050, 2.478, 1.197> <-0.084, 2.466, 1.208> <-0.125, 2.494, 1.240> <-0.159, 2.501, 1.257> 
		<-0.039, 2.469, 1.225> <-0.073, 2.457, 1.236> <-0.116, 2.486, 1.263> <-0.149, 2.494, 1.279> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.220, 2.432, 1.155> <-0.224, 2.436, 1.137> <-0.242, 2.447, 1.113> <-0.233, 2.445, 1.097> 
		<-0.215, 2.456, 1.160> <-0.219, 2.460, 1.142> <-0.233, 2.483, 1.120> <-0.225, 2.481, 1.104> 
		<-0.201, 2.484, 1.181> <-0.201, 2.497, 1.171> <-0.216, 2.519, 1.149> <-0.205, 2.523, 1.136> 
		<-0.190, 2.494, 1.201> <-0.190, 2.508, 1.191> <-0.200, 2.536, 1.179> <-0.189, 2.539, 1.166> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.233, 2.445, 1.097> <-0.218, 2.441, 1.067> <-0.184, 2.428, 1.031> <-0.154, 2.414, 1.026> 
		<-0.225, 2.481, 1.104> <-0.210, 2.477, 1.075> <-0.174, 2.468, 1.040> <-0.145, 2.454, 1.035> 
		<-0.205, 2.523, 1.136> <-0.184, 2.529, 1.113> <-0.146, 2.520, 1.080> <-0.122, 2.502, 1.071> 
		<-0.189, 2.539, 1.166> <-0.168, 2.545, 1.143> <-0.128, 2.539, 1.114> <-0.104, 2.520, 1.105> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.154, 2.414, 1.026> <-0.136, 2.405, 1.023> <-0.109, 2.388, 1.059> <-0.117, 2.390, 1.078> 
		<-0.145, 2.454, 1.035> <-0.127, 2.446, 1.032> <-0.102, 2.415, 1.065> <-0.110, 2.417, 1.083> 
		<-0.122, 2.502, 1.071> <-0.106, 2.491, 1.066> <-0.082, 2.454, 1.093> <-0.095, 2.449, 1.108> 
		<-0.104, 2.520, 1.105> <-0.088, 2.509, 1.100> <-0.070, 2.467, 1.116> <-0.083, 2.462, 1.131> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.117, 2.390, 1.078> <-0.133, 2.394, 1.113> <-0.185, 2.417, 1.134> <-0.214, 2.428, 1.158> 
		<-0.110, 2.417, 1.083> <-0.127, 2.421, 1.119> <-0.179, 2.439, 1.138> <-0.208, 2.451, 1.163> 
		<-0.095, 2.449, 1.108> <-0.119, 2.440, 1.136> <-0.165, 2.470, 1.162> <-0.195, 2.478, 1.183> 
		<-0.083, 2.462, 1.131> <-0.107, 2.452, 1.159> <-0.155, 2.480, 1.181> <-0.185, 2.488, 1.202> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.224, 2.349, 1.171> <-0.229, 2.341, 1.156> <-0.247, 2.330, 1.134> <-0.240, 2.321, 1.121> 
		<-0.228, 2.371, 1.158> <-0.232, 2.362, 1.143> <-0.252, 2.362, 1.114> <-0.244, 2.353, 1.101> 
		<-0.226, 2.408, 1.150> <-0.230, 2.412, 1.132> <-0.250, 2.411, 1.105> <-0.242, 2.409, 1.089> 
		<-0.220, 2.432, 1.155> <-0.224, 2.436, 1.137> <-0.242, 2.447, 1.113> <-0.233, 2.445, 1.097> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.240, 2.321, 1.121> <-0.226, 2.304, 1.095> <-0.194, 2.281, 1.060> <-0.161, 2.274, 1.053> 
		<-0.244, 2.353, 1.101> <-0.230, 2.336, 1.075> <-0.199, 2.317, 1.038> <-0.167, 2.310, 1.031> 
		<-0.242, 2.409, 1.089> <-0.227, 2.405, 1.060> <-0.193, 2.387, 1.023> <-0.164, 2.373, 1.018> 
		<-0.233, 2.445, 1.097> <-0.218, 2.441, 1.067> <-0.184, 2.428, 1.031> <-0.154, 2.414, 1.026> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.161, 2.274, 1.053> <-0.144, 2.270, 1.050> <-0.115, 2.286, 1.081> <-0.122, 2.295, 1.096> 
		<-0.167, 2.310, 1.031> <-0.149, 2.306, 1.027> <-0.118, 2.310, 1.066> <-0.125, 2.319, 1.081> 
		<-0.164, 2.373, 1.018> <-0.146, 2.364, 1.015> <-0.115, 2.360, 1.053> <-0.123, 2.362, 1.072> 
		<-0.154, 2.414, 1.026> <-0.136, 2.405, 1.023> <-0.109, 2.388, 1.059> <-0.117, 2.390, 1.078> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.122, 2.295, 1.096> <-0.137, 2.315, 1.128> <-0.189, 2.333, 1.150> <-0.218, 2.350, 1.173> 
		<-0.125, 2.319, 1.081> <-0.140, 2.339, 1.112> <-0.192, 2.354, 1.137> <-0.221, 2.370, 1.160> 
		<-0.123, 2.362, 1.072> <-0.140, 2.366, 1.107> <-0.190, 2.394, 1.129> <-0.219, 2.405, 1.153> 
		<-0.117, 2.390, 1.078> <-0.133, 2.394, 1.113> <-0.185, 2.417, 1.134> <-0.214, 2.428, 1.158> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.200, 2.296, 1.240> <-0.201, 2.279, 1.235> <-0.213, 2.253, 1.232> <-0.204, 2.240, 1.224> 
		<-0.210, 2.303, 1.216> <-0.211, 2.287, 1.211> <-0.227, 2.264, 1.196> <-0.219, 2.252, 1.188> 
		<-0.221, 2.326, 1.185> <-0.226, 2.318, 1.170> <-0.242, 2.296, 1.156> <-0.235, 2.287, 1.142> 
		<-0.224, 2.349, 1.171> <-0.229, 2.341, 1.156> <-0.247, 2.330, 1.134> <-0.240, 2.321, 1.121> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.204, 2.240, 1.224> <-0.186, 2.215, 1.209> <-0.152, 2.184, 1.185> <-0.120, 2.182, 1.171> 
		<-0.219, 2.252, 1.188> <-0.201, 2.227, 1.172> <-0.169, 2.197, 1.144> <-0.137, 2.195, 1.130> 
		<-0.235, 2.287, 1.142> <-0.221, 2.270, 1.116> <-0.188, 2.242, 1.085> <-0.156, 2.235, 1.078> 
		<-0.240, 2.321, 1.121> <-0.226, 2.304, 1.095> <-0.194, 2.281, 1.060> <-0.161, 2.274, 1.053> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.120, 2.182, 1.171> <-0.105, 2.181, 1.164> <-0.086, 2.220, 1.168> <-0.094, 2.233, 1.175> 
		<-0.137, 2.195, 1.130> <-0.122, 2.194, 1.123> <-0.097, 2.229, 1.140> <-0.106, 2.242, 1.147> 
		<-0.156, 2.235, 1.078> <-0.138, 2.231, 1.074> <-0.111, 2.259, 1.098> <-0.118, 2.269, 1.112> 
		<-0.161, 2.274, 1.053> <-0.144, 2.270, 1.050> <-0.115, 2.286, 1.081> <-0.122, 2.295, 1.096> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.094, 2.233, 1.175> <-0.114, 2.264, 1.193> <-0.165, 2.279, 1.219> <-0.195, 2.299, 1.238> 
		<-0.106, 2.242, 1.147> <-0.125, 2.273, 1.165> <-0.174, 2.286, 1.196> <-0.204, 2.306, 1.215> 
		<-0.118, 2.269, 1.112> <-0.133, 2.289, 1.144> <-0.186, 2.312, 1.163> <-0.214, 2.328, 1.186> 
		<-0.122, 2.295, 1.096> <-0.137, 2.315, 1.128> <-0.189, 2.333, 1.150> <-0.218, 2.350, 1.173> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.162, 2.302, 1.321> <-0.158, 2.286, 1.329> <-0.159, 2.263, 1.348> <-0.147, 2.250, 1.346> 
		<-0.174, 2.290, 1.300> <-0.169, 2.275, 1.307> <-0.176, 2.245, 1.315> <-0.164, 2.232, 1.314> 
		<-0.191, 2.288, 1.264> <-0.191, 2.271, 1.259> <-0.198, 2.242, 1.268> <-0.189, 2.229, 1.260> 
		<-0.200, 2.296, 1.240> <-0.201, 2.279, 1.235> <-0.213, 2.253, 1.232> <-0.204, 2.240, 1.224> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.147, 2.250, 1.346> <-0.123, 2.226, 1.344> <-0.082, 2.196, 1.331> <-0.056, 2.193, 1.309> 
		<-0.164, 2.232, 1.314> <-0.140, 2.208, 1.311> <-0.102, 2.176, 1.294> <-0.075, 2.173, 1.273> 
		<-0.189, 2.229, 1.260> <-0.171, 2.204, 1.245> <-0.135, 2.171, 1.226> <-0.104, 2.169, 1.211> 
		<-0.204, 2.240, 1.224> <-0.186, 2.215, 1.209> <-0.152, 2.184, 1.185> <-0.120, 2.182, 1.171> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.056, 2.193, 1.309> <-0.041, 2.191, 1.298> <-0.038, 2.226, 1.268> <-0.050, 2.240, 1.269> 
		<-0.075, 2.173, 1.273> <-0.061, 2.172, 1.261> <-0.051, 2.213, 1.243> <-0.063, 2.227, 1.244> 
		<-0.104, 2.169, 1.211> <-0.088, 2.168, 1.204> <-0.074, 2.211, 1.195> <-0.083, 2.224, 1.203> 
		<-0.120, 2.182, 1.171> <-0.105, 2.181, 1.164> <-0.086, 2.220, 1.168> <-0.094, 2.233, 1.175> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.050, 2.240, 1.269> <-0.078, 2.270, 1.271> <-0.126, 2.285, 1.302> <-0.159, 2.305, 1.316> 
		<-0.063, 2.227, 1.244> <-0.091, 2.257, 1.246> <-0.137, 2.274, 1.281> <-0.170, 2.294, 1.295> 
		<-0.083, 2.224, 1.203> <-0.102, 2.255, 1.221> <-0.155, 2.272, 1.242> <-0.185, 2.292, 1.261> 
		<-0.094, 2.233, 1.175> <-0.114, 2.264, 1.193> <-0.165, 2.279, 1.219> <-0.195, 2.299, 1.238> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.404, 2.283, 0.786> <1.413, 2.280, 0.802> <1.417, 2.270, 0.832> <1.434, 2.271, 0.838> 
		<1.414, 2.262, 0.777> <1.423, 2.259, 0.792> <1.432, 2.238, 0.818> <1.449, 2.240, 0.824> 
		<1.422, 2.238, 0.749> <1.434, 2.226, 0.756> <1.444, 2.206, 0.782> <1.461, 2.203, 0.782> 
		<1.422, 2.228, 0.726> <1.434, 2.216, 0.733> <1.444, 2.192, 0.747> <1.462, 2.188, 0.748> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.434, 2.271, 0.838> <1.466, 2.274, 0.847> <1.517, 2.283, 0.847> <1.542, 2.294, 0.829> 
		<1.449, 2.240, 0.824> <1.481, 2.242, 0.833> <1.533, 2.247, 0.832> <1.559, 2.258, 0.813> 
		<1.461, 2.203, 0.782> <1.495, 2.196, 0.783> <1.546, 2.199, 0.781> <1.572, 2.216, 0.766> 
		<1.462, 2.188, 0.748> <1.495, 2.182, 0.748> <1.547, 2.183, 0.741> <1.573, 2.200, 0.727> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.542, 2.294, 0.829> <1.557, 2.301, 0.818> <1.553, 2.316, 0.772> <1.534, 2.315, 0.765> 
		<1.559, 2.258, 0.813> <1.574, 2.265, 0.802> <1.565, 2.292, 0.761> <1.546, 2.291, 0.754> 
		<1.572, 2.216, 0.766> <1.586, 2.226, 0.759> <1.573, 2.258, 0.723> <1.555, 2.262, 0.722> 
		<1.573, 2.200, 0.727> <1.587, 2.210, 0.719> <1.573, 2.247, 0.696> <1.555, 2.251, 0.696> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.534, 2.315, 0.765> <1.497, 2.313, 0.751> <1.445, 2.295, 0.775> <1.407, 2.286, 0.779> 
		<1.546, 2.291, 0.754> <1.509, 2.288, 0.740> <1.455, 2.275, 0.766> <1.416, 2.266, 0.770> 
		<1.555, 2.262, 0.722> <1.515, 2.271, 0.721> <1.463, 2.248, 0.736> <1.424, 2.243, 0.744> 
		<1.555, 2.251, 0.696> <1.516, 2.260, 0.694> <1.463, 2.239, 0.714> <1.424, 2.234, 0.722> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.362, 2.356, 0.782> <1.365, 2.363, 0.797> <1.358, 2.372, 0.827> <1.371, 2.380, 0.832> 
		<1.375, 2.337, 0.793> <1.378, 2.345, 0.808> <1.377, 2.344, 0.843> <1.391, 2.352, 0.848> 
		<1.394, 2.304, 0.795> <1.403, 2.301, 0.811> <1.402, 2.302, 0.846> <1.419, 2.303, 0.852> 
		<1.404, 2.283, 0.786> <1.413, 2.280, 0.802> <1.417, 2.270, 0.832> <1.434, 2.271, 0.838> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.371, 2.380, 0.832> <1.398, 2.395, 0.842> <1.444, 2.413, 0.839> <1.470, 2.418, 0.823> 
		<1.391, 2.352, 0.848> <1.417, 2.367, 0.858> <1.466, 2.382, 0.858> <1.492, 2.386, 0.841> 
		<1.419, 2.303, 0.852> <1.451, 2.306, 0.861> <1.500, 2.319, 0.863> <1.525, 2.330, 0.845> 
		<1.434, 2.271, 0.838> <1.466, 2.274, 0.847> <1.517, 2.283, 0.847> <1.542, 2.294, 0.829> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.470, 2.418, 0.823> <1.487, 2.420, 0.812> <1.502, 2.408, 0.768> <1.486, 2.398, 0.760> 
		<1.492, 2.386, 0.841> <1.509, 2.389, 0.830> <1.517, 2.387, 0.780> <1.501, 2.377, 0.773> 
		<1.525, 2.330, 0.845> <1.540, 2.337, 0.834> <1.542, 2.340, 0.782> <1.523, 2.339, 0.775> 
		<1.542, 2.294, 0.829> <1.557, 2.301, 0.818> <1.553, 2.316, 0.772> <1.534, 2.315, 0.765> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.486, 2.398, 0.760> <1.455, 2.380, 0.746> <1.403, 2.368, 0.771> <1.367, 2.355, 0.776> 
		<1.501, 2.377, 0.773> <1.470, 2.358, 0.759> <1.415, 2.350, 0.781> <1.379, 2.337, 0.786> 
		<1.523, 2.339, 0.775> <1.486, 2.337, 0.762> <1.436, 2.315, 0.784> <1.398, 2.306, 0.788> 
		<1.534, 2.315, 0.765> <1.497, 2.313, 0.751> <1.445, 2.295, 0.775> <1.407, 2.286, 0.779> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.321, 2.403, 0.717> <1.317, 2.418, 0.722> <1.299, 2.440, 0.735> <1.309, 2.452, 0.734> 
		<1.330, 2.397, 0.742> <1.327, 2.411, 0.747> <1.313, 2.429, 0.772> <1.323, 2.441, 0.771> 
		<1.348, 2.376, 0.771> <1.351, 2.383, 0.786> <1.336, 2.403, 0.809> <1.350, 2.411, 0.815> 
		<1.362, 2.356, 0.782> <1.365, 2.363, 0.797> <1.358, 2.372, 0.827> <1.371, 2.380, 0.832> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.309, 2.452, 0.734> <1.329, 2.476, 0.733> <1.371, 2.498, 0.723> <1.400, 2.498, 0.712> 
		<1.323, 2.441, 0.771> <1.343, 2.466, 0.770> <1.386, 2.487, 0.765> <1.416, 2.487, 0.754> 
		<1.350, 2.411, 0.815> <1.377, 2.426, 0.824> <1.420, 2.448, 0.820> <1.446, 2.452, 0.803> 
		<1.371, 2.380, 0.832> <1.398, 2.395, 0.842> <1.444, 2.413, 0.839> <1.470, 2.418, 0.823> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.400, 2.498, 0.712> <1.418, 2.499, 0.705> <1.450, 2.469, 0.685> <1.438, 2.453, 0.685> 
		<1.416, 2.487, 0.754> <1.434, 2.487, 0.747> <1.461, 2.461, 0.713> <1.449, 2.445, 0.714> 
		<1.446, 2.452, 0.803> <1.463, 2.455, 0.792> <1.486, 2.431, 0.754> <1.470, 2.422, 0.747> 
		<1.470, 2.418, 0.823> <1.487, 2.420, 0.812> <1.502, 2.408, 0.768> <1.486, 2.398, 0.760> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.438, 2.453, 0.685> <1.416, 2.423, 0.686> <1.361, 2.416, 0.705> <1.328, 2.400, 0.714> 
		<1.449, 2.445, 0.714> <1.427, 2.415, 0.714> <1.370, 2.410, 0.729> <1.337, 2.394, 0.737> 
		<1.470, 2.422, 0.747> <1.439, 2.403, 0.733> <1.389, 2.387, 0.760> <1.354, 2.374, 0.765> 
		<1.486, 2.398, 0.760> <1.455, 2.380, 0.746> <1.403, 2.368, 0.771> <1.367, 2.355, 0.776> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.304, 2.398, 0.629> <1.298, 2.412, 0.620> <1.276, 2.432, 0.610> <1.285, 2.443, 0.601> 
		<1.304, 2.408, 0.654> <1.298, 2.422, 0.645> <1.276, 2.447, 0.647> <1.284, 2.459, 0.639> 
		<1.312, 2.410, 0.693> <1.308, 2.425, 0.698> <1.286, 2.450, 0.698> <1.296, 2.462, 0.697> 
		<1.321, 2.403, 0.717> <1.317, 2.418, 0.722> <1.299, 2.440, 0.735> <1.309, 2.452, 0.734> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.285, 2.443, 0.601> <1.301, 2.465, 0.585> <1.340, 2.488, 0.565> <1.372, 2.489, 0.561> 
		<1.284, 2.459, 0.639> <1.301, 2.481, 0.622> <1.340, 2.506, 0.608> <1.372, 2.507, 0.604> 
		<1.296, 2.462, 0.697> <1.316, 2.486, 0.696> <1.355, 2.510, 0.681> <1.384, 2.510, 0.670> 
		<1.309, 2.452, 0.734> <1.329, 2.476, 0.733> <1.371, 2.498, 0.723> <1.400, 2.498, 0.712> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.372, 2.489, 0.561> <1.392, 2.490, 0.558> <1.429, 2.461, 0.573> <1.419, 2.447, 0.583> 
		<1.372, 2.507, 0.604> <1.392, 2.507, 0.601> <1.428, 2.473, 0.602> <1.419, 2.459, 0.612> 
		<1.384, 2.510, 0.670> <1.403, 2.510, 0.663> <1.439, 2.476, 0.657> <1.428, 2.461, 0.657> 
		<1.400, 2.498, 0.712> <1.418, 2.499, 0.705> <1.450, 2.469, 0.685> <1.438, 2.453, 0.685> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.419, 2.447, 0.583> <1.402, 2.419, 0.603> <1.344, 2.411, 0.616> <1.312, 2.395, 0.629> 
		<1.419, 2.459, 0.612> <1.402, 2.431, 0.632> <1.344, 2.420, 0.639> <1.312, 2.405, 0.653> 
		<1.428, 2.461, 0.657> <1.405, 2.430, 0.658> <1.352, 2.423, 0.682> <1.319, 2.407, 0.690> 
		<1.438, 2.453, 0.685> <1.416, 2.423, 0.686> <1.361, 2.416, 0.705> <1.328, 2.400, 0.714> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.322, 2.343, 0.569> <1.319, 2.348, 0.551> <1.302, 2.354, 0.525> <1.312, 2.361, 0.511> 
		<1.312, 2.364, 0.578> <1.309, 2.369, 0.561> <1.287, 2.386, 0.539> <1.297, 2.392, 0.525> 
		<1.305, 2.389, 0.605> <1.299, 2.402, 0.597> <1.276, 2.417, 0.575> <1.285, 2.429, 0.566> 
		<1.304, 2.398, 0.629> <1.298, 2.412, 0.620> <1.276, 2.432, 0.610> <1.285, 2.443, 0.601> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.312, 2.361, 0.511> <1.330, 2.372, 0.486> <1.370, 2.389, 0.458> <1.403, 2.395, 0.459> 
		<1.297, 2.392, 0.525> <1.315, 2.404, 0.500> <1.353, 2.425, 0.474> <1.386, 2.431, 0.475> 
		<1.285, 2.429, 0.566> <1.302, 2.451, 0.550> <1.341, 2.472, 0.526> <1.373, 2.473, 0.522> 
		<1.285, 2.443, 0.601> <1.301, 2.465, 0.585> <1.340, 2.488, 0.565> <1.372, 2.489, 0.561> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.403, 2.395, 0.459> <1.423, 2.399, 0.460> <1.451, 2.391, 0.499> <1.440, 2.383, 0.514> 
		<1.386, 2.431, 0.475> <1.406, 2.435, 0.475> <1.439, 2.415, 0.509> <1.429, 2.407, 0.525> 
		<1.373, 2.473, 0.522> <1.393, 2.474, 0.519> <1.429, 2.450, 0.546> <1.420, 2.436, 0.557> 
		<1.372, 2.489, 0.561> <1.392, 2.490, 0.558> <1.429, 2.461, 0.573> <1.419, 2.447, 0.583> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.440, 2.383, 0.514> <1.420, 2.369, 0.545> <1.363, 2.355, 0.555> <1.329, 2.343, 0.572> 
		<1.429, 2.407, 0.525> <1.409, 2.393, 0.556> <1.353, 2.375, 0.564> <1.320, 2.363, 0.581> 
		<1.420, 2.436, 0.557> <1.402, 2.408, 0.577> <1.345, 2.402, 0.594> <1.312, 2.386, 0.607> 
		<1.419, 2.447, 0.583> <1.402, 2.419, 0.603> <1.344, 2.411, 0.616> <1.312, 2.395, 0.629> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.364, 2.270, 0.572> <1.368, 2.265, 0.556> <1.362, 2.251, 0.529> <1.375, 2.251, 0.517> 
		<1.351, 2.289, 0.562> <1.355, 2.283, 0.545> <1.343, 2.279, 0.513> <1.355, 2.280, 0.501> 
		<1.332, 2.322, 0.559> <1.329, 2.327, 0.542> <1.317, 2.322, 0.511> <1.327, 2.329, 0.497> 
		<1.322, 2.343, 0.569> <1.319, 2.348, 0.551> <1.302, 2.354, 0.525> <1.312, 2.361, 0.511> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.375, 2.251, 0.517> <1.399, 2.252, 0.493> <1.443, 2.258, 0.465> <1.474, 2.272, 0.465> 
		<1.355, 2.280, 0.501> <1.380, 2.280, 0.477> <1.421, 2.290, 0.447> <1.452, 2.304, 0.447> 
		<1.327, 2.329, 0.497> <1.345, 2.341, 0.472> <1.387, 2.353, 0.442> <1.420, 2.359, 0.443> 
		<1.312, 2.361, 0.511> <1.330, 2.372, 0.486> <1.370, 2.389, 0.458> <1.403, 2.395, 0.459> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.474, 2.272, 0.465> <1.491, 2.279, 0.466> <1.501, 2.299, 0.505> <1.489, 2.300, 0.519> 
		<1.452, 2.304, 0.447> <1.469, 2.311, 0.447> <1.486, 2.321, 0.493> <1.474, 2.321, 0.506> 
		<1.420, 2.359, 0.443> <1.440, 2.363, 0.444> <1.462, 2.366, 0.488> <1.452, 2.359, 0.504> 
		<1.403, 2.395, 0.459> <1.423, 2.399, 0.460> <1.451, 2.391, 0.499> <1.440, 2.383, 0.514> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.489, 2.300, 0.519> <1.461, 2.300, 0.548> <1.405, 2.281, 0.559> <1.369, 2.274, 0.576> 
		<1.474, 2.321, 0.506> <1.446, 2.322, 0.536> <1.393, 2.299, 0.549> <1.357, 2.291, 0.566> 
		<1.452, 2.359, 0.504> <1.432, 2.345, 0.535> <1.372, 2.335, 0.546> <1.339, 2.323, 0.564> 
		<1.440, 2.383, 0.514> <1.420, 2.369, 0.545> <1.363, 2.355, 0.555> <1.329, 2.343, 0.572> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.406, 2.223, 0.638> <1.415, 2.210, 0.631> <1.422, 2.184, 0.621> <1.437, 2.180, 0.615> 
		<1.396, 2.229, 0.613> <1.406, 2.217, 0.606> <1.408, 2.194, 0.584> <1.423, 2.190, 0.578> 
		<1.378, 2.250, 0.584> <1.382, 2.244, 0.567> <1.383, 2.221, 0.547> <1.396, 2.221, 0.534> 
		<1.364, 2.270, 0.572> <1.368, 2.265, 0.556> <1.362, 2.251, 0.529> <1.375, 2.251, 0.517> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.437, 2.180, 0.615> <1.468, 2.173, 0.601> <1.516, 2.172, 0.582> <1.545, 2.191, 0.576> 
		<1.423, 2.190, 0.578> <1.454, 2.183, 0.564> <1.500, 2.184, 0.540> <1.529, 2.202, 0.534> 
		<1.396, 2.221, 0.534> <1.420, 2.222, 0.510> <1.467, 2.224, 0.485> <1.498, 2.237, 0.485> 
		<1.375, 2.251, 0.517> <1.399, 2.252, 0.493> <1.443, 2.258, 0.465> <1.474, 2.272, 0.465> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.545, 2.191, 0.576> <1.559, 2.200, 0.573> <1.551, 2.241, 0.587> <1.536, 2.245, 0.594> 
		<1.529, 2.202, 0.534> <1.543, 2.212, 0.531> <1.541, 2.249, 0.559> <1.525, 2.253, 0.565> 
		<1.498, 2.237, 0.485> <1.515, 2.245, 0.485> <1.517, 2.276, 0.519> <1.505, 2.276, 0.532> 
		<1.474, 2.272, 0.465> <1.491, 2.279, 0.466> <1.501, 2.299, 0.505> <1.489, 2.300, 0.519> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.536, 2.245, 0.594> <1.500, 2.255, 0.610> <1.447, 2.233, 0.625> <1.409, 2.229, 0.638> 
		<1.525, 2.253, 0.565> <1.489, 2.263, 0.582> <1.438, 2.240, 0.601> <1.400, 2.235, 0.615> 
		<1.505, 2.276, 0.532> <1.477, 2.277, 0.561> <1.418, 2.262, 0.570> <1.383, 2.254, 0.587> 
		<1.489, 2.300, 0.519> <1.461, 2.300, 0.548> <1.405, 2.281, 0.559> <1.369, 2.274, 0.576> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.422, 2.228, 0.726> <1.434, 2.216, 0.733> <1.444, 2.192, 0.747> <1.462, 2.188, 0.748> 
		<1.422, 2.218, 0.701> <1.434, 2.206, 0.707> <1.444, 2.176, 0.710> <1.462, 2.173, 0.710> 
		<1.415, 2.216, 0.662> <1.424, 2.203, 0.655> <1.435, 2.174, 0.658> <1.451, 2.170, 0.651> 
		<1.406, 2.223, 0.638> <1.415, 2.210, 0.631> <1.422, 2.184, 0.621> <1.437, 2.180, 0.615> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.462, 2.188, 0.748> <1.495, 2.182, 0.748> <1.547, 2.183, 0.741> <1.573, 2.200, 0.727> 
		<1.462, 2.173, 0.710> <1.495, 2.167, 0.710> <1.547, 2.166, 0.699> <1.573, 2.183, 0.684> 
		<1.451, 2.170, 0.651> <1.482, 2.163, 0.638> <1.532, 2.161, 0.624> <1.560, 2.179, 0.618> 
		<1.437, 2.180, 0.615> <1.468, 2.173, 0.601> <1.516, 2.172, 0.582> <1.545, 2.191, 0.576> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.573, 2.200, 0.727> <1.587, 2.210, 0.719> <1.573, 2.247, 0.696> <1.555, 2.251, 0.696> 
		<1.573, 2.183, 0.684> <1.587, 2.192, 0.677> <1.574, 2.235, 0.667> <1.555, 2.239, 0.667> 
		<1.560, 2.179, 0.618> <1.574, 2.189, 0.615> <1.562, 2.233, 0.615> <1.547, 2.237, 0.622> 
		<1.545, 2.191, 0.576> <1.559, 2.200, 0.573> <1.551, 2.241, 0.587> <1.536, 2.245, 0.594> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.555, 2.251, 0.696> <1.516, 2.260, 0.694> <1.463, 2.239, 0.714> <1.424, 2.234, 0.722> 
		<1.555, 2.239, 0.667> <1.516, 2.248, 0.666> <1.464, 2.229, 0.690> <1.424, 2.224, 0.698> 
		<1.547, 2.237, 0.622> <1.511, 2.247, 0.638> <1.456, 2.227, 0.648> <1.417, 2.222, 0.661> 
		<1.536, 2.245, 0.594> <1.500, 2.255, 0.610> <1.447, 2.233, 0.625> <1.409, 2.229, 0.638> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.695, 2.479, -1.253> <1.699, 2.551, -1.237> <1.726, 2.621, -1.278> <1.757, 2.635, -1.343> 
		<1.431, 2.517, -1.369> <1.434, 2.589, -1.352> <1.462, 2.659, -1.393> <1.492, 2.673, -1.458> 
		<1.077, 2.568, -1.523> <1.081, 2.639, -1.506> <1.108, 2.710, -1.547> <1.139, 2.724, -1.612> 
		<0.813, 2.606, -1.638> <0.816, 2.677, -1.622> <0.844, 2.748, -1.663> <0.874, 2.762, -1.728> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.757, 2.635, -1.343> <1.787, 2.649, -1.408> <1.810, 2.601, -1.476> <1.807, 2.530, -1.492> 
		<1.492, 2.673, -1.458> <1.522, 2.687, -1.523> <1.545, 2.639, -1.591> <1.542, 2.568, -1.608> 
		<1.139, 2.724, -1.612> <1.169, 2.738, -1.677> <1.192, 2.690, -1.745> <1.189, 2.618, -1.762> 
		<0.874, 2.762, -1.728> <0.904, 2.776, -1.793> <0.927, 2.728, -1.861> <0.924, 2.656, -1.877> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.807, 2.530, -1.492> <1.804, 2.458, -1.509> <1.776, 2.388, -1.468> <1.745, 2.374, -1.403> 
		<1.542, 2.568, -1.608> <1.539, 2.496, -1.624> <1.511, 2.426, -1.584> <1.481, 2.412, -1.518> 
		<1.189, 2.618, -1.762> <1.186, 2.547, -1.778> <1.158, 2.476, -1.738> <1.127, 2.463, -1.672> 
		<0.924, 2.656, -1.877> <0.921, 2.585, -1.894> <0.893, 2.514, -1.853> <0.863, 2.501, -1.788> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.863, 2.501, -1.788> <0.832, 2.487, -1.723> <0.810, 2.535, -1.655> <0.813, 2.606, -1.638> 
		<1.127, 2.463, -1.672> <1.097, 2.449, -1.607> <1.074, 2.497, -1.539> <1.077, 2.568, -1.523> 
		<1.481, 2.412, -1.518> <1.450, 2.398, -1.453> <1.427, 2.446, -1.385> <1.431, 2.517, -1.369> 
		<1.745, 2.374, -1.403> <1.715, 2.360, -1.338> <1.692, 2.408, -1.270> <1.695, 2.479, -1.253> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.179, 2.589, -1.586> <1.180, 2.607, -1.582> <1.186, 2.624, -1.591> <1.194, 2.627, -1.607> 
		<1.027, 2.615, -1.667> <1.028, 2.632, -1.663> <1.034, 2.649, -1.673> <1.042, 2.652, -1.688> 
		<0.824, 2.648, -1.775> <0.825, 2.665, -1.771> <0.832, 2.682, -1.781> <0.839, 2.685, -1.797> 
		<0.673, 2.673, -1.857> <0.673, 2.690, -1.853> <0.680, 2.707, -1.863> <0.687, 2.710, -1.878> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.194, 2.627, -1.607> <1.201, 2.630, -1.623> <1.206, 2.619, -1.639> <1.206, 2.602, -1.643> 
		<1.042, 2.652, -1.688> <1.049, 2.655, -1.704> <1.054, 2.644, -1.720> <1.054, 2.627, -1.724> 
		<0.839, 2.685, -1.797> <0.846, 2.689, -1.813> <0.852, 2.677, -1.829> <0.851, 2.660, -1.833> 
		<0.687, 2.710, -1.878> <0.695, 2.714, -1.894> <0.700, 2.702, -1.910> <0.699, 2.685, -1.914> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.206, 2.602, -1.643> <1.205, 2.584, -1.647> <1.198, 2.567, -1.637> <1.191, 2.564, -1.621> 
		<1.054, 2.627, -1.724> <1.053, 2.609, -1.728> <1.046, 2.592, -1.718> <1.039, 2.589, -1.703> 
		<0.851, 2.660, -1.833> <0.850, 2.643, -1.837> <0.844, 2.626, -1.827> <0.836, 2.623, -1.811> 
		<0.699, 2.685, -1.914> <0.699, 2.668, -1.918> <0.692, 2.651, -1.908> <0.685, 2.648, -1.893> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.685, 2.648, -1.893> <0.677, 2.644, -1.877> <0.672, 2.656, -1.861> <0.673, 2.673, -1.857> 
		<0.836, 2.623, -1.811> <0.829, 2.619, -1.796> <0.824, 2.631, -1.779> <0.824, 2.648, -1.775> 
		<1.039, 2.589, -1.703> <1.032, 2.586, -1.687> <1.026, 2.597, -1.671> <1.027, 2.615, -1.667> 
		<1.191, 2.564, -1.621> <1.183, 2.561, -1.606> <1.178, 2.572, -1.590> <1.179, 2.589, -1.586> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.796, 2.603, -1.798> <0.797, 2.593, -1.799> <0.793, 2.578, -1.804> <0.800, 2.572, -1.802> 
		<0.802, 2.605, -1.810> <0.803, 2.596, -1.812> <0.802, 2.582, -1.823> <0.809, 2.576, -1.821> 
		<0.810, 2.617, -1.826> <0.814, 2.611, -1.832> <0.813, 2.597, -1.844> <0.821, 2.593, -1.844> 
		<0.815, 2.628, -1.833> <0.819, 2.623, -1.839> <0.820, 2.614, -1.854> <0.828, 2.610, -1.855> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.800, 2.572, -1.802> <0.814, 2.560, -1.798> <0.839, 2.548, -1.789> <0.856, 2.551, -1.780> 
		<0.809, 2.576, -1.821> <0.823, 2.564, -1.817> <0.849, 2.553, -1.810> <0.866, 2.556, -1.802> 
		<0.821, 2.593, -1.844> <0.839, 2.585, -1.846> <0.865, 2.575, -1.840> <0.880, 2.576, -1.828> 
		<0.828, 2.610, -1.855> <0.846, 2.603, -1.856> <0.873, 2.595, -1.851> <0.888, 2.595, -1.840> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.856, 2.551, -1.780> <0.865, 2.553, -1.776> <0.873, 2.576, -1.767> <0.866, 2.583, -1.769> 
		<0.866, 2.556, -1.802> <0.875, 2.558, -1.797> <0.880, 2.579, -1.782> <0.872, 2.586, -1.784> 
		<0.880, 2.576, -1.828> <0.888, 2.576, -1.822> <0.891, 2.595, -1.803> <0.882, 2.600, -1.802> 
		<0.888, 2.595, -1.840> <0.896, 2.596, -1.833> <0.897, 2.609, -1.811> <0.887, 2.613, -1.809> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.866, 2.583, -1.769> <0.849, 2.599, -1.773> <0.819, 2.599, -1.788> <0.799, 2.605, -1.796> 
		<0.872, 2.586, -1.784> <0.856, 2.602, -1.788> <0.824, 2.601, -1.800> <0.804, 2.608, -1.808> 
		<0.882, 2.600, -1.802> <0.862, 2.609, -1.798> <0.833, 2.614, -1.817> <0.812, 2.619, -1.823> 
		<0.887, 2.613, -1.809> <0.867, 2.623, -1.806> <0.838, 2.625, -1.823> <0.817, 2.630, -1.829> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.778, 2.612, -1.755> <0.777, 2.604, -1.750> <0.768, 2.591, -1.743> <0.774, 2.586, -1.738> 
		<0.782, 2.604, -1.766> <0.781, 2.596, -1.761> <0.774, 2.579, -1.760> <0.779, 2.574, -1.754> 
		<0.790, 2.600, -1.785> <0.791, 2.591, -1.786> <0.784, 2.574, -1.785> <0.791, 2.568, -1.783> 
		<0.796, 2.603, -1.798> <0.797, 2.593, -1.799> <0.793, 2.578, -1.804> <0.800, 2.572, -1.802> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.774, 2.586, -1.738> <0.785, 2.575, -1.726> <0.808, 2.565, -1.712> <0.826, 2.568, -1.707> 
		<0.779, 2.574, -1.754> <0.791, 2.564, -1.743> <0.814, 2.552, -1.731> <0.832, 2.554, -1.726> 
		<0.791, 2.568, -1.783> <0.805, 2.556, -1.779> <0.829, 2.544, -1.767> <0.846, 2.547, -1.759> 
		<0.800, 2.572, -1.802> <0.814, 2.560, -1.798> <0.839, 2.548, -1.789> <0.856, 2.551, -1.780> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.826, 2.568, -1.707> <0.836, 2.569, -1.705> <0.851, 2.588, -1.713> <0.846, 2.594, -1.720> 
		<0.832, 2.554, -1.726> <0.843, 2.555, -1.724> <0.856, 2.579, -1.726> <0.850, 2.585, -1.732> 
		<0.846, 2.547, -1.759> <0.855, 2.549, -1.754> <0.866, 2.573, -1.752> <0.859, 2.580, -1.755> 
		<0.856, 2.551, -1.780> <0.865, 2.553, -1.776> <0.873, 2.576, -1.767> <0.866, 2.583, -1.769> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.846, 2.594, -1.720> <0.833, 2.607, -1.733> <0.801, 2.608, -1.744> <0.782, 2.614, -1.755> 
		<0.850, 2.585, -1.732> <0.837, 2.598, -1.746> <0.805, 2.601, -1.755> <0.786, 2.607, -1.766> 
		<0.859, 2.580, -1.755> <0.843, 2.596, -1.759> <0.813, 2.596, -1.776> <0.793, 2.603, -1.784> 
		<0.866, 2.583, -1.769> <0.849, 2.599, -1.773> <0.819, 2.599, -1.788> <0.799, 2.605, -1.796> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.773, 2.651, -1.729> <0.770, 2.649, -1.720> <0.760, 2.647, -1.706> <0.765, 2.645, -1.699> 
		<0.772, 2.637, -1.732> <0.770, 2.635, -1.723> <0.759, 2.626, -1.711> <0.764, 2.624, -1.703> 
		<0.774, 2.620, -1.743> <0.773, 2.612, -1.738> <0.763, 2.603, -1.726> <0.768, 2.598, -1.721> 
		<0.778, 2.612, -1.755> <0.777, 2.604, -1.750> <0.768, 2.591, -1.743> <0.774, 2.586, -1.738> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.765, 2.645, -1.699> <0.776, 2.641, -1.683> <0.798, 2.636, -1.665> <0.816, 2.634, -1.663> 
		<0.764, 2.624, -1.703> <0.775, 2.620, -1.688> <0.797, 2.612, -1.671> <0.815, 2.611, -1.669> 
		<0.768, 2.598, -1.721> <0.779, 2.587, -1.710> <0.801, 2.579, -1.693> <0.820, 2.581, -1.688> 
		<0.774, 2.586, -1.738> <0.785, 2.575, -1.726> <0.808, 2.565, -1.712> <0.826, 2.568, -1.707> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.816, 2.634, -1.663> <0.827, 2.634, -1.662> <0.844, 2.637, -1.681> <0.839, 2.639, -1.690> 
		<0.815, 2.611, -1.669> <0.826, 2.610, -1.667> <0.844, 2.621, -1.685> <0.838, 2.624, -1.693> 
		<0.820, 2.581, -1.688> <0.830, 2.582, -1.686> <0.847, 2.597, -1.700> <0.841, 2.603, -1.707> 
		<0.826, 2.568, -1.707> <0.836, 2.569, -1.705> <0.851, 2.588, -1.713> <0.846, 2.594, -1.720> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.839, 2.639, -1.690> <0.828, 2.644, -1.709> <0.795, 2.648, -1.718> <0.777, 2.651, -1.730> 
		<0.838, 2.624, -1.693> <0.827, 2.628, -1.712> <0.795, 2.635, -1.721> <0.776, 2.638, -1.733> 
		<0.841, 2.603, -1.707> <0.829, 2.617, -1.720> <0.798, 2.616, -1.734> <0.778, 2.622, -1.744> 
		<0.846, 2.594, -1.720> <0.833, 2.607, -1.733> <0.801, 2.608, -1.744> <0.782, 2.614, -1.755> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.782, 2.697, -1.735> <0.781, 2.702, -1.727> <0.773, 2.712, -1.715> <0.779, 2.714, -1.708> 
		<0.777, 2.686, -1.728> <0.777, 2.691, -1.720> <0.767, 2.694, -1.705> <0.772, 2.696, -1.698> 
		<0.773, 2.665, -1.726> <0.771, 2.663, -1.717> <0.761, 2.667, -1.702> <0.766, 2.665, -1.694> 
		<0.773, 2.651, -1.729> <0.770, 2.649, -1.720> <0.760, 2.647, -1.706> <0.765, 2.645, -1.699> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.779, 2.714, -1.708> <0.791, 2.717, -1.694> <0.814, 2.718, -1.677> <0.832, 2.712, -1.674> 
		<0.772, 2.696, -1.698> <0.784, 2.700, -1.684> <0.807, 2.698, -1.665> <0.825, 2.693, -1.663> 
		<0.766, 2.665, -1.694> <0.777, 2.661, -1.679> <0.799, 2.659, -1.660> <0.817, 2.658, -1.658> 
		<0.765, 2.645, -1.699> <0.776, 2.641, -1.683> <0.798, 2.636, -1.665> <0.816, 2.634, -1.663> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.832, 2.712, -1.674> <0.842, 2.709, -1.672> <0.856, 2.695, -1.689> <0.850, 2.692, -1.697> 
		<0.825, 2.693, -1.663> <0.835, 2.690, -1.661> <0.851, 2.681, -1.681> <0.844, 2.679, -1.689> 
		<0.817, 2.658, -1.658> <0.828, 2.657, -1.656> <0.845, 2.653, -1.677> <0.840, 2.655, -1.686> 
		<0.816, 2.634, -1.663> <0.827, 2.634, -1.662> <0.844, 2.637, -1.681> <0.839, 2.639, -1.690> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.850, 2.692, -1.697> <0.837, 2.687, -1.715> <0.805, 2.694, -1.724> <0.786, 2.695, -1.736> 
		<0.844, 2.679, -1.689> <0.831, 2.674, -1.707> <0.800, 2.683, -1.718> <0.781, 2.684, -1.730> 
		<0.840, 2.655, -1.686> <0.828, 2.660, -1.705> <0.796, 2.661, -1.715> <0.777, 2.665, -1.727> 
		<0.839, 2.639, -1.690> <0.828, 2.644, -1.709> <0.795, 2.648, -1.718> <0.777, 2.651, -1.730> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.801, 2.723, -1.770> <0.803, 2.732, -1.767> <0.800, 2.749, -1.765> <0.808, 2.752, -1.761> 
		<0.795, 2.720, -1.757> <0.797, 2.729, -1.754> <0.791, 2.745, -1.746> <0.799, 2.748, -1.742> 
		<0.786, 2.709, -1.742> <0.786, 2.714, -1.734> <0.780, 2.729, -1.725> <0.786, 2.731, -1.718> 
		<0.782, 2.697, -1.735> <0.781, 2.702, -1.727> <0.773, 2.712, -1.715> <0.779, 2.714, -1.708> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.808, 2.752, -1.761> <0.823, 2.760, -1.752> <0.848, 2.764, -1.739> <0.865, 2.756, -1.733> 
		<0.799, 2.748, -1.742> <0.814, 2.756, -1.733> <0.838, 2.760, -1.718> <0.855, 2.752, -1.712> 
		<0.786, 2.731, -1.718> <0.798, 2.735, -1.704> <0.822, 2.738, -1.688> <0.840, 2.732, -1.685> 
		<0.779, 2.714, -1.708> <0.791, 2.717, -1.694> <0.814, 2.718, -1.677> <0.832, 2.712, -1.674> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.865, 2.756, -1.733> <0.874, 2.752, -1.730> <0.880, 2.727, -1.732> <0.872, 2.722, -1.737> 
		<0.855, 2.752, -1.712> <0.864, 2.748, -1.708> <0.873, 2.724, -1.718> <0.865, 2.719, -1.723> 
		<0.840, 2.732, -1.685> <0.850, 2.729, -1.684> <0.861, 2.708, -1.696> <0.855, 2.706, -1.705> 
		<0.832, 2.712, -1.674> <0.842, 2.709, -1.672> <0.856, 2.695, -1.689> <0.850, 2.692, -1.697> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.872, 2.722, -1.737> <0.854, 2.712, -1.747> <0.824, 2.720, -1.760> <0.804, 2.720, -1.769> 
		<0.865, 2.719, -1.723> <0.848, 2.709, -1.733> <0.818, 2.718, -1.748> <0.798, 2.717, -1.757> 
		<0.855, 2.706, -1.705> <0.842, 2.701, -1.722> <0.809, 2.705, -1.731> <0.790, 2.706, -1.743> 
		<0.850, 2.692, -1.697> <0.837, 2.687, -1.715> <0.805, 2.694, -1.724> <0.786, 2.695, -1.736> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.818, 2.714, -1.813> <0.823, 2.721, -1.817> <0.825, 2.735, -1.826> <0.834, 2.738, -1.825> 
		<0.814, 2.722, -1.802> <0.819, 2.729, -1.805> <0.819, 2.747, -1.809> <0.828, 2.750, -1.808> 
		<0.807, 2.726, -1.783> <0.809, 2.735, -1.780> <0.809, 2.752, -1.784> <0.817, 2.756, -1.780> 
		<0.801, 2.723, -1.770> <0.803, 2.732, -1.767> <0.800, 2.749, -1.765> <0.808, 2.752, -1.761> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.834, 2.738, -1.825> <0.852, 2.744, -1.824> <0.879, 2.747, -1.816> <0.894, 2.740, -1.806> 
		<0.828, 2.750, -1.808> <0.846, 2.756, -1.807> <0.873, 2.761, -1.797> <0.888, 2.754, -1.787> 
		<0.817, 2.756, -1.780> <0.832, 2.764, -1.771> <0.858, 2.769, -1.761> <0.875, 2.761, -1.755> 
		<0.808, 2.752, -1.761> <0.823, 2.760, -1.752> <0.848, 2.764, -1.739> <0.865, 2.756, -1.733> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.894, 2.740, -1.806> <0.902, 2.736, -1.801> <0.901, 2.715, -1.786> <0.892, 2.711, -1.787> 
		<0.888, 2.754, -1.787> <0.896, 2.750, -1.782> <0.897, 2.724, -1.773> <0.887, 2.720, -1.774> 
		<0.875, 2.761, -1.755> <0.884, 2.757, -1.751> <0.886, 2.730, -1.747> <0.878, 2.725, -1.752> 
		<0.865, 2.756, -1.733> <0.874, 2.752, -1.730> <0.880, 2.727, -1.732> <0.872, 2.722, -1.737> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.892, 2.711, -1.787> <0.871, 2.703, -1.788> <0.842, 2.711, -1.803> <0.820, 2.711, -1.810> 
		<0.887, 2.720, -1.774> <0.866, 2.712, -1.775> <0.838, 2.718, -1.793> <0.816, 2.718, -1.800> 
		<0.878, 2.725, -1.752> <0.861, 2.715, -1.762> <0.830, 2.723, -1.772> <0.809, 2.722, -1.781> 
		<0.872, 2.722, -1.737> <0.854, 2.712, -1.747> <0.824, 2.720, -1.760> <0.804, 2.720, -1.769> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.824, 2.674, -1.839> <0.829, 2.676, -1.846> <0.833, 2.679, -1.863> <0.842, 2.679, -1.864> 
		<0.825, 2.688, -1.836> <0.830, 2.690, -1.843> <0.834, 2.700, -1.858> <0.843, 2.700, -1.859> 
		<0.822, 2.706, -1.824> <0.827, 2.713, -1.828> <0.831, 2.723, -1.843> <0.839, 2.726, -1.842> 
		<0.818, 2.714, -1.813> <0.823, 2.721, -1.817> <0.825, 2.735, -1.826> <0.834, 2.738, -1.825> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.842, 2.679, -1.864> <0.861, 2.679, -1.867> <0.890, 2.677, -1.863> <0.904, 2.674, -1.851> 
		<0.843, 2.700, -1.859> <0.862, 2.700, -1.862> <0.891, 2.700, -1.857> <0.905, 2.697, -1.845> 
		<0.839, 2.726, -1.842> <0.857, 2.733, -1.840> <0.886, 2.734, -1.835> <0.901, 2.727, -1.825> 
		<0.834, 2.738, -1.825> <0.852, 2.744, -1.824> <0.879, 2.747, -1.816> <0.894, 2.740, -1.806> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.904, 2.674, -1.851> <0.912, 2.672, -1.844> <0.908, 2.666, -1.819> <0.898, 2.666, -1.817> 
		<0.905, 2.697, -1.845> <0.913, 2.695, -1.838> <0.909, 2.682, -1.815> <0.899, 2.682, -1.813> 
		<0.901, 2.727, -1.825> <0.909, 2.723, -1.820> <0.906, 2.706, -1.799> <0.896, 2.702, -1.800> 
		<0.894, 2.740, -1.806> <0.902, 2.736, -1.801> <0.901, 2.715, -1.786> <0.892, 2.711, -1.787> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.898, 2.666, -1.817> <0.876, 2.666, -1.812> <0.847, 2.671, -1.829> <0.825, 2.673, -1.835> 
		<0.899, 2.682, -1.813> <0.877, 2.682, -1.808> <0.848, 2.684, -1.826> <0.826, 2.687, -1.832> 
		<0.896, 2.702, -1.800> <0.875, 2.694, -1.801> <0.845, 2.703, -1.814> <0.824, 2.703, -1.821> 
		<0.892, 2.711, -1.787> <0.871, 2.703, -1.788> <0.842, 2.711, -1.803> <0.820, 2.711, -1.810> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.815, 2.628, -1.833> <0.819, 2.623, -1.839> <0.820, 2.614, -1.854> <0.828, 2.610, -1.855> 
		<0.819, 2.640, -1.839> <0.823, 2.635, -1.846> <0.827, 2.632, -1.864> <0.835, 2.628, -1.865> 
		<0.823, 2.661, -1.842> <0.829, 2.662, -1.850> <0.832, 2.659, -1.867> <0.841, 2.659, -1.869> 
		<0.824, 2.674, -1.839> <0.829, 2.676, -1.846> <0.833, 2.679, -1.863> <0.842, 2.679, -1.864> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.828, 2.610, -1.855> <0.846, 2.603, -1.856> <0.873, 2.595, -1.851> <0.888, 2.595, -1.840> 
		<0.835, 2.628, -1.865> <0.852, 2.620, -1.866> <0.881, 2.614, -1.863> <0.896, 2.615, -1.851> 
		<0.841, 2.659, -1.869> <0.860, 2.658, -1.872> <0.889, 2.653, -1.868> <0.903, 2.650, -1.856> 
		<0.842, 2.679, -1.864> <0.861, 2.679, -1.867> <0.890, 2.677, -1.863> <0.904, 2.674, -1.851> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.888, 2.595, -1.840> <0.896, 2.596, -1.833> <0.897, 2.609, -1.811> <0.887, 2.613, -1.809> 
		<0.896, 2.615, -1.851> <0.904, 2.616, -1.845> <0.902, 2.622, -1.818> <0.893, 2.627, -1.817> 
		<0.903, 2.650, -1.856> <0.911, 2.648, -1.849> <0.908, 2.650, -1.822> <0.897, 2.650, -1.820> 
		<0.904, 2.674, -1.851> <0.912, 2.672, -1.844> <0.908, 2.666, -1.819> <0.898, 2.666, -1.817> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.887, 2.613, -1.809> <0.867, 2.623, -1.806> <0.838, 2.625, -1.823> <0.817, 2.630, -1.829> 
		<0.893, 2.627, -1.817> <0.872, 2.636, -1.814> <0.842, 2.636, -1.829> <0.821, 2.641, -1.835> 
		<0.897, 2.650, -1.820> <0.875, 2.650, -1.816> <0.847, 2.658, -1.832> <0.825, 2.660, -1.838> 
		<0.898, 2.666, -1.817> <0.876, 2.666, -1.812> <0.847, 2.671, -1.829> <0.825, 2.673, -1.835> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.644, 2.634, -1.958> <0.643, 2.624, -1.958> <0.644, 2.609, -1.965> <0.640, 2.603, -1.959> 
		<0.657, 2.632, -1.952> <0.656, 2.623, -1.952> <0.663, 2.606, -1.956> <0.659, 2.600, -1.950> 
		<0.675, 2.637, -1.942> <0.680, 2.630, -1.939> <0.687, 2.613, -1.943> <0.686, 2.608, -1.936> 
		<0.684, 2.646, -1.936> <0.689, 2.638, -1.933> <0.701, 2.626, -1.934> <0.701, 2.620, -1.926> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.640, 2.603, -1.959> <0.633, 2.590, -1.947> <0.621, 2.577, -1.925> <0.613, 2.579, -1.907> 
		<0.659, 2.600, -1.950> <0.652, 2.587, -1.939> <0.642, 2.574, -1.915> <0.635, 2.576, -1.897> 
		<0.686, 2.608, -1.936> <0.686, 2.597, -1.920> <0.676, 2.584, -1.896> <0.665, 2.585, -1.881> 
		<0.701, 2.620, -1.926> <0.700, 2.609, -1.911> <0.693, 2.598, -1.885> <0.681, 2.599, -1.870> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.613, 2.579, -1.907> <0.609, 2.580, -1.898> <0.607, 2.603, -1.885> <0.610, 2.611, -1.891> 
		<0.635, 2.576, -1.897> <0.631, 2.577, -1.888> <0.621, 2.601, -1.879> <0.625, 2.608, -1.885> 
		<0.665, 2.585, -1.881> <0.659, 2.585, -1.872> <0.646, 2.608, -1.865> <0.646, 2.614, -1.873> 
		<0.681, 2.599, -1.870> <0.675, 2.600, -1.861> <0.657, 2.618, -1.858> <0.657, 2.624, -1.866> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.610, 2.611, -1.891> <0.619, 2.627, -1.905> <0.633, 2.629, -1.935> <0.643, 2.636, -1.954> 
		<0.625, 2.608, -1.885> <0.634, 2.625, -1.898> <0.645, 2.627, -1.930> <0.655, 2.634, -1.949> 
		<0.646, 2.614, -1.873> <0.646, 2.628, -1.891> <0.665, 2.632, -1.919> <0.672, 2.639, -1.939> 
		<0.657, 2.624, -1.866> <0.657, 2.638, -1.884> <0.674, 2.640, -1.913> <0.681, 2.648, -1.933> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.606, 2.657, -1.972> <0.599, 2.651, -1.974> <0.589, 2.642, -1.985> <0.582, 2.638, -1.980> 
		<0.614, 2.646, -1.970> <0.607, 2.640, -1.972> <0.602, 2.626, -1.982> <0.595, 2.621, -1.977> 
		<0.631, 2.636, -1.964> <0.630, 2.626, -1.964> <0.625, 2.612, -1.974> <0.621, 2.605, -1.968> 
		<0.644, 2.634, -1.958> <0.643, 2.624, -1.958> <0.644, 2.609, -1.965> <0.640, 2.603, -1.959> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.582, 2.638, -1.980> <0.569, 2.629, -1.971> <0.551, 2.619, -1.950> <0.547, 2.619, -1.931> 
		<0.595, 2.621, -1.977> <0.581, 2.612, -1.968> <0.566, 2.600, -1.946> <0.562, 2.600, -1.928> 
		<0.621, 2.605, -1.968> <0.614, 2.593, -1.956> <0.599, 2.580, -1.935> <0.591, 2.582, -1.917> 
		<0.640, 2.603, -1.959> <0.633, 2.590, -1.947> <0.621, 2.577, -1.925> <0.613, 2.579, -1.907> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.547, 2.619, -1.931> <0.545, 2.619, -1.921> <0.558, 2.632, -1.903> <0.566, 2.638, -1.908> 
		<0.562, 2.600, -1.928> <0.560, 2.600, -1.918> <0.568, 2.620, -1.901> <0.576, 2.625, -1.905> 
		<0.591, 2.582, -1.917> <0.587, 2.583, -1.908> <0.592, 2.605, -1.892> <0.596, 2.613, -1.898> 
		<0.613, 2.579, -1.907> <0.609, 2.580, -1.898> <0.607, 2.603, -1.885> <0.610, 2.611, -1.891> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.566, 2.638, -1.908> <0.583, 2.649, -1.918> <0.594, 2.652, -1.950> <0.606, 2.659, -1.968> 
		<0.576, 2.625, -1.905> <0.593, 2.636, -1.916> <0.602, 2.642, -1.948> <0.614, 2.648, -1.966> 
		<0.596, 2.613, -1.898> <0.604, 2.629, -1.912> <0.621, 2.630, -1.941> <0.631, 2.638, -1.960> 
		<0.610, 2.611, -1.891> <0.619, 2.627, -1.905> <0.633, 2.629, -1.935> <0.643, 2.636, -1.954> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.591, 2.702, -1.969> <0.582, 2.703, -1.972> <0.568, 2.706, -1.982> <0.560, 2.705, -1.977> 
		<0.590, 2.689, -1.973> <0.581, 2.689, -1.975> <0.568, 2.685, -1.986> <0.560, 2.685, -1.981> 
		<0.597, 2.668, -1.974> <0.590, 2.663, -1.976> <0.576, 2.659, -1.988> <0.569, 2.655, -1.983> 
		<0.606, 2.657, -1.972> <0.599, 2.651, -1.974> <0.589, 2.642, -1.985> <0.582, 2.638, -1.980> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.560, 2.705, -1.977> <0.544, 2.704, -1.967> <0.525, 2.700, -1.945> <0.523, 2.696, -1.927> 
		<0.560, 2.685, -1.981> <0.544, 2.683, -1.972> <0.524, 2.676, -1.951> <0.522, 2.672, -1.933> 
		<0.569, 2.655, -1.983> <0.556, 2.646, -1.973> <0.537, 2.638, -1.953> <0.533, 2.638, -1.934> 
		<0.582, 2.638, -1.980> <0.569, 2.629, -1.971> <0.551, 2.619, -1.950> <0.547, 2.619, -1.931> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.523, 2.696, -1.927> <0.521, 2.693, -1.917> <0.540, 2.689, -1.900> <0.549, 2.689, -1.905> 
		<0.522, 2.672, -1.933> <0.520, 2.670, -1.922> <0.539, 2.673, -1.903> <0.549, 2.673, -1.909> 
		<0.533, 2.638, -1.934> <0.530, 2.638, -1.924> <0.548, 2.645, -1.905> <0.556, 2.650, -1.910> 
		<0.547, 2.619, -1.931> <0.545, 2.619, -1.921> <0.558, 2.632, -1.903> <0.566, 2.638, -1.908> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.549, 2.689, -1.905> <0.569, 2.691, -1.916> <0.580, 2.698, -1.947> <0.592, 2.701, -1.965> 
		<0.549, 2.673, -1.909> <0.568, 2.675, -1.919> <0.579, 2.685, -1.950> <0.592, 2.688, -1.968> 
		<0.556, 2.650, -1.910> <0.573, 2.662, -1.920> <0.586, 2.663, -1.951> <0.598, 2.669, -1.969> 
		<0.566, 2.638, -1.908> <0.583, 2.649, -1.918> <0.594, 2.652, -1.950> <0.606, 2.659, -1.968> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.609, 2.743, -1.952> <0.603, 2.750, -1.952> <0.594, 2.763, -1.957> <0.588, 2.766, -1.951> 
		<0.600, 2.734, -1.959> <0.593, 2.741, -1.958> <0.580, 2.751, -1.967> <0.574, 2.753, -1.960> 
		<0.592, 2.716, -1.966> <0.582, 2.717, -1.968> <0.569, 2.727, -1.977> <0.561, 2.726, -1.972> 
		<0.591, 2.702, -1.969> <0.582, 2.703, -1.972> <0.568, 2.706, -1.982> <0.560, 2.705, -1.977> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.588, 2.766, -1.951> <0.575, 2.771, -1.938> <0.558, 2.772, -1.914> <0.554, 2.764, -1.898> 
		<0.574, 2.753, -1.960> <0.560, 2.758, -1.948> <0.542, 2.757, -1.925> <0.537, 2.750, -1.909> 
		<0.561, 2.726, -1.972> <0.545, 2.725, -1.962> <0.526, 2.723, -1.940> <0.524, 2.719, -1.922> 
		<0.560, 2.705, -1.977> <0.544, 2.704, -1.967> <0.525, 2.700, -1.945> <0.523, 2.696, -1.927> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.554, 2.764, -1.898> <0.551, 2.760, -1.888> <0.563, 2.739, -1.878> <0.570, 2.736, -1.885> 
		<0.537, 2.750, -1.909> <0.535, 2.745, -1.899> <0.552, 2.729, -1.886> <0.559, 2.726, -1.892> 
		<0.524, 2.719, -1.922> <0.522, 2.717, -1.911> <0.541, 2.705, -1.896> <0.550, 2.705, -1.901> 
		<0.523, 2.696, -1.927> <0.521, 2.693, -1.917> <0.540, 2.689, -1.900> <0.549, 2.689, -1.905> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.570, 2.736, -1.885> <0.586, 2.729, -1.900> <0.598, 2.738, -1.930> <0.610, 2.740, -1.949> 
		<0.559, 2.726, -1.892> <0.575, 2.719, -1.907> <0.589, 2.730, -1.936> <0.601, 2.732, -1.955> 
		<0.550, 2.705, -1.901> <0.570, 2.707, -1.912> <0.580, 2.711, -1.944> <0.593, 2.715, -1.962> 
		<0.549, 2.689, -1.905> <0.569, 2.691, -1.916> <0.580, 2.698, -1.947> <0.592, 2.701, -1.965> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.649, 2.754, -1.930> <0.649, 2.763, -1.926> <0.651, 2.780, -1.926> <0.648, 2.783, -1.918> 
		<0.637, 2.756, -1.936> <0.636, 2.765, -1.932> <0.632, 2.783, -1.935> <0.629, 2.786, -1.926> 
		<0.619, 2.751, -1.946> <0.612, 2.758, -1.945> <0.609, 2.776, -1.948> <0.602, 2.778, -1.941> 
		<0.609, 2.743, -1.952> <0.603, 2.750, -1.952> <0.594, 2.763, -1.957> <0.588, 2.766, -1.951> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.648, 2.783, -1.918> <0.642, 2.790, -1.901> <0.630, 2.793, -1.875> <0.622, 2.784, -1.860> 
		<0.629, 2.786, -1.926> <0.622, 2.793, -1.910> <0.608, 2.796, -1.885> <0.600, 2.787, -1.870> 
		<0.602, 2.778, -1.941> <0.589, 2.783, -1.928> <0.574, 2.786, -1.904> <0.570, 2.778, -1.887> 
		<0.588, 2.766, -1.951> <0.575, 2.771, -1.938> <0.558, 2.772, -1.914> <0.554, 2.764, -1.898> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.622, 2.784, -1.860> <0.617, 2.779, -1.852> <0.613, 2.754, -1.851> <0.616, 2.749, -1.860> 
		<0.600, 2.787, -1.870> <0.596, 2.782, -1.862> <0.598, 2.756, -1.857> <0.602, 2.751, -1.866> 
		<0.570, 2.778, -1.887> <0.567, 2.774, -1.878> <0.574, 2.749, -1.871> <0.581, 2.745, -1.878> 
		<0.554, 2.764, -1.898> <0.551, 2.760, -1.888> <0.563, 2.739, -1.878> <0.570, 2.736, -1.885> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.616, 2.749, -1.860> <0.624, 2.740, -1.879> <0.639, 2.750, -1.908> <0.648, 2.751, -1.928> 
		<0.602, 2.751, -1.866> <0.609, 2.742, -1.886> <0.626, 2.752, -1.913> <0.636, 2.753, -1.934> 
		<0.581, 2.745, -1.878> <0.597, 2.738, -1.892> <0.607, 2.746, -1.924> <0.619, 2.748, -1.943> 
		<0.570, 2.736, -1.885> <0.586, 2.729, -1.900> <0.598, 2.738, -1.930> <0.610, 2.740, -1.949> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.688, 2.731, -1.916> <0.694, 2.736, -1.910> <0.706, 2.747, -1.906> <0.706, 2.748, -1.897> 
		<0.680, 2.742, -1.918> <0.685, 2.747, -1.912> <0.693, 2.763, -1.909> <0.693, 2.765, -1.900> 
		<0.662, 2.753, -1.924> <0.662, 2.761, -1.920> <0.671, 2.777, -1.917> <0.667, 2.781, -1.909> 
		<0.649, 2.754, -1.930> <0.649, 2.763, -1.926> <0.651, 2.780, -1.926> <0.648, 2.783, -1.918> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.706, 2.748, -1.897> <0.706, 2.751, -1.878> <0.699, 2.751, -1.850> <0.688, 2.744, -1.836> 
		<0.693, 2.765, -1.900> <0.693, 2.768, -1.881> <0.685, 2.770, -1.853> <0.673, 2.763, -1.840> 
		<0.667, 2.781, -1.909> <0.661, 2.788, -1.892> <0.652, 2.790, -1.865> <0.644, 2.781, -1.850> 
		<0.648, 2.783, -1.918> <0.642, 2.790, -1.901> <0.630, 2.793, -1.875> <0.622, 2.784, -1.860> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.688, 2.744, -1.836> <0.681, 2.740, -1.829> <0.661, 2.724, -1.833> <0.661, 2.722, -1.844> 
		<0.673, 2.763, -1.840> <0.667, 2.759, -1.832> <0.651, 2.737, -1.835> <0.651, 2.735, -1.846> 
		<0.644, 2.781, -1.850> <0.639, 2.776, -1.842> <0.628, 2.751, -1.844> <0.631, 2.747, -1.853> 
		<0.622, 2.784, -1.860> <0.617, 2.779, -1.852> <0.613, 2.754, -1.851> <0.616, 2.749, -1.860> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.661, 2.722, -1.844> <0.660, 2.718, -1.866> <0.678, 2.727, -1.893> <0.685, 2.728, -1.915> 
		<0.651, 2.735, -1.846> <0.650, 2.731, -1.868> <0.669, 2.737, -1.895> <0.677, 2.739, -1.917> 
		<0.631, 2.747, -1.853> <0.639, 2.738, -1.872> <0.651, 2.749, -1.902> <0.660, 2.749, -1.922> 
		<0.616, 2.749, -1.860> <0.624, 2.740, -1.879> <0.639, 2.750, -1.908> <0.648, 2.751, -1.928> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.703, 2.686, -1.918> <0.710, 2.684, -1.913> <0.727, 2.683, -1.909> <0.728, 2.681, -1.900> 
		<0.703, 2.700, -1.915> <0.711, 2.698, -1.910> <0.728, 2.703, -1.905> <0.729, 2.701, -1.895> 
		<0.697, 2.720, -1.914> <0.702, 2.725, -1.908> <0.719, 2.730, -1.903> <0.719, 2.731, -1.894> 
		<0.688, 2.731, -1.916> <0.694, 2.736, -1.910> <0.706, 2.747, -1.906> <0.706, 2.748, -1.897> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.728, 2.681, -1.900> <0.730, 2.676, -1.882> <0.725, 2.670, -1.854> <0.712, 2.668, -1.840> 
		<0.729, 2.701, -1.895> <0.731, 2.697, -1.877> <0.726, 2.694, -1.849> <0.713, 2.691, -1.835> 
		<0.719, 2.731, -1.894> <0.719, 2.735, -1.875> <0.714, 2.732, -1.847> <0.702, 2.725, -1.833> 
		<0.706, 2.748, -1.897> <0.706, 2.751, -1.878> <0.699, 2.751, -1.850> <0.688, 2.744, -1.836> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.712, 2.668, -1.840> <0.705, 2.666, -1.833> <0.680, 2.668, -1.836> <0.678, 2.670, -1.846> 
		<0.713, 2.691, -1.835> <0.706, 2.690, -1.827> <0.680, 2.684, -1.832> <0.678, 2.686, -1.843> 
		<0.702, 2.725, -1.833> <0.696, 2.721, -1.826> <0.671, 2.711, -1.831> <0.671, 2.709, -1.841> 
		<0.688, 2.744, -1.836> <0.681, 2.740, -1.829> <0.661, 2.724, -1.833> <0.661, 2.722, -1.844> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.678, 2.670, -1.846> <0.674, 2.675, -1.868> <0.692, 2.681, -1.896> <0.699, 2.686, -1.917> 
		<0.678, 2.686, -1.843> <0.674, 2.691, -1.864> <0.693, 2.694, -1.893> <0.699, 2.699, -1.914> 
		<0.671, 2.709, -1.841> <0.670, 2.705, -1.864> <0.686, 2.716, -1.892> <0.693, 2.718, -1.913> 
		<0.661, 2.722, -1.844> <0.660, 2.718, -1.866> <0.678, 2.727, -1.893> <0.685, 2.728, -1.915> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.684, 2.646, -1.936> <0.689, 2.638, -1.933> <0.701, 2.626, -1.934> <0.701, 2.620, -1.926> 
		<0.694, 2.654, -1.929> <0.699, 2.646, -1.926> <0.715, 2.638, -1.924> <0.715, 2.633, -1.917> 
		<0.702, 2.672, -1.922> <0.710, 2.670, -1.916> <0.726, 2.662, -1.914> <0.727, 2.660, -1.905> 
		<0.703, 2.686, -1.918> <0.710, 2.684, -1.913> <0.727, 2.683, -1.909> <0.728, 2.681, -1.900> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.701, 2.620, -1.926> <0.700, 2.609, -1.911> <0.693, 2.598, -1.885> <0.681, 2.599, -1.870> 
		<0.715, 2.633, -1.917> <0.714, 2.622, -1.901> <0.709, 2.613, -1.874> <0.698, 2.614, -1.859> 
		<0.727, 2.660, -1.905> <0.729, 2.656, -1.887> <0.724, 2.647, -1.860> <0.711, 2.644, -1.846> 
		<0.728, 2.681, -1.900> <0.730, 2.676, -1.882> <0.725, 2.670, -1.854> <0.712, 2.668, -1.840> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.681, 2.599, -1.870> <0.675, 2.600, -1.861> <0.657, 2.618, -1.858> <0.657, 2.624, -1.866> 
		<0.698, 2.614, -1.859> <0.691, 2.614, -1.850> <0.668, 2.627, -1.850> <0.668, 2.634, -1.859> 
		<0.711, 2.644, -1.846> <0.704, 2.643, -1.838> <0.679, 2.652, -1.840> <0.677, 2.654, -1.850> 
		<0.712, 2.668, -1.840> <0.705, 2.666, -1.833> <0.680, 2.668, -1.836> <0.678, 2.670, -1.846> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.657, 2.624, -1.866> <0.657, 2.638, -1.884> <0.674, 2.640, -1.913> <0.681, 2.648, -1.933> 
		<0.668, 2.634, -1.859> <0.668, 2.647, -1.877> <0.683, 2.649, -1.907> <0.690, 2.656, -1.927> 
		<0.677, 2.654, -1.850> <0.673, 2.660, -1.872> <0.692, 2.668, -1.899> <0.698, 2.673, -1.920> 
		<0.678, 2.670, -1.846> <0.674, 2.675, -1.868> <0.692, 2.681, -1.896> <0.699, 2.686, -1.917> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.836, 2.441, -1.390> <1.834, 2.432, -1.391> <1.835, 2.416, -1.398> <1.832, 2.410, -1.392> 
		<1.848, 2.439, -1.384> <1.847, 2.430, -1.385> <1.854, 2.414, -1.389> <1.851, 2.407, -1.383> 
		<1.866, 2.445, -1.374> <1.871, 2.437, -1.372> <1.878, 2.420, -1.376> <1.878, 2.415, -1.368> 
		<1.876, 2.453, -1.368> <1.881, 2.445, -1.365> <1.892, 2.433, -1.366> <1.892, 2.428, -1.358> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.832, 2.410, -1.392> <1.824, 2.397, -1.380> <1.812, 2.384, -1.357> <1.804, 2.386, -1.340> 
		<1.851, 2.407, -1.383> <1.843, 2.394, -1.371> <1.834, 2.381, -1.347> <1.826, 2.383, -1.330> 
		<1.878, 2.415, -1.368> <1.877, 2.404, -1.353> <1.868, 2.391, -1.328> <1.857, 2.392, -1.313> 
		<1.892, 2.428, -1.358> <1.891, 2.417, -1.343> <1.884, 2.406, -1.317> <1.873, 2.407, -1.302> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.804, 2.386, -1.340> <1.800, 2.388, -1.330> <1.798, 2.410, -1.318> <1.802, 2.418, -1.324> 
		<1.826, 2.383, -1.330> <1.822, 2.384, -1.320> <1.813, 2.408, -1.311> <1.817, 2.416, -1.317> 
		<1.857, 2.392, -1.313> <1.850, 2.393, -1.304> <1.837, 2.415, -1.297> <1.837, 2.422, -1.306> 
		<1.873, 2.407, -1.302> <1.866, 2.407, -1.294> <1.848, 2.425, -1.290> <1.848, 2.432, -1.298> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.802, 2.418, -1.324> <1.810, 2.434, -1.337> <1.825, 2.436, -1.368> <1.834, 2.444, -1.387> 
		<1.817, 2.416, -1.317> <1.825, 2.432, -1.330> <1.837, 2.434, -1.362> <1.846, 2.442, -1.381> 
		<1.837, 2.422, -1.306> <1.837, 2.435, -1.324> <1.856, 2.440, -1.352> <1.864, 2.447, -1.372> 
		<1.848, 2.432, -1.298> <1.848, 2.445, -1.316> <1.865, 2.448, -1.346> <1.873, 2.455, -1.366> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.797, 2.465, -1.404> <1.790, 2.459, -1.407> <1.780, 2.450, -1.417> <1.773, 2.445, -1.413> 
		<1.805, 2.454, -1.402> <1.798, 2.448, -1.405> <1.793, 2.433, -1.415> <1.786, 2.429, -1.410> 
		<1.823, 2.443, -1.396> <1.821, 2.434, -1.396> <1.816, 2.419, -1.406> <1.812, 2.413, -1.400> 
		<1.836, 2.441, -1.390> <1.834, 2.432, -1.391> <1.835, 2.416, -1.398> <1.832, 2.410, -1.392> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.773, 2.445, -1.413> <1.760, 2.436, -1.403> <1.743, 2.427, -1.382> <1.739, 2.426, -1.363> 
		<1.786, 2.429, -1.410> <1.773, 2.420, -1.400> <1.757, 2.408, -1.379> <1.753, 2.408, -1.360> 
		<1.812, 2.413, -1.400> <1.805, 2.400, -1.389> <1.790, 2.388, -1.367> <1.783, 2.390, -1.350> 
		<1.832, 2.410, -1.392> <1.824, 2.397, -1.380> <1.812, 2.384, -1.357> <1.804, 2.386, -1.340> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.739, 2.426, -1.363> <1.736, 2.426, -1.353> <1.749, 2.440, -1.335> <1.757, 2.445, -1.340> 
		<1.753, 2.408, -1.360> <1.751, 2.407, -1.350> <1.759, 2.427, -1.333> <1.767, 2.432, -1.338> 
		<1.783, 2.390, -1.350> <1.778, 2.391, -1.340> <1.783, 2.413, -1.324> <1.787, 2.420, -1.331> 
		<1.804, 2.386, -1.340> <1.800, 2.388, -1.330> <1.798, 2.410, -1.318> <1.802, 2.418, -1.324> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.757, 2.445, -1.340> <1.774, 2.456, -1.350> <1.785, 2.460, -1.382> <1.798, 2.466, -1.400> 
		<1.767, 2.432, -1.338> <1.784, 2.443, -1.348> <1.794, 2.449, -1.380> <1.806, 2.455, -1.398> 
		<1.787, 2.420, -1.331> <1.796, 2.436, -1.344> <1.812, 2.438, -1.373> <1.822, 2.445, -1.392> 
		<1.802, 2.418, -1.324> <1.810, 2.434, -1.337> <1.825, 2.436, -1.368> <1.834, 2.444, -1.387> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.782, 2.510, -1.402> <1.773, 2.511, -1.404> <1.760, 2.514, -1.414> <1.752, 2.513, -1.409> 
		<1.782, 2.496, -1.405> <1.773, 2.497, -1.407> <1.759, 2.493, -1.419> <1.751, 2.492, -1.414> 
		<1.788, 2.476, -1.406> <1.781, 2.470, -1.409> <1.767, 2.466, -1.420> <1.761, 2.462, -1.415> 
		<1.797, 2.465, -1.404> <1.790, 2.459, -1.407> <1.780, 2.450, -1.417> <1.773, 2.445, -1.413> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.752, 2.513, -1.409> <1.736, 2.511, -1.399> <1.717, 2.507, -1.378> <1.714, 2.503, -1.359> 
		<1.751, 2.492, -1.414> <1.735, 2.490, -1.404> <1.716, 2.484, -1.383> <1.713, 2.480, -1.365> 
		<1.761, 2.462, -1.415> <1.747, 2.453, -1.406> <1.728, 2.445, -1.385> <1.724, 2.445, -1.367> 
		<1.773, 2.445, -1.413> <1.760, 2.436, -1.403> <1.743, 2.427, -1.382> <1.739, 2.426, -1.363> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.714, 2.503, -1.359> <1.712, 2.501, -1.349> <1.731, 2.496, -1.332> <1.741, 2.497, -1.337> 
		<1.713, 2.480, -1.365> <1.711, 2.477, -1.355> <1.731, 2.480, -1.336> <1.740, 2.481, -1.341> 
		<1.724, 2.445, -1.367> <1.722, 2.445, -1.356> <1.740, 2.453, -1.337> <1.747, 2.458, -1.342> 
		<1.739, 2.426, -1.363> <1.736, 2.426, -1.353> <1.749, 2.440, -1.335> <1.757, 2.445, -1.340> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.741, 2.497, -1.337> <1.760, 2.498, -1.348> <1.771, 2.505, -1.380> <1.784, 2.509, -1.398> 
		<1.740, 2.481, -1.341> <1.760, 2.482, -1.352> <1.770, 2.492, -1.383> <1.783, 2.496, -1.401> 
		<1.747, 2.458, -1.342> <1.764, 2.469, -1.352> <1.777, 2.470, -1.384> <1.789, 2.477, -1.402> 
		<1.757, 2.445, -1.340> <1.774, 2.456, -1.350> <1.785, 2.460, -1.382> <1.798, 2.466, -1.400> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.800, 2.550, -1.385> <1.794, 2.557, -1.384> <1.786, 2.571, -1.390> <1.779, 2.573, -1.383> 
		<1.791, 2.542, -1.391> <1.785, 2.548, -1.391> <1.771, 2.558, -1.399> <1.765, 2.560, -1.393> 
		<1.783, 2.524, -1.399> <1.774, 2.525, -1.401> <1.761, 2.534, -1.409> <1.753, 2.534, -1.404> 
		<1.782, 2.510, -1.402> <1.773, 2.511, -1.404> <1.760, 2.514, -1.414> <1.752, 2.513, -1.409> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.779, 2.573, -1.383> <1.766, 2.578, -1.370> <1.749, 2.579, -1.347> <1.745, 2.571, -1.330> 
		<1.765, 2.560, -1.393> <1.752, 2.565, -1.380> <1.733, 2.565, -1.358> <1.729, 2.557, -1.341> 
		<1.753, 2.534, -1.404> <1.737, 2.532, -1.394> <1.718, 2.531, -1.372> <1.715, 2.527, -1.354> 
		<1.752, 2.513, -1.409> <1.736, 2.511, -1.399> <1.717, 2.507, -1.378> <1.714, 2.503, -1.359> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.745, 2.571, -1.330> <1.742, 2.567, -1.321> <1.754, 2.546, -1.311> <1.762, 2.543, -1.317> 
		<1.729, 2.557, -1.341> <1.726, 2.553, -1.332> <1.743, 2.537, -1.318> <1.751, 2.533, -1.325> 
		<1.715, 2.527, -1.354> <1.713, 2.524, -1.344> <1.732, 2.512, -1.329> <1.741, 2.513, -1.334> 
		<1.714, 2.503, -1.359> <1.712, 2.501, -1.349> <1.731, 2.496, -1.332> <1.741, 2.497, -1.337> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.762, 2.543, -1.317> <1.777, 2.536, -1.332> <1.789, 2.546, -1.362> <1.801, 2.547, -1.381> 
		<1.751, 2.533, -1.325> <1.767, 2.526, -1.339> <1.780, 2.538, -1.368> <1.792, 2.539, -1.387> 
		<1.741, 2.513, -1.334> <1.761, 2.514, -1.344> <1.771, 2.518, -1.377> <1.784, 2.522, -1.395> 
		<1.741, 2.497, -1.337> <1.760, 2.498, -1.348> <1.771, 2.505, -1.380> <1.784, 2.509, -1.398> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.841, 2.562, -1.362> <1.840, 2.571, -1.359> <1.843, 2.587, -1.358> <1.839, 2.591, -1.350> 
		<1.828, 2.564, -1.368> <1.828, 2.572, -1.365> <1.823, 2.590, -1.367> <1.820, 2.594, -1.359> 
		<1.810, 2.558, -1.378> <1.804, 2.565, -1.378> <1.800, 2.583, -1.380> <1.793, 2.586, -1.374> 
		<1.800, 2.550, -1.385> <1.794, 2.557, -1.384> <1.786, 2.571, -1.390> <1.779, 2.573, -1.383> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.839, 2.591, -1.350> <1.833, 2.598, -1.334> <1.821, 2.600, -1.307> <1.813, 2.591, -1.293> 
		<1.820, 2.594, -1.359> <1.814, 2.601, -1.342> <1.799, 2.603, -1.317> <1.791, 2.595, -1.303> 
		<1.793, 2.586, -1.374> <1.780, 2.591, -1.361> <1.765, 2.593, -1.336> <1.761, 2.586, -1.319> 
		<1.779, 2.573, -1.383> <1.766, 2.578, -1.370> <1.749, 2.579, -1.347> <1.745, 2.571, -1.330> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.813, 2.591, -1.293> <1.809, 2.587, -1.284> <1.804, 2.561, -1.283> <1.808, 2.557, -1.292> 
		<1.791, 2.595, -1.303> <1.787, 2.590, -1.294> <1.790, 2.563, -1.290> <1.793, 2.559, -1.299> 
		<1.761, 2.586, -1.319> <1.758, 2.581, -1.310> <1.765, 2.556, -1.303> <1.772, 2.553, -1.310> 
		<1.745, 2.571, -1.330> <1.742, 2.567, -1.321> <1.754, 2.546, -1.311> <1.762, 2.543, -1.317> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.808, 2.557, -1.292> <1.815, 2.547, -1.311> <1.830, 2.558, -1.340> <1.839, 2.558, -1.360> 
		<1.793, 2.559, -1.299> <1.800, 2.549, -1.318> <1.818, 2.560, -1.345> <1.827, 2.560, -1.366> 
		<1.772, 2.553, -1.310> <1.788, 2.546, -1.325> <1.798, 2.554, -1.356> <1.810, 2.555, -1.375> 
		<1.762, 2.543, -1.317> <1.777, 2.536, -1.332> <1.789, 2.546, -1.362> <1.801, 2.547, -1.381> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.879, 2.538, -1.348> <1.885, 2.543, -1.343> <1.897, 2.554, -1.338> <1.897, 2.556, -1.329> 
		<1.871, 2.549, -1.350> <1.876, 2.555, -1.345> <1.885, 2.571, -1.341> <1.884, 2.572, -1.332> 
		<1.854, 2.560, -1.357> <1.853, 2.569, -1.353> <1.862, 2.584, -1.349> <1.859, 2.588, -1.341> 
		<1.841, 2.562, -1.362> <1.840, 2.571, -1.359> <1.843, 2.587, -1.358> <1.839, 2.591, -1.350> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.897, 2.556, -1.329> <1.897, 2.559, -1.310> <1.890, 2.558, -1.282> <1.879, 2.551, -1.269> 
		<1.884, 2.572, -1.332> <1.884, 2.575, -1.313> <1.876, 2.577, -1.286> <1.864, 2.570, -1.272> 
		<1.859, 2.588, -1.341> <1.852, 2.595, -1.325> <1.843, 2.597, -1.297> <1.835, 2.588, -1.283> 
		<1.839, 2.591, -1.350> <1.833, 2.598, -1.334> <1.821, 2.600, -1.307> <1.813, 2.591, -1.293> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.879, 2.551, -1.269> <1.873, 2.548, -1.261> <1.853, 2.532, -1.266> <1.852, 2.530, -1.276> 
		<1.864, 2.570, -1.272> <1.858, 2.567, -1.264> <1.843, 2.544, -1.268> <1.842, 2.542, -1.278> 
		<1.835, 2.588, -1.283> <1.830, 2.583, -1.274> <1.819, 2.559, -1.276> <1.823, 2.554, -1.285> 
		<1.813, 2.591, -1.293> <1.809, 2.587, -1.284> <1.804, 2.561, -1.283> <1.808, 2.557, -1.292> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.852, 2.530, -1.276> <1.851, 2.525, -1.298> <1.869, 2.534, -1.326> <1.876, 2.536, -1.347> 
		<1.842, 2.542, -1.278> <1.841, 2.538, -1.300> <1.861, 2.545, -1.328> <1.868, 2.546, -1.349> 
		<1.823, 2.554, -1.285> <1.830, 2.545, -1.304> <1.842, 2.556, -1.334> <1.851, 2.556, -1.355> 
		<1.808, 2.557, -1.292> <1.815, 2.547, -1.311> <1.830, 2.558, -1.340> <1.839, 2.558, -1.360> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.894, 2.493, -1.351> <1.901, 2.492, -1.345> <1.918, 2.490, -1.342> <1.919, 2.488, -1.333> 
		<1.895, 2.507, -1.348> <1.902, 2.506, -1.342> <1.919, 2.511, -1.337> <1.920, 2.509, -1.328> 
		<1.888, 2.527, -1.347> <1.893, 2.532, -1.341> <1.910, 2.537, -1.336> <1.910, 2.539, -1.326> 
		<1.879, 2.538, -1.348> <1.885, 2.543, -1.343> <1.897, 2.554, -1.338> <1.897, 2.556, -1.329> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.919, 2.488, -1.333> <1.921, 2.484, -1.314> <1.916, 2.478, -1.287> <1.904, 2.475, -1.273> 
		<1.920, 2.509, -1.328> <1.922, 2.504, -1.310> <1.917, 2.501, -1.281> <1.905, 2.498, -1.267> 
		<1.910, 2.539, -1.326> <1.910, 2.542, -1.308> <1.905, 2.539, -1.279> <1.894, 2.533, -1.266> 
		<1.897, 2.556, -1.329> <1.897, 2.559, -1.310> <1.890, 2.558, -1.282> <1.879, 2.551, -1.269> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.904, 2.475, -1.273> <1.896, 2.473, -1.265> <1.871, 2.475, -1.268> <1.869, 2.478, -1.279> 
		<1.905, 2.498, -1.267> <1.898, 2.497, -1.260> <1.871, 2.491, -1.265> <1.870, 2.494, -1.275> 
		<1.894, 2.533, -1.266> <1.887, 2.529, -1.258> <1.863, 2.519, -1.263> <1.862, 2.517, -1.274> 
		<1.879, 2.551, -1.269> <1.873, 2.548, -1.261> <1.853, 2.532, -1.266> <1.852, 2.530, -1.276> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.869, 2.478, -1.279> <1.865, 2.483, -1.300> <1.884, 2.488, -1.328> <1.890, 2.493, -1.349> 
		<1.870, 2.494, -1.275> <1.866, 2.499, -1.297> <1.884, 2.502, -1.325> <1.890, 2.506, -1.346> 
		<1.862, 2.517, -1.274> <1.861, 2.512, -1.296> <1.877, 2.523, -1.324> <1.884, 2.525, -1.345> 
		<1.852, 2.530, -1.276> <1.851, 2.525, -1.298> <1.869, 2.534, -1.326> <1.876, 2.536, -1.347> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.876, 2.453, -1.368> <1.881, 2.445, -1.365> <1.892, 2.433, -1.366> <1.892, 2.428, -1.358> 
		<1.885, 2.461, -1.362> <1.890, 2.454, -1.359> <1.906, 2.446, -1.357> <1.906, 2.440, -1.349> 
		<1.893, 2.479, -1.354> <1.901, 2.478, -1.349> <1.917, 2.469, -1.347> <1.918, 2.467, -1.337> 
		<1.894, 2.493, -1.351> <1.901, 2.492, -1.345> <1.918, 2.490, -1.342> <1.919, 2.488, -1.333> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.892, 2.428, -1.358> <1.891, 2.417, -1.343> <1.884, 2.406, -1.317> <1.873, 2.407, -1.302> 
		<1.906, 2.440, -1.349> <1.905, 2.429, -1.333> <1.900, 2.420, -1.307> <1.889, 2.421, -1.291> 
		<1.918, 2.467, -1.337> <1.921, 2.463, -1.319> <1.915, 2.454, -1.292> <1.903, 2.451, -1.278> 
		<1.919, 2.488, -1.333> <1.921, 2.484, -1.314> <1.916, 2.478, -1.287> <1.904, 2.475, -1.273> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.873, 2.407, -1.302> <1.866, 2.407, -1.294> <1.848, 2.425, -1.290> <1.848, 2.432, -1.298> 
		<1.889, 2.421, -1.291> <1.883, 2.421, -1.283> <1.859, 2.435, -1.283> <1.859, 2.441, -1.291> 
		<1.903, 2.451, -1.278> <1.895, 2.450, -1.271> <1.870, 2.459, -1.272> <1.868, 2.462, -1.282> 
		<1.904, 2.475, -1.273> <1.896, 2.473, -1.265> <1.871, 2.475, -1.268> <1.869, 2.478, -1.279> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.848, 2.432, -1.298> <1.848, 2.445, -1.316> <1.865, 2.448, -1.346> <1.873, 2.455, -1.366> 
		<1.859, 2.441, -1.291> <1.859, 2.455, -1.309> <1.874, 2.456, -1.339> <1.882, 2.463, -1.360> 
		<1.868, 2.462, -1.282> <1.864, 2.467, -1.304> <1.883, 2.475, -1.331> <1.889, 2.480, -1.352> 
		<1.869, 2.478, -1.279> <1.865, 2.483, -1.300> <1.884, 2.488, -1.328> <1.890, 2.493, -1.349> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.498, 2.560, -1.833> <0.493, 2.555, -1.816> <0.475, 2.552, -1.790> <0.483, 2.543, -1.776> 
		<0.494, 2.536, -1.840> <0.490, 2.531, -1.823> <0.469, 2.516, -1.800> <0.478, 2.507, -1.787> 
		<0.495, 2.507, -1.864> <0.491, 2.492, -1.855> <0.471, 2.477, -1.831> <0.479, 2.463, -1.823> 
		<0.500, 2.494, -1.885> <0.496, 2.480, -1.876> <0.478, 2.458, -1.863> <0.487, 2.445, -1.855> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.483, 2.543, -1.776> <0.499, 2.526, -1.752> <0.535, 2.500, -1.726> <0.565, 2.488, -1.727> 
		<0.478, 2.507, -1.787> <0.493, 2.490, -1.762> <0.528, 2.460, -1.737> <0.559, 2.447, -1.739> 
		<0.479, 2.463, -1.823> <0.495, 2.437, -1.807> <0.528, 2.405, -1.783> <0.561, 2.398, -1.780> 
		<0.487, 2.445, -1.855> <0.502, 2.419, -1.839> <0.536, 2.384, -1.819> <0.569, 2.377, -1.816> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.565, 2.488, -1.727> <0.584, 2.480, -1.728> <0.613, 2.484, -1.767> <0.605, 2.494, -1.783> 
		<0.559, 2.447, -1.739> <0.578, 2.440, -1.740> <0.609, 2.456, -1.775> <0.600, 2.466, -1.790> 
		<0.561, 2.398, -1.780> <0.579, 2.394, -1.778> <0.609, 2.418, -1.809> <0.602, 2.433, -1.818> 
		<0.569, 2.377, -1.816> <0.587, 2.373, -1.814> <0.615, 2.404, -1.834> <0.607, 2.419, -1.843> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.605, 2.494, -1.783> <0.588, 2.513, -1.813> <0.535, 2.539, -1.821> <0.504, 2.558, -1.837> 
		<0.600, 2.466, -1.790> <0.584, 2.486, -1.820> <0.531, 2.516, -1.827> <0.501, 2.536, -1.844> 
		<0.602, 2.433, -1.818> <0.585, 2.464, -1.837> <0.532, 2.485, -1.853> <0.502, 2.508, -1.866> 
		<0.607, 2.419, -1.843> <0.591, 2.450, -1.861> <0.537, 2.473, -1.873> <0.507, 2.496, -1.887> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.523, 2.639, -1.844> <0.522, 2.646, -1.829> <0.510, 2.664, -1.805> <0.521, 2.662, -1.793> 
		<0.513, 2.619, -1.832> <0.513, 2.626, -1.816> <0.496, 2.634, -1.787> <0.506, 2.632, -1.774> 
		<0.501, 2.584, -1.826> <0.497, 2.578, -1.809> <0.481, 2.588, -1.780> <0.489, 2.578, -1.766> 
		<0.498, 2.560, -1.833> <0.493, 2.555, -1.816> <0.475, 2.552, -1.790> <0.483, 2.543, -1.776> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.521, 2.662, -1.793> <0.542, 2.658, -1.769> <0.582, 2.641, -1.746> <0.608, 2.623, -1.746> 
		<0.506, 2.632, -1.774> <0.527, 2.628, -1.751> <0.565, 2.607, -1.725> <0.592, 2.589, -1.725> 
		<0.489, 2.578, -1.766> <0.505, 2.562, -1.742> <0.541, 2.541, -1.714> <0.572, 2.529, -1.716> 
		<0.483, 2.543, -1.776> <0.499, 2.526, -1.752> <0.535, 2.500, -1.726> <0.565, 2.488, -1.727> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.608, 2.623, -1.746> <0.625, 2.611, -1.746> <0.646, 2.583, -1.780> <0.634, 2.585, -1.795> 
		<0.592, 2.589, -1.725> <0.608, 2.578, -1.726> <0.635, 2.561, -1.765> <0.622, 2.562, -1.781> 
		<0.572, 2.529, -1.716> <0.591, 2.521, -1.717> <0.618, 2.511, -1.759> <0.609, 2.521, -1.775> 
		<0.565, 2.488, -1.727> <0.584, 2.480, -1.728> <0.613, 2.484, -1.767> <0.605, 2.494, -1.783> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.634, 2.585, -1.795> <0.610, 2.588, -1.825> <0.560, 2.619, -1.832> <0.528, 2.634, -1.848> 
		<0.622, 2.562, -1.781> <0.599, 2.566, -1.811> <0.551, 2.600, -1.820> <0.519, 2.615, -1.836> 
		<0.609, 2.521, -1.775> <0.592, 2.540, -1.805> <0.538, 2.562, -1.814> <0.508, 2.581, -1.831> 
		<0.605, 2.494, -1.783> <0.588, 2.513, -1.813> <0.535, 2.539, -1.821> <0.504, 2.558, -1.837> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.561, 2.686, -1.912> <0.566, 2.700, -1.907> <0.564, 2.730, -1.901> <0.578, 2.732, -1.894> 
		<0.550, 2.681, -1.887> <0.555, 2.694, -1.882> <0.548, 2.722, -1.864> <0.562, 2.724, -1.858> 
		<0.533, 2.660, -1.857> <0.533, 2.667, -1.842> <0.526, 2.696, -1.825> <0.537, 2.694, -1.813> 
		<0.523, 2.639, -1.844> <0.522, 2.646, -1.829> <0.510, 2.664, -1.805> <0.521, 2.662, -1.793> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.578, 2.732, -1.894> <0.606, 2.736, -1.882> <0.650, 2.724, -1.866> <0.672, 2.703, -1.861> 
		<0.562, 2.724, -1.858> <0.590, 2.728, -1.845> <0.632, 2.715, -1.824> <0.654, 2.693, -1.820> 
		<0.537, 2.694, -1.813> <0.558, 2.690, -1.789> <0.600, 2.677, -1.768> <0.626, 2.659, -1.769> 
		<0.521, 2.662, -1.793> <0.542, 2.658, -1.769> <0.582, 2.641, -1.746> <0.608, 2.623, -1.746> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.672, 2.703, -1.861> <0.686, 2.690, -1.858> <0.694, 2.643, -1.865> <0.677, 2.639, -1.873> 
		<0.654, 2.693, -1.820> <0.668, 2.680, -1.817> <0.682, 2.637, -1.837> <0.665, 2.633, -1.845> 
		<0.626, 2.659, -1.769> <0.643, 2.648, -1.769> <0.658, 2.608, -1.795> <0.646, 2.609, -1.810> 
		<0.608, 2.623, -1.746> <0.625, 2.611, -1.746> <0.646, 2.583, -1.780> <0.634, 2.585, -1.795> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.677, 2.639, -1.873> <0.644, 2.632, -1.889> <0.598, 2.667, -1.900> <0.564, 2.679, -1.912> 
		<0.665, 2.633, -1.845> <0.632, 2.625, -1.861> <0.588, 2.661, -1.877> <0.554, 2.673, -1.889> 
		<0.646, 2.609, -1.810> <0.622, 2.613, -1.840> <0.570, 2.639, -1.844> <0.538, 2.654, -1.860> 
		<0.634, 2.585, -1.795> <0.610, 2.588, -1.825> <0.560, 2.619, -1.832> <0.528, 2.634, -1.848> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.589, 2.673, -1.997> <0.598, 2.685, -2.004> <0.603, 2.712, -2.020> <0.620, 2.713, -2.022> 
		<0.584, 2.686, -1.973> <0.593, 2.698, -1.981> <0.596, 2.732, -1.986> <0.612, 2.733, -1.987> 
		<0.571, 2.692, -1.936> <0.576, 2.705, -1.931> <0.579, 2.738, -1.937> <0.594, 2.740, -1.931> 
		<0.561, 2.686, -1.912> <0.566, 2.700, -1.907> <0.564, 2.730, -1.901> <0.578, 2.732, -1.894> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.620, 2.713, -2.022> <0.652, 2.715, -2.024> <0.699, 2.702, -2.017> <0.720, 2.681, -2.005> 
		<0.612, 2.733, -1.987> <0.644, 2.735, -1.989> <0.691, 2.724, -1.978> <0.712, 2.703, -1.966> 
		<0.594, 2.740, -1.931> <0.622, 2.745, -1.918> <0.668, 2.733, -1.907> <0.690, 2.712, -1.903> 
		<0.578, 2.732, -1.894> <0.606, 2.736, -1.882> <0.650, 2.724, -1.866> <0.672, 2.703, -1.861> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.720, 2.681, -2.005> <0.734, 2.668, -1.998> <0.730, 2.627, -1.973> <0.710, 2.624, -1.971> 
		<0.712, 2.703, -1.966> <0.725, 2.690, -1.958> <0.724, 2.642, -1.946> <0.704, 2.639, -1.944> 
		<0.690, 2.712, -1.903> <0.704, 2.699, -1.900> <0.707, 2.649, -1.893> <0.689, 2.645, -1.901> 
		<0.672, 2.703, -1.861> <0.686, 2.690, -1.858> <0.694, 2.643, -1.865> <0.677, 2.639, -1.873> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.710, 2.624, -1.971> <0.672, 2.620, -1.967> <0.627, 2.654, -1.986> <0.591, 2.666, -1.992> 
		<0.704, 2.639, -1.944> <0.666, 2.635, -1.940> <0.622, 2.666, -1.964> <0.586, 2.679, -1.970> 
		<0.689, 2.645, -1.901> <0.656, 2.638, -1.917> <0.608, 2.672, -1.923> <0.574, 2.684, -1.935> 
		<0.677, 2.639, -1.873> <0.644, 2.632, -1.889> <0.598, 2.667, -1.900> <0.564, 2.679, -1.912> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.591, 2.608, -2.049> <0.601, 2.610, -2.064> <0.607, 2.620, -2.094> <0.623, 2.615, -2.100> 
		<0.595, 2.632, -2.042> <0.604, 2.634, -2.057> <0.612, 2.656, -2.084> <0.629, 2.651, -2.090> 
		<0.594, 2.661, -2.018> <0.603, 2.673, -2.025> <0.610, 2.694, -2.053> <0.627, 2.695, -2.054> 
		<0.589, 2.673, -1.997> <0.598, 2.685, -2.004> <0.603, 2.712, -2.020> <0.620, 2.713, -2.022> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.623, 2.615, -2.100> <0.654, 2.607, -2.110> <0.701, 2.587, -2.112> <0.724, 2.570, -2.094> 
		<0.629, 2.651, -2.090> <0.659, 2.642, -2.100> <0.708, 2.627, -2.100> <0.730, 2.611, -2.083> 
		<0.627, 2.695, -2.054> <0.659, 2.697, -2.056> <0.707, 2.681, -2.054> <0.728, 2.660, -2.042> 
		<0.620, 2.713, -2.022> <0.652, 2.715, -2.024> <0.699, 2.702, -2.017> <0.720, 2.681, -2.005> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.724, 2.570, -2.094> <0.738, 2.560, -2.083> <0.730, 2.545, -2.038> <0.712, 2.549, -2.031> 
		<0.730, 2.611, -2.083> <0.744, 2.600, -2.072> <0.735, 2.572, -2.030> <0.716, 2.577, -2.023> 
		<0.728, 2.660, -2.042> <0.742, 2.647, -2.034> <0.735, 2.613, -1.997> <0.715, 2.610, -1.995> 
		<0.720, 2.681, -2.005> <0.734, 2.668, -1.998> <0.730, 2.627, -1.973> <0.710, 2.624, -1.971> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.712, 2.549, -2.031> <0.676, 2.559, -2.016> <0.629, 2.588, -2.039> <0.593, 2.604, -2.042> 
		<0.716, 2.577, -2.023> <0.681, 2.586, -2.009> <0.632, 2.610, -2.032> <0.597, 2.627, -2.036> 
		<0.715, 2.610, -1.995> <0.677, 2.606, -1.991> <0.631, 2.642, -2.006> <0.596, 2.655, -2.013> 
		<0.710, 2.624, -1.971> <0.672, 2.620, -1.967> <0.627, 2.654, -1.986> <0.591, 2.666, -1.992> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.566, 2.529, -2.038> <0.572, 2.519, -2.051> <0.572, 2.507, -2.079> <0.586, 2.496, -2.083> 
		<0.576, 2.548, -2.050> <0.581, 2.539, -2.064> <0.587, 2.537, -2.097> <0.600, 2.526, -2.102> 
		<0.587, 2.584, -2.056> <0.597, 2.586, -2.071> <0.601, 2.584, -2.104> <0.618, 2.579, -2.110> 
		<0.591, 2.608, -2.049> <0.601, 2.610, -2.064> <0.607, 2.620, -2.094> <0.623, 2.615, -2.100> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.586, 2.496, -2.083> <0.611, 2.475, -2.092> <0.654, 2.446, -2.093> <0.681, 2.435, -2.075> 
		<0.600, 2.526, -2.102> <0.626, 2.505, -2.110> <0.671, 2.479, -2.114> <0.698, 2.469, -2.096> 
		<0.618, 2.579, -2.110> <0.648, 2.571, -2.120> <0.695, 2.546, -2.123> <0.717, 2.529, -2.106> 
		<0.623, 2.615, -2.100> <0.654, 2.607, -2.110> <0.701, 2.587, -2.112> <0.724, 2.570, -2.094> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.681, 2.435, -2.075> <0.696, 2.429, -2.066> <0.697, 2.447, -2.023> <0.683, 2.458, -2.018> 
		<0.698, 2.469, -2.096> <0.712, 2.463, -2.086> <0.708, 2.469, -2.037> <0.694, 2.481, -2.032> 
		<0.717, 2.529, -2.106> <0.731, 2.519, -2.095> <0.726, 2.517, -2.046> <0.708, 2.522, -2.038> 
		<0.724, 2.570, -2.094> <0.738, 2.560, -2.083> <0.730, 2.545, -2.038> <0.712, 2.549, -2.031> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.683, 2.458, -2.018> <0.653, 2.483, -2.006> <0.603, 2.508, -2.027> <0.569, 2.529, -2.032> 
		<0.694, 2.481, -2.032> <0.665, 2.506, -2.020> <0.613, 2.526, -2.039> <0.579, 2.548, -2.043> 
		<0.708, 2.522, -2.038> <0.672, 2.531, -2.024> <0.625, 2.565, -2.045> <0.590, 2.582, -2.048> 
		<0.712, 2.549, -2.031> <0.676, 2.559, -2.016> <0.629, 2.588, -2.039> <0.593, 2.604, -2.042> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.528, 2.482, -1.970> <0.528, 2.465, -1.974> <0.519, 2.440, -1.983> <0.529, 2.425, -1.982> 
		<0.539, 2.487, -1.994> <0.539, 2.470, -1.998> <0.535, 2.448, -2.020> <0.545, 2.434, -2.019> 
		<0.555, 2.507, -2.024> <0.561, 2.498, -2.038> <0.556, 2.475, -2.059> <0.570, 2.464, -2.064> 
		<0.566, 2.529, -2.038> <0.572, 2.519, -2.051> <0.572, 2.507, -2.079> <0.586, 2.496, -2.083> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.529, 2.425, -1.982> <0.549, 2.397, -1.980> <0.585, 2.361, -1.972> <0.617, 2.355, -1.960> 
		<0.545, 2.434, -2.019> <0.565, 2.406, -2.016> <0.603, 2.371, -2.014> <0.635, 2.364, -2.002> 
		<0.570, 2.464, -2.064> <0.595, 2.443, -2.072> <0.636, 2.409, -2.071> <0.663, 2.399, -2.053> 
		<0.586, 2.496, -2.083> <0.611, 2.475, -2.092> <0.654, 2.446, -2.093> <0.681, 2.435, -2.075> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.617, 2.355, -1.960> <0.633, 2.352, -1.954> <0.649, 2.389, -1.939> <0.640, 2.404, -1.940> 
		<0.635, 2.364, -2.002> <0.651, 2.361, -1.996> <0.661, 2.396, -1.967> <0.652, 2.410, -1.968> 
		<0.663, 2.399, -2.053> <0.678, 2.393, -2.043> <0.684, 2.422, -2.008> <0.671, 2.434, -2.003> 
		<0.681, 2.435, -2.075> <0.696, 2.429, -2.066> <0.697, 2.447, -2.023> <0.683, 2.458, -2.018> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.640, 2.404, -1.940> <0.617, 2.438, -1.942> <0.565, 2.460, -1.959> <0.533, 2.484, -1.967> 
		<0.652, 2.410, -1.968> <0.630, 2.444, -1.970> <0.575, 2.465, -1.982> <0.543, 2.489, -1.990> 
		<0.671, 2.434, -2.003> <0.641, 2.458, -1.991> <0.593, 2.487, -2.015> <0.559, 2.509, -2.019> 
		<0.683, 2.458, -2.018> <0.653, 2.483, -2.006> <0.603, 2.508, -2.027> <0.569, 2.529, -2.032> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.500, 2.494, -1.885> <0.496, 2.480, -1.876> <0.478, 2.458, -1.863> <0.487, 2.445, -1.855> 
		<0.505, 2.481, -1.908> <0.501, 2.466, -1.899> <0.486, 2.439, -1.897> <0.494, 2.425, -1.889> 
		<0.517, 2.476, -1.946> <0.518, 2.459, -1.949> <0.503, 2.431, -1.946> <0.513, 2.417, -1.945> 
		<0.528, 2.482, -1.970> <0.528, 2.465, -1.974> <0.519, 2.440, -1.983> <0.529, 2.425, -1.982> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.487, 2.445, -1.855> <0.502, 2.419, -1.839> <0.536, 2.384, -1.819> <0.569, 2.377, -1.816> 
		<0.494, 2.425, -1.889> <0.510, 2.399, -1.874> <0.545, 2.362, -1.859> <0.578, 2.355, -1.855> 
		<0.513, 2.417, -1.945> <0.533, 2.389, -1.943> <0.567, 2.352, -1.931> <0.599, 2.346, -1.919> 
		<0.529, 2.425, -1.982> <0.549, 2.397, -1.980> <0.585, 2.361, -1.972> <0.617, 2.355, -1.960> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.569, 2.377, -1.816> <0.587, 2.373, -1.814> <0.615, 2.404, -1.834> <0.607, 2.419, -1.843> 
		<0.578, 2.355, -1.855> <0.596, 2.351, -1.854> <0.621, 2.389, -1.861> <0.613, 2.403, -1.869> 
		<0.599, 2.346, -1.919> <0.615, 2.343, -1.913> <0.637, 2.383, -1.911> <0.628, 2.398, -1.912> 
		<0.617, 2.355, -1.960> <0.633, 2.352, -1.954> <0.649, 2.389, -1.939> <0.640, 2.404, -1.940> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.607, 2.419, -1.843> <0.591, 2.450, -1.861> <0.537, 2.473, -1.873> <0.507, 2.496, -1.887> 
		<0.613, 2.403, -1.869> <0.596, 2.435, -1.888> <0.542, 2.461, -1.895> <0.511, 2.484, -1.909> 
		<0.628, 2.398, -1.912> <0.605, 2.432, -1.914> <0.555, 2.455, -1.936> <0.523, 2.479, -1.944> 
		<0.640, 2.404, -1.940> <0.617, 2.438, -1.942> <0.565, 2.460, -1.959> <0.533, 2.484, -1.967> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.764, 2.342, -1.238> <1.759, 2.339, -1.221> <1.740, 2.333, -1.196> <1.748, 2.333, -1.180> 
		<1.774, 2.319, -1.237> <1.770, 2.316, -1.220> <1.755, 2.299, -1.194> <1.764, 2.299, -1.178> 
		<1.796, 2.290, -1.251> <1.798, 2.279, -1.237> <1.784, 2.261, -1.211> <1.796, 2.257, -1.199> 
		<1.811, 2.278, -1.267> <1.813, 2.266, -1.254> <1.806, 2.243, -1.235> <1.818, 2.239, -1.223> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.748, 2.333, -1.180> <1.764, 2.334, -1.151> <1.802, 2.340, -1.116> <1.834, 2.347, -1.112> 
		<1.764, 2.299, -1.178> <1.780, 2.300, -1.150> <1.820, 2.301, -1.114> <1.852, 2.308, -1.110> 
		<1.796, 2.257, -1.199> <1.819, 2.248, -1.175> <1.857, 2.246, -1.140> <1.888, 2.260, -1.133> 
		<1.818, 2.239, -1.223> <1.841, 2.230, -1.199> <1.883, 2.226, -1.168> <1.913, 2.239, -1.160> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.834, 2.347, -1.112> <1.854, 2.351, -1.109> <1.885, 2.361, -1.145> <1.876, 2.360, -1.164> 
		<1.852, 2.308, -1.110> <1.872, 2.312, -1.108> <1.897, 2.334, -1.144> <1.888, 2.334, -1.163> 
		<1.888, 2.260, -1.133> <1.905, 2.267, -1.129> <1.924, 2.296, -1.165> <1.912, 2.301, -1.178> 
		<1.913, 2.239, -1.160> <1.930, 2.247, -1.156> <1.941, 2.282, -1.183> <1.929, 2.288, -1.197> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.876, 2.360, -1.164> <1.859, 2.359, -1.199> <1.803, 2.348, -1.218> <1.771, 2.343, -1.241> 
		<1.888, 2.334, -1.163> <1.871, 2.333, -1.198> <1.813, 2.327, -1.217> <1.781, 2.322, -1.240> 
		<1.912, 2.301, -1.178> <1.886, 2.313, -1.207> <1.836, 2.296, -1.231> <1.801, 2.295, -1.253> 
		<1.929, 2.288, -1.197> <1.903, 2.299, -1.225> <1.850, 2.285, -1.247> <1.816, 2.283, -1.268> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.747, 2.416, -1.272> <1.739, 2.425, -1.260> <1.715, 2.438, -1.244> <1.722, 2.445, -1.231> 
		<1.746, 2.398, -1.255> <1.739, 2.407, -1.243> <1.714, 2.411, -1.218> <1.721, 2.418, -1.205> 
		<1.753, 2.364, -1.239> <1.749, 2.362, -1.222> <1.724, 2.367, -1.197> <1.733, 2.368, -1.181> 
		<1.764, 2.342, -1.238> <1.759, 2.339, -1.221> <1.740, 2.333, -1.196> <1.748, 2.333, -1.180> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.722, 2.445, -1.231> <1.736, 2.459, -1.206> <1.773, 2.474, -1.176> <1.804, 2.474, -1.170> 
		<1.721, 2.418, -1.205> <1.735, 2.432, -1.180> <1.772, 2.442, -1.147> <1.803, 2.443, -1.140> 
		<1.733, 2.368, -1.181> <1.749, 2.369, -1.152> <1.784, 2.379, -1.117> <1.816, 2.385, -1.113> 
		<1.748, 2.333, -1.180> <1.764, 2.334, -1.151> <1.802, 2.340, -1.116> <1.834, 2.347, -1.112> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.804, 2.474, -1.170> <1.824, 2.474, -1.166> <1.863, 2.455, -1.187> <1.856, 2.446, -1.203> 
		<1.803, 2.443, -1.140> <1.823, 2.443, -1.136> <1.863, 2.434, -1.167> <1.855, 2.425, -1.183> 
		<1.816, 2.385, -1.113> <1.836, 2.390, -1.111> <1.872, 2.387, -1.146> <1.863, 2.386, -1.165> 
		<1.834, 2.347, -1.112> <1.854, 2.351, -1.109> <1.885, 2.361, -1.145> <1.876, 2.360, -1.164> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.856, 2.446, -1.203> <1.841, 2.429, -1.234> <1.785, 2.424, -1.252> <1.755, 2.414, -1.274> 
		<1.855, 2.425, -1.183> <1.840, 2.408, -1.214> <1.784, 2.407, -1.236> <1.754, 2.397, -1.257> 
		<1.863, 2.386, -1.165> <1.846, 2.386, -1.200> <1.792, 2.370, -1.219> <1.761, 2.365, -1.242> 
		<1.876, 2.360, -1.164> <1.859, 2.359, -1.199> <1.803, 2.348, -1.218> <1.771, 2.343, -1.241> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.769, 2.459, -1.349> <1.765, 2.474, -1.348> <1.746, 2.498, -1.353> <1.755, 2.509, -1.347> 
		<1.757, 2.454, -1.325> <1.753, 2.470, -1.324> <1.729, 2.492, -1.316> <1.738, 2.503, -1.310> 
		<1.747, 2.436, -1.291> <1.740, 2.445, -1.279> <1.716, 2.468, -1.272> <1.724, 2.475, -1.259> 
		<1.747, 2.416, -1.272> <1.739, 2.425, -1.260> <1.715, 2.438, -1.244> <1.722, 2.445, -1.231> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.755, 2.509, -1.347> <1.774, 2.531, -1.334> <1.813, 2.549, -1.313> <1.842, 2.546, -1.301> 
		<1.738, 2.503, -1.310> <1.757, 2.525, -1.298> <1.794, 2.542, -1.272> <1.823, 2.538, -1.259> 
		<1.724, 2.475, -1.259> <1.738, 2.489, -1.234> <1.774, 2.507, -1.208> <1.806, 2.507, -1.202> 
		<1.722, 2.445, -1.231> <1.736, 2.459, -1.206> <1.773, 2.474, -1.176> <1.804, 2.474, -1.170> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.842, 2.546, -1.301> <1.860, 2.544, -1.293> <1.892, 2.510, -1.284> <1.881, 2.495, -1.291> 
		<1.823, 2.538, -1.259> <1.840, 2.536, -1.251> <1.879, 2.505, -1.256> <1.868, 2.490, -1.263> 
		<1.806, 2.507, -1.202> <1.825, 2.507, -1.197> <1.864, 2.478, -1.208> <1.857, 2.469, -1.224> 
		<1.804, 2.474, -1.170> <1.824, 2.474, -1.166> <1.863, 2.455, -1.187> <1.856, 2.446, -1.203> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.881, 2.495, -1.291> <1.861, 2.467, -1.306> <1.807, 2.467, -1.330> <1.776, 2.455, -1.347> 
		<1.868, 2.490, -1.263> <1.847, 2.462, -1.278> <1.796, 2.463, -1.307> <1.765, 2.451, -1.324> 
		<1.857, 2.469, -1.224> <1.842, 2.451, -1.255> <1.786, 2.443, -1.270> <1.755, 2.433, -1.291> 
		<1.856, 2.446, -1.203> <1.841, 2.429, -1.234> <1.785, 2.424, -1.252> <1.755, 2.414, -1.274> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.817, 2.444, -1.424> <1.820, 2.457, -1.434> <1.815, 2.478, -1.458> <1.828, 2.488, -1.459> 
		<1.801, 2.457, -1.407> <1.804, 2.470, -1.417> <1.790, 2.497, -1.432> <1.804, 2.507, -1.432> 
		<1.780, 2.463, -1.373> <1.776, 2.479, -1.373> <1.763, 2.505, -1.389> <1.772, 2.516, -1.383> 
		<1.769, 2.459, -1.349> <1.765, 2.474, -1.348> <1.746, 2.498, -1.353> <1.755, 2.509, -1.347> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.828, 2.488, -1.459> <1.854, 2.506, -1.459> <1.899, 2.524, -1.447> <1.924, 2.522, -1.428> 
		<1.804, 2.507, -1.432> <1.830, 2.526, -1.433> <1.872, 2.546, -1.417> <1.897, 2.544, -1.398> 
		<1.772, 2.516, -1.383> <1.791, 2.538, -1.371> <1.832, 2.557, -1.354> <1.861, 2.554, -1.342> 
		<1.755, 2.509, -1.347> <1.774, 2.531, -1.334> <1.813, 2.549, -1.313> <1.842, 2.546, -1.301> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.924, 2.522, -1.428> <1.940, 2.520, -1.415> <1.953, 2.491, -1.379> <1.937, 2.478, -1.377> 
		<1.897, 2.544, -1.398> <1.913, 2.542, -1.386> <1.934, 2.506, -1.359> <1.918, 2.494, -1.357> 
		<1.861, 2.554, -1.342> <1.879, 2.552, -1.334> <1.905, 2.515, -1.312> <1.894, 2.500, -1.319> 
		<1.842, 2.546, -1.301> <1.860, 2.544, -1.293> <1.892, 2.510, -1.284> <1.881, 2.495, -1.291> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.937, 2.478, -1.377> <1.907, 2.455, -1.374> <1.856, 2.452, -1.406> <1.822, 2.441, -1.418> 
		<1.918, 2.494, -1.357> <1.888, 2.470, -1.354> <1.841, 2.465, -1.389> <1.806, 2.454, -1.401> 
		<1.894, 2.500, -1.319> <1.873, 2.472, -1.334> <1.818, 2.471, -1.353> <1.786, 2.459, -1.370> 
		<1.881, 2.495, -1.291> <1.861, 2.467, -1.306> <1.807, 2.467, -1.330> <1.776, 2.455, -1.347> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.864, 2.381, -1.453> <1.874, 2.385, -1.467> <1.881, 2.389, -1.499> <1.898, 2.393, -1.502> 
		<1.853, 2.404, -1.453> <1.864, 2.407, -1.468> <1.865, 2.423, -1.500> <1.882, 2.427, -1.503> 
		<1.832, 2.432, -1.440> <1.835, 2.445, -1.450> <1.837, 2.460, -1.482> <1.851, 2.469, -1.483> 
		<1.817, 2.444, -1.424> <1.820, 2.457, -1.434> <1.815, 2.478, -1.458> <1.828, 2.488, -1.459> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.898, 2.393, -1.502> <1.930, 2.400, -1.507> <1.980, 2.411, -1.499> <2.004, 2.414, -1.476> 
		<1.882, 2.427, -1.503> <1.914, 2.435, -1.508> <1.962, 2.450, -1.501> <1.986, 2.453, -1.478> 
		<1.851, 2.469, -1.483> <1.877, 2.488, -1.484> <1.924, 2.503, -1.474> <1.950, 2.501, -1.455> 
		<1.828, 2.488, -1.459> <1.854, 2.506, -1.459> <1.899, 2.524, -1.447> <1.924, 2.522, -1.428> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.004, 2.414, -1.476> <2.018, 2.416, -1.462> <2.010, 2.411, -1.415> <1.990, 2.406, -1.410> 
		<1.986, 2.453, -1.478> <2.000, 2.455, -1.464> <1.998, 2.437, -1.416> <1.978, 2.432, -1.411> 
		<1.950, 2.501, -1.455> <1.966, 2.500, -1.443> <1.970, 2.477, -1.397> <1.954, 2.465, -1.396> 
		<1.924, 2.522, -1.428> <1.940, 2.520, -1.415> <1.953, 2.491, -1.379> <1.937, 2.478, -1.377> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.990, 2.406, -1.410> <1.953, 2.397, -1.402> <1.903, 2.389, -1.434> <1.866, 2.381, -1.445> 
		<1.978, 2.432, -1.411> <1.941, 2.423, -1.403> <1.893, 2.410, -1.435> <1.856, 2.403, -1.446> 
		<1.954, 2.465, -1.396> <1.924, 2.441, -1.393> <1.870, 2.441, -1.421> <1.836, 2.430, -1.433> 
		<1.937, 2.478, -1.377> <1.907, 2.455, -1.374> <1.856, 2.452, -1.406> <1.822, 2.441, -1.418> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.881, 2.306, -1.418> <1.894, 2.299, -1.428> <1.907, 2.283, -1.450> <1.924, 2.281, -1.450> 
		<1.882, 2.325, -1.436> <1.895, 2.317, -1.445> <1.908, 2.310, -1.476> <1.925, 2.308, -1.476> 
		<1.874, 2.358, -1.452> <1.885, 2.362, -1.466> <1.897, 2.355, -1.497> <1.914, 2.359, -1.500> 
		<1.864, 2.381, -1.453> <1.874, 2.385, -1.467> <1.881, 2.389, -1.499> <1.898, 2.393, -1.502> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.924, 2.281, -1.450> <1.958, 2.276, -1.450> <2.009, 2.276, -1.440> <2.033, 2.287, -1.418> 
		<1.925, 2.308, -1.476> <1.959, 2.304, -1.476> <2.011, 2.307, -1.470> <2.034, 2.318, -1.448> 
		<1.914, 2.359, -1.500> <1.946, 2.366, -1.506> <1.998, 2.372, -1.498> <2.022, 2.375, -1.475> 
		<1.898, 2.393, -1.502> <1.930, 2.400, -1.507> <1.980, 2.411, -1.499> <2.004, 2.414, -1.476> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.033, 2.287, -1.418> <2.046, 2.293, -1.406> <2.029, 2.317, -1.372> <2.011, 2.320, -1.371> 
		<2.034, 2.318, -1.448> <2.047, 2.324, -1.436> <2.030, 2.338, -1.392> <2.011, 2.341, -1.391> 
		<2.022, 2.375, -1.475> <2.036, 2.377, -1.460> <2.022, 2.384, -1.414> <2.003, 2.380, -1.409> 
		<2.004, 2.414, -1.476> <2.018, 2.416, -1.462> <2.010, 2.411, -1.415> <1.990, 2.406, -1.410> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.011, 2.320, -1.371> <1.971, 2.326, -1.369> <1.921, 2.313, -1.400> <1.883, 2.310, -1.412> 
		<2.011, 2.341, -1.391> <1.971, 2.347, -1.389> <1.922, 2.330, -1.416> <1.883, 2.327, -1.429> 
		<2.003, 2.380, -1.409> <1.965, 2.371, -1.401> <1.913, 2.367, -1.434> <1.876, 2.359, -1.444> 
		<1.990, 2.406, -1.410> <1.953, 2.397, -1.402> <1.903, 2.389, -1.434> <1.866, 2.381, -1.445> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.859, 2.264, -1.341> <1.869, 2.250, -1.339> <1.876, 2.222, -1.341> <1.891, 2.217, -1.335> 
		<1.870, 2.268, -1.366> <1.880, 2.254, -1.364> <1.893, 2.229, -1.377> <1.908, 2.224, -1.371> 
		<1.880, 2.287, -1.400> <1.893, 2.279, -1.409> <1.906, 2.253, -1.422> <1.923, 2.251, -1.422> 
		<1.881, 2.306, -1.418> <1.894, 2.299, -1.428> <1.907, 2.283, -1.450> <1.924, 2.281, -1.450> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.891, 2.217, -1.335> <1.922, 2.206, -1.323> <1.969, 2.199, -1.302> <1.996, 2.215, -1.287> 
		<1.908, 2.224, -1.371> <1.939, 2.213, -1.359> <1.988, 2.207, -1.344> <2.015, 2.222, -1.329> 
		<1.923, 2.251, -1.422> <1.957, 2.247, -1.422> <2.008, 2.243, -1.408> <2.032, 2.254, -1.386> 
		<1.924, 2.281, -1.450> <1.958, 2.276, -1.450> <2.009, 2.276, -1.440> <2.033, 2.287, -1.418> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.996, 2.215, -1.287> <2.009, 2.222, -1.280> <2.000, 2.265, -1.277> <1.985, 2.271, -1.282> 
		<2.015, 2.222, -1.329> <2.028, 2.230, -1.321> <2.013, 2.270, -1.305> <1.998, 2.276, -1.310> 
		<2.032, 2.254, -1.386> <2.045, 2.259, -1.374> <2.028, 2.294, -1.350> <2.010, 2.297, -1.349> 
		<2.033, 2.287, -1.418> <2.046, 2.293, -1.406> <2.029, 2.317, -1.372> <2.011, 2.320, -1.371> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.985, 2.271, -1.282> <1.950, 2.285, -1.296> <1.899, 2.270, -1.322> <1.862, 2.270, -1.339> 
		<1.998, 2.276, -1.310> <1.963, 2.291, -1.324> <1.909, 2.274, -1.345> <1.872, 2.274, -1.362> 
		<2.010, 2.297, -1.349> <1.970, 2.303, -1.348> <1.920, 2.294, -1.382> <1.882, 2.291, -1.395> 
		<2.011, 2.320, -1.371> <1.971, 2.326, -1.369> <1.921, 2.313, -1.400> <1.883, 2.310, -1.412> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.811, 2.278, -1.267> <1.813, 2.266, -1.254> <1.806, 2.243, -1.235> <1.818, 2.239, -1.223> 
		<1.827, 2.265, -1.284> <1.829, 2.253, -1.271> <1.831, 2.224, -1.261> <1.843, 2.219, -1.249> 
		<1.848, 2.259, -1.317> <1.858, 2.245, -1.315> <1.859, 2.216, -1.304> <1.874, 2.210, -1.298> 
		<1.859, 2.264, -1.341> <1.869, 2.250, -1.339> <1.876, 2.222, -1.341> <1.891, 2.217, -1.335> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.818, 2.239, -1.223> <1.841, 2.230, -1.199> <1.883, 2.226, -1.168> <1.913, 2.239, -1.160> 
		<1.843, 2.219, -1.249> <1.865, 2.210, -1.225> <1.910, 2.204, -1.197> <1.941, 2.217, -1.190> 
		<1.874, 2.210, -1.298> <1.905, 2.199, -1.286> <1.950, 2.192, -1.261> <1.977, 2.207, -1.246> 
		<1.891, 2.217, -1.335> <1.922, 2.206, -1.323> <1.969, 2.199, -1.302> <1.996, 2.215, -1.287> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.913, 2.239, -1.160> <1.930, 2.247, -1.156> <1.941, 2.282, -1.183> <1.929, 2.288, -1.197> 
		<1.941, 2.217, -1.190> <1.957, 2.224, -1.186> <1.960, 2.267, -1.203> <1.948, 2.272, -1.217> 
		<1.977, 2.207, -1.246> <1.990, 2.215, -1.239> <1.987, 2.260, -1.249> <1.972, 2.266, -1.255> 
		<1.996, 2.215, -1.287> <2.009, 2.222, -1.280> <2.000, 2.265, -1.277> <1.985, 2.271, -1.282> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.929, 2.288, -1.197> <1.903, 2.299, -1.225> <1.850, 2.285, -1.247> <1.816, 2.283, -1.268> 
		<1.948, 2.272, -1.217> <1.922, 2.284, -1.245> <1.865, 2.272, -1.263> <1.831, 2.271, -1.285> 
		<1.972, 2.266, -1.255> <1.937, 2.280, -1.268> <1.888, 2.266, -1.299> <1.851, 2.265, -1.316> 
		<1.985, 2.271, -1.282> <1.950, 2.285, -1.296> <1.899, 2.270, -1.322> <1.862, 2.270, -1.339> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.576, 2.068, -0.020> <3.569, 2.140, -0.021> <3.564, 2.201, -0.082> <3.566, 2.200, -0.155> 
		<3.866, 2.098, -0.013> <3.858, 2.171, -0.013> <3.854, 2.231, -0.075> <3.855, 2.231, -0.148> 
		<4.252, 2.139, -0.003> <4.245, 2.211, -0.004> <4.240, 2.272, -0.065> <4.242, 2.271, -0.138> 
		<4.542, 2.169, 0.004> <4.534, 2.242, 0.004> <4.530, 2.302, -0.058> <4.532, 2.302, -0.131> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.566, 2.200, -0.155> <3.568, 2.200, -0.228> <3.576, 2.139, -0.289> <3.583, 2.066, -0.288> 
		<3.855, 2.231, -0.148> <3.857, 2.230, -0.221> <3.865, 2.169, -0.282> <3.873, 2.097, -0.281> 
		<4.242, 2.271, -0.138> <4.244, 2.271, -0.211> <4.252, 2.210, -0.272> <4.259, 2.137, -0.271> 
		<4.532, 2.302, -0.131> <4.533, 2.301, -0.204> <4.541, 2.240, -0.264> <4.549, 2.167, -0.264> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.583, 2.066, -0.288> <3.591, 1.993, -0.288> <3.596, 1.933, -0.226> <3.594, 1.933, -0.153> 
		<3.873, 2.097, -0.281> <3.881, 2.024, -0.280> <3.885, 1.963, -0.219> <3.883, 1.964, -0.146> 
		<4.259, 2.137, -0.271> <4.267, 2.064, -0.271> <4.272, 2.004, -0.209> <4.270, 2.004, -0.136> 
		<4.549, 2.167, -0.264> <4.557, 2.095, -0.263> <4.561, 2.034, -0.202> <4.559, 2.035, -0.129> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.559, 2.035, -0.129> <4.558, 2.035, -0.055> <4.550, 2.096, 0.005> <4.542, 2.169, 0.004> 
		<4.270, 2.004, -0.136> <4.268, 2.005, -0.063> <4.260, 2.066, -0.002> <4.252, 2.139, -0.003> 
		<3.883, 1.964, -0.146> <3.881, 1.964, -0.072> <3.874, 2.025, -0.012> <3.866, 2.098, -0.013> 
		<3.594, 1.933, -0.153> <3.592, 1.934, -0.080> <3.584, 1.995, -0.019> <3.576, 2.068, -0.020> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.190, 2.142, -0.107> <4.188, 2.160, -0.107> <4.187, 2.174, -0.121> <4.187, 2.174, -0.139> 
		<4.479, 2.173, -0.099> <4.478, 2.190, -0.099> <4.476, 2.205, -0.114> <4.477, 2.204, -0.132> 
		<4.866, 2.213, -0.089> <4.864, 2.231, -0.090> <4.863, 2.245, -0.104> <4.863, 2.245, -0.122> 
		<5.156, 2.244, -0.082> <5.154, 2.261, -0.082> <5.153, 2.276, -0.097> <5.153, 2.275, -0.115> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.187, 2.174, -0.139> <4.188, 2.174, -0.157> <4.190, 2.159, -0.171> <4.191, 2.142, -0.171> 
		<4.477, 2.204, -0.132> <4.477, 2.204, -0.149> <4.479, 2.190, -0.164> <4.481, 2.172, -0.164> 
		<4.863, 2.245, -0.122> <4.864, 2.245, -0.139> <4.866, 2.230, -0.154> <4.867, 2.213, -0.154> 
		<5.153, 2.275, -0.115> <5.153, 2.275, -0.132> <5.155, 2.261, -0.147> <5.157, 2.243, -0.147> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.191, 2.142, -0.171> <4.193, 2.124, -0.171> <4.194, 2.110, -0.156> <4.194, 2.110, -0.138> 
		<4.481, 2.172, -0.164> <4.483, 2.155, -0.163> <4.484, 2.140, -0.149> <4.484, 2.140, -0.131> 
		<4.867, 2.213, -0.154> <4.869, 2.195, -0.154> <4.870, 2.181, -0.139> <4.870, 2.181, -0.121> 
		<5.157, 2.243, -0.147> <5.159, 2.226, -0.146> <5.160, 2.211, -0.132> <5.160, 2.211, -0.114> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.160, 2.211, -0.114> <5.159, 2.211, -0.096> <5.157, 2.226, -0.082> <5.156, 2.244, -0.082> 
		<4.870, 2.181, -0.121> <4.869, 2.181, -0.104> <4.868, 2.196, -0.089> <4.866, 2.213, -0.089> 
		<4.484, 2.140, -0.131> <4.483, 2.141, -0.114> <4.481, 2.155, -0.099> <4.479, 2.173, -0.099> 
		<4.194, 2.110, -0.138> <4.193, 2.110, -0.121> <4.192, 2.125, -0.106> <4.190, 2.142, -0.107> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.627, 2.137, -0.127> <4.626, 2.127, -0.127> <4.632, 2.111, -0.127> <4.624, 2.105, -0.127> 
		<4.628, 2.137, -0.142> <4.627, 2.127, -0.142> <4.632, 2.111, -0.148> <4.625, 2.105, -0.149> 
		<4.627, 2.145, -0.161> <4.626, 2.138, -0.168> <4.632, 2.121, -0.174> <4.624, 2.117, -0.178> 
		<4.627, 2.154, -0.171> <4.626, 2.148, -0.178> <4.631, 2.136, -0.189> <4.623, 2.132, -0.193> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.624, 2.105, -0.127> <4.610, 2.093, -0.128> <4.583, 2.083, -0.128> <4.564, 2.086, -0.129> 
		<4.625, 2.105, -0.149> <4.610, 2.093, -0.149> <4.583, 2.083, -0.152> <4.565, 2.086, -0.153> 
		<4.624, 2.117, -0.178> <4.609, 2.108, -0.186> <4.583, 2.098, -0.190> <4.564, 2.100, -0.186> 
		<4.623, 2.132, -0.193> <4.608, 2.123, -0.201> <4.581, 2.115, -0.207> <4.563, 2.117, -0.203> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.564, 2.086, -0.129> <4.554, 2.088, -0.129> <4.543, 2.112, -0.129> <4.551, 2.119, -0.129> 
		<4.565, 2.086, -0.153> <4.554, 2.088, -0.153> <4.544, 2.112, -0.146> <4.552, 2.119, -0.146> 
		<4.564, 2.100, -0.186> <4.554, 2.101, -0.184> <4.543, 2.123, -0.173> <4.551, 2.128, -0.168> 
		<4.563, 2.117, -0.203> <4.552, 2.118, -0.202> <4.542, 2.135, -0.184> <4.550, 2.140, -0.180> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.551, 2.119, -0.129> <4.568, 2.134, -0.129> <4.602, 2.133, -0.128> <4.624, 2.139, -0.128> 
		<4.552, 2.119, -0.146> <4.569, 2.134, -0.145> <4.602, 2.133, -0.142> <4.624, 2.139, -0.141> 
		<4.551, 2.128, -0.168> <4.568, 2.140, -0.158> <4.602, 2.142, -0.163> <4.624, 2.147, -0.160> 
		<4.550, 2.140, -0.180> <4.568, 2.151, -0.170> <4.601, 2.151, -0.172> <4.623, 2.156, -0.169> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.624, 2.155, -0.084> <4.623, 2.148, -0.077> <4.628, 2.137, -0.065> <4.620, 2.133, -0.062> 
		<4.626, 2.145, -0.094> <4.624, 2.138, -0.087> <4.629, 2.122, -0.080> <4.622, 2.118, -0.077> 
		<4.627, 2.137, -0.113> <4.626, 2.127, -0.113> <4.631, 2.111, -0.106> <4.624, 2.105, -0.106> 
		<4.627, 2.137, -0.127> <4.626, 2.127, -0.127> <4.632, 2.111, -0.127> <4.624, 2.105, -0.127> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.620, 2.133, -0.062> <4.605, 2.124, -0.055> <4.577, 2.116, -0.050> <4.559, 2.118, -0.055> 
		<4.622, 2.118, -0.077> <4.606, 2.109, -0.070> <4.580, 2.099, -0.067> <4.561, 2.100, -0.072> 
		<4.624, 2.105, -0.106> <4.609, 2.094, -0.106> <4.582, 2.083, -0.104> <4.563, 2.087, -0.105> 
		<4.624, 2.105, -0.127> <4.610, 2.093, -0.128> <4.583, 2.083, -0.128> <4.564, 2.086, -0.129> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.559, 2.118, -0.055> <4.549, 2.119, -0.057> <4.540, 2.135, -0.075> <4.548, 2.140, -0.079> 
		<4.561, 2.100, -0.072> <4.551, 2.102, -0.074> <4.541, 2.124, -0.086> <4.549, 2.129, -0.091> 
		<4.563, 2.087, -0.105> <4.553, 2.089, -0.105> <4.543, 2.112, -0.113> <4.551, 2.119, -0.113> 
		<4.564, 2.086, -0.129> <4.554, 2.088, -0.129> <4.543, 2.112, -0.129> <4.551, 2.119, -0.129> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.548, 2.140, -0.079> <4.565, 2.152, -0.088> <4.599, 2.152, -0.084> <4.621, 2.157, -0.086> 
		<4.549, 2.129, -0.091> <4.567, 2.140, -0.099> <4.600, 2.142, -0.093> <4.622, 2.147, -0.096> 
		<4.551, 2.119, -0.113> <4.568, 2.134, -0.113> <4.602, 2.133, -0.115> <4.624, 2.140, -0.114> 
		<4.551, 2.119, -0.129> <4.568, 2.134, -0.129> <4.602, 2.133, -0.128> <4.624, 2.139, -0.128> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.619, 2.199, -0.066> <4.617, 2.198, -0.057> <4.620, 2.199, -0.040> <4.612, 2.198, -0.035> 
		<4.621, 2.184, -0.066> <4.619, 2.184, -0.057> <4.623, 2.178, -0.040> <4.615, 2.177, -0.035> 
		<4.623, 2.165, -0.074> <4.622, 2.158, -0.067> <4.626, 2.152, -0.050> <4.618, 2.148, -0.047> 
		<4.624, 2.155, -0.084> <4.623, 2.148, -0.077> <4.628, 2.137, -0.065> <4.620, 2.133, -0.062> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.612, 2.198, -0.035> <4.596, 2.197, -0.025> <4.568, 2.194, -0.018> <4.550, 2.192, -0.024> 
		<4.615, 2.177, -0.035> <4.598, 2.175, -0.025> <4.571, 2.170, -0.018> <4.553, 2.168, -0.024> 
		<4.618, 2.148, -0.047> <4.603, 2.139, -0.040> <4.575, 2.133, -0.033> <4.557, 2.135, -0.038> 
		<4.620, 2.133, -0.062> <4.605, 2.124, -0.055> <4.577, 2.116, -0.050> <4.559, 2.118, -0.055> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.550, 2.192, -0.024> <4.540, 2.191, -0.028> <4.533, 2.190, -0.053> <4.542, 2.191, -0.059> 
		<4.553, 2.168, -0.024> <4.543, 2.167, -0.028> <4.535, 2.173, -0.053> <4.544, 2.174, -0.059> 
		<4.557, 2.135, -0.038> <4.547, 2.136, -0.040> <4.538, 2.147, -0.063> <4.546, 2.152, -0.068> 
		<4.559, 2.118, -0.055> <4.549, 2.119, -0.057> <4.540, 2.135, -0.075> <4.548, 2.140, -0.079> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.542, 2.191, -0.059> <4.561, 2.192, -0.071> <4.594, 2.196, -0.066> <4.616, 2.198, -0.069> 
		<4.544, 2.174, -0.059> <4.562, 2.176, -0.071> <4.595, 2.183, -0.066> <4.618, 2.185, -0.069> 
		<4.546, 2.152, -0.068> <4.564, 2.163, -0.077> <4.598, 2.161, -0.075> <4.620, 2.166, -0.077> 
		<4.548, 2.140, -0.079> <4.565, 2.152, -0.088> <4.599, 2.152, -0.084> <4.621, 2.157, -0.086> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.615, 2.242, -0.085> <4.612, 2.248, -0.078> <4.615, 2.261, -0.066> <4.606, 2.263, -0.063> 
		<4.616, 2.232, -0.074> <4.613, 2.238, -0.068> <4.616, 2.246, -0.051> <4.607, 2.248, -0.048> 
		<4.618, 2.213, -0.066> <4.616, 2.213, -0.057> <4.618, 2.220, -0.040> <4.610, 2.219, -0.035> 
		<4.619, 2.199, -0.066> <4.617, 2.198, -0.057> <4.620, 2.199, -0.040> <4.612, 2.198, -0.035> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.606, 2.263, -0.063> <4.589, 2.269, -0.056> <4.561, 2.271, -0.052> <4.543, 2.266, -0.056> 
		<4.607, 2.248, -0.048> <4.591, 2.254, -0.041> <4.562, 2.254, -0.034> <4.545, 2.249, -0.039> 
		<4.610, 2.219, -0.035> <4.594, 2.218, -0.026> <4.566, 2.218, -0.019> <4.548, 2.216, -0.025> 
		<4.612, 2.198, -0.035> <4.596, 2.197, -0.025> <4.568, 2.194, -0.018> <4.550, 2.192, -0.024> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.543, 2.266, -0.056> <4.534, 2.262, -0.058> <4.528, 2.244, -0.076> <4.537, 2.241, -0.080> 
		<4.545, 2.249, -0.039> <4.535, 2.245, -0.041> <4.529, 2.233, -0.064> <4.538, 2.229, -0.068> 
		<4.548, 2.216, -0.025> <4.538, 2.215, -0.028> <4.532, 2.206, -0.053> <4.540, 2.207, -0.059> 
		<4.550, 2.192, -0.024> <4.540, 2.191, -0.028> <4.533, 2.190, -0.053> <4.542, 2.191, -0.059> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.537, 2.241, -0.080> <4.557, 2.233, -0.089> <4.590, 2.240, -0.085> <4.612, 2.240, -0.087> 
		<4.538, 2.229, -0.068> <4.558, 2.222, -0.077> <4.591, 2.230, -0.075> <4.613, 2.230, -0.077> 
		<4.540, 2.207, -0.059> <4.559, 2.209, -0.072> <4.593, 2.209, -0.066> <4.615, 2.212, -0.069> 
		<4.542, 2.191, -0.059> <4.561, 2.192, -0.071> <4.594, 2.196, -0.066> <4.616, 2.198, -0.069> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.614, 2.260, -0.128> <4.612, 2.269, -0.129> <4.614, 2.286, -0.129> <4.605, 2.290, -0.129> 
		<4.614, 2.260, -0.114> <4.611, 2.269, -0.114> <4.613, 2.286, -0.107> <4.604, 2.290, -0.108> 
		<4.614, 2.252, -0.095> <4.612, 2.258, -0.088> <4.613, 2.275, -0.082> <4.605, 2.278, -0.078> 
		<4.615, 2.242, -0.085> <4.612, 2.248, -0.078> <4.615, 2.261, -0.066> <4.606, 2.263, -0.063> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.605, 2.290, -0.129> <4.588, 2.298, -0.129> <4.560, 2.303, -0.130> <4.542, 2.296, -0.131> 
		<4.604, 2.290, -0.108> <4.588, 2.299, -0.108> <4.559, 2.303, -0.106> <4.542, 2.296, -0.106> 
		<4.605, 2.278, -0.078> <4.588, 2.284, -0.071> <4.560, 2.288, -0.069> <4.542, 2.282, -0.073> 
		<4.606, 2.263, -0.063> <4.589, 2.269, -0.056> <4.561, 2.271, -0.052> <4.543, 2.266, -0.056> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.542, 2.296, -0.131> <4.532, 2.292, -0.131> <4.527, 2.266, -0.131> <4.537, 2.261, -0.130> 
		<4.542, 2.296, -0.106> <4.532, 2.292, -0.107> <4.527, 2.266, -0.114> <4.536, 2.261, -0.114> 
		<4.542, 2.282, -0.073> <4.532, 2.279, -0.076> <4.527, 2.255, -0.088> <4.536, 2.252, -0.092> 
		<4.543, 2.266, -0.056> <4.534, 2.262, -0.058> <4.528, 2.244, -0.076> <4.537, 2.241, -0.080> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.537, 2.261, -0.130> <4.556, 2.250, -0.130> <4.589, 2.258, -0.129> <4.612, 2.256, -0.129> 
		<4.536, 2.261, -0.114> <4.556, 2.250, -0.114> <4.589, 2.258, -0.116> <4.611, 2.256, -0.115> 
		<4.536, 2.252, -0.092> <4.556, 2.245, -0.100> <4.589, 2.249, -0.094> <4.612, 2.249, -0.096> 
		<4.537, 2.241, -0.080> <4.557, 2.233, -0.089> <4.590, 2.240, -0.085> <4.612, 2.240, -0.087> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.617, 2.242, -0.172> <4.615, 2.248, -0.179> <4.618, 2.260, -0.190> <4.610, 2.263, -0.194> 
		<4.616, 2.252, -0.162> <4.614, 2.258, -0.169> <4.616, 2.275, -0.176> <4.608, 2.278, -0.179> 
		<4.615, 2.260, -0.143> <4.612, 2.269, -0.143> <4.614, 2.286, -0.150> <4.606, 2.290, -0.150> 
		<4.614, 2.260, -0.128> <4.612, 2.269, -0.129> <4.614, 2.286, -0.129> <4.605, 2.290, -0.129> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.610, 2.263, -0.194> <4.593, 2.268, -0.202> <4.565, 2.270, -0.208> <4.547, 2.265, -0.205> 
		<4.608, 2.278, -0.179> <4.591, 2.283, -0.187> <4.563, 2.288, -0.191> <4.545, 2.282, -0.188> 
		<4.606, 2.290, -0.150> <4.589, 2.298, -0.151> <4.560, 2.303, -0.154> <4.543, 2.296, -0.155> 
		<4.605, 2.290, -0.129> <4.588, 2.298, -0.129> <4.560, 2.303, -0.130> <4.542, 2.296, -0.131> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.547, 2.265, -0.205> <4.537, 2.262, -0.203> <4.531, 2.243, -0.185> <4.540, 2.240, -0.181> 
		<4.545, 2.282, -0.188> <4.535, 2.279, -0.186> <4.530, 2.255, -0.174> <4.538, 2.252, -0.169> 
		<4.543, 2.296, -0.155> <4.533, 2.292, -0.155> <4.528, 2.266, -0.147> <4.537, 2.261, -0.147> 
		<4.542, 2.296, -0.131> <4.532, 2.292, -0.131> <4.527, 2.266, -0.131> <4.537, 2.261, -0.130> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.540, 2.240, -0.181> <4.559, 2.233, -0.171> <4.592, 2.239, -0.173> <4.615, 2.239, -0.170> 
		<4.538, 2.252, -0.169> <4.557, 2.244, -0.159> <4.591, 2.249, -0.164> <4.613, 2.249, -0.160> 
		<4.537, 2.261, -0.147> <4.557, 2.250, -0.146> <4.589, 2.258, -0.143> <4.612, 2.256, -0.142> 
		<4.537, 2.261, -0.130> <4.556, 2.250, -0.130> <4.589, 2.258, -0.129> <4.612, 2.256, -0.129> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.622, 2.198, -0.190> <4.621, 2.198, -0.199> <4.625, 2.198, -0.216> <4.617, 2.197, -0.221> 
		<4.621, 2.212, -0.190> <4.619, 2.212, -0.199> <4.623, 2.219, -0.216> <4.615, 2.218, -0.221> 
		<4.619, 2.231, -0.182> <4.616, 2.238, -0.189> <4.620, 2.245, -0.205> <4.612, 2.247, -0.209> 
		<4.617, 2.242, -0.172> <4.615, 2.248, -0.179> <4.618, 2.260, -0.190> <4.610, 2.263, -0.194> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.617, 2.197, -0.221> <4.601, 2.195, -0.231> <4.574, 2.192, -0.240> <4.556, 2.191, -0.235> 
		<4.615, 2.218, -0.221> <4.599, 2.217, -0.232> <4.572, 2.216, -0.240> <4.553, 2.215, -0.235> 
		<4.612, 2.247, -0.209> <4.595, 2.253, -0.217> <4.567, 2.253, -0.225> <4.550, 2.248, -0.222> 
		<4.610, 2.263, -0.194> <4.593, 2.268, -0.202> <4.565, 2.270, -0.208> <4.547, 2.265, -0.205> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.556, 2.191, -0.235> <4.546, 2.190, -0.232> <4.537, 2.189, -0.207> <4.546, 2.190, -0.201> 
		<4.553, 2.215, -0.235> <4.543, 2.214, -0.232> <4.536, 2.205, -0.208> <4.544, 2.206, -0.201> 
		<4.550, 2.248, -0.222> <4.540, 2.244, -0.220> <4.533, 2.232, -0.197> <4.541, 2.228, -0.192> 
		<4.547, 2.265, -0.205> <4.537, 2.262, -0.203> <4.531, 2.243, -0.185> <4.540, 2.240, -0.181> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.546, 2.190, -0.201> <4.564, 2.192, -0.187> <4.597, 2.195, -0.191> <4.619, 2.198, -0.187> 
		<4.544, 2.206, -0.201> <4.562, 2.208, -0.188> <4.596, 2.209, -0.191> <4.618, 2.211, -0.187> 
		<4.541, 2.228, -0.192> <4.560, 2.221, -0.182> <4.593, 2.230, -0.183> <4.616, 2.230, -0.179> 
		<4.540, 2.240, -0.181> <4.559, 2.233, -0.171> <4.592, 2.239, -0.173> <4.615, 2.239, -0.170> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.627, 2.154, -0.171> <4.626, 2.148, -0.178> <4.631, 2.136, -0.189> <4.623, 2.132, -0.193> 
		<4.626, 2.164, -0.181> <4.625, 2.158, -0.188> <4.630, 2.151, -0.205> <4.622, 2.147, -0.208> 
		<4.624, 2.184, -0.190> <4.622, 2.184, -0.199> <4.627, 2.177, -0.215> <4.619, 2.176, -0.221> 
		<4.622, 2.198, -0.190> <4.621, 2.198, -0.199> <4.625, 2.198, -0.216> <4.617, 2.197, -0.221> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.623, 2.132, -0.193> <4.608, 2.123, -0.201> <4.581, 2.115, -0.207> <4.563, 2.117, -0.203> 
		<4.622, 2.147, -0.208> <4.607, 2.138, -0.216> <4.580, 2.132, -0.224> <4.561, 2.134, -0.221> 
		<4.619, 2.176, -0.221> <4.604, 2.174, -0.231> <4.577, 2.168, -0.240> <4.558, 2.167, -0.235> 
		<4.617, 2.197, -0.221> <4.601, 2.195, -0.231> <4.574, 2.192, -0.240> <4.556, 2.191, -0.235> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.563, 2.117, -0.203> <4.552, 2.118, -0.202> <4.542, 2.135, -0.184> <4.550, 2.140, -0.180> 
		<4.561, 2.134, -0.221> <4.551, 2.135, -0.219> <4.542, 2.146, -0.196> <4.550, 2.151, -0.191> 
		<4.558, 2.167, -0.235> <4.548, 2.165, -0.232> <4.539, 2.173, -0.207> <4.547, 2.174, -0.201> 
		<4.556, 2.191, -0.235> <4.546, 2.190, -0.232> <4.537, 2.189, -0.207> <4.546, 2.190, -0.201> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.550, 2.140, -0.180> <4.568, 2.151, -0.170> <4.601, 2.151, -0.172> <4.623, 2.156, -0.169> 
		<4.550, 2.151, -0.191> <4.567, 2.162, -0.182> <4.601, 2.161, -0.182> <4.622, 2.166, -0.179> 
		<4.547, 2.174, -0.201> <4.565, 2.176, -0.187> <4.599, 2.182, -0.191> <4.621, 2.184, -0.187> 
		<4.546, 2.190, -0.201> <4.564, 2.192, -0.187> <4.597, 2.195, -0.191> <4.619, 2.198, -0.187> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.224, 2.188, -0.151> <5.225, 2.179, -0.149> <5.227, 2.162, -0.153> <5.227, 2.157, -0.144> 
		<5.210, 2.186, -0.151> <5.211, 2.177, -0.149> <5.206, 2.160, -0.153> <5.206, 2.155, -0.145> 
		<5.190, 2.192, -0.151> <5.184, 2.185, -0.149> <5.179, 2.168, -0.153> <5.176, 2.164, -0.145> 
		<5.179, 2.201, -0.151> <5.173, 2.194, -0.150> <5.162, 2.181, -0.153> <5.159, 2.177, -0.145> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.227, 2.157, -0.144> <5.228, 2.147, -0.128> <5.229, 2.140, -0.101> <5.228, 2.145, -0.082> 
		<5.206, 2.155, -0.145> <5.207, 2.145, -0.129> <5.205, 2.137, -0.101> <5.204, 2.143, -0.083> 
		<5.176, 2.164, -0.145> <5.169, 2.156, -0.129> <5.166, 2.149, -0.101> <5.170, 2.153, -0.083> 
		<5.159, 2.177, -0.145> <5.153, 2.170, -0.129> <5.148, 2.164, -0.101> <5.151, 2.168, -0.083> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.228, 2.145, -0.082> <5.228, 2.148, -0.072> <5.225, 2.173, -0.065> <5.224, 2.179, -0.073> 
		<5.204, 2.143, -0.083> <5.204, 2.146, -0.073> <5.209, 2.172, -0.065> <5.208, 2.178, -0.074> 
		<5.170, 2.153, -0.083> <5.172, 2.156, -0.073> <5.181, 2.180, -0.065> <5.185, 2.184, -0.074> 
		<5.151, 2.168, -0.083> <5.153, 2.171, -0.073> <5.168, 2.190, -0.065> <5.172, 2.195, -0.074> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.224, 2.179, -0.073> <5.223, 2.192, -0.092> <5.224, 2.188, -0.126> <5.224, 2.191, -0.148> 
		<5.208, 2.178, -0.074> <5.207, 2.191, -0.092> <5.211, 2.186, -0.126> <5.210, 2.190, -0.148> 
		<5.185, 2.184, -0.074> <5.193, 2.195, -0.092> <5.189, 2.193, -0.126> <5.191, 2.195, -0.148> 
		<5.172, 2.195, -0.074> <5.181, 2.205, -0.092> <5.178, 2.201, -0.126> <5.181, 2.204, -0.148> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.266, 2.211, -0.151> <5.273, 2.205, -0.149> <5.286, 2.194, -0.152> <5.290, 2.191, -0.144> 
		<5.257, 2.199, -0.151> <5.264, 2.194, -0.149> <5.273, 2.178, -0.152> <5.276, 2.175, -0.144> 
		<5.238, 2.189, -0.151> <5.239, 2.180, -0.149> <5.248, 2.164, -0.152> <5.249, 2.159, -0.144> 
		<5.224, 2.188, -0.151> <5.225, 2.179, -0.149> <5.227, 2.162, -0.153> <5.227, 2.157, -0.144> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.290, 2.191, -0.144> <5.298, 2.185, -0.128> <5.303, 2.180, -0.100> <5.299, 2.184, -0.082> 
		<5.276, 2.175, -0.144> <5.284, 2.168, -0.128> <5.288, 2.161, -0.100> <5.284, 2.165, -0.082> 
		<5.249, 2.159, -0.144> <5.249, 2.149, -0.128> <5.253, 2.142, -0.100> <5.252, 2.148, -0.082> 
		<5.227, 2.157, -0.144> <5.228, 2.147, -0.128> <5.229, 2.140, -0.101> <5.228, 2.145, -0.082> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.299, 2.184, -0.082> <5.296, 2.186, -0.072> <5.277, 2.201, -0.065> <5.272, 2.205, -0.073> 
		<5.284, 2.165, -0.082> <5.281, 2.167, -0.072> <5.267, 2.189, -0.065> <5.262, 2.193, -0.073> 
		<5.252, 2.148, -0.082> <5.252, 2.151, -0.072> <5.241, 2.175, -0.065> <5.241, 2.181, -0.073> 
		<5.228, 2.145, -0.082> <5.228, 2.148, -0.072> <5.225, 2.173, -0.065> <5.224, 2.179, -0.073> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.272, 2.205, -0.073> <5.262, 2.213, -0.092> <5.266, 2.210, -0.125> <5.263, 2.213, -0.148> 
		<5.262, 2.193, -0.073> <5.252, 2.201, -0.092> <5.258, 2.200, -0.125> <5.255, 2.202, -0.148> 
		<5.241, 2.181, -0.073> <5.240, 2.194, -0.092> <5.237, 2.189, -0.125> <5.237, 2.192, -0.148> 
		<5.224, 2.179, -0.073> <5.223, 2.192, -0.092> <5.224, 2.188, -0.126> <5.224, 2.191, -0.148> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.279, 2.256, -0.151> <5.289, 2.257, -0.149> <5.305, 2.259, -0.153> <5.310, 2.259, -0.145> 
		<5.281, 2.242, -0.151> <5.290, 2.243, -0.149> <5.307, 2.237, -0.152> <5.312, 2.238, -0.144> 
		<5.275, 2.222, -0.151> <5.282, 2.216, -0.149> <5.299, 2.211, -0.152> <5.303, 2.208, -0.144> 
		<5.266, 2.211, -0.151> <5.273, 2.205, -0.149> <5.286, 2.194, -0.152> <5.290, 2.191, -0.144> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.310, 2.259, -0.145> <5.320, 2.260, -0.129> <5.327, 2.261, -0.101> <5.322, 2.261, -0.083> 
		<5.312, 2.238, -0.144> <5.322, 2.239, -0.128> <5.330, 2.237, -0.100> <5.324, 2.237, -0.082> 
		<5.303, 2.208, -0.144> <5.311, 2.201, -0.128> <5.319, 2.199, -0.100> <5.314, 2.203, -0.082> 
		<5.290, 2.191, -0.144> <5.298, 2.185, -0.128> <5.303, 2.180, -0.100> <5.299, 2.184, -0.082> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.322, 2.261, -0.083> <5.319, 2.261, -0.072> <5.294, 2.258, -0.065> <5.288, 2.258, -0.074> 
		<5.324, 2.237, -0.082> <5.321, 2.237, -0.072> <5.296, 2.242, -0.065> <5.290, 2.241, -0.073> 
		<5.314, 2.203, -0.082> <5.312, 2.205, -0.072> <5.287, 2.214, -0.065> <5.283, 2.218, -0.073> 
		<5.299, 2.184, -0.082> <5.296, 2.186, -0.072> <5.277, 2.201, -0.065> <5.272, 2.205, -0.073> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.288, 2.258, -0.074> <5.275, 2.256, -0.092> <5.280, 2.256, -0.126> <5.276, 2.256, -0.148> 
		<5.290, 2.241, -0.073> <5.277, 2.240, -0.092> <5.281, 2.243, -0.125> <5.278, 2.242, -0.148> 
		<5.283, 2.218, -0.073> <5.273, 2.226, -0.092> <5.275, 2.221, -0.125> <5.272, 2.223, -0.148> 
		<5.272, 2.205, -0.073> <5.262, 2.213, -0.092> <5.266, 2.210, -0.125> <5.263, 2.213, -0.148> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.257, 2.298, -0.151> <5.263, 2.305, -0.150> <5.273, 2.318, -0.153> <5.276, 2.322, -0.145> 
		<5.268, 2.289, -0.151> <5.274, 2.296, -0.149> <5.290, 2.304, -0.153> <5.293, 2.308, -0.145> 
		<5.278, 2.270, -0.151> <5.287, 2.271, -0.149> <5.303, 2.280, -0.153> <5.308, 2.280, -0.145> 
		<5.279, 2.256, -0.151> <5.289, 2.257, -0.149> <5.305, 2.259, -0.153> <5.310, 2.259, -0.145> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.276, 2.322, -0.145> <5.282, 2.330, -0.129> <5.287, 2.336, -0.102> <5.283, 2.332, -0.083> 
		<5.293, 2.308, -0.145> <5.299, 2.316, -0.129> <5.306, 2.321, -0.101> <5.302, 2.317, -0.083> 
		<5.308, 2.280, -0.145> <5.318, 2.282, -0.129> <5.325, 2.285, -0.101> <5.319, 2.285, -0.083> 
		<5.310, 2.259, -0.145> <5.320, 2.260, -0.129> <5.327, 2.261, -0.101> <5.322, 2.261, -0.083> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.283, 2.332, -0.083> <5.281, 2.329, -0.073> <5.266, 2.310, -0.066> <5.262, 2.305, -0.074> 
		<5.302, 2.317, -0.083> <5.300, 2.314, -0.073> <5.278, 2.300, -0.065> <5.275, 2.295, -0.074> 
		<5.319, 2.285, -0.083> <5.316, 2.285, -0.073> <5.292, 2.274, -0.065> <5.286, 2.274, -0.074> 
		<5.322, 2.261, -0.083> <5.319, 2.261, -0.072> <5.294, 2.258, -0.065> <5.288, 2.258, -0.074> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.262, 2.305, -0.074> <5.254, 2.295, -0.092> <5.257, 2.298, -0.126> <5.255, 2.295, -0.148> 
		<5.275, 2.295, -0.074> <5.266, 2.285, -0.092> <5.267, 2.290, -0.126> <5.265, 2.287, -0.148> 
		<5.286, 2.274, -0.074> <5.273, 2.272, -0.092> <5.278, 2.270, -0.126> <5.275, 2.269, -0.148> 
		<5.288, 2.258, -0.074> <5.275, 2.256, -0.092> <5.280, 2.256, -0.126> <5.276, 2.256, -0.148> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.211, 2.311, -0.152> <5.210, 2.320, -0.150> <5.209, 2.337, -0.154> <5.208, 2.342, -0.146> 
		<5.225, 2.313, -0.152> <5.224, 2.322, -0.150> <5.230, 2.339, -0.154> <5.229, 2.344, -0.146> 
		<5.246, 2.307, -0.152> <5.251, 2.314, -0.150> <5.256, 2.331, -0.154> <5.260, 2.335, -0.146> 
		<5.257, 2.298, -0.151> <5.263, 2.305, -0.150> <5.273, 2.318, -0.153> <5.276, 2.322, -0.145> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.208, 2.342, -0.146> <5.207, 2.352, -0.130> <5.206, 2.360, -0.102> <5.206, 2.355, -0.084> 
		<5.229, 2.344, -0.146> <5.228, 2.354, -0.130> <5.230, 2.363, -0.102> <5.230, 2.357, -0.084> 
		<5.260, 2.335, -0.146> <5.266, 2.343, -0.130> <5.268, 2.351, -0.102> <5.265, 2.347, -0.084> 
		<5.276, 2.322, -0.145> <5.282, 2.330, -0.129> <5.287, 2.336, -0.102> <5.283, 2.332, -0.083> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.206, 2.355, -0.084> <5.206, 2.352, -0.074> <5.209, 2.327, -0.066> <5.210, 2.321, -0.075> 
		<5.230, 2.357, -0.084> <5.230, 2.354, -0.074> <5.225, 2.329, -0.066> <5.226, 2.323, -0.075> 
		<5.265, 2.347, -0.084> <5.263, 2.345, -0.074> <5.253, 2.321, -0.066> <5.249, 2.316, -0.074> 
		<5.283, 2.332, -0.083> <5.281, 2.329, -0.073> <5.266, 2.310, -0.066> <5.262, 2.305, -0.074> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.210, 2.321, -0.075> <5.211, 2.308, -0.093> <5.211, 2.312, -0.127> <5.212, 2.308, -0.149> 
		<5.226, 2.323, -0.075> <5.227, 2.309, -0.093> <5.224, 2.313, -0.127> <5.225, 2.309, -0.149> 
		<5.249, 2.316, -0.074> <5.241, 2.305, -0.093> <5.246, 2.307, -0.126> <5.244, 2.304, -0.149> 
		<5.262, 2.305, -0.074> <5.254, 2.295, -0.092> <5.257, 2.298, -0.126> <5.255, 2.295, -0.148> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.170, 2.288, -0.152> <5.162, 2.294, -0.150> <5.150, 2.305, -0.154> <5.146, 2.308, -0.146> 
		<5.179, 2.300, -0.152> <5.171, 2.305, -0.150> <5.163, 2.321, -0.154> <5.159, 2.325, -0.146> 
		<5.197, 2.310, -0.152> <5.196, 2.319, -0.150> <5.187, 2.335, -0.154> <5.187, 2.340, -0.146> 
		<5.211, 2.311, -0.152> <5.210, 2.320, -0.150> <5.209, 2.337, -0.154> <5.208, 2.342, -0.146> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.146, 2.308, -0.146> <5.137, 2.315, -0.130> <5.131, 2.320, -0.103> <5.135, 2.316, -0.085> 
		<5.159, 2.325, -0.146> <5.151, 2.331, -0.130> <5.146, 2.338, -0.103> <5.151, 2.335, -0.085> 
		<5.187, 2.340, -0.146> <5.186, 2.350, -0.130> <5.182, 2.358, -0.103> <5.182, 2.352, -0.084> 
		<5.208, 2.342, -0.146> <5.207, 2.352, -0.130> <5.206, 2.360, -0.102> <5.206, 2.355, -0.084> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.135, 2.316, -0.085> <5.138, 2.314, -0.074> <5.157, 2.299, -0.066> <5.162, 2.295, -0.075> 
		<5.151, 2.335, -0.085> <5.153, 2.333, -0.074> <5.167, 2.312, -0.066> <5.172, 2.308, -0.075> 
		<5.182, 2.352, -0.084> <5.182, 2.349, -0.074> <5.193, 2.325, -0.066> <5.193, 2.319, -0.075> 
		<5.206, 2.355, -0.084> <5.206, 2.352, -0.074> <5.209, 2.327, -0.066> <5.210, 2.321, -0.075> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.162, 2.295, -0.075> <5.172, 2.287, -0.093> <5.169, 2.289, -0.127> <5.172, 2.287, -0.149> 
		<5.172, 2.308, -0.075> <5.182, 2.299, -0.093> <5.177, 2.300, -0.127> <5.181, 2.297, -0.149> 
		<5.193, 2.319, -0.075> <5.195, 2.306, -0.093> <5.198, 2.310, -0.127> <5.198, 2.307, -0.149> 
		<5.210, 2.321, -0.075> <5.211, 2.308, -0.093> <5.211, 2.312, -0.127> <5.212, 2.308, -0.149> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.156, 2.243, -0.152> <5.147, 2.242, -0.150> <5.130, 2.240, -0.154> <5.125, 2.240, -0.146> 
		<5.155, 2.257, -0.152> <5.145, 2.256, -0.150> <5.128, 2.262, -0.154> <5.123, 2.261, -0.146> 
		<5.161, 2.277, -0.152> <5.153, 2.283, -0.150> <5.136, 2.288, -0.154> <5.132, 2.291, -0.146> 
		<5.170, 2.288, -0.152> <5.162, 2.294, -0.150> <5.150, 2.305, -0.154> <5.146, 2.308, -0.146> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.125, 2.240, -0.146> <5.115, 2.239, -0.130> <5.107, 2.238, -0.102> <5.112, 2.239, -0.084> 
		<5.123, 2.261, -0.146> <5.113, 2.260, -0.130> <5.105, 2.262, -0.103> <5.110, 2.263, -0.084> 
		<5.132, 2.291, -0.146> <5.124, 2.298, -0.130> <5.116, 2.301, -0.103> <5.120, 2.298, -0.085> 
		<5.146, 2.308, -0.146> <5.137, 2.315, -0.130> <5.131, 2.320, -0.103> <5.135, 2.316, -0.085> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.112, 2.239, -0.084> <5.115, 2.239, -0.074> <5.140, 2.242, -0.066> <5.146, 2.243, -0.075> 
		<5.110, 2.263, -0.084> <5.113, 2.263, -0.074> <5.138, 2.258, -0.066> <5.145, 2.259, -0.075> 
		<5.120, 2.298, -0.085> <5.122, 2.296, -0.074> <5.147, 2.286, -0.066> <5.151, 2.282, -0.075> 
		<5.135, 2.316, -0.085> <5.138, 2.314, -0.074> <5.157, 2.299, -0.066> <5.162, 2.295, -0.075> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.146, 2.243, -0.075> <5.159, 2.244, -0.093> <5.155, 2.243, -0.127> <5.159, 2.243, -0.149> 
		<5.145, 2.259, -0.075> <5.158, 2.260, -0.093> <5.154, 2.257, -0.127> <5.158, 2.257, -0.149> 
		<5.151, 2.282, -0.075> <5.162, 2.274, -0.093> <5.160, 2.279, -0.127> <5.164, 2.276, -0.149> 
		<5.162, 2.295, -0.075> <5.172, 2.287, -0.093> <5.169, 2.289, -0.127> <5.172, 2.287, -0.149> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.179, 2.201, -0.151> <5.173, 2.194, -0.150> <5.162, 2.181, -0.153> <5.159, 2.177, -0.145> 
		<5.168, 2.210, -0.152> <5.162, 2.203, -0.150> <5.146, 2.195, -0.153> <5.143, 2.191, -0.145> 
		<5.158, 2.229, -0.152> <5.148, 2.228, -0.150> <5.133, 2.219, -0.154> <5.128, 2.219, -0.146> 
		<5.156, 2.243, -0.152> <5.147, 2.242, -0.150> <5.130, 2.240, -0.154> <5.125, 2.240, -0.146> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.159, 2.177, -0.145> <5.153, 2.170, -0.129> <5.148, 2.164, -0.101> <5.151, 2.168, -0.083> 
		<5.143, 2.191, -0.145> <5.136, 2.183, -0.129> <5.129, 2.179, -0.102> <5.132, 2.183, -0.084> 
		<5.128, 2.219, -0.146> <5.117, 2.218, -0.130> <5.110, 2.214, -0.102> <5.115, 2.215, -0.084> 
		<5.125, 2.240, -0.146> <5.115, 2.239, -0.130> <5.107, 2.238, -0.102> <5.112, 2.239, -0.084> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.151, 2.168, -0.083> <5.153, 2.171, -0.073> <5.168, 2.190, -0.065> <5.172, 2.195, -0.074> 
		<5.132, 2.183, -0.084> <5.134, 2.186, -0.073> <5.156, 2.200, -0.066> <5.160, 2.205, -0.074> 
		<5.115, 2.215, -0.084> <5.118, 2.215, -0.074> <5.142, 2.226, -0.066> <5.148, 2.226, -0.074> 
		<5.112, 2.239, -0.084> <5.115, 2.239, -0.074> <5.140, 2.242, -0.066> <5.146, 2.243, -0.075> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.172, 2.195, -0.074> <5.181, 2.205, -0.092> <5.178, 2.201, -0.126> <5.181, 2.204, -0.148> 
		<5.160, 2.205, -0.074> <5.168, 2.215, -0.093> <5.168, 2.210, -0.126> <5.170, 2.212, -0.148> 
		<5.148, 2.226, -0.074> <5.161, 2.228, -0.093> <5.157, 2.230, -0.126> <5.161, 2.230, -0.149> 
		<5.146, 2.243, -0.075> <5.159, 2.244, -0.093> <5.155, 2.243, -0.127> <5.159, 2.243, -0.149> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.510, 1.997, -0.194> <3.510, 1.988, -0.192> <3.512, 1.971, -0.196> <3.513, 1.966, -0.188> 
		<3.495, 1.995, -0.194> <3.496, 1.986, -0.192> <3.491, 1.969, -0.196> <3.491, 1.964, -0.188> 
		<3.475, 2.001, -0.195> <3.469, 1.994, -0.193> <3.464, 1.977, -0.196> <3.461, 1.973, -0.188> 
		<3.464, 2.010, -0.195> <3.458, 2.003, -0.193> <3.448, 1.990, -0.197> <3.445, 1.986, -0.189> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.513, 1.966, -0.188> <3.514, 1.956, -0.172> <3.514, 1.949, -0.144> <3.513, 1.954, -0.126> 
		<3.491, 1.964, -0.188> <3.492, 1.954, -0.172> <3.490, 1.946, -0.144> <3.489, 1.952, -0.126> 
		<3.461, 1.973, -0.188> <3.455, 1.965, -0.172> <3.452, 1.958, -0.144> <3.455, 1.962, -0.126> 
		<3.445, 1.986, -0.189> <3.438, 1.979, -0.173> <3.433, 1.973, -0.145> <3.436, 1.977, -0.127> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.513, 1.954, -0.126> <3.513, 1.958, -0.116> <3.510, 1.982, -0.108> <3.510, 1.988, -0.117> 
		<3.489, 1.952, -0.126> <3.489, 1.955, -0.116> <3.494, 1.981, -0.108> <3.494, 1.987, -0.117> 
		<3.455, 1.962, -0.126> <3.457, 1.965, -0.116> <3.466, 1.989, -0.109> <3.470, 1.994, -0.117> 
		<3.436, 1.977, -0.127> <3.438, 1.980, -0.117> <3.454, 1.999, -0.109> <3.458, 2.004, -0.117> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.510, 1.988, -0.117> <3.509, 2.001, -0.135> <3.509, 1.997, -0.169> <3.509, 2.000, -0.191> 
		<3.494, 1.987, -0.117> <3.492, 2.000, -0.135> <3.496, 1.995, -0.169> <3.496, 1.999, -0.191> 
		<3.470, 1.994, -0.117> <3.479, 2.004, -0.136> <3.474, 2.002, -0.169> <3.477, 2.004, -0.191> 
		<3.458, 2.004, -0.117> <3.466, 2.014, -0.136> <3.463, 2.010, -0.169> <3.466, 2.013, -0.192> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.551, 2.020, -0.194> <3.558, 2.014, -0.192> <3.571, 2.003, -0.196> <3.575, 2.000, -0.188> 
		<3.542, 2.009, -0.194> <3.549, 2.003, -0.192> <3.558, 1.987, -0.196> <3.562, 1.984, -0.188> 
		<3.524, 1.998, -0.194> <3.525, 1.989, -0.192> <3.533, 1.973, -0.196> <3.534, 1.968, -0.188> 
		<3.510, 1.997, -0.194> <3.510, 1.988, -0.192> <3.512, 1.971, -0.196> <3.513, 1.966, -0.188> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.575, 2.000, -0.188> <3.583, 1.994, -0.171> <3.589, 1.989, -0.144> <3.584, 1.993, -0.125> 
		<3.562, 1.984, -0.188> <3.569, 1.977, -0.171> <3.573, 1.970, -0.144> <3.569, 1.974, -0.125> 
		<3.534, 1.968, -0.188> <3.535, 1.958, -0.172> <3.538, 1.951, -0.144> <3.537, 1.957, -0.126> 
		<3.513, 1.966, -0.188> <3.514, 1.956, -0.172> <3.514, 1.949, -0.144> <3.513, 1.954, -0.126> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.584, 1.993, -0.125> <3.582, 1.995, -0.115> <3.562, 2.010, -0.108> <3.558, 2.014, -0.117> 
		<3.569, 1.974, -0.125> <3.567, 1.976, -0.115> <3.552, 1.998, -0.108> <3.547, 2.002, -0.117> 
		<3.537, 1.957, -0.126> <3.537, 1.960, -0.116> <3.527, 1.984, -0.108> <3.526, 1.990, -0.117> 
		<3.513, 1.954, -0.126> <3.513, 1.958, -0.116> <3.510, 1.982, -0.108> <3.510, 1.988, -0.117> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.558, 2.014, -0.117> <3.548, 2.022, -0.135> <3.551, 2.019, -0.169> <3.549, 2.022, -0.191> 
		<3.547, 2.002, -0.117> <3.537, 2.010, -0.135> <3.543, 2.009, -0.169> <3.540, 2.011, -0.191> 
		<3.526, 1.990, -0.117> <3.525, 2.003, -0.135> <3.523, 1.998, -0.169> <3.523, 2.001, -0.191> 
		<3.510, 1.988, -0.117> <3.509, 2.001, -0.135> <3.509, 1.997, -0.169> <3.509, 2.000, -0.191> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.565, 2.065, -0.194> <3.574, 2.066, -0.192> <3.590, 2.068, -0.196> <3.595, 2.068, -0.188> 
		<3.566, 2.051, -0.194> <3.575, 2.052, -0.192> <3.593, 2.046, -0.196> <3.598, 2.047, -0.188> 
		<3.560, 2.031, -0.194> <3.567, 2.025, -0.192> <3.585, 2.020, -0.196> <3.589, 2.017, -0.188> 
		<3.551, 2.020, -0.194> <3.558, 2.014, -0.192> <3.571, 2.003, -0.196> <3.575, 2.000, -0.188> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.595, 2.068, -0.188> <3.605, 2.069, -0.172> <3.613, 2.070, -0.144> <3.607, 2.070, -0.126> 
		<3.598, 2.047, -0.188> <3.608, 2.048, -0.172> <3.615, 2.046, -0.144> <3.610, 2.046, -0.126> 
		<3.589, 2.017, -0.188> <3.596, 2.010, -0.171> <3.604, 2.008, -0.144> <3.599, 2.012, -0.125> 
		<3.575, 2.000, -0.188> <3.583, 1.994, -0.171> <3.589, 1.989, -0.144> <3.584, 1.993, -0.125> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.607, 2.070, -0.126> <3.604, 2.070, -0.116> <3.579, 2.067, -0.108> <3.573, 2.067, -0.117> 
		<3.610, 2.046, -0.126> <3.607, 2.046, -0.116> <3.581, 2.051, -0.108> <3.575, 2.050, -0.117> 
		<3.599, 2.012, -0.125> <3.597, 2.014, -0.115> <3.573, 2.023, -0.108> <3.568, 2.027, -0.117> 
		<3.584, 1.993, -0.125> <3.582, 1.995, -0.115> <3.562, 2.010, -0.108> <3.558, 2.014, -0.117> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.573, 2.067, -0.117> <3.560, 2.065, -0.135> <3.565, 2.065, -0.169> <3.562, 2.065, -0.191> 
		<3.575, 2.050, -0.117> <3.562, 2.049, -0.135> <3.566, 2.052, -0.169> <3.563, 2.051, -0.191> 
		<3.568, 2.027, -0.117> <3.558, 2.035, -0.135> <3.560, 2.030, -0.169> <3.557, 2.032, -0.191> 
		<3.558, 2.014, -0.117> <3.548, 2.022, -0.135> <3.551, 2.019, -0.169> <3.549, 2.022, -0.191> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.542, 2.107, -0.195> <3.548, 2.114, -0.193> <3.558, 2.127, -0.197> <3.561, 2.131, -0.189> 
		<3.553, 2.098, -0.195> <3.559, 2.105, -0.193> <3.575, 2.113, -0.196> <3.578, 2.117, -0.188> 
		<3.563, 2.079, -0.194> <3.572, 2.080, -0.192> <3.588, 2.089, -0.196> <3.593, 2.089, -0.188> 
		<3.565, 2.065, -0.194> <3.574, 2.066, -0.192> <3.590, 2.068, -0.196> <3.595, 2.068, -0.188> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.561, 2.131, -0.189> <3.568, 2.139, -0.173> <3.572, 2.145, -0.145> <3.569, 2.141, -0.127> 
		<3.578, 2.117, -0.188> <3.584, 2.125, -0.172> <3.591, 2.130, -0.145> <3.588, 2.126, -0.126> 
		<3.593, 2.089, -0.188> <3.603, 2.091, -0.172> <3.610, 2.094, -0.144> <3.605, 2.094, -0.126> 
		<3.595, 2.068, -0.188> <3.605, 2.069, -0.172> <3.613, 2.070, -0.144> <3.607, 2.070, -0.126> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.569, 2.141, -0.127> <3.567, 2.138, -0.117> <3.551, 2.119, -0.109> <3.547, 2.114, -0.117> 
		<3.588, 2.126, -0.126> <3.585, 2.123, -0.116> <3.564, 2.109, -0.109> <3.560, 2.104, -0.117> 
		<3.605, 2.094, -0.126> <3.601, 2.094, -0.116> <3.578, 2.083, -0.108> <3.572, 2.083, -0.117> 
		<3.607, 2.070, -0.126> <3.604, 2.070, -0.116> <3.579, 2.067, -0.108> <3.573, 2.067, -0.117> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.547, 2.114, -0.117> <3.539, 2.104, -0.136> <3.542, 2.107, -0.169> <3.540, 2.104, -0.192> 
		<3.560, 2.104, -0.117> <3.552, 2.094, -0.136> <3.553, 2.099, -0.169> <3.551, 2.096, -0.192> 
		<3.572, 2.083, -0.117> <3.559, 2.081, -0.135> <3.564, 2.079, -0.169> <3.560, 2.078, -0.191> 
		<3.573, 2.067, -0.117> <3.560, 2.065, -0.135> <3.565, 2.065, -0.169> <3.562, 2.065, -0.191> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.497, 2.120, -0.195> <3.496, 2.129, -0.194> <3.494, 2.146, -0.197> <3.493, 2.151, -0.189> 
		<3.511, 2.122, -0.195> <3.510, 2.131, -0.193> <3.515, 2.148, -0.197> <3.515, 2.153, -0.189> 
		<3.531, 2.116, -0.195> <3.537, 2.123, -0.193> <3.542, 2.140, -0.197> <3.545, 2.144, -0.189> 
		<3.542, 2.107, -0.195> <3.548, 2.114, -0.193> <3.558, 2.127, -0.197> <3.561, 2.131, -0.189> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.493, 2.151, -0.189> <3.492, 2.161, -0.173> <3.491, 2.169, -0.146> <3.492, 2.164, -0.128> 
		<3.515, 2.153, -0.189> <3.513, 2.163, -0.173> <3.515, 2.172, -0.146> <3.516, 2.166, -0.127> 
		<3.545, 2.144, -0.189> <3.551, 2.152, -0.173> <3.554, 2.160, -0.145> <3.550, 2.156, -0.127> 
		<3.561, 2.131, -0.189> <3.568, 2.139, -0.173> <3.572, 2.145, -0.145> <3.569, 2.141, -0.127> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.492, 2.164, -0.128> <3.492, 2.161, -0.117> <3.494, 2.136, -0.109> <3.495, 2.130, -0.118> 
		<3.516, 2.166, -0.127> <3.516, 2.163, -0.117> <3.511, 2.138, -0.109> <3.511, 2.132, -0.118> 
		<3.550, 2.156, -0.127> <3.548, 2.154, -0.117> <3.538, 2.130, -0.109> <3.535, 2.125, -0.118> 
		<3.569, 2.141, -0.127> <3.567, 2.138, -0.117> <3.551, 2.119, -0.109> <3.547, 2.114, -0.117> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.495, 2.130, -0.118> <3.497, 2.117, -0.136> <3.496, 2.121, -0.170> <3.497, 2.117, -0.192> 
		<3.511, 2.132, -0.118> <3.513, 2.118, -0.136> <3.510, 2.122, -0.170> <3.510, 2.118, -0.192> 
		<3.535, 2.125, -0.118> <3.526, 2.114, -0.136> <3.532, 2.116, -0.170> <3.530, 2.113, -0.192> 
		<3.547, 2.114, -0.117> <3.539, 2.104, -0.136> <3.542, 2.107, -0.169> <3.540, 2.104, -0.192> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.455, 2.098, -0.195> <3.448, 2.103, -0.194> <3.435, 2.114, -0.198> <3.431, 2.117, -0.190> 
		<3.464, 2.109, -0.195> <3.457, 2.114, -0.194> <3.448, 2.130, -0.198> <3.444, 2.134, -0.190> 
		<3.482, 2.119, -0.195> <3.481, 2.128, -0.194> <3.473, 2.144, -0.197> <3.472, 2.149, -0.190> 
		<3.497, 2.120, -0.195> <3.496, 2.129, -0.194> <3.494, 2.146, -0.197> <3.493, 2.151, -0.189> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.431, 2.117, -0.190> <3.423, 2.124, -0.174> <3.417, 2.129, -0.146> <3.421, 2.125, -0.128> 
		<3.444, 2.134, -0.190> <3.436, 2.140, -0.174> <3.432, 2.147, -0.146> <3.436, 2.144, -0.128> 
		<3.472, 2.149, -0.190> <3.471, 2.159, -0.174> <3.467, 2.167, -0.146> <3.467, 2.161, -0.128> 
		<3.493, 2.151, -0.189> <3.492, 2.161, -0.173> <3.491, 2.169, -0.146> <3.492, 2.164, -0.128> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.421, 2.125, -0.128> <3.423, 2.123, -0.118> <3.442, 2.108, -0.110> <3.447, 2.104, -0.118> 
		<3.436, 2.144, -0.128> <3.438, 2.142, -0.118> <3.453, 2.121, -0.110> <3.457, 2.117, -0.118> 
		<3.467, 2.161, -0.128> <3.468, 2.158, -0.118> <3.478, 2.134, -0.110> <3.479, 2.128, -0.118> 
		<3.492, 2.164, -0.128> <3.492, 2.161, -0.117> <3.494, 2.136, -0.109> <3.495, 2.130, -0.118> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.447, 2.104, -0.118> <3.457, 2.096, -0.136> <3.454, 2.098, -0.170> <3.457, 2.096, -0.192> 
		<3.457, 2.117, -0.118> <3.468, 2.108, -0.136> <3.463, 2.109, -0.170> <3.466, 2.106, -0.192> 
		<3.479, 2.128, -0.118> <3.480, 2.115, -0.136> <3.483, 2.120, -0.170> <3.483, 2.116, -0.192> 
		<3.495, 2.130, -0.118> <3.497, 2.117, -0.136> <3.496, 2.121, -0.170> <3.497, 2.117, -0.192> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.441, 2.052, -0.195> <3.432, 2.051, -0.193> <3.416, 2.049, -0.197> <3.411, 2.049, -0.189> 
		<3.440, 2.066, -0.195> <3.431, 2.065, -0.194> <3.414, 2.071, -0.197> <3.408, 2.070, -0.189> 
		<3.446, 2.086, -0.195> <3.439, 2.092, -0.194> <3.421, 2.097, -0.198> <3.417, 2.100, -0.190> 
		<3.455, 2.098, -0.195> <3.448, 2.103, -0.194> <3.435, 2.114, -0.198> <3.431, 2.117, -0.190> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.411, 2.049, -0.189> <3.400, 2.048, -0.173> <3.392, 2.047, -0.146> <3.398, 2.048, -0.127> 
		<3.408, 2.070, -0.189> <3.398, 2.069, -0.174> <3.390, 2.071, -0.146> <3.395, 2.072, -0.128> 
		<3.417, 2.100, -0.190> <3.409, 2.107, -0.174> <3.401, 2.110, -0.146> <3.406, 2.107, -0.128> 
		<3.431, 2.117, -0.190> <3.423, 2.124, -0.174> <3.417, 2.129, -0.146> <3.421, 2.125, -0.128> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.398, 2.048, -0.127> <3.401, 2.048, -0.117> <3.425, 2.051, -0.109> <3.432, 2.052, -0.118> 
		<3.395, 2.072, -0.128> <3.398, 2.073, -0.118> <3.424, 2.067, -0.110> <3.430, 2.068, -0.118> 
		<3.406, 2.107, -0.128> <3.408, 2.105, -0.118> <3.432, 2.095, -0.110> <3.437, 2.091, -0.118> 
		<3.421, 2.125, -0.128> <3.423, 2.123, -0.118> <3.442, 2.108, -0.110> <3.447, 2.104, -0.118> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.432, 2.052, -0.118> <3.445, 2.053, -0.136> <3.441, 2.052, -0.170> <3.445, 2.052, -0.192> 
		<3.430, 2.068, -0.118> <3.443, 2.069, -0.136> <3.439, 2.066, -0.170> <3.443, 2.066, -0.192> 
		<3.437, 2.091, -0.118> <3.447, 2.083, -0.136> <3.446, 2.088, -0.170> <3.449, 2.085, -0.192> 
		<3.447, 2.104, -0.118> <3.457, 2.096, -0.136> <3.454, 2.098, -0.170> <3.457, 2.096, -0.192> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.464, 2.010, -0.195> <3.458, 2.003, -0.193> <3.448, 1.990, -0.197> <3.445, 1.986, -0.189> 
		<3.453, 2.019, -0.195> <3.447, 2.012, -0.193> <3.431, 2.004, -0.197> <3.428, 2.000, -0.189> 
		<3.443, 2.038, -0.195> <3.434, 2.037, -0.193> <3.418, 2.028, -0.197> <3.413, 2.028, -0.189> 
		<3.441, 2.052, -0.195> <3.432, 2.051, -0.193> <3.416, 2.049, -0.197> <3.411, 2.049, -0.189> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.445, 1.986, -0.189> <3.438, 1.979, -0.173> <3.433, 1.973, -0.145> <3.436, 1.977, -0.127> 
		<3.428, 2.000, -0.189> <3.421, 1.992, -0.173> <3.414, 1.988, -0.145> <3.417, 1.992, -0.127> 
		<3.413, 2.028, -0.189> <3.403, 2.027, -0.173> <3.395, 2.023, -0.145> <3.400, 2.024, -0.127> 
		<3.411, 2.049, -0.189> <3.400, 2.048, -0.173> <3.392, 2.047, -0.146> <3.398, 2.048, -0.127> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.436, 1.977, -0.127> <3.438, 1.980, -0.117> <3.454, 1.999, -0.109> <3.458, 2.004, -0.117> 
		<3.417, 1.992, -0.127> <3.419, 1.995, -0.117> <3.441, 2.009, -0.109> <3.445, 2.014, -0.118> 
		<3.400, 2.024, -0.127> <3.403, 2.024, -0.117> <3.427, 2.035, -0.109> <3.433, 2.035, -0.118> 
		<3.398, 2.048, -0.127> <3.401, 2.048, -0.117> <3.425, 2.051, -0.109> <3.432, 2.052, -0.118> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.458, 2.004, -0.117> <3.466, 2.014, -0.136> <3.463, 2.010, -0.169> <3.466, 2.013, -0.192> 
		<3.445, 2.014, -0.118> <3.453, 2.024, -0.136> <3.453, 2.019, -0.170> <3.456, 2.021, -0.192> 
		<3.433, 2.035, -0.118> <3.447, 2.037, -0.136> <3.442, 2.039, -0.170> <3.446, 2.039, -0.192> 
		<3.432, 2.052, -0.118> <3.445, 2.053, -0.136> <3.441, 2.052, -0.170> <3.445, 2.052, -0.192> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.298, 2.146, 0.037> <5.295, 2.145, 0.055> <5.299, 2.148, 0.087> <5.286, 2.141, 0.096> 
		<5.304, 2.122, 0.037> <5.300, 2.120, 0.055> <5.308, 2.111, 0.087> <5.294, 2.104, 0.097> 
		<5.312, 2.089, 0.021> <5.311, 2.076, 0.034> <5.318, 2.067, 0.066> <5.307, 2.055, 0.073> 
		<5.317, 2.073, 0.003> <5.316, 2.060, 0.015> <5.325, 2.043, 0.039> <5.314, 2.030, 0.045> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.286, 2.141, 0.096> <5.261, 2.129, 0.114> <5.216, 2.106, 0.126> <5.189, 2.092, 0.114> 
		<5.294, 2.104, 0.097> <5.269, 2.092, 0.114> <5.225, 2.065, 0.127> <5.198, 2.050, 0.114> 
		<5.307, 2.055, 0.073> <5.285, 2.031, 0.084> <5.244, 2.002, 0.097> <5.213, 1.994, 0.087> 
		<5.314, 2.030, 0.045> <5.292, 2.007, 0.057> <5.252, 1.975, 0.066> <5.221, 1.966, 0.056> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.189, 2.092, 0.114> <5.172, 2.083, 0.106> <5.163, 2.078, 0.059> <5.178, 2.085, 0.047> 
		<5.198, 2.050, 0.114> <5.181, 2.042, 0.107> <5.169, 2.050, 0.059> <5.184, 2.057, 0.047> 
		<5.213, 1.994, 0.087> <5.195, 1.989, 0.081> <5.183, 2.006, 0.036> <5.194, 2.019, 0.029> 
		<5.221, 1.966, 0.056> <5.204, 1.962, 0.050> <5.188, 1.987, 0.015> <5.200, 2.000, 0.008> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.178, 2.085, 0.047> <5.207, 2.099, 0.024> <5.259, 2.126, 0.036> <5.294, 2.144, 0.031> 
		<5.184, 2.057, 0.047> <5.213, 2.071, 0.025> <5.264, 2.103, 0.036> <5.299, 2.121, 0.031> 
		<5.194, 2.019, 0.029> <5.218, 2.047, 0.014> <5.274, 2.067, 0.019> <5.307, 2.089, 0.016> 
		<5.200, 2.000, 0.008> <5.224, 2.029, -0.008> <5.278, 2.052, 0.001> <5.312, 2.074, -0.002> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.283, 2.221, 0.001> <5.277, 2.230, 0.014> <5.278, 2.253, 0.036> <5.263, 2.253, 0.042> 
		<5.286, 2.204, 0.020> <5.280, 2.214, 0.032> <5.282, 2.228, 0.064> <5.267, 2.228, 0.071> 
		<5.293, 2.171, 0.037> <5.289, 2.169, 0.055> <5.291, 2.185, 0.086> <5.277, 2.178, 0.096> 
		<5.298, 2.146, 0.037> <5.295, 2.145, 0.055> <5.299, 2.148, 0.087> <5.286, 2.141, 0.096> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.263, 2.253, 0.042> <5.234, 2.252, 0.055> <5.187, 2.238, 0.061> <5.163, 2.219, 0.053> 
		<5.267, 2.228, 0.071> <5.238, 2.227, 0.083> <5.192, 2.210, 0.093> <5.168, 2.190, 0.085> 
		<5.277, 2.178, 0.096> <5.252, 2.165, 0.113> <5.206, 2.148, 0.126> <5.179, 2.134, 0.113> 
		<5.286, 2.141, 0.096> <5.261, 2.129, 0.114> <5.216, 2.106, 0.126> <5.189, 2.092, 0.114> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.163, 2.219, 0.053> <5.148, 2.206, 0.047> <5.142, 2.171, 0.014> <5.160, 2.171, 0.006> 
		<5.168, 2.190, 0.085> <5.152, 2.178, 0.079> <5.145, 2.152, 0.036> <5.164, 2.152, 0.027> 
		<5.179, 2.134, 0.113> <5.162, 2.125, 0.106> <5.156, 2.106, 0.059> <5.171, 2.113, 0.047> 
		<5.189, 2.092, 0.114> <5.172, 2.083, 0.106> <5.163, 2.078, 0.059> <5.178, 2.085, 0.047> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.160, 2.171, 0.006> <5.195, 2.170, -0.011> <5.244, 2.202, -0.001> <5.280, 2.215, -0.003> 
		<5.164, 2.152, 0.027> <5.198, 2.151, 0.011> <5.246, 2.186, 0.017> <5.282, 2.199, 0.015> 
		<5.171, 2.113, 0.047> <5.200, 2.128, 0.024> <5.254, 2.150, 0.035> <5.289, 2.167, 0.030> 
		<5.178, 2.085, 0.047> <5.207, 2.099, 0.024> <5.259, 2.126, 0.036> <5.294, 2.144, 0.031> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.281, 2.252, -0.084> <5.274, 2.267, -0.084> <5.275, 2.297, -0.084> <5.259, 2.300, -0.085> 
		<5.279, 2.252, -0.057> <5.273, 2.266, -0.057> <5.272, 2.297, -0.043> <5.257, 2.300, -0.044> 
		<5.280, 2.239, -0.019> <5.274, 2.248, -0.007> <5.274, 2.280, 0.005> <5.258, 2.279, 0.012> 
		<5.283, 2.221, 0.001> <5.277, 2.230, 0.014> <5.278, 2.253, 0.036> <5.263, 2.253, 0.042> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.259, 2.300, -0.085> <5.228, 2.305, -0.087> <5.182, 2.293, -0.090> <5.159, 2.272, -0.092> 
		<5.257, 2.300, -0.044> <5.226, 2.305, -0.046> <5.179, 2.293, -0.044> <5.156, 2.272, -0.046> 
		<5.258, 2.279, 0.012> <5.229, 2.279, 0.024> <5.182, 2.268, 0.027> <5.158, 2.249, 0.018> 
		<5.263, 2.253, 0.042> <5.234, 2.252, 0.055> <5.187, 2.238, 0.061> <5.163, 2.219, 0.053> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.159, 2.272, -0.092> <5.144, 2.259, -0.093> <5.139, 2.211, -0.093> <5.158, 2.207, -0.092> 
		<5.156, 2.272, -0.046> <5.142, 2.258, -0.047> <5.137, 2.211, -0.062> <5.156, 2.207, -0.061> 
		<5.158, 2.249, 0.018> <5.143, 2.237, 0.013> <5.139, 2.192, -0.009> <5.157, 2.191, -0.018> 
		<5.163, 2.219, 0.053> <5.148, 2.206, 0.047> <5.142, 2.171, 0.014> <5.160, 2.171, 0.006> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.158, 2.207, -0.092> <5.194, 2.199, -0.090> <5.241, 2.233, -0.087> <5.277, 2.245, -0.084> 
		<5.156, 2.207, -0.061> <5.193, 2.198, -0.058> <5.240, 2.233, -0.061> <5.276, 2.244, -0.058> 
		<5.157, 2.191, -0.018> <5.191, 2.190, -0.034> <5.241, 2.219, -0.020> <5.277, 2.232, -0.023> 
		<5.160, 2.171, 0.006> <5.195, 2.170, -0.011> <5.244, 2.202, -0.001> <5.280, 2.215, -0.003> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.292, 2.222, -0.168> <5.288, 2.232, -0.181> <5.291, 2.255, -0.203> <5.277, 2.255, -0.212> 
		<5.287, 2.240, -0.148> <5.282, 2.250, -0.161> <5.283, 2.281, -0.173> <5.269, 2.281, -0.182> 
		<5.282, 2.253, -0.111> <5.276, 2.267, -0.111> <5.277, 2.298, -0.125> <5.261, 2.300, -0.126> 
		<5.281, 2.252, -0.084> <5.274, 2.267, -0.084> <5.275, 2.297, -0.084> <5.259, 2.300, -0.085> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.277, 2.255, -0.212> <5.249, 2.255, -0.228> <5.203, 2.240, -0.240> <5.178, 2.221, -0.235> 
		<5.269, 2.281, -0.182> <5.241, 2.281, -0.198> <5.194, 2.270, -0.206> <5.170, 2.251, -0.201> 
		<5.261, 2.300, -0.126> <5.230, 2.305, -0.128> <5.184, 2.294, -0.136> <5.161, 2.272, -0.138> 
		<5.259, 2.300, -0.085> <5.228, 2.305, -0.087> <5.182, 2.293, -0.090> <5.159, 2.272, -0.092> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.178, 2.221, -0.235> <5.163, 2.209, -0.232> <5.154, 2.173, -0.200> <5.171, 2.173, -0.189> 
		<5.170, 2.251, -0.201> <5.154, 2.239, -0.198> <5.148, 2.193, -0.177> <5.165, 2.193, -0.166> 
		<5.161, 2.272, -0.138> <5.147, 2.259, -0.139> <5.140, 2.212, -0.124> <5.159, 2.207, -0.123> 
		<5.159, 2.272, -0.092> <5.144, 2.259, -0.093> <5.139, 2.211, -0.093> <5.158, 2.207, -0.092> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.171, 2.173, -0.189> <5.203, 2.171, -0.168> <5.253, 2.203, -0.172> <5.288, 2.216, -0.164> 
		<5.165, 2.193, -0.166> <5.197, 2.191, -0.145> <5.248, 2.220, -0.153> <5.283, 2.233, -0.145> 
		<5.159, 2.207, -0.123> <5.196, 2.199, -0.121> <5.243, 2.234, -0.112> <5.279, 2.245, -0.110> 
		<5.158, 2.207, -0.092> <5.194, 2.199, -0.090> <5.241, 2.233, -0.087> <5.277, 2.245, -0.084> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.311, 2.149, -0.203> <5.309, 2.147, -0.221> <5.318, 2.151, -0.252> <5.305, 2.144, -0.263> 
		<5.306, 2.173, -0.203> <5.304, 2.172, -0.221> <5.309, 2.188, -0.252> <5.296, 2.181, -0.263> 
		<5.297, 2.206, -0.187> <5.292, 2.216, -0.200> <5.298, 2.231, -0.231> <5.284, 2.231, -0.239> 
		<5.292, 2.222, -0.168> <5.288, 2.232, -0.181> <5.291, 2.255, -0.203> <5.277, 2.255, -0.212> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.305, 2.144, -0.263> <5.282, 2.132, -0.284> <5.239, 2.110, -0.302> <5.211, 2.096, -0.293> 
		<5.296, 2.181, -0.263> <5.274, 2.169, -0.284> <5.230, 2.152, -0.303> <5.201, 2.137, -0.294> 
		<5.284, 2.231, -0.239> <5.256, 2.230, -0.256> <5.211, 2.213, -0.272> <5.186, 2.194, -0.267> 
		<5.277, 2.255, -0.212> <5.249, 2.255, -0.228> <5.203, 2.240, -0.240> <5.178, 2.221, -0.235> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.211, 2.096, -0.293> <5.193, 2.087, -0.288> <5.179, 2.081, -0.242> <5.193, 2.088, -0.228> 
		<5.201, 2.137, -0.294> <5.183, 2.128, -0.288> <5.173, 2.109, -0.242> <5.186, 2.116, -0.229> 
		<5.186, 2.194, -0.267> <5.171, 2.181, -0.263> <5.159, 2.155, -0.221> <5.176, 2.154, -0.210> 
		<5.178, 2.221, -0.235> <5.163, 2.209, -0.232> <5.154, 2.173, -0.200> <5.171, 2.173, -0.189> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.193, 2.088, -0.228> <5.219, 2.101, -0.202> <5.272, 2.129, -0.206> <5.306, 2.146, -0.197> 
		<5.186, 2.116, -0.229> <5.212, 2.130, -0.202> <5.267, 2.152, -0.207> <5.301, 2.169, -0.197> 
		<5.176, 2.154, -0.210> <5.209, 2.153, -0.190> <5.258, 2.188, -0.189> <5.293, 2.201, -0.182> 
		<5.171, 2.173, -0.189> <5.203, 2.171, -0.168> <5.253, 2.203, -0.172> <5.288, 2.216, -0.164> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.326, 2.074, -0.167> <5.327, 2.062, -0.179> <5.338, 2.045, -0.202> <5.328, 2.033, -0.209> 
		<5.324, 2.091, -0.185> <5.324, 2.078, -0.198> <5.334, 2.070, -0.230> <5.323, 2.057, -0.237> 
		<5.317, 2.124, -0.202> <5.315, 2.123, -0.220> <5.326, 2.114, -0.251> <5.313, 2.107, -0.263> 
		<5.311, 2.149, -0.203> <5.309, 2.147, -0.221> <5.318, 2.151, -0.252> <5.305, 2.144, -0.263> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.328, 2.033, -0.209> <5.308, 2.009, -0.224> <5.269, 1.977, -0.238> <5.236, 1.969, -0.232> 
		<5.323, 2.057, -0.237> <5.303, 2.034, -0.252> <5.264, 2.006, -0.270> <5.232, 1.997, -0.264> 
		<5.313, 2.107, -0.263> <5.290, 2.095, -0.283> <5.249, 2.068, -0.302> <5.220, 2.054, -0.293> 
		<5.305, 2.144, -0.263> <5.282, 2.132, -0.284> <5.239, 2.110, -0.302> <5.211, 2.096, -0.293> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.236, 1.969, -0.232> <5.219, 1.964, -0.229> <5.200, 1.989, -0.196> <5.210, 2.002, -0.187> 
		<5.232, 1.997, -0.264> <5.214, 1.993, -0.261> <5.197, 2.008, -0.217> <5.207, 2.021, -0.209> 
		<5.220, 2.054, -0.293> <5.203, 2.045, -0.288> <5.186, 2.052, -0.242> <5.199, 2.059, -0.228> 
		<5.211, 2.096, -0.293> <5.193, 2.087, -0.288> <5.179, 2.081, -0.242> <5.193, 2.088, -0.228> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.210, 2.002, -0.187> <5.232, 2.030, -0.169> <5.287, 2.053, -0.170> <5.320, 2.075, -0.163> 
		<5.207, 2.021, -0.209> <5.229, 2.049, -0.190> <5.285, 2.069, -0.188> <5.318, 2.091, -0.181> 
		<5.199, 2.059, -0.228> <5.225, 2.073, -0.202> <5.277, 2.105, -0.206> <5.311, 2.123, -0.197> 
		<5.193, 2.088, -0.228> <5.219, 2.101, -0.202> <5.272, 2.129, -0.206> <5.306, 2.146, -0.197> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.329, 2.043, -0.082> <5.330, 2.026, -0.082> <5.341, 2.000, -0.081> <5.331, 1.985, -0.082> 
		<5.330, 2.043, -0.109> <5.331, 2.026, -0.109> <5.343, 2.000, -0.122> <5.334, 1.986, -0.122> 
		<5.329, 2.056, -0.146> <5.330, 2.044, -0.159> <5.343, 2.018, -0.171> <5.332, 2.006, -0.179> 
		<5.326, 2.074, -0.167> <5.327, 2.062, -0.179> <5.338, 2.045, -0.202> <5.328, 2.033, -0.209> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.331, 1.985, -0.082> <5.312, 1.957, -0.083> <5.274, 1.921, -0.086> <5.241, 1.916, -0.088> 
		<5.334, 1.986, -0.122> <5.314, 1.958, -0.124> <5.277, 1.922, -0.132> <5.243, 1.916, -0.134> 
		<5.332, 2.006, -0.179> <5.312, 1.982, -0.193> <5.274, 1.947, -0.204> <5.241, 1.939, -0.198> 
		<5.328, 2.033, -0.209> <5.308, 2.009, -0.224> <5.269, 1.977, -0.238> <5.236, 1.969, -0.232> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.241, 1.916, -0.088> <5.224, 1.913, -0.089> <5.204, 1.951, -0.090> <5.213, 1.966, -0.089> 
		<5.243, 1.916, -0.134> <5.226, 1.913, -0.135> <5.205, 1.952, -0.121> <5.215, 1.966, -0.121> 
		<5.241, 1.939, -0.198> <5.224, 1.934, -0.194> <5.203, 1.969, -0.172> <5.213, 1.982, -0.164> 
		<5.236, 1.969, -0.232> <5.219, 1.964, -0.229> <5.200, 1.989, -0.196> <5.210, 2.002, -0.187> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.213, 1.966, -0.089> <5.235, 2.000, -0.088> <5.290, 2.022, -0.084> <5.323, 2.046, -0.082> 
		<5.215, 1.966, -0.121> <5.236, 2.001, -0.119> <5.291, 2.022, -0.110> <5.324, 2.046, -0.108> 
		<5.213, 1.982, -0.164> <5.236, 2.010, -0.145> <5.290, 2.036, -0.151> <5.323, 2.058, -0.143> 
		<5.210, 2.002, -0.187> <5.232, 2.030, -0.169> <5.287, 2.053, -0.170> <5.320, 2.075, -0.163> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.317, 2.073, 0.003> <5.316, 2.060, 0.015> <5.325, 2.043, 0.039> <5.314, 2.030, 0.045> 
		<5.322, 2.055, -0.017> <5.321, 2.042, -0.005> <5.333, 2.017, 0.009> <5.322, 2.004, 0.015> 
		<5.327, 2.042, -0.055> <5.328, 2.025, -0.055> <5.339, 1.999, -0.040> <5.329, 1.985, -0.041> 
		<5.329, 2.043, -0.082> <5.330, 2.026, -0.082> <5.341, 2.000, -0.081> <5.331, 1.985, -0.082> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.314, 2.030, 0.045> <5.292, 2.007, 0.057> <5.252, 1.975, 0.066> <5.221, 1.966, 0.056> 
		<5.322, 2.004, 0.015> <5.300, 1.980, 0.027> <5.261, 1.945, 0.032> <5.230, 1.937, 0.022> 
		<5.329, 1.985, -0.041> <5.310, 1.957, -0.042> <5.272, 1.921, -0.040> <5.238, 1.915, -0.042> 
		<5.331, 1.985, -0.082> <5.312, 1.957, -0.083> <5.274, 1.921, -0.086> <5.241, 1.916, -0.088> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.221, 1.966, 0.056> <5.204, 1.962, 0.050> <5.188, 1.987, 0.015> <5.200, 2.000, 0.008> 
		<5.230, 1.937, 0.022> <5.212, 1.932, 0.016> <5.194, 1.967, -0.008> <5.206, 1.980, -0.015> 
		<5.238, 1.915, -0.042> <5.221, 1.912, -0.043> <5.202, 1.951, -0.059> <5.211, 1.966, -0.058> 
		<5.241, 1.916, -0.088> <5.224, 1.913, -0.089> <5.204, 1.951, -0.090> <5.213, 1.966, -0.089> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.200, 2.000, 0.008> <5.224, 2.029, -0.008> <5.278, 2.052, 0.001> <5.312, 2.074, -0.002> 
		<5.206, 1.980, -0.015> <5.230, 2.009, -0.031> <5.283, 2.035, -0.018> <5.317, 2.057, -0.021> 
		<5.211, 1.966, -0.058> <5.233, 2.000, -0.057> <5.289, 2.021, -0.058> <5.321, 2.045, -0.056> 
		<5.213, 1.966, -0.089> <5.235, 2.000, -0.088> <5.290, 2.022, -0.084> <5.323, 2.046, -0.082> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.503, 1.931, -0.010> <3.500, 1.933, 0.008> <3.506, 1.932, 0.039> <3.491, 1.935, 0.049> 
		<3.493, 1.909, -0.010> <3.489, 1.910, 0.008> <3.490, 1.898, 0.040> <3.475, 1.901, 0.050> 
		<3.479, 1.877, -0.025> <3.470, 1.868, -0.013> <3.471, 1.857, 0.020> <3.454, 1.854, 0.027> 
		<3.472, 1.862, -0.044> <3.464, 1.852, -0.031> <3.461, 1.833, -0.008> <3.444, 1.830, -0.001> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.491, 1.935, 0.049> <3.464, 1.941, 0.067> <3.416, 1.950, 0.081> <3.385, 1.956, 0.069> 
		<3.475, 1.901, 0.050> <3.448, 1.907, 0.068> <3.397, 1.912, 0.082> <3.367, 1.918, 0.070> 
		<3.454, 1.854, 0.027> <3.423, 1.849, 0.039> <3.373, 1.851, 0.053> <3.343, 1.864, 0.043> 
		<3.444, 1.830, -0.001> <3.413, 1.825, 0.011> <3.362, 1.825, 0.022> <3.332, 1.837, 0.012> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.385, 1.956, 0.069> <3.366, 1.960, 0.062> <3.355, 1.961, 0.015> <3.371, 1.957, 0.003> 
		<3.367, 1.918, 0.070> <3.348, 1.921, 0.063> <3.343, 1.935, 0.015> <3.359, 1.931, 0.003> 
		<3.343, 1.864, 0.043> <3.327, 1.871, 0.038> <3.326, 1.892, -0.007> <3.343, 1.895, -0.015> 
		<3.332, 1.837, 0.012> <3.315, 1.844, 0.007> <3.318, 1.874, -0.028> <3.335, 1.877, -0.036> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.371, 1.957, 0.003> <3.402, 1.951, -0.021> <3.460, 1.940, -0.011> <3.498, 1.932, -0.016> 
		<3.359, 1.931, 0.003> <3.390, 1.925, -0.020> <3.450, 1.918, -0.010> <3.488, 1.911, -0.016> 
		<3.343, 1.895, -0.015> <3.379, 1.903, -0.031> <3.435, 1.884, -0.027> <3.475, 1.881, -0.031> 
		<3.335, 1.877, -0.036> <3.371, 1.885, -0.052> <3.429, 1.869, -0.045> <3.469, 1.866, -0.048> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.537, 1.999, -0.047> <3.538, 2.011, -0.035> <3.553, 2.028, -0.013> <3.541, 2.037, -0.006> 
		<3.529, 1.985, -0.028> <3.530, 1.996, -0.016> <3.542, 2.006, 0.016> <3.530, 2.015, 0.023> 
		<3.514, 1.954, -0.011> <3.511, 1.955, 0.007> <3.522, 1.966, 0.038> <3.507, 1.969, 0.048> 
		<3.503, 1.931, -0.010> <3.500, 1.933, 0.008> <3.506, 1.932, 0.039> <3.491, 1.935, 0.049> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.541, 2.037, -0.006> <3.518, 2.055, 0.007> <3.472, 2.072, 0.015> <3.442, 2.072, 0.007> 
		<3.530, 2.015, 0.023> <3.507, 2.033, 0.036> <3.459, 2.047, 0.047> <3.429, 2.047, 0.039> 
		<3.507, 1.969, 0.048> <3.480, 1.975, 0.067> <3.434, 1.989, 0.080> <3.403, 1.995, 0.068> 
		<3.491, 1.935, 0.049> <3.464, 1.941, 0.067> <3.416, 1.950, 0.081> <3.385, 1.956, 0.069> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.442, 2.072, 0.007> <3.422, 2.071, 0.002> <3.395, 2.047, -0.031> <3.409, 2.036, -0.040> 
		<3.429, 2.047, 0.039> <3.409, 2.046, 0.034> <3.387, 2.030, -0.009> <3.400, 2.019, -0.018> 
		<3.403, 1.995, 0.068> <3.385, 1.998, 0.061> <3.367, 1.987, 0.014> <3.383, 1.984, 0.002> 
		<3.385, 1.956, 0.069> <3.366, 1.960, 0.062> <3.355, 1.961, 0.015> <3.371, 1.957, 0.003> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.409, 2.036, -0.040> <3.435, 2.013, -0.057> <3.494, 2.008, -0.048> <3.530, 1.997, -0.051> 
		<3.400, 2.019, -0.018> <3.426, 1.997, -0.035> <3.486, 1.994, -0.030> <3.523, 1.983, -0.033> 
		<3.383, 1.984, 0.002> <3.414, 1.977, -0.021> <3.470, 1.961, -0.011> <3.508, 1.954, -0.017> 
		<3.371, 1.957, 0.003> <3.402, 1.951, -0.021> <3.460, 1.940, -0.011> <3.498, 1.932, -0.016> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.552, 2.026, -0.132> <3.556, 2.041, -0.133> <3.575, 2.065, -0.133> <3.564, 2.076, -0.134> 
		<3.551, 2.026, -0.105> <3.555, 2.042, -0.106> <3.574, 2.066, -0.092> <3.563, 2.077, -0.093> 
		<3.545, 2.015, -0.068> <3.546, 2.026, -0.055> <3.566, 2.051, -0.044> <3.553, 2.061, -0.037> 
		<3.537, 1.999, -0.047> <3.538, 2.011, -0.035> <3.553, 2.028, -0.013> <3.541, 2.037, -0.006> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.564, 2.076, -0.134> <3.543, 2.099, -0.135> <3.499, 2.119, -0.138> <3.468, 2.116, -0.138> 
		<3.563, 2.077, -0.093> <3.542, 2.100, -0.095> <3.498, 2.120, -0.091> <3.467, 2.117, -0.092> 
		<3.553, 2.061, -0.037> <3.530, 2.078, -0.024> <3.486, 2.099, -0.020> <3.455, 2.099, -0.028> 
		<3.541, 2.037, -0.006> <3.518, 2.055, 0.007> <3.472, 2.072, 0.015> <3.442, 2.072, 0.007> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.468, 2.116, -0.138> <3.448, 2.115, -0.139> <3.415, 2.081, -0.139> <3.427, 2.066, -0.138> 
		<3.467, 2.117, -0.092> <3.447, 2.116, -0.093> <3.414, 2.082, -0.108> <3.426, 2.067, -0.107> 
		<3.455, 2.099, -0.028> <3.436, 2.098, -0.033> <3.405, 2.065, -0.054> <3.419, 2.054, -0.063> 
		<3.442, 2.072, 0.007> <3.422, 2.071, 0.002> <3.395, 2.047, -0.031> <3.409, 2.036, -0.040> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.427, 2.066, -0.138> <3.451, 2.036, -0.136> <3.509, 2.035, -0.134> <3.545, 2.022, -0.132> 
		<3.426, 2.067, -0.107> <3.450, 2.037, -0.105> <3.509, 2.036, -0.108> <3.544, 2.022, -0.107> 
		<3.419, 2.054, -0.063> <3.445, 2.032, -0.080> <3.501, 2.023, -0.067> <3.538, 2.012, -0.071> 
		<3.409, 2.036, -0.040> <3.435, 2.013, -0.057> <3.494, 2.008, -0.048> <3.530, 1.997, -0.051> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.541, 1.995, -0.216> <3.543, 2.005, -0.230> <3.559, 2.021, -0.252> <3.548, 2.030, -0.260> 
		<3.548, 2.012, -0.197> <3.550, 2.022, -0.210> <3.570, 2.047, -0.222> <3.558, 2.056, -0.230> 
		<3.553, 2.025, -0.159> <3.557, 2.040, -0.160> <3.576, 2.064, -0.174> <3.565, 2.075, -0.175> 
		<3.552, 2.026, -0.132> <3.556, 2.041, -0.133> <3.575, 2.065, -0.133> <3.564, 2.076, -0.134> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.548, 2.030, -0.260> <3.525, 2.047, -0.276> <3.480, 2.064, -0.287> <3.449, 2.064, -0.281> 
		<3.558, 2.056, -0.230> <3.536, 2.072, -0.246> <3.493, 2.093, -0.254> <3.461, 2.093, -0.248> 
		<3.565, 2.075, -0.175> <3.544, 2.098, -0.176> <3.500, 2.117, -0.184> <3.469, 2.115, -0.184> 
		<3.564, 2.076, -0.134> <3.543, 2.099, -0.135> <3.499, 2.119, -0.138> <3.468, 2.116, -0.138> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.449, 2.064, -0.281> <3.429, 2.064, -0.278> <3.401, 2.041, -0.245> <3.414, 2.030, -0.235> 
		<3.461, 2.093, -0.248> <3.441, 2.093, -0.244> <3.409, 2.061, -0.222> <3.422, 2.050, -0.212> 
		<3.469, 2.115, -0.184> <3.450, 2.113, -0.185> <3.416, 2.080, -0.170> <3.428, 2.065, -0.169> 
		<3.468, 2.116, -0.138> <3.448, 2.115, -0.139> <3.415, 2.081, -0.139> <3.427, 2.066, -0.138> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.414, 2.030, -0.235> <3.439, 2.009, -0.214> <3.498, 2.004, -0.219> <3.534, 1.992, -0.212> 
		<3.422, 2.050, -0.212> <3.447, 2.029, -0.192> <3.505, 2.020, -0.200> <3.541, 2.009, -0.194> 
		<3.428, 2.065, -0.169> <3.452, 2.036, -0.167> <3.510, 2.034, -0.160> <3.545, 2.021, -0.158> 
		<3.427, 2.066, -0.138> <3.451, 2.036, -0.136> <3.509, 2.035, -0.134> <3.545, 2.022, -0.132> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.510, 1.925, -0.250> <3.507, 1.925, -0.268> <3.515, 1.923, -0.299> <3.501, 1.925, -0.310> 
		<3.520, 1.948, -0.251> <3.518, 1.948, -0.269> <3.531, 1.957, -0.300> <3.517, 1.959, -0.311> 
		<3.534, 1.979, -0.235> <3.536, 1.990, -0.248> <3.549, 1.998, -0.279> <3.538, 2.007, -0.288> 
		<3.541, 1.995, -0.216> <3.543, 2.005, -0.230> <3.559, 2.021, -0.252> <3.548, 2.030, -0.260> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.501, 1.925, -0.310> <3.475, 1.930, -0.330> <3.427, 1.939, -0.348> <3.396, 1.945, -0.338> 
		<3.517, 1.959, -0.311> <3.491, 1.964, -0.331> <3.445, 1.977, -0.349> <3.414, 1.984, -0.339> 
		<3.538, 2.007, -0.288> <3.515, 2.023, -0.303> <3.469, 2.037, -0.319> <3.438, 2.037, -0.313> 
		<3.548, 2.030, -0.260> <3.525, 2.047, -0.276> <3.480, 2.064, -0.287> <3.449, 2.064, -0.281> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.396, 1.945, -0.338> <3.377, 1.949, -0.333> <3.363, 1.953, -0.286> <3.378, 1.950, -0.273> 
		<3.414, 1.984, -0.339> <3.395, 1.988, -0.333> <3.375, 1.979, -0.287> <3.390, 1.976, -0.274> 
		<3.438, 2.037, -0.313> <3.418, 2.037, -0.309> <3.393, 2.023, -0.266> <3.407, 2.012, -0.256> 
		<3.449, 2.064, -0.281> <3.429, 2.064, -0.278> <3.401, 2.041, -0.245> <3.414, 2.030, -0.235> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.378, 1.950, -0.273> <3.408, 1.945, -0.247> <3.466, 1.933, -0.253> <3.504, 1.926, -0.244> 
		<3.390, 1.976, -0.274> <3.420, 1.971, -0.248> <3.476, 1.955, -0.253> <3.514, 1.948, -0.245> 
		<3.407, 2.012, -0.256> <3.431, 1.991, -0.235> <3.492, 1.989, -0.236> <3.528, 1.978, -0.230> 
		<3.414, 2.030, -0.235> <3.439, 2.009, -0.214> <3.498, 2.004, -0.219> <3.534, 1.992, -0.212> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.476, 1.857, -0.213> <3.469, 1.847, -0.226> <3.467, 1.827, -0.248> <3.451, 1.823, -0.255> 
		<3.484, 1.872, -0.232> <3.476, 1.862, -0.245> <3.478, 1.849, -0.277> <3.462, 1.845, -0.284> 
		<3.499, 1.902, -0.249> <3.496, 1.902, -0.268> <3.499, 1.889, -0.298> <3.485, 1.891, -0.310> 
		<3.510, 1.925, -0.250> <3.507, 1.925, -0.268> <3.515, 1.923, -0.299> <3.501, 1.925, -0.310> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.451, 1.823, -0.255> <3.420, 1.817, -0.269> <3.370, 1.816, -0.283> <3.339, 1.830, -0.276> 
		<3.462, 1.845, -0.284> <3.432, 1.839, -0.298> <3.383, 1.841, -0.315> <3.352, 1.855, -0.308> 
		<3.485, 1.891, -0.310> <3.459, 1.896, -0.330> <3.409, 1.900, -0.347> <3.378, 1.906, -0.337> 
		<3.501, 1.925, -0.310> <3.475, 1.930, -0.330> <3.427, 1.939, -0.348> <3.396, 1.945, -0.338> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.339, 1.830, -0.276> <3.323, 1.837, -0.272> <3.324, 1.868, -0.239> <3.340, 1.872, -0.231> 
		<3.352, 1.855, -0.308> <3.336, 1.862, -0.305> <3.333, 1.885, -0.261> <3.349, 1.889, -0.253> 
		<3.378, 1.906, -0.337> <3.358, 1.910, -0.332> <3.351, 1.926, -0.286> <3.366, 1.924, -0.272> 
		<3.396, 1.945, -0.338> <3.377, 1.949, -0.333> <3.363, 1.953, -0.286> <3.378, 1.950, -0.273> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.340, 1.872, -0.231> <3.375, 1.880, -0.213> <3.433, 1.865, -0.216> <3.473, 1.862, -0.209> 
		<3.349, 1.889, -0.253> <3.384, 1.897, -0.235> <3.440, 1.879, -0.234> <3.480, 1.876, -0.227> 
		<3.366, 1.924, -0.272> <3.395, 1.919, -0.247> <3.456, 1.912, -0.252> <3.494, 1.904, -0.244> 
		<3.378, 1.950, -0.273> <3.408, 1.945, -0.247> <3.466, 1.933, -0.253> <3.504, 1.926, -0.244> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.461, 1.831, -0.128> <3.451, 1.817, -0.128> <3.444, 1.789, -0.127> <3.428, 1.784, -0.127> 
		<3.462, 1.830, -0.155> <3.452, 1.816, -0.155> <3.445, 1.788, -0.168> <3.429, 1.783, -0.168> 
		<3.468, 1.841, -0.193> <3.461, 1.831, -0.205> <3.455, 1.803, -0.217> <3.439, 1.800, -0.224> 
		<3.476, 1.857, -0.213> <3.469, 1.847, -0.226> <3.467, 1.827, -0.248> <3.451, 1.823, -0.255> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.428, 1.784, -0.127> <3.395, 1.774, -0.128> <3.343, 1.769, -0.129> <3.313, 1.785, -0.131> 
		<3.429, 1.783, -0.168> <3.396, 1.773, -0.169> <3.344, 1.767, -0.175> <3.314, 1.784, -0.177> 
		<3.439, 1.800, -0.224> <3.408, 1.794, -0.238> <3.356, 1.789, -0.248> <3.325, 1.803, -0.241> 
		<3.451, 1.823, -0.255> <3.420, 1.817, -0.269> <3.370, 1.816, -0.283> <3.339, 1.830, -0.276> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.313, 1.785, -0.131> <3.298, 1.793, -0.132> <3.306, 1.836, -0.133> <3.322, 1.842, -0.133> 
		<3.314, 1.784, -0.177> <3.299, 1.792, -0.178> <3.307, 1.835, -0.164> <3.323, 1.841, -0.164> 
		<3.325, 1.803, -0.241> <3.309, 1.810, -0.237> <3.314, 1.850, -0.215> <3.331, 1.854, -0.207> 
		<3.339, 1.830, -0.276> <3.323, 1.837, -0.272> <3.324, 1.868, -0.239> <3.340, 1.872, -0.231> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.322, 1.842, -0.133> <3.361, 1.855, -0.132> <3.417, 1.838, -0.129> <3.458, 1.837, -0.128> 
		<3.323, 1.841, -0.164> <3.361, 1.854, -0.163> <3.418, 1.837, -0.155> <3.459, 1.836, -0.154> 
		<3.331, 1.854, -0.207> <3.366, 1.862, -0.190> <3.425, 1.850, -0.196> <3.465, 1.847, -0.190> 
		<3.340, 1.872, -0.231> <3.375, 1.880, -0.213> <3.433, 1.865, -0.216> <3.473, 1.862, -0.209> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.472, 1.862, -0.044> <3.464, 1.852, -0.031> <3.461, 1.833, -0.008> <3.444, 1.830, -0.001> 
		<3.465, 1.845, -0.064> <3.457, 1.835, -0.051> <3.450, 1.808, -0.037> <3.434, 1.805, -0.031> 
		<3.460, 1.831, -0.101> <3.450, 1.817, -0.101> <3.443, 1.790, -0.086> <3.427, 1.785, -0.087> 
		<3.461, 1.831, -0.128> <3.451, 1.817, -0.128> <3.444, 1.789, -0.127> <3.428, 1.784, -0.127> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.444, 1.830, -0.001> <3.413, 1.825, 0.011> <3.362, 1.825, 0.022> <3.332, 1.837, 0.012> 
		<3.434, 1.805, -0.031> <3.402, 1.799, -0.018> <3.350, 1.796, -0.012> <3.320, 1.809, -0.022> 
		<3.427, 1.785, -0.087> <3.394, 1.775, -0.087> <3.342, 1.770, -0.083> <3.312, 1.786, -0.085> 
		<3.428, 1.784, -0.127> <3.395, 1.774, -0.128> <3.343, 1.769, -0.129> <3.313, 1.785, -0.131> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.332, 1.837, 0.012> <3.315, 1.844, 0.007> <3.318, 1.874, -0.028> <3.335, 1.877, -0.036> 
		<3.320, 1.809, -0.022> <3.303, 1.816, -0.027> <3.310, 1.854, -0.051> <3.327, 1.858, -0.059> 
		<3.312, 1.786, -0.085> <3.297, 1.794, -0.086> <3.305, 1.837, -0.102> <3.321, 1.842, -0.101> 
		<3.313, 1.785, -0.131> <3.298, 1.793, -0.132> <3.306, 1.836, -0.133> <3.322, 1.842, -0.133> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.335, 1.877, -0.036> <3.371, 1.885, -0.052> <3.429, 1.869, -0.045> <3.469, 1.866, -0.048> 
		<3.327, 1.858, -0.059> <3.363, 1.865, -0.075> <3.422, 1.853, -0.063> <3.462, 1.850, -0.067> 
		<3.321, 1.842, -0.101> <3.360, 1.856, -0.101> <3.417, 1.839, -0.104> <3.457, 1.837, -0.102> 
		<3.322, 1.842, -0.133> <3.361, 1.855, -0.132> <3.417, 1.838, -0.129> <3.458, 1.837, -0.128> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.593, 2.556, -0.582> <3.580, 2.628, -0.584> <3.562, 2.684, -0.647> <3.554, 2.680, -0.719> 
		<3.878, 2.606, -0.617> <3.865, 2.678, -0.619> <3.847, 2.734, -0.682> <3.839, 2.730, -0.754> 
		<4.258, 2.672, -0.664> <4.245, 2.744, -0.666> <4.227, 2.801, -0.729> <4.219, 2.797, -0.801> 
		<4.542, 2.722, -0.699> <4.530, 2.794, -0.701> <4.512, 2.851, -0.764> <4.504, 2.847, -0.837> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.554, 2.680, -0.719> <3.546, 2.676, -0.792> <3.549, 2.613, -0.850> <3.562, 2.541, -0.848> 
		<3.839, 2.730, -0.754> <3.830, 2.726, -0.827> <3.834, 2.663, -0.886> <3.847, 2.591, -0.883> 
		<4.219, 2.797, -0.801> <4.210, 2.793, -0.874> <4.214, 2.730, -0.932> <4.227, 2.658, -0.930> 
		<4.504, 2.847, -0.837> <4.495, 2.843, -0.909> <4.499, 2.780, -0.968> <4.512, 2.708, -0.965> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.562, 2.541, -0.848> <3.575, 2.469, -0.845> <3.593, 2.412, -0.783> <3.601, 2.416, -0.710> 
		<3.847, 2.591, -0.883> <3.860, 2.519, -0.881> <3.878, 2.462, -0.818> <3.886, 2.466, -0.746> 
		<4.227, 2.658, -0.930> <4.240, 2.586, -0.928> <4.258, 2.529, -0.865> <4.266, 2.533, -0.792> 
		<4.512, 2.708, -0.965> <4.525, 2.636, -0.963> <4.543, 2.579, -0.900> <4.551, 2.583, -0.828> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.551, 2.583, -0.828> <4.559, 2.587, -0.755> <4.555, 2.650, -0.697> <4.542, 2.722, -0.699> 
		<4.266, 2.533, -0.792> <4.274, 2.537, -0.720> <4.270, 2.600, -0.661> <4.258, 2.672, -0.664> 
		<3.886, 2.466, -0.746> <3.894, 2.470, -0.673> <3.891, 2.534, -0.614> <3.878, 2.606, -0.617> 
		<3.601, 2.416, -0.710> <3.610, 2.420, -0.638> <3.606, 2.484, -0.579> <3.593, 2.556, -0.582> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.181, 2.667, -0.758> <4.178, 2.684, -0.758> <4.174, 2.698, -0.773> <4.172, 2.697, -0.791> 
		<4.374, 2.699, -0.783> <4.371, 2.717, -0.784> <4.366, 2.730, -0.799> <4.364, 2.729, -0.816> 
		<4.631, 2.743, -0.818> <4.627, 2.760, -0.818> <4.623, 2.774, -0.833> <4.621, 2.773, -0.851> 
		<4.823, 2.776, -0.844> <4.820, 2.793, -0.844> <4.816, 2.806, -0.859> <4.814, 2.805, -0.877> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.172, 2.697, -0.791> <4.170, 2.696, -0.808> <4.171, 2.680, -0.822> <4.174, 2.663, -0.821> 
		<4.364, 2.729, -0.816> <4.362, 2.728, -0.834> <4.363, 2.713, -0.848> <4.366, 2.696, -0.847> 
		<4.621, 2.773, -0.851> <4.619, 2.772, -0.868> <4.620, 2.757, -0.882> <4.623, 2.739, -0.882> 
		<4.814, 2.805, -0.877> <4.812, 2.805, -0.894> <4.813, 2.789, -0.908> <4.816, 2.772, -0.907> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.174, 2.663, -0.821> <4.177, 2.646, -0.821> <4.181, 2.632, -0.806> <4.183, 2.633, -0.788> 
		<4.366, 2.696, -0.847> <4.370, 2.679, -0.847> <4.374, 2.665, -0.832> <4.376, 2.666, -0.814> 
		<4.623, 2.739, -0.882> <4.626, 2.722, -0.881> <4.631, 2.708, -0.866> <4.633, 2.709, -0.849> 
		<4.816, 2.772, -0.907> <4.819, 2.755, -0.907> <4.823, 2.741, -0.892> <4.825, 2.742, -0.874> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.825, 2.742, -0.874> <4.827, 2.743, -0.857> <4.826, 2.758, -0.843> <4.823, 2.776, -0.844> 
		<4.633, 2.709, -0.849> <4.635, 2.710, -0.831> <4.634, 2.726, -0.817> <4.631, 2.743, -0.818> 
		<4.376, 2.666, -0.814> <4.378, 2.667, -0.797> <4.377, 2.682, -0.783> <4.374, 2.699, -0.783> 
		<4.183, 2.633, -0.788> <4.185, 2.634, -0.771> <4.184, 2.649, -0.757> <4.181, 2.667, -0.758> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.611, 2.689, -0.840> <4.611, 2.680, -0.840> <4.617, 2.664, -0.840> <4.610, 2.658, -0.838> 
		<4.609, 2.689, -0.854> <4.609, 2.679, -0.854> <4.615, 2.663, -0.861> <4.608, 2.657, -0.860> 
		<4.605, 2.695, -0.874> <4.604, 2.688, -0.880> <4.610, 2.672, -0.887> <4.602, 2.667, -0.889> 
		<4.603, 2.705, -0.884> <4.601, 2.698, -0.890> <4.606, 2.686, -0.902> <4.598, 2.681, -0.905> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.610, 2.658, -0.838> <4.596, 2.645, -0.836> <4.571, 2.633, -0.833> <4.552, 2.635, -0.831> 
		<4.608, 2.657, -0.860> <4.594, 2.644, -0.857> <4.568, 2.631, -0.857> <4.549, 2.634, -0.855> 
		<4.602, 2.667, -0.889> <4.587, 2.657, -0.894> <4.561, 2.645, -0.894> <4.543, 2.645, -0.888> 
		<4.598, 2.681, -0.905> <4.583, 2.671, -0.909> <4.556, 2.660, -0.911> <4.538, 2.661, -0.905> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.552, 2.635, -0.831> <4.541, 2.636, -0.829> <4.529, 2.659, -0.829> <4.537, 2.667, -0.831> 
		<4.549, 2.634, -0.855> <4.539, 2.635, -0.853> <4.528, 2.659, -0.846> <4.535, 2.666, -0.847> 
		<4.543, 2.645, -0.888> <4.533, 2.646, -0.885> <4.523, 2.668, -0.873> <4.531, 2.674, -0.869> 
		<4.538, 2.661, -0.905> <4.528, 2.662, -0.902> <4.519, 2.679, -0.884> <4.527, 2.685, -0.881> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.537, 2.667, -0.831> <4.552, 2.683, -0.833> <4.586, 2.684, -0.837> <4.607, 2.692, -0.840> 
		<4.535, 2.666, -0.847> <4.551, 2.682, -0.849> <4.585, 2.684, -0.851> <4.606, 2.691, -0.853> 
		<4.531, 2.674, -0.869> <4.548, 2.687, -0.863> <4.581, 2.691, -0.872> <4.602, 2.698, -0.872> 
		<4.527, 2.685, -0.881> <4.545, 2.698, -0.875> <4.578, 2.700, -0.882> <4.599, 2.707, -0.882> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.612, 2.710, -0.797> <4.613, 2.703, -0.790> <4.620, 2.693, -0.779> <4.613, 2.688, -0.774> 
		<4.613, 2.699, -0.807> <4.613, 2.693, -0.800> <4.621, 2.677, -0.793> <4.614, 2.672, -0.789> 
		<4.612, 2.690, -0.826> <4.612, 2.681, -0.826> <4.619, 2.665, -0.818> <4.613, 2.659, -0.817> 
		<4.611, 2.689, -0.840> <4.611, 2.680, -0.840> <4.617, 2.664, -0.840> <4.610, 2.658, -0.838> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.613, 2.688, -0.774> <4.599, 2.679, -0.765> <4.574, 2.669, -0.756> <4.555, 2.669, -0.758> 
		<4.614, 2.672, -0.789> <4.600, 2.663, -0.779> <4.575, 2.651, -0.772> <4.556, 2.652, -0.774> 
		<4.613, 2.659, -0.817> <4.599, 2.646, -0.815> <4.573, 2.634, -0.809> <4.555, 2.636, -0.807> 
		<4.610, 2.658, -0.838> <4.596, 2.645, -0.836> <4.571, 2.633, -0.833> <4.552, 2.635, -0.831> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.555, 2.669, -0.758> <4.544, 2.670, -0.759> <4.532, 2.685, -0.776> <4.539, 2.690, -0.781> 
		<4.556, 2.652, -0.774> <4.545, 2.652, -0.775> <4.532, 2.673, -0.787> <4.539, 2.678, -0.792> 
		<4.555, 2.636, -0.807> <4.544, 2.638, -0.805> <4.531, 2.660, -0.813> <4.539, 2.668, -0.814> 
		<4.552, 2.635, -0.831> <4.541, 2.636, -0.829> <4.529, 2.659, -0.829> <4.537, 2.667, -0.831> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.539, 2.690, -0.781> <4.554, 2.702, -0.793> <4.588, 2.705, -0.794> <4.609, 2.711, -0.799> 
		<4.539, 2.678, -0.792> <4.555, 2.690, -0.804> <4.588, 2.695, -0.803> <4.609, 2.701, -0.808> 
		<4.539, 2.668, -0.814> <4.554, 2.684, -0.817> <4.588, 2.685, -0.824> <4.609, 2.693, -0.827> 
		<4.537, 2.667, -0.831> <4.552, 2.683, -0.833> <4.586, 2.684, -0.837> <4.607, 2.692, -0.840> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.607, 2.754, -0.781> <4.606, 2.754, -0.771> <4.611, 2.755, -0.755> <4.604, 2.754, -0.749> 
		<4.609, 2.740, -0.780> <4.609, 2.740, -0.771> <4.615, 2.734, -0.755> <4.608, 2.733, -0.749> 
		<4.612, 2.720, -0.788> <4.612, 2.714, -0.781> <4.619, 2.708, -0.764> <4.612, 2.704, -0.760> 
		<4.612, 2.710, -0.797> <4.613, 2.703, -0.790> <4.620, 2.693, -0.779> <4.613, 2.688, -0.774> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.604, 2.754, -0.749> <4.590, 2.752, -0.737> <4.563, 2.748, -0.726> <4.545, 2.744, -0.730> 
		<4.608, 2.733, -0.749> <4.594, 2.731, -0.737> <4.568, 2.724, -0.726> <4.549, 2.720, -0.729> 
		<4.612, 2.704, -0.760> <4.598, 2.694, -0.750> <4.573, 2.687, -0.740> <4.554, 2.687, -0.741> 
		<4.613, 2.688, -0.774> <4.599, 2.679, -0.765> <4.574, 2.669, -0.756> <4.555, 2.669, -0.758> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.545, 2.744, -0.730> <4.535, 2.742, -0.731> <4.524, 2.740, -0.755> <4.532, 2.741, -0.762> 
		<4.549, 2.720, -0.729> <4.539, 2.719, -0.731> <4.527, 2.724, -0.755> <4.535, 2.725, -0.762> 
		<4.554, 2.687, -0.741> <4.543, 2.687, -0.742> <4.531, 2.697, -0.765> <4.538, 2.702, -0.770> 
		<4.555, 2.669, -0.758> <4.544, 2.670, -0.759> <4.532, 2.685, -0.776> <4.539, 2.690, -0.781> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.532, 2.741, -0.762> <4.549, 2.743, -0.778> <4.582, 2.749, -0.777> <4.603, 2.753, -0.784> 
		<4.535, 2.725, -0.762> <4.552, 2.727, -0.777> <4.584, 2.736, -0.777> <4.606, 2.740, -0.783> 
		<4.538, 2.702, -0.770> <4.553, 2.714, -0.782> <4.587, 2.715, -0.785> <4.608, 2.721, -0.790> 
		<4.539, 2.690, -0.781> <4.554, 2.702, -0.793> <4.588, 2.705, -0.794> <4.609, 2.711, -0.799> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.597, 2.796, -0.800> <4.595, 2.802, -0.794> <4.598, 2.815, -0.783> <4.590, 2.817, -0.779> 
		<4.600, 2.786, -0.790> <4.598, 2.793, -0.784> <4.602, 2.801, -0.768> <4.594, 2.803, -0.763> 
		<4.604, 2.768, -0.781> <4.604, 2.768, -0.772> <4.608, 2.776, -0.756> <4.600, 2.775, -0.750> 
		<4.607, 2.754, -0.781> <4.606, 2.754, -0.771> <4.611, 2.755, -0.755> <4.604, 2.754, -0.749> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.590, 2.817, -0.779> <4.573, 2.822, -0.770> <4.546, 2.823, -0.761> <4.528, 2.816, -0.763> 
		<4.594, 2.803, -0.763> <4.578, 2.808, -0.754> <4.551, 2.807, -0.744> <4.533, 2.800, -0.745> 
		<4.600, 2.775, -0.750> <4.586, 2.773, -0.738> <4.559, 2.771, -0.727> <4.541, 2.768, -0.730> 
		<4.604, 2.754, -0.749> <4.590, 2.752, -0.737> <4.563, 2.748, -0.726> <4.545, 2.744, -0.730> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.528, 2.816, -0.763> <4.519, 2.812, -0.764> <4.512, 2.792, -0.779> <4.521, 2.789, -0.785> 
		<4.533, 2.800, -0.745> <4.524, 2.796, -0.746> <4.516, 2.781, -0.768> <4.524, 2.778, -0.773> 
		<4.541, 2.768, -0.730> <4.531, 2.766, -0.732> <4.522, 2.756, -0.756> <4.529, 2.757, -0.763> 
		<4.545, 2.744, -0.730> <4.535, 2.742, -0.731> <4.524, 2.740, -0.755> <4.532, 2.741, -0.762> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.521, 2.789, -0.785> <4.539, 2.783, -0.796> <4.572, 2.792, -0.797> <4.594, 2.793, -0.802> 
		<4.524, 2.778, -0.773> <4.543, 2.772, -0.784> <4.575, 2.783, -0.787> <4.597, 2.784, -0.792> 
		<4.529, 2.757, -0.763> <4.546, 2.759, -0.778> <4.580, 2.763, -0.778> <4.601, 2.766, -0.784> 
		<4.532, 2.741, -0.762> <4.549, 2.743, -0.778> <4.582, 2.749, -0.777> <4.603, 2.753, -0.784> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.589, 2.811, -0.844> <4.585, 2.820, -0.844> <4.586, 2.837, -0.845> <4.577, 2.841, -0.845> 
		<4.590, 2.812, -0.830> <4.587, 2.821, -0.830> <4.588, 2.838, -0.824> <4.580, 2.842, -0.823> 
		<4.594, 2.805, -0.811> <4.592, 2.812, -0.804> <4.593, 2.829, -0.798> <4.585, 2.831, -0.794> 
		<4.597, 2.796, -0.800> <4.595, 2.802, -0.794> <4.598, 2.815, -0.783> <4.590, 2.817, -0.779> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.577, 2.841, -0.845> <4.560, 2.848, -0.843> <4.531, 2.851, -0.840> <4.515, 2.842, -0.838> 
		<4.580, 2.842, -0.823> <4.562, 2.849, -0.822> <4.534, 2.852, -0.816> <4.517, 2.843, -0.814> 
		<4.585, 2.831, -0.794> <4.569, 2.836, -0.785> <4.541, 2.839, -0.779> <4.524, 2.832, -0.780> 
		<4.590, 2.817, -0.779> <4.573, 2.822, -0.770> <4.546, 2.823, -0.761> <4.528, 2.816, -0.763> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.515, 2.842, -0.838> <4.505, 2.837, -0.836> <4.502, 2.812, -0.834> <4.512, 2.807, -0.835> 
		<4.517, 2.843, -0.814> <4.508, 2.839, -0.812> <4.504, 2.812, -0.818> <4.513, 2.808, -0.819> 
		<4.524, 2.832, -0.780> <4.514, 2.828, -0.781> <4.509, 2.803, -0.791> <4.518, 2.800, -0.797> 
		<4.528, 2.816, -0.763> <4.519, 2.812, -0.764> <4.512, 2.792, -0.779> <4.521, 2.789, -0.785> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.512, 2.807, -0.835> <4.532, 2.797, -0.837> <4.564, 2.807, -0.841> <4.586, 2.808, -0.844> 
		<4.513, 2.808, -0.819> <4.534, 2.798, -0.821> <4.565, 2.808, -0.828> <4.588, 2.808, -0.830> 
		<4.518, 2.800, -0.797> <4.536, 2.793, -0.808> <4.569, 2.801, -0.807> <4.591, 2.802, -0.812> 
		<4.521, 2.789, -0.785> <4.539, 2.783, -0.796> <4.572, 2.792, -0.797> <4.594, 2.793, -0.802> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.587, 2.791, -0.887> <4.583, 2.797, -0.894> <4.584, 2.808, -0.906> <4.575, 2.810, -0.909> 
		<4.586, 2.801, -0.878> <4.583, 2.807, -0.884> <4.583, 2.824, -0.892> <4.574, 2.826, -0.894> 
		<4.587, 2.810, -0.858> <4.584, 2.819, -0.859> <4.584, 2.836, -0.867> <4.575, 2.839, -0.866> 
		<4.589, 2.811, -0.844> <4.585, 2.820, -0.844> <4.586, 2.837, -0.845> <4.577, 2.841, -0.845> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.575, 2.810, -0.909> <4.557, 2.814, -0.914> <4.528, 2.814, -0.917> <4.512, 2.808, -0.910> 
		<4.574, 2.826, -0.894> <4.556, 2.830, -0.900> <4.527, 2.832, -0.900> <4.511, 2.825, -0.894> 
		<4.575, 2.839, -0.866> <4.557, 2.847, -0.864> <4.529, 2.849, -0.864> <4.512, 2.841, -0.862> 
		<4.577, 2.841, -0.845> <4.560, 2.848, -0.843> <4.531, 2.851, -0.840> <4.515, 2.842, -0.838> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.512, 2.808, -0.910> <4.502, 2.804, -0.907> <4.500, 2.786, -0.888> <4.510, 2.784, -0.885> 
		<4.511, 2.825, -0.894> <4.501, 2.822, -0.891> <4.499, 2.798, -0.877> <4.509, 2.796, -0.873> 
		<4.512, 2.841, -0.862> <4.503, 2.836, -0.860> <4.500, 2.811, -0.851> <4.510, 2.806, -0.852> 
		<4.515, 2.842, -0.838> <4.505, 2.837, -0.836> <4.502, 2.812, -0.834> <4.512, 2.807, -0.835> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.510, 2.784, -0.885> <4.530, 2.778, -0.877> <4.562, 2.787, -0.885> <4.585, 2.788, -0.885> 
		<4.509, 2.796, -0.873> <4.529, 2.790, -0.866> <4.562, 2.797, -0.875> <4.584, 2.798, -0.875> 
		<4.510, 2.806, -0.852> <4.530, 2.796, -0.853> <4.562, 2.807, -0.855> <4.585, 2.807, -0.857> 
		<4.512, 2.807, -0.835> <4.532, 2.797, -0.837> <4.564, 2.807, -0.841> <4.586, 2.808, -0.844> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.593, 2.747, -0.904> <4.590, 2.746, -0.913> <4.592, 2.746, -0.930> <4.583, 2.744, -0.934> 
		<4.590, 2.761, -0.904> <4.587, 2.760, -0.913> <4.588, 2.767, -0.930> <4.579, 2.765, -0.934> 
		<4.588, 2.781, -0.897> <4.584, 2.786, -0.903> <4.585, 2.793, -0.921> <4.576, 2.795, -0.923> 
		<4.587, 2.791, -0.887> <4.583, 2.797, -0.894> <4.584, 2.808, -0.906> <4.575, 2.810, -0.909> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.583, 2.744, -0.934> <4.566, 2.741, -0.942> <4.538, 2.736, -0.946> <4.521, 2.733, -0.938> 
		<4.579, 2.765, -0.934> <4.563, 2.762, -0.943> <4.534, 2.759, -0.947> <4.517, 2.757, -0.939> 
		<4.576, 2.795, -0.923> <4.558, 2.799, -0.929> <4.529, 2.797, -0.933> <4.513, 2.790, -0.927> 
		<4.575, 2.810, -0.909> <4.557, 2.814, -0.914> <4.528, 2.814, -0.917> <4.512, 2.808, -0.910> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.521, 2.733, -0.938> <4.512, 2.731, -0.934> <4.507, 2.731, -0.909> <4.516, 2.733, -0.904> 
		<4.517, 2.757, -0.939> <4.507, 2.755, -0.935> <4.504, 2.747, -0.909> <4.513, 2.749, -0.904> 
		<4.513, 2.790, -0.927> <4.503, 2.786, -0.923> <4.501, 2.774, -0.899> <4.510, 2.772, -0.896> 
		<4.512, 2.808, -0.910> <4.502, 2.804, -0.907> <4.500, 2.786, -0.888> <4.510, 2.784, -0.885> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.516, 2.733, -0.904> <4.536, 2.737, -0.893> <4.568, 2.743, -0.901> <4.590, 2.747, -0.900> 
		<4.513, 2.749, -0.904> <4.533, 2.753, -0.893> <4.566, 2.756, -0.902> <4.588, 2.760, -0.901> 
		<4.510, 2.772, -0.896> <4.531, 2.766, -0.888> <4.563, 2.777, -0.894> <4.585, 2.778, -0.894> 
		<4.510, 2.784, -0.885> <4.530, 2.778, -0.877> <4.562, 2.787, -0.885> <4.585, 2.788, -0.885> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.603, 2.705, -0.884> <4.601, 2.698, -0.890> <4.606, 2.686, -0.902> <4.598, 2.681, -0.905> 
		<4.600, 2.714, -0.895> <4.598, 2.707, -0.901> <4.601, 2.700, -0.917> <4.594, 2.695, -0.920> 
		<4.595, 2.733, -0.903> <4.592, 2.732, -0.912> <4.595, 2.725, -0.929> <4.587, 2.723, -0.933> 
		<4.593, 2.747, -0.904> <4.590, 2.746, -0.913> <4.592, 2.746, -0.930> <4.583, 2.744, -0.934> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.598, 2.681, -0.905> <4.583, 2.671, -0.909> <4.556, 2.660, -0.911> <4.538, 2.661, -0.905> 
		<4.594, 2.695, -0.920> <4.578, 2.685, -0.925> <4.551, 2.676, -0.929> <4.533, 2.677, -0.923> 
		<4.587, 2.723, -0.933> <4.570, 2.720, -0.941> <4.543, 2.712, -0.945> <4.526, 2.709, -0.938> 
		<4.583, 2.744, -0.934> <4.566, 2.741, -0.942> <4.538, 2.736, -0.946> <4.521, 2.733, -0.938> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.538, 2.661, -0.905> <4.528, 2.662, -0.902> <4.519, 2.679, -0.884> <4.527, 2.685, -0.881> 
		<4.533, 2.677, -0.923> <4.523, 2.678, -0.920> <4.516, 2.689, -0.896> <4.524, 2.695, -0.893> 
		<4.526, 2.709, -0.938> <4.516, 2.708, -0.933> <4.510, 2.715, -0.908> <4.519, 2.717, -0.903> 
		<4.521, 2.733, -0.938> <4.512, 2.731, -0.934> <4.507, 2.731, -0.909> <4.516, 2.733, -0.904> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.527, 2.685, -0.881> <4.545, 2.698, -0.875> <4.578, 2.700, -0.882> <4.599, 2.707, -0.882> 
		<4.524, 2.695, -0.893> <4.541, 2.708, -0.886> <4.575, 2.709, -0.891> <4.597, 2.715, -0.892> 
		<4.519, 2.717, -0.903> <4.538, 2.721, -0.892> <4.570, 2.729, -0.901> <4.593, 2.733, -0.900> 
		<4.516, 2.733, -0.904> <4.536, 2.737, -0.893> <4.568, 2.743, -0.901> <4.590, 2.747, -0.900> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.886, 2.721, -0.919> <4.887, 2.712, -0.917> <4.890, 2.696, -0.920> <4.892, 2.691, -0.912> 
		<4.872, 2.719, -0.917> <4.874, 2.710, -0.915> <4.869, 2.692, -0.917> <4.871, 2.687, -0.909> 
		<4.851, 2.723, -0.915> <4.846, 2.716, -0.912> <4.842, 2.698, -0.914> <4.840, 2.694, -0.905> 
		<4.840, 2.732, -0.914> <4.835, 2.724, -0.911> <4.825, 2.710, -0.912> <4.823, 2.707, -0.904> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.892, 2.691, -0.912> <4.896, 2.682, -0.896> <4.901, 2.676, -0.868> <4.902, 2.682, -0.850> 
		<4.871, 2.687, -0.909> <4.875, 2.678, -0.893> <4.877, 2.672, -0.865> <4.879, 2.678, -0.847> 
		<4.840, 2.694, -0.905> <4.837, 2.687, -0.888> <4.838, 2.681, -0.860> <4.844, 2.686, -0.843> 
		<4.823, 2.707, -0.904> <4.819, 2.699, -0.887> <4.819, 2.695, -0.858> <4.824, 2.700, -0.841> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.902, 2.682, -0.850> <4.903, 2.686, -0.840> <4.899, 2.711, -0.834> <4.897, 2.716, -0.842> 
		<4.879, 2.678, -0.847> <4.879, 2.682, -0.837> <4.884, 2.708, -0.831> <4.881, 2.714, -0.840> 
		<4.844, 2.686, -0.843> <4.847, 2.689, -0.833> <4.855, 2.714, -0.828> <4.858, 2.719, -0.837> 
		<4.824, 2.700, -0.841> <4.827, 2.703, -0.831> <4.842, 2.724, -0.827> <4.844, 2.728, -0.836> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.897, 2.716, -0.842> <4.893, 2.728, -0.861> <4.889, 2.722, -0.894> <4.885, 2.724, -0.916> 
		<4.881, 2.714, -0.840> <4.877, 2.726, -0.859> <4.876, 2.720, -0.892> <4.872, 2.722, -0.914> 
		<4.858, 2.719, -0.837> <4.863, 2.729, -0.857> <4.854, 2.725, -0.890> <4.853, 2.727, -0.912> 
		<4.844, 2.728, -0.836> <4.850, 2.738, -0.856> <4.843, 2.733, -0.889> <4.842, 2.734, -0.911> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.925, 2.747, -0.926> <4.933, 2.741, -0.925> <4.946, 2.732, -0.930> <4.951, 2.729, -0.922> 
		<4.917, 2.735, -0.924> <4.925, 2.730, -0.923> <4.934, 2.714, -0.927> <4.939, 2.712, -0.919> 
		<4.899, 2.724, -0.921> <4.901, 2.715, -0.919> <4.911, 2.699, -0.923> <4.913, 2.695, -0.915> 
		<4.886, 2.721, -0.919> <4.887, 2.712, -0.917> <4.890, 2.696, -0.920> <4.892, 2.691, -0.912> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.951, 2.729, -0.922> <4.961, 2.724, -0.907> <4.971, 2.721, -0.880> <4.969, 2.726, -0.862> 
		<4.939, 2.712, -0.919> <4.949, 2.707, -0.904> <4.958, 2.702, -0.877> <4.956, 2.706, -0.859> 
		<4.913, 2.695, -0.915> <4.917, 2.686, -0.899> <4.924, 2.680, -0.871> <4.926, 2.687, -0.854> 
		<4.892, 2.691, -0.912> <4.896, 2.682, -0.896> <4.901, 2.676, -0.868> <4.902, 2.682, -0.850> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.969, 2.726, -0.862> <4.968, 2.728, -0.851> <4.949, 2.743, -0.842> <4.943, 2.746, -0.850> 
		<4.956, 2.706, -0.859> <4.954, 2.708, -0.848> <4.940, 2.729, -0.840> <4.933, 2.732, -0.848> 
		<4.926, 2.687, -0.854> <4.926, 2.690, -0.844> <4.915, 2.714, -0.836> <4.913, 2.719, -0.845> 
		<4.902, 2.682, -0.850> <4.903, 2.686, -0.840> <4.899, 2.711, -0.834> <4.897, 2.716, -0.842> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.943, 2.746, -0.850> <4.930, 2.752, -0.867> <4.929, 2.748, -0.901> <4.923, 2.748, -0.923> 
		<4.933, 2.732, -0.848> <4.920, 2.739, -0.865> <4.921, 2.737, -0.899> <4.915, 2.737, -0.921> 
		<4.913, 2.719, -0.845> <4.909, 2.731, -0.863> <4.902, 2.724, -0.896> <4.899, 2.727, -0.918> 
		<4.897, 2.716, -0.842> <4.893, 2.728, -0.861> <4.889, 2.722, -0.894> <4.885, 2.724, -0.916> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.935, 2.793, -0.930> <4.944, 2.794, -0.929> <4.960, 2.797, -0.935> <4.966, 2.798, -0.928> 
		<4.938, 2.779, -0.929> <4.947, 2.780, -0.929> <4.964, 2.776, -0.934> <4.970, 2.777, -0.927> 
		<4.933, 2.758, -0.928> <4.941, 2.753, -0.926> <4.958, 2.749, -0.932> <4.963, 2.747, -0.925> 
		<4.925, 2.747, -0.926> <4.933, 2.741, -0.925> <4.946, 2.732, -0.930> <4.951, 2.729, -0.922> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.966, 2.798, -0.928> <4.978, 2.801, -0.914> <4.989, 2.804, -0.887> <4.986, 2.804, -0.868> 
		<4.970, 2.777, -0.927> <4.982, 2.780, -0.913> <4.993, 2.780, -0.886> <4.990, 2.780, -0.868> 
		<4.963, 2.747, -0.925> <4.974, 2.742, -0.910> <4.985, 2.741, -0.883> <4.983, 2.745, -0.865> 
		<4.951, 2.729, -0.922> <4.961, 2.724, -0.907> <4.971, 2.721, -0.880> <4.969, 2.726, -0.862> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.986, 2.804, -0.868> <4.984, 2.804, -0.858> <4.961, 2.800, -0.847> <4.954, 2.799, -0.854> 
		<4.990, 2.780, -0.868> <4.989, 2.780, -0.857> <4.964, 2.784, -0.846> <4.957, 2.783, -0.854> 
		<4.983, 2.745, -0.865> <4.982, 2.748, -0.854> <4.958, 2.756, -0.844> <4.952, 2.759, -0.852> 
		<4.969, 2.726, -0.862> <4.968, 2.728, -0.851> <4.949, 2.743, -0.842> <4.943, 2.746, -0.850> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.954, 2.799, -0.854> <4.939, 2.795, -0.871> <4.939, 2.794, -0.905> <4.932, 2.792, -0.926> 
		<4.957, 2.783, -0.854> <4.942, 2.779, -0.870> <4.941, 2.781, -0.904> <4.935, 2.779, -0.926> 
		<4.952, 2.759, -0.852> <4.939, 2.765, -0.869> <4.937, 2.759, -0.902> <4.931, 2.760, -0.924> 
		<4.943, 2.746, -0.850> <4.930, 2.752, -0.867> <4.929, 2.748, -0.901> <4.923, 2.748, -0.923> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.910, 2.833, -0.929> <4.915, 2.840, -0.928> <4.924, 2.854, -0.934> <4.928, 2.858, -0.926> 
		<4.921, 2.824, -0.930> <4.927, 2.832, -0.929> <4.941, 2.841, -0.935> <4.945, 2.846, -0.928> 
		<4.933, 2.807, -0.930> <4.942, 2.808, -0.930> <4.956, 2.818, -0.936> <4.962, 2.819, -0.929> 
		<4.935, 2.793, -0.930> <4.944, 2.794, -0.929> <4.960, 2.797, -0.935> <4.966, 2.798, -0.928> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.928, 2.858, -0.926> <4.936, 2.867, -0.912> <4.944, 2.875, -0.885> <4.943, 2.872, -0.867> 
		<4.945, 2.846, -0.928> <4.953, 2.855, -0.913> <4.963, 2.861, -0.887> <4.963, 2.858, -0.868> 
		<4.962, 2.819, -0.929> <4.974, 2.822, -0.914> <4.985, 2.828, -0.888> <4.982, 2.828, -0.869> 
		<4.966, 2.798, -0.928> <4.978, 2.801, -0.914> <4.989, 2.804, -0.887> <4.986, 2.804, -0.868> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.943, 2.872, -0.867> <4.942, 2.870, -0.856> <4.929, 2.850, -0.846> <4.925, 2.845, -0.853> 
		<4.963, 2.858, -0.868> <4.962, 2.856, -0.858> <4.943, 2.841, -0.847> <4.938, 2.835, -0.854> 
		<4.982, 2.828, -0.869> <4.980, 2.828, -0.859> <4.958, 2.816, -0.847> <4.951, 2.815, -0.855> 
		<4.986, 2.804, -0.868> <4.984, 2.804, -0.858> <4.961, 2.800, -0.847> <4.954, 2.799, -0.854> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.925, 2.845, -0.853> <4.915, 2.833, -0.870> <4.913, 2.835, -0.904> <4.908, 2.830, -0.925> 
		<4.938, 2.835, -0.854> <4.928, 2.823, -0.871> <4.924, 2.827, -0.905> <4.919, 2.823, -0.926> 
		<4.951, 2.815, -0.855> <4.936, 2.811, -0.871> <4.937, 2.808, -0.905> <4.930, 2.806, -0.927> 
		<4.954, 2.799, -0.854> <4.939, 2.795, -0.871> <4.939, 2.794, -0.905> <4.932, 2.792, -0.926> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.864, 2.843, -0.923> <4.862, 2.852, -0.922> <4.859, 2.868, -0.926> <4.859, 2.874, -0.918> 
		<4.878, 2.845, -0.925> <4.876, 2.855, -0.924> <4.880, 2.872, -0.929> <4.880, 2.877, -0.921> 
		<4.898, 2.841, -0.928> <4.903, 2.849, -0.927> <4.907, 2.866, -0.932> <4.910, 2.871, -0.925> 
		<4.910, 2.833, -0.929> <4.915, 2.840, -0.928> <4.924, 2.854, -0.934> <4.928, 2.858, -0.926> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.859, 2.874, -0.918> <4.859, 2.885, -0.903> <4.862, 2.894, -0.875> <4.865, 2.890, -0.857> 
		<4.880, 2.877, -0.921> <4.880, 2.888, -0.906> <4.885, 2.898, -0.879> <4.888, 2.894, -0.861> 
		<4.910, 2.871, -0.925> <4.918, 2.880, -0.910> <4.924, 2.889, -0.883> <4.923, 2.886, -0.865> 
		<4.928, 2.858, -0.926> <4.936, 2.867, -0.912> <4.944, 2.875, -0.885> <4.943, 2.872, -0.867> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.865, 2.890, -0.857> <4.867, 2.887, -0.847> <4.872, 2.863, -0.839> <4.872, 2.857, -0.847> 
		<4.888, 2.894, -0.861> <4.890, 2.891, -0.851> <4.888, 2.866, -0.841> <4.888, 2.859, -0.849> 
		<4.923, 2.886, -0.865> <4.923, 2.884, -0.854> <4.916, 2.860, -0.844> <4.912, 2.854, -0.852> 
		<4.943, 2.872, -0.867> <4.942, 2.870, -0.856> <4.929, 2.850, -0.846> <4.925, 2.845, -0.853> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.872, 2.857, -0.847> <4.872, 2.843, -0.865> <4.867, 2.845, -0.898> <4.865, 2.840, -0.920> 
		<4.888, 2.859, -0.849> <4.888, 2.845, -0.867> <4.880, 2.847, -0.900> <4.878, 2.842, -0.922> 
		<4.912, 2.854, -0.852> <4.902, 2.842, -0.869> <4.902, 2.842, -0.903> <4.897, 2.838, -0.924> 
		<4.925, 2.845, -0.853> <4.915, 2.833, -0.870> <4.913, 2.835, -0.904> <4.908, 2.830, -0.925> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.824, 2.818, -0.917> <4.817, 2.823, -0.914> <4.803, 2.832, -0.917> <4.800, 2.836, -0.908> 
		<4.832, 2.829, -0.918> <4.825, 2.835, -0.916> <4.815, 2.850, -0.919> <4.812, 2.853, -0.911> 
		<4.850, 2.841, -0.921> <4.848, 2.850, -0.920> <4.838, 2.865, -0.923> <4.838, 2.870, -0.915> 
		<4.864, 2.843, -0.923> <4.862, 2.852, -0.922> <4.859, 2.868, -0.926> <4.859, 2.874, -0.918> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.800, 2.836, -0.908> <4.794, 2.843, -0.892> <4.791, 2.849, -0.864> <4.798, 2.846, -0.846> 
		<4.812, 2.853, -0.911> <4.806, 2.860, -0.894> <4.805, 2.868, -0.867> <4.811, 2.866, -0.849> 
		<4.838, 2.870, -0.915> <4.838, 2.881, -0.900> <4.838, 2.890, -0.872> <4.841, 2.885, -0.854> 
		<4.859, 2.874, -0.918> <4.859, 2.885, -0.903> <4.862, 2.894, -0.875> <4.865, 2.890, -0.857> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.798, 2.846, -0.846> <4.802, 2.845, -0.836> <4.823, 2.831, -0.830> <4.827, 2.827, -0.839> 
		<4.811, 2.866, -0.849> <4.815, 2.865, -0.839> <4.832, 2.845, -0.832> <4.836, 2.841, -0.841> 
		<4.841, 2.885, -0.854> <4.843, 2.883, -0.844> <4.856, 2.860, -0.836> <4.856, 2.854, -0.845> 
		<4.865, 2.890, -0.857> <4.867, 2.887, -0.847> <4.872, 2.863, -0.839> <4.872, 2.857, -0.847> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.827, 2.827, -0.839> <4.835, 2.819, -0.859> <4.827, 2.820, -0.892> <4.827, 2.816, -0.914> 
		<4.836, 2.841, -0.841> <4.844, 2.832, -0.861> <4.835, 2.831, -0.893> <4.835, 2.827, -0.915> 
		<4.856, 2.854, -0.845> <4.856, 2.840, -0.863> <4.854, 2.843, -0.896> <4.851, 2.838, -0.918> 
		<4.872, 2.857, -0.847> <4.872, 2.843, -0.865> <4.867, 2.845, -0.898> <4.865, 2.840, -0.920> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.814, 2.772, -0.913> <4.805, 2.770, -0.910> <4.789, 2.767, -0.911> <4.785, 2.767, -0.902> 
		<4.812, 2.786, -0.913> <4.803, 2.784, -0.910> <4.785, 2.788, -0.912> <4.781, 2.788, -0.903> 
		<4.816, 2.806, -0.915> <4.809, 2.812, -0.912> <4.791, 2.815, -0.914> <4.788, 2.818, -0.906> 
		<4.824, 2.818, -0.917> <4.817, 2.823, -0.914> <4.803, 2.832, -0.917> <4.800, 2.836, -0.908> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.785, 2.767, -0.902> <4.777, 2.766, -0.885> <4.773, 2.766, -0.856> <4.781, 2.768, -0.839> 
		<4.781, 2.788, -0.903> <4.773, 2.787, -0.886> <4.769, 2.790, -0.857> <4.777, 2.792, -0.840> 
		<4.788, 2.818, -0.906> <4.781, 2.825, -0.889> <4.777, 2.829, -0.861> <4.784, 2.827, -0.843> 
		<4.800, 2.836, -0.908> <4.794, 2.843, -0.892> <4.791, 2.849, -0.864> <4.798, 2.846, -0.846> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.781, 2.768, -0.839> <4.785, 2.769, -0.830> <4.810, 2.774, -0.825> <4.815, 2.774, -0.835> 
		<4.777, 2.792, -0.840> <4.781, 2.793, -0.831> <4.807, 2.790, -0.826> <4.812, 2.790, -0.835> 
		<4.784, 2.827, -0.843> <4.788, 2.826, -0.833> <4.814, 2.818, -0.828> <4.817, 2.814, -0.837> 
		<4.798, 2.846, -0.846> <4.802, 2.845, -0.836> <4.823, 2.831, -0.830> <4.827, 2.827, -0.839> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.815, 2.774, -0.835> <4.826, 2.776, -0.855> <4.817, 2.773, -0.887> <4.818, 2.772, -0.910> 
		<4.812, 2.790, -0.835> <4.823, 2.792, -0.855> <4.815, 2.786, -0.888> <4.815, 2.786, -0.911> 
		<4.817, 2.814, -0.837> <4.826, 2.806, -0.857> <4.819, 2.808, -0.890> <4.819, 2.805, -0.912> 
		<4.827, 2.827, -0.839> <4.835, 2.819, -0.859> <4.827, 2.820, -0.892> <4.827, 2.816, -0.914> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.840, 2.732, -0.914> <4.835, 2.724, -0.911> <4.825, 2.710, -0.912> <4.823, 2.707, -0.904> 
		<4.828, 2.740, -0.913> <4.823, 2.732, -0.910> <4.807, 2.723, -0.911> <4.806, 2.719, -0.902> 
		<4.817, 2.758, -0.912> <4.808, 2.756, -0.909> <4.793, 2.746, -0.910> <4.789, 2.746, -0.902> 
		<4.814, 2.772, -0.913> <4.805, 2.770, -0.910> <4.789, 2.767, -0.911> <4.785, 2.767, -0.902> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.823, 2.707, -0.904> <4.819, 2.699, -0.887> <4.819, 2.695, -0.858> <4.824, 2.700, -0.841> 
		<4.806, 2.719, -0.902> <4.802, 2.712, -0.885> <4.799, 2.708, -0.857> <4.804, 2.714, -0.839> 
		<4.789, 2.746, -0.902> <4.781, 2.745, -0.884> <4.777, 2.742, -0.856> <4.785, 2.744, -0.839> 
		<4.785, 2.767, -0.902> <4.777, 2.766, -0.885> <4.773, 2.766, -0.856> <4.781, 2.768, -0.839> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.824, 2.700, -0.841> <4.827, 2.703, -0.831> <4.842, 2.724, -0.827> <4.844, 2.728, -0.836> 
		<4.804, 2.714, -0.839> <4.807, 2.717, -0.830> <4.829, 2.733, -0.826> <4.831, 2.738, -0.835> 
		<4.785, 2.744, -0.839> <4.789, 2.745, -0.829> <4.813, 2.758, -0.825> <4.818, 2.758, -0.834> 
		<4.781, 2.768, -0.839> <4.785, 2.769, -0.830> <4.810, 2.774, -0.825> <4.815, 2.774, -0.835> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.844, 2.728, -0.836> <4.850, 2.738, -0.856> <4.843, 2.733, -0.889> <4.842, 2.734, -0.911> 
		<4.831, 2.738, -0.835> <4.836, 2.747, -0.855> <4.832, 2.740, -0.888> <4.831, 2.742, -0.910> 
		<4.818, 2.758, -0.834> <4.829, 2.759, -0.854> <4.819, 2.760, -0.887> <4.820, 2.759, -0.910> 
		<4.815, 2.774, -0.835> <4.826, 2.776, -0.855> <4.817, 2.773, -0.887> <4.818, 2.772, -0.910> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.508, 2.472, -0.742> <3.510, 2.463, -0.740> <3.512, 2.446, -0.743> <3.514, 2.442, -0.735> 
		<3.494, 2.470, -0.740> <3.496, 2.461, -0.738> <3.491, 2.443, -0.740> <3.493, 2.438, -0.732> 
		<3.473, 2.474, -0.737> <3.468, 2.467, -0.734> <3.464, 2.449, -0.736> <3.463, 2.445, -0.728> 
		<3.462, 2.482, -0.736> <3.457, 2.475, -0.733> <3.447, 2.461, -0.735> <3.445, 2.457, -0.726> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.514, 2.442, -0.735> <3.518, 2.433, -0.718> <3.523, 2.427, -0.691> <3.524, 2.433, -0.673> 
		<3.493, 2.438, -0.732> <3.497, 2.429, -0.715> <3.499, 2.423, -0.687> <3.501, 2.429, -0.670> 
		<3.463, 2.445, -0.728> <3.459, 2.438, -0.711> <3.460, 2.431, -0.683> <3.466, 2.437, -0.665> 
		<3.445, 2.457, -0.726> <3.442, 2.450, -0.709> <3.441, 2.445, -0.681> <3.446, 2.451, -0.664> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.524, 2.433, -0.673> <3.525, 2.437, -0.663> <3.522, 2.462, -0.656> <3.520, 2.467, -0.665> 
		<3.501, 2.429, -0.670> <3.502, 2.433, -0.660> <3.506, 2.459, -0.654> <3.504, 2.464, -0.663> 
		<3.466, 2.437, -0.665> <3.469, 2.440, -0.656> <3.478, 2.465, -0.650> <3.480, 2.470, -0.660> 
		<3.446, 2.451, -0.664> <3.449, 2.454, -0.654> <3.464, 2.475, -0.649> <3.467, 2.479, -0.659> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.520, 2.467, -0.665> <3.515, 2.479, -0.683> <3.511, 2.473, -0.717> <3.508, 2.475, -0.739> 
		<3.504, 2.464, -0.663> <3.499, 2.476, -0.681> <3.498, 2.471, -0.715> <3.494, 2.473, -0.737> 
		<3.480, 2.470, -0.660> <3.485, 2.479, -0.680> <3.476, 2.476, -0.712> <3.475, 2.477, -0.735> 
		<3.467, 2.479, -0.659> <3.472, 2.489, -0.678> <3.465, 2.483, -0.711> <3.464, 2.485, -0.734> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.547, 2.497, -0.748> <3.555, 2.492, -0.747> <3.568, 2.482, -0.752> <3.573, 2.480, -0.745> 
		<3.539, 2.486, -0.747> <3.547, 2.480, -0.745> <3.556, 2.465, -0.749> <3.561, 2.462, -0.742> 
		<3.522, 2.474, -0.744> <3.524, 2.465, -0.742> <3.533, 2.450, -0.746> <3.535, 2.446, -0.737> 
		<3.508, 2.472, -0.742> <3.510, 2.463, -0.740> <3.512, 2.446, -0.743> <3.514, 2.442, -0.735> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.573, 2.480, -0.745> <3.584, 2.475, -0.729> <3.594, 2.472, -0.702> <3.591, 2.476, -0.684> 
		<3.561, 2.462, -0.742> <3.572, 2.458, -0.727> <3.580, 2.452, -0.700> <3.578, 2.457, -0.681> 
		<3.535, 2.446, -0.737> <3.539, 2.436, -0.721> <3.547, 2.431, -0.694> <3.548, 2.437, -0.676> 
		<3.514, 2.442, -0.735> <3.518, 2.433, -0.718> <3.523, 2.427, -0.691> <3.524, 2.433, -0.673> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.591, 2.476, -0.684> <3.590, 2.479, -0.674> <3.571, 2.493, -0.664> <3.565, 2.496, -0.672> 
		<3.578, 2.457, -0.681> <3.577, 2.459, -0.671> <3.562, 2.480, -0.662> <3.556, 2.483, -0.670> 
		<3.548, 2.437, -0.676> <3.549, 2.441, -0.666> <3.538, 2.464, -0.658> <3.535, 2.470, -0.667> 
		<3.524, 2.433, -0.673> <3.525, 2.437, -0.663> <3.522, 2.462, -0.656> <3.520, 2.467, -0.665> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.565, 2.496, -0.672> <3.552, 2.503, -0.690> <3.551, 2.498, -0.723> <3.545, 2.499, -0.745> 
		<3.556, 2.483, -0.670> <3.543, 2.490, -0.688> <3.543, 2.487, -0.722> <3.538, 2.488, -0.743> 
		<3.535, 2.470, -0.667> <3.531, 2.482, -0.686> <3.524, 2.475, -0.718> <3.521, 2.478, -0.741> 
		<3.520, 2.467, -0.665> <3.515, 2.479, -0.683> <3.511, 2.473, -0.717> <3.508, 2.475, -0.739> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.557, 2.543, -0.752> <3.567, 2.545, -0.752> <3.582, 2.548, -0.758> <3.588, 2.549, -0.750> 
		<3.560, 2.529, -0.752> <3.569, 2.531, -0.751> <3.586, 2.527, -0.757> <3.592, 2.528, -0.750> 
		<3.555, 2.509, -0.750> <3.563, 2.504, -0.749> <3.580, 2.500, -0.755> <3.585, 2.497, -0.747> 
		<3.547, 2.497, -0.748> <3.555, 2.492, -0.747> <3.568, 2.482, -0.752> <3.573, 2.480, -0.745> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.588, 2.549, -0.750> <3.600, 2.552, -0.736> <3.611, 2.555, -0.710> <3.608, 2.555, -0.691> 
		<3.592, 2.528, -0.750> <3.604, 2.531, -0.735> <3.616, 2.531, -0.709> <3.613, 2.531, -0.690> 
		<3.585, 2.497, -0.747> <3.596, 2.492, -0.732> <3.607, 2.492, -0.705> <3.605, 2.496, -0.687> 
		<3.573, 2.480, -0.745> <3.584, 2.475, -0.729> <3.594, 2.472, -0.702> <3.591, 2.476, -0.684> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.608, 2.555, -0.691> <3.607, 2.555, -0.680> <3.583, 2.551, -0.669> <3.576, 2.549, -0.677> 
		<3.613, 2.531, -0.690> <3.611, 2.531, -0.680> <3.586, 2.535, -0.669> <3.579, 2.533, -0.676> 
		<3.605, 2.496, -0.687> <3.604, 2.498, -0.677> <3.580, 2.507, -0.666> <3.574, 2.510, -0.674> 
		<3.591, 2.476, -0.684> <3.590, 2.479, -0.674> <3.571, 2.493, -0.664> <3.565, 2.496, -0.672> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.576, 2.549, -0.677> <3.561, 2.546, -0.693> <3.561, 2.545, -0.727> <3.555, 2.543, -0.749> 
		<3.579, 2.533, -0.676> <3.564, 2.530, -0.693> <3.564, 2.532, -0.727> <3.557, 2.530, -0.748> 
		<3.574, 2.510, -0.674> <3.561, 2.516, -0.692> <3.559, 2.509, -0.725> <3.553, 2.510, -0.747> 
		<3.565, 2.496, -0.672> <3.552, 2.503, -0.690> <3.551, 2.498, -0.723> <3.545, 2.499, -0.745> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.532, 2.583, -0.751> <3.537, 2.591, -0.751> <3.546, 2.604, -0.756> <3.550, 2.609, -0.749> 
		<3.543, 2.575, -0.752> <3.549, 2.583, -0.752> <3.564, 2.592, -0.758> <3.567, 2.597, -0.750> 
		<3.555, 2.557, -0.753> <3.564, 2.559, -0.752> <3.578, 2.569, -0.758> <3.584, 2.570, -0.751> 
		<3.557, 2.543, -0.752> <3.567, 2.545, -0.752> <3.582, 2.548, -0.758> <3.588, 2.549, -0.750> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.550, 2.609, -0.749> <3.558, 2.618, -0.734> <3.566, 2.626, -0.708> <3.565, 2.623, -0.689> 
		<3.567, 2.597, -0.750> <3.575, 2.606, -0.736> <3.586, 2.612, -0.710> <3.585, 2.609, -0.691> 
		<3.584, 2.570, -0.751> <3.596, 2.573, -0.737> <3.607, 2.578, -0.710> <3.604, 2.579, -0.692> 
		<3.588, 2.549, -0.750> <3.600, 2.552, -0.736> <3.611, 2.555, -0.710> <3.608, 2.555, -0.691> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.565, 2.623, -0.689> <3.565, 2.621, -0.679> <3.552, 2.601, -0.668> <3.547, 2.595, -0.676> 
		<3.585, 2.609, -0.691> <3.584, 2.607, -0.680> <3.565, 2.592, -0.669> <3.560, 2.586, -0.677> 
		<3.604, 2.579, -0.692> <3.602, 2.579, -0.681> <3.581, 2.567, -0.670> <3.573, 2.566, -0.678> 
		<3.608, 2.555, -0.691> <3.607, 2.555, -0.680> <3.583, 2.551, -0.669> <3.576, 2.549, -0.677> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.547, 2.595, -0.676> <3.537, 2.584, -0.692> <3.535, 2.585, -0.726> <3.530, 2.581, -0.748> 
		<3.560, 2.586, -0.677> <3.551, 2.574, -0.694> <3.546, 2.578, -0.727> <3.541, 2.573, -0.749> 
		<3.573, 2.566, -0.678> <3.558, 2.562, -0.694> <3.559, 2.558, -0.728> <3.552, 2.556, -0.749> 
		<3.576, 2.549, -0.677> <3.561, 2.546, -0.693> <3.561, 2.545, -0.727> <3.555, 2.543, -0.749> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.486, 2.594, -0.746> <3.484, 2.603, -0.744> <3.481, 2.619, -0.748> <3.481, 2.625, -0.741> 
		<3.500, 2.596, -0.748> <3.498, 2.605, -0.746> <3.502, 2.623, -0.751> <3.502, 2.628, -0.744> 
		<3.520, 2.592, -0.750> <3.526, 2.599, -0.749> <3.529, 2.617, -0.755> <3.533, 2.621, -0.747> 
		<3.532, 2.583, -0.751> <3.537, 2.591, -0.751> <3.546, 2.604, -0.756> <3.550, 2.609, -0.749> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.481, 2.625, -0.741> <3.482, 2.635, -0.725> <3.484, 2.645, -0.698> <3.487, 2.640, -0.680> 
		<3.502, 2.628, -0.744> <3.502, 2.639, -0.728> <3.507, 2.649, -0.701> <3.511, 2.644, -0.683> 
		<3.533, 2.621, -0.747> <3.541, 2.631, -0.733> <3.546, 2.640, -0.706> <3.545, 2.637, -0.687> 
		<3.550, 2.609, -0.749> <3.558, 2.618, -0.734> <3.566, 2.626, -0.708> <3.565, 2.623, -0.689> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.487, 2.640, -0.680> <3.489, 2.638, -0.670> <3.494, 2.614, -0.661> <3.494, 2.607, -0.670> 
		<3.511, 2.644, -0.683> <3.513, 2.642, -0.673> <3.510, 2.617, -0.663> <3.510, 2.610, -0.672> 
		<3.545, 2.637, -0.687> <3.545, 2.635, -0.677> <3.538, 2.610, -0.667> <3.534, 2.605, -0.675> 
		<3.565, 2.623, -0.689> <3.565, 2.621, -0.679> <3.552, 2.601, -0.668> <3.547, 2.595, -0.676> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.494, 2.607, -0.670> <3.494, 2.593, -0.687> <3.489, 2.596, -0.721> <3.487, 2.591, -0.743> 
		<3.510, 2.610, -0.672> <3.510, 2.596, -0.690> <3.502, 2.598, -0.723> <3.500, 2.593, -0.745> 
		<3.534, 2.605, -0.675> <3.524, 2.593, -0.691> <3.524, 2.593, -0.725> <3.519, 2.589, -0.747> 
		<3.547, 2.595, -0.676> <3.537, 2.584, -0.692> <3.535, 2.585, -0.726> <3.530, 2.581, -0.748> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.446, 2.568, -0.739> <3.439, 2.574, -0.737> <3.425, 2.583, -0.739> <3.422, 2.587, -0.731> 
		<3.454, 2.580, -0.741> <3.447, 2.586, -0.738> <3.437, 2.601, -0.742> <3.434, 2.604, -0.733> 
		<3.472, 2.591, -0.744> <3.471, 2.601, -0.742> <3.460, 2.615, -0.746> <3.460, 2.621, -0.738> 
		<3.486, 2.594, -0.746> <3.484, 2.603, -0.744> <3.481, 2.619, -0.748> <3.481, 2.625, -0.741> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.422, 2.587, -0.731> <3.416, 2.593, -0.714> <3.413, 2.599, -0.686> <3.420, 2.597, -0.669> 
		<3.434, 2.604, -0.733> <3.428, 2.611, -0.717> <3.427, 2.619, -0.689> <3.434, 2.617, -0.671> 
		<3.460, 2.621, -0.738> <3.461, 2.632, -0.722> <3.460, 2.641, -0.695> <3.464, 2.636, -0.677> 
		<3.481, 2.625, -0.741> <3.482, 2.635, -0.725> <3.484, 2.645, -0.698> <3.487, 2.640, -0.680> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.420, 2.597, -0.669> <3.424, 2.596, -0.659> <3.445, 2.582, -0.653> <3.449, 2.578, -0.662> 
		<3.434, 2.617, -0.671> <3.437, 2.616, -0.662> <3.454, 2.596, -0.655> <3.458, 2.592, -0.664> 
		<3.464, 2.636, -0.677> <3.465, 2.634, -0.666> <3.478, 2.611, -0.659> <3.478, 2.605, -0.667> 
		<3.487, 2.640, -0.680> <3.489, 2.638, -0.670> <3.494, 2.614, -0.661> <3.494, 2.607, -0.670> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.449, 2.578, -0.662> <3.457, 2.570, -0.681> <3.449, 2.570, -0.714> <3.449, 2.567, -0.736> 
		<3.458, 2.592, -0.664> <3.466, 2.583, -0.683> <3.457, 2.581, -0.716> <3.457, 2.578, -0.738> 
		<3.478, 2.605, -0.667> <3.478, 2.591, -0.685> <3.476, 2.594, -0.719> <3.474, 2.589, -0.741> 
		<3.494, 2.607, -0.670> <3.494, 2.593, -0.687> <3.489, 2.596, -0.721> <3.487, 2.591, -0.743> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.436, 2.522, -0.735> <3.428, 2.521, -0.732> <3.411, 2.518, -0.733> <3.407, 2.517, -0.725> 
		<3.434, 2.536, -0.736> <3.425, 2.535, -0.733> <3.407, 2.539, -0.734> <3.403, 2.538, -0.726> 
		<3.438, 2.557, -0.737> <3.431, 2.562, -0.735> <3.413, 2.566, -0.736> <3.410, 2.569, -0.728> 
		<3.446, 2.568, -0.739> <3.439, 2.574, -0.737> <3.425, 2.583, -0.739> <3.422, 2.587, -0.731> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.407, 2.517, -0.725> <3.399, 2.517, -0.708> <3.395, 2.517, -0.679> <3.403, 2.519, -0.662> 
		<3.403, 2.538, -0.726> <3.395, 2.538, -0.708> <3.391, 2.541, -0.680> <3.399, 2.543, -0.663> 
		<3.410, 2.569, -0.728> <3.404, 2.576, -0.712> <3.399, 2.580, -0.683> <3.406, 2.578, -0.666> 
		<3.422, 2.587, -0.731> <3.416, 2.593, -0.714> <3.413, 2.599, -0.686> <3.420, 2.597, -0.669> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.403, 2.519, -0.662> <3.407, 2.520, -0.652> <3.433, 2.525, -0.648> <3.437, 2.525, -0.657> 
		<3.399, 2.543, -0.663> <3.403, 2.544, -0.653> <3.430, 2.541, -0.648> <3.435, 2.541, -0.658> 
		<3.406, 2.578, -0.666> <3.410, 2.576, -0.656> <3.436, 2.569, -0.651> <3.440, 2.565, -0.660> 
		<3.420, 2.597, -0.669> <3.424, 2.596, -0.659> <3.445, 2.582, -0.653> <3.449, 2.578, -0.662> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.437, 2.525, -0.657> <3.448, 2.526, -0.677> <3.439, 2.524, -0.710> <3.440, 2.523, -0.733> 
		<3.435, 2.541, -0.658> <3.445, 2.542, -0.678> <3.437, 2.537, -0.710> <3.437, 2.536, -0.733> 
		<3.440, 2.565, -0.660> <3.448, 2.556, -0.679> <3.442, 2.559, -0.712> <3.442, 2.556, -0.735> 
		<3.449, 2.578, -0.662> <3.457, 2.570, -0.681> <3.449, 2.570, -0.714> <3.449, 2.567, -0.736> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.462, 2.482, -0.736> <3.457, 2.475, -0.733> <3.447, 2.461, -0.735> <3.445, 2.457, -0.726> 
		<3.450, 2.491, -0.735> <3.445, 2.483, -0.732> <3.430, 2.473, -0.733> <3.428, 2.470, -0.725> 
		<3.439, 2.508, -0.735> <3.430, 2.507, -0.732> <3.415, 2.497, -0.733> <3.411, 2.496, -0.724> 
		<3.436, 2.522, -0.735> <3.428, 2.521, -0.732> <3.411, 2.518, -0.733> <3.407, 2.517, -0.725> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.445, 2.457, -0.726> <3.442, 2.450, -0.709> <3.441, 2.445, -0.681> <3.446, 2.451, -0.664> 
		<3.428, 2.470, -0.725> <3.424, 2.462, -0.708> <3.421, 2.459, -0.679> <3.427, 2.465, -0.662> 
		<3.411, 2.496, -0.724> <3.403, 2.496, -0.707> <3.400, 2.493, -0.678> <3.407, 2.495, -0.661> 
		<3.407, 2.517, -0.725> <3.399, 2.517, -0.708> <3.395, 2.517, -0.679> <3.403, 2.519, -0.662> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.446, 2.451, -0.664> <3.449, 2.454, -0.654> <3.464, 2.475, -0.649> <3.467, 2.479, -0.659> 
		<3.427, 2.465, -0.662> <3.430, 2.468, -0.652> <3.451, 2.484, -0.648> <3.453, 2.489, -0.657> 
		<3.407, 2.495, -0.661> <3.412, 2.496, -0.651> <3.435, 2.508, -0.647> <3.440, 2.509, -0.657> 
		<3.403, 2.519, -0.662> <3.407, 2.520, -0.652> <3.433, 2.525, -0.648> <3.437, 2.525, -0.657> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.467, 2.479, -0.659> <3.472, 2.489, -0.678> <3.465, 2.483, -0.711> <3.464, 2.485, -0.734> 
		<3.453, 2.489, -0.657> <3.458, 2.498, -0.677> <3.454, 2.491, -0.710> <3.453, 2.493, -0.733> 
		<3.440, 2.509, -0.657> <3.451, 2.510, -0.677> <3.442, 2.510, -0.710> <3.442, 2.510, -0.732> 
		<3.437, 2.525, -0.657> <3.448, 2.526, -0.677> <3.439, 2.524, -0.710> <3.440, 2.523, -0.733> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.988, 2.694, -0.742> <4.987, 2.693, -0.724> <4.996, 2.698, -0.693> <4.984, 2.691, -0.682> 
		<4.995, 2.670, -0.742> <4.994, 2.669, -0.724> <5.007, 2.662, -0.693> <4.995, 2.655, -0.681> 
		<5.004, 2.637, -0.757> <5.006, 2.625, -0.744> <5.017, 2.618, -0.713> <5.008, 2.605, -0.704> 
		<5.007, 2.620, -0.776> <5.009, 2.608, -0.763> <5.022, 2.593, -0.740> <5.013, 2.580, -0.732> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.984, 2.691, -0.682> <4.963, 2.678, -0.660> <4.922, 2.653, -0.641> <4.894, 2.636, -0.648> 
		<4.995, 2.655, -0.681> <4.974, 2.642, -0.659> <4.934, 2.612, -0.640> <4.907, 2.596, -0.648> 
		<5.008, 2.605, -0.704> <4.990, 2.581, -0.689> <4.953, 2.550, -0.669> <4.922, 2.539, -0.674> 
		<5.013, 2.580, -0.732> <4.995, 2.556, -0.716> <4.959, 2.521, -0.700> <4.927, 2.511, -0.706> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.894, 2.636, -0.648> <4.877, 2.626, -0.653> <4.862, 2.618, -0.699> <4.875, 2.626, -0.713> 
		<4.907, 2.596, -0.648> <4.890, 2.586, -0.652> <4.871, 2.590, -0.698> <4.883, 2.598, -0.712> 
		<4.922, 2.539, -0.674> <4.904, 2.533, -0.677> <4.884, 2.546, -0.721> <4.893, 2.560, -0.730> 
		<4.927, 2.511, -0.706> <4.910, 2.505, -0.708> <4.888, 2.527, -0.742> <4.897, 2.541, -0.751> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.875, 2.626, -0.713> <4.899, 2.641, -0.740> <4.951, 2.672, -0.737> <4.983, 2.691, -0.748> 
		<4.883, 2.598, -0.712> <4.908, 2.613, -0.739> <4.957, 2.649, -0.737> <4.990, 2.669, -0.747> 
		<4.893, 2.560, -0.730> <4.913, 2.589, -0.750> <4.967, 2.613, -0.754> <4.998, 2.637, -0.762> 
		<4.897, 2.541, -0.751> <4.917, 2.570, -0.771> <4.970, 2.597, -0.771> <5.001, 2.621, -0.780> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.963, 2.766, -0.778> <4.958, 2.775, -0.766> <4.960, 2.799, -0.745> <4.946, 2.798, -0.736> 
		<4.969, 2.750, -0.760> <4.964, 2.760, -0.747> <4.970, 2.776, -0.716> <4.956, 2.775, -0.708> 
		<4.981, 2.718, -0.743> <4.979, 2.717, -0.724> <4.985, 2.734, -0.694> <4.973, 2.727, -0.682> 
		<4.988, 2.694, -0.742> <4.987, 2.693, -0.724> <4.996, 2.698, -0.693> <4.984, 2.691, -0.682> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.946, 2.798, -0.736> <4.919, 2.796, -0.719> <4.875, 2.779, -0.706> <4.851, 2.758, -0.710> 
		<4.956, 2.775, -0.708> <4.929, 2.773, -0.691> <4.886, 2.753, -0.674> <4.862, 2.732, -0.678> 
		<4.973, 2.727, -0.682> <4.952, 2.714, -0.661> <4.909, 2.694, -0.641> <4.882, 2.677, -0.649> 
		<4.984, 2.691, -0.682> <4.963, 2.678, -0.660> <4.922, 2.653, -0.641> <4.894, 2.636, -0.648> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.851, 2.758, -0.710> <4.836, 2.744, -0.713> <4.829, 2.708, -0.743> <4.846, 2.708, -0.754> 
		<4.862, 2.732, -0.678> <4.847, 2.718, -0.681> <4.836, 2.690, -0.722> <4.853, 2.690, -0.733> 
		<4.882, 2.677, -0.649> <4.865, 2.667, -0.654> <4.854, 2.646, -0.699> <4.866, 2.653, -0.713> 
		<4.894, 2.636, -0.648> <4.877, 2.626, -0.653> <4.862, 2.618, -0.699> <4.875, 2.626, -0.713> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.846, 2.708, -0.754> <4.877, 2.708, -0.776> <4.925, 2.744, -0.774> <4.959, 2.759, -0.782> 
		<4.853, 2.690, -0.733> <4.885, 2.691, -0.754> <4.931, 2.729, -0.756> <4.965, 2.745, -0.764> 
		<4.866, 2.653, -0.713> <4.891, 2.668, -0.740> <4.943, 2.694, -0.738> <4.976, 2.714, -0.748> 
		<4.875, 2.626, -0.713> <4.899, 2.641, -0.740> <4.951, 2.672, -0.737> <4.983, 2.691, -0.748> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.946, 2.793, -0.863> <4.939, 2.806, -0.864> <4.937, 2.837, -0.865> <4.921, 2.838, -0.864> 
		<4.948, 2.794, -0.836> <4.941, 2.807, -0.836> <4.940, 2.839, -0.824> <4.925, 2.840, -0.823> 
		<4.956, 2.782, -0.799> <4.951, 2.792, -0.786> <4.950, 2.824, -0.775> <4.935, 2.823, -0.767> 
		<4.963, 2.766, -0.778> <4.958, 2.775, -0.766> <4.960, 2.799, -0.745> <4.946, 2.798, -0.736> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.921, 2.838, -0.864> <4.890, 2.841, -0.861> <4.844, 2.826, -0.857> <4.823, 2.804, -0.855> 
		<4.925, 2.840, -0.823> <4.893, 2.843, -0.821> <4.848, 2.828, -0.811> <4.827, 2.805, -0.809> 
		<4.935, 2.823, -0.767> <4.908, 2.821, -0.750> <4.863, 2.807, -0.741> <4.839, 2.786, -0.745> 
		<4.946, 2.798, -0.736> <4.919, 2.796, -0.719> <4.875, 2.779, -0.706> <4.851, 2.758, -0.710> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.823, 2.804, -0.855> <4.810, 2.789, -0.853> <4.807, 2.742, -0.851> <4.827, 2.739, -0.852> 
		<4.827, 2.805, -0.809> <4.814, 2.791, -0.807> <4.810, 2.743, -0.820> <4.829, 2.740, -0.821> 
		<4.839, 2.786, -0.745> <4.824, 2.773, -0.748> <4.821, 2.727, -0.767> <4.838, 2.727, -0.778> 
		<4.851, 2.758, -0.710> <4.836, 2.744, -0.713> <4.829, 2.708, -0.743> <4.846, 2.708, -0.754> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.827, 2.739, -0.852> <4.864, 2.733, -0.855> <4.908, 2.771, -0.860> <4.943, 2.785, -0.863> 
		<4.829, 2.740, -0.821> <4.866, 2.734, -0.824> <4.910, 2.772, -0.834> <4.945, 2.786, -0.837> 
		<4.838, 2.727, -0.778> <4.869, 2.727, -0.799> <4.918, 2.759, -0.793> <4.952, 2.775, -0.802> 
		<4.846, 2.708, -0.754> <4.877, 2.708, -0.776> <4.925, 2.744, -0.774> <4.959, 2.759, -0.782> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.948, 2.759, -0.947> <4.941, 2.768, -0.960> <4.940, 2.790, -0.983> <4.924, 2.789, -0.989> 
		<4.944, 2.777, -0.928> <4.937, 2.786, -0.940> <4.934, 2.817, -0.953> <4.919, 2.816, -0.960> 
		<4.944, 2.792, -0.890> <4.936, 2.805, -0.890> <4.933, 2.836, -0.905> <4.918, 2.837, -0.904> 
		<4.946, 2.793, -0.863> <4.939, 2.806, -0.864> <4.937, 2.837, -0.865> <4.921, 2.838, -0.864> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.924, 2.789, -0.989> <4.894, 2.786, -1.001> <4.849, 2.768, -1.007> <4.826, 2.747, -0.997> 
		<4.919, 2.816, -0.960> <4.889, 2.813, -0.972> <4.842, 2.798, -0.973> <4.820, 2.778, -0.964> 
		<4.918, 2.837, -0.904> <4.886, 2.840, -0.902> <4.840, 2.825, -0.903> <4.819, 2.802, -0.900> 
		<4.921, 2.838, -0.864> <4.890, 2.841, -0.861> <4.844, 2.826, -0.857> <4.823, 2.804, -0.855> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.826, 2.747, -0.997> <4.812, 2.734, -0.991> <4.810, 2.700, -0.957> <4.829, 2.700, -0.949> 
		<4.820, 2.778, -0.964> <4.806, 2.765, -0.958> <4.806, 2.720, -0.934> <4.825, 2.721, -0.926> 
		<4.819, 2.802, -0.900> <4.806, 2.788, -0.899> <4.805, 2.741, -0.882> <4.824, 2.738, -0.883> 
		<4.823, 2.804, -0.855> <4.810, 2.789, -0.853> <4.807, 2.742, -0.851> <4.827, 2.739, -0.852> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.829, 2.700, -0.949> <4.863, 2.702, -0.933> <4.910, 2.737, -0.944> <4.945, 2.753, -0.943> 
		<4.825, 2.721, -0.926> <4.859, 2.723, -0.910> <4.907, 2.754, -0.926> <4.941, 2.770, -0.924> 
		<4.824, 2.738, -0.883> <4.861, 2.732, -0.886> <4.906, 2.770, -0.885> <4.941, 2.784, -0.889> 
		<4.827, 2.739, -0.852> <4.864, 2.733, -0.855> <4.908, 2.771, -0.860> <4.943, 2.785, -0.863> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.967, 2.685, -0.981> <4.963, 2.683, -0.999> <4.966, 2.686, -1.031> <4.953, 2.678, -1.040> 
		<4.960, 2.709, -0.981> <4.956, 2.707, -0.999> <4.955, 2.722, -1.031> <4.942, 2.713, -1.040> 
		<4.951, 2.743, -0.966> <4.944, 2.751, -0.978> <4.944, 2.765, -1.010> <4.929, 2.763, -1.017> 
		<4.948, 2.759, -0.947> <4.941, 2.768, -0.960> <4.940, 2.790, -0.983> <4.924, 2.789, -0.989> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.953, 2.678, -1.040> <4.928, 2.663, -1.056> <4.885, 2.637, -1.068> <4.859, 2.621, -1.054> 
		<4.942, 2.713, -1.040> <4.917, 2.699, -1.057> <4.872, 2.678, -1.068> <4.847, 2.662, -1.055> 
		<4.929, 2.763, -1.017> <4.899, 2.760, -1.029> <4.854, 2.739, -1.038> <4.832, 2.719, -1.028> 
		<4.924, 2.789, -0.989> <4.894, 2.786, -1.001> <4.849, 2.768, -1.007> <4.826, 2.747, -0.997> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.859, 2.621, -1.054> <4.843, 2.612, -1.046> <4.836, 2.607, -0.999> <4.851, 2.615, -0.987> 
		<4.847, 2.662, -1.055> <4.831, 2.652, -1.047> <4.828, 2.634, -0.999> <4.843, 2.643, -0.988> 
		<4.832, 2.719, -1.028> <4.818, 2.705, -1.022> <4.814, 2.680, -0.978> <4.833, 2.681, -0.970> 
		<4.826, 2.747, -0.997> <4.812, 2.734, -0.991> <4.810, 2.700, -0.957> <4.829, 2.700, -0.949> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.851, 2.615, -0.987> <4.879, 2.632, -0.966> <4.930, 2.663, -0.978> <4.963, 2.683, -0.975> 
		<4.843, 2.643, -0.988> <4.871, 2.660, -0.966> <4.923, 2.685, -0.979> <4.956, 2.706, -0.975> 
		<4.833, 2.681, -0.970> <4.867, 2.683, -0.954> <4.913, 2.721, -0.962> <4.948, 2.737, -0.960> 
		<4.829, 2.700, -0.949> <4.863, 2.702, -0.933> <4.910, 2.737, -0.944> <4.945, 2.753, -0.943> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.993, 2.614, -0.945> <4.992, 2.601, -0.957> <5.001, 2.584, -0.980> <4.991, 2.570, -0.985> 
		<4.986, 2.629, -0.964> <4.986, 2.616, -0.976> <4.992, 2.607, -1.008> <4.981, 2.593, -1.014> 
		<4.975, 2.661, -0.981> <4.970, 2.659, -0.998> <4.978, 2.649, -1.030> <4.964, 2.641, -1.039> 
		<4.967, 2.685, -0.981> <4.963, 2.683, -0.999> <4.966, 2.686, -1.031> <4.953, 2.678, -1.040> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.991, 2.570, -0.985> <4.971, 2.545, -0.996> <4.933, 2.510, -1.004> <4.902, 2.500, -0.993> 
		<4.981, 2.593, -1.014> <4.961, 2.568, -1.024> <4.922, 2.536, -1.036> <4.891, 2.526, -1.025> 
		<4.964, 2.641, -1.039> <4.939, 2.627, -1.056> <4.898, 2.596, -1.067> <4.872, 2.580, -1.054> 
		<4.953, 2.678, -1.040> <4.928, 2.663, -1.056> <4.885, 2.637, -1.068> <4.859, 2.621, -1.054> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.902, 2.500, -0.993> <4.886, 2.494, -0.987> <4.870, 2.519, -0.952> <4.880, 2.533, -0.946> 
		<4.891, 2.526, -1.025> <4.874, 2.520, -1.019> <4.862, 2.537, -0.974> <4.873, 2.551, -0.967> 
		<4.872, 2.580, -1.054> <4.856, 2.571, -1.045> <4.845, 2.579, -0.998> <4.860, 2.588, -0.987> 
		<4.859, 2.621, -1.054> <4.843, 2.612, -1.046> <4.836, 2.607, -0.999> <4.851, 2.615, -0.987> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.880, 2.533, -0.946> <4.903, 2.564, -0.932> <4.955, 2.590, -0.942> <4.987, 2.615, -0.940> 
		<4.873, 2.551, -0.967> <4.895, 2.581, -0.953> <4.949, 2.605, -0.960> <4.981, 2.630, -0.958> 
		<4.860, 2.588, -0.987> <4.888, 2.604, -0.965> <4.937, 2.640, -0.978> <4.970, 2.660, -0.974> 
		<4.851, 2.615, -0.987> <4.879, 2.632, -0.966> <4.930, 2.663, -0.978> <4.963, 2.683, -0.975> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.009, 2.587, -0.860> <5.011, 2.570, -0.859> <5.025, 2.545, -0.859> <5.016, 2.530, -0.858> 
		<5.007, 2.586, -0.887> <5.009, 2.569, -0.886> <5.021, 2.543, -0.900> <5.012, 2.529, -0.898> 
		<5.000, 2.597, -0.924> <4.999, 2.584, -0.936> <5.012, 2.559, -0.949> <5.002, 2.546, -0.955> 
		<4.993, 2.614, -0.945> <4.992, 2.601, -0.957> <5.001, 2.584, -0.980> <4.991, 2.570, -0.985> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.016, 2.530, -0.858> <4.998, 2.501, -0.855> <4.964, 2.462, -0.851> <4.930, 2.454, -0.848> 
		<5.012, 2.529, -0.898> <4.995, 2.499, -0.896> <4.960, 2.460, -0.897> <4.926, 2.452, -0.894> 
		<5.002, 2.546, -0.955> <4.981, 2.520, -0.965> <4.945, 2.482, -0.969> <4.914, 2.472, -0.958> 
		<4.991, 2.570, -0.985> <4.971, 2.545, -0.996> <4.933, 2.510, -1.004> <4.902, 2.500, -0.993> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.930, 2.454, -0.848> <4.914, 2.450, -0.847> <4.891, 2.487, -0.847> <4.899, 2.502, -0.848> 
		<4.926, 2.452, -0.894> <4.910, 2.448, -0.893> <4.888, 2.486, -0.878> <4.897, 2.501, -0.879> 
		<4.914, 2.472, -0.958> <4.898, 2.466, -0.952> <4.878, 2.500, -0.928> <4.888, 2.514, -0.922> 
		<4.902, 2.500, -0.993> <4.886, 2.494, -0.987> <4.870, 2.519, -0.952> <4.880, 2.533, -0.946> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.899, 2.502, -0.848> <4.919, 2.538, -0.851> <4.972, 2.563, -0.856> <5.003, 2.589, -0.859> 
		<4.897, 2.501, -0.879> <4.916, 2.537, -0.882> <4.970, 2.562, -0.882> <5.001, 2.588, -0.885> 
		<4.888, 2.514, -0.922> <4.911, 2.545, -0.908> <4.962, 2.575, -0.922> <4.994, 2.599, -0.921> 
		<4.880, 2.533, -0.946> <4.903, 2.564, -0.932> <4.955, 2.590, -0.942> <4.987, 2.615, -0.940> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.007, 2.620, -0.776> <5.009, 2.608, -0.763> <5.022, 2.593, -0.740> <5.013, 2.580, -0.732> 
		<5.011, 2.602, -0.796> <5.013, 2.590, -0.782> <5.028, 2.566, -0.770> <5.018, 2.553, -0.762> 
		<5.012, 2.588, -0.833> <5.014, 2.571, -0.832> <5.028, 2.546, -0.819> <5.019, 2.532, -0.817> 
		<5.009, 2.587, -0.860> <5.011, 2.570, -0.859> <5.025, 2.545, -0.859> <5.016, 2.530, -0.858> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.013, 2.580, -0.732> <4.995, 2.556, -0.716> <4.959, 2.521, -0.700> <4.927, 2.511, -0.706> 
		<5.018, 2.553, -0.762> <5.001, 2.528, -0.746> <4.965, 2.491, -0.734> <4.933, 2.480, -0.739> 
		<5.019, 2.532, -0.817> <5.002, 2.502, -0.815> <4.968, 2.464, -0.805> <4.934, 2.456, -0.802> 
		<5.016, 2.530, -0.858> <4.998, 2.501, -0.855> <4.964, 2.462, -0.851> <4.930, 2.454, -0.848> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.927, 2.511, -0.706> <4.910, 2.505, -0.708> <4.888, 2.527, -0.742> <4.897, 2.541, -0.751> 
		<4.933, 2.480, -0.739> <4.916, 2.474, -0.742> <4.892, 2.506, -0.765> <4.901, 2.520, -0.774> 
		<4.934, 2.456, -0.802> <4.918, 2.452, -0.801> <4.894, 2.488, -0.816> <4.902, 2.503, -0.817> 
		<4.930, 2.454, -0.848> <4.914, 2.450, -0.847> <4.891, 2.487, -0.847> <4.899, 2.502, -0.848> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.897, 2.541, -0.751> <4.917, 2.570, -0.771> <4.970, 2.597, -0.771> <5.001, 2.621, -0.780> 
		<4.901, 2.520, -0.774> <4.921, 2.549, -0.794> <4.973, 2.580, -0.790> <5.005, 2.604, -0.798> 
		<4.902, 2.503, -0.817> <4.921, 2.539, -0.820> <4.974, 2.564, -0.830> <5.005, 2.590, -0.834> 
		<4.899, 2.502, -0.848> <4.919, 2.538, -0.851> <4.972, 2.563, -0.856> <5.003, 2.589, -0.859> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.532, 2.415, -0.556> <3.531, 2.417, -0.538> <3.542, 2.419, -0.508> <3.528, 2.421, -0.496> 
		<3.523, 2.392, -0.553> <3.522, 2.394, -0.535> <3.529, 2.384, -0.503> <3.515, 2.386, -0.491> 
		<3.510, 2.359, -0.566> <3.504, 2.350, -0.551> <3.510, 2.340, -0.519> <3.494, 2.337, -0.510> 
		<3.502, 2.342, -0.582> <3.496, 2.333, -0.568> <3.498, 2.315, -0.544> <3.483, 2.311, -0.535> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.528, 2.421, -0.496> <3.504, 2.426, -0.474> <3.457, 2.433, -0.454> <3.425, 2.436, -0.462> 
		<3.515, 2.386, -0.491> <3.491, 2.391, -0.470> <3.442, 2.394, -0.449> <3.410, 2.397, -0.457> 
		<3.494, 2.337, -0.510> <3.466, 2.330, -0.493> <3.418, 2.330, -0.472> <3.386, 2.340, -0.478> 
		<3.483, 2.311, -0.535> <3.454, 2.304, -0.518> <3.405, 2.301, -0.500> <3.373, 2.311, -0.506> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.425, 2.436, -0.462> <3.405, 2.438, -0.466> <3.387, 2.436, -0.512> <3.401, 2.433, -0.526> 
		<3.410, 2.397, -0.457> <3.390, 2.398, -0.461> <3.377, 2.409, -0.508> <3.391, 2.406, -0.522> 
		<3.386, 2.340, -0.478> <3.369, 2.346, -0.481> <3.360, 2.364, -0.526> <3.375, 2.368, -0.536> 
		<3.373, 2.311, -0.506> <3.355, 2.317, -0.509> <3.351, 2.345, -0.546> <3.366, 2.349, -0.555> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.401, 2.433, -0.526> <3.429, 2.428, -0.553> <3.489, 2.421, -0.551> <3.526, 2.416, -0.562> 
		<3.391, 2.406, -0.522> <3.419, 2.401, -0.550> <3.480, 2.399, -0.548> <3.518, 2.394, -0.559> 
		<3.375, 2.368, -0.536> <3.408, 2.378, -0.558> <3.466, 2.363, -0.561> <3.505, 2.362, -0.570> 
		<3.366, 2.349, -0.555> <3.399, 2.358, -0.577> <3.458, 2.347, -0.577> <3.497, 2.346, -0.586> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.555, 2.484, -0.600> <3.557, 2.495, -0.588> <3.574, 2.515, -0.570> <3.562, 2.523, -0.561> 
		<3.551, 2.469, -0.579> <3.553, 2.481, -0.568> <3.568, 2.493, -0.539> <3.557, 2.502, -0.531> 
		<3.541, 2.439, -0.559> <3.540, 2.441, -0.541> <3.555, 2.454, -0.512> <3.541, 2.456, -0.500> 
		<3.532, 2.415, -0.556> <3.531, 2.417, -0.538> <3.542, 2.419, -0.508> <3.528, 2.421, -0.496> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.562, 2.523, -0.561> <3.540, 2.540, -0.546> <3.495, 2.555, -0.533> <3.463, 2.552, -0.536> 
		<3.557, 2.502, -0.531> <3.534, 2.519, -0.515> <3.488, 2.531, -0.498> <3.457, 2.528, -0.501> 
		<3.541, 2.456, -0.500> <3.517, 2.461, -0.479> <3.472, 2.473, -0.459> <3.440, 2.476, -0.467> 
		<3.528, 2.421, -0.496> <3.504, 2.426, -0.474> <3.457, 2.433, -0.454> <3.425, 2.436, -0.462> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.463, 2.552, -0.536> <3.443, 2.550, -0.538> <3.414, 2.523, -0.566> <3.427, 2.511, -0.576> 
		<3.457, 2.528, -0.501> <3.437, 2.526, -0.504> <3.410, 2.506, -0.542> <3.423, 2.495, -0.552> 
		<3.440, 2.476, -0.467> <3.420, 2.478, -0.472> <3.397, 2.463, -0.515> <3.411, 2.460, -0.529> 
		<3.425, 2.436, -0.462> <3.405, 2.438, -0.466> <3.387, 2.436, -0.512> <3.401, 2.433, -0.526> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.427, 2.511, -0.576> <3.452, 2.490, -0.596> <3.512, 2.490, -0.595> <3.548, 2.480, -0.603> 
		<3.423, 2.495, -0.552> <3.448, 2.474, -0.572> <3.508, 2.476, -0.576> <3.544, 2.467, -0.584> 
		<3.411, 2.460, -0.529> <3.439, 2.454, -0.556> <3.497, 2.443, -0.554> <3.535, 2.438, -0.564> 
		<3.401, 2.433, -0.526> <3.429, 2.428, -0.553> <3.489, 2.421, -0.551> <3.526, 2.416, -0.562> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.556, 2.506, -0.688> <3.559, 2.522, -0.689> <3.576, 2.547, -0.693> <3.565, 2.558, -0.693> 
		<3.559, 2.509, -0.661> <3.562, 2.524, -0.662> <3.581, 2.550, -0.653> <3.569, 2.561, -0.653> 
		<3.559, 2.499, -0.622> <3.561, 2.511, -0.611> <3.580, 2.538, -0.603> <3.568, 2.546, -0.595> 
		<3.555, 2.484, -0.600> <3.557, 2.495, -0.588> <3.574, 2.515, -0.570> <3.562, 2.523, -0.561> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.565, 2.558, -0.693> <3.542, 2.579, -0.692> <3.497, 2.595, -0.689> <3.466, 2.591, -0.685> 
		<3.569, 2.561, -0.653> <3.546, 2.582, -0.652> <3.502, 2.599, -0.643> <3.471, 2.594, -0.640> 
		<3.568, 2.546, -0.595> <3.546, 2.563, -0.579> <3.502, 2.581, -0.570> <3.470, 2.578, -0.574> 
		<3.562, 2.523, -0.561> <3.540, 2.540, -0.546> <3.495, 2.555, -0.533> <3.463, 2.552, -0.536> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.466, 2.591, -0.685> <3.447, 2.588, -0.683> <3.416, 2.552, -0.677> <3.429, 2.538, -0.677> 
		<3.471, 2.594, -0.640> <3.452, 2.591, -0.637> <3.419, 2.554, -0.646> <3.433, 2.540, -0.646> 
		<3.470, 2.578, -0.574> <3.450, 2.576, -0.576> <3.419, 2.540, -0.591> <3.432, 2.529, -0.601> 
		<3.463, 2.552, -0.536> <3.443, 2.550, -0.538> <3.414, 2.523, -0.566> <3.427, 2.511, -0.576> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.429, 2.538, -0.677> <3.455, 2.510, -0.677> <3.513, 2.513, -0.684> <3.549, 2.502, -0.687> 
		<3.433, 2.540, -0.646> <3.458, 2.513, -0.646> <3.516, 2.515, -0.658> <3.552, 2.504, -0.661> 
		<3.432, 2.529, -0.601> <3.457, 2.508, -0.621> <3.516, 2.504, -0.616> <3.552, 2.495, -0.624> 
		<3.427, 2.511, -0.576> <3.452, 2.490, -0.596> <3.512, 2.490, -0.595> <3.548, 2.480, -0.603> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.536, 2.471, -0.768> <3.535, 2.481, -0.782> <3.547, 2.497, -0.807> <3.534, 2.504, -0.814> 
		<3.545, 2.489, -0.750> <3.544, 2.499, -0.764> <3.560, 2.524, -0.780> <3.547, 2.532, -0.787> 
		<3.553, 2.504, -0.715> <3.556, 2.520, -0.716> <3.571, 2.544, -0.734> <3.560, 2.555, -0.733> 
		<3.556, 2.506, -0.688> <3.559, 2.522, -0.689> <3.576, 2.547, -0.693> <3.565, 2.558, -0.693> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.534, 2.504, -0.814> <3.508, 2.519, -0.827> <3.461, 2.532, -0.832> <3.431, 2.530, -0.822> 
		<3.547, 2.532, -0.787> <3.521, 2.546, -0.800> <3.476, 2.563, -0.802> <3.446, 2.561, -0.791> 
		<3.560, 2.555, -0.733> <3.537, 2.576, -0.733> <3.491, 2.592, -0.735> <3.461, 2.587, -0.731> 
		<3.565, 2.558, -0.693> <3.542, 2.579, -0.692> <3.497, 2.595, -0.689> <3.466, 2.591, -0.685> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.431, 2.530, -0.822> <3.412, 2.529, -0.815> <3.390, 2.506, -0.778> <3.406, 2.497, -0.769> 
		<3.446, 2.561, -0.791> <3.427, 2.560, -0.785> <3.400, 2.528, -0.758> <3.415, 2.518, -0.749> 
		<3.461, 2.587, -0.731> <3.441, 2.585, -0.729> <3.412, 2.550, -0.708> <3.426, 2.535, -0.708> 
		<3.466, 2.591, -0.685> <3.447, 2.588, -0.683> <3.416, 2.552, -0.677> <3.429, 2.538, -0.677> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.406, 2.497, -0.769> <3.435, 2.479, -0.752> <3.493, 2.477, -0.765> <3.530, 2.468, -0.763> 
		<3.415, 2.518, -0.749> <3.444, 2.500, -0.731> <3.501, 2.494, -0.748> <3.538, 2.486, -0.746> 
		<3.426, 2.535, -0.708> <3.451, 2.508, -0.708> <3.510, 2.511, -0.709> <3.546, 2.500, -0.712> 
		<3.429, 2.538, -0.677> <3.455, 2.510, -0.677> <3.513, 2.513, -0.684> <3.549, 2.502, -0.687> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.505, 2.397, -0.794> <3.500, 2.396, -0.811> <3.504, 2.393, -0.843> <3.488, 2.394, -0.852> 
		<3.514, 2.421, -0.797> <3.509, 2.420, -0.814> <3.517, 2.428, -0.848> <3.501, 2.429, -0.857> 
		<3.528, 2.454, -0.785> <3.527, 2.464, -0.798> <3.535, 2.471, -0.832> <3.522, 2.479, -0.838> 
		<3.536, 2.471, -0.768> <3.535, 2.481, -0.782> <3.547, 2.497, -0.807> <3.534, 2.504, -0.814> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.488, 2.394, -0.852> <3.459, 2.396, -0.869> <3.409, 2.401, -0.880> <3.379, 2.405, -0.866> 
		<3.501, 2.429, -0.857> <3.473, 2.431, -0.873> <3.424, 2.440, -0.885> <3.394, 2.445, -0.871> 
		<3.522, 2.479, -0.838> <3.497, 2.493, -0.851> <3.448, 2.503, -0.861> <3.417, 2.501, -0.850> 
		<3.534, 2.504, -0.814> <3.508, 2.519, -0.827> <3.461, 2.532, -0.832> <3.431, 2.530, -0.822> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.379, 2.405, -0.866> <3.361, 2.408, -0.858> <3.353, 2.413, -0.810> <3.371, 2.412, -0.799> 
		<3.394, 2.445, -0.871> <3.376, 2.448, -0.863> <3.364, 2.440, -0.813> <3.381, 2.439, -0.802> 
		<3.417, 2.501, -0.850> <3.398, 2.500, -0.844> <3.381, 2.487, -0.797> <3.396, 2.477, -0.788> 
		<3.431, 2.530, -0.822> <3.412, 2.529, -0.815> <3.390, 2.506, -0.778> <3.406, 2.497, -0.769> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.371, 2.412, -0.799> <3.404, 2.411, -0.778> <3.462, 2.403, -0.791> <3.501, 2.399, -0.787> 
		<3.381, 2.439, -0.802> <3.414, 2.437, -0.781> <3.470, 2.425, -0.794> <3.509, 2.421, -0.790> 
		<3.396, 2.477, -0.788> <3.425, 2.459, -0.771> <3.485, 2.461, -0.781> <3.522, 2.452, -0.779> 
		<3.406, 2.497, -0.769> <3.435, 2.479, -0.752> <3.493, 2.477, -0.765> <3.530, 2.468, -0.763> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.483, 2.329, -0.750> <3.474, 2.318, -0.761> <3.471, 2.297, -0.782> <3.454, 2.292, -0.787> 
		<3.487, 2.344, -0.771> <3.478, 2.332, -0.782> <3.476, 2.318, -0.813> <3.460, 2.313, -0.817> 
		<3.497, 2.374, -0.791> <3.491, 2.373, -0.809> <3.491, 2.358, -0.839> <3.475, 2.359, -0.848> 
		<3.505, 2.397, -0.794> <3.500, 2.396, -0.811> <3.504, 2.393, -0.843> <3.488, 2.394, -0.852> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.454, 2.292, -0.787> <3.423, 2.283, -0.796> <3.371, 2.278, -0.802> <3.341, 2.290, -0.792> 
		<3.460, 2.313, -0.817> <3.428, 2.305, -0.827> <3.377, 2.302, -0.837> <3.347, 2.314, -0.826> 
		<3.475, 2.359, -0.848> <3.446, 2.361, -0.864> <3.394, 2.361, -0.874> <3.364, 2.366, -0.861> 
		<3.488, 2.394, -0.852> <3.459, 2.396, -0.869> <3.409, 2.401, -0.880> <3.379, 2.405, -0.866> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.341, 2.290, -0.792> <3.324, 2.296, -0.786> <3.328, 2.329, -0.754> <3.344, 2.334, -0.749> 
		<3.347, 2.314, -0.826> <3.331, 2.320, -0.821> <3.332, 2.345, -0.778> <3.349, 2.350, -0.772> 
		<3.364, 2.366, -0.861> <3.346, 2.368, -0.853> <3.343, 2.386, -0.807> <3.360, 2.385, -0.796> 
		<3.379, 2.405, -0.866> <3.361, 2.408, -0.858> <3.353, 2.413, -0.810> <3.371, 2.412, -0.799> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.344, 2.334, -0.749> <3.381, 2.346, -0.737> <3.439, 2.334, -0.747> <3.479, 2.334, -0.746> 
		<3.349, 2.350, -0.772> <3.386, 2.362, -0.760> <3.442, 2.347, -0.766> <3.483, 2.347, -0.765> 
		<3.360, 2.385, -0.796> <3.394, 2.384, -0.774> <3.453, 2.380, -0.788> <3.492, 2.376, -0.785> 
		<3.371, 2.412, -0.799> <3.404, 2.411, -0.778> <3.462, 2.403, -0.791> <3.501, 2.399, -0.787> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.481, 2.306, -0.662> <3.472, 2.292, -0.660> <3.468, 2.264, -0.657> <3.452, 2.258, -0.655> 
		<3.478, 2.304, -0.689> <3.469, 2.290, -0.687> <3.463, 2.261, -0.698> <3.447, 2.255, -0.696> 
		<3.479, 2.314, -0.728> <3.470, 2.303, -0.739> <3.465, 2.274, -0.749> <3.448, 2.269, -0.754> 
		<3.483, 2.329, -0.750> <3.474, 2.318, -0.761> <3.471, 2.297, -0.782> <3.454, 2.292, -0.787> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.452, 2.258, -0.655> <3.420, 2.245, -0.651> <3.369, 2.236, -0.645> <3.338, 2.251, -0.642> 
		<3.447, 2.255, -0.696> <3.415, 2.242, -0.691> <3.364, 2.233, -0.690> <3.333, 2.247, -0.688> 
		<3.448, 2.269, -0.754> <3.416, 2.260, -0.763> <3.364, 2.252, -0.764> <3.334, 2.264, -0.754> 
		<3.454, 2.292, -0.787> <3.423, 2.283, -0.796> <3.371, 2.278, -0.802> <3.341, 2.290, -0.792> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.338, 2.251, -0.642> <3.322, 2.258, -0.641> <3.327, 2.301, -0.646> <3.343, 2.308, -0.648> 
		<3.333, 2.247, -0.688> <3.317, 2.254, -0.687> <3.324, 2.299, -0.677> <3.339, 2.305, -0.679> 
		<3.334, 2.264, -0.754> <3.317, 2.270, -0.748> <3.323, 2.311, -0.729> <3.340, 2.317, -0.723> 
		<3.341, 2.290, -0.792> <3.324, 2.296, -0.786> <3.328, 2.329, -0.754> <3.344, 2.334, -0.749> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.343, 2.308, -0.648> <3.380, 2.324, -0.653> <3.437, 2.311, -0.658> <3.478, 2.312, -0.663> 
		<3.339, 2.305, -0.679> <3.376, 2.322, -0.684> <3.434, 2.309, -0.684> <3.475, 2.310, -0.688> 
		<3.340, 2.317, -0.723> <3.377, 2.328, -0.711> <3.435, 2.319, -0.726> <3.475, 2.319, -0.725> 
		<3.344, 2.334, -0.749> <3.381, 2.346, -0.737> <3.439, 2.334, -0.747> <3.479, 2.334, -0.746> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.502, 2.342, -0.582> <3.496, 2.333, -0.568> <3.498, 2.315, -0.544> <3.483, 2.311, -0.535> 
		<3.493, 2.324, -0.600> <3.487, 2.314, -0.586> <3.485, 2.287, -0.570> <3.470, 2.284, -0.561> 
		<3.484, 2.308, -0.636> <3.475, 2.294, -0.633> <3.472, 2.267, -0.617> <3.456, 2.261, -0.615> 
		<3.481, 2.306, -0.662> <3.472, 2.292, -0.660> <3.468, 2.264, -0.657> <3.452, 2.258, -0.655> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.483, 2.311, -0.535> <3.454, 2.304, -0.518> <3.405, 2.301, -0.500> <3.373, 2.311, -0.506> 
		<3.470, 2.284, -0.561> <3.441, 2.277, -0.545> <3.390, 2.270, -0.531> <3.358, 2.280, -0.536> 
		<3.456, 2.261, -0.615> <3.425, 2.248, -0.610> <3.374, 2.240, -0.599> <3.343, 2.254, -0.597> 
		<3.452, 2.258, -0.655> <3.420, 2.245, -0.651> <3.369, 2.236, -0.645> <3.338, 2.251, -0.642> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.373, 2.311, -0.506> <3.355, 2.317, -0.509> <3.351, 2.345, -0.546> <3.366, 2.349, -0.555> 
		<3.358, 2.280, -0.536> <3.341, 2.286, -0.539> <3.341, 2.323, -0.566> <3.356, 2.328, -0.576> 
		<3.343, 2.254, -0.597> <3.328, 2.261, -0.596> <3.331, 2.303, -0.615> <3.346, 2.310, -0.617> 
		<3.338, 2.251, -0.642> <3.322, 2.258, -0.641> <3.327, 2.301, -0.646> <3.343, 2.308, -0.648> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.366, 2.349, -0.555> <3.399, 2.358, -0.577> <3.458, 2.347, -0.577> <3.497, 2.346, -0.586> 
		<3.356, 2.328, -0.576> <3.389, 2.337, -0.597> <3.450, 2.329, -0.594> <3.489, 2.328, -0.603> 
		<3.346, 2.310, -0.617> <3.383, 2.326, -0.622> <3.440, 2.313, -0.633> <3.481, 2.314, -0.637> 
		<3.343, 2.308, -0.648> <3.380, 2.324, -0.653> <3.437, 2.311, -0.658> <3.478, 2.312, -0.663> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.701, 2.529, 0.793> <3.711, 2.602, 0.799> <3.729, 2.665, 0.743> <3.741, 2.669, 0.671> 
		<3.986, 2.490, 0.841> <3.995, 2.562, 0.846> <4.013, 2.626, 0.791> <4.026, 2.629, 0.719> 
		<4.366, 2.437, 0.905> <4.375, 2.510, 0.910> <4.393, 2.573, 0.854> <4.406, 2.577, 0.782> 
		<4.651, 2.398, 0.953> <4.660, 2.470, 0.958> <4.678, 2.534, 0.902> <4.690, 2.537, 0.830> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.741, 2.669, 0.671> <3.754, 2.672, 0.599> <3.757, 2.615, 0.535> <3.748, 2.542, 0.529> 
		<4.026, 2.629, 0.719> <4.039, 2.633, 0.647> <4.041, 2.576, 0.582> <4.032, 2.503, 0.577> 
		<4.406, 2.577, 0.782> <4.418, 2.580, 0.710> <4.421, 2.523, 0.646> <4.412, 2.450, 0.641> 
		<4.690, 2.537, 0.830> <4.703, 2.541, 0.758> <4.706, 2.483, 0.694> <4.697, 2.411, 0.689> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.748, 2.542, 0.529> <3.738, 2.470, 0.524> <3.720, 2.407, 0.580> <3.708, 2.403, 0.652> 
		<4.032, 2.503, 0.577> <4.023, 2.431, 0.572> <4.005, 2.367, 0.628> <3.992, 2.364, 0.700> 
		<4.412, 2.450, 0.641> <4.403, 2.378, 0.636> <4.385, 2.315, 0.691> <4.372, 2.311, 0.763> 
		<4.697, 2.411, 0.689> <4.688, 2.339, 0.683> <4.669, 2.275, 0.739> <4.657, 2.272, 0.811> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.657, 2.272, 0.811> <4.644, 2.268, 0.883> <4.641, 2.325, 0.948> <4.651, 2.398, 0.953> 
		<4.372, 2.311, 0.763> <4.360, 2.308, 0.835> <4.357, 2.365, 0.900> <4.366, 2.437, 0.905> 
		<3.992, 2.364, 0.700> <3.980, 2.360, 0.772> <3.977, 2.418, 0.836> <3.986, 2.490, 0.841> 
		<3.708, 2.403, 0.652> <3.695, 2.400, 0.724> <3.692, 2.457, 0.788> <3.701, 2.529, 0.793> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.322, 2.462, 0.795> <4.324, 2.479, 0.796> <4.328, 2.495, 0.783> <4.331, 2.495, 0.765> 
		<4.607, 2.422, 0.843> <4.609, 2.440, 0.844> <4.613, 2.455, 0.830> <4.616, 2.456, 0.813> 
		<4.986, 2.370, 0.906> <4.988, 2.387, 0.908> <4.993, 2.402, 0.894> <4.996, 2.403, 0.877> 
		<5.271, 2.330, 0.954> <5.273, 2.348, 0.955> <5.278, 2.363, 0.942> <5.281, 2.364, 0.925> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.331, 2.495, 0.765> <4.334, 2.496, 0.748> <4.335, 2.482, 0.733> <4.333, 2.465, 0.731> 
		<4.616, 2.456, 0.813> <4.619, 2.457, 0.796> <4.620, 2.443, 0.780> <4.618, 2.426, 0.779> 
		<4.996, 2.403, 0.877> <4.999, 2.404, 0.860> <4.999, 2.390, 0.844> <4.997, 2.373, 0.843> 
		<5.281, 2.364, 0.925> <5.284, 2.365, 0.907> <5.284, 2.351, 0.892> <5.282, 2.334, 0.891> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.333, 2.465, 0.731> <4.331, 2.448, 0.730> <4.326, 2.432, 0.744> <4.323, 2.432, 0.761> 
		<4.618, 2.426, 0.779> <4.615, 2.408, 0.778> <4.611, 2.393, 0.791> <4.608, 2.392, 0.809> 
		<4.997, 2.373, 0.843> <4.995, 2.356, 0.842> <4.991, 2.340, 0.855> <4.988, 2.340, 0.872> 
		<5.282, 2.334, 0.891> <5.280, 2.316, 0.889> <5.275, 2.301, 0.903> <5.272, 2.300, 0.920> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.272, 2.300, 0.920> <5.269, 2.299, 0.937> <5.269, 2.313, 0.953> <5.271, 2.330, 0.954> 
		<4.988, 2.340, 0.872> <4.985, 2.339, 0.890> <4.984, 2.352, 0.905> <4.986, 2.370, 0.906> 
		<4.608, 2.392, 0.809> <4.605, 2.391, 0.826> <4.604, 2.405, 0.841> <4.607, 2.422, 0.843> 
		<4.323, 2.432, 0.761> <4.320, 2.431, 0.778> <4.320, 2.445, 0.794> <4.322, 2.462, 0.795> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.745, 2.354, 0.831> <4.742, 2.345, 0.830> <4.744, 2.329, 0.829> <4.735, 2.325, 0.827> 
		<4.747, 2.355, 0.817> <4.744, 2.346, 0.816> <4.747, 2.330, 0.808> <4.739, 2.326, 0.806> 
		<4.752, 2.364, 0.798> <4.750, 2.358, 0.791> <4.753, 2.341, 0.784> <4.745, 2.339, 0.779> 
		<4.755, 2.374, 0.789> <4.753, 2.369, 0.782> <4.757, 2.357, 0.770> <4.750, 2.355, 0.765> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.735, 2.325, 0.827> <4.718, 2.317, 0.824> <4.690, 2.313, 0.819> <4.673, 2.321, 0.816> 
		<4.739, 2.326, 0.806> <4.722, 2.318, 0.803> <4.694, 2.314, 0.795> <4.677, 2.322, 0.793> 
		<4.745, 2.339, 0.779> <4.730, 2.334, 0.768> <4.702, 2.331, 0.760> <4.685, 2.337, 0.761> 
		<4.750, 2.355, 0.765> <4.734, 2.350, 0.755> <4.708, 2.349, 0.744> <4.690, 2.355, 0.745> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.673, 2.321, 0.816> <4.664, 2.325, 0.815> <4.659, 2.351, 0.815> <4.668, 2.356, 0.817> 
		<4.677, 2.322, 0.793> <4.668, 2.326, 0.791> <4.662, 2.352, 0.799> <4.671, 2.356, 0.801> 
		<4.685, 2.337, 0.761> <4.675, 2.341, 0.762> <4.668, 2.364, 0.774> <4.676, 2.367, 0.780> 
		<4.690, 2.355, 0.745> <4.680, 2.358, 0.746> <4.671, 2.376, 0.763> <4.679, 2.379, 0.769> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.668, 2.356, 0.817> <4.688, 2.366, 0.821> <4.720, 2.357, 0.826> <4.742, 2.358, 0.830> 
		<4.671, 2.356, 0.801> <4.691, 2.367, 0.805> <4.722, 2.358, 0.813> <4.745, 2.359, 0.817> 
		<4.676, 2.367, 0.780> <4.694, 2.373, 0.793> <4.727, 2.368, 0.793> <4.749, 2.367, 0.799> 
		<4.679, 2.379, 0.769> <4.697, 2.385, 0.782> <4.730, 2.377, 0.784> <4.752, 2.377, 0.791> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.740, 2.370, 0.875> <4.736, 2.364, 0.881> <4.736, 2.351, 0.892> <4.727, 2.348, 0.894> 
		<4.740, 2.361, 0.864> <4.736, 2.354, 0.870> <4.737, 2.337, 0.876> <4.728, 2.334, 0.878> 
		<4.743, 2.354, 0.845> <4.740, 2.345, 0.844> <4.740, 2.327, 0.850> <4.731, 2.324, 0.848> 
		<4.745, 2.354, 0.831> <4.742, 2.345, 0.830> <4.744, 2.329, 0.829> <4.735, 2.325, 0.827> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.727, 2.348, 0.894> <4.709, 2.343, 0.898> <4.681, 2.341, 0.898> <4.664, 2.348, 0.892> 
		<4.728, 2.334, 0.878> <4.710, 2.329, 0.882> <4.681, 2.325, 0.880> <4.665, 2.332, 0.874> 
		<4.731, 2.324, 0.848> <4.715, 2.316, 0.845> <4.686, 2.312, 0.843> <4.669, 2.320, 0.840> 
		<4.735, 2.325, 0.827> <4.718, 2.317, 0.824> <4.690, 2.313, 0.819> <4.673, 2.321, 0.816> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.664, 2.348, 0.892> <4.655, 2.351, 0.888> <4.652, 2.370, 0.871> <4.662, 2.374, 0.868> 
		<4.665, 2.332, 0.874> <4.656, 2.335, 0.870> <4.653, 2.360, 0.859> <4.663, 2.363, 0.856> 
		<4.669, 2.320, 0.840> <4.659, 2.324, 0.839> <4.656, 2.350, 0.832> <4.665, 2.355, 0.833> 
		<4.673, 2.321, 0.816> <4.664, 2.325, 0.815> <4.659, 2.351, 0.815> <4.668, 2.356, 0.817> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.662, 2.374, 0.868> <4.683, 2.381, 0.863> <4.715, 2.373, 0.871> <4.737, 2.373, 0.873> 
		<4.663, 2.363, 0.856> <4.683, 2.370, 0.851> <4.715, 2.364, 0.861> <4.738, 2.364, 0.862> 
		<4.665, 2.355, 0.833> <4.685, 2.365, 0.837> <4.718, 2.357, 0.840> <4.740, 2.357, 0.844> 
		<4.668, 2.356, 0.817> <4.688, 2.366, 0.821> <4.720, 2.357, 0.826> <4.742, 2.358, 0.830> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.742, 2.413, 0.896> <4.739, 2.412, 0.905> <4.739, 2.411, 0.922> <4.731, 2.412, 0.925> 
		<4.740, 2.399, 0.895> <4.737, 2.398, 0.904> <4.737, 2.390, 0.920> <4.728, 2.391, 0.924> 
		<4.739, 2.380, 0.886> <4.735, 2.373, 0.891> <4.735, 2.365, 0.908> <4.726, 2.362, 0.910> 
		<4.740, 2.370, 0.875> <4.736, 2.364, 0.881> <4.736, 2.351, 0.892> <4.727, 2.348, 0.894> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.731, 2.412, 0.925> <4.713, 2.414, 0.933> <4.685, 2.417, 0.936> <4.668, 2.420, 0.927> 
		<4.728, 2.391, 0.924> <4.711, 2.393, 0.931> <4.682, 2.393, 0.934> <4.665, 2.396, 0.926> 
		<4.726, 2.362, 0.910> <4.709, 2.357, 0.914> <4.680, 2.357, 0.916> <4.663, 2.364, 0.910> 
		<4.727, 2.348, 0.894> <4.709, 2.343, 0.898> <4.681, 2.341, 0.898> <4.664, 2.348, 0.892> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.668, 2.420, 0.927> <4.659, 2.421, 0.923> <4.655, 2.424, 0.897> <4.665, 2.423, 0.892> 
		<4.665, 2.396, 0.926> <4.656, 2.397, 0.921> <4.653, 2.407, 0.896> <4.663, 2.406, 0.891> 
		<4.663, 2.364, 0.910> <4.654, 2.367, 0.906> <4.652, 2.381, 0.883> <4.662, 2.385, 0.881> 
		<4.664, 2.348, 0.892> <4.655, 2.351, 0.888> <4.652, 2.370, 0.871> <4.662, 2.374, 0.868> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.665, 2.423, 0.892> <4.685, 2.421, 0.882> <4.717, 2.416, 0.892> <4.740, 2.413, 0.892> 
		<4.663, 2.406, 0.891> <4.683, 2.405, 0.881> <4.715, 2.403, 0.891> <4.738, 2.400, 0.891> 
		<4.662, 2.385, 0.881> <4.682, 2.392, 0.875> <4.714, 2.382, 0.881> <4.737, 2.382, 0.883> 
		<4.662, 2.374, 0.868> <4.683, 2.381, 0.863> <4.715, 2.373, 0.871> <4.737, 2.373, 0.873> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.751, 2.457, 0.881> <4.749, 2.463, 0.888> <4.752, 2.474, 0.901> <4.744, 2.478, 0.903> 
		<4.748, 2.446, 0.890> <4.746, 2.453, 0.897> <4.747, 2.458, 0.915> <4.739, 2.463, 0.917> 
		<4.744, 2.427, 0.897> <4.740, 2.426, 0.906> <4.742, 2.432, 0.923> <4.733, 2.433, 0.927> 
		<4.742, 2.413, 0.896> <4.739, 2.412, 0.905> <4.739, 2.411, 0.922> <4.731, 2.412, 0.925> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.744, 2.478, 0.903> <4.728, 2.487, 0.908> <4.700, 2.496, 0.909> <4.683, 2.495, 0.902> 
		<4.739, 2.463, 0.917> <4.723, 2.472, 0.922> <4.695, 2.478, 0.925> <4.678, 2.477, 0.918> 
		<4.733, 2.433, 0.927> <4.716, 2.435, 0.934> <4.688, 2.441, 0.938> <4.671, 2.444, 0.929> 
		<4.731, 2.412, 0.925> <4.713, 2.414, 0.933> <4.685, 2.417, 0.936> <4.668, 2.420, 0.927> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.683, 2.495, 0.902> <4.673, 2.494, 0.898> <4.666, 2.479, 0.879> <4.675, 2.473, 0.875> 
		<4.678, 2.477, 0.918> <4.668, 2.476, 0.914> <4.663, 2.467, 0.889> <4.671, 2.461, 0.886> 
		<4.671, 2.444, 0.929> <4.662, 2.445, 0.924> <4.657, 2.440, 0.898> <4.667, 2.439, 0.894> 
		<4.668, 2.420, 0.927> <4.659, 2.421, 0.923> <4.655, 2.424, 0.897> <4.665, 2.423, 0.892> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.675, 2.473, 0.875> <4.693, 2.462, 0.869> <4.726, 2.461, 0.878> <4.748, 2.455, 0.878> 
		<4.671, 2.461, 0.886> <4.690, 2.450, 0.879> <4.723, 2.451, 0.886> <4.745, 2.445, 0.887> 
		<4.667, 2.439, 0.894> <4.687, 2.437, 0.884> <4.719, 2.429, 0.893> <4.741, 2.427, 0.893> 
		<4.665, 2.423, 0.892> <4.685, 2.421, 0.882> <4.717, 2.416, 0.892> <4.740, 2.413, 0.892> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.760, 2.477, 0.839> <4.760, 2.486, 0.840> <4.765, 2.502, 0.842> <4.758, 2.508, 0.841> 
		<4.758, 2.476, 0.853> <4.757, 2.486, 0.854> <4.762, 2.501, 0.863> <4.755, 2.507, 0.862> 
		<4.754, 2.467, 0.872> <4.752, 2.474, 0.879> <4.756, 2.489, 0.887> <4.748, 2.494, 0.890> 
		<4.751, 2.457, 0.881> <4.749, 2.463, 0.888> <4.752, 2.474, 0.901> <4.744, 2.478, 0.903> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.758, 2.508, 0.841> <4.744, 2.521, 0.839> <4.718, 2.532, 0.835> <4.699, 2.529, 0.831> 
		<4.755, 2.507, 0.862> <4.740, 2.520, 0.860> <4.714, 2.531, 0.858> <4.695, 2.528, 0.855> 
		<4.748, 2.494, 0.890> <4.732, 2.503, 0.894> <4.705, 2.514, 0.894> <4.688, 2.513, 0.887> 
		<4.744, 2.478, 0.903> <4.728, 2.487, 0.908> <4.700, 2.496, 0.909> <4.683, 2.495, 0.902> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.699, 2.529, 0.831> <4.689, 2.527, 0.829> <4.678, 2.504, 0.826> <4.686, 2.497, 0.827> 
		<4.695, 2.528, 0.855> <4.685, 2.526, 0.853> <4.676, 2.503, 0.842> <4.683, 2.496, 0.843> 
		<4.688, 2.513, 0.887> <4.678, 2.512, 0.883> <4.670, 2.491, 0.868> <4.678, 2.485, 0.865> 
		<4.683, 2.495, 0.902> <4.673, 2.494, 0.898> <4.666, 2.479, 0.879> <4.675, 2.473, 0.875> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.686, 2.497, 0.827> <4.702, 2.481, 0.829> <4.736, 2.481, 0.835> <4.757, 2.474, 0.839> 
		<4.683, 2.496, 0.843> <4.700, 2.480, 0.846> <4.733, 2.480, 0.849> <4.755, 2.474, 0.852> 
		<4.678, 2.485, 0.865> <4.697, 2.474, 0.858> <4.729, 2.471, 0.869> <4.751, 2.465, 0.870> 
		<4.675, 2.473, 0.875> <4.693, 2.462, 0.869> <4.726, 2.461, 0.878> <4.748, 2.455, 0.878> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.766, 2.461, 0.795> <4.766, 2.468, 0.789> <4.773, 2.480, 0.779> <4.766, 2.485, 0.774> 
		<4.765, 2.471, 0.806> <4.765, 2.478, 0.799> <4.772, 2.494, 0.795> <4.765, 2.499, 0.790> 
		<4.763, 2.478, 0.825> <4.762, 2.487, 0.826> <4.769, 2.503, 0.821> <4.762, 2.509, 0.820> 
		<4.760, 2.477, 0.839> <4.760, 2.486, 0.840> <4.765, 2.502, 0.842> <4.758, 2.508, 0.841> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.766, 2.485, 0.774> <4.753, 2.494, 0.765> <4.727, 2.504, 0.755> <4.708, 2.502, 0.756> 
		<4.765, 2.499, 0.790> <4.752, 2.508, 0.781> <4.726, 2.520, 0.773> <4.708, 2.518, 0.774> 
		<4.762, 2.509, 0.820> <4.748, 2.522, 0.818> <4.722, 2.533, 0.811> <4.704, 2.530, 0.808> 
		<4.758, 2.508, 0.841> <4.744, 2.521, 0.839> <4.718, 2.532, 0.835> <4.699, 2.529, 0.831> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.708, 2.502, 0.756> <4.698, 2.501, 0.756> <4.685, 2.484, 0.771> <4.692, 2.478, 0.776> 
		<4.708, 2.518, 0.774> <4.697, 2.517, 0.774> <4.684, 2.495, 0.783> <4.692, 2.489, 0.789> 
		<4.704, 2.530, 0.808> <4.693, 2.529, 0.806> <4.681, 2.505, 0.810> <4.689, 2.497, 0.811> 
		<4.699, 2.529, 0.831> <4.689, 2.527, 0.829> <4.678, 2.504, 0.826> <4.686, 2.497, 0.827> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.692, 2.478, 0.776> <4.707, 2.466, 0.788> <4.741, 2.465, 0.791> <4.762, 2.459, 0.797> 
		<4.692, 2.489, 0.789> <4.707, 2.477, 0.800> <4.741, 2.474, 0.801> <4.762, 2.468, 0.807> 
		<4.689, 2.497, 0.811> <4.705, 2.482, 0.813> <4.738, 2.482, 0.822> <4.759, 2.475, 0.825> 
		<4.686, 2.497, 0.827> <4.702, 2.481, 0.829> <4.736, 2.481, 0.835> <4.757, 2.474, 0.839> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.763, 2.419, 0.774> <4.763, 2.419, 0.765> <4.770, 2.420, 0.749> <4.763, 2.421, 0.743> 
		<4.765, 2.433, 0.775> <4.765, 2.433, 0.766> <4.772, 2.441, 0.750> <4.765, 2.442, 0.744> 
		<4.766, 2.452, 0.784> <4.766, 2.459, 0.778> <4.774, 2.466, 0.763> <4.767, 2.470, 0.758> 
		<4.766, 2.461, 0.795> <4.766, 2.468, 0.789> <4.773, 2.480, 0.779> <4.766, 2.485, 0.774> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.763, 2.421, 0.743> <4.749, 2.424, 0.730> <4.723, 2.428, 0.718> <4.704, 2.430, 0.720> 
		<4.765, 2.442, 0.744> <4.751, 2.445, 0.732> <4.726, 2.452, 0.720> <4.707, 2.454, 0.722> 
		<4.767, 2.470, 0.758> <4.753, 2.480, 0.749> <4.728, 2.488, 0.737> <4.709, 2.486, 0.738> 
		<4.766, 2.485, 0.774> <4.753, 2.494, 0.765> <4.727, 2.504, 0.755> <4.708, 2.502, 0.756> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.704, 2.430, 0.720> <4.694, 2.431, 0.722> <4.682, 2.431, 0.745> <4.689, 2.430, 0.752> 
		<4.707, 2.454, 0.722> <4.697, 2.455, 0.723> <4.684, 2.447, 0.746> <4.691, 2.446, 0.753> 
		<4.709, 2.486, 0.738> <4.699, 2.485, 0.738> <4.685, 2.473, 0.759> <4.693, 2.468, 0.764> 
		<4.708, 2.502, 0.756> <4.698, 2.501, 0.756> <4.685, 2.484, 0.771> <4.692, 2.478, 0.776> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.689, 2.430, 0.752> <4.705, 2.426, 0.768> <4.739, 2.422, 0.769> <4.760, 2.419, 0.777> 
		<4.691, 2.446, 0.753> <4.707, 2.443, 0.769> <4.740, 2.435, 0.770> <4.762, 2.432, 0.778> 
		<4.693, 2.468, 0.764> <4.708, 2.455, 0.776> <4.742, 2.456, 0.780> <4.763, 2.450, 0.786> 
		<4.692, 2.478, 0.776> <4.707, 2.466, 0.788> <4.741, 2.465, 0.791> <4.762, 2.459, 0.797> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.755, 2.374, 0.789> <4.753, 2.369, 0.782> <4.757, 2.357, 0.770> <4.750, 2.355, 0.765> 
		<4.758, 2.385, 0.780> <4.756, 2.379, 0.772> <4.762, 2.373, 0.756> <4.754, 2.370, 0.751> 
		<4.762, 2.405, 0.773> <4.761, 2.405, 0.764> <4.767, 2.399, 0.747> <4.760, 2.400, 0.741> 
		<4.763, 2.419, 0.774> <4.763, 2.419, 0.765> <4.770, 2.420, 0.749> <4.763, 2.421, 0.743> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.750, 2.355, 0.765> <4.734, 2.350, 0.755> <4.708, 2.349, 0.744> <4.690, 2.355, 0.745> 
		<4.754, 2.370, 0.751> <4.739, 2.366, 0.741> <4.713, 2.366, 0.729> <4.695, 2.373, 0.730> 
		<4.760, 2.400, 0.741> <4.746, 2.403, 0.729> <4.720, 2.404, 0.716> <4.701, 2.406, 0.719> 
		<4.763, 2.421, 0.743> <4.749, 2.424, 0.730> <4.723, 2.428, 0.718> <4.704, 2.430, 0.720> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.690, 2.355, 0.745> <4.680, 2.358, 0.746> <4.671, 2.376, 0.763> <4.679, 2.379, 0.769> 
		<4.695, 2.373, 0.730> <4.685, 2.376, 0.730> <4.675, 2.388, 0.753> <4.683, 2.391, 0.759> 
		<4.701, 2.406, 0.719> <4.691, 2.407, 0.720> <4.680, 2.415, 0.744> <4.687, 2.413, 0.751> 
		<4.704, 2.430, 0.720> <4.694, 2.431, 0.722> <4.682, 2.431, 0.745> <4.689, 2.430, 0.752> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.679, 2.379, 0.769> <4.697, 2.385, 0.782> <4.730, 2.377, 0.784> <4.752, 2.377, 0.791> 
		<4.683, 2.391, 0.759> <4.700, 2.397, 0.772> <4.733, 2.387, 0.776> <4.754, 2.387, 0.782> 
		<4.687, 2.413, 0.751> <4.703, 2.410, 0.767> <4.737, 2.409, 0.768> <4.758, 2.406, 0.776> 
		<4.689, 2.430, 0.752> <4.705, 2.426, 0.768> <4.739, 2.422, 0.769> <4.760, 2.419, 0.777> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.335, 2.264, 0.890> <5.333, 2.255, 0.891> <5.332, 2.239, 0.886> <5.330, 2.233, 0.894> 
		<5.321, 2.266, 0.888> <5.319, 2.257, 0.889> <5.311, 2.242, 0.883> <5.309, 2.236, 0.891> 
		<5.303, 2.277, 0.886> <5.295, 2.271, 0.886> <5.287, 2.256, 0.880> <5.282, 2.252, 0.887> 
		<5.294, 2.288, 0.885> <5.287, 2.283, 0.885> <5.274, 2.273, 0.879> <5.269, 2.269, 0.886> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.330, 2.233, 0.894> <5.326, 2.223, 0.909> <5.321, 2.214, 0.936> <5.319, 2.218, 0.954> 
		<5.309, 2.236, 0.891> <5.305, 2.225, 0.906> <5.297, 2.217, 0.932> <5.295, 2.221, 0.950> 
		<5.282, 2.252, 0.887> <5.271, 2.245, 0.901> <5.263, 2.237, 0.928> <5.264, 2.239, 0.947> 
		<5.269, 2.269, 0.886> <5.259, 2.262, 0.900> <5.248, 2.256, 0.927> <5.250, 2.259, 0.945> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.319, 2.218, 0.954> <5.318, 2.221, 0.964> <5.320, 2.245, 0.974> <5.322, 2.251, 0.966> 
		<5.295, 2.221, 0.950> <5.294, 2.224, 0.961> <5.303, 2.247, 0.971> <5.306, 2.253, 0.963> 
		<5.264, 2.239, 0.947> <5.265, 2.241, 0.957> <5.279, 2.262, 0.968> <5.285, 2.266, 0.961> 
		<5.250, 2.259, 0.945> <5.251, 2.260, 0.956> <5.269, 2.275, 0.967> <5.275, 2.279, 0.960> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.322, 2.251, 0.966> <5.326, 2.265, 0.948> <5.331, 2.262, 0.915> <5.335, 2.267, 0.893> 
		<5.306, 2.253, 0.963> <5.310, 2.267, 0.946> <5.318, 2.264, 0.913> <5.321, 2.269, 0.891> 
		<5.285, 2.266, 0.961> <5.298, 2.275, 0.944> <5.298, 2.276, 0.910> <5.304, 2.279, 0.889> 
		<5.275, 2.279, 0.960> <5.288, 2.288, 0.944> <5.290, 2.287, 0.910> <5.296, 2.290, 0.888> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.380, 2.276, 0.898> <5.385, 2.269, 0.900> <5.396, 2.256, 0.897> <5.398, 2.252, 0.905> 
		<5.369, 2.268, 0.895> <5.374, 2.260, 0.898> <5.379, 2.243, 0.894> <5.381, 2.239, 0.902> 
		<5.349, 2.262, 0.892> <5.347, 2.253, 0.893> <5.353, 2.236, 0.889> <5.351, 2.231, 0.897> 
		<5.335, 2.264, 0.890> <5.333, 2.255, 0.891> <5.332, 2.239, 0.886> <5.330, 2.233, 0.894> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.398, 2.252, 0.905> <5.401, 2.243, 0.922> <5.402, 2.235, 0.950> <5.396, 2.239, 0.967> 
		<5.381, 2.239, 0.902> <5.385, 2.230, 0.918> <5.383, 2.220, 0.946> <5.377, 2.224, 0.963> 
		<5.351, 2.231, 0.897> <5.347, 2.220, 0.912> <5.345, 2.210, 0.939> <5.342, 2.215, 0.958> 
		<5.330, 2.233, 0.894> <5.326, 2.223, 0.909> <5.321, 2.214, 0.936> <5.319, 2.218, 0.954> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.396, 2.239, 0.967> <5.392, 2.240, 0.977> <5.376, 2.260, 0.983> <5.374, 2.265, 0.974> 
		<5.377, 2.224, 0.963> <5.373, 2.226, 0.973> <5.363, 2.250, 0.981> <5.361, 2.255, 0.972> 
		<5.342, 2.215, 0.958> <5.341, 2.217, 0.968> <5.336, 2.243, 0.976> <5.338, 2.249, 0.968> 
		<5.319, 2.218, 0.954> <5.318, 2.221, 0.964> <5.320, 2.245, 0.974> <5.322, 2.251, 0.966> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.374, 2.265, 0.974> <5.368, 2.277, 0.956> <5.376, 2.275, 0.923> <5.378, 2.279, 0.901> 
		<5.361, 2.255, 0.972> <5.356, 2.267, 0.953> <5.366, 2.266, 0.921> <5.367, 2.271, 0.898> 
		<5.338, 2.249, 0.968> <5.342, 2.263, 0.951> <5.344, 2.261, 0.917> <5.348, 2.265, 0.895> 
		<5.322, 2.251, 0.966> <5.326, 2.265, 0.948> <5.331, 2.262, 0.915> <5.335, 2.267, 0.893> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.403, 2.317, 0.903> <5.412, 2.316, 0.907> <5.429, 2.314, 0.905> <5.433, 2.313, 0.914> 
		<5.401, 2.303, 0.902> <5.410, 2.302, 0.906> <5.426, 2.293, 0.904> <5.430, 2.292, 0.913> 
		<5.391, 2.285, 0.900> <5.396, 2.278, 0.902> <5.413, 2.269, 0.901> <5.414, 2.264, 0.909> 
		<5.380, 2.276, 0.898> <5.385, 2.269, 0.900> <5.396, 2.256, 0.897> <5.398, 2.252, 0.905> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.433, 2.313, 0.914> <5.440, 2.311, 0.931> <5.443, 2.308, 0.960> <5.435, 2.308, 0.977> 
		<5.430, 2.292, 0.913> <5.437, 2.290, 0.930> <5.440, 2.284, 0.958> <5.432, 2.284, 0.975> 
		<5.414, 2.264, 0.909> <5.418, 2.256, 0.925> <5.421, 2.250, 0.953> <5.414, 2.253, 0.971> 
		<5.398, 2.252, 0.905> <5.401, 2.243, 0.922> <5.402, 2.235, 0.950> <5.396, 2.239, 0.967> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.435, 2.308, 0.977> <5.431, 2.308, 0.986> <5.405, 2.311, 0.991> <5.400, 2.312, 0.981> 
		<5.432, 2.284, 0.975> <5.427, 2.284, 0.985> <5.403, 2.295, 0.989> <5.398, 2.296, 0.980> 
		<5.414, 2.253, 0.971> <5.411, 2.255, 0.981> <5.389, 2.270, 0.986> <5.386, 2.275, 0.977> 
		<5.396, 2.239, 0.967> <5.392, 2.240, 0.977> <5.376, 2.260, 0.983> <5.374, 2.265, 0.974> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.400, 2.312, 0.981> <5.390, 2.315, 0.961> <5.400, 2.316, 0.929> <5.400, 2.318, 0.906> 
		<5.398, 2.296, 0.980> <5.388, 2.299, 0.960> <5.398, 2.303, 0.928> <5.398, 2.304, 0.905> 
		<5.386, 2.275, 0.977> <5.381, 2.286, 0.958> <5.387, 2.283, 0.925> <5.388, 2.287, 0.903> 
		<5.374, 2.265, 0.974> <5.368, 2.277, 0.956> <5.376, 2.275, 0.923> <5.378, 2.279, 0.901> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.391, 2.363, 0.904> <5.398, 2.369, 0.907> <5.411, 2.379, 0.906> <5.414, 2.381, 0.915> 
		<5.399, 2.352, 0.905> <5.406, 2.357, 0.908> <5.424, 2.362, 0.907> <5.427, 2.365, 0.916> 
		<5.405, 2.331, 0.904> <5.414, 2.330, 0.908> <5.431, 2.335, 0.907> <5.435, 2.334, 0.916> 
		<5.403, 2.317, 0.903> <5.412, 2.316, 0.907> <5.429, 2.314, 0.905> <5.433, 2.313, 0.914> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.414, 2.381, 0.915> <5.420, 2.387, 0.932> <5.421, 2.390, 0.961> <5.414, 2.386, 0.978> 
		<5.427, 2.365, 0.916> <5.432, 2.370, 0.933> <5.436, 2.371, 0.962> <5.429, 2.367, 0.979> 
		<5.435, 2.334, 0.916> <5.443, 2.332, 0.933> <5.446, 2.332, 0.962> <5.438, 2.332, 0.979> 
		<5.433, 2.313, 0.914> <5.440, 2.311, 0.931> <5.443, 2.308, 0.960> <5.435, 2.308, 0.977> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.414, 2.386, 0.978> <5.410, 2.383, 0.987> <5.390, 2.368, 0.991> <5.386, 2.365, 0.982> 
		<5.429, 2.367, 0.979> <5.425, 2.364, 0.988> <5.400, 2.355, 0.992> <5.396, 2.352, 0.982> 
		<5.438, 2.332, 0.979> <5.434, 2.332, 0.988> <5.407, 2.327, 0.992> <5.402, 2.328, 0.982> 
		<5.435, 2.308, 0.977> <5.431, 2.308, 0.986> <5.405, 2.311, 0.991> <5.400, 2.312, 0.981> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.386, 2.365, 0.982> <5.379, 2.358, 0.961> <5.387, 2.362, 0.929> <5.388, 2.361, 0.906> 
		<5.396, 2.352, 0.982> <5.389, 2.345, 0.962> <5.396, 2.351, 0.930> <5.396, 2.350, 0.907> 
		<5.402, 2.328, 0.982> <5.392, 2.331, 0.962> <5.402, 2.329, 0.929> <5.401, 2.331, 0.907> 
		<5.400, 2.312, 0.981> <5.390, 2.315, 0.961> <5.400, 2.316, 0.929> <5.400, 2.318, 0.906> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.350, 2.387, 0.899> <5.351, 2.396, 0.901> <5.354, 2.413, 0.899> <5.353, 2.417, 0.907> 
		<5.364, 2.385, 0.901> <5.365, 2.394, 0.903> <5.375, 2.410, 0.902> <5.374, 2.414, 0.910> 
		<5.382, 2.374, 0.903> <5.389, 2.380, 0.906> <5.398, 2.396, 0.905> <5.401, 2.398, 0.914> 
		<5.391, 2.363, 0.904> <5.398, 2.369, 0.907> <5.411, 2.379, 0.906> <5.414, 2.381, 0.915> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.353, 2.417, 0.907> <5.352, 2.426, 0.923> <5.349, 2.433, 0.951> <5.345, 2.426, 0.969> 
		<5.374, 2.414, 0.910> <5.373, 2.424, 0.927> <5.372, 2.429, 0.955> <5.369, 2.423, 0.972> 
		<5.401, 2.398, 0.914> <5.407, 2.404, 0.931> <5.407, 2.409, 0.959> <5.400, 2.405, 0.976> 
		<5.414, 2.381, 0.915> <5.420, 2.387, 0.932> <5.421, 2.390, 0.961> <5.414, 2.386, 0.978> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.345, 2.426, 0.969> <5.343, 2.423, 0.979> <5.339, 2.398, 0.985> <5.339, 2.392, 0.976> 
		<5.369, 2.423, 0.972> <5.367, 2.420, 0.982> <5.355, 2.396, 0.987> <5.355, 2.390, 0.978> 
		<5.400, 2.405, 0.976> <5.396, 2.403, 0.986> <5.380, 2.381, 0.990> <5.376, 2.378, 0.981> 
		<5.414, 2.386, 0.978> <5.410, 2.383, 0.987> <5.390, 2.368, 0.991> <5.386, 2.365, 0.982> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.339, 2.392, 0.976> <5.341, 2.380, 0.957> <5.346, 2.386, 0.924> <5.349, 2.384, 0.902> 
		<5.355, 2.390, 0.978> <5.357, 2.378, 0.959> <5.360, 2.384, 0.926> <5.363, 2.382, 0.903> 
		<5.376, 2.378, 0.981> <5.369, 2.371, 0.961> <5.379, 2.373, 0.928> <5.380, 2.372, 0.906> 
		<5.386, 2.365, 0.982> <5.379, 2.358, 0.961> <5.387, 2.362, 0.929> <5.388, 2.361, 0.906> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.305, 2.375, 0.891> <5.299, 2.382, 0.892> <5.290, 2.396, 0.888> <5.285, 2.399, 0.895> 
		<5.316, 2.383, 0.893> <5.310, 2.391, 0.894> <5.306, 2.408, 0.891> <5.302, 2.412, 0.899> 
		<5.336, 2.389, 0.897> <5.337, 2.398, 0.899> <5.333, 2.415, 0.896> <5.332, 2.420, 0.904> 
		<5.350, 2.387, 0.899> <5.351, 2.396, 0.901> <5.354, 2.413, 0.899> <5.353, 2.417, 0.907> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.285, 2.399, 0.895> <5.277, 2.406, 0.911> <5.268, 2.411, 0.938> <5.268, 2.406, 0.956> 
		<5.302, 2.412, 0.899> <5.293, 2.419, 0.914> <5.287, 2.426, 0.941> <5.287, 2.420, 0.960> 
		<5.332, 2.420, 0.904> <5.331, 2.429, 0.920> <5.325, 2.436, 0.948> <5.321, 2.430, 0.965> 
		<5.353, 2.417, 0.907> <5.352, 2.426, 0.923> <5.349, 2.433, 0.951> <5.345, 2.426, 0.969> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.268, 2.406, 0.956> <5.269, 2.403, 0.966> <5.282, 2.383, 0.975> <5.288, 2.378, 0.967> 
		<5.287, 2.420, 0.960> <5.288, 2.417, 0.970> <5.295, 2.393, 0.978> <5.300, 2.388, 0.969> 
		<5.321, 2.430, 0.965> <5.320, 2.426, 0.975> <5.323, 2.400, 0.982> <5.323, 2.394, 0.973> 
		<5.345, 2.426, 0.969> <5.343, 2.423, 0.979> <5.339, 2.398, 0.985> <5.339, 2.392, 0.976> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.288, 2.378, 0.967> <5.298, 2.369, 0.949> <5.301, 2.374, 0.916> <5.306, 2.372, 0.894> 
		<5.300, 2.388, 0.969> <5.311, 2.379, 0.952> <5.311, 2.382, 0.918> <5.317, 2.380, 0.896> 
		<5.323, 2.394, 0.973> <5.325, 2.382, 0.954> <5.333, 2.388, 0.922> <5.336, 2.386, 0.900> 
		<5.339, 2.392, 0.976> <5.341, 2.380, 0.957> <5.346, 2.386, 0.924> <5.349, 2.384, 0.902> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.282, 2.334, 0.885> <5.272, 2.335, 0.886> <5.257, 2.338, 0.880> <5.251, 2.338, 0.887> 
		<5.284, 2.348, 0.886> <5.274, 2.349, 0.887> <5.259, 2.359, 0.881> <5.253, 2.359, 0.888> 
		<5.294, 2.366, 0.889> <5.288, 2.374, 0.890> <5.273, 2.383, 0.885> <5.269, 2.386, 0.892> 
		<5.305, 2.375, 0.891> <5.299, 2.382, 0.892> <5.290, 2.396, 0.888> <5.285, 2.399, 0.895> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.251, 2.338, 0.887> <5.238, 2.338, 0.901> <5.226, 2.338, 0.927> <5.229, 2.336, 0.946> 
		<5.253, 2.359, 0.888> <5.241, 2.359, 0.903> <5.229, 2.362, 0.929> <5.232, 2.360, 0.948> 
		<5.269, 2.386, 0.892> <5.260, 2.394, 0.907> <5.249, 2.397, 0.934> <5.249, 2.391, 0.952> 
		<5.285, 2.399, 0.895> <5.277, 2.406, 0.911> <5.268, 2.411, 0.938> <5.268, 2.406, 0.956> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.229, 2.336, 0.946> <5.230, 2.335, 0.956> <5.253, 2.332, 0.968> <5.261, 2.331, 0.960> 
		<5.232, 2.360, 0.948> <5.233, 2.359, 0.958> <5.255, 2.348, 0.969> <5.263, 2.347, 0.961> 
		<5.249, 2.391, 0.952> <5.250, 2.388, 0.962> <5.270, 2.373, 0.972> <5.275, 2.368, 0.964> 
		<5.268, 2.406, 0.956> <5.269, 2.403, 0.966> <5.282, 2.383, 0.975> <5.288, 2.378, 0.967> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.261, 2.331, 0.960> <5.276, 2.330, 0.944> <5.277, 2.333, 0.910> <5.284, 2.333, 0.889> 
		<5.263, 2.347, 0.961> <5.279, 2.347, 0.945> <5.279, 2.346, 0.911> <5.286, 2.347, 0.890> 
		<5.275, 2.368, 0.964> <5.286, 2.359, 0.947> <5.290, 2.366, 0.914> <5.296, 2.364, 0.892> 
		<5.288, 2.378, 0.967> <5.298, 2.369, 0.949> <5.301, 2.374, 0.916> <5.306, 2.372, 0.894> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.294, 2.288, 0.885> <5.287, 2.283, 0.885> <5.274, 2.273, 0.879> <5.269, 2.269, 0.886> 
		<5.286, 2.300, 0.884> <5.278, 2.294, 0.884> <5.261, 2.290, 0.878> <5.256, 2.286, 0.885> 
		<5.280, 2.320, 0.884> <5.271, 2.321, 0.885> <5.254, 2.316, 0.878> <5.248, 2.317, 0.885> 
		<5.282, 2.334, 0.885> <5.272, 2.335, 0.886> <5.257, 2.338, 0.880> <5.251, 2.338, 0.887> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.269, 2.269, 0.886> <5.259, 2.262, 0.900> <5.248, 2.256, 0.927> <5.250, 2.259, 0.945> 
		<5.256, 2.286, 0.885> <5.246, 2.279, 0.899> <5.234, 2.275, 0.925> <5.235, 2.278, 0.944> 
		<5.248, 2.317, 0.885> <5.235, 2.317, 0.900> <5.223, 2.314, 0.926> <5.226, 2.312, 0.944> 
		<5.251, 2.338, 0.887> <5.238, 2.338, 0.901> <5.226, 2.338, 0.927> <5.229, 2.336, 0.946> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.250, 2.259, 0.945> <5.251, 2.260, 0.956> <5.269, 2.275, 0.967> <5.275, 2.279, 0.960> 
		<5.235, 2.278, 0.944> <5.236, 2.279, 0.954> <5.259, 2.288, 0.966> <5.265, 2.292, 0.959> 
		<5.226, 2.312, 0.944> <5.227, 2.312, 0.955> <5.251, 2.316, 0.967> <5.259, 2.315, 0.959> 
		<5.229, 2.336, 0.946> <5.230, 2.335, 0.956> <5.253, 2.332, 0.968> <5.261, 2.331, 0.960> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.275, 2.279, 0.960> <5.288, 2.288, 0.944> <5.290, 2.287, 0.910> <5.296, 2.290, 0.888> 
		<5.265, 2.292, 0.959> <5.278, 2.301, 0.943> <5.282, 2.297, 0.909> <5.288, 2.301, 0.888> 
		<5.259, 2.315, 0.959> <5.274, 2.314, 0.943> <5.276, 2.319, 0.909> <5.283, 2.320, 0.888> 
		<5.261, 2.331, 0.960> <5.276, 2.330, 0.944> <5.277, 2.333, 0.910> <5.284, 2.333, 0.889> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.647, 2.487, 0.606> <3.646, 2.478, 0.607> <3.644, 2.462, 0.603> <3.642, 2.456, 0.610> 
		<3.633, 2.489, 0.604> <3.632, 2.480, 0.605> <3.623, 2.465, 0.599> <3.621, 2.459, 0.607> 
		<3.615, 2.500, 0.602> <3.607, 2.494, 0.602> <3.599, 2.478, 0.596> <3.594, 2.475, 0.603> 
		<3.606, 2.511, 0.601> <3.599, 2.505, 0.601> <3.587, 2.495, 0.595> <3.581, 2.492, 0.602> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.642, 2.456, 0.610> <3.638, 2.445, 0.625> <3.633, 2.436, 0.652> <3.631, 2.441, 0.670> 
		<3.621, 2.459, 0.607> <3.618, 2.448, 0.622> <3.610, 2.440, 0.648> <3.607, 2.444, 0.667> 
		<3.594, 2.475, 0.603> <3.584, 2.468, 0.618> <3.575, 2.460, 0.644> <3.577, 2.462, 0.663> 
		<3.581, 2.492, 0.602> <3.571, 2.485, 0.617> <3.561, 2.479, 0.643> <3.562, 2.481, 0.662> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.631, 2.441, 0.670> <3.630, 2.443, 0.680> <3.632, 2.467, 0.690> <3.634, 2.474, 0.682> 
		<3.607, 2.444, 0.667> <3.606, 2.447, 0.677> <3.616, 2.470, 0.687> <3.618, 2.476, 0.679> 
		<3.577, 2.462, 0.663> <3.577, 2.463, 0.673> <3.591, 2.484, 0.684> <3.597, 2.488, 0.677> 
		<3.562, 2.481, 0.662> <3.563, 2.483, 0.672> <3.581, 2.497, 0.683> <3.587, 2.501, 0.676> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.634, 2.474, 0.682> <3.638, 2.488, 0.665> <3.643, 2.485, 0.631> <3.647, 2.490, 0.609> 
		<3.618, 2.476, 0.679> <3.622, 2.490, 0.662> <3.630, 2.487, 0.629> <3.634, 2.492, 0.607> 
		<3.597, 2.488, 0.677> <3.610, 2.497, 0.661> <3.610, 2.499, 0.627> <3.617, 2.502, 0.605> 
		<3.587, 2.501, 0.676> <3.600, 2.510, 0.660> <3.602, 2.509, 0.626> <3.608, 2.513, 0.605> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.692, 2.499, 0.614> <3.698, 2.492, 0.616> <3.708, 2.479, 0.613> <3.710, 2.474, 0.622> 
		<3.681, 2.491, 0.612> <3.686, 2.483, 0.614> <3.691, 2.466, 0.610> <3.693, 2.461, 0.618> 
		<3.661, 2.485, 0.608> <3.660, 2.476, 0.609> <3.665, 2.459, 0.606> <3.663, 2.453, 0.613> 
		<3.647, 2.487, 0.606> <3.646, 2.478, 0.607> <3.644, 2.462, 0.603> <3.642, 2.456, 0.610> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.710, 2.474, 0.622> <3.714, 2.465, 0.638> <3.714, 2.458, 0.666> <3.708, 2.461, 0.683> 
		<3.693, 2.461, 0.618> <3.697, 2.452, 0.635> <3.695, 2.443, 0.662> <3.689, 2.447, 0.680> 
		<3.663, 2.453, 0.613> <3.659, 2.442, 0.628> <3.657, 2.433, 0.656> <3.655, 2.438, 0.674> 
		<3.642, 2.456, 0.610> <3.638, 2.445, 0.625> <3.633, 2.436, 0.652> <3.631, 2.441, 0.670> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.708, 2.461, 0.683> <3.704, 2.463, 0.693> <3.688, 2.483, 0.700> <3.686, 2.488, 0.691> 
		<3.689, 2.447, 0.680> <3.686, 2.449, 0.689> <3.675, 2.473, 0.697> <3.673, 2.478, 0.688> 
		<3.655, 2.438, 0.674> <3.654, 2.440, 0.684> <3.648, 2.465, 0.692> <3.650, 2.472, 0.684> 
		<3.631, 2.441, 0.670> <3.630, 2.443, 0.680> <3.632, 2.467, 0.690> <3.634, 2.474, 0.682> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.686, 2.488, 0.691> <3.681, 2.499, 0.672> <3.689, 2.497, 0.639> <3.690, 2.502, 0.617> 
		<3.673, 2.478, 0.688> <3.668, 2.489, 0.669> <3.678, 2.489, 0.637> <3.679, 2.493, 0.615> 
		<3.650, 2.472, 0.684> <3.654, 2.486, 0.667> <3.656, 2.483, 0.633> <3.660, 2.488, 0.611> 
		<3.634, 2.474, 0.682> <3.638, 2.488, 0.665> <3.643, 2.485, 0.631> <3.647, 2.490, 0.609> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.715, 2.540, 0.620> <3.724, 2.539, 0.623> <3.741, 2.537, 0.622> <3.745, 2.536, 0.630> 
		<3.714, 2.526, 0.619> <3.723, 2.525, 0.622> <3.738, 2.516, 0.620> <3.742, 2.515, 0.629> 
		<3.703, 2.508, 0.616> <3.709, 2.500, 0.618> <3.725, 2.492, 0.617> <3.727, 2.487, 0.625> 
		<3.692, 2.499, 0.614> <3.698, 2.492, 0.616> <3.708, 2.479, 0.613> <3.710, 2.474, 0.622> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.745, 2.536, 0.630> <3.752, 2.533, 0.648> <3.756, 2.531, 0.676> <3.747, 2.531, 0.693> 
		<3.742, 2.515, 0.629> <3.750, 2.512, 0.646> <3.753, 2.507, 0.674> <3.744, 2.507, 0.691> 
		<3.727, 2.487, 0.625> <3.730, 2.478, 0.641> <3.733, 2.472, 0.669> <3.727, 2.476, 0.687> 
		<3.710, 2.474, 0.622> <3.714, 2.465, 0.638> <3.714, 2.458, 0.666> <3.708, 2.461, 0.683> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.747, 2.531, 0.693> <3.743, 2.531, 0.703> <3.717, 2.534, 0.707> <3.713, 2.535, 0.697> 
		<3.744, 2.507, 0.691> <3.740, 2.507, 0.701> <3.715, 2.517, 0.706> <3.711, 2.519, 0.696> 
		<3.727, 2.476, 0.687> <3.723, 2.478, 0.697> <3.701, 2.492, 0.702> <3.699, 2.498, 0.693> 
		<3.708, 2.461, 0.683> <3.704, 2.463, 0.693> <3.688, 2.483, 0.700> <3.686, 2.488, 0.691> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.713, 2.535, 0.697> <3.703, 2.538, 0.677> <3.712, 2.539, 0.645> <3.712, 2.540, 0.622> 
		<3.711, 2.519, 0.696> <3.701, 2.521, 0.676> <3.710, 2.525, 0.644> <3.710, 2.527, 0.621> 
		<3.699, 2.498, 0.693> <3.694, 2.509, 0.674> <3.699, 2.506, 0.641> <3.700, 2.510, 0.619> 
		<3.686, 2.488, 0.691> <3.681, 2.499, 0.672> <3.689, 2.497, 0.639> <3.690, 2.502, 0.617> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.703, 2.586, 0.620> <3.710, 2.591, 0.623> <3.724, 2.602, 0.622> <3.726, 2.604, 0.631> 
		<3.712, 2.575, 0.621> <3.719, 2.580, 0.624> <3.737, 2.585, 0.623> <3.739, 2.587, 0.632> 
		<3.717, 2.554, 0.621> <3.726, 2.553, 0.624> <3.744, 2.558, 0.623> <3.748, 2.557, 0.632> 
		<3.715, 2.540, 0.620> <3.724, 2.539, 0.623> <3.741, 2.537, 0.622> <3.745, 2.536, 0.630> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.726, 2.604, 0.631> <3.732, 2.610, 0.648> <3.734, 2.613, 0.677> <3.727, 2.609, 0.694> 
		<3.739, 2.587, 0.632> <3.745, 2.593, 0.649> <3.748, 2.594, 0.678> <3.741, 2.589, 0.695> 
		<3.748, 2.557, 0.632> <3.755, 2.555, 0.649> <3.759, 2.555, 0.678> <3.750, 2.555, 0.695> 
		<3.745, 2.536, 0.630> <3.752, 2.533, 0.648> <3.756, 2.531, 0.676> <3.747, 2.531, 0.693> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.727, 2.609, 0.694> <3.723, 2.606, 0.703> <3.702, 2.591, 0.707> <3.698, 2.588, 0.698> 
		<3.741, 2.589, 0.695> <3.737, 2.587, 0.705> <3.712, 2.578, 0.708> <3.708, 2.575, 0.699> 
		<3.750, 2.555, 0.695> <3.746, 2.555, 0.704> <3.719, 2.550, 0.708> <3.715, 2.551, 0.698> 
		<3.747, 2.531, 0.693> <3.743, 2.531, 0.703> <3.717, 2.534, 0.707> <3.713, 2.535, 0.697> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.698, 2.588, 0.698> <3.691, 2.581, 0.678> <3.700, 2.585, 0.645> <3.700, 2.584, 0.623> 
		<3.708, 2.575, 0.699> <3.701, 2.568, 0.679> <3.708, 2.574, 0.646> <3.708, 2.573, 0.623> 
		<3.715, 2.551, 0.698> <3.705, 2.554, 0.678> <3.714, 2.552, 0.646> <3.714, 2.554, 0.623> 
		<3.713, 2.535, 0.697> <3.703, 2.538, 0.677> <3.712, 2.539, 0.645> <3.712, 2.540, 0.622> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.663, 2.610, 0.615> <3.663, 2.619, 0.617> <3.666, 2.635, 0.615> <3.665, 2.640, 0.623> 
		<3.677, 2.608, 0.617> <3.677, 2.617, 0.619> <3.687, 2.633, 0.618> <3.686, 2.637, 0.626> 
		<3.695, 2.597, 0.619> <3.702, 2.603, 0.623> <3.711, 2.619, 0.621> <3.714, 2.621, 0.630> 
		<3.703, 2.586, 0.620> <3.710, 2.591, 0.623> <3.724, 2.602, 0.622> <3.726, 2.604, 0.631> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.665, 2.640, 0.623> <3.664, 2.649, 0.640> <3.661, 2.655, 0.668> <3.657, 2.649, 0.685> 
		<3.686, 2.637, 0.626> <3.685, 2.646, 0.643> <3.685, 2.652, 0.671> <3.681, 2.646, 0.689> 
		<3.714, 2.621, 0.630> <3.719, 2.627, 0.647> <3.719, 2.632, 0.676> <3.712, 2.628, 0.693> 
		<3.726, 2.604, 0.631> <3.732, 2.610, 0.648> <3.734, 2.613, 0.677> <3.727, 2.609, 0.694> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.657, 2.649, 0.685> <3.656, 2.646, 0.695> <3.651, 2.621, 0.701> <3.652, 2.615, 0.692> 
		<3.681, 2.646, 0.689> <3.679, 2.642, 0.698> <3.667, 2.618, 0.703> <3.668, 2.613, 0.694> 
		<3.712, 2.628, 0.693> <3.708, 2.625, 0.702> <3.692, 2.604, 0.706> <3.689, 2.601, 0.697> 
		<3.727, 2.609, 0.694> <3.723, 2.606, 0.703> <3.702, 2.591, 0.707> <3.698, 2.588, 0.698> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.652, 2.615, 0.692> <3.653, 2.603, 0.673> <3.659, 2.609, 0.640> <3.662, 2.606, 0.618> 
		<3.668, 2.613, 0.694> <3.669, 2.601, 0.675> <3.672, 2.607, 0.642> <3.675, 2.605, 0.620> 
		<3.689, 2.601, 0.697> <3.681, 2.594, 0.677> <3.692, 2.596, 0.644> <3.692, 2.595, 0.622> 
		<3.698, 2.588, 0.698> <3.691, 2.581, 0.678> <3.700, 2.585, 0.645> <3.700, 2.584, 0.623> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.617, 2.598, 0.607> <3.612, 2.605, 0.609> <3.602, 2.618, 0.604> <3.598, 2.622, 0.612> 
		<3.629, 2.606, 0.609> <3.623, 2.614, 0.611> <3.619, 2.631, 0.607> <3.614, 2.635, 0.615> 
		<3.649, 2.612, 0.613> <3.650, 2.621, 0.615> <3.645, 2.638, 0.612> <3.645, 2.643, 0.620> 
		<3.663, 2.610, 0.615> <3.663, 2.619, 0.617> <3.666, 2.635, 0.615> <3.665, 2.640, 0.623> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.598, 2.622, 0.612> <3.589, 2.629, 0.627> <3.580, 2.634, 0.654> <3.581, 2.629, 0.672> 
		<3.614, 2.635, 0.615> <3.606, 2.642, 0.630> <3.599, 2.649, 0.658> <3.600, 2.643, 0.676> 
		<3.645, 2.643, 0.620> <3.643, 2.652, 0.637> <3.637, 2.659, 0.664> <3.634, 2.652, 0.682> 
		<3.665, 2.640, 0.623> <3.664, 2.649, 0.640> <3.661, 2.655, 0.668> <3.657, 2.649, 0.685> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.581, 2.629, 0.672> <3.581, 2.626, 0.682> <3.595, 2.606, 0.691> <3.600, 2.601, 0.683> 
		<3.600, 2.643, 0.676> <3.600, 2.640, 0.686> <3.608, 2.615, 0.694> <3.613, 2.611, 0.686> 
		<3.634, 2.652, 0.682> <3.632, 2.649, 0.691> <3.635, 2.623, 0.698> <3.636, 2.617, 0.689> 
		<3.657, 2.649, 0.685> <3.656, 2.646, 0.695> <3.651, 2.621, 0.701> <3.652, 2.615, 0.692> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.600, 2.601, 0.683> <3.611, 2.592, 0.666> <3.613, 2.597, 0.632> <3.619, 2.595, 0.610> 
		<3.613, 2.611, 0.686> <3.623, 2.601, 0.668> <3.624, 2.605, 0.634> <3.629, 2.603, 0.612> 
		<3.636, 2.617, 0.689> <3.637, 2.605, 0.670> <3.645, 2.611, 0.638> <3.648, 2.608, 0.616> 
		<3.652, 2.615, 0.692> <3.653, 2.603, 0.673> <3.659, 2.609, 0.640> <3.662, 2.606, 0.618> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.594, 2.557, 0.601> <3.585, 2.558, 0.602> <3.569, 2.560, 0.596> <3.563, 2.561, 0.603> 
		<3.596, 2.571, 0.602> <3.587, 2.572, 0.603> <3.572, 2.581, 0.597> <3.566, 2.582, 0.604> 
		<3.606, 2.589, 0.605> <3.600, 2.596, 0.606> <3.585, 2.605, 0.601> <3.581, 2.609, 0.608> 
		<3.617, 2.598, 0.607> <3.612, 2.605, 0.609> <3.602, 2.618, 0.604> <3.598, 2.622, 0.612> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.563, 2.561, 0.603> <3.550, 2.561, 0.617> <3.539, 2.561, 0.644> <3.541, 2.559, 0.662> 
		<3.566, 2.582, 0.604> <3.553, 2.582, 0.619> <3.542, 2.585, 0.645> <3.544, 2.583, 0.664> 
		<3.581, 2.609, 0.608> <3.572, 2.616, 0.624> <3.561, 2.619, 0.650> <3.562, 2.614, 0.668> 
		<3.598, 2.622, 0.612> <3.589, 2.629, 0.627> <3.580, 2.634, 0.654> <3.581, 2.629, 0.672> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.541, 2.559, 0.662> <3.543, 2.558, 0.673> <3.566, 2.554, 0.684> <3.573, 2.554, 0.676> 
		<3.544, 2.583, 0.664> <3.546, 2.582, 0.674> <3.568, 2.571, 0.685> <3.575, 2.570, 0.678> 
		<3.562, 2.614, 0.668> <3.562, 2.611, 0.678> <3.582, 2.596, 0.689> <3.587, 2.591, 0.681> 
		<3.581, 2.629, 0.672> <3.581, 2.626, 0.682> <3.595, 2.606, 0.691> <3.600, 2.601, 0.683> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.573, 2.554, 0.676> <3.589, 2.553, 0.660> <3.590, 2.556, 0.626> <3.597, 2.556, 0.605> 
		<3.575, 2.570, 0.678> <3.591, 2.569, 0.661> <3.591, 2.569, 0.627> <3.598, 2.570, 0.606> 
		<3.587, 2.591, 0.681> <3.598, 2.582, 0.663> <3.603, 2.589, 0.630> <3.608, 2.587, 0.608> 
		<3.600, 2.601, 0.683> <3.611, 2.592, 0.666> <3.613, 2.597, 0.632> <3.619, 2.595, 0.610> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.606, 2.511, 0.601> <3.599, 2.505, 0.601> <3.587, 2.495, 0.595> <3.581, 2.492, 0.602> 
		<3.598, 2.522, 0.600> <3.590, 2.517, 0.601> <3.574, 2.512, 0.594> <3.568, 2.509, 0.601> 
		<3.592, 2.543, 0.600> <3.583, 2.544, 0.601> <3.566, 2.539, 0.594> <3.560, 2.539, 0.601> 
		<3.594, 2.557, 0.601> <3.585, 2.558, 0.602> <3.569, 2.560, 0.596> <3.563, 2.561, 0.603> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.581, 2.492, 0.602> <3.571, 2.485, 0.617> <3.561, 2.479, 0.643> <3.562, 2.481, 0.662> 
		<3.568, 2.509, 0.601> <3.558, 2.502, 0.615> <3.546, 2.498, 0.641> <3.547, 2.501, 0.660> 
		<3.560, 2.539, 0.601> <3.548, 2.540, 0.616> <3.536, 2.537, 0.642> <3.538, 2.535, 0.661> 
		<3.563, 2.561, 0.603> <3.550, 2.561, 0.617> <3.539, 2.561, 0.644> <3.541, 2.559, 0.662> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.562, 2.481, 0.662> <3.563, 2.483, 0.672> <3.581, 2.497, 0.683> <3.587, 2.501, 0.676> 
		<3.547, 2.501, 0.660> <3.548, 2.502, 0.671> <3.571, 2.510, 0.683> <3.577, 2.514, 0.675> 
		<3.538, 2.535, 0.661> <3.540, 2.534, 0.671> <3.564, 2.538, 0.683> <3.571, 2.538, 0.675> 
		<3.541, 2.559, 0.662> <3.543, 2.558, 0.673> <3.566, 2.554, 0.684> <3.573, 2.554, 0.676> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.587, 2.501, 0.676> <3.600, 2.510, 0.660> <3.602, 2.509, 0.626> <3.608, 2.513, 0.605> 
		<3.577, 2.514, 0.675> <3.590, 2.523, 0.659> <3.594, 2.520, 0.625> <3.600, 2.523, 0.604> 
		<3.571, 2.538, 0.675> <3.587, 2.537, 0.659> <3.588, 2.542, 0.625> <3.595, 2.543, 0.604> 
		<3.573, 2.554, 0.676> <3.589, 2.553, 0.660> <3.590, 2.556, 0.626> <3.597, 2.556, 0.605> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.369, 2.195, 1.081> <5.362, 2.194, 1.098> <5.363, 2.193, 1.130> <5.347, 2.190, 1.138> 
		<5.369, 2.170, 1.080> <5.362, 2.169, 1.097> <5.363, 2.156, 1.129> <5.346, 2.152, 1.136> 
		<5.372, 2.137, 1.062> <5.366, 2.124, 1.073> <5.366, 2.112, 1.106> <5.351, 2.102, 1.109> 
		<5.376, 2.121, 1.043> <5.370, 2.108, 1.054> <5.371, 2.088, 1.077> <5.357, 2.079, 1.080> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.347, 2.190, 1.138> <5.317, 2.182, 1.150> <5.267, 2.170, 1.155> <5.240, 2.164, 1.138> 
		<5.346, 2.152, 1.136> <5.317, 2.145, 1.149> <5.267, 2.128, 1.153> <5.239, 2.121, 1.136> 
		<5.351, 2.102, 1.109> <5.323, 2.084, 1.116> <5.275, 2.065, 1.120> <5.245, 2.065, 1.105> 
		<5.357, 2.079, 1.080> <5.329, 2.060, 1.087> <5.281, 2.038, 1.088> <5.251, 2.038, 1.073> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.240, 2.164, 1.138> <5.223, 2.160, 1.127> <5.220, 2.159, 1.079> <5.238, 2.164, 1.070> 
		<5.239, 2.121, 1.136> <5.222, 2.117, 1.125> <5.220, 2.131, 1.077> <5.237, 2.135, 1.068> 
		<5.245, 2.065, 1.105> <5.228, 2.065, 1.097> <5.226, 2.086, 1.052> <5.241, 2.097, 1.048> 
		<5.251, 2.038, 1.073> <5.234, 2.038, 1.065> <5.230, 2.068, 1.030> <5.245, 2.079, 1.026> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.238, 2.164, 1.070> <5.272, 2.172, 1.052> <5.327, 2.185, 1.073> <5.365, 2.194, 1.074> 
		<5.237, 2.135, 1.068> <5.272, 2.143, 1.051> <5.327, 2.161, 1.072> <5.365, 2.171, 1.073> 
		<5.241, 2.097, 1.048> <5.273, 2.120, 1.039> <5.330, 2.125, 1.052> <5.368, 2.139, 1.056> 
		<5.245, 2.079, 1.026> <5.277, 2.102, 1.017> <5.334, 2.111, 1.034> <5.371, 2.124, 1.038> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.376, 2.273, 1.051> <5.371, 2.283, 1.063> <5.374, 2.303, 1.087> <5.358, 2.306, 1.092> 
		<5.373, 2.255, 1.068> <5.367, 2.265, 1.081> <5.368, 2.277, 1.114> <5.352, 2.280, 1.118> 
		<5.369, 2.221, 1.083> <5.362, 2.219, 1.099> <5.363, 2.231, 1.132> <5.347, 2.227, 1.140> 
		<5.369, 2.195, 1.081> <5.362, 2.194, 1.098> <5.363, 2.193, 1.130> <5.347, 2.190, 1.138> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.358, 2.306, 1.092> <5.328, 2.312, 1.100> <5.279, 2.309, 1.099> <5.252, 2.296, 1.086> 
		<5.352, 2.280, 1.118> <5.322, 2.285, 1.127> <5.272, 2.278, 1.129> <5.246, 2.266, 1.116> 
		<5.347, 2.227, 1.140> <5.317, 2.220, 1.152> <5.267, 2.213, 1.157> <5.240, 2.207, 1.140> 
		<5.347, 2.190, 1.138> <5.317, 2.182, 1.150> <5.267, 2.170, 1.155> <5.240, 2.164, 1.138> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.252, 2.296, 1.086> <5.236, 2.288, 1.077> <5.228, 2.258, 1.041> <5.246, 2.253, 1.035> 
		<5.246, 2.266, 1.116> <5.229, 2.258, 1.107> <5.223, 2.237, 1.061> <5.242, 2.233, 1.055> 
		<5.240, 2.207, 1.140> <5.223, 2.203, 1.129> <5.220, 2.188, 1.080> <5.238, 2.193, 1.071> 
		<5.240, 2.164, 1.138> <5.223, 2.160, 1.127> <5.220, 2.159, 1.079> <5.238, 2.164, 1.070> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.246, 2.253, 1.035> <5.282, 2.245, 1.023> <5.334, 2.264, 1.042> <5.372, 2.268, 1.045> 
		<5.242, 2.233, 1.055> <5.277, 2.225, 1.043> <5.331, 2.247, 1.059> <5.369, 2.252, 1.062> 
		<5.238, 2.193, 1.071> <5.272, 2.201, 1.054> <5.327, 2.209, 1.074> <5.365, 2.218, 1.075> 
		<5.238, 2.164, 1.070> <5.272, 2.172, 1.052> <5.327, 2.185, 1.073> <5.365, 2.194, 1.074> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.394, 2.310, 0.969> <5.391, 2.325, 0.970> <5.398, 2.355, 0.973> <5.384, 2.361, 0.970> 
		<5.388, 2.308, 0.996> <5.385, 2.323, 0.996> <5.390, 2.352, 1.013> <5.376, 2.358, 1.010> 
		<5.381, 2.292, 1.032> <5.375, 2.302, 1.044> <5.380, 2.332, 1.059> <5.364, 2.335, 1.064> 
		<5.376, 2.273, 1.051> <5.371, 2.283, 1.063> <5.374, 2.303, 1.087> <5.358, 2.306, 1.092> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.384, 2.361, 0.970> <5.356, 2.373, 0.964> <5.309, 2.373, 0.954> <5.282, 2.358, 0.948> 
		<5.376, 2.358, 1.010> <5.347, 2.371, 1.004> <5.299, 2.370, 0.999> <5.273, 2.355, 0.993> 
		<5.364, 2.335, 1.064> <5.334, 2.341, 1.072> <5.286, 2.341, 1.067> <5.260, 2.329, 1.054> 
		<5.358, 2.306, 1.092> <5.328, 2.312, 1.100> <5.279, 2.309, 1.099> <5.252, 2.296, 1.086> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.282, 2.358, 0.948> <5.265, 2.349, 0.944> <5.249, 2.304, 0.938> <5.266, 2.295, 0.941> 
		<5.273, 2.355, 0.993> <5.256, 2.346, 0.989> <5.243, 2.302, 0.969> <5.260, 2.293, 0.972> 
		<5.260, 2.329, 1.054> <5.243, 2.321, 1.046> <5.232, 2.280, 1.019> <5.251, 2.276, 1.013> 
		<5.252, 2.296, 1.086> <5.236, 2.288, 1.077> <5.228, 2.258, 1.041> <5.246, 2.253, 1.035> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.266, 2.295, 0.941> <5.299, 2.278, 0.947> <5.352, 2.301, 0.960> <5.389, 2.303, 0.968> 
		<5.260, 2.293, 0.972> <5.293, 2.276, 0.978> <5.347, 2.299, 0.985> <5.383, 2.301, 0.993> 
		<5.251, 2.276, 1.013> <5.286, 2.267, 1.001> <5.338, 2.282, 1.024> <5.376, 2.287, 1.027> 
		<5.246, 2.253, 1.035> <5.282, 2.245, 1.023> <5.334, 2.264, 1.042> <5.372, 2.268, 1.045> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.411, 2.283, 0.885> <5.410, 2.294, 0.872> <5.422, 2.317, 0.853> <5.409, 2.321, 0.843> 
		<5.407, 2.300, 0.906> <5.406, 2.311, 0.893> <5.416, 2.342, 0.885> <5.403, 2.346, 0.874> 
		<5.399, 2.311, 0.943> <5.396, 2.326, 0.943> <5.406, 2.357, 0.933> <5.392, 2.363, 0.930> 
		<5.394, 2.310, 0.969> <5.391, 2.325, 0.970> <5.398, 2.355, 0.973> <5.384, 2.361, 0.970> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.409, 2.321, 0.843> <5.385, 2.328, 0.823> <5.340, 2.326, 0.804> <5.311, 2.312, 0.804> 
		<5.403, 2.346, 0.874> <5.379, 2.353, 0.855> <5.333, 2.355, 0.839> <5.304, 2.341, 0.839> 
		<5.392, 2.363, 0.930> <5.364, 2.375, 0.925> <5.318, 2.375, 0.909> <5.291, 2.360, 0.903> 
		<5.384, 2.361, 0.970> <5.356, 2.373, 0.964> <5.309, 2.373, 0.954> <5.282, 2.358, 0.948> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.311, 2.312, 0.804> <5.292, 2.304, 0.804> <5.271, 2.270, 0.831> <5.286, 2.264, 0.844> 
		<5.304, 2.341, 0.839> <5.285, 2.333, 0.839> <5.267, 2.289, 0.855> <5.281, 2.284, 0.868> 
		<5.291, 2.360, 0.903> <5.274, 2.351, 0.899> <5.255, 2.306, 0.907> <5.272, 2.297, 0.911> 
		<5.282, 2.358, 0.948> <5.265, 2.349, 0.944> <5.249, 2.304, 0.938> <5.266, 2.295, 0.941> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.286, 2.264, 0.844> <5.313, 2.254, 0.868> <5.369, 2.274, 0.875> <5.405, 2.278, 0.888> 
		<5.281, 2.284, 0.868> <5.309, 2.274, 0.892> <5.365, 2.290, 0.894> <5.401, 2.294, 0.907> 
		<5.272, 2.297, 0.911> <5.305, 2.280, 0.917> <5.357, 2.302, 0.935> <5.394, 2.304, 0.943> 
		<5.266, 2.295, 0.941> <5.299, 2.278, 0.947> <5.352, 2.301, 0.960> <5.389, 2.303, 0.968> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.417, 2.209, 0.847> <5.418, 2.209, 0.828> <5.431, 2.213, 0.799> <5.419, 2.210, 0.786> 
		<5.417, 2.234, 0.848> <5.418, 2.234, 0.830> <5.431, 2.250, 0.801> <5.419, 2.247, 0.788> 
		<5.414, 2.267, 0.866> <5.414, 2.278, 0.853> <5.428, 2.293, 0.825> <5.415, 2.297, 0.814> 
		<5.411, 2.283, 0.885> <5.410, 2.294, 0.872> <5.422, 2.317, 0.853> <5.409, 2.321, 0.843> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.419, 2.210, 0.786> <5.398, 2.205, 0.761> <5.354, 2.194, 0.735> <5.322, 2.187, 0.739> 
		<5.419, 2.247, 0.788> <5.398, 2.242, 0.763> <5.354, 2.237, 0.738> <5.322, 2.229, 0.741> 
		<5.415, 2.297, 0.814> <5.391, 2.304, 0.795> <5.346, 2.299, 0.771> <5.317, 2.286, 0.771> 
		<5.409, 2.321, 0.843> <5.385, 2.328, 0.823> <5.340, 2.326, 0.804> <5.311, 2.312, 0.804> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.322, 2.187, 0.739> <5.302, 2.182, 0.741> <5.281, 2.176, 0.784> <5.293, 2.179, 0.800> 
		<5.322, 2.229, 0.741> <5.303, 2.224, 0.743> <5.281, 2.205, 0.786> <5.293, 2.208, 0.801> 
		<5.317, 2.286, 0.771> <5.298, 2.277, 0.771> <5.275, 2.252, 0.809> <5.290, 2.246, 0.822> 
		<5.311, 2.312, 0.804> <5.292, 2.304, 0.804> <5.271, 2.270, 0.831> <5.286, 2.264, 0.844> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.293, 2.179, 0.800> <5.318, 2.185, 0.831> <5.376, 2.199, 0.836> <5.411, 2.207, 0.851> 
		<5.293, 2.208, 0.801> <5.318, 2.214, 0.832> <5.376, 2.223, 0.837> <5.411, 2.231, 0.853> 
		<5.290, 2.246, 0.822> <5.317, 2.236, 0.846> <5.372, 2.259, 0.856> <5.408, 2.263, 0.870> 
		<5.286, 2.264, 0.844> <5.313, 2.254, 0.868> <5.369, 2.274, 0.875> <5.405, 2.278, 0.888> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.410, 2.131, 0.877> <5.409, 2.119, 0.863> <5.420, 2.102, 0.841> <5.408, 2.093, 0.831> 
		<5.414, 2.149, 0.860> <5.413, 2.137, 0.846> <5.425, 2.128, 0.815> <5.414, 2.120, 0.805> 
		<5.417, 2.184, 0.845> <5.418, 2.184, 0.827> <5.431, 2.175, 0.797> <5.419, 2.172, 0.784> 
		<5.417, 2.209, 0.847> <5.418, 2.209, 0.828> <5.431, 2.213, 0.799> <5.419, 2.210, 0.786> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.408, 2.093, 0.831> <5.386, 2.076, 0.812> <5.343, 2.055, 0.790> <5.309, 2.054, 0.791> 
		<5.414, 2.120, 0.805> <5.391, 2.102, 0.786> <5.350, 2.085, 0.760> <5.316, 2.084, 0.761> 
		<5.419, 2.172, 0.784> <5.397, 2.167, 0.759> <5.354, 2.152, 0.733> <5.322, 2.144, 0.737> 
		<5.419, 2.210, 0.786> <5.398, 2.205, 0.761> <5.354, 2.194, 0.735> <5.322, 2.187, 0.739> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.309, 2.054, 0.791> <5.291, 2.054, 0.791> <5.273, 2.080, 0.824> <5.285, 2.090, 0.835> 
		<5.316, 2.084, 0.761> <5.297, 2.084, 0.762> <5.278, 2.101, 0.804> <5.289, 2.110, 0.815> 
		<5.322, 2.144, 0.737> <5.302, 2.139, 0.739> <5.281, 2.147, 0.783> <5.293, 2.150, 0.798> 
		<5.322, 2.187, 0.739> <5.302, 2.182, 0.741> <5.281, 2.176, 0.784> <5.293, 2.179, 0.800> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.285, 2.090, 0.835> <5.310, 2.111, 0.859> <5.368, 2.120, 0.867> <5.404, 2.133, 0.880> 
		<5.289, 2.110, 0.815> <5.314, 2.131, 0.839> <5.372, 2.137, 0.850> <5.408, 2.150, 0.864> 
		<5.293, 2.150, 0.798> <5.317, 2.156, 0.829> <5.376, 2.175, 0.835> <5.411, 2.183, 0.850> 
		<5.293, 2.179, 0.800> <5.318, 2.185, 0.831> <5.376, 2.199, 0.836> <5.411, 2.207, 0.851> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.393, 2.095, 0.958> <5.389, 2.078, 0.957> <5.395, 2.050, 0.957> <5.382, 2.038, 0.953> 
		<5.398, 2.096, 0.932> <5.395, 2.079, 0.930> <5.403, 2.052, 0.917> <5.390, 2.041, 0.914> 
		<5.406, 2.112, 0.896> <5.405, 2.100, 0.882> <5.413, 2.073, 0.870> <5.402, 2.064, 0.860> 
		<5.410, 2.131, 0.877> <5.409, 2.119, 0.863> <5.420, 2.102, 0.841> <5.408, 2.093, 0.831> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.382, 2.038, 0.953> <5.357, 2.016, 0.947> <5.313, 1.990, 0.936> <5.280, 1.993, 0.929> 
		<5.390, 2.041, 0.914> <5.365, 2.018, 0.907> <5.323, 1.992, 0.891> <5.289, 1.995, 0.884> 
		<5.402, 2.064, 0.860> <5.379, 2.047, 0.840> <5.336, 2.022, 0.822> <5.302, 2.022, 0.823> 
		<5.408, 2.093, 0.831> <5.386, 2.076, 0.812> <5.343, 2.055, 0.790> <5.309, 2.054, 0.791> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.280, 1.993, 0.929> <5.263, 1.994, 0.925> <5.253, 2.036, 0.925> <5.265, 2.048, 0.929> 
		<5.289, 1.995, 0.884> <5.272, 1.997, 0.880> <5.259, 2.038, 0.895> <5.271, 2.050, 0.898> 
		<5.302, 2.022, 0.823> <5.283, 2.021, 0.823> <5.268, 2.058, 0.846> <5.280, 2.068, 0.857> 
		<5.309, 2.054, 0.791> <5.291, 2.054, 0.791> <5.273, 2.080, 0.824> <5.285, 2.090, 0.835> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.265, 2.048, 0.929> <5.293, 2.076, 0.936> <5.351, 2.084, 0.949> <5.387, 2.099, 0.958> 
		<5.271, 2.050, 0.898> <5.300, 2.078, 0.906> <5.356, 2.085, 0.924> <5.393, 2.100, 0.932> 
		<5.280, 2.068, 0.857> <5.305, 2.089, 0.880> <5.364, 2.102, 0.885> <5.400, 2.115, 0.898> 
		<5.285, 2.090, 0.835> <5.310, 2.111, 0.859> <5.368, 2.120, 0.867> <5.404, 2.133, 0.880> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.376, 2.121, 1.043> <5.370, 2.108, 1.054> <5.371, 2.088, 1.077> <5.357, 2.079, 1.080> 
		<5.380, 2.104, 1.022> <5.374, 2.092, 1.033> <5.377, 2.063, 1.046> <5.363, 2.053, 1.049> 
		<5.387, 2.093, 0.985> <5.384, 2.076, 0.983> <5.386, 2.048, 0.996> <5.374, 2.036, 0.993> 
		<5.393, 2.095, 0.958> <5.389, 2.078, 0.957> <5.395, 2.050, 0.957> <5.382, 2.038, 0.953> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.357, 2.079, 1.080> <5.329, 2.060, 1.087> <5.281, 2.038, 1.088> <5.251, 2.038, 1.073> 
		<5.363, 2.053, 1.049> <5.335, 2.034, 1.056> <5.288, 2.009, 1.052> <5.258, 2.009, 1.038> 
		<5.374, 2.036, 0.993> <5.349, 2.014, 0.987> <5.304, 1.987, 0.981> <5.270, 1.990, 0.974> 
		<5.382, 2.038, 0.953> <5.357, 2.016, 0.947> <5.313, 1.990, 0.936> <5.280, 1.993, 0.929> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.251, 2.038, 1.073> <5.234, 2.038, 1.065> <5.230, 2.068, 1.030> <5.245, 2.079, 1.026> 
		<5.258, 2.009, 1.038> <5.241, 2.009, 1.029> <5.235, 2.049, 1.006> <5.250, 2.059, 1.002> 
		<5.270, 1.990, 0.974> <5.254, 1.991, 0.970> <5.246, 2.034, 0.956> <5.258, 2.046, 0.959> 
		<5.280, 1.993, 0.929> <5.263, 1.994, 0.925> <5.253, 2.036, 0.925> <5.265, 2.048, 0.929> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.245, 2.079, 1.026> <5.277, 2.102, 1.017> <5.334, 2.111, 1.034> <5.371, 2.124, 1.038> 
		<5.250, 2.059, 1.002> <5.282, 2.082, 0.993> <5.337, 2.094, 1.015> <5.375, 2.108, 1.018> 
		<5.258, 2.046, 0.959> <5.287, 2.074, 0.967> <5.345, 2.082, 0.974> <5.382, 2.097, 0.983> 
		<5.265, 2.048, 0.929> <5.293, 2.076, 0.936> <5.351, 2.084, 0.949> <5.387, 2.099, 0.958> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.599, 2.414, 0.781> <3.593, 2.415, 0.798> <3.595, 2.411, 0.830> <3.580, 2.417, 0.838> 
		<3.584, 2.394, 0.778> <3.578, 2.395, 0.795> <3.572, 2.381, 0.826> <3.556, 2.387, 0.834> 
		<3.565, 2.368, 0.758> <3.553, 2.360, 0.768> <3.546, 2.347, 0.800> <3.529, 2.348, 0.804> 
		<3.558, 2.356, 0.737> <3.546, 2.348, 0.748> <3.536, 2.329, 0.769> <3.518, 2.329, 0.773> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.580, 2.417, 0.838> <3.552, 2.428, 0.853> <3.505, 2.448, 0.861> <3.479, 2.461, 0.846> 
		<3.556, 2.387, 0.834> <3.529, 2.398, 0.849> <3.479, 2.415, 0.856> <3.453, 2.428, 0.841> 
		<3.529, 2.348, 0.804> <3.496, 2.350, 0.811> <3.446, 2.363, 0.819> <3.422, 2.383, 0.807> 
		<3.518, 2.329, 0.773> <3.485, 2.331, 0.781> <3.434, 2.342, 0.784> <3.409, 2.362, 0.772> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.479, 2.461, 0.846> <3.463, 2.469, 0.837> <3.459, 2.476, 0.789> <3.476, 2.470, 0.779> 
		<3.453, 2.428, 0.841> <3.437, 2.436, 0.832> <3.441, 2.454, 0.786> <3.458, 2.447, 0.775> 
		<3.422, 2.383, 0.807> <3.408, 2.394, 0.800> <3.419, 2.417, 0.757> <3.437, 2.417, 0.752> 
		<3.409, 2.362, 0.772> <3.396, 2.373, 0.765> <3.410, 2.403, 0.733> <3.429, 2.403, 0.729> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.476, 2.470, 0.779> <3.507, 2.457, 0.759> <3.559, 2.432, 0.776> <3.595, 2.416, 0.774> 
		<3.458, 2.447, 0.775> <3.490, 2.435, 0.756> <3.545, 2.414, 0.773> <3.581, 2.398, 0.771> 
		<3.437, 2.417, 0.752> <3.476, 2.417, 0.742> <3.525, 2.385, 0.751> <3.563, 2.373, 0.752> 
		<3.429, 2.403, 0.729> <3.468, 2.402, 0.718> <3.518, 2.373, 0.731> <3.556, 2.361, 0.733> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.652, 2.474, 0.755> <3.654, 2.484, 0.769> <3.669, 2.496, 0.794> <3.659, 2.507, 0.800> 
		<3.638, 2.461, 0.772> <3.640, 2.470, 0.785> <3.649, 2.475, 0.819> <3.638, 2.487, 0.825> 
		<3.615, 2.434, 0.784> <3.609, 2.434, 0.801> <3.618, 2.440, 0.835> <3.603, 2.446, 0.843> 
		<3.599, 2.414, 0.781> <3.593, 2.415, 0.798> <3.595, 2.411, 0.830> <3.580, 2.417, 0.838> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.659, 2.507, 0.800> <3.638, 2.529, 0.812> <3.597, 2.556, 0.815> <3.569, 2.563, 0.803> 
		<3.638, 2.487, 0.825> <3.618, 2.508, 0.836> <3.574, 2.533, 0.842> <3.546, 2.540, 0.831> 
		<3.603, 2.446, 0.843> <3.575, 2.457, 0.858> <3.532, 2.481, 0.866> <3.505, 2.494, 0.851> 
		<3.580, 2.417, 0.838> <3.552, 2.428, 0.853> <3.505, 2.448, 0.861> <3.479, 2.461, 0.846> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.569, 2.563, 0.803> <3.551, 2.568, 0.795> <3.524, 2.553, 0.758> <3.536, 2.539, 0.749> 
		<3.546, 2.540, 0.831> <3.528, 2.545, 0.823> <3.509, 2.537, 0.776> <3.521, 2.523, 0.768> 
		<3.505, 2.494, 0.851> <3.489, 2.503, 0.842> <3.477, 2.499, 0.792> <3.493, 2.492, 0.782> 
		<3.479, 2.461, 0.846> <3.463, 2.469, 0.837> <3.459, 2.476, 0.789> <3.476, 2.470, 0.779> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.536, 2.539, 0.749> <3.559, 2.512, 0.734> <3.613, 2.493, 0.750> <3.645, 2.474, 0.750> 
		<3.521, 2.523, 0.768> <3.543, 2.497, 0.753> <3.600, 2.480, 0.765> <3.633, 2.461, 0.765> 
		<3.493, 2.492, 0.782> <3.525, 2.480, 0.763> <3.574, 2.451, 0.778> <3.610, 2.435, 0.777> 
		<3.476, 2.470, 0.779> <3.507, 2.457, 0.759> <3.559, 2.432, 0.776> <3.595, 2.416, 0.774> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.685, 2.501, 0.675> <3.692, 2.515, 0.677> <3.716, 2.534, 0.681> <3.709, 2.548, 0.680> 
		<3.681, 2.500, 0.702> <3.688, 2.514, 0.704> <3.710, 2.533, 0.722> <3.702, 2.546, 0.720> 
		<3.666, 2.489, 0.738> <3.668, 2.499, 0.751> <3.691, 2.518, 0.767> <3.680, 2.529, 0.773> 
		<3.652, 2.474, 0.755> <3.654, 2.484, 0.769> <3.669, 2.496, 0.794> <3.659, 2.507, 0.800> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.709, 2.548, 0.680> <3.694, 2.575, 0.678> <3.656, 2.604, 0.672> <3.626, 2.609, 0.667> 
		<3.702, 2.546, 0.720> <3.687, 2.574, 0.718> <3.648, 2.603, 0.718> <3.618, 2.608, 0.712> 
		<3.680, 2.529, 0.773> <3.660, 2.551, 0.785> <3.622, 2.581, 0.784> <3.593, 2.588, 0.772> 
		<3.659, 2.507, 0.800> <3.638, 2.529, 0.812> <3.597, 2.556, 0.815> <3.569, 2.563, 0.803> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.626, 2.609, 0.667> <3.607, 2.612, 0.664> <3.567, 2.588, 0.656> <3.575, 2.570, 0.657> 
		<3.618, 2.608, 0.712> <3.599, 2.611, 0.709> <3.561, 2.587, 0.687> <3.570, 2.569, 0.688> 
		<3.593, 2.588, 0.772> <3.575, 2.593, 0.765> <3.541, 2.570, 0.737> <3.553, 2.556, 0.729> 
		<3.569, 2.563, 0.803> <3.551, 2.568, 0.795> <3.524, 2.553, 0.758> <3.536, 2.539, 0.749> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.575, 2.570, 0.657> <3.591, 2.536, 0.660> <3.647, 2.520, 0.669> <3.677, 2.499, 0.674> 
		<3.570, 2.569, 0.688> <3.586, 2.535, 0.691> <3.642, 2.520, 0.695> <3.673, 2.498, 0.699> 
		<3.553, 2.556, 0.729> <3.576, 2.529, 0.713> <3.626, 2.507, 0.733> <3.659, 2.488, 0.733> 
		<3.536, 2.539, 0.749> <3.559, 2.512, 0.734> <3.613, 2.493, 0.750> <3.645, 2.474, 0.750> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.680, 2.479, 0.588> <3.686, 2.490, 0.576> <3.709, 2.502, 0.558> <3.701, 2.514, 0.549> 
		<3.688, 2.492, 0.610> <3.694, 2.503, 0.599> <3.721, 2.523, 0.591> <3.713, 2.535, 0.582> 
		<3.690, 2.502, 0.649> <3.697, 2.516, 0.650> <3.723, 2.535, 0.641> <3.716, 2.549, 0.640> 
		<3.685, 2.501, 0.675> <3.692, 2.515, 0.677> <3.716, 2.534, 0.681> <3.709, 2.548, 0.680> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.701, 2.514, 0.549> <3.686, 2.537, 0.532> <3.648, 2.564, 0.517> <3.617, 2.572, 0.518> 
		<3.713, 2.535, 0.582> <3.697, 2.557, 0.566> <3.661, 2.588, 0.554> <3.630, 2.595, 0.556> 
		<3.716, 2.549, 0.640> <3.701, 2.576, 0.638> <3.664, 2.605, 0.627> <3.633, 2.611, 0.622> 
		<3.709, 2.548, 0.680> <3.694, 2.575, 0.678> <3.656, 2.604, 0.672> <3.626, 2.609, 0.667> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.617, 2.572, 0.518> <3.597, 2.576, 0.520> <3.560, 2.559, 0.546> <3.569, 2.544, 0.557> 
		<3.630, 2.595, 0.556> <3.610, 2.599, 0.557> <3.569, 2.574, 0.571> <3.578, 2.560, 0.582> 
		<3.633, 2.611, 0.622> <3.614, 2.614, 0.618> <3.572, 2.588, 0.626> <3.580, 2.571, 0.627> 
		<3.626, 2.609, 0.667> <3.607, 2.612, 0.664> <3.567, 2.588, 0.656> <3.575, 2.570, 0.657> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.569, 2.544, 0.557> <3.585, 2.517, 0.578> <3.641, 2.498, 0.581> <3.672, 2.478, 0.591> 
		<3.578, 2.560, 0.582> <3.594, 2.533, 0.604> <3.649, 2.511, 0.602> <3.680, 2.491, 0.612> 
		<3.580, 2.571, 0.627> <3.596, 2.537, 0.629> <3.651, 2.521, 0.644> <3.682, 2.500, 0.649> 
		<3.575, 2.570, 0.657> <3.591, 2.536, 0.660> <3.647, 2.520, 0.669> <3.677, 2.499, 0.674> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.639, 2.421, 0.544> <3.639, 2.422, 0.526> <3.651, 2.420, 0.496> <3.640, 2.427, 0.484> 
		<3.655, 2.440, 0.547> <3.655, 2.442, 0.529> <3.674, 2.450, 0.501> <3.663, 2.456, 0.488> 
		<3.673, 2.466, 0.568> <3.679, 2.477, 0.556> <3.698, 2.484, 0.527> <3.690, 2.495, 0.519> 
		<3.680, 2.479, 0.588> <3.686, 2.490, 0.576> <3.709, 2.502, 0.558> <3.701, 2.514, 0.549> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.640, 2.427, 0.484> <3.619, 2.439, 0.461> <3.577, 2.460, 0.438> <3.547, 2.472, 0.444> 
		<3.663, 2.456, 0.488> <3.642, 2.468, 0.465> <3.603, 2.493, 0.443> <3.573, 2.506, 0.449> 
		<3.690, 2.495, 0.519> <3.675, 2.518, 0.502> <3.636, 2.543, 0.482> <3.604, 2.550, 0.484> 
		<3.701, 2.514, 0.549> <3.686, 2.537, 0.532> <3.648, 2.564, 0.517> <3.617, 2.572, 0.518> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.547, 2.472, 0.444> <3.529, 2.480, 0.448> <3.510, 2.484, 0.492> <3.522, 2.477, 0.507> 
		<3.573, 2.506, 0.449> <3.555, 2.514, 0.453> <3.527, 2.507, 0.495> <3.539, 2.500, 0.510> 
		<3.604, 2.550, 0.484> <3.585, 2.555, 0.485> <3.552, 2.544, 0.522> <3.560, 2.530, 0.534> 
		<3.617, 2.572, 0.518> <3.597, 2.576, 0.520> <3.560, 2.559, 0.546> <3.569, 2.544, 0.557> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.522, 2.477, 0.507> <3.545, 2.464, 0.536> <3.600, 2.439, 0.537> <3.633, 2.423, 0.550> 
		<3.539, 2.500, 0.510> <3.563, 2.486, 0.539> <3.615, 2.458, 0.540> <3.648, 2.441, 0.552> 
		<3.560, 2.530, 0.534> <3.577, 2.503, 0.555> <3.634, 2.486, 0.561> <3.665, 2.466, 0.572> 
		<3.569, 2.544, 0.557> <3.585, 2.517, 0.578> <3.641, 2.498, 0.581> <3.672, 2.478, 0.591> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.587, 2.360, 0.570> <3.579, 2.353, 0.556> <3.576, 2.335, 0.532> <3.561, 2.336, 0.522> 
		<3.600, 2.374, 0.554> <3.592, 2.367, 0.539> <3.596, 2.356, 0.507> <3.581, 2.357, 0.497> 
		<3.624, 2.401, 0.541> <3.624, 2.403, 0.523> <3.628, 2.391, 0.492> <3.616, 2.397, 0.479> 
		<3.639, 2.421, 0.544> <3.639, 2.422, 0.526> <3.651, 2.420, 0.496> <3.640, 2.427, 0.484> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.561, 2.336, 0.522> <3.532, 2.339, 0.504> <3.485, 2.350, 0.484> <3.458, 2.370, 0.488> 
		<3.581, 2.357, 0.497> <3.552, 2.359, 0.479> <3.508, 2.373, 0.456> <3.480, 2.393, 0.460> 
		<3.616, 2.397, 0.479> <3.595, 2.409, 0.456> <3.551, 2.426, 0.433> <3.521, 2.439, 0.439> 
		<3.640, 2.427, 0.484> <3.619, 2.439, 0.461> <3.577, 2.460, 0.438> <3.547, 2.472, 0.444> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.458, 2.370, 0.488> <3.443, 2.381, 0.490> <3.446, 2.409, 0.526> <3.461, 2.408, 0.536> 
		<3.480, 2.393, 0.460> <3.465, 2.404, 0.462> <3.461, 2.424, 0.507> <3.477, 2.424, 0.517> 
		<3.521, 2.439, 0.439> <3.502, 2.447, 0.443> <3.492, 2.462, 0.489> <3.504, 2.455, 0.503> 
		<3.547, 2.472, 0.444> <3.529, 2.480, 0.448> <3.510, 2.484, 0.492> <3.522, 2.477, 0.507> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.461, 2.408, 0.536> <3.494, 2.407, 0.559> <3.547, 2.378, 0.563> <3.583, 2.365, 0.574> 
		<3.477, 2.424, 0.517> <3.510, 2.422, 0.540> <3.559, 2.391, 0.547> <3.596, 2.378, 0.558> 
		<3.504, 2.455, 0.503> <3.527, 2.441, 0.532> <3.585, 2.420, 0.534> <3.619, 2.404, 0.547> 
		<3.522, 2.477, 0.507> <3.545, 2.464, 0.536> <3.600, 2.439, 0.537> <3.633, 2.423, 0.550> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.553, 2.333, 0.650> <3.540, 2.322, 0.647> <3.527, 2.297, 0.645> <3.510, 2.296, 0.642> 
		<3.558, 2.334, 0.623> <3.545, 2.323, 0.621> <3.534, 2.298, 0.605> <3.517, 2.297, 0.602> 
		<3.572, 2.346, 0.588> <3.564, 2.339, 0.573> <3.554, 2.313, 0.558> <3.539, 2.314, 0.549> 
		<3.587, 2.360, 0.570> <3.579, 2.353, 0.556> <3.576, 2.335, 0.532> <3.561, 2.336, 0.522> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.510, 2.296, 0.642> <3.476, 2.294, 0.636> <3.426, 2.301, 0.627> <3.401, 2.324, 0.623> 
		<3.517, 2.297, 0.602> <3.483, 2.295, 0.596> <3.433, 2.302, 0.582> <3.408, 2.326, 0.578> 
		<3.539, 2.314, 0.549> <3.510, 2.317, 0.530> <3.460, 2.325, 0.514> <3.433, 2.345, 0.518> 
		<3.561, 2.336, 0.522> <3.532, 2.339, 0.504> <3.485, 2.350, 0.484> <3.458, 2.370, 0.488> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.401, 2.324, 0.623> <3.388, 2.336, 0.622> <3.406, 2.375, 0.625> <3.423, 2.377, 0.628> 
		<3.408, 2.326, 0.578> <3.396, 2.337, 0.576> <3.411, 2.376, 0.594> <3.428, 2.378, 0.597> 
		<3.433, 2.345, 0.518> <3.418, 2.356, 0.520> <3.429, 2.392, 0.546> <3.444, 2.391, 0.557> 
		<3.458, 2.370, 0.488> <3.443, 2.381, 0.490> <3.446, 2.409, 0.526> <3.461, 2.408, 0.536> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.423, 2.377, 0.628> <3.462, 2.381, 0.635> <3.513, 2.351, 0.643> <3.551, 2.340, 0.650> 
		<3.428, 2.378, 0.597> <3.468, 2.382, 0.604> <3.517, 2.352, 0.618> <3.556, 2.341, 0.624> 
		<3.444, 2.391, 0.557> <3.478, 2.390, 0.580> <3.533, 2.364, 0.579> <3.570, 2.352, 0.591> 
		<3.461, 2.408, 0.536> <3.494, 2.407, 0.559> <3.547, 2.378, 0.563> <3.583, 2.365, 0.574> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.558, 2.356, 0.737> <3.546, 2.348, 0.748> <3.536, 2.329, 0.769> <3.518, 2.329, 0.773> 
		<3.550, 2.342, 0.715> <3.538, 2.334, 0.726> <3.524, 2.308, 0.736> <3.506, 2.309, 0.740> 
		<3.548, 2.333, 0.677> <3.536, 2.321, 0.674> <3.520, 2.296, 0.685> <3.503, 2.295, 0.682> 
		<3.553, 2.333, 0.650> <3.540, 2.322, 0.647> <3.527, 2.297, 0.645> <3.510, 2.296, 0.642> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.518, 2.329, 0.773> <3.485, 2.331, 0.781> <3.434, 2.342, 0.784> <3.409, 2.362, 0.772> 
		<3.506, 2.309, 0.740> <3.473, 2.310, 0.747> <3.421, 2.319, 0.747> <3.396, 2.339, 0.734> 
		<3.503, 2.295, 0.682> <3.470, 2.293, 0.676> <3.418, 2.300, 0.673> <3.393, 2.323, 0.669> 
		<3.510, 2.296, 0.642> <3.476, 2.294, 0.636> <3.426, 2.301, 0.627> <3.401, 2.324, 0.623> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.409, 2.362, 0.772> <3.396, 2.373, 0.765> <3.410, 2.403, 0.733> <3.429, 2.403, 0.729> 
		<3.396, 2.339, 0.734> <3.383, 2.350, 0.728> <3.401, 2.387, 0.708> <3.420, 2.387, 0.703> 
		<3.393, 2.323, 0.669> <3.380, 2.335, 0.667> <3.400, 2.374, 0.656> <3.417, 2.376, 0.659> 
		<3.401, 2.324, 0.623> <3.388, 2.336, 0.622> <3.406, 2.375, 0.625> <3.423, 2.377, 0.628> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.429, 2.403, 0.729> <3.468, 2.402, 0.718> <3.518, 2.373, 0.731> <3.556, 2.361, 0.733> 
		<3.420, 2.387, 0.703> <3.459, 2.387, 0.693> <3.511, 2.361, 0.710> <3.549, 2.348, 0.712> 
		<3.417, 2.376, 0.659> <3.457, 2.380, 0.666> <3.508, 2.350, 0.669> <3.547, 2.339, 0.675> 
		<3.423, 2.377, 0.628> <3.462, 2.381, 0.635> <3.513, 2.351, 0.643> <3.551, 2.340, 0.650> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.520, 2.383, -1.084> <3.533, 2.454, -1.071> <3.531, 2.526, -1.119> <3.517, 2.541, -1.189> 
		<3.802, 2.345, -1.149> <3.814, 2.416, -1.137> <3.813, 2.488, -1.185> <3.798, 2.503, -1.255> 
		<4.177, 2.294, -1.237> <4.189, 2.365, -1.224> <4.188, 2.437, -1.272> <4.173, 2.452, -1.342> 
		<4.458, 2.256, -1.302> <4.471, 2.327, -1.290> <4.469, 2.398, -1.338> <4.455, 2.413, -1.408> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.517, 2.541, -1.189> <3.503, 2.556, -1.259> <3.480, 2.509, -1.328> <3.468, 2.438, -1.341> 
		<3.798, 2.503, -1.255> <3.784, 2.518, -1.325> <3.762, 2.471, -1.394> <3.749, 2.400, -1.407> 
		<4.173, 2.452, -1.342> <4.159, 2.467, -1.413> <4.137, 2.420, -1.482> <4.124, 2.349, -1.494> 
		<4.455, 2.413, -1.408> <4.440, 2.428, -1.478> <4.418, 2.382, -1.547> <4.405, 2.311, -1.560> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.468, 2.438, -1.341> <3.455, 2.367, -1.353> <3.456, 2.296, -1.305> <3.471, 2.281, -1.235> 
		<3.749, 2.400, -1.407> <3.736, 2.329, -1.419> <3.738, 2.257, -1.371> <3.752, 2.242, -1.301> 
		<4.124, 2.349, -1.494> <4.111, 2.278, -1.507> <4.113, 2.206, -1.459> <4.127, 2.191, -1.388> 
		<4.405, 2.311, -1.560> <4.393, 2.240, -1.572> <4.394, 2.168, -1.524> <4.409, 2.153, -1.454> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.409, 2.153, -1.454> <4.423, 2.138, -1.384> <4.445, 2.185, -1.315> <4.458, 2.256, -1.302> 
		<4.127, 2.191, -1.388> <4.142, 2.176, -1.318> <4.164, 2.223, -1.249> <4.177, 2.294, -1.237> 
		<3.752, 2.242, -1.301> <3.767, 2.227, -1.231> <3.789, 2.274, -1.162> <3.802, 2.345, -1.149> 
		<3.471, 2.281, -1.235> <3.485, 2.266, -1.165> <3.508, 2.312, -1.096> <3.520, 2.383, -1.084> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.096, 2.334, -1.318> <4.099, 2.351, -1.315> <4.099, 2.368, -1.327> <4.096, 2.372, -1.344> 
		<4.378, 2.296, -1.384> <4.381, 2.313, -1.381> <4.380, 2.330, -1.392> <4.377, 2.334, -1.409> 
		<4.753, 2.245, -1.471> <4.756, 2.262, -1.468> <4.755, 2.279, -1.480> <4.752, 2.282, -1.497> 
		<5.034, 2.206, -1.537> <5.037, 2.223, -1.534> <5.037, 2.241, -1.546> <5.033, 2.244, -1.562> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.096, 2.372, -1.344> <4.092, 2.375, -1.360> <4.087, 2.364, -1.377> <4.084, 2.347, -1.380> 
		<4.377, 2.334, -1.409> <4.373, 2.337, -1.426> <4.368, 2.326, -1.443> <4.365, 2.309, -1.446> 
		<4.752, 2.282, -1.497> <4.749, 2.286, -1.514> <4.743, 2.275, -1.530> <4.740, 2.258, -1.533> 
		<5.033, 2.244, -1.562> <5.030, 2.248, -1.579> <5.025, 2.237, -1.596> <5.022, 2.220, -1.599> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.084, 2.347, -1.380> <4.081, 2.330, -1.383> <4.081, 2.313, -1.371> <4.085, 2.309, -1.355> 
		<4.365, 2.309, -1.446> <4.362, 2.292, -1.449> <4.362, 2.275, -1.437> <4.366, 2.271, -1.420> 
		<4.740, 2.258, -1.533> <4.737, 2.241, -1.536> <4.738, 2.224, -1.525> <4.741, 2.220, -1.508> 
		<5.022, 2.220, -1.599> <5.019, 2.203, -1.602> <5.019, 2.185, -1.590> <5.022, 2.182, -1.573> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.022, 2.182, -1.573> <5.026, 2.178, -1.557> <5.031, 2.189, -1.540> <5.034, 2.206, -1.537> 
		<4.741, 2.220, -1.508> <4.744, 2.216, -1.491> <4.750, 2.228, -1.474> <4.753, 2.245, -1.471> 
		<4.366, 2.271, -1.420> <4.369, 2.267, -1.403> <4.375, 2.279, -1.387> <4.378, 2.296, -1.384> 
		<4.085, 2.309, -1.355> <4.088, 2.306, -1.338> <4.093, 2.317, -1.321> <4.096, 2.334, -1.318> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.500, 2.234, -1.456> <4.497, 2.225, -1.457> <4.498, 2.209, -1.460> <4.489, 2.205, -1.459> 
		<4.497, 2.237, -1.469> <4.494, 2.228, -1.470> <4.493, 2.213, -1.481> <4.485, 2.209, -1.480> 
		<4.495, 2.249, -1.487> <4.491, 2.244, -1.494> <4.490, 2.229, -1.504> <4.481, 2.227, -1.506> 
		<4.495, 2.261, -1.494> <4.491, 2.256, -1.501> <4.490, 2.246, -1.516> <4.481, 2.245, -1.518> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.489, 2.205, -1.459> <4.472, 2.197, -1.458> <4.444, 2.193, -1.453> <4.427, 2.201, -1.448> 
		<4.485, 2.209, -1.480> <4.468, 2.202, -1.478> <4.439, 2.198, -1.476> <4.422, 2.206, -1.471> 
		<4.481, 2.227, -1.506> <4.463, 2.224, -1.510> <4.434, 2.221, -1.509> <4.418, 2.226, -1.500> 
		<4.481, 2.245, -1.518> <4.463, 2.241, -1.522> <4.434, 2.241, -1.522> <4.418, 2.246, -1.514> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.427, 2.201, -1.448> <4.418, 2.205, -1.445> <4.415, 2.230, -1.439> <4.424, 2.235, -1.440> 
		<4.422, 2.206, -1.471> <4.413, 2.210, -1.468> <4.411, 2.234, -1.454> <4.421, 2.239, -1.455> 
		<4.418, 2.226, -1.500> <4.409, 2.229, -1.496> <4.408, 2.250, -1.478> <4.418, 2.252, -1.475> 
		<4.418, 2.246, -1.514> <4.409, 2.249, -1.509> <4.408, 2.264, -1.487> <4.418, 2.266, -1.484> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.424, 2.235, -1.440> <4.444, 2.246, -1.442> <4.476, 2.237, -1.450> <4.498, 2.238, -1.454> 
		<4.421, 2.239, -1.455> <4.441, 2.249, -1.457> <4.473, 2.240, -1.463> <4.495, 2.240, -1.467> 
		<4.418, 2.252, -1.475> <4.439, 2.257, -1.469> <4.470, 2.252, -1.482> <4.493, 2.252, -1.484> 
		<4.418, 2.266, -1.484> <4.439, 2.271, -1.478> <4.470, 2.264, -1.489> <4.493, 2.263, -1.491> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.512, 2.243, -1.410> <4.510, 2.235, -1.405> <4.514, 2.221, -1.396> <4.506, 2.218, -1.392> 
		<4.508, 2.235, -1.422> <4.507, 2.228, -1.416> <4.509, 2.210, -1.413> <4.501, 2.206, -1.409> 
		<4.503, 2.231, -1.442> <4.500, 2.223, -1.443> <4.502, 2.204, -1.440> <4.493, 2.201, -1.439> 
		<4.500, 2.234, -1.456> <4.497, 2.225, -1.457> <4.498, 2.209, -1.460> <4.489, 2.205, -1.459> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.506, 2.218, -1.392> <4.491, 2.212, -1.383> <4.465, 2.209, -1.372> <4.447, 2.216, -1.371> 
		<4.501, 2.206, -1.409> <4.486, 2.200, -1.400> <4.458, 2.196, -1.391> <4.441, 2.203, -1.390> 
		<4.493, 2.201, -1.439> <4.476, 2.193, -1.437> <4.448, 2.188, -1.429> <4.432, 2.196, -1.424> 
		<4.489, 2.205, -1.459> <4.472, 2.197, -1.458> <4.444, 2.193, -1.453> <4.427, 2.201, -1.448> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.447, 2.216, -1.371> <4.437, 2.220, -1.370> <4.429, 2.241, -1.382> <4.437, 2.245, -1.388> 
		<4.441, 2.203, -1.390> <4.431, 2.207, -1.390> <4.425, 2.232, -1.396> <4.433, 2.236, -1.401> 
		<4.432, 2.196, -1.424> <4.423, 2.200, -1.422> <4.418, 2.227, -1.423> <4.427, 2.232, -1.424> 
		<4.427, 2.201, -1.448> <4.418, 2.205, -1.445> <4.415, 2.230, -1.439> <4.424, 2.235, -1.440> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.437, 2.245, -1.388> <4.455, 2.254, -1.399> <4.487, 2.246, -1.404> <4.509, 2.246, -1.411> 
		<4.433, 2.236, -1.401> <4.451, 2.245, -1.412> <4.484, 2.238, -1.415> <4.505, 2.238, -1.422> 
		<4.427, 2.232, -1.424> <4.447, 2.242, -1.426> <4.478, 2.234, -1.437> <4.500, 2.235, -1.441> 
		<4.424, 2.235, -1.440> <4.444, 2.246, -1.442> <4.476, 2.237, -1.450> <4.498, 2.238, -1.454> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.523, 2.282, -1.386> <4.523, 2.280, -1.376> <4.530, 2.276, -1.361> <4.523, 2.276, -1.354> 
		<4.521, 2.268, -1.388> <4.521, 2.266, -1.379> <4.526, 2.255, -1.365> <4.519, 2.255, -1.358> 
		<4.516, 2.251, -1.399> <4.514, 2.243, -1.393> <4.520, 2.233, -1.379> <4.512, 2.229, -1.375> 
		<4.512, 2.243, -1.410> <4.510, 2.235, -1.405> <4.514, 2.221, -1.396> <4.506, 2.218, -1.392> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.523, 2.276, -1.354> <4.510, 2.276, -1.341> <4.484, 2.278, -1.327> <4.466, 2.282, -1.329> 
		<4.519, 2.255, -1.358> <4.506, 2.255, -1.345> <4.480, 2.255, -1.332> <4.462, 2.258, -1.333> 
		<4.512, 2.229, -1.375> <4.497, 2.223, -1.366> <4.471, 2.222, -1.353> <4.453, 2.229, -1.352> 
		<4.506, 2.218, -1.392> <4.491, 2.212, -1.383> <4.465, 2.209, -1.372> <4.447, 2.216, -1.371> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.466, 2.282, -1.329> <4.455, 2.284, -1.329> <4.443, 2.290, -1.351> <4.450, 2.290, -1.359> 
		<4.462, 2.258, -1.333> <4.451, 2.260, -1.333> <4.440, 2.274, -1.354> <4.447, 2.274, -1.362> 
		<4.453, 2.229, -1.352> <4.443, 2.233, -1.351> <4.433, 2.250, -1.369> <4.442, 2.254, -1.375> 
		<4.447, 2.216, -1.371> <4.437, 2.220, -1.370> <4.429, 2.241, -1.382> <4.437, 2.245, -1.388> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.450, 2.290, -1.359> <4.465, 2.290, -1.376> <4.499, 2.285, -1.379> <4.519, 2.283, -1.388> 
		<4.447, 2.274, -1.362> <4.463, 2.274, -1.379> <4.496, 2.272, -1.382> <4.517, 2.270, -1.390> 
		<4.442, 2.254, -1.375> <4.459, 2.263, -1.386> <4.491, 2.253, -1.394> <4.512, 2.253, -1.401> 
		<4.437, 2.245, -1.388> <4.455, 2.254, -1.399> <4.487, 2.246, -1.404> <4.509, 2.246, -1.411> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.527, 2.328, -1.395> <4.528, 2.333, -1.388> <4.535, 2.342, -1.375> <4.529, 2.345, -1.369> 
		<4.527, 2.316, -1.388> <4.528, 2.321, -1.380> <4.536, 2.324, -1.363> <4.529, 2.328, -1.357> 
		<4.525, 2.295, -1.383> <4.526, 2.294, -1.374> <4.534, 2.297, -1.357> <4.527, 2.297, -1.351> 
		<4.523, 2.282, -1.386> <4.523, 2.280, -1.376> <4.530, 2.276, -1.361> <4.523, 2.276, -1.354> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.529, 2.345, -1.369> <4.516, 2.353, -1.358> <4.491, 2.361, -1.345> <4.473, 2.360, -1.345> 
		<4.529, 2.328, -1.357> <4.517, 2.335, -1.346> <4.492, 2.341, -1.332> <4.473, 2.340, -1.332> 
		<4.527, 2.297, -1.351> <4.513, 2.297, -1.337> <4.489, 2.302, -1.323> <4.470, 2.305, -1.325> 
		<4.523, 2.276, -1.354> <4.510, 2.276, -1.341> <4.484, 2.278, -1.327> <4.466, 2.282, -1.329> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.473, 2.360, -1.345> <4.462, 2.360, -1.346> <4.448, 2.347, -1.364> <4.455, 2.343, -1.371> 
		<4.473, 2.340, -1.332> <4.462, 2.340, -1.332> <4.448, 2.334, -1.355> <4.455, 2.329, -1.361> 
		<4.470, 2.305, -1.325> <4.460, 2.307, -1.325> <4.446, 2.306, -1.349> <4.453, 2.306, -1.356> 
		<4.466, 2.282, -1.329> <4.455, 2.284, -1.329> <4.443, 2.290, -1.351> <4.450, 2.290, -1.359> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.455, 2.343, -1.371> <4.469, 2.333, -1.385> <4.503, 2.331, -1.389> <4.523, 2.326, -1.397> 
		<4.455, 2.329, -1.361> <4.469, 2.320, -1.376> <4.503, 2.320, -1.382> <4.523, 2.315, -1.390> 
		<4.453, 2.306, -1.356> <4.468, 2.306, -1.373> <4.501, 2.298, -1.377> <4.522, 2.296, -1.386> 
		<4.450, 2.290, -1.359> <4.465, 2.290, -1.376> <4.499, 2.285, -1.379> <4.519, 2.283, -1.388> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.522, 2.354, -1.434> <4.521, 2.364, -1.432> <4.528, 2.379, -1.430> <4.521, 2.385, -1.428> 
		<4.524, 2.351, -1.421> <4.524, 2.361, -1.419> <4.532, 2.375, -1.410> <4.525, 2.381, -1.407> 
		<4.527, 2.340, -1.403> <4.527, 2.345, -1.396> <4.535, 2.359, -1.387> <4.529, 2.363, -1.381> 
		<4.527, 2.328, -1.395> <4.528, 2.333, -1.388> <4.535, 2.342, -1.375> <4.529, 2.345, -1.369> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.521, 2.385, -1.428> <4.507, 2.397, -1.422> <4.482, 2.408, -1.415> <4.463, 2.405, -1.412> 
		<4.525, 2.381, -1.407> <4.511, 2.393, -1.402> <4.486, 2.403, -1.392> <4.468, 2.400, -1.388> 
		<4.529, 2.363, -1.381> <4.516, 2.371, -1.369> <4.491, 2.381, -1.359> <4.472, 2.380, -1.359> 
		<4.529, 2.345, -1.369> <4.516, 2.353, -1.358> <4.491, 2.361, -1.345> <4.473, 2.360, -1.345> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.463, 2.405, -1.412> <4.453, 2.404, -1.410> <4.441, 2.381, -1.412> <4.448, 2.373, -1.415> 
		<4.468, 2.400, -1.388> <4.458, 2.399, -1.387> <4.444, 2.377, -1.397> <4.452, 2.370, -1.400> 
		<4.472, 2.380, -1.359> <4.462, 2.380, -1.359> <4.448, 2.361, -1.373> <4.454, 2.357, -1.380> 
		<4.473, 2.360, -1.345> <4.462, 2.360, -1.346> <4.448, 2.347, -1.364> <4.455, 2.343, -1.371> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.448, 2.373, -1.415> <4.464, 2.358, -1.422> <4.497, 2.358, -1.428> <4.518, 2.352, -1.434> 
		<4.452, 2.370, -1.400> <4.467, 2.355, -1.406> <4.500, 2.355, -1.416> <4.521, 2.349, -1.421> 
		<4.454, 2.357, -1.380> <4.469, 2.347, -1.394> <4.502, 2.343, -1.397> <4.523, 2.338, -1.405> 
		<4.455, 2.343, -1.371> <4.469, 2.333, -1.385> <4.503, 2.331, -1.389> <4.523, 2.326, -1.397> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.510, 2.346, -1.479> <4.508, 2.354, -1.484> <4.511, 2.367, -1.494> <4.503, 2.372, -1.495> 
		<4.514, 2.353, -1.468> <4.512, 2.361, -1.473> <4.517, 2.378, -1.477> <4.509, 2.384, -1.478> 
		<4.519, 2.357, -1.448> <4.519, 2.366, -1.446> <4.524, 2.383, -1.451> <4.517, 2.389, -1.448> 
		<4.522, 2.354, -1.434> <4.521, 2.364, -1.432> <4.528, 2.379, -1.430> <4.521, 2.385, -1.428> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.503, 2.372, -1.495> <4.488, 2.383, -1.497> <4.461, 2.393, -1.495> <4.443, 2.391, -1.488> 
		<4.509, 2.384, -1.478> <4.493, 2.394, -1.480> <4.467, 2.406, -1.476> <4.450, 2.404, -1.469> 
		<4.517, 2.389, -1.448> <4.503, 2.401, -1.443> <4.477, 2.413, -1.438> <4.459, 2.410, -1.435> 
		<4.521, 2.385, -1.428> <4.507, 2.397, -1.422> <4.482, 2.408, -1.415> <4.463, 2.405, -1.412> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.443, 2.391, -1.488> <4.434, 2.389, -1.484> <4.427, 2.370, -1.469> <4.435, 2.364, -1.467> 
		<4.450, 2.404, -1.469> <4.440, 2.402, -1.465> <4.431, 2.379, -1.456> <4.439, 2.372, -1.454> 
		<4.459, 2.410, -1.435> <4.448, 2.409, -1.433> <4.438, 2.384, -1.428> <4.445, 2.377, -1.431> 
		<4.463, 2.405, -1.412> <4.453, 2.404, -1.410> <4.441, 2.381, -1.412> <4.448, 2.373, -1.415> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.435, 2.364, -1.467> <4.453, 2.350, -1.464> <4.485, 2.349, -1.474> <4.507, 2.343, -1.477> 
		<4.439, 2.372, -1.454> <4.457, 2.359, -1.451> <4.489, 2.357, -1.463> <4.510, 2.351, -1.466> 
		<4.445, 2.377, -1.431> <4.461, 2.362, -1.437> <4.494, 2.361, -1.441> <4.515, 2.354, -1.447> 
		<4.448, 2.373, -1.415> <4.464, 2.358, -1.422> <4.497, 2.358, -1.428> <4.518, 2.352, -1.434> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.499, 2.307, -1.504> <4.495, 2.309, -1.513> <4.495, 2.312, -1.530> <4.487, 2.314, -1.533> 
		<4.501, 2.321, -1.502> <4.498, 2.323, -1.510> <4.499, 2.333, -1.526> <4.490, 2.335, -1.529> 
		<4.506, 2.338, -1.491> <4.504, 2.346, -1.496> <4.506, 2.355, -1.511> <4.498, 2.361, -1.512> 
		<4.510, 2.346, -1.479> <4.508, 2.354, -1.484> <4.511, 2.367, -1.494> <4.503, 2.372, -1.495> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.487, 2.314, -1.533> <4.469, 2.318, -1.539> <4.441, 2.323, -1.540> <4.425, 2.325, -1.531> 
		<4.490, 2.335, -1.529> <4.473, 2.339, -1.535> <4.445, 2.347, -1.536> <4.429, 2.348, -1.526> 
		<4.498, 2.361, -1.512> <4.482, 2.371, -1.514> <4.454, 2.380, -1.515> <4.437, 2.377, -1.508> 
		<4.503, 2.372, -1.495> <4.488, 2.383, -1.497> <4.461, 2.393, -1.495> <4.443, 2.391, -1.488> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.425, 2.325, -1.531> <4.415, 2.325, -1.525> <4.413, 2.321, -1.500> <4.422, 2.319, -1.496> 
		<4.429, 2.348, -1.526> <4.419, 2.349, -1.521> <4.416, 2.337, -1.497> <4.425, 2.335, -1.493> 
		<4.437, 2.377, -1.508> <4.427, 2.376, -1.504> <4.422, 2.361, -1.482> <4.431, 2.355, -1.480> 
		<4.443, 2.391, -1.488> <4.434, 2.389, -1.484> <4.427, 2.370, -1.469> <4.435, 2.364, -1.467> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.422, 2.319, -1.496> <4.443, 2.314, -1.487> <4.474, 2.310, -1.499> <4.496, 2.307, -1.501> 
		<4.425, 2.335, -1.493> <4.445, 2.330, -1.485> <4.476, 2.323, -1.497> <4.499, 2.320, -1.498> 
		<4.431, 2.355, -1.480> <4.449, 2.341, -1.477> <4.482, 2.342, -1.485> <4.503, 2.336, -1.488> 
		<4.435, 2.364, -1.467> <4.453, 2.350, -1.464> <4.485, 2.349, -1.474> <4.507, 2.343, -1.477> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.495, 2.261, -1.494> <4.491, 2.256, -1.501> <4.490, 2.246, -1.516> <4.481, 2.245, -1.518> 
		<4.495, 2.273, -1.502> <4.490, 2.268, -1.509> <4.489, 2.264, -1.527> <4.480, 2.262, -1.530> 
		<4.496, 2.293, -1.507> <4.493, 2.295, -1.515> <4.492, 2.291, -1.533> <4.483, 2.293, -1.536> 
		<4.499, 2.307, -1.504> <4.495, 2.309, -1.513> <4.495, 2.312, -1.530> <4.487, 2.314, -1.533> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.481, 2.245, -1.518> <4.463, 2.241, -1.522> <4.434, 2.241, -1.522> <4.418, 2.246, -1.514> 
		<4.480, 2.262, -1.530> <4.462, 2.259, -1.534> <4.433, 2.261, -1.536> <4.417, 2.266, -1.527> 
		<4.483, 2.293, -1.536> <4.466, 2.297, -1.542> <4.437, 2.300, -1.544> <4.420, 2.301, -1.535> 
		<4.487, 2.314, -1.533> <4.469, 2.318, -1.539> <4.441, 2.323, -1.540> <4.425, 2.325, -1.531> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.418, 2.246, -1.514> <4.409, 2.249, -1.509> <4.408, 2.264, -1.487> <4.418, 2.266, -1.484> 
		<4.417, 2.266, -1.527> <4.408, 2.269, -1.522> <4.407, 2.277, -1.496> <4.417, 2.279, -1.494> 
		<4.420, 2.301, -1.535> <4.411, 2.302, -1.529> <4.410, 2.305, -1.503> <4.419, 2.303, -1.499> 
		<4.425, 2.325, -1.531> <4.415, 2.325, -1.525> <4.413, 2.321, -1.500> <4.422, 2.319, -1.496> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.418, 2.266, -1.484> <4.439, 2.271, -1.478> <4.470, 2.264, -1.489> <4.493, 2.263, -1.491> 
		<4.417, 2.279, -1.494> <4.439, 2.284, -1.487> <4.470, 2.275, -1.497> <4.492, 2.274, -1.499> 
		<4.419, 2.303, -1.499> <4.440, 2.298, -1.490> <4.472, 2.297, -1.501> <4.494, 2.294, -1.503> 
		<4.422, 2.319, -1.496> <4.443, 2.314, -1.487> <4.474, 2.310, -1.499> <4.496, 2.307, -1.501> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.068, 2.153, -1.629> <5.067, 2.143, -1.629> <5.063, 2.128, -1.635> <5.064, 2.122, -1.629> 
		<5.055, 2.155, -1.626> <5.053, 2.145, -1.626> <5.043, 2.131, -1.630> <5.044, 2.124, -1.624> 
		<5.037, 2.165, -1.620> <5.030, 2.159, -1.618> <5.020, 2.144, -1.622> <5.018, 2.140, -1.614> 
		<5.029, 2.176, -1.616> <5.022, 2.170, -1.613> <5.008, 2.161, -1.616> <5.006, 2.156, -1.608> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.064, 2.122, -1.629> <5.066, 2.108, -1.615> <5.070, 2.095, -1.590> <5.075, 2.097, -1.572> 
		<5.044, 2.124, -1.624> <5.045, 2.111, -1.610> <5.047, 2.098, -1.584> <5.052, 2.100, -1.566> 
		<5.018, 2.140, -1.614> <5.013, 2.130, -1.599> <5.014, 2.118, -1.573> <5.023, 2.117, -1.555> 
		<5.006, 2.156, -1.608> <5.001, 2.147, -1.592> <5.001, 2.137, -1.565> <5.009, 2.136, -1.548> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.075, 2.097, -1.572> <5.078, 2.098, -1.562> <5.084, 2.120, -1.550> <5.083, 2.128, -1.557> 
		<5.052, 2.100, -1.566> <5.055, 2.101, -1.556> <5.068, 2.122, -1.546> <5.067, 2.130, -1.553> 
		<5.023, 2.117, -1.555> <5.027, 2.117, -1.546> <5.044, 2.136, -1.537> <5.047, 2.142, -1.546> 
		<5.009, 2.136, -1.548> <5.014, 2.136, -1.539> <5.035, 2.149, -1.533> <5.038, 2.155, -1.541> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.083, 2.128, -1.557> <5.081, 2.144, -1.572> <5.074, 2.147, -1.605> <5.069, 2.155, -1.626> 
		<5.067, 2.130, -1.553> <5.066, 2.146, -1.568> <5.061, 2.149, -1.602> <5.056, 2.157, -1.623> 
		<5.047, 2.142, -1.546> <5.054, 2.153, -1.564> <5.042, 2.160, -1.595> <5.040, 2.167, -1.617> 
		<5.038, 2.155, -1.541> <5.045, 2.166, -1.559> <5.034, 2.170, -1.591> <5.032, 2.177, -1.613> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.113, 2.165, -1.637> <5.119, 2.157, -1.638> <5.128, 2.145, -1.646> <5.132, 2.140, -1.640> 
		<5.102, 2.156, -1.636> <5.108, 2.149, -1.637> <5.110, 2.132, -1.645> <5.115, 2.127, -1.639> 
		<5.082, 2.151, -1.633> <5.081, 2.142, -1.633> <5.084, 2.125, -1.641> <5.085, 2.119, -1.634> 
		<5.068, 2.153, -1.629> <5.067, 2.143, -1.629> <5.063, 2.128, -1.635> <5.064, 2.122, -1.629> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.132, 2.140, -1.640> <5.141, 2.128, -1.628> <5.151, 2.117, -1.603> <5.152, 2.117, -1.584> 
		<5.115, 2.127, -1.639> <5.124, 2.116, -1.627> <5.132, 2.102, -1.602> <5.133, 2.103, -1.583> 
		<5.085, 2.119, -1.634> <5.086, 2.106, -1.620> <5.094, 2.092, -1.596> <5.099, 2.094, -1.578> 
		<5.064, 2.122, -1.629> <5.066, 2.108, -1.615> <5.070, 2.095, -1.590> <5.075, 2.097, -1.572> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.152, 2.117, -1.584> <5.153, 2.117, -1.574> <5.140, 2.135, -1.559> <5.135, 2.142, -1.566> 
		<5.133, 2.103, -1.583> <5.133, 2.103, -1.573> <5.127, 2.125, -1.558> <5.122, 2.132, -1.565> 
		<5.099, 2.094, -1.578> <5.101, 2.095, -1.567> <5.100, 2.118, -1.554> <5.099, 2.126, -1.561> 
		<5.075, 2.097, -1.572> <5.078, 2.098, -1.562> <5.084, 2.120, -1.550> <5.083, 2.128, -1.557> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.135, 2.142, -1.566> <5.124, 2.156, -1.579> <5.119, 2.159, -1.613> <5.112, 2.167, -1.633> 
		<5.122, 2.132, -1.565> <5.111, 2.146, -1.579> <5.108, 2.151, -1.612> <5.102, 2.159, -1.632> 
		<5.099, 2.126, -1.561> <5.097, 2.142, -1.576> <5.087, 2.145, -1.608> <5.082, 2.153, -1.629> 
		<5.083, 2.128, -1.557> <5.081, 2.144, -1.572> <5.074, 2.147, -1.605> <5.069, 2.155, -1.626> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.138, 2.205, -1.634> <5.148, 2.203, -1.634> <5.163, 2.202, -1.642> <5.170, 2.200, -1.635> 
		<5.136, 2.191, -1.636> <5.145, 2.190, -1.637> <5.159, 2.181, -1.645> <5.166, 2.179, -1.639> 
		<5.125, 2.173, -1.638> <5.130, 2.166, -1.638> <5.145, 2.158, -1.647> <5.149, 2.152, -1.641> 
		<5.113, 2.165, -1.637> <5.119, 2.157, -1.638> <5.128, 2.145, -1.646> <5.132, 2.140, -1.640> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.170, 2.200, -1.635> <5.183, 2.195, -1.622> <5.196, 2.188, -1.598> <5.195, 2.185, -1.579> 
		<5.166, 2.179, -1.639> <5.179, 2.174, -1.626> <5.192, 2.165, -1.602> <5.190, 2.162, -1.583> 
		<5.149, 2.152, -1.641> <5.158, 2.141, -1.629> <5.171, 2.131, -1.605> <5.172, 2.132, -1.586> 
		<5.132, 2.140, -1.640> <5.141, 2.128, -1.628> <5.151, 2.117, -1.603> <5.152, 2.117, -1.584> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.195, 2.185, -1.579> <5.194, 2.184, -1.569> <5.172, 2.185, -1.555> <5.164, 2.188, -1.562> 
		<5.190, 2.162, -1.583> <5.190, 2.160, -1.573> <5.169, 2.169, -1.558> <5.161, 2.172, -1.565> 
		<5.172, 2.132, -1.586> <5.172, 2.132, -1.575> <5.154, 2.145, -1.560> <5.148, 2.151, -1.566> 
		<5.152, 2.117, -1.584> <5.153, 2.117, -1.574> <5.140, 2.135, -1.559> <5.135, 2.142, -1.566> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.164, 2.188, -1.562> <5.147, 2.193, -1.576> <5.144, 2.200, -1.610> <5.136, 2.205, -1.630> 
		<5.161, 2.172, -1.565> <5.144, 2.177, -1.579> <5.142, 2.187, -1.612> <5.134, 2.192, -1.632> 
		<5.148, 2.151, -1.566> <5.137, 2.165, -1.580> <5.130, 2.167, -1.613> <5.123, 2.175, -1.634> 
		<5.135, 2.142, -1.566> <5.124, 2.156, -1.579> <5.119, 2.159, -1.613> <5.112, 2.167, -1.633> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.129, 2.250, -1.622> <5.136, 2.255, -1.620> <5.149, 2.266, -1.625> <5.155, 2.267, -1.617> 
		<5.136, 2.239, -1.626> <5.144, 2.244, -1.625> <5.161, 2.249, -1.631> <5.167, 2.250, -1.624> 
		<5.141, 2.219, -1.631> <5.150, 2.217, -1.632> <5.167, 2.223, -1.638> <5.173, 2.220, -1.632> 
		<5.138, 2.205, -1.634> <5.148, 2.203, -1.634> <5.163, 2.202, -1.642> <5.170, 2.200, -1.635> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.155, 2.267, -1.617> <5.166, 2.270, -1.603> <5.178, 2.269, -1.577> <5.178, 2.262, -1.559> 
		<5.167, 2.250, -1.624> <5.178, 2.253, -1.609> <5.192, 2.250, -1.584> <5.191, 2.243, -1.566> 
		<5.173, 2.220, -1.632> <5.186, 2.216, -1.619> <5.200, 2.212, -1.594> <5.199, 2.209, -1.575> 
		<5.170, 2.200, -1.635> <5.183, 2.195, -1.622> <5.196, 2.188, -1.598> <5.195, 2.185, -1.579> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.178, 2.262, -1.559> <5.177, 2.258, -1.549> <5.159, 2.241, -1.540> <5.152, 2.239, -1.548> 
		<5.191, 2.243, -1.566> <5.191, 2.239, -1.556> <5.168, 2.229, -1.545> <5.162, 2.227, -1.553> 
		<5.199, 2.209, -1.575> <5.198, 2.207, -1.565> <5.174, 2.201, -1.552> <5.167, 2.204, -1.559> 
		<5.195, 2.185, -1.579> <5.194, 2.184, -1.569> <5.172, 2.185, -1.555> <5.164, 2.188, -1.562> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.152, 2.239, -1.548> <5.138, 2.235, -1.565> <5.134, 2.245, -1.598> <5.127, 2.247, -1.619> 
		<5.162, 2.227, -1.553> <5.147, 2.223, -1.570> <5.142, 2.234, -1.602> <5.134, 2.237, -1.623> 
		<5.167, 2.204, -1.559> <5.150, 2.209, -1.574> <5.147, 2.213, -1.607> <5.138, 2.218, -1.628> 
		<5.164, 2.188, -1.562> <5.147, 2.193, -1.576> <5.144, 2.200, -1.610> <5.136, 2.205, -1.630> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.090, 2.273, -1.608> <5.092, 2.282, -1.605> <5.094, 2.298, -1.605> <5.096, 2.302, -1.597> 
		<5.103, 2.271, -1.612> <5.105, 2.280, -1.608> <5.114, 2.296, -1.611> <5.117, 2.299, -1.602> 
		<5.121, 2.261, -1.618> <5.128, 2.266, -1.616> <5.137, 2.282, -1.619> <5.143, 2.283, -1.611> 
		<5.129, 2.250, -1.622> <5.136, 2.255, -1.620> <5.149, 2.266, -1.625> <5.155, 2.267, -1.617> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.096, 2.302, -1.597> <5.101, 2.308, -1.580> <5.109, 2.310, -1.552> <5.111, 2.301, -1.536> 
		<5.117, 2.299, -1.602> <5.122, 2.306, -1.585> <5.132, 2.307, -1.558> <5.135, 2.298, -1.541> 
		<5.143, 2.283, -1.611> <5.154, 2.286, -1.596> <5.165, 2.287, -1.569> <5.164, 2.280, -1.552> 
		<5.155, 2.267, -1.617> <5.166, 2.270, -1.603> <5.178, 2.269, -1.577> <5.178, 2.262, -1.559> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.111, 2.301, -1.536> <5.113, 2.296, -1.526> <5.111, 2.270, -1.523> <5.108, 2.266, -1.533> 
		<5.135, 2.298, -1.541> <5.136, 2.293, -1.532> <5.126, 2.268, -1.527> <5.123, 2.264, -1.537> 
		<5.164, 2.280, -1.552> <5.164, 2.276, -1.542> <5.150, 2.254, -1.536> <5.143, 2.252, -1.544> 
		<5.178, 2.262, -1.559> <5.177, 2.258, -1.549> <5.159, 2.241, -1.540> <5.152, 2.239, -1.548> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.108, 2.266, -1.533> <5.101, 2.257, -1.552> <5.095, 2.268, -1.584> <5.090, 2.269, -1.606> 
		<5.123, 2.264, -1.537> <5.117, 2.255, -1.556> <5.108, 2.267, -1.587> <5.103, 2.268, -1.609> 
		<5.143, 2.252, -1.544> <5.129, 2.248, -1.560> <5.127, 2.255, -1.594> <5.119, 2.258, -1.615> 
		<5.152, 2.239, -1.548> <5.138, 2.235, -1.565> <5.134, 2.245, -1.598> <5.127, 2.247, -1.619> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.044, 2.261, -1.601> <5.040, 2.268, -1.596> <5.029, 2.281, -1.595> <5.028, 2.284, -1.586> 
		<5.056, 2.269, -1.601> <5.051, 2.276, -1.597> <5.047, 2.294, -1.596> <5.045, 2.296, -1.587> 
		<5.076, 2.275, -1.605> <5.078, 2.283, -1.601> <5.073, 2.301, -1.600> <5.076, 2.304, -1.592> 
		<5.090, 2.273, -1.608> <5.092, 2.282, -1.605> <5.094, 2.298, -1.605> <5.096, 2.302, -1.597> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.028, 2.284, -1.586> <5.026, 2.288, -1.567> <5.028, 2.289, -1.539> <5.035, 2.281, -1.523> 
		<5.045, 2.296, -1.587> <5.043, 2.301, -1.568> <5.047, 2.303, -1.540> <5.054, 2.295, -1.524> 
		<5.076, 2.304, -1.592> <5.081, 2.311, -1.575> <5.085, 2.313, -1.546> <5.088, 2.304, -1.530> 
		<5.096, 2.302, -1.597> <5.101, 2.308, -1.580> <5.109, 2.310, -1.552> <5.111, 2.301, -1.536> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.035, 2.281, -1.523> <5.038, 2.276, -1.514> <5.054, 2.255, -1.514> <5.056, 2.252, -1.524> 
		<5.054, 2.295, -1.524> <5.058, 2.290, -1.515> <5.067, 2.265, -1.515> <5.069, 2.262, -1.525> 
		<5.088, 2.304, -1.530> <5.090, 2.299, -1.521> <5.095, 2.272, -1.519> <5.092, 2.268, -1.529> 
		<5.111, 2.301, -1.536> <5.113, 2.296, -1.526> <5.111, 2.270, -1.523> <5.108, 2.266, -1.533> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.056, 2.252, -1.524> <5.059, 2.246, -1.545> <5.049, 2.256, -1.576> <5.047, 2.258, -1.599> 
		<5.069, 2.262, -1.525> <5.072, 2.256, -1.546> <5.060, 2.264, -1.577> <5.058, 2.266, -1.599> 
		<5.092, 2.268, -1.529> <5.086, 2.259, -1.548> <5.082, 2.270, -1.580> <5.077, 2.271, -1.602> 
		<5.108, 2.266, -1.533> <5.101, 2.257, -1.552> <5.095, 2.268, -1.584> <5.090, 2.269, -1.606> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.019, 2.221, -1.604> <5.011, 2.222, -1.600> <4.994, 2.224, -1.599> <4.991, 2.223, -1.590> 
		<5.022, 2.235, -1.601> <5.013, 2.235, -1.597> <4.998, 2.245, -1.596> <4.995, 2.244, -1.587> 
		<5.033, 2.252, -1.600> <5.028, 2.259, -1.595> <5.012, 2.269, -1.594> <5.011, 2.271, -1.585> 
		<5.044, 2.261, -1.601> <5.040, 2.268, -1.596> <5.029, 2.281, -1.595> <5.028, 2.284, -1.586> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.991, 2.223, -1.590> <4.985, 2.221, -1.573> <4.983, 2.217, -1.544> <4.992, 2.212, -1.528> 
		<4.995, 2.244, -1.587> <4.988, 2.242, -1.569> <4.987, 2.240, -1.540> <4.996, 2.236, -1.524> 
		<5.011, 2.271, -1.585> <5.009, 2.276, -1.566> <5.008, 2.274, -1.537> <5.015, 2.266, -1.522> 
		<5.028, 2.284, -1.586> <5.026, 2.288, -1.567> <5.028, 2.289, -1.539> <5.035, 2.281, -1.523> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.992, 2.212, -1.528> <4.997, 2.210, -1.519> <5.023, 2.205, -1.518> <5.027, 2.206, -1.528> 
		<4.996, 2.236, -1.524> <5.001, 2.233, -1.515> <5.026, 2.221, -1.515> <5.030, 2.222, -1.525> 
		<5.015, 2.266, -1.522> <5.019, 2.262, -1.513> <5.041, 2.245, -1.513> <5.043, 2.242, -1.523> 
		<5.035, 2.281, -1.523> <5.038, 2.276, -1.514> <5.054, 2.255, -1.514> <5.056, 2.252, -1.524> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.027, 2.206, -1.528> <5.036, 2.208, -1.548> <5.024, 2.216, -1.579> <5.023, 2.220, -1.602> 
		<5.030, 2.222, -1.525> <5.038, 2.224, -1.546> <5.026, 2.229, -1.577> <5.025, 2.233, -1.599> 
		<5.043, 2.242, -1.523> <5.046, 2.236, -1.545> <5.039, 2.248, -1.576> <5.036, 2.250, -1.598> 
		<5.056, 2.252, -1.524> <5.059, 2.246, -1.545> <5.049, 2.256, -1.576> <5.047, 2.258, -1.599> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.029, 2.176, -1.616> <5.022, 2.170, -1.613> <5.008, 2.161, -1.616> <5.006, 2.156, -1.608> 
		<5.021, 2.187, -1.611> <5.014, 2.181, -1.609> <4.996, 2.178, -1.610> <4.994, 2.173, -1.602> 
		<5.017, 2.207, -1.606> <5.008, 2.208, -1.602> <4.990, 2.204, -1.603> <4.987, 2.203, -1.594> 
		<5.019, 2.221, -1.604> <5.011, 2.222, -1.600> <4.994, 2.224, -1.599> <4.991, 2.223, -1.590> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.006, 2.156, -1.608> <5.001, 2.147, -1.592> <5.001, 2.137, -1.565> <5.009, 2.136, -1.548> 
		<4.994, 2.173, -1.602> <4.989, 2.164, -1.586> <4.987, 2.155, -1.558> <4.996, 2.155, -1.541> 
		<4.987, 2.203, -1.594> <4.981, 2.201, -1.576> <4.979, 2.193, -1.548> <4.988, 2.189, -1.532> 
		<4.991, 2.223, -1.590> <4.985, 2.221, -1.573> <4.983, 2.217, -1.544> <4.992, 2.212, -1.528> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.009, 2.136, -1.548> <5.014, 2.136, -1.539> <5.035, 2.149, -1.533> <5.038, 2.155, -1.541> 
		<4.996, 2.155, -1.541> <5.000, 2.155, -1.532> <5.026, 2.162, -1.528> <5.029, 2.167, -1.536> 
		<4.988, 2.189, -1.532> <4.993, 2.186, -1.523> <5.020, 2.189, -1.521> <5.024, 2.190, -1.530> 
		<4.992, 2.212, -1.528> <4.997, 2.210, -1.519> <5.023, 2.205, -1.518> <5.027, 2.206, -1.528> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.038, 2.155, -1.541> <5.045, 2.166, -1.559> <5.034, 2.170, -1.591> <5.032, 2.177, -1.613> 
		<5.029, 2.167, -1.536> <5.036, 2.179, -1.555> <5.027, 2.181, -1.587> <5.025, 2.188, -1.609> 
		<5.024, 2.190, -1.530> <5.033, 2.192, -1.551> <5.022, 2.203, -1.582> <5.021, 2.207, -1.604> 
		<5.027, 2.206, -1.528> <5.036, 2.208, -1.548> <5.024, 2.216, -1.579> <5.023, 2.220, -1.602> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.400, 2.369, -1.242> <3.399, 2.359, -1.242> <3.395, 2.344, -1.248> <3.396, 2.338, -1.242> 
		<3.387, 2.371, -1.239> <3.385, 2.361, -1.239> <3.375, 2.347, -1.243> <3.376, 2.340, -1.237> 
		<3.369, 2.381, -1.233> <3.362, 2.375, -1.231> <3.352, 2.360, -1.235> <3.350, 2.356, -1.227> 
		<3.361, 2.392, -1.229> <3.354, 2.386, -1.226> <3.340, 2.377, -1.229> <3.338, 2.372, -1.221> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.396, 2.338, -1.242> <3.398, 2.324, -1.228> <3.403, 2.311, -1.203> <3.407, 2.313, -1.185> 
		<3.376, 2.340, -1.237> <3.377, 2.327, -1.223> <3.379, 2.314, -1.197> <3.384, 2.316, -1.179> 
		<3.350, 2.356, -1.227> <3.345, 2.346, -1.212> <3.346, 2.334, -1.186> <3.355, 2.333, -1.168> 
		<3.338, 2.372, -1.221> <3.333, 2.363, -1.205> <3.333, 2.353, -1.178> <3.341, 2.352, -1.161> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.407, 2.313, -1.185> <3.410, 2.314, -1.175> <3.416, 2.336, -1.163> <3.415, 2.344, -1.170> 
		<3.384, 2.316, -1.179> <3.387, 2.317, -1.169> <3.400, 2.338, -1.159> <3.399, 2.346, -1.166> 
		<3.355, 2.333, -1.168> <3.359, 2.333, -1.159> <3.376, 2.352, -1.151> <3.379, 2.358, -1.159> 
		<3.341, 2.352, -1.161> <3.346, 2.352, -1.152> <3.367, 2.365, -1.146> <3.370, 2.371, -1.154> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.415, 2.344, -1.170> <3.414, 2.360, -1.185> <3.406, 2.363, -1.218> <3.402, 2.371, -1.239> 
		<3.399, 2.346, -1.166> <3.398, 2.362, -1.181> <3.393, 2.365, -1.215> <3.389, 2.373, -1.236> 
		<3.379, 2.358, -1.159> <3.386, 2.369, -1.177> <3.374, 2.376, -1.208> <3.372, 2.383, -1.230> 
		<3.370, 2.371, -1.154> <3.377, 2.382, -1.172> <3.366, 2.386, -1.204> <3.364, 2.393, -1.226> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.446, 2.381, -1.250> <3.451, 2.373, -1.251> <3.460, 2.361, -1.259> <3.464, 2.356, -1.253> 
		<3.434, 2.372, -1.249> <3.440, 2.365, -1.250> <3.443, 2.348, -1.258> <3.447, 2.343, -1.252> 
		<3.414, 2.367, -1.246> <3.413, 2.358, -1.246> <3.416, 2.341, -1.254> <3.417, 2.335, -1.247> 
		<3.400, 2.369, -1.242> <3.399, 2.359, -1.242> <3.395, 2.344, -1.248> <3.396, 2.338, -1.242> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.464, 2.356, -1.253> <3.473, 2.344, -1.241> <3.483, 2.333, -1.216> <3.484, 2.333, -1.197> 
		<3.447, 2.343, -1.252> <3.456, 2.332, -1.240> <3.464, 2.318, -1.215> <3.465, 2.319, -1.196> 
		<3.417, 2.335, -1.247> <3.418, 2.322, -1.233> <3.426, 2.308, -1.209> <3.431, 2.310, -1.191> 
		<3.396, 2.338, -1.242> <3.398, 2.324, -1.228> <3.403, 2.311, -1.203> <3.407, 2.313, -1.185> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.484, 2.333, -1.197> <3.485, 2.333, -1.187> <3.472, 2.351, -1.172> <3.467, 2.358, -1.179> 
		<3.465, 2.319, -1.196> <3.465, 2.319, -1.186> <3.459, 2.341, -1.171> <3.454, 2.348, -1.178> 
		<3.431, 2.310, -1.191> <3.433, 2.311, -1.180> <3.432, 2.334, -1.167> <3.431, 2.342, -1.174> 
		<3.407, 2.313, -1.185> <3.410, 2.314, -1.175> <3.416, 2.336, -1.163> <3.415, 2.344, -1.170> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.467, 2.358, -1.179> <3.456, 2.372, -1.192> <3.451, 2.375, -1.226> <3.444, 2.383, -1.246> 
		<3.454, 2.348, -1.178> <3.443, 2.362, -1.192> <3.440, 2.367, -1.225> <3.434, 2.375, -1.245> 
		<3.431, 2.342, -1.174> <3.429, 2.358, -1.189> <3.419, 2.361, -1.221> <3.414, 2.369, -1.242> 
		<3.415, 2.344, -1.170> <3.414, 2.360, -1.185> <3.406, 2.363, -1.218> <3.402, 2.371, -1.239> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.471, 2.421, -1.247> <3.480, 2.419, -1.247> <3.495, 2.418, -1.255> <3.502, 2.416, -1.248> 
		<3.468, 2.407, -1.249> <3.477, 2.406, -1.250> <3.491, 2.397, -1.258> <3.498, 2.395, -1.252> 
		<3.457, 2.389, -1.251> <3.463, 2.382, -1.251> <3.477, 2.374, -1.260> <3.481, 2.368, -1.254> 
		<3.446, 2.381, -1.250> <3.451, 2.373, -1.251> <3.460, 2.361, -1.259> <3.464, 2.356, -1.253> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.502, 2.416, -1.248> <3.515, 2.411, -1.235> <3.528, 2.404, -1.211> <3.527, 2.401, -1.192> 
		<3.498, 2.395, -1.252> <3.511, 2.390, -1.239> <3.524, 2.381, -1.215> <3.523, 2.378, -1.196> 
		<3.481, 2.368, -1.254> <3.490, 2.357, -1.242> <3.503, 2.347, -1.218> <3.504, 2.348, -1.199> 
		<3.464, 2.356, -1.253> <3.473, 2.344, -1.241> <3.483, 2.333, -1.216> <3.484, 2.333, -1.197> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.527, 2.401, -1.192> <3.526, 2.400, -1.182> <3.504, 2.401, -1.168> <3.496, 2.404, -1.175> 
		<3.523, 2.378, -1.196> <3.522, 2.376, -1.186> <3.501, 2.385, -1.171> <3.493, 2.388, -1.178> 
		<3.504, 2.348, -1.199> <3.504, 2.348, -1.188> <3.486, 2.361, -1.173> <3.480, 2.367, -1.179> 
		<3.484, 2.333, -1.197> <3.485, 2.333, -1.187> <3.472, 2.351, -1.172> <3.467, 2.358, -1.179> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.496, 2.404, -1.175> <3.479, 2.409, -1.189> <3.476, 2.416, -1.223> <3.468, 2.421, -1.243> 
		<3.493, 2.388, -1.178> <3.477, 2.393, -1.192> <3.474, 2.403, -1.225> <3.466, 2.408, -1.245> 
		<3.480, 2.367, -1.179> <3.469, 2.381, -1.193> <3.462, 2.383, -1.226> <3.455, 2.391, -1.247> 
		<3.467, 2.358, -1.179> <3.456, 2.372, -1.192> <3.451, 2.375, -1.226> <3.444, 2.383, -1.246> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.461, 2.466, -1.235> <3.468, 2.471, -1.234> <3.481, 2.482, -1.238> <3.487, 2.483, -1.230> 
		<3.469, 2.455, -1.239> <3.476, 2.460, -1.238> <3.493, 2.465, -1.244> <3.499, 2.466, -1.237> 
		<3.473, 2.435, -1.244> <3.482, 2.433, -1.245> <3.499, 2.439, -1.251> <3.505, 2.436, -1.245> 
		<3.471, 2.421, -1.247> <3.480, 2.419, -1.247> <3.495, 2.418, -1.255> <3.502, 2.416, -1.248> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.487, 2.483, -1.230> <3.498, 2.486, -1.216> <3.510, 2.485, -1.190> <3.510, 2.478, -1.172> 
		<3.499, 2.466, -1.237> <3.510, 2.469, -1.222> <3.524, 2.466, -1.197> <3.523, 2.459, -1.179> 
		<3.505, 2.436, -1.245> <3.518, 2.432, -1.232> <3.532, 2.428, -1.207> <3.531, 2.425, -1.188> 
		<3.502, 2.416, -1.248> <3.515, 2.411, -1.235> <3.528, 2.404, -1.211> <3.527, 2.401, -1.192> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.510, 2.478, -1.172> <3.510, 2.474, -1.162> <3.491, 2.457, -1.153> <3.485, 2.455, -1.161> 
		<3.523, 2.459, -1.179> <3.523, 2.455, -1.169> <3.500, 2.445, -1.158> <3.494, 2.443, -1.166> 
		<3.531, 2.425, -1.188> <3.530, 2.423, -1.178> <3.506, 2.417, -1.166> <3.499, 2.420, -1.172> 
		<3.527, 2.401, -1.192> <3.526, 2.400, -1.182> <3.504, 2.401, -1.168> <3.496, 2.404, -1.175> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.485, 2.455, -1.161> <3.470, 2.451, -1.178> <3.466, 2.461, -1.211> <3.459, 2.463, -1.232> 
		<3.494, 2.443, -1.166> <3.479, 2.439, -1.183> <3.474, 2.450, -1.215> <3.466, 2.453, -1.236> 
		<3.499, 2.420, -1.172> <3.482, 2.425, -1.187> <3.479, 2.429, -1.220> <3.471, 2.434, -1.241> 
		<3.496, 2.404, -1.175> <3.479, 2.409, -1.189> <3.476, 2.416, -1.223> <3.468, 2.421, -1.243> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.422, 2.489, -1.221> <3.424, 2.498, -1.218> <3.426, 2.514, -1.218> <3.428, 2.518, -1.210> 
		<3.435, 2.487, -1.225> <3.437, 2.496, -1.221> <3.446, 2.512, -1.224> <3.449, 2.515, -1.215> 
		<3.453, 2.477, -1.231> <3.460, 2.482, -1.229> <3.469, 2.498, -1.232> <3.475, 2.499, -1.224> 
		<3.461, 2.466, -1.235> <3.468, 2.471, -1.234> <3.481, 2.482, -1.238> <3.487, 2.483, -1.230> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.428, 2.518, -1.210> <3.433, 2.524, -1.193> <3.441, 2.526, -1.165> <3.444, 2.517, -1.149> 
		<3.449, 2.515, -1.215> <3.454, 2.522, -1.198> <3.464, 2.523, -1.171> <3.467, 2.514, -1.155> 
		<3.475, 2.499, -1.224> <3.486, 2.502, -1.209> <3.497, 2.503, -1.182> <3.496, 2.496, -1.165> 
		<3.487, 2.483, -1.230> <3.498, 2.486, -1.216> <3.510, 2.485, -1.190> <3.510, 2.478, -1.172> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.444, 2.517, -1.149> <3.445, 2.512, -1.140> <3.443, 2.486, -1.136> <3.440, 2.482, -1.146> 
		<3.467, 2.514, -1.155> <3.468, 2.509, -1.145> <3.458, 2.484, -1.140> <3.455, 2.480, -1.150> 
		<3.496, 2.496, -1.165> <3.496, 2.492, -1.155> <3.482, 2.470, -1.149> <3.475, 2.468, -1.157> 
		<3.510, 2.478, -1.172> <3.510, 2.474, -1.162> <3.491, 2.457, -1.153> <3.485, 2.455, -1.161> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.440, 2.482, -1.146> <3.434, 2.473, -1.165> <3.427, 2.484, -1.197> <3.422, 2.485, -1.219> 
		<3.455, 2.480, -1.150> <3.449, 2.471, -1.169> <3.440, 2.483, -1.200> <3.435, 2.484, -1.222> 
		<3.475, 2.468, -1.157> <3.461, 2.464, -1.174> <3.459, 2.471, -1.207> <3.451, 2.474, -1.228> 
		<3.485, 2.455, -1.161> <3.470, 2.451, -1.178> <3.466, 2.461, -1.211> <3.459, 2.463, -1.232> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.376, 2.477, -1.214> <3.372, 2.484, -1.209> <3.362, 2.497, -1.208> <3.360, 2.500, -1.199> 
		<3.388, 2.485, -1.214> <3.383, 2.492, -1.210> <3.379, 2.510, -1.209> <3.378, 2.512, -1.200> 
		<3.408, 2.491, -1.218> <3.410, 2.499, -1.214> <3.405, 2.517, -1.213> <3.408, 2.520, -1.205> 
		<3.422, 2.489, -1.221> <3.424, 2.498, -1.218> <3.426, 2.514, -1.218> <3.428, 2.518, -1.210> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.360, 2.500, -1.199> <3.358, 2.504, -1.180> <3.360, 2.505, -1.152> <3.367, 2.497, -1.136> 
		<3.378, 2.512, -1.200> <3.375, 2.517, -1.181> <3.379, 2.519, -1.153> <3.386, 2.511, -1.137> 
		<3.408, 2.520, -1.205> <3.413, 2.527, -1.188> <3.417, 2.529, -1.159> <3.420, 2.520, -1.143> 
		<3.428, 2.518, -1.210> <3.433, 2.524, -1.193> <3.441, 2.526, -1.165> <3.444, 2.517, -1.149> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.367, 2.497, -1.136> <3.371, 2.492, -1.127> <3.386, 2.471, -1.127> <3.388, 2.468, -1.137> 
		<3.386, 2.511, -1.137> <3.390, 2.506, -1.128> <3.399, 2.481, -1.128> <3.401, 2.478, -1.138> 
		<3.420, 2.520, -1.143> <3.422, 2.515, -1.134> <3.427, 2.488, -1.132> <3.424, 2.484, -1.142> 
		<3.444, 2.517, -1.149> <3.445, 2.512, -1.140> <3.443, 2.486, -1.136> <3.440, 2.482, -1.146> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.388, 2.468, -1.137> <3.391, 2.462, -1.158> <3.381, 2.472, -1.189> <3.379, 2.474, -1.212> 
		<3.401, 2.478, -1.138> <3.404, 2.472, -1.159> <3.392, 2.480, -1.190> <3.390, 2.482, -1.212> 
		<3.424, 2.484, -1.142> <3.418, 2.475, -1.161> <3.414, 2.486, -1.193> <3.409, 2.487, -1.215> 
		<3.440, 2.482, -1.146> <3.434, 2.473, -1.165> <3.427, 2.484, -1.197> <3.422, 2.485, -1.219> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.351, 2.437, -1.217> <3.343, 2.438, -1.213> <3.326, 2.440, -1.212> <3.323, 2.439, -1.203> 
		<3.354, 2.451, -1.214> <3.345, 2.451, -1.210> <3.330, 2.461, -1.209> <3.327, 2.460, -1.200> 
		<3.365, 2.468, -1.213> <3.360, 2.475, -1.208> <3.344, 2.485, -1.207> <3.343, 2.487, -1.198> 
		<3.376, 2.477, -1.214> <3.372, 2.484, -1.209> <3.362, 2.497, -1.208> <3.360, 2.500, -1.199> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.323, 2.439, -1.203> <3.317, 2.437, -1.186> <3.315, 2.433, -1.157> <3.324, 2.428, -1.141> 
		<3.327, 2.460, -1.200> <3.320, 2.458, -1.182> <3.319, 2.456, -1.153> <3.328, 2.452, -1.137> 
		<3.343, 2.487, -1.198> <3.341, 2.492, -1.179> <3.340, 2.490, -1.150> <3.347, 2.482, -1.135> 
		<3.360, 2.500, -1.199> <3.358, 2.504, -1.180> <3.360, 2.505, -1.152> <3.367, 2.497, -1.136> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.324, 2.428, -1.141> <3.329, 2.426, -1.132> <3.355, 2.421, -1.131> <3.359, 2.422, -1.141> 
		<3.328, 2.452, -1.137> <3.334, 2.449, -1.128> <3.358, 2.437, -1.128> <3.362, 2.438, -1.138> 
		<3.347, 2.482, -1.135> <3.351, 2.478, -1.126> <3.373, 2.461, -1.126> <3.375, 2.458, -1.136> 
		<3.367, 2.497, -1.136> <3.371, 2.492, -1.127> <3.386, 2.471, -1.127> <3.388, 2.468, -1.137> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.359, 2.422, -1.141> <3.368, 2.424, -1.161> <3.356, 2.432, -1.192> <3.355, 2.436, -1.215> 
		<3.362, 2.438, -1.138> <3.370, 2.440, -1.159> <3.359, 2.445, -1.190> <3.357, 2.449, -1.212> 
		<3.375, 2.458, -1.136> <3.378, 2.452, -1.158> <3.371, 2.464, -1.189> <3.368, 2.466, -1.211> 
		<3.388, 2.468, -1.137> <3.391, 2.462, -1.158> <3.381, 2.472, -1.189> <3.379, 2.474, -1.212> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.361, 2.392, -1.229> <3.354, 2.386, -1.226> <3.340, 2.377, -1.229> <3.338, 2.372, -1.221> 
		<3.353, 2.403, -1.224> <3.346, 2.397, -1.222> <3.328, 2.394, -1.223> <3.326, 2.389, -1.215> 
		<3.349, 2.423, -1.219> <3.340, 2.424, -1.215> <3.322, 2.420, -1.216> <3.319, 2.419, -1.207> 
		<3.351, 2.437, -1.217> <3.343, 2.438, -1.213> <3.326, 2.440, -1.212> <3.323, 2.439, -1.203> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.338, 2.372, -1.221> <3.333, 2.363, -1.205> <3.333, 2.353, -1.178> <3.341, 2.352, -1.161> 
		<3.326, 2.389, -1.215> <3.321, 2.380, -1.199> <3.319, 2.371, -1.171> <3.328, 2.371, -1.154> 
		<3.319, 2.419, -1.207> <3.313, 2.417, -1.189> <3.311, 2.409, -1.161> <3.320, 2.405, -1.145> 
		<3.323, 2.439, -1.203> <3.317, 2.437, -1.186> <3.315, 2.433, -1.157> <3.324, 2.428, -1.141> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.341, 2.352, -1.161> <3.346, 2.352, -1.152> <3.367, 2.365, -1.146> <3.370, 2.371, -1.154> 
		<3.328, 2.371, -1.154> <3.332, 2.371, -1.145> <3.358, 2.378, -1.141> <3.361, 2.383, -1.149> 
		<3.320, 2.405, -1.145> <3.325, 2.402, -1.136> <3.352, 2.405, -1.134> <3.356, 2.406, -1.143> 
		<3.324, 2.428, -1.141> <3.329, 2.426, -1.132> <3.355, 2.421, -1.131> <3.359, 2.422, -1.141> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.370, 2.371, -1.154> <3.377, 2.382, -1.172> <3.366, 2.386, -1.204> <3.364, 2.393, -1.226> 
		<3.361, 2.383, -1.149> <3.368, 2.395, -1.168> <3.359, 2.397, -1.200> <3.357, 2.404, -1.222> 
		<3.356, 2.406, -1.143> <3.365, 2.408, -1.164> <3.354, 2.419, -1.195> <3.353, 2.423, -1.217> 
		<3.359, 2.422, -1.141> <3.368, 2.424, -1.161> <3.356, 2.432, -1.192> <3.355, 2.436, -1.215> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.168, 2.056, -1.477> <5.167, 2.052, -1.459> <5.180, 2.047, -1.429> <5.167, 2.041, -1.418> 
		<5.166, 2.032, -1.481> <5.166, 2.027, -1.464> <5.178, 2.010, -1.437> <5.165, 2.004, -1.425> 
		<5.162, 2.002, -1.504> <5.160, 1.987, -1.494> <5.171, 1.970, -1.466> <5.158, 1.959, -1.459> 
		<5.158, 1.989, -1.525> <5.156, 1.975, -1.515> <5.165, 1.951, -1.498> <5.152, 1.941, -1.491> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.167, 2.041, -1.418> <5.144, 2.031, -1.396> <5.099, 2.017, -1.376> <5.067, 2.013, -1.382> 
		<5.165, 2.004, -1.425> <5.142, 1.994, -1.404> <5.096, 1.975, -1.384> <5.064, 1.971, -1.391> 
		<5.158, 1.959, -1.459> <5.134, 1.939, -1.446> <5.091, 1.918, -1.427> <5.057, 1.920, -1.429> 
		<5.152, 1.941, -1.491> <5.128, 1.920, -1.478> <5.084, 1.897, -1.463> <5.050, 1.899, -1.466> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.067, 2.013, -1.382> <5.047, 2.010, -1.387> <5.027, 2.017, -1.430> <5.040, 2.023, -1.444> 
		<5.064, 1.971, -1.391> <5.045, 1.968, -1.395> <5.025, 1.989, -1.436> <5.039, 1.995, -1.450> 
		<5.057, 1.920, -1.429> <5.038, 1.921, -1.431> <5.021, 1.949, -1.468> <5.033, 1.960, -1.476> 
		<5.050, 1.899, -1.466> <5.031, 1.900, -1.467> <5.016, 1.934, -1.493> <5.029, 1.946, -1.500> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.040, 2.023, -1.444> <5.066, 2.035, -1.471> <5.125, 2.046, -1.470> <5.161, 2.056, -1.482> 
		<5.039, 1.995, -1.450> <5.064, 2.007, -1.477> <5.124, 2.023, -1.475> <5.160, 2.033, -1.486> 
		<5.033, 1.960, -1.476> <5.060, 1.985, -1.492> <5.119, 1.990, -1.500> <5.156, 2.004, -1.508> 
		<5.029, 1.946, -1.500> <5.056, 1.971, -1.517> <5.115, 1.979, -1.520> <5.152, 1.993, -1.528> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.166, 2.138, -1.495> <5.165, 2.146, -1.480> <5.178, 2.162, -1.456> <5.164, 2.164, -1.446> 
		<5.168, 2.118, -1.481> <5.168, 2.125, -1.466> <5.181, 2.132, -1.434> <5.168, 2.133, -1.424> 
		<5.169, 2.081, -1.472> <5.169, 2.076, -1.454> <5.182, 2.084, -1.422> <5.169, 2.078, -1.410> 
		<5.168, 2.056, -1.477> <5.167, 2.052, -1.459> <5.180, 2.047, -1.429> <5.167, 2.041, -1.418> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.164, 2.164, -1.446> <5.140, 2.167, -1.426> <5.093, 2.163, -1.410> <5.064, 2.152, -1.414> 
		<5.168, 2.133, -1.424> <5.143, 2.137, -1.404> <5.097, 2.128, -1.385> <5.068, 2.117, -1.389> 
		<5.169, 2.078, -1.410> <5.146, 2.068, -1.389> <5.101, 2.059, -1.367> <5.069, 2.055, -1.374> 
		<5.167, 2.041, -1.418> <5.144, 2.031, -1.396> <5.099, 2.017, -1.376> <5.067, 2.013, -1.382> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.064, 2.152, -1.414> <5.045, 2.145, -1.417> <5.023, 2.120, -1.453> <5.038, 2.117, -1.466> 
		<5.068, 2.117, -1.389> <5.049, 2.110, -1.392> <5.026, 2.097, -1.436> <5.041, 2.094, -1.449> 
		<5.069, 2.055, -1.374> <5.049, 2.052, -1.378> <5.028, 2.045, -1.424> <5.042, 2.051, -1.438> 
		<5.067, 2.013, -1.382> <5.047, 2.010, -1.387> <5.027, 2.017, -1.430> <5.040, 2.023, -1.444> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.038, 2.117, -1.466> <5.066, 2.112, -1.491> <5.123, 2.129, -1.489> <5.160, 2.134, -1.500> 
		<5.041, 2.094, -1.449> <5.069, 2.089, -1.474> <5.125, 2.110, -1.475> <5.162, 2.115, -1.486> 
		<5.042, 2.051, -1.438> <5.068, 2.063, -1.466> <5.126, 2.070, -1.466> <5.163, 2.080, -1.477> 
		<5.040, 2.023, -1.444> <5.066, 2.035, -1.471> <5.125, 2.046, -1.470> <5.161, 2.056, -1.482> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.153, 2.187, -1.571> <5.151, 2.202, -1.567> <5.160, 2.231, -1.562> <5.146, 2.237, -1.559> 
		<5.158, 2.181, -1.545> <5.156, 2.196, -1.541> <5.167, 2.222, -1.523> <5.153, 2.229, -1.520> 
		<5.163, 2.160, -1.511> <5.163, 2.168, -1.496> <5.174, 2.195, -1.480> <5.161, 2.197, -1.469> 
		<5.166, 2.138, -1.495> <5.165, 2.146, -1.480> <5.178, 2.162, -1.456> <5.164, 2.164, -1.446> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.146, 2.237, -1.559> <5.118, 2.249, -1.552> <5.071, 2.249, -1.544> <5.043, 2.235, -1.543> 
		<5.153, 2.229, -1.520> <5.125, 2.241, -1.512> <5.078, 2.239, -1.500> <5.050, 2.225, -1.498> 
		<5.161, 2.197, -1.469> <5.136, 2.200, -1.450> <5.089, 2.200, -1.437> <5.060, 2.189, -1.441> 
		<5.164, 2.164, -1.446> <5.140, 2.167, -1.426> <5.093, 2.163, -1.410> <5.064, 2.152, -1.414> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.043, 2.235, -1.543> <5.026, 2.226, -1.542> <5.007, 2.182, -1.548> <5.024, 2.173, -1.553> 
		<5.050, 2.225, -1.498> <5.033, 2.216, -1.497> <5.012, 2.175, -1.518> <5.029, 2.167, -1.522> 
		<5.060, 2.189, -1.441> <5.041, 2.182, -1.444> <5.021, 2.145, -1.471> <5.035, 2.143, -1.484> 
		<5.064, 2.152, -1.414> <5.045, 2.145, -1.417> <5.023, 2.120, -1.453> <5.038, 2.117, -1.466> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.024, 2.173, -1.553> <5.056, 2.157, -1.561> <5.111, 2.178, -1.566> <5.148, 2.180, -1.571> 
		<5.029, 2.167, -1.522> <5.062, 2.150, -1.531> <5.115, 2.173, -1.541> <5.152, 2.175, -1.546> 
		<5.035, 2.143, -1.484> <5.064, 2.137, -1.509> <5.121, 2.150, -1.504> <5.157, 2.155, -1.515> 
		<5.038, 2.117, -1.466> <5.066, 2.112, -1.491> <5.123, 2.129, -1.489> <5.160, 2.134, -1.500> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.138, 2.174, -1.659> <5.133, 2.187, -1.668> <5.138, 2.213, -1.687> <5.122, 2.218, -1.691> 
		<5.142, 2.187, -1.636> <5.137, 2.201, -1.645> <5.144, 2.233, -1.652> <5.129, 2.238, -1.656> 
		<5.149, 2.193, -1.597> <5.147, 2.208, -1.593> <5.153, 2.240, -1.602> <5.139, 2.246, -1.598> 
		<5.153, 2.187, -1.571> <5.151, 2.202, -1.567> <5.160, 2.231, -1.562> <5.146, 2.237, -1.559> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.122, 2.218, -1.691> <5.093, 2.227, -1.699> <5.043, 2.227, -1.701> <5.016, 2.213, -1.692> 
		<5.129, 2.238, -1.656> <5.099, 2.247, -1.664> <5.051, 2.250, -1.662> <5.023, 2.236, -1.653> 
		<5.139, 2.246, -1.598> <5.111, 2.258, -1.591> <5.063, 2.259, -1.588> <5.035, 2.245, -1.587> 
		<5.146, 2.237, -1.559> <5.118, 2.249, -1.552> <5.071, 2.249, -1.544> <5.043, 2.235, -1.543> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.016, 2.213, -1.692> <4.999, 2.204, -1.687> <4.988, 2.165, -1.659> <5.006, 2.159, -1.654> 
		<5.023, 2.236, -1.653> <5.006, 2.227, -1.647> <4.993, 2.181, -1.633> <5.011, 2.174, -1.627> 
		<5.035, 2.245, -1.587> <5.018, 2.236, -1.586> <5.002, 2.189, -1.578> <5.019, 2.180, -1.583> 
		<5.043, 2.235, -1.543> <5.026, 2.226, -1.542> <5.007, 2.182, -1.548> <5.024, 2.173, -1.553> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.006, 2.159, -1.654> <5.040, 2.145, -1.643> <5.095, 2.165, -1.654> <5.133, 2.168, -1.655> 
		<5.011, 2.174, -1.627> <5.045, 2.161, -1.616> <5.099, 2.178, -1.633> <5.137, 2.181, -1.633> 
		<5.019, 2.180, -1.583> <5.051, 2.163, -1.591> <5.106, 2.184, -1.590> <5.144, 2.186, -1.596> 
		<5.024, 2.173, -1.553> <5.056, 2.157, -1.561> <5.111, 2.178, -1.566> <5.148, 2.180, -1.571> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.128, 2.107, -1.708> <5.122, 2.110, -1.725> <5.124, 2.118, -1.756> <5.107, 2.117, -1.764> 
		<5.129, 2.131, -1.703> <5.123, 2.135, -1.720> <5.126, 2.155, -1.748> <5.109, 2.154, -1.757> 
		<5.134, 2.161, -1.680> <5.129, 2.175, -1.690> <5.132, 2.194, -1.719> <5.116, 2.199, -1.723> 
		<5.138, 2.174, -1.659> <5.133, 2.187, -1.668> <5.138, 2.213, -1.687> <5.122, 2.218, -1.691> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.107, 2.117, -1.764> <5.078, 2.115, -1.780> <5.028, 2.108, -1.789> <4.999, 2.099, -1.775> 
		<5.109, 2.154, -1.757> <5.080, 2.152, -1.772> <5.030, 2.150, -1.781> <5.001, 2.141, -1.767> 
		<5.116, 2.199, -1.723> <5.087, 2.209, -1.731> <5.037, 2.206, -1.737> <5.009, 2.192, -1.728> 
		<5.122, 2.218, -1.691> <5.093, 2.227, -1.699> <5.043, 2.227, -1.701> <5.016, 2.213, -1.692> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.999, 2.099, -1.775> <4.981, 2.093, -1.767> <4.977, 2.081, -1.720> <4.994, 2.081, -1.710> 
		<5.001, 2.141, -1.767> <4.984, 2.135, -1.758> <4.978, 2.109, -1.715> <4.996, 2.110, -1.704> 
		<5.009, 2.192, -1.728> <4.992, 2.183, -1.723> <4.983, 2.151, -1.684> <5.001, 2.144, -1.678> 
		<5.016, 2.213, -1.692> <4.999, 2.204, -1.687> <4.988, 2.165, -1.659> <5.006, 2.159, -1.654> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.994, 2.081, -1.710> <5.028, 2.083, -1.690> <5.085, 2.098, -1.704> <5.124, 2.105, -1.701> 
		<4.996, 2.110, -1.704> <5.030, 2.111, -1.684> <5.086, 2.121, -1.699> <5.125, 2.128, -1.696> 
		<5.001, 2.144, -1.678> <5.035, 2.131, -1.667> <5.091, 2.153, -1.675> <5.129, 2.156, -1.675> 
		<5.006, 2.159, -1.654> <5.040, 2.145, -1.643> <5.095, 2.165, -1.654> <5.133, 2.168, -1.655> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.130, 2.025, -1.689> <5.124, 2.016, -1.703> <5.125, 2.002, -1.730> <5.110, 1.994, -1.736> 
		<5.127, 2.045, -1.704> <5.121, 2.036, -1.718> <5.122, 2.033, -1.752> <5.107, 2.025, -1.758> 
		<5.126, 2.082, -1.713> <5.120, 2.085, -1.730> <5.122, 2.081, -1.763> <5.105, 2.080, -1.772> 
		<5.128, 2.107, -1.708> <5.122, 2.110, -1.725> <5.124, 2.118, -1.756> <5.107, 2.117, -1.764> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.110, 1.994, -1.736> <5.082, 1.980, -1.748> <5.033, 1.962, -1.757> <5.002, 1.960, -1.743> 
		<5.107, 2.025, -1.758> <5.078, 2.010, -1.770> <5.030, 1.996, -1.782> <4.998, 1.994, -1.768> 
		<5.105, 2.080, -1.772> <5.076, 2.078, -1.787> <5.025, 2.066, -1.798> <4.997, 2.057, -1.784> 
		<5.107, 2.117, -1.764> <5.078, 2.115, -1.780> <5.028, 2.108, -1.789> <4.999, 2.099, -1.775> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.002, 1.960, -1.743> <4.985, 1.959, -1.736> <4.981, 1.979, -1.696> <4.996, 1.987, -1.688> 
		<4.998, 1.994, -1.768> <4.981, 1.993, -1.761> <4.979, 2.003, -1.713> <4.994, 2.011, -1.705> 
		<4.997, 2.057, -1.784> <4.979, 2.051, -1.775> <4.975, 2.052, -1.726> <4.993, 2.053, -1.716> 
		<4.999, 2.099, -1.775> <4.981, 2.093, -1.767> <4.977, 2.081, -1.720> <4.994, 2.081, -1.710> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<4.996, 1.987, -1.688> <5.029, 2.005, -1.672> <5.087, 2.015, -1.685> <5.125, 2.027, -1.683> 
		<4.994, 2.011, -1.705> <5.027, 2.028, -1.689> <5.084, 2.034, -1.699> <5.123, 2.046, -1.697> 
		<4.993, 2.053, -1.716> <5.027, 2.055, -1.696> <5.084, 2.074, -1.709> <5.122, 2.081, -1.706> 
		<4.994, 2.081, -1.710> <5.028, 2.083, -1.690> <5.085, 2.098, -1.704> <5.124, 2.105, -1.701> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.142, 1.976, -1.613> <5.138, 1.960, -1.616> <5.142, 1.932, -1.623> <5.129, 1.921, -1.623> 
		<5.137, 1.982, -1.640> <5.133, 1.966, -1.642> <5.135, 1.941, -1.662> <5.122, 1.930, -1.662> 
		<5.132, 2.003, -1.673> <5.126, 1.994, -1.687> <5.128, 1.969, -1.706> <5.114, 1.961, -1.712> 
		<5.130, 2.025, -1.689> <5.124, 2.016, -1.703> <5.125, 2.002, -1.730> <5.110, 1.994, -1.736> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.129, 1.921, -1.623> <5.102, 1.899, -1.623> <5.057, 1.874, -1.621> <5.023, 1.877, -1.615> 
		<5.122, 1.930, -1.662> <5.095, 1.908, -1.663> <5.049, 1.884, -1.666> <5.015, 1.887, -1.660> 
		<5.114, 1.961, -1.712> <5.085, 1.947, -1.724> <5.037, 1.924, -1.730> <5.006, 1.922, -1.716> 
		<5.110, 1.994, -1.736> <5.082, 1.980, -1.748> <5.033, 1.962, -1.757> <5.002, 1.960, -1.743> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.023, 1.877, -1.615> <5.006, 1.878, -1.612> <4.998, 1.920, -1.602> <5.011, 1.931, -1.602> 
		<5.015, 1.887, -1.660> <4.998, 1.888, -1.657> <4.993, 1.926, -1.632> <5.005, 1.938, -1.632> 
		<5.006, 1.922, -1.716> <4.989, 1.921, -1.709> <4.984, 1.954, -1.677> <4.999, 1.962, -1.670> 
		<5.002, 1.960, -1.743> <4.985, 1.959, -1.736> <4.981, 1.979, -1.696> <4.996, 1.987, -1.688> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.011, 1.931, -1.602> <5.041, 1.959, -1.601> <5.099, 1.966, -1.609> <5.137, 1.980, -1.612> 
		<5.005, 1.938, -1.632> <5.036, 1.965, -1.631> <5.095, 1.971, -1.634> <5.133, 1.986, -1.637> 
		<4.999, 1.962, -1.670> <5.032, 1.980, -1.654> <5.089, 1.994, -1.670> <5.127, 2.006, -1.668> 
		<4.996, 1.987, -1.688> <5.029, 2.005, -1.672> <5.087, 2.015, -1.685> <5.125, 2.027, -1.683> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.158, 1.989, -1.525> <5.156, 1.975, -1.515> <5.165, 1.951, -1.498> <5.152, 1.941, -1.491> 
		<5.153, 1.976, -1.549> <5.152, 1.961, -1.538> <5.158, 1.931, -1.533> <5.146, 1.920, -1.526> 
		<5.146, 1.971, -1.587> <5.142, 1.954, -1.590> <5.148, 1.924, -1.584> <5.135, 1.913, -1.584> 
		<5.142, 1.976, -1.613> <5.138, 1.960, -1.616> <5.142, 1.932, -1.623> <5.129, 1.921, -1.623> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.152, 1.941, -1.491> <5.128, 1.920, -1.478> <5.084, 1.897, -1.463> <5.050, 1.899, -1.466> 
		<5.146, 1.920, -1.526> <5.122, 1.900, -1.512> <5.076, 1.874, -1.502> <5.042, 1.876, -1.505> 
		<5.135, 1.913, -1.584> <5.109, 1.891, -1.584> <5.064, 1.864, -1.577> <5.031, 1.867, -1.571> 
		<5.129, 1.921, -1.623> <5.102, 1.899, -1.623> <5.057, 1.874, -1.621> <5.023, 1.877, -1.615> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.050, 1.899, -1.466> <5.031, 1.900, -1.467> <5.016, 1.934, -1.493> <5.029, 1.946, -1.500> 
		<5.042, 1.876, -1.505> <5.024, 1.877, -1.506> <5.011, 1.919, -1.519> <5.024, 1.931, -1.527> 
		<5.031, 1.867, -1.571> <5.014, 1.868, -1.568> <5.003, 1.913, -1.572> <5.016, 1.925, -1.572> 
		<5.023, 1.877, -1.615> <5.006, 1.878, -1.612> <4.998, 1.920, -1.602> <5.011, 1.931, -1.602> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<5.029, 1.946, -1.500> <5.056, 1.971, -1.517> <5.115, 1.979, -1.520> <5.152, 1.993, -1.528> 
		<5.024, 1.931, -1.527> <5.051, 1.955, -1.544> <5.111, 1.966, -1.542> <5.148, 1.980, -1.550> 
		<5.016, 1.925, -1.572> <5.046, 1.952, -1.571> <5.103, 1.960, -1.584> <5.141, 1.975, -1.587> 
		<5.011, 1.931, -1.602> <5.041, 1.959, -1.601> <5.099, 1.966, -1.609> <5.137, 1.980, -1.612> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.417, 2.268, -1.076> <3.418, 2.266, -1.057> <3.431, 2.257, -1.029> <3.420, 2.262, -1.015> 
		<3.401, 2.249, -1.076> <3.402, 2.247, -1.058> <3.407, 2.229, -1.029> <3.396, 2.233, -1.015> 
		<3.376, 2.226, -1.092> <3.368, 2.216, -1.079> <3.373, 2.198, -1.049> <3.358, 2.198, -1.039> 
		<3.361, 2.216, -1.110> <3.354, 2.206, -1.097> <3.351, 2.184, -1.077> <3.336, 2.184, -1.066> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.420, 2.262, -1.015> <3.400, 2.269, -0.990> <3.360, 2.287, -0.962> <3.330, 2.301, -0.965> 
		<3.396, 2.233, -1.015> <3.376, 2.240, -0.990> <3.333, 2.254, -0.963> <3.303, 2.269, -0.965> 
		<3.358, 2.198, -1.039> <3.330, 2.197, -1.020> <3.287, 2.208, -0.993> <3.260, 2.229, -0.992> 
		<3.336, 2.184, -1.066> <3.308, 2.183, -1.047> <3.262, 2.192, -1.024> <3.236, 2.213, -1.023> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.330, 2.301, -0.965> <3.312, 2.311, -0.966> <3.291, 2.324, -1.008> <3.303, 2.320, -1.024> 
		<3.303, 2.269, -0.965> <3.285, 2.278, -0.966> <3.273, 2.302, -1.008> <3.284, 2.298, -1.024> 
		<3.260, 2.229, -0.992> <3.246, 2.241, -0.992> <3.240, 2.270, -1.032> <3.255, 2.271, -1.043> 
		<3.236, 2.213, -1.023> <3.221, 2.225, -1.022> <3.224, 2.259, -1.052> <3.239, 2.260, -1.063> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.303, 2.320, -1.024> <3.325, 2.312, -1.056> <3.379, 2.286, -1.063> <3.411, 2.272, -1.080> 
		<3.284, 2.298, -1.024> <3.307, 2.290, -1.056> <3.363, 2.268, -1.063> <3.396, 2.253, -1.080> 
		<3.255, 2.271, -1.043> <3.288, 2.274, -1.066> <3.336, 2.243, -1.081> <3.372, 2.231, -1.095> 
		<3.239, 2.260, -1.063> <3.271, 2.263, -1.087> <3.322, 2.234, -1.098> <3.358, 2.222, -1.112> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.459, 2.333, -1.109> <3.466, 2.341, -1.096> <3.489, 2.349, -1.077> <3.482, 2.359, -1.065> 
		<3.452, 2.317, -1.091> <3.459, 2.325, -1.078> <3.479, 2.325, -1.050> <3.472, 2.335, -1.038> 
		<3.433, 2.288, -1.075> <3.434, 2.286, -1.057> <3.455, 2.287, -1.029> <3.444, 2.291, -1.015> 
		<3.417, 2.268, -1.076> <3.418, 2.266, -1.057> <3.431, 2.257, -1.029> <3.420, 2.262, -1.015> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.482, 2.359, -1.065> <3.468, 2.378, -1.044> <3.432, 2.403, -1.022> <3.401, 2.412, -1.022> 
		<3.472, 2.335, -1.038> <3.458, 2.354, -1.017> <3.420, 2.376, -0.992> <3.389, 2.384, -0.991> 
		<3.444, 2.291, -1.015> <3.424, 2.298, -0.990> <3.387, 2.320, -0.962> <3.358, 2.334, -0.964> 
		<3.420, 2.262, -1.015> <3.400, 2.269, -0.990> <3.360, 2.287, -0.962> <3.330, 2.301, -0.965> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.401, 2.412, -1.022> <3.382, 2.417, -1.021> <3.343, 2.407, -1.048> <3.351, 2.395, -1.062> 
		<3.389, 2.384, -0.991> <3.370, 2.389, -0.991> <3.335, 2.388, -1.028> <3.343, 2.376, -1.042> 
		<3.358, 2.334, -0.964> <3.340, 2.343, -0.966> <3.310, 2.347, -1.008> <3.321, 2.342, -1.024> 
		<3.330, 2.301, -0.965> <3.312, 2.311, -0.966> <3.291, 2.324, -1.008> <3.303, 2.320, -1.024> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.351, 2.395, -1.062> <3.365, 2.372, -1.089> <3.421, 2.352, -1.097> <3.451, 2.333, -1.112> 
		<3.343, 2.376, -1.042> <3.357, 2.353, -1.069> <3.414, 2.336, -1.080> <3.444, 2.318, -1.095> 
		<3.321, 2.342, -1.024> <3.344, 2.334, -1.055> <3.394, 2.305, -1.063> <3.426, 2.290, -1.080> 
		<3.303, 2.320, -1.024> <3.325, 2.312, -1.056> <3.379, 2.286, -1.063> <3.411, 2.272, -1.080> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.462, 2.373, -1.190> <3.469, 2.387, -1.190> <3.494, 2.405, -1.191> <3.487, 2.419, -1.187> 
		<3.467, 2.368, -1.164> <3.475, 2.382, -1.163> <3.502, 2.398, -1.152> <3.495, 2.411, -1.148> 
		<3.466, 2.351, -1.128> <3.473, 2.359, -1.115> <3.501, 2.375, -1.106> <3.493, 2.386, -1.094> 
		<3.459, 2.333, -1.109> <3.466, 2.341, -1.096> <3.489, 2.349, -1.077> <3.482, 2.359, -1.065> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.487, 2.419, -1.187> <3.473, 2.446, -1.180> <3.436, 2.475, -1.167> <3.406, 2.480, -1.160> 
		<3.495, 2.411, -1.148> <3.481, 2.438, -1.140> <3.446, 2.466, -1.123> <3.415, 2.471, -1.115> 
		<3.493, 2.386, -1.094> <3.479, 2.405, -1.073> <3.444, 2.433, -1.055> <3.414, 2.442, -1.054> 
		<3.482, 2.359, -1.065> <3.468, 2.378, -1.044> <3.432, 2.403, -1.022> <3.401, 2.412, -1.022> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.406, 2.480, -1.160> <3.387, 2.483, -1.156> <3.347, 2.458, -1.151> <3.354, 2.441, -1.156> 
		<3.415, 2.471, -1.115> <3.397, 2.474, -1.111> <3.353, 2.452, -1.121> <3.360, 2.435, -1.126> 
		<3.414, 2.442, -1.054> <3.394, 2.447, -1.054> <3.352, 2.427, -1.071> <3.359, 2.415, -1.085> 
		<3.401, 2.412, -1.022> <3.382, 2.417, -1.021> <3.343, 2.407, -1.048> <3.351, 2.395, -1.062> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.354, 2.441, -1.156> <3.369, 2.407, -1.165> <3.424, 2.392, -1.179> <3.453, 2.371, -1.189> 
		<3.360, 2.435, -1.126> <3.375, 2.401, -1.135> <3.429, 2.387, -1.154> <3.459, 2.366, -1.164> 
		<3.359, 2.415, -1.085> <3.374, 2.392, -1.111> <3.428, 2.368, -1.115> <3.458, 2.350, -1.130> 
		<3.351, 2.395, -1.062> <3.365, 2.372, -1.089> <3.421, 2.352, -1.097> <3.451, 2.333, -1.112> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.424, 2.364, -1.272> <3.426, 2.377, -1.284> <3.441, 2.393, -1.307> <3.431, 2.406, -1.310> 
		<3.440, 2.375, -1.253> <3.442, 2.387, -1.264> <3.465, 2.408, -1.277> <3.454, 2.421, -1.281> 
		<3.456, 2.378, -1.217> <3.464, 2.392, -1.216> <3.485, 2.413, -1.230> <3.478, 2.426, -1.227> 
		<3.462, 2.373, -1.190> <3.469, 2.387, -1.190> <3.494, 2.405, -1.191> <3.487, 2.419, -1.187> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.431, 2.406, -1.310> <3.411, 2.430, -1.317> <3.371, 2.459, -1.313> <3.343, 2.465, -1.299> 
		<3.454, 2.421, -1.281> <3.434, 2.446, -1.287> <3.397, 2.476, -1.280> <3.369, 2.482, -1.266> 
		<3.478, 2.426, -1.227> <3.464, 2.453, -1.219> <3.427, 2.483, -1.211> <3.397, 2.488, -1.204> 
		<3.487, 2.419, -1.187> <3.473, 2.446, -1.180> <3.436, 2.475, -1.167> <3.406, 2.480, -1.160> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.343, 2.465, -1.299> <3.325, 2.469, -1.290> <3.300, 2.446, -1.255> <3.311, 2.431, -1.250> 
		<3.369, 2.482, -1.266> <3.352, 2.486, -1.257> <3.318, 2.458, -1.233> <3.329, 2.442, -1.228> 
		<3.397, 2.488, -1.204> <3.378, 2.491, -1.200> <3.340, 2.464, -1.181> <3.348, 2.446, -1.186> 
		<3.406, 2.480, -1.160> <3.387, 2.483, -1.156> <3.347, 2.458, -1.151> <3.354, 2.441, -1.156> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.311, 2.431, -1.250> <3.333, 2.401, -1.241> <3.386, 2.383, -1.262> <3.418, 2.363, -1.267> 
		<3.329, 2.442, -1.228> <3.351, 2.413, -1.218> <3.401, 2.393, -1.243> <3.433, 2.373, -1.248> 
		<3.348, 2.446, -1.186> <3.362, 2.413, -1.195> <3.418, 2.397, -1.204> <3.448, 2.376, -1.214> 
		<3.354, 2.441, -1.156> <3.369, 2.407, -1.165> <3.424, 2.392, -1.179> <3.453, 2.371, -1.189> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.369, 2.312, -1.306> <3.362, 2.317, -1.323> <3.362, 2.320, -1.355> <3.347, 2.328, -1.361> 
		<3.385, 2.332, -1.306> <3.378, 2.336, -1.323> <3.386, 2.349, -1.355> <3.371, 2.357, -1.361> 
		<3.410, 2.355, -1.290> <3.412, 2.367, -1.302> <3.419, 2.379, -1.334> <3.409, 2.392, -1.337> 
		<3.424, 2.364, -1.272> <3.426, 2.377, -1.284> <3.441, 2.393, -1.307> <3.431, 2.406, -1.310> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.347, 2.328, -1.361> <3.320, 2.342, -1.373> <3.273, 2.365, -1.375> <3.248, 2.376, -1.357> 
		<3.371, 2.357, -1.361> <3.344, 2.371, -1.373> <3.301, 2.398, -1.375> <3.275, 2.409, -1.357> 
		<3.409, 2.392, -1.337> <3.389, 2.416, -1.344> <3.346, 2.443, -1.344> <3.318, 2.449, -1.330> 
		<3.431, 2.406, -1.310> <3.411, 2.430, -1.317> <3.371, 2.459, -1.313> <3.343, 2.465, -1.299> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.248, 2.376, -1.357> <3.232, 2.383, -1.346> <3.231, 2.380, -1.298> <3.247, 2.371, -1.289> 
		<3.275, 2.409, -1.357> <3.260, 2.416, -1.346> <3.249, 2.402, -1.297> <3.266, 2.393, -1.289> 
		<3.318, 2.449, -1.330> <3.300, 2.452, -1.321> <3.283, 2.436, -1.276> <3.295, 2.420, -1.271> 
		<3.343, 2.465, -1.299> <3.325, 2.469, -1.290> <3.300, 2.446, -1.255> <3.311, 2.431, -1.250> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.247, 2.371, -1.289> <3.279, 2.354, -1.274> <3.330, 2.331, -1.296> <3.365, 2.314, -1.299> 
		<3.266, 2.393, -1.289> <3.297, 2.376, -1.274> <3.345, 2.349, -1.296> <3.380, 2.332, -1.299> 
		<3.295, 2.420, -1.271> <3.317, 2.390, -1.262> <3.372, 2.374, -1.279> <3.404, 2.354, -1.284> 
		<3.311, 2.431, -1.250> <3.333, 2.401, -1.241> <3.386, 2.383, -1.262> <3.418, 2.363, -1.267> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.327, 2.247, -1.273> <3.314, 2.242, -1.284> <3.302, 2.228, -1.308> <3.285, 2.230, -1.311> 
		<3.334, 2.264, -1.291> <3.321, 2.259, -1.302> <3.313, 2.253, -1.335> <3.295, 2.255, -1.338> 
		<3.352, 2.293, -1.307> <3.346, 2.298, -1.323> <3.338, 2.291, -1.355> <3.323, 2.299, -1.362> 
		<3.369, 2.312, -1.306> <3.362, 2.317, -1.323> <3.362, 2.320, -1.355> <3.347, 2.328, -1.361> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.285, 2.230, -1.311> <3.251, 2.235, -1.317> <3.201, 2.248, -1.317> <3.177, 2.266, -1.300> 
		<3.295, 2.255, -1.338> <3.262, 2.259, -1.344> <3.213, 2.276, -1.347> <3.189, 2.294, -1.331> 
		<3.323, 2.299, -1.362> <3.295, 2.313, -1.373> <3.246, 2.333, -1.376> <3.221, 2.343, -1.357> 
		<3.347, 2.328, -1.361> <3.320, 2.342, -1.373> <3.273, 2.365, -1.375> <3.248, 2.376, -1.357> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.177, 2.266, -1.300> <3.165, 2.276, -1.291> <3.181, 2.298, -1.255> <3.199, 2.296, -1.251> 
		<3.189, 2.294, -1.331> <3.176, 2.304, -1.322> <3.189, 2.317, -1.276> <3.207, 2.315, -1.272> 
		<3.221, 2.343, -1.357> <3.205, 2.350, -1.346> <3.212, 2.357, -1.298> <3.229, 2.349, -1.290> 
		<3.248, 2.376, -1.357> <3.232, 2.383, -1.346> <3.231, 2.380, -1.298> <3.247, 2.371, -1.289> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.199, 2.296, -1.251> <3.239, 2.292, -1.242> <3.288, 2.265, -1.263> <3.326, 2.252, -1.268> 
		<3.207, 2.315, -1.272> <3.247, 2.311, -1.263> <3.294, 2.281, -1.280> <3.332, 2.267, -1.285> 
		<3.229, 2.349, -1.290> <3.260, 2.331, -1.274> <3.314, 2.312, -1.296> <3.350, 2.295, -1.299> 
		<3.247, 2.371, -1.289> <3.279, 2.354, -1.274> <3.330, 2.331, -1.296> <3.365, 2.314, -1.299> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.324, 2.208, -1.192> <3.311, 2.197, -1.191> <3.297, 2.172, -1.192> <3.280, 2.171, -1.189> 
		<3.319, 2.213, -1.218> <3.305, 2.202, -1.217> <3.289, 2.179, -1.232> <3.272, 2.178, -1.228> 
		<3.320, 2.230, -1.254> <3.307, 2.225, -1.265> <3.291, 2.202, -1.279> <3.273, 2.204, -1.282> 
		<3.327, 2.247, -1.273> <3.314, 2.242, -1.284> <3.302, 2.228, -1.308> <3.285, 2.230, -1.311> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.280, 2.171, -1.189> <3.246, 2.169, -1.182> <3.196, 2.175, -1.171> <3.172, 2.198, -1.162> 
		<3.272, 2.178, -1.228> <3.238, 2.176, -1.222> <3.187, 2.184, -1.215> <3.163, 2.207, -1.206> 
		<3.273, 2.204, -1.282> <3.240, 2.208, -1.288> <3.188, 2.218, -1.284> <3.165, 2.236, -1.267> 
		<3.285, 2.230, -1.311> <3.251, 2.235, -1.317> <3.201, 2.248, -1.317> <3.177, 2.266, -1.300> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.172, 2.198, -1.162> <3.160, 2.210, -1.157> <3.179, 2.249, -1.154> <3.196, 2.250, -1.157> 
		<3.163, 2.207, -1.206> <3.151, 2.218, -1.202> <3.173, 2.254, -1.184> <3.190, 2.256, -1.187> 
		<3.165, 2.236, -1.267> <3.152, 2.246, -1.258> <3.173, 2.278, -1.233> <3.191, 2.276, -1.229> 
		<3.177, 2.266, -1.300> <3.165, 2.276, -1.291> <3.181, 2.298, -1.255> <3.199, 2.296, -1.251> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.196, 2.250, -1.157> <3.236, 2.255, -1.165> <3.285, 2.225, -1.180> <3.323, 2.214, -1.190> 
		<3.190, 2.256, -1.187> <3.229, 2.260, -1.195> <3.279, 2.230, -1.205> <3.318, 2.219, -1.215> 
		<3.191, 2.276, -1.229> <3.230, 2.272, -1.220> <3.281, 2.248, -1.244> <3.318, 2.235, -1.249> 
		<3.199, 2.296, -1.251> <3.239, 2.292, -1.242> <3.288, 2.265, -1.263> <3.326, 2.252, -1.268> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.361, 2.216, -1.110> <3.354, 2.206, -1.097> <3.351, 2.184, -1.077> <3.336, 2.184, -1.066> 
		<3.346, 2.206, -1.129> <3.338, 2.196, -1.116> <3.327, 2.169, -1.106> <3.313, 2.168, -1.096> 
		<3.329, 2.203, -1.165> <3.316, 2.192, -1.165> <3.305, 2.164, -1.153> <3.288, 2.163, -1.150> 
		<3.324, 2.208, -1.192> <3.311, 2.197, -1.191> <3.297, 2.172, -1.192> <3.280, 2.171, -1.189> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.336, 2.184, -1.066> <3.308, 2.183, -1.047> <3.262, 2.192, -1.024> <3.236, 2.213, -1.023> 
		<3.313, 2.168, -1.096> <3.285, 2.168, -1.076> <3.236, 2.175, -1.057> <3.209, 2.196, -1.056> 
		<3.288, 2.163, -1.150> <3.255, 2.161, -1.143> <3.206, 2.167, -1.127> <3.181, 2.190, -1.118> 
		<3.280, 2.171, -1.189> <3.246, 2.169, -1.182> <3.196, 2.175, -1.171> <3.172, 2.198, -1.162> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.236, 2.213, -1.023> <3.221, 2.225, -1.022> <3.224, 2.259, -1.052> <3.239, 2.260, -1.063> 
		<3.209, 2.196, -1.056> <3.194, 2.207, -1.056> <3.206, 2.247, -1.075> <3.221, 2.249, -1.086> 
		<3.181, 2.190, -1.118> <3.169, 2.201, -1.113> <3.185, 2.243, -1.124> <3.202, 2.245, -1.127> 
		<3.172, 2.198, -1.162> <3.160, 2.210, -1.157> <3.179, 2.249, -1.154> <3.196, 2.250, -1.157> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<3.239, 2.260, -1.063> <3.271, 2.263, -1.087> <3.322, 2.234, -1.098> <3.358, 2.222, -1.112> 
		<3.221, 2.249, -1.086> <3.253, 2.251, -1.110> <3.307, 2.224, -1.116> <3.343, 2.212, -1.131> 
		<3.202, 2.245, -1.127> <3.242, 2.249, -1.135> <3.290, 2.220, -1.156> <3.328, 2.209, -1.165> 
		<3.196, 2.250, -1.157> <3.236, 2.255, -1.165> <3.285, 2.225, -1.180> <3.323, 2.214, -1.190> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.119, 1.779, 0.069> <-1.090, 1.741, 0.069> <-1.066, 1.709, 0.030> <-1.066, 1.709, -0.018> 
		<-1.270, 1.665, 0.069> <-1.241, 1.627, 0.069> <-1.217, 1.595, 0.030> <-1.217, 1.595, -0.018> 
		<-1.471, 1.513, 0.069> <-1.443, 1.475, 0.069> <-1.419, 1.443, 0.030> <-1.419, 1.443, -0.018> 
		<-1.623, 1.399, 0.069> <-1.594, 1.361, 0.069> <-1.570, 1.329, 0.030> <-1.570, 1.329, -0.018> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.066, 1.709, -0.018> <-1.066, 1.709, -0.066> <-1.090, 1.741, -0.105> <-1.119, 1.779, -0.105> 
		<-1.217, 1.595, -0.018> <-1.217, 1.595, -0.066> <-1.241, 1.627, -0.105> <-1.270, 1.665, -0.105> 
		<-1.419, 1.443, -0.018> <-1.419, 1.443, -0.066> <-1.443, 1.475, -0.105> <-1.471, 1.513, -0.105> 
		<-1.570, 1.329, -0.018> <-1.570, 1.329, -0.066> <-1.594, 1.361, -0.105> <-1.623, 1.399, -0.105> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.119, 1.779, -0.105> <-1.147, 1.817, -0.105> <-1.171, 1.849, -0.066> <-1.171, 1.849, -0.018> 
		<-1.270, 1.665, -0.105> <-1.298, 1.703, -0.105> <-1.322, 1.735, -0.066> <-1.322, 1.735, -0.018> 
		<-1.471, 1.513, -0.105> <-1.500, 1.551, -0.105> <-1.524, 1.583, -0.066> <-1.524, 1.583, -0.018> 
		<-1.623, 1.399, -0.105> <-1.651, 1.437, -0.105> <-1.675, 1.469, -0.066> <-1.675, 1.469, -0.018> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.675, 1.469, -0.018> <-1.675, 1.469, 0.030> <-1.651, 1.437, 0.069> <-1.623, 1.399, 0.069> 
		<-1.524, 1.583, -0.018> <-1.524, 1.583, 0.030> <-1.500, 1.551, 0.069> <-1.471, 1.513, 0.069> 
		<-1.322, 1.735, -0.018> <-1.322, 1.735, 0.030> <-1.298, 1.703, 0.069> <-1.270, 1.665, 0.069> 
		<-1.171, 1.849, -0.018> <-1.171, 1.849, 0.030> <-1.147, 1.817, 0.069> <-1.119, 1.779, 0.069> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.434, 1.532, 0.003> <-1.427, 1.523, 0.003> <-1.421, 1.516, -0.007> <-1.421, 1.516, -0.018> 
		<-1.585, 1.418, 0.003> <-1.578, 1.409, 0.003> <-1.572, 1.402, -0.007> <-1.572, 1.402, -0.018> 
		<-1.787, 1.266, 0.003> <-1.780, 1.257, 0.003> <-1.774, 1.250, -0.007> <-1.774, 1.250, -0.018> 
		<-1.938, 1.152, 0.003> <-1.931, 1.143, 0.003> <-1.925, 1.136, -0.007> <-1.925, 1.136, -0.018> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.421, 1.516, -0.018> <-1.421, 1.516, -0.029> <-1.427, 1.523, -0.039> <-1.434, 1.532, -0.039> 
		<-1.572, 1.402, -0.018> <-1.572, 1.402, -0.029> <-1.578, 1.409, -0.039> <-1.585, 1.418, -0.039> 
		<-1.774, 1.250, -0.018> <-1.774, 1.250, -0.029> <-1.780, 1.257, -0.039> <-1.787, 1.266, -0.039> 
		<-1.925, 1.136, -0.018> <-1.925, 1.136, -0.029> <-1.931, 1.143, -0.039> <-1.938, 1.152, -0.039> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.434, 1.532, -0.039> <-1.441, 1.542, -0.039> <-1.446, 1.549, -0.029> <-1.446, 1.549, -0.018> 
		<-1.585, 1.418, -0.039> <-1.592, 1.428, -0.039> <-1.598, 1.435, -0.029> <-1.598, 1.435, -0.018> 
		<-1.787, 1.266, -0.039> <-1.794, 1.276, -0.039> <-1.799, 1.283, -0.029> <-1.799, 1.283, -0.018> 
		<-1.938, 1.152, -0.039> <-1.945, 1.162, -0.039> <-1.951, 1.169, -0.029> <-1.951, 1.169, -0.018> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.951, 1.169, -0.018> <-1.951, 1.169, -0.007> <-1.945, 1.162, 0.003> <-1.938, 1.152, 0.003> 
		<-1.799, 1.283, -0.018> <-1.799, 1.283, -0.007> <-1.794, 1.276, 0.003> <-1.787, 1.266, 0.003> 
		<-1.598, 1.435, -0.018> <-1.598, 1.435, -0.007> <-1.592, 1.428, 0.003> <-1.585, 1.418, 0.003> 
		<-1.446, 1.549, -0.018> <-1.446, 1.549, -0.007> <-1.441, 1.542, 0.003> <-1.434, 1.532, 0.003> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.679, 1.389, -0.018> <-1.682, 1.395, -0.018> <-1.690, 1.402, -0.018> <-1.688, 1.408, -0.018> 
		<-1.679, 1.389, -0.027> <-1.682, 1.395, -0.027> <-1.690, 1.402, -0.032> <-1.688, 1.408, -0.032> 
		<-1.676, 1.385, -0.040> <-1.677, 1.389, -0.044> <-1.686, 1.396, -0.049> <-1.683, 1.401, -0.051> 
		<-1.672, 1.380, -0.046> <-1.673, 1.384, -0.051> <-1.680, 1.388, -0.058> <-1.677, 1.393, -0.061> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.688, 1.408, -0.018> <-1.684, 1.419, -0.018> <-1.672, 1.434, -0.018> <-1.661, 1.438, -0.018> 
		<-1.688, 1.408, -0.032> <-1.684, 1.419, -0.032> <-1.672, 1.434, -0.034> <-1.661, 1.438, -0.034> 
		<-1.683, 1.401, -0.051> <-1.678, 1.411, -0.056> <-1.666, 1.426, -0.058> <-1.655, 1.431, -0.055> 
		<-1.677, 1.393, -0.061> <-1.672, 1.403, -0.065> <-1.659, 1.417, -0.069> <-1.648, 1.422, -0.066> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.661, 1.438, -0.018> <-1.654, 1.441, -0.018> <-1.640, 1.431, -0.018> <-1.642, 1.424, -0.018> 
		<-1.661, 1.438, -0.034> <-1.654, 1.441, -0.034> <-1.640, 1.431, -0.029> <-1.642, 1.424, -0.029> 
		<-1.655, 1.431, -0.055> <-1.649, 1.434, -0.054> <-1.636, 1.425, -0.046> <-1.639, 1.419, -0.043> 
		<-1.648, 1.422, -0.066> <-1.642, 1.425, -0.065> <-1.631, 1.419, -0.054> <-1.634, 1.413, -0.051> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.642, 1.424, -0.018> <-1.647, 1.410, -0.018> <-1.666, 1.399, -0.018> <-1.676, 1.389, -0.018> 
		<-1.642, 1.424, -0.029> <-1.647, 1.410, -0.029> <-1.666, 1.399, -0.027> <-1.676, 1.389, -0.027> 
		<-1.639, 1.419, -0.043> <-1.645, 1.407, -0.037> <-1.663, 1.395, -0.041> <-1.673, 1.385, -0.039> 
		<-1.634, 1.413, -0.051> <-1.640, 1.401, -0.045> <-1.659, 1.390, -0.047> <-1.669, 1.380, -0.045> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.672, 1.380, 0.010> <-1.673, 1.384, 0.015> <-1.680, 1.388, 0.022> <-1.677, 1.393, 0.025> 
		<-1.676, 1.385, 0.004> <-1.677, 1.389, 0.008> <-1.686, 1.396, 0.013> <-1.683, 1.401, 0.015> 
		<-1.679, 1.389, -0.009> <-1.682, 1.395, -0.009> <-1.690, 1.402, -0.004> <-1.688, 1.408, -0.004> 
		<-1.679, 1.389, -0.018> <-1.682, 1.395, -0.018> <-1.690, 1.402, -0.018> <-1.688, 1.408, -0.018> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.677, 1.393, 0.025> <-1.672, 1.403, 0.029> <-1.659, 1.417, 0.033> <-1.648, 1.422, 0.030> 
		<-1.683, 1.401, 0.015> <-1.678, 1.411, 0.020> <-1.666, 1.426, 0.022> <-1.655, 1.431, 0.019> 
		<-1.688, 1.408, -0.004> <-1.684, 1.419, -0.004> <-1.672, 1.434, -0.002> <-1.661, 1.438, -0.002> 
		<-1.688, 1.408, -0.018> <-1.684, 1.419, -0.018> <-1.672, 1.434, -0.018> <-1.661, 1.438, -0.018> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.648, 1.422, 0.030> <-1.642, 1.425, 0.029> <-1.631, 1.419, 0.018> <-1.634, 1.413, 0.015> 
		<-1.655, 1.431, 0.019> <-1.649, 1.434, 0.018> <-1.636, 1.425, 0.010> <-1.639, 1.419, 0.007> 
		<-1.661, 1.438, -0.002> <-1.654, 1.441, -0.002> <-1.640, 1.431, -0.007> <-1.642, 1.424, -0.007> 
		<-1.661, 1.438, -0.018> <-1.654, 1.441, -0.018> <-1.640, 1.431, -0.018> <-1.642, 1.424, -0.018> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.634, 1.413, 0.015> <-1.640, 1.401, 0.009> <-1.659, 1.390, 0.011> <-1.669, 1.380, 0.009> 
		<-1.639, 1.419, 0.007> <-1.645, 1.407, 0.001> <-1.663, 1.395, 0.005> <-1.673, 1.385, 0.003> 
		<-1.642, 1.424, -0.007> <-1.647, 1.410, -0.007> <-1.666, 1.399, -0.009> <-1.676, 1.389, -0.009> 
		<-1.642, 1.424, -0.018> <-1.647, 1.410, -0.018> <-1.666, 1.399, -0.018> <-1.676, 1.389, -0.018> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.655, 1.357, 0.022> <-1.654, 1.358, 0.028> <-1.656, 1.356, 0.039> <-1.652, 1.359, 0.042> 
		<-1.660, 1.364, 0.022> <-1.659, 1.365, 0.028> <-1.664, 1.367, 0.039> <-1.660, 1.370, 0.042> 
		<-1.668, 1.374, 0.017> <-1.670, 1.379, 0.021> <-1.674, 1.381, 0.032> <-1.671, 1.386, 0.035> 
		<-1.672, 1.380, 0.010> <-1.673, 1.384, 0.015> <-1.680, 1.388, 0.022> <-1.677, 1.393, 0.025> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.652, 1.359, 0.042> <-1.643, 1.366, 0.049> <-1.629, 1.377, 0.054> <-1.619, 1.384, 0.050> 
		<-1.660, 1.370, 0.042> <-1.652, 1.377, 0.049> <-1.638, 1.389, 0.054> <-1.629, 1.396, 0.050> 
		<-1.671, 1.386, 0.035> <-1.666, 1.396, 0.039> <-1.653, 1.408, 0.044> <-1.642, 1.413, 0.042> 
		<-1.677, 1.393, 0.025> <-1.672, 1.403, 0.029> <-1.659, 1.417, 0.033> <-1.648, 1.422, 0.030> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.619, 1.384, 0.050> <-1.614, 1.388, 0.048> <-1.610, 1.391, 0.032> <-1.615, 1.387, 0.028> 
		<-1.629, 1.396, 0.050> <-1.624, 1.400, 0.048> <-1.616, 1.399, 0.032> <-1.621, 1.396, 0.028> 
		<-1.642, 1.413, 0.042> <-1.636, 1.416, 0.040> <-1.627, 1.413, 0.025> <-1.630, 1.407, 0.022> 
		<-1.648, 1.422, 0.030> <-1.642, 1.425, 0.029> <-1.631, 1.419, 0.018> <-1.634, 1.413, 0.015> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.615, 1.387, 0.028> <-1.624, 1.380, 0.020> <-1.642, 1.367, 0.023> <-1.653, 1.358, 0.020> 
		<-1.621, 1.396, 0.028> <-1.631, 1.389, 0.020> <-1.647, 1.374, 0.023> <-1.658, 1.365, 0.020> 
		<-1.630, 1.407, 0.022> <-1.636, 1.395, 0.016> <-1.655, 1.385, 0.017> <-1.666, 1.375, 0.015> 
		<-1.634, 1.413, 0.015> <-1.640, 1.401, 0.009> <-1.659, 1.390, 0.011> <-1.669, 1.380, 0.009> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.638, 1.334, 0.010> <-1.634, 1.332, 0.015> <-1.631, 1.324, 0.022> <-1.626, 1.325, 0.025> 
		<-1.642, 1.339, 0.017> <-1.638, 1.337, 0.021> <-1.637, 1.332, 0.032> <-1.632, 1.333, 0.035> 
		<-1.649, 1.350, 0.022> <-1.648, 1.350, 0.028> <-1.647, 1.345, 0.039> <-1.643, 1.348, 0.042> 
		<-1.655, 1.357, 0.022> <-1.654, 1.358, 0.028> <-1.656, 1.356, 0.039> <-1.652, 1.359, 0.042> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.626, 1.325, 0.025> <-1.615, 1.328, 0.029> <-1.598, 1.336, 0.033> <-1.590, 1.345, 0.030> 
		<-1.632, 1.333, 0.035> <-1.621, 1.336, 0.039> <-1.605, 1.345, 0.044> <-1.597, 1.354, 0.042> 
		<-1.643, 1.348, 0.042> <-1.635, 1.355, 0.049> <-1.619, 1.364, 0.054> <-1.610, 1.371, 0.050> 
		<-1.652, 1.359, 0.042> <-1.643, 1.366, 0.049> <-1.629, 1.377, 0.054> <-1.619, 1.384, 0.050> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.590, 1.345, 0.030> <-1.586, 1.350, 0.029> <-1.589, 1.362, 0.018> <-1.595, 1.361, 0.015> 
		<-1.597, 1.354, 0.042> <-1.593, 1.359, 0.040> <-1.593, 1.368, 0.025> <-1.599, 1.367, 0.022> 
		<-1.610, 1.371, 0.050> <-1.605, 1.375, 0.048> <-1.604, 1.382, 0.032> <-1.608, 1.379, 0.028> 
		<-1.619, 1.384, 0.050> <-1.614, 1.388, 0.048> <-1.610, 1.391, 0.032> <-1.615, 1.387, 0.028> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.595, 1.361, 0.015> <-1.608, 1.359, 0.009> <-1.624, 1.344, 0.011> <-1.637, 1.337, 0.009> 
		<-1.599, 1.367, 0.022> <-1.613, 1.365, 0.016> <-1.628, 1.349, 0.017> <-1.641, 1.342, 0.015> 
		<-1.608, 1.379, 0.028> <-1.618, 1.372, 0.020> <-1.636, 1.360, 0.023> <-1.648, 1.351, 0.020> 
		<-1.615, 1.387, 0.028> <-1.624, 1.380, 0.020> <-1.642, 1.367, 0.023> <-1.653, 1.358, 0.020> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.631, 1.325, -0.018> <-1.626, 1.321, -0.018> <-1.621, 1.311, -0.018> <-1.615, 1.311, -0.018> 
		<-1.631, 1.325, -0.009> <-1.626, 1.321, -0.009> <-1.621, 1.311, -0.004> <-1.615, 1.311, -0.004> 
		<-1.634, 1.329, 0.004> <-1.630, 1.326, 0.008> <-1.625, 1.316, 0.013> <-1.620, 1.317, 0.015> 
		<-1.638, 1.334, 0.010> <-1.634, 1.332, 0.015> <-1.631, 1.324, 0.022> <-1.626, 1.325, 0.025> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.615, 1.311, -0.018> <-1.603, 1.312, -0.018> <-1.585, 1.319, -0.018> <-1.578, 1.329, -0.018> 
		<-1.615, 1.311, -0.004> <-1.603, 1.312, -0.004> <-1.585, 1.319, -0.002> <-1.578, 1.329, -0.002> 
		<-1.620, 1.317, 0.015> <-1.609, 1.320, 0.020> <-1.591, 1.327, 0.022> <-1.584, 1.336, 0.019> 
		<-1.626, 1.325, 0.025> <-1.615, 1.328, 0.029> <-1.598, 1.336, 0.033> <-1.590, 1.345, 0.030> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.578, 1.329, -0.018> <-1.574, 1.335, -0.018> <-1.580, 1.350, -0.018> <-1.587, 1.350, -0.018> 
		<-1.578, 1.329, -0.002> <-1.574, 1.335, -0.002> <-1.580, 1.350, -0.007> <-1.587, 1.350, -0.007> 
		<-1.584, 1.336, 0.019> <-1.579, 1.341, 0.018> <-1.584, 1.356, 0.010> <-1.590, 1.355, 0.007> 
		<-1.590, 1.345, 0.030> <-1.586, 1.350, 0.029> <-1.589, 1.362, 0.018> <-1.595, 1.361, 0.015> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.587, 1.350, -0.018> <-1.601, 1.350, -0.018> <-1.617, 1.334, -0.018> <-1.630, 1.328, -0.018> 
		<-1.587, 1.350, -0.007> <-1.601, 1.350, -0.007> <-1.617, 1.334, -0.009> <-1.630, 1.328, -0.009> 
		<-1.590, 1.355, 0.007> <-1.604, 1.353, 0.001> <-1.621, 1.339, 0.005> <-1.633, 1.332, 0.003> 
		<-1.595, 1.361, 0.015> <-1.608, 1.359, 0.009> <-1.624, 1.344, 0.011> <-1.637, 1.337, 0.009> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.638, 1.334, -0.046> <-1.634, 1.332, -0.051> <-1.631, 1.324, -0.058> <-1.626, 1.325, -0.061> 
		<-1.634, 1.329, -0.040> <-1.630, 1.326, -0.044> <-1.625, 1.316, -0.049> <-1.620, 1.317, -0.051> 
		<-1.631, 1.325, -0.027> <-1.626, 1.321, -0.027> <-1.621, 1.311, -0.032> <-1.615, 1.311, -0.032> 
		<-1.631, 1.325, -0.018> <-1.626, 1.321, -0.018> <-1.621, 1.311, -0.018> <-1.615, 1.311, -0.018> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.626, 1.325, -0.061> <-1.615, 1.328, -0.065> <-1.598, 1.336, -0.069> <-1.590, 1.345, -0.066> 
		<-1.620, 1.317, -0.051> <-1.609, 1.320, -0.056> <-1.591, 1.327, -0.058> <-1.584, 1.336, -0.055> 
		<-1.615, 1.311, -0.032> <-1.603, 1.312, -0.032> <-1.585, 1.319, -0.034> <-1.578, 1.329, -0.034> 
		<-1.615, 1.311, -0.018> <-1.603, 1.312, -0.018> <-1.585, 1.319, -0.018> <-1.578, 1.329, -0.018> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.590, 1.345, -0.066> <-1.586, 1.350, -0.065> <-1.589, 1.362, -0.054> <-1.595, 1.361, -0.051> 
		<-1.584, 1.336, -0.055> <-1.579, 1.341, -0.054> <-1.584, 1.356, -0.046> <-1.590, 1.355, -0.043> 
		<-1.578, 1.329, -0.034> <-1.574, 1.335, -0.034> <-1.580, 1.350, -0.029> <-1.587, 1.350, -0.029> 
		<-1.578, 1.329, -0.018> <-1.574, 1.335, -0.018> <-1.580, 1.350, -0.018> <-1.587, 1.350, -0.018> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.595, 1.361, -0.051> <-1.608, 1.359, -0.045> <-1.624, 1.344, -0.047> <-1.637, 1.337, -0.045> 
		<-1.590, 1.355, -0.043> <-1.604, 1.353, -0.037> <-1.621, 1.339, -0.041> <-1.633, 1.332, -0.039> 
		<-1.587, 1.350, -0.029> <-1.601, 1.350, -0.029> <-1.617, 1.334, -0.027> <-1.630, 1.328, -0.027> 
		<-1.587, 1.350, -0.018> <-1.601, 1.350, -0.018> <-1.617, 1.334, -0.018> <-1.630, 1.328, -0.018> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.655, 1.357, -0.058> <-1.654, 1.358, -0.064> <-1.656, 1.356, -0.075> <-1.652, 1.359, -0.078> 
		<-1.649, 1.350, -0.058> <-1.648, 1.350, -0.064> <-1.647, 1.345, -0.075> <-1.643, 1.348, -0.078> 
		<-1.642, 1.339, -0.053> <-1.638, 1.337, -0.057> <-1.637, 1.332, -0.068> <-1.632, 1.333, -0.070> 
		<-1.638, 1.334, -0.046> <-1.634, 1.332, -0.051> <-1.631, 1.324, -0.058> <-1.626, 1.325, -0.061> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.652, 1.359, -0.078> <-1.643, 1.366, -0.085> <-1.629, 1.377, -0.090> <-1.619, 1.384, -0.086> 
		<-1.643, 1.348, -0.078> <-1.635, 1.355, -0.085> <-1.619, 1.364, -0.090> <-1.610, 1.371, -0.086> 
		<-1.632, 1.333, -0.070> <-1.621, 1.336, -0.075> <-1.605, 1.345, -0.080> <-1.597, 1.354, -0.077> 
		<-1.626, 1.325, -0.061> <-1.615, 1.328, -0.065> <-1.598, 1.336, -0.069> <-1.590, 1.345, -0.066> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.619, 1.384, -0.086> <-1.614, 1.388, -0.084> <-1.610, 1.391, -0.068> <-1.615, 1.387, -0.064> 
		<-1.610, 1.371, -0.086> <-1.605, 1.375, -0.084> <-1.604, 1.382, -0.068> <-1.608, 1.379, -0.064> 
		<-1.597, 1.354, -0.077> <-1.593, 1.359, -0.076> <-1.593, 1.368, -0.061> <-1.599, 1.367, -0.058> 
		<-1.590, 1.345, -0.066> <-1.586, 1.350, -0.065> <-1.589, 1.362, -0.054> <-1.595, 1.361, -0.051> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.615, 1.387, -0.064> <-1.624, 1.380, -0.056> <-1.642, 1.367, -0.059> <-1.653, 1.358, -0.056> 
		<-1.608, 1.379, -0.064> <-1.618, 1.372, -0.056> <-1.636, 1.360, -0.059> <-1.648, 1.351, -0.056> 
		<-1.599, 1.367, -0.058> <-1.613, 1.365, -0.052> <-1.628, 1.349, -0.053> <-1.641, 1.342, -0.051> 
		<-1.595, 1.361, -0.051> <-1.608, 1.359, -0.045> <-1.624, 1.344, -0.047> <-1.637, 1.337, -0.045> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.672, 1.380, -0.046> <-1.673, 1.384, -0.051> <-1.680, 1.388, -0.058> <-1.677, 1.393, -0.061> 
		<-1.668, 1.374, -0.053> <-1.670, 1.379, -0.057> <-1.674, 1.381, -0.068> <-1.671, 1.386, -0.070> 
		<-1.660, 1.364, -0.058> <-1.659, 1.365, -0.064> <-1.664, 1.367, -0.075> <-1.660, 1.370, -0.078> 
		<-1.655, 1.357, -0.058> <-1.654, 1.358, -0.064> <-1.656, 1.356, -0.075> <-1.652, 1.359, -0.078> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.677, 1.393, -0.061> <-1.672, 1.403, -0.065> <-1.659, 1.417, -0.069> <-1.648, 1.422, -0.066> 
		<-1.671, 1.386, -0.070> <-1.666, 1.396, -0.075> <-1.653, 1.408, -0.080> <-1.642, 1.413, -0.077> 
		<-1.660, 1.370, -0.078> <-1.652, 1.377, -0.085> <-1.638, 1.389, -0.090> <-1.629, 1.396, -0.086> 
		<-1.652, 1.359, -0.078> <-1.643, 1.366, -0.085> <-1.629, 1.377, -0.090> <-1.619, 1.384, -0.086> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.648, 1.422, -0.066> <-1.642, 1.425, -0.065> <-1.631, 1.419, -0.054> <-1.634, 1.413, -0.051> 
		<-1.642, 1.413, -0.077> <-1.636, 1.416, -0.076> <-1.627, 1.413, -0.061> <-1.630, 1.407, -0.058> 
		<-1.629, 1.396, -0.086> <-1.624, 1.400, -0.084> <-1.616, 1.399, -0.068> <-1.621, 1.396, -0.064> 
		<-1.619, 1.384, -0.086> <-1.614, 1.388, -0.084> <-1.610, 1.391, -0.068> <-1.615, 1.387, -0.064> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.634, 1.413, -0.051> <-1.640, 1.401, -0.045> <-1.659, 1.390, -0.047> <-1.669, 1.380, -0.045> 
		<-1.630, 1.407, -0.058> <-1.636, 1.395, -0.052> <-1.655, 1.385, -0.053> <-1.666, 1.375, -0.051> 
		<-1.621, 1.396, -0.064> <-1.631, 1.389, -0.056> <-1.647, 1.374, -0.059> <-1.658, 1.365, -0.056> 
		<-1.615, 1.387, -0.064> <-1.624, 1.380, -0.056> <-1.642, 1.367, -0.059> <-1.653, 1.358, -0.056> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.994, 1.161, -0.043> <-1.997, 1.166, -0.042> <-2.004, 1.174, -0.044> <-2.006, 1.177, -0.039> 
		<-1.986, 1.166, -0.043> <-1.990, 1.171, -0.042> <-1.993, 1.183, -0.044> <-1.995, 1.185, -0.039> 
		<-1.973, 1.170, -0.043> <-1.972, 1.176, -0.041> <-1.975, 1.187, -0.044> <-1.975, 1.190, -0.039> 
		<-1.964, 1.169, -0.043> <-1.963, 1.174, -0.041> <-1.962, 1.185, -0.044> <-1.961, 1.188, -0.038> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.006, 1.177, -0.039> <-2.010, 1.182, -0.029> <-2.013, 1.186, -0.011> <-2.011, 1.183, 0.001> 
		<-1.995, 1.185, -0.039> <-1.999, 1.190, -0.028> <-2.001, 1.195, -0.010> <-1.999, 1.192, 0.001> 
		<-1.975, 1.190, -0.039> <-1.974, 1.197, -0.028> <-1.976, 1.202, -0.010> <-1.976, 1.198, 0.002> 
		<-1.961, 1.188, -0.038> <-1.960, 1.195, -0.028> <-1.960, 1.200, -0.010> <-1.961, 1.196, 0.002> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.011, 1.183, 0.001> <-2.010, 1.181, 0.008> <-2.001, 1.168, 0.013> <-1.998, 1.165, 0.007> 
		<-1.999, 1.192, 0.001> <-1.998, 1.191, 0.008> <-1.992, 1.175, 0.013> <-1.990, 1.172, 0.007> 
		<-1.976, 1.198, 0.002> <-1.977, 1.196, 0.008> <-1.974, 1.179, 0.013> <-1.974, 1.175, 0.008> 
		<-1.961, 1.196, 0.002> <-1.961, 1.194, 0.009> <-1.963, 1.178, 0.013> <-1.964, 1.174, 0.008> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.998, 1.165, 0.007> <-1.993, 1.158, -0.005> <-1.994, 1.161, -0.027> <-1.993, 1.159, -0.041> 
		<-1.990, 1.172, 0.007> <-1.984, 1.165, -0.005> <-1.987, 1.166, -0.026> <-1.986, 1.164, -0.041> 
		<-1.974, 1.175, 0.008> <-1.975, 1.167, -0.004> <-1.973, 1.170, -0.026> <-1.973, 1.168, -0.041> 
		<-1.964, 1.174, 0.008> <-1.965, 1.166, -0.004> <-1.964, 1.169, -0.026> <-1.964, 1.167, -0.041> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.009, 1.134, -0.044> <-2.015, 1.135, -0.042> <-2.026, 1.137, -0.045> <-2.029, 1.137, -0.040> 
		<-2.008, 1.143, -0.044> <-2.014, 1.144, -0.042> <-2.024, 1.150, -0.045> <-2.027, 1.151, -0.040> 
		<-2.001, 1.155, -0.043> <-2.005, 1.160, -0.042> <-2.015, 1.166, -0.045> <-2.017, 1.169, -0.039> 
		<-1.994, 1.161, -0.043> <-1.997, 1.166, -0.042> <-2.004, 1.174, -0.044> <-2.006, 1.177, -0.039> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.029, 1.137, -0.040> <-2.036, 1.138, -0.030> <-2.041, 1.138, -0.012> <-2.038, 1.138, 0.000> 
		<-2.027, 1.151, -0.040> <-2.034, 1.152, -0.029> <-2.039, 1.154, -0.011> <-2.036, 1.153, 0.000> 
		<-2.017, 1.169, -0.039> <-2.021, 1.174, -0.029> <-2.026, 1.176, -0.011> <-2.024, 1.173, 0.001> 
		<-2.006, 1.177, -0.039> <-2.010, 1.182, -0.029> <-2.013, 1.186, -0.011> <-2.011, 1.183, 0.001> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.038, 1.138, 0.000> <-2.036, 1.137, 0.007> <-2.020, 1.135, 0.012> <-2.016, 1.135, 0.007> 
		<-2.036, 1.153, 0.000> <-2.034, 1.153, 0.007> <-2.019, 1.146, 0.012> <-2.015, 1.145, 0.007> 
		<-2.024, 1.173, 0.001> <-2.023, 1.172, 0.007> <-2.009, 1.162, 0.013> <-2.007, 1.159, 0.007> 
		<-2.011, 1.183, 0.001> <-2.010, 1.181, 0.008> <-2.001, 1.168, 0.013> <-1.998, 1.165, 0.007> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.016, 1.135, 0.007> <-2.007, 1.134, -0.005> <-2.010, 1.134, -0.027> <-2.007, 1.134, -0.042> 
		<-2.015, 1.145, 0.007> <-2.006, 1.144, -0.005> <-2.009, 1.143, -0.027> <-2.006, 1.143, -0.041> 
		<-2.007, 1.159, 0.007> <-2.001, 1.152, -0.005> <-2.001, 1.156, -0.027> <-2.000, 1.154, -0.041> 
		<-1.998, 1.165, 0.007> <-1.993, 1.158, -0.005> <-1.994, 1.161, -0.027> <-1.993, 1.159, -0.041> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.002, 1.104, -0.044> <-2.007, 1.101, -0.043> <-2.015, 1.094, -0.045> <-2.018, 1.092, -0.040> 
		<-2.007, 1.112, -0.044> <-2.012, 1.108, -0.043> <-2.023, 1.105, -0.045> <-2.026, 1.103, -0.040> 
		<-2.011, 1.125, -0.044> <-2.017, 1.126, -0.043> <-2.028, 1.123, -0.045> <-2.031, 1.123, -0.040> 
		<-2.009, 1.134, -0.044> <-2.015, 1.135, -0.042> <-2.026, 1.137, -0.045> <-2.029, 1.137, -0.040> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.018, 1.092, -0.040> <-2.023, 1.088, -0.030> <-2.027, 1.085, -0.012> <-2.025, 1.087, -0.000> 
		<-2.026, 1.103, -0.040> <-2.032, 1.099, -0.030> <-2.037, 1.098, -0.012> <-2.034, 1.100, -0.000> 
		<-2.031, 1.123, -0.040> <-2.038, 1.124, -0.030> <-2.043, 1.123, -0.012> <-2.040, 1.122, 0.000> 
		<-2.029, 1.137, -0.040> <-2.036, 1.138, -0.030> <-2.041, 1.138, -0.012> <-2.038, 1.138, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.025, 1.087, -0.000> <-2.023, 1.088, 0.007> <-2.010, 1.098, 0.012> <-2.007, 1.100, 0.006> 
		<-2.034, 1.100, -0.000> <-2.033, 1.101, 0.007> <-2.017, 1.106, 0.012> <-2.014, 1.109, 0.006> 
		<-2.040, 1.122, 0.000> <-2.038, 1.122, 0.007> <-2.022, 1.125, 0.012> <-2.018, 1.124, 0.006> 
		<-2.038, 1.138, 0.000> <-2.036, 1.137, 0.007> <-2.020, 1.135, 0.012> <-2.016, 1.135, 0.007> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.007, 1.100, 0.006> <-2.000, 1.106, -0.005> <-2.002, 1.104, -0.027> <-2.000, 1.106, -0.042> 
		<-2.014, 1.109, 0.006> <-2.007, 1.114, -0.005> <-2.008, 1.111, -0.027> <-2.005, 1.113, -0.042> 
		<-2.018, 1.124, 0.006> <-2.009, 1.123, -0.005> <-2.011, 1.125, -0.027> <-2.009, 1.125, -0.042> 
		<-2.016, 1.135, 0.007> <-2.007, 1.134, -0.005> <-2.010, 1.134, -0.027> <-2.007, 1.134, -0.042> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.975, 1.089, -0.044> <-1.976, 1.083, -0.042> <-1.977, 1.072, -0.045> <-1.978, 1.069, -0.040> 
		<-1.984, 1.090, -0.044> <-1.985, 1.084, -0.043> <-1.991, 1.074, -0.045> <-1.992, 1.071, -0.040> 
		<-1.996, 1.097, -0.044> <-2.001, 1.093, -0.043> <-2.007, 1.083, -0.045> <-2.009, 1.081, -0.040> 
		<-2.002, 1.104, -0.044> <-2.007, 1.101, -0.043> <-2.015, 1.094, -0.045> <-2.018, 1.092, -0.040> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.978, 1.069, -0.040> <-1.979, 1.062, -0.030> <-1.980, 1.057, -0.012> <-1.980, 1.060, 0.000> 
		<-1.992, 1.071, -0.040> <-1.993, 1.064, -0.030> <-1.996, 1.059, -0.012> <-1.995, 1.063, 0.000> 
		<-2.009, 1.081, -0.040> <-2.015, 1.077, -0.030> <-2.018, 1.072, -0.012> <-2.015, 1.075, -0.000> 
		<-2.018, 1.092, -0.040> <-2.023, 1.088, -0.030> <-2.027, 1.085, -0.012> <-2.025, 1.087, -0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.980, 1.060, 0.000> <-1.980, 1.062, 0.007> <-1.977, 1.078, 0.012> <-1.977, 1.082, 0.007> 
		<-1.995, 1.063, 0.000> <-1.995, 1.065, 0.007> <-1.988, 1.080, 0.012> <-1.987, 1.084, 0.006> 
		<-2.015, 1.075, -0.000> <-2.014, 1.076, 0.007> <-2.004, 1.089, 0.012> <-2.001, 1.092, 0.006> 
		<-2.025, 1.087, -0.000> <-2.023, 1.088, 0.007> <-2.010, 1.098, 0.012> <-2.007, 1.100, 0.006> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.977, 1.082, 0.007> <-1.975, 1.091, -0.005> <-1.975, 1.088, -0.027> <-1.975, 1.091, -0.042> 
		<-1.987, 1.084, 0.006> <-1.986, 1.092, -0.005> <-1.984, 1.089, -0.027> <-1.984, 1.092, -0.042> 
		<-2.001, 1.092, 0.006> <-1.994, 1.097, -0.005> <-1.997, 1.097, -0.027> <-1.995, 1.099, -0.042> 
		<-2.007, 1.100, 0.006> <-2.000, 1.106, -0.005> <-2.002, 1.104, -0.027> <-2.000, 1.106, -0.042> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.945, 1.097, -0.043> <-1.942, 1.092, -0.042> <-1.935, 1.083, -0.044> <-1.933, 1.080, -0.039> 
		<-1.953, 1.091, -0.043> <-1.949, 1.086, -0.042> <-1.946, 1.075, -0.045> <-1.944, 1.072, -0.039> 
		<-1.966, 1.088, -0.044> <-1.967, 1.082, -0.042> <-1.964, 1.070, -0.045> <-1.964, 1.067, -0.040> 
		<-1.975, 1.089, -0.044> <-1.976, 1.083, -0.042> <-1.977, 1.072, -0.045> <-1.978, 1.069, -0.040> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.933, 1.080, -0.039> <-1.929, 1.075, -0.029> <-1.927, 1.071, -0.011> <-1.929, 1.074, 0.001> 
		<-1.944, 1.072, -0.039> <-1.941, 1.067, -0.029> <-1.939, 1.061, -0.011> <-1.942, 1.064, 0.001> 
		<-1.964, 1.067, -0.040> <-1.965, 1.060, -0.029> <-1.964, 1.055, -0.011> <-1.964, 1.058, 0.000> 
		<-1.978, 1.069, -0.040> <-1.979, 1.062, -0.030> <-1.980, 1.057, -0.012> <-1.980, 1.060, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.929, 1.074, 0.001> <-1.930, 1.075, 0.008> <-1.940, 1.088, 0.013> <-1.942, 1.091, 0.007> 
		<-1.942, 1.064, 0.001> <-1.943, 1.066, 0.007> <-1.949, 1.082, 0.013> <-1.951, 1.085, 0.007> 
		<-1.964, 1.058, 0.000> <-1.964, 1.060, 0.007> <-1.967, 1.077, 0.012> <-1.966, 1.081, 0.007> 
		<-1.980, 1.060, 0.000> <-1.980, 1.062, 0.007> <-1.977, 1.078, 0.012> <-1.977, 1.082, 0.007> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.942, 1.091, 0.007> <-1.947, 1.098, -0.005> <-1.945, 1.096, -0.027> <-1.947, 1.098, -0.041> 
		<-1.951, 1.085, 0.007> <-1.956, 1.092, -0.005> <-1.952, 1.091, -0.027> <-1.954, 1.093, -0.041> 
		<-1.966, 1.081, 0.007> <-1.965, 1.089, -0.005> <-1.967, 1.087, -0.027> <-1.966, 1.090, -0.041> 
		<-1.977, 1.082, 0.007> <-1.975, 1.091, -0.005> <-1.975, 1.088, -0.027> <-1.975, 1.091, -0.042> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.930, 1.123, -0.043> <-1.924, 1.122, -0.041> <-1.913, 1.121, -0.044> <-1.910, 1.120, -0.038> 
		<-1.931, 1.114, -0.043> <-1.925, 1.113, -0.041> <-1.915, 1.107, -0.044> <-1.912, 1.107, -0.039> 
		<-1.938, 1.102, -0.043> <-1.934, 1.097, -0.042> <-1.924, 1.091, -0.044> <-1.922, 1.089, -0.039> 
		<-1.945, 1.097, -0.043> <-1.942, 1.092, -0.042> <-1.935, 1.083, -0.044> <-1.933, 1.080, -0.039> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.910, 1.120, -0.038> <-1.903, 1.119, -0.028> <-1.899, 1.118, -0.010> <-1.902, 1.119, 0.002> 
		<-1.912, 1.107, -0.039> <-1.905, 1.105, -0.028> <-1.901, 1.103, -0.010> <-1.905, 1.103, 0.002> 
		<-1.922, 1.089, -0.039> <-1.918, 1.083, -0.028> <-1.914, 1.080, -0.010> <-1.916, 1.083, 0.001> 
		<-1.933, 1.080, -0.039> <-1.929, 1.075, -0.029> <-1.927, 1.071, -0.011> <-1.929, 1.074, 0.001> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.902, 1.119, 0.002> <-1.905, 1.119, 0.009> <-1.921, 1.121, 0.013> <-1.924, 1.122, 0.008> 
		<-1.905, 1.103, 0.002> <-1.907, 1.103, 0.008> <-1.922, 1.111, 0.013> <-1.926, 1.111, 0.008> 
		<-1.916, 1.083, 0.001> <-1.918, 1.085, 0.008> <-1.932, 1.094, 0.013> <-1.934, 1.098, 0.007> 
		<-1.929, 1.074, 0.001> <-1.930, 1.075, 0.008> <-1.940, 1.088, 0.013> <-1.942, 1.091, 0.007> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.924, 1.122, 0.008> <-1.933, 1.123, -0.004> <-1.930, 1.123, -0.026> <-1.932, 1.123, -0.041> 
		<-1.926, 1.111, 0.008> <-1.934, 1.112, -0.004> <-1.931, 1.114, -0.026> <-1.933, 1.115, -0.041> 
		<-1.934, 1.098, 0.007> <-1.939, 1.105, -0.005> <-1.938, 1.101, -0.026> <-1.940, 1.103, -0.041> 
		<-1.942, 1.091, 0.007> <-1.947, 1.098, -0.005> <-1.945, 1.096, -0.027> <-1.947, 1.098, -0.041> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.937, 1.153, -0.042> <-1.933, 1.157, -0.041> <-1.924, 1.163, -0.043> <-1.921, 1.165, -0.038> 
		<-1.932, 1.146, -0.042> <-1.927, 1.149, -0.041> <-1.916, 1.152, -0.043> <-1.913, 1.154, -0.038> 
		<-1.928, 1.132, -0.043> <-1.922, 1.131, -0.041> <-1.911, 1.134, -0.043> <-1.908, 1.134, -0.038> 
		<-1.930, 1.123, -0.043> <-1.924, 1.122, -0.041> <-1.913, 1.121, -0.044> <-1.910, 1.120, -0.038> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.921, 1.165, -0.038> <-1.916, 1.169, -0.028> <-1.913, 1.172, -0.009> <-1.916, 1.169, 0.002> 
		<-1.913, 1.154, -0.038> <-1.908, 1.158, -0.028> <-1.903, 1.159, -0.009> <-1.906, 1.157, 0.002> 
		<-1.908, 1.134, -0.038> <-1.902, 1.133, -0.028> <-1.897, 1.134, -0.010> <-1.900, 1.134, 0.002> 
		<-1.910, 1.120, -0.038> <-1.903, 1.119, -0.028> <-1.899, 1.118, -0.010> <-1.902, 1.119, 0.002> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.916, 1.169, 0.002> <-1.917, 1.168, 0.009> <-1.930, 1.158, 0.014> <-1.933, 1.156, 0.008> 
		<-1.906, 1.157, 0.002> <-1.908, 1.156, 0.009> <-1.924, 1.150, 0.014> <-1.927, 1.148, 0.008> 
		<-1.900, 1.134, 0.002> <-1.902, 1.134, 0.009> <-1.919, 1.132, 0.014> <-1.923, 1.132, 0.008> 
		<-1.902, 1.119, 0.002> <-1.905, 1.119, 0.009> <-1.921, 1.121, 0.013> <-1.924, 1.122, 0.008> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.933, 1.156, 0.008> <-1.940, 1.151, -0.004> <-1.937, 1.153, -0.026> <-1.939, 1.152, -0.040> 
		<-1.927, 1.148, 0.008> <-1.934, 1.142, -0.004> <-1.932, 1.146, -0.026> <-1.934, 1.145, -0.040> 
		<-1.923, 1.132, 0.008> <-1.931, 1.134, -0.004> <-1.928, 1.132, -0.026> <-1.931, 1.132, -0.041> 
		<-1.924, 1.122, 0.008> <-1.933, 1.123, -0.004> <-1.930, 1.123, -0.026> <-1.932, 1.123, -0.041> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.964, 1.169, -0.043> <-1.963, 1.174, -0.041> <-1.962, 1.185, -0.044> <-1.961, 1.188, -0.038> 
		<-1.955, 1.167, -0.043> <-1.954, 1.173, -0.041> <-1.948, 1.183, -0.043> <-1.947, 1.186, -0.038> 
		<-1.943, 1.160, -0.042> <-1.938, 1.164, -0.041> <-1.932, 1.174, -0.043> <-1.930, 1.176, -0.038> 
		<-1.937, 1.153, -0.042> <-1.933, 1.157, -0.041> <-1.924, 1.163, -0.043> <-1.921, 1.165, -0.038> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.961, 1.188, -0.038> <-1.960, 1.195, -0.028> <-1.960, 1.200, -0.010> <-1.961, 1.196, 0.002> 
		<-1.947, 1.186, -0.038> <-1.947, 1.193, -0.028> <-1.944, 1.197, -0.010> <-1.945, 1.194, 0.002> 
		<-1.930, 1.176, -0.038> <-1.925, 1.180, -0.028> <-1.922, 1.184, -0.009> <-1.925, 1.182, 0.002> 
		<-1.921, 1.165, -0.038> <-1.916, 1.169, -0.028> <-1.913, 1.172, -0.009> <-1.916, 1.169, 0.002> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.961, 1.196, 0.002> <-1.961, 1.194, 0.009> <-1.963, 1.178, 0.013> <-1.964, 1.174, 0.008> 
		<-1.945, 1.194, 0.002> <-1.945, 1.192, 0.009> <-1.953, 1.176, 0.014> <-1.953, 1.172, 0.008> 
		<-1.925, 1.182, 0.002> <-1.927, 1.181, 0.009> <-1.937, 1.167, 0.014> <-1.940, 1.164, 0.008> 
		<-1.916, 1.169, 0.002> <-1.917, 1.168, 0.009> <-1.930, 1.158, 0.014> <-1.933, 1.156, 0.008> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.964, 1.174, 0.008> <-1.965, 1.166, -0.004> <-1.964, 1.169, -0.026> <-1.964, 1.167, -0.041> 
		<-1.953, 1.172, 0.008> <-1.954, 1.164, -0.004> <-1.955, 1.168, -0.026> <-1.956, 1.165, -0.041> 
		<-1.940, 1.164, 0.008> <-1.946, 1.159, -0.004> <-1.943, 1.160, -0.026> <-1.944, 1.159, -0.040> 
		<-1.933, 1.156, 0.008> <-1.940, 1.151, -0.004> <-1.937, 1.153, -0.026> <-1.939, 1.152, -0.040> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.102, 1.842, -0.043> <-1.106, 1.846, -0.042> <-1.112, 1.855, -0.044> <-1.114, 1.858, -0.039> 
		<-1.095, 1.847, -0.043> <-1.098, 1.852, -0.042> <-1.101, 1.863, -0.044> <-1.103, 1.866, -0.039> 
		<-1.082, 1.851, -0.043> <-1.081, 1.857, -0.041> <-1.084, 1.868, -0.044> <-1.083, 1.871, -0.039> 
		<-1.072, 1.849, -0.043> <-1.072, 1.855, -0.041> <-1.070, 1.866, -0.044> <-1.070, 1.869, -0.038> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.114, 1.858, -0.039> <-1.118, 1.863, -0.029> <-1.122, 1.867, -0.011> <-1.120, 1.864, 0.001> 
		<-1.103, 1.866, -0.039> <-1.107, 1.871, -0.028> <-1.109, 1.876, -0.010> <-1.107, 1.873, 0.001> 
		<-1.083, 1.871, -0.039> <-1.083, 1.878, -0.028> <-1.084, 1.883, -0.010> <-1.085, 1.879, 0.002> 
		<-1.070, 1.869, -0.038> <-1.069, 1.876, -0.028> <-1.068, 1.880, -0.010> <-1.069, 1.877, 0.002> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.120, 1.864, 0.001> <-1.119, 1.862, 0.008> <-1.109, 1.849, 0.013> <-1.107, 1.846, 0.007> 
		<-1.107, 1.873, 0.001> <-1.106, 1.871, 0.008> <-1.101, 1.855, 0.013> <-1.098, 1.852, 0.007> 
		<-1.085, 1.879, 0.002> <-1.085, 1.877, 0.008> <-1.082, 1.860, 0.013> <-1.083, 1.856, 0.008> 
		<-1.069, 1.877, 0.002> <-1.069, 1.875, 0.009> <-1.072, 1.859, 0.013> <-1.072, 1.855, 0.008> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.107, 1.846, 0.007> <-1.101, 1.839, -0.005> <-1.103, 1.842, -0.027> <-1.101, 1.840, -0.041> 
		<-1.098, 1.852, 0.007> <-1.093, 1.846, -0.005> <-1.096, 1.847, -0.026> <-1.094, 1.845, -0.041> 
		<-1.083, 1.856, 0.008> <-1.084, 1.848, -0.004> <-1.081, 1.851, -0.026> <-1.081, 1.849, -0.041> 
		<-1.072, 1.855, 0.008> <-1.073, 1.846, -0.004> <-1.073, 1.850, -0.026> <-1.073, 1.847, -0.041> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.118, 1.815, -0.044> <-1.124, 1.816, -0.042> <-1.134, 1.817, -0.045> <-1.138, 1.818, -0.040> 
		<-1.117, 1.824, -0.044> <-1.123, 1.825, -0.042> <-1.133, 1.831, -0.045> <-1.136, 1.832, -0.040> 
		<-1.110, 1.836, -0.043> <-1.113, 1.841, -0.042> <-1.123, 1.847, -0.045> <-1.125, 1.849, -0.039> 
		<-1.102, 1.842, -0.043> <-1.106, 1.846, -0.042> <-1.112, 1.855, -0.044> <-1.114, 1.858, -0.039> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.138, 1.818, -0.040> <-1.144, 1.819, -0.030> <-1.150, 1.819, -0.012> <-1.146, 1.819, 0.000> 
		<-1.136, 1.832, -0.040> <-1.143, 1.832, -0.029> <-1.148, 1.835, -0.011> <-1.144, 1.834, 0.000> 
		<-1.125, 1.849, -0.039> <-1.130, 1.854, -0.029> <-1.134, 1.857, -0.011> <-1.132, 1.854, 0.001> 
		<-1.114, 1.858, -0.039> <-1.118, 1.863, -0.029> <-1.122, 1.867, -0.011> <-1.120, 1.864, 0.001> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.146, 1.819, 0.000> <-1.144, 1.818, 0.007> <-1.129, 1.816, 0.012> <-1.125, 1.815, 0.007> 
		<-1.144, 1.834, 0.000> <-1.142, 1.834, 0.007> <-1.127, 1.826, 0.012> <-1.123, 1.826, 0.007> 
		<-1.132, 1.854, 0.001> <-1.131, 1.853, 0.007> <-1.118, 1.843, 0.013> <-1.115, 1.840, 0.007> 
		<-1.120, 1.864, 0.001> <-1.119, 1.862, 0.008> <-1.109, 1.849, 0.013> <-1.107, 1.846, 0.007> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.125, 1.815, 0.007> <-1.116, 1.814, -0.005> <-1.118, 1.815, -0.027> <-1.116, 1.815, -0.042> 
		<-1.123, 1.826, 0.007> <-1.114, 1.825, -0.005> <-1.117, 1.824, -0.027> <-1.115, 1.823, -0.041> 
		<-1.115, 1.840, 0.007> <-1.110, 1.833, -0.005> <-1.110, 1.836, -0.027> <-1.108, 1.835, -0.041> 
		<-1.107, 1.846, 0.007> <-1.101, 1.839, -0.005> <-1.103, 1.842, -0.027> <-1.101, 1.840, -0.041> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.110, 1.785, -0.044> <-1.115, 1.782, -0.043> <-1.124, 1.775, -0.045> <-1.126, 1.773, -0.040> 
		<-1.116, 1.793, -0.044> <-1.121, 1.789, -0.043> <-1.132, 1.786, -0.045> <-1.135, 1.784, -0.040> 
		<-1.119, 1.806, -0.044> <-1.125, 1.807, -0.043> <-1.136, 1.804, -0.045> <-1.140, 1.804, -0.040> 
		<-1.118, 1.815, -0.044> <-1.124, 1.816, -0.042> <-1.134, 1.817, -0.045> <-1.138, 1.818, -0.040> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.126, 1.773, -0.040> <-1.132, 1.769, -0.030> <-1.136, 1.766, -0.012> <-1.133, 1.768, -0.000> 
		<-1.135, 1.784, -0.040> <-1.140, 1.780, -0.030> <-1.145, 1.778, -0.012> <-1.143, 1.780, -0.000> 
		<-1.140, 1.804, -0.040> <-1.146, 1.805, -0.030> <-1.152, 1.804, -0.012> <-1.149, 1.803, 0.000> 
		<-1.138, 1.818, -0.040> <-1.144, 1.819, -0.030> <-1.150, 1.819, -0.012> <-1.146, 1.819, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.133, 1.768, -0.000> <-1.132, 1.769, 0.007> <-1.119, 1.779, 0.012> <-1.116, 1.781, 0.006> 
		<-1.143, 1.780, -0.000> <-1.141, 1.782, 0.007> <-1.125, 1.787, 0.012> <-1.122, 1.790, 0.006> 
		<-1.149, 1.803, 0.000> <-1.147, 1.803, 0.007> <-1.130, 1.805, 0.012> <-1.126, 1.805, 0.006> 
		<-1.146, 1.819, 0.000> <-1.144, 1.818, 0.007> <-1.129, 1.816, 0.012> <-1.125, 1.815, 0.007> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.116, 1.781, 0.006> <-1.109, 1.786, -0.005> <-1.111, 1.785, -0.027> <-1.109, 1.786, -0.042> 
		<-1.122, 1.790, 0.006> <-1.115, 1.795, -0.005> <-1.116, 1.792, -0.027> <-1.114, 1.793, -0.042> 
		<-1.126, 1.805, 0.006> <-1.117, 1.804, -0.005> <-1.120, 1.806, -0.027> <-1.117, 1.806, -0.042> 
		<-1.125, 1.815, 0.007> <-1.116, 1.814, -0.005> <-1.118, 1.815, -0.027> <-1.116, 1.815, -0.042> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.084, 1.770, -0.044> <-1.084, 1.764, -0.042> <-1.086, 1.753, -0.045> <-1.086, 1.750, -0.040> 
		<-1.093, 1.771, -0.044> <-1.094, 1.765, -0.043> <-1.100, 1.755, -0.045> <-1.100, 1.752, -0.040> 
		<-1.105, 1.778, -0.044> <-1.109, 1.774, -0.043> <-1.115, 1.764, -0.045> <-1.118, 1.762, -0.040> 
		<-1.110, 1.785, -0.044> <-1.115, 1.782, -0.043> <-1.124, 1.775, -0.045> <-1.126, 1.773, -0.040> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.086, 1.750, -0.040> <-1.087, 1.743, -0.030> <-1.088, 1.738, -0.012> <-1.088, 1.741, 0.000> 
		<-1.100, 1.752, -0.040> <-1.101, 1.745, -0.030> <-1.104, 1.740, -0.012> <-1.104, 1.743, 0.000> 
		<-1.118, 1.762, -0.040> <-1.123, 1.758, -0.030> <-1.126, 1.753, -0.012> <-1.124, 1.755, -0.000> 
		<-1.126, 1.773, -0.040> <-1.132, 1.769, -0.030> <-1.136, 1.766, -0.012> <-1.133, 1.768, -0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.088, 1.741, 0.000> <-1.088, 1.743, 0.007> <-1.086, 1.759, 0.012> <-1.085, 1.763, 0.007> 
		<-1.104, 1.743, 0.000> <-1.103, 1.745, 0.007> <-1.096, 1.761, 0.012> <-1.096, 1.765, 0.006> 
		<-1.124, 1.755, -0.000> <-1.122, 1.756, 0.007> <-1.113, 1.770, 0.012> <-1.109, 1.773, 0.006> 
		<-1.133, 1.768, -0.000> <-1.132, 1.769, 0.007> <-1.119, 1.779, 0.012> <-1.116, 1.781, 0.006> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.085, 1.763, 0.007> <-1.084, 1.772, -0.005> <-1.084, 1.769, -0.027> <-1.083, 1.772, -0.042> 
		<-1.096, 1.765, 0.006> <-1.094, 1.773, -0.005> <-1.093, 1.770, -0.027> <-1.092, 1.773, -0.042> 
		<-1.109, 1.773, 0.006> <-1.102, 1.778, -0.005> <-1.105, 1.778, -0.027> <-1.103, 1.779, -0.042> 
		<-1.116, 1.781, 0.006> <-1.109, 1.786, -0.005> <-1.111, 1.785, -0.027> <-1.109, 1.786, -0.042> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.054, 1.777, -0.043> <-1.050, 1.773, -0.042> <-1.044, 1.764, -0.044> <-1.042, 1.761, -0.039> 
		<-1.061, 1.772, -0.043> <-1.058, 1.767, -0.042> <-1.055, 1.756, -0.045> <-1.053, 1.753, -0.039> 
		<-1.074, 1.768, -0.044> <-1.075, 1.762, -0.042> <-1.072, 1.751, -0.045> <-1.073, 1.748, -0.040> 
		<-1.084, 1.770, -0.044> <-1.084, 1.764, -0.042> <-1.086, 1.753, -0.045> <-1.086, 1.750, -0.040> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.042, 1.761, -0.039> <-1.038, 1.756, -0.029> <-1.035, 1.752, -0.011> <-1.037, 1.754, 0.001> 
		<-1.053, 1.753, -0.039> <-1.049, 1.747, -0.029> <-1.048, 1.742, -0.011> <-1.050, 1.745, 0.001> 
		<-1.073, 1.748, -0.040> <-1.074, 1.741, -0.029> <-1.073, 1.736, -0.011> <-1.073, 1.739, 0.000> 
		<-1.086, 1.750, -0.040> <-1.087, 1.743, -0.030> <-1.088, 1.738, -0.012> <-1.088, 1.741, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.037, 1.754, 0.001> <-1.039, 1.756, 0.008> <-1.049, 1.769, 0.013> <-1.051, 1.772, 0.007> 
		<-1.050, 1.745, 0.001> <-1.051, 1.746, 0.007> <-1.057, 1.762, 0.013> <-1.059, 1.766, 0.007> 
		<-1.073, 1.739, 0.000> <-1.072, 1.741, 0.007> <-1.075, 1.758, 0.012> <-1.075, 1.762, 0.007> 
		<-1.088, 1.741, 0.000> <-1.088, 1.743, 0.007> <-1.086, 1.759, 0.012> <-1.085, 1.763, 0.007> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.051, 1.772, 0.007> <-1.056, 1.779, -0.005> <-1.054, 1.777, -0.027> <-1.055, 1.779, -0.041> 
		<-1.059, 1.766, 0.007> <-1.064, 1.773, -0.005> <-1.061, 1.772, -0.027> <-1.062, 1.774, -0.041> 
		<-1.075, 1.762, 0.007> <-1.073, 1.770, -0.005> <-1.075, 1.768, -0.027> <-1.075, 1.770, -0.041> 
		<-1.085, 1.763, 0.007> <-1.084, 1.772, -0.005> <-1.084, 1.769, -0.027> <-1.083, 1.772, -0.042> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.038, 1.804, -0.043> <-1.032, 1.803, -0.041> <-1.021, 1.802, -0.044> <-1.018, 1.801, -0.038> 
		<-1.039, 1.795, -0.043> <-1.033, 1.794, -0.041> <-1.023, 1.788, -0.044> <-1.020, 1.787, -0.039> 
		<-1.046, 1.783, -0.043> <-1.043, 1.778, -0.042> <-1.033, 1.772, -0.044> <-1.031, 1.770, -0.039> 
		<-1.054, 1.777, -0.043> <-1.050, 1.773, -0.042> <-1.044, 1.764, -0.044> <-1.042, 1.761, -0.039> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.018, 1.801, -0.038> <-1.012, 1.800, -0.028> <-1.007, 1.799, -0.010> <-1.011, 1.799, 0.002> 
		<-1.020, 1.787, -0.039> <-1.014, 1.786, -0.028> <-1.009, 1.784, -0.010> <-1.013, 1.784, 0.002> 
		<-1.031, 1.770, -0.039> <-1.027, 1.764, -0.028> <-1.023, 1.761, -0.010> <-1.025, 1.764, 0.001> 
		<-1.042, 1.761, -0.039> <-1.038, 1.756, -0.029> <-1.035, 1.752, -0.011> <-1.037, 1.754, 0.001> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.011, 1.799, 0.002> <-1.013, 1.800, 0.009> <-1.029, 1.802, 0.013> <-1.033, 1.803, 0.008> 
		<-1.013, 1.784, 0.002> <-1.015, 1.784, 0.008> <-1.030, 1.791, 0.013> <-1.034, 1.792, 0.008> 
		<-1.025, 1.764, 0.001> <-1.026, 1.765, 0.008> <-1.040, 1.775, 0.013> <-1.042, 1.778, 0.007> 
		<-1.037, 1.754, 0.001> <-1.039, 1.756, 0.008> <-1.049, 1.769, 0.013> <-1.051, 1.772, 0.007> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.033, 1.803, 0.008> <-1.041, 1.804, -0.004> <-1.038, 1.804, -0.026> <-1.040, 1.804, -0.041> 
		<-1.034, 1.792, 0.008> <-1.043, 1.793, -0.004> <-1.039, 1.795, -0.026> <-1.041, 1.795, -0.041> 
		<-1.042, 1.778, 0.007> <-1.047, 1.785, -0.005> <-1.047, 1.782, -0.026> <-1.048, 1.784, -0.041> 
		<-1.051, 1.772, 0.007> <-1.056, 1.779, -0.005> <-1.054, 1.777, -0.027> <-1.055, 1.779, -0.041> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.046, 1.834, -0.042> <-1.041, 1.837, -0.041> <-1.032, 1.844, -0.043> <-1.030, 1.846, -0.038> 
		<-1.040, 1.826, -0.042> <-1.035, 1.830, -0.041> <-1.024, 1.833, -0.043> <-1.021, 1.835, -0.038> 
		<-1.037, 1.813, -0.043> <-1.031, 1.812, -0.041> <-1.020, 1.815, -0.043> <-1.016, 1.815, -0.038> 
		<-1.038, 1.804, -0.043> <-1.032, 1.803, -0.041> <-1.021, 1.802, -0.044> <-1.018, 1.801, -0.038> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.030, 1.846, -0.038> <-1.025, 1.850, -0.028> <-1.021, 1.852, -0.009> <-1.024, 1.850, 0.002> 
		<-1.021, 1.835, -0.038> <-1.016, 1.839, -0.028> <-1.011, 1.840, -0.009> <-1.015, 1.838, 0.002> 
		<-1.016, 1.815, -0.038> <-1.010, 1.814, -0.028> <-1.005, 1.815, -0.010> <-1.009, 1.815, 0.002> 
		<-1.018, 1.801, -0.038> <-1.012, 1.800, -0.028> <-1.007, 1.799, -0.010> <-1.011, 1.799, 0.002> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.024, 1.850, 0.002> <-1.026, 1.849, 0.009> <-1.039, 1.839, 0.014> <-1.042, 1.837, 0.008> 
		<-1.015, 1.838, 0.002> <-1.016, 1.836, 0.009> <-1.032, 1.831, 0.014> <-1.035, 1.828, 0.008> 
		<-1.009, 1.815, 0.002> <-1.011, 1.815, 0.009> <-1.028, 1.812, 0.014> <-1.031, 1.813, 0.008> 
		<-1.011, 1.799, 0.002> <-1.013, 1.800, 0.009> <-1.029, 1.802, 0.013> <-1.033, 1.803, 0.008> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.042, 1.837, 0.008> <-1.048, 1.832, -0.004> <-1.046, 1.834, -0.026> <-1.047, 1.832, -0.040> 
		<-1.035, 1.828, 0.008> <-1.042, 1.823, -0.004> <-1.040, 1.827, -0.026> <-1.042, 1.825, -0.040> 
		<-1.031, 1.813, 0.008> <-1.040, 1.814, -0.004> <-1.037, 1.812, -0.026> <-1.039, 1.813, -0.041> 
		<-1.033, 1.803, 0.008> <-1.041, 1.804, -0.004> <-1.038, 1.804, -0.026> <-1.040, 1.804, -0.041> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.072, 1.849, -0.043> <-1.072, 1.855, -0.041> <-1.070, 1.866, -0.044> <-1.070, 1.869, -0.038> 
		<-1.063, 1.848, -0.043> <-1.062, 1.854, -0.041> <-1.056, 1.864, -0.043> <-1.056, 1.867, -0.038> 
		<-1.051, 1.841, -0.042> <-1.047, 1.845, -0.041> <-1.041, 1.855, -0.043> <-1.038, 1.857, -0.038> 
		<-1.046, 1.834, -0.042> <-1.041, 1.837, -0.041> <-1.032, 1.844, -0.043> <-1.030, 1.846, -0.038> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.070, 1.869, -0.038> <-1.069, 1.876, -0.028> <-1.068, 1.880, -0.010> <-1.069, 1.877, 0.002> 
		<-1.056, 1.867, -0.038> <-1.055, 1.874, -0.028> <-1.053, 1.878, -0.010> <-1.054, 1.875, 0.002> 
		<-1.038, 1.857, -0.038> <-1.033, 1.861, -0.028> <-1.030, 1.865, -0.009> <-1.033, 1.863, 0.002> 
		<-1.030, 1.846, -0.038> <-1.025, 1.850, -0.028> <-1.021, 1.852, -0.009> <-1.024, 1.850, 0.002> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.069, 1.877, 0.002> <-1.069, 1.875, 0.009> <-1.072, 1.859, 0.013> <-1.072, 1.855, 0.008> 
		<-1.054, 1.875, 0.002> <-1.054, 1.873, 0.009> <-1.061, 1.857, 0.014> <-1.062, 1.853, 0.008> 
		<-1.033, 1.863, 0.002> <-1.035, 1.861, 0.009> <-1.045, 1.848, 0.014> <-1.048, 1.845, 0.008> 
		<-1.024, 1.850, 0.002> <-1.026, 1.849, 0.009> <-1.039, 1.839, 0.014> <-1.042, 1.837, 0.008> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.072, 1.855, 0.008> <-1.073, 1.846, -0.004> <-1.073, 1.850, -0.026> <-1.073, 1.847, -0.041> 
		<-1.062, 1.853, 0.008> <-1.063, 1.845, -0.004> <-1.064, 1.848, -0.026> <-1.064, 1.846, -0.041> 
		<-1.048, 1.845, 0.008> <-1.055, 1.840, -0.004> <-1.051, 1.841, -0.026> <-1.053, 1.839, -0.040> 
		<-1.042, 1.837, 0.008> <-1.048, 1.832, -0.004> <-1.046, 1.834, -0.026> <-1.047, 1.832, -0.040> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.052, 1.158, 0.078> <-2.051, 1.160, 0.089> <-2.053, 1.157, 0.110> <-2.048, 1.165, 0.116> 
		<-2.063, 1.170, 0.078> <-2.062, 1.172, 0.089> <-2.070, 1.174, 0.110> <-2.065, 1.183, 0.116> 
		<-2.079, 1.185, 0.067> <-2.083, 1.193, 0.075> <-2.090, 1.195, 0.096> <-2.088, 1.206, 0.100> 
		<-2.087, 1.193, 0.055> <-2.091, 1.200, 0.063> <-2.102, 1.207, 0.078> <-2.100, 1.217, 0.082> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.048, 1.165, 0.116> <-2.038, 1.180, 0.128> <-2.021, 1.208, 0.137> <-2.010, 1.225, 0.129> 
		<-2.065, 1.183, 0.116> <-2.055, 1.198, 0.128> <-2.040, 1.228, 0.137> <-2.030, 1.245, 0.129> 
		<-2.088, 1.206, 0.100> <-2.084, 1.226, 0.108> <-2.071, 1.256, 0.117> <-2.056, 1.271, 0.111> 
		<-2.100, 1.217, 0.082> <-2.096, 1.238, 0.090> <-2.084, 1.269, 0.096> <-2.069, 1.284, 0.090> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.010, 1.225, 0.129> <-2.004, 1.235, 0.124> <-2.000, 1.242, 0.094> <-2.006, 1.232, 0.086> 
		<-2.030, 1.245, 0.129> <-2.023, 1.255, 0.124> <-2.013, 1.255, 0.094> <-2.019, 1.246, 0.086> 
		<-2.056, 1.271, 0.111> <-2.048, 1.280, 0.108> <-2.035, 1.275, 0.078> <-2.037, 1.264, 0.074> 
		<-2.069, 1.284, 0.090> <-2.061, 1.293, 0.087> <-2.044, 1.284, 0.064> <-2.046, 1.273, 0.060> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.006, 1.232, 0.086> <-2.016, 1.215, 0.071> <-2.037, 1.182, 0.077> <-2.050, 1.161, 0.074> 
		<-2.019, 1.246, 0.086> <-2.029, 1.229, 0.071> <-2.048, 1.194, 0.077> <-2.061, 1.172, 0.074> 
		<-2.037, 1.264, 0.074> <-2.040, 1.240, 0.063> <-2.065, 1.211, 0.066> <-2.076, 1.187, 0.063> 
		<-2.046, 1.273, 0.060> <-2.049, 1.249, 0.049> <-2.072, 1.218, 0.054> <-2.083, 1.194, 0.052> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.018, 1.122, 0.055> <-2.012, 1.118, 0.063> <-2.005, 1.105, 0.078> <-1.997, 1.111, 0.082> 
		<-2.025, 1.130, 0.067> <-2.019, 1.127, 0.075> <-2.016, 1.118, 0.096> <-2.008, 1.123, 0.100> 
		<-2.041, 1.146, 0.078> <-2.039, 1.148, 0.089> <-2.036, 1.139, 0.110> <-2.031, 1.147, 0.116> 
		<-2.052, 1.158, 0.078> <-2.051, 1.160, 0.089> <-2.053, 1.157, 0.110> <-2.048, 1.165, 0.116> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.997, 1.111, 0.082> <-1.981, 1.121, 0.091> <-1.960, 1.144, 0.096> <-1.953, 1.163, 0.090> 
		<-2.008, 1.123, 0.100> <-1.992, 1.133, 0.109> <-1.972, 1.158, 0.116> <-1.965, 1.177, 0.111> 
		<-2.031, 1.147, 0.116> <-2.021, 1.163, 0.128> <-2.002, 1.188, 0.137> <-1.991, 1.205, 0.129> 
		<-2.048, 1.165, 0.116> <-2.038, 1.180, 0.128> <-2.021, 1.208, 0.137> <-2.010, 1.225, 0.129> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.953, 1.163, 0.090> <-1.948, 1.175, 0.087> <-1.956, 1.197, 0.066> <-1.967, 1.191, 0.060> 
		<-1.965, 1.177, 0.111> <-1.961, 1.189, 0.108> <-1.965, 1.206, 0.080> <-1.975, 1.200, 0.074> 
		<-1.991, 1.205, 0.129> <-1.985, 1.215, 0.124> <-1.987, 1.228, 0.094> <-1.993, 1.219, 0.086> 
		<-2.010, 1.225, 0.129> <-2.004, 1.235, 0.124> <-2.000, 1.242, 0.094> <-2.006, 1.232, 0.086> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.967, 1.191, 0.060> <-1.986, 1.180, 0.048> <-2.003, 1.146, 0.054> <-2.018, 1.126, 0.052> 
		<-1.975, 1.200, 0.074> <-1.994, 1.189, 0.062> <-2.010, 1.154, 0.066> <-2.025, 1.134, 0.063> 
		<-1.993, 1.219, 0.086> <-2.003, 1.201, 0.071> <-2.026, 1.171, 0.077> <-2.039, 1.150, 0.074> 
		<-2.006, 1.232, 0.086> <-2.016, 1.215, 0.071> <-2.037, 1.182, 0.077> <-2.050, 1.161, 0.074> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.005, 1.106, -0.000> <-1.996, 1.100, -0.000> <-1.986, 1.083, -0.000> <-1.977, 1.086, -0.001> 
		<-2.004, 1.106, 0.017> <-1.996, 1.100, 0.017> <-1.986, 1.083, 0.026> <-1.976, 1.087, 0.026> 
		<-2.010, 1.113, 0.042> <-2.004, 1.110, 0.050> <-1.993, 1.092, 0.058> <-1.985, 1.097, 0.062> 
		<-2.018, 1.122, 0.055> <-2.012, 1.118, 0.063> <-2.005, 1.105, 0.078> <-1.997, 1.111, 0.082> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.977, 1.086, -0.001> <-1.958, 1.094, -0.001> <-1.936, 1.116, -0.003> <-1.930, 1.136, -0.003> 
		<-1.976, 1.087, 0.026> <-1.957, 1.095, 0.025> <-1.935, 1.117, 0.028> <-1.930, 1.136, 0.027> 
		<-1.985, 1.097, 0.062> <-1.969, 1.108, 0.071> <-1.946, 1.129, 0.073> <-1.939, 1.148, 0.068> 
		<-1.997, 1.111, 0.082> <-1.981, 1.121, 0.091> <-1.960, 1.144, 0.096> <-1.953, 1.163, 0.090> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.930, 1.136, -0.003> <-1.926, 1.148, -0.004> <-1.939, 1.176, -0.004> <-1.951, 1.172, -0.004> 
		<-1.930, 1.136, 0.027> <-1.926, 1.149, 0.026> <-1.939, 1.177, 0.016> <-1.951, 1.173, 0.017> 
		<-1.939, 1.148, 0.068> <-1.935, 1.160, 0.065> <-1.947, 1.186, 0.051> <-1.957, 1.181, 0.045> 
		<-1.953, 1.163, 0.090> <-1.948, 1.175, 0.087> <-1.956, 1.197, 0.066> <-1.967, 1.191, 0.060> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.951, 1.172, -0.004> <-1.975, 1.165, -0.003> <-1.989, 1.129, -0.001> <-2.005, 1.111, -0.000> 
		<-1.951, 1.173, 0.017> <-1.974, 1.165, 0.018> <-1.989, 1.130, 0.015> <-2.005, 1.112, 0.016> 
		<-1.957, 1.181, 0.045> <-1.977, 1.170, 0.033> <-1.995, 1.137, 0.042> <-2.010, 1.118, 0.039> 
		<-1.967, 1.191, 0.060> <-1.986, 1.180, 0.048> <-2.003, 1.146, 0.054> <-2.018, 1.126, 0.052> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.020, 1.119, -0.055> <-2.014, 1.115, -0.064> <-2.008, 1.101, -0.078> <-1.999, 1.106, -0.083> 
		<-2.011, 1.111, -0.042> <-2.005, 1.107, -0.051> <-1.995, 1.089, -0.058> <-1.987, 1.094, -0.063> 
		<-2.005, 1.105, -0.018> <-1.997, 1.099, -0.018> <-1.987, 1.082, -0.027> <-1.977, 1.086, -0.027> 
		<-2.005, 1.106, -0.000> <-1.996, 1.100, -0.000> <-1.986, 1.083, -0.000> <-1.977, 1.086, -0.001> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.999, 1.106, -0.083> <-1.984, 1.116, -0.093> <-1.963, 1.139, -0.101> <-1.956, 1.158, -0.097> 
		<-1.987, 1.094, -0.063> <-1.971, 1.104, -0.073> <-1.949, 1.125, -0.078> <-1.941, 1.144, -0.075> 
		<-1.977, 1.086, -0.027> <-1.958, 1.093, -0.028> <-1.936, 1.115, -0.032> <-1.931, 1.135, -0.033> 
		<-1.977, 1.086, -0.001> <-1.958, 1.094, -0.001> <-1.936, 1.116, -0.003> <-1.930, 1.136, -0.003> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.956, 1.158, -0.097> <-1.951, 1.170, -0.095> <-1.959, 1.193, -0.074> <-1.969, 1.187, -0.067> 
		<-1.941, 1.144, -0.075> <-1.937, 1.156, -0.072> <-1.949, 1.183, -0.059> <-1.959, 1.178, -0.052> 
		<-1.931, 1.135, -0.033> <-1.927, 1.147, -0.034> <-1.940, 1.176, -0.024> <-1.952, 1.172, -0.024> 
		<-1.930, 1.136, -0.003> <-1.926, 1.148, -0.004> <-1.939, 1.176, -0.004> <-1.951, 1.172, -0.004> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.969, 1.187, -0.067> <-1.987, 1.177, -0.054> <-2.004, 1.143, -0.057> <-2.020, 1.124, -0.053> 
		<-1.959, 1.178, -0.052> <-1.978, 1.168, -0.039> <-1.996, 1.135, -0.045> <-2.012, 1.116, -0.040> 
		<-1.952, 1.172, -0.024> <-1.975, 1.164, -0.023> <-1.989, 1.129, -0.018> <-2.006, 1.111, -0.017> 
		<-1.951, 1.172, -0.004> <-1.975, 1.165, -0.003> <-1.989, 1.129, -0.001> <-2.005, 1.111, -0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.055, 1.154, -0.078> <-2.054, 1.155, -0.090> <-2.056, 1.151, -0.110> <-2.051, 1.159, -0.117> 
		<-2.043, 1.142, -0.078> <-2.042, 1.144, -0.090> <-2.040, 1.133, -0.110> <-2.035, 1.141, -0.117> 
		<-2.028, 1.126, -0.068> <-2.022, 1.123, -0.076> <-2.019, 1.113, -0.096> <-2.011, 1.118, -0.101> 
		<-2.020, 1.119, -0.055> <-2.014, 1.115, -0.064> <-2.008, 1.101, -0.078> <-1.999, 1.106, -0.083> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.051, 1.159, -0.117> <-2.042, 1.173, -0.131> <-2.026, 1.200, -0.142> <-2.015, 1.218, -0.136> 
		<-2.035, 1.141, -0.117> <-2.025, 1.156, -0.131> <-2.006, 1.180, -0.142> <-1.996, 1.198, -0.136> 
		<-2.011, 1.118, -0.101> <-1.996, 1.127, -0.111> <-1.976, 1.152, -0.121> <-1.969, 1.171, -0.118> 
		<-1.999, 1.106, -0.083> <-1.984, 1.116, -0.093> <-1.963, 1.139, -0.101> <-1.956, 1.158, -0.097> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.015, 1.218, -0.136> <-2.008, 1.228, -0.132> <-2.003, 1.236, -0.102> <-2.009, 1.228, -0.093> 
		<-1.996, 1.198, -0.136> <-1.989, 1.208, -0.132> <-1.990, 1.223, -0.102> <-1.996, 1.214, -0.093> 
		<-1.969, 1.171, -0.118> <-1.964, 1.183, -0.115> <-1.968, 1.201, -0.088> <-1.978, 1.196, -0.081> 
		<-1.956, 1.158, -0.097> <-1.951, 1.170, -0.095> <-1.959, 1.193, -0.074> <-1.969, 1.187, -0.067> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.009, 1.228, -0.093> <-2.019, 1.211, -0.077> <-2.039, 1.178, -0.080> <-2.053, 1.157, -0.074> 
		<-1.996, 1.214, -0.093> <-2.006, 1.198, -0.077> <-2.029, 1.167, -0.080> <-2.042, 1.146, -0.074> 
		<-1.978, 1.196, -0.081> <-1.996, 1.186, -0.068> <-2.012, 1.150, -0.069> <-2.027, 1.131, -0.064> 
		<-1.969, 1.187, -0.067> <-1.987, 1.177, -0.054> <-2.004, 1.143, -0.057> <-2.020, 1.124, -0.053> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.089, 1.190, -0.055> <-2.093, 1.197, -0.064> <-2.104, 1.203, -0.078> <-2.102, 1.213, -0.083> 
		<-2.081, 1.182, -0.068> <-2.085, 1.189, -0.076> <-2.093, 1.190, -0.097> <-2.091, 1.201, -0.101> 
		<-2.066, 1.166, -0.078> <-2.065, 1.167, -0.090> <-2.074, 1.168, -0.110> <-2.069, 1.176, -0.117> 
		<-2.055, 1.154, -0.078> <-2.054, 1.155, -0.090> <-2.056, 1.151, -0.110> <-2.051, 1.159, -0.117> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.102, 1.213, -0.083> <-2.099, 1.233, -0.093> <-2.088, 1.264, -0.101> <-2.072, 1.279, -0.097> 
		<-2.091, 1.201, -0.101> <-2.088, 1.221, -0.111> <-2.075, 1.250, -0.122> <-2.060, 1.265, -0.118> 
		<-2.069, 1.176, -0.117> <-2.059, 1.191, -0.131> <-2.045, 1.220, -0.142> <-2.034, 1.238, -0.136> 
		<-2.051, 1.159, -0.117> <-2.042, 1.173, -0.131> <-2.026, 1.200, -0.142> <-2.015, 1.218, -0.136> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.072, 1.279, -0.097> <-2.064, 1.288, -0.095> <-2.046, 1.280, -0.072> <-2.048, 1.269, -0.067> 
		<-2.060, 1.265, -0.118> <-2.052, 1.274, -0.115> <-2.038, 1.271, -0.086> <-2.039, 1.260, -0.081> 
		<-2.034, 1.238, -0.136> <-2.027, 1.248, -0.132> <-2.016, 1.250, -0.102> <-2.022, 1.241, -0.093> 
		<-2.015, 1.218, -0.136> <-2.008, 1.228, -0.132> <-2.003, 1.236, -0.102> <-2.009, 1.228, -0.093> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.048, 1.269, -0.067> <-2.051, 1.246, -0.055> <-2.074, 1.215, -0.057> <-2.085, 1.191, -0.053> 
		<-2.039, 1.260, -0.081> <-2.042, 1.237, -0.069> <-2.067, 1.207, -0.069> <-2.078, 1.184, -0.064> 
		<-2.022, 1.241, -0.093> <-2.032, 1.225, -0.077> <-2.050, 1.189, -0.080> <-2.063, 1.168, -0.074> 
		<-2.009, 1.228, -0.093> <-2.019, 1.211, -0.077> <-2.039, 1.178, -0.080> <-2.053, 1.157, -0.074> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.102, 1.206, -0.000> <-2.108, 1.216, -0.000> <-2.123, 1.226, -0.000> <-2.122, 1.237, -0.001> 
		<-2.102, 1.206, -0.018> <-2.108, 1.215, -0.018> <-2.124, 1.226, -0.027> <-2.123, 1.237, -0.027> 
		<-2.096, 1.199, -0.042> <-2.101, 1.206, -0.051> <-2.116, 1.216, -0.059> <-2.114, 1.226, -0.064> 
		<-2.089, 1.190, -0.055> <-2.093, 1.197, -0.064> <-2.104, 1.203, -0.078> <-2.102, 1.213, -0.083> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.122, 1.237, -0.001> <-2.121, 1.260, -0.001> <-2.112, 1.292, -0.002> <-2.095, 1.307, -0.003> 
		<-2.123, 1.237, -0.027> <-2.121, 1.259, -0.028> <-2.113, 1.291, -0.033> <-2.096, 1.306, -0.033> 
		<-2.114, 1.226, -0.064> <-2.111, 1.246, -0.073> <-2.101, 1.279, -0.079> <-2.086, 1.294, -0.075> 
		<-2.102, 1.213, -0.083> <-2.099, 1.233, -0.093> <-2.088, 1.264, -0.101> <-2.072, 1.279, -0.097> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.095, 1.307, -0.003> <-2.087, 1.314, -0.004> <-2.063, 1.299, -0.004> <-2.063, 1.288, -0.004> 
		<-2.096, 1.306, -0.033> <-2.087, 1.313, -0.034> <-2.063, 1.299, -0.024> <-2.063, 1.287, -0.024> 
		<-2.086, 1.294, -0.075> <-2.078, 1.303, -0.072> <-2.055, 1.290, -0.057> <-2.057, 1.279, -0.052> 
		<-2.072, 1.279, -0.097> <-2.064, 1.288, -0.095> <-2.046, 1.280, -0.072> <-2.048, 1.269, -0.067> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.063, 1.288, -0.004> <-2.064, 1.261, -0.003> <-2.087, 1.231, -0.001> <-2.098, 1.207, -0.000> 
		<-2.063, 1.287, -0.024> <-2.064, 1.261, -0.023> <-2.087, 1.231, -0.018> <-2.098, 1.206, -0.017> 
		<-2.057, 1.279, -0.052> <-2.060, 1.256, -0.040> <-2.081, 1.223, -0.045> <-2.092, 1.200, -0.040> 
		<-2.048, 1.269, -0.067> <-2.051, 1.246, -0.055> <-2.074, 1.215, -0.057> <-2.085, 1.191, -0.053> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.087, 1.193, 0.055> <-2.091, 1.200, 0.063> <-2.102, 1.207, 0.078> <-2.100, 1.217, 0.082> 
		<-2.095, 1.201, 0.042> <-2.099, 1.208, 0.050> <-2.114, 1.219, 0.058> <-2.112, 1.230, 0.062> 
		<-2.102, 1.207, 0.017> <-2.108, 1.216, 0.017> <-2.123, 1.227, 0.026> <-2.122, 1.238, 0.026> 
		<-2.102, 1.206, -0.000> <-2.108, 1.216, -0.000> <-2.123, 1.226, -0.000> <-2.122, 1.237, -0.001> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.100, 1.217, 0.082> <-2.096, 1.238, 0.090> <-2.084, 1.269, 0.096> <-2.069, 1.284, 0.090> 
		<-2.112, 1.230, 0.062> <-2.108, 1.250, 0.070> <-2.099, 1.283, 0.074> <-2.084, 1.298, 0.068> 
		<-2.122, 1.238, 0.026> <-2.120, 1.260, 0.025> <-2.112, 1.293, 0.027> <-2.095, 1.308, 0.027> 
		<-2.122, 1.237, -0.001> <-2.121, 1.260, -0.001> <-2.112, 1.292, -0.002> <-2.095, 1.307, -0.003> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.069, 1.284, 0.090> <-2.061, 1.293, 0.087> <-2.044, 1.284, 0.064> <-2.046, 1.273, 0.060> 
		<-2.084, 1.298, 0.068> <-2.076, 1.306, 0.065> <-2.053, 1.293, 0.049> <-2.055, 1.282, 0.045> 
		<-2.095, 1.308, 0.027> <-2.086, 1.315, 0.026> <-2.062, 1.300, 0.016> <-2.063, 1.288, 0.016> 
		<-2.095, 1.307, -0.003> <-2.087, 1.314, -0.004> <-2.063, 1.299, -0.004> <-2.063, 1.288, -0.004> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.046, 1.273, 0.060> <-2.049, 1.249, 0.049> <-2.072, 1.218, 0.054> <-2.083, 1.194, 0.052> 
		<-2.055, 1.282, 0.045> <-2.059, 1.258, 0.034> <-2.080, 1.225, 0.042> <-2.091, 1.202, 0.039> 
		<-2.063, 1.288, 0.016> <-2.063, 1.262, 0.017> <-2.087, 1.232, 0.015> <-2.097, 1.207, 0.016> 
		<-2.063, 1.288, -0.004> <-2.064, 1.261, -0.003> <-2.087, 1.231, -0.001> <-2.098, 1.207, -0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.124, 1.879, 0.076> <-1.122, 1.880, 0.088> <-1.126, 1.878, 0.108> <-1.117, 1.881, 0.115> 
		<-1.125, 1.895, 0.077> <-1.123, 1.896, 0.088> <-1.129, 1.902, 0.109> <-1.119, 1.905, 0.116> 
		<-1.128, 1.918, 0.067> <-1.127, 1.926, 0.075> <-1.131, 1.932, 0.096> <-1.123, 1.939, 0.101> 
		<-1.129, 1.929, 0.055> <-1.128, 1.937, 0.063> <-1.133, 1.948, 0.078> <-1.125, 1.955, 0.083> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.117, 1.881, 0.115> <-1.100, 1.887, 0.127> <-1.070, 1.897, 0.137> <-1.051, 1.905, 0.130> 
		<-1.119, 1.905, 0.116> <-1.103, 1.911, 0.128> <-1.073, 1.925, 0.138> <-1.054, 1.932, 0.131> 
		<-1.123, 1.939, 0.101> <-1.108, 1.952, 0.109> <-1.079, 1.967, 0.119> <-1.058, 1.970, 0.114> 
		<-1.125, 1.955, 0.083> <-1.110, 1.969, 0.092> <-1.081, 1.986, 0.099> <-1.060, 1.989, 0.093> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.051, 1.905, 0.130> <-1.039, 1.909, 0.126> <-1.032, 1.912, 0.095> <-1.042, 1.909, 0.087> 
		<-1.054, 1.932, 0.131> <-1.042, 1.936, 0.126> <-1.034, 1.931, 0.096> <-1.044, 1.928, 0.088> 
		<-1.058, 1.970, 0.114> <-1.046, 1.972, 0.111> <-1.038, 1.961, 0.081> <-1.046, 1.953, 0.076> 
		<-1.060, 1.989, 0.093> <-1.048, 1.990, 0.090> <-1.040, 1.974, 0.067> <-1.048, 1.966, 0.062> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.042, 1.909, 0.087> <-1.061, 1.902, 0.071> <-1.097, 1.889, 0.077> <-1.121, 1.880, 0.072> 
		<-1.044, 1.928, 0.088> <-1.063, 1.921, 0.072> <-1.098, 1.904, 0.077> <-1.122, 1.896, 0.073> 
		<-1.046, 1.953, 0.076> <-1.064, 1.937, 0.065> <-1.101, 1.929, 0.066> <-1.124, 1.917, 0.063> 
		<-1.048, 1.966, 0.062> <-1.065, 1.950, 0.051> <-1.102, 1.939, 0.055> <-1.126, 1.928, 0.052> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.119, 1.830, 0.052> <-1.116, 1.824, 0.060> <-1.119, 1.809, 0.074> <-1.109, 1.808, 0.079> 
		<-1.120, 1.841, 0.065> <-1.117, 1.834, 0.073> <-1.121, 1.825, 0.093> <-1.111, 1.824, 0.098> 
		<-1.122, 1.863, 0.076> <-1.120, 1.863, 0.088> <-1.123, 1.853, 0.108> <-1.114, 1.856, 0.115> 
		<-1.124, 1.879, 0.076> <-1.122, 1.880, 0.088> <-1.126, 1.878, 0.108> <-1.117, 1.881, 0.115> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.109, 1.808, 0.079> <-1.091, 1.806, 0.088> <-1.060, 1.811, 0.094> <-1.043, 1.822, 0.089> 
		<-1.111, 1.824, 0.098> <-1.092, 1.822, 0.107> <-1.062, 1.829, 0.115> <-1.044, 1.840, 0.110> 
		<-1.114, 1.856, 0.115> <-1.098, 1.862, 0.127> <-1.067, 1.870, 0.136> <-1.048, 1.877, 0.129> 
		<-1.117, 1.881, 0.115> <-1.100, 1.887, 0.127> <-1.070, 1.897, 0.137> <-1.051, 1.905, 0.130> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.043, 1.822, 0.089> <-1.032, 1.828, 0.086> <-1.025, 1.851, 0.065> <-1.036, 1.853, 0.059> 
		<-1.044, 1.840, 0.110> <-1.033, 1.846, 0.107> <-1.026, 1.863, 0.080> <-1.037, 1.865, 0.074> 
		<-1.048, 1.877, 0.129> <-1.036, 1.881, 0.125> <-1.030, 1.894, 0.095> <-1.040, 1.890, 0.086> 
		<-1.051, 1.905, 0.130> <-1.039, 1.909, 0.126> <-1.032, 1.912, 0.095> <-1.042, 1.909, 0.087> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.036, 1.853, 0.059> <-1.058, 1.857, 0.048> <-1.092, 1.840, 0.052> <-1.116, 1.834, 0.049> 
		<-1.037, 1.865, 0.074> <-1.059, 1.869, 0.062> <-1.093, 1.850, 0.064> <-1.117, 1.844, 0.061> 
		<-1.040, 1.890, 0.086> <-1.059, 1.884, 0.071> <-1.095, 1.873, 0.076> <-1.119, 1.865, 0.072> 
		<-1.042, 1.909, 0.087> <-1.061, 1.902, 0.071> <-1.097, 1.889, 0.077> <-1.121, 1.880, 0.072> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.117, 1.811, -0.004> <-1.114, 1.801, -0.004> <-1.117, 1.782, -0.004> <-1.107, 1.779, -0.005> 
		<-1.117, 1.811, 0.014> <-1.114, 1.801, 0.014> <-1.117, 1.781, 0.022> <-1.107, 1.778, 0.022> 
		<-1.118, 1.819, 0.039> <-1.115, 1.812, 0.047> <-1.118, 1.792, 0.054> <-1.108, 1.791, 0.059> 
		<-1.119, 1.830, 0.052> <-1.116, 1.824, 0.060> <-1.119, 1.809, 0.074> <-1.109, 1.808, 0.079> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.107, 1.779, -0.005> <-1.088, 1.773, -0.005> <-1.057, 1.777, -0.006> <-1.040, 1.789, -0.006> 
		<-1.107, 1.778, 0.022> <-1.087, 1.773, 0.021> <-1.056, 1.776, 0.024> <-1.040, 1.788, 0.024> 
		<-1.108, 1.791, 0.059> <-1.089, 1.788, 0.068> <-1.058, 1.792, 0.071> <-1.041, 1.802, 0.066> 
		<-1.109, 1.808, 0.079> <-1.091, 1.806, 0.088> <-1.060, 1.811, 0.094> <-1.043, 1.822, 0.089> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.040, 1.789, -0.006> <-1.030, 1.796, -0.006> <-1.022, 1.826, -0.005> <-1.034, 1.831, -0.005> 
		<-1.040, 1.788, 0.024> <-1.029, 1.796, 0.024> <-1.022, 1.826, 0.015> <-1.034, 1.830, 0.016> 
		<-1.041, 1.802, 0.066> <-1.030, 1.809, 0.063> <-1.023, 1.838, 0.050> <-1.035, 1.840, 0.044> 
		<-1.043, 1.822, 0.089> <-1.032, 1.828, 0.086> <-1.025, 1.851, 0.065> <-1.036, 1.853, 0.059> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.034, 1.831, -0.005> <-1.057, 1.839, -0.004> <-1.090, 1.820, -0.004> <-1.114, 1.816, -0.003> 
		<-1.034, 1.830, 0.016> <-1.057, 1.839, 0.016> <-1.090, 1.820, 0.013> <-1.114, 1.815, 0.013> 
		<-1.035, 1.840, 0.044> <-1.056, 1.843, 0.032> <-1.091, 1.829, 0.040> <-1.115, 1.823, 0.037> 
		<-1.036, 1.853, 0.059> <-1.058, 1.857, 0.048> <-1.092, 1.840, 0.052> <-1.116, 1.834, 0.049> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.120, 1.832, -0.058> <-1.117, 1.826, -0.067> <-1.121, 1.812, -0.081> <-1.111, 1.811, -0.086> 
		<-1.119, 1.820, -0.045> <-1.116, 1.814, -0.054> <-1.119, 1.794, -0.062> <-1.109, 1.793, -0.067> 
		<-1.118, 1.811, -0.021> <-1.114, 1.802, -0.021> <-1.117, 1.782, -0.031> <-1.107, 1.779, -0.031> 
		<-1.117, 1.811, -0.004> <-1.114, 1.801, -0.004> <-1.117, 1.782, -0.004> <-1.107, 1.779, -0.005> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.111, 1.811, -0.086> <-1.093, 1.809, -0.096> <-1.062, 1.815, -0.103> <-1.045, 1.825, -0.098> 
		<-1.109, 1.793, -0.067> <-1.091, 1.791, -0.077> <-1.060, 1.794, -0.081> <-1.042, 1.805, -0.077> 
		<-1.107, 1.779, -0.031> <-1.088, 1.774, -0.031> <-1.057, 1.778, -0.036> <-1.040, 1.789, -0.036> 
		<-1.107, 1.779, -0.005> <-1.088, 1.773, -0.005> <-1.057, 1.777, -0.006> <-1.040, 1.789, -0.006> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.045, 1.825, -0.098> <-1.034, 1.832, -0.096> <-1.026, 1.854, -0.074> <-1.037, 1.855, -0.068> 
		<-1.042, 1.805, -0.077> <-1.031, 1.811, -0.074> <-1.025, 1.840, -0.059> <-1.036, 1.841, -0.053> 
		<-1.040, 1.789, -0.036> <-1.030, 1.797, -0.036> <-1.022, 1.827, -0.025> <-1.034, 1.831, -0.025> 
		<-1.040, 1.789, -0.006> <-1.030, 1.796, -0.006> <-1.022, 1.826, -0.005> <-1.034, 1.831, -0.005> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.037, 1.855, -0.068> <-1.058, 1.858, -0.055> <-1.093, 1.842, -0.059> <-1.117, 1.836, -0.055> 
		<-1.036, 1.841, -0.053> <-1.057, 1.845, -0.040> <-1.092, 1.830, -0.047> <-1.116, 1.825, -0.043> 
		<-1.034, 1.831, -0.025> <-1.057, 1.839, -0.024> <-1.091, 1.821, -0.021> <-1.115, 1.816, -0.020> 
		<-1.034, 1.831, -0.005> <-1.057, 1.839, -0.004> <-1.090, 1.820, -0.004> <-1.114, 1.816, -0.003> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.125, 1.882, -0.080> <-1.124, 1.883, -0.091> <-1.128, 1.882, -0.112> <-1.119, 1.885, -0.119> 
		<-1.124, 1.866, -0.080> <-1.122, 1.867, -0.092> <-1.126, 1.857, -0.112> <-1.117, 1.861, -0.119> 
		<-1.121, 1.844, -0.070> <-1.119, 1.837, -0.078> <-1.123, 1.828, -0.099> <-1.113, 1.827, -0.104> 
		<-1.120, 1.832, -0.058> <-1.117, 1.826, -0.067> <-1.121, 1.812, -0.081> <-1.111, 1.811, -0.086> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.119, 1.885, -0.119> <-1.103, 1.891, -0.131> <-1.073, 1.903, -0.142> <-1.054, 1.909, -0.135> 
		<-1.117, 1.861, -0.119> <-1.100, 1.867, -0.132> <-1.070, 1.875, -0.142> <-1.051, 1.882, -0.136> 
		<-1.113, 1.827, -0.104> <-1.095, 1.826, -0.114> <-1.064, 1.834, -0.123> <-1.047, 1.844, -0.119> 
		<-1.111, 1.811, -0.086> <-1.093, 1.809, -0.096> <-1.062, 1.815, -0.103> <-1.045, 1.825, -0.098> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.054, 1.909, -0.135> <-1.042, 1.914, -0.131> <-1.034, 1.916, -0.101> <-1.044, 1.912, -0.092> 
		<-1.051, 1.882, -0.136> <-1.039, 1.886, -0.132> <-1.032, 1.897, -0.101> <-1.042, 1.894, -0.093> 
		<-1.047, 1.844, -0.119> <-1.036, 1.851, -0.116> <-1.028, 1.866, -0.088> <-1.039, 1.868, -0.081> 
		<-1.045, 1.825, -0.098> <-1.034, 1.832, -0.096> <-1.026, 1.854, -0.074> <-1.037, 1.855, -0.068> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.044, 1.912, -0.092> <-1.062, 1.905, -0.076> <-1.099, 1.892, -0.081> <-1.122, 1.883, -0.076> 
		<-1.042, 1.894, -0.093> <-1.060, 1.886, -0.077> <-1.097, 1.876, -0.081> <-1.121, 1.868, -0.076> 
		<-1.039, 1.868, -0.081> <-1.060, 1.871, -0.069> <-1.094, 1.852, -0.070> <-1.118, 1.847, -0.067> 
		<-1.037, 1.855, -0.068> <-1.058, 1.858, -0.055> <-1.093, 1.842, -0.059> <-1.117, 1.836, -0.055> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.130, 1.931, -0.055> <-1.129, 1.939, -0.064> <-1.135, 1.951, -0.078> <-1.127, 1.958, -0.082> 
		<-1.129, 1.920, -0.068> <-1.128, 1.928, -0.076> <-1.133, 1.935, -0.097> <-1.125, 1.942, -0.101> 
		<-1.127, 1.898, -0.079> <-1.125, 1.899, -0.091> <-1.131, 1.906, -0.111> <-1.122, 1.910, -0.118> 
		<-1.125, 1.882, -0.080> <-1.124, 1.883, -0.091> <-1.128, 1.882, -0.112> <-1.119, 1.885, -0.119> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.127, 1.958, -0.082> <-1.111, 1.972, -0.091> <-1.084, 1.989, -0.099> <-1.062, 1.992, -0.094> 
		<-1.125, 1.942, -0.101> <-1.110, 1.956, -0.110> <-1.082, 1.971, -0.120> <-1.060, 1.974, -0.115> 
		<-1.122, 1.910, -0.118> <-1.106, 1.916, -0.131> <-1.076, 1.930, -0.141> <-1.057, 1.937, -0.134> 
		<-1.119, 1.885, -0.119> <-1.103, 1.891, -0.131> <-1.073, 1.903, -0.142> <-1.054, 1.909, -0.135> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.062, 1.992, -0.094> <-1.050, 1.994, -0.091> <-1.041, 1.976, -0.070> <-1.049, 1.968, -0.065> 
		<-1.060, 1.974, -0.115> <-1.049, 1.976, -0.112> <-1.040, 1.964, -0.084> <-1.048, 1.956, -0.079> 
		<-1.057, 1.937, -0.134> <-1.045, 1.941, -0.130> <-1.036, 1.935, -0.100> <-1.045, 1.931, -0.092> 
		<-1.054, 1.909, -0.135> <-1.042, 1.914, -0.131> <-1.034, 1.916, -0.101> <-1.044, 1.912, -0.092> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.049, 1.968, -0.065> <-1.066, 1.952, -0.054> <-1.104, 1.941, -0.056> <-1.127, 1.929, -0.053> 
		<-1.048, 1.956, -0.079> <-1.065, 1.939, -0.068> <-1.103, 1.931, -0.068> <-1.126, 1.919, -0.065> 
		<-1.045, 1.931, -0.092> <-1.064, 1.924, -0.076> <-1.100, 1.907, -0.080> <-1.124, 1.899, -0.075> 
		<-1.044, 1.912, -0.092> <-1.062, 1.905, -0.076> <-1.099, 1.892, -0.081> <-1.122, 1.883, -0.076> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.132, 1.950, 0.000> <-1.131, 1.961, 0.000> <-1.136, 1.979, 0.001> <-1.129, 1.987, 0.001> 
		<-1.132, 1.950, -0.017> <-1.131, 1.962, -0.017> <-1.137, 1.979, -0.025> <-1.129, 1.988, -0.025> 
		<-1.131, 1.942, -0.042> <-1.130, 1.950, -0.050> <-1.136, 1.968, -0.058> <-1.128, 1.975, -0.062> 
		<-1.130, 1.931, -0.055> <-1.129, 1.939, -0.064> <-1.135, 1.951, -0.078> <-1.127, 1.958, -0.082> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.129, 1.987, 0.001> <-1.114, 2.004, 0.001> <-1.087, 2.024, 0.001> <-1.065, 2.025, 0.001> 
		<-1.129, 1.988, -0.025> <-1.114, 2.004, -0.025> <-1.087, 2.025, -0.029> <-1.065, 2.026, -0.029> 
		<-1.128, 1.975, -0.062> <-1.113, 1.989, -0.071> <-1.085, 2.009, -0.076> <-1.064, 2.012, -0.071> 
		<-1.127, 1.958, -0.082> <-1.111, 1.972, -0.091> <-1.084, 1.989, -0.099> <-1.062, 1.992, -0.094> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.065, 2.025, 0.001> <-1.054, 2.026, 0.000> <-1.044, 1.999, -0.000> <-1.051, 1.991, -0.000> 
		<-1.065, 2.026, -0.029> <-1.054, 2.026, -0.030> <-1.044, 2.000, -0.021> <-1.051, 1.991, -0.021> 
		<-1.064, 2.012, -0.071> <-1.052, 2.013, -0.068> <-1.043, 1.989, -0.054> <-1.050, 1.981, -0.049> 
		<-1.062, 1.992, -0.094> <-1.050, 1.994, -0.091> <-1.041, 1.976, -0.070> <-1.049, 1.968, -0.065> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.051, 1.991, -0.000> <-1.068, 1.970, -0.001> <-1.105, 1.961, -0.000> <-1.128, 1.948, 0.000> 
		<-1.051, 1.991, -0.021> <-1.068, 1.970, -0.021> <-1.105, 1.961, -0.017> <-1.128, 1.948, -0.017> 
		<-1.050, 1.981, -0.049> <-1.068, 1.965, -0.038> <-1.105, 1.952, -0.044> <-1.128, 1.940, -0.040> 
		<-1.049, 1.968, -0.065> <-1.066, 1.952, -0.054> <-1.104, 1.941, -0.056> <-1.127, 1.929, -0.053> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.129, 1.929, 0.055> <-1.128, 1.937, 0.063> <-1.133, 1.948, 0.078> <-1.125, 1.955, 0.083> 
		<-1.131, 1.941, 0.042> <-1.129, 1.949, 0.050> <-1.135, 1.966, 0.059> <-1.127, 1.973, 0.064> 
		<-1.132, 1.950, 0.018> <-1.131, 1.961, 0.018> <-1.136, 1.978, 0.027> <-1.129, 1.987, 0.027> 
		<-1.132, 1.950, 0.000> <-1.131, 1.961, 0.000> <-1.136, 1.979, 0.001> <-1.129, 1.987, 0.001> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.125, 1.955, 0.083> <-1.110, 1.969, 0.092> <-1.081, 1.986, 0.099> <-1.060, 1.989, 0.093> 
		<-1.127, 1.973, 0.064> <-1.112, 1.987, 0.072> <-1.084, 2.006, 0.077> <-1.062, 2.009, 0.072> 
		<-1.129, 1.987, 0.027> <-1.114, 2.003, 0.028> <-1.087, 2.024, 0.031> <-1.064, 2.025, 0.031> 
		<-1.129, 1.987, 0.001> <-1.114, 2.004, 0.001> <-1.087, 2.024, 0.001> <-1.065, 2.025, 0.001> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.060, 1.989, 0.093> <-1.048, 1.990, 0.090> <-1.040, 1.974, 0.067> <-1.048, 1.966, 0.062> 
		<-1.062, 2.009, 0.072> <-1.051, 2.011, 0.068> <-1.041, 1.987, 0.053> <-1.049, 1.980, 0.048> 
		<-1.064, 2.025, 0.031> <-1.053, 2.025, 0.030> <-1.044, 1.999, 0.020> <-1.051, 1.990, 0.020> 
		<-1.065, 2.025, 0.001> <-1.054, 2.026, 0.000> <-1.044, 1.999, -0.000> <-1.051, 1.991, -0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.048, 1.966, 0.062> <-1.065, 1.950, 0.051> <-1.102, 1.939, 0.055> <-1.126, 1.928, 0.052> 
		<-1.049, 1.980, 0.048> <-1.067, 1.963, 0.036> <-1.104, 1.950, 0.043> <-1.127, 1.939, 0.040> 
		<-1.051, 1.990, 0.020> <-1.067, 1.970, 0.020> <-1.105, 1.960, 0.017> <-1.128, 1.948, 0.017> 
		<-1.051, 1.991, -0.000> <-1.068, 1.970, -0.001> <-1.105, 1.961, -0.000> <-1.128, 1.948, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.621, 2.154, 1.525> <-0.591, 2.119, 1.512> <-0.581, 2.090, 1.465> <-0.600, 2.090, 1.421> 
		<-0.748, 2.025, 1.579> <-0.718, 1.990, 1.566> <-0.709, 1.961, 1.519> <-0.728, 1.961, 1.475> 
		<-0.918, 1.852, 1.651> <-0.888, 1.818, 1.638> <-0.879, 1.789, 1.591> <-0.898, 1.789, 1.548> 
		<-1.046, 1.723, 1.705> <-1.016, 1.688, 1.693> <-1.007, 1.659, 1.646> <-1.025, 1.659, 1.602> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.600, 2.090, 1.421> <-0.619, 2.090, 1.377> <-0.659, 2.119, 1.352> <-0.689, 2.154, 1.364> 
		<-0.728, 1.961, 1.475> <-0.746, 1.961, 1.432> <-0.787, 1.990, 1.406> <-0.816, 2.025, 1.418> 
		<-0.898, 1.789, 1.548> <-0.916, 1.789, 1.504> <-0.957, 1.818, 1.478> <-0.986, 1.852, 1.491> 
		<-1.025, 1.659, 1.602> <-1.044, 1.659, 1.558> <-1.084, 1.688, 1.532> <-1.114, 1.723, 1.545> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.689, 2.154, 1.364> <-0.719, 2.189, 1.377> <-0.728, 2.218, 1.424> <-0.710, 2.218, 1.468> 
		<-0.816, 2.025, 1.418> <-0.846, 2.059, 1.431> <-0.856, 2.088, 1.478> <-0.837, 2.088, 1.522> 
		<-0.986, 1.852, 1.491> <-1.016, 1.887, 1.503> <-1.026, 1.916, 1.550> <-1.007, 1.916, 1.594> 
		<-1.114, 1.723, 1.545> <-1.144, 1.758, 1.557> <-1.153, 1.787, 1.604> <-1.135, 1.787, 1.648> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.135, 1.787, 1.648> <-1.116, 1.787, 1.692> <-1.076, 1.758, 1.718> <-1.046, 1.723, 1.705> 
		<-1.007, 1.916, 1.594> <-0.989, 1.916, 1.638> <-0.948, 1.887, 1.664> <-0.918, 1.852, 1.651> 
		<-0.837, 2.088, 1.522> <-0.819, 2.088, 1.566> <-0.778, 2.059, 1.592> <-0.748, 2.025, 1.579> 
		<-0.710, 2.218, 1.468> <-0.691, 2.218, 1.512> <-0.651, 2.189, 1.537> <-0.621, 2.154, 1.525> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.912, 1.876, 1.576> <-0.904, 1.867, 1.573> <-0.902, 1.860, 1.562> <-0.907, 1.860, 1.551> 
		<-1.003, 1.780, 1.615> <-0.996, 1.772, 1.612> <-0.994, 1.765, 1.601> <-0.998, 1.765, 1.590> 
		<-1.126, 1.653, 1.667> <-1.119, 1.645, 1.664> <-1.116, 1.638, 1.653> <-1.121, 1.638, 1.642> 
		<-1.218, 1.558, 1.706> <-1.211, 1.550, 1.703> <-1.208, 1.543, 1.692> <-1.213, 1.543, 1.681> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.907, 1.860, 1.551> <-0.911, 1.860, 1.541> <-0.921, 1.867, 1.535> <-0.928, 1.876, 1.538> 
		<-0.998, 1.765, 1.590> <-1.003, 1.765, 1.580> <-1.013, 1.772, 1.574> <-1.020, 1.780, 1.577> 
		<-1.121, 1.638, 1.642> <-1.125, 1.638, 1.632> <-1.135, 1.645, 1.626> <-1.142, 1.653, 1.629> 
		<-1.213, 1.543, 1.681> <-1.217, 1.543, 1.671> <-1.227, 1.550, 1.665> <-1.234, 1.558, 1.668> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.928, 1.876, 1.538> <-0.935, 1.884, 1.541> <-0.937, 1.891, 1.552> <-0.933, 1.891, 1.563> 
		<-1.020, 1.780, 1.577> <-1.027, 1.789, 1.580> <-1.029, 1.796, 1.591> <-1.025, 1.796, 1.602> 
		<-1.142, 1.653, 1.629> <-1.149, 1.662, 1.632> <-1.152, 1.669, 1.643> <-1.147, 1.669, 1.654> 
		<-1.234, 1.558, 1.668> <-1.241, 1.566, 1.671> <-1.244, 1.573, 1.682> <-1.239, 1.573, 1.693> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.239, 1.573, 1.693> <-1.235, 1.573, 1.703> <-1.225, 1.566, 1.709> <-1.218, 1.558, 1.706> 
		<-1.147, 1.669, 1.654> <-1.143, 1.669, 1.664> <-1.133, 1.662, 1.670> <-1.126, 1.653, 1.667> 
		<-1.025, 1.796, 1.602> <-1.020, 1.796, 1.612> <-1.011, 1.789, 1.618> <-1.003, 1.780, 1.615> 
		<-0.933, 1.891, 1.563> <-0.928, 1.891, 1.573> <-0.919, 1.884, 1.579> <-0.912, 1.876, 1.576> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.130, 1.707, 1.646> <-1.133, 1.713, 1.648> <-1.142, 1.719, 1.651> <-1.140, 1.725, 1.651> 
		<-1.134, 1.707, 1.638> <-1.137, 1.713, 1.639> <-1.147, 1.719, 1.638> <-1.146, 1.725, 1.638> 
		<-1.136, 1.704, 1.625> <-1.139, 1.708, 1.622> <-1.149, 1.714, 1.621> <-1.148, 1.719, 1.618> 
		<-1.134, 1.699, 1.617> <-1.138, 1.703, 1.614> <-1.147, 1.707, 1.610> <-1.146, 1.712, 1.607> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.140, 1.725, 1.651> <-1.137, 1.737, 1.649> <-1.128, 1.753, 1.646> <-1.118, 1.758, 1.641> 
		<-1.146, 1.725, 1.638> <-1.143, 1.737, 1.637> <-1.135, 1.753, 1.631> <-1.124, 1.758, 1.627> 
		<-1.148, 1.719, 1.618> <-1.146, 1.730, 1.612> <-1.138, 1.746, 1.606> <-1.127, 1.752, 1.605> 
		<-1.146, 1.712, 1.607> <-1.144, 1.723, 1.601> <-1.135, 1.737, 1.593> <-1.125, 1.744, 1.591> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.118, 1.758, 1.641> <-1.113, 1.761, 1.639> <-1.099, 1.753, 1.633> <-1.100, 1.746, 1.634> 
		<-1.124, 1.758, 1.627> <-1.119, 1.761, 1.624> <-1.103, 1.753, 1.623> <-1.104, 1.746, 1.624> 
		<-1.127, 1.752, 1.605> <-1.121, 1.755, 1.604> <-1.105, 1.748, 1.605> <-1.106, 1.742, 1.609> 
		<-1.125, 1.744, 1.591> <-1.119, 1.747, 1.590> <-1.104, 1.742, 1.596> <-1.105, 1.736, 1.600> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.100, 1.746, 1.634> <-1.103, 1.732, 1.635> <-1.120, 1.719, 1.642> <-1.128, 1.707, 1.645> 
		<-1.104, 1.746, 1.624> <-1.107, 1.732, 1.625> <-1.123, 1.719, 1.634> <-1.131, 1.707, 1.637> 
		<-1.106, 1.742, 1.609> <-1.108, 1.729, 1.616> <-1.125, 1.715, 1.620> <-1.133, 1.704, 1.625> 
		<-1.105, 1.736, 1.600> <-1.107, 1.724, 1.607> <-1.123, 1.710, 1.612> <-1.131, 1.699, 1.617> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.112, 1.699, 1.669> <-1.112, 1.703, 1.674> <-1.115, 1.707, 1.684> <-1.113, 1.712, 1.685> 
		<-1.119, 1.704, 1.665> <-1.119, 1.708, 1.670> <-1.125, 1.714, 1.677> <-1.123, 1.719, 1.679> 
		<-1.127, 1.707, 1.655> <-1.130, 1.713, 1.656> <-1.136, 1.719, 1.664> <-1.135, 1.725, 1.663> 
		<-1.130, 1.707, 1.646> <-1.133, 1.713, 1.648> <-1.142, 1.719, 1.651> <-1.140, 1.725, 1.651> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.113, 1.712, 1.685> <-1.107, 1.723, 1.688> <-1.095, 1.737, 1.687> <-1.087, 1.744, 1.680> 
		<-1.123, 1.719, 1.679> <-1.117, 1.730, 1.681> <-1.107, 1.746, 1.680> <-1.098, 1.752, 1.673> 
		<-1.135, 1.725, 1.663> <-1.132, 1.737, 1.662> <-1.122, 1.753, 1.660> <-1.112, 1.758, 1.656> 
		<-1.140, 1.725, 1.651> <-1.137, 1.737, 1.649> <-1.128, 1.753, 1.646> <-1.118, 1.758, 1.641> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.087, 1.744, 1.680> <-1.082, 1.747, 1.677> <-1.076, 1.742, 1.662> <-1.079, 1.736, 1.660> 
		<-1.098, 1.752, 1.673> <-1.093, 1.755, 1.670> <-1.084, 1.748, 1.657> <-1.087, 1.742, 1.655> 
		<-1.112, 1.758, 1.656> <-1.106, 1.761, 1.653> <-1.095, 1.753, 1.643> <-1.096, 1.746, 1.643> 
		<-1.118, 1.758, 1.641> <-1.113, 1.761, 1.639> <-1.099, 1.753, 1.633> <-1.100, 1.746, 1.634> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.079, 1.736, 1.660> <-1.086, 1.724, 1.656> <-1.101, 1.710, 1.665> <-1.110, 1.699, 1.667> 
		<-1.087, 1.742, 1.655> <-1.093, 1.729, 1.651> <-1.107, 1.715, 1.661> <-1.117, 1.704, 1.663> 
		<-1.096, 1.746, 1.643> <-1.099, 1.732, 1.645> <-1.116, 1.719, 1.650> <-1.124, 1.707, 1.653> 
		<-1.100, 1.746, 1.634> <-1.103, 1.732, 1.635> <-1.120, 1.719, 1.642> <-1.128, 1.707, 1.645> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.089, 1.678, 1.673> <-1.086, 1.679, 1.678> <-1.084, 1.677, 1.689> <-1.079, 1.681, 1.690> 
		<-1.095, 1.685, 1.675> <-1.092, 1.686, 1.680> <-1.092, 1.687, 1.692> <-1.088, 1.691, 1.694> 
		<-1.105, 1.694, 1.674> <-1.105, 1.698, 1.678> <-1.106, 1.700, 1.690> <-1.103, 1.705, 1.692> 
		<-1.112, 1.699, 1.669> <-1.112, 1.703, 1.674> <-1.115, 1.707, 1.684> <-1.113, 1.712, 1.685> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.079, 1.681, 1.690> <-1.069, 1.688, 1.693> <-1.055, 1.700, 1.693> <-1.049, 1.708, 1.686> 
		<-1.088, 1.691, 1.694> <-1.078, 1.698, 1.697> <-1.065, 1.712, 1.697> <-1.058, 1.720, 1.690> 
		<-1.103, 1.705, 1.692> <-1.097, 1.715, 1.694> <-1.084, 1.729, 1.694> <-1.075, 1.736, 1.688> 
		<-1.113, 1.712, 1.685> <-1.107, 1.723, 1.688> <-1.095, 1.737, 1.687> <-1.087, 1.744, 1.680> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.049, 1.708, 1.686> <-1.045, 1.713, 1.682> <-1.048, 1.716, 1.666> <-1.053, 1.712, 1.664> 
		<-1.058, 1.720, 1.690> <-1.055, 1.724, 1.686> <-1.055, 1.724, 1.669> <-1.060, 1.720, 1.667> 
		<-1.075, 1.736, 1.688> <-1.071, 1.739, 1.684> <-1.068, 1.737, 1.667> <-1.071, 1.731, 1.665> 
		<-1.087, 1.744, 1.680> <-1.082, 1.747, 1.677> <-1.076, 1.742, 1.662> <-1.079, 1.736, 1.660> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.053, 1.712, 1.664> <-1.065, 1.704, 1.659> <-1.078, 1.689, 1.668> <-1.089, 1.679, 1.670> 
		<-1.060, 1.720, 1.667> <-1.071, 1.712, 1.662> <-1.084, 1.696, 1.671> <-1.094, 1.686, 1.673> 
		<-1.071, 1.731, 1.665> <-1.078, 1.718, 1.661> <-1.095, 1.706, 1.669> <-1.104, 1.695, 1.671> 
		<-1.079, 1.736, 1.660> <-1.086, 1.724, 1.656> <-1.101, 1.710, 1.665> <-1.110, 1.699, 1.667> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.076, 1.657, 1.654> <-1.071, 1.655, 1.657> <-1.065, 1.648, 1.662> <-1.059, 1.650, 1.662> 
		<-1.078, 1.662, 1.662> <-1.073, 1.660, 1.664> <-1.067, 1.655, 1.674> <-1.061, 1.657, 1.674> 
		<-1.084, 1.671, 1.670> <-1.080, 1.672, 1.675> <-1.075, 1.667, 1.685> <-1.070, 1.671, 1.686> 
		<-1.089, 1.678, 1.673> <-1.086, 1.679, 1.678> <-1.084, 1.677, 1.689> <-1.079, 1.681, 1.690> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.059, 1.650, 1.662> <-1.047, 1.653, 1.663> <-1.031, 1.663, 1.660> <-1.026, 1.673, 1.655> 
		<-1.061, 1.657, 1.674> <-1.050, 1.660, 1.674> <-1.034, 1.671, 1.673> <-1.029, 1.681, 1.668> 
		<-1.070, 1.671, 1.686> <-1.061, 1.678, 1.690> <-1.045, 1.689, 1.688> <-1.039, 1.697, 1.682> 
		<-1.079, 1.681, 1.690> <-1.069, 1.688, 1.693> <-1.055, 1.700, 1.693> <-1.049, 1.708, 1.686> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.026, 1.673, 1.655> <-1.023, 1.678, 1.652> <-1.031, 1.690, 1.643> <-1.038, 1.688, 1.643> 
		<-1.029, 1.681, 1.668> <-1.026, 1.687, 1.665> <-1.033, 1.696, 1.652> <-1.040, 1.694, 1.652> 
		<-1.039, 1.697, 1.682> <-1.035, 1.701, 1.678> <-1.041, 1.708, 1.663> <-1.047, 1.705, 1.661> 
		<-1.049, 1.708, 1.686> <-1.045, 1.713, 1.682> <-1.048, 1.716, 1.666> <-1.053, 1.712, 1.664> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.038, 1.688, 1.643> <-1.052, 1.685, 1.642> <-1.065, 1.668, 1.650> <-1.076, 1.660, 1.653> 
		<-1.040, 1.694, 1.652> <-1.054, 1.690, 1.651> <-1.066, 1.673, 1.657> <-1.078, 1.664, 1.660> 
		<-1.047, 1.705, 1.661> <-1.058, 1.696, 1.657> <-1.073, 1.683, 1.666> <-1.083, 1.673, 1.668> 
		<-1.053, 1.712, 1.664> <-1.065, 1.704, 1.659> <-1.078, 1.689, 1.668> <-1.089, 1.679, 1.670> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.080, 1.649, 1.625> <-1.075, 1.645, 1.623> <-1.070, 1.636, 1.621> <-1.065, 1.637, 1.618> 
		<-1.076, 1.649, 1.633> <-1.072, 1.645, 1.631> <-1.065, 1.636, 1.634> <-1.059, 1.637, 1.631> 
		<-1.075, 1.652, 1.647> <-1.069, 1.650, 1.649> <-1.063, 1.641, 1.651> <-1.057, 1.642, 1.651> 
		<-1.076, 1.657, 1.654> <-1.071, 1.655, 1.657> <-1.065, 1.648, 1.662> <-1.059, 1.650, 1.662> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.065, 1.637, 1.618> <-1.053, 1.639, 1.614> <-1.038, 1.648, 1.607> <-1.032, 1.658, 1.605> 
		<-1.059, 1.637, 1.631> <-1.048, 1.639, 1.626> <-1.032, 1.648, 1.622> <-1.026, 1.658, 1.619> 
		<-1.057, 1.642, 1.651> <-1.045, 1.646, 1.651> <-1.029, 1.655, 1.646> <-1.023, 1.665, 1.641> 
		<-1.059, 1.650, 1.662> <-1.047, 1.653, 1.663> <-1.031, 1.663, 1.660> <-1.026, 1.673, 1.655> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.032, 1.658, 1.605> <-1.029, 1.664, 1.603> <-1.036, 1.679, 1.606> <-1.042, 1.679, 1.609> 
		<-1.026, 1.658, 1.619> <-1.023, 1.664, 1.618> <-1.032, 1.679, 1.616> <-1.038, 1.679, 1.619> 
		<-1.023, 1.665, 1.641> <-1.020, 1.670, 1.639> <-1.030, 1.685, 1.634> <-1.036, 1.683, 1.634> 
		<-1.026, 1.673, 1.655> <-1.023, 1.678, 1.652> <-1.031, 1.690, 1.643> <-1.038, 1.688, 1.643> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.042, 1.679, 1.609> <-1.056, 1.677, 1.615> <-1.069, 1.660, 1.620> <-1.080, 1.651, 1.625> 
		<-1.038, 1.679, 1.619> <-1.051, 1.677, 1.624> <-1.065, 1.660, 1.628> <-1.076, 1.651, 1.633> 
		<-1.036, 1.683, 1.634> <-1.050, 1.679, 1.633> <-1.063, 1.664, 1.642> <-1.075, 1.655, 1.645> 
		<-1.038, 1.688, 1.643> <-1.052, 1.685, 1.642> <-1.065, 1.668, 1.650> <-1.076, 1.660, 1.653> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.098, 1.657, 1.602> <-1.097, 1.655, 1.596> <-1.096, 1.648, 1.588> <-1.092, 1.650, 1.584> 
		<-1.092, 1.652, 1.606> <-1.090, 1.650, 1.601> <-1.086, 1.641, 1.595> <-1.082, 1.642, 1.590> 
		<-1.083, 1.649, 1.616> <-1.079, 1.645, 1.614> <-1.076, 1.636, 1.608> <-1.070, 1.637, 1.606> 
		<-1.080, 1.649, 1.625> <-1.075, 1.645, 1.623> <-1.070, 1.636, 1.621> <-1.065, 1.637, 1.618> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.092, 1.650, 1.584> <-1.084, 1.653, 1.575> <-1.071, 1.663, 1.566> <-1.064, 1.673, 1.566> 
		<-1.082, 1.642, 1.590> <-1.074, 1.646, 1.582> <-1.060, 1.655, 1.573> <-1.053, 1.665, 1.573> 
		<-1.070, 1.637, 1.606> <-1.059, 1.639, 1.601> <-1.044, 1.648, 1.593> <-1.039, 1.658, 1.590> 
		<-1.065, 1.637, 1.618> <-1.053, 1.639, 1.614> <-1.038, 1.648, 1.607> <-1.032, 1.658, 1.605> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.064, 1.673, 1.566> <-1.060, 1.678, 1.565> <-1.059, 1.690, 1.577> <-1.064, 1.688, 1.582> 
		<-1.053, 1.665, 1.573> <-1.048, 1.670, 1.573> <-1.051, 1.685, 1.582> <-1.056, 1.683, 1.587> 
		<-1.039, 1.658, 1.590> <-1.035, 1.664, 1.589> <-1.040, 1.679, 1.597> <-1.046, 1.679, 1.599> 
		<-1.032, 1.658, 1.605> <-1.029, 1.664, 1.603> <-1.036, 1.679, 1.606> <-1.042, 1.679, 1.609> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.064, 1.688, 1.582> <-1.073, 1.685, 1.593> <-1.087, 1.668, 1.597> <-1.097, 1.660, 1.603> 
		<-1.056, 1.683, 1.587> <-1.065, 1.679, 1.598> <-1.081, 1.664, 1.601> <-1.091, 1.655, 1.607> 
		<-1.046, 1.679, 1.599> <-1.060, 1.677, 1.605> <-1.072, 1.660, 1.612> <-1.083, 1.651, 1.617> 
		<-1.042, 1.679, 1.609> <-1.056, 1.677, 1.615> <-1.069, 1.660, 1.620> <-1.080, 1.651, 1.625> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.121, 1.678, 1.599> <-1.122, 1.679, 1.593> <-1.128, 1.677, 1.583> <-1.126, 1.681, 1.579> 
		<-1.115, 1.671, 1.596> <-1.117, 1.672, 1.590> <-1.120, 1.667, 1.580> <-1.117, 1.671, 1.575> 
		<-1.105, 1.662, 1.598> <-1.103, 1.660, 1.592> <-1.106, 1.655, 1.582> <-1.102, 1.657, 1.577> 
		<-1.098, 1.657, 1.602> <-1.097, 1.655, 1.596> <-1.096, 1.648, 1.588> <-1.092, 1.650, 1.584> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.126, 1.681, 1.579> <-1.122, 1.688, 1.570> <-1.111, 1.700, 1.560> <-1.102, 1.708, 1.560> 
		<-1.117, 1.671, 1.575> <-1.113, 1.678, 1.566> <-1.102, 1.689, 1.556> <-1.092, 1.697, 1.556> 
		<-1.102, 1.657, 1.577> <-1.094, 1.660, 1.569> <-1.083, 1.671, 1.559> <-1.075, 1.681, 1.558> 
		<-1.092, 1.650, 1.584> <-1.084, 1.653, 1.575> <-1.071, 1.663, 1.566> <-1.064, 1.673, 1.566> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.102, 1.708, 1.560> <-1.097, 1.713, 1.560> <-1.087, 1.716, 1.573> <-1.089, 1.712, 1.579> 
		<-1.092, 1.697, 1.556> <-1.087, 1.701, 1.556> <-1.080, 1.708, 1.571> <-1.083, 1.705, 1.576> 
		<-1.075, 1.681, 1.558> <-1.071, 1.687, 1.558> <-1.067, 1.696, 1.573> <-1.071, 1.694, 1.578> 
		<-1.064, 1.673, 1.566> <-1.060, 1.678, 1.565> <-1.059, 1.690, 1.577> <-1.064, 1.688, 1.582> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.089, 1.712, 1.579> <-1.094, 1.704, 1.590> <-1.110, 1.689, 1.594> <-1.119, 1.679, 1.600> 
		<-1.083, 1.705, 1.576> <-1.087, 1.696, 1.587> <-1.104, 1.683, 1.591> <-1.113, 1.673, 1.598> 
		<-1.071, 1.694, 1.578> <-1.081, 1.690, 1.588> <-1.094, 1.673, 1.593> <-1.104, 1.664, 1.599> 
		<-1.064, 1.688, 1.582> <-1.073, 1.685, 1.593> <-1.087, 1.668, 1.597> <-1.097, 1.660, 1.603> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.134, 1.699, 1.617> <-1.138, 1.703, 1.614> <-1.147, 1.707, 1.610> <-1.146, 1.712, 1.607> 
		<-1.133, 1.694, 1.609> <-1.136, 1.698, 1.606> <-1.145, 1.700, 1.598> <-1.144, 1.705, 1.595> 
		<-1.127, 1.685, 1.601> <-1.128, 1.686, 1.595> <-1.137, 1.687, 1.587> <-1.135, 1.691, 1.583> 
		<-1.121, 1.678, 1.599> <-1.122, 1.679, 1.593> <-1.128, 1.677, 1.583> <-1.126, 1.681, 1.579> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.146, 1.712, 1.607> <-1.144, 1.723, 1.601> <-1.135, 1.737, 1.593> <-1.125, 1.744, 1.591> 
		<-1.144, 1.705, 1.595> <-1.141, 1.715, 1.589> <-1.132, 1.729, 1.580> <-1.122, 1.736, 1.578> 
		<-1.135, 1.691, 1.583> <-1.130, 1.698, 1.574> <-1.121, 1.712, 1.564> <-1.112, 1.720, 1.564> 
		<-1.126, 1.681, 1.579> <-1.122, 1.688, 1.570> <-1.111, 1.700, 1.560> <-1.102, 1.708, 1.560> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.125, 1.744, 1.591> <-1.119, 1.747, 1.590> <-1.104, 1.742, 1.596> <-1.105, 1.736, 1.600> 
		<-1.122, 1.736, 1.578> <-1.116, 1.739, 1.577> <-1.102, 1.737, 1.588> <-1.103, 1.731, 1.591> 
		<-1.112, 1.720, 1.564> <-1.107, 1.724, 1.564> <-1.094, 1.724, 1.576> <-1.096, 1.720, 1.582> 
		<-1.102, 1.708, 1.560> <-1.097, 1.713, 1.560> <-1.087, 1.716, 1.573> <-1.089, 1.712, 1.579> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.105, 1.736, 1.600> <-1.107, 1.724, 1.607> <-1.123, 1.710, 1.612> <-1.131, 1.699, 1.617> 
		<-1.103, 1.731, 1.591> <-1.105, 1.718, 1.598> <-1.122, 1.706, 1.605> <-1.130, 1.695, 1.610> 
		<-1.096, 1.720, 1.582> <-1.101, 1.712, 1.593> <-1.115, 1.696, 1.596> <-1.124, 1.686, 1.602> 
		<-1.089, 1.712, 1.579> <-1.094, 1.704, 1.590> <-1.110, 1.689, 1.594> <-1.119, 1.679, 1.600> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.288, 1.561, 1.686> <-1.291, 1.565, 1.689> <-1.299, 1.573, 1.689> <-1.299, 1.575, 1.695> 
		<-1.281, 1.567, 1.683> <-1.285, 1.571, 1.686> <-1.289, 1.582, 1.685> <-1.289, 1.585, 1.691> 
		<-1.269, 1.572, 1.678> <-1.269, 1.578, 1.680> <-1.273, 1.589, 1.679> <-1.271, 1.592, 1.684> 
		<-1.261, 1.571, 1.675> <-1.260, 1.577, 1.676> <-1.261, 1.588, 1.674> <-1.259, 1.591, 1.679> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.299, 1.575, 1.695> <-1.299, 1.580, 1.706> <-1.295, 1.583, 1.724> <-1.288, 1.581, 1.734> 
		<-1.289, 1.585, 1.691> <-1.289, 1.589, 1.703> <-1.285, 1.594, 1.720> <-1.278, 1.591, 1.730> 
		<-1.271, 1.592, 1.684> <-1.267, 1.598, 1.693> <-1.262, 1.603, 1.711> <-1.258, 1.600, 1.722> 
		<-1.259, 1.591, 1.679> <-1.254, 1.598, 1.688> <-1.247, 1.603, 1.705> <-1.243, 1.599, 1.716> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.288, 1.581, 1.734> <-1.285, 1.579, 1.740> <-1.273, 1.567, 1.740> <-1.272, 1.564, 1.734> 
		<-1.278, 1.591, 1.730> <-1.274, 1.590, 1.736> <-1.265, 1.574, 1.737> <-1.265, 1.572, 1.731> 
		<-1.258, 1.600, 1.722> <-1.255, 1.597, 1.728> <-1.249, 1.581, 1.731> <-1.251, 1.577, 1.726> 
		<-1.243, 1.599, 1.716> <-1.241, 1.597, 1.722> <-1.239, 1.581, 1.727> <-1.242, 1.577, 1.722> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.272, 1.564, 1.734> <-1.271, 1.558, 1.721> <-1.282, 1.561, 1.701> <-1.286, 1.559, 1.687> 
		<-1.265, 1.572, 1.731> <-1.264, 1.566, 1.718> <-1.276, 1.567, 1.699> <-1.280, 1.565, 1.685> 
		<-1.251, 1.577, 1.726> <-1.256, 1.569, 1.714> <-1.263, 1.572, 1.694> <-1.268, 1.570, 1.680> 
		<-1.242, 1.577, 1.722> <-1.246, 1.568, 1.710> <-1.255, 1.572, 1.690> <-1.260, 1.569, 1.677> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.300, 1.533, 1.690> <-1.305, 1.533, 1.694> <-1.316, 1.533, 1.696> <-1.317, 1.533, 1.702> 
		<-1.299, 1.542, 1.690> <-1.304, 1.542, 1.694> <-1.315, 1.547, 1.696> <-1.316, 1.547, 1.702> 
		<-1.294, 1.554, 1.688> <-1.297, 1.559, 1.691> <-1.308, 1.563, 1.693> <-1.308, 1.566, 1.699> 
		<-1.288, 1.561, 1.686> <-1.291, 1.565, 1.689> <-1.299, 1.573, 1.689> <-1.299, 1.575, 1.695> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.317, 1.533, 1.702> <-1.319, 1.533, 1.714> <-1.317, 1.533, 1.732> <-1.309, 1.533, 1.742> 
		<-1.316, 1.547, 1.702> <-1.318, 1.547, 1.714> <-1.316, 1.549, 1.732> <-1.308, 1.549, 1.742> 
		<-1.308, 1.566, 1.699> <-1.308, 1.571, 1.710> <-1.306, 1.573, 1.729> <-1.299, 1.570, 1.738> 
		<-1.299, 1.575, 1.695> <-1.299, 1.580, 1.706> <-1.295, 1.583, 1.724> <-1.288, 1.581, 1.734> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.309, 1.533, 1.742> <-1.304, 1.533, 1.747> <-1.288, 1.532, 1.746> <-1.286, 1.532, 1.739> 
		<-1.308, 1.549, 1.742> <-1.304, 1.549, 1.747> <-1.287, 1.543, 1.746> <-1.286, 1.543, 1.739> 
		<-1.299, 1.570, 1.738> <-1.295, 1.568, 1.744> <-1.280, 1.560, 1.743> <-1.280, 1.557, 1.737> 
		<-1.288, 1.581, 1.734> <-1.285, 1.579, 1.740> <-1.273, 1.567, 1.740> <-1.272, 1.564, 1.734> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.286, 1.532, 1.739> <-1.283, 1.532, 1.725> <-1.294, 1.532, 1.706> <-1.297, 1.532, 1.691> 
		<-1.286, 1.543, 1.739> <-1.282, 1.543, 1.725> <-1.293, 1.541, 1.706> <-1.297, 1.541, 1.691> 
		<-1.280, 1.557, 1.737> <-1.279, 1.551, 1.723> <-1.288, 1.555, 1.704> <-1.292, 1.553, 1.689> 
		<-1.272, 1.564, 1.734> <-1.271, 1.558, 1.721> <-1.282, 1.561, 1.701> <-1.286, 1.559, 1.687> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.290, 1.504, 1.686> <-1.293, 1.500, 1.689> <-1.302, 1.492, 1.689> <-1.302, 1.490, 1.695> 
		<-1.295, 1.510, 1.688> <-1.299, 1.506, 1.691> <-1.310, 1.502, 1.693> <-1.311, 1.500, 1.699> 
		<-1.300, 1.523, 1.690> <-1.305, 1.524, 1.694> <-1.316, 1.519, 1.696> <-1.317, 1.519, 1.702> 
		<-1.300, 1.533, 1.690> <-1.305, 1.533, 1.694> <-1.316, 1.533, 1.696> <-1.317, 1.533, 1.702> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.302, 1.490, 1.695> <-1.302, 1.485, 1.706> <-1.299, 1.482, 1.725> <-1.292, 1.484, 1.734> 
		<-1.311, 1.500, 1.699> <-1.311, 1.495, 1.710> <-1.309, 1.493, 1.729> <-1.302, 1.495, 1.739> 
		<-1.317, 1.519, 1.702> <-1.319, 1.519, 1.714> <-1.317, 1.518, 1.732> <-1.309, 1.517, 1.742> 
		<-1.317, 1.533, 1.702> <-1.319, 1.533, 1.714> <-1.317, 1.533, 1.732> <-1.309, 1.533, 1.742> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.292, 1.484, 1.734> <-1.288, 1.485, 1.740> <-1.275, 1.496, 1.740> <-1.275, 1.499, 1.734> 
		<-1.302, 1.495, 1.739> <-1.298, 1.497, 1.744> <-1.282, 1.504, 1.743> <-1.281, 1.507, 1.737> 
		<-1.309, 1.517, 1.742> <-1.305, 1.517, 1.747> <-1.288, 1.522, 1.746> <-1.286, 1.522, 1.739> 
		<-1.309, 1.533, 1.742> <-1.304, 1.533, 1.747> <-1.288, 1.532, 1.746> <-1.286, 1.532, 1.739> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.275, 1.499, 1.734> <-1.273, 1.505, 1.721> <-1.284, 1.503, 1.701> <-1.288, 1.505, 1.687> 
		<-1.281, 1.507, 1.737> <-1.280, 1.513, 1.724> <-1.289, 1.510, 1.704> <-1.293, 1.511, 1.690> 
		<-1.286, 1.522, 1.739> <-1.283, 1.521, 1.725> <-1.294, 1.524, 1.706> <-1.297, 1.524, 1.691> 
		<-1.286, 1.532, 1.739> <-1.283, 1.532, 1.725> <-1.294, 1.532, 1.706> <-1.297, 1.532, 1.691> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.264, 1.491, 1.675> <-1.264, 1.485, 1.676> <-1.265, 1.474, 1.674> <-1.263, 1.471, 1.679> 
		<-1.272, 1.491, 1.679> <-1.272, 1.485, 1.680> <-1.278, 1.475, 1.679> <-1.276, 1.471, 1.684> 
		<-1.284, 1.497, 1.683> <-1.288, 1.493, 1.686> <-1.293, 1.482, 1.686> <-1.293, 1.480, 1.691> 
		<-1.290, 1.504, 1.686> <-1.293, 1.500, 1.689> <-1.302, 1.492, 1.689> <-1.302, 1.490, 1.695> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.263, 1.471, 1.679> <-1.259, 1.464, 1.689> <-1.253, 1.459, 1.705> <-1.248, 1.462, 1.716> 
		<-1.276, 1.471, 1.684> <-1.272, 1.465, 1.694> <-1.267, 1.459, 1.711> <-1.263, 1.463, 1.722> 
		<-1.293, 1.480, 1.691> <-1.294, 1.475, 1.703> <-1.289, 1.470, 1.720> <-1.282, 1.472, 1.730> 
		<-1.302, 1.490, 1.695> <-1.302, 1.485, 1.706> <-1.299, 1.482, 1.725> <-1.292, 1.484, 1.734> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.248, 1.462, 1.716> <-1.245, 1.464, 1.722> <-1.243, 1.480, 1.727> <-1.245, 1.484, 1.722> 
		<-1.263, 1.463, 1.722> <-1.260, 1.465, 1.728> <-1.253, 1.481, 1.731> <-1.255, 1.485, 1.726> 
		<-1.282, 1.472, 1.730> <-1.278, 1.474, 1.736> <-1.269, 1.488, 1.738> <-1.268, 1.491, 1.731> 
		<-1.292, 1.484, 1.734> <-1.288, 1.485, 1.740> <-1.275, 1.496, 1.740> <-1.275, 1.499, 1.734> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.245, 1.484, 1.722> <-1.249, 1.493, 1.711> <-1.258, 1.490, 1.690> <-1.263, 1.493, 1.677> 
		<-1.255, 1.485, 1.726> <-1.259, 1.493, 1.715> <-1.266, 1.491, 1.694> <-1.271, 1.493, 1.680> 
		<-1.268, 1.491, 1.731> <-1.267, 1.497, 1.718> <-1.278, 1.497, 1.699> <-1.282, 1.499, 1.685> 
		<-1.275, 1.499, 1.734> <-1.273, 1.505, 1.721> <-1.284, 1.503, 1.701> <-1.288, 1.505, 1.687> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.237, 1.502, 1.664> <-1.233, 1.497, 1.664> <-1.227, 1.489, 1.659> <-1.223, 1.487, 1.663> 
		<-1.243, 1.495, 1.667> <-1.239, 1.491, 1.666> <-1.236, 1.480, 1.663> <-1.232, 1.478, 1.666> 
		<-1.255, 1.491, 1.672> <-1.255, 1.485, 1.673> <-1.252, 1.474, 1.669> <-1.250, 1.470, 1.674> 
		<-1.264, 1.491, 1.675> <-1.264, 1.485, 1.676> <-1.265, 1.474, 1.674> <-1.263, 1.471, 1.679> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.223, 1.487, 1.663> <-1.215, 1.482, 1.671> <-1.205, 1.478, 1.686> <-1.203, 1.481, 1.698> 
		<-1.232, 1.478, 1.666> <-1.224, 1.473, 1.674> <-1.215, 1.467, 1.690> <-1.213, 1.470, 1.702> 
		<-1.250, 1.470, 1.674> <-1.246, 1.464, 1.683> <-1.238, 1.458, 1.699> <-1.234, 1.462, 1.710> 
		<-1.263, 1.471, 1.679> <-1.259, 1.464, 1.689> <-1.253, 1.459, 1.705> <-1.248, 1.462, 1.716> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.203, 1.481, 1.698> <-1.201, 1.482, 1.704> <-1.210, 1.494, 1.713> <-1.214, 1.497, 1.709> 
		<-1.213, 1.470, 1.702> <-1.212, 1.471, 1.709> <-1.217, 1.486, 1.716> <-1.221, 1.489, 1.712> 
		<-1.234, 1.462, 1.710> <-1.231, 1.464, 1.716> <-1.233, 1.480, 1.723> <-1.235, 1.484, 1.718> 
		<-1.248, 1.462, 1.716> <-1.245, 1.464, 1.722> <-1.243, 1.480, 1.727> <-1.245, 1.484, 1.722> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.214, 1.497, 1.709> <-1.224, 1.503, 1.700> <-1.231, 1.501, 1.679> <-1.238, 1.503, 1.667> 
		<-1.221, 1.489, 1.712> <-1.231, 1.496, 1.703> <-1.237, 1.495, 1.682> <-1.244, 1.497, 1.669> 
		<-1.235, 1.484, 1.718> <-1.239, 1.493, 1.707> <-1.249, 1.490, 1.687> <-1.255, 1.493, 1.674> 
		<-1.245, 1.484, 1.722> <-1.249, 1.493, 1.711> <-1.258, 1.490, 1.690> <-1.263, 1.493, 1.677> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.225, 1.530, 1.660> <-1.219, 1.530, 1.659> <-1.210, 1.529, 1.652> <-1.205, 1.529, 1.656> 
		<-1.225, 1.521, 1.660> <-1.219, 1.520, 1.659> <-1.210, 1.515, 1.652> <-1.205, 1.515, 1.656> 
		<-1.231, 1.508, 1.662> <-1.227, 1.504, 1.661> <-1.218, 1.499, 1.655> <-1.213, 1.496, 1.659> 
		<-1.237, 1.502, 1.664> <-1.233, 1.497, 1.664> <-1.227, 1.489, 1.659> <-1.223, 1.487, 1.663> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.205, 1.529, 1.656> <-1.195, 1.529, 1.663> <-1.183, 1.528, 1.678> <-1.182, 1.528, 1.690> 
		<-1.205, 1.515, 1.656> <-1.195, 1.515, 1.663> <-1.184, 1.513, 1.678> <-1.183, 1.513, 1.690> 
		<-1.213, 1.496, 1.659> <-1.205, 1.491, 1.667> <-1.194, 1.489, 1.682> <-1.192, 1.491, 1.694> 
		<-1.223, 1.487, 1.663> <-1.215, 1.482, 1.671> <-1.205, 1.478, 1.686> <-1.203, 1.481, 1.698> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.182, 1.528, 1.690> <-1.182, 1.528, 1.697> <-1.195, 1.529, 1.708> <-1.200, 1.529, 1.704> 
		<-1.183, 1.513, 1.690> <-1.182, 1.513, 1.697> <-1.195, 1.518, 1.708> <-1.201, 1.518, 1.704> 
		<-1.192, 1.491, 1.694> <-1.191, 1.493, 1.700> <-1.202, 1.501, 1.711> <-1.207, 1.504, 1.706> 
		<-1.203, 1.481, 1.698> <-1.201, 1.482, 1.704> <-1.210, 1.494, 1.713> <-1.214, 1.497, 1.709> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.200, 1.529, 1.704> <-1.213, 1.529, 1.696> <-1.218, 1.530, 1.675> <-1.226, 1.530, 1.662> 
		<-1.201, 1.518, 1.704> <-1.213, 1.519, 1.696> <-1.219, 1.521, 1.675> <-1.227, 1.521, 1.662> 
		<-1.207, 1.504, 1.706> <-1.217, 1.510, 1.698> <-1.225, 1.507, 1.677> <-1.232, 1.509, 1.664> 
		<-1.214, 1.497, 1.709> <-1.224, 1.503, 1.700> <-1.231, 1.501, 1.679> <-1.238, 1.503, 1.667> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.235, 1.559, 1.664> <-1.230, 1.563, 1.664> <-1.224, 1.570, 1.659> <-1.220, 1.572, 1.663> 
		<-1.229, 1.552, 1.662> <-1.225, 1.556, 1.661> <-1.215, 1.560, 1.655> <-1.211, 1.562, 1.659> 
		<-1.225, 1.539, 1.660> <-1.219, 1.539, 1.659> <-1.209, 1.543, 1.652> <-1.204, 1.543, 1.656> 
		<-1.225, 1.530, 1.660> <-1.219, 1.530, 1.659> <-1.210, 1.529, 1.652> <-1.205, 1.529, 1.656> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.220, 1.572, 1.663> <-1.211, 1.577, 1.670> <-1.201, 1.580, 1.686> <-1.199, 1.577, 1.698> 
		<-1.211, 1.562, 1.659> <-1.203, 1.567, 1.667> <-1.191, 1.568, 1.682> <-1.189, 1.566, 1.693> 
		<-1.204, 1.543, 1.656> <-1.194, 1.542, 1.663> <-1.183, 1.544, 1.678> <-1.182, 1.544, 1.690> 
		<-1.205, 1.529, 1.656> <-1.195, 1.529, 1.663> <-1.183, 1.528, 1.678> <-1.182, 1.528, 1.690> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.199, 1.577, 1.698> <-1.198, 1.576, 1.704> <-1.207, 1.565, 1.713> <-1.212, 1.562, 1.709> 
		<-1.189, 1.566, 1.693> <-1.188, 1.564, 1.700> <-1.200, 1.557, 1.710> <-1.205, 1.554, 1.706> 
		<-1.182, 1.544, 1.690> <-1.181, 1.544, 1.697> <-1.194, 1.539, 1.708> <-1.200, 1.540, 1.704> 
		<-1.182, 1.528, 1.690> <-1.182, 1.528, 1.697> <-1.195, 1.529, 1.708> <-1.200, 1.529, 1.704> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.212, 1.562, 1.709> <-1.222, 1.556, 1.700> <-1.228, 1.559, 1.679> <-1.236, 1.557, 1.667> 
		<-1.205, 1.554, 1.706> <-1.215, 1.549, 1.698> <-1.223, 1.552, 1.677> <-1.230, 1.551, 1.664> 
		<-1.200, 1.540, 1.704> <-1.212, 1.540, 1.696> <-1.218, 1.538, 1.675> <-1.226, 1.539, 1.662> 
		<-1.200, 1.529, 1.704> <-1.213, 1.529, 1.696> <-1.218, 1.530, 1.675> <-1.226, 1.530, 1.662> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.261, 1.571, 1.675> <-1.260, 1.577, 1.676> <-1.261, 1.588, 1.674> <-1.259, 1.591, 1.679> 
		<-1.252, 1.571, 1.671> <-1.252, 1.577, 1.673> <-1.248, 1.588, 1.669> <-1.246, 1.591, 1.673> 
		<-1.241, 1.565, 1.667> <-1.236, 1.569, 1.666> <-1.233, 1.580, 1.662> <-1.228, 1.582, 1.666> 
		<-1.235, 1.559, 1.664> <-1.230, 1.563, 1.664> <-1.224, 1.570, 1.659> <-1.220, 1.572, 1.663> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.259, 1.591, 1.679> <-1.254, 1.598, 1.688> <-1.247, 1.603, 1.705> <-1.243, 1.599, 1.716> 
		<-1.246, 1.591, 1.673> <-1.242, 1.597, 1.683> <-1.233, 1.602, 1.699> <-1.228, 1.598, 1.710> 
		<-1.228, 1.582, 1.666> <-1.220, 1.587, 1.674> <-1.211, 1.591, 1.690> <-1.209, 1.589, 1.702> 
		<-1.220, 1.572, 1.663> <-1.211, 1.577, 1.670> <-1.201, 1.580, 1.686> <-1.199, 1.577, 1.698> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.243, 1.599, 1.716> <-1.241, 1.597, 1.722> <-1.239, 1.581, 1.727> <-1.242, 1.577, 1.722> 
		<-1.228, 1.598, 1.710> <-1.226, 1.596, 1.716> <-1.229, 1.580, 1.723> <-1.232, 1.576, 1.717> 
		<-1.209, 1.589, 1.702> <-1.208, 1.587, 1.708> <-1.214, 1.573, 1.716> <-1.218, 1.570, 1.712> 
		<-1.199, 1.577, 1.698> <-1.198, 1.576, 1.704> <-1.207, 1.565, 1.713> <-1.212, 1.562, 1.709> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.242, 1.577, 1.722> <-1.246, 1.568, 1.710> <-1.255, 1.572, 1.690> <-1.260, 1.569, 1.677> 
		<-1.232, 1.576, 1.717> <-1.237, 1.568, 1.706> <-1.246, 1.571, 1.687> <-1.252, 1.569, 1.674> 
		<-1.218, 1.570, 1.712> <-1.229, 1.564, 1.703> <-1.234, 1.565, 1.682> <-1.241, 1.564, 1.669> 
		<-1.212, 1.562, 1.709> <-1.222, 1.556, 1.700> <-1.228, 1.559, 1.679> <-1.236, 1.557, 1.667> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.656, 2.218, 1.418> <-0.659, 2.222, 1.420> <-0.667, 2.230, 1.421> <-0.667, 2.232, 1.427> 
		<-0.649, 2.224, 1.415> <-0.653, 2.229, 1.418> <-0.657, 2.240, 1.417> <-0.657, 2.242, 1.423> 
		<-0.638, 2.229, 1.410> <-0.637, 2.235, 1.411> <-0.642, 2.246, 1.411> <-0.640, 2.249, 1.416> 
		<-0.629, 2.229, 1.407> <-0.628, 2.235, 1.408> <-0.629, 2.245, 1.406> <-0.627, 2.249, 1.410> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.667, 2.232, 1.427> <-0.667, 2.237, 1.438> <-0.663, 2.241, 1.456> <-0.657, 2.238, 1.466> 
		<-0.657, 2.242, 1.423> <-0.658, 2.247, 1.434> <-0.653, 2.251, 1.452> <-0.646, 2.249, 1.462> 
		<-0.640, 2.249, 1.416> <-0.635, 2.256, 1.425> <-0.630, 2.260, 1.443> <-0.626, 2.257, 1.454> 
		<-0.627, 2.249, 1.410> <-0.623, 2.255, 1.420> <-0.616, 2.260, 1.437> <-0.611, 2.256, 1.448> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.657, 2.238, 1.466> <-0.653, 2.236, 1.472> <-0.641, 2.224, 1.472> <-0.641, 2.222, 1.466> 
		<-0.646, 2.249, 1.462> <-0.642, 2.247, 1.467> <-0.634, 2.232, 1.469> <-0.633, 2.229, 1.463> 
		<-0.626, 2.257, 1.454> <-0.623, 2.255, 1.460> <-0.617, 2.238, 1.463> <-0.620, 2.234, 1.457> 
		<-0.611, 2.256, 1.448> <-0.609, 2.254, 1.454> <-0.607, 2.238, 1.458> <-0.610, 2.234, 1.453> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.641, 2.222, 1.466> <-0.640, 2.216, 1.452> <-0.650, 2.218, 1.433> <-0.654, 2.216, 1.419> 
		<-0.633, 2.229, 1.463> <-0.632, 2.223, 1.450> <-0.644, 2.224, 1.431> <-0.648, 2.222, 1.417> 
		<-0.620, 2.234, 1.457> <-0.624, 2.226, 1.446> <-0.631, 2.229, 1.425> <-0.636, 2.227, 1.412> 
		<-0.610, 2.234, 1.453> <-0.615, 2.226, 1.442> <-0.623, 2.229, 1.422> <-0.628, 2.227, 1.409> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.668, 2.190, 1.422> <-0.673, 2.190, 1.426> <-0.684, 2.190, 1.427> <-0.685, 2.190, 1.433> 
		<-0.667, 2.199, 1.422> <-0.673, 2.199, 1.426> <-0.683, 2.204, 1.427> <-0.684, 2.204, 1.433> 
		<-0.662, 2.212, 1.420> <-0.665, 2.216, 1.423> <-0.676, 2.221, 1.425> <-0.676, 2.223, 1.430> 
		<-0.656, 2.218, 1.418> <-0.659, 2.222, 1.420> <-0.667, 2.230, 1.421> <-0.667, 2.232, 1.427> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.685, 2.190, 1.433> <-0.687, 2.191, 1.446> <-0.685, 2.191, 1.464> <-0.677, 2.190, 1.474> 
		<-0.684, 2.204, 1.433> <-0.686, 2.204, 1.446> <-0.684, 2.206, 1.464> <-0.676, 2.206, 1.474> 
		<-0.676, 2.223, 1.430> <-0.677, 2.228, 1.442> <-0.674, 2.230, 1.460> <-0.667, 2.227, 1.470> 
		<-0.667, 2.232, 1.427> <-0.667, 2.237, 1.438> <-0.663, 2.241, 1.456> <-0.657, 2.238, 1.466> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.677, 2.190, 1.474> <-0.673, 2.190, 1.479> <-0.656, 2.189, 1.478> <-0.654, 2.189, 1.471> 
		<-0.676, 2.206, 1.474> <-0.672, 2.206, 1.479> <-0.655, 2.200, 1.478> <-0.654, 2.200, 1.471> 
		<-0.667, 2.227, 1.470> <-0.664, 2.226, 1.476> <-0.648, 2.217, 1.475> <-0.648, 2.214, 1.469> 
		<-0.657, 2.238, 1.466> <-0.653, 2.236, 1.472> <-0.641, 2.224, 1.472> <-0.641, 2.222, 1.466> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.654, 2.189, 1.471> <-0.651, 2.189, 1.457> <-0.662, 2.190, 1.438> <-0.665, 2.190, 1.423> 
		<-0.654, 2.200, 1.471> <-0.650, 2.200, 1.457> <-0.662, 2.198, 1.438> <-0.665, 2.198, 1.423> 
		<-0.648, 2.214, 1.469> <-0.647, 2.208, 1.455> <-0.656, 2.212, 1.435> <-0.660, 2.210, 1.421> 
		<-0.641, 2.222, 1.466> <-0.640, 2.216, 1.452> <-0.650, 2.218, 1.433> <-0.654, 2.216, 1.419> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.658, 2.161, 1.418> <-0.662, 2.157, 1.420> <-0.670, 2.149, 1.421> <-0.670, 2.147, 1.427> 
		<-0.664, 2.168, 1.420> <-0.667, 2.164, 1.423> <-0.678, 2.160, 1.425> <-0.679, 2.157, 1.431> 
		<-0.668, 2.181, 1.422> <-0.673, 2.181, 1.426> <-0.684, 2.177, 1.427> <-0.685, 2.177, 1.434> 
		<-0.668, 2.190, 1.422> <-0.673, 2.190, 1.426> <-0.684, 2.190, 1.427> <-0.685, 2.190, 1.433> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.670, 2.147, 1.427> <-0.671, 2.143, 1.438> <-0.667, 2.139, 1.456> <-0.660, 2.141, 1.466> 
		<-0.679, 2.157, 1.431> <-0.679, 2.153, 1.442> <-0.677, 2.150, 1.461> <-0.670, 2.153, 1.470> 
		<-0.685, 2.177, 1.434> <-0.687, 2.177, 1.446> <-0.685, 2.175, 1.464> <-0.678, 2.175, 1.474> 
		<-0.685, 2.190, 1.433> <-0.687, 2.191, 1.446> <-0.685, 2.191, 1.464> <-0.677, 2.190, 1.474> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.660, 2.141, 1.466> <-0.656, 2.142, 1.472> <-0.644, 2.153, 1.472> <-0.643, 2.156, 1.466> 
		<-0.670, 2.153, 1.470> <-0.666, 2.154, 1.476> <-0.650, 2.161, 1.475> <-0.650, 2.164, 1.469> 
		<-0.678, 2.175, 1.474> <-0.673, 2.174, 1.479> <-0.656, 2.179, 1.478> <-0.655, 2.179, 1.471> 
		<-0.677, 2.190, 1.474> <-0.673, 2.190, 1.479> <-0.656, 2.189, 1.478> <-0.654, 2.189, 1.471> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.643, 2.156, 1.466> <-0.642, 2.162, 1.453> <-0.652, 2.160, 1.433> <-0.656, 2.162, 1.419> 
		<-0.650, 2.164, 1.469> <-0.648, 2.170, 1.455> <-0.657, 2.167, 1.435> <-0.661, 2.169, 1.421> 
		<-0.655, 2.179, 1.471> <-0.651, 2.179, 1.457> <-0.662, 2.181, 1.438> <-0.665, 2.181, 1.423> 
		<-0.654, 2.189, 1.471> <-0.651, 2.189, 1.457> <-0.662, 2.190, 1.438> <-0.665, 2.190, 1.423> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.632, 2.148, 1.407> <-0.632, 2.142, 1.408> <-0.633, 2.131, 1.406> <-0.631, 2.128, 1.411> 
		<-0.641, 2.148, 1.410> <-0.640, 2.142, 1.412> <-0.646, 2.132, 1.411> <-0.644, 2.128, 1.416> 
		<-0.652, 2.154, 1.415> <-0.656, 2.150, 1.418> <-0.661, 2.139, 1.417> <-0.661, 2.137, 1.423> 
		<-0.658, 2.161, 1.418> <-0.662, 2.157, 1.420> <-0.670, 2.149, 1.421> <-0.670, 2.147, 1.427> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.631, 2.128, 1.411> <-0.628, 2.121, 1.420> <-0.621, 2.116, 1.437> <-0.616, 2.119, 1.448> 
		<-0.644, 2.128, 1.416> <-0.640, 2.122, 1.426> <-0.635, 2.117, 1.443> <-0.631, 2.120, 1.454> 
		<-0.661, 2.137, 1.423> <-0.662, 2.132, 1.435> <-0.657, 2.127, 1.452> <-0.650, 2.130, 1.462> 
		<-0.670, 2.147, 1.427> <-0.671, 2.143, 1.438> <-0.667, 2.139, 1.456> <-0.660, 2.141, 1.466> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.616, 2.119, 1.448> <-0.614, 2.121, 1.454> <-0.611, 2.137, 1.459> <-0.613, 2.142, 1.454> 
		<-0.631, 2.120, 1.454> <-0.628, 2.122, 1.460> <-0.621, 2.138, 1.463> <-0.623, 2.142, 1.458> 
		<-0.650, 2.130, 1.462> <-0.647, 2.131, 1.468> <-0.637, 2.146, 1.469> <-0.636, 2.148, 1.463> 
		<-0.660, 2.141, 1.466> <-0.656, 2.142, 1.472> <-0.644, 2.153, 1.472> <-0.643, 2.156, 1.466> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.613, 2.142, 1.454> <-0.617, 2.150, 1.442> <-0.626, 2.148, 1.422> <-0.631, 2.150, 1.409> 
		<-0.623, 2.142, 1.458> <-0.627, 2.151, 1.446> <-0.634, 2.148, 1.426> <-0.639, 2.150, 1.412> 
		<-0.636, 2.148, 1.463> <-0.635, 2.154, 1.450> <-0.646, 2.154, 1.431> <-0.650, 2.156, 1.417> 
		<-0.643, 2.156, 1.466> <-0.642, 2.162, 1.453> <-0.652, 2.160, 1.433> <-0.656, 2.162, 1.419> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.605, 2.159, 1.396> <-0.601, 2.155, 1.396> <-0.595, 2.147, 1.391> <-0.591, 2.144, 1.395> 
		<-0.612, 2.153, 1.399> <-0.607, 2.148, 1.398> <-0.605, 2.137, 1.394> <-0.601, 2.135, 1.398> 
		<-0.623, 2.148, 1.403> <-0.623, 2.142, 1.405> <-0.620, 2.131, 1.401> <-0.618, 2.128, 1.405> 
		<-0.632, 2.148, 1.407> <-0.632, 2.142, 1.408> <-0.633, 2.131, 1.406> <-0.631, 2.128, 1.411> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.591, 2.144, 1.395> <-0.583, 2.139, 1.402> <-0.573, 2.135, 1.418> <-0.571, 2.138, 1.430> 
		<-0.601, 2.135, 1.398> <-0.592, 2.130, 1.406> <-0.584, 2.125, 1.422> <-0.581, 2.127, 1.434> 
		<-0.618, 2.128, 1.405> <-0.615, 2.121, 1.415> <-0.606, 2.115, 1.431> <-0.602, 2.119, 1.442> 
		<-0.631, 2.128, 1.411> <-0.628, 2.121, 1.420> <-0.621, 2.116, 1.437> <-0.616, 2.119, 1.448> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.571, 2.138, 1.430> <-0.570, 2.139, 1.436> <-0.578, 2.151, 1.445> <-0.582, 2.154, 1.441> 
		<-0.581, 2.127, 1.434> <-0.580, 2.128, 1.440> <-0.585, 2.144, 1.448> <-0.590, 2.147, 1.444> 
		<-0.602, 2.119, 1.442> <-0.599, 2.121, 1.448> <-0.601, 2.137, 1.455> <-0.603, 2.141, 1.450> 
		<-0.616, 2.119, 1.448> <-0.614, 2.121, 1.454> <-0.611, 2.137, 1.459> <-0.613, 2.142, 1.454> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.582, 2.154, 1.441> <-0.592, 2.160, 1.432> <-0.599, 2.158, 1.411> <-0.606, 2.160, 1.399> 
		<-0.590, 2.147, 1.444> <-0.600, 2.153, 1.435> <-0.605, 2.152, 1.414> <-0.612, 2.154, 1.401> 
		<-0.603, 2.141, 1.450> <-0.608, 2.150, 1.438> <-0.618, 2.147, 1.419> <-0.623, 2.150, 1.406> 
		<-0.613, 2.142, 1.454> <-0.617, 2.150, 1.442> <-0.626, 2.148, 1.422> <-0.631, 2.150, 1.409> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.593, 2.187, 1.392> <-0.587, 2.187, 1.390> <-0.578, 2.186, 1.384> <-0.573, 2.186, 1.388> 
		<-0.594, 2.178, 1.392> <-0.588, 2.178, 1.390> <-0.579, 2.173, 1.384> <-0.574, 2.172, 1.388> 
		<-0.599, 2.165, 1.394> <-0.595, 2.161, 1.393> <-0.586, 2.156, 1.387> <-0.582, 2.154, 1.391> 
		<-0.605, 2.159, 1.396> <-0.601, 2.155, 1.396> <-0.595, 2.147, 1.391> <-0.591, 2.144, 1.395> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.573, 2.186, 1.388> <-0.563, 2.186, 1.395> <-0.552, 2.185, 1.410> <-0.550, 2.185, 1.422> 
		<-0.574, 2.172, 1.388> <-0.564, 2.172, 1.395> <-0.552, 2.170, 1.410> <-0.551, 2.170, 1.422> 
		<-0.582, 2.154, 1.391> <-0.574, 2.149, 1.399> <-0.562, 2.146, 1.414> <-0.560, 2.149, 1.425> 
		<-0.591, 2.144, 1.395> <-0.583, 2.139, 1.402> <-0.573, 2.135, 1.418> <-0.571, 2.138, 1.430> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.550, 2.185, 1.422> <-0.550, 2.185, 1.429> <-0.563, 2.186, 1.440> <-0.569, 2.186, 1.436> 
		<-0.551, 2.170, 1.422> <-0.550, 2.170, 1.429> <-0.563, 2.175, 1.440> <-0.569, 2.176, 1.436> 
		<-0.560, 2.149, 1.425> <-0.559, 2.150, 1.432> <-0.571, 2.158, 1.442> <-0.575, 2.161, 1.438> 
		<-0.571, 2.138, 1.430> <-0.570, 2.139, 1.436> <-0.578, 2.151, 1.445> <-0.582, 2.154, 1.441> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.569, 2.186, 1.436> <-0.581, 2.187, 1.428> <-0.587, 2.187, 1.407> <-0.594, 2.187, 1.394> 
		<-0.569, 2.176, 1.436> <-0.581, 2.176, 1.428> <-0.587, 2.178, 1.407> <-0.595, 2.178, 1.394> 
		<-0.575, 2.161, 1.438> <-0.585, 2.168, 1.429> <-0.593, 2.164, 1.409> <-0.600, 2.166, 1.396> 
		<-0.582, 2.154, 1.441> <-0.592, 2.160, 1.432> <-0.599, 2.158, 1.411> <-0.606, 2.160, 1.399> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.603, 2.216, 1.396> <-0.599, 2.220, 1.396> <-0.592, 2.227, 1.390> <-0.588, 2.229, 1.394> 
		<-0.597, 2.209, 1.394> <-0.593, 2.213, 1.393> <-0.583, 2.217, 1.387> <-0.579, 2.219, 1.391> 
		<-0.593, 2.196, 1.392> <-0.587, 2.196, 1.390> <-0.578, 2.200, 1.384> <-0.573, 2.200, 1.388> 
		<-0.593, 2.187, 1.392> <-0.587, 2.187, 1.390> <-0.578, 2.186, 1.384> <-0.573, 2.186, 1.388> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.588, 2.229, 1.394> <-0.580, 2.234, 1.402> <-0.569, 2.237, 1.418> <-0.567, 2.234, 1.429> 
		<-0.579, 2.219, 1.391> <-0.571, 2.224, 1.398> <-0.559, 2.226, 1.413> <-0.557, 2.223, 1.425> 
		<-0.573, 2.200, 1.388> <-0.563, 2.200, 1.395> <-0.551, 2.201, 1.410> <-0.550, 2.201, 1.422> 
		<-0.573, 2.186, 1.388> <-0.563, 2.186, 1.395> <-0.552, 2.185, 1.410> <-0.550, 2.185, 1.422> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.567, 2.234, 1.429> <-0.566, 2.233, 1.436> <-0.575, 2.222, 1.445> <-0.580, 2.219, 1.441> 
		<-0.557, 2.223, 1.425> <-0.556, 2.222, 1.432> <-0.568, 2.214, 1.442> <-0.573, 2.212, 1.438> 
		<-0.550, 2.201, 1.422> <-0.549, 2.201, 1.429> <-0.562, 2.197, 1.440> <-0.568, 2.197, 1.436> 
		<-0.550, 2.185, 1.422> <-0.550, 2.185, 1.429> <-0.563, 2.186, 1.440> <-0.569, 2.186, 1.436> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.580, 2.219, 1.441> <-0.590, 2.214, 1.432> <-0.597, 2.216, 1.411> <-0.604, 2.214, 1.398> 
		<-0.573, 2.212, 1.438> <-0.584, 2.206, 1.429> <-0.591, 2.209, 1.409> <-0.598, 2.208, 1.396> 
		<-0.568, 2.197, 1.436> <-0.581, 2.197, 1.428> <-0.586, 2.196, 1.407> <-0.594, 2.196, 1.394> 
		<-0.569, 2.186, 1.436> <-0.581, 2.187, 1.428> <-0.587, 2.187, 1.407> <-0.594, 2.187, 1.394> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.629, 2.229, 1.407> <-0.628, 2.235, 1.408> <-0.629, 2.245, 1.406> <-0.627, 2.249, 1.410> 
		<-0.620, 2.228, 1.403> <-0.620, 2.234, 1.404> <-0.616, 2.245, 1.400> <-0.614, 2.248, 1.405> 
		<-0.609, 2.223, 1.398> <-0.604, 2.227, 1.398> <-0.601, 2.237, 1.394> <-0.597, 2.240, 1.398> 
		<-0.603, 2.216, 1.396> <-0.599, 2.220, 1.396> <-0.592, 2.227, 1.390> <-0.588, 2.229, 1.394> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.627, 2.249, 1.410> <-0.623, 2.255, 1.420> <-0.616, 2.260, 1.437> <-0.611, 2.256, 1.448> 
		<-0.614, 2.248, 1.405> <-0.610, 2.255, 1.415> <-0.601, 2.259, 1.431> <-0.597, 2.256, 1.442> 
		<-0.597, 2.240, 1.398> <-0.588, 2.244, 1.406> <-0.579, 2.249, 1.422> <-0.577, 2.246, 1.434> 
		<-0.588, 2.229, 1.394> <-0.580, 2.234, 1.402> <-0.569, 2.237, 1.418> <-0.567, 2.234, 1.429> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.611, 2.256, 1.448> <-0.609, 2.254, 1.454> <-0.607, 2.238, 1.458> <-0.610, 2.234, 1.453> 
		<-0.597, 2.256, 1.442> <-0.594, 2.254, 1.448> <-0.598, 2.238, 1.454> <-0.600, 2.234, 1.449> 
		<-0.577, 2.246, 1.434> <-0.576, 2.245, 1.440> <-0.582, 2.230, 1.448> <-0.587, 2.227, 1.444> 
		<-0.567, 2.234, 1.429> <-0.566, 2.233, 1.436> <-0.575, 2.222, 1.445> <-0.580, 2.219, 1.441> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.610, 2.234, 1.453> <-0.615, 2.226, 1.442> <-0.623, 2.229, 1.422> <-0.628, 2.227, 1.409> 
		<-0.600, 2.234, 1.449> <-0.605, 2.225, 1.438> <-0.615, 2.228, 1.419> <-0.620, 2.226, 1.405> 
		<-0.587, 2.227, 1.444> <-0.597, 2.221, 1.435> <-0.602, 2.222, 1.414> <-0.609, 2.221, 1.401> 
		<-0.580, 2.219, 1.441> <-0.590, 2.214, 1.432> <-0.597, 2.216, 1.411> <-0.604, 2.214, 1.398> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.293, 1.552, 1.819> <-1.288, 1.554, 1.830> <-1.282, 1.550, 1.849> <-1.275, 1.559, 1.854> 
		<-1.305, 1.562, 1.824> <-1.299, 1.564, 1.835> <-1.299, 1.566, 1.857> <-1.292, 1.575, 1.861> 
		<-1.325, 1.576, 1.821> <-1.326, 1.583, 1.831> <-1.325, 1.585, 1.853> <-1.322, 1.596, 1.856> 
		<-1.338, 1.583, 1.813> <-1.339, 1.590, 1.823> <-1.344, 1.595, 1.841> <-1.341, 1.606, 1.844> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.275, 1.559, 1.854> <-1.263, 1.575, 1.861> <-1.247, 1.604, 1.864> <-1.242, 1.622, 1.853> 
		<-1.292, 1.575, 1.861> <-1.280, 1.591, 1.869> <-1.266, 1.622, 1.872> <-1.261, 1.640, 1.862> 
		<-1.322, 1.596, 1.856> <-1.318, 1.616, 1.863> <-1.305, 1.647, 1.867> <-1.295, 1.664, 1.856> 
		<-1.341, 1.606, 1.844> <-1.336, 1.626, 1.851> <-1.326, 1.659, 1.854> <-1.317, 1.675, 1.843> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.242, 1.622, 1.853> <-1.239, 1.634, 1.847> <-1.247, 1.640, 1.818> <-1.255, 1.631, 1.812> 
		<-1.261, 1.640, 1.862> <-1.258, 1.651, 1.855> <-1.261, 1.652, 1.823> <-1.268, 1.643, 1.818> 
		<-1.295, 1.664, 1.856> <-1.290, 1.673, 1.850> <-1.289, 1.670, 1.818> <-1.291, 1.659, 1.814> 
		<-1.317, 1.675, 1.843> <-1.311, 1.685, 1.837> <-1.303, 1.678, 1.809> <-1.306, 1.666, 1.805> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.255, 1.631, 1.812> <-1.269, 1.612, 1.802> <-1.282, 1.578, 1.814> <-1.294, 1.555, 1.815> 
		<-1.268, 1.643, 1.818> <-1.282, 1.624, 1.807> <-1.293, 1.587, 1.819> <-1.305, 1.565, 1.820> 
		<-1.291, 1.659, 1.814> <-1.296, 1.635, 1.805> <-1.315, 1.603, 1.816> <-1.324, 1.578, 1.817> 
		<-1.306, 1.666, 1.805> <-1.311, 1.642, 1.796> <-1.327, 1.609, 1.808> <-1.336, 1.584, 1.809> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.268, 1.519, 1.784> <-1.258, 1.517, 1.789> <-1.245, 1.504, 1.799> <-1.237, 1.510, 1.800> 
		<-1.271, 1.527, 1.798> <-1.261, 1.524, 1.803> <-1.250, 1.515, 1.821> <-1.241, 1.521, 1.822> 
		<-1.282, 1.541, 1.815> <-1.276, 1.543, 1.825> <-1.264, 1.534, 1.842> <-1.258, 1.543, 1.846> 
		<-1.293, 1.552, 1.819> <-1.288, 1.554, 1.830> <-1.282, 1.550, 1.849> <-1.275, 1.559, 1.854> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.237, 1.510, 1.800> <-1.220, 1.522, 1.802> <-1.201, 1.548, 1.800> <-1.198, 1.567, 1.793> 
		<-1.241, 1.521, 1.822> <-1.224, 1.533, 1.824> <-1.205, 1.560, 1.824> <-1.203, 1.580, 1.817> 
		<-1.258, 1.543, 1.846> <-1.246, 1.559, 1.854> <-1.227, 1.586, 1.856> <-1.222, 1.604, 1.845> 
		<-1.275, 1.559, 1.854> <-1.263, 1.575, 1.861> <-1.247, 1.604, 1.864> <-1.242, 1.622, 1.853> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.198, 1.567, 1.793> <-1.196, 1.579, 1.789> <-1.214, 1.600, 1.773> <-1.225, 1.593, 1.771> 
		<-1.203, 1.580, 1.817> <-1.201, 1.592, 1.813> <-1.218, 1.608, 1.789> <-1.229, 1.602, 1.788> 
		<-1.222, 1.604, 1.845> <-1.219, 1.616, 1.839> <-1.234, 1.628, 1.812> <-1.242, 1.618, 1.806> 
		<-1.242, 1.622, 1.853> <-1.239, 1.634, 1.847> <-1.247, 1.640, 1.818> <-1.255, 1.631, 1.812> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.225, 1.593, 1.771> <-1.246, 1.581, 1.768> <-1.256, 1.545, 1.778> <-1.269, 1.524, 1.781> 
		<-1.229, 1.602, 1.788> <-1.250, 1.589, 1.784> <-1.259, 1.552, 1.792> <-1.272, 1.531, 1.795> 
		<-1.242, 1.618, 1.806> <-1.256, 1.600, 1.796> <-1.271, 1.567, 1.810> <-1.283, 1.545, 1.811> 
		<-1.255, 1.631, 1.812> <-1.269, 1.612, 1.802> <-1.282, 1.578, 1.814> <-1.294, 1.555, 1.815> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.276, 1.505, 1.727> <-1.267, 1.500, 1.724> <-1.256, 1.484, 1.719> <-1.248, 1.488, 1.715> 
		<-1.268, 1.505, 1.743> <-1.260, 1.500, 1.740> <-1.246, 1.484, 1.744> <-1.238, 1.489, 1.740> 
		<-1.265, 1.511, 1.768> <-1.255, 1.509, 1.773> <-1.241, 1.492, 1.776> <-1.232, 1.499, 1.777> 
		<-1.268, 1.519, 1.784> <-1.258, 1.517, 1.789> <-1.245, 1.504, 1.799> <-1.237, 1.510, 1.800> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.248, 1.488, 1.715> <-1.232, 1.498, 1.708> <-1.214, 1.522, 1.699> <-1.211, 1.542, 1.697> 
		<-1.238, 1.489, 1.740> <-1.221, 1.499, 1.732> <-1.202, 1.523, 1.726> <-1.199, 1.543, 1.724> 
		<-1.232, 1.499, 1.777> <-1.215, 1.510, 1.779> <-1.196, 1.534, 1.773> <-1.193, 1.554, 1.767> 
		<-1.237, 1.510, 1.800> <-1.220, 1.522, 1.802> <-1.201, 1.548, 1.800> <-1.198, 1.567, 1.793> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.211, 1.542, 1.697> <-1.209, 1.555, 1.695> <-1.224, 1.581, 1.701> <-1.234, 1.576, 1.706> 
		<-1.199, 1.543, 1.724> <-1.197, 1.555, 1.723> <-1.216, 1.582, 1.720> <-1.226, 1.577, 1.725> 
		<-1.193, 1.554, 1.767> <-1.191, 1.566, 1.762> <-1.211, 1.591, 1.755> <-1.222, 1.584, 1.753> 
		<-1.198, 1.567, 1.793> <-1.196, 1.579, 1.789> <-1.214, 1.600, 1.773> <-1.225, 1.593, 1.771> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.234, 1.576, 1.706> <-1.255, 1.566, 1.716> <-1.264, 1.530, 1.721> <-1.277, 1.510, 1.728> 
		<-1.226, 1.577, 1.725> <-1.246, 1.567, 1.734> <-1.257, 1.530, 1.736> <-1.270, 1.510, 1.743> 
		<-1.222, 1.584, 1.753> <-1.243, 1.571, 1.750> <-1.253, 1.537, 1.763> <-1.266, 1.516, 1.767> 
		<-1.225, 1.593, 1.771> <-1.246, 1.581, 1.768> <-1.256, 1.545, 1.778> <-1.269, 1.524, 1.781> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.312, 1.516, 1.683> <-1.309, 1.513, 1.673> <-1.308, 1.500, 1.657> <-1.303, 1.506, 1.649> 
		<-1.299, 1.509, 1.691> <-1.296, 1.506, 1.681> <-1.288, 1.489, 1.670> <-1.283, 1.495, 1.662> 
		<-1.283, 1.504, 1.711> <-1.274, 1.499, 1.708> <-1.267, 1.483, 1.695> <-1.259, 1.488, 1.691> 
		<-1.276, 1.505, 1.727> <-1.267, 1.500, 1.724> <-1.256, 1.484, 1.719> <-1.248, 1.488, 1.715> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.303, 1.506, 1.649> <-1.294, 1.517, 1.634> <-1.280, 1.542, 1.620> <-1.274, 1.562, 1.621> 
		<-1.283, 1.495, 1.662> <-1.273, 1.506, 1.647> <-1.257, 1.530, 1.634> <-1.250, 1.550, 1.636> 
		<-1.259, 1.488, 1.691> <-1.243, 1.497, 1.683> <-1.226, 1.521, 1.671> <-1.223, 1.541, 1.669> 
		<-1.248, 1.488, 1.715> <-1.232, 1.498, 1.708> <-1.214, 1.522, 1.699> <-1.211, 1.542, 1.697> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.274, 1.562, 1.621> <-1.270, 1.574, 1.622> <-1.271, 1.596, 1.645> <-1.276, 1.590, 1.655> 
		<-1.250, 1.550, 1.636> <-1.246, 1.562, 1.637> <-1.255, 1.588, 1.655> <-1.261, 1.581, 1.665> 
		<-1.223, 1.541, 1.669> <-1.221, 1.554, 1.668> <-1.232, 1.581, 1.683> <-1.242, 1.576, 1.688> 
		<-1.211, 1.542, 1.697> <-1.209, 1.555, 1.695> <-1.224, 1.581, 1.701> <-1.234, 1.576, 1.706> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.276, 1.590, 1.655> <-1.288, 1.578, 1.674> <-1.301, 1.542, 1.676> <-1.311, 1.521, 1.685> 
		<-1.261, 1.581, 1.665> <-1.272, 1.569, 1.684> <-1.288, 1.535, 1.684> <-1.299, 1.514, 1.694> 
		<-1.242, 1.576, 1.688> <-1.263, 1.566, 1.697> <-1.271, 1.529, 1.706> <-1.283, 1.509, 1.712> 
		<-1.234, 1.576, 1.706> <-1.255, 1.566, 1.716> <-1.264, 1.530, 1.721> <-1.277, 1.510, 1.728> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.356, 1.547, 1.677> <-1.360, 1.549, 1.666> <-1.370, 1.544, 1.648> <-1.369, 1.552, 1.640> 
		<-1.345, 1.537, 1.672> <-1.349, 1.538, 1.661> <-1.353, 1.528, 1.641> <-1.352, 1.537, 1.632> 
		<-1.325, 1.523, 1.675> <-1.322, 1.520, 1.665> <-1.327, 1.510, 1.645> <-1.322, 1.516, 1.637> 
		<-1.312, 1.516, 1.683> <-1.309, 1.513, 1.673> <-1.308, 1.500, 1.657> <-1.303, 1.506, 1.649> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.369, 1.552, 1.640> <-1.367, 1.568, 1.625> <-1.359, 1.596, 1.609> <-1.348, 1.615, 1.611> 
		<-1.352, 1.537, 1.632> <-1.350, 1.552, 1.617> <-1.340, 1.578, 1.601> <-1.329, 1.597, 1.603> 
		<-1.322, 1.516, 1.637> <-1.313, 1.527, 1.622> <-1.301, 1.553, 1.607> <-1.295, 1.573, 1.608> 
		<-1.303, 1.506, 1.649> <-1.294, 1.517, 1.634> <-1.280, 1.542, 1.620> <-1.274, 1.562, 1.621> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.348, 1.615, 1.611> <-1.342, 1.626, 1.612> <-1.326, 1.635, 1.638> <-1.327, 1.625, 1.648> 
		<-1.329, 1.597, 1.603> <-1.322, 1.608, 1.604> <-1.313, 1.622, 1.633> <-1.314, 1.613, 1.642> 
		<-1.295, 1.573, 1.608> <-1.291, 1.586, 1.609> <-1.285, 1.604, 1.636> <-1.291, 1.597, 1.646> 
		<-1.274, 1.562, 1.621> <-1.270, 1.574, 1.622> <-1.271, 1.596, 1.645> <-1.276, 1.590, 1.655> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.327, 1.625, 1.648> <-1.328, 1.608, 1.667> <-1.345, 1.573, 1.670> <-1.353, 1.551, 1.680> 
		<-1.314, 1.613, 1.642> <-1.315, 1.596, 1.661> <-1.335, 1.563, 1.666> <-1.342, 1.541, 1.675> 
		<-1.291, 1.597, 1.646> <-1.302, 1.585, 1.665> <-1.313, 1.548, 1.669> <-1.323, 1.527, 1.678> 
		<-1.276, 1.590, 1.655> <-1.288, 1.578, 1.674> <-1.301, 1.542, 1.676> <-1.311, 1.521, 1.685> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.382, 1.580, 1.712> <-1.390, 1.586, 1.707> <-1.407, 1.591, 1.698> <-1.408, 1.601, 1.693> 
		<-1.379, 1.572, 1.698> <-1.387, 1.579, 1.692> <-1.402, 1.580, 1.676> <-1.404, 1.590, 1.672> 
		<-1.368, 1.558, 1.682> <-1.372, 1.559, 1.671> <-1.388, 1.560, 1.655> <-1.387, 1.568, 1.647> 
		<-1.356, 1.547, 1.677> <-1.360, 1.549, 1.666> <-1.370, 1.544, 1.648> <-1.369, 1.552, 1.640> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.408, 1.601, 1.693> <-1.410, 1.621, 1.684> <-1.406, 1.653, 1.673> <-1.392, 1.670, 1.672> 
		<-1.404, 1.590, 1.672> <-1.406, 1.610, 1.663> <-1.401, 1.640, 1.648> <-1.387, 1.658, 1.647> 
		<-1.387, 1.568, 1.647> <-1.385, 1.584, 1.632> <-1.379, 1.614, 1.617> <-1.368, 1.633, 1.619> 
		<-1.369, 1.552, 1.640> <-1.367, 1.568, 1.625> <-1.359, 1.596, 1.609> <-1.348, 1.615, 1.611> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.392, 1.670, 1.672> <-1.384, 1.679, 1.671> <-1.358, 1.674, 1.684> <-1.357, 1.663, 1.689> 
		<-1.387, 1.658, 1.647> <-1.380, 1.667, 1.647> <-1.355, 1.665, 1.667> <-1.353, 1.654, 1.672> 
		<-1.368, 1.633, 1.619> <-1.361, 1.644, 1.621> <-1.340, 1.647, 1.644> <-1.340, 1.638, 1.654> 
		<-1.348, 1.615, 1.611> <-1.342, 1.626, 1.612> <-1.326, 1.635, 1.638> <-1.327, 1.625, 1.648> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.357, 1.663, 1.689> <-1.353, 1.639, 1.700> <-1.371, 1.606, 1.706> <-1.378, 1.581, 1.714> 
		<-1.353, 1.654, 1.672> <-1.350, 1.631, 1.684> <-1.369, 1.599, 1.693> <-1.375, 1.574, 1.700> 
		<-1.340, 1.638, 1.654> <-1.342, 1.620, 1.672> <-1.356, 1.583, 1.675> <-1.364, 1.561, 1.684> 
		<-1.327, 1.625, 1.648> <-1.328, 1.608, 1.667> <-1.345, 1.573, 1.670> <-1.353, 1.551, 1.680> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.374, 1.594, 1.769> <-1.381, 1.603, 1.772> <-1.396, 1.612, 1.778> <-1.396, 1.623, 1.778> 
		<-1.381, 1.594, 1.753> <-1.388, 1.603, 1.756> <-1.406, 1.611, 1.754> <-1.407, 1.623, 1.754> 
		<-1.385, 1.588, 1.728> <-1.393, 1.594, 1.722> <-1.411, 1.603, 1.721> <-1.412, 1.613, 1.716> 
		<-1.382, 1.580, 1.712> <-1.390, 1.586, 1.707> <-1.407, 1.591, 1.698> <-1.408, 1.601, 1.693> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.396, 1.623, 1.778> <-1.397, 1.646, 1.778> <-1.393, 1.679, 1.775> <-1.379, 1.695, 1.768> 
		<-1.407, 1.623, 1.754> <-1.408, 1.645, 1.753> <-1.405, 1.678, 1.747> <-1.391, 1.694, 1.740> 
		<-1.412, 1.613, 1.716> <-1.415, 1.633, 1.707> <-1.411, 1.667, 1.699> <-1.397, 1.684, 1.698> 
		<-1.408, 1.601, 1.693> <-1.410, 1.621, 1.684> <-1.406, 1.653, 1.673> <-1.392, 1.670, 1.672> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.379, 1.695, 1.768> <-1.372, 1.703, 1.764> <-1.349, 1.691, 1.754> <-1.348, 1.680, 1.754> 
		<-1.391, 1.694, 1.740> <-1.384, 1.702, 1.737> <-1.357, 1.690, 1.736> <-1.356, 1.679, 1.735> 
		<-1.397, 1.684, 1.698> <-1.389, 1.693, 1.697> <-1.362, 1.683, 1.702> <-1.360, 1.672, 1.707> 
		<-1.392, 1.670, 1.672> <-1.384, 1.679, 1.671> <-1.358, 1.674, 1.684> <-1.357, 1.663, 1.689> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.348, 1.680, 1.754> <-1.345, 1.653, 1.754> <-1.364, 1.621, 1.763> <-1.370, 1.595, 1.767> 
		<-1.356, 1.679, 1.735> <-1.354, 1.653, 1.735> <-1.370, 1.620, 1.748> <-1.377, 1.595, 1.752> 
		<-1.360, 1.672, 1.707> <-1.356, 1.648, 1.718> <-1.374, 1.613, 1.721> <-1.381, 1.589, 1.728> 
		<-1.357, 1.663, 1.689> <-1.353, 1.639, 1.700> <-1.371, 1.606, 1.706> <-1.378, 1.581, 1.714> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.338, 1.583, 1.813> <-1.339, 1.590, 1.823> <-1.344, 1.595, 1.841> <-1.341, 1.606, 1.844> 
		<-1.351, 1.590, 1.805> <-1.352, 1.597, 1.814> <-1.364, 1.606, 1.828> <-1.362, 1.617, 1.832> 
		<-1.367, 1.595, 1.785> <-1.374, 1.604, 1.788> <-1.385, 1.613, 1.802> <-1.385, 1.624, 1.802> 
		<-1.374, 1.594, 1.769> <-1.381, 1.603, 1.772> <-1.396, 1.612, 1.778> <-1.396, 1.623, 1.778> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.341, 1.606, 1.844> <-1.336, 1.626, 1.851> <-1.326, 1.659, 1.854> <-1.317, 1.675, 1.843> 
		<-1.362, 1.617, 1.832> <-1.357, 1.637, 1.838> <-1.349, 1.671, 1.839> <-1.340, 1.688, 1.829> 
		<-1.385, 1.624, 1.802> <-1.386, 1.646, 1.802> <-1.381, 1.680, 1.802> <-1.367, 1.696, 1.795> 
		<-1.396, 1.623, 1.778> <-1.397, 1.646, 1.778> <-1.393, 1.679, 1.775> <-1.379, 1.695, 1.768> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.317, 1.675, 1.843> <-1.311, 1.685, 1.837> <-1.303, 1.678, 1.809> <-1.306, 1.666, 1.805> 
		<-1.340, 1.688, 1.829> <-1.334, 1.697, 1.823> <-1.319, 1.686, 1.799> <-1.321, 1.675, 1.795> 
		<-1.367, 1.696, 1.795> <-1.360, 1.704, 1.792> <-1.340, 1.692, 1.773> <-1.340, 1.680, 1.773> 
		<-1.379, 1.695, 1.768> <-1.372, 1.703, 1.764> <-1.349, 1.691, 1.754> <-1.348, 1.680, 1.754> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.306, 1.666, 1.805> <-1.311, 1.642, 1.796> <-1.327, 1.609, 1.808> <-1.336, 1.584, 1.809> 
		<-1.321, 1.675, 1.795> <-1.326, 1.651, 1.786> <-1.339, 1.616, 1.800> <-1.348, 1.591, 1.801> 
		<-1.340, 1.680, 1.773> <-1.337, 1.654, 1.772> <-1.357, 1.621, 1.779> <-1.364, 1.596, 1.783> 
		<-1.348, 1.680, 1.754> <-1.345, 1.653, 1.754> <-1.364, 1.621, 1.763> <-1.370, 1.595, 1.767> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.632, 2.253, 1.537> <-0.626, 2.254, 1.547> <-0.622, 2.251, 1.568> <-0.611, 2.255, 1.571> 
		<-0.635, 2.269, 1.539> <-0.629, 2.270, 1.549> <-0.626, 2.275, 1.570> <-0.615, 2.279, 1.573> 
		<-0.644, 2.291, 1.532> <-0.640, 2.299, 1.539> <-0.636, 2.304, 1.561> <-0.628, 2.312, 1.562> 
		<-0.651, 2.302, 1.522> <-0.647, 2.310, 1.529> <-0.647, 2.321, 1.546> <-0.638, 2.328, 1.547> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.611, 2.255, 1.571> <-0.592, 2.263, 1.576> <-0.561, 2.277, 1.573> <-0.547, 2.286, 1.560> 
		<-0.615, 2.279, 1.573> <-0.596, 2.287, 1.578> <-0.566, 2.304, 1.576> <-0.552, 2.313, 1.563> 
		<-0.628, 2.312, 1.562> <-0.612, 2.327, 1.565> <-0.583, 2.345, 1.563> <-0.566, 2.350, 1.550> 
		<-0.638, 2.328, 1.547> <-0.622, 2.343, 1.550> <-0.595, 2.363, 1.546> <-0.578, 2.369, 1.533> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.547, 2.286, 1.560> <-0.539, 2.291, 1.551> <-0.544, 2.296, 1.520> <-0.556, 2.291, 1.517> 
		<-0.552, 2.313, 1.563> <-0.544, 2.318, 1.554> <-0.547, 2.314, 1.522> <-0.559, 2.309, 1.519> 
		<-0.566, 2.350, 1.550> <-0.557, 2.353, 1.543> <-0.560, 2.343, 1.512> <-0.569, 2.335, 1.510> 
		<-0.578, 2.369, 1.533> <-0.569, 2.371, 1.526> <-0.568, 2.356, 1.500> <-0.577, 2.347, 1.499> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.556, 2.291, 1.517> <-0.579, 2.283, 1.509> <-0.609, 2.265, 1.528> <-0.631, 2.254, 1.533> 
		<-0.559, 2.309, 1.519> <-0.582, 2.301, 1.511> <-0.611, 2.281, 1.529> <-0.634, 2.270, 1.534> 
		<-0.569, 2.335, 1.510> <-0.587, 2.317, 1.506> <-0.620, 2.304, 1.521> <-0.642, 2.290, 1.527> 
		<-0.577, 2.347, 1.499> <-0.595, 2.329, 1.494> <-0.627, 2.315, 1.512> <-0.648, 2.301, 1.518> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.633, 2.205, 1.511> <-0.626, 2.198, 1.517> <-0.622, 2.183, 1.531> <-0.611, 2.183, 1.531> 
		<-0.630, 2.215, 1.524> <-0.623, 2.209, 1.530> <-0.618, 2.199, 1.549> <-0.607, 2.199, 1.550> 
		<-0.630, 2.237, 1.536> <-0.623, 2.238, 1.546> <-0.617, 2.227, 1.565> <-0.607, 2.231, 1.568> 
		<-0.632, 2.253, 1.537> <-0.626, 2.254, 1.547> <-0.622, 2.251, 1.568> <-0.611, 2.255, 1.571> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.611, 2.183, 1.531> <-0.591, 2.183, 1.532> <-0.561, 2.192, 1.526> <-0.548, 2.204, 1.515> 
		<-0.607, 2.199, 1.550> <-0.586, 2.199, 1.551> <-0.556, 2.210, 1.547> <-0.543, 2.222, 1.536> 
		<-0.607, 2.231, 1.568> <-0.587, 2.239, 1.573> <-0.556, 2.249, 1.570> <-0.542, 2.259, 1.557> 
		<-0.611, 2.255, 1.571> <-0.592, 2.263, 1.576> <-0.561, 2.277, 1.573> <-0.547, 2.286, 1.560> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.548, 2.204, 1.515> <-0.540, 2.212, 1.509> <-0.543, 2.235, 1.488> <-0.556, 2.236, 1.487> 
		<-0.543, 2.222, 1.536> <-0.535, 2.230, 1.529> <-0.540, 2.247, 1.502> <-0.553, 2.248, 1.501> 
		<-0.542, 2.259, 1.557> <-0.534, 2.264, 1.548> <-0.541, 2.277, 1.518> <-0.552, 2.273, 1.515> 
		<-0.547, 2.286, 1.560> <-0.539, 2.291, 1.551> <-0.544, 2.296, 1.520> <-0.556, 2.291, 1.517> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.556, 2.236, 1.487> <-0.581, 2.237, 1.484> <-0.609, 2.217, 1.501> <-0.631, 2.209, 1.508> 
		<-0.553, 2.248, 1.501> <-0.578, 2.249, 1.498> <-0.606, 2.227, 1.513> <-0.629, 2.219, 1.519> 
		<-0.552, 2.273, 1.515> <-0.575, 2.264, 1.507> <-0.606, 2.250, 1.526> <-0.628, 2.239, 1.531> 
		<-0.556, 2.291, 1.517> <-0.579, 2.283, 1.509> <-0.609, 2.265, 1.528> <-0.631, 2.254, 1.533> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.651, 2.186, 1.459> <-0.648, 2.176, 1.457> <-0.648, 2.156, 1.457> <-0.639, 2.155, 1.452> 
		<-0.644, 2.186, 1.475> <-0.641, 2.176, 1.473> <-0.638, 2.156, 1.481> <-0.629, 2.154, 1.477> 
		<-0.636, 2.194, 1.498> <-0.630, 2.187, 1.504> <-0.627, 2.167, 1.511> <-0.616, 2.166, 1.512> 
		<-0.633, 2.205, 1.511> <-0.626, 2.198, 1.517> <-0.622, 2.183, 1.531> <-0.611, 2.183, 1.531> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.639, 2.155, 1.452> <-0.621, 2.151, 1.444> <-0.593, 2.158, 1.432> <-0.579, 2.172, 1.426> 
		<-0.629, 2.154, 1.477> <-0.610, 2.151, 1.468> <-0.581, 2.158, 1.459> <-0.567, 2.171, 1.453> 
		<-0.616, 2.166, 1.512> <-0.596, 2.166, 1.512> <-0.566, 2.173, 1.503> <-0.553, 2.185, 1.493> 
		<-0.611, 2.183, 1.531> <-0.591, 2.183, 1.532> <-0.561, 2.192, 1.526> <-0.548, 2.204, 1.515> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.579, 2.172, 1.426> <-0.570, 2.180, 1.422> <-0.566, 2.211, 1.421> <-0.577, 2.214, 1.426> 
		<-0.567, 2.171, 1.453> <-0.558, 2.180, 1.449> <-0.558, 2.211, 1.439> <-0.569, 2.214, 1.445> 
		<-0.553, 2.185, 1.493> <-0.545, 2.193, 1.486> <-0.547, 2.222, 1.472> <-0.560, 2.223, 1.471> 
		<-0.548, 2.204, 1.515> <-0.540, 2.212, 1.509> <-0.543, 2.235, 1.488> <-0.556, 2.236, 1.487> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.577, 2.214, 1.426> <-0.599, 2.220, 1.436> <-0.628, 2.198, 1.448> <-0.649, 2.191, 1.458> 
		<-0.569, 2.214, 1.445> <-0.591, 2.220, 1.455> <-0.621, 2.197, 1.464> <-0.642, 2.190, 1.473> 
		<-0.560, 2.223, 1.471> <-0.585, 2.224, 1.469> <-0.612, 2.206, 1.489> <-0.634, 2.198, 1.495> 
		<-0.556, 2.236, 1.487> <-0.581, 2.237, 1.484> <-0.609, 2.217, 1.501> <-0.631, 2.209, 1.508> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.677, 2.207, 1.410> <-0.677, 2.201, 1.401> <-0.685, 2.186, 1.389> <-0.678, 2.186, 1.380> 
		<-0.670, 2.195, 1.421> <-0.670, 2.189, 1.412> <-0.674, 2.168, 1.405> <-0.667, 2.169, 1.396> 
		<-0.658, 2.186, 1.443> <-0.655, 2.177, 1.441> <-0.659, 2.157, 1.432> <-0.650, 2.155, 1.428> 
		<-0.651, 2.186, 1.459> <-0.648, 2.176, 1.457> <-0.648, 2.156, 1.457> <-0.639, 2.155, 1.452> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.678, 2.186, 1.380> <-0.665, 2.186, 1.364> <-0.640, 2.195, 1.346> <-0.623, 2.207, 1.344> 
		<-0.667, 2.169, 1.396> <-0.654, 2.169, 1.380> <-0.627, 2.175, 1.364> <-0.611, 2.187, 1.362> 
		<-0.650, 2.155, 1.428> <-0.632, 2.152, 1.420> <-0.605, 2.159, 1.404> <-0.591, 2.172, 1.398> 
		<-0.639, 2.155, 1.452> <-0.621, 2.151, 1.444> <-0.593, 2.158, 1.432> <-0.579, 2.172, 1.426> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.623, 2.207, 1.344> <-0.613, 2.215, 1.342> <-0.599, 2.238, 1.360> <-0.607, 2.238, 1.370> 
		<-0.611, 2.187, 1.362> <-0.600, 2.195, 1.361> <-0.591, 2.224, 1.372> <-0.599, 2.225, 1.383> 
		<-0.591, 2.172, 1.398> <-0.582, 2.181, 1.395> <-0.574, 2.211, 1.402> <-0.586, 2.214, 1.407> 
		<-0.579, 2.172, 1.426> <-0.570, 2.180, 1.422> <-0.566, 2.211, 1.421> <-0.577, 2.214, 1.426> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.607, 2.238, 1.370> <-0.622, 2.239, 1.390> <-0.654, 2.219, 1.399> <-0.674, 2.211, 1.412> 
		<-0.599, 2.225, 1.383> <-0.613, 2.226, 1.403> <-0.647, 2.208, 1.410> <-0.667, 2.200, 1.422> 
		<-0.586, 2.214, 1.407> <-0.607, 2.220, 1.417> <-0.634, 2.198, 1.433> <-0.656, 2.191, 1.442> 
		<-0.577, 2.214, 1.426> <-0.599, 2.220, 1.436> <-0.628, 2.198, 1.448> <-0.649, 2.191, 1.458> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.695, 2.256, 1.395> <-0.698, 2.257, 1.383> <-0.710, 2.255, 1.366> <-0.705, 2.259, 1.357> 
		<-0.692, 2.240, 1.393> <-0.695, 2.241, 1.382> <-0.706, 2.231, 1.364> <-0.701, 2.235, 1.354> 
		<-0.684, 2.218, 1.400> <-0.684, 2.211, 1.391> <-0.695, 2.202, 1.374> <-0.688, 2.202, 1.365> 
		<-0.677, 2.207, 1.410> <-0.677, 2.201, 1.401> <-0.685, 2.186, 1.389> <-0.678, 2.186, 1.380> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.705, 2.259, 1.357> <-0.696, 2.267, 1.339> <-0.674, 2.281, 1.318> <-0.654, 2.290, 1.317> 
		<-0.701, 2.235, 1.354> <-0.691, 2.243, 1.336> <-0.669, 2.254, 1.315> <-0.649, 2.263, 1.314> 
		<-0.688, 2.202, 1.365> <-0.675, 2.203, 1.349> <-0.651, 2.214, 1.329> <-0.635, 2.226, 1.327> 
		<-0.678, 2.186, 1.380> <-0.665, 2.186, 1.364> <-0.640, 2.195, 1.346> <-0.623, 2.207, 1.344> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.654, 2.290, 1.317> <-0.642, 2.296, 1.316> <-0.623, 2.299, 1.341> <-0.628, 2.294, 1.352> 
		<-0.649, 2.263, 1.314> <-0.637, 2.269, 1.313> <-0.619, 2.281, 1.339> <-0.625, 2.276, 1.350> 
		<-0.635, 2.226, 1.327> <-0.624, 2.234, 1.325> <-0.607, 2.250, 1.348> <-0.615, 2.251, 1.359> 
		<-0.623, 2.207, 1.344> <-0.613, 2.215, 1.342> <-0.599, 2.238, 1.360> <-0.607, 2.238, 1.370> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.628, 2.294, 1.352> <-0.638, 2.285, 1.374> <-0.672, 2.268, 1.384> <-0.691, 2.257, 1.397> 
		<-0.625, 2.276, 1.350> <-0.635, 2.267, 1.372> <-0.669, 2.253, 1.382> <-0.688, 2.242, 1.395> 
		<-0.615, 2.251, 1.359> <-0.630, 2.252, 1.379> <-0.660, 2.229, 1.390> <-0.680, 2.221, 1.402> 
		<-0.607, 2.238, 1.370> <-0.622, 2.239, 1.390> <-0.654, 2.219, 1.399> <-0.674, 2.211, 1.412> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.695, 2.304, 1.421> <-0.698, 2.312, 1.413> <-0.710, 2.323, 1.403> <-0.705, 2.331, 1.396> 
		<-0.698, 2.293, 1.409> <-0.701, 2.301, 1.401> <-0.714, 2.308, 1.384> <-0.709, 2.316, 1.377> 
		<-0.698, 2.272, 1.396> <-0.701, 2.273, 1.385> <-0.715, 2.279, 1.369> <-0.710, 2.283, 1.359> 
		<-0.695, 2.256, 1.395> <-0.698, 2.257, 1.383> <-0.710, 2.255, 1.366> <-0.705, 2.259, 1.357> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.705, 2.331, 1.396> <-0.696, 2.346, 1.382> <-0.675, 2.367, 1.365> <-0.653, 2.372, 1.361> 
		<-0.709, 2.316, 1.377> <-0.700, 2.331, 1.364> <-0.680, 2.349, 1.344> <-0.658, 2.354, 1.341> 
		<-0.710, 2.283, 1.359> <-0.700, 2.291, 1.341> <-0.679, 2.309, 1.321> <-0.659, 2.318, 1.320> 
		<-0.705, 2.259, 1.357> <-0.696, 2.267, 1.339> <-0.674, 2.281, 1.318> <-0.654, 2.290, 1.317> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.653, 2.372, 1.361> <-0.642, 2.375, 1.359> <-0.623, 2.358, 1.375> <-0.628, 2.349, 1.382> 
		<-0.658, 2.354, 1.341> <-0.647, 2.357, 1.339> <-0.627, 2.346, 1.361> <-0.631, 2.337, 1.368> 
		<-0.659, 2.318, 1.320> <-0.647, 2.323, 1.319> <-0.626, 2.317, 1.343> <-0.631, 2.313, 1.354> 
		<-0.654, 2.290, 1.317> <-0.642, 2.296, 1.316> <-0.623, 2.299, 1.341> <-0.628, 2.294, 1.352> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.628, 2.349, 1.382> <-0.638, 2.331, 1.399> <-0.672, 2.317, 1.410> <-0.691, 2.303, 1.422> 
		<-0.631, 2.337, 1.368> <-0.641, 2.319, 1.384> <-0.674, 2.307, 1.398> <-0.693, 2.293, 1.410> 
		<-0.631, 2.313, 1.354> <-0.641, 2.304, 1.376> <-0.675, 2.283, 1.385> <-0.694, 2.272, 1.399> 
		<-0.628, 2.294, 1.352> <-0.638, 2.285, 1.374> <-0.672, 2.268, 1.384> <-0.691, 2.257, 1.397> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.676, 2.323, 1.473> <-0.677, 2.334, 1.474> <-0.683, 2.351, 1.477> <-0.677, 2.360, 1.475> 
		<-0.684, 2.323, 1.457> <-0.684, 2.334, 1.458> <-0.694, 2.351, 1.453> <-0.688, 2.360, 1.450> 
		<-0.692, 2.315, 1.434> <-0.695, 2.323, 1.427> <-0.705, 2.340, 1.423> <-0.700, 2.348, 1.416> 
		<-0.695, 2.304, 1.421> <-0.698, 2.312, 1.413> <-0.710, 2.323, 1.403> <-0.705, 2.331, 1.396> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.677, 2.360, 1.475> <-0.665, 2.378, 1.470> <-0.642, 2.401, 1.460> <-0.622, 2.404, 1.451> 
		<-0.688, 2.360, 1.450> <-0.676, 2.378, 1.445> <-0.654, 2.402, 1.432> <-0.634, 2.405, 1.423> 
		<-0.700, 2.348, 1.416> <-0.691, 2.363, 1.402> <-0.669, 2.386, 1.388> <-0.648, 2.391, 1.384> 
		<-0.705, 2.331, 1.396> <-0.696, 2.346, 1.382> <-0.675, 2.367, 1.365> <-0.653, 2.372, 1.361> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.622, 2.404, 1.451> <-0.612, 2.406, 1.446> <-0.601, 2.381, 1.441> <-0.606, 2.371, 1.443> 
		<-0.634, 2.405, 1.423> <-0.624, 2.406, 1.419> <-0.609, 2.381, 1.422> <-0.615, 2.372, 1.424> 
		<-0.648, 2.391, 1.384> <-0.637, 2.394, 1.382> <-0.620, 2.371, 1.390> <-0.624, 2.362, 1.398> 
		<-0.653, 2.372, 1.361> <-0.642, 2.375, 1.359> <-0.623, 2.358, 1.375> <-0.628, 2.349, 1.382> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.606, 2.371, 1.443> <-0.620, 2.349, 1.449> <-0.653, 2.336, 1.463> <-0.673, 2.321, 1.472> 
		<-0.615, 2.372, 1.424> <-0.628, 2.349, 1.430> <-0.660, 2.336, 1.448> <-0.680, 2.321, 1.456> 
		<-0.624, 2.362, 1.398> <-0.634, 2.344, 1.414> <-0.669, 2.327, 1.423> <-0.688, 2.313, 1.434> 
		<-0.628, 2.349, 1.382> <-0.638, 2.331, 1.399> <-0.672, 2.317, 1.410> <-0.691, 2.303, 1.422> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.651, 2.302, 1.522> <-0.647, 2.310, 1.529> <-0.647, 2.321, 1.546> <-0.638, 2.328, 1.547> 
		<-0.658, 2.313, 1.511> <-0.654, 2.321, 1.519> <-0.658, 2.338, 1.530> <-0.649, 2.346, 1.531> 
		<-0.669, 2.322, 1.490> <-0.670, 2.333, 1.490> <-0.672, 2.350, 1.501> <-0.666, 2.359, 1.499> 
		<-0.676, 2.323, 1.473> <-0.677, 2.334, 1.474> <-0.683, 2.351, 1.477> <-0.677, 2.360, 1.475> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.638, 2.328, 1.547> <-0.622, 2.343, 1.550> <-0.595, 2.363, 1.546> <-0.578, 2.369, 1.533> 
		<-0.649, 2.346, 1.531> <-0.633, 2.361, 1.533> <-0.608, 2.383, 1.528> <-0.591, 2.389, 1.515> 
		<-0.666, 2.359, 1.499> <-0.654, 2.378, 1.494> <-0.630, 2.400, 1.487> <-0.610, 2.404, 1.478> 
		<-0.677, 2.360, 1.475> <-0.665, 2.378, 1.470> <-0.642, 2.401, 1.460> <-0.622, 2.404, 1.451> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.578, 2.369, 1.533> <-0.569, 2.371, 1.526> <-0.568, 2.356, 1.500> <-0.577, 2.347, 1.499> 
		<-0.591, 2.389, 1.515> <-0.581, 2.391, 1.507> <-0.577, 2.369, 1.488> <-0.585, 2.361, 1.486> 
		<-0.610, 2.404, 1.478> <-0.600, 2.405, 1.474> <-0.593, 2.380, 1.459> <-0.598, 2.371, 1.462> 
		<-0.622, 2.404, 1.451> <-0.612, 2.406, 1.446> <-0.601, 2.381, 1.441> <-0.606, 2.371, 1.443> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.577, 2.347, 1.499> <-0.595, 2.329, 1.494> <-0.627, 2.315, 1.512> <-0.648, 2.301, 1.518> 
		<-0.585, 2.361, 1.486> <-0.604, 2.343, 1.482> <-0.634, 2.326, 1.502> <-0.655, 2.312, 1.507> 
		<-0.598, 2.371, 1.462> <-0.612, 2.349, 1.467> <-0.646, 2.336, 1.478> <-0.666, 2.320, 1.487> 
		<-0.606, 2.371, 1.443> <-0.620, 2.349, 1.449> <-0.653, 2.336, 1.463> <-0.673, 2.321, 1.472> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.165, 1.837, -0.844> <-1.136, 1.800, -0.844> <-1.111, 1.768, -0.883> <-1.111, 1.768, -0.931> 
		<-1.314, 1.721, -0.844> <-1.285, 1.683, -0.844> <-1.260, 1.652, -0.883> <-1.260, 1.652, -0.931> 
		<-1.513, 1.565, -0.844> <-1.484, 1.528, -0.844> <-1.459, 1.496, -0.883> <-1.459, 1.496, -0.931> 
		<-1.662, 1.448, -0.844> <-1.633, 1.411, -0.844> <-1.609, 1.380, -0.883> <-1.609, 1.380, -0.931> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.111, 1.768, -0.931> <-1.111, 1.768, -0.979> <-1.136, 1.800, -1.018> <-1.165, 1.837, -1.018> 
		<-1.260, 1.652, -0.931> <-1.260, 1.652, -0.979> <-1.285, 1.683, -1.018> <-1.314, 1.721, -1.018> 
		<-1.459, 1.496, -0.931> <-1.459, 1.496, -0.979> <-1.484, 1.528, -1.018> <-1.513, 1.565, -1.018> 
		<-1.609, 1.380, -0.931> <-1.609, 1.380, -0.979> <-1.633, 1.411, -1.018> <-1.662, 1.448, -1.018> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.165, 1.837, -1.018> <-1.194, 1.875, -1.018> <-1.219, 1.906, -0.979> <-1.219, 1.906, -0.931> 
		<-1.314, 1.721, -1.018> <-1.343, 1.758, -1.018> <-1.368, 1.789, -0.979> <-1.368, 1.789, -0.931> 
		<-1.513, 1.565, -1.018> <-1.542, 1.603, -1.018> <-1.567, 1.634, -0.979> <-1.567, 1.634, -0.931> 
		<-1.662, 1.448, -1.018> <-1.692, 1.486, -1.018> <-1.716, 1.517, -0.979> <-1.716, 1.517, -0.931> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.716, 1.517, -0.931> <-1.716, 1.517, -0.883> <-1.692, 1.486, -0.844> <-1.662, 1.448, -0.844> 
		<-1.567, 1.634, -0.931> <-1.567, 1.634, -0.883> <-1.542, 1.603, -0.844> <-1.513, 1.565, -0.844> 
		<-1.368, 1.789, -0.931> <-1.368, 1.789, -0.883> <-1.343, 1.758, -0.844> <-1.314, 1.721, -0.844> 
		<-1.219, 1.906, -0.931> <-1.219, 1.906, -0.883> <-1.194, 1.875, -0.844> <-1.165, 1.837, -0.844> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.476, 1.585, -0.910> <-1.469, 1.576, -0.910> <-1.463, 1.569, -0.920> <-1.463, 1.569, -0.931> 
		<-1.625, 1.469, -0.910> <-1.618, 1.460, -0.910> <-1.612, 1.452, -0.920> <-1.612, 1.452, -0.931> 
		<-1.824, 1.313, -0.910> <-1.817, 1.304, -0.910> <-1.811, 1.297, -0.920> <-1.811, 1.297, -0.931> 
		<-1.973, 1.197, -0.910> <-1.966, 1.188, -0.910> <-1.960, 1.180, -0.920> <-1.960, 1.180, -0.931> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.463, 1.569, -0.931> <-1.463, 1.569, -0.942> <-1.469, 1.576, -0.952> <-1.476, 1.585, -0.952> 
		<-1.612, 1.452, -0.931> <-1.612, 1.452, -0.942> <-1.618, 1.460, -0.952> <-1.625, 1.469, -0.952> 
		<-1.811, 1.297, -0.931> <-1.811, 1.297, -0.942> <-1.817, 1.304, -0.952> <-1.824, 1.313, -0.952> 
		<-1.960, 1.180, -0.931> <-1.960, 1.180, -0.942> <-1.966, 1.188, -0.952> <-1.973, 1.197, -0.952> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.476, 1.585, -0.952> <-1.483, 1.594, -0.952> <-1.489, 1.602, -0.942> <-1.489, 1.602, -0.931> 
		<-1.625, 1.469, -0.952> <-1.632, 1.478, -0.952> <-1.638, 1.485, -0.942> <-1.638, 1.485, -0.931> 
		<-1.824, 1.313, -0.952> <-1.831, 1.322, -0.952> <-1.837, 1.330, -0.942> <-1.837, 1.330, -0.931> 
		<-1.973, 1.197, -0.952> <-1.980, 1.206, -0.952> <-1.986, 1.213, -0.942> <-1.986, 1.213, -0.931> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.986, 1.213, -0.931> <-1.986, 1.213, -0.920> <-1.980, 1.206, -0.910> <-1.973, 1.197, -0.910> 
		<-1.837, 1.330, -0.931> <-1.837, 1.330, -0.920> <-1.831, 1.322, -0.910> <-1.824, 1.313, -0.910> 
		<-1.638, 1.485, -0.931> <-1.638, 1.485, -0.920> <-1.632, 1.478, -0.910> <-1.625, 1.469, -0.910> 
		<-1.489, 1.602, -0.931> <-1.489, 1.602, -0.920> <-1.483, 1.594, -0.910> <-1.476, 1.585, -0.910> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.718, 1.438, -0.931> <-1.721, 1.443, -0.931> <-1.730, 1.450, -0.931> <-1.728, 1.456, -0.931> 
		<-1.718, 1.438, -0.940> <-1.721, 1.443, -0.940> <-1.730, 1.450, -0.945> <-1.728, 1.456, -0.945> 
		<-1.715, 1.434, -0.953> <-1.717, 1.438, -0.957> <-1.725, 1.445, -0.962> <-1.723, 1.450, -0.964> 
		<-1.711, 1.428, -0.959> <-1.713, 1.432, -0.964> <-1.719, 1.437, -0.971> <-1.717, 1.442, -0.974> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.728, 1.456, -0.931> <-1.723, 1.468, -0.931> <-1.712, 1.483, -0.931> <-1.701, 1.487, -0.931> 
		<-1.728, 1.456, -0.945> <-1.723, 1.468, -0.945> <-1.712, 1.483, -0.947> <-1.701, 1.487, -0.947> 
		<-1.723, 1.450, -0.964> <-1.717, 1.460, -0.969> <-1.706, 1.475, -0.971> <-1.695, 1.480, -0.968> 
		<-1.717, 1.442, -0.974> <-1.711, 1.452, -0.978> <-1.699, 1.466, -0.982> <-1.689, 1.471, -0.979> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.701, 1.487, -0.931> <-1.694, 1.490, -0.931> <-1.681, 1.480, -0.931> <-1.682, 1.473, -0.931> 
		<-1.701, 1.487, -0.947> <-1.694, 1.490, -0.947> <-1.681, 1.480, -0.942> <-1.682, 1.473, -0.942> 
		<-1.695, 1.480, -0.968> <-1.689, 1.483, -0.967> <-1.676, 1.474, -0.959> <-1.679, 1.469, -0.956> 
		<-1.689, 1.471, -0.979> <-1.682, 1.474, -0.978> <-1.671, 1.468, -0.967> <-1.674, 1.463, -0.964> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.682, 1.473, -0.931> <-1.687, 1.459, -0.931> <-1.706, 1.448, -0.931> <-1.716, 1.437, -0.931> 
		<-1.682, 1.473, -0.942> <-1.687, 1.459, -0.942> <-1.706, 1.448, -0.940> <-1.716, 1.437, -0.940> 
		<-1.679, 1.469, -0.956> <-1.684, 1.457, -0.950> <-1.702, 1.444, -0.954> <-1.712, 1.433, -0.952> 
		<-1.674, 1.463, -0.964> <-1.680, 1.451, -0.958> <-1.698, 1.439, -0.960> <-1.709, 1.428, -0.958> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.711, 1.428, -0.903> <-1.713, 1.432, -0.898> <-1.719, 1.437, -0.891> <-1.717, 1.442, -0.888> 
		<-1.715, 1.434, -0.909> <-1.717, 1.438, -0.905> <-1.725, 1.445, -0.900> <-1.723, 1.450, -0.898> 
		<-1.718, 1.438, -0.922> <-1.721, 1.443, -0.922> <-1.730, 1.450, -0.917> <-1.728, 1.456, -0.917> 
		<-1.718, 1.438, -0.931> <-1.721, 1.443, -0.931> <-1.730, 1.450, -0.931> <-1.728, 1.456, -0.931> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.717, 1.442, -0.888> <-1.711, 1.452, -0.884> <-1.699, 1.466, -0.880> <-1.689, 1.471, -0.883> 
		<-1.723, 1.450, -0.898> <-1.717, 1.460, -0.893> <-1.706, 1.475, -0.891> <-1.695, 1.480, -0.894> 
		<-1.728, 1.456, -0.917> <-1.723, 1.468, -0.917> <-1.712, 1.483, -0.915> <-1.701, 1.487, -0.915> 
		<-1.728, 1.456, -0.931> <-1.723, 1.468, -0.931> <-1.712, 1.483, -0.931> <-1.701, 1.487, -0.931> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.689, 1.471, -0.883> <-1.682, 1.474, -0.884> <-1.671, 1.468, -0.895> <-1.674, 1.463, -0.898> 
		<-1.695, 1.480, -0.894> <-1.689, 1.483, -0.895> <-1.676, 1.474, -0.903> <-1.679, 1.469, -0.906> 
		<-1.701, 1.487, -0.915> <-1.694, 1.490, -0.915> <-1.681, 1.480, -0.920> <-1.682, 1.473, -0.920> 
		<-1.701, 1.487, -0.931> <-1.694, 1.490, -0.931> <-1.681, 1.480, -0.931> <-1.682, 1.473, -0.931> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.674, 1.463, -0.898> <-1.680, 1.451, -0.904> <-1.698, 1.439, -0.902> <-1.709, 1.428, -0.904> 
		<-1.679, 1.469, -0.906> <-1.684, 1.457, -0.912> <-1.702, 1.444, -0.908> <-1.712, 1.433, -0.910> 
		<-1.682, 1.473, -0.920> <-1.687, 1.459, -0.920> <-1.706, 1.448, -0.922> <-1.716, 1.437, -0.922> 
		<-1.682, 1.473, -0.931> <-1.687, 1.459, -0.931> <-1.706, 1.448, -0.931> <-1.716, 1.437, -0.931> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.694, 1.406, -0.891> <-1.693, 1.407, -0.885> <-1.695, 1.405, -0.874> <-1.690, 1.408, -0.871> 
		<-1.699, 1.413, -0.891> <-1.698, 1.414, -0.885> <-1.703, 1.416, -0.874> <-1.699, 1.419, -0.871> 
		<-1.707, 1.423, -0.896> <-1.709, 1.427, -0.892> <-1.713, 1.429, -0.881> <-1.711, 1.434, -0.879> 
		<-1.711, 1.428, -0.903> <-1.713, 1.432, -0.898> <-1.719, 1.437, -0.891> <-1.717, 1.442, -0.888> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.690, 1.408, -0.871> <-1.682, 1.415, -0.864> <-1.668, 1.426, -0.859> <-1.659, 1.433, -0.863> 
		<-1.699, 1.419, -0.871> <-1.691, 1.426, -0.864> <-1.678, 1.438, -0.859> <-1.668, 1.446, -0.863> 
		<-1.711, 1.434, -0.879> <-1.705, 1.444, -0.874> <-1.693, 1.457, -0.869> <-1.682, 1.463, -0.872> 
		<-1.717, 1.442, -0.888> <-1.711, 1.452, -0.884> <-1.699, 1.466, -0.880> <-1.689, 1.471, -0.883> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.659, 1.433, -0.863> <-1.654, 1.437, -0.865> <-1.650, 1.440, -0.881> <-1.654, 1.437, -0.885> 
		<-1.668, 1.446, -0.863> <-1.663, 1.450, -0.865> <-1.656, 1.449, -0.881> <-1.661, 1.445, -0.885> 
		<-1.682, 1.463, -0.872> <-1.676, 1.465, -0.873> <-1.667, 1.462, -0.888> <-1.669, 1.457, -0.891> 
		<-1.689, 1.471, -0.883> <-1.682, 1.474, -0.884> <-1.671, 1.468, -0.895> <-1.674, 1.463, -0.898> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.654, 1.437, -0.885> <-1.663, 1.430, -0.893> <-1.681, 1.416, -0.890> <-1.692, 1.407, -0.893> 
		<-1.661, 1.445, -0.885> <-1.670, 1.438, -0.893> <-1.686, 1.423, -0.890> <-1.697, 1.414, -0.893> 
		<-1.669, 1.457, -0.891> <-1.675, 1.445, -0.897> <-1.694, 1.434, -0.896> <-1.705, 1.424, -0.898> 
		<-1.674, 1.463, -0.898> <-1.680, 1.451, -0.904> <-1.698, 1.439, -0.902> <-1.709, 1.428, -0.904> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.676, 1.384, -0.903> <-1.673, 1.381, -0.898> <-1.670, 1.373, -0.891> <-1.664, 1.375, -0.888> 
		<-1.680, 1.389, -0.896> <-1.677, 1.386, -0.892> <-1.676, 1.381, -0.881> <-1.670, 1.383, -0.879> 
		<-1.688, 1.399, -0.891> <-1.687, 1.399, -0.885> <-1.686, 1.394, -0.874> <-1.682, 1.398, -0.871> 
		<-1.694, 1.406, -0.891> <-1.693, 1.407, -0.885> <-1.695, 1.405, -0.874> <-1.690, 1.408, -0.871> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.664, 1.375, -0.888> <-1.653, 1.378, -0.884> <-1.637, 1.386, -0.880> <-1.629, 1.395, -0.883> 
		<-1.670, 1.383, -0.879> <-1.659, 1.385, -0.874> <-1.644, 1.395, -0.869> <-1.636, 1.404, -0.872> 
		<-1.682, 1.398, -0.871> <-1.674, 1.404, -0.864> <-1.658, 1.414, -0.859> <-1.649, 1.421, -0.863> 
		<-1.690, 1.408, -0.871> <-1.682, 1.415, -0.864> <-1.668, 1.426, -0.859> <-1.659, 1.433, -0.863> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.629, 1.395, -0.883> <-1.625, 1.400, -0.884> <-1.628, 1.412, -0.895> <-1.634, 1.411, -0.898> 
		<-1.636, 1.404, -0.872> <-1.631, 1.409, -0.873> <-1.632, 1.418, -0.888> <-1.638, 1.417, -0.891> 
		<-1.649, 1.421, -0.863> <-1.644, 1.425, -0.865> <-1.643, 1.432, -0.881> <-1.647, 1.429, -0.885> 
		<-1.659, 1.433, -0.863> <-1.654, 1.437, -0.865> <-1.650, 1.440, -0.881> <-1.654, 1.437, -0.885> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.634, 1.411, -0.898> <-1.647, 1.409, -0.904> <-1.663, 1.393, -0.902> <-1.675, 1.386, -0.904> 
		<-1.638, 1.417, -0.891> <-1.652, 1.414, -0.897> <-1.667, 1.398, -0.896> <-1.679, 1.391, -0.898> 
		<-1.647, 1.429, -0.885> <-1.657, 1.421, -0.893> <-1.675, 1.409, -0.890> <-1.687, 1.400, -0.893> 
		<-1.654, 1.437, -0.885> <-1.663, 1.430, -0.893> <-1.681, 1.416, -0.890> <-1.692, 1.407, -0.893> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.669, 1.374, -0.931> <-1.664, 1.370, -0.931> <-1.659, 1.360, -0.931> <-1.653, 1.361, -0.931> 
		<-1.669, 1.374, -0.922> <-1.664, 1.370, -0.922> <-1.659, 1.360, -0.917> <-1.653, 1.361, -0.917> 
		<-1.672, 1.378, -0.909> <-1.668, 1.376, -0.905> <-1.664, 1.366, -0.900> <-1.658, 1.367, -0.898> 
		<-1.676, 1.384, -0.903> <-1.673, 1.381, -0.898> <-1.670, 1.373, -0.891> <-1.664, 1.375, -0.888> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.653, 1.361, -0.931> <-1.641, 1.362, -0.931> <-1.624, 1.369, -0.931> <-1.617, 1.379, -0.931> 
		<-1.653, 1.361, -0.917> <-1.641, 1.362, -0.917> <-1.624, 1.369, -0.915> <-1.617, 1.379, -0.915> 
		<-1.658, 1.367, -0.898> <-1.647, 1.370, -0.893> <-1.630, 1.377, -0.891> <-1.622, 1.386, -0.894> 
		<-1.664, 1.375, -0.888> <-1.653, 1.378, -0.884> <-1.637, 1.386, -0.880> <-1.629, 1.395, -0.883> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.617, 1.379, -0.931> <-1.613, 1.385, -0.931> <-1.619, 1.401, -0.931> <-1.625, 1.400, -0.931> 
		<-1.617, 1.379, -0.915> <-1.613, 1.385, -0.915> <-1.619, 1.401, -0.920> <-1.625, 1.400, -0.920> 
		<-1.622, 1.386, -0.894> <-1.618, 1.391, -0.895> <-1.623, 1.406, -0.903> <-1.629, 1.405, -0.906> 
		<-1.629, 1.395, -0.883> <-1.625, 1.400, -0.884> <-1.628, 1.412, -0.895> <-1.634, 1.411, -0.898> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.625, 1.400, -0.931> <-1.640, 1.400, -0.931> <-1.656, 1.384, -0.931> <-1.668, 1.377, -0.931> 
		<-1.625, 1.400, -0.920> <-1.640, 1.400, -0.920> <-1.656, 1.384, -0.922> <-1.668, 1.377, -0.922> 
		<-1.629, 1.405, -0.906> <-1.642, 1.403, -0.912> <-1.659, 1.389, -0.908> <-1.672, 1.381, -0.910> 
		<-1.634, 1.411, -0.898> <-1.647, 1.409, -0.904> <-1.663, 1.393, -0.902> <-1.675, 1.386, -0.904> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.676, 1.384, -0.959> <-1.673, 1.381, -0.964> <-1.670, 1.373, -0.971> <-1.664, 1.375, -0.974> 
		<-1.672, 1.378, -0.953> <-1.668, 1.376, -0.957> <-1.664, 1.366, -0.962> <-1.658, 1.367, -0.964> 
		<-1.669, 1.374, -0.940> <-1.664, 1.370, -0.940> <-1.659, 1.360, -0.945> <-1.653, 1.361, -0.945> 
		<-1.669, 1.374, -0.931> <-1.664, 1.370, -0.931> <-1.659, 1.360, -0.931> <-1.653, 1.361, -0.931> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.664, 1.375, -0.974> <-1.653, 1.378, -0.978> <-1.637, 1.386, -0.982> <-1.629, 1.395, -0.979> 
		<-1.658, 1.367, -0.964> <-1.647, 1.370, -0.969> <-1.630, 1.377, -0.971> <-1.622, 1.386, -0.968> 
		<-1.653, 1.361, -0.945> <-1.641, 1.362, -0.945> <-1.624, 1.369, -0.947> <-1.617, 1.379, -0.947> 
		<-1.653, 1.361, -0.931> <-1.641, 1.362, -0.931> <-1.624, 1.369, -0.931> <-1.617, 1.379, -0.931> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.629, 1.395, -0.979> <-1.625, 1.400, -0.978> <-1.628, 1.412, -0.967> <-1.634, 1.411, -0.964> 
		<-1.622, 1.386, -0.968> <-1.618, 1.391, -0.967> <-1.623, 1.406, -0.959> <-1.629, 1.405, -0.956> 
		<-1.617, 1.379, -0.947> <-1.613, 1.385, -0.947> <-1.619, 1.401, -0.942> <-1.625, 1.400, -0.942> 
		<-1.617, 1.379, -0.931> <-1.613, 1.385, -0.931> <-1.619, 1.401, -0.931> <-1.625, 1.400, -0.931> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.634, 1.411, -0.964> <-1.647, 1.409, -0.958> <-1.663, 1.393, -0.960> <-1.675, 1.386, -0.958> 
		<-1.629, 1.405, -0.956> <-1.642, 1.403, -0.950> <-1.659, 1.389, -0.954> <-1.672, 1.381, -0.952> 
		<-1.625, 1.400, -0.942> <-1.640, 1.400, -0.942> <-1.656, 1.384, -0.940> <-1.668, 1.377, -0.940> 
		<-1.625, 1.400, -0.931> <-1.640, 1.400, -0.931> <-1.656, 1.384, -0.931> <-1.668, 1.377, -0.931> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.694, 1.406, -0.971> <-1.693, 1.407, -0.977> <-1.695, 1.405, -0.988> <-1.690, 1.408, -0.991> 
		<-1.688, 1.399, -0.971> <-1.687, 1.399, -0.977> <-1.686, 1.394, -0.988> <-1.682, 1.398, -0.991> 
		<-1.680, 1.389, -0.966> <-1.677, 1.386, -0.970> <-1.676, 1.381, -0.981> <-1.670, 1.383, -0.984> 
		<-1.676, 1.384, -0.959> <-1.673, 1.381, -0.964> <-1.670, 1.373, -0.971> <-1.664, 1.375, -0.974> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.690, 1.408, -0.991> <-1.682, 1.415, -0.998> <-1.668, 1.426, -1.003> <-1.659, 1.433, -0.999> 
		<-1.682, 1.398, -0.991> <-1.674, 1.404, -0.998> <-1.658, 1.414, -1.003> <-1.649, 1.421, -0.999> 
		<-1.670, 1.383, -0.984> <-1.659, 1.385, -0.988> <-1.644, 1.395, -0.993> <-1.636, 1.404, -0.990> 
		<-1.664, 1.375, -0.974> <-1.653, 1.378, -0.978> <-1.637, 1.386, -0.982> <-1.629, 1.395, -0.979> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.659, 1.433, -0.999> <-1.654, 1.437, -0.997> <-1.650, 1.440, -0.981> <-1.654, 1.437, -0.977> 
		<-1.649, 1.421, -0.999> <-1.644, 1.425, -0.997> <-1.643, 1.432, -0.981> <-1.647, 1.429, -0.977> 
		<-1.636, 1.404, -0.990> <-1.631, 1.409, -0.989> <-1.632, 1.418, -0.974> <-1.638, 1.417, -0.971> 
		<-1.629, 1.395, -0.979> <-1.625, 1.400, -0.978> <-1.628, 1.412, -0.967> <-1.634, 1.411, -0.964> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.654, 1.437, -0.977> <-1.663, 1.430, -0.969> <-1.681, 1.416, -0.972> <-1.692, 1.407, -0.969> 
		<-1.647, 1.429, -0.977> <-1.657, 1.421, -0.969> <-1.675, 1.409, -0.972> <-1.687, 1.400, -0.969> 
		<-1.638, 1.417, -0.971> <-1.652, 1.414, -0.965> <-1.667, 1.398, -0.966> <-1.679, 1.391, -0.964> 
		<-1.634, 1.411, -0.964> <-1.647, 1.409, -0.958> <-1.663, 1.393, -0.960> <-1.675, 1.386, -0.958> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.711, 1.428, -0.959> <-1.713, 1.432, -0.964> <-1.719, 1.437, -0.971> <-1.717, 1.442, -0.974> 
		<-1.707, 1.423, -0.966> <-1.709, 1.427, -0.970> <-1.713, 1.429, -0.981> <-1.711, 1.434, -0.984> 
		<-1.699, 1.413, -0.971> <-1.698, 1.414, -0.977> <-1.703, 1.416, -0.988> <-1.699, 1.419, -0.991> 
		<-1.694, 1.406, -0.971> <-1.693, 1.407, -0.977> <-1.695, 1.405, -0.988> <-1.690, 1.408, -0.991> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.717, 1.442, -0.974> <-1.711, 1.452, -0.978> <-1.699, 1.466, -0.982> <-1.689, 1.471, -0.979> 
		<-1.711, 1.434, -0.984> <-1.705, 1.444, -0.988> <-1.693, 1.457, -0.993> <-1.682, 1.463, -0.990> 
		<-1.699, 1.419, -0.991> <-1.691, 1.426, -0.998> <-1.678, 1.438, -1.003> <-1.668, 1.446, -0.999> 
		<-1.690, 1.408, -0.991> <-1.682, 1.415, -0.998> <-1.668, 1.426, -1.003> <-1.659, 1.433, -0.999> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.689, 1.471, -0.979> <-1.682, 1.474, -0.978> <-1.671, 1.468, -0.967> <-1.674, 1.463, -0.964> 
		<-1.682, 1.463, -0.990> <-1.676, 1.465, -0.989> <-1.667, 1.462, -0.974> <-1.669, 1.457, -0.971> 
		<-1.668, 1.446, -0.999> <-1.663, 1.450, -0.997> <-1.656, 1.449, -0.981> <-1.661, 1.445, -0.977> 
		<-1.659, 1.433, -0.999> <-1.654, 1.437, -0.997> <-1.650, 1.440, -0.981> <-1.654, 1.437, -0.977> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.674, 1.463, -0.964> <-1.680, 1.451, -0.958> <-1.698, 1.439, -0.960> <-1.709, 1.428, -0.958> 
		<-1.669, 1.457, -0.971> <-1.675, 1.445, -0.965> <-1.694, 1.434, -0.966> <-1.705, 1.424, -0.964> 
		<-1.661, 1.445, -0.977> <-1.670, 1.438, -0.969> <-1.686, 1.423, -0.972> <-1.697, 1.414, -0.969> 
		<-1.654, 1.437, -0.977> <-1.663, 1.430, -0.969> <-1.681, 1.416, -0.972> <-1.692, 1.407, -0.969> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.029, 1.204, -0.956> <-2.033, 1.209, -0.955> <-2.040, 1.217, -0.957> <-2.042, 1.220, -0.952> 
		<-2.022, 1.210, -0.956> <-2.026, 1.214, -0.955> <-2.029, 1.226, -0.957> <-2.031, 1.228, -0.952> 
		<-2.009, 1.213, -0.956> <-2.008, 1.219, -0.955> <-2.011, 1.231, -0.957> <-2.011, 1.234, -0.952> 
		<-2.000, 1.212, -0.956> <-1.999, 1.218, -0.954> <-1.997, 1.229, -0.957> <-1.997, 1.232, -0.951> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.042, 1.220, -0.952> <-2.046, 1.225, -0.942> <-2.049, 1.229, -0.924> <-2.047, 1.226, -0.912> 
		<-2.031, 1.228, -0.952> <-2.035, 1.233, -0.942> <-2.037, 1.238, -0.923> <-2.035, 1.235, -0.912> 
		<-2.011, 1.234, -0.952> <-2.010, 1.240, -0.941> <-2.012, 1.245, -0.923> <-2.012, 1.242, -0.911> 
		<-1.997, 1.232, -0.951> <-1.996, 1.239, -0.941> <-1.996, 1.243, -0.923> <-1.997, 1.240, -0.911> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.047, 1.226, -0.912> <-2.046, 1.224, -0.905> <-2.036, 1.211, -0.900> <-2.034, 1.208, -0.906> 
		<-2.035, 1.235, -0.912> <-2.034, 1.234, -0.905> <-2.028, 1.218, -0.900> <-2.025, 1.215, -0.906> 
		<-2.012, 1.242, -0.911> <-2.013, 1.239, -0.905> <-2.010, 1.223, -0.900> <-2.010, 1.219, -0.905> 
		<-1.997, 1.240, -0.911> <-1.997, 1.238, -0.905> <-1.999, 1.221, -0.900> <-1.999, 1.218, -0.905> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.034, 1.208, -0.906> <-2.028, 1.202, -0.918> <-2.030, 1.204, -0.940> <-2.028, 1.202, -0.954> 
		<-2.025, 1.215, -0.906> <-2.020, 1.208, -0.918> <-2.023, 1.209, -0.940> <-2.021, 1.208, -0.954> 
		<-2.010, 1.219, -0.905> <-2.011, 1.211, -0.917> <-2.008, 1.213, -0.939> <-2.008, 1.211, -0.954> 
		<-1.999, 1.218, -0.905> <-2.000, 1.209, -0.917> <-2.000, 1.212, -0.939> <-2.000, 1.210, -0.954> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.044, 1.177, -0.957> <-2.050, 1.178, -0.956> <-2.061, 1.179, -0.958> <-2.064, 1.180, -0.953> 
		<-2.043, 1.186, -0.957> <-2.049, 1.187, -0.955> <-2.059, 1.193, -0.958> <-2.063, 1.193, -0.953> 
		<-2.036, 1.198, -0.956> <-2.040, 1.203, -0.955> <-2.050, 1.209, -0.958> <-2.053, 1.211, -0.952> 
		<-2.029, 1.204, -0.956> <-2.033, 1.209, -0.955> <-2.040, 1.217, -0.957> <-2.042, 1.220, -0.952> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.064, 1.180, -0.953> <-2.071, 1.180, -0.943> <-2.076, 1.181, -0.925> <-2.073, 1.180, -0.913> 
		<-2.063, 1.193, -0.953> <-2.069, 1.194, -0.942> <-2.074, 1.196, -0.924> <-2.071, 1.196, -0.913> 
		<-2.053, 1.211, -0.952> <-2.057, 1.216, -0.942> <-2.062, 1.219, -0.924> <-2.060, 1.216, -0.912> 
		<-2.042, 1.220, -0.952> <-2.046, 1.225, -0.942> <-2.049, 1.229, -0.924> <-2.047, 1.226, -0.912> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.073, 1.180, -0.913> <-2.071, 1.180, -0.906> <-2.055, 1.178, -0.901> <-2.051, 1.177, -0.906> 
		<-2.071, 1.196, -0.913> <-2.069, 1.195, -0.906> <-2.054, 1.188, -0.901> <-2.050, 1.188, -0.906> 
		<-2.060, 1.216, -0.912> <-2.058, 1.214, -0.906> <-2.044, 1.205, -0.900> <-2.042, 1.202, -0.906> 
		<-2.047, 1.226, -0.912> <-2.046, 1.224, -0.905> <-2.036, 1.211, -0.900> <-2.034, 1.208, -0.906> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.051, 1.177, -0.906> <-2.042, 1.176, -0.918> <-2.045, 1.177, -0.940> <-2.042, 1.177, -0.955> 
		<-2.050, 1.188, -0.906> <-2.041, 1.187, -0.918> <-2.044, 1.186, -0.940> <-2.041, 1.186, -0.955> 
		<-2.042, 1.202, -0.906> <-2.037, 1.195, -0.918> <-2.037, 1.199, -0.940> <-2.035, 1.197, -0.954> 
		<-2.034, 1.208, -0.906> <-2.028, 1.202, -0.918> <-2.030, 1.204, -0.940> <-2.028, 1.202, -0.954> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.036, 1.147, -0.957> <-2.041, 1.144, -0.956> <-2.049, 1.137, -0.958> <-2.052, 1.135, -0.953> 
		<-2.042, 1.155, -0.957> <-2.047, 1.151, -0.956> <-2.058, 1.148, -0.958> <-2.061, 1.146, -0.953> 
		<-2.045, 1.168, -0.957> <-2.051, 1.169, -0.956> <-2.063, 1.165, -0.958> <-2.066, 1.166, -0.953> 
		<-2.044, 1.177, -0.957> <-2.050, 1.178, -0.956> <-2.061, 1.179, -0.958> <-2.064, 1.180, -0.953> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.052, 1.135, -0.953> <-2.057, 1.131, -0.943> <-2.062, 1.128, -0.925> <-2.059, 1.130, -0.913> 
		<-2.061, 1.146, -0.953> <-2.066, 1.142, -0.943> <-2.071, 1.140, -0.925> <-2.069, 1.142, -0.913> 
		<-2.066, 1.166, -0.953> <-2.073, 1.166, -0.943> <-2.078, 1.165, -0.925> <-2.075, 1.164, -0.913> 
		<-2.064, 1.180, -0.953> <-2.071, 1.180, -0.943> <-2.076, 1.181, -0.925> <-2.073, 1.180, -0.913> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.059, 1.130, -0.913> <-2.057, 1.131, -0.906> <-2.045, 1.141, -0.901> <-2.042, 1.143, -0.907> 
		<-2.069, 1.142, -0.913> <-2.067, 1.143, -0.906> <-2.051, 1.149, -0.901> <-2.048, 1.152, -0.907> 
		<-2.075, 1.164, -0.913> <-2.073, 1.164, -0.906> <-2.056, 1.167, -0.901> <-2.052, 1.167, -0.907> 
		<-2.073, 1.180, -0.913> <-2.071, 1.180, -0.906> <-2.055, 1.178, -0.901> <-2.051, 1.177, -0.906> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.042, 1.143, -0.907> <-2.035, 1.149, -0.918> <-2.037, 1.147, -0.940> <-2.035, 1.149, -0.955> 
		<-2.048, 1.152, -0.907> <-2.041, 1.157, -0.918> <-2.042, 1.154, -0.940> <-2.040, 1.156, -0.955> 
		<-2.052, 1.167, -0.907> <-2.044, 1.166, -0.918> <-2.046, 1.168, -0.940> <-2.043, 1.168, -0.955> 
		<-2.051, 1.177, -0.906> <-2.042, 1.176, -0.918> <-2.045, 1.177, -0.940> <-2.042, 1.177, -0.955> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.009, 1.132, -0.957> <-2.010, 1.126, -0.956> <-2.011, 1.116, -0.958> <-2.012, 1.112, -0.953> 
		<-2.018, 1.133, -0.957> <-2.019, 1.127, -0.956> <-2.025, 1.117, -0.958> <-2.026, 1.114, -0.953> 
		<-2.030, 1.140, -0.957> <-2.035, 1.136, -0.956> <-2.041, 1.126, -0.958> <-2.043, 1.124, -0.953> 
		<-2.036, 1.147, -0.957> <-2.041, 1.144, -0.956> <-2.049, 1.137, -0.958> <-2.052, 1.135, -0.953> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.012, 1.112, -0.953> <-2.013, 1.106, -0.943> <-2.014, 1.100, -0.925> <-2.013, 1.104, -0.913> 
		<-2.026, 1.114, -0.953> <-2.027, 1.107, -0.943> <-2.029, 1.102, -0.925> <-2.029, 1.106, -0.913> 
		<-2.043, 1.124, -0.953> <-2.049, 1.120, -0.943> <-2.052, 1.115, -0.925> <-2.049, 1.117, -0.913> 
		<-2.052, 1.135, -0.953> <-2.057, 1.131, -0.943> <-2.062, 1.128, -0.925> <-2.059, 1.130, -0.913> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.013, 1.104, -0.913> <-2.013, 1.106, -0.906> <-2.011, 1.122, -0.901> <-2.011, 1.126, -0.906> 
		<-2.029, 1.106, -0.913> <-2.029, 1.108, -0.906> <-2.022, 1.123, -0.901> <-2.021, 1.127, -0.907> 
		<-2.049, 1.117, -0.913> <-2.048, 1.118, -0.906> <-2.038, 1.132, -0.901> <-2.035, 1.135, -0.907> 
		<-2.059, 1.130, -0.913> <-2.057, 1.131, -0.906> <-2.045, 1.141, -0.901> <-2.042, 1.143, -0.907> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.011, 1.126, -0.906> <-2.010, 1.134, -0.918> <-2.010, 1.132, -0.940> <-2.009, 1.134, -0.955> 
		<-2.021, 1.127, -0.907> <-2.020, 1.136, -0.918> <-2.018, 1.133, -0.940> <-2.018, 1.135, -0.955> 
		<-2.035, 1.135, -0.907> <-2.028, 1.140, -0.918> <-2.031, 1.140, -0.940> <-2.029, 1.142, -0.955> 
		<-2.042, 1.143, -0.907> <-2.035, 1.149, -0.918> <-2.037, 1.147, -0.940> <-2.035, 1.149, -0.955> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.980, 1.140, -0.956> <-1.976, 1.136, -0.955> <-1.969, 1.127, -0.957> <-1.967, 1.125, -0.952> 
		<-1.987, 1.135, -0.956> <-1.983, 1.130, -0.955> <-1.980, 1.119, -0.958> <-1.978, 1.116, -0.952> 
		<-2.000, 1.131, -0.957> <-2.001, 1.125, -0.955> <-1.998, 1.114, -0.958> <-1.998, 1.111, -0.953> 
		<-2.009, 1.132, -0.957> <-2.010, 1.126, -0.956> <-2.011, 1.116, -0.958> <-2.012, 1.112, -0.953> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.967, 1.125, -0.952> <-1.963, 1.119, -0.942> <-1.961, 1.115, -0.924> <-1.963, 1.118, -0.912> 
		<-1.978, 1.116, -0.952> <-1.974, 1.111, -0.942> <-1.973, 1.105, -0.924> <-1.975, 1.108, -0.912> 
		<-1.998, 1.111, -0.953> <-1.999, 1.104, -0.942> <-1.998, 1.098, -0.924> <-1.998, 1.102, -0.913> 
		<-2.012, 1.112, -0.953> <-2.013, 1.106, -0.943> <-2.014, 1.100, -0.925> <-2.013, 1.104, -0.913> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.963, 1.118, -0.912> <-1.964, 1.119, -0.905> <-1.974, 1.132, -0.900> <-1.977, 1.135, -0.906> 
		<-1.975, 1.108, -0.912> <-1.977, 1.110, -0.906> <-1.983, 1.125, -0.900> <-1.985, 1.129, -0.906> 
		<-1.998, 1.102, -0.913> <-1.998, 1.104, -0.906> <-2.001, 1.120, -0.901> <-2.000, 1.124, -0.906> 
		<-2.013, 1.104, -0.913> <-2.013, 1.106, -0.906> <-2.011, 1.122, -0.901> <-2.011, 1.126, -0.906> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.977, 1.135, -0.906> <-1.982, 1.142, -0.918> <-1.980, 1.140, -0.940> <-1.981, 1.142, -0.954> 
		<-1.985, 1.129, -0.906> <-1.990, 1.136, -0.918> <-1.987, 1.135, -0.940> <-1.988, 1.137, -0.954> 
		<-2.000, 1.124, -0.906> <-1.999, 1.133, -0.918> <-2.001, 1.131, -0.940> <-2.000, 1.133, -0.955> 
		<-2.011, 1.126, -0.906> <-2.010, 1.134, -0.918> <-2.010, 1.132, -0.940> <-2.009, 1.134, -0.955> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.964, 1.167, -0.956> <-1.958, 1.167, -0.954> <-1.948, 1.165, -0.957> <-1.945, 1.165, -0.951> 
		<-1.966, 1.158, -0.956> <-1.960, 1.157, -0.955> <-1.949, 1.151, -0.957> <-1.946, 1.151, -0.952> 
		<-1.972, 1.146, -0.956> <-1.969, 1.141, -0.955> <-1.958, 1.136, -0.957> <-1.956, 1.133, -0.952> 
		<-1.980, 1.140, -0.956> <-1.976, 1.136, -0.955> <-1.969, 1.127, -0.957> <-1.967, 1.125, -0.952> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.945, 1.165, -0.951> <-1.938, 1.164, -0.941> <-1.933, 1.163, -0.923> <-1.937, 1.163, -0.911> 
		<-1.946, 1.151, -0.952> <-1.940, 1.150, -0.941> <-1.935, 1.147, -0.923> <-1.939, 1.148, -0.911> 
		<-1.956, 1.133, -0.952> <-1.952, 1.128, -0.942> <-1.948, 1.125, -0.923> <-1.951, 1.127, -0.912> 
		<-1.967, 1.125, -0.952> <-1.963, 1.119, -0.942> <-1.961, 1.115, -0.924> <-1.963, 1.118, -0.912> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.937, 1.163, -0.911> <-1.939, 1.164, -0.905> <-1.955, 1.165, -0.900> <-1.959, 1.166, -0.905> 
		<-1.939, 1.148, -0.911> <-1.941, 1.148, -0.905> <-1.957, 1.155, -0.900> <-1.960, 1.155, -0.905> 
		<-1.951, 1.127, -0.912> <-1.952, 1.129, -0.905> <-1.966, 1.139, -0.900> <-1.968, 1.142, -0.906> 
		<-1.963, 1.118, -0.912> <-1.964, 1.119, -0.905> <-1.974, 1.132, -0.900> <-1.977, 1.135, -0.906> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.959, 1.166, -0.905> <-1.967, 1.167, -0.917> <-1.964, 1.167, -0.939> <-1.966, 1.168, -0.954> 
		<-1.960, 1.155, -0.905> <-1.969, 1.157, -0.917> <-1.965, 1.158, -0.939> <-1.968, 1.159, -0.954> 
		<-1.968, 1.142, -0.906> <-1.973, 1.149, -0.918> <-1.973, 1.145, -0.940> <-1.974, 1.147, -0.954> 
		<-1.977, 1.135, -0.906> <-1.982, 1.142, -0.918> <-1.980, 1.140, -0.940> <-1.981, 1.142, -0.954> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.973, 1.197, -0.955> <-1.968, 1.201, -0.954> <-1.959, 1.207, -0.956> <-1.957, 1.209, -0.951> 
		<-1.967, 1.190, -0.955> <-1.962, 1.193, -0.954> <-1.951, 1.196, -0.956> <-1.948, 1.198, -0.951> 
		<-1.963, 1.176, -0.956> <-1.957, 1.176, -0.954> <-1.946, 1.179, -0.956> <-1.943, 1.179, -0.951> 
		<-1.964, 1.167, -0.956> <-1.958, 1.167, -0.954> <-1.948, 1.165, -0.957> <-1.945, 1.165, -0.951> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.957, 1.209, -0.951> <-1.952, 1.213, -0.941> <-1.948, 1.216, -0.922> <-1.951, 1.214, -0.911> 
		<-1.948, 1.198, -0.951> <-1.943, 1.202, -0.941> <-1.938, 1.204, -0.922> <-1.941, 1.201, -0.911> 
		<-1.943, 1.179, -0.951> <-1.936, 1.178, -0.941> <-1.931, 1.179, -0.923> <-1.935, 1.179, -0.911> 
		<-1.945, 1.165, -0.951> <-1.938, 1.164, -0.941> <-1.933, 1.163, -0.923> <-1.937, 1.163, -0.911> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.951, 1.214, -0.911> <-1.953, 1.213, -0.904> <-1.966, 1.203, -0.899> <-1.969, 1.200, -0.905> 
		<-1.941, 1.201, -0.911> <-1.943, 1.200, -0.904> <-1.959, 1.194, -0.899> <-1.962, 1.192, -0.905> 
		<-1.935, 1.179, -0.911> <-1.937, 1.179, -0.904> <-1.954, 1.176, -0.900> <-1.958, 1.177, -0.905> 
		<-1.937, 1.163, -0.911> <-1.939, 1.164, -0.905> <-1.955, 1.165, -0.900> <-1.959, 1.166, -0.905> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.969, 1.200, -0.905> <-1.975, 1.195, -0.917> <-1.973, 1.197, -0.939> <-1.974, 1.196, -0.953> 
		<-1.962, 1.192, -0.905> <-1.969, 1.187, -0.917> <-1.967, 1.190, -0.939> <-1.969, 1.189, -0.953> 
		<-1.958, 1.177, -0.905> <-1.966, 1.178, -0.917> <-1.963, 1.176, -0.939> <-1.965, 1.176, -0.954> 
		<-1.959, 1.166, -0.905> <-1.967, 1.167, -0.917> <-1.964, 1.167, -0.939> <-1.966, 1.168, -0.954> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.000, 1.212, -0.956> <-1.999, 1.218, -0.954> <-1.997, 1.229, -0.957> <-1.997, 1.232, -0.951> 
		<-1.990, 1.211, -0.956> <-1.990, 1.217, -0.954> <-1.984, 1.227, -0.956> <-1.983, 1.230, -0.951> 
		<-1.978, 1.204, -0.955> <-1.974, 1.208, -0.954> <-1.968, 1.218, -0.956> <-1.965, 1.220, -0.951> 
		<-1.973, 1.197, -0.955> <-1.968, 1.201, -0.954> <-1.959, 1.207, -0.956> <-1.957, 1.209, -0.951> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.997, 1.232, -0.951> <-1.996, 1.239, -0.941> <-1.996, 1.243, -0.923> <-1.997, 1.240, -0.911> 
		<-1.983, 1.230, -0.951> <-1.983, 1.237, -0.941> <-1.980, 1.241, -0.923> <-1.981, 1.238, -0.911> 
		<-1.965, 1.220, -0.951> <-1.960, 1.224, -0.941> <-1.958, 1.229, -0.922> <-1.961, 1.226, -0.911> 
		<-1.957, 1.209, -0.951> <-1.952, 1.213, -0.941> <-1.948, 1.216, -0.922> <-1.951, 1.214, -0.911> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.997, 1.240, -0.911> <-1.997, 1.238, -0.905> <-1.999, 1.221, -0.900> <-1.999, 1.218, -0.905> 
		<-1.981, 1.238, -0.911> <-1.981, 1.236, -0.904> <-1.989, 1.220, -0.900> <-1.989, 1.216, -0.905> 
		<-1.961, 1.226, -0.911> <-1.962, 1.225, -0.904> <-1.972, 1.211, -0.899> <-1.975, 1.209, -0.905> 
		<-1.951, 1.214, -0.911> <-1.953, 1.213, -0.904> <-1.966, 1.203, -0.899> <-1.969, 1.200, -0.905> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.999, 1.218, -0.905> <-2.000, 1.209, -0.917> <-2.000, 1.212, -0.939> <-2.000, 1.210, -0.954> 
		<-1.989, 1.216, -0.905> <-1.990, 1.208, -0.917> <-1.991, 1.211, -0.939> <-1.991, 1.209, -0.954> 
		<-1.975, 1.209, -0.905> <-1.982, 1.203, -0.917> <-1.978, 1.204, -0.939> <-1.980, 1.203, -0.953> 
		<-1.969, 1.200, -0.905> <-1.975, 1.195, -0.917> <-1.973, 1.197, -0.939> <-1.974, 1.196, -0.953> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.150, 1.900, -0.956> <-1.153, 1.905, -0.955> <-1.160, 1.913, -0.957> <-1.162, 1.916, -0.952> 
		<-1.142, 1.906, -0.956> <-1.146, 1.911, -0.955> <-1.149, 1.922, -0.957> <-1.151, 1.924, -0.952> 
		<-1.129, 1.910, -0.956> <-1.128, 1.915, -0.955> <-1.132, 1.927, -0.957> <-1.131, 1.930, -0.952> 
		<-1.120, 1.908, -0.956> <-1.119, 1.914, -0.954> <-1.118, 1.925, -0.957> <-1.118, 1.928, -0.951> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.162, 1.916, -0.952> <-1.166, 1.921, -0.942> <-1.170, 1.925, -0.924> <-1.168, 1.922, -0.912> 
		<-1.151, 1.924, -0.952> <-1.155, 1.930, -0.942> <-1.157, 1.934, -0.923> <-1.155, 1.932, -0.912> 
		<-1.131, 1.930, -0.952> <-1.131, 1.936, -0.941> <-1.132, 1.941, -0.923> <-1.133, 1.938, -0.911> 
		<-1.118, 1.928, -0.951> <-1.117, 1.935, -0.941> <-1.117, 1.940, -0.923> <-1.117, 1.936, -0.911> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.168, 1.922, -0.912> <-1.166, 1.920, -0.905> <-1.157, 1.907, -0.900> <-1.154, 1.904, -0.906> 
		<-1.155, 1.932, -0.912> <-1.154, 1.930, -0.905> <-1.148, 1.914, -0.900> <-1.146, 1.911, -0.906> 
		<-1.133, 1.938, -0.911> <-1.133, 1.936, -0.905> <-1.130, 1.919, -0.900> <-1.130, 1.915, -0.905> 
		<-1.117, 1.936, -0.911> <-1.117, 1.934, -0.905> <-1.119, 1.918, -0.900> <-1.120, 1.914, -0.905> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.154, 1.904, -0.906> <-1.149, 1.898, -0.918> <-1.150, 1.900, -0.940> <-1.148, 1.899, -0.954> 
		<-1.146, 1.911, -0.906> <-1.140, 1.904, -0.918> <-1.143, 1.906, -0.940> <-1.141, 1.904, -0.954> 
		<-1.130, 1.915, -0.905> <-1.131, 1.907, -0.917> <-1.129, 1.910, -0.939> <-1.129, 1.907, -0.954> 
		<-1.120, 1.914, -0.905> <-1.121, 1.905, -0.917> <-1.120, 1.909, -0.939> <-1.120, 1.906, -0.954> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.165, 1.873, -0.957> <-1.171, 1.874, -0.956> <-1.181, 1.875, -0.958> <-1.185, 1.876, -0.953> 
		<-1.164, 1.883, -0.957> <-1.170, 1.883, -0.955> <-1.180, 1.889, -0.958> <-1.183, 1.890, -0.953> 
		<-1.157, 1.894, -0.956> <-1.161, 1.899, -0.955> <-1.171, 1.905, -0.958> <-1.173, 1.907, -0.952> 
		<-1.150, 1.900, -0.956> <-1.153, 1.905, -0.955> <-1.160, 1.913, -0.957> <-1.162, 1.916, -0.952> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.185, 1.876, -0.953> <-1.192, 1.876, -0.943> <-1.197, 1.877, -0.925> <-1.193, 1.876, -0.913> 
		<-1.183, 1.890, -0.953> <-1.190, 1.890, -0.942> <-1.195, 1.892, -0.924> <-1.191, 1.892, -0.913> 
		<-1.173, 1.907, -0.952> <-1.177, 1.913, -0.942> <-1.182, 1.915, -0.924> <-1.180, 1.912, -0.912> 
		<-1.162, 1.916, -0.952> <-1.166, 1.921, -0.942> <-1.170, 1.925, -0.924> <-1.168, 1.922, -0.912> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.193, 1.876, -0.913> <-1.191, 1.876, -0.906> <-1.176, 1.874, -0.901> <-1.171, 1.874, -0.906> 
		<-1.191, 1.892, -0.913> <-1.190, 1.892, -0.906> <-1.174, 1.885, -0.901> <-1.170, 1.884, -0.906> 
		<-1.180, 1.912, -0.912> <-1.179, 1.911, -0.906> <-1.165, 1.901, -0.900> <-1.162, 1.898, -0.906> 
		<-1.168, 1.922, -0.912> <-1.166, 1.920, -0.905> <-1.157, 1.907, -0.900> <-1.154, 1.904, -0.906> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.171, 1.874, -0.906> <-1.163, 1.873, -0.918> <-1.165, 1.873, -0.940> <-1.163, 1.873, -0.955> 
		<-1.170, 1.884, -0.906> <-1.162, 1.883, -0.918> <-1.164, 1.882, -0.940> <-1.162, 1.882, -0.955> 
		<-1.162, 1.898, -0.906> <-1.157, 1.891, -0.918> <-1.157, 1.895, -0.940> <-1.155, 1.893, -0.954> 
		<-1.154, 1.904, -0.906> <-1.149, 1.898, -0.918> <-1.150, 1.900, -0.940> <-1.148, 1.899, -0.954> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.157, 1.844, -0.957> <-1.161, 1.840, -0.956> <-1.170, 1.833, -0.958> <-1.172, 1.831, -0.953> 
		<-1.162, 1.851, -0.957> <-1.167, 1.847, -0.956> <-1.178, 1.844, -0.958> <-1.181, 1.842, -0.953> 
		<-1.166, 1.864, -0.957> <-1.172, 1.865, -0.956> <-1.183, 1.862, -0.958> <-1.186, 1.862, -0.953> 
		<-1.165, 1.873, -0.957> <-1.171, 1.874, -0.956> <-1.181, 1.875, -0.958> <-1.185, 1.876, -0.953> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.172, 1.831, -0.953> <-1.178, 1.827, -0.943> <-1.182, 1.824, -0.925> <-1.179, 1.826, -0.913> 
		<-1.181, 1.842, -0.953> <-1.186, 1.838, -0.943> <-1.192, 1.836, -0.925> <-1.189, 1.838, -0.913> 
		<-1.186, 1.862, -0.953> <-1.193, 1.863, -0.943> <-1.199, 1.861, -0.925> <-1.195, 1.861, -0.913> 
		<-1.185, 1.876, -0.953> <-1.192, 1.876, -0.943> <-1.197, 1.877, -0.925> <-1.193, 1.876, -0.913> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.179, 1.826, -0.913> <-1.178, 1.827, -0.906> <-1.165, 1.837, -0.901> <-1.162, 1.839, -0.907> 
		<-1.189, 1.838, -0.913> <-1.188, 1.839, -0.906> <-1.172, 1.845, -0.901> <-1.169, 1.848, -0.907> 
		<-1.195, 1.861, -0.913> <-1.193, 1.860, -0.906> <-1.177, 1.863, -0.901> <-1.173, 1.863, -0.907> 
		<-1.193, 1.876, -0.913> <-1.191, 1.876, -0.906> <-1.176, 1.874, -0.901> <-1.171, 1.874, -0.906> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.162, 1.839, -0.907> <-1.155, 1.845, -0.918> <-1.157, 1.843, -0.940> <-1.155, 1.845, -0.955> 
		<-1.169, 1.848, -0.907> <-1.162, 1.853, -0.918> <-1.163, 1.850, -0.940> <-1.160, 1.852, -0.955> 
		<-1.173, 1.863, -0.907> <-1.164, 1.862, -0.918> <-1.166, 1.865, -0.940> <-1.164, 1.864, -0.955> 
		<-1.171, 1.874, -0.906> <-1.163, 1.873, -0.918> <-1.165, 1.873, -0.940> <-1.163, 1.873, -0.955> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.130, 1.829, -0.957> <-1.130, 1.823, -0.956> <-1.132, 1.812, -0.958> <-1.132, 1.808, -0.953> 
		<-1.139, 1.830, -0.957> <-1.140, 1.824, -0.956> <-1.146, 1.814, -0.958> <-1.146, 1.810, -0.953> 
		<-1.151, 1.836, -0.957> <-1.156, 1.833, -0.956> <-1.161, 1.822, -0.958> <-1.164, 1.820, -0.953> 
		<-1.157, 1.844, -0.957> <-1.161, 1.840, -0.956> <-1.170, 1.833, -0.958> <-1.172, 1.831, -0.953> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.132, 1.808, -0.953> <-1.133, 1.802, -0.943> <-1.134, 1.797, -0.925> <-1.134, 1.800, -0.913> 
		<-1.146, 1.810, -0.953> <-1.147, 1.804, -0.943> <-1.150, 1.799, -0.925> <-1.149, 1.802, -0.913> 
		<-1.164, 1.820, -0.953> <-1.169, 1.816, -0.943> <-1.172, 1.811, -0.925> <-1.170, 1.813, -0.913> 
		<-1.172, 1.831, -0.953> <-1.178, 1.827, -0.943> <-1.182, 1.824, -0.925> <-1.179, 1.826, -0.913> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.134, 1.800, -0.913> <-1.134, 1.802, -0.906> <-1.132, 1.818, -0.901> <-1.131, 1.822, -0.906> 
		<-1.149, 1.802, -0.913> <-1.149, 1.804, -0.906> <-1.142, 1.819, -0.901> <-1.142, 1.823, -0.907> 
		<-1.170, 1.813, -0.913> <-1.168, 1.815, -0.906> <-1.159, 1.829, -0.901> <-1.155, 1.831, -0.907> 
		<-1.179, 1.826, -0.913> <-1.178, 1.827, -0.906> <-1.165, 1.837, -0.901> <-1.162, 1.839, -0.907> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.131, 1.822, -0.906> <-1.130, 1.831, -0.918> <-1.130, 1.828, -0.940> <-1.130, 1.830, -0.955> 
		<-1.142, 1.823, -0.907> <-1.141, 1.832, -0.918> <-1.139, 1.829, -0.940> <-1.138, 1.832, -0.955> 
		<-1.155, 1.831, -0.907> <-1.149, 1.836, -0.918> <-1.152, 1.836, -0.940> <-1.150, 1.838, -0.955> 
		<-1.162, 1.839, -0.907> <-1.155, 1.845, -0.918> <-1.157, 1.843, -0.940> <-1.155, 1.845, -0.955> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.100, 1.837, -0.956> <-1.096, 1.832, -0.955> <-1.090, 1.823, -0.957> <-1.088, 1.821, -0.952> 
		<-1.107, 1.831, -0.956> <-1.104, 1.826, -0.955> <-1.101, 1.815, -0.958> <-1.099, 1.812, -0.952> 
		<-1.121, 1.827, -0.957> <-1.121, 1.821, -0.955> <-1.118, 1.810, -0.958> <-1.118, 1.807, -0.953> 
		<-1.130, 1.829, -0.957> <-1.130, 1.823, -0.956> <-1.132, 1.812, -0.958> <-1.132, 1.808, -0.953> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.088, 1.821, -0.952> <-1.084, 1.816, -0.942> <-1.081, 1.811, -0.924> <-1.083, 1.814, -0.912> 
		<-1.099, 1.812, -0.952> <-1.095, 1.807, -0.942> <-1.093, 1.802, -0.924> <-1.096, 1.804, -0.912> 
		<-1.118, 1.807, -0.953> <-1.119, 1.800, -0.942> <-1.118, 1.795, -0.924> <-1.118, 1.798, -0.913> 
		<-1.132, 1.808, -0.953> <-1.133, 1.802, -0.943> <-1.134, 1.797, -0.925> <-1.134, 1.800, -0.913> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.083, 1.814, -0.912> <-1.085, 1.816, -0.905> <-1.095, 1.828, -0.900> <-1.097, 1.831, -0.906> 
		<-1.096, 1.804, -0.912> <-1.097, 1.806, -0.906> <-1.103, 1.822, -0.900> <-1.105, 1.825, -0.906> 
		<-1.118, 1.798, -0.913> <-1.118, 1.800, -0.906> <-1.121, 1.817, -0.901> <-1.121, 1.821, -0.906> 
		<-1.134, 1.800, -0.913> <-1.134, 1.802, -0.906> <-1.132, 1.818, -0.901> <-1.131, 1.822, -0.906> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.097, 1.831, -0.906> <-1.102, 1.838, -0.918> <-1.100, 1.836, -0.940> <-1.101, 1.838, -0.954> 
		<-1.105, 1.825, -0.906> <-1.111, 1.832, -0.918> <-1.107, 1.831, -0.940> <-1.108, 1.833, -0.954> 
		<-1.121, 1.821, -0.906> <-1.119, 1.829, -0.918> <-1.121, 1.827, -0.940> <-1.121, 1.829, -0.955> 
		<-1.131, 1.822, -0.906> <-1.130, 1.831, -0.918> <-1.130, 1.828, -0.940> <-1.130, 1.830, -0.955> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.085, 1.864, -0.956> <-1.079, 1.863, -0.954> <-1.068, 1.862, -0.957> <-1.065, 1.861, -0.951> 
		<-1.086, 1.854, -0.956> <-1.080, 1.854, -0.955> <-1.070, 1.848, -0.957> <-1.067, 1.847, -0.952> 
		<-1.093, 1.842, -0.956> <-1.089, 1.838, -0.955> <-1.079, 1.832, -0.957> <-1.077, 1.829, -0.952> 
		<-1.100, 1.837, -0.956> <-1.096, 1.832, -0.955> <-1.090, 1.823, -0.957> <-1.088, 1.821, -0.952> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.065, 1.861, -0.951> <-1.059, 1.860, -0.941> <-1.054, 1.859, -0.923> <-1.058, 1.860, -0.911> 
		<-1.067, 1.847, -0.952> <-1.060, 1.846, -0.941> <-1.056, 1.844, -0.923> <-1.059, 1.844, -0.911> 
		<-1.077, 1.829, -0.952> <-1.073, 1.824, -0.942> <-1.069, 1.821, -0.923> <-1.071, 1.824, -0.912> 
		<-1.088, 1.821, -0.952> <-1.084, 1.816, -0.942> <-1.081, 1.811, -0.924> <-1.083, 1.814, -0.912> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.058, 1.860, -0.911> <-1.060, 1.860, -0.905> <-1.076, 1.862, -0.900> <-1.080, 1.862, -0.905> 
		<-1.059, 1.844, -0.911> <-1.062, 1.844, -0.905> <-1.077, 1.851, -0.900> <-1.081, 1.852, -0.905> 
		<-1.071, 1.824, -0.912> <-1.072, 1.825, -0.905> <-1.086, 1.835, -0.900> <-1.089, 1.838, -0.906> 
		<-1.083, 1.814, -0.912> <-1.085, 1.816, -0.905> <-1.095, 1.828, -0.900> <-1.097, 1.831, -0.906> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.080, 1.862, -0.905> <-1.088, 1.863, -0.917> <-1.085, 1.863, -0.939> <-1.087, 1.864, -0.954> 
		<-1.081, 1.852, -0.905> <-1.089, 1.853, -0.917> <-1.086, 1.855, -0.939> <-1.088, 1.855, -0.954> 
		<-1.089, 1.838, -0.906> <-1.094, 1.845, -0.918> <-1.093, 1.842, -0.940> <-1.094, 1.844, -0.954> 
		<-1.097, 1.831, -0.906> <-1.102, 1.838, -0.918> <-1.100, 1.836, -0.940> <-1.101, 1.838, -0.954> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.093, 1.893, -0.955> <-1.088, 1.897, -0.954> <-1.080, 1.904, -0.956> <-1.077, 1.906, -0.951> 
		<-1.087, 1.886, -0.955> <-1.083, 1.890, -0.954> <-1.071, 1.893, -0.956> <-1.069, 1.895, -0.951> 
		<-1.084, 1.873, -0.956> <-1.078, 1.872, -0.954> <-1.067, 1.875, -0.956> <-1.063, 1.875, -0.951> 
		<-1.085, 1.864, -0.956> <-1.079, 1.863, -0.954> <-1.068, 1.862, -0.957> <-1.065, 1.861, -0.951> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.077, 1.906, -0.951> <-1.072, 1.910, -0.941> <-1.069, 1.912, -0.922> <-1.072, 1.910, -0.911> 
		<-1.069, 1.895, -0.951> <-1.064, 1.899, -0.941> <-1.059, 1.900, -0.922> <-1.062, 1.898, -0.911> 
		<-1.063, 1.875, -0.951> <-1.057, 1.874, -0.941> <-1.052, 1.875, -0.923> <-1.056, 1.875, -0.911> 
		<-1.065, 1.861, -0.951> <-1.059, 1.860, -0.941> <-1.054, 1.859, -0.923> <-1.058, 1.860, -0.911> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.072, 1.910, -0.911> <-1.073, 1.909, -0.904> <-1.086, 1.899, -0.899> <-1.089, 1.896, -0.905> 
		<-1.062, 1.898, -0.911> <-1.064, 1.896, -0.904> <-1.079, 1.890, -0.899> <-1.083, 1.888, -0.905> 
		<-1.056, 1.875, -0.911> <-1.058, 1.875, -0.904> <-1.074, 1.872, -0.900> <-1.078, 1.873, -0.905> 
		<-1.058, 1.860, -0.911> <-1.060, 1.860, -0.905> <-1.076, 1.862, -0.900> <-1.080, 1.862, -0.905> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.089, 1.896, -0.905> <-1.096, 1.891, -0.917> <-1.093, 1.893, -0.939> <-1.095, 1.892, -0.953> 
		<-1.083, 1.888, -0.905> <-1.089, 1.883, -0.917> <-1.088, 1.886, -0.939> <-1.089, 1.885, -0.953> 
		<-1.078, 1.873, -0.905> <-1.087, 1.874, -0.917> <-1.084, 1.872, -0.939> <-1.086, 1.872, -0.954> 
		<-1.080, 1.862, -0.905> <-1.088, 1.863, -0.917> <-1.085, 1.863, -0.939> <-1.087, 1.864, -0.954> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.120, 1.908, -0.956> <-1.119, 1.914, -0.954> <-1.118, 1.925, -0.957> <-1.118, 1.928, -0.951> 
		<-1.111, 1.907, -0.956> <-1.110, 1.913, -0.954> <-1.104, 1.923, -0.956> <-1.104, 1.927, -0.951> 
		<-1.099, 1.900, -0.955> <-1.094, 1.904, -0.954> <-1.088, 1.915, -0.956> <-1.086, 1.916, -0.951> 
		<-1.093, 1.893, -0.955> <-1.088, 1.897, -0.954> <-1.080, 1.904, -0.956> <-1.077, 1.906, -0.951> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.118, 1.928, -0.951> <-1.117, 1.935, -0.941> <-1.117, 1.940, -0.923> <-1.117, 1.936, -0.911> 
		<-1.104, 1.927, -0.951> <-1.103, 1.933, -0.941> <-1.101, 1.938, -0.923> <-1.102, 1.934, -0.911> 
		<-1.086, 1.916, -0.951> <-1.081, 1.920, -0.941> <-1.078, 1.925, -0.922> <-1.081, 1.922, -0.911> 
		<-1.077, 1.906, -0.951> <-1.072, 1.910, -0.941> <-1.069, 1.912, -0.922> <-1.072, 1.910, -0.911> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.117, 1.936, -0.911> <-1.117, 1.934, -0.905> <-1.119, 1.918, -0.900> <-1.120, 1.914, -0.905> 
		<-1.102, 1.934, -0.911> <-1.102, 1.932, -0.904> <-1.109, 1.916, -0.900> <-1.109, 1.913, -0.905> 
		<-1.081, 1.922, -0.911> <-1.083, 1.921, -0.904> <-1.093, 1.907, -0.899> <-1.096, 1.905, -0.905> 
		<-1.072, 1.910, -0.911> <-1.073, 1.909, -0.904> <-1.086, 1.899, -0.899> <-1.089, 1.896, -0.905> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.120, 1.914, -0.905> <-1.121, 1.905, -0.917> <-1.120, 1.909, -0.939> <-1.120, 1.906, -0.954> 
		<-1.109, 1.913, -0.905> <-1.110, 1.904, -0.917> <-1.111, 1.908, -0.939> <-1.112, 1.905, -0.954> 
		<-1.096, 1.905, -0.905> <-1.102, 1.900, -0.917> <-1.098, 1.900, -0.939> <-1.100, 1.899, -0.953> 
		<-1.089, 1.896, -0.905> <-1.096, 1.891, -0.917> <-1.093, 1.893, -0.939> <-1.095, 1.892, -0.953> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.087, 1.200, -0.835> <-2.086, 1.202, -0.824> <-2.088, 1.199, -0.803> <-2.083, 1.207, -0.797> 
		<-2.099, 1.212, -0.835> <-2.098, 1.214, -0.824> <-2.106, 1.216, -0.803> <-2.100, 1.224, -0.797> 
		<-2.115, 1.227, -0.846> <-2.119, 1.234, -0.838> <-2.126, 1.237, -0.817> <-2.124, 1.248, -0.813> 
		<-2.123, 1.234, -0.858> <-2.127, 1.242, -0.850> <-2.138, 1.248, -0.835> <-2.136, 1.259, -0.831> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.083, 1.207, -0.797> <-2.074, 1.223, -0.785> <-2.057, 1.250, -0.776> <-2.047, 1.268, -0.784> 
		<-2.100, 1.224, -0.797> <-2.091, 1.240, -0.785> <-2.077, 1.270, -0.776> <-2.067, 1.287, -0.784> 
		<-2.124, 1.248, -0.813> <-2.121, 1.268, -0.805> <-2.108, 1.298, -0.796> <-2.094, 1.313, -0.802> 
		<-2.136, 1.259, -0.831> <-2.133, 1.279, -0.823> <-2.122, 1.311, -0.817> <-2.107, 1.326, -0.823> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.047, 1.268, -0.784> <-2.041, 1.278, -0.789> <-2.037, 1.284, -0.819> <-2.042, 1.275, -0.827> 
		<-2.067, 1.287, -0.784> <-2.060, 1.298, -0.789> <-2.050, 1.298, -0.819> <-2.055, 1.289, -0.827> 
		<-2.094, 1.313, -0.802> <-2.085, 1.322, -0.805> <-2.072, 1.317, -0.835> <-2.074, 1.306, -0.839> 
		<-2.107, 1.326, -0.823> <-2.099, 1.334, -0.826> <-2.081, 1.326, -0.849> <-2.083, 1.315, -0.853> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.042, 1.275, -0.827> <-2.053, 1.258, -0.842> <-2.073, 1.225, -0.836> <-2.086, 1.203, -0.839> 
		<-2.055, 1.289, -0.827> <-2.066, 1.271, -0.842> <-2.084, 1.236, -0.836> <-2.097, 1.214, -0.839> 
		<-2.074, 1.306, -0.839> <-2.077, 1.282, -0.850> <-2.101, 1.252, -0.847> <-2.112, 1.229, -0.850> 
		<-2.083, 1.315, -0.853> <-2.086, 1.291, -0.864> <-2.108, 1.259, -0.859> <-2.119, 1.236, -0.861> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.053, 1.165, -0.858> <-2.046, 1.161, -0.850> <-2.040, 1.148, -0.835> <-2.031, 1.154, -0.831> 
		<-2.060, 1.173, -0.846> <-2.054, 1.169, -0.838> <-2.051, 1.160, -0.817> <-2.043, 1.166, -0.813> 
		<-2.076, 1.189, -0.835> <-2.075, 1.191, -0.824> <-2.071, 1.181, -0.803> <-2.066, 1.190, -0.797> 
		<-2.087, 1.200, -0.835> <-2.086, 1.202, -0.824> <-2.088, 1.199, -0.803> <-2.083, 1.207, -0.797> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.031, 1.154, -0.831> <-2.016, 1.164, -0.822> <-1.995, 1.188, -0.817> <-1.988, 1.207, -0.823> 
		<-2.043, 1.166, -0.813> <-2.027, 1.176, -0.804> <-2.008, 1.202, -0.797> <-2.001, 1.221, -0.802> 
		<-2.066, 1.190, -0.797> <-2.057, 1.205, -0.785> <-2.038, 1.231, -0.776> <-2.027, 1.248, -0.784> 
		<-2.083, 1.207, -0.797> <-2.074, 1.223, -0.785> <-2.057, 1.250, -0.776> <-2.047, 1.268, -0.784> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.988, 1.207, -0.823> <-1.984, 1.219, -0.826> <-1.992, 1.240, -0.847> <-2.002, 1.234, -0.853> 
		<-2.001, 1.221, -0.802> <-1.997, 1.233, -0.805> <-2.001, 1.250, -0.833> <-2.011, 1.244, -0.839> 
		<-2.027, 1.248, -0.784> <-2.021, 1.258, -0.789> <-2.023, 1.271, -0.819> <-2.029, 1.262, -0.827> 
		<-2.047, 1.268, -0.784> <-2.041, 1.278, -0.789> <-2.037, 1.284, -0.819> <-2.042, 1.275, -0.827> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.002, 1.234, -0.853> <-2.022, 1.223, -0.865> <-2.038, 1.189, -0.859> <-2.053, 1.169, -0.861> 
		<-2.011, 1.244, -0.839> <-2.030, 1.232, -0.851> <-2.045, 1.196, -0.847> <-2.060, 1.177, -0.850> 
		<-2.029, 1.262, -0.827> <-2.040, 1.244, -0.842> <-2.062, 1.214, -0.836> <-2.075, 1.192, -0.839> 
		<-2.042, 1.275, -0.827> <-2.053, 1.258, -0.842> <-2.073, 1.225, -0.836> <-2.086, 1.203, -0.839> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.039, 1.149, -0.913> <-2.031, 1.143, -0.913> <-2.020, 1.126, -0.913> <-2.011, 1.130, -0.914> 
		<-2.039, 1.149, -0.896> <-2.030, 1.143, -0.896> <-2.020, 1.127, -0.887> <-2.010, 1.130, -0.887> 
		<-2.045, 1.156, -0.871> <-2.038, 1.153, -0.863> <-2.027, 1.135, -0.855> <-2.019, 1.141, -0.851> 
		<-2.053, 1.165, -0.858> <-2.046, 1.161, -0.850> <-2.040, 1.148, -0.835> <-2.031, 1.154, -0.831> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.011, 1.130, -0.914> <-1.992, 1.138, -0.914> <-1.971, 1.160, -0.916> <-1.965, 1.180, -0.916> 
		<-2.010, 1.130, -0.887> <-1.992, 1.138, -0.888> <-1.970, 1.161, -0.885> <-1.965, 1.181, -0.886> 
		<-2.019, 1.141, -0.851> <-2.003, 1.151, -0.842> <-1.981, 1.173, -0.840> <-1.974, 1.192, -0.845> 
		<-2.031, 1.154, -0.831> <-2.016, 1.164, -0.822> <-1.995, 1.188, -0.817> <-1.988, 1.207, -0.823> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.965, 1.180, -0.916> <-1.962, 1.192, -0.917> <-1.975, 1.220, -0.917> <-1.987, 1.216, -0.917> 
		<-1.965, 1.181, -0.886> <-1.961, 1.193, -0.887> <-1.975, 1.221, -0.897> <-1.987, 1.217, -0.896> 
		<-1.974, 1.192, -0.845> <-1.970, 1.204, -0.848> <-1.983, 1.230, -0.862> <-1.993, 1.224, -0.868> 
		<-1.988, 1.207, -0.823> <-1.984, 1.219, -0.826> <-1.992, 1.240, -0.847> <-2.002, 1.234, -0.853> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.987, 1.216, -0.917> <-2.010, 1.208, -0.916> <-2.024, 1.173, -0.914> <-2.040, 1.154, -0.913> 
		<-1.987, 1.217, -0.896> <-2.010, 1.209, -0.895> <-2.024, 1.173, -0.898> <-2.040, 1.154, -0.897> 
		<-1.993, 1.224, -0.868> <-2.012, 1.213, -0.880> <-2.030, 1.180, -0.871> <-2.045, 1.161, -0.874> 
		<-2.002, 1.234, -0.853> <-2.022, 1.223, -0.865> <-2.038, 1.189, -0.859> <-2.053, 1.169, -0.861> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.055, 1.161, -0.968> <-2.048, 1.158, -0.977> <-2.042, 1.144, -0.991> <-2.034, 1.149, -0.996> 
		<-2.046, 1.154, -0.955> <-2.040, 1.150, -0.964> <-2.029, 1.132, -0.971> <-2.021, 1.137, -0.976> 
		<-2.039, 1.148, -0.931> <-2.031, 1.142, -0.931> <-2.021, 1.125, -0.940> <-2.011, 1.129, -0.940> 
		<-2.039, 1.149, -0.913> <-2.031, 1.143, -0.913> <-2.020, 1.126, -0.913> <-2.011, 1.130, -0.914> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.034, 1.149, -0.996> <-2.019, 1.159, -1.006> <-1.998, 1.183, -1.014> <-1.991, 1.202, -1.010> 
		<-2.021, 1.137, -0.976> <-2.006, 1.147, -0.987> <-1.984, 1.169, -0.991> <-1.977, 1.188, -0.988> 
		<-2.011, 1.129, -0.940> <-1.993, 1.137, -0.941> <-1.971, 1.159, -0.945> <-1.966, 1.179, -0.946> 
		<-2.011, 1.130, -0.914> <-1.992, 1.138, -0.914> <-1.971, 1.160, -0.916> <-1.965, 1.180, -0.916> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.991, 1.202, -1.010> <-1.987, 1.214, -1.008> <-1.995, 1.236, -0.987> <-2.004, 1.231, -0.980> 
		<-1.977, 1.188, -0.988> <-1.972, 1.200, -0.985> <-1.985, 1.227, -0.972> <-1.995, 1.222, -0.965> 
		<-1.966, 1.179, -0.946> <-1.962, 1.191, -0.947> <-1.975, 1.220, -0.937> <-1.987, 1.215, -0.937> 
		<-1.965, 1.180, -0.916> <-1.962, 1.192, -0.917> <-1.975, 1.220, -0.917> <-1.987, 1.216, -0.917> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.004, 1.231, -0.980> <-2.023, 1.221, -0.967> <-2.039, 1.186, -0.970> <-2.054, 1.166, -0.966> 
		<-1.995, 1.222, -0.965> <-2.013, 1.211, -0.952> <-2.031, 1.178, -0.958> <-2.046, 1.159, -0.953> 
		<-1.987, 1.215, -0.937> <-2.010, 1.207, -0.936> <-2.024, 1.172, -0.931> <-2.040, 1.154, -0.930> 
		<-1.987, 1.216, -0.917> <-2.010, 1.208, -0.916> <-2.024, 1.173, -0.914> <-2.040, 1.154, -0.913> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.090, 1.196, -0.991> <-2.089, 1.197, -1.003> <-2.092, 1.193, -1.023> <-2.087, 1.201, -1.031> 
		<-2.078, 1.184, -0.991> <-2.077, 1.186, -1.003> <-2.074, 1.175, -1.023> <-2.070, 1.184, -1.031> 
		<-2.062, 1.169, -0.981> <-2.056, 1.165, -0.989> <-2.054, 1.155, -1.009> <-2.046, 1.160, -1.014> 
		<-2.055, 1.161, -0.968> <-2.048, 1.158, -0.977> <-2.042, 1.144, -0.991> <-2.034, 1.149, -0.996> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.087, 1.201, -1.031> <-2.078, 1.215, -1.044> <-2.062, 1.243, -1.055> <-2.051, 1.260, -1.049> 
		<-2.070, 1.184, -1.031> <-2.061, 1.198, -1.044> <-2.042, 1.223, -1.055> <-2.032, 1.241, -1.049> 
		<-2.046, 1.160, -1.014> <-2.030, 1.170, -1.025> <-2.011, 1.195, -1.034> <-2.005, 1.214, -1.031> 
		<-2.034, 1.149, -0.996> <-2.019, 1.159, -1.006> <-1.998, 1.183, -1.014> <-1.991, 1.202, -1.010> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.051, 1.260, -1.049> <-2.045, 1.271, -1.045> <-2.040, 1.279, -1.015> <-2.045, 1.270, -1.006> 
		<-2.032, 1.241, -1.049> <-2.025, 1.252, -1.045> <-2.027, 1.266, -1.015> <-2.032, 1.257, -1.006> 
		<-2.005, 1.214, -1.031> <-2.000, 1.227, -1.028> <-2.004, 1.245, -1.001> <-2.014, 1.239, -0.994> 
		<-1.991, 1.202, -1.010> <-1.987, 1.214, -1.008> <-1.995, 1.236, -0.987> <-2.004, 1.231, -0.980> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.045, 1.270, -1.006> <-2.055, 1.254, -0.990> <-2.075, 1.220, -0.993> <-2.088, 1.199, -0.988> 
		<-2.032, 1.257, -1.006> <-2.042, 1.241, -0.990> <-2.064, 1.209, -0.993> <-2.077, 1.188, -0.988> 
		<-2.014, 1.239, -0.994> <-2.032, 1.229, -0.981> <-2.047, 1.193, -0.982> <-2.062, 1.173, -0.977> 
		<-2.004, 1.231, -0.980> <-2.023, 1.221, -0.967> <-2.039, 1.186, -0.970> <-2.054, 1.166, -0.966> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.124, 1.231, -0.968> <-2.129, 1.238, -0.977> <-2.140, 1.244, -0.991> <-2.139, 1.254, -0.996> 
		<-2.117, 1.223, -0.981> <-2.121, 1.230, -0.989> <-2.129, 1.232, -1.010> <-2.127, 1.242, -1.015> 
		<-2.101, 1.207, -0.991> <-2.101, 1.209, -1.003> <-2.109, 1.210, -1.023> <-2.104, 1.218, -1.031> 
		<-2.090, 1.196, -0.991> <-2.089, 1.197, -1.003> <-2.092, 1.193, -1.023> <-2.087, 1.201, -1.031> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.139, 1.254, -0.996> <-2.135, 1.274, -1.006> <-2.125, 1.305, -1.015> <-2.110, 1.321, -1.010> 
		<-2.127, 1.242, -1.015> <-2.124, 1.262, -1.024> <-2.112, 1.291, -1.035> <-2.097, 1.307, -1.031> 
		<-2.104, 1.218, -1.031> <-2.095, 1.233, -1.044> <-2.081, 1.262, -1.055> <-2.071, 1.280, -1.049> 
		<-2.087, 1.201, -1.031> <-2.078, 1.215, -1.044> <-2.062, 1.243, -1.055> <-2.051, 1.260, -1.049> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.110, 1.321, -1.010> <-2.102, 1.329, -1.008> <-2.084, 1.322, -0.986> <-2.085, 1.311, -0.980> 
		<-2.097, 1.307, -1.031> <-2.089, 1.316, -1.028> <-2.075, 1.313, -0.999> <-2.076, 1.302, -0.994> 
		<-2.071, 1.280, -1.049> <-2.064, 1.291, -1.045> <-2.053, 1.292, -1.015> <-2.058, 1.284, -1.006> 
		<-2.051, 1.260, -1.049> <-2.045, 1.271, -1.045> <-2.040, 1.279, -1.015> <-2.045, 1.270, -1.006> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.085, 1.311, -0.980> <-2.088, 1.288, -0.968> <-2.110, 1.256, -0.970> <-2.121, 1.233, -0.966> 
		<-2.076, 1.302, -0.994> <-2.079, 1.279, -0.982> <-2.103, 1.249, -0.982> <-2.114, 1.225, -0.977> 
		<-2.058, 1.284, -1.006> <-2.068, 1.267, -0.990> <-2.086, 1.231, -0.993> <-2.099, 1.210, -0.988> 
		<-2.045, 1.270, -1.006> <-2.055, 1.254, -0.990> <-2.075, 1.220, -0.993> <-2.088, 1.199, -0.988> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.138, 1.247, -0.913> <-2.144, 1.257, -0.913> <-2.160, 1.267, -0.913> <-2.159, 1.278, -0.914> 
		<-2.138, 1.247, -0.931> <-2.145, 1.256, -0.931> <-2.160, 1.266, -0.940> <-2.160, 1.277, -0.940> 
		<-2.133, 1.240, -0.955> <-2.137, 1.247, -0.964> <-2.153, 1.257, -0.972> <-2.151, 1.267, -0.977> 
		<-2.124, 1.231, -0.968> <-2.129, 1.238, -0.977> <-2.140, 1.244, -0.991> <-2.139, 1.254, -0.996> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.159, 1.278, -0.914> <-2.158, 1.301, -0.914> <-2.150, 1.333, -0.916> <-2.133, 1.348, -0.916> 
		<-2.160, 1.277, -0.940> <-2.158, 1.300, -0.941> <-2.150, 1.332, -0.946> <-2.134, 1.347, -0.946> 
		<-2.151, 1.267, -0.977> <-2.148, 1.287, -0.986> <-2.139, 1.320, -0.992> <-2.124, 1.336, -0.988> 
		<-2.139, 1.254, -0.996> <-2.135, 1.274, -1.006> <-2.125, 1.305, -1.015> <-2.110, 1.321, -1.010> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.133, 1.348, -0.916> <-2.125, 1.355, -0.917> <-2.100, 1.341, -0.917> <-2.100, 1.330, -0.917> 
		<-2.134, 1.347, -0.946> <-2.125, 1.355, -0.947> <-2.101, 1.340, -0.937> <-2.101, 1.329, -0.937> 
		<-2.124, 1.336, -0.988> <-2.116, 1.344, -0.985> <-2.093, 1.332, -0.970> <-2.094, 1.321, -0.965> 
		<-2.110, 1.321, -1.010> <-2.102, 1.329, -1.008> <-2.084, 1.322, -0.986> <-2.085, 1.311, -0.980> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.100, 1.330, -0.917> <-2.101, 1.303, -0.916> <-2.124, 1.273, -0.915> <-2.134, 1.248, -0.914> 
		<-2.101, 1.329, -0.937> <-2.101, 1.303, -0.936> <-2.124, 1.272, -0.931> <-2.134, 1.248, -0.930> 
		<-2.094, 1.321, -0.965> <-2.097, 1.298, -0.953> <-2.118, 1.265, -0.958> <-2.129, 1.241, -0.953> 
		<-2.085, 1.311, -0.980> <-2.088, 1.288, -0.968> <-2.110, 1.256, -0.970> <-2.121, 1.233, -0.966> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.123, 1.234, -0.858> <-2.127, 1.242, -0.850> <-2.138, 1.248, -0.835> <-2.136, 1.259, -0.831> 
		<-2.131, 1.242, -0.871> <-2.135, 1.250, -0.863> <-2.151, 1.260, -0.855> <-2.149, 1.271, -0.851> 
		<-2.138, 1.248, -0.896> <-2.144, 1.257, -0.896> <-2.159, 1.268, -0.887> <-2.159, 1.279, -0.887> 
		<-2.138, 1.247, -0.913> <-2.144, 1.257, -0.913> <-2.160, 1.267, -0.913> <-2.159, 1.278, -0.914> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.136, 1.259, -0.831> <-2.133, 1.279, -0.823> <-2.122, 1.311, -0.817> <-2.107, 1.326, -0.823> 
		<-2.149, 1.271, -0.851> <-2.145, 1.291, -0.843> <-2.136, 1.324, -0.839> <-2.122, 1.340, -0.845> 
		<-2.159, 1.279, -0.887> <-2.158, 1.301, -0.888> <-2.149, 1.334, -0.886> <-2.133, 1.349, -0.887> 
		<-2.159, 1.278, -0.914> <-2.158, 1.301, -0.914> <-2.150, 1.333, -0.916> <-2.133, 1.348, -0.916> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.107, 1.326, -0.823> <-2.099, 1.334, -0.826> <-2.081, 1.326, -0.849> <-2.083, 1.315, -0.853> 
		<-2.122, 1.340, -0.845> <-2.113, 1.348, -0.848> <-2.091, 1.335, -0.864> <-2.093, 1.324, -0.869> 
		<-2.133, 1.349, -0.887> <-2.124, 1.356, -0.887> <-2.100, 1.342, -0.897> <-2.100, 1.330, -0.897> 
		<-2.133, 1.348, -0.916> <-2.125, 1.355, -0.917> <-2.100, 1.341, -0.917> <-2.100, 1.330, -0.917> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.083, 1.315, -0.853> <-2.086, 1.291, -0.864> <-2.108, 1.259, -0.859> <-2.119, 1.236, -0.861> 
		<-2.093, 1.324, -0.869> <-2.096, 1.300, -0.879> <-2.116, 1.267, -0.871> <-2.127, 1.243, -0.874> 
		<-2.100, 1.330, -0.897> <-2.100, 1.304, -0.896> <-2.124, 1.273, -0.898> <-2.133, 1.248, -0.897> 
		<-2.100, 1.330, -0.917> <-2.101, 1.303, -0.916> <-2.124, 1.273, -0.915> <-2.134, 1.248, -0.914> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.172, 1.937, -0.837> <-1.170, 1.938, -0.825> <-1.174, 1.936, -0.805> <-1.165, 1.939, -0.798> 
		<-1.174, 1.953, -0.836> <-1.172, 1.954, -0.825> <-1.177, 1.960, -0.804> <-1.168, 1.963, -0.797> 
		<-1.177, 1.976, -0.846> <-1.176, 1.984, -0.838> <-1.180, 1.990, -0.817> <-1.172, 1.997, -0.812> 
		<-1.178, 1.987, -0.858> <-1.177, 1.995, -0.850> <-1.182, 2.006, -0.835> <-1.174, 2.013, -0.830> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.165, 1.939, -0.798> <-1.148, 1.945, -0.786> <-1.118, 1.957, -0.776> <-1.099, 1.964, -0.783> 
		<-1.168, 1.963, -0.797> <-1.151, 1.969, -0.785> <-1.122, 1.984, -0.775> <-1.103, 1.991, -0.782> 
		<-1.172, 1.997, -0.812> <-1.157, 2.010, -0.804> <-1.129, 2.026, -0.794> <-1.108, 2.029, -0.799> 
		<-1.174, 2.013, -0.830> <-1.159, 2.027, -0.822> <-1.131, 2.045, -0.814> <-1.110, 2.048, -0.820> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.099, 1.964, -0.783> <-1.088, 1.969, -0.787> <-1.080, 1.972, -0.818> <-1.090, 1.969, -0.826> 
		<-1.103, 1.991, -0.782> <-1.091, 1.996, -0.787> <-1.083, 1.991, -0.817> <-1.092, 1.987, -0.826> 
		<-1.108, 2.029, -0.799> <-1.096, 2.031, -0.803> <-1.088, 2.020, -0.832> <-1.096, 2.013, -0.837> 
		<-1.110, 2.048, -0.820> <-1.098, 2.050, -0.823> <-1.089, 2.033, -0.846> <-1.097, 2.025, -0.851> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.090, 1.969, -0.826> <-1.109, 1.962, -0.842> <-1.145, 1.948, -0.836> <-1.169, 1.939, -0.841> 
		<-1.092, 1.987, -0.826> <-1.111, 1.980, -0.841> <-1.147, 1.963, -0.836> <-1.171, 1.954, -0.840> 
		<-1.096, 2.013, -0.837> <-1.113, 1.996, -0.848> <-1.150, 1.987, -0.847> <-1.173, 1.975, -0.850> 
		<-1.097, 2.025, -0.851> <-1.114, 2.009, -0.862> <-1.151, 1.998, -0.858> <-1.175, 1.986, -0.861> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.166, 1.889, -0.861> <-1.163, 1.882, -0.853> <-1.166, 1.867, -0.839> <-1.156, 1.866, -0.834> 
		<-1.167, 1.899, -0.848> <-1.164, 1.892, -0.840> <-1.168, 1.883, -0.820> <-1.158, 1.882, -0.815> 
		<-1.170, 1.921, -0.837> <-1.168, 1.922, -0.826> <-1.171, 1.911, -0.805> <-1.162, 1.915, -0.799> 
		<-1.172, 1.937, -0.837> <-1.170, 1.938, -0.825> <-1.174, 1.936, -0.805> <-1.165, 1.939, -0.798> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.156, 1.866, -0.834> <-1.138, 1.864, -0.825> <-1.107, 1.870, -0.820> <-1.090, 1.881, -0.824> 
		<-1.158, 1.882, -0.815> <-1.139, 1.880, -0.806> <-1.109, 1.888, -0.798> <-1.092, 1.899, -0.803> 
		<-1.162, 1.915, -0.799> <-1.145, 1.921, -0.786> <-1.115, 1.929, -0.777> <-1.096, 1.936, -0.784> 
		<-1.165, 1.939, -0.798> <-1.148, 1.945, -0.786> <-1.118, 1.957, -0.776> <-1.099, 1.964, -0.783> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.090, 1.881, -0.824> <-1.079, 1.888, -0.827> <-1.072, 1.911, -0.848> <-1.084, 1.913, -0.854> 
		<-1.092, 1.899, -0.803> <-1.081, 1.906, -0.806> <-1.074, 1.923, -0.833> <-1.085, 1.925, -0.840> 
		<-1.096, 1.936, -0.784> <-1.084, 1.941, -0.788> <-1.078, 1.953, -0.818> <-1.088, 1.950, -0.827> 
		<-1.099, 1.964, -0.783> <-1.088, 1.969, -0.787> <-1.080, 1.972, -0.818> <-1.090, 1.969, -0.826> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.084, 1.913, -0.854> <-1.105, 1.916, -0.865> <-1.139, 1.898, -0.861> <-1.163, 1.892, -0.864> 
		<-1.085, 1.925, -0.840> <-1.107, 1.928, -0.851> <-1.140, 1.909, -0.849> <-1.164, 1.902, -0.852> 
		<-1.088, 1.950, -0.827> <-1.107, 1.943, -0.842> <-1.143, 1.932, -0.837> <-1.167, 1.923, -0.841> 
		<-1.090, 1.969, -0.826> <-1.109, 1.962, -0.842> <-1.145, 1.948, -0.836> <-1.169, 1.939, -0.841> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.164, 1.869, -0.917> <-1.161, 1.860, -0.917> <-1.163, 1.840, -0.917> <-1.153, 1.837, -0.918> 
		<-1.164, 1.869, -0.899> <-1.161, 1.859, -0.899> <-1.163, 1.839, -0.891> <-1.153, 1.837, -0.891> 
		<-1.165, 1.877, -0.874> <-1.162, 1.870, -0.866> <-1.164, 1.850, -0.859> <-1.154, 1.849, -0.854> 
		<-1.166, 1.889, -0.861> <-1.163, 1.882, -0.853> <-1.166, 1.867, -0.839> <-1.156, 1.866, -0.834> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.153, 1.837, -0.918> <-1.134, 1.832, -0.918> <-1.103, 1.836, -0.919> <-1.087, 1.848, -0.919> 
		<-1.153, 1.837, -0.891> <-1.134, 1.831, -0.892> <-1.103, 1.836, -0.889> <-1.086, 1.848, -0.889> 
		<-1.154, 1.849, -0.854> <-1.136, 1.847, -0.845> <-1.105, 1.851, -0.842> <-1.088, 1.862, -0.847> 
		<-1.156, 1.866, -0.834> <-1.138, 1.864, -0.825> <-1.107, 1.870, -0.820> <-1.090, 1.881, -0.824> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.087, 1.848, -0.919> <-1.076, 1.856, -0.919> <-1.069, 1.886, -0.918> <-1.081, 1.890, -0.918> 
		<-1.086, 1.848, -0.889> <-1.076, 1.855, -0.889> <-1.069, 1.886, -0.898> <-1.081, 1.890, -0.898> 
		<-1.088, 1.862, -0.847> <-1.077, 1.869, -0.850> <-1.071, 1.898, -0.863> <-1.082, 1.899, -0.869> 
		<-1.090, 1.881, -0.824> <-1.079, 1.888, -0.827> <-1.072, 1.911, -0.848> <-1.084, 1.913, -0.854> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.081, 1.890, -0.918> <-1.105, 1.898, -0.917> <-1.137, 1.879, -0.917> <-1.161, 1.874, -0.917> 
		<-1.081, 1.890, -0.898> <-1.104, 1.898, -0.897> <-1.137, 1.879, -0.900> <-1.161, 1.874, -0.900> 
		<-1.082, 1.899, -0.869> <-1.104, 1.903, -0.881> <-1.138, 1.888, -0.873> <-1.162, 1.882, -0.876> 
		<-1.084, 1.913, -0.854> <-1.105, 1.916, -0.865> <-1.139, 1.898, -0.861> <-1.163, 1.892, -0.864> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.167, 1.891, -0.971> <-1.165, 1.884, -0.980> <-1.168, 1.870, -0.994> <-1.158, 1.869, -0.999> 
		<-1.166, 1.879, -0.958> <-1.163, 1.872, -0.967> <-1.165, 1.852, -0.975> <-1.156, 1.851, -0.980> 
		<-1.164, 1.870, -0.934> <-1.161, 1.860, -0.934> <-1.164, 1.840, -0.944> <-1.154, 1.838, -0.944> 
		<-1.164, 1.869, -0.917> <-1.161, 1.860, -0.917> <-1.163, 1.840, -0.917> <-1.153, 1.837, -0.918> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.158, 1.869, -0.999> <-1.140, 1.868, -1.009> <-1.109, 1.874, -1.016> <-1.092, 1.885, -1.012> 
		<-1.156, 1.851, -0.980> <-1.138, 1.850, -0.990> <-1.106, 1.854, -0.994> <-1.089, 1.864, -0.990> 
		<-1.154, 1.838, -0.944> <-1.134, 1.832, -0.945> <-1.103, 1.837, -0.949> <-1.087, 1.849, -0.949> 
		<-1.153, 1.837, -0.918> <-1.134, 1.832, -0.918> <-1.103, 1.836, -0.919> <-1.087, 1.848, -0.919> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.092, 1.885, -1.012> <-1.081, 1.891, -1.009> <-1.074, 1.913, -0.987> <-1.085, 1.915, -0.981> 
		<-1.089, 1.864, -0.990> <-1.078, 1.871, -0.987> <-1.072, 1.900, -0.973> <-1.083, 1.901, -0.966> 
		<-1.087, 1.849, -0.949> <-1.077, 1.857, -0.949> <-1.070, 1.887, -0.938> <-1.082, 1.891, -0.938> 
		<-1.087, 1.848, -0.919> <-1.076, 1.856, -0.919> <-1.069, 1.886, -0.918> <-1.081, 1.890, -0.918> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.085, 1.915, -0.981> <-1.106, 1.918, -0.968> <-1.141, 1.900, -0.972> <-1.164, 1.894, -0.968> 
		<-1.083, 1.901, -0.966> <-1.104, 1.904, -0.953> <-1.139, 1.889, -0.960> <-1.163, 1.883, -0.956> 
		<-1.082, 1.891, -0.938> <-1.105, 1.899, -0.937> <-1.138, 1.879, -0.934> <-1.162, 1.874, -0.933> 
		<-1.081, 1.890, -0.918> <-1.105, 1.898, -0.917> <-1.137, 1.879, -0.917> <-1.161, 1.874, -0.917> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.174, 1.940, -0.993> <-1.172, 1.941, -1.004> <-1.176, 1.940, -1.025> <-1.168, 1.943, -1.032> 
		<-1.172, 1.924, -0.993> <-1.170, 1.925, -1.005> <-1.173, 1.916, -1.025> <-1.165, 1.919, -1.032> 
		<-1.169, 1.902, -0.983> <-1.166, 1.895, -0.992> <-1.170, 1.886, -1.012> <-1.160, 1.886, -1.017> 
		<-1.167, 1.891, -0.971> <-1.165, 1.884, -0.980> <-1.168, 1.870, -0.994> <-1.158, 1.869, -0.999> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.168, 1.943, -1.032> <-1.151, 1.950, -1.044> <-1.122, 1.962, -1.055> <-1.102, 1.969, -1.048> 
		<-1.165, 1.919, -1.032> <-1.148, 1.926, -1.045> <-1.118, 1.934, -1.056> <-1.099, 1.941, -1.049> 
		<-1.160, 1.886, -1.017> <-1.142, 1.884, -1.027> <-1.111, 1.893, -1.036> <-1.094, 1.903, -1.032> 
		<-1.158, 1.869, -0.999> <-1.140, 1.868, -1.009> <-1.109, 1.874, -1.016> <-1.092, 1.885, -1.012> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.102, 1.969, -1.048> <-1.091, 1.973, -1.044> <-1.083, 1.976, -1.014> <-1.092, 1.972, -1.005> 
		<-1.099, 1.941, -1.049> <-1.087, 1.946, -1.045> <-1.080, 1.957, -1.014> <-1.090, 1.953, -1.006> 
		<-1.094, 1.903, -1.032> <-1.083, 1.910, -1.029> <-1.075, 1.926, -1.001> <-1.087, 1.928, -0.994> 
		<-1.092, 1.885, -1.012> <-1.081, 1.891, -1.009> <-1.074, 1.913, -0.987> <-1.085, 1.915, -0.981> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.092, 1.972, -1.005> <-1.111, 1.964, -0.989> <-1.147, 1.950, -0.994> <-1.170, 1.941, -0.989> 
		<-1.090, 1.953, -1.006> <-1.108, 1.946, -0.990> <-1.145, 1.935, -0.994> <-1.168, 1.926, -0.989> 
		<-1.087, 1.928, -0.994> <-1.108, 1.930, -0.982> <-1.142, 1.911, -0.983> <-1.166, 1.905, -0.980> 
		<-1.085, 1.915, -0.981> <-1.106, 1.918, -0.968> <-1.141, 1.900, -0.972> <-1.164, 1.894, -0.968> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.179, 1.989, -0.968> <-1.178, 1.997, -0.977> <-1.184, 2.009, -0.991> <-1.176, 2.016, -0.995> 
		<-1.178, 1.978, -0.981> <-1.177, 1.986, -0.989> <-1.182, 1.993, -1.010> <-1.174, 2.000, -1.014> 
		<-1.176, 1.956, -0.992> <-1.174, 1.957, -1.004> <-1.179, 1.964, -1.024> <-1.170, 1.968, -1.031> 
		<-1.174, 1.940, -0.993> <-1.172, 1.941, -1.004> <-1.176, 1.940, -1.025> <-1.168, 1.943, -1.032> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.176, 2.016, -0.995> <-1.161, 2.030, -1.004> <-1.134, 2.048, -1.012> <-1.112, 2.051, -1.007> 
		<-1.174, 2.000, -1.014> <-1.159, 2.014, -1.023> <-1.132, 2.030, -1.033> <-1.110, 2.033, -1.028> 
		<-1.170, 1.968, -1.031> <-1.154, 1.974, -1.044> <-1.125, 1.989, -1.054> <-1.106, 1.996, -1.047> 
		<-1.168, 1.943, -1.032> <-1.151, 1.950, -1.044> <-1.122, 1.962, -1.055> <-1.102, 1.969, -1.048> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.112, 2.051, -1.007> <-1.101, 2.053, -1.004> <-1.091, 2.036, -0.983> <-1.099, 2.028, -0.978> 
		<-1.110, 2.033, -1.028> <-1.099, 2.035, -1.025> <-1.090, 2.023, -0.997> <-1.097, 2.016, -0.992> 
		<-1.106, 1.996, -1.047> <-1.094, 2.001, -1.043> <-1.085, 1.994, -1.013> <-1.094, 1.990, -1.005> 
		<-1.102, 1.969, -1.048> <-1.091, 1.973, -1.044> <-1.083, 1.976, -1.014> <-1.092, 1.972, -1.005> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.099, 2.028, -0.978> <-1.116, 2.011, -0.967> <-1.153, 2.000, -0.969> <-1.176, 1.988, -0.966> 
		<-1.097, 2.016, -0.992> <-1.114, 1.999, -0.981> <-1.152, 1.990, -0.981> <-1.175, 1.977, -0.978> 
		<-1.094, 1.990, -1.005> <-1.113, 1.983, -0.989> <-1.149, 1.966, -0.993> <-1.172, 1.957, -0.988> 
		<-1.092, 1.972, -1.005> <-1.111, 1.964, -0.989> <-1.147, 1.950, -0.994> <-1.170, 1.941, -0.989> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.181, 2.008, -0.913> <-1.181, 2.019, -0.913> <-1.186, 2.037, -0.912> <-1.179, 2.045, -0.912> 
		<-1.181, 2.008, -0.931> <-1.181, 2.020, -0.930> <-1.187, 2.037, -0.939> <-1.179, 2.046, -0.938> 
		<-1.181, 2.000, -0.955> <-1.180, 2.008, -0.963> <-1.186, 2.026, -0.971> <-1.178, 2.033, -0.975> 
		<-1.179, 1.989, -0.968> <-1.178, 1.997, -0.977> <-1.184, 2.009, -0.991> <-1.176, 2.016, -0.995> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.179, 2.045, -0.912> <-1.164, 2.062, -0.912> <-1.138, 2.083, -0.912> <-1.115, 2.084, -0.912> 
		<-1.179, 2.046, -0.938> <-1.165, 2.063, -0.938> <-1.138, 2.084, -0.942> <-1.116, 2.085, -0.942> 
		<-1.178, 2.033, -0.975> <-1.163, 2.047, -0.984> <-1.136, 2.068, -0.989> <-1.114, 2.071, -0.984> 
		<-1.176, 2.016, -0.995> <-1.161, 2.030, -1.004> <-1.134, 2.048, -1.012> <-1.112, 2.051, -1.007> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.115, 2.084, -0.912> <-1.104, 2.085, -0.913> <-1.094, 2.059, -0.913> <-1.101, 2.050, -0.914> 
		<-1.116, 2.085, -0.942> <-1.105, 2.086, -0.943> <-1.094, 2.059, -0.934> <-1.101, 2.050, -0.934> 
		<-1.114, 2.071, -0.984> <-1.103, 2.073, -0.981> <-1.093, 2.049, -0.967> <-1.100, 2.041, -0.962> 
		<-1.112, 2.051, -1.007> <-1.101, 2.053, -1.004> <-1.091, 2.036, -0.983> <-1.099, 2.028, -0.978> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.101, 2.050, -0.914> <-1.117, 2.029, -0.914> <-1.155, 2.019, -0.913> <-1.178, 2.006, -0.913> 
		<-1.101, 2.050, -0.934> <-1.118, 2.030, -0.934> <-1.155, 2.019, -0.930> <-1.178, 2.006, -0.930> 
		<-1.100, 2.041, -0.962> <-1.117, 2.024, -0.951> <-1.154, 2.010, -0.957> <-1.177, 1.998, -0.953> 
		<-1.099, 2.028, -0.978> <-1.116, 2.011, -0.967> <-1.153, 2.000, -0.969> <-1.176, 1.988, -0.966> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.178, 1.987, -0.858> <-1.177, 1.995, -0.850> <-1.182, 2.006, -0.835> <-1.174, 2.013, -0.830> 
		<-1.180, 1.999, -0.871> <-1.179, 2.007, -0.863> <-1.185, 2.024, -0.854> <-1.177, 2.031, -0.849> 
		<-1.181, 2.008, -0.895> <-1.180, 2.019, -0.895> <-1.186, 2.036, -0.886> <-1.179, 2.045, -0.886> 
		<-1.181, 2.008, -0.913> <-1.181, 2.019, -0.913> <-1.186, 2.037, -0.912> <-1.179, 2.045, -0.912> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.174, 2.013, -0.830> <-1.159, 2.027, -0.822> <-1.131, 2.045, -0.814> <-1.110, 2.048, -0.820> 
		<-1.177, 2.031, -0.849> <-1.162, 2.045, -0.841> <-1.134, 2.065, -0.836> <-1.113, 2.068, -0.841> 
		<-1.179, 2.045, -0.886> <-1.164, 2.062, -0.885> <-1.137, 2.082, -0.882> <-1.115, 2.084, -0.882> 
		<-1.179, 2.045, -0.912> <-1.164, 2.062, -0.912> <-1.138, 2.083, -0.912> <-1.115, 2.084, -0.912> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.110, 2.048, -0.820> <-1.098, 2.050, -0.823> <-1.089, 2.033, -0.846> <-1.097, 2.025, -0.851> 
		<-1.113, 2.068, -0.841> <-1.101, 2.070, -0.845> <-1.091, 2.047, -0.860> <-1.099, 2.039, -0.866> 
		<-1.115, 2.084, -0.882> <-1.104, 2.084, -0.883> <-1.094, 2.058, -0.893> <-1.101, 2.050, -0.893> 
		<-1.115, 2.084, -0.912> <-1.104, 2.085, -0.913> <-1.094, 2.059, -0.913> <-1.101, 2.050, -0.914> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.097, 2.025, -0.851> <-1.114, 2.009, -0.862> <-1.151, 1.998, -0.858> <-1.175, 1.986, -0.861> 
		<-1.099, 2.039, -0.866> <-1.116, 2.023, -0.877> <-1.153, 2.009, -0.870> <-1.176, 1.997, -0.873> 
		<-1.101, 2.050, -0.893> <-1.117, 2.029, -0.893> <-1.154, 2.019, -0.896> <-1.177, 2.006, -0.896> 
		<-1.101, 2.050, -0.914> <-1.117, 2.029, -0.914> <-1.155, 2.019, -0.913> <-1.178, 2.006, -0.913> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.190, 2.636, -2.327> <-0.183, 2.589, -2.326> <-0.146, 2.554, -2.350> <-0.109, 2.560, -2.380> 
		<-0.307, 2.616, -2.475> <-0.300, 2.569, -2.474> <-0.263, 2.535, -2.498> <-0.226, 2.540, -2.528> 
		<-0.462, 2.590, -2.672> <-0.455, 2.543, -2.671> <-0.418, 2.508, -2.696> <-0.382, 2.514, -2.725> 
		<-0.579, 2.570, -2.820> <-0.572, 2.523, -2.819> <-0.535, 2.489, -2.844> <-0.498, 2.494, -2.873> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.109, 2.560, -2.380> <-0.073, 2.565, -2.410> <-0.048, 2.609, -2.435> <-0.055, 2.656, -2.436> 
		<-0.226, 2.540, -2.528> <-0.189, 2.545, -2.558> <-0.165, 2.589, -2.583> <-0.172, 2.636, -2.584> 
		<-0.382, 2.514, -2.725> <-0.345, 2.519, -2.755> <-0.320, 2.563, -2.780> <-0.327, 2.610, -2.781> 
		<-0.498, 2.494, -2.873> <-0.461, 2.499, -2.903> <-0.437, 2.543, -2.928> <-0.444, 2.590, -2.929> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.055, 2.656, -2.436> <-0.062, 2.703, -2.436> <-0.099, 2.737, -2.412> <-0.136, 2.732, -2.382> 
		<-0.172, 2.636, -2.584> <-0.179, 2.683, -2.584> <-0.216, 2.718, -2.560> <-0.253, 2.712, -2.530> 
		<-0.327, 2.610, -2.781> <-0.335, 2.657, -2.781> <-0.371, 2.691, -2.757> <-0.408, 2.686, -2.727> 
		<-0.444, 2.590, -2.929> <-0.451, 2.637, -2.929> <-0.488, 2.672, -2.905> <-0.525, 2.666, -2.875> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.525, 2.666, -2.875> <-0.562, 2.661, -2.846> <-0.586, 2.618, -2.820> <-0.579, 2.570, -2.820> 
		<-0.408, 2.686, -2.727> <-0.445, 2.681, -2.698> <-0.470, 2.637, -2.672> <-0.462, 2.590, -2.672> 
		<-0.253, 2.712, -2.530> <-0.289, 2.707, -2.500> <-0.314, 2.663, -2.475> <-0.307, 2.616, -2.475> 
		<-0.136, 2.732, -2.382> <-0.173, 2.727, -2.352> <-0.197, 2.683, -2.327> <-0.190, 2.636, -2.327> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.384, 2.595, -2.680> <-0.382, 2.584, -2.680> <-0.374, 2.575, -2.686> <-0.365, 2.576, -2.693> 
		<-0.501, 2.575, -2.828> <-0.499, 2.564, -2.828> <-0.490, 2.556, -2.834> <-0.481, 2.557, -2.841> 
		<-0.656, 2.549, -3.026> <-0.655, 2.538, -3.026> <-0.646, 2.529, -3.031> <-0.637, 2.530, -3.038> 
		<-0.773, 2.529, -3.174> <-0.771, 2.518, -3.173> <-0.763, 2.510, -3.179> <-0.754, 2.511, -3.186> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.365, 2.576, -2.693> <-0.356, 2.578, -2.700> <-0.350, 2.588, -2.706> <-0.352, 2.600, -2.707> 
		<-0.481, 2.557, -2.841> <-0.473, 2.558, -2.848> <-0.467, 2.569, -2.854> <-0.468, 2.580, -2.855> 
		<-0.637, 2.530, -3.038> <-0.628, 2.532, -3.046> <-0.622, 2.542, -3.052> <-0.624, 2.554, -3.052> 
		<-0.754, 2.511, -3.186> <-0.745, 2.512, -3.194> <-0.739, 2.523, -3.200> <-0.741, 2.534, -3.200> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.352, 2.600, -2.707> <-0.354, 2.611, -2.707> <-0.362, 2.619, -2.701> <-0.371, 2.618, -2.694> 
		<-0.468, 2.580, -2.855> <-0.470, 2.591, -2.855> <-0.479, 2.599, -2.849> <-0.488, 2.598, -2.842> 
		<-0.624, 2.554, -3.052> <-0.626, 2.565, -3.052> <-0.635, 2.573, -3.046> <-0.643, 2.572, -3.039> 
		<-0.741, 2.534, -3.200> <-0.742, 2.545, -3.200> <-0.751, 2.553, -3.194> <-0.760, 2.552, -3.187> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.760, 2.552, -3.187> <-0.769, 2.551, -3.180> <-0.775, 2.540, -3.174> <-0.773, 2.529, -3.174> 
		<-0.643, 2.572, -3.039> <-0.652, 2.571, -3.032> <-0.658, 2.560, -3.026> <-0.656, 2.549, -3.026> 
		<-0.488, 2.598, -2.842> <-0.497, 2.597, -2.835> <-0.503, 2.586, -2.829> <-0.501, 2.575, -2.828> 
		<-0.371, 2.618, -2.694> <-0.380, 2.617, -2.687> <-0.386, 2.606, -2.681> <-0.384, 2.595, -2.680> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.547, 2.601, -2.914> <-0.547, 2.607, -2.913> <-0.550, 2.617, -2.915> <-0.547, 2.621, -2.911> 
		<-0.540, 2.602, -2.920> <-0.540, 2.608, -2.919> <-0.539, 2.619, -2.924> <-0.537, 2.622, -2.920> 
		<-0.529, 2.598, -2.928> <-0.526, 2.603, -2.930> <-0.525, 2.614, -2.934> <-0.521, 2.617, -2.932> 
		<-0.523, 2.592, -2.932> <-0.520, 2.597, -2.934> <-0.516, 2.605, -2.940> <-0.512, 2.608, -2.938> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.547, 2.621, -2.911> <-0.542, 2.628, -2.903> <-0.532, 2.635, -2.889> <-0.524, 2.633, -2.880> 
		<-0.537, 2.622, -2.920> <-0.531, 2.630, -2.912> <-0.519, 2.637, -2.899> <-0.512, 2.635, -2.890> 
		<-0.521, 2.617, -2.932> <-0.511, 2.623, -2.927> <-0.499, 2.630, -2.914> <-0.494, 2.628, -2.903> 
		<-0.512, 2.608, -2.938> <-0.502, 2.614, -2.933> <-0.489, 2.620, -2.921> <-0.483, 2.619, -2.910> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.524, 2.633, -2.880> <-0.519, 2.632, -2.875> <-0.514, 2.616, -2.871> <-0.517, 2.612, -2.875> 
		<-0.512, 2.635, -2.890> <-0.507, 2.633, -2.885> <-0.506, 2.617, -2.877> <-0.508, 2.613, -2.882> 
		<-0.494, 2.628, -2.903> <-0.490, 2.627, -2.897> <-0.491, 2.612, -2.888> <-0.496, 2.609, -2.891> 
		<-0.483, 2.619, -2.910> <-0.480, 2.618, -2.904> <-0.484, 2.606, -2.893> <-0.489, 2.602, -2.895> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.517, 2.612, -2.875> <-0.523, 2.602, -2.884> <-0.537, 2.603, -2.901> <-0.545, 2.599, -2.913> 
		<-0.508, 2.613, -2.882> <-0.515, 2.603, -2.891> <-0.530, 2.604, -2.907> <-0.538, 2.600, -2.918> 
		<-0.496, 2.609, -2.891> <-0.507, 2.601, -2.896> <-0.518, 2.600, -2.915> <-0.528, 2.596, -2.926> 
		<-0.489, 2.602, -2.895> <-0.500, 2.594, -2.901> <-0.513, 2.594, -2.919> <-0.523, 2.591, -2.929> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.567, 2.586, -2.896> <-0.570, 2.590, -2.893> <-0.579, 2.596, -2.890> <-0.578, 2.599, -2.884> 
		<-0.563, 2.593, -2.900> <-0.566, 2.597, -2.897> <-0.573, 2.607, -2.896> <-0.572, 2.609, -2.891> 
		<-0.554, 2.600, -2.908> <-0.554, 2.606, -2.908> <-0.561, 2.615, -2.907> <-0.558, 2.619, -2.903> 
		<-0.547, 2.601, -2.914> <-0.547, 2.607, -2.913> <-0.550, 2.617, -2.915> <-0.547, 2.621, -2.911> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.578, 2.599, -2.884> <-0.576, 2.604, -2.873> <-0.568, 2.609, -2.857> <-0.558, 2.608, -2.850> 
		<-0.572, 2.609, -2.891> <-0.569, 2.615, -2.880> <-0.561, 2.621, -2.864> <-0.551, 2.620, -2.857> 
		<-0.558, 2.619, -2.903> <-0.553, 2.627, -2.895> <-0.544, 2.634, -2.879> <-0.536, 2.631, -2.870> 
		<-0.547, 2.621, -2.911> <-0.542, 2.628, -2.903> <-0.532, 2.635, -2.889> <-0.524, 2.633, -2.880> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.558, 2.608, -2.850> <-0.553, 2.607, -2.845> <-0.539, 2.598, -2.848> <-0.540, 2.595, -2.854> 
		<-0.551, 2.620, -2.857> <-0.546, 2.619, -2.852> <-0.534, 2.606, -2.853> <-0.535, 2.603, -2.859> 
		<-0.536, 2.631, -2.870> <-0.532, 2.630, -2.865> <-0.522, 2.615, -2.864> <-0.525, 2.611, -2.868> 
		<-0.524, 2.633, -2.880> <-0.519, 2.632, -2.875> <-0.514, 2.616, -2.871> <-0.517, 2.612, -2.875> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.540, 2.595, -2.854> <-0.542, 2.588, -2.867> <-0.557, 2.588, -2.883> <-0.564, 2.585, -2.896> 
		<-0.535, 2.603, -2.859> <-0.537, 2.596, -2.872> <-0.553, 2.595, -2.887> <-0.561, 2.592, -2.900> 
		<-0.525, 2.611, -2.868> <-0.531, 2.601, -2.878> <-0.543, 2.602, -2.896> <-0.552, 2.598, -2.907> 
		<-0.517, 2.612, -2.875> <-0.523, 2.602, -2.884> <-0.537, 2.603, -2.901> <-0.545, 2.599, -2.913> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.572, 2.556, -2.889> <-0.576, 2.556, -2.884> <-0.585, 2.554, -2.879> <-0.585, 2.554, -2.873> 
		<-0.573, 2.565, -2.889> <-0.577, 2.565, -2.884> <-0.588, 2.568, -2.879> <-0.587, 2.568, -2.873> 
		<-0.571, 2.579, -2.892> <-0.574, 2.582, -2.889> <-0.585, 2.585, -2.884> <-0.584, 2.588, -2.878> 
		<-0.567, 2.586, -2.896> <-0.570, 2.590, -2.893> <-0.579, 2.596, -2.890> <-0.578, 2.599, -2.884> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.585, 2.554, -2.873> <-0.584, 2.555, -2.861> <-0.576, 2.556, -2.843> <-0.566, 2.558, -2.836> 
		<-0.587, 2.568, -2.873> <-0.586, 2.569, -2.861> <-0.579, 2.572, -2.844> <-0.569, 2.573, -2.837> 
		<-0.584, 2.588, -2.878> <-0.582, 2.593, -2.867> <-0.575, 2.597, -2.850> <-0.565, 2.596, -2.842> 
		<-0.578, 2.599, -2.884> <-0.576, 2.604, -2.873> <-0.568, 2.609, -2.857> <-0.558, 2.608, -2.850> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.566, 2.558, -2.836> <-0.561, 2.559, -2.833> <-0.545, 2.561, -2.839> <-0.545, 2.561, -2.846> 
		<-0.569, 2.573, -2.837> <-0.563, 2.574, -2.833> <-0.547, 2.571, -2.839> <-0.547, 2.571, -2.846> 
		<-0.565, 2.596, -2.842> <-0.560, 2.595, -2.838> <-0.544, 2.589, -2.844> <-0.545, 2.586, -2.850> 
		<-0.558, 2.608, -2.850> <-0.553, 2.607, -2.845> <-0.539, 2.598, -2.848> <-0.540, 2.595, -2.854> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.545, 2.561, -2.846> <-0.546, 2.561, -2.860> <-0.562, 2.558, -2.875> <-0.569, 2.557, -2.888> 
		<-0.547, 2.571, -2.846> <-0.548, 2.571, -2.860> <-0.563, 2.567, -2.876> <-0.570, 2.565, -2.888> 
		<-0.545, 2.586, -2.850> <-0.546, 2.580, -2.863> <-0.561, 2.581, -2.879> <-0.568, 2.578, -2.892> 
		<-0.540, 2.595, -2.854> <-0.542, 2.588, -2.867> <-0.557, 2.588, -2.883> <-0.564, 2.585, -2.896> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.558, 2.529, -2.896> <-0.560, 2.525, -2.892> <-0.566, 2.516, -2.889> <-0.565, 2.514, -2.883> 
		<-0.564, 2.535, -2.892> <-0.566, 2.531, -2.888> <-0.575, 2.525, -2.883> <-0.574, 2.523, -2.877> 
		<-0.570, 2.547, -2.889> <-0.574, 2.547, -2.884> <-0.583, 2.541, -2.879> <-0.583, 2.541, -2.873> 
		<-0.572, 2.556, -2.889> <-0.576, 2.556, -2.884> <-0.585, 2.554, -2.879> <-0.585, 2.554, -2.873> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.565, 2.514, -2.883> <-0.561, 2.510, -2.872> <-0.552, 2.508, -2.856> <-0.543, 2.512, -2.848> 
		<-0.574, 2.523, -2.877> <-0.570, 2.519, -2.866> <-0.563, 2.518, -2.849> <-0.554, 2.522, -2.842> 
		<-0.583, 2.541, -2.873> <-0.581, 2.541, -2.861> <-0.574, 2.541, -2.843> <-0.564, 2.542, -2.836> 
		<-0.585, 2.554, -2.873> <-0.584, 2.555, -2.861> <-0.576, 2.556, -2.843> <-0.566, 2.558, -2.836> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.543, 2.512, -2.848> <-0.538, 2.514, -2.844> <-0.528, 2.527, -2.847> <-0.530, 2.530, -2.854> 
		<-0.554, 2.522, -2.842> <-0.549, 2.524, -2.837> <-0.535, 2.534, -2.843> <-0.537, 2.537, -2.849> 
		<-0.564, 2.542, -2.836> <-0.558, 2.543, -2.832> <-0.543, 2.550, -2.839> <-0.544, 2.550, -2.845> 
		<-0.566, 2.558, -2.836> <-0.561, 2.559, -2.833> <-0.545, 2.561, -2.839> <-0.545, 2.561, -2.846> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.530, 2.530, -2.854> <-0.534, 2.535, -2.867> <-0.548, 2.531, -2.883> <-0.556, 2.531, -2.895> 
		<-0.537, 2.537, -2.849> <-0.541, 2.542, -2.862> <-0.554, 2.536, -2.879> <-0.562, 2.537, -2.891> 
		<-0.544, 2.550, -2.845> <-0.545, 2.550, -2.860> <-0.561, 2.549, -2.875> <-0.568, 2.548, -2.888> 
		<-0.545, 2.561, -2.846> <-0.546, 2.561, -2.860> <-0.562, 2.558, -2.875> <-0.569, 2.557, -2.888> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.535, 2.521, -2.913> <-0.533, 2.515, -2.912> <-0.533, 2.504, -2.914> <-0.529, 2.502, -2.910> 
		<-0.542, 2.520, -2.908> <-0.540, 2.514, -2.906> <-0.543, 2.503, -2.905> <-0.540, 2.500, -2.901> 
		<-0.552, 2.524, -2.900> <-0.554, 2.519, -2.896> <-0.557, 2.508, -2.895> <-0.556, 2.506, -2.889> 
		<-0.558, 2.529, -2.896> <-0.560, 2.525, -2.892> <-0.566, 2.516, -2.889> <-0.565, 2.514, -2.883> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.529, 2.502, -2.910> <-0.522, 2.496, -2.902> <-0.510, 2.493, -2.888> <-0.503, 2.498, -2.878> 
		<-0.540, 2.500, -2.901> <-0.532, 2.495, -2.893> <-0.522, 2.491, -2.878> <-0.515, 2.496, -2.869> 
		<-0.556, 2.506, -2.889> <-0.552, 2.502, -2.878> <-0.542, 2.498, -2.863> <-0.533, 2.502, -2.855> 
		<-0.565, 2.514, -2.883> <-0.561, 2.510, -2.872> <-0.552, 2.508, -2.856> <-0.543, 2.512, -2.848> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.503, 2.498, -2.878> <-0.499, 2.500, -2.873> <-0.499, 2.517, -2.870> <-0.503, 2.520, -2.874> 
		<-0.515, 2.496, -2.869> <-0.511, 2.499, -2.863> <-0.507, 2.516, -2.863> <-0.511, 2.519, -2.867> 
		<-0.533, 2.502, -2.855> <-0.528, 2.505, -2.851> <-0.521, 2.521, -2.852> <-0.523, 2.523, -2.858> 
		<-0.543, 2.512, -2.848> <-0.538, 2.514, -2.844> <-0.528, 2.527, -2.847> <-0.530, 2.530, -2.854> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.503, 2.520, -2.874> <-0.511, 2.527, -2.883> <-0.524, 2.522, -2.900> <-0.534, 2.523, -2.912> 
		<-0.511, 2.519, -2.867> <-0.519, 2.526, -2.877> <-0.531, 2.521, -2.895> <-0.540, 2.522, -2.906> 
		<-0.523, 2.523, -2.858> <-0.527, 2.529, -2.871> <-0.543, 2.525, -2.886> <-0.550, 2.526, -2.899> 
		<-0.530, 2.530, -2.854> <-0.534, 2.535, -2.867> <-0.548, 2.531, -2.883> <-0.556, 2.531, -2.895> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.514, 2.536, -2.931> <-0.510, 2.532, -2.933> <-0.504, 2.525, -2.939> <-0.499, 2.524, -2.937> 
		<-0.518, 2.529, -2.927> <-0.514, 2.525, -2.929> <-0.510, 2.514, -2.933> <-0.505, 2.513, -2.931> 
		<-0.527, 2.522, -2.919> <-0.526, 2.516, -2.918> <-0.522, 2.506, -2.923> <-0.518, 2.503, -2.919> 
		<-0.535, 2.521, -2.913> <-0.533, 2.515, -2.912> <-0.533, 2.504, -2.914> <-0.529, 2.502, -2.910> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.499, 2.524, -2.937> <-0.488, 2.521, -2.932> <-0.474, 2.519, -2.920> <-0.469, 2.523, -2.909> 
		<-0.505, 2.513, -2.931> <-0.494, 2.510, -2.925> <-0.480, 2.507, -2.913> <-0.476, 2.511, -2.902> 
		<-0.518, 2.503, -2.919> <-0.511, 2.498, -2.910> <-0.498, 2.495, -2.897> <-0.491, 2.500, -2.888> 
		<-0.529, 2.502, -2.910> <-0.522, 2.496, -2.902> <-0.510, 2.493, -2.888> <-0.503, 2.498, -2.878> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.469, 2.523, -2.909> <-0.466, 2.525, -2.903> <-0.473, 2.535, -2.892> <-0.479, 2.537, -2.895> 
		<-0.476, 2.511, -2.902> <-0.473, 2.513, -2.896> <-0.478, 2.527, -2.887> <-0.484, 2.529, -2.890> 
		<-0.491, 2.500, -2.888> <-0.487, 2.502, -2.883> <-0.490, 2.518, -2.876> <-0.494, 2.521, -2.881> 
		<-0.503, 2.498, -2.878> <-0.499, 2.500, -2.873> <-0.499, 2.517, -2.870> <-0.503, 2.520, -2.874> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.479, 2.537, -2.895> <-0.492, 2.541, -2.900> <-0.504, 2.537, -2.918> <-0.514, 2.537, -2.929> 
		<-0.484, 2.529, -2.890> <-0.497, 2.533, -2.895> <-0.508, 2.530, -2.915> <-0.518, 2.530, -2.925> 
		<-0.494, 2.521, -2.881> <-0.503, 2.529, -2.890> <-0.518, 2.523, -2.906> <-0.527, 2.524, -2.917> 
		<-0.503, 2.520, -2.874> <-0.511, 2.527, -2.883> <-0.524, 2.522, -2.900> <-0.534, 2.523, -2.912> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.510, 2.565, -2.939> <-0.504, 2.566, -2.942> <-0.497, 2.567, -2.950> <-0.491, 2.568, -2.948> 
		<-0.508, 2.556, -2.939> <-0.503, 2.557, -2.942> <-0.495, 2.553, -2.950> <-0.489, 2.554, -2.948> 
		<-0.510, 2.543, -2.935> <-0.506, 2.539, -2.937> <-0.498, 2.536, -2.946> <-0.493, 2.535, -2.943> 
		<-0.514, 2.536, -2.931> <-0.510, 2.532, -2.933> <-0.504, 2.525, -2.939> <-0.499, 2.524, -2.937> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.491, 2.568, -2.948> <-0.480, 2.570, -2.944> <-0.465, 2.572, -2.933> <-0.460, 2.573, -2.922> 
		<-0.489, 2.554, -2.948> <-0.478, 2.556, -2.944> <-0.463, 2.557, -2.933> <-0.458, 2.557, -2.922> 
		<-0.493, 2.535, -2.943> <-0.482, 2.532, -2.938> <-0.467, 2.532, -2.927> <-0.462, 2.535, -2.916> 
		<-0.499, 2.524, -2.937> <-0.488, 2.521, -2.932> <-0.474, 2.519, -2.920> <-0.469, 2.523, -2.909> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.460, 2.573, -2.922> <-0.458, 2.573, -2.916> <-0.467, 2.572, -2.901> <-0.474, 2.571, -2.903> 
		<-0.458, 2.557, -2.922> <-0.456, 2.558, -2.915> <-0.466, 2.562, -2.901> <-0.472, 2.561, -2.903> 
		<-0.462, 2.535, -2.916> <-0.459, 2.537, -2.910> <-0.469, 2.544, -2.897> <-0.475, 2.546, -2.899> 
		<-0.469, 2.523, -2.909> <-0.466, 2.525, -2.903> <-0.473, 2.535, -2.892> <-0.479, 2.537, -2.895> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.474, 2.571, -2.903> <-0.488, 2.569, -2.907> <-0.499, 2.567, -2.926> <-0.510, 2.565, -2.936> 
		<-0.472, 2.561, -2.903> <-0.486, 2.558, -2.907> <-0.498, 2.558, -2.926> <-0.509, 2.557, -2.936> 
		<-0.475, 2.546, -2.899> <-0.488, 2.550, -2.905> <-0.500, 2.544, -2.922> <-0.511, 2.544, -2.933> 
		<-0.479, 2.537, -2.895> <-0.492, 2.541, -2.900> <-0.504, 2.537, -2.918> <-0.514, 2.537, -2.929> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.523, 2.592, -2.932> <-0.520, 2.597, -2.934> <-0.516, 2.605, -2.940> <-0.512, 2.608, -2.938> 
		<-0.517, 2.586, -2.936> <-0.514, 2.591, -2.938> <-0.507, 2.596, -2.946> <-0.503, 2.600, -2.944> 
		<-0.511, 2.574, -2.939> <-0.506, 2.575, -2.942> <-0.499, 2.581, -2.950> <-0.494, 2.582, -2.948> 
		<-0.510, 2.565, -2.939> <-0.504, 2.566, -2.942> <-0.497, 2.567, -2.950> <-0.491, 2.568, -2.948> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.512, 2.608, -2.938> <-0.502, 2.614, -2.933> <-0.489, 2.620, -2.921> <-0.483, 2.619, -2.910> 
		<-0.503, 2.600, -2.944> <-0.493, 2.606, -2.939> <-0.479, 2.610, -2.928> <-0.473, 2.609, -2.917> 
		<-0.494, 2.582, -2.948> <-0.482, 2.583, -2.944> <-0.467, 2.588, -2.934> <-0.463, 2.589, -2.922> 
		<-0.491, 2.568, -2.948> <-0.480, 2.570, -2.944> <-0.465, 2.572, -2.933> <-0.460, 2.573, -2.922> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.483, 2.619, -2.910> <-0.480, 2.618, -2.904> <-0.484, 2.606, -2.893> <-0.489, 2.602, -2.895> 
		<-0.473, 2.609, -2.917> <-0.470, 2.608, -2.911> <-0.477, 2.599, -2.897> <-0.482, 2.595, -2.900> 
		<-0.463, 2.589, -2.922> <-0.460, 2.589, -2.916> <-0.469, 2.583, -2.902> <-0.475, 2.582, -2.904> 
		<-0.460, 2.573, -2.922> <-0.458, 2.573, -2.916> <-0.467, 2.572, -2.901> <-0.474, 2.571, -2.903> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.489, 2.602, -2.895> <-0.500, 2.594, -2.901> <-0.513, 2.594, -2.919> <-0.523, 2.591, -2.929> 
		<-0.482, 2.595, -2.900> <-0.493, 2.588, -2.905> <-0.507, 2.589, -2.923> <-0.517, 2.585, -2.933> 
		<-0.475, 2.582, -2.904> <-0.489, 2.579, -2.908> <-0.500, 2.576, -2.926> <-0.511, 2.574, -2.936> 
		<-0.474, 2.571, -2.903> <-0.488, 2.569, -2.907> <-0.499, 2.567, -2.926> <-0.510, 2.565, -2.936> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.768, 2.570, -3.234> <-0.770, 2.576, -3.233> <-0.769, 2.587, -3.235> <-0.774, 2.589, -3.231> 
		<-0.762, 2.571, -3.226> <-0.764, 2.577, -3.226> <-0.761, 2.588, -3.224> <-0.766, 2.591, -3.220> 
		<-0.754, 2.567, -3.216> <-0.753, 2.572, -3.212> <-0.750, 2.583, -3.210> <-0.753, 2.585, -3.205> 
		<-0.749, 2.561, -3.211> <-0.748, 2.566, -3.207> <-0.743, 2.574, -3.202> <-0.746, 2.576, -3.197> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.774, 2.589, -3.231> <-0.783, 2.595, -3.225> <-0.798, 2.598, -3.214> <-0.807, 2.593, -3.207> 
		<-0.766, 2.591, -3.220> <-0.775, 2.596, -3.214> <-0.789, 2.599, -3.202> <-0.797, 2.594, -3.195> 
		<-0.753, 2.585, -3.205> <-0.759, 2.589, -3.195> <-0.773, 2.592, -3.183> <-0.783, 2.588, -3.177> 
		<-0.746, 2.576, -3.197> <-0.752, 2.580, -3.187> <-0.764, 2.582, -3.174> <-0.775, 2.578, -3.168> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.807, 2.593, -3.207> <-0.812, 2.590, -3.203> <-0.813, 2.574, -3.200> <-0.808, 2.570, -3.203> 
		<-0.797, 2.594, -3.195> <-0.802, 2.592, -3.190> <-0.807, 2.575, -3.191> <-0.802, 2.571, -3.195> 
		<-0.783, 2.588, -3.177> <-0.789, 2.585, -3.174> <-0.795, 2.569, -3.177> <-0.792, 2.567, -3.183> 
		<-0.775, 2.578, -3.168> <-0.780, 2.576, -3.166> <-0.790, 2.563, -3.171> <-0.786, 2.560, -3.177> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.808, 2.570, -3.203> <-0.798, 2.563, -3.210> <-0.781, 2.568, -3.224> <-0.769, 2.568, -3.232> 
		<-0.802, 2.571, -3.195> <-0.791, 2.564, -3.202> <-0.776, 2.569, -3.217> <-0.764, 2.569, -3.225> 
		<-0.792, 2.567, -3.183> <-0.785, 2.562, -3.195> <-0.766, 2.565, -3.206> <-0.756, 2.565, -3.216> 
		<-0.786, 2.560, -3.177> <-0.780, 2.555, -3.189> <-0.762, 2.560, -3.201> <-0.751, 2.559, -3.211> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.783, 2.555, -3.256> <-0.787, 2.559, -3.259> <-0.791, 2.566, -3.266> <-0.797, 2.568, -3.265> 
		<-0.780, 2.563, -3.251> <-0.784, 2.566, -3.254> <-0.787, 2.577, -3.259> <-0.793, 2.578, -3.257> 
		<-0.773, 2.569, -3.241> <-0.775, 2.575, -3.240> <-0.778, 2.585, -3.246> <-0.782, 2.588, -3.242> 
		<-0.768, 2.570, -3.234> <-0.770, 2.576, -3.233> <-0.769, 2.587, -3.235> <-0.774, 2.589, -3.231> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.797, 2.568, -3.265> <-0.809, 2.571, -3.262> <-0.826, 2.572, -3.254> <-0.833, 2.568, -3.245> 
		<-0.793, 2.578, -3.257> <-0.804, 2.581, -3.255> <-0.821, 2.584, -3.246> <-0.828, 2.580, -3.236> 
		<-0.782, 2.588, -3.242> <-0.792, 2.593, -3.236> <-0.808, 2.596, -3.227> <-0.816, 2.591, -3.219> 
		<-0.774, 2.589, -3.231> <-0.783, 2.595, -3.225> <-0.798, 2.598, -3.214> <-0.807, 2.593, -3.207> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.833, 2.568, -3.245> <-0.837, 2.566, -3.240> <-0.832, 2.555, -3.228> <-0.826, 2.553, -3.229> 
		<-0.828, 2.580, -3.236> <-0.832, 2.578, -3.231> <-0.829, 2.564, -3.222> <-0.822, 2.562, -3.223> 
		<-0.816, 2.591, -3.219> <-0.821, 2.588, -3.215> <-0.820, 2.572, -3.208> <-0.815, 2.569, -3.211> 
		<-0.807, 2.593, -3.207> <-0.812, 2.590, -3.203> <-0.813, 2.574, -3.200> <-0.808, 2.570, -3.203> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.826, 2.553, -3.229> <-0.812, 2.549, -3.231> <-0.796, 2.554, -3.246> <-0.784, 2.554, -3.254> 
		<-0.822, 2.562, -3.223> <-0.809, 2.558, -3.225> <-0.794, 2.561, -3.241> <-0.781, 2.561, -3.249> 
		<-0.815, 2.569, -3.211> <-0.804, 2.562, -3.219> <-0.786, 2.568, -3.231> <-0.774, 2.567, -3.239> 
		<-0.808, 2.570, -3.203> <-0.798, 2.563, -3.210> <-0.781, 2.568, -3.224> <-0.769, 2.568, -3.232> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.786, 2.526, -3.265> <-0.791, 2.525, -3.269> <-0.795, 2.524, -3.279> <-0.801, 2.524, -3.279> 
		<-0.787, 2.535, -3.265> <-0.792, 2.534, -3.269> <-0.797, 2.538, -3.279> <-0.803, 2.537, -3.279> 
		<-0.786, 2.548, -3.261> <-0.790, 2.552, -3.264> <-0.796, 2.555, -3.274> <-0.801, 2.557, -3.273> 
		<-0.783, 2.555, -3.256> <-0.787, 2.559, -3.259> <-0.791, 2.566, -3.266> <-0.797, 2.568, -3.265> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.801, 2.524, -3.279> <-0.813, 2.522, -3.277> <-0.831, 2.519, -3.270> <-0.838, 2.518, -3.260> 
		<-0.803, 2.537, -3.279> <-0.815, 2.535, -3.278> <-0.833, 2.535, -3.271> <-0.840, 2.534, -3.261> 
		<-0.801, 2.557, -3.273> <-0.813, 2.560, -3.270> <-0.831, 2.559, -3.263> <-0.838, 2.556, -3.254> 
		<-0.797, 2.568, -3.265> <-0.809, 2.571, -3.262> <-0.826, 2.572, -3.254> <-0.833, 2.568, -3.245> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.838, 2.518, -3.260> <-0.842, 2.518, -3.255> <-0.836, 2.519, -3.239> <-0.829, 2.520, -3.239> 
		<-0.840, 2.534, -3.261> <-0.844, 2.533, -3.255> <-0.837, 2.529, -3.239> <-0.831, 2.530, -3.239> 
		<-0.838, 2.556, -3.254> <-0.842, 2.554, -3.249> <-0.836, 2.547, -3.233> <-0.829, 2.545, -3.235> 
		<-0.833, 2.568, -3.245> <-0.837, 2.566, -3.240> <-0.832, 2.555, -3.228> <-0.826, 2.553, -3.229> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.829, 2.520, -3.239> <-0.815, 2.522, -3.240> <-0.799, 2.524, -3.255> <-0.786, 2.526, -3.262> 
		<-0.831, 2.530, -3.239> <-0.816, 2.532, -3.240> <-0.800, 2.533, -3.255> <-0.788, 2.535, -3.262> 
		<-0.829, 2.545, -3.235> <-0.815, 2.541, -3.237> <-0.799, 2.547, -3.251> <-0.786, 2.547, -3.259> 
		<-0.826, 2.553, -3.229> <-0.812, 2.549, -3.231> <-0.796, 2.554, -3.246> <-0.784, 2.554, -3.254> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.775, 2.499, -3.255> <-0.777, 2.494, -3.258> <-0.779, 2.486, -3.265> <-0.784, 2.483, -3.264> 
		<-0.779, 2.505, -3.261> <-0.782, 2.500, -3.263> <-0.786, 2.495, -3.273> <-0.791, 2.492, -3.272> 
		<-0.785, 2.517, -3.265> <-0.789, 2.516, -3.269> <-0.793, 2.511, -3.279> <-0.799, 2.510, -3.278> 
		<-0.786, 2.526, -3.265> <-0.791, 2.525, -3.269> <-0.795, 2.524, -3.279> <-0.801, 2.524, -3.279> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.784, 2.483, -3.264> <-0.794, 2.477, -3.261> <-0.810, 2.471, -3.253> <-0.818, 2.472, -3.244> 
		<-0.791, 2.492, -3.272> <-0.802, 2.486, -3.269> <-0.818, 2.481, -3.262> <-0.827, 2.482, -3.253> 
		<-0.799, 2.510, -3.278> <-0.811, 2.508, -3.277> <-0.828, 2.504, -3.270> <-0.835, 2.503, -3.260> 
		<-0.801, 2.524, -3.279> <-0.813, 2.522, -3.277> <-0.831, 2.519, -3.270> <-0.838, 2.518, -3.260> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.818, 2.472, -3.244> <-0.823, 2.473, -3.239> <-0.822, 2.485, -3.227> <-0.816, 2.489, -3.228> 
		<-0.827, 2.482, -3.253> <-0.831, 2.483, -3.248> <-0.827, 2.492, -3.233> <-0.822, 2.495, -3.234> 
		<-0.835, 2.503, -3.260> <-0.839, 2.502, -3.255> <-0.834, 2.508, -3.239> <-0.827, 2.509, -3.239> 
		<-0.838, 2.518, -3.260> <-0.842, 2.518, -3.255> <-0.836, 2.519, -3.239> <-0.829, 2.520, -3.239> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.816, 2.489, -3.228> <-0.804, 2.497, -3.231> <-0.788, 2.497, -3.246> <-0.775, 2.500, -3.253> 
		<-0.822, 2.495, -3.234> <-0.809, 2.503, -3.237> <-0.792, 2.502, -3.251> <-0.780, 2.506, -3.258> 
		<-0.827, 2.509, -3.239> <-0.813, 2.511, -3.240> <-0.798, 2.515, -3.255> <-0.785, 2.517, -3.262> 
		<-0.829, 2.520, -3.239> <-0.815, 2.522, -3.240> <-0.799, 2.524, -3.255> <-0.786, 2.526, -3.262> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.756, 2.490, -3.233> <-0.756, 2.484, -3.232> <-0.752, 2.474, -3.233> <-0.756, 2.470, -3.230> 
		<-0.761, 2.489, -3.240> <-0.761, 2.483, -3.239> <-0.760, 2.472, -3.244> <-0.764, 2.469, -3.241> 
		<-0.770, 2.493, -3.250> <-0.772, 2.489, -3.253> <-0.772, 2.478, -3.258> <-0.777, 2.474, -3.256> 
		<-0.775, 2.499, -3.255> <-0.777, 2.494, -3.258> <-0.779, 2.486, -3.265> <-0.784, 2.483, -3.264> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.756, 2.470, -3.230> <-0.763, 2.462, -3.224> <-0.776, 2.455, -3.213> <-0.786, 2.458, -3.205> 
		<-0.764, 2.469, -3.241> <-0.771, 2.461, -3.235> <-0.786, 2.454, -3.225> <-0.795, 2.456, -3.218> 
		<-0.777, 2.474, -3.256> <-0.787, 2.468, -3.253> <-0.802, 2.461, -3.244> <-0.810, 2.463, -3.235> 
		<-0.784, 2.483, -3.264> <-0.794, 2.477, -3.261> <-0.810, 2.471, -3.253> <-0.818, 2.472, -3.244> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.786, 2.458, -3.205> <-0.791, 2.459, -3.201> <-0.798, 2.474, -3.198> <-0.794, 2.479, -3.202> 
		<-0.795, 2.456, -3.218> <-0.801, 2.457, -3.214> <-0.804, 2.473, -3.207> <-0.801, 2.478, -3.210> 
		<-0.810, 2.463, -3.235> <-0.814, 2.463, -3.230> <-0.816, 2.478, -3.221> <-0.810, 2.482, -3.222> 
		<-0.818, 2.472, -3.244> <-0.823, 2.473, -3.239> <-0.822, 2.485, -3.227> <-0.816, 2.489, -3.228> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.794, 2.479, -3.202> <-0.786, 2.489, -3.209> <-0.768, 2.488, -3.223> <-0.757, 2.492, -3.232> 
		<-0.801, 2.478, -3.210> <-0.792, 2.487, -3.218> <-0.774, 2.487, -3.230> <-0.763, 2.491, -3.238> 
		<-0.810, 2.482, -3.222> <-0.798, 2.490, -3.225> <-0.783, 2.491, -3.241> <-0.771, 2.495, -3.248> 
		<-0.816, 2.489, -3.228> <-0.804, 2.497, -3.231> <-0.788, 2.497, -3.246> <-0.775, 2.500, -3.253> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.740, 2.505, -3.210> <-0.738, 2.501, -3.206> <-0.730, 2.495, -3.201> <-0.733, 2.492, -3.196> 
		<-0.743, 2.498, -3.215> <-0.741, 2.494, -3.211> <-0.735, 2.484, -3.209> <-0.737, 2.481, -3.204> 
		<-0.750, 2.491, -3.225> <-0.750, 2.485, -3.225> <-0.744, 2.475, -3.222> <-0.747, 2.471, -3.219> 
		<-0.756, 2.490, -3.233> <-0.756, 2.484, -3.232> <-0.752, 2.474, -3.233> <-0.756, 2.470, -3.230> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.733, 2.492, -3.196> <-0.737, 2.487, -3.186> <-0.749, 2.481, -3.172> <-0.760, 2.482, -3.167> 
		<-0.737, 2.481, -3.204> <-0.742, 2.476, -3.194> <-0.754, 2.469, -3.181> <-0.765, 2.470, -3.176> 
		<-0.747, 2.471, -3.219> <-0.754, 2.464, -3.213> <-0.767, 2.457, -3.200> <-0.777, 2.459, -3.193> 
		<-0.756, 2.470, -3.230> <-0.763, 2.462, -3.224> <-0.776, 2.455, -3.213> <-0.786, 2.458, -3.205> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.760, 2.482, -3.167> <-0.766, 2.483, -3.164> <-0.779, 2.492, -3.170> <-0.776, 2.495, -3.176> 
		<-0.765, 2.470, -3.176> <-0.771, 2.471, -3.173> <-0.782, 2.484, -3.176> <-0.780, 2.487, -3.182> 
		<-0.777, 2.459, -3.193> <-0.782, 2.460, -3.189> <-0.791, 2.475, -3.190> <-0.788, 2.480, -3.194> 
		<-0.786, 2.458, -3.205> <-0.791, 2.459, -3.201> <-0.798, 2.474, -3.198> <-0.794, 2.479, -3.202> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.776, 2.495, -3.176> <-0.772, 2.502, -3.188> <-0.753, 2.503, -3.200> <-0.743, 2.506, -3.210> 
		<-0.780, 2.487, -3.182> <-0.775, 2.494, -3.194> <-0.756, 2.496, -3.205> <-0.746, 2.499, -3.215> 
		<-0.788, 2.480, -3.194> <-0.780, 2.490, -3.201> <-0.763, 2.489, -3.216> <-0.752, 2.493, -3.225> 
		<-0.794, 2.479, -3.202> <-0.786, 2.489, -3.209> <-0.768, 2.488, -3.223> <-0.757, 2.492, -3.232> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.737, 2.534, -3.201> <-0.735, 2.535, -3.196> <-0.726, 2.536, -3.189> <-0.729, 2.536, -3.183> 
		<-0.736, 2.525, -3.201> <-0.733, 2.526, -3.196> <-0.724, 2.522, -3.189> <-0.726, 2.522, -3.183> 
		<-0.737, 2.512, -3.205> <-0.735, 2.508, -3.201> <-0.726, 2.505, -3.194> <-0.728, 2.503, -3.189> 
		<-0.740, 2.505, -3.210> <-0.738, 2.501, -3.206> <-0.730, 2.495, -3.201> <-0.733, 2.492, -3.196> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.729, 2.536, -3.183> <-0.733, 2.535, -3.171> <-0.744, 2.534, -3.156> <-0.755, 2.532, -3.152> 
		<-0.726, 2.522, -3.183> <-0.731, 2.522, -3.171> <-0.741, 2.518, -3.156> <-0.753, 2.517, -3.152> 
		<-0.728, 2.503, -3.189> <-0.733, 2.497, -3.179> <-0.744, 2.493, -3.164> <-0.755, 2.494, -3.159> 
		<-0.733, 2.492, -3.196> <-0.737, 2.487, -3.186> <-0.749, 2.481, -3.172> <-0.760, 2.482, -3.167> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.755, 2.532, -3.152> <-0.762, 2.531, -3.150> <-0.775, 2.529, -3.159> <-0.773, 2.529, -3.166> 
		<-0.753, 2.517, -3.152> <-0.759, 2.516, -3.149> <-0.774, 2.518, -3.159> <-0.772, 2.519, -3.166> 
		<-0.755, 2.494, -3.159> <-0.761, 2.495, -3.156> <-0.775, 2.501, -3.165> <-0.773, 2.504, -3.170> 
		<-0.760, 2.482, -3.167> <-0.766, 2.483, -3.164> <-0.779, 2.492, -3.170> <-0.776, 2.495, -3.176> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.773, 2.529, -3.166> <-0.769, 2.530, -3.180> <-0.750, 2.532, -3.191> <-0.740, 2.534, -3.202> 
		<-0.772, 2.519, -3.166> <-0.767, 2.519, -3.180> <-0.749, 2.524, -3.191> <-0.739, 2.525, -3.202> 
		<-0.773, 2.504, -3.170> <-0.768, 2.510, -3.182> <-0.750, 2.510, -3.195> <-0.740, 2.513, -3.205> 
		<-0.776, 2.495, -3.176> <-0.772, 2.502, -3.188> <-0.753, 2.503, -3.200> <-0.743, 2.506, -3.210> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.749, 2.561, -3.211> <-0.748, 2.566, -3.207> <-0.743, 2.574, -3.202> <-0.746, 2.576, -3.197> 
		<-0.744, 2.555, -3.206> <-0.743, 2.560, -3.202> <-0.735, 2.566, -3.195> <-0.738, 2.568, -3.190> 
		<-0.739, 2.543, -3.201> <-0.736, 2.544, -3.196> <-0.729, 2.550, -3.189> <-0.731, 2.550, -3.183> 
		<-0.737, 2.534, -3.201> <-0.735, 2.535, -3.196> <-0.726, 2.536, -3.189> <-0.729, 2.536, -3.183> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.746, 2.576, -3.197> <-0.752, 2.580, -3.187> <-0.764, 2.582, -3.174> <-0.775, 2.578, -3.168> 
		<-0.738, 2.568, -3.190> <-0.744, 2.571, -3.180> <-0.756, 2.572, -3.165> <-0.766, 2.568, -3.160> 
		<-0.731, 2.550, -3.183> <-0.735, 2.549, -3.172> <-0.746, 2.549, -3.157> <-0.758, 2.548, -3.152> 
		<-0.729, 2.536, -3.183> <-0.733, 2.535, -3.171> <-0.744, 2.534, -3.156> <-0.755, 2.532, -3.152> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.775, 2.578, -3.168> <-0.780, 2.576, -3.166> <-0.790, 2.563, -3.171> <-0.786, 2.560, -3.177> 
		<-0.766, 2.568, -3.160> <-0.772, 2.566, -3.157> <-0.784, 2.556, -3.165> <-0.781, 2.554, -3.171> 
		<-0.758, 2.548, -3.152> <-0.764, 2.547, -3.150> <-0.777, 2.539, -3.159> <-0.775, 2.540, -3.166> 
		<-0.755, 2.532, -3.152> <-0.762, 2.531, -3.150> <-0.775, 2.529, -3.159> <-0.773, 2.529, -3.166> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.786, 2.560, -3.177> <-0.780, 2.555, -3.189> <-0.762, 2.560, -3.201> <-0.751, 2.559, -3.211> 
		<-0.781, 2.554, -3.171> <-0.774, 2.548, -3.183> <-0.757, 2.554, -3.196> <-0.746, 2.554, -3.206> 
		<-0.775, 2.540, -3.166> <-0.771, 2.540, -3.180> <-0.752, 2.541, -3.191> <-0.742, 2.543, -3.202> 
		<-0.773, 2.529, -3.166> <-0.769, 2.530, -3.180> <-0.750, 2.532, -3.191> <-0.740, 2.534, -3.202> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.078, 2.694, -2.358> <-0.080, 2.700, -2.357> <-0.080, 2.710, -2.359> <-0.084, 2.713, -2.355> 
		<-0.073, 2.695, -2.350> <-0.074, 2.700, -2.350> <-0.071, 2.712, -2.348> <-0.076, 2.715, -2.345> 
		<-0.064, 2.691, -2.340> <-0.063, 2.695, -2.336> <-0.060, 2.707, -2.334> <-0.063, 2.709, -2.329> 
		<-0.059, 2.685, -2.335> <-0.058, 2.689, -2.331> <-0.053, 2.698, -2.326> <-0.056, 2.700, -2.321> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.084, 2.713, -2.355> <-0.093, 2.719, -2.349> <-0.108, 2.721, -2.338> <-0.117, 2.717, -2.331> 
		<-0.076, 2.715, -2.345> <-0.085, 2.720, -2.338> <-0.099, 2.723, -2.326> <-0.108, 2.718, -2.319> 
		<-0.063, 2.709, -2.329> <-0.069, 2.713, -2.319> <-0.083, 2.716, -2.307> <-0.093, 2.712, -2.301> 
		<-0.056, 2.700, -2.321> <-0.062, 2.704, -2.311> <-0.075, 2.706, -2.298> <-0.085, 2.702, -2.292> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.117, 2.717, -2.331> <-0.122, 2.714, -2.327> <-0.123, 2.697, -2.324> <-0.118, 2.694, -2.327> 
		<-0.108, 2.718, -2.319> <-0.112, 2.715, -2.315> <-0.117, 2.698, -2.315> <-0.112, 2.695, -2.319> 
		<-0.093, 2.712, -2.301> <-0.099, 2.709, -2.298> <-0.105, 2.693, -2.301> <-0.102, 2.691, -2.307> 
		<-0.085, 2.702, -2.292> <-0.091, 2.699, -2.290> <-0.100, 2.686, -2.295> <-0.097, 2.684, -2.301> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.118, 2.694, -2.327> <-0.108, 2.687, -2.334> <-0.091, 2.692, -2.348> <-0.079, 2.691, -2.356> 
		<-0.112, 2.695, -2.319> <-0.101, 2.688, -2.326> <-0.086, 2.693, -2.341> <-0.074, 2.692, -2.350> 
		<-0.102, 2.691, -2.307> <-0.096, 2.685, -2.319> <-0.077, 2.689, -2.330> <-0.066, 2.689, -2.340> 
		<-0.097, 2.684, -2.301> <-0.090, 2.679, -2.313> <-0.072, 2.683, -2.325> <-0.061, 2.683, -2.335> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.093, 2.679, -2.380> <-0.098, 2.683, -2.383> <-0.101, 2.690, -2.390> <-0.107, 2.691, -2.389> 
		<-0.091, 2.686, -2.375> <-0.095, 2.690, -2.378> <-0.097, 2.701, -2.383> <-0.103, 2.702, -2.381> 
		<-0.084, 2.693, -2.365> <-0.086, 2.699, -2.364> <-0.088, 2.709, -2.370> <-0.093, 2.712, -2.366> 
		<-0.078, 2.694, -2.358> <-0.080, 2.700, -2.357> <-0.080, 2.710, -2.359> <-0.084, 2.713, -2.355> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.107, 2.691, -2.389> <-0.119, 2.694, -2.386> <-0.136, 2.695, -2.378> <-0.143, 2.692, -2.369> 
		<-0.103, 2.702, -2.381> <-0.115, 2.705, -2.379> <-0.131, 2.707, -2.370> <-0.138, 2.704, -2.360> 
		<-0.093, 2.712, -2.366> <-0.102, 2.717, -2.360> <-0.118, 2.720, -2.351> <-0.127, 2.715, -2.343> 
		<-0.084, 2.713, -2.355> <-0.093, 2.719, -2.349> <-0.108, 2.721, -2.338> <-0.117, 2.717, -2.331> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.143, 2.692, -2.369> <-0.147, 2.690, -2.364> <-0.143, 2.679, -2.352> <-0.136, 2.677, -2.353> 
		<-0.138, 2.704, -2.360> <-0.142, 2.702, -2.355> <-0.139, 2.687, -2.346> <-0.133, 2.685, -2.347> 
		<-0.127, 2.715, -2.343> <-0.131, 2.712, -2.339> <-0.130, 2.696, -2.332> <-0.125, 2.693, -2.335> 
		<-0.117, 2.717, -2.331> <-0.122, 2.714, -2.327> <-0.123, 2.697, -2.324> <-0.118, 2.694, -2.327> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.136, 2.677, -2.353> <-0.122, 2.673, -2.355> <-0.107, 2.678, -2.370> <-0.094, 2.678, -2.378> 
		<-0.133, 2.685, -2.347> <-0.119, 2.681, -2.349> <-0.104, 2.684, -2.365> <-0.091, 2.684, -2.373> 
		<-0.125, 2.693, -2.335> <-0.114, 2.686, -2.343> <-0.096, 2.691, -2.355> <-0.085, 2.691, -2.363> 
		<-0.118, 2.694, -2.327> <-0.108, 2.687, -2.334> <-0.091, 2.692, -2.348> <-0.079, 2.691, -2.356> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.096, 2.650, -2.389> <-0.101, 2.649, -2.393> <-0.105, 2.648, -2.403> <-0.111, 2.647, -2.403> 
		<-0.098, 2.659, -2.389> <-0.102, 2.658, -2.393> <-0.108, 2.662, -2.403> <-0.114, 2.661, -2.403> 
		<-0.096, 2.672, -2.385> <-0.101, 2.676, -2.388> <-0.106, 2.679, -2.398> <-0.112, 2.681, -2.397> 
		<-0.093, 2.679, -2.380> <-0.098, 2.683, -2.383> <-0.101, 2.690, -2.390> <-0.107, 2.691, -2.389> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.111, 2.647, -2.403> <-0.124, 2.645, -2.401> <-0.141, 2.643, -2.394> <-0.148, 2.642, -2.384> 
		<-0.114, 2.661, -2.403> <-0.126, 2.659, -2.402> <-0.143, 2.658, -2.395> <-0.150, 2.657, -2.385> 
		<-0.112, 2.681, -2.397> <-0.123, 2.684, -2.394> <-0.141, 2.683, -2.387> <-0.148, 2.680, -2.378> 
		<-0.107, 2.691, -2.389> <-0.119, 2.694, -2.386> <-0.136, 2.695, -2.378> <-0.143, 2.692, -2.369> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.148, 2.642, -2.384> <-0.152, 2.641, -2.379> <-0.146, 2.642, -2.363> <-0.139, 2.644, -2.363> 
		<-0.150, 2.657, -2.385> <-0.154, 2.657, -2.379> <-0.148, 2.653, -2.363> <-0.141, 2.654, -2.363> 
		<-0.148, 2.680, -2.378> <-0.152, 2.678, -2.373> <-0.146, 2.671, -2.358> <-0.139, 2.669, -2.359> 
		<-0.143, 2.692, -2.369> <-0.147, 2.690, -2.364> <-0.143, 2.679, -2.352> <-0.136, 2.677, -2.353> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.139, 2.644, -2.363> <-0.125, 2.646, -2.364> <-0.109, 2.648, -2.379> <-0.097, 2.650, -2.386> 
		<-0.141, 2.654, -2.363> <-0.126, 2.656, -2.364> <-0.111, 2.657, -2.379> <-0.098, 2.658, -2.386> 
		<-0.139, 2.669, -2.359> <-0.126, 2.665, -2.361> <-0.109, 2.671, -2.375> <-0.097, 2.671, -2.383> 
		<-0.136, 2.677, -2.353> <-0.122, 2.673, -2.355> <-0.107, 2.678, -2.370> <-0.094, 2.678, -2.378> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.085, 2.623, -2.379> <-0.088, 2.618, -2.382> <-0.089, 2.610, -2.389> <-0.094, 2.607, -2.388> 
		<-0.090, 2.629, -2.385> <-0.093, 2.624, -2.387> <-0.097, 2.619, -2.397> <-0.102, 2.616, -2.396> 
		<-0.095, 2.641, -2.389> <-0.099, 2.640, -2.393> <-0.103, 2.635, -2.403> <-0.109, 2.634, -2.402> 
		<-0.096, 2.650, -2.389> <-0.101, 2.649, -2.393> <-0.105, 2.648, -2.403> <-0.111, 2.647, -2.403> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.094, 2.607, -2.388> <-0.105, 2.601, -2.385> <-0.120, 2.595, -2.377> <-0.128, 2.596, -2.368> 
		<-0.102, 2.616, -2.396> <-0.112, 2.609, -2.393> <-0.129, 2.605, -2.386> <-0.137, 2.606, -2.377> 
		<-0.109, 2.634, -2.402> <-0.122, 2.632, -2.401> <-0.138, 2.627, -2.394> <-0.145, 2.626, -2.384> 
		<-0.111, 2.647, -2.403> <-0.124, 2.645, -2.401> <-0.141, 2.643, -2.394> <-0.148, 2.642, -2.384> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.128, 2.596, -2.368> <-0.133, 2.597, -2.363> <-0.132, 2.609, -2.351> <-0.126, 2.613, -2.352> 
		<-0.137, 2.606, -2.377> <-0.141, 2.607, -2.372> <-0.137, 2.616, -2.357> <-0.132, 2.619, -2.358> 
		<-0.145, 2.626, -2.384> <-0.149, 2.626, -2.379> <-0.144, 2.632, -2.363> <-0.138, 2.633, -2.363> 
		<-0.148, 2.642, -2.384> <-0.152, 2.641, -2.379> <-0.146, 2.642, -2.363> <-0.139, 2.644, -2.363> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.126, 2.613, -2.352> <-0.114, 2.621, -2.355> <-0.098, 2.621, -2.370> <-0.086, 2.624, -2.377> 
		<-0.132, 2.619, -2.358> <-0.120, 2.627, -2.361> <-0.103, 2.626, -2.375> <-0.090, 2.630, -2.382> 
		<-0.138, 2.633, -2.363> <-0.123, 2.635, -2.364> <-0.108, 2.639, -2.379> <-0.095, 2.641, -2.386> 
		<-0.139, 2.644, -2.363> <-0.125, 2.646, -2.364> <-0.109, 2.648, -2.379> <-0.097, 2.650, -2.386> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.066, 2.614, -2.357> <-0.066, 2.608, -2.356> <-0.062, 2.598, -2.357> <-0.066, 2.594, -2.354> 
		<-0.071, 2.613, -2.364> <-0.071, 2.607, -2.363> <-0.071, 2.596, -2.368> <-0.074, 2.592, -2.365> 
		<-0.080, 2.617, -2.374> <-0.083, 2.612, -2.377> <-0.082, 2.601, -2.382> <-0.087, 2.598, -2.380> 
		<-0.085, 2.623, -2.379> <-0.088, 2.618, -2.382> <-0.089, 2.610, -2.389> <-0.094, 2.607, -2.388> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.066, 2.594, -2.354> <-0.073, 2.586, -2.348> <-0.087, 2.579, -2.337> <-0.096, 2.581, -2.329> 
		<-0.074, 2.592, -2.365> <-0.081, 2.585, -2.359> <-0.096, 2.578, -2.349> <-0.106, 2.580, -2.342> 
		<-0.087, 2.598, -2.380> <-0.097, 2.592, -2.377> <-0.112, 2.585, -2.368> <-0.120, 2.586, -2.359> 
		<-0.094, 2.607, -2.388> <-0.105, 2.601, -2.385> <-0.120, 2.595, -2.377> <-0.128, 2.596, -2.368> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.096, 2.581, -2.329> <-0.102, 2.583, -2.325> <-0.108, 2.598, -2.322> <-0.104, 2.603, -2.326> 
		<-0.106, 2.580, -2.342> <-0.111, 2.581, -2.338> <-0.115, 2.597, -2.331> <-0.111, 2.601, -2.334> 
		<-0.120, 2.586, -2.359> <-0.125, 2.587, -2.354> <-0.126, 2.602, -2.345> <-0.120, 2.606, -2.346> 
		<-0.128, 2.596, -2.368> <-0.133, 2.597, -2.363> <-0.132, 2.609, -2.351> <-0.126, 2.613, -2.352> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.104, 2.603, -2.326> <-0.096, 2.612, -2.333> <-0.079, 2.612, -2.347> <-0.068, 2.616, -2.356> 
		<-0.111, 2.601, -2.334> <-0.103, 2.611, -2.342> <-0.084, 2.611, -2.354> <-0.073, 2.615, -2.362> 
		<-0.120, 2.606, -2.346> <-0.108, 2.614, -2.349> <-0.093, 2.615, -2.365> <-0.081, 2.619, -2.372> 
		<-0.126, 2.613, -2.352> <-0.114, 2.621, -2.355> <-0.098, 2.621, -2.370> <-0.086, 2.624, -2.377> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.051, 2.629, -2.334> <-0.048, 2.625, -2.330> <-0.041, 2.618, -2.326> <-0.043, 2.616, -2.320> 
		<-0.053, 2.622, -2.339> <-0.051, 2.618, -2.335> <-0.045, 2.608, -2.333> <-0.047, 2.605, -2.328> 
		<-0.060, 2.615, -2.349> <-0.060, 2.609, -2.349> <-0.054, 2.599, -2.346> <-0.058, 2.595, -2.343> 
		<-0.066, 2.614, -2.357> <-0.066, 2.608, -2.356> <-0.062, 2.598, -2.357> <-0.066, 2.594, -2.354> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.043, 2.616, -2.320> <-0.048, 2.610, -2.310> <-0.059, 2.605, -2.296> <-0.070, 2.606, -2.291> 
		<-0.047, 2.605, -2.328> <-0.052, 2.600, -2.318> <-0.064, 2.593, -2.305> <-0.075, 2.594, -2.300> 
		<-0.058, 2.595, -2.343> <-0.065, 2.588, -2.337> <-0.077, 2.581, -2.324> <-0.087, 2.583, -2.317> 
		<-0.066, 2.594, -2.354> <-0.073, 2.586, -2.348> <-0.087, 2.579, -2.337> <-0.096, 2.581, -2.329> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.070, 2.606, -2.291> <-0.076, 2.607, -2.288> <-0.089, 2.616, -2.295> <-0.087, 2.619, -2.300> 
		<-0.075, 2.594, -2.300> <-0.081, 2.594, -2.297> <-0.092, 2.608, -2.300> <-0.090, 2.611, -2.306> 
		<-0.087, 2.583, -2.317> <-0.092, 2.584, -2.313> <-0.102, 2.599, -2.314> <-0.098, 2.604, -2.318> 
		<-0.096, 2.581, -2.329> <-0.102, 2.583, -2.325> <-0.108, 2.598, -2.322> <-0.104, 2.603, -2.326> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.087, 2.619, -2.300> <-0.082, 2.626, -2.312> <-0.063, 2.627, -2.324> <-0.053, 2.630, -2.334> 
		<-0.090, 2.611, -2.306> <-0.085, 2.618, -2.318> <-0.066, 2.620, -2.329> <-0.056, 2.623, -2.339> 
		<-0.098, 2.604, -2.318> <-0.090, 2.613, -2.325> <-0.073, 2.613, -2.340> <-0.062, 2.617, -2.349> 
		<-0.104, 2.603, -2.326> <-0.096, 2.612, -2.333> <-0.079, 2.612, -2.347> <-0.068, 2.616, -2.356> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.048, 2.658, -2.325> <-0.045, 2.659, -2.320> <-0.037, 2.660, -2.313> <-0.039, 2.660, -2.307> 
		<-0.046, 2.649, -2.325> <-0.044, 2.649, -2.320> <-0.035, 2.646, -2.313> <-0.037, 2.646, -2.307> 
		<-0.048, 2.636, -2.329> <-0.045, 2.632, -2.325> <-0.036, 2.629, -2.318> <-0.039, 2.626, -2.313> 
		<-0.051, 2.629, -2.334> <-0.048, 2.625, -2.330> <-0.041, 2.618, -2.326> <-0.043, 2.616, -2.320> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.039, 2.660, -2.307> <-0.043, 2.659, -2.295> <-0.054, 2.658, -2.280> <-0.065, 2.656, -2.276> 
		<-0.037, 2.646, -2.307> <-0.041, 2.645, -2.295> <-0.052, 2.642, -2.280> <-0.063, 2.640, -2.276> 
		<-0.039, 2.626, -2.313> <-0.043, 2.621, -2.303> <-0.054, 2.617, -2.288> <-0.065, 2.618, -2.283> 
		<-0.043, 2.616, -2.320> <-0.048, 2.610, -2.310> <-0.059, 2.605, -2.296> <-0.070, 2.606, -2.291> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.065, 2.656, -2.276> <-0.072, 2.655, -2.274> <-0.086, 2.653, -2.283> <-0.084, 2.653, -2.290> 
		<-0.063, 2.640, -2.276> <-0.069, 2.639, -2.273> <-0.084, 2.642, -2.283> <-0.082, 2.642, -2.290> 
		<-0.065, 2.618, -2.283> <-0.071, 2.619, -2.280> <-0.086, 2.624, -2.289> <-0.083, 2.627, -2.294> 
		<-0.070, 2.606, -2.291> <-0.076, 2.607, -2.288> <-0.089, 2.616, -2.295> <-0.087, 2.619, -2.300> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.084, 2.653, -2.290> <-0.079, 2.653, -2.304> <-0.060, 2.656, -2.315> <-0.051, 2.658, -2.326> 
		<-0.082, 2.642, -2.290> <-0.078, 2.643, -2.304> <-0.059, 2.648, -2.315> <-0.049, 2.649, -2.326> 
		<-0.083, 2.627, -2.294> <-0.079, 2.634, -2.307> <-0.060, 2.633, -2.319> <-0.050, 2.637, -2.329> 
		<-0.087, 2.619, -2.300> <-0.082, 2.626, -2.312> <-0.063, 2.627, -2.324> <-0.053, 2.630, -2.334> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.059, 2.685, -2.335> <-0.058, 2.689, -2.331> <-0.053, 2.698, -2.326> <-0.056, 2.700, -2.321> 
		<-0.054, 2.679, -2.330> <-0.053, 2.684, -2.326> <-0.046, 2.689, -2.319> <-0.049, 2.691, -2.314> 
		<-0.049, 2.667, -2.325> <-0.046, 2.668, -2.320> <-0.039, 2.674, -2.313> <-0.041, 2.673, -2.307> 
		<-0.048, 2.658, -2.325> <-0.045, 2.659, -2.320> <-0.037, 2.660, -2.313> <-0.039, 2.660, -2.307> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.056, 2.700, -2.321> <-0.062, 2.704, -2.311> <-0.075, 2.706, -2.298> <-0.085, 2.702, -2.292> 
		<-0.049, 2.691, -2.314> <-0.055, 2.695, -2.304> <-0.066, 2.696, -2.289> <-0.077, 2.692, -2.284> 
		<-0.041, 2.673, -2.307> <-0.045, 2.673, -2.296> <-0.056, 2.673, -2.281> <-0.068, 2.671, -2.276> 
		<-0.039, 2.660, -2.307> <-0.043, 2.659, -2.295> <-0.054, 2.658, -2.280> <-0.065, 2.656, -2.276> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.085, 2.702, -2.292> <-0.091, 2.699, -2.290> <-0.100, 2.686, -2.295> <-0.097, 2.684, -2.301> 
		<-0.077, 2.692, -2.284> <-0.082, 2.690, -2.281> <-0.094, 2.680, -2.289> <-0.091, 2.677, -2.295> 
		<-0.068, 2.671, -2.276> <-0.074, 2.670, -2.274> <-0.087, 2.663, -2.283> <-0.085, 2.663, -2.290> 
		<-0.065, 2.656, -2.276> <-0.072, 2.655, -2.274> <-0.086, 2.653, -2.283> <-0.084, 2.653, -2.290> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.097, 2.684, -2.301> <-0.090, 2.679, -2.313> <-0.072, 2.683, -2.325> <-0.061, 2.683, -2.335> 
		<-0.091, 2.677, -2.295> <-0.084, 2.672, -2.307> <-0.067, 2.678, -2.320> <-0.057, 2.678, -2.330> 
		<-0.085, 2.663, -2.290> <-0.081, 2.664, -2.304> <-0.062, 2.665, -2.315> <-0.052, 2.666, -2.326> 
		<-0.084, 2.653, -2.290> <-0.079, 2.653, -2.304> <-0.060, 2.656, -2.315> <-0.051, 2.658, -2.326> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.896, 2.584, -3.196> <-0.904, 2.584, -3.187> <-0.922, 2.580, -3.177> <-0.922, 2.583, -3.166> 
		<-0.900, 2.600, -3.198> <-0.907, 2.600, -3.189> <-0.927, 2.603, -3.180> <-0.927, 2.607, -3.169> 
		<-0.896, 2.622, -3.207> <-0.903, 2.630, -3.201> <-0.923, 2.633, -3.192> <-0.922, 2.641, -3.183> 
		<-0.890, 2.634, -3.216> <-0.896, 2.641, -3.210> <-0.913, 2.651, -3.205> <-0.912, 2.659, -3.196> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.922, 2.583, -3.166> <-0.921, 2.590, -3.146> <-0.911, 2.604, -3.117> <-0.895, 2.614, -3.107> 
		<-0.927, 2.607, -3.169> <-0.927, 2.614, -3.148> <-0.917, 2.631, -3.120> <-0.901, 2.641, -3.110> 
		<-0.922, 2.641, -3.183> <-0.921, 2.655, -3.166> <-0.913, 2.673, -3.138> <-0.896, 2.679, -3.126> 
		<-0.912, 2.659, -3.196> <-0.911, 2.673, -3.180> <-0.902, 2.693, -3.154> <-0.884, 2.699, -3.141> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.895, 2.614, -3.107> <-0.885, 2.620, -3.101> <-0.857, 2.627, -3.115> <-0.857, 2.623, -3.128> 
		<-0.901, 2.641, -3.110> <-0.891, 2.647, -3.104> <-0.861, 2.645, -3.117> <-0.861, 2.641, -3.130> 
		<-0.896, 2.679, -3.126> <-0.886, 2.682, -3.119> <-0.857, 2.675, -3.131> <-0.857, 2.667, -3.140> 
		<-0.884, 2.699, -3.141> <-0.875, 2.702, -3.134> <-0.849, 2.688, -3.141> <-0.850, 2.680, -3.151> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.857, 2.623, -3.128> <-0.856, 2.615, -3.152> <-0.881, 2.597, -3.176> <-0.891, 2.586, -3.196> 
		<-0.861, 2.641, -3.130> <-0.860, 2.633, -3.154> <-0.884, 2.612, -3.177> <-0.894, 2.601, -3.198> 
		<-0.857, 2.667, -3.140> <-0.858, 2.649, -3.160> <-0.881, 2.636, -3.187> <-0.892, 2.622, -3.207> 
		<-0.850, 2.680, -3.151> <-0.850, 2.663, -3.170> <-0.874, 2.648, -3.196> <-0.885, 2.634, -3.215> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.867, 2.538, -3.206> <-0.871, 2.531, -3.198> <-0.882, 2.515, -3.191> <-0.879, 2.515, -3.180> 
		<-0.879, 2.548, -3.199> <-0.883, 2.541, -3.191> <-0.899, 2.529, -3.181> <-0.896, 2.529, -3.170> 
		<-0.892, 2.568, -3.195> <-0.900, 2.568, -3.186> <-0.916, 2.556, -3.175> <-0.916, 2.560, -3.164> 
		<-0.896, 2.584, -3.196> <-0.904, 2.584, -3.187> <-0.922, 2.580, -3.177> <-0.922, 2.583, -3.166> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.879, 2.515, -3.180> <-0.874, 2.514, -3.160> <-0.859, 2.523, -3.133> <-0.847, 2.536, -3.123> 
		<-0.896, 2.529, -3.170> <-0.891, 2.528, -3.150> <-0.879, 2.539, -3.122> <-0.866, 2.552, -3.112> 
		<-0.916, 2.560, -3.164> <-0.916, 2.566, -3.143> <-0.905, 2.577, -3.114> <-0.889, 2.587, -3.104> 
		<-0.922, 2.583, -3.166> <-0.921, 2.590, -3.146> <-0.911, 2.604, -3.117> <-0.895, 2.614, -3.107> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.847, 2.536, -3.123> <-0.838, 2.544, -3.117> <-0.821, 2.569, -3.126> <-0.824, 2.570, -3.138> 
		<-0.866, 2.552, -3.112> <-0.858, 2.560, -3.106> <-0.835, 2.580, -3.118> <-0.837, 2.581, -3.131> 
		<-0.889, 2.587, -3.104> <-0.878, 2.593, -3.098> <-0.853, 2.608, -3.113> <-0.852, 2.604, -3.126> 
		<-0.895, 2.614, -3.107> <-0.885, 2.620, -3.101> <-0.857, 2.627, -3.115> <-0.857, 2.623, -3.128> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.824, 2.570, -3.138> <-0.829, 2.572, -3.163> <-0.852, 2.551, -3.185> <-0.864, 2.543, -3.205> 
		<-0.837, 2.581, -3.131> <-0.843, 2.583, -3.155> <-0.863, 2.560, -3.179> <-0.875, 2.551, -3.199> 
		<-0.852, 2.604, -3.126> <-0.851, 2.597, -3.150> <-0.877, 2.582, -3.174> <-0.887, 2.571, -3.195> 
		<-0.857, 2.623, -3.128> <-0.856, 2.615, -3.152> <-0.881, 2.597, -3.176> <-0.891, 2.586, -3.196> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.821, 2.524, -3.239> <-0.818, 2.515, -3.237> <-0.816, 2.495, -3.238> <-0.809, 2.493, -3.231> 
		<-0.835, 2.522, -3.228> <-0.831, 2.513, -3.225> <-0.836, 2.492, -3.221> <-0.830, 2.491, -3.213> 
		<-0.855, 2.528, -3.213> <-0.858, 2.521, -3.205> <-0.863, 2.500, -3.202> <-0.860, 2.500, -3.191> 
		<-0.867, 2.538, -3.206> <-0.871, 2.531, -3.198> <-0.882, 2.515, -3.191> <-0.879, 2.515, -3.180> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.809, 2.493, -3.231> <-0.796, 2.490, -3.216> <-0.777, 2.498, -3.192> <-0.768, 2.511, -3.180> 
		<-0.830, 2.491, -3.213> <-0.816, 2.487, -3.199> <-0.799, 2.495, -3.173> <-0.791, 2.509, -3.161> 
		<-0.860, 2.500, -3.191> <-0.855, 2.499, -3.171> <-0.838, 2.506, -3.145> <-0.825, 2.519, -3.136> 
		<-0.879, 2.515, -3.180> <-0.874, 2.514, -3.160> <-0.859, 2.523, -3.133> <-0.847, 2.536, -3.123> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.768, 2.511, -3.180> <-0.762, 2.520, -3.173> <-0.762, 2.551, -3.168> <-0.771, 2.553, -3.177> 
		<-0.791, 2.509, -3.161> <-0.785, 2.517, -3.153> <-0.778, 2.549, -3.155> <-0.786, 2.551, -3.164> 
		<-0.825, 2.519, -3.136> <-0.817, 2.527, -3.129> <-0.807, 2.557, -3.134> <-0.810, 2.558, -3.147> 
		<-0.847, 2.536, -3.123> <-0.838, 2.544, -3.117> <-0.821, 2.569, -3.126> <-0.824, 2.570, -3.138> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.771, 2.553, -3.177> <-0.787, 2.559, -3.195> <-0.805, 2.536, -3.219> <-0.820, 2.529, -3.237> 
		<-0.786, 2.551, -3.164> <-0.802, 2.557, -3.181> <-0.818, 2.535, -3.208> <-0.833, 2.527, -3.226> 
		<-0.810, 2.558, -3.147> <-0.815, 2.560, -3.171> <-0.840, 2.541, -3.192> <-0.852, 2.533, -3.212> 
		<-0.824, 2.570, -3.138> <-0.829, 2.572, -3.163> <-0.852, 2.551, -3.185> <-0.864, 2.543, -3.205> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.784, 2.549, -3.277> <-0.775, 2.543, -3.280> <-0.764, 2.530, -3.292> <-0.754, 2.531, -3.287> 
		<-0.791, 2.536, -3.267> <-0.782, 2.531, -3.270> <-0.775, 2.511, -3.277> <-0.765, 2.512, -3.273> 
		<-0.808, 2.525, -3.251> <-0.804, 2.516, -3.248> <-0.796, 2.497, -3.255> <-0.789, 2.496, -3.248> 
		<-0.821, 2.524, -3.239> <-0.818, 2.515, -3.237> <-0.816, 2.495, -3.238> <-0.809, 2.493, -3.231> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.754, 2.531, -3.287> <-0.735, 2.532, -3.280> <-0.711, 2.542, -3.260> <-0.705, 2.554, -3.245> 
		<-0.765, 2.512, -3.273> <-0.746, 2.513, -3.265> <-0.723, 2.520, -3.244> <-0.717, 2.533, -3.228> 
		<-0.789, 2.496, -3.248> <-0.776, 2.493, -3.233> <-0.754, 2.501, -3.212> <-0.745, 2.514, -3.200> 
		<-0.809, 2.493, -3.231> <-0.796, 2.490, -3.216> <-0.777, 2.498, -3.192> <-0.768, 2.511, -3.180> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.705, 2.554, -3.245> <-0.701, 2.562, -3.235> <-0.716, 2.583, -3.216> <-0.728, 2.582, -3.220> 
		<-0.717, 2.533, -3.228> <-0.713, 2.540, -3.218> <-0.724, 2.568, -3.205> <-0.736, 2.568, -3.209> 
		<-0.745, 2.514, -3.200> <-0.740, 2.523, -3.192> <-0.747, 2.553, -3.181> <-0.755, 2.555, -3.190> 
		<-0.768, 2.511, -3.180> <-0.762, 2.520, -3.173> <-0.762, 2.551, -3.168> <-0.771, 2.553, -3.177> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.728, 2.582, -3.220> <-0.751, 2.582, -3.229> <-0.768, 2.562, -3.257> <-0.785, 2.553, -3.273> 
		<-0.736, 2.568, -3.209> <-0.760, 2.567, -3.218> <-0.775, 2.550, -3.248> <-0.792, 2.541, -3.264> 
		<-0.755, 2.555, -3.190> <-0.772, 2.561, -3.208> <-0.793, 2.538, -3.230> <-0.807, 2.530, -3.248> 
		<-0.771, 2.553, -3.177> <-0.787, 2.559, -3.195> <-0.805, 2.536, -3.219> <-0.820, 2.529, -3.237> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.778, 2.599, -3.297> <-0.768, 2.601, -3.303> <-0.755, 2.601, -3.320> <-0.745, 2.606, -3.317> 
		<-0.774, 2.583, -3.295> <-0.764, 2.585, -3.302> <-0.750, 2.577, -3.317> <-0.739, 2.582, -3.315> 
		<-0.777, 2.561, -3.286> <-0.768, 2.555, -3.289> <-0.754, 2.548, -3.305> <-0.744, 2.548, -3.301> 
		<-0.784, 2.549, -3.277> <-0.775, 2.543, -3.280> <-0.764, 2.530, -3.292> <-0.754, 2.531, -3.287> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.745, 2.606, -3.317> <-0.726, 2.615, -3.313> <-0.700, 2.631, -3.297> <-0.694, 2.639, -3.279> 
		<-0.739, 2.582, -3.315> <-0.720, 2.591, -3.311> <-0.694, 2.604, -3.294> <-0.688, 2.613, -3.276> 
		<-0.744, 2.548, -3.301> <-0.724, 2.550, -3.293> <-0.699, 2.562, -3.276> <-0.693, 2.574, -3.260> 
		<-0.754, 2.531, -3.287> <-0.735, 2.532, -3.280> <-0.711, 2.542, -3.260> <-0.705, 2.554, -3.245> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_s