//INCLUDE FILE FOR CREATING CREATURE.
//BY DAVID BRIDGE JUNE 2001.
//USE THE FOLLOWING EXAMPLE:

/*
object
{
DBs_Creature
scale 0.6
rotate<0, -10, 0>
translate<-45, 30, 100>
}
*/

#declare Creature_Body_Txtr=texture
{
    pigment
    {
        gradient z
        turbulence 0.1
        colour_map
        {
            [0.0 colour Yellow]
            [0.4 colour Yellow]
            [0.5 colour Black]
            [0.9 colour Black]
            [1.0 colour Yellow]
        }
    }
    finish
    {
        ambient 0.2
        diffuse 0.4
    }
    scale 3
}

#declare Creature_Leg_Txtr=texture
{
  pigment{ colour rgb<0, 0, 0>}
  finish
  {
    ambient 0.2
    diffuse 0.4
    brilliance 2
    metallic
    reflection 0.2
    specular 0.5
    roughness 0.2
  }
}

#declare Creature_Feeler_Txtr=texture
{
  pigment{ colour rgb<0, 0, 0>}
  finish
  {
    ambient 0.2
    diffuse 0.4
    reflection 0.2
    specular 0.5
    roughness 0.2
  }
}

#declare Creature_Eye_Txtr=texture
{
  pigment{ colour rgb<0, 0, 0.2>}
  finish
  {
    ambient 0.2
    diffuse 0.4
    reflection 0.3
    specular 0.6
    roughness 0.01
    irid
    {
      0.35
      thickness 0.5
      turbulence 0.5
    }
  }
}

#declare Creature_Prob_Txtr=texture
{
  pigment{ colour rgb<0, 0, 0>}
  finish
  {
    ambient 0.2
    diffuse 0.4
    reflection 0.2
    specular 0.5
    roughness 0.2
  }
}

//THESE OBJECTS GENERATED BY WORM V0.05A - ROBERT FLORES AND CTDS 3.0 - TRUEMAN BROWN

#declare XX = (0);
#declare ZZ = (0);

#declare Creature_Leg =
   union {
      sphere { < -0.05219, 0.05219, ZZ >, 1 }
      cone  { < -0.020456, 0.036486, 0 >, 0.999373, < 10.092111, -4.967672, 0 >, 0.599624 }
      sphere { < 10.07307, -4.95825, ZZ >, 0.6 }
      cone  { < 10.06828, -4.96783, 0 >, 0.599904, < 5.059437, -14.985507, 0 >, 0.399936 }
      sphere { < 5.06263, -14.97912, ZZ >, 0.4 }
      cone  { < 5.105208, -14.97912, 0 >, 0.397727, < 6.962839, -14.97912, 0 >, 0.198864 }
      sphere { < 6.94155, -14.97912, ZZ >, 0.2 }
      //THIS BOUNDING BOX IS NOT CORRECT! DO NOT USE
      // bounded_by { box { < -1.05219, -15.37912, -1 >, < 7.14155, 1.05219, 1 > } }
      texture { Creature_Leg_Txtr }
   }

#declare Creature_Feeler =
   union {
      sphere { < 0, 0, ZZ >, 0.2 }
      cone  { < -0.000325, -0.005909, 0 >, 0.199912, < 0.110828, 2.017069, 0 >, 0.259886 }
      sphere { < 0.11125, 2.02475, ZZ >, 0.26 }
      cone  { < 0.110364, 2.018327, 0 >, 0.259919, < 0.438909, 4.400094, 0 >, 0.3199 }
      sphere { < 0.44, 4.408, ZZ >, 0.32 }
      cone  { < 0.438538, 4.400932, 0 >, 0.319919, < 0.977014, 7.004857, 0 >, 0.379903 }
      sphere { < 0.97875, 7.01325, ZZ >, 0.38 }
      cone  { < 0.97658, 7.005374, 0 >, 0.379912, < 1.717488, 9.694881, 0 >, 0.439898 }
      sphere { < 1.72, 9.704, ZZ >, 0.44 }
      cone  { < 1.716849, 9.695117, 0 >, 0.439899, < 2.65267, 12.333655, 0 >, 0.499885 }
      sphere { < 2.65625, 12.34375, ZZ >, 0.5 }
      cone  { < 2.651617, 12.333639, 0 >, 0.499876, < 3.774811, 14.784676, 0 >, 0.559861 }
      sphere { < 3.78, 14.796, ZZ >, 0.56 }
      cone  { < 3.772968, 14.78452, 0 >, 0.559838, < 5.075964, 16.91154, 0 >, 0.619821 }
      sphere { < 5.08375, 16.92425, ZZ >, 0.62 }
      cone  { < 5.07268, 16.911744, 0 >, 0.619775, < 6.547858, 18.578283, 0 >, 0.679753 }
      sphere { < 6.56, 18.592, ZZ >, 0.68 }
      cone  { < 6.542563, 18.580624, 0 >, 0.679681, < 8.182274, 19.65037, 0 >, 0.739653 }
      sphere { < 8.20125, 19.66275, ZZ >, 0.74 }
      cone  { < 8.177404, 19.658279, 0 >, 0.739602, < 9.974221, 19.995167, 0 >, 0.79957 }
      sphere { < 10, 20, ZZ >, 0.8 }
      bounded_by { box { < -0.2, -0.2, -0.8 >, < 10.8, 20.8, 0.8 > } }
      texture { Creature_Feeler_Txtr }
   }

#declare Creature_Prob =
   union {
      sphere { < XX, 0.05219, 9.96869 >, 0.6 }
      cone  { < XX, 0.05219, 9.96869 >, 0.6, < XX, 0.05219, 0.05219 >, 0.6 }
      sphere { < XX, 0.05219, 0.05219 >, 0.6 }
      cone  { < 0, 0.052135, 0.051241 >, 0.599999, < 0, -0.020585, -1.209036 >, 0.597999 }
      sphere { < XX, -0.02053, -1.20809 >, 0.598 }
      cone  { < 0, -0.02074, -1.209016 >, 0.597999, < 0, -0.299589, -2.438002 >, 0.595999 }
      sphere { < XX, -0.29938, -2.43708 >, 0.596 }
      cone  { < 0, -0.299705, -2.437973 >, 0.595999, < 0, -0.728474, -3.6163 >, 0.593999 }
      sphere { < XX, -0.72815, -3.61541 >, 0.594 }
      cone  { < 0, -0.728585, -3.616257 >, 0.593999, < 0, -1.298994, -4.725834 >, 0.591999 }
      sphere { < XX, -1.29856, -4.72499 >, 0.592 }
      cone  { < 0, -1.299099, -4.725777 >, 0.591999, < 0, -2.000727, -5.749764 >, 0.589999 }
      sphere { < XX, -2.00019, -5.74898 >, 0.59 }
      cone  { < 0, -2.000825, -5.749694 >, 0.589999, < 0, -2.821263, -6.672782 >, 0.587999 }
      sphere { < XX, -2.82063, -6.67207 >, 0.588 }
      cone  { < 0, -2.821351, -6.6727 >, 0.587999, < 0, -3.746428, -7.481348 >, 0.585999 }
      sphere { < XX, -3.74571, -7.48072 >, 0.586 }
      cone  { < 0, -3.746505, -7.481255 >, 0.585999, < 0, -4.760553, -8.163834 >, 0.583999 }
      sphere { < XX, -4.75976, -8.1633 >, 0.584 }
      cone  { < 0, -4.760618, -8.163732 >, 0.583999, < 0, -5.846705, -8.710771 >, 0.581999 }
      sphere { < XX, -5.84585, -8.71034 >, 0.582 }
      cone  { < 0, -5.846757, -8.710662 >, 0.581999, < 0, -6.986984, -9.11491 >, 0.579999 }
      sphere { < XX, -6.98608, -9.11459 >, 0.58 }
      cone  { < 0, -6.987022, -9.114795 >, 0.579999, < 0, -8.162818, -9.371345 >, 0.577999 }
      sphere { < XX, -8.16188, -9.37114 >, 0.578 }
      cone  { < 0, -8.162842, -9.371226 >, 0.577999, < 0, -9.355268, -9.477565 >, 0.575999 }
      sphere { < XX, -9.35431, -9.47748 >, 0.576 }
      cone  { < 0, -9.355277, -9.477444 >, 0.575999, < 0, -10.545313, -9.433464 >, 0.573999 }
      sphere { < XX, -10.54435, -9.4335 >, 0.574 }
      cone  { < 0, -10.545306, -9.433343 >, 0.573999, < 0, -11.714173, -9.241313 >, 0.571999 }
      sphere { < XX, -11.71322, -9.24147 >, 0.572 }
      cone  { < 0, -11.714151, -9.241194 >, 0.571999, < 0, -12.843617, -8.905715 >, 0.569999 }
      sphere { < XX, -12.84269, -8.90599 >, 0.57 }
      cone  { < 0, -12.84358, -8.905598 >, 0.569999, < 0, -13.916217, -8.4335 >, 0.567999 }
      sphere { < XX, -13.91533, -8.43389 >, 0.568 }
      cone  { < 0, -13.916166, -8.433389 >, 0.567999, < 0, -14.915623, -7.83359 >, 0.565999 }
      sphere { < XX, -14.91479, -7.83409 >, 0.566 }
      cone  { < 0, -14.915558, -7.833486 >, 0.565999, < 0, -15.826835, -7.116839 >, 0.563999 }
      sphere { < XX, -15.82607, -7.11744 >, 0.564 }
      cone  { < 0, -15.826757, -7.116743 >, 0.563999, < 0, -16.636415, -6.295826 >, 0.561999 }
      sphere { < XX, -16.63573, -6.29652 >, 0.562 }
      cone  { < 0, -16.636325, -6.295741 >, 0.561999, < 0, -17.332643, -5.384664 >, 0.559999 }
      sphere { < XX, -17.33205, -5.38544 >, 0.56 }
      cone  { < 0, -17.332544, -5.384591 >, 0.559999, < 0, -17.905782, -4.398734 >, 0.557999 }
      sphere { < XX, -17.90529, -4.39958 >, 0.558 }
      cone  { < 0, -17.905674, -4.398674 >, 0.557999, < 0, -18.348123, -3.354447 >, 0.555999 }
      sphere { < XX, -18.34774, -3.35535 >, 0.556 }
      cone  { < 0, -18.348008, -3.354401 >, 0.555999, < 0, -18.654097, -2.268944 >, 0.553999 }
      sphere { < XX, -18.65383, -2.26989 >, 0.554 }
      cone  { < 0, -18.653977, -2.268913 >, 0.553999, < 0, -18.820396, -1.159846 >, 0.551999 }
      sphere { < XX, -18.82025, -1.16082 >, 0.552 }
      cone  { < 0, -18.820273, -1.15983 >, 0.551999, < 0, -18.845953, -0.044944 >, 0.549999 }
      sphere { < XX, -18.84593, -0.04593 >, 0.55 }
      cone  { < 0, -18.845828, -0.044943 >, 0.549999, < 0, -18.731938, 1.058063 >, 0.547999 }
      sphere { < XX, -18.73204, 1.05708 >, 0.548 }
      cone  { < 0, -18.731815, 1.058048 >, 0.547999, < 0, -18.481725, 2.131875 >, 0.545999 }
      sphere { < XX, -18.48195, 2.13091 >, 0.546 }
      cone  { < 0, -18.481604, 2.131844 >, 0.545999, < 0, -18.100825, 3.159851 >, 0.543999 }
      sphere { < XX, -18.10117, 3.15892 >, 0.544 }
      cone  { < 0, -18.100708, 3.159805 >, 0.543999, < 0, -17.59674, 4.126252 >, 0.541999 }
      sphere { < XX, -17.5972, 4.12537 >, 0.542 }
      cone  { < 0, -17.59663, 4.126192 >, 0.541999, < 0, -16.978862, 5.016509 >, 0.539999 }
      sphere { < XX, -16.97943, 5.01569 >, 0.54 }
      cone  { < 0, -16.97876, 5.016435 >, 0.539999, < 0, -16.258282, 5.817423 >, 0.537999 }
      sphere { < XX, -16.25895, 5.81668 >, 0.538 }
      cone  { < 0, -16.25819, 5.817337 >, 0.537999, < 0, -15.447572, 6.517364 >, 0.535999 }
      sphere { < XX, -15.44833, 6.51671 >, 0.536 }
      cone  { < 0, -15.447491, 6.517267 >, 0.535999, < 0, -14.560624, 7.106435 >, 0.533999 }
      sphere { < XX, -14.56146, 7.10588 >, 0.534 }
      cone  { < 0, -14.560556, 7.106328 >, 0.533999, < 0, -13.612349, 7.576637 >, 0.531999 }
      sphere { < XX, -13.61325, 7.57619 >, 0.532 }
      cone  { < 0, -13.612295, 7.576522 >, 0.531999, < 0, -12.618478, 7.921921 >, 0.529999 }
      sphere { < XX, -12.61943, 7.92159 >, 0.53 }
      cone  { < 0, -12.618438, 7.9218 >, 0.529999, < 0, -11.595272, 8.138309 >, 0.527999 }
      sphere { < XX, -11.59626, 8.1381 >, 0.528 }
      cone  { < 0, -11.595248, 8.138184 >, 0.527999, < 0, -10.559281, 8.223933 >, 0.525999 }
      sphere { < XX, -10.56029, 8.22385 >, 0.526 }
      cone  { < 0, -10.559273, 8.223806 >, 0.525999, < 0, -9.527027, 8.179006 >, 0.523999 }
      sphere { < XX, -9.52804, 8.17905 >, 0.524 }
      cone  { < 0, -9.527034, 8.178878 >, 0.523999, < 0, -8.514818, 8.005809 >, 0.521999 }
      sphere { < XX, -8.51582, 8.00598 >, 0.522 }
      cone  { < 0, -8.514841, 8.005682 >, 0.521999, < 0, -7.538415, 7.708653 >, 0.519999 }
      sphere { < XX, -7.53939, 7.70895 >, 0.52 }
      cone  { < 0, -7.538454, 7.708531 >, 0.519999, < 0, -6.612838, 7.293762 >, 0.517999 }
      sphere { < XX, -6.61377, 7.29418 >, 0.518 }
      cone  { < 0, -6.612892, 7.293645 >, 0.517999, < 0, -5.752106, 6.769147 >, 0.515999 }
      sphere { < XX, -5.75298, 6.76968 >, 0.516 }
      cone  { < 0, -5.752175, 6.769038 >, 0.515999, < 0, -4.969038, 6.14447 >, 0.513999 }
      sphere { < XX, -4.96984, 6.14511 >, 0.514 }
      cone  { < 0, -4.96912, 6.14437 >, 0.513999, < 0, -4.275053, 5.430873 >, 0.511999 }
      sphere { < XX, -4.27577, 5.43161 >, 0.512 }
      cone  { < 0, -4.275147, 5.430783 >, 0.511999, < 0, -3.68004, 4.640766 >, 0.509999 }
      sphere { < XX, -3.68066, 4.64159 >, 0.51 }
      cone  { < 0, -3.680145, 4.640689 >, 0.509999, < 0, -3.192147, 3.787633 >, 0.507999 }
      sphere { < XX, -3.19266, 3.78853 >, 0.508 }
      cone  { < 0, -3.192261, 3.787569 >, 0.507999, < 0, -2.817753, 2.885763 >, 0.505999 }
      sphere { < XX, -2.81815, 2.88672 >, 0.506 }
      cone  { < 0, -2.817874, 2.885714 >, 0.505999, < 0, -2.561315, 1.950078 >, 0.503999 }
      sphere { < XX, -2.56159, 1.95108 >, 0.504 }
      cone  { < 0, -2.561442, 1.950045 >, 0.503999, < 0, -2.425393, 0.995829 >, 0.501999 }
      sphere { < XX, -2.42554, 0.99686 >, 0.502 }
      cone  { < 0, -2.425524, 0.995812 >, 0.501999, < 0, -2.410574, 0.038366 >, 0.499999 }
      sphere { < XX, -2.41059, 0.03941 >, 0.5 }
      cone  { < 0, -2.410706, 0.038365 >, 0.499999, < 0, -2.515505, -0.907111 >, 0.497999 }
      sphere { < XX, -2.51539, -0.90607 >, 0.498 }
      cone  { < 0, -2.515637, -0.907095 >, 0.497999, < 0, -2.736966, -1.825771 >, 0.495999 }
      sphere { < XX, -2.73672, -1.82475 >, 0.496 }
      cone  { < 0, -2.737095, -1.825738 >, 0.495999, < 0, -3.069893, -2.703414 >, 0.493999 }
      sphere { < XX, -3.06952, -2.70243 >, 0.494 }
      cone  { < 0, -3.070017, -2.703366 >, 0.493999, < 0, -3.507535, -3.526682 >, 0.491999 }
      sphere { < XX, -3.50704, -3.52575 >, 0.492 }
      cone  { < 0, -3.507653, -3.526618 >, 0.491999, < 0, -4.04156, -4.283265 >, 0.489999 }
      sphere { < XX, -4.04095, -4.2824 >, 0.49 }
      cone  { < 0, -4.041669, -4.283186 >, 0.489999, < 0, -4.662196, -4.962073 >, 0.487999 }
      sphere { < XX, -4.66148, -4.96129 >, 0.488 }
      cone  { < 0, -4.662294, -4.961982 >, 0.487999, < 0, -5.358441, -5.553389 >, 0.485999 }
      sphere { < XX, -5.35763, -5.5527 >, 0.486 }
      cone  { < 0, -5.358527, -5.553286 >, 0.485999, < 0, -6.118224, -6.049043 >, 0.483999 }
      sphere { < XX, -6.11733, -6.04846 >, 0.484 }
      cone  { < 0, -6.118297, -6.048929 >, 0.483999, < 0, -6.928613, -6.442498 >, 0.481999 }
      sphere { < XX, -6.92765, -6.44203 >, 0.482 }
      cone  { < 0, -6.928671, -6.442375 >, 0.481999, < 0, -7.776077, -6.728924 >, 0.479999 }
      sphere { < XX, -7.77506, -6.72858 >, 0.48 }
      cone  { < 0, -7.776119, -6.728795 >, 0.479999, < 0, -8.646645, -6.905274 >, 0.477999 }
      sphere { < XX, -8.64559, -6.90506 >, 0.478 }
      cone  { < 0, -8.646671, -6.90514 >, 0.477999, < 0, -9.526196, -6.9703 >, 0.475999 }
      sphere { < XX, -9.52512, -6.97022 >, 0.476 }
      cone  { < 0, -9.526206, -6.970163 >, 0.475999, < 0, -10.400651, -6.924544 >, 0.473999 }
      sphere { < XX, -10.39957, -6.9246 >, 0.474 }
      cone  { < 0, -10.400643, -6.924407 >, 0.473999, < 0, -11.256209, -6.770298 >, 0.471999 }
      sphere { < XX, -11.25514, -6.77049 >, 0.472 }
      cone  { < 0, -11.256184, -6.770162 >, 0.471999, < 0, -12.079569, -6.511584 >, 0.469999 }
      sphere { < XX, -12.07853, -6.51191 >, 0.47 }
      cone  { < 0, -12.079527, -6.511452 >, 0.469999, < 0, -12.858123, -6.154014 >, 0.467999 }
      sphere { < XX, -12.85713, -6.15447 >, 0.468 }
      cone  { < 0, -12.858065, -6.153889 >, 0.467999, < 0, -13.580181, -5.704691 >, 0.465999 }
      sphere { < XX, -13.57925, -5.70527 >, 0.466 }
      cone  { < 0, -13.580107, -5.704574 >, 0.465999, < 0, -14.235103, -5.172097 >, 0.463999 }
      sphere { < XX, -14.23425, -5.17279 >, 0.464 }
      cone  { < 0, -14.235015, -5.171989 >, 0.463999, < 0, -14.813491, -4.565912 >, 0.461999 }
      sphere { < XX, -14.81273, -4.56671 >, 0.462 }
      cone  { < 0, -14.81339, -4.565816 >, 0.461999, < 0, -15.307287, -3.89686 >, 0.459999 }
      sphere { < XX, -15.30663, -3.89775 >, 0.46 }
      cone  { < 0, -15.307174, -3.896777 >, 0.459999, < 0, -15.709922, -3.176511 >, 0.457999 }
      sphere { < XX, -15.70938, -3.17748 >, 0.458 }
      cone  { < 0, -15.709799, -3.176443 >, 0.457999, < 0, -16.016387, -2.417067 >, 0.455999 }
      sphere { < XX, -16.01597, -2.4181 >, 0.456 }
      cone  { < 0, -16.016256, -2.417015 >, 0.455999, < 0, -16.223275, -1.6312 >, 0.453999 }
      sphere { < XX, -16.22299, -1.63228 >, 0.454 }
      cone  { < 0, -16.223138, -1.631164 >, 0.453999, < 0, -16.328807, -0.831799 >, 0.451999 }
      sphere { < XX, -16.32866, -0.83291 >, 0.452 }
      cone  { < 0, -16.328666, -0.83178 >, 0.451999, < 0, -16.332896, -0.031765 >, 0.449999 }
      sphere { < XX, -16.33289, -0.03289 >, 0.45 }
      cone  { < 0, -16.332753, -0.031764 >, 0.449999, < 0, -16.237044, 0.756181 >, 0.447999 }
      sphere { < XX, -16.23718, 0.75506 >, 0.448 }
      cone  { < 0, -16.236902, 0.756163 >, 0.447999, < 0, -16.044343, 1.519678 >, 0.445999 }
      sphere { < XX, -16.04462, 1.51858 >, 0.446 }
      cone  { < 0, -16.044204, 1.519643 >, 0.445999, < 0, -15.759385, 2.246999 >, 0.443999 }
      sphere { < XX, -15.7598, 2.24594 >, 0.444 }
      cone  { < 0, -15.759251, 2.246946 >, 0.443999, < 0, -15.388174, 2.927142 >, 0.441999 }
      sphere { < XX, -15.38872, 2.92614 >, 0.442 }
      cone  { < 0, -15.388046, 2.927072 >, 0.441999, < 0, -14.937999, 3.550048 >, 0.439999 }
      sphere { < XX, -14.93867, 3.54912 >, 0.44 }
      cone  { < 0, -14.937882, 3.549963 >, 0.439998, < 0, -14.417305, 4.106739 >, 0.437998 }
      sphere { < XX, -14.41809, 4.1059 >, 0.438 }
      cone  { < 0, -14.417198, 4.10664 >, 0.437998, < 0, -13.835522, 4.589427 >, 0.435998 }
      sphere { < XX, -13.83641, 4.58869 >, 0.436 }
      cone  { < 0, -13.835429, 4.589314 >, 0.435998, < 0, -13.202913, 4.991661 >, 0.433998 }
      sphere { < XX, -13.20389, 4.99104 >, 0.434 }
      cone  { < 0, -13.202834, 4.991538 >, 0.433998, < 0, -12.530389, 5.308365 >, 0.431998 }
      sphere { < XX, -12.53144, 5.30787 >, 0.432 }
      cone  { < 0, -12.530325, 5.308232 >, 0.431998, < 0, -11.82934, 5.53593 >, 0.429998 }
      sphere { < XX, -11.83045, 5.53557 >, 0.43 }
      cone  { < 0, -11.829294, 5.53579 >, 0.429998, < 0, -11.111399, 5.672239 >, 0.427998 }
      sphere { < XX, -11.11255, 5.67202 >, 0.428 }
      cone  { < 0, -11.111371, 5.672093 >, 0.427998, < 0, -10.388296, 5.716662 >, 0.425998 }
      sphere { < XX, -10.38947, 5.71659 >, 0.426 }
      cone  { < 0, -10.388286, 5.716513 >, 0.425998, < 0, -9.671642, 5.670074 >, 0.423998 }
      sphere { < XX, -9.67282, 5.67015 >, 0.424 }
      cone  { < 0, -9.67165, 5.669924 >, 0.423998, < 0, -8.972736, 5.534785 >, 0.421998 }
      sphere { < XX, -8.9739, 5.53501 >, 0.422 }
      cone  { < 0, -8.972764, 5.534637 >, 0.421998, < 0, -8.302419, 5.314509 >, 0.419998 }
      sphere { < XX, -8.30355, 5.31488 >, 0.42 }
      cone  { < 0, -8.302465, 5.314364 >, 0.419998, < 0, -7.67088, 5.014247 >, 0.417998 }
      sphere { < XX, -7.67196, 5.01476 >, 0.418 }
      cone  { < 0, -7.670944, 5.014109 >, 0.417998, < 0, -7.087509, 4.640212 >, 0.415998 }
      sphere { < XX, -7.08852, 4.64086 >, 0.416 }
      cone  { < 0, -7.08759, 4.640083 >, 0.415998, < 0, -6.560735, 4.199697 >, 0.413998 }
      sphere { < XX, -6.56166, 4.20047 >, 0.414 }
      cone  { < 0, -6.560832, 4.199578 >, 0.413998, < 0, -6.097946, 3.700922 >, 0.411998 }
      sphere { < XX, -6.09877, 3.70181 >, 0.412 }
      cone  { < 0, -6.098058, 3.700816 >, 0.411998, < 0, -5.705371, 3.152921 >, 0.409998 }
      sphere { < XX, -5.70608, 3.15391 >, 0.41 }
      cone  { < 0, -5.705496, 3.15283 >, 0.409998, < 0, -5.387989, 2.565355 >, 0.407998 }
      sphere { < XX, -5.38857, 2.56643 >, 0.408 }
      cone  { < 0, -5.388125, 2.56528 >, 0.407998, < 0, -5.149467, 1.948335 >, 0.405998 }
      sphere { < XX, -5.14991, 1.94948 >, 0.406 }
      cone  { < 0, -5.149612, 1.948277 >, 0.405998, < 0, -4.992134, 1.312283 >, 0.403998 }
      sphere { < XX, -4.99243, 1.31348 >, 0.404 }
      cone  { < 0, -4.992286, 1.312243 >, 0.403998, < 0, -4.916986, 0.667719 >, 0.401998 }
      sphere { < XX, -4.91713, 0.66895 >, 0.402 }
      cone  { < 0, -4.917143, 0.667699 >, 0.401998, < 0, -4.923643, 0.025115 >, 0.399998 }
      sphere { < XX, -4.92363, 0.02636 >, 0.4 }
      cone  { < 0, -4.923801, 0.025114 >, 0.399998, < 0, -5.01042, -0.605279 >, 0.397998 }
      sphere { < XX, -5.01025, -0.60404 >, 0.398 }
      cone  { < 0, -5.010578, -0.60526 >, 0.397998, < 0, -5.174377, -1.213634 >, 0.395998 }
      sphere { < XX, -5.17405, -1.21242 >, 0.396 }
      cone  { < 0, -5.174532, -1.213595 >, 0.395998, < 0, -5.41137, -1.790619 >, 0.393998 }
      sphere { < XX, -5.41089, -1.78945 >, 0.394 }
      cone  { < 0, -5.41152, -1.79056 >, 0.393998, < 0, -5.716146, -2.327624 >, 0.391998 }
      sphere { < XX, -5.71552, -2.32652 >, 0.392 }
      cone  { < 0, -5.716289, -2.327547 >, 0.391998, < 0, -6.082475, -2.816852 >, 0.389998 }
      sphere { < XX, -6.08171, -2.81583 >, 0.39 }
      cone  { < 0, -6.082607, -2.816757 >, 0.389998, < 0, -6.503232, -3.251422 >, 0.387998 }
      sphere { < XX, -6.50234, -3.2505 >, 0.388 }
      cone  { < 0, -6.503352, -3.25131 >, 0.387998, < 0, -6.970567, -3.625496 >, 0.385998 }
      sphere { < XX, -6.96956, -3.62469 >, 0.386 }
      cone  { < 0, -6.970672, -3.62537 >, 0.385998, < 0, -7.476006, -3.934296 >, 0.383998 }
      sphere { < XX, -7.4749, -3.93362 >, 0.384 }
      cone  { < 0, -7.476096, -3.934157 >, 0.383998, < 0, -8.010649, -4.174254 >, 0.381998 }
      sphere { < XX, -8.00946, -4.17372 >, 0.382 }
      cone  { < 0, -8.010721, -4.174104 >, 0.381998, < 0, -8.565294, -4.342952 >, 0.379998 }
      sphere { < XX, -8.56404, -4.34257 >, 0.38 }
      cone  { < 0, -8.565346, -4.342793 >, 0.379998, < 0, -9.13061, -4.439202 >, 0.377998 }
      sphere { < XX, -9.12931, -4.43898 >, 0.378 }
      cone  { < 0, -9.130642, -4.439036 >, 0.377998, < 0, -9.697265, -4.463006 >, 0.375998 }
      sphere { < XX, -9.69594, -4.46295 >, 0.376 }
      cone  { < 0, -9.697276, -4.462837 >, 0.375998, < 0, -10.256129, -4.415578 >, 0.373998 }
      sphere { < XX, -10.2548, -4.41569 >, 0.374 }
      cone  { < 0, -10.256119, -4.415407 >, 0.373998, < 0, -10.798372, -4.299239 >, 0.371998 }
      sphere { < XX, -10.79706, -4.29952 >, 0.372 }
      cone  { < 0, -10.79834, -4.29907 >, 0.371998, < 0, -11.315633, -4.117393 >, 0.369998 }
      sphere { < XX, -11.31436, -4.11784 >, 0.37 }
      cone  { < 0, -11.315581, -4.117228 >, 0.369997, < 0, -11.800154, -3.874442 >, 0.367997 }
      sphere { < XX, -11.79894, -3.87505 >, 0.368 }
      cone  { < 0, -11.800081, -3.874284 >, 0.367997, < 0, -12.244844, -3.575688 >, 0.365997 }
      sphere { < XX, -12.24371, -3.57645 >, 0.366 }
      cone  { < 0, -12.244751, -3.57554 >, 0.365997, < 0, -12.643466, -3.227235 >, 0.363997 }
      sphere { < XX, -12.64243, -3.22814 >, 0.364 }
      cone  { < 0, -12.643354, -3.227099 >, 0.363997, < 0, -12.990649, -2.835865 >, 0.361997 }
      sphere { < XX, -12.98973, -2.8369 >, 0.362 }
      cone  { < 0, -12.99052, -2.835743 >, 0.361997, < 0, -13.281996, -2.40892 >, 0.359997 }
      sphere { < XX, -13.28121, -2.41007 >, 0.36 }
      cone  { < 0, -13.281852, -2.408814 >, 0.359997, < 0, -13.514118, -1.954131 >, 0.357997 }
      sphere { < XX, -13.51348, -1.95538 >, 0.358 }
      cone  { < 0, -13.513961, -1.954044 >, 0.357997, < 0, -13.684688, -1.479532 >, 0.355997 }
      sphere { < XX, -13.68421, -1.48086 >, 0.356 }
      cone  { < 0, -13.68452, -1.479464 >, 0.355997, < 0, -13.792448, -0.993292 >, 0.353997 }
      sphere { < XX, -13.79214, -0.99468 >, 0.354 }
      cone  { < 0, -13.792272, -0.993246 >, 0.353997, < 0, -13.837201, -0.503564 >, 0.351997 }
      sphere { < XX, -13.83707, -0.50499 >, 0.352 }
      cone  { < 0, -13.837019, -0.503541 >, 0.351997, < 0, -13.819799, -0.018399 >, 0.349997 }
      sphere { < XX, -13.81985, -0.01984 >, 0.35 }
      cone  { < 0, -13.819614, -0.018398 >, 0.349997, < 0, -13.742085, 0.454463 >, 0.347997 }
      sphere { < XX, -13.74232, 0.45303 >, 0.348 }
      cone  { < 0, -13.7419, 0.45444 >, 0.347997, < 0, -13.606862, 0.907652 >, 0.345997 }
      sphere { < XX, -13.60728, 0.90625 >, 0.346 }
      cone  { < 0, -13.60668, 0.907606 >, 0.345997, < 0, -13.417833, 1.334308 >, 0.343997 }
      sphere { < XX, -13.41843, 1.33296 >, 0.344 }
      cone  { < 0, -13.417657, 1.334239 >, 0.343997, < 0, -13.179471, 1.728171 >, 0.341997 }
      sphere { < XX, -13.18024, 1.7269 >, 0.342 }
      cone  { < 0, -13.179303, 1.72808 >, 0.341997, < 0, -12.896979, 2.083713 >, 0.339997 }
      sphere { < XX, -12.89791, 2.08254 >, 0.34 }
      cone  { < 0, -12.896823, 2.0836 >, 0.339997, < 0, -12.576149, 2.396164 >, 0.337997 }
      sphere { < XX, -12.57723, 2.39511 >, 0.338 }
      cone  { < 0, -12.576007, 2.396031 >, 0.337997, < 0, -12.223264, 2.661595 >, 0.335997 }
      sphere { < XX, -12.22448, 2.66068 >, 0.336 }
      cone  { < 0, -12.223139, 2.661444 >, 0.335996, < 0, -11.844977, 2.87696 >, 0.333996 }
      sphere { < XX, -11.84631, 2.8762 >, 0.334 }
      cone  { < 0, -11.84487, 2.876793 >, 0.333996, < 0, -11.448209, 3.040149 >, 0.331996 }
      sphere { < XX, -11.44964, 3.03956 >, 0.332 }
      cone  { < 0, -11.448123, 3.039969 >, 0.331996, < 0, -11.039963, 3.149966 >, 0.329996 }
      sphere { < XX, -11.04147, 3.14956 >, 0.33 }
      cone  { < 0, -11.0399, 3.149775 >, 0.329996, < 0, -10.627279, 3.206143 >, 0.327996 }
      sphere { < XX, -10.62884, 3.20593 >, 0.328 }
      cone  { < 0, -10.627241, 3.205943 >, 0.327996, < 0, -10.217061, 3.209333 >, 0.325996 }
      sphere { < XX, -10.21865, 3.20932 >, 0.326 }
      cone  { < 0, -10.217047, 3.209128 >, 0.325996, < 0, -9.815997, 3.161049 >, 0.323996 }
      sphere { < XX, -9.81759, 3.16124 >, 0.324 }
      cone  { < 0, -9.81601, 3.160842 >, 0.323996, < 0, -9.43041, 3.063634 >, 0.321996 }
      sphere { < XX, -9.43198, 3.06403 >, 0.322 }
      cone  { < 0, -9.430449, 3.063428 >, 0.321996, < 0, -9.066198, 2.920202 >, 0.319996 }
      sphere { < XX, -9.06772, 2.9208 >, 0.32 }
      cone  { < 0, -9.066264, 2.92 >, 0.319996, < 0, -8.728713, 2.734535 >, 0.317996 }
      sphere { < XX, -8.73016, 2.73533 >, 0.318 }
      cone  { < 0, -8.728804, 2.734341 >, 0.317996, < 0, -8.422712, 2.511047 >, 0.315996 }
      sphere { < XX, -8.42406, 2.51203 >, 0.316 }
      cone  { < 0, -8.422829, 2.510864 >, 0.315995, < 0, -8.152256, 2.254651 >, 0.313995 }
      sphere { < XX, -8.15348, 2.25581 >, 0.314 }
      cone  { < 0, -8.152396, 2.254482 >, 0.313995, < 0, -7.920693, 1.970681 >, 0.311995 }
      sphere { < XX, -7.92177, 1.972 >, 0.312 }
      cone  { < 0, -7.920855, 1.970529 >, 0.311995, < 0, -7.730601, 1.664758 >, 0.309995 }
      sphere { < XX, -7.73151, 1.66622 >, 0.31 }
      cone  { < 0, -7.730782, 1.664626 >, 0.309995, < 0, -7.583757, 1.342737 >, 0.307995 }
      sphere { < XX, -7.58448, 1.34432 >, 0.308 }
      cone  { < 0, -7.583956, 1.342627 >, 0.307995, < 0, -7.481159, 1.010548 >, 0.305995 }
      sphere { < XX, -7.48168, 1.01223 >, 0.306 }
      cone  { < 0, -7.481373, 1.010464 >, 0.305995, < 0, -7.422985, 0.674115 >, 0.303995 }
      sphere { < XX, -7.42329, 0.67587 >, 0.304 }
      cone  { < 0, -7.423211, 0.674058 >, 0.303995, < 0, -7.408652, 0.33924 >, 0.301995 }
      sphere { < XX, -7.40873, 0.34104 >, 0.302 }
      cone  { < 0, -7.408886, 0.33921 >, 0.301994, < 0, -7.436835, 0.011492 >, 0.299994 }
      sphere { < XX, -7.43668, 0.01331 >, 0.3 }
      cone  { < 0, -7.437074, 0.011493 >, 0.299994, < 0, -7.505512, -0.303825 >, 0.297994 }
      sphere { < XX, -7.50512, -0.30202 >, 0.298 }
      cone  { < 0, -7.505753, -0.303794 >, 0.297994, < 0, -7.612018, -0.601842 >, 0.295994 }
      sphere { < XX, -7.61139, -0.60008 >, 0.296 }
      cone  { < 0, -7.612257, -0.60178 >, 0.295994, < 0, -7.753131, -0.878159 >, 0.293994 }
      sphere { < XX, -7.75227, -0.87647 >, 0.294 }
      cone  { < 0, -7.753363, -0.878066 >, 0.293994, < 0, -7.925095, -1.128875 >, 0.291994 }
      sphere { < XX, -7.92401, -1.12729 >, 0.292 }
      cone  { < 0, -7.925317, -1.128752 >, 0.291993, < 0, -8.123778, -1.350712 >, 0.289993 }
      sphere { < XX, -8.12248, -1.34926 >, 0.29 }
      cone  { < 0, -8.123986, -1.35056 >, 0.289993, < 0, -8.344706, -1.541011 >, 0.287993 }
      sphere { < XX, -8.34321, -1.53972 >, 0.288 }
      cone  { < 0, -8.344896, -1.54083 >, 0.287993, < 0, -8.583164, -1.697773 >, 0.285993 }
      sphere { < XX, -8.58149, -1.69667 >, 0.286 }
      cone  { < 0, -8.583333, -1.697567 >, 0.285993, < 0, -8.83431, -1.81967 >, 0.283993 }
      sphere { < XX, -8.83248, -1.81878 >, 0.284 }
      cone  { < 0, -8.834454, -1.819441 >, 0.283992, < 0, -9.09323, -1.906056 >, 0.281992 }
      sphere { < XX, -9.09127, -1.9054 >, 0.282 }
      cone  { < 0, -9.093345, -1.905806 >, 0.281992, < 0, -9.355091, -1.956953 >, 0.279992 }
      sphere { < XX, -9.35303, -1.95655 >, 0.28 }
      cone  { < 0, -9.355175, -1.956685 >, 0.279992, < 0, -9.61515, -1.973014 >, 0.277992 }
      sphere { < XX, -9.61302, -1.97288 >, 0.278 }
      cone  { < 0, -9.615201, -1.972732 >, 0.277991, < 0, -9.868926, -1.955533 >, 0.275991 }
      sphere { < XX, -9.86676, -1.95568 >, 0.276 }
      cone  { < 0, -9.868941, -1.955242 >, 0.275991, < 0, -10.112195, -1.906345 >, 0.273991 }
      sphere { < XX, -10.11003, -1.90678 >, 0.274 }
      cone  { < 0, -10.112173, -1.906048 >, 0.273991, < 0, -10.341108, -1.827813 >, 0.271991 }
      sphere { < XX, -10.33898, -1.82854 >, 0.272 }
      cone  { < 0, -10.341047, -1.827515 >, 0.27199, < 0, -10.552252, -1.722732 >, 0.26999 }
      sphere { < XX, -10.5502, -1.72375 >, 0.27 }
      cone  { < 0, -10.552151, -1.722438 >, 0.26999, < 0, -10.742677, -1.594307 >, 0.26799 }
      sphere { < XX, -10.74074, -1.59561 >, 0.268 }
      cone  { < 0, -10.742537, -1.594021 >, 0.267989, < 0, -10.909954, -1.446043 >, 0.265989 }
      sphere { < XX, -10.90817, -1.44762 >, 0.266 }
      cone  { < 0, -10.909774, -1.445771 >, 0.265989, < 0, -11.052202, -1.281645 >, 0.263989 }
      sphere { < XX, -11.05061, -1.28348 >, 0.264 }
      cone  { < 0, -11.051985, -1.281392 >, 0.263988, < 0, -11.168094, -1.105017 >, 0.261988 }
      sphere { < XX, -11.16673, -1.10709 >, 0.262 }
      cone  { < 0, -11.16784, -1.104788 >, 0.261988, < 0, -11.256871, -0.920096 >, 0.259988 }
      sphere { < XX, -11.25577, -0.92238 >, 0.26 }
      cone  { < 0, -11.256582, -0.919896 >, 0.259987, < 0, -11.318366, -0.730805 >, 0.257987 }
      sphere { < XX, -11.31756, -0.73327 >, 0.258 }
      cone  { < 0, -11.318044, -0.730638 >, 0.257986, < 0, -11.35292, -0.540999 >, 0.255986 }
      sphere { < XX, -11.35244, -0.54361 >, 0.256 }
      cone  { < 0, -11.35257, -0.540871 >, 0.255985, < 0, -11.361419, -0.354353 >, 0.253985 }
      sphere { < XX, -11.36129, -0.35707 >, 0.254 }
      cone  { < 0, -11.361044, -0.354269 >, 0.253984, < 0, -11.345226, -0.174301 >, 0.251985 }
      sphere { < XX, -11.34547, -0.17708 >, 0.252 }
      cone  { < 0, -11.344831, -0.174265 >, 0.251983, < 0, -11.306166, -0.003998 >, 0.249984 }
      sphere { < XX, -11.3068, -0.00679 >, 0.25 }
      cone  { < 0, -11.305756, -0.004014 >, 0.249982, < 0, -11.246414, 0.153764 >, 0.247983 }
      sphere { < XX, -11.24745, 0.15101 >, 0.248 }
      cone  { < 0, -11.245995, 0.153692 >, 0.247981, < 0, -11.168497, 0.29658 >, 0.245981 }
      sphere { < XX, -11.16994, 0.29392 >, 0.246 }
      cone  { < 0, -11.168076, 0.296449 >, 0.24598, < 0, -11.075201, 0.422489 >, 0.24398 }
      sphere { < XX, -11.07705, 0.41998 >, 0.244 }
      cone  { < 0, -11.074785, 0.422297 >, 0.243978, < 0, -10.969503, 0.529968 >, 0.241979 }
      sphere { < XX, -10.97175, 0.52767 >, 0.242 }
      cone  { < 0, -10.9691, 0.529711 >, 0.241977, < 0, -10.854502, 0.617995 >, 0.239977 }
      sphere { < XX, -10.85713, 0.61597 >, 0.24 }
      cone  { < 0, -10.85412, 0.617674 >, 0.239975, < 0, -10.733375, 0.686009 >, 0.237975 }
      sphere { < XX, -10.73636, 0.68432 >, 0.238 }
      cone  { < 0, -10.733024, 0.685622 >, 0.237973, < 0, -10.609232, 0.733951 >, 0.235973 }
      sphere { < XX, -10.61254, 0.73266 >, 0.236 }
      cone  { < 0, -10.608922, 0.733499 >, 0.235971, < 0, -10.485152, 0.762181 >, 0.233971 }
      sphere { < XX, -10.48874, 0.76135 >, 0.234 }
      cone  { < 0, -10.484895, 0.761664 >, 0.233968, < 0, -10.364008, 0.771552 >, 0.231968 }
      sphere { < XX, -10.36782, 0.77124 >, 0.232 }
      cone  { < 0, -10.363815, 0.770973 >, 0.231965, < 0, -10.248509, 0.763275 >, 0.229966 }
      sphere { < XX, -10.25248, 0.76354 >, 0.23 }
      cone  { < 0, -10.248394, 0.762638 >, 0.229962, < 0, -10.14107, 0.738946 >, 0.227962 }
      sphere { < XX, -10.14512, 0.73984 >, 0.228 }
      cone  { < 0, -10.141047, 0.738258 >, 0.227958, < 0, -10.043793, 0.700482 >, 0.225959 }
      sphere { < XX, -10.04783, 0.70205 >, 0.226 }
      cone  { < 0, -10.043879, 0.699751 >, 0.225954, < 0, -9.958444, 0.650052 >, 0.223954 }
      sphere { < XX, -9.96236, 0.65233 >, 0.224 }
      cone  { < 0, -9.958655, 0.649292 >, 0.223949, < 0, -9.886388, 0.590039 >, 0.221949 }
      sphere { < XX, -9.89006, 0.59305 >, 0.222 }
      cone  { < 0, -9.886742, 0.589267 >, 0.221943, < 0, -9.828592, 0.522961 >, 0.219943 }
      sphere { < XX, -9.83188, 0.52671 >, 0.22 }
      cone  { < 0, -9.829108, 0.5222 >, 0.219936, < 0, -9.785613, 0.451431 >, 0.217937 }
      sphere { < XX, -9.78836, 0.4559 >, 0.218 }
      cone  { < 0, -9.786309, 0.450714 >, 0.217929, < 0, -9.757567, 0.378062 >, 0.215929 }
      sphere { < XX, -9.7596, 0.3832 >, 0.216 }
      cone  { < 0, -9.758455, 0.377431 >, 0.21592, < 0, -9.744165, 0.305444 >, 0.213921 }
      sphere { < XX, -9.7453, 0.31116 >, 0.214 }
      cone  { < 0, -9.745252, 0.304956 >, 0.21391, < 0, -9.744723, 0.236034 >, 0.211911 }
      sphere { < XX, -9.74477, 0.24218 >, 0.212 }
      cone  { < 0, -9.745999, 0.235754 >, 0.211899, < 0, -9.758157, 0.172164 >, 0.2099 }
      sphere { < XX, -9.75694, 0.17853 >, 0.21 }
      cone  { < 0, -9.759588, 0.172174 >, 0.209887, < 0, -9.783023, 0.115925 >, 0.207888 }
      sphere { < XX, -9.7804, 0.12222 >, 0.208 }
      cone  { < 0, -9.784536, 0.116308 >, 0.207875, < 0, -9.817547, 0.069125 >, 0.205876 }
      sphere { < XX, -9.81345, 0.07498 >, 0.206 }
      cone  { < 0, -9.819031, 0.069944 >, 0.205863, < 0, -9.859666, 0.033273 >, 0.203864 }
      sphere { < XX, -9.85414, 0.03826 >, 0.204 }
      cone  { < 0, -9.860955, 0.03455 >, 0.203852, < 0, -9.907068, 0.009446 >, 0.201854 }
      sphere { < XX, -9.90032, 0.01312 >, 0.202 }
      cone  { < 0, -9.907978, 0.011127 >, 0.201845, < 0, -9.957312, -0.001713 >, 0.199846 }
      sphere { < XX, -9.94973, 0.00026 >, 0.2 }
      texture { Creature_Prob_Txtr }
   }

//THESE OBJECTS GENERATED BY SPIKE V1.0a - BOB CRAWFORD

#declare Creature_Body =
union {
sphere{<0, 0, 0>,10}
cone {
<0.0000 ,0.0000 ,10.0000>, 0.3000
<0.0000 ,0.0000 ,14.0000>, 0.1000
}
cone {
<0.0017 ,0.0130 ,10.0000>, 0.3000
<0.0024 ,0.0182 ,14.0000>, 0.1000
}
cone {
<0.0068 ,0.0253 ,10.0000>, 0.3000
<0.0095 ,0.0354 ,14.0000>, 0.1000
}
cone {
<0.0150 ,0.0363 ,9.9999>, 0.3000
<0.0210 ,0.0508 ,13.9999>, 0.1000
}
cone {
<0.0262 ,0.0453 ,9.9999>, 0.3000
<0.0367 ,0.0635 ,13.9998>, 0.1000
}
cone {
<0.0398 ,0.0519 ,9.9998>, 0.3000
<0.0558 ,0.0727 ,13.9997>, 0.1000
}
cone {
<0.0555 ,0.0555 ,9.9997>, 0.3000
<0.0777 ,0.0777 ,13.9996>, 0.1000
}
cone {
<0.0727 ,0.0558 ,9.9996>, 0.3000
<0.1018 ,0.0781 ,13.9994>, 0.1000
}
cone {
<0.0907 ,0.0524 ,9.9995>, 0.3000
<0.1270 ,0.0733 ,13.9992>, 0.1000
}
cone {
<0.1088 ,0.0451 ,9.9993>, 0.3000
<0.1524 ,0.0631 ,13.9990>, 0.1000
}
cone {
<0.1264 ,0.0339 ,9.9991>, 0.3000
<0.1770 ,0.0474 ,13.9988>, 0.1000
}
cone {
<0.1428 ,0.0188 ,9.9990>, 0.3000
<0.1999 ,0.0263 ,13.9985>, 0.1000
}
cone {
<0.1571 ,-0.0000 ,9.9988>, 0.3000
<0.2199 ,-0.0000 ,13.9983>, 0.1000
}
cone {
<0.1687 ,-0.0222 ,9.9986>, 0.3000
<0.2362 ,-0.0311 ,13.9980>, 0.1000
}
cone {
<0.1770 ,-0.0474 ,9.9983>, 0.3000
<0.2478 ,-0.0664 ,13.9976>, 0.1000
}
cone {
<0.1814 ,-0.0751 ,9.9981>, 0.3000
<0.2539 ,-0.1052 ,13.9973>, 0.1000
}
cone {
<0.1814 ,-0.1047 ,9.9978>, 0.3000
<0.2539 ,-0.1466 ,13.9969>, 0.1000
}
cone {
<0.1765 ,-0.1355 ,9.9975>, 0.3000
<0.2471 ,-0.1896 ,13.9965>, 0.1000
}
cone {
<0.1666 ,-0.1666 ,9.9972>, 0.3000
<0.2332 ,-0.2332 ,13.9961>, 0.1000
}
cone {
<0.1514 ,-0.1973 ,9.9969>, 0.3000
<0.2119 ,-0.2762 ,13.9957>, 0.1000
}
cone {
<0.1309 ,-0.2267 ,9.9966>, 0.3000
<0.1832 ,-0.3174 ,13.9952>, 0.1000
}
cone {
<0.1052 ,-0.2539 ,9.9962>, 0.3000
<0.1473 ,-0.3555 ,13.9947>, 0.1000
}
cone {
<0.0745 ,-0.2781 ,9.9959>, 0.3000
<0.1043 ,-0.3894 ,13.9942>, 0.1000
}
cone {
<0.0393 ,-0.2984 ,9.9955>, 0.3000
<0.0550 ,-0.4178 ,13.9937>, 0.1000
}
cone {
<-0.0000 ,-0.3141 ,9.9951>, 0.3000
<-0.0000 ,-0.4398 ,13.9931>, 0.1000
}
cone {
<-0.0427 ,-0.3244 ,9.9946>, 0.3000
<-0.0598 ,-0.4541 ,13.9925>, 0.1000
}
cone {
<-0.0881 ,-0.3287 ,9.9942>, 0.3000
<-0.1233 ,-0.4602 ,13.9919>, 0.1000
}
cone {
<-0.1352 ,-0.3265 ,9.9938>, 0.3000
<-0.1893 ,-0.4570 ,13.9913>, 0.1000
}
cone {
<-0.1832 ,-0.3173 ,9.9933>, 0.3000
<-0.2565 ,-0.4443 ,13.9906>, 0.1000
}
cone {
<-0.2310 ,-0.3011 ,9.9928>, 0.3000
<-0.3235 ,-0.4215 ,13.9899>, 0.1000
}
cone {
<-0.2776 ,-0.2776 ,9.9923>, 0.3000
<-0.3887 ,-0.3887 ,13.9892>, 0.1000
}
cone {
<-0.3218 ,-0.2470 ,9.9918>, 0.3000
<-0.4506 ,-0.3457 ,13.9885>, 0.1000
}
cone {
<-0.3627 ,-0.2094 ,9.9912>, 0.3000
<-0.5077 ,-0.2931 ,13.9877>, 0.1000
}
cone {
<-0.3990 ,-0.1653 ,9.9907>, 0.3000
<-0.5585 ,-0.2314 ,13.9869>, 0.1000
}
cone {
<-0.4298 ,-0.1152 ,9.9901>, 0.3000
<-0.6017 ,-0.1612 ,13.9861>, 0.1000
}
cone {
<-0.4541 ,-0.0598 ,9.9895>, 0.3000
<-0.6357 ,-0.0837 ,13.9853>, 0.1000
}
cone {
<-0.4711 ,0.0000 ,9.9889>, 0.3000
<-0.6595 ,0.0000 ,13.9845>, 0.1000
}
cone {
<-0.4800 ,0.0632 ,9.9883>, 0.3000
<-0.6720 ,0.0885 ,13.9836>, 0.1000
}
cone {
<-0.4803 ,0.1287 ,9.9876>, 0.3000
<-0.6724 ,0.1802 ,13.9827>, 0.1000
}
cone {
<-0.4714 ,0.1953 ,9.9870>, 0.3000
<-0.6600 ,0.2734 ,13.9818>, 0.1000
}
cone {
<-0.4532 ,0.2617 ,9.9863>, 0.3000
<-0.6345 ,0.3664 ,13.9808>, 0.1000
}
cone {
<-0.4256 ,0.3266 ,9.9856>, 0.3000
<-0.5958 ,0.4572 ,13.9798>, 0.1000
}
cone {
<-0.3886 ,0.3886 ,9.9849>, 0.3000
<-0.5440 ,0.5440 ,13.9788>, 0.1000
}
cone {
<-0.3425 ,0.4463 ,9.9842>, 0.3000
<-0.4795 ,0.6248 ,13.9778>, 0.1000
}
cone {
<-0.2878 ,0.4985 ,9.9834>, 0.3000
<-0.4029 ,0.6979 ,13.9768>, 0.1000
}
cone {
<-0.2253 ,0.5439 ,9.9827>, 0.3000
<-0.3154 ,0.7615 ,13.9757>, 0.1000
}
cone {
<-0.1557 ,0.5813 ,9.9819>, 0.3000
<-0.2180 ,0.8138 ,13.9746>, 0.1000
}
cone {
<-0.0803 ,0.6096 ,9.9811>, 0.3000
<-0.1124 ,0.8534 ,13.9735>, 0.1000
}
cone {
<0.0000 ,0.6279 ,9.9803>, 0.3000
<0.0000 ,0.8791 ,13.9724>, 0.1000
}
cone {
<0.0837 ,0.6355 ,9.9794>, 0.3000
<0.1171 ,0.8897 ,13.9712>, 0.1000
}
cone {
<0.1693 ,0.6317 ,9.9786>, 0.3000
<0.2370 ,0.8844 ,13.9700>, 0.1000
}
cone {
<0.2553 ,0.6163 ,9.9777>, 0.3000
<0.3574 ,0.8628 ,13.9688>, 0.1000
}
cone {
<0.3401 ,0.5890 ,9.9768>, 0.3000
<0.4761 ,0.8246 ,13.9676>, 0.1000
}
cone {
<0.4220 ,0.5500 ,9.9759>, 0.3000
<0.5908 ,0.7699 ,13.9663>, 0.1000
}
cone {
<0.4994 ,0.4994 ,9.9750>, 0.3000
<0.6992 ,0.6992 ,13.9650>, 0.1000
}
cone {
<0.5707 ,0.4379 ,9.9741>, 0.3000
<0.7990 ,0.6131 ,13.9637>, 0.1000
}
cone {
<0.6343 ,0.3662 ,9.9731>, 0.3000
<0.8880 ,0.5127 ,13.9624>, 0.1000
}
cone {
<0.6887 ,0.2853 ,9.9722>, 0.3000
<0.9642 ,0.3994 ,13.9610>, 0.1000
}
cone {
<0.7326 ,0.1963 ,9.9712>, 0.3000
<1.0257 ,0.2748 ,13.9597>, 0.1000
}
cone {
<0.7649 ,0.1007 ,9.9702>, 0.3000
<1.0709 ,0.1410 ,13.9583>, 0.1000
}
cone {
<0.7846 ,-0.0000 ,9.9692>, 0.3000
<1.0984 ,-0.0000 ,13.9568>, 0.1000
}
cone {
<0.7908 ,-0.1041 ,9.9681>, 0.3000
<1.1071 ,-0.1458 ,13.9554>, 0.1000
}
cone {
<0.7831 ,-0.2098 ,9.9671>, 0.3000
<1.0963 ,-0.2938 ,13.9539>, 0.1000
}
cone {
<0.7610 ,-0.3152 ,9.9660>, 0.3000
<1.0654 ,-0.4413 ,13.9524>, 0.1000
}
cone {
<0.7247 ,-0.4184 ,9.9649>, 0.3000
<1.0145 ,-0.5857 ,13.9509>, 0.1000
}
cone {
<0.6742 ,-0.5173 ,9.9638>, 0.3000
<0.9439 ,-0.7243 ,13.9494>, 0.1000
}
cone {
<0.6101 ,-0.6101 ,9.9627>, 0.3000
<0.8542 ,-0.8542 ,13.9478>, 0.1000
}
cone {
<0.5332 ,-0.6949 ,9.9616>, 0.3000
<0.7465 ,-0.9729 ,13.9462>, 0.1000
}
cone {
<0.4445 ,-0.7698 ,9.9604>, 0.3000
<0.6223 ,-1.0778 ,13.9446>, 0.1000
}
cone {
<0.3452 ,-0.8333 ,9.9592>, 0.3000
<0.4832 ,-1.1667 ,13.9429>, 0.1000
}
cone {
<0.2368 ,-0.8838 ,9.9580>, 0.3000
<0.3316 ,-1.2374 ,13.9413>, 0.1000
}
cone {
<0.1211 ,-0.9201 ,9.9568>, 0.3000
<0.1696 ,-1.2882 ,13.9396>, 0.1000
}
cone {
<0.0000 ,-0.9411 ,9.9556>, 0.3000
<0.0000 ,-1.3175 ,13.9379>, 0.1000
}
cone {
<-0.1245 ,-0.9460 ,9.9544>, 0.3000
<-0.1744 ,-1.3243 ,13.9361>, 0.1000
}
cone {
<-0.2503 ,-0.9342 ,9.9531>, 0.3000
<-0.3504 ,-1.3079 ,13.9344>, 0.1000
}
cone {
<-0.3751 ,-0.9056 ,9.9518>, 0.3000
<-0.5251 ,-1.2678 ,13.9326>, 0.1000
}
cone {
<-0.4966 ,-0.8601 ,9.9506>, 0.3000
<-0.6952 ,-1.2042 ,13.9308>, 0.1000
}
cone {
<-0.6125 ,-0.7983 ,9.9492>, 0.3000
<-0.8576 ,-1.1176 ,13.9289>, 0.1000
}
cone {
<-0.7207 ,-0.7207 ,9.9479>, 0.3000
<-1.0090 ,-1.0090 ,13.9271>, 0.1000
}
cone {
<-0.8189 ,-0.6284 ,9.9466>, 0.3000
<-1.1465 ,-0.8798 ,13.9252>, 0.1000
}
cone {
<-0.9052 ,-0.5226 ,9.9452>, 0.3000
<-1.2673 ,-0.7317 ,13.9233>, 0.1000
}
cone {
<-0.9777 ,-0.4050 ,9.9438>, 0.3000
<-1.3688 ,-0.5670 ,13.9214>, 0.1000
}
cone {
<-1.0348 ,-0.2773 ,9.9424>, 0.3000
<-1.4487 ,-0.3882 ,13.9194>, 0.1000
}
cone {
<-1.0751 ,-0.1415 ,9.9410>, 0.3000
<-1.5051 ,-0.1982 ,13.9175>, 0.1000
}
cone {
<-1.0973 ,-0.0000 ,9.9396>, 0.3000
<-1.5363 ,-0.0000 ,13.9155>, 0.1000
}
cone {
<-1.1009 ,0.1449 ,9.9382>, 0.3000
<-1.5412 ,0.2029 ,13.9134>, 0.1000
}
cone {
<-1.0851 ,0.2907 ,9.9367>, 0.3000
<-1.5191 ,0.4070 ,13.9114>, 0.1000
}
cone {
<-1.0499 ,0.4349 ,9.9352>, 0.3000
<-1.4698 ,0.6088 ,13.9093>, 0.1000
}
cone {
<-0.9954 ,0.5747 ,9.9337>, 0.3000
<-1.3935 ,0.8046 ,13.9072>, 0.1000
}
cone {
<-0.9222 ,0.7076 ,9.9322>, 0.3000
<-1.2910 ,0.9906 ,13.9051>, 0.1000
}
cone {
<-0.8311 ,0.8311 ,9.9307>, 0.3000
<-1.1636 ,1.1636 ,13.9030>, 0.1000
}
cone {
<-0.7234 ,0.9428 ,9.9291>, 0.3000
<-1.0128 ,1.3199 ,13.9008>, 0.1000
}
cone {
<-0.6007 ,1.0404 ,9.9276>, 0.3000
<-0.8410 ,1.4566 ,13.8986>, 0.1000
}
cone {
<-0.4647 ,1.1219 ,9.9260>, 0.3000
<-0.6506 ,1.5707 ,13.8964>, 0.1000
}
cone {
<-0.3177 ,1.1855 ,9.9244>, 0.3000
<-0.4447 ,1.6597 ,13.8942>, 0.1000
}
cone {
<-0.1619 ,1.2297 ,9.9228>, 0.3000
<-0.2267 ,1.7216 ,13.8919>, 0.1000
}
cone {
<-0.0000 ,1.2533 ,9.9211>, 0.3000
<-0.0000 ,1.7547 ,13.8896>, 0.1000
}
cone {
<0.1653 ,1.2555 ,9.9195>, 0.3000
<0.2314 ,1.7577 ,13.8873>, 0.1000
}
cone {
<0.3311 ,1.2357 ,9.9178>, 0.3000
<0.4635 ,1.7300 ,13.8850>, 0.1000
}
cone {
<0.4945 ,1.1939 ,9.9161>, 0.3000
<0.6923 ,1.6715 ,13.8826>, 0.1000
}
cone {
<0.6526 ,1.1304 ,9.9144>, 0.3000
<0.9137 ,1.5826 ,13.8802>, 0.1000
}
cone {
<0.8025 ,1.0458 ,9.9127>, 0.3000
<1.1235 ,1.4642 ,13.8778>, 0.1000
}
cone {
<0.9413 ,0.9413 ,9.9110>, 0.3000
<1.3178 ,1.3178 ,13.8754>, 0.1000
}
cone {
<1.0664 ,0.8183 ,9.9092>, 0.3000
<1.4930 ,1.1456 ,13.8729>, 0.1000
}
cone {
<1.1753 ,0.6786 ,9.9075>, 0.3000
<1.6455 ,0.9500 ,13.8705>, 0.1000
}
cone {
<1.2658 ,0.5243 ,9.9057>, 0.3000
<1.7722 ,0.7341 ,13.8680>, 0.1000
}
cone {
<1.3360 ,0.3580 ,9.9039>, 0.3000
<1.8703 ,0.5012 ,13.8654>, 0.1000
}
cone {
<1.3841 ,0.1822 ,9.9021>, 0.3000
<1.9377 ,0.2551 ,13.8629>, 0.1000
}
cone {
<1.4090 ,0.0000 ,9.9002>, 0.3000
<1.9726 ,0.0000 ,13.8603>, 0.1000
}
cone {
<1.4098 ,-0.1856 ,9.8984>, 0.3000
<1.9737 ,-0.2598 ,13.8577>, 0.1000
}
cone {
<1.3860 ,-0.3714 ,9.8965>, 0.3000
<1.9404 ,-0.5199 ,13.8551>, 0.1000
}
cone {
<1.3377 ,-0.5541 ,9.8946>, 0.3000
<1.8727 ,-0.7757 ,13.8525>, 0.1000
}
cone {
<1.2651 ,-0.7304 ,9.8927>, 0.3000
<1.7712 ,-1.0226 ,13.8498>, 0.1000
}
cone {
<1.1692 ,-0.8972 ,9.8908>, 0.3000
<1.6369 ,-1.2560 ,13.8471>, 0.1000
}
cone {
<1.0513 ,-1.0513 ,9.8889>, 0.3000
<1.4718 ,-1.4718 ,13.8444>, 0.1000
}
cone {
<0.9130 ,-1.1898 ,9.8869>, 0.3000
<1.2781 ,-1.6657 ,13.8417>, 0.1000
}
cone {
<0.7563 ,-1.3099 ,9.8849>, 0.3000
<1.0588 ,-1.8339 ,13.8389>, 0.1000
}
cone {
<0.5838 ,-1.4094 ,9.8830>, 0.3000
<0.8173 ,-1.9732 ,13.8361>, 0.1000
}
cone {
<0.3982 ,-1.4861 ,9.8809>, 0.3000
<0.5575 ,-2.0805 ,13.8333>, 0.1000
}
cone {
<0.2025 ,-1.5381 ,9.8789>, 0.3000
<0.2835 ,-2.1534 ,13.8305>, 0.1000
}
cone {
<0.0000 ,-1.5643 ,9.8769>, 0.3000
<0.0000 ,-2.1901 ,13.8276>, 0.1000
}
cone {
<-0.2059 ,-1.5638 ,9.8748>, 0.3000
<-0.2882 ,-2.1893 ,13.8248>, 0.1000
}
cone {
<-0.4116 ,-1.5360 ,9.8728>, 0.3000
<-0.5762 ,-2.1504 ,13.8219>, 0.1000
}
cone {
<-0.6135 ,-1.4811 ,9.8707>, 0.3000
<-0.8589 ,-2.0735 ,13.8189>, 0.1000
}
cone {
<-0.8080 ,-1.3995 ,9.8686>, 0.3000
<-1.1312 ,-1.9594 ,13.8160>, 0.1000
}
cone {
<-0.9916 ,-1.2924 ,9.8664>, 0.3000
<-1.3883 ,-1.8093 ,13.8130>, 0.1000
}
cone {
<-1.1610 ,-1.1610 ,9.8643>, 0.3000
<-1.6253 ,-1.6254 ,13.8100>, 0.1000
}
cone {
<-1.3128 ,-1.0074 ,9.8621>, 0.3000
<-1.8379 ,-1.4103 ,13.8070>, 0.1000
}
cone {
<-1.4442 ,-0.8339 ,9.8600>, 0.3000
<-2.0219 ,-1.1674 ,13.8039>, 0.1000
}
cone {
<-1.5527 ,-0.6432 ,9.8578>, 0.3000
<-2.1737 ,-0.9004 ,13.8009>, 0.1000
}
cone {
<-1.6358 ,-0.4383 ,9.8556>, 0.3000
<-2.2901 ,-0.6137 ,13.7978>, 0.1000
}
cone {
<-1.6918 ,-0.2228 ,9.8533>, 0.3000
<-2.3685 ,-0.3119 ,13.7947>, 0.1000
}
cone {
<-1.7193 ,-0.0000 ,9.8511>, 0.3000
<-2.4070 ,-0.0000 ,13.7915>, 0.1000
}
cone {
<-1.7174 ,0.2261 ,9.8488>, 0.3000
<-2.4043 ,0.3165 ,13.7884>, 0.1000
}
cone {
<-1.6856 ,0.4516 ,9.8466>, 0.3000
<-2.3599 ,0.6323 ,13.7852>, 0.1000
}
cone {
<-1.6242 ,0.6727 ,9.8443>, 0.3000
<-2.2738 ,0.9418 ,13.7820>, 0.1000
}
cone {
<-1.5336 ,0.8854 ,9.8420>, 0.3000
<-2.1471 ,1.2396 ,13.7787>, 0.1000
}
cone {
<-1.4151 ,1.0858 ,9.8396>, 0.3000
<-1.9812 ,1.5202 ,13.7755>, 0.1000
}
cone {
<-1.2704 ,1.2704 ,9.8373>, 0.3000
<-1.7786 ,1.7785 ,13.7722>, 0.1000
}
cone {
<-1.1016 ,1.4355 ,9.8349>, 0.3000
<-1.5422 ,2.0098 ,13.7689>, 0.1000
}
cone {
<-0.9112 ,1.5782 ,9.8326>, 0.3000
<-1.2757 ,2.2095 ,13.7656>, 0.1000
}
cone {
<-0.7023 ,1.6955 ,9.8302>, 0.3000
<-0.9833 ,2.3737 ,13.7622>, 0.1000
}
cone {
<-0.4784 ,1.7851 ,9.8277>, 0.3000
<-0.6697 ,2.4991 ,13.7588>, 0.1000
}
cone {
<-0.2429 ,1.8450 ,9.8253>, 0.3000
<-0.3401 ,2.5830 ,13.7554>, 0.1000
}
cone {
<-0.0000 ,1.8738 ,9.8229>, 0.3000
<-0.0001 ,2.6233 ,13.7520>, 0.1000
}
cone {
<0.2462 ,1.8705 ,9.8204>, 0.3000
<0.3447 ,2.6187 ,13.7486>, 0.1000
}
cone {
<0.4916 ,1.8348 ,9.8179>, 0.3000
<0.6882 ,2.5687 ,13.7451>, 0.1000
}
cone {
<0.7318 ,1.7668 ,9.8154>, 0.3000
<1.0245 ,2.4735 ,13.7416>, 0.1000
}
cone {
<0.9626 ,1.6673 ,9.8129>, 0.3000
<1.3476 ,2.3342 ,13.7381>, 0.1000
}
cone {
<1.1798 ,1.5376 ,9.8104>, 0.3000
<1.6517 ,2.1526 ,13.7346>, 0.1000
}
cone {
<1.3795 ,1.3795 ,9.8079>, 0.3000
<1.9313 ,1.9313 ,13.7310>, 0.1000
}
cone {
<1.5579 ,1.1955 ,9.8053>, 0.3000
<2.1811 ,1.6737 ,13.7274>, 0.1000
}
cone {
<1.7117 ,0.9883 ,9.8027>, 0.3000
<2.3964 ,1.3837 ,13.7238>, 0.1000
}
cone {
<1.8379 ,0.7614 ,9.8001>, 0.3000
<2.5731 ,1.0659 ,13.7202>, 0.1000
}
cone {
<1.9340 ,0.5183 ,9.7975>, 0.3000
<2.7076 ,0.7256 ,13.7165>, 0.1000
}
cone {
<1.9978 ,0.2631 ,9.7949>, 0.3000
<2.7969 ,0.3683 ,13.7128>, 0.1000
}
cone {
<2.0279 ,0.0000 ,9.7922>, 0.3000
<2.8390 ,0.0001 ,13.7091>, 0.1000
}
cone {
<2.0232 ,-0.2663 ,9.7896>, 0.3000
<2.8325 ,-0.3728 ,13.7054>, 0.1000
}
cone {
<1.9835 ,-0.5314 ,9.7869>, 0.3000
<2.7770 ,-0.7440 ,13.7016>, 0.1000
}
cone {
<1.9090 ,-0.7907 ,9.7842>, 0.3000
<2.6727 ,-1.1070 ,13.6979>, 0.1000
}
cone {
<1.8006 ,-1.0395 ,9.7815>, 0.3000
<2.5208 ,-1.4553 ,13.6941>, 0.1000
}
cone {
<1.6597 ,-1.2734 ,9.7787>, 0.3000
<2.3235 ,-1.7828 ,13.6902>, 0.1000
}
cone {
<1.4883 ,-1.4882 ,9.7760>, 0.3000
<2.0836 ,-2.0835 ,13.6864>, 0.1000
}
cone {
<1.2891 ,-1.6799 ,9.7732>, 0.3000
<1.8047 ,-2.3519 ,13.6825>, 0.1000
}
cone {
<1.0652 ,-1.8449 ,9.7705>, 0.3000
<1.4913 ,-2.5828 ,13.6786>, 0.1000
}
cone {
<0.8202 ,-1.9799 ,9.7677>, 0.3000
<1.1482 ,-2.7719 ,13.6747>, 0.1000
}
cone {
<0.5580 ,-2.0824 ,9.7648>, 0.3000
<0.7813 ,-2.9154 ,13.6708>, 0.1000
}
cone {
<0.2831 ,-2.1501 ,9.7620>, 0.3000
<0.3964 ,-3.0101 ,13.6668>, 0.1000
}
cone {
<0.0001 ,-2.1814 ,9.7592>, 0.3000
<0.0001 ,-3.0540 ,13.6628>, 0.1000
}
cone {
<-0.2863 ,-2.1754 ,9.7563>, 0.3000
<-0.4009 ,-3.0456 ,13.6588>, 0.1000
}
cone {
<-0.5711 ,-2.1318 ,9.7534>, 0.3000
<-0.7996 ,-2.9845 ,13.6548>, 0.1000
}
cone {
<-0.8494 ,-2.0508 ,9.7505>, 0.3000
<-1.1892 ,-2.8711 ,13.6507>, 0.1000
}
cone {
<-1.1162 ,-1.9334 ,9.7476>, 0.3000
<-1.5627 ,-2.7068 ,13.6467>, 0.1000
}
cone {
<-1.3668 ,-1.7813 ,9.7447>, 0.3000
<-1.9135 ,-2.4938 ,13.6426>, 0.1000
}
cone {
<-1.5966 ,-1.5967 ,9.7417>, 0.3000
<-2.2353 ,-2.2354 ,13.6384>, 0.1000
}
cone {
<-1.8015 ,-1.3824 ,9.7388>, 0.3000
<-2.5221 ,-1.9354 ,13.6343>, 0.1000
}
cone {
<-1.9775 ,-1.1418 ,9.7358>, 0.3000
<-2.7686 ,-1.5985 ,13.6301>, 0.1000
}
cone {
<-2.1214 ,-0.8788 ,9.7328>, 0.3000
<-2.9700 ,-1.2303 ,13.6259>, 0.1000
}
cone {
<-2.2303 ,-0.5977 ,9.7298>, 0.3000
<-3.1224 ,-0.8367 ,13.6217>, 0.1000
}
cone {
<-2.3018 ,-0.3031 ,9.7267>, 0.3000
<-3.2226 ,-0.4244 ,13.6174>, 0.1000
}
cone {
<-2.3345 ,-0.0001 ,9.7237>, 0.3000
<-3.2682 ,-0.0001 ,13.6132>, 0.1000
}
cone {
<-2.3271 ,0.3063 ,9.7206>, 0.3000
<-3.2579 ,0.4288 ,13.6089>, 0.1000
}
cone {
<-2.2795 ,0.6107 ,9.7176>, 0.3000
<-3.1913 ,0.8550 ,13.6046>, 0.1000
}
cone {
<-2.1920 ,0.9079 ,9.7145>, 0.3000
<-3.0689 ,1.2710 ,13.6002>, 0.1000
}
cone {
<-2.0658 ,1.1926 ,9.7113>, 0.3000
<-2.8921 ,1.6696 ,13.5959>, 0.1000
}
cone {
<-1.9025 ,1.4598 ,9.7082>, 0.3000
<-2.6636 ,2.0437 ,13.5915>, 0.1000
}
cone {
<-1.7047 ,1.7046 ,9.7051>, 0.3000
<-2.3866 ,2.3864 ,13.5871>, 0.1000
}
cone {
<-1.4754 ,1.9226 ,9.7019>, 0.3000
<-2.0655 ,2.6916 ,13.5827>, 0.1000
}
cone {
<-1.2181 ,2.1097 ,9.6987>, 0.3000
<-1.7054 ,2.9536 ,13.5782>, 0.1000
}
cone {
<-0.9372 ,2.2624 ,9.6955>, 0.3000
<-1.3121 ,3.1674 ,13.5737>, 0.1000
}
cone {
<-0.6372 ,2.3776 ,9.6923>, 0.3000
<-0.8920 ,3.3287 ,13.5692>, 0.1000
}
cone {
<-0.3230 ,2.4530 ,9.6891>, 0.3000
<-0.4522 ,3.4343 ,13.5647>, 0.1000
}
cone {
<-0.0001 ,2.4869 ,9.6858>, 0.3000
<-0.0001 ,3.4817 ,13.5602>, 0.1000
}
cone {
<0.3262 ,2.4782 ,9.6826>, 0.3000
<0.4566 ,3.4695 ,13.5556>, 0.1000
}
cone {
<0.6501 ,2.4267 ,9.6793>, 0.3000
<0.9102 ,3.3973 ,13.5510>, 0.1000
}
cone {
<0.9662 ,2.3327 ,9.6760>, 0.3000
<1.3526 ,3.2658 ,13.5464>, 0.1000
}
cone {
<1.2687 ,2.1977 ,9.6727>, 0.3000
<1.7762 ,3.0767 ,13.5417>, 0.1000
}
cone {
<1.5524 ,2.0233 ,9.6693>, 0.3000
<2.1734 ,2.8326 ,13.5371>, 0.1000
}
cone {
<1.8122 ,1.8123 ,9.6660>, 0.3000
<2.5370 ,2.5372 ,13.5324>, 0.1000
}
cone {
<2.0433 ,1.5680 ,9.6626>, 0.3000
<2.8606 ,2.1952 ,13.5277>, 0.1000
}
cone {
<2.2414 ,1.2942 ,9.6593>, 0.3000
<3.1379 ,1.8118 ,13.5230>, 0.1000
}
cone {
<2.4028 ,0.9954 ,9.6559>, 0.3000
<3.3639 ,1.3935 ,13.5182>, 0.1000
}
cone {
<2.5244 ,0.6765 ,9.6525>, 0.3000
<3.5341 ,0.9471 ,13.5134>, 0.1000
}
cone {
<2.6036 ,0.3429 ,9.6490>, 0.3000
<3.6451 ,0.4800 ,13.5086>, 0.1000
}
cone {
<2.6387 ,0.0001 ,9.6456>, 0.3000
<3.6942 ,0.0001 ,13.5038>, 0.1000
}
cone {
<2.6287 ,-0.3460 ,9.6421>, 0.3000
<3.6802 ,-0.4844 ,13.4990>, 0.1000
}
cone {
<2.5732 ,-0.6894 ,9.6386>, 0.3000
<3.6025 ,-0.9651 ,13.4941>, 0.1000
}
cone {
<2.4729 ,-1.0242 ,9.6351>, 0.3000
<3.4620 ,-1.4339 ,13.4892>, 0.1000
}
cone {
<2.3290 ,-1.3445 ,9.6316>, 0.3000
<3.2605 ,-1.8823 ,13.4843>, 0.1000
}
cone {
<2.1435 ,-1.6447 ,9.6281>, 0.3000
<3.0010 ,-2.3025 ,13.4793>, 0.1000
}
cone {
<1.9194 ,-1.9193 ,9.6246>, 0.3000
<2.6872 ,-2.6870 ,13.4744>, 0.1000
}
cone {
<1.6602 ,-2.1634 ,9.6210>, 0.3000
<2.3242 ,-3.0288 ,13.4694>, 0.1000
}
cone {
<1.3699 ,-2.3725 ,9.6174>, 0.3000
<1.9178 ,-3.3215 ,13.4644>, 0.1000
}
cone {
<1.0533 ,-2.5426 ,9.6138>, 0.3000
<1.4746 ,-3.5597 ,13.4593>, 0.1000
}
cone {
<0.7157 ,-2.6705 ,9.6102>, 0.3000
<1.0019 ,-3.7387 ,13.4543>, 0.1000
}
cone {
<0.3626 ,-2.7536 ,9.6066>, 0.3000
<0.5077 ,-3.8550 ,13.4492>, 0.1000
}
cone {
<0.0001 ,-2.7899 ,9.6029>, 0.3000
<0.0001 ,-3.9059 ,13.4441>, 0.1000
}
cone {
<-0.3657 ,-2.7785 ,9.5993>, 0.3000
<-0.5120 ,-3.8899 ,13.4390>, 0.1000
}
cone {
<-0.7285 ,-2.7191 ,9.5956>, 0.3000
<-1.0199 ,-3.8068 ,13.4338>, 0.1000
}
cone {
<-1.0820 ,-2.6124 ,9.5919>, 0.3000
<-1.5148 ,-3.6574 ,13.4287>, 0.1000
}
cone {
<-1.4200 ,-2.4597 ,9.5882>, 0.3000
<-1.9880 ,-3.4436 ,13.4235>, 0.1000
}
cone {
<-1.7365 ,-2.2632 ,9.5845>, 0.3000
<-2.4312 ,-3.1685 ,13.4183>, 0.1000
}
cone {
<-2.0260 ,-2.0261 ,9.5807>, 0.3000
<-2.8364 ,-2.8365 ,13.4130>, 0.1000
}
cone {
<-2.2831 ,-1.7519 ,9.5770>, 0.3000
<-3.1963 ,-2.4527 ,13.4078>, 0.1000
}
cone {
<-2.5030 ,-1.4452 ,9.5732>, 0.3000
<-3.5043 ,-2.0233 ,13.4025>, 0.1000
}
cone {
<-2.6819 ,-1.1109 ,9.5694>, 0.3000
<-3.7546 ,-1.5553 ,13.3972>, 0.1000
}
cone {
<-2.8160 ,-0.7546 ,9.5656>, 0.3000
<-3.9424 ,-1.0565 ,13.3918>, 0.1000
}
cone {
<-2.9028 ,-0.3822 ,9.5618>, 0.3000
<-4.0640 ,-0.5351 ,13.3865>, 0.1000
}
cone {
<-2.9404 ,-0.0001 ,9.5579>, 0.3000
<-4.1166 ,-0.0001 ,13.3811>, 0.1000
}
cone {
<-2.9277 ,0.3854 ,9.5541>, 0.3000
<-4.0987 ,0.5395 ,13.3757>, 0.1000
}
cone {
<-2.8644 ,0.7675 ,9.5502>, 0.3000
<-4.0101 ,1.0744 ,13.3703>, 0.1000
}
cone {
<-2.7513 ,1.1396 ,9.5463>, 0.3000
<-3.8518 ,1.5954 ,13.3648>, 0.1000
}
cone {
<-2.5898 ,1.4952 ,9.5424>, 0.3000
<-3.6257 ,2.0932 ,13.3594>, 0.1000
}
cone {
<-2.3824 ,1.8280 ,9.5385>, 0.3000
<-3.3353 ,2.5592 ,13.3539>, 0.1000
}
cone {
<-2.1322 ,2.1322 ,9.5345>, 0.3000
<-2.9851 ,2.9850 ,13.3484>, 0.1000
}
cone {
<-1.8433 ,2.4021 ,9.5306>, 0.3000
<-2.5806 ,3.3630 ,13.3428>, 0.1000
}
cone {
<-1.5202 ,2.6330 ,9.5266>, 0.3000
<-2.1283 ,3.6862 ,13.3373>, 0.1000
}
cone {
<-1.1683 ,2.8204 ,9.5226>, 0.3000
<-1.6356 ,3.9486 ,13.3317>, 0.1000
}
cone {
<-0.7934 ,2.9608 ,9.5186>, 0.3000
<-1.1107 ,4.1451 ,13.3261>, 0.1000
}
cone {
<-0.4017 ,3.0514 ,9.5146>, 0.3000
<-0.5624 ,4.2719 ,13.3204>, 0.1000
}
cone {
<-0.0000 ,3.0902 ,9.5106>, 0.3000
<-0.0000 ,4.3262 ,13.3148>, 0.1000
}
cone {
<0.4050 ,3.0761 ,9.5065>, 0.3000
<0.5670 ,4.3065 ,13.3091>, 0.1000
}
cone {
<0.8062 ,3.0089 ,9.5024>, 0.3000
<1.1287 ,4.2125 ,13.3034>, 0.1000
}
cone {
<1.1968 ,2.8894 ,9.4984>, 0.3000
<1.6756 ,4.0452 ,13.2977>, 0.1000
}
cone {
<1.5700 ,2.7193 ,9.4943>, 0.3000
<2.1980 ,3.8070 ,13.2920>, 0.1000
}
cone {
<1.9190 ,2.5009 ,9.4901>, 0.3000
<2.6867 ,3.5013 ,13.2862>, 0.1000
}
cone {
<2.2378 ,2.2378 ,9.4860>, 0.3000
<3.1330 ,3.1329 ,13.2804>, 0.1000
}
cone {
<2.5206 ,1.9341 ,9.4819>, 0.3000
<3.5289 ,2.7078 ,13.2746>, 0.1000
}
cone {
<2.7623 ,1.5948 ,9.4777>, 0.3000
<3.8672 ,2.2327 ,13.2688>, 0.1000
}
cone {
<2.9583 ,1.2253 ,9.4735>, 0.3000
<4.1416 ,1.7155 ,13.2629>, 0.1000
}
cone {
<3.1049 ,0.8319 ,9.4693>, 0.3000
<4.3468 ,1.1647 ,13.2570>, 0.1000
}
cone {
<3.1992 ,0.4211 ,9.4651>, 0.3000
<4.4789 ,0.5896 ,13.2511>, 0.1000
}
cone {
<3.2392 ,-0.0000 ,9.4609>, 0.3000
<4.5348 ,-0.0001 ,13.2452>, 0.1000
}
cone {
<3.2237 ,-0.4245 ,9.4566>, 0.3000
<4.5132 ,-0.5942 ,13.2392>, 0.1000
}
cone {
<3.1527 ,-0.8448 ,9.4523>, 0.3000
<4.4138 ,-1.1827 ,13.2333>, 0.1000
}
cone {
<3.0269 ,-1.2538 ,9.4481>, 0.3000
<4.2376 ,-1.7554 ,13.2273>, 0.1000
}
cone {
<2.8480 ,-1.6444 ,9.4438>, 0.3000
<3.9873 ,-2.3021 ,13.2213>, 0.1000
}
cone {
<2.6188 ,-2.0096 ,9.4395>, 0.3000
<3.6664 ,-2.8134 ,13.2152>, 0.1000
}
cone {
<2.3429 ,-2.3430 ,9.4351>, 0.3000
<3.2800 ,-3.2801 ,13.2092>, 0.1000
}
cone {
<2.0245 ,-2.6385 ,9.4308>, 0.3000
<2.8343 ,-3.6939 ,13.2031>, 0.1000
}
cone {
<1.6690 ,-2.8909 ,9.4264>, 0.3000
<2.3366 ,-4.0473 ,13.1970>, 0.1000
}
cone {
<1.2821 ,-3.0954 ,9.4220>, 0.3000
<1.7949 ,-4.3336 ,13.1909>, 0.1000
}
cone {
<0.8703 ,-3.2482 ,9.4176>, 0.3000
<1.2184 ,-4.5475 ,13.1847>, 0.1000
}
cone {
<0.4404 ,-3.3462 ,9.4132>, 0.3000
<0.6166 ,-4.6847 ,13.1785>, 0.1000
}
cone {
<-0.0001 ,-3.3874 ,9.4088>, 0.3000
<-0.0001 ,-4.7423 ,13.1723>, 0.1000
}
cone {
<-0.4439 ,-3.3706 ,9.4044>, 0.3000
<-0.6214 ,-4.7188 ,13.1661>, 0.1000
}
cone {
<-0.8832 ,-3.2957 ,9.3999>, 0.3000
<-1.2365 ,-4.6140 ,13.1599>, 0.1000
}
cone {
<-1.3105 ,-3.1636 ,9.3954>, 0.3000
<-1.8347 ,-4.4290 ,13.1536>, 0.1000
}
cone {
<-1.7184 ,-2.9761 ,9.3909>, 0.3000
<-2.4058 ,-4.1666 ,13.1473>, 0.1000
}
cone {
<-2.0997 ,-2.7361 ,9.3864>, 0.3000
<-2.9395 ,-3.8306 ,13.1410>, 0.1000
}
cone {
<-2.4475 ,-2.4473 ,9.3819>, 0.3000
<-3.4265 ,-3.4263 ,13.1347>, 0.1000
}
cone {
<-2.7558 ,-2.1144 ,9.3774>, 0.3000
<-3.8581 ,-2.9602 ,13.1283>, 0.1000
}
cone {
<-3.0188 ,-1.7427 ,9.3728>, 0.3000
<-4.2263 ,-2.4398 ,13.1219>, 0.1000
}
cone {
<-3.2318 ,-1.3385 ,9.3682>, 0.3000
<-4.5245 ,-1.8739 ,13.1155>, 0.1000
}
cone {
<-3.3907 ,-0.9084 ,9.3637>, 0.3000
<-4.7470 ,-1.2717 ,13.1091>, 0.1000
}
cone {
<-3.4924 ,-0.4596 ,9.3591>, 0.3000
<-4.8893 ,-0.6435 ,13.1027>, 0.1000
}
cone {
<-3.5348 ,0.0002 ,9.3544>, 0.3000
<-4.9487 ,0.0002 ,13.0962>, 0.1000
}
cone {
<-3.5166 ,0.4631 ,9.3498>, 0.3000
<-4.9233 ,0.6484 ,13.0897>, 0.1000
}
cone {
<-3.4379 ,0.9214 ,9.3452>, 0.3000
<-4.8131 ,1.2899 ,13.0832>, 0.1000
}
cone {
<-3.2995 ,1.3669 ,9.3405>, 0.3000
<-4.6193 ,1.9137 ,13.0767>, 0.1000
}
cone {
<-3.1035 ,1.7920 ,9.3358>, 0.3000
<-4.3449 ,2.5088 ,13.0701>, 0.1000
}
cone {
<-2.8527 ,2.1892 ,9.3311>, 0.3000
<-3.9938 ,3.0649 ,13.0635>, 0.1000
}
cone {
<-2.5512 ,2.5515 ,9.3264>, 0.3000
<-3.5717 ,3.5720 ,13.0569>, 0.1000
}
cone {
<-2.2038 ,2.8723 ,9.3217>, 0.3000
<-3.0853 ,4.0212 ,13.0503>, 0.1000
}
cone {
<-1.8161 ,3.1460 ,9.3169>, 0.3000
<-2.5425 ,4.4043 ,13.0437>, 0.1000
}
cone {
<-1.3946 ,3.3674 ,9.3121>, 0.3000
<-1.9524 ,4.7143 ,13.0370>, 0.1000
}
cone {
<-0.9463 ,3.5323 ,9.3074>, 0.3000
<-1.3248 ,4.9453 ,13.0303>, 0.1000
}
cone {
<-0.4787 ,3.6377 ,9.3026>, 0.3000
<-0.6702 ,5.0928 ,13.0236>, 0.1000
}
cone {
<0.0002 ,3.6813 ,9.2978>, 0.3000
<0.0003 ,5.1538 ,13.0169>, 0.1000
}
cone {
<0.4823 ,3.6618 ,9.2929>, 0.3000
<0.6752 ,5.1265 ,13.0101>, 0.1000
}
cone {
<0.9593 ,3.5793 ,9.2881>, 0.3000
<1.3430 ,5.0110 ,13.0033>, 0.1000
}
cone {
<1.4229 ,3.4346 ,9.2832>, 0.3000
<1.9921 ,4.8085 ,12.9965>, 0.1000
}
cone {
<1.8652 ,3.2300 ,9.2784>, 0.3000
<2.6112 ,4.5221 ,12.9897>, 0.1000
}
cone {
<2.2782 ,2.9686 ,9.2735>, 0.3000
<3.1895 ,4.1560 ,12.9829>, 0.1000
}
cone {
<2.6548 ,2.6544 ,9.2686>, 0.3000
<3.7167 ,3.7162 ,12.9760>, 0.1000
}
cone {
<2.9882 ,2.2926 ,9.2636>, 0.3000
<4.1834 ,3.2096 ,12.9691>, 0.1000
}
cone {
<3.2723 ,1.8890 ,9.2587>, 0.3000
<4.5813 ,2.6446 ,12.9622>, 0.1000
}
cone {
<3.5021 ,1.4503 ,9.2537>, 0.3000
<4.9029 ,2.0304 ,12.9552>, 0.1000
}
cone {
<3.6731 ,0.9839 ,9.2488>, 0.3000
<5.1424 ,1.3775 ,12.9483>, 0.1000
}
cone {
<3.7821 ,0.4976 ,9.2438>, 0.3000
<5.2950 ,0.6967 ,12.9413>, 0.1000
}
cone {
<3.8268 ,-0.0003 ,9.2388>, 0.3000
<5.3576 ,-0.0004 ,12.9343>, 0.1000
}
cone {
<3.8060 ,-0.5014 ,9.2338>, 0.3000
<5.3285 ,-0.7019 ,12.9273>, 0.1000
}
cone {
<3.7197 ,-0.9970 ,9.2287>, 0.3000
<5.2076 ,-1.3958 ,12.9202>, 0.1000
}
cone {
<3.5689 ,-1.4786 ,9.2237>, 0.3000
<4.9965 ,-2.0701 ,12.9132>, 0.1000
}
cone {
<3.3558 ,-1.9379 ,9.2186>, 0.3000
<4.6982 ,-2.7130 ,12.9061>, 0.1000
}
cone {
<3.0837 ,-2.3667 ,9.2135>, 0.3000
<4.3172 ,-3.3133 ,12.8990>, 0.1000
}
cone {
<2.7570 ,-2.7575 ,9.2085>, 0.3000
<3.8598 ,-3.8604 ,12.8918>, 0.1000
}
cone {
<2.3808 ,-3.1033 ,9.2033>, 0.3000
<3.3331 ,-4.3446 ,12.8847>, 0.1000
}
cone {
<1.9614 ,-3.3979 ,9.1982>, 0.3000
<2.7459 ,-4.7571 ,12.8775>, 0.1000
}
cone {
<1.5057 ,-3.6360 ,9.1931>, 0.3000
<2.1080 ,-5.0904 ,12.8703>, 0.1000
}
cone {
<1.0213 ,-3.8130 ,9.1879>, 0.3000
<1.4299 ,-5.3382 ,12.8631>, 0.1000
}
cone {
<0.5164 ,-3.9256 ,9.1827>, 0.3000
<0.7230 ,-5.4959 ,12.8558>, 0.1000
}
cone {
<-0.0004 ,-3.9715 ,9.1775>, 0.3000
<-0.0005 ,-5.5601 ,12.8486>, 0.1000
}
cone {
<-0.5203 ,-3.9494 ,9.1723>, 0.3000
<-0.7285 ,-5.5291 ,12.8413>, 0.1000
}
cone {
<-1.0345 ,-3.8593 ,9.1671>, 0.3000
<-1.4483 ,-5.4030 ,12.8340>, 0.1000
}
cone {
<-1.5340 ,-3.7023 ,9.1619>, 0.3000
<-2.1476 ,-5.1832 ,12.8266>, 0.1000
}
cone {
<-2.0101 ,-3.4808 ,9.1566>, 0.3000
<-2.8141 ,-4.8731 ,12.8193>, 0.1000
}
cone {
<-2.4545 ,-3.1981 ,9.1514>, 0.3000
<-3.4363 ,-4.4774 ,12.8119>, 0.1000
}
cone {
<-2.8594 ,-2.8589 ,9.1461>, 0.3000
<-4.0032 ,-4.0024 ,12.8045>, 0.1000
}
cone {
<-3.2176 ,-2.4684 ,9.1408>, 0.3000
<-4.5047 ,-3.4558 ,12.7971>, 0.1000
}
cone {
<-3.5227 ,-2.0333 ,9.1355>, 0.3000
<-4.9317 ,-2.8466 ,12.7896>, 0.1000
}
cone {
<-3.7690 ,-1.5607 ,9.1301>, 0.3000
<-5.2766 ,-2.1850 ,12.7822>, 0.1000
}
cone {
<-3.9520 ,-1.0585 ,9.1248>, 0.3000
<-5.5328 ,-1.4819 ,12.7747>, 0.1000
}
cone {
<-4.0682 ,-0.5351 ,9.1194>, 0.3000
<-5.6954 ,-0.7492 ,12.7672>, 0.1000
}
cone {
<-4.1152 ,0.0005 ,9.1140>, 0.3000
<-5.7612 ,0.0006 ,12.7596>, 0.1000
}
cone {
<-4.0917 ,0.5392 ,9.1086>, 0.3000
<-5.7284 ,0.7548 ,12.7521>, 0.1000
}
cone {
<-3.9978 ,1.0717 ,9.1032>, 0.3000
<-5.5970 ,1.5004 ,12.7445>, 0.1000
}
cone {
<-3.8348 ,1.5889 ,9.0978>, 0.3000
<-5.3687 ,2.2245 ,12.7369>, 0.1000
}
cone {
<-3.6049 ,2.0818 ,9.0924>, 0.3000
<-5.0468 ,2.9146 ,12.7293>, 0.1000
}
cone {
<-3.3117 ,2.5418 ,9.0869>, 0.3000
<-4.6364 ,3.5585 ,12.7217>, 0.1000
}
cone {
<-2.9600 ,2.9607 ,9.0814>, 0.3000
<-4.1440 ,4.1450 ,12.7140>, 0.1000
}
cone {
<-2.5555 ,3.3312 ,9.0759>, 0.3000
<-3.5777 ,4.6637 ,12.7063>, 0.1000
}
cone {
<-2.1047 ,3.6465 ,9.0704>, 0.3000
<-2.9466 ,5.1052 ,12.6986>, 0.1000
}
cone {
<-1.6153 ,3.9010 ,9.0649>, 0.3000
<-2.2614 ,5.4615 ,12.6909>, 0.1000
}
cone {
<-1.0954 ,4.0900 ,9.0594>, 0.3000
<-1.5335 ,5.7260 ,12.6831>, 0.1000
}
cone {
<-0.5537 ,4.2097 ,9.0538>, 0.3000
<-0.7751 ,5.8936 ,12.6754>, 0.1000
}
cone {
<0.0005 ,4.2578 ,9.0483>, 0.3000
<0.0008 ,5.9609 ,12.6676>, 0.1000
}
cone {
<0.5578 ,4.2330 ,9.0427>, 0.3000
<0.7810 ,5.9263 ,12.6598>, 0.1000
}
cone {
<1.1087 ,4.1354 ,9.0371>, 0.3000
<1.5521 ,5.7896 ,12.6519>, 0.1000
}
cone {
<1.6435 ,3.9663 ,9.0315>, 0.3000
<2.3009 ,5.5528 ,12.6441>, 0.1000
}
cone {
<2.1531 ,3.7281 ,9.0258>, 0.3000
<3.0143 ,5.2193 ,12.6362>, 0.1000
}
cone {
<2.6284 ,3.4245 ,9.0202>, 0.3000
<3.6798 ,4.7943 ,12.6283>, 0.1000
}
cone {
<3.0613 ,3.0605 ,9.0145>, 0.3000
<4.2858 ,4.2846 ,12.6204>, 0.1000
}
cone {
<3.4439 ,2.6419 ,9.0089>, 0.3000
<4.8215 ,3.6986 ,12.6124>, 0.1000
}
cone {
<3.7695 ,2.1756 ,9.0032>, 0.3000
<5.2773 ,3.0459 ,12.6045>, 0.1000
}
cone {
<4.0321 ,1.6695 ,8.9975>, 0.3000
<5.6450 ,2.3373 ,12.5965>, 0.1000
}
cone {
<4.2269 ,1.1320 ,8.9918>, 0.3000
<5.9177 ,1.5847 ,12.5885>, 0.1000
}
cone {
<4.3502 ,0.5721 ,8.9860>, 0.3000
<6.0903 ,0.8009 ,12.5804>, 0.1000
}
cone {
<4.3994 ,-0.0006 ,8.9803>, 0.3000
<6.1592 ,-0.0009 ,12.5724>, 0.1000
}
cone {
<4.3733 ,-0.5764 ,8.9745>, 0.3000
<6.1227 ,-0.8070 ,12.5643>, 0.1000
}
cone {
<4.2720 ,-1.1454 ,8.9687>, 0.3000
<5.9808 ,-1.6035 ,12.5562>, 0.1000
}
cone {
<4.0968 ,-1.6977 ,8.9629>, 0.3000
<5.7355 ,-2.3767 ,12.5481>, 0.1000
}
cone {
<3.8503 ,-2.2238 ,8.9571>, 0.3000
<5.3905 ,-3.1133 ,12.5400>, 0.1000
}
cone {
<3.5364 ,-2.7144 ,8.9513>, 0.3000
<4.9510 ,-3.8002 ,12.5318>, 0.1000
}
cone {
<3.1601 ,-3.1611 ,8.9454>, 0.3000
<4.4242 ,-4.4256 ,12.5236>, 0.1000
}
cone {
<2.7276 ,-3.5558 ,8.9396>, 0.3000
<3.8187 ,-4.9782 ,12.5154>, 0.1000
}
cone {
<2.2460 ,-3.8916 ,8.9337>, 0.3000
<3.1444 ,-5.4482 ,12.5072>, 0.1000
}
cone {
<1.7233 ,-4.1623 ,8.9278>, 0.3000
<2.4126 ,-5.8272 ,12.4989>, 0.1000
}
cone {
<1.1683 ,-4.3629 ,8.9219>, 0.3000
<1.6356 ,-6.1080 ,12.4907>, 0.1000
}
cone {
<0.5903 ,-4.4896 ,8.9160>, 0.3000
<0.8265 ,-6.2854 ,12.4824>, 0.1000
}
cone {
<-0.0007 ,-4.5399 ,8.9101>, 0.3000
<-0.0010 ,-6.3559 ,12.4741>, 0.1000
}
cone {
<-0.5948 ,-4.5125 ,8.9041>, 0.3000
<-0.8328 ,-6.3176 ,12.4658>, 0.1000
}
cone {
<-1.1818 ,-4.4075 ,8.8981>, 0.3000
<-1.6545 ,-6.1706 ,12.4574>, 0.1000
}
cone {
<-1.7514 ,-4.2263 ,8.8922>, 0.3000
<-2.4520 ,-5.9169 ,12.4490>, 0.1000
}
cone {
<-2.2939 ,-3.9717 ,8.8862>, 0.3000
<-3.2115 ,-5.5603 ,12.4406>, 0.1000
}
cone {
<-2.7998 ,-3.6475 ,8.8802>, 0.3000
<-3.9197 ,-5.1065 ,12.4322>, 0.1000
}
cone {
<-3.2601 ,-3.2590 ,8.8741>, 0.3000
<-4.5642 ,-4.5627 ,12.4238>, 0.1000
}
cone {
<-3.6669 ,-2.8127 ,8.8681>, 0.3000
<-5.1336 ,-3.9378 ,12.4153>, 0.1000
}
cone {
<-4.0127 ,-2.3158 ,8.8620>, 0.3000
<-5.6177 ,-3.2421 ,12.4068>, 0.1000
}
cone {
<-4.2913 ,-1.7767 ,8.8560>, 0.3000
<-6.0079 ,-2.4873 ,12.3983>, 0.1000
}
cone {
<-4.4977 ,-1.2043 ,8.8499>, 0.3000
<-6.2968 ,-1.6860 ,12.3898>, 0.1000
}
cone {
<-4.6279 ,-0.6084 ,8.8438>, 0.3000
<-6.4791 ,-0.8518 ,12.3813>, 0.1000
}
cone {
<-4.6793 ,0.0008 ,8.8376>, 0.3000
<-6.5510 ,0.0012 ,12.3727>, 0.1000
}
cone {
<-4.6506 ,0.6131 ,8.8315>, 0.3000
<-6.5109 ,0.8584 ,12.3641>, 0.1000
}
cone {
<-4.5420 ,1.2179 ,8.8254>, 0.3000
<-6.3588 ,1.7051 ,12.3555>, 0.1000
}
cone {
<-4.3548 ,1.8048 ,8.8192>, 0.3000
<-6.0968 ,2.5267 ,12.3469>, 0.1000
}
cone {
<-4.0920 ,2.3635 ,8.8130>, 0.3000
<-5.7288 ,3.3089 ,12.3382>, 0.1000
}
cone {
<-3.7576 ,2.8844 ,8.8068>, 0.3000
<-5.2607 ,4.0382 ,12.3296>, 0.1000
}
cone {
<-3.3571 ,3.3584 ,8.8006>, 0.3000
<-4.7000 ,4.7017 ,12.3209>, 0.1000
}
cone {
<-2.8971 ,3.7770 ,8.7944>, 0.3000
<-4.0559 ,5.2878 ,12.3122>, 0.1000
}
cone {
<-2.3850 ,4.1328 ,8.7882>, 0.3000
<-3.3390 ,5.7859 ,12.3034>, 0.1000
}
cone {
<-1.8296 ,4.4194 ,8.7819>, 0.3000
<-2.5614 ,6.1871 ,12.2947>, 0.1000
}
cone {
<-1.2400 ,4.6315 ,8.7756>, 0.3000
<-1.7361 ,6.4840 ,12.2859>, 0.1000
}
cone {
<-0.6264 ,4.7651 ,8.7694>, 0.3000
<-0.8770 ,6.6711 ,12.2771>, 0.1000
}
cone {
<0.0009 ,4.8176 ,8.7631>, 0.3000
<0.0013 ,6.7446 ,12.2683>, 0.1000
}
cone {
<0.6312 ,4.7876 ,8.7567>, 0.3000
<0.8837 ,6.7026 ,12.2594>, 0.1000
}
cone {
<1.2537 ,4.6753 ,8.7504>, 0.3000
<1.7552 ,6.5454 ,12.2506>, 0.1000
}
cone {
<1.8576 ,4.4822 ,8.7441>, 0.3000
<2.6007 ,6.2751 ,12.2417>, 0.1000
}
cone {
<2.4325 ,4.2113 ,8.7377>, 0.3000
<3.4055 ,5.8958 ,12.2328>, 0.1000
}
cone {
<2.9684 ,3.8668 ,8.7313>, 0.3000
<4.1557 ,5.4136 ,12.2239>, 0.1000
}
cone {
<3.4558 ,3.4544 ,8.7249>, 0.3000
<4.8381 ,4.8361 ,12.2149>, 0.1000
}
cone {
<3.8862 ,2.9807 ,8.7185>, 0.3000
<5.4406 ,4.1730 ,12.2060>, 0.1000
}
cone {
<4.2519 ,2.4537 ,8.7121>, 0.3000
<5.9526 ,3.4351 ,12.1970>, 0.1000
}
cone {
<4.5463 ,1.8820 ,8.7057>, 0.3000
<6.3648 ,2.6349 ,12.1880>, 0.1000
}
cone {
<4.7641 ,1.2755 ,8.6992>, 0.3000
<6.6697 ,1.7857 ,12.1789>, 0.1000
}
cone {
<4.9011 ,0.6442 ,8.6928>, 0.3000
<6.8615 ,0.9019 ,12.1699>, 0.1000
}
cone {
<4.9546 ,-0.0010 ,8.6863>, 0.3000
<6.9364 ,-0.0015 ,12.1608>, 0.1000
}
cone {
<4.9233 ,-0.6492 ,8.6798>, 0.3000
<6.8927 ,-0.9089 ,12.1517>, 0.1000
}
cone {
<4.8075 ,-1.2893 ,8.6733>, 0.3000
<6.7304 ,-1.8050 ,12.1426>, 0.1000
}
cone {
<4.6085 ,-1.9101 ,8.6668>, 0.3000
<6.4519 ,-2.6741 ,12.1335>, 0.1000
}
cone {
<4.3296 ,-2.5009 ,8.6602>, 0.3000
<6.0614 ,-3.5013 ,12.1243>, 0.1000
}
cone {
<3.9751 ,-3.0516 ,8.6537>, 0.3000
<5.5652 ,-4.2722 ,12.1152>, 0.1000
}
cone {
<3.5508 ,-3.5523 ,8.6471>, 0.3000
<4.9711 ,-4.9733 ,12.1060>, 0.1000
}
cone {
<3.0636 ,-3.9944 ,8.6405>, 0.3000
<4.2891 ,-5.5922 ,12.0968>, 0.1000
}
cone {
<2.5217 ,-4.3699 ,8.6339>, 0.3000
<3.5304 ,-6.1179 ,12.0875>, 0.1000
}
cone {
<1.9340 ,-4.6721 ,8.6273>, 0.3000
<2.7076 ,-6.5410 ,12.0783>, 0.1000
}
cone {
<1.3106 ,-4.8955 ,8.6207>, 0.3000
<1.8348 ,-6.8537 ,12.0690>, 0.1000
}
cone {
<0.6618 ,-5.0359 ,8.6141>, 0.3000
<0.9266 ,-7.0502 ,12.0597>, 0.1000
}
cone {
<-0.0012 ,-5.0904 ,8.6074>, 0.3000
<-0.0016 ,-7.1266 ,12.0504>, 0.1000
}
cone {
<-0.6671 ,-5.0579 ,8.6007>, 0.3000
<-0.9339 ,-7.0811 ,12.0410>, 0.1000
}
cone {
<-1.3245 ,-4.9384 ,8.5941>, 0.3000
<-1.8542 ,-6.9138 ,12.0317>, 0.1000
}
cone {
<-1.9620 ,-4.7337 ,8.5874>, 0.3000
<-2.7469 ,-6.6272 ,12.0223>, 0.1000
}
cone {
<-2.5688 ,-4.4468 ,8.5806>, 0.3000
<-3.5963 ,-6.2255 ,12.0129>, 0.1000
}
cone {
<-3.1340 ,-4.0824 ,8.5739>, 0.3000
<-4.3877 ,-5.7153 ,12.0035>, 0.1000
}
cone {
<-3.6480 ,-3.6463 ,8.5672>, 0.3000
<-5.1072 ,-5.1048 ,11.9940>, 0.1000
}
cone {
<-4.1017 ,-3.1458 ,8.5604>, 0.3000
<-5.7423 ,-4.4041 ,11.9846>, 0.1000
}
cone {
<-4.4869 ,-2.5891 ,8.5536>, 0.3000
<-6.2816 ,-3.6247 ,11.9751>, 0.1000
}
cone {
<-4.7968 ,-1.9855 ,8.5468>, 0.3000
<-6.7155 ,-2.7798 ,11.9656>, 0.1000
}
cone {
<-5.0257 ,-1.3453 ,8.5400>, 0.3000
<-7.0360 ,-1.8835 ,11.9561>, 0.1000
}
cone {
<-5.1694 ,-0.6793 ,8.5332>, 0.3000
<-7.2372 ,-0.9510 ,11.9465>, 0.1000
}
cone {
<-5.2250 ,0.0013 ,8.5264>, 0.3000
<-7.3150 ,0.0018 ,11.9369>, 0.1000
}
cone {
<-5.1912 ,0.6847 ,8.5195>, 0.3000
<-7.2677 ,0.9586 ,11.9274>, 0.1000
}
cone {
<-5.0682 ,1.3594 ,8.5127>, 0.3000
<-7.0954 ,1.9031 ,11.9178>, 0.1000
}
cone {
<-4.8577 ,2.0135 ,8.5058>, 0.3000
<-6.8007 ,2.8189 ,11.9081>, 0.1000
}
cone {
<-4.5629 ,2.6359 ,8.4989>, 0.3000
<-6.3881 ,3.6903 ,11.8985>, 0.1000
}
cone {
<-4.1887 ,3.2157 ,8.4920>, 0.3000
<-5.8641 ,4.5020 ,11.8888>, 0.1000
}
cone {
<-3.7409 ,3.7428 ,8.4851>, 0.3000
<-5.2373 ,5.2399 ,11.8791>, 0.1000
}
cone {
<-3.2271 ,4.2079 ,8.4782>, 0.3000
<-4.5180 ,5.8911 ,11.8694>, 0.1000
}
cone {
<-2.6558 ,4.6027 ,8.4712>, 0.3000
<-3.7182 ,6.4438 ,11.8597>, 0.1000
}
cone {
<-2.0366 ,4.9203 ,8.4642>, 0.3000
<-2.8512 ,6.8884 ,11.8499>, 0.1000
}
cone {
<-1.3798 ,5.1547 ,8.4573>, 0.3000
<-1.9317 ,7.2166 ,11.8402>, 0.1000
}
cone {
<-0.6966 ,5.3017 ,8.4503>, 0.3000
<-0.9752 ,7.4223 ,11.8304>, 0.1000
}
cone {
<0.0014 ,5.3583 ,8.4433>, 0.3000
<0.0020 ,7.5016 ,11.8206>, 0.1000
}
cone {
<0.7022 ,5.3232 ,8.4362>, 0.3000
<0.9831 ,7.4525 ,11.8107>, 0.1000
}
cone {
<1.3939 ,5.1967 ,8.4292>, 0.3000
<1.9515 ,7.2753 ,11.8009>, 0.1000
}
cone {
<2.0645 ,4.9805 ,8.4222>, 0.3000
<2.8903 ,6.9726 ,11.7910>, 0.1000
}
cone {
<2.7025 ,4.6779 ,8.4151>, 0.3000
<3.7834 ,6.5491 ,11.7811>, 0.1000
}
cone {
<3.2966 ,4.2939 ,8.4080>, 0.3000
<4.6153 ,6.0114 ,11.7712>, 0.1000
}
cone {
<3.8367 ,3.8346 ,8.4009>, 0.3000
<5.3714 ,5.3685 ,11.7613>, 0.1000
}
cone {
<4.3131 ,3.3077 ,8.3938>, 0.3000
<6.0384 ,4.6308 ,11.7513>, 0.1000
}
cone {
<4.7175 ,2.7219 ,8.3867>, 0.3000
<6.6045 ,3.8107 ,11.7414>, 0.1000
}
cone {
<5.0425 ,2.0871 ,8.3796>, 0.3000
<7.0596 ,2.9219 ,11.7314>, 0.1000
}
cone {
<5.2824 ,1.4139 ,8.3724>, 0.3000
<7.3954 ,1.9794 ,11.7214>, 0.1000
}
cone {
<5.4326 ,0.7137 ,8.3652>, 0.3000
<7.6057 ,0.9992 ,11.7113>, 0.1000
}
cone {
<5.4903 ,-0.0015 ,8.3581>, 0.3000
<7.6864 ,-0.0021 ,11.7013>, 0.1000
}
cone {
<5.4539 ,-0.7196 ,8.3509>, 0.3000
<7.6355 ,-1.0074 ,11.6912>, 0.1000
}
cone {
<5.3239 ,-1.4281 ,8.3437>, 0.3000
<7.4535 ,-1.9994 ,11.6811>, 0.1000
}
cone {
<5.1020 ,-2.1150 ,8.3364>, 0.3000
<7.1428 ,-2.9610 ,11.6710>, 0.1000
}
cone {
<4.7918 ,-2.7683 ,8.3292>, 0.3000
<6.7085 ,-3.8756 ,11.6609>, 0.1000
}
cone {
<4.3981 ,-3.3767 ,8.3219>, 0.3000
<6.1573 ,-4.7274 ,11.6507>, 0.1000
}
cone {
<3.9274 ,-3.9296 ,8.3147>, 0.3000
<5.4983 ,-5.5015 ,11.6406>, 0.1000
}
cone {
<3.3875 ,-4.4173 ,8.3074>, 0.3000
<4.7425 ,-6.1842 ,11.6304>, 0.1000
}
cone {
<2.7873 ,-4.8310 ,8.3001>, 0.3000
<3.9023 ,-6.7635 ,11.6201>, 0.1000
}
cone {
<2.1371 ,-5.1636 ,8.2928>, 0.3000
<2.9919 ,-7.2290 ,11.6099>, 0.1000
}
cone {
<1.4476 ,-5.4088 ,8.2855>, 0.3000
<2.0266 ,-7.5723 ,11.5997>, 0.1000
}
cone {
<0.7306 ,-5.5622 ,8.2781>, 0.3000
<1.0229 ,-7.7871 ,11.5894>, 0.1000
}
cone {
<-0.0016 ,-5.6209 ,8.2708>, 0.3000
<-0.0023 ,-7.8692 ,11.5791>, 0.1000
}
cone {
<-0.7367 ,-5.5833 ,8.2634>, 0.3000
<-1.0314 ,-7.8166 ,11.5688>, 0.1000
}
cone {
<-1.4620 ,-5.4498 ,8.2560>, 0.3000
<-2.0468 ,-7.6297 ,11.5585>, 0.1000
}
cone {
<-2.1650 ,-5.2223 ,8.2487>, 0.3000
<-3.0310 ,-7.3112 ,11.5481>, 0.1000
}
cone {
<-2.8335 ,-4.9044 ,8.2412>, 0.3000
<-3.9669 ,-6.8662 ,11.5377>, 0.1000
}
cone {
<-3.4560 ,-4.5011 ,8.2338>, 0.3000
<-4.8384 ,-6.3016 ,11.5274>, 0.1000
}
cone {
<-4.0216 ,-4.0191 ,8.2264>, 0.3000
<-5.6302 ,-5.6268 ,11.5169>, 0.1000
}
cone {
<-4.5203 ,-3.4664 ,8.2189>, 0.3000
<-6.3284 ,-4.8529 ,11.5065>, 0.1000
}
cone {
<-4.9434 ,-2.8521 ,8.2115>, 0.3000
<-6.9208 ,-3.9929 ,11.4961>, 0.1000
}
cone {
<-5.2833 ,-2.1865 ,8.2040>, 0.3000
<-7.3967 ,-3.0611 ,11.4856>, 0.1000
}
cone {
<-5.5339 ,-1.4810 ,8.1965>, 0.3000
<-7.7475 ,-2.0734 ,11.4751>, 0.1000
}
cone {
<-5.6905 ,-0.7474 ,8.1890>, 0.3000
<-7.9667 ,-1.0463 ,11.4646>, 0.1000
}
cone {
<-5.7501 ,0.0018 ,8.1815>, 0.3000
<-8.0501 ,0.0025 ,11.4541>, 0.1000
}
cone {
<-5.7113 ,0.7537 ,8.1739>, 0.3000
<-7.9958 ,1.0552 ,11.4435>, 0.1000
}
cone {
<-5.5744 ,1.4955 ,8.1664>, 0.3000
<-7.8041 ,2.0937 ,11.4330>, 0.1000
}
cone {
<-5.3413 ,2.2144 ,8.1588>, 0.3000
<-7.4779 ,3.1002 ,11.4224>, 0.1000
}
cone {
<-5.0158 ,2.8980 ,8.1513>, 0.3000
<-7.0222 ,4.0572 ,11.4118>, 0.1000
}
cone {
<-4.6031 ,3.5344 ,8.1437>, 0.3000
<-6.4444 ,4.9482 ,11.4011>, 0.1000
}
cone {
<-4.1099 ,4.1125 ,8.1361>, 0.3000
<-5.7539 ,5.7576 ,11.3905>, 0.1000
}
cone {
<-3.5444 ,4.6223 ,8.1284>, 0.3000
<-4.9622 ,6.4712 ,11.3798>, 0.1000
}
cone {
<-2.9161 ,5.0546 ,8.1208>, 0.3000
<-4.0825 ,7.0764 ,11.3691>, 0.1000
}
cone {
<-2.2355 ,5.4018 ,8.1132>, 0.3000
<-3.1296 ,7.5625 ,11.3584>, 0.1000
}
cone {
<-1.5140 ,5.6576 ,8.1055>, 0.3000
<-2.1196 ,7.9206 ,11.3477>, 0.1000
}
cone {
<-0.7639 ,5.8173 ,8.0978>, 0.3000
<-1.0695 ,8.1443 ,11.3370>, 0.1000
}
cone {
<0.0019 ,5.8779 ,8.0902>, 0.3000
<0.0027 ,8.2290 ,11.3262>, 0.1000
}
cone {
<0.7705 ,5.8378 ,8.0824>, 0.3000
<1.0787 ,8.1730 ,11.3154>, 0.1000
}
cone {
<1.5287 ,5.6975 ,8.0747>, 0.3000
<2.1401 ,7.9765 ,11.3046>, 0.1000
}
cone {
<2.2633 ,5.4590 ,8.0670>, 0.3000
<3.1686 ,7.6426 ,11.2938>, 0.1000
}
cone {
<2.9618 ,5.1260 ,8.0593>, 0.3000
<4.1465 ,7.1764 ,11.2830>, 0.1000
}
cone {
<3.6119 ,4.7039 ,8.0515>, 0.3000
<5.0567 ,6.5855 ,11.2721>, 0.1000
}
cone {
<4.2025 ,4.1997 ,8.0437>, 0.3000
<5.8835 ,5.8796 ,11.2612>, 0.1000
}
cone {
<4.7231 ,3.6216 ,8.0360>, 0.3000
<6.6123 ,5.0703 ,11.2503>, 0.1000
}
cone {
<5.1645 ,2.9794 ,8.0282>, 0.3000
<7.2303 ,4.1712 ,11.2394>, 0.1000
}
cone {
<5.5189 ,2.2838 ,8.0203>, 0.3000
<7.7265 ,3.1973 ,11.2285>, 0.1000
}
cone {
<5.7799 ,1.5466 ,8.0125>, 0.3000
<8.0919 ,2.1653 ,11.2175>, 0.1000
}
cone {
<5.9427 ,0.7803 ,8.0047>, 0.3000
<8.3198 ,1.0924 ,11.2065>, 0.1000
}
cone {
<6.0042 ,-0.0021 ,7.9968>, 0.3000
<8.4059 ,-0.0029 ,11.1956>, 0.1000
}
cone {
<5.9630 ,-0.7871 ,7.9890>, 0.3000
<8.3482 ,-1.1020 ,11.1845>, 0.1000
}
cone {
<5.8193 ,-1.5614 ,7.9811>, 0.3000
<8.1470 ,-2.1860 ,11.1735>, 0.1000
}
cone {
<5.5754 ,-2.3117 ,7.9732>, 0.3000
<7.8055 ,-3.2363 ,11.1625>, 0.1000
}
cone {
<5.2350 ,-3.0248 ,7.9653>, 0.3000
<7.3289 ,-4.2348 ,11.1514>, 0.1000
}
cone {
<4.8036 ,-3.6886 ,7.9574>, 0.3000
<6.7251 ,-5.1640 ,11.1403>, 0.1000
}
cone {
<4.2884 ,-4.2914 ,7.9494>, 0.3000
<6.0038 ,-6.0080 ,11.1292>, 0.1000
}
cone {
<3.6979 ,-4.8227 ,7.9415>, 0.3000
<5.1771 ,-6.7518 ,11.1181>, 0.1000
}
cone {
<3.0420 ,-5.2731 ,7.9335>, 0.3000
<4.2587 ,-7.3824 ,11.1069>, 0.1000
}
cone {
<2.3316 ,-5.6347 ,7.9255>, 0.3000
<3.2643 ,-7.8885 ,11.0958>, 0.1000
}
cone {
<1.5789 ,-5.9008 ,7.9175>, 0.3000
<2.2104 ,-8.2611 ,11.0846>, 0.1000
}
cone {
<0.7965 ,-6.0667 ,7.9095>, 0.3000
<1.1151 ,-8.4934 ,11.0734>, 0.1000
}
cone {
<-0.0022 ,-6.1291 ,7.9015>, 0.3000
<-0.0031 ,-8.5807 ,11.0621>, 0.1000
}
cone {
<-0.8035 ,-6.0866 ,7.8935>, 0.3000
<-1.1250 ,-8.5213 ,11.0509>, 0.1000
}
cone {
<-1.5938 ,-5.9396 ,7.8855>, 0.3000
<-2.2314 ,-8.3155 ,11.0396>, 0.1000
}
cone {
<-2.3594 ,-5.6903 ,7.8774>, 0.3000
<-3.3032 ,-7.9664 ,11.0284>, 0.1000
}
cone {
<-3.0871 ,-5.3426 ,7.8693>, 0.3000
<-4.3220 ,-7.4796 ,11.0171>, 0.1000
}
cone {
<-3.7644 ,-4.9021 ,7.8612>, 0.3000
<-5.2701 ,-6.8629 ,11.0057>, 0.1000
}
cone {
<-4.3793 ,-4.3761 ,7.8531>, 0.3000
<-6.1310 ,-6.1265 ,10.9944>, 0.1000
}
cone {
<-4.9212 ,-3.7733 ,7.8450>, 0.3000
<-6.8896 ,-5.2826 ,10.9831>, 0.1000
}
cone {
<-5.3805 ,-3.1038 ,7.8369>, 0.3000
<-7.5327 ,-4.3453 ,10.9717>, 0.1000
}
cone {
<-5.7490 ,-2.3788 ,7.8288>, 0.3000
<-8.0487 ,-3.3304 ,10.9603>, 0.1000
}
cone {
<-6.0203 ,-1.6107 ,7.8206>, 0.3000
<-8.4284 ,-2.2550 ,10.9489>, 0.1000
}
cone {
<-6.1891 ,-0.8125 ,7.8125>, 0.3000
<-8.6648 ,-1.1374 ,10.9374>, 0.1000
}
cone {
<-6.2525 ,0.0023 ,7.8043>, 0.3000
<-8.7534 ,0.0033 ,10.9260>, 0.1000
}
cone {
<-6.2088 ,0.8198 ,7.7961>, 0.3000
<-8.6923 ,1.1477 ,10.9145>, 0.1000
}
cone {
<-6.0585 ,1.6258 ,7.7879>, 0.3000
<-8.4819 ,2.2762 ,10.9030>, 0.1000
}
cone {
<-5.8039 ,2.4066 ,7.7797>, 0.3000
<-8.1254 ,3.3693 ,10.8915>, 0.1000
}
cone {
<-5.4489 ,3.1487 ,7.7714>, 0.3000
<-7.6285 ,4.4082 ,10.8800>, 0.1000
}
cone {
<-4.9994 ,3.8392 ,7.7632>, 0.3000
<-6.9991 ,5.3748 ,10.8685>, 0.1000
}
cone {
<-4.4626 ,4.4661 ,7.7549>, 0.3000
<-6.2477 ,6.2525 ,10.8569>, 0.1000
}
cone {
<-3.8477 ,5.0184 ,7.7467>, 0.3000
<-5.3868 ,7.0258 ,10.8453>, 0.1000
}
cone {
<-3.1648 ,5.4865 ,7.7384>, 0.3000
<-4.4307 ,7.6811 ,10.8337>, 0.1000
}
cone {
<-2.4255 ,5.8620 ,7.7301>, 0.3000
<-3.3956 ,8.2068 ,10.8221>, 0.1000
}
cone {
<-1.6422 ,6.1382 ,7.7218>, 0.3000
<-2.2990 ,8.5935 ,10.8105>, 0.1000
}
cone {
<-0.8282 ,6.3101 ,7.7134>, 0.3000
<-1.1595 ,8.8341 ,10.7988>, 0.1000
}
cone {
<0.0025 ,6.3743 ,7.7051>, 0.3000
<0.0035 ,8.9240 ,10.7872>, 0.1000
}
cone {
<0.8358 ,6.3294 ,7.6968>, 0.3000
<1.1701 ,8.8612 ,10.7755>, 0.1000
}
cone {
<1.6574 ,6.1759 ,7.6884>, 0.3000
<2.3204 ,8.6462 ,10.7638>, 0.1000
}
cone {
<2.4532 ,5.9160 ,7.6800>, 0.3000
<3.4345 ,8.2824 ,10.7520>, 0.1000
}
cone {
<3.2095 ,5.5539 ,7.6716>, 0.3000
<4.4933 ,7.7754 ,10.7403>, 0.1000
}
cone {
<3.9131 ,5.0954 ,7.6632>, 0.3000
<5.4783 ,7.1335 ,10.7285>, 0.1000
}
cone {
<4.5518 ,4.5481 ,7.6548>, 0.3000
<6.3725 ,6.3674 ,10.7167>, 0.1000
}
cone {
<5.1144 ,3.9212 ,7.6464>, 0.3000
<7.1602 ,5.4896 ,10.7049>, 0.1000
}
cone {
<5.5912 ,3.2251 ,7.6379>, 0.3000
<7.8276 ,4.5151 ,10.6931>, 0.1000
}
cone {
<5.9735 ,2.4715 ,7.6295>, 0.3000
<8.3629 ,3.4601 ,10.6813>, 0.1000
}
cone {
<6.2546 ,1.6732 ,7.6210>, 0.3000
<8.7565 ,2.3425 ,10.6694>, 0.1000
}
cone {
<6.4294 ,0.8438 ,7.6125>, 0.3000
<9.0012 ,1.1813 ,10.6575>, 0.1000
}
cone {
<6.4945 ,-0.0027 ,7.6040>, 0.3000
<9.0923 ,-0.0037 ,10.6456>, 0.1000
}
cone {
<6.4485 ,-0.8516 ,7.5955>, 0.3000
<9.0279 ,-1.1923 ,10.6337>, 0.1000
}
cone {
<6.2917 ,-1.6886 ,7.5870>, 0.3000
<8.8084 ,-2.3641 ,10.6218>, 0.1000
}
cone {
<6.0267 ,-2.4992 ,7.5785>, 0.3000
<8.4373 ,-3.4989 ,10.6099>, 0.1000
}
cone {
<5.6575 ,-3.2695 ,7.5699>, 0.3000
<7.9204 ,-4.5772 ,10.5979>, 0.1000
}
cone {
<5.1902 ,-3.9860 ,7.5614>, 0.3000
<7.2662 ,-5.5804 ,10.5859>, 0.1000
}
cone {
<4.6325 ,-4.6363 ,7.5528>, 0.3000
<6.4855 ,-6.4909 ,10.5739>, 0.1000
}
cone {
<3.9937 ,-5.2092 ,7.5442>, 0.3000
<5.5912 ,-7.2928 ,10.5619>, 0.1000
}
cone {
<3.2845 ,-5.6944 ,7.5356>, 0.3000
<4.5983 ,-7.9722 ,10.5498>, 0.1000
}
cone {
<2.5169 ,-6.0836 ,7.5270>, 0.3000
<3.5236 ,-8.5170 ,10.5378>, 0.1000
}
cone {
<1.7038 ,-6.3695 ,7.5184>, 0.3000
<2.3854 ,-8.9174 ,10.5257>, 0.1000
}
cone {
<0.8591 ,-6.5472 ,7.5097>, 0.3000
<1.2028 ,-9.1661 ,10.5136>, 0.1000
}
cone {
<-0.0028 ,-6.6132 ,7.5011>, 0.3000
<-0.0039 ,-9.2584 ,10.5015>, 0.1000
}
cone {
<-0.8673 ,-6.5659 ,7.4924>, 0.3000
<-1.2142 ,-9.1923 ,10.4894>, 0.1000
}
cone {
<-1.7194 ,-6.4060 ,7.4837>, 0.3000
<-2.4072 ,-8.9684 ,10.4772>, 0.1000
}
cone {
<-2.5446 ,-6.1358 ,7.4751>, 0.3000
<-3.5625 ,-8.5902 ,10.4651>, 0.1000
}
cone {
<-3.3286 ,-5.7597 ,7.4664>, 0.3000
<-4.6601 ,-8.0635 ,10.4529>, 0.1000
}
cone {
<-4.0579 ,-5.2837 ,7.4576>, 0.3000
<-5.6811 ,-7.3971 ,10.4407>, 0.1000
}
cone {
<-4.7198 ,-4.7157 ,7.4489>, 0.3000
<-6.6077 ,-6.6019 ,10.4285>, 0.1000
}
cone {
<-5.3026 ,-4.0652 ,7.4402>, 0.3000
<-7.4237 ,-5.6913 ,10.4162>, 0.1000
}
cone {
<-5.7963 ,-3.3431 ,7.4314>, 0.3000
<-8.1149 ,-4.6804 ,10.4040>, 0.1000
}
cone {
<-6.1921 ,-2.5617 ,7.4227>, 0.3000
<-8.6689 ,-3.5864 ,10.3917>, 0.1000
}
cone {
<-6.4829 ,-1.7340 ,7.4139>, 0.3000
<-9.0760 ,-2.4276 ,10.3794>, 0.1000
}
cone {
<-6.6634 ,-0.8743 ,7.4051>, 0.3000
<-9.3287 ,-1.2240 ,10.3671>, 0.1000
}
cone {
<-6.7302 ,0.0030 ,7.3963>, 0.3000
<-9.4222 ,0.0042 ,10.3548>, 0.1000
}
cone {
<-6.6818 ,0.8827 ,7.3875>, 0.3000
<-9.3545 ,1.2358 ,10.3425>, 0.1000
}
cone {
<-6.5187 ,1.7498 ,7.3786>, 0.3000
<-9.1262 ,2.4497 ,10.3301>, 0.1000
}
cone {
<-6.2435 ,2.5894 ,7.3698>, 0.3000
<-8.7409 ,3.6252 ,10.3177>, 0.1000
}
cone {
<-5.8604 ,3.3870 ,7.3609>, 0.3000
<-8.2046 ,4.7418 ,10.3053>, 0.1000
}
cone {
<-5.3758 ,4.1289 ,7.3521>, 0.3000
<-7.5262 ,5.7804 ,10.2929>, 0.1000
}
cone {
<-4.7977 ,4.8020 ,7.3432>, 0.3000
<-6.7168 ,6.7228 ,10.2805>, 0.1000
}
cone {
<-4.1357 ,5.3948 ,7.3343>, 0.3000
<-5.7900 ,7.5527 ,10.2680>, 0.1000
}
cone {
<-3.4010 ,5.8968 ,7.3254>, 0.3000
<-4.7613 ,8.2555 ,10.2556>, 0.1000
}
cone {
<-2.6058 ,6.2991 ,7.3165>, 0.3000
<-3.6482 ,8.8188 ,10.2431>, 0.1000
}
cone {
<-1.7638 ,6.5946 ,7.3076>, 0.3000
<-2.4693 ,9.2324 ,10.2306>, 0.1000
}
cone {
<-0.8892 ,6.7779 ,7.2986>, 0.3000
<-1.2449 ,9.4890 ,10.2181>, 0.1000
}
cone {
<0.0031 ,6.8455 ,7.2897>, 0.3000
<0.0044 ,9.5837 ,10.2055>, 0.1000
}
cone {
<0.8979 ,6.7960 ,7.2807>, 0.3000
<1.2570 ,9.5144 ,10.1930>, 0.1000
}
cone {
<1.7797 ,6.6298 ,7.2717>, 0.3000
<2.4916 ,9.2818 ,10.1804>, 0.1000
}
cone {
<2.6335 ,6.3496 ,7.2627>, 0.3000
<3.6869 ,8.8894 ,10.1678>, 0.1000
}
cone {
<3.4446 ,5.9598 ,7.2537>, 0.3000
<4.8224 ,8.3437 ,10.1552>, 0.1000
}
cone {
<4.1988 ,5.4667 ,7.2447>, 0.3000
<5.8783 ,7.6534 ,10.1426>, 0.1000
}
cone {
<4.8831 ,4.8786 ,7.2357>, 0.3000
<6.8364 ,6.8300 ,10.1299>, 0.1000
}
cone {
<5.4856 ,4.2052 ,7.2266>, 0.3000
<7.6799 ,5.8873 ,10.1173>, 0.1000
}
cone {
<5.9958 ,3.4579 ,7.2176>, 0.3000
<8.3941 ,4.8411 ,10.1046>, 0.1000
}
cone {
<6.4046 ,2.6493 ,7.2085>, 0.3000
<8.9664 ,3.7091 ,10.0919>, 0.1000
}
cone {
<6.7047 ,1.7931 ,7.1994>, 0.3000
<9.3866 ,2.5104 ,10.0792>, 0.1000
}
cone {
<6.8907 ,0.9039 ,7.1903>, 0.3000
<9.6470 ,1.2654 ,10.0665>, 0.1000
}
cone {
<6.9592 ,-0.0033 ,7.1812>, 0.3000
<9.7428 ,-0.0046 ,10.0537>, 0.1000
}
cone {
<6.9085 ,-0.9129 ,7.1721>, 0.3000
<9.6719 ,-1.2780 ,10.0410>, 0.1000
}
cone {
<6.7393 ,-1.8092 ,7.1630>, 0.3000
<9.4350 ,-2.5329 ,10.0282>, 0.1000
}
cone {
<6.4542 ,-2.6770 ,7.1538>, 0.3000
<9.0358 ,-3.7478 ,10.0154>, 0.1000
}
cone {
<6.0576 ,-3.5012 ,7.1447>, 0.3000
<8.4807 ,-4.9017 ,10.0026>, 0.1000
}
cone {
<5.5562 ,-4.2677 ,7.1355>, 0.3000
<7.7787 ,-5.9747 ,9.9897>, 0.1000
}
cone {
<4.9582 ,-4.9630 ,7.1264>, 0.3000
<6.9415 ,-6.9482 ,9.9769>, 0.1000
}
cone {
<4.2737 ,-5.5751 ,7.1172>, 0.3000
<5.9831 ,-7.8052 ,9.9640>, 0.1000
}
cone {
<3.5140 ,-6.0933 ,7.1080>, 0.3000
<4.9196 ,-8.5306 ,9.9511>, 0.1000
}
cone {
<2.6922 ,-6.5085 ,7.0987>, 0.3000
<3.7691 ,-9.1118 ,9.9382>, 0.1000
}
cone {
<1.8220 ,-6.8131 ,7.0895>, 0.3000
<2.5508 ,-9.5384 ,9.9253>, 0.1000
}
cone {
<0.9183 ,-7.0019 ,7.0803>, 0.3000
<1.2857 ,-9.8026 ,9.9124>, 0.1000
}
cone {
<-0.0035 ,-7.0711 ,7.0710>, 0.3000
<-0.0049 ,-9.8995 ,9.8994>, 0.1000
}
cone {
<-0.9276 ,-7.0193 ,7.0618>, 0.3000
<-1.2987 ,-9.8271 ,9.8865>, 0.1000
}
cone {
<-1.8383 ,-6.8471 ,7.0525>, 0.3000
<-2.5736 ,-9.5860 ,9.8735>, 0.1000
}
cone {
<-2.7198 ,-6.5571 ,7.0432>, 0.3000
<-3.8078 ,-9.1799 ,9.8605>, 0.1000
}
cone {
<-3.5571 ,-6.1540 ,7.0339>, 0.3000
<-4.9799 ,-8.6156 ,9.8475>, 0.1000
}
cone {
<-4.3355 ,-5.6443 ,7.0246>, 0.3000
<-6.0697 ,-7.9021 ,9.8344>, 0.1000
}
cone {
<-5.0417 ,-5.0366 ,7.0153>, 0.3000
<-7.0583 ,-7.0513 ,9.8214>, 0.1000
}
cone {
<-5.6632 ,-4.3410 ,7.0059>, 0.3000
<-7.9285 ,-6.0775 ,9.8083>, 0.1000
}
cone {
<-6.1893 ,-3.5693 ,6.9966>, 0.3000
<-8.6651 ,-4.9970 ,9.7952>, 0.1000
}
cone {
<-6.6107 ,-2.7344 ,6.9872>, 0.3000
<-9.2550 ,-3.8281 ,9.7821>, 0.1000
}
cone {
<-6.9199 ,-1.8504 ,6.9779>, 0.3000
<-9.6879 ,-2.5906 ,9.7690>, 0.1000
}
cone {
<-7.1113 ,-0.9326 ,6.9685>, 0.3000
<-9.9558 ,-1.3056 ,9.7559>, 0.1000
}
cone {
<-7.1813 ,0.0036 ,6.9591>, 0.3000
<-10.0538 ,0.0051 ,9.7427>, 0.1000
}
cone {
<-7.1284 ,0.9422 ,6.9497>, 0.3000
<-9.9798 ,1.3190 ,9.7296>, 0.1000
}
cone {
<-6.9532 ,1.8669 ,6.9403>, 0.3000
<-9.7345 ,2.6137 ,9.7164>, 0.1000
}
cone {
<-6.6584 ,2.7620 ,6.9308>, 0.3000
<-9.3218 ,3.8668 ,9.7032>, 0.1000
}
cone {
<-6.2488 ,3.6120 ,6.9214>, 0.3000
<-8.7483 ,5.0568 ,9.6900>, 0.1000
}
cone {
<-5.7311 ,4.4023 ,6.9119>, 0.3000
<-8.0235 ,6.1632 ,9.6767>, 0.1000
}
cone {
<-5.1138 ,5.1191 ,6.9025>, 0.3000
<-7.1593 ,7.1667 ,9.6635>, 0.1000
}
cone {
<-4.4074 ,5.7499 ,6.8930>, 0.3000
<-6.1703 ,8.0499 ,9.6502>, 0.1000
}
cone {
<-3.6236 ,6.2838 ,6.8835>, 0.3000
<-5.0731 ,8.7974 ,9.6369>, 0.1000
}
cone {
<-2.7759 ,6.7114 ,6.8740>, 0.3000
<-3.8862 ,9.3959 ,9.6236>, 0.1000
}
cone {
<-1.8784 ,7.0250 ,6.8645>, 0.3000
<-2.6298 ,9.8350 ,9.6103>, 0.1000
}
cone {
<-0.9466 ,7.2190 ,6.8550>, 0.3000
<-1.3252 ,10.1065 ,9.5970>, 0.1000
}
cone {
<0.0038 ,7.2897 ,6.8454>, 0.3000
<0.0053 ,10.2056 ,9.5836>, 0.1000
}
cone {
<0.9565 ,7.2357 ,6.8359>, 0.3000
<1.3391 ,10.1300 ,9.5702>, 0.1000
}
cone {
<1.8951 ,7.0576 ,6.8263>, 0.3000
<2.6531 ,9.8807 ,9.5569>, 0.1000
}
cone {
<2.8035 ,6.7581 ,6.8168>, 0.3000
<3.9249 ,9.4614 ,9.5435>, 0.1000
}
cone {
<3.6661 ,6.3421 ,6.8072>, 0.3000
<5.1325 ,8.8789 ,9.5300>, 0.1000
}
cone {
<4.4680 ,5.8164 ,6.7976>, 0.3000
<6.2552 ,8.1429 ,9.5166>, 0.1000
}
cone {
<5.1952 ,5.1897 ,6.7880>, 0.3000
<7.2733 ,7.2656 ,9.5032>, 0.1000
}
cone {
<5.8352 ,4.4726 ,6.7784>, 0.3000
<8.1693 ,6.2616 ,9.4897>, 0.1000
}
cone {
<6.3768 ,3.6771 ,6.7687>, 0.3000
<8.9275 ,5.1479 ,9.4762>, 0.1000
}
cone {
<6.8104 ,2.8167 ,6.7591>, 0.3000
<9.5345 ,3.9433 ,9.4627>, 0.1000
}
cone {
<7.1283 ,1.9059 ,6.7494>, 0.3000
<9.9796 ,2.6683 ,9.4492>, 0.1000
}
cone {
<7.3248 ,0.9603 ,6.7398>, 0.3000
<10.2548 ,1.3444 ,9.4357>, 0.1000
}
cone {
<7.3963 ,-0.0040 ,6.7301>, 0.3000
<10.3549 ,-0.0056 ,9.4221>, 0.1000
}
cone {
<7.3413 ,-0.9705 ,6.7204>, 0.3000
<10.2778 ,-1.3588 ,9.4086>, 0.1000
}
cone {
<7.1603 ,-1.9228 ,6.7107>, 0.3000
<10.0244 ,-2.6919 ,9.3950>, 0.1000
}
cone {
<6.8562 ,-2.8443 ,6.7010>, 0.3000
<9.5986 ,-3.9820 ,9.3814>, 0.1000
}
cone {
<6.4338 ,-3.7193 ,6.6913>, 0.3000
<9.0074 ,-5.2070 ,9.3678>, 0.1000
}
cone {
<5.9003 ,-4.5326 ,6.6815>, 0.3000
<8.2604 ,-6.3456 ,9.3541>, 0.1000
}
cone {
<5.2643 ,-5.2701 ,6.6718>, 0.3000
<7.3701 ,-7.3782 ,9.3405>, 0.1000
}
cone {
<4.5367 ,-5.9191 ,6.6620>, 0.3000
<6.3514 ,-8.2867 ,9.3268>, 0.1000
}
cone {
<3.7296 ,-6.4682 ,6.6523>, 0.3000
<5.2215 ,-9.0554 ,9.3132>, 0.1000
}
cone {
<2.8568 ,-6.9077 ,6.6425>, 0.3000
<3.9995 ,-9.6708 ,9.2995>, 0.1000
}
cone {
<1.9329 ,-7.2299 ,6.6327>, 0.3000
<2.7061 ,-10.1218 ,9.2858>, 0.1000
}
cone {
<0.9738 ,-7.4289 ,6.6229>, 0.3000
<1.3634 ,-10.4005 ,9.2720>, 0.1000
}
cone {
<-0.0042 ,-7.5011 ,6.6131>, 0.3000
<-0.0058 ,-10.5016 ,9.2583>, 0.1000
}
cone {
<-0.9844 ,-7.4450 ,6.6033>, 0.3000
<-1.3781 ,-10.4230 ,9.2446>, 0.1000
}
cone {
<-1.9500 ,-7.2612 ,6.5934>, 0.3000
<-2.7300 ,-10.1656 ,9.2308>, 0.1000
}
cone {
<-2.8844 ,-6.9525 ,6.5836>, 0.3000
<-4.0381 ,-9.7335 ,9.2170>, 0.1000
}
cone {
<-3.7715 ,-6.5240 ,6.5737>, 0.3000
<-5.2801 ,-9.1335 ,9.2032>, 0.1000
}
cone {
<-4.5960 ,-5.9827 ,6.5638>, 0.3000
<-6.4344 ,-8.3758 ,9.1894>, 0.1000
}
cone {
<-5.3437 ,-5.3377 ,6.5540>, 0.3000
<-7.4812 ,-7.4727 ,9.1755>, 0.1000
}
cone {
<-6.0015 ,-4.5997 ,6.5441>, 0.3000
<-8.4021 ,-6.4396 ,9.1617>, 0.1000
}
cone {
<-6.5579 ,-3.7813 ,6.5342>, 0.3000
<-9.1811 ,-5.2938 ,9.1478>, 0.1000
}
cone {
<-7.0033 ,-2.8962 ,6.5242>, 0.3000
<-9.8046 ,-4.0547 ,9.1339>, 0.1000
}
cone {
<-7.3297 ,-1.9595 ,6.5143>, 0.3000
<-10.2615 ,-2.7433 ,9.1201>, 0.1000
}
cone {
<-7.5312 ,-0.9871 ,6.5044>, 0.3000
<-10.5436 ,-1.3820 ,9.1061>, 0.1000
}
cone {
<-7.6041 ,0.0044 ,6.4944>, 0.3000
<-10.6457 ,0.0061 ,9.0922>, 0.1000
}
cone {
<-7.5469 ,0.9980 ,6.4845>, 0.3000
<-10.5656 ,1.3972 ,9.0783>, 0.1000
}
cone {
<-7.3603 ,1.9767 ,6.4745>, 0.3000
<-10.3044 ,2.7674 ,9.0643>, 0.1000
}
cone {
<-7.0471 ,2.9238 ,6.4645>, 0.3000
<-9.8659 ,4.0933 ,9.0503>, 0.1000
}
cone {
<-6.6125 ,3.8228 ,6.4545>, 0.3000
<-9.2575 ,5.3520 ,9.0363>, 0.1000
}
cone {
<-6.0636 ,4.6584 ,6.4445>, 0.3000
<-8.4891 ,6.5217 ,9.0223>, 0.1000
}
cone {
<-5.4097 ,5.4160 ,6.4345>, 0.3000
<-7.5735 ,7.5823 ,9.0083>, 0.1000
}
cone {
<-4.6616 ,6.0824 ,6.4245>, 0.3000
<-6.5262 ,8.5154 ,8.9943>, 0.1000
}
cone {
<-3.8320 ,6.6461 ,6.4145>, 0.3000
<-5.3647 ,9.3046 ,8.9802>, 0.1000
}
cone {
<-2.9349 ,7.0972 ,6.4044>, 0.3000
<-4.1088 ,9.9361 ,8.9662>, 0.1000
}
cone {
<-1.9856 ,7.4276 ,6.3943>, 0.3000
<-2.7798 ,10.3987 ,8.9521>, 0.1000
}
cone {
<-1.0001 ,7.6316 ,6.3843>, 0.3000
<-1.4002 ,10.6842 ,8.9380>, 0.1000
}
cone {
<0.0045 ,7.7052 ,6.3742>, 0.3000
<0.0064 ,10.7872 ,8.9239>, 0.1000
}
cone {
<1.0113 ,7.6469 ,6.3641>, 0.3000
<1.4159 ,10.7057 ,8.9097>, 0.1000
}
cone {
<2.0030 ,7.4575 ,6.3540>, 0.3000
<2.8042 ,10.4405 ,8.8956>, 0.1000
}
cone {
<2.9624 ,7.1400 ,6.3439>, 0.3000
<4.1474 ,9.9959 ,8.8814>, 0.1000
}
cone {
<3.8732 ,6.6994 ,6.3338>, 0.3000
<5.4225 ,9.3791 ,8.8673>, 0.1000
}
cone {
<4.7196 ,6.1431 ,6.3236>, 0.3000
<6.6074 ,8.6003 ,8.8531>, 0.1000
}
cone {
<5.4869 ,5.4803 ,6.3135>, 0.3000
<7.6816 ,7.6725 ,8.8389>, 0.1000
}
cone {
<6.1618 ,4.7223 ,6.3033>, 0.3000
<8.6266 ,6.6112 ,8.8247>, 0.1000
}
cone {
<6.7326 ,3.8817 ,6.2932>, 0.3000
<9.4257 ,5.4344 ,8.8104>, 0.1000
}
cone {
<7.1893 ,2.9728 ,6.2830>, 0.3000
<10.0651 ,4.1620 ,8.7962>, 0.1000
}
cone {
<7.5238 ,2.0111 ,6.2728>, 0.3000
<10.5333 ,2.8156 ,8.7819>, 0.1000
}
cone {
<7.7301 ,1.0129 ,6.2626>, 0.3000
<10.8221 ,1.4181 ,8.7676>, 0.1000
}
cone {
<7.8043 ,-0.0047 ,6.2524>, 0.3000
<10.9261 ,-0.0066 ,8.7533>, 0.1000
}
cone {
<7.7451 ,-1.0244 ,6.2422>, 0.3000
<10.8431 ,-1.4342 ,8.7390>, 0.1000
}
cone {
<7.5530 ,-2.0287 ,6.2319>, 0.3000
<10.5742 ,-2.8402 ,8.7247>, 0.1000
}
cone {
<7.2311 ,-3.0004 ,6.2217>, 0.3000
<10.1235 ,-4.2005 ,8.7104>, 0.1000
}
cone {
<6.7846 ,-3.9226 ,6.2114>, 0.3000
<9.4985 ,-5.4917 ,8.6960>, 0.1000
}
cone {
<6.2210 ,-4.7796 ,6.2012>, 0.3000
<8.7094 ,-6.6914 ,8.6816>, 0.1000
}
cone {
<5.5496 ,-5.5565 ,6.1909>, 0.3000
<7.7695 ,-7.7791 ,8.6672>, 0.1000
}
cone {
<4.7818 ,-6.2397 ,6.1806>, 0.3000
<6.6945 ,-8.7356 ,8.6528>, 0.1000
}
cone {
<3.9305 ,-6.8175 ,6.1703>, 0.3000
<5.5027 ,-9.5445 ,8.6384>, 0.1000
}
cone {
<3.0101 ,-7.2797 ,6.1600>, 0.3000
<4.2141 ,-10.1916 ,8.6240>, 0.1000
}
cone {
<2.0362 ,-7.6181 ,6.1497>, 0.3000
<2.8507 ,-10.6653 ,8.6096>, 0.1000
}
cone {
<1.0255 ,-7.8267 ,6.1394>, 0.3000
<1.4356 ,-10.9573 ,8.5951>, 0.1000
}
cone {
<-0.0049 ,-7.9016 ,6.1290>, 0.3000
<-0.0069 ,-11.0622 ,8.5806>, 0.1000
}
cone {
<-1.0373 ,-7.8413 ,6.1187>, 0.3000
<-1.4522 ,-10.9778 ,8.5661>, 0.1000
}
cone {
<-2.0540 ,-7.6465 ,6.1083>, 0.3000
<-2.8756 ,-10.7052 ,8.5516>, 0.1000
}
cone {
<-3.0376 ,-7.3204 ,6.0979>, 0.3000
<-4.2526 ,-10.2486 ,8.5371>, 0.1000
}
cone {
<-3.9711 ,-6.8682 ,6.0876>, 0.3000
<-5.5595 ,-9.6155 ,8.5226>, 0.1000
}
cone {
<-4.8385 ,-6.2974 ,6.0772>, 0.3000
<-6.7738 ,-8.8164 ,8.5080>, 0.1000
}
cone {
<-5.6247 ,-5.6176 ,6.0668>, 0.3000
<-7.8745 ,-7.8646 ,8.4935>, 0.1000
}
cone {
<-6.3161 ,-4.8402 ,6.0564>, 0.3000
<-8.8425 ,-6.7762 ,8.4789>, 0.1000
}
cone {
<-6.9007 ,-3.9783 ,6.0459>, 0.3000
<-9.6610 ,-5.5696 ,8.4643>, 0.1000
}
cone {
<-7.3683 ,-3.0466 ,6.0355>, 0.3000
<-10.3156 ,-4.2652 ,8.4497>, 0.1000
}
cone {
<-7.7105 ,-2.0608 ,6.0251>, 0.3000
<-10.7947 ,-2.8851 ,8.4351>, 0.1000
}
cone {
<-7.9213 ,-1.0377 ,6.0146>, 0.3000
<-11.0899 ,-1.4528 ,8.4205>, 0.1000
}
cone {
<-7.9969 ,0.0051 ,6.0042>, 0.3000
<-11.1956 ,0.0072 ,8.4058>, 0.1000
}
cone {
<-7.9356 ,1.0499 ,5.9937>, 0.3000
<-11.1098 ,1.4699 ,8.3911>, 0.1000
}
cone {
<-7.7382 ,2.0788 ,5.9832>, 0.3000
<-10.8335 ,2.9103 ,8.3765>, 0.1000
}
cone {
<-7.4079 ,3.0740 ,5.9727>, 0.3000
<-10.3711 ,4.3037 ,8.3618>, 0.1000
}
cone {
<-6.9500 ,4.0186 ,5.9622>, 0.3000
<-9.7301 ,5.6260 ,8.3471>, 0.1000
}
cone {
<-6.3722 ,4.8961 ,5.9517>, 0.3000
<-8.9211 ,6.8546 ,8.3324>, 0.1000
}
cone {
<-5.6841 ,5.6915 ,5.9412>, 0.3000
<-7.9578 ,7.9681 ,8.3176>, 0.1000
}
cone {
<-4.8973 ,6.3909 ,5.9306>, 0.3000
<-6.8563 ,8.9473 ,8.3029>, 0.1000
}
cone {
<-4.0251 ,6.9822 ,5.9201>, 0.3000
<-5.6352 ,9.7751 ,8.2881>, 0.1000
}
cone {
<-3.0823 ,7.4550 ,5.9095>, 0.3000
<-4.3152 ,10.4370 ,8.2733>, 0.1000
}
cone {
<-2.0848 ,7.8010 ,5.8990>, 0.3000
<-2.9187 ,10.9214 ,8.2585>, 0.1000
}
cone {
<-1.0497 ,8.0140 ,5.8884>, 0.3000
<-1.4696 ,11.2197 ,8.2437>, 0.1000
}
cone {
<0.0053 ,8.0902 ,5.8778>, 0.3000
<0.0074 ,11.3263 ,8.2289>, 0.1000
}
cone {
<1.0623 ,8.0279 ,5.8672>, 0.3000
<1.4872 ,11.2391 ,8.2141>, 0.1000
}
cone {
<2.1030 ,7.8280 ,5.8566>, 0.3000
<2.9442 ,10.9592 ,8.1992>, 0.1000
}
cone {
<3.1097 ,7.4936 ,5.8460>, 0.3000
<4.3536 ,10.4910 ,8.1844>, 0.1000
}
cone {
<4.0651 ,7.0302 ,5.8354>, 0.3000
<5.6911 ,9.8423 ,8.1695>, 0.1000
}
cone {
<4.9526 ,6.4455 ,5.8247>, 0.3000
<6.9336 ,9.0237 ,8.1546>, 0.1000
}
cone {
<5.7569 ,5.7493 ,5.8141>, 0.3000
<8.0597 ,8.0490 ,8.1397>, 0.1000
}
cone {
<6.4641 ,4.9533 ,5.8034>, 0.3000
<9.0498 ,6.9346 ,8.1248>, 0.1000
}
cone {
<7.0620 ,4.0710 ,5.7928>, 0.3000
<9.8867 ,5.6993 ,8.1099>, 0.1000
}
cone {
<7.5399 ,3.1172 ,5.7821>, 0.3000
<10.5559 ,4.3641 ,8.0949>, 0.1000
}
cone {
<7.8896 ,2.1084 ,5.7714>, 0.3000
<11.0454 ,2.9517 ,8.0800>, 0.1000
}
cone {
<8.1048 ,1.0615 ,5.7607>, 0.3000
<11.3467 ,1.4861 ,8.0650>, 0.1000
}
cone {
<8.1815 ,-0.0055 ,5.7500>, 0.3000
<11.4541 ,-0.0077 ,8.0500>, 0.1000
}
cone {
<8.1183 ,-1.0744 ,5.7393>, 0.3000
<11.3656 ,-1.5041 ,8.0350>, 0.1000
}
cone {
<7.9158 ,-2.1268 ,5.7286>, 0.3000
<11.0822 ,-2.9775 ,8.0200>, 0.1000
}
cone {
<7.5774 ,-3.1447 ,5.7178>, 0.3000
<10.6084 ,-4.4025 ,8.0050>, 0.1000
}
cone {
<7.1086 ,-4.1106 ,5.7071>, 0.3000
<9.9521 ,-5.7548 ,7.9899>, 0.1000
}
cone {
<6.5172 ,-5.0078 ,5.6963>, 0.3000
<9.1240 ,-7.0110 ,7.9749>, 0.1000
}
cone {
<5.8130 ,-5.8209 ,5.6856>, 0.3000
<8.1382 ,-8.1493 ,7.9598>, 0.1000
}
cone {
<5.0080 ,-6.5358 ,5.6748>, 0.3000
<7.0112 ,-9.1501 ,7.9447>, 0.1000
}
cone {
<4.1158 ,-7.1400 ,5.6640>, 0.3000
<5.7621 ,-9.9960 ,7.9296>, 0.1000
}
cone {
<3.1514 ,-7.6230 ,5.6532>, 0.3000
<4.4120 ,-10.6722 ,7.9145>, 0.1000
}
cone {
<2.1314 ,-7.9762 ,5.6424>, 0.3000
<2.9839 ,-11.1667 ,7.8994>, 0.1000
}
cone {
<1.0730 ,-8.1935 ,5.6316>, 0.3000
<1.5022 ,-11.4709 ,7.8842>, 0.1000
}
cone {
<-0.0057 ,-8.2708 ,5.6208>, 0.3000
<-0.0080 ,-11.5792 ,7.8691>, 0.1000
}
cone {
<-1.0862 ,-8.2066 ,5.6099>, 0.3000
<-1.5207 ,-11.4893 ,7.8539>, 0.1000
}
cone {
<-2.1500 ,-8.0017 ,5.5991>, 0.3000
<-3.0100 ,-11.2024 ,7.8387>, 0.1000
}
cone {
<-3.1788 ,-7.6594 ,5.5883>, 0.3000
<-4.4504 ,-10.7232 ,7.8236>, 0.1000
}
cone {
<-4.1551 ,-7.1853 ,5.5774>, 0.3000
<-5.8171 ,-10.0594 ,7.8084>, 0.1000
}
cone {
<-5.0618 ,-6.5872 ,5.5665>, 0.3000
<-7.0866 ,-9.2221 ,7.7931>, 0.1000
}
cone {
<-5.8835 ,-5.8753 ,5.5556>, 0.3000
<-8.2369 ,-8.2254 ,7.7779>, 0.1000
}
cone {
<-6.6058 ,-5.0615 ,5.5448>, 0.3000
<-9.2481 ,-7.0861 ,7.7627>, 0.1000
}
cone {
<-7.2163 ,-4.1596 ,5.5339>, 0.3000
<-10.1028 ,-5.8234 ,7.7474>, 0.1000
}
cone {
<-7.7041 ,-3.1848 ,5.5229>, 0.3000
<-10.7858 ,-4.4588 ,7.7321>, 0.1000
}
cone {
<-8.0609 ,-2.1539 ,5.5120>, 0.3000
<-11.2853 ,-3.0154 ,7.7168>, 0.1000
}
cone {
<-8.2802 ,-1.0842 ,5.5011>, 0.3000
<-11.5923 ,-1.5179 ,7.7015>, 0.1000
}
cone {
<-8.3581 ,0.0059 ,5.4902>, 0.3000
<-11.7014 ,0.0082 ,7.6862>, 0.1000
}
cone {
<-8.2930 ,1.0977 ,5.4792>, 0.3000
<-11.6101 ,1.5368 ,7.6709>, 0.1000
}
cone {
<-8.0856 ,2.1727 ,5.4683>, 0.3000
<-11.3199 ,3.0417 ,7.6556>, 0.1000
}
cone {
<-7.7395 ,3.2122 ,5.4573>, 0.3000
<-10.8353 ,4.4971 ,7.6402>, 0.1000
}
cone {
<-7.2602 ,4.1985 ,5.4463>, 0.3000
<-10.1642 ,5.8779 ,7.6249>, 0.1000
}
cone {
<-6.6557 ,5.1146 ,5.4353>, 0.3000
<-9.3179 ,7.1604 ,7.6095>, 0.1000
}
cone {
<-5.9361 ,5.9446 ,5.4244>, 0.3000
<-8.3106 ,8.3225 ,7.5941>, 0.1000
}
cone {
<-5.1137 ,6.6742 ,5.4134>, 0.3000
<-7.1592 ,9.3439 ,7.5787>, 0.1000
}
cone {
<-4.2024 ,7.2907 ,5.4023>, 0.3000
<-5.8833 ,10.2070 ,7.5633>, 0.1000
}
cone {
<-3.2175 ,7.7834 ,5.3913>, 0.3000
<-4.5044 ,10.8968 ,7.5479>, 0.1000
}
cone {
<-2.1758 ,8.1436 ,5.3803>, 0.3000
<-3.0461 ,11.4010 ,7.5324>, 0.1000
}
cone {
<-1.0951 ,8.3649 ,5.3693>, 0.3000
<-1.5332 ,11.7109 ,7.5170>, 0.1000
}
cone {
<0.0061 ,8.4433 ,5.3582>, 0.3000
<0.0085 ,11.8206 ,7.5015>, 0.1000
}
cone {
<1.1090 ,8.3772 ,5.3472>, 0.3000
<1.5527 ,11.7281 ,7.4860>, 0.1000
}
cone {
<2.1948 ,8.1676 ,5.3361>, 0.3000
<3.0728 ,11.4346 ,7.4705>, 0.1000
}
cone {
<3.2448 ,7.8176 ,5.3250>, 0.3000
<4.5427 ,10.9447 ,7.4550>, 0.1000
}
cone {
<4.2410 ,7.3332 ,5.3139>, 0.3000
<5.9373 ,10.2665 ,7.4395>, 0.1000
}
cone {
<5.1661 ,6.7225 ,5.3028>, 0.3000
<7.2325 ,9.4114 ,7.4240>, 0.1000
}
cone {
<6.0043 ,5.9955 ,5.2917>, 0.3000
<8.4060 ,8.3937 ,7.4084>, 0.1000
}
cone {
<6.7410 ,5.1647 ,5.2806>, 0.3000
<9.4374 ,7.2306 ,7.3929>, 0.1000
}
cone {
<7.3634 ,4.2441 ,5.2695>, 0.3000
<10.3088 ,5.9417 ,7.3773>, 0.1000
}
cone {
<7.8608 ,3.2493 ,5.2584>, 0.3000
<11.0051 ,4.5490 ,7.3617>, 0.1000
}
cone {
<8.2243 ,2.1972 ,5.2472>, 0.3000
<11.5140 ,3.0761 ,7.3461>, 0.1000
}
cone {
<8.4475 ,1.1058 ,5.2361>, 0.3000
<11.8265 ,1.5481 ,7.3305>, 0.1000
}
cone {
<8.5264 ,-0.0063 ,5.2249>, 0.3000
<11.9370 ,-0.0088 ,7.3149>, 0.1000
}
cone {
<8.4594 ,-1.1201 ,5.2138>, 0.3000
<11.8432 ,-1.5681 ,7.2993>, 0.1000
}
cone {
<8.2475 ,-2.2164 ,5.2026>, 0.3000
<11.5464 ,-3.1030 ,7.2836>, 0.1000
}
cone {
<7.8939 ,-3.2766 ,5.1914>, 0.3000
<11.0514 ,-4.5873 ,7.2680>, 0.1000
}
cone {
<7.4045 ,-4.2823 ,5.1802>, 0.3000
<10.3663 ,-5.9953 ,7.2523>, 0.1000
}
cone {
<6.7876 ,-5.2163 ,5.1690>, 0.3000
<9.5026 ,-7.3029 ,7.2366>, 0.1000
}
cone {
<6.0534 ,-6.0625 ,5.1578>, 0.3000
<8.4748 ,-8.4874 ,7.2209>, 0.1000
}
cone {
<5.2144 ,-6.8061 ,5.1466>, 0.3000
<7.3002 ,-9.5285 ,7.2052>, 0.1000
}
cone {
<4.2848 ,-7.4343 ,5.1353>, 0.3000
<5.9987 ,-10.4080 ,7.1895>, 0.1000
}
cone {
<3.2803 ,-7.9362 ,5.1241>, 0.3000
<4.5924 ,-11.1107 ,7.1738>, 0.1000
}
cone {
<2.2181 ,-8.3029 ,5.1129>, 0.3000
<3.1053 ,-11.6241 ,7.1580>, 0.1000
}
cone {
<1.1162 ,-8.5280 ,5.1016>, 0.3000
<1.5627 ,-11.9393 ,7.1423>, 0.1000
}
cone {
<-0.0065 ,-8.6075 ,5.0903>, 0.3000
<-0.0091 ,-12.0504 ,7.1265>, 0.1000
}
cone {
<-1.1308 ,-8.5396 ,5.0791>, 0.3000
<-1.5831 ,-11.9554 ,7.1107>, 0.1000
}
cone {
<-2.2375 ,-8.3253 ,5.0678>, 0.3000
<-3.1325 ,-11.6554 ,7.0949>, 0.1000
}
cone {
<-3.3076 ,-7.9682 ,5.0565>, 0.3000
<-4.6306 ,-11.1554 ,7.0791>, 0.1000
}
cone {
<-4.3227 ,-7.4740 ,5.0452>, 0.3000
<-6.0517 ,-10.4636 ,7.0633>, 0.1000
}
cone {
<-5.2653 ,-6.8510 ,5.0339>, 0.3000
<-7.3714 ,-9.5915 ,7.0475>, 0.1000
}
cone {
<-6.1191 ,-6.1098 ,5.0226>, 0.3000
<-8.5668 ,-8.5537 ,7.0316>, 0.1000
}
cone {
<-6.8695 ,-5.2628 ,5.0113>, 0.3000
<-9.6173 ,-7.3679 ,7.0158>, 0.1000
}
cone {
<-7.5033 ,-4.3244 ,4.9999>, 0.3000
<-10.5047 ,-6.0542 ,6.9999>, 0.1000
}
cone {
<-8.0096 ,-3.3105 ,4.9886>, 0.3000
<-11.2135 ,-4.6347 ,6.9840>, 0.1000
}
cone {
<-8.3795 ,-2.2384 ,4.9772>, 0.3000
<-11.7314 ,-3.1338 ,6.9681>, 0.1000
}
cone {
<-8.6065 ,-1.1263 ,4.9659>, 0.3000
<-12.0491 ,-1.5769 ,6.9522>, 0.1000
}
cone {
<-8.6864 ,0.0067 ,4.9545>, 0.3000
<-12.1609 ,0.0094 ,6.9363>, 0.1000
}
cone {
<-8.6176 ,1.1413 ,4.9431>, 0.3000
<-12.0646 ,1.5978 ,6.9204>, 0.1000
}
cone {
<-8.4011 ,2.2580 ,4.9318>, 0.3000
<-11.7616 ,3.1613 ,6.9045>, 0.1000
}
cone {
<-8.0405 ,3.3378 ,4.9204>, 0.3000
<-11.2567 ,4.6729 ,6.8885>, 0.1000
}
cone {
<-7.5416 ,4.3619 ,4.9090>, 0.3000
<-10.5582 ,6.1067 ,6.8726>, 0.1000
}
cone {
<-6.9128 ,5.3129 ,4.8976>, 0.3000
<-9.6779 ,7.4381 ,6.8566>, 0.1000
}
cone {
<-6.1647 ,6.1743 ,4.8861>, 0.3000
<-8.6306 ,8.6440 ,6.8406>, 0.1000
}
cone {
<-5.3099 ,6.9312 ,4.8747>, 0.3000
<-7.4339 ,9.7037 ,6.8246>, 0.1000
}
cone {
<-4.3630 ,7.5705 ,4.8633>, 0.3000
<-6.1082 ,10.5987 ,6.8086>, 0.1000
}
cone {
<-3.3399 ,8.0811 ,4.8518>, 0.3000
<-4.6759 ,11.3136 ,6.7926>, 0.1000
}
cone {
<-2.2582 ,8.4541 ,4.8404>, 0.3000
<-3.1614 ,11.8357 ,6.7766>, 0.1000
}
cone {
<-1.1362 ,8.6828 ,4.8289>, 0.3000
<-1.5906 ,12.1559 ,6.7605>, 0.1000
}
cone {
<0.0069 ,8.7631 ,4.8175>, 0.3000
<0.0097 ,12.2683 ,6.7445>, 0.1000
}
cone {
<1.1515 ,8.6935 ,4.8060>, 0.3000
<1.6121 ,12.1709 ,6.7284>, 0.1000
}
cone {
<2.2780 ,8.4749 ,4.7945>, 0.3000
<3.1892 ,11.8648 ,6.7123>, 0.1000
}
cone {
<3.3671 ,8.1108 ,4.7830>, 0.3000
<4.7140 ,11.3551 ,6.6962>, 0.1000
}
cone {
<4.4001 ,7.6073 ,4.7715>, 0.3000
<6.1602 ,10.6503 ,6.6801>, 0.1000
}
cone {
<5.3593 ,6.9729 ,4.7600>, 0.3000
<7.5030 ,9.7620 ,6.6640>, 0.1000
}
cone {
<6.2280 ,6.2181 ,4.7485>, 0.3000
<8.7191 ,8.7053 ,6.6479>, 0.1000
}
cone {
<6.9912 ,5.3557 ,4.7370>, 0.3000
<9.7877 ,7.4980 ,6.6318>, 0.1000
}
cone {
<7.6359 ,4.4004 ,4.7254>, 0.3000
<10.6902 ,6.1606 ,6.6156>, 0.1000
}
cone {
<8.1506 ,3.3685 ,4.7139>, 0.3000
<11.4109 ,4.7159 ,6.5995>, 0.1000
}
cone {
<8.5265 ,2.2774 ,4.7023>, 0.3000
<11.9371 ,3.1883 ,6.5833>, 0.1000
}
cone {
<8.7569 ,1.1457 ,4.6908>, 0.3000
<12.2597 ,1.6040 ,6.5671>, 0.1000
}
cone {
<8.8377 ,-0.0071 ,4.6792>, 0.3000
<12.3728 ,-0.0099 ,6.5509>, 0.1000
}
cone {
<8.7672 ,-1.1614 ,4.6677>, 0.3000
<12.2741 ,-1.6260 ,6.5347>, 0.1000
}
cone {
<8.5465 ,-2.2974 ,4.6561>, 0.3000
<11.9651 ,-3.2164 ,6.5185>, 0.1000
}
cone {
<8.1791 ,-3.3957 ,4.6445>, 0.3000
<11.4508 ,-4.7539 ,6.5023>, 0.1000
}
cone {
<7.6712 ,-4.4372 ,4.6329>, 0.3000
<10.7397 ,-6.2121 ,6.4860>, 0.1000
}
cone {
<7.0312 ,-5.4043 ,4.6213>, 0.3000
<9.8437 ,-7.5660 ,6.4698>, 0.1000
}
cone {
<6.2699 ,-6.2801 ,4.6097>, 0.3000
<8.7778 ,-8.7921 ,6.4535>, 0.1000
}
cone {
<5.4002 ,-7.0495 ,4.5981>, 0.3000
<7.5603 ,-9.8693 ,6.4373>, 0.1000
}
cone {
<4.4368 ,-7.6993 ,4.5864>, 0.3000
<6.2116 ,-10.7790 ,6.4210>, 0.1000
}
cone {
<3.3962 ,-8.2181 ,4.5748>, 0.3000
<4.7547 ,-11.5053 ,6.4047>, 0.1000
}
cone {
<2.2960 ,-8.5969 ,4.5631>, 0.3000
<3.2144 ,-12.0356 ,6.3884>, 0.1000
}
cone {
<1.1550 ,-8.8289 ,4.5515>, 0.3000
<1.6170 ,-12.3605 ,6.3721>, 0.1000
}
cone {
<-0.0073 ,-8.9101 ,4.5398>, 0.3000
<-0.0102 ,-12.4741 ,6.3558>, 0.1000
}
cone {
<-1.1710 ,-8.8388 ,4.5282>, 0.3000
<-1.6395 ,-12.3743 ,6.3394>, 0.1000
}
cone {
<-2.3163 ,-8.6160 ,4.5165>, 0.3000
<-3.2428 ,-12.0625 ,6.3231>, 0.1000
}
cone {
<-3.4233 ,-8.2455 ,4.5048>, 0.3000
<-4.7927 ,-11.5436 ,6.3067>, 0.1000
}
cone {
<-4.4733 ,-7.7332 ,4.4931>, 0.3000
<-6.2626 ,-10.8264 ,6.2904>, 0.1000
}
cone {
<-5.4480 ,-7.0878 ,4.4814>, 0.3000
<-7.6271 ,-9.9229 ,6.2740>, 0.1000
}
cone {
<-6.3306 ,-6.3202 ,4.4697>, 0.3000
<-8.8629 ,-8.8482 ,6.2576>, 0.1000
}
cone {
<-7.1061 ,-5.4433 ,4.4580>, 0.3000
<-9.9485 ,-7.6207 ,6.2412>, 0.1000
}
cone {
<-7.7608 ,-4.4721 ,4.4463>, 0.3000
<-10.8652 ,-6.2610 ,6.2248>, 0.1000
}
cone {
<-8.2836 ,-3.4231 ,4.4345>, 0.3000
<-11.5970 ,-4.7923 ,6.2084>, 0.1000
}
cone {
<-8.6651 ,-2.3141 ,4.4228>, 0.3000
<-12.1311 ,-3.2397 ,6.1919>, 0.1000
}
cone {
<-8.8987 ,-1.1640 ,4.4111>, 0.3000
<-12.4582 ,-1.6296 ,6.1755>, 0.1000
}
cone {
<-8.9803 ,0.0075 ,4.3993>, 0.3000
<-12.5724 ,0.0105 ,6.1590>, 0.1000
}
cone {
<-8.9082 ,1.1804 ,4.3876>, 0.3000
<-12.4715 ,1.6525 ,6.1426>, 0.1000
}
cone {
<-8.6835 ,2.3345 ,4.3758>, 0.3000
<-12.1568 ,3.2684 ,6.1261>, 0.1000
}
cone {
<-8.3097 ,3.4501 ,4.3640>, 0.3000
<-11.6336 ,4.8302 ,6.1096>, 0.1000
}
cone {
<-7.7933 ,4.5081 ,4.3522>, 0.3000
<-10.9106 ,6.3113 ,6.0931>, 0.1000
}
cone {
<-7.1427 ,5.4902 ,4.3404>, 0.3000
<-9.9998 ,7.6862 ,6.0766>, 0.1000
}
cone {
<-6.3691 ,6.3795 ,4.3287>, 0.3000
<-8.9167 ,8.9313 ,6.0601>, 0.1000
}
cone {
<-5.4854 ,7.1607 ,4.3168>, 0.3000
<-7.6795 ,10.0250 ,6.0436>, 0.1000
}
cone {
<-4.5066 ,7.8203 ,4.3050>, 0.3000
<-6.3093 ,10.9484 ,6.0271>, 0.1000
}
cone {
<-3.4495 ,8.3468 ,4.2932>, 0.3000
<-4.8293 ,11.6855 ,6.0105>, 0.1000
}
cone {
<-2.3320 ,8.7311 ,4.2814>, 0.3000
<-3.2648 ,12.2235 ,5.9940>, 0.1000
}
cone {
<-1.1732 ,8.9663 ,4.2696>, 0.3000
<-1.6425 ,12.5528 ,5.9774>, 0.1000
}
cone {
<0.0071 ,9.0483 ,4.2577>, 0.3000
<0.0100 ,12.6676 ,5.9608>, 0.1000
}
cone {
<1.1888 ,8.9755 ,4.2459>, 0.3000
<1.6643 ,12.5657 ,5.9442>, 0.1000
}
cone {
<2.3515 ,8.7489 ,4.2340>, 0.3000
<3.2922 ,12.2485 ,5.9276>, 0.1000
}
cone {
<3.4755 ,8.3722 ,4.2222>, 0.3000
<4.8656 ,11.7211 ,5.9110>, 0.1000
}
cone {
<4.5412 ,7.8518 ,4.2103>, 0.3000
<6.3577 ,10.9925 ,5.8944>, 0.1000
}
cone {
<5.5306 ,7.1963 ,4.1984>, 0.3000
<7.7428 ,10.0748 ,5.8778>, 0.1000
}
cone {
<6.4264 ,6.4167 ,4.1865>, 0.3000
<8.9970 ,8.9834 ,5.8611>, 0.1000
}
cone {
<7.2133 ,5.5264 ,4.1746>, 0.3000
<10.0986 ,7.7369 ,5.8445>, 0.1000
}
cone {
<7.8776 ,4.5403 ,4.1627>, 0.3000
<11.0287 ,6.3565 ,5.8278>, 0.1000
}
cone {
<8.4079 ,3.4754 ,4.1508>, 0.3000
<11.7710 ,4.8655 ,5.8112>, 0.1000
}
cone {
<8.7948 ,2.3496 ,4.1389>, 0.3000
<12.3127 ,3.2895 ,5.7945>, 0.1000
}
cone {
<9.0316 ,1.1823 ,4.1270>, 0.3000
<12.6442 ,1.6553 ,5.7778>, 0.1000
}
cone {
<9.1141 ,-0.0066 ,4.1151>, 0.3000
<12.7597 ,-0.0092 ,5.7611>, 0.1000
}
cone {
<9.0406 ,-1.1968 ,4.1031>, 0.3000
<12.6568 ,-1.6755 ,5.7444>, 0.1000
}
cone {
<8.8122 ,-2.3680 ,4.0912>, 0.3000
<12.3371 ,-3.3151 ,5.7277>, 0.1000
}
cone {
<8.4327 ,-3.4999 ,4.0793>, 0.3000
<11.8058 ,-4.8999 ,5.7110>, 0.1000
}
cone {
<7.9084 ,-4.5733 ,4.0673>, 0.3000
<11.0717 ,-6.4026 ,5.6942>, 0.1000
}
cone {
<7.2480 ,-5.5696 ,4.0553>, 0.3000
<10.1472 ,-7.7975 ,5.6775>, 0.1000
}
cone {
<6.4628 ,-6.4717 ,4.0434>, 0.3000
<9.0479 ,-9.0604 ,5.6607>, 0.1000
}
cone {
<5.5660 ,-7.2641 ,4.0314>, 0.3000
<7.7924 ,-10.1697 ,5.6440>, 0.1000
}
cone {
<4.5729 ,-7.9330 ,4.0194>, 0.3000
<6.4021 ,-11.1062 ,5.6272>, 0.1000
}
cone {
<3.5004 ,-8.4669 ,4.0074>, 0.3000
<4.9005 ,-11.8536 ,5.6104>, 0.1000
}
cone {
<2.3667 ,-8.8564 ,3.9954>, 0.3000
<3.3134 ,-12.3989 ,5.5936>, 0.1000
}
cone {
<1.1912 ,-9.0947 ,3.9834>, 0.3000
<1.6677 ,-12.7326 ,5.5768>, 0.1000
}
cone {
<-0.0061 ,-9.1776 ,3.9714>, 0.3000
<-0.0085 ,-12.8486 ,5.5600>, 0.1000
}
cone {
<-1.2045 ,-9.1034 ,3.9594>, 0.3000
<-1.6864 ,-12.7448 ,5.5432>, 0.1000
}
cone {
<-2.3838 ,-8.8733 ,3.9474>, 0.3000
<-3.3373 ,-12.4226 ,5.5263>, 0.1000
}
cone {
<-3.5235 ,-8.4910 ,3.9353>, 0.3000
<-4.9329 ,-11.8875 ,5.5095>, 0.1000
}
cone {
<-4.6042 ,-7.9630 ,3.9233>, 0.3000
<-6.4459 ,-11.1482 ,5.4926>, 0.1000
}
cone {
<-5.6073 ,-7.2980 ,3.9113>, 0.3000
<-7.8502 ,-10.2172 ,5.4758>, 0.1000
}
cone {
<-6.5155 ,-6.5073 ,3.8992>, 0.3000
<-9.1217 ,-9.1102 ,5.4589>, 0.1000
}
cone {
<-7.3131 ,-5.6043 ,3.8872>, 0.3000
<-10.2384 ,-7.8460 ,5.4420>, 0.1000
}
cone {
<-7.9864 ,-4.6044 ,3.8751>, 0.3000
<-11.1810 ,-6.4462 ,5.4251>, 0.1000
}
cone {
<-8.5238 ,-3.5245 ,3.8630>, 0.3000
<-11.9333 ,-4.9344 ,5.4082>, 0.1000
}
cone {
<-8.9158 ,-2.3832 ,3.8510>, 0.3000
<-12.4821 ,-3.3364 ,5.3913>, 0.1000
}
cone {
<-9.1555 ,-1.1997 ,3.8389>, 0.3000
<-12.8177 ,-1.6796 ,5.3744>, 0.1000
}
cone {
<-9.2388 ,0.0055 ,3.8268>, 0.3000
<-12.9343 ,0.0077 ,5.3575>, 0.1000
}
cone {
<-9.1640 ,1.2120 ,3.8147>, 0.3000
<-12.8296 ,1.6968 ,5.3406>, 0.1000
}
cone {
<-8.9323 ,2.3990 ,3.8026>, 0.3000
<-12.5052 ,3.3586 ,5.3236>, 0.1000
}
cone {
<-8.5473 ,3.5462 ,3.7905>, 0.3000
<-11.9662 ,4.9647 ,5.3067>, 0.1000
}
cone {
<-8.0156 ,4.6340 ,3.7784>, 0.3000
<-11.2219 ,6.4876 ,5.2897>, 0.1000
}
cone {
<-7.3461 ,5.6435 ,3.7662>, 0.3000
<-10.2846 ,7.9010 ,5.2727>, 0.1000
}
cone {
<-6.5502 ,6.5576 ,3.7541>, 0.3000
<-9.1703 ,9.1806 ,5.2557>, 0.1000
}
cone {
<-5.6412 ,7.3603 ,3.7420>, 0.3000
<-7.8977 ,10.3044 ,5.2388>, 0.1000
}
cone {
<-4.6347 ,8.0379 ,3.7298>, 0.3000
<-6.4886 ,11.2530 ,5.2218>, 0.1000
}
cone {
<-3.5478 ,8.5786 ,3.7177>, 0.3000
<-4.9670 ,12.0100 ,5.2048>, 0.1000
}
cone {
<-2.3991 ,8.9729 ,3.7055>, 0.3000
<-3.3587 ,12.5621 ,5.1877>, 0.1000
}
cone {
<-1.2080 ,9.2141 ,3.6934>, 0.3000
<-1.6912 ,12.8997 ,5.1707>, 0.1000
}
cone {
<0.0050 ,9.2978 ,3.6812>, 0.3000
<0.0069 ,13.0169 ,5.1537>, 0.1000
}
cone {
<1.2191 ,9.2224 ,3.6690>, 0.3000
<1.7067 ,12.9113 ,5.1366>, 0.1000
}
cone {
<2.4136 ,8.9890 ,3.6568>, 0.3000
<3.3791 ,12.5846 ,5.1196>, 0.1000
}
cone {
<3.5681 ,8.6015 ,3.6447>, 0.3000
<4.9953 ,12.0421 ,5.1025>, 0.1000
}
cone {
<4.6626 ,8.0663 ,3.6325>, 0.3000
<6.5276 ,11.2928 ,5.0855>, 0.1000
}
cone {
<5.6784 ,7.3925 ,3.6203>, 0.3000
<7.9498 ,10.3495 ,5.0684>, 0.1000
}
cone {
<6.5981 ,6.5915 ,3.6081>, 0.3000
<9.2373 ,9.2280 ,5.0513>, 0.1000
}
cone {
<7.4057 ,5.6768 ,3.5959>, 0.3000
<10.3680 ,7.9475 ,5.0342>, 0.1000
}
cone {
<8.0873 ,4.6639 ,3.5836>, 0.3000
<11.3223 ,6.5295 ,5.0171>, 0.1000
}
cone {
<8.6312 ,3.5703 ,3.5714>, 0.3000
<12.0837 ,4.9984 ,5.0000>, 0.1000
}
cone {
<9.0279 ,2.4144 ,3.5592>, 0.3000
<12.6391 ,3.3801 ,4.9829>, 0.1000
}
cone {
<9.2704 ,1.2160 ,3.5469>, 0.3000
<12.9786 ,1.7024 ,4.9657>, 0.1000
}
cone {
<9.3545 ,-0.0044 ,3.5347>, 0.3000
<13.0962 ,-0.0061 ,4.9486>, 0.1000
}
cone {
<9.2784 ,-1.2259 ,3.5225>, 0.3000
<12.9898 ,-1.7163 ,4.9314>, 0.1000
}
cone {
<9.0435 ,-2.4276 ,3.5102>, 0.3000
<12.6609 ,-3.3987 ,4.9143>, 0.1000
}
cone {
<8.6535 ,-3.5890 ,3.4979>, 0.3000
<12.1149 ,-5.0246 ,4.8971>, 0.1000
}
cone {
<8.1150 ,-4.6901 ,3.4857>, 0.3000
<11.3610 ,-6.5661 ,4.8799>, 0.1000
}
cone {
<7.4371 ,-5.7119 ,3.4734>, 0.3000
<10.4119 ,-7.9966 ,4.8628>, 0.1000
}
cone {
<6.6311 ,-6.6369 ,3.4611>, 0.3000
<9.2836 ,-9.2917 ,4.8456>, 0.1000
}
cone {
<5.7109 ,-7.4492 ,3.4488>, 0.3000
<7.9952 ,-10.4289 ,4.8284>, 0.1000
}
cone {
<4.6920 ,-8.1348 ,3.4366>, 0.3000
<6.5688 ,-11.3887 ,4.8112>, 0.1000
}
cone {
<3.5918 ,-8.6818 ,3.4243>, 0.3000
<5.0286 ,-12.1545 ,4.7940>, 0.1000
}
cone {
<2.4291 ,-9.0806 ,3.4120>, 0.3000
<3.4007 ,-12.7129 ,4.7767>, 0.1000
}
cone {
<1.2237 ,-9.3244 ,3.3997>, 0.3000
<1.7132 ,-13.0542 ,4.7595>, 0.1000
}
cone {
<-0.0038 ,-9.4088 ,3.3873>, 0.3000
<-0.0053 ,-13.1723 ,4.7423>, 0.1000
}
cone {
<-1.2324 ,-9.3322 ,3.3750>, 0.3000
<-1.7254 ,-13.0651 ,4.7250>, 0.1000
}
cone {
<-2.4411 ,-9.0958 ,3.3627>, 0.3000
<-3.4175 ,-12.7341 ,4.7078>, 0.1000
}
cone {
<-3.6091 ,-8.7034 ,3.3504>, 0.3000
<-5.0527 ,-12.1848 ,4.6905>, 0.1000
}
cone {
<-4.7164 ,-8.1617 ,3.3380>, 0.3000
<-6.6029 ,-11.4264 ,4.6732>, 0.1000
}
cone {
<-5.7439 ,-7.4798 ,3.3257>, 0.3000
<-8.0415 ,-10.4717 ,4.6560>, 0.1000
}
cone {
<-6.6741 ,-6.6692 ,3.3133>, 0.3000
<-9.3438 ,-9.3368 ,4.6387>, 0.1000
}
cone {
<-7.4909 ,-5.7436 ,3.3010>, 0.3000
<-10.4873 ,-8.0411 ,4.6214>, 0.1000
}
cone {
<-8.1803 ,-4.7189 ,3.2886>, 0.3000
<-11.4524 ,-6.6065 ,4.6041>, 0.1000
}
cone {
<-8.7302 ,-3.6125 ,3.2763>, 0.3000
<-12.2222 ,-5.0575 ,4.5868>, 0.1000
}
cone {
<-9.1311 ,-2.4432 ,3.2639>, 0.3000
<-12.7836 ,-3.4205 ,4.5695>, 0.1000
}
cone {
<-9.3761 ,-1.2311 ,3.2515>, 0.3000
<-13.1266 ,-1.7235 ,4.5521>, 0.1000
}
cone {
<-9.4609 ,0.0032 ,3.2391>, 0.3000
<-13.2452 ,0.0045 ,4.5348>, 0.1000
}
cone {
<-9.3837 ,1.2386 ,3.2268>, 0.3000
<-13.1372 ,1.7340 ,4.5175>, 0.1000
}
cone {
<-9.1458 ,2.4539 ,3.2144>, 0.3000
<-12.8042 ,3.4354 ,4.5001>, 0.1000
}
cone {
<-8.7512 ,3.6282 ,3.2020>, 0.3000
<-12.2517 ,5.0795 ,4.4828>, 0.1000
}
cone {
<-8.2064 ,4.7415 ,3.1896>, 0.3000
<-11.4890 ,6.6381 ,4.4654>, 0.1000
}
cone {
<-7.5206 ,5.7746 ,3.1772>, 0.3000
<-10.5289 ,8.0844 ,4.4480>, 0.1000
}
cone {
<-6.7055 ,6.7097 ,3.1647>, 0.3000
<-9.3878 ,9.3936 ,4.4306>, 0.1000
}
cone {
<-5.7749 ,7.5308 ,3.1523>, 0.3000
<-8.0849 ,10.5431 ,4.4132>, 0.1000
}
cone {
<-4.7447 ,8.2237 ,3.1399>, 0.3000
<-6.6425 ,11.5132 ,4.3959>, 0.1000
}
cone {
<-3.6323 ,8.7764 ,3.1275>, 0.3000
<-5.0852 ,12.2870 ,4.3785>, 0.1000
}
cone {
<-2.4568 ,9.1794 ,3.1150>, 0.3000
<-3.4395 ,12.8511 ,4.3610>, 0.1000
}
cone {
<-1.2382 ,9.4255 ,3.1026>, 0.3000
<-1.7334 ,13.1958 ,4.3436>, 0.1000
}
cone {
<0.0027 ,9.5106 ,3.0901>, 0.3000
<0.0037 ,13.3148 ,4.3262>, 0.1000
}
cone {
<1.2445 ,9.4329 ,3.0777>, 0.3000
<1.7423 ,13.2060 ,4.3088>, 0.1000
}
cone {
<2.4661 ,9.1936 ,3.0652>, 0.3000
<3.4525 ,12.8711 ,4.2913>, 0.1000
}
cone {
<3.6465 ,8.7968 ,3.0528>, 0.3000
<5.1051 ,12.3155 ,4.2739>, 0.1000
}
cone {
<4.7654 ,8.2491 ,3.0403>, 0.3000
<6.6716 ,11.5487 ,4.2564>, 0.1000
}
cone {
<5.8038 ,7.5597 ,3.0278>, 0.3000
<8.1253 ,10.5835 ,4.2390>, 0.1000
}
cone {
<6.7436 ,6.7403 ,3.0154>, 0.3000
<9.4411 ,9.4364 ,4.2215>, 0.1000
}
cone {
<7.5688 ,5.8048 ,3.0029>, 0.3000
<10.5963 ,8.1268 ,4.2040>, 0.1000
}
cone {
<8.2651 ,4.7692 ,2.9904>, 0.3000
<11.5711 ,6.6769 ,4.1865>, 0.1000
}
cone {
<8.8205 ,3.6512 ,2.9779>, 0.3000
<12.3487 ,5.1116 ,4.1690>, 0.1000
}
cone {
<9.2253 ,2.4697 ,2.9654>, 0.3000
<12.9155 ,3.4576 ,4.1516>, 0.1000
}
cone {
<9.4726 ,1.2450 ,2.9529>, 0.3000
<13.2617 ,1.7430 ,4.1340>, 0.1000
}
cone {
<9.5579 ,-0.0021 ,2.9404>, 0.3000
<13.3811 ,-0.0029 ,4.1165>, 0.1000
}
cone {
<9.4797 ,-1.2501 ,2.9279>, 0.3000
<13.2716 ,-1.7501 ,4.0990>, 0.1000
}
cone {
<9.2392 ,-2.4777 ,2.9154>, 0.3000
<12.9348 ,-3.4687 ,4.0815>, 0.1000
}
cone {
<8.8403 ,-3.6638 ,2.9028>, 0.3000
<12.3763 ,-5.1293 ,4.0640>, 0.1000
}
cone {
<8.2897 ,-4.7882 ,2.8903>, 0.3000
<11.6056 ,-6.7035 ,4.0464>, 0.1000
}
cone {
<7.5968 ,-5.8315 ,2.8778>, 0.3000
<10.6356 ,-8.1641 ,4.0289>, 0.1000
}
cone {
<6.7734 ,-6.7758 ,2.8652>, 0.3000
<9.4827 ,-9.4862 ,4.0113>, 0.1000
}
cone {
<5.8333 ,-7.6049 ,2.8527>, 0.3000
<8.1666 ,-10.6469 ,3.9938>, 0.1000
}
cone {
<4.7927 ,-8.3045 ,2.8401>, 0.3000
<6.7097 ,-11.6262 ,3.9762>, 0.1000
}
cone {
<3.6692 ,-8.8624 ,2.8276>, 0.3000
<5.1368 ,-12.4073 ,3.9586>, 0.1000
}
cone {
<2.4820 ,-9.2690 ,2.8150>, 0.3000
<3.4748 ,-12.9767 ,3.9410>, 0.1000
}
cone {
<1.2515 ,-9.5174 ,2.8025>, 0.3000
<1.7520 ,-13.3243 ,3.9234>, 0.1000
}
cone {
<-0.0015 ,-9.6029 ,2.7899>, 0.3000
<-0.0020 ,-13.4441 ,3.9059>, 0.1000
}
cone {
<-1.2553 ,-9.5242 ,2.7773>, 0.3000
<-1.7574 ,-13.3339 ,3.8883>, 0.1000
}
cone {
<-2.4886 ,-9.2824 ,2.7647>, 0.3000
<-3.4841 ,-12.9954 ,3.8706>, 0.1000
}
cone {
<-3.6803 ,-8.8815 ,2.7522>, 0.3000
<-5.1524 ,-12.4341 ,3.8530>, 0.1000
}
cone {
<-4.8098 ,-8.3283 ,2.7396>, 0.3000
<-6.7337 ,-11.6596 ,3.8354>, 0.1000
}
cone {
<-5.8578 ,-7.6321 ,2.7270>, 0.3000
<-8.2010 ,-10.6850 ,3.8178>, 0.1000
}
cone {
<-6.8064 ,-6.8048 ,2.7144>, 0.3000
<-9.5290 ,-9.5267 ,3.8001>, 0.1000
}
cone {
<-7.6392 ,-5.8603 ,2.7018>, 0.3000
<-10.6948 ,-8.2045 ,3.7825>, 0.1000
}
cone {
<-8.3418 ,-4.8149 ,2.6892>, 0.3000
<-11.6785 ,-6.7409 ,3.7649>, 0.1000
}
cone {
<-8.9021 ,-3.6863 ,2.6766>, 0.3000
<-12.4629 ,-5.1608 ,3.7472>, 0.1000
}
cone {
<-9.3105 ,-2.4937 ,2.6640>, 0.3000
<-13.0346 ,-3.4912 ,3.7295>, 0.1000
}
cone {
<-9.5597 ,-1.2577 ,2.6513>, 0.3000
<-13.3836 ,-1.7607 ,3.7119>, 0.1000
}
cone {
<-9.6456 ,0.0009 ,2.6387>, 0.3000
<-13.5038 ,0.0012 ,3.6942>, 0.1000
}
cone {
<-9.5664 ,1.2602 ,2.6261>, 0.3000
<-13.3929 ,1.7643 ,3.6765>, 0.1000
}
cone {
<-9.3234 ,2.4990 ,2.6135>, 0.3000
<-13.0527 ,3.4986 ,3.6588>, 0.1000
}
cone {
<-8.9206 ,3.6958 ,2.6008>, 0.3000
<-12.4888 ,5.1741 ,3.6412>, 0.1000
}
cone {
<-8.3648 ,4.8302 ,2.5882>, 0.3000
<-11.7108 ,6.7623 ,3.6235>, 0.1000
}
cone {
<-7.6655 ,5.8827 ,2.5755>, 0.3000
<-10.7317 ,8.2358 ,3.6058>, 0.1000
}
cone {
<-6.8345 ,6.8353 ,2.5629>, 0.3000
<-9.5683 ,9.5694 ,3.5880>, 0.1000
}
cone {
<-5.8859 ,7.6715 ,2.5502>, 0.3000
<-8.2403 ,10.7401 ,3.5703>, 0.1000
}
cone {
<-4.8360 ,8.3770 ,2.5376>, 0.3000
<-6.7703 ,11.7278 ,3.5526>, 0.1000
}
cone {
<-3.7025 ,8.9396 ,2.5249>, 0.3000
<-5.1835 ,12.5154 ,3.5349>, 0.1000
}
cone {
<-2.5048 ,9.3496 ,2.5122>, 0.3000
<-3.5068 ,13.0894 ,3.5171>, 0.1000
}
cone {
<-1.2635 ,9.5998 ,2.4996>, 0.3000
<-1.7690 ,13.4397 ,3.4994>, 0.1000
}
cone {
<0.0002 ,9.6858 ,2.4869>, 0.3000
<0.0003 ,13.5602 ,3.4817>, 0.1000
}
cone {
<1.2649 ,9.6062 ,2.4742>, 0.3000
<1.7708 ,13.4486 ,3.4639>, 0.1000
}
cone {
<2.5087 ,9.3620 ,2.4615>, 0.3000
<3.5122 ,13.1068 ,3.4461>, 0.1000
}
cone {
<3.7104 ,8.9575 ,2.4488>, 0.3000
<5.1946 ,12.5404 ,3.4284>, 0.1000
}
cone {
<4.8494 ,8.3993 ,2.4361>, 0.3000
<6.7892 ,11.7590 ,3.4106>, 0.1000
}
cone {
<5.9061 ,7.6970 ,2.4235>, 0.3000
<8.2686 ,10.7759 ,3.3928>, 0.1000
}
cone {
<6.8625 ,6.8626 ,2.4108>, 0.3000
<9.6075 ,9.6076 ,3.3751>, 0.1000
}
cone {
<7.7020 ,5.9101 ,2.3980>, 0.3000
<10.7828 ,8.2741 ,3.3573>, 0.1000
}
cone {
<8.4102 ,4.8558 ,2.3853>, 0.3000
<11.7743 ,6.7981 ,3.3395>, 0.1000
}
cone {
<8.9749 ,3.7178 ,2.3726>, 0.3000
<12.5649 ,5.2049 ,3.3217>, 0.1000
}
cone {
<9.3864 ,2.5153 ,2.3599>, 0.3000
<13.1409 ,3.5215 ,3.3039>, 0.1000
}
cone {
<9.6374 ,1.2691 ,2.3472>, 0.3000
<13.4924 ,1.7768 ,3.2861>, 0.1000
}
cone {
<9.7237 ,0.0004 ,2.3345>, 0.3000
<13.6132 ,0.0005 ,3.2682>, 0.1000
}
cone {
<9.6436 ,-1.2692 ,2.3217>, 0.3000
<13.5010 ,-1.7768 ,3.2504>, 0.1000
}
cone {
<9.3984 ,-2.5178 ,2.3090>, 0.3000
<13.1577 ,-3.5249 ,3.2326>, 0.1000
}
cone {
<8.9921 ,-3.7241 ,2.2963>, 0.3000
<12.5890 ,-5.2137 ,3.2148>, 0.1000
}
cone {
<8.4317 ,-4.8674 ,2.2835>, 0.3000
<11.8044 ,-6.8144 ,3.1969>, 0.1000
}
cone {
<7.7267 ,-5.9281 ,2.2708>, 0.3000
<10.8173 ,-8.2993 ,3.1791>, 0.1000
}
cone {
<6.8889 ,-6.8880 ,2.2580>, 0.3000
<9.6445 ,-9.6431 ,3.1612>, 0.1000
}
cone {
<5.9328 ,-7.7305 ,2.2453>, 0.3000
<8.3059 ,-10.8227 ,3.1434>, 0.1000
}
cone {
<4.8745 ,-8.4413 ,2.2325>, 0.3000
<6.8243 ,-11.8178 ,3.1255>, 0.1000
}
cone {
<3.7321 ,-9.0080 ,2.2197>, 0.3000
<5.2250 ,-12.6112 ,3.1076>, 0.1000
}
cone {
<2.5252 ,-9.4209 ,2.2070>, 0.3000
<3.5353 ,-13.1892 ,3.0898>, 0.1000
}
cone {
<1.2744 ,-9.6727 ,2.1942>, 0.3000
<1.7841 ,-13.5418 ,3.0719>, 0.1000
}
cone {
<0.0010 ,-9.7592 ,2.1814>, 0.3000
<0.0014 ,-13.6628 ,3.0540>, 0.1000
}
cone {
<-1.2732 ,-9.6786 ,2.1687>, 0.3000
<-1.7824 ,-13.5501 ,3.0361>, 0.1000
}
cone {
<-2.5263 ,-9.4324 ,2.1559>, 0.3000
<-3.5368 ,-13.2054 ,3.0182>, 0.1000
}
cone {
<-3.7369 ,-9.0246 ,2.1431>, 0.3000
<-5.2316 ,-12.6344 ,3.0003>, 0.1000
}
cone {
<-4.8842 ,-8.4621 ,2.1303>, 0.3000
<-6.8379 ,-11.8469 ,2.9824>, 0.1000
}
cone {
<-5.9486 ,-7.7544 ,2.1175>, 0.3000
<-8.3280 ,-10.8561 ,2.9645>, 0.1000
}
cone {
<-6.9118 ,-6.9136 ,2.1047>, 0.3000
<-9.6765 ,-9.6790 ,2.9466>, 0.1000
}
cone {
<-7.7572 ,-5.9540 ,2.0919>, 0.3000
<-10.8600 ,-8.3356 ,2.9287>, 0.1000
}
cone {
<-8.4703 ,-4.8920 ,2.0791>, 0.3000
<-11.8584 ,-6.8487 ,2.9108>, 0.1000
}
cone {
<-9.0389 ,-3.7456 ,2.0663>, 0.3000
<-12.6544 ,-5.2438 ,2.8929>, 0.1000
}
cone {
<-9.4530 ,-2.5345 ,2.0535>, 0.3000
<-13.2342 ,-3.5483 ,2.8749>, 0.1000
}
cone {
<-9.7056 ,-1.2793 ,2.0407>, 0.3000
<-13.5878 ,-1.7911 ,2.8570>, 0.1000
}
cone {
<-9.7922 ,-0.0016 ,2.0279>, 0.3000
<-13.7091 ,-0.0023 ,2.8390>, 0.1000
}
cone {
<-9.7113 ,1.2768 ,2.0151>, 0.3000
<-13.5958 ,1.7876 ,2.8211>, 0.1000
}
cone {
<-9.4641 ,2.5341 ,2.0022>, 0.3000
<-13.2497 ,3.5478 ,2.8031>, 0.1000
}
cone {
<-9.0548 ,3.7487 ,1.9894>, 0.3000
<-12.6767 ,5.2482 ,2.7852>, 0.1000
}
cone {
<-8.4903 ,4.8998 ,1.9766>, 0.3000
<-11.8864 ,6.8597 ,2.7672>, 0.1000
}
cone {
<-7.7802 ,5.9676 ,1.9638>, 0.3000
<-10.8923 ,8.3546 ,2.7493>, 0.1000
}
cone {
<-6.9366 ,6.9338 ,1.9509>, 0.3000
<-9.7112 ,9.7074 ,2.7313>, 0.1000
}
cone {
<-5.9738 ,7.7819 ,1.9381>, 0.3000
<-8.3633 ,10.8947 ,2.7133>, 0.1000
}
cone {
<-4.9082 ,8.4972 ,1.9252>, 0.3000
<-6.8715 ,11.8961 ,2.6953>, 0.1000
}
cone {
<-3.7581 ,9.0675 ,1.9124>, 0.3000
<-5.2614 ,12.6945 ,2.6774>, 0.1000
}
cone {
<-2.5431 ,9.4828 ,1.8995>, 0.3000
<-3.5604 ,13.2760 ,2.6594>, 0.1000
}
cone {
<-1.2840 ,9.7361 ,1.8867>, 0.3000
<-1.7976 ,13.6305 ,2.6414>, 0.1000
}
cone {
<-0.0022 ,9.8229 ,1.8738>, 0.3000
<-0.0031 ,13.7520 ,2.6234>, 0.1000
}
cone {
<1.2802 ,9.7416 ,1.8610>, 0.3000
<1.7923 ,13.6382 ,2.6054>, 0.1000
}
cone {
<2.5413 ,9.4935 ,1.8481>, 0.3000
<3.5579 ,13.2909 ,2.5874>, 0.1000
}
cone {
<3.7596 ,9.0828 ,1.8352>, 0.3000
<5.2635 ,12.7159 ,2.5694>, 0.1000
}
cone {
<4.9141 ,8.5165 ,1.8224>, 0.3000
<6.8798 ,11.9230 ,2.5513>, 0.1000
}
cone {
<5.9851 ,7.8041 ,1.8095>, 0.3000
<8.3792 ,10.9257 ,2.5333>, 0.1000
}
cone {
<6.9542 ,6.9578 ,1.7966>, 0.3000
<9.7359 ,9.7409 ,2.5153>, 0.1000
}
cone {
<7.8047 ,5.9921 ,1.7838>, 0.3000
<10.9266 ,8.3889 ,2.4973>, 0.1000
}
cone {
<8.5220 ,4.9233 ,1.7709>, 0.3000
<11.9309 ,6.8926 ,2.4792>, 0.1000
}
cone {
<9.0939 ,3.7697 ,1.7580>, 0.3000
<12.7314 ,5.2776 ,2.4612>, 0.1000
}
cone {
<9.5103 ,2.5512 ,1.7451>, 0.3000
<13.3145 ,3.5716 ,2.4431>, 0.1000
}
cone {
<9.7642 ,1.2883 ,1.7322>, 0.3000
<13.6699 ,1.8037 ,2.4251>, 0.1000
}
cone {
<9.8511 ,0.0029 ,1.7193>, 0.3000
<13.7915 ,0.0040 ,2.4070>, 0.1000
}
cone {
<9.7694 ,-1.2832 ,1.7064>, 0.3000
<13.6772 ,-1.7965 ,2.3890>, 0.1000
}
cone {
<9.5205 ,-2.5479 ,1.6935>, 0.3000
<13.3287 ,-3.5671 ,2.3709>, 0.1000
}
cone {
<9.1085 ,-3.7696 ,1.6806>, 0.3000
<12.7520 ,-5.2774 ,2.3529>, 0.1000
}
cone {
<8.5405 ,-4.9273 ,1.6677>, 0.3000
<11.9567 ,-6.8982 ,2.3348>, 0.1000
}
cone {
<7.8261 ,-6.0012 ,1.6548>, 0.3000
<10.9565 ,-8.4017 ,2.3167>, 0.1000
}
cone {
<6.9774 ,-6.9728 ,1.6419>, 0.3000
<9.7683 ,-9.7620 ,2.2987>, 0.1000
}
cone {
<6.0089 ,-7.8256 ,1.6290>, 0.3000
<8.4124 ,-10.9558 ,2.2806>, 0.1000
}
cone {
<4.9371 ,-8.5448 ,1.6161>, 0.3000
<6.9120 ,-11.9627 ,2.2625>, 0.1000
}
cone {
<3.7804 ,-9.1180 ,1.6031>, 0.3000
<5.2926 ,-12.7652 ,2.2444>, 0.1000
}
cone {
<2.5585 ,-9.5355 ,1.5902>, 0.3000
<3.5820 ,-13.3496 ,2.2263>, 0.1000
}
cone {
<1.2923 ,-9.7899 ,1.5773>, 0.3000
<1.8093 ,-13.7058 ,2.2082>, 0.1000
}
cone {
<0.0035 ,-9.8769 ,1.5644>, 0.3000
<0.0049 ,-13.8276 ,2.1901>, 0.1000
}
cone {
<-1.2859 ,-9.7949 ,1.5515>, 0.3000
<-1.8003 ,-13.7128 ,2.1720>, 0.1000
}
cone {
<-2.5539 ,-9.5452 ,1.5385>, 0.3000
<-3.5754 ,-13.3633 ,2.1539>, 0.1000
}
cone {
<-3.7787 ,-9.1321 ,1.5256>, 0.3000
<-5.2901 ,-12.7849 ,2.1358>, 0.1000
}
cone {
<-4.9392 ,-8.5625 ,1.5126>, 0.3000
<-6.9149 ,-11.9874 ,2.1177>, 0.1000
}
cone {
<-6.0158 ,-7.8461 ,1.4997>, 0.3000
<-8.4221 ,-10.9845 ,2.0996>, 0.1000
}
cone {
<-6.9898 ,-6.9952 ,1.4868>, 0.3000
<-9.7857 ,-9.7933 ,2.0815>, 0.1000
}
cone {
<-7.8445 ,-6.0242 ,1.4738>, 0.3000
<-10.9823 ,-8.4339 ,2.0633>, 0.1000
}
cone {
<-8.5654 ,-4.9498 ,1.4609>, 0.3000
<-11.9915 ,-6.9297 ,2.0452>, 0.1000
}
cone {
<-9.1399 ,-3.7902 ,1.4479>, 0.3000
<-12.7959 ,-5.3063 ,2.0271>, 0.1000
}
cone {
<-9.5582 ,-2.5653 ,1.4350>, 0.3000
<-13.3815 ,-3.5914 ,2.0090>, 0.1000
}
cone {
<-9.8132 ,-1.2961 ,1.4220>, 0.3000
<-13.7384 ,-1.8145 ,1.9908>, 0.1000
}
cone {
<-9.9002 ,-0.0041 ,1.4091>, 0.3000
<-13.8603 ,-0.0058 ,1.9727>, 0.1000
}
cone {
<-9.8179 ,1.2883 ,1.3961>, 0.3000
<-13.7451 ,1.8036 ,1.9545>, 0.1000
}
cone {
<-9.5675 ,2.5592 ,1.3831>, 0.3000
<-13.3945 ,3.5829 ,1.9364>, 0.1000
}
cone {
<-9.1533 ,3.7868 ,1.3702>, 0.3000
<-12.8146 ,5.3015 ,1.9182>, 0.1000
}
cone {
<-8.5823 ,4.9500 ,1.3572>, 0.3000
<-12.0152 ,6.9299 ,1.9001>, 0.1000
}
cone {
<-7.8642 ,6.0289 ,1.3442>, 0.3000
<-11.0099 ,8.4404 ,1.8819>, 0.1000
}
cone {
<-7.0113 ,7.0050 ,1.3313>, 0.3000
<-9.8158 ,9.8070 ,1.8638>, 0.1000
}
cone {
<-6.0381 ,7.8615 ,1.3183>, 0.3000
<-8.4533 ,11.0062 ,1.8456>, 0.1000
}
cone {
<-4.9612 ,8.5839 ,1.3053>, 0.3000
<-6.9457 ,12.0174 ,1.8274>, 0.1000
}
cone {
<-3.7990 ,9.1596 ,1.2923>, 0.3000
<-5.3186 ,12.8234 ,1.8093>, 0.1000
}
cone {
<-2.5714 ,9.5787 ,1.2793>, 0.3000
<-3.6000 ,13.4101 ,1.7911>, 0.1000
}
cone {
<-1.2994 ,9.8340 ,1.2664>, 0.3000
<-1.8192 ,13.7676 ,1.7729>, 0.1000
}
cone {
<-0.0048 ,9.9211 ,1.2534>, 0.3000
<-0.0067 ,13.8896 ,1.7547>, 0.1000
}
cone {
<1.2904 ,9.8385 ,1.2404>, 0.3000
<1.8065 ,13.7739 ,1.7366>, 0.1000
}
cone {
<2.5639 ,9.5875 ,1.2274>, 0.3000
<3.5895 ,13.4225 ,1.7184>, 0.1000
}
cone {
<3.7939 ,9.1723 ,1.2144>, 0.3000
<5.3115 ,12.8412 ,1.7002>, 0.1000
}
cone {
<4.9595 ,8.6000 ,1.2014>, 0.3000
<6.9432 ,12.0400 ,1.6820>, 0.1000
}
cone {
<6.0405 ,7.8804 ,1.1884>, 0.3000
<8.4567 ,11.0325 ,1.6638>, 0.1000
}
cone {
<7.0184 ,7.0257 ,1.1754>, 0.3000
<9.8258 ,9.8359 ,1.6456>, 0.1000
}
cone {
<7.8766 ,6.0504 ,1.1624>, 0.3000
<11.0273 ,8.4706 ,1.6274>, 0.1000
}
cone {
<8.6002 ,4.9714 ,1.1494>, 0.3000
<12.0403 ,6.9599 ,1.6092>, 0.1000
}
cone {
<9.1769 ,3.8069 ,1.1364>, 0.3000
<12.8477 ,5.3297 ,1.5910>, 0.1000
}
cone {
<9.5967 ,2.5769 ,1.1234>, 0.3000
<13.4354 ,3.6077 ,1.5728>, 0.1000
}
cone {
<9.8524 ,1.3025 ,1.1104>, 0.3000
<13.7934 ,1.8235 ,1.5546>, 0.1000
}
cone {
<9.9396 ,0.0054 ,1.0974>, 0.3000
<13.9154 ,0.0076 ,1.5364>, 0.1000
}
cone {
<9.8567 ,-1.2921 ,1.0844>, 0.3000
<13.7994 ,-1.8090 ,1.5181>, 0.1000
}
cone {
<9.6051 ,-2.5680 ,1.0714>, 0.3000
<13.4471 ,-3.5951 ,1.4999>, 0.1000
}
cone {
<9.1890 ,-3.8002 ,1.0584>, 0.3000
<12.8647 ,-5.3203 ,1.4817>, 0.1000
}
cone {
<8.6156 ,-4.9677 ,1.0453>, 0.3000
<12.0619 ,-6.9548 ,1.4635>, 0.1000
}
cone {
<7.8946 ,-6.0506 ,1.0323>, 0.3000
<11.0525 ,-8.4708 ,1.4452>, 0.1000
}
cone {
<7.0383 ,-7.0302 ,1.0193>, 0.3000
<9.8536 ,-9.8422 ,1.4270>, 0.1000
}
cone {
<6.0613 ,-7.8897 ,1.0063>, 0.3000
<8.4858 ,-11.0456 ,1.4088>, 0.1000
}
cone {
<4.9803 ,-8.6145 ,0.9933>, 0.3000
<6.9725 ,-12.0603 ,1.3906>, 0.1000
}
cone {
<3.8139 ,-9.1920 ,0.9802>, 0.3000
<5.3394 ,-12.8689 ,1.3723>, 0.1000
}
cone {
<2.5818 ,-9.6124 ,0.9672>, 0.3000
<3.6145 ,-13.4574 ,1.3541>, 0.1000
}
cone {
<1.3053 ,-9.8684 ,0.9542>, 0.3000
<1.8274 ,-13.8158 ,1.3358>, 0.1000
}
cone {
<0.0061 ,-9.9556 ,0.9411>, 0.3000
<0.0085 ,-13.9379 ,1.3176>, 0.1000
}
cone {
<-1.2936 ,-9.8725 ,0.9281>, 0.3000
<-1.8110 ,-13.8214 ,1.2994>, 0.1000
}
cone {
<-2.5714 ,-9.6203 ,0.9151>, 0.3000
<-3.5999 ,-13.4685 ,1.2811>, 0.1000
}
cone {
<-3.8055 ,-9.2035 ,0.9020>, 0.3000
<-5.3277 ,-12.8849 ,1.2629>, 0.1000
}
cone {
<-4.9748 ,-8.6291 ,0.8890>, 0.3000
<-6.9647 ,-12.0807 ,1.2446>, 0.1000
}
cone {
<-6.0592 ,-7.9069 ,0.8760>, 0.3000
<-8.4829 ,-11.0696 ,1.2264>, 0.1000
}
cone {
<-7.0402 ,-7.0492 ,0.8629>, 0.3000
<-9.8562 ,-9.8689 ,1.2081>, 0.1000
}
cone {
<-7.9009 ,-6.0707 ,0.8499>, 0.3000
<-11.0613 ,-8.4990 ,1.1898>, 0.1000
}
cone {
<-8.6266 ,-4.9881 ,0.8368>, 0.3000
<-12.0773 ,-6.9833 ,1.1716>, 0.1000
}
cone {
<-9.2049 ,-3.8199 ,0.8238>, 0.3000
<-12.8868 ,-5.3478 ,1.1533>, 0.1000
}
cone {
<-9.6258 ,-2.5860 ,0.8108>, 0.3000
<-13.4761 ,-3.6205 ,1.1351>, 0.1000
}
cone {
<-9.8820 ,-1.3077 ,0.7977>, 0.3000
<-13.8348 ,-1.8308 ,1.1168>, 0.1000
}
cone {
<-9.9692 ,-0.0067 ,0.7847>, 0.3000
<-13.9568 ,-0.0094 ,1.0985>, 0.1000
}
cone {
<-9.8858 ,1.2947 ,0.7716>, 0.3000
<-13.8401 ,1.8125 ,1.0802>, 0.1000
}
cone {
<-9.6332 ,2.5742 ,0.7586>, 0.3000
<-13.4865 ,3.6038 ,1.0620>, 0.1000
}
cone {
<-9.2157 ,3.8098 ,0.7455>, 0.3000
<-12.9020 ,5.3338 ,1.0437>, 0.1000
}
cone {
<-8.6404 ,4.9806 ,0.7325>, 0.3000
<-12.0966 ,6.9728 ,1.0254>, 0.1000
}
cone {
<-7.9172 ,6.0663 ,0.7194>, 0.3000
<-11.0841 ,8.4928 ,1.0072>, 0.1000
}
cone {
<-7.0584 ,7.0484 ,0.7063>, 0.3000
<-9.8817 ,9.8678 ,0.9889>, 0.1000
}
cone {
<-6.0786 ,7.9101 ,0.6933>, 0.3000
<-8.5100 ,11.0742 ,0.9706>, 0.1000
}
cone {
<-4.9946 ,8.6366 ,0.6802>, 0.3000
<-6.9924 ,12.0913 ,0.9523>, 0.1000
}
cone {
<-3.8249 ,9.2155 ,0.6672>, 0.3000
<-5.3549 ,12.9016 ,0.9340>, 0.1000
}
cone {
<-2.5896 ,9.6367 ,0.6541>, 0.3000
<-3.6255 ,13.4914 ,0.9157>, 0.1000
}
cone {
<-1.3098 ,9.8931 ,0.6410>, 0.3000
<-1.8337 ,13.8503 ,0.8975>, 0.1000
}
cone {
<-0.0073 ,9.9803 ,0.6280>, 0.3000
<-0.0103 ,13.9724 ,0.8792>, 0.1000
}
cone {
<1.2955 ,9.8966 ,0.6149>, 0.3000
<1.8136 ,13.8553 ,0.8609>, 0.1000
}
cone {
<2.5763 ,9.6437 ,0.6019>, 0.3000
<3.6068 ,13.5011 ,0.8426>, 0.1000
}
cone {
<3.8133 ,9.2256 ,0.5888>, 0.3000
<5.3386 ,12.9159 ,0.8243>, 0.1000
}
cone {
<4.9852 ,8.6497 ,0.5757>, 0.3000
<6.9792 ,12.1095 ,0.8060>, 0.1000
}
cone {
<6.0719 ,7.9256 ,0.5626>, 0.3000
<8.5007 ,11.0958 ,0.7877>, 0.1000
}
cone {
<7.0550 ,7.0658 ,0.5496>, 0.3000
<9.8769 ,9.8921 ,0.7694>, 0.1000
}
cone {
<7.9174 ,6.0850 ,0.5365>, 0.3000
<11.0844 ,8.5190 ,0.7511>, 0.1000
}
cone {
<8.6445 ,4.9999 ,0.5234>, 0.3000
<12.1023 ,6.9998 ,0.7328>, 0.1000
}
cone {
<9.2238 ,3.8291 ,0.5104>, 0.3000
<12.9133 ,5.3607 ,0.7145>, 0.1000
}
cone {
<9.6453 ,2.5926 ,0.4973>, 0.3000
<13.5034 ,3.6296 ,0.6962>, 0.1000
}
cone {
<9.9018 ,1.3116 ,0.4842>, 0.3000
<13.8625 ,1.8362 ,0.6779>, 0.1000
}
cone {
<9.9889 ,0.0080 ,0.4711>, 0.3000
<13.9844 ,0.0112 ,0.6596>, 0.1000
}
cone {
<9.9051 ,-1.2959 ,0.4581>, 0.3000
<13.8671 ,-1.8143 ,0.6413>, 0.1000
}
cone {
<9.6518 ,-2.5778 ,0.4450>, 0.3000
<13.5125 ,-3.6089 ,0.6230>, 0.1000
}
cone {
<9.2333 ,-3.8157 ,0.4319>, 0.3000
<12.9266 ,-5.3420 ,0.6047>, 0.1000
}
cone {
<8.6567 ,-4.9885 ,0.4188>, 0.3000
<12.1195 ,-6.9839 ,0.5864>, 0.1000
}
cone {
<7.9320 ,-6.0761 ,0.4058>, 0.3000
<11.1048 ,-8.5065 ,0.5681>, 0.1000
}
cone {
<7.0715 ,-7.0597 ,0.3927>, 0.3000
<9.9001 ,-9.8836 ,0.5498>, 0.1000
}
cone {
<6.0899 ,-7.9227 ,0.3796>, 0.3000
<8.5258 ,-11.0918 ,0.5315>, 0.1000
}
cone {
<5.0039 ,-8.6502 ,0.3665>, 0.3000
<7.0055 ,-12.1103 ,0.5131>, 0.1000
}
cone {
<3.8323 ,-9.2298 ,0.3534>, 0.3000
<5.3652 ,-12.9217 ,0.4948>, 0.1000
}
cone {
<2.5949 ,-9.6515 ,0.3404>, 0.3000
<3.6329 ,-13.5120 ,0.4765>, 0.1000
}
cone {
<1.3131 ,-9.9080 ,0.3273>, 0.3000
<1.8383 ,-13.8712 ,0.4582>, 0.1000
}
cone {
<0.0086 ,-9.9951 ,0.3142>, 0.3000
<0.0121 ,-13.9931 ,0.4399>, 0.1000
}
cone {
<-1.2961 ,-9.9111 ,0.3011>, 0.3000
<-1.8145 ,-13.8755 ,0.4216>, 0.1000
}
cone {
<-2.5787 ,-9.6575 ,0.2880>, 0.3000
<-3.6102 ,-13.5205 ,0.4032>, 0.1000
}
cone {
<-3.8173 ,-9.2387 ,0.2749>, 0.3000
<-5.3442 ,-12.9341 ,0.3849>, 0.1000
}
cone {
<-4.9906 ,-8.6617 ,0.2619>, 0.3000
<-6.9869 ,-12.1264 ,0.3666>, 0.1000
}
cone {
<-6.0787 ,-7.9365 ,0.2488>, 0.3000
<-8.5101 ,-11.1111 ,0.3483>, 0.1000
}
cone {
<-7.0628 ,-7.0754 ,0.2357>, 0.3000
<-9.8879 ,-9.9056 ,0.3300>, 0.1000
}
cone {
<-7.9261 ,-6.0932 ,0.2226>, 0.3000
<-11.0965 ,-8.5305 ,0.3116>, 0.1000
}
cone {
<-8.6538 ,-5.0067 ,0.2095>, 0.3000
<-12.1154 ,-7.0094 ,0.2933>, 0.1000
}
cone {
<-9.2335 ,-3.8345 ,0.1964>, 0.3000
<-12.9269 ,-5.3683 ,0.2750>, 0.1000
}
cone {
<-9.6553 ,-2.5966 ,0.1834>, 0.3000
<-13.5174 ,-3.6352 ,0.2567>, 0.1000
}
cone {
<-9.9118 ,-1.3142 ,0.1703>, 0.3000
<-13.8765 ,-1.8399 ,0.2384>, 0.1000
}
cone {
<-9.9988 ,-0.0093 ,0.1572>, 0.3000
<-13.9983 ,-0.0130 ,0.2200>, 0.1000
}
cone {
<-9.9146 ,1.2959 ,0.1441>, 0.3000
<-13.8805 ,1.8142 ,0.2017>, 0.1000
}
cone {
<-9.6608 ,2.5789 ,0.1310>, 0.3000
<-13.5252 ,3.6105 ,0.1834>, 0.1000
}
cone {
<-9.2418 ,3.8179 ,0.1179>, 0.3000
<-12.9385 ,5.3450 ,0.1650>, 0.1000
}
cone {
<-8.6645 ,4.9915 ,0.1048>, 0.3000
<-12.1303 ,6.9881 ,0.1467>, 0.1000
}
cone {
<-7.9390 ,6.0798 ,0.0917>, 0.3000
<-11.1146 ,8.5117 ,0.1284>, 0.1000
}
cone {
<-7.0776 ,7.0641 ,0.0787>, 0.3000
<-9.9087 ,9.8897 ,0.1100>, 0.1000
}
cone {
<-6.0951 ,7.9275 ,0.0655>, 0.3000
<-8.5332 ,11.0985 ,0.0918>, 0.1000
}
cone {
<-5.0083 ,8.6553 ,0.0525>, 0.3000
<-7.0116 ,12.1174 ,0.0735>, 0.1000
}
cone {
<-3.8358 ,9.2350 ,0.0394>, 0.3000
<-5.3701 ,12.9290 ,0.0551>, 0.1000
}
cone {
<-2.5976 ,9.6567 ,0.0262>, 0.3000
<-3.6367 ,13.5194 ,0.0366>, 0.1000
}
cone {
<-1.3150 ,9.9132 ,0.0129>, 0.3000
<-1.8410 ,13.8784 ,0.0187>, 0.1000
}
cone {
<-0.0099 ,10.0000 ,0.0016>, 0.3000
<-0.0139 ,14.0000 ,0.0022>, 0.1000
}
cone {
<1.2954 ,9.9157 ,-0.0127>, 0.3000
<1.8136 ,13.8820 ,-0.0180>, 0.1000
}
cone {
<2.5785 ,9.6618 ,-0.0261>, 0.3000
<3.6099 ,13.5265 ,-0.0364>, 0.1000
}
cone {
<3.8175 ,9.2426 ,-0.0392>, 0.3000
<5.3445 ,12.9396 ,-0.0548>, 0.1000
}
cone {
<4.9912 ,8.6652 ,-0.0522>, 0.3000
<6.9876 ,12.1313 ,-0.0731>, 0.1000
}
cone {
<6.0794 ,7.9395 ,-0.0653>, 0.3000
<8.5112 ,11.1154 ,-0.0915>, 0.1000
}
cone {
<7.0636 ,7.0781 ,-0.0784>, 0.3000
<9.8891 ,9.9093 ,-0.1098>, 0.1000
}
cone {
<7.9269 ,6.0955 ,-0.0915>, 0.3000
<11.0977 ,8.5337 ,-0.1282>, 0.1000
}
cone {
<8.6546 ,5.0087 ,-0.1046>, 0.3000
<12.1165 ,7.0121 ,-0.1464>, 0.1000
}
cone {
<9.2342 ,3.8361 ,-0.1177>, 0.3000
<12.9279 ,5.3706 ,-0.1648>, 0.1000
}
cone {
<9.6557 ,2.5980 ,-0.1308>, 0.3000
<13.5180 ,3.6372 ,-0.1831>, 0.1000
}
cone {
<9.9120 ,1.3155 ,-0.1439>, 0.3000
<13.8769 ,1.8417 ,-0.2014>, 0.1000
}
cone {
<9.9988 ,0.0105 ,-0.1570>, 0.3000
<13.9983 ,0.0147 ,-0.2198>, 0.1000
}
cone {
<9.9144 ,-1.2946 ,-0.1701>, 0.3000
<13.8801 ,-1.8124 ,-0.2381>, 0.1000
}
cone {
<9.6604 ,-2.5775 ,-0.1831>, 0.3000
<13.5245 ,-3.6085 ,-0.2564>, 0.1000
}
cone {
<9.2411 ,-3.8162 ,-0.1962>, 0.3000
<12.9375 ,-5.3427 ,-0.2747>, 0.1000
}
cone {
<8.6637 ,-4.9896 ,-0.2093>, 0.3000
<12.1292 ,-6.9854 ,-0.2930>, 0.1000
}
cone {
<7.9381 ,-6.0775 ,-0.2224>, 0.3000
<11.1134 ,-8.5086 ,-0.3114>, 0.1000
}
cone {
<7.0768 ,-7.0614 ,-0.2355>, 0.3000
<9.9075 ,-9.8860 ,-0.3297>, 0.1000
}
cone {
<6.0944 ,-7.9244 ,-0.2486>, 0.3000
<8.5321 ,-11.0942 ,-0.3480>, 0.1000
}
cone {
<5.0078 ,-8.6518 ,-0.2617>, 0.3000
<7.0109 ,-12.1125 ,-0.3663>, 0.1000
}
cone {
<3.8356 ,-9.2311 ,-0.2747>, 0.3000
<5.3698 ,-12.9235 ,-0.3847>, 0.1000
}
cone {
<2.5978 ,-9.6524 ,-0.2878>, 0.3000
<3.6369 ,-13.5133 ,-0.4029>, 0.1000
}
cone {
<1.3157 ,-9.9085 ,-0.3009>, 0.3000
<1.8420 ,-13.8719 ,-0.4213>, 0.1000
}
cone {
<0.0112 ,-9.9951 ,-0.3140>, 0.3000
<0.0156 ,-13.9931 ,-0.4396>, 0.1000
}
cone {
<-1.2934 ,-9.9106 ,-0.3271>, 0.3000
<-1.8108 ,-13.8748 ,-0.4579>, 0.1000
}
cone {
<-2.5758 ,-9.6566 ,-0.3402>, 0.3000
<-3.6061 ,-13.5192 ,-0.4762>, 0.1000
}
cone {
<-3.8140 ,-9.2374 ,-0.3533>, 0.3000
<-5.3396 ,-12.9323 ,-0.4946>, 0.1000
}
cone {
<-4.9868 ,-8.6601 ,-0.3663>, 0.3000
<-6.9815 ,-12.1242 ,-0.5129>, 0.1000
}
cone {
<-6.0742 ,-7.9348 ,-0.3794>, 0.3000
<-8.5038 ,-11.1087 ,-0.5312>, 0.1000
}
cone {
<-7.0575 ,-7.0737 ,-0.3925>, 0.3000
<-9.8805 ,-9.9032 ,-0.5495>, 0.1000
}
cone {
<-7.9200 ,-6.0917 ,-0.4056>, 0.3000
<-11.0880 ,-8.5284 ,-0.5678>, 0.1000
}
cone {
<-8.6469 ,-5.0056 ,-0.4186>, 0.3000
<-12.1056 ,-7.0079 ,-0.5861>, 0.1000
}
cone {
<-9.2257 ,-3.8340 ,-0.4317>, 0.3000
<-12.9160 ,-5.3676 ,-0.6044>, 0.1000
}
cone {
<-9.6467 ,-2.5969 ,-0.4448>, 0.3000
<-13.5053 ,-3.6357 ,-0.6227>, 0.1000
}
cone {
<-9.9025 ,-1.3155 ,-0.4579>, 0.3000
<-13.8635 ,-1.8417 ,-0.6410>, 0.1000
}
cone {
<-9.9889 ,-0.0118 ,-0.4709>, 0.3000
<-13.9845 ,-0.0165 ,-0.6593>, 0.1000
}
cone {
<-9.9044 ,1.2920 ,-0.4840>, 0.3000
<-13.8661 ,1.8088 ,-0.6776>, 0.1000
}
cone {
<-9.6504 ,2.5735 ,-0.4971>, 0.3000
<-13.5105 ,3.6029 ,-0.6959>, 0.1000
}
cone {
<-9.2313 ,3.8108 ,-0.5102>, 0.3000
<-12.9239 ,5.3351 ,-0.7142>, 0.1000
}
cone {
<-8.6544 ,4.9828 ,-0.5232>, 0.3000
<-12.1161 ,6.9759 ,-0.7325>, 0.1000
}
cone {
<-7.9294 ,6.0693 ,-0.5363>, 0.3000
<-11.1012 ,8.4970 ,-0.7508>, 0.1000
}
cone {
<-7.0689 ,7.0518 ,-0.5494>, 0.3000
<-9.8965 ,9.8726 ,-0.7691>, 0.1000
}
cone {
<-6.0876 ,7.9136 ,-0.5624>, 0.3000
<-8.5227 ,11.0790 ,-0.7874>, 0.1000
}
cone {
<-5.0023 ,8.6398 ,-0.5755>, 0.3000
<-7.0032 ,12.0957 ,-0.8057>, 0.1000
}
cone {
<-3.8315 ,9.2181 ,-0.5886>, 0.3000
<-5.3641 ,12.9053 ,-0.8240>, 0.1000
}
cone {
<-2.5954 ,9.6386 ,-0.6017>, 0.3000
<-3.6335 ,13.4940 ,-0.8423>, 0.1000
}
cone {
<-1.3150 ,9.8941 ,-0.6147>, 0.3000
<-1.8411 ,13.8517 ,-0.8606>, 0.1000
}
cone {
<-0.0124 ,9.9803 ,-0.6278>, 0.3000
<-0.0174 ,13.9724 ,-0.8789>, 0.1000
}
cone {
<1.2902 ,9.8957 ,-0.6408>, 0.3000
<1.8063 ,13.8540 ,-0.8972>, 0.1000
}
cone {
<2.5706 ,9.6418 ,-0.6539>, 0.3000
<3.5988 ,13.4985 ,-0.9155>, 0.1000
}
cone {
<3.8067 ,9.2230 ,-0.6670>, 0.3000
<5.3294 ,12.9122 ,-0.9337>, 0.1000
}
cone {
<4.9775 ,8.6465 ,-0.6800>, 0.3000
<6.9685 ,12.1051 ,-0.9520>, 0.1000
}
cone {
<6.0629 ,7.9222 ,-0.6931>, 0.3000
<8.4881 ,11.0910 ,-0.9703>, 0.1000
}
cone {
<7.0444 ,7.0624 ,-0.7061>, 0.3000
<9.8622 ,9.8874 ,-0.9886>, 0.1000
}
cone {
<7.9052 ,6.0820 ,-0.7192>, 0.3000
<11.0673 ,8.5148 ,-1.0069>, 0.1000
}
cone {
<8.6306 ,4.9977 ,-0.7322>, 0.3000
<12.0828 ,6.9967 ,-1.0252>, 0.1000
}
cone {
<9.2082 ,3.8281 ,-0.7453>, 0.3000
<12.8914 ,5.3593 ,-1.0434>, 0.1000
}
cone {
<9.6281 ,2.5932 ,-0.7584>, 0.3000
<13.4793 ,3.6305 ,-1.0617>, 0.1000
}
cone {
<9.8832 ,1.3142 ,-0.7714>, 0.3000
<13.8365 ,1.8399 ,-1.0800>, 0.1000
}
cone {
<9.9692 ,0.0130 ,-0.7845>, 0.3000
<13.9568 ,0.0182 ,-1.0982>, 0.1000
}
cone {
<9.8846 ,-1.2881 ,-0.7975>, 0.3000
<13.8384 ,-1.8034 ,-1.1165>, 0.1000
}
cone {
<9.6309 ,-2.5670 ,-0.8106>, 0.3000
<13.4832 ,-3.5938 ,-1.1348>, 0.1000
}
cone {
<9.2124 ,-3.8017 ,-0.8236>, 0.3000
<12.8974 ,-5.3223 ,-1.1530>, 0.1000
}
cone {
<8.6365 ,-4.9710 ,-0.8366>, 0.3000
<12.0911 ,-6.9594 ,-1.1713>, 0.1000
}
cone {
<7.9129 ,-6.0551 ,-0.8497>, 0.3000
<11.0781 ,-8.4771 ,-1.1896>, 0.1000
}
cone {
<7.0541 ,-7.0353 ,-0.8627>, 0.3000
<9.8758 ,-9.8494 ,-1.2078>, 0.1000
}
cone {
<6.0748 ,-7.8949 ,-0.8758>, 0.3000
<8.5048 ,-11.0529 ,-1.2261>, 0.1000
}
cone {
<4.9918 ,-8.6193 ,-0.8888>, 0.3000
<6.9886 ,-12.0670 ,-1.2443>, 0.1000
}
cone {
<3.8237 ,-9.1960 ,-0.9018>, 0.3000
<5.3532 ,-12.8744 ,-1.2626>, 0.1000
}
cone {
<2.5904 ,-9.6152 ,-0.9149>, 0.3000
<3.6266 ,-13.4613 ,-1.2808>, 0.1000
}
cone {
<1.3131 ,-9.8699 ,-0.9279>, 0.3000
<1.8383 ,-13.8178 ,-1.2991>, 0.1000
}
cone {
<0.0136 ,-9.9556 ,-0.9409>, 0.3000
<0.0191 ,-13.9379 ,-1.3173>, 0.1000
}
cone {
<-1.2857 ,-9.8710 ,-0.9540>, 0.3000
<-1.8000 ,-13.8194 ,-1.3356>, 0.1000
}
cone {
<-2.5628 ,-9.6175 ,-0.9670>, 0.3000
<-3.5879 ,-13.4646 ,-1.3538>, 0.1000
}
cone {
<-3.7957 ,-9.1996 ,-0.9800>, 0.3000
<-5.3139 ,-12.8794 ,-1.3720>, 0.1000
}
cone {
<-4.9633 ,-8.6244 ,-0.9931>, 0.3000
<-6.9486 ,-12.0741 ,-1.3903>, 0.1000
}
cone {
<-6.0457 ,-7.9017 ,-1.0061>, 0.3000
<-8.4640 ,-11.0624 ,-1.4085>, 0.1000
}
cone {
<-7.0244 ,-7.0441 ,-1.0191>, 0.3000
<-9.8341 ,-9.8617 ,-1.4267>, 0.1000
}
cone {
<-7.8826 ,-6.0662 ,-1.0321>, 0.3000
<-11.0357 ,-8.4927 ,-1.4450>, 0.1000
}
cone {
<-8.6058 ,-4.9848 ,-1.0451>, 0.3000
<-12.0481 ,-6.9787 ,-1.4632>, 0.1000
}
cone {
<-9.1815 ,-3.8184 ,-1.0582>, 0.3000
<-12.8541 ,-5.3457 ,-1.4814>, 0.1000
}
cone {
<-9.6000 ,-2.5870 ,-1.0712>, 0.3000
<-13.4400 ,-3.6217 ,-1.4997>, 0.1000
}
cone {
<-9.8541 ,-1.3116 ,-1.0842>, 0.3000
<-13.7958 ,-1.8363 ,-1.5179>, 0.1000
}
cone {
<-9.9396 ,-0.0142 ,-1.0972>, 0.3000
<-13.9155 ,-0.0199 ,-1.5361>, 0.1000
}
cone {
<-9.8550 ,1.2830 ,-1.1102>, 0.3000
<-13.7970 ,1.7962 ,-1.5543>, 0.1000
}
cone {
<-9.6018 ,2.5579 ,-1.1232>, 0.3000
<-13.4426 ,3.5811 ,-1.5725>, 0.1000
}
cone {
<-9.1845 ,3.7887 ,-1.1362>, 0.3000
<-12.8583 ,5.3042 ,-1.5907>, 0.1000
}
cone {
<-8.6101 ,4.9544 ,-1.1492>, 0.3000
<-12.0541 ,6.9361 ,-1.6089>, 0.1000
}
cone {
<-7.8886 ,6.0348 ,-1.1622>, 0.3000
<-11.0440 ,8.4488 ,-1.6271>, 0.1000
}
cone {
<-7.0323 ,7.0118 ,-1.1752>, 0.3000
<-9.8453 ,9.8165 ,-1.6453>, 0.1000
}
cone {
<-6.0561 ,7.8684 ,-1.1882>, 0.3000
<-8.4785 ,11.0158 ,-1.6635>, 0.1000
}
cone {
<-4.9765 ,8.5902 ,-1.2012>, 0.3000
<-6.9671 ,12.0263 ,-1.6817>, 0.1000
}
cone {
<-3.8121 ,9.1648 ,-1.2142>, 0.3000
<-5.3369 ,12.8307 ,-1.6999>, 0.1000
}
cone {
<-2.5829 ,9.5824 ,-1.2272>, 0.3000
<-3.6160 ,13.4154 ,-1.7181>, 0.1000
}
cone {
<-1.3099 ,9.8360 ,-1.2402>, 0.3000
<-1.8338 ,13.7703 ,-1.7363>, 0.1000
}
cone {
<-0.0149 ,9.9212 ,-1.2532>, 0.3000
<-0.0208 ,13.8896 ,-1.7545>, 0.1000
}
cone {
<1.2800 ,9.8366 ,-1.2662>, 0.3000
<1.7920 ,13.7712 ,-1.7726>, 0.1000
}
cone {
<2.5525 ,9.5838 ,-1.2792>, 0.3000
<3.5735 ,13.4173 ,-1.7908>, 0.1000
}
cone {
<3.7809 ,9.1671 ,-1.2921>, 0.3000
<5.2932 ,12.8339 ,-1.8090>, 0.1000
}
cone {
<4.9442 ,8.5937 ,-1.3051>, 0.3000
<6.9219 ,12.0312 ,-1.8272>, 0.1000
}
cone {
<6.0225 ,7.8735 ,-1.3181>, 0.3000
<8.4315 ,11.0229 ,-1.8453>, 0.1000
}
cone {
<6.9974 ,7.0189 ,-1.3311>, 0.3000
<9.7964 ,9.8264 ,-1.8635>, 0.1000
}
cone {
<7.8523 ,6.0444 ,-1.3440>, 0.3000
<10.9932 ,8.4622 ,-1.8817>, 0.1000
}
cone {
<8.5725 ,4.9670 ,-1.3570>, 0.3000
<12.0015 ,6.9537 ,-1.8998>, 0.1000
}
cone {
<9.1458 ,3.8049 ,-1.3700>, 0.3000
<12.8041 ,5.3268 ,-1.9180>, 0.1000
}
cone {
<9.5625 ,2.5781 ,-1.3829>, 0.3000
<13.3874 ,3.6094 ,-1.9361>, 0.1000
}
cone {
<9.8154 ,1.3077 ,-1.3959>, 0.3000
<13.7415 ,1.8308 ,-1.9543>, 0.1000
}
cone {
<9.9002 ,0.0154 ,-1.4089>, 0.3000
<13.8603 ,0.0216 ,-1.9724>, 0.1000
}
cone {
<9.8157 ,-1.2766 ,-1.4218>, 0.3000
<13.7420 ,-1.7873 ,-1.9905>, 0.1000
}
cone {
<9.5633 ,-2.5464 ,-1.4348>, 0.3000
<13.3887 ,-3.5649 ,-2.0087>, 0.1000
}
cone {
<9.1474 ,-3.7721 ,-1.4477>, 0.3000
<12.8064 ,-5.2809 ,-2.0268>, 0.1000
}
cone {
<8.5752 ,-4.9328 ,-1.4607>, 0.3000
<12.0053 ,-6.9059 ,-2.0449>, 0.1000
}
cone {
<7.8565 ,-6.0087 ,-1.4736>, 0.3000
<10.9991 ,-8.4122 ,-2.0631>, 0.1000
}
cone {
<7.0036 ,-6.9814 ,-1.4866>, 0.3000
<9.8051 ,-9.7739 ,-2.0812>, 0.1000
}
cone {
<6.0313 ,-7.8342 ,-1.4995>, 0.3000
<8.4438 ,-10.9679 ,-2.0993>, 0.1000
}
cone {
<4.9562 ,-8.5527 ,-1.5124>, 0.3000
<6.9387 ,-11.9738 ,-2.1174>, 0.1000
}
cone {
<3.7967 ,-9.1246 ,-1.5254>, 0.3000
<5.3154 ,-12.7744 ,-2.1355>, 0.1000
}
cone {
<2.5728 ,-9.5401 ,-1.5383>, 0.3000
<3.6019 ,-13.3562 ,-2.1537>, 0.1000
}
cone {
<1.3053 ,-9.7923 ,-1.5513>, 0.3000
<1.8274 ,-13.7093 ,-2.1718>, 0.1000
}
cone {
<0.0160 ,-9.8769 ,-1.5642>, 0.3000
<0.0225 ,-13.8277 ,-2.1899>, 0.1000
}
cone {
<-1.2730 ,-9.7925 ,-1.5771>, 0.3000
<-1.7822 ,-13.7094 ,-2.2080>, 0.1000
}
cone {
<-2.5397 ,-9.5405 ,-1.5900>, 0.3000
<-3.5555 ,-13.3568 ,-2.2261>, 0.1000
}
cone {
<-3.7624 ,-9.1255 ,-1.6030>, 0.3000
<-5.2673 ,-12.7757 ,-2.2441>, 0.1000
}
cone {
<-4.9202 ,-8.5545 ,-1.6159>, 0.3000
<-6.8883 ,-11.9764 ,-2.2622>, 0.1000
}
cone {
<-5.9934 ,-7.8375 ,-1.6288>, 0.3000
<-8.3908 ,-10.9725 ,-2.2803>, 0.1000
}
cone {
<-6.9636 ,-6.9867 ,-1.6417>, 0.3000
<-9.7490 ,-9.7813 ,-2.2984>, 0.1000
}
cone {
<-7.8142 ,-6.0167 ,-1.6546>, 0.3000
<-10.9399 ,-8.4234 ,-2.3165>, 0.1000
}
cone {
<-8.5308 ,-4.9442 ,-1.6675>, 0.3000
<-11.9431 ,-6.9219 ,-2.3345>, 0.1000
}
cone {
<-9.1011 ,-3.7876 ,-1.6804>, 0.3000
<-12.7415 ,-5.3027 ,-2.3526>, 0.1000
}
cone {
<-9.5155 ,-2.5668 ,-1.6933>, 0.3000
<-13.3217 ,-3.5935 ,-2.3707>, 0.1000
}
cone {
<-9.7669 ,-1.3026 ,-1.7062>, 0.3000
<-13.6736 ,-1.8236 ,-2.3887>, 0.1000
}
cone {
<-9.8511 ,-0.0166 ,-1.7191>, 0.3000
<-13.7916 ,-0.0233 ,-2.4068>, 0.1000
}
cone {
<-9.7668 ,1.2690 ,-1.7320>, 0.3000
<-13.6735 ,1.7766 ,-2.4248>, 0.1000
}
cone {
<-9.5154 ,2.5323 ,-1.7449>, 0.3000
<-13.3215 ,3.5453 ,-2.4429>, 0.1000
}
cone {
<-9.1013 ,3.7518 ,-1.7578>, 0.3000
<-12.7419 ,5.2525 ,-2.4609>, 0.1000
}
cone {
<-8.5318 ,4.9064 ,-1.7707>, 0.3000
<-11.9445 ,6.8690 ,-2.4790>, 0.1000
}
cone {
<-7.8166 ,5.9766 ,-1.7836>, 0.3000
<-10.9432 ,8.3673 ,-2.4970>, 0.1000
}
cone {
<-6.9680 ,6.9441 ,-1.7964>, 0.3000
<-9.7552 ,9.7217 ,-2.5150>, 0.1000
}
cone {
<-6.0006 ,7.7923 ,-1.8093>, 0.3000
<-8.4008 ,10.9092 ,-2.5330>, 0.1000
}
cone {
<-4.9310 ,8.5067 ,-1.8222>, 0.3000
<-6.9034 ,11.9094 ,-2.5511>, 0.1000
}
cone {
<-3.7776 ,9.0754 ,-1.8351>, 0.3000
<-5.2886 ,12.7055 ,-2.5691>, 0.1000
}
cone {
<-2.5601 ,9.4885 ,-1.8479>, 0.3000
<-3.5842 ,13.2838 ,-2.5871>, 0.1000
}
cone {
<-1.2995 ,9.7390 ,-1.8608>, 0.3000
<-1.8193 ,13.6347 ,-2.6051>, 0.1000
}
cone {
<-0.0172 ,9.8229 ,-1.8736>, 0.3000
<-0.0241 ,13.7520 ,-2.6231>, 0.1000
}
cone {
<1.2647 ,9.7387 ,-1.8865>, 0.3000
<1.7706 ,13.6341 ,-2.6411>, 0.1000
}
cone {
<2.5244 ,9.4879 ,-1.8993>, 0.3000
<3.5341 ,13.2830 ,-2.6591>, 0.1000
}
cone {
<3.7402 ,9.0749 ,-1.9122>, 0.3000
<5.2363 ,12.7049 ,-2.6771>, 0.1000
}
cone {
<4.8914 ,8.5070 ,-1.9250>, 0.3000
<6.8480 ,11.9097 ,-2.6951>, 0.1000
}
cone {
<5.9584 ,7.7937 ,-1.9379>, 0.3000
<8.3417 ,10.9112 ,-2.7130>, 0.1000
}
cone {
<6.9229 ,6.9476 ,-1.9507>, 0.3000
<9.6920 ,9.7266 ,-2.7310>, 0.1000
}
cone {
<7.7684 ,5.9830 ,-1.9636>, 0.3000
<10.8758 ,8.3762 ,-2.7490>, 0.1000
}
cone {
<8.4806 ,4.9166 ,-1.9764>, 0.3000
<11.8729 ,6.8832 ,-2.7670>, 0.1000
}
cone {
<9.0474 ,3.7666 ,-1.9892>, 0.3000
<12.6664 ,5.2733 ,-2.7849>, 0.1000
}
cone {
<9.4591 ,2.5529 ,-2.0021>, 0.3000
<13.2428 ,3.5740 ,-2.8029>, 0.1000
}
cone {
<9.7088 ,1.2961 ,-2.0149>, 0.3000
<13.5923 ,1.8145 ,-2.8208>, 0.1000
}
cone {
<9.7922 ,0.0178 ,-2.0277>, 0.3000
<13.7091 ,0.0249 ,-2.8388>, 0.1000
}
cone {
<9.7082 ,-1.2601 ,-2.0405>, 0.3000
<13.5914 ,-1.7642 ,-2.8567>, 0.1000
}
cone {
<9.4580 ,-2.5158 ,-2.0533>, 0.3000
<13.2413 ,-3.5221 ,-2.8747>, 0.1000
}
cone {
<9.0463 ,-3.7277 ,-2.0661>, 0.3000
<12.6648 ,-5.2188 ,-2.8926>, 0.1000
}
cone {
<8.4800 ,-4.8752 ,-2.0789>, 0.3000
<11.8720 ,-6.8253 ,-2.9105>, 0.1000
}
cone {
<7.7690 ,-5.9387 ,-2.0917>, 0.3000
<10.8766 ,-8.3141 ,-2.9284>, 0.1000
}
cone {
<6.9255 ,-6.8999 ,-2.1045>, 0.3000
<9.6956 ,-9.6599 ,-2.9464>, 0.1000
}
cone {
<5.9639 ,-7.7426 ,-2.1173>, 0.3000
<8.3495 ,-10.8397 ,-2.9643>, 0.1000
}
cone {
<4.9009 ,-8.4524 ,-2.1301>, 0.3000
<6.8613 ,-11.8334 ,-2.9822>, 0.1000
}
cone {
<3.7547 ,-9.0172 ,-2.1429>, 0.3000
<5.2566 ,-12.6241 ,-3.0001>, 0.1000
}
cone {
<2.5449 ,-9.4274 ,-2.1557>, 0.3000
<3.5629 ,-13.1984 ,-3.0180>, 0.1000
}
cone {
<1.2923 ,-9.6761 ,-2.1685>, 0.3000
<1.8093 ,-13.5466 ,-3.0359>, 0.1000
}
cone {
<0.0183 ,-9.7592 ,-2.1812>, 0.3000
<0.0257 ,-13.6629 ,-3.0538>, 0.1000
}
cone {
<-1.2552 ,-9.6753 ,-2.1940>, 0.3000
<-1.7573 ,-13.5454 ,-3.0716>, 0.1000
}
cone {
<-2.5066 ,-9.4259 ,-2.2068>, 0.3000
<-3.5092 ,-13.1962 ,-3.0895>, 0.1000
}
cone {
<-3.7143 ,-9.0154 ,-2.2196>, 0.3000
<-5.2000 ,-12.6216 ,-3.1074>, 0.1000
}
cone {
<-4.8578 ,-8.4510 ,-2.2323>, 0.3000
<-6.8009 ,-11.8313 ,-3.1252>, 0.1000
}
cone {
<-5.9175 ,-7.7423 ,-2.2451>, 0.3000
<-8.2845 ,-10.8392 ,-3.1431>, 0.1000
}
cone {
<-6.8753 ,-6.9016 ,-2.2578>, 0.3000
<-9.6254 ,-9.6623 ,-3.1610>, 0.1000
}
cone {
<-7.7150 ,-5.9434 ,-2.2706>, 0.3000
<-10.8009 ,-8.3208 ,-3.1788>, 0.1000
}
cone {
<-8.4221 ,-4.8841 ,-2.2833>, 0.3000
<-11.7910 ,-6.8377 ,-3.1966>, 0.1000
}
cone {
<-8.9848 ,-3.7419 ,-2.2961>, 0.3000
<-12.5787 ,-5.2387 ,-3.2145>, 0.1000
}
cone {
<-9.3934 ,-2.5364 ,-2.3088>, 0.3000
<-13.1508 ,-3.5510 ,-3.2323>, 0.1000
}
cone {
<-9.6411 ,-1.2883 ,-2.3215>, 0.3000
<-13.4975 ,-1.8036 ,-3.2502>, 0.1000
}
cone {
<-9.7237 ,-0.0189 ,-2.3343>, 0.3000
<-13.6132 ,-0.0264 ,-3.2680>, 0.1000
}
cone {
<-9.6400 ,1.2500 ,-2.3470>, 0.3000
<-13.4960 ,1.7501 ,-3.2858>, 0.1000
}
cone {
<-9.3914 ,2.4968 ,-2.3597>, 0.3000
<-13.1479 ,3.4955 ,-3.3036>, 0.1000
}
cone {
<-8.9823 ,3.7000 ,-2.3724>, 0.3000
<-12.5752 ,5.1800 ,-3.3214>, 0.1000
}
cone {
<-8.4198 ,4.8392 ,-2.3851>, 0.3000
<-11.7877 ,6.7749 ,-3.3392>, 0.1000
}
cone {
<-7.7137 ,5.8948 ,-2.3979>, 0.3000
<-10.7992 ,8.2528 ,-3.3570>, 0.1000
}
cone {
<-6.8761 ,6.8490 ,-2.4106>, 0.3000
<-9.6265 ,9.5886 ,-3.3748>, 0.1000
}
cone {
<-5.9214 ,7.6854 ,-2.4233>, 0.3000
<-8.2899 ,10.7595 ,-3.3926>, 0.1000
}
cone {
<-4.8660 ,8.3897 ,-2.4360>, 0.3000
<-6.8124 ,11.7456 ,-3.4103>, 0.1000
}
cone {
<-3.7281 ,8.9501 ,-2.4486>, 0.3000
<-5.2194 ,12.5302 ,-3.4281>, 0.1000
}
cone {
<-2.5272 ,9.3571 ,-2.4613>, 0.3000
<-3.5381 ,13.0999 ,-3.4459>, 0.1000
}
cone {
<-1.2839 ,9.6037 ,-2.4740>, 0.3000
<-1.7974 ,13.4452 ,-3.4636>, 0.1000
}
cone {
<-0.0194 ,9.6859 ,-2.4867>, 0.3000
<-0.0272 ,13.5602 ,-3.4814>, 0.1000
}
cone {
<1.2445 ,9.6023 ,-2.4994>, 0.3000
<1.7424 ,13.4432 ,-3.4991>, 0.1000
}
cone {
<2.4864 ,9.3546 ,-2.5121>, 0.3000
<3.4809 ,13.0964 ,-3.5169>, 0.1000
}
cone {
<3.6848 ,8.9470 ,-2.5247>, 0.3000
<5.1587 ,12.5257 ,-3.5346>, 0.1000
}
cone {
<4.8194 ,8.3866 ,-2.5374>, 0.3000
<6.7471 ,11.7413 ,-3.5523>, 0.1000
}
cone {
<5.8708 ,7.6832 ,-2.5500>, 0.3000
<8.2191 ,10.7565 ,-3.5701>, 0.1000
}
cone {
<6.8210 ,6.8488 ,-2.5627>, 0.3000
<9.5494 ,9.5884 ,-3.5878>, 0.1000
}
cone {
<7.6539 ,5.8979 ,-2.5753>, 0.3000
<10.7155 ,8.2571 ,-3.6055>, 0.1000
}
cone {
<8.3553 ,4.8468 ,-2.5880>, 0.3000
<11.6974 ,6.7855 ,-3.6232>, 0.1000
}
cone {
<8.9133 ,3.7135 ,-2.6006>, 0.3000
<12.4786 ,5.1988 ,-3.6409>, 0.1000
}
cone {
<9.3184 ,2.5174 ,-2.6133>, 0.3000
<13.0458 ,3.5244 ,-3.6586>, 0.1000
}
cone {
<9.5639 ,1.2792 ,-2.6259>, 0.3000
<13.3895 ,1.7909 ,-3.6763>, 0.1000
}
cone {
<9.6456 ,0.0199 ,-2.6385>, 0.3000
<13.5039 ,0.0279 ,-3.6939>, 0.1000
}
cone {
<9.5623 ,-1.2387 ,-2.6512>, 0.3000
<13.3872 ,-1.7342 ,-3.7116>, 0.1000
}
cone {
<9.3154 ,-2.4753 ,-2.6638>, 0.3000
<13.0416 ,-3.4654 ,-3.7293>, 0.1000
}
cone {
<8.9094 ,-3.6687 ,-2.6764>, 0.3000
<12.4732 ,-5.1361 ,-3.7469>, 0.1000
}
cone {
<8.3513 ,-4.7984 ,-2.6890>, 0.3000
<11.6919 ,-6.7178 ,-3.7646>, 0.1000
}
cone {
<7.6508 ,-5.8452 ,-2.7016>, 0.3000
<10.7111 ,-8.1833 ,-3.7822>, 0.1000
}
cone {
<6.8199 ,-6.7913 ,-2.7142>, 0.3000
<9.5479 ,-9.5079 ,-3.7999>, 0.1000
}
cone {
<5.8730 ,-7.6205 ,-2.7268>, 0.3000
<8.2222 ,-10.6688 ,-3.8175>, 0.1000
}
cone {
<4.8263 ,-8.3188 ,-2.7394>, 0.3000
<6.7568 ,-11.6463 ,-3.8351>, 0.1000
}
cone {
<3.6979 ,-8.8743 ,-2.7520>, 0.3000
<5.1770 ,-12.4240 ,-3.8528>, 0.1000
}
cone {
<2.5070 ,-9.2775 ,-2.7646>, 0.3000
<3.5098 ,-12.9885 ,-3.8704>, 0.1000
}
cone {
<1.2742 ,-9.5218 ,-2.7771>, 0.3000
<1.7838 ,-13.3305 ,-3.8880>, 0.1000
}
cone {
<0.0205 ,-9.6030 ,-2.7897>, 0.3000
<0.0287 ,-13.4442 ,-3.9056>, 0.1000
}
cone {
<-1.2326 ,-9.5199 ,-2.8023>, 0.3000
<-1.7257 ,-13.3278 ,-3.9232>, 0.1000
}
cone {
<-2.4637 ,-9.2740 ,-2.8148>, 0.3000
<-3.4492 ,-12.9836 ,-3.9408>, 0.1000
}
cone {
<-3.6517 ,-8.8697 ,-2.8274>, 0.3000
<-5.1123 ,-12.4176 ,-3.9584>, 0.1000
}
cone {
<-4.7762 ,-8.3140 ,-2.8399>, 0.3000
<-6.6867 ,-11.6396 ,-3.9759>, 0.1000
}
cone {
<-5.8183 ,-7.6165 ,-2.8525>, 0.3000
<-8.1456 ,-10.6631 ,-3.9935>, 0.1000
}
cone {
<-6.7600 ,-6.7893 ,-2.8650>, 0.3000
<-9.4640 ,-9.5050 ,-4.0111>, 0.1000
}
cone {
<-7.5853 ,-5.8466 ,-2.8776>, 0.3000
<-10.6194 ,-8.1852 ,-4.0286>, 0.1000
}
cone {
<-8.2803 ,-4.8046 ,-2.8901>, 0.3000
<-11.5924 ,-6.7265 ,-4.0462>, 0.1000
}
cone {
<-8.8330 ,-3.6813 ,-2.9026>, 0.3000
<-12.3662 ,-5.1539 ,-4.0637>, 0.1000
}
cone {
<-9.2343 ,-2.4959 ,-2.9152>, 0.3000
<-12.9280 ,-3.4943 ,-4.0812>, 0.1000
}
cone {
<-9.4773 ,-1.2688 ,-2.9277>, 0.3000
<-13.2682 ,-1.7764 ,-4.0988>, 0.1000
}
cone {
<-9.5580 ,-0.0210 ,-2.9402>, 0.3000
<-13.3812 ,-0.0294 ,-4.1163>, 0.1000
}
cone {
<-9.4751 ,1.2262 ,-2.9527>, 0.3000
<-13.2652 ,1.7167 ,-4.1338>, 0.1000
}
cone {
<-9.2303 ,2.4514 ,-2.9652>, 0.3000
<-12.9224 ,3.4320 ,-4.1513>, 0.1000
}
cone {
<-8.8278 ,3.6337 ,-2.9777>, 0.3000
<-12.3589 ,5.0872 ,-4.1688>, 0.1000
}
cone {
<-8.2746 ,4.7529 ,-2.9902>, 0.3000
<-11.5844 ,6.6541 ,-4.1863>, 0.1000
}
cone {
<-7.5803 ,5.7899 ,-3.0027>, 0.3000
<-10.6124 ,8.1058 ,-4.2038>, 0.1000
}
cone {
<-6.7570 ,6.7270 ,-3.0152>, 0.3000
<-9.4598 ,9.4177 ,-4.2212>, 0.1000
}
cone {
<-5.8188 ,7.5482 ,-3.0276>, 0.3000
<-8.1463 ,10.5675 ,-4.2387>, 0.1000
}
cone {
<-4.7818 ,8.2397 ,-3.0401>, 0.3000
<-6.6945 ,11.5355 ,-4.2562>, 0.1000
}
cone {
<-3.6639 ,8.7896 ,-3.0526>, 0.3000
<-5.1295 ,12.3055 ,-4.2736>, 0.1000
}
cone {
<-2.4843 ,9.1888 ,-3.0650>, 0.3000
<-3.4780 ,12.8643 ,-4.2911>, 0.1000
}
cone {
<-1.2632 ,9.4305 ,-3.0775>, 0.3000
<-1.7684 ,13.2026 ,-4.3085>, 0.1000
}
cone {
<-0.0215 ,9.5106 ,-3.0900>, 0.3000
<-0.0301 ,13.3149 ,-4.3259>, 0.1000
}
cone {
<1.2195 ,9.4280 ,-3.1024>, 0.3000
<1.7073 ,13.1993 ,-4.3434>, 0.1000
}
cone {
<2.4386 ,9.1843 ,-3.1148>, 0.3000
<3.4140 ,12.8580 ,-4.3608>, 0.1000
}
cone {
<3.6149 ,8.7836 ,-3.1273>, 0.3000
<5.0609 ,12.2971 ,-4.3782>, 0.1000
}
cone {
<4.7284 ,8.2331 ,-3.1397>, 0.3000
<6.6198 ,11.5264 ,-4.3956>, 0.1000
}
cone {
<5.7601 ,7.5423 ,-3.1521>, 0.3000
<8.0641 ,10.5592 ,-4.4130>, 0.1000
}
cone {
<6.6923 ,6.7230 ,-3.1646>, 0.3000
<9.3692 ,9.4122 ,-4.4304>, 0.1000
}
cone {
<7.5092 ,5.7895 ,-3.1770>, 0.3000
<10.5129 ,8.1053 ,-4.4478>, 0.1000
}
cone {
<8.1971 ,4.7577 ,-3.1894>, 0.3000
<11.4759 ,6.6608 ,-4.4651>, 0.1000
}
cone {
<8.7441 ,3.6456 ,-3.2018>, 0.3000
<12.2417 ,5.1038 ,-4.4825>, 0.1000
}
cone {
<9.1410 ,2.4720 ,-3.2142>, 0.3000
<12.7974 ,3.4608 ,-4.4998>, 0.1000
}
cone {
<9.3813 ,1.2572 ,-3.2266>, 0.3000
<13.1338 ,1.7601 ,-4.5172>, 0.1000
}
cone {
<9.4609 ,0.0220 ,-3.2390>, 0.3000
<13.2453 ,0.0307 ,-4.5345>, 0.1000
}
cone {
<9.3786 ,-1.2125 ,-3.2513>, 0.3000
<13.1301 ,-1.6975 ,-4.5519>, 0.1000
}
cone {
<9.1360 ,-2.4252 ,-3.2637>, 0.3000
<12.7904 ,-3.3952 ,-4.5692>, 0.1000
}
cone {
<8.7374 ,-3.5952 ,-3.2761>, 0.3000
<12.2323 ,-5.0333 ,-4.5865>, 0.1000
}
cone {
<8.1896 ,-4.7027 ,-3.2884>, 0.3000
<11.4655 ,-6.5838 ,-4.6038>, 0.1000
}
cone {
<7.5024 ,-5.7288 ,-3.3008>, 0.3000
<10.5033 ,-8.0204 ,-4.6211>, 0.1000
}
cone {
<6.6874 ,-6.6560 ,-3.3132>, 0.3000
<9.3623 ,-9.3184 ,-4.6384>, 0.1000
}
cone {
<5.7588 ,-7.4684 ,-3.3255>, 0.3000
<8.0623 ,-10.4558 ,-4.6557>, 0.1000
}
cone {
<4.7325 ,-8.1524 ,-3.3378>, 0.3000
<6.6255 ,-11.4134 ,-4.6730>, 0.1000
}
cone {
<3.6263 ,-8.6963 ,-3.3502>, 0.3000
<5.0768 ,-12.1749 ,-4.6903>, 0.1000
}
cone {
<2.4591 ,-9.0910 ,-3.3625>, 0.3000
<3.4427 ,-12.7274 ,-4.7075>, 0.1000
}
cone {
<1.2509 ,-9.3298 ,-3.3748>, 0.3000
<1.7512 ,-13.0618 ,-4.7248>, 0.1000
}
cone {
<0.0224 ,-9.4089 ,-3.3872>, 0.3000
<0.0314 ,-13.1724 ,-4.7420>, 0.1000
}
cone {
<-1.2052 ,-9.3269 ,-3.3995>, 0.3000
<-1.6873 ,-13.0577 ,-4.7593>, 0.1000
}
cone {
<-2.4111 ,-9.0855 ,-3.4118>, 0.3000
<-3.3756 ,-12.7197 ,-4.7765>, 0.1000
}
cone {
<-3.5747 ,-8.6889 ,-3.4241>, 0.3000
<-5.0045 ,-12.1645 ,-4.7937>, 0.1000
}
cone {
<-4.6759 ,-8.1441 ,-3.4364>, 0.3000
<-6.5463 ,-11.4018 ,-4.8109>, 0.1000
}
cone {
<-5.6962 ,-7.4606 ,-3.4487>, 0.3000
<-7.9746 ,-10.4448 ,-4.8281>, 0.1000
}
cone {
<-6.6180 ,-6.6501 ,-3.4609>, 0.3000
<-9.2652 ,-9.3101 ,-4.8453>, 0.1000
}
cone {
<-7.4258 ,-5.7266 ,-3.4732>, 0.3000
<-10.3961 ,-8.0173 ,-4.8625>, 0.1000
}
cone {
<-8.1058 ,-4.7061 ,-3.4855>, 0.3000
<-11.3481 ,-6.5886 ,-4.8797>, 0.1000
}
cone {
<-8.6465 ,-3.6061 ,-3.4978>, 0.3000
<-12.1051 ,-5.0486 ,-4.8969>, 0.1000
}
cone {
<-9.0388 ,-2.4456 ,-3.5100>, 0.3000
<-12.6543 ,-3.4238 ,-4.9140>, 0.1000
}
cone {
<-9.2761 ,-1.2443 ,-3.5223>, 0.3000
<-12.9865 ,-1.7420 ,-4.9312>, 0.1000
}
cone {
<-9.3545 ,-0.0229 ,-3.5345>, 0.3000
<-13.0963 ,-0.0321 ,-4.9483>, 0.1000
}
cone {
<-9.2729 ,1.1977 ,-3.5468>, 0.3000
<-12.9820 ,1.6767 ,-4.9655>, 0.1000
}
cone {
<-9.0327 ,2.3965 ,-3.5590>, 0.3000
<-12.6458 ,3.3551 ,-4.9826>, 0.1000
}
cone {
<-8.6383 ,3.5532 ,-3.5712>, 0.3000
<-12.0937 ,4.9745 ,-4.9997>, 0.1000
}
cone {
<-8.0966 ,4.6480 ,-3.5834>, 0.3000
<-11.3353 ,6.5072 ,-5.0168>, 0.1000
}
cone {
<-7.4170 ,5.6621 ,-3.5957>, 0.3000
<-10.3838 ,7.9270 ,-5.0339>, 0.1000
}
cone {
<-6.6112 ,6.5784 ,-3.6079>, 0.3000
<-9.2556 ,9.2098 ,-5.0510>, 0.1000
}
cone {
<-5.6931 ,7.3813 ,-3.6201>, 0.3000
<-7.9703 ,10.3338 ,-5.0681>, 0.1000
}
cone {
<-4.6786 ,8.0571 ,-3.6323>, 0.3000
<-6.5500 ,11.2800 ,-5.0852>, 0.1000
}
cone {
<-3.5851 ,8.5945 ,-3.6445>, 0.3000
<-5.0191 ,12.0323 ,-5.1023>, 0.1000
}
cone {
<-2.4314 ,8.9843 ,-3.6567>, 0.3000
<-3.4040 ,12.5780 ,-5.1193>, 0.1000
}
cone {
<-1.2374 ,9.2200 ,-3.6688>, 0.3000
<-1.7323 ,12.9080 ,-5.1364>, 0.1000
}
cone {
<-0.0234 ,9.2978 ,-3.6810>, 0.3000
<-0.0327 ,13.0170 ,-5.1534>, 0.1000
}
cone {
<1.1898 ,9.2166 ,-3.6932>, 0.3000
<1.6657 ,12.9032 ,-5.1705>, 0.1000
}
cone {
<2.3813 ,8.9777 ,-3.7053>, 0.3000
<3.3339 ,12.5688 ,-5.1875>, 0.1000
}
cone {
<3.5309 ,8.5856 ,-3.7175>, 0.3000
<4.9432 ,12.0199 ,-5.2045>, 0.1000
}
cone {
<4.6189 ,8.0471 ,-3.7296>, 0.3000
<6.4664 ,11.2659 ,-5.2215>, 0.1000
}
cone {
<5.6267 ,7.3715 ,-3.7418>, 0.3000
<7.8774 ,10.3201 ,-5.2385>, 0.1000
}
cone {
<6.5372 ,6.5706 ,-3.7539>, 0.3000
<9.1521 ,9.1988 ,-5.2555>, 0.1000
}
cone {
<7.3350 ,5.6581 ,-3.7660>, 0.3000
<10.2690 ,7.9214 ,-5.2725>, 0.1000
}
cone {
<8.0065 ,4.6499 ,-3.7782>, 0.3000
<11.2091 ,6.5098 ,-5.2894>, 0.1000
}
cone {
<8.5403 ,3.5632 ,-3.7903>, 0.3000
<11.9565 ,4.9884 ,-5.3064>, 0.1000
}
cone {
<8.9276 ,2.4167 ,-3.8024>, 0.3000
<12.4986 ,3.3834 ,-5.3234>, 0.1000
}
cone {
<9.1617 ,1.2301 ,-3.8145>, 0.3000
<12.8264 ,1.7222 ,-5.3403>, 0.1000
}
cone {
<9.2389 ,0.0238 ,-3.8266>, 0.3000
<12.9344 ,0.0333 ,-5.3572>, 0.1000
}
cone {
<9.1580 ,-1.1816 ,-3.8387>, 0.3000
<12.8211 ,-1.6543 ,-5.3742>, 0.1000
}
cone {
<8.9205 ,-2.3655 ,-3.8508>, 0.3000
<12.4887 ,-3.3118 ,-5.3911>, 0.1000
}
cone {
<8.5308 ,-3.5077 ,-3.8628>, 0.3000
<11.9431 ,-4.9108 ,-5.4080>, 0.1000
}
cone {
<7.9956 ,-4.5886 ,-3.8749>, 0.3000
<11.1938 ,-6.4241 ,-5.4249>, 0.1000
}
cone {
<7.3242 ,-5.5899 ,-3.8870>, 0.3000
<10.2539 ,-7.8258 ,-5.4418>, 0.1000
}
cone {
<6.5284 ,-6.4944 ,-3.8990>, 0.3000
<9.1397 ,-9.0922 ,-5.4587>, 0.1000
}
cone {
<5.6218 ,-7.2869 ,-3.9111>, 0.3000
<7.8705 ,-10.2017 ,-5.4755>, 0.1000
}
cone {
<4.6200 ,-7.9539 ,-3.9231>, 0.3000
<6.4680 ,-11.1355 ,-5.4924>, 0.1000
}
cone {
<3.5403 ,-8.4841 ,-3.9352>, 0.3000
<4.9565 ,-11.8778 ,-5.5092>, 0.1000
}
cone {
<2.4013 ,-8.8687 ,-3.9472>, 0.3000
<3.3619 ,-12.4161 ,-5.5261>, 0.1000
}
cone {
<1.2226 ,-9.1011 ,-3.9592>, 0.3000
<1.7116 ,-12.7415 ,-5.5429>, 0.1000
}
cone {
<0.0242 ,-9.1776 ,-3.9712>, 0.3000
<0.0339 ,-12.8487 ,-5.5597>, 0.1000
}
cone {
<-1.1732 ,-9.0971 ,-3.9832>, 0.3000
<-1.6425 ,-12.7359 ,-5.5765>, 0.1000
}
cone {
<-2.3492 ,-8.8611 ,-3.9952>, 0.3000
<-3.2889 ,-12.4056 ,-5.5933>, 0.1000
}
cone {
<-3.4837 ,-8.4738 ,-4.0072>, 0.3000
<-4.8771 ,-11.8634 ,-5.6101>, 0.1000
}
cone {
<-4.5573 ,-7.9421 ,-4.0192>, 0.3000
<-6.3802 ,-11.1190 ,-5.6269>, 0.1000
}
cone {
<-5.5517 ,-7.2752 ,-4.0312>, 0.3000
<-7.7724 ,-10.1852 ,-5.6437>, 0.1000
}
cone {
<-6.4500 ,-6.4846 ,-4.0432>, 0.3000
<-9.0300 ,-9.0784 ,-5.6605>, 0.1000
}
cone {
<-7.2370 ,-5.5840 ,-4.0552>, 0.3000
<-10.1318 ,-7.8176 ,-5.6772>, 0.1000
}
cone {
<-7.8994 ,-4.5890 ,-4.0671>, 0.3000
<-11.0591 ,-6.4246 ,-5.6940>, 0.1000
}
cone {
<-8.4258 ,-3.5166 ,-4.0791>, 0.3000
<-11.7961 ,-4.9233 ,-5.7107>, 0.1000
}
cone {
<-8.8076 ,-2.3854 ,-4.0910>, 0.3000
<-12.3306 ,-3.3396 ,-5.7274>, 0.1000
}
cone {
<-9.0383 ,-1.2147 ,-4.1030>, 0.3000
<-12.6536 ,-1.7006 ,-5.7442>, 0.1000
}
cone {
<-9.1141 ,-0.0246 ,-4.1149>, 0.3000
<-12.7598 ,-0.0345 ,-5.7609>, 0.1000
}
cone {
<-9.0340 ,1.1645 ,-4.1268>, 0.3000
<-12.6476 ,1.6303 ,-5.7776>, 0.1000
}
cone {
<-8.7995 ,2.3323 ,-4.1387>, 0.3000
<-12.3193 ,3.2652 ,-5.7942>, 0.1000
}
cone {
<-8.4148 ,3.4588 ,-4.1507>, 0.3000
<-11.7807 ,4.8423 ,-5.8109>, 0.1000
}
cone {
<-7.8867 ,4.5248 ,-4.1626>, 0.3000
<-11.0413 ,6.3347 ,-5.8276>, 0.1000
}
cone {
<-7.2243 ,5.5121 ,-4.1745>, 0.3000
<-10.1140 ,7.7170 ,-5.8442>, 0.1000
}
cone {
<-6.4392 ,6.4040 ,-4.1863>, 0.3000
<-9.0148 ,8.9657 ,-5.8609>, 0.1000
}
cone {
<-5.5449 ,7.1854 ,-4.1982>, 0.3000
<-7.7628 ,10.0595 ,-5.8775>, 0.1000
}
cone {
<-4.5568 ,7.8429 ,-4.2101>, 0.3000
<-6.3795 ,10.9800 ,-5.8942>, 0.1000
}
cone {
<-3.4921 ,8.3654 ,-4.2220>, 0.3000
<-4.8889 ,11.7116 ,-5.9108>, 0.1000
}
cone {
<-2.3689 ,8.7443 ,-4.2338>, 0.3000
<-3.3164 ,12.2420 ,-5.9274>, 0.1000
}
cone {
<-1.2066 ,8.9732 ,-4.2457>, 0.3000
<-1.6892 ,12.5625 ,-5.9440>, 0.1000
}
cone {
<-0.0250 ,9.0484 ,-4.2575>, 0.3000
<-0.0350 ,12.6677 ,-5.9606>, 0.1000
}
cone {
<1.1555 ,8.9687 ,-4.2694>, 0.3000
<1.6177 ,12.5562 ,-5.9771>, 0.1000
}
cone {
<2.3148 ,8.7357 ,-4.2812>, 0.3000
<3.2407 ,12.2300 ,-5.9937>, 0.1000
}
cone {
<3.4330 ,8.3537 ,-4.2930>, 0.3000
<4.8062 ,11.6952 ,-6.0103>, 0.1000
}
cone {
<4.4912 ,7.8293 ,-4.3049>, 0.3000
<6.2877 ,10.9610 ,-6.0268>, 0.1000
}
cone {
<5.4712 ,7.1716 ,-4.3167>, 0.3000
<7.6597 ,10.0403 ,-6.0433>, 0.1000
}
cone {
<6.3565 ,6.3921 ,-4.3285>, 0.3000
<8.8991 ,8.9490 ,-6.0599>, 0.1000
}
cone {
<7.1319 ,5.5043 ,-4.3403>, 0.3000
<9.9847 ,7.7061 ,-6.0764>, 0.1000
}
cone {
<7.7844 ,4.5235 ,-4.3521>, 0.3000
<10.8982 ,6.3329 ,-6.0929>, 0.1000
}
cone {
<8.3030 ,3.4666 ,-4.3638>, 0.3000
<11.6242 ,4.8532 ,-6.1094>, 0.1000
}
cone {
<8.6789 ,2.3517 ,-4.3756>, 0.3000
<12.1505 ,3.2924 ,-6.1259>, 0.1000
}
cone {
<8.9059 ,1.1981 ,-4.3874>, 0.3000
<12.4683 ,1.6773 ,-6.1423>, 0.1000
}
cone {
<8.9804 ,0.0254 ,-4.3991>, 0.3000
<12.5725 ,0.0356 ,-6.1588>, 0.1000
}
cone {
<8.9011 ,-1.1462 ,-4.4109>, 0.3000
<12.4616 ,-1.6047 ,-6.1752>, 0.1000
}
cone {
<8.6698 ,-2.2967 ,-4.4226>, 0.3000
<12.1377 ,-3.2154 ,-6.1917>, 0.1000
}
cone {
<8.2905 ,-3.4064 ,-4.4344>, 0.3000
<11.6067 ,-4.7690 ,-6.2081>, 0.1000
}
cone {
<7.7699 ,-4.4565 ,-4.4461>, 0.3000
<10.8779 ,-6.2391 ,-6.2245>, 0.1000
}
cone {
<7.1172 ,-5.4290 ,-4.4578>, 0.3000
<9.9640 ,-7.6006 ,-6.2409>, 0.1000
}
cone {
<6.3435 ,-6.3074 ,-4.4695>, 0.3000
<8.8810 ,-8.8303 ,-6.2573>, 0.1000
}
cone {
<5.4625 ,-7.0767 ,-4.4812>, 0.3000
<7.6474 ,-9.9074 ,-6.2737>, 0.1000
}
cone {
<4.4891 ,-7.7241 ,-4.4929>, 0.3000
<6.2848 ,-10.8137 ,-6.2901>, 0.1000
}
cone {
<3.4403 ,-8.2385 ,-4.5046>, 0.3000
<4.8164 ,-11.5339 ,-6.3065>, 0.1000
}
cone {
<2.3340 ,-8.6113 ,-4.5163>, 0.3000
<3.2676 ,-12.0559 ,-6.3228>, 0.1000
}
cone {
<1.1893 ,-8.8365 ,-4.5280>, 0.3000
<1.6650 ,-12.3710 ,-6.3392>, 0.1000
}
cone {
<0.0258 ,-8.9102 ,-4.5396>, 0.3000
<0.0361 ,-12.4742 ,-6.3555>, 0.1000
}
cone {
<-1.1367 ,-8.8314 ,-4.5513>, 0.3000
<-1.5913 ,-12.3640 ,-6.3718>, 0.1000
}
cone {
<-2.2781 ,-8.6017 ,-4.5630>, 0.3000
<-3.1893 ,-12.0424 ,-6.3881>, 0.1000
}
cone {
<-3.3790 ,-8.2253 ,-4.5746>, 0.3000
<-4.7306 ,-11.5154 ,-6.4044>, 0.1000
}
cone {
<-4.4207 ,-7.7087 ,-4.5862>, 0.3000
<-6.1890 ,-10.7922 ,-6.4207>, 0.1000
}
cone {
<-5.3854 ,-7.0610 ,-4.5979>, 0.3000
<-7.5396 ,-9.8853 ,-6.4370>, 0.1000
}
cone {
<-6.2567 ,-6.2934 ,-4.6095>, 0.3000
<-8.7594 ,-8.8107 ,-6.4533>, 0.1000
}
cone {
<-7.0198 ,-5.4192 ,-4.6211>, 0.3000
<-9.8277 ,-7.5869 ,-6.4695>, 0.1000
}
cone {
<-7.6618 ,-4.4536 ,-4.6327>, 0.3000
<-10.7266 ,-6.2350 ,-6.4858>, 0.1000
}
cone {
<-8.1720 ,-3.4131 ,-4.6443>, 0.3000
<-11.4408 ,-4.7784 ,-6.5020>, 0.1000
}
cone {
<-8.5417 ,-2.3157 ,-4.6559>, 0.3000
<-11.9583 ,-3.2420 ,-6.5182>, 0.1000
}
cone {
<-8.7648 ,-1.1802 ,-4.6675>, 0.3000
<-12.2707 ,-1.6523 ,-6.5345>, 0.1000
}
cone {
<-8.8378 ,-0.0261 ,-4.6790>, 0.3000
<-12.3729 ,-0.0366 ,-6.5507>, 0.1000
}
cone {
<-8.7595 ,1.1268 ,-4.6906>, 0.3000
<-12.2633 ,1.5776 ,-6.5668>, 0.1000
}
cone {
<-8.5315 ,2.2589 ,-4.7022>, 0.3000
<-11.9441 ,3.1625 ,-6.5830>, 0.1000
}
cone {
<-8.1580 ,3.3508 ,-4.7137>, 0.3000
<-11.4212 ,4.6911 ,-6.5992>, 0.1000
}
cone {
<-7.6455 ,4.3838 ,-4.7252>, 0.3000
<-10.7037 ,6.1374 ,-6.6153>, 0.1000
}
cone {
<-7.0030 ,5.3405 ,-4.7368>, 0.3000
<-9.8042 ,7.4767 ,-6.6315>, 0.1000
}
cone {
<-6.2417 ,6.2045 ,-4.7483>, 0.3000
<-8.7383 ,8.6863 ,-6.6476>, 0.1000
}
cone {
<-5.3746 ,6.9611 ,-4.7598>, 0.3000
<-7.5245 ,9.7456 ,-6.6637>, 0.1000
}
cone {
<-4.4170 ,7.5977 ,-4.7713>, 0.3000
<-6.1837 ,10.6368 ,-6.6799>, 0.1000
}
cone {
<-3.3851 ,8.1034 ,-4.7828>, 0.3000
<-4.7391 ,11.3448 ,-6.6960>, 0.1000
}
cone {
<-2.2968 ,8.4699 ,-4.7943>, 0.3000
<-3.2156 ,11.8579 ,-6.7120>, 0.1000
}
cone {
<-1.1708 ,8.6910 ,-4.8058>, 0.3000
<-1.6392 ,12.1674 ,-6.7281>, 0.1000
}
cone {
<-0.0265 ,8.7632 ,-4.8173>, 0.3000
<-0.0370 ,12.2684 ,-6.7442>, 0.1000
}
cone {
<1.1167 ,8.6854 ,-4.8287>, 0.3000
<1.5634 ,12.1596 ,-6.7602>, 0.1000
}
cone {
<2.2392 ,8.4592 ,-4.8402>, 0.3000
<3.1349 ,11.8429 ,-6.7763>, 0.1000
}
cone {
<3.3217 ,8.0887 ,-4.8516>, 0.3000
<4.6504 ,11.3242 ,-6.7923>, 0.1000
}
cone {
<4.3459 ,7.5805 ,-4.8631>, 0.3000
<6.0843 ,10.6127 ,-6.8083>, 0.1000
}
cone {
<5.2943 ,6.9433 ,-4.8745>, 0.3000
<7.4120 ,9.7206 ,-6.8243>, 0.1000
}
cone {
<6.1507 ,6.1884 ,-4.8859>, 0.3000
<8.6110 ,8.6637 ,-6.8403>, 0.1000
}
cone {
<6.9008 ,5.3287 ,-4.8974>, 0.3000
<9.6611 ,7.4602 ,-6.8563>, 0.1000
}
cone {
<7.5317 ,4.3792 ,-4.9088>, 0.3000
<10.5444 ,6.1309 ,-6.8723>, 0.1000
}
cone {
<8.0329 ,3.3562 ,-4.9202>, 0.3000
<11.2461 ,4.6987 ,-6.8882>, 0.1000
}
cone {
<8.3960 ,2.2774 ,-4.9316>, 0.3000
<11.7544 ,3.1883 ,-6.9042>, 0.1000
}
cone {
<8.6150 ,1.1612 ,-4.9429>, 0.3000
<12.0611 ,1.6256 ,-6.9201>, 0.1000
}
cone {
<8.6864 ,0.0268 ,-4.9543>, 0.3000
<12.1610 ,0.0375 ,-6.9360>, 0.1000
}
cone {
<8.6092 ,-1.1064 ,-4.9657>, 0.3000
<12.0528 ,-1.5489 ,-6.9520>, 0.1000
}
cone {
<8.3848 ,-2.2189 ,-4.9770>, 0.3000
<11.7388 ,-3.1065 ,-6.9679>, 0.1000
}
cone {
<8.0175 ,-3.2919 ,-4.9884>, 0.3000
<11.2244 ,-4.6086 ,-6.9837>, 0.1000
}
cone {
<7.5135 ,-4.3069 ,-4.9997>, 0.3000
<10.5190 ,-6.0297 ,-6.9996>, 0.1000
}
cone {
<6.8819 ,-5.2468 ,-5.0111>, 0.3000
<9.6347 ,-7.3455 ,-7.0155>, 0.1000
}
cone {
<6.1336 ,-6.0955 ,-5.0224>, 0.3000
<8.5870 ,-8.5337 ,-7.0313>, 0.1000
}
cone {
<5.2815 ,-6.8387 ,-5.0337>, 0.3000
<7.3941 ,-9.5742 ,-7.0472>, 0.1000
}
cone {
<4.3404 ,-7.4638 ,-5.0450>, 0.3000
<6.0766 ,-10.4494 ,-7.0630>, 0.1000
}
cone {
<3.3265 ,-7.9604 ,-5.0563>, 0.3000
<4.6571 ,-11.1446 ,-7.0788>, 0.1000
}
cone {
<2.2573 ,-8.3201 ,-5.0676>, 0.3000
<3.1603 ,-11.6481 ,-7.0946>, 0.1000
}
cone {
<1.1512 ,-8.5370 ,-5.0789>, 0.3000
<1.6117 ,-11.9518 ,-7.1104>, 0.1000
}
cone {
<0.0271 ,-8.6075 ,-5.0901>, 0.3000
<0.0379 ,-12.0506 ,-7.1262>, 0.1000
}
cone {
<-1.0958 ,-8.5308 ,-5.1014>, 0.3000
<-1.5341 ,-11.9432 ,-7.1420>, 0.1000
}
cone {
<-2.1981 ,-8.3084 ,-5.1127>, 0.3000
<-3.0774 ,-11.6317 ,-7.1577>, 0.1000
}
cone {
<-3.2612 ,-7.9442 ,-5.1239>, 0.3000
<-4.5657 ,-11.1219 ,-7.1735>, 0.1000
}
cone {
<-4.2668 ,-7.4448 ,-5.1351>, 0.3000
<-5.9736 ,-10.4227 ,-7.1892>, 0.1000
}
cone {
<-5.1980 ,-6.8188 ,-5.1464>, 0.3000
<-7.2772 ,-9.5463 ,-7.2049>, 0.1000
}
cone {
<-6.0387 ,-6.0772 ,-5.1576>, 0.3000
<-8.4542 ,-8.5081 ,-7.2206>, 0.1000
}
cone {
<-6.7749 ,-5.2329 ,-5.1688>, 0.3000
<-9.4849 ,-7.3261 ,-7.2363>, 0.1000
}
cone {
<-7.3941 ,-4.3005 ,-5.1800>, 0.3000
<-10.3518 ,-6.0207 ,-7.2520>, 0.1000
}
cone {
<-7.8859 ,-3.2960 ,-5.1912>, 0.3000
<-11.0403 ,-4.6144 ,-7.2677>, 0.1000
}
cone {
<-8.2421 ,-2.2367 ,-5.2024>, 0.3000
<-11.5389 ,-3.1314 ,-7.2833>, 0.1000
}
cone {
<-8.4568 ,-1.1409 ,-5.2135>, 0.3000
<-11.8395 ,-1.5973 ,-7.2990>, 0.1000
}
cone {
<-8.5265 ,-0.0274 ,-5.2247>, 0.3000
<-11.9371 ,-0.0383 ,-7.3146>, 0.1000
}
cone {
<-8.4504 ,1.0849 ,-5.2359>, 0.3000
<-11.8305 ,1.5188 ,-7.3302>, 0.1000
}
cone {
<-8.2298 ,2.1768 ,-5.2470>, 0.3000
<-11.5218 ,3.0475 ,-7.3458>, 0.1000
}
cone {
<-7.8690 ,3.2297 ,-5.2582>, 0.3000
<-11.0166 ,4.5216 ,-7.3614>, 0.1000
}
cone {
<-7.3741 ,4.2257 ,-5.2693>, 0.3000
<-10.3238 ,5.9160 ,-7.3770>, 0.1000
}
cone {
<-6.7540 ,5.1479 ,-5.2804>, 0.3000
<-9.4556 ,7.2070 ,-7.3926>, 0.1000
}
cone {
<-6.0194 ,5.9805 ,-5.2915>, 0.3000
<-8.4272 ,8.3727 ,-7.4081>, 0.1000
}
cone {
<-5.1831 ,6.7095 ,-5.3026>, 0.3000
<-7.2563 ,9.3933 ,-7.4237>, 0.1000
}
cone {
<-4.2595 ,7.3226 ,-5.3137>, 0.3000
<-5.9633 ,10.2517 ,-7.4392>, 0.1000
}
cone {
<-3.2646 ,7.8095 ,-5.3248>, 0.3000
<-4.5705 ,10.9333 ,-7.4547>, 0.1000
}
cone {
<-2.2156 ,8.1621 ,-5.3359>, 0.3000
<-3.1018 ,11.4269 ,-7.4702>, 0.1000
}
cone {
<-1.1304 ,8.3745 ,-5.3469>, 0.3000
<-1.5825 ,11.7243 ,-7.4857>, 0.1000
}
cone {
<-0.0276 ,8.4434 ,-5.3580>, 0.3000
<-0.0387 ,11.8208 ,-7.5012>, 0.1000
}
cone {
<1.0738 ,8.3678 ,-5.3690>, 0.3000
<1.5033 ,11.7150 ,-7.5167>, 0.1000
}
cone {
<2.1549 ,8.1493 ,-5.3801>, 0.3000
<3.0169 ,11.4090 ,-7.5321>, 0.1000
}
cone {
<3.1975 ,7.7918 ,-5.3911>, 0.3000
<4.4765 ,10.9085 ,-7.5475>, 0.1000
}
cone {
<4.1836 ,7.3017 ,-5.4021>, 0.3000
<5.8571 ,10.2223 ,-7.5630>, 0.1000
}
cone {
<5.0966 ,6.6875 ,-5.4131>, 0.3000
<7.1352 ,9.3625 ,-7.5784>, 0.1000
}
cone {
<5.9208 ,5.9601 ,-5.4241>, 0.3000
<8.2892 ,8.3441 ,-7.5938>, 0.1000
}
cone {
<6.6425 ,5.1320 ,-5.4351>, 0.3000
<9.2994 ,7.1847 ,-7.6092>, 0.1000
}
cone {
<7.2493 ,4.2175 ,-5.4461>, 0.3000
<10.1490 ,5.9045 ,-7.6246>, 0.1000
}
cone {
<7.7312 ,3.2325 ,-5.4571>, 0.3000
<10.8237 ,4.5255 ,-7.6399>, 0.1000
}
cone {
<8.0801 ,2.1939 ,-5.4681>, 0.3000
<11.3121 ,3.0714 ,-7.6553>, 0.1000
}
cone {
<8.2902 ,1.1195 ,-5.4790>, 0.3000
<11.6063 ,1.5673 ,-7.6706>, 0.1000
}
cone {
<8.3582 ,0.0279 ,-5.4899>, 0.3000
<11.7015 ,0.0390 ,-7.6859>, 0.1000
}
cone {
<8.2832 ,-1.0624 ,-5.5009>, 0.3000
<11.5965 ,-1.4873 ,-7.7012>, 0.1000
}
cone {
<8.0667 ,-2.1326 ,-5.5118>, 0.3000
<11.2934 ,-2.9856 ,-7.7165>, 0.1000
}
cone {
<7.7127 ,-3.1645 ,-5.5227>, 0.3000
<10.7978 ,-4.4302 ,-7.7318>, 0.1000
}
cone {
<7.2274 ,-4.1405 ,-5.5336>, 0.3000
<10.1184 ,-5.7966 ,-7.7471>, 0.1000
}
cone {
<6.6194 ,-5.0440 ,-5.5445>, 0.3000
<9.2672 ,-7.0616 ,-7.7623>, 0.1000
}
cone {
<5.8993 ,-5.8597 ,-5.5554>, 0.3000
<8.2590 ,-8.2035 ,-7.7776>, 0.1000
}
cone {
<5.0796 ,-6.5738 ,-5.5663>, 0.3000
<7.1114 ,-9.2033 ,-7.7928>, 0.1000
}
cone {
<4.1744 ,-7.1742 ,-5.5772>, 0.3000
<5.8442 ,-10.0439 ,-7.8080>, 0.1000
}
cone {
<3.1995 ,-7.6510 ,-5.5880>, 0.3000
<4.4793 ,-10.7113 ,-7.8232>, 0.1000
}
cone {
<2.1716 ,-7.9960 ,-5.5989>, 0.3000
<3.0402 ,-11.1945 ,-7.8384>, 0.1000
}
cone {
<1.1084 ,-8.2038 ,-5.6097>, 0.3000
<1.5518 ,-11.4853 ,-7.8536>, 0.1000
}
cone {
<0.0281 ,-8.2709 ,-5.6206>, 0.3000
<0.0394 ,-11.5793 ,-7.8688>, 0.1000
}
cone {
<-1.0507 ,-8.1966 ,-5.6314>, 0.3000
<-1.4710 ,-11.4752 ,-7.8839>, 0.1000
}
cone {
<-2.1097 ,-7.9822 ,-5.6422>, 0.3000
<-2.9535 ,-11.1750 ,-7.8991>, 0.1000
}
cone {
<-3.1307 ,-7.6317 ,-5.6530>, 0.3000
<-4.3829 ,-10.6844 ,-7.9142>, 0.1000
}
cone {
<-4.0963 ,-7.1514 ,-5.6638>, 0.3000
<-5.7348 ,-10.0119 ,-7.9293>, 0.1000
}
cone {
<-4.9902 ,-6.5496 ,-5.6746>, 0.3000
<-6.9862 ,-9.1695 ,-7.9444>, 0.1000
}
cone {
<-5.7971 ,-5.8370 ,-5.6853>, 0.3000
<-8.1159 ,-8.1718 ,-7.9595>, 0.1000
}
cone {
<-6.5035 ,-5.0259 ,-5.6961>, 0.3000
<-9.1048 ,-7.0362 ,-7.9745>, 0.1000
}
cone {
<-7.0974 ,-4.1303 ,-5.7069>, 0.3000
<-9.9363 ,-5.7824 ,-7.9896>, 0.1000
}
cone {
<-7.5688 ,-3.1657 ,-5.7176>, 0.3000
<-10.5964 ,-4.4320 ,-8.0046>, 0.1000
}
cone {
<-7.9101 ,-2.1488 ,-5.7283>, 0.3000
<-11.0741 ,-3.0083 ,-8.0197>, 0.1000
}
cone {
<-8.1154 ,-1.0970 ,-5.7391>, 0.3000
<-11.3616 ,-1.5358 ,-8.0347>, 0.1000
}
cone {
<-8.1816 ,-0.0283 ,-5.7498>, 0.3000
<-11.4543 ,-0.0397 ,-8.0497>, 0.1000
}
cone {
<-8.1079 ,1.0388 ,-5.7605>, 0.3000
<-11.3510 ,1.4544 ,-8.0647>, 0.1000
}
cone {
<-7.8956 ,2.0863 ,-5.7712>, 0.3000
<-11.0539 ,2.9208 ,-8.0796>, 0.1000
}
cone {
<-7.5488 ,3.0961 ,-5.7819>, 0.3000
<-10.5683 ,4.3345 ,-8.0946>, 0.1000
}
cone {
<-7.0735 ,4.0511 ,-5.7925>, 0.3000
<-9.9030 ,5.6716 ,-8.1095>, 0.1000
}
cone {
<-6.4782 ,4.9351 ,-5.8032>, 0.3000
<-9.0695 ,6.9092 ,-8.1245>, 0.1000
}
cone {
<-5.7733 ,5.7331 ,-5.8138>, 0.3000
<-8.0826 ,8.0263 ,-8.1394>, 0.1000
}
cone {
<-4.9710 ,6.4315 ,-5.8245>, 0.3000
<-6.9593 ,9.0042 ,-8.1543>, 0.1000
}
cone {
<-4.0851 ,7.0187 ,-5.8351>, 0.3000
<-5.7192 ,9.8263 ,-8.1692>, 0.1000
}
cone {
<-3.1312 ,7.4849 ,-5.8458>, 0.3000
<-4.3836 ,10.4788 ,-8.1841>, 0.1000
}
cone {
<-2.1254 ,7.8221 ,-5.8564>, 0.3000
<-2.9756 ,10.9510 ,-8.1989>, 0.1000
}
cone {
<-1.0853 ,8.0250 ,-5.8670>, 0.3000
<-1.5194 ,11.2350 ,-8.2138>, 0.1000
}
cone {
<-0.0285 ,8.0903 ,-5.8776>, 0.3000
<-0.0399 ,11.3265 ,-8.2286>, 0.1000
}
cone {
<1.0267 ,8.0172 ,-5.8882>, 0.3000
<1.4374 ,11.2241 ,-8.2434>, 0.1000
}
cone {
<2.0624 ,7.8072 ,-5.8987>, 0.3000
<2.8873 ,10.9300 ,-8.2582>, 0.1000
}
cone {
<3.0608 ,7.4640 ,-5.9093>, 0.3000
<4.2851 ,10.4497 ,-8.2730>, 0.1000
}
cone {
<4.0050 ,6.9940 ,-5.9198>, 0.3000
<5.6069 ,9.7916 ,-8.2878>, 0.1000
}
cone {
<4.8789 ,6.4052 ,-5.9304>, 0.3000
<6.8304 ,8.9673 ,-8.3025>, 0.1000
}
cone {
<5.6677 ,5.7081 ,-5.9409>, 0.3000
<7.9347 ,7.9914 ,-8.3173>, 0.1000
}
cone {
<6.3581 ,4.9148 ,-5.9514>, 0.3000
<8.9013 ,6.8807 ,-8.3320>, 0.1000
}
cone {
<6.9384 ,4.0390 ,-5.9620>, 0.3000
<9.7138 ,5.6546 ,-8.3467>, 0.1000
}
cone {
<7.3990 ,3.0958 ,-5.9725>, 0.3000
<10.3586 ,4.3341 ,-8.3615>, 0.1000
}
cone {
<7.7323 ,2.1015 ,-5.9830>, 0.3000
<10.8252 ,2.9422 ,-8.3761>, 0.1000
}
cone {
<7.9326 ,1.0733 ,-5.9934>, 0.3000
<11.1057 ,1.5026 ,-8.3908>, 0.1000
}
cone {
<7.9970 ,0.0287 ,-6.0039>, 0.3000
<11.1958 ,0.0402 ,-8.4055>, 0.1000
}
cone {
<7.9245 ,-1.0143 ,-6.0144>, 0.3000
<11.0944 ,-1.4200 ,-8.4201>, 0.1000
}
cone {
<7.7167 ,-2.0379 ,-6.0248>, 0.3000
<10.8034 ,-2.8531 ,-8.4348>, 0.1000
}
cone {
<7.3774 ,-3.0247 ,-6.0353>, 0.3000
<10.3284 ,-4.2346 ,-8.4494>, 0.1000
}
cone {
<6.9127 ,-3.9578 ,-6.0457>, 0.3000
<9.6777 ,-5.5410 ,-8.4640>, 0.1000
}
cone {
<6.3307 ,-4.8214 ,-6.0561>, 0.3000
<8.8629 ,-6.7500 ,-8.4786>, 0.1000
}
cone {
<5.6416 ,-5.6009 ,-6.0665>, 0.3000
<7.8982 ,-7.8412 ,-8.4931>, 0.1000
}
cone {
<4.8574 ,-6.2830 ,-6.0769>, 0.3000
<6.8004 ,-8.7962 ,-8.5077>, 0.1000
}
cone {
<3.9918 ,-6.8564 ,-6.0873>, 0.3000
<5.5885 ,-9.5989 ,-8.5223>, 0.1000
}
cone {
<3.0597 ,-7.3114 ,-6.0977>, 0.3000
<4.2836 ,-10.2359 ,-8.5368>, 0.1000
}
cone {
<2.0771 ,-7.6405 ,-6.1081>, 0.3000
<2.9080 ,-10.6967 ,-8.5513>, 0.1000
}
cone {
<1.0610 ,-7.8383 ,-6.1184>, 0.3000
<1.4855 ,-10.9736 ,-8.5658>, 0.1000
}
cone {
<0.0289 ,-7.9017 ,-6.1288>, 0.3000
<0.0404 ,-11.0624 ,-8.5803>, 0.1000
}
cone {
<-1.0017 ,-7.8299 ,-6.1391>, 0.3000
<-1.4024 ,-10.9619 ,-8.5948>, 0.1000
}
cone {
<-2.0130 ,-7.6244 ,-6.1494>, 0.3000
<-2.8183 ,-10.6742 ,-8.6092>, 0.1000
}
cone {
<-2.9879 ,-7.2890 ,-6.1598>, 0.3000
<-4.1831 ,-10.2046 ,-8.6237>, 0.1000
}
cone {
<-3.9097 ,-6.8297 ,-6.1701>, 0.3000
<-5.4736 ,-9.5615 ,-8.6381>, 0.1000
}
cone {
<-4.7628 ,-6.2545 ,-6.1804>, 0.3000
<-6.6679 ,-8.7563 ,-8.6525>, 0.1000
}
cone {
<-5.5327 ,-5.5736 ,-6.1906>, 0.3000
<-7.7458 ,-7.8031 ,-8.6669>, 0.1000
}
cone {
<-6.2064 ,-4.7988 ,-6.2009>, 0.3000
<-8.6890 ,-6.7184 ,-8.6813>, 0.1000
}
cone {
<-6.7727 ,-3.9436 ,-6.2112>, 0.3000
<-9.4817 ,-5.5211 ,-8.6957>, 0.1000
}
cone {
<-7.2219 ,-3.0228 ,-6.2214>, 0.3000
<-10.1107 ,-4.2319 ,-8.7100>, 0.1000
}
cone {
<-7.5468 ,-2.0522 ,-6.2317>, 0.3000
<-10.5656 ,-2.8730 ,-8.7244>, 0.1000
}
cone {
<-7.7420 ,-1.0485 ,-6.2419>, 0.3000
<-10.8389 ,-1.4679 ,-8.7387>, 0.1000
}
cone {
<-7.8045 ,-0.0290 ,-6.2521>, 0.3000
<-10.9263 ,-0.0406 ,-8.7530>, 0.1000
}
cone {
<-7.7334 ,0.9888 ,-6.2623>, 0.3000
<-10.8267 ,1.3844 ,-8.7673>, 0.1000
}
cone {
<-7.5302 ,1.9877 ,-6.2725>, 0.3000
<-10.5423 ,2.7827 ,-8.7816>, 0.1000
}
cone {
<-7.1988 ,2.9504 ,-6.2827>, 0.3000
<-10.0783 ,4.1306 ,-8.7958>, 0.1000
}
cone {
<-6.7450 ,3.8607 ,-6.2929>, 0.3000
<-9.4429 ,5.4049 ,-8.8101>, 0.1000
}
cone {
<-6.1768 ,4.7030 ,-6.3031>, 0.3000
<-8.6475 ,6.5842 ,-8.8243>, 0.1000
}
cone {
<-5.5043 ,5.4632 ,-6.3132>, 0.3000
<-7.7060 ,7.6484 ,-8.8385>, 0.1000
}
cone {
<-4.7391 ,6.1283 ,-6.3234>, 0.3000
<-6.6347 ,8.5796 ,-8.8527>, 0.1000
}
cone {
<-3.8945 ,6.6873 ,-6.3335>, 0.3000
<-5.4523 ,9.3622 ,-8.8669>, 0.1000
}
cone {
<-2.9851 ,7.1307 ,-6.3436>, 0.3000
<-4.1792 ,9.9830 ,-8.8811>, 0.1000
}
cone {
<-2.0267 ,7.4513 ,-6.3538>, 0.3000
<-2.8374 ,10.4319 ,-8.8953>, 0.1000
}
cone {
<-1.0357 ,7.6439 ,-6.3639>, 0.3000
<-1.4500 ,10.7014 ,-8.9094>, 0.1000
}
cone {
<-0.0291 ,7.7053 ,-6.3739>, 0.3000
<-0.0408 ,10.7874 ,-8.9235>, 0.1000
}
cone {
<0.9758 ,7.6349 ,-6.3840>, 0.3000
<1.3661 ,10.6889 ,-8.9376>, 0.1000
}
cone {
<1.9618 ,7.4342 ,-6.3941>, 0.3000
<2.7465 ,10.4078 ,-8.9517>, 0.1000
}
cone {
<2.9122 ,7.1068 ,-6.4042>, 0.3000
<4.0770 ,9.9495 ,-8.9658>, 0.1000
}
cone {
<3.8107 ,6.6586 ,-6.4142>, 0.3000
<5.3349 ,9.3220 ,-8.9799>, 0.1000
}
cone {
<4.6421 ,6.0976 ,-6.4242>, 0.3000
<6.4989 ,8.5366 ,-8.9939>, 0.1000
}
cone {
<5.3923 ,5.4336 ,-6.4343>, 0.3000
<7.5492 ,7.6070 ,-9.0080>, 0.1000
}
cone {
<6.0487 ,4.6781 ,-6.4443>, 0.3000
<8.4682 ,6.5494 ,-9.0220>, 0.1000
}
cone {
<6.6002 ,3.8444 ,-6.4543>, 0.3000
<9.2403 ,5.3821 ,-9.0360>, 0.1000
}
cone {
<7.0377 ,2.9467 ,-6.4643>, 0.3000
<9.8528 ,4.1254 ,-9.0500>, 0.1000
}
cone {
<7.3540 ,2.0007 ,-6.4743>, 0.3000
<10.2956 ,2.8010 ,-9.0640>, 0.1000
}
cone {
<7.5438 ,1.0226 ,-6.4842>, 0.3000
<10.5613 ,1.4317 ,-9.0779>, 0.1000
}
cone {
<7.6043 ,0.0292 ,-6.4942>, 0.3000
<10.6460 ,0.0409 ,-9.0919>, 0.1000
}
cone {
<7.5346 ,-0.9625 ,-6.5041>, 0.3000
<10.5484 ,-1.3474 ,-9.1058>, 0.1000
}
cone {
<7.3363 ,-1.9355 ,-6.5141>, 0.3000
<10.2708 ,-2.7097 ,-9.1197>, 0.1000
}
cone {
<7.0130 ,-2.8732 ,-6.5240>, 0.3000
<9.8182 ,-4.0225 ,-9.1336>, 0.1000
}
cone {
<6.5706 ,-3.7597 ,-6.5339>, 0.3000
<9.1988 ,-5.2636 ,-9.1475>, 0.1000
}
cone {
<6.0168 ,-4.5800 ,-6.5438>, 0.3000
<8.4236 ,-6.4120 ,-9.1613>, 0.1000
}
cone {
<5.3615 ,-5.3201 ,-6.5537>, 0.3000
<7.5061 ,-7.4481 ,-9.1752>, 0.1000
}
cone {
<4.6160 ,-5.9676 ,-6.5636>, 0.3000
<6.4624 ,-8.3546 ,-9.1890>, 0.1000
}
cone {
<3.7933 ,-6.5116 ,-6.5735>, 0.3000
<5.3106 ,-9.1162 ,-9.2028>, 0.1000
}
cone {
<2.9076 ,-6.9430 ,-6.5833>, 0.3000
<4.0706 ,-9.7203 ,-9.2166>, 0.1000
}
cone {
<1.9743 ,-7.2548 ,-6.5932>, 0.3000
<2.7640 ,-10.1568 ,-9.2304>, 0.1000
}
cone {
<1.0093 ,-7.4419 ,-6.6030>, 0.3000
<1.4130 ,-10.4186 ,-9.2442>, 0.1000
}
cone {
<0.0293 ,-7.5013 ,-6.6128>, 0.3000
<0.0410 ,-10.5018 ,-9.2580>, 0.1000
}
cone {
<-0.9489 ,-7.4324 ,-6.6226>, 0.3000
<-1.3285 ,-10.4053 ,-9.2717>, 0.1000
}
cone {
<-1.9087 ,-7.2366 ,-6.6324>, 0.3000
<-2.6721 ,-10.1312 ,-9.2854>, 0.1000
}
cone {
<-2.8336 ,-6.9175 ,-6.6422>, 0.3000
<-3.9670 ,-9.6845 ,-9.2991>, 0.1000
}
cone {
<-3.7079 ,-6.4809 ,-6.6520>, 0.3000
<-5.1910 ,-9.0733 ,-9.3128>, 0.1000
}
cone {
<-4.5168 ,-5.9346 ,-6.6618>, 0.3000
<-6.3235 ,-8.3084 ,-9.3265>, 0.1000
}
cone {
<-5.2466 ,-5.2881 ,-6.6715>, 0.3000
<-7.3452 ,-7.4033 ,-9.3401>, 0.1000
}
cone {
<-5.8850 ,-4.5527 ,-6.6813>, 0.3000
<-8.2390 ,-6.3738 ,-9.3538>, 0.1000
}
cone {
<-6.4213 ,-3.7412 ,-6.6910>, 0.3000
<-8.9899 ,-5.2377 ,-9.3674>, 0.1000
}
cone {
<-6.8466 ,-2.8677 ,-6.7007>, 0.3000
<-9.5853 ,-4.0148 ,-9.3810>, 0.1000
}
cone {
<-7.1539 ,-1.9473 ,-6.7104>, 0.3000
<-10.0154 ,-2.7262 ,-9.3946>, 0.1000
}
cone {
<-7.3381 ,-0.9957 ,-6.7201>, 0.3000
<-10.2734 ,-1.3940 ,-9.4082>, 0.1000
}
cone {
<-7.3965 ,-0.0294 ,-6.7298>, 0.3000
<-10.3551 ,-0.0411 ,-9.4218>, 0.1000
}
cone {
<-7.3283 ,0.9352 ,-6.7395>, 0.3000
<-10.2597 ,1.3092 ,-9.4353>, 0.1000
}
cone {
<-7.1351 ,1.8814 ,-6.7492>, 0.3000
<-9.9891 ,2.6340 ,-9.4488>, 0.1000
}
cone {
<-6.8203 ,2.7932 ,-6.7588>, 0.3000
<-9.5484 ,3.9105 ,-9.4624>, 0.1000
}
cone {
<-6.3897 ,3.6551 ,-6.7685>, 0.3000
<-8.9455 ,5.1172 ,-9.4759>, 0.1000
}
cone {
<-5.8509 ,4.4525 ,-6.7781>, 0.3000
<-8.1912 ,6.2335 ,-9.4893>, 0.1000
}
cone {
<-5.2134 ,5.1718 ,-6.7877>, 0.3000
<-7.2987 ,7.2405 ,-9.5028>, 0.1000
}
cone {
<-4.4883 ,5.8010 ,-6.7973>, 0.3000
<-6.2836 ,8.1214 ,-9.5162>, 0.1000
}
cone {
<-3.6883 ,6.3295 ,-6.8069>, 0.3000
<-5.1636 ,8.8613 ,-9.5297>, 0.1000
}
cone {
<-2.8272 ,6.7485 ,-6.8165>, 0.3000
<-3.9580 ,9.4479 ,-9.5431>, 0.1000
}
cone {
<-1.9198 ,7.0512 ,-6.8261>, 0.3000
<-2.6877 ,9.8717 ,-9.5565>, 0.1000
}
cone {
<-0.9818 ,7.2326 ,-6.8356>, 0.3000
<-1.3746 ,10.1256 ,-9.5699>, 0.1000
}
cone {
<-0.0294 ,7.2899 ,-6.8452>, 0.3000
<-0.0412 ,10.2059 ,-9.5832>, 0.1000
}
cone {
<0.9212 ,7.2225 ,-6.8547>, 0.3000
<1.2897 ,10.1115 ,-9.5966>, 0.1000
}
cone {
<1.8537 ,7.0318 ,-6.8642>, 0.3000
<2.5952 ,9.8445 ,-9.6099>, 0.1000
}
cone {
<2.7522 ,6.7214 ,-6.8738>, 0.3000
<3.8531 ,9.4099 ,-9.6233>, 0.1000
}
cone {
<3.6015 ,6.2968 ,-6.8833>, 0.3000
<5.0421 ,8.8156 ,-9.6366>, 0.1000
}
cone {
<4.3871 ,5.7657 ,-6.8927>, 0.3000
<6.1419 ,8.0720 ,-9.6498>, 0.1000
}
cone {
<5.0958 ,5.1374 ,-6.9022>, 0.3000
<7.1341 ,7.1923 ,-9.6631>, 0.1000
}
cone {
<5.7156 ,4.4228 ,-6.9117>, 0.3000
<8.0018 ,6.1919 ,-9.6764>, 0.1000
}
cone {
<6.2361 ,3.6344 ,-6.9211>, 0.3000
<8.7306 ,5.0881 ,-9.6896>, 0.1000
}
cone {
<6.6488 ,2.7859 ,-6.9306>, 0.3000
<9.3083 ,3.9002 ,-9.7028>, 0.1000
}
cone {
<6.9467 ,1.8918 ,-6.9400>, 0.3000
<9.7254 ,2.6486 ,-9.7160>, 0.1000
}
cone {
<7.1252 ,0.9677 ,-6.9494>, 0.3000
<9.9753 ,1.3548 ,-9.7292>, 0.1000
}
cone {
<7.1815 ,0.0294 ,-6.9588>, 0.3000
<10.0541 ,0.0412 ,-9.7424>, 0.1000
}
cone {
<7.1149 ,-0.9070 ,-6.9682>, 0.3000
<9.9608 ,-1.2698 ,-9.7555>, 0.1000
}
cone {
<6.9268 ,-1.8256 ,-6.9776>, 0.3000
<9.6975 ,-2.5558 ,-9.7687>, 0.1000
}
cone {
<6.6208 ,-2.7106 ,-6.9870>, 0.3000
<9.2691 ,-3.7948 ,-9.7818>, 0.1000
}
cone {
<6.2024 ,-3.5470 ,-6.9963>, 0.3000
<8.6834 ,-4.9658 ,-9.7949>, 0.1000
}
cone {
<5.6791 ,-4.3206 ,-7.0057>, 0.3000
<7.9508 ,-6.0489 ,-9.8080>, 0.1000
}
cone {
<5.0601 ,-5.0185 ,-7.0150>, 0.3000
<7.0841 ,-7.0259 ,-9.8210>, 0.1000
}
cone {
<4.3562 ,-5.6287 ,-7.0243>, 0.3000
<6.0986 ,-7.8802 ,-9.8341>, 0.1000
}
cone {
<3.5796 ,-6.1412 ,-7.0337>, 0.3000
<5.0114 ,-8.5977 ,-9.8471>, 0.1000
}
cone {
<2.7439 ,-6.5474 ,-7.0430>, 0.3000
<3.8414 ,-9.1663 ,-9.8601>, 0.1000
}
cone {
<1.8634 ,-6.8406 ,-7.0522>, 0.3000
<2.6088 ,-9.5768 ,-9.8731>, 0.1000
}
cone {
<0.9534 ,-7.0161 ,-7.0615>, 0.3000
<1.3347 ,-9.8226 ,-9.8861>, 0.1000
}
cone {
<0.0294 ,-7.0713 ,-7.0708>, 0.3000
<0.0412 ,-9.8998 ,-9.8991>, 0.1000
}
cone {
<-0.8926 ,-7.0055 ,-7.0800>, 0.3000
<-1.2497 ,-9.8076 ,-9.9120>, 0.1000
}
cone {
<-1.7970 ,-6.8201 ,-7.0893>, 0.3000
<-2.5158 ,-9.5481 ,-9.9250>, 0.1000
}
cone {
<-2.6682 ,-6.5186 ,-7.0985>, 0.3000
<-3.7355 ,-9.1260 ,-9.9379>, 0.1000
}
cone {
<-3.4916 ,-6.1065 ,-7.1077>, 0.3000
<-4.8883 ,-8.5491 ,-9.9508>, 0.1000
}
cone {
<-4.2531 ,-5.5911 ,-7.1169>, 0.3000
<-5.9544 ,-7.8276 ,-9.9637>, 0.1000
}
cone {
<-4.9399 ,-4.9815 ,-7.1261>, 0.3000
<-6.9159 ,-6.9742 ,-9.9765>, 0.1000
}
cone {
<-5.5405 ,-4.2884 ,-7.1353>, 0.3000
<-7.7567 ,-6.0038 ,-9.9894>, 0.1000
}
cone {
<-6.0448 ,-3.5239 ,-7.1444>, 0.3000
<-8.4627 ,-4.9335 ,-10.0022>, 0.1000
}
cone {
<-6.4444 ,-2.7012 ,-7.1536>, 0.3000
<-9.0221 ,-3.7816 ,-10.0150>, 0.1000
}
cone {
<-6.7328 ,-1.8345 ,-7.1627>, 0.3000
<-9.4259 ,-2.5683 ,-10.0278>, 0.1000
}
cone {
<-6.9053 ,-0.9388 ,-7.1719>, 0.3000
<-9.6674 ,-1.3143 ,-10.0406>, 0.1000
}
cone {
<-6.9594 ,-0.0294 ,-7.1810>, 0.3000
<-9.7431 ,-0.0412 ,-10.0534>, 0.1000
}
cone {
<-6.8943 ,0.8780 ,-7.1901>, 0.3000
<-9.6521 ,1.2292 ,-10.0661>, 0.1000
}
cone {
<-6.7117 ,1.7680 ,-7.1992>, 0.3000
<-9.3963 ,2.4751 ,-10.0788>, 0.1000
}
cone {
<-6.4148 ,2.6253 ,-7.2082>, 0.3000
<-8.9807 ,3.6754 ,-10.0915>, 0.1000
}
cone {
<-6.0090 ,3.4354 ,-7.2173>, 0.3000
<-8.4127 ,4.8095 ,-10.1042>, 0.1000
}
cone {
<-5.5017 ,4.1846 ,-7.2264>, 0.3000
<-7.7024 ,5.8584 ,-10.1169>, 0.1000
}
cone {
<-4.9018 ,4.8602 ,-7.2354>, 0.3000
<-6.8625 ,6.8043 ,-10.1296>, 0.1000
}
cone {
<-4.2197 ,5.4509 ,-7.2444>, 0.3000
<-5.9075 ,7.6313 ,-10.1422>, 0.1000
}
cone {
<-3.4673 ,5.9469 ,-7.2534>, 0.3000
<-4.8543 ,8.3256 ,-10.1548>, 0.1000
}
cone {
<-2.6578 ,6.3398 ,-7.2625>, 0.3000
<-3.7209 ,8.8757 ,-10.1674>, 0.1000
}
cone {
<-1.8051 ,6.6233 ,-7.2714>, 0.3000
<-2.5271 ,9.2726 ,-10.1800>, 0.1000
}
cone {
<-0.9239 ,6.7928 ,-7.2804>, 0.3000
<-1.2935 ,9.5099 ,-10.1926>, 0.1000
}
cone {
<-0.0294 ,6.8457 ,-7.2894>, 0.3000
<-0.0411 ,9.5840 ,-10.2051>, 0.1000
}
cone {
<0.8632 ,6.7815 ,-7.2983>, 0.3000
<1.2085 ,9.4941 ,-10.2177>, 0.1000
}
cone {
<1.7385 ,6.6016 ,-7.3073>, 0.3000
<2.4339 ,9.2422 ,-10.2302>, 0.1000
}
cone {
<2.5817 ,6.3094 ,-7.3162>, 0.3000
<3.6143 ,8.8331 ,-10.2427>, 0.1000
}
cone {
<3.3783 ,5.9101 ,-7.3251>, 0.3000
<4.7297 ,8.2741 ,-10.2552>, 0.1000
}
cone {
<4.1150 ,5.4110 ,-7.3340>, 0.3000
<5.7610 ,7.5753 ,-10.2677>, 0.1000
}
cone {
<4.7793 ,4.8208 ,-7.3429>, 0.3000
<6.6910 ,6.7491 ,-10.2801>, 0.1000
}
cone {
<5.3600 ,4.1498 ,-7.3518>, 0.3000
<7.5040 ,5.8098 ,-10.2925>, 0.1000
}
cone {
<5.8475 ,3.4099 ,-7.3607>, 0.3000
<8.1865 ,4.7738 ,-10.3049>, 0.1000
}
cone {
<6.2336 ,2.6138 ,-7.3695>, 0.3000
<8.7271 ,3.6593 ,-10.3173>, 0.1000
}
cone {
<6.5121 ,1.7753 ,-7.3784>, 0.3000
<9.1170 ,2.4854 ,-10.3297>, 0.1000
}
cone {
<6.6786 ,0.9088 ,-7.3872>, 0.3000
<9.3500 ,1.2723 ,-10.3421>, 0.1000
}
cone {
<6.7304 ,0.0293 ,-7.3960>, 0.3000
<9.4225 ,0.0410 ,-10.3544>, 0.1000
}
cone {
<6.6670 ,-0.8482 ,-7.4048>, 0.3000
<9.3338 ,-1.1875 ,-10.3668>, 0.1000
}
cone {
<6.4899 ,-1.7087 ,-7.4136>, 0.3000
<9.0859 ,-2.3921 ,-10.3791>, 0.1000
}
cone {
<6.2024 ,-2.5374 ,-7.4224>, 0.3000
<8.6833 ,-3.5524 ,-10.3913>, 0.1000
}
cone {
<5.8097 ,-3.3204 ,-7.4312>, 0.3000
<8.1336 ,-4.6486 ,-10.4036>, 0.1000
}
cone {
<5.3189 ,-4.0444 ,-7.4399>, 0.3000
<7.4464 ,-5.6622 ,-10.4159>, 0.1000
}
cone {
<4.7386 ,-4.6972 ,-7.4486>, 0.3000
<6.6340 ,-6.5761 ,-10.4281>, 0.1000
}
cone {
<4.0790 ,-5.2678 ,-7.4574>, 0.3000
<5.7106 ,-7.3749 ,-10.4403>, 0.1000
}
cone {
<3.3516 ,-5.7467 ,-7.4661>, 0.3000
<4.6922 ,-8.0454 ,-10.4525>, 0.1000
}
cone {
<2.5691 ,-6.1260 ,-7.4748>, 0.3000
<3.5967 ,-8.5763 ,-10.4647>, 0.1000
}
cone {
<1.7450 ,-6.3994 ,-7.4835>, 0.3000
<2.4429 ,-8.9592 ,-10.4769>, 0.1000
}
cone {
<0.8935 ,-6.5627 ,-7.4922>, 0.3000
<1.2508 ,-9.1878 ,-10.4890>, 0.1000
}
cone {
<0.0292 ,-6.6134 ,-7.5008>, 0.3000
<0.0409 ,-9.2587 ,-10.5011>, 0.1000
}
cone {
<-0.8330 ,-6.5509 ,-7.5095>, 0.3000
<-1.1662 ,-9.1712 ,-10.5133>, 0.1000
}
cone {
<-1.6784 ,-6.3766 ,-7.5181>, 0.3000
<-2.3498 ,-8.9272 ,-10.5253>, 0.1000
}
cone {
<-2.4926 ,-6.0939 ,-7.5267>, 0.3000
<-3.4896 ,-8.5314 ,-10.5374>, 0.1000
}
cone {
<-3.2618 ,-5.7079 ,-7.5353>, 0.3000
<-4.5665 ,-7.9910 ,-10.5495>, 0.1000
}
cone {
<-3.9729 ,-5.2254 ,-7.5439>, 0.3000
<-5.5620 ,-7.3156 ,-10.5615>, 0.1000
}
cone {
<-4.6140 ,-4.6552 ,-7.5525>, 0.3000
<-6.4595 ,-6.5172 ,-10.5735>, 0.1000
}
cone {
<-5.1743 ,-4.0071 ,-7.5611>, 0.3000
<-7.2440 ,-5.6099 ,-10.5855>, 0.1000
}
cone {
<-5.6445 ,-3.2925 ,-7.5697>, 0.3000
<-7.9022 ,-4.6094 ,-10.5975>, 0.1000
}
cone {
<-6.0168 ,-2.5237 ,-7.5782>, 0.3000
<-8.4235 ,-3.5332 ,-10.6095>, 0.1000
}
cone {
<-6.2851 ,-1.7142 ,-7.5867>, 0.3000
<-8.7992 ,-2.3999 ,-10.6214>, 0.1000
}
cone {
<-6.4453 ,-0.8779 ,-7.5953>, 0.3000
<-9.0234 ,-1.2290 ,-10.6334>, 0.1000
}
cone {
<-6.4948 ,-0.0291 ,-7.6038>, 0.3000
<-9.0927 ,-0.0407 ,-10.6453>, 0.1000
}
cone {
<-6.4331 ,0.8176 ,-7.6123>, 0.3000
<-9.0064 ,1.1447 ,-10.6572>, 0.1000
}
cone {
<-6.2617 ,1.6477 ,-7.6207>, 0.3000
<-8.7664 ,2.3068 ,-10.6690>, 0.1000
}
cone {
<-5.9839 ,2.4471 ,-7.6292>, 0.3000
<-8.3774 ,3.4260 ,-10.6809>, 0.1000
}
cone {
<-5.6046 ,3.2023 ,-7.6377>, 0.3000
<-7.8464 ,4.4832 ,-10.6927>, 0.1000
}
cone {
<-5.1307 ,3.9003 ,-7.6461>, 0.3000
<-7.1830 ,5.4605 ,-10.7046>, 0.1000
}
cone {
<-4.5706 ,4.5296 ,-7.6545>, 0.3000
<-6.3989 ,6.3414 ,-10.7164>, 0.1000
}
cone {
<-3.9342 ,5.0795 ,-7.6630>, 0.3000
<-5.5079 ,7.1113 ,-10.7281>, 0.1000
}
cone {
<-3.2325 ,5.5409 ,-7.6714>, 0.3000
<-4.5255 ,7.7572 ,-10.7399>, 0.1000
}
cone {
<-2.4778 ,5.9061 ,-7.6798>, 0.3000
<-3.4689 ,8.2686 ,-10.7517>, 0.1000
}
cone {
<-1.6830 ,6.1693 ,-7.6881>, 0.3000
<-2.3563 ,8.6370 ,-10.7634>, 0.1000
}
cone {
<-0.8621 ,6.3262 ,-7.6965>, 0.3000
<-1.2069 ,8.8567 ,-10.7751>, 0.1000
}
cone {
<-0.0289 ,6.3745 ,-7.7048>, 0.3000
<-0.0405 ,8.9243 ,-10.7868>, 0.1000
}
cone {
<0.8020 ,6.3138 ,-7.7132>, 0.3000
<1.1229 ,8.8393 ,-10.7985>, 0.1000
}
cone {
<1.6167 ,6.1453 ,-7.7215>, 0.3000
<2.2634 ,8.6034 ,-10.8101>, 0.1000
}
cone {
<2.4011 ,5.8724 ,-7.7298>, 0.3000
<3.3616 ,8.2213 ,-10.8217>, 0.1000
}
cone {
<3.1420 ,5.4999 ,-7.7381>, 0.3000
<4.3988 ,7.6999 ,-10.8334>, 0.1000
}
cone {
<3.8269 ,5.0347 ,-7.7464>, 0.3000
<5.3576 ,7.0486 ,-10.8450>, 0.1000
}
cone {
<4.4441 ,4.4850 ,-7.7547>, 0.3000
<6.2218 ,6.2789 ,-10.8565>, 0.1000
}
cone {
<4.9835 ,3.8603 ,-7.7629>, 0.3000
<6.9768 ,5.4045 ,-10.8681>, 0.1000
}
cone {
<5.4359 ,3.1717 ,-7.7712>, 0.3000
<7.6103 ,4.4404 ,-10.8796>, 0.1000
}
cone {
<5.7940 ,2.4312 ,-7.7794>, 0.3000
<8.1116 ,3.4036 ,-10.8912>, 0.1000
}
cone {
<6.0519 ,1.6514 ,-7.7876>, 0.3000
<8.4727 ,2.3120 ,-10.9027>, 0.1000
}
cone {
<6.2056 ,0.8460 ,-7.7958>, 0.3000
<8.6878 ,1.1845 ,-10.9142>, 0.1000
}
cone {
<6.2527 ,0.0288 ,-7.8040>, 0.3000
<8.7538 ,0.0403 ,-10.9256>, 0.1000
}
cone {
<6.1929 ,-0.7863 ,-7.8122>, 0.3000
<8.6700 ,-1.1008 ,-10.9371>, 0.1000
}
cone {
<6.0274 ,-1.5852 ,-7.8204>, 0.3000
<8.4383 ,-2.2193 ,-10.9485>, 0.1000
}
cone {
<5.7594 ,-2.3545 ,-7.8285>, 0.3000
<8.0632 ,-3.2963 ,-10.9599>, 0.1000
}
cone {
<5.3939 ,-3.0810 ,-7.8366>, 0.3000
<7.5515 ,-4.3134 ,-10.9713>, 0.1000
}
cone {
<4.9375 ,-3.7525 ,-7.8448>, 0.3000
<6.9125 ,-5.2534 ,-10.9827>, 0.1000
}
cone {
<4.3982 ,-4.3576 ,-7.8529>, 0.3000
<6.1574 ,-6.1006 ,-10.9940>, 0.1000
}
cone {
<3.7855 ,-4.8862 ,-7.8610>, 0.3000
<5.2997 ,-6.8407 ,-11.0054>, 0.1000
}
cone {
<3.1102 ,-5.3296 ,-7.8691>, 0.3000
<4.3542 ,-7.4615 ,-11.0167>, 0.1000
}
cone {
<2.3839 ,-5.6805 ,-7.8771>, 0.3000
<3.3375 ,-7.9526 ,-11.0280>, 0.1000
}
cone {
<1.6194 ,-5.9331 ,-7.8852>, 0.3000
<2.2672 ,-8.3063 ,-11.0393>, 0.1000
}
cone {
<0.8298 ,-6.0834 ,-7.8932>, 0.3000
<1.1617 ,-8.5168 ,-11.0505>, 0.1000
}
cone {
<0.0286 ,-6.1294 ,-7.9013>, 0.3000
<0.0401 ,-8.5811 ,-11.0618>, 0.1000
}
cone {
<-0.7703 ,-6.0704 ,-7.9093>, 0.3000
<-1.0785 ,-8.4986 ,-11.0730>, 0.1000
}
cone {
<-1.5534 ,-5.9079 ,-7.9173>, 0.3000
<-2.1748 ,-8.2711 ,-11.0842>, 0.1000
}
cone {
<-2.3073 ,-5.6450 ,-7.9253>, 0.3000
<-3.2303 ,-7.9030 ,-11.0954>, 0.1000
}
cone {
<-3.0192 ,-5.2866 ,-7.9332>, 0.3000
<-4.2269 ,-7.4012 ,-11.1065>, 0.1000
}
cone {
<-3.6771 ,-4.8390 ,-7.9412>, 0.3000
<-5.1480 ,-6.7746 ,-11.1177>, 0.1000
}
cone {
<-4.2699 ,-4.3103 ,-7.9492>, 0.3000
<-5.9779 ,-6.0344 ,-11.1288>, 0.1000
}
cone {
<-4.7878 ,-3.7097 ,-7.9571>, 0.3000
<-6.7029 ,-5.1936 ,-11.1399>, 0.1000
}
cone {
<-5.2220 ,-3.0478 ,-7.9650>, 0.3000
<-7.3108 ,-4.2669 ,-11.1510>, 0.1000
}
cone {
<-5.5655 ,-2.3361 ,-7.9729>, 0.3000
<-7.7917 ,-3.2706 ,-11.1621>, 0.1000
}
cone {
<-5.8128 ,-1.5870 ,-7.9808>, 0.3000
<-8.1379 ,-2.2218 ,-11.1731>, 0.1000
}
cone {
<-5.9598 ,-0.8133 ,-7.9887>, 0.3000
<-8.3437 ,-1.1386 ,-11.1842>, 0.1000
}
cone {
<-6.0045 ,-0.0284 ,-7.9966>, 0.3000
<-8.4063 ,-0.0398 ,-11.1952>, 0.1000
}
cone {
<-5.9465 ,0.7542 ,-8.0044>, 0.3000
<-8.3251 ,1.0559 ,-11.2062>, 0.1000
}
cone {
<-5.7870 ,1.5213 ,-8.0123>, 0.3000
<-8.1018 ,2.1298 ,-11.2172>, 0.1000
}
cone {
<-5.5292 ,2.2596 ,-8.0201>, 0.3000
<-7.7409 ,3.1634 ,-11.2281>, 0.1000
}
cone {
<-5.1779 ,2.9567 ,-8.0279>, 0.3000
<-7.2491 ,4.1394 ,-11.2390>, 0.1000
}
cone {
<-4.7393 ,3.6009 ,-8.0357>, 0.3000
<-6.6350 ,5.0413 ,-11.2500>, 0.1000
}
cone {
<-4.2213 ,4.1813 ,-8.0435>, 0.3000
<-5.9098 ,5.8538 ,-11.2609>, 0.1000
}
cone {
<-3.6330 ,4.6882 ,-8.0512>, 0.3000
<-5.0862 ,6.5634 ,-11.2717>, 0.1000
}
cone {
<-2.9847 ,5.1131 ,-8.0590>, 0.3000
<-4.1786 ,7.1584 ,-11.2826>, 0.1000
}
cone {
<-2.2877 ,5.4492 ,-8.0667>, 0.3000
<-3.2028 ,7.6289 ,-11.2934>, 0.1000
}
cone {
<-1.5541 ,5.6910 ,-8.0745>, 0.3000
<-2.1758 ,7.9674 ,-11.3043>, 0.1000
}
cone {
<-0.7966 ,5.8347 ,-8.0822>, 0.3000
<-1.1152 ,8.1686 ,-11.3151>, 0.1000
}
cone {
<-0.0282 ,5.8782 ,-8.0899>, 0.3000
<-0.0395 ,8.2294 ,-11.3258>, 0.1000
}
cone {
<0.7379 ,5.8211 ,-8.0976>, 0.3000
<1.0331 ,8.1495 ,-11.3366>, 0.1000
}
cone {
<1.4887 ,5.6647 ,-8.1052>, 0.3000
<2.0842 ,7.9306 ,-11.3473>, 0.1000
}
cone {
<2.2113 ,5.4121 ,-8.1129>, 0.3000
<3.0958 ,7.5769 ,-11.3581>, 0.1000
}
cone {
<2.8935 ,5.0679 ,-8.1206>, 0.3000
<4.0509 ,7.0951 ,-11.3688>, 0.1000
}
cone {
<3.5238 ,4.6385 ,-8.1282>, 0.3000
<4.9333 ,6.4938 ,-11.3795>, 0.1000
}
cone {
<4.0916 ,4.1313 ,-8.1358>, 0.3000
<5.7282 ,5.7838 ,-11.3901>, 0.1000
}
cone {
<4.5874 ,3.5554 ,-8.1434>, 0.3000
<6.4224 ,4.9775 ,-11.4008>, 0.1000
}
cone {
<5.0030 ,2.9208 ,-8.1510>, 0.3000
<7.0042 ,4.0892 ,-11.4114>, 0.1000
}
cone {
<5.3316 ,2.2387 ,-8.1586>, 0.3000
<7.4642 ,3.1342 ,-11.4220>, 0.1000
}
cone {
<5.5679 ,1.5209 ,-8.1661>, 0.3000
<7.7950 ,2.1292 ,-11.4326>, 0.1000
}
cone {
<5.7081 ,0.7797 ,-8.1737>, 0.3000
<7.9914 ,1.0916 ,-11.4432>, 0.1000
}
cone {
<5.7504 ,0.0279 ,-8.1812>, 0.3000
<8.0505 ,0.0391 ,-11.4537>, 0.1000
}
cone {
<5.6942 ,-0.7215 ,-8.1887>, 0.3000
<7.9719 ,-1.0101 ,-11.4642>, 0.1000
}
cone {
<5.5410 ,-1.4558 ,-8.1962>, 0.3000
<7.7573 ,-2.0381 ,-11.4747>, 0.1000
}
cone {
<5.2936 ,-2.1625 ,-8.2037>, 0.3000
<7.4110 ,-3.0275 ,-11.4852>, 0.1000
}
cone {
<4.9567 ,-2.8296 ,-8.2112>, 0.3000
<6.9394 ,-3.9615 ,-11.4957>, 0.1000
}
cone {
<4.5364 ,-3.4459 ,-8.2187>, 0.3000
<6.3510 ,-4.8242 ,-11.5061>, 0.1000
}
cone {
<4.0402 ,-4.0009 ,-8.2261>, 0.3000
<5.6563 ,-5.6013 ,-11.5166>, 0.1000
}
cone {
<3.4769 ,-4.4855 ,-8.2336>, 0.3000
<4.8676 ,-6.2797 ,-11.5270>, 0.1000
}
cone {
<2.8562 ,-4.8916 ,-8.2410>, 0.3000
<3.9987 ,-6.8483 ,-11.5374>, 0.1000
}
cone {
<2.1892 ,-5.2126 ,-8.2484>, 0.3000
<3.0648 ,-7.2977 ,-11.5477>, 0.1000
}
cone {
<1.4872 ,-5.4434 ,-8.2558>, 0.3000
<2.0821 ,-7.6207 ,-11.5581>, 0.1000
}
cone {
<0.7626 ,-5.5802 ,-8.2632>, 0.3000
<1.0676 ,-7.8123 ,-11.5684>, 0.1000
}
cone {
<0.0277 ,-5.6212 ,-8.2705>, 0.3000
<0.0387 ,-7.8696 ,-11.5787>, 0.1000
}
cone {
<-0.7049 ,-5.5660 ,-8.2779>, 0.3000
<-0.9868 ,-7.7923 ,-11.5890>, 0.1000
}
cone {
<-1.4226 ,-5.4159 ,-8.2852>, 0.3000
<-1.9916 ,-7.5822 ,-11.5993>, 0.1000
}
cone {
<-2.1132 ,-5.1738 ,-8.2925>, 0.3000
<-2.9585 ,-7.2433 ,-11.6096>, 0.1000
}
cone {
<-2.7650 ,-4.8443 ,-8.2998>, 0.3000
<-3.8710 ,-6.7820 ,-11.6198>, 0.1000
}
cone {
<-3.3671 ,-4.4333 ,-8.3071>, 0.3000
<-4.7139 ,-6.2066 ,-11.6300>, 0.1000
}
cone {
<-3.9093 ,-3.9482 ,-8.3144>, 0.3000
<-5.4730 ,-5.5275 ,-11.6402>, 0.1000
}
cone {
<-4.3825 ,-3.3975 ,-8.3217>, 0.3000
<-6.1355 ,-4.7565 ,-11.6504>, 0.1000
}
cone {
<-4.7791 ,-2.7909 ,-8.3289>, 0.3000
<-6.6907 ,-3.9073 ,-11.6605>, 0.1000
}
cone {
<-5.0924 ,-2.1391 ,-8.3362>, 0.3000
<-7.1294 ,-2.9947 ,-11.6706>, 0.1000
}
cone {
<-5.3175 ,-1.4532 ,-8.3434>, 0.3000
<-7.4445 ,-2.0345 ,-11.6808>, 0.1000
}
cone {
<-5.4509 ,-0.7453 ,-8.3506>, 0.3000
<-7.6312 ,-1.0434 ,-11.6908>, 0.1000
}
cone {
<-5.4906 ,-0.0274 ,-8.3578>, 0.3000
<-7.6868 ,-0.0383 ,-11.7009>, 0.1000
}
cone {
<-5.4363 ,0.6881 ,-8.3650>, 0.3000
<-7.6109 ,0.9634 ,-11.7110>, 0.1000
}
cone {
<-5.2894 ,1.3890 ,-8.3721>, 0.3000
<-7.4052 ,1.9446 ,-11.7210>, 0.1000
}
cone {
<-5.0527 ,2.0634 ,-8.3793>, 0.3000
<-7.0738 ,2.8887 ,-11.7310>, 0.1000
}
cone {
<-4.7307 ,2.6998 ,-8.3864>, 0.3000
<-6.6229 ,3.7797 ,-11.7410>, 0.1000
}
cone {
<-4.3291 ,3.2875 ,-8.3936>, 0.3000
<-6.0607 ,4.6025 ,-11.7510>, 0.1000
}
cone {
<-3.8551 ,3.8166 ,-8.4007>, 0.3000
<-5.3972 ,5.3433 ,-11.7609>, 0.1000
}
cone {
<-3.3173 ,4.2785 ,-8.4078>, 0.3000
<-4.6442 ,5.9899 ,-11.7709>, 0.1000
}
cone {
<-2.7249 ,4.6653 ,-8.4148>, 0.3000
<-3.8149 ,6.5315 ,-11.7808>, 0.1000
}
cone {
<-2.0884 ,4.9709 ,-8.4219>, 0.3000
<-2.9238 ,6.9593 ,-11.7907>, 0.1000
}
cone {
<-1.4188 ,5.1904 ,-8.4290>, 0.3000
<-1.9863 ,7.2665 ,-11.8005>, 0.1000
}
cone {
<-0.7277 ,5.3202 ,-8.4360>, 0.3000
<-1.0188 ,7.4483 ,-11.8104>, 0.1000
}
cone {
<-0.0271 ,5.3586 ,-8.4430>, 0.3000
<-0.0379 ,7.5021 ,-11.8202>, 0.1000
}
cone {
<0.6712 ,5.3053 ,-8.4500>, 0.3000
<0.9397 ,7.4275 ,-11.8300>, 0.1000
}
cone {
<1.3551 ,5.1617 ,-8.4570>, 0.3000
<1.8972 ,7.2263 ,-11.8398>, 0.1000
}
cone {
<2.0130 ,4.9304 ,-8.4640>, 0.3000
<2.8182 ,6.9025 ,-11.8496>, 0.1000
}
cone {
<2.6338 ,4.6158 ,-8.4710>, 0.3000
<3.6874 ,6.4622 ,-11.8593>, 0.1000
}
cone {
<3.2071 ,4.2237 ,-8.4779>, 0.3000
<4.4899 ,5.9132 ,-11.8691>, 0.1000
}
cone {
<3.7231 ,3.7611 ,-8.4848>, 0.3000
<5.2123 ,5.2656 ,-11.8788>, 0.1000
}
cone {
<4.1734 ,3.2362 ,-8.4918>, 0.3000
<5.8427 ,4.5307 ,-11.8885>, 0.1000
}
cone {
<4.5505 ,2.6582 ,-8.4987>, 0.3000
<6.3707 ,3.7215 ,-11.8981>, 0.1000
}
cone {
<4.8482 ,2.0372 ,-8.5055>, 0.3000
<6.7875 ,2.8521 ,-11.9078>, 0.1000
}
cone {
<5.0619 ,1.3841 ,-8.5124>, 0.3000
<7.0867 ,1.9377 ,-11.9174>, 0.1000
}
cone {
<5.1882 ,0.7100 ,-8.5193>, 0.3000
<7.2635 ,0.9940 ,-11.9270>, 0.1000
}
cone {
<5.2254 ,0.0267 ,-8.5261>, 0.3000
<7.3155 ,0.0374 ,-11.9366>, 0.1000
}
cone {
<5.1731 ,-0.6541 ,-8.5330>, 0.3000
<7.2423 ,-0.9158 ,-11.9462>, 0.1000
}
cone {
<5.0326 ,-1.3209 ,-8.5398>, 0.3000
<7.0457 ,-1.8493 ,-11.9557>, 0.1000
}
cone {
<4.8068 ,-1.9622 ,-8.5466>, 0.3000
<6.7295 ,-2.7471 ,-11.9652>, 0.1000
}
cone {
<4.4999 ,-2.5673 ,-8.5534>, 0.3000
<6.2998 ,-3.5942 ,-11.9747>, 0.1000
}
cone {
<4.1174 ,-3.1259 ,-8.5602>, 0.3000
<5.7643 ,-4.3762 ,-11.9842>, 0.1000
}
cone {
<3.6662 ,-3.6287 ,-8.5669>, 0.3000
<5.1327 ,-5.0801 ,-11.9937>, 0.1000
}
cone {
<3.1543 ,-4.0673 ,-8.5737>, 0.3000
<4.4161 ,-5.6942 ,-12.0031>, 0.1000
}
cone {
<2.5908 ,-4.4345 ,-8.5804>, 0.3000
<3.6271 ,-6.2083 ,-12.0125>, 0.1000
}
cone {
<1.9855 ,-4.7243 ,-8.5871>, 0.3000
<2.7797 ,-6.6141 ,-12.0219>, 0.1000
}
cone {
<1.3489 ,-4.9322 ,-8.5938>, 0.3000
<1.8885 ,-6.9051 ,-12.0313>, 0.1000
}
cone {
<0.6921 ,-5.0550 ,-8.6005>, 0.3000
<0.9689 ,-7.0769 ,-12.0407>, 0.1000
}
cone {
<0.0263 ,-5.0908 ,-8.6072>, 0.3000
<0.0369 ,-7.1271 ,-12.0500>, 0.1000
}
cone {
<-0.6369 ,-5.0395 ,-8.6138>, 0.3000
<-0.8917 ,-7.0553 ,-12.0593>, 0.1000
}
cone {
<-1.2864 ,-4.9023 ,-8.6205>, 0.3000
<-1.8009 ,-6.8633 ,-12.0686>, 0.1000
}
cone {
<-1.9110 ,-4.6821 ,-8.6271>, 0.3000
<-2.6753 ,-6.5549 ,-12.0779>, 0.1000
}
cone {
<-2.5001 ,-4.3828 ,-8.6337>, 0.3000
<-3.5002 ,-6.1359 ,-12.0872>, 0.1000
}
cone {
<-3.0439 ,-4.0100 ,-8.6403>, 0.3000
<-4.2615 ,-5.6139 ,-12.0964>, 0.1000
}
cone {
<-3.5333 ,-3.5703 ,-8.6469>, 0.3000
<-4.9467 ,-4.9984 ,-12.1056>, 0.1000
}
cone {
<-3.9602 ,-3.0717 ,-8.6534>, 0.3000
<-5.5442 ,-4.3003 ,-12.1148>, 0.1000
}
cone {
<-4.3174 ,-2.5228 ,-8.6600>, 0.3000
<-6.0444 ,-3.5319 ,-12.1240>, 0.1000
}
cone {
<-4.5993 ,-1.9333 ,-8.6665>, 0.3000
<-6.4390 ,-2.7066 ,-12.1331>, 0.1000
}
cone {
<-4.8013 ,-1.3135 ,-8.6731>, 0.3000
<-6.7219 ,-1.8388 ,-12.1423>, 0.1000
}
cone {
<-4.9205 ,-0.6740 ,-8.6796>, 0.3000
<-6.8886 ,-0.9436 ,-12.1514>, 0.1000
}
cone {
<-4.9550 ,-0.0260 ,-8.6861>, 0.3000
<-6.9370 ,-0.0363 ,-12.1605>, 0.1000
}
cone {
<-4.9047 ,0.6196 ,-8.6925>, 0.3000
<-6.8666 ,0.8674 ,-12.1695>, 0.1000
}
cone {
<-4.7709 ,1.2515 ,-8.6990>, 0.3000
<-6.6792 ,1.7522 ,-12.1786>, 0.1000
}
cone {
<-4.5561 ,1.8592 ,-8.7054>, 0.3000
<-6.3786 ,2.6029 ,-12.1876>, 0.1000
}
cone {
<-4.2646 ,2.4323 ,-8.7119>, 0.3000
<-5.9704 ,3.4053 ,-12.1966>, 0.1000
}
cone {
<-3.9016 ,2.9613 ,-8.7183>, 0.3000
<-5.4622 ,4.1458 ,-12.2056>, 0.1000
}
cone {
<-3.4736 ,3.4371 ,-8.7247>, 0.3000
<-4.8630 ,4.8120 ,-12.2146>, 0.1000
}
cone {
<-2.9882 ,3.8521 ,-8.7311>, 0.3000
<-4.1835 ,5.3929 ,-12.2235>, 0.1000
}
cone {
<-2.4541 ,4.1993 ,-8.7375>, 0.3000
<-3.4358 ,5.8790 ,-12.2325>, 0.1000
}
cone {
<-1.8806 ,4.4731 ,-8.7438>, 0.3000
<-2.6328 ,6.2624 ,-12.2414>, 0.1000
}
cone {
<-1.2777 ,4.6693 ,-8.7502>, 0.3000
<-1.7887 ,6.5370 ,-12.2502>, 0.1000
}
cone {
<-0.6557 ,4.7847 ,-8.7565>, 0.3000
<-0.9180 ,6.6986 ,-12.2591>, 0.1000
}
cone {
<-0.0255 ,4.8179 ,-8.7628>, 0.3000
<-0.0358 ,6.7451 ,-12.2679>, 0.1000
}
cone {
<0.6021 ,4.7687 ,-8.7691>, 0.3000
<0.8429 ,6.6761 ,-12.2768>, 0.1000
}
cone {
<1.2164 ,4.6382 ,-8.7754>, 0.3000
<1.7030 ,6.4935 ,-12.2856>, 0.1000
}
cone {
<1.8071 ,4.4291 ,-8.7817>, 0.3000
<2.5299 ,6.2007 ,-12.2943>, 0.1000
}
cone {
<2.3640 ,4.1454 ,-8.7879>, 0.3000
<3.3096 ,5.8035 ,-12.3031>, 0.1000
}
cone {
<2.8779 ,3.7922 ,-8.7942>, 0.3000
<4.0290 ,5.3091 ,-12.3118>, 0.1000
}
cone {
<3.3401 ,3.3759 ,-8.8004>, 0.3000
<4.6762 ,4.7263 ,-12.3205>, 0.1000
}
cone {
<3.7431 ,2.9040 ,-8.8066>, 0.3000
<5.2403 ,4.0657 ,-12.3292>, 0.1000
}
cone {
<4.0801 ,2.3848 ,-8.8128>, 0.3000
<5.7122 ,3.3388 ,-12.3379>, 0.1000
}
cone {
<4.3459 ,1.8274 ,-8.8190>, 0.3000
<6.0842 ,2.5584 ,-12.3465>, 0.1000
}
cone {
<4.5361 ,1.2415 ,-8.8251>, 0.3000
<6.3505 ,1.7381 ,-12.3552>, 0.1000
}
cone {
<4.6479 ,0.6373 ,-8.8313>, 0.3000
<6.5070 ,0.8922 ,-12.3638>, 0.1000
}
cone {
<4.6797 ,0.0251 ,-8.8374>, 0.3000
<6.5516 ,0.0352 ,-12.3724>, 0.1000
}
cone {
<4.6315 ,-0.5845 ,-8.8435>, 0.3000
<6.4841 ,-0.8182 ,-12.3809>, 0.1000
}
cone {
<4.5044 ,-1.1810 ,-8.8496>, 0.3000
<6.3061 ,-1.6534 ,-12.3895>, 0.1000
}
cone {
<4.3010 ,-1.7545 ,-8.8557>, 0.3000
<6.0213 ,-2.4562 ,-12.3980>, 0.1000
}
cone {
<4.0251 ,-2.2951 ,-8.8618>, 0.3000
<5.6351 ,-3.2131 ,-12.4065>, 0.1000
}
cone {
<3.6819 ,-2.7938 ,-8.8678>, 0.3000
<5.1546 ,-3.9113 ,-12.4150>, 0.1000
}
cone {
<3.2775 ,-3.2423 ,-8.8739>, 0.3000
<4.5885 ,-4.5392 ,-12.4234>, 0.1000
}
cone {
<2.8191 ,-3.6331 ,-8.8799>, 0.3000
<3.9468 ,-5.0864 ,-12.4319>, 0.1000
}
cone {
<2.3149 ,-3.9600 ,-8.8859>, 0.3000
<3.2409 ,-5.5440 ,-12.4403>, 0.1000
}
cone {
<1.7738 ,-4.2175 ,-8.8919>, 0.3000
<2.4833 ,-5.9045 ,-12.4487>, 0.1000
}
cone {
<1.2050 ,-4.4017 ,-8.8979>, 0.3000
<1.6871 ,-6.1624 ,-12.4571>, 0.1000
}
cone {
<0.6186 ,-4.5098 ,-8.9039>, 0.3000
<0.8661 ,-6.3137 ,-12.4654>, 0.1000
}
cone {
<0.0247 ,-4.5403 ,-8.9098>, 0.3000
<0.0345 ,-6.3565 ,-12.4737>, 0.1000
}
cone {
<-0.5667 ,-4.4931 ,-8.9158>, 0.3000
<-0.7934 ,-6.2904 ,-12.4821>, 0.1000
}
cone {
<-1.1453 ,-4.3694 ,-8.9217>, 0.3000
<-1.6035 ,-6.1172 ,-12.4903>, 0.1000
}
cone {
<-1.7014 ,-4.1717 ,-8.9276>, 0.3000
<-2.3820 ,-5.8404 ,-12.4986>, 0.1000
}
cone {
<-2.2256 ,-3.9038 ,-8.9335>, 0.3000
<-3.1158 ,-5.4654 ,-12.5069>, 0.1000
}
cone {
<-2.7090 ,-3.5706 ,-8.9393>, 0.3000
<-3.7926 ,-4.9989 ,-12.5151>, 0.1000
}
cone {
<-3.1437 ,-3.1782 ,-8.9452>, 0.3000
<-4.4011 ,-4.4494 ,-12.5233>, 0.1000
}
cone {
<-3.5223 ,-2.7335 ,-8.9510>, 0.3000
<-4.9313 ,-3.8269 ,-12.5315>, 0.1000
}
cone {
<-3.8389 ,-2.2445 ,-8.9569>, 0.3000
<-5.3744 ,-3.1422 ,-12.5396>, 0.1000
}
cone {
<-4.0882 ,-1.7197 ,-8.9627>, 0.3000
<-5.7234 ,-2.4075 ,-12.5478>, 0.1000
}
cone {
<-4.2663 ,-1.1683 ,-8.9685>, 0.3000
<-5.9728 ,-1.6356 ,-12.5559>, 0.1000
}
cone {
<-4.3707 ,-0.5998 ,-8.9743>, 0.3000
<-6.1189 ,-0.8398 ,-12.5640>, 0.1000
}
cone {
<-4.3998 ,-0.0242 ,-8.9800>, 0.3000
<-6.1597 ,-0.0338 ,-12.5720>, 0.1000
}
cone {
<-4.3537 ,0.5488 ,-8.9858>, 0.3000
<-6.0951 ,0.7684 ,-12.5801>, 0.1000
}
cone {
<-4.2334 ,1.1094 ,-8.9915>, 0.3000
<-5.9268 ,1.5532 ,-12.5881>, 0.1000
}
cone {
<-4.0415 ,1.6480 ,-8.9972>, 0.3000
<-5.6581 ,2.3072 ,-12.5961>, 0.1000
}
cone {
<-3.7816 ,2.1556 ,-9.0029>, 0.3000
<-5.2942 ,3.0178 ,-12.6041>, 0.1000
}
cone {
<-3.4585 ,2.6236 ,-9.0086>, 0.3000
<-4.8419 ,3.6730 ,-12.6121>, 0.1000
}
cone {
<-3.0781 ,3.0443 ,-9.0143>, 0.3000
<-4.3093 ,4.2620 ,-12.6200>, 0.1000
}
cone {
<-2.6472 ,3.4107 ,-9.0200>, 0.3000
<-3.7061 ,4.7749 ,-12.6280>, 0.1000
}
cone {
<-2.1734 ,3.7168 ,-9.0256>, 0.3000
<-3.0428 ,5.2035 ,-12.6359>, 0.1000
}
cone {
<-1.6651 ,3.9578 ,-9.0312>, 0.3000
<-2.3312 ,5.5409 ,-12.6437>, 0.1000
}
cone {
<-1.1312 ,4.1299 ,-9.0369>, 0.3000
<-1.5836 ,5.7818 ,-12.6516>, 0.1000
}
cone {
<-0.5809 ,4.2304 ,-9.0425>, 0.3000
<-0.8132 ,5.9226 ,-12.6594>, 0.1000
}
cone {
<-0.0237 ,4.2582 ,-9.0480>, 0.3000
<-0.0331 ,5.9615 ,-12.6672>, 0.1000
}
cone {
<0.5308 ,4.2131 ,-9.0536>, 0.3000
<0.7432 ,5.8984 ,-12.6750>, 0.1000
}
cone {
<1.0732 ,4.0963 ,-9.0592>, 0.3000
<1.5025 ,5.7349 ,-12.6828>, 0.1000
}
cone {
<1.5942 ,3.9102 ,-9.0647>, 0.3000
<2.2319 ,5.4743 ,-12.6906>, 0.1000
}
cone {
<2.0851 ,3.6584 ,-9.0702>, 0.3000
<2.9191 ,5.1218 ,-12.6983>, 0.1000
}
cone {
<2.5375 ,3.3455 ,-9.0757>, 0.3000
<3.5526 ,4.6837 ,-12.7060>, 0.1000
}
cone {
<2.9441 ,2.9772 ,-9.0812>, 0.3000
<4.1218 ,4.1681 ,-12.7137>, 0.1000
}
cone {
<3.2982 ,2.5602 ,-9.0867>, 0.3000
<4.6174 ,3.5843 ,-12.7213>, 0.1000
}
cone {
<3.5938 ,2.1018 ,-9.0921>, 0.3000
<5.0314 ,2.9425 ,-12.7290>, 0.1000
}
cone {
<3.8264 ,1.6101 ,-9.0976>, 0.3000
<5.3570 ,2.2542 ,-12.7366>, 0.1000
}
cone {
<3.9924 ,1.0938 ,-9.1030>, 0.3000
<5.5893 ,1.5313 ,-12.7442>, 0.1000
}
cone {
<4.0892 ,0.5617 ,-9.1084>, 0.3000
<5.7249 ,0.7864 ,-12.7518>, 0.1000
}
cone {
<4.1156 ,0.0231 ,-9.1138>, 0.3000
<5.7618 ,0.0324 ,-12.7593>, 0.1000
}
cone {
<4.0716 ,-0.5127 ,-9.1192>, 0.3000
<5.7002 ,-0.7178 ,-12.7669>, 0.1000
}
cone {
<3.9583 ,-1.0368 ,-9.1245>, 0.3000
<5.5416 ,-1.4515 ,-12.7744>, 0.1000
}
cone {
<3.7780 ,-1.5400 ,-9.1299>, 0.3000
<5.2892 ,-2.1560 ,-12.7818>, 0.1000
}
cone {
<3.5343 ,-2.0140 ,-9.1352>, 0.3000
<4.9480 ,-2.8197 ,-12.7893>, 0.1000
}
cone {
<3.2317 ,-2.4509 ,-9.1405>, 0.3000
<4.5243 ,-3.4312 ,-12.7968>, 0.1000
}
cone {
<2.8756 ,-2.8433 ,-9.1458>, 0.3000
<4.0259 ,-3.9806 ,-12.8042>, 0.1000
}
cone {
<2.4726 ,-3.1848 ,-9.1511>, 0.3000
<3.4616 ,-4.4588 ,-12.8116>, 0.1000
}
cone {
<2.0297 ,-3.4700 ,-9.1564>, 0.3000
<2.8415 ,-4.8580 ,-12.8190>, 0.1000
}
cone {
<1.5548 ,-3.6942 ,-9.1617>, 0.3000
<2.1767 ,-5.1718 ,-12.8263>, 0.1000
}
cone {
<1.0561 ,-3.8539 ,-9.1669>, 0.3000
<1.4786 ,-5.3955 ,-12.8336>, 0.1000
}
cone {
<0.5424 ,-3.9469 ,-9.1721>, 0.3000
<0.7594 ,-5.5257 ,-12.8410>, 0.1000
}
cone {
<0.0226 ,-3.9719 ,-9.1773>, 0.3000
<0.0316 ,-5.5607 ,-12.8482>, 0.1000
}
cone {
<-0.4945 ,-3.9290 ,-9.1825>, 0.3000
<-0.6924 ,-5.5006 ,-12.8555>, 0.1000
}
cone {
<-1.0001 ,-3.8192 ,-9.1877>, 0.3000
<-1.4001 ,-5.3469 ,-12.8628>, 0.1000
}
cone {
<-1.4855 ,-3.6449 ,-9.1928>, 0.3000
<-2.0797 ,-5.1028 ,-12.8700>, 0.1000
}
cone {
<-1.9425 ,-3.4093 ,-9.1980>, 0.3000
<-2.7195 ,-4.7731 ,-12.8772>, 0.1000
}
cone {
<-2.3636 ,-3.1170 ,-9.2031>, 0.3000
<-3.3091 ,-4.3638 ,-12.8844>, 0.1000
}
cone {
<-2.7418 ,-2.7733 ,-9.2082>, 0.3000
<-3.8385 ,-3.8826 ,-12.8915>, 0.1000
}
cone {
<-3.0708 ,-2.3843 ,-9.2133>, 0.3000
<-4.2991 ,-3.3380 ,-12.8987>, 0.1000
}
cone {
<-3.3453 ,-1.9570 ,-9.2184>, 0.3000
<-4.6834 ,-2.7398 ,-12.9058>, 0.1000
}
cone {
<-3.5610 ,-1.4990 ,-9.2235>, 0.3000
<-4.9854 ,-2.0986 ,-12.9129>, 0.1000
}
cone {
<-3.7145 ,-1.0182 ,-9.2285>, 0.3000
<-5.2003 ,-1.4254 ,-12.9199>, 0.1000
}
cone {
<-3.8037 ,-0.5230 ,-9.2336>, 0.3000
<-5.3251 ,-0.7322 ,-12.9270>, 0.1000
}
cone {
<-3.8273 ,-0.0220 ,-9.2386>, 0.3000
<-5.3582 ,-0.0308 ,-12.9340>, 0.1000
}
cone {
<-3.7854 ,0.4762 ,-9.2436>, 0.3000
<-5.2996 ,0.6667 ,-12.9410>, 0.1000
}
cone {
<-3.6792 ,0.9632 ,-9.2486>, 0.3000
<-5.1509 ,1.3484 ,-12.9480>, 0.1000
}
cone {
<-3.5108 ,1.4306 ,-9.2535>, 0.3000
<-4.9151 ,2.0028 ,-12.9549>, 0.1000
}
cone {
<-3.2835 ,1.8706 ,-9.2585>, 0.3000
<-4.5969 ,2.6188 ,-12.9619>, 0.1000
}
cone {
<-3.0016 ,2.2758 ,-9.2634>, 0.3000
<-4.2022 ,3.1861 ,-12.9688>, 0.1000
}
cone {
<-2.6703 ,2.6396 ,-9.2683>, 0.3000
<-3.7384 ,3.6954 ,-12.9757>, 0.1000
}
cone {
<-2.2955 ,2.9559 ,-9.2733>, 0.3000
<-3.2136 ,4.1383 ,-12.9826>, 0.1000
}
cone {
<-1.8839 ,3.2198 ,-9.2781>, 0.3000
<-2.6374 ,4.5077 ,-12.9894>, 0.1000
}
cone {
<-1.4428 ,3.4269 ,-9.2830>, 0.3000
<-2.0199 ,4.7977 ,-12.9962>, 0.1000
}
cone {
<-0.9800 ,3.5742 ,-9.2879>, 0.3000
<-1.3719 ,5.0039 ,-13.0030>, 0.1000
}
cone {
<-0.5034 ,3.6595 ,-9.2927>, 0.3000
<-0.7048 ,5.1233 ,-13.0098>, 0.1000
}
cone {
<-0.0214 ,3.6817 ,-9.2976>, 0.3000
<-0.0299 ,5.1544 ,-13.0166>, 0.1000
}
cone {
<0.4578 ,3.6409 ,-9.3024>, 0.3000
<0.6409 ,5.0973 ,-13.0233>, 0.1000
}
cone {
<0.9260 ,3.5383 ,-9.3072>, 0.3000
<1.2964 ,4.9536 ,-13.0300>, 0.1000
}
cone {
<1.3753 ,3.3758 ,-9.3119>, 0.3000
<1.9255 ,4.7262 ,-13.0367>, 0.1000
}
cone {
<1.7982 ,3.1569 ,-9.3167>, 0.3000
<2.5174 ,4.4196 ,-13.0434>, 0.1000
}
cone {
<2.1874 ,2.8854 ,-9.3214>, 0.3000
<3.0624 ,4.0396 ,-13.0500>, 0.1000
}
cone {
<2.5368 ,2.5666 ,-9.3262>, 0.3000
<3.5515 ,3.5932 ,-13.0567>, 0.1000
}
cone {
<2.8404 ,2.2060 ,-9.3309>, 0.3000
<3.9766 ,3.0884 ,-13.0633>, 0.1000
}
cone {
<3.0935 ,1.8102 ,-9.3356>, 0.3000
<4.3309 ,2.5343 ,-13.0698>, 0.1000
}
cone {
<3.2920 ,1.3863 ,-9.3403>, 0.3000
<4.6089 ,1.9408 ,-13.0764>, 0.1000
}
cone {
<3.4330 ,0.9415 ,-9.3449>, 0.3000
<4.8062 ,1.3181 ,-13.0829>, 0.1000
}
cone {
<3.5144 ,0.4837 ,-9.3496>, 0.3000
<4.9202 ,0.6771 ,-13.0894>, 0.1000
}
cone {
<3.5352 ,0.0208 ,-9.3542>, 0.3000
<4.9493 ,0.0291 ,-13.0959>, 0.1000
}
cone {
<3.4956 ,-0.4393 ,-9.3589>, 0.3000
<4.8938 ,-0.6150 ,-13.1024>, 0.1000
}
cone {
<3.3965 ,-0.8887 ,-9.3635>, 0.3000
<4.7550 ,-1.2442 ,-13.1088>, 0.1000
}
cone {
<3.2401 ,-1.3198 ,-9.3680>, 0.3000
<4.5361 ,-1.8477 ,-13.1153>, 0.1000
}
cone {
<3.0294 ,-1.7253 ,-9.3726>, 0.3000
<4.2412 ,-2.4154 ,-13.1217>, 0.1000
}
cone {
<2.7685 ,-2.0985 ,-9.3772>, 0.3000
<3.8760 ,-2.9380 ,-13.1280>, 0.1000
}
cone {
<2.4622 ,-2.4333 ,-9.3817>, 0.3000
<3.4471 ,-3.4066 ,-13.1344>, 0.1000
}
cone {
<2.1160 ,-2.7242 ,-9.3862>, 0.3000
<2.9624 ,-3.8138 ,-13.1407>, 0.1000
}
cone {
<1.7362 ,-2.9664 ,-9.3907>, 0.3000
<2.4306 ,-4.1530 ,-13.1470>, 0.1000
}
cone {
<1.3293 ,-3.1563 ,-9.3952>, 0.3000
<1.8611 ,-4.4189 ,-13.1533>, 0.1000
}
cone {
<0.9028 ,-3.2910 ,-9.3997>, 0.3000
<1.2639 ,-4.6074 ,-13.1596>, 0.1000
}
cone {
<0.4638 ,-3.3685 ,-9.4042>, 0.3000
<0.6493 ,-4.7159 ,-13.1658>, 0.1000
}
cone {
<0.0201 ,-3.3879 ,-9.4086>, 0.3000
<0.0282 ,-4.7430 ,-13.1720>, 0.1000
}
cone {
<-0.4207 ,-3.3493 ,-9.4130>, 0.3000
<-0.5890 ,-4.6890 ,-13.1782>, 0.1000
}
cone {
<-0.8511 ,-3.2538 ,-9.4174>, 0.3000
<-1.1916 ,-4.5553 ,-13.1844>, 0.1000
}
cone {
<-1.2639 ,-3.1035 ,-9.4218>, 0.3000
<-1.7695 ,-4.3449 ,-13.1906>, 0.1000
}
cone {
<-1.6521 ,-2.9012 ,-9.4262>, 0.3000
<-2.3129 ,-4.0617 ,-13.1967>, 0.1000
}
cone {
<-2.0091 ,-2.6510 ,-9.4306>, 0.3000
<-2.8128 ,-3.7113 ,-13.2028>, 0.1000
}
cone {
<-2.3293 ,-2.3573 ,-9.4349>, 0.3000
<-3.2610 ,-3.3002 ,-13.2089>, 0.1000
}
cone {
<-2.6073 ,-2.0255 ,-9.4393>, 0.3000
<-3.6502 ,-2.8357 ,-13.2150>, 0.1000
}
cone {
<-2.8387 ,-1.6616 ,-9.4436>, 0.3000
<-3.9741 ,-2.3263 ,-13.2210>, 0.1000
}
cone {
<-3.0199 ,-1.2721 ,-9.4479>, 0.3000
<-4.2278 ,-1.7809 ,-13.2270>, 0.1000
}
cone {
<-3.1481 ,-0.8638 ,-9.4521>, 0.3000
<-4.4074 ,-1.2093 ,-13.2330>, 0.1000
}
cone {
<-3.2217 ,-0.4438 ,-9.4564>, 0.3000
<-4.5104 ,-0.6213 ,-13.2390>, 0.1000
}
cone {
<-3.2397 ,-0.0194 ,-9.4607>, 0.3000
<-4.5356 ,-0.0272 ,-13.2449>, 0.1000
}
cone {
<-3.2022 ,0.4020 ,-9.4649>, 0.3000
<-4.4831 ,0.5628 ,-13.2508>, 0.1000
}
cone {
<-3.1104 ,0.8134 ,-9.4691>, 0.3000
<-4.3545 ,1.1388 ,-13.2568>, 0.1000
}
cone {
<-2.9661 ,1.2077 ,-9.4733>, 0.3000
<-4.1525 ,1.6908 ,-13.2626>, 0.1000
}
cone {
<-2.7723 ,1.5784 ,-9.4775>, 0.3000
<-3.8812 ,2.2098 ,-13.2685>, 0.1000
}
cone {
<-2.5327 ,1.9193 ,-9.4817>, 0.3000
<-3.5458 ,2.6870 ,-13.2743>, 0.1000
}
cone {
<-2.2517 ,2.2247 ,-9.4858>, 0.3000
<-3.1524 ,3.1146 ,-13.2801>, 0.1000
}
cone {
<-1.9344 ,2.4897 ,-9.4899>, 0.3000
<-2.7082 ,3.4856 ,-13.2859>, 0.1000
}
cone {
<-1.5867 ,2.7102 ,-9.4941>, 0.3000
<-2.2213 ,3.7943 ,-13.2917>, 0.1000
}
cone {
<-1.2145 ,2.8827 ,-9.4982>, 0.3000
<-1.7003 ,4.0357 ,-13.2974>, 0.1000
}
cone {
<-0.8246 ,3.0045 ,-9.5023>, 0.3000
<-1.1544 ,4.2063 ,-13.3032>, 0.1000
}
cone {
<-0.4237 ,3.0741 ,-9.5063>, 0.3000
<-0.5932 ,4.3038 ,-13.3089>, 0.1000
}
cone {
<-0.0187 ,3.0907 ,-9.5104>, 0.3000
<-0.0262 ,4.3270 ,-13.3145>, 0.1000
}
cone {
<0.3833 ,3.0543 ,-9.5144>, 0.3000
<0.5366 ,4.2761 ,-13.3202>, 0.1000
}
cone {
<0.7755 ,2.9661 ,-9.5184>, 0.3000
<1.0857 ,4.1526 ,-13.3258>, 0.1000
}
cone {
<1.1513 ,2.8280 ,-9.5224>, 0.3000
<1.6118 ,3.9592 ,-13.3314>, 0.1000
}
cone {
<1.5044 ,2.6427 ,-9.5264>, 0.3000
<2.1062 ,3.6998 ,-13.3370>, 0.1000
}
cone {
<1.8289 ,2.4138 ,-9.5304>, 0.3000
<2.5605 ,3.3793 ,-13.3426>, 0.1000
}
cone {
<2.1196 ,2.1456 ,-9.5344>, 0.3000
<2.9674 ,3.0038 ,-13.3481>, 0.1000
}
cone {
<2.3716 ,1.8429 ,-9.5383>, 0.3000
<3.3203 ,2.5801 ,-13.3536>, 0.1000
}
cone {
<2.5811 ,1.5113 ,-9.5422>, 0.3000
<3.6135 ,2.1158 ,-13.3591>, 0.1000
}
cone {
<2.7448 ,1.1566 ,-9.5461>, 0.3000
<3.8427 ,1.6193 ,-13.3646>, 0.1000
}
cone {
<2.8602 ,0.7852 ,-9.5500>, 0.3000
<4.0043 ,1.0992 ,-13.3700>, 0.1000
}
cone {
<2.9258 ,0.4034 ,-9.5539>, 0.3000
<4.0961 ,0.5648 ,-13.3754>, 0.1000
}
cone {
<2.9409 ,0.0180 ,-9.5577>, 0.3000
<4.1173 ,0.0252 ,-13.3808>, 0.1000
}
cone {
<2.9057 ,-0.3644 ,-9.5616>, 0.3000
<4.0680 ,-0.5102 ,-13.3862>, 0.1000
}
cone {
<2.8212 ,-0.7374 ,-9.5654>, 0.3000
<3.9496 ,-1.0324 ,-13.3916>, 0.1000
}
cone {
<2.6892 ,-1.0946 ,-9.5692>, 0.3000
<3.7649 ,-1.5324 ,-13.3969>, 0.1000
}
cone {
<2.5124 ,-1.4300 ,-9.5730>, 0.3000
<3.5174 ,-2.0020 ,-13.4022>, 0.1000
}
cone {
<2.2943 ,-1.7382 ,-9.5768>, 0.3000
<3.2120 ,-2.4334 ,-13.4075>, 0.1000
}
cone {
<2.0389 ,-2.0139 ,-9.5806>, 0.3000
<2.8545 ,-2.8195 ,-13.4128>, 0.1000
}
cone {
<1.7509 ,-2.2529 ,-9.5843>, 0.3000
<2.4513 ,-3.1541 ,-13.4180>, 0.1000
}
cone {
<1.4355 ,-2.4513 ,-9.5880>, 0.3000
<2.0097 ,-3.4319 ,-13.4232>, 0.1000
}
cone {
<1.0984 ,-2.6062 ,-9.5917>, 0.3000
<1.5378 ,-3.6486 ,-13.4284>, 0.1000
}
cone {
<0.7455 ,-2.7151 ,-9.5954>, 0.3000
<1.0437 ,-3.8012 ,-13.4336>, 0.1000
}
cone {
<0.3831 ,-2.7768 ,-9.5991>, 0.3000
<0.5363 ,-3.8875 ,-13.4387>, 0.1000
}
cone {
<0.0173 ,-2.7905 ,-9.6028>, 0.3000
<0.0242 ,-3.9066 ,-13.4439>, 0.1000
}
cone {
<-0.3455 ,-2.7564 ,-9.6064>, 0.3000
<-0.4837 ,-3.8589 ,-13.4490>, 0.1000
}
cone {
<-0.6991 ,-2.6755 ,-9.6100>, 0.3000
<-0.9788 ,-3.7457 ,-13.4541>, 0.1000
}
cone {
<-1.0376 ,-2.5497 ,-9.6136>, 0.3000
<-1.4527 ,-3.5696 ,-13.4591>, 0.1000
}
cone {
<-1.3553 ,-2.3815 ,-9.6172>, 0.3000
<-1.8975 ,-3.3342 ,-13.4641>, 0.1000
}
cone {
<-1.6470 ,-2.1742 ,-9.6208>, 0.3000
<-2.3058 ,-3.0439 ,-13.4691>, 0.1000
}
cone {
<-1.9078 ,-1.9317 ,-9.6244>, 0.3000
<-2.6709 ,-2.7044 ,-13.4741>, 0.1000
}
cone {
<-2.1337 ,-1.6584 ,-9.6279>, 0.3000
<-2.9871 ,-2.3218 ,-13.4791>, 0.1000
}
cone {
<-2.3210 ,-1.3594 ,-9.6315>, 0.3000
<-3.2494 ,-1.9031 ,-13.4840>, 0.1000
}
cone {
<-2.4670 ,-1.0399 ,-9.6350>, 0.3000
<-3.4537 ,-1.4559 ,-13.4890>, 0.1000
}
cone {
<-2.5694 ,-0.7057 ,-9.6385>, 0.3000
<-3.5972 ,-0.9880 ,-13.4939>, 0.1000
}
cone {
<-2.6271 ,-0.3626 ,-9.6419>, 0.3000
<-3.6779 ,-0.5076 ,-13.4987>, 0.1000
}
cone {
<-2.6393 ,-0.0165 ,-9.6454>, 0.3000
<-3.6950 ,-0.0231 ,-13.5036>, 0.1000
}
cone {
<-2.6063 ,0.3265 ,-9.6489>, 0.3000
<-3.6489 ,0.4572 ,-13.5084>, 0.1000
}
cone {
<-2.5292 ,0.6607 ,-9.6523>, 0.3000
<-3.5409 ,0.9250 ,-13.5132>, 0.1000
}
cone {
<-2.4096 ,0.9804 ,-9.6557>, 0.3000
<-3.3735 ,1.3726 ,-13.5180>, 0.1000
}
cone {
<-2.2500 ,1.2803 ,-9.6591>, 0.3000
<-3.1501 ,1.7924 ,-13.5227>, 0.1000
}
cone {
<-2.0536 ,1.5554 ,-9.6625>, 0.3000
<-2.8750 ,2.1776 ,-13.5275>, 0.1000
}
cone {
<-1.8240 ,1.8012 ,-9.6658>, 0.3000
<-2.5536 ,2.5217 ,-13.5322>, 0.1000
}
cone {
<-1.5656 ,2.0139 ,-9.6692>, 0.3000
<-2.1918 ,2.8195 ,-13.5369>, 0.1000
}
cone {
<-1.2829 ,2.1901 ,-9.6725>, 0.3000
<-1.7961 ,3.0661 ,-13.5415>, 0.1000
}
cone {
<-0.9812 ,2.3271 ,-9.6758>, 0.3000
<-1.3736 ,3.2580 ,-13.5462>, 0.1000
}
cone {
<-0.6657 ,2.4231 ,-9.6791>, 0.3000
<-0.9319 ,3.3923 ,-13.5508>, 0.1000
}
cone {
<-0.3420 ,2.4767 ,-9.6824>, 0.3000
<-0.4788 ,3.4674 ,-13.5554>, 0.1000
}
cone {
<-0.0157 ,2.4875 ,-9.6857>, 0.3000
<-0.0220 ,3.4824 ,-13.5599>, 0.1000
}
cone {
<0.3075 ,2.4557 ,-9.6889>, 0.3000
<0.4305 ,3.4379 ,-13.5645>, 0.1000
}
cone {
<0.6222 ,2.3822 ,-9.6922>, 0.3000
<0.8711 ,3.3351 ,-13.5690>, 0.1000
}
cone {
<0.9230 ,2.2689 ,-9.6954>, 0.3000
<1.2922 ,3.1765 ,-13.5735>, 0.1000
}
cone {
<1.2050 ,2.1180 ,-9.6986>, 0.3000
<1.6870 ,2.9652 ,-13.5780>, 0.1000
}
cone {
<1.4634 ,1.9325 ,-9.7017>, 0.3000
<2.0488 ,2.7055 ,-13.5824>, 0.1000
}
cone {
<1.6942 ,1.7159 ,-9.7049>, 0.3000
<2.3719 ,2.4022 ,-13.5869>, 0.1000
}
cone {
<1.8937 ,1.4723 ,-9.7081>, 0.3000
<2.6511 ,2.0612 ,-13.5913>, 0.1000
}
cone {
<2.0587 ,1.2061 ,-9.7112>, 0.3000
<2.8821 ,1.6885 ,-13.5957>, 0.1000
}
cone {
<2.1868 ,0.9221 ,-9.7143>, 0.3000
<3.0615 ,1.2910 ,-13.6000>, 0.1000
}
cone {
<2.2762 ,0.6255 ,-9.7174>, 0.3000
<3.1866 ,0.8756 ,-13.6044>, 0.1000
}
cone {
<2.3257 ,0.3213 ,-9.7205>, 0.3000
<3.2560 ,0.4498 ,-13.6087>, 0.1000
}
cone {
<2.3350 ,0.0149 ,-9.7236>, 0.3000
<3.2690 ,0.0209 ,-13.6130>, 0.1000
}
cone {
<2.3044 ,-0.2884 ,-9.7266>, 0.3000
<3.2261 ,-0.4038 ,-13.6172>, 0.1000
}
cone {
<2.2347 ,-0.5835 ,-9.7296>, 0.3000
<3.1286 ,-0.8169 ,-13.6215>, 0.1000
}
cone {
<2.1276 ,-0.8654 ,-9.7326>, 0.3000
<2.9787 ,-1.2115 ,-13.6257>, 0.1000
}
cone {
<1.9854 ,-1.1294 ,-9.7356>, 0.3000
<2.7795 ,-1.5811 ,-13.6299>, 0.1000
}
cone {
<1.8108 ,-1.3712 ,-9.7386>, 0.3000
<2.5352 ,-1.9196 ,-13.6341>, 0.1000
}
cone {
<1.6073 ,-1.5868 ,-9.7416>, 0.3000
<2.2502 ,-2.2216 ,-13.6382>, 0.1000
}
cone {
<1.3786 ,-1.7730 ,-9.7445>, 0.3000
<1.9301 ,-2.4822 ,-13.6424>, 0.1000
}
cone {
<1.1290 ,-1.9267 ,-9.7475>, 0.3000
<1.5805 ,-2.6974 ,-13.6465>, 0.1000
}
cone {
<0.8629 ,-2.0458 ,-9.7504>, 0.3000
<1.2080 ,-2.8642 ,-13.6505>, 0.1000
}
cone {
<0.5851 ,-2.1287 ,-9.7533>, 0.3000
<0.8191 ,-2.9801 ,-13.6546>, 0.1000
}
cone {
<0.3005 ,-2.1742 ,-9.7562>, 0.3000
<0.4207 ,-3.0438 ,-13.6586>, 0.1000
}
cone {
<0.0141 ,-2.1820 ,-9.7590>, 0.3000
<0.0197 ,-3.0548 ,-13.6626>, 0.1000
}
cone {
<-0.2693 ,-2.1525 ,-9.7619>, 0.3000
<-0.3770 ,-3.0135 ,-13.6666>, 0.1000
}
cone {
<-0.5447 ,-2.0866 ,-9.7647>, 0.3000
<-0.7626 ,-2.9212 ,-13.6706>, 0.1000
}
cone {
<-0.8076 ,-1.9858 ,-9.7675>, 0.3000
<-1.1306 ,-2.7801 ,-13.6745>, 0.1000
}
cone {
<-1.0535 ,-1.8523 ,-9.7703>, 0.3000
<-1.4749 ,-2.5932 ,-13.6784>, 0.1000
}
cone {
<-1.2785 ,-1.6887 ,-9.7731>, 0.3000
<-1.7900 ,-2.3642 ,-13.6823>, 0.1000
}
cone {
<-1.4790 ,-1.4983 ,-9.7759>, 0.3000
<-2.0707 ,-2.0976 ,-13.6862>, 0.1000
}
cone {
<-1.6518 ,-1.2846 ,-9.7786>, 0.3000
<-2.3126 ,-1.7984 ,-13.6901>, 0.1000
}
cone {
<-1.7943 ,-1.0515 ,-9.7813>, 0.3000
<-2.5121 ,-1.4722 ,-13.6939>, 0.1000
}
cone {
<-1.9044 ,-0.8034 ,-9.7841>, 0.3000
<-2.6662 ,-1.1247 ,-13.6977>, 0.1000
}
cone {
<-1.9806 ,-0.5445 ,-9.7868>, 0.3000
<-2.7729 ,-0.7623 ,-13.7015>, 0.1000
}
cone {
<-2.0221 ,-0.2796 ,-9.7894>, 0.3000
<-2.8309 ,-0.3914 ,-13.7052>, 0.1000
}
cone {
<-2.0285 ,-0.0132 ,-9.7921>, 0.3000
<-2.8399 ,-0.0185 ,-13.7089>, 0.1000
}
cone {
<-2.0001 ,0.2501 ,-9.7947>, 0.3000
<-2.8002 ,0.3501 ,-13.7126>, 0.1000
}
cone {
<-1.9380 ,0.5058 ,-9.7974>, 0.3000
<-2.7131 ,0.7081 ,-13.7163>, 0.1000
}
cone {
<-1.8435 ,0.7495 ,-9.8000>, 0.3000
<-2.5809 ,1.0494 ,-13.7200>, 0.1000
}
cone {
<-1.7187 ,0.9774 ,-9.8026>, 0.3000
<-2.4062 ,1.3684 ,-13.7236>, 0.1000
}
cone {
<-1.5662 ,1.1856 ,-9.8052>, 0.3000
<-2.1927 ,1.6599 ,-13.7272>, 0.1000
}
cone {
<-1.3889 ,1.3709 ,-9.8077>, 0.3000
<-1.9445 ,1.9193 ,-13.7308>, 0.1000
}
cone {
<-1.1902 ,1.5303 ,-9.8103>, 0.3000
<-1.6663 ,2.1424 ,-13.7344>, 0.1000
}
cone {
<-0.9738 ,1.6615 ,-9.8128>, 0.3000
<-1.3634 ,2.3261 ,-13.7379>, 0.1000
}
cone {
<-0.7436 ,1.7626 ,-9.8153>, 0.3000
<-1.0411 ,2.4676 ,-13.7414>, 0.1000
}
cone {
<-0.5038 ,1.8322 ,-9.8178>, 0.3000
<-0.7054 ,2.5650 ,-13.7449>, 0.1000
}
cone {
<-0.2586 ,1.8695 ,-9.8203>, 0.3000
<-0.3621 ,2.6173 ,-13.7484>, 0.1000
}
cone {
<-0.0123 ,1.8744 ,-9.8227>, 0.3000
<-0.0172 ,2.6242 ,-13.7518>, 0.1000
}
cone {
<0.2308 ,1.8472 ,-9.8252>, 0.3000
<0.3232 ,2.5861 ,-13.7553>, 0.1000
}
cone {
<0.4667 ,1.7889 ,-9.8276>, 0.3000
<0.6534 ,2.5044 ,-13.7587>, 0.1000
}
cone {
<0.6914 ,1.7007 ,-9.8300>, 0.3000
<0.9679 ,2.3810 ,-13.7620>, 0.1000
}
cone {
<0.9011 ,1.5847 ,-9.8324>, 0.3000
<1.2615 ,2.2186 ,-13.7654>, 0.1000
}
cone {
<1.0924 ,1.4433 ,-9.8348>, 0.3000
<1.5294 ,2.0206 ,-13.7687>, 0.1000
}
cone {
<1.2624 ,1.2792 ,-9.8372>, 0.3000
<1.7674 ,1.7909 ,-13.7720>, 0.1000
}
cone {
<1.4084 ,1.0956 ,-9.8395>, 0.3000
<1.9718 ,1.5338 ,-13.7753>, 0.1000
}
cone {
<1.5283 ,0.8959 ,-9.8418>, 0.3000
<2.1396 ,1.2542 ,-13.7786>, 0.1000
}
cone {
<1.6203 ,0.6837 ,-9.8441>, 0.3000
<2.2684 ,0.9572 ,-13.7818>, 0.1000
}
cone {
<1.6832 ,0.4630 ,-9.8464>, 0.3000
<2.3565 ,0.6482 ,-13.7850>, 0.1000
}
cone {
<1.7165 ,0.2376 ,-9.8487>, 0.3000
<2.4031 ,0.3326 ,-13.7882>, 0.1000
}
cone {
<1.7199 ,0.0114 ,-9.8510>, 0.3000
<2.4079 ,0.0160 ,-13.7914>, 0.1000
}
cone {
<1.6939 ,-0.2116 ,-9.8532>, 0.3000
<2.3714 ,-0.2962 ,-13.7945>, 0.1000
}
cone {
<1.6393 ,-0.4276 ,-9.8554>, 0.3000
<2.2950 ,-0.5986 ,-13.7976>, 0.1000
}
cone {
<1.5575 ,-0.6330 ,-9.8577>, 0.3000
<2.1805 ,-0.8863 ,-13.8007>, 0.1000
}
cone {
<1.4503 ,-0.8245 ,-9.8598>, 0.3000
<2.0305 ,-1.1544 ,-13.8038>, 0.1000
}
cone {
<1.3200 ,-0.9990 ,-9.8620>, 0.3000
<1.8480 ,-1.3986 ,-13.8068>, 0.1000
}
cone {
<1.1692 ,-1.1537 ,-9.8642>, 0.3000
<1.6368 ,-1.6151 ,-13.8099>, 0.1000
}
cone {
<1.0006 ,-1.2862 ,-9.8663>, 0.3000
<1.4009 ,-1.8007 ,-13.8129>, 0.1000
}
cone {
<0.8177 ,-1.3947 ,-9.8684>, 0.3000
<1.1447 ,-1.9525 ,-13.8158>, 0.1000
}
cone {
<0.6236 ,-1.4776 ,-9.8706>, 0.3000
<0.8731 ,-2.0686 ,-13.8188>, 0.1000
}
cone {
<0.4220 ,-1.5339 ,-9.8726>, 0.3000
<0.5908 ,-2.1474 ,-13.8217>, 0.1000
}
cone {
<0.2164 ,-1.5630 ,-9.8747>, 0.3000
<0.3030 ,-2.1882 ,-13.8246>, 0.1000
}
cone {
<0.0105 ,-1.5650 ,-9.8768>, 0.3000
<0.0147 ,-2.1910 ,-13.8275>, 0.1000
}
cone {
<-0.1923 ,-1.5401 ,-9.8788>, 0.3000
<-0.2692 ,-2.1562 ,-13.8303>, 0.1000
}
cone {
<-0.3884 ,-1.4893 ,-9.8808>, 0.3000
<-0.5437 ,-2.0851 ,-13.8332>, 0.1000
}
cone {
<-0.5746 ,-1.4139 ,-9.8828>, 0.3000
<-0.8044 ,-1.9795 ,-13.8360>, 0.1000
}
cone {
<-0.7478 ,-1.3156 ,-9.8848>, 0.3000
<-1.0469 ,-1.8418 ,-13.8388>, 0.1000
}
cone {
<-0.9053 ,-1.1964 ,-9.8868>, 0.3000
<-1.2674 ,-1.6750 ,-13.8415>, 0.1000
}
cone {
<-1.0446 ,-1.0588 ,-9.8888>, 0.3000
<-1.4625 ,-1.4823 ,-13.8443>, 0.1000
}
cone {
<-1.1637 ,-0.9054 ,-9.8907>, 0.3000
<-1.6292 ,-1.2676 ,-13.8470>, 0.1000
}
cone {
<-1.2607 ,-0.7393 ,-9.8926>, 0.3000
<-1.7650 ,-1.0350 ,-13.8497>, 0.1000
}
cone {
<-1.3345 ,-0.5633 ,-9.8945>, 0.3000
<-1.8683 ,-0.7887 ,-13.8523>, 0.1000
}
cone {
<-1.3841 ,-0.3809 ,-9.8964>, 0.3000
<-1.9378 ,-0.5333 ,-13.8550>, 0.1000
}
cone {
<-1.4092 ,-0.1952 ,-9.8983>, 0.3000
<-1.9729 ,-0.2733 ,-13.8576>, 0.1000
}
cone {
<-1.4096 ,-0.0095 ,-9.9001>, 0.3000
<-1.9735 ,-0.0133 ,-13.8602>, 0.1000
}
cone {
<-1.3860 ,0.1729 ,-9.9020>, 0.3000
<-1.9404 ,0.2421 ,-13.8628>, 0.1000
}
cone {
<-1.3390 ,0.3491 ,-9.9038>, 0.3000
<-1.8746 ,0.4887 ,-13.8653>, 0.1000
}
cone {
<-1.2700 ,0.5160 ,-9.9056>, 0.3000
<-1.7780 ,0.7224 ,-13.8678>, 0.1000
}
cone {
<-1.1805 ,0.6709 ,-9.9074>, 0.3000
<-1.6527 ,0.9393 ,-13.8703>, 0.1000
}
cone {
<-1.0725 ,0.8114 ,-9.9092>, 0.3000
<-1.5015 ,1.1360 ,-13.8728>, 0.1000
}
cone {
<-0.9482 ,0.9354 ,-9.9109>, 0.3000
<-1.3274 ,1.3095 ,-13.8753>, 0.1000
}
cone {
<-0.8100 ,1.0409 ,-9.9126>, 0.3000
<-1.1340 ,1.4572 ,-13.8777>, 0.1000
}
cone {
<-0.6606 ,1.1265 ,-9.9144>, 0.3000
<-0.9249 ,1.5771 ,-13.8801>, 0.1000
}
cone {
<-0.5029 ,1.1911 ,-9.9161>, 0.3000
<-0.7041 ,1.6676 ,-13.8825>, 0.1000
}
cone {
<-0.3397 ,1.2341 ,-9.9177>, 0.3000
<-0.4756 ,1.7277 ,-13.8848>, 0.1000
}
cone {
<-0.1739 ,1.2550 ,-9.9194>, 0.3000
<-0.2435 ,1.7570 ,-13.8872>, 0.1000
}
cone {
<-0.0086 ,1.2540 ,-9.9211>, 0.3000
<-0.0120 ,1.7556 ,-13.8895>, 0.1000
}
cone {
<0.1536 ,1.2315 ,-9.9227>, 0.3000
<0.2150 ,1.7241 ,-13.8918>, 0.1000
}
cone {
<0.3097 ,1.1883 ,-9.9243>, 0.3000
<0.4336 ,1.6637 ,-13.8940>, 0.1000
}
cone {
<0.4573 ,1.1257 ,-9.9259>, 0.3000
<0.6402 ,1.5760 ,-13.8963>, 0.1000
}
cone {
<0.5939 ,1.0451 ,-9.9275>, 0.3000
<0.8314 ,1.4631 ,-13.8985>, 0.1000
}
cone {
<0.7174 ,0.9483 ,-9.9291>, 0.3000
<1.0043 ,1.3276 ,-13.9007>, 0.1000
}
cone {
<0.8259 ,0.8373 ,-9.9306>, 0.3000
<1.1562 ,1.1722 ,-13.9028>, 0.1000
}
cone {
<0.9178 ,0.7143 ,-9.9321>, 0.3000
<1.2850 ,1.0001 ,-13.9050>, 0.1000
}
cone {
<0.9920 ,0.5819 ,-9.9336>, 0.3000
<1.3888 ,0.8146 ,-13.9071>, 0.1000
}
cone {
<1.0475 ,0.4423 ,-9.9351>, 0.3000
<1.4665 ,0.6193 ,-13.9092>, 0.1000
}
cone {
<1.0837 ,0.2984 ,-9.9366>, 0.3000
<1.5172 ,0.4177 ,-13.9113>, 0.1000
}
cone {
<1.1005 ,0.1526 ,-9.9381>, 0.3000
<1.5407 ,0.2136 ,-13.9133>, 0.1000
}
cone {
<1.0980 ,0.0076 ,-9.9395>, 0.3000
<1.5372 ,0.0106 ,-13.9153>, 0.1000
}
cone {
<1.0767 ,-0.1342 ,-9.9410>, 0.3000
<1.5074 ,-0.1879 ,-13.9173>, 0.1000
}
cone {
<1.0374 ,-0.2703 ,-9.9424>, 0.3000
<1.4523 ,-0.3784 ,-13.9193>, 0.1000
}
cone {
<0.9812 ,-0.3985 ,-9.9438>, 0.3000
<1.3736 ,-0.5579 ,-13.9213>, 0.1000
}
cone {
<0.9094 ,-0.5167 ,-9.9451>, 0.3000
<1.2732 ,-0.7234 ,-13.9232>, 0.1000
}
cone {
<0.8238 ,-0.6231 ,-9.9465>, 0.3000
<1.1534 ,-0.8724 ,-13.9251>, 0.1000
}
cone {
<0.7262 ,-0.7162 ,-9.9479>, 0.3000
<1.0166 ,-1.0027 ,-13.9270>, 0.1000
}
cone {
<0.6185 ,-0.7946 ,-9.9492>, 0.3000
<0.8659 ,-1.1124 ,-13.9288>, 0.1000
}
cone {
<0.5029 ,-0.8573 ,-9.9505>, 0.3000
<0.7041 ,-1.2002 ,-13.9307>, 0.1000
}
cone {
<0.3816 ,-0.9036 ,-9.9518>, 0.3000
<0.5343 ,-1.2650 ,-13.9325>, 0.1000
}
cone {
<0.2570 ,-0.9331 ,-9.9531>, 0.3000
<0.3598 ,-1.3063 ,-13.9343>, 0.1000
}
cone {
<0.1312 ,-0.9457 ,-9.9543>, 0.3000
<0.1837 ,-1.3240 ,-13.9360>, 0.1000
}
cone {
<0.0065 ,-0.9418 ,-9.9556>, 0.3000
<0.0092 ,-1.3185 ,-13.9378>, 0.1000
}
cone {
<-0.1148 ,-0.9216 ,-9.9568>, 0.3000
<-0.1607 ,-1.2903 ,-13.9395>, 0.1000
}
cone {
<-0.2308 ,-0.8861 ,-9.9580>, 0.3000
<-0.3232 ,-1.2406 ,-13.9412>, 0.1000
}
cone {
<-0.3396 ,-0.8363 ,-9.9592>, 0.3000
<-0.4755 ,-1.1709 ,-13.9428>, 0.1000
}
cone {
<-0.4394 ,-0.7735 ,-9.9603>, 0.3000
<-0.6152 ,-1.0829 ,-13.9445>, 0.1000
}
cone {
<-0.5288 ,-0.6992 ,-9.9615>, 0.3000
<-0.7403 ,-0.9788 ,-13.9461>, 0.1000
}
cone {
<-0.6063 ,-0.6149 ,-9.9626>, 0.3000
<-0.8489 ,-0.8608 ,-13.9477>, 0.1000
}
cone {
<-0.6711 ,-0.5225 ,-9.9638>, 0.3000
<-0.9396 ,-0.7315 ,-13.9493>, 0.1000
}
cone {
<-0.7223 ,-0.4238 ,-9.9649>, 0.3000
<-1.0113 ,-0.5933 ,-13.9508>, 0.1000
}
cone {
<-0.7594 ,-0.3208 ,-9.9660>, 0.3000
<-1.0632 ,-0.4491 ,-13.9523>, 0.1000
}
cone {
<-0.7822 ,-0.2155 ,-9.9670>, 0.3000
<-1.0951 ,-0.3017 ,-13.9538>, 0.1000
}
cone {
<-0.7908 ,-0.1097 ,-9.9681>, 0.3000
<-1.1071 ,-0.1536 ,-13.9553>, 0.1000
}
cone {
<-0.7853 ,-0.0055 ,-9.9691>, 0.3000
<-1.0994 ,-0.0077 ,-13.9568>, 0.1000
}
cone {
<-0.7663 ,0.0954 ,-9.9701>, 0.3000
<-1.0729 ,0.1336 ,-13.9582>, 0.1000
}
cone {
<-0.7347 ,0.1913 ,-9.9711>, 0.3000
<-1.0286 ,0.2679 ,-13.9596>, 0.1000
}
cone {
<-0.6913 ,0.2807 ,-9.9721>, 0.3000
<-0.9679 ,0.3930 ,-13.9610>, 0.1000
}
cone {
<-0.6374 ,0.3621 ,-9.9731>, 0.3000
<-0.8924 ,0.5069 ,-13.9623>, 0.1000
}
cone {
<-0.5743 ,0.4343 ,-9.9740>, 0.3000
<-0.8040 ,0.6080 ,-13.9637>, 0.1000
}
cone {
<-0.5034 ,0.4964 ,-9.9750>, 0.3000
<-0.7048 ,0.6949 ,-13.9650>, 0.1000
}
cone {
<-0.4263 ,0.5475 ,-9.9759>, 0.3000
<-0.5968 ,0.7665 ,-13.9663>, 0.1000
}
cone {
<-0.3446 ,0.5872 ,-9.9768>, 0.3000
<-0.4824 ,0.8221 ,-13.9675>, 0.1000
}
cone {
<-0.2599 ,0.6151 ,-9.9777>, 0.3000
<-0.3639 ,0.8612 ,-13.9687>, 0.1000
}
cone {
<-0.1739 ,0.6312 ,-9.9785>, 0.3000
<-0.2435 ,0.8837 ,-13.9700>, 0.1000
}
cone {
<-0.0883 ,0.6356 ,-9.9794>, 0.3000
<-0.1236 ,0.8898 ,-13.9711>, 0.1000
}
cone {
<-0.0044 ,0.6286 ,-9.9802>, 0.3000
<-0.0062 ,0.8800 ,-13.9723>, 0.1000
}
cone {
<0.0760 ,0.6108 ,-9.9810>, 0.3000
<0.1064 ,0.8552 ,-13.9735>, 0.1000
}
cone {
<0.1518 ,0.5830 ,-9.9818>, 0.3000
<0.2125 ,0.8163 ,-13.9746>, 0.1000
}
cone {
<0.2217 ,0.5461 ,-9.9826>, 0.3000
<0.3104 ,0.7646 ,-13.9757>, 0.1000
}
cone {
<0.2846 ,0.5012 ,-9.9834>, 0.3000
<0.3985 ,0.7016 ,-13.9767>, 0.1000
}
cone {
<0.3397 ,0.4493 ,-9.9841>, 0.3000
<0.4756 ,0.6290 ,-13.9778>, 0.1000
}
cone {
<0.3863 ,0.3918 ,-9.9849>, 0.3000
<0.5408 ,0.5485 ,-13.9788>, 0.1000
}
cone {
<0.4238 ,0.3300 ,-9.9856>, 0.3000
<0.5933 ,0.4620 ,-13.9798>, 0.1000
}
cone {
<0.4520 ,0.2653 ,-9.9863>, 0.3000
<0.6328 ,0.3714 ,-13.9808>, 0.1000
}
cone {
<0.4707 ,0.1989 ,-9.9869>, 0.3000
<0.6590 ,0.2785 ,-13.9817>, 0.1000
}
cone {
<0.4800 ,0.1323 ,-9.9876>, 0.3000
<0.6720 ,0.1852 ,-13.9826>, 0.1000
}
cone {
<0.4802 ,0.0667 ,-9.9882>, 0.3000
<0.6723 ,0.0934 ,-13.9835>, 0.1000
}
cone {
<0.4718 ,0.0034 ,-9.9889>, 0.3000
<0.6605 ,0.0047 ,-13.9844>, 0.1000
}
cone {
<0.4552 ,-0.0566 ,-9.9895>, 0.3000
<0.6373 ,-0.0793 ,-13.9853>, 0.1000
}
cone {
<0.4313 ,-0.1123 ,-9.9901>, 0.3000
<0.6038 ,-0.1572 ,-13.9861>, 0.1000
}
cone {
<0.4008 ,-0.1627 ,-9.9906>, 0.3000
<0.5611 ,-0.2277 ,-13.9869>, 0.1000
}
cone {
<0.3648 ,-0.2071 ,-9.9912>, 0.3000
<0.5107 ,-0.2900 ,-13.9877>, 0.1000
}
cone {
<0.3242 ,-0.2451 ,-9.9917>, 0.3000
<0.4539 ,-0.3431 ,-13.9884>, 0.1000
}
cone {
<0.2801 ,-0.2761 ,-9.9923>, 0.3000
<0.3921 ,-0.3866 ,-13.9892>, 0.1000
}
cone {
<0.2336 ,-0.3000 ,-9.9928>, 0.3000
<0.3271 ,-0.4200 ,-13.9899>, 0.1000
}
cone {
<0.1859 ,-0.3166 ,-9.9933>, 0.3000
<0.2602 ,-0.4433 ,-13.9906>, 0.1000
}
cone {
<0.1378 ,-0.3261 ,-9.9937>, 0.3000
<0.1930 ,-0.4566 ,-13.9912>, 0.1000
}
cone {
<0.0906 ,-0.3287 ,-9.9942>, 0.3000
<0.1269 ,-0.4602 ,-13.9919>, 0.1000
}
cone {
<0.0451 ,-0.3248 ,-9.9946>, 0.3000
<0.0632 ,-0.4547 ,-13.9925>, 0.1000
}
cone {
<0.0023 ,-0.3148 ,-9.9950>, 0.3000
<0.0032 ,-0.4407 ,-13.9931>, 0.1000
}
cone {
<-0.0372 ,-0.2994 ,-9.9954>, 0.3000
<-0.0521 ,-0.4192 ,-13.9936>, 0.1000
}
cone {
<-0.0727 ,-0.2794 ,-9.9958>, 0.3000
<-0.1018 ,-0.3911 ,-13.9942>, 0.1000
}
cone {
<-0.1036 ,-0.2554 ,-9.9962>, 0.3000
<-0.1451 ,-0.3575 ,-13.9947>, 0.1000
}
cone {
<-0.1296 ,-0.2283 ,-9.9966>, 0.3000
<-0.1814 ,-0.3196 ,-13.9952>, 0.1000
}
cone {
<-0.1504 ,-0.1990 ,-9.9969>, 0.3000
<-0.2106 ,-0.2785 ,-13.9956>, 0.1000
}
cone {
<-0.1659 ,-0.1683 ,-9.9972>, 0.3000
<-0.2322 ,-0.2356 ,-13.9961>, 0.1000
}
cone {
<-0.1761 ,-0.1372 ,-9.9975>, 0.3000
<-0.2466 ,-0.1920 ,-13.9965>, 0.1000
}
cone {
<-0.1812 ,-0.1064 ,-9.9978>, 0.3000
<-0.2537 ,-0.1489 ,-13.9969>, 0.1000
}
cone {
<-0.1815 ,-0.0767 ,-9.9981>, 0.3000
<-0.2541 ,-0.1074 ,-13.9973>, 0.1000
}
cone {
<-0.1774 ,-0.0489 ,-9.9983>, 0.3000
<-0.2483 ,-0.0685 ,-13.9976>, 0.1000
}
cone {
<-0.1693 ,-0.0235 ,-9.9985>, 0.3000
<-0.2370 ,-0.0329 ,-13.9980>, 0.1000
}
cone {
<-0.1578 ,-0.0011 ,-9.9988>, 0.3000
<-0.2209 ,-0.0016 ,-13.9983>, 0.1000
}
cone {
<-0.1436 ,0.0178 ,-9.9990>, 0.3000
<-0.2011 ,0.0250 ,-13.9985>, 0.1000
}
cone {
<-0.1274 ,0.0331 ,-9.9991>, 0.3000
<-0.1783 ,0.0464 ,-13.9988>, 0.1000
}
cone {
<-0.1098 ,0.0446 ,-9.9993>, 0.3000
<-0.1538 ,0.0624 ,-13.9990>, 0.1000
}
cone {
<-0.0917 ,0.0521 ,-9.9994>, 0.3000
<-0.1284 ,0.0729 ,-13.9992>, 0.1000
}
cone {
<-0.0737 ,0.0557 ,-9.9996>, 0.3000
<-0.1032 ,0.0780 ,-13.9994>, 0.1000
}
cone {
<-0.0565 ,0.0556 ,-9.9997>, 0.3000
<-0.0790 ,0.0779 ,-13.9996>, 0.1000
}
cone {
<-0.0407 ,0.0522 ,-9.9998>, 0.3000
<-0.0569 ,0.0731 ,-13.9997>, 0.1000
}
cone {
<-0.0269 ,0.0458 ,-9.9999>, 0.3000
<-0.0376 ,0.0641 ,-13.9998>, 0.1000
}
cone {
<-0.0156 ,0.0368 ,-9.9999>, 0.3000
<-0.0218 ,0.0516 ,-13.9999>, 0.1000
}
cone {
<-0.0072 ,0.0259 ,-10.0000>, 0.3000
<-0.0100 ,0.0363 ,-13.9999>, 0.1000
}
cone {
<-0.0019 ,0.0137 ,-10.0000>, 0.3000
<-0.0027 ,0.0192 ,-14.0000>, 0.1000
}
cone {
<-0.0000 ,0.0007 ,-10.0000>, 0.3000
<-0.0000 ,0.0010 ,-14.0000>, 0.1000
}

}

#declare Creature_Eye =
union {
cone {
<0.0000 ,0.0000 ,4.0000>, 0.1000
<0.0000 ,0.0000 ,6.0000>, 0.4000
}
cone {
<0.0007 ,0.0052 ,4.0000>, 0.1000
<0.0010 ,0.0078 ,6.0000>, 0.4000
}
cone {
<0.0027 ,0.0101 ,4.0000>, 0.1000
<0.0041 ,0.0152 ,6.0000>, 0.4000
}
cone {
<0.0060 ,0.0145 ,4.0000>, 0.1000
<0.0090 ,0.0218 ,6.0000>, 0.4000
}
cone {
<0.0105 ,0.0181 ,3.9999>, 0.1000
<0.0157 ,0.0272 ,5.9999>, 0.4000
}
cone {
<0.0159 ,0.0208 ,3.9999>, 0.1000
<0.0239 ,0.0312 ,5.9999>, 0.4000
}
cone {
<0.0222 ,0.0222 ,3.9999>, 0.1000
<0.0333 ,0.0333 ,5.9998>, 0.4000
}
cone {
<0.0291 ,0.0223 ,3.9998>, 0.1000
<0.0436 ,0.0335 ,5.9997>, 0.4000
}
cone {
<0.0363 ,0.0209 ,3.9998>, 0.1000
<0.0544 ,0.0314 ,5.9997>, 0.4000
}
cone {
<0.0435 ,0.0180 ,3.9997>, 0.1000
<0.0653 ,0.0270 ,5.9996>, 0.4000
}
cone {
<0.0506 ,0.0136 ,3.9997>, 0.1000
<0.0759 ,0.0203 ,5.9995>, 0.4000
}
cone {
<0.0571 ,0.0075 ,3.9996>, 0.1000
<0.0857 ,0.0113 ,5.9994>, 0.4000
}
cone {
<0.0628 ,-0.0000 ,3.9995>, 0.1000
<0.0942 ,-0.0000 ,5.9993>, 0.4000
}
cone {
<0.0675 ,-0.0089 ,3.9994>, 0.1000
<0.1012 ,-0.0133 ,5.9991>, 0.4000
}
cone {
<0.0708 ,-0.0190 ,3.9993>, 0.1000
<0.1062 ,-0.0285 ,5.9990>, 0.4000
}
cone {
<0.0726 ,-0.0301 ,3.9992>, 0.1000
<0.1088 ,-0.0451 ,5.9988>, 0.4000
}
cone {
<0.0725 ,-0.0419 ,3.9991>, 0.1000
<0.1088 ,-0.0628 ,5.9987>, 0.4000
}
cone {
<0.0706 ,-0.0542 ,3.9990>, 0.1000
<0.1059 ,-0.0813 ,5.9985>, 0.4000
}
cone {
<0.0666 ,-0.0666 ,3.9989>, 0.1000
<0.1000 ,-0.1000 ,5.9983>, 0.4000
}
cone {
<0.0606 ,-0.0789 ,3.9988>, 0.1000
<0.0908 ,-0.1184 ,5.9981>, 0.4000
}
cone {
<0.0524 ,-0.0907 ,3.9986>, 0.1000
<0.0785 ,-0.1360 ,5.9979>, 0.4000
}
cone {
<0.0421 ,-0.1016 ,3.9985>, 0.1000
<0.0631 ,-0.1524 ,5.9977>, 0.4000
}
cone {
<0.0298 ,-0.1113 ,3.9983>, 0.1000
<0.0447 ,-0.1669 ,5.9975>, 0.4000
}
cone {
<0.0157 ,-0.1194 ,3.9982>, 0.1000
<0.0236 ,-0.1791 ,5.9973>, 0.4000
}
cone {
<-0.0000 ,-0.1256 ,3.9980>, 0.1000
<-0.0000 ,-0.1885 ,5.9970>, 0.4000
}
cone {
<-0.0171 ,-0.1298 ,3.9979>, 0.1000
<-0.0256 ,-0.1946 ,5.9968>, 0.4000
}
cone {
<-0.0352 ,-0.1315 ,3.9977>, 0.1000
<-0.0528 ,-0.1972 ,5.9965>, 0.4000
}
cone {
<-0.0541 ,-0.1306 ,3.9975>, 0.1000
<-0.0811 ,-0.1959 ,5.9963>, 0.4000
}
cone {
<-0.0733 ,-0.1269 ,3.9973>, 0.1000
<-0.1099 ,-0.1904 ,5.9960>, 0.4000
}
cone {
<-0.0924 ,-0.1204 ,3.9971>, 0.1000
<-0.1386 ,-0.1807 ,5.9957>, 0.4000
}
cone {
<-0.1110 ,-0.1110 ,3.9969>, 0.1000
<-0.1666 ,-0.1666 ,5.9954>, 0.4000
}
cone {
<-0.1287 ,-0.0988 ,3.9967>, 0.1000
<-0.1931 ,-0.1482 ,5.9951>, 0.4000
}
cone {
<-0.1451 ,-0.0838 ,3.9965>, 0.1000
<-0.2176 ,-0.1256 ,5.9947>, 0.4000
}
cone {
<-0.1596 ,-0.0661 ,3.9963>, 0.1000
<-0.2394 ,-0.0992 ,5.9944>, 0.4000
}
cone {
<-0.1719 ,-0.0461 ,3.9960>, 0.1000
<-0.2579 ,-0.0691 ,5.9941>, 0.4000
}
cone {
<-0.1816 ,-0.0239 ,3.9958>, 0.1000
<-0.2724 ,-0.0359 ,5.9937>, 0.4000
}
cone {
<-0.1884 ,0.0000 ,3.9956>, 0.1000
<-0.2826 ,0.0000 ,5.9933>, 0.4000
}
cone {
<-0.1920 ,0.0253 ,3.9953>, 0.1000
<-0.2880 ,0.0379 ,5.9930>, 0.4000
}
cone {
<-0.1921 ,0.0515 ,3.9951>, 0.1000
<-0.2882 ,0.0772 ,5.9926>, 0.4000
}
cone {
<-0.1886 ,0.0781 ,3.9948>, 0.1000
<-0.2829 ,0.1172 ,5.9922>, 0.4000
}
cone {
<-0.1813 ,0.1047 ,3.9945>, 0.1000
<-0.2719 ,0.1570 ,5.9918>, 0.4000
}
cone {
<-0.1702 ,0.1306 ,3.9942>, 0.1000
<-0.2553 ,0.1959 ,5.9914>, 0.4000
}
cone {
<-0.1554 ,0.1554 ,3.9940>, 0.1000
<-0.2331 ,0.2331 ,5.9909>, 0.4000
}
cone {
<-0.1370 ,0.1785 ,3.9937>, 0.1000
<-0.2055 ,0.2678 ,5.9905>, 0.4000
}
cone {
<-0.1151 ,0.1994 ,3.9934>, 0.1000
<-0.1727 ,0.2991 ,5.9901>, 0.4000
}
cone {
<-0.0901 ,0.2176 ,3.9931>, 0.1000
<-0.1352 ,0.3263 ,5.9896>, 0.4000
}
cone {
<-0.0623 ,0.2325 ,3.9928>, 0.1000
<-0.0934 ,0.3488 ,5.9891>, 0.4000
}
cone {
<-0.0321 ,0.2438 ,3.9924>, 0.1000
<-0.0482 ,0.3657 ,5.9886>, 0.4000
}
cone {
<0.0000 ,0.2512 ,3.9921>, 0.1000
<0.0000 ,0.3767 ,5.9882>, 0.4000
}
cone {
<0.0335 ,0.2542 ,3.9918>, 0.1000
<0.0502 ,0.3813 ,5.9877>, 0.4000
}
cone {
<0.0677 ,0.2527 ,3.9914>, 0.1000
<0.1016 ,0.3790 ,5.9872>, 0.4000
}
cone {
<0.1021 ,0.2465 ,3.9911>, 0.1000
<0.1532 ,0.3698 ,5.9866>, 0.4000
}
cone {
<0.1360 ,0.2356 ,3.9907>, 0.1000
<0.2040 ,0.3534 ,5.9861>, 0.4000
}
cone {
<0.1688 ,0.2200 ,3.9904>, 0.1000
<0.2532 ,0.3300 ,5.9856>, 0.4000
}
cone {
<0.1998 ,0.1998 ,3.9900>, 0.1000
<0.2996 ,0.2996 ,5.9850>, 0.4000
}
cone {
<0.2283 ,0.1752 ,3.9896>, 0.1000
<0.3424 ,0.2627 ,5.9845>, 0.4000
}
cone {
<0.2537 ,0.1465 ,3.9893>, 0.1000
<0.3806 ,0.2197 ,5.9839>, 0.4000
}
cone {
<0.2755 ,0.1141 ,3.9889>, 0.1000
<0.4132 ,0.1712 ,5.9833>, 0.4000
}
cone {
<0.2931 ,0.0785 ,3.9885>, 0.1000
<0.4396 ,0.1178 ,5.9827>, 0.4000
}
cone {
<0.3060 ,0.0403 ,3.9881>, 0.1000
<0.4590 ,0.0604 ,5.9821>, 0.4000
}
cone {
<0.3138 ,-0.0000 ,3.9877>, 0.1000
<0.4708 ,-0.0000 ,5.9815>, 0.4000
}
cone {
<0.3163 ,-0.0416 ,3.9873>, 0.1000
<0.4745 ,-0.0625 ,5.9809>, 0.4000
}
cone {
<0.3132 ,-0.0839 ,3.9868>, 0.1000
<0.4698 ,-0.1259 ,5.9803>, 0.4000
}
cone {
<0.3044 ,-0.1261 ,3.9864>, 0.1000
<0.4566 ,-0.1891 ,5.9796>, 0.4000
}
cone {
<0.2899 ,-0.1674 ,3.9860>, 0.1000
<0.4348 ,-0.2510 ,5.9790>, 0.4000
}
cone {
<0.2697 ,-0.2069 ,3.9855>, 0.1000
<0.4045 ,-0.3104 ,5.9783>, 0.4000
}
cone {
<0.2441 ,-0.2441 ,3.9851>, 0.1000
<0.3661 ,-0.3661 ,5.9776>, 0.4000
}
cone {
<0.2133 ,-0.2780 ,3.9846>, 0.1000
<0.3199 ,-0.4169 ,5.9769>, 0.4000
}
cone {
<0.1778 ,-0.3079 ,3.9842>, 0.1000
<0.2667 ,-0.4619 ,5.9762>, 0.4000
}
cone {
<0.1381 ,-0.3333 ,3.9837>, 0.1000
<0.2071 ,-0.5000 ,5.9755>, 0.4000
}
cone {
<0.0947 ,-0.3535 ,3.9832>, 0.1000
<0.1421 ,-0.5303 ,5.9748>, 0.4000
}
cone {
<0.0485 ,-0.3680 ,3.9827>, 0.1000
<0.0727 ,-0.5521 ,5.9741>, 0.4000
}
cone {
<0.0000 ,-0.3764 ,3.9822>, 0.1000
<0.0000 ,-0.5646 ,5.9734>, 0.4000
}
cone {
<-0.0498 ,-0.3784 ,3.9818>, 0.1000
<-0.0747 ,-0.5676 ,5.9726>, 0.4000
}
cone {
<-0.1001 ,-0.3737 ,3.9812>, 0.1000
<-0.1502 ,-0.5605 ,5.9719>, 0.4000
}
cone {
<-0.1500 ,-0.3622 ,3.9807>, 0.1000
<-0.2251 ,-0.5433 ,5.9711>, 0.4000
}
cone {
<-0.1986 ,-0.3441 ,3.9802>, 0.1000
<-0.2980 ,-0.5161 ,5.9703>, 0.4000
}
cone {
<-0.2450 ,-0.3193 ,3.9797>, 0.1000
<-0.3675 ,-0.4790 ,5.9695>, 0.4000
}
cone {
<-0.2883 ,-0.2883 ,3.9792>, 0.1000
<-0.4324 ,-0.4324 ,5.9688>, 0.4000
}
cone {
<-0.3276 ,-0.2514 ,3.9786>, 0.1000
<-0.4914 ,-0.3770 ,5.9679>, 0.4000
}
cone {
<-0.3621 ,-0.2091 ,3.9781>, 0.1000
<-0.5431 ,-0.3136 ,5.9671>, 0.4000
}
cone {
<-0.3911 ,-0.1620 ,3.9775>, 0.1000
<-0.5866 ,-0.2430 ,5.9663>, 0.4000
}
cone {
<-0.4139 ,-0.1109 ,3.9770>, 0.1000
<-0.6209 ,-0.1664 ,5.9655>, 0.4000
}
cone {
<-0.4300 ,-0.0566 ,3.9764>, 0.1000
<-0.6450 ,-0.0849 ,5.9646>, 0.4000
}
cone {
<-0.4389 ,-0.0000 ,3.9758>, 0.1000
<-0.6584 ,-0.0000 ,5.9638>, 0.4000
}
cone {
<-0.4403 ,0.0580 ,3.9753>, 0.1000
<-0.6605 ,0.0870 ,5.9629>, 0.4000
}
cone {
<-0.4340 ,0.1163 ,3.9747>, 0.1000
<-0.6511 ,0.1744 ,5.9620>, 0.4000
}
cone {
<-0.4199 ,0.1739 ,3.9741>, 0.1000
<-0.6299 ,0.2609 ,5.9611>, 0.4000
}
cone {
<-0.3982 ,0.2299 ,3.9735>, 0.1000
<-0.5972 ,0.3448 ,5.9602>, 0.4000
}
cone {
<-0.3689 ,0.2830 ,3.9729>, 0.1000
<-0.5533 ,0.4246 ,5.9593>, 0.4000
}
cone {
<-0.3324 ,0.3324 ,3.9723>, 0.1000
<-0.4987 ,0.4987 ,5.9584>, 0.4000
}
cone {
<-0.2894 ,0.3771 ,3.9717>, 0.1000
<-0.4341 ,0.5657 ,5.9575>, 0.4000
}
cone {
<-0.2403 ,0.4162 ,3.9710>, 0.1000
<-0.3604 ,0.6242 ,5.9565>, 0.4000
}
cone {
<-0.1859 ,0.4488 ,3.9704>, 0.1000
<-0.2788 ,0.6732 ,5.9556>, 0.4000
}
cone {
<-0.1271 ,0.4742 ,3.9698>, 0.1000
<-0.1906 ,0.7113 ,5.9546>, 0.4000
}
cone {
<-0.0648 ,0.4919 ,3.9691>, 0.1000
<-0.0971 ,0.7378 ,5.9537>, 0.4000
}
cone {
<-0.0000 ,0.5013 ,3.9685>, 0.1000
<-0.0000 ,0.7520 ,5.9527>, 0.4000
}
cone {
<0.0661 ,0.5022 ,3.9678>, 0.1000
<0.0992 ,0.7533 ,5.9517>, 0.4000
}
cone {
<0.1324 ,0.4943 ,3.9671>, 0.1000
<0.1987 ,0.7414 ,5.9507>, 0.4000
}
cone {
<0.1978 ,0.4776 ,3.9665>, 0.1000
<0.2967 ,0.7164 ,5.9497>, 0.4000
}
cone {
<0.2610 ,0.4522 ,3.9658>, 0.1000
<0.3916 ,0.6782 ,5.9487>, 0.4000
}
cone {
<0.3210 ,0.4183 ,3.9651>, 0.1000
<0.4815 ,0.6275 ,5.9476>, 0.4000
}
cone {
<0.3765 ,0.3765 ,3.9644>, 0.1000
<0.5648 ,0.5648 ,5.9466>, 0.4000
}
cone {
<0.4266 ,0.3273 ,3.9637>, 0.1000
<0.6398 ,0.4910 ,5.9455>, 0.4000
}
cone {
<0.4701 ,0.2714 ,3.9630>, 0.1000
<0.7052 ,0.4072 ,5.9445>, 0.4000
}
cone {
<0.5063 ,0.2097 ,3.9623>, 0.1000
<0.7595 ,0.3146 ,5.9434>, 0.4000
}
cone {
<0.5344 ,0.1432 ,3.9616>, 0.1000
<0.8016 ,0.2148 ,5.9423>, 0.4000
}
cone {
<0.5536 ,0.0729 ,3.9608>, 0.1000
<0.8305 ,0.1093 ,5.9412>, 0.4000
}
cone {
<0.5636 ,0.0000 ,3.9601>, 0.1000
<0.8454 ,0.0000 ,5.9401>, 0.4000
}
cone {
<0.5639 ,-0.0742 ,3.9594>, 0.1000
<0.8459 ,-0.1114 ,5.9390>, 0.4000
}
cone {
<0.5544 ,-0.1485 ,3.9586>, 0.1000
<0.8316 ,-0.2228 ,5.9379>, 0.4000
}
cone {
<0.5351 ,-0.2216 ,3.9579>, 0.1000
<0.8026 ,-0.3324 ,5.9368>, 0.4000
}
cone {
<0.5060 ,-0.2922 ,3.9571>, 0.1000
<0.7591 ,-0.4382 ,5.9356>, 0.4000
}
cone {
<0.4677 ,-0.3589 ,3.9563>, 0.1000
<0.7015 ,-0.5383 ,5.9345>, 0.4000
}
cone {
<0.4205 ,-0.4205 ,3.9555>, 0.1000
<0.6308 ,-0.6308 ,5.9333>, 0.4000
}
cone {
<0.3652 ,-0.4759 ,3.9548>, 0.1000
<0.5478 ,-0.7139 ,5.9321>, 0.4000
}
cone {
<0.3025 ,-0.5240 ,3.9540>, 0.1000
<0.4538 ,-0.7860 ,5.9310>, 0.4000
}
cone {
<0.2335 ,-0.5638 ,3.9532>, 0.1000
<0.3503 ,-0.8456 ,5.9298>, 0.4000
}
cone {
<0.1593 ,-0.5944 ,3.9524>, 0.1000
<0.2389 ,-0.8916 ,5.9286>, 0.4000
}
cone {
<0.0810 ,-0.6153 ,3.9516>, 0.1000
<0.1215 ,-0.9229 ,5.9274>, 0.4000
}
cone {
<0.0000 ,-0.6257 ,3.9508>, 0.1000
<0.0000 ,-0.9386 ,5.9261>, 0.4000
}
cone {
<-0.0823 ,-0.6255 ,3.9499>, 0.1000
<-0.1235 ,-0.9383 ,5.9249>, 0.4000
}
cone {
<-0.1646 ,-0.6144 ,3.9491>, 0.1000
<-0.2469 ,-0.9216 ,5.9237>, 0.4000
}
cone {
<-0.2454 ,-0.5924 ,3.9483>, 0.1000
<-0.3681 ,-0.8887 ,5.9224>, 0.4000
}
cone {
<-0.3232 ,-0.5598 ,3.9474>, 0.1000
<-0.4848 ,-0.8397 ,5.9211>, 0.4000
}
cone {
<-0.3966 ,-0.5169 ,3.9466>, 0.1000
<-0.5950 ,-0.7754 ,5.9199>, 0.4000
}
cone {
<-0.4644 ,-0.4644 ,3.9457>, 0.1000
<-0.6966 ,-0.6966 ,5.9186>, 0.4000
}
cone {
<-0.5251 ,-0.4030 ,3.9449>, 0.1000
<-0.7877 ,-0.6044 ,5.9173>, 0.4000
}
cone {
<-0.5777 ,-0.3335 ,3.9440>, 0.1000
<-0.8665 ,-0.5003 ,5.9160>, 0.4000
}
cone {
<-0.6211 ,-0.2573 ,3.9431>, 0.1000
<-0.9316 ,-0.3859 ,5.9147>, 0.4000
}
cone {
<-0.6543 ,-0.1753 ,3.9422>, 0.1000
<-0.9815 ,-0.2630 ,5.9133>, 0.4000
}
cone {
<-0.6767 ,-0.0891 ,3.9413>, 0.1000
<-1.0151 ,-0.1337 ,5.9120>, 0.4000
}
cone {
<-0.6877 ,-0.0000 ,3.9404>, 0.1000
<-1.0316 ,-0.0000 ,5.9107>, 0.4000
}
cone {
<-0.6869 ,0.0904 ,3.9395>, 0.1000
<-1.0304 ,0.1356 ,5.9093>, 0.4000
}
cone {
<-0.6742 ,0.1807 ,3.9386>, 0.1000
<-1.0114 ,0.2710 ,5.9079>, 0.4000
}
cone {
<-0.6497 ,0.2691 ,3.9377>, 0.1000
<-0.9745 ,0.4036 ,5.9066>, 0.4000
}
cone {
<-0.6134 ,0.3542 ,3.9368>, 0.1000
<-0.9202 ,0.5312 ,5.9052>, 0.4000
}
cone {
<-0.5661 ,0.4343 ,3.9359>, 0.1000
<-0.8491 ,0.6515 ,5.9038>, 0.4000
}
cone {
<-0.5082 ,0.5081 ,3.9349>, 0.1000
<-0.7622 ,0.7622 ,5.9024>, 0.4000
}
cone {
<-0.4406 ,0.5742 ,3.9340>, 0.1000
<-0.6609 ,0.8613 ,5.9010>, 0.4000
}
cone {
<-0.3645 ,0.6313 ,3.9330>, 0.1000
<-0.5467 ,0.9469 ,5.8995>, 0.4000
}
cone {
<-0.2809 ,0.6782 ,3.9321>, 0.1000
<-0.4214 ,1.0173 ,5.8981>, 0.4000
}
cone {
<-0.1913 ,0.7140 ,3.9311>, 0.1000
<-0.2870 ,1.0711 ,5.8966>, 0.4000
}
cone {
<-0.0972 ,0.7380 ,3.9301>, 0.1000
<-0.1458 ,1.1070 ,5.8952>, 0.4000
}
cone {
<-0.0000 ,0.7495 ,3.9291>, 0.1000
<-0.0000 ,1.1243 ,5.8937>, 0.4000
}
cone {
<0.0985 ,0.7482 ,3.9282>, 0.1000
<0.1477 ,1.1223 ,5.8922>, 0.4000
}
cone {
<0.1966 ,0.7339 ,3.9272>, 0.1000
<0.2950 ,1.1009 ,5.8908>, 0.4000
}
cone {
<0.2927 ,0.7067 ,3.9262>, 0.1000
<0.4391 ,1.0601 ,5.8893>, 0.4000
}
cone {
<0.3850 ,0.6669 ,3.9252>, 0.1000
<0.5775 ,1.0004 ,5.8878>, 0.4000
}
cone {
<0.4719 ,0.6150 ,3.9242>, 0.1000
<0.7079 ,0.9226 ,5.8862>, 0.4000
}
cone {
<0.5518 ,0.5518 ,3.9231>, 0.1000
<0.8277 ,0.8277 ,5.8847>, 0.4000
}
cone {
<0.6232 ,0.4782 ,3.9221>, 0.1000
<0.9347 ,0.7173 ,5.8832>, 0.4000
}
cone {
<0.6847 ,0.3953 ,3.9211>, 0.1000
<1.0270 ,0.5930 ,5.8816>, 0.4000
}
cone {
<0.7352 ,0.3045 ,3.9200>, 0.1000
<1.1028 ,0.4568 ,5.8801>, 0.4000
}
cone {
<0.7736 ,0.2073 ,3.9190>, 0.1000
<1.1604 ,0.3110 ,5.8785>, 0.4000
}
cone {
<0.7991 ,0.1052 ,3.9179>, 0.1000
<1.1987 ,0.1578 ,5.8769>, 0.4000
}
cone {
<0.8111 ,0.0000 ,3.9169>, 0.1000
<1.2167 ,0.0000 ,5.8753>, 0.4000
}
cone {
<0.8093 ,-0.1065 ,3.9158>, 0.1000
<1.2139 ,-0.1598 ,5.8737>, 0.4000
}
cone {
<0.7934 ,-0.2126 ,3.9148>, 0.1000
<1.1901 ,-0.3189 ,5.8721>, 0.4000
}
cone {
<0.7636 ,-0.3163 ,3.9137>, 0.1000
<1.1454 ,-0.4744 ,5.8705>, 0.4000
}
cone {
<0.7202 ,-0.4158 ,3.9126>, 0.1000
<1.0804 ,-0.6237 ,5.8689>, 0.4000
}
cone {
<0.6639 ,-0.5094 ,3.9115>, 0.1000
<0.9958 ,-0.7641 ,5.8672>, 0.4000
}
cone {
<0.5953 ,-0.5953 ,3.9104>, 0.1000
<0.8930 ,-0.8929 ,5.8656>, 0.4000
}
cone {
<0.5156 ,-0.6720 ,3.9093>, 0.1000
<0.7735 ,-1.0079 ,5.8639>, 0.4000
}
cone {
<0.4261 ,-0.7379 ,3.9082>, 0.1000
<0.6391 ,-1.1069 ,5.8623>, 0.4000
}
cone {
<0.3281 ,-0.7920 ,3.9071>, 0.1000
<0.4921 ,-1.1880 ,5.8606>, 0.4000
}
cone {
<0.2232 ,-0.8330 ,3.9059>, 0.1000
<0.3348 ,-1.2494 ,5.8589>, 0.4000
}
cone {
<0.1132 ,-0.8600 ,3.9048>, 0.1000
<0.1699 ,-1.2901 ,5.8572>, 0.4000
}
cone {
<0.0000 ,-0.8726 ,3.9037>, 0.1000
<0.0000 ,-1.3089 ,5.8555>, 0.4000
}
cone {
<-0.1145 ,-0.8702 ,3.9025>, 0.1000
<-0.1718 ,-1.3053 ,5.8538>, 0.4000
}
cone {
<-0.2285 ,-0.8527 ,3.9014>, 0.1000
<-0.3427 ,-1.2791 ,5.8521>, 0.4000
}
cone {
<-0.3398 ,-0.8203 ,3.9002>, 0.1000
<-0.5096 ,-1.2305 ,5.8503>, 0.4000
}
cone {
<-0.4465 ,-0.7734 ,3.8990>, 0.1000
<-0.6697 ,-1.1601 ,5.8486>, 0.4000
}
cone {
<-0.5467 ,-0.7125 ,3.8979>, 0.1000
<-0.8201 ,-1.0688 ,5.8468>, 0.4000
}
cone {
<-0.6386 ,-0.6387 ,3.8967>, 0.1000
<-0.9580 ,-0.9580 ,5.8450>, 0.4000
}
cone {
<-0.7206 ,-0.5530 ,3.8955>, 0.1000
<-1.0809 ,-0.8294 ,5.8433>, 0.4000
}
cone {
<-0.7910 ,-0.4567 ,3.8943>, 0.1000
<-1.1865 ,-0.6851 ,5.8415>, 0.4000
}
cone {
<-0.8486 ,-0.3515 ,3.8931>, 0.1000
<-1.2729 ,-0.5273 ,5.8397>, 0.4000
}
cone {
<-0.8921 ,-0.2391 ,3.8919>, 0.1000
<-1.3382 ,-0.3586 ,5.8379>, 0.4000
}
cone {
<-0.9207 ,-0.1212 ,3.8907>, 0.1000
<-1.3811 ,-0.1819 ,5.8360>, 0.4000
}
cone {
<-0.9338 ,-0.0000 ,3.8895>, 0.1000
<-1.4007 ,-0.0000 ,5.8342>, 0.4000
}
cone {
<-0.9308 ,0.1225 ,3.8883>, 0.1000
<-1.3963 ,0.1838 ,5.8324>, 0.4000
}
cone {
<-0.9118 ,0.2443 ,3.8870>, 0.1000
<-1.3677 ,0.3664 ,5.8305>, 0.4000
}
cone {
<-0.8768 ,0.3632 ,3.8858>, 0.1000
<-1.3152 ,0.5447 ,5.8287>, 0.4000
}
cone {
<-0.8263 ,0.4770 ,3.8845>, 0.1000
<-1.2395 ,0.7156 ,5.8268>, 0.4000
}
cone {
<-0.7610 ,0.5839 ,3.8833>, 0.1000
<-1.1415 ,0.8759 ,5.8249>, 0.4000
}
cone {
<-0.6819 ,0.6818 ,3.8820>, 0.1000
<-1.0228 ,1.0228 ,5.8230>, 0.4000
}
cone {
<-0.5901 ,0.7690 ,3.8808>, 0.1000
<-0.8852 ,1.1536 ,5.8211>, 0.4000
}
cone {
<-0.4873 ,0.8439 ,3.8795>, 0.1000
<-0.7309 ,1.2658 ,5.8192>, 0.4000
}
cone {
<-0.3749 ,0.9050 ,3.8782>, 0.1000
<-0.5623 ,1.3574 ,5.8173>, 0.4000
}
cone {
<-0.2549 ,0.9511 ,3.8769>, 0.1000
<-0.3823 ,1.4266 ,5.8154>, 0.4000
}
cone {
<-0.1292 ,0.9812 ,3.8756>, 0.1000
<-0.1938 ,1.4718 ,5.8134>, 0.4000
}
cone {
<-0.0000 ,0.9948 ,3.8743>, 0.1000
<-0.0001 ,1.4921 ,5.8115>, 0.4000
}
cone {
<0.1305 ,0.9913 ,3.8730>, 0.1000
<0.1957 ,1.4869 ,5.8095>, 0.4000
}
cone {
<0.2601 ,0.9707 ,3.8717>, 0.1000
<0.3901 ,1.4560 ,5.8076>, 0.4000
}
cone {
<0.3865 ,0.9331 ,3.8704>, 0.1000
<0.5797 ,1.3996 ,5.8056>, 0.4000
}
cone {
<0.5075 ,0.8791 ,3.8691>, 0.1000
<0.7612 ,1.3186 ,5.8036>, 0.4000
}
cone {
<0.6210 ,0.8093 ,3.8677>, 0.1000
<0.9314 ,1.2140 ,5.8016>, 0.4000
}
cone {
<0.7249 ,0.7249 ,3.8664>, 0.1000
<1.0873 ,1.0874 ,5.7996>, 0.4000
}
cone {
<0.8173 ,0.6272 ,3.8651>, 0.1000
<1.2260 ,0.9408 ,5.7976>, 0.4000
}
cone {
<0.8966 ,0.5177 ,3.8637>, 0.1000
<1.3448 ,0.7765 ,5.7956>, 0.4000
}
cone {
<0.9611 ,0.3982 ,3.8623>, 0.1000
<1.4417 ,0.5972 ,5.7935>, 0.4000
}
cone {
<1.0098 ,0.2706 ,3.8610>, 0.1000
<1.5146 ,0.4059 ,5.7915>, 0.4000
}
cone {
<1.0414 ,0.1371 ,3.8596>, 0.1000
<1.5622 ,0.2057 ,5.7894>, 0.4000
}
cone {
<1.0555 ,0.0000 ,3.8582>, 0.1000
<1.5832 ,0.0001 ,5.7873>, 0.4000
}
cone {
<1.0515 ,-0.1384 ,3.8568>, 0.1000
<1.5772 ,-0.2076 ,5.7853>, 0.4000
}
cone {
<1.0293 ,-0.2758 ,3.8555>, 0.1000
<1.5439 ,-0.4136 ,5.7832>, 0.4000
}
cone {
<0.9892 ,-0.4097 ,3.8541>, 0.1000
<1.4837 ,-0.6145 ,5.7811>, 0.4000
}
cone {
<0.9316 ,-0.5378 ,3.8527>, 0.1000
<1.3974 ,-0.8067 ,5.7790>, 0.4000
}
cone {
<0.8574 ,-0.6579 ,3.8512>, 0.1000
<1.2861 ,-0.9868 ,5.7769>, 0.4000
}
cone {
<0.7678 ,-0.7677 ,3.8498>, 0.1000
<1.1517 ,-1.1516 ,5.7747>, 0.4000
}
cone {
<0.6641 ,-0.8654 ,3.8484>, 0.1000
<0.9961 ,-1.2980 ,5.7726>, 0.4000
}
cone {
<0.5480 ,-0.9490 ,3.8470>, 0.1000
<0.8219 ,-1.4235 ,5.7704>, 0.4000
}
cone {
<0.4213 ,-1.0171 ,3.8455>, 0.1000
<0.6320 ,-1.5256 ,5.7683>, 0.4000
}
cone {
<0.2863 ,-1.0682 ,3.8441>, 0.1000
<0.4294 ,-1.6023 ,5.7661>, 0.4000
}
cone {
<0.1450 ,-1.1014 ,3.8426>, 0.1000
<0.2176 ,-1.6521 ,5.7639>, 0.4000
}
cone {
<0.0000 ,-1.1160 ,3.8412>, 0.1000
<0.0001 ,-1.6739 ,5.7618>, 0.4000
}
cone {
<-0.1463 ,-1.1114 ,3.8397>, 0.1000
<-0.2194 ,-1.6671 ,5.7596>, 0.4000
}
cone {
<-0.2914 ,-1.0877 ,3.8382>, 0.1000
<-0.4371 ,-1.6315 ,5.7574>, 0.4000
}
cone {
<-0.4328 ,-1.0450 ,3.8368>, 0.1000
<-0.6492 ,-1.5674 ,5.7551>, 0.4000
}
cone {
<-0.5680 ,-0.9839 ,3.8353>, 0.1000
<-0.8520 ,-1.4758 ,5.7529>, 0.4000
}
cone {
<-0.6946 ,-0.9053 ,3.8338>, 0.1000
<-1.0419 ,-1.3579 ,5.7507>, 0.4000
}
cone {
<-0.8104 ,-0.8104 ,3.8323>, 0.1000
<-1.2156 ,-1.2157 ,5.7484>, 0.4000
}
cone {
<-0.9132 ,-0.7008 ,3.8308>, 0.1000
<-1.3698 ,-1.0512 ,5.7462>, 0.4000
}
cone {
<-1.0012 ,-0.5781 ,3.8293>, 0.1000
<-1.5018 ,-0.8671 ,5.7439>, 0.4000
}
cone {
<-1.0727 ,-0.4444 ,3.8278>, 0.1000
<-1.6091 ,-0.6666 ,5.7416>, 0.4000
}
cone {
<-1.1264 ,-0.3018 ,3.8262>, 0.1000
<-1.6896 ,-0.4528 ,5.7394>, 0.4000
}
cone {
<-1.1611 ,-0.1529 ,3.8247>, 0.1000
<-1.7417 ,-0.2293 ,5.7371>, 0.4000
}
cone {
<-1.1762 ,-0.0000 ,3.8232>, 0.1000
<-1.7642 ,-0.0000 ,5.7348>, 0.4000
}
cone {
<-1.1711 ,0.1542 ,3.8216>, 0.1000
<-1.7566 ,0.2312 ,5.7324>, 0.4000
}
cone {
<-1.1458 ,0.3070 ,3.8201>, 0.1000
<-1.7186 ,0.4605 ,5.7301>, 0.4000
}
cone {
<-1.1005 ,0.4558 ,3.8185>, 0.1000
<-1.6508 ,0.6837 ,5.7278>, 0.4000
}
cone {
<-1.0359 ,0.5981 ,3.8170>, 0.1000
<-1.5539 ,0.8971 ,5.7254>, 0.4000
}
cone {
<-0.9530 ,0.7312 ,3.8154>, 0.1000
<-1.4294 ,1.0968 ,5.7231>, 0.4000
}
cone {
<-0.8529 ,0.8529 ,3.8138>, 0.1000
<-1.2793 ,1.2793 ,5.7207>, 0.4000
}
cone {
<-0.7373 ,0.9609 ,3.8122>, 0.1000
<-1.1060 ,1.4413 ,5.7184>, 0.4000
}
cone {
<-0.6081 ,1.0532 ,3.8106>, 0.1000
<-0.9121 ,1.5798 ,5.7160>, 0.4000
}
cone {
<-0.4673 ,1.1282 ,3.8091>, 0.1000
<-0.7010 ,1.6922 ,5.7136>, 0.4000
}
cone {
<-0.3173 ,1.1843 ,3.8074>, 0.1000
<-0.4760 ,1.7765 ,5.7112>, 0.4000
}
cone {
<-0.1607 ,1.2206 ,3.8058>, 0.1000
<-0.2410 ,1.8308 ,5.7088>, 0.4000
}
cone {
<-0.0000 ,1.2361 ,3.8042>, 0.1000
<-0.0000 ,1.8541 ,5.7063>, 0.4000
}
cone {
<0.1620 ,1.2304 ,3.8026>, 0.1000
<0.2430 ,1.8456 ,5.7039>, 0.4000
}
cone {
<0.3225 ,1.2036 ,3.8010>, 0.1000
<0.4837 ,1.8053 ,5.7015>, 0.4000
}
cone {
<0.4787 ,1.1558 ,3.7993>, 0.1000
<0.7181 ,1.7337 ,5.6990>, 0.4000
}
cone {
<0.6280 ,1.0877 ,3.7977>, 0.1000
<0.9420 ,1.6316 ,5.6966>, 0.4000
}
cone {
<0.7676 ,1.0004 ,3.7961>, 0.1000
<1.1514 ,1.5006 ,5.6941>, 0.4000
}
cone {
<0.8951 ,0.8951 ,3.7944>, 0.1000
<1.3427 ,1.3427 ,5.6916>, 0.4000
}
cone {
<1.0083 ,0.7737 ,3.7927>, 0.1000
<1.5124 ,1.1605 ,5.6891>, 0.4000
}
cone {
<1.1049 ,0.6379 ,3.7911>, 0.1000
<1.6574 ,0.9569 ,5.6866>, 0.4000
}
cone {
<1.1833 ,0.4901 ,3.7894>, 0.1000
<1.7750 ,0.7352 ,5.6841>, 0.4000
}
cone {
<1.2420 ,0.3328 ,3.7877>, 0.1000
<1.8629 ,0.4991 ,5.6816>, 0.4000
}
cone {
<1.2797 ,0.1685 ,3.7860>, 0.1000
<1.9195 ,0.2527 ,5.6791>, 0.4000
}
cone {
<1.2957 ,-0.0000 ,3.7843>, 0.1000
<1.9435 ,-0.0000 ,5.6765>, 0.4000
}
cone {
<1.2895 ,-0.1698 ,3.7826>, 0.1000
<1.9342 ,-0.2547 ,5.6740>, 0.4000
}
cone {
<1.2611 ,-0.3379 ,3.7809>, 0.1000
<1.8916 ,-0.5069 ,5.6714>, 0.4000
}
cone {
<1.2108 ,-0.5015 ,3.7792>, 0.1000
<1.8161 ,-0.7523 ,5.6688>, 0.4000
}
cone {
<1.1392 ,-0.6578 ,3.7775>, 0.1000
<1.7088 ,-0.9866 ,5.6663>, 0.4000
}
cone {
<1.0475 ,-0.8038 ,3.7758>, 0.1000
<1.5713 ,-1.2058 ,5.6637>, 0.4000
}
cone {
<0.9371 ,-0.9372 ,3.7740>, 0.1000
<1.4057 ,-1.4058 ,5.6611>, 0.4000
}
cone {
<0.8098 ,-1.0554 ,3.7723>, 0.1000
<1.2147 ,-1.5831 ,5.6585>, 0.4000
}
cone {
<0.6676 ,-1.1564 ,3.7706>, 0.1000
<1.0014 ,-1.7345 ,5.6558>, 0.4000
}
cone {
<0.5128 ,-1.2382 ,3.7688>, 0.1000
<0.7692 ,-1.8572 ,5.6532>, 0.4000
}
cone {
<0.3481 ,-1.2993 ,3.7671>, 0.1000
<0.5222 ,-1.9489 ,5.6506>, 0.4000
}
cone {
<0.1762 ,-1.3385 ,3.7653>, 0.1000
<0.2643 ,-2.0077 ,5.6479>, 0.4000
}
cone {
<-0.0000 ,-1.3550 ,3.7635>, 0.1000
<-0.0001 ,-2.0324 ,5.6453>, 0.4000
}
cone {
<-0.1775 ,-1.3482 ,3.7617>, 0.1000
<-0.2663 ,-2.0224 ,5.6426>, 0.4000
}
cone {
<-0.3533 ,-1.3183 ,3.7600>, 0.1000
<-0.5299 ,-1.9774 ,5.6399>, 0.4000
}
cone {
<-0.5242 ,-1.2654 ,3.7582>, 0.1000
<-0.7863 ,-1.8982 ,5.6373>, 0.4000
}
cone {
<-0.6874 ,-1.1904 ,3.7564>, 0.1000
<-1.0310 ,-1.7857 ,5.6346>, 0.4000
}
cone {
<-0.8399 ,-1.0944 ,3.7546>, 0.1000
<-1.2598 ,-1.6417 ,5.6319>, 0.4000
}
cone {
<-0.9790 ,-0.9789 ,3.7528>, 0.1000
<-1.4685 ,-1.4684 ,5.6291>, 0.4000
}
cone {
<-1.1023 ,-0.8458 ,3.7509>, 0.1000
<-1.6535 ,-1.2686 ,5.6264>, 0.4000
}
cone {
<-1.2075 ,-0.6971 ,3.7491>, 0.1000
<-1.8113 ,-1.0456 ,5.6237>, 0.4000
}
cone {
<-1.2927 ,-0.5354 ,3.7473>, 0.1000
<-1.9391 ,-0.8031 ,5.6209>, 0.4000
}
cone {
<-1.3563 ,-0.3633 ,3.7455>, 0.1000
<-2.0344 ,-0.5450 ,5.6182>, 0.4000
}
cone {
<-1.3970 ,-0.1838 ,3.7436>, 0.1000
<-2.0954 ,-0.2758 ,5.6154>, 0.4000
}
cone {
<-1.4139 ,0.0001 ,3.7418>, 0.1000
<-2.1209 ,0.0001 ,5.6127>, 0.4000
}
cone {
<-1.4067 ,0.1853 ,3.7399>, 0.1000
<-2.1100 ,0.2779 ,5.6099>, 0.4000
}
cone {
<-1.3752 ,0.3685 ,3.7381>, 0.1000
<-2.0627 ,0.5528 ,5.6071>, 0.4000
}
cone {
<-1.3198 ,0.5468 ,3.7362>, 0.1000
<-1.9797 ,0.8201 ,5.6043>, 0.4000
}
cone {
<-1.2414 ,0.7168 ,3.7343>, 0.1000
<-1.8621 ,1.0752 ,5.6015>, 0.4000
}
cone {
<-1.1411 ,0.8757 ,3.7324>, 0.1000
<-1.7116 ,1.3135 ,5.5987>, 0.4000
}
cone {
<-1.0205 ,1.0206 ,3.7306>, 0.1000
<-1.5307 ,1.5309 ,5.5958>, 0.4000
}
cone {
<-0.8815 ,1.1489 ,3.7287>, 0.1000
<-1.3223 ,1.7234 ,5.5930>, 0.4000
}
cone {
<-0.7264 ,1.2584 ,3.7268>, 0.1000
<-1.0896 ,1.8876 ,5.5901>, 0.4000
}
cone {
<-0.5578 ,1.3469 ,3.7249>, 0.1000
<-0.8367 ,2.0204 ,5.5873>, 0.4000
}
cone {
<-0.3785 ,1.4129 ,3.7229>, 0.1000
<-0.5678 ,2.1194 ,5.5844>, 0.4000
}
cone {
<-0.1915 ,1.4551 ,3.7210>, 0.1000
<-0.2872 ,2.1826 ,5.5815>, 0.4000
}
cone {
<0.0001 ,1.4725 ,3.7191>, 0.1000
<0.0001 ,2.2088 ,5.5787>, 0.4000
}
cone {
<0.1929 ,1.4647 ,3.7172>, 0.1000
<0.2894 ,2.1971 ,5.5758>, 0.4000
}
cone {
<0.3837 ,1.4317 ,3.7152>, 0.1000
<0.5756 ,2.1476 ,5.5729>, 0.4000
}
cone {
<0.5692 ,1.3739 ,3.7133>, 0.1000
<0.8538 ,2.0608 ,5.5699>, 0.4000
}
cone {
<0.7461 ,1.2920 ,3.7113>, 0.1000
<1.1191 ,1.9380 ,5.5670>, 0.4000
}
cone {
<0.9113 ,1.1874 ,3.7094>, 0.1000
<1.3669 ,1.7812 ,5.5641>, 0.4000
}
cone {
<1.0619 ,1.0618 ,3.7074>, 0.1000
<1.5929 ,1.5926 ,5.5611>, 0.4000
}
cone {
<1.1953 ,0.9170 ,3.7055>, 0.1000
<1.7929 ,1.3755 ,5.5582>, 0.4000
}
cone {
<1.3089 ,0.7556 ,3.7035>, 0.1000
<1.9634 ,1.1334 ,5.5552>, 0.4000
}
cone {
<1.4008 ,0.5801 ,3.7015>, 0.1000
<2.1013 ,0.8702 ,5.5522>, 0.4000
}
cone {
<1.4693 ,0.3936 ,3.6995>, 0.1000
<2.2039 ,0.5903 ,5.5493>, 0.4000
}
cone {
<1.5129 ,0.1991 ,3.6975>, 0.1000
<2.2693 ,0.2986 ,5.5463>, 0.4000
}
cone {
<1.5307 ,-0.0001 ,3.6955>, 0.1000
<2.2961 ,-0.0002 ,5.5433>, 0.4000
}
cone {
<1.5224 ,-0.2006 ,3.6935>, 0.1000
<2.2836 ,-0.3008 ,5.5403>, 0.4000
}
cone {
<1.4879 ,-0.3988 ,3.6915>, 0.1000
<2.2318 ,-0.5982 ,5.5372>, 0.4000
}
cone {
<1.4276 ,-0.5915 ,3.6895>, 0.1000
<2.1413 ,-0.8872 ,5.5342>, 0.4000
}
cone {
<1.3423 ,-0.7751 ,3.6875>, 0.1000
<2.0135 ,-1.1627 ,5.5312>, 0.4000
}
cone {
<1.2335 ,-0.9467 ,3.6854>, 0.1000
<1.8502 ,-1.4200 ,5.5281>, 0.4000
}
cone {
<1.1028 ,-1.1030 ,3.6834>, 0.1000
<1.6542 ,-1.6545 ,5.5251>, 0.4000
}
cone {
<0.9523 ,-1.2413 ,3.6813>, 0.1000
<1.4285 ,-1.8620 ,5.5220>, 0.4000
}
cone {
<0.7846 ,-1.3592 ,3.6793>, 0.1000
<1.1768 ,-2.0388 ,5.5189>, 0.4000
}
cone {
<0.6023 ,-1.4544 ,3.6772>, 0.1000
<0.9034 ,-2.1816 ,5.5158>, 0.4000
}
cone {
<0.4085 ,-1.5252 ,3.6752>, 0.1000
<0.6128 ,-2.2878 ,5.5127>, 0.4000
}
cone {
<0.2066 ,-1.5703 ,3.6731>, 0.1000
<0.3099 ,-2.3554 ,5.5096>, 0.4000
}
cone {
<-0.0002 ,-1.5886 ,3.6710>, 0.1000
<-0.0002 ,-2.3829 ,5.5065>, 0.4000
}
cone {
<-0.2081 ,-1.5797 ,3.6689>, 0.1000
<-0.3122 ,-2.3696 ,5.5034>, 0.4000
}
cone {
<-0.4138 ,-1.5437 ,3.6668>, 0.1000
<-0.6207 ,-2.3156 ,5.5003>, 0.4000
}
cone {
<-0.6136 ,-1.4809 ,3.6648>, 0.1000
<-0.9204 ,-2.2214 ,5.4971>, 0.4000
}
cone {
<-0.8040 ,-1.3923 ,3.6626>, 0.1000
<-1.2061 ,-2.0885 ,5.4940>, 0.4000
}
cone {
<-0.9818 ,-1.2793 ,3.6605>, 0.1000
<-1.4727 ,-1.9189 ,5.4908>, 0.4000
}
cone {
<-1.1438 ,-1.1435 ,3.6584>, 0.1000
<-1.7157 ,-1.7153 ,5.4876>, 0.4000
}
cone {
<-1.2871 ,-0.9874 ,3.6563>, 0.1000
<-1.9306 ,-1.4811 ,5.4845>, 0.4000
}
cone {
<-1.4091 ,-0.8133 ,3.6542>, 0.1000
<-2.1136 ,-1.2200 ,5.4813>, 0.4000
}
cone {
<-1.5076 ,-0.6243 ,3.6520>, 0.1000
<-2.2614 ,-0.9364 ,5.4781>, 0.4000
}
cone {
<-1.5808 ,-0.4234 ,3.6499>, 0.1000
<-2.3712 ,-0.6351 ,5.4749>, 0.4000
}
cone {
<-1.6273 ,-0.2141 ,3.6478>, 0.1000
<-2.4409 ,-0.3211 ,5.4716>, 0.4000
}
cone {
<-1.6461 ,0.0002 ,3.6456>, 0.1000
<-2.4691 ,0.0003 ,5.4684>, 0.4000
}
cone {
<-1.6367 ,0.2157 ,3.6435>, 0.1000
<-2.4550 ,0.3235 ,5.4652>, 0.4000
}
cone {
<-1.5991 ,0.4287 ,3.6413>, 0.1000
<-2.3987 ,0.6430 ,5.4619>, 0.4000
}
cone {
<-1.5339 ,0.6356 ,3.6391>, 0.1000
<-2.3009 ,0.9534 ,5.4587>, 0.4000
}
cone {
<-1.4419 ,0.8327 ,3.6369>, 0.1000
<-2.1629 ,1.2491 ,5.4554>, 0.4000
}
cone {
<-1.3247 ,1.0167 ,3.6348>, 0.1000
<-1.9870 ,1.5251 ,5.4521>, 0.4000
}
cone {
<-1.1840 ,1.1843 ,3.6326>, 0.1000
<-1.7760 ,1.7764 ,5.4489>, 0.4000
}
cone {
<-1.0222 ,1.3325 ,3.6304>, 0.1000
<-1.5333 ,1.9987 ,5.4456>, 0.4000
}
cone {
<-0.8419 ,1.4586 ,3.6282>, 0.1000
<-1.2628 ,2.1879 ,5.4423>, 0.4000
}
cone {
<-0.6461 ,1.5604 ,3.6260>, 0.1000
<-0.9692 ,2.3406 ,5.4389>, 0.4000
}
cone {
<-0.4381 ,1.6360 ,3.6238>, 0.1000
<-0.6572 ,2.4540 ,5.4356>, 0.4000
}
cone {
<-0.2215 ,1.6839 ,3.6215>, 0.1000
<-0.3322 ,2.5258 ,5.4323>, 0.4000
}
cone {
<0.0002 ,1.7031 ,3.6193>, 0.1000
<0.0003 ,2.5547 ,5.4290>, 0.4000
}
cone {
<0.2231 ,1.6932 ,3.6171>, 0.1000
<0.3347 ,2.5398 ,5.4256>, 0.4000
}
cone {
<0.4435 ,1.6542 ,3.6148>, 0.1000
<0.6652 ,2.4813 ,5.4223>, 0.4000
}
cone {
<0.6574 ,1.5865 ,3.6126>, 0.1000
<0.9861 ,2.3798 ,5.4189>, 0.4000
}
cone {
<0.8612 ,1.4912 ,3.6103>, 0.1000
<1.2918 ,2.2368 ,5.4155>, 0.4000
}
cone {
<1.0514 ,1.3698 ,3.6081>, 0.1000
<1.5771 ,2.0547 ,5.4121>, 0.4000
}
cone {
<1.2245 ,1.2242 ,3.6058>, 0.1000
<1.8368 ,1.8363 ,5.4087>, 0.4000
}
cone {
<1.3776 ,1.0568 ,3.6035>, 0.1000
<2.0664 ,1.5851 ,5.4053>, 0.4000
}
cone {
<1.5078 ,0.8703 ,3.6013>, 0.1000
<2.2617 ,1.3054 ,5.4019>, 0.4000
}
cone {
<1.6129 ,0.6678 ,3.5990>, 0.1000
<2.4193 ,1.0017 ,5.3985>, 0.4000
}
cone {
<1.6908 ,0.4528 ,3.5967>, 0.1000
<2.5362 ,0.6792 ,5.3951>, 0.4000
}
cone {
<1.7401 ,0.2288 ,3.5944>, 0.1000
<2.6101 ,0.3432 ,5.3916>, 0.4000
}
cone {
<1.7598 ,-0.0003 ,3.5921>, 0.1000
<2.6396 ,-0.0004 ,5.3882>, 0.4000
}
cone {
<1.7493 ,-0.2306 ,3.5898>, 0.1000
<2.6240 ,-0.3458 ,5.3847>, 0.4000
}
cone {
<1.7088 ,-0.4581 ,3.5875>, 0.1000
<2.5632 ,-0.6872 ,5.3812>, 0.4000
}
cone {
<1.6387 ,-0.6791 ,3.5852>, 0.1000
<2.4581 ,-1.0186 ,5.3778>, 0.4000
}
cone {
<1.5401 ,-0.8895 ,3.5828>, 0.1000
<2.3102 ,-1.3343 ,5.3743>, 0.4000
}
cone {
<1.4146 ,-1.0858 ,3.5805>, 0.1000
<2.1219 ,-1.6287 ,5.3708>, 0.4000
}
cone {
<1.2641 ,-1.2644 ,3.5782>, 0.1000
<1.8961 ,-1.8967 ,5.3673>, 0.4000
}
cone {
<1.0910 ,-1.4223 ,3.5758>, 0.1000
<1.6366 ,-2.1335 ,5.3637>, 0.4000
}
cone {
<0.8984 ,-1.5566 ,3.5735>, 0.1000
<1.3476 ,-2.3349 ,5.3602>, 0.4000
}
cone {
<0.6893 ,-1.6649 ,3.5711>, 0.1000
<1.0340 ,-2.4974 ,5.3567>, 0.4000
}
cone {
<0.4673 ,-1.7451 ,3.5688>, 0.1000
<0.7010 ,-2.6177 ,5.3531>, 0.4000
}
cone {
<0.2361 ,-1.7958 ,3.5664>, 0.1000
<0.3542 ,-2.6938 ,5.3496>, 0.4000
}
cone {
<-0.0003 ,-1.8160 ,3.5640>, 0.1000
<-0.0004 ,-2.7240 ,5.3460>, 0.4000
}
cone {
<-0.2379 ,-1.8050 ,3.5616>, 0.1000
<-0.3569 ,-2.7075 ,5.3425>, 0.4000
}
cone {
<-0.4727 ,-1.7630 ,3.5593>, 0.1000
<-0.7091 ,-2.6445 ,5.3389>, 0.4000
}
cone {
<-0.7006 ,-1.6905 ,3.5569>, 0.1000
<-1.0509 ,-2.5358 ,5.3353>, 0.4000
}
cone {
<-0.9176 ,-1.5887 ,3.5545>, 0.1000
<-1.3764 ,-2.3830 ,5.3317>, 0.4000
}
cone {
<-1.1199 ,-1.4590 ,3.5521>, 0.1000
<-1.6799 ,-2.1885 ,5.3281>, 0.4000
}
cone {
<-1.3041 ,-1.3036 ,3.5497>, 0.1000
<-1.9561 ,-1.9554 ,5.3245>, 0.4000
}
cone {
<-1.4667 ,-1.1251 ,3.5472>, 0.1000
<-2.2001 ,-1.6876 ,5.3209>, 0.4000
}
cone {
<-1.6051 ,-0.9263 ,3.5448>, 0.1000
<-2.4076 ,-1.3895 ,5.3172>, 0.4000
}
cone {
<-1.7165 ,-0.7107 ,3.5424>, 0.1000
<-2.5748 ,-1.0660 ,5.3136>, 0.4000
}
cone {
<-1.7991 ,-0.4817 ,3.5399>, 0.1000
<-2.6986 ,-0.7226 ,5.3099>, 0.4000
}
cone {
<-1.8512 ,-0.2434 ,3.5375>, 0.1000
<-2.7767 ,-0.3651 ,5.3063>, 0.4000
}
cone {
<-1.8717 ,0.0003 ,3.5351>, 0.1000
<-2.8076 ,0.0005 ,5.3026>, 0.4000
}
cone {
<-1.8603 ,0.2452 ,3.5326>, 0.1000
<-2.7904 ,0.3679 ,5.2989>, 0.4000
}
cone {
<-1.8168 ,0.4872 ,3.5301>, 0.1000
<-2.7252 ,0.7307 ,5.2952>, 0.4000
}
cone {
<-1.7419 ,0.7219 ,3.5277>, 0.1000
<-2.6129 ,1.0829 ,5.2915>, 0.4000
}
cone {
<-1.6368 ,0.9454 ,3.5252>, 0.1000
<-2.4552 ,1.4181 ,5.2878>, 0.4000
}
cone {
<-1.5031 ,1.1538 ,3.5227>, 0.1000
<-2.2546 ,1.7307 ,5.2841>, 0.4000
}
cone {
<-1.3429 ,1.3434 ,3.5202>, 0.1000
<-2.0143 ,2.0150 ,5.2804>, 0.4000
}
cone {
<-1.1588 ,1.5108 ,3.5178>, 0.1000
<-1.7382 ,2.2662 ,5.2766>, 0.4000
}
cone {
<-0.9540 ,1.6531 ,3.5153>, 0.1000
<-1.4310 ,2.4797 ,5.2729>, 0.4000
}
cone {
<-0.7318 ,1.7677 ,3.5128>, 0.1000
<-1.0977 ,2.6516 ,5.2691>, 0.4000
}
cone {
<-0.4960 ,1.8526 ,3.5103>, 0.1000
<-0.7440 ,2.7789 ,5.2654>, 0.4000
}
cone {
<-0.2506 ,1.9060 ,3.5077>, 0.1000
<-0.3758 ,2.8590 ,5.2616>, 0.4000
}
cone {
<0.0004 ,1.9270 ,3.5052>, 0.1000
<0.0006 ,2.8905 ,5.2578>, 0.4000
}
cone {
<0.2525 ,1.9150 ,3.5027>, 0.1000
<0.3787 ,2.8726 ,5.2540>, 0.4000
}
cone {
<0.5015 ,1.8701 ,3.5002>, 0.1000
<0.7522 ,2.8052 ,5.2502>, 0.4000
}
cone {
<0.7431 ,1.7929 ,3.4976>, 0.1000
<1.1146 ,2.6893 ,5.2464>, 0.4000
}
cone {
<0.9730 ,1.6845 ,3.4951>, 0.1000
<1.4595 ,2.5268 ,5.2426>, 0.4000
}
cone {
<1.1873 ,1.5467 ,3.4925>, 0.1000
<1.7810 ,2.3201 ,5.2388>, 0.4000
}
cone {
<1.3823 ,1.3818 ,3.4900>, 0.1000
<2.0735 ,2.0726 ,5.2350>, 0.4000
}
cone {
<1.5545 ,1.1923 ,3.4874>, 0.1000
<2.3317 ,1.7884 ,5.2311>, 0.4000
}
cone {
<1.7007 ,0.9815 ,3.4849>, 0.1000
<2.5511 ,1.4722 ,5.2273>, 0.4000
}
cone {
<1.8185 ,0.7528 ,3.4823>, 0.1000
<2.7278 ,1.1292 ,5.2234>, 0.4000
}
cone {
<1.9056 ,0.5102 ,3.4797>, 0.1000
<2.8584 ,0.7653 ,5.2195>, 0.4000
}
cone {
<1.9604 ,0.2577 ,3.4771>, 0.1000
<2.9406 ,0.3865 ,5.2157>, 0.4000
}
cone {
<1.9818 ,-0.0004 ,3.4745>, 0.1000
<2.9728 ,-0.0006 ,5.2118>, 0.4000
}
cone {
<1.9693 ,-0.2597 ,3.4719>, 0.1000
<2.9540 ,-0.3895 ,5.2079>, 0.4000
}
cone {
<1.9230 ,-0.5157 ,3.4693>, 0.1000
<2.8845 ,-0.7736 ,5.2040>, 0.4000
}
cone {
<1.8434 ,-0.7640 ,3.4667>, 0.1000
<2.7651 ,-1.1460 ,5.2001>, 0.4000
}
cone {
<1.7318 ,-1.0004 ,3.4641>, 0.1000
<2.5978 ,-1.5006 ,5.1961>, 0.4000
}
cone {
<1.5900 ,-1.2206 ,3.4615>, 0.1000
<2.3851 ,-1.8309 ,5.1922>, 0.4000
}
cone {
<1.4203 ,-1.4209 ,3.4588>, 0.1000
<2.1305 ,-2.1314 ,5.1883>, 0.4000
}
cone {
<1.2254 ,-1.5978 ,3.4562>, 0.1000
<1.8382 ,-2.3966 ,5.1843>, 0.4000
}
cone {
<1.0087 ,-1.7480 ,3.4536>, 0.1000
<1.5130 ,-2.6219 ,5.1804>, 0.4000
}
cone {
<0.7736 ,-1.8688 ,3.4509>, 0.1000
<1.1604 ,-2.8033 ,5.1764>, 0.4000
}
cone {
<0.5242 ,-1.9582 ,3.4483>, 0.1000
<0.7863 ,-2.9373 ,5.1724>, 0.4000
}
cone {
<0.2647 ,-2.0143 ,3.4456>, 0.1000
<0.3971 ,-3.0215 ,5.1684>, 0.4000
}
cone {
<-0.0005 ,-2.0362 ,3.4430>, 0.1000
<-0.0007 ,-3.0543 ,5.1644>, 0.4000
}
cone {
<-0.2668 ,-2.0232 ,3.4403>, 0.1000
<-0.4002 ,-3.0347 ,5.1604>, 0.4000
}
cone {
<-0.5298 ,-1.9754 ,3.4376>, 0.1000
<-0.7947 ,-2.9631 ,5.1564>, 0.4000
}
cone {
<-0.7848 ,-1.8935 ,3.4349>, 0.1000
<-1.1772 ,-2.8402 ,5.1524>, 0.4000
}
cone {
<-1.0275 ,-1.7787 ,3.4323>, 0.1000
<-1.5413 ,-2.6681 ,5.1484>, 0.4000
}
cone {
<-1.2536 ,-1.6330 ,3.4296>, 0.1000
<-1.8804 ,-2.4494 ,5.1443>, 0.4000
}
cone {
<-1.4592 ,-1.4585 ,3.4269>, 0.1000
<-2.1888 ,-2.1878 ,5.1403>, 0.4000
}
cone {
<-1.6407 ,-1.2583 ,3.4242>, 0.1000
<-2.4610 ,-1.8875 ,5.1362>, 0.4000
}
cone {
<-1.7948 ,-1.0356 ,3.4215>, 0.1000
<-2.6921 ,-1.5534 ,5.1322>, 0.4000
}
cone {
<-1.9187 ,-0.7942 ,3.4187>, 0.1000
<-2.8781 ,-1.1913 ,5.1281>, 0.4000
}
cone {
<-2.0103 ,-0.5381 ,3.4160>, 0.1000
<-3.0154 ,-0.8072 ,5.1240>, 0.4000
}
cone {
<-2.0678 ,-0.2717 ,3.4133>, 0.1000
<-3.1016 ,-0.4076 ,5.1199>, 0.4000
}
cone {
<-2.0900 ,0.0005 ,3.4106>, 0.1000
<-3.1350 ,0.0008 ,5.1158>, 0.4000
}
cone {
<-2.0765 ,0.2739 ,3.4078>, 0.1000
<-3.1147 ,0.4108 ,5.1117>, 0.4000
}
cone {
<-2.0273 ,0.5437 ,3.4051>, 0.1000
<-3.0409 ,0.8156 ,5.1076>, 0.4000
}
cone {
<-1.9431 ,0.8054 ,3.4023>, 0.1000
<-2.9146 ,1.2081 ,5.1035>, 0.4000
}
cone {
<-1.8252 ,1.0544 ,3.3996>, 0.1000
<-2.7378 ,1.5816 ,5.0993>, 0.4000
}
cone {
<-1.6755 ,1.2863 ,3.3968>, 0.1000
<-2.5132 ,1.9294 ,5.0952>, 0.4000
}
cone {
<-1.4964 ,1.4971 ,3.3940>, 0.1000
<-2.2446 ,2.2457 ,5.0911>, 0.4000
}
cone {
<-1.2909 ,1.6832 ,3.3913>, 0.1000
<-1.9363 ,2.5247 ,5.0869>, 0.4000
}
cone {
<-1.0623 ,1.8411 ,3.3885>, 0.1000
<-1.5935 ,2.7616 ,5.0827>, 0.4000
}
cone {
<-0.8146 ,1.9681 ,3.3857>, 0.1000
<-1.2219 ,2.9522 ,5.0785>, 0.4000
}
cone {
<-0.5519 ,2.0619 ,3.3829>, 0.1000
<-0.8279 ,3.0928 ,5.0744>, 0.4000
}
cone {
<-0.2786 ,2.1207 ,3.3801>, 0.1000
<-0.4179 ,3.1810 ,5.0702>, 0.4000
}
cone {
<0.0006 ,2.1433 ,3.3773>, 0.1000
<0.0008 ,3.2150 ,5.0660>, 0.4000
}
cone {
<0.2809 ,2.1293 ,3.3745>, 0.1000
<0.4213 ,3.1939 ,5.0617>, 0.4000
}
cone {
<0.5576 ,2.0787 ,3.3717>, 0.1000
<0.8363 ,3.1180 ,5.0575>, 0.4000
}
cone {
<0.8258 ,1.9922 ,3.3689>, 0.1000
<1.2387 ,2.9883 ,5.0533>, 0.4000
}
cone {
<1.0810 ,1.8712 ,3.3660>, 0.1000
<1.6215 ,2.8068 ,5.0491>, 0.4000
}
cone {
<1.3187 ,1.7176 ,3.3632>, 0.1000
<1.9780 ,2.5763 ,5.0448>, 0.4000
}
cone {
<1.5347 ,1.5339 ,3.3604>, 0.1000
<2.3020 ,2.3008 ,5.0406>, 0.4000
}
cone {
<1.7252 ,1.3231 ,3.3575>, 0.1000
<2.5879 ,1.9846 ,5.0363>, 0.4000
}
cone {
<1.8870 ,1.0888 ,3.3547>, 0.1000
<2.8305 ,1.6332 ,5.0320>, 0.4000
}
cone {
<2.0170 ,0.8348 ,3.3518>, 0.1000
<3.0255 ,1.2522 ,5.0277>, 0.4000
}
cone {
<2.1130 ,0.5655 ,3.3490>, 0.1000
<3.1694 ,0.8483 ,5.0234>, 0.4000
}
cone {
<2.1731 ,0.2855 ,3.3461>, 0.1000
<3.2596 ,0.4282 ,5.0191>, 0.4000
}
cone {
<2.1961 ,-0.0006 ,3.3432>, 0.1000
<3.2942 ,-0.0009 ,5.0148>, 0.4000
}
cone {
<2.1816 ,-0.2878 ,3.3403>, 0.1000
<3.2724 ,-0.4317 ,5.0105>, 0.4000
}
cone {
<2.1296 ,-0.5713 ,3.3375>, 0.1000
<3.1943 ,-0.8569 ,5.0062>, 0.4000
}
cone {
<2.0408 ,-0.8460 ,3.3346>, 0.1000
<3.0612 ,-1.2690 ,5.0019>, 0.4000
}
cone {
<1.9167 ,-1.1073 ,3.3317>, 0.1000
<2.8751 ,-1.6610 ,4.9975>, 0.4000
}
cone {
<1.7592 ,-1.3507 ,3.3288>, 0.1000
<2.6388 ,-2.0260 ,4.9932>, 0.4000
}
cone {
<1.5709 ,-1.5718 ,3.3259>, 0.1000
<2.3564 ,-2.3578 ,4.9888>, 0.4000
}
cone {
<1.3550 ,-1.7669 ,3.3230>, 0.1000
<2.0325 ,-2.6504 ,4.9844>, 0.4000
}
cone {
<1.1149 ,-1.9324 ,3.3200>, 0.1000
<1.6724 ,-2.8986 ,4.9801>, 0.4000
}
cone {
<0.8548 ,-2.0654 ,3.3171>, 0.1000
<1.2822 ,-3.0981 ,4.9757>, 0.4000
}
cone {
<0.5790 ,-2.1635 ,3.3142>, 0.1000
<0.8686 ,-3.2453 ,4.9713>, 0.4000
}
cone {
<0.2923 ,-2.2249 ,3.3113>, 0.1000
<0.4384 ,-3.3373 ,4.9669>, 0.4000
}
cone {
<-0.0007 ,-2.2483 ,3.3083>, 0.1000
<-0.0010 ,-3.3725 ,4.9625>, 0.4000
}
cone {
<-0.2947 ,-2.2333 ,3.3054>, 0.1000
<-0.4420 ,-3.3500 ,4.9581>, 0.4000
}
cone {
<-0.5848 ,-2.1799 ,3.3024>, 0.1000
<-0.8772 ,-3.2699 ,4.9536>, 0.4000
}
cone {
<-0.8660 ,-2.0889 ,3.2995>, 0.1000
<-1.2990 ,-3.1334 ,4.9492>, 0.4000
}
cone {
<-1.1334 ,-1.9618 ,3.2965>, 0.1000
<-1.7001 ,-2.9426 ,4.9447>, 0.4000
}
cone {
<-1.3824 ,-1.8005 ,3.2935>, 0.1000
<-2.0736 ,-2.7007 ,4.9403>, 0.4000
}
cone {
<-1.6086 ,-1.6077 ,3.2906>, 0.1000
<-2.4129 ,-2.4115 ,4.9358>, 0.4000
}
cone {
<-1.8081 ,-1.3866 ,3.2876>, 0.1000
<-2.7122 ,-2.0798 ,4.9314>, 0.4000
}
cone {
<-1.9774 ,-1.1408 ,3.2846>, 0.1000
<-2.9660 ,-1.7112 ,4.9269>, 0.4000
}
cone {
<-2.1133 ,-0.8746 ,3.2816>, 0.1000
<-3.1700 ,-1.3119 ,4.9224>, 0.4000
}
cone {
<-2.2136 ,-0.5924 ,3.2786>, 0.1000
<-3.3203 ,-0.8886 ,4.9179>, 0.4000
}
cone {
<-2.2762 ,-0.2990 ,3.2756>, 0.1000
<-3.4143 ,-0.4484 ,4.9134>, 0.4000
}
cone {
<-2.3000 ,0.0007 ,3.2726>, 0.1000
<-3.4500 ,0.0011 ,4.9089>, 0.4000
}
cone {
<-2.2845 ,0.3015 ,3.2696>, 0.1000
<-3.4268 ,0.4522 ,4.9044>, 0.4000
}
cone {
<-2.2297 ,0.5982 ,3.2666>, 0.1000
<-3.3446 ,0.8973 ,4.8998>, 0.4000
}
cone {
<-2.1365 ,0.8858 ,3.2635>, 0.1000
<-3.2048 ,1.3286 ,4.8953>, 0.4000
}
cone {
<-2.0063 ,1.1592 ,3.2605>, 0.1000
<-3.0095 ,1.7388 ,4.8908>, 0.4000
}
cone {
<-1.8412 ,1.4138 ,3.2575>, 0.1000
<-2.7619 ,2.1206 ,4.8862>, 0.4000
}
cone {
<-1.6440 ,1.6450 ,3.2544>, 0.1000
<-2.4660 ,2.4675 ,4.8816>, 0.4000
}
cone {
<-1.4178 ,1.8489 ,3.2514>, 0.1000
<-2.1267 ,2.7734 ,4.8771>, 0.4000
}
cone {
<-1.1664 ,2.0218 ,3.2483>, 0.1000
<-1.7497 ,3.0327 ,4.8725>, 0.4000
}
cone {
<-0.8942 ,2.1607 ,3.2453>, 0.1000
<-1.3413 ,3.2411 ,4.8679>, 0.4000
}
cone {
<-0.6056 ,2.2630 ,3.2422>, 0.1000
<-0.9084 ,3.3946 ,4.8633>, 0.4000
}
cone {
<-0.3056 ,2.3269 ,3.2391>, 0.1000
<-0.4584 ,3.4904 ,4.8587>, 0.4000
}
cone {
<0.0008 ,2.3512 ,3.2361>, 0.1000
<0.0011 ,3.5267 ,4.8541>, 0.4000
}
cone {
<0.3082 ,2.3351 ,3.2330>, 0.1000
<0.4623 ,3.5027 ,4.8495>, 0.4000
}
cone {
<0.6115 ,2.2790 ,3.2299>, 0.1000
<0.9172 ,3.4185 ,4.8448>, 0.4000
}
cone {
<0.9053 ,2.1836 ,3.2268>, 0.1000
<1.3580 ,3.2754 ,4.8402>, 0.4000
}
cone {
<1.1847 ,2.0504 ,3.2237>, 0.1000
<1.7771 ,3.0756 ,4.8356>, 0.4000
}
cone {
<1.4448 ,1.8816 ,3.2206>, 0.1000
<2.1672 ,2.8224 ,4.8309>, 0.4000
}
cone {
<1.6810 ,1.6799 ,3.2175>, 0.1000
<2.5215 ,2.5198 ,4.8262>, 0.4000
}
cone {
<1.8892 ,1.4486 ,3.2144>, 0.1000
<2.8338 ,2.1730 ,4.8216>, 0.4000
}
cone {
<2.0658 ,1.1918 ,3.2113>, 0.1000
<3.0987 ,1.7876 ,4.8169>, 0.4000
}
cone {
<2.2076 ,0.9135 ,3.2081>, 0.1000
<3.3113 ,1.3703 ,4.8122>, 0.4000
}
cone {
<2.3120 ,0.6186 ,3.2050>, 0.1000
<3.4680 ,0.9280 ,4.8075>, 0.4000
}
cone {
<2.3771 ,0.3121 ,3.2019>, 0.1000
<3.5656 ,0.4682 ,4.8028>, 0.4000
}
cone {
<2.4017 ,-0.0008 ,3.1987>, 0.1000
<3.6025 ,-0.0012 ,4.7981>, 0.4000
}
cone {
<2.3852 ,-0.3148 ,3.1956>, 0.1000
<3.5778 ,-0.4723 ,4.7934>, 0.4000
}
cone {
<2.3277 ,-0.6246 ,3.1924>, 0.1000
<3.4916 ,-0.9369 ,4.7886>, 0.4000
}
cone {
<2.2301 ,-0.9247 ,3.1893>, 0.1000
<3.3452 ,-1.3870 ,4.7839>, 0.4000
}
cone {
<2.0940 ,-1.2099 ,3.1861>, 0.1000
<3.1410 ,-1.8149 ,4.7792>, 0.4000
}
cone {
<1.9214 ,-1.4754 ,3.1829>, 0.1000
<2.8822 ,-2.2132 ,4.7744>, 0.4000
}
cone {
<1.7154 ,-1.7166 ,3.1798>, 0.1000
<2.5730 ,-2.5748 ,4.7697>, 0.4000
}
cone {
<1.4792 ,-1.9291 ,3.1766>, 0.1000
<2.2187 ,-2.8936 ,4.7649>, 0.4000
}
cone {
<1.2168 ,-2.1093 ,3.1734>, 0.1000
<1.8252 ,-3.1639 ,4.7601>, 0.4000
}
cone {
<0.9326 ,-2.2539 ,3.1702>, 0.1000
<1.3990 ,-3.3808 ,4.7553>, 0.4000
}
cone {
<0.6315 ,-2.3603 ,3.1670>, 0.1000
<0.9473 ,-3.5405 ,4.7505>, 0.4000
}
cone {
<0.3186 ,-2.4267 ,3.1638>, 0.1000
<0.4779 ,-3.6400 ,4.7457>, 0.4000
}
cone {
<-0.0009 ,-2.4516 ,3.1606>, 0.1000
<-0.0013 ,-3.6775 ,4.7409>, 0.4000
}
cone {
<-0.3214 ,-2.4346 ,3.1574>, 0.1000
<-0.4821 ,-3.6520 ,4.7361>, 0.4000
}
cone {
<-0.6375 ,-2.3759 ,3.1542>, 0.1000
<-0.9563 ,-3.5638 ,4.7313>, 0.4000
}
cone {
<-0.9438 ,-2.2761 ,3.1510>, 0.1000
<-1.4157 ,-3.4142 ,4.7264>, 0.4000
}
cone {
<-1.2349 ,-2.1370 ,3.1477>, 0.1000
<-1.8523 ,-3.2056 ,4.7216>, 0.4000
}
cone {
<-1.5057 ,-1.9608 ,3.1445>, 0.1000
<-2.2586 ,-2.9413 ,4.7167>, 0.4000
}
cone {
<-1.7517 ,-1.7504 ,3.1413>, 0.1000
<-2.6276 ,-2.6256 ,4.7119>, 0.4000
}
cone {
<-1.9685 ,-1.5093 ,3.1380>, 0.1000
<-2.9527 ,-2.2640 ,4.7070>, 0.4000
}
cone {
<-2.1522 ,-1.2415 ,3.1348>, 0.1000
<-3.2283 ,-1.8623 ,4.7021>, 0.4000
}
cone {
<-2.2996 ,-0.9515 ,3.1315>, 0.1000
<-3.4494 ,-1.4273 ,4.6973>, 0.4000
}
cone {
<-2.4081 ,-0.6443 ,3.1282>, 0.1000
<-3.6122 ,-0.9664 ,4.6924>, 0.4000
}
cone {
<-2.4757 ,-0.3250 ,3.1250>, 0.1000
<-3.7135 ,-0.4875 ,4.6875>, 0.4000
}
cone {
<-2.5010 ,0.0009 ,3.1217>, 0.1000
<-3.7515 ,0.0014 ,4.6826>, 0.4000
}
cone {
<-2.4835 ,0.3279 ,3.1184>, 0.1000
<-3.7253 ,0.4919 ,4.6777>, 0.4000
}
cone {
<-2.4234 ,0.6503 ,3.1152>, 0.1000
<-3.6351 ,0.9755 ,4.6727>, 0.4000
}
cone {
<-2.3215 ,0.9626 ,3.1119>, 0.1000
<-3.4823 ,1.4440 ,4.6678>, 0.4000
}
cone {
<-2.1796 ,1.2595 ,3.1086>, 0.1000
<-3.2693 ,1.8892 ,4.6629>, 0.4000
}
cone {
<-1.9997 ,1.5357 ,3.1053>, 0.1000
<-2.9996 ,2.3035 ,4.6579>, 0.4000
}
cone {
<-1.7851 ,1.7864 ,3.1020>, 0.1000
<-2.6776 ,2.6796 ,4.6530>, 0.4000
}
cone {
<-1.5391 ,2.0074 ,3.0987>, 0.1000
<-2.3086 ,3.0110 ,4.6480>, 0.4000
}
cone {
<-1.2659 ,2.1946 ,3.0954>, 0.1000
<-1.8989 ,3.2919 ,4.6430>, 0.4000
}
cone {
<-0.9702 ,2.3448 ,3.0920>, 0.1000
<-1.4553 ,3.5172 ,4.6380>, 0.4000
}
cone {
<-0.6569 ,2.4553 ,3.0887>, 0.1000
<-0.9853 ,3.6829 ,4.6331>, 0.4000
}
cone {
<-0.3313 ,2.5240 ,3.0854>, 0.1000
<-0.4969 ,3.7860 ,4.6281>, 0.4000
}
cone {
<0.0010 ,2.5497 ,3.0820>, 0.1000
<0.0015 ,3.8246 ,4.6231>, 0.4000
}
cone {
<0.3343 ,2.5318 ,3.0787>, 0.1000
<0.5015 ,3.7976 ,4.6181>, 0.4000
}
cone {
<0.6630 ,2.4704 ,3.0754>, 0.1000
<0.9945 ,3.7055 ,4.6130>, 0.4000
}
cone {
<0.9813 ,2.3664 ,3.0720>, 0.1000
<1.4719 ,3.5496 ,4.6080>, 0.4000
}
cone {
<1.2838 ,2.2215 ,3.0687>, 0.1000
<1.9257 ,3.3323 ,4.6030>, 0.4000
}
cone {
<1.5652 ,2.0382 ,3.0653>, 0.1000
<2.3478 ,3.0572 ,4.5979>, 0.4000
}
cone {
<1.8207 ,1.8192 ,3.0619>, 0.1000
<2.7311 ,2.7289 ,4.5929>, 0.4000
}
cone {
<2.0458 ,1.5685 ,3.0586>, 0.1000
<3.0687 ,2.3527 ,4.5878>, 0.4000
}
cone {
<2.2365 ,1.2900 ,3.0552>, 0.1000
<3.3547 ,1.9350 ,4.5828>, 0.4000
}
cone {
<2.3894 ,0.9886 ,3.0518>, 0.1000
<3.5841 ,1.4829 ,4.5777>, 0.4000
}
cone {
<2.5019 ,0.6693 ,3.0484>, 0.1000
<3.7528 ,1.0039 ,4.5726>, 0.4000
}
cone {
<2.5718 ,0.3375 ,3.0450>, 0.1000
<3.8577 ,0.5063 ,4.5675>, 0.4000
}
cone {
<2.5978 ,-0.0011 ,3.0416>, 0.1000
<3.8967 ,-0.0016 ,4.5624>, 0.4000
}
cone {
<2.5794 ,-0.3407 ,3.0382>, 0.1000
<3.8691 ,-0.5110 ,4.5573>, 0.4000
}
cone {
<2.5167 ,-0.6755 ,3.0348>, 0.1000
<3.7750 ,-1.0132 ,4.5522>, 0.4000
}
cone {
<2.4107 ,-0.9997 ,3.0314>, 0.1000
<3.6160 ,-1.4995 ,4.5471>, 0.4000
}
cone {
<2.2630 ,-1.3078 ,3.0280>, 0.1000
<3.3945 ,-1.9617 ,4.5420>, 0.4000
}
cone {
<2.0761 ,-1.5944 ,3.0245>, 0.1000
<3.1141 ,-2.3916 ,4.5368>, 0.4000
}
cone {
<1.8530 ,-1.8545 ,3.0211>, 0.1000
<2.7795 ,-2.7818 ,4.5317>, 0.4000
}
cone {
<1.5975 ,-2.0837 ,3.0177>, 0.1000
<2.3962 ,-3.1255 ,4.5265>, 0.4000
}
cone {
<1.3138 ,-2.2778 ,3.0142>, 0.1000
<1.9707 ,-3.4167 ,4.5214>, 0.4000
}
cone {
<1.0068 ,-2.4334 ,3.0108>, 0.1000
<1.5101 ,-3.6501 ,4.5162>, 0.4000
}
cone {
<0.6815 ,-2.5478 ,3.0073>, 0.1000
<1.0223 ,-3.8217 ,4.5110>, 0.4000
}
cone {
<0.3437 ,-2.6189 ,3.0039>, 0.1000
<0.5155 ,-3.9283 ,4.5058>, 0.4000
}
cone {
<-0.0011 ,-2.6453 ,3.0004>, 0.1000
<-0.0017 ,-3.9679 ,4.5006>, 0.4000
}
cone {
<-0.3469 ,-2.6264 ,2.9970>, 0.1000
<-0.5204 ,-3.9396 ,4.4955>, 0.4000
}
cone {
<-0.6878 ,-2.5624 ,2.9935>, 0.1000
<-1.0317 ,-3.8436 ,4.4902>, 0.4000
}
cone {
<-1.0179 ,-2.4543 ,2.9900>, 0.1000
<-1.5268 ,-3.6815 ,4.4850>, 0.4000
}
cone {
<-1.3315 ,-2.3039 ,2.9865>, 0.1000
<-1.9972 ,-3.4558 ,4.4798>, 0.4000
}
cone {
<-1.6232 ,-2.1135 ,2.9831>, 0.1000
<-2.4347 ,-3.1702 ,4.4746>, 0.4000
}
cone {
<-1.8879 ,-1.8863 ,2.9796>, 0.1000
<-2.8319 ,-2.8294 ,4.4693>, 0.4000
}
cone {
<-2.1211 ,-1.6261 ,2.9761>, 0.1000
<-3.1816 ,-2.4391 ,4.4641>, 0.4000
}
cone {
<-2.3185 ,-1.3373 ,2.9726>, 0.1000
<-3.4778 ,-2.0059 ,4.4589>, 0.4000
}
cone {
<-2.4768 ,-1.0247 ,2.9691>, 0.1000
<-3.7153 ,-1.5370 ,4.4536>, 0.4000
}
cone {
<-2.5931 ,-0.6936 ,2.9656>, 0.1000
<-3.8897 ,-1.0404 ,4.4483>, 0.4000
}
cone {
<-2.6653 ,-0.3497 ,2.9620>, 0.1000
<-3.9980 ,-0.5246 ,4.4431>, 0.4000
}
cone {
<-2.6921 ,0.0012 ,2.9585>, 0.1000
<-4.0381 ,0.0018 ,4.4378>, 0.4000
}
cone {
<-2.6727 ,0.3531 ,2.9550>, 0.1000
<-4.0091 ,0.5296 ,4.4325>, 0.4000
}
cone {
<-2.6075 ,0.6999 ,2.9515>, 0.1000
<-3.9112 ,1.0499 ,4.4272>, 0.4000
}
cone {
<-2.4974 ,1.0358 ,2.9479>, 0.1000
<-3.7461 ,1.5536 ,4.4219>, 0.4000
}
cone {
<-2.3442 ,1.3548 ,2.9444>, 0.1000
<-3.5163 ,2.0322 ,4.4166>, 0.4000
}
cone {
<-2.1503 ,1.6515 ,2.9408>, 0.1000
<-3.2255 ,2.4773 ,4.4112>, 0.4000
}
cone {
<-1.9191 ,1.9208 ,2.9373>, 0.1000
<-2.8786 ,2.8812 ,4.4059>, 0.4000
}
cone {
<-1.6543 ,2.1579 ,2.9337>, 0.1000
<-2.4814 ,3.2369 ,4.4006>, 0.4000
}
cone {
<-1.3604 ,2.3587 ,2.9302>, 0.1000
<-2.0406 ,3.5381 ,4.3952>, 0.4000
}
cone {
<-1.0423 ,2.5196 ,2.9266>, 0.1000
<-1.5635 ,3.7795 ,4.3899>, 0.4000
}
cone {
<-0.7055 ,2.6378 ,2.9230>, 0.1000
<-1.0583 ,3.9568 ,4.3845>, 0.4000
}
cone {
<-0.3557 ,2.7112 ,2.9194>, 0.1000
<-0.5335 ,4.0667 ,4.3792>, 0.4000
}
cone {
<0.0013 ,2.7382 ,2.9159>, 0.1000
<0.0019 ,4.1073 ,4.3738>, 0.4000
}
cone {
<0.3592 ,2.7184 ,2.9123>, 0.1000
<0.5387 ,4.0776 ,4.3684>, 0.4000
}
cone {
<0.7119 ,2.6519 ,2.9087>, 0.1000
<1.0678 ,3.9779 ,4.3630>, 0.4000
}
cone {
<1.0534 ,2.5398 ,2.9051>, 0.1000
<1.5801 ,3.8098 ,4.3576>, 0.4000
}
cone {
<1.3778 ,2.3839 ,2.9015>, 0.1000
<2.0667 ,3.5759 ,4.3522>, 0.4000
}
cone {
<1.6795 ,2.1867 ,2.8979>, 0.1000
<2.5193 ,3.2800 ,4.3468>, 0.4000
}
cone {
<1.9532 ,1.9514 ,2.8943>, 0.1000
<2.9299 ,2.9271 ,4.3414>, 0.4000
}
cone {
<2.1943 ,1.6821 ,2.8906>, 0.1000
<3.2914 ,2.5231 ,4.3360>, 0.4000
}
cone {
<2.3983 ,1.3832 ,2.8870>, 0.1000
<3.5975 ,2.0748 ,4.3305>, 0.4000
}
cone {
<2.5618 ,1.0597 ,2.8834>, 0.1000
<3.8427 ,1.5896 ,4.3251>, 0.4000
}
cone {
<2.6819 ,0.7173 ,2.8798>, 0.1000
<4.0228 ,1.0759 ,4.3197>, 0.4000
}
cone {
<2.7563 ,0.3615 ,2.8761>, 0.1000
<4.1344 ,0.5423 ,4.3142>, 0.4000
}
cone {
<2.7837 ,-0.0013 ,2.8725>, 0.1000
<4.1755 ,-0.0020 ,4.3087>, 0.4000
}
cone {
<2.7634 ,-0.3651 ,2.8688>, 0.1000
<4.1451 ,-0.5477 ,4.3033>, 0.4000
}
cone {
<2.6957 ,-0.7237 ,2.8652>, 0.1000
<4.0436 ,-1.0855 ,4.2978>, 0.4000
}
cone {
<2.5817 ,-1.0708 ,2.8615>, 0.1000
<3.8725 ,-1.6062 ,4.2923>, 0.4000
}
cone {
<2.4230 ,-1.4005 ,2.8579>, 0.1000
<3.6346 ,-2.1007 ,4.2868>, 0.4000
}
cone {
<2.2225 ,-1.7071 ,2.8542>, 0.1000
<3.3337 ,-2.5606 ,4.2813>, 0.4000
}
cone {
<1.9833 ,-1.9852 ,2.8505>, 0.1000
<2.9749 ,-2.9778 ,4.2758>, 0.4000
}
cone {
<1.7095 ,-2.2300 ,2.8469>, 0.1000
<2.5642 ,-3.3451 ,4.2703>, 0.4000
}
cone {
<1.4056 ,-2.4373 ,2.8432>, 0.1000
<2.1084 ,-3.6560 ,4.2648>, 0.4000
}
cone {
<1.0769 ,-2.6034 ,2.8395>, 0.1000
<1.6153 ,-3.9051 ,4.2592>, 0.4000
}
cone {
<0.7288 ,-2.7253 ,2.8358>, 0.1000
<1.0932 ,-4.0879 ,4.2537>, 0.4000
}
cone {
<0.3673 ,-2.8008 ,2.8321>, 0.1000
<0.5510 ,-4.2011 ,4.2482>, 0.4000
}
cone {
<-0.0014 ,-2.8284 ,2.8284>, 0.1000
<-0.0021 ,-4.2427 ,4.2426>, 0.4000
}
cone {
<-0.3710 ,-2.8077 ,2.8247>, 0.1000
<-0.5566 ,-4.2116 ,4.2371>, 0.4000
}
cone {
<-0.7353 ,-2.7388 ,2.8210>, 0.1000
<-1.1030 ,-4.1083 ,4.2315>, 0.4000
}
cone {
<-1.0879 ,-2.6228 ,2.8173>, 0.1000
<-1.6319 ,-3.9343 ,4.2259>, 0.4000
}
cone {
<-1.4228 ,-2.4616 ,2.8136>, 0.1000
<-2.1342 ,-3.6924 ,4.2203>, 0.4000
}
cone {
<-1.7342 ,-2.2577 ,2.8098>, 0.1000
<-2.6013 ,-3.3866 ,4.2148>, 0.4000
}
cone {
<-2.0167 ,-2.0147 ,2.8061>, 0.1000
<-3.0250 ,-3.0220 ,4.2092>, 0.4000
}
cone {
<-2.2653 ,-1.7364 ,2.8024>, 0.1000
<-3.3979 ,-2.6046 ,4.2036>, 0.4000
}
cone {
<-2.4757 ,-1.4277 ,2.7986>, 0.1000
<-3.7136 ,-2.1416 ,4.1980>, 0.4000
}
cone {
<-2.6443 ,-1.0937 ,2.7949>, 0.1000
<-3.9664 ,-1.6406 ,4.1923>, 0.4000
}
cone {
<-2.7680 ,-0.7402 ,2.7911>, 0.1000
<-4.1519 ,-1.1103 ,4.1867>, 0.4000
}
cone {
<-2.8445 ,-0.3730 ,2.7874>, 0.1000
<-4.2668 ,-0.5595 ,4.1811>, 0.4000
}
cone {
<-2.8725 ,0.0015 ,2.7836>, 0.1000
<-4.3088 ,0.0022 ,4.1755>, 0.4000
}
cone {
<-2.8514 ,0.3769 ,2.7799>, 0.1000
<-4.2770 ,0.5653 ,4.1698>, 0.4000
}
cone {
<-2.7813 ,0.7468 ,2.7761>, 0.1000
<-4.1719 ,1.1201 ,4.1642>, 0.4000
}
cone {
<-2.6634 ,1.1048 ,2.7723>, 0.1000
<-3.9951 ,1.6572 ,4.1585>, 0.4000
}
cone {
<-2.4995 ,1.4448 ,2.7686>, 0.1000
<-3.7493 ,2.1672 ,4.1528>, 0.4000
}
cone {
<-2.2924 ,1.7609 ,2.7648>, 0.1000
<-3.4386 ,2.6414 ,4.1472>, 0.4000
}
cone {
<-2.0455 ,2.0476 ,2.7610>, 0.1000
<-3.0683 ,3.0714 ,4.1415>, 0.4000
}
cone {
<-1.7629 ,2.3000 ,2.7572>, 0.1000
<-2.6444 ,3.4500 ,4.1358>, 0.4000
}
cone {
<-1.4495 ,2.5135 ,2.7534>, 0.1000
<-2.1742 ,3.7703 ,4.1301>, 0.4000
}
cone {
<-1.1103 ,2.6846 ,2.7496>, 0.1000
<-1.6655 ,4.0268 ,4.1244>, 0.4000
}
cone {
<-0.7514 ,2.8100 ,2.7458>, 0.1000
<-1.1270 ,4.2150 ,4.1187>, 0.4000
}
cone {
<-0.3786 ,2.8876 ,2.7420>, 0.1000
<-0.5679 ,4.3314 ,4.1130>, 0.4000
}
cone {
<0.0015 ,2.9159 ,2.7382>, 0.1000
<0.0023 ,4.3738 ,4.1073>, 0.4000
}
cone {
<0.3826 ,2.8943 ,2.7344>, 0.1000
<0.5739 ,4.3414 ,4.1015>, 0.4000
}
cone {
<0.7580 ,2.8230 ,2.7305>, 0.1000
<1.1370 ,4.2346 ,4.0958>, 0.4000
}
cone {
<1.1214 ,2.7033 ,2.7267>, 0.1000
<1.6821 ,4.0549 ,4.0901>, 0.4000
}
cone {
<1.4664 ,2.5368 ,2.7229>, 0.1000
<2.1997 ,3.8053 ,4.0843>, 0.4000
}
cone {
<1.7872 ,2.3266 ,2.7190>, 0.1000
<2.6808 ,3.4898 ,4.0785>, 0.4000
}
cone {
<2.0781 ,2.0759 ,2.7152>, 0.1000
<3.1171 ,3.1138 ,4.0728>, 0.4000
}
cone {
<2.3341 ,1.7890 ,2.7113>, 0.1000
<3.5011 ,2.6836 ,4.0670>, 0.4000
}
cone {
<2.5507 ,1.4708 ,2.7075>, 0.1000
<3.8261 ,2.2063 ,4.0612>, 0.4000
}
cone {
<2.7241 ,1.1267 ,2.7036>, 0.1000
<4.0862 ,1.6900 ,4.0554>, 0.4000
}
cone {
<2.8513 ,0.7624 ,2.6998>, 0.1000
<4.2770 ,1.1436 ,4.0497>, 0.4000
}
cone {
<2.9299 ,0.3841 ,2.6959>, 0.1000
<4.3949 ,0.5762 ,4.0439>, 0.4000
}
cone {
<2.9585 ,-0.0016 ,2.6920>, 0.1000
<4.4378 ,-0.0024 ,4.0381>, 0.4000
}
cone {
<2.9365 ,-0.3882 ,2.6882>, 0.1000
<4.4048 ,-0.5823 ,4.0322>, 0.4000
}
cone {
<2.8641 ,-0.7691 ,2.6843>, 0.1000
<4.2962 ,-1.1537 ,4.0264>, 0.4000
}
cone {
<2.7425 ,-1.1377 ,2.6804>, 0.1000
<4.1137 ,-1.7066 ,4.0206>, 0.4000
}
cone {
<2.5735 ,-1.4877 ,2.6765>, 0.1000
<3.8603 ,-2.2316 ,4.0148>, 0.4000
}
cone {
<2.3601 ,-1.8130 ,2.6726>, 0.1000
<3.5402 ,-2.7195 ,4.0089>, 0.4000
}
cone {
<2.1057 ,-2.1080 ,2.6687>, 0.1000
<3.1586 ,-3.1621 ,4.0031>, 0.4000
}
cone {
<1.8147 ,-2.3676 ,2.6648>, 0.1000
<2.7220 ,-3.5515 ,3.9972>, 0.4000
}
cone {
<1.4919 ,-2.5873 ,2.6609>, 0.1000
<2.2378 ,-3.8809 ,3.9914>, 0.4000
}
cone {
<1.1427 ,-2.7631 ,2.6570>, 0.1000
<1.7141 ,-4.1446 ,3.9855>, 0.4000
}
cone {
<0.7732 ,-2.8920 ,2.6531>, 0.1000
<1.1598 ,-4.3379 ,3.9796>, 0.4000
}
cone {
<0.3895 ,-2.9716 ,2.6492>, 0.1000
<0.5843 ,-4.4574 ,3.9737>, 0.4000
}
cone {
<-0.0017 ,-3.0005 ,2.6452>, 0.1000
<-0.0025 ,-4.5007 ,3.9678>, 0.4000
}
cone {
<-0.3938 ,-2.9780 ,2.6413>, 0.1000
<-0.5906 ,-4.4670 ,3.9620>, 0.4000
}
cone {
<-0.7800 ,-2.9045 ,2.6374>, 0.1000
<-1.1700 ,-4.3567 ,3.9560>, 0.4000
}
cone {
<-1.1538 ,-2.7810 ,2.6334>, 0.1000
<-1.7306 ,-4.1715 ,3.9501>, 0.4000
}
cone {
<-1.5086 ,-2.6096 ,2.6295>, 0.1000
<-2.2629 ,-3.9144 ,3.9442>, 0.4000
}
cone {
<-1.8384 ,-2.3931 ,2.6255>, 0.1000
<-2.7576 ,-3.5896 ,3.9383>, 0.4000
}
cone {
<-2.1375 ,-2.1351 ,2.6216>, 0.1000
<-3.2062 ,-3.2026 ,3.9324>, 0.4000
}
cone {
<-2.4006 ,-1.8399 ,2.6176>, 0.1000
<-3.6009 ,-2.7598 ,3.9264>, 0.4000
}
cone {
<-2.6232 ,-1.5125 ,2.6137>, 0.1000
<-3.9348 ,-2.2688 ,3.9205>, 0.4000
}
cone {
<-2.8013 ,-1.1585 ,2.6097>, 0.1000
<-4.2020 ,-1.7377 ,3.9145>, 0.4000
}
cone {
<-2.9319 ,-0.7838 ,2.6057>, 0.1000
<-4.3978 ,-1.1757 ,3.9086>, 0.4000
}
cone {
<-3.0125 ,-0.3948 ,2.6018>, 0.1000
<-4.5187 ,-0.5923 ,3.9026>, 0.4000
}
cone {
<-3.0416 ,0.0017 ,2.5978>, 0.1000
<-4.5625 ,0.0026 ,3.8967>, 0.4000
}
cone {
<-3.0188 ,0.3992 ,2.5938>, 0.1000
<-4.5281 ,0.5988 ,3.8907>, 0.4000
}
cone {
<-2.9441 ,0.7907 ,2.5898>, 0.1000
<-4.4162 ,1.1860 ,3.8847>, 0.4000
}
cone {
<-2.8188 ,1.1695 ,2.5858>, 0.1000
<-4.2283 ,1.7543 ,3.8787>, 0.4000
}
cone {
<-2.6450 ,1.5291 ,2.5818>, 0.1000
<-3.9675 ,2.2937 ,3.8727>, 0.4000
}
cone {
<-2.4255 ,1.8633 ,2.5778>, 0.1000
<-3.6382 ,2.7950 ,3.8667>, 0.4000
}
cone {
<-2.1639 ,2.1664 ,2.5738>, 0.1000
<-3.2458 ,3.2496 ,3.8607>, 0.4000
}
cone {
<-1.8646 ,2.4330 ,2.5698>, 0.1000
<-2.7969 ,3.6494 ,3.8547>, 0.4000
}
cone {
<-1.5328 ,2.6584 ,2.5658>, 0.1000
<-2.2992 ,3.9877 ,3.8487>, 0.4000
}
cone {
<-1.1740 ,2.8389 ,2.5618>, 0.1000
<-1.7609 ,4.2583 ,3.8426>, 0.4000
}
cone {
<-0.7942 ,2.9711 ,2.5577>, 0.1000
<-1.1913 ,4.4566 ,3.8366>, 0.4000
}
cone {
<-0.4001 ,3.0526 ,2.5537>, 0.1000
<-0.6001 ,4.5789 ,3.8306>, 0.4000
}
cone {
<0.0018 ,3.0821 ,2.5497>, 0.1000
<0.0027 ,4.6231 ,3.8245>, 0.4000
}
cone {
<0.4045 ,3.0588 ,2.5456>, 0.1000
<0.6068 ,4.5882 ,3.8185>, 0.4000
}
cone {
<0.8012 ,2.9830 ,2.5416>, 0.1000
<1.2018 ,4.4745 ,3.8124>, 0.4000
}
cone {
<1.1850 ,2.8560 ,2.5376>, 0.1000
<1.7775 ,4.2840 ,3.8063>, 0.4000
}
cone {
<1.5493 ,2.6798 ,2.5335>, 0.1000
<2.3239 ,4.0196 ,3.8003>, 0.4000
}
cone {
<1.8878 ,2.4572 ,2.5295>, 0.1000
<2.8317 ,3.6858 ,3.7942>, 0.4000
}
cone {
<2.1948 ,2.1921 ,2.5254>, 0.1000
<3.2921 ,3.2882 ,3.7881>, 0.4000
}
cone {
<2.4647 ,1.8889 ,2.5213>, 0.1000
<3.6971 ,2.8334 ,3.7820>, 0.4000
}
cone {
<2.6931 ,1.5527 ,2.5173>, 0.1000
<4.0396 ,2.3290 ,3.7759>, 0.4000
}
cone {
<2.8757 ,1.1891 ,2.5132>, 0.1000
<4.3136 ,1.7837 ,3.7698>, 0.4000
}
cone {
<3.0095 ,0.8045 ,2.5091>, 0.1000
<4.5143 ,1.2067 ,3.7637>, 0.4000
}
cone {
<3.0920 ,0.4052 ,2.5050>, 0.1000
<4.6380 ,0.6078 ,3.7576>, 0.4000
}
cone {
<3.1217 ,-0.0019 ,2.5010>, 0.1000
<4.6826 ,-0.0028 ,3.7514>, 0.4000
}
cone {
<3.0980 ,-0.4098 ,2.4969>, 0.1000
<4.6470 ,-0.6147 ,3.7453>, 0.4000
}
cone {
<3.0212 ,-0.8115 ,2.4928>, 0.1000
<4.5318 ,-1.2172 ,3.7392>, 0.4000
}
cone {
<2.8924 ,-1.2002 ,2.4887>, 0.1000
<4.3386 ,-1.8002 ,3.7330>, 0.4000
}
cone {
<2.7138 ,-1.5691 ,2.4846>, 0.1000
<4.0708 ,-2.3536 ,3.7269>, 0.4000
}
cone {
<2.4884 ,-1.9118 ,2.4805>, 0.1000
<3.7326 ,-2.8678 ,3.7207>, 0.4000
}
cone {
<2.2199 ,-2.2226 ,2.4764>, 0.1000
<3.3298 ,-3.3339 ,3.7145>, 0.4000
}
cone {
<1.9127 ,-2.4959 ,2.4722>, 0.1000
<2.8691 ,-3.7438 ,3.7084>, 0.4000
}
cone {
<1.5722 ,-2.7270 ,2.4681>, 0.1000
<2.3583 ,-4.0905 ,3.7022>, 0.4000
}
cone {
<1.2040 ,-2.9119 ,2.4640>, 0.1000
<1.8060 ,-4.3678 ,3.6960>, 0.4000
}
cone {
<0.8145 ,-3.0472 ,2.4599>, 0.1000
<1.2217 ,-4.5709 ,3.6898>, 0.4000
}
cone {
<0.4102 ,-3.1307 ,2.4557>, 0.1000
<0.6153 ,-4.6960 ,3.6836>, 0.4000
}
cone {
<-0.0020 ,-3.1606 ,2.4516>, 0.1000
<-0.0030 ,-4.7410 ,3.6774>, 0.4000
}
cone {
<-0.4149 ,-3.1365 ,2.4475>, 0.1000
<-0.6224 ,-4.7048 ,3.6712>, 0.4000
}
cone {
<-0.8216 ,-3.0586 ,2.4433>, 0.1000
<-1.2324 ,-4.5879 ,3.6650>, 0.4000
}
cone {
<-1.2150 ,-2.9282 ,2.4392>, 0.1000
<-1.8225 ,-4.3922 ,3.6588>, 0.4000
}
cone {
<-1.5884 ,-2.7473 ,2.4350>, 0.1000
<-2.3827 ,-4.1209 ,3.6525>, 0.4000
}
cone {
<-1.9354 ,-2.5190 ,2.4309>, 0.1000
<-2.9031 ,-3.7784 ,3.6463>, 0.4000
}
cone {
<-2.2499 ,-2.2470 ,2.4267>, 0.1000
<-3.3748 ,-3.3706 ,3.6401>, 0.4000
}
cone {
<-2.5264 ,-1.9361 ,2.4225>, 0.1000
<-3.7897 ,-2.9041 ,3.6338>, 0.4000
}
cone {
<-2.7603 ,-1.5913 ,2.4184>, 0.1000
<-4.1404 ,-2.3870 ,3.6276>, 0.4000
}
cone {
<-2.9473 ,-1.2186 ,2.4142>, 0.1000
<-4.4210 ,-1.8279 ,3.6213>, 0.4000
}
cone {
<-3.0842 ,-0.8243 ,2.4100>, 0.1000
<-4.6263 ,-1.2365 ,3.6150>, 0.4000
}
cone {
<-3.1685 ,-0.4151 ,2.4058>, 0.1000
<-4.7528 ,-0.6226 ,3.6088>, 0.4000
}
cone {
<-3.1988 ,0.0020 ,2.4017>, 0.1000
<-4.7981 ,0.0031 ,3.6025>, 0.4000
}
cone {
<-3.1742 ,0.4200 ,2.3975>, 0.1000
<-4.7614 ,0.6299 ,3.5962>, 0.4000
}
cone {
<-3.0953 ,0.8315 ,2.3933>, 0.1000
<-4.6429 ,1.2473 ,3.5899>, 0.4000
}
cone {
<-2.9632 ,1.2296 ,2.3891>, 0.1000
<-4.4447 ,1.8444 ,3.5836>, 0.4000
}
cone {
<-2.7800 ,1.6074 ,2.3849>, 0.1000
<-4.1700 ,2.4112 ,3.5773>, 0.4000
}
cone {
<-2.5489 ,1.9585 ,2.3807>, 0.1000
<-3.8233 ,2.9377 ,3.5710>, 0.4000
}
cone {
<-2.2737 ,2.2766 ,2.3765>, 0.1000
<-3.4105 ,3.4149 ,3.5647>, 0.4000
}
cone {
<-1.9589 ,2.5564 ,2.3722>, 0.1000
<-2.9384 ,3.8345 ,3.5584>, 0.4000
}
cone {
<-1.6100 ,2.7929 ,2.3680>, 0.1000
<-2.4151 ,4.1893 ,3.5520>, 0.4000
}
cone {
<-1.2329 ,2.9820 ,2.3638>, 0.1000
<-1.8494 ,4.4730 ,3.5457>, 0.4000
}
cone {
<-0.8339 ,3.1204 ,2.3596>, 0.1000
<-1.2509 ,4.6806 ,3.5394>, 0.4000
}
cone {
<-0.4199 ,3.2056 ,2.3554>, 0.1000
<-0.6298 ,4.8084 ,3.5330>, 0.4000
}
cone {
<0.0021 ,3.2361 ,2.3511>, 0.1000
<0.0032 ,4.8541 ,3.5267>, 0.4000
}
cone {
<0.4249 ,3.2112 ,2.3469>, 0.1000
<0.6374 ,4.8168 ,3.5203>, 0.4000
}
cone {
<0.8412 ,3.1312 ,2.3426>, 0.1000
<1.2618 ,4.6968 ,3.5140>, 0.4000
}
cone {
<1.2439 ,2.9974 ,2.3384>, 0.1000
<1.8658 ,4.4962 ,3.5076>, 0.4000
}
cone {
<1.6260 ,2.8121 ,2.3341>, 0.1000
<2.4390 ,4.2181 ,3.5012>, 0.4000
}
cone {
<1.9810 ,2.5782 ,2.3299>, 0.1000
<2.9716 ,3.8673 ,3.4948>, 0.4000
}
cone {
<2.3028 ,2.2997 ,2.3256>, 0.1000
<3.4542 ,3.4496 ,3.4884>, 0.4000
}
cone {
<2.5857 ,1.9813 ,2.3214>, 0.1000
<3.8785 ,2.9720 ,3.4821>, 0.4000
}
cone {
<2.8248 ,1.6284 ,2.3171>, 0.1000
<4.2372 ,2.4426 ,3.4757>, 0.4000
}
cone {
<3.0160 ,1.2469 ,2.3128>, 0.1000
<4.5240 ,1.8703 ,3.4692>, 0.4000
}
cone {
<3.1558 ,0.8433 ,2.3086>, 0.1000
<4.7338 ,1.2650 ,3.4628>, 0.4000
}
cone {
<3.2419 ,0.4246 ,2.3043>, 0.1000
<4.8629 ,0.6369 ,3.4564>, 0.4000
}
cone {
<3.2726 ,-0.0022 ,2.3000>, 0.1000
<4.9089 ,-0.0033 ,3.4500>, 0.4000
}
cone {
<3.2473 ,-0.4297 ,2.2957>, 0.1000
<4.8710 ,-0.6446 ,3.4436>, 0.4000
}
cone {
<3.1663 ,-0.8507 ,2.2914>, 0.1000
<4.7495 ,-1.2761 ,3.4371>, 0.4000
}
cone {
<3.0310 ,-1.2579 ,2.2871>, 0.1000
<4.5465 ,-1.8868 ,3.4307>, 0.4000
}
cone {
<2.8434 ,-1.6442 ,2.2828>, 0.1000
<4.2652 ,-2.4663 ,3.4242>, 0.4000
}
cone {
<2.6069 ,-2.0031 ,2.2785>, 0.1000
<3.9103 ,-3.0047 ,3.4178>, 0.4000
}
cone {
<2.3252 ,-2.3284 ,2.2742>, 0.1000
<3.4878 ,-3.4926 ,3.4113>, 0.4000
}
cone {
<2.0032 ,-2.6143 ,2.2699>, 0.1000
<3.0048 ,-3.9215 ,3.4049>, 0.4000
}
cone {
<1.6463 ,-2.8560 ,2.2656>, 0.1000
<2.4695 ,-4.2840 ,3.3984>, 0.4000
}
cone {
<1.2606 ,-3.0492 ,2.2613>, 0.1000
<1.8909 ,-4.5738 ,3.3919>, 0.4000
}
cone {
<0.8525 ,-3.1905 ,2.2570>, 0.1000
<1.2788 ,-4.7857 ,3.3854>, 0.4000
}
cone {
<0.4292 ,-3.2774 ,2.2526>, 0.1000
<0.6438 ,-4.9161 ,3.3790>, 0.4000
}
cone {
<-0.0023 ,-3.3083 ,2.2483>, 0.1000
<-0.0034 ,-4.9625 ,3.3725>, 0.4000
}
cone {
<-0.4345 ,-3.2827 ,2.2440>, 0.1000
<-0.6517 ,-4.9240 ,3.3660>, 0.4000
}
cone {
<-0.8600 ,-3.2007 ,2.2396>, 0.1000
<-1.2900 ,-4.8010 ,3.3595>, 0.4000
}
cone {
<-1.2715 ,-3.0638 ,2.2353>, 0.1000
<-1.9073 ,-4.5956 ,3.3530>, 0.4000
}
cone {
<-1.6620 ,-2.8741 ,2.2310>, 0.1000
<-2.4930 ,-4.3112 ,3.3464>, 0.4000
}
cone {
<-2.0247 ,-2.6349 ,2.2266>, 0.1000
<-3.0371 ,-3.9523 ,3.3399>, 0.4000
}
cone {
<-2.3534 ,-2.3501 ,2.2223>, 0.1000
<-3.5301 ,-3.5252 ,3.3334>, 0.4000
}
cone {
<-2.6423 ,-2.0246 ,2.2179>, 0.1000
<-3.9635 ,-3.0369 ,3.3269>, 0.4000
}
cone {
<-2.8865 ,-1.6638 ,2.2135>, 0.1000
<-4.3298 ,-2.4957 ,3.3203>, 0.4000
}
cone {
<-3.0817 ,-1.2739 ,2.2092>, 0.1000
<-4.6225 ,-1.9109 ,3.3138>, 0.4000
}
cone {
<-3.2244 ,-0.8615 ,2.2048>, 0.1000
<-4.8366 ,-1.2923 ,3.3072>, 0.4000
}
cone {
<-3.3121 ,-0.4337 ,2.2004>, 0.1000
<-4.9681 ,-0.6505 ,3.3007>, 0.4000
}
cone {
<-3.3432 ,0.0024 ,2.1961>, 0.1000
<-5.0149 ,0.0035 ,3.2941>, 0.4000
}
cone {
<-3.3172 ,0.4391 ,2.1917>, 0.1000
<-4.9758 ,0.6586 ,3.2875>, 0.4000
}
cone {
<-3.2343 ,0.8691 ,2.1873>, 0.1000
<-4.8514 ,1.3036 ,3.2810>, 0.4000
}
cone {
<-3.0958 ,1.2849 ,2.1829>, 0.1000
<-4.6437 ,1.9273 ,3.2744>, 0.4000
}
cone {
<-2.9041 ,1.6794 ,2.1785>, 0.1000
<-4.3561 ,2.5191 ,3.2678>, 0.4000
}
cone {
<-2.6623 ,2.0458 ,2.1741>, 0.1000
<-3.9934 ,3.0688 ,3.2612>, 0.4000
}
cone {
<-2.3745 ,2.3778 ,2.1697>, 0.1000
<-3.5617 ,3.5668 ,3.2546>, 0.4000
}
cone {
<-2.0455 ,2.6697 ,2.1653>, 0.1000
<-3.0682 ,4.0045 ,3.2480>, 0.4000
}
cone {
<-1.6809 ,2.9163 ,2.1609>, 0.1000
<-2.5214 ,4.3744 ,3.2414>, 0.4000
}
cone {
<-1.2870 ,3.1134 ,2.1565>, 0.1000
<-1.9305 ,4.6701 ,3.2348>, 0.4000
}
cone {
<-0.8703 ,3.2574 ,2.1521>, 0.1000
<-1.3055 ,4.8862 ,3.2282>, 0.4000
}
cone {
<-0.4381 ,3.3460 ,2.1477>, 0.1000
<-0.6571 ,5.0189 ,3.2216>, 0.4000
}
cone {
<0.0024 ,3.3773 ,2.1433>, 0.1000
<0.0037 ,5.0660 ,3.2149>, 0.4000
}
cone {
<0.4436 ,3.3509 ,2.1389>, 0.1000
<0.6654 ,5.0263 ,3.2083>, 0.4000
}
cone {
<0.8779 ,3.2670 ,2.1344>, 0.1000
<1.3169 ,4.9005 ,3.2017>, 0.4000
}
cone {
<1.2979 ,3.1271 ,2.1300>, 0.1000
<1.9469 ,4.6906 ,3.1950>, 0.4000
}
cone {
<1.6964 ,2.9333 ,2.1256>, 0.1000
<2.5446 ,4.3999 ,3.1884>, 0.4000
}
cone {
<2.0664 ,2.6890 ,2.1211>, 0.1000
<3.0997 ,4.0335 ,3.1817>, 0.4000
}
cone {
<2.4017 ,2.3982 ,2.1167>, 0.1000
<3.6026 ,3.5973 ,3.1750>, 0.4000
}
cone {
<2.6964 ,2.0659 ,2.1122>, 0.1000
<4.0446 ,3.0988 ,3.1684>, 0.4000
}
cone {
<2.9454 ,1.6976 ,2.1078>, 0.1000
<4.4181 ,2.5465 ,3.1617>, 0.4000
}
cone {
<3.1443 ,1.2997 ,2.1033>, 0.1000
<4.7165 ,1.9496 ,3.1550>, 0.4000
}
cone {
<3.2897 ,0.8789 ,2.0989>, 0.1000
<4.9346 ,1.3183 ,3.1483>, 0.4000
}
cone {
<3.3790 ,0.4423 ,2.0944>, 0.1000
<5.0685 ,0.6635 ,3.1416>, 0.4000
}
cone {
<3.4106 ,-0.0025 ,2.0900>, 0.1000
<5.1159 ,-0.0038 ,3.1350>, 0.4000
}
cone {
<3.3838 ,-0.4480 ,2.0855>, 0.1000
<5.0757 ,-0.6720 ,3.1283>, 0.4000
}
cone {
<3.2990 ,-0.8866 ,2.0810>, 0.1000
<4.9485 ,-1.3299 ,3.1215>, 0.4000
}
cone {
<3.1575 ,-1.3106 ,2.0766>, 0.1000
<4.7363 ,-1.9660 ,3.1148>, 0.4000
}
cone {
<2.9618 ,-1.7129 ,2.0721>, 0.1000
<4.4427 ,-2.5694 ,3.1081>, 0.4000
}
cone {
<2.7150 ,-2.0865 ,2.0676>, 0.1000
<4.0726 ,-3.1298 ,3.1014>, 0.4000
}
cone {
<2.4214 ,-2.4250 ,2.0631>, 0.1000
<3.6320 ,-3.6375 ,3.0947>, 0.4000
}
cone {
<2.0858 ,-2.7224 ,2.0586>, 0.1000
<3.1286 ,-4.0836 ,3.0879>, 0.4000
}
cone {
<1.7139 ,-2.9737 ,2.0541>, 0.1000
<2.5709 ,-4.4606 ,3.0812>, 0.4000
}
cone {
<1.3121 ,-3.1745 ,2.0496>, 0.1000
<1.9682 ,-4.7617 ,3.0745>, 0.4000
}
cone {
<0.8872 ,-3.3212 ,2.0451>, 0.1000
<1.3308 ,-4.9818 ,3.0677>, 0.4000
}
cone {
<0.4465 ,-3.4112 ,2.0406>, 0.1000
<0.6697 ,-5.1168 ,3.0610>, 0.4000
}
cone {
<-0.0026 ,-3.4430 ,2.0361>, 0.1000
<-0.0039 ,-5.1645 ,3.0542>, 0.4000
}
cone {
<-0.4523 ,-3.4158 ,2.0316>, 0.1000
<-0.6785 ,-5.1237 ,3.0474>, 0.4000
}
cone {
<-0.8950 ,-3.3301 ,2.0271>, 0.1000
<-1.3425 ,-4.9952 ,3.0407>, 0.4000
}
cone {
<-1.3230 ,-3.1873 ,2.0226>, 0.1000
<-1.9846 ,-4.7809 ,3.0339>, 0.4000
}
cone {
<-1.7291 ,-2.9896 ,2.0181>, 0.1000
<-2.5936 ,-4.4844 ,3.0271>, 0.4000
}
cone {
<-2.1061 ,-2.7404 ,2.0136>, 0.1000
<-3.1592 ,-4.1106 ,3.0203>, 0.4000
}
cone {
<-2.4477 ,-2.4439 ,2.0090>, 0.1000
<-3.6715 ,-3.6659 ,3.0136>, 0.4000
}
cone {
<-2.7478 ,-2.1051 ,2.0045>, 0.1000
<-4.1217 ,-3.1577 ,3.0068>, 0.4000
}
cone {
<-3.0013 ,-1.7298 ,2.0000>, 0.1000
<-4.5020 ,-2.5946 ,3.0000>, 0.4000
}
cone {
<-3.2039 ,-1.3242 ,1.9954>, 0.1000
<-4.8058 ,-1.9863 ,2.9932>, 0.4000
}
cone {
<-3.3518 ,-0.8954 ,1.9909>, 0.1000
<-5.0277 ,-1.3430 ,2.9863>, 0.4000
}
cone {
<-3.4426 ,-0.4505 ,1.9864>, 0.1000
<-5.1639 ,-0.6758 ,2.9795>, 0.4000
}
cone {
<-3.4745 ,0.0027 ,1.9818>, 0.1000
<-5.2118 ,0.0040 ,2.9727>, 0.4000
}
cone {
<-3.4470 ,0.4565 ,1.9773>, 0.1000
<-5.1706 ,0.6848 ,2.9659>, 0.4000
}
cone {
<-3.3605 ,0.9032 ,1.9727>, 0.1000
<-5.0407 ,1.3548 ,2.9591>, 0.4000
}
cone {
<-3.2162 ,1.3351 ,1.9681>, 0.1000
<-4.8243 ,2.0027 ,2.9522>, 0.4000
}
cone {
<-3.0166 ,1.7448 ,1.9636>, 0.1000
<-4.5250 ,2.6172 ,2.9454>, 0.4000
}
cone {
<-2.7651 ,2.1252 ,1.9590>, 0.1000
<-4.1477 ,3.1878 ,2.9385>, 0.4000
}
cone {
<-2.4659 ,2.4697 ,1.9545>, 0.1000
<-3.6988 ,3.7046 ,2.9317>, 0.4000
}
cone {
<-2.1240 ,2.7725 ,1.9499>, 0.1000
<-3.1860 ,4.1587 ,2.9248>, 0.4000
}
cone {
<-1.7452 ,3.0282 ,1.9453>, 0.1000
<-2.6178 ,4.5423 ,2.9180>, 0.4000
}
cone {
<-1.3360 ,3.2325 ,1.9407>, 0.1000
<-2.0039 ,4.8487 ,2.9111>, 0.4000
}
cone {
<-0.9033 ,3.3816 ,1.9362>, 0.1000
<-1.3549 ,5.0724 ,2.9042>, 0.4000
}
cone {
<-0.4545 ,3.4731 ,1.9316>, 0.1000
<-0.6817 ,5.2097 ,2.8974>, 0.4000
}
cone {
<0.0028 ,3.5052 ,1.9270>, 0.1000
<0.0041 ,5.2579 ,2.8905>, 0.4000
}
cone {
<0.4606 ,3.4774 ,1.9224>, 0.1000
<0.6909 ,5.2161 ,2.8836>, 0.4000
}
cone {
<0.9112 ,3.3899 ,1.9178>, 0.1000
<1.3668 ,5.0849 ,2.8767>, 0.4000
}
cone {
<1.3469 ,3.2443 ,1.9132>, 0.1000
<2.0203 ,4.8665 ,2.8698>, 0.4000
}
cone {
<1.7601 ,3.0429 ,1.9086>, 0.1000
<2.6401 ,4.5644 ,2.8629>, 0.4000
}
cone {
<2.1437 ,2.7891 ,1.9040>, 0.1000
<3.2156 ,4.1837 ,2.8560>, 0.4000
}
cone {
<2.4912 ,2.4872 ,1.8994>, 0.1000
<3.7368 ,3.7308 ,2.8491>, 0.4000
}
cone {
<2.7965 ,2.1423 ,1.8948>, 0.1000
<4.1947 ,3.2134 ,2.8422>, 0.4000
}
cone {
<3.0543 ,1.7602 ,1.8902>, 0.1000
<4.5815 ,2.6403 ,2.8353>, 0.4000
}
cone {
<3.2602 ,1.3474 ,1.8856>, 0.1000
<4.8904 ,2.0211 ,2.8283>, 0.4000
}
cone {
<3.4106 ,0.9109 ,1.8809>, 0.1000
<5.1159 ,1.3664 ,2.8214>, 0.4000
}
cone {
<3.5028 ,0.4583 ,1.8763>, 0.1000
<5.2542 ,0.6874 ,2.8145>, 0.4000
}
cone {
<3.5351 ,-0.0028 ,1.8717>, 0.1000
<5.3026 ,-0.0043 ,2.8075>, 0.4000
}
cone {
<3.5069 ,-0.4646 ,1.8671>, 0.1000
<5.2603 ,-0.6968 ,2.8006>, 0.4000
}
cone {
<3.4186 ,-0.9190 ,1.8624>, 0.1000
<5.1279 ,-1.3785 ,2.7936>, 0.4000
}
cone {
<3.2717 ,-1.3583 ,1.8578>, 0.1000
<4.9075 ,-2.0374 ,2.7867>, 0.4000
}
cone {
<3.0685 ,-1.7749 ,1.8532>, 0.1000
<4.6027 ,-2.6623 ,2.7797>, 0.4000
}
cone {
<2.8125 ,-2.1617 ,1.8485>, 0.1000
<4.2187 ,-3.2426 ,2.7728>, 0.4000
}
cone {
<2.5080 ,-2.5120 ,1.8439>, 0.1000
<3.7619 ,-3.7680 ,2.7658>, 0.4000
}
cone {
<2.1601 ,-2.8198 ,1.8392>, 0.1000
<3.2401 ,-4.2297 ,2.7588>, 0.4000
}
cone {
<1.7747 ,-3.0797 ,1.8346>, 0.1000
<2.6621 ,-4.6196 ,2.7519>, 0.4000
}
cone {
<1.3585 ,-3.2872 ,1.8299>, 0.1000
<2.0377 ,-4.9309 ,2.7449>, 0.4000
}
cone {
<0.9184 ,-3.4387 ,1.8253>, 0.1000
<1.3776 ,-5.1581 ,2.7379>, 0.4000
}
cone {
<0.4620 ,-3.5316 ,1.8206>, 0.1000
<0.6930 ,-5.2974 ,2.7309>, 0.4000
}
cone {
<-0.0029 ,-3.5640 ,1.8159>, 0.1000
<-0.0044 ,-5.3461 ,2.7239>, 0.4000
}
cone {
<-0.4684 ,-3.5355 ,1.8113>, 0.1000
<-0.7026 ,-5.3033 ,2.7169>, 0.4000
}
cone {
<-0.9265 ,-3.4464 ,1.8066>, 0.1000
<-1.3898 ,-5.1696 ,2.7099>, 0.4000
}
cone {
<-1.3693 ,-3.2982 ,1.8019>, 0.1000
<-2.0540 ,-4.9473 ,2.7029>, 0.4000
}
cone {
<-1.7893 ,-3.0933 ,1.7972>, 0.1000
<-2.6840 ,-4.6399 ,2.6959>, 0.4000
}
cone {
<-2.1792 ,-2.8351 ,1.7926>, 0.1000
<-3.2688 ,-4.2527 ,2.6889>, 0.4000
}
cone {
<-2.5323 ,-2.5281 ,1.7879>, 0.1000
<-3.7984 ,-3.7921 ,2.6818>, 0.4000
}
cone {
<-2.8424 ,-2.1773 ,1.7832>, 0.1000
<-4.2636 ,-3.2660 ,2.6748>, 0.4000
}
cone {
<-3.1043 ,-1.7889 ,1.7785>, 0.1000
<-4.6565 ,-2.6833 ,2.6678>, 0.4000
}
cone {
<-3.3134 ,-1.3692 ,1.7738>, 0.1000
<-4.9701 ,-2.0539 ,2.6607>, 0.4000
}
cone {
<-3.4660 ,-0.9256 ,1.7691>, 0.1000
<-5.1991 ,-1.3884 ,2.6537>, 0.4000
}
cone {
<-3.5595 ,-0.4656 ,1.7644>, 0.1000
<-5.3392 ,-0.6984 ,2.6466>, 0.4000
}
cone {
<-3.5921 ,0.0030 ,1.7597>, 0.1000
<-5.3882 ,0.0045 ,2.6396>, 0.4000
}
cone {
<-3.5633 ,0.4722 ,1.7550>, 0.1000
<-5.3449 ,0.7082 ,2.6325>, 0.4000
}
cone {
<-3.4734 ,0.9338 ,1.7503>, 0.1000
<-5.2101 ,1.4007 ,2.6255>, 0.4000
}
cone {
<-3.3239 ,1.3801 ,1.7456>, 0.1000
<-4.9858 ,2.0701 ,2.6184>, 0.4000
}
cone {
<-3.1173 ,1.8032 ,1.7409>, 0.1000
<-4.6760 ,2.7048 ,2.6113>, 0.4000
}
cone {
<-2.8571 ,2.1961 ,1.7362>, 0.1000
<-4.2856 ,3.2941 ,2.6043>, 0.4000
}
cone {
<-2.5476 ,2.5518 ,1.7315>, 0.1000
<-3.8214 ,3.8277 ,2.5972>, 0.4000
}
cone {
<-2.1941 ,2.8643 ,1.7267>, 0.1000
<-3.2912 ,4.2964 ,2.5901>, 0.4000
}
cone {
<-1.8027 ,3.1281 ,1.7220>, 0.1000
<-2.7040 ,4.6922 ,2.5830>, 0.4000
}
cone {
<-1.3798 ,3.3387 ,1.7173>, 0.1000
<-2.0697 ,5.0081 ,2.5759>, 0.4000
}
cone {
<-0.9328 ,3.4924 ,1.7126>, 0.1000
<-1.3992 ,5.2386 ,2.5688>, 0.4000
}
cone {
<-0.4693 ,3.5865 ,1.7078>, 0.1000
<-0.7039 ,5.3798 ,2.5617>, 0.4000
}
cone {
<0.0028 ,3.6193 ,1.7031>, 0.1000
<0.0043 ,5.4290 ,2.5546>, 0.4000
}
cone {
<0.4755 ,3.5902 ,1.6983>, 0.1000
<0.7133 ,5.3853 ,2.5475>, 0.4000
}
cone {
<0.9406 ,3.4996 ,1.6936>, 0.1000
<1.4109 ,5.2493 ,2.5404>, 0.4000
}
cone {
<1.3902 ,3.3489 ,1.6889>, 0.1000
<2.0853 ,5.0233 ,2.5333>, 0.4000
}
cone {
<1.8165 ,3.1407 ,1.6841>, 0.1000
<2.7247 ,4.7111 ,2.5262>, 0.4000
}
cone {
<2.2122 ,2.8785 ,1.6794>, 0.1000
<3.3183 ,4.3178 ,2.5190>, 0.4000
}
cone {
<2.5706 ,2.5667 ,1.6746>, 0.1000
<3.8558 ,3.8500 ,2.5119>, 0.4000
}
cone {
<2.8853 ,2.2105 ,1.6699>, 0.1000
<4.3280 ,3.3158 ,2.5048>, 0.4000
}
cone {
<3.1510 ,1.8161 ,1.6651>, 0.1000
<4.7266 ,2.7242 ,2.4976>, 0.4000
}
cone {
<3.3631 ,1.3902 ,1.6603>, 0.1000
<5.0447 ,2.0852 ,2.4905>, 0.4000
}
cone {
<3.5179 ,0.9399 ,1.6556>, 0.1000
<5.2769 ,1.4098 ,2.4834>, 0.4000
}
cone {
<3.6126 ,0.4729 ,1.6508>, 0.1000
<5.4190 ,0.7094 ,2.4762>, 0.4000
}
cone {
<3.6456 ,-0.0026 ,1.6460>, 0.1000
<5.4684 ,-0.0040 ,2.4690>, 0.4000
}
cone {
<3.6162 ,-0.4787 ,1.6413>, 0.1000
<5.4243 ,-0.7181 ,2.4619>, 0.4000
}
cone {
<3.5249 ,-0.9472 ,1.6365>, 0.1000
<5.2873 ,-1.4208 ,2.4547>, 0.4000
}
cone {
<3.3731 ,-1.4000 ,1.6317>, 0.1000
<5.0596 ,-2.1000 ,2.4476>, 0.4000
}
cone {
<3.1633 ,-1.8293 ,1.6269>, 0.1000
<4.7450 ,-2.7440 ,2.4404>, 0.4000
}
cone {
<2.8992 ,-2.2278 ,1.6221>, 0.1000
<4.3488 ,-3.3418 ,2.4332>, 0.4000
}
cone {
<2.5851 ,-2.5887 ,1.6173>, 0.1000
<3.8777 ,-3.8830 ,2.4260>, 0.4000
}
cone {
<2.2264 ,-2.9056 ,1.6126>, 0.1000
<3.3396 ,-4.3585 ,2.4188>, 0.4000
}
cone {
<1.8292 ,-3.1732 ,1.6078>, 0.1000
<2.7438 ,-4.7598 ,2.4116>, 0.4000
}
cone {
<1.4002 ,-3.3867 ,1.6030>, 0.1000
<2.1002 ,-5.0801 ,2.4045>, 0.4000
}
cone {
<0.9467 ,-3.5425 ,1.5982>, 0.1000
<1.4200 ,-5.3138 ,2.3973>, 0.4000
}
cone {
<0.4765 ,-3.6379 ,1.5934>, 0.1000
<0.7147 ,-5.4568 ,2.3901>, 0.4000
}
cone {
<-0.0024 ,-3.6710 ,1.5886>, 0.1000
<-0.0036 ,-5.5065 ,2.3829>, 0.4000
}
cone {
<-0.4818 ,-3.6414 ,1.5838>, 0.1000
<-0.7227 ,-5.4621 ,2.3756>, 0.4000
}
cone {
<-0.9535 ,-3.5493 ,1.5790>, 0.1000
<-1.4303 ,-5.3240 ,2.3684>, 0.4000
}
cone {
<-1.4094 ,-3.3964 ,1.5741>, 0.1000
<-2.1141 ,-5.0946 ,2.3612>, 0.4000
}
cone {
<-1.8417 ,-3.1852 ,1.5693>, 0.1000
<-2.7625 ,-4.7778 ,2.3540>, 0.4000
}
cone {
<-2.2429 ,-2.9192 ,1.5645>, 0.1000
<-3.3644 ,-4.3788 ,2.3468>, 0.4000
}
cone {
<-2.6062 ,-2.6029 ,1.5597>, 0.1000
<-3.9093 ,-3.9044 ,2.3395>, 0.4000
}
cone {
<-2.9252 ,-2.2417 ,1.5549>, 0.1000
<-4.3879 ,-3.3626 ,2.3323>, 0.4000
}
cone {
<-3.1946 ,-1.8418 ,1.5500>, 0.1000
<-4.7919 ,-2.7626 ,2.3251>, 0.4000
}
cone {
<-3.4095 ,-1.4098 ,1.5452>, 0.1000
<-5.1143 ,-2.1147 ,2.3178>, 0.4000
}
cone {
<-3.5663 ,-0.9533 ,1.5404>, 0.1000
<-5.3495 ,-1.4299 ,2.3106>, 0.4000
}
cone {
<-3.6622 ,-0.4799 ,1.5355>, 0.1000
<-5.4933 ,-0.7198 ,2.3033>, 0.4000
}
cone {
<-3.6955 ,0.0022 ,1.5307>, 0.1000
<-5.5433 ,0.0033 ,2.2961>, 0.4000
}
cone {
<-3.6656 ,0.4848 ,1.5259>, 0.1000
<-5.4984 ,0.7272 ,2.2888>, 0.4000
}
cone {
<-3.5729 ,0.9596 ,1.5210>, 0.1000
<-5.3594 ,1.4394 ,2.2815>, 0.4000
}
cone {
<-3.4189 ,1.4185 ,1.5162>, 0.1000
<-5.1284 ,2.1277 ,2.2743>, 0.4000
}
cone {
<-3.2063 ,1.8536 ,1.5113>, 0.1000
<-4.8094 ,2.7804 ,2.2670>, 0.4000
}
cone {
<-2.9385 ,2.2574 ,1.5065>, 0.1000
<-4.4077 ,3.3861 ,2.2597>, 0.4000
}
cone {
<-2.6201 ,2.6230 ,1.5016>, 0.1000
<-3.9301 ,3.9345 ,2.2525>, 0.4000
}
cone {
<-2.2565 ,2.9441 ,1.4968>, 0.1000
<-3.3847 ,4.4162 ,2.2452>, 0.4000
}
cone {
<-1.8539 ,3.2152 ,1.4919>, 0.1000
<-2.7808 ,4.8227 ,2.2379>, 0.4000
}
cone {
<-1.4191 ,3.4314 ,1.4871>, 0.1000
<-2.1287 ,5.1471 ,2.2306>, 0.4000
}
cone {
<-0.9596 ,3.5892 ,1.4822>, 0.1000
<-1.4394 ,5.3838 ,2.2233>, 0.4000
}
cone {
<-0.4832 ,3.6856 ,1.4773>, 0.1000
<-0.7248 ,5.5285 ,2.2160>, 0.4000
}
cone {
<0.0020 ,3.7191 ,1.4725>, 0.1000
<0.0030 ,5.5787 ,2.2087>, 0.4000
}
cone {
<0.4876 ,3.6889 ,1.4676>, 0.1000
<0.7315 ,5.5334 ,2.2014>, 0.4000
}
cone {
<0.9654 ,3.5956 ,1.4627>, 0.1000
<1.4482 ,5.3934 ,2.1941>, 0.4000
}
cone {
<1.4272 ,3.4406 ,1.4579>, 0.1000
<2.1408 ,5.1609 ,2.1868>, 0.4000
}
cone {
<1.8650 ,3.2265 ,1.4530>, 0.1000
<2.7976 ,4.8398 ,2.1795>, 0.4000
}
cone {
<2.2714 ,2.9570 ,1.4481>, 0.1000
<3.4071 ,4.4355 ,2.1722>, 0.4000
}
cone {
<2.6392 ,2.6366 ,1.4432>, 0.1000
<3.9588 ,3.9549 ,2.1648>, 0.4000
}
cone {
<2.9623 ,2.2707 ,1.4383>, 0.1000
<4.4434 ,3.4061 ,2.1575>, 0.4000
}
cone {
<3.2349 ,1.8656 ,1.4335>, 0.1000
<4.8524 ,2.7984 ,2.1502>, 0.4000
}
cone {
<3.4525 ,1.4281 ,1.4286>, 0.1000
<5.1787 ,2.1422 ,2.1428>, 0.4000
}
cone {
<3.6112 ,0.9658 ,1.4237>, 0.1000
<5.4167 ,1.4486 ,2.1355>, 0.4000
}
cone {
<3.7082 ,0.4864 ,1.4188>, 0.1000
<5.5622 ,0.7296 ,2.1282>, 0.4000
}
cone {
<3.7418 ,-0.0018 ,1.4139>, 0.1000
<5.6127 ,-0.0026 ,2.1208>, 0.4000
}
cone {
<3.7114 ,-0.4904 ,1.4090>, 0.1000
<5.5671 ,-0.7355 ,2.1135>, 0.4000
}
cone {
<3.6174 ,-0.9711 ,1.4041>, 0.1000
<5.4261 ,-1.4566 ,2.1061>, 0.4000
}
cone {
<3.4614 ,-1.4356 ,1.3992>, 0.1000
<5.1921 ,-2.1534 ,2.0988>, 0.4000
}
cone {
<3.2460 ,-1.8760 ,1.3943>, 0.1000
<4.8690 ,-2.8140 ,2.0914>, 0.4000
}
cone {
<2.9748 ,-2.2848 ,1.3894>, 0.1000
<4.4622 ,-3.4271 ,2.0840>, 0.4000
}
cone {
<2.6524 ,-2.6548 ,1.3845>, 0.1000
<3.9787 ,-3.9822 ,2.0767>, 0.4000
}
cone {
<2.2844 ,-2.9797 ,1.3795>, 0.1000
<3.4265 ,-4.4695 ,2.0693>, 0.4000
}
cone {
<1.8768 ,-3.2539 ,1.3746>, 0.1000
<2.8152 ,-4.8809 ,2.0619>, 0.4000
}
cone {
<1.4367 ,-3.4727 ,1.3697>, 0.1000
<2.1551 ,-5.2091 ,2.0546>, 0.4000
}
cone {
<0.9716 ,-3.6323 ,1.3648>, 0.1000
<1.4575 ,-5.4484 ,2.0472>, 0.4000
}
cone {
<0.4895 ,-3.7298 ,1.3599>, 0.1000
<0.7342 ,-5.5947 ,2.0398>, 0.4000
}
cone {
<-0.0015 ,-3.7635 ,1.3549>, 0.1000
<-0.0023 ,-5.6453 ,2.0324>, 0.4000
}
cone {
<-0.4930 ,-3.7329 ,1.3500>, 0.1000
<-0.7394 ,-5.5993 ,2.0250>, 0.4000
}
cone {
<-0.9764 ,-3.6383 ,1.3451>, 0.1000
<-1.4646 ,-5.4575 ,2.0176>, 0.4000
}
cone {
<-1.4436 ,-3.4814 ,1.3401>, 0.1000
<-2.1654 ,-5.2221 ,2.0102>, 0.4000
}
cone {
<-1.8865 ,-3.2647 ,1.3352>, 0.1000
<-2.8298 ,-4.8970 ,2.0028>, 0.4000
}
cone {
<-2.2976 ,-2.9919 ,1.3303>, 0.1000
<-3.4464 ,-4.4879 ,1.9954>, 0.4000
}
cone {
<-2.6697 ,-2.6677 ,1.3253>, 0.1000
<-4.0045 ,-4.0015 ,1.9880>, 0.4000
}
cone {
<-2.9964 ,-2.2974 ,1.3204>, 0.1000
<-4.4946 ,-3.4462 ,1.9806>, 0.4000
}
cone {
<-3.2721 ,-1.8876 ,1.3155>, 0.1000
<-4.9082 ,-2.8313 ,1.9732>, 0.4000
}
cone {
<-3.4921 ,-1.4450 ,1.3105>, 0.1000
<-5.2381 ,-2.1675 ,1.9658>, 0.4000
}
cone {
<-3.6525 ,-0.9773 ,1.3056>, 0.1000
<-5.4787 ,-1.4659 ,1.9583>, 0.4000
}
cone {
<-3.7505 ,-0.4924 ,1.3006>, 0.1000
<-5.6257 ,-0.7386 ,1.9509>, 0.4000
}
cone {
<-3.7843 ,0.0013 ,1.2957>, 0.1000
<-5.6765 ,0.0019 ,1.9435>, 0.4000
}
cone {
<-3.7535 ,0.4954 ,1.2907>, 0.1000
<-5.6302 ,0.7432 ,1.9361>, 0.4000
}
cone {
<-3.6583 ,0.9815 ,1.2857>, 0.1000
<-5.4875 ,1.4723 ,1.9286>, 0.4000
}
cone {
<-3.5005 ,1.4513 ,1.2808>, 0.1000
<-5.2507 ,2.1769 ,1.9212>, 0.4000
}
cone {
<-3.2826 ,1.8966 ,1.2758>, 0.1000
<-4.9238 ,2.8449 ,1.9137>, 0.4000
}
cone {
<-3.0083 ,2.3098 ,1.2709>, 0.1000
<-4.5124 ,3.4647 ,1.9063>, 0.4000
}
cone {
<-2.6822 ,2.6839 ,1.2659>, 0.1000
<-4.0233 ,4.0258 ,1.8988>, 0.4000
}
cone {
<-2.3100 ,3.0123 ,1.2609>, 0.1000
<-3.4650 ,4.5185 ,1.8914>, 0.4000
}
cone {
<-1.8979 ,3.2895 ,1.2560>, 0.1000
<-2.8468 ,4.9342 ,1.8839>, 0.4000
}
cone {
<-1.4529 ,3.5106 ,1.2510>, 0.1000
<-2.1794 ,5.2659 ,1.8765>, 0.4000
}
cone {
<-0.9827 ,3.6718 ,1.2460>, 0.1000
<-1.4741 ,5.5076 ,1.8690>, 0.4000
}
cone {
<-0.4953 ,3.7702 ,1.2410>, 0.1000
<-0.7429 ,5.6553 ,1.8616>, 0.4000
}
cone {
<0.0011 ,3.8042 ,1.2361>, 0.1000
<0.0016 ,5.7063 ,1.8541>, 0.4000
}
cone {
<0.4978 ,3.7731 ,1.2311>, 0.1000
<0.7467 ,5.6597 ,1.8466>, 0.4000
}
cone {
<0.9864 ,3.6775 ,1.2261>, 0.1000
<1.4796 ,5.5162 ,1.8391>, 0.4000
}
cone {
<1.4586 ,3.5187 ,1.2211>, 0.1000
<2.1879 ,5.2781 ,1.8317>, 0.4000
}
cone {
<1.9062 ,3.2996 ,1.2161>, 0.1000
<2.8593 ,4.9494 ,1.8242>, 0.4000
}
cone {
<2.3215 ,3.0239 ,1.2111>, 0.1000
<3.4823 ,4.5358 ,1.8167>, 0.4000
}
cone {
<2.6974 ,2.6961 ,1.2061>, 0.1000
<4.0462 ,4.0442 ,1.8092>, 0.4000
}
cone {
<3.0275 ,2.3219 ,1.2011>, 0.1000
<4.5413 ,3.4829 ,1.8017>, 0.4000
}
cone {
<3.3060 ,1.9077 ,1.1962>, 0.1000
<4.9591 ,2.8615 ,1.7942>, 0.4000
}
cone {
<3.5282 ,1.4605 ,1.1912>, 0.1000
<5.2923 ,2.1907 ,1.7867>, 0.4000
}
cone {
<3.6901 ,0.9879 ,1.1862>, 0.1000
<5.5352 ,1.4818 ,1.7792>, 0.4000
}
cone {
<3.7890 ,0.4980 ,1.1812>, 0.1000
<5.6836 ,0.7470 ,1.7717>, 0.4000
}
cone {
<3.8232 ,-0.0008 ,1.1762>, 0.1000
<5.7348 ,-0.0012 ,1.7642>, 0.4000
}
cone {
<3.7919 ,-0.5000 ,1.1711>, 0.1000
<5.6878 ,-0.7500 ,1.7567>, 0.4000
}
cone {
<3.6957 ,-0.9911 ,1.1661>, 0.1000
<5.5435 ,-1.4866 ,1.7492>, 0.4000
}
cone {
<3.5361 ,-1.4655 ,1.1611>, 0.1000
<5.3042 ,-2.1983 ,1.7417>, 0.4000
}
cone {
<3.3159 ,-1.9153 ,1.1561>, 0.1000
<4.9738 ,-2.8729 ,1.7342>, 0.4000
}
cone {
<3.0387 ,-2.3326 ,1.1511>, 0.1000
<4.5581 ,-3.4989 ,1.7267>, 0.4000
}
cone {
<2.7093 ,-2.7103 ,1.1461>, 0.1000
<4.0640 ,-4.0655 ,1.7191>, 0.4000
}
cone {
<2.3333 ,-3.0420 ,1.1411>, 0.1000
<3.5000 ,-4.5630 ,1.7116>, 0.4000
}
cone {
<1.9171 ,-3.3218 ,1.1361>, 0.1000
<2.8756 ,-4.9827 ,1.7041>, 0.4000
}
cone {
<1.4677 ,-3.5450 ,1.1310>, 0.1000
<2.2015 ,-5.3174 ,1.6966>, 0.4000
}
cone {
<0.9928 ,-3.7076 ,1.1260>, 0.1000
<1.4892 ,-5.5614 ,1.6890>, 0.4000
}
cone {
<0.5006 ,-3.8069 ,1.1210>, 0.1000
<0.7509 ,-5.7104 ,1.6815>, 0.4000
}
cone {
<-0.0006 ,-3.8412 ,1.1160>, 0.1000
<-0.0009 ,-5.7618 ,1.6739>, 0.4000
}
cone {
<-0.5021 ,-3.8097 ,1.1109>, 0.1000
<-0.7532 ,-5.7145 ,1.6664>, 0.4000
}
cone {
<-0.9954 ,-3.7130 ,1.1059>, 0.1000
<-1.4932 ,-5.5694 ,1.6588>, 0.4000
}
cone {
<-1.4721 ,-3.5526 ,1.1009>, 0.1000
<-2.2082 ,-5.3289 ,1.6513>, 0.4000
}
cone {
<-1.9239 ,-3.3313 ,1.0958>, 0.1000
<-2.8859 ,-4.9970 ,1.6437>, 0.4000
}
cone {
<-2.3431 ,-3.0528 ,1.0908>, 0.1000
<-3.5147 ,-4.5793 ,1.6362>, 0.4000
}
cone {
<-2.7226 ,-2.7219 ,1.0858>, 0.1000
<-4.0838 ,-4.0829 ,1.6286>, 0.4000
}
cone {
<-3.0557 ,-2.3441 ,1.0807>, 0.1000
<-4.5835 ,-3.5162 ,1.6211>, 0.4000
}
cone {
<-3.3367 ,-1.9260 ,1.0757>, 0.1000
<-5.0051 ,-2.8889 ,1.6135>, 0.4000
}
cone {
<-3.5608 ,-1.4745 ,1.0706>, 0.1000
<-5.3413 ,-2.2118 ,1.6059>, 0.4000
}
cone {
<-3.7242 ,-0.9975 ,1.0656>, 0.1000
<-5.5863 ,-1.4962 ,1.5984>, 0.4000
}
cone {
<-3.8239 ,-0.5031 ,1.0605>, 0.1000
<-5.7358 ,-0.7546 ,1.5908>, 0.4000
}
cone {
<-3.8582 ,0.0003 ,1.0555>, 0.1000
<-5.7873 ,0.0005 ,1.5832>, 0.4000
}
cone {
<-3.8265 ,0.5041 ,1.0504>, 0.1000
<-5.7398 ,0.7561 ,1.5757>, 0.4000
}
cone {
<-3.7293 ,0.9996 ,1.0454>, 0.1000
<-5.5940 ,1.4994 ,1.5681>, 0.4000
}
cone {
<-3.5682 ,1.4783 ,1.0403>, 0.1000
<-5.3524 ,2.2175 ,1.5605>, 0.4000
}
cone {
<-3.3459 ,1.9321 ,1.0353>, 0.1000
<-5.0189 ,2.8981 ,1.5529>, 0.4000
}
cone {
<-3.0662 ,2.3531 ,1.0302>, 0.1000
<-4.5993 ,3.5296 ,1.5453>, 0.4000
}
cone {
<-2.7338 ,2.7341 ,1.0252>, 0.1000
<-4.1007 ,4.1012 ,1.5377>, 0.4000
}
cone {
<-2.3544 ,3.0686 ,1.0201>, 0.1000
<-3.5316 ,4.6029 ,1.5301>, 0.4000
}
cone {
<-1.9344 ,3.3508 ,1.0150>, 0.1000
<-2.9016 ,5.0262 ,1.5225>, 0.4000
}
cone {
<-1.4810 ,3.5758 ,1.0100>, 0.1000
<-2.2215 ,5.3638 ,1.5149>, 0.4000
}
cone {
<-1.0019 ,3.7398 ,1.0049>, 0.1000
<-1.5029 ,5.6097 ,1.5073>, 0.4000
}
cone {
<-0.5054 ,3.8399 ,0.9998>, 0.1000
<-0.7581 ,5.7599 ,1.4997>, 0.4000
}
cone {
<0.0001 ,3.8743 ,0.9948>, 0.1000
<0.0001 ,5.8115 ,1.4921>, 0.4000
}
cone {
<0.5059 ,3.8425 ,0.9897>, 0.1000
<0.7589 ,5.7637 ,1.4845>, 0.4000
}
cone {
<1.0035 ,3.7448 ,0.9846>, 0.1000
<1.5052 ,5.6172 ,1.4769>, 0.4000
}
cone {
<1.4842 ,3.5830 ,0.9795>, 0.1000
<2.2262 ,5.3745 ,1.4693>, 0.4000
}
cone {
<1.9398 ,3.3597 ,0.9745>, 0.1000
<2.9096 ,5.0396 ,1.4617>, 0.4000
}
cone {
<2.3625 ,3.0788 ,0.9694>, 0.1000
<3.5437 ,4.6182 ,1.4541>, 0.4000
}
cone {
<2.7450 ,2.7450 ,0.9643>, 0.1000
<4.1175 ,4.1175 ,1.4464>, 0.4000
}
cone {
<3.0808 ,2.3640 ,0.9592>, 0.1000
<4.6212 ,3.5460 ,1.4388>, 0.4000
}
cone {
<3.3641 ,1.9423 ,0.9541>, 0.1000
<5.0461 ,2.9135 ,1.4312>, 0.4000
}
cone {
<3.5900 ,1.4871 ,0.9490>, 0.1000
<5.3849 ,2.2307 ,1.4236>, 0.4000
}
cone {
<3.7545 ,1.0061 ,0.9440>, 0.1000
<5.6318 ,1.5092 ,1.4159>, 0.4000
}
cone {
<3.8550 ,0.5076 ,0.9389>, 0.1000
<5.7825 ,0.7615 ,1.4083>, 0.4000
}
cone {
<3.8895 ,0.0001 ,0.9338>, 0.1000
<5.8342 ,0.0002 ,1.4007>, 0.4000
}
cone {
<3.8574 ,-0.5077 ,0.9287>, 0.1000
<5.7862 ,-0.7615 ,1.3930>, 0.4000
}
cone {
<3.7593 ,-1.0071 ,0.9236>, 0.1000
<5.6390 ,-1.5107 ,1.3854>, 0.4000
}
cone {
<3.5969 ,-1.4896 ,0.9185>, 0.1000
<5.3953 ,-2.2345 ,1.3778>, 0.4000
}
cone {
<3.3727 ,-1.9470 ,0.9134>, 0.1000
<5.0590 ,-2.9204 ,1.3701>, 0.4000
}
cone {
<3.0907 ,-2.3712 ,0.9083>, 0.1000
<4.6360 ,-3.5569 ,1.3625>, 0.4000
}
cone {
<2.7556 ,-2.7552 ,0.9032>, 0.1000
<4.1334 ,-4.1328 ,1.3548>, 0.4000
}
cone {
<2.3731 ,-3.0922 ,0.8981>, 0.1000
<3.5597 ,-4.6383 ,1.3472>, 0.4000
}
cone {
<1.9498 ,-3.3765 ,0.8930>, 0.1000
<2.9247 ,-5.0648 ,1.3395>, 0.4000
}
cone {
<1.4929 ,-3.6032 ,0.8879>, 0.1000
<2.2393 ,-5.4048 ,1.3318>, 0.4000
}
cone {
<1.0101 ,-3.7683 ,0.8828>, 0.1000
<1.5151 ,-5.6525 ,1.3242>, 0.4000
}
cone {
<0.5098 ,-3.8691 ,0.8777>, 0.1000
<0.7646 ,-5.8036 ,1.3165>, 0.4000
}
cone {
<0.0004 ,-3.9037 ,0.8726>, 0.1000
<0.0006 ,-5.8555 ,1.3089>, 0.4000
}
cone {
<-0.5093 ,-3.8715 ,0.8675>, 0.1000
<-0.7639 ,-5.8072 ,1.3012>, 0.4000
}
cone {
<-1.0105 ,-3.7730 ,0.8624>, 0.1000
<-1.5158 ,-5.6594 ,1.2935>, 0.4000
}
cone {
<-1.4947 ,-3.6098 ,0.8572>, 0.1000
<-2.2421 ,-5.4147 ,1.2859>, 0.4000
}
cone {
<-1.9537 ,-3.3848 ,0.8521>, 0.1000
<-2.9305 ,-5.0772 ,1.2782>, 0.4000
}
cone {
<-2.3794 ,-3.1018 ,0.8470>, 0.1000
<-3.5691 ,-4.6526 ,1.2705>, 0.4000
}
cone {
<-2.7647 ,-2.7654 ,0.8419>, 0.1000
<-4.1471 ,-4.1482 ,1.2628>, 0.4000
}
cone {
<-3.1029 ,-2.3816 ,0.8368>, 0.1000
<-4.6543 ,-3.5724 ,1.2552>, 0.4000
}
cone {
<-3.3881 ,-1.9568 ,0.8317>, 0.1000
<-5.0822 ,-2.9352 ,1.2475>, 0.4000
}
cone {
<-3.6155 ,-1.4982 ,0.8265>, 0.1000
<-5.4233 ,-2.2474 ,1.2398>, 0.4000
}
cone {
<-3.7812 ,-1.0138 ,0.8214>, 0.1000
<-5.6718 ,-1.5207 ,1.2321>, 0.4000
}
cone {
<-3.8822 ,-0.5117 ,0.8163>, 0.1000
<-5.8234 ,-0.7676 ,1.2244>, 0.4000
}
cone {
<-3.9169 ,-0.0006 ,0.8112>, 0.1000
<-5.8753 ,-0.0010 ,1.2167>, 0.4000
}
cone {
<-3.8845 ,0.5107 ,0.8060>, 0.1000
<-5.8268 ,0.7661 ,1.2090>, 0.4000
}
cone {
<-3.7856 ,1.0136 ,0.8009>, 0.1000
<-5.6785 ,1.5205 ,1.2013>, 0.4000
}
cone {
<-3.6219 ,1.4995 ,0.7958>, 0.1000
<-5.4329 ,2.2492 ,1.1937>, 0.4000
}
cone {
<-3.3961 ,1.9599 ,0.7906>, 0.1000
<-5.0942 ,2.9399 ,1.1860>, 0.4000
}
cone {
<-3.1121 ,2.3870 ,0.7855>, 0.1000
<-4.6681 ,3.5806 ,1.1783>, 0.4000
}
cone {
<-2.7746 ,2.7735 ,0.7804>, 0.1000
<-4.1619 ,4.1603 ,1.1706>, 0.4000
}
cone {
<-2.3895 ,3.1128 ,0.7752>, 0.1000
<-3.5843 ,4.6691 ,1.1629>, 0.4000
}
cone {
<-1.9633 ,3.3989 ,0.7701>, 0.1000
<-2.9449 ,5.0983 ,1.1551>, 0.4000
}
cone {
<-1.5033 ,3.6270 ,0.7650>, 0.1000
<-2.2549 ,5.4405 ,1.1474>, 0.4000
}
cone {
<-1.0173 ,3.7931 ,0.7598>, 0.1000
<-1.5259 ,5.6897 ,1.1397>, 0.4000
}
cone {
<-0.5136 ,3.8944 ,0.7547>, 0.1000
<-0.7704 ,5.8417 ,1.1320>, 0.4000
}
cone {
<-0.0009 ,3.9291 ,0.7495>, 0.1000
<-0.0013 ,5.8937 ,1.1243>, 0.4000
}
cone {
<0.5121 ,3.8966 ,0.7444>, 0.1000
<0.7681 ,5.8449 ,1.1166>, 0.4000
}
cone {
<1.0165 ,3.7974 ,0.7392>, 0.1000
<1.5248 ,5.6961 ,1.1089>, 0.4000
}
cone {
<1.5038 ,3.6331 ,0.7341>, 0.1000
<2.2558 ,5.4497 ,1.1011>, 0.4000
}
cone {
<1.9657 ,3.4066 ,0.7290>, 0.1000
<2.9485 ,5.1099 ,1.0934>, 0.4000
}
cone {
<2.3941 ,3.1216 ,0.7238>, 0.1000
<3.5911 ,4.6825 ,1.0857>, 0.4000
}
cone {
<2.7817 ,2.7831 ,0.7187>, 0.1000
<4.1725 ,4.1747 ,1.0780>, 0.4000
}
cone {
<3.1219 ,2.3968 ,0.7135>, 0.1000
<4.6828 ,3.5952 ,1.0703>, 0.4000
}
cone {
<3.4088 ,1.9693 ,0.7083>, 0.1000
<5.1132 ,2.9540 ,1.0625>, 0.4000
}
cone {
<3.6375 ,1.5079 ,0.7032>, 0.1000
<5.4563 ,2.2618 ,1.0548>, 0.4000
}
cone {
<3.8041 ,1.0205 ,0.6980>, 0.1000
<5.7062 ,1.5307 ,1.0471>, 0.4000
}
cone {
<3.9057 ,0.5153 ,0.6929>, 0.1000
<5.8585 ,0.7730 ,1.0393>, 0.4000
}
cone {
<3.9404 ,0.0012 ,0.6877>, 0.1000
<5.9107 ,0.0017 ,1.0316>, 0.4000
}
cone {
<3.9078 ,-0.5133 ,0.6826>, 0.1000
<5.8616 ,-0.7699 ,1.0239>, 0.4000
}
cone {
<3.8082 ,-1.0192 ,0.6774>, 0.1000
<5.7123 ,-1.5288 ,1.0161>, 0.4000
}
cone {
<3.6434 ,-1.5078 ,0.6722>, 0.1000
<5.4651 ,-2.2618 ,1.0084>, 0.4000
}
cone {
<3.4162 ,-1.9709 ,0.6671>, 0.1000
<5.1243 ,-2.9564 ,1.0006>, 0.4000
}
cone {
<3.1304 ,-2.4005 ,0.6619>, 0.1000
<4.6956 ,-3.6007 ,0.9929>, 0.4000
}
cone {
<2.7909 ,-2.7891 ,0.6568>, 0.1000
<4.1864 ,-4.1837 ,0.9851>, 0.4000
}
cone {
<2.4035 ,-3.1302 ,0.6516>, 0.1000
<3.6053 ,-4.6954 ,0.9774>, 0.4000
}
cone {
<1.9749 ,-3.4179 ,0.6464>, 0.1000
<2.9623 ,-5.1269 ,0.9696>, 0.4000
}
cone {
<1.5122 ,-3.6472 ,0.6413>, 0.1000
<2.2683 ,-5.4708 ,0.9619>, 0.4000
}
cone {
<1.0234 ,-3.8142 ,0.6361>, 0.1000
<1.5351 ,-5.7213 ,0.9541>, 0.4000
}
cone {
<0.5169 ,-3.9160 ,0.6309>, 0.1000
<0.7754 ,-5.8739 ,0.9464>, 0.4000
}
cone {
<0.0014 ,-3.9508 ,0.6258>, 0.1000
<0.0021 ,-5.9261 ,0.9386>, 0.4000
}
cone {
<-0.5144 ,-3.9179 ,0.6206>, 0.1000
<-0.7716 ,-5.8769 ,0.9309>, 0.4000
}
cone {
<-1.0216 ,-3.8181 ,0.6154>, 0.1000
<-1.5323 ,-5.7271 ,0.9231>, 0.4000
}
cone {
<-1.5115 ,-3.6528 ,0.6102>, 0.1000
<-2.2672 ,-5.4792 ,0.9153>, 0.4000
}
cone {
<-1.9757 ,-3.4250 ,0.6051>, 0.1000
<-2.9635 ,-5.1375 ,0.9076>, 0.4000
}
cone {
<-2.4063 ,-3.1384 ,0.5999>, 0.1000
<-3.6095 ,-4.7077 ,0.8998>, 0.4000
}
cone {
<-2.7959 ,-2.7981 ,0.5947>, 0.1000
<-4.1939 ,-4.1971 ,0.8921>, 0.4000
}
cone {
<-3.1378 ,-2.4097 ,0.5895>, 0.1000
<-4.7067 ,-3.6145 ,0.8843>, 0.4000
}
cone {
<-3.4262 ,-1.9799 ,0.5843>, 0.1000
<-5.1392 ,-2.9699 ,0.8765>, 0.4000
}
cone {
<-3.6560 ,-1.5161 ,0.5792>, 0.1000
<-5.4839 ,-2.2741 ,0.8688>, 0.4000
}
cone {
<-3.8233 ,-1.0261 ,0.5740>, 0.1000
<-5.7349 ,-1.5392 ,0.8610>, 0.4000
}
cone {
<-3.9253 ,-0.5184 ,0.5688>, 0.1000
<-5.8879 ,-0.7776 ,0.8532>, 0.4000
}
cone {
<-3.9601 ,-0.0017 ,0.5636>, 0.1000
<-5.9401 ,-0.0025 ,0.8454>, 0.4000
}
cone {
<-3.9272 ,0.5153 ,0.5584>, 0.1000
<-5.8907 ,0.7730 ,0.8377>, 0.4000
}
cone {
<-3.8270 ,1.0237 ,0.5533>, 0.1000
<-5.7405 ,1.5355 ,0.8299>, 0.4000
}
cone {
<-3.6613 ,1.5147 ,0.5481>, 0.1000
<-5.4920 ,2.2721 ,0.8221>, 0.4000
}
cone {
<-3.4329 ,1.9800 ,0.5429>, 0.1000
<-5.1494 ,2.9700 ,0.8143>, 0.4000
}
cone {
<-3.1457 ,2.4115 ,0.5377>, 0.1000
<-4.7185 ,3.6173 ,0.8065>, 0.4000
}
cone {
<-2.8045 ,2.8020 ,0.5325>, 0.1000
<-4.2068 ,4.2030 ,0.7988>, 0.4000
}
cone {
<-2.4152 ,3.1446 ,0.5273>, 0.1000
<-3.6228 ,4.7169 ,0.7910>, 0.4000
}
cone {
<-1.9845 ,3.4335 ,0.5221>, 0.1000
<-2.9767 ,5.1503 ,0.7832>, 0.4000
}
cone {
<-1.5196 ,3.6638 ,0.5169>, 0.1000
<-2.2794 ,5.4957 ,0.7754>, 0.4000
}
cone {
<-1.0286 ,3.8315 ,0.5117>, 0.1000
<-1.5429 ,5.7472 ,0.7676>, 0.4000
}
cone {
<-0.5198 ,3.9336 ,0.5065>, 0.1000
<-0.7797 ,5.9004 ,0.7598>, 0.4000
}
cone {
<-0.0019 ,3.9685 ,0.5014>, 0.1000
<-0.0029 ,5.9527 ,0.7520>, 0.4000
}
cone {
<0.5162 ,3.9354 ,0.4962>, 0.1000
<0.7742 ,5.9031 ,0.7442>, 0.4000
}
cone {
<1.0256 ,3.8350 ,0.4910>, 0.1000
<1.5383 ,5.7525 ,0.7364>, 0.4000
}
cone {
<1.5176 ,3.6689 ,0.4858>, 0.1000
<2.2764 ,5.5034 ,0.7286>, 0.4000
}
cone {
<1.9838 ,3.4400 ,0.4806>, 0.1000
<2.9757 ,5.1600 ,0.7209>, 0.4000
}
cone {
<2.4162 ,3.1522 ,0.4754>, 0.1000
<3.6243 ,4.7282 ,0.7131>, 0.4000
}
cone {
<2.8074 ,2.8103 ,0.4702>, 0.1000
<4.2111 ,4.2154 ,0.7053>, 0.4000
}
cone {
<3.1506 ,2.4202 ,0.4650>, 0.1000
<4.7260 ,3.6303 ,0.6975>, 0.4000
}
cone {
<3.4401 ,1.9885 ,0.4598>, 0.1000
<5.1601 ,2.9828 ,0.6897>, 0.4000
}
cone {
<3.6708 ,1.5228 ,0.4546>, 0.1000
<5.5062 ,2.2841 ,0.6819>, 0.4000
}
cone {
<3.8387 ,1.0308 ,0.4494>, 0.1000
<5.7580 ,1.5462 ,0.6740>, 0.4000
}
cone {
<3.9410 ,0.5210 ,0.4442>, 0.1000
<5.9115 ,0.7815 ,0.6662>, 0.4000
}
cone {
<3.9758 ,0.0022 ,0.4390>, 0.1000
<5.9638 ,0.0033 ,0.6584>, 0.4000
}
cone {
<3.9427 ,-0.5169 ,0.4338>, 0.1000
<5.9140 ,-0.7753 ,0.6506>, 0.4000
}
cone {
<3.8420 ,-1.0272 ,0.4285>, 0.1000
<5.7631 ,-1.5408 ,0.6428>, 0.4000
}
cone {
<3.6756 ,-1.5201 ,0.4233>, 0.1000
<5.5134 ,-2.2801 ,0.6350>, 0.4000
}
cone {
<3.4462 ,-1.9871 ,0.4181>, 0.1000
<5.1694 ,-2.9806 ,0.6272>, 0.4000
}
cone {
<3.1578 ,-2.4202 ,0.4129>, 0.1000
<4.7368 ,-3.6303 ,0.6194>, 0.4000
}
cone {
<2.8153 ,-2.8121 ,0.4077>, 0.1000
<4.2230 ,-4.2181 ,0.6116>, 0.4000
}
cone {
<2.4245 ,-3.1559 ,0.4025>, 0.1000
<3.6368 ,-4.7338 ,0.6038>, 0.4000
}
cone {
<1.9921 ,-3.4458 ,0.3973>, 0.1000
<2.9882 ,-5.1687 ,0.5960>, 0.4000
}
cone {
<1.5255 ,-3.6768 ,0.3921>, 0.1000
<2.2883 ,-5.5152 ,0.5881>, 0.4000
}
cone {
<1.0327 ,-3.8450 ,0.3869>, 0.1000
<1.5491 ,-5.7675 ,0.5803>, 0.4000
}
cone {
<0.5221 ,-3.9474 ,0.3817>, 0.1000
<0.7832 ,-5.9211 ,0.5725>, 0.4000
}
cone {
<0.0024 ,-3.9822 ,0.3765>, 0.1000
<0.0036 ,-5.9734 ,0.5647>, 0.4000
}
cone {
<-0.5174 ,-3.9490 ,0.3712>, 0.1000
<-0.7761 ,-5.9235 ,0.5569>, 0.4000
}
cone {
<-1.0285 ,-3.8481 ,0.3660>, 0.1000
<-1.5428 ,-5.7722 ,0.5490>, 0.4000
}
cone {
<-1.5222 ,-3.6814 ,0.3608>, 0.1000
<-2.2833 ,-5.5221 ,0.5412>, 0.4000
}
cone {
<-1.9899 ,-3.4516 ,0.3556>, 0.1000
<-2.9849 ,-5.1775 ,0.5334>, 0.4000
}
cone {
<-2.4237 ,-3.1628 ,0.3504>, 0.1000
<-3.6355 ,-4.7441 ,0.5256>, 0.4000
}
cone {
<-2.8161 ,-2.8197 ,0.3452>, 0.1000
<-4.2241 ,-4.2295 ,0.5178>, 0.4000
}
cone {
<-3.1604 ,-2.4283 ,0.3400>, 0.1000
<-4.7405 ,-3.6424 ,0.5099>, 0.4000
}
cone {
<-3.4507 ,-1.9952 ,0.3347>, 0.1000
<-5.1760 ,-2.9928 ,0.5021>, 0.4000
}
cone {
<-3.6820 ,-1.5279 ,0.3295>, 0.1000
<-5.5229 ,-2.2919 ,0.4943>, 0.4000
}
cone {
<-3.8503 ,-1.0344 ,0.3243>, 0.1000
<-5.7755 ,-1.5516 ,0.4865>, 0.4000
}
cone {
<-3.9528 ,-0.5231 ,0.3191>, 0.1000
<-5.9292 ,-0.7846 ,0.4786>, 0.4000
}
cone {
<-3.9877 ,-0.0027 ,0.3139>, 0.1000
<-5.9815 ,-0.0040 ,0.4708>, 0.4000
}
cone {
<-3.9543 ,0.5179 ,0.3086>, 0.1000
<-5.9315 ,0.7768 ,0.4630>, 0.4000
}
cone {
<-3.8533 ,1.0297 ,0.3034>, 0.1000
<-5.7799 ,1.5445 ,0.4551>, 0.4000
}
cone {
<-3.6863 ,1.5239 ,0.2982>, 0.1000
<-5.5294 ,2.2859 ,0.4473>, 0.4000
}
cone {
<-3.4562 ,1.9922 ,0.2930>, 0.1000
<-5.1843 ,2.9883 ,0.4395>, 0.4000
}
cone {
<-3.1669 ,2.4265 ,0.2878>, 0.1000
<-4.7503 ,3.6398 ,0.4316>, 0.4000
}
cone {
<-2.8233 ,2.8194 ,0.2825>, 0.1000
<-4.2350 ,4.2291 ,0.4238>, 0.4000
}
cone {
<-2.4314 ,3.1641 ,0.2773>, 0.1000
<-3.6471 ,4.7461 ,0.4160>, 0.4000
}
cone {
<-1.9978 ,3.4547 ,0.2721>, 0.1000
<-2.9968 ,5.1820 ,0.4081>, 0.4000
}
cone {
<-1.5300 ,3.6862 ,0.2669>, 0.1000
<-2.2950 ,5.5293 ,0.4003>, 0.4000
}
cone {
<-1.0359 ,3.8547 ,0.2616>, 0.1000
<-1.5538 ,5.7820 ,0.3925>, 0.4000
}
cone {
<-0.5239 ,3.9572 ,0.2564>, 0.1000
<-0.7859 ,5.9359 ,0.3846>, 0.4000
}
cone {
<-0.0029 ,3.9921 ,0.2512>, 0.1000
<-0.0044 ,5.9882 ,0.3768>, 0.4000
}
cone {
<0.5182 ,3.9587 ,0.2460>, 0.1000
<0.7773 ,5.9380 ,0.3689>, 0.4000
}
cone {
<1.0305 ,3.8575 ,0.2407>, 0.1000
<1.5458 ,5.7862 ,0.3611>, 0.4000
}
cone {
<1.5253 ,3.6903 ,0.2355>, 0.1000
<2.2880 ,5.5354 ,0.3533>, 0.4000
}
cone {
<1.9941 ,3.4599 ,0.2303>, 0.1000
<2.9911 ,5.1898 ,0.3454>, 0.4000
}
cone {
<2.4288 ,3.1702 ,0.2251>, 0.1000
<3.6432 ,4.7554 ,0.3376>, 0.4000
}
cone {
<2.8220 ,2.8263 ,0.2198>, 0.1000
<4.2330 ,4.2395 ,0.3297>, 0.4000
}
cone {
<3.1670 ,2.4340 ,0.2146>, 0.1000
<4.7504 ,3.6510 ,0.3219>, 0.4000
}
cone {
<3.4578 ,1.9999 ,0.2094>, 0.1000
<5.1867 ,2.9999 ,0.3141>, 0.4000
}
cone {
<3.6895 ,1.5316 ,0.2041>, 0.1000
<5.5343 ,2.2974 ,0.3062>, 0.4000
}
cone {
<3.8581 ,1.0370 ,0.1989>, 0.1000
<5.7872 ,1.5556 ,0.2984>, 0.4000
}
cone {
<3.9607 ,0.5246 ,0.1937>, 0.1000
<5.9411 ,0.7870 ,0.2905>, 0.4000
}
cone {
<3.9956 ,0.0032 ,0.1885>, 0.1000
<5.9933 ,0.0048 ,0.2827>, 0.4000
}
cone {
<3.9620 ,-0.5184 ,0.1832>, 0.1000
<5.9431 ,-0.7776 ,0.2748>, 0.4000
}
cone {
<3.8607 ,-1.0311 ,0.1780>, 0.1000
<5.7911 ,-1.5467 ,0.2670>, 0.4000
}
cone {
<3.6933 ,-1.5263 ,0.1728>, 0.1000
<5.5400 ,-2.2894 ,0.2591>, 0.4000
}
cone {
<3.4627 ,-1.9954 ,0.1675>, 0.1000
<5.1941 ,-2.9931 ,0.2513>, 0.4000
}
cone {
<3.1728 ,-2.4304 ,0.1623>, 0.1000
<4.7592 ,-3.6456 ,0.2435>, 0.4000
}
cone {
<2.8286 ,-2.8239 ,0.1571>, 0.1000
<4.2429 ,-4.2358 ,0.2356>, 0.4000
}
cone {
<2.4359 ,-3.1691 ,0.1518>, 0.1000
<3.6539 ,-4.7536 ,0.2278>, 0.4000
}
cone {
<2.0016 ,-3.4601 ,0.1466>, 0.1000
<3.0024 ,-5.1901 ,0.2199>, 0.4000
}
cone {
<1.5329 ,-3.6919 ,0.1414>, 0.1000
<2.2994 ,-5.5379 ,0.2121>, 0.4000
}
cone {
<1.0380 ,-3.8606 ,0.1361>, 0.1000
<1.5569 ,-5.7909 ,0.2042>, 0.4000
}
cone {
<0.5252 ,-3.9632 ,0.1309>, 0.1000
<0.7878 ,-5.9448 ,0.1964>, 0.4000
}
cone {
<0.0034 ,-3.9980 ,0.1257>, 0.1000
<0.0052 ,-5.9970 ,0.1885>, 0.4000
}
cone {
<-0.5184 ,-3.9644 ,0.1204>, 0.1000
<-0.7776 ,-5.9466 ,0.1807>, 0.4000
}
cone {
<-1.0315 ,-3.8630 ,0.1152>, 0.1000
<-1.5472 ,-5.7945 ,0.1728>, 0.4000
}
cone {
<-1.5269 ,-3.6955 ,0.1100>, 0.1000
<-2.2904 ,-5.5432 ,0.1650>, 0.4000
}
cone {
<-1.9963 ,-3.4647 ,0.1047>, 0.1000
<-2.9944 ,-5.1970 ,0.1571>, 0.4000
}
cone {
<-2.4315 ,-3.1746 ,0.0995>, 0.1000
<-3.6472 ,-4.7619 ,0.1493>, 0.4000
}
cone {
<-2.8251 ,-2.8302 ,0.0943>, 0.1000
<-4.2377 ,-4.2453 ,0.1414>, 0.4000
}
cone {
<-3.1704 ,-2.4373 ,0.0890>, 0.1000
<-4.7557 ,-3.6559 ,0.1336>, 0.4000
}
cone {
<-3.4615 ,-2.0027 ,0.0838>, 0.1000
<-5.1923 ,-3.0040 ,0.1257>, 0.4000
}
cone {
<-3.6934 ,-1.5338 ,0.0786>, 0.1000
<-5.5401 ,-2.3007 ,0.1178>, 0.4000
}
cone {
<-3.8621 ,-1.0386 ,0.0733>, 0.1000
<-5.7932 ,-1.5580 ,0.1100>, 0.4000
}
cone {
<-3.9647 ,-0.5257 ,0.0681>, 0.1000
<-5.9471 ,-0.7885 ,0.1021>, 0.4000
}
cone {
<-3.9995 ,-0.0037 ,0.0629>, 0.1000
<-5.9993 ,-0.0056 ,0.0943>, 0.4000
}
cone {
<-3.9659 ,0.5184 ,0.0576>, 0.1000
<-5.9488 ,0.7775 ,0.0864>, 0.4000
}
cone {
<-3.8643 ,1.0316 ,0.0524>, 0.1000
<-5.7965 ,1.5474 ,0.0786>, 0.4000
}
cone {
<-3.6967 ,1.5271 ,0.0472>, 0.1000
<-5.5451 ,2.2907 ,0.0708>, 0.4000
}
cone {
<-3.4658 ,1.9966 ,0.0419>, 0.1000
<-5.1987 ,2.9949 ,0.0629>, 0.4000
}
cone {
<-3.1756 ,2.4319 ,0.0367>, 0.1000
<-4.7634 ,3.6479 ,0.0550>, 0.4000
}
cone {
<-2.8310 ,2.8256 ,0.0315>, 0.1000
<-4.2466 ,4.2384 ,0.0472>, 0.4000
}
cone {
<-2.4380 ,3.1710 ,0.0262>, 0.1000
<-3.6571 ,4.7565 ,0.0393>, 0.4000
}
cone {
<-2.0033 ,3.4621 ,0.0210>, 0.1000
<-3.0050 ,5.1932 ,0.0314>, 0.4000
}
cone {
<-1.5343 ,3.6940 ,0.0157>, 0.1000
<-2.3015 ,5.5410 ,0.0236>, 0.4000
}
cone {
<-1.0391 ,3.8627 ,0.0105>, 0.1000
<-1.5586 ,5.7940 ,0.0157>, 0.4000
}
cone {
<-0.5260 ,3.9653 ,0.0052>, 0.1000
<-0.7890 ,5.9479 ,0.0079>, 0.4000
}
cone {
<-0.0040 ,4.0000 ,0.0006>, 0.1000
<-0.0059 ,6.0000 ,0.0010>, 0.4000
}
cone {
<0.5182 ,3.9663 ,-0.0052>, 0.1000
<0.7772 ,5.9494 ,-0.0077>, 0.4000
}
cone {
<1.0314 ,3.8647 ,-0.0104>, 0.1000
<1.5471 ,5.7971 ,-0.0157>, 0.4000
}
cone {
<1.5270 ,3.6970 ,-0.0157>, 0.1000
<2.2905 ,5.5455 ,-0.0235>, 0.4000
}
cone {
<1.9965 ,3.4661 ,-0.0209>, 0.1000
<2.9947 ,5.1991 ,-0.0313>, 0.4000
}
cone {
<2.4318 ,3.1758 ,-0.0261>, 0.1000
<3.6477 ,4.7637 ,-0.0392>, 0.4000
}
cone {
<2.8255 ,2.8312 ,-0.0314>, 0.1000
<4.2382 ,4.2468 ,-0.0471>, 0.4000
}
cone {
<3.1708 ,2.4382 ,-0.0366>, 0.1000
<4.7562 ,3.6573 ,-0.0549>, 0.4000
}
cone {
<3.4618 ,2.0035 ,-0.0418>, 0.1000
<5.1928 ,3.0052 ,-0.0628>, 0.4000
}
cone {
<3.6937 ,1.5345 ,-0.0471>, 0.1000
<5.5405 ,2.3017 ,-0.0706>, 0.4000
}
cone {
<3.8623 ,1.0392 ,-0.0523>, 0.1000
<5.7934 ,1.5588 ,-0.0785>, 0.4000
}
cone {
<3.9648 ,0.5262 ,-0.0575>, 0.1000
<5.9472 ,0.7893 ,-0.0863>, 0.4000
}
cone {
<3.9995 ,0.0042 ,-0.0628>, 0.1000
<5.9993 ,0.0063 ,-0.0942>, 0.4000
}
cone {
<3.9658 ,-0.5178 ,-0.0680>, 0.1000
<5.9486 ,-0.7767 ,-0.1020>, 0.4000
}
cone {
<3.8642 ,-1.0310 ,-0.0733>, 0.1000
<5.7962 ,-1.5465 ,-0.1099>, 0.4000
}
cone {
<3.6964 ,-1.5265 ,-0.0785>, 0.1000
<5.5447 ,-2.2897 ,-0.1177>, 0.4000
}
cone {
<3.4655 ,-1.9958 ,-0.0837>, 0.1000
<5.1982 ,-2.9938 ,-0.1256>, 0.4000
}
cone {
<3.1753 ,-2.4310 ,-0.0890>, 0.1000
<4.7629 ,-3.6465 ,-0.1335>, 0.4000
}
cone {
<2.8307 ,-2.8246 ,-0.0942>, 0.1000
<4.2461 ,-4.2369 ,-0.1413>, 0.4000
}
cone {
<2.4377 ,-3.1698 ,-0.0994>, 0.1000
<3.6566 ,-4.7547 ,-0.1491>, 0.4000
}
cone {
<2.0031 ,-3.4607 ,-0.1047>, 0.1000
<3.0047 ,-5.1911 ,-0.1570>, 0.4000
}
cone {
<1.5342 ,-3.6924 ,-0.1099>, 0.1000
<2.3013 ,-5.5387 ,-0.1648>, 0.4000
}
cone {
<1.0391 ,-3.8610 ,-0.1151>, 0.1000
<1.5587 ,-5.7914 ,-0.1727>, 0.4000
}
cone {
<0.5263 ,-3.9634 ,-0.1204>, 0.1000
<0.7894 ,-5.9451 ,-0.1806>, 0.4000
}
cone {
<0.0045 ,-3.9980 ,-0.1256>, 0.1000
<0.0067 ,-5.9970 ,-0.1884>, 0.4000
}
cone {
<-0.5174 ,-3.9642 ,-0.1308>, 0.1000
<-0.7761 ,-5.9464 ,-0.1962>, 0.4000
}
cone {
<-1.0303 ,-3.8626 ,-0.1361>, 0.1000
<-1.5455 ,-5.7939 ,-0.2041>, 0.4000
}
cone {
<-1.5256 ,-3.6949 ,-0.1413>, 0.1000
<-2.2884 ,-5.5424 ,-0.2119>, 0.4000
}
cone {
<-1.9947 ,-3.4640 ,-0.1465>, 0.1000
<-2.9921 ,-5.1961 ,-0.2198>, 0.4000
}
cone {
<-2.4297 ,-3.1739 ,-0.1518>, 0.1000
<-3.6445 ,-4.7609 ,-0.2276>, 0.4000
}
cone {
<-2.8230 ,-2.8295 ,-0.1570>, 0.1000
<-4.2345 ,-4.2442 ,-0.2355>, 0.4000
}
cone {
<-3.1680 ,-2.4367 ,-0.1622>, 0.1000
<-4.7520 ,-3.6550 ,-0.2433>, 0.4000
}
cone {
<-3.4587 ,-2.0023 ,-0.1675>, 0.1000
<-5.1881 ,-3.0034 ,-0.2512>, 0.4000
}
cone {
<-3.6903 ,-1.5336 ,-0.1727>, 0.1000
<-5.5354 ,-2.3004 ,-0.2590>, 0.4000
}
cone {
<-3.8587 ,-1.0388 ,-0.1779>, 0.1000
<-5.7880 ,-1.5581 ,-0.2669>, 0.4000
}
cone {
<-3.9610 ,-0.5262 ,-0.1831>, 0.1000
<-5.9415 ,-0.7893 ,-0.2747>, 0.4000
}
cone {
<-3.9956 ,-0.0047 ,-0.1884>, 0.1000
<-5.9933 ,-0.0071 ,-0.2826>, 0.4000
}
cone {
<-3.9617 ,0.5168 ,-0.1936>, 0.1000
<-5.9426 ,0.7752 ,-0.2904>, 0.4000
}
cone {
<-3.8602 ,1.0294 ,-0.1988>, 0.1000
<-5.7902 ,1.5441 ,-0.2983>, 0.4000
}
cone {
<-3.6925 ,1.5243 ,-0.2041>, 0.1000
<-5.5388 ,2.2865 ,-0.3061>, 0.4000
}
cone {
<-3.4618 ,1.9931 ,-0.2093>, 0.1000
<-5.1926 ,2.9897 ,-0.3139>, 0.4000
}
cone {
<-3.1718 ,2.4277 ,-0.2145>, 0.1000
<-4.7577 ,3.6416 ,-0.3218>, 0.4000
}
cone {
<-2.8276 ,2.8207 ,-0.2198>, 0.1000
<-4.2414 ,4.2311 ,-0.3296>, 0.4000
}
cone {
<-2.4350 ,3.1654 ,-0.2250>, 0.1000
<-3.6526 ,4.7481 ,-0.3375>, 0.4000
}
cone {
<-2.0009 ,3.4559 ,-0.2302>, 0.1000
<-3.0014 ,5.1839 ,-0.3453>, 0.4000
}
cone {
<-1.5326 ,3.6872 ,-0.2354>, 0.1000
<-2.2989 ,5.5308 ,-0.3532>, 0.4000
}
cone {
<-1.0382 ,3.8554 ,-0.2407>, 0.1000
<-1.5572 ,5.7831 ,-0.3610>, 0.4000
}
cone {
<-0.5260 ,3.9576 ,-0.2459>, 0.1000
<-0.7890 ,5.9364 ,-0.3688>, 0.4000
}
cone {
<-0.0050 ,3.9921 ,-0.2511>, 0.1000
<-0.0074 ,5.9882 ,-0.3767>, 0.4000
}
cone {
<0.5161 ,3.9583 ,-0.2563>, 0.1000
<0.7741 ,5.9374 ,-0.3845>, 0.4000
}
cone {
<1.0282 ,3.8567 ,-0.2616>, 0.1000
<1.5423 ,5.7851 ,-0.3923>, 0.4000
}
cone {
<1.5227 ,3.6892 ,-0.2668>, 0.1000
<2.2840 ,5.5338 ,-0.4002>, 0.4000
}
cone {
<1.9910 ,3.4586 ,-0.2720>, 0.1000
<2.9865 ,5.1879 ,-0.4080>, 0.4000
}
cone {
<2.4252 ,3.1689 ,-0.2772>, 0.1000
<3.6378 ,4.7533 ,-0.4159>, 0.4000
}
cone {
<2.8178 ,2.8250 ,-0.2825>, 0.1000
<4.2267 ,4.2374 ,-0.4237>, 0.4000
}
cone {
<3.1621 ,2.4328 ,-0.2877>, 0.1000
<4.7431 ,3.6492 ,-0.4315>, 0.4000
}
cone {
<3.4522 ,1.9991 ,-0.2929>, 0.1000
<5.1784 ,2.9986 ,-0.4394>, 0.4000
}
cone {
<3.6833 ,1.5312 ,-0.2981>, 0.1000
<5.5249 ,2.2968 ,-0.4472>, 0.4000
}
cone {
<3.8512 ,1.0373 ,-0.3033>, 0.1000
<5.7769 ,1.5559 ,-0.4550>, 0.4000
}
cone {
<3.9533 ,0.5257 ,-0.3086>, 0.1000
<5.9299 ,0.7885 ,-0.4628>, 0.4000
}
cone {
<3.9877 ,0.0052 ,-0.3138>, 0.1000
<5.9815 ,0.0078 ,-0.4707>, 0.4000
}
cone {
<3.9538 ,-0.5153 ,-0.3190>, 0.1000
<5.9307 ,-0.7729 ,-0.4785>, 0.4000
}
cone {
<3.8523 ,-1.0268 ,-0.3242>, 0.1000
<5.7785 ,-1.5402 ,-0.4863>, 0.4000
}
cone {
<3.6850 ,-1.5207 ,-0.3294>, 0.1000
<5.5275 ,-2.2810 ,-0.4942>, 0.4000
}
cone {
<3.4546 ,-1.9884 ,-0.3347>, 0.1000
<5.1819 ,-2.9826 ,-0.5020>, 0.4000
}
cone {
<3.1652 ,-2.4220 ,-0.3399>, 0.1000
<4.7478 ,-3.6330 ,-0.5098>, 0.4000
}
cone {
<2.8217 ,-2.8141 ,-0.3451>, 0.1000
<4.2325 ,-4.2212 ,-0.5176>, 0.4000
}
cone {
<2.4299 ,-3.1580 ,-0.3503>, 0.1000
<3.6449 ,-4.7369 ,-0.5255>, 0.4000
}
cone {
<1.9967 ,-3.4477 ,-0.3555>, 0.1000
<2.9951 ,-5.1716 ,-0.5333>, 0.4000
}
cone {
<1.5295 ,-3.6784 ,-0.3607>, 0.1000
<2.2942 ,-5.5176 ,-0.5411>, 0.4000
}
cone {
<1.0362 ,-3.8461 ,-0.3660>, 0.1000
<1.5542 ,-5.7691 ,-0.5489>, 0.4000
}
cone {
<0.5252 ,-3.9480 ,-0.3712>, 0.1000
<0.7879 ,-5.9219 ,-0.5567>, 0.4000
}
cone {
<0.0055 ,-3.9822 ,-0.3764>, 0.1000
<0.0082 ,-5.9734 ,-0.5646>, 0.4000
}
cone {
<-0.5143 ,-3.9484 ,-0.3816>, 0.1000
<-0.7714 ,-5.9226 ,-0.5724>, 0.4000
}
cone {
<-1.0251 ,-3.8470 ,-0.3868>, 0.1000
<-1.5377 ,-5.7705 ,-0.5802>, 0.4000
}
cone {
<-1.5183 ,-3.6798 ,-0.3920>, 0.1000
<-2.2774 ,-5.5198 ,-0.5880>, 0.4000
}
cone {
<-1.9853 ,-3.4497 ,-0.3972>, 0.1000
<-2.9780 ,-5.1746 ,-0.5958>, 0.4000
}
cone {
<-2.4183 ,-3.1607 ,-0.4024>, 0.1000
<-3.6274 ,-4.7410 ,-0.6036>, 0.4000
}
cone {
<-2.8098 ,-2.8176 ,-0.4076>, 0.1000
<-4.2146 ,-4.2265 ,-0.6115>, 0.4000
}
cone {
<-3.1531 ,-2.4265 ,-0.4128>, 0.1000
<-4.7296 ,-3.6397 ,-0.6193>, 0.4000
}
cone {
<-3.4423 ,-1.9939 ,-0.4181>, 0.1000
<-5.1635 ,-2.9909 ,-0.6271>, 0.4000
}
cone {
<-3.6726 ,-1.5273 ,-0.4233>, 0.1000
<-5.5089 ,-2.2910 ,-0.6349>, 0.4000
}
cone {
<-3.8400 ,-1.0348 ,-0.4285>, 0.1000
<-5.7600 ,-1.5522 ,-0.6427>, 0.4000
}
cone {
<-3.9417 ,-0.5247 ,-0.4337>, 0.1000
<-5.9125 ,-0.7870 ,-0.6505>, 0.4000
}
cone {
<-3.9758 ,-0.0057 ,-0.4389>, 0.1000
<-5.9638 ,-0.0085 ,-0.6583>, 0.4000
}
cone {
<-3.9420 ,0.5132 ,-0.4441>, 0.1000
<-5.9130 ,0.7698 ,-0.6661>, 0.4000
}
cone {
<-3.8407 ,1.0232 ,-0.4493>, 0.1000
<-5.7611 ,1.5348 ,-0.6739>, 0.4000
}
cone {
<-3.6738 ,1.5155 ,-0.4545>, 0.1000
<-5.5107 ,2.2732 ,-0.6817>, 0.4000
}
cone {
<-3.4440 ,1.9817 ,-0.4597>, 0.1000
<-5.1661 ,2.9726 ,-0.6895>, 0.4000
}
cone {
<-3.1554 ,2.4139 ,-0.4649>, 0.1000
<-4.7332 ,3.6209 ,-0.6973>, 0.4000
}
cone {
<-2.8129 ,2.8047 ,-0.4701>, 0.1000
<-4.2194 ,4.2071 ,-0.7051>, 0.4000
}
cone {
<-2.4224 ,3.1474 ,-0.4753>, 0.1000
<-3.6336 ,4.7211 ,-0.7129>, 0.4000
}
cone {
<-1.9906 ,3.4361 ,-0.4805>, 0.1000
<-2.9859 ,5.1541 ,-0.7207>, 0.4000
}
cone {
<-1.5248 ,3.6659 ,-0.4857>, 0.1000
<-2.2873 ,5.4989 ,-0.7285>, 0.4000
}
cone {
<-1.0331 ,3.8330 ,-0.4909>, 0.1000
<-1.5497 ,5.7495 ,-0.7363>, 0.4000
}
cone {
<-0.5239 ,3.9344 ,-0.4961>, 0.1000
<-0.7859 ,5.9016 ,-0.7441>, 0.4000
}
cone {
<-0.0059 ,3.9685 ,-0.5013>, 0.1000
<-0.0089 ,5.9527 ,-0.7519>, 0.4000
}
cone {
<0.5120 ,3.9346 ,-0.5065>, 0.1000
<0.7680 ,5.9020 ,-0.7597>, 0.4000
}
cone {
<1.0210 ,3.8335 ,-0.5117>, 0.1000
<1.5315 ,5.7503 ,-0.7675>, 0.4000
}
cone {
<1.5124 ,3.6668 ,-0.5169>, 0.1000
<2.2685 ,5.5002 ,-0.7753>, 0.4000
}
cone {
<1.9777 ,3.4375 ,-0.5220>, 0.1000
<2.9665 ,5.1562 ,-0.7831>, 0.4000
}
cone {
<2.4090 ,3.1494 ,-0.5272>, 0.1000
<3.6135 ,4.7241 ,-0.7909>, 0.4000
}
cone {
<2.7990 ,2.8075 ,-0.5324>, 0.1000
<4.1985 ,4.2113 ,-0.7986>, 0.4000
}
cone {
<3.1409 ,2.4178 ,-0.5376>, 0.1000
<4.7114 ,3.6267 ,-0.8064>, 0.4000
}
cone {
<3.4290 ,1.9868 ,-0.5428>, 0.1000
<5.1435 ,2.9802 ,-0.8142>, 0.4000
}
cone {
<3.6583 ,1.5220 ,-0.5480>, 0.1000
<5.4875 ,2.2829 ,-0.8220>, 0.4000
}
cone {
<3.8250 ,1.0313 ,-0.5532>, 0.1000
<5.7375 ,1.5469 ,-0.8298>, 0.4000
}
cone {
<3.9261 ,0.5231 ,-0.5584>, 0.1000
<5.8892 ,0.7846 ,-0.8375>, 0.4000
}
cone {
<3.9601 ,0.0062 ,-0.5635>, 0.1000
<5.9401 ,0.0093 ,-0.8453>, 0.4000
}
cone {
<3.9263 ,-0.5107 ,-0.5687>, 0.1000
<5.8894 ,-0.7660 ,-0.8531>, 0.4000
}
cone {
<3.8253 ,-1.0186 ,-0.5739>, 0.1000
<5.7380 ,-1.5278 ,-0.8609>, 0.4000
}
cone {
<3.6590 ,-1.5088 ,-0.5791>, 0.1000
<5.4885 ,-2.2633 ,-0.8686>, 0.4000
}
cone {
<3.4301 ,-1.9731 ,-0.5843>, 0.1000
<5.1451 ,-2.9597 ,-0.8764>, 0.4000
}
cone {
<3.1426 ,-2.4035 ,-0.5894>, 0.1000
<4.7139 ,-3.6052 ,-0.8842>, 0.4000
}
cone {
<2.8014 ,-2.7925 ,-0.5946>, 0.1000
<4.2022 ,-4.1888 ,-0.8919>, 0.4000
}
cone {
<2.4125 ,-3.1337 ,-0.5998>, 0.1000
<3.6188 ,-4.7005 ,-0.8997>, 0.4000
}
cone {
<1.9825 ,-3.4211 ,-0.6050>, 0.1000
<2.9737 ,-5.1316 ,-0.9075>, 0.4000
}
cone {
<1.5187 ,-3.6498 ,-0.6102>, 0.1000
<2.2780 ,-5.4748 ,-0.9152>, 0.4000
}
cone {
<1.0291 ,-3.8161 ,-0.6153>, 0.1000
<1.5437 ,-5.7241 ,-0.9230>, 0.4000
}
cone {
<0.5221 ,-3.9169 ,-0.6205>, 0.1000
<0.7832 ,-5.8754 ,-0.9308>, 0.4000
}
cone {
<0.0064 ,-3.9508 ,-0.6257>, 0.1000
<0.0096 ,-5.9261 ,-0.9385>, 0.4000
}
cone {
<-0.5092 ,-3.9170 ,-0.6308>, 0.1000
<-0.7638 ,-5.8755 ,-0.9463>, 0.4000
}
cone {
<-1.0159 ,-3.8162 ,-0.6360>, 0.1000
<-1.5238 ,-5.7243 ,-0.9540>, 0.4000
}
cone {
<-1.5050 ,-3.6502 ,-0.6412>, 0.1000
<-2.2574 ,-5.4753 ,-0.9618>, 0.4000
}
cone {
<-1.9681 ,-3.4218 ,-0.6464>, 0.1000
<-2.9521 ,-5.1327 ,-0.9695>, 0.4000
}
cone {
<-2.3974 ,-3.1350 ,-0.6515>, 0.1000
<-3.5960 ,-4.7025 ,-0.9773>, 0.4000
}
cone {
<-2.7854 ,-2.7947 ,-0.6567>, 0.1000
<-4.1781 ,-4.1920 ,-0.9850>, 0.4000
}
cone {
<-3.1257 ,-2.4067 ,-0.6618>, 0.1000
<-4.6885 ,-3.6100 ,-0.9928>, 0.4000
}
cone {
<-3.4123 ,-1.9777 ,-0.6670>, 0.1000
<-5.1185 ,-2.9665 ,-1.0005>, 0.4000
}
cone {
<-3.6404 ,-1.5151 ,-0.6722>, 0.1000
<-5.4607 ,-2.2726 ,-1.0083>, 0.4000
}
cone {
<-3.8062 ,-1.0267 ,-0.6773>, 0.1000
<-5.7093 ,-1.5401 ,-1.0160>, 0.4000
}
cone {
<-3.9068 ,-0.5210 ,-0.6825>, 0.1000
<-5.8601 ,-0.7815 ,-1.0237>, 0.4000
}
cone {
<-3.9404 ,-0.0066 ,-0.6877>, 0.1000
<-5.9107 ,-0.0100 ,-1.0315>, 0.4000
}
cone {
<-3.9067 ,0.5076 ,-0.6928>, 0.1000
<-5.8601 ,0.7614 ,-1.0392>, 0.4000
}
cone {
<-3.8062 ,1.0129 ,-0.6980>, 0.1000
<-5.7092 ,1.5194 ,-1.0469>, 0.4000
}
cone {
<-3.6405 ,1.5007 ,-0.7031>, 0.1000
<-5.4608 ,2.2511 ,-1.0547>, 0.4000
}
cone {
<-3.4127 ,1.9626 ,-0.7083>, 0.1000
<-5.1191 ,2.9439 ,-1.0624>, 0.4000
}
cone {
<-3.1266 ,2.3906 ,-0.7134>, 0.1000
<-4.6899 ,3.5860 ,-1.0701>, 0.4000
}
cone {
<-2.7872 ,2.7776 ,-0.7186>, 0.1000
<-4.1808 ,4.1664 ,-1.0779>, 0.4000
}
cone {
<-2.4002 ,3.1169 ,-0.7237>, 0.1000
<-3.6004 ,4.6754 ,-1.0856>, 0.4000
}
cone {
<-1.9724 ,3.4027 ,-0.7289>, 0.1000
<-2.9586 ,5.1040 ,-1.0933>, 0.4000
}
cone {
<-1.5110 ,3.6301 ,-0.7340>, 0.1000
<-2.2666 ,5.4452 ,-1.1010>, 0.4000
}
cone {
<-1.0241 ,3.7954 ,-0.7392>, 0.1000
<-1.5361 ,5.6931 ,-1.1088>, 0.4000
}
cone {
<-0.5198 ,3.8956 ,-0.7443>, 0.1000
<-0.7797 ,5.8434 ,-1.1165>, 0.4000
}
cone {
<-0.0069 ,3.9292 ,-0.7495>, 0.1000
<-0.0103 ,5.8937 ,-1.1242>, 0.4000
}
cone {
<0.5059 ,3.8955 ,-0.7546>, 0.1000
<0.7588 ,5.8432 ,-1.1319>, 0.4000
}
cone {
<1.0097 ,3.7952 ,-0.7597>, 0.1000
<1.5146 ,5.6927 ,-1.1396>, 0.4000
}
cone {
<1.4961 ,3.6300 ,-0.7649>, 0.1000
<2.2441 ,5.4450 ,-1.1473>, 0.4000
}
cone {
<1.9566 ,3.4028 ,-0.7700>, 0.1000
<2.9348 ,5.1042 ,-1.1550>, 0.4000
}
cone {
<2.3833 ,3.1175 ,-0.7752>, 0.1000
<3.5750 ,4.6762 ,-1.1627>, 0.4000
}
cone {
<2.7691 ,2.7790 ,-0.7803>, 0.1000
<4.1537 ,4.1685 ,-1.1704>, 0.4000
}
cone {
<3.1074 ,2.3932 ,-0.7854>, 0.1000
<4.6610 ,3.5898 ,-1.1781>, 0.4000
}
cone {
<3.3923 ,1.9666 ,-0.7906>, 0.1000
<5.0884 ,2.9500 ,-1.1858>, 0.4000
}
cone {
<3.6190 ,1.5067 ,-0.7957>, 0.1000
<5.4284 ,2.2600 ,-1.1935>, 0.4000
}
cone {
<3.7836 ,1.0211 ,-0.8008>, 0.1000
<5.6755 ,1.5317 ,-1.2012>, 0.4000
}
cone {
<3.8835 ,0.5184 ,-0.8060>, 0.1000
<5.8253 ,0.7776 ,-1.2089>, 0.4000
}
cone {
<3.9169 ,0.0071 ,-0.8111>, 0.1000
<5.8753 ,0.0107 ,-1.2166>, 0.4000
}
cone {
<3.8833 ,-0.5041 ,-0.8162>, 0.1000
<5.8249 ,-0.7561 ,-1.2243>, 0.4000
}
cone {
<3.7832 ,-1.0063 ,-0.8213>, 0.1000
<5.6748 ,-1.5095 ,-1.2320>, 0.4000
}
cone {
<3.6185 ,-1.4911 ,-0.8265>, 0.1000
<5.4278 ,-2.2366 ,-1.2397>, 0.4000
}
cone {
<3.3920 ,-1.9501 ,-0.8316>, 0.1000
<5.0880 ,-2.9251 ,-1.2474>, 0.4000
}
cone {
<3.1076 ,-2.3755 ,-0.8367>, 0.1000
<4.6614 ,-3.5632 ,-1.2550>, 0.4000
}
cone {
<2.7702 ,-2.7600 ,-0.8418>, 0.1000
<4.1553 ,-4.1400 ,-1.2627>, 0.4000
}
cone {
<2.3856 ,-3.0971 ,-0.8469>, 0.1000
<3.5784 ,-4.6456 ,-1.2704>, 0.4000
}
cone {
<1.9604 ,-3.3810 ,-0.8520>, 0.1000
<2.9406 ,-5.0714 ,-1.2781>, 0.4000
}
cone {
<1.5019 ,-3.6069 ,-0.8572>, 0.1000
<2.2528 ,-5.4103 ,-1.2857>, 0.4000
}
cone {
<1.0180 ,-3.7710 ,-0.8623>, 0.1000
<1.5270 ,-5.6565 ,-1.2934>, 0.4000
}
cone {
<0.5169 ,-3.8705 ,-0.8674>, 0.1000
<0.7754 ,-5.8057 ,-1.3011>, 0.4000
}
cone {
<0.0073 ,-3.9037 ,-0.8725>, 0.1000
<0.0110 ,-5.8555 ,-1.3087>, 0.4000
}
cone {
<-0.5021 ,-3.8701 ,-0.8776>, 0.1000
<-0.7531 ,-5.8052 ,-1.3164>, 0.4000
}
cone {
<-1.0026 ,-3.7703 ,-0.8827>, 0.1000
<-1.5040 ,-5.6555 ,-1.3241>, 0.4000
}
cone {
<-1.4857 ,-3.6062 ,-0.8878>, 0.1000
<-2.2286 ,-5.4092 ,-1.3317>, 0.4000
}
cone {
<-1.9431 ,-3.3804 ,-0.8929>, 0.1000
<-2.9147 ,-5.0706 ,-1.3394>, 0.4000
}
cone {
<-2.3670 ,-3.0969 ,-0.8980>, 0.1000
<-3.5505 ,-4.6454 ,-1.3470>, 0.4000
}
cone {
<-2.7501 ,-2.7606 ,-0.9031>, 0.1000
<-4.1252 ,-4.1410 ,-1.3547>, 0.4000
}
cone {
<-3.0860 ,-2.3774 ,-0.9082>, 0.1000
<-4.6290 ,-3.5660 ,-1.3623>, 0.4000
}
cone {
<-3.3688 ,-1.9536 ,-0.9133>, 0.1000
<-5.0533 ,-2.9305 ,-1.3700>, 0.4000
}
cone {
<-3.5939 ,-1.4968 ,-0.9184>, 0.1000
<-5.3909 ,-2.2451 ,-1.3776>, 0.4000
}
cone {
<-3.7574 ,-1.0146 ,-0.9235>, 0.1000
<-5.6360 ,-1.5218 ,-1.3853>, 0.4000
}
cone {
<-3.8564 ,-0.5153 ,-0.9286>, 0.1000
<-5.7847 ,-0.7730 ,-1.3929>, 0.4000
}
cone {
<-3.8895 ,-0.0075 ,-0.9337>, 0.1000
<-5.8342 ,-0.0113 ,-1.4006>, 0.4000
}
cone {
<-3.8560 ,0.5000 ,-0.9388>, 0.1000
<-5.7840 ,0.7500 ,-1.4082>, 0.4000
}
cone {
<-3.7565 ,0.9987 ,-0.9439>, 0.1000
<-5.6348 ,1.4981 ,-1.4158>, 0.4000
}
cone {
<-3.5929 ,1.4800 ,-0.9490>, 0.1000
<-5.3894 ,2.2200 ,-1.4235>, 0.4000
}
cone {
<-3.3679 ,1.9357 ,-0.9541>, 0.1000
<-5.0519 ,2.9035 ,-1.4311>, 0.4000
}
cone {
<-3.0855 ,2.3579 ,-0.9591>, 0.1000
<-4.6282 ,3.5369 ,-1.4387>, 0.4000
}
cone {
<-2.7504 ,2.7396 ,-0.9642>, 0.1000
<-4.1256 ,4.1094 ,-1.4463>, 0.4000
}
cone {
<-2.3686 ,3.0742 ,-0.9693>, 0.1000
<-3.5528 ,4.6112 ,-1.4540>, 0.4000
}
cone {
<-1.9464 ,3.3559 ,-0.9744>, 0.1000
<-2.9196 ,5.0338 ,-1.4616>, 0.4000
}
cone {
<-1.4913 ,3.5801 ,-0.9795>, 0.1000
<-2.2369 ,5.3701 ,-1.4692>, 0.4000
}
cone {
<-1.0109 ,3.7428 ,-0.9845>, 0.1000
<-1.5163 ,5.6142 ,-1.4768>, 0.4000
}
cone {
<-0.5136 ,3.8415 ,-0.9896>, 0.1000
<-0.7703 ,5.7622 ,-1.4844>, 0.4000
}
cone {
<-0.0078 ,3.8743 ,-0.9947>, 0.1000
<-0.0116 ,5.8115 ,-1.4920>, 0.4000
}
cone {
<0.4978 ,3.8409 ,-0.9998>, 0.1000
<0.7467 ,5.7614 ,-1.4996>, 0.4000
}
cone {
<0.9945 ,3.7418 ,-1.0048>, 0.1000
<1.4918 ,5.6127 ,-1.5072>, 0.4000
}
cone {
<1.4739 ,3.5788 ,-1.0099>, 0.1000
<2.2109 ,5.3682 ,-1.5148>, 0.4000
}
cone {
<1.9278 ,3.3546 ,-1.0150>, 0.1000
<2.8916 ,5.0320 ,-1.5224>, 0.4000
}
cone {
<2.3483 ,3.0733 ,-1.0200>, 0.1000
<3.5225 ,4.6099 ,-1.5300>, 0.4000
}
cone {
<2.7284 ,2.7395 ,-1.0251>, 0.1000
<4.0926 ,4.1093 ,-1.5376>, 0.4000
}
cone {
<3.0616 ,2.3592 ,-1.0301>, 0.1000
<4.5923 ,3.5387 ,-1.5452>, 0.4000
}
cone {
<3.3421 ,1.9387 ,-1.0352>, 0.1000
<5.0132 ,2.9081 ,-1.5528>, 0.4000
}
cone {
<3.5653 ,1.4854 ,-1.0403>, 0.1000
<5.3480 ,2.2281 ,-1.5604>, 0.4000
}
cone {
<3.7274 ,1.0070 ,-1.0453>, 0.1000
<5.5911 ,1.5105 ,-1.5680>, 0.4000
}
cone {
<3.8256 ,0.5117 ,-1.0504>, 0.1000
<5.7383 ,0.7675 ,-1.5755>, 0.4000
}
cone {
<3.8582 ,0.0080 ,-1.0554>, 0.1000
<5.7874 ,0.0120 ,-1.5831>, 0.4000
}
cone {
<3.8249 ,-0.4955 ,-1.0605>, 0.1000
<5.7374 ,-0.7432 ,-1.5907>, 0.4000
}
cone {
<3.7262 ,-0.9901 ,-1.0655>, 0.1000
<5.5893 ,-1.4852 ,-1.5983>, 0.4000
}
cone {
<3.5638 ,-1.4675 ,-1.0706>, 0.1000
<5.3457 ,-2.2012 ,-1.6058>, 0.4000
}
cone {
<3.3405 ,-1.9194 ,-1.0756>, 0.1000
<5.0108 ,-2.8790 ,-1.6134>, 0.4000
}
cone {
<3.0603 ,-2.3381 ,-1.0806>, 0.1000
<4.5905 ,-3.5071 ,-1.6210>, 0.4000
}
cone {
<2.7280 ,-2.7165 ,-1.0857>, 0.1000
<4.0919 ,-4.0748 ,-1.6285>, 0.4000
}
cone {
<2.3492 ,-3.0482 ,-1.0907>, 0.1000
<3.5238 ,-4.5723 ,-1.6361>, 0.4000
}
cone {
<1.9305 ,-3.3275 ,-1.0958>, 0.1000
<2.8958 ,-4.9913 ,-1.6436>, 0.4000
}
cone {
<1.4791 ,-3.5497 ,-1.1008>, 0.1000
<2.2187 ,-5.3246 ,-1.6512>, 0.4000
}
cone {
<1.0028 ,-3.7110 ,-1.1058>, 0.1000
<1.5042 ,-5.5665 ,-1.6587>, 0.4000
}
cone {
<0.5097 ,-3.8087 ,-1.1109>, 0.1000
<0.7645 ,-5.7131 ,-1.6663>, 0.4000
}
cone {
<0.0082 ,-3.8412 ,-1.1159>, 0.1000
<0.0123 ,-5.7618 ,-1.6738>, 0.4000
}
cone {
<-0.4931 ,-3.8079 ,-1.1209>, 0.1000
<-0.7396 ,-5.7119 ,-1.6814>, 0.4000
}
cone {
<-0.9855 ,-3.7096 ,-1.1259>, 0.1000
<-1.4782 ,-5.5644 ,-1.6889>, 0.4000
}
cone {
<-1.4607 ,-3.5479 ,-1.1310>, 0.1000
<-2.1910 ,-5.3218 ,-1.6964>, 0.4000
}
cone {
<-1.9105 ,-3.3256 ,-1.1360>, 0.1000
<-2.8657 ,-4.9884 ,-1.7040>, 0.4000
}
cone {
<-2.3273 ,-3.0466 ,-1.1410>, 0.1000
<-3.4910 ,-4.5699 ,-1.7115>, 0.4000
}
cone {
<-2.7040 ,-2.7157 ,-1.1460>, 0.1000
<-4.0560 ,-4.0736 ,-1.7190>, 0.4000
}
cone {
<-3.0341 ,-2.3386 ,-1.1510>, 0.1000
<-4.5512 ,-3.5080 ,-1.7265>, 0.4000
}
cone {
<-3.3121 ,-1.9219 ,-1.1560>, 0.1000
<-4.9682 ,-2.8828 ,-1.7341>, 0.4000
}
cone {
<-3.5332 ,-1.4725 ,-1.1611>, 0.1000
<-5.2998 ,-2.2088 ,-1.7416>, 0.4000
}
cone {
<-3.6937 ,-0.9984 ,-1.1661>, 0.1000
<-5.5406 ,-1.4976 ,-1.7491>, 0.4000
}
cone {
<-3.7909 ,-0.5075 ,-1.1711>, 0.1000
<-5.6864 ,-0.7613 ,-1.7566>, 0.4000
}
cone {
<-3.8232 ,-0.0084 ,-1.1761>, 0.1000
<-5.7348 ,-0.0126 ,-1.7641>, 0.4000
}
cone {
<-3.7900 ,0.4905 ,-1.1811>, 0.1000
<-5.6851 ,0.7357 ,-1.7716>, 0.4000
}
cone {
<-3.6921 ,0.9806 ,-1.1861>, 0.1000
<-5.5382 ,1.4709 ,-1.7791>, 0.4000
}
cone {
<-3.5311 ,1.4535 ,-1.1911>, 0.1000
<-5.2967 ,2.1802 ,-1.7866>, 0.4000
}
cone {
<-3.3098 ,1.9012 ,-1.1961>, 0.1000
<-4.9647 ,2.8517 ,-1.7941>, 0.4000
}
cone {
<-3.0321 ,2.3160 ,-1.2011>, 0.1000
<-4.5482 ,3.4739 ,-1.8016>, 0.4000
}
cone {
<-2.7028 ,2.6908 ,-1.2061>, 0.1000
<-4.0542 ,4.0362 ,-1.8091>, 0.4000
}
cone {
<-2.3275 ,3.0193 ,-1.2111>, 0.1000
<-3.4913 ,4.5289 ,-1.8166>, 0.4000
}
cone {
<-1.9127 ,3.2959 ,-1.2160>, 0.1000
<-2.8691 ,4.9438 ,-1.8241>, 0.4000
}
cone {
<-1.4656 ,3.5159 ,-1.2210>, 0.1000
<-2.1983 ,5.2738 ,-1.8316>, 0.4000
}
cone {
<-0.9937 ,3.6755 ,-1.2260>, 0.1000
<-1.4906 ,5.5133 ,-1.8390>, 0.4000
}
cone {
<-0.5053 ,3.7722 ,-1.2310>, 0.1000
<-0.7579 ,5.6583 ,-1.8465>, 0.4000
}
cone {
<-0.0086 ,3.8042 ,-1.2360>, 0.1000
<-0.0129 ,5.7064 ,-1.8540>, 0.4000
}
cone {
<0.4878 ,3.7712 ,-1.2410>, 0.1000
<0.7317 ,5.6568 ,-1.8614>, 0.4000
}
cone {
<0.9754 ,3.6737 ,-1.2459>, 0.1000
<1.4632 ,5.5106 ,-1.8689>, 0.4000
}
cone {
<1.4460 ,3.5135 ,-1.2509>, 0.1000
<2.1690 ,5.2702 ,-1.8764>, 0.4000
}
cone {
<1.8914 ,3.2933 ,-1.2559>, 0.1000
<2.8370 ,4.9399 ,-1.8838>, 0.4000
}
cone {
<2.3040 ,3.0169 ,-1.2609>, 0.1000
<3.4560 ,4.5254 ,-1.8913>, 0.4000
}
cone {
<2.6769 ,2.6892 ,-1.2658>, 0.1000
<4.0154 ,4.0338 ,-1.8987>, 0.4000
}
cone {
<3.0037 ,2.3158 ,-1.2708>, 0.1000
<4.5055 ,3.4737 ,-1.9062>, 0.4000
}
cone {
<3.2788 ,1.9031 ,-1.2757>, 0.1000
<4.9182 ,2.8546 ,-1.9136>, 0.4000
}
cone {
<3.4976 ,1.4582 ,-1.2807>, 0.1000
<5.2464 ,2.1873 ,-1.9211>, 0.4000
}
cone {
<3.6564 ,0.9888 ,-1.2857>, 0.1000
<5.4846 ,1.4832 ,-1.9285>, 0.4000
}
cone {
<3.7525 ,0.5029 ,-1.2906>, 0.1000
<5.6288 ,0.7543 ,-1.9359>, 0.4000
}
cone {
<3.7844 ,0.0088 ,-1.2956>, 0.1000
<5.6765 ,0.0132 ,-1.9434>, 0.4000
}
cone {
<3.7514 ,-0.4850 ,-1.3005>, 0.1000
<5.6272 ,-0.7275 ,-1.9508>, 0.4000
}
cone {
<3.6544 ,-0.9701 ,-1.3055>, 0.1000
<5.4816 ,-1.4551 ,-1.9582>, 0.4000
}
cone {
<3.4949 ,-1.4381 ,-1.3104>, 0.1000
<5.2424 ,-2.1571 ,-1.9656>, 0.4000
}
cone {
<3.2759 ,-1.8811 ,-1.3154>, 0.1000
<4.9138 ,-2.8216 ,-1.9731>, 0.4000
}
cone {
<3.0009 ,-2.2915 ,-1.3203>, 0.1000
<4.5014 ,-3.4373 ,-1.9805>, 0.4000
}
cone {
<2.6749 ,-2.6624 ,-1.3253>, 0.1000
<4.0124 ,-3.9936 ,-1.9879>, 0.4000
}
cone {
<2.3035 ,-2.9874 ,-1.3302>, 0.1000
<3.4553 ,-4.4811 ,-1.9953>, 0.4000
}
cone {
<1.8930 ,-3.2610 ,-1.3351>, 0.1000
<2.8395 ,-4.8915 ,-2.0027>, 0.4000
}
cone {
<1.4505 ,-3.4785 ,-1.3401>, 0.1000
<2.1758 ,-5.2178 ,-2.0101>, 0.4000
}
cone {
<0.9836 ,-3.6364 ,-1.3450>, 0.1000
<1.4754 ,-5.4546 ,-2.0175>, 0.4000
}
cone {
<0.5004 ,-3.7319 ,-1.3499>, 0.1000
<0.7505 ,-5.5979 ,-2.0249>, 0.4000
}
cone {
<0.0090 ,-3.7635 ,-1.3549>, 0.1000
<0.0135 ,-5.6453 ,-2.0323>, 0.4000
}
cone {
<-0.4821 ,-3.7308 ,-1.3598>, 0.1000
<-0.7231 ,-5.5961 ,-2.0397>, 0.4000
}
cone {
<-0.9645 ,-3.6342 ,-1.3647>, 0.1000
<-1.4467 ,-5.4513 ,-2.0471>, 0.4000
}
cone {
<-1.4299 ,-3.4756 ,-1.3696>, 0.1000
<-2.1448 ,-5.2134 ,-2.0544>, 0.4000
}
cone {
<-1.8704 ,-3.2577 ,-1.3745>, 0.1000
<-2.8056 ,-4.8865 ,-2.0618>, 0.4000
}
cone {
<-2.2785 ,-2.9842 ,-1.3795>, 0.1000
<-3.4177 ,-4.4763 ,-2.0692>, 0.4000
}
cone {
<-2.6472 ,-2.6600 ,-1.3844>, 0.1000
<-3.9708 ,-3.9901 ,-2.0766>, 0.4000
}
cone {
<-2.9703 ,-2.2907 ,-1.3893>, 0.1000
<-4.4555 ,-3.4360 ,-2.0839>, 0.4000
}
cone {
<-3.2423 ,-1.8825 ,-1.3942>, 0.1000
<-4.8635 ,-2.8237 ,-2.0913>, 0.4000
}
cone {
<-3.4586 ,-1.4425 ,-1.3991>, 0.1000
<-5.1879 ,-2.1637 ,-2.0987>, 0.4000
}
cone {
<-3.6155 ,-0.9782 ,-1.4040>, 0.1000
<-5.4233 ,-1.4673 ,-2.1060>, 0.4000
}
cone {
<-3.7104 ,-0.4977 ,-1.4089>, 0.1000
<-5.5656 ,-0.7466 ,-2.1134>, 0.4000
}
cone {
<-3.7418 ,-0.0092 ,-1.4138>, 0.1000
<-5.6127 ,-0.0137 ,-2.1207>, 0.4000
}
cone {
<-3.7091 ,0.4791 ,-1.4187>, 0.1000
<-5.5637 ,0.7186 ,-2.1281>, 0.4000
}
cone {
<-3.6131 ,0.9586 ,-1.4236>, 0.1000
<-5.4196 ,1.4379 ,-2.1354>, 0.4000
}
cone {
<-3.4553 ,1.4213 ,-1.4285>, 0.1000
<-5.1830 ,2.1319 ,-2.1427>, 0.4000
}
cone {
<-3.2386 ,1.8592 ,-1.4334>, 0.1000
<-4.8580 ,2.7888 ,-2.1501>, 0.4000
}
cone {
<-2.9668 ,2.2649 ,-1.4383>, 0.1000
<-4.4502 ,3.3973 ,-2.1574>, 0.4000
}
cone {
<-2.6445 ,2.6314 ,-1.4432>, 0.1000
<-3.9667 ,3.9471 ,-2.1647>, 0.4000
}
cone {
<-2.2772 ,2.9525 ,-1.4480>, 0.1000
<-3.4159 ,4.4288 ,-2.1720>, 0.4000
}
cone {
<-1.8714 ,3.2229 ,-1.4529>, 0.1000
<-2.8071 ,4.8343 ,-2.1794>, 0.4000
}
cone {
<-1.4340 ,3.4378 ,-1.4578>, 0.1000
<-2.1511 ,5.1567 ,-2.1867>, 0.4000
}
cone {
<-0.9726 ,3.5937 ,-1.4627>, 0.1000
<-1.4589 ,5.3906 ,-2.1940>, 0.4000
}
cone {
<-0.4949 ,3.6880 ,-1.4675>, 0.1000
<-0.7424 ,5.5320 ,-2.2013>, 0.4000
}
cone {
<-0.0093 ,3.7191 ,-1.4724>, 0.1000
<-0.0140 ,5.5787 ,-2.2086>, 0.4000
}
cone {
<0.4759 ,3.6866 ,-1.4773>, 0.1000
<0.7139 ,5.5299 ,-2.2159>, 0.4000
}
cone {
<0.9525 ,3.5911 ,-1.4821>, 0.1000
<1.4288 ,5.3866 ,-2.2232>, 0.4000
}
cone {
<1.4124 ,3.4343 ,-1.4870>, 0.1000
<2.1185 ,5.1514 ,-2.2305>, 0.4000
}
cone {
<1.8475 ,3.2188 ,-1.4919>, 0.1000
<2.7713 ,4.8283 ,-2.2378>, 0.4000
}
cone {
<2.2507 ,2.9486 ,-1.4967>, 0.1000
<3.3760 ,4.4229 ,-2.2451>, 0.4000
}
cone {
<2.6149 ,2.6282 ,-1.5016>, 0.1000
<3.9223 ,3.9423 ,-2.2524>, 0.4000
}
cone {
<2.9340 ,2.2632 ,-1.5064>, 0.1000
<4.4010 ,3.3949 ,-2.2596>, 0.4000
}
cone {
<3.2026 ,1.8599 ,-1.5113>, 0.1000
<4.8039 ,2.7899 ,-2.2669>, 0.4000
}
cone {
<3.4161 ,1.4253 ,-1.5161>, 0.1000
<5.1242 ,2.1379 ,-2.2742>, 0.4000
}
cone {
<3.5710 ,0.9667 ,-1.5210>, 0.1000
<5.3565 ,1.4500 ,-2.2814>, 0.4000
}
cone {
<3.6647 ,0.4920 ,-1.5258>, 0.1000
<5.4970 ,0.7381 ,-2.2887>, 0.4000
}
cone {
<3.6955 ,0.0095 ,-1.5306>, 0.1000
<5.5433 ,0.0143 ,-2.2960>, 0.4000
}
cone {
<3.6632 ,-0.4727 ,-1.5355>, 0.1000
<5.4948 ,-0.7090 ,-2.3032>, 0.4000
}
cone {
<3.5682 ,-0.9462 ,-1.5403>, 0.1000
<5.3523 ,-1.4193 ,-2.3105>, 0.4000
}
cone {
<3.4123 ,-1.4031 ,-1.5451>, 0.1000
<5.1185 ,-2.1046 ,-2.3177>, 0.4000
}
cone {
<3.1982 ,-1.8354 ,-1.5500>, 0.1000
<4.7974 ,-2.7532 ,-2.3249>, 0.4000
}
cone {
<2.9297 ,-2.2360 ,-1.5548>, 0.1000
<4.3945 ,-3.3539 ,-2.3322>, 0.4000
}
cone {
<2.6114 ,-2.5978 ,-1.5596>, 0.1000
<3.9170 ,-3.8967 ,-2.3394>, 0.4000
}
cone {
<2.2487 ,-2.9148 ,-1.5644>, 0.1000
<3.3731 ,-4.3722 ,-2.3467>, 0.4000
}
cone {
<1.8480 ,-3.1816 ,-1.5693>, 0.1000
<2.7720 ,-4.7723 ,-2.3539>, 0.4000
}
cone {
<1.4161 ,-3.3937 ,-1.5741>, 0.1000
<2.1242 ,-5.0905 ,-2.3611>, 0.4000
}
cone {
<0.9605 ,-3.5475 ,-1.5789>, 0.1000
<1.4408 ,-5.3212 ,-2.3683>, 0.4000
}
cone {
<0.4890 ,-3.6404 ,-1.5837>, 0.1000
<0.7335 ,-5.4607 ,-2.3755>, 0.4000
}
cone {
<0.0097 ,-3.6710 ,-1.5885>, 0.1000
<0.0145 ,-5.5066 ,-2.3827>, 0.4000
}
cone {
<-0.4693 ,-3.6388 ,-1.5933>, 0.1000
<-0.7039 ,-5.4583 ,-2.3899>, 0.4000
}
cone {
<-0.9397 ,-3.5444 ,-1.5981>, 0.1000
<-1.4095 ,-5.3167 ,-2.3971>, 0.4000
}
cone {
<-1.3935 ,-3.3895 ,-1.6029>, 0.1000
<-2.0902 ,-5.0843 ,-2.4043>, 0.4000
}
cone {
<-1.8229 ,-3.1768 ,-1.6077>, 0.1000
<-2.7344 ,-4.7653 ,-2.4115>, 0.4000
}
cone {
<-2.2207 ,-2.9101 ,-1.6125>, 0.1000
<-3.3310 ,-4.3651 ,-2.4187>, 0.4000
}
cone {
<-2.5800 ,-2.5938 ,-1.6173>, 0.1000
<-3.8700 ,-3.8907 ,-2.4259>, 0.4000
}
cone {
<-2.8948 ,-2.2336 ,-1.6221>, 0.1000
<-4.3422 ,-3.3504 ,-2.4331>, 0.4000
}
cone {
<-3.1597 ,-1.8356 ,-1.6268>, 0.1000
<-4.7396 ,-2.7534 ,-2.4403>, 0.4000
}
cone {
<-3.3703 ,-1.4067 ,-1.6316>, 0.1000
<-5.0555 ,-2.1100 ,-2.4474>, 0.4000
}
cone {
<-3.5230 ,-0.9542 ,-1.6364>, 0.1000
<-5.2845 ,-1.4312 ,-2.4546>, 0.4000
}
cone {
<-3.6153 ,-0.4859 ,-1.6412>, 0.1000
<-5.4230 ,-0.7288 ,-2.4618>, 0.4000
}
cone {
<-3.6456 ,-0.0099 ,-1.6460>, 0.1000
<-5.4685 ,-0.0148 ,-2.4689>, 0.4000
}
cone {
<-3.6136 ,0.4658 ,-1.6507>, 0.1000
<-5.4204 ,0.6987 ,-2.4761>, 0.4000
}
cone {
<-3.5198 ,0.9329 ,-1.6555>, 0.1000
<-5.2797 ,1.3994 ,-2.4832>, 0.4000
}
cone {
<-3.3659 ,1.3835 ,-1.6603>, 0.1000
<-5.0489 ,2.0753 ,-2.4904>, 0.4000
}
cone {
<-3.1547 ,1.8099 ,-1.6650>, 0.1000
<-4.7320 ,2.7149 ,-2.4975>, 0.4000
}
cone {
<-2.8897 ,2.2049 ,-1.6698>, 0.1000
<-4.3346 ,3.3073 ,-2.5047>, 0.4000
}
cone {
<-2.5757 ,2.5616 ,-1.6745>, 0.1000
<-3.8635 ,3.8424 ,-2.5118>, 0.4000
}
cone {
<-2.2179 ,2.8741 ,-1.6793>, 0.1000
<-3.3269 ,4.3112 ,-2.5189>, 0.4000
}
cone {
<-1.8227 ,3.1371 ,-1.6840>, 0.1000
<-2.7341 ,4.7057 ,-2.5261>, 0.4000
}
cone {
<-1.3968 ,3.3462 ,-1.6888>, 0.1000
<-2.0952 ,5.0193 ,-2.5332>, 0.4000
}
cone {
<-0.9475 ,3.4977 ,-1.6935>, 0.1000
<-1.4213 ,5.2466 ,-2.5403>, 0.4000
}
cone {
<-0.4826 ,3.5893 ,-1.6983>, 0.1000
<-0.7239 ,5.3839 ,-2.5474>, 0.4000
}
cone {
<-0.0100 ,3.6193 ,-1.7030>, 0.1000
<-0.0150 ,5.4290 ,-2.5545>, 0.4000
}
cone {
<0.4622 ,3.5875 ,-1.7078>, 0.1000
<0.6933 ,5.3812 ,-2.5616>, 0.4000
}
cone {
<0.9259 ,3.4943 ,-1.7125>, 0.1000
<1.3889 ,5.2414 ,-2.5687>, 0.4000
}
cone {
<1.3732 ,3.3415 ,-1.7172>, 0.1000
<2.0598 ,5.0122 ,-2.5758>, 0.4000
}
cone {
<1.7965 ,3.1317 ,-1.7219>, 0.1000
<2.6947 ,4.6976 ,-2.5829>, 0.4000
}
cone {
<2.1885 ,2.8686 ,-1.7267>, 0.1000
<3.2827 ,4.3030 ,-2.5900>, 0.4000
}
cone {
<2.5426 ,2.5569 ,-1.7314>, 0.1000
<3.8139 ,3.8353 ,-2.5971>, 0.4000
}
cone {
<2.8528 ,2.2017 ,-1.7361>, 0.1000
<4.2792 ,3.3026 ,-2.6042>, 0.4000
}
cone {
<3.1138 ,1.8094 ,-1.7408>, 0.1000
<4.6707 ,2.7141 ,-2.6112>, 0.4000
}
cone {
<3.3212 ,1.3866 ,-1.7455>, 0.1000
<4.9818 ,2.0800 ,-2.6183>, 0.4000
}
cone {
<3.4716 ,0.9407 ,-1.7502>, 0.1000
<5.2073 ,1.4110 ,-2.6254>, 0.4000
}
cone {
<3.5624 ,0.4792 ,-1.7550>, 0.1000
<5.3436 ,0.7188 ,-2.6324>, 0.4000
}
cone {
<3.5921 ,0.0102 ,-1.7597>, 0.1000
<5.3882 ,0.0152 ,-2.6395>, 0.4000
}
cone {
<3.5605 ,-0.4585 ,-1.7644>, 0.1000
<5.3407 ,-0.6877 ,-2.6465>, 0.4000
}
cone {
<3.4679 ,-0.9187 ,-1.7691>, 0.1000
<5.2019 ,-1.3780 ,-2.6536>, 0.4000
}
cone {
<3.3162 ,-1.3626 ,-1.7737>, 0.1000
<4.9743 ,-2.0439 ,-2.6606>, 0.4000
}
cone {
<3.1080 ,-1.7826 ,-1.7784>, 0.1000
<4.6620 ,-2.6739 ,-2.6677>, 0.4000
}
cone {
<2.8469 ,-2.1716 ,-1.7831>, 0.1000
<4.2703 ,-3.2574 ,-2.6747>, 0.4000
}
cone {
<2.5374 ,-2.5229 ,-1.7878>, 0.1000
<3.8061 ,-3.7844 ,-2.6817>, 0.4000
}
cone {
<2.1850 ,-2.8307 ,-1.7925>, 0.1000
<3.2775 ,-4.2460 ,-2.6887>, 0.4000
}
cone {
<1.7956 ,-3.0896 ,-1.7972>, 0.1000
<2.6935 ,-4.6344 ,-2.6958>, 0.4000
}
cone {
<1.3761 ,-3.2954 ,-1.8018>, 0.1000
<2.0642 ,-4.9431 ,-2.7028>, 0.4000
}
cone {
<0.9336 ,-3.4445 ,-1.8065>, 0.1000
<1.4004 ,-5.1668 ,-2.7098>, 0.4000
}
cone {
<0.4757 ,-3.5346 ,-1.8112>, 0.1000
<0.7136 ,-5.3019 ,-2.7168>, 0.4000
}
cone {
<0.0103 ,-3.5641 ,-1.8159>, 0.1000
<0.0155 ,-5.3461 ,-2.7238>, 0.4000
}
cone {
<-0.4547 ,-3.5326 ,-1.8205>, 0.1000
<-0.6820 ,-5.2988 ,-2.7308>, 0.4000
}
cone {
<-0.9112 ,-3.4407 ,-1.8252>, 0.1000
<-1.3669 ,-5.1610 ,-2.7378>, 0.4000
}
cone {
<-1.3516 ,-3.2901 ,-1.8298>, 0.1000
<-2.0274 ,-4.9352 ,-2.7448>, 0.4000
}
cone {
<-1.7683 ,-3.0835 ,-1.8345>, 0.1000
<-2.6524 ,-4.6252 ,-2.7517>, 0.4000
}
cone {
<-2.1542 ,-2.8244 ,-1.8391>, 0.1000
<-3.2312 ,-4.2366 ,-2.7587>, 0.4000
}
cone {
<-2.5027 ,-2.5174 ,-1.8438>, 0.1000
<-3.7540 ,-3.7760 ,-2.7657>, 0.4000
}
cone {
<-2.8079 ,-2.1677 ,-1.8484>, 0.1000
<-4.2119 ,-3.2515 ,-2.7727>, 0.4000
}
cone {
<-3.0647 ,-1.7814 ,-1.8531>, 0.1000
<-4.5971 ,-2.6722 ,-2.7796>, 0.4000
}
cone {
<-3.2688 ,-1.3652 ,-1.8577>, 0.1000
<-4.9032 ,-2.0479 ,-2.7866>, 0.4000
}
cone {
<-3.4167 ,-0.9263 ,-1.8624>, 0.1000
<-5.1250 ,-1.3894 ,-2.7935>, 0.4000
}
cone {
<-3.5059 ,-0.4721 ,-1.8670>, 0.1000
<-5.2589 ,-0.7081 ,-2.8005>, 0.4000
}
cone {
<-3.5351 ,-0.0104 ,-1.8716>, 0.1000
<-5.3027 ,-0.0157 ,-2.8074>, 0.4000
}
cone {
<-3.5038 ,0.4507 ,-1.8762>, 0.1000
<-5.2557 ,0.6761 ,-2.8144>, 0.4000
}
cone {
<-3.4126 ,0.9036 ,-1.8809>, 0.1000
<-5.1189 ,1.3553 ,-2.8213>, 0.4000
}
cone {
<-3.2632 ,1.3403 ,-1.8855>, 0.1000
<-4.8948 ,2.0105 ,-2.8282>, 0.4000
}
cone {
<-3.0582 ,1.7535 ,-1.8901>, 0.1000
<-4.5873 ,2.6303 ,-2.8351>, 0.4000
}
cone {
<-2.8012 ,2.1362 ,-1.8947>, 0.1000
<-4.2018 ,3.2043 ,-2.8421>, 0.4000
}
cone {
<-2.4967 ,2.4818 ,-1.8993>, 0.1000
<-3.7450 ,3.7227 ,-2.8490>, 0.4000
}
cone {
<-2.1499 ,2.7845 ,-1.9039>, 0.1000
<-3.2248 ,4.1767 ,-2.8559>, 0.4000
}
cone {
<-1.7668 ,3.0391 ,-1.9085>, 0.1000
<-2.6502 ,4.5586 ,-2.8628>, 0.4000
}
cone {
<-1.3540 ,3.2414 ,-1.9131>, 0.1000
<-2.0311 ,4.8621 ,-2.8697>, 0.4000
}
cone {
<-0.9187 ,3.3880 ,-1.9177>, 0.1000
<-1.3781 ,5.0819 ,-2.8766>, 0.4000
}
cone {
<-0.4683 ,3.4764 ,-1.9223>, 0.1000
<-0.7025 ,5.2146 ,-2.8835>, 0.4000
}
cone {
<-0.0106 ,3.5053 ,-1.9269>, 0.1000
<-0.0159 ,5.2579 ,-2.8904>, 0.4000
}
cone {
<0.4467 ,3.4742 ,-1.9315>, 0.1000
<0.6700 ,5.2112 ,-2.8972>, 0.4000
}
cone {
<0.8957 ,3.3837 ,-1.9361>, 0.1000
<1.3435 ,5.0755 ,-2.9041>, 0.4000
}
cone {
<1.3287 ,3.2355 ,-1.9407>, 0.1000
<1.9930 ,4.8532 ,-2.9110>, 0.4000
}
cone {
<1.7384 ,3.0322 ,-1.9452>, 0.1000
<2.6075 ,4.5483 ,-2.9179>, 0.4000
}
cone {
<2.1177 ,2.7773 ,-1.9498>, 0.1000
<3.1766 ,4.1660 ,-2.9247>, 0.4000
}
cone {
<2.4603 ,2.4754 ,-1.9544>, 0.1000
<3.6904 ,3.7130 ,-2.9316>, 0.4000
}
cone {
<2.7603 ,2.1315 ,-1.9589>, 0.1000
<4.1405 ,3.1972 ,-2.9384>, 0.4000
}
cone {
<3.0127 ,1.7517 ,-1.9635>, 0.1000
<4.5190 ,2.6275 ,-2.9453>, 0.4000
}
cone {
<3.2132 ,1.3425 ,-1.9681>, 0.1000
<4.8197 ,2.0137 ,-2.9521>, 0.4000
}
cone {
<3.3584 ,0.9110 ,-1.9726>, 0.1000
<5.0376 ,1.3664 ,-2.9589>, 0.4000
}
cone {
<3.4460 ,0.4645 ,-1.9772>, 0.1000
<5.1690 ,0.6967 ,-2.9658>, 0.4000
}
cone {
<3.4746 ,0.0107 ,-1.9817>, 0.1000
<5.2119 ,0.0161 ,-2.9726>, 0.4000
}
cone {
<3.4437 ,-0.4426 ,-1.9863>, 0.1000
<5.1655 ,-0.6638 ,-2.9794>, 0.4000
}
cone {
<3.3539 ,-0.8876 ,-1.9908>, 0.1000
<5.0309 ,-1.3314 ,-2.9862>, 0.4000
}
cone {
<3.2070 ,-1.3167 ,-1.9954>, 0.1000
<4.8105 ,-1.9751 ,-2.9930>, 0.4000
}
cone {
<3.0054 ,-1.7228 ,-1.9999>, 0.1000
<4.5081 ,-2.5841 ,-2.9998>, 0.4000
}
cone {
<2.7528 ,-2.0987 ,-2.0044>, 0.1000
<4.1291 ,-3.1481 ,-3.0066>, 0.4000
}
cone {
<2.4534 ,-2.4382 ,-2.0090>, 0.1000
<3.6801 ,-3.6573 ,-3.0134>, 0.4000
}
cone {
<2.1126 ,-2.7355 ,-2.0135>, 0.1000
<3.1689 ,-4.1032 ,-3.0202>, 0.4000
}
cone {
<1.7362 ,-2.9855 ,-2.0180>, 0.1000
<2.6042 ,-4.4783 ,-3.0270>, 0.4000
}
cone {
<1.3306 ,-3.1842 ,-2.0225>, 0.1000
<1.9959 ,-4.7762 ,-3.0338>, 0.4000
}
cone {
<0.9029 ,-3.3280 ,-2.0270>, 0.1000
<1.3544 ,-4.9921 ,-3.0406>, 0.4000
}
cone {
<0.4605 ,-3.4148 ,-2.0315>, 0.1000
<0.6907 ,-5.1222 ,-3.0473>, 0.4000
}
cone {
<0.0108 ,-3.4430 ,-2.0361>, 0.1000
<0.0162 ,-5.1645 ,-3.0541>, 0.4000
}
cone {
<-0.4383 ,-3.4123 ,-2.0406>, 0.1000
<-0.6575 ,-5.1185 ,-3.0608>, 0.4000
}
cone {
<-0.8793 ,-3.3233 ,-2.0451>, 0.1000
<-1.3189 ,-4.9850 ,-3.0676>, 0.4000
}
cone {
<-1.3045 ,-3.1777 ,-2.0496>, 0.1000
<-1.9567 ,-4.7665 ,-3.0743>, 0.4000
}
cone {
<-1.7067 ,-2.9779 ,-2.0541>, 0.1000
<-2.5601 ,-4.4669 ,-3.0811>, 0.4000
}
cone {
<-2.0792 ,-2.7275 ,-2.0585>, 0.1000
<-3.1188 ,-4.0913 ,-3.0878>, 0.4000
}
cone {
<-2.4155 ,-2.4309 ,-2.0630>, 0.1000
<-3.6232 ,-3.6463 ,-3.0946>, 0.4000
}
cone {
<-2.7100 ,-2.0932 ,-2.0675>, 0.1000
<-4.0650 ,-3.1398 ,-3.1013>, 0.4000
}
cone {
<-2.9577 ,-1.7202 ,-2.0720>, 0.1000
<-4.4365 ,-2.5803 ,-3.1080>, 0.4000
}
cone {
<-3.1544 ,-1.3184 ,-2.0765>, 0.1000
<-4.7316 ,-1.9776 ,-3.1147>, 0.4000
}
cone {
<-3.2968 ,-0.8947 ,-2.0809>, 0.1000
<-4.9453 ,-1.3420 ,-3.1214>, 0.4000
}
cone {
<-3.3827 ,-0.4564 ,-2.0854>, 0.1000
<-5.0741 ,-0.6846 ,-3.1281>, 0.4000
}
cone {
<-3.4106 ,-0.0109 ,-2.0899>, 0.1000
<-5.1159 ,-0.0164 ,-3.1348>, 0.4000
}
cone {
<-3.3801 ,0.4340 ,-2.0943>, 0.1000
<-5.0702 ,0.6509 ,-3.1415>, 0.4000
}
cone {
<-3.2919 ,0.8707 ,-2.0988>, 0.1000
<-4.9379 ,1.3061 ,-3.1482>, 0.4000
}
cone {
<-3.1476 ,1.2919 ,-2.1033>, 0.1000
<-4.7214 ,1.9378 ,-3.1549>, 0.4000
}
cone {
<-2.9496 ,1.6903 ,-2.1077>, 0.1000
<-4.4245 ,2.5354 ,-3.1616>, 0.4000
}
cone {
<-2.7016 ,2.0592 ,-2.1122>, 0.1000
<-4.0524 ,3.0887 ,-3.1682>, 0.4000
}
cone {
<-2.4078 ,2.3922 ,-2.1166>, 0.1000
<-3.6116 ,3.5883 ,-3.1749>, 0.4000
}
cone {
<-2.0732 ,2.6838 ,-2.1210>, 0.1000
<-3.1099 ,4.0257 ,-3.1816>, 0.4000
}
cone {
<-1.7038 ,2.9291 ,-2.1255>, 0.1000
<-2.5557 ,4.3936 ,-3.1882>, 0.4000
}
cone {
<-1.3059 ,3.1238 ,-2.1299>, 0.1000
<-1.9588 ,4.6857 ,-3.1949>, 0.4000
}
cone {
<-0.8862 ,3.2648 ,-2.1343>, 0.1000
<-1.3294 ,4.8973 ,-3.2015>, 0.4000
}
cone {
<-0.4522 ,3.3498 ,-2.1388>, 0.1000
<-0.6782 ,5.0247 ,-3.2082>, 0.4000
}
cone {
<-0.0111 ,3.3774 ,-2.1432>, 0.1000
<-0.0166 ,5.0660 ,-3.2148>, 0.4000
}
cone {
<0.4295 ,3.3471 ,-2.1476>, 0.1000
<0.6443 ,5.0207 ,-3.2214>, 0.4000
}
cone {
<0.8620 ,3.2597 ,-2.1520>, 0.1000
<1.2930 ,4.8896 ,-3.2280>, 0.4000
}
cone {
<1.2790 ,3.1167 ,-2.1564>, 0.1000
<1.9185 ,4.6751 ,-3.2347>, 0.4000
}
cone {
<1.6734 ,2.9207 ,-2.1609>, 0.1000
<2.5102 ,4.3810 ,-3.2413>, 0.4000
}
cone {
<2.0386 ,2.6750 ,-2.1653>, 0.1000
<3.0579 ,4.0125 ,-3.2479>, 0.4000
}
cone {
<2.3683 ,2.3840 ,-2.1697>, 0.1000
<3.5525 ,3.5761 ,-3.2545>, 0.4000
}
cone {
<2.6570 ,2.0528 ,-2.1741>, 0.1000
<3.9855 ,3.0792 ,-3.2611>, 0.4000
}
cone {
<2.8997 ,1.6870 ,-2.1784>, 0.1000
<4.3496 ,2.5305 ,-3.2677>, 0.4000
}
cone {
<3.0925 ,1.2930 ,-2.1828>, 0.1000
<4.6387 ,1.9395 ,-3.2743>, 0.4000
}
cone {
<3.2320 ,0.8775 ,-2.1872>, 0.1000
<4.8480 ,1.3163 ,-3.2808>, 0.4000
}
cone {
<3.3161 ,0.4478 ,-2.1916>, 0.1000
<4.9741 ,0.6717 ,-3.2874>, 0.4000
}
cone {
<3.3433 ,0.0112 ,-2.1960>, 0.1000
<5.0149 ,0.0167 ,-3.2940>, 0.4000
}
cone {
<3.3133 ,-0.4249 ,-2.2004>, 0.1000
<4.9699 ,-0.6374 ,-3.3005>, 0.4000
}
cone {
<3.2267 ,-0.8530 ,-2.2047>, 0.1000
<4.8400 ,-1.2795 ,-3.3071>, 0.4000
}
cone {
<3.0851 ,-1.2658 ,-2.2091>, 0.1000
<4.6276 ,-1.8987 ,-3.3136>, 0.4000
}
cone {
<2.8910 ,-1.6562 ,-2.2135>, 0.1000
<4.3364 ,-2.4843 ,-3.3202>, 0.4000
}
cone {
<2.6478 ,-2.0176 ,-2.2178>, 0.1000
<3.9716 ,-3.0264 ,-3.3267>, 0.4000
}
cone {
<2.3597 ,-2.3439 ,-2.2222>, 0.1000
<3.5396 ,-3.5158 ,-3.3333>, 0.4000
}
cone {
<2.0318 ,-2.6295 ,-2.2265>, 0.1000
<3.0477 ,-3.9443 ,-3.3398>, 0.4000
}
cone {
<1.6698 ,-2.8697 ,-2.2309>, 0.1000
<2.5047 ,-4.3045 ,-3.3463>, 0.4000
}
cone {
<1.2798 ,-3.0604 ,-2.2352>, 0.1000
<1.9197 ,-4.5906 ,-3.3528>, 0.4000
}
cone {
<0.8686 ,-3.1984 ,-2.2396>, 0.1000
<1.3030 ,-4.7976 ,-3.3593>, 0.4000
}
cone {
<0.4434 ,-3.2815 ,-2.2439>, 0.1000
<0.6650 ,-4.9223 ,-3.3658>, 0.4000
}
cone {
<0.0112 ,-3.3084 ,-2.2482>, 0.1000
<0.0169 ,-4.9626 ,-3.3723>, 0.4000
}
cone {
<-0.4203 ,-3.2786 ,-2.2525>, 0.1000
<-0.6304 ,-4.9179 ,-3.3788>, 0.4000
}
cone {
<-0.8439 ,-3.1929 ,-2.2569>, 0.1000
<-1.2658 ,-4.7893 ,-3.3853>, 0.4000
}
cone {
<-1.2523 ,-3.0527 ,-2.2612>, 0.1000
<-1.8784 ,-4.5790 ,-3.3918>, 0.4000
}
cone {
<-1.6385 ,-2.8605 ,-2.2655>, 0.1000
<-2.4578 ,-4.2908 ,-3.3983>, 0.4000
}
cone {
<-1.9961 ,-2.6199 ,-2.2698>, 0.1000
<-2.9941 ,-3.9298 ,-3.4047>, 0.4000
}
cone {
<-2.3188 ,-2.3348 ,-2.2741>, 0.1000
<-3.4783 ,-3.5022 ,-3.4112>, 0.4000
}
cone {
<-2.6014 ,-2.0104 ,-2.2784>, 0.1000
<-3.9021 ,-3.0155 ,-3.4177>, 0.4000
}
cone {
<-2.8389 ,-1.6521 ,-2.2827>, 0.1000
<-4.2584 ,-2.4782 ,-3.4241>, 0.4000
}
cone {
<-3.0275 ,-1.2663 ,-2.2870>, 0.1000
<-4.5413 ,-1.8994 ,-3.4306>, 0.4000
}
cone {
<-3.1640 ,-0.8595 ,-2.2913>, 0.1000
<-4.7460 ,-1.2893 ,-3.4370>, 0.4000
}
cone {
<-3.2462 ,-0.4388 ,-2.2956>, 0.1000
<-4.8692 ,-0.6582 ,-3.4434>, 0.4000
}
cone {
<-3.2727 ,-0.0113 ,-2.2999>, 0.1000
<-4.9090 ,-0.0170 ,-3.4499>, 0.4000
}
cone {
<-3.2432 ,0.4155 ,-2.3042>, 0.1000
<-4.8647 ,0.6233 ,-3.4563>, 0.4000
}
cone {
<-3.1583 ,0.8345 ,-2.3085>, 0.1000
<-4.7374 ,1.2518 ,-3.4627>, 0.4000
}
cone {
<-3.0195 ,1.2384 ,-2.3127>, 0.1000
<-4.5293 ,1.8577 ,-3.4691>, 0.4000
}
cone {
<-2.8294 ,1.6204 ,-2.3170>, 0.1000
<-4.2441 ,2.4307 ,-3.4755>, 0.4000
}
cone {
<-2.5913 ,1.9740 ,-2.3213>, 0.1000
<-3.8869 ,2.9611 ,-3.4819>, 0.4000
}
cone {
<-2.3093 ,2.2932 ,-2.3255>, 0.1000
<-3.4640 ,3.4398 ,-3.4883>, 0.4000
}
cone {
<-1.9884 ,2.5726 ,-2.3298>, 0.1000
<-2.9826 ,3.8589 ,-3.4947>, 0.4000
}
cone {
<-1.6341 ,2.8075 ,-2.3341>, 0.1000
<-2.4511 ,4.2112 ,-3.5011>, 0.4000
}
cone {
<-1.2525 ,2.9939 ,-2.3383>, 0.1000
<-1.8787 ,4.4909 ,-3.5075>, 0.4000
}
cone {
<-0.8502 ,3.1288 ,-2.3425>, 0.1000
<-1.2753 ,4.6933 ,-3.5138>, 0.4000
}
cone {
<-0.4341 ,3.2100 ,-2.3468>, 0.1000
<-0.6512 ,4.8150 ,-3.5202>, 0.4000
}
cone {
<-0.0114 ,3.2361 ,-2.3510>, 0.1000
<-0.0171 ,4.8542 ,-3.5265>, 0.4000
}
cone {
<0.4107 ,3.2069 ,-2.3553>, 0.1000
<0.6160 ,4.8103 ,-3.5329>, 0.4000
}
cone {
<0.8249 ,3.1229 ,-2.3595>, 0.1000
<1.2374 ,4.6843 ,-3.5392>, 0.4000
}
cone {
<1.2243 ,2.9856 ,-2.3637>, 0.1000
<1.8365 ,4.4784 ,-3.5456>, 0.4000
}
cone {
<1.6020 ,2.7976 ,-2.3679>, 0.1000
<2.4030 ,4.1964 ,-3.5519>, 0.4000
}
cone {
<1.9515 ,2.5621 ,-2.3722>, 0.1000
<2.9273 ,3.8431 ,-3.5582>, 0.4000
}
cone {
<2.2671 ,2.2833 ,-2.3764>, 0.1000
<3.4006 ,3.4249 ,-3.5646>, 0.4000
}
cone {
<2.5432 ,1.9659 ,-2.3806>, 0.1000
<3.8148 ,2.9489 ,-3.5709>, 0.4000
}
cone {
<2.7754 ,1.6156 ,-2.3848>, 0.1000
<4.1631 ,2.4234 ,-3.5772>, 0.4000
}
cone {
<2.9596 ,1.2383 ,-2.3890>, 0.1000
<4.4394 ,1.8575 ,-3.5835>, 0.4000
}
cone {
<3.0929 ,0.8406 ,-2.3932>, 0.1000
<4.6394 ,1.2609 ,-3.5898>, 0.4000
}
cone {
<3.1731 ,0.4293 ,-2.3974>, 0.1000
<4.7596 ,0.6440 ,-3.5961>, 0.4000
}
cone {
<3.1988 ,0.0115 ,-2.4016>, 0.1000
<4.7982 ,0.0172 ,-3.6023>, 0.4000
}
cone {
<3.1698 ,-0.4057 ,-2.4058>, 0.1000
<4.7547 ,-0.6086 ,-3.6086>, 0.4000
}
cone {
<3.0867 ,-0.8152 ,-2.4099>, 0.1000
<4.6300 ,-1.2228 ,-3.6149>, 0.4000
}
cone {
<2.9510 ,-1.2099 ,-2.4141>, 0.1000
<4.4265 ,-1.8148 ,-3.6212>, 0.4000
}
cone {
<2.7651 ,-1.5831 ,-2.4183>, 0.1000
<4.1476 ,-2.3747 ,-3.6274>, 0.4000
}
cone {
<2.5323 ,-1.9286 ,-2.4224>, 0.1000
<3.7984 ,-2.8928 ,-3.6337>, 0.4000
}
cone {
<2.2566 ,-2.2403 ,-2.4266>, 0.1000
<3.3849 ,-3.3605 ,-3.6399>, 0.4000
}
cone {
<1.9430 ,-2.5132 ,-2.4308>, 0.1000
<2.9145 ,-3.7698 ,-3.6462>, 0.4000
}
cone {
<1.5967 ,-2.7426 ,-2.4349>, 0.1000
<2.3951 ,-4.1138 ,-3.6524>, 0.4000
}
cone {
<1.2239 ,-2.9246 ,-2.4391>, 0.1000
<1.8358 ,-4.3868 ,-3.6586>, 0.4000
}
cone {
<0.8308 ,-3.0562 ,-2.4432>, 0.1000
<1.2463 ,-4.5843 ,-3.6648>, 0.4000
}
cone {
<0.4244 ,-3.1353 ,-2.4474>, 0.1000
<0.6366 ,-4.7030 ,-3.6711>, 0.4000
}
cone {
<0.0115 ,-3.1607 ,-2.4515>, 0.1000
<0.0173 ,-4.7410 ,-3.6773>, 0.4000
}
cone {
<-0.4007 ,-3.1320 ,-2.4556>, 0.1000
<-0.6010 ,-4.6980 ,-3.6835>, 0.4000
}
cone {
<-0.8052 ,-3.0498 ,-2.4598>, 0.1000
<-1.2078 ,-4.5747 ,-3.6897>, 0.4000
}
cone {
<-1.1952 ,-2.9156 ,-2.4639>, 0.1000
<-1.7928 ,-4.3734 ,-3.6959>, 0.4000
}
cone {
<-1.5639 ,-2.7319 ,-2.4680>, 0.1000
<-2.3458 ,-4.0978 ,-3.7020>, 0.4000
}
cone {
<-1.9051 ,-2.5018 ,-2.4721>, 0.1000
<-2.8577 ,-3.7527 ,-3.7082>, 0.4000
}
cone {
<-2.2131 ,-2.2294 ,-2.4763>, 0.1000
<-3.3196 ,-3.3442 ,-3.7144>, 0.4000
}
cone {
<-2.4826 ,-1.9195 ,-2.4804>, 0.1000
<-3.7239 ,-2.8793 ,-3.7206>, 0.4000
}
cone {
<-2.7091 ,-1.5775 ,-2.4845>, 0.1000
<-4.0636 ,-2.3662 ,-3.7267>, 0.4000
}
cone {
<-2.8888 ,-1.2091 ,-2.4886>, 0.1000
<-4.3332 ,-1.8137 ,-3.7329>, 0.4000
}
cone {
<-3.0187 ,-0.8209 ,-2.4927>, 0.1000
<-4.5281 ,-1.2313 ,-3.7390>, 0.4000
}
cone {
<-3.0968 ,-0.4194 ,-2.4968>, 0.1000
<-4.6452 ,-0.6291 ,-3.7451>, 0.4000
}
cone {
<-3.1218 ,-0.0116 ,-2.5009>, 0.1000
<-4.6827 ,-0.0174 ,-3.7513>, 0.4000
}
cone {
<-3.0934 ,0.3955 ,-2.5049>, 0.1000
<-4.6400 ,0.5933 ,-3.7574>, 0.4000
}
cone {
<-3.0121 ,0.7951 ,-2.5090>, 0.1000
<-4.5181 ,1.1926 ,-3.7635>, 0.4000
}
cone {
<-2.8795 ,1.1802 ,-2.5131>, 0.1000
<-4.3193 ,1.7702 ,-3.7696>, 0.4000
}
cone {
<-2.6980 ,1.5443 ,-2.5172>, 0.1000
<-4.0470 ,2.3164 ,-3.7757>, 0.4000
}
cone {
<-2.4707 ,1.8812 ,-2.5212>, 0.1000
<-3.7061 ,2.8218 ,-3.7818>, 0.4000
}
cone {
<-2.2017 ,2.1853 ,-2.5253>, 0.1000
<-3.3026 ,3.2779 ,-3.7879>, 0.4000
}
cone {
<-1.8956 ,2.4513 ,-2.5294>, 0.1000
<-2.8434 ,3.6770 ,-3.7940>, 0.4000
}
cone {
<-1.5578 ,2.6749 ,-2.5334>, 0.1000
<-2.3367 ,4.0124 ,-3.8001>, 0.4000
}
cone {
<-1.1941 ,2.8523 ,-2.5375>, 0.1000
<-1.7911 ,4.2784 ,-3.8062>, 0.4000
}
cone {
<-0.8107 ,2.9805 ,-2.5415>, 0.1000
<-1.2160 ,4.4708 ,-3.8123>, 0.4000
}
cone {
<-0.4143 ,3.0575 ,-2.5455>, 0.1000
<-0.6214 ,4.5863 ,-3.8183>, 0.4000
}
cone {
<-0.0117 ,3.0821 ,-2.5496>, 0.1000
<-0.0175 ,4.6232 ,-3.8244>, 0.4000
}
cone {
<0.3903 ,3.0540 ,-2.5536>, 0.1000
<0.5855 ,4.5810 ,-3.8304>, 0.4000
}
cone {
<0.7847 ,2.9737 ,-2.5576>, 0.1000
<1.1771 ,4.4605 ,-3.8365>, 0.4000
}
cone {
<1.1649 ,2.8427 ,-2.5617>, 0.1000
<1.7473 ,4.2641 ,-3.8425>, 0.4000
}
cone {
<1.5243 ,2.6634 ,-2.5657>, 0.1000
<2.2864 ,3.9952 ,-3.8485>, 0.4000
}
cone {
<1.8568 ,2.4390 ,-2.5697>, 0.1000
<2.7852 ,3.6585 ,-3.8545>, 0.4000
}
cone {
<2.1569 ,2.1734 ,-2.5737>, 0.1000
<3.2354 ,3.2601 ,-3.8606>, 0.4000
}
cone {
<2.4195 ,1.8712 ,-2.5777>, 0.1000
<3.6292 ,2.8069 ,-3.8666>, 0.4000
}
cone {
<2.6401 ,1.5377 ,-2.5817>, 0.1000
<3.9601 ,2.3066 ,-3.8726>, 0.4000
}
cone {
<2.8151 ,1.1787 ,-2.5857>, 0.1000
<4.2226 ,1.7680 ,-3.8786>, 0.4000
}
cone {
<2.9416 ,0.8003 ,-2.5897>, 0.1000
<4.4124 ,1.2004 ,-3.8846>, 0.4000
}
cone {
<3.0175 ,0.4091 ,-2.5937>, 0.1000
<4.5263 ,0.6136 ,-3.8905>, 0.4000
}
cone {
<3.0417 ,0.0117 ,-2.5977>, 0.1000
<4.5626 ,0.0175 ,-3.8965>, 0.4000
}
cone {
<3.0138 ,-0.3850 ,-2.6017>, 0.1000
<4.5207 ,-0.5775 ,-3.9025>, 0.4000
}
cone {
<2.9345 ,-0.7742 ,-2.6056>, 0.1000
<4.4018 ,-1.1613 ,-3.9084>, 0.4000
}
cone {
<2.8052 ,-1.1493 ,-2.6096>, 0.1000
<4.2078 ,-1.7239 ,-3.9144>, 0.4000
}
cone {
<2.6282 ,-1.5039 ,-2.6136>, 0.1000
<3.9423 ,-2.2558 ,-3.9203>, 0.4000
}
cone {
<2.4067 ,-1.8320 ,-2.6175>, 0.1000
<3.6101 ,-2.7480 ,-3.9263>, 0.4000
}
cone {
<2.1446 ,-2.1280 ,-2.6215>, 0.1000
<3.2169 ,-3.1921 ,-3.9322>, 0.4000
}
cone {
<1.8464 ,-2.3870 ,-2.6254>, 0.1000
<2.7696 ,-3.5805 ,-3.9382>, 0.4000
}
cone {
<1.5173 ,-2.6046 ,-2.6294>, 0.1000
<2.2760 ,-3.9069 ,-3.9441>, 0.4000
}
cone {
<1.1630 ,-2.7772 ,-2.6333>, 0.1000
<1.7446 ,-4.1658 ,-3.9500>, 0.4000
}
cone {
<0.7897 ,-2.9019 ,-2.6373>, 0.1000
<1.1846 ,-4.3529 ,-3.9559>, 0.4000
}
cone {
<0.4037 ,-2.9768 ,-2.6412>, 0.1000
<0.6056 ,-4.4651 ,-3.9618>, 0.4000
}
cone {
<0.0117 ,-3.0005 ,-2.6451>, 0.1000
<0.0176 ,-4.5008 ,-3.9677>, 0.4000
}
cone {
<-0.3796 ,-2.9729 ,-2.6491>, 0.1000
<-0.5694 ,-4.4594 ,-3.9736>, 0.4000
}
cone {
<-0.7635 ,-2.8946 ,-2.6530>, 0.1000
<-1.1452 ,-4.3419 ,-3.9795>, 0.4000
}
cone {
<-1.1334 ,-2.7670 ,-2.6569>, 0.1000
<-1.7001 ,-4.1505 ,-3.9853>, 0.4000
}
cone {
<-1.4832 ,-2.5924 ,-2.6608>, 0.1000
<-2.2247 ,-3.8886 ,-3.9912>, 0.4000
}
cone {
<-1.8067 ,-2.3738 ,-2.6647>, 0.1000
<-2.7101 ,-3.5608 ,-3.9971>, 0.4000
}
cone {
<-2.0986 ,-2.1152 ,-2.6686>, 0.1000
<-3.1480 ,-3.1729 ,-4.0029>, 0.4000
}
cone {
<-2.3540 ,-1.8211 ,-2.6725>, 0.1000
<-3.5310 ,-2.7316 ,-4.0088>, 0.4000
}
cone {
<-2.5685 ,-1.4965 ,-2.6764>, 0.1000
<-3.8528 ,-2.2447 ,-4.0146>, 0.4000
}
cone {
<-2.7386 ,-1.1471 ,-2.6803>, 0.1000
<-4.1080 ,-1.7206 ,-4.0204>, 0.4000
}
cone {
<-2.8616 ,-0.7789 ,-2.6842>, 0.1000
<-4.2923 ,-1.1684 ,-4.0263>, 0.4000
}
cone {
<-2.9353 ,-0.3983 ,-2.6881>, 0.1000
<-4.4029 ,-0.5974 ,-4.0321>, 0.4000
}
cone {
<-2.9586 ,-0.0117 ,-2.6919>, 0.1000
<-4.4379 ,-0.0176 ,-4.0379>, 0.4000
}
cone {
<-2.9313 ,0.3741 ,-2.6958>, 0.1000
<-4.3970 ,0.5611 ,-4.0437>, 0.4000
}
cone {
<-2.8540 ,0.7526 ,-2.6997>, 0.1000
<-4.2810 ,1.1289 ,-4.0495>, 0.4000
}
cone {
<-2.7281 ,1.1173 ,-2.7035>, 0.1000
<-4.0922 ,1.6759 ,-4.0553>, 0.4000
}
cone {
<-2.5559 ,1.4621 ,-2.7074>, 0.1000
<-3.8338 ,2.1931 ,-4.0611>, 0.4000
}
cone {
<-2.3403 ,1.7810 ,-2.7112>, 0.1000
<-3.5105 ,2.6715 ,-4.0669>, 0.4000
}
cone {
<-2.0854 ,2.0687 ,-2.7151>, 0.1000
<-3.1280 ,3.1031 ,-4.0726>, 0.4000
}
cone {
<-1.7953 ,2.3204 ,-2.7189>, 0.1000
<-2.6930 ,3.4806 ,-4.0784>, 0.4000
}
cone {
<-1.4753 ,2.5318 ,-2.7228>, 0.1000
<-2.2130 ,3.7977 ,-4.0841>, 0.4000
}
cone {
<-1.1309 ,2.6994 ,-2.7266>, 0.1000
<-1.6963 ,4.0491 ,-4.0899>, 0.4000
}
cone {
<-0.7679 ,2.8205 ,-2.7304>, 0.1000
<-1.1519 ,4.2307 ,-4.0956>, 0.4000
}
cone {
<-0.3927 ,2.8930 ,-2.7343>, 0.1000
<-0.5891 ,4.3395 ,-4.1014>, 0.4000
}
cone {
<-0.0118 ,2.9160 ,-2.7381>, 0.1000
<-0.0176 ,4.3739 ,-4.1071>, 0.4000
}
cone {
<0.3685 ,2.8890 ,-2.7419>, 0.1000
<0.5527 ,4.3335 ,-4.1128>, 0.4000
}
cone {
<0.7415 ,2.8127 ,-2.7457>, 0.1000
<1.1122 ,4.2191 ,-4.1185>, 0.4000
}
cone {
<1.1009 ,2.6885 ,-2.7495>, 0.1000
<1.6513 ,4.0328 ,-4.1243>, 0.4000
}
cone {
<1.4406 ,2.5187 ,-2.7533>, 0.1000
<2.1609 ,3.7781 ,-4.1300>, 0.4000
}
cone {
<1.7548 ,2.3063 ,-2.7571>, 0.1000
<2.6323 ,3.4594 ,-4.1356>, 0.4000
}
cone {
<2.0383 ,2.0549 ,-2.7609>, 0.1000
<3.0575 ,3.0824 ,-4.1413>, 0.4000
}
cone {
<2.2862 ,1.7691 ,-2.7647>, 0.1000
<3.4293 ,2.6537 ,-4.1470>, 0.4000
}
cone {
<2.4944 ,1.4538 ,-2.7685>, 0.1000
<3.7417 ,2.1806 ,-4.1527>, 0.4000
}
cone {
<2.6595 ,1.1143 ,-2.7722>, 0.1000
<3.9893 ,1.6715 ,-4.1583>, 0.4000
}
cone {
<2.7787 ,0.7567 ,-2.7760>, 0.1000
<4.1680 ,1.1351 ,-4.1640>, 0.4000
}
cone {
<2.8501 ,0.3871 ,-2.7798>, 0.1000
<4.2751 ,0.5806 ,-4.1697>, 0.4000
}
cone {
<2.8726 ,0.0118 ,-2.7835>, 0.1000
<4.3089 ,0.0177 ,-4.1753>, 0.4000
}
cone {
<2.8459 ,-0.3628 ,-2.7873>, 0.1000
<4.2689 ,-0.5442 ,-4.1809>, 0.4000
}
cone {
<2.7707 ,-0.7302 ,-2.7910>, 0.1000
<4.1561 ,-1.0953 ,-4.1866>, 0.4000
}
cone {
<2.6483 ,-1.0842 ,-2.7948>, 0.1000
<3.9725 ,-1.6263 ,-4.1922>, 0.4000
}
cone {
<2.4810 ,-1.4188 ,-2.7985>, 0.1000
<3.7215 ,-2.1282 ,-4.1978>, 0.4000
}
cone {
<2.2716 ,-1.7283 ,-2.8023>, 0.1000
<3.4075 ,-2.5924 ,-4.2034>, 0.4000
}
cone {
<2.0240 ,-2.0074 ,-2.8060>, 0.1000
<3.0361 ,-3.0111 ,-4.2090>, 0.4000
}
cone {
<1.7425 ,-2.2515 ,-2.8097>, 0.1000
<2.6137 ,-3.3772 ,-4.2146>, 0.4000
}
cone {
<1.4318 ,-2.4565 ,-2.8135>, 0.1000
<2.1478 ,-3.6847 ,-4.2202>, 0.4000
}
cone {
<1.0975 ,-2.6189 ,-2.8172>, 0.1000
<1.6463 ,-3.9284 ,-4.2258>, 0.4000
}
cone {
<0.7454 ,-2.7362 ,-2.8209>, 0.1000
<1.1180 ,-4.1044 ,-4.2313>, 0.4000
}
cone {
<0.3813 ,-2.8065 ,-2.8246>, 0.1000
<0.5720 ,-4.2097 ,-4.2369>, 0.4000
}
cone {
<0.0118 ,-2.8285 ,-2.8283>, 0.1000
<0.0177 ,-4.2428 ,-4.2425>, 0.4000
}
cone {
<-0.3570 ,-2.8022 ,-2.8320>, 0.1000
<-0.5356 ,-4.2033 ,-4.2480>, 0.4000
}
cone {
<-0.7188 ,-2.7280 ,-2.8357>, 0.1000
<-1.0782 ,-4.0920 ,-4.2536>, 0.4000
}
cone {
<-1.0673 ,-2.6074 ,-2.8394>, 0.1000
<-1.6009 ,-3.9112 ,-4.2591>, 0.4000
}
cone {
<-1.3966 ,-2.4426 ,-2.8431>, 0.1000
<-2.0950 ,-3.6639 ,-4.2646>, 0.4000
}
cone {
<-1.7013 ,-2.2364 ,-2.8468>, 0.1000
<-2.5519 ,-3.3547 ,-4.2701>, 0.4000
}
cone {
<-1.9760 ,-1.9926 ,-2.8504>, 0.1000
<-2.9640 ,-2.9889 ,-4.2757>, 0.4000
}
cone {
<-2.2162 ,-1.7154 ,-2.8541>, 0.1000
<-3.3243 ,-2.5731 ,-4.2812>, 0.4000
}
cone {
<-2.4179 ,-1.4096 ,-2.8578>, 0.1000
<-3.6269 ,-2.1143 ,-4.2867>, 0.4000
}
cone {
<-2.5777 ,-1.0805 ,-2.8614>, 0.1000
<-3.8666 ,-1.6207 ,-4.2922>, 0.4000
}
cone {
<-2.6931 ,-0.7338 ,-2.8651>, 0.1000
<-4.0397 ,-1.1007 ,-4.2976>, 0.4000
}
cone {
<-2.7621 ,-0.3755 ,-2.8687>, 0.1000
<-4.1432 ,-0.5633 ,-4.3031>, 0.4000
}
cone {
<-2.7837 ,-0.0118 ,-2.8724>, 0.1000
<-4.1756 ,-0.0176 ,-4.3086>, 0.4000
}
cone {
<-2.7577 ,0.3512 ,-2.8760>, 0.1000
<-4.1366 ,0.5268 ,-4.3140>, 0.4000
}
cone {
<-2.6847 ,0.7072 ,-2.8797>, 0.1000
<-4.0270 ,1.0608 ,-4.3195>, 0.4000
}
cone {
<-2.5659 ,1.0501 ,-2.8833>, 0.1000
<-3.8489 ,1.5752 ,-4.3249>, 0.4000
}
cone {
<-2.4036 ,1.3742 ,-2.8869>, 0.1000
<-3.6054 ,2.0612 ,-4.3304>, 0.4000
}
cone {
<-2.2007 ,1.6738 ,-2.8905>, 0.1000
<-3.3010 ,2.5108 ,-4.3358>, 0.4000
}
cone {
<-1.9607 ,1.9441 ,-2.8942>, 0.1000
<-2.9411 ,2.9161 ,-4.3412>, 0.4000
}
cone {
<-1.6879 ,2.1804 ,-2.8978>, 0.1000
<-2.5318 ,3.2706 ,-4.3467>, 0.4000
}
cone {
<-1.3869 ,2.3787 ,-2.9014>, 0.1000
<-2.0804 ,3.5681 ,-4.3521>, 0.4000
}
cone {
<-1.0631 ,2.5359 ,-2.9050>, 0.1000
<-1.5947 ,3.8039 ,-4.3575>, 0.4000
}
cone {
<-0.7220 ,2.6493 ,-2.9086>, 0.1000
<-1.0831 ,3.9740 ,-4.3629>, 0.4000
}
cone {
<-0.3696 ,2.7171 ,-2.9122>, 0.1000
<-0.5543 ,4.0757 ,-4.3683>, 0.4000
}
cone {
<-0.0117 ,2.7383 ,-2.9158>, 0.1000
<-0.0176 ,4.1074 ,-4.3736>, 0.4000
}
cone {
<0.3453 ,2.7126 ,-2.9193>, 0.1000
<0.5179 ,4.0689 ,-4.3790>, 0.4000
}
cone {
<0.6954 ,2.6406 ,-2.9229>, 0.1000
<1.0431 ,3.9610 ,-4.3844>, 0.4000
}
cone {
<1.0327 ,2.5237 ,-2.9265>, 0.1000
<1.5490 ,3.7856 ,-4.3897>, 0.4000
}
cone {
<1.3513 ,2.3640 ,-2.9301>, 0.1000
<2.0270 ,3.5461 ,-4.3951>, 0.4000
}
cone {
<1.6460 ,2.1644 ,-2.9336>, 0.1000
<2.4690 ,3.2466 ,-4.4004>, 0.4000
}
cone {
<1.9117 ,1.9283 ,-2.9372>, 0.1000
<2.8676 ,2.8925 ,-4.4058>, 0.4000
}
cone {
<2.1440 ,1.6599 ,-2.9407>, 0.1000
<3.2160 ,2.4899 ,-4.4111>, 0.4000
}
cone {
<2.3390 ,1.3640 ,-2.9443>, 0.1000
<3.5085 ,2.0459 ,-4.4164>, 0.4000
}
cone {
<2.4935 ,1.0455 ,-2.9478>, 0.1000
<3.7402 ,1.5683 ,-4.4217>, 0.4000
}
cone {
<2.6049 ,0.7101 ,-2.9513>, 0.1000
<3.9073 ,1.0652 ,-4.4270>, 0.4000
}
cone {
<2.6714 ,0.3635 ,-2.9549>, 0.1000
<4.0071 ,0.5453 ,-4.4323>, 0.4000
}
cone {
<2.6922 ,0.0117 ,-2.9584>, 0.1000
<4.0382 ,0.0176 ,-4.4376>, 0.4000
}
cone {
<2.6668 ,-0.3393 ,-2.9619>, 0.1000
<4.0002 ,-0.5089 ,-4.4429>, 0.4000
}
cone {
<2.5960 ,-0.6835 ,-2.9654>, 0.1000
<3.8939 ,-1.0252 ,-4.4482>, 0.4000
}
cone {
<2.4810 ,-1.0150 ,-2.9690>, 0.1000
<3.7214 ,-1.5225 ,-4.4534>, 0.4000
}
cone {
<2.3239 ,-1.3282 ,-2.9725>, 0.1000
<3.4858 ,-1.9923 ,-4.4587>, 0.4000
}
cone {
<2.1275 ,-1.6178 ,-2.9760>, 0.1000
<3.1913 ,-2.4267 ,-4.4639>, 0.4000
}
cone {
<1.8954 ,-1.8789 ,-2.9795>, 0.1000
<2.8431 ,-2.8183 ,-4.4692>, 0.4000
}
cone {
<1.6316 ,-2.1071 ,-2.9829>, 0.1000
<2.4474 ,-3.1607 ,-4.4744>, 0.4000
}
cone {
<1.3406 ,-2.2987 ,-2.9864>, 0.1000
<2.0110 ,-3.4480 ,-4.4797>, 0.4000
}
cone {
<1.0276 ,-2.4504 ,-2.9899>, 0.1000
<1.5414 ,-3.6756 ,-4.4849>, 0.4000
}
cone {
<0.6980 ,-2.5598 ,-2.9934>, 0.1000
<1.0470 ,-3.8397 ,-4.4901>, 0.4000
}
cone {
<0.3574 ,-2.6251 ,-2.9969>, 0.1000
<0.5361 ,-3.9376 ,-4.4953>, 0.4000
}
cone {
<0.0117 ,-2.6454 ,-3.0003>, 0.1000
<0.0175 ,-3.9680 ,-4.5005>, 0.4000
}
cone {
<-0.3332 ,-2.6204 ,-3.0038>, 0.1000
<-0.4998 ,-3.9305 ,-4.5057>, 0.4000
}
cone {
<-0.6714 ,-2.5506 ,-3.0072>, 0.1000
<-1.0070 ,-3.8260 ,-4.5109>, 0.4000
}
cone {
<-0.9970 ,-2.4375 ,-3.0107>, 0.1000
<-1.4956 ,-3.6563 ,-4.5160>, 0.4000
}
cone {
<-1.3047 ,-2.2831 ,-3.0141>, 0.1000
<-1.9571 ,-3.4247 ,-4.5212>, 0.4000
}
cone {
<-1.5892 ,-2.0902 ,-3.0176>, 0.1000
<-2.3837 ,-3.1353 ,-4.5264>, 0.4000
}
cone {
<-1.8456 ,-1.8621 ,-3.0210>, 0.1000
<-2.7684 ,-2.7931 ,-4.5315>, 0.4000
}
cone {
<-2.0697 ,-1.6028 ,-3.0244>, 0.1000
<-3.1046 ,-2.4042 ,-4.5367>, 0.4000
}
cone {
<-2.2578 ,-1.3170 ,-3.0279>, 0.1000
<-3.3867 ,-1.9755 ,-4.5418>, 0.4000
}
cone {
<-2.4067 ,-1.0095 ,-3.0313>, 0.1000
<-3.6101 ,-1.5142 ,-4.5469>, 0.4000
}
cone {
<-2.5141 ,-0.6857 ,-3.0347>, 0.1000
<-3.7711 ,-1.0285 ,-4.5520>, 0.4000
}
cone {
<-2.5781 ,-0.3512 ,-3.0381>, 0.1000
<-3.8672 ,-0.5267 ,-4.5572>, 0.4000
}
cone {
<-2.5979 ,-0.0116 ,-3.0415>, 0.1000
<-3.8969 ,-0.0174 ,-4.5623>, 0.4000
}
cone {
<-2.5732 ,0.3270 ,-3.0449>, 0.1000
<-3.8599 ,0.4906 ,-4.5674>, 0.4000
}
cone {
<-2.5047 ,0.6591 ,-3.0483>, 0.1000
<-3.7570 ,0.9886 ,-4.5724>, 0.4000
}
cone {
<-2.3935 ,0.9789 ,-3.0517>, 0.1000
<-3.5903 ,1.4683 ,-4.5775>, 0.4000
}
cone {
<-2.2418 ,1.2809 ,-3.0551>, 0.1000
<-3.3628 ,1.9214 ,-4.5826>, 0.4000
}
cone {
<-2.0523 ,1.5601 ,-3.0584>, 0.1000
<-3.0784 ,2.3402 ,-4.5877>, 0.4000
}
cone {
<-1.8283 ,1.8118 ,-3.0618>, 0.1000
<-2.7424 ,2.7178 ,-4.5927>, 0.4000
}
cone {
<-1.5737 ,2.0318 ,-3.0652>, 0.1000
<-2.3605 ,3.0477 ,-4.5978>, 0.4000
}
cone {
<-1.2930 ,2.2163 ,-3.0685>, 0.1000
<-1.9395 ,3.3245 ,-4.6028>, 0.4000
}
cone {
<-0.9911 ,2.3624 ,-3.0719>, 0.1000
<-1.4867 ,3.5437 ,-4.6079>, 0.4000
}
cone {
<-0.6732 ,2.4677 ,-3.0753>, 0.1000
<-1.0098 ,3.7016 ,-4.6129>, 0.4000
}
cone {
<-0.3448 ,2.5305 ,-3.0786>, 0.1000
<-0.5172 ,3.7957 ,-4.6179>, 0.4000
}
cone {
<-0.0116 ,2.5498 ,-3.0819>, 0.1000
<-0.0174 ,3.8247 ,-4.6229>, 0.4000
}
cone {
<0.3208 ,2.5255 ,-3.0853>, 0.1000
<0.4812 ,3.7883 ,-4.6279>, 0.4000
}
cone {
<0.6467 ,2.4581 ,-3.0886>, 0.1000
<0.9700 ,3.6872 ,-4.6329>, 0.4000
}
cone {
<0.9604 ,2.3489 ,-3.0919>, 0.1000
<1.4407 ,3.5234 ,-4.6379>, 0.4000
}
cone {
<1.2568 ,2.2000 ,-3.0952>, 0.1000
<1.8852 ,3.3000 ,-4.6429>, 0.4000
}
cone {
<1.5307 ,2.0139 ,-3.0986>, 0.1000
<2.2961 ,3.0208 ,-4.6478>, 0.4000
}
cone {
<1.7777 ,1.7940 ,-3.1019>, 0.1000
<2.6665 ,2.6910 ,-4.6528>, 0.4000
}
cone {
<1.9934 ,1.5441 ,-3.1052>, 0.1000
<2.9901 ,2.3162 ,-4.6578>, 0.4000
}
cone {
<2.1744 ,1.2687 ,-3.1085>, 0.1000
<3.2615 ,1.9030 ,-4.6627>, 0.4000
}
cone {
<2.3176 ,0.9725 ,-3.1118>, 0.1000
<3.4764 ,1.4587 ,-4.6676>, 0.4000
}
cone {
<2.4208 ,0.6606 ,-3.1150>, 0.1000
<3.6312 ,0.9909 ,-4.6726>, 0.4000
}
cone {
<2.4822 ,0.3384 ,-3.1183>, 0.1000
<3.7234 ,0.5076 ,-4.6775>, 0.4000
}
cone {
<2.5011 ,0.0115 ,-3.1216>, 0.1000
<3.7516 ,0.0173 ,-4.6824>, 0.4000
}
cone {
<2.4771 ,-0.3145 ,-3.1249>, 0.1000
<3.7157 ,-0.4718 ,-4.6873>, 0.4000
}
cone {
<2.4109 ,-0.6341 ,-3.1281>, 0.1000
<3.6164 ,-0.9511 ,-4.6922>, 0.4000
}
cone {
<2.3038 ,-0.9418 ,-3.1314>, 0.1000
<3.4556 ,-1.4127 ,-4.6971>, 0.4000
}
cone {
<2.1576 ,-1.2324 ,-3.1347>, 0.1000
<3.2364 ,-1.8486 ,-4.7020>, 0.4000
}
cone {
<1.9750 ,-1.5010 ,-3.1379>, 0.1000
<2.9625 ,-2.2515 ,-4.7069>, 0.4000
}
cone {
<1.7593 ,-1.7430 ,-3.1412>, 0.1000
<2.6389 ,-2.6145 ,-4.7117>, 0.4000
}
cone {
<1.5142 ,-1.9545 ,-3.1444>, 0.1000
<2.2713 ,-2.9317 ,-4.7166>, 0.4000
}
cone {
<1.2441 ,-2.1318 ,-3.1476>, 0.1000
<1.8661 ,-3.1978 ,-4.7214>, 0.4000
}
cone {
<0.9536 ,-2.2722 ,-3.1509>, 0.1000
<1.4304 ,-3.4083 ,-4.7263>, 0.4000
}
cone {
<0.6478 ,-2.3732 ,-3.1541>, 0.1000
<0.9716 ,-3.5598 ,-4.7311>, 0.4000
}
cone {
<0.3319 ,-2.4334 ,-3.1573>, 0.1000
<0.4979 ,-3.6501 ,-4.7359>, 0.4000
}
cone {
<0.0114 ,-2.4517 ,-3.1605>, 0.1000
<0.0172 ,-3.6776 ,-4.7408>, 0.4000
}
cone {
<-0.3081 ,-2.4282 ,-3.1637>, 0.1000
<-0.4622 ,-3.6422 ,-4.7456>, 0.4000
}
cone {
<-0.6214 ,-2.3632 ,-3.1669>, 0.1000
<-0.9321 ,-3.5447 ,-4.7504>, 0.4000
}
cone {
<-0.9229 ,-2.2580 ,-3.1701>, 0.1000
<-1.3844 ,-3.3870 ,-4.7552>, 0.4000
}
cone {
<-1.2077 ,-2.1146 ,-3.1733>, 0.1000
<-1.8115 ,-3.1719 ,-4.7599>, 0.4000
}
cone {
<-1.4709 ,-1.9356 ,-3.1765>, 0.1000
<-2.2063 ,-2.9034 ,-4.7647>, 0.4000
}
cone {
<-1.7080 ,-1.7241 ,-3.1797>, 0.1000
<-2.5620 ,-2.5862 ,-4.7695>, 0.4000
}
cone {
<-1.9151 ,-1.4839 ,-3.1828>, 0.1000
<-2.8727 ,-2.2258 ,-4.7743>, 0.4000
}
cone {
<-2.0888 ,-1.2191 ,-3.1860>, 0.1000
<-3.1332 ,-1.8287 ,-4.7790>, 0.4000
}
cone {
<-2.2262 ,-0.9344 ,-3.1892>, 0.1000
<-3.3393 ,-1.4017 ,-4.7838>, 0.4000
}
cone {
<-2.3251 ,-0.6348 ,-3.1923>, 0.1000
<-3.4877 ,-0.9522 ,-4.7885>, 0.4000
}
cone {
<-2.3839 ,-0.3253 ,-3.1955>, 0.1000
<-3.5759 ,-0.4880 ,-4.7932>, 0.4000
}
cone {
<-2.4018 ,-0.0114 ,-3.1986>, 0.1000
<-3.6027 ,-0.0170 ,-4.7979>, 0.4000
}
cone {
<-2.3786 ,0.3017 ,-3.2018>, 0.1000
<-3.5679 ,0.4525 ,-4.8026>, 0.4000
}
cone {
<-2.3148 ,0.6085 ,-3.2049>, 0.1000
<-3.4722 ,0.9128 ,-4.8074>, 0.4000
}
cone {
<-2.2117 ,0.9038 ,-3.2080>, 0.1000
<-3.3175 ,1.3558 ,-4.8120>, 0.4000
}
cone {
<-2.0712 ,1.1827 ,-3.2112>, 0.1000
<-3.1067 ,1.7740 ,-4.8167>, 0.4000
}
cone {
<-1.8957 ,1.4404 ,-3.2143>, 0.1000
<-2.8436 ,2.1605 ,-4.8214>, 0.4000
}
cone {
<-1.6885 ,1.6725 ,-3.2174>, 0.1000
<-2.5328 ,2.5088 ,-4.8261>, 0.4000
}
cone {
<-1.4532 ,1.8753 ,-3.2205>, 0.1000
<-2.1798 ,2.8129 ,-4.8307>, 0.4000
}
cone {
<-1.1939 ,2.0453 ,-3.2236>, 0.1000
<-1.7908 ,3.0679 ,-4.8354>, 0.4000
}
cone {
<-0.9151 ,2.1797 ,-3.2267>, 0.1000
<-1.3726 ,3.2695 ,-4.8400>, 0.4000
}
cone {
<-0.6216 ,2.2764 ,-3.2298>, 0.1000
<-0.9325 ,3.4146 ,-4.8447>, 0.4000
}
cone {
<-0.3186 ,2.3339 ,-3.2329>, 0.1000
<-0.4780 ,3.5008 ,-4.8493>, 0.4000
}
cone {
<-0.0113 ,2.3513 ,-3.2360>, 0.1000
<-0.0169 ,3.5269 ,-4.8539>, 0.4000
}
cone {
<0.2952 ,2.3284 ,-3.2390>, 0.1000
<0.4428 ,3.4926 ,-4.8585>, 0.4000
}
cone {
<0.5955 ,2.2659 ,-3.2421>, 0.1000
<0.8932 ,3.3988 ,-4.8631>, 0.4000
}
cone {
<0.8845 ,2.1648 ,-3.2452>, 0.1000
<1.3268 ,3.2473 ,-4.8677>, 0.4000
}
cone {
<1.1574 ,2.0272 ,-3.2482>, 0.1000
<1.7361 ,3.0408 ,-4.8723>, 0.4000
}
cone {
<1.4095 ,1.8554 ,-3.2513>, 0.1000
<2.1143 ,2.7831 ,-4.8769>, 0.4000
}
cone {
<1.6366 ,1.6525 ,-3.2543>, 0.1000
<2.4550 ,2.4788 ,-4.8815>, 0.4000
}
cone {
<1.8350 ,1.4222 ,-3.2574>, 0.1000
<2.7524 ,2.1332 ,-4.8860>, 0.4000
}
cone {
<2.0012 ,1.1683 ,-3.2604>, 0.1000
<3.0018 ,1.7525 ,-4.8906>, 0.4000
}
cone {
<2.1326 ,0.8955 ,-3.2634>, 0.1000
<3.1990 ,1.3432 ,-4.8951>, 0.4000
}
cone {
<2.2271 ,0.6083 ,-3.2665>, 0.1000
<3.3407 ,0.9125 ,-4.8997>, 0.4000
}
cone {
<2.2833 ,0.3119 ,-3.2695>, 0.1000
<3.4249 ,0.4678 ,-4.9042>, 0.4000
}
cone {
<2.3002 ,0.0112 ,-3.2725>, 0.1000
<3.4502 ,0.0168 ,-4.9087>, 0.4000
}
cone {
<2.2777 ,-0.2886 ,-3.2755>, 0.1000
<3.4165 ,-0.4329 ,-4.9132>, 0.4000
}
cone {
<2.2164 ,-0.5823 ,-3.2785>, 0.1000
<3.3246 ,-0.8735 ,-4.9177>, 0.4000
}
cone {
<2.1174 ,-0.8650 ,-3.2815>, 0.1000
<3.1762 ,-1.2975 ,-4.9222>, 0.4000
}
cone {
<1.9827 ,-1.1318 ,-3.2845>, 0.1000
<2.9740 ,-1.6978 ,-4.9267>, 0.4000
}
cone {
<1.8146 ,-1.3783 ,-3.2875>, 0.1000
<2.7219 ,-2.0675 ,-4.9312>, 0.4000
}
cone {
<1.6161 ,-1.6004 ,-3.2905>, 0.1000
<2.4241 ,-2.4005 ,-4.9357>, 0.4000
}
cone {
<1.3907 ,-1.7942 ,-3.2934>, 0.1000
<2.0861 ,-2.6913 ,-4.9401>, 0.4000
}
cone {
<1.1425 ,-1.9567 ,-3.2964>, 0.1000
<1.7137 ,-2.9350 ,-4.9446>, 0.4000
}
cone {
<0.8757 ,-2.0851 ,-3.2994>, 0.1000
<1.3135 ,-3.1276 ,-4.9490>, 0.4000
}
cone {
<0.5949 ,-2.1773 ,-3.3023>, 0.1000
<0.8923 ,-3.2660 ,-4.9535>, 0.4000
}
cone {
<0.3050 ,-2.2321 ,-3.3053>, 0.1000
<0.4575 ,-3.3481 ,-4.9579>, 0.4000
}
cone {
<0.0111 ,-2.2485 ,-3.3082>, 0.1000
<0.0166 ,-3.3727 ,-4.9623>, 0.4000
}
cone {
<-0.2820 ,-2.2264 ,-3.3112>, 0.1000
<-0.4229 ,-3.3396 ,-4.9667>, 0.4000
}
cone {
<-0.5690 ,-2.1663 ,-3.3141>, 0.1000
<-0.8535 ,-3.2495 ,-4.9711>, 0.4000
}
cone {
<-0.8453 ,-2.0695 ,-3.3170>, 0.1000
<-1.2679 ,-3.1043 ,-4.9755>, 0.4000
}
cone {
<-1.1060 ,-1.9377 ,-3.3199>, 0.1000
<-1.6590 ,-2.9066 ,-4.9799>, 0.4000
}
cone {
<-1.3468 ,-1.7733 ,-3.3229>, 0.1000
<-2.0202 ,-2.6600 ,-4.9843>, 0.4000
}
cone {
<-1.5637 ,-1.5793 ,-3.3258>, 0.1000
<-2.3456 ,-2.3689 ,-4.9887>, 0.4000
}
cone {
<-1.7530 ,-1.3590 ,-3.3287>, 0.1000
<-2.6295 ,-2.0385 ,-4.9930>, 0.4000
}
cone {
<-1.9116 ,-1.1164 ,-3.3316>, 0.1000
<-2.8674 ,-1.6746 ,-4.9974>, 0.4000
}
cone {
<-2.0370 ,-0.8556 ,-3.3345>, 0.1000
<-3.0554 ,-1.2834 ,-5.0017>, 0.4000
}
cone {
<-2.1270 ,-0.5813 ,-3.3374>, 0.1000
<-3.1905 ,-0.8719 ,-5.0060>, 0.4000
}
cone {
<-2.1803 ,-0.2981 ,-3.3402>, 0.1000
<-3.2705 ,-0.4472 ,-5.0104>, 0.4000
}
cone {
<-2.1962 ,-0.0109 ,-3.3431>, 0.1000
<-3.2943 ,-0.0164 ,-5.0147>, 0.4000
}
cone {
<-2.1745 ,0.2752 ,-3.3460>, 0.1000
<-3.2618 ,0.4129 ,-5.0190>, 0.4000
}
cone {
<-2.1158 ,0.5556 ,-3.3489>, 0.1000
<-3.1736 ,0.8334 ,-5.0233>, 0.4000
}
cone {
<-2.0211 ,0.8253 ,-3.3517>, 0.1000
<-3.0316 ,1.2380 ,-5.0276>, 0.4000
}
cone {
<-1.8923 ,1.0799 ,-3.3546>, 0.1000
<-2.8384 ,1.6199 ,-5.0319>, 0.4000
}
cone {
<-1.7316 ,1.3150 ,-3.3574>, 0.1000
<-2.5974 ,1.9725 ,-5.0361>, 0.4000
}
cone {
<-1.5421 ,1.5267 ,-3.3603>, 0.1000
<-2.3131 ,2.2900 ,-5.0404>, 0.4000
}
cone {
<-1.3269 ,1.7114 ,-3.3631>, 0.1000
<-1.9904 ,2.5671 ,-5.0447>, 0.4000
}
cone {
<-1.0900 ,1.8661 ,-3.3659>, 0.1000
<-1.6349 ,2.7992 ,-5.0489>, 0.4000
}
cone {
<-0.8354 ,1.9884 ,-3.3688>, 0.1000
<-1.2530 ,2.9826 ,-5.0531>, 0.4000
}
cone {
<-0.5675 ,2.0761 ,-3.3716>, 0.1000
<-0.8513 ,3.1142 ,-5.0574>, 0.4000
}
cone {
<-0.2911 ,2.1281 ,-3.3744>, 0.1000
<-0.4366 ,3.1921 ,-5.0616>, 0.4000
}
cone {
<-0.0108 ,2.1435 ,-3.3772>, 0.1000
<-0.0162 ,3.2152 ,-5.0658>, 0.4000
}
cone {
<0.2685 ,2.1221 ,-3.3800>, 0.1000
<0.4027 ,3.1832 ,-5.0700>, 0.4000
}
cone {
<0.5420 ,2.0647 ,-3.3828>, 0.1000
<0.8131 ,3.0970 ,-5.0742>, 0.4000
}
cone {
<0.8052 ,1.9722 ,-3.3856>, 0.1000
<1.2078 ,2.9582 ,-5.0784>, 0.4000
}
cone {
<1.0535 ,1.8463 ,-3.3884>, 0.1000
<1.5803 ,2.7695 ,-5.0826>, 0.4000
}
cone {
<1.2828 ,1.6895 ,-3.3912>, 0.1000
<1.9242 ,2.5342 ,-5.0867>, 0.4000
}
cone {
<1.4892 ,1.5045 ,-3.3939>, 0.1000
<2.2339 ,2.2567 ,-5.0909>, 0.4000
}
cone {
<1.6694 ,1.2945 ,-3.3967>, 0.1000
<2.5040 ,1.9417 ,-5.0951>, 0.4000
}
cone {
<1.8202 ,1.0633 ,-3.3995>, 0.1000
<2.7303 ,1.5949 ,-5.0992>, 0.4000
}
cone {
<1.9393 ,0.8149 ,-3.4022>, 0.1000
<2.9089 ,1.2223 ,-5.1033>, 0.4000
}
cone {
<2.0248 ,0.5536 ,-3.4050>, 0.1000
<3.0372 ,0.8304 ,-5.1075>, 0.4000
}
cone {
<2.0753 ,0.2840 ,-3.4077>, 0.1000
<3.1129 ,0.4260 ,-5.1116>, 0.4000
}
cone {
<2.0901 ,0.0107 ,-3.4105>, 0.1000
<3.1352 ,0.0160 ,-5.1157>, 0.4000
}
cone {
<2.0692 ,-0.2617 ,-3.4132>, 0.1000
<3.1038 ,-0.3925 ,-5.1198>, 0.4000
}
cone {
<2.0131 ,-0.5284 ,-3.4159>, 0.1000
<3.0196 ,-0.7925 ,-5.1239>, 0.4000
}
cone {
<1.9227 ,-0.7849 ,-3.4186>, 0.1000
<2.8841 ,-1.1773 ,-5.1280>, 0.4000
}
cone {
<1.7999 ,-1.0269 ,-3.4214>, 0.1000
<2.6999 ,-1.5404 ,-5.1320>, 0.4000
}
cone {
<1.6469 ,-1.2504 ,-3.4241>, 0.1000
<2.4704 ,-1.8755 ,-5.1361>, 0.4000
}
cone {
<1.4665 ,-1.4515 ,-3.4268>, 0.1000
<2.1997 ,-2.1772 ,-5.1401>, 0.4000
}
cone {
<1.2617 ,-1.6269 ,-3.4295>, 0.1000
<1.8926 ,-2.4404 ,-5.1442>, 0.4000
}
cone {
<1.0363 ,-1.7738 ,-3.4322>, 0.1000
<1.5545 ,-2.6607 ,-5.1482>, 0.4000
}
cone {
<0.7942 ,-1.8897 ,-3.4348>, 0.1000
<1.1913 ,-2.8346 ,-5.1523>, 0.4000
}
cone {
<0.5396 ,-1.9729 ,-3.4375>, 0.1000
<0.8094 ,-2.9593 ,-5.1563>, 0.4000
}
cone {
<0.2768 ,-2.0220 ,-3.4402>, 0.1000
<0.4153 ,-3.0330 ,-5.1603>, 0.4000
}
cone {
<0.0105 ,-2.0363 ,-3.4429>, 0.1000
<0.0158 ,-3.0545 ,-5.1643>, 0.4000
}
cone {
<-0.2548 ,-2.0158 ,-3.4455>, 0.1000
<-0.3822 ,-3.0237 ,-5.1683>, 0.4000
}
cone {
<-0.5145 ,-1.9609 ,-3.4482>, 0.1000
<-0.7718 ,-2.9414 ,-5.1723>, 0.4000
}
cone {
<-0.7644 ,-1.8728 ,-3.4508>, 0.1000
<-1.1466 ,-2.8092 ,-5.1762>, 0.4000
}
cone {
<-1.0000 ,-1.7531 ,-3.4535>, 0.1000
<-1.5001 ,-2.6297 ,-5.1802>, 0.4000
}
cone {
<-1.2176 ,-1.6040 ,-3.4561>, 0.1000
<-1.8264 ,-2.4060 ,-5.1842>, 0.4000
}
cone {
<-1.4133 ,-1.4281 ,-3.4587>, 0.1000
<-2.1200 ,-2.1422 ,-5.1881>, 0.4000
}
cone {
<-1.5841 ,-1.2287 ,-3.4614>, 0.1000
<-2.3761 ,-1.8430 ,-5.1921>, 0.4000
}
cone {
<-1.7270 ,-1.0091 ,-3.4640>, 0.1000
<-2.5904 ,-1.5137 ,-5.1960>, 0.4000
}
cone {
<-1.8397 ,-0.7733 ,-3.4666>, 0.1000
<-2.7596 ,-1.1600 ,-5.1999>, 0.4000
}
cone {
<-1.9205 ,-0.5254 ,-3.4692>, 0.1000
<-2.8808 ,-0.7881 ,-5.2038>, 0.4000
}
cone {
<-1.9682 ,-0.2696 ,-3.4718>, 0.1000
<-2.9523 ,-0.4044 ,-5.2077>, 0.4000
}
cone {
<-1.9820 ,-0.0104 ,-3.4744>, 0.1000
<-2.9730 ,-0.0156 ,-5.2116>, 0.4000
}
cone {
<-1.9619 ,0.2478 ,-3.4770>, 0.1000
<-2.9428 ,0.3717 ,-5.2155>, 0.4000
}
cone {
<-1.9083 ,0.5006 ,-3.4796>, 0.1000
<-2.8625 ,0.7509 ,-5.2194>, 0.4000
}
cone {
<-1.8225 ,0.7437 ,-3.4822>, 0.1000
<-2.7337 ,1.1155 ,-5.2233>, 0.4000
}
cone {
<-1.7058 ,0.9729 ,-3.4848>, 0.1000
<-2.5588 ,1.4594 ,-5.2271>, 0.4000
}
cone {
<-1.5606 ,1.1845 ,-3.4873>, 0.1000
<-2.3409 ,1.7768 ,-5.2310>, 0.4000
}
cone {
<-1.3894 ,1.3749 ,-3.4899>, 0.1000
<-2.0841 ,2.0623 ,-5.2348>, 0.4000
}
cone {
<-1.1953 ,1.5408 ,-3.4924>, 0.1000
<-1.7929 ,2.3112 ,-5.2387>, 0.4000
}
cone {
<-0.9816 ,1.6797 ,-3.4950>, 0.1000
<-1.4725 ,2.5196 ,-5.2425>, 0.4000
}
cone {
<-0.7522 ,1.7893 ,-3.4975>, 0.1000
<-1.1284 ,2.6839 ,-5.2463>, 0.4000
}
cone {
<-0.5111 ,1.8677 ,-3.5001>, 0.1000
<-0.7666 ,2.8016 ,-5.2501>, 0.4000
}
cone {
<-0.2623 ,1.9139 ,-3.5026>, 0.1000
<-0.3934 ,2.8708 ,-5.2539>, 0.4000
}
cone {
<-0.0102 ,1.9272 ,-3.5051>, 0.1000
<-0.0153 ,2.8908 ,-5.2577>, 0.4000
}
cone {
<0.2408 ,1.9075 ,-3.5076>, 0.1000
<0.3612 ,2.8612 ,-5.2615>, 0.4000
}
cone {
<0.4866 ,1.8553 ,-3.5102>, 0.1000
<0.7299 ,2.7829 ,-5.2652>, 0.4000
}
cone {
<0.7228 ,1.7716 ,-3.5127>, 0.1000
<1.0842 ,2.6575 ,-5.2690>, 0.4000
}
cone {
<0.9456 ,1.6581 ,-3.5152>, 0.1000
<1.4184 ,2.4872 ,-5.2728>, 0.4000
}
cone {
<1.1511 ,1.5169 ,-3.5177>, 0.1000
<1.7267 ,2.2753 ,-5.2765>, 0.4000
}
cone {
<1.3360 ,1.3504 ,-3.5202>, 0.1000
<2.0041 ,2.0256 ,-5.2802>, 0.4000
}
cone {
<1.4972 ,1.1616 ,-3.5226>, 0.1000
<2.2458 ,1.7424 ,-5.2840>, 0.4000
}
cone {
<1.6321 ,0.9539 ,-3.5251>, 0.1000
<2.4481 ,1.4309 ,-5.2877>, 0.4000
}
cone {
<1.7383 ,0.7310 ,-3.5276>, 0.1000
<2.6075 ,1.0964 ,-5.2914>, 0.4000
}
cone {
<1.8144 ,0.4966 ,-3.5300>, 0.1000
<2.7216 ,0.7449 ,-5.2951>, 0.4000
}
cone {
<1.8591 ,0.2549 ,-3.5325>, 0.1000
<2.7887 ,0.3824 ,-5.2988>, 0.4000
}
cone {
<1.8719 ,0.0100 ,-3.5350>, 0.1000
<2.8078 ,0.0151 ,-5.3024>, 0.4000
}
cone {
<1.8526 ,-0.2338 ,-3.5374>, 0.1000
<2.7789 ,-0.3507 ,-5.3061>, 0.4000
}
cone {
<1.8017 ,-0.4724 ,-3.5399>, 0.1000
<2.7026 ,-0.7086 ,-5.3098>, 0.4000
}
cone {
<1.7204 ,-0.7018 ,-3.5423>, 0.1000
<2.5806 ,-1.0527 ,-5.3134>, 0.4000
}
cone {
<1.6100 ,-0.9180 ,-3.5447>, 0.1000
<2.4151 ,-1.3770 ,-5.3171>, 0.4000
}
cone {
<1.4727 ,-1.1175 ,-3.5471>, 0.1000
<2.2091 ,-1.6763 ,-5.3207>, 0.4000
}
cone {
<1.3110 ,-1.2969 ,-3.5496>, 0.1000
<1.9665 ,-1.9454 ,-5.3243>, 0.4000
}
cone {
<1.1276 ,-1.4533 ,-3.5520>, 0.1000
<1.6915 ,-2.1799 ,-5.3279>, 0.4000
}
cone {
<0.9260 ,-1.5840 ,-3.5544>, 0.1000
<1.3890 ,-2.3760 ,-5.3316>, 0.4000
}
cone {
<0.7095 ,-1.6870 ,-3.5568>, 0.1000
<1.0643 ,-2.5305 ,-5.3352>, 0.4000
}
cone {
<0.4820 ,-1.7607 ,-3.5592>, 0.1000
<0.7230 ,-2.6410 ,-5.3387>, 0.4000
}
cone {
<0.2475 ,-1.8039 ,-3.5615>, 0.1000
<0.3712 ,-2.7059 ,-5.3423>, 0.4000
}
cone {
<0.0099 ,-1.8161 ,-3.5639>, 0.1000
<0.0148 ,-2.7242 ,-5.3459>, 0.4000
}
cone {
<-0.2267 ,-1.7972 ,-3.5663>, 0.1000
<-0.3400 ,-2.6959 ,-5.3495>, 0.4000
}
cone {
<-0.4581 ,-1.7478 ,-3.5687>, 0.1000
<-0.6872 ,-2.6217 ,-5.3530>, 0.4000
}
cone {
<-0.6806 ,-1.6687 ,-3.5710>, 0.1000
<-1.0209 ,-2.5030 ,-5.3565>, 0.4000
}
cone {
<-0.8902 ,-1.5615 ,-3.5734>, 0.1000
<-1.3354 ,-2.3423 ,-5.3601>, 0.4000
}
cone {
<-1.0836 ,-1.4283 ,-3.5757>, 0.1000
<-1.6254 ,-2.1424 ,-5.3636>, 0.4000
}
cone {
<-1.2575 ,-1.2713 ,-3.5781>, 0.1000
<-1.8862 ,-1.9069 ,-5.3671>, 0.4000
}
cone {
<-1.4089 ,-1.0934 ,-3.5804>, 0.1000
<-2.1134 ,-1.6401 ,-5.3706>, 0.4000
}
cone {
<-1.5355 ,-0.8978 ,-3.5827>, 0.1000
<-2.3033 ,-1.3467 ,-5.3741>, 0.4000
}
cone {
<-1.6353 ,-0.6879 ,-3.5851>, 0.1000
<-2.4529 ,-1.0318 ,-5.3776>, 0.4000
}
cone {
<-1.7065 ,-0.4673 ,-3.5874>, 0.1000
<-2.5598 ,-0.7010 ,-5.3811>, 0.4000
}
cone {
<-1.7483 ,-0.2399 ,-3.5897>, 0.1000
<-2.6224 ,-0.3599 ,-5.3846>, 0.4000
}
cone {
<-1.7599 ,-0.0097 ,-3.5920>, 0.1000
<-2.6399 ,-0.0145 ,-5.3880>, 0.4000
}
cone {
<-1.7415 ,0.2195 ,-3.5943>, 0.1000
<-2.6122 ,0.3293 ,-5.3915>, 0.4000
}
cone {
<-1.6934 ,0.4438 ,-3.5966>, 0.1000
<-2.5400 ,0.6656 ,-5.3949>, 0.4000
}
cone {
<-1.6166 ,0.6592 ,-3.5989>, 0.1000
<-2.4249 ,0.9888 ,-5.3983>, 0.4000
}
cone {
<-1.5126 ,0.8622 ,-3.6012>, 0.1000
<-2.2690 ,1.2934 ,-5.4018>, 0.4000
}
cone {
<-1.3834 ,1.0494 ,-3.6035>, 0.1000
<-2.0751 ,1.5742 ,-5.4052>, 0.4000
}
cone {
<-1.2312 ,1.2177 ,-3.6057>, 0.1000
<-1.8469 ,1.8266 ,-5.4086>, 0.4000
}
cone {
<-1.0589 ,1.3643 ,-3.6080>, 0.1000
<-1.5883 ,2.0464 ,-5.4120>, 0.4000
}
cone {
<-0.8694 ,1.4867 ,-3.6102>, 0.1000
<-1.3040 ,2.2301 ,-5.4154>, 0.4000
}
cone {
<-0.6660 ,1.5831 ,-3.6125>, 0.1000
<-0.9991 ,2.3747 ,-5.4187>, 0.4000
}
cone {
<-0.4525 ,1.6519 ,-3.6147>, 0.1000
<-0.6787 ,2.4779 ,-5.4221>, 0.4000
}
cone {
<-0.2323 ,1.6922 ,-3.6170>, 0.1000
<-0.3485 ,2.5383 ,-5.4255>, 0.4000
}
cone {
<-0.0095 ,1.7033 ,-3.6192>, 0.1000
<-0.0142 ,2.5549 ,-5.4288>, 0.4000
}
cone {
<0.2123 ,1.6853 ,-3.6214>, 0.1000
<0.3185 ,2.5279 ,-5.4322>, 0.4000
}
cone {
<0.4293 ,1.6385 ,-3.6237>, 0.1000
<0.6439 ,2.4578 ,-5.4355>, 0.4000
}
cone {
<0.6377 ,1.5641 ,-3.6259>, 0.1000
<0.9565 ,2.3461 ,-5.4388>, 0.4000
}
cone {
<0.8340 ,1.4634 ,-3.6281>, 0.1000
<1.2510 ,2.1950 ,-5.4421>, 0.4000
}
cone {
<1.0150 ,1.3382 ,-3.6303>, 0.1000
<1.5225 ,2.0073 ,-5.4454>, 0.4000
}
cone {
<1.1777 ,1.1909 ,-3.6325>, 0.1000
<1.7665 ,1.7863 ,-5.4487>, 0.4000
}
cone {
<1.3193 ,1.0241 ,-3.6347>, 0.1000
<1.9789 ,1.5361 ,-5.4520>, 0.4000
}
cone {
<1.4375 ,0.8407 ,-3.6369>, 0.1000
<2.1563 ,1.2611 ,-5.4553>, 0.4000
}
cone {
<1.5306 ,0.6441 ,-3.6390>, 0.1000
<2.2959 ,0.9661 ,-5.4585>, 0.4000
}
cone {
<1.5970 ,0.4375 ,-3.6412>, 0.1000
<2.3954 ,0.6563 ,-5.4618>, 0.4000
}
cone {
<1.6357 ,0.2247 ,-3.6434>, 0.1000
<2.4535 ,0.3370 ,-5.4650>, 0.4000
}
cone {
<1.6462 ,0.0093 ,-3.6455>, 0.1000
<2.4694 ,0.0139 ,-5.4683>, 0.4000
}
cone {
<1.6286 ,-0.2051 ,-3.6477>, 0.1000
<2.4429 ,-0.3076 ,-5.4715>, 0.4000
}
cone {
<1.5833 ,-0.4147 ,-3.6498>, 0.1000
<2.3750 ,-0.6221 ,-5.4747>, 0.4000
}
cone {
<1.5112 ,-0.6160 ,-3.6520>, 0.1000
<2.2668 ,-0.9240 ,-5.4779>, 0.4000
}
cone {
<1.4137 ,-0.8056 ,-3.6541>, 0.1000
<2.1206 ,-1.2084 ,-5.4811>, 0.4000
}
cone {
<1.2927 ,-0.9804 ,-3.6562>, 0.1000
<1.9390 ,-1.4705 ,-5.4843>, 0.4000
}
cone {
<1.1502 ,-1.1373 ,-3.6583>, 0.1000
<1.7254 ,-1.7060 ,-5.4875>, 0.4000
}
cone {
<0.9890 ,-1.2739 ,-3.6605>, 0.1000
<1.4835 ,-1.9109 ,-5.4907>, 0.4000
}
cone {
<0.8119 ,-1.3880 ,-3.6626>, 0.1000
<1.2178 ,-2.0820 ,-5.4938>, 0.4000
}
cone {
<0.6219 ,-1.4777 ,-3.6647>, 0.1000
<0.9329 ,-2.2165 ,-5.4970>, 0.4000
}
cone {
<0.4224 ,-1.5416 ,-3.6668>, 0.1000
<0.6337 ,-2.3124 ,-5.5001>, 0.4000
}
cone {
<0.2170 ,-1.5788 ,-3.6688>, 0.1000
<0.3255 ,-2.3681 ,-5.5033>, 0.4000
}
cone {
<0.0090 ,-1.5888 ,-3.6709>, 0.1000
<0.0135 ,-2.3832 ,-5.5064>, 0.4000
}
cone {
<-0.1978 ,-1.5716 ,-3.6730>, 0.1000
<-0.2967 ,-2.3574 ,-5.5095>, 0.4000
}
cone {
<-0.4000 ,-1.5277 ,-3.6751>, 0.1000
<-0.6000 ,-2.2915 ,-5.5126>, 0.4000
}
cone {
<-0.5942 ,-1.4579 ,-3.6771>, 0.1000
<-0.8913 ,-2.1869 ,-5.5157>, 0.4000
}
cone {
<-0.7770 ,-1.3637 ,-3.6792>, 0.1000
<-1.1655 ,-2.0456 ,-5.5188>, 0.4000
}
cone {
<-0.9455 ,-1.2468 ,-3.6812>, 0.1000
<-1.4182 ,-1.8702 ,-5.5219>, 0.4000
}
cone {
<-1.0967 ,-1.1093 ,-3.6833>, 0.1000
<-1.6451 ,-1.6640 ,-5.5249>, 0.4000
}
cone {
<-1.2283 ,-0.9537 ,-3.6853>, 0.1000
<-1.8425 ,-1.4306 ,-5.5280>, 0.4000
}
cone {
<-1.3381 ,-0.7828 ,-3.6874>, 0.1000
<-2.0072 ,-1.1742 ,-5.5310>, 0.4000
}
cone {
<-1.4244 ,-0.5996 ,-3.6894>, 0.1000
<-2.1366 ,-0.8994 ,-5.5341>, 0.4000
}
cone {
<-1.4858 ,-0.4073 ,-3.6914>, 0.1000
<-2.2287 ,-0.6109 ,-5.5371>, 0.4000
}
cone {
<-1.5215 ,-0.2092 ,-3.6934>, 0.1000
<-2.2822 ,-0.3138 ,-5.5401>, 0.4000
}
cone {
<-1.5309 ,-0.0088 ,-3.6954>, 0.1000
<-2.2964 ,-0.0132 ,-5.5431>, 0.4000
}
cone {
<-1.5142 ,0.1905 ,-3.6974>, 0.1000
<-2.2713 ,0.2857 ,-5.5461>, 0.4000
}
cone {
<-1.4717 ,0.3853 ,-3.6994>, 0.1000
<-2.2075 ,0.5779 ,-5.5491>, 0.4000
}
cone {
<-1.4043 ,0.5722 ,-3.7014>, 0.1000
<-2.1065 ,0.8583 ,-5.5521>, 0.4000
}
cone {
<-1.3134 ,0.7482 ,-3.7034>, 0.1000
<-1.9701 ,1.1223 ,-5.5551>, 0.4000
}
cone {
<-1.2006 ,0.9103 ,-3.7054>, 0.1000
<-1.8010 ,1.3655 ,-5.5581>, 0.4000
}
cone {
<-1.0681 ,1.0558 ,-3.7073>, 0.1000
<-1.6022 ,1.5837 ,-5.5610>, 0.4000
}
cone {
<-0.9182 ,1.1824 ,-3.7093>, 0.1000
<-1.3773 ,1.7736 ,-5.5640>, 0.4000
}
cone {
<-0.7536 ,1.2879 ,-3.7113>, 0.1000
<-1.1303 ,1.9319 ,-5.5669>, 0.4000
}
cone {
<-0.5771 ,1.3708 ,-3.7132>, 0.1000
<-0.8657 ,2.0562 ,-5.5698>, 0.4000
}
cone {
<-0.3920 ,1.4297 ,-3.7152>, 0.1000
<-0.5880 ,2.1445 ,-5.5727>, 0.4000
}
cone {
<-0.2014 ,1.4638 ,-3.7171>, 0.1000
<-0.3020 ,2.1957 ,-5.5756>, 0.4000
}
cone {
<-0.0086 ,1.4727 ,-3.7190>, 0.1000
<-0.0128 ,2.2090 ,-5.5785>, 0.4000
}
cone {
<0.1831 ,1.4564 ,-3.7209>, 0.1000
<0.2747 ,2.1846 ,-5.5814>, 0.4000
}
cone {
<0.3704 ,1.4153 ,-3.7229>, 0.1000
<0.5556 ,2.1230 ,-5.5843>, 0.4000
}
cone {
<0.5501 ,1.3503 ,-3.7248>, 0.1000
<0.8252 ,2.0255 ,-5.5872>, 0.4000
}
cone {
<0.7193 ,1.2627 ,-3.7267>, 0.1000
<1.0789 ,1.8941 ,-5.5900>, 0.4000
}
cone {
<0.8750 ,1.1542 ,-3.7286>, 0.1000
<1.3125 ,1.7313 ,-5.5929>, 0.4000
}
cone {
<1.0147 ,1.0266 ,-3.7305>, 0.1000
<1.5221 ,1.5399 ,-5.5957>, 0.4000
}
cone {
<1.1362 ,0.8824 ,-3.7324>, 0.1000
<1.7042 ,1.3236 ,-5.5985>, 0.4000
}
cone {
<1.2374 ,0.7241 ,-3.7342>, 0.1000
<1.8561 ,1.0861 ,-5.6014>, 0.4000
}
cone {
<1.3168 ,0.5545 ,-3.7361>, 0.1000
<1.9752 ,0.8318 ,-5.6042>, 0.4000
}
cone {
<1.3732 ,0.3766 ,-3.7380>, 0.1000
<2.0598 ,0.5649 ,-5.6070>, 0.4000
}
cone {
<1.4058 ,0.1935 ,-3.7398>, 0.1000
<2.1086 ,0.2902 ,-5.6098>, 0.4000
}
cone {
<1.4141 ,0.0083 ,-3.7417>, 0.1000
<2.1211 ,0.0125 ,-5.6125>, 0.4000
}
cone {
<1.3982 ,-0.1757 ,-3.7435>, 0.1000
<2.0973 ,-0.2636 ,-5.6153>, 0.4000
}
cone {
<1.3586 ,-0.3555 ,-3.7454>, 0.1000
<2.0379 ,-0.5332 ,-5.6181>, 0.4000
}
cone {
<1.2960 ,-0.5279 ,-3.7472>, 0.1000
<1.9440 ,-0.7919 ,-5.6208>, 0.4000
}
cone {
<1.2118 ,-0.6901 ,-3.7490>, 0.1000
<1.8177 ,-1.0352 ,-5.6236>, 0.4000
}
cone {
<1.1074 ,-0.8394 ,-3.7509>, 0.1000
<1.6611 ,-1.2591 ,-5.6263>, 0.4000
}
cone {
<0.9849 ,-0.9733 ,-3.7527>, 0.1000
<1.4773 ,-1.4600 ,-5.6290>, 0.4000
}
cone {
<0.8464 ,-1.0897 ,-3.7545>, 0.1000
<1.2696 ,-1.6345 ,-5.6317>, 0.4000
}
cone {
<0.6945 ,-1.1866 ,-3.7563>, 0.1000
<1.0417 ,-1.7799 ,-5.6344>, 0.4000
}
cone {
<0.5317 ,-1.2625 ,-3.7581>, 0.1000
<0.7976 ,-1.8938 ,-5.6371>, 0.4000
}
cone {
<0.3611 ,-1.3164 ,-3.7599>, 0.1000
<0.5417 ,-1.9746 ,-5.6398>, 0.4000
}
cone {
<0.1855 ,-1.3474 ,-3.7617>, 0.1000
<0.2783 ,-2.0211 ,-5.6425>, 0.4000
}
cone {
<0.0080 ,-1.3552 ,-3.7634>, 0.1000
<0.0121 ,-2.0327 ,-5.6452>, 0.4000
}
cone {
<-0.1683 ,-1.3397 ,-3.7652>, 0.1000
<-0.2524 ,-2.0096 ,-5.6478>, 0.4000
}
cone {
<-0.3405 ,-1.3015 ,-3.7670>, 0.1000
<-0.5107 ,-1.9523 ,-5.6505>, 0.4000
}
cone {
<-0.5056 ,-1.2414 ,-3.7687>, 0.1000
<-0.7583 ,-1.8621 ,-5.6531>, 0.4000
}
cone {
<-0.6608 ,-1.1605 ,-3.7705>, 0.1000
<-0.9912 ,-1.7407 ,-5.6557>, 0.4000
}
cone {
<-0.8037 ,-1.0604 ,-3.7722>, 0.1000
<-1.2055 ,-1.5906 ,-5.6583>, 0.4000
}
cone {
<-0.9317 ,-0.9429 ,-3.7740>, 0.1000
<-1.3976 ,-1.4144 ,-5.6610>, 0.4000
}
cone {
<-1.0429 ,-0.8102 ,-3.7757>, 0.1000
<-1.5644 ,-1.2153 ,-5.6636>, 0.4000
}
cone {
<-1.1355 ,-0.6646 ,-3.7774>, 0.1000
<-1.7032 ,-0.9970 ,-5.6661>, 0.4000
}
cone {
<-1.2079 ,-0.5088 ,-3.7791>, 0.1000
<-1.8119 ,-0.7633 ,-5.6687>, 0.4000
}
cone {
<-1.2593 ,-0.3455 ,-3.7809>, 0.1000
<-1.8889 ,-0.5183 ,-5.6713>, 0.4000
}
cone {
<-1.2887 ,-0.1775 ,-3.7826>, 0.1000
<-1.9330 ,-0.2663 ,-5.6738>, 0.4000
}
cone {
<-1.2959 ,-0.0078 ,-3.7843>, 0.1000
<-1.9438 ,-0.0117 ,-5.6764>, 0.4000
}
cone {
<-1.2809 ,0.1608 ,-3.7860>, 0.1000
<-1.9213 ,0.2412 ,-5.6789>, 0.4000
}
cone {
<-1.2441 ,0.3254 ,-3.7876>, 0.1000
<-1.8662 ,0.4880 ,-5.6815>, 0.4000
}
cone {
<-1.1864 ,0.4831 ,-3.7893>, 0.1000
<-1.7797 ,0.7246 ,-5.6840>, 0.4000
}
cone {
<-1.1089 ,0.6314 ,-3.7910>, 0.1000
<-1.6634 ,0.9471 ,-5.6865>, 0.4000
}
cone {
<-1.0131 ,0.7677 ,-3.7927>, 0.1000
<-1.5196 ,1.1516 ,-5.6890>, 0.4000
}
cone {
<-0.9007 ,0.8899 ,-3.7943>, 0.1000
<-1.3510 ,1.3348 ,-5.6915>, 0.4000
}
cone {
<-0.7738 ,0.9959 ,-3.7960>, 0.1000
<-1.1607 ,1.4938 ,-5.6940>, 0.4000
}
cone {
<-0.6347 ,1.0841 ,-3.7976>, 0.1000
<-0.9520 ,1.6261 ,-5.6964>, 0.4000
}
cone {
<-0.4858 ,1.1531 ,-3.7993>, 0.1000
<-0.7287 ,1.7296 ,-5.6989>, 0.4000
}
cone {
<-0.3298 ,1.2018 ,-3.8009>, 0.1000
<-0.4948 ,1.8027 ,-5.7014>, 0.4000
}
cone {
<-0.1695 ,1.2297 ,-3.8025>, 0.1000
<-0.2542 ,1.8445 ,-5.7038>, 0.4000
}
cone {
<-0.0075 ,1.2363 ,-3.8042>, 0.1000
<-0.0112 ,1.8544 ,-5.7062>, 0.4000
}
cone {
<0.1533 ,1.2217 ,-3.8058>, 0.1000
<0.2300 ,1.8326 ,-5.7086>, 0.4000
}
cone {
<0.3102 ,1.1865 ,-3.8074>, 0.1000
<0.4653 ,1.7797 ,-5.7111>, 0.4000
}
cone {
<0.4605 ,1.1312 ,-3.8090>, 0.1000
<0.6908 ,1.6968 ,-5.7135>, 0.4000
}
cone {
<0.6018 ,1.0571 ,-3.8106>, 0.1000
<0.9026 ,1.5856 ,-5.7159>, 0.4000
}
cone {
<0.7316 ,0.9655 ,-3.8122>, 0.1000
<1.0974 ,1.4483 ,-5.7182>, 0.4000
}
cone {
<0.8478 ,0.8582 ,-3.8137>, 0.1000
<1.2717 ,1.2873 ,-5.7206>, 0.4000
}
cone {
<0.9486 ,0.7372 ,-3.8153>, 0.1000
<1.4230 ,1.1057 ,-5.7230>, 0.4000
}
cone {
<1.0324 ,0.6045 ,-3.8169>, 0.1000
<1.5487 ,0.9068 ,-5.7253>, 0.4000
}
cone {
<1.0979 ,0.4626 ,-3.8185>, 0.1000
<1.6469 ,0.6940 ,-5.7277>, 0.4000
}
cone {
<1.1441 ,0.3141 ,-3.8200>, 0.1000
<1.7161 ,0.4711 ,-5.7300>, 0.4000
}
cone {
<1.1703 ,0.1614 ,-3.8216>, 0.1000
<1.7555 ,0.2421 ,-5.7323>, 0.4000
}
cone {
<1.1764 ,0.0072 ,-3.8231>, 0.1000
<1.7646 ,0.0108 ,-5.7347>, 0.4000
}
cone {
<1.1623 ,-0.1458 ,-3.8246>, 0.1000
<1.7434 ,-0.2187 ,-5.7370>, 0.4000
}
cone {
<1.1285 ,-0.2950 ,-3.8262>, 0.1000
<1.6927 ,-0.4424 ,-5.7392>, 0.4000
}
cone {
<1.0757 ,-0.4378 ,-3.8277>, 0.1000
<1.6135 ,-0.6568 ,-5.7415>, 0.4000
}
cone {
<1.0050 ,-0.5720 ,-3.8292>, 0.1000
<1.5075 ,-0.8580 ,-5.7438>, 0.4000
}
cone {
<0.9177 ,-0.6953 ,-3.8307>, 0.1000
<1.3766 ,-1.0429 ,-5.7461>, 0.4000
}
cone {
<0.8156 ,-0.8056 ,-3.8322>, 0.1000
<1.2233 ,-1.2084 ,-5.7483>, 0.4000
}
cone {
<0.7004 ,-0.9012 ,-3.8337>, 0.1000
<1.0505 ,-1.3518 ,-5.7506>, 0.4000
}
cone {
<0.5742 ,-0.9805 ,-3.8352>, 0.1000
<0.8613 ,-1.4708 ,-5.7528>, 0.4000
}
cone {
<0.4394 ,-1.0425 ,-3.8367>, 0.1000
<0.6590 ,-1.5637 ,-5.7550>, 0.4000
}
cone {
<0.2982 ,-1.0861 ,-3.8382>, 0.1000
<0.4473 ,-1.6291 ,-5.7573>, 0.4000
}
cone {
<0.1532 ,-1.1107 ,-3.8396>, 0.1000
<0.2298 ,-1.6661 ,-5.7595>, 0.4000
}
cone {
<0.0069 ,-1.1162 ,-3.8411>, 0.1000
<0.0104 ,-1.6743 ,-5.7617>, 0.4000
}
cone {
<-0.1382 ,-1.1025 ,-3.8426>, 0.1000
<-0.2073 ,-1.6538 ,-5.7638>, 0.4000
}
cone {
<-0.2797 ,-1.0702 ,-3.8440>, 0.1000
<-0.4195 ,-1.6053 ,-5.7660>, 0.4000
}
cone {
<-0.4151 ,-1.0199 ,-3.8455>, 0.1000
<-0.6226 ,-1.5298 ,-5.7682>, 0.4000
}
cone {
<-0.5421 ,-0.9526 ,-3.8469>, 0.1000
<-0.8132 ,-1.4289 ,-5.7703>, 0.4000
}
cone {
<-0.6588 ,-0.8697 ,-3.8483>, 0.1000
<-0.9882 ,-1.3045 ,-5.7725>, 0.4000
}
cone {
<-0.7631 ,-0.7727 ,-3.8498>, 0.1000
<-1.1447 ,-1.1590 ,-5.7746>, 0.4000
}
cone {
<-0.8535 ,-0.6634 ,-3.8512>, 0.1000
<-1.2802 ,-0.9951 ,-5.7768>, 0.4000
}
cone {
<-0.9284 ,-0.5438 ,-3.8526>, 0.1000
<-1.3926 ,-0.8156 ,-5.7789>, 0.4000
}
cone {
<-0.9868 ,-0.4160 ,-3.8540>, 0.1000
<-1.4802 ,-0.6240 ,-5.7810>, 0.4000
}
cone {
<-1.0278 ,-0.2823 ,-3.8554>, 0.1000
<-1.5417 ,-0.4234 ,-5.7831>, 0.4000
}
cone {
<-1.0508 ,-0.1450 ,-3.8568>, 0.1000
<-1.5762 ,-0.2175 ,-5.7852>, 0.4000
}
cone {
<-1.0557 ,-0.0066 ,-3.8582>, 0.1000
<-1.5836 ,-0.0099 ,-5.7872>, 0.4000
}
cone {
<-1.0425 ,0.1306 ,-3.8595>, 0.1000
<-1.5638 ,0.1959 ,-5.7893>, 0.4000
}
cone {
<-1.0117 ,0.2643 ,-3.8609>, 0.1000
<-1.5175 ,0.3964 ,-5.7914>, 0.4000
}
cone {
<-0.9638 ,0.3922 ,-3.8623>, 0.1000
<-1.4458 ,0.5883 ,-5.7934>, 0.4000
}
cone {
<-0.9000 ,0.5121 ,-3.8636>, 0.1000
<-1.3500 ,0.7682 ,-5.7955>, 0.4000
}
cone {
<-0.8214 ,0.6222 ,-3.8650>, 0.1000
<-1.2322 ,0.9332 ,-5.7975>, 0.4000
}
cone {
<-0.7296 ,0.7205 ,-3.8663>, 0.1000
<-1.0944 ,1.0807 ,-5.7995>, 0.4000
}
cone {
<-0.6262 ,0.8056 ,-3.8677>, 0.1000
<-0.9393 ,1.2083 ,-5.8015>, 0.4000
}
cone {
<-0.5132 ,0.8760 ,-3.8690>, 0.1000
<-0.7697 ,1.3141 ,-5.8035>, 0.4000
}
cone {
<-0.3925 ,0.9309 ,-3.8703>, 0.1000
<-0.5887 ,1.3963 ,-5.8055>, 0.4000
}
cone {
<-0.2663 ,0.9692 ,-3.8717>, 0.1000
<-0.3994 ,1.4539 ,-5.8075>, 0.4000
}
cone {
<-0.1368 ,0.9907 ,-3.8730>, 0.1000
<-0.2052 ,1.4860 ,-5.8094>, 0.4000
}
cone {
<-0.0063 ,0.9950 ,-3.8743>, 0.1000
<-0.0094 ,1.4925 ,-5.8114>, 0.4000
}
cone {
<0.1230 ,0.9823 ,-3.8756>, 0.1000
<0.1845 ,1.4734 ,-5.8134>, 0.4000
}
cone {
<0.2489 ,0.9529 ,-3.8769>, 0.1000
<0.3733 ,1.4293 ,-5.8153>, 0.4000
}
cone {
<0.3692 ,0.9076 ,-3.8781>, 0.1000
<0.5538 ,1.3613 ,-5.8172>, 0.4000
}
cone {
<0.4820 ,0.8472 ,-3.8794>, 0.1000
<0.7230 ,1.2708 ,-5.8191>, 0.4000
}
cone {
<0.5854 ,0.7730 ,-3.8807>, 0.1000
<0.8781 ,1.1595 ,-5.8210>, 0.4000
}
cone {
<0.6777 ,0.6864 ,-3.8820>, 0.1000
<1.0165 ,1.0295 ,-5.8229>, 0.4000
}
cone {
<0.7575 ,0.5889 ,-3.8832>, 0.1000
<1.1362 ,0.8834 ,-5.8248>, 0.4000
}
cone {
<0.8235 ,0.4824 ,-3.8845>, 0.1000
<1.2352 ,0.7237 ,-5.8267>, 0.4000
}
cone {
<0.8747 ,0.3689 ,-3.8857>, 0.1000
<1.3121 ,0.5533 ,-5.8286>, 0.4000
}
cone {
<0.9105 ,0.2502 ,-3.8870>, 0.1000
<1.3657 ,0.3753 ,-5.8304>, 0.4000
}
cone {
<0.9303 ,0.1285 ,-3.8882>, 0.1000
<1.3954 ,0.1928 ,-5.8323>, 0.4000
}
cone {
<0.9340 ,0.0060 ,-3.8894>, 0.1000
<1.4010 ,0.0089 ,-5.8341>, 0.4000
}
cone {
<0.9217 ,-0.1154 ,-3.8906>, 0.1000
<1.3826 ,-0.1731 ,-5.8360>, 0.4000
}
cone {
<0.8939 ,-0.2334 ,-3.8919>, 0.1000
<1.3408 ,-0.3501 ,-5.8378>, 0.4000
}
cone {
<0.8510 ,-0.3462 ,-3.8931>, 0.1000
<1.2766 ,-0.5192 ,-5.8396>, 0.4000
}
cone {
<0.7942 ,-0.4518 ,-3.8943>, 0.1000
<1.1912 ,-0.6776 ,-5.8414>, 0.4000
}
cone {
<0.7243 ,-0.5485 ,-3.8954>, 0.1000
<1.0865 ,-0.8227 ,-5.8432>, 0.4000
}
cone {
<0.6429 ,-0.6347 ,-3.8966>, 0.1000
<0.9644 ,-0.9521 ,-5.8450>, 0.4000
}
cone {
<0.5514 ,-0.7092 ,-3.8978>, 0.1000
<0.8272 ,-1.0638 ,-5.8467>, 0.4000
}
cone {
<0.4516 ,-0.7707 ,-3.8990>, 0.1000
<0.6774 ,-1.1560 ,-5.8485>, 0.4000
}
cone {
<0.3451 ,-0.8183 ,-3.9002>, 0.1000
<0.5177 ,-1.2275 ,-5.8502>, 0.4000
}
cone {
<0.2340 ,-0.8515 ,-3.9013>, 0.1000
<0.3510 ,-1.2772 ,-5.8520>, 0.4000
}
cone {
<0.1202 ,-0.8697 ,-3.9025>, 0.1000
<0.1803 ,-1.3045 ,-5.8537>, 0.4000
}
cone {
<0.0056 ,-0.8728 ,-3.9036>, 0.1000
<0.0084 ,-1.3092 ,-5.8554>, 0.4000
}
cone {
<-0.1077 ,-0.8610 ,-3.9047>, 0.1000
<-0.1616 ,-1.2915 ,-5.8571>, 0.4000
}
cone {
<-0.2179 ,-0.8346 ,-3.9059>, 0.1000
<-0.3268 ,-1.2520 ,-5.8588>, 0.4000
}
cone {
<-0.3230 ,-0.7943 ,-3.9070>, 0.1000
<-0.4845 ,-1.1915 ,-5.8605>, 0.4000
}
cone {
<-0.4214 ,-0.7409 ,-3.9081>, 0.1000
<-0.6321 ,-1.1114 ,-5.8622>, 0.4000
}
cone {
<-0.5114 ,-0.6755 ,-3.9092>, 0.1000
<-0.7671 ,-1.0132 ,-5.8639>, 0.4000
}
cone {
<-0.5916 ,-0.5993 ,-3.9103>, 0.1000
<-0.8874 ,-0.8990 ,-5.8655>, 0.4000
}
cone {
<-0.6607 ,-0.5138 ,-3.9114>, 0.1000
<-0.9911 ,-0.7708 ,-5.8672>, 0.4000
}
cone {
<-0.7177 ,-0.4206 ,-3.9125>, 0.1000
<-1.0766 ,-0.6309 ,-5.8688>, 0.4000
}
cone {
<-0.7618 ,-0.3213 ,-3.9136>, 0.1000
<-1.1427 ,-0.4820 ,-5.8704>, 0.4000
}
cone {
<-0.7923 ,-0.2178 ,-3.9147>, 0.1000
<-1.1884 ,-0.3267 ,-5.8721>, 0.4000
}
cone {
<-0.8088 ,-0.1118 ,-3.9158>, 0.1000
<-1.2133 ,-0.1678 ,-5.8737>, 0.4000
}
cone {
<-0.8114 ,-0.0053 ,-3.9168>, 0.1000
<-1.2171 ,-0.0079 ,-5.8753>, 0.4000
}
cone {
<-0.8000 ,0.1000 ,-3.9179>, 0.1000
<-1.2001 ,0.1500 ,-5.8768>, 0.4000
}
cone {
<-0.7752 ,0.2023 ,-3.9189>, 0.1000
<-1.1628 ,0.3035 ,-5.8784>, 0.4000
}
cone {
<-0.7374 ,0.2998 ,-3.9200>, 0.1000
<-1.1061 ,0.4497 ,-5.8800>, 0.4000
}
cone {
<-0.6875 ,0.3910 ,-3.9210>, 0.1000
<-1.0312 ,0.5864 ,-5.8815>, 0.4000
}
cone {
<-0.6265 ,0.4743 ,-3.9221>, 0.1000
<-0.9397 ,0.7114 ,-5.8831>, 0.4000
}
cone {
<-0.5556 ,0.5484 ,-3.9231>, 0.1000
<-0.8334 ,0.8225 ,-5.8846>, 0.4000
}
cone {
<-0.4761 ,0.6121 ,-3.9241>, 0.1000
<-0.7141 ,0.9182 ,-5.8862>, 0.4000
}
cone {
<-0.3895 ,0.6646 ,-3.9251>, 0.1000
<-0.5843 ,0.9969 ,-5.8877>, 0.4000
}
cone {
<-0.2975 ,0.7050 ,-3.9261>, 0.1000
<-0.4462 ,1.0575 ,-5.8892>, 0.4000
}
cone {
<-0.2015 ,0.7329 ,-3.9271>, 0.1000
<-0.3023 ,1.0993 ,-5.8907>, 0.4000
}
cone {
<-0.1034 ,0.7478 ,-3.9281>, 0.1000
<-0.1552 ,1.1217 ,-5.8922>, 0.4000
}
cone {
<-0.0049 ,0.7498 ,-3.9291>, 0.1000
<-0.0074 ,1.1247 ,-5.8936>, 0.4000
}
cone {
<0.0923 ,0.7389 ,-3.9301>, 0.1000
<0.1385 ,1.1083 ,-5.8951>, 0.4000
}
cone {
<0.1867 ,0.7155 ,-3.9310>, 0.1000
<0.2800 ,1.0733 ,-5.8966>, 0.4000
}
cone {
<0.2765 ,0.6803 ,-3.9320>, 0.1000
<0.4148 ,1.0204 ,-5.8980>, 0.4000
}
cone {
<0.3604 ,0.6339 ,-3.9330>, 0.1000
<0.5406 ,0.9508 ,-5.8995>, 0.4000
}
cone {
<0.4370 ,0.5773 ,-3.9339>, 0.1000
<0.6555 ,0.8660 ,-5.9009>, 0.4000
}
cone {
<0.5050 ,0.5117 ,-3.9349>, 0.1000
<0.7575 ,0.7675 ,-5.9023>, 0.4000
}
cone {
<0.5634 ,0.4382 ,-3.9358>, 0.1000
<0.8451 ,0.6574 ,-5.9037>, 0.4000
}
cone {
<0.6113 ,0.3584 ,-3.9367>, 0.1000
<0.9170 ,0.5375 ,-5.9051>, 0.4000
}
cone {
<0.6481 ,0.2735 ,-3.9377>, 0.1000
<0.9722 ,0.4102 ,-5.9065>, 0.4000
}
cone {
<0.6733 ,0.1852 ,-3.9386>, 0.1000
<1.0099 ,0.2778 ,-5.9079>, 0.4000
}
cone {
<0.6866 ,0.0950 ,-3.9395>, 0.1000
<1.0299 ,0.1425 ,-5.9092>, 0.4000
}
cone {
<0.6880 ,0.0046 ,-3.9404>, 0.1000
<1.0319 ,0.0068 ,-5.9106>, 0.4000
}
cone {
<0.6776 ,-0.0846 ,-3.9413>, 0.1000
<1.0163 ,-0.1269 ,-5.9119>, 0.4000
}
cone {
<0.6557 ,-0.1710 ,-3.9422>, 0.1000
<0.9836 ,-0.2566 ,-5.9133>, 0.4000
}
cone {
<0.6230 ,-0.2532 ,-3.9431>, 0.1000
<0.9345 ,-0.3798 ,-5.9146>, 0.4000
}
cone {
<0.5801 ,-0.3298 ,-3.9439>, 0.1000
<0.8702 ,-0.4947 ,-5.9159>, 0.4000
}
cone {
<0.5280 ,-0.3996 ,-3.9448>, 0.1000
<0.7920 ,-0.5994 ,-5.9172>, 0.4000
}
cone {
<0.4677 ,-0.4615 ,-3.9457>, 0.1000
<0.7015 ,-0.6922 ,-5.9185>, 0.4000
}
cone {
<0.4003 ,-0.5145 ,-3.9465>, 0.1000
<0.6004 ,-0.7717 ,-5.9198>, 0.4000
}
cone {
<0.3271 ,-0.5579 ,-3.9474>, 0.1000
<0.4906 ,-0.8368 ,-5.9211>, 0.4000
}
cone {
<0.2495 ,-0.5910 ,-3.9482>, 0.1000
<0.3742 ,-0.8865 ,-5.9223>, 0.4000
}
cone {
<0.1688 ,-0.6135 ,-3.9491>, 0.1000
<0.2532 ,-0.9203 ,-5.9236>, 0.4000
}
cone {
<0.0866 ,-0.6252 ,-3.9499>, 0.1000
<0.1299 ,-0.9378 ,-5.9248>, 0.4000
}
cone {
<0.0042 ,-0.6260 ,-3.9507>, 0.1000
<0.0063 ,-0.9390 ,-5.9261>, 0.4000
}
cone {
<-0.0769 ,-0.6160 ,-3.9515>, 0.1000
<-0.1154 ,-0.9241 ,-5.9273>, 0.4000
}
cone {
<-0.1554 ,-0.5957 ,-3.9523>, 0.1000
<-0.2330 ,-0.8936 ,-5.9285>, 0.4000
}
cone {
<-0.2298 ,-0.5656 ,-3.9531>, 0.1000
<-0.3447 ,-0.8484 ,-5.9297>, 0.4000
}
cone {
<-0.2991 ,-0.5262 ,-3.9539>, 0.1000
<-0.4487 ,-0.7894 ,-5.9309>, 0.4000
}
cone {
<-0.3621 ,-0.4786 ,-3.9547>, 0.1000
<-0.5432 ,-0.7178 ,-5.9321>, 0.4000
}
cone {
<-0.4179 ,-0.4235 ,-3.9555>, 0.1000
<-0.6268 ,-0.6353 ,-5.9333>, 0.4000
}
cone {
<-0.4655 ,-0.3622 ,-3.9563>, 0.1000
<-0.6982 ,-0.5433 ,-5.9344>, 0.4000
}
cone {
<-0.5043 ,-0.2957 ,-3.9570>, 0.1000
<-0.7564 ,-0.4436 ,-5.9356>, 0.4000
}
cone {
<-0.5338 ,-0.2253 ,-3.9578>, 0.1000
<-0.8007 ,-0.3380 ,-5.9367>, 0.4000
}
cone {
<-0.5537 ,-0.1524 ,-3.9586>, 0.1000
<-0.8305 ,-0.2285 ,-5.9378>, 0.4000
}
cone {
<-0.5637 ,-0.0781 ,-3.9593>, 0.1000
<-0.8455 ,-0.1171 ,-5.9390>, 0.4000
}
cone {
<-0.5639 ,-0.0038 ,-3.9601>, 0.1000
<-0.8458 ,-0.0057 ,-5.9401>, 0.4000
}
cone {
<-0.5544 ,0.0692 ,-3.9608>, 0.1000
<-0.8316 ,0.1038 ,-5.9412>, 0.4000
}
cone {
<-0.5356 ,0.1396 ,-3.9615>, 0.1000
<-0.8034 ,0.2095 ,-5.9423>, 0.4000
}
cone {
<-0.5080 ,0.2064 ,-3.9622>, 0.1000
<-0.7620 ,0.3096 ,-5.9434>, 0.4000
}
cone {
<-0.4722 ,0.2684 ,-3.9630>, 0.1000
<-0.7083 ,0.4026 ,-5.9444>, 0.4000
}
cone {
<-0.4290 ,0.3246 ,-3.9637>, 0.1000
<-0.6435 ,0.4869 ,-5.9455>, 0.4000
}
cone {
<-0.3793 ,0.3741 ,-3.9644>, 0.1000
<-0.5689 ,0.5612 ,-5.9465>, 0.4000
}
cone {
<-0.3240 ,0.4164 ,-3.9651>, 0.1000
<-0.4860 ,0.6245 ,-5.9476>, 0.4000
}
cone {
<-0.2643 ,0.4506 ,-3.9657>, 0.1000
<-0.3964 ,0.6759 ,-5.9486>, 0.4000
}
cone {
<-0.2012 ,0.4765 ,-3.9664>, 0.1000
<-0.3017 ,0.7147 ,-5.9496>, 0.4000
}
cone {
<-0.1359 ,0.4936 ,-3.9671>, 0.1000
<-0.2038 ,0.7404 ,-5.9506>, 0.4000
}
cone {
<-0.0696 ,0.5020 ,-3.9678>, 0.1000
<-0.1044 ,0.7530 ,-5.9516>, 0.4000
}
cone {
<-0.0034 ,0.5016 ,-3.9684>, 0.1000
<-0.0051 ,0.7524 ,-5.9526>, 0.4000
}
cone {
<0.0614 ,0.4926 ,-3.9691>, 0.1000
<0.0921 ,0.7389 ,-5.9536>, 0.4000
}
cone {
<0.1239 ,0.4753 ,-3.9697>, 0.1000
<0.1858 ,0.7130 ,-5.9546>, 0.4000
}
cone {
<0.1829 ,0.4503 ,-3.9704>, 0.1000
<0.2744 ,0.6754 ,-5.9555>, 0.4000
}
cone {
<0.2376 ,0.4180 ,-3.9710>, 0.1000
<0.3563 ,0.6271 ,-5.9565>, 0.4000
}
cone {
<0.2869 ,0.3793 ,-3.9716>, 0.1000
<0.4304 ,0.5690 ,-5.9574>, 0.4000
}
cone {
<0.3304 ,0.3349 ,-3.9722>, 0.1000
<0.4955 ,0.5024 ,-5.9584>, 0.4000
}
cone {
<0.3671 ,0.2857 ,-3.9729>, 0.1000
<0.5507 ,0.4286 ,-5.9593>, 0.4000
}
cone {
<0.3968 ,0.2327 ,-3.9735>, 0.1000
<0.5952 ,0.3491 ,-5.9602>, 0.4000
}
cone {
<0.4190 ,0.1769 ,-3.9741>, 0.1000
<0.6285 ,0.2654 ,-5.9611>, 0.4000
}
cone {
<0.4335 ,0.1194 ,-3.9747>, 0.1000
<0.6502 ,0.1790 ,-5.9620>, 0.4000
}
cone {
<0.4402 ,0.0610 ,-3.9752>, 0.1000
<0.6603 ,0.0916 ,-5.9629>, 0.4000
}
cone {
<0.4392 ,0.0030 ,-3.9758>, 0.1000
<0.6588 ,0.0045 ,-5.9637>, 0.4000
}
cone {
<0.4307 ,-0.0537 ,-3.9764>, 0.1000
<0.6460 ,-0.0805 ,-5.9646>, 0.4000
}
cone {
<0.4149 ,-0.1081 ,-3.9769>, 0.1000
<0.6224 ,-0.1622 ,-5.9654>, 0.4000
}
cone {
<0.3925 ,-0.1594 ,-3.9775>, 0.1000
<0.5887 ,-0.2391 ,-5.9663>, 0.4000
}
cone {
<0.3638 ,-0.2067 ,-3.9781>, 0.1000
<0.5457 ,-0.3100 ,-5.9671>, 0.4000
}
cone {
<0.3295 ,-0.2493 ,-3.9786>, 0.1000
<0.4943 ,-0.3739 ,-5.9679>, 0.4000
}
cone {
<0.2905 ,-0.2865 ,-3.9791>, 0.1000
<0.4357 ,-0.4297 ,-5.9687>, 0.4000
}
cone {
<0.2474 ,-0.3178 ,-3.9797>, 0.1000
<0.3711 ,-0.4767 ,-5.9695>, 0.4000
}
cone {
<0.2012 ,-0.3429 ,-3.9802>, 0.1000
<0.3017 ,-0.5144 ,-5.9703>, 0.4000
}
cone {
<0.1527 ,-0.3614 ,-3.9807>, 0.1000
<0.2290 ,-0.5421 ,-5.9711>, 0.4000
}
cone {
<0.1028 ,-0.3732 ,-3.9812>, 0.1000
<0.1542 ,-0.5599 ,-5.9718>, 0.4000
}
cone {
<0.0525 ,-0.3783 ,-3.9817>, 0.1000
<0.0787 ,-0.5674 ,-5.9726>, 0.4000
}
cone {
<0.0026 ,-0.3767 ,-3.9822>, 0.1000
<0.0039 ,-0.5651 ,-5.9733>, 0.4000
}
cone {
<-0.0459 ,-0.3686 ,-3.9827>, 0.1000
<-0.0689 ,-0.5530 ,-5.9741>, 0.4000
}
cone {
<-0.0923 ,-0.3545 ,-3.9832>, 0.1000
<-0.1385 ,-0.5317 ,-5.9748>, 0.4000
}
cone {
<-0.1358 ,-0.3345 ,-3.9837>, 0.1000
<-0.2038 ,-0.5018 ,-5.9755>, 0.4000
}
cone {
<-0.1758 ,-0.3094 ,-3.9841>, 0.1000
<-0.2637 ,-0.4641 ,-5.9762>, 0.4000
}
cone {
<-0.2115 ,-0.2797 ,-3.9846>, 0.1000
<-0.3173 ,-0.4195 ,-5.9769>, 0.4000
}
cone {
<-0.2425 ,-0.2460 ,-3.9851>, 0.1000
<-0.3638 ,-0.3689 ,-5.9776>, 0.4000
}
cone {
<-0.2685 ,-0.2090 ,-3.9855>, 0.1000
<-0.4027 ,-0.3135 ,-5.9783>, 0.4000
}
cone {
<-0.2889 ,-0.1695 ,-3.9859>, 0.1000
<-0.4334 ,-0.2543 ,-5.9789>, 0.4000
}
cone {
<-0.3038 ,-0.1283 ,-3.9864>, 0.1000
<-0.4557 ,-0.1925 ,-5.9796>, 0.4000
}
cone {
<-0.3129 ,-0.0862 ,-3.9868>, 0.1000
<-0.4693 ,-0.1293 ,-5.9802>, 0.4000
}
cone {
<-0.3163 ,-0.0439 ,-3.9872>, 0.1000
<-0.4745 ,-0.0658 ,-5.9808>, 0.4000
}
cone {
<-0.3141 ,-0.0022 ,-3.9876>, 0.1000
<-0.4712 ,-0.0033 ,-5.9815>, 0.4000
}
cone {
<-0.3065 ,0.0382 ,-3.9881>, 0.1000
<-0.4598 ,0.0573 ,-5.9821>, 0.4000
}
cone {
<-0.2939 ,0.0765 ,-3.9885>, 0.1000
<-0.4408 ,0.1148 ,-5.9827>, 0.4000
}
cone {
<-0.2765 ,0.1123 ,-3.9889>, 0.1000
<-0.4148 ,0.1684 ,-5.9833>, 0.4000
}
cone {
<-0.2550 ,0.1448 ,-3.9892>, 0.1000
<-0.3825 ,0.2172 ,-5.9839>, 0.4000
}
cone {
<-0.2297 ,0.1737 ,-3.9896>, 0.1000
<-0.3446 ,0.2606 ,-5.9844>, 0.4000
}
cone {
<-0.2014 ,0.1985 ,-3.9900>, 0.1000
<-0.3020 ,0.2978 ,-5.9850>, 0.4000
}
cone {
<-0.1705 ,0.2190 ,-3.9904>, 0.1000
<-0.2558 ,0.3285 ,-5.9855>, 0.4000
}
cone {
<-0.1378 ,0.2349 ,-3.9907>, 0.1000
<-0.2067 ,0.3523 ,-5.9861>, 0.4000
}
cone {
<-0.1040 ,0.2461 ,-3.9911>, 0.1000
<-0.1559 ,0.3691 ,-5.9866>, 0.4000
}
cone {
<-0.0696 ,0.2525 ,-3.9914>, 0.1000
<-0.1044 ,0.3787 ,-5.9871>, 0.4000
}
cone {
<-0.0353 ,0.2542 ,-3.9918>, 0.1000
<-0.0530 ,0.3813 ,-5.9876>, 0.4000
}
cone {
<-0.0018 ,0.2514 ,-3.9921>, 0.1000
<-0.0027 ,0.3772 ,-5.9881>, 0.4000
}
cone {
<0.0304 ,0.2443 ,-3.9924>, 0.1000
<0.0456 ,0.3665 ,-5.9886>, 0.4000
}
cone {
<0.0607 ,0.2332 ,-3.9927>, 0.1000
<0.0911 ,0.3498 ,-5.9891>, 0.4000
}
cone {
<0.0887 ,0.2185 ,-3.9930>, 0.1000
<0.1330 ,0.3277 ,-5.9896>, 0.4000
}
cone {
<0.1138 ,0.2005 ,-3.9934>, 0.1000
<0.1708 ,0.3007 ,-5.9900>, 0.4000
}
cone {
<0.1359 ,0.1797 ,-3.9936>, 0.1000
<0.2038 ,0.2696 ,-5.9905>, 0.4000
}
cone {
<0.1545 ,0.1567 ,-3.9939>, 0.1000
<0.2318 ,0.2351 ,-5.9909>, 0.4000
}
cone {
<0.1695 ,0.1320 ,-3.9942>, 0.1000
<0.2543 ,0.1980 ,-5.9913>, 0.4000
}
cone {
<0.1808 ,0.1061 ,-3.9945>, 0.1000
<0.2712 ,0.1592 ,-5.9918>, 0.4000
}
cone {
<0.1883 ,0.0796 ,-3.9948>, 0.1000
<0.2824 ,0.1193 ,-5.9922>, 0.4000
}
cone {
<0.1920 ,0.0529 ,-3.9950>, 0.1000
<0.2880 ,0.0794 ,-5.9926>, 0.4000
}
cone {
<0.1921 ,0.0267 ,-3.9953>, 0.1000
<0.2881 ,0.0400 ,-5.9929>, 0.4000
}
cone {
<0.1887 ,0.0013 ,-3.9955>, 0.1000
<0.2831 ,0.0020 ,-5.9933>, 0.4000
}
cone {
<0.1821 ,-0.0226 ,-3.9958>, 0.1000
<0.2731 ,-0.0340 ,-5.9937>, 0.4000
}
cone {
<0.1725 ,-0.0449 ,-3.9960>, 0.1000
<0.2588 ,-0.0674 ,-5.9940>, 0.4000
}
cone {
<0.1603 ,-0.0651 ,-3.9963>, 0.1000
<0.2405 ,-0.0976 ,-5.9944>, 0.4000
}
cone {
<0.1459 ,-0.0829 ,-3.9965>, 0.1000
<0.2189 ,-0.1243 ,-5.9947>, 0.4000
}
cone {
<0.1297 ,-0.0980 ,-3.9967>, 0.1000
<0.1945 ,-0.1470 ,-5.9950>, 0.4000
}
cone {
<0.1120 ,-0.1104 ,-3.9969>, 0.1000
<0.1681 ,-0.1657 ,-5.9954>, 0.4000
}
cone {
<0.0935 ,-0.1200 ,-3.9971>, 0.1000
<0.1402 ,-0.1800 ,-5.9957>, 0.4000
}
cone {
<0.0743 ,-0.1267 ,-3.9973>, 0.1000
<0.1115 ,-0.1900 ,-5.9960>, 0.4000
}
cone {
<0.0551 ,-0.1305 ,-3.9975>, 0.1000
<0.0827 ,-0.1957 ,-5.9962>, 0.4000
}
cone {
<0.0362 ,-0.1315 ,-3.9977>, 0.1000
<0.0544 ,-0.1972 ,-5.9965>, 0.4000
}
cone {
<0.0181 ,-0.1299 ,-3.9978>, 0.1000
<0.0271 ,-0.1949 ,-5.9968>, 0.4000
}
cone {
<0.0009 ,-0.1259 ,-3.9980>, 0.1000
<0.0014 ,-0.1889 ,-5.9970>, 0.4000
}
cone {
<-0.0149 ,-0.1198 ,-3.9982>, 0.1000
<-0.0223 ,-0.1797 ,-5.9973>, 0.4000
}
cone {
<-0.0291 ,-0.1117 ,-3.9983>, 0.1000
<-0.0436 ,-0.1676 ,-5.9975>, 0.4000
}
cone {
<-0.0414 ,-0.1021 ,-3.9985>, 0.1000
<-0.0622 ,-0.1532 ,-5.9977>, 0.4000
}
cone {
<-0.0518 ,-0.0913 ,-3.9986>, 0.1000
<-0.0778 ,-0.1370 ,-5.9979>, 0.4000
}
cone {
<-0.0602 ,-0.0796 ,-3.9988>, 0.1000
<-0.0902 ,-0.1194 ,-5.9981>, 0.4000
}
cone {
<-0.0664 ,-0.0673 ,-3.9989>, 0.1000
<-0.0995 ,-0.1010 ,-5.9983>, 0.4000
}
cone {
<-0.0704 ,-0.0549 ,-3.9990>, 0.1000
<-0.1057 ,-0.0823 ,-5.9985>, 0.4000
}
cone {
<-0.0725 ,-0.0426 ,-3.9991>, 0.1000
<-0.1087 ,-0.0638 ,-5.9987>, 0.4000
}
cone {
<-0.0726 ,-0.0307 ,-3.9992>, 0.1000
<-0.1089 ,-0.0460 ,-5.9988>, 0.4000
}
cone {
<-0.0709 ,-0.0196 ,-3.9993>, 0.1000
<-0.1064 ,-0.0293 ,-5.9990>, 0.4000
}
cone {
<-0.0677 ,-0.0094 ,-3.9994>, 0.1000
<-0.1016 ,-0.0141 ,-5.9991>, 0.4000
}
cone {
<-0.0631 ,-0.0005 ,-3.9995>, 0.1000
<-0.0947 ,-0.0007 ,-5.9993>, 0.4000
}
cone {
<-0.0574 ,0.0071 ,-3.9996>, 0.1000
<-0.0862 ,0.0107 ,-5.9994>, 0.4000
}
cone {
<-0.0510 ,0.0133 ,-3.9997>, 0.1000
<-0.0764 ,0.0199 ,-5.9995>, 0.4000
}
cone {
<-0.0439 ,0.0178 ,-3.9997>, 0.1000
<-0.0659 ,0.0267 ,-5.9996>, 0.4000
}
cone {
<-0.0367 ,0.0208 ,-3.9998>, 0.1000
<-0.0550 ,0.0312 ,-5.9997>, 0.4000
}
cone {
<-0.0295 ,0.0223 ,-3.9998>, 0.1000
<-0.0442 ,0.0334 ,-5.9997>, 0.4000
}
cone {
<-0.0226 ,0.0223 ,-3.9999>, 0.1000
<-0.0339 ,0.0334 ,-5.9998>, 0.4000
}
cone {
<-0.0163 ,0.0209 ,-3.9999>, 0.1000
<-0.0244 ,0.0313 ,-5.9999>, 0.4000
}
cone {
<-0.0108 ,0.0183 ,-3.9999>, 0.1000
<-0.0161 ,0.0275 ,-5.9999>, 0.4000
}
cone {
<-0.0062 ,0.0147 ,-4.0000>, 0.1000
<-0.0093 ,0.0221 ,-6.0000>, 0.4000
}
cone {
<-0.0029 ,0.0104 ,-4.0000>, 0.1000
<-0.0043 ,0.0156 ,-6.0000>, 0.4000
}
cone {
<-0.0008 ,0.0055 ,-4.0000>, 0.1000
<-0.0011 ,0.0082 ,-6.0000>, 0.4000
}
cone {
<-0.0000 ,0.0003 ,-4.0000>, 0.1000
<-0.0000 ,0.0004 ,-6.0000>, 0.4000
}

}

#declare DBs_Creature=object
{
union
{

object
{
  Creature_Body
  texture{Creature_Body_Txtr}
}

object  //LEG 1
{
  Creature_Leg
  scale 1.8
  rotate<0, 0, 0>
  translate<5, -2, 0>
}

object  //LEG 2
{
  Creature_Leg
  scale 1.8
  rotate<0, 60, 0>
  translate<5, -2, 0>
}

object  //LEG 3
{
  Creature_Leg
  scale 1.8
  rotate<0, 120, 0>
  translate<-5, -2, 0>
}

object  //LEG 4
{
  Creature_Leg
  scale 1.8
  rotate<0, 180, 0>
  translate<-5, -2, 0>
}

object  //LEG 5
{
  Creature_Leg
  scale 1.8
  rotate<0, 220, 0>
  translate<-5, -2, 0>
}

object  //LEG 6
{
  Creature_Leg
  scale 1.8
  rotate<0, 300, 0>
  translate<5, -2, 0>
}

object
{
  Creature_Feeler
  scale<1.0, 1.2, 1.0>
  rotate<0, 60, 0>
  translate<5, 5, -5>
}

object
{
  Creature_Feeler
  scale<1.0, 1.2, 1.0>
  rotate<0, 120, 0>
  translate<-5, 5, -5>
}

object
{
  Creature_Eye
  texture{Creature_Eye_Txtr}
  scale<1.2, 1.2, 0.8>
  translate<5, 5, -8>
}

object
{
  Creature_Eye
  texture{Creature_Eye_Txtr}
  scale<1.2, 1.2, 0.8>
  translate<-5, 5, -8>
}

object
{
  Creature_Prob
  texture{Creature_Prob_Txtr}
  scale<1, 1, 1>
  translate<0, 0, -20>
}

}
}

