// Persistence of Vision Ray Tracer Scene Include File
// File: butterfly.inc
// Vers: 3.1
// Desc: Object definition of a butterfly
// Auth: David Bowers

#declare Leg =
union
{
  cylinder
  {
    <0,0,0>,<0,.5,0>,.03
  }
  cylinder
  {
    <0,0,0>,<0,.5,0>,.03
    rotate -120*x
    translate .5*y
  }
  sphere
  {
    <0,0,0>,.1
    scale <.5,.5,1>
    rotate -45*y
    translate .01*x
    translate .5*y
    rotate -120*x
    translate .5*y
  
  }
  
  rotate -90*x
  pigment{Aquamarine/2}
}

#declare Antanae =  
union
{
  #local posy = 0;
  #while (posy <= 1.5)
  #local posx = sin((posy/1.5)*(pi*.6));
  sphere
  {
    <posx,posy,0>,.022
  }
  #local posy = posy + .02;
  #end
  pigment{Aquamarine/2}
}

#declare Body =
union
{
  // Abodomen
  #local pos = -2;
  #while (pos < 2)
  sphere
  {
    <pos,0,0>,.3
    #if (pos < 1)
      scale pos
    #end
    translate -pos*pos*y/100
  }
  #local pos = pos +.13;
  #end
  // Thorax
  sphere
  {
    <0,0,0>,.2
    scale <2,1,1>
  }
  // Head
  sphere
  {
    <0,0,0>,.2
    scale <1,1.5,1>
    rotate -30*z
    translate <-.2,-.05,0>
  }
  // Eyes
  union
  {
    sphere
    {
      <0,0,0>,.12
      scale <1,1.5,1>
      rotate -30*z
      translate <-.24,-.05,.1>
    }
    sphere
    {
      <0,0,0>,.12
      scale <1,1.5,1>
      rotate -30*z
      translate <-.24,-.05,-.1>
    }
    texture{Aluminum}
    pigment{Green/4}
    
  }  
  pigment{Aquamarine}
}                                 
  

#declare K = 20;  

#declare Grid1 = array[K][K]
#local rad1 = 10;
#local i = 0;
#while (i < K)
  #local r = (i/K)*rad1;
  #local j = 0;
  #while (j < K)
    #local a = (j/K)*((90*pi)/180);
    #local posx = 2*r*cos(a);
    #local posz = 2*r*sin(a);
    #local posy = 0;
    #declare Grid1[i][j] = <posx,posy,posz>;
  #local j = j + 1;
  #end
#local i = i + 1;
#end


#declare Grid2 = array[K][K]
#local rad1 = 10;
#local i = 0;
#while (i < K)
  #local r = (i/K)*rad1;
  #local j = 0;
  #while (j < K)
    #local a = (j/K)*((180*pi)/180);
    #local posx = r*cos(a);
    #local posz = 2*r*sin(a) -posx*posx*posx/50;
    #local posy = 0;
    #declare Grid2[i][j] = <posx,posy,posz>;
  #local j = j + 1;
  #end
#local i = i + 1;
#end

#declare Wings =
union
{
  mesh
  {
    #local i = 1;
    #while (i < K)
    #local j = 1;
    #while (j < K)
      triangle
      {
        Grid1[i][j],Grid1[i-1][j],Grid1[i][j-1]
      } 
      triangle
      {
        Grid1[i-1][j-1],Grid1[i-1][j],Grid1[i][j-1]
      } 
    #local j = j + 1;
    #end
    #local i = i + 1;        
    #end
    rotate <90,0,0>
  }
  mesh
  {
    #local i = 1;
    #while (i < K)
    #local j = 1;
    #while (j < K)
      triangle
      {
        Grid2[i][j],Grid2[i-1][j],Grid2[i][j-1]
      } 
      triangle
      {
        Grid2[i-1][j-1],Grid2[i-1][j],Grid2[i][j-1]
      } 
    #local j = j + 1;
    #end
    #local i = i + 1;        
    #end
    scale <1.5,1,1>
    rotate <90,0,180>
    translate <13,0,0>
  }
  
}  

#declare Butterfly =
union
{
  object
  {
    Body
  }
  object
  {
    Antanae
    rotate <-10,0,120>
    translate <-.35,0,-.1>
  }
  object
  {
    Antanae      
    rotate <20,0,120>
    translate <-.35,0,.1>
  }
  object
  {
    Leg
    translate <.2,0,-.1>
  }
  object
  {
    Leg
    rotate 180*y
    rotate -20*y
    translate <.2,0,.1>
  }
  object
  {
    Leg
    translate .1*x
  }
  object
  {
    Leg
    rotate 180*y
    translate .1*x
  }
  object
  {
    Leg
    rotate 20*y
    translate <0,0,-.1>
  }
  object
  {
    Leg
    rotate 180*y
    rotate -20*y
    translate <0,0,.1>
  }
  union
  {
    object
    {
      Wings
      scale <.1,.08,.1>*2
      rotate <0,30,90>
      translate <.25,.1,-.1>
    }
    object
    {
      Wings
      scale <.1,.08,.1>*2
      rotate <0,-30,90>
      translate <.25,.1,.1> 
    }
    pigment
    {
      spotted
      color_map
      {
        [0.01 rgbt(<0,0,0,.03>+ (Flesh/2))]
        [0.01 rgbt(<0,0,0,.03>+ Wheat)]
        
      }
      scale .1
      
    }
    normal
    {
      radial 
      rotate 90*x
      slope_map
      {
        [0.0   <.0000, 1.000>]
        [0.1   <.3090, .9512>]
        [0.2   <.5878, .8090>]
        [0.3   <.8090, .5878>]
        [0.4   <.9512, .3090>]
        [0.5   <1.000, 0.000>]
        [0.6   <.9512, .3090>]
        [0.7   <.8090, .5878>]
        [0.8   <.5878, .8090>]
        [0.9   <.3090, .9512>]
      }
       scale .1
       frequency 2
      }  
      
    finish 
    {
      specular .5
      ambient .5
    } 
    
  }  
  scale 2
}  

