// Persistence of Vision Ray Tracer Scene Description File
// File: plants.inc
// Vers: 3.1
// Desc: Object definitions of plants parts and plants
// Auth: David Bowers

#declare r1 = seed(pi);

#declare T_Water =
texture
{
   pigment
   {
      White
      transmit .7
   }
   finish
   {
      specular .2
      reflection .2
   }  
}   

#declare Drop =
union
{
  #local pos = pi/4;
  #local size = cos(pos);
  #local y1 = sin(pos);
  #local y2 = 1.5;
  cone
  {
     <0,y1,0>,size,<0,y2,0>,0
  }
  sphere
  {
     <0,0,0>,1
  }
  pigment
  {
    White
    transmit .7
  }
  finish
  {
    specular .2
    reflection .2
    refraction 1
  }  scale <.5,1,.5>
  interior
  {
     ior 1.33
     caustics 1.0
  }   
  scale <.1,.15,.1>
}



#declare P_Leaf1 =
pigment
{
  crackle
  color_map
  {
    [0.1 rgb <0,1,0>]
    [0.2 rgb <0,.5,0>]
  }
  scale .2
}

#declare P_Leaf2 =
pigment
{
  granite
  color_map
  {
    [0.2 rgb <0,1,0>]
    [0.1 rgb <0,.5,0>]
  }
  scale .2
}

#declare P_Leaf3 =
pigment
{
   wood
   color_map
   {
     [0.1 rgb <0,.8,0>] 
     [0.2 rgb <0,.5,0>] 
   }
   rotate<0,90,0>
   scale .1    
}

#declare P_Leaf4 =
pigment
{
  agate
  color_map
  {
    [0.1 rgb <0,1,0>]
    [0.5 rgb <0,.5,0>]
  }
  scale .5
}

#declare P_Leaf5 =
pigment
{
   leopard 
   color_map
   {
      [0.1 Green]
      [0.9 Yellow]
   }
   scale .1    
}

#declare Leaf1 =
blob
{
  threshold .6
  #local degree = 0;
  #while (degree < 360)
  #local radian = (degree * pi)/180;
  #local r = 1-cos(radian);
  cylinder
  {
    <0,0,0>,<abs(r)+.1,1,0>,.3,1
    scale <1,.1,1>
    rotate<0,0,15>
    rotate <0,degree,0>  
    pigment
    {
      rgb <1-abs(r),1,0>
    } 
  }
  #local degree = degree + 5;
  #end
}

#declare Leaf2 =
blob
{
  threshold .6
  #local degree = 0;
  #while (degree < 360)
  #local radian = (degree * pi)/180;
  #local r = 1-cos(radian);
  cylinder
  {
    <0,0,0>,<abs(r)+.1,1,0>,.3,1
    scale <1,.1,1>
    rotate<0,0,15>
    rotate <0,degree,0>  
   }
  #local degree = degree + 5;
  #end
}

#declare Leaf3 =
blob
{
  threshold .6
  #local degree = 0;
  #while (degree < 360)
  #local radian = (degree * pi)/180;
  #local r = 1-cos(radian);
  cylinder
  {
    <0,0,0>,<abs(r)+.1,1,0>,.3,1
    scale <1,.1,1>
    rotate<0,0,15>
    rotate <0,degree,0>  
   }
   #if(degree = 15)
   cylinder
   {
     <0,0,0>,<-2,.0,0>,.2,1
     rotate<0,r,-15>
     pigment
     {
       Green
     }   
   }
  #end
  #local degree = degree + 5;
  #end
}

#declare P_Leaf1 =
pigment
{
  crackle
  color_map
  {
    [0.1 rgb <0,1,0>]
    [0.2 rgb <0,.5,0>]
  }
  scale .2
}

#declare P_Leaf2 =
pigment
{
  granite
  color_map
  {
    [0.2 rgb <0,1,0>]
    [0.1 rgb <0,.5,0>]
  }
  scale .2
}

#declare P_Leaf3 =
pigment
{
   wood
   color_map
   {
     [0.1 rgb <0,.8,0>] 
     [0.2 rgb <0,.5,0>] 
      
   }
   rotate<0,90,0>
   scale .1    
}

#declare P_Leaf4 =
pigment
{
  agate
  color_map
  {
    [0.1 rgb <0,1,0>]
    [0.5 rgb <0,.5,0>]
  }
  scale .5
}

#declare P_Leaf5 =
pigment
{
   leopard 
   color_map
   {
      [0.1 Green]
      [0.9 Yellow]
   }
   scale .1    
}

#declare Leaf1 =
blob
{
  threshold .6
  #local degree = 0;
  #while (degree < 360)
  #local radian = (degree * pi)/180;
  #local r = 1-cos(radian);
  cylinder
  {
    <0,0,0>,<abs(r)+.1,1,0>,.3,1
    scale <1,.1,1>
    rotate<0,0,15>
    rotate <0,degree,0>  
    pigment
    {
      rgb <1-abs(r),1,0>
    } 
  }
  #local degree = degree + 5;
  #end
}

#declare Leaf2 =
blob
{
  threshold .6
  #local degree = 0;
  #while (degree < 360)
  #local radian = (degree * pi)/180;
  #local r = 1-cos(radian);
  cylinder
  {
    <0,0,0>,<abs(r)+.1,1,0>,.3,1
    scale <1,.1,1>
    rotate<0,0,15>
    rotate <0,degree,0>  
   }
  #local degree = degree + 5;
  #end
}

#declare Leaf3 =
blob
{
  threshold .6
  #local degree = 0;
  #while (degree < 360)
  #local radian = (degree * pi)/180;
  #local r = 1-cos(radian);
  cylinder
  {
    <0,0,0>,<abs(r)+.1,1,0>,.3,1
    scale <1,.1,1>
    rotate<0,0,15>
    rotate <0,degree,0>  
   }
   #if(degree = 15)
   cylinder
   {
     <0,0,0>,<-2,.0,0>,.2,1
     rotate<0,r,-15>
     pigment
     {
       Green
     }   
   }
  #end
  #local degree = degree + 5;
  #end
}


#declare Blade =
union
{
  object
  {
    Leaf2
    rotate -90*z
    scale <1,3,.25>
    rotate 90*y
    pigment
    {
      marble
      color_map
      {
        [0.1 Green/2]
        [0.5 Green/4]
      }
      scale .1
    }
  }
}

#declare Grass =
union
{
  #local grow = 0;
  #while (grow < 3)
  #local degree = 0;
  #while (degree < 360)
  union
  {
    #local dew = 0;
    #while (dew < 7)
    object 
    {
      Drop
      scale 1
      translate <(.5-rand(r1))/2,rand(r1)*4+1,0>
      rotate -7*x
    }
    #local dew = dew + 1;
    #end
    object
    {
      Blade
    }
    rotate rand(r1)*40*x
    rotate degree *y
  }  
  #local degree = degree + 45;
  #end
  #local grow = grow +1;
  #end
}  

#declare Seed =
union
{
  #local pos = pi/4;
  #local size = cos(pos);
  #local y1 = sin(pos);
  #local y2 = 1.5;
  cone
  {
     <0,y1,0>,size,<0,y2,0>,0
  }
  sphere
  {
     <0,0,0>,1
  }
  
  scale <.1,.15,.1>
}

#declare Grain =
union
{
    #declare s1 = seed(pi)
    #local size = 2
    #local pos = 0;
    #while (pos <= 4)
    union
    {
        #local degree = 0;
        #while (degree < 360)
        object
        {
            Seed
            scale <1,2,1>
            pigment {Khaki}
            translate -.2*x
            rotate 20*z
            rotate (degree+ rand(s1)*20) *y
        }
        #local degree = degree + 40;
        #end
        scale size + .1
        #local size = size -.2;
        translate <0,pos*.7,0>
    }
    #local pos = pos + .5;
    #end 
    scale <.8,1,.8>
}

#declare WheatGrass =
union
{
  object
  {
    Grain
    scale .75
    translate <10,0,0>
    rotate 50*z
  }
  
  difference
  {
    torus
    {
      10,
      .1
      rotate 90*x
    }
    box
    {
      <-1, -1, -1> 
      < .5,  1,  1> 
      scale <12,12,1>
    }
    pigment{Khaki}
  }
  rotate 40*z  
}