//Wings veins-----------------------------------------------------------------------------------------------------------------------
#declare Libelle_Ader_Texture = 
texture
{
  pigment
  {
   onion
   color_map
   {
    [0.5 rgbf<1,0.4,0,0.2>]
    [1   rgbf<1,1,0,0.2>]
   }
   
  }
  finish
  {
   specular 1
   roughness 0.001
   ambient 0.3
   diffuse 0
   reflection 0.5
   irid {0.3 thickness 0.25 turbulence 0.3}
  } 
}
#declare Libelle_Fluegel_Texture = 
texture
{
  pigment{rgbf<1,1,1,1>}
  normal
  {
   wrinkles scale 0.1
  }
  finish
  {
   specular 1
   roughness 0.001
   ambient 0.3
   diffuse 0.5
   reflection 0.5
   irid {0.3 thickness 0.25 turbulence 0.3}
  } 
}
#macro Libelle_Bogen(A,B,Biegung,Radius,Dicke,Steps)
 #if(Biegung = -1)
  #local C=<-100,0,-40>;
 #end
 #if(Biegung = 1) 
  #local C=<100,0,40>;
 #end

 #local Mittelpunkt = Get_Mittelpunkt(A,B,C,Radius);
 #local phi = get_Winkel(A,Mittelpunkt,B);

 #local Counter = 0;
 #local PunktA = A;
 
 #while(Counter<Steps)
  #local PunktB = rotate_Winkel(PunktA,Mittelpunkt,B, phi/Steps);//vaxis_rotate(PunktA,vcross(A-M,B-M)+M,degrees(phi))
  cylinder{PunktA,PunktB,Dicke }
  #local PunktA = PunktB ;
  #local Counter = Counter + 1;
 #end
#end


#macro Libelle_Adern_Start(Startpunkt,Richtung)
  cylinder{Startpunkt,Richtung Libelle_Ader_Dicke }

  #local StartpunktS = Startpunkt+0.2*(Richtung-Startpunkt);
  #local EndpunktS = StartpunktS + (Richtung-Startpunkt)*4/10;

  #local EndpunktS1 =vaxis_rotate(EndpunktS-StartpunktS,rotate_Axis,60+(rand(Libelle_Adern_Random)*5-2.5))+StartpunktS;
  Libelle_Adern_Ast(StartpunktS,EndpunktS1,-1,0)
  
  #local EndpunktS1 =vaxis_rotate(EndpunktS-StartpunktS,rotate_Axis,-60-(rand(Libelle_Adern_Random)*5-2.5))+StartpunktS;
  Libelle_Adern_Ast(StartpunktS,EndpunktS1,1,0)
  
  #local StartpunktS = Startpunkt+(Richtung-Startpunkt);
  #local EndpunktS = StartpunktS + (Richtung-Startpunkt)*4/10;

  #local EndpunktS1 =vaxis_rotate(EndpunktS-StartpunktS,rotate_Axis,25+(rand(Libelle_Adern_Random)*5-2.5))+StartpunktS;
  Libelle_Adern_Ast(StartpunktS,EndpunktS1,-1,0)
  
  #local EndpunktS1 =vaxis_rotate(EndpunktS-StartpunktS,rotate_Axis,-25-(rand(Libelle_Adern_Random)*5-2.5))+StartpunktS;
  Libelle_Adern_Ast(StartpunktS,EndpunktS1,1,0)
  
#end

#macro Libelle_Adern(Startpunkt,Richtung,Biegung,Recursion)
 #local Endpunkt = Startpunkt+(Richtung-Startpunkt)*(rand(Libelle_Adern_Random)/2+0.5);
  Libelle_Bogen(Startpunkt,Endpunkt,Biegung,1, Libelle_Ader_Dicke*pow(3/4,Recursion),10)
 
 #if(Recursion<9)
  #local EndpunktS = Endpunkt + (Richtung-Startpunkt)*5/6;
  
  #local EndpunktS1 =vaxis_rotate(EndpunktS-Endpunkt,rotate_Axis,Libelle_Adern_Bogen+(rand(Libelle_Adern_Random)*5-2.5))+Endpunkt;
  Libelle_Adern_Ast(Endpunkt,EndpunktS1,-1,Recursion)
  
  #local EndpunktS1 =vaxis_rotate(EndpunktS-Endpunkt,rotate_Axis,-Libelle_Adern_Bogen-(rand(Libelle_Adern_Random)*5-2.5))+Endpunkt;
  Libelle_Adern_Ast(Endpunkt,EndpunktS1,1,Recursion)
 #end 
#end

#macro Libelle_Adern_Ast(Endpunkt,EndpunktS1,Biegung,Recursion)
  #if(vlength(EndpunktS1)<1)
   Libelle_Adern(Endpunkt,EndpunktS1,Biegung,Recursion+1)
  #else
   #local EndpunktS1s = EndpunktS1/vlength(EndpunktS1);
   cylinder{Endpunkt,EndpunktS1s Libelle_Ader_Dicke/pow(2,Recursion)  }
  #end
#end

//-Texture Libellenkrper------------------------------------------------------------------------------------------------------------------------------
#declare Libelle_Koerper_Texture =
texture
{
 pigment
 {
  bozo//gradient z
  color_map
  {
   [0.01  color rgb<1,0.5,0>]
   [0.9 color rgb<0,1,1> ]
  }
 }
 finish
 {
  //ambient 0.25
  brilliance 3
  diffuse 0.7
  metallic
  specular 0.80
  roughness 1/80
  reflection 0.2
 }

 //scale 0.16+0.2+1.4 
 //translate -0.16-0.2
}
//Body-------------------------------------------------------------------------------------------------------------------------------------------------------
#declare Libelle_Auge =
sphere
{<0,0,0>,0.07 //scale<0.4,1,0.8> 
 texture
 {
  pigment{color rgbf<0.1,0,0.05,0.3>}
  finish
  {
   specular 1
   roughness 0.001
   ambient 0
   diffuse 0.3
   reflection 0.2
  }   

 } 
}
#declare Libelle_Kopf =
union
{
 sphere{<0,0,0>,0.08 scale<1.4,1,1>}
 object{Libelle_Auge translate<0.065,0.035,-0.001>}
 object{Libelle_Auge translate<-0.065,0.035,-0.001>}
}

#local Cone_Array= array[15]

#local Cone_Array[0]  = 0.02;
#local Cone_Array[1]  = 0.02;
#local Cone_Array[2]  = 0.05;
#local Cone_Array[3]  = 0.07;
#local Cone_Array[4]  = 0.07;
#local Cone_Array[5]  = 0.06;
#local Cone_Array[6]  = 0.04;
#local Cone_Array[7]  = 0.045;
#local Cone_Array[8]  = 0.056;
#local Cone_Array[9]  = 0.06;
#local Cone_Array[10] = 0.06;
#local Cone_Array[11] = 0.05;
#local Cone_Array[12] = 0.04;
#local Cone_Array[13] = 0.03;
#local Cone_Array[14] = 0.03;

#local Cone_Arraya= array[21]

#local Cone_Arraya[7]  = 0.036;
#local Cone_Arraya[8]  = 0.03;
#local Cone_Arraya[9]  = 0.025;
#local Cone_Arraya[10] = 0.027;
#local Cone_Arraya[11] = 0.03;
#local Cone_Arraya[12] = 0.033;
#local Cone_Arraya[13] = 0.033;
#local Cone_Arraya[14] = 0.03;
#local Cone_Arraya[15] = 0.029;
#local Cone_Arraya[16] = 0.027;
#local Cone_Arraya[17] = 0.025;
#local Cone_Arraya[18] = 0.022;
#local Cone_Arraya[19] = 0.018;
#local Cone_Arraya[20] = 0.015;
#declare Libelle_Rumpf =
union
{
 lathe
 {
  cubic_spline
  14
  #local Counter = 0;
  #while(Counter<14)
   ,<Cone_Array[Counter],1.4/(20*2)*Counter>
   #local Counter = Counter+1;
  #end 
  //pigment {Red}
  rotate<90,0,0>
  translate<0,0,-0.2-1.4/20>
 }
 #local Counter = 7;
 #local Translate = -0.2+1.4/20*5;
 #while(Counter<20)
  cone{<0,0,Translate>,Cone_Arraya[Counter],<0,0,Translate+1.4/20>,Cone_Arraya[Counter+1] texture{Libelle_Koerper_Texture} }
  #local Counter = Counter+1;
  #local Translate = Translate+1.4/20;
 #end
 sphere{<0,0,Translate>,0.015} 
}

#declare Libelle_Koerper =
union
{
 object{Libelle_Kopf translate<0,0,-0.08+-0.2>}
 object{Libelle_Rumpf}
 texture{Libelle_Koerper_Texture}
}
//------------------------------------------------------------------------------------------------------------
#declare I_Libelle =
interior
{
 ior 1.5
}
//Wings------------------------------------------------------------------------------------------------------------
#declare Libelle_Fluegel_Shape_1o =
union
{
 #declare rotate_Axis = vcross(<-4,0,0>,<0,0,4>);
 #declare Libelle_Adern_Random = seed(7);
 #declare Libelle_Adern_Bogen = 38 ;
 #declare Libelle_Ader_Dicke = 0.01;
 
 torus{1,0.001  }
 union{Libelle_Adern_Start(<-1,0,0>,<0,0,0>)}
 cylinder{<0,-0.0005,0><0,0.0005,0> 1 texture{Libelle_Fluegel_Texture} }
 translate<1,0,0>
 texture{Libelle_Ader_Texture scale 2}
 scale <1,1,0.3>
 rotate<0,20,0>
}  
#declare Libelle_Fluegel_Shape_2o =
union
{
 #declare rotate_Axis = vcross(<-4,0,0>,<0,0,4>);
 #declare Libelle_Adern_Random = seed(13);
 #declare Libelle_Adern_Bogen = 38 ;
 #declare Libelle_Ader_Dicke = 0.01;

 torus{1,0.001  }
 union{Libelle_Adern_Start(<1,0,0>,<0,0,0>)}
 cylinder{<0,-0.0005,0><0,0.0005,0> 1 texture{Libelle_Fluegel_Texture} }
 translate<-1,0,0>
 texture{Libelle_Ader_Texture scale 2}
 scale <1,1,0.3>
 rotate<0,-20,0>
}  
#declare Libelle_Fluegel_Shape_1u =
union
{
 #declare rotate_Axis = vcross(<-4,0,0>,<0,0,4>);
 #declare Libelle_Adern_Random = seed(5);
 #declare Libelle_Adern_Bogen = 38 ;
 #declare Libelle_Ader_Dicke = 0.01;

 torus{1,0.001 }
 union{Libelle_Adern_Start(<-1,0,0>,<0,0,0>)}
 cylinder{<0,-0.0005,0><0,0.0005,0> 1 texture{Libelle_Fluegel_Texture} }
 translate<1,0,0>
 texture{Libelle_Ader_Texture scale 2} 
 scale <0.7,1,0.25>
 rotate<0,-20,0>
}  
#declare Libelle_Fluegel_Shape_2u =
union
{
 #declare rotate_Axis = vcross(<-4,0,0>,<0,0,4>);
 #declare Libelle_Adern_Random = seed(23);
 #declare Libelle_Adern_Bogen = 38 ;
 #declare Libelle_Ader_Dicke = 0.01;

 torus{1,0.001 }
 union{Libelle_Adern_Start(<1,0,0>,<0,0,0>)}
 cylinder{<0,-0.0005,0><0,0.0005,0> 1 texture{Libelle_Fluegel_Texture} }
 translate<-1,0,0>
 texture{Libelle_Ader_Texture scale 2}
 scale <0.7,1,0.25>
 rotate<0,20,0>
}  

//---Dragonfly------------------------------------------------------------------------------------------------------------
#macro Libelle(Fluegel_Schlago,Fluegel_Schlagu)
union
{
 object{Libelle_Koerper}
 object{Libelle_Fluegel_Shape_1o rotate<0,0, Fluegel_Schlago > translate<0.04,0.01,-0.01>}
 object{Libelle_Fluegel_Shape_2o rotate<0,0,-Fluegel_Schlago > translate<-0.04,0.01,-0.01>}
 object{Libelle_Fluegel_Shape_1u rotate<0,0, Fluegel_Schlagu > translate<0.04,-0.03,0>}
 object{Libelle_Fluegel_Shape_2u rotate<0,0,-Fluegel_Schlagu > translate<-0.04,-0.03,0>}
}
#end
//------------------------------------------------------------------------------------------------------------
