//@--------Include Files----------------------------------------------------------

#include "colors.inc"
//#include "shapes2.inc"
#include "metals.inc"

#declare Axes  = 0 ;
#declare Final = 1 ;
#declare Flare = 0 ;
#declare Sun   = 1 ;

#declare FireSeed = seed(44);
#declare TurnSeed = seed(6);

//@--------Camera-----------------------------------------------------------------

#declare CamPos = < 16, 4.4,-10.25>;
#declare CamLook = < 6, 1, 0>;

camera{
  location  CamPos
  look_at   CamLook
}
#if (Final)
  //  SODONOTHING
#else
  light_source{ CamPos + < 0, 10, 0> White }
#end

//@--------Lighting---------------------------------------------------------------



//@--------Textures---------------------------------------------------------------

#declare BrickClr   = color rgb< .230, .130, .000>;
#declare MortarClr  = color rgb< .600, .580, .540>;
#declare LightClr   = color rgb< 1.00, 1.00, .500>*.75;

#declare GroundTex  = texture{ pigment{ Gray10 } }
#declare StarWidth  = 0.050;
#declare SpaceWidth = 0.200-StarWidth;
#declare StarPig =
pigment{
  granite
  color_map{
    [ 0.000 0.250 color rgb < 0, 0, 0> color rgb < 0, 0, 0> ]
    [ 0.250 0.300 color rgb <.5,.5,.4> color rgb <.8,.8,.4> ]
    [ 0.300 0.450 color rgb < 0, 0, 0> color rgb < 0, 0, 0> ]
    [ 0.450 0.500 color rgb <.4,.4,.5> color rgb <.4,.4,.8> ]
    [ 0.500 0.650 color rgb < 0, 0, 0> color rgb < 0, 0, 0> ]
    [ 0.650 0.700 color rgb <.5,.4,.4> color rgb <.8,.4,.4> ]
    [ 0.700 0.850 color rgb < 0, 0, 0> color rgb < 0, 0, 0> ]
    [ 0.850 0.900 color rgb <.5,.5,.5> color rgb < 1, 1, 1> ]
    [ 0.900 1.000 color rgb < 0, 0, 0> color rgb < 0, 0, 0> ]
  }
  turbulence 1
  sine_wave
  scale .075
}
#if (Final)

  #declare CloudPig =
  pigment{
    bozo
    turbulence 0.65
    color_map{
        [0.0 0.1 color rgb(0.65*< 1, 1, 1>)  color rgb(0.55*< 1, 1, 1>)]
        [0.1 0.5 color rgb(0.55*< 1, 1, 1>)  color rgbt < 1, 1, 1, 1>]
        [0.5 1.0 color rgbt < 1, 1, 1, 1>    color rgbt < 1, 1, 1, 1>]
    }
    scale .1
    scale <3,1,3>
  }
  #declare WallTex =
  texture{
    pigment{
      brick MortarClr, BrickClr
      scale .05
      mortar .25
    }
  }
  #declare FramePig = pigment{ VeryDarkBrown }

  #declare WindowTex =
  texture{
    pigment{ SlateBlue }
      finish {
        ambient 0
        diffuse .1
        reflection .25
        refraction 1
        ior 1.33
        specular 1
        roughness .001
     }
  }
  #declare ParapetTex =
  texture{
    pigment{ Gray25 }
  }

  #declare CarTex =
  texture{
    pigment{ color rgb< 0, 0, .5> }
    finish{ F_MetalB }
  }

  #declare StreetlightTex =
  texture{
    pigment{ LightClr }
    finish{
      ambient 1
      diffuse 0
    }
  }
  #declare LaserTex1 =
  texture{
    pigment{ color rgbf< 1, 0, 0, .75> }
    finish{
      ambient 1
      diffuse 0
    }
  }
  #declare LaserTex2 =
  texture{
    pigment{ color rgbf< 1, 0, 0, 0> }
    finish{
      ambient 1
      diffuse 0
    }
  }

#else

  #declare LaserTex1 =
  texture{
    pigment{ color rgbf< 1, 0, 0, .9> }
    finish{
      ambient 1
      diffuse 0
    }
  }
  #declare LaserTex2 =
  texture{
    pigment{ color rgbf< 1, 0, 0, 0> }
    finish{
      ambient 1
      diffuse 0
    }
  }
  #declare CloudPig = pigment{ Invisible }
  #declare BrickClr = color rgb< .23, .13, 0>;
  #declare MortarClr = color rgb< .6, .58, .54>;
  #declare WallTex = texture{ pigment{ BrickClr } }
  #declare FramePig = pigment{ VeryDarkBrown }
  #declare WindowTex = texture{ pigment{ color rgb < 0, 0, .25> } }
  #declare ParapetTex = texture{ pigment{ Gray25 } }
  #declare CarTex = texture{ pigment{ Blue } }
  #declare StreetlightTex = texture{ pigment{ LightClr } }

#end

//@--------Object Declares--------------------------------------------------------

#declare Streetlight =
union{
  union{
    union{
      cylinder{ < 0, 0, 0>, < 0, 1, 0>, .15 }
      cylinder{ < 0, 1, 0>, < 0, 3, 0>, .075 }
      intersection{
        torus{
          1, .075
          rotate < 0, 0, 90>
          translate < 0, 3,-1>
        }
        box{ <-1, 3,-1>, < 1, 5, 2> }
      }
      cylinder{ < 0, 4,-1>, < 0, 4,-2>, .075 }
      difference{
        union{
          sphere{ < 0, 3.9,-1.5>, .15 }
          cylinder{ < 0, 3.9,-1.5>, < 0, 3.9,-2>, .15 }
          sphere{ < 0, 3.9,-2>, .15 }
        }
        plane{ y, 3.9 }
      }
      union{
        torus{
          .15, .025
          translate < 0, 3.9,-1.5>
        }
        torus{
          .15, .025
          translate < 0, 3.9,-2>
        }
        cylinder{ <-.15, 3.9,-1.5>, <-.15, 3.9,-2>, .025 }
        cylinder{ < .15, 3.9,-1.5>, < .15, 3.9,-2>, .025 }
      }
      texture{ T_Chrome_2A }
    }
    difference{
      union{
        sphere{ < 0, 3.9,-1.5>, .15 }
        cylinder{ < 0, 3.9,-1.5>, < 0, 3.9,-2>, .15 }
        sphere{ < 0, 3.9,-2>, .15 }
      }
      plane{-y,-3.9 }
      texture{ StreetlightTex }
    }
    scale .85
  }
  #if (Final)
    light_source{
      < 0, 3.187,-1.487>
      LightClr
      spotlight
      point_at < 0, 0,-1.487>
      radius 30
      falloff 40
      fade_distance 4
      fade_power 1
    }
    light_source{
      < 0, 3.187,-1.487>
      LightClr*.125
    }
  #end
}
#declare FireB =
sphere{ 0, 1
  pigment{ Invisible }
  interior{
    media{
      emission rgb< 1, .5, 0>
      density{
        spherical
        color_map{
          [ 0.0 color rgbt < 1, 0, 0, 1> ]
          [ 0.5 color rgbt < 1, 1, 0, 1> ]
          [ 1.0 color rgbt < 1, 0, 0, 1> ]
        }
        turbulence .5+(rand(FireSeed)/10)
      }
      //intervals 2
      //samples 15,20
      scale 0.5
    }
  }
  no_shadow
  hollow
  rotate < 90*rand(TurnSeed), 90*rand(TurnSeed), 90*rand(TurnSeed)>
  scale 2
  translate <-1, 4,-1>
}
#declare FireC = object{ FireB }/*
sphere{ 0, 1
  pigment{ Invisible }
  halo{
    emitting
    spherical_mapping
    linear
    turbulence .5+(rand(FireSeed)/10)
    color_map{
      [ 0.0 color rgbt <1, 0, 0,  1> ]
      [ 0.5 color rgbt <1, 1, 0, -1> ]
      [ 1.0 color rgbt <1, 0, 0,  1> ]
    }
    frequency 2
    samples 20
    scale 0.5
  }
  no_shadow
  hollow
  rotate < 90*rand(TurnSeed), 90*rand(TurnSeed), 90*rand(TurnSeed)>
  scale 2
  translate < 1, 3,-1>
}*/
#declare FireD = object{ FireB }/*
sphere{ 0, 1
  pigment{ Invisible }
  halo{
    emitting
    spherical_mapping
    linear
    turbulence .5+(rand(FireSeed)/10)
    color_map{
      [ 0.0 color rgbt <1, 0, 0,  1> ]
      [ 0.5 color rgbt <1, 1, 0, -1> ]
      [ 1.0 color rgbt <1, 0, 0,  1> ]
    }
    frequency 2
    samples 20
    scale 0.5
  }
  no_shadow
  hollow
  rotate < 90*rand(TurnSeed), 90*rand(TurnSeed), 90*rand(TurnSeed)>
  scale 2
  translate <-1, 3,-1>
}*/
#declare HouseA =
union{
  difference{  //  walls
    box{ <-2, 0,-2>, < 2, 3.8, 2> }

    box{ <-(5/3), (1/3),-3>, <-(2/3), (4/3),-1> }
    box{ <-(1/3), 0,-3>, < (1/3), (4/3),-1> }
    box{ < (5/3), (1/3),-3>, < (2/3), (4/3),-1> }

    box{ <-(5/3), 2,-3>, <-(1/6), 3,-1> }
    box{ < (5/3), 2,-3>, < (1/6), 3,-1> }
    texture{ WallTex }
  }
  union{  //  window frames
    difference{
      box{ <-(10/6), (2/6),-2>, <-(4/6), (8/6),-1> }
      box{ <-(19/12), (5/12),-3>, <-(9/12), (11/12),-1> }
      box{ <-(19/12), (12/12),-3>, <-(9/12), (15/12),-1> }
    }
    difference{
      box{ < (10/6), (2/6),-2>, < (4/6), (8/6),-1> }
      box{ < (19/12), (5/12),-3>, < (9/12), (11/12),-1> }
      box{ < (19/12), (12/12),-3>, < (9/12), (15/12),-1> }
    }
    difference{
      box{ <-(5/3), 2,-2>, <-(1/6), 3,-1> }
      box{ <-(19/12), (25/12),-3>, <-(3/12), (31/12),-1> }
      box{ <-(19/12), (32/12),-3>, <-(12/12), (35/12),-1> }
      box{ <-(11/12), (32/12),-3>, <-(3/12), (35/12),-1> }
    }
    difference{
      box{ < (5/3), 2,-2>, < (1/6), 3,-1> }
      box{ < (19/12), (25/12),-3>, < (3/12), (31/12),-1> }
      box{ < (19/12), (32/12),-3>, < (12/12), (35/12),-1> }
      box{ < (11/12), (32/12),-3>, < (3/12), (35/12),-1> }
    }
    pigment{ FramePig }
  }
  union{  //  windows
    box{ <-(5/3), (1/3),-1.9>, <-(2/3), (4/3),-1> }
    box{ < (5/3), (1/3),-1.9>, < (2/3), (4/3),-1> }

    box{ <-(5/3), 2,-1.9>, <-(1/6), 3,-1> }
    box{ < (5/3), 2,-1.9>, < (1/6), 3,-1> }
    texture{ WindowTex }
  }
  union{  //  door
    difference{
      box{ <-(1/3), 0,-2>, < (1/3), (4/3),-1> }
      box{ <-(3/12),-1,-3>, < (3/12), (15/12),-1> }
      pigment{ FramePig }
    }
    box{ <-(3/12), 0,-2>, < (3/12), (15/12),-1> pigment{ DarkWood } }
    union{
      sphere{ <-(2/12), (8/12),-(24/12)>, (1/24) }
      box{ < 0, (7/12),-(24/12)>, < (2/12), (8/12),-(25/12)> }
      pigment{ Gold }
    }
  }
  difference{
    box{ <-2.05, 3.75,-2.05>, < 2.05, 4, 2.05> }
    box{ <-1.95, 3.81,-1.95>, < 1.95, 5, 1.95> }
    texture{ ParapetTex }
  }
}
#declare HouseB =
union{
difference{
  object{ HouseA }
  union{
    box{
      -1, 1
      scale .75
      rotate < 90*rand(TurnSeed), 90*rand(TurnSeed), 90*rand(TurnSeed)>
      translate <-2, 3,-2>
    }
    box{
      -1, 1
      scale .75
      rotate < 90*rand(TurnSeed), 90*rand(TurnSeed), 90*rand(TurnSeed)>
      translate <-2, 3,-2>
    }

    box{
      -1, 1
      scale .5
      rotate < 90*rand(TurnSeed), 90*rand(TurnSeed), 90*rand(TurnSeed)>
      translate <-1, 4,-2>
    }
    box{
      -1, 1
      scale .5
      rotate < 90*rand(TurnSeed), 90*rand(TurnSeed), 90*rand(TurnSeed)>
      translate < 0, 4,-2>
    }
    box{
      -1, 1
      scale .5
     rotate < 90*rand(TurnSeed), 90*rand(TurnSeed), 90*rand(TurnSeed)>
      translate < 1, 4,-2>
    }
    pigment{ BrickClr*.25 }
  }
}
//object{ FireB }
}
#declare HouseC =
union{
difference{
  object{ HouseA }
  union{
    plane{ -y, -3 }
    box{
      -1, 1
      scale .75
      rotate < 90*rand(TurnSeed), 90*rand(TurnSeed), 90*rand(TurnSeed)>
      translate <-2, 2,-2>
    }
    box{
      -1, 1
      scale .75
      rotate < 90*rand(TurnSeed), 90*rand(TurnSeed), 90*rand(TurnSeed)>
      translate <-2, 2,-2>
    }

    box{
      -1, 1
      scale .75
      rotate < 90*rand(TurnSeed), 90*rand(TurnSeed), 90*rand(TurnSeed)>
      translate < 2, 2,-2>
    }
    box{
      -1, 1
      scale .75
      rotate < 90*rand(TurnSeed), 90*rand(TurnSeed), 90*rand(TurnSeed)>
      translate < 2, 2,-2>
    }

    box{
      -1, 1
      scale .5
      rotate < 90*rand(TurnSeed), 90*rand(TurnSeed), 90*rand(TurnSeed)>
      translate <-1, 3,-2>
    }
    box{
      -1, 1
      scale .5
      rotate < 90*rand(TurnSeed), 90*rand(TurnSeed), 90*rand(TurnSeed)>
      translate < 0, 3,-2>
    }
    box{
      -1, 1
      scale .5
     rotate < 90*rand(TurnSeed), 90*rand(TurnSeed), 90*rand(TurnSeed)>
      translate < 1, 3,-2>
    }
    pigment{ BrickClr*.25 }
  }
}
//object{ FireC }
}
#declare HouseD =
union{
difference{
  object{ HouseA }
  union{
    plane{ -y, -3 }
    box{
      -1, 1
      scale .75
      rotate < 90*rand(TurnSeed), 90*rand(TurnSeed), 90*rand(TurnSeed)>
      translate <-2, 2,-2>
    }
    box{
      -1, 1
      scale .75
      rotate < 90*rand(TurnSeed), 90*rand(TurnSeed), 90*rand(TurnSeed)>
      translate <-2, 2,-2>
    }

    box{
      -1, 1
      scale .75
      rotate < 90*rand(TurnSeed), 90*rand(TurnSeed), 90*rand(TurnSeed)>
      translate < 2, 2,-2>
    }
    box{
      -1, 1
      scale .75
      rotate < 90*rand(TurnSeed), 90*rand(TurnSeed), 90*rand(TurnSeed)>
      translate < 2, 2,-2>
    }

    box{
      -1, 1
      scale .5
      rotate < 90*rand(TurnSeed), 90*rand(TurnSeed), 90*rand(TurnSeed)>
      translate <-1, 3,-2>
    }
    box{
      -1, 1
      scale .5
      rotate < 90*rand(TurnSeed), 90*rand(TurnSeed), 90*rand(TurnSeed)>
      translate < 0, 3,-2>
    }
    box{
      -1, 1
      scale .5
     rotate < 90*rand(TurnSeed), 90*rand(TurnSeed), 90*rand(TurnSeed)>
      translate < 1, 3,-2>
    }
    pigment{ BrickClr*.25 }
  }
}
//object{ FireD }
}

#declare Car =
union{
  difference{
    difference{
      box{ <-1, .25,-.5>, < 1, .5, .5> }
      plane{ <-3,-2, 0>,-.6 }
      plane{ < 3,-2, 0>,-.6 }
      plane{ < 0,-2, 3>,-.6 }
      plane{ < 0,-2,-3>,-.6 }
    }
    difference{
      union{
        difference{
          box{ <-1, .25,-.5>, < 1, .45, .5> }
          plane{ <-3,-2, 0>,-.5 }
          plane{ < 3,-2, 0>,-.5 }
        }
        difference{
          box{ <-1, .25,-.5>, < 1, .45, .5> }
          plane{ < 0,-2, 3>,-.5 }
          plane{ < 0,-2,-3>,-.5 }
        }
      }
      box{ <-.05, 0,-1>, < .05, 1, 1> }
    }
    texture{ CarTex }
  }
  intersection{
    difference{
      box{ <-1, .2,-.5>, < 1, .5, .5> }
      plane{ <-3,-2, 0>,-.6 }
      plane{ < 3,-2, 0>,-.6 }
      plane{ < 0,-2, 3>,-.6 }
      plane{ < 0,-2,-3>,-.6 }
    }
    difference{
      union{
        difference{
          box{ <-1, .2,-.5>, < 1, .45, .5> }
          plane{ <-3,-2, 0>,-.5 }
          plane{ < 3,-2, 0>,-.5 }
        }
        difference{
          box{ <-1, .2,-.5>, < 1, .45, .5> }
          plane{ < 0,-2, 3>,-.5 }
          plane{ < 0,-2,-3>,-.5 }
        }
      }
      box{ <-.05, 0,-1>, < .05, 1, 1> }
    }
    texture{ WindowTex }
  }
  difference{
    box{ <-1, 0,-.5>, < 1, .25, .5> }
    cylinder{ <-.5, 0,-1>, <-.5, 0, 1>, .15 }
    cylinder{ < .6, 0,-1>, < .6, 0, 1>, .15 }
    texture{ CarTex }
  }
  difference{
    box{ < 1, 0,-.5>, < 1.1, .25, .5> }
    cylinder{ < 0, .125,-.25>, < 2, .125,-.25>, .05 }
    cylinder{ < 0, .125, .25>, < 2, .125, .25>, .05 }
    texture{ T_Chrome_2E }
  }
  union{
    cylinder{ < 1, .125,-.25>, < 1.1, .125,-.25>, .05 }
    cylinder{ < 1, .125, .25>, < 1.1, .125, .25>, .05 }
    pigment{ White }
  }
  union{
    cylinder{ <-.5, 0,-.5>, <-.5, 0, .5>, .15 pigment{ Black } }
    cylinder{ < .6, 0,-.5>, < .6, 0, .5>, .15 pigment{ Black } }
    cylinder{ <-.5, 0,-.51>, <-.5, 0, .51>, .075 texture{ T_Chrome_2A } }
    cylinder{ < .6, 0,-.51>, < .6, 0, .51>, .075 texture{ T_Chrome_2A } }
    finish{
      phong .5
      phong_size 50
    }
  }
  translate < 12, .15,-4>
}

//@--------Object Assembly--------------------------------------------------------

#declare Sidewalk =
union{
  box{ <-3, 0,-3>, < 25, (1/12), 3> }
  box{ <-3, 0,-9>, < 25, (1/12), -15> }
  box{ <-9, 0,-7>, <-14, (1/12), 15> }
  pigment{ Gray50 }
}
#declare Row1 =
union{
  object{
    HouseC
    translate < 0, 0, 0>
  }
  object{
    HouseB
    translate < 4, 0, 0>
  }
  object{
    HouseA
    translate < 8, 0, 0>
  }
  object{
    HouseA
    translate < 12, 0, 0>
  }
  object{
    HouseA
    translate < 16, 0, 0>
  }
}
#declare Row2 =
union{
  object{
    HouseA
    translate < 0, 0, 0>
  }
  object{
    HouseA
    translate <-4, 0, 0>
  }
  object{
    HouseA
    translate <-8, 0, 0>
  }
  object{
    HouseA
    translate <-12, 0, 0>
  }
  object{
    HouseA
    translate <-16, 0, 0>
  }
  object{
    HouseA
    translate <-20, 0, 0>
  }
  object{
    HouseA
    translate <-24, 0, 0>
  }
  rotate 180*y
  translate < 0, 0,-12>
}
#declare Row3 =
union{
  object{
    HouseD
    translate < 0, 0, 0>
  }
  object{
    HouseC
    translate <-4, 0, 0>
  }
  object{
    HouseD
    translate <-8, 0, 0>
  }
  object{
    HouseC
    translate <-12, 0, 0>
  }
  object{
    HouseD
    translate <-16, 0, 0>
  }
  rotate 270*y
  translate <-12, 0, 12>
}
#declare Wall =
box{
  <-15, 0,-7>, <-12, 3.75, 15>
  texture{ WallTex }
}
#declare Streetlights =
union{
  object{
    Streetlight
    translate < 2, 0, 0>
  }
  object{
    Streetlight
    translate < 6, 0, 0>
  }
  object{
    Streetlight
    translate < 10, 0, 0>
  }
  object{
    Streetlight
    translate < 14, 0, 0>
  }
  object{
    Streetlight
    translate < 18, 0, 0>
  }
  object{
    Streetlight
    translate < 22, 0, 0>
  }
}
#declare Streetlights1 =
object{
  Streetlights
  translate < 0, 0,-2.2>
}
#declare Streetlights2 =
object{
  Streetlights
  rotate 180*y
  translate < 24, 0,-11.2>
}
#declare Streetlights3 =
object{
  Streetlights
  rotate 270*y
  translate <-9.8, 0,-8>
}

#declare SpiderBeams =
union{
  union{
    cylinder{ < .1, 0,-.1>, < 10, 0,-.1>, .01 }
    cylinder{ < .1, 0, .1>, < 10, 0, .1>, .01 }
    texture{ LaserTex2 }
  }
  union{
    cylinder{ < 0, 0,-.1>, < 10, 0,-.1>, .05 }
    cylinder{ < 0, 0, .1>, < 10, 0, .1>, .05 }
    texture{ LaserTex1 }
  }
  no_shadow
  translate < 1.25, 2.125, 0>
}
#declare AntBeams =
union{
  union{
    cylinder{ < .1, 0,-.2>, < 100, 0,-.2>, .02 }
    cylinder{ < .1, 0, .2>, < 100, 0, .2>, .02 }
    texture{ LaserTex2 }
  }
  union{
    cylinder{ < 0, 0,-.2>, < 100, 0,-.2>, .1 }
    cylinder{ < 0, 0, .2>, < 100, 0, .2>, .1 }
    texture{ LaserTex1 }
  }
  no_shadow
  translate < 3, 3.75, 0>
}

#declare RobotPaint1Tex =
texture{
  pigment{ Black }
}
#declare RobotPaint2Tex =
texture{
  pigment{ Red }
}
#declare RobotMetalTex =
texture{
  T_Chrome_2A
}
#declare RobotEyeTex =
texture{
  pigment{ color rgbf < .85, .85, 1, .25> }
}
#include "GKinfest.inc"
#declare Spider =
union{
  object{ RobotSpider }
  union{
    object{ laser_RobotSpider }
    object{ SpiderBeams }
    rotate 320*y
  }
  translate < 0, 0,-5>
}                 
#declare NormalAnt =
object{
  RobotAnt
  scale (1/10)
}
#declare NormalBeetle =
union{
  RobotBeetle
  scale (1/5)
}
#declare NormalBeetle_buzzsaw =
union{
  RobotBeetle_buzzsaw
  scale (1/5)
}

#declare RoofAnt1 =
object{
  RobotAnt
  scale (1/80)
}
#declare RoofAnt2 =
object{
  RoofAnt1
  rotate< 0, 0, 15>
}
#declare LaserAnt1 =
union{
  object{ RobotAnt }
  union{
    object{ laser_RobotAnt }
    object{ AntBeams }
    rotate 010*y
  }
  scale (1/10)
}
#declare LaserAnt2 =
union{
  object{ RobotAnt }
  union{
    object{ laser_RobotAnt }
    object{ AntBeams }
    rotate 350*y
  }
  scale (1/10)
}
#declare LaserAnt3 =
union{
  object{ RobotAnt }
  union{
    object{ laser_RobotAnt }
    object{ AntBeams }
    rotate 000*y
  }
  scale (1/10)
}                 
#declare RearingAnt =
object{
  NormalAnt
  rotate< 0, 0, 15>
}
#declare WallAnt =
object{
  NormalAnt
  scale (5/12)
  rotate 270*x
  translate -2*z
}
#declare WallBeetle =
object{
  NormalBeetle
  scale (2/3)
  rotate 270*x
  translate -2*z
}
#declare WallBeetle_buzzsaw =
object{
  NormalBeetle_buzzsaw
  scale (2/3)
  rotate 270*x
  translate -2*z
}
#declare Ground_Ants =
union{
  object{ NormalAnt  rotate 020*y translate < 04, 0,-6> }
  object{ NormalAnt  rotate 015*y translate < 06, 0,-5> }
  object{ RearingAnt rotate 260*y translate < 13, 0,-5.25> }
  object{ LaserAnt3  rotate 090*y translate < 06.75, 0,-6.5> }
  
  object{ NormalAnt  rotate 290*y translate < 07, (1/12),-3> }
  object{ LaserAnt1  rotate 015*y translate < 09, 0,-4.5> }
  object{ LaserAnt2  rotate 015*y translate < 10, 0,-7> }
  object{ NormalAnt  rotate 340*y translate < 14.5, 0,-4> }
}
#declare Wall_Ants =
union{
  object{ WallAnt rotate 030*z translate < 06.00, 2.0, 0> }
  object{ WallAnt rotate 020*z translate < 07.25, 3.0, 0> }
  object{ WallAnt rotate 015*z translate < 09.00, 1.0, 0> }
  
  object{ WallAnt rotate 010*z translate < 10.50, 2.0, 0> }
  object{ WallAnt rotate 005*z translate < 12.00, 1.0, 0> }
  object{ WallAnt rotate 025*z translate < 13.25, 3.0, 0> }
}
#declare Ground_Beetles =
union{
  object{ NormalBeetle rotate 025*y translate < 08, 0,-5> }
  object{ NormalBeetle rotate 030*y translate < 11, 0,-6> }
  object{ NormalBeetle rotate 045*y translate < 09, 0,-6> }
  
  object{ NormalBeetle rotate 035*y translate < 10.5, 0,-8> }
  object{ NormalBeetle rotate 330*y translate < 13.5, (1/12),-2.5> }
  object{ NormalBeetle_buzzsaw rotate 345*y translate < 12, .65,-4> }
}
#declare Wall_Beetles =
union{
  object{ WallBeetle_buzzsaw rotate 330*z translate < 8.00, 2.5, 0> }
  object{ WallBeetle_buzzsaw rotate 340*z translate < 12.5, 2.0, 0> }
  
  object{ WallBeetle rotate 030*z translate < 9.25, 3.0, 0> }
  object{ WallBeetle rotate 020*z translate < 14.0, 1.5, 0> }
}
#declare Roof_Ants =
union{
  object{ RoofAnt1 rotate 000*y translate < 15.25, 4,-10> }
  object{ RoofAnt2 rotate 022*y translate < 15.5, 4,-10> }
}

//@--------Objects----------------------------------------------------------------

object{ Row1 }
object{ Row2 }
object{ Row3 }

object{ Sidewalk }
object{ Wall }
object{ Streetlights1 }
object{ Streetlights2 }
object{ Streetlights3 }

object{ Car }

object{ Spider }
object{ Ground_Ants }
object{ Wall_Ants }
object{ Roof_Ants }
object{ Ground_Beetles }
object{ Wall_Beetles }

//@--------Environment------------------------------------------------------------

background{ White }

plane{
  y,0
  texture{ GroundTex }
}
difference{
  plane{ y,.01 }
  box{ <-16,-1,-12>, <24, 1,8> }
  pigment{ BrickClr }
}
sky_sphere{ pigment{ StarPig } pigment{ CloudPig } }

#if (Sun)
  #declare SunRot   = < 80,-17, 0>;
  #declare SunDist  = 1000*y;
  #declare SunSize  = 15;
  #declare SunPig   = pigment{ color rgb < 1, 1, 1> }
  #declare SunPos   = vrotate( SunDist,SunRot );

  union{
    light_source{ SunPos White }
    sphere{
      vrotate( SunDist+((SunSize+1)*y),SunRot ),SunSize
      pigment{ SunPig }
      finish{ ambient 1 diffuse 0 }
    }
  }
#end

#if (Flare)
  #declare cam_loc = CamPos;
  #declare light_loc = SunPos;
  #declare lookat = CamLook;
  #declare sky_vect = y;
  #include "camcordr.flr"
  #include "nkflare.inc"
#end

#if (Axes)
  union{
  /* x */ cylinder{ <-100, 0, 0>, < 100, 0, 0>, .1 pigment{ Red } finish{ ambient 1 diffuse 0 } }
  /* y */ cylinder{ < 0,-100, 0>, < 0, 100, 0>, .1 pigment{ Green } finish{ ambient 1 diffuse 0 } }
  /* z */ cylinder{ < 0, 0,-100>, < 0, 0, 100>, .1 pigment{ Blue } finish{ ambient 1 diffuse 0 } }
  }
#end

//@-------------------------------------------------------------------------------
