#include "colors.inc"
#include "textures.inc"
#include "stones.inc"
#include "glass.inc"
#include "woods.inc"          


#declare TextureBeer=
texture {
    finish {
    ambient 0.
    diffuse 0.1
    reflection 0.15
    specular 0.8
    roughness 0.01
    ior 1.33
    }  
    normal {ripples 0.2
            frequency 8
            scale 1 
            }
    pigment { rgbf <1, 0.9, 0.3, 0.95> }    
}

#declare TextureCoca=
texture {
    finish {
    ambient 0.
    diffuse 0.1
    reflection 0.15
    specular 0.8
    roughness 0.01
    ior 1.33
    }  
    normal {ripples 0.2
            frequency 8
            scale 1 
            }
    pigment { rgbf <0.65, 0.35, 0.3, 0.95> }    
}
          
#declare TextureBubble=
texture {
    finish {
    ambient 0
    diffuse 0
    reflection 0
    specular 0.8
    roughness 0.01
    ior 1
    }  
    pigment { rgbf <1, 1, 1, 1.1> }    
}
 
//********** verre **********************

#declare verre = difference {
   cone {0, 2.5, 7*y, 3}
   cone {0.3, 2.5, 7.3*y, 3}
   
   texture {
     finish {
       ambient 0.25
       diffuse 0.25
       reflection 0.2
       specular 1
       roughness 0.001  
       }
     pigment { color rgbf <1, 1, 1, 0.97> }
     }          
   interior {ior 1.5}
   }
 
 
 
 
//********** Bire **********************
 
#declare goutte1 = blob {
      sphere {0, 0.9, 1 scale <1.1, 1, 1>}
      sphere {-y, 0.9, 1 scale <1, 1.3, 1>}
      sphere {z, 0.9, 1 scale <1.2, 0.9, 1.2>}
      threshold 0.5  
      texture {TextureBeer}
      }

#declare tache1 = difference {
  blob {
    sphere {0, 0.7, 1}
    sphere {x, 0.7, 1}
    sphere {0, 1, 1 
            scale <1, 0.7, 1> 
            translate 1.2*x-0.9*z
            }
    threshold 0.2
    scale <1, 0.5, 1>
    texture {TextureBeer}
    }
  plane {y, 0.001
         texture {TextureBubble}
         }
  }
 
//********** Coca ***********************
 
#declare goutte2 = blob {
      sphere {0, 0.9, 1 scale <1.1, 1, 1>}
      sphere {-y, 0.9, 1 scale <1, 1.3, 1>}
      sphere {z, 0.9, 1 scale <1.2, 0.9, 1.2>}
      threshold 0.6  
      texture {TextureCoca}
      }

#declare tache2 = difference {
  blob {
    sphere {0, 0.7, 1}
    sphere {0.7*x-0.7*z, 0.7, 1}
    sphere {0, 1, 1 
            scale <1, 0.7, 1> 
            translate -1.2*x-0.9*z
            }
    threshold 0.2
    scale <1, 0.5, 1>
    texture {TextureCoca}
    }
  plane {y, 0.001
         texture {TextureBubble}
         }
  }
