// -----------------------   Mariposa   -----------------------------------
//
// ---------------- Javier Benavent Llin (2.001) -------------------------

#include "colors.inc"
#include "textures.inc"
#include "shapes.inc"
#include "metals.inc"
#include "glass.inc"
#include "skies.inc" 
#include "woods.inc"
#include "stones.inc"



camera {                    
   location <4, 15, -30>
   look_at <0, 11, 0> }
  
   
light_source { <10.1, 40, -50> color blue 1 red 1 green 1 }  
light_source { <10, 40.1, -50> color blue 1 red 1 green 1 }  
light_source { <10, 100, 50> color blue 1 red 1 green 1 }  




// Montaje Mariposa ==============================================================


#declare al= difference{
        sphere {<0, 0, 0> 1 scale <1, .001, 1.5> translate <-1, 0, 0>}
        sphere {<0, 0, 0> .1 scale <.8, 1, 5> translate <-2, 0, 0> rotate <0, 5, 0>}
        sphere {<0, 0, 0> .1 scale <1, 1, 5> translate <-2, 0, 0> rotate <0, -5, 0>}
        sphere {<0, 0, 0> .1 scale <1, 1, 5> translate <-2, 0, 0> rotate <0, -10, 0>}
        sphere {<0, 0, 0> .1 scale <1, 1, 5> translate <-2, 0, 0> rotate <0, -17, 0>}
        sphere {<0, 0, 0> .1 scale <1, 1, 4> translate <-2, 0, 0> rotate <0, -26, 0>}
        sphere {<0, 0, 0> .1 scale <1, 1, 3> translate <-2, 0, 0> rotate <0, -35, 0>}
        sphere {<0, 0, 0> .1 scale <1, 1, 2> translate <-2, 0, 0> rotate <0, -48, 0>}
        sphere {<0, 0, 0> .1 scale <1, 1, 3> translate <-2, 0, 0> rotate <0, -52, 0>}}                

#declare al2= intersection{
        object {al}
        sphere {<0, 0, 0> 1 rotate <0, 15, 0> translate <-1, 0, 0> scale <1.5, 1, .9>}}



#declare al1= intersection{
        object {al}
        sphere {<0, 0, 0> 1 scale <2, 1, .9> rotate <0, 240, 0>}}

#declare ala= union{
        object {al2}
        object {al scale <.7, 1, 1.1> rotate <0, 15, 0> translate <-.2, 0, -.8>}
        object {al1 scale <.7, 1, 1.1> rotate <0, 15, 0> translate <-.2, 0, -1.2>}
        object {al1 scale <.7, 1, 1.1> rotate <0, 15, 0> translate <-.5, 0, -1.5>}
        texture {White_Marble scale <1.4, 1, 3.5> normal {wrinkles 1 scale <.01, .1, .05>} finish {ambient .5}}}
                
#declare Zz=0
#declare Yy=0
#declare Rr=.1        
#declare cuerpo= union{
        sphere {<0, Yy-.1, Zz> Rr scale <1, 1, 1>}
        sphere {<0, Yy-.05, Zz-.05> Rr-.005 scale <1, 1, 1.2>}
        sphere {<0, Yy, Zz-.12> Rr-.01 scale <1, 1, 1.4>}
        sphere {<0, Yy+.01, Zz-.18> Rr-.0125 scale <1, 1, 1.5>}
        sphere {<0, Yy, Zz-.24> Rr-.015 scale <1, 1, 1.6>}
        sphere {<0, Yy-.0125, Zz-.3> Rr-.01675 scale <1, 1, 1.65>}
        sphere {<0, Yy-.025, Zz-.36> Rr-.0175 scale <1, 1, 1.7>}
        sphere {<0, Yy-.0375, Zz-.42> Rr-.01875 scale <1, 1, 1.75>}
        sphere {<0, Yy-.05, Zz-.48> Rr-.02 scale <1, 1, 1.8>}
        sphere {<0, Yy-.08, Zz-.54> Rr-.0225 scale <1, 1, 1.9>}
        sphere {<0, Yy-.12, Zz-.6> Rr-.025 scale <.9, .9, 2>}
        sphere {<0, Yy-.14, Zz-.66> Rr-.0275 scale <.8, .8, 2.1>}
        sphere {<0, Yy-.15, Zz-.72> Rr-.03 scale <.7, .7, 2.2>}
        
        }
                
#declare trompa= union {      
        #declare Yyy=.2;
        #declare Ang=0;
        #while (Yyy>=.03)
                cylinder {<0, 0, 0>, <0, 0, .03>, .005 open translate <0, Yyy, 0> rotate <Ang, 0, 0>}
        #declare Yyy=Yyy-.00045;
        #declare Ang=Ang+1.5;
        #end}
 
 


#declare mariposa1= union{    
        object {ala rotate <0, 0, 0-40> translate <-.02, 0, 0>}
        object {ala rotate <0, 0, -180+40> translate <.02, 0, 0>}
        object {cuerpo texture {T_Grnt8 scale <1, 1, .1> finish {ambient .3}}}
        object {trompa texture {T_Grnt1 finish {ambient .3}} translate <0, -.37, 0>}}

#declare mariposa2= union{    
        object {ala rotate <0, 0, 0-88> translate <-.02, 0, 0>}
        object {ala rotate <0, 0, -180+88> translate <.02, 0, 0>}
        object {cuerpo texture {T_Grnt8 scale <1, 1, .1> finish {ambient .3}}}
        object {trompa texture {T_Grnt1 finish {ambient .3}} translate <0, -.37, 0>}}

#declare mariposa3= union{    
        object {ala rotate <0, 0, 0-10> translate <-.02, 0, 0>}
        object {ala rotate <0, 0, -180+10> translate <.02, 0, 0>}
        object {cuerpo texture {T_Grnt8 scale <1, 1, .1> finish {ambient .3}}}
        object {trompa texture {T_Grnt1 finish {ambient .3}} translate <0, -.37, 0>}}


// Arbol =================================================================================

#declare arbre= union{
       object {
       #declare MaxSplits=5		
       #declare BaseLen=.4		
       #declare LengthInc=2.4		
       #declare MinXDeg=30		
       #declare MaxXDeg=40		
       #declare IncXDeg=-11		
       #declare MaxYDeg=160		
       #declare PlusMinus=80		
       #declare BallLevels=3		
       #declare LeafNum=5		
       #declare LeafRandRot=1	
       #declare TipPercent=.2		
       #declare Tip=3			
       #declare TipOther=1		
       #declare LeafShape=4		
       #declare LeafTexture=4 		
       #declare BarkTexture=3  	
       #declare FlowerShape=2		
       #declare FlowerTexture=4        
       #include "trees.inc"}}
  


#declare arbre2= union{
        object {
        #declare BaseLen=1.7		
        #declare LengthInc=1.5		
        #declare MinXDeg=30		
        #declare MaxXDeg=35		
        #declare IncXDeg=15		
        #declare PlusMinus=10		
        #declare LeafNum=6		
        #declare LeafRandRot=1  	
        #declare TipPercent=.7		
        #declare Tip=2			
        #declare LeafShape=4		
        #declare LeafTexture=2 		
        #declare FruitShape=5		
        #declare BarkTexture=4  	
        #include "trees.inc"}}
  
  
// Tiesto ================================================================================


#declare terra= difference{                                                                                          
        sphere {<0, 0, 0> 2.94 scale <1, .4, 1> translate <0, .1, 0>}
        box {<-4, .2, -4> <4, 4, 4>}
                texture {T_Grnt27 scale <.2, .2, .2> normal {dents 1 scale <.1, .1, .1>} finish {ambient .5}}}
        
#declare ties= union{
        sphere {<0, 0, 0> 3 scale <1, .4, 1>}
        torus{ 1.5,  1.49 translate <0, 2.9, 0> scale <1, .12, 1>}
        sphere {<0, 0, 0> .3 scale <.5, 1, .5> rotate <-30, 0, 30> translate <2, -.5, 2>}
        sphere {<0, 0, 0> .3 scale <.5, 1, .5> rotate <-30, 0, 30> translate <2, -.5, -2>}
        sphere {<0, 0, 0> .3 scale <.5, 1, .5> rotate <30, 0, -30> translate <-2, -.5, -2>}
        sphere {<0, 0, 0> .3 scale <.5, 1, .5> rotate <30, 0, -30> translate <-2, -.5, 2>}
        sphere {<0, 0, 0> .3 scale <.5, 1, .5> rotate <-30, 0, 30> translate <1.85, -.5, 1.85>}
        sphere {<0, 0, 0> .3 scale <.5, 1, .5> rotate <-30, 0, 30> translate <1.85, -.5, -1.85>}
        sphere {<0, 0, 0> .3 scale <.5, 1, .5> rotate <30, 0, -30> translate <-1.85, -.5, -1.85>}
        sphere {<0, 0, 0> .3 scale <.5, 1, .5> rotate <30, 0, -30> translate <-1.85, -.5, 1.85>}}
 
        
#declare tiest= difference{
        object {ties}
        sphere {<0, 0, 0> 2.94 scale <1, .4, 1> translate <0, .1, 0>}
                texture {T_Stone20 scale <.1, .1, .1>} finish {ambient .2}}

#declare tiesto= union{
        object {tiest}
        object {terra}}                                                                                          

#declare repisa= union{
        box {<-17, -.5, -3.6> <17, -1.1, 3> texture {T_Stone23 scale <2.5, 1, 1.5>} finish {ambient .7}}
        object {tiesto scale <1, 1.4, .6> translate <0, .2, 0>}
        translate <0, -1, 0>}


// Ventana =====================================================================================


#declare marc= difference {
        box {<-17, -1, -.2> <17, 22, 1>}
        box {<-16, 0, 0> <16, 21, 1.1>}
        box {<-15.8, .2, -.3> <15.8, 20.8, 1.1>}
            texture {Yellow_Pine scale <12, 15, 5> finish {ambient.3 reflection .1}}}
            

#declare ven= union{
        box {<-16, 0, 0> <-.1, 1, .2>}
        box {<-16, 5, 0> <-.1, 5.4, .2>}
        box {<-16, 10, 0> <-.1, 10.4, .2>} 
        box {<-16, 15, 0> <-.1, 15.4, .2>}
        box {<-16, 20, 0> <-.1, 21, .2>}
        box {<-16, 0, .3> <-.1, 1, .5>}
        box {<-16, 5, .3> <-.1, 5.4, .5>}
        box {<-16, 10, .3> <-.1, 10.4, .5>} 
        box {<-16, 15, .3> <-.1, 15.4, .5>}
        box {<-16, 20, .3> <-.1, 21, .5>}
            texture {Yellow_Pine scale <9, 12, 5> finish {ambient .3 reflection .06}}}
                
#declare ven1= union{
        box {<-16, 1, 0> <-15, 20, .2>}
        box {<-8.2, 1, 0> <-7.8, 20, .2>}
        box {<-1.1, 1, 0> <-.1, 20, .2>}
        box {<-16, 1, .3> <-15, 20, .5>}
        box {<-8.2, 1, .3> <-7.8, 20, .5>}
        box {<-1.1, 1, .3> <-.1, 20, .5>}
            texture {Yellow_Pine scale <16, 17, 4.5>} finish {ambient .3 reflection .06}}
                


#declare venta= union{
        object {ven}
        object {ven1}
        box {<-15.9, .1, .3> <-.2, 20.9, .4> texture {Glass3}}}

#declare ventana1= union {
        object {venta translate <16, 0, 0> rotate <0, -15, 0>}}

#declare ventana2= union {
        object {venta translate <0, 0, 0> rotate <0, 31, 0>}}

#declare ventana= union{
        object {ventana1 translate <-16, 0, 3>}
        object {ventana2 translate <16, 0, 3>}
        object {marc translate <0, 0, 3>}}

// Estancia =====================================================================

#declare estancia= difference {
        box {<-60, -16, -3> <60, 30, 60>texture {T_Stone8 scale <.1, .1, .1>} normal {dents 1 scale <.01, .01, .01>} finish {ambient .3}}
        box {<-55, -15  3> <55, 25, 55> pigment {color MidnightBlue}}
        box {<-17, -.6, 4> <17, 22.6, -5>texture {T_Stone8 scale <.1, .1, .1>} normal {dents 1 scale <.01, .01, .01>} finish {ambient .3}}}
                
// Rejola ============================================================================

#declare rejola= union{
        box {<-2.6, 0, -3.2> <0.2, 1.7, 3>}
        box {<-2.6, 2, -3.2> <0.2, 3.7, 3>}}

#declare rejola2= union{
        box {<.5, 22.4, -3.2> <2.2, 25.2, 3>}
        box {<2.5, 22.4, -3.2> <4.2, 25.2, 3>}}


#declare esque= union{
        object {rejola translate <0, -8, 0> texture { Rust scale <.024, .02, .027> finish {ambient .53 diffuse .67 roughness 0.45 }}}
        object {rejola translate <0, -4, 0> texture { Rust scale <.027, .02, .018> finish {ambient .55 diffuse .7 roughness 0.45 }}}
        object {rejola translate <0, -2, 0> texture { Rust scale <.02, .02, .03> finish {ambient .5 diffuse .6 roughness 0.4 }}}
        object {rejola translate <0, 0, 0> texture { Rust scale <.024, .02, .02> finish {ambient .47 diffuse .52 roughness 0.5 }}}
        object {rejola translate <0, 4, 0> texture { Rust scale <.022, .02, .025> finish {ambient .57 diffuse .7 roughness 0.45 }}}
        object {rejola translate <0, 6, 0> texture { Rust scale <.024, .02, .027> finish {ambient .53 diffuse .67 roughness 0.45 }}}
        object {rejola translate <0, 10, 0> texture { Rust scale <.027, .02, .018> finish {ambient .55 diffuse .7 roughness 0.45 }}}
        object {rejola translate <0, 12, 0> texture { Rust scale <.019, .02, .03> finish {ambient .52 diffuse .72 roughness 0.5 }}}
        object {rejola translate <0, 16, 0> texture { Rust scale <.022, .02, .022> finish {ambient .45 diffuse .62 roughness 0.55 }}}
        object {rejola translate <0, 20, 0> texture { Rust scale <.023, .02, .02> finish {ambient .51 diffuse .62 roughness 0.55 }}}
        object {rejola translate <0, 22, 0> texture { Rust scale <.017, .02, .024> finish {ambient .48 diffuse .55 roughness 0.45 }}}}

#declare esquer= union{
        object {esque}
        object {esque translate <-3.2, 2, 0>}}


#declare dalt= union{
        object {rejola2 texture { Rust scale <.023, .02, .02> finish {ambient .51 diffuse .62 roughness 0.55 }}}
        object {rejola2 translate <4, 0, 0> texture { Rust scale <.022, .02, .04> finish {ambient .51 diffuse .62 roughness 0.55 }}}
        object {rejola2 translate <6, 0, 0> texture { Rust scale <.02, .02, .06> finish {ambient .45 diffuse .57 roughness 0.51 }}}
        object {rejola2 translate <10, 0, 0> texture { Rust scale <.03, .02, .05> finish {ambient .49 diffuse .7 roughness 0.5 }}}
        object {rejola2 translate <12, 0, 0> texture { Rust scale <.025, .02, .03> finish {ambient .51 diffuse .6 roughness 0.54 }}}
        object {rejola2 translate <16, 0, 0> texture { Rust scale <.032, .02, .04> finish {ambient .54 diffuse .62 roughness 0.48 }}}
        object {rejola2 translate <18, 0, 0> texture { Rust scale <.04, .02, .02> finish {ambient .48 diffuse .58 roughness 0.51 }}}
        object {rejola2 translate <20, 0, 0> texture { Rust scale <.023, .02, .025> finish {ambient .5 diffuse .64 roughness 0.48 }}}
        object {rejola2 translate <24, 0, 0> texture { Rust scale <.03, .02, .035> finish {ambient .54 diffuse .61 roughness 0.45 }}}
        object {rejola2 translate <26, 0, 0> texture { Rust scale <.034, .02, .024> finish {ambient .47 diffuse .68 roughness 0.5 }}}
        object {rejola2 translate <30, 0, 0> texture { Rust scale <.026, .02, .02> finish {ambient .49 diffuse .59 roughness 0.54 }}}}





#declare pared=union{
        object {esquer}
        object {esquer translate <39.6, 2, 0>}
        object {dalt scale <.976, 1, 1>}
        object {dalt scale <.978, 1, 1> translate <0, -26, 0>}
        object {dalt scale <.978, 1, 1> translate <0, -29, 0>}}


// Escena ====================================================================================

sphere {<0, -5015, 0> 5000 texture {Jade scale <.1, .1, .1>} finish {ambient .6}}
sphere {<0, 0, 0> 10000 texture {Bright_Blue_Sky scale <3000, 1000, 1000>}}
object {mariposa2 rotate <-30, -90, 0> translate <2.4, 1.7, 0>}
object {mariposa3 rotate <-65, 5, 0> translate <-5.38, 11.5, -13>}
object {mariposa1 rotate <-10, -40, 0> translate <9, 16.6, -8>}
object {repisa translate <0, 1.5, 0>}
object {arbre texture {finish {ambient .5}}}  
object {ventana translate <0, 1, .2>}
object {estancia}
object {pared translate <-17, 0, 0>}
object {arbre2 rotate <0, 80, 0> translate <5, -17, -35> texture {finish {ambient .5}}}  
object {arbre2 rotate <0, -40, 0> translate <-20, -17, -40> texture {finish {ambient .5}}}  
object {arbre2 rotate <0, -120, 0> translate <15, -17, -50> texture {finish {ambient .5}}}  
object {arbre2 rotate <0, 100, 0> translate <10, -17, -45> texture {finish {ambient .5}}}  
                      
                      
        












