#include <stdio.h>
#include <math.h>

// Mbius bnd
// by Knut Roll-Lund (c)2001

//creation of a POV Mbius band according to some parameters
//the center line of the band (path) follows a circle:
#define pdiam 30.0
#define ptwist 10.0
//the profile band is a rectangle with:
#define bthick 0.6
#define bwidth 17.0*bthick

#define SMOOTHE
//#define QUICK

const char* tri1_txt=" triangle { <%f, %f, %f>,";
const char* tri2_txt=" <%f, %f, %f>,";
const char* tri3_txt=" <%f, %f, %f> }\n";
const char* s_tri1_txt=" smooth_triangle { <%f, %f, %f>,<%f, %f, %f>,";
const char* s_tri2_txt=" <%f, %f, %f>,<%f, %f, %f>,";
const char* s_tri3_txt=" <%f, %f, %f>,<%f, %f, %f> }\n";

void baand(void)
{
	unsigned int i,j;
	float s, a,b,c, x,y,z, d,e,f;
	float dx,dy,dz, nx,ny,nz, l;
	float fx,fy,fz,fdx,fdy,fdz,fnx,fny,fnz;
	float lx,ly,lz,ldx,ldy,ldz,lnx,lny,lnz;
	const float ix1=7.5/8.5, ix2=4.5/8.5, ix3=3.5/8.5, ix4=0.5/8.5;

	printf("#declare baand =\n"
		"union {\n");
	for (s=0.0; s<2.0*M_PI;)	//144 steps 36*4
	{
		x = pdiam/2.0  * cos(s);
		y = pdiam/2.0  * sin(s);
		z = -ptwist/2.0 * sin(s*2.0);
		//finn vektor for rotasjon
		a = cos(s/2.0) * cos(s);
		b = cos(s/2.0) * sin(s);
		c = sin(s/2.0);
		//er enhetsvektor ingen justering ndvendig
		//finn vektor langs banen med twist (derriverte av funksjonene til x,y og z
		d = -pdiam*sin(s);
		e = pdiam*cos(s);
		f = -ptwist*2.0*cos(s*2.0);
		//finn enhetsvektoren
		l = sqrt(d*d+e*e+f*f);
		d /= l;
		e /= l;
		f /= l;
		//finn vektor i skjeringpunktet mellom et plan som abc og def ligger
		//i mot et plan vinkelrett def
		dx = d*e*b-e*e*a-f*f*a+d*f*c;
		dy = -d*d*b+d*e*a+e*f*c-f*f*b;
		dz = d*f*a-d*d*c-e*e*c+e*f*b;
		//finn lengden av dxyz vektoren
		l = sqrt(dx*dx+dy*dy+dz*dz);
		//finn normalen til def og dxyz
		nx = bthick/2.0*(dy*f - dz*e);
		ny = bthick/2.0*(dz*d - dx*f);
		nz = bthick/2.0*(dx*e - dy*d);
		//lag en vektor med lengde bwidth/2.0
		dx *= bwidth/2.0/l;
		dy *= bwidth/2.0/l;
		dz *= bwidth/2.0/l;
		if (s==0.0)
		{
			fx = x;
			fy = y;
			fz = z;
			fdx = dx;
			fdy = dy;
			fdz = dz;
			fnx = nx;
			fny = ny;
			fnz = nz;
		}
		else
		{
			//(the single) flat surface (on both sides)
#ifdef SMOOTHE
			printf(s_tri1_txt,lx-ldx+lnx,ly-ldy+lny,lz-ldz+lnz,lnx,lny,lnz);
			printf(s_tri2_txt,lx+ldx+lnx,ly+ldy+lny,lz+ldz+lnz,lnx,lny,lnz);
			printf(s_tri3_txt,x+dx+nx,y+dy+ny,z+dz+nz,nx,ny,nz);
			printf(s_tri1_txt,lx-ldx+lnx,ly-ldy+lny,lz-ldz+lnz,lnx,lny,lnz);
			printf(s_tri2_txt,x-dx+nx,y-dy+ny,z-dz+nz,nx,ny,nz);
			printf(s_tri3_txt,x+dx+nx,y+dy+ny,z+dz+nz,nx,ny,nz);
			printf(s_tri1_txt,lx-ldx-lnx,ly-ldy-lny,lz-ldz-lnz,-lnx,-lny,-lnz);
			printf(s_tri2_txt,lx+ldx-lnx,ly+ldy-lny,lz+ldz-lnz,-lnx,-lny,-lnz);
			printf(s_tri3_txt,x+dx-nx,y+dy-ny,z+dz-nz,-nx,-ny,-nz);
			printf(s_tri1_txt,lx-ldx-lnx,ly-ldy-lny,lz-ldz-lnz,-lnx,-lny,-lnz);
			printf(s_tri2_txt,x-dx-nx,y-dy-ny,z-dz-nz,-nx,-ny,-nz);
			printf(s_tri3_txt,x+dx-nx,y+dy-ny,z+dz-nz,-nx,-ny,-nz);
#else SMOOTHE
			printf(tri1_txt,lx-ldx+lnx,ly-ldy+lny,lz-ldz+lnz);
			printf(tri2_txt,lx+ldx+lnx,ly+ldy+lny,lz+ldz+lnz);
			printf(tri3_txt,x+dx+nx,y+dy+ny,z+dz+nz);
			printf(tri1_txt,lx-ldx+lnx,ly-ldy+lny,lz-ldz+lnz);
			printf(tri2_txt,x-dx+nx,y-dy+ny,z-dz+nz);
			printf(tri3_txt,x+dx+nx,y+dy+ny,z+dz+nz);
			printf(tri1_txt,lx-ldx-lnx,ly-ldy-lny,lz-ldz-lnz);
			printf(tri2_txt,lx+ldx-lnx,ly+ldy-lny,lz+ldz-lnz);
			printf(tri3_txt,x+dx-nx,y+dy-ny,z+dz-nz);
			printf(tri1_txt,lx-ldx-lnx,ly-ldy-lny,lz-ldz-lnz);
			printf(tri2_txt,x-dx-nx,y-dy-ny,z-dz-nz);
			printf(tri3_txt,x+dx-nx,y+dy-ny,z+dz-nz);
#endif SMOOTHE
			//the sides of each rung (no need for smooth_triangle it is completely flat)
#ifndef QUICK
			printf(tri1_txt,lx-ldx+lnx,ly-ldy+lny,lz-ldz+lnz);
			printf(tri2_txt,lx+ldx+lnx,ly+ldy+lny,lz+ldz+lnz);
			printf(tri3_txt,lx+ldx-lnx,ly+ldy-lny,lz+ldz-lnz);
			printf(tri1_txt,lx-ldx-lnx,ly-ldy-lny,lz-ldz-lnz);
			printf(tri2_txt,lx-ldx+lnx,ly-ldy+lny,lz-ldz+lnz);
			printf(tri3_txt,lx+ldx-lnx,ly+ldy-lny,lz+ldz-lnz);
			printf(tri1_txt,x-dx-nx,y-dy-ny,z-dz-nz);
			printf(tri2_txt,x+dx-nx,y+dy-ny,z+dz-nz);
			printf(tri3_txt,x+dx+nx,y+dy+ny,z+dz+nz);
			printf(tri1_txt,x-dx-nx,y-dy-ny,z-dz-nz);
			printf(tri2_txt,x-dx+nx,y-dy+ny,z-dz+nz);
			printf(tri3_txt,x+dx+nx,y+dy+ny,z+dz+nz);
#endif QUICK
			//(the single) edge (on both sides)
#ifdef SMOOTHE
			printf(s_tri1_txt,lx-ldx+lnx,ly-ldy+lny,lz-ldz+lnz,-ldx,-ldy,-ldz);
			printf(s_tri2_txt,x-dx+nx,y-dy+ny,z-dz+nz,-dx,-dy,-dz);
			printf(s_tri3_txt,x-dx-nx,y-dy-ny,z-dz-nz,-dx,-dy,-dz);
			printf(s_tri1_txt,lx-ldx+lnx,ly-ldy+lny,lz-ldz+lnz,-ldx,-ldy,-ldz);
			printf(s_tri2_txt,lx-ldx-lnx,ly-ldy-lny,lz-ldz-lnz,-ldx,-ldy,-ldz);
			printf(s_tri3_txt,x-dx-nx,y-dy-ny,z-dz-nz,-dx,-dy,-dz);
			printf(s_tri1_txt,lx+ldx+lnx,ly+ldy+lny,lz+ldz+lnz,ldx,ldy,ldz);
			printf(s_tri2_txt,x+dx+nx,y+dy+ny,z+dz+nz,dx,dy,dz);
			printf(s_tri3_txt,x+dx-nx,y+dy-ny,z+dz-nz,dx,dy,dz);
			printf(s_tri1_txt,lx+ldx+lnx,ly+ldy+lny,lz+ldz+lnz,ldx,ldy,ldz);
			printf(s_tri2_txt,lx+ldx-lnx,ly+ldy-lny,lz+ldz-lnz,ldx,ldy,ldz);
			printf(s_tri3_txt,x+dx-nx,y+dy-ny,z+dz-nz,dx,dy,dz);
#else SMOOTHE
#ifndef QUICK
			printf(tri1_txt,lx-ldx+lnx,ly-ldy+lny,lz-ldz+lnz);
			printf(tri2_txt,x-dx+nx,y-dy+ny,z-dz+nz);
			printf(tri3_txt,x-dx-nx,y-dy-ny,z-dz-nz);
			printf(tri1_txt,lx-ldx+lnx,ly-ldy+lny,lz-ldz+lnz);
			printf(tri2_txt,lx-ldx-lnx,ly-ldy-lny,lz-ldz-lnz);
			printf(tri3_txt,x-dx-nx,y-dy-ny,z-dz-nz);
			printf(tri1_txt,lx+ldx+lnx,ly+ldy+lny,lz+ldz+lnz);
			printf(tri2_txt,x+dx+nx,y+dy+ny,z+dz+nz);
			printf(tri3_txt,x+dx-nx,y+dy-ny,z+dz-nz);
			printf(tri1_txt,lx+ldx+lnx,ly+ldy+lny,lz+ldz+lnz);
			printf(tri2_txt,lx+ldx-lnx,ly+ldy-lny,lz+ldz-lnz);
			printf(tri3_txt,x+dx-nx,y+dy-ny,z+dz-nz);
#endif QUICK
#endif SMOOTHE
		}
		lx = x;
		ly = y;
		lz = z;
		ldx = dx;
		ldy = dy;
		ldz = dz;
		lnx = nx;
		lny = ny;
		lnz = nz;
		s+=M_PI/48.0;	//144 steps 36*4 *1.5
		for (i=0; i<2; i++)
		{
			x = pdiam/2.0  * cos(s);
			y = pdiam/2.0  * sin(s);
			z = -ptwist/2.0 * sin(s*2.0);
			//finn vektor for rotasjon
			a = cos(s/2.0) * cos(s);
			b = cos(s/2.0) * sin(s);
			c = sin(s/2.0);
			//er enhetsvektor ingen justering ndvendig
			//finn vektor langs banen med twist (derriverte av funksjonene til x,y og z
			d = -pdiam*sin(s);
			e = pdiam*cos(s);
			f = -ptwist*2.0*cos(s*2.0);
			//finn enhetsvektoren
			l = sqrt(d*d+e*e+f*f);
			d /= l;
			e /= l;
			f /= l;
			//finn vektor i skjeringpunktet mellom et plan som abc og def ligger
			//i mot et plan vinkelrett def
			dx = d*e*b-e*e*a-f*f*a+d*f*c;
			dy = -d*d*b+d*e*a+e*f*c-f*f*b;
			dz = d*f*a-d*d*c-e*e*c+e*f*b;
			//finn lengden av dxyz vektoren
			l = sqrt(dx*dx+dy*dy+dz*dz);
			//finn normalen til def og dxyz
			nx = bthick/2.0*(dy*f - dz*e);
			ny = bthick/2.0*(dz*d - dx*f);
			nz = bthick/2.0*(dx*e - dy*d);
			//lag en vektor med lengde bwidth/2.0
			dx *= bwidth/2.0/l;
			dy *= bwidth/2.0/l;
			dz *= bwidth/2.0/l;
			//the surface of the edge
#ifdef SMOOTHE
			printf(s_tri1_txt,lx+ix1*ldx+lnx,ly+ix1*ldy+lny,lz+ix1*ldz+lnz,lnx,lny,lnz);
			printf(s_tri2_txt,lx+ldx+lnx,ly+ldy+lny,lz+ldz+lnz,lnx,lny,lnz);
			printf(s_tri3_txt,x+dx+nx,y+dy+ny,z+dz+nz,nx,ny,nz);
			printf(s_tri1_txt,lx+ix1*ldx+lnx,ly+ix1*ldy+lny,lz+ix1*ldz+lnz,lnx,lny,lnz);
			printf(s_tri2_txt,x+ix1*dx+nx,y+ix1*dy+ny,z+ix1*dz+nz,nx,ny,nz);
			printf(s_tri3_txt,x+dx+nx,y+dy+ny,z+dz+nz,nx,ny,nz);
			printf(s_tri1_txt,lx+ix1*ldx-lnx,ly+ix1*ldy-lny,lz+ix1*ldz-lnz,-lnx,-lny,-lnz);
			printf(s_tri2_txt,lx+ldx-lnx,ly+ldy-lny,lz+ldz-lnz,-lnx,-lny,-lnz);
			printf(s_tri3_txt,x+dx-nx,y+dy-ny,z+dz-nz,-nx,-ny,-nz);
			printf(s_tri1_txt,lx+ix1*ldx-lnx,ly+ix1*ldy-lny,lz+ix1*ldz-lnz,-lnx,-lny,-lnz);
			printf(s_tri2_txt,x+ix1*dx-nx,y+ix1*dy-ny,z+ix1*dz-nz,-nx,-ny,-nz);
			printf(s_tri3_txt,x+dx-nx,y+dy-ny,z+dz-nz,-nx,-ny,-nz);
			printf(s_tri1_txt,lx-ix1*ldx+lnx,ly-ix1*ldy+lny,lz-ix1*ldz+lnz,lnx,lny,lnz);
			printf(s_tri2_txt,lx-ldx+lnx,ly-ldy+lny,lz-ldz+lnz,lnx,lny,lnz);
			printf(s_tri3_txt,x-dx+nx,y-dy+ny,z-dz+nz,nx,ny,nz);
			printf(s_tri1_txt,lx-ix1*ldx+lnx,ly-ix1*ldy+lny,lz-ix1*ldz+lnz,lnx,lny,lnz);
			printf(s_tri2_txt,x-ix1*dx+nx,y-ix1*dy+ny,z-ix1*dz+nz,nx,ny,nz);
			printf(s_tri3_txt,x-dx+nx,y-dy+ny,z-dz+nz,nx,ny,nz);
			printf(s_tri1_txt,lx-ix1*ldx-lnx,ly-ix1*ldy-lny,lz-ix1*ldz-lnz,-lnx,-lny,-lnz);
			printf(s_tri2_txt,lx-ldx-lnx,ly-ldy-lny,lz-ldz-lnz,-lnx,-lny,-lnz);
			printf(s_tri3_txt,x-dx-nx,y-dy-ny,z-dz-nz,-nx,-ny,-nz);
			printf(s_tri1_txt,lx-ix1*ldx-lnx,ly-ix1*ldy-lny,lz-ix1*ldz-lnz,-lnx,-lny,-lnz);
			printf(s_tri2_txt,x-ix1*dx-nx,y-ix1*dy-ny,z-ix1*dz-nz,-nx,-ny,-nz);
			printf(s_tri3_txt,x-dx-nx,y-dy-ny,z-dz-nz,-nx,-ny,-nz);
#else SMOOTHE
			printf(tri1_txt,lx+ix1*ldx+lnx,ly+ix1*ldy+lny,lz+ix1*ldz+lnz);
			printf(tri2_txt,lx+ldx+lnx,ly+ldy+lny,lz+ldz+lnz);
			printf(tri3_txt,x+dx+nx,y+dy+ny,z+dz+nz);
			printf(tri1_txt,lx+ix1*ldx+lnx,ly+ix1*ldy+lny,lz+ix1*ldz+lnz);
			printf(tri2_txt,x+ix1*dx+nx,y+ix1*dy+ny,z+ix1*dz+nz);
			printf(tri3_txt,x+dx+nx,y+dy+ny,z+dz+nz);
			printf(tri1_txt,lx+ix1*ldx-lnx,ly+ix1*ldy-lny,lz+ix1*ldz-lnz);
			printf(tri2_txt,lx+ldx-lnx,ly+ldy-lny,lz+ldz-lnz);
			printf(tri3_txt,x+dx-nx,y+dy-ny,z+dz-nz);
			printf(tri1_txt,lx+ix1*ldx-lnx,ly+ix1*ldy-lny,lz+ix1*ldz-lnz);
			printf(tri2_txt,x+ix1*dx-nx,y+ix1*dy-ny,z+ix1*dz-nz);
			printf(tri3_txt,x+dx-nx,y+dy-ny,z+dz-nz);
			printf(tri1_txt,lx-ix1*ldx+lnx,ly-ix1*ldy+lny,lz-ix1*ldz+lnz);
			printf(tri2_txt,lx-ldx+lnx,ly-ldy+lny,lz-ldz+lnz);
			printf(tri3_txt,x-dx+nx,y-dy+ny,z-dz+nz);
			printf(tri1_txt,lx-ix1*ldx+lnx,ly-ix1*ldy+lny,lz-ix1*ldz+lnz);
			printf(tri2_txt,x-ix1*dx+nx,y-ix1*dy+ny,z-ix1*dz+nz);
			printf(tri3_txt,x-dx+nx,y-dy+ny,z-dz+nz);
			printf(tri1_txt,lx-ix1*ldx-lnx,ly-ix1*ldy-lny,lz-ix1*ldz-lnz);
			printf(tri2_txt,lx-ldx-lnx,ly-ldy-lny,lz-ldz-lnz);
			printf(tri3_txt,x-dx-nx,y-dy-ny,z-dz-nz);
			printf(tri1_txt,lx-ix1*ldx-lnx,ly-ix1*ldy-lny,lz-ix1*ldz-lnz);
			printf(tri2_txt,x-ix1*dx-nx,y-ix1*dy-ny,z-ix1*dz-nz);
			printf(tri3_txt,x-dx-nx,y-dy-ny,z-dz-nz);
#endif SMOOTHE
			//the surface 1/4 rung
#ifdef SMOOTHE
			printf(s_tri1_txt,lx+ix3*ldx+lnx,ly+ix3*ldy+lny,lz+ix3*ldz+lnz,lnx,lny,lnz);
			printf(s_tri2_txt,lx+ix2*ldx+lnx,ly+ix2*ldy+lny,lz+ix2*ldz+lnz,lnx,lny,lnz);
			printf(s_tri3_txt,x+ix2*dx+nx,y+ix2*dy+ny,z+ix2*dz+nz,nx,ny,nz);
			printf(s_tri1_txt,lx+ix3*ldx+lnx,ly+ix3*ldy+lny,lz+ix3*ldz+lnz,lnx,lny,lnz);
			printf(s_tri2_txt,x+ix3*dx+nx,y+ix3*dy+ny,z+ix3*dz+nz,nx,ny,nz);
			printf(s_tri3_txt,x+ix2*dx+nx,y+ix2*dy+ny,z+ix2*dz+nz,nx,ny,nz);
			printf(s_tri1_txt,lx+ix3*ldx-lnx,ly+ix3*ldy-lny,lz+ix3*ldz-lnz,-lnx,-lny,-lnz);
			printf(s_tri2_txt,lx+ix2*ldx-lnx,ly+ix2*ldy-lny,lz+ix2*ldz-lnz,-lnx,-lny,-lnz);
			printf(s_tri3_txt,x+ix2*dx-nx,y+ix2*dy-ny,z+ix2*dz-nz,-nx,-ny,-nz);
			printf(s_tri1_txt,lx+ix3*ldx-lnx,ly+ix3*ldy-lny,lz+ix3*ldz-lnz,-lnx,-lny,-lnz);
			printf(s_tri2_txt,x+ix3*dx-nx,y+ix3*dy-ny,z+ix3*dz-nz,-nx,-ny,-nz);
			printf(s_tri3_txt,x+ix2*dx-nx,y+ix2*dy-ny,z+ix2*dz-nz,-nx,-ny,-nz);
			printf(s_tri1_txt,lx-ix3*ldx+lnx,ly-ix3*ldy+lny,lz-ix3*ldz+lnz,lnx,lny,lnz);
			printf(s_tri2_txt,lx-ix2*ldx+lnx,ly-ix2*ldy+lny,lz-ix2*ldz+lnz,lnx,lny,lnz);
			printf(s_tri3_txt,x-ix2*dx+nx,y-ix2*dy+ny,z-ix2*dz+nz,nx,ny,nz);
			printf(s_tri1_txt,lx-ix3*ldx+lnx,ly-ix3*ldy+lny,lz-ix3*ldz+lnz,lnx,lny,lnz);
			printf(s_tri2_txt,x-ix3*dx+nx,y-ix3*dy+ny,z-ix3*dz+nz,nx,ny,nz);
			printf(s_tri3_txt,x-ix2*dx+nx,y-ix2*dy+ny,z-ix2*dz+nz,nx,ny,nz);
			printf(s_tri1_txt,lx-ix3*ldx-lnx,ly-ix3*ldy-lny,lz-ix3*ldz-lnz,-lnx,-lny,-lnz);
			printf(s_tri2_txt,lx-ix2*ldx-lnx,ly-ix2*ldy-lny,lz-ix2*ldz-lnz,-lnx,-lny,-lnz);
			printf(s_tri3_txt,x-ix2*dx-nx,y-ix2*dy-ny,z-ix2*dz-nz,-nx,-ny,-nz);
			printf(s_tri1_txt,lx-ix3*ldx-lnx,ly-ix3*ldy-lny,lz-ix3*ldz-lnz,-lnx,-lny,-lnz);
			printf(s_tri2_txt,x-ix3*dx-nx,y-ix3*dy-ny,z-ix3*dz-nz,-nx,-ny,-nz);
			printf(s_tri3_txt,x-ix2*dx-nx,y-ix2*dy-ny,z-ix2*dz-nz,-nx,-ny,-nz);
#else SMOOTHE
			printf(tri1_txt,lx+ix3*ldx+lnx,ly+ix3*ldy+lny,lz+ix3*ldz+lnz);
			printf(tri2_txt,lx+ix2*ldx+lnx,ly+ix2*ldy+lny,lz+ix2*ldz+lnz);
			printf(tri3_txt,x+ix2*dx+nx,y+ix2*dy+ny,z+ix2*dz+nz);
			printf(tri1_txt,lx+ix3*ldx+lnx,ly+ix3*ldy+lny,lz+ix3*ldz+lnz);
			printf(tri2_txt,x+ix3*dx+nx,y+ix3*dy+ny,z+ix3*dz+nz);
			printf(tri3_txt,x+ix2*dx+nx,y+ix2*dy+ny,z+ix2*dz+nz);
			printf(tri1_txt,lx+ix3*ldx-lnx,ly+ix3*ldy-lny,lz+ix3*ldz-lnz);
			printf(tri2_txt,lx+ix2*ldx-lnx,ly+ix2*ldy-lny,lz+ix2*ldz-lnz);
			printf(tri3_txt,x+ix2*dx-nx,y+ix2*dy-ny,z+ix2*dz-nz);
			printf(tri1_txt,lx+ix3*ldx-lnx,ly+ix3*ldy-lny,lz+ix3*ldz-lnz);
			printf(tri2_txt,x+ix3*dx-nx,y+ix3*dy-ny,z+ix3*dz-nz);
			printf(tri3_txt,x+ix2*dx-nx,y+ix2*dy-ny,z+ix2*dz-nz);
			printf(tri1_txt,lx-ix3*ldx+lnx,ly-ix3*ldy+lny,lz-ix3*ldz+lnz);
			printf(tri2_txt,lx-ix2*ldx+lnx,ly-ix2*ldy+lny,lz-ix2*ldz+lnz);
			printf(tri3_txt,x-ix2*dx+nx,y-ix2*dy+ny,z-ix2*dz+nz);
			printf(tri1_txt,lx-ix3*ldx+lnx,ly-ix3*ldy+lny,lz-ix3*ldz+lnz);
			printf(tri2_txt,x-ix3*dx+nx,y-ix3*dy+ny,z-ix3*dz+nz);
			printf(tri3_txt,x-ix2*dx+nx,y-ix2*dy+ny,z-ix2*dz+nz);
			printf(tri1_txt,lx-ix3*ldx-lnx,ly-ix3*ldy-lny,lz-ix3*ldz-lnz);
			printf(tri2_txt,lx-ix2*ldx-lnx,ly-ix2*ldy-lny,lz-ix2*ldz-lnz);
			printf(tri3_txt,x-ix2*dx-nx,y-ix2*dy-ny,z-ix2*dz-nz);
			printf(tri1_txt,lx-ix3*ldx-lnx,ly-ix3*ldy-lny,lz-ix3*ldz-lnz);
			printf(tri2_txt,x-ix3*dx-nx,y-ix3*dy-ny,z-ix3*dz-nz);
			printf(tri3_txt,x-ix2*dx-nx,y-ix2*dy-ny,z-ix2*dz-nz);
#endif SMOOTHE
			//the surfacee of middle rung
#ifdef SMOOTHE
			printf(s_tri1_txt,lx-ix4*ldx+lnx,ly-ix4*ldy+lny,lz-ix4*ldz+lnz,lnx,lny,lnz);
			printf(s_tri2_txt,lx+ix4*ldx+lnx,ly+ix4*ldy+lny,lz+ix4*ldz+lnz,lnx,lny,lnz);
			printf(s_tri3_txt,x+ix4*dx+nx,y+ix4*dy+ny,z+ix4*dz+nz,nx,ny,nz);
			printf(s_tri1_txt,lx-ix4*ldx+lnx,ly-ix4*ldy+lny,lz-ix4*ldz+lnz,lnx,lny,lnz);
			printf(s_tri2_txt,x-ix4*dx+nx,y-ix4*dy+ny,z-ix4*dz+nz,lnx,lny,lnz);
			printf(s_tri3_txt,x+ix4*dx+nx,y+ix4*dy+ny,z+ix4*dz+nz,nx,ny,nz);
			printf(s_tri1_txt,lx-ix4*ldx-lnx,ly-ix4*ldy-lny,lz-ix4*ldz-lnz,-lnx,-lny,-lnz);
			printf(s_tri2_txt,lx+ix4*ldx-lnx,ly+ix4*ldy-lny,lz+ix4*ldz-lnz,-lnx,-lny,-lnz);
			printf(s_tri3_txt,x+ix4*dx-nx,y+ix4*dy-ny,z+ix4*dz-nz,-nx,-ny,-nz);
			printf(s_tri1_txt,lx-ix4*ldx-lnx,ly-ix4*ldy-lny,lz-ix4*ldz-lnz,-lnx,-lny,-lnz);
			printf(s_tri2_txt,x-ix4*dx-nx,y-ix4*dy-ny,z-ix4*dz-nz,-nx,-ny,-nz);
			printf(s_tri3_txt,x+ix4*dx-nx,y+ix4*dy-ny,z+ix4*dz-nz,-nx,-ny,-nz);
#else SMOOTHE
			printf(tri1_txt,lx-ix4*ldx+lnx,ly-ix4*ldy+lny,lz-ix4*ldz+lnz);
			printf(tri2_txt,lx+ix4*ldx+lnx,ly+ix4*ldy+lny,lz+ix4*ldz+lnz);
			printf(tri3_txt,x+ix4*dx+nx,y+ix4*dy+ny,z+ix4*dz+nz);
			printf(tri1_txt,lx-ix4*ldx+lnx,ly-ix4*ldy+lny,lz-ix4*ldz+lnz);
			printf(tri2_txt,x-ix4*dx+nx,y-ix4*dy+ny,z-ix4*dz+nz);
			printf(tri3_txt,x+ix4*dx+nx,y+ix4*dy+ny,z+ix4*dz+nz);
			printf(tri1_txt,lx-ix4*ldx-lnx,ly-ix4*ldy-lny,lz-ix4*ldz-lnz);
			printf(tri2_txt,lx+ix4*ldx-lnx,ly+ix4*ldy-lny,lz+ix4*ldz-lnz);
			printf(tri3_txt,x+ix4*dx-nx,y+ix4*dy-ny,z+ix4*dz-nz);
			printf(tri1_txt,lx-ix4*ldx-lnx,ly-ix4*ldy-lny,lz-ix4*ldz-lnz);
			printf(tri2_txt,x-ix4*dx-nx,y-ix4*dy-ny,z-ix4*dz-nz);
			printf(tri3_txt,x+ix4*dx-nx,y+ix4*dy-ny,z+ix4*dz-nz);
#endif SMOOTHE
			//the sides of the middle rung
#ifdef SMOOTHE
			printf(s_tri1_txt,lx-ix4*ldx+lnx,ly-ix4*ldy+lny,lz-ix4*ldz+lnz,-ldx,-ldy,-ldz);
			printf(s_tri2_txt,x-ix4*dx+nx,y-ix4*dy+ny,z-ix4*dz+nz,-dx,-dy,-dz);
			printf(s_tri3_txt,x-ix4*dx-nx,y-ix4*dy-ny,z-ix4*dz-nz,-dx,-dy,-dz);
			printf(s_tri1_txt,lx-ix4*ldx+lnx,ly-ix4*ldy+lny,lz-ix4*ldz+lnz,-ldx,-ldy,-ldz);
			printf(s_tri2_txt,lx-ix4*ldx-lnx,ly-ix4*ldy-lny,lz-ix4*ldz-lnz,-ldx,-ldy,-ldz);
			printf(s_tri3_txt,x-ix4*dx-nx,y-ix4*dy-ny,z-ix4*dz-nz,-dx,-dy,-dz);
			printf(s_tri1_txt,lx+ix4*ldx+lnx,ly+ix4*ldy+lny,lz+ix4*ldz+lnz,ldx,ldy,ldz);
			printf(s_tri2_txt,x+ix4*dx+nx,y+ix4*dy+ny,z+ix4*dz+nz,dx,dy,dz);
			printf(s_tri3_txt,x+ix4*dx-nx,y+ix4*dy-ny,z+ix4*dz-nz,dx,dy,dz);
			printf(s_tri1_txt,lx+ix4*ldx+lnx,ly+ix4*ldy+lny,lz+ix4*ldz+lnz,ldx,ldy,ldz);
			printf(s_tri2_txt,lx+ix4*ldx-lnx,ly+ix4*ldy-lny,lz+ix4*ldz-lnz,ldx,ldy,ldz);
			printf(s_tri3_txt,x+ix4*dx-nx,y+ix4*dy-ny,z+ix4*dz-nz,dx,dy,dz);
#else SMOOTHE
#ifndef QUICK
			printf(tri1_txt,lx-ix4*ldx+lnx,ly-ix4*ldy+lny,lz-ix4*ldz+lnz);
			printf(tri2_txt,x-ix4*dx+nx,y-ix4*dy+ny,z-ix4*dz+nz);
			printf(tri3_txt,x-ix4*dx-nx,y-ix4*dy-ny,z-ix4*dz-nz);
			printf(tri1_txt,lx-ix4*ldx+lnx,ly-ix4*ldy+lny,lz-ix4*ldz+lnz);
			printf(tri2_txt,lx-ix4*ldx-lnx,ly-ix4*ldy-lny,lz-ix4*ldz-lnz);
			printf(tri3_txt,x-ix4*dx-nx,y-ix4*dy-ny,z-ix4*dz-nz);
			printf(tri1_txt,lx+ix4*ldx+lnx,ly+ix4*ldy+lny,lz+ix4*ldz+lnz);
			printf(tri2_txt,x+ix4*dx+nx,y+ix4*dy+ny,z+ix4*dz+nz);
			printf(tri3_txt,x+ix4*dx-nx,y+ix4*dy-ny,z+ix4*dz-nz);
			printf(tri1_txt,lx+ix4*ldx+lnx,ly+ix4*ldy+lny,lz+ix4*ldz+lnz);
			printf(tri2_txt,lx+ix4*ldx-lnx,ly+ix4*ldy-lny,lz+ix4*ldz-lnz);
			printf(tri3_txt,x+ix4*dx-nx,y+ix4*dy-ny,z+ix4*dz-nz);
#endif QUICK
#endif SMOOTHE
			//the outer side of the edge
#ifdef SMOOTHE
			printf(s_tri1_txt,lx-ldx+lnx,ly-ldy+lny,lz-ldz+lnz,-ldx,-ldy,-ldz);
			printf(s_tri2_txt,x-dx+nx,y-dy+ny,z-dz+nz,-dx,-dy,-dz);
			printf(s_tri3_txt,x-dx-nx,y-dy-ny,z-dz-nz,-dx,-dy,-dz);
			printf(s_tri1_txt,lx-ldx+lnx,ly-ldy+lny,lz-ldz+lnz,-ldx,-ldy,-ldz);
			printf(s_tri2_txt,lx-ldx-lnx,ly-ldy-lny,lz-ldz-lnz,-ldx,-ldy,-ldz);
			printf(s_tri3_txt,x-dx-nx,y-dy-ny,z-dz-nz,-dx,-dy,-dz);
			printf(s_tri1_txt,lx+ldx+lnx,ly+ldy+lny,lz+ldz+lnz,ldx,ldy,ldz);
			printf(s_tri2_txt,x+dx+nx,y+dy+ny,z+dz+nz,dx,dy,dz);
			printf(s_tri3_txt,x+dx-nx,y+dy-ny,z+dz-nz,dx,dy,dz);
			printf(s_tri1_txt,lx+ldx+lnx,ly+ldy+lny,lz+ldz+lnz,ldx,ldy,ldz);
			printf(s_tri2_txt,lx+ldx-lnx,ly+ldy-lny,lz+ldz-lnz,ldx,ldy,ldz);
			printf(s_tri3_txt,x+dx-nx,y+dy-ny,z+dz-nz,dx,dy,dz);
#else SMOOTHE
#ifndef QUICK
			printf(tri1_txt,lx-ldx+lnx,ly-ldy+lny,lz-ldz+lnz);
			printf(tri2_txt,x-dx+nx,y-dy+ny,z-dz+nz);
			printf(tri3_txt,x-dx-nx,y-dy-ny,z-dz-nz);
			printf(tri1_txt,lx-ldx+lnx,ly-ldy+lny,lz-ldz+lnz);
			printf(tri2_txt,lx-ldx-lnx,ly-ldy-lny,lz-ldz-lnz);
			printf(tri3_txt,x-dx-nx,y-dy-ny,z-dz-nz);
			printf(tri1_txt,lx+ldx+lnx,ly+ldy+lny,lz+ldz+lnz);
			printf(tri2_txt,x+dx+nx,y+dy+ny,z+dz+nz);
			printf(tri3_txt,x+dx-nx,y+dy-ny,z+dz-nz);
			printf(tri1_txt,lx+ldx+lnx,ly+ldy+lny,lz+ldz+lnz);
			printf(tri2_txt,lx+ldx-lnx,ly+ldy-lny,lz+ldz-lnz);
			printf(tri3_txt,x+dx-nx,y+dy-ny,z+dz-nz);
#endif QUICK
#endif SMOOTHE
			//the outer side of 1/4 rung
#ifdef SMOOTHE
			printf(s_tri1_txt,lx-ix2*ldx+lnx,ly-ix2*ldy+lny,lz-ix2*ldz+lnz,-ldx,-ldy,-ldz);
			printf(s_tri2_txt,x-ix2*dx+nx,y-ix2*dy+ny,z-ix2*dz+nz,-dx,-dy,-dz);
			printf(s_tri3_txt,x-ix2*dx-nx,y-ix2*dy-ny,z-ix2*dz-nz,-dx,-dy,-dz);
			printf(s_tri1_txt,lx-ix2*ldx+lnx,ly-ix2*ldy+lny,lz-ix2*ldz+lnz,-ldx,-ldy,-ldz);
			printf(s_tri2_txt,lx-ix2*ldx-lnx,ly-ix2*ldy-lny,lz-ix2*ldz-lnz,-ldx,-ldy,-ldz);
			printf(s_tri3_txt,x-ix2*dx-nx,y-ix2*dy-ny,z-ix2*dz-nz,-dx,-dy,-dz);
			printf(s_tri1_txt,lx+ix2*ldx+lnx,ly+ix2*ldy+lny,lz+ix2*ldz+lnz,ldx,ldy,ldz);
			printf(s_tri2_txt,x+ix2*dx+nx,y+ix2*dy+ny,z+ix2*dz+nz,dx,dy,dz);
			printf(s_tri3_txt,x+ix2*dx-nx,y+ix2*dy-ny,z+ix2*dz-nz,dx,dy,dz);
			printf(s_tri1_txt,lx+ix2*ldx+lnx,ly+ix2*ldy+lny,lz+ix2*ldz+lnz,ldx,ldy,ldz);
			printf(s_tri2_txt,lx+ix2*ldx-lnx,ly+ix2*ldy-lny,lz+ix2*ldz-lnz,ldx,ldy,ldz);
			printf(s_tri3_txt,x+ix2*dx-nx,y+ix2*dy-ny,z+ix2*dz-nz,dx,dy,dz);
#else SMOOTHE
#ifndef QUICK
			printf(tri1_txt,lx-ix2*ldx+lnx,ly-ix2*ldy+lny,lz-ix2*ldz+lnz);
			printf(tri2_txt,x-ix2*dx+nx,y-ix2*dy+ny,z-ix2*dz+nz);
			printf(tri3_txt,x-ix2*dx-nx,y-ix2*dy-ny,z-ix2*dz-nz);
			printf(tri1_txt,lx-ix2*ldx+lnx,ly-ix2*ldy+lny,lz-ix2*ldz+lnz);
			printf(tri2_txt,lx-ix2*ldx-lnx,ly-ix2*ldy-lny,lz-ix2*ldz-lnz);
			printf(tri3_txt,x-ix2*dx-nx,y-ix2*dy-ny,z-ix2*dz-nz);
			printf(tri1_txt,lx+ix2*ldx+lnx,ly+ix2*ldy+lny,lz+ix2*ldz+lnz);
			printf(tri2_txt,x+ix2*dx+nx,y+ix2*dy+ny,z+ix2*dz+nz);
			printf(tri3_txt,x+ix2*dx-nx,y+ix2*dy-ny,z+ix2*dz-nz);
			printf(tri1_txt,lx+ix2*ldx+lnx,ly+ix2*ldy+lny,lz+ix2*ldz+lnz);
			printf(tri2_txt,lx+ix2*ldx-lnx,ly+ix2*ldy-lny,lz+ix2*ldz-lnz);
			printf(tri3_txt,x+ix2*dx-nx,y+ix2*dy-ny,z+ix2*dz-nz);
#endif QUICK
#endif SMOOTHE
			//the inner side of the edge
#ifdef SMOOTHE
			printf(s_tri1_txt,lx-ix1*ldx+lnx,ly-ix1*ldy+lny,lz-ix1*ldz+lnz,ldx,ldy,ldz);
			printf(s_tri2_txt,x-ix1*dx+nx,y-ix1*dy+ny,z-ix1*dz+nz,dx,dy,dz);
			printf(s_tri3_txt,x-ix1*dx-nx,y-ix1*dy-ny,z-ix1*dz-nz,dx,dy,dz);
			printf(s_tri1_txt,lx-ix1*ldx+lnx,ly-ix1*ldy+lny,lz-ix1*ldz+lnz,ldx,ldy,ldz);
			printf(s_tri2_txt,lx-ix1*ldx-lnx,ly-ix1*ldy-lny,lz-ix1*ldz-lnz,ldx,ldy,ldz);
			printf(s_tri3_txt,x-ix1*dx-nx,y-ix1*dy-ny,z-ix1*dz-nz,dx,dy,dz);
			printf(s_tri1_txt,lx+ix1*ldx+lnx,ly+ix1*ldy+lny,lz+ix1*ldz+lnz,-ldx,-ldy,-ldz);
			printf(s_tri2_txt,x+ix1*dx+nx,y+ix1*dy+ny,z+ix1*dz+nz,-dx,-dy,-dz);
			printf(s_tri3_txt,x+ix1*dx-nx,y+ix1*dy-ny,z+ix1*dz-nz,-dx,-dy,-dz);
			printf(s_tri1_txt,lx+ix1*ldx+lnx,ly+ix1*ldy+lny,lz+ix1*ldz+lnz,-ldx,-ldy,-ldz);
			printf(s_tri2_txt,lx+ix1*ldx-lnx,ly+ix1*ldy-lny,lz+ix1*ldz-lnz,-ldx,-ldy,-ldz);
			printf(s_tri3_txt,x+ix1*dx-nx,y+ix1*dy-ny,z+ix1*dz-nz,-dx,-dy,-dz);
#else SMOOTHE
#ifndef QUICK
			printf(tri1_txt,lx-ix1*ldx+lnx,ly-ix1*ldy+lny,lz-ix1*ldz+lnz);
			printf(tri2_txt,x-ix1*dx+nx,y-ix1*dy+ny,z-ix1*dz+nz);
			printf(tri3_txt,x-ix1*dx-nx,y-ix1*dy-ny,z-ix1*dz-nz);
			printf(tri1_txt,lx-ix1*ldx+lnx,ly-ix1*ldy+lny,lz-ix1*ldz+lnz);
			printf(tri2_txt,lx-ix1*ldx-lnx,ly-ix1*ldy-lny,lz-ix1*ldz-lnz);
			printf(tri3_txt,x-ix1*dx-nx,y-ix1*dy-ny,z-ix1*dz-nz);
			printf(tri1_txt,lx+ix1*ldx+lnx,ly+ix1*ldy+lny,lz+ix1*ldz+lnz);
			printf(tri2_txt,x+ix1*dx+nx,y+ix1*dy+ny,z+ix1*dz+nz);
			printf(tri3_txt,x+ix1*dx-nx,y+ix1*dy-ny,z+ix1*dz-nz);
			printf(tri1_txt,lx+ix1*ldx+lnx,ly+ix1*ldy+lny,lz+ix1*ldz+lnz);
			printf(tri2_txt,lx+ix1*ldx-lnx,ly+ix1*ldy-lny,lz+ix1*ldz-lnz);
			printf(tri3_txt,x+ix1*dx-nx,y+ix1*dy-ny,z+ix1*dz-nz);
#endif QUICK
#endif SMOOTHE
			//the inner side of 1/4 rung
#ifdef SMOOTHE
			printf(s_tri1_txt,lx-ix3*ldx+lnx,ly-ix3*ldy+lny,lz-ix3*ldz+lnz,ldx,ldy,ldz);
			printf(s_tri2_txt,x-ix3*dx+nx,y-ix3*dy+ny,z-ix3*dz+nz,dx,dy,dz);
			printf(s_tri3_txt,x-ix3*dx-nx,y-ix3*dy-ny,z-ix3*dz-nz,dx,dy,dz);
			printf(s_tri1_txt,lx-ix3*ldx+lnx,ly-ix3*ldy+lny,lz-ix3*ldz+lnz,ldx,ldy,ldz);
			printf(s_tri2_txt,lx-ix3*ldx-lnx,ly-ix3*ldy-lny,lz-ix3*ldz-lnz,ldx,ldy,ldz);
			printf(s_tri3_txt,x-ix3*dx-nx,y-ix3*dy-ny,z-ix3*dz-nz,dx,dy,dz);
			printf(s_tri1_txt,lx+ix3*ldx+lnx,ly+ix3*ldy+lny,lz+ix3*ldz+lnz,-ldx,-ldy,-ldz);
			printf(s_tri2_txt,x+ix3*dx+nx,y+ix3*dy+ny,z+ix3*dz+nz,-dx,-dy,-dz);
			printf(s_tri3_txt,x+ix3*dx-nx,y+ix3*dy-ny,z+ix3*dz-nz,-dx,-dy,-dz);
			printf(s_tri1_txt,lx+ix3*ldx+lnx,ly+ix3*ldy+lny,lz+ix3*ldz+lnz,-ldx,-ldy,-ldz);
			printf(s_tri2_txt,lx+ix3*ldx-lnx,ly+ix3*ldy-lny,lz+ix3*ldz-lnz,-ldx,-ldy,-ldz);
			printf(s_tri3_txt,x+ix3*dx-nx,y+ix3*dy-ny,z+ix3*dz-nz,-dx,-dy,-dz);
#else SMOOTHE
#ifndef QUICK
			printf(tri1_txt,lx-ix3*ldx+lnx,ly-ix3*ldy+lny,lz-ix3*ldz+lnz);
			printf(tri2_txt,x-ix3*dx+nx,y-ix3*dy+ny,z-ix3*dz+nz);
			printf(tri3_txt,x-ix3*dx-nx,y-ix3*dy-ny,z-ix3*dz-nz);
			printf(tri1_txt,lx-ix3*ldx+lnx,ly-ix3*ldy+lny,lz-ix3*ldz+lnz);
			printf(tri2_txt,lx-ix3*ldx-lnx,ly-ix3*ldy-lny,lz-ix3*ldz-lnz);
			printf(tri3_txt,x-ix3*dx-nx,y-ix3*dy-ny,z-ix3*dz-nz);
			printf(tri1_txt,lx+ix3*ldx+lnx,ly+ix3*ldy+lny,lz+ix3*ldz+lnz);
			printf(tri2_txt,x+ix3*dx+nx,y+ix3*dy+ny,z+ix3*dz+nz);
			printf(tri3_txt,x+ix3*dx-nx,y+ix3*dy-ny,z+ix3*dz-nz);
			printf(tri1_txt,lx+ix3*ldx+lnx,ly+ix3*ldy+lny,lz+ix3*ldz+lnz);
			printf(tri2_txt,lx+ix3*ldx-lnx,ly+ix3*ldy-lny,lz+ix3*ldz-lnz);
			printf(tri3_txt,x+ix3*dx-nx,y+ix3*dy-ny,z+ix3*dz-nz);
#endif QUICK
#endif SMOOTHE
			lx = x;
			ly = y;
			lz = z;
			ldx = dx;
			ldy = dy;
			ldz = dz;
			lnx = nx;
			lny = ny;
			lnz = nz;
			if (i==1)
				s+=M_PI/72.0;	//144 steps 36*4
			else
				s+=M_PI/48.0;	//144 steps 36*4 *1.5
		}
	}
	//surface of last bit
#ifdef SMOOTHE
	printf(s_tri1_txt,lx-ldx+lnx,ly-ldy+lny,lz-ldz+lnz,lnx,lny,lnz);
	printf(s_tri2_txt,lx+ldx+lnx,ly+ldy+lny,lz+ldz+lnz,lnx,lny,lnz);
	printf(s_tri3_txt,fx+fdx-fnx,fy+fdy-fny,fz+fdz-fnz,-fnx,-fny,-fnz);
	printf(s_tri1_txt,lx+ldx+lnx,ly+ldy+lny,lz+ldz+lnz,lnx,lny,lnz);
	printf(s_tri2_txt,fx-fdx-fnx,fy-fdy-fny,fz-fdz-fnz,-fnx,-fny,-fnz);
	printf(s_tri3_txt,fx+fdx-fnx,fy+fdy-fny,fz+fdz-fnz,-fnx,-fny,-fnz);
	printf(s_tri1_txt,lx-ldx-lnx,ly-ldy-lny,lz-ldz-lnz,-lnx,-lny,-lnz);
	printf(s_tri2_txt,lx+ldx-lnx,ly+ldy-lny,lz+ldz-lnz,-lnx,-lny,-lnz);
	printf(s_tri3_txt,fx+fdx+fnx,fy+fdy+fny,fz+fdz+fnz,fnx,fny,fnz);
	printf(s_tri1_txt,lx+ldx-lnx,ly+ldy-lny,lz+ldz-lnz,-lnx,-lny,-lnz);
	printf(s_tri2_txt,fx-fdx+fnx,fy-fdy+fny,fz-fdz+fnz,fnx,fny,fnz);
	printf(s_tri3_txt,fx+fdx+fnx,fy+fdy+fny,fz+fdz+fnz,fnx,fny,fnz);
#else SMOOTHE
	printf(tri1_txt,lx-ldx+lnx,ly-ldy+lny,lz-ldz+lnz);
	printf(tri2_txt,lx+ldx+lnx,ly+ldy+lny,lz+ldz+lnz);
	printf(tri3_txt,fx+fdx-fnx,fy+fdy-fny,fz+fdz-fnz);
	printf(tri1_txt,lx-ldx+lnx,ly-ldy+lny,lz-ldz+lnz);
	printf(tri2_txt,fx-fdx-fnx,fy-fdy-fny,fz-fdz-fnz);
	printf(tri3_txt,fx+fdx-fnx,fy+fdy-fny,fz+fdz-fnz);
	printf(tri1_txt,lx-ldx-lnx,ly-ldy-lny,lz-ldz-lnz);
	printf(tri2_txt,lx+ldx-lnx,ly+ldy-lny,lz+ldz-lnz);
	printf(tri3_txt,fx+fdx+fnx,fy+fdy+fny,fz+fdz+fnz);
	printf(tri1_txt,lx-ldx-lnx,ly-ldy-lny,lz-ldz-lnz);
	printf(tri2_txt,fx-fdx+fnx,fy-fdy+fny,fz-fdz+fnz);
	printf(tri3_txt,fx+fdx+fnx,fy+fdy+fny,fz+fdz+fnz);
#endif SMOOTHE
	//the sides of last bit (no need for smooth_triangle it is completely flat)
#ifndef QUICK
	printf(tri1_txt,lx-ldx+lnx,ly-ldy+lny,lz-ldz+lnz);
	printf(tri2_txt,lx+ldx+lnx,ly+ldy+lny,lz+ldz+lnz);
	printf(tri3_txt,lx+ldx-lnx,ly+ldy-lny,lz+ldz-lnz);
	printf(tri1_txt,lx-ldx-lnx,ly-ldy-lny,lz-ldz-lnz);
	printf(tri2_txt,lx-ldx+lnx,ly-ldy+lny,lz-ldz+lnz);
	printf(tri3_txt,lx+ldx-lnx,ly+ldy-lny,lz+ldz-lnz);
	printf(tri1_txt,fx-fdx-fnx,fy-fdy-fny,fz-fdz-fnz);
	printf(tri2_txt,fx+fdx-fnx,fy+fdy-fny,fz+fdz-fnz);
	printf(tri3_txt,fx+fdx+fnx,fy+fdy+fny,fz+fdz+fnz);
	printf(tri1_txt,fx-fdx-fnx,fy-fdy-fny,fz-fdz-fnz);
	printf(tri2_txt,fx-fdx+fnx,fy-fdy+fny,fz-fdz+fnz);
	printf(tri3_txt,fx+fdx+fnx,fy+fdy+fny,fz+fdz+fnz);
#endif QUICK
	//edge of last bit
#ifdef SMOOTHE
	printf(s_tri1_txt,lx-ldx-lnx,ly-ldy-lny,lz-ldz-lnz,-ldx,-ldy,-ldz);
	printf(s_tri2_txt,fx+fdx+fnx,fy+fdy+fny,fz+fdz+fnz,fdx,fdy,fdz);
	printf(s_tri3_txt,fx+fdx-fnx,fy+fdy-fny,fz+fdz-fnz,fdx,fdy,fdz);
	printf(s_tri1_txt,lx-ldx+lnx,ly-ldy+lny,lz-ldz+lnz,-ldx,-ldy,-ldz);
	printf(s_tri2_txt,lx-ldx-lnx,ly-ldy-lny,lz-ldz-lnz,-ldx,-ldy,-ldz);
	printf(s_tri3_txt,fx+fdx-fnx,fy+fdy-fny,fz+fdz-fnz,fdx,fdy,fdz);
	printf(s_tri1_txt,lx+ldx+lnx,ly+ldy+lny,lz+ldz+lnz,ldx,ldy,ldz);
	printf(s_tri2_txt,fx-fdx+fnx,fy-fdy+fny,fz-fdz+fnz,-fdx,-fdy,-fdz);
	printf(s_tri3_txt,fx-fdx-fnx,fy-fdy-fny,fz-fdz-fnz,-fdx,-fdy,-fdz);
	printf(s_tri1_txt,lx+ldx+lnx,ly+ldy+lny,lz+ldz+lnz,ldx,ldy,ldz);
	printf(s_tri2_txt,lx+ldx-lnx,ly+ldy-lny,lz+ldz-lnz,ldx,ldy,ldz);
	printf(s_tri3_txt,fx-fdx+fnx,fy-fdy+fny,fz-fdz+fnz,-fdx,-fdy,-fdz);
#else SMOOTHE
#ifndef QUICK
	printf(tri1_txt,lx-ldx-lnx,ly-ldy-lny,lz-ldz-lnz);
	printf(tri2_txt,fx+fdx+fnx,fy+fdy+fny,fz+fdz+fnz);
	printf(tri3_txt,fx+fdx-fnx,fy+fdy-fny,fz+fdz-fnz);
	printf(tri1_txt,lx-ldx+lnx,ly-ldy+lny,lz-ldz+lnz);
	printf(tri2_txt,lx-ldx-lnx,ly-ldy-lny,lz-ldz-lnz);
	printf(tri3_txt,fx+fdx-fnx,fy+fdy-fny,fz+fdz-fnz);
	printf(tri1_txt,lx+ldx+lnx,ly+ldy+lny,lz+ldz+lnz);
	printf(tri2_txt,fx-fdx+fnx,fy-fdy+fny,fz-fdz+fnz);
	printf(tri3_txt,fx-fdx-fnx,fy-fdy-fny,fz-fdz-fnz);
	printf(tri1_txt,lx+ldx+lnx,ly+ldy+lny,lz+ldz+lnz);
	printf(tri2_txt,lx+ldx-lnx,ly+ldy-lny,lz+ldz-lnz);
	printf(tri3_txt,fx-fdx+fnx,fy-fdy+fny,fz-fdz+fnz);
#endif QUICK
#endif SMOOTHE
	printf("}\n");
}


#ifndef QUICK
#ifdef SMOOTHE
void indre_baand(void)
{
	unsigned int i,j;
	float s, a,b,c, x,y,z, d,e,f;
	float dx,dy,dz, nx,ny,nz, l;
	float fx,fy,fz,fdx,fdy,fdz,fnx,fny,fnz;
	float lx,ly,lz,ldx,ldy,ldz,lnx,lny,lnz;
	const float ix0=8.499/8.5,	ix1=7.501/8.5,	ix2=4.499/8.5,	ix3=3.501/8.5,	ix4=0.499/8.5;

	printf("#declare indre_baand =\n"
		"union {\n");
	for (s=0.0; s<2.0*M_PI;)	//144 steps 36*4
	{
		x = pdiam/2.0  * cos(s);
		y = pdiam/2.0  * sin(s);
		z = -ptwist/2.0 * sin(s*2.0);
		//finn vektor for rotasjon
		a = cos(s/2.0) * cos(s);
		b = cos(s/2.0) * sin(s);
		c = sin(s/2.0);
      //er enhetsvektor ingen justering ndvendig
		//finn vektor langs banen med twist (derriverte av funksjonene til x,y og z
		d = -pdiam*sin(s);
		e = pdiam*cos(s);
		f = -ptwist*2.0*cos(s*2.0);
		//finn enhetsvektoren
		l = sqrt(d*d+e*e+f*f);
		d /= l;
		e /= l;
		f /= l;
		//finn vektor i skjeringpunktet mellom et plan som abc og def ligger
		//i mot et plan vinkelrett def
		dx = d*e*b-e*e*a-f*f*a+d*f*c;
		dy = -d*d*b+d*e*a+e*f*c-f*f*b;
		dz = d*f*a-d*d*c-e*e*c+e*f*b;
		//finn lengden av dxyz vektoren
		l = sqrt(dx*dx+dy*dy+dz*dz);
		//finn normalen til def og dxyz
		nx = bthick/2.01*(dy*f - dz*e);
		ny = bthick/2.01*(dz*d - dx*f);
		nz = bthick/2.01*(dx*e - dy*d);
		//lag en vektor med lengde bwidth/2.0
		dx *= bwidth/2.0/l;
		dy *= bwidth/2.0/l;
		dz *= bwidth/2.0/l;
		if (s==0.0)
		{
			fx = x;
			fy = y;
			fz = z;
			fdx = dx;
			fdy = dy;
			fdz = dz;
			fnx = nx;
			fny = ny;
			fnz = nz;
		}
		else
		{
			//(the single) flat surface (on both sides)
			printf(tri1_txt,lx-ix0*ldx+lnx,ly-ix0*ldy+lny,lz-ix0*ldz+lnz);
			printf(tri2_txt,lx+ix0*ldx+lnx,ly+ix0*ldy+lny,lz+ix0*ldz+lnz);
			printf(tri3_txt,x+ix0*dx+nx,y+ix0*dy+ny,z+ix0*dz+nz);
			printf(tri1_txt,lx-ix0*ldx+lnx,ly-ix0*ldy+lny,lz-ix0*ldz+lnz);
			printf(tri2_txt,x-ix0*dx+nx,y-ix0*dy+ny,z-ix0*dz+nz);
			printf(tri3_txt,x+ix0*dx+nx,y+ix0*dy+ny,z+ix0*dz+nz);
			printf(tri1_txt,lx-ix0*ldx-lnx,ly-ix0*ldy-lny,lz-ix0*ldz-lnz);
			printf(tri2_txt,lx+ix0*ldx-lnx,ly+ix0*ldy-lny,lz+ix0*ldz-lnz);
			printf(tri3_txt,x+ix0*dx-nx,y+ix0*dy-ny,z+ix0*dz-nz);
			printf(tri1_txt,lx-ix0*ldx-lnx,ly-ix0*ldy-lny,lz-ix0*ldz-lnz);
			printf(tri2_txt,x-ix0*dx-nx,y-ix0*dy-ny,z-ix0*dz-nz);
			printf(tri3_txt,x+ix0*dx-nx,y+ix0*dy-ny,z+ix0*dz-nz);
			//the sides of each rung (no need for smooth_triangle it is completely flat)
			printf(tri1_txt,lx-ix0*ldx+lnx,ly-ix0*ldy+lny,lz-ix0*ldz+lnz);
			printf(tri2_txt,lx+ix0*ldx+lnx,ly+ix0*ldy+lny,lz+ix0*ldz+lnz);
			printf(tri3_txt,lx+ix0*ldx-lnx,ly+ix0*ldy-lny,lz+ix0*ldz-lnz);
			printf(tri1_txt,lx-ix0*ldx-lnx,ly-ix0*ldy-lny,lz-ix0*ldz-lnz);
			printf(tri2_txt,lx-ix0*ldx+lnx,ly-ix0*ldy+lny,lz-ix0*ldz+lnz);
			printf(tri3_txt,lx+ix0*ldx-lnx,ly+ix0*ldy-lny,lz+ix0*ldz-lnz);
			printf(tri1_txt,x-ix0*dx-nx,y-ix0*dy-ny,z-ix0*dz-nz);
			printf(tri2_txt,x+ix0*dx-nx,y+ix0*dy-ny,z+ix0*dz-nz);
			printf(tri3_txt,x+ix0*dx+nx,y+ix0*dy+ny,z+ix0*dz+nz);
			printf(tri1_txt,x-ix0*dx-nx,y-ix0*dy-ny,z-ix0*dz-nz);
			printf(tri2_txt,x-ix0*dx+nx,y-ix0*dy+ny,z-ix0*dz+nz);
			printf(tri3_txt,x+ix0*dx+nx,y+ix0*dy+ny,z+ix0*dz+nz);
			//(the single) edge (on both sides)
			printf(tri1_txt,lx-ix0*ldx+lnx,ly-ix0*ldy+lny,lz-ix0*ldz+lnz);
			printf(tri2_txt,x-ix0*dx+nx,y-ix0*dy+ny,z-ix0*dz+nz);
			printf(tri3_txt,x-ix0*dx-nx,y-ix0*dy-ny,z-ix0*dz-nz);
			printf(tri1_txt,lx-ix0*ldx+lnx,ly-ix0*ldy+lny,lz-ix0*ldz+lnz);
			printf(tri2_txt,lx-ix0*ldx-lnx,ly-ix0*ldy-lny,lz-ix0*ldz-lnz);
			printf(tri3_txt,x-ix0*dx-nx,y-ix0*dy-ny,z-ix0*dz-nz);
			printf(tri1_txt,lx+ix0*ldx+lnx,ly+ix0*ldy+lny,lz+ix0*ldz+lnz);
			printf(tri2_txt,x+ix0*dx+nx,y+ix0*dy+ny,z+ix0*dz+nz);
			printf(tri3_txt,x+ix0*dx-nx,y+ix0*dy-ny,z+ix0*dz-nz);
			printf(tri1_txt,lx+ix0*ldx+lnx,ly+ix0*ldy+lny,lz+ix0*ldz+lnz);
			printf(tri2_txt,lx+ix0*ldx-lnx,ly+ix0*ldy-lny,lz+ix0*ldz-lnz);
			printf(tri3_txt,x+ix0*dx-nx,y+ix0*dy-ny,z+ix0*dz-nz);
		}
		lx = x;
		ly = y;
		lz = z;
		ldx = dx;
		ldy = dy;
		ldz = dz;
		lnx = nx;
		lny = ny;
		lnz = nz;
		s+=M_PI/48.0;	//144 steps 36*4 *1.5
		for (i=0; i<2; i++)
		{
			x = pdiam/2.0  * cos(s);
			y = pdiam/2.0  * sin(s);
			z = -ptwist/2.0 * sin(s*2.0);
			//finn vektor for rotasjon
			a = cos(s/2.0) * cos(s);
			b = cos(s/2.0) * sin(s);
			c = sin(s/2.0);
			//er enhetsvektor ingen justering ndvendig
			//finn vektor langs banen med twist (derriverte av funksjonene til x,y og z
			d = -pdiam*sin(s);
			e = pdiam*cos(s);
			f = -ptwist*2.0*cos(s*2.0);
			//finn enhetsvektoren
			l = sqrt(d*d+e*e+f*f);
			d /= l;
			e /= l;
			f /= l;
			//finn vektor i skjeringpunktet mellom et plan som abc og def ligger
			//i mot et plan vinkelrett def
			dx = d*e*b-e*e*a-f*f*a+d*f*c;
			dy = -d*d*b+d*e*a+e*f*c-f*f*b;
			dz = d*f*a-d*d*c-e*e*c+e*f*b;
			//finn lengden av dxyz vektoren
			l = sqrt(dx*dx+dy*dy+dz*dz);
			//finn normalen til def og dxyz
			nx = bthick/2.01*(dy*f - dz*e);
			ny = bthick/2.01*(dz*d - dx*f);
			nz = bthick/2.01*(dx*e - dy*d);
			//lag en vektor med lengde bwidth/2.0
			dx *= bwidth/2.0/l;
			dy *= bwidth/2.0/l;
			dz *= bwidth/2.0/l;
			//the surface of the edge
			printf(tri1_txt,lx+ix1*ldx+lnx,ly+ix1*ldy+lny,lz+ix1*ldz+lnz);
			printf(tri2_txt,lx+ldx+lnx,ly+ldy+lny,lz+ldz+lnz);
			printf(tri3_txt,x+dx+nx,y+dy+ny,z+dz+nz);
			printf(tri1_txt,lx+ix1*ldx+lnx,ly+ix1*ldy+lny,lz+ix1*ldz+lnz);
			printf(tri2_txt,x+ix1*dx+nx,y+ix1*dy+ny,z+ix1*dz+nz);
			printf(tri3_txt,x+dx+nx,y+dy+ny,z+dz+nz);
			printf(tri1_txt,lx+ix1*ldx-lnx,ly+ix1*ldy-lny,lz+ix1*ldz-lnz);
			printf(tri2_txt,lx+ldx-lnx,ly+ldy-lny,lz+ldz-lnz);
			printf(tri3_txt,x+dx-nx,y+dy-ny,z+dz-nz);
			printf(tri1_txt,lx+ix1*ldx-lnx,ly+ix1*ldy-lny,lz+ix1*ldz-lnz);
			printf(tri2_txt,x+ix1*dx-nx,y+ix1*dy-ny,z+ix1*dz-nz);
			printf(tri3_txt,x+dx-nx,y+dy-ny,z+dz-nz);
			printf(tri1_txt,lx-ix1*ldx+lnx,ly-ix1*ldy+lny,lz-ix1*ldz+lnz);
			printf(tri2_txt,lx-ldx+lnx,ly-ldy+lny,lz-ldz+lnz);
			printf(tri3_txt,x-dx+nx,y-dy+ny,z-dz+nz);
			printf(tri1_txt,lx-ix1*ldx+lnx,ly-ix1*ldy+lny,lz-ix1*ldz+lnz);
			printf(tri2_txt,x-ix1*dx+nx,y-ix1*dy+ny,z-ix1*dz+nz);
			printf(tri3_txt,x-dx+nx,y-dy+ny,z-dz+nz);
			printf(tri1_txt,lx-ix1*ldx-lnx,ly-ix1*ldy-lny,lz-ix1*ldz-lnz);
			printf(tri2_txt,lx-ldx-lnx,ly-ldy-lny,lz-ldz-lnz);
			printf(tri3_txt,x-dx-nx,y-dy-ny,z-dz-nz);
			printf(tri1_txt,lx-ix1*ldx-lnx,ly-ix1*ldy-lny,lz-ix1*ldz-lnz);
			printf(tri2_txt,x-ix1*dx-nx,y-ix1*dy-ny,z-ix1*dz-nz);
			printf(tri3_txt,x-dx-nx,y-dy-ny,z-dz-nz);
			//the surface 1/4 rung
			printf(tri1_txt,lx+ix3*ldx+lnx,ly+ix3*ldy+lny,lz+ix3*ldz+lnz);
			printf(tri2_txt,lx+ix2*ldx+lnx,ly+ix2*ldy+lny,lz+ix2*ldz+lnz);
			printf(tri3_txt,x+ix2*dx+nx,y+ix2*dy+ny,z+ix2*dz+nz);
			printf(tri1_txt,lx+ix3*ldx+lnx,ly+ix3*ldy+lny,lz+ix3*ldz+lnz);
			printf(tri2_txt,x+ix3*dx+nx,y+ix3*dy+ny,z+ix3*dz+nz);
			printf(tri3_txt,x+ix2*dx+nx,y+ix2*dy+ny,z+ix2*dz+nz);
			printf(tri1_txt,lx+ix3*ldx-lnx,ly+ix3*ldy-lny,lz+ix3*ldz-lnz);
			printf(tri2_txt,lx+ix2*ldx-lnx,ly+ix2*ldy-lny,lz+ix2*ldz-lnz);
			printf(tri3_txt,x+ix2*dx-nx,y+ix2*dy-ny,z+ix2*dz-nz);
			printf(tri1_txt,lx+ix3*ldx-lnx,ly+ix3*ldy-lny,lz+ix3*ldz-lnz);
			printf(tri2_txt,x+ix3*dx-nx,y+ix3*dy-ny,z+ix3*dz-nz);
			printf(tri3_txt,x+ix2*dx-nx,y+ix2*dy-ny,z+ix2*dz-nz);
			printf(tri1_txt,lx-ix3*ldx+lnx,ly-ix3*ldy+lny,lz-ix3*ldz+lnz);
			printf(tri2_txt,lx-ix2*ldx+lnx,ly-ix2*ldy+lny,lz-ix2*ldz+lnz);
			printf(tri3_txt,x-ix2*dx+nx,y-ix2*dy+ny,z-ix2*dz+nz);
			printf(tri1_txt,lx-ix3*ldx+lnx,ly-ix3*ldy+lny,lz-ix3*ldz+lnz);
			printf(tri2_txt,x-ix3*dx+nx,y-ix3*dy+ny,z-ix3*dz+nz);
			printf(tri3_txt,x-ix2*dx+nx,y-ix2*dy+ny,z-ix2*dz+nz);
			printf(tri1_txt,lx-ix3*ldx-lnx,ly-ix3*ldy-lny,lz-ix3*ldz-lnz);
			printf(tri2_txt,lx-ix2*ldx-lnx,ly-ix2*ldy-lny,lz-ix2*ldz-lnz);
			printf(tri3_txt,x-ix2*dx-nx,y-ix2*dy-ny,z-ix2*dz-nz);
			printf(tri1_txt,lx-ix3*ldx-lnx,ly-ix3*ldy-lny,lz-ix3*ldz-lnz);
			printf(tri2_txt,x-ix3*dx-nx,y-ix3*dy-ny,z-ix3*dz-nz);
			printf(tri3_txt,x-ix2*dx-nx,y-ix2*dy-ny,z-ix2*dz-nz);
			//the surfacee of middle rung
			printf(tri1_txt,lx-ix4*ldx+lnx,ly-ix4*ldy+lny,lz-ix4*ldz+lnz);
			printf(tri2_txt,lx+ix4*ldx+lnx,ly+ix4*ldy+lny,lz+ix4*ldz+lnz);
			printf(tri3_txt,x+ix4*dx+nx,y+ix4*dy+ny,z+ix4*dz+nz);
			printf(tri1_txt,lx-ix4*ldx+lnx,ly-ix4*ldy+lny,lz-ix4*ldz+lnz);
			printf(tri2_txt,x-ix4*dx+nx,y-ix4*dy+ny,z-ix4*dz+nz);
			printf(tri3_txt,x+ix4*dx+nx,y+ix4*dy+ny,z+ix4*dz+nz);
			printf(tri1_txt,lx-ix4*ldx-lnx,ly-ix4*ldy-lny,lz-ix4*ldz-lnz);
			printf(tri2_txt,lx+ix4*ldx-lnx,ly+ix4*ldy-lny,lz+ix4*ldz-lnz);
			printf(tri3_txt,x+ix4*dx-nx,y+ix4*dy-ny,z+ix4*dz-nz);
			printf(tri1_txt,lx-ix4*ldx-lnx,ly-ix4*ldy-lny,lz-ix4*ldz-lnz);
			printf(tri2_txt,x-ix4*dx-nx,y-ix4*dy-ny,z-ix4*dz-nz);
			printf(tri3_txt,x+ix4*dx-nx,y+ix4*dy-ny,z+ix4*dz-nz);
			//the sides of the middle rung
			printf(tri1_txt,lx-ix4*ldx+lnx,ly-ix4*ldy+lny,lz-ix4*ldz+lnz);
			printf(tri2_txt,x-ix4*dx+nx,y-ix4*dy+ny,z-ix4*dz+nz);
			printf(tri3_txt,x-ix4*dx-nx,y-ix4*dy-ny,z-ix4*dz-nz);
			printf(tri1_txt,lx-ix4*ldx+lnx,ly-ix4*ldy+lny,lz-ix4*ldz+lnz);
			printf(tri2_txt,lx-ix4*ldx-lnx,ly-ix4*ldy-lny,lz-ix4*ldz-lnz);
			printf(tri3_txt,x-ix4*dx-nx,y-ix4*dy-ny,z-ix4*dz-nz);
			printf(tri1_txt,lx+ix4*ldx+lnx,ly+ix4*ldy+lny,lz+ix4*ldz+lnz);
			printf(tri2_txt,x+ix4*dx+nx,y+ix4*dy+ny,z+ix4*dz+nz);
			printf(tri3_txt,x+ix4*dx-nx,y+ix4*dy-ny,z+ix4*dz-nz);
			printf(tri1_txt,lx+ix4*ldx+lnx,ly+ix4*ldy+lny,lz+ix4*ldz+lnz);
			printf(tri2_txt,lx+ix4*ldx-lnx,ly+ix4*ldy-lny,lz+ix4*ldz-lnz);
			printf(tri3_txt,x+ix4*dx-nx,y+ix4*dy-ny,z+ix4*dz-nz);
			//the outer side of the edge
			printf(tri1_txt,lx-ldx+lnx,ly-ldy+lny,lz-ldz+lnz);
			printf(tri2_txt,x-dx+nx,y-dy+ny,z-dz+nz);
			printf(tri3_txt,x-dx-nx,y-dy-ny,z-dz-nz);
			printf(tri1_txt,lx-ldx+lnx,ly-ldy+lny,lz-ldz+lnz);
			printf(tri2_txt,lx-ldx-lnx,ly-ldy-lny,lz-ldz-lnz);
			printf(tri3_txt,x-dx-nx,y-dy-ny,z-dz-nz);
			printf(tri1_txt,lx+ldx+lnx,ly+ldy+lny,lz+ldz+lnz);
			printf(tri2_txt,x+dx+nx,y+dy+ny,z+dz+nz);
			printf(tri3_txt,x+dx-nx,y+dy-ny,z+dz-nz);
			printf(tri1_txt,lx+ldx+lnx,ly+ldy+lny,lz+ldz+lnz);
			printf(tri2_txt,lx+ldx-lnx,ly+ldy-lny,lz+ldz-lnz);
			printf(tri3_txt,x+dx-nx,y+dy-ny,z+dz-nz);
			//the outer side of 1/4 rung
			printf(tri1_txt,lx-ix2*ldx+lnx,ly-ix2*ldy+lny,lz-ix2*ldz+lnz);
			printf(tri2_txt,x-ix2*dx+nx,y-ix2*dy+ny,z-ix2*dz+nz);
			printf(tri3_txt,x-ix2*dx-nx,y-ix2*dy-ny,z-ix2*dz-nz);
			printf(tri1_txt,lx-ix2*ldx+lnx,ly-ix2*ldy+lny,lz-ix2*ldz+lnz);
			printf(tri2_txt,lx-ix2*ldx-lnx,ly-ix2*ldy-lny,lz-ix2*ldz-lnz);
			printf(tri3_txt,x-ix2*dx-nx,y-ix2*dy-ny,z-ix2*dz-nz);
			printf(tri1_txt,lx+ix2*ldx+lnx,ly+ix2*ldy+lny,lz+ix2*ldz+lnz);
			printf(tri2_txt,x+ix2*dx+nx,y+ix2*dy+ny,z+ix2*dz+nz);
			printf(tri3_txt,x+ix2*dx-nx,y+ix2*dy-ny,z+ix2*dz-nz);
			printf(tri1_txt,lx+ix2*ldx+lnx,ly+ix2*ldy+lny,lz+ix2*ldz+lnz);
			printf(tri2_txt,lx+ix2*ldx-lnx,ly+ix2*ldy-lny,lz+ix2*ldz-lnz);
			printf(tri3_txt,x+ix2*dx-nx,y+ix2*dy-ny,z+ix2*dz-nz);
			//the inner side of the edge
			printf(tri1_txt,lx-ix1*ldx+lnx,ly-ix1*ldy+lny,lz-ix1*ldz+lnz);
			printf(tri2_txt,x-ix1*dx+nx,y-ix1*dy+ny,z-ix1*dz+nz);
			printf(tri3_txt,x-ix1*dx-nx,y-ix1*dy-ny,z-ix1*dz-nz);
			printf(tri1_txt,lx-ix1*ldx+lnx,ly-ix1*ldy+lny,lz-ix1*ldz+lnz);
			printf(tri2_txt,lx-ix1*ldx-lnx,ly-ix1*ldy-lny,lz-ix1*ldz-lnz);
			printf(tri3_txt,x-ix1*dx-nx,y-ix1*dy-ny,z-ix1*dz-nz);
			printf(tri1_txt,lx+ix1*ldx+lnx,ly+ix1*ldy+lny,lz+ix1*ldz+lnz);
			printf(tri2_txt,x+ix1*dx+nx,y+ix1*dy+ny,z+ix1*dz+nz);
			printf(tri3_txt,x+ix1*dx-nx,y+ix1*dy-ny,z+ix1*dz-nz);
			printf(tri1_txt,lx+ix1*ldx+lnx,ly+ix1*ldy+lny,lz+ix1*ldz+lnz);
			printf(tri2_txt,lx+ix1*ldx-lnx,ly+ix1*ldy-lny,lz+ix1*ldz-lnz);
			printf(tri3_txt,x+ix1*dx-nx,y+ix1*dy-ny,z+ix1*dz-nz);
			//the inner side of 1/4 rung
			printf(tri1_txt,lx-ix3*ldx+lnx,ly-ix3*ldy+lny,lz-ix3*ldz+lnz);
			printf(tri2_txt,x-ix3*dx+nx,y-ix3*dy+ny,z-ix3*dz+nz);
			printf(tri3_txt,x-ix3*dx-nx,y-ix3*dy-ny,z-ix3*dz-nz);
			printf(tri1_txt,lx-ix3*ldx+lnx,ly-ix3*ldy+lny,lz-ix3*ldz+lnz);
			printf(tri2_txt,lx-ix3*ldx-lnx,ly-ix3*ldy-lny,lz-ix3*ldz-lnz);
			printf(tri3_txt,x-ix3*dx-nx,y-ix3*dy-ny,z-ix3*dz-nz);
			printf(tri1_txt,lx+ix3*ldx+lnx,ly+ix3*ldy+lny,lz+ix3*ldz+lnz);
			printf(tri2_txt,x+ix3*dx+nx,y+ix3*dy+ny,z+ix3*dz+nz);
			printf(tri3_txt,x+ix3*dx-nx,y+ix3*dy-ny,z+ix3*dz-nz);
			printf(tri1_txt,lx+ix3*ldx+lnx,ly+ix3*ldy+lny,lz+ix3*ldz+lnz);
			printf(tri2_txt,lx+ix3*ldx-lnx,ly+ix3*ldy-lny,lz+ix3*ldz-lnz);
			printf(tri3_txt,x+ix3*dx-nx,y+ix3*dy-ny,z+ix3*dz-nz);
			lx = x;
			ly = y;
			lz = z;
			ldx = dx;
			ldy = dy;
			ldz = dz;
			lnx = nx;
			lny = ny;
			lnz = nz;
			if (i==1)
				s+=M_PI/72.0;	//144 steps 36*4
			else
				s+=M_PI/48.0;	//144 steps 36*4 *1.5
		}
	}
	//surface of last bit
	printf(tri1_txt,lx-ldx+lnx,ly-ldy+lny,lz-ldz+lnz);
	printf(tri2_txt,lx+ldx+lnx,ly+ldy+lny,lz+ldz+lnz);
	printf(tri3_txt,fx+fdx-fnx,fy+fdy-fny,fz+fdz-fnz);
	printf(tri1_txt,lx-ldx+lnx,ly-ldy+lny,lz-ldz+lnz);
	printf(tri2_txt,fx-fdx-fnx,fy-fdy-fny,fz-fdz-fnz);
	printf(tri3_txt,fx+fdx-fnx,fy+fdy-fny,fz+fdz-fnz);
	printf(tri1_txt,lx-ldx-lnx,ly-ldy-lny,lz-ldz-lnz);
	printf(tri2_txt,lx+ldx-lnx,ly+ldy-lny,lz+ldz-lnz);
	printf(tri3_txt,fx+fdx+fnx,fy+fdy+fny,fz+fdz+fnz);
	printf(tri1_txt,lx-ldx-lnx,ly-ldy-lny,lz-ldz-lnz);
	printf(tri2_txt,fx-fdx+fnx,fy-fdy+fny,fz-fdz+fnz);
	printf(tri3_txt,fx+fdx+fnx,fy+fdy+fny,fz+fdz+fnz);
	//the sides of last bit (no need for smooth_triangle it is completely flat)
	printf(tri1_txt,lx-ldx+lnx,ly-ldy+lny,lz-ldz+lnz);
	printf(tri2_txt,lx+ldx+lnx,ly+ldy+lny,lz+ldz+lnz);
	printf(tri3_txt,lx+ldx-lnx,ly+ldy-lny,lz+ldz-lnz);
	printf(tri1_txt,lx-ldx-lnx,ly-ldy-lny,lz-ldz-lnz);
	printf(tri2_txt,lx-ldx+lnx,ly-ldy+lny,lz-ldz+lnz);
	printf(tri3_txt,lx+ldx-lnx,ly+ldy-lny,lz+ldz-lnz);
	printf(tri1_txt,fx-fdx-fnx,fy-fdy-fny,fz-fdz-fnz);
	printf(tri2_txt,fx+fdx-fnx,fy+fdy-fny,fz+fdz-fnz);
	printf(tri3_txt,fx+fdx+fnx,fy+fdy+fny,fz+fdz+fnz);
	printf(tri1_txt,fx-fdx-fnx,fy-fdy-fny,fz-fdz-fnz);
	printf(tri2_txt,fx-fdx+fnx,fy-fdy+fny,fz-fdz+fnz);
	printf(tri3_txt,fx+fdx+fnx,fy+fdy+fny,fz+fdz+fnz);
	//edge of last bit
	printf(tri1_txt,lx-ldx-lnx,ly-ldy-lny,lz-ldz-lnz);
	printf(tri2_txt,fx+fdx+fnx,fy+fdy+fny,fz+fdz+fnz);
	printf(tri3_txt,fx+fdx-fnx,fy+fdy-fny,fz+fdz-fnz);
	printf(tri1_txt,lx-ldx+lnx,ly-ldy+lny,lz-ldz+lnz);
	printf(tri2_txt,lx-ldx-lnx,ly-ldy-lny,lz-ldz-lnz);
	printf(tri3_txt,fx+fdx-fnx,fy+fdy-fny,fz+fdz-fnz);
	printf(tri1_txt,lx+ldx+lnx,ly+ldy+lny,lz+ldz+lnz);
	printf(tri2_txt,fx-fdx+fnx,fy-fdy+fny,fz-fdz+fnz);
	printf(tri3_txt,fx-fdx-fnx,fy-fdy-fny,fz-fdz-fnz);
	printf(tri1_txt,lx+ldx+lnx,ly+ldy+lny,lz+ldz+lnz);
	printf(tri2_txt,lx+ldx-lnx,ly+ldy-lny,lz+ldz-lnz);
	printf(tri3_txt,fx-fdx+fnx,fy-fdy+fny,fz-fdz+fnz);
	printf("}\n");
}
#endif SMOOTHE
#endif QUICK

void main(void)
{
	baand();
#ifdef SMOOTHE
#ifndef QUICK
	printf("\n\n");
	indre_baand();
#endif QUICK
#endif SMOOTHE
}