//	Band van Mbius II, M.C.Escher
//	by Knut Roll-Lund (c)2001

#include "colors.inc"
#include "textures.inc"
#include "fov.inc"

#declare IMPORT_SPATCH = 1;

#include "baand.inc"
sky_sphere {
        pigment { color SkyBlue }
        pigment {
                bozo
                turbulence 0.65
                octaves 6
                omega 0.7
                lambda 2
                color_map {
                        [0.0 0.1 color rgb <0.85, 0.85, 0.85> color rgb <0.8, 0.8, 0.8>]
                        [0.1 0.3 color rgb <0.8, 0.8, 0.8> color rgbt <0.75, 0.75, 0.75, 0.2>]
                        [0.3 0.5 color rgbt <0.75, 0.75, 0.75, 0.2> color rgbt <1, 1, 1, 1>]
                        [0.5 1.0 color rgbt <1, 1, 1, 1> color rgbt <1, 1, 1, 1>]
                }
                scale <0.04, 0.04, 0.1>
        }
        rotate <0, 90, 10>
}

#declare eyes =
texture {
	pigment { rgb < 0, 0, 0 > }
	finish { reflection 0.75 phong 1 }
}

#declare ants =
texture {
        pigment {
                agate //marble
                turbulence 1
                color_map {
                        [0.0 rgb <0.9, 0.28, 0.25>]
                        [0.92 rgb <0.9, 0.28, 0.25>]
                        [1.0 rgb <0.85, 0.25, 0.23>]
                }
        }
        scale <0.5, 0.5, 0.5>
    normal {
      granite
      scale 0.07
      bump_size 0.03
    }
    finish {
      ambient 0.2
      phong 0.4//diffuse 1
    }
}

#declare m2 = 80;
#declare m2s = radians(m2);
#declare m2A =-m2/2;
#declare m2B =-33.7*cos(m2s*2);   //30.07016
#declare m2C = 90-m2;

#declare m3 = 160;
#declare m3s = radians(m3);
#declare m3A =-m3/2;
#declare m3B =-33.7*cos(m3s*2);
#declare m3C = 90-m3;

#declare m4 = 240;
#declare m4s = radians(m4);
#declare m4A =-m4/2;
#declare m4B =-33.7*cos(m4s*2);
#declare m4C = 90-m4;

#declare m5 = 320;
#declare m5s = radians(m5);
#declare m5A =-m5/2;
#declare m5B =-33.7*cos(m5s*2);
#declare m5C = 90-m5;

#declare m6 = 400;
#declare m6s = radians(m6);
#declare m6A =-m6/2;
#declare m6B =-33.7*cos(m6s*2);
#declare m6C = 90-m6;

#declare m7 = 480;
#declare m7s = radians(m7);
#declare m7A =-m7/2;
#declare m7B =-33.7*cos(m7s*2);
#declare m7C = 90-m7;

#declare m8 = 560;
#declare m8s = radians(m8);
#declare m8A =-m8/2;
#declare m8B =-33.7*cos(m8s*2);
#declare m8C = 90-m8;

#declare m9 = 640;
#declare m9s = radians(m9);
#declare m9A =-m9/2;
#declare m9B =-33.7*cos(m9s*2);
#declare m9C = 90-m9;

camera {
	location <200, 0, 0>    //ring seen along x-axis "side" Esher's view
	up <1, 0, 0>		// The Z axis is up and
	right <1/2, 0, 0>	        // The X axis is right (1/2 aspect)
	direction <0,0,5>       // Field of view 22.5 degrees 1/tan(angle/2) matches 200,0,0 location
	sky <0, 1, 0>
	look_at <0, 0, 0>
}

light_source { <50, 100,100> color White }      //over left
light_source { <50, 100,-100> color White }     //over right
light_source { <100, 100,0> color White*0.8 }   //"right" side

//remove most of the sky, reflection in ants eyes looks bad (vashy)
//I like the liquidy reflective black better
object {
        sphere { <0,0,0>, 200 hollow }
        //make opening just big enough to cover background
        clipped_by {
                plane { -x, 195 }
        }
        pigment { color Black }
        finish { ambient 0 phong 0 }
}

object {
	baand
        texture {
                pigment { DMFLightOak }
                scale <0.2, 0.2, 0.2>
	        finish { ambient 0.3 specular 0.2 roughness 0.15 }
        }
}

union {
#include "maur1.pov"
	rotate <0, -32, 90>
	translate <-15.6, 0, 0>
}

union {
#include "maur2.pov"
        rotate <m2A, m2B, m2C>
	translate <-15*cos(m2s), 15*sin(m2s), 5*sin(m2s*2)>
}

union {
#include "maur3.pov"
        rotate <m3A, m3B, m3C>
	translate <-15*cos(m3s), 15*sin(m3s), 5*sin(m3s*2)>
}

union {
#include "maur4.pov"
        rotate <m4A, m4B, m4C>
	translate <-15*cos(m4s), 15*sin(m4s), 5*sin(m4s*2)>
}

union {
#include "maur5.pov"
        rotate <m5A, m5B, m5C>
	translate <-15*cos(m5s), 15*sin(m5s), 5*sin(m5s*2)>
}

union {
#include "maur6.pov"
        rotate <m6A, m6B, m6C>
	translate <-15*cos(m6s), 15*sin(m6s), 5*sin(m6s*2)>
}

union {
#include "maur7.pov"
        rotate <m7A, m7B, m7C>
	translate <-15*cos(m7s), 15*sin(m7s), 5*sin(m7s*2)>
}

union {
#include "maur8.pov"
        rotate <m8A, m8B, m8C>
	translate <-15*cos(m8s), 15*sin(m8s), 5*sin(m8s*2)>
}

union {
#include "maur9.pov"
        rotate <m9A, m9B, m9C>
	translate <-15*cos(m9s), 15*sin(m9s), 5*sin(m9s*2)>
}