// Persistence of Vision Ray Tracer Scene Description File
// File:   tg_hunt.pov
// Vers:   3.1
// Desc:   The hunt in the Temple of the Spider
// Date: 06/20/2001    (20.06.2001)
// Auth: Thomas de Groot


#include "colors.inc"
// From Specific Includes:
#include "RomanStones.inc"
#include "TexturesExtra.inc"
// From The Hunt directory:
#include "RoundedColumn.inc"
#include "ik_spider.inc"
#include "HangingChain1.inc"
#include "HangingChain2.inc"
#include "RunningMale.inc"

default {
  texture {pigment {color <1,0,0>}}
}


camera {  //  Camera StdCam
 right      < 1.33, 0, 0 >
 up         < 0, 1, 0 >
 direction  < 0, 0, 1 >
 location   <-12, 1.4, -4>
 look_at    <0, 1.4, 0>
// location   <-12, 8.5, -4>
// look_at    <-5, 1.5, 0>
 angle 75
}

global_settings {
 assumed_gamma 1.9
 ambient_light rgb<0.975,0.975,0.838>
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

//
// *******  TEMPORARY TEST SETTINGS *******
//
// Temporary Background:
//background { color <0.643,1.000,1.000> }

// Temporary floor:
//plane { y, 0
//   pigment { Gray50 } 
//}

//
// *******  FOG SETTINGS *******
//
// FOG gives a natural looking haze effect.
fog { color Black distance 50 }

fog {
  fog_type 2    // Ground Fog
  distance     3 // was: 5.0
  color <0.686275,0.6,0.6,0.7,0.6>
  turbulence   <0.12, 0.8, 0.12>
    octaves    2 // best: 1-10 (default=6)
    lambda     2.0
    omega      0.5 // (default=0.5)
    turb_depth 10.1 // (default=0.5)
  up           <0,1,0>
  fog_offset   -0.1 // was:0.5
  fog_alt      0.2  // was: 0.15
}

//
// *******  L I G H T S *******
//
// Backlight:
light_source {
  //<-20, 20, -4>
  //color rgb <1.000, 1.000, 1.000>*0.95
  < -15, 2, -4 >
  color rgb <0.975,0.975,0.838>*0.3
  fade_distance  5.0
  fade_power 1.0
  shadowless
}


#declare Lamp =
 union {
  sphere { < 0, 0, 0 >, 0.1
   scale < 1, 2, 1 >
   translate < 0, 2, 0 >
   texture { Glass
    }
   interior { I_Glass
    //fade_distance  4.0
    //fade_power 1.0
   }
   hollow
  }
  union {
   cylinder { < 0, 2.32, 0>, < 0, 50, 0>, 0.03 }    // hanging version
   //cylinder { < 0, 0, 0>, < 0, 1.75, 0>, 0.03 }  // standing version
   //cylinder { < 0, 0, 0>, < 0, 0.1, 0>, 0.4 }    // standing version
   torus { 0.3, 0.02
    rotate 90*x
    translate < 0, 2, 0 >
   }
   torus { 0.3, 0.02
    rotate 90*z
    translate < 0, 2, 0 >
   }
   rotate 45*y
   texture { TM_Brass_Metal }
  }

  light_source { < 0, 2, 0 > // Lamplight
   color rgb <0.975,0.975,0.838>*1.5
   area_light <0.1, 0, 0>, <0, 0, 0.1>, 3, 3
   adaptive 1
   jitter
   fade_distance 3.0
   fade_power 1.0
  }
 }

#declare sky_vect = <0.00000, 1.00000, 0.00000>;
#declare cam_loc = <-12, 1.4, -4>;  // using camera 'StdCam'
#declare lookat = <0, 1.4, 0>;
#declare light_loc = < -3, 3, -2 >;  // hanging version, using light source 'Light1'
//#declare light_loc = < -3, 2, -2 >;  // standing version, using light source 'Light1'
#declare flare_size = 1.2;
#declare bright_background = 0;
#declare source_color = <0.975,0.975,0.838>;
#declare flare_brightness = <0.686275,0.6,0.6>;
// Note: if the following two lines cause an error, make sure that
// you have the NKFlare\ subdirectory in the directory where you are
// exporting POV-files to.
#include "SmlStar.flr"
#include "nkflare.inc"

object { Lamp
 rotate 15*y
 translate <-3,1,-2>    // hanging version
 //translate <-3,0,-2>  // standing version
} 

//
// ********  OBJECTS  *******
//

#declare Chapiteau = 
union {
 box {                                // Partie_Suprieure
   <-0.55, 0, -0.55>, <0.55, 0.55, 0.55>
 }
 intersection {                       // Partie_Infrieure
  box {
    <-0.55, -0.8, -0.55>, <0.55, 0, 0.55>
  }
  sphere {
    <0,0,0>,0.8
  }
 }
}

#declare Chapiteaux =
union {
  object {Chapiteau translate 4*y}
  object {Chapiteau translate 8*y}
  object {Chapiteau translate 12*y}
  object {Chapiteau translate 16*y}
  object {Chapiteau translate 20*y}
  box {<-0.55,-0.1,-0.55>,<0.55,0.2,0.55>}
}

// Rectangular array of columns:
#declare Sx = seed(15895);
#declare Sy = seed(23513);
#declare Sz = seed(58121);
#declare J=-10;
#render "Starting the array of columns...\n"
 #while (J<100)
  #declare I=-15;
   #while (I<100)
      union {
        object { RoundedColumn
          rotate <0, rand(Sy), 0>
        }
        object { Chapiteaux
          texture { TdG_RuggedSandstone
            rotate <0, rand(Sy), 0>
            translate <rand(Sx), rand(Sy), rand(Sz)>
          }
        }
        translate <I,0,J>
      }
      #declare I=I+5;
   #end
  #declare J=J+5;
#end
#render "...finished\n"

//
// ********  FLOOR  *******
//
#declare FloorCement= texture {pigment {color Tan}}
plane { y, -0.1
   texture { brick 
    //texture {FrostedT_Stone7}
    texture {FloorCement}
    texture {CF_RoughStone}
    brick_size <0.5, 0.3, 0.3>
    mortar 0.01
    rotate 90*x
   }
}


//
// ********  FLAGSTONES  *******
//

#declare OriginX=-13;
#declare OriginZ=-8;
#declare EndX=10;
#declare EndZ=5;
#declare N=46;
#declare R=0.5;
//#declare Crack=0.00;
#declare Pattern=2;
#render "Starting the Cobblestones....\n"
#include "C:\VirtualReality\Data files\POV-Ray files\Specific Includes\Thomas de Groot\Cobblestones\Cobblestones.inc"
object {Cobblestones}
#render "....finished\n"

//
// ********  SPIDER  *******
//
#render "Starting the spider...\n"
object {NewSpider
 scale 0.8
 rotate <0,97,0>
 translate <-6.5,0.0,-1.0>
}

//
// ********  SPIDERWEB  *******
//

object {#declare web_type = 3;
 #declare web_seed = 234432;
 #declare web_circles_count = 16;
 #declare thread_tightness = 0.3;
 #declare thread_thickness = 0.008;
 #render "... and the spiderweb....\n"
 #include "SpiderWeb.inc"
 scale 1.4
 rotate 45*y
 translate <8,11.5,-2>
 material {TdG_Glimmer}
}

//
// ********  HANGING CHAINS  *******
//

#render "... and the hanging chains....\n"
object {RustyChain1 //Coiled on the ground
 scale 0.1
 rotate -130*y
 translate <-8,4.8295,-4.6>
}


object {RustyChain2 //Free hanging
 scale 0.1
 translate <-10.5,5.5,-2.6>
}


//
// ********  RUNNING FIGURE  *******
//

#render "... and the running figure....\n"
object {RunningMale
 rotate <0, 120, 0>
 translate <0.0, 0.0, -3.1>
}
#render "....finished\n"
