#version unofficial Megapov 0.7;

global_settings{
        assumed_gamma 1
        max_trace_level 32  
        //ini_option "+QR"
        radiosity{
                pretrace_start 0.08
                pretrace_end   0.01
                count 150                
                nearest_count 8      
                error_bound 0.1      
                recursion_limit 3    
                low_error_factor 0.5  
                gray_threshold 0  
                minimum_reuse 0.01 
                brightness 1      
                adc_bailout 0.006
                normal on
                media on  
                }
}        

#include "colors.inc"

#include "globallightNeu.inc"
camera {location <0,6,-27> look_at 0 angle 43}
light_source{<-15000,15000,-1000>,<1,0.93,0.85>*7}


sky_sphere {
   pigment {
      gradient y
      color_map {
         [0.0 color (LightBlue+SteelBlue)/3]
         [0.6 color rgb <0,0,0.25>+(SkyBlue)/2]
      }
   } scale 1.5 translate -0.14
}
   
sphere {0, 1 hollow
   pigment {
      bozo
      turbulence 0.8
      octaves 3
      lambda 4
      color_map {
         [0.0 0.4 color rgbf 1 color rgbf 1]
         [0.8 color rgbf <1,1,1,0.8>]
         [1.0 color rgbf <1,1,1,0.4>]
      }
      scale <0.1667,1,0.1667>*2
   }
   finish {ambient 1.667 diffuse 0}
   scale <25000, 2500, 25000>*100
}


#declare Erde = 
texture {
  pigment { colour rgb <0.15,0.135,0.1> }}
texture {
  pigment { granite color_map {
      [0.00 color rgb <0.945, 0.863, 0.396+0.15>/4]
      [0.11 color rgbf<0.953, 0.678, 0.404+0.15, 0.086*4>/4]
      [0.24 color rgbf<0.886, 0.651, 0.157+0.15, 0.329*4>/4]
      [0.49 color rgb <0.910, 0.588, 0.220+0.15>/4]
      [0.78 color rgbf<0.933, 0.784, 0.627, 0.196*4>/4]
      [1.00 color rgbf<1.000, 1.000, 1.000, 0.996*4>/4]}}}
texture {
  pigment { granite turbulence 0.49 color_map {
      [0.00 color rgbf<0.549, 0.369, 0.024+0.15, 0.388*4>/4]
      [0.20 color rgb <0.961, 0.773, 0.341+0.15>/4]
      [0.52 color rgbf<0.655, 0.365, 0.086+0.15, 0.098*4>/4]
      [0.75 color rgbf<0.918, 0.647, 0.349+0.15, 0.369*4>/4]
      [1.00 color rgbf<0.439, 0.275, 0.027+0.15, 0.729*4>/4]}
    scale <2.0, 2.0, 2.0>/4}}                              

height_field{ png "hfInsect5.png" smooth         
        translate <-1,-1,-1>/2
        scale <34.4,-0.32,34.4>
        texture {Erde}
        normal{granite}
        finish{ ambient 0.03 diffuse 0.7 phong 0.5 crand 0.5 }}
                
                                  
#declare watermat=      
  material {     
    texture {
      pigment { rgbt <0.2+0.02, 0.22, 0.21-0.13, 0.8*1.5>/1.5 } 
      finish { ambient 0.0 diffuse 0.01 specular 1.35 roughness 0.06 reflection_type 1 conserve_energy metallic 0.5 }}   
    interior { ior 1.43 fade_distance 0.03 fade_power 1001 fade_color <0.6+0.1, 0.8, 0.2>*0.7}}        

        
height_field{ png "water-hf2.png" smooth          
        translate <-1,-1,-1>/2
        scale <4.3,0.002,4.3>*8
        material {watermat}}

 
#declare map3  = pigment { image_map { png "hfInsect5.png"       } rotate x*90 translate <-1,-1,-1>/2 scale <4.3,-0.04,4.3>*8 } 
#declare map4  = pigment { image_map { png "hfInsectsnadler.png" } rotate x*90 translate <-1,-1,-1>/2 scale <4.3,-0.04,4.3>*8 }
#declare map3a = pigment { image_map { png "hfInsect5blume1.png" } rotate x*90 translate <-1,-1,-1>/2 scale <4.3,-0.04,4.3>*8 }
#declare map6  = pigment { image_map { png "hfInsectBlume1.png"  } rotate x*90 translate <-1,-1,-1>/2 scale <4.3,-0.04,4.3>*8 }
#declare map9  = pigment { image_map { png "hffarnKlein.png"     } rotate x*90 translate <-1,-1,-1>/2 scale <4.3,-0.04,4.3>*8 }
#declare map10 = pigment { image_map { png "hfgrossGras.png"     } rotate x*90 translate <-1,-1,-1>/2 scale <4.3,-0.04,4.3>*8 }
#declare map11 = pigment { image_map { png "hfbutterfly.png"     } rotate x*90 translate <-1,-1,-1>/2 scale <4.3,-0.04,4.3>*8 }        
#declare map12 = pigment { image_map { png "hfInsectsRand2.png"  } rotate x*90 translate <-1,-1,-1>/2 scale <4.3,-0.04,4.3>*8 }    
        

height_field{ png "hfback5.png" smooth         
        translate <-1,-1,-1>/2
        scale <34.4,-0.32/3,34.4>*3
        translate <0,0,68.8>
        texture {Erde}
        normal{granite}
        finish{phong .5 crand .5 ambient .05 diffuse .7}}


height_field{ png "water-hf2.png" smooth          
        translate <-1,-1,-1>/2
        scale <34.4,0.016/3,34.4>*3
        translate <0,0,68.8>
        material {watermat}}

#declare map8 = pigment { image_map { png "hfBack5.png"  } rotate x*90 translate <-1,-1,-1>/2 scale <34.4,-0.32/3,34.4>*3 }

#include "Bewuchs.inc"


#declare tree = union {          
  sphere{<0,-40,0>,100 scale<0.4,0,0.4>}
  sphere{<0,40,0>,30 } 
  sphere{<30,15,0>,60 scale <1,0.1,0.4> rotate <0,0,-30>} 
  sphere{<-30,50,0>,60 scale <1,0.1,0.4> rotate <0,0,-30>} 
  sphere{<0,0,0>,120 scale <0.2,1,0.2> rotate <0,0,15>} 
  sphere{<0,0,0>,120 scale<.1,1,.1> rotate <0,0,-20>} 
  sphere{<-30,20,-20>,30 } 
  sphere{<30,20,10>,30 } 
  texture {
        pigment { bozo turbulence .5 omega .75
                    color_map { [0.0 rgbf <0.06,0.1,0.06,0>]
                                [0.5 rgbf <0.33,0.4,0.33,0>]
                                [0.6 rgbf 1]
                                [1.0 rgbf 1] } scale 8 }
        normal { wrinkles }
        finish { ambient 0.2 diffuse 0.45 specular 0.02 crand 0.1 }}
  scale 0.3} 

 
#declare yy = seed(4844);      
#declare xx = -900;
#while (xx < 150)      
  object{tree  scale <1,1.6,1>*0.06 rotate<0,rand(yy)*360,0> translate<xx + rand(yy)*3,-0.5+pow(rand(yy),2)*2,120.4>}    
  #declare xx = xx + 5/16;
#end
