//                                    7C                                      \\
//                                IRTC Entry                                  \\
//                            Summer Round  2001                              \\

//                            by Elias Pschernig                              \\

//                               www.irtc.org                                 \\

//  mail: elias@users.sourceforge.net             web: www.elias.f2s.com/pov  \\

// Candle Include File

#version unofficial megapov 0.7;

#include "flame.inc"

#declare G = seed(021078);

#declare m_blackmetal = material {
   texture {
      pigment {
         color rgb <.3, .1, .1>
      }
      finish {
         ambient 0
         diffuse 0.9
         specular .6
         roughness 0.01
         reflection 0.1
         brilliance 1
      }
   }
}

#declare m_candle = material {
   texture {
      pigment {
         bumps
         color_map {
            [0 rgb <0.9, 0.7, 0.1>]
            [0.8 rgb <0.7, 0.9, 0.5>]
            [1 rgb <1, 0.4, 0.0>]
         }
      }
      finish {
         ambient 0
         diffuse 0.5
         specular 0.4
         brilliance 0.5
      }
      normal {
         ripples
         scale 0.1
      }
   }
   texture {
      pigment {
         gradient y
         color_map {
            [0.7 rgbf 1]
            [1 rgbf <1, 0.4, 0.0, 0>]
         }
         turbulence 0.4
         scale 2
         triangle_wave
      }
      finish {
         ambient 1
         diffuse 0
      }
   }
}

#macro placeCandle(Object, Place, Color, ColorL)
   #local Norm = <0, 0, 0>;
   #local Pos = trace(Object, Place + y, -y, Norm);
   #if(Norm.x | Norm.y | Norm.z)

      #local Len = 0.3;
      #set Norm = vnormalize(Norm);

      #local N6 = 0;
      #while(N6 < 6)
         cylinder {

            #local H = Len + sin(N6) * 0.02;

            0 y 1
            material { m_candle }
            scale <0.02, H, 0.02>

            translate z * 0.03
            rotate y * 360 * N6 / 6

            #local Dir = vcross(x, Norm);
            #local V3 = vcross(Norm, Dir);

            matrix <V3.x V3.y V3.z,
                    Norm.x Norm.y Norm.z,
                    Dir.x Dir.y Dir.z,
                    Pos.x Pos.y Pos.z>

         }
         #set N6 = N6 + 1;
      #end

      sphere {
         0 1
         hollow
         material_flame(0.5, 10, rgb Color, rgb ColorL, 2.2, 1, 2, 1.2, 0, 0, rand(G) * 0.5)
         scale <0.15, .4, 0.15>
         translate Pos + Norm * Len + y * 0.3
         no_shadow
      }

      light_source {
         0 ColorL
         fade_distance 1
         fade_power 3
         translate Pos + Norm * 0.5 + y * 0.5
      }
   #end
#end          

/* POV-Ray Scene File for the Internet Raytracing Competition Summer 2001

 #macro C(X,Y)cylinder{X*x<X,0,-Y/2>.1}#end#macro U(R,X,Y)intersection{torus{.9
 .1}box{-1 0rotate y*R*90}translate<X,0,Y>scale 1-z*.5}#end union{U(0,0,0)U(1,0
 ,0)U(2,-1,-1)U(1,1,0)U(1,1.5,-3)U(1,2,0)U(3,1,0)U(2,2,0)U(0,3,0)U(3,2,.5)C(.1,
 2)C(.8,1)C(.8,-1)C(1.1,1)C(1.9,-1)pigment{rgb 10}rotate x*90translate<-1,0,4>}
 
created by Elias Pschernig elias@users.sourceforge.net*/     