//                                    7C                                      \\
//                                IRTC Entry                                  \\
//                            Summer Round  2001                              \\

//                            by Elias Pschernig                              \\

//                               www.irtc.org                                 \\

//  mail: elias@users.sourceforge.net             web: www.elias.f2s.com/pov  \\

// Column Include
   
#version unofficial megapov 0.7;   
   
#debug "column "
#debug str(start_chrono, 0, 0)
#debug ":"
#debug str(current_chrono, 0, 0)
#debug "\n"

#declare Length = Radius * 2 * pi / Width;
#declare Height = int(ceil(Total / Length) );

// row - column arrays of points and normals
#local P = array[Height][Width]
#local NORM = array[Height][Width]

/*-----------------------------------------------------------------------------
   Calculate points
-----------------------------------------------------------------------------*/

/*

   Index coordinates are like this:  (M/N)

     /\      /\      /\      /\
    /  \    /  \    /  \    /  \
   /    \  /    \  /    \  /    \
  /______\/______\/______\/______\
         /\      /\      /\      /\2/0
        /  \    /  \    /  \    /  \
       /    \  /    \  /    \  /    \
      /______\/______\/______\/______\
             /\      /\      /\      /\1/0
            /  \    /  \    /  \    /  \
           /    \  /    \  /    \  /    \
          /______\/______\/______\/______\
                   0/3     0/2     0/1     0/0

*/

#declare G = seed(781002);

#local M = 0; // Y - Axis
#while(M < Height)
   #local N = 0; // Revolution
   #while(N < Width)

      // Convert from index M/N to cylinder coordinates Mi/Ni
      #local Mi = M;
      #local Ni = N + M / 2;
      #if(Ni >= Width)
         #set Ni = Ni - Width;
      #end

      // Convert from cylinder coordinates Mi/Ni to Euklidean coordinates X/Y/Z
      #local X = cos(2 * pi * Ni / Width) * Radius;
      #local Z = sin(2 * pi * Ni / Width) * Radius;
      #local Y = Total * Mi / Height;

      #local Mid = <0, Y, 0>;

      #if(Y < 1)
         #local Mid = <0, 1.5, 0>;

         #local Pos = <X, 0, Z>;
         #set Pos = vaxis_rotate(Pos, vcross(Pos, y), (Y ^ 0.5) * 90 - 90);
         #set X = Pos.x;
         #set Y = 1 + Pos.y * 0.5;
         #set Z = Pos.z;
      #end

      #local Temp = <X, Y, Z>;

      #local V = eval_pattern(ripples, Temp);

      //#set V = V * (0.5 + 0.5 * noise3d(<X, Y, Z>));

      #set V = 1 + V * 0.3;

      #set X = Mid.x + (X - Mid.x) * V;
      #set Y = Mid.y + (Y - Mid.y) * V;
      #set Z = Mid.z + (Z - Mid.z) * V;

      #local V = eval_pattern(crackle, 3 * Temp);

      #set V = 1 + V * 0.1;

      #set X = Mid.x + (X - Mid.x) * V;
      #set Y = Mid.y + (Y - Mid.y) * V;
      #set Z = Mid.z + (Z - Mid.z) * V;

      #declare P[M][N] = <X, Y, Z>;

      #set N = N + 1;
   #end
   #debug "point "
   #debug str(M,0,0)
   #debug " / "
   #debug str(Height - 1, 0, 0)
   #debug "\n"
   #set M = M + 1;
#end

#macro Normal(Point, Point1, Point2)
   vcross(Point1 - Point, Point2 - Point)
#end

/*-----------------------------------------------------------------------------
   Calculate averaged weighted normals
-----------------------------------------------------------------------------*/
#local M = 0;
#while(M < Height)
   #local N = 0;
   #while(N < Width)

      #local N1 = N + 1;
      #if(N1 = Width) #set N1 = 0; #end

      #local N_ = N - 1;
      #if(N_ = -1) #set N_ = Width - 1; #end


      #local NORM0 = 0;

      #if(M < Height - 1)
         #local NORM1 = Normal(P[M][N], P[M    ][N_], P[M + 1][N_]);
         #local NORM2 = Normal(P[M][N], P[M + 1][N_], P[M + 1][N ]);
         #local NORM3 = Normal(P[M][N], P[M + 1][N ], P[M    ][N1]);
         #local NORM0 = NORM0 + NORM1 +
                                NORM2 +
                                NORM3;
      #end

      #if(M > 0)
         #local NORM4 = Normal(P[M][N], P[M    ][N1], P[M - 1][N1]);
         #local NORM5 = Normal(P[M][N], P[M - 1][N1], P[M - 1][N ]);
         #local NORM6 = Normal(P[M][N], P[M - 1][N ], P[M    ][N_]);
         #local NORM0 = NORM0 + NORM4 +
                                NORM5 +
                                NORM6;
      #end

      #set NORM0 = NORM0;
      #declare NORM[M][N] = NORM0;

      #set N = N + 1;
   #end
   #debug "normal "
   #debug str(M,0,0)
   #debug " / "
   #debug str(Height - 1, 0, 0)
   #debug "\n"
   #set M = M + 1;
#end

/*-----------------------------------------------------------------------------
   Place triangles
-----------------------------------------------------------------------------*/

#declare smooth_surface = mesh {
   #local M = 0;
   #while(M < Height - 1)
      #local N = 0;
      #while(N < Width)

         #local N1 = N + 1;
         #if(N1 = Width) #set N1 = 0; #end

         smooth_triangle {
            P[M][N] NORM[M][N]
            P[M + 1][N] NORM[M + 1][N]
            P[M][N1] NORM[M][N1]
         }

         smooth_triangle {
            P[M + 1][N1] NORM[M + 1][N1]
            P[M][N1] NORM[M][N1]
            P[M + 1][N] NORM[M + 1][N]
         }

         #set N = N + 1;
      #end
      #debug "smooth triangle "
      #debug str(M, 0, 0)
      #debug " / "
      #debug str(Height - 2, 0, 0)
      #debug "\n"
      #set M = M + 1;
   #end
}

#debug "time used is "
#debug str(current_chrono, 0, 0)
#debug " ticks\n"    

/* POV-Ray Scene File for the Internet Raytracing Competition Summer 2001

 #macro C(X,Y)cylinder{X*x<X,0,-Y/2>.1}#end#macro U(R,X,Y)intersection{torus{.9
 .1}box{-1 0rotate y*R*90}translate<X,0,Y>scale 1-z*.5}#end union{U(0,0,0)U(1,0
 ,0)U(2,-1,-1)U(1,1,0)U(1,1.5,-3)U(1,2,0)U(3,1,0)U(2,2,0)U(0,3,0)U(3,2,.5)C(.1,
 2)C(.8,1)C(.8,-1)C(1.1,1)C(1.9,-1)pigment{rgb 10}rotate x*90translate<-1,0,4>}
 
created by Elias Pschernig elias@users.sourceforge.net*/  