//                                    7C                                      \\
//                                IRTC Entry                                  \\
//                            Summer Round  2001                              \\

//                            by Elias Pschernig                              \\

//                               www.irtc.org                                 \\

//  mail: elias@users.sourceforge.net             web: www.elias.f2s.com/pov  \\

// Knight's Hand Include File

#version unofficial megapov 0.7;

#macro T1() rotate R1 translate P #end
#macro T2() rotate R2 translate y * L1 T1() #end
#macro T3() rotate R3 translate y * L2 T2() #end
#macro T4() rotate R4 translate y * L3 T3() #end

#macro finger(P, L1, L2, L3, L4, R1, R2, R3, R4, R)

   cylinder { 0 y * L1 R material { m_metal } T1() }
   sphere   { 0 R material { m_metal } T1()}

   cylinder { 0 y * L2 R material { m_metal } T2() }
   sphere   { 0 R material { m_metal } T2()}

   cylinder { 0 y * L3 R material { m_metal } T3() }
   sphere   { 0 R material { m_metal } T3()}

   cylinder { 0 y * L4 R material { m_metal } T4() }
   sphere   { 0 R material { m_metal } T4()}

#end

#declare metalhand = union {

   finger(< .15, .0, 0>, 1.00, .40, .40, .40, z* 10, x*30, x*90, x*10, .15)
   finger(< .30, .0, 0>, 1.00, .45, .45, .45, z*  5, x*30, x*90, x*10, .15)
   finger(< .45, .0, 0>, 1.00, .50, .50, .50, z*  0, x*30, x*90, x*10, .15)
   finger(< .60, .0, 0>, 1.00, .45, .45, .45, z*- 5, x*30, x*90, x*10, .15)

   finger(< .20, .0, 0>, 0.70, .40, .30, .20, <50,0,50>, z*-10, z*-80, z*-10, .15)
}

/* POV-Ray Scene File for the Internet Raytracing Competition Summer 2001

 #macro C(X,Y)cylinder{X*x<X,0,-Y/2>.1}#end#macro U(R,X,Y)intersection{torus{.9
 .1}box{-1 0rotate y*R*90}translate<X,0,Y>scale 1-z*.5}#end union{U(0,0,0)U(1,0
 ,0)U(2,-1,-1)U(1,1,0)U(1,1.5,-3)U(1,2,0)U(3,1,0)U(2,2,0)U(0,3,0)U(3,2,.5)C(.1,
 2)C(.8,1)C(.8,-1)C(1.1,1)C(1.9,-1)pigment{rgb 10}rotate x*90translate<-1,0,4>}
 
created by Elias Pschernig elias@users.sourceforge.net*/  