//                                    7C                                      \\
//                                IRTC Entry                                  \\
//                            Summer Round  2001                              \\

//                            by Elias Pschernig                              \\

//                               www.irtc.org                                 \\

//  mail: elias@users.sourceforge.net             web: www.elias.f2s.com/pov  \\

// Spider Include File

#declare m_white = material {
   texture {
      pigment {
         color rgb <1,0,0>
      }
      finish {
         ambient 1
         diffuse 1
      }
   }
}

#declare m_black = material {
   texture {
      pigment {
         color rgb <0,0,0>
      }
      finish {
         ambient 1
         diffuse 1
      }
   }
}

#declare m_skin = material {
   texture {
      pigment {
         color rgb <.3,0,0>
      }
      finish {
         ambient 0
         diffuse .95
      }
   }
}

/*



                      .
                     .
                 Y2 .
                   o
                  /.\
                 / . \
          L1    /  .  \
               /  . A2 \
              /   .     \   L2
             /    .      \
            /    .  H     \
           /     .         \
          /  A1  .          \
      ...o.......  90       \
        0       ........   A3 \
            D1          .......o...
                  D           Y3
                        D2
*/

#declare L1 = 4;
#declare L2 = 6;

#declare X1 = 0;
#declare Y1 = 0;

#declare X3 = 5;
#declare Y3 = 3;

#declare _D = sqrt((X1 - X3) * (X1 - X3) + (Y1 - Y3) * (Y1 - Y3));
#declare _D1 = (L1 * L1 - L2 * L2 + _D * _D) / (2 * _D);
#declare _D2 = (L2 * L2 - L1 * L1 + _D * _D) / (2 * _D);
#if(X3 > X1)
   #declare _H = sqrt(L1 * L1 - _D1 * _D1);
#else
   #declare _H = -sqrt(L1 * L1 - _D1 * _D1);
#end

#declare _A1 = atan2(_H, _D1) * 180 / pi;
#declare _A3 = atan2(_H, _D2) * 180 / pi;
#declare _A2 = 180 - _A1 - _A3;
#if(X1 != X3)
   #declare _A0 = atan2(Y3 - Y1, X3 - X1) * 180 / pi;
#else
   #declare _A0 = 0;
#end

#declare A1 = _A0 - _A1;
#declare A2 = 180 - _A2;

#declare o_leg = union {

   union {
      cylinder {
         0
         z * L1
         .2
      }
      sphere {
         z * L1 .2
      }

   }

   union {
      cylinder {
         0
         z * L2
         .2
      }
      sphere {
         z * L2 .2
      }

      rotate x * A2
      translate z * L1

   }

   rotate x * A1

   material { m_skin }

}


#declare o_body = sphere {

   0 1
   material { m_skin }
}

#declare o_tail = sphere {

   0 1
   material { m_skin }
   translate z*-1
}

#declare o_eye = union {
   sphere {
      0 0.4
      material { m_white }
   }
   sphere {
      <0,0,.4> 0.3
      material { m_black }
   }
}

#declare o_head = union {

   sphere {
      0,1
      material { m_skin }
   }
   object {
      o_eye
      translate <cos(20*pi/180),0,sin(20*pi/180)>
   }
   object {
      o_eye
      translate <-cos(20*pi/180),0,sin(20*pi/180)>
   }
   translate z*1
}


#declare o_spider = union {

   object {
      o_body
   }

   object {
      o_leg
      translate z
      rotate y*35
   }
   object {
      o_leg
      translate z
      rotate y*-35
   }

   object {
      o_leg
      translate z
      rotate y*75
   }
   object {
      o_leg
      translate z
      rotate y*-75
   }

   object {
      o_leg
      translate z
      rotate y*105
   }
   object {
      o_leg
      translate z
      rotate y*-105
   }

   object {
      o_leg
      translate z
      rotate y*145
   }
   object {
      o_leg
      translate z
      rotate y*-145
   }


   object {
      o_head
      translate z*.8
      rotate x*-20
   }
   object {
      o_tail
      translate z*-.8
      rotate x*20
   }

}

/* POV-Ray Scene File for the Internet Raytracing Competition Summer 2001

 #macro C(X,Y)cylinder{X*x<X,0,-Y/2>.1}#end#macro U(R,X,Y)intersection{torus{.9
 .1}box{-1 0rotate y*R*90}translate<X,0,Y>scale 1-z*.5}#end union{U(0,0,0)U(1,0
 ,0)U(2,-1,-1)U(1,1,0)U(1,1.5,-3)U(1,2,0)U(3,1,0)U(2,2,0)U(0,3,0)U(3,2,.5)C(.1,
 2)C(.8,1)C(.8,-1)C(1.1,1)C(1.9,-1)pigment{rgb 10}rotate x*90translate<-1,0,4>}
 
created by Elias Pschernig elias@users.sourceforge.net*/  