//                                    7C                                      \\
//                                IRTC Entry                                  \\
//                            Summer Round  2001                              \\

//                            by Elias Pschernig                              \\

//                               www.irtc.org                                 \\

//  mail: elias@users.sourceforge.net             web: www.elias.f2s.com/pov  \\

// Wall Include File

#version unofficial MegaPov 0.7;

#debug "wall\n"

#local m_stone = material {
   texture {
      pigment {
         bumps
         color_map {
            [0 rgb <1.0, 0.9, 0.8>]
            [1 rgb <0.9, 0.7, 0.6>]
         }

      }
      finish {
         diffuse 0.6
         ambient 0.1
         specular 0.4
         roughness 0.05
      }
      normal {
         granite 1
         scale 0.5
      }
   }
}

#local Width = 80;
#local Height = 64;

#local TotalW = 20;
#local TotalH = 60;

#local P = array[Height][Width]
#local NORM = array[Height][Width]

#local M = 0;
#while(M < Height)

   #local N = 0;
   #while(N < Width)

      #local X = TotalW * N / Width;
      #local Y = TotalH * ((M / Height) ^ 0.3);
      #local Z = 0;

      // horizontal band
      #local Z = Z + 1.5 * ((1 - 2 * abs((Y / TotalH) - 0.8)) ^ 20);

      #local Z = Z + 1.5 * ((1 - 2 * abs((Y / TotalH) - 0.7)) ^ 16);

      // columns
      #local Z = Z - 2 * abs(sin(4 * pi * 2 * X / TotalW));

      #local V =  -eval_pattern(crackle, <X, Y, Z>);

      #local Z = Z + V;

      // Bottom
      #if(Y < 3)
         #local RelPos = <X, Y - 3, Z>;
         #set RelPos = vaxis_rotate(RelPos, x, RelPos.y * 30);
         #set X = RelPos.x;
         #set Y = RelPos.y + 3;
         #set Z = RelPos.z;
      #end

      // Top
      #if(Y > TotalH - 3)
         #local RelPos = <X, Y - (TotalH - 3), Z>;
         #set RelPos = vaxis_rotate(RelPos, x, RelPos.y * 30);
         #set X = RelPos.x;
         #set Y = RelPos.y + (TotalH - 3);
         #set Z = RelPos.z;
      #end

      // Right
      #if(X > TotalW - 3)
         #local RelPos = <X - (TotalW - 3), Y, Z>;
         #set RelPos = vaxis_rotate(RelPos, y, -RelPos.x * 30);
         #set X = RelPos.x + (TotalW - 3);
         #set Y = RelPos.y;
         #set Z = RelPos.z;
      #end

      #set X = X - TotalW / 2;

      #local P[M][N] = vrotate(<X, Y, Z> + z * TotalW * 8 / (2 * pi),
                               <0, (360 / 8) * X / TotalW, 0>)
                       - z * TotalW * 8 / (2 * pi);

      #set N = N + 1;
   #end

   #debug str(M, 0, 0)
   #debug "..vertex\r"

   #set M = M + 1;
#end

#debug "\n"

#macro Normal(Point, Point1, Point2)
   vcross(Point1 - Point, Point2 - Point)
#end

#declare M = 0;
#while(M < Height)
   #declare N = 0;
   #while(N < Width)

      #local NORM0 = <0, 0, 0>;

      #if(M < Height - 2 & N < Width - 2)
         #local NORM0 = NORM0 + Normal(P[M][N], P[M + 0][N + 1], P[M + 1][N + 0]);
      #end
      #if(M < Height - 2 & N > 0)
         #local NORM0 = NORM0 + Normal(P[M][N], P[M + 1][N + 0], P[M + 1][N - 1]);
      #end
      #if(M < Height - 2 & N > 0)
         #local NORM0 = NORM0 + Normal(P[M][N], P[M + 1][N - 1], P[M - 0][N - 1]);
      #end
      #if(M > 0 & N > 0)
         #local NORM0 = NORM0 + Normal(P[M][N], P[M - 0][N - 1], P[M - 1][N - 0]);
      #end
      #if(M > 0 & N < Width - 2)
         #local NORM0 = NORM0 + Normal(P[M][N], P[M - 1][N - 0], P[M - 1][N + 1]);
      #end
      #if(M > 0 & N < Width - 2)
         #local NORM0 = NORM0 + Normal(P[M][N], P[M - 1][N + 1], P[M + 0][N + 1]);
      #end

      #declare NORM[M][N] = NORM0;

      #set N = N + 1;
   #end

   #debug str(M, 0, 0)
   #debug "..normal\r"

   #set M = M + 1;
#end

#debug "\n"

#declare smooth_surface = mesh {
   #declare M = 0;
   #while(M < Height - 1)
      #declare N = 0;
      #while(N < Width - 1)
         smooth_triangle {
            P[M][N] NORM[M][N]
            P[M][N + 1] NORM[M][N + 1]
            P[M + 1][N] NORM[M + 1][N]
         }

         smooth_triangle {
            P[M + 1][N + 1] NORM[M + 1][N + 1]
            P[M + 1][N] NORM[M + 1][N]
            P[M][N + 1] NORM[M][N + 1]
         }

         #set N = N + 1;
      #end

      #debug str(M, 0, 0)
      #debug "..face\r"

      #set M = M + 1;
   #end
}

#debug "\n"

#declare wall = object {
   smooth_surface
   material { m_stone }
}

#debug "time used is "
#debug str(current_chrono, 0, 0)
#debug " ticks\n"   

/* POV-Ray Scene File for the Internet Raytracing Competition Summer 2001

 #macro C(X,Y)cylinder{X*x<X,0,-Y/2>.1}#end#macro U(R,X,Y)intersection{torus{.9
 .1}box{-1 0rotate y*R*90}translate<X,0,Y>scale 1-z*.5}#end union{U(0,0,0)U(1,0
 ,0)U(2,-1,-1)U(1,1,0)U(1,1.5,-3)U(1,2,0)U(3,1,0)U(2,2,0)U(0,3,0)U(3,2,.5)C(.1,
 2)C(.8,1)C(.8,-1)C(1.1,1)C(1.9,-1)pigment{rgb 10}rotate x*90translate<-1,0,4>}
 
created by Elias Pschernig elias@users.sourceforge.net*/  