/*

  "Alchemist Laboratory"
  
  Jaime Vives Piqueres, Aug-2001.
  
  Entry for the IRTC 07-08-2001, topic "Fantasy & Mystic".

*/
#version unofficial megapov 0.7;


// *** standard includes ***
#include "colors.inc"
#include "textures.inc"
#include "woods.inc"  
#include "skies.inc"
#include "stones.inc"
#include "metals.inc"

// *** custom generic includes ***
#include "meshlath.inc"
#include "i_macros.inc"

// *** control center ***
#declare test_glass    =0;
#declare use_camera    =0;
#declare use_test_text =0;
#declare use_room      =1;
#declare use_iscenery  =1;
#declare use_oldchair  =1;
#declare use_hourglass =1;
#declare use_stove     =1;
#declare use_tools     =1;
#declare use_boiler    =1;
#declare use_tamiz     =1;
#declare use_bucket    =1;
#declare use_bottles   =1;
#declare use_taburetes =1;
#declare use_books     =1;
#declare use_labware   =1;
#declare use_botijo    =1;
#declare use_vases     =1;
#declare use_cofre     =1;
#declare use_steps     =1;
#declare use_sticks    =1;
#declare use_cloth     =1;
#declare use_trunk     =1;
#declare use_firerests =1;
#declare use_firelight =1;
#declare use_candles   =1;
#declare use_candelight=0;
#declare use_testlight =0;
#declare use_faked_amb =1;
#declare use_arealight =1;
#declare use_radiosity =1;

// *** global settings ***
global_settings{
max_trace_level 64
#if (use_radiosity)
#include "i_radiosity.inc"
#end 
} 

// *** common declarations ***
#include "i_textures.inc"
#include "i_misc_obj.inc"
#declare fire_light_color=White*.35+Orange*.55+Red*.1;
#declare r_smk=seed(5632);

// *** lab room ***        
#if (use_room>0)
#include "i_labroom.inc"
object{lab_room
 translate 125*y
}
#declare atanor=
union{
 difference{
  superellipsoid{<.03,.03> scale .5 rotate 90*x scale <40,22,40>}
  box{-.5,.5 scale <40,22,40> scale .7}
  superellipsoid{<.2,.2> scale .5 rotate 90*x scale <15,10,41> translate <0,-11+5,0>}
  sphere{0,15 translate 11*y}
  texture{t_wall scale <.5,.5,1,> translate -60*y}
 }
 translate 11*y
}
object{atanor translate <-80,70.1,178>}
#end

// *** test light ***
#if (use_testlight)
light_source{
 <0,230,-200>
 (White*.27+Gold*.2)
 fade_distance 300
 fade_power 4
}
light_source{
 <0,230,0>
 (White*.27+Gold*.2)
 fade_distance 300
 fade_power 4
}
light_source{
 <0,230,-400>
 (White*.27+Gold*.2)
 fade_distance 300
 fade_power 4
}
#end


// *** inside scenery ***  
#if (use_iscenery)

// --- old chair, in the front of the left chimey ---
#if (use_oldchair)
#include "i_oldchair.inc"
object{old_chair(t_chair_wood,rand(seed(37)),use_test_text)
 scale 1.1
 rotate 50*y
 translate <-75,0,-140>
}
#end

// --- old stove, at right of background chimey ---
#if (use_stove)
#include "i_stove.inc"
object{stove
 translate <59,0,150>
}
#end

// --- boilers ---
#if (use_boiler)
#declare soft_boiler=0;
#include "i_boiler.inc"
// over the stove
object{boiler
 translate <57,87,152>
}
// at left foreground
object{boiler
 translate <-166,0,-288>
}
#end

// --- cubo ---
#if (use_bucket)
#include "i_cubo.inc"
// in fron of the background chimey
object{cubo scale .8
 translate <5,0,70>
}
#include "i_cubeta.inc"
// just before the bucket
object{cubeta scale 1.2
 rotate -86*x
 rotate 50*y
 translate <36,13.5,-50>
}
#end

// --- reloj arena ---
#if (use_hourglass)
#include "i_sandglass.inc"
// at left shelf
object{hourglass rotate 37*y
 translate <-180,71.5,-210>
}
// at right shelf
object{hourglass rotate 37*y
 translate <-182,71.5,-60>
}
#end

// --- candil ---
#if (use_candles)
#include "i_lamp.inc"
// on the chimey side
union{
 object{oil_lamp(rand(seed(56)),0)
  rotate 7*x
  rotate 4*z
 }
 object{clavo
  scale <4,10,4>
  rotate 90*x
  translate 7*y
 }
 translate <-180,130,-205>
}
#if (use_candelight)
// at right, out of view
#declare lamp_pos=<-55,77.1,141>;
union{
 object{oil_lamp(rand(seed(56)),1)}
 rotate 15*y
 translate lamp_pos
}
glow{
 type 1
 location lamp_pos
 size 1
 radius 100
 fade_power 1
 color Gold*.5+White*.5
}
#end
#end                    

// --- botellas ---
#if (use_bottles)
#include "i_bottles.inc"
// on the left foreground
object{bottle1
 translate <-182,.5,-209>
}
// at the right shelf
object{bottle1
 translate <-183,71.5,41>
}
object{bottle2
 translate <-184,71.5,31>
}
#end

// --- taburetes ---
#if (use_taburetes)
#include "i_taburete.inc"
// foreground, with open book
object{taburete
 rotate -27*y
 translate <-130,0,-230>
}
// background, with cloth
object{taburete2
 rotate 17*y
 translate <-32,0,55>
}
#end             

// --- books ---
#if (use_books)
#include "i_libro_abierto.inc"
#include "i_libros_cerrados.inc"
// on the left foreground
object{libro_abierto
 rotate -20*x
 rotate -91*y
 translate <-125,42.2,-234>
}
object{libro1
 scale <3,22,14> rotate 90*z rotate 90*y
 translate <-135,40.2,-234>
}
// at right background
object{libro_abiert2
 scale <1,2,1>
 rotate -29*x
 rotate 15*y
 translate <17,56,110>
}
// row of books at left shelf
object{books_row_01
 rotate 90*y
 translate <-179,31.5,-200.1>
}
// stack of books at left shelf
union{
object{libro3 scale <3,22,14> rotate 90*y rotate 180*y rotate 90*x rotate 3*y translate <-179,33,-269>}
object{libro1 scale <4,22,14> rotate 90*y rotate 180*y rotate 90*x rotate -4*y translate <-179,33+4,-267>}
object{libro2 scale <4,22,14> rotate 90*y rotate 90*x rotate 7*y translate <-179,33+4*2+1,-268>}
object{libro5 scale <1.8,22,14> rotate 90*y rotate 180*y rotate 90*x rotate 30*y translate <-179,33+4*2+4.5,-267>}
}
// stack of books at right shelf
union{
object{libro2 scale <3,21,13> rotate 90*y rotate 180*y rotate 90*x rotate 3*y translate <-179,33,-269>}
object{libro3 scale <4,21,13> rotate 90*y rotate 180*y rotate 90*x rotate -4*y translate <-179,33+4,-267>}
object{libro4 scale <4,21,13> rotate 90*y rotate 90*x rotate 7*y translate <-179,33+4*2,-268>}
 translate <2,40.1,228>
}
// row of books at right shelf
object{books_row_02
 rotate -90*y
 translate <-186,111.5,-99>
}
object{books_row_03
 rotate -90*y
 translate <-186,151.5,-99>
}
#end

// --- vases ---
#if (use_vases)
#include "i_vases.inc"
// left foreground
object{jarron1
 scale 1.8
 translate <-163,0,-257>
}
object{jarron2b
 translate <-156,0,-215>
}
// left background
object{jarron2
 scale <2,2.1,2>
 translate <-142,0,95>
}
object{jarron2b
 scale 2
translate <-140,60,165>
}
// at the right shelf
object{jarron1
 scale <.8,1,.8>
 translate <-177,151,31>
}
object{jarron2b
 scale <1,.6,1>
 translate <-179,111,10>
}
// right bkg
object{jarron2
 texture{
  pigment{DarkBrown filter 0.5}
  finish{Phong_Shiny}
 }
 scale <1,2.3,1>
 translate <11,50,164>
}
object{jarron1b
 texture{
  pigment{Copper filter 0.3}
  finish{Metal}
 }
 scale <1.1,.9,1.1>
 scale 1.2
 translate <1,50,152>
}
// backg shelv
object{jarron2b
 texture{pigment{SteelBlue filter .5} finish{Phong_Glossy}}
 scale <1.5,1,1.5>
 translate <-151,110.1,187>
}
// atanor
union{
 object{vasija
  scale 2
 }
 union{
  intersection{
   difference{
    sphere{0,1}
    sphere{0,.95}
    cylinder{<.9,0,0>,<1.1,0,0>,.4}
   }
   plane{y,0 inverse}
  }
  difference{
   cylinder{<0,0,0>,<0,-1,0>,1}
   cylinder{<0,.1,0>,<0,-1.1,0>,.95}
  }
  torus{1,.1 translate -1*y}
  intersection{
   cone{<0,.5,0>,.4,<2.9,-1.4,0>,.1}
   plane{x,1 inverse}
  }
  scale 8
  texture{
   pigment{SeaGreen*.5+Yellow*.2+Gray10 filter 0.9 transmit .1}
   finish{Glass_Finish caustics 3}
  }
  translate 37*y
 }
 translate <-80,80,178>
}
// on the left upper shelf
#include "i_bol1.inc"
object{bol_1
 scale .5
 texture{T_Stone11}
 translate <-180,71.5,-329>
}
// on the left bkg
object{bol_1
 scale <.9,.5,.9>
 texture{Brass_Metal}
 translate <-169,60,155>
}
object{bol_1
 scale <.7,1.5,.7>
 texture{Silver_Metal
  normal{bumps .1 scale 4}
 }
 translate <-131,110.1,186>
}
object{bol_1
 scale <.25,1.4,.25>
 texture{Chrome_Metal
  normal{dents .1 scale 4}
 }
 translate <-166,110.1,188>
}
object{bol_1
 scale <.25,1.1,.25>
 texture{Chrome_Metal
  normal{dents .1 scale 4}
 }
 translate <-173,110.1,185>
}
object{bol_1
 scale <.25,.8,.25>
 texture{Chrome_Metal
  normal{dents .1 scale 4}
 }
 translate <-181,110.1,186>
}
object{bol_1
  scale <1.1,.5,1.1>
  texture{
   pigment{Tan*.75+Firebrick*.25}
   finish{Shiny reflection .1}
  }
 translate <-136,0.1,-265>
}
// over left fire
union{
 object{jarron1b
  rotate 95*y
  scale <1.1,.9,1.1>
  scale 1.1
 }
 object{soporte_metal rotate 38*y scale 1.6}
 object{chimey_smoke(10,.5,12,White,Gold,1,<-.5,0,0>,.1,.8,r_smk) translate 4*y}
 translate <-175,80,-155>
}
#end

// --- tools ---
#if (use_tools)
#include "i_tools.inc"
object{martillo_1 scale 1.1 rotate 90*x rotate 15*y
 translate <-128,71.5,-155>
}
object{martillo_2 scale 1.1 rotate 90*x rotate -132*y
 translate <-100,55+15+6,55>
}
object{pinzas
 scale 1.5
 rotate -90*y
 translate <-140,70.6,-160>
}
object{alicates
 scale 1.5
 rotate 0*y
 rotate -4*x
 translate <-150,71.7,-170>
}
object{pinzas
 scale <1,1,3>
 rotate -90*x
 translate <-14,25,100>
}
object{tenazas
 scale <2,2,2>
 rotate -34*y
 translate <-50,71.7,155>
}
#end

// *** fires ***
#if ((use_firelight) | (use_firerests))
#include "i_fires.inc"
#end
#if (use_firelight)
object{fire
 translate <-175,70.1,-155>
}
object{fire
 translate <-80,70.1,178>
}
#end
#if (use_firerests)
object{fire_rests
 translate <-60,1.5,158>
}
object{materia_prima
 scale 2
 rotate <-30,50,0>
 translate <5,4,-20-50>
}
#end

// --- probetas ---
#if (use_labware)
#include "i_botes.inc"
#declare r_pot=seed(264);
//object{matraz2b scale 2 translate <-80,80,178>}
object{matraz2 scale 1.8 rotate 49*z translate <-30,83,178>}
intersection{
 sphere{0,7}
 plane{y,0}
 texture{Ruby_Glass finish{caustics 4}}
 translate <-36,90,178>
}
object{soporte_metal rotate 84*y scale 1.9 translate <-36,81,178>}
object{matraz1 scale 1.7 translate <1,50,178>}
object{matraz1 scale 2 translate <-133,60,178>}
object{matraz1 scale <3,2.5,3> translate <-163,60,178>}
object{matraz1 scale 1 translate <-183,70.1,-220>}
object{matraz1 scale 1 translate <-181,70.1,-235>}
object{matraz1 scale 1 translate <-183,71.5,-73>}
object{matraz1 scale 1 translate <-182,71.5,-86>}
object{pot01 rotate (170+25*rand(r_pot))*y translate <-185,71.5,21>}
object{pot01b rotate (175+15*rand(r_pot))*y translate <-183,71.5,11>}
object{pot02 rotate (165+35*rand(r_pot))*y translate <-186,71.5,2>}
object{pot02b rotate (175+15*rand(r_pot))*y translate <-184,71.5,-10>}
object{pot02 rotate (175+15*rand(r_pot))*y translate <-183,71.5,-19>}
object{pot01 rotate (175+25*rand(r_pot))*y translate <-185,151.5,31>}
object{pot01b rotate (165+25*rand(r_pot))*y translate <-183,151.5,21>}
object{pot01 rotate (175+15*rand(r_pot))*y translate <-185,151.5,12>}
object{pot01b rotate (175+15*rand(r_pot))*y translate <-183,151.5,-1>}
object{pot02 rotate (175+25*rand(r_pot))*y translate <-185,151.5,-11>}
object{pot02b rotate (165+35*rand(r_pot))*y translate <-183,151.5,-20>}
object{pot02 rotate (175+15*rand(r_pot))*y translate <-185,151.5,-29>}
object{garrafa scale 2 translate <-163,0,-230>}
object{pot01 rotate 186*y translate <-184,31.5,-289>}
object{pot01b rotate 193*y translate <-183,31.5,-300>}
object{pot02 rotate 188*y translate <-185,31.5,-312>}
object{pot03 rotate 360*rand(r_pot)*y translate <-183,31.5,-331>}
object{pot01 rotate (175+15*rand(r_pot))*y translate <-185,.5,-309>}
object{pot01b rotate (175+25*rand(r_pot))*y translate <-183,.5,-329>}
object{pot02 rotate (175+15*rand(r_pot))*y translate <-186,.5,-340>}
object{pot03 rotate 360*rand(r_pot)*y translate <-184,.5,-289>}
object{pot01 rotate (165+35*rand(r_pot))*y translate <-183,.5,-300>}
object{pot01b rotate (175+25*rand(r_pot))*y translate <-185,.5,-312>}
object{pot02b rotate (175+15*rand(r_pot))*y translate <-183,.5,-331>}
// backg shelves
object{pot01
 texture{pigment{Gray filter .5} finish{Metal}}
 scale <2,.8,2> rotate (-10+20*rand(r_pot))*y translate <-155,151.5,185>
}
object{pot01b
 texture{pigment{Gold filter .5} finish{Metal}}
 scale <2.9,1,1.9> translate <-177,151.5,186>
}
// vasos
object{vaso1
 texture{pigment{Flesh}
   normal{granite scale 1}
}
 texture{
  pigment{
   bozo turbulence .2
   color_map{
    [0 Clear]
    [0.1 Clear]
    [1 DkGreenCopper]
   }
  }
  scale 16
 }
 translate <-140,70.1,-140>
}
object{vaso1
 scale <.9,.7,.8>
 texture{pigment{Wheat}
  normal{granite scale 1}
 }
 texture{
  pigment{
   bozo turbulence .2
   color_map{
    [0 Clear]
    [0.1 Clear]
    [1 DkGreenCopper]
   }
  }
  scale 16
 }
 translate <-137,70.1,-134>
}
object{vaso1
 scale <2,.4,2>
 texture{pigment{Thistle}
  normal{granite scale 1}
 }
 texture{
  pigment{
   bozo turbulence .2
   color_map{
    [0 Clear]
    [0.1 Clear]
    [1 DkGreenCopper]
   }
  }
  scale 16
 }
 translate <-29,70.1,150>
}
object{vaso1
 texture{pigment{Tan*.5+White*.5}
  normal{granite scale 1}
 }
 texture{
  pigment{
   bozo turbulence .2
   color_map{
    [0 Clear]
    [0.1 Clear]
    [1 DkGreenCopper]
   }
  }
  scale 16
 }
 translate <-65,70.1,145>
}
#end

// *** botijo (...perhaps this alchemist was spanish?) ***
#if (use_botijo)
#include "i_botijo.inc"
object{botijo
 scale .3
 texture{
  pigment{Flesh}
  normal{granite}
 }
 translate <-150,0,65>
}
#end

// *** cofre ***
#if (use_cofre)
#declare m_largo=22
#declare m_corto=15
#declare m_alto=10
#declare m_grueso=1.5
#declare m_esq=m_grueso*2
#declare r1=seed(668)
#declare r_sucio=seed(666)
#declare t_sucio=
texture{
 pigment{
  bozo
  turbulence 0.7
  color_map{
   [0 color Clear]
   [0.3 color Clear]
   [1 color DarkTan]
  }
  scale <50,100,50>
 }
}
#declare t_madera=
texture{
 T_Wood15 scale 6
 finish{Metal reflection 0.05}
}
#declare t_metal=
texture{
 Bronze_Texture normal{dents}
}
texture{t_sucio translate 100*rand(r_sucio)}
#include "i_cofre.inc"
object{cofre
 scale .8
 rotate -92*y
 translate <-178,m_grueso*2+m_alto*0.5+107,-10>
}
#end

// --- cloths ---
#if (use_cloth)
#include "i_nappe.inc"
object{Nappe
 scale 60
 rotate -40*y
 rotate 17*y
 translate <-32,-6.5,44.5>
}
#end

// --- step ---
#if (use_steps)
#declare rds=seed(9236);
#declare t_madera=texture{T_Wood13}
#macro plain_board(xs,ys,zs,r_wood)
superellipsoid{ <.1,.1> rotate 90*x
 scale <xs,ys,zs>
}
#end
#declare woodstep=
union{
 object{plain_board(1,50,5,rds)
  texture{
   t_madera
   rotate 90*x
   scale 10
   translate 100*rand(rds)
  }
  translate -10*x
 }
 object{plain_board(1,50,5,rds)
  texture{
   t_madera
   rotate 90*x
   scale 10
   translate 100*rand(rds)
  }
  translate 10*x
 }
 #declare cnt=2;
 #while (cnt<=10)
 object{plain_board(10,.8,4,rds)
  texture{
   t_madera
   rotate 90*y
   scale 10
   translate 100*rand(rds)
  }
  rotate -20*x
  translate (-50+10*(cnt-1))*y
 }
 #declare cnt=cnt+1;
 #end
}
object{woodstep
 scale <1.2,1.5,.5>
 rotate 30*x
 rotate -90*y
 translate <-151,66,100>
}
#end

#if (use_sticks)
#declare stick1=
union{
 cone{<0,0,0>,4,<0,40,0>,2}
 sphere{0,1 scale <3,1.5,3> translate 40*y}
 texture{T_Wood11}
}
object{stick1 scale .6 rotate <20,40,0> translate <-166,0,-288>}
#declare stick2=
union{
 cone{<0,0,0>,3,<0,14,0>,1}
 sphere{0,1 scale <2,1,2> translate 14*y}
 texture{T_Wood13 rotate 90*x scale 4}
}
object{stick2 scale .6 rotate <20,-40,0>  translate <-180,74,-326>}
#end

#if (use_tamiz)
#declare tamiz=
union{
 difference{
  cylinder{<0,0,0>,<0,5,0>,15}
  cylinder{<0,-.1,0>,<0,5.1,0>,14}
  texture{T_Wood7 rotate 90*y scale 4}
 }
 height_field{
  png "hf_tamiz.png"
  water_level .1
  translate -.5
  scale <31,.1,31>
  texture{T_Chrome_3C}
 }
}
object{tamiz
 rotate <-28,-12,9>
 translate <-136,8.5,-260>
}
#end

#if (use_trunk)
#include "i_trunk.inc"
object{trunk(20,55,seed(92))
 translate <-110,0,50>
}
union{
 superellipsoid{<.1,.1> scale .5 rotate 90*x scale <39,20,19>}
 difference{
  box{-.5,.5 scale <44,5,24>}
  cylinder{<-22.1,0,-12>,<22.1,0,-12>,2.6}
  cylinder{<-22.1,0,12>,<22.1,0,12>,2.6}
  cylinder{<22,0,-12.1>,<22,0,12.1>,2.6}
  cylinder{<-22,0,-12.1>,<-22,0,12.1>,2.6}
  translate -12.5*y
 }
 cone{<18,2.1,0>,8,<35,2.1,0>,.01}
 cone{<-18,2.1,0>,8,<-35,2.1,0>,.01}
 rotate 140*y
 texture{
  pigment{Brass*.3}
  normal{
   bozo turbulence .5
   normal_map{
   [0.0 granite 1 scale 1]
   [0.2 granite 1 scale .5]
   [0.4 crackle scale 1 turbulence .3]
   [1.0 crackle scale 1 turbulence .3]
   }
   scale 4
  }
  finish{F_MetalB phong 1}
 }
 texture{
  pigment{
   gradient y turbulence .3
   color_map{
    [0 Clear]
    [0.1 Clear]
    [1 Orange filter .5]
   }
  }
  normal{granite}
  scale <1.5,25,1.5>
  translate -10*y
 }
 scale .8
 translate <-110,55+12,50>
}
#end

#end // indoor scenery


// *** outside scenery ***

// --- sky sphere ---
sphere{0,1
 hollow
 pigment{SummerSky*.6+White*.4}
 scale 100000
}
light_source{
 0
 (White+Gold*.3)
 fade_distance 10000000
 fade_power 2
 translate <0,99999,0>
 rotate -20*z
}
plane{y,-10 pigment{Flesh}}
#include "i_house_ceil.inc"
union{
 object{house_ceil
  rotate 60*x translate <0,0,110>
 }
 object{house_ceil
  rotate 60*x
  rotate 180*y
  translate <0,0,130+250>
 }
 object{ceil_basement translate -327*y}
 translate <-700,100,200>
}

// -- faked sunlight ambient --
#if (use_faked_amb)
#declare k=(White+Gold*.2);
#declare fdp=2;
#declare fdd=256;
light_source{
 0
 k*.4
 #if (use_arealight)
   area_light <0,90,0>,<0,0,60>,12,8 jitter adaptive 1
 #end
 fade_distance fdd
 fade_power fdp
 media_interaction off
 translate <-189,120,-270>
}
light_source{
 0
 k*.4
 #if (use_arealight)
   area_light <0,90,0>,<60,0,0>,12,8 jitter adaptive 1
 #end
 fade_distance fdd
 fade_power fdp
 media_interaction off
 translate <-189,120,-270>
}
light_source{
 0
 k*.4
 #if (use_arealight)
   area_light <90,0,0>,<0,0,60>,12,8 jitter adaptive 1
 #end
 fade_distance fdd
 fade_power fdp
 media_interaction off
 translate <-189,120,-270>
}
light_source{
 0
 k*1.3
 area_light <0,12,0>,<0,0,12>,12,8 jitter adaptive 1
 fade_distance fdd*.5
 fade_power fdp
 media_interaction off
 translate <-220,125,-270>
}
#end


// *** camera *** 
#include "i_camera.inc"
camera{
 location camera_from
 direction camera_zoom
 look_at camera_look
}




